package webservice

// MiGo extraction module (v1).
// This uses dingo-hunter MiGo extraction.

import (
	"encoding/json"
	"io/ioutil"
	"log"
	"net/http"

	"github.com/nickng/dingo-hunter/migoextract"
	"github.com/nickng/dingo-hunter/ssabuilder"
)

func initMigoV1() {
	http.HandleFunc("/migo.v1", migoV1Handler)
}

func migoV1Handler(w http.ResponseWriter, req *http.Request) {
	b, err := ioutil.ReadAll(req.Body)
	if err != nil {
		NewErrInternal(err, "Cannot read input Go source code").Report(w)
		return
	}
	req.Body.Close()
	conf, err := ssabuilder.NewConfigFromString(string(b))
	if err != nil {
		NewErrInternal(err, "Cannot initialise SSA").Report(w)
		return
	}
	info, err := conf.Build()
	if err != nil {
		NewErrInternal(err, "Cannot build SSA").Report(w)
		return
	}
	extract, err := migoextract.New(info, ioutil.Discard)
	go extract.Run()

	select {
	case <-extract.Error:
		NewErrInternal(err, "MiGo type inference failed").Report(w)
		return
	case <-extract.Done:
		log.Println("MiGo: analysis completed in", extract.Time)
		extract.Env.MigoProg.CleanUp()
	}

	reply := struct {
		MiGo string `json:"MiGo"`
		Time string `json:"time"`
	}{
		MiGo: extract.Env.MigoProg.String(),
		Time: extract.Time.String(),
	}
	json.NewEncoder(w).Encode(&reply)
}
