// Code generated by Wire. DO NOT EDIT.

//go:generate go run -mod=mod github.com/google/wire/cmd/wire
//go:build !wireinject
// +build !wireinject

package wire

import (
	"PandoraHelper/internal/handler"
	"PandoraHelper/internal/middleware"
	"PandoraHelper/internal/repository"
	"PandoraHelper/internal/server"
	"PandoraHelper/internal/service"
	"PandoraHelper/pkg/app"
	"PandoraHelper/pkg/jwt"
	"PandoraHelper/pkg/log"
	server2 "PandoraHelper/pkg/server"
	"PandoraHelper/pkg/server/http"
	"PandoraHelper/pkg/server/reverse/chatgpt"
	"PandoraHelper/pkg/server/reverse/claude"
	"PandoraHelper/pkg/sid"
	"github.com/google/wire"
	"github.com/spf13/viper"
)

// Injectors from wire.go:

func NewWire(viperViper *viper.Viper, logger *log.Logger) (*app.App, func(), error) {
	jwtJWT := jwt.NewJwt(viperViper)
	handlerHandler := handler.NewHandler(logger)
	db := repository.NewDB(viperViper, logger)
	repositoryRepository := repository.NewRepository(logger, db)
	transaction := repository.NewTransaction(repositoryRepository)
	sidSid := sid.NewSid()
	serviceService := service.NewService(transaction, logger, sidSid, jwtJWT)
	userService := service.NewUserService(serviceService, viperViper)
	userHandler := handler.NewUserHandler(handlerHandler, userService, viperViper)
	shareRepository := repository.NewShareRepository(repositoryRepository)
	accountRepository := repository.NewAccountRepository(repositoryRepository)
	coordinator := service.NewServiceCoordinator(serviceService, accountRepository, shareRepository, viperViper)
	shareService := service.NewShareService(serviceService, shareRepository, viperViper, coordinator)
	shareHandler := handler.NewShareHandler(handlerHandler, shareService)
	accountService := service.NewAccountService(serviceService, accountRepository, viperViper, coordinator)
	accountHandler := handler.NewAccountHandler(handlerHandler, accountService)
	healthCheckHandler := handler.NewHealthCheckHandler()
	httpServer := server.NewHTTPServer(logger, viperViper, jwtJWT, userHandler, shareHandler, accountHandler, healthCheckHandler)
	job := server.NewJob(logger)
	task := server.NewTask(viperViper, logger, accountService, shareService)
	migrate := server.NewMigrate(db, logger)
	conversationRepository := repository.NewConversationRepository(repositoryRepository)
	conversationLoggerMiddleware := middleware.NewConversationLoggerMiddleware(logger, conversationRepository)
	chatgptServer := server.NewChatGPTReverseProxyServer(logger, viperViper, conversationLoggerMiddleware)
	claudeServer := server.NewClaudeReverseProxyServer(logger, viperViper, conversationLoggerMiddleware)
	appApp := newApp(viperViper, httpServer, job, task, migrate, chatgptServer, claudeServer)
	return appApp, func() {
	}, nil
}

// wire.go:

var repositorySet = wire.NewSet(repository.NewDB, repository.NewRepository, repository.NewTransaction, repository.NewAccountRepository, repository.NewShareRepository, repository.NewConversationRepository)

var serviceCoordinatorSet = wire.NewSet(service.NewServiceCoordinator)

var serviceSet = wire.NewSet(service.NewService, service.NewUserService, serviceCoordinatorSet, service.NewAccountService, service.NewShareService, server.NewTask)

var migrateSet = wire.NewSet(server.NewMigrate)

var handlerSet = wire.NewSet(handler.NewHandler, handler.NewUserHandler, handler.NewShareHandler, handler.NewAccountHandler, handler.NewHealthCheckHandler)

var serverSet = wire.NewSet(server.NewHTTPServer, server.NewChatGPTReverseProxyServer, server.NewClaudeReverseProxyServer, server.NewJob)

// build App
func newApp(conf *viper.Viper, httpServer *http.Server, job *server.Job, task *server.Task, migrate *server.Migrate, gptServer *chatgpt.Server, claudeServer *claude.Server) *app.App {
	servers := []server2.Server{
		httpServer,
		job,
		task,
		migrate,
	}
	if conf.GetBool("http.proxy-pass.oaifree.enable") {
		servers = append(servers, gptServer)
	}
	if conf.GetBool("http.proxy-pass.fuclaude.enable") {
		servers = append(servers, claudeServer)
	}
	return app.NewApp(app.WithServer(servers...), app.WithName("demo-server"))
}
