## Extracting Key Information from Research Papers using PAPERSNAP and Claude

Welcome to the **PAPERSNAP** repository! Our primary goal is to facilitate the extraction of crucial information from research papers and organize it into a comprehensive mind map. To achieve this, we leverage a powerful language model named Claude, which has the capability to handle documents with up to 100,000 tokens.

### How to Use PAPERSNAP prompt:
#### Using Poe
1. **Create an Account:** To get started, you'll need to have an account on [Poe](https://poe.com).

2. **Use PAPERSNAP bot:** [https://poe.com/PAPERSNAP](https://poe.com/PAPERSNAP)

3. **Upload Your Paper:** Prepare the research paper you want to extract information from. You can either upload the paper as a PDF or copy and paste its text directly into poe's interface.

4. **Generate the Mind Map:** After providing the necessary input, let PAPERSNAP bot work its magic! It will process the paper and generate a mind map containing the most important information in markdown.

5. **View the Result:** Once PAPERSNAP bot has completed its analysis, you will be presented with the mind map in markdown. To visualize and explore this mind map in a user-friendly format, we recommend using [Markmap](https://markmap.js.org/repl).


#### Using Claude
1. **Create an Account:** To get started, you'll need to have an account on [Claude](https://claude.ai/). If you don't have one already, sign up—it's free and easy (USA,UK)!

2. **Upload Your Paper:** Prepare the research paper you want to extract information from. You can either upload the paper as a PDF or copy and paste its text directly into Claude's interface.

3. **Set Up PAPERSNAP Prompt:** Within Claude, paste PAPERSNAP prompt. This prompt has been optimized to guide Claude in extracting key information effectively.

4. **Generate the Mind Map:** After providing the necessary input, let Claude work its magic! It will process the paper and generate a mind map containing the most important information in markdown.

5. **View the Result:** Once Claude has completed its analysis, you will be presented with the mind map in markdown. To visualize and explore this mind map in a user-friendly format, we recommend using [Markmap](https://markmap.js.org/repl).



### Why Use PAPERSNAP:

- **Efficiency:** Extracting essential details from research papers can be time-consuming. PAPERSNAP automates this process, saving you valuable time and effort.

- **Comprehensiveness:** The mind map generated by PAPERSNAP provides a comprehensive overview of the research paper's key concepts, findings, and insights.

- **Simplicity:** By utilizing PAPERSNAP and Claude, you can quickly distill complex research papers into easy-to-understand visual representations.


We believe that PAPERSNAP coupled with Claude offers an innovative approach to enhancing research paper analysis. Feel free to explore our repository, follow the steps outlined above, and discover how PAPERSNAP can streamline your research process.

For any inquiries, feedback, or support, don't hesitate to reach us. 

Happy paper analysis and mind mapping!


https://github.com/nhaouari/papersnap/assets/9850722/d288474f-e050-4153-9cf8-b5f3ef8822e1




## PAPERSNAPV1 Prompt
```md
Extract the following information from the paper :

# PAPERSNAPv1: {Exact title of the research paper} 
## 🎓 Citation Information:
- Author(s): Name all authors in sequence.

- Title: Exact title of the research paper.

- Journal/Source: Specific journal, volume, and issue or other publication source.

- Publication Year: Year the paper was published.

- Pages: Range of pages or article number.

- DOI/URL: Direct link or unique identifier.

- Affiliation: Mention the institutions or organizations the authors are affiliated with. 

## 🌌 Contextual Insight:
* In a Sentence: Condense the abstract into a single, easily understandable sentence.
* Keywords: List key terms that frequently appear in the abstract and might be central to the paper's theme.
- Gap/Need: Define the existing gap or need that the paper addresses. Detail how the research fits or contrasts within the broader academic landscape.
- Novelty: How does this research stand out from existing works? What's new or innovative about the methods, results, or conclusions?
- Target Audience: Who would benefit most from this research? Academics, industry professionals, policymakers, or the general public?
- Jargon Density: Was the paper heavy on jargon, or was it relatively easy to understand?
- Recommendation: Would you recommend this paper to a novice, an intermediate reader, or only to experts in the field?

## 🧭 Purpose/Objective:

- Goal: Explicitly state the paper's primary aim or objective.

- Research Questions/Hypotheses: Clearly list the central research questions or hypotheses.

- Significance: Why did the authors feel this research was necessary? What larger issues does it hope to address or solve?

## 🎓 Background Knowledge:
- Core Concepts: List foundational concepts that the paper frequently references or assumes the reader knows. Define them succinctly.

- Preliminary Theories: Highlight any theories or models that the research paper builds upon or critiques. Provide a brief description of each.

* Contextual Timeline: Provide a brief timeline of the major developments in the field leading up to the current paper, helping readers to understand the chronological evolution.

- Prior Research: Point out significant previous studies that paved the way for this paper. Mention their primary findings and relevance.

- Terminology: List any specialized terms or jargons used in the paper, and provid clear definitions for each.

- Essential Context: Sometimes, external events, trends, or shifts in the field can influence a paper. Mention any such context that would help a reader better understand the paper's motivations or implications.

## 📝 Methodology:
- Research Design & Rationale: Outlines step by step  type, implications, and the reasoning behind design choices.

- Participants/Subjects: Describe step by step sample size, demographics, and selection criteria.

- Instruments/Tools: Note step by step instruments, datasets or tools utilized, detailing their validity and reliability.

- Data Collection: Describe step by step the process, locations, duration, and controls during data gathering.

- Data Analysis Techniques: Explain step by step  the techniques, software, and rationale.

- Ethical Considerations: Highlight step by step any ethical aspects and resolutions.
- Comparison to Standard: Does the methodology adhere to standard practices in the field? If it deviates, how and why?
- Replicability Score: On a scale of 1-10, how easy would it be for another researcher to replicate the study based on the provided methodology?

## 📊 Main Results/Findings:
- List of metrics: list for each metric: definition, importance, implications, and contextual relevance.
- Graphs/Tables: Highlight any key graphs, figures, or tables that provide a significant understanding of the results. Provide a brief description of each.
- Outcomes: List primary outcomes or findings figures and tables.
- Data & Code Availability: Indicate whether the paper provides access to the data and code, which is essential for reproducibility and further research.
- Statistical Significance: Highlight if the findings were statistically significant and any p-values associated.
- Unintended Findings: Sometimes, research can produce unexpected results. Mention these serendipitous discoveries.
## 🔄 Discussion & Interpretation:
- Authors' Views: Examine the authors' interpretations and implications.
- Comparative Analysis: How do the authors' interpretations compare to previous work or general beliefs in the field?
- Contradictions: Are there any points in the discussion that seem to contradict earlier sections or external research?
## ❌ Limitations:
- List: Mention any study weaknesses, constraints, and biases.
- Mitigations: If the authors mention limitations, do they also suggest ways they tried to mitigate or account for these limitations?

## 🖋️ Conclusions:
- Takeaways: Extract core conclusions and emergent themes.
- Practical Implications: Beyond academic impact, how does the paper suggest its findings could be applied in practice?
* Potential Impact: If these future works were pursued, what potential impact could they have on the field or real-world applications?
## 🚀 Future Work:
- Authors' Proposals: Highlight the avenues for further research or follow-up studies as suggested specifically by the authors.

## 📚 References:
- Notable Citations: Highlight crucial references related to the paper's content or the reader's interest.

## 🎯 Relevance:
- Significance: Describe how the paper relates to current trends or personal trajectories.
- Real-world Implications: How can the research be applied in real-world situations or industries?


## 🌐 Textual Mind Map:
List all sections from the research paper. This will serve as the main branches of your mind map. In each section extract:

- Central Ideas: Under each section, pinpoint the predominant ideas. These will form the sub-branches connected to the main branches.

- Significant Facts: Identify standout facts within the sections that are crucial or unexpected.

- Key Arguments: Extract and list pivotal arguments presented within each section, particularly those central to the paper's primary thesis.

- Interconnections: Highlight connections between various ideas, facts, or arguments across sections, showcasing the integrative nature of the paper.

## 🌟 Key Quotes:
- list significant statements or sentences that encapsulate crucial points or findings of the paper.

## 🧠 Personal Insights/Comments:
- Opinions: Critique, praise, raise questions, or cross-reference with other known papers or information.
 

Use markdown for a clear, hierarchical representation, employing bullet points, highlight verbs interesting concepts in bold (`**bold text**`), and italic (`*italic text*`) as needed. keep icons and sections as defined.
```
