# Swim!!
A small game built with Delphi + FMX + Skia4Delphi

## Intro

Taking on the role of a fish, you have to be vigilant for obstacles that include larger predators, poisonous jelly fish, aggressive sharks, hungry fishermen awaiting crispy fried fish fillets for dinner, and naval mines that are gonna tear you apart.

Always check the numbers that are going backwards in the green circle at the top right corner. It shows how much energy you have. Low energy? Not a big deal! Boost your energy by munching smaller fish. As smaller fish are eaten, you grow in size and become capable of eating larger fish.

Don’t forget to collect as many collect coins as you can along the way. The more coins you collect, the higher score you gain. Once you have collected 100 gold coins, wait for a miracle to happen.

Have fun!!

## Video

[Click to open Youtube](https://youtu.be/KVNRi83yYQA)

[![Watch the video](https://img.youtube.com/vi/KVNRi83yYQA/maxresdefault.jpg)](https://youtu.be/KVNRi83yYQA)


## Screenshots

![Screenshot1](https://user-images.githubusercontent.com/28640848/171116605-3c1bebe8-5c3d-4d16-b322-987998f008b1.png)
![Screenshot2](https://user-images.githubusercontent.com/28640848/171116615-50aa52a7-35ea-4a08-99c3-e301dcc5b352.png)
![Screenshot3](https://user-images.githubusercontent.com/28640848/171116622-7f8318c0-f9b1-4c84-88e6-610d3c3e3b50.png)
![Screenshot4](https://user-images.githubusercontent.com/28640848/171116631-fbe07a52-0b3f-455b-8d9d-4a104020344e.png)

## How to play
Simply, move the fish around to eat smaller fish.

## Why I chose [Delphi](https://www.embarcadero.com/products/delphi) + FMX + Skia4Delphi
1. Object Pascal is a neat language. It is very easy to learn.
2. Rapid application development: I could get the UI of the application quickly. In some cases, I don't need to write any single line of code for my application.
3. Cross platform
4. FMX make graphic development easily. I could get the effects on application by drop some components.
5. [Skia4Delphi](https://github.com/skia4delphi/skia4delphi) makes the app runs smoothly on Android. There is a contest for now, you could find more information from [here](https://blogs.embarcadero.com/skia4delphi-gui-beauty-contest/).

## How to build the game
1. Clone this repository
2. Open ```Swim.dpr``` or ```Swim.dproj```
3. From Delphi IDE, press ```F9``` to run the game or ```SHIFT + F9``` to build the game.
4. If you are building the game for Windows, copy ```MP3``` folder to the folder where contains ```swim.exe```
5. Optional step: Install the fonts in ```Fonts``` folder before running the game

## Download:
[Click here to download the game for Windows](https://github.com/nglthach/Swim/releases/download/v1.0/Swim_Win32.zip)


## Special thank you to
www.freepik.com

www.freesound.org

www.fleamedia.com
