# Generated by Django 5.0.3 on 2024-09-18 17:26

# add colors with sub items background, accent and text
# rename details-username to details-primary
# rename details-pronouns to details-secondary

from django.db import migrations

def migrate_json_data(apps, schema_editor):
    Card = apps.get_model('main', 'Card')
    for obj in Card.objects.all():
        obj_json = obj.data
        
        if obj_json:
            obj_json["version"] = 3

            color_data = {
                "background": "#ffffff",
                "accent": "#000000",
                "text": "#000000"
            }

            obj_json["colors"] = color_data

            username = obj_json["details"]["username"]
            pronouns = obj_json["details"]["pronouns"]

            obj_json["details"]["primary"] = username
            obj_json["details"]["secondary"] = pronouns

            del obj_json["details"]["username"]
            del obj_json["details"]["pronouns"]

            obj.data = obj_json
            obj.save()

class Migration(migrations.Migration):

    dependencies = [
        ('main', '0011_migrate_card_v1_to_v2'),
    ]

    operations = [
        migrations.RunPython(migrate_json_data)
    ]
