# Generated by Django 5.0.3 on 2024-09-17 22:07

from django.db import migrations

def migrate_json_data(apps, schema_editor):
    Card = apps.get_model('main', 'Card')
    for obj in Card.objects.all():
        obj_json = obj.data
        
        if obj_json:
            obj_json["version"] = 2

            items = obj_json["information"]["items"]

            if items:
                for item in range(len(items)):
                    items[item]["position"] = item

            obj.data = obj_json
            obj.save()

class Migration(migrations.Migration):

    dependencies = [
        ('main', '0010_migrate_card_v0_to_v1'),
    ]

    operations = [
        migrations.RunPython(migrate_json_data)
    ]
