# Generated by Django 5.0.3 on 2024-09-09 23:31

from django.db import migrations

def migrate_json_data(apps, schema_editor):
    Card = apps.get_model('main', 'Card')
    for obj in Card.objects.all():
        obj_json = obj.data
        
        if obj_json:
            obj_json['version'] = 1

            text_items = obj_json["information"]["items"]["text"]
            link_items = obj_json["information"]["items"]["links"]

            del obj_json["information"]["items"]
            obj_json["information"]["items"] = []

            if text_items:
                for item in range(len(text_items)):
                    text_items[item]["url"] = ""
                    text_items[item]["url_enabled"] = False

                    obj_json["information"]["items"].append(text_items[item])

            if link_items:
                for item in range(len(link_items)):
                    link_items[item]["url_enabled"] = True

                    obj_json["information"]["items"].append(link_items[item])

            for item in range(len(obj_json["information"]["items"])):
                obj_json["information"]["items"][item]["uuid"] = item
            
            obj.data = obj_json
            obj.save()

class Migration(migrations.Migration):

    dependencies = [
        ('main', '0009_card_card_created_on_card_card_last_edited_on'),  # Replace with your previous migration
    ]

    operations = [
        migrations.RunPython(migrate_json_data),
    ]