---
title: About Neutralinojs
---

Every open-source project has a great history. Some open-source projects decide to share their development
histories and internal processes with their developer communities to offer a fully-transparent
project-developer relationship.

Neutralinojs hides nothing &mdash; it explains to you the entire source code, framework internals, security
perspective, DevOps practices, project history, and even the financial side. We keep everything transparent
to motivate you to build your own open-source projects.

## History

In 2018, three Uva Wellassa University students, [Shalitha Suranga](https://github.com/shalithasuranga),
[Deepal Samarakoon](https://github.com/deepz123), and [Chathumadhuri
Hettiarachchi](https://github.com/Chathumaduri456) published a research paper about a theoretical way to
build cross-platform apps using inbuilt platform-specific browser libraries. They initially planned to use
"Neutrino" as the research project name, but it was already taken. So, they decided to use "Neutralinojs"
as the project name ([Neutralino](https://en.wikipedia.org/wiki/Neutralino) refers to a hypothetical
lightweight particle).

For the research paper, Shalitha Suranga wrote a small POC project
for GNU/Linux and Windows to demonstrate the theoretical idea and published it to GitHub as an experimental
open-source project. In 2019, the research paper authors started working with the software development industry.
But, Shalitha Suranga decided to maintain the POC project alone as a hobby project due to the positive feedback
received from the developer communities. Later, [Kasun Vithanage](https://github.com/kasvith) ported the
POC project to the macOS platform.

During 2020–2021, Shalitha Suranga rewrote the Neutralinojs POC project with a new WebSockets-based architecture.
His goal was to make the project production-ready with a stable API, well-organized codebase,
DevOps improvements, and developer-friendly documentation. Since this rewrite was so different compared to the
original research project idea, he planned to re-brand "Neutralinojs" as "Neu.js". However, he decided to use
the same name due to the existing Neutralinojs-related content on the internet.

In 2022, Neutralinojs passed remarkable development milestones and became a popular open-source framework for
building lightweight cross-platform desktop apps with JavaScript. During this journey, the developer community
supported Neutralinojs with ideas and code contributions.

## Current development

In 2022, Shalitha Suranga added the Neutralinojs project under the CodeZri non-profit organization to maintain
the project, along with his other personal [open-source projects](https://codezri.org/projects).

Nowadays, he releases a new framework version every two months with support from very supportive contributors.

The project uses a community-driven development methodology. Developer community members and maintainers
collaboratively work by writing code, reporting bugs, improving documentation, and discussing features.

## Financial perspective

Shalitha Suranga often donates his time to Neutralinojs by writing code, reviewing pull requests, and
planning future of Neutralinojs. He integrated [EthicalAds](https://www.ethicalads.io) and
[Google Adsense](https://www.google.com/adsense/start) with the Neutralinojs website
to generate revenue for his work. Also, he accepts donations from the developer community via his personal
[Patreon](https://www.patreon.com/shalithasuranga) and [GitHub Sponsors](https://github.com/sponsors/shalithasuranga) accounts.

Moreover, you can donate Neutralinojs via [OpenCollective](https://opencollective.com/neutralinojs).

Neutralinojs has no plans to monetize the framework with paid licensing/subscriptions,
paid support, or courses. Also, Neutralinojs doesn't accept payments to deliver new custom features or solve
bugs in apps. Our goal is to keep improving Neutralinojs as a pure FOSS project
under the donation-based financial model.

:::tip
Read [this article](https://betterprogramming.pub/how-to-turn-your-open-source-project-into-a-stable-income-stream-4c46b15ed960?sk=0cbeb6c01e36621fe01b99198a174b62)
to learn how to build a community-friendly revenue stream around your open-source project.
:::

We motivate everyone to build a community-friendly revenue stream around open-source projects!
