#-*- coding: utf-8 -*-

#+---------------------------------------------------------------------------+
#|          01001110 01100101 01110100 01111010 01101111 01100010            |
#|                                                                           |
#|               Netzob : Inferring communication protocols                  |
#+---------------------------------------------------------------------------+
#| Copyright (C) 2011-2017 Georges Bossert and Frédéric Guihéry              |
#| This program is free software: you can redistribute it and/or modify      |
#| it under the terms of the GNU General Public License as published by      |
#| the Free Software Foundation, either version 3 of the License, or         |
#| (at your option) any later version.                                       |
#|                                                                           |
#| This program is distributed in the hope that it will be useful,           |
#| but WITHOUT ANY WARRANTY; without even the implied warranty of            |
#| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the              |
#| GNU General Public License for more details.                              |
#|                                                                           |
#| You should have received a copy of the GNU General Public License         |
#| along with this program. If not, see <http://www.gnu.org/licenses/>.      |
#+---------------------------------------------------------------------------+
#| @url      : http://www.netzob.org                                         |
#| @contact  : contact@netzob.org                                            |
#| @sponsors : Amossys, http://www.amossys.fr                                |
#|             Supélec, http://www.rennes.supelec.fr/ren/rd/cidre/           |
#+---------------------------------------------------------------------------+

#+---------------------------------------------------------------------------+
#| File contributors :                                                       |
#|       - Georges Bossert <georges.bossert (a) supelec.fr>                  |
#|       - Frédéric Guihéry <frederic.guihery (a) amossys.fr>                |
#+---------------------------------------------------------------------------+

from common.NetzobTestCase import NetzobTestCase
import binascii
from netzob.all import *
import logging


class test_USBMouseProtocol(NetzobTestCase):

    def test_inferUSBMouseProtocol(self):
        """This method illustrates the very short script which
        gives some insights on the over USB protocol used
        by a traditionnal mouse."""

        # Put samples in an array
        samples = [
			"00ff1f000000",
			"00fe1f000000",
			"00fe1f000000",
			"00fe1f000000",
			"00ff1f000000",
			"00ff1f000000",
			"00ff0f000000",
			"00fe2f000000",
			"00fe1f000000",
			"00ff0f000000",
			"000010000000",
			"00fe1f000000",
			"00ff1f000000",
			"00ff0f000000",
			"00ff1f000000",
			"000010000000",
			"00ff0f000000",
			"000010000000",
			"00ff1f000000",
			"00ff0f000000",
			"00ff1f000000",
			"00fe0f000000",
			"00ff1f000000",
			"00ff1f000000",
			"00ff0f000000",
			"00fe1f000000",
			"00fe2f000000",
			"00fe1f000000",
			"00fe1f000000",
			"00fe1f000000",
			"000010000000",
			"00ff0f000000",
			"000010000000",
			"00fe0f000000",
			"00ff1f000000",
			"00fe1f000000",
			"00ff1f000000",
			"00ff1f000000",
			"00ff0f000000",
			"000010000000",
			"00fe1f000000",
			"00ff2f000000",
			"00fe1f000000",
			"00fe1f000000",
			"00ff1f000000",
			"00ff1f000000",
			"00ff1f000000",
			"00ff1f000000",
			"00fe1f000000",
			"00fe2f000000",
			"00fd2f000000",
			"00fe2f000000",
			"00fe1f000000",
			"00ff1f000000",
			"000010000000",
			"00ff1f000000",
			"00ff1f000000",
			"00ff1f000000",
			"00ff1f000000",
			"00ff0f000000",
			"000010000000",
			"00fe1f000000",
			"00ff0f000000",
			"00fe2f000000",
			"00fe2f000000",
			"00fd2f000000",
			"00ff2f000000",
			"00ff1f000000",
			"00fe0f000000",
			"000010000000",
			"00ff1f000000",
			"00fe1f000000",
			"00ff1f000000",
			"00ff1f000000",
			"00ff1f000000",
			"00fe1f000000",
			"00ff1f000000",
			"00ff2f000000",
			"00ff0f000000",
			"00fe1f000000",
			"00fe2f000000",
			"00ff1f000000",
			"00fe1f000000",
			"00ff1f000000",
			"00ff1f000000",
			"00fe1f000000",
			"00fe1f000000",
			"00fe1f000000",
			"00fe2f000000",
			"00ff1f000000",
			"00fe1f000000",
			"00ff1f000000",
			"00ff1f000000",
			"00ff1f000000",
			"00ff1f000000",
			"00fe1f000000",
			"00ff1f000000",
			"00ff0f000000",
			"000010000000",
			"00fe1f000000",
			"000010000000",
			"00fe1f000000",
			"00ff1f000000",
			"00ff1f000000",
			"00ff1f000000",
			"00ff0f000000",
			"00ff1f000000",
			"00ff1f000000",
			"00fe2f000000",
			"00fe1f000000",
			"00fe2f000000",
			"00fe1f000000",
			"00ff1f000000",
			"00fe1f000000",
			"00ff1f000000",
			"00fe1f000000",
			"00fe2f000000",
			"00ff1f000000",
			"00fe1f000000",
			"00fe1f000000",
			"00ff0f000000",
			"00fe2f000000",
			"00fe1f000000",
			"00fe1f000000",
			"00fe2f000000",
			"00fe1f000000",
			"00fe2f000000",
			"00fe2f000000",
			"00fd2f000000",
			"00fe1f000000",
			"00ff1f000000",
			"00fe1f000000",
			"00fe1f000000",
			"00ff1f000000",
			"00ff1f000000",
			"00fe0f000000",
			"00fe1f000000",
			"00fe2f000000",
			"00fd1f000000",
			"00fe1f000000",
			"00fe1f000000",
			"00fe1f000000",
			"00ff1f000000",
			"00ff0f000000",
			"00ff1f000000",
			"00ff0f000000",
			"00ff1f000000",
			"00ff0f000000",
			"00ff1f000000",
			"00ff0f000000",
			"00ff1f000000",
			"00fe1f000000",
			"00ff1f000000",
			"00ff1f000000",
			"00ff1f000000",
			"00ff0f000000",
			"00ff1f000000",
			"00ff1f000000",
			"00ff1f000000",
			"00fe1f000000",
			"00fe2f000000",
			"00fd1f000000",
			"00fe2f000000",
			"00fd1f000000",
			"00fe1f000000",
			"00fe2f000000",
			"00ff0f000000",
			"00fe1f000000",
			"00fe2f000000",
			"00ff1f000000",
			"00ff1f000000",
			"00ff0f000000",
			"00fe1f000000",
			"00ff1f000000",
			"00fe1f000000",
			"00fe2f000000",
			"00ff1f000000",
			"00fe1f000000",
			"00ff1f000000",
			"00ff1f000000",
			"00fe1f000000",
			"00fe1f000000",
			"00ff2f000000",
			"00fe1f000000",
			"00fe1f000000",
			"00fe2f000000",
			"00fe1f000000",
			"00fe2f000000",
			"00ff1f000000",
			"00fe1f000000",
			"00fe1f000000",
			"00fe2f000000",
			"00ff2f000000",
			"00fe1f000000",
			"00ff1f000000",
			"00ff2f000000",
			"00ff1f000000",
			"00ff1f000000",
			"000020000000",
			"00fe1f000000",
			"00ff1f000000",
			"00ff1f000000",
			"00ff1f000000",
			"00ff1f000000",
			"000010000000",
			"00fe1f000000",
			"00ff0f000000",
			"00ff1f000000",
			"00ff1f000000",
			"00ff1f000000",
			"00fe1f000000",
			"00fe2f000000",
			"00ff1f000000",
			"00fe2f000000",
			"00fe1f000000",
			"00fe2f000000",
			"00ff2f000000",
			"00fe1f000000",
			"00ff1f000000",
			"00ff1f000000",
			"00fe1f000000",
			"00ff1f000000",
			"00ff2f000000",
			"00ff1f000000",
			"00fd1f000000",
			"00fe2f000000",
			"00ff1f000000",
			"00ff0f000000",
			"00ff1f000000",
			"00fe1f000000",
			"000010000000",
			"00ff1f000000",
			"00ff2f000000",
			"00fe2f000000",
			"00fe1f000000",
			"00ff2f000000",
			"00fe1f000000",
			"00ff1f000000",
			"00fe2f000000",
			"00ff1f000000",
			"00fe1f000000",
			"00fe1f000000",
			"00ff2f000000",
			"00fe1f000000",
			"00ff1f000000",
			"00ff1f000000",
			"00ff1f000000",
			"00ff1f000000",
			"00ff1f000000",
			"00ff0f000000",
			"00fe1f000000",
			"00ff1f000000",
			"00ff1f000000",
			"00fe1f000000",
			"00ff1f000000",
			"00fe1f000000",
			"00ff1f000000",
			"00ff1f000000",
			"00ff1f000000",
			"00fe1f000000",
			"00fe1f000000",
			"00fe2f000000",
			"00fc2f000000",
			"00fe1f000000",
			"00fd2f000000",
			"00fe1f000000",
			"00ff1f000000",
			"00fe1f000000",
			"00ff1f000000",
			"00fe0f000000",
			"00ff1f000000",
			"00ff1f000000",
			"00fe1f000000",
			"00ff1f000000",
			"00ff1f000000",
			"00fe1f000000",
			"000010000000",
			"00fe1f000000",
			"00fe1f000000",
			"00ff1f000000",
			"00ff1f000000",
			"00ff1f000000",
			"00ff0f000000",
			"00ff1f000000",
			"00ff0f000000",
			"00ff1f000000",
			"00ff1f000000",
			"00fd2f000000",
			"00fe1f000000",
			"00fe1f000000",
			"00ff1f000000",
			"00ff1f000000",
			"00ff0f000000",
			"00ff1f000000",
			"00fe1f000000",
			"00fc2f000000",
			"00fb2f000000",
			"00fb2f000000",
			"00fa4f000000",
			"00f92f000000",
			"00fa3f000000",
			"00fe1f000000",
			"000010000000",
			"00ff1f000000",
			"00fd3f000000",
			"00fd3f000000",
			"00fe2f000000",
			"00fd2f000000",
			"00ff2f000000",
			"00fe0f000000",
			"000010000000",
			"000010000000",
			"00ff1f000000",
			"000010000000",
			"00ff1f000000",
			"00ff2f000000",
			"000010000000",
			"00fe1f000000",
			"000020000000",
			"00ff1f000000",
			"00ff1f000000",
			"00ff2f000000",
			"00fe1f000000",
			"00ff2f000000"
            ]

        # Create a message for each data
        messages = [RawMessage(data=binascii.unhexlify(sample)) for sample in samples]

        # Create a symbol to represent all the messages
        initialSymbol = Symbol(messages=messages)

        # Split following the value
        Format.splitStatic(initialSymbol, mergeAdjacentDynamicFields=False)

        initialSymbol.addEncodingFunction(TypeEncodingFunction(HexaString))

        logging.debug(initialSymbol)
