# Netguru Mobile Security Checklist

At Netguru we care about security of our mobile applications, that's why our mobile security group has created this checklist.
This repository contains a list of security requirements that can increase the security of mobile application.

Every requirement should contain a handbook describing:
- Risk related with the requirement.
- Information when the app should apply this requirement.
- Solution how to apply requirement.
- Explanation how to test your app againt this risk.

Which should make it easier to decide, if app need such requirement and how to apply it.

# Why did we decide to create a Mobile Security Checklist?

We wanted to make mobile security more accessible and standardize the list of requirements that projects could conform to. 

# Table of contents

## Checklists

- [Shared](Checklists/01-Shared.md)
- [iOS](Checklists/02-iOS.md)
- [Android](Checklists/03-Android.md)

## Handbooks

- [Shared](Handbooks/01-Shared/)
- [iOS](Handbooks/02-iOS/)
<!-- Uncomment Android directory after adding first handbook
- [Android](Handbooks/03-Android/) 
-->

# About

This project is made with ❤️ by [Netguru](https://netguru.com).

<h1 id="Contributors">Contributors</h1>

<div>

<a href="https://github.com/krysztalzg">
  <img alt="Kamil" src="https://avatars.githubusercontent.com/u/6009785?v=4" height="60" width="60"/>
</a>

<a href="https://github.com/karolpiateknet">
  <img alt="Karol" src="https://avatars.githubusercontent.com/u/57398986?v=4" height="60" width="60"/>
</a>
  
<a href="https://github.com/Silvorion">
  <img alt="Daniel" src="https://avatars.githubusercontent.com/u/41166091?v=4" height="60" width="60"/>
</a>
  
<a href="https://github.com/mtbrzeski">
  <img alt="Mariusz" src="https://avatars.githubusercontent.com/u/19146143?v=4" height="60" width="60"/>
</a>
  
<a href="https://github.com/drohoo">
  <img alt="Damian" src="https://avatars.githubusercontent.com/u/18630690?v=4" height="60" width="60"/>
</a>
  
<a href="https://github.com/Patys">
  <img alt="Patryk" src="https://avatars.githubusercontent.com/u/8997573?v=4" height="60" width="60"/>
</a>
  
<a href="https://github.com/howtodance">
  <img alt="Eugene" src="https://avatars.githubusercontent.com/u/11170458?v=4" height="60" width="60"/>
</a>

<a href="https://github.com/MateuszMatyska">
  <img alt="Mateusz" src="https://avatars.githubusercontent.com/u/37210055?v=4" height="60" width="60"/>
</a>

</div>
<br>

Wanna become next contributor? Check these guides:
- [Checklist contribution](Checklists/how_to_contribute.md)
- [Handbooks contribution](Handbooks/how_to_contribute.md)

# License

The mobile security checklist is available as open source under the terms of the [Apache 2.0 LICENSE](LICENSE).
