# Shared security requirements between platforms

## Default

| ID  | Priority | Feature | Description | Link |
| --  | -- | ---------------------- | ---------------------- | - |
| SD.1 | High | Login / Signup, keeping user session alive | All tokens / credentials must be stored in keychain/keystore if they are persisted | [Handbook](../Handbooks/TODO.md) |
| SD.2 | High | Storing environment variables | Environment variables cannot be stored in github repository. All envs should be stored in secrets on CI (e. g. Bitrise) | [Handbook](../Handbooks/TODO.md) |
| SD.3 | Medium | App is using logs | No sensitive data is written to application logs | [Handbook](../Handbooks/01-Shared/SD.3-Secure-application-logging.md) |
| SD.4 | Critical | Sensitive aplication logic | Validate every update of a sensitive value with the server. <br> Do not validate sensitive features locally <br> For example: <br> - Admin mode <br> - Coins for premium features | [Handbook](../Handbooks/TODO.md) |
| SD.5 | Critical | Hardcoded keys | App doesn't store sensitive hardcoded keys inside app and conforms to best practices of storing hardcoded keys | [Handbook](../Handbooks/01-Shared/SD.5-Hardcoded-keys.md) |
| SD.6 | Critical | Login / signup | Do not store user password in local data storage | [Handbook](../Handbooks/TODO.md) |
| SD.7 | High | Third party service with API keys | Keys generated in Third Party service like Google Cloud should have minimum set of permissions. <br> It should have assigned bundleID / AppID to key, It will accept data only from those apps | [Handbook](../Handbooks/TODO.md) |
| SD.8 | Medium | Authentication requires to enter data (password, pin) through e.g. keyboard | No sensitive data, such as passwords or pins, is exposed through the user interface. You have to use secure text entry for fields | [Handbook](../Handbooks/01-Shared/SD.8-Masking-sensitive-data-in-the-UI.md) |
| SD.9 | Critical | App is making requests to REST API | Whole communication should use only HTTPS protocol | [Handbook](../Handbooks/TODO.md) |
| SD.10 | Medium | Platforms with native obfuscation: Android, Flutter, React-Native | Obfuscation should be configured. For Android: App should have proguard/r8 enabled | [Handbook](../Handbooks/TODO.md) |
| SD.11 | Low | App is adding new permissions | Review permissions and use only necessary | [Handbook](../Handbooks/TODO.md) |
| SD.12 | High | App has apple certificates, google keystore or other sensitive files | Secure them in proper place and describe how it's achieved. E.g. make sure they are all stored only in 1pass and access has minimal amount of people | [Handbook](../Handbooks/TODO.md) |
| SD.13 | High | App is persisting data. App saves files | No sensitive data is included in backups generated by the mobile operating system. Make sure that all files are saved in proper place | [Handbook](../Handbooks/TODO.md) |
| SD.14 | Medium | User can recover account | The app doesn't rely on a single insecure communication channel (email or SMS) for critical operations, such as enrollments and account recovery. You should have possiblity to verify somehow user identity e.g. security questions, additional informtation about what happend in account | [Handbook](../Handbooks/TODO.md) |
| SD.15 | Medium | URLs passed outside of app (for example from API) | Validate url according whitelist of urls within app | [Handbook](../Handbooks/01-Shared/SD.15-URLs-passed-outside-of-app.md) |
| SD.16 | Medium | Login / signup | Removing all data after logout, keychain, files, cache | [Handbook](../Handbooks/TODO.md) |
| SD.17 | Critical | Application contains deep / universal links | App verifies content of deep links according to best practices | [Handbook](../Handbooks/TODO.md) |
| SD.18 | High | Logout | Invalidate access token through request to backend | [Handbook](../Handbooks/TODO.md) |
| SD.19 | High | Application contains Development / Debug code | This code is not compiled to Production application | [Handbook](../Handbooks/TODO.md) |
| SD.20 | High | Staging offers app functionalities for free | It should be protected against random users | [Handbook](../Handbooks/TODO.md) |


## Extra

| ID  | Priority | Feature | Description | Link |
| --  | -- | ---------------------- | ---------------------- | - |
| SE.1 | Medium | Fintech app or very sensitive application | To increase security of the application it could be additionally protected with PIN screen | [Handbook](../Handbooks/TODO.md) |
| SE.2 | Medium | User shouldn't use jailbroken/rooted device | The app detects and reacts to the presence of a rooted or jailbroken device either by alerting the user or terminating the app | [Handbook](../Handbooks/01-Shared/SE.2-Detecting-and-reacting-to-root.md) |
| SE.3 | Low | The app informs the user of all sensitive activities with their account. Users are able to view a list of devices, view contextual information (IP address, location, etc.), and to block specific devices | The app informs the user of all sensitive activities with their account. Users are able to view a list of devices, view contextual information (IP address, location, etc.), and to block specific devices | [Handbook](../Handbooks/TODO.md) |
| SE.4 | Low | The app catches and handles possible exceptions | Make sure you have added sentry, bugsnag or crashlitics or other to catch all crashes | [Handbook](../Handbooks/TODO.md) |
| SE.5 | Medium | Storing data using hashes | Hashed data should use unique (for every user) salt to increase the complexity of reversing the operation | [Handbook](../Handbooks/TODO.md) |
| SE.6 | High | Very sensitive applications like banking apps | Two factor authentication | [Handbook](../Handbooks/TODO.md) |
| SE.7 | Low | App is recognizing device as trust device | The app implements a 'device binding' functionality using a device fingerprint derived from multiple properties unique to the device | [Handbook](../Handbooks/TODO.md) |
| SE.8 | Medium | Login | Block App after number of login failures | [Handbook](../Handbooks/TODO.md) |
| SE.9 | Medium | App receives data from user input | Input data should be properly validated to process it safely | [Handbook](../Handbooks/01-Shared/SE.9-Limit-maximum-input-length.md) |
| SE.10 | Medium | App properly configures auto-correction | Auto-correction should be disabled for sensitive input | [Handbook](../Handbooks/01-Shared/SE.10-Disable-auto-correction.md) |


## WebView

| ID  | Priority | Feature | Description | Link |
| --  | -- | ---------------------- | ---------------------- | - |
| SW.1 | Medium | App is using webview | JavaScript is disabled in WebViews unless explicitly required | [Handbook](../Handbooks/01-Shared/SW.1-JavaScript-WebView.md) |


## Upload

| ID  | Priority | Feature | Description | Link |
| --  | -- | ---------------------- | ---------------------- | - |
| SU.1 | Medium | App has file upload | Limit maximum number of files that can be uploaded at once | [Handbook](../Handbooks/TODO.md) |


## GDPR

| ID  | Priority | Feature | Description | Link |
| --  | -- | ---------------------- | ---------------------- | - |
| SG.1 | Critical | Persising user personal information (name, phone, email, ...) on the device | Persisted database should be encrypted when not used. Storage data should not be easily accessible and kept unencrypted | [Handbook](../Handbooks/TODO.md) |
| SG.2 | Medium | Saving sensitive data in local storage (Keychain, SQLite, ...) | The app’s local storage should be wiped after an excessive number of failed authentication attempts | [Handbook](../Handbooks/TODO.md) |
| SG.3 | High | Sending personal data outside of the application | All requests must be authenticated | [Handbook](../Handbooks/TODO.md) |
| SG.4 | Medium | Transferin personal data through REST API | Certificate pinning should be implemented and HTTPS protocol used for network communication | [Handbook](../Handbooks/01-Shared/SG-4-Certificate-Pinning.md) |
| SG.5 | Critical | Displaying privacy policy screen during registration process | The privacy policy must be directly accepted by the user, you can use unchecked checkbox | [Handbook](../Handbooks/TODO.md) |
| SG.6 | High | Using non-production environments | Non-production environments (development, staging, beta) **can not** contain any real personal data | [Handbook](../Handbooks/TODO.md) |


## Email

| ID  | Priority | Feature | Description | Link |
| --  | -- | ---------------------- | ---------------------- | - |
| SEM.1 | High | Application has input for user email address | Email input should be validated and limited in maximum characters to e.g. 100 characters | [Handbook](../Handbooks/TODO.md) |


## Video

| ID  | Priority | Feature | Description | Link |
| --  | -- | ---------------------- | ---------------------- | - |
| SV.1 | High | User can play video in the application | Video data must be received through encrypted protocol | [Handbook](../Handbooks/TODO.md) |


## Location

| ID  | Priority | Feature | Description | Link |
| --  | -- | ---------------------- | ---------------------- | - |
| SL.1 | Medium | App is using location services | Detect mocked location and let user know. Also check how it's affecting app and should it be possible to fake location | [Handbook](../Handbooks/TODO.md) |

