// A text-mode interface inspired by the one in the DOS edit.com utility.
// Much of the code is based on the alphanumeric renderer in vga.c, although it has been simplified for speed and performance.
#include "display.h"
#include "devices.h"
#include "util.h"
#include <SDL/SDL.h>
#include <stdarg.h>
#include <stdlib.h>
#include <string.h>

#define DISPLAY_LOG(x, ...) LOG("DISPLAY", x, ##__VA_ARGS__)
#define DISPLAY_FATAL(x, ...)          \
    do {                               \
        DISPLAY_LOG(x, ##__VA_ARGS__); \
        ABORT();                       \
    } while (0)

/*
 * This font comes from ftp://ftp.simtel.net/pub/simtelnet/msdos/screen/fntcol16.zip
 * The package is (c) by Joseph Gil
 * The individual fonts are public domain
 */
static const uint8_t vgadata[256 * 16] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x7e, 0x81, 0xa5, 0x81, 0x81, 0xbd, 0x99, 0x81, 0x81, 0x7e, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x7e, 0xff, 0xdb, 0xff, 0xff, 0xc3, 0xe7, 0xff, 0xff, 0x7e, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x6c, 0xfe, 0xfe, 0xfe, 0xfe, 0x7c, 0x38, 0x10, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x10, 0x38, 0x7c, 0xfe, 0x7c, 0x38, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x18, 0x3c, 0x3c, 0xe7, 0xe7, 0xe7, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x18, 0x3c, 0x7e, 0xff, 0xff, 0x7e, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x3c, 0x3c, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe7, 0xc3, 0xc3, 0xe7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x66, 0x42, 0x42, 0x66, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xc3, 0x99, 0xbd, 0xbd, 0x99, 0xc3, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x00, 0x00, 0x1e, 0x0e, 0x1a, 0x32, 0x78, 0xcc, 0xcc, 0xcc, 0xcc, 0x78, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x3c, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x18, 0x7e, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x3f, 0x33, 0x3f, 0x30, 0x30, 0x30, 0x30, 0x70, 0xf0, 0xe0, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x7f, 0x63, 0x7f, 0x63, 0x63, 0x63, 0x63, 0x67, 0xe7, 0xe6, 0xc0, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x18, 0x18, 0xdb, 0x3c, 0xe7, 0x3c, 0xdb, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x80, 0xc0, 0xe0, 0xf0, 0xf8, 0xfe, 0xf8, 0xf0, 0xe0, 0xc0, 0x80, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x02, 0x06, 0x0e, 0x1e, 0x3e, 0xfe, 0x3e, 0x1e, 0x0e, 0x06, 0x02, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x18, 0x3c, 0x7e, 0x18, 0x18, 0x18, 0x7e, 0x3c, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x00, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x7f, 0xdb, 0xdb, 0xdb, 0x7b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x7c, 0xc6, 0x60, 0x38, 0x6c, 0xc6, 0xc6, 0x6c, 0x38, 0x0c, 0xc6, 0x7c, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0xfe, 0xfe, 0xfe, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x18, 0x3c, 0x7e, 0x18, 0x18, 0x18, 0x7e, 0x3c, 0x18, 0x7e, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x18, 0x3c, 0x7e, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x7e, 0x3c, 0x18, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x0c, 0xfe, 0x0c, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x60, 0xfe, 0x60, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xc0, 0xc0, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x66, 0xff, 0x66, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x10, 0x38, 0x38, 0x7c, 0x7c, 0xfe, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xfe, 0xfe, 0x7c, 0x7c, 0x38, 0x38, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x18, 0x3c, 0x3c, 0x3c, 0x18, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x66, 0x66, 0x66, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x6c, 0x6c, 0xfe, 0x6c, 0x6c, 0x6c, 0xfe, 0x6c, 0x6c, 0x00, 0x00, 0x00, 0x00,
    0x18, 0x18, 0x7c, 0xc6, 0xc2, 0xc0, 0x7c, 0x06, 0x06, 0x86, 0xc6, 0x7c, 0x18, 0x18, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xc2, 0xc6, 0x0c, 0x18, 0x30, 0x60, 0xc6, 0x86, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x38, 0x6c, 0x6c, 0x38, 0x76, 0xdc, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x30, 0x30, 0x30, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x0c, 0x18, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x18, 0x0c, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x30, 0x18, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x18, 0x30, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x3c, 0xff, 0x3c, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x7e, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x30, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x02, 0x06, 0x0c, 0x18, 0x30, 0x60, 0xc0, 0x80, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x3c, 0x66, 0xc3, 0xc3, 0xdb, 0xdb, 0xc3, 0xc3, 0x66, 0x3c, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x18, 0x38, 0x78, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x7e, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x7c, 0xc6, 0x06, 0x0c, 0x18, 0x30, 0x60, 0xc0, 0xc6, 0xfe, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x7c, 0xc6, 0x06, 0x06, 0x3c, 0x06, 0x06, 0x06, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x0c, 0x1c, 0x3c, 0x6c, 0xcc, 0xfe, 0x0c, 0x0c, 0x0c, 0x1e, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xfe, 0xc0, 0xc0, 0xc0, 0xfc, 0x06, 0x06, 0x06, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x38, 0x60, 0xc0, 0xc0, 0xfc, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xfe, 0xc6, 0x06, 0x06, 0x0c, 0x18, 0x30, 0x30, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0x7e, 0x06, 0x06, 0x06, 0x0c, 0x78, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x18, 0x18, 0x30, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x06, 0x0c, 0x18, 0x30, 0x60, 0x30, 0x18, 0x0c, 0x06, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x60, 0x30, 0x18, 0x0c, 0x06, 0x0c, 0x18, 0x30, 0x60, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x7c, 0xc6, 0xc6, 0x0c, 0x18, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xde, 0xde, 0xde, 0xdc, 0xc0, 0x7c, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x10, 0x38, 0x6c, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xfc, 0x66, 0x66, 0x66, 0x7c, 0x66, 0x66, 0x66, 0x66, 0xfc, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x3c, 0x66, 0xc2, 0xc0, 0xc0, 0xc0, 0xc0, 0xc2, 0x66, 0x3c, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xf8, 0x6c, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x6c, 0xf8, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xfe, 0x66, 0x62, 0x68, 0x78, 0x68, 0x60, 0x62, 0x66, 0xfe, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xfe, 0x66, 0x62, 0x68, 0x78, 0x68, 0x60, 0x60, 0x60, 0xf0, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x3c, 0x66, 0xc2, 0xc0, 0xc0, 0xde, 0xc6, 0xc6, 0x66, 0x3a, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x1e, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0xcc, 0xcc, 0xcc, 0x78, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xe6, 0x66, 0x66, 0x6c, 0x78, 0x78, 0x6c, 0x66, 0x66, 0xe6, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xf0, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x62, 0x66, 0xfe, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xc3, 0xe7, 0xff, 0xff, 0xdb, 0xc3, 0xc3, 0xc3, 0xc3, 0xc3, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xc6, 0xe6, 0xf6, 0xfe, 0xde, 0xce, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xfc, 0x66, 0x66, 0x66, 0x7c, 0x60, 0x60, 0x60, 0x60, 0xf0, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xd6, 0xde, 0x7c, 0x0c, 0x0e, 0x00, 0x00,
    0x00, 0x00, 0xfc, 0x66, 0x66, 0x66, 0x7c, 0x6c, 0x66, 0x66, 0x66, 0xe6, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x7c, 0xc6, 0xc6, 0x60, 0x38, 0x0c, 0x06, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xff, 0xdb, 0x99, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xc3, 0xc3, 0xc3, 0xc3, 0xc3, 0xc3, 0xc3, 0x66, 0x3c, 0x18, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xc3, 0xc3, 0xc3, 0xc3, 0xc3, 0xdb, 0xdb, 0xff, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xc3, 0xc3, 0x66, 0x3c, 0x18, 0x18, 0x3c, 0x66, 0xc3, 0xc3, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xc3, 0xc3, 0xc3, 0x66, 0x3c, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xff, 0xc3, 0x86, 0x0c, 0x18, 0x30, 0x60, 0xc1, 0xc3, 0xff, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x3c, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x3c, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x80, 0xc0, 0xe0, 0x70, 0x38, 0x1c, 0x0e, 0x06, 0x02, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x3c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0x3c, 0x00, 0x00, 0x00, 0x00,
    0x10, 0x38, 0x6c, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00,
    0x30, 0x30, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x0c, 0x7c, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xe0, 0x60, 0x60, 0x78, 0x6c, 0x66, 0x66, 0x66, 0x66, 0x7c, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc0, 0xc0, 0xc0, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x1c, 0x0c, 0x0c, 0x3c, 0x6c, 0xcc, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xfe, 0xc0, 0xc0, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x38, 0x6c, 0x64, 0x60, 0xf0, 0x60, 0x60, 0x60, 0x60, 0xf0, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x7c, 0x0c, 0xcc, 0x78, 0x00,
    0x00, 0x00, 0xe0, 0x60, 0x60, 0x6c, 0x76, 0x66, 0x66, 0x66, 0x66, 0xe6, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x18, 0x18, 0x00, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x06, 0x06, 0x00, 0x0e, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x66, 0x66, 0x3c, 0x00,
    0x00, 0x00, 0xe0, 0x60, 0x60, 0x66, 0x6c, 0x78, 0x78, 0x6c, 0x66, 0xe6, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0xe6, 0xff, 0xdb, 0xdb, 0xdb, 0xdb, 0xdb, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0xdc, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0xdc, 0x66, 0x66, 0x66, 0x66, 0x66, 0x7c, 0x60, 0x60, 0xf0, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x7c, 0x0c, 0x0c, 0x1e, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0xdc, 0x76, 0x66, 0x60, 0x60, 0x60, 0xf0, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xc6, 0x60, 0x38, 0x0c, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x10, 0x30, 0x30, 0xfc, 0x30, 0x30, 0x30, 0x30, 0x36, 0x1c, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0xc3, 0xc3, 0xc3, 0xc3, 0x66, 0x3c, 0x18, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0xc3, 0xc3, 0xc3, 0xdb, 0xdb, 0xff, 0x66, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0xc3, 0x66, 0x3c, 0x18, 0x3c, 0x66, 0xc3, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e, 0x06, 0x0c, 0xf8, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0xcc, 0x18, 0x30, 0x60, 0xc6, 0xfe, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x0e, 0x18, 0x18, 0x18, 0x70, 0x18, 0x18, 0x18, 0x18, 0x0e, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x70, 0x18, 0x18, 0x18, 0x0e, 0x18, 0x18, 0x18, 0x18, 0x70, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x76, 0xdc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x10, 0x38, 0x6c, 0xc6, 0xc6, 0xc6, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x3c, 0x66, 0xc2, 0xc0, 0xc0, 0xc0, 0xc2, 0x66, 0x3c, 0x0c, 0x06, 0x7c, 0x00, 0x00,
    0x00, 0x00, 0xcc, 0x00, 0x00, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x0c, 0x18, 0x30, 0x00, 0x7c, 0xc6, 0xfe, 0xc0, 0xc0, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x10, 0x38, 0x6c, 0x00, 0x78, 0x0c, 0x7c, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xcc, 0x00, 0x00, 0x78, 0x0c, 0x7c, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x60, 0x30, 0x18, 0x00, 0x78, 0x0c, 0x7c, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x38, 0x6c, 0x38, 0x00, 0x78, 0x0c, 0x7c, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x3c, 0x66, 0x60, 0x60, 0x66, 0x3c, 0x0c, 0x06, 0x3c, 0x00, 0x00, 0x00,
    0x00, 0x10, 0x38, 0x6c, 0x00, 0x7c, 0xc6, 0xfe, 0xc0, 0xc0, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xc6, 0x00, 0x00, 0x7c, 0xc6, 0xfe, 0xc0, 0xc0, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x60, 0x30, 0x18, 0x00, 0x7c, 0xc6, 0xfe, 0xc0, 0xc0, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x66, 0x00, 0x00, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x18, 0x3c, 0x66, 0x00, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x60, 0x30, 0x18, 0x00, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00,
    0x00, 0xc6, 0x00, 0x10, 0x38, 0x6c, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00,
    0x38, 0x6c, 0x38, 0x00, 0x38, 0x6c, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00,
    0x18, 0x30, 0x60, 0x00, 0xfe, 0x66, 0x60, 0x7c, 0x60, 0x60, 0x66, 0xfe, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x6e, 0x3b, 0x1b, 0x7e, 0xd8, 0xdc, 0x77, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x3e, 0x6c, 0xcc, 0xcc, 0xfe, 0xcc, 0xcc, 0xcc, 0xcc, 0xce, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x10, 0x38, 0x6c, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xc6, 0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x60, 0x30, 0x18, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x30, 0x78, 0xcc, 0x00, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x60, 0x30, 0x18, 0x00, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xc6, 0x00, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7e, 0x06, 0x0c, 0x78, 0x00,
    0x00, 0xc6, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00,
    0x00, 0xc6, 0x00, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x18, 0x18, 0x7e, 0xc3, 0xc0, 0xc0, 0xc0, 0xc3, 0x7e, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x38, 0x6c, 0x64, 0x60, 0xf0, 0x60, 0x60, 0x60, 0x60, 0xe6, 0xfc, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xc3, 0x66, 0x3c, 0x18, 0xff, 0x18, 0xff, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00,
    0x00, 0xfc, 0x66, 0x66, 0x7c, 0x62, 0x66, 0x6f, 0x66, 0x66, 0x66, 0xf3, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x0e, 0x1b, 0x18, 0x18, 0x18, 0x7e, 0x18, 0x18, 0x18, 0x18, 0x18, 0xd8, 0x70, 0x00, 0x00,
    0x00, 0x18, 0x30, 0x60, 0x00, 0x78, 0x0c, 0x7c, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x0c, 0x18, 0x30, 0x00, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3c, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x18, 0x30, 0x60, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x18, 0x30, 0x60, 0x00, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x76, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x76, 0xdc, 0x00, 0xdc, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00,
    0x76, 0xdc, 0x00, 0xc6, 0xe6, 0xf6, 0xfe, 0xde, 0xce, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x3c, 0x6c, 0x6c, 0x3e, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x38, 0x6c, 0x6c, 0x38, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x60, 0xc0, 0xc6, 0xc6, 0x7c, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0xc0, 0xc0, 0xc0, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x06, 0x06, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0xc0, 0xc0, 0xc2, 0xc6, 0xcc, 0x18, 0x30, 0x60, 0xce, 0x9b, 0x06, 0x0c, 0x1f, 0x00, 0x00,
    0x00, 0xc0, 0xc0, 0xc2, 0xc6, 0xcc, 0x18, 0x30, 0x66, 0xce, 0x96, 0x3e, 0x06, 0x06, 0x00, 0x00,
    0x00, 0x00, 0x18, 0x18, 0x00, 0x18, 0x18, 0x18, 0x3c, 0x3c, 0x3c, 0x18, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x6c, 0xd8, 0x6c, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0xd8, 0x6c, 0x36, 0x6c, 0xd8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x11, 0x44, 0x11, 0x44, 0x11, 0x44, 0x11, 0x44, 0x11, 0x44, 0x11, 0x44, 0x11, 0x44, 0x11, 0x44,
    0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa,
    0xdd, 0x77, 0xdd, 0x77, 0xdd, 0x77, 0xdd, 0x77, 0xdd, 0x77, 0xdd, 0x77, 0xdd, 0x77, 0xdd, 0x77,
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xf8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
    0x18, 0x18, 0x18, 0x18, 0x18, 0xf8, 0x18, 0xf8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
    0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0xf6, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36,
    0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x18, 0xf8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
    0x36, 0x36, 0x36, 0x36, 0x36, 0xf6, 0x06, 0xf6, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36,
    0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36,
    0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x06, 0xf6, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36,
    0x36, 0x36, 0x36, 0x36, 0x36, 0xf6, 0x06, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x18, 0x18, 0x18, 0x18, 0x18, 0xf8, 0x18, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x1f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
    0x18, 0x18, 0x18, 0x18, 0x18, 0x1f, 0x18, 0x1f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
    0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x37, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36,
    0x36, 0x36, 0x36, 0x36, 0x36, 0x37, 0x30, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x30, 0x37, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36,
    0x36, 0x36, 0x36, 0x36, 0x36, 0xf7, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0xf7, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36,
    0x36, 0x36, 0x36, 0x36, 0x36, 0x37, 0x30, 0x37, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36,
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x36, 0x36, 0x36, 0x36, 0x36, 0xf7, 0x00, 0xf7, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36,
    0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36,
    0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x18, 0x18, 0x18, 0x18, 0x18, 0x1f, 0x18, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x18, 0x1f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36,
    0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0xff, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36,
    0x18, 0x18, 0x18, 0x18, 0x18, 0xff, 0x18, 0xff, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,
    0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0xdc, 0xd8, 0xd8, 0xd8, 0xdc, 0x76, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x78, 0xcc, 0xcc, 0xcc, 0xd8, 0xcc, 0xc6, 0xc6, 0xc6, 0xcc, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xfe, 0xc6, 0xc6, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xfe, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0xfe, 0xc6, 0x60, 0x30, 0x18, 0x30, 0x60, 0xc6, 0xfe, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0xd8, 0xd8, 0xd8, 0xd8, 0xd8, 0x70, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x66, 0x66, 0x66, 0x7c, 0x60, 0x60, 0xc0, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x76, 0xdc, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x7e, 0x18, 0x3c, 0x66, 0x66, 0x66, 0x3c, 0x18, 0x7e, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x38, 0x6c, 0xc6, 0xc6, 0xfe, 0xc6, 0xc6, 0x6c, 0x38, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x38, 0x6c, 0xc6, 0xc6, 0xc6, 0x6c, 0x6c, 0x6c, 0x6c, 0xee, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x1e, 0x30, 0x18, 0x0c, 0x3e, 0x66, 0x66, 0x66, 0x66, 0x3c, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0xdb, 0xdb, 0xdb, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x03, 0x06, 0x7e, 0xdb, 0xdb, 0xf3, 0x7e, 0x60, 0xc0, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x1c, 0x30, 0x60, 0x60, 0x7c, 0x60, 0x60, 0x60, 0x30, 0x1c, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x7c, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xfe, 0x00, 0x00, 0xfe, 0x00, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x7e, 0x18, 0x18, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x30, 0x18, 0x0c, 0x06, 0x0c, 0x18, 0x30, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x0c, 0x18, 0x30, 0x60, 0x30, 0x18, 0x0c, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x0e, 0x1b, 0x1b, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0xd8, 0xd8, 0xd8, 0x70, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x7e, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0xdc, 0x00, 0x76, 0xdc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x38, 0x6c, 0x6c, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x0f, 0x0c, 0x0c, 0x0c, 0x0c, 0x0c, 0xec, 0x6c, 0x6c, 0x3c, 0x1c, 0x00, 0x00, 0x00, 0x00,
    0x00, 0xd8, 0x6c, 0x6c, 0x6c, 0x6c, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x70, 0xd8, 0x30, 0x60, 0xc8, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

// These values were ripped right out of the VGA controller
static const uint32_t vga_colors[16] = {
    // vga.dac_palette[vga.attr_palette[0]] = vga.dac_palette[0]
    0xff000000,
    // vga.dac_palette[vga.attr_palette[1]] = vga.dac_palette[1]
    0xff0000a8,
    // vga.dac_palette[vga.attr_palette[2]] = vga.dac_palette[2]
    0xff00a800,
    // vga.dac_palette[vga.attr_palette[3]] = vga.dac_palette[3]
    0xff00a8a8,
    // vga.dac_palette[vga.attr_palette[4]] = vga.dac_palette[4]
    0xffa80000,
    // vga.dac_palette[vga.attr_palette[5]] = vga.dac_palette[5]
    0xffa800a8,
    // vga.dac_palette[vga.attr_palette[6]] = vga.dac_palette[0x14]
    0xffa85700,
    // vga.dac_palette[vga.attr_palette[7]] = vga.dac_palette[7]
    0xffa8a8a8,
    // vga.dac_palette[vga.attr_palette[8]] = vga.dac_palette[0x38]
    0xff575757,
    // vga.dac_palette[vga.attr_palette[9]] = vga.dac_palette[0x39]
    0xff5757ff,
    // vga.dac_palette[vga.attr_palette[10]] = vga.dac_palette[0x3A]
    0xff57ff57,
    // vga.dac_palette[vga.attr_palette[11]] = vga.dac_palette[0x3B]
    0xff57ffff,
    // vga.dac_palette[vga.attr_palette[12]] = vga.dac_palette[0x3C]
    0xffff5757,
    // vga.dac_palette[vga.attr_palette[13]] = vga.dac_palette[0x3D]
    0xffff57ff,
    // vga.dac_palette[vga.attr_palette[14]] = vga.dac_palette[0x3E]
    0xffffff57,
    // vga.dac_palette[vga.attr_palette[15]] = vga.dac_palette[0x3F]
    0xffffffff
};

static SDL_Surface* surface = NULL;
static int w, h, mouse_enabled, mhz_rating, input_captured;

#define CHAR_HEIGHT 16
#define MENUBAR_HEIGHT CHAR_HEIGHT
#define STATUS_HEIGHT CHAR_HEIGHT
#define CHAR_WIDTH 9
#define SCREEN_BYTPP 4 // BYTES per pixel, just the way that the VGA controller likes it

void* display_get_pixels(void)
{
    return surface->pixels + (w * SCREEN_BYTPP * MENUBAR_HEIGHT);
}

static void display_set_title(void)
{
    char buffer[1000];
    sprintf(buffer, "Halfix x86 Emulator - "
                    " [%d x %d] - %s",
        w, h,
        mouse_enabled ? "Press ESC to release mouse" : "Right-click to capture mouse");
    SDL_WM_SetCaption(buffer, "Halfix");
}

void display_update_cycles(int cycles_elapsed, int us)
{
    mhz_rating = (int)((double)cycles_elapsed / (double)us);
    display_set_title();
}

static int resized = 0;
static uint8_t *menubar_textbuffer = NULL, *statusbar_textbuffer = NULL;
static uint32_t menubar_width = 0, menubar_overflow = 0, menubar_overscan = 0x70;

typedef void (*topmenu_cb_t)(int);
typedef void (*menu_click_cb)(void);

enum {
    FILE_QUIT
};

#define MAX_MENUBAR_ITEMS 10
#define MAX_SUBWINDOWS 5

struct menubar_listing {
    int nent;
    int max_width, max_height;
    char** entries;
    int* offsets;
    menu_click_cb* cbs;

    char* textbuf;
};

static struct menubar {
    char* name;
    int xoffs, twidth;

    // Character position
    int cpos, cwidth;

    int attached_window;

    topmenu_cb_t cbclick;

    struct menubar_listing* menulist;
} menubar[MAX_MENUBAR_ITEMS];

// Blit 'chrpnt' with attributes 'attr' to framebuffer 'pix' with width 'w' at offset 'offsz.'
static void blit_chr(uint8_t chrpnt, uint8_t attr, uint32_t* pix, uint32_t offsz, int w)
{
    uint32_t fg = vga_colors[attr & 15],
             bg = vga_colors[attr >> 4 & 15],
             xorvec = fg ^ bg;
    const uint8_t* fontptr = &vgadata[chrpnt * 16];
    for (int j = 0; j < MENUBAR_HEIGHT; j++) {
        uint8_t font = fontptr[j];
        // copied from vga.c
        pix[offsz + 0] = ((xorvec & -(font >> 7))) ^ bg;
        pix[offsz + 1] = ((xorvec & -(font >> 6 & 1))) ^ bg;
        pix[offsz + 2] = ((xorvec & -(font >> 5 & 1))) ^ bg;
        pix[offsz + 3] = ((xorvec & -(font >> 4 & 1))) ^ bg;
        pix[offsz + 4] = ((xorvec & -(font >> 3 & 1))) ^ bg;
        pix[offsz + 5] = ((xorvec & -(font >> 2 & 1))) ^ bg;
        pix[offsz + 6] = ((xorvec & -(font >> 1 & 1))) ^ bg;
        if ((chrpnt & 0xE0) == 0xC0)
            pix[offsz + 7] = pix[offsz + 8] = ((xorvec & -(font >> 0 & 1))) ^ bg; // Pretend ATTR 0x10 bit 5 is 1 (line graphics)
        else {
            pix[offsz + 7] = ((xorvec & -(font >> 0 & 1))) ^ bg;
            pix[offsz + 8] = bg;
        }
        // Move onto next scanline
        offsz += w;
    }
}

#define FLAG_NOFREE 1
static struct subwindow {
    int visible;
    int flags;
    uint8_t* textbuf;
    uint32_t* pixbuf;
    int h, w, ch, cw, x, y;
} subwindows[MAX_SUBWINDOWS];
static int num_subwindows = 0;

static void render_windows(void)
{
    uint32_t* pix = surface->pixels;
    for (int i = 0; i < num_subwindows; i++) {
        struct subwindow* sw = &subwindows[i];

        // Copy each scanline to the pixel buffer
        int pos = (w * sw->y) + sw->x;

        if (sw->x >= w || sw->y >= h)
            continue;

        // Figure out how many pixels per line we're going to copy
        int line_length = sw->w;
        if ((line_length + sw->x) > w) // If we go past the end of the screeen, simply truncate the screen
            line_length = w - sw->x; // i.e. if width was 640 pixels and we wanted to draw from 630 to 655, we'd draw 640 - 630 = 10 pixels and discard the other 655 - 640 = 15

        int scanlines = sw->h; // same thing for height
        if ((scanlines + sw->y) > h)
            scanlines = h - sw->y;

        int sw_pos = 0;

        for (int j = 0; j < scanlines; j++) {
            memcpy(&pix[pos], &sw->pixbuf[sw_pos], line_length * SCREEN_BYTPP);

            // Advance to next scanline
            sw_pos += sw->w;
            pos += w;
        }
    }
}

static void window_update_pixbuf(struct subwindow* sw)
{
    for (int i = 0; i < sw->ch; i++) {
        int cpos = i * sw->cw;
        for (int j = 0; j < sw->cw; j++) {
            int offsz = i * (CHAR_WIDTH * CHAR_HEIGHT * sw->cw) + j * CHAR_WIDTH;
            int cpos2 = (cpos + j) << 1;
            blit_chr(sw->textbuf[cpos2 | 0], sw->textbuf[cpos | 1], sw->pixbuf, offsz, sw->w);
        }
    }
}

static int create_subwindow(int chrwidth, int chrheight, int x, int y)
{
    // Find first free subwindow
    for (int i = 0; i < MAX_SUBWINDOWS; i++) {
        struct subwindow* sw = &subwindows[i];
        if (!sw->visible) {
            int chrsize = chrwidth * chrheight;

            sw->textbuf = malloc(chrsize << 1);
            sw->pixbuf = malloc(chrsize * (CHAR_WIDTH * CHAR_HEIGHT) * SCREEN_BYTPP);

            for (int j = 0; j < chrsize; j++) {
                ((uint16_t*)sw->textbuf)[j] = 0x0720; // gray on black, space
            }

            sw->ch = chrheight;
            sw->cw = chrwidth;
            sw->h = chrheight * CHAR_HEIGHT;
            sw->w = chrwidth * CHAR_WIDTH;

            sw->flags = 0;

            sw->x = x;
            sw->y = y;

            sw->visible = 1;

            // Increment num_subwindows if needed
            if (i >= num_subwindows)
                num_subwindows = i + 1; // we use num_subwindows in the count below

            window_update_pixbuf(sw);

            return i;
        }
    }
    return -1;
}

static int create_subwindow2(int chrwidth, int chrheight, char* textbuf, int x, int y)
{
    // Find first free subwindow
    for (int i = 0; i < MAX_SUBWINDOWS; i++) {
        struct subwindow* sw = &subwindows[i];
        if (!sw->visible) {
            int chrsize = chrwidth * chrheight;

            sw->textbuf = (uint8_t*)textbuf;
            sw->pixbuf = malloc(chrsize * (CHAR_WIDTH * CHAR_HEIGHT) * SCREEN_BYTPP);

            sw->ch = chrheight;
            sw->cw = chrwidth;
            sw->h = chrheight * CHAR_HEIGHT;
            sw->w = chrwidth * CHAR_WIDTH;

            sw->flags = FLAG_NOFREE;

            sw->x = x;
            sw->y = y;

            sw->visible = 1;

            // Increment num_subwindows if needed
            if (i >= num_subwindows)
                num_subwindows = i + 1; // we use num_subwindows in the count below

            window_update_pixbuf(sw);

            return i;
        }
    }
    return -1;
}

static void destroy_subwindow(int id)
{
    struct subwindow* sw = &subwindows[id];
    if (sw->visible) {
        free(sw->pixbuf);
        if (!(sw->flags & FLAG_NOFREE))
            free(sw->textbuf);
        sw->visible = 0;
        if (num_subwindows == (id + 1))
            num_subwindows--;
    }
}

static int menubar_idx_focus;

static void display_blit_menubar(void)
{
    uint32_t* pix = surface->pixels;

    // Draw characters, one by one, like the VGA alphanumeric renderer
    for (unsigned int i = 0; i < menubar_width; i++) {
        uint8_t atrchr = menubar_textbuffer[(i << 1) | 1],
                chrpnt = menubar_textbuffer[(i << 1) | 0];

        int offsz = i * CHAR_WIDTH;
        blit_chr(chrpnt, atrchr, pix, offsz, w);
    }
    UNUSED(menubar_overscan);
    display_update(0, h);
}
static void display_blit_statusbar(void)
{
    uint32_t *pix = surface->pixels, base = w * (h + CHAR_HEIGHT); // Screen size plus menu bar

    // Draw characters, one by one, like the VGA alphanumeric renderer
    for (unsigned int i = 0; i < menubar_width; i++) {
        uint8_t atrchr = statusbar_textbuffer[(i << 1) | 1],
                chrpnt = statusbar_textbuffer[(i << 1) | 0];

        int offsz = base + i * CHAR_WIDTH;
        blit_chr(chrpnt, atrchr, pix, offsz, w);
    }
    display_update(0, h);
}

static int make_menu_item(int index, int pos, char* name, topmenu_cb_t cbclick, struct menubar_listing* menulist)
{
    int len = strlen(name);
    menubar[index].name = name;
    menubar[index].cbclick = cbclick;
    menubar[index].cpos = pos;
    menubar[index].cwidth = len + 2;
    menubar[index].xoffs = pos * CHAR_WIDTH;
    menubar[index].twidth = (len + 2) * CHAR_WIDTH;
    menubar[index].menulist = menulist;

    return pos + len + 2;
}

static void menubar_blur(int index)
{
    struct menubar* menu = &menubar[index];
    for (int i = 0; i < menu->cwidth; i++) {
        menubar_textbuffer[((menu->cpos + i) << 1) | 1] = 0x70;
    }
    menubar_idx_focus = -1;
    display_blit_menubar();
    destroy_subwindow(menubar[index].attached_window);
}
static void menubar_focus(int index)
{
    struct menubar* menu = &menubar[index];
    for (int i = 0; i < menu->cwidth; i++) {
        menubar_textbuffer[((menu->cpos + i) << 1) | 1] = 0x07;
    }
    menubar_idx_focus = index;
    display_blit_menubar();
}
static void menubar_click(int index)
{
    menubar[index].cbclick(index);
}

static void realloc_bar_sizes(int width)
{
    uint32_t new_menubar_width = width / CHAR_WIDTH;
    if (menubar_width != new_menubar_width) {
        if (menubar_textbuffer)
            menubar_textbuffer = realloc(menubar_textbuffer, new_menubar_width << 1);
        else
            menubar_textbuffer = malloc(new_menubar_width << 1);

        // Menubar width
        if (statusbar_textbuffer)
            statusbar_textbuffer = realloc(statusbar_textbuffer, new_menubar_width << 1);
        else
            statusbar_textbuffer = malloc(new_menubar_width << 1);
    }
    menubar_width = new_menubar_width;
    menubar_overflow = width % CHAR_WIDTH;

    // Fill our menu bar with stuff

    // Window corner icon
    menubar_textbuffer[1] = 0x03;
    menubar_textbuffer[0] = 15;
    for (unsigned int i = 1; i < new_menubar_width; i++) {
        menubar_textbuffer[(i << 1) | 1] = 0x70; // fg black, bg gray
        menubar_textbuffer[(i << 1)] = ' ';
    }

    for (int i = 0; i < MAX_MENUBAR_ITEMS; i++) {
        if (!menubar[i].name)
            continue;
        int rpos = menubar[i].cpos << 1, len = strlen(menubar[i].name);
        // Add spacer before
        menubar_textbuffer[rpos++] = ' ';
        menubar_textbuffer[rpos++] = 0x70;

        // Copy menu entry
        for (int j = 0; j < len; j++) {
            menubar_textbuffer[rpos++] = menubar[i].name[j];
            menubar_textbuffer[rpos++] = 0x70;
        }

        menubar_textbuffer[rpos++] = ' ';
        menubar_textbuffer[rpos++] = 0x70;
    }

    // Render status bar
    for (unsigned int i = 0; i < new_menubar_width; i++) {
        statusbar_textbuffer[(i << 1)] = ' ';
        statusbar_textbuffer[(i << 1) | 1] = 0x30; // cyan bg, black fg
    }

    statusbar_textbuffer[0] = 'H';
    statusbar_textbuffer[2] = 'i';
}

#define PUTCHR(a, ps, c, attr)   \
    do {                         \
        a[(ps) << 1] = c;        \
        a[(ps) << 1 | 1] = attr; \
    } while (0)
#define THICK_MASK_TOP 1
#define THICK_MASK_LEFT 2
#define THICK_MASK_RIGHT 4
#define THICK_MASK_BOTTOM 8
#define NO_PIXBUF_UPDATE 16
// Draw a border around the window 'sw.' A bitmask in 'thick' decides whether the border should be thick (double-lined) or not.
// https://en.wikipedia.org/wiki/Box-drawing_character#DOS
static void draw_window_border(struct subwindow* sw, int thick, int attr)
{
    // Draw the upper left hand corner piece -- left and top
    int c;
    {
        int mask = thick & (THICK_MASK_TOP | THICK_MASK_LEFT);
        if (!mask)
            c = 0xDA; // no thick, all thin
        else if (mask == (THICK_MASK_LEFT | THICK_MASK_TOP))
            c = 0xC9; // left and top thick
        else if (mask == THICK_MASK_TOP)
            c = 0xD5; // left thin, top thick
        else // if(mask == THICK_MASK_LEFT)
            c = 0xD6; // left thick top thin
    }
    PUTCHR(sw->textbuf, 0, c, attr);
    c = thick & THICK_MASK_TOP ? 0xCD : 0xC4;
    for (int i = 1; i < (sw->cw - 1); i++)
        PUTCHR(sw->textbuf, i, c, attr);

    // Draw upper right hand corner piece.
    {
        int mask = thick & (THICK_MASK_TOP | THICK_MASK_RIGHT);
        if (!mask)
            c = 0xBF; // no thick, all thin
        else if (mask == (THICK_MASK_RIGHT | THICK_MASK_TOP))
            c = 0xBB; // right and top thick
        else if (mask == THICK_MASK_TOP)
            c = 0xB8; // right thin, top thick
        else // if(mask == THICK_MASK_LEFT)
            c = 0xB7; // right thick top thin
    }
    PUTCHR(sw->textbuf, sw->cw - 1, c, attr);

    // Now draw left and right bars
    c = thick & THICK_MASK_LEFT ? 0xBA : 0xB3;
    int c2 = thick & THICK_MASK_RIGHT ? 0xBA : 0xB3;
    int index = sw->cw;
    for (int i = 1; i < (sw->ch - 1); i++) {
        PUTCHR(sw->textbuf, index, c, attr);
        PUTCHR(sw->textbuf, index + sw->cw - 1, c2, attr);
        index += sw->cw;
    }

    // Lower left hand corner
    {
        int mask = thick & (THICK_MASK_BOTTOM | THICK_MASK_LEFT);
        if (!mask)
            c = 0xC0; // no thick, all thin
        else if (mask == (THICK_MASK_LEFT | THICK_MASK_BOTTOM))
            c = 0xC8; // left and bottom thick
        else if (mask == THICK_MASK_BOTTOM)
            c = 0xD4; // left thin, bottom thick
        else // if(mask == THICK_MASK_LEFT)
            c = 0xD3; // left thick bottom thin
    }
    PUTCHR(sw->textbuf, index, c, attr);
    index++;

    c = thick & THICK_MASK_BOTTOM ? 0xCD : 0xC4;
    for (int i = 1; i < (sw->cw - 1); i++, index++)
        PUTCHR(sw->textbuf, index, c, attr);

    // Final corner piece! Lower right hand corner
    {
        int mask = thick & (THICK_MASK_BOTTOM | THICK_MASK_RIGHT);
        if (!mask)
            c = 0xD9; // no thick, all thin
        else if (mask == (THICK_MASK_RIGHT | THICK_MASK_BOTTOM))
            c = 0xBC; // right and bottom thick
        else if (mask == THICK_MASK_BOTTOM)
            c = 0xBE; // right thin, bottom thick
        else // if(mask == THICK_MASK_LEFT)
            c = 0xBD; // right thick bottom thin
    }
    PUTCHR(sw->textbuf, index, c, attr);

    if (!(NO_PIXBUF_UPDATE & thick))
        window_update_pixbuf(sw);
}

// Called when one of the callbacks are triggered
static void render_menubar_info(int id)
{
    struct menubar* mb = &menubar[id];
    struct menubar_listing* ml = mb->menulist;
    int window = create_subwindow2(ml->max_width + 2, ml->max_height + 2, ml->textbuf, mb->xoffs, MENUBAR_HEIGHT);
    mb->attached_window = window;
}

static struct menubar_listing* init_menubar_listing(int sz)
{
    struct menubar_listing* mbl = malloc(sizeof(struct menubar_listing));
    mbl->nent = sz;
    mbl->entries = calloc(sizeof(char*), sz);
    mbl->offsets = calloc(sizeof(int), sz);
    mbl->cbs = calloc(sizeof(menu_click_cb), sz);
    mbl->max_height = mbl->max_width = 0;
    mbl->textbuf = NULL;
    return mbl;
}

#define SEPERATOR ")"

static int add_menu_entry(struct menubar_listing* mbl, int idx, char* value, menu_click_cb cb)
{
    int width = strlen(value);
    if (width > mbl->max_width)
        mbl->max_width = width;
    mbl->entries[idx] = value;
    mbl->cbs[idx] = cb;
    if (value[0] != ')' && value[1] != 0)
        mbl->offsets[idx] = (idx + 1) << 4;
    if (idx > mbl->max_height)
        mbl->max_height = idx + 1;
    return idx + 1;
}

static void finalize_menubar(struct menubar_listing* mbl)
{
    // Find out how tall/wide the window has to be
    // max_width is the maximum width of the menubar elements, and max_height is the number of elements.
    // Since we create a border around them that's one character wide, we add two to these values
    int width = mbl->max_width + 2;
    int height = mbl->max_height + 2;

    if (mbl->textbuf)
        free(mbl->textbuf);

    // Create a fake subwindow so that we can fool draw_window_border into thinking this is an actual window
    struct subwindow sw;
    sw.cw = width;
    sw.ch = height;
    uint8_t* textbuf = sw.textbuf = calloc(width * height, 2);
    mbl->textbuf = (char*)textbuf;
    draw_window_border(&sw, 0 | NO_PIXBUF_UPDATE, 0x07);

    // Now render each line of text
    int ncol = (width + 1) << 1;
    for (int i = 0; i < mbl->max_height; i++) {
        char* entry = mbl->entries[i];
        if (entry[0] == ')' && entry[1] == 0) {
            // Seperator!
            textbuf[ncol - 2] = 0xC6; // The |= box drawing char
            textbuf[ncol - 1] = 0x07;
            int k = 0;
            for (int j = 0; j < mbl->max_width; j++, k += 2) {
                textbuf[ncol + k] = 0xCD; // '=' box drawing character
                textbuf[ncol + k + 1] = 0x07;
            }
            textbuf[ncol + k] = 0xB5; // =|
            textbuf[ncol + k + 1] = 0x07;
        } else {
            int j = 0;
            while (*entry) {
                textbuf[ncol + j] = *entry;
                textbuf[ncol + j + 1] = 0x07;
                entry++;
                j += 2;
            }
        }
        ncol += width << 1;
    }
}

void display_set_resolution(int width, int height)
{
    resized = 1;
    if ((!width && !height)) {
        realloc_bar_sizes(640);
        display_set_resolution(640, 480 + MENUBAR_HEIGHT + STATUS_HEIGHT);
        return;
    }
    DISPLAY_LOG("Changed resolution to w=%d h=%d\n", width, height);
    // We reserve nine pixels at the top for our menu bar.
    surface = SDL_SetVideoMode(width, height + MENUBAR_HEIGHT + STATUS_HEIGHT, 32, SDL_SWSURFACE);
    realloc_bar_sizes(width);
    w = width;
    h = height;
    display_set_title();

#ifdef EMSCRIPTEN
    emscripten_handle_resize(surface->pixels, width, height);
#endif
    display_blit_menubar();
    display_blit_statusbar();
}

void display_update(int scanline_start, int scanlines)
{
    if (!resized)
        return;
    if ((w == 0) || (h == 0))
        return;
    if ((scanline_start + scanlines) > h) {
        printf("%d x %d [%d %d]\n", w, h, scanline_start, scanlines);
        ABORT();
    } else {
        render_windows();
#ifndef EMSCRIPTEN
        SDL_Flip(surface);
#else
        emscripten_flip();
#endif
        //SDL_UpdateRect(surface, 0, scanline_start, w, scanlines);
    }
}
void display_init(void)
{
    if (SDL_Init(SDL_INIT_VIDEO | SDL_INIT_NOPARACHUTE))
        DISPLAY_FATAL("Unable to initialize SDL");

    display_set_title();
    display_set_resolution(640, 480);

    resized = 0;
#ifdef EMSCRIPTEN
    display_mouse_capture_update(1);
#endif
    struct menubar_listing* menulist = init_menubar_listing(5);
    int idx = 0;
    idx = add_menu_entry(menulist, idx, SEPERATOR, NULL);
    idx = add_menu_entry(menulist, idx, "Exit", NULL);
    finalize_menubar(menulist);

    int menupos = 2;
    menupos = make_menu_item(0, menupos, "File", render_menubar_info, menulist);
    UNUSED(create_subwindow);
    UNUSED(destroy_subwindow);
}
void display_sleep(int ms)
{
    SDL_Delay(ms);
}

static void display_mouse_capture_update(int y)
{
    input_captured = y;
    SDL_WM_GrabInput(y);
    SDL_ShowCursor(SDL_TRUE ^ y);
    mouse_enabled = y;
    display_set_title();
}

void display_release_mouse(void)
{
    display_mouse_capture_update(0);
}

static void display_handle_mouse_click(SDL_Event* event)
{
    int k = event->type == SDL_MOUSEBUTTONDOWN ? MOUSE_STATUS_PRESSED : MOUSE_STATUS_RELEASED;
    switch (event->button.button) {
    case SDL_BUTTON_LEFT:
        kbd_mouse_down(k, MOUSE_STATUS_NOCHANGE, MOUSE_STATUS_NOCHANGE);
        break;
    case SDL_BUTTON_MIDDLE:
        kbd_mouse_down(MOUSE_STATUS_NOCHANGE, k, MOUSE_STATUS_NOCHANGE);
        break;
    case SDL_BUTTON_RIGHT:
#ifndef EMSCRIPTEN
        if (k == MOUSE_STATUS_PRESSED && !mouse_enabled) // Don't send anything
            display_mouse_capture_update(1);
        else
#endif
            kbd_mouse_down(MOUSE_STATUS_NOCHANGE, MOUSE_STATUS_NOCHANGE, k);
        break;
    }
    return;
}

void display_handle_events(void)
{
    SDL_Event event;
    while (SDL_PollEvent(&event)) {
        switch (event.type) {
        case SDL_QUIT:
            printf("QUIT\n");
            exit(0);
            break;
        case SDL_KEYDOWN:
            if (event.key.keysym.sym == SDLK_ESCAPE)
                display_release_mouse();
            break;
        case SDL_MOUSEBUTTONDOWN:
        case SDL_MOUSEBUTTONUP:
            if (input_captured)
                display_handle_mouse_click(&event);
            else {
                // Check where the click was.
                if (event.button.y <= MENUBAR_HEIGHT) {
                    if (event.type == SDL_MOUSEBUTTONDOWN) {
                        // Find out which element we clicked on.
                        if (menubar_idx_focus != -1)
                            menubar_blur(menubar_idx_focus);
                        int x = event.button.x, indx = -1;
                        for (int i = 0; i < MAX_MENUBAR_ITEMS; i++) {
                            if (!menubar[i].name)
                                continue;
                            unsigned int dx = x - menubar[i].xoffs;
                            // If (dx >= 0), that means we clicked to the right.
                            // If (dx < 0), then we clicked to the left and can safely ignore it.
                            if (dx <= (unsigned int)menubar[i].twidth) { // Handily catches both cases (note the unsigned int type for dx)
                                indx = i;
                                break;
                            }
                        }
                        if (indx != -1) {
                            menubar_focus(indx);
                            menubar_click(indx);
                        }
                    }
                } else {
                    if (menubar_idx_focus != -1) {
                        // Don't register a click to get rid of a menu bar item.
                        menubar_blur(menubar_idx_focus);
                    } else
                        // TODO: menu bar items
                        display_handle_mouse_click(&event);
                }
            }
        }
    }
    // TODO
}