# Type Checking

## Enabling Luau Type Checking in VS Code

1. Install the [Luau language server](https://marketplace.visualstudio.com/items?itemName=JohnnyMorganz.luau-lsp) for VS Code.
2. Open the `data` folder in VS Code.
3. Create a VS Code workspace settings file at `data/.vscode/settings.json`.
4. Add the following JSON configuration:
	```json
	{
		"luau-lsp.types.definitionFiles": ["scripts/lumix.d.lua"]
	}
	```
5. Create a `.luaurc` file in the `data/scripts/` directory with the following content:
	```json
	{
		"languageMode": "nonstrict",
		"lint": { "*": true, "FunctionUnused": false },
		"lintErrors": true,
		"globals": ["expect"]
	}
	```
6. Type checking should now be enabled. You can test it with the following script:
	```lua
	function onInputEvent(event : InputEvent)
		return event.some_prop
	end
	```

## Lumix Type Definitions

Lumix type definitions are available in the [lumix.d.lua](../../data/scripts/lumix.d.lua) file. This file is generated by [lua_type_defs.lua](../../data/editor/scripts/plugins/lua_type_defs.lua). 

To generate [lumix.d.lua](../../data/scripts/lumix.d.lua), do the following:

1. in [lua_type_defs.lua](../../data/editor/scripts/plugins/lua_type_defs.lua) change `if false then` to `if true then`.
2. (Re)start the Lumix editor.
3. There should be a `Lua type definitions` window available now.
4. Copy the content of `Lua type definitions` window and paste it in the [lumix.d.lua](../../data/scripts/lumix.d.lua) file.
