/**
 * @author Jiyao Wang <wangjiy@ncbi.nlm.nih.gov> / https://github.com/ncbi/icn3d
 */

class Dialog {
    constructor(icn3dui) {
        this.icn3dui = icn3dui;
    }

    //Open a dialog to input parameters. "id" is the id of the div section holding the html content.
    //"title" is the title of the dialog. The dialog can be out of the viewing area.
    openDlg(id, title) {  let me = this.icn3dui, ic = me.icn3d;
        if(me.bNode) return;

        id = me.pre + id;

        if(!me.cfg.notebook) {
            this.openDlgRegular(id, title);
        }
        else {
            this.openDlgNotebook(id, title);
        }

        if(!me.htmlCls.themecolor) me.htmlCls.themecolor = 'blue';

        me.htmlCls.setMenuCls.setTheme(me.htmlCls.themecolor);
    }

    addSaveButton(id) {  let me = this.icn3dui, ic = me.icn3d;
        if(me.bNode) return;

        // adda save button
        if(this.dialogHashSave === undefined || !this.dialogHashSave.hasOwnProperty(id)) {
            $("#" + id).parent().children('.ui-dialog-titlebar')
            .append("<div pid='" + id + "' class='icn3d-saveicon ui-icon ui-icon-disk' title='Save as an HTML file' style='background-color:white; background-image: url(&quot;https://www.ncbi.nlm.nih.gov/Structure/icn3d/lib/images/ui-icons_228ef1_256x240.png&quot;);'></div>");

            if(this.dialogHashSave === undefined) this.dialogHashSave = {}
            this.dialogHashSave[id] = 1;
        }
    }

    addHideButton(id) {  let me = this.icn3dui, ic = me.icn3d;
        if(me.bNode) return;

        // adda save button
        if(this.dialogHashHide === undefined || !this.dialogHashHide.hasOwnProperty(id)) {
            $("#" + id).parent().children('.ui-dialog-titlebar')
            .append("<div pid='" + id + "' class='icn3d-hideicon ui-icon ui-icon-arrowthick-2-ne-sw' title='Resize the window' style='background-color:white; background-image: url(&quot;https://www.ncbi.nlm.nih.gov/Structure/icn3d/lib/images/ui-icons_228ef1_256x240.png&quot;);'></div>");

            if(this.dialogHashHide === undefined) this.dialogHashHide = {}
            this.dialogHashHide[id] = 1;
        }
    }

    getDialogStatus() {  let me = this.icn3dui, ic = me.icn3d;
        if(me.bNode) return;

        let status = {};
        let id2flag = {};

        // determine whether dialogs initilaized
        let bSelectannotationsInit = $('#' + me.pre + 'dl_selectannotations').hasClass('ui-dialog-content'); // initialized
        let bGraph = $('#' + me.pre + 'dl_graph').hasClass('ui-dialog-content'); // initialized
        let bLineGraph = $('#' + me.pre + 'dl_linegraph').hasClass('ui-dialog-content'); // initialized
        let bScatterplot = $('#' + me.pre + 'dl_scatterplot').hasClass('ui-dialog-content'); // initialized
        let bLigplot = $('#' + me.pre + 'dl_ligplot').hasClass('ui-dialog-content'); // initialized
        let bContactmap = $('#' + me.pre + 'dl_contactmap').hasClass('ui-dialog-content'); // initialized
        let bAlignerrormap = $('#' + me.pre + 'dl_alignerrormap').hasClass('ui-dialog-content'); // initialized
        let bTable = $('#' + me.pre + 'dl_interactionsorted').hasClass('ui-dialog-content'); // initialized
        let bAlignmentInit = $('#' + me.pre + 'dl_alignment').hasClass('ui-dialog-content'); // initialized
        let bTwoddgmInit = $('#' + me.pre + 'dl_2ddgm').hasClass('ui-dialog-content'); // initialized
        let bTwodctnInit = $('#' + me.pre + 'dl_2dctn').hasClass('ui-dialog-content'); // initialized
        let bSetsInit = $('#' + me.pre + 'dl_definedsets').hasClass('ui-dialog-content'); // initialized

        status.bSelectannotationsInit2 = false, status.bGraph2 = false, status.bLineGraph2 = false;
        status.bScatterplot2 = false, status.bLigplot2 = false, status.bTable2 = false, status.bAlignmentInit2 = false;
        status.bTwoddgmInit2 = false, status.bTwodctnInit2 = false, status.bSetsInit2 = false;

        id2flag.dl_selectannotations = 'bSelectannotationsInit2';
        id2flag.dl_graph = 'bGraph2';
        id2flag.dl_linegraph = 'bLineGraph2';
        id2flag.dl_scatterplot = 'bScatterplot2';
        id2flag.dl_ligplot = 'bLigplot2';	
        id2flag.dl_contactmap = 'bContactmap2';
        id2flag.dl_alignerrormap = 'bAlignerrormap2';
        id2flag.dl_interactionsorted = 'bTable2';
        id2flag.dl_alignment = 'bAlignmentInit2';
        id2flag.dl_2ddgm = 'bTwoddgmInit2';
        id2flag.dl_2dctn = 'bTwodctnInit2';
        id2flag.dl_definedsets = 'bSetsInit2';

        if(bSelectannotationsInit) status.bSelectannotationsInit2 = $('#' + me.pre + 'dl_selectannotations').dialog( 'isOpen' );
        if(bGraph) status.bGraph2 = $('#' + me.pre + 'dl_graph').dialog( 'isOpen' );
        if(bLineGraph) status.bLineGraph2 = $('#' + me.pre + 'dl_linegraph').dialog( 'isOpen' );
        if(bScatterplot) status.bScatterplot2 = $('#' + me.pre + 'dl_scatterplot').dialog( 'isOpen' );
        if(bLigplot) status.bLigplot2 = $('#' + me.pre + 'dl_ligplot').dialog( 'isOpen' );
        if(bContactmap) status.bContactmap2 = $('#' + me.pre + 'dl_contactmap').dialog( 'isOpen' );
        if(bAlignerrormap) status.bAlignerror2 = $('#' + me.pre + 'dl_alignerrormap').dialog( 'isOpen' );
        if(bTable) status.bTable2 = $('#' + me.pre + 'dl_interactionsorted').dialog( 'isOpen' );
        if(bAlignmentInit) status.bAlignmentInit2 = $('#' + me.pre + 'dl_alignment').dialog( 'isOpen' );
        if(bTwoddgmInit) status.bTwoddgmInit2 = $('#' + me.pre + 'dl_2ddgm').dialog( 'isOpen' );
        if(bTwodctnInit) status.bTwodctnInit2 = $('#' + me.pre + 'dl_2dctn').dialog( 'isOpen' );
        if(bSetsInit) status.bSetsInit2 = $('#' + me.pre + 'dl_definedsets').dialog( 'isOpen' );

        return {status: status, id2flag: id2flag};
    }

    openDlgHalfWindow(id, title, dialogWidth, bForceResize) {  let me = this.icn3dui, ic = me.icn3d;
        if(me.bNode) return;

        let thisClass = this;

        let twoddgmWidth = me.htmlCls.width2d + 20;

        //ic.resizeCanvasCls.resizeCanvas(me.htmlCls.WIDTH - dialogWidth - me.htmlCls.LESSWIDTH, me.htmlCls.HEIGHT - me.htmlCls.LESSHEIGHT - me.htmlCls.EXTRAHEIGHT, bForceResize);
        ic.resizeCanvasCls.resizeCanvas(me.htmlCls.WIDTH - dialogWidth, me.htmlCls.HEIGHT, bForceResize);

        //height = me.htmlCls.HEIGHT - me.htmlCls.LESSHEIGHT - me.htmlCls.EXTRAHEIGHT;
        let height = me.htmlCls.HEIGHT;
        let width = dialogWidth;

        let position;
        if(me.cfg.showmenu && !me.utilsCls.isMobile() && !me.cfg.mobilemenu) {
            position ={ my: "left top", at: "right top+40", of: "#" + me.pre + "viewer", collision: "none" }
        }
        else {
            position ={ my: "left top", at: "right top", of: "#" + me.pre + "viewer", collision: "none" }
        }

        // disable resize
        me.cfg.resize = false;

        window.dialog = $( "#" + id ).dialog({
          autoOpen: true,
          title: title,
          height: height,
          width: width,
          modal: false,
          position: position,
          close: function(e) {
              let result = thisClass.getDialogStatus();
              let status = result.status;
              let id2flag = result.id2flag;

              // check the condition when all the rest dialogs are closed
              let bCheckAll = false;
              for(let idname in id2flag) {
                let bCheckRest = (id === me.pre + idname);
                for(let idstatus in status) {
                    // just check the rest, not itself
                    if(status.hasOwnProperty(idstatus)) continue;
                    bCheckRest = bCheckRest && !status[idstatus];
                }
                bCheckAll = bCheckAll || bCheckRest;
              }

              if(bCheckAll) {
                  if(status.bTwoddgmInit2 || status.bTwodctnInit2 || status.bSetsInit2) {
                      //ic.resizeCanvasCls.resizeCanvas(me.htmlCls.WIDTH - me.htmlCls.LESSWIDTH - twoddgmWidth, me.htmlCls.HEIGHT - me.htmlCls.LESSHEIGHT - me.htmlCls.EXTRAHEIGHT, true);
                      let canvasWidth = me.utilsCls.isMobile() ? me.htmlCls.WIDTH : me.htmlCls.WIDTH - twoddgmWidth;
                      ic.resizeCanvasCls.resizeCanvas(canvasWidth, me.htmlCls.HEIGHT, true);

                      if(status.bTwoddgmInit2) thisClass.openDlg2Ddgm(me.pre + 'dl_2ddgm', undefined, status.bSetsInit2);
                      if(status.bTwodctnInit2) thisClass.openDlg2Ddgm(me.pre + 'dl_2dctn', undefined, status.bSetsInit2);
                      if(status.bSetsInit2) thisClass.openDlg2Ddgm(me.pre + 'dl_definedsets');
                  }
                  else {
                      //ic.resizeCanvasCls.resizeCanvas(me.htmlCls.WIDTH - me.htmlCls.LESSWIDTH, me.htmlCls.HEIGHT - me.htmlCls.LESSHEIGHT - me.htmlCls.EXTRAHEIGHT, true);
                      ic.resizeCanvasCls.resizeCanvas(me.htmlCls.WIDTH, me.htmlCls.HEIGHT, true);
                  }
              }
          },
          resize: function(e) {
              if(id == me.pre + 'dl_selectannotations') {
                  ic.annotationCls.hideFixedTitle();
              }
              else if(id == me.pre + 'dl_graph') {
                  let width = $("#" + id).width();
                  let height = $("#" + id).height();

                  d3.select("#" + me.svgid).attr("width", width).attr("height", height);
              }
              else if(id == me.pre + 'dl_linegraph' || id == me.pre + 'dl_scatterplot' || id == me.pre + 'dl_ligplot' || id == me.pre + 'dl_contactmap' || id == me.pre + 'dl_alignerrormap') {
                  let oriWidth =(status.bTwoddgmInit2 || status.bSetsInit2) ?(me.htmlCls.WIDTH - twoddgmWidth)/2 : me.htmlCls.WIDTH / 2;
                  let ratio = $("#" + id).width() / oriWidth;

                  if(id == me.pre + 'dl_linegraph') {
                      let width = ic.linegraphWidth * ratio;
                      $("#" + me.linegraphid).attr("width", width);
                  }
                  else if(id == me.pre + 'dl_scatterplot') {
                      let width = ic.scatterplotWidth * ratio;
                      $("#" + me.scatterplotid).attr("width", width);
                  }
                  else if(id == me.pre + 'dl_ligplot') {
                    let width = ic.ligplotWidth * ratio;
                    $("#" + me.ligplotid).attr("width", width);
                  }
                  else if(id == me.pre + 'dl_ligplot') {
                    let width = ic.ligplotWidth * ratio;
                    $("#" + me.ligplotid).attr("width", width);
                }
                  else if(id == me.pre + 'dl_contactmap') {
                      let width = ic.contactmapWidth * ratio;
                      $("#" + me.contactmapid).attr("width", width);
                  }
                  else if(id == me.pre + 'dl_alignerrormap') {
                    let width = ic.alignerrormapWidth * ratio;
                    $("#" + me.alignerrormapid).attr("width", width);
                }
              }
          }
        });

        this.addSaveButton(id);
        this.addHideButton(id);
    }

    openDlg2Ddgm(id, inHeight, bDefinedSets) {  let me = this.icn3dui, ic = me.icn3d;
        if(me.bNode) return;

        let thisClass = this;

        let twoddgmWidth = me.htmlCls.width2d + 20;
        let at, title;
        if(id === me.pre + 'dl_definedsets') {
            at = "right top";
            title = 'Select sets';
        }
        else if(id === me.pre + 'dl_2ddgm' || id === me.pre + 'dl_2dctn') {
            if(bDefinedSets) {
                at = "right top+240";
            }
            else {
                at = "right top";
            }

            title = (id === me.pre + 'dl_2ddgm') ? '2D Diagram' : '2D Cartoon';
        }

        //var position ={ my: "left top", at: at, of: "#" + me.pre + "canvas", collision: "none" }
        let position ={ my: "left top+" + me.htmlCls.MENU_HEIGHT, at: at, of: "#" + me.pre + "viewer", collision: "none" }

        let height = 'auto';

        window.dialog = $( '#' + id ).dialog({
          autoOpen: true,
          title: title,
          height: height,
          width: twoddgmWidth,
          modal: false,
          position: position,
          close: function(e) {
              let status = thisClass.getDialogStatus().status;

              if((!status.bSelectannotationsInit2) &&(!status.bGraph2) &&(!status.bLineGraph2) &&(!status.bScatterplot2) &&(!status.bLigplot2) &&(!status.bTable2) &&(!status.bAlignmentInit2) ) {
                    //ic.resizeCanvasCls.resizeCanvas(me.htmlCls.WIDTH - me.htmlCls.LESSWIDTH, me.htmlCls.HEIGHT - me.htmlCls.LESSHEIGHT - me.htmlCls.EXTRAHEIGHT, true);
                    ic.resizeCanvasCls.resizeCanvas(me.htmlCls.WIDTH, me.htmlCls.HEIGHT, true);
              }
          },
          resize: function(e, ui) {
              if(id == me.pre + 'dl_2dctn') {
                ic.resizeRatioX = ui.size.width / me.htmlCls.width2d; //ui.originalSize.width;
                ic.resizeRatioY = ui.size.height / (me.htmlCls.width2d + 70); //ui.originalSize.height;
              }
          },
          resizeStop: function(e, ui) {
            ic.resizeRatioX = ui.size.width / me.htmlCls.width2d; //ui.originalSize.width;
            ic.resizeRatioY = ui.size.height / (me.htmlCls.width2d + 70); //ui.originalSize.height;
          }
        });

        this.addSaveButton(id);
        this.addHideButton(id);
    }

    openDlgRegular(id, title) {  let me = this.icn3dui, ic = me.icn3d;
        if(me.bNode) return;

        let width = 400, height = 150;
        let twoddgmWidth = me.htmlCls.width2d + 20;

        let status = this.getDialogStatus().status;

        if(id === me.pre + 'dl_selectannotations' || id === me.pre + 'dl_graph' || id === me.pre + 'dl_linegraph' || id === me.pre + 'dl_scatterplot' || id === me.pre + 'dl_ligplot' || id === me.pre + 'dl_contactmap'  || id === me.pre + 'dl_alignerrormap' || id === me.pre + 'dl_interactionsorted' || id === me.pre + 'dl_alignment') {
            //var dialogWidth = 0.5 *(me.htmlCls.WIDTH - me.htmlCls.LESSWIDTH) - twoddgmWidth * 0.5;
            let dialogWidth = 0.5 *(me.htmlCls.WIDTH) - twoddgmWidth * 0.5;

            //if(me.htmlCls.WIDTH - me.htmlCls.LESSWIDTH >= me.htmlCls.HEIGHT - me.htmlCls.LESSHEIGHT - me.htmlCls.EXTRAHEIGHT) {
            if(me.htmlCls.WIDTH >= me.htmlCls.HEIGHT) {
                this.openDlgHalfWindow(id, title, dialogWidth, true);

                if(status.bTwoddgmInit2 || status.bTwodctnInit2 || status.bSetsInit2) {
                    ic.resizeCanvasCls.resizeCanvas(me.htmlCls.WIDTH - dialogWidth - twoddgmWidth, me.htmlCls.HEIGHT, true);

                    if(status.bTwoddgmInit2) this.openDlg2Ddgm(me.pre + 'dl_2ddgm', undefined, status.bSetsInit2);
                    if(status.bTwodctnInit2) this.openDlg2Ddgm(me.pre + 'dl_2dctn', undefined, status.bSetsInit2);
                    if(status.bSetsInit2) this.openDlg2Ddgm(me.pre + 'dl_definedsets');
                }
            }
            else {
                //ic.resizeCanvasCls.resizeCanvas(me.htmlCls.WIDTH - me.htmlCls.LESSWIDTH,(me.htmlCls.HEIGHT - me.htmlCls.LESSHEIGHT - me.htmlCls.EXTRAHEIGHT) * 0.5, true);
                ic.resizeCanvasCls.resizeCanvas(me.htmlCls.WIDTH,(me.htmlCls.HEIGHT) * 0.5, true);

                //height =(me.htmlCls.HEIGHT - me.htmlCls.LESSHEIGHT - me.htmlCls.EXTRAHEIGHT) * 0.5;
                height =(me.htmlCls.HEIGHT) * 0.5;

                //width = me.htmlCls.WIDTH - me.htmlCls.LESSWIDTH;
                width = me.htmlCls.WIDTH;

                let position ={ my: "left top", at: "left bottom+32", of: "#" + me.pre + "canvas", collision: "none" }

                window.dialog = $( "#" + id ).dialog({
                  autoOpen: true,
                  title: title,
                  height: height,
                  width: width,
                  modal: false,
                  position: position,
                  close: function(e) {
                      if((id === me.pre + 'dl_selectannotations' &&(!status.bAlignmentInit2) &&(!status.bGraph2) &&(!status.bTable2) &&(!status.bLineGraph2) &&(!status.bScatterplot2) &&(!status.bLigplot2) &&(!status.bContactmap2) &&(!status.bAlignerrormap2))
                        ||(id === me.pre + 'dl_graph' &&(!status.bSelectannotationsInit2) &&(!status.bAlignmentInit2) &&(!status.bTable2) &&(!status.bLineGraph2) &&(!status.bScatterplot2) &&(!status.bLigplot2) &&(!status.bContactmap2) &&(!status.bAlignerrormap2))
                        ||(id === me.pre + 'dl_alignment' &&(!status.bSelectannotationsInit2) &&(!status.bGraph2) &&(!status.bTable2) &&(!status.bLineGraph2) &&(!status.bScatterplot2) &&(!status.bLigplot2) &&(!status.bContactmap2) &&(!status.bAlignerrormap2))
                        ||(id === me.pre + 'dl_interactionsorted' &&(!status.bSelectannotationsInit2) &&(!status.bGraph2) &&(!status.bAlignmentInit2) &&(!status.bLineGraph2) &&(!status.bScatterplot2) &&(!status.bLigplot2) &&(!status.bContactmap2) &&(!status.bAlignerrormap2))
                        ||(id === me.pre + 'dl_linegraph' &&(!status.bSelectannotationsInit2) &&(!status.bGraph2) &&(!status.bAlignmentInit2) &&(!status.bTable2) &&(!status.bScatterplot2) &&(!status.bLigplot2) &&(!status.bContactmap2) &&(!status.bAlignerrormap2))
                        ||(id === me.pre + 'dl_scatterplot' &&(!status.bSelectannotationsInit2) &&(!status.bGraph2) &&(!status.bAlignmentInit2) &&(!status.bTable2) &&(!status.bLineGraph2) &&(!status.bLigplot2) &&(!status.bContactmap2) &&(!status.bAlignerrormap2))
                        ||(id === me.pre + 'dl_ligplot' &&(!status.bSelectannotationsInit2) &&(!status.bGraph2) &&(!status.bAlignmentInit2) &&(!status.bTable2) &&(!status.bLineGraph2) &&(!status.bScatterplot2) &&(!status.bContactmap2) &&(!status.bAlignerrormap2))
                        ||(id === me.pre + 'dl_contactmap' &&(!status.bSelectannotationsInit2) &&(!status.bGraph2) &&(!status.bAlignmentInit2) &&(!status.bTable2) &&(!status.bLineGraph2) &&(!status.bScatterplot2) &&(!status.bLigplot2) &&(!status.bAlignerrormap2))
                        ||(id === me.pre + 'dl_alignerrormap' &&(!status.bSelectannotationsInit2) &&(!status.bGraph2) &&(!status.bAlignmentInit2) &&(!status.bTable2) &&(!status.bLineGraph2) &&(!status.bScatterplot2) &&(!status.bLigplot2) &&(!status.bContactmap2))
                        ) {
                          if(status.bTwoddgmInit2 || status.bTwodctnInit2 || status.bSetsInit2) {
                              let canvasWidth = me.utilsCls.isMobile() ? me.htmlCls.WIDTH : me.htmlCls.WIDTH - twoddgmWidth;
                              ic.resizeCanvasCls.resizeCanvas(canvasWidth, me.htmlCls.HEIGHT, true);

                              if(status.bTwoddgmInit2) thisClass.openDlg2Ddgm(me.pre + 'dl_2ddgm', undefined, status.bSetsInit2);
                              if(status.bTwodctnInit2) thisClass.openDlg2Ddgm(me.pre + 'dl_2dctn', undefined, status.bSetsInit2);
                              if(status.bSetsInit2) thisClass.openDlg2Ddgm(me.pre + 'dl_definedsets');
                          }
                          else {
                              //ic.resizeCanvasCls.resizeCanvas(me.htmlCls.WIDTH - me.htmlCls.LESSWIDTH, me.htmlCls.HEIGHT - me.htmlCls.LESSHEIGHT - me.htmlCls.EXTRAHEIGHT, true);
                              ic.resizeCanvasCls.resizeCanvas(me.htmlCls.WIDTH, me.htmlCls.HEIGHT, true);
                          }
                      }
                  },
                  resize: function(e) {
                      if(id == me.pre + 'dl_selectannotations') {
                          ic.annotationCls.hideFixedTitle();
                      }
                      else if(id == me.pre + 'dl_graph') {
                          let width = $("#" + id).width();
                          let height = $("#" + id).height();

                          d3.select("#" + me.svgid).attr("width", width).attr("height", height);
                      }
                      else if(id == me.pre + 'dl_linegraph' || id == me.pre + 'dl_scatterplot' || id == me.pre + 'dl_ligplot' || id == me.pre + 'dl_contactmap' || id == me.pre + 'dl_alignerrormap') {
                          let oriWidth =(status.bTwoddgmInit2 || status.bSetsInit2) ?(me.htmlCls.WIDTH - twoddgmWidth)/2 : me.htmlCls.WIDTH / 2;
                          let ratio = $("#" + id).width() / oriWidth;

                          if(id == me.pre + 'dl_linegraph') {
                              let width = ic.linegraphWidth * ratio;
                              $("#" + me.linegraphid).attr("width", width);
                          }
                          else if(id == me.pre + 'dl_scatterplot') {
                              let width = ic.scatterplotWidth * ratio;
                              $("#" + me.scatterplotid).attr("width", width);
                          }
                          else if(id == me.pre + 'dl_ligplot') {
                            let width = ic.ligplotWidth * ratio;
                            $("#" + me.ligplotid).attr("width", width);
                        }
                          else if(id == me.pre + 'dl_contactmap') {
                              let width = ic.contactmapWidth * ratio;
                              $("#" + me.contactmapid).attr("width", width);
                          }
                          else if(id == me.pre + 'dl_alignerrormap') {
                            let width = ic.alignerrormapWidth * ratio;
                            $("#" + me.alignerrormapid).attr("width", width);
                        }
                      }
                  }
                });

                this.addSaveButton(id);
                this.addHideButton(id);
            }
        }
        else if(id === me.pre + 'dl_2ddgm' || id === me.pre + 'dl_2dctn') {
            let tmpWidth = 0;

            //if(me.htmlCls.WIDTH - me.htmlCls.LESSWIDTH >= me.htmlCls.HEIGHT - me.htmlCls.LESSHEIGHT - me.htmlCls.EXTRAHEIGHT) {
            if(me.htmlCls.WIDTH >= me.htmlCls.HEIGHT) {
                if(status.bSelectannotationsInit2 || status.bGraph2 || status.bLineGraph2 || status.bScatterplot2 || status.bLigplot2 || status.bTable2 || status.bAlignmentInit2) {
                    //tmpWidth = 0.5 *(me.htmlCls.WIDTH - me.htmlCls.LESSWIDTH) - twoddgmWidth * 0.5;
                    tmpWidth = 0.5 *(me.htmlCls.WIDTH) - twoddgmWidth * 0.5;
                }
                //ic.resizeCanvasCls.resizeCanvas(me.htmlCls.WIDTH - me.htmlCls.LESSWIDTH - tmpWidth - twoddgmWidth, me.htmlCls.HEIGHT - me.htmlCls.LESSHEIGHT - me.htmlCls.EXTRAHEIGHT, true);
                ic.resizeCanvasCls.resizeCanvas(me.htmlCls.WIDTH - tmpWidth - twoddgmWidth, me.htmlCls.HEIGHT, true);

                this.openDlg2Ddgm(id, undefined, status.bSetsInit2);
            }
            else {
                //ic.resizeCanvasCls.resizeCanvas(me.htmlCls.WIDTH - me.htmlCls.LESSWIDTH - tmpWidth - twoddgmWidth,(me.htmlCls.HEIGHT - me.htmlCls.LESSHEIGHT - me.htmlCls.EXTRAHEIGHT)*0.5, true);
                let canvasWidth = me.utilsCls.isMobile() ? me.htmlCls.WIDTH : me.htmlCls.WIDTH - twoddgmWidth;
                ic.resizeCanvasCls.resizeCanvas(canvasWidth,(me.htmlCls.HEIGHT)*0.5, true);
                //this.openDlg2Ddgm(id,(me.htmlCls.HEIGHT - me.htmlCls.LESSHEIGHT - me.htmlCls.EXTRAHEIGHT)*0.5);
                this.openDlg2Ddgm(id,(me.htmlCls.HEIGHT)*0.5);

                //this.openDlg2Ddgm(id,(me.htmlCls.HEIGHT - me.htmlCls.LESSHEIGHT - me.htmlCls.EXTRAHEIGHT)*0.5, bSetsInit2);
                this.openDlg2Ddgm(id,(me.htmlCls.HEIGHT)*0.5, status.bSetsInit2);
            }
        }
        else {
            height = 'auto';
            width = 'auto';

            if(id === me.pre + 'dl_addtrack') {
                width='50%';
            }
            else if(id === me.pre + 'dl_menupref') {
                width = 800;
                height = 500;
            }
            
            let position;

            if(id === me.pre + 'dl_definedsets') {
                let tmpWidth = 0;

                //if(me.htmlCls.WIDTH - me.htmlCls.LESSWIDTH >= me.htmlCls.HEIGHT - me.htmlCls.LESSHEIGHT - me.htmlCls.EXTRAHEIGHT) {
                if(me.htmlCls.WIDTH >= me.htmlCls.HEIGHT) {
                    if(status.bSelectannotationsInit2 || status.bGraph2 || status.bLineGraph2 || status.bScatterplot2 || status.bLigplot2 || status.bTable2 || status.bAlignmentInit2) {
                        //tmpWidth = 0.5 *(me.htmlCls.WIDTH - me.htmlCls.LESSWIDTH) - twoddgmWidth * 0.5;
                        tmpWidth = 0.5 *(me.htmlCls.WIDTH) - twoddgmWidth * 0.5;
                    }
                    //ic.resizeCanvasCls.resizeCanvas(me.htmlCls.WIDTH - me.htmlCls.LESSWIDTH - tmpWidth - twoddgmWidth, me.htmlCls.HEIGHT - me.htmlCls.LESSHEIGHT - me.htmlCls.EXTRAHEIGHT, true);
                    ic.resizeCanvasCls.resizeCanvas(me.htmlCls.WIDTH - tmpWidth - twoddgmWidth, me.htmlCls.HEIGHT, true);
                    this.openDlg2Ddgm(id);

                    if(status.bTwoddgmInit2) this.openDlg2Ddgm(me.pre + 'dl_2ddgm', undefined, true);
                    if(status.bTwodctnInit2) this.openDlg2Ddgm(me.pre + 'dl_2dctn', undefined, true);
                }
                else {
                    //ic.resizeCanvasCls.resizeCanvas(me.htmlCls.WIDTH - me.htmlCls.LESSWIDTH - tmpWidth - twoddgmWidth,(me.htmlCls.HEIGHT - me.htmlCls.LESSHEIGHT - me.htmlCls.EXTRAHEIGHT)*0.5, true);
                    let canvasWidth = me.utilsCls.isMobile() ? me.htmlCls.WIDTH : me.htmlCls.WIDTH - twoddgmWidth;
                    ic.resizeCanvasCls.resizeCanvas(canvasWidth,(me.htmlCls.HEIGHT)*0.5, true);
                    //this.openDlg2Ddgm(id,(me.htmlCls.HEIGHT - me.htmlCls.LESSHEIGHT - me.htmlCls.EXTRAHEIGHT)*0.5);
                    this.openDlg2Ddgm(id,(me.htmlCls.HEIGHT)*0.5);

                    //if(bTwoddgmInit2) this.openDlg2Ddgm(me.pre + 'dl_2ddgm',(me.htmlCls.HEIGHT - me.htmlCls.LESSHEIGHT - me.htmlCls.EXTRAHEIGHT)*0.5, true);
                    if(status.bTwoddgmInit2) this.openDlg2Ddgm(me.pre + 'dl_2ddgm',(me.htmlCls.HEIGHT)*0.5, true);
                    if(status.bTwodctnInit2) this.openDlg2Ddgm(me.pre + 'dl_2dctn',(me.htmlCls.HEIGHT)*0.5, true);
                }
            }
            else {
                if(me.utilsCls.isMobile()) {
                    position ={ my: "left top", at: "left bottom-50", of: "#" + me.pre + "canvas", collision: "none" }
                }
                else if(id === me.pre + 'dl_allinteraction' || id === me.pre + 'dl_buriedarea') {
                    //position ={ my: "right top", at: "right top+50", of: "#" + me.pre + "dl_selectannotations", collision: "none" }
                    position ={ my: "right top", at: "right top+50", of: "#" + ic.divid, collision: "none" }

                    width = 700;
                    height = 500;
                }
                else if(id === me.pre + 'dl_rmsd') {
                    position ={ my: "left bottom", at: "left+20 bottom-20", of: "#" + me.pre + "canvas", collision: "none" }
                }
                else if(id === me.pre + 'dl_legend') {
                    position ={ my: "left bottom", at: "left+20 bottom-20", of: "#" + me.pre + "canvas", collision: "none" }
                }
                else if(id === me.pre + 'dl_symd') {
                    position ={ my: "left top", at: "right-200 bottom-200", of: "#" + me.pre + "canvas", collision: "none" }
                }
                else {
                    if(me.cfg.align) {
                        position ={ my: "left top", at: "left top+90", of: "#" + me.pre + "canvas", collision: "none" }
                    }
                    else if(id === me.pre + 'dl_mmdbafid') {
                        position ={ my: "left top", at: "left top+130", of: "#" + me.pre + "canvas", collision: "none" }
                    }
                    else {
                        position ={ my: "left top", at: "left top+50", of: "#" + me.pre + "canvas", collision: "none" };
                    }
                }

                window.dialog = $( "#" + id ).dialog({
                  autoOpen: true,
                  title: title,
                  height: height,
                  width: width,
                  modal: false,
                  position: position
                });

                this.addSaveButton(id);
                this.addHideButton(id);
            }
        }

        $(".ui-dialog .ui-button span")
          .removeClass("ui-icon-closethick")
          .addClass("ui-icon-close");
    }

    openDlgNotebook(id, title) {  let me = this.icn3dui, ic = me.icn3d;
        if(me.bNode) return;

        let width = 400, height = 150;
        let twoddgmWidth = me.htmlCls.width2d + 20;

        if(id === me.pre + 'dl_selectannotations' || id === me.pre + 'dl_graph' || id === me.pre + 'dl_linegraph' || id === me.pre + 'dl_scatterplot' || id === me.pre + 'dl_ligplot' || id === me.pre + 'dl_contactmap'  || id === me.pre + 'dl_alignerrormap' || id === me.pre + 'dl_interactionsorted' || id === me.pre + 'dl_alignment') {
            $( "#" + id ).show();
            $( "#" + id + "_nb").show();
            $( "#" + id + "_title").html(title);

            height =(me.htmlCls.HEIGHT) * 0.5;

            width = me.htmlCls.WIDTH;

            $( "#" + id ).width(width);
            $( "#" + id ).height(height);

            $( "#" + id ).resize(function(e) {
                  let oriWidth = me.htmlCls.WIDTH / 2;
                  let ratio = $("#" + id).width() / oriWidth;

                  if(id == me.pre + 'dl_selectannotations') {
                      ic.annotationCls.hideFixedTitle();
                  }
                  else if(id == me.pre + 'dl_graph') {
                      let width = $("#" + id).width();
                      let height = $("#" + id).height();

                      d3.select("#" + me.svgid).attr("width", width).attr("height", height);
                  }
                  else if(id == me.pre + 'dl_linegraph') {
                      let width = ic.linegraphWidth * ratio;

                      $("#" + me.linegraphid).attr("width", width);
                  }
                  else if(id == me.pre + 'dl_scatterplot') {
                      let width = ic.scatterplotWidth * ratio;

                      $("#" + me.scatterplotid).attr("width", width);
                  }
                  else if(id == me.pre + 'dl_ligplot') {
                    let width = ic.ligplotWidth * ratio;

                    $("#" + me.ligplotid).attr("width", width);
                  }
                  else if(id == me.pre + 'dl_contactmap') {
                      let width = ic.contactmapWidth * ratio;

                      $("#" + me.contactmapid).attr("width", width);
                  }
                  else if(id == me.pre + 'dl_alignerrormap') {
                    let width = ic.alignerrormapWidth * ratio;

                    $("#" + me.alignerrormapid).attr("width", width);
                }
            });
        }
        else {
            if(ic.bRender) {
                $( "#" + id ).show();
                $( "#" + id + "_nb").show();
                $( "#" + id + "_title").html(title);
            }

            height = 'auto';
            width = 'auto';

            if(id === me.pre + 'dl_addtrack') {
                width='50%';
            }
            else if(id === me.pre + 'dl_2ddgm' || id === me.pre + 'dl_2dctn' || id === me.pre + 'dl_definedsets') {
                width=twoddgmWidth;
            }
            else if(id === me.pre + 'dl_allinteraction' || id === me.pre + 'dl_buriedarea') {
                width = 700;
                height = 500;
            }

            $( "#" + id ).width(width);
            $( "#" + id ).height(height);
        }
    }
}

export {Dialog}
