/* ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * File Name:
 *
 * Author:  Jiyao Wang
 *
 * File Description:
 *
 */

#include "tmalignCgi.hpp"
/*
#include <ncbi_pch.hpp>
#include <corelib/ncbistd.hpp>
#include <corelib/ncbidiag.hpp>
#include <corelib/ncbistr.hpp>
#include <corelib/ncbiexpt.hpp>
#include <connect/ncbi_conn_stream.hpp>
#include <connect/ncbi_core_cxx.hpp>
#include <connect/ncbi_util.h>

#include <corelib/ncbi_system.hpp>

#include <cgi/ncbicgi.hpp>
#include <cgi/cgiapp.hpp>
#include <cgi/cgictx.hpp>
#include <html/html.hpp>
#include <html/page.hpp>
#include <corelib/ncbistre.hpp>
*/

#include <stdlib.h>
#include <string>

#include <time.h>

#include <cstdio>
#include <iostream>
#include <memory>
#include <stdexcept>
#include <string>
#include <array>

/*
USING_NCBI_SCOPE;
using namespace SHProjNS;

CConstRef<SHProjNS::CShdbInit> log_ini;
*/

CTmalignCgi::CTmalignCgi()
{
	m_output = "";
}

CTmalignCgi::~CTmalignCgi()
{
}

int main(int argc, const char* argv[])
{
	unique_ptr<CTmalignCgi> pTmalignCgi(new CTmalignCgi());
/*
	string line;
	getline(cin, line);

	size_t pos = line.find("||||||");
	pTmalignCgi->m_pdb_query = line.substr(0, pos);
	pTmalignCgi->m_pdb_target = line.substr(pos + 6);
*/
	string queryid, line;
	getline(cin, queryid);
	pTmalignCgi->m_queryid = queryid;

	bool bQuery = true;
	while (getline(cin, line)) {
		if(line == "||||||") {
			//cout<<"match 1"<<endl;
			//cout<<"pTmalignCgi->m_pdb_query "<<pTmalignCgi->m_pdb_query <<endl;
			bQuery = false;
		}
		else {
			if(bQuery) {
				pTmalignCgi->m_pdb_query += line + "\n";
			}
			else {
				pTmalignCgi->m_pdb_target += line + "\n";
			}
		}
	}

	pTmalignCgi->resi2igstrand();
	pTmalignCgi->igstrand2kabat();
	pTmalignCgi->igstrand2imgt();

//cout<<"pTmalignCgi->m_pdb_target "<<pTmalignCgi->m_pdb_target <<endl;

	pTmalignCgi->main_func();

	cout<<pTmalignCgi->m_output<<endl;

/*
	unique_ptr<CTmalignCgi> pTmalignCgi(new CTmalignCgi());

	// query, 2BNL_C
	pTmalignCgi->m_pdb_query = "ATOM   2144  N   SER C   3      11.566  97.480  18.298  1.00 42.94           N  \nATOM   2145  CA  SER C   3      12.864  97.540  17.444  1.00 43.05           C  \nATOM   2146  C   SER C   3      12.624  97.927  15.934  1.00 42.97           C  \nATOM   2147  O   SER C   3      11.852  97.282  15.198  1.00 45.09           O  \nATOM   2148  CB  SER C   3      13.744  96.319  17.528  1.00 42.68           C  \nATOM   2149  OG  SER C   3      14.750  96.252  16.498  1.00 37.69           O  \nATOM   2150  N   ASN C   4      13.321  98.975  15.526  1.00 38.28           N  \nATOM   2151  CA  ASN C   4      13.286  99.465  14.157  1.00 36.88           C  \nATOM   2152  C   ASN C   4      14.424  98.960  13.285  1.00 35.48           C  \nATOM   2153  O   ASN C   4      14.662  99.517  12.213  1.00 31.17           O  \nATOM   2154  CB  ASN C   4      13.320 100.985  14.212  1.00 37.44           C  \nATOM   2155  CG  ASN C   4      11.975 101.606  14.705  1.00 35.23           C  \nATOM   2156  OD1 ASN C   4      10.886 101.061  14.402  1.00 34.73           O  \nATOM   2157  ND2 ASN C   4      12.033 102.768  15.377  1.00 31.98           N  \nATOM   2158  N   GLN C   5      15.092  97.870  13.714  1.00 35.24           N  \nATOM   2159  CA  GLN C   5      16.275  97.343  13.054  1.00 34.41           C  \nATOM   2160  C   GLN C   5      16.050  96.939  11.636  1.00 35.22           C  \nATOM   2161  O   GLN C   5      16.870  97.330  10.805  1.00 34.00           O  \nATOM   2162  CB  GLN C   5      16.873  96.141  13.788  1.00 38.45           C  \nATOM   2163  CG  GLN C   5      17.581  96.572  15.083  1.00 41.73           C  \nATOM   2164  CD  GLN C   5      18.670  97.590  14.784  1.00 46.25           C  \nATOM   2165  OE1 GLN C   5      19.652  97.270  14.041  1.00 45.40           O  \nATOM   2166  NE2 GLN C   5      18.442  98.861  15.227  1.00 39.59           N  \nATOM   2167  N   THR C   6      15.009  96.130  11.336  1.00 34.63           N  \nATOM   2168  CA  THR C   6      14.869  95.641   9.953  1.00 33.66           C  \nATOM   2169  C   THR C   6      14.702  96.855   8.980  1.00 33.19           C  \nATOM   2170  O   THR C   6      15.365  96.931   7.967  1.00 31.00           O  \nATOM   2171  CB  THR C   6      13.658  94.694   9.799  1.00 35.47           C  \nATOM   2172  OG1 THR C   6      13.885  93.573  10.626  1.00 32.95           O  \nATOM   2173  CG2 THR C   6      13.427  94.210   8.315  1.00 36.35           C  \nATOM   2174  N   VAL C   7      13.840  97.812   9.319  1.00 31.66           N  \nATOM   2175  CA  VAL C   7      13.706  99.015   8.492  1.00 31.94           C  \nATOM   2176  C   VAL C   7      14.973  99.897   8.500  1.00 30.61           C  \nATOM   2177  O   VAL C   7      15.397 100.368   7.420  1.00 29.30           O  \nATOM   2178  CB  VAL C   7      12.418  99.792   8.842  1.00 31.27           C  \nATOM   2179  CG1 VAL C   7      12.255 101.066   7.987  1.00 28.89           C  \nATOM   2180  CG2 VAL C   7      11.196  98.860   8.650  1.00 31.46           C  \nATOM   2181  N   TYR C   8      15.525 100.187   9.668  1.00 29.46           N  \nATOM   2182  CA  TYR C   8      16.627 101.086   9.751  1.00 30.18           C  \nATOM   2183  C   TYR C   8      17.794 100.557   8.856  1.00 32.29           C  \nATOM   2184  O   TYR C   8      18.378 101.358   8.090  1.00 30.67           O  \nATOM   2185  CB  TYR C   8      17.096 101.307  11.210  1.00 31.16           C  \nATOM   2186  CG  TYR C   8      18.269 102.294  11.305  1.00 32.16           C  \nATOM   2187  CD1 TYR C   8      18.026 103.635  11.460  1.00 33.68           C  \nATOM   2188  CD2 TYR C   8      19.633 101.891  11.239  1.00 34.61           C  \nATOM   2189  CE1 TYR C   8      19.041 104.535  11.603  1.00 32.99           C  \nATOM   2190  CE2 TYR C   8      20.672 102.832  11.292  1.00 31.69           C  \nATOM   2191  CZ  TYR C   8      20.353 104.164  11.419  1.00 30.81           C  \nATOM   2192  OH  TYR C   8      21.273 105.207  11.470  1.00 33.46           O  \nATOM   2193  N   GLN C   9      18.147  99.263   9.025  1.00 31.43           N  \nATOM   2194  CA  GLN C   9      19.257  98.634   8.266  1.00 32.82           C  \nATOM   2195  C   GLN C   9      19.009  98.635   6.782  1.00 31.25           C  \nATOM   2196  O   GLN C   9      19.930  98.940   6.025  1.00 32.30           O  \nATOM   2197  CB  GLN C   9      19.424  97.171   8.718  1.00 35.50           C  \nATOM   2198  CG  GLN C   9      20.157  96.997  10.030  1.00 42.20           C  \nATOM   2199  CD  GLN C   9      20.022  95.520  10.660  1.00 51.13           C  \nATOM   2200  OE1 GLN C   9      19.600  94.537   9.983  1.00 53.90           O  \nATOM   2201  NE2 GLN C   9      20.347  95.403  11.975  1.00 51.76           N  \nATOM   2202  N   PHE C  10      17.745  98.425   6.368  1.00 29.84           N  \nATOM   2203  CA  PHE C  10      17.400  98.594   4.958  1.00 31.13           C  \nATOM   2204  C   PHE C  10      17.674  99.970   4.395  1.00 31.87           C  \nATOM   2205  O   PHE C  10      18.315 100.108   3.331  1.00 32.38           O  \nATOM   2206  CB  PHE C  10      15.972  98.133   4.679  1.00 33.57           C  \nATOM   2207  CG  PHE C  10      15.688  98.003   3.215  1.00 30.77           C  \nATOM   2208  CD1 PHE C  10      15.811  96.746   2.557  1.00 36.46           C  \nATOM   2209  CD2 PHE C  10      15.339  99.116   2.499  1.00 34.67           C  \nATOM   2210  CE1 PHE C  10      15.574  96.635   1.202  1.00 33.16           C  \nATOM   2211  CE2 PHE C  10      15.142  99.034   1.112  1.00 34.63           C  \nATOM   2212  CZ  PHE C  10      15.246  97.806   0.486  1.00 32.32           C  \nATOM   2213  N   ILE C  11      17.242 101.023   5.116  1.00 30.97           N  \nATOM   2214  CA  ILE C  11      17.607 102.366   4.739  1.00 29.91           C  \nATOM   2215  C   ILE C  11      19.080 102.581   4.637  1.00 29.78           C  \nATOM   2216  O   ILE C  11      19.559 103.067   3.584  1.00 28.67           O  \nATOM   2217  CB  ILE C  11      16.861 103.425   5.682  1.00 27.96           C  \nATOM   2218  CG1 ILE C  11      15.358 103.115   5.636  1.00 30.01           C  \nATOM   2219  CG2 ILE C  11      17.245 104.889   5.309  1.00 30.32           C  \nATOM   2220  CD1 ILE C  11      14.573 103.808   6.554  1.00 34.20           C  \nATOM   2221  N   ALA C  12      19.825 102.198   5.689  1.00 29.64           N  \nATOM   2222  CA  ALA C  12      21.247 102.384   5.731  1.00 30.57           C  \nATOM   2223  C   ALA C  12      21.961 101.741   4.594  1.00 31.56           C  \nATOM   2224  O   ALA C  12      22.872 102.345   4.065  1.00 33.64           O  \nATOM   2225  CB  ALA C  12      21.855 101.906   7.054  1.00 31.01           C  \nATOM   2226  N   GLU C  13      21.492 100.567   4.182  1.00 33.67           N  \nATOM   2227  CA  GLU C  13      22.136  99.750   3.171  1.00 34.42           C  \nATOM   2228  C   GLU C  13      21.662 100.070   1.789  1.00 34.41           C  \nATOM   2229  O   GLU C  13      22.292  99.604   0.882  1.00 33.57           O  \nATOM   2230  CB  GLU C  13      21.948  98.232   3.458  1.00 35.23           C  \nATOM   2231  CG  GLU C  13      22.605  97.852   4.774  1.00 40.00           C  \nATOM   2232  CD  GLU C  13      22.303  96.380   5.271  1.00 48.77           C  \nATOM   2233  OE1 GLU C  13      21.602  95.611   4.521  1.00 51.98           O  \nATOM   2234  OE2 GLU C  13      22.755  96.034   6.423  1.00 47.22           O  \nATOM   2235  N   ASN C  14      20.629 100.898   1.605  1.00 33.27           N  \nATOM   2236  CA  ASN C  14      20.034 101.193   0.285  1.00 33.16           C  \nATOM   2237  C   ASN C  14      19.838 102.682   0.045  1.00 33.28           C  \nATOM   2238  O   ASN C  14      18.890 103.087  -0.659  1.00 34.14           O  \nATOM   2239  CB  ASN C  14      18.704 100.410   0.077  1.00 31.91           C  \nATOM   2240  CG  ASN C  14      18.903  98.902   0.178  1.00 35.94           C  \nATOM   2241  OD1 ASN C  14      19.211  98.266  -0.822  1.00 37.04           O  \nATOM   2242  ND2 ASN C  14      18.726  98.322   1.386  1.00 31.01           N  \nATOM   2243  N   GLN C  15      20.773 103.460   0.554  1.00 33.58           N  \nATOM   2244  CA  GLN C  15      20.703 104.937   0.600  1.00 36.20           C  \nATOM   2245  C   GLN C  15      20.669 105.490  -0.811  1.00 36.58           C  \nATOM   2246  O   GLN C  15      19.855 106.360  -1.077  1.00 34.71           O  \nATOM   2247  CB  GLN C  15      21.906 105.544   1.303  1.00 36.18           C  \nATOM   2248  CG  GLN C  15      21.842 105.402   2.779  1.00 37.57           C  \nATOM   2249  CD  GLN C  15      23.085 105.914   3.400  1.00 34.80           C  \nATOM   2250  OE1 GLN C  15      23.426 107.064   3.158  1.00 36.96           O  \nATOM   2251  NE2 GLN C  15      23.753 105.113   4.227  1.00 37.46           N  \nATOM   2252  N   ASN C  16      21.505 104.939  -1.711  1.00 35.79           N  \nATOM   2253  CA  ASN C  16      21.586 105.518  -3.107  1.00 37.05           C  \nATOM   2254  C   ASN C  16      20.335 105.169  -3.862  1.00 34.06           C  \nATOM   2255  O   ASN C  16      19.776 105.988  -4.574  1.00 33.68           O  \nATOM   2256  CB  ASN C  16      22.726 104.976  -3.965  1.00 39.55           C  \nATOM   2257  CG  ASN C  16      24.017 105.347  -3.467  1.00 46.74           C  \nATOM   2258  OD1 ASN C  16      24.185 106.457  -2.957  1.00 55.16           O  \nATOM   2259  ND2 ASN C  16      24.996 104.429  -3.593  1.00 51.05           N  \nATOM   2260  N   GLU C  17      19.862 103.972  -3.689  1.00 32.98           N  \nATOM   2261  CA  GLU C  17      18.646 103.570  -4.400  1.00 34.63           C  \nATOM   2262  C   GLU C  17      17.431 104.291  -3.886  1.00 32.31           C  \nATOM   2263  O   GLU C  17      16.458 104.619  -4.604  1.00 30.06           O  \nATOM   2264  CB  GLU C  17      18.393 102.103  -4.119  1.00 38.35           C  \nATOM   2265  CG  GLU C  17      18.013 101.196  -5.222  1.00 45.08           C  \nATOM   2266  CD  GLU C  17      17.919  99.693  -4.654  1.00 52.06           C  \nATOM   2267  OE1 GLU C  17      19.024  99.165  -4.278  1.00 52.36           O  \nATOM   2268  OE2 GLU C  17      16.759  99.146  -4.489  1.00 51.34           O  \nATOM   2269  N   LEU C  18      17.365 104.422  -2.571  1.00 32.08           N  \nATOM   2270  CA  LEU C  18      16.217 105.186  -2.020  1.00 31.46           C  \nATOM   2271  C   LEU C  18      16.258 106.676  -2.446  1.00 32.01           C  \nATOM   2272  O   LEU C  18      15.227 107.247  -2.690  1.00 32.20           O  \nATOM   2273  CB  LEU C  18      16.172 105.038  -0.514  1.00 32.44           C  \nATOM   2274  CG  LEU C  18      15.845 103.644   0.031  1.00 28.75           C  \nATOM   2275  CD1 LEU C  18      15.772 103.548   1.542  1.00 32.91           C  \nATOM   2276  CD2 LEU C  18      14.497 103.270  -0.588  1.00 33.23           C  \nATOM   2277  N   LEU C  19      17.431 107.317  -2.433  1.00 33.44           N  \nATOM   2278  CA  LEU C  19      17.544 108.695  -2.906  1.00 33.78           C  \nATOM   2279  C   LEU C  19      16.937 108.813  -4.318  1.00 34.85           C  \nATOM   2280  O   LEU C  19      16.162 109.734  -4.601  1.00 32.98           O  \nATOM   2281  CB  LEU C  19      19.000 109.134  -2.987  1.00 34.78           C  \nATOM   2282  CG  LEU C  19      19.379 110.608  -3.367  1.00 36.68           C  \nATOM   2283  CD1 LEU C  19      18.832 111.582  -2.298  1.00 37.19           C  \nATOM   2284  CD2 LEU C  19      20.913 110.813  -3.502  1.00 45.03           C  \nATOM   2285  N   GLN C  20      17.299 107.878  -5.192  1.00 36.33           N  \nATOM   2286  CA  GLN C  20      16.778 107.915  -6.541  1.00 37.54           C  \nATOM   2287  C   GLN C  20      15.253 107.743  -6.555  1.00 36.22           C  \nATOM   2288  O   GLN C  20      14.543 108.482  -7.213  1.00 35.42           O  \nATOM   2289  CB  GLN C  20      17.443 106.854  -7.428  1.00 39.76           C  \nATOM   2290  CG  GLN C  20      17.343 107.183  -8.946  1.00 46.63           C  \nATOM   2291  CD  GLN C  20      18.354 108.309  -9.324  1.00 56.06           C  \nATOM   2292  OE1 GLN C  20      18.781 109.141  -8.454  1.00 61.92           O  \nATOM   2293  NE2 GLN C  20      18.801 108.298 -10.586  1.00 61.53           N  \nATOM   2294  N   LEU C  21      14.781 106.720  -5.849  1.00 35.97           N  \nATOM   2295  CA  LEU C  21      13.339 106.394  -5.757  1.00 34.45           C  \nATOM   2296  C   LEU C  21      12.546 107.569  -5.345  1.00 32.56           C  \nATOM   2297  O   LEU C  21      11.520 107.923  -5.961  1.00 32.81           O  \nATOM   2298  CB  LEU C  21      13.172 105.239  -4.718  1.00 34.26           C  \nATOM   2299  CG  LEU C  21      11.755 104.670  -4.637  1.00 38.13           C  \nATOM   2300  CD1 LEU C  21      11.412 103.995  -6.065  1.00 43.22           C  \nATOM   2301  CD2 LEU C  21      11.639 103.690  -3.440  1.00 37.62           C  \nATOM   2302  N   TRP C  22      12.959 108.186  -4.222  1.00 31.85           N  \nATOM   2303  CA  TRP C  22      12.220 109.311  -3.627  1.00 29.93           C  \nATOM   2304  C   TRP C  22      12.329 110.630  -4.445  1.00 31.84           C  \nATOM   2305  O   TRP C  22      11.367 111.332  -4.620  1.00 30.65           O  \nATOM   2306  CB  TRP C  22      12.648 109.471  -2.185  1.00 28.76           C  \nATOM   2307  CG  TRP C  22      12.172 108.366  -1.372  1.00 28.92           C  \nATOM   2308  CD1 TRP C  22      11.185 107.468  -1.706  1.00 29.45           C  \nATOM   2309  CD2 TRP C  22      12.636 107.968  -0.095  1.00 27.83           C  \nATOM   2310  NE1 TRP C  22      11.007 106.557  -0.723  1.00 30.44           N  \nATOM   2311  CE2 TRP C  22      11.894 106.814   0.283  1.00 31.04           C  \nATOM   2312  CE3 TRP C  22      13.663 108.374   0.710  1.00 30.99           C  \nATOM   2313  CZ2 TRP C  22      12.112 106.133   1.516  1.00 34.50           C  \nATOM   2314  CZ3 TRP C  22      13.819 107.727   1.970  1.00 31.42           C  \nATOM   2315  CH2 TRP C  22      13.069 106.657   2.346  1.00 32.03           C  \nATOM   2316  N   THR C  23      13.481 110.853  -5.073  1.00 32.72           N  \nATOM   2317  CA  THR C  23      13.632 111.953  -5.961  1.00 32.53           C  \nATOM   2318  C   THR C  23      12.642 111.761  -7.131  1.00 32.16           C  \nATOM   2319  O   THR C  23      11.959 112.696  -7.500  1.00 32.59           O  \nATOM   2320  CB  THR C  23      15.028 112.104  -6.508  1.00 31.33           C  \nATOM   2321  OG1 THR C  23      16.006 112.252  -5.468  1.00 30.27           O  \nATOM   2322  CG2 THR C  23      15.111 113.239  -7.492  1.00 34.51           C  \nATOM   2323  N   ASP C  24      12.596 110.573  -7.703  1.00 33.76           N  \nATOM   2324  CA  ASP C  24      11.677 110.287  -8.848  1.00 33.70           C  \nATOM   2325  C   ASP C  24      10.225 110.411  -8.432  1.00 32.00           C  \nATOM   2326  O   ASP C  24       9.408 110.902  -9.148  1.00 29.98           O  \nATOM   2327  CB  ASP C  24      11.942 108.895  -9.423  1.00 35.45           C  \nATOM   2328  CG  ASP C  24      13.284 108.807 -10.180  1.00 35.88           C  \nATOM   2329  OD1 ASP C  24      13.916 109.854 -10.450  1.00 34.90           O  \nATOM   2330  OD2 ASP C  24      13.805 107.677 -10.328  1.00 35.69           O  \nATOM   2331  N   THR C  25       9.922 109.961  -7.226  1.00 31.63           N  \nATOM   2332  CA  THR C  25       8.624 110.179  -6.596  1.00 32.35           C  \nATOM   2333  C   THR C  25       8.205 111.644  -6.506  1.00 31.11           C  \nATOM   2334  O   THR C  25       7.074 111.971  -6.878  1.00 32.79           O  \nATOM   2335  CB  THR C  25       8.533 109.454  -5.167  1.00 32.41           C  \nATOM   2336  OG1 THR C  25       8.866 108.092  -5.313  1.00 35.71           O  \nATOM   2337  CG2 THR C  25       7.151 109.522  -4.578  1.00 34.82           C  \nATOM   2338  N   LEU C  26       9.047 112.515  -5.998  1.00 29.71           N  \nATOM   2339  CA  LEU C  26       8.762 113.921  -5.938  1.00 30.00           C  \nATOM   2340  C   LEU C  26       8.580 114.493  -7.362  1.00 31.84           C  \nATOM   2341  O   LEU C  26       7.634 115.216  -7.613  1.00 31.24           O  \nATOM   2342  CB  LEU C  26       9.874 114.676  -5.201  1.00 29.71           C  \nATOM   2343  CG  LEU C  26       9.973 114.431  -3.697  1.00 29.11           C  \nATOM   2344  CD1 LEU C  26      11.283 114.918  -3.160  1.00 31.01           C  \nATOM   2345  CD2 LEU C  26       8.819 115.117  -3.048  1.00 31.81           C  \nATOM   2346  N   LYS C  27       9.416 114.077  -8.296  1.00 33.49           N  \nATOM   2347  CA  LYS C  27       9.268 114.545  -9.698  1.00 34.33           C  \nATOM   2348  C   LYS C  27       7.924 114.182 -10.258  1.00 32.45           C  \nATOM   2349  O   LYS C  27       7.258 115.018 -10.857  1.00 33.82           O  \nATOM   2350  CB  LYS C  27      10.387 113.998 -10.573  1.00 35.82           C  \nATOM   2351  CG  LYS C  27      11.789 114.602 -10.241  1.00 36.73           C  \nATOM   2352  CD  LYS C  27      12.939 113.981 -11.012  1.00 34.57           C  \nATOM   2353  CE  LYS C  27      12.695 113.885 -12.461  1.00 40.79           C  \nATOM   2354  NZ  LYS C  27      13.990 113.499 -13.008  1.00 40.74           N  \nATOM   2355  N   GLU C  28       7.502 112.942 -10.026  1.00 34.38           N  \nATOM   2356  CA  GLU C  28       6.239 112.426 -10.474  1.00 34.15           C  \nATOM   2357  C   GLU C  28       5.093 113.196  -9.935  1.00 35.85           C  \nATOM   2358  O   GLU C  28       4.199 113.660 -10.696  1.00 33.05           O  \nATOM   2359  CB  GLU C  28       6.144 110.936 -10.144  1.00 36.15           C  \nATOM   2360  CG  GLU C  28       4.881 110.287 -10.601  1.00 42.81           C  \nATOM   2361  CD  GLU C  28       4.776 108.806 -10.102  1.00 49.99           C  \nATOM   2362  OE1 GLU C  28       5.805 108.075 -10.109  1.00 49.85           O  \nATOM   2363  OE2 GLU C  28       3.656 108.431  -9.689  1.00 54.12           O  \nATOM   2364  N   LEU C  29       5.112 113.459  -8.626  1.00 34.04           N  \nATOM   2365  CA  LEU C  29       4.024 114.213  -8.002  1.00 34.24           C  \nATOM   2366  C   LEU C  29       4.053 115.658  -8.459  1.00 33.97           C  \nATOM   2367  O   LEU C  29       2.996 116.315  -8.660  1.00 34.38           O  \nATOM   2368  CB  LEU C  29       4.122 114.094  -6.497  1.00 33.14           C  \nATOM   2369  CG  LEU C  29       3.931 112.627  -5.991  1.00 37.69           C  \nATOM   2370  CD1 LEU C  29       4.276 112.529  -4.486  1.00 38.72           C  \nATOM   2371  CD2 LEU C  29       2.431 112.187  -6.202  1.00 41.64           C  \nATOM   2372  N   SER C  30       5.252 116.167  -8.709  1.00 32.86           N  \nATOM   2373  CA  SER C  30       5.340 117.563  -9.075  1.00 34.48           C  \nATOM   2374  C   SER C  30       4.670 117.757 -10.446  1.00 34.07           C  \nATOM   2375  O   SER C  30       4.248 118.866 -10.769  1.00 34.61           O  \nATOM   2376  CB  SER C  30       6.817 118.043  -9.127  1.00 35.52           C  \nATOM   2377  OG  SER C  30       7.465 117.567 -10.285  1.00 38.09           O  \nATOM   2378  N   GLU C  31       4.667 116.722 -11.284  1.00 35.60           N  \nATOM   2379  CA  GLU C  31       4.048 116.791 -12.626  1.00 38.25           C  \nATOM   2380  C   GLU C  31       2.534 117.094 -12.509  1.00 40.04           C  \nATOM   2381  O   GLU C  31       1.939 117.642 -13.408  1.00 39.55           O  \nATOM   2382  CB  GLU C  31       4.292 115.513 -13.435  1.00 38.39           C  \nATOM   2383  CG  GLU C  31       5.745 115.365 -13.892  1.00 41.03           C  \nATOM   2384  CD  GLU C  31       6.213 116.472 -14.879  1.00 46.83           C  \nATOM   2385  OE1 GLU C  31       5.383 117.227 -15.451  1.00 49.91           O  \nATOM   2386  OE2 GLU C  31       7.421 116.575 -15.132  1.00 50.06           O  \nATOM   2387  N   GLN C  32       1.902 116.766 -11.382  1.00 41.92           N  \nATOM   2388  CA  GLN C  32       0.489 117.142 -11.241  1.00 43.36           C  \nATOM   2389  C   GLN C  32       0.379 118.517 -10.647  1.00 44.37           C  \nATOM   2390  O   GLN C  32      -0.699 118.939 -10.380  1.00 45.85           O  \nATOM   2391  CB  GLN C  32      -0.296 116.195 -10.352  1.00 43.58           C  \nATOM   2392  CG  GLN C  32       0.179 114.747 -10.382  1.00 50.01           C  \nATOM   2393  CD  GLN C  32       0.241 114.187 -11.792  1.00 58.53           C  \nATOM   2394  OE1 GLN C  32      -0.728 114.370 -12.585  1.00 55.34           O  \nATOM   2395  NE2 GLN C  32       1.388 113.475 -12.123  1.00 61.69           N  \nATOM   2396  N   GLU C  33       1.463 119.237 -10.397  1.00 44.77           N  \nATOM   2397  CA  GLU C  33       1.316 120.602  -9.872  1.00 44.92           C  \nATOM   2398  C   GLU C  33       1.426 121.589 -11.023  1.00 45.69           C  \nATOM   2399  O   GLU C  33       1.726 121.216 -12.179  1.00 45.03           O  \nATOM   2400  CB  GLU C  33       2.364 120.893  -8.755  1.00 45.47           C  \nATOM   2401  CG  GLU C  33       2.297 120.024  -7.509  1.00 46.70           C  \nATOM   2402  CD  GLU C  33       0.856 119.800  -7.007  1.00 51.93           C  \nATOM   2403  OE1 GLU C  33       0.046 120.747  -7.091  1.00 52.93           O  \nATOM   2404  OE2 GLU C  33       0.518 118.661  -6.592  1.00 49.95           O  \nATOM   2405  N   SER C  34       1.205 122.868 -10.752  1.00 46.90           N  \nATOM   2406  CA  SER C  34       1.197 123.833 -11.889  1.00 48.81           C  \nATOM   2407  C   SER C  34       2.623 124.125 -12.394  1.00 47.32           C  \nATOM   2408  O   SER C  34       2.786 124.434 -13.560  1.00 47.52           O  \nATOM   2409  CB  SER C  34       0.427 125.149 -11.556  1.00 49.80           C  \nATOM   2410  OG  SER C  34       1.118 125.956 -10.583  1.00 54.28           O  \nATOM   2411  N   TYR C  35       3.636 123.973 -11.519  1.00 45.70           N  \nATOM   2412  CA  TYR C  35       5.051 124.063 -11.939  1.00 44.39           C  \nATOM   2413  C   TYR C  35       5.923 123.030 -11.176  1.00 41.52           C  \nATOM   2414  O   TYR C  35       5.507 122.445 -10.187  1.00 38.18           O  \nATOM   2415  CB  TYR C  35       5.595 125.478 -11.763  1.00 46.70           C  \nATOM   2416  CG  TYR C  35       5.688 125.955 -10.316  1.00 49.76           C  \nATOM   2417  CD1 TYR C  35       6.815 125.670  -9.501  1.00 53.75           C  \nATOM   2418  CD2 TYR C  35       4.661 126.679  -9.769  1.00 53.17           C  \nATOM   2419  CE1 TYR C  35       6.870 126.082  -8.121  1.00 52.05           C  \nATOM   2420  CE2 TYR C  35       4.717 127.132  -8.447  1.00 56.36           C  \nATOM   2421  CZ  TYR C  35       5.814 126.849  -7.619  1.00 56.73           C  \nATOM   2422  OH  TYR C  35       5.753 127.361  -6.294  1.00 57.40           O  \nATOM   2423  N   GLN C  36       7.082 122.727 -11.737  1.00 38.93           N  \nATOM   2424  CA  GLN C  36       7.950 121.665 -11.260  1.00 38.15           C  \nATOM   2425  C   GLN C  36       9.285 122.333 -10.958  1.00 38.91           C  \nATOM   2426  O   GLN C  36       9.785 123.056 -11.817  1.00 40.97           O  \nATOM   2427  CB  GLN C  36       8.146 120.601 -12.338  1.00 38.56           C  \nATOM   2428  CG  GLN C  36       6.904 119.739 -12.716  1.00 37.19           C  \nATOM   2429  CD  GLN C  36       5.952 120.531 -13.614  1.00 35.90           C  \nATOM   2430  OE1 GLN C  36       6.425 121.190 -14.528  1.00 38.81           O  \nATOM   2431  NE2 GLN C  36       4.684 120.598 -13.252  1.00 30.20           N  \nATOM   2432  N   LEU C  37       9.864 122.121  -9.757  1.00 36.45           N  \nATOM   2433  CA  LEU C  37      11.203 122.547  -9.497  1.00 36.32           C  \nATOM   2434  C   LEU C  37      12.201 121.558 -10.211  1.00 36.34           C  \nATOM   2435  O   LEU C  37      11.840 120.594 -10.970  1.00 35.19           O  \nATOM   2436  CB  LEU C  37      11.454 122.641  -7.970  1.00 35.95           C  \nATOM   2437  CG  LEU C  37      10.387 123.435  -7.170  1.00 35.80           C  \nATOM   2438  CD1 LEU C  37      10.426 123.270  -5.710  1.00 38.27           C  \nATOM   2439  CD2 LEU C  37      10.546 124.927  -7.502  1.00 41.46           C  \nATOM   2440  N   THR C  38      13.455 121.761  -9.966  1.00 34.05           N  \nATOM   2441  CA  THR C  38      14.443 121.059 -10.822  1.00 33.78           C  \nATOM   2442  C   THR C  38      14.791 119.830 -10.000  1.00 32.24           C  \nATOM   2443  O   THR C  38      14.512 119.785  -8.797  1.00 31.18           O  \nATOM   2444  CB  THR C  38      15.662 121.868 -11.081  1.00 32.70           C  \nATOM   2445  OG1 THR C  38      16.262 122.246  -9.826  1.00 34.98           O  \nATOM   2446  CG2 THR C  38      15.395 123.012 -12.004  1.00 36.48           C  \nATOM   2447  N   ASP C  39      15.379 118.844 -10.641  1.00 30.70           N  \nATOM   2448  CA  ASP C  39      15.743 117.626  -9.973  1.00 30.57           C  \nATOM   2449  C   ASP C  39      16.679 117.813  -8.803  1.00 31.40           C  \nATOM   2450  O   ASP C  39      16.547 117.090  -7.798  1.00 32.54           O  \nATOM   2451  CB  ASP C  39      16.483 116.768 -10.908  1.00 32.67           C  \nATOM   2452  CG  ASP C  39      15.550 116.158 -11.994  1.00 33.92           C  \nATOM   2453  OD1 ASP C  39      14.376 116.616 -12.196  1.00 36.37           O  \nATOM   2454  OD2 ASP C  39      16.051 115.209 -12.600  1.00 41.20           O  \nATOM   2455  N   GLN C  40      17.649 118.728  -8.902  1.00 28.57           N  \nATOM   2456  CA  GLN C  40      18.493 118.959  -7.775  1.00 30.95           C  \nATOM   2457  C   GLN C  40      17.751 119.413  -6.489  1.00 30.59           C  \nATOM   2458  O   GLN C  40      18.122 119.059  -5.372  1.00 29.95           O  \nATOM   2459  CB  GLN C  40      19.695 119.869  -8.153  1.00 31.47           C  \nATOM   2460  CG  GLN C  40      20.699 119.936  -6.936  1.00 33.78           C  \nATOM   2461  CD  GLN C  40      21.322 118.533  -6.698  1.00 39.09           C  \nATOM   2462  OE1 GLN C  40      21.787 117.961  -7.648  1.00 37.38           O  \nATOM   2463  NE2 GLN C  40      21.255 117.979  -5.484  1.00 34.21           N  \nATOM   2464  N   VAL C  41      16.716 120.218  -6.628  1.00 31.21           N  \nATOM   2465  CA  VAL C  41      15.913 120.633  -5.462  1.00 31.39           C  \nATOM   2466  C   VAL C  41      15.255 119.438  -4.774  1.00 31.61           C  \nATOM   2467  O   VAL C  41      15.221 119.286  -3.539  1.00 30.93           O  \nATOM   2468  CB  VAL C  41      14.871 121.639  -5.922  1.00 31.77           C  \nATOM   2469  CG1 VAL C  41      13.920 121.937  -4.788  1.00 33.71           C  \nATOM   2470  CG2 VAL C  41      15.520 122.903  -6.517  1.00 30.02           C  \nATOM   2471  N   TYR C  42      14.684 118.576  -5.606  1.00 30.03           N  \nATOM   2472  CA  TYR C  42      14.000 117.358  -5.132  1.00 31.01           C  \nATOM   2473  C   TYR C  42      14.960 116.382  -4.574  1.00 30.46           C  \nATOM   2474  O   TYR C  42      14.688 115.759  -3.566  1.00 28.86           O  \nATOM   2475  CB  TYR C  42      13.122 116.686  -6.217  1.00 29.29           C  \nATOM   2476  CG  TYR C  42      12.011 117.540  -6.679  1.00 30.18           C  \nATOM   2477  CD1 TYR C  42      11.134 118.161  -5.759  1.00 33.82           C  \nATOM   2478  CD2 TYR C  42      11.781 117.743  -7.995  1.00 33.90           C  \nATOM   2479  CE1 TYR C  42      10.073 118.926  -6.157  1.00 35.95           C  \nATOM   2480  CE2 TYR C  42      10.745 118.623  -8.428  1.00 34.05           C  \nATOM   2481  CZ  TYR C  42       9.909 119.176  -7.501  1.00 33.29           C  \nATOM   2482  OH  TYR C  42       8.963 120.063  -7.854  1.00 31.68           O  \nATOM   2483  N   GLU C  43      16.098 116.226  -5.231  1.00 29.81           N  \nATOM   2484  CA  GLU C  43      17.164 115.396  -4.695  1.00 30.45           C  \nATOM   2485  C   GLU C  43      17.635 115.845  -3.340  1.00 31.21           C  \nATOM   2486  O   GLU C  43      17.875 114.961  -2.392  1.00 28.32           O  \nATOM   2487  CB  GLU C  43      18.359 115.304  -5.679  1.00 31.19           C  \nATOM   2488  CG  GLU C  43      19.339 114.256  -5.285  1.00 36.49           C  \nATOM   2489  CD  GLU C  43      20.547 114.184  -6.181  1.00 41.25           C  \nATOM   2490  OE1 GLU C  43      20.373 113.857  -7.389  1.00 44.78           O  \nATOM   2491  OE2 GLU C  43      21.636 114.514  -5.671  1.00 43.24           O  \nATOM   2492  N   ASN C  44      17.871 117.164  -3.197  1.00 29.78           N  \nATOM   2493  CA  ASN C  44      18.188 117.680  -1.882  1.00 30.90           C  \nATOM   2494  C   ASN C  44      17.171 117.349  -0.768  1.00 30.49           C  \nATOM   2495  O   ASN C  44      17.505 117.080   0.383  1.00 30.02           O  \nATOM   2496  CB  ASN C  44      18.494 119.221  -1.958  1.00 30.77           C  \nATOM   2497  CG  ASN C  44      19.956 119.517  -2.262  1.00 33.53           C  \nATOM   2498  OD1 ASN C  44      20.637 118.703  -2.891  1.00 34.57           O  \nATOM   2499  ND2 ASN C  44      20.425 120.726  -1.910  1.00 33.06           N  \nATOM   2500  N   ILE C  45      15.900 117.479  -1.072  1.00 32.88           N  \nATOM   2501  CA  ILE C  45      14.855 117.191  -0.119  1.00 32.53           C  \nATOM   2502  C   ILE C  45      14.957 115.679   0.289  1.00 32.44           C  \nATOM   2503  O   ILE C  45      14.878 115.317   1.447  1.00 31.42           O  \nATOM   2504  CB  ILE C  45      13.484 117.445  -0.767  1.00 34.17           C  \nATOM   2505  CG1 ILE C  45      13.254 118.949  -0.788  1.00 37.36           C  \nATOM   2506  CG2 ILE C  45      12.381 116.749  -0.024  1.00 36.83           C  \nATOM   2507  CD1 ILE C  45      12.115 119.354  -1.635  1.00 43.54           C  \nATOM   2508  N   SER C  46      15.118 114.806  -0.719  1.00 32.20           N  \nATOM   2509  CA  SER C  46      15.208 113.367  -0.486  1.00 32.02           C  \nATOM   2510  C   SER C  46      16.375 113.090   0.475  1.00 29.43           C  \nATOM   2511  O   SER C  46      16.271 112.239   1.328  1.00 29.60           O  \nATOM   2512  CB  SER C  46      15.364 112.561  -1.814  1.00 30.21           C  \nATOM   2513  OG  SER C  46      14.127 112.810  -2.496  1.00 34.98           O  \nATOM   2514  N   LYS C  47      17.516 113.718   0.193  1.00 30.59           N  \nATOM   2515  CA  LYS C  47      18.737 113.522   0.954  1.00 31.03           C  \nATOM   2516  C   LYS C  47      18.559 113.953   2.385  1.00 31.08           C  \nATOM   2517  O   LYS C  47      18.946 113.259   3.320  1.00 32.13           O  \nATOM   2518  CB  LYS C  47      19.948 114.282   0.265  1.00 32.27           C  \nATOM   2519  CG  LYS C  47      21.217 114.048   0.923  1.00 37.63           C  \nATOM   2520  CD  LYS C  47      21.771 112.667   0.528  1.00 44.64           C  \nATOM   2521  CE  LYS C  47      23.194 112.370   1.151  1.00 47.62           C  \nATOM   2522  NZ  LYS C  47      23.324 112.835   2.634  1.00 47.42           N  \nATOM   2523  N   GLU C  48      17.998 115.142   2.567  1.00 31.95           N  \nATOM   2524  CA  GLU C  48      17.704 115.666   3.866  1.00 31.94           C  \nATOM   2525  C   GLU C  48      16.777 114.746   4.613  1.00 30.46           C  \nATOM   2526  O   GLU C  48      16.922 114.580   5.818  1.00 30.96           O  \nATOM   2527  CB  GLU C  48      17.023 117.007   3.741  1.00 32.42           C  \nATOM   2528  CG  GLU C  48      17.790 118.216   3.815  1.00 41.88           C  \nATOM   2529  CD  GLU C  48      16.725 119.479   3.891  1.00 50.17           C  \nATOM   2530  OE1 GLU C  48      16.335 120.178   5.011  1.00 41.73           O  \nATOM   2531  OE2 GLU C  48      16.233 119.659   2.744  1.00 44.20           O  \nATOM   2532  N   TYR C  49      15.744 114.233   3.934  1.00 29.64           N  \nATOM   2533  CA  TYR C  49      14.812 113.242   4.542  1.00 28.65           C  \nATOM   2534  C   TYR C  49      15.556 111.981   4.966  1.00 28.28           C  \nATOM   2535  O   TYR C  49      15.374 111.514   6.069  1.00 29.00           O  \nATOM   2536  CB  TYR C  49      13.636 112.917   3.619  1.00 29.23           C  \nATOM   2537  CG  TYR C  49      12.548 112.098   4.184  1.00 29.88           C  \nATOM   2538  CD1 TYR C  49      11.727 112.597   5.215  1.00 27.51           C  \nATOM   2539  CD2 TYR C  49      12.318 110.821   3.699  1.00 27.96           C  \nATOM   2540  CE1 TYR C  49      10.680 111.856   5.713  1.00 28.47           C  \nATOM   2541  CE2 TYR C  49      11.298 110.057   4.160  1.00 28.61           C  \nATOM   2542  CZ  TYR C  49      10.465 110.618   5.266  1.00 27.50           C  \nATOM   2543  OH  TYR C  49       9.440 109.866   5.731  1.00 28.41           O  \nATOM   2544  N   ILE C  50      16.428 111.454   4.131  1.00 29.12           N  \nATOM   2545  CA  ILE C  50      17.233 110.320   4.461  1.00 29.33           C  \nATOM   2546  C   ILE C  50      18.046 110.568   5.705  1.00 29.29           C  \nATOM   2547  O   ILE C  50      18.133 109.648   6.533  1.00 29.60           O  \nATOM   2548  CB  ILE C  50      18.078 109.792   3.299  1.00 29.90           C  \nATOM   2549  CG1 ILE C  50      17.193 109.205   2.176  1.00 31.59           C  \nATOM   2550  CG2 ILE C  50      19.009 108.747   3.760  1.00 38.10           C  \nATOM   2551  CD1 ILE C  50      17.901 109.098   0.790  1.00 37.69           C  \nATOM   2552  N   ASP C  51      18.613 111.740   5.829  1.00 28.42           N  \nATOM   2553  CA  ASP C  51      19.422 112.049   7.013  1.00 28.90           C  \nATOM   2554  C   ASP C  51      18.530 112.018   8.256  1.00 28.19           C  \nATOM   2555  O   ASP C  51      18.932 111.446   9.292  1.00 29.06           O  \nATOM   2556  CB  ASP C  51      20.074 113.368   6.901  1.00 30.17           C  \nATOM   2557  CG  ASP C  51      21.393 113.335   6.194  1.00 35.16           C  \nATOM   2558  OD1 ASP C  51      21.949 112.242   5.862  1.00 33.89           O  \nATOM   2559  OD2 ASP C  51      21.843 114.468   6.040  1.00 37.70           O  \nATOM   2560  N   ILE C  52      17.333 112.531   8.123  1.00 27.85           N  \nATOM   2561  CA  ILE C  52      16.362 112.468   9.189  1.00 29.62           C  \nATOM   2562  C   ILE C  52      16.111 111.013   9.569  1.00 29.21           C  \nATOM   2563  O   ILE C  52      16.113 110.672  10.773  1.00 30.57           O  \nATOM   2564  CB  ILE C  52      15.027 113.274   8.893  1.00 29.38           C  \nATOM   2565  CG1 ILE C  52      15.282 114.770   8.910  1.00 31.52           C  \nATOM   2566  CG2 ILE C  52      13.974 112.836   9.969  1.00 29.33           C  \nATOM   2567  CD1 ILE C  52      14.226 115.547   8.175  1.00 32.38           C  \nATOM   2568  N   LEU C  53      15.844 110.141   8.608  1.00 28.75           N  \nATOM   2569  CA  LEU C  53      15.591 108.742   8.902  1.00 29.53           C  \nATOM   2570  C   LEU C  53      16.772 108.093   9.694  1.00 31.49           C  \nATOM   2571  O   LEU C  53      16.549 107.362  10.669  1.00 28.77           O  \nATOM   2572  CB  LEU C  53      15.298 107.927   7.648  1.00 28.61           C  \nATOM   2573  CG  LEU C  53      14.211 108.502   6.732  1.00 28.32           C  \nATOM   2574  CD1 LEU C  53      14.027 107.574   5.602  1.00 29.46           C  \nATOM   2575  CD2 LEU C  53      12.959 108.690   7.511  1.00 28.57           C  \nATOM   2576  N   LEU C  54      17.990 108.373   9.275  1.00 31.86           N  \nATOM   2577  CA  LEU C  54      19.173 107.757   9.860  1.00 32.95           C  \nATOM   2578  C   LEU C  54      19.473 108.245  11.221  1.00 31.87           C  \nATOM   2579  O   LEU C  54      20.253 107.626  11.903  1.00 34.28           O  \nATOM   2580  CB  LEU C  54      20.396 107.900   8.968  1.00 31.55           C  \nATOM   2581  CG  LEU C  54      20.290 107.122   7.610  1.00 33.42           C  \nATOM   2582  CD1 LEU C  54      21.406 107.575   6.737  1.00 33.62           C  \nATOM   2583  CD2 LEU C  54      20.228 105.627   7.801  1.00 35.83           C  \nATOM   2584  N   LEU C  55      18.889 109.368  11.584  1.00 30.24           N  \nATOM   2585  CA  LEU C  55      18.930 109.831  12.964  1.00 30.57           C  \nATOM   2586  C   LEU C  55      17.811 109.301  13.845  1.00 31.24           C  \nATOM   2587  O   LEU C  55      17.833 109.447  15.035  1.00 31.82           O  \nATOM   2588  CB  LEU C  55      18.887 111.364  12.924  1.00 30.57           C  \nATOM   2589  CG  LEU C  55      20.050 112.039  12.294  1.00 28.09           C  \nATOM   2590  CD1 LEU C  55      19.822 113.553  12.237  1.00 31.77           C  \nATOM   2591  CD2 LEU C  55      21.373 111.760  13.058  1.00 27.64           C  \nATOM   2592  N   SER C  56      16.811 108.626  13.252  1.00 31.38           N  \nATOM   2593  CA  SER C  56      15.531 108.385  13.949  1.00 30.65           C  \nATOM   2594  C   SER C  56      15.354 106.858  14.260  1.00 30.87           C  \nATOM   2595  O   SER C  56      14.220 106.307  14.288  1.00 29.94           O  \nATOM   2596  CB  SER C  56      14.433 108.835  12.995  1.00 30.27           C  \nATOM   2597  OG  SER C  56      14.426 110.226  12.792  1.00 28.52           O  \nATOM   2598  N   VAL C  57      16.482 106.174  14.448  1.00 30.39           N  \nATOM   2599  CA  VAL C  57      16.441 104.691  14.753  1.00 32.52           C  \nATOM   2600  C   VAL C  57      15.508 104.357  15.971  1.00 32.62           C  \nATOM   2601  O   VAL C  57      14.867 103.287  15.972  1.00 32.51           O  \nATOM   2602  CB  VAL C  57      17.902 104.055  14.945  1.00 33.18           C  \nATOM   2603  CG1 VAL C  57      18.657 104.571  16.214  1.00 34.62           C  \nATOM   2604  CG2 VAL C  57      17.844 102.504  14.984  1.00 38.16           C  \nATOM   2605  N   LYS C  58      15.498 105.248  16.983  1.00 32.40           N  \nATOM   2606  CA  LYS C  58      14.689 105.126  18.182  1.00 34.35           C  \nATOM   2607  C   LYS C  58      13.336 105.743  17.980  1.00 34.99           C  \nATOM   2608  O   LYS C  58      12.288 105.099  18.095  1.00 36.91           O  \nATOM   2609  CB  LYS C  58      15.362 105.799  19.357  1.00 35.73           C  \nATOM   2610  CG  LYS C  58      14.575 105.695  20.615  1.00 40.03           C  \nATOM   2611  CD  LYS C  58      15.356 105.948  21.895  1.00 48.03           C  \nATOM   2612  CE  LYS C  58      15.407 107.406  22.244  1.00 52.89           C  \nATOM   2613  NZ  LYS C  58      15.664 107.597  23.772  1.00 57.11           N  \nATOM   2614  N   ASP C  59      13.335 107.003  17.633  1.00 35.54           N  \nATOM   2615  CA  ASP C  59      12.092 107.779  17.426  1.00 36.18           C  \nATOM   2616  C   ASP C  59      12.472 109.130  16.721  1.00 34.00           C  \nATOM   2617  O   ASP C  59      13.613 109.351  16.375  1.00 32.13           O  \nATOM   2618  CB  ASP C  59      11.311 107.978  18.771  1.00 38.05           C  \nATOM   2619  CG  ASP C  59      12.102 108.704  19.817  1.00 39.81           C  \nATOM   2620  OD1 ASP C  59      12.950 109.591  19.487  1.00 36.20           O  \nATOM   2621  OD2 ASP C  59      11.880 108.341  20.982  1.00 39.71           O  \nATOM   2622  N   GLU C  60      11.512 110.021  16.617  1.00 34.57           N  \nATOM   2623  CA  GLU C  60      11.649 111.335  15.955  1.00 35.62           C  \nATOM   2624  C   GLU C  60      12.361 112.440  16.752  1.00 36.26           C  \nATOM   2625  O   GLU C  60      12.473 113.554  16.239  1.00 35.14           O  \nATOM   2626  CB  GLU C  60      10.245 111.923  15.598  1.00 37.13           C  \nATOM   2627  CG  GLU C  60       9.420 112.478  16.816  1.00 37.55           C  \nATOM   2628  CD  GLU C  60       8.614 111.354  17.640  1.00 40.47           C  \nATOM   2629  OE1 GLU C  60       8.958 110.126  17.696  1.00 37.64           O  \nATOM   2630  OE2 GLU C  60       7.540 111.719  18.144  1.00 41.91           O  \nATOM   2631  N   ASN C  61      12.754 112.181  18.021  1.00 33.31           N  \nATOM   2632  CA  ASN C  61      13.307 113.246  18.800  1.00 33.50           C  \nATOM   2633  C   ASN C  61      14.798 113.656  18.448  1.00 31.85           C  \nATOM   2634  O   ASN C  61      15.119 114.830  18.485  1.00 30.49           O  \nATOM   2635  CB  ASN C  61      13.227 112.942  20.289  1.00 34.22           C  \nATOM   2636  CG  ASN C  61      11.808 112.814  20.783  1.00 40.00           C  \nATOM   2637  OD1 ASN C  61      11.436 111.793  21.389  1.00 44.29           O  \nATOM   2638  ND2 ASN C  61      10.997 113.791  20.450  1.00 40.78           N  \nATOM   2639  N   ALA C  62      15.687 112.698  18.183  1.00 31.05           N  \nATOM   2640  CA  ALA C  62      17.027 113.073  17.873  1.00 31.37           C  \nATOM   2641  C   ALA C  62      17.149 114.050  16.646  1.00 29.73           C  \nATOM   2642  O   ALA C  62      18.111 114.853  16.551  1.00 32.17           O  \nATOM   2643  CB  ALA C  62      17.914 111.814  17.654  1.00 30.99           C  \nATOM   2644  N   ALA C  63      16.296 113.827  15.639  1.00 32.44           N  \nATOM   2645  CA  ALA C  63      16.328 114.589  14.401  1.00 29.59           C  \nATOM   2646  C   ALA C  63      15.557 115.867  14.491  1.00 31.18           C  \nATOM   2647  O   ALA C  63      15.259 116.482  13.462  1.00 31.14           O  \nATOM   2648  CB  ALA C  63      15.774 113.713  13.282  1.00 31.50           C  \nATOM   2649  N   GLU C  64      15.317 116.395  15.693  1.00 31.08           N  \nATOM   2650  CA  GLU C  64      14.563 117.646  15.849  1.00 32.61           C  \nATOM   2651  C   GLU C  64      14.914 118.808  14.957  1.00 32.54           C  \nATOM   2652  O   GLU C  64      14.025 119.417  14.298  1.00 30.44           O  \nATOM   2653  CB  GLU C  64      14.505 118.138  17.385  1.00 34.85           C  \nATOM   2654  CG  GLU C  64      13.906 119.552  17.521  1.00 37.52           C  \nATOM   2655  CD  GLU C  64      13.657 119.959  19.066  1.00 45.80           C  \nATOM   2656  OE1 GLU C  64      14.136 119.240  19.905  1.00 49.03           O  \nATOM   2657  OE2 GLU C  64      12.976 120.957  19.403  1.00 52.61           O  \nATOM   2658  N   SER C  65      16.189 119.176  14.962  1.00 32.49           N  \nATOM   2659  CA  SER C  65      16.672 120.324  14.217  1.00 33.30           C  \nATOM   2660  C   SER C  65      16.603 120.129  12.729  1.00 33.44           C  \nATOM   2661  O   SER C  65      16.221 121.054  11.971  1.00 33.11           O  \nATOM   2662  CB  SER C  65      18.080 120.712  14.723  1.00 36.58           C  \nATOM   2663  OG  SER C  65      19.037 119.719  14.345  1.00 35.56           O  \nATOM   2664  N   GLN C  66      16.855 118.905  12.282  1.00 32.12           N  \nATOM   2665  CA  GLN C  66      16.702 118.566  10.871  1.00 31.18           C  \nATOM   2666  C   GLN C  66      15.272 118.658  10.406  1.00 30.23           C  \nATOM   2667  O   GLN C  66      14.983 119.059   9.290  1.00 30.36           O  \nATOM   2668  CB  GLN C  66      17.310 117.211  10.533  1.00 31.37           C  \nATOM   2669  CG  GLN C  66      18.859 117.285  10.536  1.00 31.46           C  \nATOM   2670  CD  GLN C  66      19.438 117.203  11.945  1.00 31.60           C  \nATOM   2671  OE1 GLN C  66      18.803 116.725  12.854  1.00 30.89           O  \nATOM   2672  NE2 GLN C  66      20.650 117.684  12.112  1.00 31.37           N  \nATOM   2673  N   ILE C  67      14.376 118.196  11.249  1.00 29.39           N  \nATOM   2674  CA  ILE C  67      12.960 118.117  10.948  1.00 31.87           C  \nATOM   2675  C   ILE C  67      12.419 119.527  10.778  1.00 33.05           C  \nATOM   2676  O   ILE C  67      11.749 119.877   9.777  1.00 32.74           O  \nATOM   2677  CB  ILE C  67      12.211 117.250  12.016  1.00 32.17           C  \nATOM   2678  CG1 ILE C  67      12.446 115.765  11.817  1.00 29.98           C  \nATOM   2679  CG2 ILE C  67      10.731 117.546  11.965  1.00 34.87           C  \nATOM   2680  CD1 ILE C  67      11.964 114.867  12.848  1.00 29.04           C  \nATOM   2681  N   SER C  68      12.841 120.403  11.711  1.00 34.27           N  \nATOM   2682  CA  SER C  68      12.452 121.777  11.670  1.00 32.89           C  \nATOM   2683  C   SER C  68      12.948 122.461  10.343  1.00 33.24           C  \nATOM   2684  O   SER C  68      12.224 123.208   9.663  1.00 31.03           O  \nATOM   2685  CB  SER C  68      12.974 122.479  12.953  1.00 33.49           C  \nATOM   2686  OG  SER C  68      12.724 123.855  12.755  1.00 39.28           O  \nATOM   2687  N   GLU C  69      14.209 122.233  10.007  1.00 33.23           N  \nATOM   2688  CA  GLU C  69      14.823 122.743   8.795  1.00 32.20           C  \nATOM   2689  C   GLU C  69      14.167 122.269   7.482  1.00 31.36           C  \nATOM   2690  O   GLU C  69      13.942 123.074   6.542  1.00 30.02           O  \nATOM   2691  CB  GLU C  69      16.304 122.378   8.829  1.00 33.82           C  \nATOM   2692  CG  GLU C  69      17.057 123.196   9.922  1.00 45.40           C  \nATOM   2693  CD  GLU C  69      18.434 122.602  10.341  1.00 51.64           C  \nATOM   2694  OE1 GLU C  69      18.940 121.726   9.610  1.00 60.73           O  \nATOM   2695  OE2 GLU C  69      18.987 123.033  11.390  1.00 56.47           O  \nATOM   2696  N   LEU C  70      13.800 120.995   7.435  1.00 31.21           N  \nATOM   2697  CA  LEU C  70      13.151 120.442   6.229  1.00 32.18           C  \nATOM   2698  C   LEU C  70      11.748 121.038   6.080  1.00 32.38           C  \nATOM   2699  O   LEU C  70      11.284 121.389   4.981  1.00 30.09           O  \nATOM   2700  CB  LEU C  70      13.070 118.930   6.320  1.00 31.52           C  \nATOM   2701  CG  LEU C  70      12.280 118.175   5.195  1.00 38.18           C  \nATOM   2702  CD1 LEU C  70      12.864 118.570   3.846  1.00 41.58           C  \nATOM   2703  CD2 LEU C  70      12.401 116.640   5.336  1.00 40.10           C  \nATOM   2704  N   ALA C  71      11.004 121.085   7.183  1.00 31.08           N  \nATOM   2705  CA  ALA C  71       9.610 121.626   7.143  1.00 31.41           C  \nATOM   2706  C   ALA C  71       9.627 123.082   6.691  1.00 32.31           C  \nATOM   2707  O   ALA C  71       8.842 123.493   5.847  1.00 32.81           O  \nATOM   2708  CB  ALA C  71       8.939 121.490   8.525  1.00 33.20           C  \nATOM   2709  N   LEU C  72      10.553 123.869   7.210  1.00 33.20           N  \nATOM   2710  CA  LEU C  72      10.668 125.275   6.803  1.00 34.31           C  \nATOM   2711  C   LEU C  72      11.048 125.382   5.374  1.00 33.02           C  \nATOM   2712  O   LEU C  72      10.610 126.238   4.677  1.00 30.61           O  \nATOM   2713  CB  LEU C  72      11.790 125.928   7.575  1.00 36.63           C  \nATOM   2714  CG  LEU C  72      11.927 127.432   7.464  1.00 41.12           C  \nATOM   2715  CD1 LEU C  72      10.665 128.264   7.829  1.00 41.07           C  \nATOM   2716  CD2 LEU C  72      13.048 127.865   8.408  1.00 46.88           C  \nATOM   2717  N   ARG C  73      11.953 124.539   4.941  1.00 32.77           N  \nATOM   2718  CA  ARG C  73      12.348 124.559   3.534  1.00 32.87           C  \nATOM   2719  C   ARG C  73      11.163 124.291   2.652  1.00 30.99           C  \nATOM   2720  O   ARG C  73      10.996 124.936   1.619  1.00 31.17           O  \nATOM   2721  CB  ARG C  73      13.434 123.509   3.268  1.00 35.43           C  \nATOM   2722  CG  ARG C  73      14.171 123.735   1.921  1.00 40.03           C  \nATOM   2723  CD  ARG C  73      15.258 122.633   1.686  1.00 48.32           C  \nATOM   2724  NE  ARG C  73      15.289 122.477   0.232  1.00 53.96           N  \nATOM   2725  CZ  ARG C  73      15.794 121.418  -0.440  1.00 56.52           C  \nATOM   2726  NH1 ARG C  73      16.371 120.397   0.269  1.00 49.67           N  \nATOM   2727  NH2 ARG C  73      15.762 121.406  -1.808  1.00 36.66           N  \nATOM   2728  N   ALA C  74      10.392 123.270   2.975  1.00 31.77           N  \nATOM   2729  CA  ALA C  74       9.168 122.955   2.223  1.00 29.63           C  \nATOM   2730  C   ALA C  74       8.227 124.104   2.010  1.00 29.49           C  \nATOM   2731  O   ALA C  74       7.712 124.349   0.889  1.00 29.81           O  \nATOM   2732  CB  ALA C  74       8.455 121.753   2.887  1.00 31.26           C  \nATOM   2733  N   VAL C  75       7.975 124.826   3.098  1.00 28.23           N  \nATOM   2734  CA  VAL C  75       7.169 126.026   3.090  1.00 30.81           C  \nATOM   2735  C   VAL C  75       7.780 127.120   2.186  1.00 32.24           C  \nATOM   2736  O   VAL C  75       7.063 127.659   1.311  1.00 32.35           O  \nATOM   2737  CB  VAL C  75       7.079 126.642   4.470  1.00 29.54           C  \nATOM   2738  CG1 VAL C  75       6.325 127.963   4.384  1.00 32.94           C  \nATOM   2739  CG2 VAL C  75       6.346 125.662   5.441  1.00 31.82           C  \nATOM   2740  N   GLN C  76       9.081 127.385   2.354  1.00 31.74           N  \nATOM   2741  CA  GLN C  76       9.706 128.493   1.583  1.00 33.37           C  \nATOM   2742  C   GLN C  76       9.759 128.219   0.055  1.00 34.01           C  \nATOM   2743  O   GLN C  76       9.597 129.154  -0.735  1.00 36.79           O  \nATOM   2744  CB  GLN C  76      11.092 128.748   2.119  1.00 34.41           C  \nATOM   2745  CG  GLN C  76      11.037 129.340   3.510  1.00 37.88           C  \nATOM   2746  CD  GLN C  76      12.413 129.572   4.094  1.00 40.70           C  \nATOM   2747  OE1 GLN C  76      13.337 128.795   3.900  1.00 48.51           O  \nATOM   2748  NE2 GLN C  76      12.548 130.645   4.826  1.00 48.12           N  \nATOM   2749  N   ILE C  77       9.989 126.980  -0.334  1.00 33.44           N  \nATOM   2750  CA  ILE C  77      10.026 126.624  -1.742  1.00 34.64           C  \nATOM   2751  C   ILE C  77       8.684 126.473  -2.419  1.00 36.39           C  \nATOM   2752  O   ILE C  77       8.648 126.206  -3.634  1.00 35.39           O  \nATOM   2753  CB  ILE C  77      10.934 125.419  -2.009  1.00 33.66           C  \nATOM   2754  CG1 ILE C  77      10.383 124.131  -1.484  1.00 33.52           C  \nATOM   2755  CG2 ILE C  77      12.291 125.688  -1.400  1.00 37.18           C  \nATOM   2756  CD1 ILE C  77      11.201 122.965  -1.860  1.00 36.77           C  \nATOM   2757  N   GLY C  78       7.620 126.465  -1.616  1.00 35.24           N  \nATOM   2758  CA  GLY C  78       6.282 126.459  -2.114  1.00 36.58           C  \nATOM   2759  C   GLY C  78       5.621 125.082  -2.160  1.00 34.85           C  \nATOM   2760  O   GLY C  78       4.683 124.925  -2.887  1.00 34.33           O  \nATOM   2761  N   LEU C  79       6.104 124.099  -1.399  1.00 32.43           N  \nATOM   2762  CA  LEU C  79       5.404 122.851  -1.269  1.00 32.93           C  \nATOM   2763  C   LEU C  79       4.249 123.069  -0.296  1.00 31.25           C  \nATOM   2764  O   LEU C  79       4.459 123.487   0.840  1.00 32.23           O  \nATOM   2765  CB  LEU C  79       6.252 121.681  -0.826  1.00 31.69           C  \nATOM   2766  CG  LEU C  79       7.630 121.512  -1.579  1.00 34.70           C  \nATOM   2767  CD1 LEU C  79       8.306 120.236  -1.086  1.00 36.48           C  \nATOM   2768  CD2 LEU C  79       7.379 121.459  -3.034  1.00 41.14           C  \nATOM   2769  N   SER C  80       3.059 122.717  -0.735  1.00 29.80           N  \nATOM   2770  CA  SER C  80       1.878 122.641   0.165  1.00 28.53           C  \nATOM   2771  C   SER C  80       1.970 121.522   1.183  1.00 27.70           C  \nATOM   2772  O   SER C  80       2.619 120.542   0.950  1.00 26.97           O  \nATOM   2773  CB  SER C  80       0.562 122.587  -0.691  1.00 29.27           C  \nATOM   2774  OG  SER C  80       0.454 121.306  -1.233  1.00 28.40           O  \nATOM   2775    N MSE C  81       1.154 121.598   2.245  1.00 28.21           N  \nATOM   2776   CA MSE C  81       1.052 120.535   3.217  1.00 26.99           C  \nATOM   2777    C MSE C  81       0.501 119.338   2.436  1.00 27.49           C  \nATOM   2778    O MSE C  81       0.858 118.197   2.669  1.00 28.37           O  \nATOM   2779   CB MSE C  81       0.148 120.975   4.399  1.00 24.53           C  \nATOM   2780   CG MSE C  81      -0.311 119.850   5.148  1.00 27.61           C  \nATOM   2781   SE MSE C  81       1.239 119.133   6.319  1.00 46.97          SE  \nATOM   2782   CE MSE C  81       1.163 117.968   5.844  1.00 41.99           C  \nATOM   2783  N   LYS C  82      -0.445 119.594   1.553  1.00 26.27           N  \nATOM   2784  CA  LYS C  82      -1.031 118.465   0.803  1.00 26.74           C  \nATOM   2785  C   LYS C  82       0.003 117.687  -0.035  1.00 27.28           C  \nATOM   2786  O   LYS C  82       0.055 116.456   0.032  1.00 29.22           O  \nATOM   2787  CB  LYS C  82      -2.080 118.976  -0.074  1.00 28.74           C  \nATOM   2788  CG  LYS C  82      -2.803 117.979  -0.945  1.00 33.24           C  \nATOM   2789  CD  LYS C  82      -3.590 116.970  -0.130  1.00 33.56           C  \nATOM   2790  CE  LYS C  82      -4.502 116.112  -1.026  1.00 38.17           C  \nATOM   2791  NZ  LYS C  82      -5.673 115.469  -0.406  1.00 37.40           N  \nATOM   2792  N   PHE C  83       0.855 118.458  -0.717  1.00 27.12           N  \nATOM   2793  CA  PHE C  83       1.914 117.855  -1.545  1.00 28.81           C  \nATOM   2794  C   PHE C  83       2.903 117.111  -0.652  1.00 26.98           C  \nATOM   2795  O   PHE C  83       3.260 115.956  -0.919  1.00 28.03           O  \nATOM   2796  CB  PHE C  83       2.594 118.927  -2.293  1.00 30.59           C  \nATOM   2797  CG  PHE C  83       3.730 118.418  -3.164  1.00 31.63           C  \nATOM   2798  CD1 PHE C  83       3.421 118.060  -4.493  1.00 34.54           C  \nATOM   2799  CD2 PHE C  83       5.011 118.237  -2.651  1.00 30.83           C  \nATOM   2800  CE1 PHE C  83       4.434 117.552  -5.317  1.00 35.76           C  \nATOM   2801  CE2 PHE C  83       6.060 117.683  -3.488  1.00 35.66           C  \nATOM   2802  CZ  PHE C  83       5.714 117.352  -4.812  1.00 32.59           C  \nATOM   2803  N   LEU C  84       3.372 117.781   0.382  1.00 28.36           N  \nATOM   2804  CA  LEU C  84       4.324 117.168   1.346  1.00 29.44           C  \nATOM   2805  C   LEU C  84       3.816 115.833   1.951  1.00 29.14           C  \nATOM   2806  O   LEU C  84       4.509 114.827   1.963  1.00 28.04           O  \nATOM   2807  CB  LEU C  84       4.713 118.164   2.425  1.00 29.98           C  \nATOM   2808  CG  LEU C  84       5.722 117.623   3.509  1.00 33.77           C  \nATOM   2809  CD1 LEU C  84       7.010 117.171   2.775  1.00 34.97           C  \nATOM   2810  CD2 LEU C  84       5.962 118.657   4.610  1.00 40.22           C  \nATOM   2811  N   ALA C  85       2.595 115.882   2.491  1.00 30.06           N  \nATOM   2812  CA  ALA C  85       2.025 114.695   3.075  1.00 31.36           C  \nATOM   2813  C   ALA C  85       1.753 113.575   2.061  1.00 31.78           C  \nATOM   2814  O   ALA C  85       1.903 112.423   2.372  1.00 29.52           O  \nATOM   2815  CB  ALA C  85       0.726 115.031   3.798  1.00 31.06           C  \nATOM   2816  N   THR C  86       1.298 113.948   0.877  1.00 28.76           N  \nATOM   2817  CA  THR C  86       1.156 112.958  -0.208  1.00 29.34           C  \nATOM   2818  C   THR C  86       2.482 112.367  -0.532  1.00 29.12           C  \nATOM   2819  O   THR C  86       2.596 111.137  -0.726  1.00 29.04           O  \nATOM   2820  CB  THR C  86       0.532 113.589  -1.467  1.00 28.41           C  \nATOM   2821  OG1 THR C  86      -0.707 114.181  -1.068  1.00 30.47           O  \nATOM   2822  CG2 THR C  86       0.274 112.532  -2.604  1.00 33.15           C  \nATOM   2823  N   ALA C  87       3.501 113.196  -0.677  1.00 27.09           N  \nATOM   2824  CA  ALA C  87       4.840 112.648  -0.938  1.00 29.96           C  \nATOM   2825  C   ALA C  87       5.427 111.678   0.096  1.00 31.59           C  \nATOM   2826  O   ALA C  87       5.902 110.609  -0.257  1.00 29.40           O  \nATOM   2827  CB  ALA C  87       5.802 113.769  -1.204  1.00 31.65           C  \nATOM   2828  N   LEU C  88       5.361 112.064   1.376  1.00 30.38           N  \nATOM   2829  CA  LEU C  88       5.850 111.225   2.480  1.00 32.64           C  \nATOM   2830  C   LEU C  88       5.039 109.953   2.571  1.00 33.07           C  \nATOM   2831  O   LEU C  88       5.674 108.917   2.755  1.00 33.96           O  \nATOM   2832  CB  LEU C  88       5.806 111.909   3.837  1.00 31.14           C  \nATOM   2833  CG  LEU C  88       6.679 113.174   3.862  1.00 32.18           C  \nATOM   2834  CD1 LEU C  88       6.811 113.718   5.243  1.00 34.31           C  \nATOM   2835  CD2 LEU C  88       8.028 113.102   3.240  1.00 32.38           C  \nATOM   2836  N   ALA C  89       3.721 109.982   2.292  1.00 32.25           N  \nATOM   2837  CA  ALA C  89       2.986 108.718   2.204  1.00 33.01           C  \nATOM   2838  C   ALA C  89       3.546 107.844   1.079  1.00 33.62           C  \nATOM   2839  O   ALA C  89       3.772 106.646   1.252  1.00 34.83           O  \nATOM   2840  CB  ALA C  89       1.537 108.919   2.014  1.00 33.37           C  \nATOM   2841  N   GLU C  90       3.666 108.365  -0.139  1.00 33.78           N  \nATOM   2842  CA  GLU C  90       4.262 107.534  -1.210  1.00 34.04           C  \nATOM   2843  C   GLU C  90       5.665 107.037  -0.948  1.00 33.36           C  \nATOM   2844  O   GLU C  90       6.038 105.984  -1.423  1.00 33.63           O  \nATOM   2845  CB  GLU C  90       4.396 108.305  -2.545  1.00 34.70           C  \nATOM   2846  CG  GLU C  90       3.194 108.424  -3.220  1.00 43.91           C  \nATOM   2847  CD  GLU C  90       2.597 107.068  -3.679  1.00 45.16           C  \nATOM   2848  OE1 GLU C  90       3.274 106.205  -4.313  1.00 44.01           O  \nATOM   2849  OE2 GLU C  90       1.430 106.967  -3.339  1.00 51.24           O  \nATOM   2850  N   PHE C  91       6.469 107.845  -0.238  1.00 31.87           N  \nATOM   2851  CA  PHE C  91       7.827 107.457   0.147  1.00 30.81           C  \nATOM   2852  C   PHE C  91       7.800 106.110   0.825  1.00 31.56           C  \nATOM   2853  O   PHE C  91       8.558 105.239   0.479  1.00 30.55           O  \nATOM   2854  CB  PHE C  91       8.524 108.508   1.070  1.00 30.82           C  \nATOM   2855  CG  PHE C  91       9.116 109.712   0.337  1.00 29.46           C  \nATOM   2856  CD1 PHE C  91       8.794 109.983  -0.960  1.00 27.91           C  \nATOM   2857  CD2 PHE C  91       9.963 110.578   1.002  1.00 33.33           C  \nATOM   2858  CE1 PHE C  91       9.281 111.057  -1.633  1.00 28.43           C  \nATOM   2859  CE2 PHE C  91      10.481 111.712   0.338  1.00 36.08           C  \nATOM   2860  CZ  PHE C  91      10.178 111.906  -1.012  1.00 29.71           C  \nATOM   2861  N   TRP C  92       7.065 105.981   1.922  1.00 31.61           N  \nATOM   2862  CA  TRP C  92       7.102 104.721   2.648  1.00 31.51           C  \nATOM   2863  C   TRP C  92       6.393 103.626   1.887  1.00 31.50           C  \nATOM   2864  O   TRP C  92       6.794 102.459   1.970  1.00 30.30           O  \nATOM   2865  CB  TRP C  92       6.647 104.866   4.112  1.00 32.66           C  \nATOM   2866  CG  TRP C  92       5.134 104.993   4.253  1.00 30.68           C  \nATOM   2867  CD1 TRP C  92       4.399 106.116   4.455  1.00 32.36           C  \nATOM   2868  CD2 TRP C  92       4.154 103.893   4.308  1.00 33.97           C  \nATOM   2869  NE1 TRP C  92       3.042 105.802   4.498  1.00 31.64           N  \nATOM   2870  CE2 TRP C  92       2.871 104.465   4.472  1.00 34.72           C  \nATOM   2871  CE3 TRP C  92       4.242 102.515   4.133  1.00 40.76           C  \nATOM   2872  CZ2 TRP C  92       1.687 103.697   4.455  1.00 38.00           C  \nATOM   2873  CZ3 TRP C  92       3.089 101.754   4.154  1.00 39.57           C  \nATOM   2874  CH2 TRP C  92       1.817 102.348   4.337  1.00 39.31           C  \nATOM   2875  N   LYS C  93       5.369 103.927   1.091  1.00 32.66           N  \nATOM   2876  CA  LYS C  93       4.771 102.879   0.301  1.00 33.36           C  \nATOM   2877  C   LYS C  93       5.663 102.333  -0.832  1.00 34.03           C  \nATOM   2878  O   LYS C  93       5.679 101.120  -1.128  1.00 33.60           O  \nATOM   2879  CB  LYS C  93       3.426 103.296  -0.250  1.00 35.05           C  \nATOM   2880  CG  LYS C  93       2.394 103.571   0.784  1.00 38.01           C  \nATOM   2881  CD  LYS C  93       1.080 103.963   0.088  1.00 44.13           C  \nATOM   2882  CE  LYS C  93       0.729 105.399   0.208  1.00 46.26           C  \nATOM   2883  NZ  LYS C  93      -0.537 105.641  -0.560  1.00 53.19           N  \nATOM   2884  N   ARG C  94       6.440 103.204  -1.449  1.00 33.95           N  \nATOM   2885  CA  ARG C  94       7.481 102.790  -2.401  1.00 35.06           C  \nATOM   2886  C   ARG C  94       8.661 102.026  -1.775  1.00 34.33           C  \nATOM   2887  O   ARG C  94       9.174 101.059  -2.353  1.00 31.21           O  \nATOM   2888  CB  ARG C  94       7.889 103.965  -3.262  1.00 35.82           C  \nATOM   2889  CG  ARG C  94       6.719 104.318  -4.168  1.00 40.16           C  \nATOM   2890  CD  ARG C  94       7.032 105.289  -5.213  1.00 43.94           C  \nATOM   2891  NE  ARG C  94       5.757 105.825  -5.728  1.00 46.03           N  \nATOM   2892  CZ  ARG C  94       5.622 106.624  -6.792  1.00 49.44           C  \nATOM   2893  NH1 ARG C  94       6.665 107.021  -7.493  1.00 43.95           N  \nATOM   2894  NH2 ARG C  94       4.390 106.998  -7.180  1.00 53.41           N  \nATOM   2895  N   LEU C  95       9.001 102.382  -0.541  1.00 33.09           N  \nATOM   2896  CA  LEU C  95       9.954 101.581   0.189  1.00 32.82           C  \nATOM   2897  C   LEU C  95       9.404 100.164   0.418  1.00 32.66           C  \nATOM   2898  O   LEU C  95      10.124  99.183   0.289  1.00 32.25           O  \nATOM   2899  CB  LEU C  95      10.320 102.299   1.515  1.00 32.72           C  \nATOM   2900  CG  LEU C  95      11.005 101.488   2.593  1.00 35.35           C  \nATOM   2901  CD1 LEU C  95      12.361 101.189   2.176  1.00 42.98           C  \nATOM   2902  CD2 LEU C  95      11.031 102.189   3.899  1.00 43.18           C  \nATOM   2903  N   TYR C  96       8.130 100.075   0.822  1.00 31.62           N  \nATOM   2904  CA  TYR C  96       7.531  98.813   1.094  1.00 31.42           C  \nATOM   2905  C   TYR C  96       7.691  97.865  -0.095  1.00 31.30           C  \nATOM   2906  O   TYR C  96       8.041  96.743   0.091  1.00 34.42           O  \nATOM   2907  CB  TYR C  96       6.035  99.007   1.334  1.00 31.54           C  \nATOM   2908  CG  TYR C  96       5.273  97.707   1.205  1.00 30.19           C  \nATOM   2909  CD1 TYR C  96       5.263  96.778   2.248  1.00 29.35           C  \nATOM   2910  CD2 TYR C  96       4.514  97.415   0.040  1.00 33.04           C  \nATOM   2911  CE1 TYR C  96       4.606  95.552   2.126  1.00 30.87           C  \nATOM   2912  CE2 TYR C  96       3.823  96.173  -0.089  1.00 33.76           C  \nATOM   2913  CZ  TYR C  96       3.872  95.275   0.999  1.00 34.78           C  \nATOM   2914  OH  TYR C  96       3.223  94.049   0.974  1.00 36.84           O  \nATOM   2915  N   THR C  97       7.341  98.327  -1.300  1.00 30.56           N  \nATOM   2916  CA  THR C  97       7.518  97.564  -2.504  1.00 33.88           C  \nATOM   2917  C   THR C  97       8.928  97.072  -2.659  1.00 33.03           C  \nATOM   2918  O   THR C  97       9.132  95.903  -2.990  1.00 31.29           O  \nATOM   2919  CB  THR C  97       7.142  98.420  -3.759  1.00 34.60           C  \nATOM   2920  OG1 THR C  97       5.782  98.846  -3.611  1.00 32.91           O  \nATOM   2921  CG2 THR C  97       7.364  97.626  -5.049  1.00 35.28           C  \nATOM   2922  N   LYS C  98       9.875  97.970  -2.436  1.00 34.23           N  \nATOM   2923  CA  LYS C  98      11.313  97.573  -2.483  1.00 35.56           C  \nATOM   2924  C   LYS C  98      11.640  96.513  -1.480  1.00 32.58           C  \nATOM   2925  O   LYS C  98      12.171  95.456  -1.862  1.00 31.31           O  \nATOM   2926  CB  LYS C  98      12.267  98.763  -2.319  1.00 37.86           C  \nATOM   2927  CG  LYS C  98      12.389  99.666  -3.574  1.00 44.53           C  \nATOM   2928  CD  LYS C  98      12.706  98.922  -4.914  1.00 53.31           C  \nATOM   2929  CE  LYS C  98      12.223  99.693  -6.168  1.00 54.00           C  \nATOM   2930  NZ  LYS C  98      13.199 100.731  -6.436  1.00 58.59           N  \nATOM   2931    N MSE C  99      11.227  96.712  -0.209  1.00 29.28           N  \nATOM   2932   CA MSE C  99      11.576  95.720   0.817  1.00 30.87           C  \nATOM   2933    C MSE C  99      10.763  94.425   0.652  1.00 31.27           C  \nATOM   2934    O MSE C  99      11.230  93.298   0.919  1.00 31.92           O  \nATOM   2935   CB MSE C  99      11.373  96.252   2.179  1.00 30.23           C  \nATOM   2936   CG MSE C  99      12.327  97.387   2.501  1.00 34.76           C  \nATOM   2937   SE MSE C  99      11.965  97.972   4.409  1.00 43.68          SE  \nATOM   2938   CE MSE C  99      12.831  96.356   5.236  1.00 35.55           C  \nATOM   2939  N   ASN C 100       9.506  94.574   0.251  1.00 31.11           N  \nATOM   2940  CA  ASN C 100       8.646  93.442   0.085  1.00 31.43           C  \nATOM   2941  C   ASN C 100       9.139  92.493  -1.040  1.00 32.61           C  \nATOM   2942  O   ASN C 100       9.072  91.316  -0.869  1.00 32.35           O  \nATOM   2943  CB  ASN C 100       7.190  93.864  -0.204  1.00 30.07           C  \nATOM   2944  CG  ASN C 100       6.237  92.761  -0.034  1.00 32.87           C  \nATOM   2945  OD1 ASN C 100       6.202  92.116   1.008  1.00 30.83           O  \nATOM   2946  ND2 ASN C 100       5.458  92.474  -1.098  1.00 34.51           N  \nATOM   2947  N   ASP C 101       9.605  93.033  -2.156  1.00 34.71           N  \nATOM   2948  CA  ASP C 101      10.198  92.260  -3.243  1.00 37.91           C  \nATOM   2949  C   ASP C 101      11.513  91.491  -2.867  1.00 38.56           C  \nATOM   2950  O   ASP C 101      11.921  90.594  -3.543  1.00 38.43           O  \nATOM   2951  CB  ASP C 101      10.448  93.191  -4.475  1.00 39.07           C  \nATOM   2952  CG  ASP C 101       9.116  93.673  -5.160  1.00 41.62           C  \nATOM   2953  OD1 ASP C 101       7.987  93.255  -4.763  1.00 42.79           O  \nATOM   2954  OD2 ASP C 101       9.200  94.547  -6.055  1.00 44.71           O  \nATOM   2955  N   LYS C 102      12.169  91.896  -1.793  1.00 39.86           N  \nATOM   2956  CA  LYS C 102      13.414  91.345  -1.353  1.00 42.15           C  \nATOM   2957  C   LYS C 102      13.167  90.613  -0.066  1.00 41.02           C  \nATOM   2958  O   LYS C 102      14.124  90.187   0.556  1.00 41.73           O  \nATOM   2959  CB  LYS C 102      14.465  92.475  -1.067  1.00 44.07           C  \nATOM   2960  CG  LYS C 102      15.210  93.078  -2.283  1.00 48.91           C  \nATOM   2961  CD  LYS C 102      15.861  94.456  -1.858  1.00 53.77           C  \nATOM   2962  CE  LYS C 102      17.256  94.839  -2.585  1.00 54.41           C  \nATOM   2963  NZ  LYS C 102      18.027  96.086  -2.015  1.00 49.03           N  \nATOM   2964  N   ARG C 103      11.927  90.408   0.357  1.00 40.29           N  \nATOM   2965  CA  ARG C 103      11.765  89.848   1.679  1.00 41.30           C  \nATOM   2966  C   ARG C 103      12.119  88.331   1.665  1.00 41.69           C  \nATOM   2967  O   ARG C 103      12.029  87.632   0.617  1.00 40.20           O  \nATOM   2968  CB  ARG C 103      10.407  90.156   2.311  1.00 42.54           C  \nATOM   2969  CG  ARG C 103       9.485  89.014   2.430  1.00 46.89           C  \nATOM   2970  CD  ARG C 103       7.999  89.537   2.682  1.00 53.50           C  \nATOM   2971  NE  ARG C 103       7.521  89.620   1.316  1.00 57.05           N  \nATOM   2972  CZ  ARG C 103       6.709  88.779   0.712  1.00 50.32           C  \nATOM   2973  NH1 ARG C 103       6.118  87.857   1.401  1.00 50.94           N  \nATOM   2974  NH2 ARG C 103       6.447  88.931  -0.594  1.00 50.00           N  \nATOM   2975  N   LEU C 104      12.574  87.891   2.832  1.00 41.42           N  \nATOM   2976  CA  LEU C 104      12.996  86.548   3.043  1.00 43.70           C  \nATOM   2977  C   LEU C 104      11.868  85.599   3.311  1.00 43.81           C  \nATOM   2978  O   LEU C 104      10.781  86.057   3.616  1.00 42.69           O  \nATOM   2979  CB  LEU C 104      14.161  86.491   4.050  1.00 44.26           C  \nATOM   2980  CG  LEU C 104      15.394  87.040   3.283  1.00 45.87           C  \nATOM   2981  CD1 LEU C 104      16.641  86.514   3.920  1.00 48.47           C  \nATOM   2982  CD2 LEU C 104      15.422  86.769   1.681  1.00 43.75           C  \nATOM   2983  N   PRO C 105      12.115  84.279   3.048  1.00 43.22           N  \nATOM   2984  CA  PRO C 105      11.115  83.291   3.148  1.00 44.41           C  \nATOM   2985  C   PRO C 105      10.290  83.319   4.403  1.00 45.18           C  \nATOM   2986  O   PRO C 105       9.167  82.877   4.322  1.00 44.91           O  \nATOM   2987  CB  PRO C 105      11.929  81.956   3.076  1.00 43.60           C  \nATOM   2988  CG  PRO C 105      12.971  82.247   2.201  1.00 43.01           C  \nATOM   2989  CD  PRO C 105      13.365  83.657   2.560  1.00 44.38           C  \nATOM   2990  N   ASP C 106      10.825  83.784   5.536  1.00 47.57           N  \nATOM   2991  CA  ASP C 106      10.063  83.710   6.827  1.00 49.88           C  \nATOM   2992  C   ASP C 106       9.194  84.993   7.126  1.00 49.61           C  \nATOM   2993  O   ASP C 106       8.116  84.902   7.793  1.00 50.18           O  \nATOM   2994  CB  ASP C 106      11.043  83.350   7.993  1.00 51.12           C  \nATOM   2995  CG  ASP C 106      11.415  81.807   8.048  1.00 55.83           C  \nATOM   2996  OD1 ASP C 106      10.537  80.920   7.746  1.00 60.36           O  \nATOM   2997  OD2 ASP C 106      12.608  81.473   8.402  1.00 58.80           O  \nATOM   2998  N   GLN C 107       9.651  86.118   6.541  1.00 48.85           N  \nATOM   2999  CA  GLN C 107       9.037  87.478   6.605  1.00 48.31           C  \nATOM   3000  C   GLN C 107       7.637  87.579   5.913  1.00 46.42           C  \nATOM   3001  O   GLN C 107       7.496  87.327   4.704  1.00 46.61           O  \nATOM   3002  CB  GLN C 107       9.962  88.527   5.939  1.00 48.55           C  \nATOM   3003  CG  GLN C 107      11.407  88.873   6.547  1.00 51.75           C  \nATOM   3004  CD  GLN C 107      12.193  89.951   5.717  1.00 50.14           C  \nATOM   3005  OE1 GLN C 107      12.949  89.559   4.876  1.00 48.11           O  \nATOM   3006  NE2 GLN C 107      11.953  91.351   5.935  1.00 53.29           N  \nATOM   3007  N   GLU C 108       6.624  87.978   6.679  1.00 44.38           N  \nATOM   3008  CA  GLU C 108       5.286  88.288   6.131  1.00 42.53           C  \nATOM   3009  C   GLU C 108       5.134  89.772   5.747  1.00 38.23           C  \nATOM   3010  O   GLU C 108       5.638  90.634   6.439  1.00 36.64           O  \nATOM   3011  CB  GLU C 108       4.203  87.847   7.122  1.00 43.53           C  \nATOM   3012  CG  GLU C 108       4.493  86.379   7.518  1.00 49.98           C  \nATOM   3013  CD  GLU C 108       3.401  85.717   8.314  1.00 57.73           C  \nATOM   3014  OE1 GLU C 108       2.422  86.438   8.635  1.00 62.76           O  \nATOM   3015  OE2 GLU C 108       3.532  84.464   8.611  1.00 62.98           O  \nATOM   3016  N   SER C 109       4.488  90.022   4.609  1.00 34.52           N  \nATOM   3017  CA  SER C 109       4.229  91.364   4.089  1.00 35.93           C  \nATOM   3018  C   SER C 109       3.523  92.261   5.106  1.00 34.72           C  \nATOM   3019  O   SER C 109       3.915  93.425   5.311  1.00 35.19           O  \nATOM   3020  CB  SER C 109       3.355  91.250   2.871  1.00 35.58           C  \nATOM   3021  OG  SER C 109       4.143  90.630   1.932  1.00 36.54           O  \nATOM   3022  N   THR C 110       2.567  91.683   5.816  1.00 35.95           N  \nATOM   3023  CA  THR C 110       1.796  92.456   6.770  1.00 37.34           C  \nATOM   3024  C   THR C 110       2.706  92.949   7.942  1.00 36.35           C  \nATOM   3025  O   THR C 110       2.648  94.090   8.343  1.00 33.90           O  \nATOM   3026  CB  THR C 110       0.556  91.650   7.276  1.00 39.06           C  \nATOM   3027  OG1 THR C 110      -0.401  91.562   6.201  1.00 42.50           O  \nATOM   3028  CG2 THR C 110      -0.113  92.397   8.400  1.00 38.39           C  \nATOM   3029  N   GLU C 111       3.545  92.051   8.447  1.00 35.65           N  \nATOM   3030  CA  GLU C 111       4.509  92.371   9.494  1.00 35.52           C  \nATOM   3031  C   GLU C 111       5.450  93.517   9.002  1.00 33.19           C  \nATOM   3032  O   GLU C 111       5.750  94.454   9.732  1.00 32.46           O  \nATOM   3033  CB  GLU C 111       5.281  91.111   9.876  1.00 36.38           C  \nATOM   3034  CG  GLU C 111       6.435  91.338  10.867  1.00 43.89           C  \nATOM   3035  CD  GLU C 111       7.441  90.110  11.051  1.00 51.91           C  \nATOM   3036  OE1 GLU C 111       8.108  89.650  10.062  1.00 53.30           O  \nATOM   3037  OE2 GLU C 111       7.568  89.622  12.225  1.00 60.79           O  \nATOM   3038  N   LEU C 112       5.881  93.423   7.749  1.00 31.16           N  \nATOM   3039  CA  LEU C 112       6.718  94.438   7.141  1.00 30.76           C  \nATOM   3040  C   LEU C 112       6.063  95.815   7.061  1.00 28.59           C  \nATOM   3041  O   LEU C 112       6.658  96.825   7.396  1.00 27.53           O  \nATOM   3042  CB  LEU C 112       7.175  93.921   5.783  1.00 32.88           C  \nATOM   3043  CG  LEU C 112       7.973  94.825   4.888  1.00 34.50           C  \nATOM   3044  CD1 LEU C 112       9.350  95.164   5.558  1.00 38.62           C  \nATOM   3045  CD2 LEU C 112       8.194  94.149   3.584  1.00 35.34           C  \nATOM   3046  N   ILE C 113       4.771  95.842   6.658  1.00 29.20           N  \nATOM   3047  CA  ILE C 113       4.034  97.040   6.634  1.00 30.32           C  \nATOM   3048  C   ILE C 113       3.979  97.697   8.028  1.00 30.61           C  \nATOM   3049  O   ILE C 113       4.254  98.945   8.137  1.00 31.12           O  \nATOM   3050  CB  ILE C 113       2.624  96.897   6.115  1.00 29.92           C  \nATOM   3051  CG1 ILE C 113       2.631  96.500   4.657  1.00 30.04           C  \nATOM   3052  CG2 ILE C 113       1.942  98.243   6.263  1.00 34.18           C  \nATOM   3053  CD1 ILE C 113       1.275  96.072   4.006  1.00 31.12           C  \nATOM   3054  N   TRP C 114       3.685  96.912   9.056  1.00 30.65           N  \nATOM   3055  CA  TRP C 114       3.659  97.436  10.425  1.00 32.33           C  \nATOM   3056  C   TRP C 114       5.047  97.886  10.929  1.00 31.34           C  \nATOM   3057  O   TRP C 114       5.139  98.823  11.703  1.00 30.26           O  \nATOM   3058  CB  TRP C 114       3.013  96.483  11.437  1.00 33.53           C  \nATOM   3059  CG  TRP C 114       1.584  96.256  11.110  1.00 34.92           C  \nATOM   3060  CD1 TRP C 114       0.966  95.060  10.965  1.00 36.35           C  \nATOM   3061  CD2 TRP C 114       0.603  97.250  10.828  1.00 34.27           C  \nATOM   3062  NE1 TRP C 114      -0.350  95.265  10.636  1.00 33.82           N  \nATOM   3063  CE2 TRP C 114      -0.592  96.591  10.529  1.00 36.94           C  \nATOM   3064  CE3 TRP C 114       0.602  98.658  10.843  1.00 38.37           C  \nATOM   3065  CZ2 TRP C 114      -1.783  97.293  10.231  1.00 35.82           C  \nATOM   3066  CZ3 TRP C 114      -0.515  99.313  10.553  1.00 35.93           C  \nATOM   3067  CH2 TRP C 114      -1.695  98.643  10.198  1.00 35.79           C  \nATOM   3068  N   GLN C 115       6.093  97.254  10.456  1.00 31.33           N  \nATOM   3069  CA  GLN C 115       7.459  97.645  10.841  1.00 31.11           C  \nATOM   3070  C   GLN C 115       7.759  99.031  10.212  1.00 30.90           C  \nATOM   3071  O   GLN C 115       8.343  99.916  10.843  1.00 28.57           O  \nATOM   3072  CB  GLN C 115       8.480  96.633  10.422  1.00 29.82           C  \nATOM   3073  CG  GLN C 115       8.616  95.293  11.238  1.00 32.68           C  \nATOM   3074  CD  GLN C 115       9.542  94.234  10.517  1.00 33.81           C  \nATOM   3075  OE1 GLN C 115       9.660  94.236   9.286  1.00 35.93           O  \nATOM   3076  NE2 GLN C 115      10.157  93.358  11.284  1.00 33.05           N  \nATOM   3077  N   ILE C 116       7.321  99.206   8.953  1.00 31.27           N  \nATOM   3078  CA  ILE C 116       7.564 100.435   8.262  1.00 29.80           C  \nATOM   3079  C   ILE C 116       6.791 101.560   8.982  1.00 29.65           C  \nATOM   3080  O   ILE C 116       7.371 102.635   9.292  1.00 29.11           O  \nATOM   3081  CB  ILE C 116       7.241 100.305   6.737  1.00 30.12           C  \nATOM   3082  CG1 ILE C 116       8.297  99.335   6.114  1.00 32.41           C  \nATOM   3083  CG2 ILE C 116       7.151 101.644   6.047  1.00 32.39           C  \nATOM   3084  CD1 ILE C 116       8.016  98.911   4.638  1.00 35.12           C  \nATOM   3085  N   ASP C 117       5.512 101.284   9.251  1.00 29.32           N  \nATOM   3086  CA  ASP C 117       4.662 102.246   9.912  1.00 31.00           C  \nATOM   3087  C   ASP C 117       5.278 102.729  11.203  1.00 30.20           C  \nATOM   3088  O   ASP C 117       5.274 103.897  11.496  1.00 31.25           O  \nATOM   3089  CB  ASP C 117       3.250 101.629  10.146  1.00 32.02           C  \nATOM   3090  CG  ASP C 117       2.302 102.556  10.897  1.00 34.37           C  \nATOM   3091  OD1 ASP C 117       1.784 103.427  10.237  1.00 34.78           O  \nATOM   3092  OD2 ASP C 117       2.151 102.396  12.118  1.00 34.63           O  \nATOM   3093  N   ARG C 118       5.725 101.791  11.992  1.00 31.71           N  \nATOM   3094  CA  ARG C 118       6.239 102.096  13.301  1.00 33.47           C  \nATOM   3095  C   ARG C 118       7.466 103.006  13.264  1.00 31.96           C  \nATOM   3096  O   ARG C 118       7.627 103.877  14.083  1.00 29.36           O  \nATOM   3097  CB  ARG C 118       6.647 100.753  13.965  1.00 35.94           C  \nATOM   3098  CG  ARG C 118       6.949 100.868  15.410  1.00 42.36           C  \nATOM   3099  CD  ARG C 118       7.761  99.666  15.941  1.00 47.34           C  \nATOM   3100  NE  ARG C 118       7.992  99.876  17.384  1.00 50.19           N  \nATOM   3101  CZ  ARG C 118       9.053 100.505  17.896  1.00 52.04           C  \nATOM   3102  NH1 ARG C 118      10.002 100.972  17.086  1.00 41.24           N  \nATOM   3103  NH2 ARG C 118       9.142 100.693  19.232  1.00 54.31           N  \nATOM   3104  N   PHE C 119       8.343 102.777  12.298  1.00 30.45           N  \nATOM   3105  CA  PHE C 119       9.459 103.648  12.096  1.00 31.26           C  \nATOM   3106  C   PHE C 119       9.074 105.079  11.538  1.00 29.83           C  \nATOM   3107  O   PHE C 119       9.572 106.096  11.986  1.00 27.91           O  \nATOM   3108  CB  PHE C 119      10.459 102.952  11.125  1.00 32.13           C  \nATOM   3109  CG  PHE C 119      11.760 103.755  10.868  1.00 31.94           C  \nATOM   3110  CD1 PHE C 119      12.785 103.717  11.760  1.00 36.11           C  \nATOM   3111  CD2 PHE C 119      11.922 104.553   9.724  1.00 35.01           C  \nATOM   3112  CE1 PHE C 119      13.956 104.506  11.591  1.00 37.48           C  \nATOM   3113  CE2 PHE C 119      13.075 105.291   9.526  1.00 34.33           C  \nATOM   3114  CZ  PHE C 119      14.086 105.294  10.475  1.00 36.34           C  \nATOM   3115  N   PHE C 120       8.262 105.120  10.477  1.00 31.17           N  \nATOM   3116  CA  PHE C 120       8.030 106.311   9.777  1.00 29.25           C  \nATOM   3117  C   PHE C 120       6.936 107.211  10.411  1.00 30.88           C  \nATOM   3118  O   PHE C 120       7.010 108.416  10.249  1.00 29.78           O  \nATOM   3119  CB  PHE C 120       7.666 106.036   8.305  1.00 29.64           C  \nATOM   3120  CG  PHE C 120       8.840 105.750   7.433  1.00 28.22           C  \nATOM   3121  CD1 PHE C 120       9.488 106.754   6.709  1.00 29.07           C  \nATOM   3122  CD2 PHE C 120       9.302 104.458   7.303  1.00 32.73           C  \nATOM   3123  CE1 PHE C 120      10.576 106.504   5.887  1.00 26.30           C  \nATOM   3124  CE2 PHE C 120      10.404 104.174   6.489  1.00 31.99           C  \nATOM   3125  CZ  PHE C 120      11.040 105.257   5.734  1.00 29.12           C  \nATOM   3126  N   SER C 121       5.862 106.633  10.943  1.00 29.03           N  \nATOM   3127  CA  SER C 121       4.722 107.461  11.220  1.00 30.59           C  \nATOM   3128  C   SER C 121       5.062 108.654  12.192  1.00 31.43           C  \nATOM   3129  O   SER C 121       4.644 109.740  11.908  1.00 31.88           O  \nATOM   3130  CB  SER C 121       3.590 106.655  11.872  1.00 31.14           C  \nATOM   3131  OG  SER C 121       2.414 107.420  12.061  1.00 34.03           O  \nATOM   3132  N   PRO C 122       5.796 108.419  13.292  1.00 31.09           N  \nATOM   3133  CA  PRO C 122       6.153 109.534  14.238  1.00 31.43           C  \nATOM   3134  C   PRO C 122       7.116 110.598  13.681  1.00 30.34           C  \nATOM   3135  O   PRO C 122       7.028 111.748  14.083  1.00 28.57           O  \nATOM   3136  CB  PRO C 122       6.813 108.817  15.435  1.00 32.89           C  \nATOM   3137  CG  PRO C 122       7.098 107.534  14.984  1.00 35.16           C  \nATOM   3138  CD  PRO C 122       6.275 107.136  13.830  1.00 32.47           C  \nATOM   3139  N   ILE C 123       7.964 110.172  12.702  1.00 27.68           N  \nATOM   3140  CA  ILE C 123       8.776 111.096  11.985  1.00 28.85           C  \nATOM   3141  C   ILE C 123       7.942 112.009  11.126  1.00 28.47           C  \nATOM   3142  O   ILE C 123       8.100 113.210  11.171  1.00 26.02           O  \nATOM   3143  CB  ILE C 123       9.840 110.365  11.091  1.00 28.54           C  \nATOM   3144  CG1 ILE C 123      10.759 109.470  11.968  1.00 28.73           C  \nATOM   3145  CG2 ILE C 123      10.642 111.357  10.239  1.00 32.28           C  \nATOM   3146  CD1 ILE C 123      11.544 108.507  11.154  1.00 29.47           C  \nATOM   3147  N   ASN C 124       7.096 111.395  10.305  1.00 28.67           N  \nATOM   3148  CA  ASN C 124       6.256 112.126   9.440  1.00 29.44           C  \nATOM   3149  C   ASN C 124       5.278 113.070  10.155  1.00 29.46           C  \nATOM   3150  O   ASN C 124       5.101 114.230   9.794  1.00 27.65           O  \nATOM   3151  CB  ASN C 124       5.509 111.176   8.484  1.00 29.06           C  \nATOM   3152  CG  ASN C 124       6.430 110.459   7.505  1.00 29.66           C  \nATOM   3153  OD1 ASN C 124       7.542 110.899   7.236  1.00 32.68           O  \nATOM   3154  ND2 ASN C 124       5.963 109.341   6.964  1.00 27.90           N  \nATOM   3155  N   THR C 125       4.659 112.581  11.222  1.00 30.36           N  \nATOM   3156  CA  THR C 125       3.810 113.455  11.985  1.00 29.56           C  \nATOM   3157  C   THR C 125       4.532 114.672  12.542  1.00 26.92           C  \nATOM   3158  O   THR C 125       3.935 115.756  12.656  1.00 28.33           O  \nATOM   3159  CB  THR C 125       2.991 112.743  13.034  1.00 28.70           C  \nATOM   3160  OG1 THR C 125       3.775 112.165  13.977  1.00 34.05           O  \nATOM   3161  CG2 THR C 125       2.117 111.709  12.453  1.00 28.83           C  \nATOM   3162  N   GLU C 126       5.742 114.486  13.001  1.00 28.20           N  \nATOM   3163  CA  GLU C 126       6.554 115.580  13.510  1.00 27.11           C  \nATOM   3164  C   GLU C 126       6.932 116.541  12.365  1.00 27.05           C  \nATOM   3165  O   GLU C 126       6.961 117.746  12.572  1.00 28.31           O  \nATOM   3166  CB  GLU C 126       7.815 115.027  14.160  1.00 28.94           C  \nATOM   3167  CG  GLU C 126       8.602 115.983  14.920  1.00 29.96           C  \nATOM   3168  CD  GLU C 126       7.819 116.443  16.168  1.00 42.57           C  \nATOM   3169  OE1 GLU C 126       7.263 115.497  16.713  1.00 41.74           O  \nATOM   3170  OE2 GLU C 126       7.643 117.685  16.380  1.00 48.21           O  \nATOM   3171  N   ILE C 127       7.254 116.043  11.144  1.00 28.81           N  \nATOM   3172  CA  ILE C 127       7.413 116.951  10.017  1.00 27.76           C  \nATOM   3173  C   ILE C 127       6.180 117.817   9.715  1.00 27.86           C  \nATOM   3174  O   ILE C 127       6.251 119.022   9.470  1.00 28.19           O  \nATOM   3175  CB  ILE C 127       7.835 116.140   8.727  1.00 27.90           C  \nATOM   3176  CG1 ILE C 127       9.254 115.534   9.020  1.00 31.46           C  \nATOM   3177  CG2 ILE C 127       7.795 117.013   7.534  1.00 28.93           C  \nATOM   3178  CD1 ILE C 127       9.757 114.525   8.041  1.00 33.15           C  \nATOM   3179  N   PHE C 128       5.006 117.174   9.715  1.00 28.57           N  \nATOM   3180  CA  PHE C 128       3.711 117.874   9.611  1.00 26.91           C  \nATOM   3181  C   PHE C 128       3.528 118.948  10.629  1.00 25.82           C  \nATOM   3182  O   PHE C 128       3.188 120.069  10.298  1.00 25.07           O  \nATOM   3183  CB  PHE C 128       2.439 116.949   9.494  1.00 28.72           C  \nATOM   3184  CG  PHE C 128       2.554 115.838   8.472  1.00 27.38           C  \nATOM   3185  CD1 PHE C 128       3.356 115.988   7.391  1.00 32.74           C  \nATOM   3186  CD2 PHE C 128       1.856 114.670   8.648  1.00 33.01           C  \nATOM   3187  CE1 PHE C 128       3.521 114.950   6.436  1.00 35.23           C  \nATOM   3188  CE2 PHE C 128       1.984 113.627   7.727  1.00 33.83           C  \nATOM   3189  CZ  PHE C 128       2.840 113.813   6.599  1.00 32.52           C  \nATOM   3190  N   ASN C 129       3.745 118.586  11.882  1.00 25.82           N  \nATOM   3191  CA  ASN C 129       3.639 119.543  12.935  1.00 26.40           C  \nATOM   3192  C   ASN C 129       4.540 120.720  12.729  1.00 25.71           C  \nATOM   3193  O   ASN C 129       4.123 121.847  12.900  1.00 26.43           O  \nATOM   3194  CB  ASN C 129       3.986 118.866  14.240  1.00 26.90           C  \nATOM   3195  CG  ASN C 129       3.503 119.607  15.416  1.00 31.54           C  \nATOM   3196  OD1 ASN C 129       2.323 119.901  15.575  1.00 27.66           O  \nATOM   3197  ND2 ASN C 129       4.430 119.929  16.258  1.00 28.43           N  \nATOM   3198  N   GLN C 130       5.778 120.477  12.312  1.00 27.03           N  \nATOM   3199  CA  GLN C 130       6.709 121.591  12.120  1.00 28.75           C  \nATOM   3200  C   GLN C 130       6.393 122.442  10.890  1.00 28.77           C  \nATOM   3201  O   GLN C 130       6.622 123.626  10.899  1.00 28.30           O  \nATOM   3202  CB  GLN C 130       8.147 121.130  12.054  1.00 30.39           C  \nATOM   3203  CG  GLN C 130       8.673 120.638  13.335  1.00 31.04           C  \nATOM   3204  CD  GLN C 130       8.642 121.765  14.409  1.00 35.09           C  \nATOM   3205  OE1 GLN C 130       8.979 122.925  14.135  1.00 37.29           O  \nATOM   3206  NE2 GLN C 130       8.177 121.418  15.551  1.00 32.70           N  \nATOM   3207  N   TYR C 131       5.829 121.847   9.862  1.00 29.11           N  \nATOM   3208  CA  TYR C 131       5.331 122.574   8.675  1.00 27.42           C  \nATOM   3209  C   TYR C 131       4.263 123.625   9.121  1.00 27.79           C  \nATOM   3210  O   TYR C 131       4.387 124.769   8.852  1.00 28.23           O  \nATOM   3211  CB  TYR C 131       4.766 121.604   7.596  1.00 28.26           C  \nATOM   3212  CG  TYR C 131       4.272 122.279   6.302  1.00 28.60           C  \nATOM   3213  CD1 TYR C 131       5.042 122.210   5.154  1.00 30.75           C  \nATOM   3214  CD2 TYR C 131       3.138 123.018   6.243  1.00 28.97           C  \nATOM   3215  CE1 TYR C 131       4.611 122.793   3.915  1.00 26.34           C  \nATOM   3216  CE2 TYR C 131       2.778 123.687   5.072  1.00 25.40           C  \nATOM   3217  CZ  TYR C 131       3.526 123.577   3.912  1.00 27.27           C  \nATOM   3218  OH  TYR C 131       3.141 124.179   2.719  1.00 28.43           O  \nATOM   3219  N   SER C 132       3.254 123.207   9.883  1.00 28.26           N  \nATOM   3220  CA  SER C 132       2.135 124.027  10.240  1.00 27.81           C  \nATOM   3221  C   SER C 132       2.671 125.119  11.136  1.00 28.77           C  \nATOM   3222  O   SER C 132       2.263 126.259  11.049  1.00 28.90           O  \nATOM   3223  CB  SER C 132       1.065 123.139  10.996  1.00 29.25           C  \nATOM   3224  OG  SER C 132      -0.149 123.921  11.197  1.00 36.41           O  \nATOM   3225  N   ILE C 133       3.615 124.749  12.000  1.00 31.55           N  \nATOM   3226  CA  ILE C 133       4.157 125.639  13.021  1.00 34.22           C  \nATOM   3227  C   ILE C 133       4.917 126.653  12.381  1.00 35.27           C  \nATOM   3228  O   ILE C 133       4.884 127.762  12.818  1.00 35.70           O  \nATOM   3229  CB  ILE C 133       5.036 124.906  14.112  1.00 34.93           C  \nATOM   3230  CG1 ILE C 133       4.094 124.295  15.179  1.00 40.94           C  \nATOM   3231  CG2 ILE C 133       5.949 125.840  14.760  1.00 40.91           C  \nATOM   3232  CD1 ILE C 133       4.767 123.115  15.955  1.00 45.20           C  \nATOM   3233  N   SER C 134       5.605 126.343  11.290  1.00 38.08           N  \nATOM   3234  CA  SER C 134       6.177 127.407  10.490  1.00 41.46           C  \nATOM   3235  C   SER C 134       5.178 128.536  10.252  1.00 44.75           C  \nATOM   3236  O   SER C 134       5.548 129.706  10.422  1.00 48.29           O  \nATOM   3237  CB  SER C 134       6.795 126.946   9.234  1.00 40.97           C  \nATOM   3238  OG  SER C 134       7.941 126.122   9.516  1.00 43.26           O  \nATOM   3239  N   TRP C 135       3.899 128.275   9.929  1.00 45.80           N  \nATOM   3240  CA  TRP C 135       2.947 129.398   9.677  1.00 44.32           C  \nATOM   3241  C   TRP C 135       2.358 129.969  10.957  1.00 45.44           C  \nATOM   3242  O   TRP C 135       2.246 131.193  11.121  1.00 45.16           O  \nATOM   3243  CB  TRP C 135       1.794 128.935   8.850  1.00 45.57           C  \nATOM   3244  CG  TRP C 135       2.183 128.695   7.409  1.00 49.27           C  \nATOM   3245  CD1 TRP C 135       2.298 127.498   6.773  1.00 43.87           C  \nATOM   3246  CD2 TRP C 135       2.562 129.718   6.460  1.00 48.59           C  \nATOM   3247  NE1 TRP C 135       2.626 127.697   5.445  1.00 45.45           N  \nATOM   3248  CE2 TRP C 135       2.831 129.055   5.222  1.00 53.06           C  \nATOM   3249  CE3 TRP C 135       2.649 131.096   6.518  1.00 47.23           C  \nATOM   3250  CZ2 TRP C 135       3.241 129.784   4.016  1.00 46.35           C  \nATOM   3251  CZ3 TRP C 135       3.081 131.826   5.328  1.00 48.74           C  \nATOM   3252  CH2 TRP C 135       3.375 131.135   4.106  1.00 48.33           C  \nATOM   3253  N   GLU C 136       1.977 129.070  11.849  1.00 44.79           N  \nATOM   3254  CA  GLU C 136       1.457 129.435  13.156  1.00 45.87           C  \nATOM   3255  C   GLU C 136       2.451 130.372  13.899  1.00 46.22           C  \nATOM   3256  O   GLU C 136       2.004 131.496  14.212  1.00 45.06           O  \nATOM   3257  CB  GLU C 136       1.002 128.180  13.998  1.00 45.84           C  \nATOM   3258  CG  GLU C 136       0.643 128.541  15.464  1.00 45.01           C  \nATOM   3259  CD  GLU C 136       0.083 127.412  16.278  1.00 46.51           C  \nATOM   3260  OE1 GLU C 136       0.018 126.287  15.814  1.00 46.41           O  \nATOM   3261  OE2 GLU C 136      -0.394 127.675  17.408  1.00 48.58           O  ";

	// target, 1HHO_A
	pTmalignCgi->m_pdb_target = "ATOM      1  N   VAL A   1       5.287  16.725   4.830  1.00  0.00           N  \nATOM      2  CA  VAL A   1       5.776  17.899   5.595  1.00  0.00           C  \nATOM      3  C   VAL A   1       7.198  18.266   5.104  1.00  0.00           C  \nATOM      4  O   VAL A   1       7.301  19.067   4.161  1.00  0.00           O  \nATOM      5  CB  VAL A   1       5.498  17.697   7.118  1.00  0.00           C  \nATOM      6  CG1 VAL A   1       6.457  16.822   7.917  1.00  0.00           C  \nATOM      7  CG2 VAL A   1       5.211  18.976   7.922  1.00  0.00           C  \nATOM      8  N   LEU A   2       8.272  17.653   5.632  1.00  0.00           N  \nATOM      9  CA  LEU A   2       9.698  18.050   5.442  1.00  0.00           C  \nATOM     10  C   LEU A   2      10.047  19.267   6.283  1.00  0.00           C  \nATOM     11  O   LEU A   2       9.566  20.404   6.099  1.00  0.00           O  \nATOM     12  CB  LEU A   2      10.129  18.317   4.001  1.00  0.00           C  \nATOM     13  CG  LEU A   2      10.208  17.036   3.175  1.00  0.00           C  \nATOM     14  CD1 LEU A   2      10.270  17.355   1.684  1.00  0.00           C  \nATOM     15  CD2 LEU A   2      11.398  16.219   3.605  1.00  0.00           C  \nATOM     16  N   SER A   3      10.906  18.980   7.204  1.00  0.00           N  \nATOM     17  CA  SER A   3      11.161  19.924   8.259  1.00  0.00           C  \nATOM     18  C   SER A   3      12.404  20.656   7.863  1.00  0.00           C  \nATOM     19  O   SER A   3      13.085  20.175   6.951  1.00  0.00           O  \nATOM     20  CB  SER A   3      11.402  19.155   9.553  1.00  0.00           C  \nATOM     21  OG  SER A   3      12.583  18.414   9.360  1.00  0.00           O  \nATOM     22  N   PRO A   4      12.697  21.735   8.552  1.00  0.00           N  \nATOM     23  CA  PRO A   4      13.961  22.439   8.372  1.00  0.00           C  \nATOM     24  C   PRO A   4      15.139  21.453   8.368  1.00  0.00           C  \nATOM     25  O   PRO A   4      16.162  21.757   7.764  1.00  0.00           O  \nATOM     26  CB  PRO A   4      14.000  23.497   9.507  1.00  0.00           C  \nATOM     27  CG  PRO A   4      12.993  23.019  10.549  1.00  0.00           C  \nATOM     28  CD  PRO A   4      11.940  22.309   9.712  1.00  0.00           C  \nATOM     29  N   ALA A   5      15.016  20.285   8.990  1.00  0.00           N  \nATOM     30  CA  ALA A   5      16.191  19.433   9.021  1.00  0.00           C  \nATOM     31  C   ALA A   5      16.118  18.392   7.919  1.00  0.00           C  \nATOM     32  O   ALA A   5      17.169  17.869   7.554  1.00  0.00           O  \nATOM     33  CB  ALA A   5      16.334  18.701  10.350  1.00  0.00           C  \nATOM     34  N   ASP A   6      14.933  18.106   7.483  1.00  0.00           N  \nATOM     35  CA  ASP A   6      14.826  17.172   6.388  1.00  0.00           C  \nATOM     36  C   ASP A   6      15.393  17.895   5.192  1.00  0.00           C  \nATOM     37  O   ASP A   6      16.261  17.368   4.492  1.00  0.00           O  \nATOM     38  CB  ASP A   6      13.378  16.754   6.140  1.00  0.00           C  \nATOM     39  CG  ASP A   6      12.859  15.872   7.278  1.00  0.00           C  \nATOM     40  OD1 ASP A   6      11.654  15.986   7.492  1.00  0.00           O  \nATOM     41  OD2 ASP A   6      13.614  15.055   7.862  1.00  0.00           O  \nATOM     42  N   LYS A   7      14.891  19.083   5.026  1.00  0.00           N  \nATOM     43  CA  LYS A   7      15.353  19.915   3.949  1.00  0.00           C  \nATOM     44  C   LYS A   7      16.890  20.146   4.084  1.00  0.00           C  \nATOM     45  O   LYS A   7      17.656  20.181   3.131  1.00  0.00           O  \nATOM     46  CB  LYS A   7      14.379  21.103   3.835  1.00  0.00           C  \nATOM     47  CG  LYS A   7      15.027  22.479   3.873  1.00  0.00           C  \nATOM     48  CD  LYS A   7      14.437  23.332   5.016  1.00  0.00           C  \nATOM     49  CE  LYS A   7      14.992  24.784   5.058  1.00  0.00           C  \nATOM     50  NZ  LYS A   7      14.496  25.613   3.926  1.00  0.00           N  \nATOM     51  N   THR A   8      17.447  20.153   5.245  1.00  0.00           N  \nATOM     52  CA  THR A   8      18.917  20.329   5.337  1.00  0.00           C  \nATOM     53  C   THR A   8      19.750  19.109   4.868  1.00  0.00           C  \nATOM     54  O   THR A   8      20.766  19.307   4.187  1.00  0.00           O  \nATOM     55  CB  THR A   8      19.208  20.656   6.803  1.00  0.00           C  \nATOM     56  OG1 THR A   8      18.651  21.908   7.147  1.00  0.00           O  \nATOM     57  CG2 THR A   8      20.694  20.705   7.078  1.00  0.00           C  \nATOM     58  N   ASN A   9      19.318  17.906   5.273  1.00  0.00           N  \nATOM     59  CA  ASN A   9      19.819  16.546   4.953  1.00  0.00           C  \nATOM     60  C   ASN A   9      19.588  16.195   3.470  1.00  0.00           C  \nATOM     61  O   ASN A   9      20.339  15.484   2.784  1.00  0.00           O  \nATOM     62  CB  ASN A   9      18.931  15.540   5.705  1.00  0.00           C  \nATOM     63  CG  ASN A   9      19.191  15.304   7.186  1.00  0.00           C  \nATOM     64  OD1 ASN A   9      18.317  14.781   7.870  1.00  0.00           O  \nATOM     65  ND2 ASN A   9      20.354  15.622   7.678  1.00  0.00           N  \nATOM     66  N   VAL A  10      18.474  16.651   3.002  1.00  0.00           N  \nATOM     67  CA  VAL A  10      18.235  16.330   1.622  1.00  0.00           C  \nATOM     68  C   VAL A  10      19.085  17.289   0.787  1.00  0.00           C  \nATOM     69  O   VAL A  10      19.532  16.824  -0.282  1.00  0.00           O  \nATOM     70  CB  VAL A  10      16.737  16.431   1.319  1.00  0.00           C  \nATOM     71  CG1 VAL A  10      16.404  16.509  -0.180  1.00  0.00           C  \nATOM     72  CG2 VAL A  10      15.945  15.317   2.003  1.00  0.00           C  \nATOM     73  N   LYS A  11      19.299  18.554   1.316  1.00  0.00           N  \nATOM     74  CA  LYS A  11      20.122  19.570   0.643  1.00  0.00           C  \nATOM     75  C   LYS A  11      21.522  18.968   0.581  1.00  0.00           C  \nATOM     76  O   LYS A  11      22.310  19.206  -0.327  1.00  0.00           O  \nATOM     77  CB  LYS A  11      20.000  21.009   1.193  1.00  0.00           C  \nATOM     78  CG  LYS A  11      18.788  21.746   0.559  1.00  0.00           C  \nATOM     79  CD  LYS A  11      18.155  22.950   1.321  1.00  0.00           C  \nATOM     80  CE  LYS A  11      16.865  23.437   0.587  1.00  0.00           C  \nATOM     81  NZ  LYS A  11      16.299  24.743   1.031  1.00  0.00           N  \nATOM     82  N   ALA A  12      21.743  18.025   1.437  1.00  0.00           N  \nATOM     83  CA  ALA A  12      23.107  17.671   1.637  1.00  0.00           C  \nATOM     84  C   ALA A  12      23.555  16.291   1.157  1.00  0.00           C  \nATOM     85  O   ALA A  12      24.697  16.040   0.726  1.00  0.00           O  \nATOM     86  CB  ALA A  12      23.287  17.747   3.151  1.00  0.00           C  \nATOM     87  N   ALA A  13      22.711  15.387   1.318  1.00  0.00           N  \nATOM     88  CA  ALA A  13      23.089  14.158   0.643  1.00  0.00           C  \nATOM     89  C   ALA A  13      23.137  14.383  -0.895  1.00  0.00           C  \nATOM     90  O   ALA A  13      23.812  13.686  -1.694  1.00  0.00           O  \nATOM     91  CB  ALA A  13      21.985  13.154   1.007  1.00  0.00           C  \nATOM     92  N   TRP A  14      22.386  15.393  -1.319  1.00  0.00           N  \nATOM     93  CA  TRP A  14      22.393  15.627  -2.751  1.00  0.00           C  \nATOM     94  C   TRP A  14      23.672  16.341  -3.113  1.00  0.00           C  \nATOM     95  O   TRP A  14      24.245  16.020  -4.156  1.00  0.00           O  \nATOM     96  CB  TRP A  14      21.230  16.488  -3.166  1.00  0.00           C  \nATOM     97  CG  TRP A  14      20.672  16.104  -4.553  1.00  0.00           C  \nATOM     98  CD1 TRP A  14      20.571  16.937  -5.650  1.00  0.00           C  \nATOM     99  CD2 TRP A  14      20.194  14.835  -4.957  1.00  0.00           C  \nATOM    100  NE1 TRP A  14      20.011  16.232  -6.713  1.00  0.00           N  \nATOM    101  CE2 TRP A  14      19.761  14.939  -6.292  1.00  0.00           C  \nATOM    102  CE3 TRP A  14      20.064  13.631  -4.273  1.00  0.00           C  \nATOM    103  CZ2 TRP A  14      19.187  13.889  -7.002  1.00  0.00           C  \nATOM    104  CZ3 TRP A  14      19.500  12.552  -4.985  1.00  0.00           C  \nATOM    105  CH2 TRP A  14      19.071  12.684  -6.307  1.00  0.00           C  \nATOM    106  N   GLY A  15      24.031  17.263  -2.234  1.00  0.00           N  \nATOM    107  CA  GLY A  15      25.313  17.981  -2.329  1.00  0.00           C  \nATOM    108  C   GLY A  15      26.442  17.017  -2.696  1.00  0.00           C  \nATOM    109  O   GLY A  15      27.115  17.131  -3.729  1.00  0.00           O  \nATOM    110  N   LYS A  16      26.569  16.087  -1.830  1.00  0.00           N  \nATOM    111  CA  LYS A  16      27.480  14.958  -1.831  1.00  0.00           C  \nATOM    112  C   LYS A  16      27.316  13.958  -2.986  1.00  0.00           C  \nATOM    113  O   LYS A  16      28.303  13.286  -3.260  1.00  0.00           O  \nATOM    114  CB  LYS A  16      27.294  14.191  -0.509  1.00  0.00           C  \nATOM    115  CG  LYS A  16      27.777  15.011   0.707  1.00  0.00           C  \nATOM    116  CD  LYS A  16      29.283  14.913   0.975  1.00  0.00           C  \nATOM    117  CE  LYS A  16      29.599  15.185   2.455  1.00  0.00           C  \nATOM    118  NZ  LYS A  16      30.959  14.707   2.788  1.00  0.00           N  \nATOM    119  N   VAL A  17      26.163  13.823  -3.621  1.00  0.00           N  \nATOM    120  CA  VAL A  17      26.068  12.962  -4.839  1.00  0.00           C  \nATOM    121  C   VAL A  17      26.654  13.626  -6.099  1.00  0.00           C  \nATOM    122  O   VAL A  17      27.122  12.976  -7.031  1.00  0.00           O  \nATOM    123  CB  VAL A  17      24.581  12.629  -5.051  1.00  0.00           C  \nATOM    124  CG1 VAL A  17      24.223  12.232  -6.457  1.00  0.00           C  \nATOM    125  CG2 VAL A  17      24.121  11.567  -4.077  1.00  0.00           C  \nATOM    126  N   GLY A  18      26.644  14.938  -6.089  1.00  0.00           N  \nATOM    127  CA  GLY A  18      26.945  15.761  -7.257  1.00  0.00           C  \nATOM    128  C   GLY A  18      26.601  15.192  -8.640  1.00  0.00           C  \nATOM    129  O   GLY A  18      25.466  14.794  -8.972  1.00  0.00           O  \nATOM    130  N   ALA A  19      27.695  15.184  -9.391  1.00  0.00           N  \nATOM    131  CA  ALA A  19      27.770  14.928 -10.841  1.00  0.00           C  \nATOM    132  C   ALA A  19      27.332  13.497 -11.174  1.00  0.00           C  \nATOM    133  O   ALA A  19      26.936  13.107 -12.278  1.00  0.00           O  \nATOM    134  CB  ALA A  19      29.231  15.183 -11.204  1.00  0.00           C  \nATOM    135  N   HIS A  20      27.370  12.675 -10.176  1.00  0.00           N  \nATOM    136  CA  HIS A  20      26.957  11.325 -10.499  1.00  0.00           C  \nATOM    137  C   HIS A  20      25.444  11.150 -10.399  1.00  0.00           C  \nATOM    138  O   HIS A  20      24.978  10.012 -10.426  1.00  0.00           O  \nATOM    139  CB  HIS A  20      27.517  10.442  -9.432  1.00  0.00           C  \nATOM    140  CG  HIS A  20      29.029  10.257  -9.361  1.00  0.00           C  \nATOM    141  ND1 HIS A  20      29.642   9.250 -10.093  1.00  0.00           N  \nATOM    142  CD2 HIS A  20      29.982  10.950  -8.632  1.00  0.00           C  \nATOM    143  CE1 HIS A  20      30.997   9.300  -9.825  1.00  0.00           C  \nATOM    144  NE2 HIS A  20      31.218  10.347  -8.921  1.00  0.00           N  \nATOM    145  N   ALA A  21      24.736  12.249 -10.229  1.00  0.00           N  \nATOM    146  CA  ALA A  21      23.333  12.048  -9.875  1.00  0.00           C  \nATOM    147  C   ALA A  21      22.588  11.220 -10.940  1.00  0.00           C  \nATOM    148  O   ALA A  21      21.798  10.330 -10.574  1.00  0.00           O  \nATOM    149  CB  ALA A  21      22.649  13.400  -9.686  1.00  0.00           C  \nATOM    150  N   GLY A  22      22.880  11.527 -12.217  1.00  0.00           N  \nATOM    151  CA  GLY A  22      22.358  10.826 -13.415  1.00  0.00           C  \nATOM    152  C   GLY A  22      22.869   9.383 -13.534  1.00  0.00           C  \nATOM    153  O   GLY A  22      22.133   8.468 -13.899  1.00  0.00           O  \nATOM    154  N   GLU A  23      24.120   9.159 -13.152  1.00  0.00           N  \nATOM    155  CA  GLU A  23      24.597   7.770 -13.111  1.00  0.00           C  \nATOM    156  C   GLU A  23      23.840   6.960 -12.029  1.00  0.00           C  \nATOM    157  O   GLU A  23      23.740   5.738 -12.014  1.00  0.00           O  \nATOM    158  CB  GLU A  23      26.084   7.728 -12.779  1.00  0.00           C  \nATOM    159  CG  GLU A  23      26.932   8.853 -13.404  1.00  0.00           C  \nATOM    160  CD  GLU A  23      28.424   8.463 -13.433  1.00  0.00           C  \nATOM    161  OE1 GLU A  23      29.209   9.104 -12.715  1.00  0.00           O  \nATOM    162  OE2 GLU A  23      28.799   7.546 -14.197  1.00  0.00           O  \nATOM    163  N   TYR A  24      23.322   7.629 -11.073  1.00  0.00           N  \nATOM    164  CA  TYR A  24      22.745   6.862  -9.994  1.00  0.00           C  \nATOM    165  C   TYR A  24      21.312   6.645 -10.386  1.00  0.00           C  \nATOM    166  O   TYR A  24      20.634   5.694 -10.019  1.00  0.00           O  \nATOM    167  CB  TYR A  24      22.781   7.678  -8.684  1.00  0.00           C  \nATOM    168  CG  TYR A  24      24.177   7.873  -8.031  1.00  0.00           C  \nATOM    169  CD1 TYR A  24      24.322   8.710  -6.936  1.00  0.00           C  \nATOM    170  CD2 TYR A  24      25.291   7.201  -8.521  1.00  0.00           C  \nATOM    171  CE1 TYR A  24      25.581   8.894  -6.341  1.00  0.00           C  \nATOM    172  CE2 TYR A  24      26.539   7.378  -7.936  1.00  0.00           C  \nATOM    173  CZ  TYR A  24      26.689   8.238  -6.842  1.00  0.00           C  \nATOM    174  OH  TYR A  24      27.941   8.516  -6.341  1.00  0.00           O  \nATOM    175  N   GLY A  25      20.911   7.601 -11.151  1.00  0.00           N  \nATOM    176  CA  GLY A  25      19.539   7.588 -11.445  1.00  0.00           C  \nATOM    177  C   GLY A  25      19.305   6.527 -12.491  1.00  0.00           C  \nATOM    178  O   GLY A  25      18.159   6.142 -12.758  1.00  0.00           O  \nATOM    179  N   ALA A  26      20.392   6.134 -13.070  1.00  0.00           N  \nATOM    180  CA  ALA A  26      20.194   5.234 -14.181  1.00  0.00           C  \nATOM    181  C   ALA A  26      20.279   3.881 -13.543  1.00  0.00           C  \nATOM    182  O   ALA A  26      19.629   2.958 -14.036  1.00  0.00           O  \nATOM    183  CB  ALA A  26      21.300   5.427 -15.219  1.00  0.00           C  \nATOM    184  N   GLU A  27      21.012   3.875 -12.431  1.00  0.00           N  \nATOM    185  CA  GLU A  27      21.208   2.587 -11.723  1.00  0.00           C  \nATOM    186  C   GLU A  27      19.932   2.235 -10.974  1.00  0.00           C  \nATOM    187  O   GLU A  27      19.627   1.037 -10.858  1.00  0.00           O  \nATOM    188  CB  GLU A  27      22.380   2.708 -10.771  1.00  0.00           C  \nATOM    189  CG  GLU A  27      22.500   1.578  -9.773  1.00  0.00           C  \nATOM    190  CD  GLU A  27      23.727   1.761  -8.877  1.00  0.00           C  \nATOM    191  OE1 GLU A  27      24.666   2.471  -9.262  1.00  0.00           O  \nATOM    192  OE2 GLU A  27      23.725   1.150  -7.806  1.00  0.00           O  \nATOM    193  N   ALA A  28      19.178   3.275 -10.550  1.00  0.00           N  \nATOM    194  CA  ALA A  28      18.053   2.999  -9.608  1.00  0.00           C  \nATOM    195  C   ALA A  28      16.951   2.327 -10.428  1.00  0.00           C  \nATOM    196  O   ALA A  28      16.235   1.414 -10.000  1.00  0.00           O  \nATOM    197  CB  ALA A  28      17.610   4.390  -9.267  1.00  0.00           C  \nATOM    198  N   LEU A  29      16.921   2.865 -11.650  1.00  0.00           N  \nATOM    199  CA  LEU A  29      16.010   2.469 -12.718  1.00  0.00           C  \nATOM    200  C   LEU A  29      16.282   1.042 -13.109  1.00  0.00           C  \nATOM    201  O   LEU A  29      15.328   0.268 -13.199  1.00  0.00           O  \nATOM    202  CB  LEU A  29      16.181   3.262 -13.993  1.00  0.00           C  \nATOM    203  CG  LEU A  29      15.469   4.607 -13.909  1.00  0.00           C  \nATOM    204  CD1 LEU A  29      16.006   5.424 -15.120  1.00  0.00           C  \nATOM    205  CD2 LEU A  29      13.904   4.469 -13.833  1.00  0.00           C  \nATOM    206  N   GLU A  30      17.551   0.744 -13.331  1.00  0.00           N  \nATOM    207  CA  GLU A  30      17.908  -0.677 -13.625  1.00  0.00           C  \nATOM    208  C   GLU A  30      17.463  -1.654 -12.507  1.00  0.00           C  \nATOM    209  O   GLU A  30      16.851  -2.701 -12.751  1.00  0.00           O  \nATOM    210  CB  GLU A  30      19.434  -0.753 -13.768  1.00  0.00           C  \nATOM    211  CG  GLU A  30      19.942  -2.066 -14.391  1.00  0.00           C  \nATOM    212  CD  GLU A  30      21.477  -2.092 -14.334  1.00  0.00           C  \nATOM    213  OE1 GLU A  30      22.013  -3.118 -13.917  1.00  0.00           O  \nATOM    214  OE2 GLU A  30      22.135  -1.091 -14.654  1.00  0.00           O  \nATOM    215  N   ARG A  31      17.806  -1.299 -11.294  1.00  0.00           N  \nATOM    216  CA  ARG A  31      17.385  -2.086 -10.118  1.00  0.00           C  \nATOM    217  C   ARG A  31      15.893  -2.420 -10.128  1.00  0.00           C  \nATOM    218  O   ARG A  31      15.500  -3.505  -9.711  1.00  0.00           O  \nATOM    219  CB  ARG A  31      17.685  -1.280  -8.821  1.00  0.00           C  \nATOM    220  CG  ARG A  31      19.183  -1.147  -8.548  1.00  0.00           C  \nATOM    221  CD  ARG A  31      19.570  -0.414  -7.263  1.00  0.00           C  \nATOM    222  NE  ARG A  31      21.019  -0.528  -7.033  1.00  0.00           N  \nATOM    223  CZ  ARG A  31      21.679  -1.560  -6.508  1.00  0.00           C  \nATOM    224  NH1 ARG A  31      21.189  -2.686  -5.996  1.00  0.00           N  \nATOM    225  NH2 ARG A  31      22.959  -1.432  -6.489  1.00  0.00           N  \nATOM    226  N   MET A  32      15.112  -1.444 -10.562  1.00  0.00           N  \nATOM    227  CA  MET A  32      13.649  -1.528 -10.398  1.00  0.00           C  \nATOM    228  C   MET A  32      13.076  -2.457 -11.445  1.00  0.00           C  \nATOM    229  O   MET A  32      12.154  -3.208 -11.201  1.00  0.00           O  \nATOM    230  CB  MET A  32      13.050  -0.143 -10.664  1.00  0.00           C  \nATOM    231  CG  MET A  32      11.536  -0.159 -10.564  1.00  0.00           C  \nATOM    232  SD  MET A  32      10.764   1.302 -11.203  1.00  0.00           S  \nATOM    233  CE  MET A  32      11.496   1.425 -12.844  1.00  0.00           C  \nATOM    234  N   PHE A  33      13.624  -2.305 -12.601  1.00  0.00           N  \nATOM    235  CA  PHE A  33      13.248  -3.054 -13.762  1.00  0.00           C  \nATOM    236  C   PHE A  33      13.554  -4.513 -13.465  1.00  0.00           C  \nATOM    237  O   PHE A  33      12.777  -5.416 -13.836  1.00  0.00           O  \nATOM    238  CB  PHE A  33      13.984  -2.531 -14.967  1.00  0.00           C  \nATOM    239  CG  PHE A  33      13.549  -1.152 -15.525  1.00  0.00           C  \nATOM    240  CD1 PHE A  33      12.244  -0.744 -15.452  1.00  0.00           C  \nATOM    241  CD2 PHE A  33      14.477  -0.303 -16.108  1.00  0.00           C  \nATOM    242  CE1 PHE A  33      11.863   0.493 -15.969  1.00  0.00           C  \nATOM    243  CE2 PHE A  33      14.100   0.940 -16.627  1.00  0.00           C  \nATOM    244  CZ  PHE A  33      12.790   1.334 -16.564  1.00  0.00           C  \nATOM    245  N   LEU A  34      14.620  -4.649 -12.700  1.00  0.00           N  \nATOM    246  CA  LEU A  34      15.154  -5.967 -12.317  1.00  0.00           C  \nATOM    247  C   LEU A  34      14.364  -6.567 -11.181  1.00  0.00           C  \nATOM    248  O   LEU A  34      14.091  -7.771 -11.273  1.00  0.00           O  \nATOM    249  CB  LEU A  34      16.648  -5.888 -11.924  1.00  0.00           C  \nATOM    250  CG  LEU A  34      17.594  -6.637 -12.878  1.00  0.00           C  \nATOM    251  CD1 LEU A  34      17.560  -6.062 -14.263  1.00  0.00           C  \nATOM    252  CD2 LEU A  34      19.038  -6.605 -12.394  1.00  0.00           C  \nATOM    253  N   SER A  35      14.002  -5.724 -10.172  1.00  0.00           N  \nATOM    254  CA  SER A  35      13.501  -6.229  -8.878  1.00  0.00           C  \nATOM    255  C   SER A  35      11.966  -6.373  -8.884  1.00  0.00           C  \nATOM    256  O   SER A  35      11.303  -7.289  -8.347  1.00  0.00           O  \nATOM    257  CB  SER A  35      14.070  -5.308  -7.792  1.00  0.00           C  \nATOM    258  OG  SER A  35      15.516  -5.241  -7.871  1.00  0.00           O  \nATOM    259  N   PHE A  36      11.426  -5.446  -9.595  1.00  0.00           N  \nATOM    260  CA  PHE A  36       9.991  -5.310  -9.822  1.00  0.00           C  \nATOM    261  C   PHE A  36       9.695  -5.307 -11.324  1.00  0.00           C  \nATOM    262  O   PHE A  36       9.607  -4.280 -11.989  1.00  0.00           O  \nATOM    263  CB  PHE A  36       9.613  -3.963  -9.224  1.00  0.00           C  \nATOM    264  CG  PHE A  36      10.143  -3.854  -7.793  1.00  0.00           C  \nATOM    265  CD1 PHE A  36      11.102  -2.933  -7.480  1.00  0.00           C  \nATOM    266  CD2 PHE A  36       9.669  -4.699  -6.804  1.00  0.00           C  \nATOM    267  CE1 PHE A  36      11.561  -2.838  -6.152  1.00  0.00           C  \nATOM    268  CE2 PHE A  36      10.137  -4.611  -5.500  1.00  0.00           C  \nATOM    269  CZ  PHE A  36      11.073  -3.672  -5.166  1.00  0.00           C  \nATOM    270  N   PRO A  37       9.573  -6.468 -11.879  1.00  0.00           N  \nATOM    271  CA  PRO A  37       9.555  -6.634 -13.332  1.00  0.00           C  \nATOM    272  C   PRO A  37       8.253  -6.068 -13.942  1.00  0.00           C  \nATOM    273  O   PRO A  37       8.081  -5.921 -15.152  1.00  0.00           O  \nATOM    274  CB  PRO A  37       9.656  -8.128 -13.521  1.00  0.00           C  \nATOM    275  CG  PRO A  37      10.280  -8.601 -12.254  1.00  0.00           C  \nATOM    276  CD  PRO A  37       9.684  -7.734 -11.177  1.00  0.00           C  \nATOM    277  N   THR A  38       7.314  -5.721 -13.099  1.00  0.00           N  \nATOM    278  CA  THR A  38       6.008  -5.254 -13.600  1.00  0.00           C  \nATOM    279  C   THR A  38       6.134  -3.831 -14.168  1.00  0.00           C  \nATOM    280  O   THR A  38       5.400  -3.378 -15.059  1.00  0.00           O  \nATOM    281  CB  THR A  38       5.061  -5.410 -12.408  1.00  0.00           C  \nATOM    282  OG1 THR A  38       3.758  -5.866 -12.720  1.00  0.00           O  \nATOM    283  CG2 THR A  38       5.126  -4.378 -11.290  1.00  0.00           C  \nATOM    284  N   THR A  39       7.118  -3.154 -13.635  1.00  0.00           N  \nATOM    285  CA  THR A  39       7.377  -1.774 -14.004  1.00  0.00           C  \nATOM    286  C   THR A  39       7.820  -1.696 -15.471  1.00  0.00           C  \nATOM    287  O   THR A  39       7.578  -0.666 -16.134  1.00  0.00           O  \nATOM    288  CB  THR A  39       8.481  -1.324 -13.035  1.00  0.00           C  \nATOM    289  OG1 THR A  39       9.595  -2.164 -13.310  1.00  0.00           O  \nATOM    290  CG2 THR A  39       8.071  -1.511 -11.554  1.00  0.00           C  \nATOM    291  N   LYS A  40       8.460  -2.806 -15.928  1.00  0.00           N  \nATOM    292  CA  LYS A  40       8.967  -2.910 -17.316  1.00  0.00           C  \nATOM    293  C   LYS A  40       7.928  -2.544 -18.398  1.00  0.00           C  \nATOM    294  O   LYS A  40       8.303  -2.175 -19.525  1.00  0.00           O  \nATOM    295  CB  LYS A  40       9.508  -4.292 -17.571  1.00  0.00           C  \nATOM    296  CG  LYS A  40      10.772  -4.523 -16.753  1.00  0.00           C  \nATOM    297  CD  LYS A  40      11.738  -5.461 -17.513  1.00  0.00           C  \nATOM    298  CE  LYS A  40      11.663  -6.933 -17.053  1.00  0.00           C  \nATOM    299  NZ  LYS A  40      12.860  -7.311 -16.261  1.00  0.00           N  \nATOM    300  N   THR A  41       6.658  -2.561 -18.009  1.00  0.00           N  \nATOM    301  CA  THR A  41       5.495  -2.363 -18.902  1.00  0.00           C  \nATOM    302  C   THR A  41       5.400  -0.965 -19.485  1.00  0.00           C  \nATOM    303  O   THR A  41       4.740  -0.746 -20.508  1.00  0.00           O  \nATOM    304  CB  THR A  41       4.206  -2.645 -18.142  1.00  0.00           C  \nATOM    305  OG1 THR A  41       3.572  -3.674 -18.808  1.00  0.00           O  \nATOM    306  CG2 THR A  41       3.210  -1.496 -18.146  1.00  0.00           C  \nATOM    307  N   TYR A  42       6.068  -0.071 -18.828  1.00  0.00           N  \nATOM    308  CA  TYR A  42       5.923   1.311 -19.219  1.00  0.00           C  \nATOM    309  C   TYR A  42       6.937   1.647 -20.278  1.00  0.00           C  \nATOM    310  O   TYR A  42       6.822   2.645 -20.987  1.00  0.00           O  \nATOM    311  CB  TYR A  42       6.145   2.149 -18.008  1.00  0.00           C  \nATOM    312  CG  TYR A  42       4.991   1.944 -17.029  1.00  0.00           C  \nATOM    313  CD1 TYR A  42       3.931   2.805 -17.144  1.00  0.00           C  \nATOM    314  CD2 TYR A  42       4.997   0.933 -16.080  1.00  0.00           C  \nATOM    315  CE1 TYR A  42       2.868   2.714 -16.312  1.00  0.00           C  \nATOM    316  CE2 TYR A  42       3.926   0.828 -15.232  1.00  0.00           C  \nATOM    317  CZ  TYR A  42       2.861   1.728 -15.347  1.00  0.00           C  \nATOM    318  OH  TYR A  42       1.781   1.636 -14.516  1.00  0.00           O  \nATOM    319  N   PHE A  43       7.858   0.726 -20.368  1.00  0.00           N  \nATOM    320  CA  PHE A  43       9.048   1.049 -21.095  1.00  0.00           C  \nATOM    321  C   PHE A  43       9.256   0.102 -22.240  1.00  0.00           C  \nATOM    322  O   PHE A  43      10.373  -0.398 -22.401  1.00  0.00           O  \nATOM    323  CB  PHE A  43      10.166   0.907 -20.098  1.00  0.00           C  \nATOM    324  CG  PHE A  43      10.226   2.190 -19.226  1.00  0.00           C  \nATOM    325  CD1 PHE A  43       9.968   2.142 -17.870  1.00  0.00           C  \nATOM    326  CD2 PHE A  43      10.509   3.405 -19.814  1.00  0.00           C  \nATOM    327  CE1 PHE A  43      10.057   3.299 -17.099  1.00  0.00           C  \nATOM    328  CE2 PHE A  43      10.602   4.572 -19.050  1.00  0.00           C  \nATOM    329  CZ  PHE A  43      10.385   4.516 -17.685  1.00  0.00           C  \nATOM    330  N   PRO A  44       8.258  -0.126 -23.070  1.00  0.00           N  \nATOM    331  CA  PRO A  44       8.394  -1.264 -23.982  1.00  0.00           C  \nATOM    332  C   PRO A  44       9.263  -0.856 -25.188  1.00  0.00           C  \nATOM    333  O   PRO A  44       9.565  -1.703 -26.033  1.00  0.00           O  \nATOM    334  CB  PRO A  44       6.971  -1.604 -24.377  1.00  0.00           C  \nATOM    335  CG  PRO A  44       6.073  -0.712 -23.516  1.00  0.00           C  \nATOM    336  CD  PRO A  44       6.924   0.508 -23.212  1.00  0.00           C  \nATOM    337  N   HIS A  45       9.680   0.433 -25.210  1.00  0.00           N  \nATOM    338  CA  HIS A  45      10.425   1.062 -26.321  1.00  0.00           C  \nATOM    339  C   HIS A  45      11.843   1.331 -25.829  1.00  0.00           C  \nATOM    340  O   HIS A  45      12.712   2.029 -26.382  1.00  0.00           O  \nATOM    341  CB  HIS A  45       9.740   2.341 -26.825  1.00  0.00           C  \nATOM    342  CG  HIS A  45       9.538   3.448 -25.778  1.00  0.00           C  \nATOM    343  ND1 HIS A  45       8.801   3.203 -24.607  1.00  0.00           N  \nATOM    344  CD2 HIS A  45       9.998   4.768 -25.780  1.00  0.00           C  \nATOM    345  CE1 HIS A  45       8.802   4.385 -23.876  1.00  0.00           C  \nATOM    346  NE2 HIS A  45       9.542   5.371 -24.592  1.00  0.00           N  \nATOM    347  N   PHE A  46      12.077   0.690 -24.733  1.00  0.00           N  \nATOM    348  CA  PHE A  46      13.396   0.798 -24.206  1.00  0.00           C  \nATOM    349  C   PHE A  46      14.072  -0.551 -24.321  1.00  0.00           C  \nATOM    350  O   PHE A  46      13.457  -1.630 -24.184  1.00  0.00           O  \nATOM    351  CB  PHE A  46      13.261   1.212 -22.737  1.00  0.00           C  \nATOM    352  CG  PHE A  46      13.145   2.734 -22.513  1.00  0.00           C  \nATOM    353  CD1 PHE A  46      14.008   3.367 -21.651  1.00  0.00           C  \nATOM    354  CD2 PHE A  46      12.195   3.474 -23.154  1.00  0.00           C  \nATOM    355  CE1 PHE A  46      13.927   4.734 -21.433  1.00  0.00           C  \nATOM    356  CE2 PHE A  46      12.106   4.831 -22.952  1.00  0.00           C  \nATOM    357  CZ  PHE A  46      12.976   5.473 -22.088  1.00  0.00           C  \nATOM    358  N   ASP A  47      15.329  -0.428 -24.601  1.00  0.00           N  \nATOM    359  CA  ASP A  47      16.173  -1.565 -24.294  1.00  0.00           C  \nATOM    360  C   ASP A  47      16.417  -1.469 -22.781  1.00  0.00           C  \nATOM    361  O   ASP A  47      16.945  -0.458 -22.329  1.00  0.00           O  \nATOM    362  CB  ASP A  47      17.494  -1.378 -25.018  1.00  0.00           C  \nATOM    363  CG  ASP A  47      18.153  -2.732 -25.047  1.00  0.00           C  \nATOM    364  OD1 ASP A  47      19.218  -2.906 -24.472  1.00  0.00           O  \nATOM    365  OD2 ASP A  47      17.533  -3.623 -25.605  1.00  0.00           O  \nATOM    366  N   LEU A  48      16.011  -2.458 -22.026  1.00  0.00           N  \nATOM    367  CA  LEU A  48      16.052  -2.391 -20.555  1.00  0.00           C  \nATOM    368  C   LEU A  48      17.238  -3.215 -20.089  1.00  0.00           C  \nATOM    369  O   LEU A  48      17.310  -3.704 -18.955  1.00  0.00           O  \nATOM    370  CB  LEU A  48      14.733  -2.953 -19.979  1.00  0.00           C  \nATOM    371  CG  LEU A  48      13.734  -1.853 -19.594  1.00  0.00           C  \nATOM    372  CD1 LEU A  48      13.961  -0.498 -20.240  1.00  0.00           C  \nATOM    373  CD2 LEU A  48      12.294  -2.290 -19.712  1.00  0.00           C  \nATOM    374  N   SER A  49      18.160  -3.330 -20.976  1.00  0.00           N  \nATOM    375  CA  SER A  49      19.295  -4.196 -20.705  1.00  0.00           C  \nATOM    376  C   SER A  49      20.412  -3.324 -20.153  1.00  0.00           C  \nATOM    377  O   SER A  49      20.356  -2.095 -20.283  1.00  0.00           O  \nATOM    378  CB  SER A  49      19.752  -4.904 -21.981  1.00  0.00           C  \nATOM    379  OG  SER A  49      20.653  -4.033 -22.629  1.00  0.00           O  \nATOM    380  N   HIS A  50      21.361  -4.006 -19.561  1.00  0.00           N  \nATOM    381  CA  HIS A  50      22.338  -3.378 -18.666  1.00  0.00           C  \nATOM    382  C   HIS A  50      22.862  -2.066 -19.227  1.00  0.00           C  \nATOM    383  O   HIS A  50      22.563  -0.993 -18.674  1.00  0.00           O  \nATOM    384  CB  HIS A  50      23.497  -4.314 -18.355  1.00  0.00           C  \nATOM    385  CG  HIS A  50      24.468  -3.529 -17.465  1.00  0.00           C  \nATOM    386  ND1 HIS A  50      24.009  -2.750 -16.399  1.00  0.00           N  \nATOM    387  CD2 HIS A  50      25.830  -3.413 -17.533  1.00  0.00           C  \nATOM    388  CE1 HIS A  50      25.102  -2.153 -15.792  1.00  0.00           C  \nATOM    389  NE2 HIS A  50      26.220  -2.563 -16.492  1.00  0.00           N  \nATOM    390  N   GLY A  51      23.557  -2.154 -20.342  1.00  0.00           N  \nATOM    391  CA  GLY A  51      24.323  -0.942 -20.708  1.00  0.00           C  \nATOM    392  C   GLY A  51      23.484   0.014 -21.557  1.00  0.00           C  \nATOM    393  O   GLY A  51      24.056   0.903 -22.212  1.00  0.00           O  \nATOM    394  N   SER A  52      22.159  -0.178 -21.485  1.00  0.00           N  \nATOM    395  CA  SER A  52      21.255   0.593 -22.341  1.00  0.00           C  \nATOM    396  C   SER A  52      21.278   2.081 -22.052  1.00  0.00           C  \nATOM    397  O   SER A  52      20.996   2.564 -20.949  1.00  0.00           O  \nATOM    398  CB  SER A  52      19.799   0.138 -22.285  1.00  0.00           C  \nATOM    399  OG  SER A  52      19.024   1.090 -23.014  1.00  0.00           O  \nATOM    400  N   ALA A  53      21.638   2.671 -23.154  1.00  0.00           N  \nATOM    401  CA  ALA A  53      21.725   4.083 -23.445  1.00  0.00           C  \nATOM    402  C   ALA A  53      20.394   4.757 -23.120  1.00  0.00           C  \nATOM    403  O   ALA A  53      20.431   5.882 -22.643  1.00  0.00           O  \nATOM    404  CB  ALA A  53      22.036   4.224 -24.940  1.00  0.00           C  \nATOM    405  N   GLN A  54      19.277   4.071 -23.380  1.00  0.00           N  \nATOM    406  CA  GLN A  54      17.972   4.731 -23.246  1.00  0.00           C  \nATOM    407  C   GLN A  54      17.707   4.882 -21.756  1.00  0.00           C  \nATOM    408  O   GLN A  54      17.383   5.999 -21.333  1.00  0.00           O  \nATOM    409  CB  GLN A  54      16.865   3.981 -23.986  1.00  0.00           C  \nATOM    410  CG  GLN A  54      17.172   3.902 -25.482  1.00  0.00           C  \nATOM    411  CD  GLN A  54      16.475   2.729 -26.173  1.00  0.00           C  \nATOM    412  OE1 GLN A  54      16.830   1.580 -25.916  1.00  0.00           O  \nATOM    413  NE2 GLN A  54      15.541   3.041 -27.066  1.00  0.00           N  \nATOM    414  N   VAL A  55      17.922   3.798 -21.018  1.00  0.00           N  \nATOM    415  CA  VAL A  55      17.923   3.888 -19.549  1.00  0.00           C  \nATOM    416  C   VAL A  55      19.048   4.789 -19.014  1.00  0.00           C  \nATOM    417  O   VAL A  55      18.880   5.454 -17.997  1.00  0.00           O  \nATOM    418  CB  VAL A  55      18.062   2.523 -18.907  1.00  0.00           C  \nATOM    419  CG1 VAL A  55      17.914   2.697 -17.388  1.00  0.00           C  \nATOM    420  CG2 VAL A  55      16.933   1.641 -19.372  1.00  0.00           C  \nATOM    421  N   LYS A  56      20.161   4.809 -19.690  1.00  0.00           N  \nATOM    422  CA  LYS A  56      21.193   5.707 -19.211  1.00  0.00           C  \nATOM    423  C   LYS A  56      20.667   7.126 -19.235  1.00  0.00           C  \nATOM    424  O   LYS A  56      20.795   7.947 -18.319  1.00  0.00           O  \nATOM    425  CB  LYS A  56      22.396   5.631 -20.169  1.00  0.00           C  \nATOM    426  CG  LYS A  56      23.693   5.064 -19.592  1.00  0.00           C  \nATOM    427  CD  LYS A  56      23.505   3.739 -18.853  1.00  0.00           C  \nATOM    428  CE  LYS A  56      24.739   2.836 -18.919  1.00  0.00           C  \nATOM    429  NZ  LYS A  56      25.958   3.605 -19.261  1.00  0.00           N  \nATOM    430  N   GLY A  57      20.071   7.382 -20.329  1.00  0.00           N  \nATOM    431  CA  GLY A  57      19.713   8.759 -20.583  1.00  0.00           C  \nATOM    432  C   GLY A  57      18.446   9.113 -19.816  1.00  0.00           C  \nATOM    433  O   GLY A  57      18.122  10.312 -19.696  1.00  0.00           O  \nATOM    434  N   HIS A  58      17.806   8.057 -19.337  1.00  0.00           N  \nATOM    435  CA  HIS A  58      16.557   8.238 -18.589  1.00  0.00           C  \nATOM    436  C   HIS A  58      16.809   8.616 -17.119  1.00  0.00           C  \nATOM    437  O   HIS A  58      16.164   9.516 -16.627  1.00  0.00           O  \nATOM    438  CB  HIS A  58      15.727   6.972 -18.635  1.00  0.00           C  \nATOM    439  CG  HIS A  58      14.323   7.382 -18.190  1.00  0.00           C  \nATOM    440  ND1 HIS A  58      13.654   8.373 -18.938  1.00  0.00           N  \nATOM    441  CD2 HIS A  58      13.533   6.965 -17.121  1.00  0.00           C  \nATOM    442  CE1 HIS A  58      12.439   8.584 -18.390  1.00  0.00           C  \nATOM    443  NE2 HIS A  58      12.345   7.716 -17.254  1.00  0.00           N  \nATOM    444  N   GLY A  59      17.707   7.852 -16.512  1.00  0.00           N  \nATOM    445  CA  GLY A  59      18.425   8.109 -15.292  1.00  0.00           C  \nATOM    446  C   GLY A  59      18.704   9.610 -15.241  1.00  0.00           C  \nATOM    447  O   GLY A  59      18.415  10.213 -14.196  1.00  0.00           O  \nATOM    448  N   LYS A  60      19.183  10.171 -16.382  1.00  0.00           N  \nATOM    449  CA  LYS A  60      19.675  11.556 -16.350  1.00  0.00           C  \nATOM    450  C   LYS A  60      18.480  12.433 -16.047  1.00  0.00           C  \nATOM    451  O   LYS A  60      18.616  13.365 -15.250  1.00  0.00           O  \nATOM    452  CB  LYS A  60      20.382  12.058 -17.607  1.00  0.00           C  \nATOM    453  CG  LYS A  60      21.648  11.300 -18.037  1.00  0.00           C  \nATOM    454  CD  LYS A  60      22.479  12.116 -19.055  1.00  0.00           C  \nATOM    455  CE  LYS A  60      23.991  12.020 -18.756  1.00  0.00           C  \nATOM    456  NZ  LYS A  60      24.734  12.908 -19.646  1.00  0.00           N  \nATOM    457  N   LYS A  61      17.380  12.053 -16.676  1.00  0.00           N  \nATOM    458  CA  LYS A  61      16.097  12.796 -16.637  1.00  0.00           C  \nATOM    459  C   LYS A  61      15.438  12.680 -15.286  1.00  0.00           C  \nATOM    460  O   LYS A  61      15.056  13.728 -14.754  1.00  0.00           O  \nATOM    461  CB  LYS A  61      15.130  12.326 -17.706  1.00  0.00           C  \nATOM    462  CG  LYS A  61      15.798  12.610 -19.031  1.00  0.00           C  \nATOM    463  CD  LYS A  61      14.813  12.616 -20.171  1.00  0.00           C  \nATOM    464  CE  LYS A  61      15.257  11.545 -21.134  1.00  0.00           C  \nATOM    465  NZ  LYS A  61      14.091  11.235 -21.963  1.00  0.00           N  \nATOM    466  N   VAL A  62      15.359  11.442 -14.768  1.00  0.00           N  \nATOM    467  CA  VAL A  62      14.812  11.260 -13.433  1.00  0.00           C  \nATOM    468  C   VAL A  62      15.663  12.107 -12.468  1.00  0.00           C  \nATOM    469  O   VAL A  62      15.088  12.889 -11.715  1.00  0.00           O  \nATOM    470  CB  VAL A  62      14.737   9.751 -13.108  1.00  0.00           C  \nATOM    471  CG1 VAL A  62      14.292   9.428 -11.694  1.00  0.00           C  \nATOM    472  CG2 VAL A  62      13.746   9.089 -14.054  1.00  0.00           C  \nATOM    473  N   ALA A  63      16.988  11.982 -12.566  1.00  0.00           N  \nATOM    474  CA  ALA A  63      17.919  12.629 -11.637  1.00  0.00           C  \nATOM    475  C   ALA A  63      17.792  14.142 -11.605  1.00  0.00           C  \nATOM    476  O   ALA A  63      17.823  14.731 -10.523  1.00  0.00           O  \nATOM    477  CB  ALA A  63      19.335  12.282 -12.045  1.00  0.00           C  \nATOM    478  N   ASP A  64      17.667  14.677 -12.788  1.00  0.00           N  \nATOM    479  CA  ASP A  64      17.413  16.094 -12.991  1.00  0.00           C  \nATOM    480  C   ASP A  64      16.062  16.488 -12.393  1.00  0.00           C  \nATOM    481  O   ASP A  64      15.938  17.584 -11.847  1.00  0.00           O  \nATOM    482  CB  ASP A  64      17.530  16.460 -14.492  1.00  0.00           C  \nATOM    483  CG  ASP A  64      19.010  16.432 -14.956  1.00  0.00           C  \nATOM    484  OD1 ASP A  64      19.887  16.485 -14.092  1.00  0.00           O  \nATOM    485  OD2 ASP A  64      19.294  16.365 -16.164  1.00  0.00           O  \nATOM    486  N   ALA A  65      15.052  15.643 -12.492  1.00  0.00           N  \nATOM    487  CA  ALA A  65      13.771  16.098 -11.947  1.00  0.00           C  \nATOM    488  C   ALA A  65      13.833  16.038 -10.432  1.00  0.00           C  \nATOM    489  O   ALA A  65      13.099  16.726  -9.706  1.00  0.00           O  \nATOM    490  CB  ALA A  65      12.638  15.215 -12.465  1.00  0.00           C  \nATOM    491  N   LEU A  66      14.710  15.172  -9.986  1.00  0.00           N  \nATOM    492  CA  LEU A  66      14.868  15.082  -8.541  1.00  0.00           C  \nATOM    493  C   LEU A  66      15.577  16.337  -8.003  1.00  0.00           C  \nATOM    494  O   LEU A  66      15.239  16.795  -6.909  1.00  0.00           O  \nATOM    495  CB  LEU A  66      15.700  13.835  -8.221  1.00  0.00           C  \nATOM    496  CG  LEU A  66      14.885  12.534  -8.290  1.00  0.00           C  \nATOM    497  CD1 LEU A  66      15.651  11.368  -7.633  1.00  0.00           C  \nATOM    498  CD2 LEU A  66      13.559  12.718  -7.578  1.00  0.00           C  \nATOM    499  N   THR A  67      16.543  16.845  -8.784  1.00  0.00           N  \nATOM    500  CA  THR A  67      17.359  18.021  -8.381  1.00  0.00           C  \nATOM    501  C   THR A  67      16.529  19.290  -8.496  1.00  0.00           C  \nATOM    502  O   THR A  67      16.729  20.211  -7.718  1.00  0.00           O  \nATOM    503  CB  THR A  67      18.643  18.203  -9.189  1.00  0.00           C  \nATOM    504  OG1 THR A  67      19.375  17.016  -9.113  1.00  0.00           O  \nATOM    505  CG2 THR A  67      19.562  19.296  -8.634  1.00  0.00           C  \nATOM    506  N   ASN A  68      15.630  19.266  -9.445  1.00  0.00           N  \nATOM    507  CA  ASN A  68      14.748  20.402  -9.590  1.00  0.00           C  \nATOM    508  C   ASN A  68      13.825  20.311  -8.390  1.00  0.00           C  \nATOM    509  O   ASN A  68      13.499  21.365  -7.892  1.00  0.00           O  \nATOM    510  CB  ASN A  68      13.953  20.414 -10.917  1.00  0.00           C  \nATOM    511  CG  ASN A  68      13.255  21.760 -11.196  1.00  0.00           C  \nATOM    512  OD1 ASN A  68      12.103  21.975 -10.851  1.00  0.00           O  \nATOM    513  ND2 ASN A  68      13.909  22.691 -11.843  1.00  0.00           N  \nATOM    514  N   ALA A  69      13.413  19.112  -7.946  1.00  0.00           N  \nATOM    515  CA  ALA A  69      12.654  19.041  -6.666  1.00  0.00           C  \nATOM    516  C   ALA A  69      13.468  19.531  -5.420  1.00  0.00           C  \nATOM    517  O   ALA A  69      12.916  20.301  -4.627  1.00  0.00           O  \nATOM    518  CB  ALA A  69      12.120  17.650  -6.457  1.00  0.00           C  \nATOM    519  N   VAL A  70      14.755  19.165  -5.231  1.00  0.00           N  \nATOM    520  CA  VAL A  70      15.579  19.630  -4.047  1.00  0.00           C  \nATOM    521  C   VAL A  70      15.669  21.175  -4.001  1.00  0.00           C  \nATOM    522  O   VAL A  70      15.547  21.858  -2.965  1.00  0.00           O  \nATOM    523  CB  VAL A  70      17.021  19.107  -4.190  1.00  0.00           C  \nATOM    524  CG1 VAL A  70      17.764  19.193  -2.862  1.00  0.00           C  \nATOM    525  CG2 VAL A  70      17.097  17.700  -4.701  1.00  0.00           C  \nATOM    526  N   ALA A  71      15.884  21.714  -5.168  1.00  0.00           N  \nATOM    527  CA  ALA A  71      16.007  23.146  -5.399  1.00  0.00           C  \nATOM    528  C   ALA A  71      14.644  23.582  -5.871  1.00  0.00           C  \nATOM    529  O   ALA A  71      14.511  23.520  -7.068  1.00  0.00           O  \nATOM    530  CB  ALA A  71      16.935  23.277  -6.615  1.00  0.00           C  \nATOM    531  N   HIS A  72      13.766  23.943  -5.001  1.00  0.00           N  \nATOM    532  CA  HIS A  72      12.365  24.311  -5.154  1.00  0.00           C  \nATOM    533  C   HIS A  72      11.530  23.320  -4.317  1.00  0.00           C  \nATOM    534  O   HIS A  72      10.338  23.174  -4.506  1.00  0.00           O  \nATOM    535  CB  HIS A  72      11.857  24.377  -6.606  1.00  0.00           C  \nATOM    536  CG  HIS A  72      12.393  25.413  -7.632  1.00  0.00           C  \nATOM    537  ND1 HIS A  72      13.092  25.007  -8.805  1.00  0.00           N  \nATOM    538  CD2 HIS A  72      12.326  26.806  -7.659  1.00  0.00           C  \nATOM    539  CE1 HIS A  72      13.430  26.141  -9.531  1.00  0.00           C  \nATOM    540  NE2 HIS A  72      12.975  27.255  -8.853  1.00  0.00           N  \nATOM    541  N   VAL A  73      12.172  22.628  -3.412  1.00  0.00           N  \nATOM    542  CA  VAL A  73      11.550  21.738  -2.422  1.00  0.00           C  \nATOM    543  C   VAL A  73      10.358  22.384  -1.711  1.00  0.00           C  \nATOM    544  O   VAL A  73       9.450  21.639  -1.373  1.00  0.00           O  \nATOM    545  CB  VAL A  73      12.645  21.341  -1.403  1.00  0.00           C  \nATOM    546  CG1 VAL A  73      13.041  22.481  -0.438  1.00  0.00           C  \nATOM    547  CG2 VAL A  73      12.255  20.110  -0.605  1.00  0.00           C  \nATOM    548  N   ASP A  74      10.357  23.707  -1.526  1.00  0.00           N  \nATOM    549  CA  ASP A  74       9.342  24.417  -0.751  1.00  0.00           C  \nATOM    550  C   ASP A  74       8.282  24.859  -1.734  1.00  0.00           C  \nATOM    551  O   ASP A  74       7.438  25.673  -1.329  1.00  0.00           O  \nATOM    552  CB  ASP A  74       9.854  25.687  -0.026  1.00  0.00           C  \nATOM    553  CG  ASP A  74      10.750  25.479   1.207  1.00  0.00           C  \nATOM    554  OD1 ASP A  74      11.360  26.450   1.665  1.00  0.00           O  \nATOM    555  OD2 ASP A  74      10.813  24.362   1.729  1.00  0.00           O  \nATOM    556  N   ASP A  75       8.402  24.300  -2.967  1.00  0.00           N  \nATOM    557  CA  ASP A  75       7.468  24.493  -4.113  1.00  0.00           C  \nATOM    558  C   ASP A  75       7.621  23.482  -5.286  1.00  0.00           C  \nATOM    559  O   ASP A  75       7.646  23.769  -6.506  1.00  0.00           O  \nATOM    560  CB  ASP A  75       7.598  25.907  -4.629  1.00  0.00           C  \nATOM    561  CG  ASP A  75       6.483  26.162  -5.641  1.00  0.00           C  \nATOM    562  OD1 ASP A  75       6.857  26.593  -6.748  1.00  0.00           O  \nATOM    563  OD2 ASP A  75       5.303  25.834  -5.350  1.00  0.00           O  \nATOM    564  N   MET A  76       7.721  22.248  -4.885  1.00  0.00           N  \nATOM    565  CA  MET A  76       7.676  21.148  -5.840  1.00  0.00           C  \nATOM    566  C   MET A  76       6.374  21.149  -6.628  1.00  0.00           C  \nATOM    567  O   MET A  76       6.450  20.929  -7.847  1.00  0.00           O  \nATOM    568  CB  MET A  76       7.701  19.810  -5.106  1.00  0.00           C  \nATOM    569  CG  MET A  76       8.923  19.660  -4.222  1.00  0.00           C  \nATOM    570  SD  MET A  76       9.046  17.994  -3.547  1.00  0.00           S  \nATOM    571  CE  MET A  76      10.662  18.214  -2.787  1.00  0.00           C  \nATOM    572  N   PRO A  77       5.189  21.309  -5.998  1.00  0.00           N  \nATOM    573  CA  PRO A  77       3.932  21.313  -6.771  1.00  0.00           C  \nATOM    574  C   PRO A  77       4.045  22.157  -8.071  1.00  0.00           C  \nATOM    575  O   PRO A  77       3.882  21.575  -9.141  1.00  0.00           O  \nATOM    576  CB  PRO A  77       2.858  21.767  -5.787  1.00  0.00           C  \nATOM    577  CG  PRO A  77       3.599  22.305  -4.578  1.00  0.00           C  \nATOM    578  CD  PRO A  77       4.874  21.499  -4.554  1.00  0.00           C  \nATOM    579  N   ASN A  78       4.386  23.446  -8.049  1.00  0.00           N  \nATOM    580  CA  ASN A  78       4.455  24.230  -9.330  1.00  0.00           C  \nATOM    581  C   ASN A  78       5.617  23.759 -10.186  1.00  0.00           C  \nATOM    582  O   ASN A  78       5.616  23.911 -11.407  1.00  0.00           O  \nATOM    583  CB  ASN A  78       4.637  25.736  -8.998  1.00  0.00           C  \nATOM    584  CG  ASN A  78       4.522  26.786 -10.136  1.00  0.00           C  \nATOM    585  OD1 ASN A  78       4.155  26.598 -11.307  1.00  0.00           O  \nATOM    586  ND2 ASN A  78       4.831  27.995  -9.748  1.00  0.00           N  \nATOM    587  N   ALA A  79       6.630  23.221  -9.545  1.00  0.00           N  \nATOM    588  CA  ALA A  79       7.836  22.930 -10.319  1.00  0.00           C  \nATOM    589  C   ALA A  79       7.704  21.600 -11.093  1.00  0.00           C  \nATOM    590  O   ALA A  79       8.224  21.496 -12.208  1.00  0.00           O  \nATOM    591  CB  ALA A  79       9.010  22.952  -9.353  1.00  0.00           C  \nATOM    592  N   LEU A  80       6.977  20.613 -10.514  1.00  0.00           N  \nATOM    593  CA  LEU A  80       6.909  19.261 -11.079  1.00  0.00           C  \nATOM    594  C   LEU A  80       5.566  19.212 -11.756  1.00  0.00           C  \nATOM    595  O   LEU A  80       5.073  18.124 -12.079  1.00  0.00           O  \nATOM    596  CB  LEU A  80       6.940  18.097 -10.074  1.00  0.00           C  \nATOM    597  CG  LEU A  80       7.895  18.198  -8.908  1.00  0.00           C  \nATOM    598  CD1 LEU A  80       7.952  16.894  -8.170  1.00  0.00           C  \nATOM    599  CD2 LEU A  80       9.309  18.583  -9.374  1.00  0.00           C  \nATOM    600  N   SER A  81       5.030  20.415 -11.853  1.00  0.00           N  \nATOM    601  CA  SER A  81       3.761  20.688 -12.528  1.00  0.00           C  \nATOM    602  C   SER A  81       3.556  19.793 -13.763  1.00  0.00           C  \nATOM    603  O   SER A  81       2.618  18.998 -13.810  1.00  0.00           O  \nATOM    604  CB  SER A  81       3.805  22.142 -12.983  1.00  0.00           C  \nATOM    605  OG  SER A  81       5.078  22.403 -13.620  1.00  0.00           O  \nATOM    606  N   ALA A  82       4.433  19.942 -14.744  1.00  0.00           N  \nATOM    607  CA  ALA A  82       4.228  19.178 -15.956  1.00  0.00           C  \nATOM    608  C   ALA A  82       4.587  17.688 -15.847  1.00  0.00           C  \nATOM    609  O   ALA A  82       3.958  16.871 -16.477  1.00  0.00           O  \nATOM    610  CB  ALA A  82       4.982  19.861 -17.062  1.00  0.00           C  \nATOM    611  N   LEU A  83       5.542  17.252 -15.116  1.00  0.00           N  \nATOM    612  CA  LEU A  83       5.699  15.792 -14.891  1.00  0.00           C  \nATOM    613  C   LEU A  83       4.495  15.119 -14.188  1.00  0.00           C  \nATOM    614  O   LEU A  83       4.293  13.903 -14.287  1.00  0.00           O  \nATOM    615  CB  LEU A  83       6.962  15.543 -14.027  1.00  0.00           C  \nATOM    616  CG  LEU A  83       8.282  15.801 -14.761  1.00  0.00           C  \nATOM    617  CD1 LEU A  83       9.461  15.872 -13.799  1.00  0.00           C  \nATOM    618  CD2 LEU A  83       8.521  14.816 -15.898  1.00  0.00           C  \nATOM    619  N   SER A  84       3.767  15.860 -13.385  1.00  0.00           N  \nATOM    620  CA  SER A  84       2.532  15.418 -12.742  1.00  0.00           C  \nATOM    621  C   SER A  84       1.510  15.068 -13.845  1.00  0.00           C  \nATOM    622  O   SER A  84       0.841  14.031 -13.859  1.00  0.00           O  \nATOM    623  CB  SER A  84       1.987  16.588 -11.878  1.00  0.00           C  \nATOM    624  OG  SER A  84       2.655  16.787 -10.631  1.00  0.00           O  \nATOM    625  N   ASP A  85       1.398  15.975 -14.759  1.00  0.00           N  \nATOM    626  CA  ASP A  85       0.498  15.763 -15.873  1.00  0.00           C  \nATOM    627  C   ASP A  85       0.916  14.578 -16.698  1.00  0.00           C  \nATOM    628  O   ASP A  85       0.043  13.780 -16.977  1.00  0.00           O  \nATOM    629  CB  ASP A  85       0.551  16.943 -16.825  1.00  0.00           C  \nATOM    630  CG  ASP A  85      -0.484  17.936 -16.363  1.00  0.00           C  \nATOM    631  OD1 ASP A  85      -1.643  17.770 -16.764  1.00  0.00           O  \nATOM    632  OD2 ASP A  85      -0.122  18.819 -15.583  1.00  0.00           O  \nATOM    633  N   LEU A  86       2.175  14.553 -17.090  1.00  0.00           N  \nATOM    634  CA  LEU A  86       2.770  13.505 -17.910  1.00  0.00           C  \nATOM    635  C   LEU A  86       2.672  12.149 -17.213  1.00  0.00           C  \nATOM    636  O   LEU A  86       2.326  11.123 -17.791  1.00  0.00           O  \nATOM    637  CB  LEU A  86       4.221  13.908 -17.994  1.00  0.00           C  \nATOM    638  CG  LEU A  86       5.061  13.061 -18.891  1.00  0.00           C  \nATOM    639  CD1 LEU A  86       5.861  12.047 -18.078  1.00  0.00           C  \nATOM    640  CD2 LEU A  86       4.272  12.500 -20.080  1.00  0.00           C  \nATOM    641  N   HIS A  87       2.956  12.093 -15.949  1.00  0.00           N  \nATOM    642  CA  HIS A  87       2.892  10.705 -15.405  1.00  0.00           C  \nATOM    643  C   HIS A  87       1.467  10.248 -15.090  1.00  0.00           C  \nATOM    644  O   HIS A  87       1.185   9.077 -15.314  1.00  0.00           O  \nATOM    645  CB  HIS A  87       3.736  10.658 -14.155  1.00  0.00           C  \nATOM    646  CG  HIS A  87       5.244  10.645 -14.441  1.00  0.00           C  \nATOM    647  ND1 HIS A  87       5.977  11.779 -14.763  1.00  0.00           N  \nATOM    648  CD2 HIS A  87       6.072   9.569 -14.457  1.00  0.00           C  \nATOM    649  CE1 HIS A  87       7.283  11.368 -14.946  1.00  0.00           C  \nATOM    650  NE2 HIS A  87       7.344   9.998 -14.755  1.00  0.00           N  \nATOM    651  N   ALA A  88       0.616  11.142 -14.570  1.00  0.00           N  \nATOM    652  CA  ALA A  88      -0.720  10.710 -14.110  1.00  0.00           C  \nATOM    653  C   ALA A  88      -1.752  10.851 -15.228  1.00  0.00           C  \nATOM    654  O   ALA A  88      -2.654  10.019 -15.315  1.00  0.00           O  \nATOM    655  CB  ALA A  88      -1.198  11.467 -12.867  1.00  0.00           C  \nATOM    656  N   HIS A  89      -1.637  11.870 -16.072  1.00  0.00           N  \nATOM    657  CA  HIS A  89      -2.648  11.981 -17.146  1.00  0.00           C  \nATOM    658  C   HIS A  89      -2.408  11.036 -18.257  1.00  0.00           C  \nATOM    659  O   HIS A  89      -3.241  10.146 -18.512  1.00  0.00           O  \nATOM    660  CB  HIS A  89      -2.670  13.293 -17.872  1.00  0.00           C  \nATOM    661  CG  HIS A  89      -3.721  14.149 -17.183  1.00  0.00           C  \nATOM    662  ND1 HIS A  89      -3.366  15.228 -16.344  1.00  0.00           N  \nATOM    663  CD2 HIS A  89      -5.103  14.012 -17.255  1.00  0.00           C  \nATOM    664  CE1 HIS A  89      -4.553  15.753 -15.907  1.00  0.00           C  \nATOM    665  NE2 HIS A  89      -5.641  15.023 -16.450  1.00  0.00           N  \nATOM    666  N   LYS A  90      -1.288  11.390 -18.822  1.00  0.00           N  \nATOM    667  CA  LYS A  90      -0.819  10.892 -20.099  1.00  0.00           C  \nATOM    668  C   LYS A  90      -0.250   9.504 -19.907  1.00  0.00           C  \nATOM    669  O   LYS A  90      -0.567   8.668 -20.749  1.00  0.00           O  \nATOM    670  CB  LYS A  90       0.264  11.782 -20.739  1.00  0.00           C  \nATOM    671  CG  LYS A  90       0.514  11.324 -22.190  1.00  0.00           C  \nATOM    672  CD  LYS A  90       1.911  11.612 -22.741  1.00  0.00           C  \nATOM    673  CE  LYS A  90       2.165  10.702 -23.949  1.00  0.00           C  \nATOM    674  NZ  LYS A  90       3.493  10.920 -24.558  1.00  0.00           N  \nATOM    675  N   LEU A  91       0.527   9.245 -18.839  1.00  0.00           N  \nATOM    676  CA  LEU A  91       1.068   7.870 -18.784  1.00  0.00           C  \nATOM    677  C   LEU A  91       0.250   6.915 -17.888  1.00  0.00           C  \nATOM    678  O   LEU A  91       0.349   5.687 -18.044  1.00  0.00           O  \nATOM    679  CB  LEU A  91       2.483   7.848 -18.245  1.00  0.00           C  \nATOM    680  CG  LEU A  91       3.485   8.469 -19.182  1.00  0.00           C  \nATOM    681  CD1 LEU A  91       4.805   8.599 -18.459  1.00  0.00           C  \nATOM    682  CD2 LEU A  91       3.621   7.632 -20.447  1.00  0.00           C  \nATOM    683  N   ARG A  92      -0.515   7.474 -16.981  1.00  0.00           N  \nATOM    684  CA  ARG A  92      -1.312   6.663 -16.070  1.00  0.00           C  \nATOM    685  C   ARG A  92      -0.426   5.672 -15.318  1.00  0.00           C  \nATOM    686  O   ARG A  92      -0.722   4.457 -15.375  1.00  0.00           O  \nATOM    687  CB  ARG A  92      -2.400   5.823 -16.799  1.00  0.00           C  \nATOM    688  CG  ARG A  92      -3.551   6.588 -17.434  1.00  0.00           C  \nATOM    689  CD  ARG A  92      -4.482   7.263 -16.409  1.00  0.00           C  \nATOM    690  NE  ARG A  92      -5.698   7.834 -16.996  1.00  0.00           N  \nATOM    691  CZ  ARG A  92      -6.305   7.541 -18.137  1.00  0.00           C  \nATOM    692  NH1 ARG A  92      -6.055   6.485 -18.930  1.00  0.00           N  \nATOM    693  NH2 ARG A  92      -7.281   8.378 -18.452  1.00  0.00           N  \nATOM    694  N   VAL A  93       0.605   6.202 -14.660  1.00  0.00           N  \nATOM    695  CA  VAL A  93       1.485   5.334 -13.872  1.00  0.00           C  \nATOM    696  C   VAL A  93       0.841   4.907 -12.545  1.00  0.00           C  \nATOM    697  O   VAL A  93       0.256   5.694 -11.793  1.00  0.00           O  \nATOM    698  CB  VAL A  93       2.839   5.988 -13.617  1.00  0.00           C  \nATOM    699  CG1 VAL A  93       3.734   5.033 -12.811  1.00  0.00           C  \nATOM    700  CG2 VAL A  93       3.461   6.433 -14.916  1.00  0.00           C  \nATOM    701  N   ASP A  94       0.982   3.640 -12.277  1.00  0.00           N  \nATOM    702  CA  ASP A  94       0.367   3.096 -11.102  1.00  0.00           C  \nATOM    703  C   ASP A  94       1.200   3.656  -9.958  1.00  0.00           C  \nATOM    704  O   ASP A  94       2.415   3.620 -10.021  1.00  0.00           O  \nATOM    705  CB  ASP A  94       0.376   1.590 -11.202  1.00  0.00           C  \nATOM    706  CG  ASP A  94      -0.400   0.947 -10.058  1.00  0.00           C  \nATOM    707  OD1 ASP A  94      -0.557   1.530  -8.988  1.00  0.00           O  \nATOM    708  OD2 ASP A  94      -0.859  -0.177 -10.248  1.00  0.00           O  \nATOM    709  N   PRO A  95       0.520   4.237  -9.037  1.00  0.00           N  \nATOM    710  CA  PRO A  95       1.121   4.994  -7.981  1.00  0.00           C  \nATOM    711  C   PRO A  95       1.982   4.054  -7.173  1.00  0.00           C  \nATOM    712  O   PRO A  95       2.895   4.574  -6.542  1.00  0.00           O  \nATOM    713  CB  PRO A  95      -0.009   5.594  -7.193  1.00  0.00           C  \nATOM    714  CG  PRO A  95      -1.058   5.725  -8.264  1.00  0.00           C  \nATOM    715  CD  PRO A  95      -0.935   4.408  -8.980  1.00  0.00           C  \nATOM    716  N   VAL A  96       1.698   2.749  -7.250  1.00  0.00           N  \nATOM    717  CA  VAL A  96       2.535   1.814  -6.477  1.00  0.00           C  \nATOM    718  C   VAL A  96       3.941   1.850  -7.095  1.00  0.00           C  \nATOM    719  O   VAL A  96       4.975   1.633  -6.431  1.00  0.00           O  \nATOM    720  CB  VAL A  96       1.956   0.365  -6.355  1.00  0.00           C  \nATOM    721  CG1 VAL A  96       2.421  -0.564  -7.467  1.00  0.00           C  \nATOM    722  CG2 VAL A  96       2.450  -0.323  -5.082  1.00  0.00           C  \nATOM    723  N   ASN A  97       3.984   2.230  -8.383  1.00  0.00           N  \nATOM    724  CA  ASN A  97       5.306   2.291  -9.016  1.00  0.00           C  \nATOM    725  C   ASN A  97       6.214   3.369  -8.475  1.00  0.00           C  \nATOM    726  O   ASN A  97       7.436   3.235  -8.522  1.00  0.00           O  \nATOM    727  CB  ASN A  97       5.191   2.299 -10.491  1.00  0.00           C  \nATOM    728  CG  ASN A  97       4.581   0.954 -10.919  1.00  0.00           C  \nATOM    729  OD1 ASN A  97       3.967   0.957 -11.957  1.00  0.00           O  \nATOM    730  ND2 ASN A  97       4.737  -0.175 -10.237  1.00  0.00           N  \nATOM    731  N   PHE A  98       5.616   4.330  -7.891  1.00  0.00           N  \nATOM    732  CA  PHE A  98       6.404   5.408  -7.257  1.00  0.00           C  \nATOM    733  C   PHE A  98       7.077   4.929  -5.991  1.00  0.00           C  \nATOM    734  O   PHE A  98       8.174   5.412  -5.712  1.00  0.00           O  \nATOM    735  CB  PHE A  98       5.550   6.664  -6.952  1.00  0.00           C  \nATOM    736  CG  PHE A  98       5.219   7.254  -8.327  1.00  0.00           C  \nATOM    737  CD1 PHE A  98       6.102   8.107  -8.928  1.00  0.00           C  \nATOM    738  CD2 PHE A  98       4.048   6.899  -8.985  1.00  0.00           C  \nATOM    739  CE1 PHE A  98       5.800   8.616 -10.189  1.00  0.00           C  \nATOM    740  CE2 PHE A  98       3.744   7.397 -10.241  1.00  0.00           C  \nATOM    741  CZ  PHE A  98       4.627   8.260 -10.840  1.00  0.00           C  \nATOM    742  N   LYS A  99       6.418   3.983  -5.315  1.00  0.00           N  \nATOM    743  CA  LYS A  99       7.035   3.398  -4.107  1.00  0.00           C  \nATOM    744  C   LYS A  99       8.210   2.470  -4.464  1.00  0.00           C  \nATOM    745  O   LYS A  99       9.197   2.469  -3.755  1.00  0.00           O  \nATOM    746  CB  LYS A  99       6.051   2.590  -3.247  1.00  0.00           C  \nATOM    747  CG  LYS A  99       4.847   3.379  -2.743  1.00  0.00           C  \nATOM    748  CD  LYS A  99       4.089   2.649  -1.637  1.00  0.00           C  \nATOM    749  CE  LYS A  99       3.134   3.571  -0.854  1.00  0.00           C  \nATOM    750  NZ  LYS A  99       2.571   2.843   0.312  1.00  0.00           N  \nATOM    751  N   LEU A 100       8.126   1.704  -5.507  1.00  0.00           N  \nATOM    752  CA  LEU A 100       9.233   0.815  -5.869  1.00  0.00           C  \nATOM    753  C   LEU A 100      10.464   1.549  -6.377  1.00  0.00           C  \nATOM    754  O   LEU A 100      11.574   1.096  -6.111  1.00  0.00           O  \nATOM    755  CB  LEU A 100       8.774  -0.147  -6.975  1.00  0.00           C  \nATOM    756  CG  LEU A 100       7.481  -0.860  -6.537  1.00  0.00           C  \nATOM    757  CD1 LEU A 100       6.859  -1.714  -7.589  1.00  0.00           C  \nATOM    758  CD2 LEU A 100       7.681  -1.738  -5.326  1.00  0.00           C  \nATOM    759  N   LEU A 101      10.253   2.612  -7.103  1.00  0.00           N  \nATOM    760  CA  LEU A 101      11.391   3.392  -7.642  1.00  0.00           C  \nATOM    761  C   LEU A 101      12.092   4.093  -6.490  1.00  0.00           C  \nATOM    762  O   LEU A 101      13.330   4.116  -6.458  1.00  0.00           O  \nATOM    763  CB  LEU A 101      10.922   4.437  -8.707  1.00  0.00           C  \nATOM    764  CG  LEU A 101      12.079   5.109  -9.444  1.00  0.00           C  \nATOM    765  CD1 LEU A 101      13.273   4.158  -9.588  1.00  0.00           C  \nATOM    766  CD2 LEU A 101      11.628   5.702 -10.793  1.00  0.00           C  \nATOM    767  N   SER A 102      11.253   4.615  -5.573  1.00  0.00           N  \nATOM    768  CA  SER A 102      11.763   5.461  -4.528  1.00  0.00           C  \nATOM    769  C   SER A 102      12.692   4.685  -3.658  1.00  0.00           C  \nATOM    770  O   SER A 102      13.686   5.215  -3.169  1.00  0.00           O  \nATOM    771  CB  SER A 102      10.608   5.945  -3.756  1.00  0.00           C  \nATOM    772  OG  SER A 102       9.953   6.896  -4.598  1.00  0.00           O  \nATOM    773  N   HIS A 103      12.332   3.469  -3.552  1.00  0.00           N  \nATOM    774  CA  HIS A 103      13.066   2.484  -2.808  1.00  0.00           C  \nATOM    775  C   HIS A 103      14.343   2.135  -3.570  1.00  0.00           C  \nATOM    776  O   HIS A 103      15.377   2.007  -2.916  1.00  0.00           O  \nATOM    777  CB  HIS A 103      12.207   1.210  -2.660  1.00  0.00           C  \nATOM    778  CG  HIS A 103      12.954   0.032  -2.007  1.00  0.00           C  \nATOM    779  ND1 HIS A 103      13.246  -1.167  -2.716  1.00  0.00           N  \nATOM    780  CD2 HIS A 103      13.441  -0.056  -0.715  1.00  0.00           C  \nATOM    781  CE1 HIS A 103      13.914  -1.966  -1.821  1.00  0.00           C  \nATOM    782  NE2 HIS A 103      14.056  -1.301  -0.562  1.00  0.00           N  \nATOM    783  N   CYS A 104      14.269   1.993  -4.900  1.00  0.00           N  \nATOM    784  CA  CYS A 104      15.540   1.701  -5.539  1.00  0.00           C  \nATOM    785  C   CYS A 104      16.532   2.878  -5.521  1.00  0.00           C  \nATOM    786  O   CYS A 104      17.753   2.687  -5.386  1.00  0.00           O  \nATOM    787  CB  CYS A 104      15.283   1.237  -6.964  1.00  0.00           C  \nATOM    788  SG  CYS A 104      14.434  -0.342  -7.025  1.00  0.00           S  \nATOM    789  N   LEU A 105      16.021   4.047  -5.665  1.00  0.00           N  \nATOM    790  CA  LEU A 105      16.725   5.303  -5.318  1.00  0.00           C  \nATOM    791  C   LEU A 105      17.410   5.255  -3.924  1.00  0.00           C  \nATOM    792  O   LEU A 105      18.586   5.614  -3.811  1.00  0.00           O  \nATOM    793  CB  LEU A 105      15.632   6.384  -5.348  1.00  0.00           C  \nATOM    794  CG  LEU A 105      15.709   7.465  -6.439  1.00  0.00           C  \nATOM    795  CD1 LEU A 105      16.703   7.185  -7.551  1.00  0.00           C  \nATOM    796  CD2 LEU A 105      14.350   7.713  -7.068  1.00  0.00           C  \nATOM    797  N   LEU A 106      16.743   4.815  -2.825  1.00  0.00           N  \nATOM    798  CA  LEU A 106      17.443   4.859  -1.532  1.00  0.00           C  \nATOM    799  C   LEU A 106      18.549   3.810  -1.436  1.00  0.00           C  \nATOM    800  O   LEU A 106      19.646   4.171  -0.993  1.00  0.00           O  \nATOM    801  CB  LEU A 106      16.480   4.700  -0.375  1.00  0.00           C  \nATOM    802  CG  LEU A 106      15.529   5.864  -0.330  1.00  0.00           C  \nATOM    803  CD1 LEU A 106      14.439   5.503   0.626  1.00  0.00           C  \nATOM    804  CD2 LEU A 106      16.228   7.048   0.185  1.00  0.00           C  \nATOM    805  N   VAL A 107      18.238   2.563  -1.800  1.00  0.00           N  \nATOM    806  CA  VAL A 107      19.207   1.435  -2.043  1.00  0.00           C  \nATOM    807  C   VAL A 107      20.406   1.948  -2.910  1.00  0.00           C  \nATOM    808  O   VAL A 107      21.568   1.613  -2.652  1.00  0.00           O  \nATOM    809  CB  VAL A 107      18.469   0.214  -2.705  1.00  0.00           C  \nATOM    810  CG1 VAL A 107      19.409  -0.904  -3.120  1.00  0.00           C  \nATOM    811  CG2 VAL A 107      17.306  -0.439  -1.904  1.00  0.00           C  \nATOM    812  N   THR A 108      20.172   2.790  -3.923  1.00  0.00           N  \nATOM    813  CA  THR A 108      21.273   3.326  -4.769  1.00  0.00           C  \nATOM    814  C   THR A 108      22.026   4.439  -4.054  1.00  0.00           C  \nATOM    815  O   THR A 108      23.227   4.511  -4.268  1.00  0.00           O  \nATOM    816  CB  THR A 108      20.759   3.864  -6.101  1.00  0.00           C  \nATOM    817  OG1 THR A 108      19.901   2.934  -6.725  1.00  0.00           O  \nATOM    818  CG2 THR A 108      21.904   4.115  -7.079  1.00  0.00           C  \nATOM    819  N   LEU A 109      21.375   5.304  -3.232  1.00  0.00           N  \nATOM    820  CA  LEU A 109      22.113   6.396  -2.460  1.00  0.00           C  \nATOM    821  C   LEU A 109      23.030   5.718  -1.448  1.00  0.00           C  \nATOM    822  O   LEU A 109      24.235   6.021  -1.439  1.00  0.00           O  \nATOM    823  CB  LEU A 109      21.226   7.410  -1.691  1.00  0.00           C  \nATOM    824  CG  LEU A 109      20.556   8.522  -2.538  1.00  0.00           C  \nATOM    825  CD1 LEU A 109      20.825   8.467  -4.040  1.00  0.00           C  \nATOM    826  CD2 LEU A 109      19.051   8.679  -2.269  1.00  0.00           C  \nATOM    827  N   ALA A 110      22.372   4.812  -0.715  1.00  0.00           N  \nATOM    828  CA  ALA A 110      22.962   3.930   0.316  1.00  0.00           C  \nATOM    829  C   ALA A 110      24.157   3.166  -0.192  1.00  0.00           C  \nATOM    830  O   ALA A 110      25.075   2.987   0.594  1.00  0.00           O  \nATOM    831  CB  ALA A 110      22.006   2.838   0.827  1.00  0.00           C  \nATOM    832  N   ALA A 111      24.063   2.705  -1.435  1.00  0.00           N  \nATOM    833  CA  ALA A 111      25.012   1.719  -1.923  1.00  0.00           C  \nATOM    834  C   ALA A 111      26.226   2.523  -2.330  1.00  0.00           C  \nATOM    835  O   ALA A 111      27.278   1.946  -2.604  1.00  0.00           O  \nATOM    836  CB  ALA A 111      24.429   0.965  -3.113  1.00  0.00           C  \nATOM    837  N   HIS A 112      26.014   3.839  -2.307  1.00  0.00           N  \nATOM    838  CA  HIS A 112      26.998   4.775  -2.878  1.00  0.00           C  \nATOM    839  C   HIS A 112      27.594   5.700  -1.840  1.00  0.00           C  \nATOM    840  O   HIS A 112      28.724   6.153  -2.065  1.00  0.00           O  \nATOM    841  CB  HIS A 112      26.442   5.633  -4.047  1.00  0.00           C  \nATOM    842  CG  HIS A 112      26.556   4.806  -5.344  1.00  0.00           C  \nATOM    843  ND1 HIS A 112      27.697   4.802  -6.101  1.00  0.00           N  \nATOM    844  CD2 HIS A 112      25.648   3.962  -5.946  1.00  0.00           C  \nATOM    845  CE1 HIS A 112      27.498   3.951  -7.189  1.00  0.00           C  \nATOM    846  NE2 HIS A 112      26.218   3.426  -7.090  1.00  0.00           N  \nATOM    847  N   LEU A 113      26.840   5.962  -0.778  1.00  0.00           N  \nATOM    848  CA  LEU A 113      27.220   7.094   0.113  1.00  0.00           C  \nATOM    849  C   LEU A 113      27.092   6.743   1.582  1.00  0.00           C  \nATOM    850  O   LEU A 113      26.231   7.370   2.175  1.00  0.00           O  \nATOM    851  CB  LEU A 113      26.213   8.247  -0.013  1.00  0.00           C  \nATOM    852  CG  LEU A 113      25.949   8.851  -1.405  1.00  0.00           C  \nATOM    853  CD1 LEU A 113      25.034  10.065  -1.259  1.00  0.00           C  \nATOM    854  CD2 LEU A 113      27.196   9.228  -2.228  1.00  0.00           C  \nATOM    855  N   PRO A 114      27.870   5.829   2.143  1.00  0.00           N  \nATOM    856  CA  PRO A 114      27.553   5.157   3.398  1.00  0.00           C  \nATOM    857  C   PRO A 114      27.915   5.998   4.639  1.00  0.00           C  \nATOM    858  O   PRO A 114      27.486   5.681   5.762  1.00  0.00           O  \nATOM    859  CB  PRO A 114      28.340   3.842   3.354  1.00  0.00           C  \nATOM    860  CG  PRO A 114      29.540   4.149   2.483  1.00  0.00           C  \nATOM    861  CD  PRO A 114      29.002   5.157   1.478  1.00  0.00           C  \nATOM    862  N   ALA A 115      28.703   7.047   4.380  1.00  0.00           N  \nATOM    863  CA  ALA A 115      29.095   7.989   5.407  1.00  0.00           C  \nATOM    864  C   ALA A 115      27.872   8.837   5.788  1.00  0.00           C  \nATOM    865  O   ALA A 115      27.554   9.044   6.968  1.00  0.00           O  \nATOM    866  CB  ALA A 115      30.167   8.875   4.786  1.00  0.00           C  \nATOM    867  N   GLU A 116      27.275   9.235   4.665  1.00  0.00           N  \nATOM    868  CA  GLU A 116      26.194  10.241   4.470  1.00  0.00           C  \nATOM    869  C   GLU A 116      24.804   9.689   4.743  1.00  0.00           C  \nATOM    870  O   GLU A 116      23.968  10.462   5.183  1.00  0.00           O  \nATOM    871  CB  GLU A 116      26.141  10.753   3.006  1.00  0.00           C  \nATOM    872  CG  GLU A 116      27.493  11.278   2.490  1.00  0.00           C  \nATOM    873  CD  GLU A 116      27.896  12.324   3.505  1.00  0.00           C  \nATOM    874  OE1 GLU A 116      27.030  13.102   3.933  1.00  0.00           O  \nATOM    875  OE2 GLU A 116      29.074  12.322   3.862  1.00  0.00           O  \nATOM    876  N   PHE A 117      24.625   8.415   4.459  1.00  0.00           N  \nATOM    877  CA  PHE A 117      23.373   7.700   4.494  1.00  0.00           C  \nATOM    878  C   PHE A 117      23.089   7.278   5.915  1.00  0.00           C  \nATOM    879  O   PHE A 117      22.883   6.071   6.140  1.00  0.00           O  \nATOM    880  CB  PHE A 117      23.408   6.451   3.614  1.00  0.00           C  \nATOM    881  CG  PHE A 117      21.998   5.907   3.318  1.00  0.00           C  \nATOM    882  CD1 PHE A 117      21.106   6.660   2.575  1.00  0.00           C  \nATOM    883  CD2 PHE A 117      21.618   4.691   3.805  1.00  0.00           C  \nATOM    884  CE1 PHE A 117      19.844   6.196   2.314  1.00  0.00           C  \nATOM    885  CE2 PHE A 117      20.355   4.200   3.553  1.00  0.00           C  \nATOM    886  CZ  PHE A 117      19.461   4.964   2.811  1.00  0.00           C  \nATOM    887  N   THR A 118      23.095   8.293   6.809  1.00  0.00           N  \nATOM    888  CA  THR A 118      22.656   8.087   8.213  1.00  0.00           C  \nATOM    889  C   THR A 118      21.167   7.698   8.263  1.00  0.00           C  \nATOM    890  O   THR A 118      20.413   8.028   7.342  1.00  0.00           O  \nATOM    891  CB  THR A 118      22.964   9.290   9.150  1.00  0.00           C  \nATOM    892  OG1 THR A 118      22.478  10.540   8.682  1.00  0.00           O  \nATOM    893  CG2 THR A 118      24.430   9.413   9.539  1.00  0.00           C  \nATOM    894  N   PRO A 119      20.784   6.961   9.311  1.00  0.00           N  \nATOM    895  CA  PRO A 119      19.398   6.647   9.688  1.00  0.00           C  \nATOM    896  C   PRO A 119      18.498   7.869   9.551  1.00  0.00           C  \nATOM    897  O   PRO A 119      17.332   7.701   9.163  1.00  0.00           O  \nATOM    898  CB  PRO A 119      19.461   6.137  11.139  1.00  0.00           C  \nATOM    899  CG  PRO A 119      20.797   5.427  11.132  1.00  0.00           C  \nATOM    900  CD  PRO A 119      21.679   6.397  10.337  1.00  0.00           C  \nATOM    901  N   ALA A 120      19.068   9.048   9.827  1.00  0.00           N  \nATOM    902  CA  ALA A 120      18.231  10.242   9.813  1.00  0.00           C  \nATOM    903  C   ALA A 120      18.172  10.827   8.413  1.00  0.00           C  \nATOM    904  O   ALA A 120      17.257  11.595   8.094  1.00  0.00           O  \nATOM    905  CB  ALA A 120      18.822  11.276  10.766  1.00  0.00           C  \nATOM    906  N   VAL A 121      19.179  10.492   7.631  1.00  0.00           N  \nATOM    907  CA  VAL A 121      19.154  11.062   6.308  1.00  0.00           C  \nATOM    908  C   VAL A 121      18.349  10.141   5.430  1.00  0.00           C  \nATOM    909  O   VAL A 121      17.748  10.601   4.456  1.00  0.00           O  \nATOM    910  CB  VAL A 121      20.560  11.292   5.777  1.00  0.00           C  \nATOM    911  CG1 VAL A 121      20.626  11.549   4.268  1.00  0.00           C  \nATOM    912  CG2 VAL A 121      21.275  12.405   6.555  1.00  0.00           C  \nATOM    913  N   HIS A 122      18.407   8.896   5.827  1.00  0.00           N  \nATOM    914  CA  HIS A 122      17.643   7.828   5.181  1.00  0.00           C  \nATOM    915  C   HIS A 122      16.176   8.205   5.300  1.00  0.00           C  \nATOM    916  O   HIS A 122      15.414   8.168   4.337  1.00  0.00           O  \nATOM    917  CB  HIS A 122      17.994   6.551   5.956  1.00  0.00           C  \nATOM    918  CG  HIS A 122      17.221   5.292   5.570  1.00  0.00           C  \nATOM    919  ND1 HIS A 122      17.485   4.066   6.126  1.00  0.00           N  \nATOM    920  CD2 HIS A 122      16.204   5.134   4.652  1.00  0.00           C  \nATOM    921  CE1 HIS A 122      16.609   3.113   5.538  1.00  0.00           C  \nATOM    922  NE2 HIS A 122      15.838   3.797   4.650  1.00  0.00           N  \nATOM    923  N   ALA A 123      15.843   8.617   6.490  1.00  0.00           N  \nATOM    924  CA  ALA A 123      14.479   9.097   6.839  1.00  0.00           C  \nATOM    925  C   ALA A 123      14.041  10.336   6.046  1.00  0.00           C  \nATOM    926  O   ALA A 123      12.882  10.320   5.624  1.00  0.00           O  \nATOM    927  CB  ALA A 123      14.412   9.373   8.350  1.00  0.00           C  \nATOM    928  N   SER A 124      14.952  11.335   5.907  1.00  0.00           N  \nATOM    929  CA  SER A 124      14.704  12.665   5.262  1.00  0.00           C  \nATOM    930  C   SER A 124      14.491  12.407   3.756  1.00  0.00           C  \nATOM    931  O   SER A 124      13.699  13.070   3.024  1.00  0.00           O  \nATOM    932  CB  SER A 124      15.890  13.703   5.530  1.00  0.00           C  \nATOM    933  OG  SER A 124      16.152  13.862   6.925  1.00  0.00           O  \nATOM    934  N   LEU A 125      15.251  11.385   3.330  1.00  0.00           N  \nATOM    935  CA  LEU A 125      15.285  11.088   1.907  1.00  0.00           C  \nATOM    936  C   LEU A 125      14.005  10.323   1.559  1.00  0.00           C  \nATOM    937  O   LEU A 125      13.278  10.673   0.627  1.00  0.00           O  \nATOM    938  CB  LEU A 125      16.551  10.302   1.676  1.00  0.00           C  \nATOM    939  CG  LEU A 125      17.669  11.035   0.963  1.00  0.00           C  \nATOM    940  CD1 LEU A 125      17.802  12.547   1.129  1.00  0.00           C  \nATOM    941  CD2 LEU A 125      18.962  10.273   1.128  1.00  0.00           C  \nATOM    942  N   ASP A 126      13.734   9.300   2.324  1.00  0.00           N  \nATOM    943  CA  ASP A 126      12.461   8.687   2.171  1.00  0.00           C  \nATOM    944  C   ASP A 126      11.281   9.649   2.040  1.00  0.00           C  \nATOM    945  O   ASP A 126      10.471   9.449   1.111  1.00  0.00           O  \nATOM    946  CB  ASP A 126      12.143   7.876   3.400  1.00  0.00           C  \nATOM    947  CG  ASP A 126      10.819   7.074   3.252  1.00  0.00           C  \nATOM    948  OD1 ASP A 126       9.826   7.444   3.881  1.00  0.00           O  \nATOM    949  OD2 ASP A 126      10.791   6.041   2.576  1.00  0.00           O  \nATOM    950  N   LYS A 127      11.223  10.567   3.034  1.00  0.00           N  \nATOM    951  CA  LYS A 127      10.124  11.566   3.192  1.00  0.00           C  \nATOM    952  C   LYS A 127      10.159  12.476   1.977  1.00  0.00           C  \nATOM    953  O   LYS A 127       9.129  12.741   1.367  1.00  0.00           O  \nATOM    954  CB  LYS A 127      10.243  12.462   4.429  1.00  0.00           C  \nATOM    955  CG  LYS A 127       9.923  11.893   5.811  1.00  0.00           C  \nATOM    956  CD  LYS A 127      10.277  12.952   6.897  1.00  0.00           C  \nATOM    957  CE  LYS A 127      10.078  12.517   8.356  1.00  0.00           C  \nATOM    958  NZ  LYS A 127       8.702  12.840   8.824  1.00  0.00           N  \nATOM    959  N   PHE A 128      11.349  12.928   1.657  1.00  0.00           N  \nATOM    960  CA  PHE A 128      11.406  13.659   0.437  1.00  0.00           C  \nATOM    961  C   PHE A 128      10.900  12.830  -0.772  1.00  0.00           C  \nATOM    962  O   PHE A 128      10.188  13.319  -1.657  1.00  0.00           O  \nATOM    963  CB  PHE A 128      12.873  14.041   0.287  1.00  0.00           C  \nATOM    964  CG  PHE A 128      13.181  14.584  -1.105  1.00  0.00           C  \nATOM    965  CD1 PHE A 128      12.931  15.908  -1.384  1.00  0.00           C  \nATOM    966  CD2 PHE A 128      13.694  13.745  -2.084  1.00  0.00           C  \nATOM    967  CE1 PHE A 128      13.210  16.437  -2.664  1.00  0.00           C  \nATOM    968  CE2 PHE A 128      13.978  14.244  -3.352  1.00  0.00           C  \nATOM    969  CZ  PHE A 128      13.735  15.604  -3.646  1.00  0.00           C  \nATOM    970  N   LEU A 129      11.241  11.590  -0.844  1.00  0.00           N  \nATOM    971  CA  LEU A 129      10.891  10.935  -2.104  1.00  0.00           C  \nATOM    972  C   LEU A 129       9.408  10.691  -2.103  1.00  0.00           C  \nATOM    973  O   LEU A 129       8.809  10.603  -3.163  1.00  0.00           O  \nATOM    974  CB  LEU A 129      11.622   9.607  -2.333  1.00  0.00           C  \nATOM    975  CG  LEU A 129      13.038   9.821  -2.909  1.00  0.00           C  \nATOM    976  CD1 LEU A 129      13.959   8.655  -2.666  1.00  0.00           C  \nATOM    977  CD2 LEU A 129      13.036  10.299  -4.365  1.00  0.00           C  \nATOM    978  N   ALA A 130       8.901  10.651  -0.921  1.00  0.00           N  \nATOM    979  CA  ALA A 130       7.478  10.489  -0.825  1.00  0.00           C  \nATOM    980  C   ALA A 130       6.752  11.740  -1.311  1.00  0.00           C  \nATOM    981  O   ALA A 130       5.638  11.629  -1.797  1.00  0.00           O  \nATOM    982  CB  ALA A 130       7.136  10.221   0.632  1.00  0.00           C  \nATOM    983  N   SER A 131       7.406  12.874  -1.205  1.00  0.00           N  \nATOM    984  CA  SER A 131       6.676  14.118  -1.473  1.00  0.00           C  \nATOM    985  C   SER A 131       6.658  14.352  -2.960  1.00  0.00           C  \nATOM    986  O   SER A 131       5.666  14.817  -3.550  1.00  0.00           O  \nATOM    987  CB  SER A 131       7.361  15.311  -0.827  1.00  0.00           C  \nATOM    988  OG  SER A 131       7.158  15.269   0.566  1.00  0.00           O  \nATOM    989  N   VAL A 132       7.810  13.986  -3.477  1.00  0.00           N  \nATOM    990  CA  VAL A 132       7.899  14.029  -4.935  1.00  0.00           C  \nATOM    991  C   VAL A 132       6.844  13.142  -5.620  1.00  0.00           C  \nATOM    992  O   VAL A 132       6.213  13.570  -6.587  1.00  0.00           O  \nATOM    993  CB  VAL A 132       9.287  13.606  -5.296  1.00  0.00           C  \nATOM    994  CG1 VAL A 132       9.399  13.420  -6.822  1.00  0.00           C  \nATOM    995  CG2 VAL A 132      10.267  14.612  -4.683  1.00  0.00           C  \nATOM    996  N   SER A 133       6.699  11.918  -5.047  1.00  0.00           N  \nATOM    997  CA  SER A 133       5.790  10.882  -5.583  1.00  0.00           C  \nATOM    998  C   SER A 133       4.352  11.343  -5.420  1.00  0.00           C  \nATOM    999  O   SER A 133       3.578  11.117  -6.340  1.00  0.00           O  \nATOM   1000  CB  SER A 133       5.917   9.540  -4.870  1.00  0.00           C  \nATOM   1001  OG  SER A 133       7.236   9.108  -4.988  1.00  0.00           O  \nATOM   1002  N   THR A 134       4.066  11.986  -4.290  1.00  0.00           N  \nATOM   1003  CA  THR A 134       2.711  12.478  -4.014  1.00  0.00           C  \nATOM   1004  C   THR A 134       2.284  13.572  -4.978  1.00  0.00           C  \nATOM   1005  O   THR A 134       1.172  13.562  -5.472  1.00  0.00           O  \nATOM   1006  CB  THR A 134       2.641  12.985  -2.612  1.00  0.00           C  \nATOM   1007  OG1 THR A 134       2.784  11.829  -1.829  1.00  0.00           O  \nATOM   1008  CG2 THR A 134       1.260  13.572  -2.324  1.00  0.00           C  \nATOM   1009  N   VAL A 135       3.229  14.428  -5.233  1.00  0.00           N  \nATOM   1010  CA  VAL A 135       3.117  15.421  -6.284  1.00  0.00           C  \nATOM   1011  C   VAL A 135       2.879  14.778  -7.637  1.00  0.00           C  \nATOM   1012  O   VAL A 135       1.939  15.201  -8.279  1.00  0.00           O  \nATOM   1013  CB  VAL A 135       4.381  16.297  -6.259  1.00  0.00           C  \nATOM   1014  CG1 VAL A 135       4.525  17.007  -7.588  1.00  0.00           C  \nATOM   1015  CG2 VAL A 135       4.280  17.320  -5.092  1.00  0.00           C  \nATOM   1016  N   LEU A 136       3.679  13.771  -8.057  1.00  0.00           N  \nATOM   1017  CA  LEU A 136       3.537  13.243  -9.458  1.00  0.00           C  \nATOM   1018  C   LEU A 136       2.326  12.282  -9.598  1.00  0.00           C  \nATOM   1019  O   LEU A 136       2.057  11.732 -10.664  1.00  0.00           O  \nATOM   1020  CB  LEU A 136       4.808  12.510  -9.925  1.00  0.00           C  \nATOM   1021  CG  LEU A 136       6.147  13.271  -9.955  1.00  0.00           C  \nATOM   1022  CD1 LEU A 136       7.328  12.376 -10.385  1.00  0.00           C  \nATOM   1023  CD2 LEU A 136       6.058  14.504 -10.837  1.00  0.00           C  \nATOM   1024  N   THR A 137       1.570  12.070  -8.531  1.00  0.00           N  \nATOM   1025  CA  THR A 137       0.339  11.252  -8.589  1.00  0.00           C  \nATOM   1026  C   THR A 137      -0.918  12.045  -8.174  1.00  0.00           C  \nATOM   1027  O   THR A 137      -1.976  11.455  -7.952  1.00  0.00           O  \nATOM   1028  CB  THR A 137       0.474  10.182  -7.541  1.00  0.00           C  \nATOM   1029  OG1 THR A 137       0.897  10.889  -6.366  1.00  0.00           O  \nATOM   1030  CG2 THR A 137       1.424   9.050  -7.899  1.00  0.00           C  \nATOM   1031  N   SER A 138      -0.785  13.358  -8.066  1.00  0.00           N  \nATOM   1032  CA  SER A 138      -1.758  14.251  -7.452  1.00  0.00           C  \nATOM   1033  C   SER A 138      -2.757  14.717  -8.510  1.00  0.00           C  \nATOM   1034  O   SER A 138      -3.741  15.406  -8.189  1.00  0.00           O  \nATOM   1035  CB  SER A 138      -1.005  15.431  -6.782  1.00  0.00           C  \nATOM   1036  OG  SER A 138      -0.350  16.274  -7.745  1.00  0.00           O  \nATOM   1037  N   LYS A 139      -2.531  14.344  -9.766  1.00  0.00           N  \nATOM   1038  CA  LYS A 139      -3.748  14.602 -10.556  1.00  0.00           C  \nATOM   1039  C   LYS A 139      -4.632  13.343 -10.575  1.00  0.00           C  \nATOM   1040  O   LYS A 139      -5.758  13.355 -11.103  1.00  0.00           O  \nATOM   1041  CB  LYS A 139      -3.516  15.301 -11.915  1.00  0.00           C  \nATOM   1042  CG  LYS A 139      -4.851  15.829 -12.482  1.00  0.00           C  \nATOM   1043  CD  LYS A 139      -4.824  17.200 -13.192  1.00  0.00           C  \nATOM   1044  CE  LYS A 139      -6.211  17.551 -13.777  1.00  0.00           C  \nATOM   1045  NZ  LYS A 139      -6.136  18.043 -15.175  1.00  0.00           N  \nATOM   1046  N   TYR A 140      -4.170  12.261  -9.946  1.00  0.00           N  \nATOM   1047  CA  TYR A 140      -5.206  11.208  -9.540  1.00  0.00           C  \nATOM   1048  C   TYR A 140      -6.049  11.562  -8.297  1.00  0.00           C  \nATOM   1049  O   TYR A 140      -7.107  10.953  -8.085  1.00  0.00           O  \nATOM   1050  CB  TYR A 140      -4.647   9.833  -9.166  1.00  0.00           C  \nATOM   1051  CG  TYR A 140      -3.749   9.184 -10.225  1.00  0.00           C  \nATOM   1052  CD1 TYR A 140      -2.474   8.788  -9.878  1.00  0.00           C  \nATOM   1053  CD2 TYR A 140      -4.226   9.000 -11.503  1.00  0.00           C  \nATOM   1054  CE1 TYR A 140      -1.622   8.220 -10.814  1.00  0.00           C  \nATOM   1055  CE2 TYR A 140      -3.386   8.430 -12.442  1.00  0.00           C  \nATOM   1056  CZ  TYR A 140      -2.072   8.048 -12.087  1.00  0.00           C  \nATOM   1057  OH  TYR A 140      -1.211   7.548 -13.028  1.00  0.00           O  \nATOM   1058  N   ARG A 141      -5.568  12.527  -7.539  1.00  0.00           N  \nATOM   1059  CA  ARG A 141      -6.042  12.991  -6.230  1.00  0.00           C  \nATOM   1060  C   ARG A 141      -6.843  14.284  -6.415  1.00  0.00           C  \nATOM   1061  O   ARG A 141      -7.538  14.409  -7.432  1.00  0.00           O  \nATOM   1062  CB  ARG A 141      -4.816  13.327  -5.363  1.00  0.00           C  \nATOM   1063  CG  ARG A 141      -3.826  12.177  -5.102  1.00  0.00           C  \nATOM   1064  CD  ARG A 141      -2.620  12.718  -4.312  1.00  0.00           C  \nATOM   1065  NE  ARG A 141      -1.649  11.711  -3.738  1.00  0.00           N  \nATOM   1066  CZ  ARG A 141      -1.742  10.944  -2.594  1.00  0.00           C  \nATOM   1067  NH1 ARG A 141      -2.911  10.577  -1.995  1.00  0.00           N  \nATOM   1068  NH2 ARG A 141      -0.604  10.395  -2.146  1.00  0.00           N  \nATOM   1069  OXT ARG A 141      -6.729  15.170  -5.560  1.00  0.00           O  ";

	pTmalignCgi->main_func();

	cout<<pTmalignCgi->m_output<<endl;
*/

/*
	// discontinuous residues
	unique_ptr<CTmalignCgi> pTmalignCgi(new CTmalignCgi());

	// query, 1HHO_A
	pTmalignCgi->m_pdb_query = "MODEL        1\nHEADER    PDB From iCn3D                                      1HHO\nTITLE     \nATOM   4591  C   PRO A   4      13.055  22.001   6.171  1.00                 C  \nATOM   4592  CA  PRO A   4      12.779  22.532   4.766  1.00                 C  \nATOM   4593  CB  PRO A   4      12.481  24.030   4.775  1.00                 C  \nATOM   4594  CD  PRO A   4      10.622  23.011   3.775  1.00                 C  \nATOM   4595  CG  PRO A   4      11.532  24.197   3.622  1.00                 C  \nATOM   4596  N   PRO A   4      11.553  21.954   4.205  1.00                 N  \nATOM   4597  O   PRO A   4      14.193  21.645   6.517  1.00                 O  \nATOM   4598  C   ALA A   5      12.481  20.001   8.356  1.00                 C  \nATOM   4599  CA  ALA A   5      12.103  21.476   8.349  1.00                 C  \nATOM   4600  CB  ALA A   5      10.785  21.674   9.076  1.00                 C  \nATOM   4601  N   ALA A   5      11.997  21.960   6.977  1.00                 N  \nATOM   4602  O   ALA A   5      13.377  19.579   9.101  1.00                 O  \nATOM   4603  C   ASP A   6      13.551  17.556   7.263  1.00                 C  \nATOM   4604  CA  ASP A   6      12.057  17.794   7.443  1.00                 C  \nATOM   4605  CB  ASP A   6      11.313  17.157   6.266  1.00                 C  \nATOM   4606  CG  ASP A   6       9.872  16.817   6.591  1.00                 C  \nATOM   4607  N   ASP A   6      11.790  19.221   7.526  1.00                 N  \nATOM   4608  O   ASP A   6      14.234  17.012   8.142  1.00                 O  \nATOM   4609  OD1 ASP A   6       9.573  16.471   7.749  1.00                 O  \nATOM   4610  OD2 ASP A   6       9.031  16.872   5.670  1.00                 O  \nATOM   4611  C   LYS A   7      16.399  18.145   6.897  1.00                 C  \nATOM   4612  CA  LYS A   7      15.444  17.828   5.757  1.00                 C  \nATOM   4613  CB  LYS A   7      15.742  18.692   4.539  1.00                 C  \nATOM   4614  CD  LYS A   7      15.226  18.869   2.077  1.00                 C  \nATOM   4615  CE  LYS A   7      14.150  18.736   1.012  1.00                 C  \nATOM   4616  CG  LYS A   7      14.690  18.523   3.451  1.00                 C  \nATOM   4617  N   LYS A   7      14.047  17.986   6.109  1.00                 N  \nATOM   4618  NZ  LYS A   7      13.117  19.792   1.165  1.00                 N  \nATOM   4619  O   LYS A   7      17.419  17.477   7.060  1.00                 O  \nATOM   4620  C   THR A   8      17.216  18.433   9.783  1.00                 C  \nATOM   4621  CA  THR A   8      16.898  19.572   8.814  1.00                 C  \nATOM   4622  CB  THR A   8      16.215  20.713   9.600  1.00                 C  \nATOM   4623  CG2 THR A   8      17.269  21.604  10.294  1.00                 C  \nATOM   4624  N   THR A   8      16.053  19.148   7.699  1.00                 N  \nATOM   4625  O   THR A   8      18.378  18.206  10.155  1.00                 O  \nATOM   4626  OG1 THR A   8      15.438  21.511   8.694  1.00                 O  \nATOM   4627  C   ASN A   9      16.845  15.370  10.474  1.00                 C  \nATOM   4628  CA  ASN A   9      16.248  16.610  11.119  1.00                 C  \nATOM   4629  CB  ASN A   9      14.847  16.325  11.646  1.00                 C  \nATOM   4630  CG  ASN A   9      14.140  17.590  12.085  1.00                 C  \nATOM   4631  N   ASN A   9      16.163  17.724  10.177  1.00                 N  \nATOM   4632  ND2 ASN A   9      13.231  18.090  11.247  1.00                 N  \nATOM   4633  O   ASN A   9      17.656  14.675  11.084  1.00                 O  \nATOM   4634  OD1 ASN A   9      14.429  18.133  13.153  1.00                 O  \nATOM   4635  C   VAL A  10      18.462  14.017   8.653  1.00                 C  \nATOM   4636  CA  VAL A  10      16.942  13.965   8.480  1.00                 C  \nATOM   4637  CB  VAL A  10      16.568  14.098   6.979  1.00                 C  \nATOM   4638  CG1 VAL A  10      17.216  12.986   6.170  1.00                 C  \nATOM   4639  CG2 VAL A  10      15.065  14.044   6.819  1.00                 C  \nATOM   4640  N   VAL A  10      16.425  15.099   9.241  1.00                 N  \nATOM   4641  O   VAL A  10      19.146  12.991   8.686  1.00                 O  \nATOM   4642  C   LYS A  11      20.691  15.337  10.459  1.00                 C  \nATOM   4643  CA  LYS A  11      20.400  15.456   8.974  1.00                 C  \nATOM   4644  CB  LYS A  11      20.796  16.848   8.481  1.00                 C  \nATOM   4645  CD  LYS A  11      20.458  16.043   6.095  1.00                 C  \nATOM   4646  CE  LYS A  11      21.926  15.672   5.920  1.00                 C  \nATOM   4647  CG  LYS A  11      20.265  17.181   7.095  1.00                 C  \nATOM   4648  N   LYS A  11      18.976  15.236   8.776  1.00                 N  \nATOM   4649  NZ  LYS A  11      22.532  15.070   7.151  1.00                 N  \nATOM   4650  O   LYS A  11      21.556  14.567  10.870  1.00                 O  \nATOM   4651  C   ALA A  12      20.203  14.628  13.156  1.00                 C  \nATOM   4652  CA  ALA A  12      20.124  16.084  12.703  1.00                 C  \nATOM   4653  CB  ALA A  12      18.948  16.796  13.378  1.00                 C  \nATOM   4654  N   ALA A  12      19.955  16.105  11.257  1.00                 N  \nATOM   4655  O   ALA A  12      20.977  14.279  14.056  1.00                 O  \nATOM   4656  C   ALA A  13      20.623  11.707  12.279  1.00                 C  \nATOM   4657  CA  ALA A  13      19.369  12.366  12.833  1.00                 C  \nATOM   4658  CB  ALA A  13      18.137  11.739  12.237  1.00                 C  \nATOM   4659  N   ALA A  13      19.399  13.785  12.517  1.00                 N  \nATOM   4660  O   ALA A  13      21.405  11.131  13.032  1.00                 O  \nATOM   4744  C   GLY A  25      22.203  -2.220   8.559  1.00                 C  \nATOM   4745  CA  GLY A  25      22.276  -0.715   8.374  1.00                 C  \nATOM   4746  N   GLY A  25      22.739  -0.077   9.592  1.00                 N  \nATOM   4747  O   GLY A  25      21.294  -2.883   8.063  1.00                 O  \nATOM   4748  C   ALA A  26      21.915  -4.587  10.285  1.00                 C  \nATOM   4749  CA  ALA A  26      23.171  -4.210   9.525  1.00                 C  \nATOM   4750  CB  ALA A  26      24.410  -4.614  10.311  1.00                 C  \nATOM   4751  N   ALA A  26      23.163  -2.774   9.291  1.00                 N  \nATOM   4752  O   ALA A  26      21.097  -5.353   9.785  1.00                 O  \nATOM   4753  C   GLU A  27      19.276  -4.135  11.633  1.00                 C  \nATOM   4754  CA  GLU A  27      20.623  -4.288  12.378  1.00                 C  \nATOM   4755  CB  GLU A  27      20.702  -3.332  13.582  1.00                 C  \nATOM   4756  CD  GLU A  27      19.936  -2.606  15.877  1.00                 C  \nATOM   4757  CG  GLU A  27      19.774  -3.630  14.752  1.00                 C  \nATOM   4758  N   GLU A  27      21.773  -4.034  11.490  1.00                 N  \nATOM   4759  O   GLU A  27      18.353  -4.939  11.808  1.00                 O  \nATOM   4760  OE1 GLU A  27      20.422  -1.489  15.605  1.00                 O  \nATOM   4761  OE2 GLU A  27      19.570  -2.913  17.034  1.00                 O  \nATOM   4762  C   ALA A  28      17.801  -4.143   9.156  1.00                 C  \nATOM   4763  CA  ALA A  28      17.958  -2.893  10.023  1.00                 C  \nATOM   4764  CB  ALA A  28      18.091  -1.638   9.133  1.00                 C  \nATOM   4765  N   ALA A  28      19.170  -3.101  10.804  1.00                 N  \nATOM   4766  O   ALA A  28      16.786  -4.860   9.228  1.00                 O  \nATOM   4767  C   LEU A  29      18.527  -6.841   8.258  1.00                 C  \nATOM   4768  CA  LEU A  29      18.826  -5.571   7.483  1.00                 C  \nATOM   4769  CB  LEU A  29      20.162  -5.708   6.775  1.00                 C  \nATOM   4770  CD1 LEU A  29      21.848  -5.106   5.099  1.00                 C  \nATOM   4771  CD2 LEU A  29      19.409  -4.982   4.482  1.00                 C  \nATOM   4772  CG  LEU A  29      20.445  -4.788   5.593  1.00                 C  \nATOM   4773  N   LEU A  29      18.826  -4.407   8.344  1.00                 N  \nATOM   4774  O   LEU A  29      17.798  -7.700   7.773  1.00                 O  \nATOM   4775  C   GLU A  30      17.403  -8.216  10.818  1.00                 C  \nATOM   4776  CA  GLU A  30      18.797  -8.174  10.231  1.00                 C  \nATOM   4777  CB  GLU A  30      19.785  -8.346  11.364  1.00                 C  \nATOM   4778  CD  GLU A  30      20.426  -9.947  13.220  1.00                 C  \nATOM   4779  CG  GLU A  30      19.409  -9.581  12.176  1.00                 C  \nATOM   4780  N   GLU A  30      19.065  -6.972   9.464  1.00                 N  \nATOM   4781  O   GLU A  30      16.752  -9.279  10.831  1.00                 O  \nATOM   4782  OE1 GLU A  30      20.272 -11.049  13.794  1.00                 O  \nATOM   4783  OE2 GLU A  30      21.364  -9.139  13.462  1.00                 O  \nATOM   4784  C   ARG A  31      14.641  -7.356  10.856  1.00                 C  \nATOM   4785  CA  ARG A  31      15.626  -6.984  11.930  1.00                 C  \nATOM   4786  CB  ARG A  31      15.330  -5.564  12.421  1.00                 C  \nATOM   4787  CD  ARG A  31      15.667  -3.793  14.147  1.00                 C  \nATOM   4788  CG  ARG A  31      16.102  -5.160  13.662  1.00                 C  \nATOM   4789  CZ  ARG A  31      15.706  -4.095  16.608  1.00                 C  \nATOM   4790  N   ARG A  31      16.959  -7.071  11.338  1.00                 N  \nATOM   4791  NE  ARG A  31      16.144  -3.503  15.495  1.00                 N  \nATOM   4792  NH1 ARG A  31      16.223  -3.739  17.774  1.00                 N  \nATOM   4793  NH2 ARG A  31      14.760  -5.029  16.567  1.00                 N  \nATOM   4794  O   ARG A  31      13.623  -8.003  11.113  1.00                 O  \nATOM   4795  C   MET A  32      14.062  -8.715   8.176  1.00                 C  \nATOM   4796  CA  MET A  32      14.127  -7.230   8.501  1.00                 C  \nATOM   4797  CB  MET A  32      14.592  -6.458   7.271  1.00                 C  \nATOM   4798  CE  MET A  32      15.692  -6.959   4.075  1.00                 C  \nATOM   4799  CG  MET A  32      13.766  -6.762   6.033  1.00                 C  \nATOM   4800  N   MET A  32      14.976  -6.949   9.636  1.00                 N  \nATOM   4801  O   MET A  32      12.964  -9.288   8.116  1.00                 O  \nATOM   4802  SD  MET A  32      14.363  -5.878   4.558  1.00                 S  \nATOM   4803  C   PHE A  33      14.485 -11.512   8.749  1.00                 C  \nATOM   4804  CA  PHE A  33      15.188 -10.764   7.642  1.00                 C  \nATOM   4805  CB  PHE A  33      16.594 -11.329   7.448  1.00                 C  \nATOM   4806  CD1 PHE A  33      16.855 -10.558   5.061  1.00                 C  \nATOM   4807  CD2 PHE A  33      18.647 -10.166   6.615  1.00                 C  \nATOM   4808  CE1 PHE A  33      17.590  -9.959   4.047  1.00                 C  \nATOM   4809  CE2 PHE A  33      19.394  -9.566   5.617  1.00                 C  \nATOM   4810  CG  PHE A  33      17.375 -10.668   6.352  1.00                 C  \nATOM   4811  CZ  PHE A  33      18.864  -9.460   4.317  1.00                 C  \nATOM   4812  N   PHE A  33      15.218  -9.351   7.978  1.00                 N  \nATOM   4813  O   PHE A  33      13.699 -12.430   8.492  1.00                 O  \nATOM   4814  C   LEU A  34      12.615 -11.561  11.231  1.00                 C  \nATOM   4815  CA  LEU A  34      14.119 -11.744  11.111  1.00                 C  \nATOM   4816  CB  LEU A  34      14.794 -11.299  12.395  1.00                 C  \nATOM   4817  CD1 LEU A  34      16.079 -12.049  14.405  1.00                 C  \nATOM   4818  CD2 LEU A  34      14.674 -13.694  13.117  1.00                 C  \nATOM   4819  CG  LEU A  34      15.576 -12.459  13.024  1.00                 C  \nATOM   4820  N   LEU A  34      14.740 -11.095   9.984  1.00                 N  \nATOM   4821  O   LEU A  34      11.886 -12.543  11.334  1.00                 O  \nATOM   4935  C   LEU A  48      22.048 -14.701   8.350  1.00                 C  \nATOM   4936  CA  LEU A  48      21.935 -14.631   6.838  1.00                 C  \nATOM   4937  CB  LEU A  48      20.463 -14.651   6.417  1.00                 C  \nATOM   4938  CD1 LEU A  48      18.666 -14.858   4.700  1.00                 C  \nATOM   4939  CD2 LEU A  48      20.597 -13.339   4.302  1.00                 C  \nATOM   4940  CG  LEU A  48      20.156 -14.643   4.914  1.00                 C  \nATOM   4941  N   LEU A  48      22.660 -15.711   6.185  1.00                 N  \nATOM   4942  O   LEU A  48      21.833 -13.704   9.034  1.00                 O  \nATOM   4943  C   SER A  49      23.159 -14.915  11.022  1.00                 C  \nATOM   4944  CA  SER A  49      22.544 -16.111  10.298  1.00                 C  \nATOM   4945  CB  SER A  49      23.412 -17.345  10.516  1.00                 C  \nATOM   4946  N   SER A  49      22.387 -15.883   8.859  1.00                 N  \nATOM   4947  O   SER A  49      23.910 -14.133  10.427  1.00                 O  \nATOM   4948  OG  SER A  49      24.573 -17.267   9.707  1.00                 O  \nATOM   4949  C   HIS A  50      24.849 -13.407  12.909  1.00                 C  \nATOM   4950  CA  HIS A  50      23.358 -13.665  13.107  1.00                 C  \nATOM   4951  CB  HIS A  50      23.075 -13.873  14.607  1.00                 C  \nATOM   4952  CD2 HIS A  50      24.438 -12.497  16.340  1.00                 C  \nATOM   4953  CE1 HIS A  50      23.344 -10.602  16.159  1.00                 C  \nATOM   4954  CG  HIS A  50      23.434 -12.689  15.452  1.00                 C  \nATOM   4955  N   HIS A  50      22.853 -14.784  12.312  1.00                 N  \nATOM   4956  ND1 HIS A  50      22.765 -11.485  15.366  1.00                 N  \nATOM   4957  NE2 HIS A  50      24.363 -11.189  16.761  1.00                 N  \nATOM   4958  O   HIS A  50      25.642 -14.336  12.778  1.00                 O  \nATOM   4959  C   GLY A  51      27.150 -12.058  11.326  1.00                 C  \nATOM   4960  CA  GLY A  51      26.615 -11.791  12.713  1.00                 C  \nATOM   4961  N   GLY A  51      25.221 -12.136  12.876  1.00                 N  \nATOM   4962  O   GLY A  51      28.329 -11.817  11.075  1.00                 O  \nATOM   4963  C   SER A  52      27.669 -11.680   8.593  1.00                 C  \nATOM   4964  CA  SER A  52      26.751 -12.822   9.056  1.00                 C  \nATOM   4965  CB  SER A  52      25.536 -12.924   8.135  1.00                 C  \nATOM   4966  N   SER A  52      26.310 -12.561  10.426  1.00                 N  \nATOM   4967  O   SER A  52      27.328 -10.509   8.749  1.00                 O  \nATOM   4968  OG  SER A  52      25.906 -12.784   6.772  1.00                 O  \nATOM   4969  C   ALA A  53      29.331 -10.247   6.336  1.00                 C  \nATOM   4970  CA  ALA A  53      29.776 -10.991   7.588  1.00                 C  \nATOM   4971  CB  ALA A  53      31.148 -11.617   7.355  1.00                 C  \nATOM   4972  N   ALA A  53      28.828 -12.012   8.032  1.00                 N  \nATOM   4973  O   ALA A  53      29.445  -9.014   6.259  1.00                 O  \nATOM   4974  C   GLN A  54      27.183  -9.477   4.400  1.00                 C  \nATOM   4975  CA  GLN A  54      28.411 -10.349   4.115  1.00                 C  \nATOM   4976  CB  GLN A  54      28.122 -11.392   3.022  1.00                 C  \nATOM   4977  CD  GLN A  54      26.951 -13.508   2.285  1.00                 C  \nATOM   4978  CG  GLN A  54      27.322 -12.611   3.464  1.00                 C  \nATOM   4979  N   GLN A  54      28.849 -10.992   5.343  1.00                 N  \nATOM   4980  NE2 GLN A  54      27.401 -13.131   1.093  1.00                 N  \nATOM   4981  O   GLN A  54      26.970  -8.450   3.745  1.00                 O  \nATOM   4982  OE1 GLN A  54      26.270 -14.520   2.446  1.00                 O  \nATOM   4983  C   VAL A  55      25.632  -7.750   6.262  1.00                 C  \nATOM   4984  CA  VAL A  55      25.207  -9.145   5.805  1.00                 C  \nATOM   4985  CB  VAL A  55      24.456  -9.901   6.927  1.00                 C  \nATOM   4986  CG1 VAL A  55      24.241  -9.011   8.131  1.00                 C  \nATOM   4987  CG2 VAL A  55      23.137 -10.415   6.393  1.00                 C  \nATOM   4988  N   VAL A  55      26.400  -9.884   5.400  1.00                 N  \nATOM   4989  O   VAL A  55      24.992  -6.759   5.921  1.00                 O  \nATOM   4990  C   LYS A  56      27.949  -5.715   6.328  1.00                 C  \nATOM   4991  CA  LYS A  56      27.279  -6.426   7.504  1.00                 C  \nATOM   4992  CB  LYS A  56      28.326  -6.692   8.579  1.00                 C  \nATOM   4993  CD  LYS A  56      29.005  -8.017  10.559  1.00                 C  \nATOM   4994  CE  LYS A  56      28.564  -9.052  11.583  1.00                 C  \nATOM   4995  CG  LYS A  56      27.834  -7.545   9.718  1.00                 C  \nATOM   4996  N   LYS A  56      26.724  -7.687   7.022  1.00                 N  \nATOM   4997  NZ  LYS A  56      29.708  -9.934  11.972  1.00                 N  \nATOM   4998  O   LYS A  56      27.966  -4.486   6.241  1.00                 O  \nATOM   4999  C   GLY A  57      28.117  -5.196   3.459  1.00                 C  \nATOM   5000  CA  GLY A  57      29.165  -5.933   4.262  1.00                 C  \nATOM   5001  N   GLY A  57      28.522  -6.506   5.428  1.00                 N  \nATOM   5002  O   GLY A  57      28.411  -4.284   2.672  1.00                 O  \nATOM   5003  C   HIS A  58      25.292  -3.774   3.761  1.00                 C  \nATOM   5004  CA  HIS A  58      25.765  -4.968   2.967  1.00                 C  \nATOM   5005  CB  HIS A  58      24.630  -5.962   2.804  1.00                 C  \nATOM   5006  CD2 HIS A  58      22.293  -5.635   1.735  1.00                 C  \nATOM   5007  CE1 HIS A  58      22.957  -4.763  -0.164  1.00                 C  \nATOM   5008  CG  HIS A  58      23.643  -5.554   1.768  1.00                 C  \nATOM   5009  N   HIS A  58      26.869  -5.593   3.666  1.00                 N  \nATOM   5010  ND1 HIS A  58      24.029  -5.004   0.567  1.00                 N  \nATOM   5011  NE2 HIS A  58      21.890  -5.137   0.520  1.00                 N  \nATOM   5012  O   HIS A  58      25.102  -2.689   3.220  1.00                 O  \nATOM   5013  C   GLY A  59      25.364  -1.625   5.712  1.00                 C  \nATOM   5014  CA  GLY A  59      24.668  -2.944   5.952  1.00                 C  \nATOM   5015  N   GLY A  59      25.124  -3.994   5.061  1.00                 N  \nATOM   5016  O   GLY A  59      24.720  -0.583   5.607  1.00                 O  \nATOM   5017  C   LYS A  60      27.168   0.147   4.034  1.00                 C  \nATOM   5018  CA  LYS A  60      27.474  -0.470   5.395  1.00                 C  \nATOM   5019  CB  LYS A  60      28.975  -0.788   5.506  1.00                 C  \nATOM   5020  CD  LYS A  60      30.008   1.376   6.410  1.00                 C  \nATOM   5021  CE  LYS A  60      30.543   2.732   5.957  1.00                 C  \nATOM   5022  CG  LYS A  60      29.901   0.409   5.227  1.00                 C  \nATOM   5023  N   LYS A  60      26.687  -1.673   5.618  1.00                 N  \nATOM   5024  NZ  LYS A  60      31.599   2.619   4.887  1.00                 N  \nATOM   5025  O   LYS A  60      27.193   1.371   3.880  1.00                 O  \nATOM   5026  C   LYS A  61      25.276   0.607   1.746  1.00                 C  \nATOM   5027  CA  LYS A  61      26.576  -0.185   1.709  1.00                 C  \nATOM   5028  CB  LYS A  61      26.436  -1.325   0.684  1.00                 C  \nATOM   5029  CD  LYS A  61      27.901  -2.492  -1.007  1.00                 C  \nATOM   5030  CE  LYS A  61      28.879  -3.643  -1.245  1.00                 C  \nATOM   5031  CG  LYS A  61      27.662  -2.215   0.487  1.00                 C  \nATOM   5032  N   LYS A  61      26.874  -0.694   3.047  1.00                 N  \nATOM   5033  NZ  LYS A  61      28.228  -4.968  -1.001  1.00                 N  \nATOM   5034  O   LYS A  61      25.238   1.793   1.401  1.00                 O  \nATOM   5035  C   VAL A  62      22.970   1.861   3.036  1.00                 C  \nATOM   5036  CA  VAL A  62      22.900   0.549   2.263  1.00                 C  \nATOM   5037  CB  VAL A  62      21.912  -0.393   2.951  1.00                 C  \nATOM   5038  CG1 VAL A  62      20.602   0.329   3.213  1.00                 C  \nATOM   5039  CG2 VAL A  62      21.680  -1.609   2.078  1.00                 C  \nATOM   5040  N   VAL A  62      24.210  -0.067   2.166  1.00                 N  \nATOM   5041  O   VAL A  62      22.495   2.893   2.564  1.00                 O  \nATOM   5042  C   ALA A  63      24.344   4.128   4.222  1.00                 C  \nATOM   5043  CA  ALA A  63      23.685   3.025   5.029  1.00                 C  \nATOM   5044  CB  ALA A  63      24.489   2.743   6.271  1.00                 C  \nATOM   5045  N   ALA A  63      23.572   1.823   4.218  1.00                 N  \nATOM   5046  O   ALA A  63      23.794   5.229   4.083  1.00                 O  \nATOM   5047  C   ASP A  64      25.337   5.338   1.791  1.00                 C  \nATOM   5048  CA  ASP A  64      26.239   4.819   2.891  1.00                 C  \nATOM   5049  CB  ASP A  64      27.510   4.229   2.276  1.00                 C  \nATOM   5050  CG  ASP A  64      28.647   4.107   3.285  1.00                 C  \nATOM   5051  N   ASP A  64      25.526   3.833   3.687  1.00                 N  \nATOM   5052  O   ASP A  64      25.239   6.546   1.582  1.00                 O  \nATOM   5053  OD1 ASP A  64      28.799   5.027   4.123  1.00                 O  \nATOM   5054  OD2 ASP A  64      29.394   3.098   3.229  1.00                 O  \nATOM   5055  C   ALA A  65      22.753   5.832   0.530  1.00                 C  \nATOM   5056  CA  ALA A  65      23.783   4.833   0.013  1.00                 C  \nATOM   5057  CB  ALA A  65      23.100   3.623  -0.585  1.00                 C  \nATOM   5058  N   ALA A  65      24.667   4.428   1.092  1.00                 N  \nATOM   5059  O   ALA A  65      22.358   6.748  -0.189  1.00                 O  \nATOM   5060  C   LEU A  66      22.023   7.902   2.623  1.00                 C  \nATOM   5061  CA  LEU A  66      21.342   6.579   2.349  1.00                 C  \nATOM   5062  CB  LEU A  66      20.746   6.006   3.640  1.00                 C  \nATOM   5063  CD1 LEU A  66      19.469   4.143   4.721  1.00                 C  \nATOM   5064  CD2 LEU A  66      18.462   5.450   2.838  1.00                 C  \nATOM   5065  CG  LEU A  66      19.736   4.873   3.421  1.00                 C  \nATOM   5066  N   LEU A  66      22.319   5.663   1.777  1.00                 N  \nATOM   5067  O   LEU A  66      21.475   8.968   2.319  1.00                 O  \nATOM   5068  C   THR A  67      24.064   9.883   2.214  1.00                 C  \nATOM   5069  CA  THR A  67      23.990   9.038   3.478  1.00                 C  \nATOM   5070  CB  THR A  67      25.418   8.718   3.911  1.00                 C  \nATOM   5071  CG2 THR A  67      26.141  10.005   4.287  1.00                 C  \nATOM   5072  N   THR A  67      23.226   7.833   3.188  1.00                 N  \nATOM   5073  O   THR A  67      24.076  11.116   2.270  1.00                 O  \nATOM   5074  OG1 THR A  67      25.397   7.822   5.034  1.00                 O  \n\nENDMDL\n\n";

	// target, 4N7N_A
	pTmalignCgi->m_pdb_target = "MODEL        1\nHEADER    PDB From iCn3D                                      1HHO\nTITLE     \nHELIX          PRO A    4ATOM     22  C   PRO A   4      13.843  22.356   7.064  1.00                 C  \nATOM     23  CA  PRO A   4      13.694  23.016   5.684  1.00                 C  \nATOM     24  CB  PRO A   4      13.523  24.558   5.714  1.00                 C  \nATOM     25  CD  PRO A   4      11.629  23.655   4.577  1.00                 C  \nATOM     26  CG  PRO A   4      12.038  24.812   5.475  1.00                 C  \nATOM     27  N   PRO A   4      12.509  22.516   4.997  1.00                 N  \nATOM     28  O   PRO A   4      14.963  22.260   7.554  1.00                 O  \nATOM     29  C   ALA A   5      13.100  19.832   8.963  1.00                 C  \nATOM     30  CA  ALA A   5      12.961  21.343   9.015  1.00                 C  \nATOM     31  CB  ALA A   5      11.799  21.676   9.942  1.00                 C  \nATOM     32  N   ALA A   5      12.767  21.879   7.680  1.00                 N  \nATOM     33  O   ALA A   5      13.653  19.274   9.908  1.00                 O  \nATOM     34  C   ASP A   6      14.214  17.617   7.527  1.00                 C  \nATOM     35  CA  ASP A   6      12.747  17.819   7.811  1.00                 C  \nATOM     36  CB  ASP A   6      11.886  17.240   6.691  1.00                 C  \nATOM     37  CG  ASP A   6      10.401  17.288   7.059  1.00                 C  \nATOM     38  N   ASP A   6      12.576  19.247   7.933  1.00                 N  \nATOM     39  O   ASP A   6      14.881  16.823   8.195  1.00                 O  \nATOM     40  OD1 ASP A   6       9.650  17.429   6.096  1.00                 O  \nATOM     41  OD2 ASP A   6      10.020  17.112   8.243  1.00                 O  \nATOM     42  C   LYS A   7      16.931  18.686   7.416  1.00                 C  \nATOM     43  CA  LYS A   7      16.044  18.315   6.188  1.00                 C  \nATOM     44  CB  LYS A   7      16.189  19.063   4.849  1.00                 C  \nATOM     45  CD  LYS A   7      16.603  21.516   4.430  1.00                 C  \nATOM     46  CE  LYS A   7      17.635  22.674   4.307  1.00                 C  \nATOM     47  CG  LYS A   7      17.235  20.167   4.833  1.00                 C  \nATOM     48  N   LYS A   7      14.656  18.365   6.559  1.00                 N  \nATOM     49  NZ  LYS A   7      18.523  22.518   3.124  1.00                 N  \nATOM     50  O   LYS A   7      17.996  18.141   7.672  1.00                 O  \nATOM     51  C   THR A   8      17.478  18.624  10.509  1.00                 C  \nATOM     52  CA  THR A   8      17.339  19.789   9.496  1.00                 C  \nATOM     53  CB  THR A   8      16.716  21.018  10.162  1.00                 C  \nATOM     54  CG2 THR A   8      17.390  21.341  11.476  1.00                 C  \nATOM     55  N   THR A   8      16.489  19.493   8.317  1.00                 N  \nATOM     56  O   THR A   8      18.589  18.398  11.008  1.00                 O  \nATOM     57  OG1 THR A   8      16.829  22.145   9.316  1.00                 O  \nATOM     58  C   ASN A   9      16.793  15.507  11.041  1.00                 C  \nATOM     59  CA  ASN A   9      16.138  16.761  11.653  1.00                 C  \nATOM     60  CB  ASN A   9      14.635  16.436  11.620  1.00                 C  \nATOM     61  CG  ASN A   9      13.694  17.250  12.497  1.00                 C  \nATOM     62  N   ASN A   9      16.353  17.956  10.801  1.00                 N  \nATOM     63  ND2 ASN A   9      14.186  17.894  13.516  1.00                 N  \nATOM     64  O   ASN A   9      17.290  14.576  11.693  1.00                 O  \nATOM     65  OD1 ASN A   9      12.492  17.244  12.250  1.00                 O  \nATOM     66  C   VAL A  10      18.823  14.531   9.150  1.00                 C  \nATOM     67  CA  VAL A  10      17.311  14.299   9.160  1.00                 C  \nATOM     68  CB  VAL A  10      16.727  14.070   7.764  1.00                 C  \nATOM     69  CG1 VAL A  10      17.557  13.121   6.884  1.00                 C  \nATOM     70  CG2 VAL A  10      15.265  13.626   7.828  1.00                 C  \nATOM     71  N   VAL A  10      16.713  15.463   9.753  1.00                 N  \nATOM     72  O   VAL A  10      19.528  13.512   9.304  1.00                 O  \nATOM     73  C   LYS A  11      21.181  15.829  10.397  1.00                 C  \nATOM     74  CA  LYS A  11      20.672  16.223   9.014  1.00                 C  \nATOM     75  CB  LYS A  11      20.989  17.656   8.531  1.00                 C  \nATOM     76  CD  LYS A  11      20.881  19.067   6.254  1.00                 C  \nATOM     77  CE  LYS A  11      20.891  18.859   4.706  1.00                 C  \nATOM     78  CG  LYS A  11      21.107  17.707   6.983  1.00                 C  \nATOM     79  N   LYS A  11      19.251  15.843   9.008  1.00                 N  \nATOM     80  NZ  LYS A  11      20.961  20.091   3.869  1.00                 N  \nATOM     81  O   LYS A  11      22.334  15.467  10.605  1.00                 O  \nATOM     82  C   ALA A  12      20.557  14.341  13.401  1.00                 C  \nATOM     83  CA  ALA A  12      20.707  15.661  12.646  1.00                 C  \nATOM     84  CB  ALA A  12      19.862  16.725  13.341  1.00                 C  \nATOM     85  N   ALA A  12      20.261  15.699  11.295  1.00                 N  \nATOM     86  O   ALA A  12      21.343  13.950  14.285  1.00                 O  \nATOM     87  C   ALA A  13      20.674  11.531  13.058  1.00                 C  \nATOM     88  CA  ALA A  13      19.530  12.369  13.698  1.00                 C  \nATOM     89  CB  ALA A  13      18.160  11.776  13.336  1.00                 C  \nATOM     90  N   ALA A  13      19.515  13.708  13.136  1.00                 N  \nATOM     91  O   ALA A  13      21.210  10.531  13.598  1.00                 O  \nATOM    175  C   GLY A  25      22.028  -2.253   8.696  1.00                 C  \nATOM    176  CA  GLY A  25      22.026  -0.753   8.852  1.00                 C  \nATOM    177  N   GLY A  25      22.605  -0.453  10.094  1.00                 N  \nATOM    178  O   GLY A  25      21.365  -2.798   7.804  1.00                 O  \nATOM    179  C   ALA A  26      21.889  -4.862  10.190  1.00                 C  \nATOM    180  CA  ALA A  26      22.955  -4.271   9.319  1.00                 C  \nATOM    181  CB  ALA A  26      24.346  -4.729   9.759  1.00                 C  \nATOM    182  N   ALA A  26      22.807  -2.851   9.537  1.00                 N  \nATOM    183  O   ALA A  26      21.371  -5.924   9.844  1.00                 O  \nATOM    184  C   GLU A  27      19.174  -4.435  11.561  1.00                 C  \nATOM    185  CA  GLU A  27      20.554  -4.572  12.186  1.00                 C  \nATOM    186  CB  GLU A  27      20.650  -3.774  13.469  1.00                 C  \nATOM    187  CD  GLU A  27      19.679  -3.146  15.697  1.00                 C  \nATOM    188  CG  GLU A  27      19.484  -3.958  14.415  1.00                 C  \nATOM    189  N   GLU A  27      21.570  -4.084  11.223  1.00                 N  \nATOM    190  O   GLU A  27      18.310  -5.280  11.846  1.00                 O  \nATOM    191  OE1 GLU A  27      20.819  -2.799  16.034  1.00                 O  \nATOM    192  OE2 GLU A  27      18.665  -2.901  16.355  1.00                 O  \nATOM    193  C   ALA A  28      17.206  -4.219   9.265  1.00                 C  \nATOM    194  CA  ALA A  28      17.634  -3.098  10.213  1.00                 C  \nATOM    195  CB  ALA A  28      17.883  -1.861   9.404  1.00                 C  \nATOM    196  N   ALA A  28      19.015  -3.429  10.671  1.00                 N  \nATOM    197  O   ALA A  28      16.058  -4.674   9.211  1.00                 O  \nATOM    198  C   LEU A  29      17.915  -6.991   8.217  1.00                 C  \nATOM    199  CA  LEU A  29      18.246  -5.682   7.554  1.00                 C  \nATOM    200  CB  LEU A  29      19.580  -5.912   6.882  1.00                 C  \nATOM    201  CD1 LEU A  29      21.332  -5.041   5.417  1.00                 C  \nATOM    202  CD2 LEU A  29      18.831  -5.062   4.562  1.00                 C  \nATOM    203  CG  LEU A  29      19.823  -4.897   5.771  1.00                 C  \nATOM    204  N   LEU A  29      18.263  -4.619   8.552  1.00                 N  \nATOM    205  O   LEU A  29      17.042  -7.699   7.712  1.00                 O  \nATOM    206  C   GLU A  30      16.789  -8.537  10.534  1.00                 C  \nATOM    207  CA  GLU A  30      18.268  -8.506  10.073  1.00                 C  \nATOM    208  CB  GLU A  30      19.172  -8.549  11.313  1.00                 C  \nATOM    209  CD  GLU A  30      19.987  -9.781  13.339  1.00                 C  \nATOM    210  CG  GLU A  30      19.182  -9.908  12.036  1.00                 C  \nATOM    211  N   GLU A  30      18.612  -7.271   9.305  1.00                 N  \nATOM    212  O   GLU A  30      16.066  -9.527  10.365  1.00                 O  \nATOM    213  OE1 GLU A  30      19.484 -10.240  14.364  1.00                 O  \nATOM    214  OE2 GLU A  30      21.078  -9.193  13.349  1.00                 O  \nATOM    215  C   ARG A  31      13.971  -7.661  10.458  1.00                 C  \nATOM    216  CA  ARG A  31      14.968  -7.298  11.559  1.00                 C  \nATOM    217  CB  ARG A  31      14.707  -5.820  11.970  1.00                 C  \nATOM    218  CD  ARG A  31      15.191  -4.013  13.768  1.00                 C  \nATOM    219  CG  ARG A  31      15.433  -5.435  13.259  1.00                 C  \nATOM    220  CZ  ARG A  31      15.282  -4.229  16.273  1.00                 C  \nATOM    221  N   ARG A  31      16.374  -7.450  11.134  1.00                 N  \nATOM    222  NE  ARG A  31      15.789  -3.845  15.102  1.00                 N  \nATOM    223  NH1 ARG A  31      14.095  -4.773  16.527  1.00                 N  \nATOM    224  NH2 ARG A  31      16.049  -4.030  17.287  1.00                 N  \nATOM    225  O   ARG A  31      12.921  -8.230  10.739  1.00                 O  \nATOM    226  C   MET A  32      13.240  -8.753   7.640  1.00                 C  \nATOM    227  CA  MET A  32      13.358  -7.328   8.131  1.00                 C  \nATOM    228  CB  MET A  32      13.912  -6.505   6.963  1.00                 C  \nATOM    229  CE  MET A  32      15.275  -6.869   4.200  1.00                 C  \nATOM    230  CG  MET A  32      12.996  -6.558   5.755  1.00                 C  \nATOM    231  N   MET A  32      14.322  -7.269   9.244  1.00                 N  \nATOM    232  O   MET A  32      12.180  -9.222   7.279  1.00                 O  \nATOM    233  SD  MET A  32      13.736  -5.935   4.271  1.00                 S  \nATOM    234  C   PHE A  33      13.759 -11.590   8.111  1.00                 C  \nATOM    235  CA  PHE A  33      14.535 -10.711   7.143  1.00                 C  \nATOM    236  CB  PHE A  33      15.999 -11.057   7.077  1.00                 C  \nATOM    237  CD1 PHE A  33      16.268 -10.157   4.717  1.00                 C  \nATOM    238  CD2 PHE A  33      18.166 -10.098   6.133  1.00                 C  \nATOM    239  CE1 PHE A  33      17.031  -9.594   3.695  1.00                 C  \nATOM    240  CE2 PHE A  33      18.936  -9.532   5.111  1.00                 C  \nATOM    241  CG  PHE A  33      16.832 -10.419   5.937  1.00                 C  \nATOM    242  CZ  PHE A  33      18.369  -9.288   3.889  1.00                 C  \nATOM    243  N   PHE A  33      14.376  -9.359   7.589  1.00                 N  \nATOM    244  O   PHE A  33      13.101 -12.566   7.698  1.00                 O  \nATOM    245  C   LEU A  34      11.664 -11.575  10.498  1.00                 C  \nATOM    246  CA  LEU A  34      13.152 -11.814  10.471  1.00                 C  \nATOM    247  CB  LEU A  34      13.770 -11.391  11.825  1.00                 C  \nATOM    248  CD1 LEU A  34      15.709 -12.993  11.759  1.00                 C  \nATOM    249  CD2 LEU A  34      15.036 -12.069  13.919  1.00                 C  \nATOM    250  CG  LEU A  34      14.530 -12.513  12.552  1.00                 C  \nATOM    251  N   LEU A  34      13.785 -11.114   9.341  1.00                 N  \nATOM    252  O   LEU A  34      10.950 -12.559  10.733  1.00                 O  \nATOM    366  C   LEU A  48      20.790 -14.703   8.097  1.00                 C  \nATOM    367  CA  LEU A  48      20.858 -14.475   6.599  1.00                 C  \nATOM    368  CB  LEU A  48      19.459 -14.612   5.958  1.00                 C  \nATOM    369  CD1 LEU A  48      20.466 -12.994   4.209  1.00                 C  \nATOM    370  CD2 LEU A  48      18.269 -14.111   3.769  1.00                 C  \nATOM    371  CG  LEU A  48      19.220 -13.604   4.826  1.00                 C  \nATOM    372  N   LEU A  48      21.758 -15.494   6.031  1.00                 N  \nATOM    373  O   LEU A  48      19.840 -14.321   8.791  1.00                 O  \nATOM    374  C   SER A  49      22.543 -14.602  10.744  1.00                 C  \nATOM    375  CA  SER A  49      21.830 -15.699   9.968  1.00                 C  \nATOM    376  CB  SER A  49      22.549 -17.036  10.151  1.00                 C  \nATOM    377  N   SER A  49      21.822 -15.307   8.569  1.00                 N  \nATOM    378  O   SER A  49      23.231 -13.769  10.142  1.00                 O  \nATOM    379  OG  SER A  49      23.922 -16.744  10.291  1.00                 O  \nATOM    380  C   HIS A  50      23.955 -12.876  12.607  1.00                 C  \nATOM    381  CA  HIS A  50      22.621 -13.530  12.927  1.00                 C  \nATOM    382  CB  HIS A  50      22.580 -13.947  14.391  1.00                 C  \nATOM    383  CD2 HIS A  50      23.810 -12.565  16.264  1.00                 C  \nATOM    384  CE1 HIS A  50      22.923 -10.528  15.807  1.00                 C  \nATOM    385  CG  HIS A  50      22.947 -12.704  15.211  1.00                 C  \nATOM    386  N   HIS A  50      22.335 -14.659  12.036  1.00                 N  \nATOM    387  ND1 HIS A  50      22.400 -11.452  14.917  1.00                 N  \nATOM    388  NE2 HIS A  50      23.789 -11.216  16.634  1.00                 N  \nATOM    389  O   HIS A  50      23.982 -11.729  12.129  1.00                 O  \nATOM    390  C   GLY A  51      26.891 -12.800  11.376  1.00                 C  \nATOM    391  CA  GLY A  51      26.312 -12.901  12.788  1.00                 C  \nATOM    392  N   GLY A  51      25.022 -13.625  12.793  1.00                 N  \nATOM    393  O   GLY A  51      28.095 -12.522  11.233  1.00                 O  \nATOM    394  C   SER A  52      27.052 -11.729   8.511  1.00                 C  \nATOM    395  CA  SER A  52      26.459 -13.038   8.994  1.00                 C  \nATOM    396  CB  SER A  52      25.376 -13.446   7.998  1.00                 C  \nATOM    397  N   SER A  52      26.007 -12.991  10.386  1.00                 N  \nATOM    398  O   SER A  52      26.426 -10.662   8.499  1.00                 O  \nATOM    399  OG  SER A  52      25.911 -13.265   6.686  1.00                 O  \nATOM    400  C   ALA A  53      28.636 -10.484   6.270  1.00                 C  \nATOM    401  CA  ALA A  53      29.241 -11.109   7.525  1.00                 C  \nATOM    402  CB  ALA A  53      30.459 -11.963   7.154  1.00                 C  \nATOM    403  N   ALA A  53      28.274 -11.984   8.145  1.00                 N  \nATOM    404  O   ALA A  53      28.927  -9.323   6.019  1.00                 O  \nATOM    405  C   GLN A  54      26.317  -9.685   4.516  1.00                 C  \nATOM    406  CA  GLN A  54      27.356 -10.758   4.228  1.00                 C  \nATOM    407  CB  GLN A  54      26.833 -11.885   3.339  1.00                 C  \nATOM    408  CD  GLN A  54      27.393 -14.289   2.697  1.00                 C  \nATOM    409  CG  GLN A  54      27.937 -12.905   3.054  1.00                 C  \nATOM    410  N   GLN A  54      27.829 -11.249   5.529  1.00                 N  \nATOM    411  NE2 GLN A  54      27.615 -14.707   1.455  1.00                 N  \nATOM    412  O   GLN A  54      26.438  -8.591   3.949  1.00                 O  \nATOM    413  OE1 GLN A  54      26.830 -14.958   3.562  1.00                 O  \nATOM    414  C   VAL A  55      25.231  -7.859   6.710  1.00                 C  \nATOM    415  CA  VAL A  55      24.488  -8.967   5.946  1.00                 C  \nATOM    416  CB  VAL A  55      23.443  -9.560   6.868  1.00                 C  \nATOM    417  CG1 VAL A  55      22.462  -8.443   7.253  1.00                 C  \nATOM    418  CG2 VAL A  55      22.661 -10.608   6.119  1.00                 C  \nATOM    419  N   VAL A  55      25.397  -9.999   5.421  1.00                 N  \nATOM    420  O   VAL A  55      24.820  -6.704   6.685  1.00                 O  \nATOM    421  C   LYS A  56      27.483  -6.135   7.003  1.00                 C  \nATOM    422  CA  LYS A  56      27.028  -7.147   8.032  1.00                 C  \nATOM    423  CB  LYS A  56      28.282  -7.748   8.693  1.00                 C  \nATOM    424  CD  LYS A  56      27.067  -8.226  10.892  1.00                 C  \nATOM    425  CE  LYS A  56      27.331  -8.860  12.259  1.00                 C  \nATOM    426  CG  LYS A  56      28.336  -7.703  10.220  1.00                 C  \nATOM    427  N   LYS A  56      26.301  -8.209   7.365  1.00                 N  \nATOM    428  NZ  LYS A  56      28.629  -8.421  12.821  1.00                 N  \nATOM    429  O   LYS A  56      27.383  -4.908   7.121  1.00                 O  \nATOM    430  C   GLY A  57      27.650  -5.181   4.125  1.00                 C  \nATOM    431  CA  GLY A  57      28.672  -5.861   5.027  1.00                 C  \nATOM    432  N   GLY A  57      27.995  -6.703   5.987  1.00                 N  \nATOM    433  O   GLY A  57      28.011  -4.225   3.410  1.00                 O  \nATOM    434  C   HIS A  58      24.728  -3.900   4.005  1.00                 C  \nATOM    435  CA  HIS A  58      25.348  -5.167   3.391  1.00                 C  \nATOM    436  CB  HIS A  58      24.262  -6.206   3.208  1.00                 C  \nATOM    437  CD2 HIS A  58      22.052  -5.373   1.973  1.00                 C  \nATOM    438  CE1 HIS A  58      23.104  -5.068  -0.083  1.00                 C  \nATOM    439  CG  HIS A  58      23.403  -5.706   2.047  1.00                 C  \nATOM    440  N   HIS A  58      26.437  -5.705   4.213  1.00                 N  \nATOM    441  ND1 HIS A  58      24.028  -5.500   0.800  1.00                 N  \nATOM    442  NE2 HIS A  58      21.865  -4.980   0.630  1.00                 N  \nATOM    443  O   HIS A  58      24.513  -2.947   3.288  1.00                 O  \nATOM    444  C   GLY A  59      25.074  -1.786   5.880  1.00                 C  \nATOM    445  CA  GLY A  59      24.177  -2.966   6.248  1.00                 C  \nATOM    446  N   GLY A  59      24.438  -4.011   5.294  1.00                 N  \nATOM    447  O   GLY A  59      24.545  -0.668   5.792  1.00                 O  \nATOM    448  C   LYS A  60      26.931  -0.211   4.225  1.00                 C  \nATOM    449  CA  LYS A  60      27.341  -0.984   5.459  1.00                 C  \nATOM    450  CB  LYS A  60      28.812  -1.383   5.358  1.00                 C  \nATOM    451  CD  LYS A  60      30.952  -2.141   6.517  1.00                 C  \nATOM    452  CE  LYS A  60      31.550  -1.910   7.922  1.00                 C  \nATOM    453  CG  LYS A  60      29.405  -2.144   6.554  1.00                 C  \nATOM    454  N   LYS A  60      26.373  -2.080   5.610  1.00                 N  \nATOM    455  NZ  LYS A  60      33.001  -1.775   7.831  1.00                 N  \nATOM    456  O   LYS A  60      26.970   1.021   4.258  1.00                 O  \nATOM    457  C   LYS A  61      24.870   0.258   1.896  1.00                 C  \nATOM    458  CA  LYS A  61      26.176  -0.495   1.878  1.00                 C  \nATOM    459  CB  LYS A  61      26.090  -1.618   0.864  1.00                 C  \nATOM    460  CD  LYS A  61      27.667  -3.041  -0.458  1.00                 C  \nATOM    461  CE  LYS A  61      27.988  -4.446  -0.018  1.00                 C  \nATOM    462  CG  LYS A  61      27.471  -2.228   0.794  1.00                 C  \nATOM    463  N   LYS A  61      26.532  -0.988   3.231  1.00                 N  \nATOM    464  NZ  LYS A  61      27.718  -5.306  -1.171  1.00                 N  \nATOM    465  O   LYS A  61      24.852   1.368   1.352  1.00                 O  \nATOM    466  C   VAL A  62      22.866   1.694   3.394  1.00                 C  \nATOM    467  CA  VAL A  62      22.582   0.365   2.670  1.00                 C  \nATOM    468  CB  VAL A  62      21.550  -0.561   3.353  1.00                 C  \nATOM    469  CG1 VAL A  62      20.216   0.094   3.658  1.00                 C  \nATOM    470  CG2 VAL A  62      21.272  -1.749   2.445  1.00                 C  \nATOM    471  N   VAL A  62      23.850  -0.337   2.538  1.00                 N  \nATOM    472  O   VAL A  62      22.459   2.735   2.883  1.00                 O  \nATOM    473  C   ALA A  63      24.541   3.940   4.647  1.00                 C  \nATOM    474  CA  ALA A  63      23.851   2.792   5.363  1.00                 C  \nATOM    475  CB  ALA A  63      24.726   2.364   6.522  1.00                 C  \nATOM    476  N   ALA A  63      23.603   1.630   4.504  1.00                 N  \nATOM    477  O   ALA A  63      24.158   5.095   4.843  1.00                 O  \nATOM    478  C   ASP A  64      25.301   5.062   1.949  1.00                 C  \nATOM    479  CA  ASP A  64      26.239   4.469   3.001  1.00                 C  \nATOM    480  CB  ASP A  64      27.470   3.766   2.374  1.00                 C  \nATOM    481  CG  ASP A  64      28.581   3.545   3.434  1.00                 C  \nATOM    482  N   ASP A  64      25.517   3.556   3.872  1.00                 N  \nATOM    483  O   ASP A  64      25.443   6.234   1.604  1.00                 O  \nATOM    484  OD1 ASP A  64      28.535   4.215   4.467  1.00                 O  \nATOM    485  OD2 ASP A  64      29.491   2.722   3.235  1.00                 O  \nATOM    486  C   ALA A  65      22.552   5.853   1.038  1.00                 C  \nATOM    487  CA  ALA A  65      23.534   4.899   0.384  1.00                 C  \nATOM    488  CB  ALA A  65      22.784   3.816  -0.388  1.00                 C  \nATOM    489  N   ALA A  65      24.367   4.291   1.423  1.00                 N  \nATOM    490  O   ALA A  65      22.026   6.795   0.425  1.00                 O  \nATOM    491  C   LEU A  66      22.097   7.796   3.285  1.00                 C  \nATOM    492  CA  LEU A  66      21.404   6.451   3.010  1.00                 C  \nATOM    493  CB  LEU A  66      21.015   5.783   4.334  1.00                 C  \nATOM    494  CD1 LEU A  66      19.332   4.313   5.533  1.00                 C  \nATOM    495  CD2 LEU A  66      18.828   5.215   3.267  1.00                 C  \nATOM    496  CG  LEU A  66      19.935   4.703   4.169  1.00                 C  \nATOM    497  N   LEU A  66      22.303   5.558   2.291  1.00                 N  \nATOM    498  O   LEU A  66      21.433   8.835   3.234  1.00                 O  \nATOM    499  C   THR A  67      24.472   9.757   2.669  1.00                 C  \nATOM    500  CA  THR A  67      24.205   8.939   3.922  1.00                 C  \nATOM    501  CB  THR A  67      25.539   8.636   4.601  1.00                 C  \nATOM    502  CG2 THR A  67      26.254   9.886   5.124  1.00                 C  \nATOM    503  N   THR A  67      23.405   7.733   3.577  1.00                 N  \nATOM    504  O   THR A  67      24.553  10.974   2.752  1.00                 O  \nATOM    505  OG1 THR A  67      25.285   7.846   5.725  1.00                 O  \n\nENDMDL\n";

	pTmalignCgi->main_func();

	cout<<pTmalignCgi->m_output<<endl;
*/
/*
	// discontinuous residues
	unique_ptr<CTmalignCgi> pTmalignCgi(new CTmalignCgi());

	// query, 1HHO_B
	pTmalignCgi->m_pdb_query = "HEADER    PDB From iCn3D                                      1HHO\nTITLE     Structure Of Human Oxyhaemoglobin At 2.1 Angstr...\nHELIX          PRO B    5  TRP B   15\nHELIX          VAL B   23  TYR B   35\nHELIX          PRO B   58  HIS B   77\nHELIX          ALA B   86  CYS B   93\nHELIX          GLU B  101  PHE B  118\nHELIX          PRO B  124  ALA B  142\nREMARK 350   BIOMT1   1         1         0         0              0\nREMARK 350   BIOMT2   1         0         1         0              0\nREMARK 350   BIOMT3   1         0         0         1              0\nREMARK 350   BIOMT1   2        -1         0         0              0\nREMARK 350   BIOMT2   2         0         1         0              0\nREMARK 350   BIOMT3   2         0         0        -1              0\nATOM   1070  C   VAL B   1      10.769 -19.768  -5.014  1.00                 C  \nATOM   1071  CA  VAL B   1      10.737 -18.800  -3.820  1.00                 C  \nATOM   1072  CB  VAL B   1      11.679 -19.318  -2.800  1.00                 C  \nATOM   1073  CG1 VAL B   1      10.768 -19.342  -1.582  1.00                 C  \nATOM   1074  CG2 VAL B   1      12.250 -20.696  -3.202  1.00                 C  \nATOM   1075  N   VAL B   1       9.445 -18.730  -3.132  1.00                 N  \nATOM   1076  O   VAL B   1       9.926 -20.653  -5.223  1.00                 O  \nATOM   1077  C   HIS B   2      13.768 -20.310  -6.626  1.00                 C  \nATOM   1078  CA  HIS B   2      12.288 -20.223  -6.906  1.00                 C  \nATOM   1079  CB  HIS B   2      12.177 -19.327  -8.095  1.00                 C  \nATOM   1080  CD2 HIS B   2      12.796 -21.402  -9.616  1.00                 C  \nATOM   1081  CE1 HIS B   2      12.432 -20.425 -11.667  1.00                 C  \nATOM   1082  CG  HIS B   2      12.390 -20.089  -9.415  1.00                 C  \nATOM   1083  N   HIS B   2      11.763 -19.464  -5.811  1.00                 N  \nATOM   1084  ND1 HIS B   2      12.159 -19.476 -10.670  1.00                 N  \nATOM   1085  NE2 HIS B   2      12.824 -21.614 -11.003  1.00                 N  \nATOM   1086  O   HIS B   2      14.296 -21.361  -6.237  1.00                 O  \nATOM   1087  C   LEU B   3      16.434 -19.486  -7.770  1.00                 C  \nATOM   1088  CA  LEU B   3      15.652 -18.683  -6.748  1.00                 C  \nATOM   1089  CB  LEU B   3      16.238 -18.864  -5.368  1.00                 C  \nATOM   1090  CD1 LEU B   3      17.087 -17.491  -3.535  1.00                 C  \nATOM   1091  CD2 LEU B   3      15.421 -16.515  -5.150  1.00                 C  \nATOM   1092  CG  LEU B   3      15.858 -17.773  -4.391  1.00                 C  \nATOM   1093  N   LEU B   3      14.277 -19.111  -6.827  1.00                 N  \nATOM   1094  O   LEU B   3      16.540 -20.718  -7.689  1.00                 O  \nATOM   1095  C   THR B   4      18.927 -19.910  -9.089  1.00                 C  \nATOM   1096  CA  THR B   4      17.555 -19.659  -9.714  1.00                 C  \nATOM   1097  CB  THR B   4      17.525 -19.025 -11.113  1.00                 C  \nATOM   1098  CG2 THR B   4      16.290 -18.178 -11.387  1.00                 C  \nATOM   1099  N   THR B   4      16.961 -18.797  -8.738  1.00                 N  \nATOM   1100  O   THR B   4      19.287 -19.220  -8.141  1.00                 O  \nATOM   1101  OG1 THR B   4      18.662 -18.216 -11.333  1.00                 O  \nATOM   1102  C   PRO B   5      21.865 -19.992  -8.854  1.00                 C  \nATOM   1103  CA  PRO B   5      20.986 -21.222  -9.095  1.00                 C  \nATOM   1104  CB  PRO B   5      21.575 -22.087 -10.245  1.00                 C  \nATOM   1105  CD  PRO B   5      19.292 -21.742 -10.714  1.00                 C  \nATOM   1106  CG  PRO B   5      20.639 -21.923 -11.425  1.00                 C  \nATOM   1107  N   PRO B   5      19.643 -20.879  -9.560  1.00                 N  \nATOM   1108  O   PRO B   5      22.545 -19.934  -7.827  1.00                 O  \nATOM   1109  C   GLU B   6      22.257 -16.882  -8.913  1.00                 C  \nATOM   1110  CA  GLU B   6      22.717 -17.907  -9.926  1.00                 C  \nATOM   1111  CB  GLU B   6      22.710 -17.290 -11.311  1.00                 C  \nATOM   1112  CD  GLU B   6      21.413 -16.702 -13.289  1.00                 C  \nATOM   1113  CG  GLU B   6      21.420 -17.562 -12.038  1.00                 C  \nATOM   1114  N   GLU B   6      21.872 -19.101  -9.860  1.00                 N  \nATOM   1115  O   GLU B   6      23.141 -16.271  -8.298  1.00                 O  \nATOM   1116  OE1 GLU B   6      20.518 -15.867 -13.431  1.00                 O  \nATOM   1117  OE2 GLU B   6      22.345 -16.850 -14.077  1.00                 O  \nATOM   1118  C   GLU B   7      20.587 -16.499  -6.356  1.00                 C  \nATOM   1119  CA  GLU B   7      20.271 -15.897  -7.720  1.00                 C  \nATOM   1120  CB  GLU B   7      18.747 -15.769  -7.881  1.00                 C  \nATOM   1121  CD  GLU B   7      16.939 -14.721  -9.258  1.00                 C  \nATOM   1122  CG  GLU B   7      18.437 -14.916  -9.106  1.00                 C  \nATOM   1123  N   GLU B   7      20.913 -16.716  -8.800  1.00                 N  \nATOM   1124  O   GLU B   7      20.942 -15.773  -5.417  1.00                 O  \nATOM   1125  OE1 GLU B   7      16.509 -13.562  -9.387  1.00                 O  \nATOM   1126  OE2 GLU B   7      16.229 -15.737  -9.296  1.00                 O  \nATOM   1127  C   LYS B   8      22.229 -18.313  -4.708  1.00                 C  \nATOM   1128  CA  LYS B   8      20.777 -18.647  -5.086  1.00                 C  \nATOM   1129  CB  LYS B   8      20.654 -20.138  -5.393  1.00                 C  \nATOM   1130  CD  LYS B   8      19.969 -20.683  -3.116  1.00                 C  \nATOM   1131  CE  LYS B   8      18.796 -20.972  -2.177  1.00                 C  \nATOM   1132  CG  LYS B   8      19.579 -20.831  -4.580  1.00                 C  \nATOM   1133  N   LYS B   8      20.433 -17.838  -6.299  1.00                 N  \nATOM   1134  NZ  LYS B   8      19.059 -20.440  -0.829  1.00                 N  \nATOM   1135  O   LYS B   8      22.532 -18.016  -3.547  1.00                 O  \nATOM   1136  C   SER B   9      24.812 -16.908  -4.884  1.00                 C  \nATOM   1137  CA  SER B   9      24.524 -18.225  -5.581  1.00                 C  \nATOM   1138  CB  SER B   9      25.235 -18.328  -6.950  1.00                 C  \nATOM   1139  N   SER B   9      23.077 -18.281  -5.758  1.00                 N  \nATOM   1140  O   SER B   9      25.702 -16.815  -4.025  1.00                 O  \nATOM   1141  OG  SER B   9      25.969 -17.113  -7.320  1.00                 O  \nATOM   1142  C   ALA B  10      23.572 -14.158  -3.554  1.00                 C  \nATOM   1143  CA  ALA B  10      24.143 -14.551  -4.935  1.00                 C  \nATOM   1144  CB  ALA B  10      23.549 -13.789  -6.127  1.00                 C  \nATOM   1145  N   ALA B  10      23.961 -15.965  -5.267  1.00                 N  \nATOM   1146  O   ALA B  10      24.123 -13.333  -2.831  1.00                 O  \nATOM   1147  C   VAL B  11      22.714 -15.090  -0.679  1.00                 C  \nATOM   1148  CA  VAL B  11      21.899 -14.534  -1.857  1.00                 C  \nATOM   1149  CB  VAL B  11      20.592 -15.294  -1.896  1.00                 C  \nATOM   1150  CG1 VAL B  11      20.234 -15.768  -0.513  1.00                 C  \nATOM   1151  CG2 VAL B  11      19.468 -14.473  -2.513  1.00                 C  \nATOM   1152  N   VAL B  11      22.491 -14.744  -3.178  1.00                 N  \nATOM   1153  O   VAL B  11      22.897 -14.459   0.365  1.00                 O  \nATOM   1154  C   THR B  12      25.426 -16.630   0.248  1.00                 C  \nATOM   1155  CA  THR B  12      23.986 -17.168   0.005  1.00                 C  \nATOM   1156  CB  THR B  12      23.781 -18.393  -0.922  1.00                 C  \nATOM   1157  CG2 THR B  12      24.900 -19.373  -1.232  1.00                 C  \nATOM   1158  N   THR B  12      23.231 -16.263  -0.894  1.00                 N  \nATOM   1159  O   THR B  12      25.977 -16.456   1.365  1.00                 O  \nATOM   1160  OG1 THR B  12      22.570 -19.081  -0.558  1.00                 O  \nATOM   1161  C   ALA B  13      27.430 -14.271  -0.181  1.00                 C  \nATOM   1162  CA  ALA B  13      27.344 -15.659  -0.854  1.00                 C  \nATOM   1163  CB  ALA B  13      27.699 -15.603  -2.321  1.00                 C  \nATOM   1164  N   ALA B  13      26.033 -16.282  -0.847  1.00                 N  \nATOM   1165  O   ALA B  13      28.525 -13.914   0.270  1.00                 O  \nATOM   1166  C   LEU B  14      26.153 -12.391   2.121  1.00                 C  \nATOM   1167  CA  LEU B  14      26.357 -12.192   0.633  1.00                 C  \nATOM   1168  CB  LEU B  14      25.217 -11.228   0.270  1.00                 C  \nATOM   1169  CD1 LEU B  14      24.417  -9.034  -0.621  1.00                 C  \nATOM   1170  CD2 LEU B  14      26.877  -9.321  -0.354  1.00                 C  \nATOM   1171  CG  LEU B  14      25.559 -10.054  -0.664  1.00                 C  \nATOM   1172  N   LEU B  14      26.326 -13.492  -0.093  1.00                 N  \nATOM   1173  O   LEU B  14      26.756 -11.637   2.886  1.00                 O  \nATOM   1174  C   TRP B  15      25.721 -14.158   4.757  1.00                 C  \nATOM   1175  CA  TRP B  15      24.687 -13.625   3.767  1.00                 C  \nATOM   1176  CB  TRP B  15      23.593 -14.673   3.677  1.00                 C  \nATOM   1177  CD1 TRP B  15      22.394 -15.471   5.855  1.00                 C  \nATOM   1178  CD2 TRP B  15      21.748 -13.470   5.142  1.00                 C  \nATOM   1179  CE2 TRP B  15      21.016 -13.778   6.310  1.00                 C  \nATOM   1180  CE3 TRP B  15      21.544 -12.270   4.481  1.00                 C  \nATOM   1181  CG  TRP B  15      22.607 -14.554   4.860  1.00                 C  \nATOM   1182  CH2 TRP B  15      19.858 -11.756   6.199  1.00                 C  \nATOM   1183  CZ2 TRP B  15      20.054 -12.948   6.863  1.00                 C  \nATOM   1184  CZ3 TRP B  15      20.587 -11.421   5.046  1.00                 C  \nATOM   1185  N   TRP B  15      25.254 -13.343   2.419  1.00                 N  \nATOM   1186  NE1 TRP B  15      21.418 -15.000   6.745  1.00                 N  \nATOM   1187  O   TRP B  15      25.610 -13.923   5.983  1.00                 O  \nATOM   1188  C   GLY B  16      28.740 -14.188   5.275  1.00                 C  \nATOM   1189  CA  GLY B  16      27.906 -15.354   4.731  1.00                 C  \nATOM   1190  N   GLY B  16      26.653 -14.878   4.117  1.00                 N  \nATOM   1191  O   GLY B  16      29.242 -14.241   6.408  1.00                 O  \nATOM   1192  C   LYS B  17      28.853 -11.183   6.036  1.00                 C  \nATOM   1193  CA  LYS B  17      29.549 -11.959   4.896  1.00                 C  \nATOM   1194  CB  LYS B  17      29.799 -11.077   3.693  1.00                 C  \nATOM   1195  CD  LYS B  17      31.299 -10.511   1.851  1.00                 C  \nATOM   1196  CE  LYS B  17      32.185 -10.833   0.666  1.00                 C  \nATOM   1197  CG  LYS B  17      30.628 -11.709   2.551  1.00                 C  \nATOM   1198  N   LYS B  17      28.875 -13.170   4.457  1.00                 N  \nATOM   1199  NZ  LYS B  17      32.084  -9.695  -0.256  1.00                 N  \nATOM   1200  O   LYS B  17      29.525 -10.592   6.881  1.00                 O  \nATOM   1201  C   VAL B  18      27.003 -10.576   8.452  1.00                 C  \nATOM   1202  CA  VAL B  18      26.747 -10.374   6.977  1.00                 C  \nATOM   1203  CB  VAL B  18      25.270 -10.690   6.667  1.00                 C  \nATOM   1204  CG1 VAL B  18      24.286 -10.338   7.765  1.00                 C  \nATOM   1205  CG2 VAL B  18      24.835 -10.024   5.358  1.00                 C  \nATOM   1206  N   VAL B  18      27.552 -11.228   6.105  1.00                 N  \nATOM   1207  O   VAL B  18      26.793 -11.704   8.937  1.00                 O  \nATOM   1208  C   ASN B  19      26.158  -9.429  11.163  1.00                 C  \nATOM   1209  CA  ASN B  19      27.542  -9.285  10.542  1.00                 C  \nATOM   1210  CB  ASN B  19      28.152  -7.919  10.934  1.00                 C  \nATOM   1211  CG  ASN B  19      28.545  -7.834  12.423  1.00                 C  \nATOM   1212  N   ASN B  19      27.382  -9.421   9.067  1.00                 N  \nATOM   1213  ND2 ASN B  19      29.576  -7.019  12.687  1.00                 N  \nATOM   1214  O   ASN B  19      25.407  -8.459  11.198  1.00                 O  \nATOM   1215  OD1 ASN B  19      27.957  -8.482  13.304  1.00                 O  \nATOM   1216  C   VAL B  20      24.326 -10.303  13.579  1.00                 C  \nATOM   1217  CA  VAL B  20      24.498 -10.878  12.170  1.00                 C  \nATOM   1218  CB  VAL B  20      24.170 -12.379  12.085  1.00                 C  \nATOM   1219  CG1 VAL B  20      25.415 -13.270  12.195  1.00                 C  \nATOM   1220  CG2 VAL B  20      23.023 -12.866  12.991  1.00                 C  \nATOM   1221  N   VAL B  20      25.838 -10.620  11.619  1.00                 N  \nATOM   1222  O   VAL B  20      23.185 -10.146  14.031  1.00                 O  \nATOM   1223  C   ASP B  21      24.648  -7.822  15.260  1.00                 C  \nATOM   1224  CA  ASP B  21      25.060  -9.279  15.552  1.00                 C  \nATOM   1225  CB  ASP B  21      26.251  -9.282  16.526  1.00                 C  \nATOM   1226  CG  ASP B  21      26.296 -10.359  17.626  1.00                 C  \nATOM   1227  N   ASP B  21      25.376  -9.949  14.270  1.00                 N  \nATOM   1228  O   ASP B  21      23.792  -7.222  15.922  1.00                 O  \nATOM   1229  OD1 ASP B  21      25.354 -10.557  18.415  1.00                 O  \nATOM   1230  OD2 ASP B  21      27.375 -10.938  17.757  1.00                 O  \nATOM   1231  C   GLU B  22      24.158  -5.482  12.896  1.00                 C  \nATOM   1232  CA  GLU B  22      25.011  -5.817  14.139  1.00                 C  \nATOM   1233  CB  GLU B  22      26.373  -5.028  14.237  1.00                 C  \nATOM   1234  CD  GLU B  22      27.777  -4.609  16.529  1.00                 C  \nATOM   1235  CG  GLU B  22      27.337  -5.524  15.348  1.00                 C  \nATOM   1236  N   GLU B  22      25.227  -7.250  14.241  1.00                 N  \nATOM   1237  O   GLU B  22      23.853  -4.307  12.685  1.00                 O  \nATOM   1238  OE1 GLU B  22      28.308  -5.214  17.480  1.00                 O  \nATOM   1239  OE2 GLU B  22      27.651  -3.359  16.520  1.00                 O  \nATOM   1240  C   VAL B  23      21.492  -5.900  11.130  1.00                 C  \nATOM   1241  CA  VAL B  23      22.988  -5.962  10.836  1.00                 C  \nATOM   1242  CB  VAL B  23      23.283  -6.762   9.522  1.00                 C  \nATOM   1243  CG1 VAL B  23      22.306  -6.538   8.376  1.00                 C  \nATOM   1244  CG2 VAL B  23      24.637  -6.418   8.972  1.00                 C  \nATOM   1245  N   VAL B  23      23.710  -6.437  12.058  1.00                 N  \nATOM   1246  O   VAL B  23      20.807  -4.995  10.630  1.00                 O  \nATOM   1247  C   GLY B  24      19.067  -5.767  12.997  1.00                 C  \nATOM   1248  CA  GLY B  24      19.613  -6.994  12.276  1.00                 C  \nATOM   1249  N   GLY B  24      21.051  -6.853  11.933  1.00                 N  \nATOM   1250  O   GLY B  24      17.891  -5.401  12.842  1.00                 O  \nATOM   1251  C   GLY B  25      19.727  -2.766  13.855  1.00                 C  \nATOM   1252  CA  GLY B  25      19.658  -4.077  14.618  1.00                 C  \nATOM   1253  N   GLY B  25      19.976  -5.187  13.755  1.00                 N  \nATOM   1254  O   GLY B  25      19.043  -1.797  14.226  1.00                 O  \nATOM   1255  C   GLU B  26      19.313  -1.569  11.152  1.00                 C  \nATOM   1256  CA  GLU B  26      20.619  -1.552  11.983  1.00                 C  \nATOM   1257  CB  GLU B  26      21.909  -1.608  11.180  1.00                 C  \nATOM   1258  CD  GLU B  26      22.599   0.597  10.158  1.00                 C  \nATOM   1259  CG  GLU B  26      22.863  -0.434  11.259  1.00                 C  \nATOM   1260  N   GLU B  26      20.589  -2.738  12.839  1.00                 N  \nATOM   1261  O   GLU B  26      18.688  -0.540  10.839  1.00                 O  \nATOM   1262  OE1 GLU B  26      22.587   1.758  10.529  1.00                 O  \nATOM   1263  OE2 GLU B  26      22.493   0.301   8.958  1.00                 O  \nATOM   1264  C   ALA B  27      16.308  -2.456  10.995  1.00                 C  \nATOM   1265  CA  ALA B  27      17.563  -2.653  10.145  1.00                 C  \nATOM   1266  CB  ALA B  27      17.452  -3.768   9.166  1.00                 C  \nATOM   1267  N   ALA B  27      18.835  -2.721  10.852  1.00                 N  \nATOM   1268  O   ALA B  27      15.406  -1.722  10.564  1.00                 O  \nATOM   1269  C   LEU B  28      15.114  -1.262  13.516  1.00                 C  \nATOM   1270  CA  LEU B  28      15.071  -2.712  13.096  1.00                 C  \nATOM   1271  CB  LEU B  28      15.174  -3.497  14.403  1.00                 C  \nATOM   1272  CD1 LEU B  28      13.539  -3.326  16.327  1.00                 C  \nATOM   1273  CD2 LEU B  28      12.641  -3.841  14.004  1.00                 C  \nATOM   1274  CG  LEU B  28      13.831  -3.971  14.983  1.00                 C  \nATOM   1275  N   LEU B  28      16.212  -3.043  12.171  1.00                 N  \nATOM   1276  O   LEU B  28      14.096  -0.661  13.779  1.00                 O  \nATOM   1277  C   GLY B  29      15.940   1.537  12.980  1.00                 C  \nATOM   1278  CA  GLY B  29      16.406   0.597  14.089  1.00                 C  \nATOM   1279  N   GLY B  29      16.297  -0.757  13.627  1.00                 N  \nATOM   1280  O   GLY B  29      15.236   2.516  13.235  1.00                 O  \nATOM   1281  C   ARG B  30      14.611   2.181  10.424  1.00                 C  \nATOM   1282  CA  ARG B  30      16.104   2.120  10.657  1.00                 C  \nATOM   1283  CB  ARG B  30      16.831   1.616   9.416  1.00                 C  \nATOM   1284  CD  ARG B  30      19.170   1.675   8.399  1.00                 C  \nATOM   1285  CG  ARG B  30      18.148   2.357   9.288  1.00                 C  \nATOM   1286  CZ  ARG B  30      20.888   3.374   7.868  1.00                 C  \nATOM   1287  N   ARG B  30      16.395   1.242  11.790  1.00                 N  \nATOM   1288  NE  ARG B  30      20.489   2.322   8.557  1.00                 N  \nATOM   1289  NH1 ARG B  30      20.060   4.086   7.090  1.00                 N  \nATOM   1290  NH2 ARG B  30      22.150   3.737   8.010  1.00                 N  \nATOM   1291  O   ARG B  30      14.103   3.211   9.977  1.00                 O  \nATOM   1292  C   LEU B  31      11.878   1.919  11.583  1.00                 C  \nATOM   1293  CA  LEU B  31      12.536   0.990  10.604  1.00                 C  \nATOM   1294  CB  LEU B  31      12.083  -0.384  11.049  1.00                 C  \nATOM   1295  CD1 LEU B  31      10.456  -1.024   9.206  1.00                 C  \nATOM   1296  CD2 LEU B  31      10.239  -1.965  11.565  1.00                 C  \nATOM   1297  CG  LEU B  31      10.638  -0.736  10.730  1.00                 C  \nATOM   1298  N   LEU B  31      13.976   1.075  10.750  1.00                 N  \nATOM   1299  O   LEU B  31      10.826   2.474  11.261  1.00                 O  \nATOM   1300  C   LEU B  32      11.874   4.140  13.531  1.00                 C  \nATOM   1301  CA  LEU B  32      11.691   2.684  13.797  1.00                 C  \nATOM   1302  CB  LEU B  32      12.072   2.362  15.259  1.00                 C  \nATOM   1303  CD1 LEU B  32      12.968   0.597  16.872  1.00                 C  \nATOM   1304  CD2 LEU B  32      10.925   0.042  15.359  1.00                 C  \nATOM   1305  CG  LEU B  32      12.227   0.862  15.544  1.00                 C  \nATOM   1306  N   LEU B  32      12.502   2.033  12.765  1.00                 N  \nATOM   1307  O   LEU B  32      11.091   4.969  13.974  1.00                 O  \nATOM   1308  C   VAL B  33      12.567   6.231  11.383  1.00                 C  \nATOM   1309  CA  VAL B  33      13.278   5.810  12.650  1.00                 C  \nATOM   1310  CB  VAL B  33      14.822   6.064  12.598  1.00                 C  \nATOM   1311  CG1 VAL B  33      15.249   7.263  11.776  1.00                 C  \nATOM   1312  CG2 VAL B  33      15.508   6.109  13.970  1.00                 C  \nATOM   1313  N   VAL B  33      12.946   4.402  12.832  1.00                 N  \nATOM   1314  O   VAL B  33      12.063   7.359  11.286  1.00                 O  \nATOM   1315  C   VAL B  34      10.548   5.816   9.129  1.00                 C  \nATOM   1316  CA  VAL B  34      12.088   5.799   9.135  1.00                 C  \nATOM   1317  CB  VAL B  34      12.747   4.954   8.038  1.00                 C  \nATOM   1318  CG1 VAL B  34      12.133   5.117   6.659  1.00                 C  \nATOM   1319  CG2 VAL B  34      14.211   5.319   7.929  1.00                 C  \nATOM   1320  N   VAL B  34      12.536   5.312  10.432  1.00                 N  \nATOM   1321  O   VAL B  34       9.897   6.707   8.570  1.00                 O  \nATOM   1322  C   TYR B  35       8.195   4.600  11.389  1.00                 C  \nATOM   1323  CA  TYR B  35       8.597   4.581   9.902  1.00                 C  \nATOM   1324  CB  TYR B  35       8.274   3.205   9.287  1.00                 C  \nATOM   1325  CD1 TYR B  35       8.386   3.866   6.878  1.00                 C  \nATOM   1326  CD2 TYR B  35       9.808   2.109   7.621  1.00                 C  \nATOM   1327  CE1 TYR B  35       8.913   3.760   5.604  1.00                 C  \nATOM   1328  CE2 TYR B  35      10.344   1.987   6.356  1.00                 C  \nATOM   1329  CG  TYR B  35       8.848   3.049   7.882  1.00                 C  \nATOM   1330  CZ  TYR B  35       9.905   2.815   5.347  1.00                 C  \nATOM   1331  N   TYR B  35      10.022   4.818   9.818  1.00                 N  \nATOM   1332  O   TYR B  35       8.101   3.507  11.973  1.00                 O  \nATOM   1333  OH  TYR B  35      10.464   2.740   4.093  1.00                 O  \nATOM   1334  C   PRO B  36       6.622   5.334  13.961  1.00                 C  \nATOM   1335  CA  PRO B  36       7.834   6.050  13.357  1.00                 C  \nATOM   1336  CB  PRO B  36       7.708   7.548  13.526  1.00                 C  \nATOM   1337  CD  PRO B  36       7.824   7.106  11.219  1.00                 C  \nATOM   1338  CG  PRO B  36       8.254   8.128  12.247  1.00                 C  \nATOM   1339  N   PRO B  36       7.917   5.805  11.931  1.00                 N  \nATOM   1340  O   PRO B  36       6.650   4.995  15.146  1.00                 O  \nATOM   1341  C   TRP B  37       4.871   3.211  14.398  1.00                 C  \nATOM   1342  CA  TRP B  37       4.459   4.508  13.774  1.00                 C  \nATOM   1343  CB  TRP B  37       3.255   4.312  12.884  1.00                 C  \nATOM   1344  CD1 TRP B  37       3.523   2.186  11.389  1.00                 C  \nATOM   1345  CD2 TRP B  37       4.030   4.144  10.427  1.00                 C  \nATOM   1346  CE2 TRP B  37       4.235   3.132   9.500  1.00                 C  \nATOM   1347  CE3 TRP B  37       4.265   5.468  10.122  1.00                 C  \nATOM   1348  CG  TRP B  37       3.590   3.541  11.611  1.00                 C  \nATOM   1349  CH2 TRP B  37       4.965   4.697   7.902  1.00                 C  \nATOM   1350  CZ2 TRP B  37       4.719   3.366   8.214  1.00                 C  \nATOM   1351  CZ3 TRP B  37       4.740   5.719   8.841  1.00                 C  \nATOM   1352  N   TRP B  37       5.606   5.094  13.148  1.00                 N  \nATOM   1353  NE1 TRP B  37       3.920   1.941  10.100  1.00                 N  \nATOM   1354  O   TRP B  37       4.379   2.917  15.478  1.00                 O  \nATOM   1355  C   THR B  38       6.744   1.214  15.593  1.00                 C  \nATOM   1356  CA  THR B  38       6.163   1.209  14.188  1.00                 C  \nATOM   1357  CB  THR B  38       7.169   0.515  13.260  1.00                 C  \nATOM   1358  CG2 THR B  38       6.620   0.280  11.861  1.00                 C  \nATOM   1359  N   THR B  38       5.818   2.567  13.765  1.00                 N  \nATOM   1360  O   THR B  38       6.764   0.149  16.223  1.00                 O  \nATOM   1361  OG1 THR B  38       8.459   1.128  13.245  1.00                 O  \nATOM   1362  C   GLN B  39       6.544   2.204  18.428  1.00                 C  \nATOM   1363  CA  GLN B  39       7.708   2.392  17.435  1.00                 C  \nATOM   1364  CB  GLN B  39       8.410   3.659  17.867  1.00                 C  \nATOM   1365  CD  GLN B  39       9.958   5.446  17.370  1.00                 C  \nATOM   1366  CG  GLN B  39       9.781   3.930  17.268  1.00                 C  \nATOM   1367  N   GLN B  39       7.216   2.387  16.040  1.00                 N  \nATOM   1368  NE2 GLN B  39      10.641   6.021  16.382  1.00                 N  \nATOM   1369  O   GLN B  39       6.889   1.955  19.580  1.00                 O  \nATOM   1370  OE1 GLN B  39       9.454   6.064  18.322  1.00                 O  \nATOM   1371  C   ARG B  40       4.416   0.509  19.470  1.00                 C  \nATOM   1372  CA  ARG B  40       4.060   1.827  18.783  1.00                 C  \nATOM   1373  CB  ARG B  40       2.846   1.447  17.862  1.00                 C  \nATOM   1374  CD  ARG B  40       0.290   0.957  18.122  1.00                 C  \nATOM   1375  CG  ARG B  40       1.460   1.879  18.374  1.00                 C  \nATOM   1376  CZ  ARG B  40      -1.308   1.094  20.146  1.00                 C  \nATOM   1377  N   ARG B  40       5.242   2.348  18.018  1.00                 N  \nATOM   1378  NE  ARG B  40      -0.850   1.517  18.933  1.00                 N  \nATOM   1379  NH1 ARG B  40      -0.723   0.120  20.867  1.00                 N  \nATOM   1380  NH2 ARG B  40      -2.367   1.691  20.689  1.00                 N  \nATOM   1381  O   ARG B  40       3.907   0.208  20.550  1.00                 O  \nATOM   1382  C   PHE B  41       6.457  -1.979  20.154  1.00                 C  \nATOM   1383  CA  PHE B  41       5.338  -1.692  19.166  1.00                 C  \nATOM   1384  CB  PHE B  41       5.564  -2.467  17.863  1.00                 C  \nATOM   1385  CD1 PHE B  41       4.149  -1.721  15.904  1.00                 C  \nATOM   1386  CD2 PHE B  41       3.320  -3.476  17.245  1.00                 C  \nATOM   1387  CE1 PHE B  41       3.029  -1.791  15.108  1.00                 C  \nATOM   1388  CE2 PHE B  41       2.182  -3.548  16.452  1.00                 C  \nATOM   1389  CG  PHE B  41       4.303  -2.560  16.975  1.00                 C  \nATOM   1390  CZ  PHE B  41       2.036  -2.705  15.380  1.00                 C  \nATOM   1391  N   PHE B  41       5.248  -0.279  18.814  1.00                 N  \nATOM   1392  O   PHE B  41       6.557  -3.123  20.597  1.00                 O  \nATOM   1393  C   PHE B  42       8.571   0.059  22.326  1.00                 C  \nATOM   1394  CA  PHE B  42       8.485  -1.080  21.286  1.00                 C  \nATOM   1395  CB  PHE B  42       9.701  -0.995  20.352  1.00                 C  \nATOM   1396  CD1 PHE B  42       9.318  -1.718  17.943  1.00                 C  \nATOM   1397  CD2 PHE B  42      10.115  -3.348  19.501  1.00                 C  \nATOM   1398  CE1 PHE B  42       9.321  -2.671  16.945  1.00                 C  \nATOM   1399  CE2 PHE B  42      10.133  -4.313  18.503  1.00                 C  \nATOM   1400  CG  PHE B  42       9.710  -2.052  19.229  1.00                 C  \nATOM   1401  CZ  PHE B  42       9.743  -3.968  17.211  1.00                 C  \nATOM   1402  N   PHE B  42       7.273  -0.964  20.442  1.00                 N  \nATOM   1403  O   PHE B  42       9.646   0.619  22.595  1.00                 O  \nATOM   1404  C   GLU B  43       8.024   0.794  25.232  1.00                 C  \nATOM   1405  CA  GLU B  43       7.325   1.368  23.986  1.00                 C  \nATOM   1406  CB  GLU B  43       5.819   1.585  24.256  1.00                 C  \nATOM   1407  CD  GLU B  43       3.837   2.931  23.284  1.00                 C  \nATOM   1408  CG  GLU B  43       5.153   2.181  23.015  1.00                 C  \nATOM   1409  N   GLU B  43       7.429   0.395  22.880  1.00                 N  \nATOM   1410  O   GLU B  43       8.526   1.527  26.081  1.00                 O  \nATOM   1411  OE1 GLU B  43       3.426   3.051  24.449  1.00                 O  \nATOM   1412  OE2 GLU B  43       3.226   3.386  22.303  1.00                 O  \nATOM   1413  C   SER B  44      10.175  -1.310  26.287  1.00                 C  \nATOM   1414  CA  SER B  44       8.641  -1.381  26.334  1.00                 C  \nATOM   1415  CB  SER B  44       8.218  -2.839  26.103  1.00                 C  \nATOM   1416  N   SER B  44       8.036  -0.540  25.282  1.00                 N  \nATOM   1417  O   SER B  44      10.876  -1.829  27.170  1.00                 O  \nATOM   1418  OG  SER B  44       9.024  -3.534  25.132  1.00                 O  \nATOM   1419  C   PHE B  45      12.947   0.414  25.361  1.00                 C  \nATOM   1420  CA  PHE B  45      12.128  -0.788  24.937  1.00                 C  \nATOM   1421  CB  PHE B  45      12.354  -0.767  23.444  1.00                 C  \nATOM   1422  CD1 PHE B  45      13.158  -2.307  21.707  1.00                 C  \nATOM   1423  CD2 PHE B  45      11.813  -3.223  23.446  1.00                 C  \nATOM   1424  CE1 PHE B  45      13.268  -3.539  21.136  1.00                 C  \nATOM   1425  CE2 PHE B  45      11.922  -4.465  22.871  1.00                 C  \nATOM   1426  CG  PHE B  45      12.437  -2.155  22.853  1.00                 C  \nATOM   1427  CZ  PHE B  45      12.652  -4.611  21.720  1.00                 C  \nATOM   1428  N   PHE B  45      10.674  -0.683  25.252  1.00                 N  \nATOM   1429  O   PHE B  45      14.171   0.342  25.213  1.00                 O  \nATOM   1430  C   GLY B  46      13.120   3.809  25.377  1.00                 C  \nATOM   1431  CA  GLY B  46      13.185   2.575  26.260  1.00                 C  \nATOM   1432  N   GLY B  46      12.304   1.494  25.796  1.00                 N  \nATOM   1433  O   GLY B  46      12.227   3.977  24.549  1.00                 O  \nATOM   1434  C   ASP B  47      14.268   5.604  23.425  1.00                 C  \nATOM   1435  CA  ASP B  47      14.040   5.907  24.880  1.00                 C  \nATOM   1436  CB  ASP B  47      15.189   6.797  25.370  1.00                 C  \nATOM   1437  CG  ASP B  47      15.270   8.172  24.701  1.00                 C  \nATOM   1438  N   ASP B  47      14.094   4.654  25.593  1.00                 N  \nATOM   1439  O   ASP B  47      15.297   5.022  23.090  1.00                 O  \nATOM   1440  OD1 ASP B  47      16.416   8.604  24.593  1.00                 O  \nATOM   1441  OD2 ASP B  47      14.270   8.813  24.346  1.00                 O  \nATOM   1442  C   LEU B  48      13.106   7.447  20.638  1.00                 C  \nATOM   1443  CA  LEU B  48      13.459   6.028  21.140  1.00                 C  \nATOM   1444  CB  LEU B  48      12.478   5.044  20.466  1.00                 C  \nATOM   1445  CD1 LEU B  48      11.187   2.847  20.514  1.00                 C  \nATOM   1446  CD2 LEU B  48      13.671   2.890  21.006  1.00                 C  \nATOM   1447  CG  LEU B  48      12.359   3.655  21.107  1.00                 C  \nATOM   1448  N   LEU B  48      13.298   5.981  22.631  1.00                 N  \nATOM   1449  O   LEU B  48      12.487   7.575  19.577  1.00                 O  \nATOM   1450  C   SER B  49      13.633  10.453  19.978  1.00                 C  \nATOM   1451  CA  SER B  49      12.720   9.728  20.947  1.00                 C  \nATOM   1452  CB  SER B  49      12.276  10.610  22.136  1.00                 C  \nATOM   1453  N   SER B  49      13.446   8.525  21.355  1.00                 N  \nATOM   1454  O   SER B  49      13.268  11.422  19.329  1.00                 O  \nATOM   1455  OG  SER B  49      11.272  11.569  21.727  1.00                 O  \nATOM   1456  C   THR B  50      16.414   9.270  18.336  1.00                 C  \nATOM   1457  CA  THR B  50      15.749  10.516  18.958  1.00                 C  \nATOM   1458  CB  THR B  50      16.819  11.426  19.676  1.00                 C  \nATOM   1459  CG2 THR B  50      16.349  11.930  21.057  1.00                 C  \nATOM   1460  N   THR B  50      14.797   9.966  19.900  1.00                 N  \nATOM   1461  O   THR B  50      16.563   8.213  18.952  1.00                 O  \nATOM   1462  OG1 THR B  50      18.157  10.809  19.835  1.00                 O  \nATOM   1463  C   PRO B  51      18.610   7.817  16.869  1.00                 C  \nATOM   1464  CA  PRO B  51      17.245   8.235  16.365  1.00                 C  \nATOM   1465  CB  PRO B  51      17.339   8.742  14.915  1.00                 C  \nATOM   1466  CD  PRO B  51      16.446  10.528  16.231  1.00                 C  \nATOM   1467  CG  PRO B  51      17.275  10.261  14.993  1.00                 C  \nATOM   1468  N   PRO B  51      16.757   9.367  17.101  1.00                 N  \nATOM   1469  O   PRO B  51      19.047   6.711  16.512  1.00                 O  \nATOM   1470  C   ASP B  52      20.316   7.366  19.285  1.00                 C  \nATOM   1471  CA  ASP B  52      20.564   8.322  18.150  1.00                 C  \nATOM   1472  CB  ASP B  52      21.379   9.500  18.645  1.00                 C  \nATOM   1473  CG  ASP B  52      21.834  10.393  17.490  1.00                 C  \nATOM   1474  N   ASP B  52      19.260   8.718  17.617  1.00                 N  \nATOM   1475  O   ASP B  52      20.984   6.351  19.455  1.00                 O  \nATOM   1476  OD1 ASP B  52      22.507   9.886  16.598  1.00                 O  \nATOM   1477  OD2 ASP B  52      21.563  11.598  17.504  1.00                 O  \nATOM   1478  C   ALA B  53      18.169   5.613  20.531  1.00                 C  \nATOM   1479  CA  ALA B  53      18.790   6.903  21.072  1.00                 C  \nATOM   1480  CB  ALA B  53      17.709   7.710  21.805  1.00                 C  \nATOM   1481  N   ALA B  53      19.314   7.753  20.010  1.00                 N  \nATOM   1482  O   ALA B  53      17.886   4.675  21.314  1.00                 O  \nATOM   1483  C   VAL B  54      18.510   3.420  18.267  1.00                 C  \nATOM   1484  CA  VAL B  54      17.326   4.312  18.700  1.00                 C  \nATOM   1485  CB  VAL B  54      16.274   4.558  17.559  1.00                 C  \nATOM   1486  CG1 VAL B  54      15.780   3.284  16.906  1.00                 C  \nATOM   1487  CG2 VAL B  54      14.997   5.266  17.999  1.00                 C  \nATOM   1488  N   VAL B  54      17.878   5.578  19.249  1.00                 N  \nATOM   1489  O   VAL B  54      18.477   2.174  18.343  1.00                 O  \nATOM   1490  C   MET B  55      21.622   2.713  18.087  1.00                 C  \nATOM   1491  CA  MET B  55      20.546   3.246  17.172  1.00                 C  \nATOM   1492  CB  MET B  55      21.107   3.991  15.999  1.00                 C  \nATOM   1493  CE  MET B  55      18.177   3.809  13.167  1.00                 C  \nATOM   1494  CG  MET B  55      20.001   4.231  14.950  1.00                 C  \nATOM   1495  N   MET B  55      19.579   4.073  17.850  1.00                 N  \nATOM   1496  O   MET B  55      22.370   1.857  17.622  1.00                 O  \nATOM   1497  SD  MET B  55      19.405   2.791  13.976  1.00                 S  \nATOM   1498  C   GLY B  56      21.594   2.212  21.599  1.00                 C  \nATOM   1499  CA  GLY B  56      22.469   2.685  20.431  1.00                 C  \nATOM   1500  N   GLY B  56      21.637   3.218  19.327  1.00                 N  \nATOM   1501  O   GLY B  56      21.929   2.358  22.786  1.00                 O  \nATOM   1502  C   ASN B  57      19.794  -0.397  22.135  1.00                 C  \nATOM   1503  CA  ASN B  57      19.584   1.099  22.234  1.00                 C  \nATOM   1504  CB  ASN B  57      18.145   1.504  22.016  1.00                 C  \nATOM   1505  CG  ASN B  57      17.201   0.797  23.019  1.00                 C  \nATOM   1506  N   ASN B  57      20.428   1.683  21.233  1.00                 N  \nATOM   1507  ND2 ASN B  57      16.212   1.562  23.372  1.00                 N  \nATOM   1508  O   ASN B  57      19.832  -0.932  21.023  1.00                 O  \nATOM   1509  OD1 ASN B  57      17.291  -0.380  23.414  1.00                 O  \nATOM   1510  C   PRO B  58      19.479  -3.337  23.259  1.00                 C  \nATOM   1511  CA  PRO B  58      20.613  -2.341  23.396  1.00                 C  \nATOM   1512  CB  PRO B  58      21.286  -2.459  24.771  1.00                 C  \nATOM   1513  CD  PRO B  58      20.293  -0.299  24.560  1.00                 C  \nATOM   1514  CG  PRO B  58      21.529  -1.007  25.119  1.00                 C  \nATOM   1515  N   PRO B  58      20.065  -0.988  23.283  1.00                 N  \nATOM   1516  O   PRO B  58      19.731  -4.479  22.891  1.00                 O  \nATOM   1517  C   LYS B  59      16.866  -3.904  21.936  1.00                 C  \nATOM   1518  CA  LYS B  59      17.159  -3.788  23.436  1.00                 C  \nATOM   1519  CB  LYS B  59      15.967  -3.240  24.180  1.00                 C  \nATOM   1520  CD  LYS B  59      14.928  -4.135  26.289  1.00                 C  \nATOM   1521  CE  LYS B  59      14.881  -4.199  27.820  1.00                 C  \nATOM   1522  CG  LYS B  59      16.087  -3.300  25.699  1.00                 C  \nATOM   1523  N   LYS B  59      18.286  -2.877  23.577  1.00                 N  \nATOM   1524  NZ  LYS B  59      14.450  -2.901  28.373  1.00                 N  \nATOM   1525  O   LYS B  59      16.500  -4.992  21.455  1.00                 O  \nATOM   1526  C   VAL B  60      17.801  -3.456  18.991  1.00                 C  \nATOM   1527  CA  VAL B  60      16.847  -2.574  19.819  1.00                 C  \nATOM   1528  CB  VAL B  60      16.874  -1.084  19.420  1.00                 C  \nATOM   1529  CG1 VAL B  60      17.004  -0.852  17.906  1.00                 C  \nATOM   1530  CG2 VAL B  60      15.657  -0.341  19.946  1.00                 C  \nATOM   1531  N   VAL B  60      17.105  -2.752  21.268  1.00                 N  \nATOM   1532  O   VAL B  60      17.360  -4.148  18.060  1.00                 O  \nATOM   1533  C   LYS B  61      19.936  -5.784  19.238  1.00                 C  \nATOM   1534  CA  LYS B  61      20.095  -4.342  18.761  1.00                 C  \nATOM   1535  CB  LYS B  61      21.501  -3.839  19.142  1.00                 C  \nATOM   1536  CD  LYS B  61      23.065  -3.776  21.259  1.00                 C  \nATOM   1537  CE  LYS B  61      23.080  -4.529  22.605  1.00                 C  \nATOM   1538  CG  LYS B  61      21.656  -3.790  20.668  1.00                 C  \nATOM   1539  N   LYS B  61      19.072  -3.463  19.393  1.00                 N  \nATOM   1540  NZ  LYS B  61      24.395  -4.320  23.261  1.00                 N  \nATOM   1541  O   LYS B  61      20.375  -6.728  18.591  1.00                 O  \nATOM   1542  C   ALA B  62      17.953  -7.975  20.300  1.00                 C  \nATOM   1543  CA  ALA B  62      19.033  -7.232  21.072  1.00                 C  \nATOM   1544  CB  ALA B  62      18.495  -7.005  22.495  1.00                 C  \nATOM   1545  N   ALA B  62      19.298  -5.933  20.412  1.00                 N  \nATOM   1546  O   ALA B  62      17.922  -9.213  20.211  1.00                 O  \nATOM   1547  C   HIS B  63      16.188  -8.048  17.746  1.00                 C  \nATOM   1548  CA  HIS B  63      15.940  -7.723  19.212  1.00                 C  \nATOM   1549  CB  HIS B  63      14.789  -6.773  19.412  1.00                 C  \nATOM   1550  CD2 HIS B  63      12.669  -7.145  17.908  1.00                 C  \nATOM   1551  CE1 HIS B  63      11.885  -9.034  18.890  1.00                 C  \nATOM   1552  CG  HIS B  63      13.513  -7.479  18.940  1.00                 C  \nATOM   1553  N   HIS B  63      17.095  -7.126  19.764  1.00                 N  \nATOM   1554  ND1 HIS B  63      13.051  -8.658  19.554  1.00                 N  \nATOM   1555  NE2 HIS B  63      11.668  -8.078  17.869  1.00                 N  \nATOM   1556  O   HIS B  63      15.701  -9.064  17.200  1.00                 O  \nATOM   1557  C   GLY B  64      18.080  -8.379  15.275  1.00                 C  \nATOM   1558  CA  GLY B  64      17.258  -7.171  15.719  1.00                 C  \nATOM   1559  N   GLY B  64      16.967  -7.138  17.191  1.00                 N  \nATOM   1560  O   GLY B  64      18.115  -8.742  14.087  1.00                 O  \nATOM   1561  C   LYS B  65      18.555 -11.385  15.861  1.00                 C  \nATOM   1562  CA  LYS B  65      19.485 -10.177  15.873  1.00                 C  \nATOM   1563  CB  LYS B  65      20.605 -10.354  16.885  1.00                 C  \nATOM   1564  CD  LYS B  65      22.776 -11.624  17.047  1.00                 C  \nATOM   1565  CE  LYS B  65      23.247 -12.991  17.522  1.00                 C  \nATOM   1566  CG  LYS B  65      21.310 -11.684  16.665  1.00                 C  \nATOM   1567  N   LYS B  65      18.736  -8.981  16.237  1.00                 N  \nATOM   1568  NZ  LYS B  65      22.547 -13.282  18.783  1.00                 N  \nATOM   1569  O   LYS B  65      18.770 -12.357  15.105  1.00                 O  \nATOM   1570  C   LYS B  66      15.890 -12.242  15.373  1.00                 C  \nATOM   1571  CA  LYS B  66      16.482 -12.276  16.763  1.00                 C  \nATOM   1572  CB  LYS B  66      15.413 -12.026  17.853  1.00                 C  \nATOM   1573  CD  LYS B  66      17.199 -13.036  19.436  1.00                 C  \nATOM   1574  CE  LYS B  66      17.280 -14.492  18.898  1.00                 C  \nATOM   1575  CG  LYS B  66      15.812 -12.374  19.307  1.00                 C  \nATOM   1576  N   LYS B  66      17.534 -11.263  16.734  1.00                 N  \nATOM   1577  NZ  LYS B  66      18.647 -14.836  18.391  1.00                 N  \nATOM   1578  O   LYS B  66      15.684 -13.284  14.740  1.00                 O  \nATOM   1579  C   VAL B  67      15.979 -11.323  12.509  1.00                 C  \nATOM   1580  CA  VAL B  67      15.043 -10.878  13.630  1.00                 C  \nATOM   1581  CB  VAL B  67      14.459  -9.472  13.492  1.00                 C  \nATOM   1582  CG1 VAL B  67      13.549  -9.229  12.292  1.00                 C  \nATOM   1583  CG2 VAL B  67      13.622  -9.255  14.744  1.00                 C  \nATOM   1584  N   VAL B  67      15.702 -11.008  14.928  1.00                 N  \nATOM   1585  O   VAL B  67      15.469 -11.775  11.473  1.00                 O  \nATOM   1586  C   LEU B  68      18.045 -13.222  11.467  1.00                 C  \nATOM   1587  CA  LEU B  68      17.999 -11.721  11.435  1.00                 C  \nATOM   1588  CB  LEU B  68      19.493 -11.385  11.362  1.00                 C  \nATOM   1589  CD1 LEU B  68      21.366  -9.862  10.797  1.00                 C  \nATOM   1590  CD2 LEU B  68      19.105  -9.515   9.726  1.00                 C  \nATOM   1591  CG  LEU B  68      19.842  -9.977  10.984  1.00                 C  \nATOM   1592  N   LEU B  68      17.279 -11.270  12.659  1.00                 N  \nATOM   1593  O   LEU B  68      18.295 -13.812  10.417  1.00                 O  \nATOM   1594  C   GLY B  69      16.933 -15.766  12.097  1.00                 C  \nATOM   1595  CA  GLY B  69      17.879 -15.093  13.066  1.00                 C  \nATOM   1596  N   GLY B  69      17.885 -13.677  12.708  1.00                 N  \nATOM   1597  O   GLY B  69      17.364 -16.523  11.207  1.00                 O  \nATOM   1598  C   ALA B  70      14.667 -15.771  10.035  1.00                 C  \nATOM   1599  CA  ALA B  70      14.474 -15.877  11.542  1.00                 C  \nATOM   1600  CB  ALA B  70      13.201 -15.156  12.006  1.00                 C  \nATOM   1601  N   ALA B  70      15.662 -15.357  12.269  1.00                 N  \nATOM   1602  O   ALA B  70      14.074 -16.566   9.322  1.00                 O  \nATOM   1603  C   PHE B  71      16.663 -15.648   7.640  1.00                 C  \nATOM   1604  CA  PHE B  71      15.719 -14.583   8.170  1.00                 C  \nATOM   1605  CB  PHE B  71      16.292 -13.186   7.903  1.00                 C  \nATOM   1606  CD1 PHE B  71      14.603 -11.312   8.255  1.00                 C  \nATOM   1607  CD2 PHE B  71      14.890 -12.171   6.076  1.00                 C  \nATOM   1608  CE1 PHE B  71      13.650 -10.426   7.787  1.00                 C  \nATOM   1609  CE2 PHE B  71      13.941 -11.297   5.600  1.00                 C  \nATOM   1610  CG  PHE B  71      15.226 -12.185   7.402  1.00                 C  \nATOM   1611  CZ  PHE B  71      13.323 -10.422   6.447  1.00                 C  \nATOM   1612  N   PHE B  71      15.488 -14.805   9.589  1.00                 N  \nATOM   1613  O   PHE B  71      16.513 -16.063   6.486  1.00                 O  \nATOM   1614  C   SER B  72      17.939 -18.331   8.156  1.00                 C  \nATOM   1615  CA  SER B  72      18.676 -16.994   8.237  1.00                 C  \nATOM   1616  CB  SER B  72      19.743 -17.082   9.372  1.00                 C  \nATOM   1617  N   SER B  72      17.622 -15.997   8.505  1.00                 N  \nATOM   1618  O   SER B  72      18.224 -19.185   7.300  1.00                 O  \nATOM   1619  OG  SER B  72      20.301 -15.855   9.835  1.00                 O  \nATOM   1620  C   ASP B  73      15.310 -19.589   7.692  1.00                 C  \nATOM   1621  CA  ASP B  73      16.070 -19.581   9.011  1.00                 C  \nATOM   1622  CB  ASP B  73      14.985 -19.412  10.043  1.00                 C  \nATOM   1623  CG  ASP B  73      15.099 -20.456  11.128  1.00                 C  \nATOM   1624  N   ASP B  73      16.997 -18.453   9.082  1.00                 N  \nATOM   1625  O   ASP B  73      15.203 -20.632   7.047  1.00                 O  \nATOM   1626  OD1 ASP B  73      14.288 -21.408  11.055  1.00                 O  \nATOM   1627  OD2 ASP B  73      15.979 -20.260  11.999  1.00                 O  \nATOM   1628  C   GLY B  74      14.798 -18.737   4.835  1.00                 C  \nATOM   1629  CA  GLY B  74      13.950 -18.599   6.093  1.00                 C  \nATOM   1630  N   GLY B  74      14.769 -18.458   7.300  1.00                 N  \nATOM   1631  O   GLY B  74      14.423 -19.559   3.999  1.00                 O  \nATOM   1632  C   LEU B  75      17.296 -19.050   3.023  1.00                 C  \nATOM   1633  CA  LEU B  75      16.766 -17.735   3.578  1.00                 C  \nATOM   1634  CB  LEU B  75      17.949 -16.794   3.913  1.00                 C  \nATOM   1635  CD1 LEU B  75      17.725 -15.407   1.818  1.00                 C  \nATOM   1636  CD2 LEU B  75      19.847 -15.284   3.040  1.00                 C  \nATOM   1637  CG  LEU B  75      18.662 -16.202   2.685  1.00                 C  \nATOM   1638  N   LEU B  75      15.903 -17.946   4.772  1.00                 N  \nATOM   1639  O   LEU B  75      17.655 -19.137   1.836  1.00                 O  \nATOM   1640  C   ALA B  76      16.952 -22.427   4.216  1.00                 C  \nATOM   1641  CA  ALA B  76      17.848 -21.353   3.589  1.00                 C  \nATOM   1642  CB  ALA B  76      19.310 -21.519   4.021  1.00                 C  \nATOM   1643  N   ALA B  76      17.345 -20.012   3.919  1.00                 N  \nATOM   1644  O   ALA B  76      17.420 -23.303   4.959  1.00                 O  \nATOM   1645  C   HIS B  77      13.376 -22.460   3.105  1.00                 C  \nATOM   1646  CA  HIS B  77      14.450 -22.985   4.037  1.00                 C  \nATOM   1647  CB  HIS B  77      14.001 -22.657   5.445  1.00                 C  \nATOM   1648  CD2 HIS B  77      14.722 -23.726   7.742  1.00                 C  \nATOM   1649  CE1 HIS B  77      13.975 -25.854   7.361  1.00                 C  \nATOM   1650  CG  HIS B  77      14.154 -23.776   6.484  1.00                 C  \nATOM   1651  N   HIS B  77      15.691 -22.260   3.790  1.00                 N  \nATOM   1652  ND1 HIS B  77      13.689 -25.075   6.234  1.00                 N  \nATOM   1653  NE2 HIS B  77      14.614 -25.019   8.299  1.00                 N  \nATOM   1654  O   HIS B  77      12.181 -22.331   3.432  1.00                 O  \nATOM   1655  C   LEU B  78      11.816 -22.243   0.523  1.00                 C  \nATOM   1656  CA  LEU B  78      12.910 -21.351   1.050  1.00                 C  \nATOM   1657  CB  LEU B  78      13.692 -20.782  -0.131  1.00                 C  \nATOM   1658  CD1 LEU B  78      15.682 -19.314  -0.787  1.00                 C  \nATOM   1659  CD2 LEU B  78      13.695 -18.340   0.486  1.00                 C  \nATOM   1660  CG  LEU B  78      14.572 -19.580   0.248  1.00                 C  \nATOM   1661  N   LEU B  78      13.819 -22.103   1.929  1.00                 N  \nATOM   1662  O   LEU B  78      10.948 -21.768  -0.200  1.00                 O  \nATOM   1663  C   ASP B  79       9.593 -24.460   0.859  1.00                 C  \nATOM   1664  CA  ASP B  79      10.951 -24.443   0.157  1.00                 C  \nATOM   1665  CB  ASP B  79      11.579 -25.847   0.139  1.00                 C  \nATOM   1666  CG  ASP B  79      10.845 -26.782  -0.829  1.00                 C  \nATOM   1667  N   ASP B  79      11.852 -23.502   0.863  1.00                 N  \nATOM   1668  O   ASP B  79       8.526 -24.648   0.274  1.00                 O  \nATOM   1669  OD1 ASP B  79      11.233 -27.960  -0.912  1.00                 O  \nATOM   1670  OD2 ASP B  79       9.911 -26.339  -1.519  1.00                 O  \nATOM   1671  C   ASN B  80       8.792 -22.791   3.686  1.00                 C  \nATOM   1672  CA  ASN B  80       8.429 -23.983   2.843  1.00                 C  \nATOM   1673  CB  ASN B  80       7.917 -25.156   3.685  1.00                 C  \nATOM   1674  CG  ASN B  80       6.411 -25.031   4.008  1.00                 C  \nATOM   1675  N   ASN B  80       9.646 -24.277   2.130  1.00                 N  \nATOM   1676  ND2 ASN B  80       5.987 -25.838   4.973  1.00                 N  \nATOM   1677  O   ASN B  80       9.188 -22.959   4.847  1.00                 O  \nATOM   1678  OD1 ASN B  80       5.642 -24.269   3.401  1.00                 O  \nATOM   1679  C   LEU B  81       7.775 -20.280   4.828  1.00                 C  \nATOM   1680  CA  LEU B  81       8.836 -20.353   3.709  1.00                 C  \nATOM   1681  CB  LEU B  81       8.634 -19.248   2.682  1.00                 C  \nATOM   1682  CD1 LEU B  81      11.088 -18.969   3.266  1.00                 C  \nATOM   1683  CD2 LEU B  81      10.093 -17.949   1.143  1.00                 C  \nATOM   1684  CG  LEU B  81       9.846 -18.342   2.600  1.00                 C  \nATOM   1685  N   LEU B  81       8.720 -21.641   2.998  1.00                 N  \nATOM   1686  O   LEU B  81       7.970 -19.620   5.856  1.00                 O  \nATOM   1687  C   LYS B  82       5.257 -21.737   6.489  1.00                 C  \nATOM   1688  CA  LYS B  82       5.348 -20.911   5.215  1.00                 C  \nATOM   1689  CB  LYS B  82       4.284 -21.434   4.224  1.00                 C  \nATOM   1690  CD  LYS B  82       5.090 -21.246   1.679  1.00                 C  \nATOM   1691  CE  LYS B  82       4.961 -20.385   0.385  1.00                 C  \nATOM   1692  CG  LYS B  82       4.225 -20.718   2.847  1.00                 C  \nATOM   1693  N   LYS B  82       6.700 -21.046   4.602  1.00                 N  \nATOM   1694  NZ  LYS B  82       5.309 -21.203  -0.783  1.00                 N  \nATOM   1695  O   LYS B  82       4.689 -21.355   7.522  1.00                 O  \nATOM   1696  C   GLY B  83       6.891 -23.106   8.495  1.00                 C  \nATOM   1697  CA  GLY B  83       6.013 -23.795   7.469  1.00                 C  \nATOM   1698  N   GLY B  83       5.849 -22.900   6.338  1.00                 N  \nATOM   1699  O   GLY B  83       6.527 -22.989   9.676  1.00                 O  \nATOM   1700  C   THR B  84       8.471 -20.965   9.746  1.00                 C  \nATOM   1701  CA  THR B  84       9.043 -22.121   8.900  1.00                 C  \nATOM   1702  CB  THR B  84      10.320 -21.716   8.102  1.00                 C  \nATOM   1703  CG2 THR B  84      11.502 -21.300   8.963  1.00                 C  \nATOM   1704  N   THR B  84       8.016 -22.650   7.975  1.00                 N  \nATOM   1705  O   THR B  84       8.783 -20.801  10.933  1.00                 O  \nATOM   1706  OG1 THR B  84      10.783 -22.834   7.421  1.00                 O  \nATOM   1707  C   PHE B  85       5.961 -18.910  10.606  1.00                 C  \nATOM   1708  CA  PHE B  85       7.264 -18.944   9.806  1.00                 C  \nATOM   1709  CB  PHE B  85       7.242 -17.892   8.676  1.00                 C  \nATOM   1710  CD1 PHE B  85       9.347 -17.233   7.357  1.00                 C  \nATOM   1711  CD2 PHE B  85       9.087 -16.437   9.605  1.00                 C  \nATOM   1712  CE1 PHE B  85      10.572 -16.562   7.271  1.00                 C  \nATOM   1713  CE2 PHE B  85      10.307 -15.759   9.540  1.00                 C  \nATOM   1714  CG  PHE B  85       8.603 -17.162   8.525  1.00                 C  \nATOM   1715  CZ  PHE B  85      11.049 -15.824   8.368  1.00                 C  \nATOM   1716  N   PHE B  85       7.587 -20.199   9.155  1.00                 N  \nATOM   1717  O   PHE B  85       5.614 -17.847  11.134  1.00                 O  \nATOM   1718  C   ALA B  86       3.657 -19.564  12.618  1.00                 C  \nATOM   1719  CA  ALA B  86       3.862 -20.072  11.205  1.00                 C  \nATOM   1720  CB  ALA B  86       3.458 -21.517  11.190  1.00                 C  \nATOM   1721  N   ALA B  86       5.265 -20.030  10.699  1.00                 N  \nATOM   1722  O   ALA B  86       2.691 -18.914  13.008  1.00                 O  \nATOM   1723  C   THR B  87       4.711 -18.128  15.038  1.00                 C  \nATOM   1724  CA  THR B  87       4.565 -19.633  14.821  1.00                 C  \nATOM   1725  CB  THR B  87       5.815 -20.336  15.374  1.00                 C  \nATOM   1726  CG2 THR B  87       5.734 -20.486  16.898  1.00                 C  \nATOM   1727  N   THR B  87       4.591 -19.940  13.390  1.00                 N  \nATOM   1728  O   THR B  87       4.109 -17.533  15.936  1.00                 O  \nATOM   1729  OG1 THR B  87       6.072 -21.579  14.647  1.00                 O  \nATOM   1730  C   LEU B  88       4.836 -15.320  13.578  1.00                 C  \nATOM   1731  CA  LEU B  88       5.975 -16.167  14.156  1.00                 C  \nATOM   1732  CB  LEU B  88       7.212 -16.101  13.248  1.00                 C  \nATOM   1733  CD1 LEU B  88       9.730 -16.419  13.124  1.00                 C  \nATOM   1734  CD2 LEU B  88       8.714 -15.025  14.986  1.00                 C  \nATOM   1735  CG  LEU B  88       8.512 -16.211  14.028  1.00                 C  \nATOM   1736  N   LEU B  88       5.552 -17.570  14.183  1.00                 N  \nATOM   1737  O   LEU B  88       4.521 -14.246  14.059  1.00                 O  \nATOM   1738  C   SER B  89       2.019 -15.140  13.029  1.00                 C  \nATOM   1739  CA  SER B  89       3.082 -15.226  11.929  1.00                 C  \nATOM   1740  CB  SER B  89       2.707 -16.172  10.753  1.00                 C  \nATOM   1741  N   SER B  89       4.273 -15.817  12.514  1.00                 N  \nATOM   1742  O   SER B  89       1.391 -14.118  13.156  1.00                 O  \nATOM   1743  OG  SER B  89       1.334 -16.121  10.339  1.00                 O  \nATOM   1744  C   GLU B  90       1.032 -15.179  15.836  1.00                 C  \nATOM   1745  CA  GLU B  90       0.789 -16.263  14.787  1.00                 C  \nATOM   1746  CB  GLU B  90       0.835 -17.674  15.432  1.00                 C  \nATOM   1747  CD  GLU B  90      -0.559 -19.642  16.420  1.00                 C  \nATOM   1748  CG  GLU B  90      -0.481 -18.123  16.108  1.00                 C  \nATOM   1749  N   GLU B  90       1.867 -16.164  13.840  1.00                 N  \nATOM   1750  O   GLU B  90       0.096 -14.459  16.254  1.00                 O  \nATOM   1751  OE1 GLU B  90      -0.719 -19.985  17.612  1.00                 O  \nATOM   1752  OE2 GLU B  90      -0.501 -20.460  15.479  1.00                 O  \nATOM   1753  C   LEU B  91       2.530 -12.645  16.632  1.00                 C  \nATOM   1754  CA  LEU B  91       2.759 -14.083  17.166  1.00                 C  \nATOM   1755  CB  LEU B  91       4.246 -14.380  17.399  1.00                 C  \nATOM   1756  CD1 LEU B  91       4.561 -12.772  19.341  1.00                 C  \nATOM   1757  CD2 LEU B  91       6.515 -13.192  17.793  1.00                 C  \nATOM   1758  CG  LEU B  91       4.996 -13.146  17.923  1.00                 C  \nATOM   1759  N   LEU B  91       2.324 -15.087  16.186  1.00                 N  \nATOM   1760  O   LEU B  91       2.165 -11.676  17.314  1.00                 O  \nATOM   1761  C   HIS B  92       1.280 -10.711  14.510  1.00                 C  \nATOM   1762  CA  HIS B  92       2.670 -11.038  15.027  1.00                 C  \nATOM   1763  CB  HIS B  92       3.645 -10.734  13.907  1.00                 C  \nATOM   1764  CD2 HIS B  92       6.030  -9.766  14.407  1.00                 C  \nATOM   1765  CE1 HIS B  92       7.207 -11.601  14.390  1.00                 C  \nATOM   1766  CG  HIS B  92       5.168 -10.788  14.159  1.00                 C  \nATOM   1767  N   HIS B  92       2.730 -12.449  15.377  1.00                 N  \nATOM   1768  ND1 HIS B  92       5.914 -11.943  14.173  1.00                 N  \nATOM   1769  NE2 HIS B  92       7.327 -10.262  14.540  1.00                 N  \nATOM   1770  O   HIS B  92       0.897  -9.544  14.465  1.00                 O  \nATOM   1771  C   CYS B  93      -1.773 -11.454  14.517  1.00                 C  \nATOM   1772  CA  CYS B  93      -0.685 -11.563  13.476  1.00                 C  \nATOM   1773  CB  CYS B  93      -0.920 -12.675  12.442  1.00                 C  \nATOM   1774  N   CYS B  93       0.579 -11.755  14.137  1.00                 N  \nATOM   1775  O   CYS B  93      -2.284 -10.344  14.762  1.00                 O  \nATOM   1776  SG  CYS B  93       0.220 -12.437  10.992  1.00                 S  \nATOM   1777  C   ASP B  94      -2.592 -12.452  17.487  1.00                 C  \nATOM   1778  CA  ASP B  94      -3.162 -12.550  16.101  1.00                 C  \nATOM   1779  CB  ASP B  94      -4.079 -13.790  16.181  1.00                 C  \nATOM   1780  CG  ASP B  94      -3.709 -14.902  15.200  1.00                 C  \nATOM   1781  N   ASP B  94      -2.069 -12.593  15.120  1.00                 N  \nATOM   1782  O   ASP B  94      -3.200 -13.089  18.338  1.00                 O  \nATOM   1783  OD1 ASP B  94      -2.991 -15.818  15.606  1.00                 O  \nATOM   1784  OD2 ASP B  94      -4.187 -14.855  14.058  1.00                 O  \nATOM   1785  C   LYS B  95      -0.207 -10.191  19.184  1.00                 C  \nATOM   1786  CA  LYS B  95      -0.878 -11.529  18.971  1.00                 C  \nATOM   1787  CB  LYS B  95       0.116 -12.661  19.152  1.00                 C  \nATOM   1788  CD  LYS B  95      -1.368 -13.478  20.967  1.00                 C  \nATOM   1789  CE  LYS B  95      -2.178 -14.584  21.608  1.00                 C  \nATOM   1790  CG  LYS B  95      -0.630 -13.892  19.685  1.00                 C  \nATOM   1791  N   LYS B  95      -1.532 -11.683  17.663  1.00                 N  \nATOM   1792  NZ  LYS B  95      -2.020 -14.413  23.059  1.00                 N  \nATOM   1793  O   LYS B  95      -0.252  -9.648  20.283  1.00                 O  \nATOM   1794  C   LEU B  96      -0.044  -7.445  17.248  1.00                 C  \nATOM   1795  CA  LEU B  96       0.743  -8.266  18.287  1.00                 C  \nATOM   1796  CB  LEU B  96       2.179  -8.170  17.896  1.00                 C  \nATOM   1797  CD1 LEU B  96       4.355  -9.215  17.770  1.00                 C  \nATOM   1798  CD2 LEU B  96       3.451  -8.478  19.977  1.00                 C  \nATOM   1799  CG  LEU B  96       3.110  -9.092  18.624  1.00                 C  \nATOM   1800  N   LEU B  96       0.398  -9.667  18.170  1.00                 N  \nATOM   1801  O   LEU B  96       0.041  -6.212  17.251  1.00                 O  \nATOM   1802  C   HIS B  97      -0.783  -6.381  14.483  1.00                 C  \nATOM   1803  CA  HIS B  97      -1.597  -7.367  15.326  1.00                 C  \nATOM   1804  CB  HIS B  97      -2.653  -6.588  16.105  1.00                 C  \nATOM   1805  CD2 HIS B  97      -3.582  -7.683  18.294  1.00                 C  \nATOM   1806  CE1 HIS B  97      -5.027  -9.189  17.292  1.00                 C  \nATOM   1807  CG  HIS B  97      -3.511  -7.542  16.928  1.00                 C  \nATOM   1808  N   HIS B  97      -0.766  -8.109  16.330  1.00                 N  \nATOM   1809  ND1 HIS B  97      -4.396  -8.455  16.306  1.00                 N  \nATOM   1810  NE2 HIS B  97      -4.522  -8.711  18.521  1.00                 N  \nATOM   1811  O   HIS B  97      -1.112  -5.178  14.415  1.00                 O  \nATOM   1812  C   VAL B  98       0.657  -6.152  11.736  1.00                 C  \nATOM   1813  CA  VAL B  98       1.152  -5.985  13.166  1.00                 C  \nATOM   1814  CB  VAL B  98       2.672  -6.233  13.272  1.00                 C  \nATOM   1815  CG1 VAL B  98       3.466  -5.430  12.202  1.00                 C  \nATOM   1816  CG2 VAL B  98       3.238  -6.028  14.693  1.00                 C  \nATOM   1817  N   VAL B  98       0.310  -6.896  13.925  1.00                 N  \nATOM   1818  O   VAL B  98       0.687  -7.251  11.191  1.00                 O  \nATOM   1819  C   ASP B  99       1.003  -5.355   8.943  1.00                 C  \nATOM   1820  CA  ASP B  99      -0.197  -5.059   9.811  1.00                 C  \nATOM   1821  CB  ASP B  99      -0.750  -3.682   9.472  1.00                 C  \nATOM   1822  CG  ASP B  99      -1.535  -3.698   8.161  1.00                 C  \nATOM   1823  N   ASP B  99       0.207  -5.068  11.181  1.00                 N  \nATOM   1824  O   ASP B  99       2.000  -4.639   9.072  1.00                 O  \nATOM   1825  OD1 ASP B  99      -2.759  -3.963   8.199  1.00                 O  \nATOM   1826  OD2 ASP B  99      -0.878  -3.513   7.129  1.00                 O  \nATOM   1827  C   PRO B 100       2.401  -6.098   6.276  1.00                 C  \nATOM   1828  CA  PRO B 100       1.636  -7.030   7.176  1.00                 C  \nATOM   1829  CB  PRO B 100       0.699  -7.857   6.274  1.00                 C  \nATOM   1830  CD  PRO B 100      -0.445  -7.217   8.290  1.00                 C  \nATOM   1831  CG  PRO B 100      -0.694  -7.795   6.910  1.00                 C  \nATOM   1832  N   PRO B 100       0.801  -6.404   8.173  1.00                 N  \nATOM   1833  O   PRO B 100       3.333  -6.568   5.628  1.00                 O  \nATOM   1834  C   GLU B 101       4.081  -3.544   6.037  1.00                 C  \nATOM   1835  CA  GLU B 101       2.779  -3.972   5.342  1.00                 C  \nATOM   1836  CB  GLU B 101       1.856  -2.825   4.975  1.00                 C  \nATOM   1837  CD  GLU B 101       2.859  -1.622   2.917  1.00                 C  \nATOM   1838  CG  GLU B 101       2.602  -1.617   4.422  1.00                 C  \nATOM   1839  N   GLU B 101       2.012  -4.857   6.200  1.00                 N  \nATOM   1840  O   GLU B 101       5.089  -3.183   5.411  1.00                 O  \nATOM   1841  OE1 GLU B 101       2.637  -2.626   2.217  1.00                 O  \nATOM   1842  OE2 GLU B 101       3.294  -0.555   2.479  1.00                 O  \nATOM   1843  C   ASN B 102       6.381  -4.437   7.762  1.00                 C  \nATOM   1844  CA  ASN B 102       5.366  -3.304   7.966  1.00                 C  \nATOM   1845  CB  ASN B 102       5.091  -2.989   9.438  1.00                 C  \nATOM   1846  CG  ASN B 102       4.013  -1.892   9.518  1.00                 C  \nATOM   1847  N   ASN B 102       4.101  -3.648   7.332  1.00                 N  \nATOM   1848  ND2 ASN B 102       4.437  -0.726   9.189  1.00                 N  \nATOM   1849  O   ASN B 102       7.592  -4.268   7.975  1.00                 O  \nATOM   1850  OD1 ASN B 102       2.846  -2.118   9.881  1.00                 O  \nATOM   1851  C   PHE B 103       7.332  -6.439   5.657  1.00                 C  \nATOM   1852  CA  PHE B 103       6.631  -6.701   6.986  1.00                 C  \nATOM   1853  CB  PHE B 103       5.821  -7.970   6.803  1.00                 C  \nATOM   1854  CD1 PHE B 103       5.327  -8.029   9.294  1.00                 C  \nATOM   1855  CD2 PHE B 103       3.957  -9.315   7.801  1.00                 C  \nATOM   1856  CE1 PHE B 103       4.576  -8.493  10.385  1.00                 C  \nATOM   1857  CE2 PHE B 103       3.213  -9.769   8.867  1.00                 C  \nATOM   1858  CG  PHE B 103       5.015  -8.449   8.014  1.00                 C  \nATOM   1859  CZ  PHE B 103       3.522  -9.358  10.164  1.00                 C  \nATOM   1860  N   PHE B 103       5.830  -5.556   7.351  1.00                 N  \nATOM   1861  O   PHE B 103       8.451  -6.936   5.505  1.00                 O  \nATOM   1862  C   ARG B 104       8.391  -4.163   3.822  1.00                 C  \nATOM   1863  CA  ARG B 104       7.382  -5.288   3.532  1.00                 C  \nATOM   1864  CB  ARG B 104       6.354  -4.910   2.479  1.00                 C  \nATOM   1865  CD  ARG B 104       4.559  -6.237   1.246  1.00                 C  \nATOM   1866  CG  ARG B 104       5.917  -6.250   1.930  1.00                 C  \nATOM   1867  CZ  ARG B 104       3.232  -8.067   2.125  1.00                 C  \nATOM   1868  N   ARG B 104       6.680  -5.713   4.735  1.00                 N  \nATOM   1869  NE  ARG B 104       4.093  -7.628   1.208  1.00                 N  \nATOM   1870  NH1 ARG B 104       2.753  -7.225   3.076  1.00                 N  \nATOM   1871  NH2 ARG B 104       2.839  -9.347   2.043  1.00                 N  \nATOM   1872  O   ARG B 104       9.527  -4.112   3.339  1.00                 O  \nATOM   1873  C   LEU B 105      10.174  -2.709   5.648  1.00                 C  \nATOM   1874  CA  LEU B 105       8.823  -2.216   5.028  1.00                 C  \nATOM   1875  CB  LEU B 105       8.008  -1.336   5.941  1.00                 C  \nATOM   1876  CD1 LEU B 105       6.280   0.312   6.090  1.00                 C  \nATOM   1877  CD2 LEU B 105       7.099  -0.219   3.868  1.00                 C  \nATOM   1878  CG  LEU B 105       6.771  -0.815   5.221  1.00                 C  \nATOM   1879  N   LEU B 105       7.932  -3.263   4.641  1.00                 N  \nATOM   1880  O   LEU B 105      11.222  -2.293   5.185  1.00                 O  \nATOM   1881  C   LEU B 106      12.169  -4.843   6.147  1.00                 C  \nATOM   1882  CA  LEU B 106      11.367  -4.164   7.249  1.00                 C  \nATOM   1883  CB  LEU B 106      10.914  -5.230   8.287  1.00                 C  \nATOM   1884  CD1 LEU B 106      12.673  -4.343   9.897  1.00                 C  \nATOM   1885  CD2 LEU B 106      11.619  -6.616  10.313  1.00                 C  \nATOM   1886  CG  LEU B 106      12.040  -5.591   9.260  1.00                 C  \nATOM   1887  N   LEU B 106      10.175  -3.524   6.669  1.00                 N  \nATOM   1888  O   LEU B 106      13.369  -4.580   6.031  1.00                 O  \nATOM   1889  C   GLY B 107      12.877  -5.329   3.419  1.00                 C  \nATOM   1890  CA  GLY B 107      12.008  -6.301   4.242  1.00                 C  \nATOM   1891  N   GLY B 107      11.429  -5.684   5.390  1.00                 N  \nATOM   1892  O   GLY B 107      14.070  -5.563   3.182  1.00                 O  \nATOM   1893  C   ASN B 108      13.990  -2.425   2.972  1.00                 C  \nATOM   1894  CA  ASN B 108      12.914  -3.226   2.218  1.00                 C  \nATOM   1895  CB  ASN B 108      11.880  -2.238   1.717  1.00                 C  \nATOM   1896  CG  ASN B 108      11.041  -2.809   0.595  1.00                 C  \nATOM   1897  N   ASN B 108      12.234  -4.262   3.009  1.00                 N  \nATOM   1898  ND2 ASN B 108      11.436  -3.942   0.050  1.00                 N  \nATOM   1899  O   ASN B 108      14.917  -1.892   2.334  1.00                 O  \nATOM   1900  OD1 ASN B 108      10.064  -2.175   0.210  1.00                 O  \nATOM   1901  C   VAL B 109      15.993  -2.527   5.047  1.00                 C  \nATOM   1902  CA  VAL B 109      14.834  -1.532   4.959  1.00                 C  \nATOM   1903  CB  VAL B 109      14.430  -0.857   6.324  1.00                 C  \nATOM   1904  CG1 VAL B 109      13.067  -0.205   6.328  1.00                 C  \nATOM   1905  CG2 VAL B 109      14.581  -1.624   7.601  1.00                 C  \nATOM   1906  N   VAL B 109      13.817  -2.302   4.277  1.00                 N  \nATOM   1907  O   VAL B 109      17.146  -2.117   5.030  1.00                 O  \nATOM   1908  C   LEU B 110      17.501  -4.695   3.888  1.00                 C  \nATOM   1909  CA  LEU B 110      16.715  -4.779   5.180  1.00                 C  \nATOM   1910  CB  LEU B 110      16.208  -6.206   5.301  1.00                 C  \nATOM   1911  CD1 LEU B 110      16.984  -8.628   5.612  1.00                 C  \nATOM   1912  CD2 LEU B 110      18.630  -6.804   6.149  1.00                 C  \nATOM   1913  CG  LEU B 110      17.150  -7.175   6.057  1.00                 C  \nATOM   1914  N   LEU B 110      15.666  -3.805   5.066  1.00                 N  \nATOM   1915  O   LEU B 110      18.727  -4.850   3.930  1.00                 O  \nATOM   1916  C   VAL B 111      18.356  -3.125   1.528  1.00                 C  \nATOM   1917  CA  VAL B 111      17.507  -4.392   1.582  1.00                 C  \nATOM   1918  CB  VAL B 111      16.611  -4.602   0.394  1.00                 C  \nATOM   1919  CG1 VAL B 111      17.336  -4.441  -0.949  1.00                 C  \nATOM   1920  CG2 VAL B 111      16.039  -6.008   0.477  1.00                 C  \nATOM   1921  N   VAL B 111      16.765  -4.418   2.822  1.00                 N  \nATOM   1922  O   VAL B 111      19.477  -3.133   1.005  1.00                 O  \nATOM   1923  C   CYS B 112      19.939  -1.150   3.031  1.00                 C  \nATOM   1924  CA  CYS B 112      18.648  -0.906   2.232  1.00                 C  \nATOM   1925  CB  CYS B 112      17.851   0.174   2.945  1.00                 C  \nATOM   1926  N   CYS B 112      17.833  -2.101   2.112  1.00                 N  \nATOM   1927  O   CYS B 112      20.983  -0.706   2.584  1.00                 O  \nATOM   1928  SG  CYS B 112      16.577   0.937   1.922  1.00                 S  \nATOM   1929  C   VAL B 113      22.036  -2.884   4.492  1.00                 C  \nATOM   1930  CA  VAL B 113      20.938  -2.068   5.128  1.00                 C  \nATOM   1931  CB  VAL B 113      20.461  -2.884   6.343  1.00                 C  \nATOM   1932  CG1 VAL B 113      21.626  -3.160   7.334  1.00                 C  \nATOM   1933  CG2 VAL B 113      19.380  -2.089   7.059  1.00                 C  \nATOM   1934  N   VAL B 113      19.836  -1.813   4.173  1.00                 N  \nATOM   1935  O   VAL B 113      23.205  -2.625   4.777  1.00                 O  \nATOM   1936  C   LEU B 114      23.219  -3.871   1.883  1.00                 C  \nATOM   1937  CA  LEU B 114      22.559  -4.708   2.972  1.00                 C  \nATOM   1938  CB  LEU B 114      21.792  -5.776   2.254  1.00                 C  \nATOM   1939  CD1 LEU B 114      20.209  -7.699   2.556  1.00                 C  \nATOM   1940  CD2 LEU B 114      22.227  -7.339   4.072  1.00                 C  \nATOM   1941  CG  LEU B 114      21.138  -6.681   3.255  1.00                 C  \nATOM   1942  N   LEU B 114      21.592  -3.878   3.713  1.00                 N  \nATOM   1943  O   LEU B 114      24.442  -3.874   1.777  1.00                 O  \nATOM   1944  C   ALA B 115      24.110  -1.310   0.806  1.00                 C  \nATOM   1945  CA  ALA B 115      23.078  -2.267   0.166  1.00                 C  \nATOM   1946  CB  ALA B 115      22.062  -1.483  -0.681  1.00                 C  \nATOM   1947  N   ALA B 115      22.411  -3.143   1.108  1.00                 N  \nATOM   1948  O   ALA B 115      25.162  -1.031   0.205  1.00                 O  \nATOM   1949  C   HIS B 116      26.002  -0.598   3.056  1.00                 C  \nATOM   1950  CA  HIS B 116      24.745   0.175   2.598  1.00                 C  \nATOM   1951  CB  HIS B 116      23.950   0.748   3.762  1.00                 C  \nATOM   1952  CD2 HIS B 116      25.085   3.020   4.460  1.00                 C  \nATOM   1953  CE1 HIS B 116      25.270   2.653   6.699  1.00                 C  \nATOM   1954  CG  HIS B 116      24.572   1.779   4.724  1.00                 C  \nATOM   1955  N   HIS B 116      23.833  -0.794   1.951  1.00                 N  \nATOM   1956  ND1 HIS B 116      24.668   1.534   6.110  1.00                 N  \nATOM   1957  NE2 HIS B 116      25.525   3.566   5.688  1.00                 N  \nATOM   1958  O   HIS B 116      27.108  -0.057   3.170  1.00                 O  \nATOM   1959  C   HIS B 117      27.843  -3.204   2.899  1.00                 C  \nATOM   1960  CA  HIS B 117      26.912  -2.591   3.931  1.00                 C  \nATOM   1961  CB  HIS B 117      26.429  -3.592   5.026  1.00                 C  \nATOM   1962  CD2 HIS B 117      25.407  -1.559   6.430  1.00                 C  \nATOM   1963  CE1 HIS B 117      25.464  -2.422   8.518  1.00                 C  \nATOM   1964  CG  HIS B 117      25.944  -2.844   6.316  1.00                 C  \nATOM   1965  N   HIS B 117      25.823  -1.885   3.248  1.00                 N  \nATOM   1966  ND1 HIS B 117      25.972  -3.367   7.628  1.00                 N  \nATOM   1967  NE2 HIS B 117      25.108  -1.286   7.773  1.00                 N  \nATOM   1968  O   HIS B 117      29.043  -3.394   3.134  1.00                 O  \nATOM   1969  C   PHE B 118      28.518  -3.333  -0.377  1.00                 C  \nATOM   1970  CA  PHE B 118      28.089  -4.236   0.793  1.00                 C  \nATOM   1971  CB  PHE B 118      27.167  -5.405   0.448  1.00                 C  \nATOM   1972  CD1 PHE B 118      26.134  -6.766   2.348  1.00                 C  \nATOM   1973  CD2 PHE B 118      28.416  -7.181   1.749  1.00                 C  \nATOM   1974  CE1 PHE B 118      26.225  -7.757   3.344  1.00                 C  \nATOM   1975  CE2 PHE B 118      28.535  -8.187   2.747  1.00                 C  \nATOM   1976  CG  PHE B 118      27.223  -6.473   1.545  1.00                 C  \nATOM   1977  CZ  PHE B 118      27.440  -8.475   3.545  1.00                 C  \nATOM   1978  N   PHE B 118      27.307  -3.490   1.787  1.00                 N  \nATOM   1979  O   PHE B 118      29.349  -3.652  -1.207  1.00                 O  \nATOM   1980  C   GLY B 119      27.847  -1.842  -2.889  1.00                 C  \nATOM   1981  CA  GLY B 119      28.012  -1.233  -1.493  1.00                 C  \nATOM   1982  N   GLY B 119      27.945  -2.154  -0.394  1.00                 N  \nATOM   1983  O   GLY B 119      26.765  -2.312  -3.256  1.00                 O  \nATOM   1984  C   LYS B 120      28.571  -3.539  -5.191  1.00                 C  \nATOM   1985  CA  LYS B 120      28.838  -2.050  -5.058  1.00                 C  \nATOM   1986  CB  LYS B 120      30.067  -1.514  -5.858  1.00                 C  \nATOM   1987  CD  LYS B 120      30.989   0.770  -6.868  1.00                 C  \nATOM   1988  CE  LYS B 120      30.691   2.302  -6.914  1.00                 C  \nATOM   1989  CG  LYS B 120      29.869  -0.001  -6.129  1.00                 C  \nATOM   1990  N   LYS B 120      28.937  -1.777  -3.644  1.00                 N  \nATOM   1991  NZ  LYS B 120      30.865   3.016  -5.610  1.00                 N  \nATOM   1992  O   LYS B 120      28.070  -3.979  -6.230  1.00                 O  \nATOM   1993  C   GLU B 121      27.313  -6.123  -4.196  1.00                 C  \nATOM   1994  CA  GLU B 121      28.782  -5.746  -4.222  1.00                 C  \nATOM   1995  CB  GLU B 121      29.615  -6.490  -3.143  1.00                 C  \nATOM   1996  CD  GLU B 121      31.831  -7.538  -2.718  1.00                 C  \nATOM   1997  CG  GLU B 121      31.046  -6.606  -3.637  1.00                 C  \nATOM   1998  N   GLU B 121      28.887  -4.270  -4.124  1.00                 N  \nATOM   1999  O   GLU B 121      26.866  -7.251  -4.451  1.00                 O  \nATOM   2000  OE1 GLU B 121      32.687  -7.020  -1.987  1.00                 O  \nATOM   2001  OE2 GLU B 121      31.612  -8.757  -2.779  1.00                 O  \nATOM   2002  C   PHE B 122      24.557  -4.738  -5.279  1.00                 C  \nATOM   2003  CA  PHE B 122      25.113  -5.281  -3.954  1.00                 C  \nATOM   2004  CB  PHE B 122      24.533  -4.600  -2.713  1.00                 C  \nATOM   2005  CD1 PHE B 122      23.055  -6.408  -1.768  1.00                 C  \nATOM   2006  CD2 PHE B 122      22.005  -4.468  -2.649  1.00                 C  \nATOM   2007  CE1 PHE B 122      21.826  -6.935  -1.458  1.00                 C  \nATOM   2008  CE2 PHE B 122      20.774  -4.983  -2.342  1.00                 C  \nATOM   2009  CG  PHE B 122      23.148  -5.177  -2.363  1.00                 C  \nATOM   2010  CZ  PHE B 122      20.682  -6.223  -1.744  1.00                 C  \nATOM   2011  N   PHE B 122      26.560  -5.098  -3.924  1.00                 N  \nATOM   2012  O   PHE B 122      23.963  -3.658  -5.333  1.00                 O  \nATOM   2013  C   THR B 123      22.916  -5.364  -7.799  1.00                 C  \nATOM   2014  CA  THR B 123      24.430  -5.177  -7.662  1.00                 C  \nATOM   2015  CB  THR B 123      25.140  -6.146  -8.621  1.00                 C  \nATOM   2016  CG2 THR B 123      26.658  -6.257  -8.408  1.00                 C  \nATOM   2017  N   THR B 123      24.769  -5.526  -6.312  1.00                 N  \nATOM   2018  O   THR B 123      22.254  -5.942  -6.941  1.00                 O  \nATOM   2019  OG1 THR B 123      24.513  -7.424  -8.505  1.00                 O  \nATOM   2020  C   PRO B 124      20.415  -6.232  -9.151  1.00                 C  \nATOM   2021  CA  PRO B 124      20.977  -4.820  -9.085  1.00                 C  \nATOM   2022  CB  PRO B 124      20.786  -4.005 -10.356  1.00                 C  \nATOM   2023  CD  PRO B 124      23.077  -3.866  -9.774  1.00                 C  \nATOM   2024  CG  PRO B 124      21.969  -3.038 -10.347  1.00                 C  \nATOM   2025  N   PRO B 124      22.382  -4.787  -8.825  1.00                 N  \nATOM   2026  O   PRO B 124      19.300  -6.378  -8.625  1.00                 O  \nATOM   2027  C   PRO B 125      20.703  -9.295  -8.486  1.00                 C  \nATOM   2028  CA  PRO B 125      20.700  -8.649  -9.844  1.00                 C  \nATOM   2029  CB  PRO B 125      21.785  -9.334 -10.658  1.00                 C  \nATOM   2030  CD  PRO B 125      22.264  -6.991 -10.731  1.00                 C  \nATOM   2031  CG  PRO B 125      22.350  -8.246 -11.561  1.00                 C  \nATOM   2032  N   PRO B 125      21.105  -7.201  -9.800  1.00                 N  \nATOM   2033  O   PRO B 125      19.980 -10.308  -8.232  1.00                 O  \nATOM   2034  C   VAL B 126      20.460  -8.815  -5.474  1.00                 C  \nATOM   2035  CA  VAL B 126      21.573  -9.414  -6.295  1.00                 C  \nATOM   2036  CB  VAL B 126      22.918  -9.206  -5.597  1.00                 C  \nATOM   2037  CG1 VAL B 126      22.904  -9.762  -4.162  1.00                 C  \nATOM   2038  CG2 VAL B 126      24.039  -9.800  -6.442  1.00                 C  \nATOM   2039  N   VAL B 126      21.527  -8.717  -7.600  1.00                 N  \nATOM   2040  O   VAL B 126      19.814  -9.427  -4.624  1.00                 O  \nATOM   2041  C   GLN B 127      17.814  -7.601  -5.474  1.00                 C  \nATOM   2042  CA  GLN B 127      19.161  -6.966  -5.089  1.00                 C  \nATOM   2043  CB  GLN B 127      19.230  -5.505  -5.493  1.00                 C  \nATOM   2044  CD  GLN B 127      17.680  -3.503  -5.463  1.00                 C  \nATOM   2045  CG  GLN B 127      17.833  -4.994  -5.344  1.00                 C  \nATOM   2046  N   GLN B 127      20.275  -7.591  -5.749  1.00                 N  \nATOM   2047  NE2 GLN B 127      16.657  -3.185  -4.777  1.00                 N  \nATOM   2048  O   GLN B 127      16.961  -7.881  -4.621  1.00                 O  \nATOM   2049  OE1 GLN B 127      18.413  -2.758  -6.102  1.00                 O  \nATOM   2050  C   ALA B 128      16.357  -9.923  -6.751  1.00                 C  \nATOM   2051  CA  ALA B 128      16.565  -8.537  -7.396  1.00                 C  \nATOM   2052  CB  ALA B 128      16.807  -8.614  -8.936  1.00                 C  \nATOM   2053  N   ALA B 128      17.688  -7.820  -6.761  1.00                 N  \nATOM   2054  O   ALA B 128      15.232 -10.388  -6.564  1.00                 O  \nATOM   2055  C   ALA B 129      16.751 -11.815  -4.367  1.00                 C  \nATOM   2056  CA  ALA B 129      17.314 -11.911  -5.783  1.00                 C  \nATOM   2057  CB  ALA B 129      18.746 -12.519  -5.757  1.00                 C  \nATOM   2058  N   ALA B 129      17.445 -10.573  -6.375  1.00                 N  \nATOM   2059  O   ALA B 129      15.981 -12.666  -3.901  1.00                 O  \nATOM   2060  C   TYR B 130      15.502 -10.055  -2.101  1.00                 C  \nATOM   2061  CA  TYR B 130      16.929 -10.533  -2.277  1.00                 C  \nATOM   2062  CB  TYR B 130      17.962  -9.486  -1.741  1.00                 C  \nATOM   2063  CD1 TYR B 130      18.712 -10.904   0.237  1.00                 C  \nATOM   2064  CD2 TYR B 130      20.295 -10.245  -1.446  1.00                 C  \nATOM   2065  CE1 TYR B 130      19.715 -11.582   0.937  1.00                 C  \nATOM   2066  CE2 TYR B 130      21.311 -10.926  -0.764  1.00                 C  \nATOM   2067  CG  TYR B 130      19.021 -10.219  -0.942  1.00                 C  \nATOM   2068  CZ  TYR B 130      21.032 -11.584   0.431  1.00                 C  \nATOM   2069  N   TYR B 130      17.203 -10.765  -3.708  1.00                 N  \nATOM   2070  O   TYR B 130      14.925 -10.280  -1.027  1.00                 O  \nATOM   2071  OH  TYR B 130      22.055 -12.214   1.118  1.00                 O  \nATOM   2072  C   GLN B 131      12.648  -9.919  -3.110  1.00                 C  \nATOM   2073  CA  GLN B 131      13.652  -8.793  -3.118  1.00                 C  \nATOM   2074  CB  GLN B 131      13.274  -7.796  -4.268  1.00                 C  \nATOM   2075  CD  GLN B 131      13.915  -5.517  -3.154  1.00                 C  \nATOM   2076  CG  GLN B 131      14.052  -6.455  -4.353  1.00                 C  \nATOM   2077  N   GLN B 131      14.992  -9.396  -3.170  1.00                 N  \nATOM   2078  NE2 GLN B 131      12.843  -5.656  -2.451  1.00                 N  \nATOM   2079  O   GLN B 131      11.579  -9.820  -2.501  1.00                 O  \nATOM   2080  OE1 GLN B 131      14.806  -4.731  -2.830  1.00                 O  \nATOM   2081  C   LYS B 132      11.944 -12.697  -2.547  1.00                 C  \nATOM   2082  CA  LYS B 132      12.076 -11.993  -3.893  1.00                 C  \nATOM   2083  CB  LYS B 132      12.617 -12.981  -4.878  1.00                 C  \nATOM   2084  CD  LYS B 132      13.194 -13.488  -7.253  1.00                 C  \nATOM   2085  CE  LYS B 132      13.228 -12.993  -8.695  1.00                 C  \nATOM   2086  CG  LYS B 132      12.900 -12.377  -6.237  1.00                 C  \nATOM   2087  N   LYS B 132      13.016 -10.916  -3.811  1.00                 N  \nATOM   2088  NZ  LYS B 132      13.044 -14.135  -9.606  1.00                 N  \nATOM   2089  O   LYS B 132      10.899 -13.266  -2.217  1.00                 O  \nATOM   2090  C   VAL B 133      12.555 -12.755   0.505  1.00                 C  \nATOM   2091  CA  VAL B 133      13.238 -13.427  -0.676  1.00                 C  \nATOM   2092  CB  VAL B 133      14.724 -13.675  -0.367  1.00                 C  \nATOM   2093  CG1 VAL B 133      14.911 -14.468   0.903  1.00                 C  \nATOM   2094  CG2 VAL B 133      15.543 -14.329  -1.436  1.00                 C  \nATOM   2095  N   VAL B 133      13.055 -12.612  -1.849  1.00                 N  \nATOM   2096  O   VAL B 133      11.926 -13.458   1.320  1.00                 O  \nATOM   2097  C   VAL B 134      10.682 -10.594   1.401  1.00                 C  \nATOM   2098  CA  VAL B 134      12.193 -10.566   1.587  1.00                 C  \nATOM   2099  CB  VAL B 134      12.819  -9.175   1.442  1.00                 C  \nATOM   2100  CG1 VAL B 134      11.845  -8.053   1.155  1.00                 C  \nATOM   2101  CG2 VAL B 134      13.831  -8.810   2.540  1.00                 C  \nATOM   2102  N   VAL B 134      12.759 -11.448   0.547  1.00                 N  \nATOM   2103  O   VAL B 134       9.964 -10.645   2.386  1.00                 O  \nATOM   2104  C   ALA B 135       8.317 -12.148   0.294  1.00                 C  \nATOM   2105  CA  ALA B 135       8.866 -10.849  -0.247  1.00                 C  \nATOM   2106  CB  ALA B 135       8.721 -10.970  -1.772  1.00                 C  \nATOM   2107  N   ALA B 135      10.255 -10.638   0.151  1.00                 N  \nATOM   2108  O   ALA B 135       7.156 -12.206   0.672  1.00                 O  \nATOM   2109  C   GLY B 136       8.399 -14.429   1.955  1.00                 C  \nATOM   2110  CA  GLY B 136       8.602 -14.431   0.469  1.00                 C  \nATOM   2111  N   GLY B 136       9.145 -13.138   0.259  1.00                 N  \nATOM   2112  O   GLY B 136       7.391 -14.923   2.479  1.00                 O  \nATOM   2113  C   VAL B 137       8.163 -12.938   4.487  1.00                 C  \nATOM   2114  CA  VAL B 137       9.348 -13.762   3.997  1.00                 C  \nATOM   2115  CB  VAL B 137      10.739 -13.432   4.629  1.00                 C  \nATOM   2116  CG1 VAL B 137      10.751 -13.236   6.165  1.00                 C  \nATOM   2117  CG2 VAL B 137      11.709 -14.566   4.287  1.00                 C  \nATOM   2118  N   VAL B 137       9.374 -13.759   2.543  1.00                 N  \nATOM   2119  O   VAL B 137       7.514 -13.450   5.407  1.00                 O  \nATOM   2120  C   ALA B 138       5.454 -11.606   4.058  1.00                 C  \nATOM   2121  CA  ALA B 138       6.764 -10.867   4.332  1.00                 C  \nATOM   2122  CB  ALA B 138       6.690  -9.548   3.596  1.00                 C  \nATOM   2123  N   ALA B 138       7.902 -11.727   3.899  1.00                 N  \nATOM   2124  O   ALA B 138       4.462 -11.532   4.782  1.00                 O  \nATOM   2125  C   ASN B 139       3.993 -14.269   3.664  1.00                 C  \nATOM   2126  CA  ASN B 139       4.236 -13.076   2.720  1.00                 C  \nATOM   2127  CB  ASN B 139       4.378 -13.460   1.241  1.00                 C  \nATOM   2128  CG  ASN B 139       4.125 -12.220   0.365  1.00                 C  \nATOM   2129  N   ASN B 139       5.453 -12.384   3.043  1.00                 N  \nATOM   2130  ND2 ASN B 139       4.982 -12.048  -0.609  1.00                 N  \nATOM   2131  O   ASN B 139       2.845 -14.690   3.877  1.00                 O  \nATOM   2132  OD1 ASN B 139       3.148 -11.482   0.533  1.00                 O  \nATOM   2133  C   ALA B 140       4.451 -15.637   6.460  1.00                 C  \nATOM   2134  CA  ALA B 140       4.966 -15.998   5.073  1.00                 C  \nATOM   2135  CB  ALA B 140       6.278 -16.758   5.132  1.00                 C  \nATOM   2136  N   ALA B 140       5.085 -14.786   4.241  1.00                 N  \nATOM   2137  O   ALA B 140       3.602 -16.302   7.065  1.00                 O  \nATOM   2138  C   LEU B 141       3.074 -13.593   8.133  1.00                 C  \nATOM   2139  CA  LEU B 141       4.503 -14.094   8.228  1.00                 C  \nATOM   2140  CB  LEU B 141       5.301 -12.822   8.479  1.00                 C  \nATOM   2141  CD1 LEU B 141       7.417 -11.715   8.380  1.00                 C  \nATOM   2142  CD2 LEU B 141       6.714 -12.919  10.523  1.00                 C  \nATOM   2143  CG  LEU B 141       6.708 -12.919   8.984  1.00                 C  \nATOM   2144  N   LEU B 141       4.954 -14.573   6.951  1.00                 N  \nATOM   2145  O   LEU B 141       2.356 -13.592   9.129  1.00                 O  \nATOM   2146  C   ALA B 142       0.314 -13.449   6.631  1.00                 C  \nATOM   2147  CA  ALA B 142       1.380 -12.411   6.993  1.00                 C  \nATOM   2148  CB  ALA B 142       1.364 -11.288   5.992  1.00                 C  \nATOM   2149  N   ALA B 142       2.707 -13.051   6.977  1.00                 N  \nATOM   2150  O   ALA B 142      -0.837 -13.170   6.329  1.00                 O  \nATOM   2151  C   HIS B 143      -1.285 -16.073   7.263  1.00                 C  \nATOM   2152  CA  HIS B 143      -0.252 -15.651   6.205  1.00                 C  \nATOM   2153  CB  HIS B 143       0.554 -16.857   5.861  1.00                 C  \nATOM   2154  CD2 HIS B 143      -0.758 -19.060   5.353  1.00                 C  \nATOM   2155  CE1 HIS B 143      -1.223 -18.638   3.157  1.00                 C  \nATOM   2156  CG  HIS B 143      -0.228 -17.840   5.003  1.00                 C  \nATOM   2157  N   HIS B 143       0.701 -14.673   6.682  1.00                 N  \nATOM   2158  ND1 HIS B 143      -0.501 -17.557   3.657  1.00                 N  \nATOM   2159  NE2 HIS B 143      -1.378 -19.555   4.194  1.00                 N  \nATOM   2160  O   HIS B 143      -2.263 -16.747   6.924  1.00                 O  \nATOM   2161  C   LYS B 144      -3.239 -15.011   9.640  1.00                 C  \nATOM   2162  CA  LYS B 144      -2.203 -16.114   9.423  1.00                 C  \nATOM   2163  CB  LYS B 144      -1.635 -16.704  10.715  1.00                 C  \nATOM   2164  CD  LYS B 144      -3.752 -18.121  10.252  1.00                 C  \nATOM   2165  CE  LYS B 144      -4.559 -19.437  10.389  1.00                 C  \nATOM   2166  CG  LYS B 144      -2.444 -17.980  11.090  1.00                 C  \nATOM   2167  N   LYS B 144      -1.135 -15.676   8.529  1.00                 N  \nATOM   2168  NZ  LYS B 144      -5.621 -19.470   9.346  1.00                 N  \nATOM   2169  O   LYS B 144      -3.904 -15.014  10.677  1.00                 O  \nATOM   2170  C   TYR B 145      -5.540 -13.229   7.887  1.00                 C  \nATOM   2171  CA  TYR B 145      -4.282 -12.935   8.701  1.00                 C  \nATOM   2172  CB  TYR B 145      -3.485 -11.807   8.017  1.00                 C  \nATOM   2173  CD1 TYR B 145      -3.525 -10.230   9.896  1.00                 C  \nATOM   2174  CD2 TYR B 145      -1.352 -10.753   9.052  1.00                 C  \nATOM   2175  CE1 TYR B 145      -2.987  -9.404  10.854  1.00                 C  \nATOM   2176  CE2 TYR B 145      -0.792  -9.894  10.039  1.00                 C  \nATOM   2177  CG  TYR B 145      -2.731 -10.914   9.010  1.00                 C  \nATOM   2178  CZ  TYR B 145      -1.633  -9.237  10.944  1.00                 C  \nATOM   2179  N   TYR B 145      -3.384 -14.127   8.659  1.00                 N  \nATOM   2180  O   TYR B 145      -6.463 -12.409   7.749  1.00                 O  \nATOM   2181  OH  TYR B 145      -1.143  -8.573  12.047  1.00                 O  \nATOM   2182  C   HIS B 146      -7.259 -16.190   7.137  1.00                 C  \nATOM   2183  CA  HIS B 146      -6.383 -15.135   6.444  1.00                 C  \nATOM   2184  CB  HIS B 146      -5.495 -15.954   5.535  1.00                 C  \nATOM   2185  CD2 HIS B 146      -4.030 -15.453   3.438  1.00                 C  \nATOM   2186  CE1 HIS B 146      -2.798 -13.748   4.261  1.00                 C  \nATOM   2187  CG  HIS B 146      -4.422 -15.218   4.738  1.00                 C  \nATOM   2188  N   HIS B 146      -5.483 -14.439   7.372  1.00                 N  \nATOM   2189  ND1 HIS B 146      -3.669 -14.177   5.261  1.00                 N  \nATOM   2190  NE2 HIS B 146      -3.023 -14.540   3.139  1.00                 N  \nATOM   2191  O   HIS B 146      -6.760 -17.299   7.460  1.00                 O  \nATOM   2192  OXT HIS B 146      -8.458 -15.914   7.272  1.00                 O  \n";

	// target, 1A6N_A
	pTmalignCgi->m_pdb_target = "MODEL        1\nHEADER    PDB From iCn3D                                      1A6N\nTITLE     Structure Of Human Oxyhaemoglobin At 2.1 Angstr...\nHELIX          GLU A    4  VAL A   17\nHELIX          VAL A   21  HIS A   36\nHELIX          GLU A   59  LEU A   76\nHELIX          LYS A   87  THR A   95\nHELIX          ILE A  101  HIS A  119\nHELIX          ALA A  125  LEU A  149\nATOM   4570  C   VAL A   1     -17.059  -4.718   7.580  1.00 21.38           C  \nATOM   4571  CA  VAL A   1     -17.934  -3.713   6.846  1.00 28.70           C  \nATOM   4572  CB  VAL A   1     -19.099  -3.263   7.756  1.00 35.94           C  \nATOM   4573  CG1 VAL A   1     -18.684  -3.214   9.207  1.00 43.03           C  \nATOM   4574  CG2 VAL A   1     -19.598  -1.905   7.296  1.00 40.64           C  \nATOM   4575  N   VAL A   1     -18.544  -4.266   5.636  1.00 37.64           N  \nATOM   4576  O   VAL A   1     -17.434  -5.893   7.676  1.00 25.05           O  \nATOM   4577  C   LEU A   2     -15.669  -5.388  10.249  1.00 14.72           C  \nATOM   4578  CA  LEU A   2     -15.089  -5.195   8.839  1.00 14.07           C  \nATOM   4579  CB  LEU A   2     -13.633  -4.749   8.985  1.00 13.48           C  \nATOM   4580  CD1 LEU A   2     -13.071  -4.025   6.676  1.00 16.17           C  \nATOM   4581  CD2 LEU A   2     -11.252  -4.921   8.187  1.00 14.05           C  \nATOM   4582  CG  LEU A   2     -12.714  -5.011   7.768  1.00 13.68           C  \nATOM   4583  N   LEU A   2     -15.900  -4.260   8.079  1.00 15.30           N  \nATOM   4584  O   LEU A   2     -16.136  -4.409  10.835  1.00 15.95           O  \nATOM   4585  C   SER A   3     -14.796  -6.367  13.075  1.00 12.87           C  \nATOM   4586  CA  SER A   3     -15.909  -6.865  12.159  1.00 14.28           C  \nATOM   4587  CB  SER A   3     -16.047  -8.357  12.437  1.00 15.37           C  \nATOM   4588  N   SER A   3     -15.517  -6.591  10.772  1.00 14.12           N  \nATOM   4589  O   SER A   3     -13.657  -6.173  12.647  1.00 13.07           O  \nATOM   4590  OG  SER A   3     -14.792  -9.011  12.286  1.00 15.15           O  \nATOM   4591  C   GLU A   4     -12.911  -6.982  15.266  1.00 13.02           C  \nATOM   4592  CA  GLU A   4     -14.045  -5.964  15.325  1.00 13.28           C  \nATOM   4593  CB  GLU A   4     -14.598  -5.890  16.753  1.00 15.56           C  \nATOM   4594  CD  GLU A   4     -14.645  -3.321  17.086  1.00 13.74           C  \nATOM   4595  CG  GLU A   4     -15.400  -4.619  17.030  1.00 14.52           C  \nATOM   4596  N   GLU A   4     -15.078  -6.282  14.356  1.00 13.90           N  \nATOM   4597  O   GLU A   4     -11.708  -6.631  15.357  1.00 12.93           O  \nATOM   4598  OE1 GLU A   4     -13.418  -3.336  17.183  1.00 16.08           O  \nATOM   4599  OE2 GLU A   4     -15.308  -2.256  17.006  1.00 14.30           O  \nATOM   4600  C   GLY A   5     -11.248  -9.063  13.832  1.00 13.51           C  \nATOM   4601  CA  GLY A   5     -12.149  -9.249  15.047  1.00 14.61           C  \nATOM   4602  N   GLY A   5     -13.219  -8.263  15.095  1.00 14.33           N  \nATOM   4603  O   GLY A   5     -10.035  -9.227  13.922  1.00 13.64           O  \nATOM   4604  C   GLU A   6     -10.190  -7.162  11.728  1.00 11.39           C  \nATOM   4605  CA  GLU A   6     -11.075  -8.400  11.520  1.00 12.25           C  \nATOM   4606  CB  GLU A   6     -11.983  -8.287  10.301  1.00 12.88           C  \nATOM   4607  CD  GLU A   6     -13.736  -9.546   8.977  1.00 15.04           C  \nATOM   4608  CG  GLU A   6     -12.543  -9.621   9.904  1.00 14.32           C  \nATOM   4609  N   GLU A   6     -11.848  -8.694  12.711  1.00 12.49           N  \nATOM   4610  O   GLU A   6      -9.015  -7.157  11.343  1.00 11.22           O  \nATOM   4611  OE1 GLU A   6     -14.447  -8.515   8.913  1.00 16.27           O  \nATOM   4612  OE2 GLU A   6     -13.962 -10.525   8.252  1.00 18.12           O  \nATOM   4613  C   TRP A   7      -8.745  -5.277  13.489  1.00 10.20           C  \nATOM   4614  CA  TRP A   7      -9.919  -4.928  12.572  1.00 10.32           C  \nATOM   4615  CB  TRP A   7     -10.690  -3.770  13.199  1.00 10.97           C  \nATOM   4616  CD1 TRP A   7     -12.905  -2.888  12.187  1.00 11.72           C  \nATOM   4617  CD2 TRP A   7     -11.093  -2.339  11.036  1.00 11.12           C  \nATOM   4618  CE2 TRP A   7     -12.239  -1.811  10.390  1.00 11.17           C  \nATOM   4619  CE3 TRP A   7      -9.838  -2.090  10.468  1.00 10.72           C  \nATOM   4620  CG  TRP A   7     -11.538  -3.038  12.190  1.00 10.51           C  \nATOM   4621  CH2 TRP A   7     -10.933  -0.861   8.648  1.00 12.42           C  \nATOM   4622  CZ2 TRP A   7     -12.149  -1.086   9.215  1.00 13.56           C  \nATOM   4623  CZ3 TRP A   7      -9.785  -1.363   9.274  1.00 11.51           C  \nATOM   4624  N   TRP A   7     -10.752  -6.100  12.308  1.00 11.54           N  \nATOM   4625  NE1 TRP A   7     -13.329  -2.149  11.141  1.00 11.95           N  \nATOM   4626  O   TRP A   7      -7.644  -4.756  13.300  1.00 10.48           O  \nATOM   4627  C   GLN A   8      -6.787  -7.207  14.606  1.00 10.44           C  \nATOM   4628  CA  GLN A   8      -7.902  -6.518  15.399  1.00 11.80           C  \nATOM   4629  CB  GLN A   8      -8.324  -7.565  16.450  1.00 16.93           C  \nATOM   4630  CD  GLN A   8      -6.347  -9.199  16.892  1.00 19.89           C  \nATOM   4631  CG  GLN A   8      -7.251  -8.110  17.360  1.00 20.67           C  \nATOM   4632  N   GLN A   8      -8.982  -6.110  14.513  1.00 10.79           N  \nATOM   4633  NE2 GLN A   8      -5.132  -9.369  17.408  1.00 26.18           N  \nATOM   4634  O   GLN A   8      -5.618  -6.954  14.897  1.00 11.18           O  \nATOM   4635  OE1 GLN A   8      -6.725 -10.074  16.079  1.00 26.27           O  \nATOM   4636  C   LEU A   9      -5.300  -7.754  12.061  1.00 10.14           C  \nATOM   4637  CA  LEU A   9      -6.104  -8.744  12.877  1.00 11.71           C  \nATOM   4638  CB  LEU A   9      -6.706  -9.806  11.937  1.00 12.34           C  \nATOM   4639  CD1 LEU A   9      -8.125 -11.845  11.686  1.00 17.41           C  \nATOM   4640  CD2 LEU A   9      -6.217 -11.876  13.286  1.00 19.42           C  \nATOM   4641  CG  LEU A   9      -7.307 -11.015  12.682  1.00 13.88           C  \nATOM   4642  N   LEU A   9      -7.109  -8.060  13.670  1.00 10.88           N  \nATOM   4643  O   LEU A   9      -4.066  -7.832  11.944  1.00 11.53           O  \nATOM   4644  C   VAL A  10      -4.418  -4.911  11.467  1.00  8.92           C  \nATOM   4645  CA  VAL A  10      -5.387  -5.744  10.652  1.00  8.90           C  \nATOM   4646  CB  VAL A  10      -6.496  -4.850  10.029  1.00  9.86           C  \nATOM   4647  CG1 VAL A  10      -5.889  -3.579   9.398  1.00 10.75           C  \nATOM   4648  CG2 VAL A  10      -7.282  -5.593   8.982  1.00 11.36           C  \nATOM   4649  N   VAL A  10      -6.000  -6.782  11.481  1.00  9.71           N  \nATOM   4650  O   VAL A  10      -3.296  -4.657  11.083  1.00  9.83           O  \nATOM   4651  C   LEU A  11      -2.956  -4.249  14.142  1.00 10.04           C  \nATOM   4652  CA  LEU A  11      -4.069  -3.537  13.415  1.00  9.76           C  \nATOM   4653  CB  LEU A  11      -4.984  -2.691  14.298  1.00 10.66           C  \nATOM   4654  CD1 LEU A  11      -6.837  -1.057  14.557  1.00 15.67           C  \nATOM   4655  CD2 LEU A  11      -5.171  -0.766  12.676  1.00 12.94           C  \nATOM   4656  CG  LEU A  11      -5.941  -1.784  13.557  1.00 10.78           C  \nATOM   4657  N   LEU A  11      -4.880  -4.456  12.618  1.00  9.91           N  \nATOM   4658  O   LEU A  11      -1.958  -3.636  14.474  1.00 10.84           O  \nATOM   4659  C   HIS A  12      -0.873  -6.383  14.117  1.00 10.49           C  \nATOM   4660  CA  HIS A  12      -2.052  -6.294  15.043  1.00 10.96           C  \nATOM   4661  CB  HIS A  12      -2.555  -7.709  15.399  1.00 12.15           C  \nATOM   4662  CD2 HIS A  12      -0.732  -9.496  15.742  1.00 14.31           C  \nATOM   4663  CE1 HIS A  12      -0.302  -9.079  17.864  1.00 16.34           C  \nATOM   4664  CG  HIS A  12      -1.543  -8.494  16.120  1.00 13.03           C  \nATOM   4665  N   HIS A  12      -3.137  -5.553  14.388  1.00  9.97           N  \nATOM   4666  ND1 HIS A  12      -1.276  -8.230  17.467  1.00 14.37           N  \nATOM   4667  NE2 HIS A  12       0.047  -9.829  16.836  1.00 16.03           N  \nATOM   4668  O   HIS A  12       0.275  -6.164  14.599  1.00 11.93           O  \nATOM   4669  C   VAL A  13       0.514  -5.305  11.637  1.00 10.17           C  \nATOM   4670  CA  VAL A  13       0.044  -6.721  11.908  1.00 10.47           C  \nATOM   4671  CB  VAL A  13      -0.243  -7.544  10.668  1.00 10.19           C  \nATOM   4672  CG1 VAL A  13      -1.234  -6.891   9.724  1.00 11.18           C  \nATOM   4673  CG2 VAL A  13       1.095  -7.838   9.927  1.00 11.41           C  \nATOM   4674  N   VAL A  13      -1.104  -6.721  12.856  1.00 10.15           N  \nATOM   4675  O   VAL A  13       1.719  -5.056  11.471  1.00 10.60           O  \nATOM   4676  C   TRP A  14       1.007  -2.426  12.394  1.00  9.86           C  \nATOM   4677  CA  TRP A  14       0.049  -2.953  11.321  1.00  9.69           C  \nATOM   4678  CB  TRP A  14      -1.144  -2.019  11.088  1.00 10.92           C  \nATOM   4679  CD1 TRP A  14      -0.347   0.394  11.006  1.00 16.23           C  \nATOM   4680  CD2 TRP A  14      -0.283  -0.683   9.030  1.00 14.19           C  \nATOM   4681  CE2 TRP A  14       0.205   0.612   8.850  1.00 18.46           C  \nATOM   4682  CE3 TRP A  14      -0.354  -1.599   7.974  1.00 15.11           C  \nATOM   4683  CG  TRP A  14      -0.635  -0.791  10.411  1.00 12.58           C  \nATOM   4684  CH2 TRP A  14       0.561   0.168   6.601  1.00 23.97           C  \nATOM   4685  CZ2 TRP A  14       0.651   1.112   7.591  1.00 23.87           C  \nATOM   4686  CZ3 TRP A  14       0.092  -1.131   6.749  1.00 20.87           C  \nATOM   4687  N   TRP A  14      -0.371  -4.305  11.590  1.00  9.88           N  \nATOM   4688  NE1 TRP A  14       0.155   1.258  10.040  1.00 20.36           N  \nATOM   4689  O   TRP A  14       1.921  -1.666  12.079  1.00 11.18           O  \nATOM   4690  C   ALA A  15       3.094  -2.926  14.456  1.00 11.11           C  \nATOM   4691  CA  ALA A  15       1.687  -2.392  14.711  1.00 11.74           C  \nATOM   4692  CB  ALA A  15       1.170  -2.860  16.068  1.00 14.50           C  \nATOM   4693  N   ALA A  15       0.776  -2.816  13.652  1.00 10.68           N  \nATOM   4694  O   ALA A  15       4.080  -2.308  14.888  1.00 12.48           O  \nATOM   4695  C   LYS A  16       5.129  -3.733  12.312  1.00 11.06           C  \nATOM   4696  CA  LYS A  16       4.528  -4.624  13.413  1.00 11.66           C  \nATOM   4697  CB  LYS A  16       4.455  -6.051  12.898  1.00 12.55           C  \nATOM   4698  CD  LYS A  16       4.400  -7.308  15.062  1.00 14.17           C  \nATOM   4699  CE  LYS A  16       3.708  -8.336  15.936  1.00 15.12           C  \nATOM   4700  CG  LYS A  16       3.719  -7.096  13.738  1.00 13.72           C  \nATOM   4701  N   LYS A  16       3.216  -4.102  13.833  1.00 10.99           N  \nATOM   4702  NZ  LYS A  16       4.528  -8.539  17.173  1.00 18.49           N  \nATOM   4703  O   LYS A  16       6.333  -3.447  12.359  1.00 13.73           O  \nATOM   4704  C   VAL A  17       5.376  -1.162  10.887  1.00 12.95           C  \nATOM   4705  CA  VAL A  17       4.777  -2.417  10.286  1.00 12.64           C  \nATOM   4706  CB  VAL A  17       3.623  -2.089   9.301  1.00 12.52           C  \nATOM   4707  CG1 VAL A  17       4.059  -1.010   8.300  1.00 14.02           C  \nATOM   4708  CG2 VAL A  17       3.159  -3.336   8.550  1.00 15.08           C  \nATOM   4709  N   VAL A  17       4.323  -3.292  11.378  1.00 11.97           N  \nATOM   4710  O   VAL A  17       6.396  -0.667  10.404  1.00 14.32           O  \nATOM   4711  C   GLU A  18       6.411   0.591  13.231  1.00 14.24           C  \nATOM   4712  CA  GLU A  18       5.123   0.646  12.447  1.00 15.29           C  \nATOM   4713  CB  GLU A  18       3.957   1.213  13.225  1.00 17.72           C  \nATOM   4714  CD  GLU A  18       1.822   2.515  12.866  1.00 23.79           C  \nATOM   4715  CG  GLU A  18       2.883   1.672  12.236  1.00 20.05           C  \nATOM   4716  N   GLU A  18       4.678  -0.641  11.898  1.00 12.94           N  \nATOM   4717  O   GLU A  18       7.001   1.649  13.547  1.00 16.06           O  \nATOM   4718  OE1 GLU A  18       1.580   2.359  14.079  1.00 33.84           O  \nATOM   4719  OE2 GLU A  18       1.212   3.323  12.137  1.00 26.53           O  \nATOM   4720  C   ALA A  19       9.344  -0.357  12.908  1.00 14.36           C  \nATOM   4721  CA  ALA A  19       8.309  -0.676  13.981  1.00 14.50           C  \nATOM   4722  CB  ALA A  19       8.560  -2.071  14.547  1.00 19.72           C  \nATOM   4723  N   ALA A  19       6.961  -0.616  13.429  1.00 14.62           N  \nATOM   4724  O   ALA A  19      10.522  -0.135  13.231  1.00 14.14           O  \nATOM   4725  C   ASP A  20       9.181   0.459   9.388  1.00 10.76           C  \nATOM   4726  CA  ASP A  20       9.963  -0.089  10.571  1.00 11.83           C  \nATOM   4727  CB  ASP A  20      10.728  -1.347  10.201  1.00 13.46           C  \nATOM   4728  CG  ASP A  20      11.664  -1.152   9.006  1.00 14.78           C  \nATOM   4729  N   ASP A  20       9.031  -0.325  11.656  1.00 12.35           N  \nATOM   4730  O   ASP A  20       9.104  -0.132   8.329  1.00 11.35           O  \nATOM   4731  OD1 ASP A  20      12.132   0.009   8.791  1.00 12.60           O  \nATOM   4732  OD2 ASP A  20      11.886  -2.151   8.311  1.00 18.21           O  \nATOM   4733  C   VAL A  21       8.591   2.390   7.252  1.00 10.24           C  \nATOM   4734  CA  VAL A  21       7.786   2.224   8.524  1.00 10.50           C  \nATOM   4735  CB  VAL A  21       7.132   3.556   8.968  1.00 11.08           C  \nATOM   4736  CG1 VAL A  21       6.353   4.168   7.792  1.00 13.46           C  \nATOM   4737  CG2 VAL A  21       6.181   3.338  10.123  1.00 13.04           C  \nATOM   4738  N   VAL A  21       8.633   1.668   9.589  1.00 10.75           N  \nATOM   4739  O   VAL A  21       8.139   2.039   6.162  1.00 11.09           O  \nATOM   4740  C   ALA A  22      10.948   2.019   5.372  1.00 10.90           C  \nATOM   4741  CA  ALA A  22      10.566   3.278   6.138  1.00 10.86           C  \nATOM   4742  CB  ALA A  22      11.771   4.112   6.438  1.00 12.25           C  \nATOM   4743  N   ALA A  22       9.784   2.946   7.339  1.00 11.14           N  \nATOM   4744  O   ALA A  22      10.908   2.002   4.124  1.00 11.42           O  \nATOM   4745  C   GLY A  23      10.566  -0.895   4.664  1.00 10.38           C  \nATOM   4746  CA  GLY A  23      11.764  -0.239   5.336  1.00 11.23           C  \nATOM   4747  N   GLY A  23      11.358   0.967   6.061  1.00 11.12           N  \nATOM   4748  O   GLY A  23      10.705  -1.412   3.556  1.00 11.29           O  \nATOM   4749  C   HIS A  24       7.844  -0.604   3.440  1.00  9.20           C  \nATOM   4750  CA  HIS A  24       8.233  -1.440   4.679  1.00  9.62           C  \nATOM   4751  CB  HIS A  24       7.014  -1.450   5.603  1.00  9.42           C  \nATOM   4752  CD2 HIS A  24       6.455  -3.723   6.718  1.00 10.75           C  \nATOM   4753  CE1 HIS A  24       7.705  -3.629   8.458  1.00 11.40           C  \nATOM   4754  CG  HIS A  24       7.077  -2.554   6.632  1.00  9.53           C  \nATOM   4755  N   HIS A  24       9.425  -0.894   5.334  1.00 10.00           N  \nATOM   4756  ND1 HIS A  24       7.882  -2.492   7.771  1.00  9.50           N  \nATOM   4757  NE2 HIS A  24       6.827  -4.405   7.852  1.00 11.48           N  \nATOM   4758  O   HIS A  24       7.463  -1.151   2.417  1.00  9.81           O  \nATOM   4759  C   GLY A  25       8.428   1.351   1.247  1.00  9.43           C  \nATOM   4760  CA  GLY A  25       7.541   1.570   2.441  1.00  9.14           C  \nATOM   4761  N   GLY A  25       7.931   0.724   3.549  1.00  9.14           N  \nATOM   4762  O   GLY A  25       7.955   1.311   0.117  1.00 10.39           O  \nATOM   4763  C   GLN A  26      10.271  -0.455  -0.272  1.00 11.04           C  \nATOM   4764  CA  GLN A  26      10.661   0.844   0.415  1.00 12.02           C  \nATOM   4765  CB  GLN A  26      12.085   0.452   0.837  1.00 11.49           C  \nATOM   4766  CD  GLN A  26      14.036   1.476   1.940  1.00 11.63           C  \nATOM   4767  CG  GLN A  26      12.754   1.733   1.197  1.00 10.36           C  \nATOM   4768  N   GLN A  26       9.737   1.167   1.509  1.00 11.77           N  \nATOM   4769  NE2 GLN A  26      15.136   1.969   1.395  1.00 12.52           N  \nATOM   4770  O   GLN A  26      10.197  -0.537  -1.507  1.00 12.45           O  \nATOM   4771  OE1 GLN A  26      14.033   0.824   2.974  1.00 15.75           O  \nATOM   4772  C   ASP A  27       8.482  -2.711  -0.855  1.00 10.48           C  \nATOM   4773  CA  ASP A  27       9.771  -2.766  -0.029  1.00 11.81           C  \nATOM   4774  CB  ASP A  27       9.636  -3.886   1.030  1.00 13.12           C  \nATOM   4775  CG  ASP A  27      10.858  -4.258   1.813  1.00 17.25           C  \nATOM   4776  N   ASP A  27      10.073  -1.462   0.547  1.00 10.93           N  \nATOM   4777  O   ASP A  27       8.396  -3.304  -1.923  1.00 10.99           O  \nATOM   4778  OD1 ASP A  27      11.934  -3.801   1.469  1.00 19.95           O  \nATOM   4779  OD2 ASP A  27      10.754  -4.947   2.832  1.00 23.52           O  \nATOM   4780  C   ILE A  28       6.295  -1.191  -2.309  1.00  8.53           C  \nATOM   4781  CA  ILE A  28       6.188  -1.941  -1.001  1.00  8.81           C  \nATOM   4782  CB  ILE A  28       5.150  -1.346  -0.006  1.00  8.65           C  \nATOM   4783  CD1 ILE A  28       4.133  -1.864   2.297  1.00  9.89           C  \nATOM   4784  CG1 ILE A  28       4.851  -2.405   1.054  1.00  9.08           C  \nATOM   4785  CG2 ILE A  28       3.931  -0.930  -0.739  1.00  9.61           C  \nATOM   4786  N   ILE A  28       7.479  -2.009  -0.333  1.00  9.01           N  \nATOM   4787  O   ILE A  28       5.761  -1.637  -3.326  1.00  9.00           O  \nATOM   4788  C   LEU A  29       7.844   0.054  -4.545  1.00  9.17           C  \nATOM   4789  CA  LEU A  29       6.992   0.775  -3.540  1.00  9.22           C  \nATOM   4790  CB  LEU A  29       7.546   2.185  -3.257  1.00  9.66           C  \nATOM   4791  CD1 LEU A  29       7.257   4.473  -2.214  1.00 12.30           C  \nATOM   4792  CD2 LEU A  29       5.271   3.352  -3.232  1.00 12.20           C  \nATOM   4793  CG  LEU A  29       6.585   3.112  -2.521  1.00  9.25           C  \nATOM   4794  N   LEU A  29       6.865   0.015  -2.313  1.00  8.53           N  \nATOM   4795  O   LEU A  29       7.498   0.105  -5.750  1.00  9.96           O  \nATOM   4796  C   ILE A  30       8.969  -2.451  -5.759  1.00  9.48           C  \nATOM   4797  CA  ILE A  30       9.761  -1.308  -5.128  1.00  9.84           C  \nATOM   4798  CB  ILE A  30      11.056  -1.767  -4.487  1.00 11.84           C  \nATOM   4799  CD1 ILE A  30      13.199  -0.898  -3.415  1.00 18.18           C  \nATOM   4800  CG1 ILE A  30      11.938  -0.596  -4.152  1.00 13.28           C  \nATOM   4801  CG2 ILE A  30      11.772  -2.746  -5.404  1.00 14.64           C  \nATOM   4802  N   ILE A  30       8.941  -0.573  -4.151  1.00  9.28           N  \nATOM   4803  O   ILE A  30       9.001  -2.651  -6.945  1.00 10.96           O  \nATOM   4804  C   ARG A  31       6.396  -3.716  -6.486  1.00 10.46           C  \nATOM   4805  CA  ARG A  31       7.425  -4.246  -5.483  1.00 10.55           C  \nATOM   4806  CB  ARG A  31       6.670  -5.070  -4.417  1.00 11.15           C  \nATOM   4807  CD  ARG A  31       5.351  -7.206  -4.047  1.00 17.36           C  \nATOM   4808  CG  ARG A  31       5.822  -6.166  -5.049  1.00 14.44           C  \nATOM   4809  CZ  ARG A  31       4.661  -9.232  -5.326  1.00 23.96           C  \nATOM   4810  N   ARG A  31       8.240  -3.198  -4.930  1.00  9.84           N  \nATOM   4811  NE  ARG A  31       4.376  -8.124  -4.658  1.00 20.16           N  \nATOM   4812  NH1 ARG A  31       5.934  -9.588  -5.471  1.00 29.58           N  \nATOM   4813  NH2 ARG A  31       3.704  -9.999  -5.848  1.00 32.31           N  \nATOM   4814  O   ARG A  31       6.178  -4.261  -7.556  1.00 11.86           O  \nATOM   4815  C   LEU A  32       5.379  -1.557  -8.332  1.00 10.05           C  \nATOM   4816  CA  LEU A  32       4.760  -1.968  -6.993  1.00 10.07           C  \nATOM   4817  CB  LEU A  32       4.229  -0.732  -6.276  1.00  9.82           C  \nATOM   4818  CD1 LEU A  32       1.934  -0.623  -7.310  1.00 11.45           C  \nATOM   4819  CD2 LEU A  32       2.966   1.445  -6.398  1.00 10.99           C  \nATOM   4820  CG  LEU A  32       3.251   0.115  -7.075  1.00  9.95           C  \nATOM   4821  N   LEU A  32       5.754  -2.614  -6.105  1.00  9.74           N  \nATOM   4822  O   LEU A  32       4.859  -1.809  -9.385  1.00 11.05           O  \nATOM   4823  C   PHE A  33       7.720  -1.447 -10.328  1.00 11.17           C  \nATOM   4824  CA  PHE A  33       7.196  -0.350  -9.439  1.00  9.98           C  \nATOM   4825  CB  PHE A  33       8.321   0.580  -9.027  1.00 10.60           C  \nATOM   4826  CD1 PHE A  33       6.667   2.421  -8.515  1.00 10.96           C  \nATOM   4827  CD2 PHE A  33       8.815   2.542  -7.501  1.00 11.86           C  \nATOM   4828  CE1 PHE A  33       6.312   3.613  -7.866  1.00 12.04           C  \nATOM   4829  CE2 PHE A  33       8.466   3.723  -6.886  1.00 13.76           C  \nATOM   4830  CG  PHE A  33       7.918   1.870  -8.332  1.00 10.58           C  \nATOM   4831  CZ  PHE A  33       7.229   4.275  -7.046  1.00 12.46           C  \nATOM   4832  N   PHE A  33       6.545  -0.878  -8.229  1.00  9.60           N  \nATOM   4833  O   PHE A  33       7.725  -1.294 -11.575  1.00 13.04           O  \nATOM   4834  C   LYS A  34       7.545  -4.435 -11.154  1.00 11.66           C  \nATOM   4835  CA  LYS A  34       8.705  -3.666 -10.525  1.00 11.52           C  \nATOM   4836  CB  LYS A  34       9.604  -4.565  -9.703  1.00 13.96           C  \nATOM   4837  CD  LYS A  34      11.588  -5.138  -8.404  1.00 23.79           C  \nATOM   4838  CE  LYS A  34      11.908  -6.485  -9.026  1.00 32.22           C  \nATOM   4839  CG  LYS A  34      10.952  -4.053  -9.272  1.00 17.55           C  \nATOM   4840  N   LYS A  34       8.220  -2.530  -9.770  1.00 10.68           N  \nATOM   4841  NZ  LYS A  34      13.278  -6.407  -9.576  1.00 39.40           N  \nATOM   4842  O   LYS A  34       7.611  -4.852 -12.308  1.00 13.84           O  \nATOM   4843  C   SER A  35       4.511  -4.763 -11.824  1.00 12.15           C  \nATOM   4844  CA  SER A  35       5.411  -5.499 -10.850  1.00 12.65           C  \nATOM   4845  CB  SER A  35       4.550  -5.963  -9.642  1.00 14.31           C  \nATOM   4846  N   SER A  35       6.515  -4.713 -10.357  1.00 11.97           N  \nATOM   4847  O   SER A  35       3.824  -5.391 -12.646  1.00 13.48           O  \nATOM   4848  OG  SER A  35       5.234  -6.918  -8.885  1.00 18.66           O  \nATOM   4849  C   HIS A  36       4.261  -1.326 -12.907  1.00 11.02           C  \nATOM   4850  CA  HIS A  36       3.553  -2.616 -12.488  1.00 11.02           C  \nATOM   4851  CB  HIS A  36       2.268  -2.271 -11.719  1.00 11.54           C  \nATOM   4852  CD2 HIS A  36       1.667  -4.143 -10.008  1.00 14.19           C  \nATOM   4853  CE1 HIS A  36       0.342  -5.346 -11.235  1.00 15.62           C  \nATOM   4854  CG  HIS A  36       1.582  -3.504 -11.222  1.00 13.42           C  \nATOM   4855  N   HIS A  36       4.466  -3.430 -11.712  1.00 11.54           N  \nATOM   4856  ND1 HIS A  36       0.755  -4.298 -11.989  1.00 13.42           N  \nATOM   4857  NE2 HIS A  36       0.884  -5.268 -10.022  1.00 15.98           N  \nATOM   4858  O   HIS A  36       4.077  -0.280 -12.319  1.00 11.24           O  \nATOM   4859  C   PRO A  37       5.191   1.011 -14.657  1.00 11.16           C  \nATOM   4860  CA  PRO A  37       5.947  -0.249 -14.301  1.00 12.38           C  \nATOM   4861  CB  PRO A  37       6.775  -0.818 -15.472  1.00 14.22           C  \nATOM   4862  CD  PRO A  37       5.470  -2.639 -14.695  1.00 12.45           C  \nATOM   4863  CG  PRO A  37       6.855  -2.305 -15.169  1.00 13.89           C  \nATOM   4864  N   PRO A  37       5.126  -1.412 -13.946  1.00 11.05           N  \nATOM   4865  O   PRO A  37       5.800   2.106 -14.563  1.00 12.13           O  \nATOM   4866  C   GLU A  38       3.039   2.986 -14.106  1.00 12.46           C  \nATOM   4867  CA  GLU A  38       3.178   2.132 -15.348  1.00 13.15           C  \nATOM   4868  CB  GLU A  38       1.793   1.775 -15.935  1.00 13.37           C  \nATOM   4869  CD  GLU A  38       0.998  -0.500 -15.012  1.00 11.96           C  \nATOM   4870  CG  GLU A  38       0.861   1.001 -15.052  1.00 12.98           C  \nATOM   4871  N   GLU A  38       3.963   0.931 -15.097  1.00 11.57           N  \nATOM   4872  O   GLU A  38       2.899   4.186 -14.223  1.00 15.32           O  \nATOM   4873  OE1 GLU A  38       2.123  -1.059 -15.044  1.00 12.30           O  \nATOM   4874  OE2 GLU A  38      -0.083  -1.138 -14.939  1.00 13.19           O  \nATOM   4875  C   THR A  39       4.196   4.070 -11.479  1.00 11.48           C  \nATOM   4876  CA  THR A  39       3.004   3.165 -11.709  1.00 10.83           C  \nATOM   4877  CB  THR A  39       2.775   2.247 -10.485  1.00 10.00           C  \nATOM   4878  CG2 THR A  39       1.486   1.425 -10.653  1.00 11.35           C  \nATOM   4879  N   THR A  39       3.146   2.376 -12.919  1.00 10.48           N  \nATOM   4880  O   THR A  39       4.008   5.186 -11.012  1.00 11.76           O  \nATOM   4881  OG1 THR A  39       3.896   1.418 -10.212  1.00 10.68           O  \nATOM   4882  C   LEU A  40       6.479   5.681 -12.432  1.00 12.58           C  \nATOM   4883  CA  LEU A  40       6.595   4.382 -11.651  1.00 12.97           C  \nATOM   4884  CB  LEU A  40       7.771   3.525 -12.091  1.00 13.65           C  \nATOM   4885  CD1 LEU A  40       9.455   4.458 -10.511  1.00 14.96           C  \nATOM   4886  CD2 LEU A  40      10.139   3.147 -12.564  1.00 16.03           C  \nATOM   4887  CG  LEU A  40       9.158   4.147 -11.963  1.00 12.87           C  \nATOM   4888  N   LEU A  40       5.390   3.598 -11.841  1.00 11.81           N  \nATOM   4889  O   LEU A  40       6.928   6.759 -12.062  1.00 13.57           O  \nATOM   4890  C   GLU A  41       4.993   7.820 -13.981  1.00 15.18           C  \nATOM   4891  CA  GLU A  41       5.819   6.667 -14.564  1.00 17.10           C  \nATOM   4892  CB  GLU A  41       5.359   6.219 -15.972  1.00 18.00           C  \nATOM   4893  CD  GLU A  41       7.091   7.620 -17.304  1.00 22.02           C  \nATOM   4894  CG  GLU A  41       5.658   7.274 -17.004  1.00 18.18           C  \nATOM   4895  N   GLU A  41       5.890   5.561 -13.631  1.00 14.52           N  \nATOM   4896  O   GLU A  41       5.107   8.970 -14.453  1.00 19.06           O  \nATOM   4897  OE1 GLU A  41       8.004   6.977 -16.740  1.00 22.64           O  \nATOM   4898  OE2 GLU A  41       7.300   8.547 -18.115  1.00 21.18           O  \nATOM   4899  C   LYS A  42       4.095   9.515 -11.502  1.00 13.05           C  \nATOM   4900  CA  LYS A  42       3.300   8.595 -12.419  1.00 13.50           C  \nATOM   4901  CB  LYS A  42       2.115   8.012 -11.593  1.00 14.51           C  \nATOM   4902  CD  LYS A  42       0.172   8.345 -13.176  1.00 17.61           C  \nATOM   4903  CE  LYS A  42      -0.873   7.639 -14.018  1.00 21.07           C  \nATOM   4904  CG  LYS A  42       1.066   7.340 -12.439  1.00 14.90           C  \nATOM   4905  N   LYS A  42       4.091   7.564 -13.032  1.00 14.30           N  \nATOM   4906  NZ  LYS A  42      -1.776   8.570 -14.734  1.00 22.12           N  \nATOM   4907  O   LYS A  42       3.574  10.515 -11.016  1.00 14.64           O  \nATOM   4908  C   PHE A  43       7.313  10.619 -10.999  1.00 12.72           C  \nATOM   4909  CA  PHE A  43       6.190   9.900 -10.276  1.00 13.12           C  \nATOM   4910  CB  PHE A  43       6.826   8.929  -9.262  1.00 11.69           C  \nATOM   4911  CD1 PHE A  43       5.652   9.146  -7.065  1.00 11.25           C  \nATOM   4912  CD2 PHE A  43       5.254   7.202  -8.371  1.00 12.77           C  \nATOM   4913  CE1 PHE A  43       4.835   8.705  -6.085  1.00 12.44           C  \nATOM   4914  CE2 PHE A  43       4.376   6.737  -7.356  1.00 13.87           C  \nATOM   4915  CG  PHE A  43       5.864   8.414  -8.211  1.00 11.19           C  \nATOM   4916  CZ  PHE A  43       4.239   7.473  -6.172  1.00 12.92           C  \nATOM   4917  N   PHE A  43       5.324   9.157 -11.183  1.00 12.43           N  \nATOM   4918  O   PHE A  43       8.300   9.974 -11.360  1.00 12.29           O  \nATOM   4919  C   ASP A  44       9.490  12.480 -10.768  1.00 15.43           C  \nATOM   4920  CA  ASP A  44       8.289  12.660 -11.719  1.00 16.73           C  \nATOM   4921  CB  ASP A  44       7.911  14.128 -11.874  1.00 22.03           C  \nATOM   4922  CG  ASP A  44       6.841  14.389 -12.926  1.00 23.44           C  \nATOM   4923  N   ASP A  44       7.149  11.907 -11.206  1.00 15.30           N  \nATOM   4924  O   ASP A  44      10.629  12.518 -11.272  1.00 17.65           O  \nATOM   4925  OD1 ASP A  44       6.643  13.543 -13.825  1.00 29.88           O  \nATOM   4926  OD2 ASP A  44       6.211  15.448 -12.773  1.00 27.87           O  \nATOM   4927  C   ARG A  45      11.194  10.825  -8.811  1.00 12.87           C  \nATOM   4928  CA  ARG A  45      10.403  12.084  -8.473  1.00 14.52           C  \nATOM   4929  CB  ARG A  45       9.774  12.011  -7.041  1.00 16.58           C  \nATOM   4930  CD  ARG A  45       8.604  13.368  -5.227  1.00 18.75           C  \nATOM   4931  CG  ARG A  45       9.536  13.348  -6.396  1.00 17.79           C  \nATOM   4932  CZ  ARG A  45       8.656  12.511  -2.914  1.00 19.09           C  \nATOM   4933  N   ARG A  45       9.309  12.275  -9.462  1.00 14.71           N  \nATOM   4934  NE  ARG A  45       9.289  12.816  -4.039  1.00 16.58           N  \nATOM   4935  NH1 ARG A  45       7.344  12.728  -2.791  1.00 20.05           N  \nATOM   4936  NH2 ARG A  45       9.351  12.001  -1.899  1.00 18.68           N  \nATOM   4937  O   ARG A  45      12.323  10.766  -8.386  1.00 13.86           O  \nATOM   4938  C   PHE A  46      11.367   7.883 -10.804  1.00 12.25           C  \nATOM   4939  CA  PHE A  46      11.143   8.484  -9.433  1.00 11.92           C  \nATOM   4940  CB  PHE A  46      10.322   7.470  -8.592  1.00 11.71           C  \nATOM   4941  CD1 PHE A  46      11.254   8.486  -6.432  1.00 11.74           C  \nATOM   4942  CD2 PHE A  46       8.947   8.004  -6.519  1.00 12.81           C  \nATOM   4943  CE1 PHE A  46      11.094   8.987  -5.147  1.00 12.60           C  \nATOM   4944  CE2 PHE A  46       8.786   8.497  -5.234  1.00 13.33           C  \nATOM   4945  CG  PHE A  46      10.202   7.984  -7.163  1.00 11.71           C  \nATOM   4946  CZ  PHE A  46       9.862   9.025  -4.543  1.00 12.17           C  \nATOM   4947  N   PHE A  46      10.553   9.816  -9.433  1.00 11.71           N  \nATOM   4948  O   PHE A  46      12.004   6.841 -10.945  1.00 12.89           O  \nATOM   4949  C   LYS A  47      12.211   7.776 -13.718  1.00 15.05           C  \nATOM   4950  CA  LYS A  47      10.830   7.824 -13.116  1.00 15.66           C  \nATOM   4951  CB  LYS A  47       9.792   8.474 -14.026  1.00 19.65           C  \nATOM   4952  CD  LYS A  47       8.810  10.521 -15.006  1.00 27.46           C  \nATOM   4953  CE  LYS A  47       9.008  11.761 -15.808  1.00 28.65           C  \nATOM   4954  CG  LYS A  47      10.030   9.958 -14.269  1.00 19.81           C  \nATOM   4955  N   LYS A  47      10.800   8.518 -11.828  1.00 13.95           N  \nATOM   4956  NZ  LYS A  47      10.153  11.796 -16.750  1.00 29.03           N  \nATOM   4957  O   LYS A  47      12.397   6.994 -14.689  1.00 17.37           O  \nATOM   4958  C   HIS A  48      15.228   6.852 -13.096  1.00 15.04           C  \nATOM   4959  CA  HIS A  48      14.626   8.171 -13.565  1.00 14.85           C  \nATOM   4960  CB  HIS A  48      15.530   9.321 -13.063  1.00 15.19           C  \nATOM   4961  CD2 HIS A  48      16.681   8.817 -10.817  1.00 13.79           C  \nATOM   4962  CE1 HIS A  48      15.150   9.722  -9.540  1.00 15.43           C  \nATOM   4963  CG  HIS A  48      15.697   9.325 -11.591  1.00 12.82           C  \nATOM   4964  N   HIS A  48      13.258   8.404 -13.168  1.00 13.97           N  \nATOM   4965  ND1 HIS A  48      14.722   9.868 -10.795  1.00 15.05           N  \nATOM   4966  NE2 HIS A  48      16.313   9.063  -9.510  1.00 13.94           N  \nATOM   4967  O   HIS A  48      16.298   6.425 -13.512  1.00 17.63           O  \nATOM   4968  C   LEU A  49      14.844   3.803 -12.613  1.00 12.62           C  \nATOM   4969  CA  LEU A  49      15.080   4.943 -11.620  1.00 11.83           C  \nATOM   4970  CB  LEU A  49      14.388   4.691 -10.285  1.00 11.72           C  \nATOM   4971  CD1 LEU A  49      13.697   5.505  -8.031  1.00 11.22           C  \nATOM   4972  CD2 LEU A  49      16.079   5.723  -8.721  1.00 12.34           C  \nATOM   4973  CG  LEU A  49      14.626   5.730  -9.212  1.00 11.52           C  \nATOM   4974  N   LEU A  49      14.559   6.184 -12.163  1.00 12.08           N  \nATOM   4975  O   LEU A  49      13.723   3.615 -13.043  1.00 16.02           O  \nATOM   4976  C   LYS A  50      16.094   0.609 -13.473  1.00 13.28           C  \nATOM   4977  CA  LYS A  50      15.890   2.050 -13.983  1.00 14.31           C  \nATOM   4978  CB  LYS A  50      16.998   2.325 -15.026  1.00 18.16           C  \nATOM   4979  CD  LYS A  50      15.629   4.195 -16.214  1.00 30.11           C  \nATOM   4980  CE  LYS A  50      15.858   5.606 -16.782  1.00 33.26           C  \nATOM   4981  CG  LYS A  50      16.922   3.559 -15.833  1.00 22.18           C  \nATOM   4982  N   LYS A  50      15.868   3.035 -12.926  1.00 12.51           N  \nATOM   4983  NZ  LYS A  50      14.576   6.345 -16.929  1.00 37.13           N  \nATOM   4984  O   LYS A  50      15.899  -0.356 -14.263  1.00 13.66           O  \nATOM   4985  C   THR A  51      16.417  -0.898 -10.246  1.00  9.91           C  \nATOM   4986  CA  THR A  51      16.931  -0.825 -11.686  1.00  9.94           C  \nATOM   4987  CB  THR A  51      18.456  -1.141 -11.663  1.00 11.16           C  \nATOM   4988  CG2 THR A  51      19.113  -0.901 -12.988  1.00 13.34           C  \nATOM   4989  N   THR A  51      16.608   0.449 -12.271  1.00 10.41           N  \nATOM   4990  O   THR A  51      16.264   0.116  -9.574  1.00 10.15           O  \nATOM   4991  OG1 THR A  51      19.020  -0.304 -10.657  1.00 11.86           O  \nATOM   4992  C   GLU A  52      16.956  -1.753  -7.464  1.00  9.26           C  \nATOM   4993  CA  GLU A  52      15.879  -2.343  -8.387  1.00  9.87           C  \nATOM   4994  CB  GLU A  52      15.640  -3.825  -8.111  1.00  9.65           C  \nATOM   4995  CD  GLU A  52      14.684  -5.527  -6.475  1.00 14.01           C  \nATOM   4996  CG  GLU A  52      15.198  -4.124  -6.699  1.00 11.74           C  \nATOM   4997  N   GLU A  52      16.230  -2.123  -9.778  1.00  9.91           N  \nATOM   4998  O   GLU A  52      16.623  -1.176  -6.432  1.00 10.23           O  \nATOM   4999  OE1 GLU A  52      14.694  -6.338  -7.400  1.00 15.20           O  \nATOM   5000  OE2 GLU A  52      14.268  -5.784  -5.335  1.00 19.78           O  \nATOM   5001  C   ALA A  53      19.159   0.060  -6.819  1.00 10.45           C  \nATOM   5002  CA  ALA A  53      19.255  -1.450  -6.891  1.00 10.98           C  \nATOM   5003  CB  ALA A  53      20.645  -1.825  -7.417  1.00 15.42           C  \nATOM   5004  N   ALA A  53      18.211  -1.979  -7.776  1.00 10.40           N  \nATOM   5005  O   ALA A  53      19.343   0.653  -5.747  1.00 11.68           O  \nATOM   5006  C   GLU A  54      17.538   2.599  -7.016  1.00  9.36           C  \nATOM   5007  CA  GLU A  54      18.720   2.184  -7.891  1.00 10.66           C  \nATOM   5008  CB  GLU A  54      18.538   2.768  -9.286  1.00 10.91           C  \nATOM   5009  CD  GLU A  54      19.610   3.156 -11.568  1.00 15.62           C  \nATOM   5010  CG  GLU A  54      19.809   2.789 -10.109  1.00 12.79           C  \nATOM   5011  N   GLU A  54      18.867   0.744  -7.963  1.00 10.68           N  \nATOM   5012  O   GLU A  54      17.616   3.553  -6.243  1.00  9.81           O  \nATOM   5013  OE1 GLU A  54      18.452   3.438 -11.940  1.00 16.86           O  \nATOM   5014  OE2 GLU A  54      20.599   3.161 -12.325  1.00 20.68           O  \nATOM   5015  C   MET A  55      15.656   1.942  -4.822  1.00  9.13           C  \nATOM   5016  CA  MET A  55      15.271   2.104  -6.297  1.00  8.86           C  \nATOM   5017  CB  MET A  55      14.132   1.196  -6.656  1.00  9.14           C  \nATOM   5018  CE  MET A  55      12.158   0.432 -10.212  1.00 14.19           C  \nATOM   5019  CG  MET A  55      13.585   1.418  -8.067  1.00  9.67           C  \nATOM   5020  N   MET A  55      16.428   1.852  -7.143  1.00  9.19           N  \nATOM   5021  O   MET A  55      15.271   2.764  -3.975  1.00  9.98           O  \nATOM   5022  SD  MET A  55      12.373   0.161  -8.443  1.00 11.87           S  \nATOM   5023  C   LYS A  56      17.715   1.661  -2.554  1.00 10.32           C  \nATOM   5024  CA  LYS A  56      16.742   0.608  -3.097  1.00 10.99           C  \nATOM   5025  CB  LYS A  56      17.407  -0.763  -3.045  1.00 13.56           C  \nATOM   5026  CD  LYS A  56      16.303  -2.738  -2.087  1.00 21.92           C  \nATOM   5027  CE  LYS A  56      17.213  -1.965  -1.120  1.00 30.02           C  \nATOM   5028  CG  LYS A  56      16.414  -1.881  -3.348  1.00 15.55           C  \nATOM   5029  N   LYS A  56      16.365   0.875  -4.490  1.00  9.21           N  \nATOM   5030  NZ  LYS A  56      16.474  -1.611   0.112  1.00 40.94           N  \nATOM   5031  O   LYS A  56      17.755   1.841  -1.323  1.00 14.21           O  \nATOM   5032  C   ALA A  57      18.819   4.743  -2.932  1.00  9.74           C  \nATOM   5033  CA  ALA A  57      19.407   3.352  -3.021  1.00 10.44           C  \nATOM   5034  CB  ALA A  57      20.602   3.338  -3.943  1.00 11.69           C  \nATOM   5035  N   ALA A  57      18.450   2.338  -3.405  1.00 10.11           N  \nATOM   5036  O   ALA A  57      19.529   5.668  -2.550  1.00 12.75           O  \nATOM   5037  C   SER A  58      16.368   6.677  -2.028  1.00  8.46           C  \nATOM   5038  CA  SER A  58      16.986   6.279  -3.372  1.00  8.69           C  \nATOM   5039  CB  SER A  58      15.882   6.337  -4.407  1.00  9.24           C  \nATOM   5040  N   SER A  58      17.575   4.952  -3.335  1.00  8.81           N  \nATOM   5041  O   SER A  58      15.400   6.091  -1.543  1.00  9.59           O  \nATOM   5042  OG  SER A  58      15.181   7.557  -4.328  1.00  9.47           O  \nATOM   5043  C   GLU A  59      15.080   8.825  -0.318  1.00  8.83           C  \nATOM   5044  CA  GLU A  59      16.446   8.185  -0.130  1.00  9.34           C  \nATOM   5045  CB  GLU A  59      17.465   9.105   0.530  1.00 10.04           C  \nATOM   5046  CD  GLU A  59      17.123   8.285   2.933  1.00 10.51           C  \nATOM   5047  CG  GLU A  59      17.102   9.449   1.978  1.00 10.30           C  \nATOM   5048  N   GLU A  59      16.946   7.688  -1.403  1.00  9.25           N  \nATOM   5049  O   GLU A  59      14.191   8.720   0.530  1.00 10.06           O  \nATOM   5050  OE1 GLU A  59      17.630   7.230   2.521  1.00 12.00           O  \nATOM   5051  OE2 GLU A  59      16.691   8.480   4.080  1.00 12.98           O  \nATOM   5052  C   ASP A  60      12.543   9.113  -1.844  1.00  9.01           C  \nATOM   5053  CA  ASP A  60      13.621  10.156  -1.697  1.00 10.39           C  \nATOM   5054  CB  ASP A  60      13.754  11.067  -2.927  1.00 11.91           C  \nATOM   5055  CG  ASP A  60      12.595  12.081  -2.926  1.00 13.50           C  \nATOM   5056  N   ASP A  60      14.896   9.519  -1.427  1.00  9.16           N  \nATOM   5057  O   ASP A  60      11.402   9.390  -1.441  1.00  9.47           O  \nATOM   5058  OD1 ASP A  60      12.365  12.744  -1.861  1.00 16.72           O  \nATOM   5059  OD2 ASP A  60      11.916  12.157  -3.888  1.00 16.56           O  \nATOM   5060  C   LEU A  61      11.434   6.443  -1.140  1.00  7.99           C  \nATOM   5061  CA  LEU A  61      11.800   6.907  -2.546  1.00  9.16           C  \nATOM   5062  CB  LEU A  61      12.354   5.781  -3.407  1.00  8.30           C  \nATOM   5063  CD1 LEU A  61      11.789   3.935  -4.990  1.00  9.61           C  \nATOM   5064  CD2 LEU A  61      11.418   3.563  -2.546  1.00  8.64           C  \nATOM   5065  CG  LEU A  61      11.425   4.598  -3.658  1.00  9.21           C  \nATOM   5066  N   LEU A  61      12.803   7.963  -2.430  1.00  9.14           N  \nATOM   5067  O   LEU A  61      10.240   6.241  -0.828  1.00  8.66           O  \nATOM   5068  C   LYS A  62      11.306   6.900   1.818  1.00  8.55           C  \nATOM   5069  CA  LYS A  62      12.173   5.868   1.124  1.00  9.22           C  \nATOM   5070  CB  LYS A  62      13.490   5.664   1.867  1.00 10.72           C  \nATOM   5071  CD  LYS A  62      14.955   4.592   3.587  1.00 16.90           C  \nATOM   5072  CE  LYS A  62      14.931   4.039   5.023  1.00 14.45           C  \nATOM   5073  CG  LYS A  62      13.496   5.011   3.209  1.00 12.76           C  \nATOM   5074  N   LYS A  62      12.418   6.238  -0.276  1.00  8.51           N  \nATOM   5075  NZ  LYS A  62      16.279   3.561   5.240  1.00 13.87           N  \nATOM   5076  O   LYS A  62      10.389   6.546   2.570  1.00  9.41           O  \nATOM   5077  C   LYS A  63       9.286   9.129   1.697  1.00  8.81           C  \nATOM   5078  CA  LYS A  63      10.720   9.265   2.164  1.00  9.25           C  \nATOM   5079  CB  LYS A  63      11.379  10.599   1.829  1.00 12.08           C  \nATOM   5080  CD  LYS A  63      13.190  12.241   2.344  1.00 17.96           C  \nATOM   5081  CE  LYS A  63      12.115  13.323   2.367  1.00 21.61           C  \nATOM   5082  CG  LYS A  63      12.591  10.927   2.718  1.00 13.68           C  \nATOM   5083  N   LYS A  63      11.539   8.188   1.568  1.00  8.93           N  \nATOM   5084  NZ  LYS A  63      12.088  14.027   3.662  1.00 29.87           N  \nATOM   5085  O   LYS A  63       8.344   9.247   2.497  1.00  9.82           O  \nATOM   5086  C   HIS A  64       6.986   7.543   0.500  1.00  8.17           C  \nATOM   5087  CA  HIS A  64       7.666   8.764  -0.053  1.00  8.69           C  \nATOM   5088  CB  HIS A  64       7.560   8.841  -1.596  1.00  8.56           C  \nATOM   5089  CD2 HIS A  64       5.153   8.625  -2.489  1.00 10.18           C  \nATOM   5090  CE1 HIS A  64       4.478  10.615  -1.972  1.00 12.12           C  \nATOM   5091  CG  HIS A  64       6.150   9.289  -1.908  1.00  9.73           C  \nATOM   5092  N   HIS A  64       9.036   8.891   0.403  1.00  8.83           N  \nATOM   5093  ND1 HIS A  64       5.736  10.545  -1.587  1.00 11.00           N  \nATOM   5094  NE2 HIS A  64       4.056   9.486  -2.527  1.00 11.49           N  \nATOM   5095  O   HIS A  64       5.795   7.547   0.787  1.00  9.32           O  \nATOM   5096  C   GLY A  65       6.670   5.601   2.726  1.00  8.54           C  \nATOM   5097  CA  GLY A  65       7.170   5.254   1.330  1.00  8.65           C  \nATOM   5098  N   GLY A  65       7.763   6.449   0.681  1.00  8.41           N  \nATOM   5099  O   GLY A  65       5.609   5.130   3.113  1.00  8.93           O  \nATOM   5100  C   VAL A  66       5.687   7.700   4.624  1.00  8.85           C  \nATOM   5101  CA  VAL A  66       6.960   6.834   4.763  1.00  9.09           C  \nATOM   5102  CB  VAL A  66       8.073   7.591   5.520  1.00 10.00           C  \nATOM   5103  CG1 VAL A  66       7.542   8.269   6.764  1.00 11.35           C  \nATOM   5104  CG2 VAL A  66       9.249   6.663   5.846  1.00 10.96           C  \nATOM   5105  N   VAL A  66       7.414   6.404   3.452  1.00  8.86           N  \nATOM   5106  O   VAL A  66       4.757   7.495   5.419  1.00  9.16           O  \nATOM   5107  C   THR A  67       3.225   8.571   3.226  1.00  8.49           C  \nATOM   5108  CA  THR A  67       4.463   9.422   3.497  1.00  8.72           C  \nATOM   5109  CB  THR A  67       4.719  10.399   2.325  1.00 10.64           C  \nATOM   5110  CG2 THR A  67       3.455  11.216   2.021  1.00 13.55           C  \nATOM   5111  N   THR A  67       5.671   8.605   3.679  1.00  8.57           N  \nATOM   5112  O   THR A  67       2.171   8.755   3.846  1.00 10.15           O  \nATOM   5113  OG1 THR A  67       5.803  11.245   2.724  1.00 13.16           O  \nATOM   5114  C   VAL A  68       1.827   5.886   3.157  1.00  8.33           C  \nATOM   5115  CA  VAL A  68       2.249   6.727   1.952  1.00  8.38           C  \nATOM   5116  CB  VAL A  68       2.636   5.849   0.771  1.00  8.69           C  \nATOM   5117  CG1 VAL A  68       1.614   4.727   0.513  1.00  9.23           C  \nATOM   5118  CG2 VAL A  68       2.861   6.734  -0.485  1.00 10.29           C  \nATOM   5119  N   VAL A  68       3.388   7.597   2.322  1.00  8.27           N  \nATOM   5120  O   VAL A  68       0.622   5.838   3.513  1.00  9.00           O  \nATOM   5121  C   LEU A  69       1.876   5.067   6.110  1.00  9.55           C  \nATOM   5122  CA  LEU A  69       2.374   4.300   4.881  1.00  9.42           C  \nATOM   5123  CB  LEU A  69       3.438   3.330   5.242  1.00  9.51           C  \nATOM   5124  CD1 LEU A  69       4.789   1.297   4.803  1.00 10.93           C  \nATOM   5125  CD2 LEU A  69       2.656   1.629   3.488  1.00 11.41           C  \nATOM   5126  CG  LEU A  69       3.818   2.314   4.158  1.00  9.48           C  \nATOM   5127  N   LEU A  69       2.743   5.193   3.806  1.00  8.24           N  \nATOM   5128  O   LEU A  69       1.026   4.567   6.862  1.00 10.52           O  \nATOM   5129  C   THR A  70       0.406   7.384   7.224  1.00  9.74           C  \nATOM   5130  CA  THR A  70       1.868   7.091   7.457  1.00 10.54           C  \nATOM   5131  CB  THR A  70       2.723   8.372   7.624  1.00 13.02           C  \nATOM   5132  CG2 THR A  70       2.205   9.266   8.738  1.00 18.50           C  \nATOM   5133  N   THR A  70       2.383   6.262   6.339  1.00  9.60           N  \nATOM   5134  O   THR A  70      -0.415   7.237   8.165  1.00 11.04           O  \nATOM   5135  OG1 THR A  70       4.053   7.973   7.933  1.00 14.99           O  \nATOM   5136  C   ALA A  71      -2.205   6.840   5.837  1.00  9.26           C  \nATOM   5137  CA  ALA A  71      -1.368   8.098   5.714  1.00  9.47           C  \nATOM   5138  CB  ALA A  71      -1.434   8.713   4.332  1.00 10.96           C  \nATOM   5139  N   ALA A  71       0.042   7.800   6.016  1.00  9.54           N  \nATOM   5140  O   ALA A  71      -3.323   6.879   6.398  1.00  9.82           O  \nATOM   5141  C   LEU A  72      -2.689   4.084   6.884  1.00  9.05           C  \nATOM   5142  CA  LEU A  72      -2.503   4.483   5.422  1.00  9.26           C  \nATOM   5143  CB  LEU A  72      -1.842   3.383   4.608  1.00  9.58           C  \nATOM   5144  CD1 LEU A  72      -4.028   2.220   4.009  1.00 11.94           C  \nATOM   5145  CD2 LEU A  72      -1.798   1.049   3.735  1.00 10.90           C  \nATOM   5146  CG  LEU A  72      -2.588   2.061   4.539  1.00  9.97           C  \nATOM   5147  N   LEU A  72      -1.722   5.708   5.322  1.00  9.58           N  \nATOM   5148  O   LEU A  72      -3.791   3.632   7.209  1.00  9.57           O  \nATOM   5149  C   GLY A  73      -2.871   4.623   9.762  1.00  9.90           C  \nATOM   5150  CA  GLY A  73      -1.816   3.774   9.072  1.00 10.64           C  \nATOM   5151  N   GLY A  73      -1.666   4.153   7.714  1.00  9.95           N  \nATOM   5152  O   GLY A  73      -3.684   4.092  10.524  1.00 10.94           O  \nATOM   5153  C   ALA A  74      -5.300   6.386   9.679  1.00 11.31           C  \nATOM   5154  CA  ALA A  74      -3.887   6.818  10.116  1.00 11.66           C  \nATOM   5155  CB  ALA A  74      -3.606   8.272   9.742  1.00 13.16           C  \nATOM   5156  N   ALA A  74      -2.889   5.932   9.502  1.00 10.36           N  \nATOM   5157  O   ALA A  74      -6.224   6.452  10.477  1.00 13.33           O  \nATOM   5158  C   ILE A  75      -7.131   4.248   8.604  1.00 10.07           C  \nATOM   5159  CA  ILE A  75      -6.777   5.526   7.918  1.00 10.55           C  \nATOM   5160  CB  ILE A  75      -6.678   5.355   6.405  1.00 10.66           C  \nATOM   5161  CD1 ILE A  75      -6.146   6.656   4.271  1.00 14.25           C  \nATOM   5162  CG1 ILE A  75      -6.612   6.691   5.707  1.00 11.57           C  \nATOM   5163  CG2 ILE A  75      -7.778   4.460   5.843  1.00 11.33           C  \nATOM   5164  N   ILE A  75      -5.463   5.984   8.434  1.00 10.36           N  \nATOM   5165  O   ILE A  75      -8.264   4.105   9.117  1.00 10.92           O  \nATOM   5166  C   LEU A  76      -6.996   2.094  10.675  1.00 10.48           C  \nATOM   5167  CA  LEU A  76      -6.563   1.966   9.218  1.00  9.94           C  \nATOM   5168  CB  LEU A  76      -5.385   0.990   9.079  1.00  9.63           C  \nATOM   5169  CD1 LEU A  76      -3.826  -0.332   7.650  1.00 11.37           C  \nATOM   5170  CD2 LEU A  76      -6.213  -0.190   6.974  1.00 11.84           C  \nATOM   5171  CG  LEU A  76      -5.054   0.536   7.658  1.00 10.38           C  \nATOM   5172  N   LEU A  76      -6.238   3.245   8.645  1.00  9.82           N  \nATOM   5173  O   LEU A  76      -7.910   1.362  11.088  1.00 11.34           O  \nATOM   5174  C   LYS A  77      -8.027   3.695  13.078  1.00 11.30           C  \nATOM   5175  CA  LYS A  77      -6.665   3.056  12.863  1.00 11.80           C  \nATOM   5176  CB  LYS A  77      -5.555   3.845  13.568  1.00 12.66           C  \nATOM   5177  CD  LYS A  77      -3.087   3.893  14.100  1.00 16.12           C  \nATOM   5178  CE  LYS A  77      -1.780   3.181  13.824  1.00 16.31           C  \nATOM   5179  CG  LYS A  77      -4.250   3.060  13.618  1.00 13.56           C  \nATOM   5180  N   LYS A  77      -6.338   2.945  11.453  1.00 11.01           N  \nATOM   5181  NZ  LYS A  77      -0.633   3.955  14.305  1.00 22.05           N  \nATOM   5182  O   LYS A  77      -8.510   3.629  14.214  1.00 13.15           O  \nATOM   5183  C   LYS A  78     -10.991   3.660  11.989  1.00 12.84           C  \nATOM   5184  CA  LYS A  78      -9.992   4.799  12.158  1.00 12.66           C  \nATOM   5185  CB  LYS A  78     -10.283   5.854  11.106  1.00 13.95           C  \nATOM   5186  CD  LYS A  78      -9.671   7.764  12.531  1.00 23.69           C  \nATOM   5187  CE  LYS A  78     -11.024   8.427  12.586  1.00 26.73           C  \nATOM   5188  CG  LYS A  78      -9.514   7.127  11.162  1.00 16.56           C  \nATOM   5189  N   LYS A  78      -8.636   4.311  12.069  1.00 10.75           N  \nATOM   5190  NZ  LYS A  78     -11.152   9.602  11.690  1.00 42.41           N  \nATOM   5191  O   LYS A  78     -12.193   3.900  12.221  1.00 13.71           O  \nATOM   5192  C   LYS A  79     -12.742   1.626  10.766  1.00 12.03           C  \nATOM   5193  CA  LYS A  79     -11.469   1.303  11.537  1.00 11.07           C  \nATOM   5194  CB  LYS A  79     -11.801   0.757  12.933  1.00 11.74           C  \nATOM   5195  CD  LYS A  79     -10.748   0.115  15.165  1.00 15.43           C  \nATOM   5196  CE  LYS A  79     -11.640  -0.979  15.533  1.00 16.04           C  \nATOM   5197  CG  LYS A  79     -10.545   0.302  13.686  1.00 13.00           C  \nATOM   5198  N   LYS A  79     -10.584   2.458  11.624  1.00 12.02           N  \nATOM   5199  NZ  LYS A  79     -11.910  -1.078  17.020  1.00 14.88           N  \nATOM   5200  O   LYS A  79     -13.859   1.349  11.190  1.00 13.27           O  \nATOM   5201  C   GLY A  80     -14.147   3.938   8.774  1.00 13.45           C  \nATOM   5202  CA  GLY A  80     -13.650   2.512   8.676  1.00 12.32           C  \nATOM   5203  N   GLY A  80     -12.538   2.213   9.569  1.00 12.57           N  \nATOM   5204  O   GLY A  80     -14.794   4.418   7.849  1.00 14.37           O  \nATOM   5205  C   HIS A  81     -13.429   7.007   9.637  1.00 13.66           C  \nATOM   5206  CA  HIS A  81     -14.425   5.945  10.075  1.00 14.63           C  \nATOM   5207  CB  HIS A  81     -14.773   6.147  11.544  1.00 18.57           C  \nATOM   5208  CD2 HIS A  81     -15.830   3.939  12.437  1.00 29.02           C  \nATOM   5209  CE1 HIS A  81     -17.829   4.786  12.679  1.00 35.13           C  \nATOM   5210  CG  HIS A  81     -15.820   5.224  12.050  1.00 24.81           C  \nATOM   5211  N   HIS A  81     -13.911   4.584   9.919  1.00 13.37           N  \nATOM   5212  ND1 HIS A  81     -17.069   5.754  12.207  1.00 32.18           N  \nATOM   5213  NE2 HIS A  81     -17.126   3.646  12.843  1.00 33.47           N  \nATOM   5214  O   HIS A  81     -12.959   7.845  10.384  1.00 15.18           O  \nATOM   5215  C   HIS A  82     -12.334   8.626   6.695  1.00 13.76           C  \nATOM   5216  CA  HIS A  82     -11.962   7.567   7.709  1.00 13.58           C  \nATOM   5217  CB  HIS A  82     -11.041   6.515   7.138  1.00 13.34           C  \nATOM   5218  CD2 HIS A  82     -12.625   5.820   5.249  1.00 14.86           C  \nATOM   5219  CE1 HIS A  82     -12.094   3.699   5.183  1.00 12.67           C  \nATOM   5220  CG  HIS A  82     -11.679   5.560   6.183  1.00 12.39           C  \nATOM   5221  N   HIS A  82     -13.086   6.896   8.335  1.00 14.46           N  \nATOM   5222  ND1 HIS A  82     -11.354   4.234   6.139  1.00 12.76           N  \nATOM   5223  NE2 HIS A  82     -12.897   4.643   4.610  1.00 12.68           N  \nATOM   5224  O   HIS A  82     -11.541   9.032   5.881  1.00 14.90           O  \nATOM   5225  C   GLU A  83     -13.104  11.334   5.766  1.00 18.15           C  \nATOM   5226  CA  GLU A  83     -14.006  10.126   5.844  1.00 16.75           C  \nATOM   5227  CB  GLU A  83     -15.433  10.573   6.221  1.00 21.12           C  \nATOM   5228  CD  GLU A  83     -16.315   8.518   7.657  1.00 32.60           C  \nATOM   5229  CG  GLU A  83     -16.404   9.486   6.523  1.00 26.17           C  \nATOM   5230  N   GLU A  83     -13.564   9.143   6.796  1.00 15.96           N  \nATOM   5231  O   GLU A  83     -12.821  11.786   4.662  1.00 19.08           O  \nATOM   5232  OE1 GLU A  83     -15.808   8.713   8.781  1.00 32.84           O  \nATOM   5233  OE2 GLU A  83     -16.878   7.386   7.474  1.00 51.56           O  \nATOM   5234  C   ALA A  84     -10.547  12.837   6.235  1.00 18.19           C  \nATOM   5235  CA  ALA A  84     -11.926  13.121   6.808  1.00 18.41           C  \nATOM   5236  CB  ALA A  84     -11.777  13.715   8.175  1.00 22.67           C  \nATOM   5237  N   ALA A  84     -12.699  11.899   6.903  1.00 17.70           N  \nATOM   5238  O   ALA A  84     -10.027  13.689   5.506  1.00 20.75           O  \nATOM   5239  C   GLU A  85      -8.716  11.084   4.537  1.00 14.99           C  \nATOM   5240  CA  GLU A  85      -8.666  11.352   6.021  1.00 15.95           C  \nATOM   5241  CB  GLU A  85      -8.215  10.067   6.714  1.00 20.55           C  \nATOM   5242  CD  GLU A  85      -9.018  10.325   9.155  1.00 22.90           C  \nATOM   5243  CG  GLU A  85      -7.886  10.147   8.180  1.00 22.54           C  \nATOM   5244  N   GLU A  85      -9.976  11.663   6.540  1.00 17.29           N  \nATOM   5245  O   GLU A  85      -7.805  11.427   3.789  1.00 15.20           O  \nATOM   5246  OE1 GLU A  85     -10.152   9.969   8.815  1.00 25.17           O  \nATOM   5247  OE2 GLU A  85      -8.718  10.835  10.249  1.00 28.43           O  \nATOM   5248  C   LEU A  86     -10.099  11.455   1.705  1.00 17.09           C  \nATOM   5249  CA  LEU A  86      -9.832  10.247   2.580  1.00 15.43           C  \nATOM   5250  CB  LEU A  86     -10.857   9.195   2.160  1.00 14.25           C  \nATOM   5251  CD1 LEU A  86     -11.518   6.785   2.101  1.00 19.93           C  \nATOM   5252  CD2 LEU A  86      -9.114   7.383   2.634  1.00 22.79           C  \nATOM   5253  CG  LEU A  86     -10.578   7.804   2.730  1.00 18.29           C  \nATOM   5254  N   LEU A  86      -9.822  10.522   4.007  1.00 14.98           N  \nATOM   5255  O   LEU A  86      -9.770  11.438   0.521  1.00 18.22           O  \nATOM   5256  C   LYS A  87      -9.931  14.242   0.653  1.00 19.26           C  \nATOM   5257  CA  LYS A  87     -11.107  13.619   1.381  1.00 20.95           C  \nATOM   5258  CB  LYS A  87     -11.825  14.765   2.105  1.00 26.83           C  \nATOM   5259  CD  LYS A  87     -12.072  17.258   1.570  1.00 38.78           C  \nATOM   5260  CE  LYS A  87     -12.433  18.260   0.478  1.00 43.27           C  \nATOM   5261  CG  LYS A  87     -12.189  15.827   1.065  1.00 32.20           C  \nATOM   5262  N   LYS A  87     -10.742  12.490   2.247  1.00 19.67           N  \nATOM   5263  NZ  LYS A  87     -12.910  19.548   1.068  1.00 51.22           N  \nATOM   5264  O   LYS A  87      -9.949  14.385  -0.572  1.00 19.04           O  \nATOM   5265  C   PRO A  88      -7.138  14.287  -0.267  1.00 14.84           C  \nATOM   5266  CA  PRO A  88      -7.789  15.277   0.641  1.00 18.08           C  \nATOM   5267  CB  PRO A  88      -6.870  15.848   1.714  1.00 19.15           C  \nATOM   5268  CD  PRO A  88      -8.692  14.772   2.830  1.00 20.62           C  \nATOM   5269  CG  PRO A  88      -7.204  15.036   2.903  1.00 19.10           C  \nATOM   5270  N   PRO A  88      -8.878  14.626   1.384  1.00 17.78           N  \nATOM   5271  O   PRO A  88      -6.613  14.693  -1.282  1.00 15.44           O  \nATOM   5272  C   LEU A  89      -6.970  11.738  -1.864  1.00 11.83           C  \nATOM   5273  CA  LEU A  89      -6.267  12.053  -0.572  1.00 13.04           C  \nATOM   5274  CB  LEU A  89      -6.147  10.775   0.263  1.00 12.94           C  \nATOM   5275  CD1 LEU A  89      -3.812  10.140  -0.123  1.00 17.56           C  \nATOM   5276  CD2 LEU A  89      -5.439   8.359   0.391  1.00 18.57           C  \nATOM   5277  CG  LEU A  89      -5.257   9.665  -0.304  1.00 13.30           C  \nATOM   5278  N   LEU A  89      -7.027  13.015   0.185  1.00 13.76           N  \nATOM   5279  O   LEU A  89      -6.363  11.668  -2.928  1.00 12.84           O  \nATOM   5280  C   ALA A  90      -8.951  12.418  -3.971  1.00 13.83           C  \nATOM   5281  CA  ALA A  90      -9.032  11.224  -3.015  1.00 14.00           C  \nATOM   5282  CB  ALA A  90     -10.478  10.869  -2.724  1.00 15.63           C  \nATOM   5283  N   ALA A  90      -8.286  11.470  -1.775  1.00 12.84           N  \nATOM   5284  O   ALA A  90      -8.809  12.250  -5.188  1.00 15.13           O  \nATOM   5285  C   GLN A  91      -7.660  14.934  -5.012  1.00 15.96           C  \nATOM   5286  CA  GLN A  91      -8.983  14.807  -4.275  1.00 16.80           C  \nATOM   5287  CB  GLN A  91      -9.178  16.080  -3.475  1.00 17.57           C  \nATOM   5288  CD  GLN A  91     -11.341  17.126  -4.457  1.00 23.76           C  \nATOM   5289  CG  GLN A  91     -10.607  16.496  -3.302  1.00 22.10           C  \nATOM   5290  N   GLN A  91      -9.043  13.628  -3.402  1.00 14.94           N  \nATOM   5291  NE2 GLN A  91     -10.696  17.395  -5.566  1.00 29.80           N  \nATOM   5292  O   GLN A  91      -7.587  15.137  -6.213  1.00 16.67           O  \nATOM   5293  OE1 GLN A  91     -12.551  17.367  -4.325  1.00 36.81           O  \nATOM   5294  C   SER A  92      -4.977  13.813  -5.924  1.00 14.48           C  \nATOM   5295  CA  SER A  92      -5.231  14.925  -4.908  1.00 16.28           C  \nATOM   5296  CB  SER A  92      -4.059  15.033  -3.945  1.00 16.38           C  \nATOM   5297  N   SER A  92      -6.535  14.777  -4.250  1.00 15.76           N  \nATOM   5298  O   SER A  92      -4.377  14.017  -6.998  1.00 15.62           O  \nATOM   5299  OG  SER A  92      -3.925  13.805  -3.248  1.00 15.26           O  \nATOM   5300  C   HIS A  93      -5.979  11.452  -7.660  1.00 12.84           C  \nATOM   5301  CA  HIS A  93      -5.144  11.473  -6.396  1.00 12.95           C  \nATOM   5302  CB  HIS A  93      -5.224  10.175  -5.545  1.00 12.09           C  \nATOM   5303  CD2 HIS A  93      -3.000   9.115  -4.680  1.00 11.57           C  \nATOM   5304  CE1 HIS A  93      -2.526  10.488  -3.086  1.00 11.67           C  \nATOM   5305  CG  HIS A  93      -3.998  10.036  -4.687  1.00 11.22           C  \nATOM   5306  N   HIS A  93      -5.444  12.605  -5.513  1.00 13.48           N  \nATOM   5307  ND1 HIS A  93      -3.708  10.887  -3.649  1.00 12.68           N  \nATOM   5308  NE2 HIS A  93      -2.057   9.442  -3.704  1.00 10.41           N  \nATOM   5309  O   HIS A  93      -5.510  11.029  -8.726  1.00 13.87           O  \nATOM   5310  C   ALA A  94      -7.634  13.207  -9.640  1.00 15.14           C  \nATOM   5311  CA  ALA A  94      -8.047  12.029  -8.764  1.00 13.44           C  \nATOM   5312  CB  ALA A  94      -9.509  12.254  -8.373  1.00 16.28           C  \nATOM   5313  N   ALA A  94      -7.219  11.935  -7.578  1.00 13.22           N  \nATOM   5314  O   ALA A  94      -7.668  13.096 -10.867  1.00 17.80           O  \nATOM   5315  C   THR A  95      -5.887  16.045 -10.122  1.00 20.13           C  \nATOM   5316  CA  THR A  95      -7.299  15.556  -9.870  1.00 17.91           C  \nATOM   5317  CB  THR A  95      -8.120  16.716  -9.275  1.00 19.97           C  \nATOM   5318  CG2 THR A  95      -9.508  16.293  -8.843  1.00 22.36           C  \nATOM   5319  N   THR A  95      -7.372  14.362  -9.023  1.00 16.50           N  \nATOM   5320  O   THR A  95      -5.701  16.811 -11.061  1.00 24.15           O  \nATOM   5321  OG1 THR A  95      -7.402  17.215  -8.149  1.00 21.20           O  \nATOM   5322  C   LYS A  96      -2.639  14.952  -9.923  1.00 18.70           C  \nATOM   5323  CA  LYS A  96      -3.517  16.119  -9.535  1.00 20.21           C  \nATOM   5324  CB  LYS A  96      -2.984  16.736  -8.250  1.00 21.84           C  \nATOM   5325  CD  LYS A  96      -0.854  17.674  -7.198  1.00 32.65           C  \nATOM   5326  CE  LYS A  96      -1.421  18.078  -5.846  1.00 33.77           C  \nATOM   5327  CG  LYS A  96      -1.795  17.620  -8.357  1.00 27.44           C  \nATOM   5328  N   LYS A  96      -4.882  15.654  -9.367  1.00 19.85           N  \nATOM   5329  NZ  LYS A  96      -0.677  19.233  -5.250  1.00 36.95           N  \nATOM   5330  O   LYS A  96      -2.019  14.998 -10.983  1.00 21.44           O  \nATOM   5331  C   HIS A  97      -2.155  11.917 -10.470  1.00 15.75           C  \nATOM   5332  CA  HIS A  97      -1.651  12.855  -9.382  1.00 15.21           C  \nATOM   5333  CB  HIS A  97      -1.352  12.091  -8.107  1.00 15.48           C  \nATOM   5334  CD2 HIS A  97      -1.363  12.793  -5.690  1.00 13.02           C  \nATOM   5335  CE1 HIS A  97      -0.041  14.499  -5.799  1.00 14.56           C  \nATOM   5336  CG  HIS A  97      -0.951  12.948  -6.954  1.00 13.62           C  \nATOM   5337  N   HIS A  97      -2.592  13.938  -9.058  1.00 15.83           N  \nATOM   5338  ND1 HIS A  97      -0.135  14.038  -7.028  1.00 14.09           N  \nATOM   5339  NE2 HIS A  97      -0.771  13.771  -4.950  1.00 13.36           N  \nATOM   5340  O   HIS A  97      -1.340  11.243 -11.124  1.00 17.42           O  \nATOM   5341  C   LYS A  98      -3.800   9.519 -11.453  1.00 15.44           C  \nATOM   5342  CA  LYS A  98      -4.132  11.001 -11.605  1.00 18.36           C  \nATOM   5343  CB  LYS A  98      -3.837  11.494 -13.006  1.00 23.61           C  \nATOM   5344  CD  LYS A  98      -5.161  13.640 -13.624  1.00 35.75           C  \nATOM   5345  CE  LYS A  98      -5.043  15.146 -13.801  1.00 37.86           C  \nATOM   5346  CG  LYS A  98      -3.878  12.995 -13.223  1.00 29.77           C  \nATOM   5347  N   LYS A  98      -3.484  11.841 -10.590  1.00 16.96           N  \nATOM   5348  NZ  LYS A  98      -4.600  15.851 -12.560  1.00 45.38           N  \nATOM   5349  O   LYS A  98      -3.222   8.876 -12.338  1.00 16.84           O  \nATOM   5350  C   ILE A  99      -5.165   6.748 -10.086  1.00 14.59           C  \nATOM   5351  CA  ILE A  99      -3.905   7.585  -9.956  1.00 14.33           C  \nATOM   5352  CB  ILE A  99      -3.340   7.474  -8.527  1.00 12.14           C  \nATOM   5353  CD1 ILE A  99      -1.076   8.352  -9.400  1.00 13.81           C  \nATOM   5354  CG1 ILE A  99      -2.161   8.425  -8.347  1.00 12.37           C  \nATOM   5355  CG2 ILE A  99      -2.991   6.050  -8.196  1.00 12.12           C  \nATOM   5356  N   ILE A  99      -4.184   8.966 -10.299  1.00 14.10           N  \nATOM   5357  O   ILE A  99      -6.100   6.831  -9.275  1.00 15.32           O  \nATOM   5358  C   PRO A 100      -6.674   4.202  -9.990  1.00 13.30           C  \nATOM   5359  CA  PRO A 100      -6.456   5.084 -11.242  1.00 15.00           C  \nATOM   5360  CB  PRO A 100      -6.206   4.261 -12.505  1.00 16.58           C  \nATOM   5361  CD  PRO A 100      -4.373   5.744 -12.249  1.00 14.47           C  \nATOM   5362  CG  PRO A 100      -5.224   5.036 -13.292  1.00 16.69           C  \nATOM   5363  N   PRO A 100      -5.257   5.915 -11.107  1.00 13.98           N  \nATOM   5364  O   PRO A 100      -5.760   3.702  -9.362  1.00 13.28           O  \nATOM   5365  C   ILE A 101      -7.529   1.588  -8.933  1.00 12.03           C  \nATOM   5366  CA  ILE A 101      -8.271   2.889  -8.726  1.00 14.63           C  \nATOM   5367  CB  ILE A 101      -9.786   2.660  -8.573  1.00 15.86           C  \nATOM   5368  CD1 ILE A 101     -10.226   4.508  -6.881  1.00 21.61           C  \nATOM   5369  CG1 ILE A 101     -10.559   3.927  -8.238  1.00 17.73           C  \nATOM   5370  CG2 ILE A 101     -10.081   1.611  -7.523  1.00 19.76           C  \nATOM   5371  N   ILE A 101      -7.957   3.866  -9.782  1.00 14.19           N  \nATOM   5372  O   ILE A 101      -7.076   0.984  -7.984  1.00 12.02           O  \nATOM   5373  C   LYS A 102      -5.171   0.022  -9.859  1.00 10.92           C  \nATOM   5374  CA  LYS A 102      -6.579  -0.041 -10.469  1.00 11.67           C  \nATOM   5375  CB  LYS A 102      -6.489  -0.284 -11.969  1.00 14.22           C  \nATOM   5376  CD  LYS A 102      -6.942  -2.696 -11.973  1.00 24.73           C  \nATOM   5377  CE  LYS A 102      -6.575  -4.141 -12.249  1.00 25.09           C  \nATOM   5378  CG  LYS A 102      -5.903  -1.648 -12.347  1.00 17.89           C  \nATOM   5379  N   LYS A 102      -7.323   1.195 -10.212  1.00 12.23           N  \nATOM   5380  NZ  LYS A 102      -7.699  -4.994 -11.827  1.00 21.47           N  \nATOM   5381  O   LYS A 102      -4.639  -0.982  -9.349  1.00 10.47           O  \nATOM   5382  C   TYR A 103      -3.243   1.196  -7.778  1.00  8.75           C  \nATOM   5383  CA  TYR A 103      -3.206   1.340  -9.290  1.00 10.11           C  \nATOM   5384  CB  TYR A 103      -2.545   2.653  -9.653  1.00 10.88           C  \nATOM   5385  CD1 TYR A 103      -2.682   2.209 -12.176  1.00 13.62           C  \nATOM   5386  CD2 TYR A 103      -1.236   3.877 -11.381  1.00 14.13           C  \nATOM   5387  CE1 TYR A 103      -2.269   2.502 -13.483  1.00 17.42           C  \nATOM   5388  CE2 TYR A 103      -0.812   4.215 -12.652  1.00 16.82           C  \nATOM   5389  CG  TYR A 103      -2.149   2.876 -11.110  1.00 11.97           C  \nATOM   5390  CZ  TYR A 103      -1.350   3.501 -13.701  1.00 17.08           C  \nATOM   5391  N   TYR A 103      -4.543   1.215  -9.875  1.00 10.86           N  \nATOM   5392  O   TYR A 103      -2.295   0.688  -7.157  1.00  9.61           O  \nATOM   5393  OH  TYR A 103      -0.970   3.803 -14.978  1.00 21.42           O  \nATOM   5394  C   LEU A 104      -4.746  -0.123  -5.450  1.00  8.96           C  \nATOM   5395  CA  LEU A 104      -4.571   1.356  -5.720  1.00  9.17           C  \nATOM   5396  CB  LEU A 104      -5.720   2.195  -5.233  1.00  9.53           C  \nATOM   5397  CD1 LEU A 104      -6.873   4.397  -4.806  1.00 13.26           C  \nATOM   5398  CD2 LEU A 104      -4.389   4.296  -4.808  1.00 11.87           C  \nATOM   5399  CG  LEU A 104      -5.646   3.713  -5.395  1.00 11.14           C  \nATOM   5400  N   LEU A 104      -4.342   1.634  -7.146  1.00  9.25           N  \nATOM   5401  O   LEU A 104      -4.269  -0.603  -4.398  1.00  9.61           O  \nATOM   5402  C   GLU A 105      -3.975  -2.894  -6.310  1.00  8.62           C  \nATOM   5403  CA  GLU A 105      -5.404  -2.309  -6.251  1.00  9.41           C  \nATOM   5404  CB  GLU A 105      -6.321  -2.902  -7.318  1.00 10.66           C  \nATOM   5405  CD  GLU A 105      -7.236  -5.044  -8.300  1.00 15.14           C  \nATOM   5406  CG  GLU A 105      -6.480  -4.405  -7.138  1.00 11.53           C  \nATOM   5407  N   GLU A 105      -5.350  -0.863  -6.352  1.00  9.11           N  \nATOM   5408  O   GLU A 105      -3.635  -3.751  -5.502  1.00  9.36           O  \nATOM   5409  OE1 GLU A 105      -7.738  -4.327  -9.199  1.00 15.22           O  \nATOM   5410  OE2 GLU A 105      -7.460  -6.263  -8.196  1.00 19.84           O  \nATOM   5411  C   PHE A 106      -1.019  -2.610  -6.026  1.00  8.13           C  \nATOM   5412  CA  PHE A 106      -1.790  -2.902  -7.306  1.00  8.88           C  \nATOM   5413  CB  PHE A 106      -1.045  -2.231  -8.464  1.00 10.14           C  \nATOM   5414  CD1 PHE A 106      -2.300  -3.598 -10.167  1.00 12.07           C  \nATOM   5415  CD2 PHE A 106      -1.352  -1.537 -10.843  1.00 11.77           C  \nATOM   5416  CE1 PHE A 106      -2.807  -3.798 -11.449  1.00 14.52           C  \nATOM   5417  CE2 PHE A 106      -1.823  -1.694 -12.113  1.00 13.96           C  \nATOM   5418  CG  PHE A 106      -1.599  -2.471  -9.864  1.00 11.01           C  \nATOM   5419  CZ  PHE A 106      -2.507  -2.854 -12.407  1.00 14.54           C  \nATOM   5420  N   PHE A 106      -3.177  -2.399  -7.246  1.00  8.62           N  \nATOM   5421  O   PHE A 106      -0.288  -3.489  -5.578  1.00  9.16           O  \nATOM   5422  C   ILE A 107      -0.873  -2.006  -3.094  1.00  8.65           C  \nATOM   5423  CA  ILE A 107      -0.323  -1.162  -4.219  1.00  8.56           C  \nATOM   5424  CB  ILE A 107      -0.208   0.316  -3.882  1.00  8.77           C  \nATOM   5425  CD1 ILE A 107       1.273   1.977  -2.657  1.00  9.14           C  \nATOM   5426  CG1 ILE A 107       1.012   0.553  -2.973  1.00  9.16           C  \nATOM   5427  CG2 ILE A 107      -1.460   0.911  -3.277  1.00  9.16           C  \nATOM   5428  N   ILE A 107      -1.099  -1.419  -5.460  1.00  8.36           N  \nATOM   5429  O   ILE A 107      -0.116  -2.436  -2.223  1.00  8.84           O  \nATOM   5430  C   SER A 108      -2.149  -4.548  -2.118  1.00  9.13           C  \nATOM   5431  CA  SER A 108      -2.731  -3.155  -2.073  1.00  9.21           C  \nATOM   5432  CB  SER A 108      -4.271  -3.175  -2.211  1.00  9.45           C  \nATOM   5433  N   SER A 108      -2.175  -2.266  -3.079  1.00  8.62           N  \nATOM   5434  O   SER A 108      -1.791  -5.152  -1.125  1.00  9.64           O  \nATOM   5435  OG  SER A 108      -4.852  -1.926  -1.991  1.00 11.23           O  \nATOM   5436  C   GLU A 109       0.106  -6.329  -3.014  1.00  9.34           C  \nATOM   5437  CA  GLU A 109      -1.312  -6.345  -3.559  1.00  9.86           C  \nATOM   5438  CB  GLU A 109      -1.309  -6.737  -5.062  1.00 13.20           C  \nATOM   5439  CD  GLU A 109       0.627  -8.426  -5.259  1.00 25.65           C  \nATOM   5440  CG  GLU A 109      -0.849  -8.147  -5.299  1.00 20.64           C  \nATOM   5441  N   GLU A 109      -1.953  -5.055  -3.375  1.00  9.27           N  \nATOM   5442  O   GLU A 109       0.571  -7.266  -2.363  1.00  9.94           O  \nATOM   5443  OE1 GLU A 109       1.568  -7.595  -5.266  1.00 36.76           O  \nATOM   5444  OE2 GLU A 109       0.974  -9.638  -5.155  1.00 31.66           O  \nATOM   5445  C   ALA A 110       2.254  -5.056  -1.296  1.00  8.83           C  \nATOM   5446  CA  ALA A 110       2.191  -5.115  -2.823  1.00  8.66           C  \nATOM   5447  CB  ALA A 110       2.838  -3.918  -3.415  1.00  9.86           C  \nATOM   5448  N   ALA A 110       0.820  -5.242  -3.263  1.00  8.94           N  \nATOM   5449  O   ALA A 110       3.123  -5.664  -0.670  1.00  9.33           O  \nATOM   5450  C   ILE A 111       1.070  -5.633   1.348  1.00  8.95           C  \nATOM   5451  CA  ILE A 111       1.262  -4.256   0.792  1.00  9.15           C  \nATOM   5452  CB  ILE A 111       0.151  -3.307   1.214  1.00  9.04           C  \nATOM   5453  CD1 ILE A 111      -0.696  -0.927   0.813  1.00 10.31           C  \nATOM   5454  CG1 ILE A 111       0.500  -1.860   0.855  1.00  9.64           C  \nATOM   5455  CG2 ILE A 111      -0.180  -3.482   2.697  1.00 10.05           C  \nATOM   5456  N   ILE A 111       1.353  -4.284  -0.677  1.00  9.16           N  \nATOM   5457  O   ILE A 111       1.761  -6.062   2.289  1.00 10.18           O  \nATOM   5458  C   ILE A 112       1.014  -8.610   1.188  1.00 10.84           C  \nATOM   5459  CA  ILE A 112      -0.193  -7.699   1.330  1.00 11.17           C  \nATOM   5460  CB  ILE A 112      -1.498  -8.232   0.679  1.00 11.08           C  \nATOM   5461  CD1 ILE A 112      -4.005  -7.591   0.353  1.00 17.44           C  \nATOM   5462  CG1 ILE A 112      -2.719  -7.461   1.129  1.00 14.38           C  \nATOM   5463  CG2 ILE A 112      -1.606  -9.709   0.947  1.00 15.52           C  \nATOM   5464  N   ILE A 112       0.075  -6.383   0.797  1.00  9.65           N  \nATOM   5465  O   ILE A 112       1.368  -9.379   2.103  1.00 11.37           O  \nATOM   5466  C   HIS A 113       3.928  -9.117   0.813  1.00 10.37           C  \nATOM   5467  CA  HIS A 113       2.823  -9.423  -0.212  1.00 10.86           C  \nATOM   5468  CB  HIS A 113       3.338  -9.159  -1.642  1.00 12.54           C  \nATOM   5469  CD2 HIS A 113       4.234 -11.270  -2.647  1.00 19.96           C  \nATOM   5470  CE1 HIS A 113       6.333 -11.025  -2.183  1.00 24.32           C  \nATOM   5471  CG  HIS A 113       4.431 -10.100  -1.973  1.00 16.92           C  \nATOM   5472  N   HIS A 113       1.647  -8.574   0.013  1.00 10.66           N  \nATOM   5473  ND1 HIS A 113       5.751  -9.949  -1.671  1.00 21.71           N  \nATOM   5474  NE2 HIS A 113       5.463 -11.858  -2.768  1.00 27.51           N  \nATOM   5475  O   HIS A 113       4.531 -10.043   1.391  1.00 10.66           O  \nATOM   5476  C   VAL A 114       4.986  -7.832   3.358  1.00  9.78           C  \nATOM   5477  CA  VAL A 114       5.341  -7.475   1.905  1.00  9.41           C  \nATOM   5478  CB  VAL A 114       5.684  -5.999   1.735  1.00  9.50           C  \nATOM   5479  CG1 VAL A 114       6.576  -5.470   2.837  1.00 10.73           C  \nATOM   5480  CG2 VAL A 114       6.341  -5.763   0.372  1.00  9.96           C  \nATOM   5481  N   VAL A 114       4.236  -7.829   0.983  1.00  9.28           N  \nATOM   5482  O   VAL A 114       5.861  -8.298   4.096  1.00 10.04           O  \nATOM   5483  C   LEU A 115       3.489  -9.473   5.334  1.00 10.07           C  \nATOM   5484  CA  LEU A 115       3.361  -7.985   5.129  1.00 10.15           C  \nATOM   5485  CB  LEU A 115       1.975  -7.412   5.410  1.00  9.02           C  \nATOM   5486  CD1 LEU A 115       2.743  -5.015   5.178  1.00  8.76           C  \nATOM   5487  CD2 LEU A 115       0.545  -5.600   6.273  1.00  9.52           C  \nATOM   5488  CG  LEU A 115       1.989  -6.025   6.054  1.00  7.83           C  \nATOM   5489  N   LEU A 115       3.757  -7.589   3.771  1.00  9.89           N  \nATOM   5490  O   LEU A 115       3.905  -9.940   6.405  1.00 10.87           O  \nATOM   5491  C   HIS A 116       4.751 -12.143   4.547  1.00 10.66           C  \nATOM   5492  CA  HIS A 116       3.271 -11.727   4.431  1.00 11.04           C  \nATOM   5493  CB  HIS A 116       2.528 -12.403   3.278  1.00 13.82           C  \nATOM   5494  CD2 HIS A 116       2.408 -14.564   4.688  1.00 21.86           C  \nATOM   5495  CE1 HIS A 116       1.363 -15.783   3.193  1.00 27.11           C  \nATOM   5496  CG  HIS A 116       2.205 -13.808   3.603  1.00 17.15           C  \nATOM   5497  N   HIS A 116       3.143 -10.282   4.292  1.00 10.53           N  \nATOM   5498  ND1 HIS A 116       1.536 -14.586   2.657  1.00 27.53           N  \nATOM   5499  NE2 HIS A 116       1.934 -15.786   4.429  1.00 25.22           N  \nATOM   5500  O   HIS A 116       5.063 -13.029   5.346  1.00 12.17           O  \nATOM   5501  C   SER A 117       7.653 -11.419   5.165  1.00 10.98           C  \nATOM   5502  CA  SER A 117       7.056 -11.792   3.803  1.00 11.11           C  \nATOM   5503  CB  SER A 117       7.778 -11.048   2.655  1.00 13.63           C  \nATOM   5504  N   SER A 117       5.635 -11.490   3.785  1.00 10.29           N  \nATOM   5505  O   SER A 117       8.458 -12.144   5.766  1.00 13.35           O  \nATOM   5506  OG  SER A 117       9.150 -11.384   2.716  1.00 17.15           O  \nATOM   5507  C   ARG A 118       7.323 -10.235   8.158  1.00  9.78           C  \nATOM   5508  CA  ARG A 118       7.946  -9.721   6.863  1.00 10.17           C  \nATOM   5509  CB  ARG A 118       7.873  -8.171   6.860  1.00 10.83           C  \nATOM   5510  CD  ARG A 118       8.812  -6.048   5.903  1.00 11.66           C  \nATOM   5511  CG  ARG A 118       8.963  -7.522   6.002  1.00 10.69           C  \nATOM   5512  CZ  ARG A 118      10.847  -4.622   5.839  1.00 14.80           C  \nATOM   5513  N   ARG A 118       7.300 -10.227   5.662  1.00 10.35           N  \nATOM   5514  NE  ARG A 118       9.886  -5.324   5.275  1.00 15.08           N  \nATOM   5515  NH1 ARG A 118      10.990  -4.490   7.150  1.00 15.69           N  \nATOM   5516  NH2 ARG A 118      11.754  -4.003   5.098  1.00 14.49           N  \nATOM   5517  O   ARG A 118       7.978 -10.237   9.170  1.00 10.62           O  \nATOM   5518  C   HIS A 119       4.518 -12.244   9.277  1.00  9.27           C  \nATOM   5519  CA  HIS A 119       5.341 -10.966   9.370  1.00  9.39           C  \nATOM   5520  CB  HIS A 119       4.434  -9.812   9.825  1.00 10.16           C  \nATOM   5521  CD2 HIS A 119       4.992  -7.428   8.950  1.00 11.04           C  \nATOM   5522  CE1 HIS A 119       6.635  -6.957  10.259  1.00 10.69           C  \nATOM   5523  CG  HIS A 119       5.135  -8.492   9.743  1.00  9.27           C  \nATOM   5524  N   HIS A 119       6.022 -10.643   8.103  1.00  9.57           N  \nATOM   5525  ND1 HIS A 119       6.191  -8.197  10.561  1.00  9.66           N  \nATOM   5526  NE2 HIS A 119       5.923  -6.490   9.259  1.00 11.49           N  \nATOM   5527  O   HIS A 119       3.324 -12.257   9.586  1.00 10.37           O  \nATOM   5528  C   PRO A 120       3.469 -14.956   9.770  1.00 10.91           C  \nATOM   5529  CA  PRO A 120       4.278 -14.529   8.530  1.00 11.08           C  \nATOM   5530  CB  PRO A 120       5.265 -15.575   8.022  1.00 13.17           C  \nATOM   5531  CD  PRO A 120       6.521 -13.616   8.493  1.00 12.36           C  \nATOM   5532  CG  PRO A 120       6.608 -15.137   8.545  1.00 12.86           C  \nATOM   5533  N   PRO A 120       5.095 -13.363   8.805  1.00 10.73           N  \nATOM   5534  O   PRO A 120       2.326 -15.399   9.638  1.00 12.34           O  \nATOM   5535  C   GLY A 121       2.243 -14.608  12.550  1.00 12.15           C  \nATOM   5536  CA  GLY A 121       3.417 -15.447  12.113  1.00 12.08           C  \nATOM   5537  N   GLY A 121       4.088 -14.937  10.947  1.00 11.30           N  \nATOM   5538  O   GLY A 121       1.393 -15.089  13.301  1.00 17.89           O  \nATOM   5539  C   ASP A 122       0.245 -12.108  11.089  1.00 11.16           C  \nATOM   5540  CA  ASP A 122       1.059 -12.429  12.342  1.00 11.30           C  \nATOM   5541  CB  ASP A 122       1.539 -11.159  13.059  1.00 13.84           C  \nATOM   5542  CG  ASP A 122       2.021 -11.548  14.449  1.00 14.80           C  \nATOM   5543  N   ASP A 122       2.118 -13.383  12.092  1.00 10.64           N  \nATOM   5544  O   ASP A 122      -0.505 -11.138  11.097  1.00 13.12           O  \nATOM   5545  OD1 ASP A 122       1.292 -11.943  15.342  1.00 15.60           O  \nATOM   5546  OD2 ASP A 122       3.303 -11.472  14.582  1.00 18.17           O  \nATOM   5547  C   PHE A 123      -0.526 -13.997   8.124  1.00 11.89           C  \nATOM   5548  CA  PHE A 123      -0.191 -12.673   8.780  1.00 11.37           C  \nATOM   5549  CB  PHE A 123       0.688 -11.767   7.919  1.00 11.66           C  \nATOM   5550  CD1 PHE A 123      -1.033  -9.994   7.358  1.00 12.21           C  \nATOM   5551  CD2 PHE A 123       0.009 -11.067   5.558  1.00 12.78           C  \nATOM   5552  CE1 PHE A 123      -1.779  -9.202   6.525  1.00 12.40           C  \nATOM   5553  CE2 PHE A 123      -0.720 -10.282   4.702  1.00 13.20           C  \nATOM   5554  CG  PHE A 123      -0.128 -10.930   6.938  1.00 11.04           C  \nATOM   5555  CZ  PHE A 123      -1.623  -9.338   5.160  1.00 12.68           C  \nATOM   5556  N   PHE A 123       0.422 -12.919  10.071  1.00 10.41           N  \nATOM   5557  O   PHE A 123      -0.288 -14.192   6.921  1.00 13.26           O  \nATOM   5558  C   GLY A 124      -3.003 -15.664   7.575  1.00 12.47           C  \nATOM   5559  CA  GLY A 124      -1.821 -16.063   8.429  1.00 13.21           C  \nATOM   5560  N   GLY A 124      -1.166 -14.877   8.906  1.00 12.15           N  \nATOM   5561  O   GLY A 124      -3.345 -14.503   7.372  1.00 12.39           O  \nATOM   5562  C   ALA A 125      -5.908 -15.566   6.681  1.00 12.48           C  \nATOM   5563  CA  ALA A 125      -4.788 -16.422   6.127  1.00 14.41           C  \nATOM   5564  CB  ALA A 125      -5.366 -17.778   5.667  1.00 17.44           C  \nATOM   5565  N   ALA A 125      -3.720 -16.680   7.073  1.00 14.13           N  \nATOM   5566  O   ALA A 125      -6.494 -14.729   6.021  1.00 12.95           O  \nATOM   5567  C   ASP A 126      -6.852 -13.451   8.491  1.00 11.87           C  \nATOM   5568  CA  ASP A 126      -7.212 -14.919   8.567  1.00 14.47           C  \nATOM   5569  CB  ASP A 126      -7.416 -15.412   9.991  1.00 16.04           C  \nATOM   5570  CG  ASP A 126      -6.215 -15.407  10.884  1.00 16.70           C  \nATOM   5571  N   ASP A 126      -6.215 -15.795   7.968  1.00 13.75           N  \nATOM   5572  O   ASP A 126      -7.666 -12.608   8.123  1.00 12.12           O  \nATOM   5573  OD1 ASP A 126      -4.998 -15.368  10.522  1.00 19.53           O  \nATOM   5574  OD2 ASP A 126      -6.444 -15.581  12.110  1.00 21.52           O  \nATOM   5575  C   ALA A 127      -5.003 -11.249   7.372  1.00  9.88           C  \nATOM   5576  CA  ALA A 127      -5.139 -11.751   8.825  1.00 10.61           C  \nATOM   5577  CB  ALA A 127      -3.830 -11.608   9.571  1.00 11.39           C  \nATOM   5578  N   ALA A 127      -5.618 -13.123   8.853  1.00 11.58           N  \nATOM   5579  O   ALA A 127      -5.278 -10.074   7.103  1.00 11.04           O  \nATOM   5580  C   GLN A 128      -5.913 -11.317   4.528  1.00 10.38           C  \nATOM   5581  CA  GLN A 128      -4.538 -11.718   5.040  1.00 11.14           C  \nATOM   5582  CB  GLN A 128      -4.036 -12.915   4.200  1.00 12.86           C  \nATOM   5583  CD  GLN A 128      -2.222 -14.602   3.870  1.00 11.78           C  \nATOM   5584  CG  GLN A 128      -2.561 -13.235   4.388  1.00 11.03           C  \nATOM   5585  N   GLN A 128      -4.585 -12.109   6.438  1.00 10.72           N  \nATOM   5586  NE2 GLN A 128      -1.455 -15.443   4.572  1.00 11.17           N  \nATOM   5587  O   GLN A 128      -6.087 -10.343   3.832  1.00 10.74           O  \nATOM   5588  OE1 GLN A 128      -2.671 -14.918   2.771  1.00 16.05           O  \nATOM   5589  C   GLY A 129      -8.774 -10.530   5.046  1.00  9.58           C  \nATOM   5590  CA  GLY A 129      -8.239 -11.841   4.480  1.00 11.40           C  \nATOM   5591  N   GLY A 129      -6.909 -12.174   4.856  1.00 11.19           N  \nATOM   5592  O   GLY A 129      -9.404  -9.728   4.362  1.00 10.87           O  \nATOM   5593  C   ALA A 130      -8.258  -7.878   6.348  1.00  9.36           C  \nATOM   5594  CA  ALA A 130      -8.940  -9.075   6.976  1.00 10.05           C  \nATOM   5595  CB  ALA A 130      -8.627  -9.138   8.457  1.00 10.96           C  \nATOM   5596  N   ALA A 130      -8.494 -10.315   6.334  1.00 10.03           N  \nATOM   5597  O   ALA A 130      -8.877  -6.838   6.131  1.00  9.51           O  \nATOM   5598  C   MET A 131      -6.751  -6.612   4.063  1.00 10.57           C  \nATOM   5599  CA  MET A 131      -6.241  -6.831   5.480  1.00  9.59           C  \nATOM   5600  CB  MET A 131      -4.750  -7.079   5.476  1.00 10.13           C  \nATOM   5601  CE  MET A 131      -3.050  -4.749   7.219  1.00 13.64           C  \nATOM   5602  CG  MET A 131      -3.915  -5.919   4.954  1.00 10.59           C  \nATOM   5603  N   MET A 131      -6.947  -7.942   6.119  1.00  9.67           N  \nATOM   5604  O   MET A 131      -6.903  -5.447   3.657  1.00  9.78           O  \nATOM   5605  SD  MET A 131      -4.052  -4.358   5.790  1.00 11.42           S  \nATOM   5606  C   ASN A 132      -8.925  -6.732   2.152  1.00 10.04           C  \nATOM   5607  CA  ASN A 132      -7.590  -7.459   2.004  1.00 11.40           C  \nATOM   5608  CB  ASN A 132      -7.813  -8.777   1.325  1.00 14.21           C  \nATOM   5609  CG  ASN A 132      -8.324  -8.445  -0.067  1.00 15.43           C  \nATOM   5610  N   ASN A 132      -7.003  -7.645   3.311  1.00 10.43           N  \nATOM   5611  ND2 ASN A 132      -9.581  -8.881  -0.223  1.00 19.43           N  \nATOM   5612  O   ASN A 132      -9.199  -5.801   1.365  1.00 10.69           O  \nATOM   5613  OD1 ASN A 132      -7.684  -7.860  -0.938  1.00 18.82           O  \nATOM   5614  C   LYS A 133     -10.854  -4.900   3.641  1.00  9.03           C  \nATOM   5615  CA  LYS A 133     -11.045  -6.346   3.297  1.00  9.97           C  \nATOM   5616  CB  LYS A 133     -11.920  -7.044   4.346  1.00 11.33           C  \nATOM   5617  CD  LYS A 133     -13.528  -8.857   5.181  1.00 16.18           C  \nATOM   5618  CE  LYS A 133     -14.267 -10.145   4.799  1.00 22.68           C  \nATOM   5619  CG  LYS A 133     -12.569  -8.386   4.080  1.00 11.37           C  \nATOM   5620  N   LYS A 133      -9.750  -7.055   3.131  1.00 10.21           N  \nATOM   5621  NZ  LYS A 133     -15.418 -10.496   5.679  1.00 29.65           N  \nATOM   5622  O   LYS A 133     -11.572  -4.044   3.162  1.00  9.63           O  \nATOM   5623  C   ALA A 134      -9.136  -2.409   3.662  1.00  8.08           C  \nATOM   5624  CA  ALA A 134      -9.570  -3.200   4.869  1.00  8.51           C  \nATOM   5625  CB  ALA A 134      -8.483  -3.159   5.941  1.00  9.33           C  \nATOM   5626  N   ALA A 134      -9.840  -4.586   4.483  1.00  8.72           N  \nATOM   5627  O   ALA A 134      -9.517  -1.242   3.513  1.00  8.94           O  \nATOM   5628  C   LEU A 135      -8.861  -2.137   0.603  1.00  8.73           C  \nATOM   5629  CA  LEU A 135      -7.784  -2.277   1.674  1.00  8.63           C  \nATOM   5630  CB  LEU A 135      -6.543  -2.923   1.096  1.00  8.90           C  \nATOM   5631  CD1 LEU A 135      -4.205  -3.713   1.572  1.00 12.27           C  \nATOM   5632  CD2 LEU A 135      -4.946  -1.461   2.412  1.00 14.95           C  \nATOM   5633  CG  LEU A 135      -5.340  -2.867   2.080  1.00  9.69           C  \nATOM   5634  N   LEU A 135      -8.277  -2.988   2.825  1.00  8.40           N  \nATOM   5635  O   LEU A 135      -8.931  -1.152  -0.123  1.00 10.00           O  \nATOM   5636  C   GLU A 136     -11.806  -1.896   0.101  1.00  8.86           C  \nATOM   5637  CA  GLU A 136     -10.943  -3.027  -0.351  1.00  9.88           C  \nATOM   5638  CB  GLU A 136     -11.705  -4.374  -0.361  1.00 10.68           C  \nATOM   5639  CD  GLU A 136     -11.568  -6.831  -0.974  1.00 18.10           C  \nATOM   5640  CG  GLU A 136     -11.022  -5.447  -1.188  1.00 11.52           C  \nATOM   5641  N   GLU A 136      -9.753  -3.159   0.511  1.00  9.51           N  \nATOM   5642  O   GLU A 136     -12.347  -1.159  -0.751  1.00 10.13           O  \nATOM   5643  OE1 GLU A 136     -12.458  -7.062  -0.133  1.00 17.61           O  \nATOM   5644  OE2 GLU A 136     -11.087  -7.727  -1.709  1.00 28.60           O  \nATOM   5645  C   LEU A 137     -12.274   0.705   1.549  1.00  9.21           C  \nATOM   5646  CA  LEU A 137     -12.872  -0.670   1.912  1.00  9.49           C  \nATOM   5647  CB  LEU A 137     -13.023  -0.815   3.417  1.00 10.38           C  \nATOM   5648  CD1 LEU A 137     -15.263   0.338   3.577  1.00 15.95           C  \nATOM   5649  CD2 LEU A 137     -13.778   0.074   5.589  1.00 12.90           C  \nATOM   5650  CG  LEU A 137     -13.841   0.285   4.080  1.00 11.91           C  \nATOM   5651  N   LEU A 137     -12.027  -1.736   1.384  1.00  9.17           N  \nATOM   5652  O   LEU A 137     -12.982   1.590   1.093  1.00  9.94           O  \nATOM   5653  C   PHE A 138     -10.498   2.324  -0.184  1.00  9.55           C  \nATOM   5654  CA  PHE A 138     -10.230   2.005   1.280  1.00 10.20           C  \nATOM   5655  CB  PHE A 138      -8.732   1.785   1.575  1.00  9.84           C  \nATOM   5656  CD1 PHE A 138      -7.816   4.153   1.294  1.00 10.47           C  \nATOM   5657  CD2 PHE A 138      -7.048   2.438  -0.172  1.00 10.48           C  \nATOM   5658  CE1 PHE A 138      -7.000   5.059   0.655  1.00 10.98           C  \nATOM   5659  CE2 PHE A 138      -6.248   3.327  -0.839  1.00 12.66           C  \nATOM   5660  CG  PHE A 138      -7.844   2.827   0.891  1.00  9.39           C  \nATOM   5661  CZ  PHE A 138      -6.227   4.636  -0.401  1.00 12.40           C  \nATOM   5662  N   PHE A 138     -10.962   0.838   1.737  1.00  9.52           N  \nATOM   5663  O   PHE A 138     -10.864   3.438  -0.553  1.00  9.85           O  \nATOM   5664  C   ARG A 139     -11.962   1.868  -2.789  1.00  9.44           C  \nATOM   5665  CA  ARG A 139     -10.514   1.518  -2.446  1.00 10.38           C  \nATOM   5666  CB  ARG A 139     -10.068   0.310  -3.254  1.00 10.87           C  \nATOM   5667  CD  ARG A 139      -8.247  -0.875  -4.394  1.00 13.84           C  \nATOM   5668  CG  ARG A 139      -8.623   0.031  -3.262  1.00 11.99           C  \nATOM   5669  CZ  ARG A 139      -8.504  -3.218  -3.780  1.00 11.77           C  \nATOM   5670  N   ARG A 139     -10.319   1.334  -1.037  1.00  9.77           N  \nATOM   5671  NE  ARG A 139      -8.896  -2.173  -4.529  1.00 12.76           N  \nATOM   5672  NH1 ARG A 139      -7.541  -3.114  -2.861  1.00 13.72           N  \nATOM   5673  NH2 ARG A 139      -9.075  -4.369  -4.006  1.00 13.93           N  \nATOM   5674  O   ARG A 139     -12.245   2.720  -3.642  1.00  9.82           O  \nATOM   5675  C   LYS A 140     -14.633   2.935  -2.144  1.00  9.67           C  \nATOM   5676  CA  LYS A 140     -14.326   1.470  -2.401  1.00 10.16           C  \nATOM   5677  CB  LYS A 140     -15.179   0.574  -1.502  1.00 12.59           C  \nATOM   5678  CD  LYS A 140     -17.418   0.140  -0.324  1.00 21.95           C  \nATOM   5679  CE  LYS A 140     -18.890   0.501  -0.195  1.00 26.58           C  \nATOM   5680  CG  LYS A 140     -16.678   0.903  -1.441  1.00 14.70           C  \nATOM   5681  N   LYS A 140     -12.905   1.202  -2.160  1.00  9.23           N  \nATOM   5682  NZ  LYS A 140     -19.512   0.126   1.101  1.00 37.35           N  \nATOM   5683  O   LYS A 140     -15.341   3.609  -2.919  1.00 10.59           O  \nATOM   5684  C   ASP A 141     -13.801   5.800  -1.432  1.00 10.73           C  \nATOM   5685  CA  ASP A 141     -14.479   4.748  -0.592  1.00 10.57           C  \nATOM   5686  CB  ASP A 141     -14.253   4.936   0.903  1.00 11.33           C  \nATOM   5687  CG  ASP A 141     -15.240   4.195   1.766  1.00 12.03           C  \nATOM   5688  N   ASP A 141     -14.158   3.399  -0.991  1.00  9.86           N  \nATOM   5689  O   ASP A 141     -14.371   6.841  -1.778  1.00 11.83           O  \nATOM   5690  OD1 ASP A 141     -16.284   3.682   1.275  1.00 13.40           O  \nATOM   5691  OD2 ASP A 141     -15.029   4.185   3.023  1.00 13.42           O  \nATOM   5692  C   ILE A 142     -12.604   6.448  -4.084  1.00 10.65           C  \nATOM   5693  CA  ILE A 142     -11.893   6.452  -2.745  1.00 10.42           C  \nATOM   5694  CB  ILE A 142     -10.401   6.012  -2.921  1.00 10.73           C  \nATOM   5695  CD1 ILE A 142      -9.261   7.630  -1.296  1.00 13.53           C  \nATOM   5696  CG1 ILE A 142      -9.524   6.206  -1.705  1.00  9.36           C  \nATOM   5697  CG2 ILE A 142      -9.811   6.730  -4.138  1.00 10.13           C  \nATOM   5698  N   ILE A 142     -12.554   5.542  -1.831  1.00  9.66           N  \nATOM   5699  O   ILE A 142     -12.819   7.487  -4.703  1.00 11.05           O  \nATOM   5700  C   ALA A 143     -14.963   5.952  -5.892  1.00 10.34           C  \nATOM   5701  CA  ALA A 143     -13.690   5.125  -5.855  1.00 10.57           C  \nATOM   5702  CB  ALA A 143     -13.971   3.663  -6.159  1.00 11.45           C  \nATOM   5703  N   ALA A 143     -13.012   5.279  -4.565  1.00 10.14           N  \nATOM   5704  O   ALA A 143     -15.269   6.554  -6.944  1.00 11.48           O  \nATOM   5705  C   ALA A 144     -16.639   8.255  -4.996  1.00 11.81           C  \nATOM   5706  CA  ALA A 144     -16.931   6.779  -4.796  1.00 11.42           C  \nATOM   5707  CB  ALA A 144     -17.662   6.505  -3.511  1.00 12.37           C  \nATOM   5708  N   ALA A 144     -15.677   5.984  -4.796  1.00 10.26           N  \nATOM   5709  O   ALA A 144     -17.358   8.962  -5.684  1.00 14.28           O  \nATOM   5710  C   LYS A 145     -14.625  10.383  -5.944  1.00 13.06           C  \nATOM   5711  CA  LYS A 145     -15.146  10.123  -4.523  1.00 13.72           C  \nATOM   5712  CB  LYS A 145     -14.149  10.522  -3.452  1.00 14.79           C  \nATOM   5713  CD  LYS A 145     -15.613  11.333  -1.546  1.00 30.61           C  \nATOM   5714  CE  LYS A 145     -16.855  10.884  -0.815  1.00 32.74           C  \nATOM   5715  CG  LYS A 145     -14.590  10.351  -1.994  1.00 22.20           C  \nATOM   5716  N   LYS A 145     -15.555   8.754  -4.377  1.00 12.07           N  \nATOM   5717  NZ  LYS A 145     -17.585   9.737  -1.373  1.00 38.91           N  \nATOM   5718  O   LYS A 145     -14.905  11.429  -6.544  1.00 16.62           O  \nATOM   5719  C   TYR A 146     -14.684   9.716  -8.764  1.00 14.04           C  \nATOM   5720  CA  TYR A 146     -13.441   9.574  -7.894  1.00 13.78           C  \nATOM   5721  CB  TYR A 146     -12.712   8.316  -8.323  1.00 12.64           C  \nATOM   5722  CD1 TYR A 146     -10.674   9.141  -7.021  1.00 10.99           C  \nATOM   5723  CD2 TYR A 146     -10.441   7.320  -8.554  1.00 11.02           C  \nATOM   5724  CE1 TYR A 146      -9.332   9.050  -6.727  1.00 11.36           C  \nATOM   5725  CE2 TYR A 146      -9.094   7.223  -8.262  1.00 11.07           C  \nATOM   5726  CG  TYR A 146     -11.255   8.259  -7.947  1.00 11.05           C  \nATOM   5727  CZ  TYR A 146      -8.559   8.099  -7.324  1.00 10.73           C  \nATOM   5728  N   TYR A 146     -13.856   9.446  -6.490  1.00 12.34           N  \nATOM   5729  O   TYR A 146     -14.679  10.560  -9.675  1.00 18.38           O  \nATOM   5730  OH  TYR A 146      -7.199   8.016  -7.036  1.00 11.78           O  \nATOM   5731  C   LYS A 147     -17.508  10.251  -9.383  1.00 17.16           C  \nATOM   5732  CA  LYS A 147     -16.849   8.906  -9.456  1.00 16.81           C  \nATOM   5733  CB  LYS A 147     -17.840   7.984  -8.882  1.00 15.52           C  \nATOM   5734  CD  LYS A 147     -20.038   6.761  -9.359  1.00 22.46           C  \nATOM   5735  CE  LYS A 147     -21.349   6.813 -10.150  1.00 30.28           C  \nATOM   5736  CG  LYS A 147     -19.102   7.896  -9.749  1.00 16.76           C  \nATOM   5737  N   LYS A 147     -15.692   8.896  -8.569  1.00 15.34           N  \nATOM   5738  NZ  LYS A 147     -21.382   5.936 -11.334  1.00 41.60           N  \nATOM   5739  O   LYS A 147     -17.945  10.848 -10.384  1.00 20.24           O  \nATOM   5740  C   GLU A 148     -17.498  13.154  -8.887  1.00 19.24           C  \nATOM   5741  CA  GLU A 148     -18.227  12.095  -8.056  1.00 19.32           C  \nATOM   5742  CB  GLU A 148     -18.152  12.487  -6.592  1.00 20.04           C  \nATOM   5743  CD  GLU A 148     -18.355  14.308  -4.970  1.00 21.90           C  \nATOM   5744  CG  GLU A 148     -18.635  13.899  -6.398  1.00 22.74           C  \nATOM   5745  N   GLU A 148     -17.662  10.771  -8.185  1.00 16.41           N  \nATOM   5746  O   GLU A 148     -18.130  13.995  -9.533  1.00 25.39           O  \nATOM   5747  OE1 GLU A 148     -18.401  13.438  -4.103  1.00 29.41           O  \nATOM   5748  OE2 GLU A 148     -18.108  15.507  -4.743  1.00 29.55           O  \nATOM   5749  C   LEU A 149     -15.118  13.738 -11.038  1.00 16.03           C  \nATOM   5750  CA  LEU A 149     -15.323  14.028  -9.550  1.00 16.50           C  \nATOM   5751  CB  LEU A 149     -13.965  14.078  -8.828  1.00 15.05           C  \nATOM   5752  CD1 LEU A 149     -12.587  14.375  -6.799  1.00 17.56           C  \nATOM   5753  CD2 LEU A 149     -14.463  16.062  -7.342  1.00 25.81           C  \nATOM   5754  CG  LEU A 149     -13.975  14.612  -7.392  1.00 16.65           C  \nATOM   5755  N   LEU A 149     -16.177  13.113  -8.833  1.00 14.75           N  \nATOM   5756  O   LEU A 149     -14.443  14.554 -11.673  1.00 19.46           O  \nATOM   5757  C   GLY A 150     -14.360  11.747 -13.314  1.00 17.21           C  \nATOM   5758  CA  GLY A 150     -15.672  12.352 -12.952  1.00 17.55           C  \nATOM   5759  N   GLY A 150     -15.741  12.688 -11.545  1.00 16.53           N  \nATOM   5760  O   GLY A 150     -14.038  11.844 -14.484  1.00 18.65           O  \nATOM   5761  C   TYR A 151     -12.543   8.918 -12.458  1.00 28.32           C  \nATOM   5762  CA  TYR A 151     -12.396  10.432 -12.654  1.00 24.32           C  \nATOM   5763  CB  TYR A 151     -11.321  10.987 -11.657  1.00 19.65           C  \nATOM   5764  CD1 TYR A 151      -9.341  10.609 -13.168  1.00 17.63           C  \nATOM   5765  CD2 TYR A 151      -9.373   9.472 -11.061  1.00 14.89           C  \nATOM   5766  CE1 TYR A 151      -8.142  10.043 -13.463  1.00 18.69           C  \nATOM   5767  CE2 TYR A 151      -8.154   8.882 -11.399  1.00 16.90           C  \nATOM   5768  CG  TYR A 151      -9.978  10.333 -11.959  1.00 16.57           C  \nATOM   5769  CZ  TYR A 151      -7.513   9.171 -12.596  1.00 17.32           C  \nATOM   5770  N   TYR A 151     -13.628  11.109 -12.400  1.00 18.88           N  \nATOM   5771  O   TYR A 151     -11.572   8.206 -12.717  1.00 43.73           O  \nATOM   5772  OH  TYR A 151      -6.328   8.554 -12.938  1.00 20.44           O  \nATOM   5773  OXT TYR A 151     -13.568   8.497 -11.933  1.00 36.55           O  \n\nENDMDL\n";

	pTmalignCgi->main_func();

	cout<<pTmalignCgi->m_output<<endl;
*/
}


