var CIFTools,$NGL_shaderTextHash={};$NGL_shaderTextHash["SphereImpostor.frag"]=["#define STANDARD","#define IMPOSTOR","","uniform vec3 diffuse;","uniform vec3 emissive;","uniform float roughness;","uniform float metalness;","uniform float opacity;","uniform float nearClip;","uniform mat4 projectionMatrix;","uniform float ortho;","","varying float vRadius;","varying float vRadiusSq;","varying vec3 vPoint;","varying vec3 vPointViewPosition;","","#ifdef PICKING","    uniform float objectId;","    varying vec3 vPickingColor;","#else","    #include common","    #include color_pars_fragment","    #include fog_pars_fragment","    #include bsdfs","    #include lights_pars_begin","    #include lights_physical_pars_fragment","#endif","","bool flag2 = false;","bool interior = false;","vec3 cameraPos;","vec3 cameraNormal;","","// Calculate depth based on the given camera position.","float calcDepth( in vec3 cameraPos ){","    vec2 clipZW = cameraPos.z * projectionMatrix[2].zw + projectionMatrix[3].zw;","    return 0.5 + 0.5 * clipZW.x / clipZW.y;","}","","float calcClip( vec3 cameraPos ){","    return dot( vec4( cameraPos, 1.0 ), vec4( 0.0, 0.0, 1.0, nearClip - 0.5 ) );","}","","bool Impostor( out vec3 cameraPos, out vec3 cameraNormal ){","","    vec3 cameraSpherePos = -vPointViewPosition;","    cameraSpherePos.z += vRadius;","","    vec3 rayOrigin = mix( vec3( 0.0, 0.0, 0.0 ), vPoint, ortho );","    vec3 rayDirection = mix( normalize( vPoint ), vec3( 0.0, 0.0, 1.0 ), ortho );","    vec3 cameraSphereDir = mix( cameraSpherePos, rayOrigin - cameraSpherePos, ortho );","","    float B = dot( rayDirection, cameraSphereDir );","    float det = B * B + vRadiusSq - dot( cameraSphereDir, cameraSphereDir );","","    if( det < 0.0 ){","        discard;","        return false;","    }","        float sqrtDet = sqrt( det );","        float posT = mix( B + sqrtDet, B + sqrtDet, ortho );","        float negT = mix( B - sqrtDet, sqrtDet - B, ortho );","","        cameraPos = rayDirection * negT + rayOrigin;","","        #ifdef NEAR_CLIP","if( calcDepth( cameraPos ) <= 0.0 ){","    cameraPos = rayDirection * posT + rayOrigin;","    interior = true;","    return false;","}else if( calcClip( cameraPos ) > 0.0 ){","    cameraPos = rayDirection * posT + rayOrigin;","    interior = true;","    flag2 = true;","    return false;","}else{","    cameraNormal = normalize( cameraPos - cameraSpherePos );","}","        #else","if( calcDepth( cameraPos ) <= 0.0 ){","    cameraPos = rayDirection * posT + rayOrigin;","    interior = true;","    return false;","}else{","    cameraNormal = normalize( cameraPos - cameraSpherePos );","}","        #endif","","        cameraNormal = normalize( cameraPos - cameraSpherePos );","        cameraNormal *= float(!interior) * 2.0 - 1.0;","         return !interior;","","}","","void main(void){","","    bool flag = Impostor( cameraPos, cameraNormal );","","    #ifdef NEAR_CLIP","        if( calcClip( cameraPos ) > 0.0 )","            discard;","    #endif","","    // FIXME not compatible with custom clipping plane","    //Set the depth based on the new cameraPos.","    gl_FragDepthEXT = calcDepth( cameraPos );","    if( !flag ){","","        // clamp to near clipping plane and add a tiny value to","        // make spheres with a greater radius occlude smaller ones","        #ifdef NEAR_CLIP","if( flag2 ){","    gl_FragDepthEXT = max( 0.0, calcDepth( vec3( - ( nearClip - 0.5 ) ) ) + ( 0.0000001 / vRadius ) );","}else if( gl_FragDepthEXT >= 0.0 ){","    gl_FragDepthEXT = 0.0 + ( 0.0000001 / vRadius );","}","        #else","if( gl_FragDepthEXT >= 0.0 ){","    gl_FragDepthEXT = 0.0 + ( 0.0000001 / vRadius );","}","        #endif","","    }","","    // bugfix (mac only?)","    if (gl_FragDepthEXT < 0.0)","        discard;","    if (gl_FragDepthEXT > 1.0)","        discard;","","    #ifdef PICKING","","        gl_FragColor = vec4( vPickingColor, objectId );","","    #else","","        vec3 vNormal = cameraNormal;","        vec3 vViewPosition = -cameraPos;","","        vec4 diffuseColor = vec4( diffuse, opacity );","        ReflectedLight reflectedLight = ReflectedLight( vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ) );","        vec3 totalEmissiveLight = emissive;","","        #include color_fragment","        #include roughnessmap_fragment","        #include metalnessmap_fragment","","        // don't use include normal_fragment","        vec3 normal = normalize( vNormal );","","        #include lights_physical_fragment","        //include lights_template","        #include lights_fragment_begin","        #include lights_fragment_end","","        vec3 outgoingLight = reflectedLight.directDiffuse + reflectedLight.indirectDiffuse + reflectedLight.directSpecular + reflectedLight.indirectSpecular + totalEmissiveLight;","","        gl_FragColor = vec4( outgoingLight, diffuseColor.a );","        //gl_FragColor = vec4( reflectedLight.directSpecular, diffuseColor.a );","","        #include premultiplied_alpha_fragment","        #include tonemapping_fragment","        #include encodings_fragment","        //include fog_fragment","        #ifdef USE_FOG","            #ifdef USE_LOGDEPTHBUF_EXT","                float depth = gl_FragDepthEXT / gl_FragCoord.w;","            #else","                float depth = gl_FragCoord.z / gl_FragCoord.w;","            #endif","            #ifdef FOG_EXP2","                float fogFactor = whiteCompliment( exp2( - fogDensity * fogDensity * depth * depth * LOG2 ) );","            #else","                float fogFactor = smoothstep( fogNear, fogFar, depth );","            #endif","            gl_FragColor.rgb = mix( gl_FragColor.rgb, fogColor, fogFactor );","        #endif","","    #endif","","}"].join("\n"),$NGL_shaderTextHash["SphereImpostor.vert"]=["uniform mat4 projectionMatrixInverse;","uniform float nearClip;","","varying float vRadius;","varying float vRadiusSq;","varying vec3 vPoint;","varying vec3 vPointViewPosition;","varying float fogDepth;","varying float fogNear;","varying float fogFar;","","attribute vec2 mapping;","//attribute vec3 position;","attribute float radius;","","#ifdef PICKING","    #include unpack_clr","    attribute float primitiveId;","    varying vec3 vPickingColor;","#else","    #include color_pars_vertex","#endif","","//include matrix_scale","float matrixScale( in mat4 m ){","    vec4 r = m[ 0 ];","    return sqrt( r[ 0 ] * r[ 0 ] + r[ 1 ] * r[ 1 ] + r[ 2 ] * r[ 2 ] );","}","","const mat4 D = mat4(","    1.0, 0.0, 0.0, 0.0,","    0.0, 1.0, 0.0, 0.0,","    0.0, 0.0, 1.0, 0.0,","    0.0, 0.0, 0.0, -1.0",");","","mat4 transposeTmp( in mat4 inMatrix ) {","    vec4 i0 = inMatrix[0];","    vec4 i1 = inMatrix[1];","    vec4 i2 = inMatrix[2];","    vec4 i3 = inMatrix[3];","","    mat4 outMatrix = mat4(","        vec4(i0.x, i1.x, i2.x, i3.x),","        vec4(i0.y, i1.y, i2.y, i3.y),","        vec4(i0.z, i1.z, i2.z, i3.z),","        vec4(i0.w, i1.w, i2.w, i3.w)","    );","    return outMatrix;","}","","//------------------------------------------------------------------------------","// Compute point size and center using the technique described in:","// 'GPU-Based Ray-Casting of Quadratic Surfaces'","// by Christian Sigg, Tim Weyrich, Mario Botsch, Markus Gross.","//","// Code based on","/*=========================================================================",""," Program:   Visualization Toolkit"," Module:    Quadrics_fs.glsl and Quadrics_vs.glsl",""," Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen"," All rights reserved."," See Copyright.txt or http://www.kitware.com/Copyright.htm for details.",""," This software is distributed WITHOUT ANY WARRANTY; without even"," the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR"," PURPOSE.  See the above copyright notice for more information.",""," =========================================================================*/","","// .NAME Quadrics_fs.glsl and Quadrics_vs.glsl","// .SECTION Thanks","// <verbatim>","//","//  This file is part of the PointSprites plugin developed and contributed by","//","//  Copyright (c) CSCS - Swiss National Supercomputing Centre","//                EDF - Electricite de France","//","//  John Biddiscombe, Ugo Varetto (CSCS)","//  Stephane Ploix (EDF)","//","// </verbatim>","//","// Contributions by Alexander Rose","// - ported to WebGL","// - adapted to work with quads","void ComputePointSizeAndPositionInClipCoordSphere(){","","    vec2 xbc;","    vec2 ybc;","","    mat4 T = mat4(","        radius, 0.0, 0.0, 0.0,","        0.0, radius, 0.0, 0.0,","        0.0, 0.0, radius, 0.0,","        position.x, position.y, position.z, 1.0","    );","","    mat4 R = transposeTmp( projectionMatrix * modelViewMatrix * T );","    float A = dot( R[ 3 ], D * R[ 3 ] );","    float B = -2.0 * dot( R[ 0 ], D * R[ 3 ] );","    float C = dot( R[ 0 ], D * R[ 0 ] );","    xbc[ 0 ] = ( -B - sqrt( B * B - 4.0 * A * C ) ) / ( 2.0 * A );","    xbc[ 1 ] = ( -B + sqrt( B * B - 4.0 * A * C ) ) / ( 2.0 * A );","    float sx = abs( xbc[ 0 ] - xbc[ 1 ] ) * 0.5;","","    A = dot( R[ 3 ], D * R[ 3 ] );","    B = -2.0 * dot( R[ 1 ], D * R[ 3 ] );","    C = dot( R[ 1 ], D * R[ 1 ] );","    ybc[ 0 ] = ( -B - sqrt( B * B - 4.0 * A * C ) ) / ( 2.0 * A );","    ybc[ 1 ] = ( -B + sqrt( B * B - 4.0 * A * C ) ) / ( 2.0 * A );","    float sy = abs( ybc[ 0 ] - ybc[ 1 ]  ) * 0.5;","","    gl_Position.xy = vec2( 0.5 * ( xbc.x + xbc.y ), 0.5 * ( ybc.x + ybc.y ) );","    gl_Position.xy -= mapping * vec2( sx, sy );","    gl_Position.xy *= gl_Position.w;","","}","","void main(void){","","    #ifdef PICKING","        vPickingColor = unpackColor( primitiveId );","    #else","        #include color_vertex","    #endif","","    vRadius = radius * matrixScale( modelViewMatrix );","","    vec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );","    // avoid clipping, added again in fragment shader","    mvPosition.z -= vRadius;","","    gl_Position = projectionMatrix * vec4( mvPosition.xyz, 1.0 );","    ComputePointSizeAndPositionInClipCoordSphere();","","","    vRadiusSq = vRadius * vRadius;","    vec4 vPoint4 = projectionMatrixInverse * gl_Position;","    vPoint = vPoint4.xyz / vPoint4.w;","    vPointViewPosition = -mvPosition.xyz / mvPosition.w;","","}"].join("\n"),$NGL_shaderTextHash["CylinderImpostor.frag"]=["#define STANDARD","#define IMPOSTOR","","// Open-Source PyMOL is Copyright (C) Schrodinger, LLC.","//","//  All Rights Reserved","//","//  Permission to use, copy, modify, distribute, and distribute modified","//  versions of this software and its built-in documentation for any","//  purpose and without fee is hereby granted, provided that the above","//  copyright notice appears in all copies and that both the copyright","//  notice and this permission notice appear in supporting documentation,","//  and that the name of Schrodinger, LLC not be used in advertising or","//  publicity pertaining to distribution of the software without specific,","//  written prior permission.","//","//  SCHRODINGER, LLC DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,","//  INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS. IN","//  NO EVENT SHALL SCHRODINGER, LLC BE LIABLE FOR ANY SPECIAL, INDIRECT OR","//  CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS","//  OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE","//  OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE","//  USE OR PERFORMANCE OF THIS SOFTWARE.","","// Contributions by Alexander Rose","// - ported to WebGL","// - dual color","// - pk color","// - custom clipping","// - three.js lighting","","uniform vec3 diffuse;","uniform vec3 emissive;","uniform float roughness;","uniform float metalness;","uniform float opacity;","uniform float nearClip;","uniform mat4 projectionMatrix;","uniform float ortho;","","varying vec3 axis;","varying vec4 base_radius;","varying vec4 end_b;","varying vec3 U;","varying vec3 V;","varying vec4 w;","","#ifdef PICKING","    uniform float objectId;","    varying vec3 vPickingColor;","#else","    varying vec3 vColor1;","    varying vec3 vColor2;","    #include common","    #include fog_pars_fragment","    #include bsdfs","    #include lights_pars_begin","    #include lights_physical_pars_fragment","#endif","","bool interior = false;","","float distSq3( vec3 v3a, vec3 v3b ){","    return (","        ( v3a.x - v3b.x ) * ( v3a.x - v3b.x ) +","        ( v3a.y - v3b.y ) * ( v3a.y - v3b.y ) +","        ( v3a.z - v3b.z ) * ( v3a.z - v3b.z )","    );","}","","// Calculate depth based on the given camera position.","float calcDepth( in vec3 cameraPos ){","    vec2 clipZW = cameraPos.z * projectionMatrix[2].zw + projectionMatrix[3].zw;","    return 0.5 + 0.5 * clipZW.x / clipZW.y;","}","","float calcClip( vec3 cameraPos ){","    return dot( vec4( cameraPos, 1.0 ), vec4( 0.0, 0.0, 1.0, nearClip - 0.5 ) );","}","","void main(){","","    vec3 point = w.xyz / w.w;","","    // unpacking","    vec3 base = base_radius.xyz;","    float vRadius = base_radius.w;","    vec3 end = end_b.xyz;","    float b = end_b.w;","","    vec3 end_cyl = end;","    vec3 surface_point = point;","","    vec3 ray_target = surface_point;","    vec3 ray_origin = vec3(0.0);","    vec3 ray_direction = mix(normalize(ray_origin - ray_target), vec3(0.0, 0.0, 1.0), ortho);","    mat3 basis = mat3( U, V, axis );","","    vec3 diff = ray_target - 0.5 * (base + end_cyl);","    vec3 P = diff * basis;","","    // angle (cos) between cylinder cylinder_axis and ray direction","    float dz = dot( axis, ray_direction );","","    float radius2 = vRadius*vRadius;","","    // calculate distance to the cylinder from ray origin","    vec3 D = vec3(dot(U, ray_direction),","                dot(V, ray_direction),","                dz);","    float a0 = P.x*P.x + P.y*P.y - radius2;","    float a1 = P.x*D.x + P.y*D.y;","    float a2 = D.x*D.x + D.y*D.y;","","    // calculate a dicriminant of the above quadratic equation","    float d = a1*a1 - a0*a2;","    if (d < 0.0)","        // outside of the cylinder","        discard;","","    float dist = (-a1 + sqrt(d)) / a2;","","    // point of intersection on cylinder surface","    vec3 new_point = ray_target + dist * ray_direction;","","    vec3 tmp_point = new_point - base;","    vec3 _normal = normalize( tmp_point - axis * dot(tmp_point, axis) );","","    ray_origin = mix( ray_origin, surface_point, ortho );","","    // test caps","    float front_cap_test = dot( tmp_point, axis );","    float end_cap_test = dot((new_point - end_cyl), axis);","","    // to calculate caps, simply check the angle between","    // the point of intersection - cylinder end vector","    // and a cap plane normal (which is the cylinder cylinder_axis)","    // if the angle < 0, the point is outside of cylinder","    // test front cap","","    #ifndef CAP","        vec3 new_point2 = ray_target + ( (-a1 - sqrt(d)) / a2 ) * ray_direction;","        vec3 tmp_point2 = new_point2 - base;","    #endif","","    // flat","    if (front_cap_test < 0.0)","    {","        // ray-plane intersection","        float dNV = dot(-axis, ray_direction);","        if (dNV < 0.0)","            discard;","        float near = dot(-axis, (base)) / dNV;","        vec3 front_point = ray_direction * near + ray_origin;","        // within the cap radius?","        if (dot(front_point - base, front_point-base) > radius2)","            discard;","","        #ifdef CAP","            new_point = front_point;","            _normal = axis;","        #else","            new_point = ray_target + ( (-a1 - sqrt(d)) / a2 ) * ray_direction;","            dNV = dot(-axis, ray_direction);","            near = dot(axis, end_cyl) / dNV;","            new_point2 = ray_direction * near + ray_origin;","            if (dot(new_point2 - end_cyl, new_point2-base) < radius2)","                discard;","            interior = true;","        #endif","    }","","    // test end cap","","","    // flat","    if( end_cap_test > 0.0 )","    {","        // ray-plane intersection","        float dNV = dot(axis, ray_direction);","        if (dNV < 0.0)","            discard;","        float near = dot(axis, end_cyl) / dNV;","        vec3 end_point = ray_direction * near + ray_origin;","        // within the cap radius?","        if( dot(end_point - end_cyl, end_point-base) > radius2 )","            discard;","","        #ifdef CAP","            new_point = end_point;","            _normal = axis;","        #else","            new_point = ray_target + ( (-a1 - sqrt(d)) / a2 ) * ray_direction;","            dNV = dot(-axis, ray_direction);","            near = dot(-axis, (base)) / dNV;","            new_point2 = ray_direction * near + ray_origin;","            if (dot(new_point2 - base, new_point2-base) < radius2)","                discard;","            interior = true;","        #endif","    }","","    gl_FragDepthEXT = calcDepth( new_point );","","    #ifdef NEAR_CLIP","        if( calcClip( new_point ) > 0.0 ){","            dist = (-a1 - sqrt(d)) / a2;","            new_point = ray_target + dist * ray_direction;","            if( calcClip( new_point ) > 0.0 )","                discard;","            interior = true;","            gl_FragDepthEXT = calcDepth( new_point );","            if( gl_FragDepthEXT >= 0.0 ){","                gl_FragDepthEXT = max( 0.0, calcDepth( vec3( - ( nearClip - 0.5 ) ) ) + ( 0.0000001 / vRadius ) );","            }","        }else if( gl_FragDepthEXT <= 0.0 ){","            dist = (-a1 - sqrt(d)) / a2;","            new_point = ray_target + dist * ray_direction;","            interior = true;","            gl_FragDepthEXT = calcDepth( new_point );","            if( gl_FragDepthEXT >= 0.0 ){","                gl_FragDepthEXT = 0.0 + ( 0.0000001 / vRadius );","            }","        }","    #else","        if( gl_FragDepthEXT <= 0.0 ){","            dist = (-a1 - sqrt(d)) / a2;","            new_point = ray_target + dist * ray_direction;","            interior = true;","            gl_FragDepthEXT = calcDepth( new_point );","            if( gl_FragDepthEXT >= 0.0 ){","                gl_FragDepthEXT = 0.0 + ( 0.0000001 / vRadius );","            }","        }","    #endif","","    // this is a workaround necessary for Mac","    // otherwise the modified fragment won't clip properly","    if (gl_FragDepthEXT < 0.0)","        discard;","    if (gl_FragDepthEXT > 1.0)","        discard;","","    #ifdef PICKING","","        gl_FragColor = vec4( vPickingColor, objectId );","","    #else","","        vec3 vViewPosition = -new_point;","        vec3 vNormal = _normal;","        vec3 vColor;","","        if( distSq3( new_point, end_cyl ) < distSq3( new_point, base ) ){","            if( b < 0.0 ){","                vColor = vColor1;","            }else{","                vColor = vColor2;","            }","        }else{","            if( b > 0.0 ){","                vColor = vColor1;","            }else{","                vColor = vColor2;","            }","        }","","        vec4 diffuseColor = vec4( diffuse, opacity );","        ReflectedLight reflectedLight = ReflectedLight( vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ) );","        vec3 totalEmissiveLight = emissive;","","        #include color_fragment","     //ifdef USE_COLOR","     //diffuseColor.r *= vColor[0];","     //diffuseColor.g *= vColor[1];","     //diffuseColor.b *= vColor[2];","     //endif","        #include roughnessmap_fragment","        #include metalnessmap_fragment","","        // don't use include normal_fragment","        vec3 normal = normalize( vNormal );","","        #include lights_physical_fragment","        //include lights_template","        #include lights_fragment_begin","        #include lights_fragment_end","","        vec3 outgoingLight = reflectedLight.directDiffuse + reflectedLight.indirectDiffuse + reflectedLight.directSpecular + reflectedLight.indirectSpecular + totalEmissiveLight;","","        gl_FragColor = vec4( outgoingLight, diffuseColor.a );","        //gl_FragColor = vec4( reflectedLight.directSpecular, diffuseColor.a );","","        #include premultiplied_alpha_fragment","        #include tonemapping_fragment","        #include encodings_fragment","        //include fog_fragment","        #ifdef USE_FOG","            #ifdef USE_LOGDEPTHBUF_EXT","                float depth = gl_FragDepthEXT / gl_FragCoord.w;","            #else","                float depth = gl_FragCoord.z / gl_FragCoord.w;","            #endif","            #ifdef FOG_EXP2","                float fogFactor = whiteCompliment( exp2( - fogDensity * fogDensity * depth * depth * LOG2 ) );","            #else","                float fogFactor = smoothstep( fogNear, fogFar, depth );","            #endif","            gl_FragColor.rgb = mix( gl_FragColor.rgb, fogColor, fogFactor );","        #endif","","    #endif","","}"].join("\n"),$NGL_shaderTextHash["CylinderImpostor.vert"]=["// Open-Source PyMOL is Copyright (C) Schrodinger, LLC.","//","//  All Rights Reserved","//","//  Permission to use, copy, modify, distribute, and distribute modified","//  versions of this software and its built-in documentation for any","//  purpose and without fee is hereby granted, provided that the above","//  copyright notice appears in all copies and that both the copyright","//  notice and this permission notice appear in supporting documentation,","//  and that the name of Schrodinger, LLC not be used in advertising or","//  publicity pertaining to distribution of the software without specific,","//  written prior permission.","//","//  SCHRODINGER, LLC DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,","//  INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS. IN","//  NO EVENT SHALL SCHRODINGER, LLC BE LIABLE FOR ANY SPECIAL, INDIRECT OR","//  CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS","//  OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE","//  OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE","//  USE OR PERFORMANCE OF THIS SOFTWARE.","","// Contributions by Alexander Rose","// - ported to WebGL","// - dual color","// - pk color","// - shift","","attribute vec3 mapping;","attribute vec3 position1;","attribute vec3 position2;","attribute float radius;","","varying vec3 axis;","varying vec4 base_radius;","varying vec4 end_b;","varying vec3 U;","varying vec3 V;","varying vec4 w;","varying float fogDepth;","varying float fogNear;","varying float fogFar;","","#ifdef PICKING","    #include unpack_clr","    attribute float primitiveId;","    varying vec3 vPickingColor;","#else","    //attribute vec3 color;","    attribute vec3 color2;","    varying vec3 vColor1;","    varying vec3 vColor2;","#endif","","uniform mat4 modelViewMatrixInverse;","uniform float ortho;","","//include matrix_scale","float matrixScale( in mat4 m ){","    vec4 r = m[ 0 ];","    return sqrt( r[ 0 ] * r[ 0 ] + r[ 1 ] * r[ 1 ] + r[ 2 ] * r[ 2 ] );","}","","void main(){","","    #ifdef PICKING","        vPickingColor = unpackColor( primitiveId );","    #else","        vColor1 = color;","        vColor2 = color2;","    #endif","","    // vRadius = radius;","    base_radius.w = radius * matrixScale( modelViewMatrix );","","    //vec3 center = position;","    vec3 center = ( position2 + position1 ) / 2.0;","    vec3 dir = normalize( position2 - position1 );","    float ext = length( position2 - position1 ) / 2.0;","","    // using cameraPosition fails on some machines, not sure why","    // vec3 cam_dir = normalize( cameraPosition - mix( center, vec3( 0.0 ), ortho ) );","    vec3 cam_dir;","    if( ortho == 0.0 ){","        cam_dir = ( modelViewMatrixInverse * vec4( 0, 0, 0, 1 ) ).xyz - center;","    }else{","        cam_dir = ( modelViewMatrixInverse * vec4( 0, 0, 1, 0 ) ).xyz;","    }","    cam_dir = normalize( cam_dir );","","    vec3 ldir;","","    float b = dot( cam_dir, dir );","    end_b.w = b;","    // direction vector looks away, so flip","    if( b < 0.0 )","        ldir = -ext * dir;","    // direction vector already looks in my direction","    else","        ldir = ext * dir;","","    vec3 left = normalize( cross( cam_dir, ldir ) );","    left = radius * left;","    vec3 up = radius * normalize( cross( left, ldir ) );","","    // transform to modelview coordinates","    axis = normalize( normalMatrix * ldir );","    U = normalize( normalMatrix * up );","    V = normalize( normalMatrix * left );","","    vec4 base4 = modelViewMatrix * vec4( center - ldir, 1.0 );","    base_radius.xyz = base4.xyz / base4.w;","","    vec4 top_position = modelViewMatrix * vec4( center + ldir, 1.0 );","    vec4 end4 = top_position;","    end_b.xyz = end4.xyz / end4.w;","","    w = modelViewMatrix * vec4(","        center + mapping.x*ldir + mapping.y*left + mapping.z*up, 1.0","    );","","    gl_Position = projectionMatrix * w;","","    // avoid clipping (1.0 seems to induce flickering with some drivers)","    gl_Position.z = 0.99;","","}"].join("\n"),$NGL_shaderTextHash["SphereInstancing.frag"]=$NGL_shaderTextHash["SphereImpostor.frag"],$NGL_shaderTextHash["SphereInstancing.vert"]=["uniform mat4 projectionMatrixInverse;","uniform float nearClip;","","varying float vRadius;","varying float vRadiusSq;","varying vec3 vPoint;","varying vec3 vPointViewPosition;","varying float fogDepth;","varying float fogNear;","varying float fogFar;","","attribute vec2 mapping;","//attribute vec3 position;","attribute float radius;","attribute vec4 matrix1;","attribute vec4 matrix2;","attribute vec4 matrix3;","attribute vec4 matrix4;","","#ifdef PICKING","    #include unpack_clr","    attribute float primitiveId;","    varying vec3 vPickingColor;","#else","    #include color_pars_vertex","#endif","","//include matrix_scale","float matrixScale( in mat4 m ){","    vec4 r = m[ 0 ];","    return sqrt( r[ 0 ] * r[ 0 ] + r[ 1 ] * r[ 1 ] + r[ 2 ] * r[ 2 ] );","}","","const mat4 D = mat4(","    1.0, 0.0, 0.0, 0.0,","    0.0, 1.0, 0.0, 0.0,","    0.0, 0.0, 1.0, 0.0,","    0.0, 0.0, 0.0, -1.0",");","","mat4 transposeTmp( in mat4 inMatrix ) {","    vec4 i0 = inMatrix[0];","    vec4 i1 = inMatrix[1];","    vec4 i2 = inMatrix[2];","    vec4 i3 = inMatrix[3];","","    mat4 outMatrix = mat4(","        vec4(i0.x, i1.x, i2.x, i3.x),","        vec4(i0.y, i1.y, i2.y, i3.y),","        vec4(i0.z, i1.z, i2.z, i3.z),","        vec4(i0.w, i1.w, i2.w, i3.w)","    );","    return outMatrix;","}","","//------------------------------------------------------------------------------","// Compute point size and center using the technique described in:","// 'GPU-Based Ray-Casting of Quadratic Surfaces'","// by Christian Sigg, Tim Weyrich, Mario Botsch, Markus Gross.","//","// Code based on","/*=========================================================================",""," Program:   Visualization Toolkit"," Module:    Quadrics_fs.glsl and Quadrics_vs.glsl",""," Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen"," All rights reserved."," See Copyright.txt or http://www.kitware.com/Copyright.htm for details.",""," This software is distributed WITHOUT ANY WARRANTY; without even"," the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR"," PURPOSE.  See the above copyright notice for more information.",""," =========================================================================*/","","// .NAME Quadrics_fs.glsl and Quadrics_vs.glsl","// .SECTION Thanks","// <verbatim>","//","//  This file is part of the PointSprites plugin developed and contributed by","//","//  Copyright (c) CSCS - Swiss National Supercomputing Centre","//                EDF - Electricite de France","//","//  John Biddiscombe, Ugo Varetto (CSCS)","//  Stephane Ploix (EDF)","//","// </verbatim>","//","// Contributions by Alexander Rose","// - ported to WebGL","// - adapted to work with quads","void ComputePointSizeAndPositionInClipCoordSphere(vec4 updatePosition){","","    vec2 xbc;","    vec2 ybc;","","    mat4 T = mat4(","        radius, 0.0, 0.0, 0.0,","        0.0, radius, 0.0, 0.0,","        0.0, 0.0, radius, 0.0,","        updatePosition.x, updatePosition.y, updatePosition.z, 1.0","    );","","    mat4 R = transposeTmp( projectionMatrix * modelViewMatrix * T );","    float A = dot( R[ 3 ], D * R[ 3 ] );","    float B = -2.0 * dot( R[ 0 ], D * R[ 3 ] );","    float C = dot( R[ 0 ], D * R[ 0 ] );","    xbc[ 0 ] = ( -B - sqrt( B * B - 4.0 * A * C ) ) / ( 2.0 * A );","    xbc[ 1 ] = ( -B + sqrt( B * B - 4.0 * A * C ) ) / ( 2.0 * A );","    float sx = abs( xbc[ 0 ] - xbc[ 1 ] ) * 0.5;","","    A = dot( R[ 3 ], D * R[ 3 ] );","    B = -2.0 * dot( R[ 1 ], D * R[ 3 ] );","    C = dot( R[ 1 ], D * R[ 1 ] );","    ybc[ 0 ] = ( -B - sqrt( B * B - 4.0 * A * C ) ) / ( 2.0 * A );","    ybc[ 1 ] = ( -B + sqrt( B * B - 4.0 * A * C ) ) / ( 2.0 * A );","    float sy = abs( ybc[ 0 ] - ybc[ 1 ]  ) * 0.5;","","    gl_Position.xy = vec2( 0.5 * ( xbc.x + xbc.y ), 0.5 * ( ybc.x + ybc.y ) );","    gl_Position.xy -= mapping * vec2( sx, sy );","    gl_Position.xy *= gl_Position.w;","","}","","  mat4 computeMat(vec4 v1, vec4 v2, vec4 v3, vec4 v4) {","    return mat4(","      v1.x, v1.y, v1.z, v1.w,","      v2.x, v2.y, v2.z, v2.w,","      v3.x, v3.y, v3.z, v3.w,","      v4.x, v4.y, v4.z, v4.w","    );","  }","","void main(void){","","    #ifdef PICKING","        vPickingColor = unpackColor( primitiveId );","    #else","        #include color_vertex","    #endif","","    vRadius = radius * matrixScale( modelViewMatrix );","","    mat4 matrix = computeMat(matrix1, matrix2, matrix3, matrix4);","    vec4 updatePosition = matrix * vec4(position, 1.0);","","//    vec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );","    vec4 mvPosition = modelViewMatrix * vec4( updatePosition.xyz, 1.0 );","    // avoid clipping, added again in fragment shader","    mvPosition.z -= vRadius;","","//    gl_Position = projectionMatrix * vec4( mvPosition.xyz, 1.0 );","    gl_Position = projectionMatrix * vec4( mvPosition.xyz, 1.0 );","    ComputePointSizeAndPositionInClipCoordSphere(updatePosition);","","","    vRadiusSq = vRadius * vRadius;","    vec4 vPoint4 = projectionMatrixInverse * gl_Position;","    vPoint = vPoint4.xyz / vPoint4.w;","    vPointViewPosition = -mvPosition.xyz / mvPosition.w;","","}"].join("\n"),$NGL_shaderTextHash["CylinderInstancing.frag"]=$NGL_shaderTextHash["CylinderImpostor.frag"],$NGL_shaderTextHash["CylinderInstancing.vert"]=["// Open-Source PyMOL is Copyright (C) Schrodinger, LLC.","//","//  All Rights Reserved","//","//  Permission to use, copy, modify, distribute, and distribute modified","//  versions of this software and its built-in documentation for any","//  purpose and without fee is hereby granted, provided that the above","//  copyright notice appears in all copies and that both the copyright","//  notice and this permission notice appear in supporting documentation,","//  and that the name of Schrodinger, LLC not be used in advertising or","//  publicity pertaining to distribution of the software without specific,","//  written prior permission.","//","//  SCHRODINGER, LLC DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,","//  INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS. IN","//  NO EVENT SHALL SCHRODINGER, LLC BE LIABLE FOR ANY SPECIAL, INDIRECT OR","//  CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS","//  OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE","//  OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE","//  USE OR PERFORMANCE OF THIS SOFTWARE.","","// Contributions by Alexander Rose","// - ported to WebGL","// - dual color","// - pk color","// - shift","","attribute vec3 mapping;","attribute vec3 position1;","attribute vec3 position2;","attribute float radius;","attribute vec4 matrix1;","attribute vec4 matrix2;","attribute vec4 matrix3;","attribute vec4 matrix4;","","varying vec3 axis;","varying vec4 base_radius;","varying vec4 end_b;","varying vec3 U;","varying vec3 V;","varying vec4 w;","varying float fogDepth;","varying float fogNear;","varying float fogFar;","","#ifdef PICKING","    #include unpack_clr","    attribute float primitiveId;","    varying vec3 vPickingColor;","#else","    //attribute vec3 color;","    attribute vec3 color2;","    varying vec3 vColor1;","    varying vec3 vColor2;","#endif","","uniform mat4 modelViewMatrixInverse;","uniform float ortho;","","//include matrix_scale","float matrixScale( in mat4 m ){","    vec4 r = m[ 0 ];","    return sqrt( r[ 0 ] * r[ 0 ] + r[ 1 ] * r[ 1 ] + r[ 2 ] * r[ 2 ] );","}","","  mat4 computeMat(vec4 v1, vec4 v2, vec4 v3, vec4 v4) {","    return mat4(","      v1.x, v1.y, v1.z, v1.w,","      v2.x, v2.y, v2.z, v2.w,","      v3.x, v3.y, v3.z, v3.w,","      v4.x, v4.y, v4.z, v4.w","    );","  }","","void main(){","","    #ifdef PICKING","        vPickingColor = unpackColor( primitiveId );","    #else","        vColor1 = color;","        vColor2 = color2;","    #endif","","    // vRadius = radius;","    base_radius.w = radius * matrixScale( modelViewMatrix );","","    //vec3 center = ( position2 + position1 ) / 2.0;","","    mat4 matrix = computeMat(matrix1, matrix2, matrix3, matrix4);","    vec4 updatePosition1 = matrix * vec4(position1, 1.0);","    vec4 updatePosition2 = matrix * vec4(position2, 1.0);","    vec3 center = ( updatePosition2.xyz + updatePosition1.xyz ) / 2.0;","","    //vec3 dir = normalize( position2 - position1 );","    vec3 dir = normalize( updatePosition2.xyz - updatePosition1.xyz );","    float ext = length( position2 - position1 ) / 2.0;","","    // using cameraPosition fails on some machines, not sure why","    // vec3 cam_dir = normalize( cameraPosition - mix( center, vec3( 0.0 ), ortho ) );","    vec3 cam_dir;","    if( ortho == 0.0 ){","        cam_dir = ( modelViewMatrixInverse * vec4( 0, 0, 0, 1 ) ).xyz - center;","    }else{","        cam_dir = ( modelViewMatrixInverse * vec4( 0, 0, 1, 0 ) ).xyz;","    }","    cam_dir = normalize( cam_dir );","","    vec3 ldir;","","    float b = dot( cam_dir, dir );","    end_b.w = b;","    // direction vector looks away, so flip","    if( b < 0.0 )","        ldir = -ext * dir;","    // direction vector already looks in my direction","    else","        ldir = ext * dir;","","    vec3 left = normalize( cross( cam_dir, ldir ) );","    left = radius * left;","    vec3 up = radius * normalize( cross( left, ldir ) );","","    // transform to modelview coordinates","    axis = normalize( normalMatrix * ldir );","    U = normalize( normalMatrix * up );","    V = normalize( normalMatrix * left );","","    vec4 base4 = modelViewMatrix * vec4( center - ldir, 1.0 );","    base_radius.xyz = base4.xyz / base4.w;","","    vec4 top_position = modelViewMatrix * vec4( center + ldir, 1.0 );","    vec4 end4 = top_position;","    end_b.xyz = end4.xyz / end4.w;","","    w = modelViewMatrix * vec4(","        center + mapping.x*ldir + mapping.y*left + mapping.z*up, 1.0","    );","","    gl_Position = projectionMatrix * w;","","    // avoid clipping (1.0 seems to induce flickering with some drivers)","    gl_Position.z = 0.99;","","}"].join("\n"),$NGL_shaderTextHash["Instancing.frag"]=["#define STANDARD","uniform vec3 diffuse;","uniform vec3 emissive;","uniform float roughness;","uniform float metalness;","uniform float opacity;","uniform float nearClip;","uniform float clipRadius;","uniform mat4 projectionMatrix;","uniform float ortho;","varying float bCylinder;","","#if defined( NEAR_CLIP ) || defined( RADIUS_CLIP ) || ( !defined( PICKING ) && !defined( NOLIGHT ) )","    varying vec3 vViewPosition;","#endif","","#if defined( RADIUS_CLIP )","    varying vec3 vClipCenter;","#endif","","#if defined( PICKING )","    uniform float objectId;","    varying vec3 vPickingColor;","#elif defined( NOLIGHT )","    varying vec3 vColor;","#else","    #ifndef FLAT_SHADED","        varying vec3 vNormal;","    #endif","    #include common","    #include color_pars_fragment","    #include fog_pars_fragment","    #include bsdfs","    #include lights_pars_begin","    #include lights_physical_pars_fragment","#endif","","void main(){","    #include nearclip_fragment","    #include radiusclip_fragment","","    #if defined( PICKING )","","        gl_FragColor = vec4( vPickingColor, objectId );","","    #elif defined( NOLIGHT )","","        gl_FragColor = vec4( vColor, opacity );","","    #else","","        vec4 diffuseColor = vec4( diffuse, opacity );","        ReflectedLight reflectedLight = ReflectedLight( vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ) );","        vec3 totalEmissiveLight = emissive;","","        #include color_fragment","        #include roughnessmap_fragment","        #include metalnessmap_fragment","        #include normal_flip","        #include normal_fragment_begin","","        //include dull_interior_fragment","","        #include lights_physical_fragment","        //include lights_template","        #include lights_fragment_begin","        #include lights_fragment_end","","        vec3 outgoingLight = reflectedLight.directDiffuse + reflectedLight.indirectDiffuse + reflectedLight.directSpecular + reflectedLight.indirectSpecular + totalEmissiveLight;","","        #include interior_fragment","","        gl_FragColor = vec4( outgoingLight, diffuseColor.a );","","        #include premultiplied_alpha_fragment","        #include tonemapping_fragment","        #include encodings_fragment","        #include fog_fragment","","        #include opaque_back_fragment","","    #endif","","}"].join("\n"),$NGL_shaderTextHash["Instancing.vert"]=["#define STANDARD","","uniform mat4 projectionMatrixInverse;","uniform float nearClip;","uniform vec3 clipCenter;","attribute vec4 matrix1;","attribute vec4 matrix2;","attribute vec4 matrix3;","attribute vec4 matrix4;","attribute float cylinder;","varying float bCylinder;","","#if defined( NEAR_CLIP ) || defined( RADIUS_CLIP ) || ( !defined( PICKING ) && !defined( NOLIGHT ) )","    varying vec3 vViewPosition;","#endif","","#if defined( RADIUS_CLIP )","    varying vec3 vClipCenter;","#endif","","#if defined( PICKING )","    #include unpack_color","    attribute float primitiveId;","    varying vec3 vPickingColor;","#elif defined( NOLIGHT )","    varying vec3 vColor;","#else","    #include color_pars_vertex","    #ifndef FLAT_SHADED","        varying vec3 vNormal;","    #endif","#endif","","#include common","","  mat4 computeMat(vec4 v1, vec4 v2, vec4 v3, vec4 v4) {","    return mat4(","      v1.x, v1.y, v1.z, v1.w,","      v2.x, v2.y, v2.z, v2.w,","      v3.x, v3.y, v3.z, v3.w,","      v4.x, v4.y, v4.z, v4.w","    );","  }","","void main(){","    bCylinder = cylinder;","","    mat4 matrix = computeMat(matrix1, matrix2, matrix3, matrix4);","    vec4 updatePosition = matrix * vec4(position, 1.0);","","    #if defined( PICKING )","        vPickingColor = unpackColor( primitiveId );","    #elif defined( NOLIGHT )","        vColor = color;","    #else","        #include color_vertex","        //include beginnormal_vertex","        //vec3 objectNormal = vec3( normal );","        vec3 objectNormal = vec3(matrix * vec4(normal,0.0));","        #include defaultnormal_vertex","        // Normal computed with derivatives when FLAT_SHADED","        #ifndef FLAT_SHADED","            vNormal = normalize( transformedNormal );","        #endif","    #endif","","    //include begin_vertex","    vec3 transformed = updatePosition.xyz;","    //include project_vertex","    vec4 mvPosition = modelViewMatrix * vec4( transformed, 1.0 );","    gl_Position = projectionMatrix * mvPosition;","","    #if defined( NEAR_CLIP ) || defined( RADIUS_CLIP ) || ( !defined( PICKING ) && !defined( NOLIGHT ) )","        vViewPosition = -mvPosition.xyz;","    #endif","","    #if defined( RADIUS_CLIP )","        vClipCenter = -( modelViewMatrix * vec4( clipCenter, 1.0 ) ).xyz;","    #endif","","    #include nearclip_vertex","","}"].join("\n"),THREE.RenderableObject=function(){"use strict";this.id=0,this.object=null,this.z=0},THREE.RenderableFace=function(){"use strict";this.id=0,this.v1=new THREE.RenderableVertex,this.v2=new THREE.RenderableVertex,this.v3=new THREE.RenderableVertex,this.normalModel=new THREE.Vector3,this.vertexNormalsModel=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3],this.vertexNormalsLength=0,this.color=new THREE.Color,this.material=null,this.uvs=[new THREE.Vector2,new THREE.Vector2,new THREE.Vector2],this.z=0},THREE.RenderableVertex=function(){"use strict";this.position=new THREE.Vector3,this.positionWorld=new THREE.Vector3,this.positionScreen=new THREE.Vector4,this.visible=!0},THREE.RenderableVertex.prototype.copy=function(e){"use strict";this.positionWorld.copy(e.positionWorld),this.positionScreen.copy(e.positionScreen)},THREE.RenderableLine=function(){"use strict";this.id=0,this.v1=new THREE.RenderableVertex,this.v2=new THREE.RenderableVertex,this.vertexColors=[new THREE.Color,new THREE.Color],this.material=null,this.z=0},THREE.RenderableSprite=function(){"use strict";this.id=0,this.object=null,this.x=0,this.y=0,this.z=0,this.rotation=0,this.scale=new THREE.Vector2,this.material=null},THREE.Projector=function(){"use strict";var e,t,n,r,i,o,a,s,c,u,d,l=[],f=0,p=[],h=0,g=[],v=0,m=[],y=0,E=[],w=0,b={objects:[],lights:[],elements:[]},_=(new THREE.Vector3,new THREE.Vector3,new THREE.Vector3,new THREE.Vector3),T=new THREE.Vector4,S=new THREE.Box3(new THREE.Vector3(-1,-1,-1),new THREE.Vector3(1,1,1)),C=new THREE.Box3,x=new Array(3),R=(new Array(4),new THREE.Matrix4),A=new THREE.Matrix4,k=(new THREE.Matrix4,new THREE.Matrix3,new THREE.Frustum);new THREE.Vector4,new THREE.Vector4;this.projectVector=function(e,t){console.warn("THREE.Projector: .projectVector() is now vector.project()."),e.project(t)},this.unprojectVector=function(e,t){console.warn("THREE.Projector: .unprojectVector() is now vector.unproject()."),e.unproject(t)},this.pkRay=function(e,t){console.error("THREE.Projector: .pkRay() is now raycaster.setFromCamera().")};var I=new function(){var e=[],t=[],c=null,u=null,l=new THREE.Matrix3,f=function(e){var t=e.position,n=e.positionWorld,r=e.positionScreen;n.copy(t).applyMatrix4(d),r.copy(n).applyMatrix4(A);var i=1/r.w;r.x*=i,r.y*=i,r.z*=i,e.visible=r.x>=-1&&r.x<=1&&r.y>=-1&&r.y<=1&&r.z>=-1&&r.z<=1},E=function(e,t,n){return!0===e.visible||!0===t.visible||!0===n.visible||(x[0]=e.positionScreen,x[1]=t.positionScreen,x[2]=n.positionScreen,S.isIntersectionBox(C.setFromPoints(x)))},w=function(e,t,n){return(n.positionScreen.x-e.positionScreen.x)*(t.positionScreen.y-e.positionScreen.y)-(n.positionScreen.y-e.positionScreen.y)*(t.positionScreen.x-e.positionScreen.x)<0};return{setObject:function(n){u=(c=n).material,l.getNormalMatrix(c.matrixWorld),e.length=0,t.length=0},projectVertex:f,checkTriangleVisibility:E,checkBackfaceCulling:w,pushVertex:function(e,t,i){(n=function(){if(r===h){var e=new THREE.RenderableVertex;return p.push(e),h++,r++,e}return p[r++]}()).position.set(e,t,i),f(n)},pushNormal:function(t,n,r){e.push(t,n,r)},pushUv:function(e,n){t.push(e,n)},pushLine:function(e,t){var n=p[e],r=p[t];(a=function(){if(s===y){var e=new THREE.RenderableLine;return m.push(e),y++,s++,e}return m[s++]}()).id=c.id,a.v1.copy(n),a.v2.copy(r),a.z=(n.positionScreen.z+r.positionScreen.z)/2,a.material=c.material,b.elements.push(a)},pushTriangle:function(n,r,a){var s=p[n],d=p[r],f=p[a];if(!1!==E(s,d,f)&&(u.side===THREE.DoubleSide||!0===w(s,d,f))){(i=function(){if(o===v){var e=new THREE.RenderableFace;return g.push(e),v++,o++,e}return g[o++]}()).id=c.id,i.v1.copy(s),i.v2.copy(d),i.v3.copy(f),i.z=(s.positionScreen.z+d.positionScreen.z+f.positionScreen.z)/3;for(var h=0;h<3;h++){var m=3*arguments[h],y=i.vertexNormalsModel[h];y.set(e[m],e[m+1],e[m+2]),y.applyMatrix3(l).normalize();var _=2*arguments[h];i.uvs[h].set(t[_],t[_+1])}i.vertexNormalsLength=3,i.material=c.material,b.elements.push(i)}}}};function P(){if(u===w){var e=new THREE.RenderableSprite;return E.push(e),w++,u++,e}return E[u++]}function N(e,t){return e.z!==t.z?t.z-e.z:e.id!==t.id?e.id-t.id:0}this.projectScene=function(n,i,a,p){o=0,s=0,u=0,b.elements.length=0,!0===n.autoUpdate&&n.updateMatrixWorld(),void 0===i.parent&&i.updateMatrixWorld(),R.copy(i.matrixWorldInverse.copy(i.matrixWorld).invert()),A.multiplyMatrices(i.projectionMatrix,R),k.setFromMatrix(A),t=0,b.objects.length=0,b.lights.length=0,n.traverseVisible(function(n){if(n instanceof THREE.Light)b.lights.push(n);else if(n instanceof THREE.Mesh||n instanceof THREE.Line||n instanceof THREE.Sprite){if(!1===n.material.visible)return;!1!==n.frustumCulled&&!0!==k.intersectsObject(n)||((e=function(){if(t===f){var e=new THREE.RenderableObject;return l.push(e),f++,t++,e}return l[t++]}()).id=n.id,e.object=n,_.setFromMatrixPosition(n.matrixWorld),_.applyProjection(A),e.z=_.z,b.objects.push(e))}}),!0===a&&b.objects.sort(N);for(var h=0,g=b.objects.length;h<g;h++){var v=b.objects[h].object,m=v.geometry;if(I.setObject(v),d=v.matrixWorld,r=0,v instanceof THREE.Mesh){if(m instanceof THREE.BufferGeometry){var y=m.attributes,E=m.offsets;if(void 0===y.position)continue;for(var w=0,S=(D=y.position.array).length;w<S;w+=3)I.pushVertex(D[w],D[w+1],D[w+2]);if(void 0!==y.normal){var C=y.normal.array;for(w=0,S=C.length;w<S;w+=3)I.pushNormal(C[w],C[w+1],C[w+2])}if(void 0!==y.uv){var x=y.uv.array;for(w=0,S=x.length;w<S;w+=2)I.pushUv(x[w],x[w+1])}if(void 0!==y.index){var O=y.index.array;if(E.length>0)for(h=0;h<E.length;h++){var L=E[h],z=L.index;for(w=L.start,S=L.start+L.count;w<S;w+=3)I.pushTriangle(O[w]+z,O[w+1]+z,O[w+2]+z)}else for(w=0,S=O.length;w<S;w+=3)I.pushTriangle(O[w],O[w+1],O[w+2])}else for(w=0,S=D.length/3;w<S;w+=3)I.pushTriangle(w,w+1,w+2)}}else if(v instanceof THREE.Line){if(m instanceof THREE.BufferGeometry)if(void 0!==(y=m.attributes).position){var D;for(w=0,S=(D=y.position.array).length;w<S;w+=3)I.pushVertex(D[w],D[w+1],D[w+2]);if(void 0!==y.index)for(w=0,S=(O=y.index.array).length;w<S;w+=2)I.pushLine(O[w],O[w+1]);else{var M=v.mode===THREE.LinePieces?2:1;for(w=0,S=D.length/3-1;w<S;w+=M)I.pushLine(w,w+1)}}}else if(v instanceof THREE.Sprite){T.set(d.elements[12],d.elements[13],d.elements[14],1),T.applyMatrix4(A);var H=1/T.w;T.z*=H,T.z>=-1&&T.z<=1&&((c=P()).id=v.id,c.x=T.x*H,c.y=T.y*H,c.z=T.z,c.object=v,c.rotation=v.rotation,c.scale.x=v.scale.x*Math.abs(c.x-(T.x+i.projectionMatrix.elements[0])/(T.w+i.projectionMatrix.elements[12])),c.scale.y=v.scale.y*Math.abs(c.y-(T.y+i.projectionMatrix.elements[5])/(T.w+i.projectionMatrix.elements[13])),c.material=v.material,b.elements.push(c))}}return!0===p&&b.elements.sort(N),b}},THREE.TrackballControls=function(e,t,n){"use strict";var r=this;this.STATE={NONE:-1,ROTATE:0,ZOOM:1,PAN:2,TOUCH_ROTATE:3,TOUCH_ZOOM_PAN:4},this.object=e,this.domElement=void 0!==t?t:document,this.enabled=!0,this.screen={left:0,top:0,width:0,height:0},this.rotateSpeed=1,this.zoomSpeed=1.2,this.panSpeed=.3,this.noRotate=!1,this.noZoom=!1,this.noPan=!1,this.noRoll=!1,this.staticMoving=!1,this.dynamicDampingFactor=.2,this.minDistance=0,this.maxDistance=1/0,this.keys=[65,83,68],this.target=new THREE.Vector3;var i=new THREE.Vector3;this._state=this.STATE.NONE;var o=this.STATE.NONE,a=new THREE.Vector3;this._rotateStart=new THREE.Vector3,this._rotateEnd=new THREE.Vector3,this._zoomStart=new THREE.Vector2,this._zoomEnd=new THREE.Vector2;var s=0,c=0;this._panStart=new THREE.Vector2,this._panEnd=new THREE.Vector2,this.target0=this.target.clone(),this.position0=this.object.position.clone(),this.up0=this.object.up.clone();var u={type:"change"},d={type:"start"},l={type:"end"};this.handleResize=function(){if(this.domElement===document)this.screen.left=0,this.screen.top=0,this.screen.width=window.innerWidth,this.screen.height=window.innerHeight;else if(this.domElement){var e=this.domElement.getBoundingClientRect(),t=this.domElement.ownerDocument.documentElement;this.screen.left=e.left+window.pageXOffset-t.clientLeft,this.screen.top=e.top+window.pageYOffset-t.clientTop,this.screen.width=e.width,this.screen.height=e.height}},this.handleEvent=function(e){"function"==typeof this[e.type]&&this[e.type](e)};var f,p,h,g,v,m,y,E,w,b=(f=new THREE.Vector2,function(e,t){return f.set((e-r.screen.left)/r.screen.width,(t-r.screen.top)/r.screen.height),f}),_=(p=new THREE.Vector3,h=new THREE.Vector3,g=new THREE.Vector3,function(e,t){g.set((e-.5*r.screen.width-r.screen.left)/(.5*r.screen.width),(.5*r.screen.height+r.screen.top-t)/(.5*r.screen.height),0);var n=g.length();return r.noRoll?n<Math.SQRT1_2?g.z=Math.sqrt(1-n*n):g.z=.5/n:n>1?g.normalize():g.z=Math.sqrt(1-n*n),a.copy(r.object.position).sub(r.target),p.copy(r.object.up).setLength(g.y),p.add(h.copy(r.object.up).cross(a).setLength(g.x)),p.add(a.setLength(g.z)),p});function T(e){!1===r.enabled||Object.keys(window).length<2||(window.removeEventListener("keydown",T),o=r._state,r._state===r.STATE.NONE&&(e.keyCode!==r.keys[r.STATE.ROTATE]||r.noRotate?e.keyCode!==r.keys[r.STATE.ZOOM]||r.noZoom?e.keyCode!==r.keys[r.STATE.PAN]||r.noPan||(r._state=r.STATE.PAN):r._state=r.STATE.ZOOM:r._state=r.STATE.ROTATE))}function S(e){!1===r.enabled||Object.keys(window).length<2||(e.stopPropagation(),r._state!==r.STATE.ROTATE||r.noRotate?r._state!==r.STATE.ZOOM||r.noZoom?r._state!==r.STATE.PAN||r.noPan||r._panEnd.copy(b(e.pageX,e.pageY)):r._zoomEnd.copy(b(e.pageX,e.pageY)):r._rotateEnd.copy(_(e.pageX,e.pageY)))}function C(e){!1===r.enabled||Object.keys(window).length<2||(e.stopPropagation(),r._state=r.STATE.NONE,document.removeEventListener("mousemove",S),document.removeEventListener("mouseup",C),r.dispatchEvent(l))}function x(e){if(!(!1===r.enabled||Object.keys(window).length<2)){e.stopPropagation();var t=0;e.wheelDelta?t=e.wheelDelta/40:e.detail&&(t=-e.detail/3),r._zoomStart.y=.005*t,r.dispatchEvent(d),r.dispatchEvent(l)}}this.rotateCamera=(v=new THREE.Vector3,m=new THREE.Quaternion,function(e,t){var i;void 0===e&&(i=Math.acos(r._rotateStart.dot(r._rotateEnd)/r._rotateStart.length()/r._rotateEnd.length())),(i||void 0!==e)&&(void 0===e?(v.crossVectors(r._rotateStart,r._rotateEnd).normalize(),i*=r.rotateSpeed,m.setFromAxisAngle(v,-i)):m.copy(e),void 0===n||void 0===n.quaternion||void 0!==t&&!0!==t||n.quaternion.multiplyQuaternions(m,n.quaternion),a.applyQuaternion(m),r.object.up.applyQuaternion(m),r._rotateEnd.applyQuaternion(m),r.staticMoving?r._rotateStart.copy(r._rotateEnd):(m.setFromAxisAngle(v,i*(r.dynamicDampingFactor-1)),r._rotateStart.applyQuaternion(m)))}),this.zoomCamera=function(e,t){var i;r._state===r.STATE.TOUCH_ZOOM_PAN?(void 0!==e?i=e:(i=s/c,s=c),a.multiplyScalar(i),void 0===n||void 0===n._zoomFactor||void 0!==t&&!0!==t||(n._zoomFactor*=i,n.fogCls.setFog())):(i=void 0!==e?e:1+(r._zoomEnd.y-r._zoomStart.y)*r.zoomSpeed,void 0===n||void 0===n._zoomFactor||void 0!==t&&!0!==t||(n._zoomFactor*=i,n.fogCls.setFog()),1!==i&&(a.multiplyScalar(i),r.staticMoving?r._zoomStart.copy(r._zoomEnd):r._zoomStart.y+=(r._zoomEnd.y-r._zoomStart.y)*this.dynamicDampingFactor))},this.panCamera=(y=new THREE.Vector2,E=new THREE.Vector3,w=new THREE.Vector3,function(e,t){void 0!==e?(y=e,void 0===n||void 0===n.mouseChange||void 0!==t&&!0!==t||n.mouseChange.add(e)):(y.copy(r._panEnd).sub(r._panStart),void 0===n||void 0===n.mouseChange||void 0!==t&&!0!==t||n.mouseChange.add(r._panEnd).sub(r._panStart)),y.lengthSq()&&(y.multiplyScalar(a.length()*r.panSpeed),w.copy(a).cross(r.object.up).setLength(y.x),w.add(E.copy(r.object.up).setLength(y.y)),r.object.position.add(w),r.target.add(w),r.staticMoving?r._panStart.copy(r._panEnd):r._panStart.add(y.subVectors(r._panEnd,r._panStart).multiplyScalar(r.dynamicDampingFactor)))}),this.checkDistances=function(){r.noZoom&&r.noPan||(a.lengthSq()>r.maxDistance*r.maxDistance&&r.object.position.addVectors(r.target,a.setLength(r.maxDistance)),a.lengthSq()<r.minDistance*r.minDistance&&r.object.position.addVectors(r.target,a.setLength(r.minDistance)))},this.update=function(e){a.subVectors(r.object.position,r.target),r.noRotate||(void 0!==e&&void 0!==e.quaternion?r.rotateCamera(e.quaternion,e.update):r.rotateCamera()),r.noZoom||(void 0!==e&&void 0!==e._zoomFactor?r.zoomCamera(e._zoomFactor,e.update):r.zoomCamera()),r.noPan||(void 0!==e&&void 0!==e.mouseChange?r.panCamera(e.mouseChange,e.update):r.panCamera()),r.object.position.addVectors(r.target,a),r.checkDistances(),r.object.lookAt(r.target),i.distanceToSquared(r.object.position)>1e-6&&(r.dispatchEvent(u),i.copy(r.object.position))},this.reset=function(){r._state=r.STATE.NONE,o=r.STATE.NONE,r.target.copy(r.target0),r.object.position.copy(r.position0),r.object.up.copy(r.up0),a.subVectors(r.object.position,r.target),r.object.lookAt(r.target),r.dispatchEvent(u),i.copy(r.object.position)},Object.keys(window).length>=2&&this.domElement&&(this.domElement.addEventListener("contextmn",function(e){},!1),this.domElement.addEventListener("mousedown",function(e){!1===r.enabled||Object.keys(window).length<2||(e.stopPropagation(),r._state===r.STATE.NONE&&(r._state=e.button),r._state!==r.STATE.ROTATE||r.noRotate?r._state!==r.STATE.ZOOM||r.noZoom?r._state!==r.STATE.PAN||r.noPan||(r._panStart.copy(b(e.pageX,e.pageY)),r._panEnd.copy(r._panStart)):(r._zoomStart.copy(b(e.pageX,e.pageY)),r._zoomEnd.copy(r._zoomStart)):(r._rotateStart.copy(_(e.pageX,e.pageY)),r._rotateEnd.copy(r._rotateStart)),document.addEventListener("mousemove",S,!1),document.addEventListener("mouseup",C,!1),r.dispatchEvent(d))},!1),this.domElement.addEventListener("mousewheel",x,!1),this.domElement.addEventListener("DOMMouseScroll",x,!1),this.domElement.addEventListener("touchstart",function(e){if(!(!1===r.enabled||Object.keys(window).length<2)){switch(e.touches.length){case 1:r._state=r.STATE.TOUCH_ROTATE,r._rotateStart.copy(_(e.touches[0].pageX,e.touches[0].pageY)),r._rotateEnd.copy(r._rotateStart);break;case 2:r._state=r.STATE.TOUCH_ZOOM_PAN;var t=e.touches[0].pageX-e.touches[1].pageX,n=e.touches[0].pageY-e.touches[1].pageY;c=s=Math.sqrt(t*t+n*n);var i=(e.touches[0].pageX+e.touches[1].pageX)/2,o=(e.touches[0].pageY+e.touches[1].pageY)/2;r._panStart.copy(b(i,o)),r._panEnd.copy(r._panStart);break;default:r._state=r.STATE.NONE}r.dispatchEvent(d)}},!1),this.domElement.addEventListener("touchend",function(e){if(!(!1===r.enabled||Object.keys(window).length<2)){switch(e.touches.length){case 1:r._rotateEnd.copy(_(e.touches[0].pageX,e.touches[0].pageY)),r._rotateStart.copy(r._rotateEnd);break;case 2:s=c=0;var t=(e.touches[0].pageX+e.touches[1].pageX)/2,n=(e.touches[0].pageY+e.touches[1].pageY)/2;r._panEnd.copy(b(t,n)),r._panStart.copy(r._panEnd)}r._state=r.STATE.NONE,r.dispatchEvent(l)}},!1),this.domElement.addEventListener("touchmove",function(e){if(!(!1===r.enabled||Object.keys(window).length<2))switch(e.stopPropagation(),e.touches.length){case 1:r._rotateEnd.copy(_(e.touches[0].pageX,e.touches[0].pageY));break;case 2:var t=e.touches[0].pageX-e.touches[1].pageX,n=e.touches[0].pageY-e.touches[1].pageY;c=Math.sqrt(t*t+n*n);var i=(e.touches[0].pageX+e.touches[1].pageX)/2,o=(e.touches[0].pageY+e.touches[1].pageY)/2;r._panEnd.copy(b(i,o));break;default:r._state=r.STATE.NONE}},!1),Object.keys(window).length>=2&&window.addEventListener("keydown",T,!1),Object.keys(window).length>=2&&window.addEventListener("keyup",function(e){!1===r.enabled||Object.keys(window).length<2||(r._state=o,window.addEventListener("keydown",T,!1))},!1)),this.handleResize(),this.update()},THREE.TrackballControls.prototype=Object.create(THREE.EventDispatcher.prototype),THREE.TrackballControls.prototype.constructor=THREE.TrackballControls,THREE.OrthographicTrackballControls=function(e,t,n){this.icn3d;var r=this,i={NONE:-1,ROTATE:0,ZOOM:1,PAN:2,TOUCH_ROTATE:3,TOUCH_ZOOM_PAN:4};this.object=e,this.domElement=void 0!==t?t:document,this.enabled=!0,this.screen={left:0,top:0,width:0,height:0},this.rotateSpeed=.5,this.zoomSpeed=1.2;this.zoomSpeed*=.01,this.panSpeed=.03,this.noRotate=!1,this.noZoom=!1,this.noPan=!1,this.noRoll=!1,this.staticMoving=!1,this.dynamicDampingFactor=.2,this.keys=[65,83,68],this.target=new THREE.Vector3;var o=new THREE.Vector3;this._state=i.NONE;var a=i.NONE,s=new THREE.Vector3;this._rotateStart=new THREE.Vector3,this._rotateEnd=new THREE.Vector3,this._zoomStart=new THREE.Vector2,this._zoomEnd=new THREE.Vector2;var c=1,u=0,d=0;this._panStart=new THREE.Vector2,this._panEnd=new THREE.Vector2,this.target0=this.target.clone(),this.position0=this.object.position.clone(),this.up0=this.object.up.clone(),this.left0=this.object.left,this.right0=this.object.right,this.top0=this.object.top,this.bottom0=this.object.bottom,this.center0=new THREE.Vector2((this.left0+this.right0)/2,(this.top0+this.bottom0)/2);var l={type:"change"},f={type:"start"},p={type:"end"};this.handleResize=function(){if(this.domElement===document)this.screen.left=0,this.screen.top=0,this.screen.width=window.innerWidth,this.screen.height=window.innerHeight;else if(this.domElement){var e=this.domElement.getBoundingClientRect(),t=this.domElement.ownerDocument.documentElement;this.screen.left=e.left+window.pageXOffset-t.clientLeft,this.screen.top=e.top+window.pageYOffset-t.clientTop,this.screen.width=e.width,this.screen.height=e.height}this.left0=this.object.left,this.right0=this.object.right,this.top0=this.object.top,this.bottom0=this.object.bottom,this.center0.set((this.left0+this.right0)/2,(this.top0+this.bottom0)/2)},this.handleEvent=function(e){"function"==typeof this[e.type]&&this[e.type](e)};var h,g,v,m,y,E,w,b,_,T=(h=new THREE.Vector2,function(e,t){return h.set((e-r.screen.left)/r.screen.width,(t-r.screen.top)/r.screen.height),h}),S=(g=new THREE.Vector3,v=new THREE.Vector3,m=new THREE.Vector3,function(e,t){m.set((e-.5*r.screen.width-r.screen.left)/(.5*r.screen.width),(.5*r.screen.height+r.screen.top-t)/(.5*r.screen.height),0);var n=m.length();return r.noRoll?n<Math.SQRT1_2?m.z=Math.sqrt(1-n*n):m.z=.5/n:n>1?m.normalize():m.z=Math.sqrt(1-n*n),s.copy(r.object.position).sub(r.target),g.copy(r.object.up).setLength(m.y),g.add(v.copy(r.object.up).cross(s).setLength(m.x)),g.add(s.setLength(m.z)),g});function C(e){!1===r.enabled||Object.keys(window).length<2||(window.removeEventListener("keydown",C),a=r._state,r._state===i.NONE&&(e.keyCode!==r.keys[i.ROTATE]||r.noRotate?e.keyCode!==r.keys[i.ZOOM]||r.noZoom?e.keyCode!==r.keys[i.PAN]||r.noPan||(r._state=i.PAN):r._state=i.ZOOM:r._state=i.ROTATE))}function x(e){!1===r.enabled||Object.keys(window).length<2||(e.stopPropagation(),r._state!==i.ROTATE||r.noRotate?r._state!==i.ZOOM||r.noZoom?r._state!==i.PAN||r.noPan||r._panEnd.copy(T(e.pageX,e.pageY)):r._zoomEnd.copy(T(e.pageX,e.pageY)):r._rotateEnd.copy(S(e.pageX,e.pageY)))}function R(e){!1===r.enabled||Object.keys(window).length<2||(e.stopPropagation(),r._state=i.NONE,document.removeEventListener("mousemove",x),document.removeEventListener("mouseup",R),r.dispatchEvent(p))}function A(e){if(!(!1===r.enabled||Object.keys(window).length<2)){e.stopPropagation();var t=0;e.wheelDelta?t=e.wheelDelta/40:e.detail&&(t=-e.detail/3),r._zoomStart.y=.01*t,r.dispatchEvent(f),r.dispatchEvent(p)}}this.rotateCamera=(y=new THREE.Vector3,E=new THREE.Quaternion,function(e,t){var i;void 0===e&&(i=Math.acos(r._rotateStart.dot(r._rotateEnd)/r._rotateStart.length()/r._rotateEnd.length())),(i||void 0!==e)&&(void 0===e?(y.crossVectors(r._rotateStart,r._rotateEnd).normalize(),i*=r.rotateSpeed,E.setFromAxisAngle(y,-i)):E.copy(e),void 0===n||void 0===n.quaternion||void 0!==t&&!0!==t||n.quaternion.multiplyQuaternions(E,n.quaternion),s.applyQuaternion(E),r.object.up.applyQuaternion(E),r._rotateEnd.applyQuaternion(E),r.staticMoving?r._rotateStart.copy(r._rotateEnd):(E.setFromAxisAngle(y,i*(r.dynamicDampingFactor-1)),r._rotateStart.applyQuaternion(E)))}),this.zoomCamera=function(e,t){var o;r._state===i.TOUCH_ZOOM_PAN?void 0!==e?o=e:(o=u/d,u=d):o=void 0!==e?e:1+(r._zoomEnd.y-r._zoomStart.y)*r.zoomSpeed/.01,void 0===n||void 0===n._zoomFactor||void 0!==t&&!0!==t||(n._zoomFactor*=o),1!==o&&(c=o,r.object.left=c*r.left0+(1-c)*r.center0.x,r.object.right=c*r.right0+(1-c)*r.center0.x,r.object.top=c*r.top0+(1-c)*r.center0.y,r.object.bottom=c*r.bottom0+(1-c)*r.center0.y,r.staticMoving?r._zoomStart.copy(r._zoomEnd):r._zoomStart.y+=(r._zoomEnd.y-r._zoomStart.y)*this.dynamicDampingFactor)},this.panCamera=(w=new THREE.Vector2,b=new THREE.Vector3,_=new THREE.Vector3,function(e,t){void 0!==e?(w=e,void 0===n||void 0===n.mouseChange||void 0!==t&&!0!==t||n.mouseChange.add(e)):(w.copy(r._panEnd).sub(r._panStart),void 0===n||void 0===n.mouseChange||void 0!==t&&!0!==t||n.mouseChange.add(r._panEnd).sub(r._panStart)),w.lengthSq()&&(w.multiplyScalar(s.length()*r.panSpeed),_.copy(s).cross(r.object.up).setLength(w.x),_.add(b.copy(r.object.up).setLength(w.y)),r.object.position.add(_),r.target.add(_),r.staticMoving?r._panStart.copy(r._panEnd):r._panStart.add(w.subVectors(r._panEnd,r._panStart).multiplyScalar(r.dynamicDampingFactor)))}),this.update=function(e){s.subVectors(r.object.position,r.target),r.noRotate||(void 0!==e&&void 0!==e.quaternion?r.rotateCamera(e.quaternion,e.update):r.rotateCamera()),r.noZoom||(void 0!==e&&void 0!==e._zoomFactor?r.zoomCamera(e._zoomFactor,e.update):r.zoomCamera(),r.object.updateProjectionMatrix()),r.noPan||(void 0!==e&&void 0!==e.mouseChange?r.panCamera(e.mouseChange,e.update):r.panCamera()),r.object.position.addVectors(r.target,s),r.object.lookAt(r.target),o.distanceToSquared(r.object.position)>1e-6&&(r.dispatchEvent(l),o.copy(r.object.position))},this.reset=function(){r._state=i.NONE,a=i.NONE,r.target.copy(r.target0),r.object.position.copy(r.position0),r.object.up.copy(r.up0),s.subVectors(r.object.position,r.target),r.object.left=r.left0,r.object.right=r.right0,r.object.top=r.top0,r.object.bottom=r.bottom0,r.object.lookAt(r.target),r.dispatchEvent(l),o.copy(r.object.position)},Object.keys(window).length>=2&&this.domElement&&(this.domElement.addEventListener("contextmn",function(e){},!1),this.domElement.addEventListener("mousedown",function(e){!1===r.enabled||Object.keys(window).length<2||(e.stopPropagation(),r._state===i.NONE&&(r._state=e.button),r._state!==i.ROTATE||r.noRotate?r._state!==i.ZOOM||r.noZoom?r._state!==i.PAN||r.noPan||(r._panStart.copy(T(e.pageX,e.pageY)),r._panEnd.copy(r._panStart)):(r._zoomStart.copy(T(e.pageX,e.pageY)),r._zoomEnd.copy(r._zoomStart)):(r._rotateStart.copy(S(e.pageX,e.pageY)),r._rotateEnd.copy(r._rotateStart)),document.addEventListener("mousemove",x,!1),document.addEventListener("mouseup",R,!1),r.dispatchEvent(f))},!1),this.domElement.addEventListener("mousewheel",A,!1),this.domElement.addEventListener("DOMMouseScroll",A,!1),this.domElement.addEventListener("touchstart",function(e){if(!(!1===r.enabled||Object.keys(window).length<2)){switch(e.touches.length){case 1:r._state=i.TOUCH_ROTATE,r._rotateStart.copy(S(e.touches[0].pageX,e.touches[0].pageY)),r._rotateEnd.copy(r._rotateStart);break;case 2:r._state=i.TOUCH_ZOOM_PAN;var t=e.touches[0].pageX-e.touches[1].pageX,n=e.touches[0].pageY-e.touches[1].pageY;d=u=Math.sqrt(t*t+n*n);var o=(e.touches[0].pageX+e.touches[1].pageX)/2,a=(e.touches[0].pageY+e.touches[1].pageY)/2;r._panStart.copy(T(o,a)),r._panEnd.copy(r._panStart);break;default:r._state=i.NONE}r.dispatchEvent(f)}},!1),this.domElement.addEventListener("touchend",function(e){if(!(!1===r.enabled||Object.keys(window).length<2)){switch(e.touches.length){case 1:r._rotateEnd.copy(S(e.touches[0].pageX,e.touches[0].pageY)),r._rotateStart.copy(r._rotateEnd);break;case 2:u=d=0;var t=(e.touches[0].pageX+e.touches[1].pageX)/2,n=(e.touches[0].pageY+e.touches[1].pageY)/2;r._panEnd.copy(T(t,n)),r._panStart.copy(r._panEnd)}r._state=i.NONE,r.dispatchEvent(p)}},!1),this.domElement.addEventListener("touchmove",function(e){if(!(!1===r.enabled||Object.keys(window).length<2))switch(e.stopPropagation(),e.touches.length){case 1:r._rotateEnd.copy(S(e.touches[0].pageX,e.touches[0].pageY));break;case 2:var t=e.touches[0].pageX-e.touches[1].pageX,n=e.touches[0].pageY-e.touches[1].pageY;d=Math.sqrt(t*t+n*n);var o=(e.touches[0].pageX+e.touches[1].pageX)/2,a=(e.touches[0].pageY+e.touches[1].pageY)/2;r._panEnd.copy(T(o,a));break;default:r._state=i.NONE}},!1),window.addEventListener("keydown",C,!1),window.addEventListener("keyup",function(e){!1===r.enabled||Object.keys(window).length<2||(r._state=a,window.addEventListener("keydown",C,!1))},!1)),this.handleResize(),this.update()},THREE.OrthographicTrackballControls.prototype=Object.create(THREE.EventDispatcher.prototype),THREE.OrthographicTrackballControls.prototype.constructor=THREE.OrthographicTrackballControls,function(e){var t,n,r,i;e.VERSION={number:"1.1.7",date:"Oct 30 2018"},function(e){function t(e,t,n){(t|=0)<=0&&(t=1);var r=t*n,i=e(r);return{elementSize:n,chunkSize:r,creator:e,current:i,parts:[i],currentIndex:0,elementCount:0}}e.is=function(e){return e.creator&&e.chunkSize},e.add4=function(e,t,n,r,i){return e.currentIndex>=e.chunkSize&&(e.currentIndex=0,e.current=e.creator(e.chunkSize),e.parts[e.parts.length]=e.current),e.current[e.currentIndex++]=t,e.current[e.currentIndex++]=n,e.current[e.currentIndex++]=r,e.current[e.currentIndex++]=i,e.elementCount++},e.add3=function(e,t,n,r){return e.currentIndex>=e.chunkSize&&(e.currentIndex=0,e.current=e.creator(e.chunkSize),e.parts[e.parts.length]=e.current),e.current[e.currentIndex++]=t,e.current[e.currentIndex++]=n,e.current[e.currentIndex++]=r,e.elementCount++},e.add2=function(e,t,n){return e.currentIndex>=e.chunkSize&&(e.currentIndex=0,e.current=e.creator(e.chunkSize),e.parts[e.parts.length]=e.current),e.current[e.currentIndex++]=t,e.current[e.currentIndex++]=n,e.elementCount++},e.add=function(e,t){return e.currentIndex>=e.chunkSize&&(e.currentIndex=0,e.current=e.creator(e.chunkSize),e.parts[e.parts.length]=e.current),e.current[e.currentIndex++]=t,e.elementCount++},e.compact=function(e){var t,n=e.creator(e.elementSize*e.elementCount),r=(e.parts.length-1)*e.chunkSize,i=0;if(e.parts.length>1)if(e.parts[0].buffer)for(var o=0;o<e.parts.length-1;o++)n.set(e.parts[o],e.chunkSize*o);else for(o=0;o<e.parts.length-1;o++){i=e.chunkSize*o,t=e.parts[o];for(var a=0;a<e.chunkSize;a++)n[i+a]=t[a]}if(e.current.buffer&&e.currentIndex>=e.chunkSize)n.set(e.current,e.chunkSize*(e.parts.length-1));else for(o=0;o<e.currentIndex;o++)n[r+o]=e.current[o];return n},e.forVertex3D=function(e){return void 0===e&&(e=262144),t(function(e){return new Float32Array(e)},e,3)},e.forIndexBuffer=function(e){return void 0===e&&(e=262144),t(function(e){return new Uint32Array(e)},e,3)},e.forTokenIndices=function(e){return void 0===e&&(e=131072),t(function(e){return new Int32Array(e)},e,2)},e.forIndices=function(e){return void 0===e&&(e=131072),t(function(e){return new Int32Array(e)},e,1)},e.forInt32=function(e){return void 0===e&&(e=131072),t(function(e){return new Int32Array(e)},e,1)},e.forFloat32=function(e){return void 0===e&&(e=131072),t(function(e){return new Float32Array(e)},e,1)},e.forArray=function(e){return void 0===e&&(e=131072),t(function(e){return[]},e,1)},e.create=t}((t=e.Utils||(e.Utils={})).ChunkedArray||(t.ChunkedArray={})),function(e){"use strict";function t(e,t,n){var r=0,i=1;for(45===e.charCodeAt(t)&&(i=-1,t++);t<n;t++){var o=e.charCodeAt(t)-48;if(o>9||o<0)return i*r|0;r=10*r+o|0}return i*r}function n(e,n,r,i){return 43===n.charCodeAt(r)&&r++,e*Math.pow(10,t(n,r,i))}function r(e,t,r){var i=1,o=0,a=0,s=1;for(45===e.charCodeAt(t)&&(i=-1,++t);t<r;){var c=e.charCodeAt(t)-48;if(!(c>=0&&c<10)){if(-2===c){for(++t;t<r;){if(!((c=e.charCodeAt(t)-48)>=0&&c<10))return 53===c||21===c?n(i*(o+a/s),e,t+1,r):i*(o+a/s);a=10*a+c,s*=10,++t}return i*(o+a/s)}if(53===c||21===c)return n(i*o,e,t+1,r);break}o=10*o+c,++t}return i*o}e.parseIntSkipTrailingWhitespace=function(e,n,r){for(;n<r&&32===e.charCodeAt(n);)n++;return t(e,n,r)},e.parseInt=t,e.parseFloatSkipTrailingWhitespace=function(e,t,n){for(;t<n&&32===e.charCodeAt(t);)t++;return r(e,t,n)},e.parseFloat=r}((n=e.Utils||(e.Utils={})).FastNumberParsers||(n.FastNumberParsers={})),r=e.Utils||(e.Utils={}),i=[],function(){for(var e="",t=0;t<512;t++)i[t]=e,e+=" "}(),function(e){function t(e,t){void 0!==t&&null!==t&&(e.chunkOffset===e.chunkCapacity&&(e.data[e.data.length]=e.chunkData.join(""),e.chunkOffset=0),e.chunkData[e.chunkOffset++]=t)}e.create=function(e){return void 0===e&&(e=512),{chunkData:[],chunkOffset:0,chunkCapacity:e,data:[]}},e.asString=function(e){return e.data.length?(e.chunkOffset>0&&(e.data[e.data.length]=e.chunkData.splice(0,e.chunkOffset).join("")),e.data.join("")):e.chunkData.length===e.chunkOffset?e.chunkData.join(""):e.chunkData.splice(0,e.chunkOffset).join("")},e.writeTo=function(e,t){var n;(n=e).chunkOffset>0&&(n.chunkData.length===n.chunkOffset?n.data[n.data.length]=n.chunkData.join(""):n.data[n.data.length]=n.chunkData.splice(0,n.chunkOffset).join(""),n.chunkOffset=0);for(var r=0,i=e.data;r<i.length;r++){var o=i[r];t.writeString(o)}},e.newline=function(e){t(e,"\n")},e.whitespace=function(e,n){t(e,i[n])},e.write=t,e.writeSafe=function(e,t){e.chunkOffset===e.chunkCapacity&&(e.data[e.data.length]=e.chunkData.join(""),e.chunkOffset=0),e.chunkData[e.chunkOffset++]=t},e.writePadLeft=function(e,n,r){void 0!==n&&null!==n||t(e,i[r]);var o=r-n.length;o>0&&t(e,i[o]),t(e,n)},e.writePadRight=function(e,n,r){void 0!==n&&null!==n||t(e,i[r]);var o=r-n.length;t(e,n),o>0&&t(e,i[o])},e.writeInteger=function(e,n){t(e,""+n)},e.writeIntegerPadLeft=function(e,n,r){var o=""+n,a=r-o.length;a>0&&t(e,i[a]),t(e,o)},e.writeIntegerPadRight=function(e,n,r){var o=""+n,a=r-o.length;t(e,o),a>0&&t(e,i[a])},e.writeFloat=function(e,n,r){t(e,""+Math.round(r*n)/r)},e.writeFloatPadLeft=function(e,n,r,o){var a=""+Math.round(r*n)/r,s=o-a.length;s>0&&t(e,i[s]),t(e,a)},e.writeFloatPadRight=function(e,n,r,o){var a=""+Math.round(r*n)/r,s=o-a.length;t(e,a),s>0&&t(e,i[s])}}(r.StringWriter||(r.StringWriter={}));var o=function(){function e(){this.isDefined=!1}return e.prototype.getString=function(e){return null},e.prototype.getInteger=function(e){return 0},e.prototype.getFloat=function(e){return 0},e.prototype.getValuePresence=function(e){return 1},e.prototype.areValuesEqual=function(e,t){return!0},e.prototype.stringEquals=function(e,t){return null===t},e}();e.UndefinedColumn=new o,function(e){e.getMatrix=function(e,t,n,r,i){for(var o=[],a=1;a<=n;a++){for(var s=[],c=1;c<=r;c++)s[c-1]=e.getColumn(t+"["+a+"]["+c+"]").getFloat(i);o[a-1]=s}return o},e.getVector=function(e,t,n,r,i){for(var o=[],a=1;a<=n;a++)o[a-1]=e.getColumn(t+"["+a+"]").getFloat(i);return o}}(e.Category||(e.Category={})),function(e){e.error=function(e,t){return void 0===t&&(t=-1),new a(e,t)},e.success=function(e,t){return void 0===t&&(t=[]),new l(e,t)}}(e.ParserResult||(e.ParserResult={}));var a=function(){function e(e,t){this.message=e,this.line=t,this.isError=!0}return e.prototype.toString=function(){return this.line>=0?"[Line "+this.line+"] "+this.message:this.message},e}();e.ParserError=a;var s,c,u,d,l=function(){return function(e,t){this.result=e,this.warnings=t,this.isError=!1}}();e.ParserSuccess=l,function(t){"use strict";var n;!function(e){e.create=function(){return Object.create(null)},e.get=function(e,t){if(t.length>6)return t;var n=e[t];return void 0!==n?n:(e[t]=t,t)}}(n||(n={}));var r=function(){function e(e){this.dataBlocks=[],this.data=e}return e.prototype.toJSON=function(){return this.dataBlocks.map(function(e){return e.toJSON()})},e}();t.File=r;var i=function(){function e(e,t){this.header=t,this.data=e,this.categoryList=[],this.additionalData={},this.categoryMap=new Map}return Object.defineProperty(e.prototype,"categories",{get:function(){return this.categoryList},enumerable:!0,configurable:!0}),e.prototype.getCategory=function(e){return this.categoryMap.get(e)},e.prototype.addCategory=function(e){this.categoryList[this.categoryList.length]=e,this.categoryMap.set(e.name,e)},e.prototype.toJSON=function(){return{id:this.header,categories:this.categoryList.map(function(e){return e.toJSON()}),additionalData:this.additionalData}},e}();t.DataBlock=i;var o=function(){function t(e,t,n,r,i,o,a){this.name=t,this.tokens=o,this.data=e,this.startIndex=n,this.endIndex=r,this.columnCount=i.length,this.rowCount=a/i.length|0,this.columnIndices=new Map,this.columnNameList=[];for(var s=0;s<i.length;s++){var c=i[s].substr(t.length+1);this.columnIndices.set(c,s),this.columnNameList.push(c)}}return Object.defineProperty(t.prototype,"columnNames",{get:function(){return this.columnNameList},enumerable:!0,configurable:!0}),t.prototype.getColumn=function(t){var n=this.columnIndices.get(t);return void 0!==n?new c(this,this.data,t,n):e.UndefinedColumn},t.prototype.toJSON=function(){for(var e=[],t=this.data,r=this.tokens,i=this.columnNameList,o=n.create(),a=0;a<this.rowCount;a++){for(var s={},c=0;c<this.columnCount;c++){var u=2*(a*this.columnCount+c);s[i[c]]=n.get(o,t.substring(r[u],r[u+1]))}e[a]=s}return{name:this.name,columns:i,rows:e}},t}();t.Category=o;var a=e.Utils.FastNumberParsers.parseInt,s=e.Utils.FastNumberParsers.parseFloat,c=function(){function e(e,t,r,i){this.data=t,this.name=r,this.index=i,this.stringPool=n.create(),this.isDefined=!0,this.tokens=e.tokens,this.columnCount=e.columnCount}return e.prototype.getString=function(e){var t=2*(e*this.columnCount+this.index),r=n.get(this.stringPool,this.data.substring(this.tokens[t],this.tokens[t+1]));return"."===r||"?"===r?null:r},e.prototype.getInteger=function(e){var t=2*(e*this.columnCount+this.index);return a(this.data,this.tokens[t],this.tokens[t+1])},e.prototype.getFloat=function(e){var t=2*(e*this.columnCount+this.index);return s(this.data,this.tokens[t],this.tokens[t+1])},e.prototype.stringEquals=function(e,t){var n=2*(e*this.columnCount+this.index),r=this.tokens[n],i=t.length;if(i!==this.tokens[n+1]-r)return!1;for(var o=0;o<i;o++)if(this.data.charCodeAt(o+r)!==t.charCodeAt(o))return!1;return!0},e.prototype.areValuesEqual=function(e,t){var n=2*(e*this.columnCount+this.index),r=2*(t*this.columnCount+this.index),i=this.tokens[n],o=this.tokens[r],a=this.tokens[n+1]-i;if(a!==this.tokens[r+1]-o)return!1;for(var s=0;s<a;s++)if(this.data.charCodeAt(s+i)!==this.data.charCodeAt(s+o))return!1;return!0},e.prototype.getValuePresence=function(e){var t=e*this.columnCount+this.index,n=this.tokens[2*t];if(this.tokens[2*t+1]-n!=1)return 0;var r=this.data.charCodeAt(n);return 46===r?1:63===r?2:0},e}();t.Column=c}(e.Text||(e.Text={})),function(t){"use strict";var n;function r(e){for(;e.position<e.length;)switch(e.data.charCodeAt(e.position)){case 9:case 10:case 13:case 32:return void(e.currentTokenEnd=e.position);default:++e.position}e.currentTokenEnd=e.position}function i(e,t,n){var r,i=n-t,o=e.currentTokenStart-t,a=e.currentTokenEnd-e.currentTokenStart;if(a<i)return!1;for(r=t;r<n;++r)if(e.data.charCodeAt(r)!==e.data.charCodeAt(r+o))return!1;return i===a||46===e.data.charCodeAt(r+o)}function o(e){var t;for(t=e.currentTokenStart;t<e.currentTokenEnd;++t)if(46===e.data.charCodeAt(t))return t;return t}function a(e,t){return e.data.substring(e.currentTokenStart,t)}function s(e){return e.data.substring(e.currentTokenStart,e.currentTokenEnd)}function c(e){var t=function(e){for(var t=10;e.position<e.length;){var n=e.data.charCodeAt(e.position);switch(n){case 9:case 32:t=n,++e.position;break;case 10:13!==t&&++e.currentLineNumber,t=n,++e.position;break;case 13:t=n,++e.position,++e.currentLineNumber;break;default:return t}}return t}(e);if(e.position>=e.length)e.currentTokenType=6;else{e.currentTokenStart=e.position,e.currentTokenEnd=e.position,e.isEscaped=!1;var n,i,o,a,s=e.data.charCodeAt(e.position);switch(s){case 35:!function(e){for(;e.position<e.length;){var t=e.data.charCodeAt(e.position);if(10===t||13===t)return;++e.position}}(e),e.currentTokenType=5;break;case 34:case 39:!function(e,t){var n,r;for(++e.position;e.position<e.length;)if((r=e.data.charCodeAt(e.position))===t)switch(n=e.data.charCodeAt(e.position+1)){case 9:case 10:case 13:case 32:return e.currentTokenStart++,e.currentTokenEnd=e.position,e.isEscaped=!0,void++e.position;default:if(void 0===n)return e.currentTokenStart++,e.currentTokenEnd=e.position,e.isEscaped=!0,void++e.position;++e.position}else{if(10===r||13===r)return void(e.currentTokenEnd=e.position);++e.position}e.currentTokenEnd=e.position}(e,s),e.currentTokenType=3;break;case 59:10===t||13===t?function(e){for(var t,n=59,r=e.position+1;r<e.length;){if(59===(t=e.data.charCodeAt(r))&&(10===n||13===n)){for(e.position=r+1,e.currentTokenStart++,r--,t=e.data.charCodeAt(r);10===t||13===t;)r--,t=e.data.charCodeAt(r);return e.currentTokenEnd=r+1,void(e.isEscaped=!0)}13===t?e.currentLineNumber++:10===t&&13!==n&&e.currentLineNumber++,n=t,++r}e.position=r}(e):r(e),e.currentTokenType=3;break;default:r(e),e.isEscaped?e.currentTokenType=3:95===e.data.charCodeAt(e.currentTokenStart)?e.currentTokenType=4:e.currentTokenEnd-e.currentTokenStart>=5&&95===e.data.charCodeAt(e.currentTokenStart+4)?68!==(a=(o=e).data.charCodeAt(o.currentTokenStart))&&100!==a||65!==(a=o.data.charCodeAt(o.currentTokenStart+1))&&97!==a||84!==(a=o.data.charCodeAt(o.currentTokenStart+2))&&116!==a||65!==(a=o.data.charCodeAt(o.currentTokenStart+3))&&97!==a?83!==(i=(n=e).data.charCodeAt(n.currentTokenStart))&&115!==i||65!==(i=n.data.charCodeAt(n.currentTokenStart+1))&&97!==i||86!==(i=n.data.charCodeAt(n.currentTokenStart+2))&&118!==i||69!==(i=n.data.charCodeAt(n.currentTokenStart+3))&&101!==i?!function(e){if(e.currentTokenEnd-e.currentTokenStart!=5)return!1;var t=e.data.charCodeAt(e.currentTokenStart);return!(76!==t&&108!==t||79!==(t=e.data.charCodeAt(e.currentTokenStart+1))&&111!==t||79!==(t=e.data.charCodeAt(e.currentTokenStart+2))&&111!==t||80!==(t=e.data.charCodeAt(e.currentTokenStart+3))&&112!==t)}(e)?e.currentTokenType=3:e.currentTokenType=2:e.currentTokenType=1:e.currentTokenType=0:e.currentTokenType=3}}}function u(e){for(c(e);5===e.currentTokenType;)c(e)}function d(e,r){for(var c,d=e.currentTokenStart,l=o(e),f=a(e,l),p=[],h=n.create(512),g=0,v=!0;v;){if(4!==e.currentTokenType||!i(e,d,l)){v=!1;break}if(c=s(e),u(e),3!==e.currentTokenType)return{hasError:!0,errorLine:e.currentLineNumber,errorMessage:"Expected value."};p[p.length]=c,n.addToken(h,e.currentTokenStart,e.currentTokenEnd),g++,u(e)}return r.addCategory(new t.Category(r.data,f,d,e.currentTokenStart,p,h.tokens,g)),{hasError:!1,errorLine:0,errorMessage:""}}function l(e,r){var i=e.currentTokenStart,c=e.currentLineNumber;u(e);for(var d=a(e,o(e)),l=[],f=n.create("_atom_site"===d?r.data.length/1.85|0:1024),p=0;4===e.currentTokenType;)l[l.length]=s(e),u(e);for(;3===e.currentTokenType;)n.addToken(f,e.currentTokenStart,e.currentTokenEnd),p++,u(e);return p%l.length!=0?{hasError:!0,errorLine:e.currentLineNumber,errorMessage:"The number of values for loop starting at line "+c+" is not a multiple of the number of columns."}:(r.addCategory(new t.Category(r.data,d,i,e.currentTokenStart,l,f.tokens,p)),{hasError:!1,errorLine:0,errorMessage:""})}function f(t,n){return e.ParserResult.error(n,t)}function p(n){var r,i,o,a,s,c={data:a=n,length:a.length,position:0,currentTokenStart:0,currentTokenEnd:0,currentTokenType:6,currentLineNumber:1,isEscaped:!1},p=new t.File(n),h=new t.DataBlock(n,"default"),g=new t.DataBlock(n,"empty"),v=!1;for(u(c);6!==c.currentTokenType;){var m=c.currentTokenType;if(0===m){if(v)return f(c.currentLineNumber,"Unexpected data block inside a save frame.");h.categories.length>0&&p.dataBlocks.push(h),h=new t.DataBlock(n,n.substring(c.currentTokenStart+5,c.currentTokenEnd)),u(c)}else if(1===m){if(0===(i=n.substring(c.currentTokenStart+5,c.currentTokenEnd)).length)g.categories.length>0&&((o=h.additionalData.saveFrames)||(o=[],h.additionalData.saveFrames=o),o[o.length]=g),v=!1;else{if(v)return f(c.currentLineNumber,"Save frames cannot be nested.");v=!0,g=new t.DataBlock(n,i)}u(c)}else if(2===m){if((r=l(c,v?g:h)).hasError)return f(r.errorLine,r.errorMessage)}else{if(4!==m)return f(c.currentLineNumber,"Unexpected token. Expected data_, loop_, or data name.");if((r=d(c,v?g:h)).hasError)return f(r.errorLine,r.errorMessage)}}return v?f(c.currentLineNumber,"Unfinished save frame (`"+g.header+"`)."):(h.categories.length>0&&p.dataBlocks.push(h),s=p,e.ParserResult.success(s))}!function(e){e.addToken=function(e,t,n){var r,i;e.count>=e.tokensLenMinus2&&(r=e,(i=new Int32Array(1.61*r.tokens.length|0)).set(r.tokens),r.tokens=i,r.tokensLenMinus2=i.length-2|0),e.tokens[e.count++]=t,e.tokens[e.count++]=n},e.create=function(e){return{tokensLenMinus2:e-2|0,count:0,tokens:new Int32Array(e)}}}(n||(n={})),t.parse=function(e){return p(e)}}(e.Text||(e.Text={})),function(t){"use strict";var n=e.Utils.StringWriter,r=function(){function e(){this.writer=n.create(),this.encoded=!1,this.dataBlockCreated=!1}return e.prototype.startDataBlock=function(e){this.dataBlockCreated=!0,n.write(this.writer,"data_"+(e||"").replace(/[ \n\t]/g,"").toUpperCase()+"\n#\n")},e.prototype.writeCategory=function(e,t){if(this.encoded)throw new Error("The writer contents have already been encoded, no more writing.");if(!this.dataBlockCreated)throw new Error("No data block created.");var r=(t&&t.length?t.map(function(t){return e(t)}):[e(void 0)]).filter(function(e){return e&&e.count>0});if(r.length){var d=r.reduce(function(e,t){return e+(void 0===t.count?1:t.count)},0);d&&(1===d?function(e,t){for(var r=e.desc.fields,o=e.data,d=r.reduce(function(e,t){return Math.max(e,t.name.length)},0)+e.desc.name.length+5,l=0,f=r;l<f.length;l++){var p=f[l];n.writePadRight(t,e.desc.name+"."+p.name,d);var h=p.presence,g=h?h(o,0):0;if(0!==g)1===g?a(t):s(t);else{var v=p.string(o,0);i(v)?(u(t,v),n.newline(t)):c(t,v)}n.newline(t)}n.write(t,"#\n")}(r[0],this.writer):function(e,t){o(t,"loop_");for(var r=e[0],d=r.desc.fields,l=0,f=d;l<f.length;l++){var p=f[l];o(t,r.desc.name+"."+p.name)}for(var h=0,g=e;h<g.length;h++)for(var v=g[h],m=v.data,y=v.count,E=0;E<y;E++){for(var w=0,b=d;w<b.length;w++){var p=b[w],_=p.presence,T=_?_(m,E):0;if(0!==T)1===T?a(t):s(t);else{var S=p.string(m,E);i(S)?(u(t,S),n.newline(t)):c(t,S)}}n.newline(t)}n.write(t,"#\n")}(r,this.writer))}},e.prototype.encode=function(){this.encoded=!0},e.prototype.flush=function(e){n.writeTo(this.writer,e)},e}();function i(e){return!!e&&e.indexOf("\n")>=0}function o(e,t){n.write(e,t),n.newline(e)}function a(e){n.writeSafe(e,". ")}function s(e){n.writeSafe(e,"? ")}function c(e,t){if(t){for(var r=!1,i="'",o="' ",a=!1,s=!1,c=!1,u=0,d=t.length-1;u<d;u++){switch(t.charCodeAt(u)){case 9:a=!0;break;case 10:return n.writeSafe(e,"\n;"+t),void n.writeSafe(e,"\n; ");case 32:a=!0;break;case 34:if(s)return n.writeSafe(e,"\n;"+t),void n.writeSafe(e,"\n; ");c=!0,r=!0,i="'",o="' ";break;case 39:if(c)return n.writeSafe(e,"\n;"+t),void n.writeSafe(e,"\n; ");r=!0,s=!0,i='"',o='" '}}var l=t.charCodeAt(0);r||35!==l&&36!==l&&59!==l&&91!==l&&93!==l&&!a||(i="'",o="' ",r=!0),r?n.writeSafe(e,i+t+o):(n.write(e,t),n.writeSafe(e," "))}else n.writeSafe(e,". ")}function u(e,t){n.writeSafe(e,"\n;"+t),n.writeSafe(e,"\n; ")}t.Writer=r}(e.Text||(e.Text={})),function(e){function t(e,t){for(var n={},r=0;r<t;r++)n[o(e)]=o(e);return n}function n(e,t){for(var n=new Uint8Array(t),r=e.offset,i=0;i<t;i++)n[i]=e.buffer[i+r];return e.offset+=t,n}function r(t,n){var r=e.utf8Read(t.buffer,t.offset,n);return t.offset+=n,r}function i(e,t){for(var n=new Array(t),r=0;r<t;r++)n[r]=o(e);return n}function o(e){var o,a,s=e.buffer[e.offset];if(0==(128&s))return e.offset++,s;if(128==(240&s))return a=15&s,e.offset++,t(e,a);if(144==(240&s))return a=15&s,e.offset++,i(e,a);if(160==(224&s))return a=31&s,e.offset++,r(e,a);if(224==(224&s))return o=e.dataView.getInt8(e.offset),e.offset++,o;switch(s){case 192:return e.offset++,null;case 194:return e.offset++,!1;case 195:return e.offset++,!0;case 196:return a=e.dataView.getUint8(e.offset+1),e.offset+=2,n(e,a);case 197:return a=e.dataView.getUint16(e.offset+1),e.offset+=3,n(e,a);case 198:return a=e.dataView.getUint32(e.offset+1),e.offset+=5,n(e,a);case 202:return o=e.dataView.getFloat32(e.offset+1),e.offset+=5,o;case 203:return o=e.dataView.getFloat64(e.offset+1),e.offset+=9,o;case 204:return o=e.buffer[e.offset+1],e.offset+=2,o;case 205:return o=e.dataView.getUint16(e.offset+1),e.offset+=3,o;case 206:return o=e.dataView.getUint32(e.offset+1),e.offset+=5,o;case 208:return o=e.dataView.getInt8(e.offset+1),e.offset+=2,o;case 209:return o=e.dataView.getInt16(e.offset+1),e.offset+=3,o;case 210:return o=e.dataView.getInt32(e.offset+1),e.offset+=5,o;case 217:return a=e.dataView.getUint8(e.offset+1),e.offset+=2,r(e,a);case 218:return a=e.dataView.getUint16(e.offset+1),e.offset+=3,r(e,a);case 219:return a=e.dataView.getUint32(e.offset+1),e.offset+=5,r(e,a);case 220:return a=e.dataView.getUint16(e.offset+1),e.offset+=3,i(e,a);case 221:return a=e.dataView.getUint32(e.offset+1),e.offset+=5,i(e,a);case 222:return a=e.dataView.getUint16(e.offset+1),e.offset+=3,t(e,a);case 223:return a=e.dataView.getUint32(e.offset+1),e.offset+=5,t(e,a)}throw new Error("Unknown type 0x"+s.toString(16))}e.decode=function(e){return o({buffer:e,offset:0,dataView:new DataView(e.buffer)})}}((s=e.Binary||(e.Binary={})).MessagePack||(s.MessagePack={})),u=e.Binary||(e.Binary={}),(c=u.MessagePack||(u.MessagePack={})).encode=function(e){var t=new ArrayBuffer(function e(t){var n=typeof t;if("string"===n){var r=c.utf8ByteCount(t);if(r<32)return 1+r;if(r<256)return 2+r;if(r<65536)return 3+r;if(r<4294967296)return 5+r}if(t instanceof Uint8Array){var i=t.byteLength;if(i<256)return 2+i;if(i<65536)return 3+i;if(i<4294967296)return 5+i}if("number"===n){if(Math.floor(t)!==t)return 9;if(t>=0){if(t<128)return 1;if(t<256)return 2;if(t<65536)return 3;if(t<4294967296)return 5;throw new Error("Number too big 0x"+t.toString(16))}if(t>=-32)return 1;if(t>=-128)return 2;if(t>=-32768)return 3;if(t>=-2147483648)return 5;throw new Error("Number too small -0x"+t.toString(16).substr(1))}if("boolean"===n||null===t||void 0===t)return 1;if("object"===n){var o,a=0;if(Array.isArray(t)){o=t.length;for(var s=0;s<o;s++)a+=e(t[s])}else{var u=Object.keys(t);o=u.length;for(var s=0;s<o;s++){var d=u[s];a+=e(d)+e(t[d])}}if(o<16)return 1+a;if(o<65536)return 3+a;if(o<4294967296)return 5+a;throw new Error("Array or object too long 0x"+o.toString(16))}throw new Error("Unknown type "+n)}(e)),n=new DataView(t),r=new Uint8Array(t);return function e(t,n,r,i){var o=typeof t;if("string"===o){var a=c.utf8ByteCount(t);if(a<32)return n.setUint8(i,160|a),c.utf8Write(r,i+1,t),1+a;if(a<256)return n.setUint8(i,217),n.setUint8(i+1,a),c.utf8Write(r,i+2,t),2+a;if(a<65536)return n.setUint8(i,218),n.setUint16(i+1,a),c.utf8Write(r,i+3,t),3+a;if(a<4294967296)return n.setUint8(i,219),n.setUint32(i+1,a),c.utf8Write(r,i+5,t),5+a}if(t instanceof Uint8Array){var s=t.byteLength,u=new Uint8Array(n.buffer);if(s<256)return n.setUint8(i,196),n.setUint8(i+1,s),u.set(t,i+2),2+s;if(s<65536)return n.setUint8(i,197),n.setUint16(i+1,s),u.set(t,i+3),3+s;if(s<4294967296)return n.setUint8(i,198),n.setUint32(i+1,s),u.set(t,i+5),5+s}if("number"===o){if(!isFinite(t))throw new Error("Number not finite: "+t);if(Math.floor(t)!==t)return n.setUint8(i,203),n.setFloat64(i+1,t),9;if(t>=0){if(t<128)return n.setUint8(i,t),1;if(t<256)return n.setUint8(i,204),n.setUint8(i+1,t),2;if(t<65536)return n.setUint8(i,205),n.setUint16(i+1,t),3;if(t<4294967296)return n.setUint8(i,206),n.setUint32(i+1,t),5;throw new Error("Number too big 0x"+t.toString(16))}if(t>=-32)return n.setInt8(i,t),1;if(t>=-128)return n.setUint8(i,208),n.setInt8(i+1,t),2;if(t>=-32768)return n.setUint8(i,209),n.setInt16(i+1,t),3;if(t>=-2147483648)return n.setUint8(i,210),n.setInt32(i+1,t),5;throw new Error("Number too small -0x"+(-t).toString(16).substr(1))}if(null===t||void 0===t)return n.setUint8(i,192),1;if("boolean"===o)return n.setUint8(i,t?195:194),1;if("object"===o){var d,l=0,f=Array.isArray(t),p=void 0;if(f?d=t.length:(p=Object.keys(t),d=p.length),d<16?(n.setUint8(i,d|(f?144:128)),l=1):d<65536?(n.setUint8(i,f?220:222),n.setUint16(i+1,d),l=3):d<4294967296&&(n.setUint8(i,f?221:223),n.setUint32(i+1,d),l=5),f)for(var h=0;h<d;h++)l+=e(t[h],n,r,i+l);else for(var g=0,v=p;g<v.length;g++){var m=v[g];l+=e(m,n,r,i+l),l+=e(t[m],n,r,i+l)}return l}throw new Error("Unknown type "+o)}(e,n,r,0),r},function(e){e.utf8Write=function(e,t,n){e.byteLength;for(var r=0,i=n.length;r<i;r++){var o=n.charCodeAt(r);if(o<128)e[t++]=o>>>0&127|0;else if(o<2048)e[t++]=o>>>6&31|192,e[t++]=o>>>0&63|128;else if(o<65536)e[t++]=o>>>12&15|224,e[t++]=o>>>6&63|128,e[t++]=o>>>0&63|128;else{if(!(o<1114112))throw new Error("bad codepoint "+o);e[t++]=o>>>18&7|240,e[t++]=o>>>12&63|128,e[t++]=o>>>6&63|128,e[t++]=o>>>0&63|128}}};var t=function(){for(var e=[],t=0;t<1024;t++)e[t]=String.fromCharCode(t);return e}();function n(e){throw new Error(e)}e.utf8Read=function(e,r,i){for(var o=t,a=void 0,s=[],c=0,u=r,d=r+i;u<d;u++){var l=e[u];0==(128&l)?s[c++]=o[l]:192==(224&l)?s[c++]=o[(15&l)<<6|63&e[++u]]:224==(240&l)?s[c++]=String.fromCharCode((15&l)<<12|(63&e[++u])<<6|(63&e[++u])<<0):240==(248&l)?s[c++]=String.fromCharCode((7&l)<<18|(63&e[++u])<<12|(63&e[++u])<<6|(63&e[++u])<<0):n("Invalid byte "+l.toString(16)),512===c&&((a=a||[])[a.length]=s.join(""),c=0)}return a?(c>0&&(a[a.length]=s.slice(0,c).join("")),a.join("")):s.slice(0,c).join("")},e.utf8ByteCount=function(e){for(var t=0,r=0,i=e.length;r<i;r++){var o=e.charCodeAt(r);o<128?t+=1:o<2048?t+=2:o<65536?t+=3:o<1114112?t+=4:n("bad codepoint "+o)}return t}}((d=e.Binary||(e.Binary={})).MessagePack||(d.MessagePack={})),function(e){"use strict";function t(e){for(var t=e.data,r=e.encoding.length-1;r>=0;r--)t=n.decodeStep(t,e.encoding[r]);return t}var n;e.decode=t,function(e){function r(e,t){switch(e){case 1:return new Int8Array(t);case 2:return new Int16Array(t);case 3:return new Int32Array(t);case 4:return new Uint8Array(t);case 5:return new Uint16Array(t);case 6:return new Uint32Array(t);default:throw new Error("Unsupported integer data type.")}}function i(e,t){switch(e){case 32:return new Float32Array(t);case 33:return new Float64Array(t);default:throw new Error("Unsupported floating data type.")}}(n||(n={})).decodeStep=function(e,n){switch(n.kind){case"ByteArray":switch(n.type){case 4:return e;case 1:return s=e,new Int8Array(s.buffer,s.byteOffset);case 2:return u(e,2,Int16Array);case 5:return u(e,2,Uint16Array);case 3:return u(e,4,Int32Array);case 6:return u(e,4,Uint32Array);case 32:return u(e,4,Float32Array);case 33:return u(e,8,Float64Array);default:throw new Error("Unsupported ByteArray type.")}case"FixedPoint":return function(e,t){for(var n=e.length,r=i(t.srcType,n),o=1/t.factor,a=0;a<n;a++)r[a]=o*e[a];return r}(e,n);case"IntervalQuantization":return function(e,t){for(var n=e.length,r=i(t.srcType,n),o=(t.max-t.min)/(t.numSteps-1),a=t.min,s=0;s<n;s++)r[s]=a+o*e[s];return r}(e,n);case"RunLength":return function(e,t){for(var n=r(t.srcType,t.srcSize),i=0,o=0,a=e.length;o<a;o+=2)for(var s=e[o],c=e[o+1],u=0;u<c;++u)n[i++]=s;return n}(e,n);case"Delta":return function(e,t){var n=e.length,i=r(t.srcType,n);if(!n)return i;i[0]=e[0]+(0|t.origin);for(var o=1;o<n;++o)i[o]=e[o]+i[o-1];return i}(e,n);case"IntegerPacking":return o=e,(a=n).isUnsigned?function(e,t){for(var n=1===t.byteCount?255:65535,r=e.length,i=new Int32Array(t.srcSize),o=0,a=0;o<r;){for(var s=0,c=e[o];c===n;)s+=c,c=e[++o];s+=c,i[a]=s,o++,a++}return i}(o,a):function(e,t){for(var n=1===t.byteCount?127:32767,r=-n-1,i=e.length,o=new Int32Array(t.srcSize),a=0,s=0;a<i;){for(var c=0,u=e[a];u===n||u===r;)c+=u,u=e[++a];c+=u,o[s]=c,a++,s++}return o}(o,a);case"StringArray":return function(e,n){for(var r=n.stringData,i=t({encoding:n.offsetEncoding,data:n.offsets}),o=t({encoding:n.dataEncoding,data:e}),a=Object.create(null),s=new Array(o.length),c=0,u=0,d=o;u<d.length;u++){var l=d[u];if(l<0)s[c++]=null;else{var f=a[l];void 0===f&&(f=r.substring(i[l],i[l+1]),a[l]=f),s[c++]=f}}return s}(e,n)}var o,a,s};var o,a,s,c=(o=new ArrayBuffer(2),a=new Uint8Array(o),s=new Uint16Array(o),a[0]=170,a[1]=187,48042===s[0]);function u(e,t,n){return new n(c?e.buffer:function(e,t){for(var n=new ArrayBuffer(e.length),r=new Uint8Array(n),i=0,o=e.length;i<o;i+=t)for(var a=0;a<t;a++)r[i+t-a-1]=e[i+a];return n}(e,t))}}()}(e.Binary||(e.Binary={})),function(t){"use strict";var n=function(){function e(e){this.dataBlocks=e.dataBlocks.map(function(e){return new r(e)})}return e.prototype.toJSON=function(){return this.dataBlocks.map(function(e){return e.toJSON()})},e}();t.File=n;var r=function(){function e(e){this.additionalData={},this.header=e.header,this.categoryList=e.categories.map(function(e){return new i(e)}),this.categoryMap=new Map;for(var t=0,n=this.categoryList;t<n.length;t++){var r=n[t];this.categoryMap.set(r.name,r)}}return Object.defineProperty(e.prototype,"categories",{get:function(){return this.categoryList},enumerable:!0,configurable:!0}),e.prototype.getCategory=function(e){return this.categoryMap.get(e)},e.prototype.toJSON=function(){return{id:this.header,categories:this.categoryList.map(function(e){return e.toJSON()}),additionalData:this.additionalData}},e}();t.DataBlock=r;var i=function(){function n(e){this.name=e.name,this.columnCount=e.columns.length,this.rowCount=e.rowCount,this.columnNameList=[],this.encodedColumns=new Map;for(var t=0,n=e.columns;t<n.length;t++){var r=n[t];this.encodedColumns.set(r.name,r),this.columnNameList.push(r.name)}}return Object.defineProperty(n.prototype,"columnNames",{get:function(){return this.columnNameList},enumerable:!0,configurable:!0}),n.prototype.getColumn=function(n){var r=this.encodedColumns.get(n);return r?function(n){if(!n.data.data)return e.UndefinedColumn;var r=t.decode(n.data),i=void 0;n.mask&&(i=t.decode(n.mask));if(r.buffer&&r.byteLength&&r.BYTES_PER_ELEMENT)return i?new c(r,i):new s(r);return i?new d(r,i):new u(r)}(r):e.UndefinedColumn},n.prototype.toJSON=function(){for(var e=this,t=[],n=this.columnNameList.map(function(t){return{name:t,column:e.getColumn(t)}}),r=0;r<this.rowCount;r++){for(var i={},o=0,a=n;o<a.length;o++){var s=a[o],c=s.column.getValuePresence(r);i[s.name]=0===c?s.column.getString(r):1===c?".":"?"}t[r]=i}return{name:this.name,columns:this.columnNames,rows:t}},n}();t.Category=i;var o=e.Utils.FastNumberParsers.parseInt,a=e.Utils.FastNumberParsers.parseFloat,s=function(){function e(e){this.data=e,this.isDefined=!0}return e.prototype.getString=function(e){return""+this.data[e]},e.prototype.getInteger=function(e){return 0|this.data[e]},e.prototype.getFloat=function(e){return 1*this.data[e]},e.prototype.stringEquals=function(e,t){return this.data[e]===a(t,0,t.length)},e.prototype.areValuesEqual=function(e,t){return this.data[e]===this.data[t]},e.prototype.getValuePresence=function(e){return 0},e}(),c=function(){function e(e,t){this.data=e,this.mask=t,this.isDefined=!0}return e.prototype.getString=function(e){return 0===this.mask[e]?""+this.data[e]:null},e.prototype.getInteger=function(e){return 0===this.mask[e]?this.data[e]:0},e.prototype.getFloat=function(e){return 0===this.mask[e]?this.data[e]:0},e.prototype.stringEquals=function(e,t){return 0===this.mask[e]?this.data[e]===a(t,0,t.length):null===t||void 0===t},e.prototype.areValuesEqual=function(e,t){return this.data[e]===this.data[t]},e.prototype.getValuePresence=function(e){return this.mask[e]},e}(),u=function(){function e(e){this.data=e,this.isDefined=!0}return e.prototype.getString=function(e){return this.data[e]},e.prototype.getInteger=function(e){var t=this.data[e];return o(t,0,t.length)},e.prototype.getFloat=function(e){var t=this.data[e];return a(t,0,t.length)},e.prototype.stringEquals=function(e,t){return this.data[e]===t},e.prototype.areValuesEqual=function(e,t){return this.data[e]===this.data[t]},e.prototype.getValuePresence=function(e){return 0},e}(),d=function(){function e(e,t){this.data=e,this.mask=t,this.isDefined=!0}return e.prototype.getString=function(e){return 0===this.mask[e]?this.data[e]:null},e.prototype.getInteger=function(e){if(0!==this.mask[e])return 0;var t=this.data[e];return o(t||"",0,(t||"").length)},e.prototype.getFloat=function(e){if(0!==this.mask[e])return 0;var t=this.data[e];return a(t||"",0,(t||"").length)},e.prototype.stringEquals=function(e,t){return this.data[e]===t},e.prototype.areValuesEqual=function(e,t){return this.data[e]===this.data[t]},e.prototype.getValuePresence=function(e){return this.mask[e]},e}()}(e.Binary||(e.Binary={})),function(t){"use strict";var n=function(){function e(e){this.providers=e}return e.prototype.and=function(t){return new e(this.providers.concat([t]))},e.prototype.encode=function(e){for(var t=[],n=0,r=this.providers;n<r.length;n++){var i=(0,r[n])(e);if(!i.encodings.length)throw new Error("Encodings must be non-empty.");e=i.data;for(var o=0,a=i.encodings;o<a.length;o++){var s=a[o];t.push(s)}}if(!(e instanceof Uint8Array))throw new Error("The encoding must result in a Uint8Array. Fix your encoding chain.");return{encoding:t,data:e}},e}();t.Encoder=n,function(n){var r,i;n.by=function(e){return new n([e])};var o=((r={})[2]=function(e,t,n){e.setInt16(2*t,n,!0)},r[5]=function(e,t,n){e.setUint16(2*t,n,!0)},r[3]=function(e,t,n){e.setInt32(4*t,n,!0)},r[6]=function(e,t,n){e.setUint32(4*t,n,!0)},r[32]=function(e,t,n){e.setFloat32(4*t,n,!0)},r[33]=function(e,t,n){e.setFloat64(8*t,n,!0)},r),a=((i={})[2]=2,i[5]=2,i[3]=4,i[6]=4,i[32]=4,i[33]=8,i);function s(e){var n,r=t.Encoding.getDataType(e);if(1===r)return n=e,{encodings:[{kind:"ByteArray",type:1}],data:new Uint8Array(n.buffer,n.byteOffset)};if(4===r)return{encodings:[{kind:"ByteArray",type:4}],data:e};for(var i=new Uint8Array(e.length*a[r]),s=o[r],c=new DataView(i.buffer),u=0,d=e.length;u<d;u++)s(c,u,e[u]);return{encodings:[{kind:"ByteArray",type:r}],data:i}}function c(e){var n=t.Encoding.getDataType(e);if(void 0===n&&(e=new Int32Array(e),n=3),!e.length)return{encodings:[{kind:"RunLength",srcType:n,srcSize:0}],data:new Int32Array(0)};for(var r=2,i=1,o=e.length;i<o;i++)e[i-1]!==e[i]&&(r+=2);var a=new Int32Array(r),s=0,c=1;for(i=1,o=e.length;i<o;i++)e[i-1]!==e[i]?(a[s]=e[i-1],a[s+1]=c,c=1,s+=2):++c;return a[s]=e[e.length-1],a[s+1]=c,{encodings:[{kind:"RunLength",srcType:n,srcSize:e.length}],data:a}}function u(e){if(!t.Encoding.isSignedIntegerDataType(e))throw new Error("Only signed integer types can be encoded using delta encoding.");var n=t.Encoding.getDataType(e);if(void 0===n&&(e=new Int32Array(e),n=3),!e.length)return{encodings:[{kind:"Delta",origin:0,srcType:n}],data:new e.constructor(0)};var r=new e.constructor(e.length),i=e[0];r[0]=e[0];for(var o=1,a=e.length;o<a;o++)r[o]=e[o]-e[o-1];return r[0]=0,{encodings:[{kind:"Delta",origin:i,srcType:n}],data:r}}function d(e,t){for(var n=-t-1,r=0,i=0,o=e.length;i<o;i++){var a=e[i];0===a?r+=1:a>0?(r+=Math.ceil(a/t),a%t==0&&(r+=1)):(r+=Math.ceil(a/n),a%n==0&&(r+=1))}return r}function l(e){if(!(e instanceof Int32Array))throw new Error("Integer packing can only be applied to Int32 data.");var t,n,r,i,o=(n=function(e){for(var t=0,n=e.length;t<n;t++)if(e[t]<0)return!0;return!1}(t=e),r=d(t,n?127:255),i=d(t,n?32767:65535),4*t.length<2*i?{isSigned:n,size:t.length,bytesPerElement:4}:2*i<r?{isSigned:n,size:i,bytesPerElement:2}:{isSigned:n,size:r,bytesPerElement:1});return 4===o.bytesPerElement?s(e):function(e,t){for(var n=t.isSigned?1===t.bytesPerElement?127:32767:1===t.bytesPerElement?255:65535,r=-n-1,i=e.length,o=t.isSigned?1===t.bytesPerElement?new Int8Array(t.size):new Int16Array(t.size):1===t.bytesPerElement?new Uint8Array(t.size):new Uint16Array(t.size),a=0,c=0;c<i;c++){var u=e[c];if(u>=0)for(;u>=n;)o[a]=n,++a,u-=n;else for(;u<=r;)o[a]=r,++a,u-=r;o[a]=u,++a}var d=s(o);return{encodings:[{kind:"IntegerPacking",byteCount:t.bytesPerElement,isUnsigned:!t.isSigned,srcSize:i},d.encodings[0]],data:d.data}}(e,o)}n.byteArray=s,n.fixedPoint=function(e){return function(n){return function(e,n){for(var r=t.Encoding.getDataType(e),i=new Int32Array(e.length),o=0,a=e.length;o<a;o++)i[o]=Math.round(e[o]*n);return{encodings:[{kind:"FixedPoint",factor:n,srcType:r}],data:i}}(n,e)}},n.intervalQuantizaiton=function(e,n,r,i){return void 0===i&&(i=Int32Array),function(o){return function(e,n,r,i,o){var a=t.Encoding.getDataType(e);if(!e.length)return{encodings:[{kind:"IntervalQuantization",min:n,max:r,numSteps:i,srcType:a}],data:new Int32Array(0)};if(r<n){var s=n;n=r,r=s}for(var c=(r-n)/(i-1),u=new o(e.length),d=0,l=e.length;d<l;d++){var f=e[d];u[d]=f<=n?0:f>=r?i:0|Math.round((f-n)/c)}return{encodings:[{kind:"IntervalQuantization",min:n,max:r,numSteps:i,srcType:a}],data:u}}(o,e,n,r,i)}},n.runLength=c,n.delta=u,n.integerPacking=l,n.stringArray=function(t){var r=Object.create(null),i=[],o=0,a=e.Utils.ChunkedArray.create(function(e){return new Int32Array(e)},1024,1),s=new Int32Array(t.length);e.Utils.ChunkedArray.add(a,0);for(var d=0,f=0,p=t;f<p.length;f++){var h=p[f];if(null!==h&&void 0!==h){var g=r[h];void 0===g&&(o+=h.length,i[g=i.length]=h,r[h]=g,e.Utils.ChunkedArray.add(a,o)),s[d++]=g}else s[d++]=-1}var v=n.by(u).and(l).encode(e.Utils.ChunkedArray.compact(a)),m=n.by(u).and(c).and(l).encode(s);return{encodings:[{kind:"StringArray",dataEncoding:m.encoding,stringData:i.join(""),offsetEncoding:v.encoding,offsets:v.data}],data:m.data}}}(n=t.Encoder||(t.Encoder={}))}(e.Binary||(e.Binary={})),function(e){"use strict";e.VERSION="0.3.0",function(e){e.getDataType=function(e){var t;if(e instanceof Int8Array)t=1;else if(e instanceof Int16Array)t=2;else if(e instanceof Int32Array)t=3;else if(e instanceof Uint8Array)t=4;else if(e instanceof Uint16Array)t=5;else if(e instanceof Uint32Array)t=6;else if(e instanceof Float32Array)t=32;else{if(!(e instanceof Float64Array))throw new Error("Unsupported integer data type.");t=33}return t},e.isSignedIntegerDataType=function(e){return e instanceof Int8Array||e instanceof Int16Array||e instanceof Int32Array}}(e.Encoding||(e.Encoding={}))}(e.Binary||(e.Binary={})),function(t){"use strict";t.parse=function(n){var r=[0,3];try{var i=new Uint8Array(n),o=t.MessagePack.decode(i);if(!function(e,t){for(var n=0;n<2;n++)if(e[n]>t[n])return!1;return!0}(r,o.version.match(/(\d)\.(\d)\.\d/).slice(1)))return e.ParserResult.error("Unsupported format version. Current "+o.version+", required "+r.join(".")+".");var a=new t.File(o);return e.ParserResult.success(a)}catch(t){return e.ParserResult.error(""+t)}}}(e.Binary||(e.Binary={})),function(e){"use strict";function t(t,n,r){var i,o=!1;t.typedArray?i=new t.typedArray(r):(o=!0,i=new Array(r));for(var a=new Uint8Array(r),s=t.presence,c=t.number?t.number:t.string,u=!0,d=0,l=0,f=n;l<f.length;l++)for(var p=f[l],h=p.data,g=0,v=p.count;g<v;g++){var m=s?s(h,g):0;0!==m?(a[d]=m,o&&(i[d]=null),u=!1):(a[d]=0,i[d]=c(h,g)),d++}var y=(t.encoder?t.encoder:e.Encoder.by(e.Encoder.stringArray)).encode(i),E=void 0;if(!u){var w=e.Encoder.by(e.Encoder.runLength).and(e.Encoder.byteArray).encode(a);E=w.data.length<a.length?w:e.Encoder.by(e.Encoder.byteArray).encode(a)}return{name:t.name,data:y,mask:E}}var n=function(){function n(t){this.dataBlocks=[],this.data={encoder:t,version:e.VERSION,dataBlocks:this.dataBlocks}}return n.prototype.startDataBlock=function(e){this.dataBlocks.push({header:(e||"").replace(/[ \n\t]/g,"").toUpperCase(),categories:[]})},n.prototype.writeCategory=function(e,n){if(!this.data)throw new Error("The writer contents have already been encoded, no more writing.");if(!this.dataBlocks.length)throw new Error("No data block created.");var r=(n&&n.length?n.map(function(t){return e(t)}):[e(void 0)]).filter(function(e){return e&&e.count>0});if(r.length){var i=r.reduce(function(e,t){return e+t.count},0);if(i){for(var o=r[0],a={name:o.desc.name,columns:[],rowCount:i},s=r.map(function(e){return{data:e.data,count:e.count}}),c=0,u=o.desc.fields;c<u.length;c++){var d=u[c];a.columns.push(t(d,s,i))}this.dataBlocks[this.dataBlocks.length-1].categories.push(a)}}},n.prototype.encode=function(){this.encodedData=e.MessagePack.encode(this.data),this.data=null,this.dataBlocks=null},n.prototype.flush=function(e){e.writeBinary(this.encodedData)},n}();e.Writer=n}(e.Binary||(e.Binary={}))}(CIFTools||(CIFTools={})),function(e,t,n){var r,i="__instance__",o="firstChild",a=setTimeout;function s(e){return void 0!==e}function c(e){return"object"==typeof e}function u(e){return Object.keys(e).length}function d(e,t,n){return e<t?t:e>n?n:e}function l(e,t){return parseInt(e,t||10)}function f(e){return Math.round(e)}function p(e){var t,n,r,i,o,a,s,c,u=+e[0],d=+e[1],l=+e[2];switch(a=l*(1-d),s=l*(1-(o=6*u-(i=Math.floor(6*u)))*d),c=l*(1-(1-o)*d),i=i||0,s=s||0,c=c||0,i%6){case 0:t=l,n=c,r=a;break;case 1:t=s,n=l,r=a;break;case 2:t=a,n=l,r=c;break;case 3:t=a,n=s,r=l;break;case 4:t=c,n=a,r=l;break;case 5:t=l,n=a,r=s}return[f(255*t),f(255*n),f(255*r)]}function h(e){return v(p(e))}function g(e){var t,n=+e[0],r=+e[1],i=+e[2],o=Math.max(n,r,i),a=Math.min(n,r,i),s=o-a,c=0===o?0:s/o,u=o/255;switch(o){case a:t=0;break;case n:t=r-i+s*(r<i?6:0),t/=6*s;break;case r:t=i-n+2*s,t/=6*s;break;case i:t=n-r+4*s,t/=6*s}return[t,c,u]}function v(e){var t=+e[2]|+e[1]<<8|+e[0]<<16;return(t="000000"+t.toString(16)).slice(-6)}function m(e){return g(y(e))}function y(e){return 3===e.length&&(e=e.replace(/./g,"$&$&")),[l(e[0]+e[1],16),l(e[2]+e[3],16),l(e[4]+e[5],16)]}function E(e){return[+e[0]/360,+e[1]/100,+e[2]/100]}function w(e){return[f(360*+e[0]),f(100*+e[1]),f(100*+e[2])]}function b(e){if(c(e))return e;var t=/\s*rgb\s*\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*\)\s*$/i.exec(e),n=/\s*hsv\s*\(\s*(\d+)\s*,\s*(\d+)%\s*,\s*(\d+)%\s*\)\s*$/i.exec(e);return"#"===e[0]&&e.match(/^#([\da-f]{3}|[\da-f]{6})$/i)?m(e.slice(1)):n?E([+n[1],+n[2],+n[3]]):t?g([+t[1],+t[2],+t[3]]):[0,1,1]}(r=e.CP=function(n,r,l){var f=t.body,g=t.documentElement,v=this,m=e.CP,y=!1,E={},w=t.createElement("div"),b="touchstart mousedown",_="touchmove mousemove",T="touchend mouseup",S="orientationchange resize";if(!(v instanceof m))return new m(n,r);function C(e,t,n){for(var r=0,i=(e=e.split(/\s+/)).length;r<i;++r)t.addEventListener(e[r],n,!1)}function x(e,t,n){for(var r=0,i=(e=e.split(/\s+/)).length;r<i;++r)t.removeEventListener(e[r],n)}function R(e,t){var n="touches",r="clientX",i="clientY",o=t[n]?t[n][0][r]:t[r],a=t[n]?t[n][0][i]:t[i],s=A(e);return{x:o-s.l,y:a-s.t}}function A(t){var n,r,i;return t===e?(n=e.pageXOffset||g.scrollLeft,r=e.pageYOffset||g.scrollTop):(n=(i=t.getBoundingClientRect()).left,r=i.top),{l:n,t:r}}function k(e,t){for(;(e=e.parentElement)&&e!==t;);return e}function I(e){e&&e.preventDefault()}function P(t){return t===e?{w:e.innerWidth,h:e.innerHeight}:{w:t.offsetWidth,h:t.offsetHeight}}function N(e){return y||!!s(e)&&e}function O(e){y=e}function L(e,t,n){if(!s(E[e]))return v;if(s(n))s(E[e][n])&&E[e][n].apply(v,t);else for(var r in E[e])E[e][r].apply(v,t);return v}m[i][n.id||n.name||u(m[i])]=v,s(r)&&!0!==r||(r=b),O(m.parse(n.getAttribute("data-color")||n.value||[0,1,1])),w.className="color-picker",w.innerHTML='<div class="color-picker-control"><span class="color-picker-h"><i></i></span><span class="color-picker-sv"><i></i></span></div>';var z,D=w[o].children,M=N([0,1,1]),H=D[0],F=D[1],V=H[o],j=F[o],U=0,B=0,G=0,q=0,X=0,W=0,Y=0,Z=0,Q=h(M);function K(e,t){e&&"h"!==e||L("change:h",t),e&&"sv"!==e||L("change:sv",t),L("change",t)}function $(){return w.parentNode}function J(i,o){i||((l||o||f).appendChild(w),v.visible=!0),Y=P(w).w,Z=P(w).h;var a=P(F),s=P(j),c=P(H).h,u=a.w,g=a.h,m=P(V).h,y=s.w,E=s.h;if(i){function A(e){var t=e.target,r=t===n||k(t,n)===n;r?J():v.exit(),L(r?"enter":"exit",[v])}w.style.left=w.style.top="-9999px",!1!==r&&C(r,n,A),v.create=function(){return J(1),L("create",[v]),v},v.destroy=function(){return!1!==r&&x(r,n,A),v.exit(),O(!1),L("destroy",[v]),v}}else ee();function D(e){p(M);var t=p([M[0],1,1]);F.style.backgroundColor="rgb("+t.join(",")+")",O(M),I(e)}function X(e){var t,n,r,i,o,a;G&&(n=d(R(H,t=e).y,0,c),M[0]=(c-n)/c,V.style.top=n-m/2+"px",D(t),Q=h(M),U||(L("drag:h",[Q,v]),L("drag",[Q,v]),K("h",[Q,v]))),q&&(i=R(F,r=e),o=d(i.x,0,u),a=d(i.y,0,g),M[1]=1-(u-o)/u,M[2]=(g-a)/g,j.style.right=u-o-y/2+"px",j.style.top=a-E/2+"px",D(r),Q=h(M),B||(L("drag:sv",[Q,v]),L("drag",[Q,v]),K("sv",[Q,v]))),U=0,B=0}function W(e){var t=e.target,i=G?"h":"sv",o=[h(M),v],a=t===n||k(t,n)===n,s=t===w||k(t,w)===w;a||s?s&&(L("stop:"+i,o),L("stop",o),K(i,o)):$()&&!1!==r&&(v.exit(),L("exit",[v]),K(0,o)),G=0,q=0}function te(e){U=1,G=1,X(e),I(e),L("start:h",[Q,v]),L("start",[Q,v]),K("h",[Q,v])}function ne(e){B=1,q=1,X(e),I(e),L("start:sv",[Q,v]),L("start",[Q,v]),K("sv",[Q,v])}z=function(){M=N(M),D(),V.style.top=c-m/2-c*+M[0]+"px",j.style.right=u-y/2-u*+M[1]+"px",j.style.top=g-E/2-g*+M[2]+"px"},v.exit=function(n){return $()&&($().removeChild(w),v.visible=!1),x(b,H,te),x(b,F,ne),x(_,t,X),x(T,t,W),x(S,e,ee),v},z(),i||(C(b,H,te),C(b,F,ne),C(_,t,X),C(T,t,W),C(S,e,ee))}function ee(){return v.fit()}return J(1),a(function(){var e=[h(M),v];L("create",e),K(0,e)},0),v.fit=function(t){var r=P(e),i=P(g),o=r.w-i.w,a=r.h-g.clientHeight,u=A(e),l=A(n);if(X=l.l+u.l,W=l.t+u.t+P(n).h,c(t))s(t[0])&&(X=t[0]),s(t[1])&&(W=t[1]);else{var f=u.l,p=u.t,h=u.l+r.w-Y-o,m=u.t+r.h-Z-a;X=d(X,f,h)>>0,W=d(W,p,m)>>0}return w.style.left=X+"px",w.style.top=W+"px",L("fit",[v]),v},v.set=function(e){return s(e)?("string"==typeof e&&(e=m.parse(e)),O(e),z(),v):N()},v.get=function(e){return N(e)},v.target=n,v.picker=w,v.visible=!1,v.on=function(e,t,n){return s(e)?s(t)?(s(E[e])||(E[e]={}),s(n)||(n=u(E[e])),E[e][n]=t,v):E[e]:E},v.off=function(e,t){return s(e)?s(t)?(delete E[e][t],v):(E[e]={},v):(E={},v)},v.fire=L,v.hooks=E,v.enter=function(e){return J(0,e)},v}).version="1.3.9",r[i]={},r.each=function(e,t){return a(function(){var t,n=r[i];for(t in n)e(n[t],t,n)},0===t?0:t||1),r},r.parse=b,r._HSV2RGB=p,r._HSV2HEX=h,r._RGB2HSV=g,r._HEX2HSV=m,r._HEX2RGB=function(e){return[+(t=y(e))[0]/255,+t[1]/255,+t[2]/255];var t},r.HSV2RGB=function(e){return p(E(e))},r.HSV2HEX=function(e){return h(E(e))},r.RGB2HSV=function(e){return w(g(e))},r.RGB2HEX=v,r.HEX2HSV=function(e){return w(m(e))},r.HEX2RGB=y}(window,document);var saveAs=function(e){"use strict";if(!(void 0===e||"undefined"!=typeof navigator&&/MSIE [1-9]\./.test(navigator.userAgent))){var t=function(){return e.URL||e.webkitURL||e},n=e.document.createElementNS("http://www.w3.org/1999/xhtml","a"),r="download"in n,i=/constructor/i.test(e.HTMLElement)||e.safari,o=/CriOS\/[\d]+/.test(navigator.userAgent),a=e.setImmediate||e.setTimeout,s=function(e){a(function(){throw e},0)},c=function(e){setTimeout(function(){"string"==typeof e?t().revokeObjectURL(e):e.remove()},4e4)},u=function(e){return/^\s*(?:text\/\S*|application\/xml|\S*\/\S*\+xml)\s*;.*charset\s*=\s*utf-8/i.test(e.type)?new Blob([String.fromCharCode(65279),e],{type:e.type}):e},d=function(d,l,f){f||(d=u(d));var p,h=this,g="application/octet-stream"===(d?d.type:void 0),v=function(){!function(e,t,n){for(var r=(t=[].concat(t)).length;r--;){var i=e["on"+t[r]];if("function"==typeof i)try{i.call(e,n||e)}catch(e){s(e)}}}(h,"writestart progress write writeend".split(" "))};if(h.readyState=h.INIT,r)return p||(p=t().createObjectURL(d)),void a(function(){var e,t;n.href=p,n.download=l,e=n,t=new MouseEvent("click"),e.dispatchEvent(t),v(),c(p),h.readyState=h.DONE},0);!function(){if((o||g&&i)&&e.FileReader){var n=new FileReader;return n.onloadend=function(){var t=o?n.result:n.result.replace(/^data:[^;]*;/,"data:attachment/file;");e.open(t,"_blank")||(e.location.href=t),t=void 0,h.readyState=h.DONE,v()},n.readAsDataURL(d),void(h.readyState=h.INIT)}p||(p=t().createObjectURL(d)),g?e.location.href=p:e.open(p,"_blank")||(e.location.href=p);h.readyState=h.DONE,v(),c(p)}()},l=d.prototype;return"undefined"!=typeof navigator&&navigator.msSaveOrOpenBlob?function(e,t,n){return t=t||e.name||"download",n||(e=u(e)),navigator.msSaveOrOpenBlob(e,t)}:(l.abort=function(){},l.readyState=l.INIT=0,l.WRITING=1,l.DONE=2,l.error=l.onwritestart=l.onprogress=l.onwrite=l.onabort=l.onerror=l.onwriteend=null,function(e,t,n){return new d(e,t||e.name||"download",n)})}}("undefined"!=typeof self&&self||"undefined"!=typeof window&&window||this);!function(e){"use strict";var t=e.HTMLCanvasElement&&e.HTMLCanvasElement.prototype,n=e.Blob&&function(){try{return Boolean(new Blob)}catch(e){return!1}}(),r=n&&e.Uint8Array&&function(){try{return 100===new Blob([new Uint8Array(100)]).size}catch(e){return!1}}(),i=e.BlobBuilder||e.WebKitBlobBuilder||e.MozBlobBuilder||e.MSBlobBuilder,o=/^data:((.*?)(;charset=.*?)?)(;base64)?,/,a=(n||i)&&e.atob&&e.ArrayBuffer&&e.Uint8Array&&function(e){var t,a,s,c,u,d,l,f,p;if(!(t=e.match(o)))throw new Error("invalid data URI");for(a=t[2]?t[1]:"text/plain"+(t[3]||";charset=US-ASCII"),s=!!t[4],c=e.slice(t[0].length),u=s?atob(c):decodeURIComponent(c),d=new ArrayBuffer(u.length),l=new Uint8Array(d),f=0;f<u.length;f+=1)l[f]=u.charCodeAt(f);return n?new Blob([r?l:d],{type:a}):((p=new i).append(d),p.getBlob(a))};e.HTMLCanvasElement&&!t.toBlob&&(t.mozGetAsFile?t.toBlob=function(e,n,r){var i=this;setTimeout(function(){r&&t.toDataURL&&a?e(a(i.toDataURL(n,r))):e(i.mozGetAsFile("blob",n))})}:t.toDataURL&&a&&(t.toBlob=function(e,t,n){var r=this;setTimeout(function(){e(a(r.toDataURL(t,n)))})})),"function"==typeof define&&define.amd?define(function(){return a}):"object"==typeof module&&module.exports?module.exports=a:e.dataURLtoBlob=a}(window);
var icn3d=function(e){"use strict";class t{constructor(e){this.icn3dui=e}cloneHash(e){this.icn3dui;let t={};void 0===e&&(e={});for(let s in e)t[s]=e[s];return t}intHash(e,t){this.icn3dui;let s={};if(void 0===e&&(e={}),void 0===t&&(t={}),Object.keys(e).length<Object.keys(t).length)for(let i in e)void 0!==t&&t[i]&&(s[i]=e[i]);else for(let i in t)void 0!==e&&e[i]&&(s[i]=t[i]);return s}exclHash(e,t){void 0===e&&(e={}),void 0===t&&(t={});let s=this.icn3dui.hashUtilsCls.cloneHash(e);for(let e in s)void 0!==t&&t[e]&&delete s[e];return s}unionHash(e,t){return this.icn3dui.hashUtilsCls.unionHashInPlace(e,t)}unionHashInPlace(e,t){return this.icn3dui,void 0===e&&(e={}),void 0===t&&(t={}),$.extend(e,t),e}unionHashNotInPlace(e,t){return this.icn3dui,$.extend({},e,t)}intHash2Atoms(e,t,s){let i=this.icn3dui;return i.hashUtilsCls.hash2Atoms(i.hashUtilsCls.intHash(e,t),s)}exclHash2Atoms(e,t,s){let i=this.icn3dui;return i.hashUtilsCls.hash2Atoms(i.hashUtilsCls.exclHash(e,t),s)}unionHash2Atoms(e,t,s){let i=this.icn3dui;return i.hashUtilsCls.hash2Atoms(i.hashUtilsCls.unionHash(e,t),s)}hash2Atoms(e,t){this.icn3dui;let s={};for(let i in e)s[i]=t[i];return s}hashvalue2array(e){this.icn3dui;let t=[];for(let s in e)t.push(e[s]);return t}}class s{constructor(e){this.icn3dui=e}isIE(){return this.icn3dui,!!(window.navigator.userAgent.indexOf("MSIE ")>0||window.navigator.userAgent.match(/Trident.*rv\:11\./))}isMobile(){return this.icn3dui,/Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(window.navigator.userAgent)}isMac(){return this.icn3dui,/Mac/i.test(window.navigator.userAgent)}isAndroid(){return this.icn3dui,/android/i.test(window.navigator.userAgent.toLowerCase())}isChrome(){return this.icn3dui,navigator.userAgent.includes("Chrome")&&navigator.vendor.includes("Google Inc")}isSessionStorageSupported(){return this.icn3dui,window.sessionStorage}isLocalStorageSupported(){return this.icn3dui,window.localStorage}hexToRgb(e,t){this.icn3dui;let s=/^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(e);return s?{r:parseInt(s[1],16),g:parseInt(s[2],16),b:parseInt(s[3],16),a:t}:null}isCalphaPhosOnly(e){this.icn3dui;let t=!1,s=0,i=0;for(let t in e){if(!(s<100))break;{let s=e[t].name;if(!s)continue;s=s.trim(),"CA"!==s&&"P"!==s&&"O3'"!==s&&"O3*"!==s&&++i}++s}return i<.5*s&&(t=!0),t}hasCovalentBond(e,t){let s=this.icn3dui,i=s.parasCls.covalentRadii[e.elem.toUpperCase()]+s.parasCls.covalentRadii[t.elem.toUpperCase()],n=e.coord.x-t.coord.x,l=e.coord.y-t.coord.y,r=e.coord.z-t.coord.z;return n*n+l*l+r*r<("N"==e.elem&&"H"==t.elem.substr(0,1)||"N"==t.elem&&"H"==e.elem.substr(0,1)?2.2:1.3)*i*i}residueName2Abbr(e){this.icn3dui;let t=e.indexOf(" ");switch(t>0&&(e=e.substr(0,t)),e){case"  A":case" DA":case"DA":case"ALA":return"A";case"  C":case" DC":case"DC":case"CYS":return"C";case"  G":case" DG":case"DG":case"GLY":return"G";case"  T":case" DT":case"DT":case"THR":return"T";case"  U":case" DU":case"DU":case"SEC":return"U";case"  I":case" DI":case"DI":case"ILE":return"I";case"ARG":return"R";case"ASN":return"N";case"ASP":return"D";case"GLU":return"E";case"GLN":return"Q";case"HIS":return"H";case"LEU":return"L";case"LYS":return"K";case"MET":return"M";case"PHE":return"F";case"PRO":return"P";case"SER":return"S";case"TRP":return"W";case"TYR":return"Y";case"VAL":return"V";case"HOH":case"WAT":return"O";default:return e.trim()}}residueAbbr2Name(e){if(this.icn3dui,(e=e.toUpperCase()).length>1)return e;switch(e){case"A":return"ALA";case"R":return"ARG";case"N":return"ASN";case"D":return"ASP";case"C":return"CYS";case"E":return"GLU";case"Q":return"GLN";case"G":return"GLY";case"H":return"HIS";case"I":return"ILE";case"L":return"LEU";case"K":return"LYS";case"M":return"MET";case"F":return"PHE";case"P":return"PRO";case"S":return"SER";case"T":return"THR";case"W":return"TRP";case"Y":return"TYR";case"V":return"VAL";case"O":return"HOH";default:return e.trim()}}getJSONFromArray(e){this.icn3dui;let t="";for(let s=0,i=e.length;s<i;++s)t+=JSON.stringify(e[s]),s!=i-1&&(t+=", ");return t}checkFileAPI(){this.icn3dui,window.File&&window.FileReader&&window.FileList&&window.Blob||alert("The File APIs are not fully supported in this browser.")}getIdArray(e){this.icn3dui;let t=[];if(e){let s=e.indexOf("_"),i=e.lastIndexOf("_");t.push(e.substr(0,s)),t.push(e.substr(s+1,i-s-1)),t.push(e.substr(i+1))}return t}compResid(e,t,s){let i,n,l=this.icn3dui,r=e.split(","),o=t.split(",");"save1"==s?(i=l.utilsCls.getIdArray(r[0]),n=l.utilsCls.getIdArray(o[0])):"save2"==s&&(i=l.utilsCls.getIdArray(r[1]),n=l.utilsCls.getIdArray(o[1]));let a=i[0]+"_"+i[1],d=n[0]+"_"+n[1],c=parseInt(i[2]),h=parseInt(n[2]);return a>d?1:a<d?-1:a==d?c>h?1:c<h?-1:0:void 0}toggle(e,t,s,i){this.icn3dui;let n=[e,t];for(let e in n){let t=n[e];$("#"+t).toggleClass("ui-icon-plus"),$("#"+t).toggleClass("ui-icon-minus")}n=[e,t,s,i];for(let e in n){let t=n[e];$("#"+t).toggleClass("icn3d-shown"),$("#"+t).toggleClass("icn3d-hidden")}}setViewerWidthHeight(e,t){if(e.bNode)return e.htmlCls.WIDTH=400,void(e.htmlCls.HEIGHT=400);let s,i;e.htmlCls.WIDTH=$(window).width()-e.htmlCls.LESSWIDTH,e.htmlCls.HEIGHT=$(window).height()-e.htmlCls.EXTRAHEIGHT-e.htmlCls.LESSHEIGHT,t||void 0===e.oriWidth||-1!==e.cfg.width.toString().indexOf("%")?(s=$("#"+e.pre+"viewer").css("width"),i=$("#"+e.pre+"viewer").css("height"),s=s?s.replace(/px/g,""):e.htmlCls.WIDTH,i=i?i.replace(/px/g,""):e.htmlCls.HEIGHT,t||(-1!==e.cfg.width.toString().indexOf("%")?s=$(window).width()*e.cfg.width.substr(0,e.cfg.width.toString().indexOf("%"))/100-e.htmlCls.LESSWIDTH:e.cfg.width&&(s=parseInt(e.cfg.width)),-1!==e.cfg.height.toString().indexOf("%")?i=$(window).height()*e.cfg.height.substr(0,e.cfg.height.toString().indexOf("%"))/100-e.htmlCls.EXTRAHEIGHT-e.htmlCls.LESSHEIGHT:e.cfg.height&&(i=parseInt(e.cfg.height)))):(s=e.oriWidth,i=e.oriHeight),s&&e.htmlCls.WIDTH>s&&(e.htmlCls.WIDTH=s),i&&e.htmlCls.HEIGHT>i&&(e.htmlCls.HEIGHT=i)}sumArray(e){let t=0;for(let s=0,i=e.length;s<i;++s)t+=e[s];return t}getMemDesc(){return"<div style='width:150px'><span style='color:red'>Red</span> and <span style='color:blue'>blue</span> membranes indicate <span style='color:red'>extracellular</span> and <span style='color:blue'>intracellular</span> membranes, respectively.<br><br></div>"}getStructures(e){let t=this.icn3dui,s={};for(let i in e){s[t.icn3d.atoms[i].structure]=1}return s}getHlStructures(e){let t=this.icn3dui;return e||(e=t.icn3d.hAtoms),this.getStructures(e)}getDisplayedStructures(e){let t=this.icn3dui;return e||(e=t.icn3d.dAtoms),this.getStructures(e)}getDateDigitStr(){this.icn3dui;let e=new Date,t=(e.getMonth()+1).toString();e.getMonth()+1<10&&(t="0"+t);let s=e.getDate().toString();return e.getDate()<10&&(s="0"+s),e.getFullYear().toString()+t+s}}class i{constructor(e){this.icn3dui=e,this.glycanHash={GLC:{c:"1E90FF",s:"sphere"},BGC:{c:"1E90FF",s:"sphere"},NAG:{c:"1E90FF",s:"cube"},NDG:{c:"1E90FF",s:"cube"},GCS:{c:"1E90FF",s:"cube"},PA1:{c:"1E90FF",s:"cube"},GCU:{c:"1E90FF",s:"cone"},BDP:{c:"1E90FF",s:"cone"},G6D:{c:"1E90FF",s:"cone"},DDA:{c:"1E90FF",s:"cylinder"},B6D:{c:"1E90FF",s:"cylinder"},XXM:{c:"1E90FF",s:"cylinder"},MAN:{c:"00FF00",s:"sphere"},BMA:{c:"00FF00",s:"sphere"},BM3:{c:"00FF00",s:"cube"},"95Z":{c:"00FF00",s:"cube"},MAV:{c:"00FF00",s:"cone"},BEM:{c:"00FF00",s:"cone"},RAM:{c:"00FF00",s:"cone"},RM4:{c:"00FF00",s:"cone"},TYV:{c:"00FF00",s:"cylinder"},ARA:{c:"00FF00",s:"cylinder"},ARB:{c:"00FF00",s:"cylinder"},KDN:{c:"00FF00",s:"cylinder"},KDM:{c:"00FF00",s:"cylinder"},"6PZ":{c:"00FF00",s:"cylinder"},GMH:{c:"00FF00",s:"cylinder"},BDF:{c:"00FF00",s:"cylinder"},GAL:{c:"FFFF00",s:"sphere"},GLA:{c:"FFFF00",s:"sphere"},NGA:{c:"FFFF00",s:"cube"},A2G:{c:"FFFF00",s:"cube"},X6X:{c:"FFFF00",s:"cube"},"1GN":{c:"FFFF00",s:"cube"},ADA:{c:"FFFF00",s:"cone"},GTR:{c:"FFFF00",s:"cone"},LDY:{c:"FFFF00",s:"cylinder"},KDO:{c:"FFFF00",s:"cylinder"},T6T:{c:"FFFF00",s:"cylinder"},GUP:{c:"A52A2A",s:"sphere"},GL0:{c:"A52A2A",s:"sphere"},LGU:{c:"A52A2A",s:"cone"},ABE:{c:"A52A2A",s:"cylinder"},XYS:{c:"A52A2A",s:"cylinder"},XYP:{c:"A52A2A",s:"cylinder"},SOE:{c:"A52A2A",s:"cylinder"},PZU:{c:"FF69B4",s:"cylinder"},RIP:{c:"FF69B4",s:"cylinder"},"0MK":{c:"FF69B4",s:"cylinder"},ALL:{c:"8A2BE2",s:"sphere"},AFD:{c:"8A2BE2",s:"sphere"},NAA:{c:"8A2BE2",s:"cube"},SIA:{c:"8A2BE2",s:"cylinder"},SIB:{c:"8A2BE2",s:"cylinder"},AMU:{c:"8A2BE2",s:"cylinder"},X0X:{c:"1E90FF",s:"cone"},X1X:{c:"1E90FF",s:"cone"},NGC:{c:"1E90FF",s:"cylinder"},NGE:{c:"1E90FF",s:"cylinder"},"4N2":{c:"A0522D",s:"sphere"},HSQ:{c:"A0522D",s:"cube"},IDR:{c:"A0522D",s:"cone"},MUR:{c:"A0522D",s:"cylinder"},FUC:{c:"FF0000",s:"cone"},FUL:{c:"FF0000",s:"cone"}},this.nucleotidesArray=["  G","  A","  T","  C","  U"," DG"," DA"," DT"," DC"," DU","G","A","T","C","U","DG","DA","DT","DC","DU"],this.ionsArray=["  K"," NA"," MG"," AL"," CA"," TI"," MN"," FE"," NI"," CU"," ZN"," AG"," BA","  F"," CL"," BR","  I","K","NA","MG","AL","CA","TI","MN","FE","NI","CU","ZN","AG","BA","F","CL","BR","I"],this.cationsTrimArray=["K","NA","MG","AL","CA","TI","MN","FE","NI","CU","ZN","AG","BA"],this.anionsTrimArray=["F","CL","BR","I"],this.ionCharges={K:1,NA:1,MG:2,AL:3,CA:2,TI:3,MN:2,FE:3,NI:2,CU:2,ZN:2,AG:1,BA:2},this.vdwRadii={H:1.08,HE:1.34,LI:1.75,BE:2.05,B:1.47,C:1.49,N:1.41,O:1.4,F:1.39,NE:1.68,NA:1.84,MG:2.05,AL:2.11,SI:2.07,P:1.92,S:1.82,CL:1.83,AR:1.93,K:2.05,CA:2.21,SC:2.16,TI:1.87,V:1.79,CR:1.89,MN:1.97,FE:1.94,CO:1.92,NI:1.84,CU:1.86,ZN:2.1,GA:2.08,GE:2.15,AS:2.06,SE:1.93,BR:1.98,KR:2.12,RB:2.16,SR:2.24,Y:2.19,ZR:1.86,NB:2.07,MO:2.09,TC:2.09,RU:2.07,RH:1.95,PD:2.02,AG:2.03,CD:2.3,IN:2.36,SN:2.33,SB:2.25,TE:2.23,I:2.23,XE:2.21,CS:2.22,BA:2.51,LA:2.4,CE:2.35,PR:2.39,ND:2.29,PM:2.36,SM:2.29,EU:2.33,GD:2.37,TB:2.21,DY:2.29,HO:2.16,ER:2.35,TM:2.27,YB:2.42,LU:2.21,HF:2.12,TA:2.17,W:2.1,RE:2.17,OS:2.16,IR:2.02,PT:2.09,AU:2.17,HG:2.09,TL:2.35,PB:2.32,BI:2.43,PO:2.29,AT:2.36,RN:2.43,FR:2.56,RA:2.43,AC:2.6,TH:2.37,PA:2.43,U:2.4,NP:2.21,PU:2.56,AM:2.56,CM:2.56,BK:2.56,CF:2.56,ES:2.56,FM:2.56},this.covalentRadii={H:.31,HE:.28,LI:1.28,BE:.96,B:.84,C:.76,N:.71,O:.66,F:.57,NE:.58,NA:1.66,MG:1.41,AL:1.21,SI:1.11,P:1.07,S:1.05,CL:1.02,AR:1.06,K:2.03,CA:1.76,SC:1.7,TI:1.6,V:1.53,CR:1.39,MN:1.39,FE:1.32,CO:1.26,NI:1.24,CU:1.32,ZN:1.22,GA:1.22,GE:1.2,AS:1.19,SE:1.2,BR:1.2,KR:1.16,RB:2.2,SR:1.95,Y:1.9,ZR:1.75,NB:1.64,MO:1.54,TC:1.47,RU:1.46,RH:1.42,PD:1.39,AG:1.45,CD:1.44,IN:1.42,SN:1.39,SB:1.39,TE:1.38,I:1.39,XE:1.4,CS:2.44,BA:2.15,LA:2.07,CE:2.04,PR:2.03,ND:2.01,PM:1.99,SM:1.98,EU:1.98,GD:1.96,TB:1.94,DY:1.92,HO:1.92,ER:1.89,TM:1.9,YB:1.87,LU:1.87,HF:1.75,TA:1.7,W:1.62,RE:1.51,OS:1.44,IR:1.41,PT:1.36,AU:1.36,HG:1.32,TL:1.45,PB:1.46,BI:1.48,PO:1.4,AT:1.5,RN:1.5,FR:2.6,RA:2.21,AC:2.15,TH:2.06,PA:2,U:1.96,NP:1.9,PU:1.87,AM:1.8,CM:1.69},this.atomColors={H:this.thr(16777215),He:this.thr(16761035),HE:this.thr(16761035),Li:this.thr(11674146),LI:this.thr(11674146),B:this.thr(65280),C:this.thr(11184810),N:this.thr(255),O:this.thr(15728640),F:this.thr(14329120),Na:this.thr(255),NA:this.thr(255),Mg:this.thr(2263842),MG:this.thr(2263842),Al:this.thr(8421520),AL:this.thr(8421520),Si:this.thr(14329120),SI:this.thr(14329120),P:this.thr(16753920),S:this.thr(16762930),Cl:this.thr(65280),CL:this.thr(65280),Ca:this.thr(8421520),CA:this.thr(8421520),Ti:this.thr(8421520),TI:this.thr(8421520),Cr:this.thr(8421520),CR:this.thr(8421520),Mn:this.thr(8421520),MN:this.thr(8421520),Fe:this.thr(16753920),FE:this.thr(16753920),Ni:this.thr(10824234),NI:this.thr(10824234),Cu:this.thr(10824234),CU:this.thr(10824234),Zn:this.thr(10824234),ZN:this.thr(10824234),Br:this.thr(10824234),BR:this.thr(10824234),Ag:this.thr(8421520),AG:this.thr(8421520),I:this.thr(10494192),Ba:this.thr(16753920),BA:this.thr(16753920),Au:this.thr(14329120),AU:this.thr(14329120)},this.atomnames={H:"Hydrogen",HE:"Helium",LI:"Lithium",B:"Boron",C:"Carbon",N:"Nitrogen",O:"Oxygen",F:"Fluorine",NA:"Sodium",MG:"Magnesium",AL:"Aluminum",SI:"Silicon",P:"Phosphorus",S:"Sulfur",CL:"Chlorine",CA:"Calcium",TI:"Titanium",CR:"Chromium",MN:"Manganese",FE:"Iron",NI:"Nickel",CU:"Copper",ZN:"Zinc",BR:"Bromine",AG:"Silver",I:"Iodine",BA:"Barium",AU:"Gold"},this.defaultAtomColor=this.thr(13421772),this.stdChainColors=[this.thr(16711935),this.thr(255),this.thr(10053171),this.thr(65433),this.thr(16750848),this.thr(16737894),this.thr(3329330),this.thr(2003199),this.thr(16416882),this.thr(16753920),this.thr(52945),this.thr(16738740),this.thr(65280),this.thr(255),this.thr(16711680),this.thr(16776960),this.thr(65535),this.thr(16711935),this.thr(3978097),this.thr(4620980),this.thr(13458524),this.thr(16770229),this.thr(11529966),this.thr(15631086),this.thr(25600),this.thr(139),this.thr(9109504),this.thr(13468991),this.thr(35723),this.thr(9699539)],this.backgroundColors={black:this.thr(0),grey:this.thr(13421772),white:this.thr(16777215),transparent:this.thr(16777215)},this.residueColors={ALA:this.thr(13158600),ARG:this.thr(1334015),ASN:this.thr(56540),ASP:this.thr(15075850),CYS:this.thr(15132160),GLN:this.thr(56540),GLU:this.thr(15075850),GLY:this.thr(15461355),HIS:this.thr(8553170),ILE:this.thr(1016335),LEU:this.thr(1016335),LYS:this.thr(1334015),MET:this.thr(15132160),PHE:this.thr(3289770),PRO:this.thr(14456450),SER:this.thr(16422400),THR:this.thr(16422400),TRP:this.thr(11819700),TYR:this.thr(3289770),VAL:this.thr(1016335),ASX:this.thr(16738740),GLX:this.thr(16738740),G:this.thr(32768),A:this.thr(6324479),T:this.thr(16744448),C:this.thr(16711680),U:this.thr(16744448),DG:this.thr(32768),DA:this.thr(6324479),DT:this.thr(16744448),DC:this.thr(16711680),DU:this.thr(16744448)},this.residueArea={ALA:247,ARG:366,ASN:290,ASP:285,CYS:271,GLN:336,GLU:325,GLY:217,HIS:340,ILE:324,LEU:328,LYS:373,MET:346,PHE:366,PRO:285,SER:265,THR:288,TRP:414,TYR:387,VAL:293,ASX:290,GLX:336,G:520,A:507,T:515,C:467,U:482,DG:520,DA:507,DT:515,DC:467,DU:482},this.defaultResidueColor=this.thr(12492910),this.chargeColors={"  G":this.thr(16711680),"  A":this.thr(16711680),"  T":this.thr(16711680),"  C":this.thr(16711680),"  U":this.thr(16711680)," DG":this.thr(16711680)," DA":this.thr(16711680)," DT":this.thr(16711680)," DC":this.thr(16711680)," DU":this.thr(16711680),G:this.thr(16711680),A:this.thr(16711680),T:this.thr(16711680),C:this.thr(16711680),U:this.thr(16711680),DG:this.thr(16711680),DA:this.thr(16711680),DT:this.thr(16711680),DC:this.thr(16711680),DU:this.thr(16711680),ARG:this.thr(255),LYS:this.thr(255),ASP:this.thr(16711680),GLU:this.thr(16711680),HIS:this.thr(8421631),GLY:this.thr(8947848),PRO:this.thr(8947848),ALA:this.thr(8947848),VAL:this.thr(8947848),LEU:this.thr(8947848),ILE:this.thr(8947848),PHE:this.thr(8947848),SER:this.thr(8947848),THR:this.thr(8947848),ASN:this.thr(8947848),GLN:this.thr(8947848),TYR:this.thr(8947848),MET:this.thr(8947848),CYS:this.thr(8947848),TRP:this.thr(8947848)},this.hydrophobicColors={"  G":this.thr(16711680),"  A":this.thr(16711680),"  T":this.thr(16711680),"  C":this.thr(16711680),"  U":this.thr(16711680)," DG":this.thr(16711680)," DA":this.thr(16711680)," DT":this.thr(16711680)," DC":this.thr(16711680)," DU":this.thr(16711680),G:this.thr(16711680),A:this.thr(16711680),T:this.thr(16711680),C:this.thr(16711680),U:this.thr(16711680),DG:this.thr(16711680),DA:this.thr(16711680),DT:this.thr(16711680),DC:this.thr(16711680),DU:this.thr(16711680),ARG:this.thr(255),LYS:this.thr(255),ASP:this.thr(16711680),GLU:this.thr(16711680),HIS:this.thr(8421631),TRP:this.thr().setHSL(1/3,1,.5),PHE:this.thr().setHSL(1/3,1,.5909090909090908),LEU:this.thr().setHSL(1/3,1,.700956937799043),ILE:this.thr().setHSL(1/3,1,.7320574162679425),TYR:this.thr().setHSL(1/3,1,.5+.69/2.09),MET:this.thr().setHSL(1/3,1,.5+.71/2.09),VAL:this.thr().setHSL(1/3,1,.5+.815/2.09),CYS:this.thr().setHSL(1/3,1,.5+1.035/2.09),PRO:this.thr().setHSL(1/6,1,.9391304347826086),THR:this.thr().setHSL(1/6,1,.8913043478260869),SER:this.thr().setHSL(1/6,1,.8),ALA:this.thr().setHSL(1/6,1,.7826086956521738),GLN:this.thr().setHSL(1/6,1,.6652173913043478),ASN:this.thr().setHSL(1/6,1,.6304347826086956),GLY:this.thr().setHSL(1/6,1,.5)},this.normalizedHPColors={"  G":this.thr(16777215),"  A":this.thr(16777215),"  T":this.thr(16777215),"  C":this.thr(16777215),"  U":this.thr(16777215)," DG":this.thr(16777215)," DA":this.thr(16777215)," DT":this.thr(16777215)," DC":this.thr(16777215)," DU":this.thr(16777215),G:this.thr(16777215),A:this.thr(16777215),T:this.thr(16777215),C:this.thr(16777215),U:this.thr(16777215),DG:this.thr(16777215),DA:this.thr(16777215),DT:this.thr(16777215),DC:this.thr(16777215),DU:this.thr(16777215),ARG:this.thr(16777215),LYS:this.thr(16777215),ASP:this.thr(16777215),GLU:this.thr(16777215),HIS:this.thr(16777215),TRP:this.thr().setHSL(1/3,1,.5),PHE:this.thr().setHSL(1/3,1,.558641975308642),LEU:this.thr().setHSL(1/3,1,.6296296296296295),ILE:this.thr().setHSL(1/3,1,.6496913580246912),TYR:this.thr().setHSL(1/3,1,.5+.69/3.24),MET:this.thr().setHSL(1/3,1,.5+.71/3.24),VAL:this.thr().setHSL(1/3,1,.5+.815/3.24),CYS:this.thr().setHSL(1/3,1,.5+1.035/3.24),PRO:this.thr().setHSL(1/3,1,.5+1.115/3.24),THR:this.thr().setHSL(1/3,1,.5+1.17/3.24),SER:this.thr().setHSL(1/3,1,.5+1.275/3.24),ALA:this.thr().setHSL(1/3,1,.5+1.295/3.24),GLN:this.thr().setHSL(1/3,1,.5+1.43/3.24),ASN:this.thr().setHSL(1/3,1,.5+1.47/3.24),GLY:this.thr().setHSL(1/3,1,1)},this.hydrophobicValues={"  G":3,"  A":3,"  T":3,"  C":3,"  U":3," DG":3," DA":3," DT":3," DC":3," DU":3,G:3,A:3,T:3,C:3,U:3,DG:3,DA:3,DT:3,DC:3,DU:3,ARG:1.5,LYS:1.5,ASP:3,GLU:3,HIS:2,TRP:-2.09,PHE:-1.71,LEU:-1.25,ILE:-1.12,TYR:-.71,MET:-.67,VAL:-.46,CYS:-.02,PRO:.14,THR:.25,SER:.46,ALA:.5,GLN:.77,ASN:.85,GLY:1.15},this.residueAbbrev={ALA:"A (Ala)",ARG:"R (Arg)",ASN:"N (Asn)",ASP:"D (Asp)",CYS:"C (Cys)",GLN:"Q (Gln)",GLU:"E (Glu)",GLY:"G (Gly)",HIS:"H (His)",ILE:"I (Ile)",LEU:"L (Leu)",LYS:"K (Lys)",MET:"M (Met)",PHE:"F (Phe)",PRO:"P (Pro)",SER:"S (Ser)",THR:"T (Thr)",TRP:"W (Trp)",TYR:"Y (Tyr)",VAL:"V (Val)",ASX:"X (Asx)",GLX:"X (Glx)",G:"Guanine",A:"Adenine",T:"Thymine",C:"Cytosine",U:"Uracil",DG:"deoxy-Guanine",DA:"deoxy-Adenine",DT:"deoxy-Thymine",DC:"deoxy-Cytosine",DU:"deoxy-Uracil"},this.ssColors={helix:this.thr(16711680),sheet:this.thr(32768),coil:this.thr(6324479)},this.ssColors2={helix:this.thr(16711680),sheet:this.thr(16762880),coil:this.thr(6324479)},this.resn2restype={ALA:1,ARG:4,ASN:7,ASP:10,CYS:13,GLN:16,GLU:19,GLY:22,HIS:25,ILE:28,LEU:31,LYS:34,MET:37,PHE:40,PRO:43,SER:46,THR:49,TRP:52,TYR:55,VAL:58},this.nuclMainArray=["C1'","C1*","C2'","C2*","C3'","C3*","C4'","C4*","C5'","C5*","O3'","O3*","O4'","O4*","O5'","O5*","P","OP1","O1P","OP2","O2P"],this.b62ResArray=["A","R","N","D","C","Q","E","G","H","I","L","K","M","F","P","S","T","W","Y","V","B","Z","X","*"],this.b62Matrix=[[4,-1,-2,-2,0,-1,-1,0,-2,-1,-1,-1,-1,-2,-1,1,0,-3,-2,0,-2,-1,0,-4],[-1,5,0,-2,-3,1,0,-2,0,-3,-2,2,-1,-3,-2,-1,-1,-3,-2,-3,-1,0,-1,-4],[-2,0,6,1,-3,0,0,0,1,-3,-3,0,-2,-3,-2,1,0,-4,-2,-3,3,0,-1,-4],[-2,-2,1,6,-3,0,2,-1,-1,-3,-4,-1,-3,-3,-1,0,-1,-4,-3,-3,4,1,-1,-4],[0,-3,-3,-3,9,-3,-4,-3,-3,-1,-1,-3,-1,-2,-3,-1,-1,-2,-2,-1,-3,-3,-2,-4],[-1,1,0,0,-3,5,2,-2,0,-3,-2,1,0,-3,-1,0,-1,-2,-1,-2,0,3,-1,-4],[-1,0,0,2,-4,2,5,-2,0,-3,-3,1,-2,-3,-1,0,-1,-3,-2,-2,1,4,-1,-4],[0,-2,0,-1,-3,-2,-2,6,-2,-4,-4,-2,-3,-3,-2,0,-2,-2,-3,-3,-1,-2,-1,-4],[-2,0,1,-1,-3,0,0,-2,8,-3,-3,-1,-2,-1,-2,-1,-2,-2,2,-3,0,0,-1,-4],[-1,-3,-3,-3,-1,-3,-3,-4,-3,4,2,-3,1,0,-3,-2,-1,-3,-1,3,-3,-3,-1,-4],[-1,-2,-3,-4,-1,-2,-3,-4,-3,2,4,-2,2,0,-3,-2,-1,-2,-1,1,-4,-3,-1,-4],[-1,2,0,-1,-3,1,1,-2,-1,-3,-2,5,-1,-3,-1,0,-1,-3,-2,-2,0,1,-1,-4],[-1,-1,-2,-3,-1,0,-2,-3,-2,1,2,-1,5,0,-2,-1,-1,-1,-1,1,-3,-1,-1,-4],[-2,-3,-3,-3,-2,-3,-3,-3,-1,0,0,-3,0,6,-4,-2,-2,1,3,-1,-3,-3,-1,-4],[-1,-2,-2,-1,-3,-1,-1,-2,-2,-3,-3,-1,-2,-4,7,-1,-1,-4,-3,-2,-2,-1,-2,-4],[1,-1,1,0,-1,0,0,0,-1,-2,-2,0,-1,-2,-1,4,1,-3,-2,-2,0,0,0,-4],[0,-1,0,-1,-1,-1,-1,-2,-2,-1,-1,-1,-1,-2,-1,1,5,-2,-2,0,-1,-1,0,-4],[-3,-3,-4,-4,-2,-2,-3,-2,-2,-3,-2,-3,-1,1,-4,-3,-2,11,2,-3,-4,-3,-2,-4],[-2,-2,-2,-3,-2,-1,-2,-3,2,-1,-1,-2,-1,3,-3,-2,-2,2,7,-1,-3,-2,-1,-4],[0,-3,-3,-3,-1,-2,-2,-3,-3,3,1,-2,1,-1,-2,-2,0,-3,-1,4,-3,-2,-1,-4],[-2,-1,3,4,-3,0,1,-1,0,-3,-4,0,-3,-3,-2,0,-1,-4,-3,-3,4,1,-1,-4],[-1,0,0,1,-3,3,4,-2,0,-3,-3,1,-1,-3,-1,0,-1,-3,-2,-2,1,4,-1,-4],[0,-1,-1,-1,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,0,0,-2,-1,-1,-1,-1,-1,-4],[-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,1]]}thr(e){return this.icn3dui,"#0"==e&&(e="#000"),new THREE.Color(e)}}class n{constructor(e){this.icn3dui=e}onId(e,t,s){if(this.icn3dui,!(Object.keys(window).length<2)&&("#"==e.substr(0,1)&&(e=e.substr(1)),document.getElementById(e))){t.split(" ").forEach((t=>{document.getElementById(e).addEventListener(t,s)}))}}onIds(e,t,s){let i=this.icn3dui;Array.isArray(e)?e.forEach((e=>{i.myEventCls.onId(e,t,s)})):i.myEventCls.onId(e,t,s)}}class l{constructor(e){this.icn3dui=e}getRmsdSuprCls(e,t,s){let i,n,l,r,o,a,d,c,h,p,m,u,g,f=this.icn3dui,C=new Array(9),b=new THREE.Vector3,y=new THREE.Vector3,v=[],_=[],w=new Array(3),S=new Array(3),A=new Array(3),x=new Array(3),k=new Array(3),O=new Array(3);if(i=0,s<=1)return{rot:void 0,trans1:void 0,trans2:void 0,rmsd:999};let R=s;for(n=0;n<s;n++)void 0!==e[n]&&void 0!==t[n]?(v.push(e[n].clone()),_.push(t[n].clone()),b.add(e[n]),y.add(t[n])):--R;if((s=R)<=1)return{rot:void 0,trans1:void 0,trans2:void 0,rmsd:999};b.multiplyScalar(1/s),y.multiplyScalar(1/s);let I=b,E=y;for(n=0;n<s;n++)v[n].sub(b),_[n].sub(y);for(n=0,a=d=0;n<s;n++)a+=v[n].x*v[n].x+v[n].y*v[n].y+v[n].z*v[n].z,d+=_[n].x*_[n].x+_[n].y*_[n].y+_[n].z*_[n].z;a/=s,d/=s;let T=new Array(9);for(n=0;n<9;++n)T[n]=0;for(n=0;n<s;n++)T[0]+=v[n].x*_[n].x,T[1]+=v[n].x*_[n].y,T[2]+=v[n].x*_[n].z,T[3]+=v[n].y*_[n].x,T[4]+=v[n].y*_[n].y,T[5]+=v[n].y*_[n].z,T[6]+=v[n].z*_[n].x,T[7]+=v[n].z*_[n].y,T[8]+=v[n].z*_[n].z;for(n=0;n<9;++n)T[n]/=s;let P=f.rmsdSuprCls.getEigenVectors(T);return l=P.k,w=P.h1,S=P.h2,A=P.h3,x=P.k1,k=P.k2,O=P.k3,c=P.d1,h=P.d2,p=P.d3,r=P.flag,u=P.s,1!=l?(i=100,C[0]=1,C[1]=0,C[2]=0,C[3]=0,C[4]=1,C[5]=0,C[6]=0,C[7]=0,C[8]=1,{rot:C,trans1:I,trans2:E,rmsd:i}):(1==r?(x[0]=T[0]*w[0]+T[3]*w[1]+T[6]*w[2],x[1]=T[1]*w[0]+T[4]*w[1]+T[7]*w[2],x[2]=T[2]*w[0]+T[5]*w[1]+T[8]*w[2],o=Math.sqrt(c),x[0]/=o,x[1]/=o,x[2]/=o,k[0]=T[0]*S[0]+T[3]*S[1]+T[6]*S[2],k[1]=T[1]*S[0]+T[4]*S[1]+T[7]*S[2],k[2]=T[2]*S[0]+T[5]*S[1]+T[8]*S[2],o=Math.sqrt(h),k[0]/=o,k[1]/=o,k[2]/=o,O[0]=T[0]*A[0]+T[3]*A[1]+T[6]*A[2],O[1]=T[1]*A[0]+T[4]*A[1]+T[7]*A[2],O[2]=T[2]*A[0]+T[5]*A[1]+T[8]*A[2],o=Math.sqrt(p),O[0]/=o,O[1]/=o,O[2]/=o):2==r&&(w[0]=T[0]*x[0]+T[1]*x[1]+T[2]*x[2],w[1]=T[3]*x[0]+T[4]*x[1]+T[5]*x[2],w[2]=T[6]*x[0]+T[7]*x[1]+T[8]*x[2],o=Math.sqrt(c),w[0]/=o,w[1]/=o,w[2]/=o,S[0]=T[0]*k[0]+T[1]*k[1]+T[2]*k[2],S[1]=T[3]*k[0]+T[4]*k[1]+T[5]*k[2],S[2]=T[6]*k[0]+T[7]*k[1]+T[8]*k[2],o=Math.sqrt(h),S[0]/=o,S[1]/=o,S[2]/=o,A[0]=T[0]*O[0]+T[1]*O[1]+T[2]*O[2],A[1]=T[3]*O[0]+T[4]*O[1]+T[5]*O[2],A[2]=T[6]*O[0]+T[7]*O[1]+T[8]*O[2],o=Math.sqrt(p),A[0]/=o,A[1]/=o,A[2]/=o),u>0?(C[0]=x[0]*w[0]+k[0]*S[0]+O[0]*A[0],C[1]=x[0]*w[1]+k[0]*S[1]+O[0]*A[1],C[2]=x[0]*w[2]+k[0]*S[2]+O[0]*A[2],C[3]=x[1]*w[0]+k[1]*S[0]+O[1]*A[0],C[4]=x[1]*w[1]+k[1]*S[1]+O[1]*A[1],C[5]=x[1]*w[2]+k[1]*S[2]+O[1]*A[2],C[6]=x[2]*w[0]+k[2]*S[0]+O[2]*A[0],C[7]=x[2]*w[1]+k[2]*S[1]+O[2]*A[1],C[8]=x[2]*w[2]+k[2]*S[2]+O[2]*A[2]):(C[0]=x[0]*w[0]+k[0]*S[0]-O[0]*A[0],C[1]=x[0]*w[1]+k[0]*S[1]-O[0]*A[1],C[2]=x[0]*w[2]+k[0]*S[2]-O[0]*A[2],C[3]=x[1]*w[0]+k[1]*S[0]-O[1]*A[0],C[4]=x[1]*w[1]+k[1]*S[1]-O[1]*A[1],C[5]=x[1]*w[2]+k[1]*S[2]-O[1]*A[2],C[6]=x[2]*w[0]+k[2]*S[0]-O[2]*A[0],C[7]=x[2]*w[1]+k[2]*S[1]-O[2]*A[1],C[8]=x[2]*w[2]+k[2]*S[2]-O[2]*A[2]),c=Math.sqrt(c),h=Math.sqrt(h),p=Math.sqrt(p),g=c+h+u*p,m=a+d-2*g,i=m>0?Math.sqrt(m):void 0,{rot:C,trans1:I,trans2:E,rmsd:i})}eigen_values(e){let t,s,i,n,l,r,o,a,d,c,h,p,m,u,g,f,C,b,y,v;if(this.icn3dui,t=e[0],s=e[1],i=e[2],n=e[3],l=e[4],r=e[5],o=e[6],a=e[7],d=e[8],c=-(t+l+d),h=t*l+(t+l)*d-r*a-s*n-i*o,p=-t*l*d+t*r*a+s*n*d-s*r*o-i*n*a+i*l*o,m=-c*c/3+h,u=c*c*c/13.5-c*h/3+p,g=.25*u*u+m*m*m/27,g<0){let e,t;e=Math.sqrt(.25*u*u-g),t=Math.acos(-.5*u/e),b=2*Math.cbrt(e)*Math.cos(t/3)}else f=Math.cbrt(-.5*u+Math.sqrt(g)),C=Math.cbrt(-.5*u-Math.sqrt(g)),b=f+C;return b-=c/3,c+=b,p/=-b,y=.5*(-c+Math.sqrt(c*c-4*p)),v=.5*(-c-Math.sqrt(c*c-4*p)),y<v&&(g=v,v=y,y=v),b<y&&(g=y,y=b,b=g),y<v&&(g=v,v=y,y=v),{d1:b,d2:y,d3:v}}null_basis(e,t,s,i,n){let l,r,o,a,d,c,h,p,m,u,g,f,C,b,y,v,_,w;if(this.icn3dui,a=e[0],d=e[1],c=e[2],h=e[3],p=e[4],m=e[5],u=e[6],g=e[7],f=e[8],w=Math.abs(a),Math.abs(d)>w&&(w=Math.abs(d)),Math.abs(c)>w&&(w=Math.abs(c)),Math.abs(h)>w&&(w=Math.abs(h)),Math.abs(p)>w&&(w=Math.abs(p)),Math.abs(m)>w&&(w=Math.abs(m)),Math.abs(u)>w&&(w=Math.abs(u)),Math.abs(g)>w&&(w=Math.abs(g)),Math.abs(f)>w&&(w=Math.abs(f)),w<1e-10)return r=3,{k:r,v1:t,v2:s,v3:i};if(o=0,a/=w,d/=w,c/=w,h/=w,p/=w,m/=w,u/=w,g/=w,f/=w,Math.abs(a)<n&&Math.abs(h)<n&&Math.abs(u)<n)l=1,t[0]=1,t[1]=0,t[2]=0,Math.abs(d)<n&&Math.abs(p)<n&&Math.abs(g)<n?(l=2,s[0]=0,s[1]=1,s[2]=0,Math.abs(c)<n&&Math.abs(m)<n&&Math.abs(f)<n&&(l=3,i[0]=0,i[1]=0,i[2]=1)):(w=Math.abs(d),Math.abs(p)>w&&(_=a,a=h,h=_,_=d,d=p,p=_,_=c,c=m,m=_,w=Math.abs(d)),Math.abs(g)>w&&(_=a,a=u,u=_,_=d,d=g,g=_,_=c,c=f,f=_),y=m-p*c/d,v=f-g*c/d,Math.abs(y)<n&&Math.abs(v)<n&&(l=2,s[0]=0,s[1]=-c/d,s[2]=1,o=1));else if(w=Math.abs(a),Math.abs(d)>w&&(_=a,a=h,h=_,_=d,d=p,p=_,_=c,c=m,m=_,w=Math.abs(a)),Math.abs(c)>w&&(_=a,a=u,u=_,_=d,d=g,g=_,_=c,c=f,f=_),C=p-h*d/a,b=m-h*c/a,y=g-u*d/a,v=f-u*c/a,Math.abs(C)<n&&Math.abs(y)<n)l=1,t[0]=-d/a,t[1]=1,t[2]=0,Math.abs(b)<n&&Math.abs(v)<n&&(l=2,s[0]=-c/a,s[1]=0,s[2]=1,o=2);else{if(Math.abs(C)<Math.abs(y)&&(_=C,C=y,y=_,_=b,b=v,v=_),!(Math.abs(v-b*y/C)<n))return r=0,t[0]=0,t[1]=0,t[2]=0,{k:r,v1:t,v2:s,v3:i};l=1,t[0]=d/a*(b/C)-c/a,t[1]=-b/C,t[2]=1,o=3}return r=l,o>0&&(1==o?(a=s[0],d=s[1],c=s[2],_=Math.sqrt(a*a+d*d+c*c),s[0]=a/_,s[1]=d/_,s[2]=c/_):2==o?(a=t[0],d=t[1],c=t[2],h=s[0],p=s[1],m=s[2],_=a*h+d*p+c*m,Math.abs(_)>=n&&(s[0]=a+_*h,s[1]=d+_*p,s[2]=c+_*m,h=s[0],p=s[1],m=s[2]),_=Math.sqrt(a*a+d*d+c*c),t[0]=a/_,t[1]=d/_,t[2]=c/_,_=Math.sqrt(h*h+p*p+m*m),s[0]=h/_,s[1]=p/_,s[2]=m/_):(a=t[0],d=t[1],c=t[2],_=Math.sqrt(a*a+d*d+c*c),t[0]=a/_,t[1]=d/_,t[2]=c/_)),{k:r,v1:t,v2:s,v3:i}}getEigenForSelection(e,t){let s,i=this.icn3dui,n=new THREE.Vector3,l=[];for(s=0;s<t;s++)l.push(e[s]),n.add(e[s]);for(n.multiplyScalar(1/t),s=0;s<t;s++)l[s].sub(n);let r=new Array(9);for(s=0;s<9;++s)r[s]=0;for(s=0;s<t;s++)r[0]+=l[s].x*l[s].x,r[1]+=l[s].x*l[s].y,r[2]+=l[s].x*l[s].z,r[3]+=l[s].y*l[s].x,r[4]+=l[s].y*l[s].y,r[5]+=l[s].y*l[s].z,r[6]+=l[s].z*l[s].x,r[7]+=l[s].z*l[s].y,r[8]+=l[s].z*l[s].z;for(s=0;s<9;++s)r[s]/=t;return i.rmsdSuprCls.getEigenVectors(r)}getEigenVectors(e,t){let s,i,n,l,r,o,a,d=this.icn3dui,c=1e-8,h=new Array(9),p=new Array(3),m=new Array(3),u=new Array(3),g=new Array(3),f=new Array(3),C=new Array(3);n=e[0]*(e[4]*e[8]-e[5]*e[7]),n-=e[1]*(e[3]*e[8]-e[5]*e[6]),n+=e[2]*(e[3]*e[7]-e[4]*e[6]),a=n<0?-1:1;let b=new Array(3),y=new Array(3);for(let e=0;e<3;++e)b[e]=new THREE.Vector3,y[e]=new THREE.Vector3;b[0].x=e[0]*e[0]+e[1]*e[1]+e[2]*e[2],b[0].y=e[0]*e[3]+e[1]*e[4]+e[2]*e[5],b[0].z=e[0]*e[6]+e[1]*e[7]+e[2]*e[8],b[1].x=b[0].y,b[1].y=e[3]*e[3]+e[4]*e[4]+e[5]*e[5],b[1].z=e[3]*e[6]+e[4]*e[7]+e[5]*e[8],b[2].x=b[0].z,b[2].y=b[1].z,b[2].z=e[6]*e[6]+e[7]*e[7]+e[8]*e[8],y[0].x=e[0]*e[0]+e[3]*e[3]+e[6]*e[6],y[0].y=e[0]*e[1]+e[3]*e[4]+e[6]*e[7],y[0].z=e[0]*e[2]+e[3]*e[5]+e[6]*e[8],y[1].x=y[0].y,y[1].y=e[1]*e[1]+e[4]*e[4]+e[7]*e[7],y[1].z=e[1]*e[2]+e[4]*e[5]+e[7]*e[8],y[2].x=y[0].z,y[2].y=y[1].z,y[2].z=e[2]*e[2]+e[5]*e[5]+e[8]*e[8],h[0]=b[0].x,h[1]=b[0].y,h[2]=b[0].z,h[3]=b[1].x,h[4]=b[1].y,h[5]=b[1].z,h[6]=b[2].x,h[7]=b[2].y,h[8]=b[2].z;let v=d.rmsdSuprCls.eigen_values(h);l=v.d1,r=v.d2,o=v.d3,i=1,h[0]-=l,h[4]-=l,h[8]-=l;let _=d.rmsdSuprCls.null_basis(h,p,m,u,c);return s=_.k,p=_.v1,m=_.v2,u=_.v3,t||(1==s&&(h[0]+=l-r,h[4]+=l-r,h[8]+=l-r,_=d.rmsdSuprCls.null_basis(h,m,u,p,c),s=_.k,m=_.v1,u=_.v2,p=_.v3,1==s&&(h[0]+=r-o,h[4]+=r-o,h[8]+=r-o,_=d.rmsdSuprCls.null_basis(h,u,p,m,c),s=_.k,u=_.v1,p=_.v2,m=_.v3)),1!=s&&(h[0]=y[0].x,h[1]=y[0].y,h[2]=y[0].z,h[3]=y[1].x,h[4]=y[1].y,h[5]=y[1].z,h[6]=y[2].x,h[7]=y[2].y,h[8]=y[2].z,i=2,h[0]-=l,h[4]-=l,h[8]-=l,_=d.rmsdSuprCls.null_basis(h,g,f,C,c),s=_.k,g=_.v1,f=_.v2,C=_.v3,1==s&&(h[0]+=l-r,h[4]+=l-r,h[8]+=l-r,_=d.rmsdSuprCls.null_basis(h,f,C,g,c),s=_.k,f=_.v1,C=_.v2,g=_.v3,1==s&&(h[0]+=r-o,h[4]+=r-o,h[8]+=r-o,_=d.rmsdSuprCls.null_basis(h,C,g,f,c),s=_.k,C=_.v1,g=_.v2,f=_.v3)))),{k:s,h1:p,h2:m,h3:u,k1:g,k2:f,k3:C,d1:l,d2:r,d3:o,flag:i,s:a}}}class r{constructor(e){this.icn3dui=e}subdivide(e,t,s,i,n,l,r,o){let a=this.icn3dui,d=[],c=[],h=[],p=new Array,m=void 0!==l?l.length:0,u=void 0!==r?r.length:0;m>0&&Math.abs(l[0].x-e[0].x)<=6&&Math.abs(l[0].y-e[0].y)<=6&&Math.abs(l[0].z-e[0].z)<=6?(p.push(l[0]),m=1):m=0,p.push(e[0]);for(let t=1,s=e.length-1;t<s;++t){let s=e[t],i=e[t+1];p.push(s.smoothen?s.clone().add(i).multiplyScalar(.5):s)}p.push(e[e.length-1]);let g=0;u>0&&Math.abs(r[0].x-e[e.length-1].x)<=6&&Math.abs(r[0].y-e[e.length-1].y)<=6&&Math.abs(r[0].z-e[e.length-1].z)<=6&&(p.push(r[0]),++g),u>1&&Math.abs(r[0].x-r[1].x)<=6&&Math.abs(r[0].y-r[1].y)<=6&&Math.abs(r[0].z-r[1].z)<=6&&(p.push(r[1]),++g);let f=[],C=[],b=[];o&&(g=u>0?u-1:0);let y;for(let e=-1,n=p.length,l=1/s;e<=n-3;++e){y=e-m;let r=p[-1===e?0:e],o=p[e+1],u=p[e+2],v=p[e===n-3?n-1:e+3],_=0,w=a.subdivideCls.getKnot(1,_,r,o),S=a.subdivideCls.getKnot(1,w,o,u),A=a.subdivideCls.getKnot(1,S,u,v);w-_<1e-4&&(w=_+1),S-w<1e-4&&(S=w+1),A-S<1e-4&&(A=S+1),e>-1&&(void 0===i||i[y+1])&&e>=-1+m&&e<=n-3-g+1&&(d=d.concat(f),c=c.concat(C),h=h.concat(b)),f=[],C=[],b=[];let x=(S-w)*l;for(let l=0;l<s;++l){let p=w+x*l,k=a.subdivideCls.getValueFromKnot(p,_,w,S,A,r.x,o.x,u.x,v.x),O=a.subdivideCls.getValueFromKnot(p,_,w,S,A,r.y,o.y,u.y,v.y),R=a.subdivideCls.getValueFromKnot(p,_,w,S,A,r.z,o.z,u.z,v.z);i?(e>=-1+m&&e<=n-3-g&&i[y+1]&&l<=parseInt(s/2)&&(d.push(new THREE.Vector3(k,O,R)),c.push(i[y+1]),h.push(t[y+1])),e>=-1+m&&e<=n-3-g+1&&i[y+2]&&l>parseInt(s/2)&&(f.push(new THREE.Vector3(k,O,R)),C.push(i[y+2]),b.push(t[y+2]))):e>=-1+m&&e<=n-3-g&&(d.push(new THREE.Vector3(k,O,R)),c.push(y+1),h.push(t[y+1]))}}i&&!i[y+1]||(d=d.concat(f),c=c.concat(C),h=h.concat(b),d.push(p[p.length-1-g]),c.push(p.length-1-g),h.push(t[p.length-1-g])),f=[],C=[],b=[],p=[];let v=[];return v.push(d),v.push(c),v.push(h),v}getKnot(e,t,s,i){return this.icn3dui,s.distanceTo(i)+t}getValueFromKnot(e,t,s,i,n,l,r,o,a){this.icn3dui;let d,c,h=(r-l)/(s-t),p=(o-r)/(i-s),m=(a-o)/(n-i),u=(s+i)*(s+i)-4*(t*s+i*n-t*n);return 0==u?(d=9999,c=9999):(d=6*(3*p*s+2*h*n+m*s-2*h*s-2*p*n-p*i-m*s)/u,c=6*(3*p*i+2*m*t+h*s-2*p*t-2*m*i-h*i-p*s)/u),p*(e-s)+r+((2*d+c)/6/(s-i)*(e-s)*(e-i)*(e-i)+(2*c+d)/6/(i-s)*(e-s)*(e-s)*(e-i))}}class o{constructor(e){this.icn3dui=e}passFloat32(e,t){let s=this.icn3dui,i=e.length;t||(t=new Uint8Array(4*i));let n=s.convertTypeCls.getDataView(t);for(let t=0;t<i;++t)n.setFloat32(4*t,e[t],!0);return s.convertTypeCls.getUint8View(t)}passInt8(e,t){let s=this.icn3dui,i=e.length;t||(t=new Uint8Array(1*i));let n=s.convertTypeCls.getDataView(t);for(let t=0;t<i;++t)n.setInt8(1*t,e[t],!0);return s.convertTypeCls.getUint8View(t)}passInt16(e,t){let s=this.icn3dui,i=e.length;t||(t=new Uint8Array(2*i));let n=s.convertTypeCls.getDataView(t);for(let t=0;t<i;++t)n.setInt16(2*t,e[t],!0);return s.convertTypeCls.getUint8View(t)}passInt32(e,t){let s=this.icn3dui,i=e.length;t||(t=new Uint8Array(4*i));let n=s.convertTypeCls.getDataView(t);for(let t=0;t<i;++t)n.setInt32(4*t,e[t],!0);return s.convertTypeCls.getUint8View(t)}getUint8View(e){return this.icn3dui.convertTypeCls.getView(Uint8Array,e)}getDataView(e){return this.icn3dui.convertTypeCls.getView(DataView,e)}getView(e,t,s){return this.icn3dui,t?new e(t.buffer,t.byteOffset,t.byteLength/(s||1)):void 0}getBlobFromBufferAndText(e,t){let s=this.icn3dui,i=new Uint8Array(e),n=new Uint8Array(t.length);for(let e=0;e<t.length;++e)n[e]=s.convertTypeCls.passInt8([t.charCodeAt(e)])[0];let l=[];return l.push(new Blob([i],{type:"application/octet-stream"})),l.push(new Blob([n],{type:"application/octet-stream"})),new Blob(l,{type:"image/png"})}}class a{constructor(e){this.icn3dui=e}setAlphaFoldLegend(){let e;return this.icn3dui.icn3d,e="<div>",e+='<span class="icn3d-square" style="background-color: rgb(0, 83, 204);">&nbsp;</span> <span>Very high (pLDDT &gt; 90)</span><br>',e+='<span class="icn3d-square" style="background-color: rgb(101, 203, 243);">&nbsp;</span> <span>Confident (90 &gt; pLDDT &gt; 70)</span><br>',e+='<span class="icn3d-square" style="background-color: rgb(255, 209, 19);">&nbsp;</span> <span>Low (70 &gt; pLDDT &gt; 50)</span><br>',e+='<span class="icn3d-square" style="background-color: rgb(255, 125, 69);">&nbsp;</span> <span>Very low (pLDDT &lt; 50)</span><br>',e+="</div>",'<div><span class="icn3d-square" style="background-color: rgb(0, 83, 204);">&nbsp;</span> <span>Very high (pLDDT &gt; 90)</span><br><span class="icn3d-square" style="background-color: rgb(101, 203, 243);">&nbsp;</span> <span>Confident (90 &gt; pLDDT &gt; 70)</span><br><span class="icn3d-square" style="background-color: rgb(255, 209, 19);">&nbsp;</span> <span>Low (70 &gt; pLDDT &gt; 50)</span><br><span class="icn3d-square" style="background-color: rgb(255, 125, 69);">&nbsp;</span> <span>Very low (pLDDT &lt; 50)</span><br></div>'}setLegendHtml(e){let t=this.icn3dui.icn3d,s="<br>";if(e)s+=this.setAlphaFoldLegend();else{s+="<div style='height: 20px; background: linear-gradient(to right, "+(("red"==t.startColor?"#F00":"green"==t.startColor?"#0F0":"#00F")+" 0%, "+("white"==t.midColor?"#FFF":"#000")+" 50%, "+("red"==t.endColor?"#F00":"green"==t.endColor?"#0F0":"#00F")+" 100%")+");'></div><table width='100%' border='0' cellspacing='0' cellpadding='0'><tr><td width='33%'>"+t.startValue+"</td><td width='33%' align='center'>"+t.midValue+"</td><td width='33%' align='right'>"+t.endValue+"</td></tr></table>"}return s}SetChainsAdvancedMenu(){let e=this.icn3dui,t=e.icn3d;if(void 0===t.bSetChainsAdvancedMenu||!t.bSetChainsAdvancedMenu){let s=e.hashUtilsCls.cloneHash(t.hAtoms);t.definedSetsCls.setPredefinedInMenu(),t.bSetChainsAdvancedMenu=!0,t.hAtoms=e.hashUtilsCls.cloneHash(s)}}setSetsMenus(e,t){let s=this.icn3dui,i=s.icn3d;this.SetChainsAdvancedMenu();let n=e,l=e+"2",r=i.definedSetsCls.setAtomMenu(["protein"]);$("#"+s.pre+n).length&&$("#"+s.pre+n).html("  <option value='selected'>selected</option>"+r),!t&&$("#"+s.pre+l).length&&$("#"+s.pre+l).html("  <option value='selected' selected>selected</option>"+r),$("#"+s.pre+n).resizable(),t||$("#"+s.pre+l).resizable()}applyShownMenus(e){let t=this.icn3dui;t.icn3d;let s=[];for(let e in t.htmlCls.allMenus)t.htmlCls.shownMenus.hasOwnProperty(e)?$("#"+t.pre+e).parent().show():($("#"+t.pre+e).parent().hide(),s.push(e));Object.keys(t.htmlCls.shownMenus).length==Object.keys(t.htmlCls.allMenus).length?$(".icn3d-menusep").show():$(".icn3d-menusep").hide(),localStorage&&!e&&localStorage.setItem("hiddenmenus",JSON.stringify(s))}getHiddenMenusFromCache(){let e=this.icn3dui;e.icn3d;let t=localStorage?localStorage.getItem("hiddenmenus"):"";if(t&&"[]"!=t){e.htmlCls.shownMenus={};let s=JSON.parse(t);for(let t in e.htmlCls.allMenus)-1==s.indexOf(t)&&(e.htmlCls.shownMenus[t]=1)}else e.htmlCls.shownMenus=e.hashUtilsCls.cloneHash(e.htmlCls.allMenus)}displayShownMenus(){let e=this.icn3dui;e.icn3d;let t="<form name='"+e.pre+"selmenu'>";t+="<table><tr><th>File</th><th>Select</th><th>View</th><th>Style</th><th>Color</th><th>Analysis</th><th>Help</th></tr>",t+="<tr>";for(let s in e.htmlCls.allMenusSel){if("uniclr"==s.substr(0,6)||"mn5_opacity"==s.substr(0,11)||"mn6_labelscale"==s.substr(0,14)||"faq_"==s.substr(0,4)||"dev_"==s.substr(0,4))continue;"mn1_searchgrooup"==s?t+="<td valign='top'>":("mn2_definedsets"==s||"mn2_show_selected"==s||"mn3_proteinwrap"==s||e.cfg.cid&&"mn3_ligwrap"==s||"mn4_clrwrap"==s||"mn6_selectannotations"==s||"abouticn3d"==s)&&(t+="</td><td valign='top'>");let i=e.htmlCls.shownMenus.hasOwnProperty(s)?"checked":"",n=e.htmlCls.allMenusSel[s];t+="<span style='white-space:nowrap'><input type='checkbox' name='"+s+"' value='"+s+"'"+i+(3==n?" style='margin-left:30px'":2==n?" style='margin-left:15px'":"")+">"+e.htmlCls.allMenus[s]+"</span><br>"}t+="</td></tr></table></form>",$("#"+e.pre+"menulist").html(t)}async setIgTemplate(e){let t=this.icn3dui.icn3d;t.bRunRefnumAgain=!0;let s=t.resid2specCls.atoms2residues(Object.keys(t.hAtoms));for(let e=0,i=s.length;e<i;++e){let i=s[e];t.resid2refnum&&delete t.resid2refnum[i],t.resid2domainid&&delete t.resid2domainid[i]}t.bAnnoShown||await t.showAnnoCls.showAnnotations(),await t.annotationCls.setAnnoTabIg(!0,e),t.bRunRefnumAgain=!1}setClashedResidues(){let e=this.icn3dui.icn3d,t=Object.keys(e.chains);for(let s=0,i=t.length;s<i;++s){let i=t[s];for(let n=s+1,l=t.length;n<l;++n){let s=t[n];e.showInterCls.pickCustomSphere_base(4,e.chains[i],e.chains[s],false,true)}}e.annoDomainCls.showDomainAll(!0)}clickMenu1(){let e=this.icn3dui;if(e.icn3d,e.bNode)return;let t=this;e.myEventCls.onIds("#"+e.pre+"mn1_vastplus","click",(function(t){e.icn3d,e.htmlCls.dialogCls.openDlg("dl_vastplus","Please input PDB ID for VAST+")})),e.myEventCls.onIds("#"+e.pre+"mn1_vast","click",(function(t){e.icn3d,e.htmlCls.dialogCls.openDlg("dl_vast","Please input chain or PDB file for VAST")})),e.myEventCls.onIds("#"+e.pre+"mn1_foldseek","click",(function(t){e.icn3d,e.htmlCls.dialogCls.openDlg("dl_foldseek","Submit your selection to Foldseek")})),e.myEventCls.onIds("#"+e.pre+"mn1_mmtfid","click",(function(t){e.icn3d,e.htmlCls.dialogCls.openDlg("dl_mmtfid","Please input BCIF/MMTF ID")})),e.myEventCls.onIds("#"+e.pre+"mn1_pdbid","click",(function(t){e.icn3d,e.htmlCls.dialogCls.openDlg("dl_pdbid","Please input PDB ID")})),e.myEventCls.onIds("#"+e.pre+"mn1_afid","click",(function(t){e.icn3d,e.htmlCls.dialogCls.openDlg("dl_afid","Please input AlphaFold UniProt ID")})),e.myEventCls.onIds("#"+e.pre+"mn1_refseqid","click",(function(t){e.icn3d,e.htmlCls.dialogCls.openDlg("dl_refseqid","Please input NCBI Protein Accession")})),e.myEventCls.onIds("#"+e.pre+"mn1_opmid","click",(function(t){e.icn3d,e.htmlCls.dialogCls.openDlg("dl_opmid","Please input OPM PDB ID")})),e.myEventCls.onIds("#"+e.pre+"mn1_align","click",(function(t){e.icn3d,e.htmlCls.dialogCls.openDlg("dl_align","Align two PDB structures")})),e.myEventCls.onIds("#"+e.pre+"mn1_alignaf","click",(function(t){e.icn3d,e.htmlCls.dialogCls.openDlg("dl_alignaf","Align two AlphaFold structures")})),e.myEventCls.onIds("#"+e.pre+"mn1_chainalign","click",(function(t){e.icn3d,e.htmlCls.dialogCls.openDlg("dl_chainalign","Align multiple chains by structure alignment")})),e.myEventCls.onIds("#"+e.pre+"mn1_chainalign2","click",(function(t){e.icn3d,e.htmlCls.dialogCls.openDlg("dl_chainalign2","Align multiple chains by sequence alignment")})),e.myEventCls.onIds("#"+e.pre+"mn1_chainalign3","click",(function(t){e.icn3d,e.htmlCls.dialogCls.openDlg("dl_chainalign3","Align multiple chains residue by residue")})),e.myEventCls.onIds("#"+e.pre+"mn1_mutation","click",(function(t){e.icn3d,e.htmlCls.dialogCls.openDlg("dl_mutation","Show the mutations in 3D")})),e.myEventCls.onIds("#"+e.pre+"mn1_pdbfile","click",(function(t){e.icn3d,e.htmlCls.dialogCls.openDlg("dl_pdbfile","Please input PDB File")})),e.myEventCls.onIds(["#"+e.pre+"mn1_pdbfile_app","#"+e.pre+"tool_pdbfile"],"click",(function(t){e.icn3d,e.htmlCls.dialogCls.openDlg("dl_pdbfile_app","Please append PDB Files")})),e.myEventCls.onIds("#"+e.pre+"mn1_mol2file","click",(function(t){e.icn3d,e.htmlCls.dialogCls.openDlg("dl_mol2file","Please input Mol2 File")})),e.myEventCls.onIds("#"+e.pre+"mn1_sdffile","click",(function(t){e.icn3d,e.htmlCls.dialogCls.openDlg("dl_sdffile","Please input SDF File")})),e.myEventCls.onIds("#"+e.pre+"mn1_xyzfile","click",(function(t){e.icn3d,e.htmlCls.dialogCls.openDlg("dl_xyzfile","Please input XYZ File")})),e.myEventCls.onIds("#"+e.pre+"mn1_afmapfile","click",(function(t){e.icn3d,e.htmlCls.dialogCls.openDlg("dl_afmapfile","Please input AlphaFold PAE File")})),e.myEventCls.onIds("#"+e.pre+"mn1_urlfile","click",(function(t){e.icn3d,e.htmlCls.dialogCls.openDlg("dl_urlfile","Load data by URL")})),e.myEventCls.onIds("#"+e.pre+"mn1_fixedversion","click",(function(t){e.icn3d,e.htmlCls.dialogCls.openDlg("dl_fixedversion","Open Share Link URL in the archived version of iCn3D")})),e.myEventCls.onIds("#"+e.pre+"reload_fixedversion","click",(function(s){let i=e.icn3d,n=$("#"+e.pre+"sharelinkurl").val();t.setLogCmd("open "+n,!1),localStorage.setItem("fixedversion","1");let l=i.structures&&Object.keys(i.structures).length>0?"_blank":"_self";window.open(n,l)})),e.myEventCls.onIds("#"+e.pre+"mn1_mmciffile","click",(function(t){e.icn3d,e.htmlCls.dialogCls.openDlg("dl_mmciffile","Please append mmCIF File")})),e.myEventCls.onIds("#"+e.pre+"mn1_mmcifid","click",(function(t){e.icn3d,e.htmlCls.dialogCls.openDlg("dl_mmcifid","Please input mmCIF ID")})),e.myEventCls.onIds("#"+e.pre+"mn1_mmdbid","click",(function(t){e.icn3d,e.htmlCls.dialogCls.openDlg("dl_mmdbid","Please input MMDB or PDB ID")})),e.myEventCls.onIds(["#"+e.pre+"mn1_mmdbafid",,"#"+e.pre+"tool_mmdbafid"],"click",(function(t){e.icn3d,e.htmlCls.dialogCls.openDlg("dl_mmdbafid","Please input PDB/MMDB/AlphaFold UniProt IDs")})),e.myEventCls.onIds("#"+e.pre+"mn1_blast_rep_id","click",(function(t){e.icn3d,e.htmlCls.dialogCls.openDlg("dl_blast_rep_id","Align sequence to structure")})),e.myEventCls.onIds("#"+e.pre+"mn1_esmfold","click",(function(t){e.icn3d,e.htmlCls.dialogCls.openDlg("dl_esmfold","Sequence to structure prediction with ESMFold")})),e.myEventCls.onIds("#"+e.pre+"mn1_proteinname","click",(function(t){e.icn3d,e.htmlCls.dialogCls.openDlg("dl_proteinname","Please input protein or gene name")})),e.myEventCls.onIds("#"+e.pre+"mn1_cid","click",(function(t){e.icn3d,e.htmlCls.dialogCls.openDlg("dl_cid","Please input PubChem Compound")})),e.myEventCls.onIds("#"+e.pre+"mn1_smiles","click",(function(t){e.icn3d,e.htmlCls.dialogCls.openDlg("dl_smiles","Please input a chemical SMILES")})),e.myEventCls.onIds("#"+e.pre+"mn1_pngimage","click",(function(t){e.icn3d,e.htmlCls.dialogCls.openDlg("dl_pngimage","Please append PNG images")})),e.myEventCls.onIds("#"+e.pre+"mn1_state","click",(function(t){e.icn3d,e.htmlCls.dialogCls.openDlg("dl_state","Please input the state file")})),e.myEventCls.onIds("#"+e.pre+"mn1_selection","click",(function(t){e.icn3d,e.htmlCls.dialogCls.openDlg("dl_selection","Please input the selection file")})),e.myEventCls.onIds("#"+e.pre+"mn1_collection","click",(function(t){e.icn3d,e.htmlCls.dialogCls.openDlg("dl_selectCollections","Select Collections")})),e.myEventCls.onIds("#"+e.pre+"mn1_dsn6","click",(function(t){e.icn3d,e.htmlCls.dialogCls.openDlg("dl_dsn6","Please input the map file to display electron density map")})),e.myEventCls.onIds(["#"+e.pre+"mn1_delphi","#"+e.pre+"mn1_delphi2","#"+e.pre+"tool_delphi"],"click",(function(t){e.icn3d.loadPhiFrom="delphi",$("#"+e.pre+"dl_delphi_tabs").tabs(),e.htmlCls.dialogCls.openDlg("dl_delphi","Please set parameters to display DelPhi potential map")})),e.myEventCls.onIds("#"+e.pre+"mn1_phi","click",(function(t){e.icn3d.loadPhiFrom="phi",$("#"+e.pre+"dl_phi_tabs").tabs(),$("#"+e.pre+"phitab1_tabs").tabs(),$("#"+e.pre+"phitab2_tabs").tabs(),e.htmlCls.dialogCls.openDlg("dl_phi","Please input local phi or cube file to display DelPhi potential map")})),e.myEventCls.onIds("#"+e.pre+"mn1_phiurl","click",(function(t){e.icn3d.loadPhiFrom="phiurl",$("#"+e.pre+"dl_phiurl_tabs").tabs(),$("#"+e.pre+"phiurltab1_tabs").tabs(),$("#"+e.pre+"phiurltab2_tabs").tabs(),e.htmlCls.dialogCls.openDlg("dl_phiurl","Please input URL phi or cube file to display DelPhi potential map")})),e.myEventCls.onIds("#"+e.pre+"mn1_dsn6url","click",(function(t){e.icn3d,e.htmlCls.dialogCls.openDlg("dl_dsn6url","Please input the map file to display electron density map")})),e.myEventCls.onIds("#"+e.pre+"mn1_exportState","click",(function(s){let i=e.icn3d;t.setLogCmd("export state file",!1);let n=Object.keys(i.structures).join(",");i.saveFileCls.saveFile(n+"_statefile.txt","command")})),e.myEventCls.onIds("#"+e.pre+"mn1_exportPdbRes","click",(function(s){e.icn3d,e.htmlCls.setHtmlCls.exportPdb(),t.setLogCmd("export pdb",!0)})),e.myEventCls.onIds("#"+e.pre+"mn1_exportSecondary","click",(function(s){e.icn3d,e.htmlCls.setHtmlCls.exportSecondary(),t.setLogCmd("export secondary structure",!0)})),e.myEventCls.onIds(["#"+e.pre+"delphipdb","#"+e.pre+"phipdb"],"click",(function(s){let i=e.icn3d,n=i.saveFileCls.getSelectedResiduePDB();t.setLogCmd("export PDB of selected residues",!1);let l=Object.keys(i.structures).join(",");i.saveFileCls.saveFile(l+"_icn3d_residues.pdb","text",[n])})),e.myEventCls.onIds(["#"+e.pre+"delphipqr","#"+e.pre+"phipqr","#"+e.pre+"phiurlpqr"],"click",(async function(s){e.icn3d,await e.htmlCls.setHtmlCls.exportPqr(),t.setLogCmd("export pqr",!0)})),e.myEventCls.onIds("#"+e.pre+"profixpdb","click",(async function(s){let i=e.icn3d;await i.scapCls.exportPdbProfix(!1),t.setLogCmd("export pdb missing atoms",!0)})),e.myEventCls.onIds("#"+e.pre+"profixpdbh","click",(async function(s){let i=e.icn3d;await i.scapCls.exportPdbProfix(!0),t.setLogCmd("export pdb hydrogen",!0)})),e.myEventCls.onIds("#"+e.pre+"mn1_exportIgstrand","click",(async function(s){e.icn3d.refnumCls.exportRefnum("igstrand"),t.setLogCmd("export refnum igstrand",!0)})),e.myEventCls.onIds("#"+e.pre+"mn1_exportKabat","click",(async function(s){e.icn3d.refnumCls.exportRefnum("kabat"),t.setLogCmd("export refnum kabat",!0)})),e.myEventCls.onIds("#"+e.pre+"mn1_exportImgt","click",(async function(s){e.icn3d.refnumCls.exportRefnum("imgt"),t.setLogCmd("export refnum imgt",!0)})),e.myEventCls.onIds("#"+e.pre+"mn1_exportStl","click",(function(s){let i=e.icn3d;t.setLogCmd("export stl file",!1),i.export3DCls.exportStlFile("")})),e.myEventCls.onIds("#"+e.pre+"mn1_exportVrml","click",(function(s){let i=e.icn3d;t.setLogCmd("export vrml file",!1),i.export3DCls.exportVrmlFile("")})),e.myEventCls.onIds("#"+e.pre+"mn1_exportStlStab","click",(function(s){let i=e.icn3d;t.setLogCmd("export stl stabilizer file",!1),i.threeDPrintCls.hideStabilizer(),i.threeDPrintCls.resetAfter3Dprint(),i.threeDPrintCls.addStabilizer(),i.export3DCls.exportStlFile("_stab")})),e.myEventCls.onIds("#"+e.pre+"mn1_exportVrmlStab","click",(function(s){let i=e.icn3d;t.setLogCmd("export vrml stabilizer file",!1),i.threeDPrintCls.hideStabilizer(),i.threeDPrintCls.resetAfter3Dprint(),i.threeDPrintCls.addStabilizer(),i.export3DCls.exportVrmlFile("_stab")})),e.myEventCls.onIds("#"+e.pre+"mn6_exportInteraction","click",(async function(s){let i=e.icn3d;t.setLogCmd("export interactions",!1),void 0!==e.cfg.mmdbid&&await i.viewInterPairsCls.retrieveInteractionData(),i.viewInterPairsCls.exportInteractions()})),e.myEventCls.onIds(["#"+e.pre+"mn1_exportCanvas","#"+e.pre+"saveimage"],"click",(async function(s){let i=e.icn3d;t.setLogCmd("export canvas",!1);await i.shareLinkCls.shareLink(!0)})),e.myEventCls.onIds("#"+e.pre+"mn1_exportCanvas1","click",(async function(s){let i=e.icn3d;t.setLogCmd("export canvas 1",!0),i.scaleFactor=1,await i.shareLinkCls.shareLink(!0,!0)})),e.myEventCls.onIds("#"+e.pre+"mn1_exportCanvas2","click",(async function(s){let i=e.icn3d;t.setLogCmd("export canvas 2",!0),i.scaleFactor=2,await i.shareLinkCls.shareLink(!0,!0)})),e.myEventCls.onIds("#"+e.pre+"mn1_exportCanvas4","click",(async function(s){let i=e.icn3d;t.setLogCmd("export canvas 4",!0),i.scaleFactor=4,await i.shareLinkCls.shareLink(!0,!0)})),e.myEventCls.onIds("#"+e.pre+"mn1_exportCanvas8","click",(async function(s){let i=e.icn3d;t.setLogCmd("export canvas 8",!0),i.scaleFactor=8,await i.shareLinkCls.shareLink(!0,!0)})),e.myEventCls.onIds("#"+e.pre+"mn1_exportCounts","click",(function(s){let i=e.icn3d;t.setLogCmd("export counts",!1);let n='<html><body><div style="text-align:center"><br><b>Total Count for atoms with coordinates</b>:<br/><table align=center border=1 cellpadding=10 cellspacing=0><tr><th>Structure Count</th><th>Chain Count</th><th>Residue Count</th><th>Atom Count</th></tr>';n+="<tr><td>"+Object.keys(i.structures).length+"</td><td>"+Object.keys(i.chains).length+"</td><td>"+Object.keys(i.residues).length+"</td><td>"+Object.keys(i.atoms).length+"</td></tr>",n+="</table><br/>",n+="<b>Counts by Chain for atoms with coordinates</b>:<br/><table align=center border=1 cellpadding=10 cellspacing=0><tr><th>Structure</th><th>Chain</th><th>Residue Count</th><th>Atom Count</th></tr>";let l=Object.keys(i.chains);for(let e=0,t=l.length;e<t;++e){let t=l[e],s=t.indexOf("_"),r=t.substr(0,s),o=t.substr(s+1),a={},d=i.chains[t];for(let e in d)a[i.atoms[e].resi]=1;n+="<tr><td>"+r+"</td><td>"+o+"</td><td>"+Object.keys(a).length+"</td><td>"+Object.keys(i.chains[t]).length+"</td></tr>"}n+="</table><br/></div></body></html>";let r=Object.keys(i.structures).join(",");i.saveFileCls.saveFile(r+"_counts.html","html",n)})),e.myEventCls.onIds("#"+e.pre+"mn1_exportSelections","click",(function(s){let i=e.icn3d;t.setLogCmd("export all selections",!1),t.SetChainsAdvancedMenu();let n=i.saveFileCls.exportCustomAtoms(),l=Object.keys(i.structures).join(",");i.saveFileCls.saveFile(l+"_selections.txt","text",[n])})),e.myEventCls.onIds("#"+e.pre+"mn1_exportSelDetails","click",(function(s){let i=e.icn3d;t.setLogCmd("export all selections with details",!1),t.SetChainsAdvancedMenu();let n=i.saveFileCls.exportCustomAtoms(!0),l=Object.keys(i.structures).join(",");i.saveFileCls.saveFile(l+"_sel_details.txt","text",[n])})),e.myEventCls.onIds(["#"+e.pre+"mn1_sharelink","#"+e.pre+"tool_sharelink"],"click",(async function(t){let s=e.icn3d;await s.shareLinkCls.shareLink()})),e.myEventCls.onIds("#"+e.pre+"mn1_replayon","click",(async function(s){let i=e.icn3d;await i.resizeCanvasCls.replayon(),t.setLogCmd("replay on",!0)})),e.myEventCls.onIds("#"+e.pre+"mn1_replayoff","click",(async function(s){let i=e.icn3d;await i.resizeCanvasCls.replayoff(),t.setLogCmd("replay off",!0)})),e.myEventCls.onIds("#"+e.pre+"mn1_menuall","click",(function(s){e.icn3d,e.htmlCls.shownMenus=e.hashUtilsCls.cloneHash(e.htmlCls.allMenus),t.applyShownMenus()})),e.myEventCls.onIds("#"+e.pre+"mn1_menusimple","click",(function(s){e.icn3d,e.htmlCls.shownMenus=e.hashUtilsCls.cloneHash(e.htmlCls.simpleMenus),t.applyShownMenus()})),e.myEventCls.onIds("#"+e.pre+"mn1_menupref","click",(function(s){e.icn3d,e.htmlCls.dialogCls.openDlg("dl_menupref","Select Menus"),t.getHiddenMenusFromCache(),t.displayShownMenus()})),e.myEventCls.onIds(["#"+e.pre+"apply_menupref","#"+e.pre+"apply_menupref2"],"click",(function(s){e.icn3d;var i=document.querySelectorAll('form[name="'+e.pre+'selmenu"] input:checked');for(var n of(e.htmlCls.shownMenus={},i))e.htmlCls.shownMenus[n.value]=1;e.htmlCls.setHtmlCls.setCookie("menumode","custom"),t.applyShownMenus()})),e.myEventCls.onIds(["#"+e.pre+"reset_menupref","#"+e.pre+"reset_menupref2"],"click",(function(s){e.icn3d,e.htmlCls.shownMenus=e.hashUtilsCls.cloneHash(e.htmlCls.simpleMenus),e.htmlCls.setHtmlCls.setCookie("menumode","simple"),t.applyShownMenus(),t.displayShownMenus()})),e.myEventCls.onIds(["#"+e.pre+"reset_menupref_all","#"+e.pre+"reset_menupref_all2"],"click",(function(s){e.icn3d,e.htmlCls.shownMenus=e.hashUtilsCls.cloneHash(e.htmlCls.allMenus),e.htmlCls.setHtmlCls.setCookie("menumode","all"),t.applyShownMenus(),t.displayShownMenus()})),e.myEventCls.onIds(["#"+e.pre+"savepref","#"+e.pre+"savepref2"],"click",(function(t){let s=e.icn3d,i="[";var n=document.querySelectorAll('form[name="'+e.pre+'selmenu"] input:not(:checked)');let l=0;for(var r of n)l>0&&(i+=", "),i+='"'+r.value+'"',++l;i+="]",s.saveFileCls.saveFile("icn3d_menus_pref.txt","text",[i])})),e.myEventCls.onIds("#"+e.pre+"reload_menupreffile","click",(function(s){e.icn3d,s.preventDefault(),e.cfg.notebook||dialog.dialog("close");let i=$("#"+e.pre+"menupreffile")[0].files[0];if(i){e.htmlCls.setHtmlCls.fileSupport();let s=new FileReader;s.onload=function(s){let i=s.target.result,n=JSON.parse(i);e.htmlCls.shownMenus={};for(let t in e.htmlCls.allMenus)-1==n.indexOf(t)&&(e.htmlCls.shownMenus[t]=1);t.applyShownMenus(),t.displayShownMenus(),e.htmlCls.setHtmlCls.setCookie("menumode","custom")},s.readAsText(i)}else alert("Please select a file before clicking 'Load'")})),e.myEventCls.onIds(["#"+e.pre+"mn1_menuloadpref","#"+e.pre+"loadpref","#"+e.pre+"loadpref2"],"click",(function(t){e.icn3d,e.htmlCls.dialogCls.openDlg("dl_menuloadpref","Please input the menu preference file")})),e.myEventCls.onIds("#"+e.pre+"mn1_link_structure","click",(function(t){let s=e.icn3d,i=s.saveFileCls.getLinkToStructureSummary(!0),n=s.structures&&Object.keys(s.structures).length>0?"_blank":"_self";window.open(i,n)})),e.myEventCls.onIds("#"+e.pre+"mn1_alphafold","click",(function(t){e.icn3d;window.open("https://github.com/sokrypton/ColabFold","_blank")})),e.myEventCls.onIds("#"+e.pre+"mn1_link_bind","click",(function(s){let i=e.icn3d,n="https://www.ncbi.nlm.nih.gov/pccompound?LinkName=pccompound_structure&from_uid="+i.inputid;t.setLogCmd("link to 3D protein structures bound to CID "+i.inputid+": "+n,!1);let l=i.structures&&Object.keys(i.structures).length>0?"_blank":"_self";window.open(n,l)})),e.myEventCls.onIds("#"+e.pre+"mn1_link_vast","click",(function(s){let i,n=e.icn3d;if(void 0===n.inputid)i="https://www.ncbi.nlm.nih.gov/pccompound?term="+n.molTitle,t.setLogCmd("link to compounds "+n.molTitle+": "+i,!1);else if(void 0!==e.cfg.cid)i="https://www.ncbi.nlm.nih.gov/pccompound?LinkName=pccompound_pccompound_3d&from_uid="+n.inputid,t.setLogCmd("link to compounds with structure similar to CID "+n.inputid+": "+i,!1);else{let s=n.inputid.split("_");1===s.length?(i=e.htmlCls.baseUrl+"vastplus/vastplus.cgi?uid="+n.inputid,t.setLogCmd("link to structures similar to "+n.inputid+": "+i,!1)):2===s.length&&(i=e.htmlCls.baseUrl+"vastplus/vastplus.cgi?uid="+s[0],t.setLogCmd("link to structures similar to "+s[0]+": "+i,!1))}let l=n.structures&&Object.keys(n.structures).length>0?"_blank":"_self";window.open(i,l)})),e.myEventCls.onIds("#"+e.pre+"mn1_link_pubmed","click",(function(s){let i,n=e.icn3d;if(void 0===n.inputid){i="https://www.ncbi.nlm.nih.gov/pubmed/?term="+n.molTitle,t.setLogCmd("link to literature about "+n.molTitle+": "+i,!1);let e=n.structures&&Object.keys(n.structures).length>0?"_blank":"_self";window.open(i,e)}else if(n.pmid){let e=n.pmid.toString().split("_");1===e.length?(i="https://www.ncbi.nlm.nih.gov/pubmed/"+n.pmid,t.setLogCmd("link to PubMed ID "+n.pmid+": "+i,!1)):2===e.length&&(i="https://www.ncbi.nlm.nih.gov/pubmed/?term="+e[0]+" OR "+e[1],t.setLogCmd("link to PubMed IDs "+e[0]+", "+e[1]+": "+i,!1));let s=n.structures&&Object.keys(n.structures).length>0?"_blank":"_self";window.open(i,s)}else if(isNaN(n.inputid)){let e=n.inputid.toString().split("_");1===e.length?(i="https://www.ncbi.nlm.nih.gov/pubmed/?term="+n.inputid,t.setLogCmd("link to literature about PDB "+n.inputid+": "+i,!1)):2===e.length&&(i="https://www.ncbi.nlm.nih.gov/pubmed/?term="+e[0]+" OR "+e[1],t.setLogCmd("link to literature about PDB "+e[0]+" OR "+e[1]+": "+i,!1));let s=n.structures&&Object.keys(n.structures).length>0?"_blank":"_self";window.open(i,s)}else void 0!==e.cfg.cid?alert("No literature information is available for this compound in the SDF file."):alert("No literature information is available for this structure.")})),e.myEventCls.onIds("#"+e.pre+"mn1_link_protein","click",(function(s){let i=e.icn3d,n=Object.keys(i.structures),l=Object.keys(i.chains),r="";for(let e=0,t=l.length;e<t;++e){let t=i.firstAtomObjCls.getFirstCalphaAtomObj(i.chains[l[e]]);i.proteins.hasOwnProperty(t.serial)&&6==l[e].length&&(r+=l[e]+"[accession] OR ")}r.length>0&&(r=r.substr(0,r.length-4));let o="https://www.ncbi.nlm.nih.gov/protein/?term="+r;t.setLogCmd("link to Entrez protein about PDB "+n+": "+o,!1);let a=i.structures&&Object.keys(i.structures).length>0?"_blank":"_self";window.open(o,a)}))}clickMenu2(){let e=this.icn3dui;if(e.icn3d,e.bNode)return;let t=this;e.myEventCls.onIds(["#"+e.pre+"mn6_selectannotations","#"+e.pre+"tool_selectannotations"],"click",(async function(s){let i=e.icn3d;await i.showAnnoCls.showAnnotations(),t.setLogCmd("view annotations",!0)})),e.myEventCls.onIds("#"+e.pre+"mn2_selectall","click",(function(s){let i=e.icn3d;t.setLogCmd("select all",!0),i.selectionCls.selectAll(),i.hlUpdateCls.removeHlAll(),i.drawCls.draw()})),e.myEventCls.onIds("#"+e.pre+"clearall","click",(function(s){let i=e.icn3d;t.setLogCmd("clear all",!0),i.bSelectResidue=!1,i.selectionCls.selectAll(),i.hlUpdateCls.removeHlAll(),i.drawCls.draw()})),e.myEventCls.onIds("#"+e.pre+"mn2_selectdisplayed","click",(function(s){let i=e.icn3d;t.setLogCmd("select displayed set",!0),i.hAtoms=e.hashUtilsCls.cloneHash(i.viewSelectionAtoms),i.hlUpdateCls.updateHlAll()})),e.myEventCls.onIds("#"+e.pre+"mn2_clashedYes","click",(function(s){let i=e.icn3d;i.bHideClashed=!1,i.annoDomainCls.showHideClashedResidues(),i.drawCls.draw(),t.setLogCmd("clashed residues show",!0)})),e.myEventCls.onIds("#"+e.pre+"mn2_clashedNo","click",(function(s){let i=e.icn3d;i.bHideClashed=!0,t.setClashedResidues(),i.annoDomainCls.showHideClashedResidues(),i.drawCls.draw(),t.setLogCmd("clashed residues hide",!0)})),e.myEventCls.onIds("#"+e.pre+"mn2_fullstru","click",(function(s){let i=e.icn3d;t.setLogCmd("show all",!0),i.selectionCls.showAll()})),e.myEventCls.onIds("#"+e.pre+"mn2_selectcomplement","click",(function(s){let i=e.icn3d;Object.keys(i.hAtoms).length<Object.keys(i.atoms).length&&(t.setLogCmd("select complement",!0),i.resid2specCls.selectComplement())})),e.myEventCls.onIds("#"+e.pre+"mn2_selectmainchains","click",(function(s){let i=e.icn3d;t.setLogCmd("select main chains",!0),i.selectionCls.selectMainChains()})),e.myEventCls.onIds("#"+e.pre+"mn2_selectsidechains","click",(function(s){let i=e.icn3d;t.setLogCmd("select side chains",!0),i.selectionCls.selectSideChains()})),e.myEventCls.onIds("#"+e.pre+"mn2_selectmainsidechains","click",(function(s){let i=e.icn3d;t.setLogCmd("select main side chains",!0),i.selectionCls.selectMainSideChains()})),e.myEventCls.onIds("#"+e.pre+"mn2_propPos","click",(function(s){let i=e.icn3d;t.setLogCmd("select prop positive",!0),i.resid2specCls.selectProperty("positive")})),e.myEventCls.onIds("#"+e.pre+"mn2_propNeg","click",(function(s){let i=e.icn3d;t.setLogCmd("select prop negative",!0),i.resid2specCls.selectProperty("negative")})),e.myEventCls.onIds("#"+e.pre+"mn2_propHydro","click",(function(s){let i=e.icn3d;t.setLogCmd("select prop hydrophobic",!0),i.resid2specCls.selectProperty("hydrophobic")})),e.myEventCls.onIds("#"+e.pre+"mn2_propPolar","click",(function(s){let i=e.icn3d;t.setLogCmd("select prop polar",!0),i.resid2specCls.selectProperty("polar")})),e.myEventCls.onIds("#"+e.pre+"mn2_propBfactor","click",(function(t){e.icn3d,e.htmlCls.dialogCls.openDlg("dl_propbybfactor","Select residue based on B-factor/pLDDT")})),e.myEventCls.onIds("#"+e.pre+"mn2_propSolAcc","click",(function(t){e.icn3d,e.htmlCls.dialogCls.openDlg("dl_propbypercentout","Select residue based on the percentage of solvent accessilbe surface area")})),e.myEventCls.onIds("#"+e.pre+"applypropbybfactor","click",(function(s){let i=e.icn3d,n=$("#"+e.pre+"minbfactor").val(),l=$("#"+e.pre+"maxbfactor").val();t.setLogCmd("select prop b factor | "+n+"_"+l,!0),i.resid2specCls.selectProperty("b factor",n,l)})),e.myEventCls.onIds("#"+e.pre+"applypropbypercentout","click",(function(s){let i=e.icn3d,n=$("#"+e.pre+"minpercentout").val(),l=$("#"+e.pre+"maxpercentout").val();t.setLogCmd("select prop percent out | "+n+"_"+l,!0),i.resid2specCls.selectProperty("percent out",n,l)})),e.myEventCls.onIds("#"+e.pre+"mn2_alignment","click",(function(s){e.icn3d,e.htmlCls.dialogCls.openDlg("dl_alignment","Select residues in aligned sequences"),t.setLogCmd("window aligned sequences",!0)})),e.myEventCls.onIds("#"+e.pre+"mn1_window_table","click",(function(s){e.icn3d,e.htmlCls.dialogCls.openDlg("dl_allinteraction","Show interactions"),t.setLogCmd("window interaction table",!0)})),e.myEventCls.onIds("#"+e.pre+"mn1_window_linegraph","click",(function(s){e.icn3d,e.htmlCls.dialogCls.openDlg("dl_linegraph","Show interactions between two lines of residue nodes"),t.setLogCmd("window interaction graph",!0)})),e.myEventCls.onIds("#"+e.pre+"mn1_window_scatterplot","click",(function(s){e.icn3d,e.htmlCls.dialogCls.openDlg("dl_scatterplot","Show interactions as map"),t.setLogCmd("window interaction scatterplot",!0)})),e.myEventCls.onIds("#"+e.pre+"mn1_window_graph","click",(function(s){e.icn3d,e.htmlCls.dialogCls.openDlg("dl_graph","Force-directed graph"),t.setLogCmd("window force-directed graph",!0)})),e.myEventCls.onIds("#"+e.pre+"mn6_yournote","click",(function(t){e.icn3d,e.htmlCls.dialogCls.openDlg("dl_yournote","Your note about the current display")})),e.myEventCls.onIds("#"+e.pre+"applyyournote","click",(function(s){let i=e.icn3d;i.yournote=$("#"+e.pre+"yournote").val(),e.cfg.shownote&&(document.title=i.yournote),e.cfg.notebook||dialog.dialog("close"),t.setLogCmd("your note | "+i.yournote,!0)})),e.myEventCls.onIds("#"+e.pre+"mn2_command","click",(function(t){e.icn3d,e.htmlCls.dialogCls.openDlg("dl_advanced2","Select by specification")})),e.myEventCls.onIds(["#"+e.pre+"mn2_definedsets","#"+e.pre+"definedsets","#"+e.pre+"definedsets2","#"+e.pre+"tool_definedsets"],"click",(function(s){e.icn3d.definedSetsCls.showSets(),t.setLogCmd("defined sets",!0)})),$(document).on("click","#"+e.pre+"setOr",(function(t){let s=e.icn3d;t.stopImmediatePropagation(),s.setOperation="or"})),$(document).on("click","#"+e.pre+"setAnd",(function(t){let s=e.icn3d;t.stopImmediatePropagation(),s.setOperation="and"})),$(document).on("click","#"+e.pre+"setNot",(function(t){let s=e.icn3d;t.stopImmediatePropagation(),s.setOperation="not"})),e.myEventCls.onIds("#"+e.pre+"mn2_pkNo","click",(function(s){let i=e.icn3d;i.pk=0,i.opts.pk="no",t.setLogCmd("set pk off",!0),i.drawCls.draw(),i.hlObjectsCls.removeHlObjects()})),e.myEventCls.onIds("#"+e.pre+"mn2_pkYes","click",(function(s){let i=e.icn3d;i.pk=1,i.opts.pk="atom",t.setLogCmd("set pk atom",!0)})),e.myEventCls.onIds("#"+e.pre+"mn2_pkResidue","click",(function(s){let i=e.icn3d;i.pk=2,i.opts.pk="residue",t.setLogCmd("set pk residue",!0)})),e.myEventCls.onIds("#"+e.pre+"mn2_pkStrand","click",(function(s){let i=e.icn3d;i.pk=3,i.opts.pk="strand",t.setLogCmd("set pk strand",!0)})),e.myEventCls.onIds("#"+e.pre+"mn2_pkDomain","click",(function(s){let i=e.icn3d;i.pk=4,i.opts.pk="domain",t.setLogCmd("set pk domain",!0)})),e.myEventCls.onIds("#"+e.pre+"mn2_pkChain","click",(function(s){let i=e.icn3d;i.pk=5,i.opts.pk="chain",t.setLogCmd("set pk chain",!0)})),e.myEventCls.onIds("#"+e.pre+"adjustmem","click",(function(t){e.icn3d,e.htmlCls.dialogCls.openDlg("dl_adjustmem","Adjust the Z-axis positions of the membrane")})),e.myEventCls.onIds("#"+e.pre+"togglemem","click",(function(s){e.icn3d.selectionCls.toggleMembrane(),t.setLogCmd("toggle membrane",!0)})),e.myEventCls.onIds("#"+e.pre+"selectplane","click",(function(t){e.icn3d,e.htmlCls.dialogCls.openDlg("dl_selectplane","Select a region between two planes")})),e.myEventCls.onIds(["#"+e.pre+"mn2_aroundsphere","#"+e.pre+"tool_aroundsphere"],"click",(function(s){let i=e.icn3d;t.SetChainsAdvancedMenu();let n=i.definedSetsCls.setAtomMenu(["protein"]);$("#"+e.pre+"atomsCustomSphere").length&&$("#"+e.pre+"atomsCustomSphere").html("  <option value='non-selected' selected>non-selected</option><option value='selected'>selected</option>"+n),$("#"+e.pre+"atomsCustomSphere2").length&&$("#"+e.pre+"atomsCustomSphere2").html("  <option value='selected' selected>selected</option>"+n),e.htmlCls.dialogCls.openDlg("dl_aroundsphere","Select a sphere around a set of residues"),i.bSphereCalc=!1,$("#"+e.pre+"atomsCustomSphere").resizable(),$("#"+e.pre+"atomsCustomSphere2").resizable()})),e.myEventCls.onIds(["#"+e.pre+"mn2_select_chain","#"+e.pre+"definedSets"],"click",(function(t){e.icn3d,e.htmlCls.dialogCls.openDlg("dl_select_chain","Select Structure/Chain/Custom Selection")}))}clickMenu3(){let e=this.icn3dui;if(e.icn3d,e.bNode)return;let t=this;e.myEventCls.onIds(["#"+e.pre+"mn3_proteinsRibbon","#"+e.pre+"tool_proteinsRibbon"],"click",(function(s){e.icn3d.setOptionCls.setStyle("proteins","ribbon"),t.setLogCmd("style proteins ribbon",!0)})),e.myEventCls.onIds("#"+e.pre+"mn3_proteinsStrand","click",(function(s){e.icn3d.setOptionCls.setStyle("proteins","strand"),t.setLogCmd("style proteins strand",!0)})),e.myEventCls.onIds("#"+e.pre+"mn3_proteinsCylinder","click",(function(s){e.icn3d.setOptionCls.setStyle("proteins","cylinder and plate"),t.setLogCmd("style proteins cylinder and plate",!0)})),e.myEventCls.onIds("#"+e.pre+"mn3_proteinsSchematic","click",(function(s){e.icn3d.setOptionCls.setStyle("proteins","schematic"),t.setLogCmd("style proteins schematic",!0)})),e.myEventCls.onIds("#"+e.pre+"mn3_proteinsCalpha","click",(function(s){e.icn3d.setOptionCls.setStyle("proteins","c alpha trace"),t.setLogCmd("style proteins c alpha trace",!0)})),e.myEventCls.onIds("#"+e.pre+"mn3_proteinsBackbone","click",(function(s){e.icn3d.setOptionCls.setStyle("proteins","backbone"),t.setLogCmd("style proteins backbone",!0)})),e.myEventCls.onIds("#"+e.pre+"mn3_proteinsBfactor","click",(function(s){e.icn3d.setOptionCls.setStyle("proteins","b factor tube"),t.setLogCmd("style proteins b factor tube",!0)})),e.myEventCls.onIds("#"+e.pre+"mn3_proteinsLines","click",(function(s){e.icn3d.setOptionCls.setStyle("proteins","lines"),t.setLogCmd("style proteins lines",!0)})),e.myEventCls.onIds("#"+e.pre+"mn3_proteinsStick","click",(function(s){e.icn3d.setOptionCls.setStyle("proteins","stick"),t.setLogCmd("style proteins stick",!0)})),e.myEventCls.onIds(["#"+e.pre+"mn3_proteinsBallstick","#"+e.pre+"tool_proteinsBallstick"],"click",(function(s){e.icn3d.setOptionCls.setStyle("proteins","ball and stick"),t.setLogCmd("style proteins ball and stick",!0)})),e.myEventCls.onIds(["#"+e.pre+"mn3_proteinsSphere","#"+e.pre+"tool_proteinsSphere"],"click",(function(s){e.icn3d.setOptionCls.setStyle("proteins","sphere"),t.setLogCmd("style proteins sphere",!0)})),e.myEventCls.onIds("#"+e.pre+"mn3_proteinsNo","click",(function(s){e.icn3d.setOptionCls.setStyle("proteins","nothing"),t.setLogCmd("style proteins nothing",!0)})),e.myEventCls.onIds("#"+e.pre+"mn3_sidecLines","click",(function(s){e.icn3d.setOptionCls.setStyle("sidec","lines2"),t.setLogCmd("style sidec lines2",!0)})),e.myEventCls.onIds("#"+e.pre+"mn3_sidecStick","click",(function(s){e.icn3d.setOptionCls.setStyle("sidec","stick2"),t.setLogCmd("style sidec stick2",!0)})),e.myEventCls.onIds("#"+e.pre+"mn3_sidecBallstick","click",(function(s){e.icn3d.setOptionCls.setStyle("sidec","ball and stick2"),t.setLogCmd("style sidec ball and stick2",!0)})),e.myEventCls.onIds("#"+e.pre+"mn3_sidecSphere","click",(function(s){e.icn3d.setOptionCls.setStyle("sidec","sphere2"),t.setLogCmd("style sidec sphere2",!0)})),e.myEventCls.onIds("#"+e.pre+"mn3_sidecNo","click",(function(s){e.icn3d.setOptionCls.setStyle("sidec","nothing"),t.setLogCmd("style sidec nothing",!0)})),e.myEventCls.onIds("#"+e.pre+"mn3_ntbaseLines","click",(function(s){e.icn3d.setOptionCls.setStyle("ntbase","lines2"),t.setLogCmd("style ntbase lines2",!0)})),e.myEventCls.onIds("#"+e.pre+"mn3_ntbaseStick","click",(function(s){e.icn3d.setOptionCls.setStyle("ntbase","stick2"),t.setLogCmd("style ntbase stick2",!0)})),e.myEventCls.onIds("#"+e.pre+"mn3_ntbaseBallstick","click",(function(s){e.icn3d.setOptionCls.setStyle("ntbase","ball and stick2"),t.setLogCmd("style ntbase ball and stick2",!0)})),e.myEventCls.onIds("#"+e.pre+"mn3_ntbaseSphere","click",(function(s){e.icn3d.setOptionCls.setStyle("ntbase","sphere2"),t.setLogCmd("style ntbase sphere2",!0)})),e.myEventCls.onIds("#"+e.pre+"mn3_ntbaseNo","click",(function(s){e.icn3d.setOptionCls.setStyle("ntbase","nothing"),t.setLogCmd("style ntbase nothing",!0)})),e.myEventCls.onIds("#"+e.pre+"mn3_nuclCartoon","click",(function(s){e.icn3d.setOptionCls.setStyle("nucleotides","nucleotide cartoon"),t.setLogCmd("style nucleotides nucleotide cartoon",!0)})),e.myEventCls.onIds("#"+e.pre+"mn3_nuclBackbone","click",(function(s){e.icn3d.setOptionCls.setStyle("nucleotides","backbone"),t.setLogCmd("style nucleotides backbone",!0)})),e.myEventCls.onIds("#"+e.pre+"mn3_nuclSchematic","click",(function(s){e.icn3d.setOptionCls.setStyle("nucleotides","schematic"),t.setLogCmd("style nucleotides schematic",!0)})),e.myEventCls.onIds("#"+e.pre+"mn3_nuclPhos","click",(function(s){e.icn3d.setOptionCls.setStyle("nucleotides","o3 trace"),t.setLogCmd("style nucleotides o3 trace",!0)})),e.myEventCls.onIds("#"+e.pre+"mn3_nuclLines","click",(function(s){e.icn3d.setOptionCls.setStyle("nucleotides","lines"),t.setLogCmd("style nucleotides lines",!0)})),e.myEventCls.onIds("#"+e.pre+"mn3_nuclStick","click",(function(s){e.icn3d.setOptionCls.setStyle("nucleotides","stick"),t.setLogCmd("style nucleotides stick",!0)})),e.myEventCls.onIds("#"+e.pre+"mn3_nuclBallstick","click",(function(s){e.icn3d.setOptionCls.setStyle("nucleotides","ball and stick"),t.setLogCmd("style nucleotides ball and stick",!0)})),e.myEventCls.onIds("#"+e.pre+"mn3_nuclSphere","click",(function(s){e.icn3d.setOptionCls.setStyle("nucleotides","sphere"),t.setLogCmd("style nucleotides sphere",!0)})),e.myEventCls.onIds("#"+e.pre+"mn3_nuclNo","click",(function(s){e.icn3d.setOptionCls.setStyle("nucleotides","nothing"),t.setLogCmd("style nucleotides nothing",!0)})),e.myEventCls.onIds("#"+e.pre+"mn3_ligLines","click",(function(s){e.icn3d.setOptionCls.setStyle("chemicals","lines"),t.setLogCmd("style chemicals lines",!0)})),e.myEventCls.onIds("#"+e.pre+"mn3_ligStick","click",(function(s){e.icn3d.setOptionCls.setStyle("chemicals","stick"),t.setLogCmd("style chemicals stick",!0)})),e.myEventCls.onIds("#"+e.pre+"mn3_ligBallstick","click",(function(s){e.icn3d.setOptionCls.setStyle("chemicals","ball and stick"),t.setLogCmd("style chemicals ball and stick",!0)})),e.myEventCls.onIds("#"+e.pre+"mn3_ligSchematic","click",(function(s){e.icn3d.setOptionCls.setStyle("chemicals","schematic"),t.setLogCmd("style chemicals schematic",!0)})),e.myEventCls.onIds("#"+e.pre+"mn3_ligSphere","click",(function(s){e.icn3d.setOptionCls.setStyle("chemicals","sphere"),t.setLogCmd("style chemicals sphere",!0)})),e.myEventCls.onIds("#"+e.pre+"mn3_ligNo","click",(function(s){e.icn3d.setOptionCls.setStyle("chemicals","nothing"),t.setLogCmd("style chemicals nothing",!0)})),e.myEventCls.onIds("#"+e.pre+"mn3_glycansCartYes","click",(function(s){let i=e.icn3d;i.bGlycansCartoon=!0,i.drawCls.draw(),t.setLogCmd("glycans cartoon yes",!0)})),e.myEventCls.onIds("#"+e.pre+"mn3_glycansCartNo","click",(function(s){let i=e.icn3d;i.bGlycansCartoon=!1,i.drawCls.draw(),t.setLogCmd("glycans cartoon no",!0)})),e.myEventCls.onIds("#"+e.pre+"mn3_hydrogensYes","click",(function(s){let i=e.icn3d;i.showInterCls.showHydrogens(),i.drawCls.draw(),t.setLogCmd("hydrogens",!0)})),e.myEventCls.onIds("#"+e.pre+"mn3_hydrogensNo","click",(function(s){let i=e.icn3d;i.showInterCls.hideHydrogens(),i.drawCls.draw(),t.setLogCmd("set hydrogens off",!0)})),e.myEventCls.onIds("#"+e.pre+"mn3_ionsSphere","click",(function(s){e.icn3d.setOptionCls.setStyle("ions","sphere"),t.setLogCmd("style ions sphere",!0)})),e.myEventCls.onIds("#"+e.pre+"mn3_ionsDot","click",(function(s){e.icn3d.setOptionCls.setStyle("ions","dot"),t.setLogCmd("style ions dot",!0)})),e.myEventCls.onIds("#"+e.pre+"mn3_ionsNo","click",(function(s){e.icn3d.setOptionCls.setStyle("ions","nothing"),t.setLogCmd("style ions nothing",!0)})),e.myEventCls.onIds("#"+e.pre+"mn3_waterSphere","click",(function(s){e.icn3d.setOptionCls.setStyle("water","sphere"),t.setLogCmd("style water sphere",!0)})),e.myEventCls.onIds("#"+e.pre+"mn3_waterDot","click",(function(s){e.icn3d.setOptionCls.setStyle("water","dot"),t.setLogCmd("style water dot",!0)})),e.myEventCls.onIds("#"+e.pre+"mn3_waterNo","click",(function(s){e.icn3d.setOptionCls.setStyle("water","nothing"),t.setLogCmd("style water nothing",!0)}))}clickMenu4(){let e=this.icn3dui;if(e.icn3d,e.bNode)return;let t=this;e.myEventCls.onIds("#"+e.pre+"mn4_clrSpectrum","click",(function(s){e.icn3d.setOptionCls.setOption("color","spectrum"),t.setLogCmd("color spectrum",!0)})),e.myEventCls.onIds("#"+e.pre+"mn4_clrSpectrumChain","click",(function(s){e.icn3d.setOptionCls.setOption("color","spectrum for chains"),t.setLogCmd("color spectrum for chains",!0)})),e.myEventCls.onIds("#"+e.pre+"mn4_clrSpectrumAcrossSets","click",(function(s){let i=e.icn3d;t.SetChainsAdvancedMenu();let n=i.definedSetsCls.setAtomMenu(["protein"]);$("#"+e.pre+"atomsCustomColorSpectrumAcross").length&&$("#"+e.pre+"atomsCustomColorSpectrumAcross").html(n),i.bRender&&e.htmlCls.dialogCls.openDlg("dl_colorspectrumacrosssets","Please select sets to apply spectrum color for sets"),$("#"+e.pre+"atomsCustomColorSpectrumAcross").resizable()})),e.myEventCls.onIds("#"+e.pre+"mn4_clrSpectrumSets","click",(function(s){let i=e.icn3d;t.SetChainsAdvancedMenu();let n=i.definedSetsCls.setAtomMenu(["protein"]);$("#"+e.pre+"atomsCustomColorSpectrum").length&&$("#"+e.pre+"atomsCustomColorSpectrum").html(n),i.bRender&&e.htmlCls.dialogCls.openDlg("dl_colorspectrumbysets","Please select sets to apply spectrum color for residues"),$("#"+e.pre+"atomsCustomColorSpectrum").resizable()})),e.myEventCls.onIds("#"+e.pre+"mn4_clrRainbowAcrossSets","click",(function(s){let i=e.icn3d;t.SetChainsAdvancedMenu();let n=i.definedSetsCls.setAtomMenu(["protein"]);$("#"+e.pre+"atomsCustomColorRainbowAcross").length&&$("#"+e.pre+"atomsCustomColorRainbowAcross").html(n),i.bRender&&e.htmlCls.dialogCls.openDlg("dl_colorrainbowacrosssets","Please select sets to apply rainbow color for sets"),$("#"+e.pre+"atomsCustomColorRainbowAcross").resizable()})),e.myEventCls.onIds("#"+e.pre+"mn4_clrRainbowSets","click",(function(s){let i=e.icn3d;t.SetChainsAdvancedMenu();let n=i.definedSetsCls.setAtomMenu(["protein"]);$("#"+e.pre+"atomsCustomColorRainbow").length&&$("#"+e.pre+"atomsCustomColorRainbow").html(n),i.bRender&&e.htmlCls.dialogCls.openDlg("dl_colorrainbowbysets","Please select sets to apply rainbow color for residues"),$("#"+e.pre+"atomsCustomColorRainbow").resizable()})),e.myEventCls.onIds("#"+e.pre+"mn4_clrRainbow","click",(function(s){e.icn3d.setOptionCls.setOption("color","rainbow"),t.setLogCmd("color rainbow",!0)})),e.myEventCls.onIds(["#"+e.pre+"mn4_clrRainbowChain","#"+e.pre+"tool_clrRainbowChain"],"click",(function(s){e.icn3d.setOptionCls.setOption("color","rainbow for chains"),t.setLogCmd("color rainbow for chains",!0)})),e.myEventCls.onIds(["#"+e.pre+"mn4_clrChain","#"+e.pre+"tool_clrChain"],"click",(function(s){e.icn3d.setOptionCls.setOption("color","chain"),t.setLogCmd("color chain",!0)})),e.myEventCls.onIds("#"+e.pre+"mn4_clrStructure","click",(function(s){e.icn3d.setOptionCls.setOption("color","structure"),t.setLogCmd("color structure",!0)})),e.myEventCls.onIds("#"+e.pre+"mn4_clrdomain","click",(function(s){e.icn3d.setOptionCls.setOption("color","domain"),t.setLogCmd("color domain",!0)})),e.myEventCls.onIds("#"+e.pre+"mn4_clrsets","click",(function(s){e.icn3d.setOptionCls.setOption("color","defined sets"),t.setLogCmd("color defined sets",!0)})),e.myEventCls.onIds(["#"+e.pre+"mn4_clrSSGreen","#"+e.pre+"tool_clrSSGreen"],"click",(function(s){let i=e.icn3d;i.sheetcolor="green",i.setOptionCls.setOption("color","secondary structure green"),t.setLogCmd("color secondary structure green",!0)})),e.myEventCls.onIds("#"+e.pre+"mn4_clrSSYellow","click",(function(s){let i=e.icn3d;i.sheetcolor="yellow",i.setOptionCls.setOption("color","secondary structure yellow"),t.setLogCmd("color secondary structure yellow",!0)})),e.myEventCls.onIds("#"+e.pre+"mn4_clrSSSpectrum","click",(function(s){e.icn3d.setOptionCls.setOption("color","secondary structure spectrum"),t.setLogCmd("color secondary structure spectrum",!0)})),e.myEventCls.onIds("#"+e.pre+"mn4_clrResidue","click",(function(s){e.icn3d.setOptionCls.setOption("color","residue"),t.setLogCmd("color residue",!0)})),e.myEventCls.onIds("#"+e.pre+"mn4_clrResidueCustom","click",(function(t){e.icn3d,e.htmlCls.dialogCls.openDlg("dl_rescolorfile","Please input the file on residue colors")})),e.myEventCls.onIds("#"+e.pre+"reload_rescolorfile","click",(function(s){let i=e.icn3d;s.preventDefault(),e.cfg.notebook||dialog.dialog("close");let n=$("#"+e.pre+"rescolorfile")[0].files[0];if(n){e.htmlCls.setHtmlCls.fileSupport();let s=new FileReader;s.onload=function(s){let n=s.target.result.replace(/#/g,"");i.customResidueColors=JSON.parse(n);for(let t in i.customResidueColors)i.customResidueColors[t.toUpperCase()]=e.parasCls.thr("#"+i.customResidueColors[t]);i.setOptionCls.setOption("color","residue custom"),t.setLogCmd("color residue custom | "+n,!0)},s.readAsText(n)}else alert("Please select a file before clicking 'Load'")})),e.myEventCls.onIds("#"+e.pre+"reload_customcolorfile","click",(function(s){let i=e.icn3d;s.preventDefault(),e.cfg.notebook||dialog.dialog("close"),i.startColor=$("#"+e.pre+"startColor").val(),i.midColor=$("#"+e.pre+"midColor").val(),i.endColor=$("#"+e.pre+"endColor").val();let n=t.setLegendHtml();$("#"+e.pre+"dl_legend_html").html(n),e.htmlCls.dialogCls.openDlg("dl_legend","Color range"),i.addTrackCls.setCustomFile("color",i.startColor,i.midColor,i.endColor)})),e.myEventCls.onIds("#"+e.pre+"mn6_customref","click",(function(t){e.icn3d,e.htmlCls.dialogCls.openDlg("dl_customref","Set custom reference numbers")})),e.myEventCls.onIds("#"+e.pre+"reload_customreffile","click",(function(s){let i=e.icn3d;e.cfg.notebook||dialog.dialog("close");let n=$("#"+i.pre+"cstreffile")[0].files[0];if(n){e.utilsCls.checkFileAPI();let s=new FileReader;s.onload=async function(e){let s=e.target.result;await i.refnumCls.parseCustomRefFile(s),s=s.replace(/\r/g,"").replace(/\n/g,"\\n"),t.setLogCmd("custom refnum | "+s,!0)},s.readAsText(n)}else alert("Please select a file before clicking 'Apply'")})),e.myEventCls.onIds("#"+e.pre+"remove_legend","click",(function(s){e.icn3d,s.preventDefault(),$("#"+e.pre+"legend").hide(),t.setLogCmd("remove legend",!0)})),e.myEventCls.onIds("#"+e.pre+"reload_customtubefile","click",(function(t){let s=e.icn3d;t.preventDefault(),e.cfg.notebook||dialog.dialog("close"),s.addTrackCls.setCustomFile("tube")})),e.myEventCls.onIds("#"+e.pre+"mn4_clrCharge","click",(function(s){e.icn3d.setOptionCls.setOption("color","charge"),t.setLogCmd("color charge",!0)})),e.myEventCls.onIds("#"+e.pre+"mn4_clrHydrophobic","click",(function(s){e.icn3d.setOptionCls.setOption("color","hydrophobic"),t.setLogCmd("color hydrophobic",!0)})),e.myEventCls.onIds("#"+e.pre+"mn4_clrNormalizedHP","click",(function(s){e.icn3d.setOptionCls.setOption("color","normalized hydrophobic"),t.setLogCmd("color normalized hydrophobic",!0)})),e.myEventCls.onIds(["#"+e.pre+"mn4_clrAtom","#"+e.pre+"tool_clrAtom"],"click",(function(s){e.icn3d.setOptionCls.setOption("color","atom"),t.setLogCmd("color atom",!0)})),e.myEventCls.onIds("#"+e.pre+"mn4_clrBfactor","click",(function(s){e.icn3d.setOptionCls.setOption("color","b factor"),t.setLogCmd("color b factor",!0)})),e.myEventCls.onIds("#"+e.pre+"mn4_clrConfidence","click",(function(s){e.icn3d.setOptionCls.setOption("color","confidence"),t.setLogCmd("color confidence",!0)})),e.myEventCls.onIds("#"+e.pre+"mn4_clrIgstrand","click",(function(s){e.icn3d.setOptionCls.setOption("color","ig strand"),t.setLogCmd("color ig strand",!0)})),e.myEventCls.onIds("#"+e.pre+"mn4_clrIgproto","click",(function(s){e.icn3d.setOptionCls.setOption("color","ig protodomain"),t.setLogCmd("color ig protodomain",!0)})),e.myEventCls.onIds("#"+e.pre+"mn4_clrArea","click",(function(t){e.icn3d,e.htmlCls.dialogCls.openDlg("dl_colorbyarea","Color based on residue's solvent accessibility")})),e.myEventCls.onIds("#"+e.pre+"applycolorbyarea","click",(function(s){let i=e.icn3d;i.midpercent=$("#"+e.pre+"midpercent").val(),i.setOptionCls.setOption("color","area"),t.setLogCmd("color area | "+i.midpercent,!0)})),e.myEventCls.onIds("#"+e.pre+"mn4_clrBfactorNorm","click",(function(s){e.icn3d.setOptionCls.setOption("color","b factor percentile"),t.setLogCmd("color b factor percentile",!0)})),e.myEventCls.onIds("#"+e.pre+"mn4_clrIdentity","click",(function(s){e.icn3d.setOptionCls.setOption("color","identity"),t.setLogCmd("color identity",!0)})),e.myEventCls.onIds("#"+e.pre+"mn4_clrConserved","click",(function(s){e.icn3d.setOptionCls.setOption("color","conservation"),t.setLogCmd("color conservation",!0)})),e.myEventCls.onIds("#"+e.pre+"mn4_clrCustom","click",(function(t){e.icn3d,e.htmlCls.dialogCls.openDlg("dl_clr","Color picker")})),$(document).on("click",".icn3d-color-rad-text",(function(s){let i=e.icn3d;s.stopImmediatePropagation();let n=$(this).attr("color");i.setOptionCls.setOption("color",n),t.setLogCmd("color "+n,!0)})),e.myEventCls.onIds("#"+e.pre+"mn4_clrSave","click",(function(s){e.icn3d.setOptionCls.saveColor(),t.setLogCmd("save color",!0)})),e.myEventCls.onIds("#"+e.pre+"mn4_clrApplySave","click",(function(s){e.icn3d.setOptionCls.applySavedColor(),t.setLogCmd("apply saved color",!0)})),e.myEventCls.onIds("#"+e.pre+"mn3_styleSave","click",(function(s){e.icn3d.setOptionCls.saveStyle(),t.setLogCmd("save style",!0)})),e.myEventCls.onIds("#"+e.pre+"mn3_styleApplySave","click",(function(s){e.icn3d.setOptionCls.applySavedStyle(),t.setLogCmd("apply saved style",!0)}))}clickMenu5(){let e=this.icn3dui;if(e.icn3d,e.bNode)return;let t=this;e.myEventCls.onIds("#"+e.pre+"mn5_neighborsYes","click",(function(s){let i=e.icn3d;i.bConsiderNeighbors=!0,i.applyMapCls.removeLastSurface(),i.applyMapCls.applySurfaceOptions(),i.bRender&&i.drawCls.render(),t.setLogCmd("set surface neighbors on",!0)})),e.myEventCls.onIds("#"+e.pre+"mn5_neighborsNo","click",(function(s){let i=e.icn3d;i.bConsiderNeighbors=!1,i.applyMapCls.removeLastSurface(),i.applyMapCls.applySurfaceOptions(),i.bRender&&i.drawCls.render(),t.setLogCmd("set surface neighbors off",!0)})),e.myEventCls.onIds(["#"+e.pre+"mn5_surfaceVDW","#"+e.pre+"tool_surfaceVDW"],"click",(function(s){let i=e.icn3d;i.bConsiderNeighbors=!1,i.setOptionCls.setOption("surface","Van der Waals surface"),t.setLogCmd("set surface Van der Waals surface",!0)})),e.myEventCls.onIds("#"+e.pre+"mn5_surfaceSAS","click",(function(s){let i=e.icn3d;i.bConsiderNeighbors=!1,i.setOptionCls.setOption("surface","solvent accessible surface"),t.setLogCmd("set surface solvent accessible surface",!0)})),e.myEventCls.onIds("#"+e.pre+"mn5_surfaceMolecular","click",(function(s){let i=e.icn3d;i.bConsiderNeighbors=!1,i.setOptionCls.setOption("surface","molecular surface"),t.setLogCmd("set surface molecular surface",!0)})),e.myEventCls.onIds("#"+e.pre+"mn5_surfaceVDWContext","click",(function(s){let i=e.icn3d;i.bConsiderNeighbors=!0,i.setOptionCls.setOption("surface","Van der Waals surface with context"),t.setLogCmd("set surface Van der Waals surface with context",!0)})),e.myEventCls.onIds("#"+e.pre+"mn5_surfaceSASContext","click",(function(s){let i=e.icn3d;i.bConsiderNeighbors=!0,i.setOptionCls.setOption("surface","solvent accessible surface with context"),t.setLogCmd("set surface solvent accessible surface with context",!0)})),e.myEventCls.onIds("#"+e.pre+"mn5_surfaceMolecularContext","click",(function(s){let i=e.icn3d;i.bConsiderNeighbors=!0,i.setOptionCls.setOption("surface","molecular surface with context"),t.setLogCmd("set surface molecular surface with context",!0)})),e.myEventCls.onIds("#"+e.pre+"mn5_surfaceNo","click",(function(s){e.icn3d.setOptionCls.setOption("surface","nothing"),t.setLogCmd("set surface nothing",!0)})),$(document).on("click","."+e.pre+"mn5_opacity",(function(s){let i=e.icn3d;i.transparentRenderOrder=!1;let n=$(this).attr("v");i.setOptionCls.setOption("opacity",n),t.setLogCmd("set surface opacity "+n,!0)})),$(document).on("click","."+e.pre+"mn5_opacityslow",(function(s){let i=e.icn3d;i.transparentRenderOrder=!0;let n=$(this).attr("v");i.setOptionCls.setOption("opacity",n),t.setLogCmd("set surface2 opacity "+n,!0)})),e.myEventCls.onIds("#"+e.pre+"mn5_wireframeYes","click",(function(s){e.icn3d.setOptionCls.setOption("wireframe","yes"),t.setLogCmd("set surface wireframe on",!0)})),e.myEventCls.onIds("#"+e.pre+"mn5_wireframeNo","click",(function(s){e.icn3d.setOptionCls.setOption("wireframe","no"),t.setLogCmd("set surface wireframe off",!0)})),e.myEventCls.onIds("#"+e.pre+"mn5_elecmap2fofc","click",(function(t){e.icn3d,e.htmlCls.dialogCls.openDlg("dl_elecmap2fofc","2Fo-Fc Electron Density Map")})),e.myEventCls.onIds("#"+e.pre+"mn5_elecmapfofc","click",(function(t){e.icn3d,e.htmlCls.dialogCls.openDlg("dl_elecmapfofc","Fo-Fc Electron Density Map")})),e.myEventCls.onIds(["#"+e.pre+"mn5_elecmapNo","#"+e.pre+"elecmapNo2","#"+e.pre+"elecmapNo3","#"+e.pre+"elecmapNo4","#"+e.pre+"elecmapNo5"],"click",(function(s){e.icn3d.setOptionCls.setOption("map","nothing"),t.setLogCmd("setoption map nothing",!0)})),e.myEventCls.onIds(["#"+e.pre+"delphimapNo","#"+e.pre+"phimapNo","#"+e.pre+"phiurlmapNo","#"+e.pre+"mn1_phimapNo"],"click",(function(s){e.icn3d.setOptionCls.setOption("phimap","nothing"),t.setLogCmd("setoption phimap nothing",!0)})),e.myEventCls.onIds(["#"+e.pre+"delphimapNo2","#"+e.pre+"phimapNo2","#"+e.pre+"phiurlmapNo2"],"click",(function(s){e.icn3d.setOptionCls.setOption("phisurface","nothing"),t.setLogCmd("setoption phisurface nothing",!0)})),e.myEventCls.onIds("#"+e.pre+"applymap2fofc","click",(async function(s){let i=e.icn3d;s.preventDefault();let n=parseFloat($("#"+e.pre+"sigma2fofc").val());await i.densityCifParserCls.densityCifParser(i.inputid,"2fofc",n),t.setLogCmd("set map 2fofc sigma "+n,!0)})),e.myEventCls.onIds("#"+e.pre+"applymapfofc","click",(async function(s){let i=e.icn3d;s.preventDefault();let n=parseFloat($("#"+e.pre+"sigmafofc").val());await i.densityCifParserCls.densityCifParser(i.inputid,"fofc",sigma2fofc),t.setLogCmd("set map fofc sigma "+n,!0)})),e.myEventCls.onIds("#"+e.pre+"mn5_mapwireframeYes","click",(function(s){e.icn3d.setOptionCls.setOption("mapwireframe","yes"),t.setLogCmd("set map wireframe on",!0)})),e.myEventCls.onIds("#"+e.pre+"mn5_mapwireframeNo","click",(function(s){e.icn3d.setOptionCls.setOption("mapwireframe","no"),t.setLogCmd("set map wireframe off",!0)})),e.myEventCls.onIds("#"+e.pre+"mn5_emmap","click",(function(t){e.icn3d,e.htmlCls.dialogCls.openDlg("dl_emmap","EM Density Map")})),e.myEventCls.onIds(["#"+e.pre+"mn5_emmapNo","#"+e.pre+"emmapNo2"],"click",(function(s){e.icn3d.setOptionCls.setOption("emmap","nothing"),t.setLogCmd("setoption emmap nothing",!0)})),e.myEventCls.onIds("#"+e.pre+"applyemmap","click",(async function(s){let i=e.icn3d;s.preventDefault();let n=parseFloat($("#"+e.pre+"empercentage").val());await i.densityCifParserCls.densityCifParser(i.inputid,"em",n,i.emd),t.setLogCmd("set emmap percentage "+n,!0)})),e.myEventCls.onIds("#"+e.pre+"mn5_emmapwireframeYes","click",(function(s){e.icn3d.setOptionCls.setOption("emmapwireframe","yes"),t.setLogCmd("set emmap wireframe on",!0)})),e.myEventCls.onIds("#"+e.pre+"mn5_emmapwireframeNo","click",(function(s){e.icn3d.setOptionCls.setOption("emmapwireframe","no"),t.setLogCmd("set emmap wireframe off",!0)}))}clickMenu6(){let e=this.icn3dui,t=e.icn3d;if(e.bNode)return;let s=this;e.myEventCls.onIds("#"+e.pre+"mn6_assemblyYes","click",(function(t){let i=e.icn3d;i.bAssembly=!0,s.setLogCmd("set assembly on",!0),i.drawCls.draw()})),e.myEventCls.onIds("#"+e.pre+"mn6_assemblyNo","click",(function(t){let i=e.icn3d;i.bAssembly=!1,s.setLogCmd("set assembly off",!0),i.drawCls.draw()})),e.myEventCls.onIds("#"+e.pre+"mn6_igrefYes","click",(async function(t){let i=e.icn3d;i.bRunRefnumAgain=!0,s.setLogCmd("ig refnum on",!0),i.bAnnoShown||await i.showAnnoCls.showAnnotations();await i.annotationCls.setAnnoTabIg(!0),i.bRunRefnumAgain=!1})),e.myEventCls.onIds("#"+e.pre+"mn6_igrefTpl","click",(async function(t){e.icn3d,e.htmlCls.dialogCls.openDlg("dl_igrefTpl","Choose an Ig template")})),e.myEventCls.onIds("#"+e.pre+"mn6_igrefTpl_apply","click",(async function(t){e.icn3d,e.cfg.notebook||dialog.dialog("close");let i=$("#"+e.pre+"refTpl").val();await s.setIgTemplate(i),s.setLogCmd("ig template "+i,!0)})),e.myEventCls.onIds("#"+e.pre+"mn6_alignrefTpl","click",(async function(t){e.icn3d,e.htmlCls.dialogCls.openDlg("dl_alignrefTpl","Align with an Ig template")})),e.myEventCls.onIds("#"+e.pre+"mn6_alignrefTpl_apply","click",(async function(t){let i=e.icn3d;e.cfg.notebook||dialog.dialog("close");let n=$("#"+e.pre+"refTpl2").val(),l=e.hashUtilsCls.cloneHash(i.hAtoms),r=e.htmlCls.baseUrl+"icn3d/refpdb/"+n+".pdb";await i.pdbParserCls.downloadUrl(r,"pdb",void 0,n),s.setLogCmd("load url "+r+" | type pdb",!0);let o=n.replace(/_/g,"").substr(0,4),a=i.structures[o][0];i.hAtoms=e.hashUtilsCls.unionHash(l,i.chains[a]),e.cfg.aligntool="tmalign",await i.realignParserCls.realignOnStructAlign(),s.setLogCmd("realign on tmalign",!0)})),e.myEventCls.onIds("#"+e.pre+"mn6_igrefNo","click",(async function(t){let i=e.icn3d;s.setLogCmd("ig refnum off",!0),await i.refnumCls.hideIgRefNum()})),e.myEventCls.onIds("#"+e.pre+"mn6_addlabelAtoms","click",(function(t){let i=e.icn3d;i.residueLabelsCls.addAtomLabels(i.hAtoms),i.selectionCls.saveSelectionIfSelected(),s.setLogCmd("add atom labels",!0),i.drawCls.draw()})),e.myEventCls.onIds("#"+e.pre+"mn6_addlabelElements","click",(function(t){let i=e.icn3d;i.residueLabelsCls.addAtomLabels(i.hAtoms,!0),i.selectionCls.saveSelectionIfSelected(),s.setLogCmd("add element labels",!0),i.drawCls.draw()})),e.myEventCls.onIds("#"+e.pre+"mn6_addlabelResidues","click",(function(t){let i=e.icn3d;i.residueLabelsCls.addResidueLabels(i.hAtoms),i.selectionCls.saveSelectionIfSelected(),s.setLogCmd("add residue labels",!0),i.drawCls.draw()})),e.myEventCls.onIds("#"+e.pre+"mn6_addlabelResnum","click",(function(t){let i=e.icn3d;i.residueLabelsCls.addResidueLabels(i.hAtoms,void 0,void 0,!0),i.selectionCls.saveSelectionIfSelected(),s.setLogCmd("add residue number labels",!0),i.drawCls.draw()})),e.myEventCls.onIds("#"+e.pre+"mn6_addlabelRefnum","click",(function(t){let i=e.icn3d;i.residueLabelsCls.addResidueLabels(i.hAtoms,void 0,void 0,void 0,!0),i.selectionCls.saveSelectionIfSelected(),s.setLogCmd("add reference number labels",!0),i.drawCls.draw()})),e.myEventCls.onIds("#"+e.pre+"mn6_addlabelIg","click",(function(t){let i=e.icn3d;i.residueLabelsCls.addIgLabels(i.hAtoms),i.selectionCls.saveSelectionIfSelected(),s.setLogCmd("add ig labels",!0),i.drawCls.draw()})),e.myEventCls.onIds("#"+e.pre+"mn6_addlabelChains","click",(function(t){let i=e.icn3d;i.analysisCls.addChainLabels(i.hAtoms),i.selectionCls.saveSelectionIfSelected(),s.setLogCmd("add chain labels",!0),i.drawCls.draw()})),e.myEventCls.onIds("#"+e.pre+"mn6_addlabelTermini","click",(function(t){let i=e.icn3d;i.analysisCls.addTerminiLabels(i.hAtoms),i.selectionCls.saveSelectionIfSelected(),s.setLogCmd("add terminal labels",!0),i.drawCls.draw()})),e.myEventCls.onIds("#"+e.pre+"mn6_addlabelYes","click",(function(t){let s=e.icn3d;e.htmlCls.dialogCls.openDlg("dl_addlabel","Add custom labels by selection"),s.pk=1,s.opts.pk="atom",s.pickpair=!0,s.pAtomNum=0})),e.myEventCls.onIds("#"+e.pre+"mn6_addlabelSelection","click",(function(t){e.icn3d,e.htmlCls.dialogCls.openDlg("dl_addlabelselection","Add custom labels by the selected")})),e.myEventCls.onIds("#"+e.pre+"mn6_labelColor","click",(function(t){e.icn3d,e.htmlCls.dialogCls.openDlg("dl_labelColor","Change color for all labels")})),e.myEventCls.onIds(["#"+e.pre+"mn2_saveselection","#"+e.pre+"tool_saveselection"],"click",(function(t){e.icn3d,e.htmlCls.dialogCls.openDlg("dl_saveselection","Save the selected")})),e.myEventCls.onIds(["#"+e.pre+"mn6_addlabelNo","#"+e.pre+"removeLabels"],"click",(function(t){let i=e.icn3d;i.labelcolor=void 0,i.pickpair=!1;s.setLogCmd("set labels off",!0);for(let e in i.labels)i.labels[e]=[];i.drawCls.draw()})),$(document).on("click","."+e.pre+"mn6_labelscale",(function(t){let i=e.icn3d,n=$(this).attr("v");i.labelScale=n,i.drawCls.draw(),s.setLogCmd("set label scale "+n,!0)})),e.myEventCls.onIds("#"+e.pre+"mn6_distanceYes","click",(function(t){let s=e.icn3d;e.htmlCls.dialogCls.openDlg("dl_distance","Measure the distance of atoms"),s.pk=1,s.opts.pk="atom",s.pickpair=!0,s.pAtomNum=0,s.bMeasureDistance=!0})),e.myEventCls.onIds("#"+e.pre+"mn6_distTwoSets","click",(function(t){let i=e.icn3d;e.htmlCls.dialogCls.openDlg("dl_disttwosets","Measure the distance between two sets"),s.setSetsMenus("atomsCustomDist"),i.bMeasureDistance=!0})),e.myEventCls.onIds("#"+e.pre+"mn6_distManySets","click",(function(t){let i=e.icn3d;e.htmlCls.dialogCls.openDlg("dl_distmanysets","Measure the pairwise distances among many sets"),s.setSetsMenus("atomsCustomDistTable"),i.bMeasureDistance=!0})),e.myEventCls.onIds("#"+e.pre+"mn6_angleManySets","click",(function(t){let i=e.icn3d;e.htmlCls.dialogCls.openDlg("dl_anglemanysets","Measure the pairwise angles among many sets"),s.setSetsMenus("atomsCustomAngleTable"),i.bMeasureAngle=!0})),e.myEventCls.onIds("#"+e.pre+"mn6_distanceNo","click",(function(t){let i=e.icn3d;i.pickpair=!1;s.setLogCmd("set lines off",!0),i.labels.distance=[],i.lines.distance=[],i.distPnts=[],i.pk=2,i.drawCls.draw()})),e.myEventCls.onIds("#"+e.pre+"mn5_cartoonshape","click",(function(t){let i=e.icn3d;e.htmlCls.dialogCls.openDlg("dl_cartoonshape","Draw cartoon for a set");s.setSetsMenus("cartoonshape",!0),i.bCartoonshape=!0})),e.myEventCls.onIds("#"+e.pre+"mn5_linebtwsets","click",(function(t){let i=e.icn3d;e.htmlCls.dialogCls.openDlg("dl_linebtwsets","Draw a line between two sets"),s.setSetsMenus("linebtwsets"),i.bLinebtwsets=!0})),e.myEventCls.onIds(["#"+e.pre+"mn2_selectedcenter","#"+e.pre+"zoomin_selection","#"+e.pre+"tool_selectedcenter"],"click",(function(t){let i=e.icn3d;i.transformCls.zoominSelection(),i.drawCls.draw(),s.setLogCmd("zoom selection",!0)})),e.myEventCls.onIds("#"+e.pre+"mn6_center","click",(function(t){let i=e.icn3d;i.applyCenterCls.centerSelection(),i.drawCls.draw(),s.setLogCmd("center selection",!0)})),e.myEventCls.onIds(["#"+e.pre+"mn6_resetOrientation","#"+e.pre+"resetOrientation","#"+e.pre+"tool_resetOrientation"],"click",(function(t){let i=e.icn3d;i.transformCls.resetOrientation(),i.drawCls.draw(),s.setLogCmd("reset orientation",!0)})),e.myEventCls.onIds(["#"+e.pre+"mn6_chemicalbindingshow","#"+e.pre+"chemicalbindingshow"],"click",(function(t){e.icn3d.setOptionCls.setOption("chemicalbinding","show"),s.setLogCmd("set chemicalbinding show",!0)})),e.myEventCls.onIds(["#"+e.pre+"mn6_chemicalbindinghide","#"+e.pre+"chemicalbindinghide"],"click",(function(t){e.icn3d.setOptionCls.setOption("chemicalbinding","hide"),s.setLogCmd("set chemicalbinding hide",!0)})),e.myEventCls.onIds("#"+e.pre+"mn6_sidebyside","click",(function(t){let i=e.icn3d;if(i.bInputfile)return void alert("Side-by-Side does NOT work when the input is from a local file.");let n=i.shareLinkCls.shareLinkUrl(void 0);n=n.replace("icn3d/full.html?","icn3d/full2.html?"),n=n.replace("icn3d/?","icn3d/full2.html?"),n+="&closepopup=1";let l=i.structures&&Object.keys(i.structures).length>0?"_blank":"_self";window.open(n,l),s.setLogCmd("side by side | "+n,!0)})),$(document).on("click","#"+e.pre+"mn2_translate",(function(t){e.icn3d,e.htmlCls.dialogCls.openDlg("dl_translate","Translate the X,Y,Z coordinates of the structure")})),$(document).on("click","#"+e.pre+"mn6_angleTwoSets",(function(t){e.icn3d,e.htmlCls.dialogCls.openDlg("dl_angle","Measure the angle between two vectors")})),$(document).on("click","#"+e.pre+"mn2_matrix",(function(t){e.icn3d,e.htmlCls.dialogCls.openDlg("dl_matrix","Apply matrix to the X,Y,Z coordinates of the structure")})),$(document).on("click","."+e.pre+"mn6_rotate",(function(t){let i=e.icn3d,n=$(this).attr("v").toLowerCase(),l=n.split(" ")[1];s.setLogCmd(n,!0),i.bStopRotate=!1,i.transformCls.rotateCount=0,i.transformCls.rotateCountMax=6e3,i.ROT_DIR=l,i.resizeCanvasCls.rotStruc(l)})),$(document).on("click","."+e.pre+"mn6_rotate90",(function(t){let i,n=e.icn3d,l=$(this).attr("v").toLowerCase(),r=l.split(" ")[1];s.setLogCmd(l,!0),"x"==r?i=new THREE.Vector3(1,0,0):"y"==r?i=new THREE.Vector3(0,1,0):"z"==r&&(i=new THREE.Vector3(0,0,1));let o=.5*Math.PI;n.transformCls.setRotation(i,o)})),e.myEventCls.onIds("#"+e.pre+"mn6_cameraPers","click",(function(t){e.icn3d.setOptionCls.setOption("camera","perspective"),s.setLogCmd("set camera perspective",!0)})),e.myEventCls.onIds("#"+e.pre+"mn6_cameraOrth","click",(function(t){e.icn3d.setOptionCls.setOption("camera","orthographic"),s.setLogCmd("set camera orthographic",!0)})),e.myEventCls.onIds("#"+e.pre+"mn6_bkgdBlack","click",(function(t){e.icn3d.setStyleCls.setBackground("black")})),e.myEventCls.onIds("#"+e.pre+"tool_bkgd","click",(function(t){let s=e.icn3d;"black"==s.opts.background?s.setStyleCls.setBackground("white"):s.setStyleCls.setBackground("black")})),e.myEventCls.onIds("#"+e.pre+"mn6_bkgdGrey","click",(function(t){e.icn3d.setStyleCls.setBackground("grey")})),e.myEventCls.onIds(["#"+e.pre+"mn6_bkgdWhite","#"+e.pre+"tool_bkgdWhite"],"click",(function(t){e.icn3d.setStyleCls.setBackground("white")})),e.myEventCls.onIds("#"+e.pre+"mn6_bkgdTransparent","click",(function(t){e.icn3d.setStyleCls.setBackground("transparent")})),e.myEventCls.onIds("#"+e.pre+"mn6_showfogYes","click",(function(t){let i=e.icn3d;i.opts.fog="yes",i.fogCls.setFog(!0),i.drawCls.draw(),s.setLogCmd("set fog on",!0)})),e.myEventCls.onIds("#"+e.pre+"mn6_showfogNo","click",(function(t){let i=e.icn3d;i.opts.fog="no",i.fogCls.setFog(!0),i.drawCls.draw(),s.setLogCmd("set fog off",!0)})),e.myEventCls.onIds("#"+e.pre+"mn6_showslabYes","click",(function(t){e.icn3d.setOptionCls.setOption("slab","yes"),s.setLogCmd("set slab on",!0)})),e.myEventCls.onIds("#"+e.pre+"mn6_showslabNo","click",(function(t){e.icn3d.setOptionCls.setOption("slab","no"),s.setLogCmd("set slab off",!0)})),e.myEventCls.onIds("#"+e.pre+"mn6_showaxisYes","click",(function(t){e.icn3d.setOptionCls.setOption("axis","yes"),s.setLogCmd("set axis on",!0)})),e.myEventCls.onIds("#"+e.pre+"mn6_showaxisSel","click",(function(t){let i=e.icn3d;i.pc1=!0,i.axesCls.setPc1Axes(),s.setLogCmd("set pc1 axis",!0)})),e.myEventCls.onIds("#"+e.pre+"mn6_showaxisNo","click",(function(t){let i=e.icn3d;i.pc1=!1,i.axes=[],i.setOptionCls.setOption("axis","no"),s.setLogCmd("set axis off",!0)})),e.myEventCls.onIds("#"+e.pre+"mn6_symmetry","click",(async function(t){let s=e.icn3d;s.bAxisOnly=!1,await s.symdCls.retrieveSymmetry(Object.keys(s.structures)[0])})),e.myEventCls.onIds("#"+e.pre+"mn6_symd","click",(async function(t){let i=e.icn3d;i.bAxisOnly=!1,await i.symdCls.retrieveSymd(),i.bSymd=!0,s.setLogCmd("symd symmetry",!0)})),e.myEventCls.onIds("#"+e.pre+"mn6_clear_sym","click",(function(t){let i=e.icn3d;i.symdArray=[],i.drawCls.draw(),s.setLogCmd("clear symd symmetry",!0)})),e.myEventCls.onIds("#"+e.pre+"mn6_axes_only","click",(function(t){let i=e.icn3d;i.bAxisOnly=!0,i.drawCls.draw(),s.setLogCmd("show axis",!0)})),e.myEventCls.onIds("#"+e.pre+"mn6_area","click",(function(t){e.icn3d.analysisCls.calculateArea(),s.setLogCmd("area",!0)})),e.myEventCls.onIds("#"+e.pre+"applysymmetry","click",(function(t){let i=e.icn3d;i.bAxisOnly=!1;let n=$("#"+e.pre+"selectSymmetry").val();i.symmetrytitle="none"===n?void 0:n,i.drawCls.draw(),s.setLogCmd("symmetry "+n,!0)})),e.myEventCls.onIds("#"+e.pre+"clearsymmetry","click",(function(t){let i=e.icn3d;i.symmetrytitle=void 0,i.drawCls.draw(),s.setLogCmd("symmetry none",!0)})),e.myEventCls.onIds(["#"+e.pre+"mn6_hbondsYes","#"+e.pre+"hbondsYes"],"click",(function(t){let i=e.icn3d;s.SetChainsAdvancedMenu();let n=i.definedSetsCls.setAtomMenu(["protein"]);$("#"+e.pre+"atomsCustomHbond").length&&$("#"+e.pre+"atomsCustomHbond").html("  <option value='non-selected' selected>non-selected</option><option value='selected'>selected</option>"+n),$("#"+e.pre+"atomsCustomHbond2").length&&$("#"+e.pre+"atomsCustomHbond2").html("  <option value='selected' selected>selected</option>"+n),e.htmlCls.dialogCls.openDlg("dl_hbonds","Hydrogen bonds/interactions between two sets of atoms"),i.bHbondCalc=!1,$("#"+e.pre+"atomsCustomHbond").resizable(),$("#"+e.pre+"atomsCustomHbond2").resizable()})),e.myEventCls.onIds(["#"+e.pre+"mn6_contactmap"],"click",(function(t){e.icn3d,e.htmlCls.dialogCls.openDlg("dl_contact","Set contact map")})),e.myEventCls.onIds(["#"+e.pre+"mn6_DSSP"],"click",(async function(t){let i=e.icn3d;s.setLogCmd("set dssp sse",!0),await i.pdbParserCls.applyCommandDssp(),i.bResetAnno=!0,i.bAnnoShown&&(await i.showAnnoCls.showAnnotations(),i.annotationCls.resetAnnoTabAll())})),e.myEventCls.onIds("#"+e.pre+"mn6_hbondsNo","click",(function(t){let s=e.icn3d;s.showInterCls.hideHbondsContacts(),s.drawCls.draw()})),e.myEventCls.onIds("#"+e.pre+"mn1_stabilizerYes","click",(function(t){let i=e.icn3d;i.threeDPrintCls.addStabilizer(),i.threeDPrintCls.prepareFor3Dprint(),s.setLogCmd("stabilizer",!0)})),e.myEventCls.onIds("#"+e.pre+"mn1_stabilizerNo","click",(function(t){let i=e.icn3d;s.setLogCmd("set stabilizer off",!0),i.threeDPrintCls.hideStabilizer(),i.drawCls.draw()})),e.myEventCls.onIds("#"+e.pre+"mn1_stabilizerOne","click",(function(t){let s=e.icn3d;e.htmlCls.dialogCls.openDlg("dl_stabilizer","Add One Stabilizer"),s.pk=1,s.opts.pk="atom",s.pickpair=!0,s.pAtomNum=0})),e.myEventCls.onIds("#"+e.pre+"mn1_stabilizerRmOne","click",(function(t){let s=e.icn3d;e.htmlCls.dialogCls.openDlg("dl_stabilizer_rm","Remove One Stabilizer"),s.pk=1,s.opts.pk="atom",s.pickpair=!0,s.pAtomNum=0})),e.myEventCls.onIds("#"+e.pre+"mn1_thicknessSet","click",(function(t){e.icn3d,e.htmlCls.dialogCls.openDlg("dl_thickness","Set Thickness for 3D Printing")})),e.myEventCls.onIds("#"+e.pre+"mn3_setThickness","click",(function(t){e.icn3d,e.htmlCls.dialogCls.openDlg("dl_thickness2","Style Preferences")})),e.myEventCls.onIds("#"+e.pre+"mn6_ssbondsYes","click",(function(t){let i=e.icn3d;s.setLogCmd("disulfide bonds",!0),i.showInterCls.showSsbonds()})),e.myEventCls.onIds("#"+e.pre+"mn6_ssbondsExport","click",(function(t){e.icn3d.viewInterPairsCls.exportSsbondPairs(),s.setLogCmd("export disulfide bond pairs",!1)})),e.myEventCls.onIds("#"+e.pre+"mn6_ssbondsNo","click",(function(t){let i=e.icn3d;i.opts.ssbonds="no";s.setLogCmd("set disulfide bonds off",!0),i.lines.ssbond=[],i.setOptionCls.setStyle("sidec","nothing")})),e.myEventCls.onIds("#"+e.pre+"mn6_clbondsYes","click",(function(t){let i=e.icn3d;s.setLogCmd("cross linkage",!0),i.showInterCls.showClbonds()})),e.myEventCls.onIds("#"+e.pre+"mn6_clbondsExport","click",(function(t){e.icn3d.viewInterPairsCls.exportClbondPairs(),s.setLogCmd("export cross linkage pairs",!1)})),e.myEventCls.onIds("#"+e.pre+"mn6_clbondsNo","click",(function(t){let i=e.icn3d;i.opts.clbonds="no";s.setLogCmd("set cross linkage off",!0),i.lines.clbond=[],i.setOptionCls.setStyle("sidec","nothing")})),$("#"+e.pre+"newvs2").on("submit",(function(){let s=t.saveFileCls.getAtomPDB(t.hAtoms,void 0,void 0,void 0,void 0,void 0,void 0,!0);return $("#"+e.pre+"pdbstr").val(s),!0})),$("#"+e.pre+"fssubmit").on("click",(function(){let e=t.saveFileCls.getAtomPDB(t.hAtoms),s=window.open("","_blank");s.document.body.innerHTML="<!doctype html>\n<head>\n<title>Loading Foldseek</title>\n<style>\n  body {\n    background-color: #121212;\n    color: #fff;\n    font-family: system-ui, -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, 'Open Sans', 'Helvetica Neue', sans-serif;\n    height: 100vh;\n    display: flex;\n    flex-direction: column;\n    flex-wrap: wrap;\n    justify-content: center;\n    align-items: center;\n  }\n  .loader {\n    display: block;\n    width: 80px;\n    height: 80px;\n  }\n  .loader:after {\n    content: \" \";\n    display: block;\n    width: 64px;\n    height: 64px;\n    margin: 8px;\n    border-radius: 50%;\n    border: 6px solid #fff;\n    border-color: #fff transparent #fff transparent;\n    animation: loader 1.2s linear infinite;\n  }\n  @keyframes loader {\n    0% {\n      transform: rotate(0deg);\n    }\n    100% {\n      transform: rotate(360deg);\n    }\n  }\n</style>\n</head>\n<body>\n<div>Foldseek is loading...</div><div class=\"loader\"></div>\n</body>",$.ajax({url:"https://search.foldseek.com/api/ticket",type:"POST",data:{q:e,database:["afdb50","afdb-swissprot","gmgcl_id","pdb100","afdb-proteome","mgnify_esm30"],mode:"3diaa"},dataType:"text",success:function(e){s.location="https://search.foldseek.com/queue/"+JSON.parse(e).id},error:function(e,t,s){console.log("Error in submitting data to Foldseek...")}})})),e.myEventCls.onIds("#"+e.pre+"jn_copy","click",(function(t){e.icn3d;let s=$("#"+e.pre+"jn_commands").val();navigator.clipboard.writeText(s)}))}setLogCmd(e,t,s){var i=this.icn3dui,n=i.icn3d;if(""===e.trim())return!1;let l=e.indexOf("|||");-1!==l&&(e=e.substr(0,l));let r={};if(n.quaternion||(n._zoomFactor=1,n.mouseChange=new THREE.Vector2(0,0),n.quaternion=new THREE.Quaternion(0,0,0,1)),r.factor=n._zoomFactor,r.mouseChange=n.mouseChange,r.quaternion={},r.quaternion._x=parseFloat(n.quaternion._x).toPrecision(5),r.quaternion._y=parseFloat(n.quaternion._y).toPrecision(5),r.quaternion._z=parseFloat(n.quaternion._z).toPrecision(5),r.quaternion._w=parseFloat(n.quaternion._w).toPrecision(5),t&&n.bAddCommands)if(n.STATENUMBER<n.commands.length){let t=n.commands[n.STATENUMBER-1],s=t.indexOf("|||");-1!=s&&e!==t.substr(0,s)&&(n.commands=n.commands.slice(0,n.STATENUMBER),n.commands.push(e+"|||"+n.transformCls.getTransformationStr(r)),n.optsHistory.push(i.hashUtilsCls.cloneHash(n.opts)),n.optsHistory[n.optsHistory.length-1].hlatomcount=Object.keys(n.hAtoms).length,i.utilsCls.isSessionStorageSupported()&&n.setStyleCls.saveCommandsToSession(),n.STATENUMBER=n.commands.length)}else n.commands.push(e+"|||"+n.transformCls.getTransformationStr(r)),n.optsHistory.push(i.hashUtilsCls.cloneHash(n.opts)),void 0!==n.hAtoms&&(n.optsHistory[n.optsHistory.length-1].hlatomcount=Object.keys(n.hAtoms).length),i.utilsCls.isSessionStorageSupported()&&n.setStyleCls.saveCommandsToSession(),n.STATENUMBER=n.commands.length;if((n.bAddLogs||s)&&i.cfg.showcommand){let s=t?e:"[comment] "+e;n.logs.push(s),$("#"+i.pre+"logtext").val("> "+n.logs.join("\n> ")+"\n> "),$("#"+i.pre+"logtext")[0]&&$("#"+i.pre+"logtext").scrollTop($("#"+i.pre+"logtext")[0].scrollHeight)}n.setStyleCls.adjustIcon()}}class d{constructor(e){this.icn3dui=e}getLink(e,t,s,i){return this.icn3dui.htmlCls.setHtmlCls.getLink(e,t,s,i)}getMenuText(e,t,s,i,n){return this.icn3dui.htmlCls.setHtmlCls.getMenuText(e,t,s,i,n)}getMenuUrl(e,t,s,i,n){return this.icn3dui.htmlCls.setHtmlCls.getMenuUrl(e,t,s,i,n)}getMenuSep(){return this.icn3dui.htmlCls.setHtmlCls.getMenuSep()}getLinkWrapper(e,t,s,i,n,l){let r=this.icn3dui;return r.icn3d,r.htmlCls.setHtmlCls.getLinkWrapper(e,t,s,i,n,l)}getLinkWrapper2(e,t,s,i,n){let l=this.icn3dui;return l.icn3d,l.htmlCls.setHtmlCls.getLinkWrapper2(e,t,s,i,n)}getRadio(e,t,s,i,n,l){return this.icn3dui.htmlCls.setHtmlCls.getRadio(e,t,s,i,n,l)}getRadClr(e,t,s,i,n,l,r){return this.icn3dui.htmlCls.setHtmlCls.getRadioColor(e,t,s,i,n,l,r)}resetMenu(e){let t=this.icn3dui;e&&"simple"!=e?"all"==e?(t.htmlCls.shownMenus=t.hashUtilsCls.cloneHash(t.htmlCls.allMenus),t.htmlCls.clickMenuCls.applyShownMenus()):"custom"==e&&(t.htmlCls.dialogCls.openDlg("dl_menupref","Select Menus"),t.htmlCls.clickMenuCls.getHiddenMenusFromCache(),t.htmlCls.clickMenuCls.displayShownMenus()):(t.htmlCls.shownMenus=t.hashUtilsCls.cloneHash(t.htmlCls.simpleMenus),t.htmlCls.clickMenuCls.applyShownMenus())}setMenuMode(e){let t=this.icn3dui,s=e?"; padding-left:6px; background-color:#eee":"; margin:3px; background-color:white",i=e?"; font-size:14px!important":"",n=t.htmlCls.setHtmlCls.getCookie("menumode"),l='<div class="icn3d-text" style="color:#f8b84e; font-weight:bold'+s+'">';return l+='<select name="menumode" id="'+t.pre+'menumode" class="icn3d-text" style="color:#f8b84e; font-weight:bold; border:0px'+i+'">',l+="simple"!=n&&n?'<option value="simple">Simple</option>':'<option value="simple" selected>Simple</option>',l+="all"==n?'<option value="all" selected>All</option>':'<option value="all">All</option>',l+="custom"==n?'<option value="custom" selected>Custom</option>':'<option value="custom">Custom</option>',l+="</select>",l+=e?'<br><span style="font-size:12px">&nbsp;Menus</span>':"&nbsp;Menus",l+="</div>",l}setTopMenusHtml(e,t,s){let i=this.icn3dui;if(i.bNode)return"";let n="black"==i.htmlCls.opts.background?i.htmlCls.GREYD:"black",l="";l+="<div style='position:relative;'>",l+=i.htmlCls.divStr+"popup' class='icn3d-text icn3d-popup'></div>",l+=this.setReplayHtml(),l+="\x3c!--https://forum.jquery.com/topic/looking-for-a-jquery-horizontal-menu-bar--\x3e",l+=i.htmlCls.divStr+"mnlist' style='position:absolute; z-index:999; float:left; display:table-row; margin-top: -2px;'>",l+="<table border='0' cellpadding='0' cellspacing='0' width='100'><tr>";let r='<td valign="top">';if(l+=r+this.setMenu1()+"</td>",l+=r+this.setMenu2()+"</td>",l+=r+this.setMenu2b()+"</td>",l+=r+this.setMenu3()+"</td>",l+=r+this.setMenu4()+"</td>",l+=r+this.setMenu5()+"</td>",l+=r+this.setMenu6()+"</td>",l+=r+"<div style='position:relative; margin-left:6px;'>"+t,l+="<div class='icn3d-commandTitle' style='min-width:40px; margin-top: 3px; white-space: nowrap;'>"+s,l+=r+'<div class="icn3d-commandTitle" style="white-space:nowrap; margin-top:10px; border-left:solid 1px #888888"><span id="'+i.pre+'selection_expand" class="icn3d-expand icn3d-link" style="display:block;" title="Expand">'+i.htmlCls.space2+'Toolbar <span class="ui-icon ui-icon-plus" style="width:15px"></span>'+i.htmlCls.space2+'</span><span id="'+i.pre+'selection_shrink" class="icn3d-shrink icn3d-link" style="display:none;" title="Shrink">'+i.htmlCls.space2+'Toolbar <span class="ui-icon ui-icon-minus" style="width:15px"></span>'+i.htmlCls.space2+"</span></div></td>",l+=r+'<div class="icn3d-commandTitle" style="white-space:nowrap; margin-top:8px; border-left:solid 1px #888888">'+i.htmlCls.space2+'<input type="text" id="'+i.pre+'search_seq" size="10" placeholder="one-letter seq."> <button style="white-space:nowrap;" id="'+i.pre+'search_seq_button">Search</button> <a style="text-decoration: none;" href="'+i.htmlCls.baseUrl+'icn3d/icn3d.html#selectb" target="_blank" title="Specification tips">?</a></div></td>',l+="</tr>",l+="</table>",l+="</div>",l+=this.setTools(),l+=i.htmlCls.divStr+"title' class='icn3d-commandTitle' style='font-size:1.2em; font-weight:normal; position:absolute; z-index:1; float:left; display:table-row; margin: 85px 0px 0px 5px; color:"+n+"; width:"+i.htmlCls.WIDTH+"px'></div>",l+=i.htmlCls.divStr+"viewer' style='position:relative; width:100%; height:100%; background-color: "+i.htmlCls.GREYD+";'>",l+=i.htmlCls.divStr+"mnLogSection'>",l+="<div style='height: "+i.htmlCls.MENU_HEIGHT+"px;'></div>",l+=" </div>",void 0===i.cfg.mmtfid){let e="top:180px; font-size: 1.8em;";l+=i.htmlCls.divStr+"wait' style='position:absolute; left:50px; "+e+" color: #444444;'>Loading data...</div>"}l+="<canvas id='"+i.pre+"canvas' style='width:100%; height: 100%; background-color: #FFF;'>Your browser does not support WebGL.</canvas>",(void 0===i.cfg.showcommand||i.cfg.showcommand)&&(l+=this.setLogWindow()),l+="</div>",l+="</div>",l+=i.htmlCls.setDialogCls.setDialogs(),l+=i.htmlCls.setDialogCls.setCustomDialogs(),$("#"+e).html(l),$("accordion").accordion({collapsible:!0,active:!1,heightStyle:"content"}),$("accordion div").removeClass("ui-accordion-content ui-corner-all ui-corner-bottom ui-widget-content"),$(".icn3d-mn-item").menu({position:{my:"left top",at:"right top"}}),$(".icn3d-mn-item").hover((function(){}),(function(){$("accordion").accordion("option","active","none")})),$("#"+i.pre+"accordion1").hover((function(){$("#"+i.pre+"accordion1 div").css("display","block")}),(function(){$("#"+i.pre+"accordion1 div").css("display","none")})),$("#"+i.pre+"accordion2").hover((function(){$("#"+i.pre+"accordion2 div").css("display","block")}),(function(){$("#"+i.pre+"accordion2 div").css("display","none")})),$("#"+i.pre+"accordion2b").hover((function(){$("#"+i.pre+"accordion2b div").css("display","block")}),(function(){$("#"+i.pre+"accordion2b div").css("display","none")})),$("#"+i.pre+"accordion3").hover((function(){$("#"+i.pre+"accordion3 div").css("display","block")}),(function(){$("#"+i.pre+"accordion3 div").css("display","none")})),$("#"+i.pre+"accordion4").hover((function(){$("#"+i.pre+"accordion4 div").css("display","block")}),(function(){$("#"+i.pre+"accordion4 div").css("display","none")})),$("#"+i.pre+"accordion5").hover((function(){$("#"+i.pre+"accordion5 div").css("display","block")}),(function(){$("#"+i.pre+"accordion5 div").css("display","none")})),$("#"+i.pre+"accordion6").hover((function(){$("#"+i.pre+"accordion6 div").css("display","block")}),(function(){$("#"+i.pre+"accordion6 div").css("display","none")}))}setTopMenusHtmlMobile(e,t,s){let i=this.icn3dui;if(i.bNode)return"";let n="black"==i.htmlCls.opts.background?i.htmlCls.GREYD:"black",l="";if(l+="<div style='position:relative;'>",l+=i.htmlCls.divStr+"popup' class='icn3d-text icn3d-popup'></div>",l+=this.setReplayHtml(),!i.utilsCls.isMobile()){let e=i.htmlCls.WIDTH-40+5;l+=i.htmlCls.buttonStr+"fullscreen' style='position:absolute; z-index:1999; display:block; padding:0px; margin: 12px 0px 0px "+e+"px; width:30px; height:34px; border-radius:4px; border:none; background-color:#f6f6f6;' title='Full screen'>",l+="<svg fill='#1c94c4' viewBox='0 0 24 24' width='24' height='24'>",l+="<path d='M0 0h24v24H0z' fill='none'></path>",l+="<path d='M7 14H5v5h5v-2H7v-3zm-2-4h2V7h3V5H5v5zm12 7h-3v2h5v-5h-2v3zM14 5v2h3v3h2V5h-5z'></path>",l+="</svg>",l+="</button>"}l+="\x3c!--https://forum.jquery.com/topic/looking-for-a-jquery-horizontal-menu-bar--\x3e",l+=i.htmlCls.divStr+"mnlist' style='position:absolute; z-index:999; float:left; display:block; margin: 5px 0px 0px 5px;'>",l+="<div>",l+="<accordion id='"+i.pre+"accordion0' class='icn3d-accordion'>",i.cfg.notebook?l+="<h3 style='width:20px; height:24px; position:relative; padding: 0'><span style='position:absolute; left:3px; top:4px;'>&#9776;</span></h3>":l+="<h3 style='width:30px; height:34px; position:relative; padding: 0; margin-top:7px!important; background-color:#f6f6f6;'><span style='position:absolute; left:7px; top:8px;'>&#9776;</span></h3>",l+="<div>";let r="<li><span class='icn3d-menu-color'";if(l+="<ul class='icn3d-mn-item'>",l+=r+">File</span>",l+=this.setMenu1_base(),l+=r+">Select</span>",l+=this.setMenu2_base(),l+=r+">View</span>",l+=this.setMenu2b_base(),l+=r+" id='"+i.pre+"style'>Style</span>",l+=this.setMenu3_base(),l+=r+" id='"+i.pre+"color'>Color</span>",l+=this.setMenu4_base(),l+=r+">Analysis</span>",l+=this.setMenu5_base(),l+=r+">Help</span>",l+=this.setMenu6_base(),l+="<li><div style='position:relative; margin-top:-6px;'>"+t,l+="<div class='icn3d-commandTitle' style='margin-top: 3px; white-space: nowrap;'>"+s,l+="<li><span id='"+i.pre+"alternate2' class='icn3d-menu-color' title='Alternate the structures'>Alternate</span>",l+="</ul>",l+="</div>",l+="</accordion>",l+="</div>",l+="</div>",l+=i.htmlCls.divStr+"title' class='icn3d-commandTitle' style='font-size:1.2em; font-weight:normal; position:absolute; z-index:1; float:left; display:block; margin: 12px 0px 0px 40px; color:"+n+"; width:"+(i.htmlCls.WIDTH-40).toString()+"px'></div>",l+=i.htmlCls.divStr+"viewer' style='position:relative; width:100%; height:100%; background-color: "+i.htmlCls.GREYD+";'>",l+=i.htmlCls.divStr+"mnLogSection'>",l+="<div style='height: "+i.htmlCls.MENU_HEIGHT+"px;'></div>",l+="</div>",void 0===i.cfg.mmtfid){let e="top:180px; font-size: 1.8em;";l+=i.htmlCls.divStr+"wait' style='position:absolute; left:50px; "+e+" color: #444444;'>Loading data...</div>"}l+="<canvas id='"+i.pre+"canvas' style='width:100%; height: 100%; background-color: #FFF;'>Your browser does not support WebGL.</canvas>",(void 0===i.cfg.showcommand||i.cfg.showcommand)&&(l+=this.setLogWindow()),l+="</div>",l+="</div>",l+=i.htmlCls.setDialogCls.setDialogs(),l+=i.htmlCls.setDialogCls.setCustomDialogs(),$("#"+e).html(l),$("accordion").accordion({collapsible:!0,active:!1,heightStyle:"content"}),$("accordion div").removeClass("ui-accordion-content ui-corner-all ui-corner-bottom ui-widget-content"),$(".icn3d-mn-item").menu({position:{my:"left top",at:"right top"}}),$(".icn3d-mn-item").hover((function(){}),(function(){$("accordion").accordion("option","active","none")})),$("#"+i.pre+"accordion0").hover((function(){$("#"+i.pre+"accordion0 div").css("display","block")}),(function(){$("#"+i.pre+"accordion0 div").css("display","none")}))}setReplayHtml(e){let t=this.icn3dui;if(t.bNode)return"";let s="";return s+=t.htmlCls.divStr+"replay' style='display:none; position:absolute; z-index:9999; top:"+parseInt(t.htmlCls.HEIGHT-100).toString()+"px; left:20px;'>",s+="<div title='Click to replay one step'><svg style='cursor:pointer;' fill='#f8b84e' viewBox='0 0 60 60' width='40' height='40'>",s+='<circle style="fill:#f8b84e;" cx="29" cy="29" r="29"/>',s+="<g>",s+='<polygon style="fill:#FFFFFF;" points="44,29 22,44 22,29.273 22,14"/>',s+='<path style="fill:#FFFFFF;" d="M22,45c-0.16,0-0.321-0.038-0.467-0.116C21.205,44.711,21,44.371,21,44V14c0-0.371,0.205-0.711,0.533-0.884c0.328-0.174,0.724-0.15,1.031,0.058l22,15C44.836,28.36,45,28.669,45,29s-0.164,0.64-0.437,0.826l-22,15C22.394,44.941,22.197,45,22,45z M23,15.893v26.215L42.225,29L23,15.893z"/>',s+="</g>",s+="</svg></div>",s+=t.htmlCls.divStr+"replay_menu' style='background-color:#DDDDDD; padding:3px; font-weight:bold;'></div>",s+=t.htmlCls.divStr+"replay_cmd' style='background-color:#DDDDDD; padding:3px; max-width:250px'></div>",s+="</div>",s}setTools(){let e=this.icn3dui;if(e.bNode)return"";let t="";return t+=e.htmlCls.divStr+"selection' style='display:none;'><div style='position:absolute; z-index:555; float:left; display:table-row; margin: 32px 0px 0px 0px;'>",t+="<table style='margin-top: 3px; width:770px; background-color:#EEE;'>",t+=this.setTools_base(),t+="</table>",t+="</div></div>",t}setButton(e,t,s,i,n){let l=this.icn3dui;return l.bNode?"":(n=void 0!==n?"color:"+n:"","<div style='margin:3px 0px 0px 10px;'><button style='-webkit-appearance:"+e+"; height:36px;"+(l.utilsCls.isMobile()?" background-color:#DDDDDD;":"")+"' id='"+l.pre+t+"'><span style='white-space:nowrap;"+n+"' class='icn3d-commandTitle' title='"+s+"'>"+i+"</span></button></div>")}setIcon(e,t,s,i,n,l,r){let o=this.icn3dui;if(o.bNode)return"";let a,d=r?"color:#f8b84e; ":"color:#1c94c4; ",c=" background-color:#EEE; ",h="text"==e?"":"cursor:pointer;";return a=l?'<div id="'+o.pre+t+'" title="'+s+'" style="font-family: Arial, Helvetica, sans-serif; font-size:16px; width:16px; height:16px;'+d+c+h+'">'+i+"</div>":'<i id="'+o.pre+t+'" class="las la-'+i+'" title="'+s+'" style="width:16px; height:16px;'+d+c+h+'"></i>',"link"==e?'<a href="'+n+'" target="_blank">'+a+"</a>":a}setTools_base(){if(this.icn3dui.bNode)return"";let e="<tr valign='center'>",t="regular",s="<td valign='top' align='center'>",i="<td valign='top' align='center' style='border-left: solid 1px #888888'>";return e+=s+this.setIcon(t,"tool_mmdbafid","Input PDB/MMDB/AlphaFold IDs","id",void 0,!0)+"</td>",e+=s+this.setIcon(t,"tool_pdbfile","Input PDB Files (appendable)","file-alt")+"</td>",e+=s+this.setIcon(t,"tool_sharelink","Get Share Link","link")+"</td>",e+=s+this.setIcon(t,"saveimage","Save iCn3D PNG Image","camera")+"</td>",e+=i+this.setIcon(t,"tool_definedsets","Defined Sets","object-group")+"</td>",e+=s+this.setIcon(t,"tool_aroundsphere","Select by Distance","dot-circle")+"</td>",e+=s+this.setIcon(t,"tool_saveselection","Save Selection as a Set","save")+"</td>",e+=s+this.setIcon(t,"toggleHighlight","Toggle Highlight","highlighter")+"</td>",e+=i+this.setIcon(t,"show_selected","View Selection","eye")+"</td>",e+=s+this.setIcon(t,"tool_selectedcenter","Zoom in Selection","search-plus")+"</td>",e+=s+this.setIcon(t,"alternate","Alternate the Structures by keying the letter 'a'","a",void 0,!0,!0)+"</td>",e+=s+this.setIcon(t,"tool_resetOrientation","Reset Orientation","undo-alt")+"</td>",e+=i+this.setIcon(t,"tool_proteinsRibbon","Style Ribbon for proteins","dna")+"</td>",e+=s+this.setIcon(t,"tool_proteinsSphere","Style Sphere for proteins","volleyball-ball")+"</td>",e+=s+this.setIcon(t,"tool_surfaceVDW","Show Van der Waals Surface","cloud")+"</td>",e+=s+this.setIcon(t,"tool_bkgd","Toggle Background Color","adjust")+"</td>",e+=i+this.setIcon(t,"tool_clrRainbowChain","Color Rainbow for Chains","rainbow")+"</td>",e+=s+this.setIcon(t,"tool_clrSSGreen","Color by Secondary Structures","ring")+"</td>",e+=s+this.setIcon(t,"tool_clrChain","Color by Chains","layer-group")+"</td>",e+=s+this.setIcon(t,"tool_clrAtom","Color by Atoms","atom")+"</td>",e+=i+this.setIcon(t,"tool_selectannotations","Sequences & Annotations","grip-lines")+"</td>",e+=s+this.setIcon(t,"hbondsYes","Interactions","users")+"</td>",e+=s+this.setIcon(t,"tool_delphi","DelPhi Potentials","cloud-meatball")+"</td>",e+=s+this.setIcon(t,"removeLabels","Remove Labels","remove-format")+"</td>",e+=i+this.setIcon("link","tool-gallery","Gallery","image","https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d.html#gallery")+"</td>",e+=s+this.setIcon("link","tool-video","Videos","file-video","https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d.html#videos")+"</td>",e+=s+this.setIcon("link","tool-github","iCn3D GitHub","code","https://github.com/ncbi/icn3d")+"</td>",e+=s+this.setIcon("link","tool-hints","Transform Hints","info-circle","https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d.html#useicn3d")+"</td>",e+="</tr>",e}setTheme(e){let t,s,i,n,l,r=this.icn3dui;if(r.bNode)return"";r.htmlCls.themecolor=e,"orange"==e?(t="#e78f08",s="#f6a828",i="ui-bg_gloss-wave_35_f6a828_500x100.png",n="ui-icons_ef8c08_256x240.png",l="#eb8f00"):"black"==e?(t="#333333",s="#333333",i="ui-bg_gloss-wave_25_333333_500x100.png",n="ui-icons_222222_256x240.png",l="#222222"):"blue"==e&&(t="#4297d7",s="#5c9ccc",i="ui-bg_gloss-wave_55_5c9ccc_500x100.png",n="ui-icons_228ef1_256x240.png",l="#444"),$(".ui-widget-header").css({border:"1px solid "+t,background:s+' url("https://www.ncbi.nlm.nih.gov/Structure/icn3d/lib/images/'+i+'") 50% 50% repeat-x',color:"#fff","font-weight":"bold"}),$(".ui-button .ui-icon").css({"background-image":"url(https://www.ncbi.nlm.nih.gov/Structure/icn3d/lib/images/"+n+")"}),$(".ui-state-active a, .ui-state-active a:link, .ui-state-active a:visited").css({color:l,"text-decoration":"none"})}setLogWindow(e,t){let s=this.icn3dui;if(s.bNode)return"";let i,n="",l=s.htmlCls.setHtmlCls.getCookie("cmdwindow");return""!=l?(i=void 0!==t?t:parseInt(l),1==i?(s.htmlCls.LOG_HEIGHT=180,s.htmlCls.CMD_HEIGHT=.8*s.htmlCls.LOG_HEIGHT,e||(n+=s.htmlCls.divStr+"cmdlog' style='float:left; margin-top: 5px; width: 100%;'>"),n+="<textarea id='"+s.pre+"logtext' rows='2' style='width: 100%; height: "+s.htmlCls.CMD_HEIGHT+"px;  margin: auto; padding: 5px; box-sizing: border-box; border: 4px inset orange; background-color: "+s.htmlCls.GREYD+";'></textarea>"):(s.htmlCls.LOG_HEIGHT=65,s.htmlCls.CMD_HEIGHT=.8*s.htmlCls.LOG_HEIGHT,e||(n+=s.htmlCls.divStr+"cmdlog' style='float:left; margin-top: 5px; width: 100%;'>"),n+="<textarea id='"+s.pre+"logtext' rows='2' style='width: 100%; height: "+s.htmlCls.CMD_HEIGHT+"px; padding: 0px; border: 0px; background-color: "+s.htmlCls.GREYD+";'></textarea>")):(i=0,s.htmlCls.LOG_HEIGHT=65,s.htmlCls.CMD_HEIGHT=.8*s.htmlCls.LOG_HEIGHT,e||(n+=s.htmlCls.divStr+"cmdlog' style='float:left; margin-top: 5px; width: 100%;'>"),n+="<textarea id='"+s.pre+"logtext' rows='2' style='width: 100%; height: "+s.htmlCls.CMD_HEIGHT+"px; padding: 0px; border: 0px; background-color: "+s.htmlCls.GREYD+";'></textarea>"),e||(n+="</div>"),e&&(s.htmlCls.clickMenuCls.setLogCmd("set cmdwindow "+i,!0),$("#"+s.pre+"cmdlog").html(n)),n}setMenu1(){let e=this.icn3dui;if(e.bNode)return"";let t="";return t+="<div class='icn3d-menu'>",t+="<accordion id='"+e.pre+"accordion1' class='icn3d-accordion'>",t+="<h3>File</h3>",t+="<div>",t+=this.setMenu1_base(),t+="</div>",t+="</accordion>",t+="</div>",t}setMenu1_base(){let e=this.icn3dui;if(e.bNode)return"";let t="";return t+="<ul class='icn3d-mn-item'>",t+=this.getMenuText("mn1_searchgrooup","Search Structure "+e.htmlCls.wifiStr,void 0,1,1),t+="<ul>",t+=this.getMenuUrl("mn1_searchstru","https://www.ncbi.nlm.nih.gov/structure","PDB Structures "+e.htmlCls.wifiStr,1,2),t+=this.getLink("mn1_proteinname","AlphaFold Structures "+e.htmlCls.wifiStr,1,2),t+=this.getMenuUrl("mn1_afdatabase","https://alphafold.ebi.ac.uk","AlphaFold UniProt Database "+e.htmlCls.wifiStr,void 0,2),t+="</ul>",t+="</li>",t+=this.getMenuText("mn1_searchsimilar","Search Similar"+e.htmlCls.wifiStr,void 0,void 0,1),t+="<ul>",t+=this.getLink("mn1_vastplus","NCBI VAST+ (PDB Complex)"+e.htmlCls.wifiStr,void 0,2),t+=this.getLink("mn1_vast","NCBI VAST (PDB Chain)"+e.htmlCls.wifiStr,void 0,2),t+=this.getLink("mn1_foldseek","Foldseek (PDB & AlphaFold)"+e.htmlCls.wifiStr,void 0,2),t+="</ul>",t+="</li>",t+=this.getMenuText("mn1_retrievebyid","Retrieve by ID",void 0,1,1),t+="<ul>",t+=this.getLink("mn1_mmdbafid","PDB/MMDB/AlphaFold IDs"+e.htmlCls.wifiStr,1,2),t+=this.getLink("mn1_mmdbid","NCBI MMDB ID (annotation) "+e.htmlCls.wifiStr,void 0,2),t+=this.getLink("mn1_mmtfid","RCSB BCIF/MMTF ID (fast) "+e.htmlCls.wifiStr,void 0,2),t+=this.getLink("mn1_pdbid","RCSB PDB ID "+e.htmlCls.wifiStr,void 0,2),t+=this.getMenuText("mn1_afwrap","AlphaFold Structures",void 0,void 0,2),t+="<ul>",t+=this.getLink("mn1_afid","UniProt ID "+e.htmlCls.wifiStr,void 0,3),t+=this.getLink("mn1_refseqid","NCBI Protein Accession "+e.htmlCls.wifiStr,void 0,3),t+="</ul>",t+=this.getLink("mn1_opmid","OPM PDB ID "+e.htmlCls.wifiStr,void 0,2),t+=this.getLink("mn1_mmcifid","RCSB mmCIF ID "+e.htmlCls.wifiStr,void 0,2),t+=this.getLink("mn1_cid","PubChem CID/Name/InchI "+e.htmlCls.wifiStr,1,2),t+=this.getLink("mn1_smiles","Chemical SMILES ",void 0,2),t+="</ul>",t+="</li>",t+=this.getMenuText("mn1_openfile","Open File",void 0,1,1),t+="<ul>",t+=this.getLink("mn1_pdbfile_app","PDB Files (appendable)",1,2),t+=this.getLink("mn1_mmciffile","mmCIF Files (appendable)",void 0,2),t+=this.getLink("mn1_mol2file","Mol2 File",void 0,2),t+=this.getLink("mn1_sdffile","SDF File",void 0,2),t+=this.getLink("mn1_xyzfile","XYZ File",void 0,2),t+=this.getLink("mn1_afmapfile","AlphaFold PAE File",void 0,2),t+=this.getLink("mn1_urlfile","URL(CORS) "+e.htmlCls.wifiStr,void 0,2),t+=this.getMenuSep(),t+=this.getLink("mn1_pngimage","iCn3D PNG (appendable)",1,2),t+=this.getLink("mn1_state","State/Script File",void 0,2),t+=this.getLink("mn1_fixedversion","Share Link in Archived Ver. "+e.htmlCls.wifiStr,void 0,2),t+=this.getLink("mn1_selection","Selection File",void 0,2),t+=this.getLink("mn1_collection","Collection File",void 0,2),t+=this.getMenuSep(),t+=this.getMenuText("mn1_dsn6wrap","Electron Density",void 0,void 0,2),t+="<ul>",t+=this.getLink("mn1_dsn6","Local File",void 0,3),t+=this.getLink("mn1_dsn6url","URL(CORS) "+e.htmlCls.wifiStr,void 0,3),t+="</ul>",t+="<li><br/></li>",t+="</ul>",t+="</li>",t+=this.getMenuText("mn1_fold","Predict by Seq.",void 0,void 0,1),t+="<ul>",t+=this.getLink("mn1_esmfold","ESMFold",void 0,2),t+=this.getLink("mn1_alphafold","AlphaFold2 via ColabFold"+e.htmlCls.wifiStr,void 0,2),t+="</ul>",t+=this.getMenuText("mn1_alignwrap","Align",void 0,1,1),t+="<ul>",t+=this.getMenuText("mn1_chainalignwrap","Multiple Chains",void 0,1,2),t+="<ul>",t+=this.getRadio("mn1_chainalignRad","mn1_chainalign","by Structure Alignment "+e.htmlCls.wifiStr,void 0,1,3),t+=this.getRadio("mn1_chainalignRad","mn1_chainalign2","by Sequence Alignment "+e.htmlCls.wifiStr,void 0,1,3),t+=this.getRadio("mn1_chainalignRad","mn1_chainalign3","Residue by Residue",void 0,void 0,3),t+="</ul>",t+="</li>",t+=this.getMenuText("mn1_aligntwostru","Protein Complexes",void 0,void 0,2),t+="<ul>",t+=this.getLink("mn1_align","Two PDB Structures "+e.htmlCls.wifiStr,void 0,3),t+=this.getLink("mn1_alignaf","Two AlphaFold Structures "+e.htmlCls.wifiStr,void 0,3),t+="</ul>",t+=this.getLink("mn1_blast_rep_id","Sequence to Structure",void 0,2),t+="</ul>",t+="</li>",t+=this.getMenuText("mn2_realignWrap","Realign Selection",void 0,void 0,1),t+="<ul>",t+=this.getMenuText("mn2_chainrealignwrap","Multiple Chains",void 0,void 0,2),t+="<ul>",t+=this.getRadio("mn2_realign","mn2_realignonstruct","by Structure Alignment "+e.htmlCls.wifiStr,void 0,void 0,3),t+=this.getRadio("mn2_realign","mn2_realignonseqalign","by Sequence Alignment "+e.htmlCls.wifiStr,void 0,void 0,3),t+=this.getRadio("mn2_realign","mn2_realignresbyres","Residue by Residue",void 0,void 0,3),t+="</ul>",t+=this.getLink("mn2_realigntwostru","Protein Complexes",void 0,2),t+="</ul>",t+="</li>",t+=this.getMenuText("mn1_3dpprint","3D Printing",void 0,1,1),t+="<ul>",void 0===e.cfg.cid?(t+=this.getLink("mn1_exportVrmlStab","WRL/VRML(Color, W/ Stab.)",1,2),t+=this.getLink("mn1_exportStlStab","STL(W/ Stabilizers)",1,2),t+=this.getMenuSep(),t+=this.getLink("mn1_exportVrml","WRL/VRML(Color)",void 0,2),t+=this.getLink("mn1_exportStl","STL",void 0,2),t+=this.getMenuSep(),t+=this.getLink("mn1_stabilizerYes","Add All Stabilizers",void 0,2),t+=this.getLink("mn1_stabilizerNo","Remove All Stabilizers",void 0,2),t+=this.getMenuSep(),t+=this.getLink("mn1_stabilizerOne","Add One Stabilizer",void 0,2),t+=this.getLink("mn1_stabilizerRmOne","Remove One Stabilizer",void 0,2),t+=this.getMenuSep(),t+=this.getLink("mn1_thicknessSet","Set Thickness",void 0,2)):(t+=this.getLink("mn1_exportVrml","VRML(Color)",1,2),t+=this.getLink("mn1_exportStl","STL",1,2)),t+="</ul>",t+="</li>",t+=this.getMenuText("mn1_savefile","Save File",void 0,1,1),t+="<ul>",t+=this.getMenuText("mn1_savepngimage","iCn3D PNG Image",void 0,1,2),t+="<ul>",t+=this.getLink("mn1_exportCanvas","Original Size & HTML",1,3),t+=this.getLink("mn1_exportCanvas1","Original Size",void 0,3),t+=this.getLink("mn1_exportCanvas2","2X Large",void 0,3),t+=this.getLink("mn1_exportCanvas4","4X Large",void 0,3),t+=this.getLink("mn1_exportCanvas8","8X Large",void 0,3),t+="</ul>",t+="</li>",t+=this.getLink("mn1_exportState","State File",void 0,2),t+=this.getLink("mn1_exportSelections","Selection File",void 0,2),t+=this.getLink("mn1_exportSelDetails","Selection Details",void 0,2),t+=this.getLink("mn1_exportCounts","Residue Counts",void 0,2),t+=this.getLink("mn1_exportPdbRes","PDB",1,2),t+=this.getLink("profixpdb","PDB with Missing Atoms",void 0,2),void 0===e.cfg.cid&&(t+=this.getLink("mn1_exportSecondary","Secondary Structure",void 0,2)),t+=this.getMenuText("m1_exportrefnum","Reference Numbers",void 0,void 0,2),t+="<ul>",t+=this.getLink("mn1_exportIgstrand","Ig Strand",void 0,3),t+=this.getLink("mn1_exportKabat","Kabat",void 0,3),t+=this.getLink("mn1_exportImgt","IMGT",void 0,3),t+="</ul>",t+="<li><br/></li>",t+="</ul>",t+="</li>",t+=this.getLink("mn1_sharelink","Share Link "+e.htmlCls.wifiStr,1,1),t+=this.getLink("mn1_replayon","Replay Each Step",void 0,1),t+=this.getMenuSep(),t+=this.getMenuText("mn1_menuwrap","Customize Menus",void 0,1,1),t+="<ul>",t+=this.getLink("mn1_menuall","All Menus",1,2),t+=this.getLink("mn1_menusimple","Simple Menus",1,2),t+=this.getMenuSep(),t+=this.getLink("mn1_menupref","Preferences",1,2),t+=this.getLink("mn1_menuloadpref","Load Preferences",1,2),t+="</ul>",t+="</li>",t+="<li><br/></li>",t+="</ul>",t}setMenu2(){let e=this.icn3dui;if(e.bNode)return"";let t="";return t+="<div class='icn3d-menu'>",t+="<accordion id='"+e.pre+"accordion2' class='icn3d-accordion'>",t+="<h3>Select</h3>",t+="<div>",t+=this.setMenu2_base(),t+="</div>",t+="</accordion>",t+="</div>",t}setMenu2_base(){let e=this.icn3dui;if(e.bNode)return"";let t="";return t+="<ul class='icn3d-mn-item'>",t+=this.getLink("mn2_definedsets","Defined Sets",1,1),t+=this.getLink("mn2_selectall","All",void 0,1),t+=this.getLink("mn2_selectdisplayed","Displayed Set",void 0,1),t+=this.getLink("mn2_aroundsphere","by Distance",1,1),t+=this.getMenuText("mn2_selbyprop","by Property",void 0,void 0,1),t+="<ul>",t+=this.getLink("mn2_propPos","Positive",void 0,2),t+=this.getLink("mn2_propNeg","Negative",void 0,2),t+=this.getLink("mn2_propHydro","Hydrophobic",void 0,2),t+=this.getLink("mn2_propPolar","Polar",void 0,2),t+=this.getLink("mn2_propBfactor","B-factor/pLDDT",void 0,2),t+=this.getLink("mn2_propSolAcc","Solvent Accessibility",void 0,2),t+="</ul>",t+="</li>",t+=this.getLink("mn2_selectcomplement","Inverse",void 0,1),t+=this.getLink("mn2_selectmainchains","Main Chains",void 0,1),t+=this.getLink("mn2_selectsidechains","Side Chains",void 0,1),t+=this.getLink("mn2_selectmainsidechains","Main & Side Chains",void 0,1),t+=this.getLink("mn2_command","Advanced",void 0,1),void 0===e.cfg.cid?(t+=this.getMenuText("mn2_selon3d","Select on 3D",void 0,1,1),t+="<ul>",t+='<li>"Alt"+Click: start selection</li>',t+='<li>"Ctrl"+Click: union selection</li>',t+='<li>"Shift"+Click: range Selection</li>',t+=this.getMenuSep(),t+=this.getRadio("mn2_pk","mn2_pkChain","Chain",void 0,1,2),void 0===e.cfg.mmdbid&&void 0===e.cfg.gi||(t+=this.getRadio("mn2_pk","mn2_pkDomain","3D Domain",void 0,void 0,2)),t+=this.getRadio("mn2_pk","mn2_pkStrand","Strand/Helix",void 0,void 0,2),t+=this.getRadio("mn2_pk","mn2_pkResidue","Residue",!0,1,2),t+=this.getRadio("mn2_pk","mn2_pkYes","Atom",void 0,1,2),t+=this.getRadio("mn2_pk","mn2_pkNo","None",void 0,void 0,2),t+="</ul>",t+="</li>"):e.utilsCls.isMobile()?t+="<li><span>Touch to pick</span></li>":t+='<li><span>Picking with<br>"Alt" + Click</span></li>',t+=this.getMenuSep(),t+=this.getLink("mn2_saveselection","Save Selection",1,1),t+=this.getLink("clearall","Clear Selection",void 0,1),t+=this.getLink("mn2_saveresidue","Save Res. in Sel.",1,1),t+=this.getMenuSep(),t+=this.getMenuText("mn2_hlcolor","Highlight Color",void 0,void 0,1),t+="<ul>",t+=this.getRadio("mn2_hl_clr","mn2_hl_clrYellow","Yellow",!0,void 0,2),t+=this.getRadio("mn2_hl_clr","mn2_hl_clrGreen","Green",void 0,void 0,2),t+=this.getRadio("mn2_hl_clr","mn2_hl_clrRed","Red",void 0,void 0,2),t+="</ul>",t+="</li>",t+=this.getMenuText("mn2_hlstyle","Highlight Style",void 0,void 0,1),t+="<ul>",t+=this.getRadio("mn2_hl_style","mn2_hl_styleOutline","Outline",!0,void 0,2),t+=this.getRadio("mn2_hl_style","mn2_hl_styleObject","3D Objects",void 0,void 0,2),t+="</ul>",t+="</li>",t+=this.getLink("toggleHighlight2","Toggle Highlight",1,1),t+="<li><br/></li>",t+="</ul>",t}setMenu2b(){let e=this.icn3dui;if(e.bNode)return"";let t="";return t+="<div class='icn3d-menu'>",t+="<accordion id='"+e.pre+"accordion2b' class='icn3d-accordion'>",t+="<h3>View</h3>",t+="<div>",t+=this.setMenu2b_base(),t+="</div>",t+="</accordion>",t+="</div>",t}setMenu2b_base(){let e=this.icn3dui;if(e.bNode)return"";let t="";return t+="<ul class='icn3d-mn-item'>",t+=this.getLink("mn2_show_selected","View Selection",1,1),t+=this.getLink("mn2_hide_selected","Hide Selection",1,1),t+=this.getLink("mn2_selectedcenter","Zoom in Selection",1,1),t+=this.getLink("mn6_center","Center Selection",1,1),t+=this.getLink("mn2_fullstru","View Full Structure"),t+=this.getLinkWrapper("mn2_alternate",'Alternate(Key "a")',"mn2_alternateWrap",void 0,1),void 0!==e.cfg.opmid?t+=this.getLinkWrapper("togglemem","Toggle Membrane","togglememli",void 0,1):void 0===e.cfg.cid&&(t+=this.getLinkWrapper("togglemem","Toggle Membrane","togglememli",void 0,1,!0)),void 0!==e.cfg.opmid&&(t+=this.getLinkWrapper("adjustmem","Adjust Membrane","adjustmemli",void 0,1),t+=this.getLinkWrapper("selectplane","Select between<br>Two X-Y Planes</span>","selectplaneli",void 0,1)),t+=this.getMenuSep(),t+=this.getMenuText("mn2_vrarhints","VR & AR Hints",void 0,1,1),t+="<ul>",t+=this.getMenuUrl("vrhint",e.htmlCls.baseUrl+"icn3d/icn3d.html#vr","VR: VR Headsets",1,2),t+=this.getMenuUrl("arhint",e.htmlCls.baseUrl+"icn3d/icn3d.html#ar","AR: Chrome in Android",1,2),t+="</ul>",t+="</li>",t+=this.getLink("mn6_sidebyside","Side by Side",1,1),t+=this.getMenuText("mn2_rotate","Rotate",void 0,1,1),t+="<ul>",t+=this.getMenuText("mn2_rotate90","Rotate 90&deg;",void 0,void 0,2),t+="<ul>",t+=this.getRadio("mn6_rotate90","mn6_rotatex","rotate x",void 0,void 0,2),t+=this.getRadio("mn6_rotate90","mn6_rotatey","rotate y",void 0,void 0,2),t+=this.getRadio("mn6_rotate90","mn6_rotatez","rotate z",void 0,void 0,2),t+="</ul>",t+="</li>",t+=this.getMenuText("mn2_rotateauto","Auto Rotation",void 0,1,2),t+="<ul>",t+=this.getRadio("mn6_rotate","mn6_rotateleft","Rotate Left",void 0,1,3),t+=this.getRadio("mn6_rotate","mn6_rotateright","Rotate Right",void 0,1,3),t+=this.getRadio("mn6_rotate","mn6_rotateup","Rotate Up",void 0,1,3),t+=this.getRadio("mn6_rotate","mn6_rotatedown","Rotate Down",void 0,1,3),t+="</ul>",t+="</li>",t+="</ul>",t+="</li>",t+=this.getLink("mn2_translate","Translate XYZ",void 0,1),t+=this.getLink("mn2_matrix","Rotate with Matrix",void 0,1),t+=this.getMenuText("mn2_camera","Camera",void 0,void 0,1),t+="<ul>",t+=this.getRadio("mn6_camera","mn6_cameraPers","Perspective",!0,void 0,2),t+=this.getRadio("mn6_camera","mn6_cameraOrth","Orthographic",void 0,void 0,2),t+="</ul>",t+="</li>",t+=this.getMenuText("mn2_fog","Fog for Selection",void 0,void 0,1),t+="<ul>",t+=this.getRadio("mn6_showfog","mn6_showfogYes","On",void 0,void 0,2),t+=this.getRadio("mn6_showfog","mn6_showfogNo","Off",!0,void 0,2),t+="</ul>",t+="</li>",t+=this.getMenuText("mn2_slab","Slab for Selection",void 0,void 0,1),t+="<ul>",t+=this.getRadio("mn6_showslab","mn6_showslabYes","On",void 0,void 0,2),t+=this.getRadio("mn6_showslab","mn6_showslabNo","Off",!0,void 0,2),t+="</ul>",t+="</li>",t+=this.getMenuText("mn2_axes","XYZ-axes",void 0,void 0,1),t+="<ul>",t+=this.getRadio("mn6_showaxis","mn6_showaxisYes","Original",void 0,void 0,2),t+=this.getRadio("mn6_showaxis","mn6_showaxisSel","Prin. Axes on Sel.",void 0,void 0,2),t+=this.getRadio("mn6_showaxis","mn6_showaxisNo","Hide",!0,void 0,2),t+="</ul>",t+="</li>",t+=this.getMenuSep(),t+=this.getMenuText("mn2_resetwrap","Reset",void 0,1,1),t+="<ul>",t+=this.getRadio("mn6_reset","reset","All",void 0,1,2),t+=this.getRadio("mn6_reset","mn6_resetOrientation","Orientation",void 0,1,2),t+="</ul>",t+="</li>",t+=this.getLink("mn6_back","Undo",void 0,1),t+=this.getLink("mn6_forward","Redo",void 0,1),t+=this.getLink("mn6_fullscreen","Full Screen",void 0,1),t+="<li><br/></li>",t+="</ul>",t}setMenu3(){let e=this.icn3dui;if(e.bNode)return"";let t="";return t+="<div class='icn3d-menu'>",t+="<accordion id='"+e.pre+"accordion3' class='icn3d-accordion'>",t+="<h3 id='"+e.pre+"style'>Style</h3>",t+="<div>",t+=this.setMenu3_base(),t+="</div>",t+="</accordion>",t+="</div>",t}setMenu3_base(){let e=this.icn3dui;if(e.bNode)return"";let t="";t+="<ul class='icn3d-mn-item'>",void 0===e.cfg.cid&&(t+=this.getMenuText("mn3_proteinwrap","Proteins",void 0,1,1),t+="<ul>",void 0!==e.cfg.align||void 0!==e.cfg.chainalign?t+=this.getRadio("mn3_proteins","mn3_proteinsRibbon","Ribbon",void 0,1,2):t+=this.getRadio("mn3_proteins","mn3_proteinsRibbon","Ribbon",!0,1,2),t+=this.getRadio("mn3_proteins","mn3_proteinsStrand","Strand",void 0,void 0,2),t+=this.getRadio("mn3_proteins","mn3_proteinsCylinder","Cylinder and Plate",void 0,void 0,2),t+=this.getRadio("mn3_proteins","mn3_proteinsSchematic","Schematic",void 0,1,2),void 0!==e.cfg.align||void 0!==e.cfg.chainalign?t+=this.getRadio("mn3_proteins","mn3_proteinsCalpha","C Alpha Trace",!0,1,2):t+=this.getRadio("mn3_proteins","mn3_proteinsCalpha","C Alpha Trace",void 0,1,2),t+=this.getRadio("mn3_proteins","mn3_proteinsBackbone","Backbone",void 0,void 0,2),t+=this.getRadio("mn3_proteins","mn3_proteinsBfactor","B-factor Tube",void 0,1,2),t+=this.getRadio("mn3_proteins","mn3_proteinsLines","Lines",void 0,1,2),t+=this.getRadio("mn3_proteins","mn3_proteinsStick","Stick",void 0,1,2),t+=this.getRadio("mn3_proteins","mn3_proteinsBallstick","Ball and Stick",void 0,1,2),t+=this.getRadio("mn3_proteins","mn3_proteinsSphere","Sphere",void 0,1,2),t+=this.getRadio("mn3_proteins","mn3_proteinsNo","Hide",void 0,1,2),t+="</ul>",t+="</li>",t+=this.getMenuText("mn3_sidecwrap","Side Chains",void 0,1,1),t+="<ul>",t+=this.getRadio("mn3_sidec","mn3_sidecLines","Lines",void 0,1,2),t+=this.getRadio("mn3_sidec","mn3_sidecStick","Stick",void 0,1,2),t+=this.getRadio("mn3_sidec","mn3_sidecBallstick","Ball and Stick",void 0,1,2),t+=this.getRadio("mn3_sidec","mn3_sidecSphere","Sphere",void 0,1,2),t+=this.getRadio("mn3_sidec","mn3_sidecNo","Hide",!0,1,2),t+="</ul>",t+="</li>",t+=this.getMenuText("mn3_nuclwrap","Nucleotides",void 0,1,1),t+="<ul>",t+=this.getRadio("mn3_nucl","mn3_nuclCartoon","Cartoon",!0,1,2),t+=this.getRadio("mn3_nucl","mn3_nuclPhos","O3' Trace",void 0,1,2),t+=this.getRadio("mn3_nucl","mn3_nuclBackbone","Backbone",void 0,void 0,2),t+=this.getRadio("mn3_nucl","mn3_nuclSchematic","Schematic",void 0,1,2),t+=this.getRadio("mn3_nucl","mn3_nuclLines","Lines",void 0,1,2),t+=this.getRadio("mn3_nucl","mn3_nuclStick","Stick",void 0,1,2),t+=this.getRadio("mn3_nucl","mn3_nuclBallstick","Ball and Stick",void 0,1,2),t+=this.getRadio("mn3_nucl","mn3_nuclSphere","Sphere",void 0,1,2),t+=this.getRadio("mn3_nucl","mn3_nuclNo","Hide",void 0,1,2),t+="</ul>",t+="</li>",t+=this.getMenuText("mn3_ntbasewrap","Nucl. Bases",void 0,1,1),t+="<ul>",t+=this.getRadio("mn3_ntbase","mn3_ntbaseLines","Lines",void 0,1,2),t+=this.getRadio("mn3_ntbase","mn3_ntbaseStick","Stick",void 0,1,2),t+=this.getRadio("mn3_ntbase","mn3_ntbaseBallstick","Ball and Stick",void 0,1,2),t+=this.getRadio("mn3_ntbase","mn3_ntbaseSphere","Sphere",void 0,1,2),t+=this.getRadio("mn3_ntbase","mn3_ntbaseNo","Hide",!0,1,2),t+="</ul>",t+="</li>"),t+=this.getMenuText("mn3_ligwrap","Chemicals",void 0,1,1),t+="<ul>",t+=this.getRadio("mn3_lig","mn3_ligLines","Lines",void 0,1,2),void 0===e.cfg.cid?(t+=this.getRadio("mn3_lig","mn3_ligStick","Stick",!0,1,2),t+=this.getRadio("mn3_lig","mn3_ligBallstick","Ball and Stick",void 0,1,2)):(t+=this.getRadio("mn3_lig","mn3_ligStick","Stick",void 0,1,2),t+=this.getRadio("mn3_lig","mn3_ligBallstick","BalHydrogensl and Stick",!0,1,2)),t+=this.getRadio("mn3_lig","mn3_ligSchematic","Schematic",void 0,1,2),t+=this.getRadio("mn3_lig","mn3_ligSphere","Sphere",void 0,1,2),t+=this.getRadio("mn3_lig","mn3_ligNo","Hide",void 0,1,2),t+="</ul>",t+="</li>",t+=this.getMenuText("mn3_hydrogenswrap","Hydrogens",void 0,1,1),t+="<ul>",t+=this.getRadio("mn3_hydrogens","mn3_hydrogensYes","Show",!0,1,2),t+=this.getRadio("mn3_hydrogens","mn3_hydrogensNo","Hide",void 0,1,2),t+="</ul>",t+="</li>",void 0===e.cfg.cid&&(t+=this.getMenuText("mn3_glycanwrap","Glycans",void 0,void 0,1),t+="<ul>",t+=this.getRadio("mn3_glycansCart","mn3_glycansCartYes","Show Cartoon",void 0,void 0,2),t+=this.getRadio("mn3_glycansCart","mn3_glycansCartNo","Hide Cartoon",!0,void 0,2),t+="</ul>",t+="</li>"),t+=this.getMenuText("mn3_ionswrap","Ions",void 0,1,1),t+="<ul>",t+=this.getRadio("mn3_ions","mn3_ionsSphere","Sphere",!0,1,2),t+=this.getRadio("mn3_ions","mn3_ionsDot","Dot",void 0,1,2),t+=this.getRadio("mn3_ions","mn3_ionsNo","Hide",void 0,1,2),t+="</ul>",t+="</li>",t+=this.getMenuText("mn3_waterwrap","Water",void 0,1,1),t+="<ul>",t+=this.getRadio("mn3_water","mn3_waterSphere","Sphere",void 0,1,2),t+=this.getRadio("mn3_water","mn3_waterDot","Dot",void 0,1,2),t+=this.getRadio("mn3_water","mn3_waterNo","Hide",!0,1,2),t+="</ul>",t+="</li>",void 0===e.cfg.cid&&(t+=this.getMenuText("mn2_clashedwrap","Clashed Residues",void 0,void 0,1),t+="<ul>",t+=this.getRadio("mn2_clashed","mn2_clashedYes","Show",!0,void 0,2),t+=this.getRadio("mn2_clashed","mn2_clashedNo","Hide",void 0,void 0,2),t+="</ul>",t+="</li>"),t+=this.getLink("mn3_setThickness","Preferences",void 0,1),t+=this.getMenuSep(),t+=this.getLink("mn3_styleSave","Save Style",void 0,2),t+=this.getLink("mn3_styleApplySave","Apply Saved Style",void 0,2),t+=this.getMenuSep(),t+=this.getMenuText("mn5_surfacewrap","Surface Type",void 0,1,1),t+="<ul>",t+=this.getRadio("mn5_surface","mn5_surfaceVDW","Van der Waals",void 0,1,2),t+=this.getRadio("mn5_surface","mn5_surfaceVDWContext","VDW with Context",void 0,void 0,2),t+=this.getRadio("mn5_surface","mn5_surfaceMolecular","Molecular Surface",void 0,1,2),t+=this.getRadio("mn5_surface","mn5_surfaceMolecularContext","MS with Context",void 0,void 0,2),t+=this.getRadio("mn5_surface","mn5_surfaceSAS","Solvent Accessible",void 0,1,2),t+=this.getRadio("mn5_surface","mn5_surfaceSASContext","SA with Context",void 0,void 0,2),t+="</ul>",t+="</li>",t+=this.getLink("mn5_surfaceNo","Remove Surface",1,1),t+=this.getMenuText("mn5_surfaceop","Surface Opacity",void 0,1,1),t+="<ul>",t+=this.getMenuText("mn5_surfaceopfast","Fast Transparency",void 0,1,2),t+="<ul>",t+=this.getRadio("mn5_opacity","mn5_opacity10","1.0",!0,1,3);for(let e=9;e>0;--e)t+=this.getRadio("mn5_opacity","mn5_opacity0"+e,"0."+e,1,3);t+="</ul>",t+="</li>",t+=this.getMenuText("mn5_surfaceopslow","Slow Transparency",void 0,void 0,2),t+="<ul>",t+=this.getRadio("mn5_opacityslow","mn5_opacityslow10","1.0",!0,void 0,3);for(let e=9;e>0;--e)t+=this.getRadio("mn5_opacityslow","mn5_opacityslow0"+e,"0."+e,void 0,void 0,3);return t+="</ul>",t+="</li>",t+="</ul>",t+=this.getMenuText("mn5_wireframewrap","Surface Wireframe",void 0,1,1),t+="<ul>",t+=this.getRadio("mn5_wireframe","mn5_wireframeYes","Yes",void 0,1,2),t+=this.getRadio("mn5_wireframe","mn5_wireframeNo","No",!0,1,2),t+="</ul>",t+="</li>",t+=this.getMenuSep(),t+=this.getLink("mn5_cartoonshape","Cartoon for a Set",void 0,1),t+=this.getLink("mn5_linebtwsets","Line btw. Two Sets",void 0,1),void 0===e.cfg.cid&&void 0===e.cfg.align&&void 0===e.cfg.chainalign&&void 0===e.cfg.mmdbaf&&(t+=this.getMenuSep(),t+=this.getLinkWrapper2("mn5_map","Electron Density","mapWrapper1",void 0,1),t+="<ul>",t+=this.getLink("mn5_elecmap2fofc","2Fo-Fc Map",void 0,2),t+=this.getLink("mn5_elecmapfofc","Fo-Fc Map",void 0,2),t+=this.getLinkWrapper("mn5_elecmapNo","Remove Map","mapWrapper2",void 0,2),t+="</ul>",t+="</li>",t+=this.getLinkWrapper2("mn5_map3","Map Wireframe","mapWrapper3",void 0,1),t+="<ul>",t+=this.getRadio("mn5_mapwireframe","mn5_mapwireframeYes","Yes",!0,void 0,2),t+=this.getRadio("mn5_mapwireframe","mn5_mapwireframeNo","No",void 0,void 0,2),t+="</ul>",t+="</li>",void 0===e.cfg.mmtfid&&(t+=this.getLinkWrapper("mn5_emmap","EM Density Map","emmapWrapper1",void 0,1),t+=this.getLinkWrapper("mn5_emmapNo","Remove EM Map","emmapWrapper2",void 0,1),t+=this.getLinkWrapper2("mn5_emmap3","EM Map Wireframe","emmapWrapper3",void 0,1),t+="<ul>",t+=this.getRadio("mn5_emmapwireframe","mn5_emmapwireframeYes","Yes",!0,void 0,2),t+=this.getRadio("mn5_emmapwireframe","mn5_emmapwireframeNo","No",void 0,void 0,2),t+="</ul>",t+="</li>")),t+=this.getMenuSep(),t+=this.getMenuText("mn6_bkgdwrap","Background",void 0,1,1),t+="<ul>",t+=this.getRadio("mn6_bkgd","mn6_bkgdTransparent","Transparent",void 0,1,2),t+=this.getRadio("mn6_bkgd","mn6_bkgdBlack","Black",!0,1,2),t+=this.getRadio("mn6_bkgd","mn6_bkgdGrey","Gray",void 0,1,2),t+=this.getRadio("mn6_bkgd","mn6_bkgdWhite","White",void 0,1,2),t+="</ul>",t+="</li>",t+=this.getMenuText("mn6_themewrap","Dialog Color",void 0,void 0,1),t+="<ul>",t+=this.getRadio("mn6_theme","mn6_themeBlue","Blue",!0,void 0,2),t+=this.getRadio("mn6_theme","mn6_themeOrange","Orange",void 0,void 0,2),t+=this.getRadio("mn6_theme","mn6_themeBlack","Black",void 0,void 0,2),t+="</ul>",t+="</li>",t+="<li><br/></li>",t+="</ul>",t}setMenu4(){let e=this.icn3dui;if(e.bNode)return"";let t="";return t+="<div class='icn3d-menu'>",t+="<accordion id='"+e.pre+"accordion4' class='icn3d-accordion'>",t+="<h3 id='"+e.pre+"color'>Color</h3>",t+="<div>",t+=this.setMenu4_base(),t+="</div>",t+="</accordion>",t+="</div>",t}setMenu4_base(){let e=this.icn3dui;if(e.bNode)return"";let t="";return t+="<ul class='icn3d-mn-item'>",t+=this.getMenuText("mn4_clrwrap","Unicolor","icn3d-menupd",1,1),t+="<ul>",t+=this.getMenuText("uniclrRedwrap","Red",void 0,1,2),t+="<ul>",t+=this.getRadClr("mn4_clr","uniclrRed1","Red","F00",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrRed2","Indian Red","CD5C5C",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrRed3","Light Coral","F08080",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrRed4","Salmon","FA8072",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrRed5","Dark Salmon","E9967A",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrRed6","Light Salmon","FFA07A",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrRed7","Crimson","DC143C",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrRed8","Fire Brick","B22222",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrRed9","Dark Red","8B0000",void 0,1,3),t+="</ul>",t+=this.getMenuText("uniclrPinkwrap","Pink",void 0,1,2),t+="<ul>",t+=this.getRadClr("mn4_clr","uniclrPink1","Pink","FFC0CB",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrPink2","Light Pink","FFB6C1",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrPink3","Hot Pink","FF69B4",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrPink4","Deep Pink","FF1493",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrPink5","Medium Violet Red","C71585",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrPink6","Pale Violet Red","DB7093",void 0,1,3),t+="</ul>",t+=this.getMenuText("uniclrOrangewrap","Orange",void 0,1,2),t+="<ul>",t+=this.getRadClr("mn4_clr","uniclrOran1","Orange","FFA500",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrOran2","Dark Orange","FF8C00",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrOran3","Orange Red","FF4500",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrOran4","Tomato","FF6347",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrOran5","Coral","FF7F50",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrOran6","Light Salmon","FFA07A",void 0,1,3),t+="</ul>",t+=this.getMenuText("uniclrYellowwrap","Yellow",void 0,1,2),t+="<ul>",t+=this.getRadClr("mn4_clr","uniclrYllw1","Yellow","FF0",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrYllw2","Gold","FFD700",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrYllw3","Light Yellow","FFFFE0",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrYllw4","Lemon Chiffon","FFFACD",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrYllw5","Light Golden Rod","FAFAD2",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrYllw6","Papaya Whip","FFEFD5",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrYllw7","Moccasin","FFE4B5",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrYllw8","Peach Puff","FFDAB9",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrYllw9","Pale Golden Rod","EEE8AA",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrYllw10","Khaki","F0E68C",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrYllw11","Dark Khaki","BDB76B",void 0,1,3),t+="</ul>",t+=this.getMenuText("uniclrMagentawrap","Magenta",void 0,1,2),t+="<ul>",t+=this.getRadClr("mn4_clr","uniclrMgnt1","Magenta","F0F",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrMgnt2","Orchid","DA70D6",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrMgnt3","Violet","EE82EE",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrMgnt4","Plum","DDA0DD",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrMgnt5","Thistle","D8BFD8",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrMgnt6","Lavender","E6E6FA",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrMgnt7","Medium Orchid","BA55D3",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrMgnt8","Medium Purple","9370DB",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrMgnt9","Rebecca Purple","663399",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrMgnt10","Blue Violet","8A2BE2",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrMgnt11","Dark Violet","9400D3",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrMgnt12","Dark Orchid","9932CC",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrMgnt13","Dark Magenta","8B008B",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrMgnt14","Purple","800080",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrMgnt15","Indigo","4B0082",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrMgnt16","Slat Blue","6A5ACD",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrMgnt17","Dark Slate Blue","483D8B",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrMgnt18","Medium Slat Blue","6A5ACD",void 0,1,3),t+="</ul>",t+=this.getMenuText("uniclrGreenwrap","Green",void 0,1,2),t+="<ul>",t+=this.getRadClr("mn4_clr","uniclrGrn1","Green","0F0",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrGrn2","Dark Green","006400",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrGrn3","Yellow Green","9ACD32",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrGrn4","Olive Drab","6B8E23",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrGrn5","Olive","808000",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrGrn6","Dark Olive Green","556B2F",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrGrn7","Medium Aquamarine","66CDAA",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrGrn8","Dark Sea Green","8FBC8B",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrGrn9","Lignt Sea Green","20B2AA",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrGrn10","Dark Cyan","008B8B",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrGrn11","Teal","008080",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrGrn12","Forest Green","228B22",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrGrn13","Sea Green","2E8B57",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrGrn14","Medium Sea Green","3CB371",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrGrn15","Spring Green","00FF7F",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrGrn16","Medium Spring","00FA9A",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrGrn17","Light Green","90EE90",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrGrn18","Pale Green","98FB98",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrGrn19","Lime Green","32CD32",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrGrn20","Lawn Green","7CFC00",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrGrn21","Chartreuse","7FFF00",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrGrn22","Green Yellow","ADFF2F",void 0,1,3),t+="</ul>",t+=this.getMenuText("uniclrCyanwrap","Cyan",void 0,1,2),t+="<ul>",t+=this.getRadClr("mn4_clr","uniclrCyan1","Cyan","0FF",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrCyan2","Light Cyan","E0FFFF",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrCyan3","Pale Turquoise","AFEEEE",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrCyan4","Aquamarine","7FFFD4",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrCyan5","Turquoise","40E0D0",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrCyan6","Medium Turquoise","48D1CC",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrCyan7","Dark Turquoise","00CED1",void 0,1,3),t+="</ul>",t+=this.getMenuText("uniclrBluewrap","Blue",void 0,1,2),t+="<ul>",t+=this.getRadClr("mn4_clr","uniclrBlue1","Blue","00F",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrBlue2","Medium Blue","0000CD",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrBlue3","Dark Blue","00008B",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrBlue4","Navy","000080",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrBlue5","Midnight Blue","191970",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrBlue6","Royal Blue","4169E1",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrBlue7","Medium Slate Blue","7B68EE",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrBlue8","Corn Flower Blue","6495ED",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrBlue9","Dodger Blue","1E90FF",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrBlue10","Deep Sky Blue","00BFFF",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrBlue11","Light Sky Blue","87CEFA",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrBlue12","Sky Blue","87CEEB",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrBlue13","Light Blue","ADD8E6",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrBlue14","Powder Blue","B0E0E6",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrBlue15","Light Steel Blue","B0C4DE",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrBlue16","Steel Blue","4682B4",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrBlue17","Cadet Blue","5F9EA0",void 0,1,3),t+="</ul>",t+=this.getMenuText("uniclrBrownwrap","Brown",void 0,1,2),t+="<ul>",t+=this.getRadClr("mn4_clr","uniclrBrown1","Brown","A52A2A",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrBrown2","Maroon","800000",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrBrown3","Sienna","A0522D",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrBrown4","Saddle Brown","8B4513",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrBrown5","Chocolate","D2691E",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrBrown6","Peru","CD853F",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrBrown7","Dark Golden Rod","B8860B",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrBrown8","Golden Rod","DAA520",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrBrown9","Sandy Brown","F4A460",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrBrown10","Rosy Brown","BC8F8F",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrBrown11","Tan","D2B48C",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrBrown12","Burlywood","DEB887",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrBrown13","Wheat","F5DEB3",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrBrown14","Navajo White","FFDEAD",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrBrown15","Bisque","FFE4C4",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrBrown16","Blanched Almond","FFEBCD",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrBrown17","Corn Silk","FFF8DC",void 0,1,3),t+="</ul>",t+=this.getMenuText("uniclrWhitewrap","White",void 0,1,2),t+="<ul>",t+=this.getRadClr("mn4_clr","uniclrWhite1","White","FFF",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrWhite2","Snow","FFFAFA",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrWhite3","Honey Dew","F0FFF0",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrWhite4","Mint Cream","F5FFFA",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrWhite5","Azure","F0FFFF",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrWhite6","Alice Blue","F0F8FF",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrWhite7","Ghost White","F8F8FF",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrWhite8","White Smoke","F5F5F5",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrWhite9","Sea Shell","FFF5EE",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrWhite10","Beige","F5F5DC",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrWhite11","Old Lace","FDF5E6",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrWhite12","Floral White","FFFAF0",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrWhite13","Ivory","FFFFF0",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrWhite14","Antique White","FAEBD7",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrWhite15","Linen","FAF0E6",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrWhite16","Lavenderblush","FFF0F5",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrWhite17","Misty Rose","FFE4E1",void 0,1,3),t+="</ul>",t+=this.getMenuText("uniclrGraywrap","Gray",void 0,1,2),t+="<ul>",t+=this.getRadClr("mn4_clr","uniclrGray1","Gray","808080",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrGray2","Dim Gray","696969",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrGray3","Light Slate Gray","778899",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrGray4","Slate Gray","708090",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrGray5","Dark Slate Gray","2F4F4F",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrGray6","Black","000000",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrGray7","Dark Gray","A9A9A9",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrGray8","Silver","C0C0C0",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrGray9","Light Gray","D3D3D3",void 0,1,3),t+=this.getRadClr("mn4_clr","uniclrGray10","Gainsboro","DCDCDC",void 0,1,3),t+="</ul>",t+="</ul>",t+=this.getRadio("mn4_clr","mn4_clrCustom","Color Picker",void 0,void 0,1),t+=this.getMenuSep(),void 0===e.cfg.cid?(t+=this.getMenuText("mn4_clrRainbowwrap","Rainbow (R-V)","icn3d-menupd",1,1),t+="<ul>",t+=this.getRadio("mn4_clr","mn4_clrRainbow","for Selection",void 0,1,2),t+=this.getRadio("mn4_clr","mn4_clrRainbowChain","for Chains",void 0,1,2),t+=this.getRadio("mn4_clr","mn4_clrRainbowSets","for Sets",void 0,void 0,2),t+=this.getRadio("mn4_clr","mn4_clrRainbowAcrossSets","across Sets",void 0,void 0,2),t+="</ul>",t+=this.getMenuText("mn4_clrSpectrumwrap","Spectrum (V-R)","icn3d-menupd",1,1),t+="<ul>",t+=this.getRadio("mn4_clr","mn4_clrSpectrum","for Selection",void 0,1,2),t+=this.getRadio("mn4_clr","mn4_clrSpectrumChain","for Chains",void 0,1,2),t+=this.getRadio("mn4_clr","mn4_clrSpectrumSets","for Sets",void 0,void 0,2),t+=this.getRadio("mn4_clr","mn4_clrSpectrumAcrossSets","across Sets",void 0,void 0,2),t+="</ul>",t+=this.getMenuText("mn4_clrSSwrap","Secondary","icn3d-menupd",1,1),t+="<ul>",t+=this.getRadio("mn4_clr","mn4_clrSSGreen","Sheet in Green",void 0,1,2),t+=this.getRadio("mn4_clr","mn4_clrSSYellow","Sheet in Yellow",void 0,1,2),t+=this.getRadio("mn4_clr","mn4_clrSSSpectrum","Spectrum",void 0,void 0,2),t+="</ul>",t+=this.getRadio("mn4_clr","mn4_clrCharge","Charge",void 0,1,1),t+=this.getMenuText("mn4_hydrophobicwrap","Hydrophobicity","icn3d-menupd",1,1),t+="<ul>",t+=this.getRadio("mn4_clr","mn4_clrNormalizedHP","Normalized",void 0,1,2),t+=this.getRadio("mn4_clr","mn4_clrHydrophobic","Wimley-White",void 0,void 0,2),t+="</ul>",t+=this.getMenuText("mn4_clrBfactorwrap","B-factor","icn3d-menupd",1,1),t+="<ul>",t+=this.getRadio("mn4_clr","mn4_clrBfactor","Original",void 0,1,2),t+=this.getRadio("mn4_clr","mn4_clrBfactorNorm","Percentile",void 0,1,2),t+="</ul>",t+=this.getRadio("mn4_clr","mn4_clrArea",'Solvent<br><span style="padding-left:1.5em;">Accessibility</span>',void 0,void 0,1),t+=this.getRadio("mn4_clr","mn4_clrStructure","Structure",void 0,1,1),void 0!==e.cfg.align||void 0!==e.cfg.chainalign||void 0!==e.cfg.blast_rep_id?t+=this.getRadio("mn4_clr","mn4_clrChain","Chain",void 0,1,1):t+=this.getRadio("mn4_clr","mn4_clrChain","Chain",!0,1,1),t+=this.getRadio("mn4_clr","mn4_clrdomain","3D Domain",void 0,void 0,1),void 0===e.cfg.cid&&(t+=this.getMenuText("mn4_clrsetswrap","Defined Sets","icn3d-menupd",void 0,1),t+="<ul>",t+=this.getRadio("mn4_clr","mn4_clrsets",'Rainbow for Selected Sets<br><span style="padding-left:1.5em;">in "Analysis > Defined Sets"</span>',void 0,void 0,2),t+="</ul>",t+="</li>"),t+=this.getMenuText("mn4_clrResiduewrap","Residue","icn3d-menupd",1,1),t+="<ul>",t+=this.getRadio("mn4_clr","mn4_clrResidue","Default",void 0,1,2),t+=this.getRadio("mn4_clr","mn4_clrResidueCustom","Custom",void 0,void 0,2),t+="</ul>",t+=this.getRadio("mn4_clr","mn4_clrAtom","Atom",void 0,1,1),void 0!==e.cfg.align||void 0!==e.cfg.chainalign?(t+=this.getRadio("mn4_clr","mn4_clrIdentity","Identity",!0,void 0,2),t+=this.getRadio("mn4_clr","mn4_clrConserved","Conservation",void 0,void 0,2)):void 0!==e.cfg.blast_rep_id?(t+=this.getRadio("mn4_clr","mn4_clrIdentity","Identity",void 0,void 0,2),t+=this.getRadio("mn4_clr","mn4_clrConserved","Conservation",!0,void 0,2)):(t+=this.getRadio("mn4_clr","mn4_clrIdentity","Identity",void 0,void 0,2),t+=this.getRadio("mn4_clr","mn4_clrConserved","Conservation",void 0,void 0,2)),t+=this.getRadio("mn4_clr","mn4_clrConfidence","pLDDT",void 0,1,1),t+=this.getRadio("mn4_clr","mn4_clrIgstrand","Ig Strand",void 0,void 0,2),t+=this.getRadio("mn4_clr","mn4_clrIgproto","Ig Protodomain",void 0,void 0,2)):t+=this.getRadio("mn4_clr","mn4_clrAtom","Atom",!0,1,1),t+=this.getMenuSep(),t+=this.getLink("mn4_clrSave","Save Color",void 0,1),t+=this.getLink("mn4_clrApplySave","Apply Saved Color",void 0,1),t+="<li><br/></li>",t+="</ul>",t}setMenu5(){let e=this.icn3dui;if(e.bNode)return"";let t="";return t+="<div class='icn3d-menu'>",t+="<accordion id='"+e.pre+"accordion5' class='icn3d-accordion'>",t+="<h3 id='"+e.pre+"analysis' style='font-size:1.2em'>&nbsp;Analysis</h3>",t+="<div>",t+=this.setMenu5_base(),t+="</div>",t+="</accordion>",t+="</div>",t}setMenu5_base(){let e=this.icn3dui;if(e.bNode)return"";let t="";t+="<ul class='icn3d-mn-item'>",void 0===e.cfg.cid&&void 0===e.cfg.smiles||(t+=this.getLink("mn2_2ddepiction","2D Depiction "+e.htmlCls.wifiStr,1,1)),void 0===e.cfg.cid&&(t+=this.getLink("mn6_selectannotations","Seq. & Annotations "+e.htmlCls.wifiStr,1,1),t+=this.getLink("mn2_alignment","Aligned Seq. "+e.htmlCls.wifiStr,void 0,1),void 0===e.cfg.mmdbid&&void 0===e.cfg.gi&&void 0===e.cfg.blast_rep_id&&void 0===e.cfg.align&&void 0===e.cfg.chainalign||(t+=this.getLink("mn2_2ddgm","2D Diagram "+e.htmlCls.wifiStr,1,1)),t+=this.getMenuText("2dctnwrap","2D Cartoon",void 0,void 0,1),t+="<ul>",t+=this.getLink("2dctn_chain","Chain Level",void 0,2),t+=this.getLink("2dctn_domain","Domain Level",void 0,2),t+=this.getLink("2dctn_secondary","Helix/Sheet Level",void 0,2),t+="</ul>",t+="</li>",t+=this.getLink("definedsets2","Defined Sets",1,1),t+=this.getMenuSep(),t+=this.getLink("mn6_hbondsYes","Interactions",1,1),t+=this.getMenuText("mn1_window","Bring to Front",void 0,void 0,1),t+="<ul>",t+=this.getLink("mn1_window_table","Interaction Table",void 0,2),t+=this.getLink("mn1_window_linegraph","2D Interaction Network",void 0,2),t+=this.getLink("mn1_window_scatterplot","2D Interaction Map",void 0,2),t+=this.getLink("mn1_window_graph","2D Graph(Force-Directed)",void 0,2),t+="</ul>",t+="</li>",t+=this.getLink("mn6_contactmap","Contact Map",void 0,1),t+=this.getLink("mn1_mutation","Mutation "+e.htmlCls.wifiStr,1,1)),e.cfg.hidelicense||(t+=this.getMenuText("mn1_delphiwrap","DelPhi Potential",void 0,1,1),t+="<ul>",t+=this.getLink("mn1_delphi","DelPhi Potential "+e.htmlCls.licenseStr,1,2),t+=this.getMenuText("mn1_phiwrap","Load PQR/Phi",void 0,void 0,2),t+="<ul>",t+=this.getLink("mn1_phi","Local PQR/Phi/Cube File",void 0,3),t+=this.getLink("mn1_phiurl","URL PQR/Phi/Cube File",void 0,3),t+="</ul>",t+="</li>",t+=this.getLink("delphipqr","Download PQR",void 0,2),t+="</ul>",t+="</li>"),t+=this.getMenuSep(),t+=this.getMenuText("mn6_distancewrap","Distance",void 0,1,1),t+="<ul>",t+=this.getRadio("mn6_distance","mn6_distanceYes","between Two Atoms",void 0,1,2),t+=this.getRadio("mn6_distance","mn6_distTwoSets","between Two Sets",void 0,void 0,2),t+=this.getRadio("mn6_distance","mn6_distManySets","among Many Sets",void 0,void 0,2),t+=this.getRadio("mn6_distance","mn6_distanceNo","Hide",!0,1,2),t+="</ul>",t+="</li>",t+=this.getMenuText("mn6_anglewrap","Angle",void 0,1,1),t+="<ul>",t+=this.getRadio("mn6_angle","mn6_angleManySets","among Many Sets",void 0,1,2),t+=this.getRadio("mn6_angle","mn6_angleTwoSets","b/w Two Vectors",void 0,void 0,2),t+="</ul>",t+="</li>",t+=this.getLink("mn6_area","Surface Area",1,1),t+=this.getMenuText("mn6_addlabelwrap","Label",void 0,1,1),t+="<ul>",t+=this.getRadio("mn6_addlabel","mn6_addlabelYes","by Picking Atoms",void 0,void 0,2),t+=this.getRadio("mn6_addlabel","mn6_addlabelSelection","per Selection",void 0,void 0,2),t+=this.getRadio("mn6_addlabel","mn6_addlabelAtoms","per Atom",void 0,void 0,2),t+=this.getRadio("mn6_addlabel","mn6_addlabelElements","per Atom Element",void 0,1,2),void 0===e.cfg.cid&&(t+=this.getRadio("mn6_addlabel","mn6_addlabelResidues","per Residue",void 0,1,2),t+=this.getRadio("mn6_addlabel","mn6_addlabelResnum","per Residue & Number",void 0,1,2),t+=this.getRadio("mn6_addlabel","mn6_addlabelRefnum","per Reference Number",void 0,1,2),t+=this.getRadio("mn6_addlabel","mn6_addlabelIg","per Ig Domain",void 0,1,2),t+=this.getRadio("mn6_addlabel","mn6_addlabelChains","per Chain",void 0,void 0,2),t+=this.getRadio("mn6_addlabel","mn6_addlabelTermini","N- & C-Termini",void 0,1,2)),t+=this.getMenuSep(),t+=this.getRadio("mn6_addlabel","mn6_labelColor","Change Label Color",void 0,1,2),t+=this.getRadio("mn6_addlabel","mn6_addlabelNo","Remove",!0,1,2),t+="</ul>",t+="</li>",t+=this.getMenuText("labelscalewrap","Label Scale",void 0,1,1),t+="<ul>";for(let e=1;e<=4;++e){let s=2*e;t+=this.getRadio("mn6_labelscale","mn6_labelscale0"+s,"0."+s,void 0,1,2)}for(let e=2;e<=10;++e){let s=(e/2).toFixed(1);t+=2==e?this.getRadio("mn6_labelscale","mn6_labelscale"+e+"0",s,!0,1,2):this.getRadio("mn6_labelscale","mn6_labelscale"+e+"0",s,void 0,1,2)}if(t+="</ul>",t+="</li>",t+=this.getMenuSep(),void 0===e.cfg.cid){t+=this.getMenuText("mn6_chemicalbindingwrap","Chem. Binding",void 0,void 0,1),t+="<ul>",t+=this.getRadio("mn6_chemicalbinding","mn6_chemicalbindingshow","Show",void 0,void 0,2),t+=this.getRadio("mn6_chemicalbinding","mn6_chemicalbindinghide","Hide",!0,void 0,2),t+="</ul>",t+="</li>",t+=this.getMenuText("mn6_ssbondswrap","Disulfide Bonds",void 0,1,1),t+="<ul>",t+=this.getRadio("mn6_ssbonds","mn6_ssbondsYes","Show",!0,1,2),t+=this.getRadio("mn6_ssbonds","mn6_ssbondsExport","Export Pairs",void 0,void 0,2),t+=this.getRadio("mn6_ssbonds","mn6_ssbondsNo","Hide",void 0,1,2),t+="</ul>",t+="</li>",t+=this.getMenuText("mn6_clbondswrap","Cross-Linkages",void 0,void 0,1),t+="<ul>",t+=this.getRadio("mn6_clbonds","mn6_clbondsYes","Show",!0,void 0,2),t+=this.getRadio("mn6_clbonds","mn6_clbondsExport","Export Pairs",void 0,void 0,2),t+=this.getRadio("mn6_clbonds","mn6_clbondsNo","Hide",void 0,void 0,2),t+="</ul>",t+="</li>",t+=this.getLink("mn6_DSSP","DSSP Secondary",void 0,1);let s=void 0!==e.cfg.mmtfid||void 0!==e.cfg.pdbid||void 0!==e.cfg.opmid||void 0!==e.cfg.mmcifid||void 0!==e.cfg.mmdbid||void 0!==e.cfg.mmdbafid||void 0!==e.cfg.gi||void 0!==e.cfg.blast_rep_id;s&&(t+=this.getMenuText("assemblyWrapper","Assembly",void 0,1,1),t+="<ul>",e.cfg.bu?(t+=this.getRadio("mn6_assembly","mn6_assemblyYes","Biological Assembly",!0,1,2),t+=this.getRadio("mn6_assembly","mn6_assemblyNo","Asymmetric Unit",void 0,1,2)):(t+=this.getRadio("mn6_assembly","mn6_assemblyYes","Biological Assembly",void 0,1,2),t+=this.getRadio("mn6_assembly","mn6_assemblyNo","Asymmetric Unit",!0,1,2)),t+="</ul>",t+="</li>"),t+=this.getMenuText("mn6_symmetrywrap","Symmetry",void 0,void 0,1),t+="<ul>",s&&(t+=this.getLink("mn6_symmetry","from PDB(precalculated) "+e.htmlCls.wifiStr,void 0,2)),t+=this.getLink("mn6_symd","from SymD(Dynamic) "+e.htmlCls.wifiStr,void 0,2),t+=this.getLink("mn6_clear_sym","Clear SymD Symmetry",void 0,2),t+=this.getLink("mn6_axes_only","Show Axes Only",void 0,2),t+="</ul>",t+="</li>",t+=this.getMenuText("mn6_igrefwrap","Ref. Number",void 0,void 0,1),t+="<ul>",t+=this.getLink("mn6_igrefYes","Show Ig for Selection",void 0,2),t+=this.getLink("mn6_igrefTpl","Ig w/ Specified Template",void 0,2),t+=this.getLink("mn6_alignrefTpl","Align w/ Specified Template",void 0,2),t+=this.getLink("mn6_igrefNo","Reset Ig Ref. Number",void 0,2),t+=this.getMenuSep(),t+=this.getLink("mn6_customref","Custom Ref. Number",void 0,2),t+="</ul>",t+="</li>",t+=this.getMenuSep()}return t+=this.getLink("mn6_yournote","Window Title",void 0,1),void 0!==e.cfg.cid?(t+=this.getMenuText("mn1_linkwrap","Links",void 0,void 0,1),t+="<ul>",t+=this.getLink("mn1_link_structure","Compound Summary "+e.htmlCls.wifiStr,void 0,2),t+=this.getLink("mn1_link_vast","Similar Compounds "+e.htmlCls.wifiStr,void 0,2),t+=this.getLink("mn1_link_bind","Structures Bound "+e.htmlCls.wifiStr,void 0,2),t+="</ul>",t+="</li>"):(t+=this.getMenuText("mn1_linkwrap","Links",void 0,void 0,1),t+="<ul>",t+=this.getLink("mn1_link_structure","Structure Summary "+e.htmlCls.wifiStr,void 0,2),t+=this.getLink("mn1_link_vast","Similar Structures "+e.htmlCls.wifiStr,void 0,2),t+=this.getLink("mn1_link_pubmed","Literature "+e.htmlCls.wifiStr,void 0,2),t+=this.getLink("mn1_link_protein","Protein "+e.htmlCls.wifiStr,void 0,2),t+="</ul>",t+="</li>"),t+="<li><br/></li>",t+="</ul>",t}setMenu6(){let e=this.icn3dui;if(e.bNode)return"";let t="";return t+="<div class='icn3d-menu'>",t+="<accordion id='"+e.pre+"accordion6' class='icn3d-accordion'>",t+="<h3>Help</h3>",t+="<div>",t+=this.setMenu6_base(),t+="</div>",t+="</accordion>",t+="</div>",t}setMenu6_base(){let e=this.icn3dui;if(e.bNode)return"";let t="";return t+="<ul class='icn3d-mn-item'>",t+=this.getMenuUrl("abouticn3d",e.htmlCls.baseUrl+"icn3d/icn3d.html#about","About iCn3D<span style='font-size:0.9em'> "+e.REVISION+"</span>",1,1),t+=this.getMenuUrl("gallery",e.htmlCls.baseUrl+"icn3d/icn3d.html#gallery","Live Gallery "+e.htmlCls.wifiStr,1,1),t+=this.getMenuUrl("video",e.htmlCls.baseUrl+"icn3d/icn3d.html#videos","Videos & Tutorials",1,1),t+=this.getMenuText("mn6_faq","FAQ",void 0,1,1),t+="<ul>",t+=this.getMenuUrl("faq_viewstru",e.htmlCls.baseUrl+"icn3d/icn3d.html#viewstru","View structure",1,2),t+=this.getMenuUrl("faq_tfstru",e.htmlCls.baseUrl+"icn3d/icn3d.html#tfstru","Transform Structure",1,2),t+=this.getMenuUrl("faq_selsubset",e.htmlCls.baseUrl+"icn3d/icn3d.html#selsubset","Select Subsets",1,2),t+=this.getMenuUrl("faq_stylecolor",e.htmlCls.baseUrl+"icn3d/icn3d.html#changestylecolor","Change Style/Color",1,2),t+=this.getMenuUrl("faq_savework",e.htmlCls.baseUrl+"icn3d/icn3d.html#saveview","Save Work",1,2),t+=this.getMenuUrl("faq_showanno",e.htmlCls.baseUrl+"icn3d/icn3d.html#showanno","Show Annotations",1,2),t+=this.getMenuUrl("faq_exportanno",e.htmlCls.baseUrl+"icn3d/icn3d.html#exportanno","Export Annotations",1,2),t+=this.getMenuUrl("faq_interanal",e.htmlCls.baseUrl+"icn3d/icn3d.html#interanalysis","Interaction Analysis",1,2),t+=this.getMenuUrl("faq_mutanal",e.htmlCls.baseUrl+"icn3d/icn3d.html#mutationanalysis","Mutation Analysis",1,2),t+=this.getMenuUrl("faq_elecpot",e.htmlCls.baseUrl+"icn3d/icn3d.html#elecpot","Electrostatic Pot.",1,2),t+=this.getMenuUrl("faq_simipdb",e.htmlCls.baseUrl+"icn3d/icn3d.html#simivast","Similar PDB",1,2),t+=this.getMenuUrl("faq_simialphapdb",e.htmlCls.baseUrl+"icn3d/icn3d.html#simifoldseek","Similar AlphaFold/PDB",1,2),t+=this.getMenuUrl("faq_alnstru",e.htmlCls.baseUrl+"icn3d/icn3d.html#alignmul","Align Multiple Structures",1,2),t+=this.getMenuUrl("faq_batchanal",e.htmlCls.baseUrl+"icn3d/icn3d.html#batchanalysis","Batch Analysis",1,2),t+=this.getMenuUrl("faq_batchanal",e.htmlCls.baseUrl+"icn3d/icn3d.html#igrefnum","Assign Ig Ref. Numbers",1,2),t+=this.getMenuUrl("faq_embedicn3d",e.htmlCls.baseUrl+"icn3d/icn3d.html#embedicn3d","Embed iCn3D",1,2),t+="</ul>",t+="</li>",t+=this.getMenuUrl("citing",e.htmlCls.baseUrl+"icn3d/icn3d.html#citing","Citing iCn3D",void 0,1),t+=this.getMenuText("mn6_source","Source Code",void 0,1,1),t+="<ul>",t+=this.getMenuUrl("github","https://github.com/ncbi/icn3d","GitHub (browser) "+e.htmlCls.wifiStr,1,2),t+=this.getMenuUrl("npm","https://www.npmjs.com/package/icn3d","npm (Node.js) "+e.htmlCls.wifiStr,1,2),t+=this.getMenuUrl("notebook","https://pypi.org/project/icn3dpy","Jupyter Notebook "+e.htmlCls.wifiStr,1,2),t+="</ul>",t+="</li>",t+=this.getMenuText("mn6_develop","Develop",void 0,void 0,1),t+="<ul>",t+=this.getMenuUrl("dev_embedicn3d2",e.htmlCls.baseUrl+"icn3d/icn3d.html#HowToUse","Embed iCn3D",void 0,2),t+=this.getMenuUrl("dev_urlpara",e.htmlCls.baseUrl+"icn3d/icn3d.html#parameters","URL Parameters",void 0,2),t+=this.getMenuUrl("dev_command",e.htmlCls.baseUrl+"icn3d/icn3d.html#commands","Commands",void 0,2),t+=this.getMenuUrl("dev_datastru",e.htmlCls.baseUrl+"icn3d/icn3d.html#datastructure","Data Structure",void 0,2),t+=this.getMenuUrl("dev_classstru",e.htmlCls.baseUrl+"icn3d/icn3d.html#classstructure","Class Structure",void 0,2),t+=this.getMenuUrl("dev_addclass",e.htmlCls.baseUrl+"icn3d/icn3d.html#addclass","Add New Classes",void 0,2),t+=this.getMenuUrl("dev_modfunc",e.htmlCls.baseUrl+"icn3d/icn3d.html#modifyfunction","Modify Functions",void 0,2),t+=this.getMenuUrl("dev_restful",e.htmlCls.baseUrl+"icn3d/icn3d.html#restfulapi","RESTful APIs",void 0,2),t+=this.getMenuUrl("dev_contributor",e.htmlCls.baseUrl+"icn3d/icn3d.html#contributors","iCn3D Contributors",void 0,2),t+="</ul>",t+="</li>",t+=this.getMenuUrl("helpdoc",e.htmlCls.baseUrl+"icn3d/docs/icn3d_help.html","Help Doc "+e.htmlCls.wifiStr,1,1),t+=this.getMenuSep(),t+=this.getMenuText("mn6_tfhint","Transform Hints",void 0,1,1),t+="<ul>",t+=this.getMenuText("mn6_rotate","Rotate",void 0,1,2),t+="<ul>",t+="<li>Left Mouse (Click & Drag)</li>",t+="<li>Key l: Left</li>",t+="<li>Key j: Right</li>",t+="<li>Key i: Up</li>",t+="<li>Key m: Down</li>",t+="<li>Shift + Key l: Left 90&deg;</li>",t+="<li>Shift + Key j: Right 90&deg;</li>",t+="<li>Shift + Key i: Up 90&deg;</li>",t+="<li>Shift + Key m: Down 90&deg;</li>",t+="</ul>",t+="</li>",t+=this.getMenuText("mn6_zoom","Zoom",void 0,1,2),t+="<ul>",t+="<li>Middle Mouse <br>(Pinch & Spread)</li>",t+="<li>Key z: Zoom in</li>",t+="<li>Key x: Zoom out</li>",t+="</ul>",t+="</li>",t+=this.getMenuText("mn6_translate","Translate",void 0,1,2),t+="<ul>",t+="<li>Right Mouse <br>(Two Finger Click & Drag)</li>",t+="</ul>",t+="</li>",t+="</ul>",t+="</li>",t+=this.getMenuUrl("selhints",e.htmlCls.baseUrl+"icn3d/icn3d.html#selsubset","Selection Hints",void 0,1),t+=this.getMenuUrl("helpdesk","https://support.nlm.nih.gov/support/create-case/","Write to Help Desk",1,1),t+="<li><br/></li>",t+="</ul>",t}hideMenu(){let e=this.icn3dui;e.bNode||(void 0!==$("#"+e.pre+"mnlist")[0]&&($("#"+e.pre+"mnlist")[0].style.display="none"),void 0!==$("#"+e.pre+"mnLogSection")[0]&&($("#"+e.pre+"mnLogSection")[0].style.display="none"),void 0!==$("#"+e.pre+"cmdlog")[0]&&($("#"+e.pre+"cmdlog")[0].style.display="none"),$("#"+e.pre+"title")[0].style.margin="10px 0 0 10px")}showMenu(){let e=this.icn3dui;e.bNode||(void 0!==$("#"+e.pre+"mnlist")[0]&&($("#"+e.pre+"mnlist")[0].style.display="block"),void 0!==$("#"+e.pre+"mnLogSection")[0]&&($("#"+e.pre+"mnLogSection")[0].style.display="block"),void 0!==$("#"+e.pre+"cmdlog")[0]&&($("#"+e.pre+"cmdlog")[0].style.display="block"))}}class c{constructor(e){this.icn3dui=e}openDlg(e,t){let s=this.icn3dui;s.icn3d,s.bNode||(e=s.pre+e,s.cfg.notebook?this.openDlgNotebook(e,t):this.openDlgRegular(e,t),s.htmlCls.themecolor||(s.htmlCls.themecolor="blue"),s.htmlCls.setMenuCls.setTheme(s.htmlCls.themecolor))}addSaveButton(e){let t=this.icn3dui;t.icn3d,t.bNode||void 0!==this.dialogHashSave&&this.dialogHashSave.hasOwnProperty(e)||($("#"+e).parent().children(".ui-dialog-titlebar").append("<div pid='"+e+"' class='icn3d-saveicon ui-icon ui-icon-disk' title='Save as an HTML file' style='background-color:white; background-image: url(&quot;https://www.ncbi.nlm.nih.gov/Structure/icn3d/lib/images/ui-icons_228ef1_256x240.png&quot;);'></div>"),void 0===this.dialogHashSave&&(this.dialogHashSave={}),this.dialogHashSave[e]=1)}addHideButton(e){let t=this.icn3dui;t.icn3d,t.bNode||void 0!==this.dialogHashHide&&this.dialogHashHide.hasOwnProperty(e)||($("#"+e).parent().children(".ui-dialog-titlebar").append("<div pid='"+e+"' class='icn3d-hideicon ui-icon ui-icon-arrowthick-2-ne-sw' title='Resize the window' style='background-color:white; background-image: url(&quot;https://www.ncbi.nlm.nih.gov/Structure/icn3d/lib/images/ui-icons_228ef1_256x240.png&quot;);'></div>"),void 0===this.dialogHashHide&&(this.dialogHashHide={}),this.dialogHashHide[e]=1)}getDialogStatus(){let e=this.icn3dui;if(e.icn3d,e.bNode)return;let t={},s={},i=$("#"+e.pre+"dl_selectannotations").hasClass("ui-dialog-content"),n=$("#"+e.pre+"dl_graph").hasClass("ui-dialog-content"),l=$("#"+e.pre+"dl_linegraph").hasClass("ui-dialog-content"),r=$("#"+e.pre+"dl_scatterplot").hasClass("ui-dialog-content"),o=$("#"+e.pre+"dl_ligplot").hasClass("ui-dialog-content"),a=$("#"+e.pre+"dl_contactmap").hasClass("ui-dialog-content"),d=$("#"+e.pre+"dl_alignerrormap").hasClass("ui-dialog-content"),c=$("#"+e.pre+"dl_interactionsorted").hasClass("ui-dialog-content"),h=$("#"+e.pre+"dl_alignment").hasClass("ui-dialog-content"),p=$("#"+e.pre+"dl_2ddgm").hasClass("ui-dialog-content"),m=$("#"+e.pre+"dl_2dctn").hasClass("ui-dialog-content"),u=$("#"+e.pre+"dl_definedsets").hasClass("ui-dialog-content");return t.bSelectannotationsInit2=!1,t.bGraph2=!1,t.bLineGraph2=!1,t.bScatterplot2=!1,t.bLigplot2=!1,t.bTable2=!1,t.bAlignmentInit2=!1,t.bTwoddgmInit2=!1,t.bTwodctnInit2=!1,t.bSetsInit2=!1,s.dl_selectannotations="bSelectannotationsInit2",s.dl_graph="bGraph2",s.dl_linegraph="bLineGraph2",s.dl_scatterplot="bScatterplot2",s.dl_ligplot="bLigplot2",s.dl_contactmap="bContactmap2",s.dl_alignerrormap="bAlignerrormap2",s.dl_interactionsorted="bTable2",s.dl_alignment="bAlignmentInit2",s.dl_2ddgm="bTwoddgmInit2",s.dl_2dctn="bTwodctnInit2",s.dl_definedsets="bSetsInit2",i&&(t.bSelectannotationsInit2=$("#"+e.pre+"dl_selectannotations").dialog("isOpen")),n&&(t.bGraph2=$("#"+e.pre+"dl_graph").dialog("isOpen")),l&&(t.bLineGraph2=$("#"+e.pre+"dl_linegraph").dialog("isOpen")),r&&(t.bScatterplot2=$("#"+e.pre+"dl_scatterplot").dialog("isOpen")),o&&(t.bLigplot2=$("#"+e.pre+"dl_ligplot").dialog("isOpen")),a&&(t.bContactmap2=$("#"+e.pre+"dl_contactmap").dialog("isOpen")),d&&(t.bAlignerror2=$("#"+e.pre+"dl_alignerrormap").dialog("isOpen")),c&&(t.bTable2=$("#"+e.pre+"dl_interactionsorted").dialog("isOpen")),h&&(t.bAlignmentInit2=$("#"+e.pre+"dl_alignment").dialog("isOpen")),p&&(t.bTwoddgmInit2=$("#"+e.pre+"dl_2ddgm").dialog("isOpen")),m&&(t.bTwodctnInit2=$("#"+e.pre+"dl_2dctn").dialog("isOpen")),u&&(t.bSetsInit2=$("#"+e.pre+"dl_definedsets").dialog("isOpen")),{status:t,id2flag:s}}openDlgHalfWindow(e,t,s,i){let n=this.icn3dui,l=n.icn3d;if(n.bNode)return;let r=this,o=n.htmlCls.width2d+20;l.resizeCanvasCls.resizeCanvas(n.htmlCls.WIDTH-s,n.htmlCls.HEIGHT,i);let a,d=n.htmlCls.HEIGHT,c=s;a=!n.cfg.showmenu||n.utilsCls.isMobile()||n.cfg.mobilemenu?{my:"left top",at:"right top",of:"#"+n.pre+"viewer",collision:"none"}:{my:"left top",at:"right top+40",of:"#"+n.pre+"viewer",collision:"none"},n.cfg.resize=!1,window.dialog=$("#"+e).dialog({autoOpen:!0,title:t,height:d,width:c,modal:!1,position:a,close:function(t){let s=r.getDialogStatus(),i=s.status,a=s.id2flag,d=!1;for(let t in a){let s=e===n.pre+t;for(let e in i)i.hasOwnProperty(e)||(s=s&&!i[e]);d=d||s}if(d)if(i.bTwoddgmInit2||i.bTwodctnInit2||i.bSetsInit2){let e=n.utilsCls.isMobile()?n.htmlCls.WIDTH:n.htmlCls.WIDTH-o;l.resizeCanvasCls.resizeCanvas(e,n.htmlCls.HEIGHT,!0),i.bTwoddgmInit2&&r.openDlg2Ddgm(n.pre+"dl_2ddgm",void 0,i.bSetsInit2),i.bTwodctnInit2&&r.openDlg2Ddgm(n.pre+"dl_2dctn",void 0,i.bSetsInit2),i.bSetsInit2&&r.openDlg2Ddgm(n.pre+"dl_definedsets")}else l.resizeCanvasCls.resizeCanvas(n.htmlCls.WIDTH,n.htmlCls.HEIGHT,!0)},resize:function(t){if(e==n.pre+"dl_selectannotations")l.annotationCls.hideFixedTitle();else if(e==n.pre+"dl_graph"){let t=$("#"+e).width(),s=$("#"+e).height();d3.select("#"+n.svgid).attr("width",t).attr("height",s)}else if(e==n.pre+"dl_linegraph"||e==n.pre+"dl_scatterplot"||e==n.pre+"dl_ligplot"||e==n.pre+"dl_contactmap"||e==n.pre+"dl_alignerrormap"){let t=status.bTwoddgmInit2||status.bSetsInit2?(n.htmlCls.WIDTH-o)/2:n.htmlCls.WIDTH/2,s=$("#"+e).width()/t;if(e==n.pre+"dl_linegraph"){let e=l.linegraphWidth*s;$("#"+n.linegraphid).attr("width",e)}else if(e==n.pre+"dl_scatterplot"){let e=l.scatterplotWidth*s;$("#"+n.scatterplotid).attr("width",e)}else if(e==n.pre+"dl_ligplot"){let e=l.ligplotWidth*s;$("#"+n.ligplotid).attr("width",e)}else if(e==n.pre+"dl_ligplot"){let e=l.ligplotWidth*s;$("#"+n.ligplotid).attr("width",e)}else if(e==n.pre+"dl_contactmap"){let e=l.contactmapWidth*s;$("#"+n.contactmapid).attr("width",e)}else if(e==n.pre+"dl_alignerrormap"){let e=l.alignerrormapWidth*s;$("#"+n.alignerrormapid).attr("width",e)}}}}),this.addSaveButton(e),this.addHideButton(e)}openDlg2Ddgm(e,t,s){let i=this.icn3dui,n=i.icn3d;if(i.bNode)return;let l,r,o=this,a=i.htmlCls.width2d+20;e===i.pre+"dl_definedsets"?(l="right top",r="Select sets"):e!==i.pre+"dl_2ddgm"&&e!==i.pre+"dl_2dctn"||(l=s?"right top+240":"right top",r=e===i.pre+"dl_2ddgm"?"2D Diagram":"2D Cartoon");let d={my:"left top+"+i.htmlCls.MENU_HEIGHT,at:l,of:"#"+i.pre+"viewer",collision:"none"};window.dialog=$("#"+e).dialog({autoOpen:!0,title:r,height:"auto",width:a,modal:!1,position:d,close:function(e){let t=o.getDialogStatus().status;t.bSelectannotationsInit2||t.bGraph2||t.bLineGraph2||t.bScatterplot2||t.bLigplot2||t.bTable2||t.bAlignmentInit2||n.resizeCanvasCls.resizeCanvas(i.htmlCls.WIDTH,i.htmlCls.HEIGHT,!0)},resize:function(t,s){e==i.pre+"dl_2dctn"&&(n.resizeRatioX=s.size.width/i.htmlCls.width2d,n.resizeRatioY=s.size.height/(i.htmlCls.width2d+70))},resizeStop:function(e,t){n.resizeRatioX=t.size.width/i.htmlCls.width2d,n.resizeRatioY=t.size.height/(i.htmlCls.width2d+70)}}),this.addSaveButton(e),this.addHideButton(e)}openDlgRegular(e,t){let s=this.icn3dui,i=s.icn3d;if(s.bNode)return;let n=400,l=150,r=s.htmlCls.width2d+20,o=this.getDialogStatus().status;if(e===s.pre+"dl_selectannotations"||e===s.pre+"dl_graph"||e===s.pre+"dl_linegraph"||e===s.pre+"dl_scatterplot"||e===s.pre+"dl_ligplot"||e===s.pre+"dl_contactmap"||e===s.pre+"dl_alignerrormap"||e===s.pre+"dl_interactionsorted"||e===s.pre+"dl_alignment"){let a=.5*s.htmlCls.WIDTH-.5*r;if(s.htmlCls.WIDTH>=s.htmlCls.HEIGHT)this.openDlgHalfWindow(e,t,a,!0),(o.bTwoddgmInit2||o.bTwodctnInit2||o.bSetsInit2)&&(i.resizeCanvasCls.resizeCanvas(s.htmlCls.WIDTH-a-r,s.htmlCls.HEIGHT,!0),o.bTwoddgmInit2&&this.openDlg2Ddgm(s.pre+"dl_2ddgm",void 0,o.bSetsInit2),o.bTwodctnInit2&&this.openDlg2Ddgm(s.pre+"dl_2dctn",void 0,o.bSetsInit2),o.bSetsInit2&&this.openDlg2Ddgm(s.pre+"dl_definedsets"));else{i.resizeCanvasCls.resizeCanvas(s.htmlCls.WIDTH,.5*s.htmlCls.HEIGHT,!0),l=.5*s.htmlCls.HEIGHT,n=s.htmlCls.WIDTH;let a={my:"left top",at:"left bottom+32",of:"#"+s.pre+"canvas",collision:"none"};window.dialog=$("#"+e).dialog({autoOpen:!0,title:t,height:l,width:n,modal:!1,position:a,close:function(t){if(!((e!==s.pre+"dl_selectannotations"||o.bAlignmentInit2||o.bGraph2||o.bTable2||o.bLineGraph2||o.bScatterplot2||o.bLigplot2||o.bContactmap2||o.bAlignerrormap2)&&(e!==s.pre+"dl_graph"||o.bSelectannotationsInit2||o.bAlignmentInit2||o.bTable2||o.bLineGraph2||o.bScatterplot2||o.bLigplot2||o.bContactmap2||o.bAlignerrormap2)&&(e!==s.pre+"dl_alignment"||o.bSelectannotationsInit2||o.bGraph2||o.bTable2||o.bLineGraph2||o.bScatterplot2||o.bLigplot2||o.bContactmap2||o.bAlignerrormap2)&&(e!==s.pre+"dl_interactionsorted"||o.bSelectannotationsInit2||o.bGraph2||o.bAlignmentInit2||o.bLineGraph2||o.bScatterplot2||o.bLigplot2||o.bContactmap2||o.bAlignerrormap2)&&(e!==s.pre+"dl_linegraph"||o.bSelectannotationsInit2||o.bGraph2||o.bAlignmentInit2||o.bTable2||o.bScatterplot2||o.bLigplot2||o.bContactmap2||o.bAlignerrormap2)&&(e!==s.pre+"dl_scatterplot"||o.bSelectannotationsInit2||o.bGraph2||o.bAlignmentInit2||o.bTable2||o.bLineGraph2||o.bLigplot2||o.bContactmap2||o.bAlignerrormap2)&&(e!==s.pre+"dl_ligplot"||o.bSelectannotationsInit2||o.bGraph2||o.bAlignmentInit2||o.bTable2||o.bLineGraph2||o.bScatterplot2||o.bContactmap2||o.bAlignerrormap2)&&(e!==s.pre+"dl_contactmap"||o.bSelectannotationsInit2||o.bGraph2||o.bAlignmentInit2||o.bTable2||o.bLineGraph2||o.bScatterplot2||o.bLigplot2||o.bAlignerrormap2)&&(e!==s.pre+"dl_alignerrormap"||o.bSelectannotationsInit2||o.bGraph2||o.bAlignmentInit2||o.bTable2||o.bLineGraph2||o.bScatterplot2||o.bLigplot2||o.bContactmap2)))if(o.bTwoddgmInit2||o.bTwodctnInit2||o.bSetsInit2){let e=s.utilsCls.isMobile()?s.htmlCls.WIDTH:s.htmlCls.WIDTH-r;i.resizeCanvasCls.resizeCanvas(e,s.htmlCls.HEIGHT,!0),o.bTwoddgmInit2&&thisClass.openDlg2Ddgm(s.pre+"dl_2ddgm",void 0,o.bSetsInit2),o.bTwodctnInit2&&thisClass.openDlg2Ddgm(s.pre+"dl_2dctn",void 0,o.bSetsInit2),o.bSetsInit2&&thisClass.openDlg2Ddgm(s.pre+"dl_definedsets")}else i.resizeCanvasCls.resizeCanvas(s.htmlCls.WIDTH,s.htmlCls.HEIGHT,!0)},resize:function(t){if(e==s.pre+"dl_selectannotations")i.annotationCls.hideFixedTitle();else if(e==s.pre+"dl_graph"){let t=$("#"+e).width(),i=$("#"+e).height();d3.select("#"+s.svgid).attr("width",t).attr("height",i)}else if(e==s.pre+"dl_linegraph"||e==s.pre+"dl_scatterplot"||e==s.pre+"dl_ligplot"||e==s.pre+"dl_contactmap"||e==s.pre+"dl_alignerrormap"){let t=o.bTwoddgmInit2||o.bSetsInit2?(s.htmlCls.WIDTH-r)/2:s.htmlCls.WIDTH/2,n=$("#"+e).width()/t;if(e==s.pre+"dl_linegraph"){let e=i.linegraphWidth*n;$("#"+s.linegraphid).attr("width",e)}else if(e==s.pre+"dl_scatterplot"){let e=i.scatterplotWidth*n;$("#"+s.scatterplotid).attr("width",e)}else if(e==s.pre+"dl_ligplot"){let e=i.ligplotWidth*n;$("#"+s.ligplotid).attr("width",e)}else if(e==s.pre+"dl_contactmap"){let e=i.contactmapWidth*n;$("#"+s.contactmapid).attr("width",e)}else if(e==s.pre+"dl_alignerrormap"){let e=i.alignerrormapWidth*n;$("#"+s.alignerrormapid).attr("width",e)}}}}),this.addSaveButton(e),this.addHideButton(e)}}else if(e===s.pre+"dl_2ddgm"||e===s.pre+"dl_2dctn"){let t=0;if(s.htmlCls.WIDTH>=s.htmlCls.HEIGHT)(o.bSelectannotationsInit2||o.bGraph2||o.bLineGraph2||o.bScatterplot2||o.bLigplot2||o.bTable2||o.bAlignmentInit2)&&(t=.5*s.htmlCls.WIDTH-.5*r),i.resizeCanvasCls.resizeCanvas(s.htmlCls.WIDTH-t-r,s.htmlCls.HEIGHT,!0),this.openDlg2Ddgm(e,void 0,o.bSetsInit2);else{let t=s.utilsCls.isMobile()?s.htmlCls.WIDTH:s.htmlCls.WIDTH-r;i.resizeCanvasCls.resizeCanvas(t,.5*s.htmlCls.HEIGHT,!0),this.openDlg2Ddgm(e,.5*s.htmlCls.HEIGHT),this.openDlg2Ddgm(e,.5*s.htmlCls.HEIGHT,o.bSetsInit2)}}else{let a;if(l="auto",n="auto",e===s.pre+"dl_addtrack"?n="50%":e===s.pre+"dl_menupref"&&(n=800,l=500),e===s.pre+"dl_definedsets"){let t=0;if(s.htmlCls.WIDTH>=s.htmlCls.HEIGHT)(o.bSelectannotationsInit2||o.bGraph2||o.bLineGraph2||o.bScatterplot2||o.bLigplot2||o.bTable2||o.bAlignmentInit2)&&(t=.5*s.htmlCls.WIDTH-.5*r),i.resizeCanvasCls.resizeCanvas(s.htmlCls.WIDTH-t-r,s.htmlCls.HEIGHT,!0),this.openDlg2Ddgm(e),o.bTwoddgmInit2&&this.openDlg2Ddgm(s.pre+"dl_2ddgm",void 0,!0),o.bTwodctnInit2&&this.openDlg2Ddgm(s.pre+"dl_2dctn",void 0,!0);else{let t=s.utilsCls.isMobile()?s.htmlCls.WIDTH:s.htmlCls.WIDTH-r;i.resizeCanvasCls.resizeCanvas(t,.5*s.htmlCls.HEIGHT,!0),this.openDlg2Ddgm(e,.5*s.htmlCls.HEIGHT),o.bTwoddgmInit2&&this.openDlg2Ddgm(s.pre+"dl_2ddgm",.5*s.htmlCls.HEIGHT,!0),o.bTwodctnInit2&&this.openDlg2Ddgm(s.pre+"dl_2dctn",.5*s.htmlCls.HEIGHT,!0)}}else s.utilsCls.isMobile()?a={my:"left top",at:"left bottom-50",of:"#"+s.pre+"canvas",collision:"none"}:e===s.pre+"dl_allinteraction"||e===s.pre+"dl_buriedarea"?(a={my:"right top",at:"right top+50",of:"#"+i.divid,collision:"none"},n=700,l=500):a=e===s.pre+"dl_rmsd"||e===s.pre+"dl_legend"?{my:"left bottom",at:"left+20 bottom-20",of:"#"+s.pre+"canvas",collision:"none"}:e===s.pre+"dl_symd"?{my:"left top",at:"right-200 bottom-200",of:"#"+s.pre+"canvas",collision:"none"}:s.cfg.align?{my:"left top",at:"left top+90",of:"#"+s.pre+"canvas",collision:"none"}:e===s.pre+"dl_mmdbafid"?{my:"left top",at:"left top+130",of:"#"+s.pre+"canvas",collision:"none"}:{my:"left top",at:"left top+50",of:"#"+s.pre+"canvas",collision:"none"},window.dialog=$("#"+e).dialog({autoOpen:!0,title:t,height:l,width:n,modal:!1,position:a}),this.addSaveButton(e),this.addHideButton(e)}$(".ui-dialog .ui-button span").removeClass("ui-icon-closethick").addClass("ui-icon-close")}openDlgNotebook(e,t){let s=this.icn3dui,i=s.icn3d;if(s.bNode)return;let n=400,l=150,r=s.htmlCls.width2d+20;e===s.pre+"dl_selectannotations"||e===s.pre+"dl_graph"||e===s.pre+"dl_linegraph"||e===s.pre+"dl_scatterplot"||e===s.pre+"dl_ligplot"||e===s.pre+"dl_contactmap"||e===s.pre+"dl_alignerrormap"||e===s.pre+"dl_interactionsorted"||e===s.pre+"dl_alignment"?($("#"+e).show(),$("#"+e+"_nb").show(),$("#"+e+"_title").html(t),l=.5*s.htmlCls.HEIGHT,n=s.htmlCls.WIDTH,$("#"+e).width(n),$("#"+e).height(l),$("#"+e).resize((function(t){let n=s.htmlCls.WIDTH/2,l=$("#"+e).width()/n;if(e==s.pre+"dl_selectannotations")i.annotationCls.hideFixedTitle();else if(e==s.pre+"dl_graph"){let t=$("#"+e).width(),i=$("#"+e).height();d3.select("#"+s.svgid).attr("width",t).attr("height",i)}else if(e==s.pre+"dl_linegraph"){let e=i.linegraphWidth*l;$("#"+s.linegraphid).attr("width",e)}else if(e==s.pre+"dl_scatterplot"){let e=i.scatterplotWidth*l;$("#"+s.scatterplotid).attr("width",e)}else if(e==s.pre+"dl_ligplot"){let e=i.ligplotWidth*l;$("#"+s.ligplotid).attr("width",e)}else if(e==s.pre+"dl_contactmap"){let e=i.contactmapWidth*l;$("#"+s.contactmapid).attr("width",e)}else if(e==s.pre+"dl_alignerrormap"){let e=i.alignerrormapWidth*l;$("#"+s.alignerrormapid).attr("width",e)}}))):(i.bRender&&($("#"+e).show(),$("#"+e+"_nb").show(),$("#"+e+"_title").html(t)),l="auto",n="auto",e===s.pre+"dl_addtrack"?n="50%":e===s.pre+"dl_2ddgm"||e===s.pre+"dl_2dctn"||e===s.pre+"dl_definedsets"?n=r:e!==s.pre+"dl_allinteraction"&&e!==s.pre+"dl_buriedarea"||(n=700,l=500),$("#"+e).width(n),$("#"+e).height(l))}}class h{constructor(e){this.icn3dui=e}setCustomDialogs(){let e=this.icn3dui;if(e.icn3d,e.bNode)return"";return""}getHtmlAlignResidueByResidue(e,t,s){let i=this.icn3dui;i.icn3d;let n="";return n+="All chains will be aligned to the first chain in the comma-separated chain IDs. Each chain ID has the form of PDBID_chain (e.g., 1HHO_A, case sensitive) or UniprotID (e.g., P69905 for AlphaFold structures).<br/><br/>",n+="<b>Chain IDs</b>: "+i.htmlCls.inputTextStr+"id='"+i.pre+e+"' value='P69905,P01942,1HHO_A' size=50><br/><br/>",n+='Each alignment is defined as " | "-separated residue lists in one line. "10-50" means a range of residues from 10 to 50.<br><textarea id=\''+i.pre+t+"' rows='5' style='width: 100%; height: "+i.htmlCls.LOG_HEIGHT+"px; padding: 0px; border: 0px;'>1,5,10-50 | 1,5,10-50\n2,6,11-51 | 1,5,10-50</textarea><br/>",n+=i.htmlCls.buttonStr+s+"'><b>Align Residue by Residue</b></button><br/>",n}addNotebookTitle(e,t,s){let i=this.icn3dui;i.icn3d;let n='<div id="'+i.pre+e+'_nb" style="display:none; background-color:#5C9CCC; width:100%"><span id="'+i.pre+e+'_title" style="color:white; font-weight:bold">'+t+"</span>&nbsp;&nbsp;&nbsp;<div onclick=\"$('#"+i.pre+e+'\').hide(); return false;" class="icn3d-nbclose ui-icon ui-icon-close" title="Close"></div></div>';return s&&(n+='<div id="'+i.pre+e+'_html"></div>'),n}setDialogs(){let e=this.icn3dui,t=e.icn3d;if(e.bNode)return"";let s="",i="#ffff00";e.htmlCls.optionStr="<option value=",s+="\x3c!-- dialog will not be part of the form --\x3e";let n=e.cfg.notebook?"":"icn3d-hidden",l=e.cfg.notebook?"icn3d-hidden":"";s+=e.htmlCls.divStr+"alldialogs' class='"+n+" icn3d-dialog' style='margin-top:12px'>",s+=e.htmlCls.divStr+"dl_2ddgm' class='"+l+" icn3d-dl_2ddgm' style='background-color:white'>",s+=this.addNotebookTitle("dl_2ddgm","2D Diagram",!0),s+="</div>",s+=e.htmlCls.divStr+"dl_2dctn' class='"+l+" icn3d-dl_2dctn' style='background-color:white'>",s+=this.addNotebookTitle("dl_2dctn","2D Cartoon"),e.svgid_ct=e.pre+"icn3d_cartoon";let r='<button class="icn3d-commandTitle" style="-webkit-appearance:button; height:24px;background-color:#DDD;" id="',o="icn3d-node-text";s+=e.htmlCls.divNowrapStr+"Dynamically generated for selected residues. <br>Nodes can be dragged or clicked.</div>",s+=e.htmlCls.divNowrapStr+r+e.svgid_ct+'_svg">SVG</button>'+e.htmlCls.space2,s+=r+e.svgid_ct+'_png">PNG</button>'+e.htmlCls.space2,s+=r+e.svgid_ct+'_json">JSON</button><br>',s+="<b>Label</b>: <select id='"+e.svgid_ct+"_label'>",s+=e.htmlCls.optionStr+"'"+o+"0'>No</option>",s+=e.htmlCls.optionStr+"'"+o+"4'>4px</option>",s+=e.htmlCls.optionStr+"'"+o+"8' selected>8px</option>",s+=e.htmlCls.optionStr+"'"+o+"12'>12px</option>",s+=e.htmlCls.optionStr+"'"+o+"16'>16px</option>",s+=e.htmlCls.optionStr+"'"+o+"24'>24px</option>",s+=e.htmlCls.optionStr+"'"+o+"32'>32px</option>",s+="</select>",s+="</div>",s+="<svg id='"+e.svgid_ct+"' viewBox='0,0,"+e.htmlCls.width2d+","+e.htmlCls.width2d+"'>",s+="</svg>",s+="</div>",s+=e.htmlCls.divStr+"dl_alignment' class='"+l+"' style='background-color:white;'>",s+=this.addNotebookTitle("dl_alignment","Dynamically Calculated Symmetry using SymD"),s+=e.htmlCls.divStr+"symd_info'></div>",s+=e.htmlCls.divStr+"alignseqguide_wrapper'><br>"+e.htmlCls.setHtmlCls.setAlignSequenceGuide()+"</div>",s+=e.htmlCls.divStr+"dl_sequence2' class='icn3d-dl_sequence'>",s+=this.addNotebookTitle("dl_sequence2","Select Residues in Aligned Sequences"),s+="</div>",s+="</div>",s+=e.htmlCls.divStr+"dl_definedsets' class='"+l+"'>",s+=this.addNotebookTitle("dl_definedsets","Defined Sets"),s+=e.htmlCls.divStr+"dl_setsmenu'>",s+="<b>Defined Sets:</b> <br/>",s+="<select id='"+e.pre+"atomsCustom' multiple size='6' style='min-width:130px;'>",s+="</select>",s+="<div style='margin: 6px 0 6px 0;'>"+e.htmlCls.buttonStr+"deletesets'><b>Delete Selected Sets</b></button></div>",s+='        <b>Set Operations</b>: <div style="width:20px; margin-top:6px; display:inline-block;"><span id="'+e.pre+'dl_command_expand" class="ui-icon ui-icon-plus icn3d-expand icn3d-link" style="width:15px;" title="Expand"></span><span id="'+e.pre+'dl_command_shrink" class="ui-icon ui-icon-minus icn3d-shrink icn3d-link" style="display:none; width:15px;" title="Shrink"></span></div><br>',s+="</div>",s+=e.htmlCls.divStr+"dl_command' style='display:none;'>",s+=e.htmlCls.divStr+"dl_setoperations'>",s+="<label for='"+e.pre+"setOr'>"+e.htmlCls.inputRadioStr+"name='"+e.pre+"setOperation' id='"+e.pre+"setOr' checked> Union(or) </label><br/>",s+="<label for='"+e.pre+"setAnd'>"+e.htmlCls.inputRadioStr+"name='"+e.pre+"setOperation' id='"+e.pre+"setAnd'> Intersection(and) </label><br/>",s+="<label for='"+e.pre+"setNot'>"+e.htmlCls.inputRadioStr+"name='"+e.pre+"setOperation' id='"+e.pre+"setNot'> Exclusion(not) </label>",s+="</div><br>",s+=e.htmlCls.setHtmlCls.setAdvanced(),s+="</div>",s+="</div>",s+=e.htmlCls.setHtmlCls.setAdvanced(2),s+=e.htmlCls.divStr+"dl_vastplus' class='"+l+"' style='max-width:500px'>",s+=this.addNotebookTitle("dl_vastplus","Please input PDB ID for VAST+"),s+="Note: <b>VAST+</b> finds other macromolecular structures that have a similar biological unit. To do this, VAST+ takes into consideration the complete set of 3D domains that VAST identified within a query structure, throughout all of its component protein molecules, and finds other macromolecular structures that have a similar set of proteins/3D domains.<br><br>",s+="PDB ID: "+e.htmlCls.inputTextStr+"id='"+e.pre+"vastpluspdbid' value='6VXX' size=8><br>",s+=e.htmlCls.buttonStr+"reload_vastplus'>VAST+</button>",s+="</div>",s+=e.htmlCls.divStr+"dl_vast' class='"+l+"' style='max-width:500px'>",s+=this.addNotebookTitle("dl_vast","Pleaes input chain or PDB file for VAST"),s+="Note: <b>VAST</b> identifies 3D domains (substructures) within each protein structure in the Molecular Modeling Database (MMDB), and then finds other protein structures that have one or more similar 3D domains, using purely geometric criteria. You have two ways to do a VAST search.<br><br>",s+="<b>Option 1</b>, search with your selection (all residues are selected by default) in the loaded structures:<br>",s+='<form data-ncbi-sg-search="true" method=post enctype=multipart/form-data action="https://www.ncbi.nlm.nih.gov/Structure/vast/VSMmdb.cgi" id="'+e.pre+'newvs2" name="newvs2" target="_blank">',s+='<input type=hidden id="'+e.pre+'pdbstr" name="pdbstr">',s+="Searching against: <input type='radio' name='dataset' value='Non-redundant subset' checked> Medium-redundancy Subset of PDB <a href='https://www.ncbi.nlm.nih.gov/Structure/VAST/vasthelp.html#VASTNR' title='Medium-redundancy Subset' target='_blank'>?</a> <input type='radio' name='dataset' value='All'>All of PDB <br>",s+='<input type="submit" id="'+e.pre+'cmdVSMmdb2" name="cmdVSMmdb" value="Submit"></input>',s+="</form><br>",s+="<b>Option 2</b>, search with PDB ID and chain name:<br>",s+="PDB ID: "+e.htmlCls.inputTextStr+"id='"+e.pre+"vastpdbid' value='4N7N' size=8> &nbsp;&nbsp;",s+="Chain Name: "+e.htmlCls.inputTextStr+"id='"+e.pre+"vastchainid' value='A' size=8> <br>",s+=e.htmlCls.buttonStr+"reload_vast'>VAST</button><br><br>",s+="<b>Option 3</b>, search with a PDB file:<br>",s+='<form data-ncbi-sg-search="true" method=post enctype=multipart/form-data action="https://www.ncbi.nlm.nih.gov/Structure/vast/VSMmdb.cgi" id="'+e.pre+'newvs" name="newvs" target="_blank">',s+="PDB File: "+e.htmlCls.inputFileStr+" name='pdbfile' size=8><br>",s+="Searching against: <input type='radio' name='dataset' value='Non-redundant subset' checked> Medium-redundancy Subset of PDB <a href='https://www.ncbi.nlm.nih.gov/Structure/VAST/vasthelp.html#VASTNR' title='Medium-redundancy Subset' target='_blank'>?</a> <input type='radio' name='dataset' value='All'>All of PDB <br>",s+='<input type="submit" id="'+e.pre+'cmdVSMmdb" name="cmdVSMmdb" value="Submit"></input>',s+="</form><br>",s+="</div>",s+=e.htmlCls.divStr+"dl_foldseek' class='"+l+"' style='max-width:500px'>",s+=this.addNotebookTitle("dl_foldseek","Submit your selection to Foldseek"),s+='1. <input type="submit" id="'+e.pre+'fssubmit" name="fssubmit" value="Submit"></input> your selection (all residues are selected by default) in the loaded structures to <a href="https://search.foldseek.com/search" target="_blank">Foldseek</a> web server.<br><br>',s+='2 (Optional). Once you see the structure neighbors, you can view the alignment in iCn3D by inputing a list of PDB chain IDs or AlphaFold UniProt IDs below. <br><br>The PDB chain IDs are the same as the record names such as "1HHO_A". The UniProt ID is the text between "AF-" and "-F1". For example, the UniProt ID for the record name "AF-P69905-F1-model_v4" is "P69905".<br><br>',s+="Chain ID List: "+e.htmlCls.inputTextStr+"id='"+e.pre+"foldseekchainids' value='P69905,P01942,1HHO_A' size=30> ",s+=e.htmlCls.buttonStr+"reload_foldseek'>Align</button>",s+="</div>",s+=e.htmlCls.divStr+"dl_mmtfid' class='"+l+"'>",s+=this.addNotebookTitle("dl_mmtfid","Please input an BCIF/MMTF ID"),s+="BCIF/MMTF ID: "+e.htmlCls.inputTextStr+"id='"+e.pre+"mmtfid' value='1TUP' size=8> ",s+=e.htmlCls.buttonStr+"reload_mmtf'>Load</button>",s+="</div>",s+=e.htmlCls.divStr+"dl_pdbid' class='"+l+"'>",s+=this.addNotebookTitle("dl_pdbid","Please input a PDB ID"),s+="PDB ID: "+e.htmlCls.inputTextStr+"id='"+e.pre+"pdbid' value='1TUP' size=8> ",s+=e.htmlCls.buttonStr+"reload_pdb'>Load</button>",s+="</div>",s+=e.htmlCls.divStr+"dl_afid' class='"+l+"'>",s+=this.addNotebookTitle("dl_afid","Please input an AlphaFold UniProt ID"),s+="Note: AlphaFold produces a per-residue confidence score (pLDDT) between 0 and 100:<br>",s+=e.htmlCls.clickMenuCls.setAlphaFoldLegend()+"<br>";let a=e.cfg.afid?e.cfg.afid:"A4D1S0";s+="<a href='https://alphafold.ebi.ac.uk/' target='_blank'>AlphaFold Uniprot</a> ID: "+e.htmlCls.inputTextStr+"id='"+e.pre+"afid' value='"+a+"' size=10><br><br>",s+=e.htmlCls.buttonStr+"reload_af'>Load Structure</button><br><br>",s+="PAE Map: "+e.htmlCls.buttonStr+"reload_afmap'>Load Half</button>"+e.htmlCls.buttonStr+"reload_afmapfull' style='margin-left:30px'>Load Full (slow)</button>",s+="</div>",s+=e.htmlCls.divStr+"dl_refseqid' class='"+l+"'>",s+=this.addNotebookTitle("dl_refseqid","Please input an NCBI protein accession"),s+="NCBI Protein Accession: "+e.htmlCls.inputTextStr+"id='"+e.pre+"refseqid' value='NP_001743.1' size=8> ",s+=e.htmlCls.buttonStr+"reload_refseq'>Load</button>",s+="</div>",s+=e.htmlCls.divStr+"dl_opmid' class='"+l+"'>",s+=this.addNotebookTitle("dl_opmid","Please input an OPM PDB ID"),s+="<a href='https://opm.phar.umich.edu' target='_blank'>Orientations of Proteins in Membranes(OPM)</a> PDB ID: "+e.htmlCls.inputTextStr+"id='"+e.pre+"opmid' value='6JXR' size=8> ",s+=e.htmlCls.buttonStr+"reload_opm'>Load</button>",s+="</div>",s+=e.htmlCls.divStr+"dl_pdbfile' class='"+l+"'>",s+=this.addNotebookTitle("dl_pdbfile","Please input a PDB file"),s+='Note: Several PDB files could be concatenated into a single PDB file. Use the line "ENDMDL" to separate PDB files.<br><br>',s+="PDB File: "+e.htmlCls.inputFileStr+" id='"+e.pre+"pdbfile' size=8> ",s+=e.htmlCls.buttonStr+"reload_pdbfile'>Load</button>",s+="</div>",s+=e.htmlCls.divStr+"dl_pdbfile_app' class='"+l+"'>",s+=this.addNotebookTitle("dl_pdbfile_app","Please append PDB files"),s+="Multiple PDB Files: <input type='file' multiple id='"+e.pre+"pdbfile_app' size=8> ",s+=e.htmlCls.buttonStr+"reload_pdbfile_app'>Append</button>",s+="</div>",s+=e.htmlCls.divStr+"dl_rescolorfile' class='"+l+"'>",s+=this.addNotebookTitle("dl_rescolorfile","Please input a residue color file"),s+='<div style="width:450px;">The custom JSON file on residue colors has the following format for proteins("ALA" and "ARG") and nucleotides("G" and "A"):<br>',s+='{"ALA":"#C8C8C8", "ARG":"#145AFF", ..., "G":"#008000", "A":"#6080FF", ...}</div><br>',s+="Residue Color File: "+e.htmlCls.inputFileStr+"id='"+e.pre+"rescolorfile' size=8> ",s+=e.htmlCls.buttonStr+"reload_rescolorfile'>Load</button>",s+="</div>",s+=e.htmlCls.divStr+"dl_customcolor' class='"+l+"'>",s+=this.addNotebookTitle("dl_customcolor","Please input a custom color file"),s+=" <input type='hidden' id='"+e.pre+"customcolor_chainid' value=''>",s+='<div style="width:450px;">The custom file for the structure has two columns separated by space or tab: ',s+='residue number, and score in the range of 0-100. If you click "Apply Custom Color" button, ',s+='the scores 0, 50 and 100 correspond to the three colors specified below. If you click "Apply Custom Tube", ',s+='the selected residues will be displayed in a style similar to "B-factor Tube".</div><br>',s+="Custom File: "+e.htmlCls.inputFileStr+"id='"+e.pre+"cstcolorfile' size=8> <br><br>",s+="1. "+e.htmlCls.buttonStr+"reload_customcolorfile'>Apply Custom Color</button>"+e.htmlCls.buttonStr+"remove_legend' style='margin-left:30px;'>Remove Legend</button><br>",s+="<span style='margin-left:15px'>Score to Color: 0:</span> <select id='"+e.pre+"startColor'>",s+=e.htmlCls.optionStr+"'red'>Red</option>",s+=e.htmlCls.optionStr+"'green'>Green</option>",s+=e.htmlCls.optionStr+"'blue' selected>Blue</option>",s+="</select>",s+="<span style='margin-left:30px'>50</span>: <select id='"+e.pre+"midColor'>",s+=e.htmlCls.optionStr+"'white' selected>White</option>",s+=e.htmlCls.optionStr+"'black'>Black</option>",s+="</select>",s+="<span style='margin-left:30px'>100</span>: <select id='"+e.pre+"endColor'>",s+=e.htmlCls.optionStr+"'red' selected>Red</option>",s+=e.htmlCls.optionStr+"'green'>Green</option>",s+=e.htmlCls.optionStr+"'blue'>Blue</option>",s+="</select><br>",s+="or<br><br>",s+="2. "+e.htmlCls.buttonStr+"reload_customtubefile'>Apply Custom Tube</button>",s+="</div>",s+=e.htmlCls.divStr+"dl_customref' class='"+l+"'>",s+=this.addNotebookTitle("dl_customref","Please input a reference number file"),s+='<div style="width:550px;">You can define your own reference numbers in a custom file using Excel, and then export it as a CSV file. An example file is shown below with cells separated by commas.<br>',s+="<pre>refnum,11,12,,21,22,,10C,11C,20C<br>",s+="1TUP_A,100,101,,,132,,,,<br>",s+="1TUP_B,110,111,,141,142,,,,<br>",s+="1TUP_C,,,,,,,200,201,230</pre>",s+='The first row defines the reference residue numbers, which could be any strings. The 1st cell could be anything. The rest cells are reference residue numbers (e.g., 11, 21, 10C, etc.) or empty cells. Each chain has a separate row. The first cell of the second row is the chain ID "1TUP_A". The rest cells are the corresponding real residue numbers for reference residue numbers in the first row. For example, the reference numbers for residues 100, 101, and 132 in the chain 1TUP_A are 11, 12, and 22, respectively. The fourth row shows another set of reference numners for the chain "1TUP_C". It could be a chain from a different structure.<br><br>',s+='To select all residues corresponding to the reference numbers, you can simplay replace ":" with "%" in the <a href="https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d.html#selectb" target="_blank">Specification</a>. For example, "%12"  selects the residue 101 in 1TUP_A and the residue 111 in 1TUP_B. ".A%12" has the chain "A" filter and selects the residue 101 in 1TUP_A.<br>',s+="</div><br>",s+="Custom File: "+e.htmlCls.inputFileStr+"id='"+e.pre+"cstreffile' size=8> <br><br>",s+=e.htmlCls.buttonStr+"reload_customreffile'>Apply Custom Reference Numbers</button>",s+="</div>",s+=e.htmlCls.divStr+"dl_align' class='"+l+"'>",s+=this.addNotebookTitle("dl_align","Please select residues in aligned sequences"),s+="Enter the PDB IDs or MMDB IDs of the structures: <br/><br/>ID1: "+e.htmlCls.inputTextStr+"id='"+e.pre+"alignid1' value='2DN3' size=8>"+e.htmlCls.space3+e.htmlCls.space3+"ID2: "+e.htmlCls.inputTextStr+"id='"+e.pre+"alignid2' value='4N7N' size=8><br/><br/>",s+="<b>VAST+ based on VAST</b>: "+e.htmlCls.buttonStr+"reload_align_ori'>All Matching Molecules Superposed</button>"+e.htmlCls.space3+e.htmlCls.buttonStr+"reload_align_refined'>Invariant Substructure Superposed</button><br><br>",s+="<b>VAST+ based on TM-align</b>: "+e.htmlCls.buttonStr+"reload_align_tmalign'>All Matching Molecules Superposed</button><br><br>",s+="</div>",s+=e.htmlCls.divStr+"dl_alignaf' class='"+l+"'>",s+=this.addNotebookTitle("dl_alignaf","Align AlphaFold structures"),s+="Enter two <a href='https://alphafold.ebi.ac.uk/' target='_blank'>AlphaFold Uniprot</a> IDs: <br/><br/>ID1: "+e.htmlCls.inputTextStr+"id='"+e.pre+"alignafid1' value='P41327' size=8>"+e.htmlCls.space3+e.htmlCls.space3+"ID2: "+e.htmlCls.inputTextStr+"id='"+e.pre+"alignafid2' value='P41331' size=8><br/><br/>",s+=e.htmlCls.buttonStr+"reload_alignaf_tmalign'>Align with TM-align</button>"+e.htmlCls.buttonStr+"reload_alignaf' style='margin-left:30px'>Align with VAST</button>",s+="</div>",s+=e.htmlCls.divStr+"dl_chainalign' class='"+l+"'>",s+=this.addNotebookTitle("dl_chainalign","Align chains"),s+="<div style='width:550px'>",s+="All chains will be aligned to the first chain in the comma-separated chain IDs. Each chain ID has the form of PDBID_chain (e.g., 1HHO_A, case sensitive) or UniprotID (e.g., P69905 for AlphaFold structures).<br/><br/>",s+="<b>Chain IDs</b>: "+e.htmlCls.inputTextStr+"id='"+e.pre+"chainalignids' value='P69905,P01942,1HHO_A' size=50><br/><br/>",s+=e.htmlCls.buttonStr+"reload_chainalign_tmalign'><b>Align with TM-align</b></button>"+e.htmlCls.buttonStr+"reload_chainalign_asym' style='margin-left:30px'><b>Align with VAST</b></button><br/><br/>",s+='(Note: To align chains in custom PDB files, you could load them in "File > Open File > PDB Files (appendable)" and click "Analysis > Defined Sets". Finally select multiple chains in Defined Sets and click "File > Realign Selection".)<br><br>',s+="</div></div>",s+=e.htmlCls.divStr+"dl_chainalign2' class='"+l+"'>",s+=this.addNotebookTitle("dl_chainalign2","Align chains"),s+="<div style='width:550px'>",s+="All chains will be aligned to the first chain in the comma-separated chain IDs. Each chain ID has the form of PDBID_chain (e.g., 1HHO_A, case sensitive) or UniprotID (e.g., P69905 for AlphaFold structures).<br/><br/>",s+="<b>Chain IDs</b>: "+e.htmlCls.inputTextStr+"id='"+e.pre+"chainalignids2' value='P69905,P01942,1HHO_A' size=50><br/><br/>",s+="The sequence alignment (followed by structure alignment) is based on residue numbers in the First/Master chain: <br>"+e.htmlCls.inputTextStr+"id='"+e.pre+"resalignids' value='1,5,10-50' size=50><br/>",s+=e.htmlCls.buttonStr+"reload_chainalign_asym2' style='margin-top:3px;'><b>Align by Sequence Alignment</b></button><br/><br/>",s+='(Note: To align chains in custom PDB files, you could load them in "File > Open File > PDB Files (appendable)" and click "Analysis > Defined Sets". Finally select multiple chains in Defined Sets and click "File > Realign Selection".)<br><br>',s+="</div></div>",s+=e.htmlCls.divStr+"dl_chainalign3' class='"+l+"'>",s+=this.addNotebookTitle("dl_chainalign3","Align chains"),s+="<div style='width:550px'>",s+=this.getHtmlAlignResidueByResidue("chainalignids3","predefinedres","reload_chainalign_asym3"),s+="</div></div>",s+=e.htmlCls.divStr+"dl_realignresbyres' class='"+l+"'>",s+=this.addNotebookTitle("dl_realignresbyres","Realign residue by residue"),s+="<div style='width:550px'>",s+="<b>Option 1</b>: "+e.htmlCls.buttonStr+"realignSelection'><b>Realign Current Selection Residue by Residue</b></button><br/><br/>",s+="<b>Option 2</b>: <br>",s+="<div class='icn3d-box'>"+this.getHtmlAlignResidueByResidue("chainalignids4","predefinedres2","reload_chainalign_asym4")+"</div>",s+="</div></div>",s+=e.htmlCls.divStr+"dl_mutation' class='"+l+"'>",s+=this.addNotebookTitle("dl_mutation","Mutation analysis"),s+="<div style='width:500px'>",s+='Please specify the mutations with a comma separated mutation list. Each mutation can be specified as "[<b>uppercase</b> PDB ID or AlphaFold UniProt ID]_[Chain Name]_[Residue Number]_[One Letter Mutant Residue]". E.g., the mutation of N501Y in the E chain of PDB 6M0J can be specified as "6M0J_E_501_Y". For AlphaFold structures, the "Chain ID" is "A".<br/>If you load a custom structure without PDB or UniProt ID, you can open "Seq. & Annotations" window and find the chain ID such as "stru_A". The part before the underscore is the structure ID, which can be used to specify the mutation such as "stru_A_...". Remember to choose "Show Mutation in: Current Page".<br/><br/>',s+="<div style='display:inline-block; width:110px'>Mutations: </div>"+e.htmlCls.inputTextStr+"id='"+e.pre+"mutationids' value='6M0J_E_484_K,6M0J_E_501_Y,6M0J_E_417_N' size=50><br/><br/>",s+="<b>ID Type</b>: ",s+='<input type="radio" name="'+e.pre+'idsource" id="'+e.pre+'type_mmdbid" value="mmdbid" checked>PDB ID',s+='<input type="radio" name="'+e.pre+'idsource" id="'+e.pre+'type_afid" value="afid" style="margin-left:20px">AlphaFold UniProt ID<br><br>',s+="<b>Show Mutation in</b>: ",s+='<input type="radio" name="'+e.pre+'pdbsource" id="'+e.pre+'showin_currentpage" value="currentpage">Current Page',s+='<input type="radio" name="'+e.pre+'pdbsource" id="'+e.pre+'showin_newpage" value="newpage" style="margin-left:20px" checked>New Page<br><br>',s+=e.htmlCls.buttonStr+"reload_mutation_3d' title='Show the mutations in 3D using the scap program'>3D with scap</button>",s+=e.htmlCls.buttonStr+"reload_mutation_inter' style='margin-left:20px' title='Show the mutations in 3D and the change of interactions'>Interactions</button>",s+=e.htmlCls.buttonStr+"reload_mutation_pdb' style='margin-left:20px' title='Show the mutations in 3D and export the PDB of the mutant within 10 angstrom'>PDB</button>",s+="<br/><br/></div></div>",s+=e.htmlCls.divStr+"dl_mol2file' class='"+l+"'>",s+=this.addNotebookTitle("dl_mol2file","Please input a Mol2 file"),s+="Mol2 File: "+e.htmlCls.inputFileStr+"id='"+e.pre+"mol2file' size=8> ",s+=e.htmlCls.buttonStr+"reload_mol2file'>Load</button>",s+="</div>",s+=e.htmlCls.divStr+"dl_sdffile' class='"+l+"'>",s+=this.addNotebookTitle("dl_sdffile","Please input an SDF file"),s+="SDF File: "+e.htmlCls.inputFileStr+"id='"+e.pre+"sdffile' size=8> ",s+=e.htmlCls.buttonStr+"reload_sdffile'>Load</button>",s+="</div>",s+=e.htmlCls.divStr+"dl_xyzfile' class='"+l+"'>",s+=this.addNotebookTitle("dl_xyzfile","Please input an XYZ file"),s+="XYZ File: "+e.htmlCls.inputFileStr+"id='"+e.pre+"xyzfile' size=8> ",s+=e.htmlCls.buttonStr+"reload_xyzfile'>Load</button>",s+="</div>",s+=e.htmlCls.divStr+"dl_afmapfile' class='"+l+"'>",s+=this.addNotebookTitle("dl_afmapfile","Please input an AlphaFold PAE file"),s+="AlphaFold PAE File: "+e.htmlCls.inputFileStr+"id='"+e.pre+"afmapfile' size=8> <br><br>",s+=e.htmlCls.buttonStr+"reload_afmapfile'>Load Half PAE Map</button>"+e.htmlCls.buttonStr+"reload_afmapfilefull' style='margin-left:30px'>Load Full PAE Map (slow)</button>",s+="</div>",s+=e.htmlCls.divStr+"dl_urlfile' class='"+l+"'>",s+=this.addNotebookTitle("dl_urlfile","Please input a file via URL"),s+="File type: ",s+="<select id='"+e.pre+"filetype'>",s+=e.htmlCls.optionStr+"'pdb' selected>PDB</option>",s+=e.htmlCls.optionStr+"'mmcif'>mmCIF</option>",s+=e.htmlCls.optionStr+"'mol2'>Mol2</option>",s+=e.htmlCls.optionStr+"'sdf'>SDF</option>",s+=e.htmlCls.optionStr+"'xyz'>XYZ</option>",s+=e.htmlCls.optionStr+"'icn3dpng'>iCn3D PNG</option>",s+=e.htmlCls.optionStr+"'pae'>AlphaFold PAE</option>",s+="</select><br/>",s+="URL in the same host: "+e.htmlCls.inputTextStr+"id='"+e.pre+"urlfile' size=20><br/> ",s+=e.htmlCls.buttonStr+"reload_urlfile'>Load</button>",s+="</div>",s+=e.htmlCls.divStr+"dl_mmciffile' class='"+l+"'>",s+=this.addNotebookTitle("dl_mmciffile","Please append mmCIF files"),s+="Multiple mmCIF Files: <input type='file' multiple id='"+e.pre+"mmciffile' size=8> ",s+=e.htmlCls.buttonStr+"reload_mmciffile'>Load</button>",s+="</div>",s+=e.htmlCls.divStr+"dl_mmcifid' class='"+l+"'>",s+=this.addNotebookTitle("dl_mmcifid","Please input an mmCIF ID"),s+="mmCIF ID: "+e.htmlCls.inputTextStr+"id='"+e.pre+"mmcifid' value='1TUP' size=8> ",s+=e.htmlCls.buttonStr+"reload_mmcif'>Load</button>",s+="</div>",s+=e.htmlCls.divStr+"dl_mmdbid' class='"+l+"' style='max-width:500px'>",s+=this.addNotebookTitle("dl_mmdbid","Please input an MMDB ID"),s+="MMDB or PDB ID: "+e.htmlCls.inputTextStr+"id='"+e.pre+"mmdbid' value='1TUP' size=8> <br><br>",s+=e.htmlCls.buttonStr+"reload_mmdb'>Load Biological Unit</button>"+e.htmlCls.buttonStr+"reload_mmdb_asym' style='margin-left:30px'>Load Asymmetric Unit (All Chains)</button><br/><br/><br/>",s+='<b>Note</b>: The "<b>biological unit</b>" is the <b>biochemically active form of a biomolecule</b>, <div style="width:20px; margin:6px 0 0 20px; display:inline-block;"><span id="'+e.pre+'asu_bu_expand" class="ui-icon ui-icon-plus icn3d-expand icn3d-link" style="width:15px;" title="Expand"></span><span id="'+e.pre+'asu_bu_shrink" class="ui-icon ui-icon-minus icn3d-shrink icn3d-link" style="display:none; width:15px;" title="Shrink"></span></div>',s+=e.htmlCls.divStr+"asu_bu' style='display:none;'>",s+='which can range from a monomer (single protein molecule) to an oligomer of 100+ protein molecules.<br><br>The "<b>asymmetric unit</b>" is the raw 3D structure data resolved by X-ray crystallography, NMR, or Cryo-electron microscopy. The asymmetric unit is equivalent to the biological unit in approximately 60% of structure records. In the remaining 40% of the records, the asymmetric unit represents a portion of the biological unit that can be reconstructed using crystallographic symmetry, or it represents multiple copies of the biological unit.</div>',s+="</div>",s+=e.htmlCls.divStr+"dl_mmdbafid' class='"+l+"' style='max-width:600px'>",s+=this.addNotebookTitle("dl_mmdbafid","Please input a list of PDB/AlphaFold IDs"),s+="List of PDB, MMDB, or AlphaFold UniProt structures: "+e.htmlCls.inputTextStr+"id='"+e.pre+"mmdbafid' placeholder='e.g., 1HHO,4N7N,P69905,P01942' size=30> <br><br>",s+="<div style='display:inline-block; width:20px'></div>"+e.htmlCls.buttonStr+"reload_mmdbaf' style='width:150px'>Load Biological Unit</button>"+e.htmlCls.buttonStr+"reload_mmdbaf_asym' style='margin-left:30px; width:250px'>Load Asymmetric Unit (All Chains)</button><br/><br/>",s+="<div style='display:inline-block; width:20px'>or</div>"+e.htmlCls.buttonStr+"reload_mmdbaf_append' style='width:150px'>Append Biological Unit</button>"+e.htmlCls.buttonStr+"reload_mmdbaf_asym_append' style='margin-left:30px; width:250px'>Append Asymmetric Unit (All Chains)</button><br/><br/>",s+='<b>Note</b>: The "<b>biological unit</b>" is the <b>biochemically active form of a biomolecule</b>, <div style="width:20px; margin:6px 0 0 20px; display:inline-block;"><span id="'+e.pre+'asu_bu2_expand" class="ui-icon ui-icon-plus icn3d-expand icn3d-link" style="width:15px;" title="Expand"></span><span id="'+e.pre+'asu_bu2_shrink" class="ui-icon ui-icon-minus icn3d-shrink icn3d-link" style="display:none; width:15px;" title="Shrink"></span></div>',s+=e.htmlCls.divStr+"asu_bu2' style='display:none;'>",s+='which can range from a monomer (single protein molecule) to an oligomer of 100+ protein molecules.<br><br>The "<b>asymmetric unit</b>" is the raw 3D structure data resolved by X-ray crystallography, NMR, or Cryo-electron microscopy. The asymmetric unit is equivalent to the biological unit in approximately 60% of structure records. In the remaining 40% of the records, the asymmetric unit represents a portion of the biological unit that can be reconstructed using crystallographic symmetry, or it represents multiple copies of the biological unit.</div>',s+="</div>",s+=e.htmlCls.divStr+"dl_blast_rep_id' style='max-width:600px;' class='"+l+"'>",s+=this.addNotebookTitle("dl_blast_rep_id","Align sequence to structure"),s+="Enter a protein sequence ID (or FASTA sequence) and the aligned protein accession, which can be found using the <a href='https://blast.ncbi.nlm.nih.gov/Blast.cgi?PROGRAM=blastp&PAGE_TYPE=BlastSearch' target='_blank'>BLAST</a> search with the protein sequence ID or FASTA sequence as input. If the protein accession is not a PDB chain, the corresponding AlphaFold UniProt structure is used.<br><br> ",s+="<b>Protein Sequence ID</b>(NCBI protein accession of a sequence): "+e.htmlCls.inputTextStr+"id='"+e.pre+"query_id' value='NP_001108451.1' size=8><br> ",s+="or FASTA sequence: <br><textarea id='"+e.pre+"query_fasta' rows='5' style='width: 100%; height: "+e.htmlCls.LOG_HEIGHT+"px; padding: 0px; border: 0px;'></textarea><br><br>",s+="<b>Aligned Protein Accession</b> (or a chain of a PDB): "+e.htmlCls.inputTextStr+"id='"+e.pre+"blast_rep_id' value='1TSR_A' size=8><br> ",s+=e.htmlCls.buttonStr+"reload_blast_rep_id'>Align with BLAST</button> "+e.htmlCls.wifiStr+e.htmlCls.buttonStr+"reload_alignsw' style='margin-left:30px'>Align with Global Smith-Waterman</button>"+e.htmlCls.buttonStr+"reload_alignswlocal' style='margin-left:30px'>Align with Local Smith-Waterman</button>",s+="</div>",s+=e.htmlCls.divStr+"dl_esmfold' style='max-width:600px;' class='"+l+"'>",s+=this.addNotebookTitle("dl_esmfold","Sequence to structure prediction with ESMFold"),s+="The sequence to structure prediction is done via <a href='https://esmatlas.com/resources?action=fold' target='_blank'>ESM Metagenomic Atlas</a>. The sequence should be less than 400 characters. For any sequence longer than 400, please see the discussion <a href='https://github.com/facebookresearch/esm/issues/21' target='_blank'>here</a>.<br><br> ",s+="FASTA sequence: <br><textarea id='"+e.pre+"esmfold_fasta' rows='5' style='width: 100%; height: "+e.htmlCls.LOG_HEIGHT+"px; padding: 0px; border: 0px;'></textarea><br><br>",s+=e.htmlCls.buttonStr+"run_esmfold'>ESMFold</button> ",s+="</div>",s+=e.htmlCls.divStr+"dl_yournote' class='"+l+"'>",s+=this.addNotebookTitle("dl_yournote","Your Note"),s+='Your note will be saved in the HTML file when you click "File > Save File > iCn3D PNG Image".<br><br>',s+="<textarea id='"+e.pre+"yournote' rows='5' style='width: 100%; height: "+e.htmlCls.LOG_HEIGHT+"px; padding: 0px; border: 0px;' placeholder='Enter your note here'></textarea><br>",s+=e.htmlCls.buttonStr+"applyyournote'>Save</button>",s+="</div>",s+=e.htmlCls.divStr+"dl_proteinname' class='"+l+"'>",s+=this.addNotebookTitle("dl_proteinname","Please input a protein/gene name"),s+="Protein/Gene name: "+e.htmlCls.inputTextStr+"id='"+e.pre+"proteinname' value='TP53' size=8> ",s+=e.htmlCls.buttonStr+"reload_proteinname'>Search</button>",s+="</div>",s+=e.htmlCls.divStr+"dl_cid' class='"+l+"'>",s+=this.addNotebookTitle("dl_cid","Please input a PubChem Compound"),s+="PubChem CID/Name/InchI: "+e.htmlCls.inputTextStr+"id='"+e.pre+"cid' value='2244' size=8> ",s+=e.htmlCls.buttonStr+"reload_cid'>Load</button>",s+="</div>",s+=e.htmlCls.divStr+"dl_smiles' class='"+l+"'>",s+=this.addNotebookTitle("dl_cid","Please input a chemical SMILES"),s+="Chemical SMILES: "+e.htmlCls.inputTextStr+"id='"+e.pre+"smiles' value='CC(=O)OC1=CC=CC=C1C(=O)O' size=30> ",s+=e.htmlCls.buttonStr+"reload_smiles'>Load</button>",s+="</div>",s+=e.htmlCls.divStr+"dl_pngimage' class='"+l+"'>",s+=this.addNotebookTitle("dl_pngimage","Please append iCn3D PNG Image files"),s+="Multiple iCn3D PNG images: "+e.htmlCls.inputFileStr+" multiple id='"+e.pre+"pngimage' size=8><br/>",s+=e.htmlCls.buttonStr+"reload_pngimage' style='margin-top: 6px;'>Append</button>",s+="</div>",s+=e.htmlCls.divStr+"dl_state' class='"+l+"'>",s+=this.addNotebookTitle("dl_state","Please input a state file"),s+="State file: "+e.htmlCls.inputFileStr+"id='"+e.pre+"state'><br/>",s+=e.htmlCls.buttonStr+"reload_state' style='margin-top: 6px;'>Load</button>",s+="</div>",s+=e.htmlCls.divStr+"dl_fixedversion' style='max-width:500px' class='"+l+"'>",s+=this.addNotebookTitle("dl_fixedversion","Use fixed version of iCn3D"),s+='Since January 6, 2021, you can show the original view with the archived version of iCn3D by pasting your URL below and click "Show Originial View". Note the version in the parameter "v" was used to replace "full.html" with "full_[v].html" in the URL.<br><br>',s+="Share Link URL: "+e.htmlCls.inputTextStr+"id='"+e.pre+"sharelinkurl' size=60><br>",s+=e.htmlCls.buttonStr+"reload_fixedversion'>Show Original View</button><br><br>",s+="</div>",s+=e.htmlCls.divStr+"dl_selection' class='"+l+"'>",s+=this.addNotebookTitle("dl_selection","Please input the selection file"),s+="Selection file: "+e.htmlCls.inputFileStr+"id='"+e.pre+"selectionfile'><br/>",s+=e.htmlCls.buttonStr+"reload_selectionfile' style='margin-top: 6px;'>Load</button>",s+="</div>",s+=e.htmlCls.divStr+"dl_selectCollections' class='"+l+"'>",s+=e.htmlCls.divStr+"dl_collectionsMenu'>",s+='<b>Collection File</b>: <div style="width:20px; margin-top:6px; display:inline-block;"><span id="'+e.pre+'dl_collection_file_expand" class="ui-icon ui-icon-plus icn3d-expand icn3d-link" style="display:none; width:15px;" title="Expand"></span><span id="'+e.pre+'dl_collection_file_shrink" class="ui-icon ui-icon-minus icn3d-shrink icn3d-link" style="width:15px;" title="Shrink"></span></div><br>',s+=e.htmlCls.divStr+"dl_collection_file' style=''>",s+="You can load a collection of structures via a file. Here are <a href='https://github.com/ncbi/icn3d/blob/master/example/collection/' target='_blank'>some example files</a><br><br>",s+="Collection file: "+e.htmlCls.inputFileStr+"id='"+e.pre+"collectionfile'><br/>",s+="<input type='radio' id='dl_collectionAppendStructureNone' name='appendStructure' value='none' checked/>",s+="<label for='dl_collectionAppendStructureNone'>Default</label>",s+="<input type='radio' id='dl_collectionAppendStructure' name='appendStructure' value='append' />",s+="<label for='dl_collectionAppendStructure'>Append</label><br/>",s+=e.htmlCls.buttonStr+"reload_collectionfile' style='margin-top: 6px;'>Load</button>",s+="</div>",s+="</div>",s+='<br/><b>Structures</b>: <div style="width:20px; margin-top:6px; display:inline-block;"><span id="'+e.pre+'dl_collection_structures_expand" class="ui-icon ui-icon-plus icn3d-expand icn3d-link" style="width:15px;" title="Expand"></span><span id="'+e.pre+'dl_collection_structures_shrink" class="ui-icon ui-icon-minus icn3d-shrink icn3d-link" style="display:none; width:15px;" title="Shrink"></span></div><br>',s+=e.htmlCls.divStr+"dl_collection_structures' style='display: none'>",s+="<select id='"+e.pre+"collections_menu'multiple size='6' style='min-width:300px;'></select>",s+="<br/>",s+=e.htmlCls.buttonStr+"collections_clear_commands' style='margin-top: 6px;'>Clear Commands</button>",s+=e.htmlCls.buttonStr+"opendl_export_collections'>Export JSON</button>",s+="</div>",s+="<br/>",s+="</div>",s+=e.htmlCls.divStr+"dl_export_collections' class='"+l+"'>",s+=this.addNotebookTitle("dl_export_collections","Export Collections"),s+="<label for='dl_collectionTitle'>Collection Title: </label>",s+="<input type='text' id='dl_collectionTitle' name='collectionTitle' placeholder='Enter collection title' />",s+="<br/>",s+="<label for='dl_collectionDescription'>Collection Description: </label>",s+="<input type='text' id='dl_collectionDescription' name='collectionDescription' placeholder='Enter collection description' />",s+="<br/>",s+="<input type='radio' id='dl_collectionExportSelected' name='exportOption' value='selected' />",s+="<label for='dl_collectionExportSelected'>Selected</label>",s+="<input type='radio' id='dl_collectionExportAll' name='exportOption' value='all' />",s+="<label for='dl_collectionExportAll'>All</label>",s+="<br/>",s+=e.htmlCls.buttonStr+"export_collections'>Export</button>",s+="</div>",s+=e.htmlCls.divStr+"dl_menuloadpref' class='"+l+"'>",s+=this.addNotebookTitle("dl_menuloadpref","Load a preference file"),s+="Preference file: "+e.htmlCls.inputFileStr+"id='"+e.pre+"menupreffile'><br/>",s+=e.htmlCls.buttonStr+"reload_menupreffile' style='margin-top: 6px;'>Load</button>",s+="</div>",s+=e.htmlCls.divStr+"dl_dsn6' class='"+l+"' style='max-width:600px'>",s+=this.addNotebookTitle("dl_dsn6","Load a map file"),s+="<b>Note</b>: Always load a PDB file before loading map files. If you don't specify the threshold below, a default one will be chosen.<br/><br/><br/>",s+="<span style='white-space:nowrap;font-weight:bold;'>2fofc contour at default threshold or at: "+e.htmlCls.inputTextStr+"id='"+e.pre+"dsn6sigma2fofc' value='' size=8> &sigma;</span><br/>",s+=e.htmlCls.inputFileStr+"id='"+e.pre+"dsn6file2fofc'><br>"+e.htmlCls.buttonStr+"reload_ccp4file2fofc' style='margin: 6px 20px 0 0;'>Load CCP4</button>"+e.htmlCls.buttonStr+"reload_mtzfile2fofc' style='margin: 6px 20px 0 0;'>Load MTZ</button>"+e.htmlCls.buttonStr+"reload_rcsbmtzfile2fofc' style='margin-top: 6px;'>Load RCSB MTZ</button><br><br><br/>",s+="<span style='white-space:nowrap;font-weight:bold;'>fofc contour at default threshold or at: "+e.htmlCls.inputTextStr+"id='"+e.pre+"dsn6sigmafofc' value='' size=8> &sigma;</span><br/>",s+=e.htmlCls.inputFileStr+"id='"+e.pre+"dsn6filefofc'><br>"+e.htmlCls.buttonStr+"reload_ccp4filefofc' style='margin: 6px 20px 0 0;'>Load CCP4</button>"+e.htmlCls.buttonStr+"reload_mtzfilefofc' style='margin: 6px 20px 0 0;'>Load MTZ</button>"+e.htmlCls.buttonStr+"reload_rcsbmtzfilefofc' style='margin-top: 6px;'>Load RCSB MTZ</button><br><br><br>",s+=e.htmlCls.buttonStr+"elecmapNo4'>Remove Map</button><br>",s+="</div>",s+=e.htmlCls.divStr+"dl_dsn6url' class='"+l+"' style='max-width:600px'>",s+=this.addNotebookTitle("dl_dsn6url","Load a selection file via a URL"),s+="<b>Note</b>: Always load a PDB file before loading map files. If you don't specify the threshold below, a default one will be chosen.<br/><br/><br/>",s+="<span style='white-space:nowrap;font-weight:bold;'>2fofc contour at default threshold or at: "+e.htmlCls.inputTextStr+"id='"+e.pre+"dsn6sigmaurl2fofc' value='' size=8> &sigma;</span><br/>",s+="URL in the same host: "+e.htmlCls.inputTextStr+"id='"+e.pre+"dsn6fileurl2fofc' size=20><br>"+e.htmlCls.buttonStr+"reload_ccp4fileurl2fofc' style='margin: 6px 20px 0 0;'>Load CCP4</button>"+e.htmlCls.buttonStr+"reload_mtzfileurl2fofc' style='margin: 6px 20px 0 0;'>Load MTZ</button>"+e.htmlCls.buttonStr+"reload_rcsbmtzfileurl2fofc' style='margin-top: 6px;'>Load RCSB MTZ</button><br><br><br/>",s+="<span style='white-space:nowrap;font-weight:bold;'>fofc contour at default threshold or at: "+e.htmlCls.inputTextStr+"id='"+e.pre+"dsn6sigmaurlfofc' value='' size=8> &sigma;</span><br/>",s+="URL in the same host: "+e.htmlCls.inputTextStr+"id='"+e.pre+"dsn6fileurlfofc' size=20><br>"+e.htmlCls.buttonStr+"reload_ccp4fileurlfofc' style='margin: 6px 20px 0 0;'>Load CCP4</button>"+e.htmlCls.buttonStr+"reload_mtzfileurlfofc' style='margin: 6px 20px 0 0;'>Load MTZ</button>"+e.htmlCls.buttonStr+"reload_rcsbmtzfileurlfofc' style='margin-top: 6px;'>Load RCSB MTZ</button><br><br><br>",s+=e.htmlCls.buttonStr+"elecmapNo5'>Remove Map</button><br>",s+="</div>",s+=e.htmlCls.divStr+"dl_clr' class='"+l+"'>",s+=this.addNotebookTitle("dl_clr","Pick a color"),s+="Click in the input box to use the color picker:<br><br> ",s+="Custom Color: "+e.htmlCls.inputTextStr+"id='"+e.pre+"colorcustom' value='FF0000' size=8> ",s+=e.htmlCls.buttonStr+"applycustomcolor'>Apply</button>",s+="</div>",s+=e.htmlCls.setHtmlCls.getPotentialHtml("delphi",l),s+=e.htmlCls.setHtmlCls.getPotentialHtml("local",l),s+=e.htmlCls.setHtmlCls.getPotentialHtml("url",l),s+=e.htmlCls.divStr+"dl_symmetry' class='"+l+"'><br>",s+=this.addNotebookTitle("dl_symmetry","Symmetry"),s+=e.htmlCls.divNowrapStr+"Symmetry: <select id='"+e.pre+"selectSymmetry'>",s+="</select>"+e.htmlCls.space3,s+=e.htmlCls.buttonStr+"applysymmetry'>Apply</button>"+e.htmlCls.space3,s+=e.htmlCls.buttonStr+"clearsymmetry'>Clear</button></div>",s+="</div>",s+=e.htmlCls.divStr+"dl_symd' style='max-width:400px' class='"+l+"'><br>",s+=this.addNotebookTitle("dl_symd","Dynamically symmetry calculation using SymD"),s+="</div>",s+=e.htmlCls.divStr+"dl_contact' class='"+l+"'>",s+=this.addNotebookTitle("dl_contact","Contact Map"),s+="<span style='white-space:nowrap;font-weight:bold;'>Distance: <select id='"+e.pre+"contactdist'>",s+=e.htmlCls.setHtmlCls.getOptionHtml(["4","5","6","7","8","9","10"],4),s+="</select></span>",s+="<span style='margin-left:30px; white-space:nowrap;font-weight:bold;'>Contact Type: <select id='"+e.pre+"contacttype'>",s+=e.htmlCls.optionStr+"'calpha' >between C-alpha Atoms</option>",s+=e.htmlCls.optionStr+"'cbeta' selected>between C-beta Atoms</option>",s+=e.htmlCls.optionStr+"'heavyatoms' >between Heavy Atoms</option>",s+="</select></span><br><br>",s+="<span style='white-space:nowrap;'>"+e.htmlCls.buttonStr+"applycontactmap'>Display</button></span><br>",s+="</div>",s+=e.htmlCls.divStr+"dl_hbonds' class='"+l+"'>",s+=this.addNotebookTitle("dl_hbonds","Interaction Analysis"),s+="1. Choose interaction types and their thresholds:<br>",s+="<div class='icn3d-box'><table border=0 width=450><tr>",s+="<td style='white-space:nowrap'>"+e.htmlCls.inputCheckStr+"id='"+e.pre+"analysis_hbond' checked>Hydrogen Bonds <span style='background-color:#"+e.htmlCls.hbondColor+"'>"+e.htmlCls.space3+"</span></td>",s+="<td>",s+=e.htmlCls.divNowrapStr+" <select id='"+e.pre+"hbondthreshold'>";let d=["3.2","3.3","3.4","3.5","3.6","3.7","3.8","3.9","4.0","4.1","4.2"];s+=e.htmlCls.setHtmlCls.getOptionHtml(d,6),s+="</select> &#197;"+e.htmlCls.space3+"</div></td>",s+="<td style='white-space:nowrap'>"+e.htmlCls.inputCheckStr+"id='"+e.pre+"analysis_saltbridge' checked>Salt Bridge/Ionic <span style='background-color:#"+e.htmlCls.ionicColor+"'>"+e.htmlCls.space3+"</span></td>",s+="<td>",s+=e.htmlCls.divNowrapStr+" <select id='"+e.pre+"saltbridgethreshold'>";let c=["3","4","5","6","7","8"];s+=e.htmlCls.setHtmlCls.getOptionHtml(c,3),s+="</select> &#197;"+e.htmlCls.space3+"</div></td>",s+="<td style='white-space:nowrap'>"+e.htmlCls.inputCheckStr+"id='"+e.pre+"analysis_contact' checked>Contacts/Interactions <span style='background-color:#"+e.htmlCls.contactColor+"'>"+e.htmlCls.space3+"</span></td>",s+="<td>",s+=e.htmlCls.divNowrapStr+" <select id='"+e.pre+"contactthreshold'>",s+=e.htmlCls.setHtmlCls.getOptionHtml(c,1),s+="</select> &#197;"+e.htmlCls.space3+"</div></td>",s+="</tr>",s+="<tr>",s+="<td style='white-space:nowrap'>"+e.htmlCls.inputCheckStr+"id='"+e.pre+"analysis_halogen' checked>Halogen Bonds <span style='background-color:#"+e.htmlCls.halogenColor+"'>"+e.htmlCls.space3+"</span></td>",s+="<td>",s+=e.htmlCls.divNowrapStr+" <select id='"+e.pre+"halogenthreshold'>",s+=e.htmlCls.setHtmlCls.getOptionHtml(d,6),s+="</select> &#197;"+e.htmlCls.space3+"</div></td>",s+="<td style='white-space:nowrap'>"+e.htmlCls.inputCheckStr+"id='"+e.pre+"analysis_pication' checked>&pi;-Cation <span style='background-color:#"+e.htmlCls.picationColor+"'>"+e.htmlCls.space3+"</span></td>",s+="<td>",s+=e.htmlCls.divNowrapStr+" <select id='"+e.pre+"picationthreshold'>",s+=e.htmlCls.setHtmlCls.getOptionHtml(c,3),s+="</select> &#197;"+e.htmlCls.space3+"</div></td>",s+="<td style='white-space:nowrap'>"+e.htmlCls.inputCheckStr+"id='"+e.pre+"analysis_pistacking' checked>&pi;-Stacking <span style='background-color:#"+e.htmlCls.pistackingColor+"'>"+e.htmlCls.space3+"</span></td>",s+="<td>",s+=e.htmlCls.divNowrapStr+" <select id='"+e.pre+"pistackingthreshold'>",s+=e.htmlCls.setHtmlCls.getOptionHtml(["3","4","5"],99),s+=e.htmlCls.optionStr+"'5.5' selected>5.5</option>",s+=e.htmlCls.setHtmlCls.getOptionHtml(["6","7","8"],99),s+="</select> &#197;"+e.htmlCls.space3+"</div></td>",s+="</tr></table></div>",s+="<table border=0 width=400 cellspacing=10><tr><td>",s+=e.htmlCls.divNowrapStr+"2. Select the first set:</div>",s+="<div style='text-indent:1.1em'><select style='max-width:200px' id='"+e.pre+"atomsCustomHbond2' multiple size='5' style='min-width:130px;'>",s+="</select></div>",s+="</td><td>",s+=e.htmlCls.divNowrapStr+"3. Select the second set:</div>",s+="<div style='text-indent:1.1em'><select style='max-width:200px' id='"+e.pre+"atomsCustomHbond' multiple size='5' style='min-width:130px;'>",s+="</select></div>",s+="</td></tr></table>",s+="<div>4. "+e.htmlCls.buttonStr+"applyhbonds'>3D Display Interactions</button></div><br>",s+="<div style='text-indent:1.1em'>"+e.htmlCls.buttonStr+"hbondWindow'>Highlight Interactions in Table</button><span style='margin-left:30px; font-wieght:bold'>Sort Interactions on</span>: "+e.htmlCls.buttonStr+"sortSet1'> Set 1</button>"+e.htmlCls.buttonStr+"sortSet2' style='margin-left:12px'>Set 2</button></div><br>",s+="<div style='text-indent:1.1em'>"+e.htmlCls.buttonStr+"hbondLineGraph'>2D Interaction Network</button> "+e.htmlCls.buttonStr+"hbondLineGraph2' style='margin-left:12px'>2D Network with Reference Numbers</button> to show two lines of residue nodes</div><br>",s+="<div style='text-indent:1.1em'>"+e.htmlCls.buttonStr+"hbondScatterplot'>2D Interaction Map</button> "+e.htmlCls.buttonStr+"hbondScatterplot2' style='margin-left:12px'>2D Map with Reference Numbers</button> to show map</div><br>",s+="<div style='text-indent:1.1em'>"+e.htmlCls.buttonStr+"hbondLigplot'>2D Interaction for One Ligand/Residue</button> with atom details</div><br>",o=': </td><td><input style="margin-left:-12px" type="text" id="',s+="<div style='text-indent:1.1em'>"+e.htmlCls.buttonStr+"hbondGraph'>2D Graph(Force-Directed)</button> to show interactions with strength parameters in 0-200:</div>",s+='<div style="text-indent:1.1em"><table><tr><td>Helix or Sheet'+o+e.pre+'dist_ss" size="4" value="100"></td>',s+="<td>Coil or Nucleotide"+o+e.pre+'dist_coil" size="4" value="50"></td>',s+="<td>Disulfide Bonds"+o+e.pre+'dist_ssbond" size="4" value="50"></td></tr>',s+="<tr><td>Hydrogen Bonds"+o+e.pre+'dist_hbond" size="4" value="50"></td>',s+="<td>Salt Bridge/Ionic"+o+e.pre+'dist_ionic" size="4" value="50"></td>',s+="<td>Contacts"+o+e.pre+'dist_inter" size="4" value="25"></td></tr>',s+="<tr><td>Halogen Bonds"+o+e.pre+'dist_halogen" size="4" value="50"></td>',s+="<td>&pi;-Cation"+o+e.pre+'dist_pication" size="4" value="50"></td>',s+="<td>&pi;-Stacking"+o+e.pre+'dist_pistacking" size="4" value="50"></td></tr></table></div>',s+='<div style="text-indent:1.1em">(Note: you can also adjust thresholds at #1 to add/remove interactions.)</div><br>',s+="<div style='text-indent:1.1em'>"+e.htmlCls.buttonStr+"areaWindow'>Buried Surface Area</button></div><br>",s+="<div>5. "+e.htmlCls.buttonStr+"hbondReset'>Reset</button> and select new sets</div>",s+="</div>",s+=e.htmlCls.divStr+"dl_realign' class='"+l+"'>",s+=this.addNotebookTitle("dl_realign","Realign by sequence"),s+=e.htmlCls.divNowrapStr+"1. Select sets below <br>or use your current selection:</div><br>",s+="<div style='text-indent:1.1em'><select id='"+e.pre+"atomsCustomRealign' multiple size='5' style='min-width:130px;'>",s+="</select></div><br>",s+="<div>2. "+e.htmlCls.buttonStr+"applyRealign'>Realign by Sequence</button></div><br>",s+="</div>",s+=e.htmlCls.divStr+"dl_realignbystruct' class='"+l+"' style='max-width:500px'>",s+=this.addNotebookTitle("dl_realignbystruct","Realign by structure"),s+="<div><b>1</b>. Select sets below or use your current selection.</div><br>",s+="<div style='text-indent:1.1em'><select id='"+e.pre+"atomsCustomRealignByStruct' multiple size='5' style='min-width:130px;'>",s+="</select></div><br>",s+="<div><b>2</b>. "+e.htmlCls.buttonStr+"applyRealignByStruct_tmalign'>Realign with TM-align</button>"+e.htmlCls.buttonStr+"applyRealignByStruct' style='margin-left:30px'>Realign with VAST</button></div><br>",s+="</div>",s+=e.htmlCls.divStr+"dl_realigntwostru' class='"+l+"'>",s+=this.addNotebookTitle("dl_realigntwostru","Realign two structure complexes"),s+=e.htmlCls.divNowrapStr+"1. Select sets below or use your current selection:</div><br>",s+="<div style='text-indent:1.1em'><select id='"+e.pre+"atomsCustomRealignByStruct2' multiple size='5' style='min-width:130px;'>",s+="</select></div><br>",s+="2. Overall maximum RMSD: "+e.htmlCls.inputTextStr+"id='"+e.pre+"maxrmsd' value='30' size='2'> &#197; <br><br>",s+="<div>3. "+e.htmlCls.buttonStr+"applyRealignByStruct_vastplus'>VAST+ Alignment based on TM-align</button></div><br>",s+="</div>",s+=e.htmlCls.divStr+"dl_colorspectrumacrosssets' class='"+l+"'>",s+=this.addNotebookTitle("dl_colorspectrumacrosssets","Set color spectrum across sets"),s+=e.htmlCls.divNowrapStr+"1. Select sets below:</div><br>",s+="<div style='text-indent:1.1em'><select id='"+e.pre+"atomsCustomColorSpectrumAcross' multiple size='5' style='min-width:130px;'>",s+="</select></div>",s+="<div>2. "+e.htmlCls.buttonStr+"applyColorSpectrumAcrossSets'>Spectrum Color for Sets</button></div><br>",s+="</div>",s+=e.htmlCls.divStr+"dl_colorspectrumbysets' class='"+l+"'>",s+=this.addNotebookTitle("dl_colorspectrumbysets","Set color spectrum for residues in sets"),s+=e.htmlCls.divNowrapStr+"1. Select sets below:</div><br>",s+="<div style='text-indent:1.1em'><select id='"+e.pre+"atomsCustomColorSpectrum' multiple size='5' style='min-width:130px;'>",s+="</select></div>",s+="<div>2. "+e.htmlCls.buttonStr+"applyColorSpectrumBySets'>Spectrum Color for Residues in Sets</button></div><br>",s+="</div>",s+=e.htmlCls.divStr+"dl_colorrainbowacrosssets' class='"+l+"'>",s+=this.addNotebookTitle("dl_colorrainbowacrosssets","Set color rainbow across sets"),s+=e.htmlCls.divNowrapStr+"1. Select sets below:</div><br>",s+="<div style='text-indent:1.1em'><select id='"+e.pre+"atomsCustomColorRainbowAcross' multiple size='5' style='min-width:130px;'>",s+="</select></div>",s+="<div>2. "+e.htmlCls.buttonStr+"applyColorRainbowAcrossSets'>Rainbow Color for Sets</button></div><br>",s+="</div>",s+=e.htmlCls.divStr+"dl_colorrainbowbysets' class='"+l+"'>",s+=this.addNotebookTitle("dl_colorrainbowbysets","Set color rainbow for residues in sets"),s+=e.htmlCls.divNowrapStr+"1. Select sets below:</div><br>",s+="<div style='text-indent:1.1em'><select id='"+e.pre+"atomsCustomColorRainbow' multiple size='5' style='min-width:130px;'>",s+="</select></div>",s+="<div>2. "+e.htmlCls.buttonStr+"applyColorRainbowBySets'>Rainbow Color for Residues in Sets</button></div><br>",s+="</div>",s+=e.htmlCls.divStr+"dl_allinteraction' style='background-color:white' class='"+l+"'>",s+=this.addNotebookTitle("dl_allinteraction","All interactions",!0),s+="</div>",s+=e.htmlCls.divStr+"dl_interactionsorted' style='background-color:white' class='"+l+"'>",s+=this.addNotebookTitle("dl_interactionsorted","Sorted interactions",!0),s+="</div>",s+=e.htmlCls.divStr+"dl_linegraph' style='background-color:white' class='"+l+"'>",s+=this.addNotebookTitle("dl_linegraph","2D Interaction Network"),s+=e.htmlCls.divNowrapStr+'<div style="width:20px; margin-top:6px; display:inline-block;"><span id="'+e.pre+'dl_linegraphcolor_expand" class="ui-icon ui-icon-plus icn3d-expand icn3d-link" style="display:none; width:15px;" title="Expand"></span><span id="'+e.pre+'dl_linegraphcolor_shrink" class="ui-icon ui-icon-minus icn3d-shrink icn3d-link" style="width:15px;" title="Shrink"></span></div>',s+=e.htmlCls.space2+"Hold Ctrl key to select multiple nodes/lines.</div>",s+=e.htmlCls.divStr+"dl_linegraphcolor' style='display:block;'>",s+=e.htmlCls.setHtmlCls.setColorHints(),s+="</div><br>",e.linegraphid=e.pre+"linegraph",s+=e.htmlCls.divNowrapStr+r+e.linegraphid+'_svg">SVG</button>'+e.htmlCls.space2,s+=r+e.linegraphid+'_png">PNG</button>'+e.htmlCls.space2,s+=r+e.linegraphid+'_json">JSON</button>'+e.htmlCls.space4,s+="<b>Scale</b>: <select id='"+e.linegraphid+"_scale'>";let h=["0.1","0.2","0.4","0.6","0.8","1","2","4","6","8","10"];s+=e.htmlCls.setHtmlCls.getOptionHtml(h,5),s+="</select></div><br>",s+='<div id="'+e.pre+'linegraphDiv"></div>',s+="</div>",s+=e.htmlCls.divStr+"dl_scatterplot' style='background-color:white' class='"+l+"'>",s+=this.addNotebookTitle("dl_scatterplot","2D Interaction Map"),s+=e.htmlCls.divNowrapStr+"Hold Ctrl key to select multiple nodes."+e.htmlCls.space3,s+='<div style="width:20px; margin-top:6px; display:inline-block;"><span id="'+e.pre+'dl_scatterplotcolor_expand" class="ui-icon ui-icon-plus icn3d-expand icn3d-link" style="width:15px;" title="Expand"></span><span id="'+e.pre+'dl_scatterplotcolor_shrink" class="ui-icon ui-icon-minus icn3d-shrink icn3d-link" style="display:none; width:15px;" title="Shrink"></span></div></div>',s+=e.htmlCls.divStr+"dl_scatterplotcolor' style='display:none;'>",s+=e.htmlCls.setHtmlCls.setColorHints(),s+="</div>",e.scatterplotid=e.pre+"scatterplot",s+=e.htmlCls.divNowrapStr+r+e.scatterplotid+'_svg">SVG</button>'+e.htmlCls.space2,s+=r+e.scatterplotid+'_png">PNG</button>'+e.htmlCls.space2,s+=r+e.scatterplotid+'_json">JSON</button>'+e.htmlCls.space4,s+="<b>Scale</b>: <select id='"+e.scatterplotid+"_scale'>",s+=e.htmlCls.setHtmlCls.getOptionHtml(h,5),s+="</select></div><br>",s+='<div id="'+e.pre+'scatterplotDiv"></div>',s+="</div>",s+=e.htmlCls.divStr+"dl_ligplot' style='background-color:white' class='"+l+"'>",void 0!==e.cfg.cid||void 0!==e.cfg.smiles?s+=this.addNotebookTitle("dl_ligplot","2D Depiction for Chemicals"):(s+=this.addNotebookTitle("dl_ligplot","2D Interaction for One Ligand/Residue with Atom Details"),s+=e.htmlCls.divNowrapStr+"<b>Note</b>: Nodes/Residues can be dragged. Both nodes and dashed lines/interactions can be clicked to select residues. "+e.htmlCls.space3,s+='<div style="width:20px; margin-top:6px; display:inline-block;"><span id="'+e.pre+'dl_ligplotcolor_expand" class="ui-icon ui-icon-plus icn3d-expand icn3d-link" style="display:none; width:15px;" title="Expand"></span><span id="'+e.pre+'dl_ligplotcolor_shrink" class="ui-icon ui-icon-minus icn3d-shrink icn3d-link" style="width:15px;" title="Shrink"></span></div></div>',s+=e.htmlCls.divStr+"dl_ligplotcolor' style='inline-block;'>",s+="<b>Color legend</b> for interactions (dashed lines): <br>",s+=e.htmlCls.setHtmlCls.setColorHints(),s+="<br></div>"),e.ligplotid=e.pre+"ligplot",s+=e.htmlCls.divNowrapStr+r+e.ligplotid+'_svg">SVG</button>'+e.htmlCls.space2,s+=r+e.ligplotid+'_png">PNG</button>'+e.htmlCls.space2,s+="<b>Scale</b>: <select id='"+e.ligplotid+"_scale'>",s+=e.htmlCls.setHtmlCls.getOptionHtml(h,5),s+="</select></div><br>",s+='<div id="'+e.pre+'ligplotDiv"></div>',s+="</div>",s+=e.htmlCls.divStr+"dl_contactmap' style='background-color:white' class='"+l+"'>",s+=this.addNotebookTitle("dl_contactmap","Contact Map"),s+=e.htmlCls.divNowrapStr+"Hold Ctrl key to select multiple nodes."+e.htmlCls.space3+"</div>",e.contactmapid=e.pre+"contactmap",s+=e.htmlCls.divNowrapStr+r+e.contactmapid+'_svg">SVG</button>'+e.htmlCls.space2,s+=r+e.contactmapid+'_png">PNG</button>'+e.htmlCls.space2,s+=r+e.contactmapid+'_json">JSON</button>'+e.htmlCls.space4,s+="<b>Scale</b>: <select id='"+e.contactmapid+"_scale'>";let p=["0.01","0.02","0.04","0.06","0.08","0.1","0.2","0.4","0.6","0.8","1"];s+=e.htmlCls.setHtmlCls.getOptionHtml(p,10),s+="</select></div><br>",s+='<div id="'+e.pre+'contactmapDiv"></div>',s+="</div>",s+=e.htmlCls.divStr+"dl_alignerrormap' style='background-color:white' class='"+l+"'>",s+=this.addNotebookTitle("dl_alignerrormap","PAE Map"),s+=e.htmlCls.divNowrapStr+"Hold Ctrl key to select multiple nodes."+e.htmlCls.space3+"</div>",e.alignerrormapid=e.pre+"alignerrormap",s+=e.htmlCls.divNowrapStr+r+e.alignerrormapid+'_svg">SVG</button>'+e.htmlCls.space2,s+=r+e.alignerrormapid+'_png">PNG (slow)</button>'+e.htmlCls.space2,s+=r+e.alignerrormapid+'_json">JSON</button>'+e.htmlCls.space4,s+='<b>Scale</b>: <select id="'+e.alignerrormapid+'_scale">',s+=e.htmlCls.setHtmlCls.getOptionHtml(p,2),s+="</select></div><br>";s+="<div style='width:200px'><div style='height: 12px; border: 1px solid #000; background: linear-gradient(to right, #004d00 0%, #FFFFFF 100%);'></div>",s+="<table width='100%' border='0' cellspacing='0' cellpadding='0'><tr><td width='15%'>0</td><td width='15%'>5</td><td width='15%'>10</td><td width='15%'>15</td><td width='15%'>20</td><td width='15%'>25</td><td>30</td></tr><tr><td colspan='7' align='center'>Expected position error (Angstroms)</td></tr></table></div><br>",s+='<div id="'+e.pre+'alignerrormapDiv"></div>',s+="</div>",s+=e.htmlCls.divStr+"dl_elecmap2fofc' class='"+l+"'>",s+=this.addNotebookTitle("dl_elecmap2fofc","Electron Density 2F0-Fc Map"),s+="<span style='white-space:nowrap;font-weight:bold;'>Contour at: <select id='"+e.pre+"sigma2fofc'>";let m=["0","0.5","1","1.5","2","3","4","5","6","7","8","9","10"];s+=e.htmlCls.setHtmlCls.getOptionHtml(m,3),s+="</select> &sigma;</span> <span style='white-space:nowrap; margin-left:30px;'>"+e.htmlCls.buttonStr+"applymap2fofc'>Display</button></span> <span style='white-space:nowrap; margin-left:30px;'>"+e.htmlCls.buttonStr+"elecmapNo2'>Remove Map</button></span>",s+="</div>",s+=e.htmlCls.divStr+"dl_elecmapfofc' class='"+l+"'>",s+=this.addNotebookTitle("dl_elecmapfofc","Electron Density F0-Fc Map"),s+="<span style='white-space:nowrap;font-weight:bold;'>Contour at: <select id='"+e.pre+"sigmafofc'>",s+=e.htmlCls.setHtmlCls.getOptionHtml(m,5),s+="</select> &sigma;</span> <span style='white-space:nowrap; margin-left:30px;'>"+e.htmlCls.buttonStr+"applymapfofc'>Display</button></span> <span style='white-space:nowrap; margin-left:30px;'>"+e.htmlCls.buttonStr+"elecmapNo3'>Remove Map</button></span>",s+="</div>",s+=e.htmlCls.divStr+"dl_emmap' class='"+l+"'>",s+=this.addNotebookTitle("dl_emmap","EM Density Map"),s+="<span style='white-space:nowrap;font-weight:bold;'>Contour at: <select id='"+e.pre+"empercentage'>",s+=e.htmlCls.setHtmlCls.getOptionHtml(["0","10","20","30","40","50","60","70","80","90","100"],3),s+="</select> % of maximum EM values</span><br><span style='white-space:nowrap; margin-left:30px;'>"+e.htmlCls.buttonStr+"applyemmap'>Display</button></span> <span style='white-space:nowrap; margin-left:30px;'>"+e.htmlCls.buttonStr+"emmapNo2'>Remove EM Map</button></span>",s+="</div>",s+=e.htmlCls.divStr+"dl_aroundsphere' class='"+l+"'>",s+=this.addNotebookTitle("dl_aroundsphere","Select a sphere around a set of residues"),s+=e.htmlCls.divNowrapStr+"1. Select the first set:</div>",s+="<div style='text-indent:1.1em'><select id='"+e.pre+"atomsCustomSphere2' multiple size='3' style='min-width:130px;'>",s+="</select></div><br>",s+=e.htmlCls.divNowrapStr+"2. Sphere with a radius: "+e.htmlCls.inputTextStr+"id='"+e.pre+"radius_aroundsphere' value='4' size='2'> &#197;</div><br/>",s+=e.htmlCls.divNowrapStr+"3. Select the second set to apply the sphere:</div>",s+="<div style='text-indent:1.1em'><select id='"+e.pre+"atomsCustomSphere' multiple size='3' style='min-width:130px;'>",s+="</select></div><br>",s+=e.htmlCls.divNowrapStr+"4. "+e.htmlCls.buttonStr+"applypick_aroundsphere'>Display</button> the sphere around the first set of atoms</div><br>",s+="<div style='text-indent:1.1em'>"+e.htmlCls.buttonStr+"sphereExport'>Save</button> interacting/contacting residue pairs in a file</div>",s+="</div>",s+=e.htmlCls.divStr+"dl_adjustmem' class='"+l+"'>",s+=this.addNotebookTitle("dl_adjustmem","Adjust membranes"),s+="<b>Note</b>: The membranes are parallel to the X-Y plane. The center of the membranes is at Z = 0. <br/><br/>",s+=e.htmlCls.divNowrapStr+"1. Extracellular membrane Z-axis position: "+e.htmlCls.inputTextStr+"id='"+e.pre+"extra_mem_z' value='' size='3'> &#197;</div><br/>",s+=e.htmlCls.divNowrapStr+"2. intracellular membrane Z-axis position: "+e.htmlCls.inputTextStr+"id='"+e.pre+"intra_mem_z' value='' size='3'> &#197;</div><br/>",s+=e.htmlCls.divNowrapStr+"3. "+e.htmlCls.buttonStr+"apply_adjustmem'>Display</button> the adjusted membranes</div><br>",s+="</div>",s+=e.htmlCls.divStr+"dl_selectplane' class='"+l+"'>",s+=this.addNotebookTitle("dl_selectplane","Select a plane"),s+="<b>Note</b>: The membranes are parallel to the X-Y plane. The center of the membranes is at Z = 0. <br/><br/>",s+=e.htmlCls.divNowrapStr+"1. Z-axis position of the first X-Y plane: "+e.htmlCls.inputTextStr+"id='"+e.pre+"selectplane_z1' value='15' size='3'> &#197;</div><br/>",s+=e.htmlCls.divNowrapStr+"2. Z-axis position of the second X-Y plane: "+e.htmlCls.inputTextStr+"id='"+e.pre+"selectplane_z2' value='-15' size='3'> &#197;</div><br/>",s+=e.htmlCls.divNowrapStr+"3. "+e.htmlCls.buttonStr+"apply_selectplane'>Save</button> the region between the planes to Defined Sets</div><br>",s+="</div>",s+=e.htmlCls.divStr+"dl_addlabel' class='"+l+"'>",s+=this.addNotebookTitle("dl_addlabel","Add labels between two atoms"),s+="1. Text: "+e.htmlCls.inputTextStr+"id='"+e.pre+"labeltext' value='Text' size=4><br/>",s+="2. Size: "+e.htmlCls.inputTextStr+"id='"+e.pre+"labelsize' value='18' size=4 maxlength=2><br/>",s+="3. Color: "+e.htmlCls.inputTextStr+"id='"+e.pre+"labelcolor' value='"+i+"' size=4><br/>",e.utilsCls.isMobile()?s+=e.htmlCls.spanNowrapStr+"4. Touch TWO atoms</span><br/>":s+=e.htmlCls.spanNowrapStr+'4. Pick TWO atoms while holding "Alt" key</span><br/>',s+=e.htmlCls.spanNowrapStr+"5. "+e.htmlCls.buttonStr+"applypick_labels'>Display</button></span>",s+="</div>",s+=e.htmlCls.divStr+"dl_addlabelselection' class='"+l+"'>",s+=this.addNotebookTitle("dl_addlabelselection","Add labels for your selection"),s+="1. Text: "+e.htmlCls.inputTextStr+"id='"+e.pre+"labeltext2' value='Text' size=4><br/>",s+="2. Size: "+e.htmlCls.inputTextStr+"id='"+e.pre+"labelsize2' value='18' size=4 maxlength=2><br/>",s+="3. Color: "+e.htmlCls.inputTextStr+"id='"+e.pre+"labelcolor2' value='"+i+"' size=4><br/>",s+=e.htmlCls.spanNowrapStr+"4. "+e.htmlCls.buttonStr+"applyselection_labels'>Display</button></span>",s+="</div>",s+=e.htmlCls.divStr+"dl_labelColor' class='"+l+"'>",s+=this.addNotebookTitle("dl_labelColor","Change label color"),s+="Color for all labels: "+e.htmlCls.inputTextStr+"id='"+e.pre+"labelcolorall' value='"+i+"' size=4><br/><br/>",s+=e.htmlCls.spanNowrapStr+e.htmlCls.buttonStr+"applylabelcolor'>Display</button></span>",s+="</div>",s+=e.htmlCls.divStr+"dl_distance' class='"+l+"'>",s+=this.addNotebookTitle("dl_distance","Measure distance"),e.utilsCls.isMobile()?s+=e.htmlCls.spanNowrapStr+"1. Touch TWO atoms</span><br/>":s+=e.htmlCls.spanNowrapStr+'1. Pick TWO atoms while holding "Alt" key</span><br/>',s+=e.htmlCls.spanNowrapStr+"2. Line Color: "+e.htmlCls.inputTextStr+"id='"+e.pre+"distancecolor' value='"+i+"' size=4><br/>",s+=e.htmlCls.spanNowrapStr+"3. "+e.htmlCls.buttonStr+"applypick_measuredistance'>Display</button></span>",s+="</div>",s+=e.htmlCls.divStr+"dl_stabilizer' class='"+l+"'>",s+=this.addNotebookTitle("dl_stabilizer","Add a stabilizer"),e.utilsCls.isMobile()?s+=e.htmlCls.spanNowrapStr+"1. Touch TWO atoms</span><br/>":s+=e.htmlCls.spanNowrapStr+'1. Pick TWO atoms while holding "Alt" key</span><br/>',s+=e.htmlCls.spanNowrapStr+"2. Color: "+e.htmlCls.inputTextStr+"id='"+e.pre+"stabilizercolor' value='ffffff' size=4><br/>",s+=e.htmlCls.spanNowrapStr+"3. "+e.htmlCls.buttonStr+"applypick_stabilizer'>Add</button></span>",s+="</div>",s+=e.htmlCls.divStr+"dl_disttwosets' class='"+l+"'>",s+=this.addNotebookTitle("dl_disttwosets","Measure the distance between two sets"),s+=e.htmlCls.spanNowrapStr+"1. Select two sets</span><br/>",s+="<table border=0 width=400 cellspacing=10><tr><td>",s+=e.htmlCls.divNowrapStr+"First set:</div>",s+="<div style='text-indent:1.1em'><select style='max-width:200px' id='"+e.pre+"atomsCustomDist2' multiple size='5' style='min-width:130px;'>",s+="</select></div>",s+="</td><td>",s+=e.htmlCls.divNowrapStr+"Second set:</div>",s+="<div style='text-indent:1.1em'><select style='max-width:200px' id='"+e.pre+"atomsCustomDist' multiple size='5' style='min-width:130px;'>",s+="</select></div>",s+="</td></tr></table>",s+=e.htmlCls.spanNowrapStr+"2. Color: "+e.htmlCls.inputTextStr+"id='"+e.pre+"distancecolor2' value='"+i+"' size=4><br/><br/>",s+=e.htmlCls.spanNowrapStr+"3. "+e.htmlCls.buttonStr+"applydist2'>Display</button></span>",s+="</div>",s+=e.htmlCls.divStr+"dl_linebtwsets' class='"+l+"'>",s+=this.addNotebookTitle("dl_linebtwsets","Add a line between  two sets"),s+=e.htmlCls.spanNowrapStr+"1. Select two sets</span><br/>",s+="<table border=0 width=400 cellspacing=10><tr><td>",s+=e.htmlCls.divNowrapStr+"First set:</div>",s+="<div style='text-indent:1.1em'><select style='max-width:200px' id='"+e.pre+"linebtwsets2' multiple size='5' style='min-width:130px;'>",s+="</select></div>",s+="</td><td>",s+=e.htmlCls.divNowrapStr+"Second set:</div>",s+="<div style='text-indent:1.1em'><select style='max-width:200px' id='"+e.pre+"linebtwsets' multiple size='5' style='min-width:130px;'>",s+="</select></div>",s+="</td></tr></table>",s+=e.htmlCls.divNowrapStr+"2. Line style: <select id='"+e.pre+"linebtwsets_style'>",s+=e.htmlCls.setHtmlCls.getOptionHtml(["Solid","Dashed"],0),s+="</select></div><br>",s+="3. Line radius: "+e.htmlCls.inputTextStr+"id='"+e.pre+"linebtwsets_radius' value='0.4' size=4><br/><br/>",s+="4. Color: "+e.htmlCls.inputTextStr+"id='"+e.pre+"linebtwsets_customcolor' value='"+i+"' size=4><br/><br/>",s+=e.htmlCls.divNowrapStr+"5. Opacity: <select id='"+e.pre+"linebtwsets_opacity'>",s+=e.htmlCls.setHtmlCls.getOptionHtml(["1.0","0.9","0.8","0.7","0.6","0.5","0.4","0.3","0.2","0.1"],7),s+="</select></div><br>",s+=e.htmlCls.spanNowrapStr+"6. "+e.htmlCls.buttonStr+"applylinebtwsets'>Display</button></span>",s+=e.htmlCls.space3+e.htmlCls.spanNowrapStr+e.htmlCls.buttonStr+"clearlinebtwsets'>Clear</button></span>",s+="</div>",s+=e.htmlCls.divStr+"dl_cartoonshape' class='"+l+"'>",s+=this.addNotebookTitle("dl_cartoonshape","Cartoon Shape"),s+=e.htmlCls.spanNowrapStr+"1. Select a set:</span><br/>",s+="<div style='text-indent:1.1em'><select style='max-width:200px' id='"+e.pre+"cartoonshape' multiple size='5' style='min-width:130px;'>",s+="</select></div><br>",s+=e.htmlCls.divNowrapStr+"2. Shape: <select id='"+e.pre+"cartoonshape_shape'>",s+=e.htmlCls.setHtmlCls.getOptionHtml(["Sphere","Cube"],0),s+="</select></div><br>",s+="3. Radius: "+e.htmlCls.inputTextStr+"id='"+e.pre+"cartoonshape_radius' value='1.5' size=4><br/><br/>",s+="4. Color: "+e.htmlCls.inputTextStr+"id='"+e.pre+"cartoonshape_customcolor' value='"+i+"' size=4><br/><br/>",s+=e.htmlCls.divNowrapStr+"5. Opacity: <select id='"+e.pre+"cartoonshape_opacity'>",s+=e.htmlCls.setHtmlCls.getOptionHtml(["1.0","0.9","0.8","0.7","0.6","0.5","0.4","0.3","0.2","0.1"],7),s+="</select></div><br>",s+=e.htmlCls.spanNowrapStr+"6. "+e.htmlCls.buttonStr+"applycartoonshape'>Display</button></span>",s+=e.htmlCls.space3+e.htmlCls.spanNowrapStr+e.htmlCls.buttonStr+"clearcartoonshape'>Clear</button></span>",s+="</div>",s+=e.htmlCls.divStr+"dl_distmanysets' class='"+l+"'>",s+=this.addNotebookTitle("dl_distmanysets","Measure distances among many sets"),s+=e.htmlCls.spanNowrapStr+"1. Select sets for pairwise distances</span><br/>",s+="<table border=0 width=400 cellspacing=10><tr><td>",s+=e.htmlCls.divNowrapStr+"First sets:</div>",s+="<div style='text-indent:1.1em'><select style='max-width:200px' id='"+e.pre+"atomsCustomDistTable2' multiple size='5' style='min-width:130px;'>",s+="</select></div>",s+="</td><td>",s+=e.htmlCls.divNowrapStr+"Second sets:</div>",s+="<div style='text-indent:1.1em'><select style='max-width:200px' id='"+e.pre+"atomsCustomDistTable' multiple size='5' style='min-width:130px;'>",s+="</select></div>",s+="</td></tr></table>",s+=e.htmlCls.spanNowrapStr+"2. "+e.htmlCls.buttonStr+"applydisttable'>Distances in Table</button></span>",s+="</div>",s+=e.htmlCls.divStr+"dl_anglemanysets' class='"+l+"' style='max-width:500px'>",s+=this.addNotebookTitle("dl_anglemanysets","Measure angles among many sets"),s+=e.htmlCls.spanNowrapStr+"Note: Each set is represented by a vector, which is the X-axis of the principle axes. The angles between the vectors are then calculated.<br/><br/>",s+=e.htmlCls.spanNowrapStr+"1. Select sets for pairwise angles</span><br/>",s+="<table border=0 width=400 cellspacing=10><tr><td>",s+=e.htmlCls.divNowrapStr+"First sets:</div>",s+="<div style='text-indent:1.1em'><select style='max-width:200px' id='"+e.pre+"atomsCustomAngleTable2' multiple size='5' style='min-width:130px;'>",s+="</select></div>",s+="</td><td>",s+=e.htmlCls.divNowrapStr+"Second sets:</div>",s+="<div style='text-indent:1.1em'><select style='max-width:200px' id='"+e.pre+"atomsCustomAngleTable' multiple size='5' style='min-width:130px;'>",s+="</select></div>",s+="</td></tr></table>",s+=e.htmlCls.spanNowrapStr+"2. "+e.htmlCls.buttonStr+"applyangletable'>Angles in Table</button></span>",s+="</div>",s+=e.htmlCls.divStr+"dl_stabilizer_rm' class='"+l+"'>",s+=this.addNotebookTitle("dl_stabilizer_rm","Remove a stabilizer"),e.utilsCls.isMobile()?s+=e.htmlCls.spanNowrapStr+"1. Touch TWO atoms</span><br/>":s+=e.htmlCls.spanNowrapStr+'1. Pick TWO atoms while holding "Alt" key</span><br/>',s+=e.htmlCls.spanNowrapStr+"2. "+e.htmlCls.buttonStr+"applypick_stabilizer_rm'>Remove</button></span>",s+="</div>",s+=e.htmlCls.divStr+"dl_thickness' class='"+l+"'>",s+=this.addNotebookTitle("dl_thickness","Set thickness"),s+=e.htmlCls.setHtmlCls.setThicknessHtml("3dprint"),s+="</div>",s+=e.htmlCls.divStr+"dl_thickness2' class='"+l+"'>",s+=this.addNotebookTitle("dl_thickness2","Set thickness"),s+=e.htmlCls.setHtmlCls.setThicknessHtml("style"),s+="</div>",s+=e.htmlCls.divStr+"dl_menupref' class='"+l+"'>",s+=this.addNotebookTitle("dl_menupref","Preferences for menus"),s+="<b>Note</b>: The following parameters will be saved in cache. You just need to set them once. <br><br>",s+=e.htmlCls.spanNowrapStr+""+e.htmlCls.buttonStr+"apply_menupref'>Apply</button></span>",s+=e.htmlCls.spanNowrapStr+""+e.htmlCls.buttonStr+"reset_menupref' style='margin-left:30px'>Reset to Simple Menus</button></span>",s+=e.htmlCls.spanNowrapStr+""+e.htmlCls.buttonStr+"reset_menupref_all' style='margin-left:30px'>Reset to All Menus</button></span>",s+=e.htmlCls.spanNowrapStr+""+e.htmlCls.buttonStr+"savepref' style='margin-left:30px'>Save Preferences</button></span>",s+=e.htmlCls.spanNowrapStr+""+e.htmlCls.buttonStr+"loadpref' style='margin-left:30px'>Load Preferences</button></span><br><br>",s+="<div id='"+e.pre+"menulist'></div><br><br>",s+=e.htmlCls.spanNowrapStr+""+e.htmlCls.buttonStr+"apply_menupref2'>Apply</button></span>",s+=e.htmlCls.spanNowrapStr+""+e.htmlCls.buttonStr+"reset_menupref2' style='margin-left:30px'>Reset to Simple Menus</button></span>",s+=e.htmlCls.spanNowrapStr+""+e.htmlCls.buttonStr+"reset_menupref_all2' style='margin-left:30px'>Reset to All Menus</button></span>",s+=e.htmlCls.spanNowrapStr+""+e.htmlCls.buttonStr+"savepref2' style='margin-left:30px'>Save Preferences</button></span>",s+=e.htmlCls.spanNowrapStr+""+e.htmlCls.buttonStr+"loadpref2' style='margin-left:30px'>Load Preferences</button></span>",s+="</div>",s+=e.htmlCls.divStr+"dl_addtrack' class='"+l+"'>",s+=this.addNotebookTitle("dl_addtrack","Add a track"),s+=" <input type='hidden' id='"+e.pre+"track_chainid' value=''>",s+=e.htmlCls.divStr+"dl_addtrack_tabs' style='border:0px;'>",s+="<ul>",s+="<li><a href='#"+e.pre+"tracktab2c'>Isoforms & Exons</a></li>",s+="<li><a href='#"+e.pre+"tracktab2b'>MSA</a></li>",s+="<li><a href='#"+e.pre+"tracktab1'>NCBI gi/Accession</a></li>",s+="<li><a href='#"+e.pre+"tracktab2'>FASTA</a></li>",s+="<li><a href='#"+e.pre+"tracktab3'>BED File</a></li>",s+="<li><a href='#"+e.pre+"tracktab4'>Custom</a></li>",s+="<li><a href='#"+e.pre+"tracktab5'>Current Selection</a></li>",s+="</ul>",s+=e.htmlCls.divStr+"tracktab1'>",s+="NCBI gi/Accession: "+e.htmlCls.inputTextStr+"id='"+e.pre+"track_gi' placeholder='gi' size=16> <br><br>",s+=e.htmlCls.buttonStr+"addtrack_button1'>Add Track</button>",s+="</div>",s+=e.htmlCls.divStr+"tracktab2'>",s+="FASTA Title: "+e.htmlCls.inputTextStr+"id='"+e.pre+"fasta_title' placeholder='track title' size=16> <br><br>",s+="FASTA sequence: <br><textarea id='"+e.pre+"track_fasta' rows='5' style='width: 100%; height: "+2*e.htmlCls.LOG_HEIGHT+"px; padding: 0px; border: 0px;'></textarea><br><br>",s+=e.htmlCls.buttonStr+"addtrack_button2'>Add Track</button>",s+="</div>",s+=e.htmlCls.divStr+"tracktab2b'>",s+="<div style='width:600px'>Note: The full protein sequences with gaps in MSA are listed one by one. The sequence of the structure is listed at the top. Each sequence has a title line starting with \">\".</div><br>",s+="<b>Precalculated Multiple Sequence Alignment (MSA)</b>:<br>",s+="<textarea id='"+e.pre+"track_fastaalign' rows='5' style='width: 100%; height: "+2*e.htmlCls.LOG_HEIGHT+"px; padding: 0px; border: 0px;'></textarea><br><br>",s+="<b>Position of the first residue in Sequences & Annotations window</b>: "+e.htmlCls.inputTextStr+"id='"+e.pre+"fasta_startpos' value='1' size=2> <br><br>",s+="Color Sequence by: <select id='"+e.pre+"colorseqby'>",s+=e.htmlCls.optionStr+"'identity' selected>Identity</option>",s+=e.htmlCls.optionStr+"'conservation'>Conservation</option>",s+="</select> <br><br>",s+=e.htmlCls.buttonStr+"addtrack_button2b'>Add Track(s)</button>",s+="</div>",s+=e.htmlCls.divStr+"tracktab2c'>",s+="<div style='width:500px'>Note: Show exons for all isoforms of the protein in the same gene as specified below.</div><br>",s+="<b><a href='https://www.ncbi.nlm.nih.gov/gene' target='_blank'>NCBI Gene</a> ID</b>: "+e.htmlCls.inputTextStr+"id='"+e.pre+"track_geneid' size=20>"+e.htmlCls.space3+e.htmlCls.buttonStr+"exons_table'>Exons & Introns in Gene Table</button><br><br>",s+="<b>Position of the first residue in Sequences & Annotations window</b>: "+e.htmlCls.inputTextStr+"id='"+e.pre+"fasta_startpos2' value='1' size=2> <br><br>",s+=e.htmlCls.buttonStr+"addtrack_button2c'>Show Isoforms & Exons</button>",s+="</div>",s+=e.htmlCls.divStr+"tracktab3'>",s+="BED file: "+e.htmlCls.inputFileStr+"id='"+e.pre+"track_bed' size=16> <br><br>",s+=e.htmlCls.buttonStr+"addtrack_button3'>Add Track</button>",s+="</div>",s+=e.htmlCls.divStr+"tracktab4'>",s+="Track Title: "+e.htmlCls.inputTextStr+"id='"+e.pre+"track_title' placeholder='track title' size=16> <br><br>",s+='Track Text (e.g., "2 G, 5-6 RR" defines a character "G" at the position 2 and two continuous characters "RR" at positions from 5 to 6. The starting position is 1): <br>',s+="<textarea id='"+e.pre+"track_text' rows='5' style='width: 100%; height: "+2*e.htmlCls.MENU_HEIGHT+"px; padding: 0px; border: 0px;'></textarea><br><br>",s+=e.htmlCls.buttonStr+"addtrack_button4'>Add Track</button>",s+="</div>",s+=e.htmlCls.divStr+"tracktab5'>",s+="Track Title: "+e.htmlCls.inputTextStr+"id='"+e.pre+"track_selection' placeholder='track title' size=16> <br><br>",s+=e.htmlCls.buttonStr+"addtrack_button5'>Add Track</button>",s+="</div>",s+="</div>",s+="</div>",s+=e.htmlCls.divStr+"dl_saveselection' class='"+l+"'>",s+=this.addNotebookTitle("dl_saveselection","Save Selection");let u=t&&t.defNames2Atoms?Object.keys(t.defNames2Atoms).length:1;return s+="Name: "+e.htmlCls.inputTextStr+"id='"+e.pre+"seq_command_name' value='seq_"+u+"' size='5'> <br>",s+="<button style='white-space:nowrap;' id='"+e.pre+"seq_saveselection'>Save</button> <button style='white-space:nowrap; margin-left:20px;' id='"+e.pre+"seq_clearselection'>Clear</button><br/><br/>",s+="</div>",s+=e.htmlCls.divStr+"dl_copyurl' style='width:520px;' class='"+l+"'>",s+=this.addNotebookTitle("dl_copyurl","Share Link"),s+="<br>",s+="1. <b>URLs Used in Browsers</b><br><br>",s+='Please copy one of the URLs below. They show the same result.<br>(To add a title to share link, click "Windows > Your Note" and click "File > Share Link" again.)<br><br>',s+="Original URL with commands: <br><textarea id='"+e.pre+"ori_url' rows='4' style='width:100%'></textarea><br><br>",e.cfg.notebook||(s+="Lifelong Short URL:(To replace this URL, send a pull request to update share.html at <a href='https://github.com/ncbi/icn3d' target='_blank'>iCn3D GitHub</a>)<br>"+e.htmlCls.inputTextStr+"id='"+e.pre+"short_url' value='' style='width:100%'><br><br>",s+='Lifelong Short URL + Window Title:(To update the window title, click "Analysis > Your Note/Window Title".)<br>'+e.htmlCls.inputTextStr+"id='"+e.pre+"short_url_title' value='' style='width:100%'><br><br>"),s+="2. <b>Commands Used in Jupyter Noteboook</b><br><br>",s+="Please copy the following commands into a cell in Jupyter Notebook to show the same result. <br>More details are at https://github.com/ncbi/icn3d/tree/master/jupyternotebook.<br><br>",s+='<textarea id="'+e.pre+'jn_commands" rows="4" style="width:100%"></textarea><br>',s+=r+e.pre+'jn_copy">Copy Commands</button><br>',s+="</div>",s+=e.htmlCls.divStr+"dl_selectannotations' class='"+l+" icn3d-annotation' style='background-color:white;'>",s+=this.addNotebookTitle("dl_selectannotations","Sequences & Annotations"),s+=e.htmlCls.divStr+"dl_annotations_tabs'>",s+=e.htmlCls.divStr+"dl_anno_view_tabs' style='border:0px; height:33px;'>",s+="<ul>",s+="<li><a href='#"+e.pre+"anno_tmp1' id='"+e.pre+"anno_summary'>Summary</a></li>",s+="<li><a href='#"+e.pre+"anno_tmp2' id='"+e.pre+"anno_details'>Details</a></li>",s+="</ul>",s+=e.htmlCls.divStr+"anno_tmp1'>",s+="</div>",s+=e.htmlCls.divStr+"anno_tmp2'>",s+="</div>",s+="</div>",s+=this.getAnnoHeader(),s+="<button style='white-space:nowrap; margin-left:5px;' id='"+e.pre+"showallchains'>Show All Chains</button><br>",s+=e.htmlCls.divStr+"seqguide_wrapper' style='display:none'><br>"+e.htmlCls.setHtmlCls.setSequenceGuide("2")+"</div>",s+="</div><br/><hr><br>",s+=e.htmlCls.divStr+"dl_annotations'>",s+="</div>",s+="</div>",s+=e.htmlCls.divStr+"dl_graph' style='background-color:white;' class='"+l+"'>",s+=this.addNotebookTitle("dl_graph","Interactions"),e.svgid=e.pre+"icn3d_viz",s+="<style>",s+="#"+e.svgid+" svg { border: 1px solid; font: 13px sans-serif; text-anchor: end; }",s+="#"+e.svgid+" .node { stroke: #eee; stroke-width: 1.5px; }",s+=".node .selected { stroke: "+e.htmlCls.ORANGE+"; }",s+=".link { stroke: #999; stroke-opacity: 0.6; }",s+="</style>",s+=e.htmlCls.divNowrapStr+"<b>Zoom</b>: mouse wheel; "+e.htmlCls.space3+" <b>Move</b>: left button; "+e.htmlCls.space3+" <b>Select Multiple Nodes</b>: Ctrl Key and drag an Area"+e.htmlCls.space3,s+='<div id="'+e.pre+'interactionDesc" style="width:20px; margin-top:6px; display:inline-block;"><span id="'+e.pre+'dl_svgcolor_expand" class="ui-icon ui-icon-plus icn3d-expand icn3d-link" style="width:15px;" title="Expand"></span><span id="'+e.pre+'dl_svgcolor_shrink" class="ui-icon ui-icon-minus icn3d-shrink icn3d-link" style="display:none; width:15px;" title="Shrink"></span></div></div>',s+=e.htmlCls.divStr+"dl_svgcolor' style='display:none;'>",s+=e.htmlCls.divNowrapStr+'<span style="margin-left:33px">Click "View > H-Bonds & Interactions" to adjust parameters and relaunch the graph</span></div>',s+=e.htmlCls.divNowrapStr+'<span style="margin-left:33px; color:#00FF00; font-weight:bold">Green</span>: H-Bonds; ',s+='<span style="color:#00FFFF; font-weight:bold">Cyan</span>: Salt Bridge/Ionic; ',s+='<span style="font-weight:bold">Grey</span>: contacts; ',s+='<span style="color:'+e.htmlCls.ORANGE+'; font-weight:bold">Orange</span>: disulfide bonds</div>',s+=e.htmlCls.divNowrapStr+'<span style="margin-left:33px; color:#FF00FF; font-weight:bold">Magenta</span>: Halogen Bonds; ',s+='<span style="color:#FF0000; font-weight:bold">Red</span>: &pi;-Cation; ',s+='<span style="color:#0000FF; font-weight:bold">Blue</span>: &pi;-Stacking</div>',s+="</div>",s+=e.htmlCls.divNowrapStr+r+e.svgid+'_svg">SVG</button>'+e.htmlCls.space2,s+=r+e.svgid+'_png">PNG</button>'+e.htmlCls.space2,s+=r+e.svgid+'_json">JSON</button>',s+=e.htmlCls.space3+"<div id='"+e.pre+"force' style='display:inline-block;'><b>Force on Nodes</b>: <select id='"+e.svgid+"_force'>",s+=e.htmlCls.optionStr+"'0'>No</option>",s+=e.htmlCls.optionStr+"'1'>X-axis</option>",s+=e.htmlCls.optionStr+"'2'>Y-axis</option>",s+=e.htmlCls.optionStr+"'3'>Circle</option>",s+=e.htmlCls.optionStr+"'4' selected>Random</option>",s+="</select></div>",s+=e.htmlCls.space3+"<b>Label Size</b>: <select id='"+e.svgid+"_label'>",o="icn3d-node-text",s+=e.htmlCls.optionStr+"'"+o+"0'>No</option>",s+=e.htmlCls.optionStr+"'"+o+"4'>4px</option>",s+=e.htmlCls.optionStr+"'"+o+"8' selected>8px</option>",s+=e.htmlCls.optionStr+"'"+o+"12'>12px</option>",s+=e.htmlCls.optionStr+"'"+o+"16'>16px</option>",s+=e.htmlCls.optionStr+"'"+o+"24'>24px</option>",s+=e.htmlCls.optionStr+"'"+o+"32'>32px</option>",s+="</select>",s+=e.htmlCls.space3+"<div id='"+e.pre+"internalEdges' style='display:inline-block;'><b>Internal Edges</b>: <select id='"+e.svgid+"_hideedges'>",s+=e.htmlCls.optionStr+"'1' selected>Hide</option>",s+=e.htmlCls.optionStr+"'0'>Show</option>",s+="</select></div>",s+="</div>",s+='<svg id="'+e.svgid+'" style="margin-top:6px;"></svg>',s+="</div>",s+=e.htmlCls.divStr+"dl_area' class='"+l+"'>",s+=this.addNotebookTitle("dl_area","Surface Area"),s+="Solvent Accessible Surface Area(SASA) calculated using the <a href='https://journals.plos.org/plosone/article?id=10.1371/journal.pone.0008140' target='_blank'>EDTSurf algorithm</a>: <br>",s+='(0-20% out is considered "in". 50-100% out is considered "out".)<br><br>',s+="<b>Toal</b>: "+e.htmlCls.inputTextStr+"id='"+e.pre+"areavalue' value='' size='10'> &#8491;<sup>2</sup><br><br>",s+="<div id='"+e.pre+"areatable' style='max-height:400px; overflow:auto'></div>",s+="</div>",s+=e.htmlCls.divStr+"dl_colorbyarea' class='"+l+"'>",s+=this.addNotebookTitle("dl_colorbyarea","Color by surface area"),s+="<div style='width:500px'>Color each residue based on the percentage of solvent accessilbe surface area. The color ranges from blue, to white, to red for a percentage of 0, 35(variable), and 100, respectively.</div><br>",s+="<b>Middle Percentage(White)</b>: "+e.htmlCls.inputTextStr+"id='"+e.pre+"midpercent' value='35' size='10'>% <br><br>",s+="<button style='white-space:nowrap;' id='"+e.pre+"applycolorbyarea'>Color</button><br/><br/>",s+="</div>",s+=e.htmlCls.divStr+"dl_rmsd' class='"+l+"' style='max-width:300px'>",s+=this.addNotebookTitle("dl_rmsd","RMSD",!0),s+="</div>",s+=e.htmlCls.divStr+"dl_buriedarea' class='"+l+"'>",s+=this.addNotebookTitle("dl_buriedarea","Buried surface area",!0),s+="</div>",s+=e.htmlCls.divStr+"dl_propbypercentout' class='"+l+"'>",s+=this.addNotebookTitle("dl_propbypercentout","Select residues basen on solvent accessilbe surface area"),s+="<div style='width:400px'>Select residue based on the percentage of solvent accessilbe surface area. The values are in the range of 0-100.</div><br>",s+="<b>Min Percentage</b>: "+e.htmlCls.inputTextStr+"id='"+e.pre+"minpercentout' value='0' size='10'>% <br>",s+="<b>Max Percentage</b>: "+e.htmlCls.inputTextStr+"id='"+e.pre+"maxpercentout' value='100' size='10'>% <br>",s+="<button style='white-space:nowrap;' id='"+e.pre+"applypropbypercentout'>Apply</button><br/><br/>",s+="</div>",s+=e.htmlCls.divStr+"dl_propbybfactor' class='"+l+"'>",s+=this.addNotebookTitle("dl_propbybfactor","Select residues basen on B-factor/pLDDT"),s+="<div style='width:400px'>Select residue based on B-factor/pLDDT. The values are in the range of 0-100.</div><br>",s+="<b>Min B-factor/pLDDT</b>: "+e.htmlCls.inputTextStr+"id='"+e.pre+"minbfactor' value='0' size='10'>% <br>",s+="<b>Max B-factor/pLDDT</b>: "+e.htmlCls.inputTextStr+"id='"+e.pre+"maxbfactor' value='100' size='10'>% <br>",s+="<button style='white-space:nowrap;' id='"+e.pre+"applypropbybfactor'>Apply</button><br/><br/>",s+="</div>",s+=e.htmlCls.divStr+"dl_legend' class='"+l+"' style='max-width:500px; background-color:white'>",s+=this.addNotebookTitle("dl_legend","Legend",!0),s+="</div>",s+=e.htmlCls.divStr+"dl_disttable' class='"+l+"'>",s+=this.addNotebookTitle("dl_disttable","Distance Table",!0),s+="</div>",s+=e.htmlCls.divStr+"dl_angletable' class='"+l+"'>",s+=this.addNotebookTitle("dl_angletable","Angle Table",!0),s+="</div>",s+=e.htmlCls.divStr+"dl_translate' class='"+l+"'>",s+=this.addNotebookTitle("dl_translate","Translate the X,Y,Z coordinates of the structure"),s+="X: "+e.htmlCls.inputTextStr+"id='"+e.pre+"translateX' value='' size=4> ",s+="Y: "+e.htmlCls.inputTextStr+"id='"+e.pre+"translateY' value='' size=4> ",s+="Z: "+e.htmlCls.inputTextStr+"id='"+e.pre+"translateZ' value='' size=4> ",s+=e.htmlCls.buttonStr+"translate_pdb'>Translate</button>",s+="</div>",s+=e.htmlCls.divStr+"dl_angle' class='"+l+"'>",s+=this.addNotebookTitle("dl_angle","Measure the angle between two vectors"),s+="<b>Vector 1</b>, X: "+e.htmlCls.inputTextStr+"id='"+e.pre+"v1X' value='' size=6> ",s+="Y: "+e.htmlCls.inputTextStr+"id='"+e.pre+"v1Y' value='' size=6> ",s+="Z: "+e.htmlCls.inputTextStr+"id='"+e.pre+"v1Z' value='' size=6><br>",s+="<b>Vector 2</b>, X: "+e.htmlCls.inputTextStr+"id='"+e.pre+"v2X' value='' size=6> ",s+="Y: "+e.htmlCls.inputTextStr+"id='"+e.pre+"v2Y' value='' size=6> ",s+="Z: "+e.htmlCls.inputTextStr+"id='"+e.pre+"v2Z' value='' size=6><br>",s+="<br>",s+=e.htmlCls.buttonStr+"measure_angle'>Measure Angle</button><br><br>",s+="The angle is: "+e.htmlCls.inputTextStr+"id='"+e.pre+"angle_value' value='' size=6> degree.<br><br>",s+="</div>",s+=e.htmlCls.divStr+"dl_matrix' class='"+l+"'>",s+=this.addNotebookTitle("dl_matrix","Apply matrix to the X,Y,Z coordinates of the structure"),s+="0: "+e.htmlCls.inputTextStr+"id='"+e.pre+"matrix0' value='1' size=2> ",s+="4: "+e.htmlCls.inputTextStr+"id='"+e.pre+"matrix4' value='0' size=2> ",s+="8: "+e.htmlCls.inputTextStr+"id='"+e.pre+"matrix8' value='0' size=2> ",s+="12: "+e.htmlCls.inputTextStr+"id='"+e.pre+"matrix12' value='0' size=2><br>",s+="1: "+e.htmlCls.inputTextStr+"id='"+e.pre+"matrix1' value='0' size=2> ",s+="5: "+e.htmlCls.inputTextStr+"id='"+e.pre+"matrix5' value='1' size=2> ",s+="9: "+e.htmlCls.inputTextStr+"id='"+e.pre+"matrix9' value='0' size=2> ",s+="13: "+e.htmlCls.inputTextStr+"id='"+e.pre+"matrix13' value='0' size=2><br>",s+="2: "+e.htmlCls.inputTextStr+"id='"+e.pre+"matrix2' value='0' size=2> ",s+="6: "+e.htmlCls.inputTextStr+"id='"+e.pre+"matrix6' value='0' size=2> ",s+="10: "+e.htmlCls.inputTextStr+"id='"+e.pre+"matrix10' value='1' size=2> ",s+="14: "+e.htmlCls.inputTextStr+"id='"+e.pre+"matrix14' value='0' size=2><br>",s+="3: "+e.htmlCls.inputTextStr+"id='"+e.pre+"matrix3' value='0' size=2> ",s+="7: "+e.htmlCls.inputTextStr+"id='"+e.pre+"matrix7' value='0' size=2> ",s+="11: "+e.htmlCls.inputTextStr+"id='"+e.pre+"matrix11' value='0' size=2> ",s+="15: "+e.htmlCls.inputTextStr+"id='"+e.pre+"matrix15' value='1' size=2><br>",s+=e.htmlCls.buttonStr+"matrix_pdb'>Rotate with Matrix</button>",s+="</div>",s+=e.htmlCls.divStr+"dl_igrefTpl' class='"+l+"'>",s+=this.addNotebookTitle("dl_igrefTpl","Choose an Ig template"),s+="<span style='white-space:nowrap;font-weight:bold;'>Choose an Ig template for selected residues:</span> <br><br><select id='"+e.pre+"refTpl'>",s+=this.setTemplateMenu(),s+="</select><br><br><span style='white-space:nowrap;'>"+e.htmlCls.buttonStr+"mn6_igrefTpl_apply'>Show Ig Ref. Number</button></span>",s+="</div>",s+=e.htmlCls.divStr+"dl_alignrefTpl' class='"+l+"'>",s+=this.addNotebookTitle("dl_alignrefTpl","Align with an Ig template"),s+="<span style='white-space:nowrap;font-weight:bold;'>Choose an Ig template to align with selected residues:</span> <br><br><select id='"+e.pre+"refTpl2'>",s+=this.setTemplateMenu(),s+="</select><br><br><span style='white-space:nowrap;'>"+e.htmlCls.buttonStr+"mn6_alignrefTpl_apply'>Align Template with Selection</button></span>",s+="</div>",s+="</div>",s+="\x3c!--/form--\x3e",s}setTemplateMenu(){let e=this.icn3dui;e.icn3d;let t={IgV:["CD28_1yjdC_human_V","CD2_1hnfA_human_V-n1","CD8a_1cd8A_human_V","FAB-HEAVY_5esv_V-n1","FAB-LIGHT_5esv_V-n1","ICOS_6x4gA_human_V","LAG3_7tzgD_human_V-n1","PD1_4zqkB_human_V","PDL1_4z18B_human_V-n1","TCRa_6jxrm_human_V-n1","VISTA_6oilA_human_V","VNAR_1t6vN_shark_V"],IgC1:["B2Microglobulin_7phrL_human_C1","CD3d_6jxrd_human_C1","CD3e_6jxrf_human_C1","FAB-LIGHT_5esv_C1-n2","FAB-HEAVY_5esv_C1-n2","GHR_1axiB_human_C1-n1","LAG3_7tzgD_human_C1-n2","MHCIa_7phrH_human_C1","Siglec3_5j0bB_human_C1-n2","TCRa_6jxrm_human_C1-n2","VTCN1_Q7Z7D3_human_C1-n2"],IgC2:["CD2_1hnfA_human_C2-n2","CD3g_6jxrg_human_C2"],IgI:["BTLA_2aw2A_human_Iset","Contactin1_3s97C_human_Iset-n2","JAM1_1nbqA_human_Iset-n2","Palladin_2dm3A_human_Iset-n1","Titin_4uowM_human_Iset-n152"],IgE:["CoAtomerGamma1_1r4xA_human","Endo-1,4-BetaXylanase10A_1i8aA_bacteria_n4","IsdA_2iteA_bacteria","NaKATPaseTransporterBeta_2zxeB_spurdogshark","TP34_2o6cA_bacteria","TP47_1o75A_bacteria"],IgFN3:["Contactin1_2ee2A_human_FN3-n9","IL6Rb_1bquB_human_FN3-n2","IL6Rb_1bquB_human_FN3-n3","InsulinR_8guyE_human_FN3-n1","InsulinR_8guyE_human_FN3-n2","Sidekick2_1wf5A_human_FN3-n7"],"IgFN3-like":["ASF1A_2iijA_human","BArrestin1_4jqiA_rat_n1","C3_2qkiD_human_n1","MPT63_1lmiA_bacteria","NaCaExchanger_2fwuA_dog_n2","RBPJ_6py8C_human_Unk-n1","RBPJ_6py8C_human_Unk-n2","TEAD1_3kysC_human"],"Other Ig":["CD19_6al5A_human-n1","CuZnSuperoxideDismutase_1hl5C_human","ECadherin_4zt1A_human_n2","LaminAC_1ifrA_human","ORF7a_1xakA_virus"]},s={ASF1A_2iijA_human:"A A' B C C' E F G G+",B2Microglobulin_7phrL_human_C1:"A B C C' D E F G",BArrestin1_4jqiA_rat_n1:"A- A A' B C C' E F G",BTLA_2aw2A_human_Iset:"A A' B C C' D E F G",C3_2qkiD_human_n1:"A A' B C C' E F G","CD19_6al5A_human-n1":"A' B C C' D E F G",CD28_1yjdC_human_V:"A A' B C C' C'' D E F G","CD2_1hnfA_human_C2-n2":"A B C C' E F G","CD2_1hnfA_human_V-n1":"A' B C C' C'' D E F G",CD3d_6jxrd_human_C1:"A B C D E F G",CD3e_6jxrf_human_C1:"A B C C' D E F G",CD3g_6jxrg_human_C2:"A B C C' E F G G+",CD8a_1cd8A_human_V:"A A' B C C' C'' D E F G",CoAtomerGamma1_1r4xA_human:"A- A B C D E F G","Contactin1_2ee2A_human_FN3-n9":"A A' B C C' E F G","Contactin1_3s97C_human_Iset-n2":"A A' B C D E F G",CuZnSuperoxideDismutase_1hl5C_human:"A- A B C C' E F G",ECadherin_4zt1A_human_n2:"A' B C D E F G","Endo-1,4-BetaXylanase10A_1i8aA_bacteria_n4":"A--- A-- A- A B C C' C'' D E F G","FAB-HEAVY_5esv_C1-n2":"A B C D E F G","FAB-HEAVY_5esv_V-n1":"A B C C' C'' D E F G","FAB-LIGHT_5esv_C1-n2":"A B C C' D E F G","FAB-LIGHT_5esv_V-n1":"A A' B C C' C'' D E F G","GHR_1axiB_human_C1-n1":"A B C C' D E F G",ICOS_6x4gA_human_V:"A B C C' C'' D E F G","IL6Rb_1bquB_human_FN3-n2":"A B C C' E F G","IL6Rb_1bquB_human_FN3-n3":"A B C C' E F G","InsulinR_8guyE_human_FN3-n1":"A B C C' E F G","InsulinR_8guyE_human_FN3-n2":"A B C C' E F G",IsdA_2iteA_bacteria:"A- A B C C' D E F G","JAM1_1nbqA_human_Iset-n2":"A A' B C C' D E F G","LAG3_7tzgD_human_C1-n2":"A A' B C C' D E F G","LAG3_7tzgD_human_V-n1":"A' B C C' D E F G",LaminAC_1ifrA_human:"A- A B C C' E E+ F G",MHCIa_7phrH_human_C1:"A B C C' D E F G",MPT63_1lmiA_bacteria:"A-- A- A BC C' E F G",NaCaExchanger_2fwuA_dog_n2:"A A' B C C' E F G",NaKATPaseTransporterBeta_2zxeB_spurdogshark:"A A' B C D E F G",ORF7a_1xakA_virus:"A' B C D E F G",PD1_4zqkB_human_V:"A A' B C C' D E F G","PDL1_4z18B_human_V-n1":"A A' B C C' C'' D E F G","Palladin_2dm3A_human_Iset-n1":"A A' B C C' D E F G","RBPJ_6py8C_human_Unk-n1":"A A' B C C' E F G","RBPJ_6py8C_human_Unk-n2":"A B C D E F G","Sidekick2_1wf5A_human_FN3-n7":"A B C C' E F G","Siglec3_5j0bB_human_C1-n2":"A A' B C D E F G","TCRa_6jxrm_human_C1-n2":"A B C D E F G","TCRa_6jxrm_human_V-n1":"A A' B C C' C'' D E F G",TEAD1_3kysC_human:"A A+ A' B C C' E F G G+",TP34_2o6cA_bacteria:"A- A B C C' D E F G",TP47_1o75A_bacteria:"A B C C' D E F G","Titin_4uowM_human_Iset-n152":"A A' B C C' D E F G",VISTA_6oilA_human_V:"A A' B C C' C'' D E F G G+",VNAR_1t6vN_shark_V:"A A' B C C' D E F G","VTCN1_Q7Z7D3_human_C1-n2":"A B C C' D E F G G+"},i="";for(let n in t){i+="<optgroup label='"+n+"'>";for(let l=0,r=t[n].length;l<r;++l){let r=t[n][l];i+=e.htmlCls.optionStr+"'"+r+"'>"+r+", Strands: "+s[r]+"</option>"}i+="</optgroup>"}return i}getAnnoHeader(){let e=this.icn3dui;e.icn3d;let t="";t+="<div id='"+e.pre+"annoHeaderSection' class='icn3d-box' style='width:520px;'><b>Annotations:&nbsp;</b><br>",t+="<div id='"+e.pre+"annoHeader'><table border=0><tr>";let s="<td style='min-width:110px;'><span style='white-space:nowrap'>",i="<td style='min-width:130px;'><span style='white-space:nowrap'>";return t+=s+e.htmlCls.inputCheckStr+"id='"+e.pre+"anno_all'>All"+e.htmlCls.space2+"</span></td>",t+=i+e.htmlCls.inputCheckStr+"id='"+e.pre+"anno_cdd' checked>Conserved Domains"+e.htmlCls.space2+"</span></td>",t+=s+e.htmlCls.inputCheckStr+"id='"+e.pre+"anno_clinvar'>ClinVar"+e.htmlCls.space2+"</span></td>",t+=s+e.htmlCls.inputCheckStr+"id='"+e.pre+"anno_binding'>Functional Sites"+e.htmlCls.space2+"</span></td>",t+="</tr><tr>",t+=s+e.htmlCls.inputCheckStr+"id='"+e.pre+"anno_custom'>Custom"+e.htmlCls.space2+"</span></td>",t+=i+e.htmlCls.inputCheckStr+"id='"+e.pre+"anno_3dd'>3D Domains"+e.htmlCls.space2+"</span></td>",t+=s+e.htmlCls.inputCheckStr+"id='"+e.pre+"anno_snp'>SNPs"+e.htmlCls.space2+"</span></td>",t+=s+e.htmlCls.inputCheckStr+"id='"+e.pre+"anno_ptm'>PTM (UniProt)"+e.htmlCls.space2+"</span></td>",t+="<td></td>",t+="</tr><tr>",t+=s+e.htmlCls.inputCheckStr+"id='"+e.pre+"anno_ssbond'>Disulfide Bonds"+e.htmlCls.space2+"</span></td>",t+=s+e.htmlCls.inputCheckStr+"id='"+e.pre+"anno_interact'>Interactions"+e.htmlCls.space2+"</span></td>",t+=s+e.htmlCls.inputCheckStr+"id='"+e.pre+"anno_crosslink'>Cross-Linkages"+e.htmlCls.space2+"</span></td>",t+=s+e.htmlCls.inputCheckStr+"id='"+e.pre+"anno_transmem'>Transmembrane"+e.htmlCls.space2+"</span></td>",t+="<td></td>",t+="</tr><tr>",t+=s+e.htmlCls.inputCheckStr+"id='"+e.pre+"anno_ig'>Ig Domains"+e.htmlCls.space2+"</span></td>",t+="<td></td>",t+="</tr></table></div></div>",t}}class p{constructor(e){this.icn3dui=e}setLogCmd(e,t,s){var i=this.icn3dui;i.icn3d,i.htmlCls.clickMenuCls.setLogCmd(e,t,s)}fullScreenChange(){let e=this.icn3dui,t=e.icn3d,s=this;e.bNode||document.fullscreenElement||document.webkitFullscreenElement||document.mozFullscreenElement||document.msFullscreenElement||(s.setLogCmd("exit full screen",!1),t.bFullscreen=!1,e.utilsCls.setViewerWidthHeight(e,!0),t.applyCenterCls.setWidthHeight(e.htmlCls.WIDTH,e.htmlCls.HEIGHT),t.drawCls.draw())}convertUniProtInChains(e){this.icn3dui.icn3d;let t=e.split(","),s="";for(let e=0,i=t.length;e<i;++e)s+=-1!=t[e].indexOf("_")?t[e]:t[e]+"_A",e<i-1&&(s+=",");return s}async searchSeq(){let e=this.icn3dui,t=e.icn3d,s=$("#"+e.pre+"search_seq").val();isNaN(s)&&-1==s.indexOf("$")&&-1==s.indexOf(".")&&-1==s.indexOf(":")&&-1==s.indexOf("@")&&(s=":"+s);let i=s.replace(/\s+/g,"_"),n=i;await t.selByCommCls.selectByCommand(s,i,n),this.setLogCmd("select "+s+" | name "+i,!0)}async setRealign(e,t){let s=this.icn3dui,i=s.icn3d,n=this,l=$("#"+s.pre+"atomsCustomRealignByStruct").val();l.length>0&&(i.hAtoms=i.definedSetsCls.getAtomsFromNameArray(l)),s.cfg.aligntool=e;let r="vast"==e?"structure align":"tmalign";if(r+=t?" msa":"",l.length>0?n.setLogCmd("realign on "+r+" | "+l,!0):n.setLogCmd("realign on "+r,!0),t){if(0==l.length){l=[];let e={};for(let t in i.chains){let s=i.firstAtomObjCls.getFirstAtomObj(i.chains[t]);e.hasOwnProperty(s.structure)||!i.proteins.hasOwnProperty(s.serial)&&!i.nucleotides.hasOwnProperty(s.serial)||(l.push(t),e[s.structure]=1)}}await i.realignParserCls.realignOnStructAlignMsa(l)}else await i.realignParserCls.realignOnStructAlign()}async readFile(e,t,s,i,n,l){let r=this.icn3dui,o=r.icn3d,a=this,d=t[s],c=e?"append":"load";c+=n?" mmcif file ":l?" png file ":" pdb file ";let h=new FileReader;h.onload=async function(h){let p=h.target.result;if(a.setLogCmd(c+d.name,!1),e?(o.resetConfig(),o.bResetAnno=!0,o.bResetSets=!0):o.init(),o.bInputfile=!0,o.InputfileType=n?"mmcif":l?"png":"pdb",l){let e=await r.htmlCls.setHtmlCls.loadPng(p);if(p=e.pdb,!p)return;o.statefileArray||(o.statefileArray=[]),o.statefileArray.push(e.statefile)}o.InputfileData=o.InputfileData?o.InputfileData+"\nENDMDL\n"+p:p,i=s>0?i+"\nENDMDL\n"+p:p,Object.keys(t).length==s+1?(e&&(o.hAtoms={},o.dAtoms={}),n?await o.mmcifParserCls.loadMultipleMmcifData(i,void 0,e):await o.pdbParserCls.loadPdbData(i,void 0,void 0,e)):await a.readFile(e,t,s+1,i,n,l),e&&(o.bSetChainsAdvancedMenu&&o.definedSetsCls.showSets(),o.bResetAnno=!0,o.bAnnoShown&&(await o.showAnnoCls.showAnnotations(),o.annotationCls.resetAnnoTabAll()))},"object"==typeof d&&h.readAsText(d)}async loadPdbFile(e,t,s){let i=this.icn3dui,n=i.icn3d;n.bInitial=!0,i.cfg.notebook||dialog.dialog("close"),i.cfg.notebook?n.resizeCanvasCls.closeDialogs():$(".ui-dialog-content").dialog("close");let l=$("#"+i.pre+t)[0].files;l[0]?(i.htmlCls.setHtmlCls.fileSupport(),n.molTitle="",n.dataStrAll="",await this.readFile(e,l,0,"",s)):alert("Please select a file before clicking 'Load'")}saveHtml(e){let t=this.icn3dui.icn3d,s="";s+='<link rel="stylesheet" href="https://www.ncbi.nlm.nih.gov/Structure/icn3d/lib/jquery-ui-1.13.2.min.css">\n',s+='<link rel="stylesheet" href="https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d_full_ui.css">\n',s+=$("#"+e).html();let i=e.split("_"),n=i.length>2?i[2]:e,l=Object.keys(t.structures)[0];Object.keys(t.structures).length>1&&(l+="-"+Object.keys(t.structures)[1]),t.saveFileCls.saveFile(l+"-"+n+".html","html",encodeURIComponent(s))}setPredefinedMenu(e){let t=this.icn3dui,s=t.icn3d;if(Object.keys(s.chains).length<2)return void alert("At least two chains are required for alignment...");t.htmlCls.clickMenuCls.SetChainsAdvancedMenu();let i=s.definedSetsCls.setAtomMenu(["protein"]);$("#"+t.pre+e).length&&$("#"+t.pre+e).html(i),$("#"+t.pre+e).resizable()}async launchMmdb(e,t,s,i){let n=this.icn3dui,l=n.icn3d,r=this;n.cfg.notebook||dialog.dialog("close");let o=t?1:0;if(!(e=e.replace(/,/g," ").replace(/\s+/g,",").trim()))return void alert("Please enter a list of PDB IDs or AlphaFold UniProt IDs...");let a=e.split(",");if(i)if(l.structures||1!=a.length||4!=a[0].length&&isNaN(a[0])){n.cfg.mmdbafid=e,n.cfg.bu=o,l.bMmdbafid=!0,l.inputid=l.inputid?l.inputid+n.cfg.mmdbafid:n.cfg.mmdbafid,1==n.cfg.bu?l.loadCmd="load mmdbaf1 "+n.cfg.mmdbafid:l.loadCmd="load mmdbaf0 "+n.cfg.mmdbafid,n.htmlCls.clickMenuCls.setLogCmd(l.loadCmd,!0);let t=!!(l.structures&&Object.keys(l.structures).length>0);await l.chainalignParserCls.downloadMmdbAf(n.cfg.mmdbafid),t&&(l.bSetChainsAdvancedMenu&&l.definedSetsCls.showSets(),l.bAnnoShown&&(await l.showAnnoCls.showAnnotations(),l.annotationCls.resetAnnoTabAll()))}else{r.setLogCmd("load mmdb"+o+" "+e,!1);let t=l.structures&&Object.keys(l.structures).length>0?"_blank":"_self";window.open(s+"?mmdbid="+e+"&bu="+o,t)}else if(1!=a.length||4!=a[0].length&&isNaN(a[0])){r.setLogCmd("load mmdbaf"+o+" "+e,!1);let t=l.structures&&Object.keys(l.structures).length>0?"_blank":"_self";window.open(s+"?mmdbafid="+e+"&bu="+o,t)}else{r.setLogCmd("load mmdb"+o+" "+e,!1);let t=l.structures&&Object.keys(l.structures).length>0?"_blank":"_self";window.open(s+"?mmdbid="+e+"&bu="+o,t)}}allEventFunctions(){let e=this.icn3dui,t=e.icn3d,s=this;if(e.bNode)return;let i=document.URL,n=i.indexOf("?");i=-1==n?i:i.substr(0,n),i.indexOf("/vast/icn3d/")&&(i=i.replace(/\/vast\/icn3d\//g,"/icn3d/")),t.definedSetsCls.clickCustomAtoms(),t.definedSetsCls.clickCommand_apply(),t.definedSetsCls.clickModeswitch(),t.selectionCls.clickShow_selected(),t.selectionCls.clickHide_selected(),t.diagram2dCls.click2Ddgm(),t.cartoon2dCls.click2Dcartoon(),t.ligplotCls.clickLigplot(),t.addTrackCls.clickAddTrackButton(),t.resizeCanvasCls.windowResize(),t.annotationCls.setTabs(),t.resid2specCls.switchHighlightLevel(),e.utilsCls.isMobile()?(t.hlSeqCls.selectSequenceMobile(),t.hlSeqCls.selectChainMobile()):t.hlSeqCls.selectSequenceNonMobile(),e.htmlCls.clickMenuCls.clickMenu1(),e.htmlCls.clickMenuCls.clickMenu2(),e.htmlCls.clickMenuCls.clickMenu3(),e.htmlCls.clickMenuCls.clickMenu4(),e.htmlCls.clickMenuCls.clickMenu5(),e.htmlCls.clickMenuCls.clickMenu6(),e.myEventCls.onIds("#"+e.pre+"menumode","change",(async function(t){e.icn3d,t.preventDefault();let s=$("#"+e.pre+"menumode").val();e.htmlCls.setHtmlCls.setCookie("menumode",s),e.htmlCls.setMenuCls.resetMenu(s)})),e.myEventCls.onIds(["#"+e.pre+"back","#"+e.pre+"mn6_back"],"click",(async function(t){let i=e.icn3d;t.preventDefault(),s.setLogCmd("back",!1),await i.resizeCanvasCls.back()})),e.myEventCls.onIds(["#"+e.pre+"forward","#"+e.pre+"mn6_forward"],"click",(async function(t){let i=e.icn3d;t.preventDefault(),s.setLogCmd("forward",!1),await i.resizeCanvasCls.forward()})),e.myEventCls.onIds(["#"+e.pre+"fullscreen","#"+e.pre+"mn6_fullscreen"],"click",(function(t){let i=e.icn3d;t.preventDefault(),s.setLogCmd("enter full screen",!1),i.bFullscreen=!0,e.htmlCls.WIDTH=$(window).width(),e.htmlCls.HEIGHT=$(window).height(),i.applyCenterCls.setWidthHeight(e.htmlCls.WIDTH,e.htmlCls.HEIGHT),i.drawCls.draw(),i.resizeCanvasCls.openFullscreen($("#"+e.pre+"canvas")[0])})),document.addEventListener("fullscreenchange",this.fullScreenChange.bind(this)),document.addEventListener("webkitfullscreenchange",this.fullScreenChange.bind(this)),document.addEventListener("mozfullscreenchange",this.fullScreenChange.bind(this)),document.addEventListener("msfullscreenchange",this.fullScreenChange.bind(this)),e.myEventCls.onIds(["#"+e.pre+"toggle","#"+e.pre+"mn2_toggle"],"click",(function(t){e.icn3d.selectionCls.toggleSelection(),s.setLogCmd("toggle selection",!0)})),e.myEventCls.onIds("#"+e.pre+"mn2_hl_clrYellow","click",(function(t){let i=e.icn3d;s.setLogCmd("set highlight color yellow",!0),i.hColor=e.parasCls.thr(16776960),i.matShader=i.setColorCls.setOutlineColor("yellow"),i.drawCls.draw()})),e.myEventCls.onIds("#"+e.pre+"mn2_hl_clrGreen","click",(function(t){let i=e.icn3d;s.setLogCmd("set highlight color green",!0),i.hColor=e.parasCls.thr(65280),i.matShader=i.setColorCls.setOutlineColor("green"),i.drawCls.draw()})),e.myEventCls.onIds("#"+e.pre+"mn2_hl_clrRed","click",(function(t){let i=e.icn3d;s.setLogCmd("set highlight color red",!0),i.hColor=e.parasCls.thr(16711680),i.matShader=i.setColorCls.setOutlineColor("red"),i.drawCls.draw()})),e.myEventCls.onIds("#"+e.pre+"mn2_hl_styleOutline","click",(function(t){let i=e.icn3d;s.setLogCmd("set highlight style outline",!0),i.bHighlight=1,i.hlUpdateCls.showHighlight()})),e.myEventCls.onIds("#"+e.pre+"mn2_hl_styleObject","click",(function(t){let i=e.icn3d;s.setLogCmd("set highlight style 3d",!0),i.bHighlight=2,i.hlUpdateCls.showHighlight()})),e.myEventCls.onIds("#"+e.pre+"mn2_hl_styleNone","click",(function(t){let i=e.icn3d;t.stopImmediatePropagation(),i.hlUpdateCls.clearHighlight(),s.setLogCmd("clear selection",!0)})),e.myEventCls.onIds(["#"+e.pre+"alternate","#"+e.pre+"mn2_alternate","#"+e.pre+"alternate2"],"click",(async function(t){let i=e.icn3d;i.bAlternate=!0,await i.alternateCls.alternateStructures(),i.bAlternate=!1,s.setLogCmd("alternate structures",!1)})),e.myEventCls.onIds("#"+e.pre+"mn2_realignresbyres","click",(function(t){e.icn3d,e.htmlCls.dialogCls.openDlg("dl_realignresbyres","Align multiple chains residue by residue")})),e.myEventCls.onIds("#"+e.pre+"realignSelection","click",(function(t){let i=e.icn3d;Object.keys(i.chains).length<2?alert("At least two chains are required for alignment..."):(i.realignParserCls.realign(),s.setLogCmd("realign",!0))})),e.myEventCls.onIds("#"+e.pre+"mn2_realignonseqalign","click",(function(t){e.icn3d.bRender&&e.htmlCls.dialogCls.openDlg("dl_realign","Please select chains to realign"),s.setPredefinedMenu("atomsCustomRealign")})),e.myEventCls.onIds("#"+e.pre+"mn2_realignonstruct","click",(function(t){e.icn3d.bRender&&e.htmlCls.dialogCls.openDlg("dl_realignbystruct","Please select chains to realign"),s.setPredefinedMenu("atomsCustomRealignByStruct")})),e.myEventCls.onIds("#"+e.pre+"mn2_realigntwostru","click",(function(t){e.icn3d.bRender&&e.htmlCls.dialogCls.openDlg("dl_realigntwostru","Please select structures to realign"),s.setPredefinedMenu("atomsCustomRealignByStruct2")})),e.myEventCls.onIds("#"+e.pre+"applyRealign","click",(async function(t){let i=e.icn3d;t.preventDefault(),e.cfg.notebook||dialog.dialog("close");let n=$("#"+e.pre+"atomsCustomRealign").val();n.length>0&&(i.hAtoms=i.definedSetsCls.getAtomsFromNameArray(n)),await i.realignParserCls.realignOnSeqAlign(),n.length>0?s.setLogCmd("realign on seq align | "+n,!0):s.setLogCmd("realign on seq align",!0)})),e.myEventCls.onIds("#"+e.pre+"applyRealignByStruct","click",(async function(t){e.icn3d,t.preventDefault(),e.cfg.notebook||dialog.dialog("close"),await s.setRealign("vast",!1)})),e.myEventCls.onIds("#"+e.pre+"applyRealignByStruct_tmalign","click",(async function(t){e.icn3d,t.preventDefault(),e.cfg.notebook||dialog.dialog("close"),await s.setRealign("tmalign",!1)})),e.myEventCls.onIds("#"+e.pre+"applyRealignByStructMsa","click",(async function(t){e.icn3d,t.preventDefault(),e.cfg.notebook||dialog.dialog("close"),await s.setRealign("vast",!0)})),e.myEventCls.onIds("#"+e.pre+"applyRealignByStructMsa_tmalign","click",(async function(t){e.icn3d,t.preventDefault(),e.cfg.notebook||dialog.dialog("close"),await s.setRealign("tmalign",!0)})),e.myEventCls.onIds("#"+e.pre+"applyRealignByStruct_vastplus","click",(async function(t){let i=e.icn3d;t.preventDefault(),e.cfg.notebook||dialog.dialog("close");let n=$("#"+e.pre+"atomsCustomRealignByStruct2").val();n.length>0&&(i.hAtoms=i.definedSetsCls.getAtomsFromNameArray(n)),await i.vastplusCls.realignOnVastplus(),n.length>0?s.setLogCmd("realign on vastplus | "+n,!0):s.setLogCmd("realign on vastplus",!0)})),e.myEventCls.onIds("#"+e.pre+"applyColorSpectrumAcrossSets","click",(function(t){let i=e.icn3d;t.preventDefault(),e.cfg.notebook||dialog.dialog("close");let n=$("#"+e.pre+"atomsCustomColorSpectrumAcross").val();if(0==n.length)return void alert("Please select some sets");i.setColorCls.setColorAcrossSets(n,!0),s.setLogCmd("set color spectrum | "+n,!0)})),e.myEventCls.onIds("#"+e.pre+"applyColorSpectrumBySets","click",(function(t){let i=e.icn3d;t.preventDefault(),e.cfg.notebook||dialog.dialog("close");let n=$("#"+e.pre+"atomsCustomColorSpectrum").val();if(0==n.length)return void alert("Please select some sets");i.setColorCls.setColorBySets(n,!0),s.setLogCmd("set residues color spectrum | "+n,!0)})),e.myEventCls.onIds("#"+e.pre+"applyColorRainbowAcrossSets","click",(function(t){let i=e.icn3d;t.preventDefault(),e.cfg.notebook||dialog.dialog("close");let n=$("#"+e.pre+"atomsCustomColorRainbowAcross").val();if(0==n.length)return void alert("Please select some sets");i.setColorCls.setColorAcrossSets(n,!1),s.setLogCmd("set color rainbow | "+n,!0)})),e.myEventCls.onIds("#"+e.pre+"applyColorRainbowBySets","click",(function(t){let i=e.icn3d;t.preventDefault(),e.cfg.notebook||dialog.dialog("close");let n=$("#"+e.pre+"atomsCustomColorRainbow").val();if(0==n.length)return void alert("Please select some sets");i.setColorCls.setColorBySets(n,!1),s.setLogCmd("set residues color rainbow | "+n,!0)})),e.myEventCls.onIds("#"+e.pre+"anno_summary","click",(function(t){let i=e.icn3d;t.preventDefault(),i.annotationCls.setAnnoViewAndDisplay("overview"),s.setLogCmd("set view overview",!0)})),e.myEventCls.onIds("#"+e.pre+"anno_details","click",(function(t){let i=e.icn3d;t.preventDefault(),i.annotationCls.setAnnoViewAndDisplay("detailed view"),s.setLogCmd("set view detailed view",!0)})),e.myEventCls.onIds("#"+e.pre+"show_annotations","click",(async function(t){let i=e.icn3d;await i.showAnnoCls.showAnnotations(),s.setLogCmd("view annotations",!0)})),e.myEventCls.onIds("#"+e.pre+"showallchains","click",(function(t){e.icn3d.annotationCls.showAnnoAllChains(),s.setLogCmd("show annotations all chains",!0)})),e.myEventCls.onIds("#"+e.pre+"show_alignsequences","click",(function(t){e.icn3d,e.htmlCls.dialogCls.openDlg("dl_alignment","Select residues in aligned sequences")})),e.myEventCls.onIds(["#"+e.pre+"show_2ddgm","#"+e.pre+"mn2_2ddgm"],"click",(async function(t){let i=e.icn3d;e.htmlCls.dialogCls.openDlg("dl_2ddgm","2D Diagram"),await i.viewInterPairsCls.retrieveInteractionData(),s.setLogCmd("view interactions",!0)})),e.myEventCls.onIds("#"+e.pre+"mn2_2ddepiction","click",(async function(t){let i=e.icn3d;await i.ligplotCls.drawLigplot(i.atoms,!0),s.setLogCmd("view 2d depiction",!0)})),e.myEventCls.onIds("#"+e.pre+"search_seq_button","click",(async function(t){e.icn3d,t.stopImmediatePropagation(),await s.searchSeq()})),e.myEventCls.onIds("#"+e.pre+"search_seq","keyup",(async function(t){e.icn3d,13===t.keyCode&&(t.preventDefault(),await s.searchSeq())})),e.myEventCls.onIds("#"+e.pre+"reload_vastplus","click",(function(t){let i=e.icn3d;t.preventDefault(),e.cfg.notebook||dialog.dialog("close"),s.setLogCmd("vast+ search "+$("#"+e.pre+"vastpluspdbid").val(),!1);let n=i.structures&&Object.keys(i.structures).length>0?"_blank":"_self";window.open("https://www.ncbi.nlm.nih.gov/Structure/vastplus/vastplus.cgi?uid="+$("#"+e.pre+"vastpluspdbid").val(),n)})),e.myEventCls.onIds("#"+e.pre+"reload_vast","click",(function(t){let i=e.icn3d;t.preventDefault(),e.cfg.notebook||dialog.dialog("close"),s.setLogCmd("vast search "+$("#"+e.pre+"vastpdbid").val()+"_"+$("#"+e.pre+"vastchainid").val(),!1);let n=i.structures&&Object.keys(i.structures).length>0?"_blank":"_self";window.open("https://www.ncbi.nlm.nih.gov/Structure/vast/vastsrv.cgi?pdbid="+$("#"+e.pre+"vastpdbid").val()+"&chain="+$("#"+e.pre+"vastchainid").val(),n)})),e.myEventCls.onIds("#"+e.pre+"reload_foldseek","click",(function(t){e.icn3d,t.preventDefault(),e.cfg.notebook||dialog.dialog("close");let n=$("#"+e.pre+"foldseekchainids").val(),l=s.convertUniProtInChains(n);s.setLogCmd("load chainalignment "+l,!0),window.open(i+"?chainalign="+l+"&aligntool=tmalign&showalignseq=1&bu=0","_self")})),e.myEventCls.onIds("#"+e.pre+"reload_mmtf","click",(function(t){let n=e.icn3d;t.preventDefault(),e.cfg.notebook||dialog.dialog("close"),s.setLogCmd("load bcif "+$("#"+e.pre+"mmtfid").val(),!1);let l=n.structures&&Object.keys(n.structures).length>0?"_blank":"_self";window.open(i+"?bcifid="+$("#"+e.pre+"mmtfid").val(),l)})),e.myEventCls.onIds("#"+e.pre+"mmtfid","keyup",(function(t){let n=e.icn3d;if(13===t.keyCode){t.preventDefault(),e.cfg.notebook||dialog.dialog("close"),s.setLogCmd("load mmtf "+$("#"+e.pre+"mmtfid").val(),!1);let l=n.structures&&Object.keys(n.structures).length>0?"_blank":"_self";window.open(i+"?mmtfid="+$("#"+e.pre+"mmtfid").val(),l)}})),e.myEventCls.onIds("#"+e.pre+"reload_pdb","click",(function(t){let n=e.icn3d;t.preventDefault(),e.cfg.notebook||dialog.dialog("close"),s.setLogCmd("load pdb "+$("#"+e.pre+"pdbid").val(),!1);let l=n.structures&&Object.keys(n.structures).length>0?"_blank":"_self";window.open(i+"?pdbid="+$("#"+e.pre+"pdbid").val(),l)})),e.myEventCls.onIds("#"+e.pre+"translate_pdb","click",(function(t){let i=e.icn3d;t.preventDefault(),e.cfg.notebook||dialog.dialog("close");let n=$("#"+e.pre+"translateX").val(),l=$("#"+e.pre+"translateY").val(),r=$("#"+e.pre+"translateZ").val();i.transformCls.translateCoord(i.hAtoms,parseFloat(n),parseFloat(l),parseFloat(r)),i.drawCls.draw(),s.setLogCmd("translate pdb "+n+" "+l+" "+r,!0)})),e.myEventCls.onIds("#"+e.pre+"measure_angle","click",(function(t){e.icn3d,t.preventDefault(),e.cfg.notebook||dialog.dialog("close");let i=$("#"+e.pre+"v1X").val(),n=$("#"+e.pre+"v1Y").val(),l=$("#"+e.pre+"v1Z").val(),r=$("#"+e.pre+"v2X").val(),o=$("#"+e.pre+"v2Y").val(),a=$("#"+e.pre+"v2Z").val(),d=new THREE.Vector3(parseFloat(i),parseFloat(n),parseFloat(l)).angleTo(new THREE.Vector3(parseFloat(r),parseFloat(o),parseFloat(a)))/3.1416*180;d=Math.abs(d).toFixed(0),d>180&&(d-=180),d>90&&(d=180-d),s.setLogCmd("The angle is "+d+" degree",!1),$("#"+e.pre+"angle_value").val(d)})),e.myEventCls.onIds("#"+e.pre+"matrix_pdb","click",(function(t){let i=e.icn3d;t.preventDefault(),e.cfg.notebook||dialog.dialog("close");let n=[];for(let t=0;t<16;++t)n.push(parseFloat($("#"+e.pre+"matrix"+t).val()));i.transformCls.rotateCoord(i.hAtoms,n),i.drawCls.draw(),s.setLogCmd("rotate pdb "+n,!0)})),e.myEventCls.onIds("#"+e.pre+"pdbid","keyup",(function(t){let n=e.icn3d;if(13===t.keyCode){t.preventDefault(),e.cfg.notebook||dialog.dialog("close"),s.setLogCmd("load pdb "+$("#"+e.pre+"pdbid").val(),!1);let l=n.structures&&Object.keys(n.structures).length>0?"_blank":"_self";window.open(i+"?pdbid="+$("#"+e.pre+"pdbid").val(),l)}})),e.myEventCls.onIds("#"+e.pre+"reload_af","click",(function(t){let n=e.icn3d;t.preventDefault(),e.cfg.notebook||dialog.dialog("close"),s.setLogCmd("load af "+$("#"+e.pre+"afid").val(),!1);let l=n.structures&&Object.keys(n.structures).length>0?"_blank":"_self";window.open(i+"?afid="+$("#"+e.pre+"afid").val(),l)})),e.myEventCls.onIds("#"+e.pre+"reload_afmap","click",(async function(t){let i=e.icn3d;t.preventDefault(),e.cfg.notebook||dialog.dialog("close");let n=e.cfg.afid?e.cfg.afid:$("#"+e.pre+"afid").val();s.setLogCmd("set half pae map "+n,!0),await i.contactMapCls.afErrorMap(n)})),e.myEventCls.onIds("#"+e.pre+"reload_afmapfull","click",(async function(t){let i=e.icn3d;t.preventDefault(),e.cfg.notebook||dialog.dialog("close");let n=e.cfg.afid?e.cfg.afid:$("#"+e.pre+"afid").val();s.setLogCmd("set full pae map "+n,!0),await i.contactMapCls.afErrorMap(n,!0)})),e.myEventCls.onIds("#"+e.pre+"afid","keyup",(function(t){let n=e.icn3d;if(13===t.keyCode){t.preventDefault(),e.cfg.notebook||dialog.dialog("close"),s.setLogCmd("load af "+$("#"+e.pre+"afid").val(),!1);let l=n.structures&&Object.keys(n.structures).length>0?"_blank":"_self";window.open(i+"?afid="+$("#"+e.pre+"afid").val(),l)}})),e.myEventCls.onIds("#"+e.pre+"reload_opm","click",(function(t){let n=e.icn3d;t.preventDefault(),e.cfg.notebook||dialog.dialog("close"),s.setLogCmd("load opm "+$("#"+e.pre+"opmid").val(),!1);let l=n.structures&&Object.keys(n.structures).length>0?"_blank":"_self";window.open(i+"?opmid="+$("#"+e.pre+"opmid").val(),l)})),e.myEventCls.onIds("#"+e.pre+"opmid","keyup",(function(t){let n=e.icn3d;if(13===t.keyCode){t.preventDefault(),e.cfg.notebook||dialog.dialog("close"),s.setLogCmd("load opm "+$("#"+e.pre+"opmid").val(),!1);let l=n.structures&&Object.keys(n.structures).length>0?"_blank":"_self";window.open(i+"?opmid="+$("#"+e.pre+"opmid").val(),l)}})),e.myEventCls.onIds("#"+e.pre+"reload_align_refined","click",(function(t){let n=e.icn3d;t.preventDefault(),e.cfg.notebook||dialog.dialog("close");let l=$("#"+e.pre+"alignid1").val()+","+$("#"+e.pre+"alignid2").val();s.setLogCmd("load alignment "+l+" | parameters &atype=1&bu=1",!1);let r=n.structures&&Object.keys(n.structures).length>0?"_blank":"_self";window.open(i+"?align="+l+"&showalignseq=1&atype=1&bu=1",r)})),e.myEventCls.onIds("#"+e.pre+"reload_align_ori","click",(function(t){let n=e.icn3d;t.preventDefault(),e.cfg.notebook||dialog.dialog("close");let l=$("#"+e.pre+"alignid1").val()+","+$("#"+e.pre+"alignid2").val();s.setLogCmd("load alignment "+l+" | parameters &atype=0&bu=1",!1);let r=n.structures&&Object.keys(n.structures).length>0?"_blank":"_self";window.open(i+"?align="+l+"&showalignseq=1&atype=0&bu=1",r)})),e.myEventCls.onIds("#"+e.pre+"reload_align_tmalign","click",(function(t){let n=e.icn3d;t.preventDefault(),e.cfg.notebook||dialog.dialog("close");let l=$("#"+e.pre+"alignid1").val()+","+$("#"+e.pre+"alignid2").val();s.setLogCmd("load alignment "+l+" | parameters &atype=2&bu=1",!1);let r=n.structures&&Object.keys(n.structures).length>0?"_blank":"_self";window.open(i+"?align="+l+"&showalignseq=1&atype=2&bu=1",r)})),e.myEventCls.onIds("#"+e.pre+"reload_alignaf","click",(function(t){let n=e.icn3d;t.preventDefault(),e.cfg.notebook||dialog.dialog("close");let l=$("#"+e.pre+"alignafid1").val()+"_A,"+$("#"+e.pre+"alignafid2").val()+"_A";s.setLogCmd("load chains "+l+" | residues | resdef ",!1);let r=n.structures&&Object.keys(n.structures).length>0?"_blank":"_self";window.open(i+"?chainalign="+l+"&resnum=&resdef=&showalignseq=1",r)})),e.myEventCls.onIds("#"+e.pre+"reload_alignaf_tmalign","click",(function(t){let n=e.icn3d;t.preventDefault(),e.cfg.notebook||dialog.dialog("close");let l=$("#"+e.pre+"alignafid1").val()+"_A,"+$("#"+e.pre+"alignafid2").val()+"_A";s.setLogCmd("load chains "+l+" | residues | resdef | align tmalign",!1);let r=n.structures&&Object.keys(n.structures).length>0?"_blank":"_self";window.open(i+"?chainalign="+l+"&aligntool=tmalign&resnum=&resdef=&showalignseq=1",r)})),e.myEventCls.onIds("#"+e.pre+"reload_chainalign_asym","click",(function(t){let n=e.icn3d;t.preventDefault(),e.cfg.notebook||dialog.dialog("close");let l=$("#"+e.pre+"chainalignids").val(),r=s.convertUniProtInChains(l);s.setLogCmd("load chains "+r+" on asymmetric unit | residues | resdef ",!1);let o=n.structures&&Object.keys(n.structures).length>0?"_blank":"_self";window.open(i+"?chainalign="+r+"&resnum=&resdef=&showalignseq=1&bu=0",o)})),e.myEventCls.onIds("#"+e.pre+"reload_chainalign_asym2","click",(function(t){let n=e.icn3d;t.preventDefault(),e.cfg.notebook||dialog.dialog("close");let l=$("#"+e.pre+"chainalignids2").val(),r=s.convertUniProtInChains(l),o=$("#"+e.pre+"resalignids").val();s.setLogCmd("load chains "+r+" on asymmetric unit | residues "+o+" | resdef ",!1);let a=n.structures&&Object.keys(n.structures).length>0?"_blank":"_self";window.open(i+"?chainalign="+r+"&resnum="+o+"&resdef=&showalignseq=1&bu=0",a)})),e.myEventCls.onIds("#"+e.pre+"reload_chainalign_asym3","click",(function(t){let n=e.icn3d;t.preventDefault(),e.cfg.notebook||dialog.dialog("close");let l=$("#"+e.pre+"chainalignids3").val(),r=s.convertUniProtInChains(l),o=$("#"+e.pre+"predefinedres").val().trim().replace(/\n/g,": ");if(o&&r.split(",").length-1!=o.split(": ").length)return void alert("Please make sure the number of chains and the lines of predefined residues are the same...");s.setLogCmd("load chains "+r+" on asymmetric unit | residues | resdef "+o,!1);let a=n.structures&&Object.keys(n.structures).length>0?"_blank":"_self";window.open(i+"?chainalign="+r+"&resnum=&resdef="+o+"&showalignseq=1&bu=0",a)})),e.myEventCls.onIds("#"+e.pre+"reload_chainalign_asym4","click",(async function(t){let i=e.icn3d;t.preventDefault(),e.cfg.notebook||dialog.dialog("close");let n=$("#"+e.pre+"chainalignids4").val(),l=s.convertUniProtInChains(n),r=$("#"+e.pre+"predefinedres2").val().trim().replace(/\n/g,": ");if(r&&l.split(",").length-1!=r.split(": ").length)return void alert("Please make sure the number of chains and the lines of predefined residues are the same...");e.cfg.resdef=r.replace(/:/gi,";");let o=l.split(",");await i.realignParserCls.realignChainOnSeqAlign(void 0,o,!0,!0),s.setLogCmd("realign predefined "+l+" "+r,!0)})),e.myEventCls.onIds("#"+e.pre+"reload_chainalign_tmalign","click",(function(t){let n=e.icn3d;t.preventDefault(),e.cfg.notebook||dialog.dialog("close");let l=$("#"+e.pre+"chainalignids").val(),r=s.convertUniProtInChains(l);s.setLogCmd("load chains "+r+" on asymmetric unit | residues | resdef | align tmalign",!1);let o=n.structures&&Object.keys(n.structures).length>0?"_blank":"_self";window.open(i+"?chainalign="+r+"&aligntool=tmalign&resnum=&resdef=&showalignseq=1&bu=0",o)})),e.myEventCls.onIds("#"+e.pre+"reload_mutation_3d","click",(async function(t){let n=e.icn3d;t.preventDefault(),e.cfg.notebook||dialog.dialog("close");let l,r,o=$("#"+e.pre+"mutationids").val();if(l=$("#"+e.pre+"type_mmdbid").is(":checked")?"mmdbid":"afid",r=$("#"+e.pre+"showin_currentpage").is(":checked")?"currentpage":"newpage","currentpage"==r){let e=o;await n.scapCls.retrieveScap(e),s.setLogCmd("scap 3d "+e,!0),s.setLogCmd("select displayed set",!0)}else{let e=o.substr(0,o.indexOf("_"));s.setLogCmd("3d of mutation "+o,!1);let t=n.structures&&Object.keys(n.structures).length>0?"_blank":"_self";window.open(i+"?"+l+"="+e+"&command=scap 3d "+o+"; select displayed set",t)}})),e.myEventCls.onIds("#"+e.pre+"reload_mutation_pdb","click",(async function(t){let n=e.icn3d;t.preventDefault(),e.cfg.notebook||dialog.dialog("close");let l,r,o=$("#"+e.pre+"mutationids").val();if(l=$("#"+e.pre+"type_mmdbid").is(":checked")?"mmdbid":"afid",r=$("#"+e.pre+"showin_currentpage").is(":checked")?"currentpage":"newpage","currentpage"==r){let e=o,t=!0;await n.scapCls.retrieveScap(e,void 0,t),s.setLogCmd("scap pdb "+e,!0)}else{let e=o.substr(0,o.indexOf("_"));s.setLogCmd("pdb of mutation "+o,!1);let t=n.structures&&Object.keys(n.structures).length>0?"_blank":"_self";window.open(i+"?"+l+"="+e+"&command=scap pdb "+o+"; select displayed set",t)}})),e.myEventCls.onIds("#"+e.pre+"reload_mutation_inter","click",(async function(t){let n=e.icn3d;t.preventDefault(),e.cfg.notebook||dialog.dialog("close");let l,r,o=$("#"+e.pre+"mutationids").val();if(l=$("#"+e.pre+"type_mmdbid").is(":checked")?"mmdbid":"afid",r=$("#"+e.pre+"showin_currentpage").is(":checked")?"currentpage":"newpage","currentpage"==r){let e=o,t=!0;await n.scapCls.retrieveScap(e,t),s.setLogCmd("scap interaction "+e,!0);let i=e.split("_"),l="."+i[1]+":"+i[2],r="snp_"+i[1]+"_"+i[2];s.setLogCmd("select "+l+" | name "+r,!0),s.setLogCmd("line graph interaction pairs | selected non-selected | hbonds,salt bridge,interactions,halogen,pi-cation,pi-stacking | false | threshold 3.8 6 4 3.8 6 5.5",!0),s.setLogCmd("adjust dialog dl_linegraph",!0),s.setLogCmd("select displayed set",!0)}else{let e=o.split(","),t=[];for(let s=0,i=e.length;s<i;++s){let i=e[s].lastIndexOf("_"),n=e[s].substr(0,i);t.push(n)}let r=o.substr(0,o.indexOf("_"));n.structures||(n.structures={},n.structures[r]=1),n.resid2specCls.residueids2spec(t),s.setLogCmd("interaction change of mutation "+o,!1);let a=n.structures&&Object.keys(n.structures).length>0?"_blank":"_self";window.open(i+"?"+l+"="+r+"&command=scap interaction "+o,a)}})),e.myEventCls.onIds("#"+e.pre+"reload_mmcif","click",(function(t){let n=e.icn3d;t.preventDefault(),e.cfg.notebook||dialog.dialog("close"),s.setLogCmd("load mmcif "+$("#"+e.pre+"mmcifid").val(),!1);let l=n.structures&&Object.keys(n.structures).length>0?"_blank":"_self";window.open(i+"?mmcifid="+$("#"+e.pre+"mmcifid").val(),l)})),e.myEventCls.onIds("#"+e.pre+"mmcifid","keyup",(function(t){let n=e.icn3d;if(13===t.keyCode){t.preventDefault(),e.cfg.notebook||dialog.dialog("close"),s.setLogCmd("load mmcif "+$("#"+e.pre+"mmcifid").val(),!1);let l=n.structures&&Object.keys(n.structures).length>0?"_blank":"_self";window.open(i+"?mmcifid="+$("#"+e.pre+"mmcifid").val(),l)}})),e.myEventCls.onIds("#"+e.pre+"reload_mmdb","click",(function(t){let n=e.icn3d;t.preventDefault(),s.setLogCmd("load mmdb1 "+$("#"+e.pre+"mmdbid").val(),!1);let l=n.structures&&Object.keys(n.structures).length>0?"_blank":"_self";window.open(i+"?mmdbid="+$("#"+e.pre+"mmdbid").val()+"&bu=1",l)})),e.myEventCls.onIds("#"+e.pre+"reload_mmdb_asym","click",(function(t){let n=e.icn3d;t.preventDefault(),s.setLogCmd("load mmdb0 "+$("#"+e.pre+"mmdbid").val(),!1);let l=n.structures&&Object.keys(n.structures).length>0?"_blank":"_self";window.open(i+"?mmdbid="+$("#"+e.pre+"mmdbid").val()+"&bu=0",l)})),e.myEventCls.onIds("#"+e.pre+"reload_mmdbaf","click",(function(t){e.icn3d,t.preventDefault();let n=$("#"+e.pre+"mmdbafid").val();s.launchMmdb(n,1,i)})),e.myEventCls.onIds("#"+e.pre+"reload_mmdbaf_asym","click",(function(t){e.icn3d,t.preventDefault();let n=$("#"+e.pre+"mmdbafid").val();s.launchMmdb(n,0,i)})),e.myEventCls.onIds("#"+e.pre+"reload_mmdbaf_append","click",(function(t){e.icn3d,t.preventDefault();let n=$("#"+e.pre+"mmdbafid").val();s.launchMmdb(n,1,i,!0)})),e.myEventCls.onIds("#"+e.pre+"reload_mmdbaf_asym_append","click",(function(t){e.icn3d,t.preventDefault();let n=$("#"+e.pre+"mmdbafid").val();s.launchMmdb(n,0,i,!0)})),e.myEventCls.onIds("#"+e.pre+"mmdbid","keyup",(function(t){let n=e.icn3d;if(13===t.keyCode){t.preventDefault(),s.setLogCmd("load mmdb1 "+$("#"+e.pre+"mmdbid").val(),!1);let l=n.structures&&Object.keys(n.structures).length>0?"_blank":"_self";window.open(i+"?mmdbid="+$("#"+e.pre+"mmdbid").val()+"&bu=1",l)}})),e.myEventCls.onIds("#"+e.pre+"mmdbafid","keyup",(function(t){if(e.icn3d,13===t.keyCode){t.preventDefault();let n=$("#"+e.pre+"mmdbafid").val();s.launchMmdb(n,1,i)}})),e.myEventCls.onIds("#"+e.pre+"reload_blast_rep_id","click",(function(t){let n=e.icn3d;t.preventDefault(),e.cfg.notebook||dialog.dialog("close");let l=$("#"+e.pre+"query_id").val().trim();if("M_"==l.substr(1,2))return void alert("You are inputting a nucleotide accession "+l+". Please use a protein accession instead.");let r=encodeURIComponent($("#"+e.pre+"query_fasta").val()),o=$("#"+e.pre+"blast_rep_id").val();s.setLogCmd("load seq_struct_ids "+l+","+o,!1),l=""!==l&&void 0!==l?l:r;let a=n.structures&&Object.keys(n.structures).length>0?"_blank":"_self";window.open(i+"?from=icn3d&alg=blast&blast_rep_id="+o+"&query_id="+l+"&command=view annotations; set annotation cdd; set annotation site; set view detailed view; select chain "+o+"; show selection",a)})),e.myEventCls.onIds("#"+e.pre+"run_esmfold","click",(async function(t){let i=e.icn3d;t.preventDefault(),e.cfg.notebook||dialog.dialog("close"),$("#"+e.pre+"dl_mmdbafid").hasClass("ui-dialog-content")&&$("#"+e.pre+"dl_mmdbafid").dialog("close");let n=$("#"+e.pre+"esmfold_fasta").val(),l="stru--";if(-1!=n.indexOf(">")){let e=n.indexOf("\n");if(i.esmTitle=n.substr(1,e-1).trim(),-1!=i.esmTitle.indexOf("|")){let e=i.esmTitle.split("|");l=e.length>2?e[1]:i.esmTitle}else l=-1!=i.esmTitle.indexOf(" ")?i.esmTitle.substr(0,i.esmTitle.indexOf(" ")):i.esmTitle;l.length<6&&(l=l.padEnd(6,"-")),n=n.substr(e+1)}if(n=n.replace(/\s/g,""),n.length>400)return void alert("Your sequence is larger than 400 characters. Please consider to split it as described at https://github.com/facebookresearch/esm/issues/21.");s.setLogCmd("Run ESMFold with the sequence "+n,!1);let r=await e.getAjaxPostPromise("https://api.esmatlas.com/foldSequence/v1/pdb/",n,!0,"Problem in returning PDB from ESMFold server...",void 0,!0,"text");i.bResetAnno=!0,i.bInputfile=!0,i.InputfileType="pdb",i.InputfileData=i.InputfileData?i.InputfileData+"\nENDMDL\n"+r:r,i.bEsmfold=!0;await i.pdbParserCls.loadPdbData(r,l,void 0,!0,void 0,void 0,void 0,i.bEsmfold)})),e.myEventCls.onIds("#"+e.pre+"reload_alignsw","click",(function(t){let n=e.icn3d;t.preventDefault(),e.cfg.notebook||dialog.dialog("close");let l=$("#"+e.pre+"query_id").val().trim();if("M_"==l.substr(1,2))return void alert("You are inputting a nucleotide accession "+l+". Please use a protein accession instead.");let r=encodeURIComponent($("#"+e.pre+"query_fasta").val()),o=$("#"+e.pre+"blast_rep_id").val();s.setLogCmd("load seq_struct_ids_smithwm "+l+","+o,!1),l=""!==l&&void 0!==l?l:r;let a=n.structures&&Object.keys(n.structures).length>0?"_blank":"_self";window.open(i+"?from=icn3d&alg=smithwm&blast_rep_id="+o+"&query_id="+l+"&command=view annotations; set annotation cdd; set annotation site; set view detailed view; select chain "+o+"; show selection",a)})),e.myEventCls.onIds("#"+e.pre+"reload_alignswlocal","click",(function(t){let n=e.icn3d;t.preventDefault(),e.cfg.notebook||dialog.dialog("close");let l=$("#"+e.pre+"query_id").val().trim();if("M_"==l.substr(1,2))return void alert("You are inputting a nucleotide accession "+l+". Please use a protein accession instead.");let r=encodeURIComponent($("#"+e.pre+"query_fasta").val()),o=$("#"+e.pre+"blast_rep_id").val();s.setLogCmd("load seq_struct_ids_local_smithwm "+l+","+o,!1),l=""!==l&&void 0!==l?l:r;let a=n.structures&&Object.keys(n.structures).length>0?"_blank":"_self";window.open(i+"?from=icn3d&alg=local_smithwm&blast_rep_id="+o+"&query_id="+l+"&command=view annotations; set annotation cdd; set annotation site; set view detailed view; select chain "+o+"; show selection",a)})),e.myEventCls.onIds("#"+e.pre+"reload_proteinname","click",(function(t){let n=e.icn3d;t.preventDefault(),e.cfg.notebook||dialog.dialog("close"),s.setLogCmd("load protein "+$("#"+e.pre+"proteinname").val(),!1);let l=n.structures&&Object.keys(n.structures).length>0?"_blank":"_self";window.open(i+"?protein="+$("#"+e.pre+"proteinname").val(),l)})),e.myEventCls.onIds("#"+e.pre+"reload_refseq","click",(function(t){let n=e.icn3d;t.preventDefault(),e.cfg.notebook||dialog.dialog("close"),s.setLogCmd("load refseq "+$("#"+e.pre+"refseqid").val(),!1);let l=n.structures&&Object.keys(n.structures).length>0?"_blank":"_self";window.open(i+"?refseqid="+$("#"+e.pre+"refseqid").val(),l)})),e.myEventCls.onIds("#"+e.pre+"gi","keyup",(function(t){let n=e.icn3d;if(13===t.keyCode){t.preventDefault(),e.cfg.notebook||dialog.dialog("close"),s.setLogCmd("load gi "+$("#"+e.pre+"gi").val(),!1);let l=n.structures&&Object.keys(n.structures).length>0?"_blank":"_self";window.open(i+"?gi="+$("#"+e.pre+"gi").val(),l)}})),e.myEventCls.onIds("#"+e.pre+"reload_uniprotid","click",(function(t){let n=e.icn3d;t.preventDefault(),e.cfg.notebook||dialog.dialog("close"),s.setLogCmd("load uniprotid "+$("#"+e.pre+"uniprotid").val(),!1);let l=n.structures&&Object.keys(n.structures).length>0?"_blank":"_self";window.open(i+"?uniprotid="+$("#"+e.pre+"uniprotid").val(),l)})),e.myEventCls.onIds("#"+e.pre+"uniprotid","keyup",(function(t){let n=e.icn3d;if(13===t.keyCode){t.preventDefault(),e.cfg.notebook||dialog.dialog("close"),s.setLogCmd("load uniprotid "+$("#"+e.pre+"uniprotid").val(),!1);let l=n.structures&&Object.keys(n.structures).length>0?"_blank":"_self";window.open(i+"?uniprotid="+$("#"+e.pre+"uniprotid").val(),l)}})),e.myEventCls.onIds("#"+e.pre+"reload_cid","click",(function(t){let n=e.icn3d;t.preventDefault(),e.cfg.notebook||dialog.dialog("close"),s.setLogCmd("load cid "+$("#"+e.pre+"cid").val(),!1);let l=n.structures&&Object.keys(n.structures).length>0?"_blank":"_self";window.open(i+"?cid="+$("#"+e.pre+"cid").val(),l)})),e.myEventCls.onIds("#"+e.pre+"reload_smiles","click",(function(t){let s=e.icn3d;t.preventDefault(),e.cfg.notebook||dialog.dialog("close");let n=s.structures&&Object.keys(s.structures).length>0?"_blank":"_self";n="_blank",window.open(i+"?smiles="+encodeURIComponent($("#"+e.pre+"smiles").val()),"_blank")})),e.myEventCls.onIds("#"+e.pre+"cid","keyup",(function(t){let n=e.icn3d;if(13===t.keyCode){t.preventDefault(),e.cfg.notebook||dialog.dialog("close"),s.setLogCmd("load cid "+$("#"+e.pre+"cid").val(),!1);let l=n.structures&&Object.keys(n.structures).length>0?"_blank":"_self";window.open(i+"?cid="+$("#"+e.pre+"cid").val(),l)}})),e.htmlCls.setHtmlCls.clickReload_pngimage(),e.myEventCls.onIds("#"+e.pre+"reload_state","click",(function(t){let i=e.icn3d;t.preventDefault(),e.cfg.notebook||dialog.dialog("close"),e.cfg.notebook?i.resizeCanvasCls.closeDialogs():$(".ui-dialog-content").dialog("close"),i.bInputfile||i.init();let n=$("#"+e.pre+"state")[0].files[0];if(n){e.htmlCls.setHtmlCls.fileSupport();let t=new FileReader;t.onload=async function(t){i.bStatefile=!0;let n=t.target.result;s.setLogCmd("load state file "+$("#"+e.pre+"state").val(),!1),i.commands=[],i.optsHistory=[],await i.loadScriptCls.loadScript(n,!0)},t.readAsText(n)}else alert("Please select a file before clicking 'Load'")})),e.myEventCls.onIds("#"+e.pre+"reload_selectionfile","click",(function(t){let i=e.icn3d;t.preventDefault(),e.cfg.notebook||dialog.dialog("close");let n=$("#"+e.pre+"selectionfile")[0].files[0];if(n){e.htmlCls.setHtmlCls.fileSupport();let t=new FileReader;t.onload=async function(t){let n=t.target.result;await i.selectionCls.loadSelection(n),s.setLogCmd("load selection file "+$("#"+e.pre+"selectionfile").val(),!1)},t.readAsText(n)}else alert("Please select a file before clicking 'Load'")})),e.myEventCls.onIds("#"+e.pre+"reload_collectionfile","click",(function(t){let s=e.icn3d;t.preventDefault();let i=$("#"+e.pre+"collectionfile")[0].files[0];if(i){e.cfg.notebook||dialog.dialog("close"),e.cfg.notebook?s.resizeCanvasCls.closeDialogs():$(".ui-dialog-content").dialog("close"),s.dAtoms=e.hashUtilsCls.cloneHash(s.atoms),s.hAtoms=e.hashUtilsCls.cloneHash(s.atoms),e.htmlCls.setHtmlCls.fileSupport();let n=i.name.split(".").pop().toLowerCase(),l={};function r(e){let t=JSON.parse(e),s={};return t.structures.map((({id:e,title:t,description:i,commands:n})=>{e&&e.includes(".pdb")&&(e=e.split(".pdb")[0]),s[e]=[e,t,i,n,!1]})),s}function o(e,t="",i=[]){let n=e.split("\n"),l=[],r=[];n.forEach((e=>{e.startsWith("HEADER")&&(r=[],l.push(r)),r.push(e)}));let o={};return l.forEach((e=>{let n=e[0].replace(/[\n\r]/g,"").trim().split(" ").filter(Boolean),l=n[n.length-1],r=e[1].startsWith("TITLE")?e[1].split("TITLE").pop().trim():l;o[l]=[l,r,t,i,!0];const a=e.map((e=>e.trim()));s.pdbCollection[l]=a})),o}if($("#"+s.pre+"collections_menu").empty(),$("#"+s.pre+"collections_menu").off("change"),dl_collectionAppendStructureNone.checked||void 0===s.allData?(s.bInputfile=!1,s.pdbCollection={},s.allData={},s.allData.all={atoms:{},proteins:{},nucleotides:{},chemicals:{},ions:{},water:{},structures:{},ssbondpnts:{},residues:{},chains:{},chainsSeq:{},defNames2Atoms:{},defNames2Residues:{}},s.allData.prev={},s.selectCollectionsCls.reset()):s.collections&&(l=s.collections),"json"===n||"pdb"===n){let a=new FileReader;a.onload=async function(t){if("json"===n){let e=r(t.target.result);l={...l,...e}}else if("pdb"===n){s.bInputfile=!0;let e=o(t.target.result);l={...l,...e}}let i=await s.selectCollectionsCls.setAtomMenu(l);s.collections=l,$("#"+s.pre+"collections_menu").html(i),await s.selectCollectionsCls.clickStructure(l),$("#"+s.pre+"collections_menu").trigger("change"),e.htmlCls.clickMenuCls.setLogCmd("load collection file "+$("#"+e.pre+"collectionfile").val(),!1)},a.readAsText(i)}else{if("zip"!==n&&"gz"!==n)throw new Error("Invalid file type");{s.bInputfile=!0;let d=new FileReader;d.onload=async function(t){if("zip"===n){let s="./script/jszip.js";await e.getAjaxPromise(s,"script");let i=new JSZip;try{let s=await i.loadAsync(t.target.result),n=!1,a=!1,d=!1,c=[],h=[],p=[];for(let e in s.files){let t=s.files[e];t.dir||(e.endsWith(".json")?(n=!0,c.push(t)):e.endsWith(".pdb")?(a=!0,h.push(t)):e.endsWith(".gz")&&(d=!0,p.push(t)))}if(n&&a){let e=[];for(const t of c){r(await t.async("text")).forEach((t=>{e.push(t)}))}for(const[t,s,i,n,r]of e){let e=h.find((e=>e.name.toLowerCase().includes(t.toLowerCase())));if(e){o(await e.async("text"),i,n).forEach((e=>{l.push(e)}))}}}else if(n)c.forEach((async e=>{r(await e.async("text")).forEach((e=>{l.push(e)}))}));else if(a)h.forEach((async e=>{o(await e.async("text")).forEach((e=>{l.push(e)}))}));else if(d){let t="./script/pako.js";await e.getAjaxPromise(t,"script");try{for(const e of p){let t=await e.async("uint8array");o(pako.inflate(t,{to:"string"})).forEach((e=>{l.push(e)}))}}catch(e){console.error("Error loading GZ file",e)}}}catch(e){console.error("Error loading ZIP file",e)}}else if("gz"===n){let s="./script/pako.js";await e.getAjaxPromise(s,"script");try{const e=new Uint8Array(t.target.result),s=pako.inflate(e,{to:"string"});l=o(s)}catch(e){console.error("Error loading GZ file",e)}}let i=await s.selectCollectionsCls.setAtomMenu(l);$("#"+s.pre+"collections_menu").html(i),await s.selectCollectionsCls.clickStructure(l),s.collections=l,$("#"+s.pre+"collections_menu").trigger("change"),e.htmlCls.clickMenuCls.setLogCmd("load collection file "+$("#"+e.pre+"collectionfile").val(),!1)},d.onerror=function(e){console.error("Error reading file",e)},d.readAsArrayBuffer(i)}}s.allData&&Object.keys(s.allData).length>0?($("#"+e.pre+"dl_collection_file").hide(),$("#"+e.pre+"dl_collection_structures").show(),$("#"+e.pre+"dl_collection_file_expand").show(),$("#"+e.pre+"dl_collection_file_shrink").hide(),$("#"+e.pre+"dl_collection_structures_expand").hide(),$("#"+e.pre+"dl_collection_structures_shrink").show()):($("#"+e.pre+"dl_collection_file").show(),$("#"+e.pre+"dl_collection_structures").hide(),$("#"+e.pre+"dl_collection_file_expand").hide(),$("#"+e.pre+"dl_collection_file_shrink").hide(),$("#"+e.pre+"dl_collection_structures_expand").show(),$("#"+e.pre+"dl_collection_structures_shrink").hide()),e.htmlCls.dialogCls.openDlg("dl_selectCollections","Select Collections")}else alert("Please select a file before clicking 'Load'")})),e.myEventCls.onIds("#"+e.pre+"collections_clear_commands","click",(function(e){$("#"+t.pre+"collections_menu").val().forEach((function(e){t.allData[e]?t.allData[e].commands=[]:console.warn("No data found for selectedValue:",e)}))})),e.myEventCls.onIds("#"+e.pre+"opendl_export_collections","click",(function(t){e.htmlCls.dialogCls.openDlg("dl_export_collections","Export Collections")})),e.myEventCls.onIds("#"+e.pre+"export_collections","click",(function(t){let s=e.icn3d;const i=document.getElementById(e.pre+"collections_menu"),n=[],l=document.getElementById("dl_collectionExportSelected"),r=document.getElementById("dl_collectionExportAll");l.checked?Array.from(i.options).filter((e=>e.selected)).forEach((e=>{const t=e.value,i=e.textContent.trim(),l=e.getAttribute("data-description");n.push({id:t,title:i,description:l||"",commands:s.allData[t]&&s.allData[t].commands?s.allData[t].commands:[]})})):r.checked&&Array.from(i.options).forEach((e=>{const t=e.value,i=e.textContent.trim(),l=e.getAttribute("data-description");n.push({name:t,title:i,description:l||"",commands:s.allData[t]&&s.allData[t].commands?s.allData[t].commands:[]})}));const o=new Date,a=`${o.getMonth()+1}_${o.getDate()}_${o.getFullYear()}`,d={collectionTitle:document.getElementById("dl_collectionTitle").value,collectionDescription:document.getElementById("dl_collectionDescription").value,structures:n},c=`${d.collectionTitle.replace(/\s+/g,"_")}_${a}.json`,h=JSON.stringify(d,null,2),p=new Blob([h],{type:"application/json"}),m=URL.createObjectURL(p),u=document.createElement("a");u.href=m,u.download=c,document.body.appendChild(u),u.click(),document.body.removeChild(u),URL.revokeObjectURL(m)})),e.myEventCls.onIds("#"+e.pre+"reload_dsn6file2fofc","click",(function(t){let s=e.icn3d;t.preventDefault(),s.dsn6ParserCls.loadDsn6File("2fofc")})),e.myEventCls.onIds("#"+e.pre+"reload_dsn6filefofc","click",(function(t){let s=e.icn3d;t.preventDefault(),s.dsn6ParserCls.loadDsn6File("fofc")})),e.myEventCls.onIds("#"+e.pre+"reload_ccp4file2fofc","click",(function(t){let s=e.icn3d;t.preventDefault(),s.ccp4ParserCls.loadCcp4File("2fofc")})),e.myEventCls.onIds("#"+e.pre+"reload_ccp4filefofc","click",(function(t){let s=e.icn3d;t.preventDefault(),s.ccp4ParserCls.loadCcp4File("fofc")})),e.myEventCls.onIds("#"+e.pre+"reload_mtzfile2fofc","click",(function(t){let s=e.icn3d;t.preventDefault(),s.mtzParserCls.loadMtzFile("2fofc")})),e.myEventCls.onIds("#"+e.pre+"reload_mtzfilefofc","click",(function(t){let s=e.icn3d;t.preventDefault(),s.mtzParserCls.loadMtzFile("fofc")})),e.myEventCls.onIds("#"+e.pre+"reload_rcsbmtzfile2fofc","click",(function(t){let s=e.icn3d;t.preventDefault(),s.mtzParserCls.loadMtzFile("2fofc",!0)})),e.myEventCls.onIds("#"+e.pre+"reload_rcsbmtzfilefofc","click",(function(t){let s=e.icn3d;t.preventDefault(),s.mtzParserCls.loadMtzFile("fofc",!0)})),e.myEventCls.onIds("#"+e.pre+"reload_delphifile","click",(async function(t){let s=e.icn3d;t.preventDefault(),e.cfg.notebook||dialog.dialog("close"),await s.delphiCls.loadDelphiFile("delphi")})),e.myEventCls.onIds("#"+e.pre+"reload_pqrfile","click",(function(t){let s=e.icn3d;t.preventDefault(),e.cfg.notebook||dialog.dialog("close"),s.delphiCls.loadPhiFile("pqr")})),e.myEventCls.onIds("#"+e.pre+"reload_phifile","click",(function(t){let s=e.icn3d;t.preventDefault(),e.cfg.notebook||dialog.dialog("close"),s.delphiCls.loadPhiFile("phi")})),e.myEventCls.onIds("#"+e.pre+"reload_cubefile","click",(function(t){let s=e.icn3d;t.preventDefault(),e.cfg.notebook||dialog.dialog("close"),s.delphiCls.loadPhiFile("cube")})),e.myEventCls.onIds("#"+e.pre+"reload_pqrurlfile","click",(async function(t){let s=e.icn3d;t.preventDefault(),e.cfg.notebook||dialog.dialog("close"),await s.delphiCls.loadPhiFileUrl("pqrurl")})),e.myEventCls.onIds("#"+e.pre+"reload_phiurlfile","click",(async function(t){let s=e.icn3d;t.preventDefault(),e.cfg.notebook||dialog.dialog("close"),await s.delphiCls.loadPhiFileUrl("phiurl")})),e.myEventCls.onIds("#"+e.pre+"reload_cubeurlfile","click",(async function(t){let s=e.icn3d;t.preventDefault(),e.cfg.notebook||dialog.dialog("close"),await s.delphiCls.loadPhiFileUrl("cubeurl")})),e.myEventCls.onIds("#"+e.pre+"reload_delphifile2","click",(async function(t){let s=e.icn3d;t.preventDefault(),e.htmlCls.setHtmlCls.updateSurfPara("delphi"),e.cfg.notebook||dialog.dialog("close"),await s.delphiCls.loadDelphiFile("delphi2")})),e.myEventCls.onIds("#"+e.pre+"reload_pqrfile2","click",(function(t){let s=e.icn3d;t.preventDefault(),e.htmlCls.setHtmlCls.updateSurfPara("phi"),e.cfg.notebook||dialog.dialog("close"),s.delphiCls.loadPhiFile("pqr2")})),e.myEventCls.onIds("#"+e.pre+"reload_phifile2","click",(function(t){let s=e.icn3d;t.preventDefault(),e.htmlCls.setHtmlCls.updateSurfPara("phi"),e.cfg.notebook||dialog.dialog("close"),s.delphiCls.loadPhiFile("phi2")})),e.myEventCls.onIds("#"+e.pre+"reload_cubefile2","click",(function(t){let s=e.icn3d;t.preventDefault(),e.htmlCls.setHtmlCls.updateSurfPara("phi"),e.cfg.notebook||dialog.dialog("close"),s.delphiCls.loadPhiFile("cube2")})),e.myEventCls.onIds("#"+e.pre+"reload_pqrurlfile2","click",(async function(t){let s=e.icn3d;t.preventDefault(),e.htmlCls.setHtmlCls.updateSurfPara("phiurl"),e.cfg.notebook||dialog.dialog("close"),await s.delphiCls.loadPhiFileUrl("pqrurl2")})),e.myEventCls.onIds("#"+e.pre+"reload_phiurlfile2","click",(async function(t){let s=e.icn3d;t.preventDefault(),e.htmlCls.setHtmlCls.updateSurfPara("phiurl"),e.cfg.notebook||dialog.dialog("close"),await s.delphiCls.loadPhiFileUrl("phiurl2")})),e.myEventCls.onIds("#"+e.pre+"reload_cubeurlfile2","click",(async function(t){let s=e.icn3d;t.preventDefault(),e.htmlCls.setHtmlCls.updateSurfPara("phiurl"),e.cfg.notebook||dialog.dialog("close"),await s.delphiCls.loadPhiFileUrl("cubeurl2")})),e.myEventCls.onIds("#"+e.pre+"reload_dsn6fileurl2fofc","click",(function(t){let s=e.icn3d;t.preventDefault(),s.dsn6ParserCls.loadDsn6FileUrl("2fofc")})),e.myEventCls.onIds("#"+e.pre+"reload_dsn6fileurlfofc","click",(function(t){let s=e.icn3d;t.preventDefault(),s.dsn6ParserCls.loadDsn6FileUrl("fofc")})),e.myEventCls.onIds("#"+e.pre+"reload_ccp4fileurl2fofc","click",(function(t){let s=e.icn3d;t.preventDefault(),s.ccp4ParserCls.loadCcp4FileUrl("2fofc")})),e.myEventCls.onIds("#"+e.pre+"reload_ccp4fileurlfofc","click",(function(t){let s=e.icn3d;t.preventDefault(),s.ccp4ParserCls.loadCcp4FileUrl("fofc")})),e.myEventCls.onIds("#"+e.pre+"reload_mtzfileurl2fofc","click",(function(t){let s=e.icn3d;t.preventDefault(),s.mtzParserCls.loadMtzFileUrl("2fofc")})),e.myEventCls.onIds("#"+e.pre+"reload_mtzfileurlfofc","click",(function(t){let s=e.icn3d;t.preventDefault(),s.mtzParserCls.loadMtzFileUrl("fofc")})),e.myEventCls.onIds("#"+e.pre+"reload_rcsbmtzfileurl2fofc","click",(async function(t){let s=e.icn3d;t.preventDefault(),await s.mtzParserCls.loadMtzFileUrl("2fofc",!0)})),e.myEventCls.onIds("#"+e.pre+"reload_rcsbmtzfileurlfofc","click",(async function(t){let s=e.icn3d;t.preventDefault(),await s.mtzParserCls.loadMtzFileUrl("fofc",!0)})),e.myEventCls.onIds("#"+e.pre+"reload_pdbfile","click",(async function(t){e.icn3d,t.preventDefault();await s.loadPdbFile(!1,"pdbfile")})),e.myEventCls.onIds("#"+e.pre+"reload_pdbfile_app","click",(async function(t){let i=e.icn3d;t.preventDefault(),i.bAppend=!0,await s.loadPdbFile(i.bAppend,"pdbfile_app")})),e.myEventCls.onIds("#"+e.pre+"reload_mol2file","click",(function(t){let i=e.icn3d;t.preventDefault(),i.bInitial=!0,e.cfg.notebook||dialog.dialog("close"),e.cfg.notebook?i.resizeCanvasCls.closeDialogs():$(".ui-dialog-content").dialog("close");let n=$("#"+e.pre+"mol2file")[0].files[0];if(n){e.htmlCls.setHtmlCls.fileSupport();let t=new FileReader;t.onload=async function(t){let n=t.target.result;s.setLogCmd("load mol2 file "+$("#"+e.pre+"mol2file").val(),!1),i.molTitle="",i.inputid=void 0,i.init(),i.bInputfile=!0,i.InputfileData=i.InputfileData?i.InputfileData+"\nENDMDL\n"+n:n,i.InputfileType="mol2",await i.mol2ParserCls.loadMol2Data(n)},t.readAsText(n)}else alert("Please select a file before clicking 'Load'")})),e.myEventCls.onIds("#"+e.pre+"reload_sdffile","click",(function(t){let i=e.icn3d;t.preventDefault(),i.bInitial=!0,e.cfg.notebook||dialog.dialog("close"),e.cfg.notebook?i.resizeCanvasCls.closeDialogs():$(".ui-dialog-content").dialog("close");let n=$("#"+e.pre+"sdffile")[0].files[0];if(n){e.htmlCls.setHtmlCls.fileSupport();let t=new FileReader;t.onload=async function(t){let n=t.target.result;s.setLogCmd("load sdf file "+$("#"+e.pre+"sdffile").val(),!1),i.molTitle="",i.inputid=void 0,i.init(),i.bInputfile=!0,i.InputfileData=i.InputfileData?i.InputfileData+"\nENDMDL\n"+n:n,i.InputfileType="sdf",await i.sdfParserCls.loadSdfData(n)},t.readAsText(n)}else alert("Please select a file before clicking 'Load'")})),e.myEventCls.onIds("#"+e.pre+"reload_xyzfile","click",(function(t){let i=e.icn3d;t.preventDefault(),i.bInitial=!0,e.cfg.notebook||dialog.dialog("close"),e.cfg.notebook?i.resizeCanvasCls.closeDialogs():$(".ui-dialog-content").dialog("close");let n=$("#"+e.pre+"xyzfile")[0].files[0];if(n){e.htmlCls.setHtmlCls.fileSupport();let t=new FileReader;t.onload=async function(t){let n=t.target.result;s.setLogCmd("load xyz file "+$("#"+e.pre+"xyzfile").val(),!1),i.molTitle="",i.inputid=void 0,i.init(),i.bInputfile=!0,i.InputfileData=i.InputfileData?i.InputfileData+"\nENDMDL\n"+n:n,i.InputfileType="xyz",await i.xyzParserCls.loadXyzData(n)},t.readAsText(n)}else alert("Please select a file before clicking 'Load'")})),e.myEventCls.onIds("#"+e.pre+"reload_afmapfile","click",(function(t){let i=e.icn3d;t.preventDefault(),i.bInitial=!0,e.cfg.notebook||dialog.dialog("close"),e.cfg.notebook?i.resizeCanvasCls.closeDialogs():$(".ui-dialog-content").dialog("close");let n=$("#"+e.pre+"afmapfile")[0].files[0];if(n){e.htmlCls.setHtmlCls.fileSupport();let t=new FileReader;t.onload=function(t){let n=t.target.result;s.setLogCmd("load AlphaFold PAE file "+$("#"+e.pre+"afmapfile").val(),!1),e.htmlCls.dialogCls.openDlg("dl_alignerrormap","Show Predicted Aligned Error (PAE) map"),i.contactMapCls.processAfErrorMap(JSON.parse(n))},t.readAsText(n)}else alert("Please select a file before clicking 'Load'")})),e.myEventCls.onIds("#"+e.pre+"reload_afmapfilefull","click",(function(t){let i=e.icn3d;t.preventDefault(),i.bInitial=!0,e.cfg.notebook||dialog.dialog("close"),e.cfg.notebook?i.resizeCanvasCls.closeDialogs():$(".ui-dialog-content").dialog("close");let n=$("#"+e.pre+"afmapfile")[0].files[0];if(n){e.htmlCls.setHtmlCls.fileSupport();let t=new FileReader;t.onload=function(t){let n=t.target.result;s.setLogCmd("load AlphaFold PAE file "+$("#"+e.pre+"afmapfile").val(),!1),e.htmlCls.dialogCls.openDlg("dl_alignerrormap","Show Predicted Aligned Error (PAE) map"),i.contactMapCls.processAfErrorMap(JSON.parse(n),!0)},t.readAsText(n)}else alert("Please select a file before clicking 'Load'")})),e.myEventCls.onIds("#"+e.pre+"reload_urlfile","click",(async function(t){let s=e.icn3d;t.preventDefault(),s.bInitial=!0,e.cfg.notebook||dialog.dialog("close"),e.cfg.notebook?s.resizeCanvasCls.closeDialogs():$(".ui-dialog-content").dialog("close");let i=$("#"+e.pre+"filetype").val(),n=$("#"+e.pre+"urlfile").val();s.inputurl="type="+i+"&url="+encodeURIComponent(n),s.init(),s.bInputfile=!0,s.bInputUrlfile=!0,await s.pdbParserCls.downloadUrl(n,i)})),e.myEventCls.onIds("#"+e.pre+"reload_mmciffile","click",(async function(t){let i=e.icn3d;t.preventDefault(),i.bAppend=!0;await s.loadPdbFile(i.bAppend,"mmciffile",!0)})),e.myEventCls.onIds("#"+e.pre+"applycustomcolor","click",(function(t){let i=e.icn3d;t.preventDefault(),e.cfg.notebook||dialog.dialog("close"),i.setOptionCls.setOption("color",$("#"+e.pre+"colorcustom").val()),s.setLogCmd("color "+$("#"+e.pre+"colorcustom").val(),!0)})),e.myEventCls.onIds(["#"+e.pre+"atomsCustomSphere2","#"+e.pre+"atomsCustomSphere","#"+e.pre+"radius_aroundsphere"],"change",(function(t){e.icn3d.bSphereCalc=!1})),e.myEventCls.onIds("#"+e.pre+"applypick_aroundsphere","click",(function(t){let i=e.icn3d,n=parseFloat($("#"+e.pre+"radius_aroundsphere").val()),l=$("#"+e.pre+"atomsCustomSphere").val(),r=$("#"+e.pre+"atomsCustomSphere2").val();if(0==r.length)alert("Please select the first set at step #1");else{let e="select zone cutoff "+n+" | sets "+r+" "+l+" | "+i.bSphereCalc;i.bSphereCalc||i.showInterCls.pickCustomSphere(n,r,l,i.bSphereCalc),i.bSphereCalc=!0,i.hlUpdateCls.updateHlAll(),s.setLogCmd(e,!0)}})),e.myEventCls.onIds("#"+e.pre+"sphereExport","click",(function(t){let i=e.icn3d;t.preventDefault();let n=parseFloat($("#"+e.pre+"radius_aroundsphere").val()),l=$("#"+e.pre+"atomsCustomSphere").val(),r=$("#"+e.pre+"atomsCustomSphere2").val();if(0==r.length)alert("Please select the first set at step #1");else{i.showInterCls.pickCustomSphere(n,r,l,i.bSphereCalc),i.bSphereCalc=!0;let t=i.viewInterPairsCls.exportSpherePairs(),o=Object.keys(e.utilsCls.getHlStructures()).join(",");i.saveFileCls.saveFile(o+"_sphere_pairs.html","html",t),s.setLogCmd("export pairs | "+r+" "+l+" | dist "+n,!0)}})),e.myEventCls.onIds("#"+e.pre+"apply_adjustmem","click",(function(t){let i=e.icn3d;e.cfg.notebook||dialog.dialog("close");let n=parseFloat($("#"+e.pre+"extra_mem_z").val()),l=parseFloat($("#"+e.pre+"intra_mem_z").val());i.selectionCls.adjustMembrane(n,l);let r="adjust membrane z-axis "+n+" "+l;s.setLogCmd(r,!0)})),e.myEventCls.onIds("#"+e.pre+"apply_selectplane","click",(function(t){let i=e.icn3d;e.cfg.notebook||dialog.dialog("close");let n=parseFloat($("#"+e.pre+"selectplane_z1").val()),l=parseFloat($("#"+e.pre+"selectplane_z2").val());i.selectionCls.selectBtwPlanes(n,l);let r="select planes z-axis "+n+" "+l;s.setLogCmd(r,!0)})),e.myEventCls.onIds(["#"+e.pre+"atomsCustomHbond2","#"+e.pre+"atomsCustomHbond","#"+e.pre+"analysis_hbond","#"+e.pre+"analysis_saltbridge","#"+e.pre+"analysis_contact","#"+e.pre+"hbondthreshold","#"+e.pre+"saltbridgethreshold","#"+e.pre+"contactthreshold"],"change",(function(t){e.icn3d.bHbondCalc=!1})),e.myEventCls.onIds("#"+e.pre+"crossstrucinter","change",(function(t){let i=e.icn3d;t.preventDefault(),i.crossstrucinter=parseInt($("#"+e.pre+"crossstrucinter").val()),s.setLogCmd("cross structure interaction "+i.crossstrucinter,!0)})),e.myEventCls.onIds("#"+e.pre+"applyhbonds","click",(async function(t){let s=e.icn3d;t.preventDefault(),await s.showInterCls.showInteractions("3d")})),e.myEventCls.onIds("#"+e.pre+"applycontactmap","click",(async function(t){let i=e.icn3d;t.preventDefault(),e.cfg.notebook||dialog.dialog("close");let n=parseFloat($("#"+i.pre+"contactdist").val()),l=$("#"+i.pre+"contacttype").val();await i.contactMapCls.contactMap(n,l),s.setLogCmd("contact map | dist "+n+" | type "+l,!0)})),e.myEventCls.onIds("#"+e.pre+"hbondWindow","click",(async function(t){let s=e.icn3d;t.preventDefault(),await s.showInterCls.showInteractions("view")})),e.myEventCls.onIds("#"+e.pre+"areaWindow","click",(function(t){let i=e.icn3d;t.preventDefault();let n=$("#"+e.pre+"atomsCustomHbond").val(),l=$("#"+e.pre+"atomsCustomHbond2").val();i.analysisCls.calcBuriedSurface(l,n),s.setLogCmd("calc buried surface | "+l+" "+n,!0)})),e.myEventCls.onIds("#"+e.pre+"sortSet1","click",(async function(t){let s=e.icn3d;t.preventDefault(),await s.showInterCls.showInteractions("save1")})),$(document).on("click","."+e.pre+"showintercntonly",(function(t){e.icn3d,t.stopImmediatePropagation(),$(".icn3d-border").hide(),s.setLogCmd("table inter count only",!0)})),$(document).on("click","."+e.pre+"showinterdetails",(function(t){e.icn3d,t.stopImmediatePropagation(),$(".icn3d-border").show(),s.setLogCmd("table inter details",!0)})),e.myEventCls.onIds("#"+e.pre+"sortSet2","click",(async function(t){let s=e.icn3d;t.preventDefault(),await s.showInterCls.showInteractions("save2")})),e.myEventCls.onIds("#"+e.pre+"hbondGraph","click",(async function(t){let s=e.icn3d;t.preventDefault(),await s.showInterCls.showInteractions("graph")})),e.myEventCls.onIds("#"+e.pre+"hbondLineGraph","click",(async function(t){let i=e.icn3d;t.preventDefault(),i.bShownRefnum=!1,s.setLogCmd("hide ref number",!0),await i.showInterCls.showInteractions("linegraph")})),e.myEventCls.onIds("#"+e.pre+"hbondLineGraph2","click",(async function(t){let i=e.icn3d;t.preventDefault(),i.bShownRefnum=!0,s.setLogCmd("show ref number",!0),await i.showInterCls.showInteractions("linegraph")})),e.myEventCls.onIds("#"+e.pre+"hbondScatterplot","click",(async function(t){let i=e.icn3d;t.preventDefault(),i.bShownRefnum=!1,s.setLogCmd("hide ref number",!0),await i.showInterCls.showInteractions("scatterplot")})),e.myEventCls.onIds("#"+e.pre+"hbondScatterplot2","click",(async function(t){let i=e.icn3d;t.preventDefault(),i.bShownRefnum=!0,s.setLogCmd("show ref number",!0),await i.showInterCls.showInteractions("scatterplot")})),e.myEventCls.onIds("#"+e.pre+"hbondLigplot","click",(async function(t){let i=e.icn3d;t.preventDefault(),i.bShownRefnum=!1,s.setLogCmd("hide ref number",!0),await i.showInterCls.showInteractions("ligplot")})),$(document).on("click","#"+e.svgid+" circle.selected",(function(t){let s=e.icn3d;t.stopImmediatePropagation();let i=$(this).attr("res");!1!==s.bSelectResidue||s.bShift||s.bCtrl||s.selectionCls.removeSelection(),void 0!==i&&(s.hlSeqCls.selectResidues(i,this),s.hlObjectsCls.addHlObjects())})),e.myEventCls.onIds("#"+e.svgid+"_svg","click",(function(t){let s=e.icn3d;t.preventDefault(),s.saveFileCls.saveSvg(e.svgid,s.inputid+"_force_directed_graph.svg")})),e.myEventCls.onIds("#"+e.svgid+"_png","click",(function(t){let s=e.icn3d;t.preventDefault(),s.saveFileCls.savePng(e.svgid,s.inputid+"_force_directed_graph.png")})),e.myEventCls.onIds("#"+e.svgid+"_json","click",(function(t){let s=e.icn3d;t.preventDefault();let i=s.graphStr.substr(0,s.graphStr.lastIndexOf("}"));i+=e.htmlCls.setHtmlCls.getLinkColor(),s.saveFileCls.saveFile(s.inputid+"_force_directed_graph.json","text",[i])})),$(document).on("click","#"+e.svgid_ct+"_svg",(function(t){let s=e.icn3d;t.preventDefault(),s.saveFileCls.saveSvg(e.svgid_ct,s.inputid+"_cartoon.svg")})),$(document).on("click","#"+e.svgid_ct+"_png",(function(t){let s=e.icn3d;t.preventDefault(),s.saveFileCls.savePng(e.svgid_ct,s.inputid+"_cartoon.png")})),$(document).on("click","#"+e.svgid_ct+"_json",(function(t){let s=e.icn3d;t.preventDefault(),s.saveFileCls.saveFile(s.inputid+"_cartoon.json","text",[s.graphStr])})),$(document).on("change","#"+e.svgid_ct+"_label",(function(t){e.icn3d,t.preventDefault();let i=$("#"+e.svgid_ct+"_label").val();$("#"+e.svgid_ct+" text").removeClass(),$("#"+e.svgid_ct+" text").addClass(i),s.setLogCmd("cartoon label "+i,!0)})),e.myEventCls.onIds("#"+e.linegraphid+"_svg","click",(function(t){let s=e.icn3d;t.preventDefault(),s.saveFileCls.saveSvg(e.linegraphid,s.inputid+"_line_graph.svg")})),e.myEventCls.onIds("#"+e.linegraphid+"_png","click",(function(t){let s=e.icn3d;t.preventDefault(),s.saveFileCls.savePng(e.linegraphid,s.inputid+"_line_graph.png")})),e.myEventCls.onIds("#"+e.linegraphid+"_json","click",(function(t){let s=e.icn3d;t.preventDefault();let i=s.lineGraphStr.substr(0,s.lineGraphStr.lastIndexOf("}"));i+=e.htmlCls.setHtmlCls.getLinkColor(),s.saveFileCls.saveFile(s.inputid+"_line_graph.json","text",[i])})),e.myEventCls.onIds("#"+e.linegraphid+"_scale","change",(function(t){let i=e.icn3d;t.preventDefault();let n=$("#"+e.linegraphid+"_scale").val();$("#"+e.linegraphid).attr("width",(i.linegraphWidth*parseFloat(n)).toString()+"px"),s.setLogCmd("line graph scale "+n,!0)})),e.myEventCls.onIds("#"+e.scatterplotid+"_svg","click",(function(t){let s=e.icn3d;t.preventDefault(),s.saveFileCls.saveSvg(e.scatterplotid,s.inputid+"_scatterplot.svg")})),e.myEventCls.onIds("#"+e.scatterplotid+"_png","click",(function(t){let s=e.icn3d;t.preventDefault(),s.saveFileCls.savePng(e.scatterplotid,s.inputid+"_scatterplot.png")})),e.myEventCls.onIds("#"+e.scatterplotid+"_json","click",(function(t){let s=e.icn3d;t.preventDefault();let i=s.scatterplotStr.substr(0,s.scatterplotStr.lastIndexOf("}"));i+=e.htmlCls.setHtmlCls.getLinkColor(),s.saveFileCls.saveFile(s.inputid+"_scatterplot.json","text",[i])})),e.myEventCls.onIds("#"+e.scatterplotid+"_scale","change",(function(t){let i=e.icn3d;t.preventDefault();let n=$("#"+e.scatterplotid+"_scale").val();$("#"+e.scatterplotid).attr("width",(i.scatterplotWidth*parseFloat(n)).toString()+"px"),s.setLogCmd("scatterplot scale "+n,!0)})),e.myEventCls.onIds("#"+e.ligplotid+"_svg","click",(function(t){let s=e.icn3d;t.preventDefault(),s.saveFileCls.saveSvg(e.ligplotid,s.inputid+"_ligplot.svg",void 0,!0)})),e.myEventCls.onIds("#"+e.ligplotid+"_png","click",(function(t){let s=e.icn3d;t.preventDefault(),s.saveFileCls.savePng(e.ligplotid,s.inputid+"_ligplot.png",void 0,!0)})),e.myEventCls.onIds("#"+e.ligplotid+"_scale","change",(function(t){let i=e.icn3d;t.preventDefault();let n=$("#"+e.ligplotid+"_scale").val();$("#"+e.ligplotid).attr("width",(i.ligplotWidth*parseFloat(n)).toString()+"px"),i.ligplotScale=parseFloat(n),s.setLogCmd("ligplot scale "+n,!0)})),e.myEventCls.onIds("#"+e.contactmapid+"_svg","click",(function(t){let s=e.icn3d;t.preventDefault(),s.saveFileCls.saveSvg(e.contactmapid,s.inputid+"_contactmap.svg",!0)})),e.myEventCls.onIds("#"+e.contactmapid+"_png","click",(function(t){let s=e.icn3d;t.preventDefault(),s.saveFileCls.savePng(e.contactmapid,s.inputid+"_contactmap.png",!0)})),e.myEventCls.onIds("#"+e.contactmapid+"_json","click",(function(t){let s=e.icn3d;t.preventDefault();let i=s.contactmapStr.substr(0,s.contactmapStr.lastIndexOf("}"));i+=e.htmlCls.setHtmlCls.getLinkColor(),s.saveFileCls.saveFile(s.inputid+"_contactmap.json","text",[i])})),e.myEventCls.onIds("#"+e.contactmapid+"_scale","change",(function(t){let i=e.icn3d;t.preventDefault();let n=$("#"+e.contactmapid+"_scale").val();$("#"+e.contactmapid).attr("width",(i.contactmapWidth*parseFloat(n)).toString()+"px"),s.setLogCmd("contactmap scale "+n,!0)})),e.myEventCls.onIds("#"+e.alignerrormapid+"_svg","click",(function(t){let s=e.icn3d;t.preventDefault();$("#"+e.alignerrormapid+"_scale").val(1),$("#"+e.alignerrormapid).attr("width",(s.alignerrormapWidth*parseFloat(1)).toString()+"px"),s.saveFileCls.saveSvg(e.alignerrormapid,s.inputid+"_alignerrormap.svg",!0)})),e.myEventCls.onIds("#"+e.alignerrormapid+"_png","click",(function(t){let s=e.icn3d;t.preventDefault();$("#"+e.alignerrormapid+"_scale").val(1),$("#"+e.alignerrormapid).attr("width",(s.alignerrormapWidth*parseFloat(1)).toString()+"px"),s.saveFileCls.savePng(e.alignerrormapid,s.inputid+"_alignerrormap.png",!0)})),e.myEventCls.onIds("#"+e.alignerrormapid+"_full","click",(async function(t){let s=e.icn3d;t.preventDefault(),await s.contactMapCls.afErrorMap(afid,!0)})),e.myEventCls.onIds("#"+e.alignerrormapid+"_json","click",(function(t){let s=e.icn3d;t.preventDefault();let i=s.alignerrormapStr.substr(0,s.alignerrormapStr.lastIndexOf("}"));i+=e.htmlCls.setHtmlCls.getLinkColor(),s.saveFileCls.saveFile(s.inputid+"_alignerrormap.json","text",[i])})),e.myEventCls.onIds("#"+e.alignerrormapid+"_scale","change",(function(t){let i=e.icn3d;t.preventDefault();let n=$("#"+e.alignerrormapid+"_scale").val();$("#"+e.alignerrormapid).attr("width",(i.alignerrormapWidth*parseFloat(n)).toString()+"px"),s.setLogCmd("alignerrormap scale "+n,!0)})),e.myEventCls.onIds("#"+e.svgid+"_label","change",(function(t){e.icn3d,t.preventDefault();let i=$("#"+e.svgid+"_label").val();$("#"+e.svgid+" text").removeClass(),$("#"+e.svgid+" text").addClass(i),s.setLogCmd("graph label "+i,!0)})),e.myEventCls.onIds("#"+e.svgid+"_hideedges","change",(function(t){let i=e.icn3d;t.preventDefault(),e.htmlCls.hideedges=parseInt($("#"+e.svgid+"_hideedges").val()),e.htmlCls.hideedges?(e.htmlCls.contactInsideColor="FFF",e.htmlCls.hbondInsideColor="FFF",e.htmlCls.ionicInsideColor="FFF"):(e.htmlCls.contactInsideColor="DDD",e.htmlCls.hbondInsideColor="AFA",e.htmlCls.ionicInsideColor="8FF"),void 0!==i.graphStr&&(i.bRender&&e.htmlCls.force&&e.drawGraph(i.graphStr,e.pre+"dl_graph"),s.setLogCmd("hide edges "+e.htmlCls.hideedges,!0))})),e.myEventCls.onIds("#"+e.svgid+"_force","change",(function(t){let i=e.icn3d;t.preventDefault(),e.htmlCls.force=parseInt($("#"+e.svgid+"_force").val()),void 0!==i.graphStr&&(s.setLogCmd("graph force "+e.htmlCls.force,!0),i.getGraphCls.handleForce())})),e.myEventCls.onIds("#"+e.pre+"hbondReset","click",(function(t){let i=e.icn3d;t.preventDefault(),i.viewInterPairsCls.resetInteractionPairs(),s.setLogCmd("reset interaction pairs",!0)})),e.myEventCls.onIds("#"+e.pre+"applypick_labels","click",(function(t){let i=e.icn3d;t.preventDefault(),e.cfg.notebook||dialog.dialog("close");let n=$("#"+e.pre+"labeltext").val(),l=$("#"+e.pre+"labelsize").val(),r=$("#"+e.pre+"labelcolor").val(),o=$("#"+e.pre+"labelbkgd").val();if("0"!==l&&""!==l&&"undefined"!==l||(l=0),"0"!==r&&""!==r&&"undefined"!==r||(r=0),"0"!==o&&""!==o&&"undefined"!==o||(o=0),void 0===i.pAtom||void 0===i.pAtom2)alert("Please pick another atom");else{let e=(i.pAtom.coord.x+i.pAtom2.coord.x)/2,t=(i.pAtom.coord.y+i.pAtom2.coord.y)/2,a=(i.pAtom.coord.z+i.pAtom2.coord.z)/2;i.analysisCls.addLabel(n,e,t,a,l,r,o,"custom"),i.pickpair=!1;let d="",c="",h="";0!=l&&(d=" | size "+l),0!=r&&(c=" | color "+r),0!=o&&(h=" | background "+o),s.setLogCmd("add label "+n+" | x "+e.toPrecision(4)+" y "+t.toPrecision(4)+" z "+a.toPrecision(4)+d+c+h+" | type custom",!0),i.drawCls.draw()}})),e.myEventCls.onIds("#"+e.pre+"applyselection_labels","click",(function(t){let i=e.icn3d;t.preventDefault(),e.cfg.notebook||dialog.dialog("close");let n=$("#"+e.pre+"labeltext2").val(),l=$("#"+e.pre+"labelsize2").val(),r=$("#"+e.pre+"labelcolor2").val(),o=$("#"+e.pre+"labelbkgd2").val();"0"!==l&&""!==l&&"undefined"!==l||(l=0),"0"!==r&&""!==r&&"undefined"!==r||(r=0),"0"!==o&&""!==o&&"undefined"!==o||(o=0);let a=i.applyCenterCls.centerAtoms(e.hashUtilsCls.hash2Atoms(i.hAtoms,i.atoms)),d=a.center.x,c=a.center.y,h=a.center.z;i.analysisCls.addLabel(n,d,c,h,l,r,o,"custom");let p="",m="",u="";0!=l&&(p=" | size "+l),0!=r&&(m=" | color "+r),0!=o&&(u=" | background "+o),s.setLogCmd("add label "+n+" | x "+d.toPrecision(4)+" y "+c.toPrecision(4)+" z "+h.toPrecision(4)+p+m+u+" | type custom",!0),i.drawCls.draw()})),e.myEventCls.onIds("#"+e.pre+"applylabelcolor","click",(function(t){let i=e.icn3d;t.preventDefault(),e.cfg.notebook||dialog.dialog("close"),i.labelcolor=$("#"+e.pre+"labelcolorall").val(),s.setLogCmd("set label color "+i.labelcolor,!0),i.drawCls.draw()})),e.myEventCls.onIds("#"+e.pre+"applypick_stabilizer","click",(function(t){let i=e.icn3d;t.preventDefault(),e.cfg.notebook||dialog.dialog("close"),void 0===i.pAtom||void 0===i.pAtom2?alert("Please pick another atom"):(i.pickpair=!1,s.setLogCmd("add one stabilizer | "+i.pAtom.serial+" "+i.pAtom2.serial,!0),void 0===i.pairArray&&(i.pairArray=[]),i.pairArray.push(i.pAtom.serial),i.pairArray.push(i.pAtom2.serial),i.threeDPrintCls.setThichknessFor3Dprint(),i.drawCls.draw())}));let l=new CP(document.querySelector("#"+e.pre+"colorcustom"));l.on("change",(function(e){this.target.value=e})),e.myEventCls.onIds("#"+e.pre+"colorcustom","input",(function(){let t=$("#"+e.pre+"colorcustom").val();l.set("#"+t).enter()})),e.myEventCls.onIds("#"+e.pre+"colorcustom","keyup",(function(){let t=$("#"+e.pre+"colorcustom").val();l.set("#"+t).enter()})),e.myEventCls.onIds("#"+e.pre+"colorcustom","paste",(function(){let t=$("#"+e.pre+"colorcustom").val();l.set("#"+t).enter()})),e.myEventCls.onIds("#"+e.pre+"colorcustom","cut",(function(){let t=$("#"+e.pre+"colorcustom").val();l.set("#"+t).enter()}));let r=new CP(document.querySelector("#"+e.pre+"labelcolorall"));r.on("change",(function(e){this.target.value=e})),e.myEventCls.onIds("#"+e.pre+"labelcolorall","input",(function(){let t=$("#"+e.pre+"labelcolorall").val();r.set("#"+t).enter()})),e.myEventCls.onIds("#"+e.pre+"labelcolorall","keyup",(function(){let t=$("#"+e.pre+"labelcolorall").val();r.set("#"+t).enter()})),e.myEventCls.onIds("#"+e.pre+"labelcolorall","paste",(function(){let t=$("#"+e.pre+"labelcolorall").val();r.set("#"+t).enter()})),e.myEventCls.onIds("#"+e.pre+"labelcolorall","cut",(function(){let t=$("#"+e.pre+"labelcolorall").val();r.set("#"+t).enter()})),e.myEventCls.onIds("#"+e.pre+"applypick_stabilizer_rm","click",(function(t){let i=e.icn3d;if(t.preventDefault(),e.cfg.notebook||dialog.dialog("close"),void 0===i.pAtom||void 0===i.pAtom2)alert("Please pick another atom");else{i.pickpair=!1,s.setLogCmd("remove one stabilizer | "+i.pAtom.serial+" "+i.pAtom2.serial,!0);let e=[];e.push(i.pAtom.serial),e.push(i.pAtom2.serial),i.threeDPrintCls.removeOneStabilizer(e),i.drawCls.draw()}})),e.myEventCls.onIds("#"+e.pre+"applypick_measuredistance","click",(function(t){let i=e.icn3d;if(t.preventDefault(),e.cfg.notebook||dialog.dialog("close"),i.bMeasureDistance=!1,void 0===i.pAtom||void 0===i.pAtom2)alert("Please pick another atom");else{let t=0,n=0,l=$("#"+e.pre+"linecolor").val(),r=(i.pAtom.coord.x+i.pAtom2.coord.x)/2,o=(i.pAtom.coord.y+i.pAtom2.coord.y)/2,a=(i.pAtom.coord.z+i.pAtom2.coord.z)/2;i.analysisCls.addLineFromPicking("distance");let d=(parseInt(10*i.pAtom.coord.distanceTo(i.pAtom2.coord))/10).toString()+" A";i.analysisCls.addLabel(d,r,o,a,t,l,n,"distance");let c="",h="",p="";0!=l&&(h=" | color "+l),s.setLogCmd("add label "+d+" | x "+r.toPrecision(4)+" y "+o.toPrecision(4)+" z "+a.toPrecision(4)+c+h+p+" | type distance",!0),i.drawCls.draw(),i.pk=2}})),e.myEventCls.onIds("#"+e.pre+"applydist2","click",(function(t){let i=e.icn3d;t.preventDefault(),e.cfg.notebook||dialog.dialog("close"),i.bMeasureDistance=!1;let n=$("#"+e.pre+"atomsCustomDist").val(),l=$("#"+e.pre+"atomsCustomDist2").val();i.analysisCls.measureDistTwoSets(n,l),s.setLogCmd("dist | "+l+" "+n,!0)})),$(document).on("click",".icn3d-distance",(function(t){let i=e.icn3d;t.preventDefault(),i.bMeasureDistance=!1,i.distPnts=[],i.labels.distance=[],i.lines.distance=[];let n=$(this).attr("sets").split("|"),l=[n[0]],r=[n[1]];i.analysisCls.measureDistTwoSets(l,r),s.setLogCmd("dist | "+r+" "+l,!0)})),e.myEventCls.onIds("#"+e.pre+"applydisttable","click",(function(t){let i=e.icn3d;t.preventDefault(),e.cfg.notebook||dialog.dialog("close"),i.bMeasureDistance=!1;let n=$("#"+e.pre+"atomsCustomDistTable").val(),l=$("#"+e.pre+"atomsCustomDistTable2").val();i.analysisCls.measureDistManySets(n,l),e.htmlCls.dialogCls.openDlg("dl_disttable","Distance among the sets"),s.setLogCmd("disttable | "+l+" "+n,!0)})),e.myEventCls.onIds("#"+e.pre+"applyangletable","click",(function(t){let i=e.icn3d;t.preventDefault(),e.cfg.notebook||dialog.dialog("close"),i.bMeasureAngle=!1;let n=$("#"+e.pre+"atomsCustomAngleTable").val(),l=$("#"+e.pre+"atomsCustomAngleTable2").val();i.analysisCls.measureAngleManySets(n,l),e.htmlCls.dialogCls.openDlg("dl_angletable","Angles among the sets"),s.setLogCmd("angletable | "+l+" "+n,!0)})),e.myEventCls.onIds("#"+e.pre+"applylinebtwsets","click",(function(t){let i=e.icn3d;t.preventDefault(),i.bLinebtwsets=!1;let n=$("#"+e.pre+"linebtwsets").val(),l=$("#"+e.pre+"linebtwsets2").val(),r=i.definedSetsCls.getAtomsFromNameArray(n),o=i.definedSetsCls.getAtomsFromNameArray(l),a=i.contactCls.getExtent(r),d=i.contactCls.getExtent(o),c=new THREE.Vector3(a[2][0],a[2][1],a[2][2]),h=new THREE.Vector3(d[2][0],d[2][1],d[2][2]),p=$("#"+e.pre+"linebtwsets_radius").val(),m=$("#"+e.pre+"linebtwsets_customcolor").val(),u=$("#"+e.pre+"linebtwsets_opacity").val(),g="Solid"!=$("#"+e.pre+"linebtwsets_style").val(),f="cylinder",C="add line | x1 "+c.x.toPrecision(4)+" y1 "+c.y.toPrecision(4)+" z1 "+c.z.toPrecision(4)+" | x2 "+h.x.toPrecision(4)+" y2 "+h.y.toPrecision(4)+" z2 "+h.z.toPrecision(4)+" | color "+m+" | dashed "+g+" | type "+f+" | radius "+p+" | opacity "+u;s.setLogCmd(C,!0),i.analysisCls.addLine(c.x,c.y,c.z,h.x,h.y,h.z,m,g,f,p,u),i.drawCls.draw()})),e.myEventCls.onIds("#"+e.pre+"applycartoonshape","click",(function(t){let i=e.icn3d;t.preventDefault(),i.bCartoonshape=!1;let n=$("#"+e.pre+"cartoonshape").val(),l=i.definedSetsCls.getAtomsFromNameArray(n),r=i.contactCls.getExtent(l),o=new THREE.Vector3(r[2][0],r[2][1],r[2][2]),a=$("#"+e.pre+"cartoonshape_shape").val(),d=$("#"+e.pre+"cartoonshape_radius").val(),c=$("#"+e.pre+"cartoonshape_customcolor").val(),h=$("#"+e.pre+"cartoonshape_opacity").val();c="#"+c.replace(/\#/g,"");let p,m=e.parasCls.thr(c);"Sphere"==a?(i.sphereCls.createSphereBase(o,m,d,void 0,void 0,void 0,h),p="add sphere | "+n+" | color "+c+" | opacity "+h+" | radius "+d):(i.boxCls.createBox_base(o,d,m,void 0,void 0,void 0,h),p="add cube | "+n+" | color "+c+" | opacity "+h+" | radius "+d),s.setLogCmd(p,!0),i.shapeCmdHash[p]=1,i.drawCls.draw()})),e.myEventCls.onIds("#"+e.pre+"clearlinebtwsets","click",(function(t){let i=e.icn3d;t.preventDefault(),i.lines.cylinder=[],s.setLogCmd("clear line between sets",!0),i.drawCls.draw()})),e.myEventCls.onIds("#"+e.pre+"clearcartoonshape","click",(function(t){let i=e.icn3d;t.preventDefault(),i.shapeCmdHash={},s.setLogCmd("clear shape",!0),i.drawCls.draw()})),e.myEventCls.onIds("#"+e.pre+"apply_thickness_3dprint","click",(function(t){e.icn3d,t.preventDefault(),e.htmlCls.setHtmlCls.setLineThickness("3dprint")})),e.myEventCls.onIds("#"+e.pre+"apply_thickness_style","click",(function(t){e.icn3d,t.preventDefault(),e.htmlCls.setHtmlCls.setLineThickness("style"),e.htmlCls.setMenuCls.setLogWindow(!0)})),e.myEventCls.onIds("#"+e.pre+"reset_thickness_3dprint","click",(function(t){e.icn3d,t.preventDefault(),e.htmlCls.setHtmlCls.setLineThickness("3dprint",!0)})),e.myEventCls.onIds("#"+e.pre+"reset_thickness_style","click",(function(t){e.icn3d,t.preventDefault(),e.htmlCls.setHtmlCls.setLineThickness("style",!0),e.htmlCls.setMenuCls.setLogWindow(!0)})),e.myEventCls.onIds("#"+e.pre+"reset","click",(function(t){let s=e.icn3d;s.selectionCls.resetAll(),s.bRender&&s.drawCls.draw()})),e.myEventCls.onIds(["#"+e.pre+"toggleHighlight","#"+e.pre+"toggleHighlight2"],"click",(function(t){let i=e.icn3d;t.stopImmediatePropagation(),i.hlUpdateCls.toggleHighlight(),s.setLogCmd("toggle highlight",!0)})),e.myEventCls.onIds("#"+e.pre+"seq_clearselection","click",(function(t){let i=e.icn3d;t.stopImmediatePropagation(),e.cfg.notebook||dialog.dialog("close"),i.hlUpdateCls.clearHighlight(),s.setLogCmd("clear selection",!0)})),e.myEventCls.onIds("#"+e.pre+"seq_clearselection2","click",(function(t){let i=e.icn3d;t.stopImmediatePropagation(),t.preventDefault(),i.hlUpdateCls.clearHighlight(),s.setLogCmd("clear selection",!0)})),e.myEventCls.onIds("#"+e.pre+"alignseq_clearselection","click",(function(t){let i=e.icn3d;t.stopImmediatePropagation(),i.hlUpdateCls.clearHighlight(),s.setLogCmd("clear selection",!0)})),e.myEventCls.onIds("#"+e.pre+"replay","click",(async function(t){let i=e.icn3d;t.stopImmediatePropagation(),i.CURRENTNUMBER++;let n=e.cfg.replay?i.STATENUMBER:i.STATENUMBER-1;if(i.CURRENTNUMBER==n)i.bReplay=0,$("#"+e.pre+"replay").hide();else if(i.commands.length>0&&i.commands[i.CURRENTNUMBER]){await i.loadScriptCls.execCommandsBase(i.CURRENTNUMBER,i.CURRENTNUMBER,i.STATENUMBER);let t=i.commands[i.CURRENTNUMBER].indexOf("|||"),n=-1!=t?i.commands[i.CURRENTNUMBER].substr(0,t):i.commands[i.CURRENTNUMBER],l=30,r=n.length>l?n.substr(0,l)+"...":n,o=i.applyCommandCls.getMenuFromCmd(r);$("#"+e.pre+"replay_cmd").html("Cmd: "+r),$("#"+e.pre+"replay_menu").html("Menu: "+o),s.setLogCmd(n,!0),i.drawCls.draw()}})),t.loadScriptCls.pressCommandtext(),e.myEventCls.onIds("#"+e.pre+"seq_saveselection","click",(function(t){let s=e.icn3d;t.stopImmediatePropagation(),e.cfg.notebook||dialog.dialog("close"),s.selectionCls.saveSelectionPrep();let i=$("#"+e.pre+"seq_command_name").val().replace(/\s+/g,"_");s.selectionCls.saveSelection(i,i)})),e.myEventCls.onIds("#"+e.pre+"seq_saveselection2","click",(function(t){let s=e.icn3d;t.stopImmediatePropagation(),s.selectionCls.saveSelectionPrep();let i=$("#"+e.pre+"seq_command_name2").val().replace(/\s+/g,"_");s.selectionCls.saveSelection(i,i)})),e.myEventCls.onIds("#"+e.pre+"mn2_saveresidue","click",(function(t){let i=e.icn3d;t.stopImmediatePropagation(),e.cfg.notebook||dialog.dialog("close"),i.selectionCls.saveEachResiInSel(),s.setLogCmd("select each residue",!0)})),e.myEventCls.onIds("#"+e.pre+"alignseq_saveselection","click",(function(t){let s=e.icn3d;t.stopImmediatePropagation(),s.selectionCls.saveSelectionPrep();let i=$("#"+e.pre+"alignseq_command_name").val().replace(/\s+/g,"_");s.selectionCls.saveSelection(i,i)})),$(document).on("click","."+e.pre+"outputselection",(function(t){let i=e.icn3d;t.stopImmediatePropagation(),i.bSelectResidue=!1,i.bSelectAlignResidue=!1,s.setLogCmd("output selection",!0),i.threeDPrintCls.outputSelection()})),$(document).on("click",".icn3d-saveicon",(function(t){e.icn3d,t.stopImmediatePropagation();let i=$(this).attr("pid");s.saveHtml(i),s.setLogCmd("save html "+i,!0)})),$(document).on("click",".icn3d-hideicon",(function(t){let s=e.icn3d;t.stopImmediatePropagation();let i=$(this).attr("pid");if(!e.cfg.notebook)if(void 0===s.dialogHashHideDone&&(s.dialogHashHideDone={}),void 0===s.dialogHashPosToRight&&(s.dialogHashPosToRight={}),s.dialogHashHideDone.hasOwnProperty(i)){let e=s.dialogHashHideDone[i].width,t=s.dialogHashHideDone[i].height,n=s.dialogHashHideDone[i].position;$("#"+i).dialog("option","width",e),$("#"+i).dialog("option","height",t),$("#"+i).dialog("option","position",n),delete s.dialogHashHideDone[i]}else{s.dialogHashHideDone[i]={width:$("#"+i).dialog("option","width"),height:$("#"+i).dialog("option","height"),position:$("#"+i).dialog("option","position")};let e,t=160,n=80;$("#"+i).dialog("option","width",t),$("#"+i).dialog("option","height",n),s.dialogHashPosToRight.hasOwnProperty(i)?e=s.dialogHashPosToRight[i]:(e=Object.keys(s.dialogHashPosToRight).length*(t+10),s.dialogHashPosToRight[i]=e);let l={my:"right bottom",at:"right-"+e+" bottom+60",of:"#"+s.divid,collision:"none"};$("#"+i).dialog("option","position",l)}})),$(document).on("click","."+e.pre+"selres",(function(t){let i=e.icn3d;t.stopImmediatePropagation(),i.bSelOneRes=!1;let n=$("."+e.pre+"seloneres");for(let e=0,t=n.length;e<t;++e)n[e].checked=!1;let l=$(this).attr("resid").split("|");i.hAtoms={},i.selectedResidues={};let r="select ";for(let e=0,t=l.length;e<t;++e){let t=l[e];e>0&&(r+=" or "),r+=i.selectionCls.selectOneResid(t)}i.hlUpdateCls.updateHlAll(),s.setLogCmd(r,!0)})),$(document).on("click","."+e.pre+"seloneres",(function(t){let s=e.icn3d;t.stopImmediatePropagation(),s.bSelOneRes||(s.hAtoms={},s.selectedResidues={},s.bSelOneRes=!0);let i=$(this).attr("resid"),n=$(this).attr("id");$("#"+n).length&&$("#"+n)[0].checked?s.selectionCls.selectOneResid(i):$("#"+n).length&&!$("#"+n)[0].checked&&s.selectionCls.selectOneResid(i,!0),s.hlUpdateCls.updateHlAll()})),$(document).on("click","."+e.pre+"selset",(async function(t){let i=e.icn3d;t.stopImmediatePropagation(),i.bSelOneRes=!1;let n=$("."+e.pre+"seloneres");for(let e=0,t=n.length;e<t;++e)n[e].checked=!1;let l=$(this).attr("cmd");await i.selByCommCls.selectByCommand(l,"",""),i.hlObjectsCls.removeHlObjects(),i.hlObjectsCls.addHlObjects(),s.setLogCmd(l,!0)})),$(document).on("click",".icn3d-addtrack",(function(t){let s=e.icn3d;t.stopImmediatePropagation(),$("#"+e.pre+"anno_custom")[0].checked=!0,$("[id^="+e.pre+"custom]").show();let i=$(this).attr("chainid"),n=s.chainsGene[i].geneId;$("#"+e.pre+"track_chainid").val(i),$("#"+e.pre+"track_geneid").val(n),e.htmlCls.dialogCls.openDlg("dl_addtrack","Add track for Chain: "+i),$("#"+e.pre+"track_gi").focus()})),$(document).on("click",".icn3d-customcolor",(function(t){e.icn3d,t.stopImmediatePropagation();let s=$(this).attr("chainid");$("#"+e.pre+"customcolor_chainid").val(s),e.htmlCls.dialogCls.openDlg("dl_customcolor","Apply custom color or tube for Chain: "+s)})),$(document).on("click",".icn3d-helixsets",(function(t){let i=e.icn3d;t.stopImmediatePropagation();let n=$(this).attr("chainid");i.addTrackCls.defineSecondary(n,"helix"),s.setLogCmd("define helix sets | chain "+n,!0)})),$(document).on("click",".icn3d-sheetsets",(function(t){let i=e.icn3d;t.stopImmediatePropagation();let n=$(this).attr("chainid");i.addTrackCls.defineSecondary(n,"sheet"),s.setLogCmd("define sheet sets | chain "+n,!0)})),$(document).on("click",".icn3d-coilsets",(function(t){let i=e.icn3d;t.stopImmediatePropagation();let n=$(this).attr("chainid");i.addTrackCls.defineSecondary(n,"coil"),s.setLogCmd("define coil sets | chain "+n,!0)})),$(document).on("click",".icn3d-iganchorsets",(function(t){let i=e.icn3d;t.stopImmediatePropagation();let n=$(this).attr("chainid");i.addTrackCls.defineIgstrand(n,"iganchor"),s.setLogCmd("define iganchor sets | chain "+n,!0)})),$(document).on("click",".icn3d-igstrandsets",(function(t){let i=e.icn3d;t.stopImmediatePropagation();let n=$(this).attr("chainid");i.addTrackCls.defineIgstrand(n,"igstrand"),s.setLogCmd("define igstrand sets | chain "+n,!0)})),$(document).on("click",".icn3d-igloopsets",(function(t){let i=e.icn3d;t.stopImmediatePropagation();let n=$(this).attr("chainid");i.addTrackCls.defineIgstrand(n,"igloop"),s.setLogCmd("define igloop sets | chain "+n,!0)})),$(document).on("click",".icn3d-igdomainsets",(function(t){let i=e.icn3d;t.stopImmediatePropagation();let n=$(this).attr("chainid");i.addTrackCls.defineIgstrand(n,"igdomain"),s.setLogCmd("define igdomain sets | chain "+n,!0)})),e.myEventCls.onIds("#"+e.pre+"deletesets","click",(function(t){e.icn3d.definedSetsCls.deleteSelectedSets(),s.setLogCmd("delete selected sets",!0)})),$(document).on("mouseup touchend","accordion",(function(t){let s=e.icn3d;s.bControlGl&&!e.bNode?window.controls&&(window.controls.noRotate=!1,window.controls.noZoom=!1,window.controls.noPan=!1):s.controls&&(s.controls.noRotate=!1,s.controls.noZoom=!1,s.controls.noPan=!1)})),$(document).on("mousedown touchstart","accordion",(function(t){let s=e.icn3d;s.bControlGl&&!e.bNode?window.controls&&(window.controls.noRotate=!0,window.controls.noZoom=!0,window.controls.noPan=!0):s.controls&&(s.controls.noRotate=!0,s.controls.noZoom=!0,s.controls.noPan=!0)})),$(document).on("click",".icn3d-expand",(function(t){e.icn3d,t.stopImmediatePropagation();let s=$(this).attr("id"),i=s.lastIndexOf("_"),n=s.substr(0,i);$("#"+n).show(),$("#"+n+"_expand").hide(),$("#"+n+"_shrink").show()})),$(document).on("click",".icn3d-shrink",(function(t){e.icn3d,t.stopImmediatePropagation();let s=$(this).attr("id"),i=s.lastIndexOf("_"),n=s.substr(0,i);$("#"+n).hide(),$("#"+n+"_expand").show(),$("#"+n+"_shrink").hide()})),window.onscroll=function(t){let s=e.icn3d;"detailed view"==s.view&&0==$(window).scrollTop()&&0==$(window).scrollTop()&&0==$("#"+e.pre+"dl_selectannotations").scrollTop()?s.annotationCls.showFixedTitle():s.annotationCls.hideFixedTitle()},e.myEventCls.onIds("#"+e.pre+"dl_selectannotations","scroll",(function(){"detailed view"==t.view&&0==$(window).scrollTop()&&0==$(window).scrollTop()&&0==$("#"+e.pre+"dl_selectannotations").scrollTop()?t.annotationCls.showFixedTitle():t.annotationCls.hideFixedTitle()})),e.myEventCls.onIds("#"+e.pre+"mn6_themeBlue","click",(function(t){e.icn3d,e.htmlCls.setMenuCls.setTheme("blue"),s.setLogCmd("set theme blue",!0)})),e.myEventCls.onIds("#"+e.pre+"mn6_themeOrange","click",(function(t){e.icn3d,e.htmlCls.setMenuCls.setTheme("orange"),s.setLogCmd("set theme orange",!0)})),e.myEventCls.onIds("#"+e.pre+"mn6_themeBlack","click",(function(t){e.icn3d,e.htmlCls.setMenuCls.setTheme("black"),s.setLogCmd("set theme black",!0)})),$(document).on("click","."+e.pre+"snpin3d",(async function(t){let i=e.icn3d;t.stopImmediatePropagation();let n=$(this).attr("snp");await i.scapCls.retrieveScap(n),s.setLogCmd("scap 3d "+n,!0),s.setLogCmd("select displayed set",!0)})),$(document).on("click","."+e.pre+"snpinter",(async function(t){let i=e.icn3d;t.stopImmediatePropagation();let n=$(this).attr("snp");await i.scapCls.retrieveScap(n,!0),s.setLogCmd("scap interaction "+n,!0);let l=n.split("_"),r="."+l[1]+":"+l[2],o="snp_"+l[1]+"_"+l[2];s.setLogCmd("select "+r+" | name "+o,!0),s.setLogCmd("line graph interaction pairs | selected non-selected | hbonds,salt bridge,interactions,halogen,pi-cation,pi-stacking | false | threshold 3.8 6 4 3.8 6 5.5",!0),s.setLogCmd("adjust dialog dl_linegraph",!0),s.setLogCmd("select displayed set",!0)})),$(document).on("click","."+e.pre+"snppdb",(async function(t){let i=e.icn3d;t.stopImmediatePropagation();let n=$(this).attr("snp");await i.scapCls.retrieveScap(n,void 0,!0),s.setLogCmd("scap pdb "+n,!0)}))}}class m{constructor(e){this.icn3dui=e}getAlignSequencesAnnotations(e,t,s,i,n,l){let r=this.icn3dui,o=r.icn3d,a="";e=Object.keys(o.alnChains),l&&(e=e.reverse());let d=0,c={};if(void 0!==e)for(let t=0,s=e.length;t<s;++t){let s=e[t];if(!(o.alnChainsSeq[s]&&o.alnChainsSeq[s].length>0))return{sequencesHtml:a,maxSeqCnt:d};c[s]=1}let h,p=void 0===t||t;p&&(o.hAtoms={});let m,u,g=0,f=0;for(let t=0,l=e.length;t<l;++t){let l=e[t];0==g&&(m=l),u=n&&g>0?m:l,p&&(o.hAtoms=r.hashUtilsCls.unionHash(o.hAtoms,o.alnChains[l]));let C=[],b="",y=void 0!==o.alnChainsSeq[l]?o.alnChainsSeq[l].length:0;y>d&&(d=y);let v,_,w=u.indexOf("_"),S=u.substr(0,w),A=u.substr(w+1);for(let e=0,t=y;e<t;++e)if("-"!=o.alnChainsSeq[l][e].resn){v=o.alnChainsSeq[l][e].resi;break}for(let e=y-1;e>=0;--e)if("-"!=o.alnChainsSeq[l][e].resn){_=o.alnChainsSeq[l][e].resi;break}b+="<span class='icn3d-residueNum' title='starting residue number'>"+v+"</span>",h=!(void 0===e||!c.hasOwnProperty(u));for(let e=0,t=y;e<t;++e){let t="N/A",a="";""!==o.alnChainsSeq[l][e].resi&&(t=o.alnChainsSeq[l][e].resi,a=S+"_"+A+"_"+t,o.alnChainsSeq[l][e].color);let d,c="class='icn3d-residue";if((void 0===i||i)&&(h||void 0!==s&&""!==a&&-1!==s.indexOf(a))&&(c="class='icn3d-residue icn3d-highlightSeq"),c+=""===a?"'":" "+o.alnChainsSeq[l][e].class+"'",o.residues.hasOwnProperty(a)){let e=o.firstAtomObjCls.getFirstCalphaAtomObj(o.residues[a]);d=void 0!==e.color?"#"+e.color.getHexString()+";":"#000000;"}else d="#000000;";if("#FFFFFF;"===d.toUpperCase()&&(d=r.htmlCls.GREYD),n&&0==e){b+="<span style='width:"+f*10+"px'></span>"}""!==a?-1!=o.alnChainsSeq[l][e].resi?b+="<span id='align_"+r.pre+a+"' "+c+" style='color:"+d+"' title='"+o.alnChainsSeq[l][e].resn+o.alnChainsSeq[l][e].resi+"'>"+o.alnChainsSeq[l][e].resn+"</span>":b+="<span>"+o.alnChainsSeq[l][e].resn+"</span>":b+="<span title='"+o.alnChainsSeq[l][e].resn+o.alnChainsSeq[l][e].resi+"'>"+o.alnChainsSeq[l][e].resn+"</span>"}b+="<span class='icn3d-residueNum' title='ending residue number'>"+_+"</span>";let x=e.length,k=void 0!==o.alnChainsAnno[l]?o.alnChainsAnno[l].length:0;for(let t=0,s=k;t<s;++t){C[t]="";let s=t<x?e[x-1-t]:u;C[t]+="<span class='icn3d-residueNum'></span>";for(let e=0,i=o.alnChainsAnno[l][t].length;e<i;++e){let i=o.alnChainsAnno[l][t][e];if("H"==i||"E"==i||"c"==i||"o"==i)if("H"==i)C[t]+=e%2==0?'<span class="icn3d-helix">&nbsp;</span>':'<span class="icn3d-helix2">&nbsp;</span>';else if("E"==i)if(void 0!==o.alnChainsSeq[s][e]){let i=s+"_"+o.alnChainsSeq[s][e].resi;if(o.residues.hasOwnProperty(i)){o.firstAtomObjCls.getFirstCalphaAtomObj(o.residues[i]).ssend?C[t]+='<span class="icn3d-sheet2">&nbsp;</span>':C[t]+='<span class="icn3d-sheet">&nbsp;</span>'}else C[t]+='<span class="icn3d-sheet">&nbsp;</span>'}else C[t]+='<span class="icn3d-sheet">&nbsp;</span>';else C[t]+="c"==i?'<span class="icn3d-coil">&nbsp;</span>':"o"==i?'<span class="icn3d-other">&nbsp;</span>':"<span></span>";else C[t]+="<span>"+i+"</span>"}C[t]+="<span class='icn3d-residueNum'></span>"}let O=l,R=void 0!==o.pdbid_chain2title?o.pdbid_chain2title[u]:"";for(let e=k-1;e>=0;--e){let t=o.alnChainsAnTtl[l][e][0];"SS"==t&&(t=""),a+="<div class='icn3d-residueLine' style='white-space:nowrap;'><div class='icn3d-seqTitle' anno='"+e+"'>"+t+"</div>"+C[e]+"<br/></div>"}a+='<div class="icn3d-seqTitle icn3d-link icn3d-blue" chain="'+l+'" anno="sequence" title="'+R+'">'+O+' </div><span class="icn3d-seqLine">'+b+"</span><br/>",g>0&&(f+=y),++g}return{sequencesHtml:a,maxSeqCnt:d}}}class u{constructor(e){this.icn3dui=e}getLink(e,t,s,i){let n=this.icn3dui;return n.icn3d,n.htmlCls.allMenus[e]=t,i&&(n.htmlCls.allMenusSel[e]=i),s&&(n.htmlCls.simpleMenus[e]=1),"<li><span data-pinger id='"+n.pre+e+"' class='icn3d-link'>"+t+"</span></li>"}getMenuText(e,t,s,i,n){let l=this.icn3dui;l.icn3d,l.htmlCls.allMenus[e]=t,n&&(l.htmlCls.allMenusSel[e]=n),i&&(l.htmlCls.simpleMenus[e]=1);let r="icn3d-menupd"==s?" style='padding-left:1.5em!important;'":"";return"<li><span data-pinger id='"+l.pre+e+"'"+r+">"+t+"</span>"}getMenuUrl(e,t,s,i,n){let l=this.icn3dui;return l.icn3d,l.htmlCls.allMenus[e]=s,n&&(l.htmlCls.allMenusSel[e]=n),i&&(l.htmlCls.simpleMenus[e]=1),"<li><a id='"+l.pre+e+"' href='"+t+"' target='_blank'>"+s+"</a></li>"}getMenuSep(){return this.icn3dui.icn3d,"<li class='icn3d-menusep'>-</li>"}getLinkWrapper(e,t,s,i,n,l){let r=this.icn3dui;r.icn3d,r.htmlCls.allMenus[e]=t,n&&(r.htmlCls.allMenusSel[e]=n),i&&(r.htmlCls.simpleMenus[e]=1);let o=l?' style="display:none"':"";return"<li id='"+r.pre+s+"'"+o+"><span data-pinger id='"+r.pre+e+"' class='icn3d-link'>"+t+"</span></li>"}getLinkWrapper2(e,t,s,i,n){let l=this.icn3dui;return l.icn3d,l.htmlCls.allMenus[e]=t,n&&(l.htmlCls.allMenusSel[e]=n),i&&(l.htmlCls.simpleMenus[e]=1),"<li id='"+l.pre+s+"'><span data-pinger id='"+l.pre+e+"' class='icn3d-link'>"+t+"</span>"}getRadio(e,t,s,i,n,l){let r=this.icn3dui;r.icn3d,r.htmlCls.allMenus[t]=s,l&&(r.htmlCls.allMenusSel[t]=l),n&&(r.htmlCls.simpleMenus[t]=1);let o=i?" checked":"";return"<li><label data-pinger id='"+r.pre+t+"' class='icn3d-rad'>"+r.htmlCls.inputRadioStr+"name='"+r.pre+e+"' class='"+r.pre+e+"' v='"+s+"'"+o+"><span class='ui-icon ui-icon-blank'></span> <span class='icn3d-rad-text'>"+s+"</span></label></li>"}getRadioColor(e,t,s,i,n,l,r){let o=this.icn3dui;o.icn3d,o.htmlCls.allMenus[t]=s,r&&(o.htmlCls.allMenusSel[t]=r),l&&(o.htmlCls.simpleMenus[t]=1);let a=n?" checked":"";return"<li><label data-pinger id='"+o.pre+t+"' class='icn3d-rad'>"+o.htmlCls.inputRadioStr+"name='"+o.pre+e+"'"+a+"><span class='ui-icon ui-icon-blank'></span> <span class='icn3d-color-rad-text' color='"+i+"'><span style='background-color:#"+i+"'>"+o.htmlCls.space3+"</span> "+s+"</span></label></li>"}setAdvanced(e){let t=this.icn3dui;t.icn3d;let s=void 0===e?"":e,i=t.cfg.notebook?"icn3d-hidden":"",n=t.htmlCls.divStr+"dl_advanced"+s+"' class='"+i+"'>";return n+="<table width='500'><tr><td valign='top'><table cellspacing='0'>",n+="<tr><td><b>Select:</b></td><td>"+t.htmlCls.inputTextStr+"id='"+t.pre+"command"+s+"' placeholder='$[structures].[chains]:[residues]@[atoms]' size='60'></td></tr>",n+="<tr><td><b>Name:</b></td><td>"+t.htmlCls.inputTextStr+"id='"+t.pre+"command_name"+s+"' placeholder='my_selection' size='60'></td></tr>",n+="<tr><td colspan='2' align='left'>"+t.htmlCls.space3+t.htmlCls.buttonStr+"command_apply"+s+"'><b>Save Selection to Defined Sets</b></button></td></tr>",n+="</table></td>",n+="</tr>",n+="<tr><td>",n+='Specification Tips: <div style="width:20px; margin-top:6px; display:inline-block;"><span id="'+t.pre+"specguide"+s+'_expand" class="ui-icon ui-icon-plus icn3d-expand icn3d-link" style="width:15px;" title="Expand"></span><span id="'+t.pre+"specguide"+s+'_shrink" class="ui-icon ui-icon-minus icn3d-shrink icn3d-link" style="display:none; width:15px;" title="Shrink"></span></div><br>',n+=t.htmlCls.divStr+"specguide"+s+"' style='display:none; width:500px' class='icn3d-box'>",n+='<b>Specification:</b> In the selection "$1HHO,4N7N.A,B,C:5-10,LV,3AlaVal,chemicals@CA,C,C*":',n+='<ul><li>"$1HHO,4N7N" uses "$" to indicate structure selection.<br/>',n+='<li>".A,B,C" uses "." to indicate chain selection.<br/>',n+='<li>":5-10,LV,3LeuVal,chemicals" uses the colon ":" to indicate residue selection. Residue selection could be residue number(5-10), one-letter IUPAC residue name abbreviations(LV), three-letter residue names(AlaVal, "3" indicates each residue name has three letters), or predefined names: "proteins", "nucleotides", "chemicals", "ions", and "water". IUPAC abbreviations can be written either as a contiguous string(e.g., ":LV"), in order to find all instances of that sequence in the structure, or they can be separated by commas(e.g., ":L,V") to select all residues of a given type in the structure(in the latter case, select all Leucine and Valine in the structure).<br/>',n+='<li>"@CA,C,C*" uses "@" to indicate atom name selection. "C*" selects any atom names starting with "C". <br/>',n+='<li>Partial definition is allowed, e.g., ":1-10" selects all residue IDs 1-10 in all chains.<br/>',n+='<li>Different selections can be unioned(with "<b>or</b>", default), intersected(with "<b>and</b>"), or negated(with "<b>not</b>"). For example, ":1-10 or :K" selects all residues 1-10 and all Lys residues. ":1-10 and :K" selects all Lys residues in the range of residue number 1-10. ":1-10 or not :K" selects all residues 1-10, which are not Lys residues.<br/>',n+='<li>The wild card character "X" or "x" can be used to represent any character.',n+="</ul>",n+="<b>Set Operation:</b>",n+='<ul><li>Users can select multiple sets in the menu "Select > Defined Sets".<br/>',n+='<li>Different sets can be unioned(with "<b>or</b>", default), intersected(with "<b>and</b>"), or negated(with "<b>not</b>"). For example, if the "Defined Sets" menu has four sets ":1-10", ":11-20", ":5-15", and ":7-8", the command "saved atoms :1-10 or :11-20 and :5-15 not :7-8" unions all residues 1-10 and 11-20 to get the residues 1-20, then intersects with the residues 5-15 to get the residues 5-15, then exclude the residues 7-8 to get the final residues 5-6 and 9-15.</ul>',n+="<b>Full commands in url or command window:</b>",n+="<ul><li>Select without saving the set: select $1HHO,4N7N.A,B,C:5-10,LV,chemicals@CA,C,C*<br/>",n+="<li>Select and save: select $1HHO,4N7N.A,B,C:5-10,LV,chemicals@CA,C,C* | name my_name</ul>",n+="</div>",n+="</td></tr></table>",n+="</div>",n}getOptionHtml(e,t){let s=this.icn3dui;s.icn3d;let i="";for(let n=0,l=e.length;n<l;++n){let l=e[n];i+=n==t?s.htmlCls.optionStr+"'"+l+"' selected>"+l+"</option>":s.htmlCls.optionStr+"'"+l+"'>"+l+"</option>"}return i}setColorHints(){let e=this.icn3dui;e.icn3d;let t="";return t+=e.htmlCls.divNowrapStr+'<span style="margin-left:33px; color:#00FF00; font-weight:bold">Green</span>: H-Bonds; ',t+='<span style="color:#00FFFF; font-weight:bold">Cyan</span>: Salt Bridge/Ionic; ',t+='<span style="font-weight:bold">Grey</span>: Contacts</div>',t+=e.htmlCls.divNowrapStr+'<span style="margin-left:33px; color:#FF00FF; font-weight:bold">Magenta</span>: Halogen Bonds; ',t+='<span style="color:#FF0000; font-weight:bold">Red</span>: &pi;-Cation; ',t+='<span style="color:#0000FF; font-weight:bold">Blue</span>: &pi;-Stacking</div>',t}setThicknessHtml(e){let t=this.icn3dui,s=t.icn3d,i="",n="3dprint"==e?"1":"0.1",l="3dprint"==e?"1.2":"0.3",r="3dprint"==e?"0.8":"0.4",o="3dprint"==e?"0.8":"0.4",a="3dprint"==e?"1":"0.4",d="3dprint"==e?"0.6":"0.3",c="3dprint"==e?"1":"0.2",h="3dprint"==e?"2":"1.3",p="3dprint"==e?"1.4":"0.8",m=40,u=.8,g=.4,f=.2,C=0,b=1,y=0;if("style"==e){if(""!=this.getCookie("shininess")&&(m=parseFloat(this.getCookie("shininess"))),""!=this.getCookie("light1")&&(u=parseFloat(this.getCookie("light1")),g=parseFloat(this.getCookie("light2")),f=parseFloat(this.getCookie("light3"))),""!=this.getCookie("lineRadius")){n=parseFloat(this.getCookie("lineRadius")),l=parseFloat(this.getCookie("coilWidth")),r=parseFloat(this.getCookie("cylinderRadius"));let e=this.getCookie("crosslinkRadius");o=isNaN(e)?s.crosslinkRadius:parseFloat(e),a=parseFloat(this.getCookie("traceRadius")),d=parseFloat(this.getCookie("dotSphereScale")),c=parseFloat(this.getCookie("ribbonthickness")),h=parseFloat(this.getCookie("helixSheetWidth")),p=parseFloat(this.getCookie("nucleicAcidWidth"))}""!=this.getCookie("glycan")&&(C=parseFloat(this.getCookie("glycan"))),""!=this.getCookie("membrane")&&(b=parseFloat(this.getCookie("membrane"))),""!=this.getCookie("cmdwindow")&&(y=parseFloat(this.getCookie("cmdwindow"))),i+="<b>Note</b>: The following parameters will be saved in cache. You just need to set them once. <br><br>",i+="<b>1. Shininess</b>: "+t.htmlCls.inputTextStr+"id='"+t.pre+"shininess' value='"+m+"' size=4>"+t.htmlCls.space3+"(for the shininess of the 3D objects, default 40)<br/><br/>",i+="<b>2. Three directional lights</b>: <br>",i+="<b>Key Light</b>: "+t.htmlCls.inputTextStr+"id='"+t.pre+"light1' value='"+u+"' size=4>"+t.htmlCls.space3+"(for the light strength of the key light, default 0.8)<br/>",i+="<b>Fill Light</b>: "+t.htmlCls.inputTextStr+"id='"+t.pre+"light2' value='"+g+"' size=4>"+t.htmlCls.space3+"(for the light strength of the fill light, default 0.4)<br/>",i+="<b>Back Light</b>: "+t.htmlCls.inputTextStr+"id='"+t.pre+"light3' value='"+f+"' size=4>"+t.htmlCls.space3+"(for the light strength of the back light, default 0.2)<br/><br/>",i+="<b>3. Thickness</b>: <br>"}return i+="<b>Line Radius</b>: "+t.htmlCls.inputTextStr+"id='"+t.pre+"linerad_"+e+"' value='"+n+"' size=4>"+t.htmlCls.space3+"(for stabilizers, hydrogen bonds, distance lines, default 0.1)<br/>",i+="<b>Coil Radius</b>: "+t.htmlCls.inputTextStr+"id='"+t.pre+"coilrad_"+e+"' value='"+l+"' size=4>"+t.htmlCls.space3+"(for coils, default 0.3)<br/>",i+="<b>Stick Radius</b>: "+t.htmlCls.inputTextStr+"id='"+t.pre+"stickrad_"+e+"' value='"+r+"' size=4>"+t.htmlCls.space3+"(for sticks, default 0.4)<br/>",i+="<b>Cross-Linkage Radius</b>: "+t.htmlCls.inputTextStr+"id='"+t.pre+"crosslinkrad_"+e+"' value='"+o+"' size=4>"+t.htmlCls.space3+"(for cross-linkages, default 0.4)<br/>",i+="<b>Trace Radius</b>: "+t.htmlCls.inputTextStr+"id='"+t.pre+"tracerad_"+e+"' value='"+a+"' size=4>"+t.htmlCls.space3+"(for C alpha trace, O3' trace, default 0.4)<br/>",i+="<b>Ribbon Thickness</b>: "+t.htmlCls.inputTextStr+"id='"+t.pre+"ribbonthick_"+e+"' value='"+c+"' size=4>"+t.htmlCls.space3+"(for helix and sheet ribbons, nucleotide ribbons, default 0.2)<br/>",i+="<b>Protein Ribbon Width</b>: "+t.htmlCls.inputTextStr+"id='"+t.pre+"prtribbonwidth_"+e+"' value='"+h+"' size=4>"+t.htmlCls.space3+"(for helix and sheet ribbons, default 1.3)<br/>",i+="<b>Nucleotide Ribbon Width</b>: "+t.htmlCls.inputTextStr+"id='"+t.pre+"nucleotideribbonwidth_"+e+"' value='"+p+"' size=4>"+t.htmlCls.space3+"(for nucleotide ribbons, default 0.8)<br/>",i+="<b>Ball Scale</b>: "+t.htmlCls.inputTextStr+"id='"+t.pre+"ballscale_"+e+"' value='"+d+"' size=4>"+t.htmlCls.space3+"(for styles 'Ball and Stick' and 'Dot', default 0.3)<br/>","style"==e&&(i+="<br><b>4. Show Glycan Cartoon</b>: "+t.htmlCls.inputTextStr+"id='"+t.pre+"glycan' value='"+C+"' size=4>"+t.htmlCls.space3+"(0: hide, 1: show, default 0)<br/>",i+="<br><b>5. Show Membrane</b>: "+t.htmlCls.inputTextStr+"id='"+t.pre+"membrane' value='"+b+"' size=4>"+t.htmlCls.space3+"(0: hide, 1: show, default 1)<br/>",i+="<br><b>6. Enlarge Command Window</b>: "+t.htmlCls.inputTextStr+"id='"+t.pre+"cmdwindow' value='"+y+"' size=4>"+t.htmlCls.space3+"(0: Regular, 1: Large, default 0)<br/><br/>"),i+=t.htmlCls.spanNowrapStr+""+t.htmlCls.buttonStr+"apply_thickness_"+e+"'>Apply</button></span>&nbsp;&nbsp;&nbsp;",i+=t.htmlCls.spanNowrapStr+""+t.htmlCls.buttonStr+"reset_thickness_"+e+"'>Reset</button></span>",i}getCookie(e){let t=e+"=",s=decodeURIComponent(document.cookie).split(";");for(let e=0;e<s.length;e++){let i=s[e];for(;" "==i.charAt(0);)i=i.substring(1);if(0==i.indexOf(t))return i.substring(t.length,i.length)}return""}setSequenceGuide(e,t){let s=this.icn3dui,i=s.icn3d,n="",l=i&&i.defNames2Atoms?Object.keys(i.defNames2Atoms).length:1;t?n+=s.htmlCls.divStr+"seqguide"+e+"'>":(n+='<div style="width:20px; margin-left:3px; display:inline-block;"><span id="'+s.pre+"seqguide"+e+'_expand" class="ui-icon ui-icon-plus icn3d-expand icn3d-link" style="width:15px;" title="Expand"></span><span id="'+s.pre+"seqguide"+e+'_shrink" class="ui-icon ui-icon-minus icn3d-shrink icn3d-link" style="display:none; width:15px;" title="Shrink"></span></div> ',n+="<div style='min-width:200px; display:inline-block;'><b>Selection:</b> Name: "+s.htmlCls.inputTextStr+"id='"+s.pre+"seq_command_name"+e+"' value='seq_"+l+"' size='5'> "+s.htmlCls.space2+"<button style='white-space:nowrap;' id='"+s.pre+"seq_saveselection"+e+"'>Save</button> <button style='white-space:nowrap; margin-left:20px;' id='"+s.pre+"seq_clearselection"+e+"'>Clear</button></div><br/>",n+=s.htmlCls.divStr+"seqguide"+e+"' style='display:none; white-space:normal;' class='icn3d-box'>"),n+=this.getSelectionHints();return n+="<b>Residue labeling:</b> standard residue with coordinates: UPPER case letter; nonstandard residue with coordinates: the first UPPER case letter plus a period except that water residue uses the letter 'O'; residue missing coordinates: lower case letter."+(s.utilsCls.isMac()&&!s.utilsCls.isMobile()?"<br/><br/><b>Turn on scroll bar:</b> System preferences -> General -> show scroll bars -> check Always":"")+"<br/></div>",n}setAlignSequenceGuide(e,t){let s=this.icn3dui,i=s.icn3d,n="";let l=i&&i.defNames2Atoms?Object.keys(i.defNames2Atoms).length:1;n+='<div style="width:20px; margin-left:3px; display:inline-block;"><span id="'+s.pre+'alignseqguide_expand" class="ui-icon ui-icon-plus icn3d-expand icn3d-link" style="width:15px;" title="Expand"></span><span id="'+s.pre+'alignseqguide_shrink" class="ui-icon ui-icon-minus icn3d-shrink icn3d-link" style="display:none; width:15px;" title="Shrink"></span></div> ',n+="<div style='min-width:200px; display:inline-block;''><b>Selection:</b> Name: "+s.htmlCls.inputTextStr+"id='"+s.pre+"alignseq_command_name' value='alseq_"+l+"' size='10'> "+s.htmlCls.space2+"<button style='white-space:nowrap;' id='"+s.pre+"alignseq_saveselection'>Save</button> <button style='white-space:nowrap; margin-left:20px;' id='"+s.pre+"alignseq_clearselection'>Clear</button></div><br/>",n+=s.htmlCls.divStr+"alignseqguide' style='display:none; white-space:normal;' class='icn3d-box'>",n+=this.getSelectionHints();return n+="<b>Residue labeling:</b> aligned residue with coordinates: UPPER case letter; non-aligned residue with coordinates: lower case letter which can be highlighted; residue missing coordinates: lower case letter which can NOT be highlighted."+(s.utilsCls.isMac()&&!s.utilsCls.isMobile()?"<br/><br/><b>Turn on scroll bar:</b> System preferences -> General -> show scroll bars -> check Always":"")+"<br/></div>",n}getSelectionHints(){let e=this.icn3dui;e.icn3d;let t="";if(e.utilsCls.isMobile())t+='<b>Select Aligned Sequences:</b> touch to select, touch again to deselect, multiple selection is allowed without Ctrl key, click "Save Selection" to save the current selection.<br/>';else{t+='<b>Select on 1D sequences:</b> drag to select, drag again to deselect, multiple selection is allowed without Ctrl key, click "Save Selection" to save the current selection.<br/><br/>',t+="<b>Select on 2D interaction diagram:</b> click on the nodes or lines. The nodes are chains and can be united with the Ctrl key. The lines are interactions and can NOT be united. Each click on the lines selects half of the lines, i.e., select the interacting residues in one of the two chains.<br/><br/>",t+="<b>Select on 3D structures:</b> "+(e.utilsCls.isMobile()?"use finger to pick":'hold "Alt" and use mouse to pick')+', click the second time to deselect, hold "Ctrl" to union selection, hold "Shift" to select a range, press the up/down arrow to switch among atom/residue/strand/chain/structure, click "Save Selection" to save the current selection.<br/><br/>',t+='<b>Save the current selection</b>(either on 3D structure, 2D interactions, or 1D sequence): open the menu "Select -> Save Selection", specify the name and description for the selection, and click "Save".<br/><br/>'}return t}addGsizeSalt(e){let t=this.icn3dui;t.icn3d;let s="";s+="<span style='white-space:nowrap;font-weight:bold;'>Grid Size: <select id='"+t.pre+e+"gsize'>";s+=this.getOptionHtml(["65","97","129"],0),s+="</select></span>",s+="<span style='white-space:nowrap;font-weight:bold;margin-left:30px;'>Salt Concentration: <select id='"+t.pre+e+"salt'>";return s+=this.getOptionHtml(["0","0.15"],1),s+="</select> M</span><br/>",s}getFootHtml(e,t){let s=this.icn3dui;s.icn3d;let i="<div style='width:500px;'>";return"delphi"==e?s.cfg.cid?i+="<b>Note</b>: Partial charges(MMFF94) are from PubChem Compound SDF files.<br/><br/>":(i+="<b>Note</b>: Only the selected residues are used for <a href='http://honig.c2b2.columbia.edu/delphi'>DelPhi</a> potential calculation by solving linear Poisson-Boltzmann equation.",i+='<div style="width:20px; margin-top:6px; display:inline-block;"><span id="'+s.pre+t+'_expand" class="ui-icon ui-icon-plus icn3d-expand icn3d-link" style="width:15px;" title="Expand"></span><span id="'+s.pre+t+'_shrink" class="ui-icon ui-icon-minus icn3d-shrink icn3d-link" style="display:none; width:15px;" title="Shrink"></span></div><br>',i+=s.htmlCls.divStr+t+"' style='display:none;'>",i+="<br>The hydrogens and partial charges of proteins and nucleotides are added using <a href='http://compbio.clemson.edu/pka_webserver'>DelPhiPKa</a> with the Amber charge and size files. The hydrogens of ligands are added using <a href='http://openbabel.org/wiki/Main_Page'>Open Babel</a>. The partial charges of ligands are calculated using <a href='http://ambermd.org/antechamber/ac.html'>Antechamber</a> with the Gasteiger charge method. All partial charges are calculated at pH 7.<br/><br/>",i+='Lipids are treated as ligands. Please use "HETATM" instead of "ATOM  " for each lipid atom in your PDB file. Each phosphate in lipids is assigned with a charge of -1. You can download PQR and modify it, or prepare your PQR file using other tools. Then load the PQR file at the menu "Analysis > Load PQR/Potential".<br/><br/>',i+="</div>"):(i+="<b>Note</b>: Always load a PDB file before loading a PQR or DelPhi potential file.",i+='<div style="width:20px; margin-top:6px; display:inline-block;"><span id="'+s.pre+t+'_expand" class="ui-icon ui-icon-plus icn3d-expand icn3d-link" style="width:15px;" title="Expand"></span><span id="'+s.pre+t+'_shrink" class="ui-icon ui-icon-minus icn3d-shrink icn3d-link" style="display:none; width:15px;" title="Shrink"></span></div><br>',i+=s.htmlCls.divStr+t+"' style='display:none;'>",i+='The PDB file can be loaded in the URL with "pdbid=" or at "File > Open File". The PQR file can be prepared at the menu "Analysis > Download PQR" with your modification or using other tools. The DelPhi potential file can be calculated at <a href=\'http://compbio.clemson.edu/sapp/delphi_webserver/\'>DelPhi Web Server</a> and be exported as a Cube file. ',"url"==e&&(i+="The PQR or potential file can be accessed in a URL if it is located in the same host as iCn3D."),i+="<br/><br/>",i+="</div>"),i+="</div>",i}getPotentialHtml(e,t){let s=this.icn3dui;s.icn3d;let i,n,l,r,o,a="";r="Equipotential Map",o="Surface with Potential","delphi"==e?n="delphi":"local"==e?(i="pqr",n="phi",l="cube"):"url"==e&&(i="pqrurl",n="phiurl",l="cubeurl"),a+=s.htmlCls.divStr+"dl_"+n+"' class='"+t+"'>",a+=s.htmlCls.setDialogCls.addNotebookTitle("dl_"+n,"DelPhi Potential"),a+=s.htmlCls.divStr+"dl_"+n+"_tabs' style='border:0px;'>",a+="<ul>",a+="<li><a href='#"+s.pre+n+"tab1'>Equipotential Map</a></li>",a+="<li><a href='#"+s.pre+n+"tab2'>Surface with Potential</a></li>",a+="</ul>",a+=s.htmlCls.divStr+n+"tab1'>","delphi"==e&&(a+=this.addGsizeSalt(n+"1")+"<br>"),a+="<span style='white-space:nowrap;font-weight:bold;'>Potential contour at: <select id='"+s.pre+n+"contour'>";let d;a+=this.getOptionHtml(["0.5","1","2","3","4","5","6","7","8","9","10"],2),a+="</select> kT/e(25.6mV at 298K)</span><br/><br/>","delphi"==e?(a+=s.htmlCls.buttonStr+"reload_"+n+"file' style='margin-top: 6px;'>Equipotential Map</button>",a+=s.htmlCls.buttonStr+n+"mapNo' style='margin-left:30px;'>Remove Map</button><br>"):"local"==e?(a+=s.htmlCls.divStr+n+"tab1_tabs' style='border:0px;'>",a+="<ul>",a+="<li><a href='#"+s.pre+n+"tab1_"+i+"'>PQR</a></li>",a+="<li><a href='#"+s.pre+n+"tab1_"+n+"'>Phi</a></li>",a+="<li><a href='#"+s.pre+n+"tab1_"+l+"'>Cube</a></li>",a+="</ul>",d="<span style='margin-left:30px'>"+s.htmlCls.buttonStr+n+"mapNo'>Remove Map</button></span></div>",a+=s.htmlCls.divStr+n+"tab1_"+i+"'>",a+=this.addGsizeSalt(i)+"<br>",a+="<b>PQR File</b>: "+s.htmlCls.inputFileStr+"id='"+s.pre+i+"file'> <br><br>"+s.htmlCls.buttonStr+"reload_"+i+"file' style='margin-top: 6px;'>Equipotential Map</button>"+d,a+=s.htmlCls.divStr+n+"tab1_"+n+"'>",a+="<b>Phi File</b>: "+s.htmlCls.inputFileStr+"id='"+s.pre+n+"file'> <br><br>"+s.htmlCls.buttonStr+"reload_"+n+"file' style='margin-top: 6px;'>Equipotential Map</button>"+d,a+=s.htmlCls.divStr+n+"tab1_"+l+"'>",a+="<b>Cube File</b>: "+s.htmlCls.inputFileStr+"id='"+s.pre+l+"file'> <br><br>"+s.htmlCls.buttonStr+"reload_"+l+"file' style='margin-top: 6px;'>Equipotential Map</button>"+d,a+="</div>"):"url"==e&&(a+=s.htmlCls.divStr+n+"tab1_tabs' style='border:0px;'>",a+="<ul>",a+="<li><a href='#"+s.pre+n+"tab1_"+i+"2'>PQR</a></li>",a+="<li><a href='#"+s.pre+n+"tab1_"+n+"2'>Phi</a></li>",a+="<li><a href='#"+s.pre+n+"tab1_"+l+"2'>Cube</a></li>",a+="</ul>",d="<span style='margin-left:30px'>"+s.htmlCls.buttonStr+n+"mapNo'>Remove Map</button></span></div>",a+=s.htmlCls.divStr+n+"tab1_"+i+"2'>",a+=this.addGsizeSalt(i)+"<br>",a+="<b>PQR URL</b> in the same host: "+s.htmlCls.inputTextStr+"id='"+s.pre+i+"file'> <br><br>"+s.htmlCls.buttonStr+"reload_"+i+"file' style='margin-top: 6px;'>Equipotential Map</button>"+d,a+=s.htmlCls.divStr+n+"tab1_"+n+"2'>",a+="<b>Phi URL</b> in the same host: "+s.htmlCls.inputTextStr+"id='"+s.pre+n+"file'> <br><br>"+s.htmlCls.buttonStr+"reload_"+n+"file' style='margin-top: 6px;'>Equipotential Map</button>"+d,a+=s.htmlCls.divStr+n+"tab1_"+l+"2'>",a+="<b>Cube URL</b> in the same host: "+s.htmlCls.inputTextStr+"id='"+s.pre+l+"file'> <br><br>"+s.htmlCls.buttonStr+"reload_"+l+"file' style='margin-top: 6px;'>Equipotential Map</button>"+d,a+="</div>"),a+="<br>"+this.getFootHtml(e,n+"tab1_foot"),a+="</div>",a+=s.htmlCls.divStr+n+"tab2'>","delphi"==e&&(a+=this.addGsizeSalt(n+"2")+"<br>"),a+="<span style='white-space:nowrap;font-weight:bold;'>Surface with max potential at: <select id='"+s.pre+n+"contour2'>";a+=this.getOptionHtml(["0.5","1","2","3","4","5","6","7","8","9","10"],2),a+="</select> kT/e(25.6mV at 298K)</span><br/><br/>",a+="<b>Surface</b>: <select id='"+s.pre+n+"surftype'>",a+="<option value='21'>Van der Waals</option>",a+="<option value='22' selected>Molecular Surface</option>",a+="<option value='23'>Solvent Accessible</option>",a+="</select>",a+="<span style='margin-left:20px'><b>Opacity</b>: <select id='"+s.pre+n+"surfop'>";return a+=this.getOptionHtml(["1.0","0.9","0.8","0.7","0.6","0.5","0.4","0.3","0.2","0.1"],0),a+="</select></span>",a+="<span style='margin-left:20px'><b>Wireframe</b>: <select id='"+s.pre+n+"surfwf'>",a+="<option value='yes'>Yes</option>",a+="<option value='no' selected>No</option>",a+="</select></span><br/>",a+="<br/>","delphi"==e?(a+=s.htmlCls.buttonStr+"reload_"+n+"file2' style='margin-top: 6px;'>Surface with Potential</button>",a+=s.htmlCls.buttonStr+n+"mapNo2' style='margin-left:30px;'>Remove Surface</button><br>"):"local"==e?(a+=s.htmlCls.divStr+n+"tab2_tabs' style='border:0px;'>",a+="<ul>",a+="<li><a href='#"+s.pre+n+"tab2_"+i+"'>PQR</a></li>",a+="<li><a href='#"+s.pre+n+"tab2_"+n+"'>Phi</a></li>",a+="<li><a href='#"+s.pre+n+"tab2_"+l+"'>Cube</a></li>",a+="</ul>",d="<span style='margin-left:30px'>"+s.htmlCls.buttonStr+n+"mapNo2'>Remove Surface</button></span></div>",a+=s.htmlCls.divStr+n+"tab2_"+i+"'>",a+=this.addGsizeSalt(i+"2")+"<br>",a+="<b>PQR File</b>: "+s.htmlCls.inputFileStr+"id='"+s.pre+i+"file2'> <br><br>"+s.htmlCls.buttonStr+"reload_"+i+"file2' style='margin-top: 6px;'>Surface with Potential</button>"+d,a+=s.htmlCls.divStr+n+"tab2_"+n+"'>",a+="<b>Phi File</b>: "+s.htmlCls.inputFileStr+"id='"+s.pre+n+"file2'> <br><br>"+s.htmlCls.buttonStr+"reload_"+n+"file2' style='margin-top: 6px;'>Surface with Potential</button>"+d,a+=s.htmlCls.divStr+n+"tab2_"+l+"'>",a+="<b>Cube File</b>: "+s.htmlCls.inputFileStr+"id='"+s.pre+l+"file2'> <br><br>"+s.htmlCls.buttonStr+"reload_"+l+"file2' style='margin-top: 6px;'>Surface with Potential</button>"+d,a+="</div>"):"url"==e&&(a+=s.htmlCls.divStr+n+"tab2_tabs' style='border:0px;'>",a+="<ul>",a+="<li><a href='#"+s.pre+n+"tab2_"+i+"2'>PQR</a></li>",a+="<li><a href='#"+s.pre+n+"tab2_"+n+"2'>Phi</a></li>",a+="<li><a href='#"+s.pre+n+"tab2_"+l+"2'>Cube</a></li>",a+="</ul>",d="<span style='margin-left:30px'>"+s.htmlCls.buttonStr+n+"mapNo2'>Remove Surface</button></span></div>",a+=s.htmlCls.divStr+n+"tab2_"+i+"2'>",a+=this.addGsizeSalt(i+"2")+"<br>",a+="<b>PQR URL</b> in the same host: "+s.htmlCls.inputTextStr+"id='"+s.pre+i+"file2'> <br><br>"+s.htmlCls.buttonStr+"reload_"+i+"file2' style='margin-top: 6px;'>Surface with Potential</button>"+d,a+=s.htmlCls.divStr+n+"tab2_"+n+"2'>",a+="<b>Phi URL</b> in the same host: "+s.htmlCls.inputTextStr+"id='"+s.pre+n+"file2'> <br><br>"+s.htmlCls.buttonStr+"reload_"+n+"file2' style='margin-top: 6px;'>Surface with Potential</button>"+d,a+=s.htmlCls.divStr+n+"tab2_"+l+"2'>",a+="<b>Cube URL</b> in the same host: "+s.htmlCls.inputTextStr+"id='"+s.pre+l+"file2'> <br><br>"+s.htmlCls.buttonStr+"reload_"+l+"file2' style='margin-top: 6px;'>Surface with Potential</button>"+d,a+="</div>"),a+="<br>"+this.getFootHtml(e,n+"tab2_foot"),a+="</div>",a+="</div>",a+="</div>",a}async exportPqr(e){let t=this.icn3dui,s=t.icn3d,i={},n={},l=t.hashUtilsCls.intHash(s.dAtoms,s.hAtoms);for(let e in l)s.atoms[e],s.ions.hasOwnProperty(e)?i[e]=1:n[e]=1;let r=e?"pdb":"pqr";if(t.cfg.cid){let l="",o=!e;l+=s.saveFileCls.getAtomPDB(n,o)+s.saveFileCls.getAtomPDB(i,o);let a=Object.keys(t.utilsCls.getHlStructures()).join(",");s.saveFileCls.saveFile(a+"_icn3d."+r,"text",[l])}else{if(t.utilsCls.isCalphaPhosOnly(t.hashUtilsCls.hash2Atoms(n,s.atoms)))return void alert("The potential will not be shown because the side chains are missing in the structure...");let l="",o=!0;l+=s.saveFileCls.getAtomPDB(n,void 0,void 0,void 0,void 0,void 0,o),l+=s.saveFileCls.getAtomPDB(i,!0,void 0,!0);let a=t.htmlCls.baseUrl+"delphi/delphi.cgi",d={pdb2pqr:l,pdbid:t.cfg.cid?t.cfg.cid:Object.keys(s.structures).toString()},c=await t.getAjaxPostPromise(a,d,!0,void 0,void 0,!0,"text");if(e){let e=c.split("\n"),s="";for(let i=0,n=e.length;i<n;++i){let n=e[i];if("ATOM  "==n.substr(0,6)||"HETATM"==n.substr(0,6)){let e,i=n.substr(12,4).trim();if("ATOM  "==n.substr(0,6))e=i.substr(0,1);else{let s=i.substr(0,2);e=t.parasCls.vdwRadii.hasOwnProperty(s)?s:i.substr(0,1)}s+=n.substr(0,54)+"                      "+e.padStart(2," ")+"\n"}else s+=n+"\n"}c=s}let h=Object.keys(t.utilsCls.getHlStructures()).join(",");s.saveFileCls.saveFile(h+"_icn3d_residues."+r,"text",[c])}}clickReload_pngimage(){let e=this.icn3dui;if(e.icn3d,e.bNode)return;let t=this;e.myEventCls.onIds("#"+e.pre+"reload_pngimage","click",(async function(s){let i=e.icn3d;s.preventDefault(),e.cfg.notebook||dialog.dialog("close"),e.cfg.notebook?i.resizeCanvasCls.closeDialogs():$(".ui-dialog-content").dialog("close");let n=$("#"+e.pre+"pngimage")[0].files;if(n[0]){t.fileSupport();let s=!0,i=!1,l=!0;await e.htmlCls.eventsCls.readFile(s,n,0,"",i,l)}else alert("Please select a file before clicking 'Load'")}))}async loadPng(e,t,s){let i=this.icn3dui,n=i.icn3d,l="Share Link: ",r=e.indexOf(l),o="Start of state file======\n",a=e.indexOf(o),d="",c="";if(-1==r&&-1==a)alert('Please load a PNG image saved by clicking the menu "File > Save File > iCn3D PNG Image"...');else if(-1!=r){let t=e.substr(r+12);i.htmlCls.clickMenuCls.setLogCmd("load iCn3D PNG image "+$("#"+i.pre+"pngimage").val(),!1),window.open(t,"_self")}else if(-1!=a){let i="Start of data file======\n",l=e.indexOf(i);n.bInputfile=-1!=l,n.bInputPNGWithData=n.bInputfile;let r=t?t.replace(/;/g,"\n"):"",o=e.indexOf("End of data file======\n");d=e.substr(l+i.length,o-l-i.length);let h="Start of type file======\n",p=e.indexOf(h),m=e.indexOf("End of type file======\n"),u=e.substr(p+h.length,m-p-h.length-1);n.InputfileType=u;let g=e.indexOf("End of state file======\n");c=e.substr(a+26,g-a-26),c=decodeURIComponent(c+"\n"+r),s&&("pdb"===u?(await n.pdbParserCls.loadPdbData(d),n.commands=[],n.optsHistory=[]):("mol2"===u?await n.mol2ParserCls.loadMol2Data(d):"sdf"===u?await n.sdfParserCls.loadSdfData(d):"xyz"===u?await n.xyzParserCls.loadXyzData(d):"mmcif"===u&&await n.mmcifParserCls.loadMmcifData(d),n.commands=[],n.optsHistory=[]),await n.loadScriptCls.loadScript(c,!0))}return{pdb:d,statefile:c}}fileSupport(){window.File&&window.FileReader&&window.FileList&&window.Blob||alert("The File APIs are not fully supported in this browser.")}getLinkColor(){let e="";return e+=", linkmap: {\n",e+='3: {"type": "peptidebond", "c":""},\n',e+='4: {"type": "ssbond", "c":"FFA500"},\n',e+='5: {"type": "ionic", "c":"0FF"},\n',e+='6: {"type": "ionicInside", "c":"FFF"},\n',e+='11: {"type": "contact", "c":"888"},\n',e+='12: {"type": "contactInside", "c":"FFF"},\n',e+='13: {"type": "hbond", "c":"0F0"},\n',e+='14: {"type": "hbondInside", "c":"FFF"},\n',e+='15: {"type": "clbond", "c":"006400"},\n',e+='17: {"type": "halogen", "c":"F0F"},\n',e+='18: {"type": "halogenInside", "c":"FFF"},\n',e+='19: {"type": "pication", "c":"F00"},\n',e+='20: {"type": "picationInside", "c":"FFF"},\n',e+='21: {"type": "pistacking", "c":"00F"},\n',e+='22: {"type": "pistackingInside", "c":"FFF"}\n',e+="}}\n",', linkmap: {\n3: {"type": "peptidebond", "c":""},\n4: {"type": "ssbond", "c":"FFA500"},\n5: {"type": "ionic", "c":"0FF"},\n6: {"type": "ionicInside", "c":"FFF"},\n11: {"type": "contact", "c":"888"},\n12: {"type": "contactInside", "c":"FFF"},\n13: {"type": "hbond", "c":"0F0"},\n14: {"type": "hbondInside", "c":"FFF"},\n15: {"type": "clbond", "c":"006400"},\n17: {"type": "halogen", "c":"F0F"},\n18: {"type": "halogenInside", "c":"FFF"},\n19: {"type": "pication", "c":"F00"},\n20: {"type": "picationInside", "c":"FFF"},\n21: {"type": "pistacking", "c":"00F"},\n22: {"type": "pistackingInside", "c":"FFF"}\n}}\n'}setCookieForThickness(){let e=this.icn3dui,t=e.icn3d;if(!e.bNode){let e=3650;this.setCookie("lineRadius",t.lineRadius,e),this.setCookie("coilWidth",t.coilWidth,e),this.setCookie("cylinderRadius",t.cylinderRadius,e),this.setCookie("crosslinkRadius",t.crosslinkRadius,e),this.setCookie("traceRadius",t.traceRadius,e),this.setCookie("dotSphereScale",t.dotSphereScale,e),this.setCookie("ribbonthickness",t.ribbonthickness,e),this.setCookie("helixSheetWidth",t.helixSheetWidth,e),this.setCookie("nucleicAcidWidth",t.nucleicAcidWidth,e)}}setLineThickness(e,t){let s=this.icn3dui,i=s.icn3d;if(i.bSetThickness=!0,"style"==e&&(t&&($("#"+s.pre+"shininess").val("40"),$("#"+s.pre+"light1").val("0.8"),$("#"+s.pre+"light2").val("0.4"),$("#"+s.pre+"light3").val("0.2"),$("#"+s.pre+"glycan").val("0"),$("#"+s.pre+"membrane").val("1"),$("#"+s.pre+"cmdwindow").val("0")),i.shininess=parseFloat($("#"+s.pre+"shininess").val()),i.light1=parseFloat($("#"+s.pre+"light1").val()),i.light2=parseFloat($("#"+s.pre+"light2").val()),i.light3=parseFloat($("#"+s.pre+"light3").val()),i.bGlycansCartoon=parseInt($("#"+s.pre+"glycan").val()),i.bMembrane=parseInt($("#"+s.pre+"membrane").val()),i.bCmdWindow=parseInt($("#"+s.pre+"cmdwindow").val())),t&&($("#"+s.pre+"linerad_"+e).val(.1),$("#"+s.pre+"coilrad_"+e).val(.3),$("#"+s.pre+"stickrad_"+e).val(.4),$("#"+s.pre+"crosslinkrad_"+e).val(.4),$("#"+s.pre+"tracerad_"+e).val(.4),$("#"+s.pre+"ballscale_"+e).val(.3),$("#"+s.pre+"ribbonthick_"+e).val(.2),$("#"+s.pre+"prtribbonwidth_"+e).val(1.3),$("#"+s.pre+"nucleotideribbonwidth_"+e).val(.8)),i.lineRadius=parseFloat($("#"+s.pre+"linerad_"+e).val()),i.coilWidth=parseFloat($("#"+s.pre+"coilrad_"+e).val()),i.cylinderRadius=parseFloat($("#"+s.pre+"stickrad_"+e).val()),i.crosslinkRadius=parseFloat($("#"+s.pre+"crosslinkrad_"+e).val()),i.traceRadius=parseFloat($("#"+s.pre+"tracerad_"+e).val()),i.dotSphereScale=parseFloat($("#"+s.pre+"ballscale_"+e).val()),i.ribbonthickness=parseFloat($("#"+s.pre+"ribbonthick_"+e).val()),i.helixSheetWidth=parseFloat($("#"+s.pre+"prtribbonwidth_"+e).val()),i.nucleicAcidWidth=parseFloat($("#"+s.pre+"nucleotideribbonwidth_"+e).val()),!s.bNode){let e=3650;this.setCookie("shininess",i.shininess,e),this.setCookie("light1",i.light1,e),this.setCookie("light2",i.light2,e),this.setCookie("light3",i.light3,e),this.setCookie("glycan",i.bGlycansCartoon,e),this.setCookie("membrane",i.bMembrane,e),this.setCookie("cmdwindow",i.bCmdWindow,e)}if(this.setCookieForThickness(),e=t){let e="reset thickness";s.htmlCls.clickMenuCls.setLogCmd(e,!0),i.bSetThickness=!1,i.threeDPrintCls.resetAfter3Dprint()}else s.htmlCls.clickMenuCls.setLogCmd("set thickness | linerad "+i.lineRadius+" | coilrad "+i.coilWidth+" | stickrad "+i.cylinderRadius+" | crosslinkrad "+i.crosslinkRadius+" | tracerad "+i.traceRadius+" | ribbonthick "+i.ribbonthickness+" | proteinwidth "+i.helixSheetWidth+" | nucleotidewidth "+i.nucleicAcidWidth+" | ballscale "+i.dotSphereScale,!0),s.htmlCls.clickMenuCls.setLogCmd("set glycan "+i.bGlycansCartoon,!0),s.htmlCls.clickMenuCls.setLogCmd("set membrane "+i.bMembrane,!0),s.htmlCls.clickMenuCls.setLogCmd("set cmdwindow "+i.bCmdWindow,!0);i.drawCls.draw()}setCookie(e,t,s){let i=new Date;i.setTime(i.getTime()+24*s*60*60*1e3);let n="expires="+i.toUTCString();document.cookie=e+"="+t+";"+n+";path=/"}updateSurfPara(e){let t=this.icn3dui,s=t.icn3d;s.phisurftype=$("#"+t.pre+e+"surftype").val(),s.phisurfop=$("#"+t.pre+e+"surfop").val(),s.phisurfwf=$("#"+t.pre+e+"surfwf").val()}exportPdb(){let e=this.icn3dui,t=e.icn3d,s="",i=e.hashUtilsCls.intHash(t.dAtoms,t.hAtoms);if(s+=t.saveFileCls.getAtomPDB(i),!e.bNode){let i=Object.keys(e.utilsCls.getHlStructures()).join(",");t.saveFileCls.saveFile(i+"_icn3d.pdb","text",[s])}return s}exportSecondary(){let e=this.icn3dui,t=e.icn3d,s="",i=e.hashUtilsCls.intHash(t.dAtoms,t.hAtoms);if(s+=t.saveFileCls.getSecondary(i),!e.bNode){let i=Object.keys(e.utilsCls.getHlStructures()).join(",");t.saveFileCls.saveFile(i+"_icn3d_ss.txt","text",[s])}return s}}class g{constructor(e){let t=e;this.icn3dui=e,this.cfg=this.icn3dui.cfg,this.opts={},this.opts.background="black",this.allMenus={},this.allMenusSel={},this.simpleMenus={},this.shownMenus={},this.WIDTH=400,this.HEIGHT=400,this.RESIDUE_WIDTH=10,t.utilsCls.isMobile()||this.cfg.mobilemenu?this.MENU_HEIGHT=0:this.MENU_HEIGHT=40,this.LOG_HEIGHT=65,this.MENU_WIDTH=750,this.LESSWIDTH=20,this.LESSWIDTH_RESIZE=20,this.LESSHEIGHT=20,this.width2d=200,this.CMD_HEIGHT=.8*this.LOG_HEIGHT,this.EXTRAHEIGHT=this.MENU_HEIGHT+this.CMD_HEIGHT,null!=this.cfg.showmenu&&0==this.cfg.showmenu&&(this.EXTRAHEIGHT-=this.MENU_HEIGHT),null!=this.cfg.showcommand&&0==this.cfg.showcommand&&(this.EXTRAHEIGHT-=this.CMD_HEIGHT),this.GREY8="#AAAAAA",this.GREYB="#CCCCCC",this.GREYC="#DDDDDD",this.GREYD="#EEEEEE",this.ORANGE="#FFA500",this.themecolor="blue",this.defaultValue=1,this.ssValue=3,this.coilValue=3,this.contactValue=11,this.contactInsideValue=12,this.hbondValue=13,this.hbondInsideValue=14,this.ssbondValue=4,this.ionicValue=5,this.ionicInsideValue=6,this.clbondValue=15,this.halogenValue=17,this.halogenInsideValue=18,this.picationValue=19,this.picationInsideValue=20,this.pistackingValue=21,this.pistackingInsideValue=22,this.contactColor="888",this.contactInsideColor="FFF",this.hbondColor="0F0",this.hbondInsideColor="FFF",this.ssbondColor="FFA500",this.ionicColor="0FF",this.ionicInsideColor="FFF",this.clbondColor="006400",this.halogenColor="F0F",this.halogenInsideColor="FFF",this.picationColor="F00",this.picationInsideColor="FFF",this.pistackingColor="00F",this.pistackingInsideColor="FFF",this.hideedges=1,this.force=4,this.simulation=void 0,this.baseUrl=window&&window.location&&"structure.ncbi.nlm.nih.gov"==window.location.hostname?"https://structure.ncbi.nlm.nih.gov/Structure/":"https://www.ncbi.nlm.nih.gov/Structure/",this.tmalignUrl=this.baseUrl+"tmalign/tmalign.cgi",this.divStr="<div id='"+this.icn3dui.pre,this.divNowrapStr="<div style='white-space:nowrap'>",this.spanNowrapStr="<span style='white-space:nowrap'>",this.inputTextStr="<input type='text' ",this.inputFileStr="<input type='file' ",this.inputRadioStr="<input type='radio' ",this.inputCheckStr="<input type='checkbox' ",this.optionStr="<option value=",this.buttonStr="<button id='"+this.icn3dui.pre,this.postfix="2",this.space2="&nbsp;&nbsp;",this.space3=this.space2+"&nbsp;",this.space4=this.space2+this.space2,this.wifiStr="",this.licenseStr="",this.closeAc={collapsible:!0,active:!1},this.clickMenuCls=new a(this.icn3dui),this.setMenuCls=new d(this.icn3dui),this.dialogCls=new c(this.icn3dui),this.setDialogCls=new h(this.icn3dui),this.eventsCls=new p(this.icn3dui),this.alignSeqCls=new m(this.icn3dui),this.setHtmlCls=new u(this.icn3dui)}}class f extends THREE.Loader{constructor(e){super(e),this.dracoLoader=null,this.ktx2Loader=null,this.meshoptDecoder=null,this.pluginCallbacks=[],this.register((function(e){return new _(e)})),this.register((function(e){return new O(e)})),this.register((function(e){return new R(e)})),this.register((function(e){return new w(e)})),this.register((function(e){return new S(e)})),this.register((function(e){return new A(e)})),this.register((function(e){return new x(e)})),this.register((function(e){return new k(e)})),this.register((function(e){return new y(e)})),this.register((function(e){return new I(e)}))}load(e,t,s,i){const n=this;let l;l=""!==this.resourcePath?this.resourcePath:""!==this.path?this.path:THREE.LoaderUtils.extractUrlBase(e),this.manager.itemStart(e);const r=function(t){i?i(t):console.error(t),n.manager.itemError(e),n.manager.itemEnd(e)},o=new THREE.FileLoader(this.manager);o.setPath(this.path),o.setResponseType("arraybuffer"),o.setRequestHeader(this.requestHeader),o.setWithCredentials(this.withCredentials),o.load(e,(function(s){try{n.parse(s,l,(function(s){t(s),n.manager.itemEnd(e)}),r)}catch(e){r(e)}}),s,r)}setDRACOLoader(e){return this.dracoLoader=e,this}setDDSLoader(){throw new Error('THREE.GLTFLoader: "MSFT_texture_dds" no longer supported. Please update to "KHR_texture_basisu".')}setKTX2Loader(e){return this.ktx2Loader=e,this}setMeshoptDecoder(e){return this.meshoptDecoder=e,this}register(e){return-1===this.pluginCallbacks.indexOf(e)&&this.pluginCallbacks.push(e),this}unregister(e){return-1!==this.pluginCallbacks.indexOf(e)&&this.pluginCallbacks.splice(this.pluginCallbacks.indexOf(e),1),this}parse(e,t,s,i){let n;const l={},r={};if("string"==typeof e)n=e;else{if(THREE.LoaderUtils.decodeText(new Uint8Array(e,0,4))===E){try{l[b.KHR_BINARY_GLTF]=new D(e)}catch(e){return void(i&&i(e))}n=l[b.KHR_BINARY_GLTF].content}else n=THREE.LoaderUtils.decodeText(new Uint8Array(e))}const o=JSON.parse(n);if(void 0===o.asset||o.asset.version[0]<2)return void(i&&i(new Error("THREE.GLTFLoader: Unsupported asset. glTF versions >=2.0 are supported.")));const a=new pe(o,{path:t||this.resourcePath||"",crossOrigin:this.crossOrigin,requestHeader:this.requestHeader,manager:this.manager,ktx2Loader:this.ktx2Loader,meshoptDecoder:this.meshoptDecoder});a.fileLoader.setRequestHeader(this.requestHeader);for(let e=0;e<this.pluginCallbacks.length;e++){const t=this.pluginCallbacks[e](a);r[t.name]=t,l[t.name]=!0}if(o.extensionsUsed)for(let e=0;e<o.extensionsUsed.length;++e){const t=o.extensionsUsed[e],s=o.extensionsRequired||[];switch(t){case b.KHR_MATERIALS_UNLIT:l[t]=new v;break;case b.KHR_MATERIALS_PBR_SPECULAR_GLOSSINESS:l[t]=new L;break;case b.KHR_DRACO_MESH_COMPRESSION:l[t]=new M(o,this.dracoLoader);break;case b.KHR_TEXTURE_TRANSFORM:l[t]=new F;break;case b.KHR_MESH_QUANTIZATION:l[t]=new N;break;default:s.indexOf(t)>=0&&void 0===r[t]&&console.warn('THREE.GLTFLoader: Unknown extension "'+t+'".')}}a.setExtensions(l),a.setPlugins(r),a.parse(s,i)}parseAsync(e,t){const s=this;return new Promise((function(i,n){s.parse(e,t,i,n)}))}}function C(){let e={};return{get:function(t){return e[t]},add:function(t,s){e[t]=s},remove:function(t){delete e[t]},removeAll:function(){e={}}}}const b={KHR_BINARY_GLTF:"KHR_binary_glTF",KHR_DRACO_MESH_COMPRESSION:"KHR_draco_mesh_compression",KHR_LIGHTS_PUNCTUAL:"KHR_lights_punctual",KHR_MATERIALS_CLEARCOAT:"KHR_materials_clearcoat",KHR_MATERIALS_IOR:"KHR_materials_ior",KHR_MATERIALS_PBR_SPECULAR_GLOSSINESS:"KHR_materials_pbrSpecularGlossiness",KHR_MATERIALS_SHEEN:"KHR_materials_sheen",KHR_MATERIALS_SPECULAR:"KHR_materials_specular",KHR_MATERIALS_TRANSMISSION:"KHR_materials_transmission",KHR_MATERIALS_UNLIT:"KHR_materials_unlit",KHR_MATERIALS_VOLUME:"KHR_materials_volume",KHR_TEXTURE_BASISU:"KHR_texture_basisu",KHR_TEXTURE_TRANSFORM:"KHR_texture_transform",KHR_MESH_QUANTIZATION:"KHR_mesh_quantization",EXT_TEXTURE_WEBP:"EXT_texture_webp",EXT_MESHOPT_COMPRESSION:"EXT_meshopt_compression"};class y{constructor(e){this.parser=e,this.name=b.KHR_LIGHTS_PUNCTUAL,this.cache={refs:{},uses:{}}}_markDefs(){const e=this.parser,t=this.parser.json.nodes||[];for(let s=0,i=t.length;s<i;s++){const i=t[s];i.extensions&&i.extensions[this.name]&&void 0!==i.extensions[this.name].light&&e._addNodeRef(this.cache,i.extensions[this.name].light)}}_loadLight(e){const t=this.parser,s="light:"+e;let i=t.cache.get(s);if(i)return i;const n=t.json,l=((n.extensions&&n.extensions[this.name]||{}).lights||[])[e];let r;const o=new Color(16777215);void 0!==l.color&&o.fromArray(l.color);const a=void 0!==l.range?l.range:0;switch(l.type){case"directional":r=new DirectionalLight(o),r.target.position.set(0,0,-1),r.add(r.target);break;case"point":r=new PointLight(o),r.distance=a;break;case"spot":r=new SpotLight(o),r.distance=a,l.spot=l.spot||{},l.spot.innerConeAngle=void 0!==l.spot.innerConeAngle?l.spot.innerConeAngle:0,l.spot.outerConeAngle=void 0!==l.spot.outerConeAngle?l.spot.outerConeAngle:Math.PI/4,r.angle=l.spot.outerConeAngle,r.penumbra=1-l.spot.innerConeAngle/l.spot.outerConeAngle,r.target.position.set(0,0,-1),r.add(r.target);break;default:throw new Error("THREE.GLTFLoader: Unexpected light type: "+l.type)}return r.position.set(0,0,0),r.decay=2,void 0!==l.intensity&&(r.intensity=l.intensity),r.name=t.createUniqueName(l.name||"light_"+e),i=Promise.resolve(r),t.cache.add(s,i),i}createNodeAttachment(e){const t=this,s=this.parser,i=s.json.nodes[e],n=(i.extensions&&i.extensions[this.name]||{}).light;return void 0===n?null:this._loadLight(n).then((function(e){return s._getNodeRef(t.cache,n,e)}))}}class v{constructor(){this.name=b.KHR_MATERIALS_UNLIT}getMaterialType(){return MeshBasicMaterial}extendParams(e,t,s){const i=[];e.color=new Color(1,1,1),e.opacity=1;const n=t.pbrMetallicRoughness;if(n){if(Array.isArray(n.baseColorFactor)){const t=n.baseColorFactor;e.color.fromArray(t),e.opacity=t[3]}void 0!==n.baseColorTexture&&i.push(s.assignTexture(e,"map",n.baseColorTexture,sRGBEncoding))}return Promise.all(i)}}class _{constructor(e){this.parser=e,this.name=b.KHR_MATERIALS_CLEARCOAT}getMaterialType(e){const t=this.parser.json.materials[e];return t.extensions&&t.extensions[this.name]?MeshPhysicalMaterial:null}extendMaterialParams(e,t){const s=this.parser,i=s.json.materials[e];if(!i.extensions||!i.extensions[this.name])return Promise.resolve();const n=[],l=i.extensions[this.name];if(void 0!==l.clearcoatFactor&&(t.clearcoat=l.clearcoatFactor),void 0!==l.clearcoatTexture&&n.push(s.assignTexture(t,"clearcoatMap",l.clearcoatTexture)),void 0!==l.clearcoatRoughnessFactor&&(t.clearcoatRoughness=l.clearcoatRoughnessFactor),void 0!==l.clearcoatRoughnessTexture&&n.push(s.assignTexture(t,"clearcoatRoughnessMap",l.clearcoatRoughnessTexture)),void 0!==l.clearcoatNormalTexture&&(n.push(s.assignTexture(t,"clearcoatNormalMap",l.clearcoatNormalTexture)),void 0!==l.clearcoatNormalTexture.scale)){const e=l.clearcoatNormalTexture.scale;t.clearcoatNormalScale=new Vector2(e,e)}return Promise.all(n)}}class w{constructor(e){this.parser=e,this.name=b.KHR_MATERIALS_SHEEN}getMaterialType(e){const t=this.parser.json.materials[e];return t.extensions&&t.extensions[this.name]?MeshPhysicalMaterial:null}extendMaterialParams(e,t){const s=this.parser,i=s.json.materials[e];if(!i.extensions||!i.extensions[this.name])return Promise.resolve();const n=[];t.sheenColor=new Color(0,0,0),t.sheenRoughness=0,t.sheen=1;const l=i.extensions[this.name];return void 0!==l.sheenColorFactor&&t.sheenColor.fromArray(l.sheenColorFactor),void 0!==l.sheenRoughnessFactor&&(t.sheenRoughness=l.sheenRoughnessFactor),void 0!==l.sheenColorTexture&&n.push(s.assignTexture(t,"sheenColorMap",l.sheenColorTexture,sRGBEncoding)),void 0!==l.sheenRoughnessTexture&&n.push(s.assignTexture(t,"sheenRoughnessMap",l.sheenRoughnessTexture)),Promise.all(n)}}class S{constructor(e){this.parser=e,this.name=b.KHR_MATERIALS_TRANSMISSION}getMaterialType(e){const t=this.parser.json.materials[e];return t.extensions&&t.extensions[this.name]?MeshPhysicalMaterial:null}extendMaterialParams(e,t){const s=this.parser,i=s.json.materials[e];if(!i.extensions||!i.extensions[this.name])return Promise.resolve();const n=[],l=i.extensions[this.name];return void 0!==l.transmissionFactor&&(t.transmission=l.transmissionFactor),void 0!==l.transmissionTexture&&n.push(s.assignTexture(t,"transmissionMap",l.transmissionTexture)),Promise.all(n)}}class A{constructor(e){this.parser=e,this.name=b.KHR_MATERIALS_VOLUME}getMaterialType(e){const t=this.parser.json.materials[e];return t.extensions&&t.extensions[this.name]?MeshPhysicalMaterial:null}extendMaterialParams(e,t){const s=this.parser,i=s.json.materials[e];if(!i.extensions||!i.extensions[this.name])return Promise.resolve();const n=[],l=i.extensions[this.name];t.thickness=void 0!==l.thicknessFactor?l.thicknessFactor:0,void 0!==l.thicknessTexture&&n.push(s.assignTexture(t,"thicknessMap",l.thicknessTexture)),t.attenuationDistance=l.attenuationDistance||0;const r=l.attenuationColor||[1,1,1];return t.attenuationColor=new Color(r[0],r[1],r[2]),Promise.all(n)}}class x{constructor(e){this.parser=e,this.name=b.KHR_MATERIALS_IOR}getMaterialType(e){const t=this.parser.json.materials[e];return t.extensions&&t.extensions[this.name]?MeshPhysicalMaterial:null}extendMaterialParams(e,t){const s=this.parser.json.materials[e];if(!s.extensions||!s.extensions[this.name])return Promise.resolve();const i=s.extensions[this.name];return t.ior=void 0!==i.ior?i.ior:1.5,Promise.resolve()}}class k{constructor(e){this.parser=e,this.name=b.KHR_MATERIALS_SPECULAR}getMaterialType(e){const t=this.parser.json.materials[e];return t.extensions&&t.extensions[this.name]?MeshPhysicalMaterial:null}extendMaterialParams(e,t){const s=this.parser,i=s.json.materials[e];if(!i.extensions||!i.extensions[this.name])return Promise.resolve();const n=[],l=i.extensions[this.name];t.specularIntensity=void 0!==l.specularFactor?l.specularFactor:1,void 0!==l.specularTexture&&n.push(s.assignTexture(t,"specularIntensityMap",l.specularTexture));const r=l.specularColorFactor||[1,1,1];return t.specularColor=new Color(r[0],r[1],r[2]),void 0!==l.specularColorTexture&&n.push(s.assignTexture(t,"specularColorMap",l.specularColorTexture,sRGBEncoding)),Promise.all(n)}}class O{constructor(e){this.parser=e,this.name=b.KHR_TEXTURE_BASISU}loadTexture(e){const t=this.parser,s=t.json,i=s.textures[e];if(!i.extensions||!i.extensions[this.name])return null;const n=i.extensions[this.name],l=t.options.ktx2Loader;if(!l){if(s.extensionsRequired&&s.extensionsRequired.indexOf(this.name)>=0)throw new Error("THREE.GLTFLoader: setKTX2Loader must be called before loading KTX2 textures");return null}return t.loadTextureImage(e,n.source,l)}}class R{constructor(e){this.parser=e,this.name=b.EXT_TEXTURE_WEBP,this.isSupported=null}loadTexture(e){const t=this.name,s=this.parser,i=s.json,n=i.textures[e];if(!n.extensions||!n.extensions[t])return null;const l=n.extensions[t],r=i.images[l.source];let o=s.textureLoader;if(r.uri){const e=s.options.manager.getHandler(r.uri);null!==e&&(o=e)}return this.detectSupport().then((function(n){if(n)return s.loadTextureImage(e,l.source,o);if(i.extensionsRequired&&i.extensionsRequired.indexOf(t)>=0)throw new Error("THREE.GLTFLoader: WebP required by asset but unsupported.");return s.loadTexture(e)}))}detectSupport(){return this.isSupported||(this.isSupported=new Promise((function(e){const t=new Image;t.src="data:image/webp;base64,UklGRiIAAABXRUJQVlA4IBYAAAAwAQCdASoBAAEADsD+JaQAA3AAAAAA",t.onload=t.onerror=function(){e(1===t.height)}}))),this.isSupported}}class I{constructor(e){this.name=b.EXT_MESHOPT_COMPRESSION,this.parser=e}loadBufferView(e){const t=this.parser.json,s=t.bufferViews[e];if(s.extensions&&s.extensions[this.name]){const e=s.extensions[this.name],i=this.parser.getDependency("buffer",e.buffer),n=this.parser.options.meshoptDecoder;if(!n||!n.supported){if(t.extensionsRequired&&t.extensionsRequired.indexOf(this.name)>=0)throw new Error("THREE.GLTFLoader: setMeshoptDecoder must be called before loading compressed files");return null}return Promise.all([i,n.ready]).then((function(t){const s=e.byteOffset||0,i=e.byteLength||0,l=e.count,r=e.byteStride,o=new ArrayBuffer(l*r),a=new Uint8Array(t[0],s,i);return n.decodeGltfBuffer(new Uint8Array(o),l,r,a,e.mode,e.filter),o}))}return null}}const E="glTF",T=1313821514,P=5130562;class D{constructor(e){this.name=b.KHR_BINARY_GLTF,this.content=null,this.body=null;const t=new DataView(e,0,12);if(this.header={magic:THREE.LoaderUtils.decodeText(new Uint8Array(e.slice(0,4))),version:t.getUint32(4,!0),length:t.getUint32(8,!0)},this.header.magic!==E)throw new Error("THREE.GLTFLoader: Unsupported glTF-Binary header.");if(this.header.version<2)throw new Error("THREE.GLTFLoader: Legacy binary file detected.");const s=this.header.length-12,i=new DataView(e,12);let n=0;for(;n<s;){const t=i.getUint32(n,!0);n+=4;const s=i.getUint32(n,!0);if(n+=4,s===T){const s=new Uint8Array(e,12+n,t);this.content=THREE.LoaderUtils.decodeText(s)}else if(s===P){const s=12+n;this.body=e.slice(s,s+t)}n+=t}if(null===this.content)throw new Error("THREE.GLTFLoader: JSON content not found.")}}class M{constructor(e,t){if(!t)throw new Error("THREE.GLTFLoader: No DRACOLoader instance provided.");this.name=b.KHR_DRACO_MESH_COMPRESSION,this.json=e,this.dracoLoader=t,this.dracoLoader.preload()}decodePrimitive(e,t){const s=this.json,i=this.dracoLoader,n=e.extensions[this.name].bufferView,l=e.extensions[this.name].attributes,r={},o={},a={};for(const e in l){const t=ee[e]||e.toLowerCase();r[t]=l[e]}for(const t in e.attributes){const i=ee[t]||t.toLowerCase();if(void 0!==l[t]){const n=s.accessors[e.attributes[t]],l=K[n.componentType];a[i]=l,o[i]=!0===n.normalized}}return t.getDependency("bufferView",n).then((function(e){return new Promise((function(t){i.decodeDracoFile(e,(function(e){for(const t in e.attributes){const s=e.attributes[t],i=o[t];void 0!==i&&(s.normalized=i)}t(e)}),r,a)}))}))}}class F{constructor(){this.name=b.KHR_TEXTURE_TRANSFORM}extendTexture(e,t){return void 0!==t.texCoord&&console.warn('THREE.GLTFLoader: Custom UV sets in "'+this.name+'" extension not yet supported.'),void 0===t.offset&&void 0===t.rotation&&void 0===t.scale||(e=e.clone(),void 0!==t.offset&&e.offset.fromArray(t.offset),void 0!==t.rotation&&(e.rotation=t.rotation),void 0!==t.scale&&e.repeat.fromArray(t.scale),e.needsUpdate=!0),e}}class H extends THREE.MeshStandardMaterial{constructor(e){super(),this.isGLTFSpecularGlossinessMaterial=!0;const t=["#ifdef USE_SPECULARMAP","   uniform sampler2D specularMap;","#endif"].join("\n"),s=["#ifdef USE_GLOSSINESSMAP","   uniform sampler2D glossinessMap;","#endif"].join("\n"),i=["vec3 specularFactor = specular;","#ifdef USE_SPECULARMAP","   vec4 texelSpecular = texture2D( specularMap, vUv );","   // reads channel RGB, compatible with a glTF Specular-Glossiness (RGBA) texture","   specularFactor *= texelSpecular.rgb;","#endif"].join("\n"),n=["float glossinessFactor = glossiness;","#ifdef USE_GLOSSINESSMAP","   vec4 texelGlossiness = texture2D( glossinessMap, vUv );","   // reads channel A, compatible with a glTF Specular-Glossiness (RGBA) texture","   glossinessFactor *= texelGlossiness.a;","#endif"].join("\n"),l=["PhysicalMaterial material;","material.diffuseColor = diffuseColor.rgb * ( 1. - max( specularFactor.r, max( specularFactor.g, specularFactor.b ) ) );","vec3 dxy = max( abs( dFdx( geometryNormal ) ), abs( dFdy( geometryNormal ) ) );","float geometryRoughness = max( max( dxy.x, dxy.y ), dxy.z );","material.roughness = max( 1.0 - glossinessFactor, 0.0525 ); // 0.0525 corresponds to the base mip of a 256 cubemap.","material.roughness += geometryRoughness;","material.roughness = min( material.roughness, 1.0 );","material.specularColor = specularFactor;"].join("\n"),r={specular:{value:(new Color).setHex(16777215)},glossiness:{value:1},specularMap:{value:null},glossinessMap:{value:null}};this._extraUniforms=r,this.onBeforeCompile=function(e){for(const t in r)e.uniforms[t]=r[t];e.fragmentShader=e.fragmentShader.replace("uniform float roughness;","uniform vec3 specular;").replace("uniform float metalness;","uniform float glossiness;").replace("#include <roughnessmap_pars_fragment>",t).replace("#include <metalnessmap_pars_fragment>",s).replace("#include <roughnessmap_fragment>",i).replace("#include <metalnessmap_fragment>",n).replace("#include <lights_physical_fragment>",l)},Object.defineProperties(this,{specular:{get:function(){return r.specular.value},set:function(e){r.specular.value=e}},specularMap:{get:function(){return r.specularMap.value},set:function(e){r.specularMap.value=e,e?this.defines.USE_SPECULARMAP="":delete this.defines.USE_SPECULARMAP}},glossiness:{get:function(){return r.glossiness.value},set:function(e){r.glossiness.value=e}},glossinessMap:{get:function(){return r.glossinessMap.value},set:function(e){r.glossinessMap.value=e,e?(this.defines.USE_GLOSSINESSMAP="",this.defines.USE_UV=""):(delete this.defines.USE_GLOSSINESSMAP,delete this.defines.USE_UV)}}}),delete this.metalness,delete this.roughness,delete this.metalnessMap,delete this.roughnessMap,this.setValues(e)}copy(e){return super.copy(e),this.specularMap=e.specularMap,this.specular.copy(e.specular),this.glossinessMap=e.glossinessMap,this.glossiness=e.glossiness,delete this.metalness,delete this.roughness,delete this.metalnessMap,delete this.roughnessMap,this}}class L{constructor(){this.name=b.KHR_MATERIALS_PBR_SPECULAR_GLOSSINESS,this.specularGlossinessParams=["color","map","lightMap","lightMapIntensity","aoMap","aoMapIntensity","emissive","emissiveIntensity","emissiveMap","bumpMap","bumpScale","normalMap","normalMapType","displacementMap","displacementScale","displacementBias","specularMap","specular","glossinessMap","glossiness","alphaMap","envMap","envMapIntensity"]}getMaterialType(){return H}extendParams(e,t,s){const i=t.extensions[this.name];e.color=new Color(1,1,1),e.opacity=1;const n=[];if(Array.isArray(i.diffuseFactor)){const t=i.diffuseFactor;e.color.fromArray(t),e.opacity=t[3]}if(void 0!==i.diffuseTexture&&n.push(s.assignTexture(e,"map",i.diffuseTexture,sRGBEncoding)),e.emissive=new Color(0,0,0),e.glossiness=void 0!==i.glossinessFactor?i.glossinessFactor:1,e.specular=new Color(1,1,1),Array.isArray(i.specularFactor)&&e.specular.fromArray(i.specularFactor),void 0!==i.specularGlossinessTexture){const t=i.specularGlossinessTexture;n.push(s.assignTexture(e,"glossinessMap",t)),n.push(s.assignTexture(e,"specularMap",t,sRGBEncoding))}return Promise.all(n)}createMaterial(e){const t=new H(e);return t.fog=!0,t.color=e.color,t.map=void 0===e.map?null:e.map,t.lightMap=null,t.lightMapIntensity=1,t.aoMap=void 0===e.aoMap?null:e.aoMap,t.aoMapIntensity=1,t.emissive=e.emissive,t.emissiveIntensity=1,t.emissiveMap=void 0===e.emissiveMap?null:e.emissiveMap,t.bumpMap=void 0===e.bumpMap?null:e.bumpMap,t.bumpScale=1,t.normalMap=void 0===e.normalMap?null:e.normalMap,t.normalMapType=TangentSpaceNormalMap,e.normalScale&&(t.normalScale=e.normalScale),t.displacementMap=null,t.displacementScale=1,t.displacementBias=0,t.specularMap=void 0===e.specularMap?null:e.specularMap,t.specular=e.specular,t.glossinessMap=void 0===e.glossinessMap?null:e.glossinessMap,t.glossiness=e.glossiness,t.alphaMap=null,t.envMap=void 0===e.envMap?null:e.envMap,t.envMapIntensity=1,t}}class N{constructor(){this.name=b.KHR_MESH_QUANTIZATION}}class q extends THREE.Interpolant{constructor(e,t,s,i){super(e,t,s,i)}copySampleValue_(e){const t=this.resultBuffer,s=this.sampleValues,i=this.valueSize,n=e*i*3+i;for(let e=0;e!==i;e++)t[e]=s[n+e];return t}}q.prototype.beforeStart_=q.prototype.copySampleValue_,q.prototype.afterEnd_=q.prototype.copySampleValue_,q.prototype.interpolate_=function(e,t,s,i){const n=this.resultBuffer,l=this.sampleValues,r=this.valueSize,o=2*r,a=3*r,d=i-t,c=(s-t)/d,h=c*c,p=h*c,m=e*a,u=m-a,g=-2*p+3*h,f=p-h,C=1-g,b=f-h+c;for(let e=0;e!==r;e++){const t=l[u+e+r],s=l[u+e+o]*d,i=l[m+e+r],a=l[m+e]*d;n[e]=C*t+b*s+g*i+f*a}return n};const U=new THREE.Quaternion;class B extends q{interpolate_(e,t,s,i){const n=super.interpolate_(e,t,s,i);return U.fromArray(n).normalize().toArray(n),n}}const j=0,z=1,G=2,V=3,W=4,Y=5,X=6,K={5120:Int8Array,5121:Uint8Array,5122:Int16Array,5123:Uint16Array,5125:Uint32Array,5126:Float32Array},J={9728:THREE.NearestFilter,9729:THREE.LinearFilter,9984:THREE.NearestMipmapNearestFilter,9985:THREE.LinearMipmapNearestFilter,9986:THREE.NearestMipmapLinearFilter,9987:THREE.LinearMipmapLinearFilter},Z={33071:THREE.ClampToEdgeWrapping,33648:THREE.MirroredRepeatWrapping,10497:THREE.RepeatWrapping},Q={SCALAR:1,VEC2:2,VEC3:3,VEC4:4,MAT2:4,MAT3:9,MAT4:16},ee={POSITION:"position",NORMAL:"normal",TANGENT:"tangent",TEXCOORD_0:"uv",TEXCOORD_1:"uv2",COLOR_0:"color",WEIGHTS_0:"skinWeight",JOINTS_0:"skinIndex"},te={scale:"scale",translation:"position",rotation:"quaternion",weights:"morphTargetInfluences"},se={CUBICSPLINE:void 0,LINEAR:THREE.InterpolateLinear,STEP:THREE.InterpolateDiscrete},ie="OPAQUE",ne="MASK",le="BLEND";function re(e,t,s){for(const i in s.extensions)void 0===e[i]&&(t.userData.gltfExtensions=t.userData.gltfExtensions||{},t.userData.gltfExtensions[i]=s.extensions[i])}function oe(e,t){void 0!==t.extras&&("object"==typeof t.extras?Object.assign(e.userData,t.extras):console.warn("THREE.GLTFLoader: Ignoring primitive type .extras, "+t.extras))}function ae(e,t){if(e.updateMorphTargets(),void 0!==t.weights)for(let s=0,i=t.weights.length;s<i;s++)e.morphTargetInfluences[s]=t.weights[s];if(t.extras&&Array.isArray(t.extras.targetNames)){const s=t.extras.targetNames;if(e.morphTargetInfluences.length===s.length){e.morphTargetDictionary={};for(let t=0,i=s.length;t<i;t++)e.morphTargetDictionary[s[t]]=t}else console.warn("THREE.GLTFLoader: Invalid extras.targetNames length. Ignoring names.")}}function de(e){const t=e.extensions&&e.extensions[b.KHR_DRACO_MESH_COMPRESSION];let s;return s=t?"draco:"+t.bufferView+":"+t.indices+":"+ce(t.attributes):e.indices+":"+ce(e.attributes)+":"+e.mode,s}function ce(e){let t="";const s=Object.keys(e).sort();for(let i=0,n=s.length;i<n;i++)t+=s[i]+":"+e[s[i]]+";";return t}function he(e){switch(e){case Int8Array:return 1/127;case Uint8Array:return 1/255;case Int16Array:return 1/32767;case Uint16Array:return 1/65535;default:throw new Error("THREE.GLTFLoader: Unsupported normalized accessor component type.")}}class pe{constructor(e={},t={}){this.json=e,this.extensions={},this.plugins={},this.options=t,this.cache=new C,this.associations=new Map,this.primitiveCache={},this.meshCache={refs:{},uses:{}},this.cameraCache={refs:{},uses:{}},this.lightCache={refs:{},uses:{}},this.sourceCache={},this.textureCache={},this.nodeNamesUsed={},"undefined"!=typeof createImageBitmap&&!1===/^((?!chrome|android).)*safari/i.test(navigator.userAgent)?this.textureLoader=new ImageBitmapLoader(this.options.manager):this.textureLoader=new TextureLoader(this.options.manager),this.textureLoader.setCrossOrigin(this.options.crossOrigin),this.textureLoader.setRequestHeader(this.options.requestHeader),this.fileLoader=new THREE.FileLoader(this.options.manager),this.fileLoader.setResponseType("arraybuffer"),"use-credentials"===this.options.crossOrigin&&this.fileLoader.setWithCredentials(!0)}setExtensions(e){this.extensions=e}setPlugins(e){this.plugins=e}parse(e,t){const s=this,i=this.json,n=this.extensions;this.cache.removeAll(),this._invokeAll((function(e){return e._markDefs&&e._markDefs()})),Promise.all(this._invokeAll((function(e){return e.beforeRoot&&e.beforeRoot()}))).then((function(){return Promise.all([s.getDependencies("scene"),s.getDependencies("animation"),s.getDependencies("camera")])})).then((function(t){const l={scene:t[0][i.scene||0],scenes:t[0],animations:t[1],cameras:t[2],asset:i.asset,parser:s,userData:{}};re(n,l,i),oe(l,i),Promise.all(s._invokeAll((function(e){return e.afterRoot&&e.afterRoot(l)}))).then((function(){e(l)}))})).catch(t)}_markDefs(){const e=this.json.nodes||[],t=this.json.skins||[],s=this.json.meshes||[];for(let s=0,i=t.length;s<i;s++){const i=t[s].joints;for(let t=0,s=i.length;t<s;t++)e[i[t]].isBone=!0}for(let t=0,i=e.length;t<i;t++){const i=e[t];void 0!==i.mesh&&(this._addNodeRef(this.meshCache,i.mesh),void 0!==i.skin&&(s[i.mesh].isSkinnedMesh=!0)),void 0!==i.camera&&this._addNodeRef(this.cameraCache,i.camera)}}_addNodeRef(e,t){void 0!==t&&(void 0===e.refs[t]&&(e.refs[t]=e.uses[t]=0),e.refs[t]++)}_getNodeRef(e,t,s){if(e.refs[t]<=1)return s;const i=s.clone(),n=(e,t)=>{const s=this.associations.get(e);null!=s&&this.associations.set(t,s);for(const[s,i]of e.children.entries())n(i,t.children[s])};return n(s,i),i.name+="_instance_"+e.uses[t]++,i}_invokeOne(e){const t=Object.values(this.plugins);t.push(this);for(let s=0;s<t.length;s++){const i=e(t[s]);if(i)return i}return null}_invokeAll(e){const t=Object.values(this.plugins);t.unshift(this);const s=[];for(let i=0;i<t.length;i++){const n=e(t[i]);n&&s.push(n)}return s}getDependency(e,t){const s=e+":"+t;let i=this.cache.get(s);if(!i){switch(e){case"scene":i=this.loadScene(t);break;case"node":i=this.loadNode(t);break;case"mesh":i=this._invokeOne((function(e){return e.loadMesh&&e.loadMesh(t)}));break;case"accessor":i=this.loadAccessor(t);break;case"bufferView":i=this._invokeOne((function(e){return e.loadBufferView&&e.loadBufferView(t)}));break;case"buffer":i=this.loadBuffer(t);break;case"material":i=this._invokeOne((function(e){return e.loadMaterial&&e.loadMaterial(t)}));break;case"texture":i=this._invokeOne((function(e){return e.loadTexture&&e.loadTexture(t)}));break;case"skin":i=this.loadSkin(t);break;case"animation":i=this.loadAnimation(t);break;case"camera":i=this.loadCamera(t);break;default:throw new Error("Unknown type: "+e)}this.cache.add(s,i)}return i}getDependencies(e){let t=this.cache.get(e);if(!t){const s=this,i=this.json[e+("mesh"===e?"es":"s")]||[];t=Promise.all(i.map((function(t,i){return s.getDependency(e,i)}))),this.cache.add(e,t)}return t}loadBuffer(e){const t=this.json.buffers[e],s=this.fileLoader;if(t.type&&"arraybuffer"!==t.type)throw new Error("THREE.GLTFLoader: "+t.type+" buffer type is not supported.");if(void 0===t.uri&&0===e)return Promise.resolve(this.extensions[b.KHR_BINARY_GLTF].body);const i=this.options;return new Promise((function(e,n){s.load(THREE.LoaderUtils.resolveURL(t.uri,i.path),e,void 0,(function(){n(new Error('THREE.GLTFLoader: Failed to load buffer "'+t.uri+'".'))}))}))}loadBufferView(e){const t=this.json.bufferViews[e];return this.getDependency("buffer",t.buffer).then((function(e){const s=t.byteLength||0,i=t.byteOffset||0;return e.slice(i,i+s)}))}loadAccessor(e){const t=this,s=this.json,i=this.json.accessors[e];if(void 0===i.bufferView&&void 0===i.sparse)return Promise.resolve(null);const n=[];return void 0!==i.bufferView?n.push(this.getDependency("bufferView",i.bufferView)):n.push(null),void 0!==i.sparse&&(n.push(this.getDependency("bufferView",i.sparse.indices.bufferView)),n.push(this.getDependency("bufferView",i.sparse.values.bufferView))),Promise.all(n).then((function(e){const n=e[0],l=Q[i.type],r=K[i.componentType],o=r.BYTES_PER_ELEMENT,a=o*l,d=i.byteOffset||0,c=void 0!==i.bufferView?s.bufferViews[i.bufferView].byteStride:void 0,h=!0===i.normalized;let p,m;if(c&&c!==a){const e=Math.floor(d/c),s="InterleavedBuffer:"+i.bufferView+":"+i.componentType+":"+e+":"+i.count;let a=t.cache.get(s);a||(p=new r(n,e*c,i.count*c/o),a=new InterleavedBuffer(p,c/o),t.cache.add(s,a)),m=new InterleavedBufferAttribute(a,l,d%c/o,h)}else p=null===n?new r(i.count*l):new r(n,d,i.count*l),m=new BufferAttribute(p,l,h);if(void 0!==i.sparse){const t=Q.SCALAR,s=K[i.sparse.indices.componentType],o=i.sparse.indices.byteOffset||0,a=i.sparse.values.byteOffset||0,d=new s(e[1],o,i.sparse.count*t),c=new r(e[2],a,i.sparse.count*l);null!==n&&(m=new BufferAttribute(m.array.slice(),m.itemSize,m.normalized));for(let e=0,t=d.length;e<t;e++){const t=d[e];if(m.setX(t,c[e*l]),l>=2&&m.setY(t,c[e*l+1]),l>=3&&m.setZ(t,c[e*l+2]),l>=4&&m.setW(t,c[e*l+3]),l>=5)throw new Error("THREE.GLTFLoader: Unsupported itemSize in sparse BufferAttribute.")}}return m}))}loadTexture(e){const t=this.json,s=this.options,i=t.textures[e].source,n=t.images[i];let l=this.textureLoader;if(n.uri){const e=s.manager.getHandler(n.uri);null!==e&&(l=e)}return this.loadTextureImage(e,i,l)}loadTextureImage(e,t,s){const i=this,n=this.json,l=n.textures[e],r=n.images[t],o=(r.uri||r.bufferView)+":"+l.sampler;if(this.textureCache[o])return this.textureCache[o];const a=this.loadImageSource(t,s).then((function(t){t.flipY=!1,l.name&&(t.name=l.name);const s=(n.samplers||{})[l.sampler]||{};return t.magFilter=J[s.magFilter]||LinearFilter,t.minFilter=J[s.minFilter]||LinearMipmapLinearFilter,t.wrapS=Z[s.wrapS]||RepeatWrapping,t.wrapT=Z[s.wrapT]||RepeatWrapping,i.associations.set(t,{textures:e}),t})).catch((function(){return null}));return this.textureCache[o]=a,a}loadImageSource(e,t){const s=this,i=this.json,n=this.options;if(void 0!==this.sourceCache[e])return this.sourceCache[e].then((e=>e.clone()));const l=i.images[e],r=self.URL||self.webkitURL;let o=l.uri||"",a=!1;if(void 0!==l.bufferView)o=s.getDependency("bufferView",l.bufferView).then((function(e){a=!0;const t=new Blob([e],{type:l.mimeType});return o=r.createObjectURL(t),o}));else if(void 0===l.uri)throw new Error("THREE.GLTFLoader: Image "+e+" is missing URI and bufferView");const d=Promise.resolve(o).then((function(e){return new Promise((function(s,i){let l=s;!0===t.isImageBitmapLoader&&(l=function(e){const t=new Texture(e);t.needsUpdate=!0,s(t)}),t.load(THREE.LoaderUtils.resolveURL(e,n.path),l,void 0,i)}))})).then((function(e){var t;return!0===a&&r.revokeObjectURL(o),e.userData.mimeType=l.mimeType||((t=l.uri).search(/\.jpe?g($|\?)/i)>0||0===t.search(/^data\:image\/jpeg/)?"image/jpeg":t.search(/\.webp($|\?)/i)>0||0===t.search(/^data\:image\/webp/)?"image/webp":"image/png"),e})).catch((function(e){throw console.error("THREE.GLTFLoader: Couldn't load texture",o),e}));return this.sourceCache[e]=d,d}assignTexture(e,t,s,i){const n=this;return this.getDependency("texture",s.index).then((function(l){if(void 0===s.texCoord||0==s.texCoord||"aoMap"===t&&1==s.texCoord||console.warn("THREE.GLTFLoader: Custom UV set "+s.texCoord+" for texture "+t+" not yet supported."),n.extensions[b.KHR_TEXTURE_TRANSFORM]){const e=void 0!==s.extensions?s.extensions[b.KHR_TEXTURE_TRANSFORM]:void 0;if(e){const t=n.associations.get(l);l=n.extensions[b.KHR_TEXTURE_TRANSFORM].extendTexture(l,e),n.associations.set(l,t)}}return void 0!==i&&(l.encoding=i),e[t]=l,l}))}assignFinalMaterial(e){const t=e.geometry;let s=e.material;const i=void 0===t.attributes.tangent,n=void 0!==t.attributes.color,l=void 0===t.attributes.normal;if(e.isPoints){const e="PointsMaterial:"+s.uuid;let t=this.cache.get(e);t||(t=new PointsMaterial,Material.prototype.copy.call(t,s),t.color.copy(s.color),t.map=s.map,t.sizeAttenuation=!1,this.cache.add(e,t)),s=t}else if(e.isLine){const e="LineBasicMaterial:"+s.uuid;let t=this.cache.get(e);t||(t=new LineBasicMaterial,Material.prototype.copy.call(t,s),t.color.copy(s.color),this.cache.add(e,t)),s=t}if(i||n||l){let e="ClonedMaterial:"+s.uuid+":";s.isGLTFSpecularGlossinessMaterial&&(e+="specular-glossiness:"),i&&(e+="derivative-tangents:"),n&&(e+="vertex-colors:"),l&&(e+="flat-shading:");let t=this.cache.get(e);t||(t=s.clone(),n&&(t.vertexColors=!0),l&&(t.flatShading=!0),i&&(t.normalScale&&(t.normalScale.y*=-1),t.clearcoatNormalScale&&(t.clearcoatNormalScale.y*=-1)),this.cache.add(e,t),this.associations.set(t,this.associations.get(s))),s=t}s.aoMap&&void 0===t.attributes.uv2&&void 0!==t.attributes.uv&&t.setAttribute("uv2",t.attributes.uv),e.material=s}getMaterialType(){return MeshStandardMaterial}loadMaterial(e){const t=this,s=this.json,i=this.extensions,n=s.materials[e];let l;const r={},o=n.extensions||{},a=[];if(o[b.KHR_MATERIALS_PBR_SPECULAR_GLOSSINESS]){const e=i[b.KHR_MATERIALS_PBR_SPECULAR_GLOSSINESS];l=e.getMaterialType(),a.push(e.extendParams(r,n,t))}else if(o[b.KHR_MATERIALS_UNLIT]){const e=i[b.KHR_MATERIALS_UNLIT];l=e.getMaterialType(),a.push(e.extendParams(r,n,t))}else{const s=n.pbrMetallicRoughness||{};if(r.color=new Color(1,1,1),r.opacity=1,Array.isArray(s.baseColorFactor)){const e=s.baseColorFactor;r.color.fromArray(e),r.opacity=e[3]}void 0!==s.baseColorTexture&&a.push(t.assignTexture(r,"map",s.baseColorTexture,sRGBEncoding)),r.metalness=void 0!==s.metallicFactor?s.metallicFactor:1,r.roughness=void 0!==s.roughnessFactor?s.roughnessFactor:1,void 0!==s.metallicRoughnessTexture&&(a.push(t.assignTexture(r,"metalnessMap",s.metallicRoughnessTexture)),a.push(t.assignTexture(r,"roughnessMap",s.metallicRoughnessTexture))),l=this._invokeOne((function(t){return t.getMaterialType&&t.getMaterialType(e)})),a.push(Promise.all(this._invokeAll((function(t){return t.extendMaterialParams&&t.extendMaterialParams(e,r)}))))}!0===n.doubleSided&&(r.side=DoubleSide);const d=n.alphaMode||ie;if(d===le?(r.transparent=!0,r.depthWrite=!1):(r.transparent=!1,d===ne&&(r.alphaTest=void 0!==n.alphaCutoff?n.alphaCutoff:.5)),void 0!==n.normalTexture&&l!==MeshBasicMaterial&&(a.push(t.assignTexture(r,"normalMap",n.normalTexture)),r.normalScale=new Vector2(1,1),void 0!==n.normalTexture.scale)){const e=n.normalTexture.scale;r.normalScale.set(e,e)}return void 0!==n.occlusionTexture&&l!==MeshBasicMaterial&&(a.push(t.assignTexture(r,"aoMap",n.occlusionTexture)),void 0!==n.occlusionTexture.strength&&(r.aoMapIntensity=n.occlusionTexture.strength)),void 0!==n.emissiveFactor&&l!==MeshBasicMaterial&&(r.emissive=(new Color).fromArray(n.emissiveFactor)),void 0!==n.emissiveTexture&&l!==MeshBasicMaterial&&a.push(t.assignTexture(r,"emissiveMap",n.emissiveTexture,sRGBEncoding)),Promise.all(a).then((function(){let s;return s=l===H?i[b.KHR_MATERIALS_PBR_SPECULAR_GLOSSINESS].createMaterial(r):new l(r),n.name&&(s.name=n.name),oe(s,n),t.associations.set(s,{materials:e}),n.extensions&&re(i,s,n),s}))}createUniqueName(e){const t=PropertyBinding.sanitizeNodeName(e||"");let s=t;for(let e=1;this.nodeNamesUsed[s];++e)s=t+"_"+e;return this.nodeNamesUsed[s]=!0,s}loadGeometries(e){const t=this,s=this.extensions,i=this.primitiveCache;function n(e){return s[b.KHR_DRACO_MESH_COMPRESSION].decodePrimitive(e,t).then((function(s){return ue(s,e,t)}))}const l=[];for(let s=0,r=e.length;s<r;s++){const r=e[s],o=de(r),a=i[o];if(a)l.push(a.promise);else{let e;e=r.extensions&&r.extensions[b.KHR_DRACO_MESH_COMPRESSION]?n(r):ue(new BufferGeometry,r,t),i[o]={primitive:r,promise:e},l.push(e)}}return Promise.all(l)}loadMesh(e){const t=this,s=this.json,i=this.extensions,n=s.meshes[e],l=n.primitives,r=[];for(let e=0,t=l.length;e<t;e++){const t=void 0===l[e].material?(void 0===(o=this.cache).DefaultMaterial&&(o.DefaultMaterial=new MeshStandardMaterial({color:16777215,emissive:0,metalness:1,roughness:1,transparent:!1,depthTest:!0,side:FrontSide})),o.DefaultMaterial):this.getDependency("material",l[e].material);r.push(t)}var o;return r.push(t.loadGeometries(l)),Promise.all(r).then((function(s){const r=s.slice(0,s.length-1),o=s[s.length-1],a=[];for(let s=0,d=o.length;s<d;s++){const d=o[s],c=l[s];let h;const p=r[s];if(c.mode===W||c.mode===Y||c.mode===X||void 0===c.mode)h=!0===n.isSkinnedMesh?new SkinnedMesh(d,p):new Mesh(d,p),!0!==h.isSkinnedMesh||h.geometry.attributes.skinWeight.normalized||h.normalizeSkinWeights(),c.mode===Y?h.geometry=ge(h.geometry,TriangleStripDrawMode):c.mode===X&&(h.geometry=ge(h.geometry,TriangleFanDrawMode));else if(c.mode===z)h=new LineSegments(d,p);else if(c.mode===V)h=new Line(d,p);else if(c.mode===G)h=new LineLoop(d,p);else{if(c.mode!==j)throw new Error("THREE.GLTFLoader: Primitive mode unsupported: "+c.mode);h=new Points(d,p)}Object.keys(h.geometry.morphAttributes).length>0&&ae(h,n),h.name=t.createUniqueName(n.name||"mesh_"+e),oe(h,n),c.extensions&&re(i,h,c),t.assignFinalMaterial(h),a.push(h)}for(let s=0,i=a.length;s<i;s++)t.associations.set(a[s],{meshes:e,primitives:s});if(1===a.length)return a[0];const d=new Group;t.associations.set(d,{meshes:e});for(let e=0,t=a.length;e<t;e++)d.add(a[e]);return d}))}loadCamera(e){let t;const s=this.json.cameras[e],i=s[s.type];if(i)return"perspective"===s.type?t=new PerspectiveCamera(MathUtils.radToDeg(i.yfov),i.aspectRatio||1,i.znear||1,i.zfar||2e6):"orthographic"===s.type&&(t=new OrthographicCamera(-i.xmag,i.xmag,i.ymag,-i.ymag,i.znear,i.zfar)),s.name&&(t.name=this.createUniqueName(s.name)),oe(t,s),Promise.resolve(t);console.warn("THREE.GLTFLoader: Missing camera parameters.")}loadSkin(e){const t=this.json.skins[e],s={joints:t.joints};return void 0===t.inverseBindMatrices?Promise.resolve(s):this.getDependency("accessor",t.inverseBindMatrices).then((function(e){return s.inverseBindMatrices=e,s}))}loadAnimation(e){const t=this.json.animations[e],s=[],i=[],n=[],l=[],r=[];for(let e=0,o=t.channels.length;e<o;e++){const o=t.channels[e],a=t.samplers[o.sampler],d=o.target,c=void 0!==d.node?d.node:d.id,h=void 0!==t.parameters?t.parameters[a.input]:a.input,p=void 0!==t.parameters?t.parameters[a.output]:a.output;s.push(this.getDependency("node",c)),i.push(this.getDependency("accessor",h)),n.push(this.getDependency("accessor",p)),l.push(a),r.push(d)}return Promise.all([Promise.all(s),Promise.all(i),Promise.all(n),Promise.all(l),Promise.all(r)]).then((function(s){const i=s[0],n=s[1],l=s[2],r=s[3],o=s[4],a=[];for(let e=0,t=i.length;e<t;e++){const t=i[e],s=n[e],d=l[e],c=r[e],h=o[e];if(void 0===t)continue;let p;switch(t.updateMatrix(),t.matrixAutoUpdate=!0,te[h.path]){case te.weights:p=NumberKeyframeTrack;break;case te.rotation:p=QuaternionKeyframeTrack;break;default:p=VectorKeyframeTrack}const m=t.name?t.name:t.uuid,u=void 0!==c.interpolation?se[c.interpolation]:InterpolateLinear,g=[];te[h.path]===te.weights?t.traverse((function(e){e.morphTargetInfluences&&g.push(e.name?e.name:e.uuid)})):g.push(m);let f=d.array;if(d.normalized){const e=he(f.constructor),t=new Float32Array(f.length);for(let s=0,i=f.length;s<i;s++)t[s]=f[s]*e;f=t}for(let e=0,t=g.length;e<t;e++){const t=new p(g[e]+"."+te[h.path],s.array,f,u);"CUBICSPLINE"===c.interpolation&&(t.createInterpolant=function(e){return new(this instanceof QuaternionKeyframeTrack?B:q)(this.times,this.values,this.getValueSize()/3,e)},t.createInterpolant.isInterpolantFactoryMethodGLTFCubicSpline=!0),a.push(t)}}const d=t.name?t.name:"animation_"+e;return new AnimationClip(d,void 0,a)}))}createNodeMesh(e){const t=this.json,s=this,i=t.nodes[e];return void 0===i.mesh?null:s.getDependency("mesh",i.mesh).then((function(e){const t=s._getNodeRef(s.meshCache,i.mesh,e);return void 0!==i.weights&&t.traverse((function(e){if(e.isMesh)for(let t=0,s=i.weights.length;t<s;t++)e.morphTargetInfluences[t]=i.weights[t]})),t}))}loadNode(e){const t=this.json,s=this.extensions,i=this,n=t.nodes[e],l=n.name?i.createUniqueName(n.name):"";return function(){const t=[],s=i._invokeOne((function(t){return t.createNodeMesh&&t.createNodeMesh(e)}));return s&&t.push(s),void 0!==n.camera&&t.push(i.getDependency("camera",n.camera).then((function(e){return i._getNodeRef(i.cameraCache,n.camera,e)}))),i._invokeAll((function(t){return t.createNodeAttachment&&t.createNodeAttachment(e)})).forEach((function(e){t.push(e)})),Promise.all(t)}().then((function(t){let r;if(r=!0===n.isBone?new Bone:t.length>1?new Group:1===t.length?t[0]:new Object3D,r!==t[0])for(let e=0,s=t.length;e<s;e++)r.add(t[e]);if(n.name&&(r.userData.name=n.name,r.name=l),oe(r,n),n.extensions&&re(s,r,n),void 0!==n.matrix){const e=new Matrix4;e.fromArray(n.matrix),r.applyMatrix4(e)}else void 0!==n.translation&&r.position.fromArray(n.translation),void 0!==n.rotation&&r.quaternion.fromArray(n.rotation),void 0!==n.scale&&r.scale.fromArray(n.scale);return i.associations.has(r)||i.associations.set(r,{}),i.associations.get(r).nodes=e,r}))}loadScene(e){const t=this.json,s=this.extensions,i=this.json.scenes[e],n=this,l=new Group;i.name&&(l.name=n.createUniqueName(i.name)),oe(l,i),i.extensions&&re(s,l,i);const r=i.nodes||[],o=[];for(let e=0,s=r.length;e<s;e++)o.push(me(r[e],l,t,n));return Promise.all(o).then((function(){return n.associations=(e=>{const t=new Map;for(const[e,s]of n.associations)(e instanceof Material||e instanceof Texture)&&t.set(e,s);return e.traverse((e=>{const s=n.associations.get(e);null!=s&&t.set(e,s)})),t})(l),l}))}}function me(e,t,s,i){const n=s.nodes[e];return i.getDependency("node",e).then((function(e){if(void 0===n.skin)return e;let t;return i.getDependency("skin",n.skin).then((function(e){t=e;const s=[];for(let e=0,n=t.joints.length;e<n;e++)s.push(i.getDependency("node",t.joints[e]));return Promise.all(s)})).then((function(s){return e.traverse((function(e){if(!e.isMesh)return;const i=[],n=[];for(let e=0,l=s.length;e<l;e++){const l=s[e];if(l){i.push(l);const s=new Matrix4;void 0!==t.inverseBindMatrices&&s.fromArray(t.inverseBindMatrices.array,16*e),n.push(s)}else console.warn('THREE.GLTFLoader: Joint "%s" could not be found.',t.joints[e])}e.bind(new Skeleton(i,n),e.matrixWorld)})),e}))})).then((function(e){t.add(e);const l=[];if(n.children){const t=n.children;for(let n=0,r=t.length;n<r;n++){const r=t[n];l.push(me(r,e,s,i))}}return Promise.all(l)}))}function ue(e,t,s){const i=t.attributes,n=[];function l(t,i){return s.getDependency("accessor",t).then((function(t){e.setAttribute(i,t)}))}for(const t in i){const s=ee[t]||t.toLowerCase();s in e.attributes||n.push(l(i[t],s))}if(void 0!==t.indices&&!e.index){const i=s.getDependency("accessor",t.indices).then((function(t){e.setIndex(t)}));n.push(i)}return oe(e,t),function(e,t,s){const i=t.attributes,n=new Box3;if(void 0===i.POSITION)return;{const e=s.json.accessors[i.POSITION],t=e.min,l=e.max;if(void 0===t||void 0===l)return void console.warn("THREE.GLTFLoader: Missing min/max properties for accessor POSITION.");if(n.set(new Vector3(t[0],t[1],t[2]),new Vector3(l[0],l[1],l[2])),e.normalized){const t=he(K[e.componentType]);n.min.multiplyScalar(t),n.max.multiplyScalar(t)}}const l=t.targets;if(void 0!==l){const e=new Vector3,t=new Vector3;for(let i=0,n=l.length;i<n;i++){const n=l[i];if(void 0!==n.POSITION){const i=s.json.accessors[n.POSITION],l=i.min,r=i.max;if(void 0!==l&&void 0!==r){if(t.setX(Math.max(Math.abs(l[0]),Math.abs(r[0]))),t.setY(Math.max(Math.abs(l[1]),Math.abs(r[1]))),t.setZ(Math.max(Math.abs(l[2]),Math.abs(r[2]))),i.normalized){const e=he(K[i.componentType]);t.multiplyScalar(e)}e.max(t)}else console.warn("THREE.GLTFLoader: Missing min/max properties for accessor POSITION.")}}n.expandByVector(e)}e.boundingBox=n;const r=new Sphere;n.getCenter(r.center),r.radius=n.min.distanceTo(n.max)/2,e.boundingSphere=r}(e,t,s),Promise.all(n).then((function(){return void 0!==t.targets?function(e,t,s){let i=!1,n=!1,l=!1;for(let e=0,s=t.length;e<s;e++){const s=t[e];if(void 0!==s.POSITION&&(i=!0),void 0!==s.NORMAL&&(n=!0),void 0!==s.COLOR_0&&(l=!0),i&&n&&l)break}if(!i&&!n&&!l)return Promise.resolve(e);const r=[],o=[],a=[];for(let d=0,c=t.length;d<c;d++){const c=t[d];if(i){const t=void 0!==c.POSITION?s.getDependency("accessor",c.POSITION):e.attributes.position;r.push(t)}if(n){const t=void 0!==c.NORMAL?s.getDependency("accessor",c.NORMAL):e.attributes.normal;o.push(t)}if(l){const t=void 0!==c.COLOR_0?s.getDependency("accessor",c.COLOR_0):e.attributes.color;a.push(t)}}return Promise.all([Promise.all(r),Promise.all(o),Promise.all(a)]).then((function(t){const s=t[0],r=t[1],o=t[2];return i&&(e.morphAttributes.position=s),n&&(e.morphAttributes.normal=r),l&&(e.morphAttributes.color=o),e.morphTargetsRelative=!0,e}))}(e,t.targets,s):e}))}function ge(e,t){let s=e.getIndex();if(null===s){const t=[],i=e.getAttribute("position");if(void 0===i)return console.error("THREE.GLTFLoader.toTrianglesDrawMode(): Undefined position attribute. Processing not possible."),e;for(let e=0;e<i.count;e++)t.push(e);e.setIndex(t),s=e.getIndex()}const i=s.count-2,n=[];if(t===TriangleFanDrawMode)for(let e=1;e<=i;e++)n.push(s.getX(0)),n.push(s.getX(e)),n.push(s.getX(e+1));else for(let e=0;e<i;e++)e%2==0?(n.push(s.getX(e)),n.push(s.getX(e+1)),n.push(s.getX(e+2))):(n.push(s.getX(e+2)),n.push(s.getX(e+1)),n.push(s.getX(e)));n.length/3!==i&&console.error("THREE.GLTFLoader.toTrianglesDrawMode(): Unable to generate correct amount of triangles.");const l=e.clone();return l.setIndex(n),l}const fe={Handedness:Object.freeze({NONE:"none",LEFT:"left",RIGHT:"right"}),ComponentState:Object.freeze({DEFAULT:"default",TOUCHED:"touched",PRESSED:"pressed"}),ComponentProperty:Object.freeze({BUTTON:"button",X_AXIS:"xAxis",Y_AXIS:"yAxis",STATE:"state"}),ComponentType:Object.freeze({TRIGGER:"trigger",SQUEEZE:"squeeze",TOUCHPAD:"touchpad",THUMBSTICK:"thumbstick",BUTTON:"button"}),ButtonTouchThreshold:.05,AxisTouchThreshold:.1,VisualResponseProperty:Object.freeze({TRANSFORM:"transform",VISIBILITY:"visibility"})};async function Ce(e){const t=await fetch(e);if(t.ok)return t.json();throw new Error(t.statusText)}async function be(e,t,s=null,i=!0){if(!e)throw new Error("No xrInputSource supplied");if(!t)throw new Error("No basePath supplied");const n=await async function(e){if(!e)throw new Error("No basePath supplied");return await Ce(`${e}/profilesList.json`)}(t);let l;if(e.profiles.some((e=>{const s=n[e];return s&&(l={profileId:e,profilePath:`${t}/${s.path}`,deprecated:!!s.deprecated}),!!l})),!l){if(!s)throw new Error("No matching profile name found");const e=n[s];if(!e)throw new Error(`No matching profile name found and default profile "${s}" missing.`);l={profileId:s,profilePath:`${t}/${e.path}`,deprecated:!!e.deprecated}}const r=await Ce(l.profilePath);let o;if(i){let t;if(t="any"===e.handedness?r.layouts[Object.keys(r.layouts)[0]]:r.layouts[e.handedness],!t)throw new Error(`No matching handedness, ${e.handedness}, in profile ${l.profileId}`);t.assetPath&&(o=l.profilePath.replace("profile.json",t.assetPath))}return{profile:r,assetPath:o}}const ye={xAxis:0,yAxis:0,button:0,state:fe.ComponentState.DEFAULT};class ve{constructor(e){this.componentProperty=e.componentProperty,this.states=e.states,this.valueNodeName=e.valueNodeName,this.valueNodeProperty=e.valueNodeProperty,this.valueNodeProperty===fe.VisualResponseProperty.TRANSFORM&&(this.minNodeName=e.minNodeName,this.maxNodeName=e.maxNodeName),this.value=0,this.updateFromComponent(ye)}updateFromComponent({xAxis:e,yAxis:t,button:s,state:i}){const{normalizedXAxis:n,normalizedYAxis:l}=function(e=0,t=0){let s=e,i=t;if(Math.sqrt(e*e+t*t)>1){const n=Math.atan2(t,e);s=Math.cos(n),i=Math.sin(n)}return{normalizedXAxis:.5*s+.5,normalizedYAxis:.5*i+.5}}(e,t);switch(this.componentProperty){case fe.ComponentProperty.X_AXIS:this.value=this.states.includes(i)?n:.5;break;case fe.ComponentProperty.Y_AXIS:this.value=this.states.includes(i)?l:.5;break;case fe.ComponentProperty.BUTTON:this.value=this.states.includes(i)?s:0;break;case fe.ComponentProperty.STATE:this.valueNodeProperty===fe.VisualResponseProperty.VISIBILITY?this.value=this.states.includes(i):this.value=this.states.includes(i)?1:0;break;default:throw new Error(`Unexpected visualResponse componentProperty ${this.componentProperty}`)}}}class _e{constructor(e,t){if(!(e&&t&&t.visualResponses&&t.gamepadIndices&&0!==Object.keys(t.gamepadIndices).length))throw new Error("Invalid arguments supplied");this.id=e,this.type=t.type,this.rootNodeName=t.rootNodeName,this.touchPointNodeName=t.touchPointNodeName,this.visualResponses={},Object.keys(t.visualResponses).forEach((e=>{const s=new ve(t.visualResponses[e]);this.visualResponses[e]=s})),this.gamepadIndices=Object.assign({},t.gamepadIndices),this.values={state:fe.ComponentState.DEFAULT,button:void 0!==this.gamepadIndices.button?0:void 0,xAxis:void 0!==this.gamepadIndices.xAxis?0:void 0,yAxis:void 0!==this.gamepadIndices.yAxis?0:void 0}}get data(){return{id:this.id,...this.values}}updateFromGamepad(e){if(this.values.state=fe.ComponentState.DEFAULT,void 0!==this.gamepadIndices.button&&e.buttons.length>this.gamepadIndices.button){const t=e.buttons[this.gamepadIndices.button];this.values.button=t.value,this.values.button=this.values.button<0?0:this.values.button,this.values.button=this.values.button>1?1:this.values.button,t.pressed||1===this.values.button?this.values.state=fe.ComponentState.PRESSED:(t.touched||this.values.button>fe.ButtonTouchThreshold)&&(this.values.state=fe.ComponentState.TOUCHED)}void 0!==this.gamepadIndices.xAxis&&e.axes.length>this.gamepadIndices.xAxis&&(this.values.xAxis=e.axes[this.gamepadIndices.xAxis],this.values.xAxis=this.values.xAxis<-1?-1:this.values.xAxis,this.values.xAxis=this.values.xAxis>1?1:this.values.xAxis,this.values.state===fe.ComponentState.DEFAULT&&Math.abs(this.values.xAxis)>fe.AxisTouchThreshold&&(this.values.state=fe.ComponentState.TOUCHED)),void 0!==this.gamepadIndices.yAxis&&e.axes.length>this.gamepadIndices.yAxis&&(this.values.yAxis=e.axes[this.gamepadIndices.yAxis],this.values.yAxis=this.values.yAxis<-1?-1:this.values.yAxis,this.values.yAxis=this.values.yAxis>1?1:this.values.yAxis,this.values.state===fe.ComponentState.DEFAULT&&Math.abs(this.values.yAxis)>fe.AxisTouchThreshold&&(this.values.state=fe.ComponentState.TOUCHED)),Object.values(this.visualResponses).forEach((e=>{e.updateFromComponent(this.values)}))}}class we{constructor(e,t,s){if(!e)throw new Error("No xrInputSource supplied");if(!t)throw new Error("No profile supplied");this.xrInputSource=e,this.assetUrl=s,this.id=t.profileId,this.layoutDescription=t.layouts[e.handedness],this.components={},Object.keys(this.layoutDescription.components).forEach((e=>{const t=this.layoutDescription.components[e];this.components[e]=new _e(e,t)})),this.updateFromGamepad()}get gripSpace(){return this.xrInputSource.gripSpace}get targetRaySpace(){return this.xrInputSource.targetRaySpace}get data(){const e=[];return Object.values(this.components).forEach((t=>{e.push(t.data)})),e}updateFromGamepad(){Object.values(this.components).forEach((e=>{e.updateFromGamepad(this.xrInputSource.gamepad)}))}}class Se extends THREE.Object3D{constructor(){super(),this.motionController=null,this.envMap=null}setEnvironmentMap(e){return this.envMap==e||(this.envMap=e,this.traverse((e=>{e.isMesh&&(e.material.envMap=this.envMap,e.material.needsUpdate=!0)}))),this}updateMatrixWorld(e){super.updateMatrixWorld(e),this.motionController&&(this.motionController.updateFromGamepad(),Object.values(this.motionController.components).forEach((e=>{Object.values(e.visualResponses).forEach((e=>{const{valueNode:t,minNode:s,maxNode:i,value:n,valueNodeProperty:l}=e;t&&(l===fe.VisualResponseProperty.VISIBILITY?t.visible=n:l===fe.VisualResponseProperty.TRANSFORM&&(t.quaternion.slerpQuaternions(s.quaternion,i.quaternion,n),t.position.lerpVectors(s.position,i.position,n)))}))})))}}function Ae(e,t){!function(e,t){Object.values(e.components).forEach((e=>{const{type:s,touchPointNodeName:i,visualResponses:n}=e;if(s===fe.ComponentType.TOUCHPAD)if(e.touchPointNode=t.getObjectByName(i),e.touchPointNode){const t=new SphereGeometry(.001),s=new MeshBasicMaterial({color:255}),i=new Mesh(t,s);e.touchPointNode.add(i)}else console.warn(`Could not find touch dot, ${e.touchPointNodeName}, in touchpad component ${e.id}`);Object.values(n).forEach((e=>{const{valueNodeName:s,minNodeName:i,maxNodeName:n,valueNodeProperty:l}=e;if(l===fe.VisualResponseProperty.TRANSFORM){if(e.minNode=t.getObjectByName(i),e.maxNode=t.getObjectByName(n),!e.minNode)return void console.warn(`Could not find ${i} in the model`);if(!e.maxNode)return void console.warn(`Could not find ${n} in the model`)}e.valueNode=t.getObjectByName(s),e.valueNode||console.warn(`Could not find ${s} in the model`)}))}))}(e.motionController,t),e.envMap&&t.traverse((t=>{t.isMesh&&(t.material.envMap=e.envMap,t.material.needsUpdate=!0)})),e.add(t)}class xe{constructor(e=null){this.gltfLoader=e,this.path="https://cdn.jsdelivr.net/npm/@webxr-input-profiles/assets@1.0/dist/profiles",this._assetCache={},this.gltfLoader||(this.gltfLoader=new f)}createControllerModel(e){const t=new Se;let s=null;return e.addEventListener("connected",(e=>{const i=e.data;"tracked-pointer"===i.targetRayMode&&i.gamepad&&be(i,this.path,"generic-trigger").then((({profile:e,assetPath:n})=>{t.motionController=new we(i,e,n);const l=this._assetCache[t.motionController.assetUrl];if(l)s=l.scene.clone(),Ae(t,s);else{if(!this.gltfLoader)throw new Error("GLTFLoader not set.");this.gltfLoader.setPath(""),this.gltfLoader.load(t.motionController.assetUrl,(e=>{this._assetCache[t.motionController.assetUrl]=e,s=e.scene.clone(),Ae(t,s)}),null,(()=>{throw new Error(`Asset ${t.motionController.assetUrl} missing or malformed.`)}))}})).catch((e=>{console.warn(e)}))})),e.addEventListener("disconnected",(()=>{t.motionController=null,t.remove(s),s=null})),t}}class ke extends THREE.EventDispatcher{constructor(e){if(super(),void 0===e)return void console.error("ControllerGestures must be passed a renderer");const t=new THREE.Clock;this.controller1=e.xr.getController(0),this.controller1.userData.gestures={index:0},this.controller1.userData.selectPressed=!1,this.controller1.addEventListener("selectstart",i),this.controller1.addEventListener("selectend",n),this.controller2=e.xr.getController(1),this.controller2.userData.gestures={index:1},this.controller2.userData.selectPressed=!1,this.controller2.addEventListener("selectstart",i),this.controller2.addEventListener("selectend",n),this.doubleClickLimit=.2,this.pressMinimum=.4,this.right=new THREE.Vector3(1,0,0),this.up=new THREE.Vector3(0,1,0),this.type="unknown",this.prevTap="none",this.clock=t;const s=this;function i(){const e=this.userData.gestures;e.startPosition=void 0,e.startTime=t.getElapsedTime(),-1==s.type.indexOf("tap")&&(e.taps=0),s.type="unknown",this.userData.selectPressed=!0}function n(){const e=this.userData.gestures;e.endTime=t.getElapsedTime();e.endTime-e.startTime<s.doubleClickLimit&&e.taps++,s.type="tap",this.userData.selectPressed=!1,e.startPosition=void 0}}get multiTouch(){let e;return e=void 0!==this.controller1&&void 0!==this.controller2&&(this.controller1.userData.selectPressed&&this.controller2.userData.selectPressed),e}get touch(){let e;return e=void 0!==this.controller1&&void 0!==this.controller2&&(this.controller1.userData.selectPressed||this.controller2.userData.selectPressed),e}get debugMsg(){return this.type}update(){const e=this.controller1.userData.gestures,t=this.controller2.userData.gestures,s=this.clock.getElapsedTime();let i;if(this.controller1.userData.selectPressed&&void 0===e.startPosition&&(i=s-e.startTime,i>.05&&(e.startPosition=this.controller1.position.clone())),this.controller2.userData.selectPressed&&void 0===t.startPosition&&(i=s-t.startTime,i>.05&&(t.startPosition=this.controller2.position.clone())),!this.controller1.userData.selectPressed&&"tap"===this.type&&(i=this.clock.getElapsedTime()-e.endTime,i>this.doubleClickLimit)){switch(e.taps){case 1:self.prevTap="tap";break;case 2:this.dispatchEvent({type:"doubletap",position:this.controller1.position,matrixWorld:this.controller1.matrixWorld}),self.prevTap="doubletap"}this.type="unknown",e.taps=0}if("unknown"===this.type&&this.touch)"doubletap"==self.prevTap?(this.type="pinch",this.startDistance=this.controller1.position.distanceTo(this.controller2.position),this.dispatchEvent({type:"pinch",delta:new THREE.Vector3(0,0,0),scale:1,initialise:!0})):(this.type="pan",this.startPosition=this.controller1.position.clone(),this.dispatchEvent({type:"pan",delta:new THREE.Vector3(0,0,0),initialise:!0}));else if(("pinch"===this.type||"pan"===this.type)&&"doubletap"==self.prevTap&&this.controller2.position){const e=this.controller1.position.distanceTo(this.controller2.position)/this.startDistance,t=this.controller1.position.clone().sub(this.startPosition);this.dispatchEvent({type:"pinch",delta:t,scale:e})}}}class Oe{constructor(e,t){this.config=void 0===t?{panelSize:{width:1,height:1},width:512,height:512,opacity:.7,body:{fontFamily:"Arial",fontSize:30,padding:2,backgroundColor:"#000",fontColor:"#fff",borderRadius:6}}:t,void 0===this.config.width&&(this.config.width=512),void 0===this.config.height&&(this.config.height=512),void 0===this.config.body&&(this.config.body={fontFamily:"Arial",size:30,padding:2,backgroundColor:"#000",fontColor:"#fff",borderRadius:6});const s=this.config.body;void 0===s.borderRadius&&(s.borderRadius=6),void 0===s.fontFamily&&(s.fontFamily="Arial"),void 0===s.padding&&(s.padding=2),void 0===s.fontSize&&(s.fontSize=30),void 0===s.backgroundColor&&(s.backgroundColor="#000"),void 0===s.fontColor&&(s.fontColor="#fff"),Object.entries(this.config).forEach((([e,t])=>{if(!("object"!=typeof t||"panelSize"===e||t instanceof THREE.WebGLRenderer||t instanceof THREE.Scene)){const e=void 0!==t.position?t.position:{x:0,y:0};void 0!==e.left&&void 0===e.x&&(e.x=e.left),void 0!==e.top&&void 0===e.y&&(e.y=e.top);const s=void 0!==t.width?t.width:this.config.width,i=void 0!==t.height?t.height:this.config.height;void 0!==e.right&&void 0===e.x&&(e.x=this.config.width-e.right-s),void 0!==e.bottom&&void 0===e.y&&(e.y=this.config.height-e.bottom-i),void 0===e.x&&(e.x=0),void 0===e.y&&(e.y=0),t.position=e,void 0===t.type&&(t.type="text")}}));const i=this.createOffscreenCanvas(this.config.width,this.config.height);this.context=i.getContext("2d"),this.context.save();const n=void 0!==this.config.opacity?this.config.opacity:.7,l=new THREE.MeshBasicMaterial({transparent:!0,opacity:n});this.panelSize=void 0!==this.config.panelSize?this.config.panelSize:{width:1,height:1};const r=new THREE.PlaneGeometry(this.panelSize.width,this.panelSize.height);this.mesh=new THREE.Mesh(r,l),this.texture=new THREE.CanvasTexture(i),this.mesh.material.map=this.texture,this.scene=this.config.scene;if(Object.values(this.config).filter((e=>"input-text"===e.type)).length>0){this.keyboard=new Re(this.panelSize.width,this.config.renderer);this.keyboard.mesh.position.set(0,-.3,.2),this.mesh.add(this.keyboard.mesh)}if(void 0===e)this.content={body:""},this.config.body.type="text";else{this.content=e;Object.values(t).filter((e=>"button"===e.type||"scroll"===e.overflow||"input-text"===e.type)).length>0&&(void 0===t||void 0===t.renderer?console.warn("CanvasUI: button, scroll or input-text in the config but no renderer"):(this.renderer=t.renderer,this.initControllers()))}this.selectedElements=[void 0,void 0],this.selectPressed=[!1,!1],this.scrollData=[void 0,void 0],this.intersects=[void 0,void 0],this.needsUpdate=!0,this.update()}getIntersectY(e){const t=this.config.height||512,s=this.intersects[e];return void 0===s||void 0===s.uv?0:(1-s.uv.y)*t}initControllers(){this.vec3=new THREE.Vector3,this.mat4=new THREE.Matrix4,this.raycaster=new THREE.Raycaster;const e=this;function t(t){const s=t.target===e.controller?0:1,i=e.selectedElements[s];if(void 0!==i)if("button"==i.type)e.select(s);else if("input-text"==i.type&&e.keyboard)if(e.keyboard.visible)e.keyboard.linkedUI=void 0,e.keyboard.linkedText=void 0,e.keyboard.linkedElement=void 0,e.keyboard.visible=!1;else{let t;e.keyboard.linkedUI=e,Object.entries(e.config).forEach((([e,s])=>{s==i&&(t=e)}));const s=(.5-(i.position.y+i.height+e.config.body.padding)/e.config.height)*e.panelSize.height,n=Math.max(e.panelSize.width,e.panelSize.height)/2;e.keyboard.position.set(0,-n/1.5-s,.1),e.keyboard.linkedText=e.content[t],e.keyboard.linkedName=t,e.keyboard.linkedElement=i,e.keyboard.visible=!0}}function s(t){const s=t.target===e.controller?0:1;if(e.selectPressed[s]=!0,void 0!==e.selectedElements[s]&&"scroll"==e.selectedElements[s].overflow){const t=e.selectedElements[s];e.scrollData[s]={scrollY:t.scrollY,rayY:e.getIntersectY(s)}}}function i(t){const s=t.target===e.controller?0:1;e.selectPressed[s]=!1,void 0!==e.selectedElements[s]&&"scroll"==e.selectedElements[s].overflow&&(e.scrollData[s]=void 0)}if(this.controller=this.renderer.xr.getController(0),this.controller.addEventListener("select",t),this.controller.addEventListener("selectstart",s),this.controller.addEventListener("selectend",i),this.controller1=this.renderer.xr.getController(1),this.controller1.addEventListener("select",t),this.controller1.addEventListener("selectstart",s),this.controller1.addEventListener("selectend",i),this.scene){const e=.015,t=new THREE.IcosahedronBufferGeometry(e),s=new THREE.MeshBasicMaterial({color:170}),i=new THREE.Mesh(t,s);i.visible=!1,this.scene.add(i);const n=new THREE.Mesh(t,s);n.visible=!1,this.scene.add(n),this.intersectMesh=[i,n]}}setClip(e){const t=this.context;if(t.restore(),t.save(),void 0!==e.clipPath){const s=new Path2D(e.clipPath);t.clip(s)}else{const s=void 0!==e.position?e.position:{x:0,y:0},i=e.borderRadius||0,n=e.width||this.config.width,l=e.height||this.config.height;if(t.beginPath(),0!==i){const e=Math.PI/2;t.moveTo(s.x+i,s.y),t.arc(s.x+i,s.y+i,i,e,2*e,!0),t.lineTo(s.x,s.y+l-i),t.arc(s.x+i,s.y+l-i,i,0,e,!0),t.lineTo(s.x+n-i,s.y+l),t.arc(s.x+n-i,s.y+l-i,i,3*e,4*e,!0),t.lineTo(s.x+n,s.y+i),t.arc(s.x+n-i,s.y+i,i,2*e,3*e,!0),t.closePath(),t.clip()}else t.rect(s.x,s.y,n,l),t.clip()}}setPosition(e,t,s){void 0!==this.mesh&&this.mesh.position.set(e,t,s)}setRotation(e,t,s){void 0!==this.mesh&&this.mesh.rotation.set(e,t,s)}updateElement(e,t){let s=this.content[e];void 0!==s?("object"==typeof s?s.content=t:s=t,this.content[e]=s,this.needsUpdate=!0):console.warn(`CanvasGUI.updateElement: No ${e} found`)}get panel(){return this.mesh}getElementAtLocation(e,t){const s=this,i=Object.entries(this.config).filter((([i,n])=>{if(!("object"!=typeof n||"panelSize"===i||"body"===i||n instanceof THREE.WebGLRenderer||n instanceof THREE.Scene)){const i=n.position,l=void 0!==n.width?n.width:s.config.width,r=void 0!==n.height?n.height:s.config.height;return e>=i.x&&e<i.x+l&&t>=i.y&&t<i.y+r}}));return 0==i.length?null:this.config[i[0][0]]}updateConfig(e,t,s){let i=this.config[e];void 0!==i?(i[t]=s,this.needsUpdate=!0):console.warn(`CanvasUI.updateconfig: No ${e} found`)}hover(e=0,t){if(void 0===t)void 0!==this.selectedElements[e]&&(this.selectedElements[e]=void 0,this.needsUpdate=!0);else{const s=t.x*(this.config.width||512),i=(1-t.y)*(this.config.height||512),n=this.getElementAtLocation(s,i);null===n?void 0!==this.selectedElements[e]&&(this.selectedElements[e]=void 0,this.needsUpdate=!0):this.selectedElements[e]!==n&&(this.selectedElements[e]=n,this.needsUpdate=!0)}}select(e=0){if(void 0!==this.selectedElements[e]){const t=this.selectedElements[e];t.onSelect&&t.onSelect(),"input-text"===t.type?this.keyboard.mesh.visible=!0:this.selectedElements[e]=void 0}}scroll(e){if(void 0===this.selectedElements[e])return void(this.intersectMesh&&(this.intersectMesh[e].visible=!1));if("scroll"!==this.selectedElements[e].overflow)return;const t=this.selectedElements[e];if(this.selectPressed[e]){const s=this.scrollData[e];if(void 0!==s){this.intersectMesh&&(this.intersectMesh[e].visible=!0,this.intersectMesh[e].position.copy(this.intersects[e].point));const i=this.getIntersectY(e)-s.rayY;t.scrollY=Math.min(Math.max(t.minScrollY,s.scrollY+i),0),this.needsUpdate=!0}}else this.intersectMesh&&(this.intersectMesh[e].visible=!1)}handleController(e,t){this.mat4.identity().extractRotation(e.matrixWorld),this.raycaster.ray.origin.setFromMatrixPosition(e.matrixWorld),this.raycaster.ray.direction.set(0,0,-1).applyMatrix4(this.mat4);const s=this.raycaster.intersectObject(this.mesh);s.length>0?(this.hover(t,s[0].uv),this.intersects[t]=s[0],this.scroll(t)):(this.hover(t),this.intersects[t]=void 0,this.scroll(t))}update(){if(void 0===this.mesh)return;if(this.controller&&this.handleController(this.controller,0),this.controller1&&this.handleController(this.controller1,1),this.keyboard&&this.keyboard.visible&&this.keyboard.update(),!this.needsUpdate)return;let e=this.context;e.clearRect(0,0,this.config.width,this.config.height);const t=this.config.body.backgroundColor?this.config.body.backgroundColor:"#000";!this.config.body.fontFamily||this.config.body.fontFamily;const s=this.config.body.fontColor?this.config.body.fontColor:"#fff";!this.config.body.fontSize||this.config.body.fontSize,this.setClip(this.config.body),e.fillStyle=t,e.fillRect(0,0,this.config.width,this.config.height);const i=this;Object.entries(this.content).forEach((([t,n])=>{const l=void 0!==i.config[t]?i.config[t]:i.config.body;if("none"!==(void 0!==l.display?l.display:"block")){const r=void 0!==l.position?l.position:{x:0,y:0},o=void 0!==l.width?l.width:i.config.width,a=void 0!==l.height?l.height:i.config.height;"button"!=l.type||n.toLowerCase().startsWith("<path>")||(void 0===l.borderRadius&&(l.borderRadius=6),void 0===l.textAlign&&(l.textAlign="center")),i.setClip(l);const d=n.toLowerCase().startsWith("<path>"),c=void 0!==i.selectedElements[0]&&this.selectedElements[0]===l||void 0!==i.selectedElements[1]&&this.selectedElements[1]===l;if(void 0!==l.backgroundColor&&(c&&"button"==l.type&&void 0!==l.hover?e.fillStyle=l.hover:e.fillStyle=l.backgroundColor,e.fillRect(r.x,r.y,o,a)),"text"==l.type||"button"==l.type||"input-text"==l.type){let h=!1;if(c?(d||"button"!=l.type?e.fillStyle=void 0!==l.hover?l.hover:void 0!==l.fontColor?l.fontColor:s:e.fillStyle=void 0!==l.fontColor?l.fontColor:s,h=void 0===l.hover):e.fillStyle=void 0!==l.fontColor?l.fontColor:s,d){const t=n.toUpperCase().substring(6,n.length-7);e.save(),e.translate(r.x,r.y);const s=new Path2D(t);e.fill(s),e.restore()}else i.wrapText(t,n);h&&(e.beginPath(),e.strokeStyle="#fff",e.lineWidth=2,e.rect(r.x,r.y,o,a),e.stroke())}else if("img"==l.type)if(void 0===l.img)this.loadImage(n).then((e=>{console.log(`w: ${e.width} | h: ${e.height}`),l.img=e,i.needsUpdate=!0,i.update()})).catch((e=>console.error(e)));else{const t=o/(l.img.width/l.img.height);e.drawImage(l.img,r.x,r.y,o,t)}}})),this.needsUpdate=!1,this.texture.needsUpdate=!0}loadImage(e){return new Promise(((t,s)=>{const i=new THREE.Image;i.addEventListener("load",(()=>t(i))),i.addEventListener("error",(e=>s(e))),i.src=e}))}createOffscreenCanvas(e,t){const s=document.createElement("canvas");return s.width=e,s.height=t,s}fillRoundedRect(e,t,s,i,n){const l=this.context;l.beginPath(),l.moveTo(e+n,t),l.lineTo(e+s-n,t),l.quadraticCurveTo(e+s,t,e+s,t+n),l.lineTo(e+s,t+i-n),l.quadraticCurveTo(e+s,t+i,e+s-n,t+i),l.lineTo(e+n,t+i),l.quadraticCurveTo(e,t+i,e,t+i-n),l.lineTo(e,t+n),l.quadraticCurveTo(e,t,e+n,t),l.closePath(),l.fill()}lookAt(e){void 0!==this.mesh&&(e instanceof Vector3?this.mesh.lookAt(e):console.error("CanvasUI lookAt called parameter not a THREE.Vector3"))}get visible(){return void 0!==this.mesh&&this.mesh.visible}set visible(e){this.mesh&&(this.mesh.visible=e)}get position(){if(void 0!==this.mesh)return this.mesh.position}set position(e){void 0!==this.mesh&&(e instanceof Vector3?this.mesh.position.copy(e):console.error("CanvasUI trying to set the mesh position using a parameter that is not a THREE.Vector3"))}get quaternion(){if(void 0!==this.mesh)return this.mesh.quaternion}set quaternion(e){void 0!==this.mesh&&(e instanceof QUaternion?this.mesh.quaternion.copy(e):console.error("CanvasUI trying to set the mesh quaternion using a parameter that is not a THREE.Quaternion"))}wrapText(e,t){const s=t.split(" ");let i="";const n=[],l=void 0!==this.config[e]?this.config[e]:this.config.body,r=void 0!==l.width?l.width:this.config.width,o=void 0!==l.height?l.height:this.config.height,a=void 0!==l.position?l.position:{x:0,y:0},d=void 0!==l.padding?l.padding:void 0!==this.config.body.padding?this.config.body.padding:10,c=void 0!==l.paddingTop?l.paddingTop:d,h=void 0!==l.paddingLeft?l.paddingLeft:d,p=void 0!==l.paddingBottom?l.paddingBottom:d,m=void 0!==l.paddingRight?l.paddingRight:d,u={x:a.x+h,y:a.y+c,width:r-h-m,height:o-c-p},g=void 0!==l.textAlign?l.textAlign:void 0!==this.config.body.textAlign?this.config.body.textAlign:"left",f=void 0!==l.fontSize?l.fontSize:void 0!==this.config.body.fontSize?this.config.body.fontSize:30,C=void 0!==l.fontFamily?l.fontFamily:void 0!==this.config.body.fontFamily?this.config.body.fontFamily:"Arial",b=f+(void 0!==l.leading?l.leading:void 0!==this.config.body.leading?this.config.body.leading:8),y=this.context;y.textAlign=g,y.font=`${f}px '${C}'`,s.forEach((function(e){let t=s.length>1?`${i}${e} `:e,l=y.measureText(t);if(l.width>u.width&&e.length>1)if(0==i.length&&l.width>u.width){for(;l.width>u.width;){let s=0;do{s++,t=e.substr(0,s),l=y.measureText(t)}while(l.width<u.width&&s<e.length-1);if(s--,t=e.substr(0,s),n.push(t),e=e.substr(s),s<=1)break;l=y.measureText(e)}""!=e&&n.push(e)}else n.push(i),i=`${e} `;else i=t})),""!=i&&n.push(i);const v=n.length*b;let _=0;if(v>u.height&&"scroll"===l.overflow){void 0===l.scrollY&&(l.scrollY=0);const e=void 0!==l.fontColor?l.fontColor:this.config.body.fontColor;y.fillStyle="#aaa",this.fillRoundedRect(a.x+r-12,a.y,12,o,6),y.fillStyle="#666";const t=u.height/v,s=t*o,i=-l.scrollY*t;this.fillRoundedRect(a.x+r-12,a.y+i,12,s,6),y.fillStyle=e,_=l.scrollY,l.minScrollY=u.height-v}let w,S=_+u.y+f/2;switch(g){case"center":w=u.x+u.width/2;break;case"right":w=u.x+u.width;break;default:w=u.x}n.forEach((e=>{S+b>0&&y.fillText(e,w,S),S+=b}))}}class Re{constructor(e,t,s="EN"){const i=this.getConfig(s);i.panelSize={width:e,height:.5*e},i.height=256,i.body={backgroundColor:"#555"},i.renderer=t;const n=this.getContent(s);this.keyboard=new Oe(n,i),this.keyboard.mesh.visible=!1,this.shift=!1}get mesh(){return this.keyboard.mesh}getConfig(e){const t={};let s=10;const i=39.2,n=49,l="#333",r="#000";let o=s,a=s;for(let e=0;e<10;e++){const d={type:"button",position:{x:a,y:o},width:i,height:n,padding:s,paddingTop:20,backgroundColor:r,borderRadius:6,hover:l,onSelect:this.onSelect.bind(this,e)};t[`btn${e}`]=d,a+=49.2}o+=59,a=s;for(let e=0;e<10;e++){const d={type:"button",position:{x:a,y:o},width:i,height:n,padding:s,paddingTop:20,backgroundColor:r,borderRadius:6,hover:l,onSelect:this.onSelect.bind(this,e+10)};t[`btn${e+10}`]=d,a+=49.2}o+=59,a=s;for(let e=0;e<9;e++){const d=0==e||8==e?1.5*i+5:i,c={type:"button",position:{x:a,y:o},width:d,height:n,padding:s,paddingTop:20,backgroundColor:r,borderRadius:6,hover:l,onSelect:this.onSelect.bind(this,e+20)};t[`btn${e+20}`]=c,a+=d+s}o+=59,a=s;for(let e=0;e<5;e++){const d=0==e||4==e?88.4:2==e?186.8:i,c={type:"button",position:{x:a,y:o},width:d,height:n,padding:s,paddingTop:20,backgroundColor:r,borderRadius:6,hover:l,onSelect:this.onSelect.bind(this,e+30)};0==e&&(c.fontSize=20),t[`btn${e+30}`]=c,a+=d+s}return t}getContent(e,t=0){let s,i={};switch(this.language=e,this.keyboardIndex=t,t){case 0:s=["q","w","e","r","t","y","u","i","o","p","a","s","d","f","g","h","j","k","l","@","⇧","z","x","c","v","b","n","m","⇦","","?123",",","   ",".","↲"];for(let e=0;e<s.length;e++){const t=s[e];""!==t&&(i[`btn${e}`]=t)}break;case 1:s=["Q","W","E","R","T","Y","U","I","O","P","A","S","D","F","G","H","J","K","L","@","⇧","Z","X","C","V","B","N","M","⇦","","?123",",","   ",".","↲"];for(let e=0;e<s.length;e++){const t=s[e];""!==t&&(i[`btn${e}`]=t)}break;case 2:s=["1","2","3","4","5","6","7","8","9","0","@","#","%","&","*","/","-","+","(",")","⇧","?","!",'"',"'","\\",":",";","⇦","","abc",",","   ",".","↲"];for(let e=0;e<s.length;e++){const t=s[e];""!==t&&(i[`btn${e}`]=t)}break;case 3:s=["1","2","3","4","5","6","7","8","9","0","€","£","$","^","=","|","{","}","[","}","⇧","<",">","_","`","~",":",";","⇦","","abc",",","   ",".","↲"];for(let e=0;e<s.length;e++){const t=s[e];""!==t&&(i[`btn${e}`]=t)}}return i}get position(){return this.keyboard.mesh.position}get visible(){return this.keyboard.mesh.visible}set visible(e){this.keyboard.mesh.visible=e}setKeyboard(e){this.keyboard.content=this.getContent(this.language,e),this.keyboard.needsUpdate=!0}onSelect(e){if(!this.visible)return;let t=!1;switch(e){case 34:this.visible=!1,this.linkedElement.onEnter&&this.linkedElement.onEnter(this.linkedText);break;case 32:this.linkedText+=" ",t=!0;break;case 30:this.shift=!1,this.keyboardIndex<2?this.setKeyboard(2):this.setKeyboard(0),this.keyboard.needsUpdate=!0;break;case 28:this.linkedText=this.linkedText.substring(0,this.linkedText.length-1),t=!0;break;case 20:this.shift=!this.shift,0==this.keyboardIndex?this.setKeyboard(1):1==this.keyboardIndex?this.setKeyboard(0):2==this.keyboardIndex?this.setKeyboard(3):3==this.keyboardIndex&&this.setKeyboard(2);break;default:const s=this.keyboard.content[`btn${e}`];this.linkedText+=s,t=!0,1==this.keyboardIndex&&this.setKeyboard(0)}t&&(this.linkedUI.updateElement(this.linkedName,this.linkedText),this.linkedElement.onChanged&&this.linkedElement.onChanged(this.linkedText))}update(){this.keyboard&&this.keyboard.update()}}class Ie{constructor(e){this.icn3d=e}rebuildScene(e){let t=this.icn3d,s=t.icn3dui;void 0===e&&(e=t.opts),this.rebuildSceneBase(e),t.fogCls.setFog(),t.cameraCls.setCamera(),s.cfg.imageonly||this.setVrArButtons(),this.setVrAr(),void 0!==t.bSkipChemicalbinding&&t.bSkipChemicalbinding||t.applyOtherCls.applyChemicalbindingOptions(),t.bSkipChemicalbinding=!0,"show"===e.chemicalbinding&&(t.opts.hbonds="yes"),t.applySsbondsCls.applySsbondsOptions(),t.applyClbondsCls.applyClbondsOptions(),t.applyMissingResCls.applyMissingResOptions(),t.applyDisplayCls.applyDisplayOptions(t.opts,t.dAtoms),t.applyOtherCls.applyOtherOptions(),t.scene_ghost.updateMatrixWorld(!0)}rebuildSceneBase(e){let t=this.icn3d,s=t.icn3dui;if($.extend(t.opts,e),t.cam_z=2*t.maxD,void 0!==t.scene)for(let e=t.scene.children.length-1;e>=0;e--){let s=t.scene.children[e];t.scene.remove(s)}else t.scene=new THREE.Scene;if(void 0!==t.scene_ghost)for(let e=t.scene_ghost.children.length-1;e>=0;e--){let s=t.scene_ghost.children[e];t.scene_ghost.remove(s)}else t.scene_ghost=new THREE.Scene;if(""!=s.htmlCls.setHtmlCls.getCookie("shininess")){let e=parseFloat(s.htmlCls.setHtmlCls.getCookie("shininess"));t.shininess!=e&&s.htmlCls.clickMenuCls.setLogCmd("set shininess "+e,!0),t.shininess=e}if(!s.bNode&&""!=s.htmlCls.setHtmlCls.getCookie("light1")){let e=parseFloat(s.htmlCls.setHtmlCls.getCookie("light1")),i=parseFloat(s.htmlCls.setHtmlCls.getCookie("light2")),n=parseFloat(s.htmlCls.setHtmlCls.getCookie("light3"));t.light1==e&&t.light2==i&&t.light3==n||s.htmlCls.clickMenuCls.setLogCmd("set light | light1 "+e+" | light2 "+i+" | light3 "+n,!0),t.light1=e,t.light2=i,t.light3=n}t.directionalLight=new THREE.DirectionalLight(16777215,t.light1),t.directionalLight2=new THREE.DirectionalLight(16777215,t.light2),t.directionalLight3=new THREE.DirectionalLight(16777215,t.light3),t.cam_z>0?(t.directionalLight.position.set(-1,1,1),t.directionalLight2.position.set(1,1,1),t.directionalLight3.position.set(1,1,-1),t.lightPos=new THREE.Vector3(-1,1,1),t.lightPos2=new THREE.Vector3(1,1,1),t.lightPos3=new THREE.Vector3(1,1,-1)):(t.directionalLight.position.set(-1,1,-1),t.directionalLight2.position.set(1,1,-1),t.directionalLight3.position.set(1,1,1),t.lightPos=new THREE.Vector3(-1,1,-1),t.lightPos2=new THREE.Vector3(1,1,-1),t.lightPos3=new THREE.Vector3(1,1,1));let i=new THREE.AmbientLight(4210752);if(t.scene.add(t.directionalLight),t.scene.add(i),void 0!==t.mdl)for(let e=t.mdl.children.length-1;e>=0;e--){let s=t.mdl.children[e];s.geometry&&s.geometry.dispose(),s.material&&s.material.dispose(),t.mdl.remove(s)}if(void 0!==t.mdlImpostor){for(let e=t.mdlImpostor.children.length-1;e>=0;e--){let s=t.mdlImpostor.children[e];s.geometry&&s.geometry.dispose(),s.material&&s.material.dispose(),t.mdlImpostor.remove(s)}t.mdlImpostor.children.length=0}s.bNode||t.renderer.renderLists.dispose(),t.mdl=new THREE.Object3D,t.mdlImpostor=new THREE.Object3D,t.scene.add(t.mdl),t.scene.add(t.mdlImpostor),t.mdl_ghost=new THREE.Object3D,t.scene_ghost.add(t.mdl_ghost),t.objects=[],t.objects_ghost=[],t.raycaster=new THREE.Raycaster,t.projector=new THREE.Projector,t.mouse=new THREE.Vector2;let n=s.parasCls.backgroundColors[t.opts.background.toLowerCase()];s.bNode||("transparent"===t.opts.background.toLowerCase()?t.renderer.setClearColor(n,0):t.renderer.setClearColor(n,1)),t.perspectiveCamera=new THREE.PerspectiveCamera(20,t.container.whratio,.1,1e4),t.perspectiveCamera.position.set(0,0,t.cam_z),t.perspectiveCamera.lookAt(new THREE.Vector3(0,0,0)),t.orthographicCamera=new THREE.OrthographicCamera,t.orthographicCamera.position.set(0,0,t.cam_z),t.orthographicCamera.lookAt(new THREE.Vector3(0,0,0)),t.cams={perspective:t.perspectiveCamera,orthographic:t.orthographicCamera}}setVrAr(){let e=this.icn3d;e.icn3dui;let t=this;e.bSetVrAr=!0,e.bVr?(e.canvasUI=this.createUI(),e.raycasterVR=new THREE.Raycaster,e.workingMatrix=new THREE.Matrix4,e.workingVector=new THREE.Vector3,e.origin=new THREE.Vector3,e.dolly=new THREE.Object3D,e.dolly.position.z=5,e.dolly.add(e.cam),e.scene.add(e.dolly),e.dollyId=e.dolly.id,e.dummyCam=new THREE.Object3D,e.cam.add(e.dummyCam),e.clock=new THREE.Clock,e.controllers=this.getControllers(),e.controllers.forEach((s=>{s.addEventListener("connected",(function(e){try{const s={},i="https://cdn.jsdelivr.net/npm/@webxr-input-profiles/assets@1.0/dist/profiles",n="generic-trigger";be(e.data,i,n).then((({profile:i,assetPath:n})=>{s.name=i.profileId,s.targetRayMode=e.data.targetRayMode,Object.entries(i.layouts).forEach((([e,t])=>{const i={};Object.values(t.components).forEach((e=>{i[e.rootNodeName]=e.gamepadIndices})),s[e]=i})),t.updateControllers(s)}))}catch(e){}})),s.addEventListener("disconnected",(function(){this.remove(this.children[0]),e.controllers.forEach((e=>{}))}))}))):e.bAr&&(e.gestures=new ke(e.renderer),e.scene.add(e.gestures.controller1),e.scene.add(e.gestures.controller2),e.gestures.addEventListener("doubletap",(e=>{t.positionCenter()})),e.gestures.addEventListener("pinch",(s=>{if(void 0!==s.initialise)t.startPosition=e.mdl.position.clone(),t.startScale=e.mdl.scale.clone();else{let i=1;const n=t.startScale.clone().multiplyScalar(s.scale*i);e.mdl.scale.copy(n)}})))}positionCenter(){let e=this.icn3d;e.icn3dui;const t=e.gestures.controller1;e.mdl.position.set(-.06,0,-.6).applyMatrix4(t.matrixWorld),e.mdl.scale.copy(new THREE.Vector3(.005,.005,.005))}setVrArButtons(){let e=this.icn3d,t=e.icn3dui;e.bSetVrArButtons=!0,t.bNode||($("#"+t.pre+"VRButton").remove(),$("#"+t.pre+"viewer").get(0).appendChild(e.VRButtonCls.createButton(e.renderer)),$("#"+t.pre+"ARButton").remove(),$("#"+t.pre+"viewer").get(0).appendChild(e.ARButtonCls.createButton(e.renderer)))}updateControllers(e){this.icn3d.icn3dui,this.addEventForController(e,"right"),this.addEventForController(e,"left")}addEventForController(e,t){let s=this.icn3d;s.icn3dui;const i="right"==t?s.renderer.xr.getController(0):s.renderer.xr.getController(1),n="right"==t?e.right:e.left;if(i&&void 0!==n){let e=!1,t=!1;Object.keys(n).forEach((i=>{-1!=i.indexOf("trigger")&&(e=!0),-1!=i.indexOf("squeeze")&&(t=!0),-1==i.indexOf("thumbstick")&&-1==i.indexOf("touchpad")||(s.xAxisIndex=n[i].xAxis,s.yAxisIndex=n[i].yAxis)})),e&&(i.addEventListener("selectstart",(function(){this.userData.selectPressed=!0})),i.addEventListener("selectend",(function(){this.userData.selectPressed=!1,this.userData.selected=void 0}))),t&&(i.addEventListener("squeezestart",(function(){this.userData.squeezePressed=!0,s.cam.add(s.canvasUI.mesh)})),i.addEventListener("squeezeend",(function(){this.userData.squeezePressed=!1,s.cam.remove(s.canvasUI.mesh)})))}}createUI(){let e=this.icn3d,t=e.icn3dui,s=94,i=50,n=94,l=34,r=12,o="#1c94c4",a="#ccc",d="#fbcb09",c=20;const h={panelSize:{width:2,height:1.6},height:400,select:{type:"button",paddingTop:c,position:{top:6,left:6},width:s,height:i,fontColor:"#000",fontSize:14,backgroundColor:a},residue:{type:"button",paddingTop:c,position:{top:62,left:6},width:s,height:i,fontColor:o,fontSize:r,backgroundColor:a,hover:d,onSelect:function(){e.pk=2,e.pAtomNum||(e.pAtomNum=0),e.cam.remove(e.canvasUI.mesh)}},secondarySelect:{type:"button",paddingTop:12,position:{top:118,left:6},width:s,height:i,fontColor:o,fontSize:r,backgroundColor:a,hover:d,onSelect:function(){e.pk=3,e.pAtomNum||(e.pAtomNum=0),e.cam.remove(e.canvasUI.mesh)}},chainSelect:{type:"button",paddingTop:c,position:{top:174,left:6},width:s,height:i,fontColor:o,fontSize:r,backgroundColor:a,hover:d,onSelect:function(){e.pk=5,e.pAtomNum||(e.pAtomNum=0),e.cam.remove(e.canvasUI.mesh)}},atom:{type:"button",paddingTop:c,position:{top:230,left:6},width:s,height:i,fontColor:o,fontSize:r,backgroundColor:a,hover:d,onSelect:function(){e.pk=1,e.pAtomNum||(e.pAtomNum=0),e.cam.remove(e.canvasUI.mesh)}},reset:{type:"button",paddingTop:c,position:{top:286,left:6},width:s,height:i,fontColor:o,fontSize:r,backgroundColor:a,hover:d,onSelect:function(){e.viewInterPairsCls.resetInteractionPairs(),e.selectionCls.resetAll(),e.cam.remove(e.canvasUI.mesh)}},togglehl:{type:"button",paddingTop:12,position:{top:342,left:6},width:s,height:i,fontColor:o,fontSize:r,backgroundColor:a,hover:d,onSelect:function(){e.hlUpdateCls.toggleHighlight(),e.cam.remove(e.canvasUI.mesh)}},style:{type:"button",paddingTop:c,position:{top:6,left:106},width:s,height:i,fontColor:"#000",fontSize:14,backgroundColor:a},ribbon:{type:"button",paddingTop:c,position:{top:62,left:106},width:s,height:i,fontColor:o,fontSize:r,backgroundColor:a,hover:d,onSelect:function(){e.setOptionCls.setStyle("proteins","ribbon"),e.setOptionCls.setStyle("nucleotides","nucleotide cartoon"),e.cam.remove(e.canvasUI.mesh)}},schematic:{type:"button",paddingTop:c,position:{top:118,left:106},width:s,height:i,fontColor:o,fontSize:r,backgroundColor:a,hover:d,onSelect:function(){e.setOptionCls.setStyle("proteins","schematic"),e.setOptionCls.setStyle("nucleotides","schematic"),e.cam.remove(e.canvasUI.mesh)}},stick:{type:"button",paddingTop:c,position:{top:174,left:106},width:s,height:i,fontColor:o,fontSize:r,backgroundColor:a,hover:d,onSelect:function(){e.setOptionCls.setStyle("proteins","stick"),e.setOptionCls.setStyle("nucleotides","stick"),e.cam.remove(e.canvasUI.mesh)}},sphere:{type:"button",paddingTop:c,position:{top:230,left:106},width:s,height:i,fontColor:o,fontSize:r,backgroundColor:a,hover:d,onSelect:function(){e.setOptionCls.setStyle("proteins","sphere"),e.setOptionCls.setStyle("nucleotides","sphere"),e.cam.remove(e.canvasUI.mesh)}},surface:{type:"button",paddingTop:c,position:{top:286,left:106},width:s,height:i,fontColor:o,fontSize:r,backgroundColor:a,hover:d,onSelect:function(){e.opts.surface="molecular surface",e.applyMapCls.applySurfaceOptions(),e.cam.remove(e.canvasUI.mesh)}},surfaceTrn:{type:"button",paddingTop:12,position:{top:342,left:106},width:s,height:i,fontColor:o,fontSize:r,backgroundColor:a,hover:d,onSelect:function(){e.opts.surface="molecular surface",e.opts.opacity="0.2",e.applyMapCls.applySurfaceOptions(),e.cam.remove(e.canvasUI.mesh)}},color:{type:"button",paddingTop:c,position:{top:6,left:206},width:s,height:i,fontColor:"#000",fontSize:14,backgroundColor:a},rainbow:{type:"button",paddingTop:c,position:{top:62,left:206},width:s,height:i,fontColor:o,fontSize:r,backgroundColor:a,hover:d,onSelect:function(){e.setOptionCls.setOption("color","rainbow for chains"),e.cam.remove(e.canvasUI.mesh)}},atomColor:{type:"button",paddingTop:c,position:{top:118,left:206},width:s,height:i,fontColor:o,fontSize:r,backgroundColor:a,hover:d,onSelect:function(){e.setOptionCls.setOption("color","atom"),e.cam.remove(e.canvasUI.mesh)}},chainColor:{type:"button",paddingTop:c,position:{top:174,left:206},width:s,height:i,fontColor:o,fontSize:r,backgroundColor:a,hover:d,onSelect:function(){e.setOptionCls.setOption("color","chain"),e.cam.remove(e.canvasUI.mesh)}},secondaryColor:{type:"button",paddingTop:12,position:{top:230,left:206},width:s,height:i,fontColor:o,fontSize:r,backgroundColor:a,hover:d,onSelect:function(){e.setOptionCls.setOption("color","secondary structure green"),e.cam.remove(e.canvasUI.mesh)}},charge:{type:"button",paddingTop:c,position:{top:342,left:206},width:s,height:i,fontColor:o,fontSize:r,backgroundColor:a,hover:d,onSelect:function(){e.setOptionCls.setOption("color","charge"),e.cam.remove(e.canvasUI.mesh)}},AlphaFold:{type:"button",paddingTop:c,position:{top:286,left:206},width:s,height:i,fontColor:o,fontSize:r,backgroundColor:a,hover:d,onSelect:function(){e.setOptionCls.setOption("color","confidence"),e.cam.remove(e.canvasUI.mesh)}},unicolor:{type:"button",paddingTop:c,position:{top:6,left:306},width:s,height:i,fontColor:"#000",fontSize:14,backgroundColor:a},red:{type:"button",position:{top:i,left:300},width:n,height:l,fontColor:"red",hover:d,onSelect:function(){e.setOptionCls.setOption("color","red"),e.cam.remove(e.canvasUI.mesh)}},green:{type:"button",position:{top:78,left:300},width:n,height:l,fontColor:"green",hover:d,onSelect:function(){e.setOptionCls.setOption("color","green"),e.cam.remove(e.canvasUI.mesh)}},blue:{type:"button",position:{top:106,left:300},width:n,height:l,fontColor:"blue",hover:d,onSelect:function(){e.setOptionCls.setOption("color","blue"),e.cam.remove(e.canvasUI.mesh)}},blueviolet:{type:"button",position:{top:134,left:300},width:n,height:l,fontColor:"#8A2BE2",hover:d,onSelect:function(){e.setOptionCls.setOption("color","8A2BE2"),e.cam.remove(e.canvasUI.mesh)}},magenta:{type:"button",position:{top:162,left:300},width:n,height:l,fontColor:"magenta",hover:d,onSelect:function(){e.setOptionCls.setOption("color","magenta"),e.cam.remove(e.canvasUI.mesh)}},yellow:{type:"button",position:{top:190,left:300},width:n,height:l,fontColor:"yellow",hover:d,onSelect:function(){e.setOptionCls.setOption("color","yellow"),e.cam.remove(e.canvasUI.mesh)}},orange:{type:"button",position:{top:218,left:300},width:n,height:l,fontColor:"orange",hover:d,onSelect:function(){e.setOptionCls.setOption("color","FFA500"),e.cam.remove(e.canvasUI.mesh)}},cyan:{type:"button",position:{top:246,left:300},width:n,height:l,fontColor:"cyan",hover:d,onSelect:function(){e.setOptionCls.setOption("color","cyan"),e.cam.remove(e.canvasUI.mesh)}},gray:{type:"button",position:{top:274,left:300},width:n,height:l,fontColor:"gray",hover:d,onSelect:function(){e.setOptionCls.setOption("color","888888"),e.cam.remove(e.canvasUI.mesh)}},white:{type:"button",position:{top:302,left:300},width:n,height:l,fontColor:"white",hover:d,onSelect:function(){e.setOptionCls.setOption("color","white"),e.cam.remove(e.canvasUI.mesh)}},analysis:{type:"button",paddingTop:c,position:{top:6,left:406},width:s,height:i,fontColor:"#000",fontSize:14,backgroundColor:a},distance:{type:"button",paddingTop:c,position:{top:62,left:406},width:s,height:i,fontColor:o,fontSize:r,backgroundColor:a,hover:d,onSelect:function(){try{e.bMeasureDistance=!0;let s=e.pickingCls.getPickedAtomList(e.pk,e.pAtom),i=e.pickingCls.getPickedAtomList(e.pk,e.pAtom2),n=e.applyCenterCls.centerAtoms(t.hashUtilsCls.hash2Atoms(s,e.atoms)).center,l=e.applyCenterCls.centerAtoms(t.hashUtilsCls.hash2Atoms(i,e.atoms)).center,r=0,o=0,a="#FFFF00",d=(n.x+l.x)/2,c=(n.y+l.y)/2,h=(n.z+l.z)/2,p=!0;e.analysisCls.addLine(n.x,n.y,n.z,l.x,l.y,l.z,a,p,"distance");let m=(parseInt(10*n.distanceTo(l))/10).toString()+" A";e.analysisCls.addLabel(m,d,c,h,r,a,o,"distance"),e.drawCls.draw(),e.cam.remove(e.canvasUI.mesh)}catch(e){}}},interaction:{type:"button",paddingTop:c,position:{top:118,left:406},width:s,height:i,fontColor:o,fontSize:r,backgroundColor:a,hover:d,onSelect:function(){try{e.viewInterPairsCls.viewInteractionPairs(["selected"],["non-selected"],!1,"3d",1,1,1,1,1,1),e.cam.remove(e.canvasUI.mesh)}catch(e){}}},delphi:{type:"button",paddingTop:c,position:{top:174,left:406},width:s,height:i,fontColor:o,fontSize:r,backgroundColor:a,hover:d,onSelect:async function(){e.phisurftype=22,e.phisurfop=1,e.phisurfwf="no",await e.delphiCls.CalcPhi(65,.15,2,!0),e.cam.remove(e.canvasUI.mesh)}},removeLabel:{type:"button",paddingTop:c,position:{top:230,left:406},width:s,height:i,fontColor:o,fontSize:r,backgroundColor:a,hover:d,onSelect:function(){for(let t in e.labels)e.labels[t]=[];e.drawCls.draw(),e.cam.remove(e.canvasUI.mesh)}},renderer:e.renderer},p=new Oe({select:"Select",residue:"Residue",secondarySelect:"Secondary Structure",chainSelect:"Chain",atom:"Atom",reset:"Reset",togglehl:"Toggle Highlight",style:"Style",ribbon:"Ribbon",schematic:"Schematic",stick:"Stick",sphere:"Sphere",surface:"Surface",surfaceTrn:"Transparent Surface",color:"Color",rainbow:"Rainbow",atomColor:"Atom",chainColor:"Chain",secondaryColor:"Secondary Structure",AlphaFold:"AlphaFold",charge:"Charge",unicolor:"UniColor",red:"<path>M 100 15 L 15 15 L 15 100 L 100 100 Z<path>",green:"<path>M 100 15 L 15 15 L 15 100 L 100 100 Z<path>",blue:"<path>M 100 15 L 15 15 L 15 100 L 100 100 Z<path>",blueviolet:"<path>M 100 15 L 15 15 L 15 100 L 100 100 Z<path>",magenta:"<path>M 100 15 L 15 15 L 15 100 L 100 100 Z<path>",yellow:"<path>M 100 15 L 15 15 L 15 100 L 100 100 Z<path>",orange:"<path>M 100 15 L 15 15 L 15 100 L 100 100 Z<path>",cyan:"<path>M 100 15 L 15 15 L 15 100 L 100 100 Z<path>",gray:"<path>M 100 15 L 15 15 L 15 100 L 100 100 Z<path>",white:"<path>M 100 15 L 15 15 L 15 100 L 100 100 Z<path>",analysis:"Analysis",distance:"Distance",interaction:"Interaction",delphi:"DelPhi Potential",removeLabel:"Remove Label"},h);return p.mesh.position.set(0,0,-3),p}createUILog(){let e=this.icn3d;e.icn3dui;const t={panelSize:{width:2,height:2},height:512,info:{type:"text",overflow:"scroll",position:{top:6,left:6},width:506,height:506,backgroundColor:"#aaa",fontColor:"#000"},renderer:e.renderer},s=new Oe({info:"Debug info"},t);return s.mesh.position.set(0,-1,-2),s}getControllers(){let e=this.icn3d;e.icn3dui;const t=new xe,s=(new THREE.BufferGeometry).setFromPoints([new THREE.Vector3(0,0,0),new THREE.Vector3(0,0,-1)]),i=new THREE.Line(s);i.name="line",i.scale.z=50;const n=[];for(let s=0;s<=1;s++){const l=e.renderer.xr.getController(s);if(!l)continue;e.dolly.add(l),l.add(i.clone()),l.userData.selectPressed=!1,e.cam.add(l),n.push(l);const r=e.renderer.xr.getControllerGrip(s);r.add(t.createControllerModel(r)),e.scene.add(r)}return n}}class Ee{constructor(e){this.icn3d=e}setCamera(){let e=this.icn3d,t=e.icn3dui;if(e.bControlGl&&!t.bNode){window.cam=e.cams[e.opts.camera.toLowerCase()];let s=e.maxD;if(window.cam===e.perspectiveCamera){let i=void 0!==e.biomtMatrices&&e.biomtMatrices.length*e.cnt>e.maxatomcnt;i?window.camMaxDFactor=1:void 0!==window.camMaxDFactorFog?window.camMaxDFactor=window.camMaxDFactorFog:window.camMaxDFactor=3,window.cam_z>0?window.cam.position.z=s*window.camMaxDFactor:window.cam.position.z=-s*window.camMaxDFactor,"yes"===e.opts.slab?i?window.cam.near=.1:void 0!==window.camMaxDFactorFog?window.cam.near=s*window.camMaxDFactorFog-10:window.cam.near=s*window.camMaxDFactor:window.cam.near=.1,window.cam.far=1e4,e.bControlGl&&!t.bNode?window.controls=new THREE.TrackballControls(window.cam,void 0,e):t.bNode?e.controls=new THREE.TrackballControls(e.cam,document,e):e.controls=new THREE.TrackballControls(e.cam,document.getElementById(e.id),e)}else window.cam===e.orthographicCamera&&(void 0!==e.biomtMatrices&&e.biomtMatrices.length*e.cnt>10*e.maxatomcnt?window.cam.right=e.maxD/2*1.5:window.cam.right=e.maxD/2*2.5,window.cam.left=-window.cam.right,window.cam.top=window.cam.right/e.container.whratio,window.cam.bottom=-window.cam.right/e.container.whratio,"yes"===e.opts.slab?window.cam.near=2*e.maxD:window.cam.near=0,window.cam.far=1e4,e.bControlGl&&!t.bNode?window.controls=new THREE.OrthographicTrackballControls(window.cam,void 0,e):t.bNode?e.controls=new THREE.OrthographicTrackballControls(e.cam,document,e):e.controls=new THREE.OrthographicTrackballControls(e.cam,document.getElementById(e.id),e));window.cam.updateProjectionMatrix()}e.cam=e.cams[e.opts.camera.toLowerCase()];let s=e.maxD;if(e.cam===e.perspectiveCamera){let i=void 0!==e.biomtMatrices&&e.biomtMatrices.length*e.cnt>e.maxatomcnt;i?e.camMaxDFactor=1:void 0!==e.camMaxDFactorFog?e.camMaxDFactor=e.camMaxDFactorFog:e.camMaxDFactor=3,e.cam_z>0?e.cam.position.z=s*e.camMaxDFactor:e.cam.position.z=-s*e.camMaxDFactor,"yes"===e.opts.slab?i?e.cam.near=.1:void 0!==e.camMaxDFactorFog?e.cam.near=s*e.camMaxDFactorFog-10:e.cam.near=s*e.camMaxDFactor:e.cam.near=.1,e.cam.far=1e4,e.bControlGl&&!t.bNode?window.controls=new THREE.TrackballControls(e.cam,void 0,e):t.bNode?e.controls=new THREE.TrackballControls(e.cam,document,e):e.controls=new THREE.TrackballControls(e.cam,document.getElementById(e.id),e)}else e.cam===e.orthographicCamera&&(void 0!==e.biomtMatrices&&e.biomtMatrices.length*e.cnt>10*e.maxatomcnt?e.cam.right=e.maxD/2*1.5:e.cam.right=e.maxD/2*2.5,e.cam.left=-e.cam.right,e.cam.top=e.cam.right/e.container.whratio,e.cam.bottom=-e.cam.right/e.container.whratio,"yes"===e.opts.slab?e.cam.near=2*e.maxD:e.cam.near=0,e.cam.far=1e4,e.bControlGl&&!t.bNode?window.controls=new THREE.OrthographicTrackballControls(e.cam,void 0,e):t.bNode?e.controls=new THREE.OrthographicTrackballControls(e.cam,document,e):e.controls=new THREE.OrthographicTrackballControls(e.cam,document.getElementById(e.id),e));e.cam.updateProjectionMatrix()}}class Te{constructor(e){this.icn3d=e}setFog(e){let t=this.icn3d,s=t.icn3dui.parasCls.backgroundColors[t.opts.background.toLowerCase()];if(e){let e=t.applyCenterCls.centerAtoms(t.hAtoms);t.maxD=e.maxD,t.maxD<25&&(t.maxD=25)}let i=void 0!==t.biomtMatrices&&t.biomtMatrices.length*t.cnt>t.maxatomcnt;if("yes"===t.opts.fog)if("perspective"===t.opts.camera)if(i)t.scene.fog=void 0,t.bSetFog=!1;else{let e=t._zoomFactor>1?1*t._zoomFactor:t._zoomFactor;t.scene.fog=new THREE.Fog(s,2.5*t.maxD*e,4*t.maxD*e),t.bSetFog=!0,t.camMaxDFactorFog=3}else"orthographic"===t.opts.camera&&(t.scene.fog=void 0,t.bSetFog=!1);else t.scene.fog=void 0,t.bSetFog=!1}}class Pe{constructor(e){this.icn3d=e}createBox(e,t,s,i,n,l){let r=this.icn3d,o=r.icn3dui;if(o.bNode)return;void 0===t&&(t=.8),void 0===s&&(s=!1),void 0===i&&(i=.8),l?void 0===n&&(n=r.hColor):void 0===n&&(n=e.color);let a=s?t:(o.parasCls.vdwRadii[e.elem.toUpperCase()]||t)*(i||1);this.createBox_base(e.coord,a,n,l)}createBox_base(e,t,s,i,n,l,r){let o,a=this.icn3d;a.icn3dui.bNode||(void 0===r&&(r=l?.5:1),new THREE.BoxGeometry(1,1,1),o=new THREE.Mesh(a.boxGeometry,new THREE.MeshPhongMaterial({transparent:!0,opacity:r,specular:a.frac,shininess:a.shininess,emissive:a.emissive,color:s})),o.scale.x=o.scale.y=o.scale.z=t,o.position.copy(e),a.mdl.add(o),i?a.prevHighlightObjects.push(o):n?a.prevOtherMesh.push(o):a.objects.push(o))}createBoxRepresentation_P_CA(e,t,s){let i=this.icn3d;if(i.icn3dui.bNode)return;let n=this;i.reprSubCls.createRepresentationSub(e,(function(e){"CA"!==e.name&&"O3'"!==e.name&&"O3*"!==e.name||n.createBox(e,void 0,void 0,t,void 0,s)}))}}class De{constructor(e){this.icn3d=e}createBrick(e,t,s,i){let n=this.icn3d;if(n.icn3dui.bNode)return;let l=new THREE.CylinderGeometry(1,1,1,4,1),r=new THREE.Mesh(l,new THREE.MeshPhongMaterial({specular:n.frac,shininess:n.shininess,emissive:n.emissive,color:i}));r.position.copy(e).add(t).multiplyScalar(.5),r.matrixAutoUpdate=!1,r.lookAt(t.clone().sub(e)),r.updateMatrix(),r.matrix.multiply((new THREE.Matrix4).makeScale(s,s,e.distanceTo(t))).multiply((new THREE.Matrix4).makeRotationX(.5*Math.PI)),n.mdl.add(r)}}class Me{constructor(e){this.icn3d=e}createCurveSubArrow(e,t,s,i,n,l,r,o,a,d,c,h,p,m,u){if(this.icn3d.icn3dui.bNode)return;let g=[],f=[];g.push(e),f.push(o),this.prepareStrand(g,f,t,s,i,void 0,n,l,r,a,d,!1,c,h,p,m,u),g=[],f=[]}createStripArrow(e,t,s,i,n,l,r,o,a,d,c,h,p,m,u,g){if(this.icn3d.icn3dui.bNode)return;let f=[],C=[];f.push(e),f.push(t),C.push(o),C.push(a),this.prepareStrand(f,C,void 0,s,i,n,l,void 0,r,d,c,!0,h,p,m,u,g),f=[],C=[]}prepareStrand(e,t,s,i,n,l,r,o,a,d,c,h,p,m,u,g,f){let C=this.icn3d,b=C.icn3dui;if(1===d.length)return;let y=i,v=!u,_=[];_.push(i[i.length-2]),_.push(i[i.length-1]),n=n||C.axisDIV;let w,S,A,x,k=2/(a-1),O={};for(let e=0,s=t.length;e<s;++e)O[e]=[];let R=b.subdivideCls.subdivide(d,i,n,void 0,void 0,g,f)[0];if(1===R.length)return;let I,E=[],T=void 0===u||u?d.length-2:d.length;for(I=0;I<T;++I){for(let s=0,i=t.length;s<i;++s)O[s].push(e[s][I]);E.push(i[I])}if(E.push(i[I]),void 0===u||u)for(let e=0,s=t.length;e<s;++e)w=k*t[e]-1,S=R.length-1-n,A=d.length-2,x=new THREE.Vector3(R[S].x+c[A].x*w,R[S].y+c[A].y*w,R[S].z+c[A].z*w),O[e].push(x);let P,D=[];for(let e=0,s=t.length;e<s;++e)P=b.subdivideCls.subdivide(O[e],E,n,p,r),O[e]=P[0],i=P[2],0===e&&(D=P[1]);if(h?v?C.bDoublecolor?C.stripCls.createStrip(O[0],O[1],y,n,l,r,!0,void 0,m,D,g,f,d,c):C.stripCls.createStrip(O[0],O[1],i,n,l,r,!0,void 0,m,D,g,f,d,c):C.stripCls.createStrip(O[0],O[1],i,n,l,r,!0,void 0,m,D,g,f):C.curveCls.createCurveSub(O[0],s,i,n,r,o,!0,void 0,m,D,g,f),void 0===u||u){E=[],D=[];for(let e=0,s=t.length;e<s;++e){O[e]=[];for(let s=n*(d.length-2),i=n*(d.length-1);p[parseInt(s/n)]&&s<i;s+=n){let i=parseInt(s/n);for(let l=0;l<n;++l){let r=k*t[e]-1;r=r*1.8*(n-l)/n;let o=parseInt(s/n),a=new THREE.Vector3(R[s+l].x+c[o].x*r,R[s+l].y+c[o].y*r,R[s+l].z+c[o].z*r);a.smoothen=!0,O[e].push(a),E.push(_[0]),0===e&&D.push(i)}}let s=0,i=R.length-1,l=d.length-1,r=new THREE.Vector3(R[i].x+c[l].x*s,R[i].y+c[l].y*s,R[i].z+c[l].z*s);r.smoothen=!0,O[e].push(r),E.push(_[1]),0===e&&D.push(i)}R=[],h?C.stripCls.createStrip(O[0],O[1],E,n,l,r,!0,void 0,void 0,D,g,f):C.curveCls.createCurveSub(O[0],s,E,n,r,o,!0,void 0,void 0,D,g,f)}for(let e in O){for(let t=0,s=O[e].length;t<s;++t)O[e][t]=null;O[e]=[]}O={}}}class Fe{constructor(e){this.icn3d=e}createCurveSub(e,t,s,i,n,l,r,o,a,d,c,h){let p,m=this.icn3d,u=m.icn3dui;if(!u.bNode&&0!==e.length){if(i=i||5,r)p=e;else{let t=!0,l=u.subdivideCls.subdivide(e,s,i,o,n,c,h,t);p=l[0],s=l[2]}if(0!==p.length){if(m.stripCls.setCalphaDrawnCoord(p,i,a),1===n){let e=m.coilWidth/2,t=4,s=!1;if(p.length>1)if(void 0!==d){let i,n,l=[];for(let r=0,o=p.length;r<o;++r){if(i=d[r],i!==n&&parseInt(i)!==parseInt(n)+1&&void 0!==n||r===o-1){let i=new THREE.TubeGeometry(new THREE.CatmullRomCurve3(l),l.length,e,t,s),n=new THREE.Mesh(i,m.matShader);n.renderOrder=m.renderOrderPicking,m.mdl.add(n),m.prevHighlightObjects.push(n),i=null,l=[]}l.push(p[r]),n=i}l=[]}else{let i=new THREE.TubeGeometry(new THREE.CatmullRomCurve3(p),p.length,e,t,s),n=new THREE.Mesh(i,m.matShader);n.renderOrder=m.renderOrderPicking,m.mdl.add(n),m.prevHighlightObjects.push(n),i=null}}else{let e,i=new THREE.BufferGeometry,r=[],o=[],a=0;if(2===n&&l)for(let t=0;t<p.length;++t,a+=3)p[t].addScalar(.6),r[a]=p[t].x,r[a+1]=p[t].y,r[a+2]=p[t].z,e=u.parasCls.thr(s[t]),o[a]=e.r,o[a+1]=e.g,o[a+2]=e.b;else for(let t=0;t<p.length;++t,a+=3)r[a]=p[t].x,r[a+1]=p[t].y,r[a+2]=p[t].z,e=u.parasCls.thr(s[t]),o[a]=e.r,o[a+1]=e.g,o[a+2]=e.b;let d=3;i.setAttribute("position",new THREE.BufferAttribute(new Float32Array(r),d)),i.setAttribute("color",new THREE.BufferAttribute(new Float32Array(o),d));let c=new THREE.Line(i,new THREE.LineBasicMaterial({linewidth:t,vertexColors:!0}));m.mdl.add(c),2===n?m.prevHighlightObjects.push(c):m.objects.push(c)}p=null}}}}class He{constructor(e){this.icn3d=e}createCylinder(e,t,s,i,n,l,r,o,a){let d=this.icn3d,c=d.icn3dui;if(c.bNode)return;let h,p=a;void 0===a&&(a=o?.5:1),1===n?(h=new THREE.Mesh(d.cylinderGeometryOutline,d.matShader),h.position.copy(e).add(t).multiplyScalar(.5),h.matrixAutoUpdate=!1,h.lookAt(t.clone().sub(e)),h.updateMatrix(),h.matrix.multiply((new THREE.Matrix4).makeScale(s,s,e.distanceTo(t))).multiply((new THREE.Matrix4).makeRotationX(.5*Math.PI)),h.renderOrder=d.renderOrderPicking,d.mdl.add(h),d.prevHighlightObjects.push(h)):(2===n?(h=new THREE.Mesh(d.cylinderGeometry,new THREE.MeshPhongMaterial({transparent:!0,opacity:a,specular:d.frac,shininess:d.shininess,emissive:d.emissive,color:i})),s*=1.5):h=new THREE.Mesh(d.cylinderGeometry,new THREE.MeshPhongMaterial({transparent:!0,opacity:a,specular:d.frac,shininess:d.shininess,emissive:d.emissive,color:i})),h.position.copy(e).add(t).multiplyScalar(.5),h.matrixAutoUpdate=!1,h.lookAt(t.clone().sub(e)),h.updateMatrix(),h.matrix.multiply((new THREE.Matrix4).makeScale(s,s,e.distanceTo(t))).multiply((new THREE.Matrix4).makeRotationX(.5*Math.PI)),!d.bImpo||p||o?d.mdl.add(h):(d.posArray.push(e.x),d.posArray.push(e.y),d.posArray.push(e.z),i||(i=c.parasCls.thr(16777215)),d.colorArray.push(i.r),d.colorArray.push(i.g),d.colorArray.push(i.b),d.pos2Array.push(t.x),d.pos2Array.push(t.y),d.pos2Array.push(t.z),void 0!==l?(d.color2Array.push(l.r),d.color2Array.push(l.g),d.color2Array.push(l.b)):(d.color2Array.push(i.r),d.color2Array.push(i.g),d.color2Array.push(i.b)),d.radiusArray.push(s),d.cnt<=d.maxatomcnt&&d.mdl_ghost.add(h)),2===n?d.bImpo&&!p?d.cnt<=d.maxatomcnt&&d.prevHighlightObjects_ghost.push(h):d.prevHighlightObjects.push(h):d.bImpo&&!p?d.cnt<=d.maxatomcnt&&d.objects_ghost.push(h):(void 0===r||r)&&d.objects.push(h))}createCylinder_base(e,t,s,i,n,l,r){let o=this.icn3d;if(o.icn3dui.bNode)return;let a=new THREE.Mesh(o.cylinderGeometry,new THREE.MeshPhongMaterial({specular:o.frac,shininess:o.shininess,emissive:o.emissive,color:i}));return a.position.copy(e).add(t).multiplyScalar(.5),a.matrixAutoUpdate=!1,a.lookAt(t.clone().sub(e)),a.updateMatrix(),a.matrix.multiply((new THREE.Matrix4).makeScale(s,s,e.distanceTo(t))).multiply((new THREE.Matrix4).makeRotationX(.5*Math.PI)),a}createCylinderHelix(e,t,s){let i=this.icn3d;if(i.icn3dui.bNode)return;let n,l,r,o=null,a={},d={};for(r in e){let c=e[r];c.het||(("helix"!==c.ss&&"sheet"!==c.ss||c.ssend||c.ssbegin)&&(a[c.serial]=c),"sheet"===c.ss&&(d[c.serial]=c),"CA"===c.name&&("helix"===c.ss&&c.ssend&&(null!==o&&n===c.chain&&parseInt(l)<parseInt(c.resi)&&(1===s||2===s?this.createCylinder(o.coord,c.coord,t,i.hColor,s):this.createCylinder(o.coord,c.coord,t,c.color)),o=null),null===o&&"helix"===c.ss&&c.ssbegin&&(o=c,n=c.chain,l=c.resi)))}1===s||2===s?(Object.keys(a).length>0&&i.tubeCls.createTube(a,"CA",i.coilWidth,s),Object.keys(d).length>0&&i.strandCls.createStrand(d,void 0,void 0,!0,0,i.helixSheetWidth,!1,2*i.ribbonthickness,s)):(Object.keys(a).length>0&&i.tubeCls.createTube(a,"CA",i.coilWidth),Object.keys(d).length>0&&i.strandCls.createStrand(d,void 0,void 0,!0,0,i.helixSheetWidth,!1,2*i.ribbonthickness))}createCylinderCurve(e,t,s,i,n){let l=this.icn3d;if(l.icn3dui.bNode)return;let r,o,a,d,c,h,p=null;for(a in e)if(d=e[a],!d.het&&(c=d.structure+"_"+d.chain,h=d.structure+"_"+r,-1!=t.indexOf(d.name))){if(null!==p&&r===d.chain&&l.ParserUtilsCls.getResiNCBI(h,o)+1===l.ParserUtilsCls.getResiNCBI(c,d.resi)&&Math.abs(p.coord.x-d.coord.x)<8&&Math.abs(p.coord.y-d.coord.y)<8&&Math.abs(p.coord.z-d.coord.z)<8){let e=p.coord.clone().add(d.coord).multiplyScalar(.5);if(n)1===n&&(this.createCylinder(p.coord,e,s,p.color,n),this.createCylinder(e,d.coord,s,d.color,n),l.sphereCls.createSphere(d,s,!0,1,n));else if(i){let t=l.lineCls.createSingleLine(p.coord,e,p.color,!1);l.mdl.add(t),l.objects.push(t),t=l.lineCls.createSingleLine(e,d.coord,d.color,!1),l.mdl.add(t),l.objects.push(t)}else this.createCylinder(p.coord,e,s,p.color),this.createCylinder(e,d.coord,s,d.color),l.sphereCls.createSphere(d,s,!0,1,n)}p=d,r=d.chain,o=d.resi,l.sphereCls.createSphere(d,s,!0,1,n),2===n&&l.boxCls.createBox(d,void 0,void 0,void 0,void 0,n)}if(null!==p&&r===d.chain&&l.ParserUtilsCls.getResiNCBI(h,o)+1===l.ParserUtilsCls.getResiNCBI(c,d.resi)&&Math.abs(p.coord.x-d.coord.x)<8&&Math.abs(p.coord.y-d.coord.y)<8&&Math.abs(p.coord.z-d.coord.z)<8){let e=p.coord.add(d.coord).multiplyScalar(.5);if(n)1===n&&(this.createCylinder(p.coord,e,s,p.color,n),this.createCylinder(e,d.coord,s,d.color,n),l.sphereCls.createSphere(d,s,!0,1,n));else if(i){let t=l.lineCls.createSingleLine(p.coord,e,p.color,!1);l.mdl.add(t),l.objects.push(t),t=l.lineCls.createSingleLine(e,d.coord,d.color,!1),l.mdl.add(t),l.objects.push(t)}else this.createCylinder(p.coord,e,s,p.color),this.createCylinder(e,d.coord,s,d.color)}}}class Le{constructor(e){this.icn3d=e}createLineRepresentation(e,t){let s=this.icn3d;if(s.icn3dui.bNode)return;let i=new THREE.BufferGeometry,n=[],l=[],r=0,o=0;s.reprSubCls.createRepresentationSub(e,void 0,(function(e,t){if(e.color===t.color)n[r++]=e.coord.x,n[r++]=e.coord.y,n[r++]=e.coord.z,n[r++]=t.coord.x,n[r++]=t.coord.y,n[r++]=t.coord.z,l[o++]=e.color.r,l[o++]=e.color.g,l[o++]=e.color.b,l[o++]=t.color.r,l[o++]=t.color.g,l[o++]=t.color.b;else{let s=e.coord.clone().add(t.coord).multiplyScalar(.5);n[r++]=e.coord.x,n[r++]=e.coord.y,n[r++]=e.coord.z,n[r++]=s.x,n[r++]=s.y,n[r++]=s.z,n[r++]=t.coord.x,n[r++]=t.coord.y,n[r++]=t.coord.z,n[r++]=s.x,n[r++]=s.y,n[r++]=s.z,l[o++]=e.color.r,l[o++]=e.color.g,l[o++]=e.color.b,l[o++]=e.color.r,l[o++]=e.color.g,l[o++]=e.color.b,l[o++]=t.color.r,l[o++]=t.color.g,l[o++]=t.color.b,l[o++]=t.color.r,l[o++]=t.color.g,l[o++]=t.color.b}}));if(i.setAttribute("position",new THREE.BufferAttribute(new Float32Array(n),3)),i.setAttribute("color",new THREE.BufferAttribute(new Float32Array(l),3)),2!==t){let e;1===t||(e=new THREE.LineSegments(i,new THREE.LineBasicMaterial({linewidth:s.linewidth,vertexColors:!0})),s.mdl.add(e)),1===t?s.prevHighlightObjects.push(e):s.objects.push(e)}else 2===t&&s.boxCls.createBoxRepresentation_P_CA(e,.8,t)}createConnCalphSidechain(e,t){let s=this.icn3d;if(s.icn3dui.bNode)return;let i={};for(let s in e){let n=e[s];if(!n.het&&n.style2===t){i[n.structure+"_"+n.chain+"_"+n.resi]=1}}let n=[],l=[];for(let e in i){let t=s.firstAtomObjCls.getFirstAtomObjByName(s.residues[e],"CA");if(void 0!==t)for(let e=0,i=t.bonds.length;e<i;++e){let i=s.atoms[t.bonds[e]];"C"!==i.name&&"N"!==i.name&&"H"!==i.elem&&i.resi==t.resi&&(n.push(t.coord),n.push(i.coord),l.push(t.color),l.push(i.color))}}for(let e=0,i=n.length;e<i;e+=2)if("ball and stick"===t||"stick"===t||"ball and stick2"===t||"stick2"===t){let i="stick"===t||"stick2"===t?s.cylinderRadius:.5*s.cylinderRadius;s.cylinderCls.createCylinder(n[e],n[e+1],i,l[e+1])}else if("lines"===t||"lines2"===t){let t=this.createSingleLine(n[e],n[e+1],l[e+1],!1,.5);s.mdl.add(t)}}createSingleLine(e,t,s,i,n){if(this.icn3d.icn3dui.bNode)return;let l,r=new THREE.BufferGeometry,o=[];l=i?new THREE.LineDashedMaterial({linewidth:1,color:s,dashSize:n,gapSize:.5*n}):new THREE.LineBasicMaterial({linewidth:1,color:s}),o[0]=e.x,o[1]=e.y,o[2]=e.z,o[3]=t.x,o[4]=t.y,o[5]=t.z;r.setAttribute("position",new THREE.BufferAttribute(new Float32Array(o),3));let a=new THREE.LineSegments(r,l);return i&&a.computeLineDistances(),a}createLines(e){let t=this.icn3d,s=t.icn3dui;if(!s.bNode&&void 0!==e)for(let i in e){let n=e[i];for(let e=0,l=n.length;e<l;++e){let l=n[e],r=l.position1,o=l.position2,a=!!l.dashed&&l.dashed,d="missingres"==i?.8:.3,c=l.radius?l.radius:t.lineRadius,h=l.opacity?l.opacity:1,p="#"+l.color.replace(/\#/g,""),m=s.parasCls.thr(p);if(a){let e,s,n=r.distanceTo(o),l=parseInt(n/d),a=o.clone().sub(r).multiplyScalar(d/n);for(let n=0;n<l;++n)n%2==1&&(e=r.clone().add(a.clone().multiplyScalar(n)),s=r.clone().add(a.clone().multiplyScalar(n+1)),"stabilizer"==i?t.brickCls.createBrick(e,s,c,m):t.cylinderCls.createCylinder(e,s,c,m,void 0,void 0,void 0,void 0,h))}else"stabilizer"==i?t.brickCls.createBrick(r,o,c,m):t.cylinderCls.createCylinder(r,o,c,m,void 0,void 0,void 0,void 0,h)}}}}class Ne{constructor(e){this.icn3d=e}createRepresentationSub(e,t,s){if(!this.icn3d.icn3dui.bNode)for(let i in e){let n=e[i];t&&t(n);for(let e in n.bonds){let t=this.icn3d.atoms[n.bonds[e]];void 0===t||t.serial<n.serial||t.chain===n.chain&&(t.resi===n.resi||"C"===n.name&&"N"===t.name||"O3'"===n.name&&"P"===t.name||"O3*"===n.name&&"P"===t.name||"SG"===n.name&&"SG"===t.name)&&s&&s(n,t)}}}}class qe{constructor(e){this.icn3d=e}createSphere(e,t,s,i,n){let l=this.icn3d.icn3dui;if(l.bNode)return;void 0===t&&(t=.8),void 0===s&&(s=!1);let r=l.parasCls.vdwRadii[e.elem.toUpperCase()]||t;s&&(r=t,i=1),this.createSphereBase(e.coord,e.color,r,i,n)}createSphereBase(e,t,s,i,n,l,r){let o,a=this.icn3d,d=a.icn3dui;if(d.bNode)return;void 0===i&&(i=1);let c=r;if(void 0===r&&(r=l?.5:1),2===n)i*=1.5,t=a.hColor,o=new THREE.Mesh(a.sphereGeometry,new THREE.MeshPhongMaterial({transparent:!0,opacity:r,specular:a.frac,shininess:a.shininess,emissive:a.emissive,color:t})),o.scale.x=o.scale.y=o.scale.z=s*(i||1),o.position.copy(e),a.mdl.add(o);else if(1===n)o=new THREE.Mesh(a.sphereGeometry,a.matShader),o.scale.x=o.scale.y=o.scale.z=s*(i||1),o.position.copy(e),o.renderOrder=a.renderOrderPicking,a.mdl.add(o);else if(void 0===t&&(t=d.parasCls.defaultAtomColor),o=new THREE.Mesh(a.sphereGeometry,new THREE.MeshPhongMaterial({transparent:!0,opacity:r,specular:a.frac,shininess:a.shininess,emissive:a.emissive,color:t})),o.scale.x=o.scale.y=o.scale.z=s*(i||1),o.position.copy(e),!a.bImpo||c||l)a.mdl.add(o);else{a.posArraySphere.push(e.x),a.posArraySphere.push(e.y),a.posArraySphere.push(e.z),a.colorArraySphere.push(t.r),a.colorArraySphere.push(t.g),a.colorArraySphere.push(t.b);let n=s*(i||1);a.radiusArraySphere.push(n),a.cnt<=a.maxatomcnt&&a.mdl_ghost.add(o)}1===n||2===n?a.bImpo?a.cnt<=a.maxatomcnt&&a.prevHighlightObjects_ghost.push(o):a.prevHighlightObjects.push(o):a.bImpo&&!c?a.cnt<=a.maxatomcnt&&a.objects_ghost.push(o):a.objects.push(o)}createSphereRepresentation(e,t,s,i,n){let l=this.icn3d;if(l.icn3dui.bNode)return;let r=this;l.reprSubCls.createRepresentationSub(e,(function(e){r.createSphere(e,t,s,i,n)}))}}class Ue{constructor(e){this.icn3d=e}createStickRepresentation(e,t,s,i,n,l){let r=this.icn3d;if(r.icn3dui.bNode)return;let o=void 0!==l&&l?t/r.cylinderRadius:1,a=r.cylinderRadius*o*.4,d=r.cylinderRadius*o*.3;r.reprSubCls.createRepresentationSub(e,(function(e){r.sphereCls.createSphere(e,t,!i,i,n)}),(function(e,t){let i=e.coord.clone().add(t.coord).multiplyScalar(.5),l=e.serial+"_"+t.serial;if(r.doublebonds.hasOwnProperty(l)){let s,l,d,c,h=new THREE.Vector3(Math.random(),Math.random(),Math.random());if(1==e.bonds.length&&1==t.bonds.length){c=t.coord.clone(),c.sub(e.coord);let s=h.clone();c.cross(s).normalize().multiplyScalar(.2*o)}else{if(e.bonds.length>=t.bonds.length&&e.bonds.length>1)s=e.serial,l=e.bonds[0],d=e.bonds[1];else{if(!(t.bonds.length>=e.bonds.length&&t.bonds.length>1))return void console.log("Double bond was not drawn due to the undefined cross plane");s=t.serial,l=t.bonds[0],d=t.bonds[1]}let i=r.atoms[s].coord.clone();i.sub(r.atoms[l].coord);let n=r.atoms[s].coord.clone();n.sub(r.atoms[d].coord),i.cross(n),0==parseInt(1e4*i.length())&&(i=new THREE.Vector3(.2,.3,.5)),c=t.coord.clone(),c.sub(e.coord),c.cross(i).normalize().multiplyScalar(.2*o),0==parseInt(1e4*c.length())&&(i=new THREE.Vector3(.5,.3,.2),c.cross(i).normalize().multiplyScalar(.2*o))}e.color===t.color?r.dAtoms.hasOwnProperty(e.serial)&&r.dAtoms.hasOwnProperty(t.serial)&&(r.cylinderCls.createCylinder(e.coord.clone().add(c),t.coord.clone().add(c),a,e.color,n),r.cylinderCls.createCylinder(e.coord.clone().sub(c),t.coord.clone().sub(c),a,e.color,n)):r.bImpo?r.dAtoms.hasOwnProperty(e.serial)&&r.dAtoms.hasOwnProperty(t.serial)&&(r.cylinderCls.createCylinder(e.coord.clone().add(c),t.coord.clone().add(c),a,e.color,n,t.color),r.cylinderCls.createCylinder(e.coord.clone().sub(c),t.coord.clone().sub(c),a,e.color,n,t.color)):r.dAtoms.hasOwnProperty(e.serial)&&r.dAtoms.hasOwnProperty(t.serial)&&(r.cylinderCls.createCylinder(e.coord.clone().add(c),i.clone().add(c),a,e.color,n),r.cylinderCls.createCylinder(t.coord.clone().add(c),i.clone().add(c),a,t.color,n),r.cylinderCls.createCylinder(e.coord.clone().sub(c),i.clone().sub(c),a,e.color,n),r.cylinderCls.createCylinder(t.coord.clone().sub(c),i.clone().sub(c),a,t.color,n))}else if(r.aromaticbonds.hasOwnProperty(l)){let s,l,d;if(e.bonds.length>t.bonds.length&&e.bonds.length>1)s=e.serial,l=e.bonds[0],d=e.bonds[1];else{if(!(t.bonds.length>1))return;s=t.serial,l=t.bonds[0],d=t.bonds[1]}let c=r.atoms[s].coord.clone();c.sub(r.atoms[l].coord);let h=r.atoms[s].coord.clone();h.sub(r.atoms[d].coord),c.cross(h);let p=t.coord.clone();p.sub(e.coord),p.cross(c).normalize().multiplyScalar(.2*o);let m=0;for(let s=0,i=e.bondOrder.length;s<i;++s)"1.5"===e.bondOrder[s]&&e.bonds[s]!==t.serial&&(m=e.bonds[s]);let u="add";if(0===m)u="add";else{let s=e.coord.clone().add(p),i=e.coord.clone().sub(p),n=t.coord.clone().sub(s).normalize(),l=r.atoms[m].coord.clone().sub(s).normalize(),o=t.coord.clone().sub(i).normalize(),a=r.atoms[m].coord.clone().sub(i).normalize();u=Math.acos(n.dot(l))<Math.acos(o.dot(a))?"sub":"add"}if(e.color===t.color){let s,i;"add"===u?(r.cylinderCls.createCylinder(e.coord.clone().sub(p),t.coord.clone().sub(p),a,e.color,n),s=e.coord.clone().add(p),i=t.coord.clone().add(p).sub(s).multiplyScalar(1/11)):(r.cylinderCls.createCylinder(e.coord.clone().add(p),t.coord.clone().add(p),a,e.color,n),s=e.coord.clone().sub(p),i=t.coord.clone().sub(p).sub(s).multiplyScalar(1/11));for(let t=0;t<=10;++t)if(t%2==0){let l=s.clone().add(i.clone().multiplyScalar(t)),o=s.clone().add(i.clone().multiplyScalar(t+1));r.cylinderCls.createCylinder(l,o,a,e.color,n)}}else{let s,l;"add"===u?(r.dAtoms.hasOwnProperty(e.serial)&&r.dAtoms.hasOwnProperty(t.serial)&&(r.cylinderCls.createCylinder(e.coord.clone().sub(p),i.clone().sub(p),a,e.color,n),r.cylinderCls.createCylinder(t.coord.clone().sub(p),i.clone().sub(p),a,t.color,n)),s=e.coord.clone().add(p),l=t.coord.clone().add(p).sub(s).multiplyScalar(1/11)):(r.dAtoms.hasOwnProperty(e.serial)&&r.dAtoms.hasOwnProperty(t.serial)&&(r.cylinderCls.createCylinder(e.coord.clone().add(p),i.clone().add(p),a,e.color,n),r.cylinderCls.createCylinder(t.coord.clone().add(p),i.clone().add(p),a,t.color,n)),s=e.coord.clone().sub(p),l=t.coord.clone().sub(p).sub(s).multiplyScalar(1/11));for(let i=0;i<=10;++i)if(i%2==0&&r.dAtoms.hasOwnProperty(e.serial)&&r.dAtoms.hasOwnProperty(t.serial)){let o=s.clone().add(l.clone().multiplyScalar(i)),d=s.clone().add(l.clone().multiplyScalar(i+1));i<5?r.cylinderCls.createCylinder(o,d,a,e.color,n):r.cylinderCls.createCylinder(o,d,a,t.color,n)}}}else if(r.triplebonds.hasOwnProperty(l)){let s=new THREE.Vector3(Math.random(),Math.random(),Math.random()),l=t.coord.clone();l.sub(e.coord);let a=s.clone();a.cross(l).normalize().multiplyScalar(.3*o),e.color===t.color?r.dAtoms.hasOwnProperty(e.serial)&&r.dAtoms.hasOwnProperty(t.serial)&&(r.cylinderCls.createCylinder(e.coord,t.coord,d,e.color,n),r.cylinderCls.createCylinder(e.coord.clone().add(a),t.coord.clone().add(a),d,e.color,n),r.cylinderCls.createCylinder(e.coord.clone().sub(a),t.coord.clone().sub(a),r.triBondRadius,e.color,n)):r.bImpo?r.dAtoms.hasOwnProperty(e.serial)&&r.dAtoms.hasOwnProperty(t.serial)&&(r.cylinderCls.createCylinder(e.coord,t.coord,d,e.color,n,t.color),r.cylinderCls.createCylinder(e.coord.clone().add(a),t.coord.clone().add(a),d,e.color,n,t.color),r.cylinderCls.createCylinder(e.coord.clone().sub(a),t.coord.clone().sub(a),d,e.color,n,t.color)):r.dAtoms.hasOwnProperty(e.serial)&&r.dAtoms.hasOwnProperty(t.serial)&&(r.cylinderCls.createCylinder(e.coord,i,d,e.color,n),r.cylinderCls.createCylinder(t.coord,i,d,t.color,n),r.cylinderCls.createCylinder(e.coord.clone().add(a),i.clone().add(a),d,e.color,n),r.cylinderCls.createCylinder(t.coord.clone().add(a),i.clone().add(a),d,t.color,n),r.cylinderCls.createCylinder(e.coord.clone().sub(a),i.clone().sub(a),d,e.color,n),r.cylinderCls.createCylinder(t.coord.clone().sub(a),i.clone().sub(a),d,t.color,n))}else e.color===t.color?r.cylinderCls.createCylinder(e.coord,t.coord,s,e.color,n):r.bImpo?r.dAtoms.hasOwnProperty(e.serial)&&r.dAtoms.hasOwnProperty(t.serial)&&r.cylinderCls.createCylinder(e.coord,t.coord,s,e.color,n,t.color):r.dAtoms.hasOwnProperty(e.serial)&&r.dAtoms.hasOwnProperty(t.serial)&&(r.cylinderCls.createCylinder(e.coord,i,s,e.color,n),r.cylinderCls.createCylinder(t.coord,i,s,t.color,n))}))}}class $e{constructor(e){this.icn3d=e}getFirstAtomObj(e){let t=this.icn3d;if(t.icn3dui,void 0===e||0===Object.keys(e).length)return;let s=Object.keys(e)[0];return t.atoms[s]}getMiddleAtomObj(e,t){let s=this.icn3d;if(s.icn3dui,void 0===e||0===Object.keys(e).length)return;let i=Object.keys(e),n=t&&t<i.length?i[t]:i[parseInt(i.length/2)];return s.atoms[n]}getFirstCalphaAtomObj(e){let t,s=this.icn3d;if(s.icn3dui,void 0!==e&&0!==Object.keys(e).length){for(let i in e)if("CA"==s.atoms[i].name){t=i;break}if(!t)for(let i in e)if("O3'"==s.atoms[i].name||"O3*"==s.atoms[i].name){t=i;break}return void 0!==t?s.atoms[t]:this.getFirstAtomObj(e)}}getFirstAtomObjByName(e,t){let s,i=this.icn3d;if(i.icn3dui,void 0===e||0===Object.keys(e).length)return i.atoms[0];for(let n in e)if(i.atoms[n].name==t){s=n;break}return void 0!==s?i.atoms[s]:void 0}getLastAtomObj(e){let t=this.icn3d;if(t.icn3dui,void 0===e||0===Object.keys(e).length)return t.atoms[0];let s=Object.keys(e),i=s[s.length-1];return t.atoms[i]}getResiduesFromAtoms(e){let t=this.icn3d;t.icn3dui;let s={};for(let i in e){s[t.atoms[i].structure+"_"+t.atoms[i].chain+"_"+t.atoms[i].resi]=1}return s}getResiduesFromCalphaAtoms(e){let t=this.icn3d;t.icn3dui;let s={};for(let i in e)if("CA"==t.atoms[i].name&&t.proteins.hasOwnProperty(i)||!t.proteins.hasOwnProperty(i)){s[t.atoms[i].structure+"_"+t.atoms[i].chain+"_"+t.atoms[i].resi]=t.atoms[i].resn}return s}getChainsFromAtoms(e){let t=this.icn3d;t.icn3dui;let s={};for(let i in e){let e=t.atoms[i];s[e.structure+"_"+e.chain]=1}return s}getAtomFromResi(e,t){let s=this.icn3d;if(s.icn3dui,s.residues.hasOwnProperty(e))for(let i in s.residues[e])if(s.atoms[i].name===t&&!s.atoms[i].het)return s.atoms[i]}getAtomCoordFromResi(e,t){this.icn3d.icn3dui;let s=this.getAtomFromResi(e,t);if(void 0!==s){return void 0!==s.coord2?s.coord2:s.coord}}}class Be{constructor(e){this.icn3d=e}createStrip(e,t,s,i,n,l,r,o,a,d,c,h,p,m){let u=this.icn3d,g=u.icn3dui;if(!(g.bNode||e.length<2)){if(i=i||u.axisDIV,p&&u.bDoublecolor){let e=!1,t=g.subdivideCls.subdivide(p,s,i,o,l,c,h,e);p=t[0],this.setCalphaDrawnCoord(p,i,a);for(let e=0,t=m.length;e<t;++e)m[e].normalize();m=g.subdivideCls.subdivide(m,s,i,o,l,c,h,e)[0],s=t[2]}else{if(!r){let n=!1,r=g.subdivideCls.subdivide(e,s,i,o,l,c,h,n),a=g.subdivideCls.subdivide(t,s,i,o,l,c,h,n);e=r[0],t=a[0],s=r[2]}if(e.length<2)return;this.setCalphaDrawnCoord(e,i,a)}if(1===l){let s=u.coilWidth/2,i=4,n=!1;if(void 0!==d){let l,r,o=[],a=[];for(let c=0,h=e.length;c<h;++c){if(l=d[c],l!==r&&parseInt(l)!==parseInt(r)+1&&void 0!==r||c===h-1){let e=new THREE.TubeGeometry(new THREE.CatmullRomCurve3(o),o.length,s,i,n),t=new THREE.Mesh(e,u.matShader);t.renderOrder=u.renderOrderPicking,u.mdl.add(t),u.prevHighlightObjects.push(t),e=null;let l=new THREE.TubeGeometry(new THREE.CatmullRomCurve3(a),a.length,s,i,n);t=new THREE.Mesh(l,u.matShader),t.renderOrder=u.renderOrderPicking,u.mdl.add(t),u.prevHighlightObjects.push(t),l=null,o=[],a=[]}o.push(e[c]),a.push(t[c]),r=l}o=[],a=[]}else{let l=new THREE.TubeGeometry(new THREE.CatmullRomCurve3(e),e.length,s,i,n),r=new THREE.Mesh(l,u.matShader);r.renderOrder=u.renderOrderPicking,u.mdl.add(r),u.prevHighlightObjects.push(r),l=null;let o=new THREE.TubeGeometry(new THREE.CatmullRomCurve3(t),t.length,s,i,n);r=new THREE.Mesh(o,u.matShader),r.renderOrder=u.renderOrderPicking,u.mdl.add(r),u.prevHighlightObjects.push(r),o=null}}else{let i,r,o,a,d,c=new THREE.BufferGeometry,h=[],p=[],m=[],g=0,f=0,C=0;for(let l=0,c=e.length;l<c;++l)if(r=e[l],o=t[l],r&&o){for(let e=0;e<2;++e)h[g++]=r.x,h[g++]=r.y,h[g++]=r.z;for(let e=0;e<2;++e)h[g++]=o.x,h[g++]=o.y,h[g++]=o.z;l<c-1&&(i=t[l].clone().sub(e[l]).cross(e[l+1].clone().sub(e[l])).normalize().multiplyScalar(n)),a=e[l].clone().add(i),d=t[l].clone().add(i);for(let e=0;e<2;++e)h[g++]=a.x,h[g++]=a.y,h[g++]=a.z;for(let e=0;e<2;++e)h[g++]=d.x,h[g++]=d.y,h[g++]=d.z;for(let e=0;e<8;++e){let e=s[l]?s[l]:s[l-1]?s[l-1]:{r:0,g:0,b:0};p[f++]=e.r,p[f++]=e.g,p[f++]=e.b}}let b=[[0,2,-6,-8],[-4,-2,6,4],[7,3,-5,-1],[-3,-7,1,5]];for(let t=1,s=e.length;t<s;++t){let e=8*t;for(let t=0;t<4;++t)m[C++]=e+b[t][0],m[C++]=e+b[t][1],m[C++]=e+b[t][2],m[C++]=e+b[t][3],m[C++]=e+b[t][0],m[C++]=e+b[t][2]}let y,v=3,_=h.length/v-8;for(let t=0;t<4;++t){for(let e=0;e<v;++e)h[g++]=h[2*t*v+e];for(let e=0;e<v;++e)h[g++]=h[(_+2*t)*v+e];if(s[0]){p[f++]=s[0].r,p[f++]=s[0].g,p[f++]=s[0].b;let t=s[e.length-1]?s[e.length-1]:s[e.length-2]?s[e.length-2]:{r:0,g:0,b:0};p[f++]=t.r,p[f++]=t.g,p[f++]=t.b}}_+=8,m[C++]=_,m[C++]=_+2,m[C++]=_+6,m[C++]=_+4,m[C++]=_,m[C++]=_+6,m[C++]=_+1,m[C++]=_+5,m[C++]=_+7,m[C++]=_+3,m[C++]=_+1,m[C++]=_+7,c.setAttribute("position",new THREE.BufferAttribute(new Float32Array(h),v)),c.setAttribute("color",new THREE.BufferAttribute(new Float32Array(p),v)),c.setIndex(new THREE.BufferAttribute(new Uint32Array(m),1)),c.computeVertexNormals(),2===l?(y=new THREE.Mesh(c,new THREE.MeshPhongMaterial({transparent:!0,opacity:.5,specular:u.frac,shininess:u.shininess,emissive:u.emissive,vertexColors:!0,side:THREE.DoubleSide})),u.mdl.add(y),u.prevHighlightObjects.push(y)):(y=new THREE.Mesh(c,new THREE.MeshPhongMaterial({specular:u.frac,shininess:u.shininess,emissive:u.emissive,vertexColors:!0,side:THREE.DoubleSide})),u.mdl.add(y),u.objects.push(y))}e=null,t=null}}setCalphaDrawnCoord(e,t,s){let i=this.icn3d;i.icn3dui;let n=0;if(void 0!==s)for(let l=0,r=e.length;l<r;l+=t){let t=s[n];i.atoms.hasOwnProperty(t)&&(i.atoms[t].coord2=e[l].clone()),++n}}}class je{constructor(e){this.icn3d=e}createTube(e,t,s,i,n,l){let r=this.icn3d;if(r.icn3dui.bNode)return;let o,a,d,c,h,p=[],m=[],u=[],g=[],f=[],C=0,b=[];for(let l in e)if(c=e[l],c.name===t&&!c.het){if(0==C&&(d=c),c.structure,c.chain,(parseInt(c.resi)-1).toString(),C>0&&(o!==c.chain||Math.abs(c.coord.x-h.coord.x)>6||Math.abs(c.coord.y-h.coord.y)>6||Math.abs(c.coord.z-h.coord.z)>6||h.ssbegin||r.ParserUtilsCls.getResiNCBI(c.structure+"_"+o,a)+1<r.ParserUtilsCls.getResiNCBI(c.structure+"_"+c.chain,c.resi)&&(Math.abs(c.coord.x-h.coord.x)>3||Math.abs(c.coord.y-h.coord.y)>3||Math.abs(c.coord.z-h.coord.z)>3))){if(2!==i){if(!isNaN(d.resi)&&!isNaN(h.resi)){let e=d.structure+"_"+d.chain+"_"+(parseInt(d.resi)-1).toString(),i=r.firstAtomObjCls.getAtomCoordFromResi(e,t);g=void 0!==i?[i]:[];let l=h.structure+"_"+h.chain+"_"+(parseInt(h.resi)+1).toString(),o=h.structure+"_"+h.chain+"_"+(parseInt(h.resi)+2).toString(),a=h.structure+"_"+h.chain+"_"+(parseInt(h.resi)+3).toString();if(r.residues.hasOwnProperty(l)){let e=r.firstAtomObjCls.getAtomFromResi(l,t);void 0!==e&&e.ssbegin&&(l=h.structure+"_"+h.chain+"_"+(parseInt(h.resi)+2).toString(),o=h.structure+"_"+h.chain+"_"+(parseInt(h.resi)+3).toString(),p.push(e.coord),n?u.push(this.getCustomtubesize(l)):u.push(this.getRadius(s,e)),m.push(e.color))}if(1==p.length&&r.residues.hasOwnProperty(l)){let e=r.firstAtomObjCls.getAtomFromResi(l,t);if(e){p.push(e.coord),m.push(e.color);let t=this.getRadius(s,c);u.push(t),l=o,o=a}}let C=r.firstAtomObjCls.getAtomCoordFromResi(l,t);void 0!==C&&f.push(C);let b=r.firstAtomObjCls.getAtomCoordFromResi(o,t);void 0!==b&&f.push(b)}b.push({pnts:p,colors:m,radii:u,prevone:g,nexttwo:f})}p=[],m=[],u=[],g=[],f=[],d=c,C=0}if(0==p.length&&!isNaN(c.resi)){let e=c.structure+"_"+c.chain+"_"+(parseInt(c.resi)-1).toString();r.residues.hasOwnProperty(e)&&(h=r.firstAtomObjCls.getAtomFromResi(e,t),void 0!==h&&h.ssend&&(p.push(h.coord),n?u.push(this.getCustomtubesize(e)):u.push(this.getRadius(s,h)),m.push(h.color)))}let e;p.push(c.coord),e=n?this.getCustomtubesize(c.structure+"_"+c.chain+"_"+c.resi):this.getRadius(s,c),u.push(e),m.push(c.color),1===C&&(m[m.length-2]=c.color),o=c.chain,a=c.resi;let l=1.2;2!==i||c.ssbegin||r.boxCls.createBox(c,void 0,void 0,l,void 0,i),++C,h=c}if(2!==i){if(g=[],void 0!==d&&!isNaN(d.resi)){let e=d.structure+"_"+d.chain+"_"+(parseInt(d.resi)-1).toString(),s=r.firstAtomObjCls.getAtomCoordFromResi(e,t);g=void 0!==s?[s]:[]}if(f=[],void 0!==c&&!isNaN(c.resi)){let e=c.structure+"_"+c.chain+"_"+(parseInt(c.resi)+1).toString(),i=c.structure+"_"+c.chain+"_"+(parseInt(c.resi)+2).toString(),n=c.structure+"_"+c.chain+"_"+(parseInt(c.resi)+3).toString();if(1==p.length&&r.residues.hasOwnProperty(e)){let l=r.firstAtomObjCls.getAtomFromResi(e,t);if(l){p.push(l.coord),m.push(l.color);let t=this.getRadius(s,c);u.push(t),e=i,i=n}}let l=r.firstAtomObjCls.getAtomCoordFromResi(e,t);void 0!==l&&f.push(l);let o=r.firstAtomObjCls.getAtomCoordFromResi(i,t);void 0!==o&&f.push(o)}b.push({pnts:p,colors:m,radii:u,prevone:g,nexttwo:f})}for(let e=0,t=b.length;e<t;++e){let t=b[e].pnts,s=b[e].colors,n=b[e].radii,r=b[e].prevone,o=b[e].nexttwo;this.createTubeSub(t,s,n,i,r,o,l)}b=[]}getCustomtubesize(e){let t=this.icn3d;t.icn3dui;let s=e.lastIndexOf("_"),i=e.substr(s+1),n=e.substr(0,s);return t.queryresi2score[n]&&t.queryresi2score[n].hasOwnProperty(i)?.01*t.queryresi2score[n][i]:t.coilWidth}createTubeSub(e,t,s,i,n,l,r){let o=this.icn3d,a=o.icn3dui;if(a.bNode)return;if(e.length<2)return;let d,c,h=o.tubeDIV,p=o.axisDIV,m=1/h,u=1/p,g=new THREE.BufferGeometry,f=[],C=[],b=[],y=0,v=0,_=0,w=a.subdivideCls.subdivide(e,t,p,void 0,void 0,n,l),S=w[0];t=w[2];let A,x=new THREE.Vector3;for(let e=0,i=S.length;e<i;++e){let n,l,o,p,g=(e-1)*u;if(0===e)n=s[0],n>0&&(c=n);else if(g%1==0)n=s[g],n>0&&(c=n);else{let e=Math.floor(g),t=g-e;n=s[e]*(1-t)+s[e+1]*t,r||n<1*c&&(n=0)}e<i-1?(l=S[e].clone().sub(S[e+1]),o=new THREE.Vector3(0,-l.z,l.y).normalize().multiplyScalar(n),p=l.clone().cross(o).normalize().multiplyScalar(n),x.dot(o)<0&&(o.negate(),p.negate()),x=o,A=p):(o=x,p=A);for(let s=0;s<h;++s){let i=2*Math.PI*m*s,n=S[e].clone().add(o.clone().multiplyScalar(Math.cos(i))).add(p.clone().multiplyScalar(Math.sin(i)));f[y++]=n.x,f[y++]=n.y,f[y++]=n.z,d=e==t.length-1&&t.length>1?a.parasCls.thr(t[t.length-2]):a.parasCls.thr(t[e]),C[v++]=d.r,C[v++]=d.g,C[v++]=d.b}}let k,O=0;for(let e=0,t=S.length-1;e<t;++e){let e=0,t=3*O,s=new THREE.Vector3(f[t],f[t+1],f[t+2]);t=3*(O+h);let i=new THREE.Vector3(f[t],f[t+1],f[t+2]);t=3*(O+h+1);let n=new THREE.Vector3(f[t],f[t+1],f[t+2]),l=s.clone().sub(i).lengthSq(),r=s.clone().sub(n).lengthSq();l>r&&(l=r,e=1);for(let t=0;t<h;++t)b[_++]=O+t,b[_++]=O+(t+e)%h+h,b[_++]=O+(t+1)%h,b[_++]=O+(t+1)%h,b[_++]=O+(t+e)%h+h,b[_++]=O+(t+e+1)%h+h;O+=h}g.setAttribute("position",new THREE.BufferAttribute(new Float32Array(f),3)),g.setAttribute("color",new THREE.BufferAttribute(new Float32Array(C),3)),g.setIndex(new THREE.BufferAttribute(new Uint32Array(b),1)),g.computeVertexNormals(),2===i?(k=new THREE.Mesh(g,new THREE.MeshPhongMaterial({transparent:!0,opacity:.5,specular:o.frac,shininess:o.shininess,emissive:o.emissive,vertexColors:!0,side:THREE.DoubleSide})),o.mdl&&o.mdl.add(k)):1===i?(k=new THREE.Mesh(g,o.matShader),k.renderOrder=o.renderOrderPicking,o.mdl&&o.mdl.add(k)):(k=new THREE.Mesh(g,new THREE.MeshPhongMaterial({specular:o.frac,shininess:o.shininess,emissive:o.emissive,vertexColors:!0,side:THREE.DoubleSide})),o.mdl&&o.mdl.add(k)),1===i||2===i?o.prevHighlightObjects.push(k):o.objects.push(k)}getRadius(e,t){let s=this.icn3d;s.icn3dui;let i=e;return i=e||(t.b>0&&t.b<=100?.01*t.b:t.b>100?1:s.coilWidth),i}}class ze{constructor(e){this.icn3d=e}createStrand(e,t,s,i,n,l,r,o,a){let d=this.icn3d,c=d.icn3dui;if(c.bNode)return;let h=!!i,p={};p=Object.keys(e).length<Object.keys(d.atoms).length?this.getSSExpandedAtoms(e):e,2===a&&(i?(i=!1,t=null,s=null,n=null,l=null,o=void 0):(i=!0,t=2,s=void 0,n=void 0,l=void 0,o=d.ribbonthickness)),t=t||d.strandDIV,s=s||d.axisDIV,n=n||d.coilWidth,r=r||!1,l=l||d.helixSheetWidth;let m={};for(let e=0;e<t;++e)m[e]=[];let u,g,f,C=[],b=[],y=[],v=[],_=[],w=null,S=null,A=null,x=null,k=null,O=null,R=null,I=null,E=!1,T=null,P=null,D=null,M=null,F=null,H=!1,L=!1,N={};d.bCalphaOnly=c.utilsCls.isCalphaPhosOnly(p);let q={};for(let e in p){let t=p[e];q[t.structure+"_"+t.chain+"_"+t.resi]=1}let U=Object.keys(q).length,$=0,B=Object.keys(d.hAtoms).length==Object.keys(d.atoms).length,j=[];for(let c in p)if(f=p[c],("O"===f.name||"CA"===f.name)&&!f.het&&("CA"===f.name&&(e.hasOwnProperty(c)&&("helix"!==f.ss&&"sheet"!==f.ss||f.ssend||f.ssbegin)&&(N[c]=f),w=f.coord,A=f.color,M=f.serial,j.push(f.serial)),"O"===f.name||d.bCalphaOnly&&"CA"===f.name)){null==w&&(w=f.coord,A=f.color,M=f.serial),"O"===f.name&&(S=f.coord);let c=!0;if(u!==f.chain&&(c=!1),f.ssend&&"sheet"===f.ss?H=!0:f.ssend&&"helix"===f.ss&&(L=!0),k){1===a||2===a?_.push(d.hColor):_.push(O),g="coil"!==I&&"coil"===f.ss||E&&f.ssbegin||"coil"===I?n:l;let s,i,o=4;"O"===f.name?(s=k.clone(),null!=x?s.sub(x):(x=k.clone(),j.length>o+1?(s=x.clone(),i=d.atoms[j[j.length-1-o-1]].coord.clone(),i.sub(s)):s=new THREE.Vector3(Math.random(),Math.random(),Math.random()))):d.bCalphaOnly&&"CA"===f.name&&(j.length>o+1?(s=x.clone(),i=d.atoms[j[j.length-1-o-1]].coord.clone(),i.sub(s)):s=new THREE.Vector3(Math.random(),Math.random(),Math.random())),s.normalize(),s.multiplyScalar(g),null!==R&&s.dot(R)<0&&s.negate(),R=s;for(let e=0,s=2/(t-1);e<t;++e){let t=s*e-1,i=new THREE.Vector3(x.x+R.x*t,x.y+R.y*t,x.z+R.z*t);r||"sheet"!==I||(i.smoothen=!0),m[e].push(i)}C.push(x),b.push(R),e.hasOwnProperty(P)?(y.push(D),v.push(F)):(y.push(0),v.push(0)),++$}let p=6,N=x&&Math.abs(w.x-x.x)>p||x&&Math.abs(w.y-x.y)>p||x&&Math.abs(w.z-x.z)>p;if((f.ssbegin||f.ssend||$===U-1||N)&&m[0].length>0&&c){let c="CA",p=[],u=[];if(isNaN(d.atoms[P].resi))p=[];else{let e=d.atoms[P].structure+"_"+d.atoms[P].chain+"_"+(parseInt(d.atoms[P].resi)-1).toString(),t=d.firstAtomObjCls.getAtomCoordFromResi(e,c);p=void 0!==t?[t]:[]}if(!isNaN(d.atoms[P].resi)){let e=d.atoms[P].structure+"_"+d.atoms[P].chain+"_"+(parseInt(d.atoms[P].resi)+1).toString(),t=d.firstAtomObjCls.getAtomCoordFromResi(e,c);void 0!==t&&u.push(t);let s=d.atoms[P].structure+"_"+d.atoms[P].chain+"_"+(parseInt(d.atoms[P].resi)+2).toString(),i=d.firstAtomObjCls.getAtomCoordFromResi(s,c);void 0!==i&&u.push(i)}if(!N){1===a||2===a?_.push(d.hColor):_.push(O),g=f.ssend&&"sheet"===f.ss?0:"coil"===I&&f.ssbegin||E&&f.ssbegin||"coil"===f.ss?n:l;let s,i,o=4;"O"===f.name?(s=S.clone(),s.sub(w)):d.bCalphaOnly&&"CA"===f.name&&(j.length>o?(s=w.clone(),i=d.atoms[j[j.length-1-o]].coord.clone(),i.sub(s)):s=new THREE.Vector3(Math.random(),Math.random(),Math.random())),s.normalize(),s.multiplyScalar(g),null!==R&&s.dot(R)<0&&s.negate(),R=s;for(let e=0,s=2/(t-1);e<t;++e){let t=s*e-1,i=new THREE.Vector3(w.x+R.x*t,w.y+R.y*t,w.z+R.z*t);r||"sheet"!==I||(i.smoothen=!0),m[e].push(i)}T=f.serial,C.push(w),b.push(R),e.hasOwnProperty(T)?(y.push(f.resi),v.push(M)):(y.push(0),v.push(0))}for(let e=0;!i&&e<t;++e)H?d.curveStripArrowCls.createCurveSubArrow(m[e],1,_,s,a,h,t,e,C,b,y,v,!0,p,u):L&&(B?d.curveCls.createCurveSub(m[e],1,_,s,a,h,!1,y,v,void 0,p,u):d.curveStripArrowCls.createCurveSubArrow(m[e],1,_,s,a,h,t,e,C,b,y,v,!1,p,u));if(i)if(H){let e=0,i=t-1;d.curveStripArrowCls.createStripArrow(m[0],m[t-1],_,s,o,a,t,e,i,C,b,y,v,!0,p,u)}else if(L)if(B)d.stripCls.createStrip(m[0],m[t-1],_,s,o,a,!1,y,v,void 0,p,u,C,b);else{let e=0,i=t-1;d.curveStripArrowCls.createStripArrow(m[0],m[t-1],_,s,o,a,t,e,i,C,b,y,v,!1,p,u)}else 2===a&&d.stripCls.createStrip(m[0],m[t-1],_,s,o,a,!1,y,v,void 0,p,u,C,b);for(let e=0;e<t;++e)m[e]=[];_=[],C=[],b=[],y=[],v=[],H=!1,L=!1}if(u!==f.chain&&m[0].length>0){let e="CA",n=[],l=[];if(isNaN(d.atoms[P].resi))n=[];else{let t=d.atoms[P].structure+"_"+d.atoms[P].chain+"_"+(parseInt(d.atoms[P].resi)-1).toString();d.firstAtomObjCls.getAtomCoordFromResi(t,e)}for(let e=0;!i&&e<t;++e)H?d.curveStripArrowCls.createCurveSubArrow(m[e],1,_,s,a,h,t,e,C,b,y,v,!0,n,l):L&&(B?d.curveCls.createCurveSub(m[e],1,_,s,a,h,!1,y,v,void 0,n,l):d.curveStripArrowCls.createCurveSubArrow(m[e],1,_,s,a,h,t,e,C,b,y,v,!1,n,l));if(i)if(H){let e=0,i=t-1;d.curveStripArrowCls.createStripArrow(m[0],m[t-1],_,s,o,a,t,e,i,C,b,y,v,!0,n,l)}else if(L)if(B)d.stripCls.createStrip(m[0],m[t-1],_,s,o,a,!1,y,v,void 0,n,l,C,b);else{let e=0,i=t-1;d.curveStripArrowCls.createStripArrow(m[0],m[t-1],_,s,o,a,t,e,i,C,b,y,v,!1,n,l)}for(let e=0;e<t;++e)m[e]=[];_=[],C=[],b=[],y=[],v=[],H=!1,L=!1}u=f.chain,f.resi,I=f.ss,E=f.ssend,P=f.serial,D=f.resi,F=M,x=w,k=f.coord,O=A}j=[],d.tubeCls.createTube(N,"CA",n,a),N={},m={}}getSSExpandedAtoms(e,t){let s,i,n,l,r,o,a,d,c=this.icn3d,h=c.icn3dui,p=0,m=Object.keys(e).length,u=h.hashUtilsCls.cloneHash(e);for(let g in e){if(s=e[g].structure+"_"+e[g].chain,i=e[g].resi,n=e[g],void 0===l&&(a=e[g]),s!==l&&void 0!==l||i!==r&&i!==parseInt(r)+1&&void 0!==r||p===m-1){s!==l&&void 0!==l||i!==r&&i!==parseInt(r)+1&&void 0!==r?d=o:p===m-1&&(d=n);let g=a.resi;if(!isNaN(a.resi)&&"coil"!==a.ss&&!a.ssbegin){for(let e=parseInt(a.resi)-1;e>0;--e){let t=a.structure+"_"+a.chain+"_"+e;if(!c.residues.hasOwnProperty(t))break;let s=c.firstAtomObjCls.getFirstCalphaAtomObj(c.residues[t]);if(s.ss===a.ss&&s.ssbegin){g=s.resi;break}}for(let e=g;e<a.resi;++e){let t=a.structure+"_"+a.chain+"_"+e;u=h.hashUtilsCls.unionHash(u,h.hashUtilsCls.hash2Atoms(c.residues[t],c.atoms))}}if(!isNaN(a.resi)&&3===c.pk&&1===t&&"coil"===a.ss){let t=a.structure+"_"+a.chain+"_"+(parseInt(a.resi)-1).toString();c.residues.hasOwnProperty(t)&&(u=h.hashUtilsCls.unionHash(u,h.hashUtilsCls.hash2Atoms(c.residues[t],c.atoms)),e=h.hashUtilsCls.unionHash(e,h.hashUtilsCls.hash2Atoms(c.residues[t],c.atoms)))}let f=d.resi;if(void 0!==d.ss&&"coil"!==d.ss&&!d.ssend&&!d.notshow){let e=c.firstAtomObjCls.getLastAtomObj(c.chains[d.structure+"_"+d.chain]).resi;for(let t=parseInt(d.resi)+1;t<=parseInt(e);++t){let e=d.structure+"_"+d.chain+"_"+t;if(!c.residues.hasOwnProperty(e))break;let s=c.firstAtomObjCls.getFirstCalphaAtomObj(c.residues[e]);if(s.ss===d.ss&&s.ssend){f=s.resi;break}}for(let e=parseInt(d.resi)+1;e<=parseInt(f);++e){let t=d.structure+"_"+d.chain+"_"+e;u=h.hashUtilsCls.unionHash(u,h.hashUtilsCls.hash2Atoms(c.residues[t],c.atoms))}}if(3===c.pk&&1===t&&"coil"===d.ss){let t=d.structure+"_"+d.chain+"_"+(parseInt(d.resi)+1).toString();c.residues.hasOwnProperty(t)&&(u=h.hashUtilsCls.unionHash(u,h.hashUtilsCls.hash2Atoms(c.residues[t],c.atoms)),e=h.hashUtilsCls.unionHash(e,h.hashUtilsCls.hash2Atoms(c.residues[t],c.atoms)))}d.notshow&&(d.notshow=void 0),a=n}l=s,r=i,o=n,++p}return u}}class Ge{constructor(e){this.icn3d=e}drawCartoonNucleicAcid(e,t,s,i){this.drawStrandNucleicAcid(e,2,t,!0,void 0,s,i)}drawStrandNucleicAcid(e,t,s,i,n,l,r){let o,a,d,c=this.icn3d;if(c.icn3dui.bNode)return;2===r&&(t=void 0,l=void 0),n=n||c.nucleicAcidWidth,s=s||c.axisDIV,t=t||c.nucleicAcidStrandDIV;let h=[];for(d=0;d<t;d++)h[d]=[];let p,m,u,g=[],f=null;for(o in e){let C=e[o];if(void 0===C)continue;let b=C.structure+"_"+C.chain,y=C.structure+"_"+p;if(("O3'"===C.name||"OP2"===C.name||"O3*"===C.name||"O2P"===C.name)&&!C.het)if("O3'"===C.name||"O3*"===C.name){if(p!==C.chain||c.ParserUtilsCls.getResiNCBI(y,m)+1!==c.ParserUtilsCls.getResiNCBI(b,C.resi)){if(u&&f)for(a=0;a<t;a++){let e=2/(t-1)*a-1;h[a].push(new THREE.Vector3(u.x+f.x*e,u.y+f.y*e,u.z+f.z*e))}for(i&&c.stripCls.createStrip(h[0],h[1],g,s,l,r),a=0;!l&&a<t;a++)c.curveCls.createCurveSub(h[a],1,g,s,r);for(h=[],d=0;d<t;d++)h[d]=[];g=[],f=null}u=new THREE.Vector3(C.coord.x,C.coord.y,C.coord.z),p=C.chain,m=C.resi,1===r||2===r?g.push(c.hColor):g.push(C.color)}else if("OP2"===C.name||"O2P"===C.name){if(!u){f=null;continue}let e=new THREE.Vector3(C.coord.x,C.coord.y,C.coord.z);for(e.sub(u),e.normalize().multiplyScalar(n),null!==f&&e.dot(f)<0&&e.negate(),f=e,a=0;a<t;a++){let e=2/(t-1)*a-1;h[a].push(new THREE.Vector3(u.x+f.x*e,u.y+f.y*e,u.z+f.z*e))}u=null}}if(u&&f)for(a=0;a<t;a++){let e=2/(t-1)*a-1;h[a].push(new THREE.Vector3(u.x+f.x*e,u.y+f.y*e,u.z+f.z*e))}for(i&&c.stripCls.createStrip(h[0],h[1],g,s,l,r),a=0;!l&&a<t;a++)c.curveCls.createCurveSub(h[a],1,g,s,r)}drawNucleicAcidStick(e,t){let s=this.icn3d;if(s.icn3dui.bNode)return;let i,n,l,r=null,o=null;for(l in e){let a=e[l];void 0===a||a.het||(a.resi===n&&a.chain===i||(null!==r&&null!==o&&s.cylinderCls.createCylinder(new THREE.Vector3(r.coord.x,r.coord.y,r.coord.z),new THREE.Vector3(o.coord.x,o.coord.y,o.coord.z),s.cylinderRadius,r.color,t),r=null,o=null),"O3'"!==a.name&&"O3*"!==a.name||(r=a),"A"===a.resn.trim()||"G"===a.resn.trim()||"DA"===a.resn.trim()||"DG"===a.resn.trim()?"N9"===a.name&&(o=a):"N1"===a.name&&(o=a),n=a.resi,i=a.chain)}null!==r&&null!==o&&s.cylinderCls.createCylinder(new THREE.Vector3(r.coord.x,r.coord.y,r.coord.z),new THREE.Vector3(o.coord.x,o.coord.y,o.coord.z),s.cylinderRadius,r.color,t)}}class Ve{constructor(e){this.icn3d=e}makeTextSprite(e,t){let s=this.icn3d,i=s.icn3dui;if(i.bNode)return;void 0===t&&(t={});let n,l,r,o=t.hasOwnProperty("fontface")?t.fontface:"Arial",a=t.hasOwnProperty("fontsize")?t.fontsize:18,d=t.hasOwnProperty("factor")?t.factor:1,c=t.hasOwnProperty("alpha")?t.alpha:1,h=!1,p=!1;t.hasOwnProperty("bSchematic")&&t.bSchematic&&(p=!0,h=!0,a=40),t.hasOwnProperty("backgroundColor")&&void 0!==t.backgroundColor?(n=i.utilsCls.hexToRgb(t.backgroundColor,c),l=t.hasOwnProperty("borderColor")?i.utilsCls.hexToRgb(t.borderColor,c):{r:0,g:0,b:0,a:1},r=t.hasOwnProperty("borderThickness")?t.borderThickness:4):(h=!1,n=void 0,l=void 0,r=0);let m="black"!=s.opts.background?{r:0,g:0,b:0,a:1}:{r:255,g:255,b:0,a:1},u=t.hasOwnProperty("textColor")&&void 0!==t.textColor?i.utilsCls.hexToRgb(t.textColor,1):m;u||(u=m);let g=document.createElement("canvas"),f=g.getContext("2d");f.font="Bold "+a+"px "+o;let C=f.measureText(e).width,b=C+2*r,y=a+2*r;p&&(b>y?y=b:b=y);let v=.8*C/y;if(g.width=b,g.height=y,f.clearRect(0,0,b,y),h)if(f.fillStyle="rgba("+n.r+","+n.g+","+n.b+","+n.a+")",f.strokeStyle="rgba("+l.r+","+l.g+","+l.b+","+l.a+")",f.lineWidth=r,p){let e=.4*b;this.circle(f,0,0,b,y,e)}else{let e=0;this.roundRect(f,0,0,b,y,e)}f.font="Bold "+a+"px "+o,f.textAlign="center",f.textBaseline="middle",f.fillStyle="rgba("+u.r+", "+u.g+", "+u.b+", 1.0)",f.strokeStyle="rgba("+u.r+", "+u.g+", "+u.b+", 1.0)",f.fillText(e,.5*b,.5*y);let _=new THREE.Texture(g);_.needsUpdate=!0;let w=new THREE.SpriteMaterial({map:_,depthTest:!1,depthWrite:!1});w.map.minFilter=THREE.LinearFilter;let S=new THREE.Sprite(w);return p?S.scale.set(.3*d,.3*d,1):S.scale.set(v*d,d,1),S.renderOrder=1,S}roundRect(e,t,s,i,n,l){e.beginPath(),e.moveTo(t+l,s),e.lineTo(t+i-l,s),e.quadraticCurveTo(t+i,s,t+i,s+l),e.lineTo(t+i,s+n-l),e.quadraticCurveTo(t+i,s+n,t+i-l,s+n),e.lineTo(t+l,s+n),e.quadraticCurveTo(t,s+n,t,s+n-l),e.lineTo(t,s+l),e.quadraticCurveTo(t,s,t+l,s),e.closePath(),e.fill(),e.stroke()}circle(e,t,s,i,n,l){e.beginPath(),e.arc(t+i/2,.9*(s+n/2),l,0,2*Math.PI,!0),e.closePath(),e.fill(),e.stroke()}}class We{constructor(e){this.icn3d=e,this.textSpriteCls=new Ve(e)}createLabelRepresentation(e){let t=this.icn3d;t.icn3dui;let s=t.oriMaxD/100;s<.4&&(s=.4);let i=3*s*t.labelScale;for(let s in e){let n=void 0!==e[s]?e[s]:[],l="black"!=t.opts.background?t.colorWhitebkgd:t.colorBlackbkgd;for(let e=0,r=n.length;e<r;++e){let r=n[e];0==r.size&&(r.size=void 0),0==r.color&&(r.color=void 0),0==r.background&&(r.background=void 0);let o=void 0!==r.size?r.size:t.LABELSIZE,a=void 0!==r.color?r.color:l;t.labelcolor&&(a=t.labelcolor);let d,c=void 0!==r.background?r.background:"#cccccc",h=void 0!==r.alpha?r.alpha:1;if(c=r.background,void 0!==a&&void 0!==c&&a.toLowerCase()===c.toString().toLowerCase()&&(a="#888888"),void 0!==r.bSchematic&&r.bSchematic)d=this.textSpriteCls.makeTextSprite(r.text,{fontsize:parseInt(o),textColor:a,borderColor:c,backgroundColor:c,alpha:h,bSchematic:1,factor:i});else if(1===r.text.length)d=this.textSpriteCls.makeTextSprite(r.text,{fontsize:parseInt(o),textColor:a,borderColor:c,backgroundColor:c,alpha:h,bSchematic:1,factor:i});else{let e=r.factor?i*r.factor:i;d=this.textSpriteCls.makeTextSprite(r.text,{fontsize:parseInt(o),textColor:a,borderColor:c,backgroundColor:c,alpha:h,bSchematic:0,factor:e})}let p="schematic"==s||"residue"==s?0:t.coilWidth;d.position.set(parseFloat(r.position.x)+p,parseFloat(r.position.y)+p,parseFloat(r.position.z)+p),t.mdl.add(d)}}}hideLabels(){let e=this.icn3d;if(e.icn3dui,void 0!==e.mdl)for(let t=0,s=e.mdl.children.length;t<s;++t){let s=e.mdl.children[t];void 0!==s&&"Sprite"===s.type&&e.mdl.remove(s)}}}class Ye{constructor(e){this.icn3d=e}buildAxes(e,t,s,i,n,l){let r=this.icn3d,o=r.icn3dui;if(o.bNode)return;new THREE.Object3D;let a=0,d=0,c=0;l?(a=t.x,d=t.y,c=t.z):(a-=.3*e,d-=.3*e);let h,p,m,u,g,f,C,b,y,v=new THREE.Vector3(a,d,c),_=e/10,w=e/100;u=g=f=_,l&&(h=s.clone().sub(t),p=i.clone().sub(t),m=n.clone().sub(t),u=h.length(),g=p.length(),f=m.length(),w=u/100,w<.4&&(w=.4)),l?(C=r.cylinderCls.createCylinder_base(t,s,w,o.parasCls.thr(16711680)),b=r.cylinderCls.createCylinder_base(t,i,w,o.parasCls.thr(65280)),y=r.cylinderCls.createCylinder_base(t,n,w,o.parasCls.thr(255))):(C=r.cylinderCls.createCylinder_base(new THREE.Vector3(a,d,c),new THREE.Vector3(a+u,d,c),w,o.parasCls.thr(16711680)),b=r.cylinderCls.createCylinder_base(new THREE.Vector3(a,d,c),new THREE.Vector3(a,d+g,c),w,o.parasCls.thr(65280)),y=r.cylinderCls.createCylinder_base(new THREE.Vector3(a,d,c),new THREE.Vector3(a,d,c+f),w,o.parasCls.thr(255))),r.mdl.add(C),r.mdl.add(b),r.mdl.add(y);let S=l?h.normalize():new THREE.Vector3(1,0,0),A=l?s:new THREE.Vector3(v.x+_,v.y,v.z),x=this.createArrow(S,A,u,16711680,4*w,4*w);r.mdl.add(x);let k=l?p.normalize():new THREE.Vector3(0,1,0),O=l?i:new THREE.Vector3(v.x,v.y+_,v.z),R=this.createArrow(k,O,g,65280,4*w,4*w);r.mdl.add(R);let I=l?m.normalize():new THREE.Vector3(0,0,1),E=l?n:new THREE.Vector3(v.x,v.y,v.z+_),T=this.createArrow(I,E,f,255,4*w,4*w);r.mdl.add(T)}buildAllAxes(e,t){let s=this.icn3d;if(!s.icn3dui.bNode&&s.pc1)for(let i=0,n=s.axes.length;i<n;++i){let n=s.axes[i][0],l=s.axes[i][1],r=s.axes[i][2],o=s.axes[i][3];this.buildAxes(e,n,l,r,o,t)}}createArrow(e,t,s,i,n,l,r){let o=this.icn3d;if(o.icn3dui.bNode)return;let a,d=new THREE.CylinderGeometry(0,.5,1,32,1);d.translate(0,.5,0),a=r?new THREE.MeshPhongMaterial({transparent:!0,opacity:.5,specular:o.frac,shininess:o.shininess,emissive:o.emissive,color:i}):new THREE.MeshPhongMaterial({specular:o.frac,shininess:o.shininess,emissive:o.emissive,side:THREE.DoubleSide,color:i});let c=new THREE.Mesh(d,a),h=new THREE.Quaternion;if(e.y>.99999)h.set(0,0,0,1);else if(e.y<-.99999)h.set(1,0,0,0);else{let t=new THREE.Vector3;t.set(e.z,0,-e.x).normalize();let s=Math.acos(e.y);h.setFromAxisAngle(t,s)}return c.applyQuaternion(h),c.scale.set(l,n,l),c.position.copy(t),c}setPc1Axes(e){let t=this.icn3d,s=t.icn3dui;if(s.bNode)return;let i=s.hashUtilsCls.intHash(t.hAtoms,t.dAtoms),n=[],l=Object.keys(i).length<100;for(let e in i){let s=t.atoms[e],i=s.structure+"_"+s.chain+"_"+s.resi;(l||""!=i)&&n.push(s.coord.clone())}let r=s.rmsdSuprCls.getEigenForSelection(n,n.length),o=new THREE.Vector3(r.h1[0],r.h1[1],r.h1[2]);if(0==r.k&&t.bRender)return void alert("Can't determine the first principal component. Please select a subset and try it again.");let a=t.applyCenterCls.centerAtoms(i),d=a.maxD,c=a.center,h=c.clone().add(o.normalize().multiplyScalar(.4*d)),p=o.normalize();if(s.htmlCls.clickMenuCls.setLogCmd("Principle X-Axis: "+p.x.toFixed(3)+" "+p.y.toFixed(3)+" "+p.z.toFixed(3),!1),e)return p;let m=new THREE.Vector3(r.h2[0],r.h2[1],r.h2[2]),u=c.clone().add(m.normalize().multiplyScalar(.3*d)),g=new THREE.Vector3(r.h3[0],r.h3[1],r.h3[2]),f=c.clone().add(g.normalize().multiplyScalar(.3*d));this.buildAxes(void 0,c,h,u,f,!0);let C=[c,h,u,f];return t.axes.push(C),t.drawCls.draw(),C}}class Xe{constructor(e){this.icn3d=e}showGlycans(){let e=this.icn3d,t=e.icn3dui;if(t.bNode)return;let s={},i=e.dAtoms;for(let n in i){let i=e.atoms[n];i.het&&-1!=t.parasCls.glycanHash.hasOwnProperty(i.resn)&&(void 0===s[i.resn]&&(s[i.resn]={}),"Misc"!=i.chain&&(s[i.resn][i.structure+"_"+i.chain+"_"+i.resi]=1))}let n=Object.keys(s);for(let i=0,l=n.length;i<l;++i){let l=n[i];if(!t.parasCls.glycanHash.hasOwnProperty(l))continue;let r=t.parasCls.glycanHash[l].s,o=new THREE.Color("#"+t.parasCls.glycanHash[l].c),a=Object.keys(s[l]);for(let t=0,s=a.length;t<s;++t){let s=e.applyCenterCls.centerAtoms(e.residues[a[t]]),i=s.center,n=.5*s.maxD*.6;if("cube"==r)e.boxCls.createBox_base(i,n,o,!1,!1,!0);else if("sphere"==r)e.sphereCls.createSphereBase(i,o,n,1,!1,!0);else if("cone"==r){let t=new THREE.Vector3(0,0,1),s=e.axesCls.createArrow(t,new THREE.Vector3(0,0,-1*n).add(i),0,o,2*n,2*n,!0);e.mdl.add(s),e.objects.push(s)}else if("cylinder"==r){let t=new THREE.Vector3(0,0,n).add(i),s=new THREE.Vector3(0,0,-1*n).add(i);e.cylinderCls.createCylinder(t,s,n,o,!1,o,!1,!0)}}}}}class Ke{constructor(e){this.icn3d=e,this.ISDONE=2;this.edgeTable=new Uint32Array([0,0,0,0,0,0,0,2816,0,0,0,1792,0,3328,3584,3840,0,0,0,138,0,21,0,134,0,0,0,652,0,2067,3865,3600,0,0,0,42,0,0,0,294,0,0,21,28,0,3875,1049,3360,0,168,162,170,0,645,2475,2210,0,687,293,172,4010,3747,3497,3232,0,0,0,0,0,69,0,900,0,0,0,1792,138,131,1608,1920,0,81,0,2074,84,85,84,86,0,81,0,3676,330,1105,1881,1616,0,0,0,42,0,69,0,502,0,0,21,3580,138,2035,1273,1520,2816,104,2337,106,840,581,367,102,2816,3695,3429,3180,1898,1635,1385,1120,0,0,0,0,0,0,0,3910,0,0,69,588,42,2083,41,2880,0,0,0,1722,0,2293,4095,3830,0,255,757,764,2538,2291,3065,2800,0,0,81,338,0,3925,1119,3414,84,855,85,340,2130,2899,89,2384,1792,712,194,1162,4036,3781,3535,3270,708,719,197,204,3018,2755,2505,2240,0,0,0,0,168,420,168,1958,162,162,676,2988,170,163,680,928,3328,3096,3328,3642,52,53,1855,1590,2340,2111,2869,2620,298,51,825,560,3584,3584,3090,3482,1668,1941,1183,1430,146,2975,2069,2460,154,915,153,400,3840,3592,3329,3082,1796,1541,1295,1030,2818,2575,2309,2060,778,515,265,0]),this.triTable=[[],[],[],[],[],[],[],[11,9,8],[],[],[],[8,10,9],[],[10,8,11],[9,11,10],[8,10,9,8,11,10],[],[],[],[1,7,3],[],[4,2,0],[],[2,1,7],[],[],[],[2,7,3,2,9,7],[],[1,4,11,1,0,4],[3,8,0,11,9,4,11,10,9],[4,11,9,11,10,9],[],[],[],[5,3,1],[],[],[],[2,5,8,2,1,5],[],[],[2,4,0],[3,2,4],[],[0,9,1,8,10,5,8,11,10],[3,4,0,3,10,4],[5,8,10,8,11,10],[],[3,5,7],[7,1,5],[1,7,3,1,5,7],[],[9,2,0,9,7,2],[0,3,8,1,7,11,1,5,7],[11,1,7,1,5,7],[],[9,1,0,5,3,2,5,7,3],[8,2,5,8,0,2],[2,5,3,5,7,3],[3,9,1,3,8,9,7,11,10,7,10,5],[9,1,0,10,7,11,10,5,7],[3,8,0,7,10,5,7,11,10],[11,5,7,11,10,5],[],[],[],[],[],[0,6,2],[],[7,2,9,7,9,8],[],[],[],[8,10,9],[7,1,3],[7,1,0],[6,9,3,6,10,9],[7,10,8,10,9,8],[],[6,0,4],[],[11,1,4,11,3,1],[2,4,6],[2,0,4,2,4,6],[2,4,6],[1,4,2,4,6,2],[],[6,0,4],[],[2,11,3,6,9,4,6,10,9],[8,6,1,8,1,3],[10,0,6,0,4,6],[8,0,3,9,6,10,9,4,6],[10,4,6,10,9,4],[],[],[],[5,3,1],[],[0,6,2],[],[7,4,8,5,2,1,5,6,2],[],[],[2,4,0],[7,4,8,2,11,3,10,5,6],[7,1,3],[5,6,10,0,9,1,8,7,4],[5,6,10,7,0,3,7,4,0],[10,5,6,4,8,7],[9,11,8],[3,5,6],[0,5,11,0,11,8],[6,3,5,3,1,5],[3,9,6,3,8,9],[9,6,0,6,2,0],[0,3,8,2,5,6,2,1,5],[1,6,2,1,5,6],[9,11,8],[1,0,9,6,10,5,11,3,2],[6,10,5,2,8,0,2,11,8],[3,2,11,10,5,6],[10,5,6,9,3,8,9,1,3],[0,9,1,5,6,10],[8,0,3,10,5,6],[10,5,6],[],[],[],[],[],[],[],[1,10,2,9,11,6,9,8,11],[],[],[6,0,2],[3,6,9,3,2,6],[3,5,1],[0,5,1,0,11,5],[0,3,5],[6,9,11,9,8,11],[],[],[],[4,5,9,7,1,10,7,3,1],[],[11,6,7,2,4,5,2,0,4],[11,6,7,8,0,3,1,10,2,9,4,5],[6,7,11,1,10,2,9,4,5],[],[4,1,0,4,5,1,6,7,3,6,3,2],[9,4,5,0,6,7,0,2,6],[4,5,9,6,3,2,6,7,3],[6,7,11,5,3,8,5,1,3],[6,7,11,4,1,0,4,5,1],[4,5,9,3,8,0,11,6,7],[9,4,5,7,11,6],[],[],[0,6,4],[8,6,4,8,1,6],[],[0,10,2,0,9,10,4,8,11,4,11,6],[10,2,1,6,0,3,6,4,0],[10,2,1,11,4,8,11,6,4],[4,2,6],[1,0,9,2,4,8,2,6,4],[2,4,0,2,6,4],[8,2,4,2,6,4],[11,4,1,11,6,4],[0,9,1,4,11,6,4,8,11],[3,6,0,6,4,0],[8,6,4,8,11,6],[10,8,9],[6,3,9,6,7,3],[6,7,1],[10,7,1,7,3,1],[7,11,6,8,10,2,8,9,10],[11,6,7,10,0,9,10,2,0],[2,1,10,7,11,6,8,0,3],[1,10,2,6,7,11],[7,2,6,7,9,2],[1,0,9,3,6,7,3,2,6],[7,0,6,0,2,6],[2,7,3,2,6,7],[7,11,6,3,9,1,3,8,9],[9,1,0,11,6,7],[0,3,8,11,6,7],[11,6,7],[],[],[],[],[5,3,7],[8,5,2,8,7,5],[5,3,7],[1,10,2,5,8,7,5,9,8],[1,7,5],[1,7,5],[9,2,7,9,7,5],[11,3,2,8,5,9,8,7,5],[1,3,7,1,7,5],[0,7,1,7,5,1],[9,3,5,3,7,5],[9,7,5,9,8,7],[8,10,11],[3,4,10,3,10,11],[8,10,11],[5,9,4,1,11,3,1,10,11],[2,4,5],[5,2,4,2,0,4],[0,3,8,5,9,4,10,2,1],[2,1,10,9,4,5],[2,8,5,2,11,8],[3,2,11,1,4,5,1,0,4],[9,4,5,8,2,11,8,0,2],[11,3,2,9,4,5],[8,5,3,5,1,3],[5,0,4,5,1,0],[3,8,0,4,5,9],[9,4,5],[11,9,10],[11,9,10],[1,11,4,1,10,11],[8,7,4,11,1,10,11,3,1],[2,7,9,2,9,10],[4,8,7,0,10,2,0,9,10],[2,1,10,0,7,4,0,3,7],[10,2,1,8,7,4],[1,7,4],[3,2,11,4,8,7,9,1,0],[11,4,2,4,0,2],[2,11,3,7,4,8],[4,1,7,1,3,7],[1,0,9,8,7,4],[3,4,0,3,7,4],[8,7,4],[8,9,10,8,10,11],[3,9,11,9,10,11],[0,10,8,10,11,8],[10,3,1,10,11,3],[2,8,10,8,9,10],[9,2,0,9,10,2],[8,0,3,1,10,2],[10,2,1],[1,11,9,11,8,9],[11,3,2,0,9,1],[11,0,2,11,8,0],[11,3,2],[8,1,3,8,9,1],[9,1,0],[8,0,3],[]],this.edgeTable2=[0,265,515,778,2060,2309,2575,2822,1030,1295,1541,1804,3082,3331,3593,3840,400,153,915,666,2460,2197,2975,2710,1430,1183,1941,1692,3482,3219,3993,3728,560,825,51,314,2620,2869,2111,2358,1590,1855,1077,1340,3642,3891,3129,3376,928,681,419,170,2988,2725,2479,2214,1958,1711,1445,1196,4010,3747,3497,3232,2240,2505,2755,3018,204,453,719,966,3270,3535,3781,4044,1226,1475,1737,1984,2384,2137,2899,2650,348,85,863,598,3414,3167,3925,3676,1370,1107,1881,1616,2800,3065,2291,2554,764,1013,255,502,3830,4095,3317,3580,1786,2035,1273,1520,2912,2665,2403,2154,876,613,367,102,3942,3695,3429,3180,1898,1635,1385,1120,1120,1385,1635,1898,3180,3429,3695,3942,102,367,613,876,2154,2403,2665,2912,1520,1273,2035,1786,3580,3317,4095,3830,502,255,1013,764,2554,2291,3065,2800,1616,1881,1107,1370,3676,3925,3167,3414,598,863,85,348,2650,2899,2137,2384,1984,1737,1475,1226,4044,3781,3535,3270,966,719,453,204,3018,2755,2505,2240,3232,3497,3747,4010,1196,1445,1711,1958,2214,2479,2725,2988,170,419,681,928,3376,3129,3891,3642,1340,1077,1855,1590,2358,2111,2869,2620,314,51,825,560,3728,3993,3219,3482,1692,1941,1183,1430,2710,2975,2197,2460,666,915,153,400,3840,3593,3331,3082,1804,1541,1295,1030,2822,2575,2309,2060,778,515,265,0],this.triTable2=[[],[8,3,0],[9,0,1],[8,3,1,8,1,9],[11,2,3],[11,2,0,11,0,8],[11,2,3,0,1,9],[2,1,11,1,9,11,11,9,8],[10,1,2],[8,3,0,1,2,10],[9,0,2,9,2,10],[3,2,8,2,10,8,8,10,9],[10,1,3,10,3,11],[1,0,10,0,8,10,10,8,11],[0,3,9,3,11,9,9,11,10],[8,10,9,8,11,10],[8,4,7],[3,0,4,3,4,7],[1,9,0,8,4,7],[9,4,1,4,7,1,1,7,3],[2,3,11,7,8,4],[7,11,4,11,2,4,4,2,0],[3,11,2,4,7,8,9,0,1],[2,7,11,2,1,7,1,4,7,1,9,4],[10,1,2,8,4,7],[2,10,1,0,4,7,0,7,3],[4,7,8,0,2,10,0,10,9],[2,7,3,2,9,7,7,9,4,2,10,9],[8,4,7,11,10,1,11,1,3],[11,4,7,1,4,11,1,11,10,1,0,4],[3,8,0,7,11,4,11,9,4,11,10,9],[7,11,4,4,11,9,11,10,9],[9,5,4],[3,0,8,4,9,5],[5,4,0,5,0,1],[4,8,5,8,3,5,5,3,1],[11,2,3,9,5,4],[9,5,4,8,11,2,8,2,0],[3,11,2,1,5,4,1,4,0],[8,5,4,2,5,8,2,8,11,2,1,5],[2,10,1,9,5,4],[0,8,3,5,4,9,10,1,2],[10,5,2,5,4,2,2,4,0],[3,4,8,3,2,4,2,5,4,2,10,5],[5,4,9,1,3,11,1,11,10],[0,9,1,4,8,5,8,10,5,8,11,10],[3,4,0,3,10,4,4,10,5,3,11,10],[4,8,5,5,8,10,8,11,10],[9,5,7,9,7,8],[0,9,3,9,5,3,3,5,7],[8,0,7,0,1,7,7,1,5],[1,7,3,1,5,7],[11,2,3,8,9,5,8,5,7],[9,2,0,9,7,2,2,7,11,9,5,7],[0,3,8,2,1,11,1,7,11,1,5,7],[2,1,11,11,1,7,1,5,7],[1,2,10,5,7,8,5,8,9],[9,1,0,10,5,2,5,3,2,5,7,3],[5,2,10,8,2,5,8,5,7,8,0,2],[10,5,2,2,5,3,5,7,3],[3,9,1,3,8,9,7,11,10,7,10,5],[9,1,0,10,7,11,10,5,7],[3,8,0,7,10,5,7,11,10],[11,5,7,11,10,5],[11,7,6],[0,8,3,11,7,6],[9,0,1,11,7,6],[7,6,11,3,1,9,3,9,8],[2,3,7,2,7,6],[8,7,0,7,6,0,0,6,2],[1,9,0,3,7,6,3,6,2],[7,6,2,7,2,9,2,1,9,7,9,8],[1,2,10,6,11,7],[2,10,1,7,6,11,8,3,0],[11,7,6,10,9,0,10,0,2],[7,6,11,3,2,8,8,2,10,8,10,9],[6,10,7,10,1,7,7,1,3],[6,10,1,6,1,7,7,1,0,7,0,8],[9,0,3,6,9,3,6,10,9,6,3,7],[6,10,7,7,10,8,10,9,8],[8,4,6,8,6,11],[11,3,6,3,0,6,6,0,4],[0,1,9,4,6,11,4,11,8],[1,9,4,11,1,4,11,3,1,11,4,6],[3,8,2,8,4,2,2,4,6],[2,0,4,2,4,6],[1,9,0,3,8,2,2,8,4,2,4,6],[9,4,1,1,4,2,4,6,2],[10,1,2,11,8,4,11,4,6],[10,1,2,11,3,6,6,3,0,6,0,4],[0,2,10,0,10,9,4,11,8,4,6,11],[2,11,3,6,9,4,6,10,9],[8,4,6,8,6,1,6,10,1,8,1,3],[1,0,10,10,0,6,0,4,6],[8,0,3,9,6,10,9,4,6],[10,4,6,10,9,4],[9,5,4,7,6,11],[4,9,5,3,0,8,11,7,6],[6,11,7,4,0,1,4,1,5],[6,11,7,4,8,5,5,8,3,5,3,1],[4,9,5,6,2,3,6,3,7],[9,5,4,8,7,0,0,7,6,0,6,2],[4,0,1,4,1,5,6,3,7,6,2,3],[7,4,8,5,2,1,5,6,2],[6,11,7,1,2,10,9,5,4],[11,7,6,8,3,0,1,2,10,9,5,4],[11,7,6,10,5,2,2,5,4,2,4,0],[7,4,8,2,11,3,10,5,6],[4,9,5,6,10,7,7,10,1,7,1,3],[5,6,10,0,9,1,8,7,4],[5,6,10,7,0,3,7,4,0],[10,5,6,4,8,7],[5,6,9,6,11,9,9,11,8],[0,9,5,0,5,3,3,5,6,3,6,11],[0,1,5,0,5,11,5,6,11,0,11,8],[11,3,6,6,3,5,3,1,5],[9,5,6,3,9,6,3,8,9,3,6,2],[5,6,9,9,6,0,6,2,0],[0,3,8,2,5,6,2,1,5],[1,6,2,1,5,6],[1,2,10,5,6,9,9,6,11,9,11,8],[1,0,9,6,10,5,11,3,2],[6,10,5,2,8,0,2,11,8],[3,2,11,10,5,6],[10,5,6,9,3,8,9,1,3],[0,9,1,5,6,10],[8,0,3,10,5,6],[10,5,6],[10,6,5],[8,3,0,10,6,5],[0,1,9,5,10,6],[10,6,5,9,8,3,9,3,1],[3,11,2,10,6,5],[6,5,10,2,0,8,2,8,11],[1,9,0,6,5,10,11,2,3],[1,10,2,5,9,6,9,11,6,9,8,11],[1,2,6,1,6,5],[0,8,3,2,6,5,2,5,1],[5,9,6,9,0,6,6,0,2],[9,6,5,3,6,9,3,9,8,3,2,6],[11,6,3,6,5,3,3,5,1],[0,5,1,0,11,5,5,11,6,0,8,11],[0,5,9,0,3,5,3,6,5,3,11,6],[5,9,6,6,9,11,9,8,11],[10,6,5,4,7,8],[5,10,6,7,3,0,7,0,4],[5,10,6,0,1,9,8,4,7],[4,5,9,6,7,10,7,1,10,7,3,1],[7,8,4,2,3,11,10,6,5],[11,6,7,10,2,5,2,4,5,2,0,4],[11,6,7,8,0,3,1,10,2,9,4,5],[6,7,11,1,10,2,9,4,5],[7,8,4,5,1,2,5,2,6],[4,1,0,4,5,1,6,7,3,6,3,2],[9,4,5,8,0,7,0,6,7,0,2,6],[4,5,9,6,3,2,6,7,3],[6,7,11,4,5,8,5,3,8,5,1,3],[6,7,11,4,1,0,4,5,1],[4,5,9,3,8,0,11,6,7],[9,4,5,7,11,6],[10,6,4,10,4,9],[8,3,0,9,10,6,9,6,4],[1,10,0,10,6,0,0,6,4],[8,6,4,8,1,6,6,1,10,8,3,1],[2,3,11,6,4,9,6,9,10],[0,10,2,0,9,10,4,8,11,4,11,6],[10,2,1,11,6,3,6,0,3,6,4,0],[10,2,1,11,4,8,11,6,4],[9,1,4,1,2,4,4,2,6],[1,0,9,3,2,8,2,4,8,2,6,4],[2,4,0,2,6,4],[3,2,8,8,2,4,2,6,4],[1,4,9,11,4,1,11,1,3,11,6,4],[0,9,1,4,11,6,4,8,11],[11,6,3,3,6,0,6,4,0],[8,6,4,8,11,6],[6,7,10,7,8,10,10,8,9],[9,3,0,6,3,9,6,9,10,6,7,3],[6,1,10,6,7,1,7,0,1,7,8,0],[6,7,10,10,7,1,7,3,1],[7,11,6,3,8,2,8,10,2,8,9,10],[11,6,7,10,0,9,10,2,0],[2,1,10,7,11,6,8,0,3],[1,10,2,6,7,11],[7,2,6,7,9,2,2,9,1,7,8,9],[1,0,9,3,6,7,3,2,6],[8,0,7,7,0,6,0,2,6],[2,7,3,2,6,7],[7,11,6,3,9,1,3,8,9],[9,1,0,11,6,7],[0,3,8,11,6,7],[11,6,7],[11,7,5,11,5,10],[3,0,8,7,5,10,7,10,11],[9,0,1,10,11,7,10,7,5],[3,1,9,3,9,8,7,10,11,7,5,10],[10,2,5,2,3,5,5,3,7],[5,10,2,8,5,2,8,7,5,8,2,0],[9,0,1,10,2,5,5,2,3,5,3,7],[1,10,2,5,8,7,5,9,8],[2,11,1,11,7,1,1,7,5],[0,8,3,2,11,1,1,11,7,1,7,5],[9,0,2,9,2,7,2,11,7,9,7,5],[11,3,2,8,5,9,8,7,5],[1,3,7,1,7,5],[8,7,0,0,7,1,7,5,1],[0,3,9,9,3,5,3,7,5],[9,7,5,9,8,7],[4,5,8,5,10,8,8,10,11],[3,0,4,3,4,10,4,5,10,3,10,11],[0,1,9,4,5,8,8,5,10,8,10,11],[5,9,4,1,11,3,1,10,11],[3,8,4,3,4,2,2,4,5,2,5,10],[10,2,5,5,2,4,2,0,4],[0,3,8,5,9,4,10,2,1],[2,1,10,9,4,5],[8,4,5,2,8,5,2,11,8,2,5,1],[3,2,11,1,4,5,1,0,4],[9,4,5,8,2,11,8,0,2],[11,3,2,9,4,5],[4,5,8,8,5,3,5,1,3],[5,0,4,5,1,0],[3,8,0,4,5,9],[9,4,5],[7,4,11,4,9,11,11,9,10],[3,0,8,7,4,11,11,4,9,11,9,10],[11,7,4,1,11,4,1,10,11,1,4,0],[8,7,4,11,1,10,11,3,1],[2,3,7,2,7,9,7,4,9,2,9,10],[4,8,7,0,10,2,0,9,10],[2,1,10,0,7,4,0,3,7],[10,2,1,8,7,4],[2,11,7,2,7,1,1,7,4,1,4,9],[3,2,11,4,8,7,9,1,0],[7,4,11,11,4,2,4,0,2],[2,11,3,7,4,8],[9,1,4,4,1,7,1,3,7],[1,0,9,8,7,4],[3,4,0,3,7,4],[8,7,4],[8,9,10,8,10,11],[0,9,3,3,9,11,9,10,11],[1,10,0,0,10,8,10,11,8],[10,3,1,10,11,3],[3,8,2,2,8,10,8,9,10],[9,2,0,9,10,2],[8,0,3,1,10,2],[10,2,1],[2,11,1,1,11,9,11,8,9],[11,3,2,0,9,1],[11,0,2,11,8,0],[11,3,2],[8,1,3,8,9,1],[9,1,0],[8,0,3],[]]}}Ke.prototype.march=function(e,t,s,i){let n=!!i.fulltable,l=i.hasOwnProperty("origin")&&i.origin.hasOwnProperty("x")?i.origin:{x:0,y:0,z:0},r=!!i.voxel,o=i.matrix,a=i.nX||0,d=i.nY||0,c=i.nZ||0,h=i.scale||1,p=null;p=i.unitCube?i.unitCube:{x:h,y:h,z:h};let m,u,g=new Int32Array(a*d*c);for(m=0,u=g.length;m<u;++m)g[m]=-1;let f=function(e,s,i,n,a,h){let m={x:0,y:0,z:0},u=a;!!!(n&1<<a)&&!!(n&1<<h)&&(u=h),1&u&&i++,2&u&&s++,4&u&&e++,o?(m=new THREE.Vector3(e,s,i),m=m.applyMatrix4(o),m={x:m.x,y:m.y,z:m.z}):(m.x=l.x+p.x*e,m.y=l.y+p.y*s,m.z=l.z+p.z*i);let f=(d*e+s)*c+i;return r?(t.push(m),t.length-1):(g[f]<0&&(g[f]=t.length,t.push(m)),g[f])},C=new Int32Array(12),b=n?this.edgeTable2:this.edgeTable,y=n?this.triTable2:this.triTable;for(m=0;m<a-1;++m)for(let i=0;i<d-1;++i)for(let n=0;n<c-1;++n){let l=0;for(let t=0;t<8;++t){l|=!!(e[(d*(m+((4&t)>>2))+i+((2&t)>>1))*c+n+(1&t)]&this.ISDONE)<<t}if(0===l||255===l)continue;let o=b[l];if(0===o)continue;let a=y[l];1&o&&(C[0]=f(m,i,n,l,0,1)),2&o&&(C[1]=f(m,i,n,l,1,3)),4&o&&(C[2]=f(m,i,n,l,3,2)),8&o&&(C[3]=f(m,i,n,l,2,0)),16&o&&(C[4]=f(m,i,n,l,4,5)),32&o&&(C[5]=f(m,i,n,l,5,7)),64&o&&(C[6]=f(m,i,n,l,7,6)),128&o&&(C[7]=f(m,i,n,l,6,4)),256&o&&(C[8]=f(m,i,n,l,0,4)),512&o&&(C[9]=f(m,i,n,l,1,5)),1024&o&&(C[10]=f(m,i,n,l,3,7)),2048&o&&(C[11]=f(m,i,n,l,2,6));for(let e=0;e<a.length;e+=3){let i=C[a[e]],n=C[a[e+1]],l=C[a[e+2]];r&&e>=3&&(t.push(t[i]),i=t.length-1,t.push(t[n]),n=t.length-1,t.push(t[l]),l=t.length-1),s.push(i),s.push(n),s.push(l)}}},Ke.prototype.laplacianSmooth=function(e,t,s){let i,n,l,r,o,a=new Array(t.length);for(i=0,n=t.length;i<n;i++)a[i]={x:0,y:0,z:0};let d,c=new Array(20);for(i=0;i<20;i++)c[i]=new Array(t.length);for(i=0,n=t.length;i<n;i++)c[0][i]=0;for(i=0,n=s.length/3;i<n;i++){let e=3*i,t=3*i+1,n=3*i+2;for(d=!0,l=0,r=c[0][s[e]];l<r;l++)if(s[t]==c[l+1][s[e]]){d=!1;break}for(d&&(c[0][s[e]]++,c[c[0][s[e]]][s[e]]=s[t]),d=!0,l=0,r=c[0][s[e]];l<r;l++)if(s[n]==c[l+1][s[e]]){d=!1;break}for(d&&(c[0][s[e]]++,c[c[0][s[e]]][s[e]]=s[n]),d=!0,l=0,r=c[0][s[t]];l<r;l++)if(s[e]==c[l+1][s[t]]){d=!1;break}for(d&&(c[0][s[t]]++,c[c[0][s[t]]][s[t]]=s[e]),d=!0,l=0,r=c[0][s[t]];l<r;l++)if(s[n]==c[l+1][s[t]]){d=!1;break}for(d&&(c[0][s[t]]++,c[c[0][s[t]]][s[t]]=s[n]),d=!0,l=0;l<c[0][s[n]];l++)if(s[e]==c[l+1][s[n]]){d=!1;break}for(d&&(c[0][s[n]]++,c[c[0][s[n]]][s[n]]=s[e]),d=!0,l=0,r=c[0][s[n]];l<r;l++)if(s[t]==c[l+1][s[n]]){d=!1;break}d&&(c[0][s[n]]++,c[c[0][s[n]]][s[n]]=s[t])}let h=.5;for(o=0;o<e;o++){for(i=0,n=t.length;i<n;i++)if(c[0][i]<3)a[i].x=t[i].x,a[i].y=t[i].y,a[i].z=t[i].z;else if(3==c[0][i]||4==c[0][i]){for(a[i].x=0,a[i].y=0,a[i].z=0,l=0,r=c[0][i];l<r;l++)a[i].x+=t[c[l+1][i]].x,a[i].y+=t[c[l+1][i]].y,a[i].z+=t[c[l+1][i]].z;a[i].x+=h*t[i].x,a[i].y+=h*t[i].y,a[i].z+=h*t[i].z,a[i].x/=h+c[0][i],a[i].y/=h+c[0][i],a[i].z/=h+c[0][i]}else{for(a[i].x=0,a[i].y=0,a[i].z=0,l=0,r=c[0][i];l<r;l++)a[i].x+=t[c[l+1][i]].x,a[i].y+=t[c[l+1][i]].y,a[i].z+=t[c[l+1][i]].z;a[i].x+=1*t[i].x,a[i].y+=1*t[i].y,a[i].z+=1*t[i].z,a[i].x/=1+c[0][i],a[i].y/=1+c[0][i],a[i].z/=1+c[0][i]}for(i=0,n=t.length;i<n;i++)t[i].x=a[i].x,t[i].y=a[i].y,t[i].z=a[i].z}};class Je{constructor(e,t){this.icn3d=e,this.threshbox=t,this.dataArray={},this.header,this.data=void 0,this.matrix=void 0,this.isovalue=void 0,this.loadPhiFrom=void 0,this.vpColor=null,this.vpPot=null,this.INOUT=1,this.ISDONE=2,this.ISBOUND=4,this.ptranx=0,this.ptrany=0,this.ptranz=0,this.probeRadius=1.4,this.defaultScaleFactor=2,this.scaleFactor=this.defaultScaleFactor,this.finalScaleFactor={},this.pHeight=0,this.pWidth=0,this.pLength=0,this.cutRadius=0,this.vpBits=null,this.vpDistance=null,this.vpAtomID=null,this.vertnumber=0,this.facenumber=0,this.pminx=0,this.pminy=0,this.pminz=0,this.pmaxx=0,this.pmaxy=0,this.pmaxz=0,this.bCalcArea=!1,this.atomsToShow={},this.vdwRadii={H:1.2,LI:1.82,Na:2.27,K:2.75,C:1.7,N:1.55,O:1.52,F:1.47,P:1.8,S:1.8,CL:1.75,BR:1.85,SE:1.9,ZN:1.39,CU:1.4,NI:1.63,X:2},this.depty={},this.widxz={},this.faces=void 0,this.verts=void 0,this.nb=[new Int32Array([1,0,0]),new Int32Array([-1,0,0]),new Int32Array([0,1,0]),new Int32Array([0,-1,0]),new Int32Array([0,0,1]),new Int32Array([0,0,-1]),new Int32Array([1,1,0]),new Int32Array([1,-1,0]),new Int32Array([-1,1,0]),new Int32Array([-1,-1,0]),new Int32Array([1,0,1]),new Int32Array([1,0,-1]),new Int32Array([-1,0,1]),new Int32Array([-1,0,-1]),new Int32Array([0,1,1]),new Int32Array([0,1,-1]),new Int32Array([0,-1,1]),new Int32Array([0,-1,-1]),new Int32Array([1,1,1]),new Int32Array([1,1,-1]),new Int32Array([1,-1,1]),new Int32Array([-1,1,1]),new Int32Array([1,-1,-1]),new Int32Array([-1,-1,1]),new Int32Array([-1,1,-1]),new Int32Array([-1,-1,-1])],this.origextent=void 0,this.marchingCube=new Ke}}Je.prototype.getVDWIndex=function(e){return e.elem&&void 0!==this.vdwRadii[e.elem.toUpperCase()]?e.elem:"X"},Je.prototype.inOrigExtent=function(e,t,s){return!(e<this.origextent[0][0]||e>this.origextent[1][0])&&(!(t<this.origextent[0][1]||t>this.origextent[1][1])&&!(s<this.origextent[0][2]||s>this.origextent[1][2]))},Je.prototype.getFacesAndVertices=function(){let e,t,s=this.verts;for(e=0,t=s.length;e<t;e++)s[e].x=s[e].x/this.scaleFactor-this.ptranx,s[e].y=s[e].y/this.scaleFactor-this.ptrany,s[e].z=s[e].z/this.scaleFactor-this.ptranz;let i=[];for(e=0,t=this.faces.length;e<t;e+=3){let t=this.faces[e],n=this.faces[e+1],l=this.faces[e+2],r=s[t].atomid,o=s[n].atomid,a=s[l].atomid;this.atomsToShow[r]&&this.atomsToShow[o]&&this.atomsToShow[a]&&(t!==n&&n!==l&&t!==l&&i.push({a:t,b:n,c:l}))}return this.vpBits=null,this.vpDistance=null,this.vpAtomID=null,this.vpColor=null,this.vpPot=null,{vertices:s,faces:i}},Je.prototype.initparm=function(e,t,s,i,n,l,r,o,a){this.header=n,this.dataArray=l,this.matrix=r,this.isovalue=o,this.loadPhiFrom=a,this.bCalcArea=s;for(let e=0,t=i.length;e<t;e++)this.atomsToShow[i[e]]=1;let d=1/this.scaleFactor*5.5;this.origextent=e,this.pminx=e[0][0],this.pmaxx=e[1][0],this.pminy=e[0][1],this.pmaxy=e[1][1],this.pminz=e[0][2],this.pmaxz=e[1][2],t?(this.pminx-=this.probeRadius+d,this.pminy-=this.probeRadius+d,this.pminz-=this.probeRadius+d,this.pmaxx+=this.probeRadius+d,this.pmaxy+=this.probeRadius+d,this.pmaxz+=this.probeRadius+d):(this.pminx-=d,this.pminy-=d,this.pminz-=d,this.pmaxx+=d,this.pmaxy+=d,this.pmaxz+=d),this.pminx=Math.floor(this.pminx*this.scaleFactor)/this.scaleFactor,this.pminy=Math.floor(this.pminy*this.scaleFactor)/this.scaleFactor,this.pminz=Math.floor(this.pminz*this.scaleFactor)/this.scaleFactor,this.pmaxx=Math.ceil(this.pmaxx*this.scaleFactor)/this.scaleFactor,this.pmaxy=Math.ceil(this.pmaxy*this.scaleFactor)/this.scaleFactor,this.pmaxz=Math.ceil(this.pmaxz*this.scaleFactor)/this.scaleFactor,this.ptranx=-this.pminx,this.ptrany=-this.pminy,this.ptranz=-this.pminz;let c=129,h=this.pmaxx-this.pminx;this.pmaxy-this.pminy>h&&(h=this.pmaxy-this.pminy),this.pmaxz-this.pminz>h&&(h=this.pmaxz-this.pminz),this.scaleFactor=(c-1)/h,this.scaleFactor=this.defaultScaleFactor,this.defaultScaleFactor*h>this.threshbox&&(c=Math.floor(this.threshbox),this.scaleFactor=(this.threshbox-1)/h),this.bCalcArea&&(this.scaleFactor=this.defaultScaleFactor),this.pLength=Math.ceil(this.scaleFactor*(this.pmaxx-this.pminx))+1,this.pWidth=Math.ceil(this.scaleFactor*(this.pmaxy-this.pminy))+1,this.pHeight=Math.ceil(this.scaleFactor*(this.pmaxz-this.pminz))+1,this.boundingatom(t),this.cutRadius=this.probeRadius*this.scaleFactor,this.vpBits=new Uint8Array(this.pLength*this.pWidth*this.pHeight),this.vpDistance=new Float64Array(this.pLength*this.pWidth*this.pHeight),this.vpAtomID=new Int32Array(this.pLength*this.pWidth*this.pHeight),this.vpColor=[],this.vpPot=[]},Je.prototype.boundingatom=function(e){let t,s,i,n,l=[];for(let r in this.vdwRadii){if(!this.vdwRadii.hasOwnProperty(r))continue;let o=this.vdwRadii[r];l[r]=e?(o+this.probeRadius)*this.scaleFactor+.5:o*this.scaleFactor+.5,i=l[r]*l[r],this.widxz[r]=Math.floor(l[r])+1,this.depty[r]=new Int32Array(this.widxz[r]*this.widxz[r]),n=0;for(let e=0;e<this.widxz[r];e++)for(let l=0;l<this.widxz[r];l++)t=e*e+l*l,t>i?this.depty[r][n]=-1:(s=Math.sqrt(i-t),this.depty[r][n]=Math.floor(s)),n++}},Je.prototype.fillvoxels=function(e,t){let s,i,n,l;for(s=0,l=this.vpBits.length;s<l;s++)this.vpBits[s]=0,this.vpDistance[s]=-1,this.vpAtomID[s]=-1,this.vpColor[s]=new THREE.Color,this.vpPot[s]=0;for(s in t){let i=e[t[s]];void 0!==i&&"DUM"!==i.resn&&this.fillAtom(i,e)}if(this.dataArray){let e=0,t=this.header.xExtent-1,l=0,r=this.header.yExtent-1,o=0,a=this.header.zExtent-1,d=1,c=Math.floor(.5+d*(t-e))+1,h=Math.floor(.5+d*(r-l))+1,p=Math.floor(.5+d*(a-o))+1,m=h*p,u=p,g=new Float32Array(c*h*p);for(s=0;s<c;++s)for(i=0;i<h;++i)for(n=0;n<p;++n){let e,t=s*m+i*u+n;"phi"==this.header.filetype?e=n*m+i*u+s:"cube"==this.header.filetype&&(e=s*m+i*u+n),e<this.dataArray.length&&(g[t]=this.dataArray[e])}let f=this.pWidth*this.pHeight,C=this.pHeight;for(s=0;s<this.pLength;++s)for(i=0;i<this.pWidth;++i)for(n=0;n<this.pHeight;++n){let e=s/this.scaleFactor-this.ptranx,t=i/this.scaleFactor-this.ptrany,l=n/this.scaleFactor-this.ptranz,r=new THREE.Vector3(e,t,l);r.sub(this.header.ori).multiplyScalar(this.header.scale);let o=Math.floor(r.x),a=Math.ceil(r.x),d=Math.floor(r.y),b=Math.ceil(r.y),y=Math.floor(r.z),v=Math.ceil(r.z);a==o&&(a=o+1),b==d&&(b=d+1),v==y&&(v=y+1),a>c&&(a=c),b>h&&(b=h),v>p&&(v=p);let _,w=g[o*m+d*u+y],S=g[a*m+d*u+y],A=g[o*m+b*u+y],x=g[o*m+d*u+v],k=g[a*m+b*u+y],O=g[o*m+b*u+v],R=g[a*m+d*u+v],I=g[a*m+b*u+v],E=r.x-o,T=r.y-d,P=r.z-y,D=((w*(1-E)+S*E)*(1-T)+(A*(1-E)+k*E)*T)*(1-P)+((x*(1-E)+R*E)*(1-T)+(O*(1-E)+I*E)*T)*P,M=s*f+i*C+n;this.vpPot[M]=D,D>this.isovalue&&(D=this.isovalue),D<-this.isovalue&&(D=-this.isovalue),D>0?(D/=1*this.isovalue,_=new THREE.Color(1-D,1-D,1)):(D/=-1*this.isovalue,_=new THREE.Color(1,1-D,1-D)),this.vpColor[M]=_}}for(s=0,l=this.vpBits.length;s<l;s++)this.vpBits[s]&this.INOUT&&(this.vpBits[s]|=this.ISDONE)},Je.prototype.fillAtom=function(e,t){let s,i,n,l,r,o,a,d,c,h,p,m,u,g,f,C,b,y,v;s=Math.floor(.5+this.scaleFactor*(e.coord.x+this.ptranx)),i=Math.floor(.5+this.scaleFactor*(e.coord.y+this.ptrany)),n=Math.floor(.5+this.scaleFactor*(e.coord.z+this.ptranz));let _=this.getVDWIndex(e),w=0,S=this.pWidth*this.pHeight;for(h=0,v=this.widxz[_];h<v;h++)for(p=0;p<v;p++){if(-1!=this.depty[_][w])for(C=-1;C<2;C++)for(b=-1;b<2;b++)for(y=-1;y<2;y++)if(0!==C&&0!==b&&0!==y)for(a=C*h,c=y*p,m=0;m<=this.depty[_][w];m++){if(d=m*b,u=s+a,g=i+d,f=n+c,u<0||g<0||f<0||u>=this.pLength||g>=this.pWidth||f>=this.pHeight)continue;let h=u*S+g*this.pHeight+f;if(this.vpBits[h]&this.INOUT){let p=t[this.vpAtomID[h]];p.serial!=e.serial&&(l=s+a-Math.floor(.5+this.scaleFactor*(p.x+this.ptranx)),r=i+d-Math.floor(.5+this.scaleFactor*(p.y+this.ptrany)),o=n+c-Math.floor(.5+this.scaleFactor*(p.z+this.ptranz)),a*a+d*d+c*c<l*l+r*r+o*o&&(this.vpAtomID[h]=e.serial))}else this.vpBits[h]|=this.INOUT,this.vpAtomID[h]=e.serial}w++}},Je.prototype.fillvoxelswaals=function(e,t){let s,i;for(s=0,i=this.vpBits.length;s<i;s++)this.vpBits[s]&=~this.ISDONE;for(s in t){let i=e[t[s]];void 0!==i&&this.fillAtomWaals(i,e)}},Je.prototype.fillAtomWaals=function(e,t){let s,i,n,l,r,o,a,d,c,h,p,m,u,g,f,C,b,y,v,_=0;s=Math.floor(.5+this.scaleFactor*(e.coord.x+this.ptranx)),i=Math.floor(.5+this.scaleFactor*(e.coord.y+this.ptrany)),n=Math.floor(.5+this.scaleFactor*(e.coord.z+this.ptranz));let w=this.getVDWIndex(e),S=this.pWidth*this.pHeight;for(u=0,v=this.widxz[w];u<v;u++)for(g=0;g<v;g++){if(-1!=this.depty[w][_])for(C=-1;C<2;C++)for(b=-1;b<2;b++)for(y=-1;y<2;y++)if(0!==C&&0!==b&&0!==y)for(a=C*u,c=y*g,f=0;f<=this.depty[w][_];f++){if(d=f*b,h=s+a,p=i+d,m=n+c,h<0||p<0||m<0||h>=this.pLength||p>=this.pWidth||m>=this.pHeight)continue;let u=h*S+p*this.pHeight+m;if(this.vpBits[u]&this.ISDONE){let h=t[this.vpAtomID[u]];h.serial!=e.serial&&(l=s+a-Math.floor(.5+this.scaleFactor*(h.x+this.ptranx)),r=i+d-Math.floor(.5+this.scaleFactor*(h.y+this.ptrany)),o=n+c-Math.floor(.5+this.scaleFactor*(h.z+this.ptranz)),a*a+d*d+c*c<l*l+r*r+o*o&&(this.vpAtomID[u]=e.serial))}else this.vpBits[u]|=this.ISDONE,this.vpAtomID[u]=e.serial}_++}},Je.prototype.buildboundary=function(){let e=this.pWidth*this.pHeight;for(let t=0;t<this.pLength;t++)for(let s=0;s<this.pHeight;s++)for(let i=0;i<this.pWidth;i++){let n=t*e+i*this.pHeight+s;if(this.vpBits[n]&this.INOUT){let l=0;for(;l<26;){let r=t+this.nb[l][0],o=s+this.nb[l][2],a=i+this.nb[l][1];if(r>-1&&r<this.pLength&&a>-1&&a<this.pWidth&&o>-1&&o<this.pHeight&&!(this.vpBits[r*e+a*this.pHeight+o]&this.INOUT)){this.vpBits[n]|=this.ISBOUND;break}l++}}}},Je.prototype.fastdistancemap=function(){let e,t,s,i,n,l=new function(e,t,s){let i=new Int32Array(e*t*s*3);this.set=function(e,n,l,r){let o=3*((e*t+n)*s+l);i[o]=r.ix,i[o+1]=r.iy,i[o+2]=r.iz},this.get=function(e,n,l){let r=3*((e*t+n)*s+l);return{ix:i[r],iy:i[r+1],iz:i[r+2]}}}(this.pLength,this.pWidth,this.pHeight),r=this.pWidth*this.pHeight,o=this.cutRadius*this.cutRadius,a=[],d=[];for(e=0;e<this.pLength;e++)for(t=0;t<this.pWidth;t++)for(s=0;s<this.pHeight;s++)if(n=e*r+t*this.pHeight+s,this.vpBits[n]&=~this.ISDONE,this.vpBits[n]&this.INOUT&&this.vpBits[n]&this.ISBOUND){let i={ix:e,iy:t,iz:s};l.set(e,t,s,i),a.push(i),this.vpDistance[n]=0,this.vpBits[n]|=this.ISDONE,this.vpBits[n]&=~this.ISBOUND}do{for(d=this.fastoneshell(a,l),a=[],e=0,i=d.length;e<i;e++)n=r*d[e].ix+this.pHeight*d[e].iy+d[e].iz,this.vpBits[n]&=~this.ISBOUND,this.vpDistance[n]<=1.0404*o&&a.push({ix:d[e].ix,iy:d[e].iy,iz:d[e].iz})}while(0!==a.length);a=[],d=[],l=null;let c=this.scaleFactor-.5;c<0&&(c=0);let h=o-.5/(.1+c);for(e=0;e<this.pLength;e++)for(t=0;t<this.pWidth;t++)for(s=0;s<this.pHeight;s++)n=e*r+t*this.pHeight+s,this.vpBits[n]&=~this.ISBOUND,this.vpBits[n]&this.INOUT&&(this.vpBits[n]&this.ISDONE&&!(this.vpBits[n]&this.ISDONE&&this.vpDistance[n]>=h)||(this.vpBits[n]|=this.ISBOUND))},Je.prototype.fastoneshell=function(e,t){let s,i,n,l,r,o,a,d,c,h,p,m,u=[];if(0===e.length)return u;let g={ix:-1,iy:-1,iz:-1},f=this.pWidth*this.pHeight;for(a=0,c=e.length;a<c;a++)for(s=e[a].ix,i=e[a].iy,n=e[a].iz,p=t.get(s,i,n),d=0;d<6;d++)g.ix=s+this.nb[d][0],g.iy=i+this.nb[d][1],g.iz=n+this.nb[d][2],g.ix<this.pLength&&g.ix>-1&&g.iy<this.pWidth&&g.iy>-1&&g.iz<this.pHeight&&g.iz>-1&&(m=g.ix*f+this.pHeight*g.iy+g.iz,this.vpBits[m]&this.INOUT&&!(this.vpBits[m]&this.ISDONE)?(t.set(g.ix,g.iy,n+this.nb[d][2],p),l=g.ix-p.ix,r=g.iy-p.iy,o=g.iz-p.iz,h=l*l+r*r+o*o,this.vpDistance[m]=h,this.vpBits[m]|=this.ISDONE,this.vpBits[m]|=this.ISBOUND,u.push({ix:g.ix,iy:g.iy,iz:g.iz})):this.vpBits[m]&this.INOUT&&this.vpBits[m]&this.ISDONE&&(l=g.ix-p.ix,r=g.iy-p.iy,o=g.iz-p.iz,h=l*l+r*r+o*o,h<this.vpDistance[m]&&(t.set(g.ix,g.iy,g.iz,p),this.vpDistance[m]=h,this.vpBits[m]&this.ISBOUND||(this.vpBits[m]|=this.ISBOUND,u.push({ix:g.ix,iy:g.iy,iz:g.iz})))));for(a=0,c=e.length;a<c;a++)for(s=e[a].ix,i=e[a].iy,n=e[a].iz,p=t.get(s,i,n),d=6;d<18;d++)g.ix=s+this.nb[d][0],g.iy=i+this.nb[d][1],g.iz=n+this.nb[d][2],g.ix<this.pLength&&g.ix>-1&&g.iy<this.pWidth&&g.iy>-1&&g.iz<this.pHeight&&g.iz>-1&&(m=g.ix*f+this.pHeight*g.iy+g.iz,this.vpBits[m]&this.INOUT&&!(this.vpBits[m]&this.ISDONE)?(t.set(g.ix,g.iy,n+this.nb[d][2],p),l=g.ix-p.ix,r=g.iy-p.iy,o=g.iz-p.iz,h=l*l+r*r+o*o,this.vpDistance[m]=h,this.vpBits[m]|=this.ISDONE,this.vpBits[m]|=this.ISBOUND,u.push({ix:g.ix,iy:g.iy,iz:g.iz})):this.vpBits[m]&this.INOUT&&this.vpBits[m]&this.ISDONE&&(l=g.ix-p.ix,r=g.iy-p.iy,o=g.iz-p.iz,h=l*l+r*r+o*o,h<this.vpDistance[m]&&(t.set(g.ix,g.iy,g.iz,p),this.vpDistance[m]=h,this.vpBits[m]&this.ISBOUND||(this.vpBits[m]|=this.ISBOUND,u.push({ix:g.ix,iy:g.iy,iz:g.iz})))));for(a=0,c=e.length;a<c;a++)for(s=e[a].ix,i=e[a].iy,n=e[a].iz,p=t.get(s,i,n),d=18;d<26;d++)g.ix=s+this.nb[d][0],g.iy=i+this.nb[d][1],g.iz=n+this.nb[d][2],g.ix<this.pLength&&g.ix>-1&&g.iy<this.pWidth&&g.iy>-1&&g.iz<this.pHeight&&g.iz>-1&&(m=g.ix*f+this.pHeight*g.iy+g.iz,this.vpBits[m]&this.INOUT&&!(this.vpBits[m]&this.ISDONE)?(t.set(g.ix,g.iy,n+this.nb[d][2],p),l=g.ix-p.ix,r=g.iy-p.iy,o=g.iz-p.iz,h=l*l+r*r+o*o,this.vpDistance[m]=h,this.vpBits[m]|=this.ISDONE,this.vpBits[m]|=this.ISBOUND,u.push({ix:g.ix,iy:g.iy,iz:g.iz})):this.vpBits[m]&this.INOUT&&this.vpBits[m]&this.ISDONE&&(l=g.ix-p.ix,r=g.iy-p.iy,o=g.iz-p.iz,h=l*l+r*r+o*o,h<this.vpDistance[m]&&(t.set(g.ix,g.iy,g.iz,p),this.vpDistance[m]=h,this.vpBits[m]&this.ISBOUND||(this.vpBits[m]|=this.ISBOUND,u.push({ix:g.ix,iy:g.iy,iz:g.iz})))));return u},Je.prototype.marchingcubeinit=function(e){for(let t=0,s=this.vpBits.length;t<s;t++)1==e?this.vpBits[t]&=~this.ISBOUND:4==e?(this.vpBits[t]&=~this.ISDONE,this.vpBits[t]&this.ISBOUND&&(this.vpBits[t]|=this.ISDONE),this.vpBits[t]&=~this.ISBOUND):2==e?this.vpBits[t]&this.ISBOUND&&this.vpBits[t]&this.ISDONE?this.vpBits[t]&=~this.ISBOUND:this.vpBits[t]&this.ISBOUND&&!(this.vpBits[t]&this.ISDONE)&&(this.vpBits[t]|=this.ISDONE):3==e&&(this.vpBits[t]&=~this.ISBOUND)},Je.prototype.counter=function(){let e=Array(256);for(let t=0;t<256;t++)e[t]=[];this.incrementUsed=function(t,s){void 0===e[t][s]&&(e[t][s]={used:0,unused:0}),e[t][s].used++},this.incrementUnused=function(t,s){void 0===e[t][s]&&(e[t][s]={used:0,unused:0}),e[t][s].unused++};this.print=function(){let t=this.marchingCube.triTable,s=[];for(let i=0;i<t.length;i++){let n=[];for(let s=0;s<t[i].length;s+=3){let l=s/3;void 0!==e[i][l]&&e[i][l].unused||(n.push(t[i][s]),n.push(t[i][s+1]),n.push(t[i][s+2])),void 0===e[i][l]&&console.log("undef "+i+","+l)}s.push(n)}!function(e){let t="[";for(let s=0;s<e.length;s++){let i=0,n=e[s];for(let e=0;e<n.length;e++)i|=1<<n[e];t+="0x"+i.toString(16)+", "}t+="]"}(s)}},Je.prototype.marchingcube=function(e){this.marchingcubeinit(e),this.verts=[],this.faces=[],this.marchingCube.march(this.vpBits,this.verts,this.faces,{smooth:1,nX:this.pLength,nY:this.pWidth,nZ:this.pHeight});let t=this.pWidth*this.pHeight;for(let e=0,s=this.verts.length;e<s;e++)this.verts[e].atomid=this.vpAtomID[this.verts[e].x*t+this.pHeight*this.verts[e].y+this.verts[e].z],this.dataArray&&(this.verts[e].color=this.vpColor[this.verts[e].x*t+this.pHeight*this.verts[e].y+this.verts[e].z]),this.dataArray&&(this.verts[e].pot=this.vpPot[this.verts[e].x*t+this.pHeight*this.verts[e].y+this.verts[e].z]);let s,i=0;if(this.bCalcArea){let e={};s={};for(let t=0,n=this.faces.length;t<n;t+=3){let n=this.faces[t],l=this.faces[t+1],r=this.faces[t+2];if(n==l||l==r||n==r)continue;let o=Math.min(n,l,r),a=Math.max(n,l,r),d=o+"_"+(n+l+r-o-a)+"_"+a;if(e.hasOwnProperty(d))continue;e[d]=1;let c=this.verts[n].atomid,h=this.verts[l].atomid,p=this.verts[r].atomid;if(!this.atomsToShow[c]||!this.atomsToShow[h]||!this.atomsToShow[p])continue;let m=this.verts[n],u=this.verts[l],g=this.verts[r],f=(m.x-u.x)*(m.x-u.x)+(m.y-u.y)*(m.y-u.y)+(m.z-u.z)*(m.z-u.z),C=(m.x-g.x)*(m.x-g.x)+(m.y-g.y)*(m.y-g.y)+(m.z-g.z)*(m.z-g.z),b=(g.x-u.x)*(g.x-u.x)+(g.y-u.y)*(g.y-u.y)+(g.z-u.z)*(g.z-u.z),y=Math.min(f,C,b),v=Math.max(f,C,b),_=f+C+b-y-v,w=0;w=0==parseInt(100*(v-y))?.433*y:0==parseInt(100*(_-y))?.5*y:.707*y;let S=w/3;void 0===s[c]?s[c]=S:s[c]+=S,void 0===s[h]?s[h]=S:s[h]+=S,void 0===s[p]?s[p]=S:s[p]+=S,i+=w}i=i/this.scaleFactor/this.scaleFactor}return this.bCalcArea||this.marchingCube.laplacianSmooth(1,this.verts,this.faces),{area:i,serial2area:s,scaleFactor:this.scaleFactor}};class Ze{constructor(e){this.icn3d=e,this.INOUT=1,this.ISDONE=2,this.ISBOUND=4,this.isovalue=1.5,this.dataArray={},this.matrix=void 0,this.center=void 0,this.maxdist=void 0,this.pmin=void 0,this.pmax=void 0,this.water=void 0,this.header=void 0,this.type=void 0,this.rmsd_supr=void 0,this.loadPhiFrom=void 0,this.ptranx=0,this.ptrany=0,this.ptranz=0,this.probeRadius=1.4,this.defaultScaleFactor=2,this.scaleFactor=this.defaultScaleFactor,this.pHeight=0,this.pWidth=0,this.pLength=0,this.cutRadius=0,this.vpBits=null,this.vpGridTrans=null,this.vpAtomID=null,this.vertnumber=0,this.facenumber=0,this.pminx=0,this.pminy=0,this.pminz=0,this.pmaxx=0,this.pmaxy=0,this.pmaxz=0,this.depty={},this.widxz={},this.faces=void 0,this.verts=void 0,this.nb=[new Int32Array([1,0,0]),new Int32Array([-1,0,0]),new Int32Array([0,1,0]),new Int32Array([0,-1,0]),new Int32Array([0,0,1]),new Int32Array([0,0,-1]),new Int32Array([1,1,0]),new Int32Array([1,-1,0]),new Int32Array([-1,1,0]),new Int32Array([-1,-1,0]),new Int32Array([1,0,1]),new Int32Array([1,0,-1]),new Int32Array([-1,0,1]),new Int32Array([-1,0,-1]),new Int32Array([0,1,1]),new Int32Array([0,1,-1]),new Int32Array([0,-1,1]),new Int32Array([0,-1,-1]),new Int32Array([1,1,1]),new Int32Array([1,1,-1]),new Int32Array([1,-1,1]),new Int32Array([-1,1,1]),new Int32Array([1,-1,-1]),new Int32Array([-1,-1,1]),new Int32Array([-1,1,-1]),new Int32Array([-1,-1,-1])],this.marchingCube=new Ke}}Ze.prototype.getFacesAndVertices=function(e,t){let s,i,n={};for(s=0,i=t.length;s<i;s++)n[t[s]]=1;let l=this.verts,r={};for(s=0,i=l.length;s<i;s++){let e;if("phi"==this.type)e=new THREE.Vector3(l[s].x,l[s].y,l[s].z).multiplyScalar(1/this.header.scale).applyMatrix4(this.matrix);else{if(this.ccp4){let e,t=l[s].index;this.vpGridTrans[t]&&(e=t,l[s].x+=this.vpGridTrans[e][0]*this.header.xExtent*this.scaleFactor,l[s].y+=this.vpGridTrans[e][1]*this.header.xExtent*this.scaleFactor,l[s].z+=this.vpGridTrans[e][2]*this.header.xExtent*this.scaleFactor,r[e]=1)}e=new THREE.Vector3(l[s].x,l[s].y,l[s].z).applyMatrix4(this.matrix)}l[s].x=e.x,l[s].y=e.y,l[s].z=e.z}let o=[];for(s=0,i=this.faces.length;s<i;s+=3){let e=this.faces[s],t=this.faces[s+1],i=this.faces[s+2];e!==t&&t!==i&&e!==i&&(this.ccp4?r.hasOwnProperty(l[e].index)&&r.hasOwnProperty(l[t].index)&&r.hasOwnProperty(l[i].index)&&o.push({a:e,b:t,c:i}):o.push({a:e,b:t,c:i}))}return this.vpBits=null,this.vpGridTrans=null,this.vpAtomID=null,{vertices:l,faces:o}},Ze.prototype.initparm=function(e,t,s,i,n,l,r,o,a,d,c,h,p){this.header=e,this.loadPhiFrom=h,this.header&&void 0!==this.header.max?this.isovalue=this.header.min+(this.header.max-this.header.min)*i/100:this.header&&void 0!==this.header.mean?this.isovalue=this.header.mean+this.header.sigma*i:this.isovalue=i,this.dataArray=t,this.matrix=s,this.center=n,this.maxdist=l,this.pmin=r,this.pmax=o,this.water=a,this.type=d,this.rmsd_supr=c,this.pminx=0,this.pmaxx=this.header.xExtent-1,this.pminy=0,this.pmaxy=this.header.yExtent-1,this.pminz=0,this.pmaxz=this.header.zExtent-1,this.ptranx=-this.pminx,this.ptrany=-this.pminy,this.ptranz=-this.pminz;let m=this.pmaxx-this.pminx;this.pmaxy-this.pminy>m&&(m=this.pmaxy-this.pminy),this.pmaxz-this.pminz>m&&(m=this.pmaxz-this.pminz),this.scaleFactor=1,this.pLength=Math.floor(.5+this.scaleFactor*(this.pmaxx-this.pminx))+1,this.pWidth=Math.floor(.5+this.scaleFactor*(this.pmaxy-this.pminy))+1,this.pHeight=Math.floor(.5+this.scaleFactor*(this.pmaxz-this.pminz))+1,this.cutRadius=this.probeRadius*this.scaleFactor,this.vpBits=new Uint8Array(this.pLength*this.pWidth*this.pHeight),this.ccp4&&(this.vpGridTrans=new Array(this.pLength*this.pWidth*this.pHeight)),this.vpAtomID=new Uint8Array(this.pLength*this.pWidth*this.pHeight)},Ze.prototype.transformMemPro=function(e,t,s,i){let n=e.clone();n.sub(s);let l=n.x*t[0]+n.y*t[1]+n.z*t[2]+i.x,r=n.x*t[3]+n.y*t[4]+n.z*t[5]+i.y,o=n.x*t[6]+n.y*t[7]+n.z*t[8]+i.z;return n.x=l,n.y=r,n.z=o,n},Ze.prototype.fillvoxels=function(e,t){let s,i,n,l,r,o;for(s=0,l=this.vpBits.length;s<l;s++)this.vpBits[s]=0,this.vpAtomID[s]=0;let a=this.pWidth*this.pHeight,d=this.pHeight;if("phi"!=this.type||this.header.bSurface){let c=(new THREE.Matrix4).copy(this.matrix).invert(),h=[];this.maxdist=parseInt(this.maxdist);let p,m,u,g=new Array(9);if(void 0!==this.rmsd_supr&&void 0!==this.rmsd_supr.rot){p=this.rmsd_supr.rot,m=this.rmsd_supr.trans1,u=this.rmsd_supr.trans2;let e=new THREE.Matrix3,t=new THREE.Matrix3;e.set(p[0],p[1],p[2],p[3],p[4],p[5],p[6],p[7],p[8]),t.copy(e).invert(),g[0]=t.elements[0],g[1]=t.elements[3],g[2]=t.elements[6],g[3]=t.elements[1],g[4]=t.elements[4],g[5]=t.elements[7],g[6]=t.elements[2],g[7]=t.elements[5],g[8]=t.elements[8]}if("phi"==this.type&&this.header.bSurface){let l=new Float32Array(this.pLength*this.pWidth*this.pHeight);for(s=0;s<this.pLength;++s)for(i=0;i<this.pWidth;++i)for(n=0;n<this.pHeight;++n){let e,t=s*a+i*d+n;"phi"==this.header.filetype?e=n*a+i*d+s:"cube"==this.header.filetype&&(e=s*a+i*d+n),e<this.dataArray.length&&(l[t]=this.dataArray[e])}for(let s in t){let i=e[t[s]];if("DUM"===i.resn)continue;let n=i.coord.clone();if("delphi"!=this.loadPhiFrom)if(void 0!==this.rmsd_supr&&void 0!==this.rmsd_supr.rot){n=this.transformMemPro(i.coord,g,u,m).applyMatrix4(c)}else n=i.coord.clone().applyMatrix4(c);n.sub(this.header.ori).multiplyScalar(this.header.scale);let r=Math.floor(n.x),o=Math.ceil(n.x),h=Math.floor(n.y),p=Math.ceil(n.y),f=Math.floor(n.z),C=Math.ceil(n.z);o==r&&(o=r+1),p==h&&(p=h+1),C==f&&(C=f+1),o>this.pLength&&(o=this.pLength),p>this.pWidth&&(p=this.pWidth),C>this.pHeight&&(C=this.pHeight);let b,y=l[r*a+h*d+f],v=l[o*a+h*d+f],_=l[r*a+p*d+f],w=l[r*a+h*d+C],S=l[o*a+p*d+f],A=l[r*a+p*d+C],x=l[o*a+h*d+C],k=l[o*a+p*d+C],O=n.x-r,R=n.y-h,I=n.z-f,E=((y*(1-O)+v*O)*(1-R)+(_*(1-O)+S*O)*R)*(1-I)+((w*(1-O)+x*O)*(1-R)+(A*(1-O)+k*O)*R)*I;E>this.isovalue&&(E=this.isovalue),E<-this.isovalue&&(E=-this.isovalue),E>0?(E/=1*this.isovalue,b=new THREE.Color(1-E,1-E,1)):(E/=-1*this.isovalue,b=new THREE.Color(1,1-E,1-E)),this.icn3d.atoms[t[s]].color=b,this.icn3d.atomPrevColors[t[s]]=b}}else{for(let p in t){let f,C=e[t[p]];if("DUM"!==C.resn){if(void 0!==this.rmsd_supr&&void 0!==this.rmsd_supr.rot){f=this.transformMemPro(C.coord,g,u,m).applyMatrix4(c)}else f=C.coord.clone().applyMatrix4(c);for(s=Math.floor(f.x)-this.maxdist,l=Math.ceil(f.x)+this.maxdist;s<=l;++s)if(!(s<0||s>this.header.xExtent*this.scaleFactor-1))for(i=Math.floor(f.y)-this.maxdist,r=Math.ceil(f.y)+this.maxdist;i<=r;++i)if(!(i<0||i>this.header.yExtent*this.scaleFactor-1))for(n=Math.floor(f.z)-this.maxdist,o=Math.ceil(f.z)+this.maxdist;n<=o;++n){if(n<0||n>this.header.zExtent*this.scaleFactor-1)continue;let e=s*a+i*d+n;h.push(e)}}}for(s=0,l=h.length;s<l;++s){let e=h[s];"2fofc"==this.type?this.vpBits[e]=this.dataArray[e]>=this.isovalue?1:0:"fofc"==this.type?(this.vpBits[e]=this.dataArray[e]>=this.isovalue||this.dataArray[e]<=-this.isovalue?1:0,this.vpAtomID[e]=this.dataArray[e]>=0?1:0):"em"==this.type&&(this.vpBits[e]=this.dataArray[e]>=this.isovalue?1:0)}}}else for(s=0;s<this.pLength;++s)for(i=0;i<this.pWidth;++i)for(n=0;n<this.pHeight;++n){let e,t=s*a+i*d+n;"phi"==this.header.filetype?e=n*a+i*d+s:"cube"==this.header.filetype&&(e=s*a+i*d+n),e<this.dataArray.length&&(this.vpBits[t]=this.dataArray[e]>=this.isovalue||this.dataArray[e]<=-this.isovalue?1:0,this.vpAtomID[t]=this.dataArray[e]>=0?1:0)}for(s=0,l=this.vpBits.length;s<l;s++)this.vpBits[s]&this.INOUT&&(this.vpBits[s]|=this.ISDONE)},Ze.prototype.buildboundary=function(){let e,t,s,i=this.pWidth*this.pHeight;for(e=0;e<this.pLength;e++)for(t=0;t<this.pHeight;t++)for(s=0;s<this.pWidth;s++){let n=e*i+s*this.pHeight+t;if(this.vpBits[n]&this.INOUT){let l=0;for(;l<26;){let r=e+this.nb[l][0],o=t+this.nb[l][2],a=s+this.nb[l][1];if(r>-1&&r<this.pLength&&a>-1&&a<this.pWidth&&o>-1&&o<this.pHeight&&!(this.vpBits[r*i+a*this.pHeight+o]&this.INOUT)){this.vpBits[n]|=this.ISBOUND;break}l++}}}},Ze.prototype.marchingcubeinit=function(e){for(let t=0,s=this.vpBits.length;t<s;t++)1==e?this.vpBits[t]&=~this.ISBOUND:4==e?(this.vpBits[t]&=~this.ISDONE,this.vpBits[t]&this.ISBOUND&&(this.vpBits[t]|=this.ISDONE),this.vpBits[t]&=~this.ISBOUND):2==e?this.vpBits[t]&this.ISBOUND&&this.vpBits[t]&this.ISDONE?this.vpBits[t]&=~this.ISBOUND:this.vpBits[t]&this.ISBOUND&&!(this.vpBits[t]&this.ISDONE)&&(this.vpBits[t]|=this.ISDONE):this.vpBits[t]&=~this.ISBOUND},Ze.prototype.counter=function(){let e=Array(256);for(let t=0;t<256;t++)e[t]=[];this.incrementUsed=function(t,s){void 0===e[t][s]&&(e[t][s]={used:0,unused:0}),e[t][s].used++},this.incrementUnused=function(t,s){void 0===e[t][s]&&(e[t][s]={used:0,unused:0}),e[t][s].unused++};this.print=function(){let t=this.marchingCube.triTable,s=[];for(let i=0;i<t.length;i++){let n=[];for(let s=0;s<t[i].length;s+=3){let l=s/3;void 0!==e[i][l]&&e[i][l].unused||(n.push(t[i][s]),n.push(t[i][s+1]),n.push(t[i][s+2])),void 0===e[i][l]&&console.log("undef "+i+","+l)}s.push(n)}!function(e){let t="[";for(let s=0;s<e.length;s++){let i=0,n=e[s];for(let e=0;e<n.length;e++)i|=1<<n[e];t+="0x"+i.toString(16)+", "}t+="]"}(s)}},Ze.prototype.marchingcube=function(e){this.marchingcubeinit(e),this.verts=[],this.faces=[],this.marchingCube.march(this.vpBits,this.verts,this.faces,{smooth:1,nX:this.pLength,nY:this.pWidth,nZ:this.pHeight});let t=this.pWidth*this.pHeight;for(let e=0,s=this.verts.length;e<s;e++)this.verts[e].atomid=this.vpAtomID[this.verts[e].x*t+this.pHeight*this.verts[e].y+this.verts[e].z];this.marchingCube.laplacianSmooth(1,this.verts,this.faces)};class Qe{constructor(e){this.icn3d=e}createSurfaceRepresentation(e,t,s,i){let n,l=this.icn3d,r=l.icn3dui,o=this;if(0==Object.keys(e).length)return;null==i&&(i=1),l.opacity=i;let a=l.contactCls.getExtent(e),d=[];if(l.bConsiderNeighbors){let t;t=r.hashUtilsCls.unionHash(t,e),t=r.hashUtilsCls.unionHash(t,l.contactCls.getAtomsWithinAtom(l.atoms,e,5)),d=Object.keys(t)}else d=Object.keys(e);let c;10==parseInt(10*i)||s||l.bInstanced&&(Object.keys(l.atoms).length,l.biomtMatrices.length,l.maxatomcnt);let h={allatoms:l.atoms,atomsToShow:Object.keys(e),extendedAtoms:d,water:l.water,center:l.center,maxdist:1,pmin:l.pmin,pmax:l.pmax,rmsd_supr:l.rmsd_supr};if(11==t){if(h.header=l.mapData.header2,h.data=l.mapData.data2,h.matrix=l.mapData.matrix2,h.isovalue=l.mapData.sigma2,h.type="2fofc",h.ccp4=l.mapData.ccp4,h.grid=l.mapData.grid2,h.unit_cell=l.mapData.unit_cell2,!h.header&&!h.ccp4)return;if(c=this.SetupMap(h),h.ccp4)return void(l.mapData={})}else if(12==t){if(h.header=l.mapData.header,h.data=l.mapData.data,h.matrix=l.mapData.matrix,h.isovalue=l.mapData.sigma,h.type="fofc",h.ccp4=l.mapData.ccp4,h.grid=l.mapData.grid,h.unit_cell=l.mapData.unit_cell,!h.header&&!h.ccp4)return;if(c=this.SetupMap(h),h.ccp4)return void(l.mapData={})}else if(13==t)h.maxdist=3,h.header=l.mapData.headerEm,h.data=l.mapData.dataEm,h.matrix=l.mapData.matrixEm,h.isovalue=l.mapData.sigmaEm,h.type="em",c=this.SetupMap(h);else if(14==t)h.header=l.mapData.headerPhi,h.data=l.mapData.dataPhi,h.matrix=l.mapData.matrixPhi,h.isovalue=l.mapData.contourPhi,h.type="phi",h.loadPhiFrom=l.loadPhiFrom,c=this.SetupMap(h);else{let s=r.hashUtilsCls.exclHash(e,l.water);d=r.hashUtilsCls.exclHash(d,l.water);let i=t;21==i?i=1:22==i?i=2:23==i&&(i=3),h={extent:a,allatoms:l.atoms,atomsToShow:Object.keys(s),extendedAtoms:d,type:i,threshbox:l.transparentRenderOrder?60:l.threshbox,bCalcArea:l.bCalcArea},h.header=l.mapData.headerPhi,h.data=l.mapData.dataPhi,h.matrix=l.mapData.matrixPhi,h.isovalue=l.mapData.contourPhi,h.loadPhiFrom=l.loadPhiFrom,c=this.SetupSurface(h)}if(l.bCalcArea){l.areavalue=c.area.toFixed(2);let e=c.serial2area,t=c.scaleFactor*c.scaleFactor;l.resid2area={};let s={},i={};for(let t in e){let n=l.atoms[t],r=n.structure+"_"+n.chain+"_"+n.resi+"_"+n.resn;s[n.structure]=1,i[n.structure+"_"+n.chain]=1,void 0===l.resid2area[r]?l.resid2area[r]=e[t]:l.resid2area[r]+=e[t]}let n='<table border="1" cellpadding="10" cellspacing="0">',o=Object.keys(s).length>1?"<th>Structure</th>":"",a=Object.keys(i).length>1?"<th>Chain</th>":"";n+="<tr>"+o+a+"<th>Residue</th><th>Number</th><th>SASA (&#8491;<sup>2</sup>)</th><th>Percent Out</th><th>In/Out</th></tr>";for(let e in l.resid2area){let d=e.lastIndexOf("_"),c=e.substr(d+1),h=r.utilsCls.getIdArray(e.substr(0,d));o=Object.keys(s).length>1?"<td>"+h[0]+"</td>":"",a=Object.keys(i).length>1?"<td>"+h[1]+"</td>":"";let p="",m="";l.resid2area[e]=(l.resid2area[e]/t).toFixed(2),r.parasCls.residueArea.hasOwnProperty(c)&&(m=parseInt(l.resid2area[e]/r.parasCls.residueArea[c]*100),m>100&&(m=100),m>=50&&(p="out"),m<20&&(p="in")),n+='<tr align="center">'+o+a+"<td>"+c+'</td><td align="right">'+h[2]+'</td><td align="right">'+l.resid2area[e]+'</td><td align="right">'+m+"%</td><td>"+p+"</td></tr>"}return n+="</table>",void(l.areahtml=n)}let p,m,u,g=c.vertices,f=c.faces,C=r.parasCls.thr("#00FFFF"),b=r.parasCls.thr("#00FF00"),y=r.parasCls.thr("#ff0000"),v=r.parasCls.thr("#00FFFF"),_=r.parasCls.thr("#0000FF"),w=r.parasCls.thr("#FF0000");11!=t&&12!=t&&13!=t&&14!=t||void 0===l.rmsd_supr||void 0===l.rmsd_supr.rot||(p=l.rmsd_supr.rot,m=l.rmsd_supr.trans1,u=l.rmsd_supr.trans2);let S=(11==t||12==t||13==t||14==t&&"delphi"!=l.loadPhiFrom)&&void 0!==l.rmsd_supr&&void 0!==l.rmsd_supr.rot;n=new THREE.BufferGeometry;let A,x=[],k=[],O=[],R=0;for(let e=0,s=g.length;e<s;++e,R+=3){let s=g[e],i=new THREE.Vector3(s.x,s.y,s.z);if(S&&(i=o.transformMemPro(i,p,m,u)),x[R]=i.x,x[R+1]=i.y,x[R+2]=i.z,11==t)A=C;else if(12==t)A=s.atomid?b:y;else if(13==t)A=v;else if(14==t)A=s.atomid?_:w;else if(21==t||22==t||23==t){A=s.color;let e=s.atomid;l.atoms[e].pot=s.pot}else{let e=s.atomid;A=l.atoms[e].color}k[R]=A.r,k[R+1]=A.g,k[R+2]=A.b}if(r.bNode)return;R=0;for(let e=0,t=f.length;e<t;++e,R+=3){let t=f[e];O[R]=t.a,O[R+1]=t.b,O[R+2]=t.c}if(n.setAttribute("position",new THREE.BufferAttribute(new Float32Array(x),3)),n.setAttribute("color",new THREE.BufferAttribute(new Float32Array(k),3)),n.setIndex(new THREE.BufferAttribute(new Uint32Array(O),1)),n.computeVertexNormals(),n.type="Surface",l.transparentRenderOrder){let e={};for(let t=0,s=f.length;t<s;++t){let s=f[t].a,i=f[t].b,n=f[t].c;void 0===e[s]&&(e[s]=[]),e[s].push(i),e[s].push(n)}for(let n in e){this.geometry=new THREE.BufferGeometry;let o=[],a=[],d=[],c=0,h=0,p=0,m=e[n],u=new THREE.Vector3(0,0,0),f=3,C=0;for(let e=0,s=m.length;e<s;e+=2){let s=m[e],i=m[e+1];o[c++]=g[n].x,o[c++]=g[n].y,o[c++]=g[n].z,o[c++]=g[s].x,o[c++]=g[s].y,o[c++]=g[s].z,o[c++]=g[i].x,o[c++]=g[i].y,o[c++]=g[i].z,21==t||22==t||23==t?(a[h++]=g[n].color.r,a[h++]=g[n].color.g,a[h++]=g[n].color.b,a[h++]=g[s].color.r,a[h++]=g[s].color.g,a[h++]=g[s].color.b,a[h++]=g[i].color.r,a[h++]=g[i].color.g,a[h++]=g[i].color.b):(a[h++]=l.atoms[g[n].atomid].color.r,a[h++]=l.atoms[g[n].atomid].color.g,a[h++]=l.atoms[g[n].atomid].color.b,a[h++]=l.atoms[g[s].atomid].color.r,a[h++]=l.atoms[g[s].atomid].color.g,a[h++]=l.atoms[g[s].atomid].color.b,a[h++]=l.atoms[g[i].atomid].color.r,a[h++]=l.atoms[g[i].atomid].color.g,a[h++]=l.atoms[g[i].atomid].color.b);let r=e/2*3;d[p++]=r,d[p++]=r+1,d[p++]=r+2,u=u.add(new THREE.Vector3(g[r].x,g[r].y,g[r].z)),u=u.add(new THREE.Vector3(g[r+1].x,g[r+1].y,g[r+1].z)),u=u.add(new THREE.Vector3(g[r+2].x,g[r+2].y,g[r+2].z)),C+=3}this.geometry.setAttribute("position",new THREE.BufferAttribute(new Float32Array(o),f)),this.geometry.setAttribute("color",new THREE.BufferAttribute(new Float32Array(a),f)),this.geometry.setIndex(new THREE.BufferAttribute(new Uint32Array(d),1)),this.geometry.computeVertexNormals(),this.geometry.type="Surface";let b,y=new THREE.Mesh(this.geometry,new THREE.MeshBasicMaterial({specular:l.frac,shininess:0,emissive:l.emissive,vertexColors:!0,wireframe:s,opacity:i,transparent:!0,side:THREE.DoubleSide}));b=l.bControlGl&&!r.bNode?u.multiplyScalar(1/C).sub(l.oriCenter).applyMatrix4(window.cam.matrixWorldInverse):u.multiplyScalar(1/C).sub(l.oriCenter).applyMatrix4(l.cam.matrixWorldInverse),y.renderOrder=l.cam_z>0?-parseInt(b.z):parseInt(b.z),y.onBeforeRender=function(e,t,s,i,n,o){let a,d=new THREE.Vector3(0,0,0),c=i.getAttribute("position").array;for(let e=0,t=c.length;e<t;e+=3)d=d.add(new THREE.Vector3(c[e],c[e+1],c[e+2]));a=l.bControlGl&&!r.bNode?d.multiplyScalar(3/c.length).sub(l.oriCenter).applyMatrix4(window.cam.matrixWorldInverse):d.multiplyScalar(3/c.length).sub(l.oriCenter).applyMatrix4(l.cam.matrixWorldInverse),this.renderOrder=l.cam_z>0?-parseInt(a.z):parseInt(a.z)},l.mdl.add(y),11==t||12==t?l.prevMaps.push(y):13==t?l.prevEmmaps.push(y):14==t?l.prevPhimaps.push(y):l.prevSurfaces.push(y)}}else{let e=new THREE.Mesh(n,new THREE.MeshPhongMaterial({specular:l.frac,shininess:20,emissive:l.emissive,vertexColors:!0,wireframe:s,opacity:i,transparent:!0,depthWrite:10==parseInt(10*i),side:THREE.DoubleSide}));e.renderOrder=-2,l.mdl.add(e),11==t||12==t?l.prevMaps.push(e):13==t?l.prevEmmaps.push(e):14==t?l.prevPhimaps.push(e):l.prevSurfaces.push(e)}c=null,g=null,f=null,n=null}transformMemPro(e,t,s,i,n){this.icn3d.icn3dui;let l=e.clone();l.sub(s),n&&console.log("sub coord: "+JSON.stringify(l));let r=l.x*t[0]+l.y*t[1]+l.z*t[2]+i.x,o=l.x*t[3]+l.y*t[4]+l.z*t[5]+i.y,a=l.x*t[6]+l.y*t[7]+l.z*t[8]+i.z;return l.x=r,l.y=o,l.z=a,n&&console.log("out coord: "+JSON.stringify(l)),l}SetupSurface(e){let t=this.icn3d;t.icn3dui;let s=e.threshbox,i=new Je(t,s);i.initparm(e.extent,1!==e.type,e.bCalcArea,e.atomsToShow,e.header,e.data,e.matrix,e.isovalue,e.loadPhiFrom),i.fillvoxels(e.allatoms,e.extendedAtoms),i.buildboundary(),2===e.type&&(i.fastdistancemap(),i.boundingatom(!1),i.fillvoxelswaals(e.allatoms,e.extendedAtoms));let n=i.marchingcube();i.vpBits=null,i.vpDistance=null,i.vpAtomID=null;let l=i.getFacesAndVertices(e.atomsToShow);return l.area=n.area,l.serial2area=n.serial2area,l.scaleFactor=n.scaleFactor,i.faces=null,i.verts=null,l}SetupMap(e){let t=this.icn3d;if(t.icn3dui,!e.ccp4){let s,i=new Ze(t);return i.initparm(e.header,e.data,e.matrix,e.isovalue,e.center,e.maxdist,e.pmin,e.pmax,e.water,e.type,e.rmsd_supr,e.loadPhiFrom,e.icn3d),i.fillvoxels(e.allatoms,e.extendedAtoms),e.header.bSurface||i.buildboundary(),e.header.bSurface||i.marchingcube(),i.vpBits=null,i.vpAtomID=null,e.header.bSurface||(s=i.getFacesAndVertices(e.allatoms,e.atomsToShow)),i.faces=null,i.verts=null,s}{let s,i=10,n=t.center?[t.center.x,t.center.y,t.center.z]:[0,0,0];if("2fofc"==e.type){s="2fofc";let l=t.ccp4ParserCls.extract_block(e.grid,e.unit_cell,i,n,s),r=t.ccp4ParserCls.marchingCubes(l.size,l.values,l.points,e.isovalue,"marching cubes");t.ccp4ParserCls.makeChickenWire(r,s),l=null,r=null}else if("fofc"==e.type){s="fofc_neg";let l=t.ccp4ParserCls.extract_block(e.grid,e.unit_cell,i,n,s),r=t.ccp4ParserCls.marchingCubes(l.size,l.values,l.points,e.isovalue,"marching cubes");t.ccp4ParserCls.makeChickenWire(r,s),s="fofc_pos",l=t.ccp4ParserCls.extract_block(e.grid,e.unit_cell,i,n,s),r=t.ccp4ParserCls.marchingCubes(l.size,l.values,l.points,e.isovalue,"marching cubes"),t.ccp4ParserCls.makeChickenWire(r,s),l=null,r=null}}}}class et{constructor(e){this.icn3d=e}applyCenterOptions(e){let t,s=this.icn3d;switch(s.icn3dui,void 0===e&&(e=s.opts),e.rotationcenter.toLowerCase()){case"molecule center":void 0!==s.center&&this.setRotationCenter(s.center);break;case"pick center":void 0!==s.pAtom&&this.setRotationCenter(s.pAtom.coord);break;case"display center":t=this.centerAtoms(s.dAtoms).center,this.setRotationCenter(t);break;case"highlight center":t=this.centerAtoms(s.hAtoms).center,this.setRotationCenter(t)}}setRotationCenter(e){this.icn3d.icn3dui,this.setCenter(e)}setCenter(e){let t=this.icn3d;t.icn3dui,t.mdl.position.set(0,0,0),t.mdlImpostor.position.set(0,0,0),t.mdl_ghost.position.set(0,0,0),t.mdl.position.sub(e),t.mdlImpostor.position.sub(e),t.mdl_ghost.position.sub(e)}centerSelection(e,t){let s=this.icn3d,i=s.icn3dui;if(s.opts.rotationcenter="highlight center",void 0===e&&(e=i.hashUtilsCls.hash2Atoms(s.hAtoms,s.atoms)),t||(s._zoomFactor=1,s.mouseChange=new THREE.Vector2(0,0),s.quaternion=new THREE.Quaternion(0,0,0,1)),Object.keys(e).length>1){let t=this.centerAtoms(e);s.center=t.center,this.setCenter(s.center),s.cameraCls.setCamera()}}centerAtoms(e){let t=this.icn3d;t.icn3dui;let s=new THREE.Vector3(9999,9999,9999),i=new THREE.Vector3(-9999,-9999,-9999),n=new THREE.Vector3;for(let l in e){let e=t.atoms[l].coord;n.add(e),s.min(e),i.max(e)}let l=t.ParserUtilsCls.getGeoCenter(s,i);return{center:l,maxD:t.ParserUtilsCls.getStructureSize(e,s,i,l),pmin:s,pmax:i}}setWidthHeight(e,t){let s=this.icn3d;s.icn3dui,void 0===s.scaleFactor&&(s.scaleFactor=1),s.renderer.setSize(e*s.scaleFactor,t*s.scaleFactor),s.renderer.domElement.style.width=e*s.scaleFactor+"px",s.renderer.domElement.style.height=t*s.scaleFactor+"px",s.renderer.domElement.width=e*s.scaleFactor,s.renderer.domElement.height=t*s.scaleFactor,s.container.whratio=e/t}}class tt{constructor(e){this.icn3d=e}applyClbondsOptions(e){let t=this.icn3d,s=t.icn3dui;if(void 0===e&&(e=t.opts),t.bCalcCrossLink||(t.clbondpnts={},t.clbondResid2serial={},this.applyClbondsOptions_base("chemical"),this.applyClbondsOptions_base("all"),t.bCalcCrossLink=!0),"yes"===e.clbonds.toLowerCase()&&"nothing"!==e.chemicals){let e="#006400";if(s.parasCls.thr(25600),t.lines.clbond=[],t.residuesHashClbonds={},t.structures){let i=Object.keys(t.structures);for(let n=0,l=i.length;n<l;++n){let l=i[n];if(t.clbondpnts[l])for(let i=0,n=t.clbondpnts[l].length;i<n;i+=2){let n=t.clbondpnts[l][i],r=t.clbondpnts[l][i+1],o={};if(o.color=e,o.dashed=!1,o.radius=t.crosslinkRadius,o.serial1=t.clbondResid2serial[n+","+r],o.serial2=t.clbondResid2serial[r+","+n],!t.dAtoms.hasOwnProperty(o.serial1)||!t.dAtoms.hasOwnProperty(o.serial2))continue;o.position1=t.atoms[o.serial1].coord,o.position2=t.atoms[o.serial2].coord,t.lines.clbond.push(o);let a={};a=s.hashUtilsCls.unionHash(a,t.residues[n]),a=s.hashUtilsCls.unionHash(a,t.residues[r]);let d=s.hashUtilsCls.intHash(a,t.sidec);for(let e in d)t.atoms[e].style2="stick";t.residuesHashClbonds[n]=1,t.residuesHashClbonds[r]=1}}}}return t.residuesHashClbonds}applyClbondsOptions_base(e){let t=this.icn3d;t.icn3dui;for(let s in t.chemicals){let i=t.atoms[s],n=i.structure+"_"+i.chain+"_"+i.resi;for(let s in i.bonds){let l=t.atoms[i.bonds[s]];if(void 0!==l&&(l.chain!==i.chain||l.resi!==i.resi)){let s=l.structure+"_"+l.chain+"_"+l.resi;if("chemical"!=e||l.het){if("chemical"==e)continue;void 0===t.clbondpnts[i.structure]&&(t.clbondpnts[i.structure]=[]),t.clbondpnts[i.structure].push(n),t.clbondpnts[l.structure].push(s),t.clbondResid2serial[n+","+s]=i.serial,t.clbondResid2serial[s+","+n]=l.serial}}}}}}class st{constructor(e){this.icn3d=e}applyMissingResOptions(e){let t=this.icn3d;if(t.icn3dui,void 0===e&&(e=t.opts),t.bCalcMissingRes||(t.missingResPnts={},t.missingResResid2serial={},this.applyMissingResOptions_base(),t.bCalcMissingRes=!0),t.lines.missingres=[],t.structures){let e=Object.keys(t.structures);for(let s=0,i=e.length;s<i;++s){let i=e[s];if(t.missingResPnts[i])for(let e=0,s=t.missingResPnts[i].length;e<s;e+=2){let s=t.missingResPnts[i][e],n=t.missingResPnts[i][e+1],l={dashed:!0};l.serial1=t.missingResResid2serial[s+","+n],l.serial2=t.missingResResid2serial[n+","+s],l.color="#"+t.atoms[l.serial1].color.getHexString(),l.radius=t.coilWidth,t.dAtoms.hasOwnProperty(l.serial1)&&t.dAtoms.hasOwnProperty(l.serial2)&&(l.position1=t.atoms[l.serial1].coord,l.position2=t.atoms[l.serial2].coord,t.lines.missingres.push(l))}}}}applyMissingResOptions_base(e){let t=this.icn3d;t.icn3dui;let s=[];for(let e in t.chainsSeq){let i,n,l,r,o=!1,a=!1;for(let d=0,c=t.chainsSeq[e].length;d<c;++d)n=e+"_"+t.chainsSeq[e][d].resi,t.residues.hasOwnProperty(n)?(o=!0,r=!0):r=!1,!r&&a?i=l:o&&i&&r&&!a&&(s.push(i),s.push(n),i=void 0),a=r,l=n}for(let e=0,i=s.length;e<i;e+=2){let i=s[e],n=s[e+1],l=i.substr(0,i.indexOf("_"));i.substr(0,n.indexOf("_"));let r=t.firstAtomObjCls.getFirstCalphaAtomObj(t.residues[i]),o=t.firstAtomObjCls.getFirstCalphaAtomObj(t.residues[n]);r&&o&&(void 0===t.missingResPnts[l]&&(t.missingResPnts[l]=[]),t.missingResPnts[l].push(i),t.missingResPnts[l].push(n),t.missingResResid2serial[i+","+n]=r.serial,t.missingResResid2serial[n+","+i]=o.serial)}}}class it{constructor(e){this.icn3d=e}applyDisplayOptions(e,t,s){let i=this.icn3d,n=i.icn3dui;if(void 0===e&&(e=i.opts),!n.bNode&&""!=n.htmlCls.setHtmlCls.getCookie("lineRadius")){let e=parseFloat(n.htmlCls.setHtmlCls.getCookie("lineRadius")),t=parseFloat(n.htmlCls.setHtmlCls.getCookie("coilWidth")),s=parseFloat(n.htmlCls.setHtmlCls.getCookie("cylinderRadius")),l=n.htmlCls.setHtmlCls.getCookie("crosslinkRadius"),r=l&&!isNaN(l)?parseFloat(l):i.crosslinkRadius,o=parseFloat(n.htmlCls.setHtmlCls.getCookie("traceRadius")),a=parseFloat(n.htmlCls.setHtmlCls.getCookie("dotSphereScale")),d=parseFloat(n.htmlCls.setHtmlCls.getCookie("ribbonthickness")),c=parseFloat(n.htmlCls.setHtmlCls.getCookie("helixSheetWidth")),h=parseFloat(n.htmlCls.setHtmlCls.getCookie("nucleicAcidWidth"));i.bSetThicknessOnce||i.lineRadius==e&&i.coilWidth==t&&i.cylinderRadius==s&&i.crosslinkRadius==r&&i.traceRadius==o&&i.dotSphereScale==a&&i.ribbonthickness==d&&i.helixSheetWidth==c&&i.nucleicAcidWidth==h||(i.bSetThicknessOnce=!0,n.htmlCls.clickMenuCls.setLogCmd("set thickness | linerad "+e+" | coilrad "+t+" | stickrad "+s+" | crosslinkrad "+r+" | tracerad "+o+" | ribbonthick "+d+" | proteinwidth "+c+" | nucleotidewidth "+h+" | ballscale "+a,!0)),i.lineRadius=e,i.coilWidth=t,i.cylinderRadius=s,i.crosslinkRadius=r,i.traceRadius=o,i.dotSphereScale=a,i.ribbonthickness=d,i.helixSheetWidth=c,i.nucleicAcidWidth=h}let l,r={},o={},a={};if(1===s&&Object.keys(t).length<Object.keys(i.atoms).length){a=n.hashUtilsCls.hash2Atoms(t,i.atoms),r=i.firstAtomObjCls.getResiduesFromAtoms(t,i.atoms);for(let e in r){l=e;let t=e.lastIndexOf("_"),s=e.substr(0,t+1),i=e.substr(t+1);if(isNaN(i))continue;let n=parseInt(i),a=s+(n-1).toString();(n+1).toString(),r.hasOwnProperty(a)||r.hasOwnProperty(a)||(o[e]=1)}if(1===Object.keys(a).length&&Object.keys(i.residues[l]).length>1&&"sphere"!==a[Object.keys(a)[0]].style&&"dot"!==a[Object.keys(a)[0]].style){if(void 0===i.bCid||!i.bCid)for(let e in a){let t=a[e],n=1;i.boxCls.createBox(t,void 0,void 0,n,void 0,s)}}else for(let e in o){let l=i.firstAtomObjCls.getFirstCalphaAtomObj(i.residues[e]),r=l,o=r.structure+"_"+r.chain+"_"+(parseInt(r.resi)-1).toString(),a=r.structure+"_"+r.chain+"_"+(parseInt(r.resi)+1).toString();if("cylinder and plate"===r.style&&"helix"===r.ss)for(let t in i.residues[e]){let e=i.atoms[t],n=1;i.boxCls.createBox(e,void 0,void 0,n,void 0,s)}else if("ribbon"===r.style&&"coil"===r.ss||"strand"===r.style&&"coil"===r.ss||"o3 trace"===r.style||"schematic"===r.style||"c alpha trace"===r.style||"b factor tube"===r.style||"cylinder and plate"===r.style&&"helix"!==r.ss){if(void 0!==l&&void 0!==l.style2&&"nothing"!==l.style2)continue;let e=!1;if(!isNaN(r.resi)&&!e&&i.residues.hasOwnProperty(a)){let s=Object.keys(i.residues[a])[0],l=n.hashUtilsCls.hash2Atoms(i.residues[a],i.atoms)[s];if(r.style===l.style&&!l.ssbegin||l.ssbegin){let s=i.residues[a];if(t=n.hashUtilsCls.unionHash(t,s),e=!0,l.ssbegin)for(let e in s)i.atoms[e].notshow=!0}}if(!isNaN(r.resi)&&!e&&i.residues.hasOwnProperty(o)){let s=Object.keys(i.residues[o])[0],l=n.hashUtilsCls.hash2Atoms(i.residues[o],i.atoms)[s];r.style===l.style&&(t=n.hashUtilsCls.unionHash(t,i.residues[o]),e=!0)}}else if("ribbon"===r.style&&"coil"!==r.ss&&r.ssend||"strand"===r.style&&"coil"!==r.ss&&r.ssend){if(void 0!==l&&void 0!==l.style2&&"nothing"!==l.style2)continue;let e=!1;if(!isNaN(r.resi)&&!e&&i.residues.hasOwnProperty(a)){let s=Object.keys(i.residues[a])[0];n.hashUtilsCls.hash2Atoms(i.residues[a],i.atoms)[s],t=n.hashUtilsCls.unionHash(t,i.residues[a]),e=!0}}}a={}}if(i.bInitial&&void 0===i.bMembrane){if(""!=n.htmlCls.setHtmlCls.getCookie("membrane")){let e=parseInt(n.htmlCls.setHtmlCls.getCookie("membrane"));i.bMembrane!=e&&n.htmlCls.clickMenuCls.setLogCmd("set membrane "+e,!0),i.bMembrane=isNaN(e)?0:parseInt(e)}i.bMembrane?i.selectionCls.toggleMembrane(!0):i.selectionCls.toggleMembrane(!1)}i.setStyleCls.setStyle2Atoms(t);let d=.5*i.cylinderRadius;void 0!==i.labels&&delete i.labels.schematic;for(let e in i.style2atoms){let t=i.style2atoms[e],l=n.hashUtilsCls.intHash(t,i.nucleotides),r=n.utilsCls.isCalphaPhosOnly(n.hashUtilsCls.hash2Atoms(l,i.atoms));if("ribbon"===e)i.strandCls.createStrand(n.hashUtilsCls.hash2Atoms(t,i.atoms),2,void 0,!0,void 0,void 0,!1,i.ribbonthickness,s);else if("strand"===e)i.strandCls.createStrand(n.hashUtilsCls.hash2Atoms(t,i.atoms),null,null,null,null,null,!1,void 0,s);else if("cylinder and plate"===e)i.cylinderCls.createCylinderHelix(n.hashUtilsCls.hash2Atoms(t,i.atoms),i.cylinderHelixRadius,s);else if("nucleotide cartoon"===e)r?i.cylinderCls.createCylinderCurve(n.hashUtilsCls.hash2Atoms(t,i.atoms),["P"],i.traceRadius,!1,s):(i.cartoonNuclCls.drawCartoonNucleicAcid(n.hashUtilsCls.hash2Atoms(t,i.atoms),null,i.ribbonthickness,s),2!==s&&i.cartoonNuclCls.drawNucleicAcidStick(n.hashUtilsCls.hash2Atoms(t,i.atoms),s));else if("o3 trace"===e)r?i.cylinderCls.createCylinderCurve(n.hashUtilsCls.hash2Atoms(t,i.atoms),["P"],i.traceRadius,!1,s):i.cylinderCls.createCylinderCurve(n.hashUtilsCls.hash2Atoms(t,i.atoms),["O3'","O3*"],i.traceRadius,!1,s);else if("schematic"===e){let e=i.firstAtomObjCls.getFirstAtomObj(t);if(i.chemicals.hasOwnProperty(e.serial)){i.residueLabelsCls.addNonCarbonAtomLabels(n.hashUtilsCls.hash2Atoms(t,i.atoms));let e=!0;i.stickCls.createStickRepresentation(n.hashUtilsCls.hash2Atoms(t,i.atoms),d,d,void 0,s,e)}else i.residueLabelsCls.addResidueLabels(n.hashUtilsCls.hash2Atoms(t,i.atoms),!0),r?i.cylinderCls.createCylinderCurve(n.hashUtilsCls.hash2Atoms(t,i.atoms),["P"],i.traceRadius,!1,s):i.cylinderCls.createCylinderCurve(n.hashUtilsCls.hash2Atoms(t,i.atoms),["O3'","O3*"],i.traceRadius,!1,s),i.cylinderCls.createCylinderCurve(n.hashUtilsCls.hash2Atoms(t,i.atoms),["CA"],i.traceRadius,!1,s)}else"c alpha trace"===e?i.cylinderCls.createCylinderCurve(n.hashUtilsCls.hash2Atoms(t,i.atoms),["CA"],i.traceRadius,!1,s):"b factor tube"===e?i.tubeCls.createTube(n.hashUtilsCls.hash2Atoms(t,i.atoms),"CA",null,s,!1,!0):"custom tube"===e?i.tubeCls.createTube(n.hashUtilsCls.hash2Atoms(t,i.atoms),"CA",null,s,!0,!0):"lines"===e||"lines2"===e?(1===s?i.stickCls.createStickRepresentation(n.hashUtilsCls.hash2Atoms(t,i.atoms),i.hlLineRadius,i.hlLineRadius,void 0,s):i.lineCls.createLineRepresentation(n.hashUtilsCls.hash2Atoms(t,i.atoms),s),i.lineCls.createConnCalphSidechain(n.hashUtilsCls.hash2Atoms(t,i.atoms),e)):"stick"===e||"stick2"===e?(i.stickCls.createStickRepresentation(n.hashUtilsCls.hash2Atoms(t,i.atoms),i.cylinderRadius,i.cylinderRadius,void 0,s,void 0),i.lineCls.createConnCalphSidechain(n.hashUtilsCls.hash2Atoms(t,i.atoms),e)):"backbone"===e?(t=this.selectMainChainSubset(t),i.stickCls.createStickRepresentation(n.hashUtilsCls.hash2Atoms(t,i.atoms),i.cylinderRadius,i.cylinderRadius,void 0,s,void 0)):"ball and stick"===e||"ball and stick2"===e?(i.stickCls.createStickRepresentation(n.hashUtilsCls.hash2Atoms(t,i.atoms),i.cylinderRadius,.5*i.cylinderRadius,i.dotSphereScale,s,void 0),i.lineCls.createConnCalphSidechain(n.hashUtilsCls.hash2Atoms(t,i.atoms),e)):"sphere"===e||"sphere2"===e?i.sphereCls.createSphereRepresentation(n.hashUtilsCls.hash2Atoms(t,i.atoms),i.sphereRadius,void 0,void 0,s):"dot"===e&&i.sphereCls.createSphereRepresentation(n.hashUtilsCls.hash2Atoms(t,i.atoms),i.sphereRadius,!1,i.dotSphereScale,s)}if(i.cnt>i.maxmaxatomcnt&&i.init_base(),void 0!==i.labels&&Object.keys(i.labels).length>0){i.labelCls.hideLabels();for(let e in i.labels)"schematic"!=e&&this.changeLabelColor(i.labels[e]);i.labelCls.createLabelRepresentation(i.labels)}}changeLabelColor(e){let t=this.icn3d;if(t.icn3dui,e)for(let s=0,i=e.length;s<i;++s){let i=e[s];"black"!=t.opts.background&&i.color==t.colorBlackbkgd?i.color=t.colorWhitebkgd:"black"==t.opts.background&&i.color==t.colorWhitebkgd&&(i.color=t.colorBlackbkgd)}}selectMainChainSubset(e){let t=this.icn3d;t.icn3dui;let s=["C1'","C1*","C2'","C2*","C3'","C3*","C4'","C4*","C5'","C5*","O3'","O3*","O4'","O4*","O5'","O5*","P","OP1","O1P","OP2","O2P"],i={};for(let n in e)(t.proteins.hasOwnProperty(n)&&("N"===t.atoms[n].name||"C"===t.atoms[n].name||"O"===t.atoms[n].name||"CA"===t.atoms[n].name&&"C"===t.atoms[n].elem)||t.nucleotides.hasOwnProperty(n)&&-1!==s.indexOf(t.atoms[n].name))&&(i[n]=1);return i}}class nt{constructor(e){this.icn3d=e}applyOtherOptions(e){let t=this.icn3d,s=t.icn3dui;if(void 0===e&&(e=t.opts),t.hBondCls.setHbondsContacts(e,"contact"),t.hBondCls.setHbondsContacts(e,"halogen"),t.hBondCls.setHbondsContacts(e,"pi-cation"),t.hBondCls.setHbondsContacts(e,"pi-stacking"),t.hBondCls.setHbondsContacts(e,"hbond"),t.hBondCls.setHbondsContacts(e,"saltbridge"),void 0!==t.pairArray&&t.pairArray.length>0){this.updateStabilizer();let e="#FFFFFF",s=t.stabilizerpnts;t.lines.stabilizer=[];for(let i=0,n=Math.floor(s.length/2);i<n;i++){let n={};n.position1=s[2*i],n.position2=s[2*i+1],n.color=e,n.dashed=!1,t.lines.stabilizer.push(n)}}if(t.lineCls.createLines(t.lines),t.distPnts&&t.distPnts.length>0)for(let e=0,s=t.distPnts.length;e<s;++e)t.boxCls.createBox_base(t.distPnts[e],t.originSize,t.hColor,!1);if(void 0!==t.prevMaps)for(let e=0,s=t.prevMaps.length;e<s;++e)t.mdl.add(t.prevMaps[e]);if(void 0!==t.prevEmmaps)for(let e=0,s=t.prevEmmaps.length;e<s;++e)t.mdl.add(t.prevEmmaps[e]);if(void 0!==t.prevPhimaps)for(let e=0,s=t.prevPhimaps.length;e<s;++e)t.mdl.add(t.prevPhimaps[e]);if(void 0!==t.prevSurfaces)for(let e=0,s=t.prevSurfaces.length;e<s;++e)t.mdl.add(t.prevSurfaces[e]);if(void 0!==t.symmetryHash&&void 0!==t.symmetrytitle&&t.applySymdCls.applySymmetry(t.symmetrytitle),void 0!==t.symdArray&&t.symdArray.length>0&&t.applySymdCls.applySymd(),void 0!==t.prevOtherMesh)for(let e=0,s=t.prevOtherMesh.length;e<s;++e)t.mdl.add(t.prevOtherMesh[e]);if(t.bInitial&&void 0===t.bGlycansCartoon&&""!=s.htmlCls.setHtmlCls.getCookie("glycan")){let e=parseInt(s.htmlCls.setHtmlCls.getCookie("glycan"));t.bGlycansCartoon!=e&&s.htmlCls.clickMenuCls.setLogCmd("set glycan "+e,!0),t.bGlycansCartoon=e}t.bGlycansCartoon&&!t.bAlternate&&t.glycanCls.showGlycans();for(let e in t.shapeCmdHash)"add cube"==e.substr(0,8)?t.applyCommandCls.addShape(e,"cube"):t.applyCommandCls.addShape(e,"sphere");switch(t.applyCenterCls.applyCenterOptions(e),t.axesCls.buildAllAxes(void 0,!0),e.axis.toLowerCase()){case"yes":t.axis=!0,t.axesCls.buildAxes(t.maxD/2);break;case"no":t.axis=!1}switch(e.pk.toLowerCase()){case"atom":t.pk=1;break;case"no":t.pk=0;break;case"residue":t.pk=2;break;case"strand":t.pk=3}}applyChemicalbindingOptions(e){let t=this.icn3d,s=t.icn3dui;if(void 0===e&&(e=t.opts),"show"===e.chemicalbinding){let e;void 0!==t.chemicals&&Object.keys(t.chemicals).length>0&&(e=s.hashUtilsCls.hash2Atoms(t.chemicals,t.atoms));let i=4;if(void 0!==e){let n=t.contactCls.getAtomsWithinAtom(t.atoms,e,i),l=3.5;t.opts.hbonds="yes",Object.keys(n).length>0&&t.hBondCls.calculateChemicalHbonds(e,n,parseFloat(l)),t.bSetFog||t.transformCls.zoominSelection(s.hashUtilsCls.unionHash(e,n))}}else"hide"===e.chemicalbinding&&(t.hBondCls.hideHbonds(),t.showInterCls.hideExtraBonds(),t.bSetFog||t.transformCls.zoominSelection(t.atoms))}updateStabilizer(){let e=this.icn3d;if(e.icn3dui,e.stabilizerpnts=[],void 0!==e.pairArray)for(let t=0,s=e.pairArray.length;t<s;t+=2){let s=this.getResidueRepPos(e.pairArray[t]),i=this.getResidueRepPos(e.pairArray[t+1]);e.stabilizerpnts.push(s),e.stabilizerpnts.push(i)}}getResidueRepPos(e){let t=this.icn3d;t.icn3dui;let s,i=t.atoms[e],n=i.structure+"_"+i.chain+"_"+i.resi;if(t.proteins.hasOwnProperty(e)||t.nucleotides.hasOwnProperty(e))for(let e in t.residues[n]){let i=t.atoms[e];if("N3"===i.name){s=t.atoms[e].coord;break}if("CA"===i.name&&"coil"==i.ss){s=t.atoms[e].coord;break}if("CA"===i.name&&("helix"==i.ss||"sheet"==i.ss)){s=void 0!==t.atoms[e].coord2?t.atoms[e].coord2:t.atoms[e].coord;break}}else s=i.coord;return void 0===s&&(s=i.coord),s}}class lt{constructor(e){this.icn3d=e}applySsbondsOptions(e){let t=this.icn3d,s=t.icn3dui;if(void 0===e&&(e=t.opts),"yes"===e.ssbonds.toLowerCase()&&void 0!==t.ssbondpnts){let e,i,n="#FFFF00",l=s.parasCls.thr(16776960),r=Object.keys(t.structures);if(t.bAlternate){let s=r.length;e=t.ALTERNATE_STRUCTURE%s,i=t.ALTERNATE_STRUCTURE%s+1}else e=0,i=r.length;t.lines.ssbond=[];for(let o=e,a=i;o<a;++o){let e=r[o];if(t.ssbondpnts[e])for(let i=Math.floor(t.ssbondpnts[e].length/2)-1;i>=0;i--){let r=t.ssbondpnts[e][2*i],o=t.ssbondpnts[e][2*i+1],a={};a.color=n,a.dashed=!1;let d=[],c=[],h=[],p=[],m=!1,u=!1;for(let e in t.residues[r])"SG"===t.atoms[e].name&&(h.push(t.atoms[e].coord),d.push(t.atoms[e].serial),m=!0);if(!m)for(let e in t.residues[r])if("CA"===t.atoms[e].name){h.push(t.atoms[e].coord),d.push(t.atoms[e].serial),m=!0,u=!0;break}m=!1;for(let e in t.residues[o])"SG"===t.atoms[e].name&&(p.push(t.atoms[e].coord),c.push(t.atoms[e].serial),m=!0);if(!m)for(let e in t.residues[o])if("CA"===t.atoms[e].name){p.push(t.atoms[e].coord),c.push(t.atoms[e].serial),m=!0,u=!0;break}let g=u?7:3,f=!1;for(let e=0,t=h.length;e<t;++e)for(let t=0,s=p.length;t<s;++t)if(h[e].distanceTo(p[t])<g){f=!0,a.serial1=d[e],a.position1=h[e],a.serial2=c[t],a.position2=p[t];break}if(void 0!==a.serial1&&void 0!==a.serial2&&!t.dAtoms.hasOwnProperty(a.serial1)&&!t.dAtoms.hasOwnProperty(a.serial2))continue;if(!f){t.ssbondpnts[e].splice(2*i,2);continue}let C,b,y,v=t.atoms[a.serial1].bonds.indexOf(a.serial2);-1!=v&&(C=t.atoms[a.serial1].bonds.slice(0,v),b=t.atoms[a.serial1].bonds.slice(v+1),t.atoms[a.serial1].bonds=C.concat(b)),v=t.atoms[a.serial2].bonds.indexOf(a.serial1),-1!=v&&(C=t.atoms[a.serial2].bonds.slice(0,v),b=t.atoms[a.serial2].bonds.slice(v+1),t.atoms[a.serial2].bonds=C.concat(b)),t.lines.ssbond.push(a),y=s.hashUtilsCls.unionHash(y,t.residues[r]),y=s.hashUtilsCls.unionHash(y,t.residues[o]);let _=t.firstAtomObjCls.getFirstAtomObj(y),w="lines"==_.style?"lines":"stick";"lines"!=_.style&&t.cylinderCls.createCylinder(a.position1,a.position2,t.cylinderRadius,l);let S=s.hashUtilsCls.intHash(y,t.sidec);for(let e in S)t.atoms[e].style2=w}}}}}class rt{constructor(e){this.icn3d=e}applySymd(){let e=this.icn3d;e.icn3dui;for(let t=0,s=e.symdArray.length;t<s;++t){let s=e.symdArray[t],i=Object.keys(s)[0];this.applySymmetry(i,!0,s[i])}}applySymmetry(e,t,s){let i=this.icn3d,n=i.icn3dui,l=t?s:i.symmetryHash[e];l||(l=[]);let r=e.substr(0,1),o=parseInt(e.substring(1,e.indexOf(" "))),a=1.5*i.cylinderRadius,d=1*i.cylinderRadius,c=[];for(let e=0,s=l.length;e<s;++e){let s=l[e][0],h=l[e][1],p=l[e][2],m=l[e][3],u=l[e][4],g=l[e][5];i.cylinderCls.createCylinder(s,h,a,p,0);let f=h.clone().sub(s).normalize();if(n.htmlCls.clickMenuCls.setLogCmd("Symmetry Axis: "+f.x.toFixed(3)+" "+f.y.toFixed(3)+" "+f.z.toFixed(3),!1),!i.bAxisOnly){if("C"==r||"D"==r&&u==o){let e={};Object.keys(i.chains).length;let l=!1,r={};if(t&&Object.keys(i.hAtoms).length<Object.keys(i.atoms).length){for(let e in i.hAtoms){let t=i.atoms[e];r[t.structure+"_"+t.chain]=1}Object.keys(r).length>1&&(l=!0)}if(t)if(l){let t=Object.keys(r)[0];e=i.chains[t]}else{0==Object.keys(i.hAtoms).length&&(i.hAtoms=n.hashUtilsCls.cloneHash(i.dAtoms));let t,s=parseInt(Object.keys(i.hAtoms).length/u),l=0;for(let n in i.hAtoms)if(e[n]=1,t=n,++l,l>s)break;let r=i.atoms[t].structure+"_"+i.atoms[t].chain+"_"+i.atoms[t].resi;e=n.hashUtilsCls.unionHash(e,i.residues[r])}else{let t=Object.keys(i.structures)[0]+"_"+g;if(i.chains.hasOwnProperty(t)||(t=Object.keys(i.structures)[0]+"_"+g.toLowerCase()),!i.chains.hasOwnProperty(t)){t=Object.keys(i.chains)[0];for(let e in i.chains){let s=Object.keys(i.chains[e])[0];if(i.proteins.hasOwnProperty(s)){t=e;break}}}e=i.chains[t]}let a=s.clone().add(h).multiplyScalar(.5),c=new THREE.Vector3,p=0,f=h.clone().sub(s).normalize(),C=new THREE.Vector3(0,0,1),b=new THREE.Quaternion;b.setFromUnitVectors(f,C);let y=-9999;for(let t in e){let e=i.atoms[t].coord.clone();c.add(e),e.sub(a).applyQuaternion(b);let s=e.x*e.x+e.y*e.y;s>y&&(y=s),++p}let v=i.ParserUtilsCls.getMassCenter(c,p),_=new THREE.Line3(s,h),w=new THREE.Vector3;_.closestPointToPoint(v,!0,w);let S,A,x,k,O=Math.sqrt(y),R=v.clone().sub(w).normalize().multiplyScalar(O),I=a.clone().add(s.clone().sub(a).multiplyScalar(.83)).add(R),E=a.clone().add(h.clone().sub(a).multiplyScalar(.83)).add(R),T=2*Math.PI/o;for(let e=0;e<o;++e){let t=(.5+e)*T,n=I.clone().sub(s);n.applyAxisAngle(f,t).add(s);let l=E.clone().sub(s);l.applyAxisAngle(f,t).add(s),i.cylinderCls.createCylinder(n,l,d,m,0),i.sphereCls.createSphereBase(n,m,d,1,0),i.sphereCls.createSphereBase(l,m,d,1,0),0==e?(S=n,A=l):(i.cylinderCls.createCylinder(n,x,d,m,0),i.cylinderCls.createCylinder(l,k,d,m,0)),x=n,k=l}S&&x&&i.cylinderCls.createCylinder(S,x,d,m,0),A&&k&&i.cylinderCls.createCylinder(A,k,d,m,0)}else("T"==r&&3==u||"O"==r&&4==u||"I"==r&&5==u)&&(c.push(s),c.push(h));if("T"==r){let e=c[0];i.sphereCls.createSphereBase(e,m,d,1,0);let t,s,n,l=e.distanceTo(c[2]),r=e.distanceTo(c[3]);l<r?(t=l,s=c[3]):(t=r,s=c[2]),i.sphereCls.createSphereBase(s,m,d,1,0),i.cylinderCls.createCylinder(e,s,d,m,0);for(let l=4,r=c.length;l<r;++l){let r=c[l];e.distanceTo(r)>t&&(i.sphereCls.createSphereBase(r,m,d,1,0),i.cylinderCls.createCylinder(e,r,d,m,0),i.cylinderCls.createCylinder(s,r,d,m,0),void 0!==n&&i.cylinderCls.createCylinder(c[n],r,d,m,0),n=l)}}else if("O"==r)for(let e=0,t=c.length;e<t;e+=2){let t=c[e],s=c[e+1];i.sphereCls.createSphereBase(t,m,d,1,0),i.sphereCls.createSphereBase(s,m,d,1,0);for(let n=e+2,l=c.length;n<l;++n){let e=c[n];i.sphereCls.createSphereBase(e,m,d,1,0),i.cylinderCls.createCylinder(t,e,d,m,0),i.cylinderCls.createCylinder(s,e,d,m,0)}}else if("I"==r)for(let e=0,t=c.length;e<t;e+=2){let t=c[e],s=c[e+1];i.sphereCls.createSphereBase(t,m,d,1,0),i.sphereCls.createSphereBase(s,m,d,1,0);for(let n=e+2,l=c.length;n<l;n+=2){let e,l,r=c[n],o=c[n+1];t.distanceTo(r)<t.distanceTo(o)?(e=r,l=o):(e=o,l=r),i.sphereCls.createSphereBase(e,m,d,1,0),i.sphereCls.createSphereBase(l,m,d,1,0),i.cylinderCls.createCylinder(t,e,d,m,0),i.cylinderCls.createCylinder(s,l,d,m,0)}}}}}}class ot{constructor(e){this.icn3d=e}applySurfaceOptions(e){let t,s,i=this.icn3d,n=i.icn3dui;switch(void 0===e&&(e=i.opts),e.wireframe){case"yes":e.wireframe=!0;break;case"no":e.wireframe=!1}switch(e.opacity=parseFloat(e.opacity),t=n.hashUtilsCls.intHash(i.dAtoms,i.hAtoms),"nothing"===e.water&&(t=n.hashUtilsCls.exclHash(t,i.water)),s=n.hashUtilsCls.hash2Atoms(t,i.atoms),e.surface.toLowerCase()){case"van der waals surface":case"van der waals surface with context":i.surfaceCls.createSurfaceRepresentation(s,1,e.wireframe,e.opacity);break;case"solvent accessible surface":case"solvent accessible surface with context":i.surfaceCls.createSurfaceRepresentation(s,3,e.wireframe,e.opacity);break;case"molecular surface":case"molecular surface with context":i.surfaceCls.createSurfaceRepresentation(s,2,e.wireframe,e.opacity);break;case"nothing":this.removeSurfaces()}}applyMapOptions(e){let t,s,i=this.icn3d,n=i.icn3dui;switch(void 0===e&&(e=i.opts),e.mapwireframe){case"yes":e.mapwireframe=!0;break;case"no":e.mapwireframe=!1}switch(t=n.hashUtilsCls.intHash(i.dAtoms,i.hAtoms),s=n.hashUtilsCls.hash2Atoms(t,i.atoms),e.map.toLowerCase()){case"2fofc":i.surfaceCls.createSurfaceRepresentation(s,11,e.mapwireframe);break;case"fofc":i.surfaceCls.createSurfaceRepresentation(s,12,e.mapwireframe);break;case"nothing":this.removeMaps()}}applyEmmapOptions(e){let t,s,i=this.icn3d,n=i.icn3dui;switch(void 0===e&&(e=i.opts),e.emmapwireframe){case"yes":e.emmapwireframe=!0;break;case"no":e.emmapwireframe=!1}switch(t=n.hashUtilsCls.intHash(i.dAtoms,i.hAtoms),s=n.hashUtilsCls.hash2Atoms(t,i.atoms),e.emmap.toLowerCase()){case"em":i.surfaceCls.createSurfaceRepresentation(s,13,e.emmapwireframe);break;case"nothing":this.removeEmmaps()}}applyPhimapOptions(e){let t,s,i=this.icn3d,n=i.icn3dui;switch(void 0===e&&(e=i.opts),e.phimapwireframe){case"yes":e.phimapwireframe=!0;break;case"no":e.phimapwireframe=!1}switch(t=n.hashUtilsCls.intHash(i.dAtoms,i.hAtoms),s=n.hashUtilsCls.hash2Atoms(t,i.atoms),e.phimap.toLowerCase()){case"phi":i.surfaceCls.createSurfaceRepresentation(s,14,e.phimapwireframe);break;case"nothing":this.removePhimaps()}}applyphisurfaceOptions(e){let t,s,i=this.icn3d,n=i.icn3dui;switch(void 0===e&&(e=i.opts),i.phisurfwf){case"yes":e.phisurfwf=!0;break;case"no":e.phisurfwf=!1}switch(e.phisurfop=parseFloat(i.phisurfop),t=n.hashUtilsCls.intHash(i.dAtoms,i.hAtoms),"nothing"===e.water&&(t=n.hashUtilsCls.exclHash(t,i.water)),s=n.hashUtilsCls.hash2Atoms(t,i.atoms),e.phisurface.toLowerCase()){case"phi":i.surfaceCls.createSurfaceRepresentation(s,parseInt(i.phisurftype),e.phisurfwf,e.phisurfop);break;case"nothing":this.removeSurfaces()}}removeSurfaces(){let e=this.icn3d;e.icn3dui;for(let t=0,s=e.prevSurfaces.length;t<s;++t)e.mdl.remove(e.prevSurfaces[t]);e.prevSurfaces=[]}removeLastSurface(){let e=this.icn3d;e.icn3dui,e.prevSurfaces.length>0&&(e.mdl.remove(e.prevSurfaces[e.prevSurfaces.length-1]),e.prevSurfaces.slice(e.prevSurfaces.length-1,1))}removeMaps(){let e=this.icn3d;e.icn3dui;for(let t=0,s=e.prevMaps.length;t<s;++t)e.mdl.remove(e.prevMaps[t]);e.prevMaps=[]}removeEmmaps(){let e=this.icn3d;e.icn3dui;for(let t=0,s=e.prevEmmaps.length;t<s;++t)e.mdl.remove(e.prevEmmaps[t]);e.prevEmmaps=[]}removePhimaps(){let e=this.icn3d;e.icn3dui;for(let t=0,s=e.prevPhimaps.length;t<s;++t)e.mdl.remove(e.prevPhimaps[t]);e.prevPhimaps=[]}removeLastMap(){let e=this.icn3d;e.icn3dui,e.prevMaps.length>0&&(e.mdl.remove(e.prevMaps[e.prevMaps.length-1]),e.prevMaps.slice(e.prevMaps.length-1,1))}removeLastEmmap(){let e=this.icn3d;e.icn3dui,e.prevEmmaps.length>0&&(e.mdl.remove(e.prevEmmaps[e.prevEmmaps.length-1]),e.prevEmmaps.slice(e.prevEmmaps.length-1,1))}removeLastPhimap(){let e=this.icn3d;e.icn3dui,e.prevPhimaps.length>0&&(e.mdl.remove(e.prevPhimaps[e.prevPhimaps.length-1]),e.prevPhimaps.slice(e.prevPhimaps.length-1,1))}}class at{constructor(e){this.icn3d=e}addResidueLabels(e,t,s,i,n){let l=this.icn3d,r=l.icn3dui;if(r.bNode)return;let o=r.hashUtilsCls.intHash(l.hAtoms,e);t?void 0===l.labels.schematic&&(l.labels.schematic=[]):void 0===l.labels.residue&&(l.labels.residue=[]);let a="";for(let e in o){let s=l.atoms[e],o={},d=s.structure+"_"+s.chain+"_"+s.resi;if(!s.het&&("CA"===s.name||"O3'"===s.name||"O3*"===s.name)||l.water.hasOwnProperty(s.serial)||l.ions.hasOwnProperty(s.serial)||l.chemicals.hasOwnProperty(s.serial)&&d!==a){if(o.position=s.coord,o.bSchematic=0,t&&(o.bSchematic=1),o.text=r.utilsCls.residueName2Abbr(s.resn),i)o.text+=s.resi;else if(n){let e=s.structure+"_"+s.chain+"_"+s.resi,t="";l.resid2refnum[e]&&(t=" "==l.resid2refnum[e].substr(0,1)?"":l.resid2refnum[e]),o.text=t}o.size=18,o.factor=.3;let e=s.color.getHexString().toUpperCase();o.color=i?"black"!=l.opts.background?l.colorWhitebkgd:l.colorBlackbkgd:n?"#00FFFF":"CCCCCC"===e||"C8C8C8"===e?"#888888":"#"+e,o.background="#FFFFFF",t?l.labels.schematic.push(o):l.labels.residue.push(o)}a=d}l.hlObjectsCls.removeHlObjects()}addIgLabels(e){let t=this.icn3d;if(t.icn3dui.bNode)return;t.labels.ig=[];let s=t.firstAtomObjCls.getChainsFromAtoms(e);for(let e in t.igLabel2Pos)if(s.hasOwnProperty(e))for(let s in t.igLabel2Pos[e]){let i={};i.position=t.igLabel2Pos[e][s],i.text=s,i.size=60,i.color="#00FFFF",t.labels.ig.push(i)}t.hlObjectsCls.removeHlObjects()}addNonCarbonAtomLabels(e){let t=this.icn3d,s=t.icn3dui;if(s.bNode)return;let i=s.hashUtilsCls.intHash(t.hAtoms,e);void 0===t.labels.schematic&&(t.labels.schematic=[]);for(let e in i){let s=t.atoms[e];if(!t.residues.hasOwnProperty(s.structure+"_"+s.chain+"_"+s.resi))continue;if("C"===s.elem)continue;let i={};i.position=s.coord,i.bSchematic=1,i.text=s.elem,i.size=18,i.color="black"!=t.opts.background?t.colorWhitebkgd:s.color.getHexString(),i.background="#FFFFFF",t.labels.schematic.push(i)}t.hlObjectsCls.removeHlObjects()}addAtomLabels(e,t){let s=this.icn3d,i=s.icn3dui;if(i.bNode)return;let n=i.hashUtilsCls.intHash(s.hAtoms,e);n=i.hashUtilsCls.intHash(s.dAtoms,n),void 0===s.labels.residue&&(s.labels.residue=[]);for(let e in n){let i=s.atoms[e],n={};n.position=i.coord,n.bSchematic=0,n.text=t?i.elem:i.name.padEnd(2," "),n.size=18,t&&(n.bSchematic=!0);let l=i.color.getHexString().toUpperCase();n.color="black"!=s.opts.background?s.colorWhitebkgd:s.colorBlackbkgd,t&&(n.color="CCCCCC"===l||"C8C8C8"===l?"#888888":"#"+l),n.background="#FFFFFF",s.labels.residue.push(n)}s.hlObjectsCls.removeHlObjects()}}class dt{constructor(e){this.icn3d=e}onBeforeRender(e,t,s,i,n,l){let r=n.uniforms,o=[];if(r.objectId&&(r.objectId.value=SupportsReadPixelsFloat?this.id:this.id/255,o.push("objectId")),(r.modelViewMatrixInverse||r.modelViewMatrixInverseTranspose||r.modelViewProjectionMatrix||r.modelViewProjectionMatrixInverse)&&this.modelViewMatrix.multiplyMatrices(s.matrixWorldInverse,this.matrixWorld),r.modelViewMatrixInverse&&(r.modelViewMatrixInverse.value.copy(this.modelViewMatrix).invert(),o.push("modelViewMatrixInverse")),r.modelViewMatrixInverseTranspose&&(r.modelViewMatrixInverse?r.modelViewMatrixInverseTranspose.value.copy(r.modelViewMatrixInverse.value).transpose():r.modelViewMatrixInverseTranspose.value.copy(this.modelViewMatrix).invert().transpose(),o.push("modelViewMatrixInverseTranspose")),r.modelViewProjectionMatrix&&(s.updateProjectionMatrix(),r.modelViewProjectionMatrix.value.multiplyMatrices(s.projectionMatrix,this.modelViewMatrix),o.push("modelViewProjectionMatrix")),r.modelViewProjectionMatrixInverse){let e=new THREE.Matrix4;r.modelViewProjectionMatrix?(e.copy(r.modelViewProjectionMatrix.value),r.modelViewProjectionMatrixInverse.value.copy(e).invert()):(s.updateProjectionMatrix(),e.multiplyMatrices(s.projectionMatrix,this.modelViewMatrix),r.modelViewProjectionMatrixInverse.value.copy(e).invert()),o.push("modelViewProjectionMatrixInverse")}if(r.projectionMatrix&&(s.updateProjectionMatrix(),r.projectionMatrix.value.copy(s.projectionMatrix),o.push("projectionMatrix")),r.projectionMatrixInverse&&(s.updateProjectionMatrix(),r.projectionMatrixInverse.value.copy(s.projectionMatrix).invert(),o.push("projectionMatrixInverse")),o.length){let t=e.properties.get(n);if(t.program){let s=e.getContext(),i=t.program;s.useProgram(i.program);let n=i.getUniforms();o.forEach((function(e){n.setValue(s,e,r[e].value)}))}}}setParametersForShader(e){let t,s=this.icn3d,i=s.icn3dui.parasCls.backgroundColors[s.opts.background.toLowerCase()],n=2.5*s.maxD,l=4*s.maxD,r=void 0!==s.biomtMatrices&&s.biomtMatrices.length*s.cnt>s.maxatomcnt;"yes"===s.opts.slab?r?t=.1:void 0!==s.camMaxDFactorFog?(t=s.maxD*s.camMaxDFactorFog-10,n=2.5*s.maxD-t<0?0:2.5*s.maxD-t,l=4*s.maxD-t):t=s.maxD*s.camMaxDFactor:t=.1;let o=void 0!==e?e:1,a=s.shininess/100*.5;s.uniforms=THREE.UniformsUtils.merge([THREE.UniformsLib.common,{modelViewMatrix:{value:new THREE.Matrix4},modelViewMatrixInverse:{value:new THREE.Matrix4},modelViewMatrixInverseTranspose:{value:new THREE.Matrix4},modelViewProjectionMatrix:{value:new THREE.Matrix4},modelViewProjectionMatrixInverse:{value:new THREE.Matrix4},projectionMatrix:{value:new THREE.Matrix4},projectionMatrixInverse:{value:new THREE.Matrix4},diffuse:{type:"v3",value:[1,1,1]},emissive:{type:"v3",value:[.06,.06,.06]},roughness:{type:"f",value:.5},metalness:{type:"f",value:a},opacity:{type:"f",value:o},nearClip:{type:"f",value:t},ortho:{type:"f",value:0},shrink:{type:"f",value:.13},fogColor:{type:"v3",value:[i.r,i.g,i.b]},fogNear:{type:"f",value:n},fogFar:{type:"f",value:l},fogDensity:{type:"f",value:2}},THREE.UniformsLib.ambient,THREE.UniformsLib.lights]),s.defines={USE_COLOR:1,NEAR_CLIP:1,CAP:1},"yes"!==s.opts.fog||r||(s.defines.USE_FOG=1,"orthographic"===s.opts.camera&&(s.defines.FOG_EXP2=1)),s.bExtFragDepth&&(s.defines.USE_LOGDEPTHBUF_EXT=1)}drawImpostorShader(){this.icn3d.icn3dui.bNode||(this.setParametersForShader(),this.createImpostorShaderSphere("SphereImpostor"),this.createImpostorShaderCylinder("CylinderImpostor"))}getShader(e){this.icn3d.icn3dui;let t=$NGL_shaderTextHash[e];return t=t.replace(/#include\s+(\S+)/gim,(function(e,t){let s;return THREE.ShaderChunk.hasOwnProperty(t)&&(s=THREE.ShaderChunk[t]),s||""})),t}createImpostorShaderBase(e,t,s,i,n,l,r,o,a){let d=this.icn3d;d.icn3dui;let c=new THREE.ShaderMaterial({defines:d.defines,uniforms:d.uniforms,vertexShader:this.getShader(e+".vert"),fragmentShader:this.getShader(e+".frag"),depthTest:!0,depthWrite:!0,lights:!0});c.extensions.fragDepth=!0,"CylinderImpostor"==e?d.CylinderImpostorMaterial=c:"SphereImpostor"==e&&(d.SphereImpostorMaterial=c);let h,p,m=l*r,u=l*o,g=new(m>65535?Uint32Array:Uint16Array)(u);for(let e=0;e<l;e++){h=e*o,p=e*r,g.set(s,h);for(let e=0;e<o;++e)g[h+e]+=p}let f=new THREE.BufferGeometry;g&&(f.setIndex(new THREE.BufferAttribute(g,1)),f.getIndex().setUsage(THREE.DynamicDrawUsage));let C={f:1,v2:2,v3:3,c:3};for(let e in n){let t,s=n[e];t=new Float32Array(m*C[s.type]),f.setAttribute(e,new THREE.BufferAttribute(t,C[s.type]).setUsage(THREE.DynamicDrawUsage))}let b,y,v,_,w,S,A=f.attributes;for(let e in i){y=i[e],b=A[e],v=b.itemSize,_=b.array;for(let e=0;e<l;++e){u=e*v,w=u*r;for(let e=0;e<r;++e){S=w+v*e;for(let e=0;e<v;++e)_[S+e]=y[u+e]}}b.needsUpdate=!0}let x=f.attributes.mapping.array;for(let e=0;e<l;e++)x.set(t,e*a*r);let k=new THREE.Mesh(f,c);k.frustumCulled=!1,k.scale.x=k.scale.y=k.scale.z=1,"CylinderImpostor"==e?k.type="Cylinder":"SphereImpostor"==e&&(k.type="Sphere"),k.onBeforeRender=this.onBeforeRender,d.mdlImpostor.add(k)}createImpostorShaderCylinder(e){let t=this.icn3d;t.icn3dui;let s=new Float32Array(t.posArray),i=new Float32Array(t.colorArray),n=new Float32Array(t.pos2Array),l=new Float32Array(t.color2Array),r=new Float32Array(t.radiusArray),o=new Float32Array([-1,1,-1,-1,-1,-1,1,1,-1,1,1,1,1,-1,-1,1,-1,1]),a=new Uint16Array([0,1,2,1,4,2,2,4,3,4,5,3]),d=s.length/3,c={position1:s,color:i,position2:n,color2:l,radius:r},h={position1:{type:"v3",value:null},color:{type:"v3",value:null},position2:{type:"v3",value:null},color2:{type:"v3",value:null},radius:{type:"f",value:null},mapping:{type:"v3",value:null}};this.createImpostorShaderBase(e,o,a,c,h,d,6,12,3),c=null,s=null,i=null,n=null,l=null,r=null,t.posArray=[],t.colorArray=[],t.pos2Array=[],t.color2Array=[],t.radiusArray=[]}createImpostorShaderSphere(e){let t=this.icn3d;t.icn3dui;let s=new Float32Array(t.posArraySphere),i=new Float32Array(t.colorArraySphere),n=new Float32Array(t.radiusArraySphere),l=new Float32Array([-1,1,-1,-1,1,1,1,-1]),r=new Uint16Array([0,1,2,1,3,2]),o=s.length/3,a={position:s,color:i,radius:n},d={position:{type:"v3",value:null},color:{type:"v3",value:null},radius:{type:"f",value:null},mapping:{type:"v2",value:null}};this.createImpostorShaderBase(e,l,r,a,d,o,4,6,2),a=null,s=null,i=null,n=null,t.posArraySphere=[],t.colorArraySphere=[],t.radiusArraySphere=[]}clearImpostors(){let e=this.icn3d;e.icn3dui,e.posArray=[],e.colorArray=[],e.pos2Array=[],e.color2Array=[],e.radiusArray=[],e.posArraySphere=[],e.colorArraySphere=[],e.radiusArraySphere=[]}}class ct{constructor(e){this.icn3d=e}positionFromGeometry(e){this.icn3d.icn3dui;let t,s,i=e.geometry,n=i.vertices,l=e.position,r=e.scale,o=e.matrix,a=n.length,d=[];for(let e=0;e<a;e++)t=3*e,s="SphereGeometry"==i.type||"BoxGeometry"==i.type?n[e].clone().multiply(r).add(l):"CylinderGeometry"==i.type?n[e].clone().applyMatrix4(o):n[e],d[t+0]=s.x,d[t+1]=s.y,d[t+2]=s.z;return d}colorFromGeometry(e){let t=this.icn3d.icn3dui,s=e.geometry,i=t.parasCls.thr(1,1,1);"SphereGeometry"!=s.type&&"BoxGeometry"!=s.type&&"CylinderGeometry"!=s.type||void 0!==e.material&&(i=e.material.color);let n,l,r,o,a,d=s.faces;s.vertices.length,s.type;let c=d.length,h=[];for(let e=0;e<c;e++)l=d[e],"Surface"==s.type?(r=l.vertexColors[0],o=l.vertexColors[1],a=l.vertexColors[2]):"SphereGeometry"==s.type||"BoxGeometry"==s.type||"CylinderGeometry"==s.type?(r=i,o=i,a=i):(r=l.color,o=l.color,a=l.color),n=3*l.a,h[n+0]=r.r,h[n+1]=r.g,h[n+2]=r.b,n=3*l.b,h[n+0]=o.r,h[n+1]=o.g,h[n+2]=o.b,n=3*l.c,h[n+0]=a.r,h[n+1]=a.g,h[n+2]=a.b;return h}indexFromGeometry(e){this.icn3d.icn3dui;let t,s,i=e.geometry.faces,n=i.length,l=[];for(let e=0;e<n;e++)t=3*e,s=i[e],l[t+0]=s.a,l[t+1]=s.b,l[t+2]=s.c;return l}normalFromGeometry(e){this.icn3d.icn3dui;let t,s,i,n,l,r,o=e.geometry,a=o.faces;o.vertices.length;let d=a.length,c=[];for(let e=0;e<d;e++)s=a[e],i=s.vertexNormals,n=i[0],l=i[1],r=i[2],t=3*s.a,c[t+0]=n.x,c[t+1]=n.y,c[t+2]=n.z,t=3*s.b,c[t+0]=l.x,c[t+1]=l.y,c[t+2]=l.z,t=3*s.c,c[t+0]=r.x,c[t+1]=r.y,c[t+2]=r.z;return c}drawSymmetryMates(){let e=this.icn3d;e.icn3dui.bNode||(e.bInstanced?this.drawSymmetryMatesInstancing():this.drawSymmetryMatesNoInstancing())}applyMat(e,t,s){let i=this.icn3d;if(i.icn3dui,void 0===i.rmsd_supr)e.applyMatrix4(t);else{let s=i.rmsd_supr.rot,n=i.rmsd_supr.trans1,l=i.rmsd_supr.trans2,r=new THREE.Matrix4;r.set(s[0],s[1],s[2],0,s[3],s[4],s[5],0,s[6],s[7],s[8],0,0,0,0,1);let o=new THREE.Matrix4;o.copy(r).invert();let a=new THREE.Matrix4;a.makeTranslation(-l.x,-l.y,-l.z),e.applyMatrix4(a),e.applyMatrix4(o),a.makeTranslation(n.x,n.y,n.z),e.applyMatrix4(a),e.applyMatrix4(t),a.makeTranslation(-n.x,-n.y,-n.z),e.applyMatrix4(a),e.applyMatrix4(r),a.makeTranslation(l.x,l.y,l.z),e.applyMatrix4(a)}}drawSymmetryMatesNoInstancing(){let e=this.icn3d;if(e.icn3dui,void 0===e.biomtMatrices||0==e.biomtMatrices.length)return;let t=1,s=e.center.clone(),i=new THREE.Matrix4;i.identity();let n=new THREE.Object3D,l=new THREE.Object3D,r=new THREE.Object3D;for(let o=0;o<e.biomtMatrices.length&&1==Object.keys(e.structures).length;o++){let a,d=e.biomtMatrices[o];if(void 0===d)continue;if(d.equals(i))continue;if(void 0!==e.mdl&&(a=e.mdl.clone(),this.applyMat(a,d),n.add(a)),void 0!==e.mdlImpostor){a=e.mdlImpostor.clone(),this.applyMat(a,d);for(let t=a.children.length-1;t>=0;t--){let s=a.children[t];s.onBeforeRender=e.impostorCls.onBeforeRender,s.frustumCulled=!1}l.add(a)}void 0!==e.mdl_ghost&&(a=e.mdl_ghost.clone(),this.applyMat(a,d),r.add(a));let c=e.center.clone();this.applyMat(c,d,!0),s.add(c),++t}e.mdl.add(n),e.mdlImpostor.add(l),e.mdl_ghost.add(r),void 0!==e.bSetInstancing&&e.bSetInstancing?(e.maxD=e.maxDAssembly,e.center=e.centerAssembly.clone(),e.applyCenterCls.setCenter(e.center),e.cameraCls.setCamera()):(e.maxD*=Math.sqrt(t),e.center=e.ParserUtilsCls.getMassCenter(s,t),e.maxDAssembly=e.maxD,e.centerAssembly=e.center.clone(),e.applyCenterCls.setCenter(e.center),e.cameraCls.setCamera()),e.bSetInstancing=!0}createInstancedGeometry(e){let t=this.icn3d,s=t.icn3dui,i=e.geometry,n=new THREE.InstancedBufferGeometry,l=[],r=[],o=[],a=[],d=[],c=[],h=[],p=[];if(t.bImpo&&"Cylinder"==e.type){t.instancedMaterial=this.getInstancedMaterial("CylinderInstancing");let e=s.hashUtilsCls.hashvalue2array(i.attributes.position1.array),r=s.hashUtilsCls.hashvalue2array(i.attributes.color.array),m=s.hashUtilsCls.hashvalue2array(i.attributes.position2.array),u=s.hashUtilsCls.hashvalue2array(i.attributes.color2.array),g=s.hashUtilsCls.hashvalue2array(i.index.array),f=s.hashUtilsCls.hashvalue2array(i.attributes.radius.array),C=s.hashUtilsCls.hashvalue2array(i.attributes.mapping.array);l=l.concat(e),o=o.concat(r),h=h.concat(m),p=p.concat(u),a=a.concat(g),d=d.concat(f),c=c.concat(C),n.setAttribute("position1",new THREE.BufferAttribute(new Float32Array(l),3)),n.setAttribute("color",new THREE.BufferAttribute(new Float32Array(o),3)),n.setAttribute("position2",new THREE.BufferAttribute(new Float32Array(h),3)),n.setAttribute("color2",new THREE.BufferAttribute(new Float32Array(p),3)),n.setAttribute("radius",new THREE.BufferAttribute(new Float32Array(d),1)),n.setAttribute("mapping",new THREE.BufferAttribute(new Float32Array(c),3)),n.setIndex(new THREE.BufferAttribute(new Uint32Array(a),1)),e=null,r=null,m=null,u=null,g=null,f=null,C=null}else if(t.bImpo&&"Sphere"==e.type){t.instancedMaterial=this.getInstancedMaterial("SphereInstancing");let e=s.hashUtilsCls.hashvalue2array(i.attributes.position.array),r=s.hashUtilsCls.hashvalue2array(i.attributes.color.array),h=s.hashUtilsCls.hashvalue2array(i.index.array),p=s.hashUtilsCls.hashvalue2array(i.attributes.radius.array),m=s.hashUtilsCls.hashvalue2array(i.attributes.mapping.array);l=l.concat(e),o=o.concat(r),a=a.concat(h),d=d.concat(p),c=c.concat(m),n.setAttribute("position",new THREE.BufferAttribute(new Float32Array(l),3)),n.setAttribute("color",new THREE.BufferAttribute(new Float32Array(o),3)),n.setAttribute("radius",new THREE.BufferAttribute(new Float32Array(d),1)),n.setAttribute("mapping",new THREE.BufferAttribute(new Float32Array(c),2)),n.setIndex(new THREE.BufferAttribute(new Uint32Array(a),1)),e=null,r=null,h=null,p=null,m=null}else{t.instancedMaterial=this.getInstancedMaterial("Instancing");let e=i.attributes.position?s.hashUtilsCls.hashvalue2array(i.attributes.position.array):[],d=i.attributes.normal?s.hashUtilsCls.hashvalue2array(i.attributes.normal.array):[],c=i.attributes.color?s.hashUtilsCls.hashvalue2array(i.attributes.color.array):[],h=i.index?s.hashUtilsCls.hashvalue2array(i.index.array):[];l=l.concat(e),r=r.concat(d),o=o.concat(c),a=a.concat(h);let p=[],m="CylinderGeometry"==i.type?1:0;for(let e=0,t=l.length/3;e<t;++e)p.push(m);n.setAttribute("position",new THREE.BufferAttribute(new Float32Array(l),3)),n.setAttribute("normal",new THREE.BufferAttribute(new Float32Array(r),3)),n.setAttribute("color",new THREE.BufferAttribute(new Float32Array(o),3)),n.setAttribute("cylinder",new THREE.BufferAttribute(new Float32Array(p),1)),n.setIndex(new THREE.BufferAttribute(new Uint32Array(a),1)),e=null,d=null,c=null,h=null}l=null,r=null,o=null,a=null,d=null,c=null,h=null,p=null;let m=new THREE.InstancedBufferAttribute(new Float32Array(t.matricesElements1),4),u=new THREE.InstancedBufferAttribute(new Float32Array(t.matricesElements2),4),g=new THREE.InstancedBufferAttribute(new Float32Array(t.matricesElements3),4),f=new THREE.InstancedBufferAttribute(new Float32Array(t.matricesElements4),4);return n.setAttribute("matrix1",m),n.setAttribute("matrix2",u),n.setAttribute("matrix3",g),n.setAttribute("matrix4",f),n}getInstancedMaterial(e){let t=this.icn3d;t.icn3dui;let s=new THREE.ShaderMaterial({defines:t.defines,uniforms:t.uniforms,vertexShader:t.impostorCls.getShader(e+".vert"),fragmentShader:t.impostorCls.getShader(e+".frag"),depthTest:!0,depthWrite:!0,lights:!0});return s.extensions.fragDepth=!0,s.extensions.derivatives="#extension GL_OES_standard_derivatives : enable",s}createInstancedMesh(e){let t=this.icn3d;t.icn3dui;for(let s=0,i=e.children.length;s<i;++s){let i=e.children[s];if("Sprite"===i.type)continue;let n=this.createInstancedGeometry(i),l=new THREE.Mesh(n,t.instancedMaterial);l.onBeforeRender=t.impostorCls.onBeforeRender,l.frustumCulled=!1,l.scale.x=l.scale.y=l.scale.z=1,l.type=i.type,n=null,e.add(l)}}drawSymmetryMatesInstancing(){let e=this.icn3d;if(e.icn3dui,void 0===e.biomtMatrices||0==e.biomtMatrices.length)return;let t=1,s=e.center.clone();if(e.impostorCls.setParametersForShader(),void 0===e.bSetInstancing||!e.bSetInstancing){e.matricesElements1=[],e.matricesElements2=[],e.matricesElements3=[],e.matricesElements4=[];let i=new THREE.Matrix4;i.identity();for(let n=0;n<e.biomtMatrices.length&&1==Object.keys(e.structures).length;n++){let l=e.biomtMatrices[n];if(void 0===l)continue;let r=l.toArray();if(l.equals(i))continue;e.matricesElements1.push(r[0],r[1],r[2],r[3]),e.matricesElements2.push(r[4],r[5],r[6],r[7]),e.matricesElements3.push(r[8],r[9],r[10],r[11]),e.matricesElements4.push(r[12],r[13],r[14],r[15]);let o=e.center.clone();o.applyMatrix4(l),s.add(o),++t}}this.createInstancedMesh(e.mdl),this.createInstancedMesh(e.mdlImpostor),void 0!==e.bSetInstancing&&e.bSetInstancing?(e.maxD=e.maxDAssembly,e.center=e.centerAssembly.clone(),e.applyCenterCls.setCenter(e.center),e.cameraCls.setCamera()):(e.maxD*=Math.sqrt(t),e.center=e.ParserUtilsCls.getMassCenter(s,t),e.maxDAssembly=e.maxD,e.centerAssembly=e.center.clone(),e.applyCenterCls.setCenter(e.center),e.cameraCls.setCamera()),e.bSetInstancing=!0}}class ht{constructor(e){this.icn3d=e}async alternateStructures(){let e=this.icn3d,t=e.icn3dui;e.bAlternate=!0,-1==e.ALTERNATE_STRUCTURE&&(e.viewSelectionAtoms=t.hashUtilsCls.cloneHash(e.dAtoms));let s=Object.keys(e.viewSelectionAtoms).length,i=Object.keys(e.atoms).length,n={};for(let t in e.viewSelectionAtoms){n[e.atoms[t].structure]=1}let l=Object.keys(n);e.dAtoms={};let r=e.bScap;for(let s=0,i=l.length;s<i;++s){let n,o=l[s];if(e.bShift?(e.ALTERNATE_STRUCTURE<0&&(e.ALTERNATE_STRUCTURE=1),n=s==e.ALTERNATE_STRUCTURE%i-1||e.ALTERNATE_STRUCTURE%i==0&&s===i-1):n=s==e.ALTERNATE_STRUCTURE%i+1||e.ALTERNATE_STRUCTURE%i==i-1&&0===s,n){for(let s in e.structures[o]){let i=e.structures[o][s];e.dAtoms=t.hashUtilsCls.unionHash(e.dAtoms,e.chains[i])}e.bShift?--e.ALTERNATE_STRUCTURE:++e.ALTERNATE_STRUCTURE,e.ALTERNATE_STRUCTURE<0&&(e.ALTERNATE_STRUCTURE+=i);let n="";r&&(0==s?n="Wild Type ":1==s&&(n="Mutant ")),$("#"+e.pre+"title").html(n+o);break}}if(s<i){let s=t.hashUtilsCls.intHash(e.dAtoms,e.viewSelectionAtoms);Object.keys(s).length>0&&(e.dAtoms=t.hashUtilsCls.cloneHash(s)),e.bShowHighlight=!1}e.applyMapCls.removeSurfaces(),e.applyMapCls.applySurfaceOptions(),e.applyMapCls.removeMaps(),e.applyMapCls.applyMapOptions(),e.applyMapCls.removeEmmaps(),e.applyMapCls.applyEmmapOptions(),e.applyMapCls.removePhimaps(),e.applyMapCls.applyPhimapOptions(),e.applyMapCls.removeSurfaces(),e.applyMapCls.applyphisurfaceOptions(),e.axes=[],e.pc1&&e.axesCls.setPc1Axes(),e.opts.rotationcenter="highlight center",e.drawCls.draw(),e.bShowHighlight=!0}async alternateWrapper(){let e=this.icn3d;e.icn3dui,e.bAlternate=!0,await this.alternateStructures(),e.bAlternate=!1}}class pt{constructor(e){this.icn3d=e}draw(e){let t=this.icn3d,s=t.icn3dui;if(t.impostorCls.clearImpostors(),!t.bRender||t.hAtoms&&0!=Object.keys(t.hAtoms)||(t.hAtoms=s.hashUtilsCls.cloneHash(t.atoms)),t.sceneCls.rebuildScene(),t.bImpo&&t.impostorCls.drawImpostorShader(),t.setColorCls.applyPrevColor(),void 0!==t.biomtMatrices&&t.biomtMatrices.length>1)if(t.bAssembly&&1==Object.keys(t.structures).length&&(void 0===s.cfg.mmdbid&&1==s.cfg.bu||void 0!==s.cfg.mmdbid&&1==s.cfg.bu&&Object.keys(t.atoms).length*t.biomtMatrices.length>t.maxatomcnt))t.instancingCls.drawSymmetryMates();else{let e=!0;t.applyCenterCls.centerSelection(void 0,e)}let i=void 0!==t.hAtoms?Object.keys(t.hAtoms).length:0;if(i>0&&i<Object.keys(t.dAtoms).length&&(t.hlObjectsCls.removeHlObjects(),(void 0===t.bShowHighlight||t.bShowHighlight)&&t.hlObjectsCls.addHlObjects()),!0===t.bRender&&((t.bInitial||$("#"+t.pre+"wait").is(":visible"))&&($("#"+t.pre+"wait")&&$("#"+t.pre+"wait").hide(),$("#"+t.pre+"canvas")&&$("#"+t.pre+"canvas").show(),$("#"+t.pre+"cmdlog")&&$("#"+t.pre+"cmdlog").show()),this.applyTransformation(t._zoomFactor,t.mouseChange,t.quaternion),this.render(e)),t.bOpm&&!s.cfg.chainalign){let e=s.utilsCls.getMemDesc();$("#"+t.pre+"dl_rmsd_html").html(e),s.cfg.bSidebyside||s.htmlCls.dialogCls.openDlg("dl_rmsd","Membranes")}}applyTransformation(e,t,s){let i=this.icn3d,n=i.icn3dui;if(n.bNode)return;let l={update:!1};l._zoomFactor=e,l.mouseChange=new THREE.Vector2,l.mouseChange.copy(t),l.quaternion=new THREE.Quaternion,l.quaternion.copy(s),i.bControlGl&&!n.bNode?window.controls.update(l):i.controls.update(l)}render(e){let t=this.icn3d;t.icn3dui;let s=this;e?t.renderer.setAnimationLoop((function(){s.render_base()})):s.render_base()}handleController(e,t,s,i,n,l){let r=this.icn3d;r.icn3dui;try{let n=0;if(l&&(0!=l[0]&&0!=l[1]||0!=l[0]?n=l[0]:0!=l[1]&&(n=l[1])),void 0===n&&(n=0),s&&!i){let s=n/1e3*t;const i=5;if(0!=n){r.uistr+="dolly";const e=r.dolly.quaternion.clone();r.dummyCam.getWorldQuaternion(r.dolly.quaternion),r.dolly.translateZ(s*i),r.dolly.quaternion.copy(e)}else{e.children[0].scale.z=10,r.workingMatrix.identity().extractRotation(e.matrixWorld),r.raycasterVR.ray.origin.setFromMatrixPosition(e.matrixWorld),r.raycasterVR.ray.direction.set(0,0,-1).applyMatrix4(r.workingMatrix);const t=r.raycasterVR.intersectObjects(r.objects);if(t.length>0){e.children[0].scale.z=t[0].distance,t[0].point.sub(r.mdl.position);let s=r.rayThreshold,i=r.rayCls.getAtomsFromPosition(t[0].point,s);for(;!i&&s<10;)s+=.5,i=r.rayCls.getAtomsFromPosition(t[0].point,s);i&&(r.pAtomNum%2==0?r.pAtom=i:r.pAtom2=i,++r.pAtomNum,this.showPickingVr(r.pk,i))}}}}catch(e){}}showPickingVr(e,t){let s=this.icn3d;s.icn3dui,e||(e=2),s.hAtoms=s.pickingCls.getPickedAtomList(e,t),2===e?s.residueLabelsCls.addResidueLabels(s.hAtoms,void 0,void 0,!0):1===e&&s.residueLabelsCls.addAtomLabels(s.hAtoms),s.setOptionCls.setStyle("proteins",t.style)}render_base(){let e=this.icn3d,t=e.icn3dui,s=this;if(t.bNode)return;let i=e.bControlGl&&!t.bNode?window.cam:e.cam;if(e.directionalLight){let t=new THREE.Quaternion;t.setFromUnitVectors(new THREE.Vector3(0,0,e.cam_z).normalize(),i.position.clone().normalize()),e.directionalLight.position.copy(e.lightPos.clone().applyQuaternion(t).normalize()),e.directionalLight2.position.copy(e.lightPos2.clone().applyQuaternion(t).normalize()),e.directionalLight3.position.copy(e.lightPos3.clone().applyQuaternion(t).normalize()),e.directionalLight.applyMatrix4(i.matrixWorld),e.directionalLight2.applyMatrix4(i.matrixWorld),e.directionalLight3.applyMatrix4(i.matrixWorld)}if(e.bVr||e.renderer.setPixelRatio(window.devicePixelRatio),e.bVr){let t=.04;if(e.controllers){let i=this.updateGamepadState();for(let n=0,l=e.controllers.length;n<l;++n){let l=e.controllers[n];l&&(t=n%2==0?t:-t,s.handleController(l,t,l.userData.selectPressed,l.userData.squeezePressed,i.xArray,i.yArray))}}e.renderer.xr.isPresenting&&(e.canvasUI&&e.canvasUI.update(),e.canvasUILog&&e.canvasUILog.update())}else e.bAr&&e.renderer.xr.isPresenting&&(e.gestures.update(),e.canvasUILog&&e.canvasUILog.update());e.scene&&(e.renderer.outputEncoding=THREE.sRGBEncoding,e.renderer.render(e.scene,i))}updateGamepadState(){let e=this.icn3d;e.icn3dui;let t=e.xAxisIndex?e.xAxisIndex:2,s=e.yAxisIndex?e.yAxisIndex:3;if(e.renderer.xr.isPresenting){const i=e.renderer.xr.getSession().inputSources;let n=[],l=[];return i.forEach((e=>{const i=e.gamepad.axes;let r=parseInt(1e3*i[t]),o=parseInt(-1e3*i[s]);n.push(r),l.push(o)})),{xArray:n,yArray:l}}return{xArray:[0,0],yArray:[0,0]}}}class mt{constructor(e){this.icn3d=e}getAtomsWithinAtom(e,t,s,i,n,l,r){let o=this.icn3d,a=o.icn3dui,d=this.getNeighboringAtoms(e,t,s,r);i&&(o.resid2Residhash={});let c={};for(let e in t){let h=o.atoms[e];if(n&&"H"==h.elem)continue;let p,m,u=a.parasCls.vdwRadii[h.elem.toUpperCase()],g=h.structure+"_"+h.chain,f=h.structure+"_"+h.chain+"_"+h.resi;for(let e in o.residues[f])if(o.atoms[e]&&("CA"===o.atoms[e].name&&"C"===o.atoms[e].elem||"O3'"===o.atoms[e].name||"O3*"===o.atoms[e].name)){p=o.atoms[e];break}if(void 0===p&&(p=h),i){let e=0==h.name.indexOf("pi")&&h.ring?h.ring.join(","):h.serial;m=h.resn+" $"+h.structure+"."+h.chain+":"+h.resi+" "+e,void 0===o.resid2Residhash[m]&&(o.resid2Residhash[m]={})}let C=h.structure+"_"+h.chain+"_"+h.resi;for(let e in d){let f=d[e];if(n&&"H"==f.elem)continue;let b=a.parasCls.vdwRadii[f.elem.toUpperCase()],y=f.structure+"_"+f.chain;if(n&&!o.crossstrucinter&&h.structure!=f.structure)continue;if(!r&&f.serial in t)continue;if(o.bOpm&&"DUM"===f.resn)continue;let v=f.coord.distanceTo(h.coord);if(n&&v<u+b&&("N"===h.name||"C"===h.name||"O"===h.name||"CA"===h.name&&"C"===h.elem)&&("N"===f.name||"C"===f.name||"O"===f.name||"CA"===f.name&&"C"===f.elem)&&(o.chainid2clashedResidpair||(o.chainid2clashedResidpair={}),o.chainid2clashedResidpair[g+"_"+h.resi+"|"+y+"_"+f.resi]="0|0"),v<s){let e,t;c[f.serial]=f,n&&(c[h.serial]=h);let s=f.structure+"_"+f.chain+"_"+f.resi;for(let t in o.residues[s])if("CA"===o.atoms[t].name&&"C"===o.atoms[t].elem||"O3'"===o.atoms[t].name||"O3*"===o.atoms[t].name){e=o.atoms[t];break}if(void 0===e&&(e=f),n&&(o.contactpnts.push({serial:e.serial,coord:e.coord}),o.contactpnts.push({serial:p.serial,coord:p.coord})),i){let s=f.structure+"_"+f.chain+"_"+f.resi,i=0==f.name.indexOf("pi")&&f.ring?f.ring.join(","):f.serial;t=f.resn+" $"+f.structure+"."+f.chain+":"+f.resi+" "+i;let n=v.toFixed(1),r=e.coord.distanceTo(p.coord).toFixed(1),a=C+"_"+h.resn+","+s+"_"+f.resn,d=m+"|"+t;if((void 0===o.resids2interAll[a]||void 0===o.resids2interAll[a].contact||!o.resids2interAll[a].contact.hasOwnProperty(d)||void 0!==o.resids2interAll[a].hbond&&!o.resids2interAll[a].hbond.hasOwnProperty(d)||void 0!==o.resids2interAll[a].ionic&&!o.resids2interAll[a].ionic.hasOwnProperty(d)||void 0!==o.resids2interAll[a].halogen&&!o.resids2interAll[a].halogen.hasOwnProperty(d)||void 0!==o.resids2interAll[a]["pi-cation"]&&!o.resids2interAll[a]["pi-cation"].hasOwnProperty(d)||void 0!==o.resids2interAll[a]["pi-stacking"]&&!o.resids2interAll[a]["pi-stacking"].hasOwnProperty(d))&&(void 0===o.resid2Residhash[m][t]||n<o.resid2Residhash[m][t].split("_")[0])){let e=void 0===o.resid2Residhash[m][t]?1:parseInt(o.resid2Residhash[m][t].split("_")[4])+1;o.resid2Residhash[m][t]=n+"_"+r+"_"+h.name+"_"+f.name+"_"+e,l||(void 0===o.resids2inter[a]&&(o.resids2inter[a]={}),void 0===o.resids2inter[a].contact&&(o.resids2inter[a].contact={}),o.resids2inter[a].contact[m+"|"+t]=n+"_"+r+"_"+h.name+"_"+f.name+"_"+e),void 0===o.resids2interAll[a]&&(o.resids2interAll[a]={}),void 0===o.resids2interAll[a].contact&&(o.resids2interAll[a].contact={}),o.resids2interAll[a].contact[m+"|"+t]=n+"_"+r+"_"+h.name+"_"+f.name+"_"+e}}}}}return c}getNeighboringAtoms(e,t,s,i){let n=this.icn3d;n.icn3dui;let l=this.getExtent(t),r=(l[2][0]-l[0][0])*(l[2][0]-l[0][0])+(l[2][1]-l[0][1])*(l[2][1]-l[0][1])+(l[2][2]-l[0][2])*(l[2][2]-l[0][2]),o=(l[2][0]-l[1][0])*(l[2][0]-l[1][0])+(l[2][1]-l[1][1])*(l[2][1]-l[1][1])+(l[2][2]-l[1][2])*(l[2][2]-l[1][2]),a=r>o?r:o,d=Math.sqrt(a),c=(d+s)*(d+s),h={};for(let r in e){let e=n.atoms[r];!i&&t.hasOwnProperty(e.serial)||(this.bOpm&&"DUM"===e.resn||e.coord.x<l[0][0]-s||e.coord.x>l[1][0]+s||e.coord.y<l[0][1]-s||e.coord.y>l[1][1]+s||e.coord.z<l[0][2]-s||e.coord.z>l[1][2]+s||(e.coord.x-l[2][0])*(e.coord.x-l[2][0])+(e.coord.y-l[2][1])*(e.coord.y-l[2][1])+(e.coord.z-l[2][2])*(e.coord.z-l[2][2])<c&&(h[e.serial]=e))}return h}getExtent(e){let t,s,i,n,l,r,o,a,d,c,h,p=this.icn3d;for(h in p.icn3dui,t=s=i=9999,n=l=r=-9999,o=a=d=c=0,e){let e=p.atoms[h];c++,o+=e.coord.x,a+=e.coord.y,d+=e.coord.z,t=t<e.coord.x?t:e.coord.x,s=s<e.coord.y?s:e.coord.y,i=i<e.coord.z?i:e.coord.z,n=n>e.coord.x?n:e.coord.x,l=l>e.coord.y?l:e.coord.y,r=r>e.coord.z?r:e.coord.z}return[[t,s,i],[n,l,r],[o/c,a/c,d/c]]}hideContact(){let e=this.icn3d;e.icn3dui,e.opts.contact="no",void 0===e.lines&&(e.lines={}),e.lines.contact=[],e.contactpnts=[]}}class ut{constructor(e){this.icn3d=e}isHbondDonorAcceptor(e){let t=this.icn3d;if(t.icn3dui,"N"==e.name&&!e.het||"N"==e.elem&&"Arg"==e.resn||"N"==e.elem&&"Asn"==e.resn||"N"==e.elem&&"Gln"==e.resn||"N"==e.elem&&"Lys"==e.resn||"N"==e.elem&&"Trp"==e.resn)return"donor";if("O"==e.name&&!e.het||"S"==e.elem&&"Met"==e.resn||"O"==e.elem&&"Asn"==e.resn||"O"==e.elem&&"Asp"==e.resn||"O"==e.elem&&"Gln"==e.resn||"O"==e.elem&&"Glu"==e.resn)return"acceptor";if("S"==e.elem&&"Cys"==e.resn||"N"==e.elem&&"His"==e.resn||"O"==e.elem&&"Ser"==e.resn||"O"==e.elem&&"Thr"==e.resn||"O"==e.elem&&"Tyr"==e.resn)return"both";if("Pro"==e.resn)return"none";if("N"==e.elem){if("Asn"==e.resn||"Gln"==e.resn)return"both";let s=0,i=0;for(let i=0,n=e.bonds.length;i<n;++i)"H"==t.atoms[e.bonds[i]].elem&&++s;if(2==s)return"donor";s=0;for(let n=0,l=e.bonds.length;n<l;++n){let l=t.atoms[e.bonds[n]];if("H"!=l.elem){++s;for(let e=0,s=l.bonds.length;e<s;++e)"N"==t.atoms[l.bonds[e]].elem&&++i}}return 1==s?"donor":2==s?i>1?"ring":"donor":"none"}if("O"==e.elem&&1==e.bonds.length){if("Asn"==e.resn||"Gln"==e.resn)return"both";for(let s=0,i=e.bonds.length;s<i;++s)if("H"==t.atoms[e.bonds[s]].elem)return"donor";let s=t.atoms[e.bonds[0]],i=0;for(let e=0,n=s.bonds.length;e<n;++e)"O"!=t.atoms[s.bonds[e]].elem&&"N"!=t.atoms[s.bonds[e]].elem&&"S"!=t.atoms[s.bonds[e]].elem||++i;return i>=2?"acceptor":"both"}if("O"==e.elem&&2==e.bonds.length){for(let s=0,i=e.bonds.length;s<i;++s)if("H"==t.atoms[e.bonds[s]].elem)return"donor";return"acceptor"}return"both"}calcAngles(e,t){let s=this.icn3d;s.icn3dui;let i=[],n=new THREE.Vector3,l=new THREE.Vector3;n.subVectors(t.coord,e.coord);for(let t=0,r=e.bonds.length;t<r;++t)"H"!=s.atoms[e.bonds[t]].elem&&(l.subVectors(s.atoms[e.bonds[t]].coord,e.coord),i.push(n.angleTo(l)));return i}calcPlaneAngle(e,t){let s=this.icn3d;s.icn3dui;let i=e,n=new THREE.Vector3;n.subVectors(t.coord,e.coord);let l=[new THREE.Vector3,new THREE.Vector3],r=0;for(let t=0,n=e.bonds.length;t<n&&!(r>1);++t)"H"!=s.atoms[e.bonds[t]].elem&&(i=s.atoms[e.bonds[t]],l[r++].subVectors(s.atoms[e.bonds[t]].coord,e.coord));if(1===r)for(let t=0,n=i.bonds.length;t<n&&!(r>1);++t)"H"!=s.atoms[i.bonds[t]].elem&&s.atoms[i.bonds[t]].serial!=e.serial&&l[r++].subVectors(s.atoms[i.bonds[t]].coord,e.coord);if(2!==r)return;let o=l[0].cross(l[1]);return Math.abs(Math.PI/2-o.angleTo(n))}isValidHbond(e,t,s){let i=this.icn3d;i.icn3dui;let n,l,r=this.isHbondDonorAcceptor(e),o=this.isHbondDonorAcceptor(t),a=50*Math.PI/180,d=50*Math.PI/180,c=90*Math.PI/180,h=30*Math.PI/180;if("donor"==r&&("acceptor"==o||"both"==o||"ring"==o)||"acceptor"==o&&("donor"==r||"both"==r||"ring"==r))n=e,l=t;else if("acceptor"==r&&("donor"==o||"both"==o||"ring"==o)||"donor"==o&&("acceptor"==r||"both"==r||"ring"==r))l=e,n=t;else{if("both"!=r&&"ring"!=r||"both"!=o&&"ring"!=o)return!1;n=e,l=t,i.nucleotides.hasOwnProperty(e.serial)&&i.nucleotides.hasOwnProperty(t.serial)&&("ring"==r||"ring"==o)||(e.het||t.het)&&"ring"==r&&"ring"==o||(h=90*Math.PI/180)}let p=this.calcAngles(n,l),m=90*Math.PI/180;for(let e=0,t=p.length;e<t;++e)if(Math.abs(m-p[e])>d)return!1;let u=this.calcPlaneAngle(n,l);if(void 0!==u&&u>h)return!1;let g=this.calcAngles(l,n),f=90*Math.PI/180;for(let e=0,t=g.length;e<t;++e)if(Math.abs(f-g[e])>a)return!1;let C=this.calcPlaneAngle(l,n);return!(void 0!==C&&C>c)}calculateChemicalHbonds(e,t,s,i,n,l){let r=this.icn3d,o=r.icn3dui;if(0===Object.keys(e).length||0===Object.keys(t).length)return;r.resid2Residhash={};let a,d,c={},h=s*s;for(let t in e){let s=e[t],n=i?"LYS"===s.resn&&"N"===s.elem&&"N"!==s.name||"ARG"===s.resn&&("NH1"===s.name||"NH2"===s.name)||("GLU"===s.resn||"ASP"===s.resn)&&"O"===s.elem&&"O"!==s.name||s.het&&("N"===s.elem||"O"===s.elem||"S"===s.elem):"N"===s.elem||"O"===s.elem||"S"===s.elem&&(s.het||"Cys"===s.resn||"Met"===s.resn);n=r.bOpm?n&&"DUM"!==s.resn:n,n&&(a=s.structure+"_"+s.chain+"_"+s.resi,d=a+"_"+s.name,c[d]=s)}let p={},m={},u=.5,g=-27.888,f={};for(let e in t){let C=t[e],b=i?"LYS"===C.resn&&"N"===C.elem&&"N"!==C.name||"ARG"===C.resn&&("NH1"===C.name||"NH2"===C.name)||("GLU"===C.resn||"ASP"===C.resn)&&"O"===C.elem&&"O"!==C.name||C.het&&("N"===C.elem||"O"===C.elem||"S"===C.elem):"N"===C.elem||"O"===C.elem||"S"===C.elem&&(C.het||"Cys"===C.resn||"Met"===C.resn);if(b=r.bOpm?b&&"DUM"!==C.resn:b,b){a=C.structure+"_"+C.chain+"_"+C.resi,d=a+"_"+C.name;let e=0==C.name.indexOf("pi")&&C.ring?C.ring.join(","):C.serial,t=C.resn+" $"+C.structure+"."+C.chain+":"+C.resi+"@"+C.name+" "+e;void 0===r.resid2Residhash[t]&&(r.resid2Residhash[t]={});for(let e in c){if(i&&!(("LYS"!==C.resn&&"ARG"!==C.resn||"LYS"!==c[e].resn&&"ARG"!==c[e].resn)&&("GLU"!==C.resn&&"ASP"!==C.resn||"GLU"!==c[e].resn&&"ASP"!==c[e].resn)))continue;if(!r.crossstrucinter&&C.structure!=c[e].structure)continue;if(a==e.substr(0,e.lastIndexOf("_")))continue;let d=Math.abs(C.coord.x-c[e].coord.x);if(d>s)continue;let b=Math.abs(C.coord.y-c[e].coord.y);if(b>s)continue;let y=Math.abs(C.coord.z-c[e].coord.z);if(y>s)continue;let v=d*d+b*b+y*y;if(v>h)continue;if(!r.proteins.hasOwnProperty(C.serial)||!r.proteins.hasOwnProperty(c[e].serial)||"N"!==C.name&&"O"!==C.name||"O"!==c[e].name&&"N"!==c[e].name){if(!this.isValidHbond(C,c[e],s))continue}else{if(C.name===c[e].name)continue;if(C.structure==c[e].structure&&C.chain==c[e].chain&&Math.abs(C.resi-c[e].resi)<=1)continue;let t,i="N"===C.name?C:c[e],n="O"===C.name?C:c[e];if("Pro"===i.resn)continue;if(void 0===i.hcoord){if(!this.isValidHbond(C,c[e],s))continue}else{let s,l=i.hcoord,o=i.coord,a=n.structure+"_"+n.chain+"_"+n.resi;for(let e in r.residues[a])if("C"===r.atoms[e].name){s=r.atoms[e];break}if(!s)continue;let d=s.coord,h=n.coord,p=l.distanceTo(h),m=l.distanceTo(d),f=o.distanceTo(d),b=o.distanceTo(h);t=p<u||m<u||f<u||b<u?-9.9:g/p-g/m+g/f-g/b,"helix"==C.ss&&c[e].ss}}if(f[C.serial]>2||f[c[e].serial]>2)continue;void 0===f[C.serial]?f[C.serial]=1:++f[C.serial],void 0===f[c[e].serial]?f[c[e].serial]=1:++f[c[e].serial],"graph"!==n&&(i?(r.saltbridgepnts.push({serial:C.serial,coord:C.coord}),r.saltbridgepnts.push({serial:c[e].serial,coord:c[e].coord})):(r.hbondpnts.push({serial:C.serial,coord:C.coord}),r.hbondpnts.push({serial:c[e].serial,coord:c[e].coord})));let _=c[e].structure+"_"+c[e].chain+"_"+c[e].resi;p=o.hashUtilsCls.unionHash(p,r.residues[a]),p=o.hashUtilsCls.unionHash(p,r.residues[_]),m[a]=1,m[_]=1;let w=0==c[e].name.indexOf("pi")&&c[e].ring?c[e].ring.join(","):c[e].serial,S=c[e].resn+" $"+c[e].structure+"."+c[e].chain+":"+c[e].resi+"@"+c[e].name+" "+w,A=a+"_"+C.resn+","+_+"_"+c[e].resn;void 0!==r.resids2interAll[A]&&void 0!==r.resids2interAll[A].ionic&&r.resids2interAll[A].ionic.hasOwnProperty(t+"|"+S)||(r.resid2Residhash[t][S]=v.toFixed(1),l||(void 0===r.resids2inter[A]&&(r.resids2inter[A]={}),void 0===r.resids2inter[A].hbond&&(r.resids2inter[A].hbond={}),r.resids2inter[A].hbond[t+"|"+S]=v.toFixed(1)),void 0===r.resids2interAll[A]&&(r.resids2interAll[A]={}),void 0===r.resids2interAll[A].hbond&&(r.resids2interAll[A].hbond={}),r.resids2interAll[A].hbond[t+"|"+S]=v.toFixed(1))}}}let C=Object.keys(m);if("graph"!==n)for(let e=0,t=C.length;e<t;++e)for(let t in r.residues[C[e]])r.atoms[t].style2="stick";return p}setHbondsContacts(e,t){let s=this.icn3d;s.icn3dui;let i=t,n="hbond"==t?"hbonds":t;if(s.lines[i]=[],"yes"===e[n].toLowerCase()){let e,n;"hbond"==t?(n=s.hbondpnts,e="#0F0"):"saltbridge"==t?(n=s.saltbridgepnts,e="#0FF"):"contact"==t?(n=s.contactpnts,e="#888"):"halogen"==t?(n=s.halogenpnts,e="#F0F"):"pi-cation"==t?(n=s.picationpnts,e="#F00"):"pi-stacking"==t&&(n=s.pistackingpnts,e="#00F");for(let t=0,l=Math.floor(n.length/2);t<l;t++){let l={};l.position1=n[2*t].coord,l.serial1=n[2*t].serial,l.position2=n[2*t+1].coord,l.serial2=n[2*t+1].serial,l.color=e,l.dashed=!0,(void 0===l.serial1||void 0===l.serial2||s.dAtoms.hasOwnProperty(l.serial1)||s.dAtoms.hasOwnProperty(l.serial2))&&s.lines[i].push(l)}}}hideHbonds(){let e=this.icn3d;e.icn3dui,e.opts.hbonds="no",void 0===e.lines&&(e.lines={}),e.lines.hbond=[],e.hbondpnts=[]}}class gt{constructor(e){this.icn3d=e}calculateHalogenPiInteractions(e,t,s,i,n,l){let r=this.icn3d,o=r.icn3dui;if(0===Object.keys(e).length||0===Object.keys(t).length)return;let a={},d={},c={},h={};if("halogen"==n){for(let t in e){let s=e[t];a=o.hashUtilsCls.unionHash(a,this.getHalogenDonar(s)),c=o.hashUtilsCls.unionHash(c,this.getHalogenAcceptor(s))}for(let e in t){let s=t[e];h=o.hashUtilsCls.unionHash(h,this.getHalogenDonar(s)),d=o.hashUtilsCls.unionHash(d,this.getHalogenAcceptor(s))}}else if("pi-cation"==n){r.processedRes={};for(let t in e){let s=e[t];a=o.hashUtilsCls.unionHash(a,this.getPi(s,!1)),c=o.hashUtilsCls.unionHash(c,this.getCation(s))}r.processedRes={};for(let e in t){let s=t[e];h=o.hashUtilsCls.unionHash(h,this.getPi(s,!1)),d=o.hashUtilsCls.unionHash(d,this.getCation(s))}}else if("pi-stacking"==n){r.processedRes={};for(let t in e){let s=e[t];a=o.hashUtilsCls.unionHash(a,this.getPi(s,!0))}r.processedRes={};for(let e in t){let s=t[e];d=o.hashUtilsCls.unionHash(d,this.getPi(s,!0))}}let p={},m={};r.resid2Residhash={};let u=s*s;for(let e in a){let t=a[e],c=0==t.name.indexOf("pi")&&t.ring?t.ring.join(","):t.serial,h=t.resn+" $"+t.structure+"."+t.chain+":"+t.resi+"@"+t.name+" "+c;void 0===r.resid2Residhash[h]&&(r.resid2Residhash[h]={});for(let a in d){let c=d[a];if((r.crossstrucinter||t.structure==c.structure)&&e.substr(0,e.lastIndexOf("_"))!=a.substr(0,a.lastIndexOf("_"))){if("pi-cation"==n&&"ARG"===c.resn&&"NH1"===c.name){let e=c.structure+"_"+c.chain+"_"+c.resi,t=r.firstAtomObjCls.getFirstAtomObjByName(r.residues[e],"NH2"),s=c.coord.clone().add(t.coord).multiplyScalar(.5);c=o.hashUtilsCls.cloneHash(c),c.coord=s}"pi-stacking"==n&&void 0!==t.normal&&void 0!==c.normal&&Math.abs(t.normal.dot(c.normal)),this.getHalogenPiInteractions(t,c,i,n,s,u,h,l)&&(p=o.hashUtilsCls.unionHash(p,r.residues[t.structure+"_"+t.chain+"_"+t.resi]),p=o.hashUtilsCls.unionHash(p,r.residues[c.structure+"_"+c.chain+"_"+c.resi]),m[t.structure+"_"+t.chain+"_"+t.resi]=1,m[c.structure+"_"+c.chain+"_"+c.resi]=1)}}}for(let e in c){let t=c[e],a=0==t.name.indexOf("pi")&&t.ring?t.ring.join(","):t.serial,d=t.resn+" $"+t.structure+"."+t.chain+":"+t.resi+"@"+t.name+" "+a;if(void 0===r.resid2Residhash[d]&&(r.resid2Residhash[d]={}),"pi-cation"==n&&"ARG"===t.resn&&"NH1"===t.name){let e=t.structure+"_"+t.chain+"_"+t.resi,s=r.firstAtomObjCls.getFirstAtomObjByName(r.residues[e],"NH2"),i=t.coord.clone().add(s.coord).multiplyScalar(.5);t=o.hashUtilsCls.cloneHash(t),t.coord=i}for(let a in h){let c=h[a];(r.crossstrucinter||t.structure==c.structure)&&(e.substr(0,e.lastIndexOf("_"))!=a.substr(0,a.lastIndexOf("_"))&&this.getHalogenPiInteractions(t,c,i,n,s,u,d,l)&&(p=o.hashUtilsCls.unionHash(p,r.residues[t.structure+"_"+t.chain+"_"+t.resi]),p=o.hashUtilsCls.unionHash(p,r.residues[c.structure+"_"+c.chain+"_"+c.resi]),m[t.structure+"_"+t.chain+"_"+t.resi]=1,m[c.structure+"_"+c.chain+"_"+c.resi]=1))}}let g=Object.keys(m);if("graph"!==i)for(let e=0,t=g.length;e<t;++e)for(let t in r.residues[g[e]])r.atoms[t].style2="stick",r.ions.hasOwnProperty(t)&&(r.atoms[t].style2="sphere");return p}getHalogenDonar(e){this.icn3d.icn3dui;let t={};if("CL"===e.elem||"BR"===e.elem||"I"===e.elem){t[e.structure+"_"+e.chain+"_"+e.resi+"_"+e.name]=e}return t}getHalogenAcceptor(e){let t=this.icn3d;t.icn3dui;let s={},i="N"===e.elem||"O"===e.elem||"S"===e.elem;if(i=t.bOpm?i&&"DUM"!==e.resn:i,i){s[e.structure+"_"+e.chain+"_"+e.resi+"_"+e.name]=e}return s}getPi(e,t){let s=this.icn3d,i=s.icn3dui,n={},l=e.structure+"_"+e.chain+"_"+e.resi,r=e.het||s.nucleotides.hasOwnProperty(e.serial)||"PHE"===e.resn||"TYR"===e.resn||"TRP"===e.resn;if(t&&(r=r||"HIS"===e.resn),r&&!s.processedRes.hasOwnProperty(l)){if(e.het){let e=this.getAromaticPisLigand(l);n=i.hashUtilsCls.unionHash(n,e)}else{let t,i,r;r=s.nucleotides.hasOwnProperty(e.serial)?this.getAromaticRings(e.resn,l,"nucleotide"):this.getAromaticRings(e.resn,l,"protein"),void 0!==r&&(t=r.piPosArray,i=r.normalArray);for(let s=0,r=t.length;s<r;++s)n[l+"_pi"+s]={resn:e.resn,name:"pi"+s,coord:t[s],serial:e.serial,structure:e.structure,chain:e.chain,resi:e.resi,normal:i[s]}}s.processedRes[l]=1}return n}getCation(e){let t=this.icn3d,s=t.icn3dui,i={};if("ARG"===e.resn&&"NH2"===e.name)return;let n="LYS"===e.resn&&"N"===e.elem&&"N"!==e.name||"ARG"===e.resn&&("NH1"===e.name||"NH2"===e.name)||e.het&&-1!==s.parasCls.cationsTrimArray.indexOf(e.elem)||e.het&&"N"===e.elem&&(1==e.bonds.length||4==e.bonds.length);if(n=t.bOpm?n&&"DUM"!==e.resn:n,n){i[e.structure+"_"+e.chain+"_"+e.resi+"_"+e.name]=e}return i}getHalogenPiInteractions(e,t,s,i,n,l,r,o){let a=this.icn3d;a.icn3dui;let d=Math.abs(e.coord.x-t.coord.x);if(d>n)return!1;let c=Math.abs(e.coord.y-t.coord.y);if(c>n)return!1;let h=Math.abs(e.coord.z-t.coord.z);if(h>n)return!1;let p=d*d+c*c+h*h;if(p>l)return!1;"graph"!==s&&("halogen"==i?(a.halogenpnts.push({serial:e.serial,coord:e.coord}),a.halogenpnts.push({serial:t.serial,coord:t.coord})):"pi-cation"==i?(a.picationpnts.push({serial:e.serial,coord:e.coord}),a.picationpnts.push({serial:t.serial,coord:t.coord})):"pi-stacking"==i&&(a.pistackingpnts.push({serial:e.serial,coord:e.coord}),a.pistackingpnts.push({serial:t.serial,coord:t.coord})));let m=0==t.name.indexOf("pi")&&t.ring?t.ring.join(","):t.serial,u=t.resn+" $"+t.structure+"."+t.chain+":"+t.resi+"@"+t.name+" "+m;a.resid2Residhash[r][u]=p.toFixed(1);let g=e.structure+"_"+e.chain+"_"+e.resi+"_"+e.resn+","+t.structure+"_"+t.chain+"_"+t.resi+"_"+t.resn;return o||(void 0===a.resids2inter[g]&&(a.resids2inter[g]={}),void 0===a.resids2inter[g][i]&&(a.resids2inter[g][i]={}),a.resids2inter[g][i][r+"|"+u]=p.toFixed(1)),void 0===a.resids2interAll[g]&&(a.resids2interAll[g]={}),void 0===a.resids2interAll[g][i]&&(a.resids2interAll[g][i]={}),a.resids2interAll[g][i][r+"|"+u]=p.toFixed(1),!0}getRingNormal(e){if(this.icn3d.icn3dui,e.length<3)return;let t=e[0].clone().sub(e[1]),s=e[1].clone().sub(e[2]);return t.cross(s).normalize()}getAromaticRings(e,t,s){let i=this.icn3d;i.icn3dui;let n=[],l=[],r=[],o=[];if("nucleotide"==s){let s=new THREE.Vector3,a=new THREE.Vector3;if("A"==e.trim().toUpperCase()||"DA"==e.trim().toUpperCase()||"G"==e.trim().toUpperCase()||"DG"==e.trim().toUpperCase()){for(let e in i.residues[t]){let t=i.atoms[e];"N1"==t.name||"C2"==t.name||"N3"==t.name||"C6"==t.name?(s.add(t.coord),r.push(t.coord)):"C4"==t.name||"C5"==t.name?(s.add(t.coord),a.add(t.coord),r.push(t.coord),o.push(t.coord)):"N7"!=t.name&&"C8"!=t.name&&"N9"!=t.name||(a.add(t.coord),o.push(t.coord))}6==r.length&&(s.multiplyScalar(1/6),n.push(s),l.push(this.getRingNormal(r))),5==o.length&&(a.multiplyScalar(.2),n.push(a),l.push(this.getRingNormal(o)))}else if("C"==e.trim().toUpperCase()||"DC"==e.trim().toUpperCase()||"T"==e.trim().toUpperCase()||"DT"==e.trim().toUpperCase()||"U"==e.trim().toUpperCase()||"DU"==e.trim().toUpperCase()){for(let e in i.residues[t]){let t=i.atoms[e];"N1"==t.name||"C2"==t.name||"N3"==t.name||"C6"==t.name?(s.add(t.coord),r.push(t.coord)):"C4"!=t.name&&"C5"!=t.name||(s.add(t.coord),r.push(t.coord))}6==r.length&&(s.multiplyScalar(1/6),n.push(s),l.push(this.getRingNormal(r)))}}else if("protein"==s){let s=new THREE.Vector3,a=new THREE.Vector3;if("PHE"==e.toUpperCase()||"TYR"==e.toUpperCase()){for(let e in i.residues[t]){let t=i.atoms[e];"CG"!=t.name&&"CD1"!=t.name&&"CE1"!=t.name&&"CZ"!=t.name&&"CE2"!=t.name&&"CD2"!=t.name||(s.add(t.coord),r.push(t.coord))}6==r.length&&(s.multiplyScalar(1/6),n.push(s),l.push(this.getRingNormal(r)))}else if("HIS"==e.toUpperCase()){for(let e in i.residues[t]){let t=i.atoms[e];"CG"!=t.name&&"ND1"!=t.name&&"CE1"!=t.name&&"NE2"!=t.name&&"CD2"!=t.name||(s.add(t.coord),r.push(t.coord))}5==r.length&&(s.multiplyScalar(.2),n.push(s),l.push(this.getRingNormal(r)))}else if("TRP"==e.toUpperCase()){for(let e in i.residues[t]){let t=i.atoms[e];"CZ2"==t.name||"CH2"==t.name||"CZ3"==t.name||"CE3"==t.name?(s.add(t.coord),r.push(t.coord)):"CD2"==t.name||"CE2"==t.name?(s.add(t.coord),a.add(t.coord),r.push(t.coord),o.push(t.coord)):"CG"!=t.name&&"CD1"!=t.name&&"NE1"!=t.name||(a.add(t.coord),o.push(t.coord))}6==r.length&&(s.multiplyScalar(1/6),n.push(s),l.push(this.getRingNormal(r))),5==o.length&&(a.multiplyScalar(.2),n.push(a),l.push(this.getRingNormal(o)))}}return{piPosArray:n,normalArray:l}}dfs_cycle(e,t,s){let i=this.icn3d;if(i.icn3dui,2==i.ring_color[e])return s;if(1==i.ring_color[e]){s++;let n=t;for(i.ring_mark[n]=s;n!=e;)n=i.ring_par[n],i.ring_mark[n]=s;return s}if(i.ring_par[e]=t,i.ring_color[e]=1,void 0!==i.atoms[e])for(let t=0,n=i.atoms[e].bonds.length;t<n;++t){let n=i.atoms[e].bonds[t];n!=i.ring_par[e]&&(s=this.dfs_cycle(n,e,s))}return i.ring_color[e]=2,s}getAromaticPisLigand(e){let t=this.icn3d;t.icn3dui;let s={},i=Object.keys(t.residues[e]),n=i.length;t.ring_color={},t.ring_par={},t.ring_mark={};let l=0;l=this.dfs_cycle(i[1],i[0],l);let r={};for(let e=0;e<n;e++){let s=i[e];t.ring_mark[s]&&(void 0===r[t.ring_mark[s]]&&(r[t.ring_mark[s]]=[]),r[t.ring_mark[s]].push(s))}for(let i=1;i<=l;i++){let n,l=new THREE.Vector3,o=0,a=[],d=[];if(r.hasOwnProperty(i))for(let e=0,s=r[i].length;e<s;++e)n=r[i][e],l.add(t.atoms[n].coord),a.push(t.atoms[n].coord),d.push(n),++o;if(o>=3&&o<=6&&a[0]&&a[1]&&a[2]&&a[3]){let i=a[0].clone().sub(a[1]).normalize(),r=a[1].clone().sub(a[2]).normalize(),c=a[2].clone().sub(a[3]).normalize(),h=i.cross(r).normalize(),p=h.dot(c);if(Math.abs(p)<.052){l.multiplyScalar(1/o);let i=t.atoms[n];s[e+"_pi"+n]={resn:i.resn,name:"pi"+n,coord:l,serial:i.serial,structure:i.structure,chain:i.chain,resi:i.resi,normal:h,ring:d}}}}return s}hideHalogenPi(){let e=this.icn3d;e.icn3dui,e.opts.halogen="no",e.opts["pi-cation"]="no",e.opts["pi-stacking"]="no",void 0===e.lines&&(e.lines={}),e.lines.halogen=[],e.lines["pi-cation"]=[],e.lines["pi-stacking"]=[],e.halogenpnts=[],e.picationpnts=[],e.pistackingpnts=[]}}class ft{constructor(e){this.icn3d=e}calculateIonicInteractions(e,t,s,i,n,l){let r=this.icn3d,o=r.icn3dui;if(0===Object.keys(e).length||0===Object.keys(t).length)return;r.resid2Residhash={};let a,d,c={},h={},p=s*s;for(let t in e){let s=e[t];if("ARG"===s.resn&&"NH2"===s.name||"GLU"===s.resn&&"OE2"===s.name||"ASP"===s.resn&&"OD2"===s.name)continue;let i=("LYS"===s.resn||"HIS"===s.resn)&&"N"===s.elem&&"N"!==s.name||"ARG"===s.resn&&("NH1"===s.name||"NH2"===s.name)||s.het&&-1!==o.parasCls.cationsTrimArray.indexOf(s.elem)||s.het&&"N"===s.elem&&1==s.bonds.length,n=this.isAnion(s);i=r.bOpm?i&&"DUM"!==s.resn:i,n=r.bOpm?n&&"DUM"!==s.resn:n,(i||n)&&(a=s.structure+"_"+s.chain+"_"+s.resi,d=a+"_"+s.name,i&&(c[d]=s),n&&(h[d]=s))}let m={},u={};for(let e in t){let i=t[e];if("ARG"===i.resn&&"NH2"===i.name||"GLU"===i.resn&&"OE2"===i.name||"ASP"===i.resn&&"OD2"===i.name)continue;let g=("LYS"===i.resn||"HIS"===i.resn)&&"N"===i.elem&&"N"!==i.name||"ARG"===i.resn&&("NH1"===i.name||"NH2"===i.name)||i.het&&-1!==o.parasCls.cationsTrimArray.indexOf(i.elem),f=this.isAnion(i);if(g=r.bOpm?g&&"DUM"!==i.resn:g,f=r.bOpm?f&&"DUM"!==i.resn:f,g||f){a=i.structure+"_"+i.chain+"_"+i.resi,d=a+"_"+i.name;let e=0==i.name.indexOf("pi")&&i.ring?i.ring.join(","):i.serial,t=i.resn+" $"+i.structure+"."+i.chain+":"+i.resi+"@"+i.name+" "+e;void 0===r.resid2Residhash[t]&&(r.resid2Residhash[t]={});let C={};g?C=h:f&&(C=c);let b,y=i.structure+"_"+i.chain+"_"+i.resi;g&&"ARG"===i.resn&&"NH1"===i.name?b=r.firstAtomObjCls.getFirstAtomObjByName(r.residues[y],"NH2"):f&&"GLU"===i.resn&&"OE1"===i.name?b=r.firstAtomObjCls.getFirstAtomObjByName(r.residues[y],"OE2"):f&&"ASP"===i.resn&&"OD1"===i.name&&(b=r.firstAtomObjCls.getFirstAtomObjByName(r.residues[y],"OD2"));let v=void 0===b?i.coord:i.coord.clone().add(b.coord).multiplyScalar(.5);for(let e in C){if(a==e.substr(0,e.lastIndexOf("_")))continue;if(!r.crossstrucinter&&i.structure!=C[e].structure)continue;let d,c=C[e].structure+"_"+C[e].chain+"_"+C[e].resi;f&&"ARG"===C[e].resn&&"NH1"===C[e].name?d=r.firstAtomObjCls.getFirstAtomObjByName(r.residues[c],"NH2"):g&&"GLU"===C[e].resn&&"OE1"===C[e].name?d=r.firstAtomObjCls.getFirstAtomObjByName(r.residues[c],"OE2"):g&&"ASP"===C[e].resn&&"OD1"===C[e].name&&(d=r.firstAtomObjCls.getFirstAtomObjByName(r.residues[c],"OD2"));let h=void 0===d?C[e].coord:C[e].coord.clone().add(d.coord).multiplyScalar(.5),b=Math.abs(v.x-h.x);if(b>s)continue;let y=Math.abs(v.y-h.y);if(y>s)continue;let _=Math.abs(v.z-h.z);if(_>s)continue;let w=b*b+y*y+_*_;if(w>p)continue;"graph"!==n&&(r.saltbridgepnts.push({serial:i.serial,coord:v}),r.saltbridgepnts.push({serial:C[e].serial,coord:h}));let S=C[e].structure+"_"+C[e].chain+"_"+C[e].resi;m=o.hashUtilsCls.unionHash(m,r.residues[a]),m=o.hashUtilsCls.unionHash(m,r.residues[S]),u[a]=1,u[S]=1;let A=0==C[e].name.indexOf("pi")&&C[e].ring?C[e].ring.join(","):C[e].serial,x=C[e].resn+" $"+C[e].structure+"."+C[e].chain+":"+C[e].resi+"@"+C[e].name+" "+A;r.resid2Residhash[t][x]=w.toFixed(1);let k=a+"_"+i.resn+","+S+"_"+C[e].resn;l||(void 0===r.resids2inter[k]&&(r.resids2inter[k]={}),void 0===r.resids2inter[k].ionic&&(r.resids2inter[k].ionic={}),r.resids2inter[k].ionic[t+"|"+x]=w.toFixed(1)),void 0===r.resids2interAll[k]&&(r.resids2interAll[k]={}),void 0===r.resids2interAll[k].ionic&&(r.resids2interAll[k].ionic={}),r.resids2interAll[k].ionic[t+"|"+x]=w.toFixed(1)}}}let g=Object.keys(u);if("graph"!==n)for(let e=0,t=g.length;e<t;++e)for(let t in r.residues[g[e]])r.atoms[t].style2="stick",r.ions.hasOwnProperty(t)&&(r.atoms[t].style2="sphere");return m}isAnion(e){let t,s=this.icn3d,i=s.icn3dui;if(e.het&&"O"===e.elem&&1==e.bonds.length){let i=s.atoms[e.bonds[0]];for(let n=0;n<i.bonds.length;++n){let l=i.bonds[n];if("O"==s.atoms[l].elem&&l!=e.serial){t=!0;break}}}if("O"===e.elem&&1==e.bonds.length){let i=s.atoms[e.bonds[0]];"P"!=i.elem&&"S"!=i.elem||(t=!0)}return"GLU"===e.resn&&("OE1"===e.name||"OE2"===e.name)||"ASP"===e.resn&&("OD1"===e.name||"OD2"===e.name)||s.nucleotides.hasOwnProperty(e.serial)&&("OP1"===e.name||"OP2"===e.name||"O1P"===e.name||"O2P"===e.name)||e.het&&-1!==i.parasCls.anionsTrimArray.indexOf(e.elem)||t}hideSaltbridge(){let e=this.icn3d;e.icn3dui,e.opts.saltbridge="no",void 0===e.lines&&(e.lines={}),e.lines.saltbridge=[],e.saltbridgepnts=[]}}class Ct{constructor(e){this.icn3d=e}setStyle2Atoms(e){let t=this.icn3d;t.icn3dui,t.style2atoms={};for(let s in e)void 0===t.style2atoms[t.atoms[s].style]&&(t.style2atoms[t.atoms[s].style]={}),t.style2atoms[t.atoms[s].style][s]=1,void 0!==t.atoms[s].style2&&"nothing"!==t.atoms[s].style2&&(void 0===t.style2atoms[t.atoms[s].style2]&&(t.style2atoms[t.atoms[s].style2]={}),t.style2atoms[t.atoms[s].style2][s]=1)}setAtomStyleByOptions(e){let t,s=this.icn3d,i=s.icn3dui;if(void 0===e&&(e=s.opts),void 0!==e.proteins){t=i.hashUtilsCls.intHash(s.hAtoms,s.proteins);for(let i in t)s.atoms[i].style=e.proteins.toLowerCase()}if(void 0!==e.sidec&&"nothing"!==e.sidec){t=i.hashUtilsCls.intHash(s.hAtoms,s.sidec);for(let i in t)s.atoms[i].style2=e.sidec.toLowerCase()}if(void 0!==e.ntbase&&"nothing"!==e.ntbase){t=i.hashUtilsCls.intHash(s.hAtoms,s.ntbase);for(let i in t)s.atoms[i].style2=e.ntbase.toLowerCase()}if(void 0!==e.chemicals){t=i.hashUtilsCls.intHash(s.hAtoms,s.chemicals);for(let i in t)s.atoms[i].style=e.chemicals.toLowerCase()}if(void 0!==e.ions){t=i.hashUtilsCls.intHash(s.hAtoms,s.ions);for(let i in t)s.atoms[i].style=e.ions.toLowerCase()}if(void 0!==e.water){t=i.hashUtilsCls.intHash(s.hAtoms,s.water);for(let i in t)s.atoms[i].style=e.water.toLowerCase()}if(void 0!==e.nucleotides){t=i.hashUtilsCls.intHash(s.hAtoms,s.nucleotides);for(let i in t)s.atoms[i].style=e.nucleotides.toLowerCase()}}setBackground(e){var t=this.icn3d,s=t.icn3dui;t.setOptionCls.setOption("background",e),s.htmlCls.clickMenuCls.setLogCmd("set background "+e,!0);let i="black"==e?s.htmlCls.GREYD:"black";$("#"+t.pre+"title").css("color",i),$("#"+t.pre+"titlelink").css("color",i)}saveCommandsToSession(){var e=this.icn3d;e.icn3dui;let t=e.commands.join("\n"),s=decodeURIComponent(t);sessionStorage.setItem("commands",s)}getCommandsBeforeCrash(){var e=this.icn3d,t=e.icn3dui;window.addEventListener("load",(function(){sessionStorage.setItem("good_exit","pending")})),window.addEventListener("beforeunload",(function(){sessionStorage.setItem("good_exit","true")})),sessionStorage.getItem("good_exit")&&"pending"===sessionStorage.getItem("good_exit")&&(t.utilsCls.isMac()||(e.bCrashed=!0),e.commandsBeforeCrash=sessionStorage.getItem("commands"),e.commandsBeforeCrash||(e.commandsBeforeCrash=""))}handleContextLost(){var e=this.icn3d;e.icn3dui;let t=$("#"+e.pre+"canvas")[0];t.addEventListener("webglcontextlost",(function(e){e.preventDefault()}),!1),t.addEventListener("webglcontextrestored",(function(t){console.log("WebGL context was lost. Reset WebGLRenderer and launch iCn3D again."),e.renderer=new THREE.WebGLRenderer({canvas:e.oriContainer.get(0),antialias:!0,preserveDrawingBuffer:!0,sortObjects:!1,alpha:!0}),e.renderer.xr.enabled=!0,e.drawCls.draw()}),!1)}adjustIcon(){var e=this.icn3d;e.icn3dui,1===e.STATENUMBER?$("#"+e.pre+"back").hasClass("icn3d-middleIcon")&&($("#"+e.pre+"back").toggleClass("icn3d-middleIcon"),$("#"+e.pre+"back").toggleClass("icn3d-endIcon")):$("#"+e.pre+"back").hasClass("icn3d-endIcon")&&($("#"+e.pre+"back").toggleClass("icn3d-middleIcon"),$("#"+e.pre+"back").toggleClass("icn3d-endIcon")),e.STATENUMBER===e.commands.length?$("#"+e.pre+"forward").hasClass("icn3d-middleIcon")&&($("#"+e.pre+"forward").toggleClass("icn3d-middleIcon"),$("#"+e.pre+"forward").toggleClass("icn3d-endIcon")):$("#"+e.pre+"forward").hasClass("icn3d-endIcon")&&($("#"+e.pre+"forward").toggleClass("icn3d-middleIcon"),$("#"+e.pre+"forward").toggleClass("icn3d-endIcon"))}}class bt{constructor(e){this.icn3d=e}colorSpectrum(e){let t=this.icn3d,s=t.icn3dui,i=0,n=0;e=s.hashUtilsCls.intHash(e,t.hAtoms);for(let s in e)t.atoms[s],++n;let l=n>1?1/(n-1):1;for(let n in e){let e=t.atoms[n];e.color=s.parasCls.thr().setHSL(3/4*(1-i++*l),1,.45),t.atomPrevColors[n]=e.color}}colorRainbow(e){let t=this.icn3d,s=t.icn3dui,i=0,n=0;e=s.hashUtilsCls.intHash(e,t.hAtoms);for(let s in e)t.atoms[s],++n;let l=n>1?1/(n-1):1;for(let n in e){let e=t.atoms[n];e.color=s.parasCls.thr().setHSL(3/4*i++*l,1,.45),t.atomPrevColors[n]=e.color}}setColorAcrossSets(e,t){let s=this.icn3d,i=s.icn3dui,n=0,l=e.length,r=l>1?1/(l-1):1;for(let l=0,o=e.length;l<o;++l){let o=s.definedSetsCls.getAtomsFromNameArray([e[l]]);for(let e in o){let l=s.atoms[e];l.color=t?i.parasCls.thr().setHSL(3/4*(1-n*r),1,.45):i.parasCls.thr().setHSL(3/4*n*r,1,.45),s.atomPrevColors[e]=l.color}++n}s.drawCls.draw()}setColorBySets(e,t){let s=this.icn3d;s.icn3dui;for(let i=0,n=e.length;i<n;++i){let n=s.definedSetsCls.getAtomsFromNameArray([e[i]]);t?this.colorSpectrum(n):this.colorRainbow(n)}s.drawCls.draw()}setColorByOptions(e,t,s){let i=this.icn3d,n=i.icn3dui;if(void 0!==e)if(s)for(let e in t){let t=i.atoms[e];i.atomPrevColors[e]=t.color}else if(0===e.color.indexOf("#"))for(let s in t){let t=i.atoms[s];t.color=n.parasCls.thr().setStyle(e.color.toLowerCase()),i.atomPrevColors[s]=t.color}else{let s,l,r,o,a;switch("confidence"==e.color.toLowerCase()?$("#"+n.pre+"legend").show():$("#"+n.pre+"legend").hide(),e.color.toLowerCase()){case"rainbow":this.colorRainbow(t);break;case"rainbow for chains":for(let e in i.chains)this.colorRainbow(i.chains[e]);break;case"spectrum":this.colorSpectrum(t);break;case"spectrum for chains":for(let e in i.chains)this.colorSpectrum(i.chains[e]);break;case"structure":let d=i.bAfMem?[n.parasCls.thr(16711935),n.parasCls.thr(65280)]:n.parasCls.stdChainColors,c=-1,h="",p=d.length;for(let e in t){let t=i.atoms[e];t.structure!=h&&(++c,c%=p),t.het?(t.color=n.parasCls.atomColors[t.elem],i.atomPrevColors[e]=t.color):(t.color=d[c],i.atomPrevColors[e]=t.color),h=t.structure}break;case"chain":if(void 0!==i.chainsColor&&Object.keys(i.chainsColor).length>0)this.setMmdbChainColor();else{let e=-1,s="",l=n.parasCls.stdChainColors.length;for(let r in t){let t=i.atoms[r];t.chain!=s&&(++e,e%=l),t.het?(t.color=n.parasCls.atomColors[t.elem],i.atomPrevColors[r]=t.color):(t.color=n.parasCls.stdChainColors[e],Object.keys(i.chainsColor).length>0&&this.updateChainsColor(t),i.atomPrevColors[r]=t.color),s=t.chain}}break;case"domain":s=0,l=0;let m=Object.keys(i.tddomains);l=m.length,r=l>1?1/(l-1):1;for(let e=0,t=m.length;e<t;++e){let t=n.parasCls.thr().setHSL(3/4*(1-s++*r),1,.45);for(let s in i.tddomains[m[e]])for(let e in i.residues[s]){let s=i.atoms[e];s.color=t,i.atomPrevColors[e]=s.color}}break;case"defined sets":if(s=0,i.nameArray&&0!=i.nameArray.length){l=i.nameArray.length,r=l>1?1/(l-1):1;for(let e=0;e<l;++e){let t=i.nameArray[e],l=i.definedSetsCls.getAtomsFromNameArray([t]),o=n.parasCls.thr().setHSL(3/4*s++*r,1,.45);for(let e in l){let t=i.atoms[e];t.color=o,i.atomPrevColors[e]=t.color}}}else alert('Please first select sets in "Analysis > Defined Sets", and try it again.');break;case"secondary structure green":case"secondary structure":i.sheetcolor="green";for(let e in t){let t=i.atoms[e];t.color=t.het?n.parasCls.atomColors[t.elem]||n.parasCls.defaultAtomColor:n.parasCls.ssColors[t.ss]||n.parasCls.thr(16711935),i.atomPrevColors[e]=t.color}break;case"secondary structure yellow":i.sheetcolor="yellow";for(let e in t){let t=i.atoms[e];t.color=t.het?n.parasCls.atomColors[t.elem]||n.parasCls.defaultAtomColor:n.parasCls.ssColors2[t.ss]||n.parasCls.thr(16711935),i.atomPrevColors[e]=t.color}break;case"secondary structure spectrum":s=0,l=0;let u,g,f=[],C=-9999;for(let e in t){if(!i.proteins.hasOwnProperty(e))continue;let t=i.atoms[e];-9999==C&&(u=parseInt(e)),-9999!=C&&(t.ss!=g.ss||Math.abs(t.resi-g.resi)>1||t.ssbegin&&g.ssend)&&("coil"==g.ss||f.push([u,C]),u=e),C=parseInt(e),g=t}"coil"==g.ss||f.push([u,C]),l=f.length,r=l>1?1/(l-1):1;for(let e=0,t=f.length;e<t;++e){let t=n.parasCls.thr().setHSL(3/4*(1-s++*r),1,.45);for(let s=f[e][0];s<=f[e][1];++s){let e=i.atoms[s];e.color=t,i.atomPrevColors[s]=e.color}}break;case"residue":for(let e in t){let t=i.atoms[e];t.color=t.het?n.parasCls.atomColors[t.elem]||n.parasCls.defaultAtomColor:n.parasCls.residueColors[t.resn]||n.parasCls.defaultResidueColor,i.atomPrevColors[e]=t.color}break;case"ig strand":if(i.bShowRefnum){let e,s=i.firstAtomObjCls.getResiduesFromAtoms(t);for(let t in s){if(i.resid2refnum[t]){let s=i.resid2refnum[t],l=i.refnumCls.rmStrandFromRefnumlabel(s),r=s.replace(new RegExp(l,"g"),"");e=i.annoIgCls.getRefnumColor(r),i.residIgLoop.hasOwnProperty(t)&&(e=n.parasCls.thr(n.htmlCls.GREYB))}else e=n.parasCls.thr("#00FFFF");for(let s in i.residues[t]){let t=i.atoms[s];t.color=n.parasCls.thr(e),i.atomPrevColors[s]=t.color}}}break;case"ig protodomain":if(i.bShowRefnum){let e,s=i.firstAtomObjCls.getResiduesFromAtoms(t);for(let t in s){if(i.resid2refnum[t]){let s=i.resid2refnum[t];if(s){let l=i.refnumCls.rmStrandFromRefnumlabel(s),r=s.replace(new RegExp(l,"g"),"");e=i.annoIgCls.getProtodomainColor(r),i.residIgLoop.hasOwnProperty(t)&&(e=n.parasCls.thr(n.htmlCls.GREYB))}else e=n.parasCls.thr(n.htmlCls.GREYB)}else e=n.parasCls.thr("#00FFFF");for(let s in i.residues[t]){let t=i.atoms[s];t.color=n.parasCls.thr(e),i.atomPrevColors[s]=t.color}}}break;case"residue custom":for(let e in t){let t=i.atoms[e];t.color=t.het?n.parasCls.atomColors[t.elem]||n.parasCls.defaultAtomColor:i.customResidueColors[t.resn]||n.parasCls.defaultResidueColor,i.atomPrevColors[e]=t.color}break;case"align custom":i.middB=50,i.spanBinv1=.02,i.spanBinv2=.02;for(let e in t){let t,s=i.atoms[e].structure+"_"+i.atoms[e].chain;if(void 0===i.queryresi2score||!i.queryresi2score.hasOwnProperty(s))continue;let l=i.atoms[e].resi;if(i.queryresi2score[s].hasOwnProperty(l)){let e=i.queryresi2score[s][l];e>100&&(e=100);let r=(i.middB-e)*i.spanBinv1,o=(e-i.middB)*i.spanBinv2;e<i.middB?"blue"==i.startColor?t="white"==i.midColor?n.parasCls.thr().setRGB(1-r,1-r,1):n.parasCls.thr().setRGB(0,0,r):"red"==i.startColor?t="white"==i.midColor?n.parasCls.thr().setRGB(1,1-r,1-r):n.parasCls.thr().setRGB(r,0,0):"green"==i.startColor&&(t="white"==i.midColor?n.parasCls.thr().setRGB(1-r,1,1-r):n.parasCls.thr().setRGB(0,r,0)):"red"==i.endColor?t="white"==i.midColor?n.parasCls.thr().setRGB(1,1-o,1-o):n.parasCls.thr().setRGB(o,0,0):"green"==i.endColor?t="white"==i.midColor?n.parasCls.thr().setRGB(1-o,1,1-o):n.parasCls.thr().setRGB(0,o,0):"blue"==i.endColor&&(t="white"==i.midColor?n.parasCls.thr().setRGB(1-o,1-o,1):n.parasCls.thr().setRGB(0,0,o))}else t=n.parasCls.defaultAtomColor;i.atoms[e].color=t,i.atomPrevColors[e]=t}break;case"charge":for(let e in t){let t=i.atoms[e];t.color=t.het?n.parasCls.defaultAtomColor:n.parasCls.chargeColors[t.resn]||n.parasCls.defaultResidueColor,i.atomPrevColors[e]=t.color}break;case"hydrophobic":for(let e in t){let t=i.atoms[e];t.color=t.het?n.parasCls.defaultAtomColor:n.parasCls.hydrophobicColors[t.resn]||n.parasCls.defaultResidueColor,i.atomPrevColors[e]=t.color}break;case"normalized hydrophobic":for(let e in t){let t=i.atoms[e];t.color=t.het?n.parasCls.defaultAtomColor:n.parasCls.normalizedHPColors[t.resn]||n.parasCls.defaultResidueColor,i.atomPrevColors[e]=t.color}break;case"atom":for(let e in t){let t=i.atoms[e];t.color=n.parasCls.atomColors[t.elem]||n.parasCls.defaultAtomColor,i.atomPrevColors[e]=t.color}break;case"confidence":for(let e in t){let t=i.atoms[e];if(void 0===t.b||isNaN(t.b)||0==parseInt(1e3*t.b))t.color=n.parasCls.thr().setRGB(0,1,0);else{let e=t.b;e=t.structure.substr(0,4)!=i.defaultPdbId&&t.structure.length<6?100-e:e,e>=90?t.color=n.parasCls.thr().setRGB(0,.325,.839):e>=70&&e<90?t.color=n.parasCls.thr().setRGB(.396,.572,.953):e>=50&&e<70?t.color=n.parasCls.thr().setRGB(1,.859,.075):e<50&&(t.color=n.parasCls.thr().setRGB(1,.49,.271))}i.atomPrevColors[e]=t.color}break;case"b factor":i.middB=50,i.spanBinv1=.02,i.spanBinv2=.02;for(let e in t){let t=i.atoms[e];if(void 0===t.b||isNaN(t.b)||0==parseInt(1e3*t.b))t.color=n.parasCls.thr().setRGB(0,1,0);else{let e=t.b;e>100&&(e=100),e=t.structure.substr(0,4)!=i.defaultPdbId&&t.structure.length>5?100-e:e;let s=(i.middB-e)*i.spanBinv1,l=(e-i.middB)*i.spanBinv2;t.color=e<i.middB?n.parasCls.thr().setRGB(1-s,1-s,1):n.parasCls.thr().setRGB(1,1-l,1-l)}i.bOpm&&"DUM"==t.resn&&(t.color=n.parasCls.atomColors[t.elem]),i.atomPrevColors[e]=t.color}break;case"b factor percentile":if(o=1e3,a=-1e3,!i.bfactorArray){i.bfactorArray=[];for(let e in i.atoms){let t=i.atoms[e];o>t.b&&(o=t.b),a<t.b&&(a=t.b),i.bfactorArray.push(t.b)}i.bfactorArray.sort((function(e,t){return e-t}))}let b=i.bfactorArray.length;for(let e in t){let t=i.atoms[e];if(void 0===t.b||isNaN(t.b)||0==parseInt(1e3*t.b)||0==i.bfactorArray.length)t.color=n.parasCls.thr().setRGB(0,1,0);else{let e=t.structure>5?100-t.b:t.b,s=i.bfactorArray.indexOf(e)/b;t.color=s<.5?n.parasCls.thr().setRGB(2*s,2*s,1):n.parasCls.thr().setRGB(1,2*(1-s),2*(1-s))}i.atomPrevColors[e]=t.color}break;case"area":if(void 0===i.resid2area){let e=n.hashUtilsCls.cloneHash(i.hAtoms);i.hAtoms=n.hashUtilsCls.cloneHash(i.atoms),i.bCalcArea=!0,i.opts.surface="solvent accessible surface",i.applyMapCls.applySurfaceOptions(),i.bCalcArea=!1,i.hAtoms=n.hashUtilsCls.cloneHash(e)}let y=void 0!==i.midpercent?i.midpercent:35;i.spanBinv1=.02,i.spanBinv2=.02;for(let e in t){let t=i.atoms[e],s=t.structure+"_"+t.chain+"_"+t.resi+"_"+t.resn,l=n.parasCls.residueArea.hasOwnProperty(t.resn)?i.resid2area[s]/n.parasCls.residueArea[t.resn]*100:y;l>100&&(l=100);let r=(y-l)*i.spanBinv1,o=(l-y)*i.spanBinv2;t.color=l<y?n.parasCls.thr().setRGB(1-r,1-r,1):n.parasCls.thr().setRGB(1,1-o,1-o),i.bOpm&&"DUM"==t.resn&&(t.color=n.parasCls.atomColors[t.elem]),i.atomPrevColors[e]=t.color}break;case"identity":case"conserved":this.setConservationColor(t,!0);break;case"conservation":this.setConservationColor(t,!1);break;case"white":this.setAtmClr(t,16777215);break;case"grey":this.setAtmClr(t,8947848);break;case"red":this.setAtmClr(t,16711680);break;case"green":this.setAtmClr(t,65280);break;case"blue":this.setAtmClr(t,255);break;case"magenta":this.setAtmClr(t,16711935);break;case"yellow":this.setAtmClr(t,16776960);break;case"cyan":this.setAtmClr(t,65535);break;case"custom":break;default:for(let s in t){let t=i.atoms[s];t.color=n.parasCls.thr().setStyle("#"+e.color.toLowerCase()),i.atomPrevColors[s]=t.color}}i.legendTableCls.showColorLegend(e.color.toLowerCase())}}setAtmClr(e,t){let s=this.icn3d,i=s.icn3dui;for(let n in e){let e=s.atoms[n];e.color=i.parasCls.thr().setHex(t),s.atomPrevColors[n]=e.color}}updateChainsColor(e){let t=this.icn3d;t.icn3dui;let s=e.structure+"_"+e.chain;void 0!==t.chainsColor[s]&&(t.chainsColor[s]=e.color)}setMmdbChainColor(e){let t,s=this.icn3d,i=s.icn3dui,n=void 0===e?s.hAtoms:e;this.applyOriginalColor(i.hashUtilsCls.hash2Atoms(n,s.atoms)),t=i.hashUtilsCls.unionHash(t,s.chemicals),t=i.hashUtilsCls.unionHash(t,s.ions);for(let e in t){let t=s.atoms[e];t.color=i.parasCls.atomColors[t.elem]||i.parasCls.defaultAtomColor,s.atomPrevColors[e]=t.color}}setConservationColor(e,t){let s=this.icn3d,i=s.icn3dui;this.setMmdbChainColor(e);for(let n in s.alnChainsSeq){let l=s.alnChainsSeq[n];for(let r=0,o=l.length;r<o;++r){let o=n+"_"+l[r].resi;for(let n in s.residues[o])if(e.hasOwnProperty(n)){let e=t?i.parasCls.thr(l[r].color):i.parasCls.thr(l[r].color2);s.atoms[n].color=e,s.atomPrevColors[n]=e}}}}applyOriginalColor(e){let t=this.icn3d,s=t.icn3dui;void 0===e&&(e=t.atoms);for(let i in e){let n=e[i],l=n.structure+"_"+n.chain;t.chainsColor.hasOwnProperty(l)?n.color=t.chainsColor[l]:n.color=s.parasCls.atomColors[n.elem],t.atomPrevColors[i]=n.color}}applyPrevColor(){let e=this.icn3d;e.icn3dui;for(let t in e.atoms){e.atoms[t].color=e.atomPrevColors[t]}}setOutlineColor(e){this.icn3d.icn3dui;let t={outline:{vertex_shader:["uniform float offset;","void main() {","vec4 pos = modelViewMatrix * vec4( position + normal * offset, 1.0 );","gl_Position = projectionMatrix * pos;","}"].join("\n"),fragment_shader:["void main(){","gl_FragColor = vec4( 1.0, 1.0, 0.0, 1.0 );","}"].join("\n")}};"yellow"===e?t.outline.fragment_shader=["void main(){","gl_FragColor = vec4( 1.0, 1.0, 0.0, 1.0 );","}"].join("\n"):"green"===e?t.outline.fragment_shader=["void main(){","gl_FragColor = vec4( 0.0, 1.0, 0.0, 1.0 );","}"].join("\n"):"red"===e&&(t.outline.fragment_shader=["void main(){","gl_FragColor = vec4( 1.0, 0.0, 0.0, 1.0 );","}"].join("\n"));let s=t.outline;return new THREE.ShaderMaterial({uniforms:{offset:{type:"f",value:.5}},vertexShader:s.vertex_shader,fragmentShader:s.fragment_shader,depthTest:!1,depthWrite:!1})}}class yt{constructor(e){this.icn3d=e}setOption(e,t){var s=this.icn3d;s.icn3dui,s.opts[e]=t,s.selectionCls.saveSelectionIfSelected(),"color"===e?(s.setColorCls.setColorByOptions(s.opts,s.hAtoms),s.drawCls.draw(),s.hlUpdateCls.updateHlAll(),s.getGraphCls.updateGraphColor()):"surface"===e||"opacity"===e||"wireframe"===e?("opacity"!==e&&"wireframe"!==e||s.applyMapCls.removeLastSurface(),s.applyMapCls.applySurfaceOptions(),s.drawCls.draw()):"map"===e||"mapwireframe"===e?("mapwireframe"===e&&s.applyMapCls.removeLastMap(),s.applyMapCls.applyMapOptions(),s.drawCls.draw()):"emmap"===e||"emmapwireframe"===e?("emmapwireframe"===e&&s.applyMapCls.removeLastEmmap(),s.applyMapCls.applyEmmapOptions(),s.drawCls.draw()):"phimap"===e||"phimapwireframe"===e?("phimapwireframe"===e&&s.applyMapCls.removeLastPhimap(),s.applyMapCls.applyPhimapOptions(),s.drawCls.draw()):"phisurface"===e?(s.applyMapCls.applyphisurfaceOptions(),s.drawCls.draw()):"chemicalbinding"===e?(s.bSkipChemicalbinding=!1,s.drawCls.draw()):s.drawCls.draw()}setStyle(e,t){var s=this.icn3d,i=s.icn3dui;let n={};switch(e){case"proteins":if(n=i.hashUtilsCls.intHash(s.hAtoms,s.proteins),Object.keys(s.hAtoms).length,Object.keys(s.proteins).length,"nothing"==t){s.opts.ssbonds="no",s.lines.ssbond=[];for(let e in n)s.atoms[e].style2="nothing"}else s.opts.ssbonds="yes";break;case"sidec":n=i.hashUtilsCls.intHash(s.hAtoms,s.sidec);break;case"nucleotides":n=i.hashUtilsCls.intHash(s.hAtoms,s.nucleotides),Object.keys(s.hAtoms).length,Object.keys(s.nucleotides).length;break;case"ntbase":n=i.hashUtilsCls.intHash(s.hAtoms,s.ntbase);break;case"chemicals":n=i.hashUtilsCls.intHash(s.hAtoms,s.chemicals);break;case"ions":n=i.hashUtilsCls.intHash(s.hAtoms,s.ions);break;case"water":n=i.hashUtilsCls.intHash(s.hAtoms,s.water)}if("sidec"===e||"ntbase"===e)for(let e in n)s.atoms[e].style2=t;else for(let e in n)s.atoms[e].style=t;s.opts[e]=t,s.selectionCls.saveSelectionIfSelected(),s.drawCls.draw()}saveStyle(){var e=this.icn3d;e.icn3dui;for(let t in e.atoms){let s=e.atoms[t];s.styleSave=s.style,void 0!==s.style2&&(s.style2Save=s.style2)}}applySavedStyle(){var e=this.icn3d;e.icn3dui;for(let t in e.atoms){let s=e.atoms[t];void 0!==s.styleSave&&(s.style=s.styleSave),void 0!==s.style2Save&&(s.style2=s.style2Save)}e.drawCls.draw()}saveColor(){var e=this.icn3d;e.icn3dui;for(let t in e.atoms){let s=e.atoms[t];s.colorSave=s.color.clone()}}applySavedColor(){var e=this.icn3d;e.icn3dui;for(let t in e.atoms){let s=e.atoms[t];void 0!==s.colorSave&&(s.color=s.colorSave.clone(),e.atomPrevColors[t]=s.color)}e.hlUpdateCls.changeSeqColor(Object.keys(e.residues)),e.drawCls.draw()}}class vt{constructor(e){this.icn3d=e}showColorLegend(e){let t=this.icn3d,s=t.icn3dui,i=e.substr(0,1).toUpperCase()+e.substr(1);"confidence"==e?i="pLDDT":"normalized hydrophobic"==e?i="Normalized Hydrophobicity":"hydrophobic"==e?i="Hydrophobicity":"ig strand"==e?i="Ig Strand":"ig protodomain"==e?i="Ig Protodomain":"exon"==e&&(i="Exon");let n="Color by <b>"+i+"</b><br><br>";if("atom"==e){let e=["proteins","nucleotides","chemicals","ions","water"];for(let i=0,l=e.length;i<l;++i){let l=e[i],r=s.hashUtilsCls.intHash(t[l],t.hAtoms);n+=this.getColorLegendForElem(l,r)}}else if("residue"==e)n+=this.getColorLegendForResidue(t.hAtoms);else if("charge"==e)n+=this.getColorLegendForCharge(t.hAtoms);else if("ig strand"==e)n+=this.getColorLegendForIgstrand(t.hAtoms);else if("ig protodomain"==e)n+=this.getColorLegendForIgproto(t.hAtoms);else if("normalized hydrophobic"==e||"hydrophobic"==e){let i=!0,o=this.getRes2color(t.hAtoms,i);var l=Object.keys(o).map((e=>[e,s.parasCls.hydrophobicValues[e]]));l.sort(((e,t)=>parseFloat(e[1])-parseFloat(t[1])));var r=l.map((e=>[e[0],Object.keys(o[e[0]])[0]]));n+="<div>","normalized hydrophobic"==e?(n+="Dark green (W, F, L, I, Y, M, V, C): Hydrophobic<br>",n+="Light green (P, T, S, A, Q, N, G): Polar<br>",n+="Grey: Charged, not hydrophobic<br><br>"):(n+="Green (W, F, L, I, Y, M, V, C): Hydrophobic<br>",n+="Yellow (P, T, S, A, Q, N, G): Polar<br>",n+="Red: Negatively Charged<br>",n+="Blue: Positively Charged<br><br>");let a=0;for(let e of r)s.parasCls.residueAbbrev[e[0]]&&(n+="<div style='display:inline-block; width:100px'>",n+="<div style='width: 10px; height: 10px; background-color:#"+e[1]+"; border: 0px;display:inline-block;' ></div> ",n+=s.parasCls.residueAbbrev[e[0]]+"</div>",a%4==3&&(n+="<br>"),++a);n+="</div>"}else"b factor"==e?(n+="<div style='width:450px'>B factor quantitates the uncertainty for each atom. A high B factor reflects that the position is less certain.</div><br>",n+=s.htmlCls.clickMenuCls.setLegendHtml()):"confidence"==e?n+=s.htmlCls.clickMenuCls.setLegendHtml(!0):"exon"==e?(t.startColor="red",t.midColor="white",t.endColor="blue",t.startValue="Start",t.midValue="Middle",t.endValue="End",n+=s.htmlCls.clickMenuCls.setLegendHtml()):n="";n?($("#"+s.pre+"dl_legend_html").html(n),s.htmlCls.dialogCls.openDlg("dl_legend","Color Legend")):$("#"+s.pre+"dl_legend").hasClass("ui-dialog-content")&&$("#"+s.pre+"dl_legend").dialog("isOpen")&&$("#"+s.pre+"dl_legend").dialog("close")}getColorLegendForElem(e,t){let s=this.icn3d,i=s.icn3dui,n="",l={};for(let e in t){let t=s.atoms[e],i=void 0===t||void 0===t.color||"FFFFFF"===t.color.getHexString().toUpperCase()?"DDDDDD":t.color.getHexString();void 0===l[t.elem]&&(l[t.elem]={}),l[t.elem][i]=1}if(Object.keys(l).length>0){n+="<b>"+e+"</b><br>";let t=Object.keys(l).sort();for(let e=0,s=t.length;e<s;++e){let s=t[e];n+="<span>";for(let e in l[s])n+="<div style='width: 10px; height: 10px; background-color:#"+e+"; border: 0px;display:inline-block;' ></div> ";n+=i.parasCls.atomnames[s.toUpperCase()]+"</span><br>"}n+="<br>"}return n}getRes2color(e,t){let s=this.icn3d,i=s.icn3dui,n={},l=s.firstAtomObjCls.getResiduesFromAtoms(e);for(let e in l){let l=s.residues[e],r=s.firstAtomObjCls.getFirstAtomObj(l),o=t?r.resn:i.parasCls.residueAbbrev[r.resn],a=void 0===r||void 0===r.color||"FFFFFF"===r.color.getHexString().toUpperCase()?"DDDDDD":r.color.getHexString();null!=o&&(void 0===n[o]&&(n[o]={}),n[o][a]=1)}return n}getColorLegendForResidue(e){this.icn3d.icn3dui;let t="",s=this.getRes2color(e);if(Object.keys(s).length>0){t+="<div>";let e=Object.keys(s).sort(),i="",n=0;for(let l=0,r=e.length;l<r;++l){let r="",o=e[l];r+="<div style='display:inline-block; width:100px'>";for(let e in s[o])r+="<div style='width: 10px; height: 10px; background-color:#"+e+"; border: 0px;display:inline-block;' ></div> ";r+=o+"</div>",n%4==3&&(r+="<br>"),-1!=o.indexOf("(")?(t+=r,++n):i+=r}i&&(t+="<br>"+i),t+="</div>"}return t}getColorLegendForCharge(e){let t=this.icn3d;t.icn3dui;let s="",i=t.firstAtomObjCls.getResiduesFromAtoms(e),n={};for(let e in i){let s=t.residues[e],i=t.firstAtomObjCls.getFirstAtomObj(s);"ARG"==i.resn||"LYS"==i.resn?n.Positive=1:"HIS"==i.resn?n["Partial-Positive"]=1:"ASP"==i.resn||"GLU"==i.resn||t.nucleotides[i.serial]?n.Negative=1:n.Neutral=1}const l={Positive:"0000ff","Partial-Positive":"8080ff",Negative:"ff0000",Neutral:"888888"};let r=["Positive","Partial-Positive","Negative","Neutral"];s+="<div>";for(let e=0,t=r.length;e<t;++e){let t=r[e];n[t]&&(s+="<span>",s+="<div style='width: 10px; height: 10px; background-color:#"+l[t]+"; border: 0px;display:inline-block;' ></div> ",s+=t,s+="</span><br>")}return s+="<br>(Charges are at pH 7)",s+="</div>",s}getColorLegendForIgstrand(e){this.icn3d.icn3dui;let t="";const s={"A Strand":"9400D3","B Strand":"ba55d3","C Strand":"0000FF","C' Strand":"6495ED","C'' Strand":"006400","D Strand":"00FF00","E Strand":"FFD700","F Strand":"FF8C00","G Strand":"FF0000",Loop:"CCCCCC"};t+="<div>";for(let e in s){t+="<span>",t+="<div style='width: 10px; height: 10px; background-color:#"+s[e]+"; border: 0px;display:inline-block;' ></div> ",t+=e,t+="</span><br>"}return t+="</div>",t}getColorLegendForIgproto(e){this.icn3d.icn3dui;let t="";const s={"<b>Protodomain 1</b>":"","A Strand":"0000FF","B Strand":"006400","C Strand":"FFD700","C' Strand":"FF8C00","<br><b>Linker</b>":"","C'' Strand":"FF0000","<br><b>Protodomain 2</b>":"","D Strand":"0000FF","E Strand":"006400","F Strand":"FFD700","G Strand":"FF8C00","":"",Loop:"CCCCCC"};t+="<div>A protodomain is a supersecondary structure <br>that by its duplication, symmetry operations <br>can generate a structural domain.<br><br>";for(let e in s){let i=s[e];t+="<span>",i&&(t+="<div style='width: 10px; height: 10px; background-color:#"+i+"; border: 0px;display:inline-block;' ></div> "),t+=e,t+="</span><br>"}return t+="</div>",t}}class _t{constructor(e){this.icn3d=e}async showCddSiteAll(){let e=this.icn3d,t=e.icn3dui,s=this;e.chainid2pssmid={};let i=$.map(e.protein_chainid,(function(e){return e})),n=Object.keys(e.protein_chainid),l="https://www.ncbi.nlm.nih.gov/Structure/cdannots/cdannots.fcgi?fmt&frclive&live=lcl&queries="+i;if(1==Object.keys(e.structures).length&&!t.cfg.afid&&(t.cfg.mmtfid||t.cfg.pdbid||t.cfg.opmid||t.cfg.mmdbid||t.cfg.gi||t.cfg.uniprotid||t.cfg.blast_rep_id||t.cfg.cid||t.cfg.mmcifid)||2==Object.keys(e.structures).length&&t.cfg.align){let e={};try{t.bNode?e=await t.getAjaxPromise(l,"jsonp"):e.value=await t.getAjaxPromise(l,"jsonp"),s.parseCddData([e],n)}catch(e){return void s.getNoCdd(i)}}else{let i=[];for(let s=0,r=n.length;s<r;++s){let r=Array.isArray(e.giSeq[n[s]])?e.giSeq[n[s]].join("").toUpperCase():e.giSeq[n[s]].toUpperCase();r=r.replace(/O/g,""),l="https://www.ncbi.nlm.nih.gov/Structure/cdannots/cdannots.fcgi?fmt&frclive&live=lcl&queries="+r;let o=t.getAjaxPromise(l,"jsonp");i.push(o)}let r=Promise.allSettled(i);try{let e=await r;s.parseCddData(e,n,!0)}catch(e){}}}parseCddData(e,t,s){let i=this.icn3d,n=i.icn3dui,l=this,r={};n.bNode&&(i.resid2cdd||(i.resid2cdd={}),i.resid2site||(i.resid2site={}),i.chainid2cdd||(i.chainid2cdd={}));for(let o=0,a=e.length;o<a;++o){let a=n.bNode?e[o]:e[o].value;if(a)for(let e=0,d=a.data.length;e<d;++e){let d=a.data[e];d._id;let c=s?t[o]:t[e];r[c]=1;let h='<div id="'+i.pre+c+'_cddseq_sequence" class="icn3d-cdd icn3d-dl_sequence">',p=h,m=h,u=d.doms;n.bNode&&!i.resid2cdd[c]&&(i.resid2cdd[c]=[]),n.bNode&&!i.chainid2cdd[c]&&(i.chainid2cdd[c]=[]);let g=l.setDomainFeature(u,c,"domain",h,p,m);i.chainid2pssmid[c]={pssmid2name:g.pssmid2name,pssmid2fromArray:g.pssmid2fromArray,pssmid2toArray:g.pssmid2toArray};let f=g.acc2domain;h=g.html+"</div>",p=g.html2+"</div>",m=g.html3+"</div>",$("#"+i.pre+"dt_cdd_"+c).html(h),$("#"+i.pre+"ov_cdd_"+c).html(p),$("#"+i.pre+"tt_cdd_"+c).html(m),h='<div id="'+i.pre+c+'_siteseq_sequence" class="icn3d-dl_sequence">',p=h,m=h;let C=d.motifs;n.bNode&&!i.resid2site[c]&&(i.resid2site[c]=[]),g=l.setDomainFeature(C,c,"feat",h,p,m,f),h=g.html,p=g.html2,m=g.html3;let b=a.data[e].sites,y=void 0!==b?b.length:0;for(let e=0;e<y;++e){b[e].srcdom,b[e].type;let t=b[e].sz,s="site: "+b[e].title;s.length>17&&(s=s.substr(0,17)+"...");let l,r=b[e].title,o=[];for(let t=0,s=b[e].locs.length;t<s;++t){l=b[e].locs[t].coords;for(let e=0,t=l.length;e<t;++e)o.push(i.ParserUtilsCls.getResi(c,Math.round(l[e])))}let a=!1;for(let e=0,t=o.length;e<t;++e){let t=c+"_"+o[e];if(i.residues.hasOwnProperty(t)){a=!0;break}}let d='<div class="icn3d-seqTitle '+(a?"icn3d-link icn3d-blue":"")+'" site="site" posarray="'+l.toString()+'" shorttitle="'+s+'" setname="'+c+"_site_"+e+'" anno="sequence" chain="'+c+'" title="'+r+'">'+s+" </div>",u='<span class="icn3d-residueNum" title="residue count">'+t.toString()+" Res</span>",g='<span class="icn3d-seqLine">';m+=d+u+"<br>",h+=d+u+g,p+=d+u+g;let f="site"+e.toString(),C=0,y=0,v=1;i.seqStartLen&&i.seqStartLen[c]&&(p+=i.showSeqCls.insertMulGapOverview(c,i.seqStartLen[c])),i.seqStartLen&&i.seqStartLen[c]&&(h+=i.showSeqCls.insertMulGap(i.seqStartLen[c],"-"));for(let t=0,s=i.giSeq[c].length;t<s;++t)if(h+=i.showSeqCls.insertGap(c,t,"-"),-1!=l.indexOf(t)){let s=i.giSeq[c][t],l=s;s.length>1&&(l=s[0]+"..");let r=i.ParserUtilsCls.getResi(c,t);if(h+='<span id="'+f+"_"+i.pre+c+"_"+r+'" title="'+l+r+'" class="icn3d-residue">'+s+"</span>",n.bNode){let t={};t[c+"_"+r]="site: "+b[e].title,i.resid2site[c].push(t)}p+=i.showSeqCls.insertGapOverview(c,t);let o=n.cfg.blast_rep_id==c?Math.round(i.seqAnnWidth*t/(i.maxAnnoLength+i.nTotalGap)-C-y):Math.round(i.seqAnnWidth*t/i.maxAnnoLength-C-y);o>=0&&(p+='<div style="display:inline-block; width:'+o+'px;">&nbsp;</div>',p+='<div style="display:inline-block; background-color:#000; width:'+v+'px;" title="'+l+r+'">&nbsp;</div>',C+=o,y+=v)}else h+="<span>-</span>";i.seqStartLen&&i.seqStartLen[c]&&(h+=i.showSeqCls.insertMulGap(i.seqEndLen[c],"-")),g='<span class="icn3d-residueNum" title="residue count">&nbsp;'+t.toString()+" Residues</span>",g+="</span>",g+="<br>",h+=g,p+=g}h+="</div>",p+="</div>",m+="</div>",$("#"+i.pre+"dt_site_"+c).html(h),$("#"+i.pre+"ov_site_"+c).html(p),$("#"+i.pre+"tt_site_"+c).html(m)}}for(let e in i.protein_chainid)r.hasOwnProperty(e)||($("#"+i.pre+"dt_cdd_"+e).html(""),$("#"+i.pre+"ov_cdd_"+e).html(""),$("#"+i.pre+"tt_cdd_"+e).html(""),$("#"+i.pre+"dt_site_"+e).html(""),$("#"+i.pre+"ov_site_"+e).html(""),$("#"+i.pre+"tt_site_"+e).html(""));i.showAnnoCls.enableHlSeq(),i.bAjaxCddSite=!0}getNoCdd(e){let t=this.icn3d;t.icn3dui,console.log("No CDD data were found for the protein "+e+"...");for(let e in t.protein_chainid)$("#"+t.pre+"dt_cdd_"+e).html(""),$("#"+t.pre+"ov_cdd_"+e).html(""),$("#"+t.pre+"tt_cdd_"+e).html(""),$("#"+t.pre+"dt_site_"+e).html(""),$("#"+t.pre+"ov_site_"+e).html(""),$("#"+t.pre+"tt_site_"+e).html("");t.showAnnoCls.enableHlSeq(),t.bAjaxCddSite=!0}getResiArrayStr(e,t){let s=this.icn3d;s.icn3dui;let i="";for(let n=0,l=e.length;n<l;++n){let l=t+"_"+(e[n]+1),r=s.ncbi2resid[l];r||(r=l),n>0&&(i+=","),i+=r.split("_")[2]}return i}setDomainFeature(e,t,s,i,n,l,r,o,a){let d,c,h,p=this.icn3d,m=p.icn3dui,u="domain"!=s&&"feat"!=s;"domain"==s&&(r={},d={},c={},h={}),void 0===e&&(e=[]);let g=e.length,f="domain"==s?14:19,C="domain"==s?100:120;e.sort((function(e,t){let i=e.locs,n="domain"==s||"ig"==s?i[0].segs:[i[0]],l=Math.round(n[0].from);return i=t.locs,n="domain"==s||"ig"==s?i[0].segs:[i[0]],l-Math.round(n[0].from)}));for(let b=0;b<g;++b){let g="domain"==s?e[b].pssmid:0,y="domain"==s?e[b].acc:"feat"==s?e[b].srcdom:"",v="domain"==s?e[b].title.split(":")[0]:"feat"==s?e[b].title:o[b];v=v.replace(/\"/g,"``"),v=v.replace(/'/g,"`"),"domain"==s&&(r[y]=v);let _="domain"==s?e[b].defline:"",w=u?o[b]:s+": "+v;w.length>f&&(w=w.substr(0,f)+"...");let S=u?a[b]:s+": "+v;"domain"==s&&(d[g]=v);let A=e[b].locs;if(A)for(let e=0,r=A.length;e<r;++e){let r=[],a=[],d={},u=0,f="domain"==s||"ig"==s?A[e].segs:[A[e]];for(let e=0,t=f.length;e<t;++e){let t=Math.round(f[e].from),s=Math.round(f[e].to);r.push(t),a.push(s);for(let e=t;e<=s;++e)d[e]=1;u+=s-t+1}let x=t+"_"+v;"domain"!=s&&(x=t+"_"+b+"_"+e+"_"+v),x=x.replace(/\s+/g,""),"domain"==s&&(c[g]=r),"domain"==s&&(h[g]=a);let k=!1;for(let e=0,s=r.length;e<s;++e){let s=parseInt(r[e]),i=parseInt(a[e]);for(let e=s;e<=i;++e){let s=t+"_"+p.ParserUtilsCls.getResi(t,e);if(p.residues.hasOwnProperty(s)){k=!0;break}}if(k)break}let O=k?"icn3d-link icn3d-blue":"",R='<div class="icn3d-seqTitle '+O+'" '+s+'="'+y+'" from="'+r+'" to="'+a+'" shorttitle="'+w+'" setname="'+x+'" anno="sequence" chain="'+t+'" title="'+S+'">'+w+" </div>",I='<span class="icn3d-residueNum" title="residue count">'+u.toString()+" Res</span>";l+=R+I+"<br>";let E='<span class="icn3d-seqLine">';i+=R+I+E,"domain"==s&&(n+='<div style="width:20px; display:inline-block;"><span id="'+p.pre+t+"_"+y+"_"+e+'_cddseq_expand" class="ui-icon ui-icon-plus icn3d-expand icn3d-link" style="width:15px;" title="Expand"></span><span id="'+p.pre+t+"_"+y+"_"+e+'_cddseq_shrink" class="ui-icon ui-icon-minus icn3d-shrink icn3d-link" style="display:none; width:15px;" title="Shrink"></span></div>'),n+='<div style="width:'+C+'px!important;" class="icn3d-seqTitle '+O+'" '+s+'="'+y+'" from="'+r+'" to="'+a+'" shorttitle="'+w+'" index="'+b+'" setname="'+x+'" anno="sequence" chain="'+t+'" title="'+S+'">'+w+" </div>",n+=I+E;let T=s+b.toString();if(p.seqStartLen&&p.seqStartLen[t]&&(i+=p.showSeqCls.insertMulGap(p.seqStartLen[t],"-")),m.bNode&&"domain"==s){let e=this.getResiArrayStr(r,t),s=this.getResiArrayStr(a,t);p.chainid2cdd[t].push(S+"_from_"+e+"_to_"+s)}for(let e=0,n=p.giSeq[t].length;e<n;++e)if(i+=p.showSeqCls.insertGap(t,e,"-"),d.hasOwnProperty(e)){let n=p.giSeq[t][e],l=n;n.length>1&&(l=n[0]+"..");let r=p.ParserUtilsCls.getResi(t,e);if(i+='<span id="'+T+"_"+p.pre+t+"_"+r+'" title="'+l+r+'" class="icn3d-residue">'+n+"</span>",m.bNode){let e={};e[t+"_"+r]=S,"domain"==s?p.resid2cdd[t].push(e):p.resid2site[t].push(e)}}else i+="<span>-</span>";if(p.seqStartLen&&p.seqStartLen[t]&&(i+=p.showSeqCls.insertMulGap(p.seqEndLen[t],"-")),p.seqStartLen&&p.seqStartLen[t]&&(n+=p.showSeqCls.insertMulGapOverview(t,p.seqStartLen[t])),m.cfg.blast_rep_id!=t){let i;for(let l=0,d=r.length;l<d;++l){let d;0==l&&(i=this.getColorFromPos(t,r[l],o)),d=0==l?Math.round(p.seqAnnWidth*r[l]/p.maxAnnoLength):Math.round(p.seqAnnWidth*(r[l]-a[l-1]-1)/p.maxAnnoLength),n+='<div style="display:inline-block; width:'+d+'px;">&nbsp;</div>',n+='<div style="display:inline-block; color:white!important; font-weight:bold; background-color:#'+i+"; width:"+Math.round(p.seqAnnWidth*(a[l]-r[l]+1)/p.maxAnnoLength)+'px;" class="icn3d-seqTitle '+O+'" '+s+'="'+(b+1).toString()+'" from="'+r+'" to="'+a+'" shorttitle="'+w+'" index="'+b+'" setname="'+x+'" id="'+t+"_domain_"+b+"_"+e+'" anno="sequence" chain="'+t+'" title="'+S+'">'+v+" </div>"}}else{let i=[],l=[];for(let e=0,t=r.length;e<t;++e){i.push(r[e]);for(let t=parseInt(r[e]);t<=parseInt(a[e]);++t)void 0!==p.targetGapHash&&p.targetGapHash.hasOwnProperty(t)&&(l.push(t-1),i.push(t));l.push(a[e])}for(let r=0,a=i.length;r<a;++r){let a=this.getColorFromPos(t,i[r],o);n+=p.showSeqCls.insertGapOverview(t,i[r]),n+='<div style="display:inline-block; width:'+(0==r?Math.round(p.seqAnnWidth*(i[r]-p.baseResi[t]-1)/(p.maxAnnoLength+p.nTotalGap)):Math.round(p.seqAnnWidth*(i[r]-l[r-1]-1)/(p.maxAnnoLength+p.nTotalGap)))+'px;">&nbsp;</div>',n+='<div style="display:inline-block; color:white!important; font-weight:bold; background-color:#'+a+"; width:"+Math.round(p.seqAnnWidth*(l[r]-i[r]+1)/(p.maxAnnoLength+p.nTotalGap))+'px;" class="icn3d-seqTitle '+O+'" '+s+'="'+(b+1).toString()+'" from="'+i+'" to="'+l+'" shorttitle="'+w+'" index="'+b+'" setname="'+x+'" id="'+t+"_domain_"+b+"_"+e+'" anno="sequence" chain="'+t+'" title="'+S+'">'+v+" </div>"}}E='<span class="icn3d-residueNum" title="residue count">&nbsp;'+u.toString()+" Residues</span>",E+="</span>",E+="<br>",i+=E,n+=E,"domain"==s&&(n+='<div id="'+p.pre+t+"_"+y+"_"+e+'_cddseq" style="display:none; white-space:normal;" class="icn3d-box">'+_+'(<a href="'+m.htmlCls.baseUrl+"cdd/cddsrv.cgi?uid="+y+'" target="_blank" class="icn3d-blue">open details view...</a>)</div>')}}return{html:i,html2:n,html3:l,acc2domain:r,pssmid2name:d,pssmid2fromArray:c,pssmid2toArray:h}}getColorFromPos(e,t,s){let i,n=this.icn3d;n.icn3dui;let l=e+"_"+n.ParserUtilsCls.getResi(e,t),r=n.firstAtomObjCls.getFirstAtomObj(n.residues[l]),o=r&&void 0!==r.color&&"FFFFFF"!==r.color.getHexString()?r.color.getHexString():"DDDDDD";return i=r&&void 0!==r.color?o:"CCCCCC",i}showAnnoType(e,t,s,i,n,l){let r=this.icn3d,o=r.icn3dui,a='<div id="'+r.pre+e+"_"+s+'seq_sequence" class="icn3d-dl_sequence">',d=a,c=a;if(0==n.length)return $("#"+r.pre+"dt_"+s+"_"+e).html(""),$("#"+r.pre+"ov_"+s+"_"+e).html(""),void $("#"+r.pre+"tt_"+s+"_"+e).html("");let h=i;i.length>17&&(i=i.substr(0,17)+"...");let p=[];for(let e=0,t=n.length;e<t;++e){let t=n[e].substr(n[e].lastIndexOf("_")+1);p.push(t)}let m=p.length,u=s,g='<div class="icn3d-seqTitle icn3d-link icn3d-blue" '+s+'="" posarray="'+p.toString()+'" shorttitle="'+i+'" setname="'+e+"_"+u+'" anno="sequence" chain="'+e+'" title="'+h+'">'+i+" </div>",f='<span class="icn3d-residueNum" title="residue count">'+m.toString()+" Res</span>";c+=g+f+"<br>";let C='<span class="icn3d-seqLine">';a+=g+f+C,d+=g+f+C;let b=s,y=0,v=0;r.seqStartLen&&r.seqStartLen[e]&&(d+=r.showSeqCls.insertMulGapOverview(e,r.seqStartLen[e])),r.seqStartLen&&r.seqStartLen[e]&&(a+=r.showSeqCls.insertMulGap(r.seqStartLen[e],"-"));for(let t=0,i=r.giSeq[e].length;t<i;++t){a+=r.showSeqCls.insertGap(e,t,"-");let i=r.ParserUtilsCls.getResi(e,t);if(-1!=p.indexOf(i)){let n=r.giSeq[e][t],c=n;n.length>1&&(c=n[0]+"..");let h=i,p=e+"_"+i,m=n+i;if("ssbond"==s){m="Residue "+p+" has disulfide bond with";let t="";if(void 0!==l[p])for(let e=0,s=l[p].length;e<s;++e)t+=" residue "+l[p][e];if(m+=t,o.bNode){let s={};s[p]="disulfide bond with"+t,r.resid2ssbond[e].push(s)}}else if("crosslink"==s){m="Residue "+p+" has cross-linkage with";let t="";if(void 0!==l[p])for(let e=0,s=l[p].length;e<s;++e)t+=" residue "+l[p][e];if(m+=t,o.bNode){let s={};s[p]="cross-linkage with"+t,r.resid2crosslink[e].push(s)}}else{m="Residue "+p+" has connection with";let e="";if(l&&void 0!==l[p])for(let t=0,s=l[p].length;t<s;++t)e+=" residue "+l[p][t];m+=e}a+='<span id="'+b+"_"+r.pre+e+"_"+h+'" title="'+m+'" class="icn3d-residue">'+c+"</span>",d+=r.showSeqCls.insertGapOverview(e,t);let u=o.cfg.blast_rep_id==e?Math.round(r.seqAnnWidth*t/(r.maxAnnoLength+r.nTotalGap)-y-v):Math.round(r.seqAnnWidth*t/r.maxAnnoLength-y-v);u>=0&&(d+='<div style="display:inline-block; width:'+u+'px;">&nbsp;</div>',d+='<div style="display:inline-block; background-color:#000; width:1px;" title="'+m+'">&nbsp;</div>',y+=u,v+=1)}else a+="<span>-</span>"}r.seqStartLen&&r.seqStartLen[e]&&(a+=r.showSeqCls.insertMulGap(r.seqEndLen[e],"-")),C='<span class="icn3d-residueNum" title="residue count">&nbsp;'+m.toString()+" Residues</span>",C+="</span>",C+="<br>",a+=C,d+=C,a+="</div>",d+="</div>",c+="</div>",$("#"+r.pre+"dt_"+s+"_"+e).html(a),$("#"+r.pre+"ov_"+s+"_"+e).html(d),$("#"+r.pre+"tt_"+s+"_"+e).html(c)}setToolTip(){let e=this.icn3d;e.icn3dui,$("[id^="+e.pre+"snp]").add("[id^="+e.pre+"clinvar]").add("[id^="+e.pre+"ssbond]").add("[id^="+e.pre+"crosslink]").tooltip({content:function(){return $(this).prop("title")},show:null,close:function(e,t){t.tooltip.hover((function(){$(this).stop(!0).fadeTo(400,1)}),(function(){$(this).fadeOut("400",(function(){$(this).remove()}))}))}})}}class wt{constructor(e){this.icn3d=e}showInteraction(e,t){this.icn3d.icn3dui,this.showInteraction_base(e,t)}showInteraction_base(e,t){let s=this.icn3d,i=s.icn3dui;i.bNode&&(s.resid2contact||(s.resid2contact={}),s.resid2contact[e]||(s.resid2contact[e]=[])),void 0===s.chainname2residues&&(s.chainname2residues={});let n=Object.keys(s.chains),l=e,r=Math.round(l.indexOf("_"));if(s.firstAtomObjCls.getFirstCalphaAtomObj(s.chains[l]),void 0===s.chainname2residues[l]){s.chainname2residues[l]={};let t=n.length;if(t>100&&void 0===i.cfg.mmdbid&&void 0===i.cfg.gi&&void 0===i.cfg.blast_rep_id&&void 0===i.cfg.align&&void 0===i.cfg.chainalign)return $("#"+s.pre+"dt_interaction_"+e).html(""),void $("#"+s.pre+"ov_interaction_"+e).html("");for(let e=0;e<t;++e){let t=n[e];if(t===l)continue;if(t.substr(0,t.indexOf("_"))!==l.substr(0,l.indexOf("_")))continue;if(r=Math.round(l.indexOf("_")),r>4)continue;let o,a=s.firstAtomObjCls.getFirstCalphaAtomObj(s.chains[t]);s.chemicals.hasOwnProperty(a.serial)?o="chemical":s.nucleotides.hasOwnProperty(a.serial)?o="nucleotide":s.ions.hasOwnProperty(a.serial)?o="ion":s.proteins.hasOwnProperty(a.serial)?o="protein":s.water.hasOwnProperty(a.serial)&&(o="water");let d=s.contactCls.getAtomsWithinAtom(i.hashUtilsCls.hash2Atoms(s.chains[l],s.atoms),i.hashUtilsCls.hash2Atoms(s.chains[t],s.atoms),4);if(0==Object.keys(d).length)continue;let c={};for(let e in d){let t=s.atoms[e];c[t.structure+"_"+t.chain+"_"+t.resi]=1}let h=t.substr(t.indexOf("_")+1)+"("+o+")";s.chainname2residues[l][h]=Object.keys(c)}}let o='<div id="'+s.pre+e+'_interseq_sequence" class="icn3d-dl_sequence">',a=o,d=o,c=0;for(let t in s.chainname2residues[e]){let n=s.chainname2residues[e][t];if(!n)continue;let l="Interact ."+t;l.length>17&&(l=l.substr(0,17)+"...");let r="Interact ."+t,h=[];for(let e=0,t=n.length;e<t;++e){let t=n[e],i=t.substr(n[e].lastIndexOf("_")+1);if(s.residues[t]){let e=Object.keys(s.residues[t])[0];(s.proteins.hasOwnProperty(e)||s.nucleotides.hasOwnProperty(e))&&h.push(i)}}let p=h.length;if(0==p)continue;let m=t.replace(/\s/g,""),u='<div class="icn3d-seqTitle icn3d-link icn3d-blue" interaction="'+(c+1).toString()+'" posarray="'+h.toString()+'" shorttitle="'+l+'" setname="'+e+"_"+m+'" anno="sequence" chain="'+e+'" title="'+r+'">'+l+" </div>",g='<span class="icn3d-residueNum" title="residue count">'+p.toString()+" Res</span>";d+=u+g+"<br>";let f='<span class="icn3d-seqLine">';o+=u+g+f,a+=u+g+f;let C="inter"+c.toString(),b=0,y=0,v=1;s.seqStartLen&&s.seqStartLen[e]&&(a+=s.showSeqCls.insertMulGapOverview(e,s.seqStartLen[e])),s.seqStartLen&&s.seqStartLen[e]&&(o+=s.showSeqCls.insertMulGap(s.seqStartLen[e],"-"));for(let t=0,n=s.giSeq[e].length;t<n;++t){o+=s.showSeqCls.insertGap(e,t,"-");let n=s.ParserUtilsCls.getResi(e,t);if(-1!=h.indexOf(n)){let l=s.giSeq[e][t],d=l;l.length>1&&(d=l[0]+"..");let c=n;if(o+='<span id="'+C+"_"+s.pre+e+"_"+c+'" title="'+l+c+'" class="icn3d-residue">'+d+"</span>",i.bNode){let t={};t[e+"_"+c]=r,s.resid2contact[e].push(t)}a+=s.showSeqCls.insertGapOverview(e,t);let h=i.cfg.blast_rep_id==e?Math.round(s.seqAnnWidth*t/(s.maxAnnoLength+s.nTotalGap)-b-y):Math.round(s.seqAnnWidth*t/s.maxAnnoLength-b-y);h>=0&&(a+='<div style="display:inline-block; width:'+h+'px;">&nbsp;</div>',a+='<div style="display:inline-block; background-color:#000; width:'+v+'px;" title="'+d+c+'">&nbsp;</div>',b+=h,y+=v)}else o+="<span>-</span>"}s.seqStartLen&&s.seqStartLen[e]&&(o+=s.showSeqCls.insertMulGap(s.seqEndLen[e],"-")),f='<span class="icn3d-residueNum" title="residue count">&nbsp;'+p.toString()+" Residues</span>",f+="</span>",f+="<br>",o+=f,a+=f,++c}o+="</div>",a+="</div>",d+="</div>",$("#"+s.pre+"dt_interaction_"+e).html(o),$("#"+s.pre+"ov_interaction_"+e).html(a),$("#"+s.pre+"tt_interaction_"+e).html(d),i.utilsCls.isMobile()?(s.hlSeqCls.selectSequenceMobile(),s.hlSeqCls.selectChainMobile()):s.hlSeqCls.selectSequenceNonMobile()}}class St{constructor(e){this.icn3d=e}async showPTM(e,t,s,i,n){let l=this.icn3d,r=l.icn3dui,o=this,a=e.substr(0,e.indexOf("_")),d=e.substr(e.indexOf("_")+1);if("afmem"==s){let t={Transmembrane:[{begin:i,end:n}]};this.setAnnoPtmTransmem("transmem",t,e)}else if(a.length>5){let t,i="https://www.ebi.ac.uk/proteins/api/features/"+a;try{t=await r.getAjaxPromise(i,"json"),o.parsePTM(t,e,s)}catch{return void o.getNoPTM(e,s)}}else{let t,i=a.substr(0,4).toLowerCase(),n="https://www.ebi.ac.uk/pdbe/api/mappings/uniprot/"+i;try{t=await r.getAjaxPromise(n,"json");let a="";l.UPResi2ResiPosPerChain||(l.UPResi2ResiPosPerChain={}),l.UPResi2ResiPosPerChain[e]={};let c=t[i].UniProt,h=!1;for(let t in c){let s=c[t].mappings;for(let i=0,n=s.length;i<n;++i){let n=s[i];if(n.chain_id==d){let s=n.unp_start,i=n.unp_end,r=n.start.residue_number;n.end.residue_number-r!=i-s&&console.log("There might be some issues in the PDB to UniProt residue mapping.");for(let t=0;t<=i-s;++t)l.UPResi2ResiPosPerChain[e][t+s]=t+r-1;""!=a&&6==a.length||(a=t),h=!0}}}if(l.annoPtmData||(l.annoPtmData={}),""==a)o.getNoPTM(e,s);else if(l.annoPtmData.hasOwnProperty(a))o.parsePTM(l.annoPtmData[a],e,s);else{let t,i="https://www.ebi.ac.uk/proteins/api/features/"+a;try{t=await r.getAjaxPromise(i,"json"),l.annoPtmData[a]=t,o.parsePTM(t,e,s)}catch(t){return void o.getNoPTM(e,s)}}}catch(t){return void o.getNoPTM(e,s)}}}parsePTM(e,t,s){let i=this.icn3d;i.icn3dui.bNode&&("ptm"==s?(i.resid2ptm={},i.resid2ptm[t]=[]):(i.resid2transmem={},i.resid2transmem[t]=[]));let n={},l={};for(let t=0,i=e.features.length;t<i;++t){let i=e.features[t];if("ptm"==s&&"PTM"==i.category&&"DISULFID"!=i.type&&"CROSSLNK"!=i.type){let e="";e="CARBOHYD"==i.type?"Glycosylation":"LIPID"==i.type?"Lipidation, "+i.description:0==i.description.indexOf("Phospho")?"Phosphorylation":i.description?i.description:i.type,n[e]||(n[e]=[]),n[e].push(i)}else if("transmem"==s&&"TOPOLOGY"==i.category&&"TRANSMEM"==i.type){let e="Transmembrane";l[e]||(l[e]=[]),l[e].push(i)}}"ptm"==s?this.setAnnoPtmTransmem("ptm",n,t):this.setAnnoPtmTransmem("transmem",l,t),i.showAnnoCls.enableHlSeq(),i.bAjaxPTM=!0}setAnnoPtmTransmem(e,t,s){let i=this.icn3d,n=i.icn3dui,l=0,r="",o="",a="";r+='<div id="'+i.pre+s+"_"+e+'seq_sequence" class="icn3d-cdd icn3d-dl_sequence">',o+=r,a+=r,s.substr(0,s.indexOf("_"));for(let d in t){let c=t[d],h=[],p=!1;for(let e=0,t=c.length;e<t;++e){let t=parseInt(c[e].begin),n=parseInt(c[e].end);for(let e=t;e<=n;++e)stucture.length>5?h.push(e-1):i.UPResi2ResiPosPerChain&&i.UPResi2ResiPosPerChain[s][e]&&h.push(i.UPResi2ResiPosPerChain[s][e]),!p&&i.residues.hasOwnProperty(s+"_"+e)&&(p=!0)}if(0==h.length)continue;let m=h.length,u="ptm"==e?"PTM: "+d:"Transmembrane";u.length>17&&(u=u.substr(0,17)+"...");let g=d,f='<div class="icn3d-seqTitle '+(p?"icn3d-link icn3d-blue":"")+'" '+e+'="'+e+'" posarray="'+h.toString()+'" shorttitle="'+u+'" setname="'+s+"_"+e+"_"+l+'" anno="sequence" chain="'+s+'" title="'+g+'">'+u+" </div>",C='<span class="icn3d-residueNum" title="residue count">'+m.toString()+" Res</span>",b='<span class="icn3d-seqLine">';a+=f+C+"<br>",r+=f+C+b,o+=f+C+b;let y=e+l.toString(),v=0,_=0,w=1;i.seqStartLen&&i.seqStartLen[s]&&(o+=i.showSeqCls.insertMulGapOverview(s,i.seqStartLen[s])),i.seqStartLen&&i.seqStartLen[s]&&(r+=i.showSeqCls.insertMulGap(i.seqStartLen[s],"-"));for(let e=0,t=i.giSeq[s].length;e<t;++e)if(r+=i.showSeqCls.insertGap(s,e,"-"),-1!=h.indexOf(e)){let t=i.giSeq[s][e],l=t;t.length>1&&(l=t[0]+"..");let a=i.ParserUtilsCls.getResi(s,e);if(r+='<span id="'+y+"_"+i.pre+s+"_"+a+'" title="'+l+a+'" class="icn3d-residue">'+t+"</span>",n.bNode){let e={};e[s+"_"+a]=u,i.resid2ptm[s].push(e)}o+=i.showSeqCls.insertGapOverview(s,e);let d=n.cfg.blast_rep_id==s?Math.round(i.seqAnnWidth*e/(i.maxAnnoLength+i.nTotalGap)-v-_):Math.round(i.seqAnnWidth*e/i.maxAnnoLength-v-_);d>=0&&(o+='<div style="display:inline-block; width:'+d+'px;">&nbsp;</div>',o+='<div style="display:inline-block; background-color:#000; width:'+w+'px;" title="'+l+a+'">&nbsp;</div>',v+=d,_+=w)}else r+="<span>-</span>";i.seqStartLen&&i.seqStartLen[s]&&(r+=i.showSeqCls.insertMulGap(i.seqEndLen[s],"-")),b='<span class="icn3d-residueNum" title="residue count">&nbsp;'+m.toString()+" Residues</span>",b+="</span>",b+="<br>",r+=b,o+=b,++l}r+="</div>",o+="</div>",a+="</div>",$("#"+i.pre+"dt_"+e+"_"+s).html(r),$("#"+i.pre+"ov_"+e+"_"+s).html(o),$("#"+i.pre+"tt_"+e+"_"+s).html(a)}getNoPTM(e,t){let s=this.icn3d;s.icn3dui,console.log("No PTM data were found for the chain "+e+"...");let i="ptm"==t?"ptm":"transmem";$("#"+s.pre+"dt_"+i+"_"+e).html(""),$("#"+s.pre+"ov_"+i+"_"+e).html(""),$("#"+s.pre+"tt_"+i+"_"+e).html(""),s.showAnnoCls.enableHlSeq(),s.bAjaxPTM=!0}}class At{constructor(e){this.icn3d=e}async showIg(e,t){let s=this.icn3d;s.icn3dui,s.bRunRefnumAgain&&await s.refnumCls.showIgRefNum(t);let i="",n="",l="";if(s.bShowRefnum&&s.chainid2refpdbname.hasOwnProperty(e)&&s.chainid2refpdbname[e].length>0){let t=s.showSeqCls.getSeq(e),r=s.annoIgCls.showAllRefNum(t,e);i+=r.html,n+=r.html2,l+=r.html3}$("#"+s.pre+"dt_"+"ig_"+e).html(i),$("#"+s.pre+"ov_"+"ig_"+e).html(n),$("#"+s.pre+"tt_"+"ig_"+e).html(l)}showAllRefNum(e,t){let s=this.icn3d;s.icn3dui;let i="",n="",l="",r=!1;for(let i=0,n=e.length;i<n;++i){let e=t+"_"+s.ParserUtilsCls.getResi(t,i),n=s.resid2domainid[e];if(s.domainid2ig2kabat[n]&&Object.keys(s.domainid2ig2kabat[n]).length>0){r=!0;break}}let o=!1;for(let i=0,n=e.length;i<n;++i){let e=t+"_"+s.ParserUtilsCls.getResi(t,i),n=s.resid2domainid[e];if(s.domainid2ig2imgt[n]&&Object.keys(s.domainid2ig2imgt[n]).length>0){o=!0;break}}let a=this.showRefNum(e,t);i+=a.html,n+=a.html2,l+=a.html3;let d=1;return r&&(a=this.showRefNum(e,t,d),i+=a.html,n+=a.html2,l+=a.html3),d=2,o&&(a=this.showRefNum(e,t,d),i+=a.html,n+=a.html2,l+=a.html3),{html:i,html2:n,html3:l}}showRefNum(e,t,s,i){let n=this.icn3d;if(n.icn3dui,n.chainid2igtrack){if(!n.chainid2igtrack[t])return{html:"",html2:"",html3:""}}let l=this.getIgAnnoHtml(t,e,i,s);return n.bShowRefnum&&(n.opts.color="ig strand",n.setColorCls.setColorByOptions(n.opts,n.chains[t])),l}setChain2igArray(e,t,s){let i,n=this.icn3d;n.icn3dui;let l={};for(let r=0,o=t.length;r<o;++r){let t=e+"_"+n.ParserUtilsCls.getResi(e,r),o=s?0:n.resid2domainid[t];i=n.resid2refnum[t],i&&(l[o]||(l[o]=[]),l[o].push(r))}for(let t in l){let s,i,r=l[t],o=[],a=[];for(let e=0,t=r.length;e<t;++e)s=r[e],0==e&&o.push(s),e>0&&s!=i+1&&(a.push(i),o.push(s)),i=s;a.push(s);let d={};d.domainid=t,d.startPosArray=o,d.endPosArray=a,n.chain2igArray[e].push(d)}}getIgAnnoHtml(e,t,s,i){let n=this.icn3d,l=n.icn3dui,r="",o="",a="";n.chain2igArray||(n.chain2igArray={});let d,c,h,p=!1,m="";n.chain2igArray[e]=[],this.setChain2igArray(e,t,s);let u=n.chain2igArray[e];for(let t=0,s=u.length;t<s;++t){let s=u[t].domainid;if(!n.domainid2info)continue;if(!n.domainid2info[s])continue;let i=!1,l=!1,r=!1,o=!1,a={};for(let s=0,d=u[t].startPosArray.length;s<d;++s){let d=u[t].startPosArray[s],c=u[t].endPosArray[s];for(let t=d;t<=c;++t){const s=e+"_"+n.chainsSeq[e][t].resi;a[s]=1;let d=n.resid2refnum[s];d&&(-1!=d.indexOf("B2550")&&(i=!0),-1!=d.indexOf("C3550")&&(l=!0),-1!=d.indexOf("E7550")&&(r=!0),-1!=d.indexOf("F8550")&&(o=!0))}}if(!(i&&l&&r&&o)){for(let e in a)delete n.resid2refnum[e],delete n.residIgLoop[e],delete n.resid2domainid[e];let t=Object.keys(a),s=n.setSeqAlignCls.getPosFromResi(e,t[t.length-1].split("_")[2]);for(let t=s+1,i=n.chainsSeq[e].length;t<i;++t){let s=e+"_"+n.chainsSeq[e][t].resi;if(!n.residIgLoop.hasOwnProperty(s))break;delete n.resid2refnum[s],delete n.residIgLoop[s],delete n.resid2domainid[s]}n.setSeqAlignCls.getPosFromResi(e,t[0].split("_")[2]);for(let t=s-1;t>=0;--t){let s=e+"_"+n.chainsSeq[e][t].resi;if(!n.residIgLoop.hasOwnProperty(s))break;delete n.resid2refnum[s],delete n.residIgLoop[s],delete n.resid2domainid[s]}}}n.chain2igArray[e]=[],this.setChain2igArray(e,t,s);let g="";for(let l=0,r=t.length;l<r;++l){g+=n.showSeqCls.insertGap(e,l,"-");let t=e+"_"+n.ParserUtilsCls.getResi(e,l),r=s?0:n.resid2domainid[t];d=s?n.chainsMapping[e][t]:n.resid2refnum[t];let o=!1;if(d)if(c=n.refnumCls.rmStrandFromRefnumlabel(d),m=d.replace(new RegExp(c,"g"),""),c.substr(0,1),h=s?d:1==i?n.domainid2ig2kabat[r]?n.domainid2ig2kabat[r][c]:void 0:2==i?n.domainid2ig2imgt[r]?n.domainid2ig2imgt[r][c]:void 0:c,s)if(h){g+=parseInt(h)%2==0?'<span title="'+h+'">'+h+"</span>":'<span title="'+h+'">&nbsp;</span>'}else g+="<span></span>";else if(1==i||2==i)if(h){let e=parseInt(h).toString(),t='style="color:'+this.getRefnumColor(m,!0)+'"';g+=parseInt(e.substr(e.length-2,2))%2==0?"<span "+t+' title="'+h+'">'+h+"</span>":"<span "+t+' title="'+h+'">&nbsp;</span>'}else g+="<span></span>";else" "!=m?(p=n.residIgLoop[t],g+=this.getRefnumHtml(t,h,c,d,m,p,o)):g+="<span></span>";else g+="<span></span>"}if(l.bNode)return{html:r,html2:o,html3:a};let f="icn3d-link icn3d-blue",C="IgStRAnD Ref. No.",b=n.chain2igArray[e].length,y=[],v=[],_={};n.igLabel2Pos||(n.igLabel2Pos={}),n.igLabel2Pos[e]={};for(let t=0;t<b;++t){let s=n.chain2igArray[e][t];y=y.concat(s.startPosArray),v=v.concat(s.endPosArray);for(let e=0,i=s.startPosArray.length;e<i;++e){_[s.startPosArray[e]]=t}let i=e+"_"+n.ParserUtilsCls.getResi(e,s.startPosArray[0]),l=n.firstAtomObjCls.getFirstCalphaAtomObj(n.residues[i]),r=e+"_"+n.ParserUtilsCls.getResi(e,s.endPosArray[s.endPosArray.length-1]),o=n.firstAtomObjCls.getFirstCalphaAtomObj(n.residues[r]),a=e.substr(e.lastIndexOf("_")+1)+"-Ig"+(t+1).toString();n.igLabel2Pos[e][a]=l.coord.clone().add(o.coord).multiplyScalar(.5)}let w='<div style="display:inline-block" class="icn3d-residueNum" title="Ig domain count">'+b.toString()+" Ig(s)</div>",S='<div id="'+n.pre+e+'_igseq_sequence" class="icn3d-ig icn3d-dl_sequence">';s&&(S='<div class="icn3d-dl_sequence">');let A='<div style="width:120px!important;" class="icn3d-seqTitle '+f+'" ig="0" from="'+y+'" to="'+v+'" shorttitle="'+C+'" index="0" setname="'+e+'_Igs" anno="sequence" chain="'+e+'" title="IgStRAnD Reference Numbers">'+C+" </div>";if(S+='<div class="icn3d-residueLine" style="white-space:nowrap;">',s?(S+='<div class="icn3d-annoTitle" anno="0" title="Custom Reference Numbers">Custom Ref. No.</div>',S+='<span class="icn3d-residueNum"></span>'):1==i?(S+='<div class="icn3d-annoTitle" anno="0" title="Kabat Reference Numbers">Kabat Ref. No.</div>',S+='<span class="icn3d-residueNum"></span>'):2==i?(S+='<div class="icn3d-annoTitle" anno="0" title="IMGT Reference Numbers">IMGT Ref. No.</div>',S+='<span class="icn3d-residueNum"></span>'):(S+=A,S+=w),a+=S+"<br>",r+=S+'<span class="icn3d-seqLine">',n.seqStartLen&&n.seqStartLen[e]&&(r+=n.showSeqCls.insertMulGap(n.seqStartLen[e],"-")),r+=g,n.seqStartLen&&n.seqStartLen[e]&&(r+=n.showSeqCls.insertMulGap(n.seqEndLen[e],"-")),s||(r+=w),r+="</span>",r+="<br>",r+="</div>",r+="</div>",u=n.chain2igArray[e],0==u.length)return{html:r,html2:o,html3:a};let x=[],k=[],O=[],R=[],I=e.substr(e.lastIndexOf("_")+1);for(let e=0,t=u.length;e<t;++e){let t=u[e].domainid;if(!n.domainid2info)continue;let s=n.domainid2info[t];if(!s)continue;let i=s.score,l=parseFloat(i)<n.refnumCls.TMThresholdIgType?"Ig":n.ref2igtype[s.refpdbname];k.push(l+" (TM:"+parseFloat(i).toFixed(2)+")"),O.push(l+" (TM:"+parseFloat(i).toFixed(2)+"), template: "+s.refpdbname+", type: "+n.ref2igtype[s.refpdbname]+", Seq. identity: "+parseFloat(s.seqid).toFixed(2)+", aligned residues: "+s.nresAlign+", label in 3D: "+I+"-Ig"+(e+1).toString()),R.push(l);let r=[];for(let t=0,s=u[e].startPosArray.length;t<s;++t)r.push({from:u[e].startPosArray[t],to:u[e].endPosArray[t]});let o={};o.locs=[{segs:r}],x.push(o)}if(0==x.length)return{html:r,html2:o,html3:a};if(!i&&!s){let t,s;o+=A,o+=w+'<span class="icn3d-seqLine">',n.seqStartLen&&n.seqStartLen[e]&&(o+=n.showSeqCls.insertMulGapOverview(e,n.seqStartLen[e]));for(let i=0,l=y.length;i<l;++i){let l=e+"_"+n.ParserUtilsCls.getResi(e,y[i]),r=_[y[i]];if(r!=t){let e=n.firstAtomObjCls.getFirstAtomObj(n.residues[l]),t=e&&void 0!==e.color&&"FFFFFF"!==e.color.getHexString()?e.color.getHexString():"DDDDDD";s=e&&void 0!==e.color?t:"CCCCCC"}o+='<div style="display:inline-block; width:'+(0==i?Math.round(n.seqAnnWidth*y[i]/n.maxAnnoLength):Math.round(n.seqAnnWidth*(y[i]-v[i-1]-1)/n.maxAnnoLength))+'px;">&nbsp;</div>',o+='<div style="display:inline-block; color:white!important; font-weight:bold; background-color:#'+s+"; width:"+Math.round(n.seqAnnWidth*(v[i]-y[i]+1)/n.maxAnnoLength)+'px;" class="icn3d-seqTitle '+f+'" ig="0" from="'+y+'" to="'+v+'" shorttitle="'+R[r]+'" index="0" setname="'+e+'_igs" id="'+e+'_igs" anno="sequence" chain="'+e+'" title="'+R[r]+'">'+R[r]+" </div>",t=r}o+=w,o+="</div></div>",a+="</div></div>",S='<div id="'+n.pre+e+'_igseq_sequence" class="icn3d-ig icn3d-dl_sequence">';let i=S,l=S,d=n.annoCddSiteCls.setDomainFeature(x,e,"ig",S,i,l,void 0,k,O);r+=d.html+"</div>",o+=d.html2+"</div>",a+=d.html3+"</div>"}return{html:r,html2:o,html3:a}}getRefnumHtml(e,t,s,i,n,l,r){let o=this.icn3d,a=o.icn3dui,d=parseInt(t).toString(),c=(d-1e3*parseInt(d/1e3)).toString(),h=parseInt(d.toString().substr(0,2)),p="5"!=c.substr(0,1)&&"18"!=h,m=this.getRefnumColor(n,!0),u=l?'style="color:'+m+'"':'style="color:'+m+'; text-decoration: underline overline;"',g=d.substr(d.length-2,2),f=parseInt(g);parseInt(d.substr(d.length-3,3));let C="";return!i||50!=f||p||l?i&&f%2==0&&52!=f&&!r?(g=isNaN(t)?g+t.substr(t.length-1,1):g,C+="<span "+u+' title="'+i+'">'+g+"</span>"):C+="<span "+u+' title="'+i+'">&nbsp;</span>':(o.hAtomsRefnum=a.hashUtilsCls.unionHash(o.hAtomsRefnum,o.residues[e]),C+="<span "+u+' title="'+i+'"><b>'+i.substr(0,1)+"</b>"+i.substr(1)+"</span>"),C}getRefnumColor(e,t){let s=this.icn3d.icn3dui,i=e?e.substr(0,1):"";return"C"==e?"#0000FF":"C'"==e?"#6495ED":"C''"==e?"#006400":"A"==i?"#9400D3":"B"==i?"#ba55d3":"D"==i?"#00FF00":"E"==i?"#FFD700":"F"==i?"#FF8C00":"G"==i?"#FF0000":s.htmlCls.GREYB}getProtodomainColor(e){let t=this.icn3d.icn3dui,s=e?e.substr(0,1):"";return"A"==s||"D"==s?"#0000FF":"B"==s||"E"==s?"#006400":"C"==e||"F"==s?"#FFD700":"C'"==e||"G"==s?"#FF8C00":"C''"==e?"#FF0000":t.htmlCls.GREYB}}class xt{constructor(e){this.icn3d=e}showCrosslink(e,t){let s=this.icn3d;s.icn3dui;let i=this;void 0===s.clbondpnts?setTimeout((function(){i.showCrosslink_base(e,t)}),1e3):this.showCrosslink_base(e,t)}showCrosslink_base(e,t){let s=this.icn3d;s.icn3dui.bNode&&(s.resid2crosslink||(s.resid2crosslink={}),s.resid2crosslink[e]||(s.resid2crosslink[e]=[]));let i=t,n={},l=i.substr(0,i.indexOf("_")),r=s.clbondpnts[l];if(void 0===r)return $("#"+s.pre+"dt_crosslink_"+e).html(""),$("#"+s.pre+"ov_crosslink_"+e).html(""),void $("#"+s.pre+"tt_crosslink_"+e).html("");for(let e=0,t=r.length;e<t;e+=2){let t=r[e],s=r[e+1];t.substr(0,t.lastIndexOf("_")),i===s.substr(0,s.lastIndexOf("_"))&&(void 0===n[s]&&(n[s]=[]),n[s].push(t))}let o=Object.keys(n);s.annoCddSiteCls.showAnnoType(e,t,"crosslink","Cross-Linkages",o,n)}}class kt{constructor(e){this.icn3d=e}showDomainPerStructure(e,t){let s=this.icn3d;s.icn3dui;let i=this,n=Object.keys(s.structures)[e],l={domains:{}};for(let e in s.chains){if(n==e.substr(0,e.indexOf("_"))){l.domains[e]={},l.domains[e].domains=[];let t=s.chains[e],i=s.domain3dCls.c2b_NewSplitChain(t).subdomains;for(let t=0,s=i.length;t<s;++t){let s={intervals:[]};for(let e=0,n=i[t].length;e<n;e+=2)s.intervals.push([i[t][e],i[t][e+1]]);l.domains[e].domains.push(s)}}}s.mmdb_dataArray[e]=l;for(let l in s.chains)-1!==l.indexOf(n)&&i.showDomainWithData(l,s.mmdb_dataArray[e],t);s.bAjax3ddomain=!0,s.bAjaxDoneArray[e]=!0}showDomainAll(e){let t=this.icn3d;t.icn3dui;let s=Object.keys(t.structures);t.mmdb_dataArray=[],t.bAjaxDoneArray=[];for(let e=0,i=s.length;e<i;++e)t.bAjaxDoneArray[e]=!1;for(let t=0,i=s.length;t<i;++t)this.showDomainPerStructure(t,e)}getResiFromNnbiresid(e){let t=this.icn3d;t.icn3dui;let s=t.ncbi2resid[e]?t.ncbi2resid[e]:e;return s.substr(s.lastIndexOf("_")+1)}getNcbiresiFromResid(e){let t=this.icn3d;t.icn3dui;let s=t.resid2ncbi[e]?t.resid2ncbi[e]:e;return s.substr(s.lastIndexOf("_")+1)}showDomainWithData(e,t,s){let i,n,l=this.icn3d,r=l.icn3dui,o='<div id="'+l.pre+e+'_domainseq_sequence" class="icn3d-dl_sequence">',a=o,d=o,c=e.indexOf("_"),h=e.substr(c+1);h.length>1&&"1"==h.substr(h.length-1)&&(h=h.substr(0,h.length-1)),n=e,i=t.domains[e]?t.domains[e].domains:[];for(let t=0,c=i.length;t<c;++t){let c="3D domain "+(t+1).toString()+" of "+n,h=c.length>17?c.substr(0,17)+"...":c,p=i[t].intervals,m=[],u=[],g={},f=0;for(let t=0,s=p.length;t<s;++t){let s=parseInt(p[t][0]),i=parseInt(p[t][1]);m.push(s),u.push(i),f+=i-s+1;for(let t=s;t<=i;++t){g[this.getResiFromNnbiresid(e+"_"+t)]=1}}if(l.chainid2clashedResidpair)for(let t in l.chainid2clashedResidpair){let s=t.split("|"),i=l.chainid2clashedResidpair[t].split("|");for(let n=0,r=s.length;n<r;++n){if(s[n][0]+"_"+s[n][1]==e){let e=s[n][3];g.hasOwnProperty(e)&&(l.chainid2clashedResidpair[t]=0==n?f+"|"+i[1]:i[1]+"|"+f)}}}if(r.bNode){let s="3D domain "+(t+1).toString();l.resid2domain||(l.resid2domain={}),l.resid2domain[e]||(l.resid2domain[e]=[]);for(let t=0,i=m.length;t<i;++t){let i=m[t],n=u[t];for(let t=i;t<=n;++t){let i={};i[l.ncbi2resid[e+"_"+t]]=s,l.resid2domain[e].push(i)}}}if(s)continue;let C='<div class="icn3d-seqTitle icn3d-link icn3d-blue" 3ddomain="'+(t+1).toString()+'" from="'+m+'" to="'+u+'" shorttitle="'+h+'" index="'+t+'" setname="'+e+"_3d_domain_"+(t+1).toString()+'" anno="sequence" chain="'+e+'" title="'+c+'">'+h+" </div>",b='<span class="icn3d-residueNum" title="residue count">'+f.toString()+" Res</span>";d+=C+b+"<br>";let y='<span class="icn3d-seqLine">';o+=C+b+y,a+=C+b+y;let v="domain3d"+t.toString();l.seqStartLen&&l.seqStartLen[e]&&(o+=l.showSeqCls.insertMulGap(l.seqStartLen[e],"-"));for(let t=0,s=l.giSeq[e].length;t<s;++t){o+=l.showSeqCls.insertGap(e,t,"-");let s=l.ParserUtilsCls.getResi(e,t);if(g.hasOwnProperty(s)){let i=l.giSeq[e][t],n=i;i.length>1&&(n=i[0]+"..");let r=s;o+='<span id="'+v+"_"+l.pre+e+"_"+r+'" title="'+n+r+'" class="icn3d-residue">'+i+"</span>"}else o+="<span>-</span>"}l.seqStartLen&&l.seqStartLen[e]&&(o+=l.showSeqCls.insertMulGap(l.seqEndLen[e],"-"));let _=l.firstAtomObjCls.getFirstCalphaAtomObj(l.chains[e]),w=void 0===_.color||"FFFFFF"===_.color.getHexString()?"DDDDDD":_.color.getHexString(),S=void 0!==_.color?w:"CCCCCC";if(l.seqStartLen&&l.seqStartLen[e]&&(a+=l.showSeqCls.insertMulGapOverview(e,l.seqStartLen[e])),r.cfg.blast_rep_id!=e)for(let s=0,i=m.length;s<i;++s){a+='<div style="display:inline-block; width:'+(0==s?Math.round(l.seqAnnWidth*m[s]/l.maxAnnoLength):Math.round(l.seqAnnWidth*(m[s]-u[s-1]-1)/l.maxAnnoLength))+'px;">&nbsp;</div>',a+='<div style="display:inline-block; color:white!important; font-weight:bold; background-color:#'+S+"; width:"+Math.round(l.seqAnnWidth*(u[s]-m[s]+1)/l.maxAnnoLength)+'px;" class="icn3d-seqTitle icn3d-link icn3d-blue" 3ddomain="'+(t+1).toString()+'" from="'+m+'" to="'+u+'" shorttitle="'+h+'" index="'+t+'" setname="'+e+"_3d_domain_"+(t+1).toString()+'" id="'+e+"_3d_domain_"+t+'" anno="sequence" chain="'+e+'" title="'+c+'">3D domain '+(t+1).toString()+"</div>"}else{let s=[],i=[];for(let e=0,t=m.length;e<t;++e){s.push(m[e]);for(let t=parseInt(m[e]);t<=parseInt(u[e]);++t)void 0!==l.targetGapHash&&l.targetGapHash.hasOwnProperty(t)&&(i.push(t-1),s.push(t));i.push(u[e])}for(let n=0,r=s.length;n<r;++n){a+=l.showSeqCls.insertGapOverview(e,s[n]),a+='<div style="display:inline-block; width:'+(0==n?Math.round(l.seqAnnWidth*(s[n]-l.baseResi[e]-1)/(l.maxAnnoLength+l.nTotalGap)):Math.round(l.seqAnnWidth*(s[n]-i[n-1]-1)/(l.maxAnnoLength+l.nTotalGap)))+'px;">&nbsp;</div>',a+='<div style="display:inline-block; color:white!important; font-weight:bold; background-color:#'+S+"; width:"+Math.round(l.seqAnnWidth*(i[n]-s[n]+1)/(l.maxAnnoLength+l.nTotalGap))+'px;" class="icn3d-seqTitle icn3d-link icn3d-blue" 3ddomain="'+(t+1).toString()+'" from="'+s+'" to="'+i+'" shorttitle="'+h+'" index="'+t+'" setname="'+e+"_3d_domain_"+(t+1).toString()+'" id="'+e+"_3d_domain_"+t+'" anno="sequence" chain="'+e+'" title="'+c+'">3D domain '+(t+1).toString()+"</div>"}}y='<span class="icn3d-residueNum" title="residue count">&nbsp;'+f.toString()+" Residues</span>",y+="</span>",y+="<br>",o+=y,a+=y}if(s||(o+="</div>",a+="</div>",d+="</div>",$("#"+l.pre+"dt_domain_"+e).html(o),$("#"+l.pre+"ov_domain_"+e).html(a),$("#"+l.pre+"tt_domain_"+e).html(d)),s&&l.chainid2clashedResidpair){l.clashedResidHash={};for(let e in l.chainid2clashedResidpair){let t=e.split("|"),s=l.chainid2clashedResidpair[e].split("|");parseInt(s[0])<parseInt(s[1])?l.clashedResidHash[t[0]]=1:l.clashedResidHash[t[1]]=1}let e={},t={};for(let s in l.clashedResidHash){let i=s.lastIndexOf("_"),n=parseInt(s.substr(i+1)),o=s.substr(0,i);"coil"==l.firstAtomObjCls.getFirstAtomObj(l.residues[s]).ss?(t=this.getMoreResidues(n,o,1,"not coil"),e=r.hashUtilsCls.unionHash(e,t),t=this.getMoreResidues(n,o,-1,"not coil"),e=r.hashUtilsCls.unionHash(e,t)):(t=this.getMoreResidues(n,o,1,"ssbegin"),e=r.hashUtilsCls.unionHash(e,t),t=this.getMoreResidues(n,o,-1,"ssend"),e=r.hashUtilsCls.unionHash(e,t))}l.clashedResidHash=r.hashUtilsCls.unionHash(l.clashedResidHash,e)}}showHideClashedResidues(){let e=this.icn3d,t=e.icn3dui;if(e.clashedResidHash&&Object.keys(e.clashedResidHash).length>0){let s={};for(let i in e.clashedResidHash)s=t.hashUtilsCls.unionHash(s,e.residues[i]);e.bHideClashed?e.hAtoms=t.hashUtilsCls.exclHash(e.hAtoms,s):e.hAtoms=t.hashUtilsCls.unionHash(e.hAtoms,s),e.dAtoms=t.hashUtilsCls.cloneHash(e.hAtoms)}}getMoreResidues(e,t,s,i){let n=this.icn3d;n.icn3dui;let l={};for(let r=1;r<100;++r){let o=t+"_"+(e+s*r).toString(),a=n.firstAtomObjCls.getFirstAtomObj(n.residues[o]);if(a){let e=!1;if("not coil"==i?e="coil"!=a.ss:"ssbegin"==i?e=a.ssbegin:"ssend"==i&&(e=a.ssend),e)break;l[o]=1}}return l}}class Ot{constructor(e){this.icn3d=e}async showSnp(e,t){this.icn3d.icn3dui,await this.showSnpClinvar(e,t,!0)}async showClinvar(e,t){this.icn3d.icn3dui,await this.showSnpClinvar(e,t,!1)}async showSnpClinvar(e,t,s){let i=this.icn3d.icn3dui,n=this,l=i.htmlCls.baseUrl+"vastdyn/vastdyn.cgi?chainid="+t;try{let r=await i.getAjaxPromise(l,"jsonp"),o=r.snpgi,a=r.gi;if(s)await n.showSnpPart2(e,t,o);else{let s=o;[6137708,1942289,224510717,2624886,253723219,2554905,75765331,3660278,312207882,319443632,342350956,1827805,109157826,1065265,40889086,6730307,163931185,494469,163931091,60594093,55669745,18655489,17942684,6980537,166235465,6435586,4139398,4389047,364506122,78101667,262118402,20664221,2624640,158430173,494395,28948777,34810587,13399647,3660342,261278854,342350965,384482350,378792570,15988303,213424334,4558333,2098365,10835631,3318817,374074330,332639529,122919696,4389286,319443573,2781341,67464020,194709238,210061039,364506106,28949044,40889076,161172338,17943181,4557976,62738484,365813173,6137343,350610552,17942703,576308,223674070,15826518,1310997,93279697,4139395,255311799,157837067,361132363,357380836,146387678,383280379,1127268,299856826,13786789,1311054,46015217,3402130,381353319,30750059,218766885,340707375,27065817,355333104,2624634,62738384,241913553,304446010].includes(a)&&(s=a),await n.showClinvarPart2(e,t,s)}}catch(t){return void(s?n.processNoSnp(e):n.processNoClinvar(e))}}navClinVar(e){let t=this.icn3d;t.icn3dui;let s=this;t.currClin[e]=-1,$(document).on("click","#"+t.pre+e+"_prevclin",(function(t){let i=s.icn3d;t.stopImmediatePropagation();let n=void 0!==i.resi2disease_nonempty[e]?Object.keys(i.resi2disease_nonempty[e]).length:0;--i.currClin[e],i.currClin[e]<0&&(i.currClin[e]=n-1),s.showClinVarLabelOn3D(e)})),$(document).on("click","#"+t.pre+e+"_nextclin",(function(t){let i=s.icn3d;t.stopImmediatePropagation();let n=void 0!==i.resi2disease_nonempty[e]?Object.keys(i.resi2disease_nonempty[e]).length:0;++i.currClin[e],i.currClin[e]>n-1&&(i.currClin[e]=0),s.showClinVarLabelOn3D(e)}))}showClinVarLabelOn3D(e){let t,s,i=this.icn3d,n=i.icn3dui,l=Object.keys(i.resi2disease_nonempty[e]);t=e,s=t+"_"+(parseInt(l[i.currClin[e]])+i.baseResi[e]).toString();let r="",o=i.resi2disease_nonempty[e][l[i.currClin[e]]];for(let e=0,t=o.length;e<t;++e)if(""!=o[e]&&"not specified"!=o[e]&&"not provided"!=o[e]){r=o[e];break}""==r&&(r=o.length>0?o[0]:"N/A");let a=i.applyCenterCls.centerAtoms(n.hashUtilsCls.hash2Atoms(i.residues[s],i.atoms));r.length>30&&(r=r.substr(0,30)+"..."),i.selectionCls.removeSelection(),null==i.labels&&(i.labels={}),i.labels.clinvar=[];let d=i.LABELSIZE,c="black"!=i.opts.background?i.colorWhitebkgd:i.colorBlackbkgd;i.analysisCls.addLabel(r,a.center.x+1,a.center.y+1,a.center.z+1,d,c,void 0,"clinvar"),i.hAtoms={};for(let e in i.residues[s])i.hAtoms[e]=1;$("#clinvar_"+i.pre+s).addClass("icn3d-highlightSeq"),void 0===$("#"+i.pre+"modeswitch")[0]||$("#"+i.pre+"modeswitch")[0].checked||i.definedSetsCls.setMode("selection"),i.drawCls.draw()}getSnpLine(e,t,s,i,n,l,r,o,a,d,c,h,p,m,u,g){let f=this.icn3d,C=f.icn3dui,b="",y=m?"clinvar":"snp",v=!1;for(let e in i){for(let t=0,s=i[e].length;t<s;++t)if(0==i[e][t]){v=!0;break}if(v)break}if(c){let e="ClinVar",t="SNP",s="",i="";v||void 0===f.organism||"human"===f.organism.toLowerCase()||"homo sapiens"===f.organism.toLowerCase()||(s=" <span style='color:#FFA500'>(from human)</span>",i=" <span style='color:#FFA500'>(based on human sequences and mapped to this structure by sequence similarity)</span>"),b+=m?'<div class="icn3d-seqTitle icn3d-link icn3d-blue icn3d-clinvar-path" clinvar="clinvar" posarray="'+d+'" shorttitle="'+e+'" setname="'+h+"_"+e+'" anno="sequence" chain="'+h+'" title="'+e+i+'">'+e+s+"</div>":'<div class="icn3d-seqTitle icn3d-link icn3d-blue" clinvar="clinvar" posarray="'+a+'" shorttitle="'+t+'" setname="'+h+"_"+t+'" anno="sequence" chain="'+h+'" title="'+t+i+'">'+t+s+"</div>"}else if(2==e&&m){let e=C.utilsCls.isMobile()?"none":"button";b+='<div id="'+f.pre+h+'_prevclin" style="display:inline-block; font-size:11px; font-weight:bold; width:60px!important;"><button class="link" style="-webkit-appearance:'+e+'; height:18px; width:55px;"><span style="white-space:nowrap; margin-left:-40px;" title="Show the previous ClinVar on structure">&lt; ClinVar</span></button></div>',b+='<div id="'+f.pre+h+'_nextclin" style="display:inline-block; font-size:11px; font-weight:bold; width:60px!important;"><button class="link" style="-webkit-appearance:'+e+'; height:18px; width:55px;"><span style="white-space:nowrap; margin-left:-40px;" title="Show the next ClinVar on structure">ClinVar &gt;</span></button></div>'}else b+='<div class="icn3d-seqTitle"></div>';let _=y,w=0,S=0,A={},x=f.firstAtomObjCls.getResiduesFromAtoms(f.chains[h]);for(let t in x){let i=t.split("_")[2];if(void 0!==r[i]){++w;let t="";for(let n=0,r=s[i].length;n<r&&!g;++n){let s=l[i][n].split("; "),r=o[i][n].split("; "),a="";for(let e=0,t=s.length;e<t;++e)a+=s[e],""!=r[e]&&(a+="("+r[e]+")"),a+="; ";""!=a&&(A[i]="icn3d-clinvar",n==e-2&&a.indexOf("Pathogenic")),t+=a+" | "}-1!=t.indexOf("Pathogenic")&&(A[i]="icn3d-clinvar-path"),"icn3d-clinvar"!=A[i]&&"icn3d-clinvar-path"!=A[i]||++S}}if(0==w&&!m)return $("#"+f.pre+"dt_clinvar_"+h).html(""),$("#"+f.pre+"ov_clinvar_"+h).html(""),$("#"+f.pre+"tt_clinvar_"+h).html(""),$("#"+f.pre+"dt_snp_"+h).html(""),$("#"+f.pre+"ov_snp_"+h).html(""),$("#"+f.pre+"tt_snp_"+h).html(""),"";if(0==S&&m)return $("#"+f.pre+"dt_clinvar_"+h).html(""),$("#"+f.pre+"ov_clinvar_"+h).html(""),$("#"+f.pre+"tt_clinvar_"+h).html(""),"";let k=m?S:w;if(b+=1==e?'<span class="icn3d-residueNum" title="residue count">'+k+" Res</span>":'<span class="icn3d-residueNum"></span>',u)return b+"<br>";b+='<span class="icn3d-seqLine">';let O="",R=0,I=0;p?f.seqStartLen&&f.seqStartLen[h]&&(b+=f.showSeqCls.insertMulGapOverview(h,f.seqStartLen[h])):f.seqStartLen&&f.seqStartLen[h]&&(b+=f.showSeqCls.insertMulGap(f.seqStartLen[h],"-"));for(let t=1,a=f.giSeq[h].length;t<=a;++t){let a=f.ParserUtilsCls.getResi(h,t-1),d=a;if(p){if(void 0!==r[d]){let e=f.giSeq[h][t-1],i=e;e.length>1&&(i=e[0]+"..");let n=a+i+">";for(let e=0,t=s[d].length;e<t;++e)if(n+=s[d][e],!g){let t=l[d][e].split("; "),s=o[d][e].split("; "),i="";for(let e=0,n=t.length;e<n;++e)i+=t[e],""!=s[e]&&(i+="("+s[e]+")"),i+="; "}b+=f.showSeqCls.insertGapOverview(h,t-1);let r=Math.round(f.seqAnnWidth*(t-1)/(f.maxAnnoLength+f.nTotalGap)-R-I);m?r>=0&&(b+='<div style="display:inline-block; width:'+r+'px;">&nbsp;</div>',b+='<div style="display:inline-block; background-color:#000; width:1px;" title="'+n+'">&nbsp;</div>',R+=r,I+=1):r>0&&(b+='<div style="display:inline-block; width:'+r+'px;">&nbsp;</div>',b+='<div style="display:inline-block; background-color:#000; width:1px;" title="'+n+'">&nbsp;</div>',R+=r,I+=1)}}else if(b+=f.showSeqCls.insertGap(h,t-1,"-"),void 0!==r[d])if(m||1!=e){let r=f.giSeq[h][t-1],c=r;r.length>1&&(c=r[0]+"..");let p,u="",y="<div class='snptip'>",v=s[d].length,w=0,S=0;if(2==e&&(w=0,S=v),m){p=1;let t=0;for(let e=w;e<v&&e<S;++e){let r=h+"_"+a+"_"+s[d][e],m=C.utilsCls.isMobile()?"none":"button",g=!0;f.residues.hasOwnProperty(h+"_"+a)||(g=!1);let b=l[d][e].split("; "),_=o[d][e].split("; "),w="",S=0;for(let t=0,s=b.length;t<s;++t)S>0?w+="; ":0!==e&&1!==e||(O='disease="'+b[t]+'"'),w+=b[t],""!=_[t]&&(w+="("+_[t]+")"),++S;t<p&&(u+=s[d][e]),y+=a+c+">"+s[d][e],y+=": "+w,g&&!C.cfg.hidelicense&&(y+="<br>"+f.showAnnoCls.addSnpButton(r,"snpin3d","3D with scap","SNP in 3D with scap",70,m)+"&nbsp;&nbsp;",y+=f.showAnnoCls.addSnpButton(r,"snpinter","Interactions","SNP Interactions in 3D",70,m)+"&nbsp;&nbsp;",y+=f.showAnnoCls.addSnpButton(r,"snppdb","PDB","Download SNP PDB",35,m)),y+="<br>Links: <a href='https://www.ncbi.nlm.nih.gov/clinvar/?term="+n[d][e]+"[AlleleID]' style='color:blue' target='_blank'>ClinVar</a>",0!=i[d][e]&&(y+=", <a href='https://www.ncbi.nlm.nih.gov/snp/?term="+i[d][e]+"' style='color:blue' target='_blank'>dbSNP(rs"+i[d][e]+")</a>"),e<v-1&&(y+="<br><br>"),++t}t>p&&2==e&&(u+="..")}else{p=1;for(let e=w;e<v&&e<S;++e){let t=h+"_"+a+"_"+s[d][e],r=C.utilsCls.isMobile()?"none":"button",m=!0;if(f.residues.hasOwnProperty(h+"_"+a)||(m=!1),e<p&&(u+=s[d][e]),y+=a+c+">"+s[d][e],g)m&&!C.cfg.hidelicense&&(y+="<br>"+f.showAnnoCls.addSnpButton(t,"snpin3d","3D with scap","SNP in 3D with scap",70,r)+"&nbsp;&nbsp;",y+=f.showAnnoCls.addSnpButton(t,"snpinter","Interactions","SNP Interactions in 3D",70,r)+"&nbsp;&nbsp;",y+=f.showAnnoCls.addSnpButton(t,"snppdb","PDB","Download SNP PDB",35,r)),0!=i[d][e]&&(y+="<br>Link: <a href='https://www.ncbi.nlm.nih.gov/snp/?term="+i[d][e]+"' target='_blank'>dbSNP(rs"+i[d][e]+")</a>"),e<v-1&&(y+="<br><br>");else{let s=l[d][e].split("; "),a=o[d][e].split("; "),c="",h=0;for(let t=0,i=s.length;t<i;++t)h>0?c+="; ":0!==e&&1!==e||(O='disease="'+s[t]+'"'),c+=s[t],""!=a[t]&&(c+="("+a[t]+")"),++h;""!=c?(y+=": "+c,m&&!C.cfg.hidelicense&&(y+="<br>"+f.showAnnoCls.addSnpButton(t,"snpin3d","3D with scap","SNP in 3D with scap",70,r)+"&nbsp;&nbsp;",y+=f.showAnnoCls.addSnpButton(t,"snpinter","Interactions","SNP Interactions in 3D",70,r)+"&nbsp;&nbsp;",y+=f.showAnnoCls.addSnpButton(t,"snppdb","PDB","Download SNP PDB",35,r)),y+="<br>Links: <a href='https://www.ncbi.nlm.nih.gov/clinvar/?term="+n[d][e]+"[AlleleID]' style='color:blue' target='_blank'>ClinVar</a>, <a href='https://www.ncbi.nlm.nih.gov/snp/?term="+i[d][e]+"' style='color:blue' target='_blank'>dbSNP(rs"+i[d][e]+")</a>"):(m&&!C.cfg.hidelicense&&(y+="<br>"+f.showAnnoCls.addSnpButton(t,"snpin3d","3D with scap","SNP in 3D with scap",70,r)+"&nbsp;&nbsp;",y+=f.showAnnoCls.addSnpButton(t,"snpinter","Interactions","SNP Interactions in 3D",70,r)+"&nbsp;&nbsp;",y+=f.showAnnoCls.addSnpButton(t,"snppdb","PDB","Download SNP PDB",35,r)),y+="<br>Link: <a href='https://www.ncbi.nlm.nih.gov/snp/?term="+i[d][e]+"' target='_blank'>dbSNP(rs"+i[d][e]+")</a>"),e<v-1&&(y+="<br><br>")}}v>p&&2==e&&(u+="..")}y+="</div>",b+=m?1==e?"<span>&dArr;</span>":""==u||" "==u?"<span>-</span>":'<span id="'+_+"_"+f.pre+h+"_"+a+'" label title="'+y+'" '+O+' class="icn3d-tooltip icn3d-residue '+A[d]+'">'+u+"</span>":""==u||" "==u?"<span>-</span>":g?'<span id="'+_+"_"+f.pre+h+"_"+a+'" label title="'+y+'" class="icn3d-tooltip icn3d-residue '+A[d]+'">'+u+"</span>":'<span id="'+_+"_"+f.pre+h+"_"+a+'" label title="'+y+'" '+O+' class="icn3d-tooltip icn3d-residue '+A[d]+'">'+u+"</span>"}else b+="<span>&dArr;</span>";else b+="<span>-</span>"}return p||f.seqStartLen&&f.seqStartLen[h]&&(b+=f.showSeqCls.insertMulGap(f.seqEndLen[h],"-")),b+=1==e?'<span class="icn3d-residueNum" title="residue count">&nbsp;'+k+" Residues</span>":'<span class="icn3d-residueNum"></span>',b+="</span>",b+="<br>",b}processSnpClinvar(e,t,s,i,n){let l=this.icn3d,r=l.icn3dui,o='<div id="'+l.pre+t+'_snpseq_sequence" class="icn3d-dl_sequence">',a=o,d=o,c='<div id="'+l.pre+t+'_clinvarseq_sequence" class="icn3d-dl_sequence">',h=c,p=c,m=!i||n?e.data:e.split("\n"),u={},g={},f={};void 0===l.resi2disease_nonempty[t]&&(l.resi2disease_nonempty[t]={});let C={},b={},y={},v={},_={},w="";r.bNode&&(i?(l.resid2snp||(l.resid2snp={}),l.resid2snp[t]||(l.resid2snp[t]=[])):(l.resid2clinvar||(l.resid2clinvar={}),l.resid2clinvar[t]||(l.resid2clinvar[t]=[])));let S={};for(let e=0,s=m.length;e<s;++e)if(""!=m[e]){let s=!i||n?m[e]:m[e].split("\t"),o=s[3],a=s[4],d=!1;if(i?s.length>5&&(d=parseInt(s[5])):s.length>8&&(d=parseInt(s[8])),o==w)continue;w=o;let c=o.indexOf(">"),h=o.substr(0,c-1),p=Math.round(h),A=d?p:l.ParserUtilsCls.getResi(t,p-1),x=A+o.substr(c-1);if(S.hasOwnProperty(x))continue;S[x]=1;let k=o.substr(c-1,1),O=l.firstAtomObjCls.getFirstAtomObj(l.residues[t+"_"+A]),R=O?r.utilsCls.residueName2Abbr(O.resn.substr(0,3)):"";if(d||(R=l.chainsSeq[t][p-1].name),k!=R)continue;if(r.bNode){let e={};e[t+"_"+A]=x,i?l.resid2snp[t].push(e):l.resid2clinvar[t].push(e)}let I=x.substr(x.indexOf(">")+1),E=i?"":s[5],T=i?"":s[6],P=i?"":s[7];v[A]=1,""!=T&&(_[A]=1),g[A]=e+1,void 0===u[A]&&(u[A]=[]),u[A].push(I),void 0===b[A]&&(b[A]=[]),b[A].push(a),void 0===y[A]&&(y[A]=[]),y[A].push(E),void 0===f[A]&&(f[A]=[]),f[A].push(T),""!=T&&(void 0===l.resi2disease_nonempty[t][A]&&(l.resi2disease_nonempty[t][A]=[]),l.resi2disease_nonempty[t][A].push(T)),void 0===C[A]&&(C[A]=[]),C[A].push(P)}let A=Object.keys(v),x=Object.keys(_);if(i){let e=!1;o+=this.getSnpLine(1,2,u,b,y,f,g,C,A,x,1,t,!1,e,void 0,i),o+=this.getSnpLine(2,2,u,b,y,f,g,C,A,x,0,t,!1,e,void 0,i),d+=this.getSnpLine(1,2,u,b,y,f,g,C,A,x,1,t,!1,e,!0,i),d+=this.getSnpLine(2,2,u,b,y,f,g,C,A,x,0,t,!1,e,!0,i),a+=this.getSnpLine(1,2,u,b,y,f,g,C,A,x,1,t,!0,e,void 0,i),o+="</div>",a+="</div>",d+="</div>",$("#"+l.pre+"dt_snp_"+t).html(o),$("#"+l.pre+"ov_snp_"+t).html(a),$("#"+l.pre+"tt_snp_"+t).html(d)}else{let e=!0;c+=this.getSnpLine(1,2,u,b,y,f,g,C,A,x,1,t,!1,e,void 0,i),c+=this.getSnpLine(2,2,u,b,y,f,g,C,A,x,0,t,!1,e,void 0,i),p+=this.getSnpLine(1,2,u,b,y,f,g,C,A,x,1,t,!1,e,!0,i),p+=this.getSnpLine(2,2,u,b,y,f,g,C,A,x,0,t,!1,e,!0,i),h+=this.getSnpLine(1,2,u,b,y,f,g,C,A,x,1,t,!0,e,void 0,i),c+="</div>",h+="</div>",p+="</div>",$("#"+l.pre+"dt_clinvar_"+t).html(c),$("#"+l.pre+"ov_clinvar_"+t).html(h),$("#"+l.pre+"tt_clinvar_"+t).html(p),this.navClinVar(t,s)}l.showAnnoCls.enableHlSeq(),i?l.bAjaxSnp=!0:l.bAjaxClinvar=!0}async showClinvarPart2(e,t,s){let i=this.icn3d,n=i.icn3dui,l=this;i.chainid2uniport||await this.getUniprotForAllStructures();let r=n.htmlCls.baseUrl+"vastdyn/vastdyn.cgi?chainid_clinvar="+t+"&uniprot="+i.chainid2uniport[t];i.chainsGene[e]&&i.chainsGene[e].geneSymbol&&(r+="&gene="+i.chainsGene[e].geneSymbol);try{let s=await n.getAjaxPromise(r,"jsonp");if(s&&s.data&&s.data.length>0){let i=!1,n=s;l.processSnpClinvar(n,e,t,i)}else l.processNoClinvar(e)}catch(t){return void l.processNoClinvar(e)}}async getUniprotForAllStructures(){let e=this.icn3d,t=e.icn3dui;e.chainid2uniport={};for(let s in e.structures)if(s.length>5){let t=e.structures[s];for(let i=0,n=t.length;i<n;++i)e.chainid2uniport[t[i]]=s}else{let i=s.toLowerCase(),n="https://www.ebi.ac.uk/pdbe/api/mappings/uniprot/"+i,l=(await t.getAjaxPromise(n,"json"))[i].UniProt;for(let t in l){let i=l[t].mappings;for(let n=0,l=i.length;n<l;++n){let l=i[n].chain_id;e.chainid2uniport[s+"_"+l]=t}}}}async showSnpPart2(e,t,s){let i=this.icn3d,n=i.icn3dui,l=this;if(i.chainid2uniport||await this.getUniprotForAllStructures(),void 0!==s){let s=n.htmlCls.baseUrl+"vastdyn/vastdyn.cgi?chainid_snp="+t+"&uniprot="+i.chainid2uniport[t];i.chainsGene[e]&&i.chainsGene[e].geneSymbol&&(s+="&gene="+i.chainsGene[e].geneSymbol);try{let i=await n.getAjaxPromise(s,"jsonp");if(i&&i.data&&i.data.length>0){let s=!0,n=!0;l.processSnpClinvar(i,e,t,s,n)}else l.processNoSnp(e)}catch(t){return void l.processNoSnp(e)}}else this.processNoSnp(e),console.log("No gi was found for the chain "+t+"...")}processNoClinvar(e){let t=this.icn3d;t.icn3dui,console.log("No ClinVar data were found for the protein "+e+"..."),$("#"+t.pre+"dt_clinvar_"+e).html(""),$("#"+t.pre+"ov_clinvar_"+e).html(""),t.showAnnoCls.enableHlSeq(),t.bAjaxClinvar=!0}processNoSnp(e){let t=this.icn3d;t.icn3dui,console.log("No SNP data were found for the protein "+e+"..."),$("#"+t.pre+"dt_snp_"+e).html(""),$("#"+t.pre+"ov_snp_"+e).html(""),t.showAnnoCls.enableHlSeq(),t.bAjaxSnp=!0}}class Rt{constructor(e){this.icn3d=e}showSsbond(e,t){let s=this.icn3d;s.icn3dui;let i=this;void 0===s.ssbondpnts?setTimeout((function(){i.showSsbond_base(e,t)}),1e3):this.showSsbond_base(e,t)}showSsbond_base(e,t){let s=this.icn3d;s.icn3dui.bNode&&(s.resid2ssbond||(s.resid2ssbond={}),s.resid2ssbond[e]||(s.resid2ssbond[e]=[]));let i=t,n={},l=i.substr(0,i.indexOf("_")),r=s.ssbondpnts[l];if(void 0===r)return $("#"+s.pre+"dt_ssbond_"+e).html(""),$("#"+s.pre+"ov_ssbond_"+e).html(""),void $("#"+s.pre+"tt_ssbond_"+e).html("");for(let e=0,t=r.length;e<t;e+=2){let t=r[e],s=r[e+1],l=t.substr(0,t.lastIndexOf("_")),o=s.substr(0,s.lastIndexOf("_"));i===l&&(void 0===n[t]&&(n[t]=[]),n[t].push(s)),i===o&&(void 0===n[s]&&(n[s]=[]),n[s].push(t))}let o=Object.keys(n);s.annoCddSiteCls.showAnnoType(e,t,"ssbond","Disulfide Bonds",o,n)}}class It{constructor(e){this.icn3d=e}showTransmem(e,t){let s=this.icn3d;s.icn3dui;let i=this;void 0===s.ssbondpnts?setTimeout((function(){i.showTransmem_base(e,t)}),1e3):this.showTransmem_base(e,t)}showTransmem_base(e,t){let s=this.icn3d;s.icn3dui;let i={};for(let e in s.chains[t]){let t=s.atoms[e];if(t.coord.z<s.halfBilayerSize&&t.coord.z>-s.halfBilayerSize){i[t.structure+"_"+t.chain+"_"+t.resi]=1}}let n=Object.keys(i);s.annoCddSiteCls.showAnnoType(e,t,"transmem","Transmembrane",n)}}class Et{constructor(e){this.icn3d=e,this.init3ddomain()}init3ddomain(){this.icn3d.icn3dui,this.dcut=8,this.min_contacts=2,this.MAX_SSE=512,this.ctc_cnt=[];for(let e=0;e<this.MAX_SSE;++e)this.ctc_cnt[e]=[];this.elt_size=[],this.elt_size.length=this.MAX_SSE,this.group_num=[],this.group_num.length=this.MAX_SSE,this.split_ratio=.25,this.min_size=25,this.min_sse=3,this.max_csz=4,this.mean_cts=0,this.c_delta=3,this.nc_fact=0,this.elements=[],this.elements.length=2*this.MAX_SSE,this.stack=[],this.stack.length=this.MAX_SSE,this.top=0,this.curr_prt0=[],this.curr_prt0.length=this.MAX_SSE,this.curr_prt1=[],this.curr_prt1.length=this.MAX_SSE,this.curr_ne0=0,this.curr_ne1=0,this.curr_ratio=0,this.curr_msize=0,this.parts=[],this.parts.length=2*this.MAX_SSE,this.np=0,this.n_doms=0,this.save_ratios=[],this.save_ratios.length=this.MAX_SSE,this.saved=0}update_partition(e,t,s){this.icn3d.icn3dui;let i,n,l,r,o,a,d,c,h,p,m,u,g,f,C=[],b=[],y=[],v=[];for(y.length=this.MAX_SSE,v.length=this.MAX_SSE,i=this.stack[this.top-1],n=this.elements.length;i<n;++i)C.push(this.elements[i]);let _=!0;for(b=y,i=c=h=p=0,r=-1;i<t;i++){for(l=r+1;l<=e[i];l++)b[c++]=C[l];r=e[i],_?(h=c,b=v,c=p,_=!1):(p=c,b=y,c=h,_=!0)}for(l=r+1;l<s;l++)b[c++]=C[l];if(_?h=c:p=c,h<this.min_sse&&p<this.min_sse)return e;for(i=0;i<h;i++)for(r=this.group_num[y[i]],l=0;l<p;l++)if(r==this.group_num[v[l]])return e;for(i=m=0;i<h;i++)m+=this.elt_size[y[i]];for(i=u=0;i<p;i++)u+=this.elt_size[v[i]];for(i=o=0;i<h;i++)for(l=i;l<h;l++)o+=this.ctc_cnt[y[i]][y[l]];for(i=a=0;i<p;i++)for(l=i;l<p;l++)a+=this.ctc_cnt[v[i]][v[l]];if(1*o/m<this.mean_cts||1*a/u<this.mean_cts)return e;for(o=Math.max(o,this.nc_fact*m),a=Math.max(a,this.nc_fact*u),i=d=0;i<h;i++)for(r=y[i],l=0;l<p;l++)d+=this.ctc_cnt[r][v[l]];if(g=Math.min(o,a),f=1*d/(g+1),f>=this.curr_ratio+.01||f>this.split_ratio)return e;if(f>this.curr_ratio-.01&&Math.min(m,u)<this.curr_msize)return e;for(i=0;i<h;i++)this.curr_prt0[i]=y[i];for(i=0;i<p;i++)this.curr_prt1[i]=v[i];return this.curr_ne0=h,this.curr_ne1=p,this.curr_ratio=f,this.curr_msize=Math.min(m,u),e}cut_size(e,t){this.icn3d.icn3dui;let s,i,n,l=[];for(l.length=this.MAX_SSE,s=0;s<e;s++)l[s]=s;for(;;){for(s=n=1;s<e;s++)if(l[s]-l[s-1]<=this.c_delta){n=0;break}for(n&&l[e-1]<t-1&&(l=this.update_partition(l,e,t)),i=e-1;i>=0&&l[i]==t-e+i;i--);if(i<0)break;for(l[i]++,s=i+1;s<e;s++)l[s]=l[s-1]+1}}process_set(){this.icn3d.icn3dui;let e,t,s,i,n,l,r=[];for(e=this.stack[this.top-1],t=this.elements.length;e<t;++e)r.push(this.elements[e]);for(i=0;i<r.length&&r[i]>-1;i++);for(l=Math.min(i-1,this.max_csz),this.curr_ne0=this.curr_ne1=0,this.curr_ratio=100,s=1;s<=l;s++)this.cut_size(s,i);if(this.top--,0==this.curr_ne0){for(n=this.stack[this.top],e=n;e<this.elements.length&&this.elements[e]>-1;e++)this.parts[this.np++]=this.elements[e];this.parts[this.np++]=-1,this.n_doms++}else{if(this.save_ratios[this.saved++]=this.curr_ratio,this.curr_ne0>this.min_sse){for(n=this.stack[this.top],e=0;e<this.curr_ne0;e++)this.elements[n++]=this.curr_prt0[e];this.elements[n++]=-1,this.stack[++this.top]=n}else{for(e=0;e<this.curr_ne0;e++)this.parts[this.np++]=this.curr_prt0[e];this.parts[this.np++]=-1,this.n_doms++}if(this.curr_ne1>this.min_sse){for(n=this.stack[this.top],e=0;e<this.curr_ne1;e++)this.elements[n++]=this.curr_prt1[e];this.elements[n++]=-1,this.stack[++this.top]=n}else{for(e=0;e<this.curr_ne1;e++)this.parts[this.np++]=this.curr_prt1[e];this.parts[this.np++]=-1,this.n_doms++}}}process_all(e){let t;for(this.icn3d.icn3dui,this.top=1,this.stack[0]=this.np=this.n_doms=0,this.saved=0,t=0;t<e;t++)this.elements[t]=t;for(this.elements[e]=-1;this.top>0;)this.process_set()}output(e){let t,s;this.icn3d.icn3dui;let i=[];for(t=0;t<2*e;t++)i.push(0);for(t=s=0;s<this.n_doms;t++)i[t]=this.parts[t]+1,this.parts[t]<0&&s++;return i}new_split_chain(e,t,s,i,n,l,r,o,a,d,c){let h;for(this.icn3d.icn3dui,this.split_ratio=t,this.min_size=s,this.min_sse=i,this.max_csz=n,this.mean_cts=l,this.c_delta=r,this.nc_fact=o,this.process_all(e),this.parts=this.output(e),d=this.saved,h=0;h<this.saved;h++)c[h]=this.save_ratios[h];return d}c2b_AlphaContacts(e,t,s,i,n,l){this.icn3d.icn3dui,n||(n=this.dcut);let r=[],o=[];for(let n=0;n<e;n++){if(!t[n]||!s[n]||!i[n])continue;let e={};e.rnum=l[n],e.x=t[n],e.y=s[n],e.z=i[n],o.push(e)}o.sort((function(e,t){return e.x-t.x}));let a,d,c=o.length;for(a=0;a<c;++a){let e=o[a],t=e.x,s=e.y,i=e.z;for(d=a+1;d<c;++d){let l=o[d];if(parseInt(e.rnum)-parseInt(l.rnum)<=3&&parseInt(l.rnum)-parseInt(e.rnum)<=3)continue;let a=l.x,c=l.y,h=l.z;if(a>t+n)break;let p=(t-a)*(t-a);p+=(s-c)*(s-c),p+=(i-h)*(i-h);let m=Math.sqrt(p);if(m>n)continue;let u={},g={};parseInt(e.rnum)<parseInt(l.rnum)?(g.first=e.rnum,g.second=l.rnum):(g.first=l.rnum,g.second=e.rnum),u.first=g,u.second=m,r.push(u)}}return r}c2b_ContactTable(e,t){this.icn3d.icn3dui;let s={},i=e.length;if(i!=t.length)return s;for(let n=0;n<i;n++){let i=e[n]+"_"+t[n];s[i]?s[i]++:s[i]=1}return s}countUtil(e,t,s){this.visited[e]=!0,this.groupnum2sheet[s]||(this.groupnum2sheet[s]=[]),this.groupnum2sheet[s].push(parseInt(e));for(let i in t[e])this.visited[i]||this.countUtil(i,t,s)}c2b_NewSplitChain(e,t){let s=this.icn3d;s.icn3dui,this.init3ddomain();let i=[],n=[],l=[],r=[],o=[],a=[],d=[],c=s.firstAtomObjCls.getResiduesFromAtoms(e),h=Object.keys(c),p=h[0].substr(0,h[0].lastIndexOf("_"));s.posid2resid||(s.posid2resid={});let m={},u={};for(let e=0;e<h.length;++e){let t=h[e],a=t.substr(t.lastIndexOf("_")+1),d=s.firstAtomObjCls.getFirstCalphaAtomObj(s.residues[t]);d&&(i.push(d.coord.x),n.push(d.coord.y),l.push(d.coord.z),r.push(e+1),u[e]=a,d.ssend&&(m.To=e+1,m.x2=d.coord.x,m.y2=d.coord.y,m.z2=d.coord.z,m.Sheet="sheet"==d.ss,o.push(m),m={}),d.ssbegin&&(m.From=e+1,m.x1=d.coord.x,m.y1=d.coord.y,m.z1=d.coord.z))}let g=o.length;if(g<=3)return o=this.standardizeSubstruct(p,o,u),{subdomains:a,substruct:o};if(g>this.MAX_SSE)return o=this.standardizeSubstruct(p,o,u),{subdomains:a,substruct:o};let f=h.length,C=f,b=this.c2b_AlphaContacts(f,i,n,l,t,r),y=[];for(let e=0;e<f;e++)y.push(0);let v=!1;for(let e=0;e<o.length;e++){let t=o[e],s=t.From,i=t.To;this.elt_size[e]=i-s+1;for(let t=s;t<=i;t++)y[t-1]=e+1;t.Sheet&&(v=!0)}let _=[],w=[],S=[],A=[];for(let e=0,t=b.length;e<t;++e){let t=b[e].first,s=y[t.first-1],i=y[t.second-1];s<=0||i<=0||!s||!i||(_.push(s),w.push(i),s!=i&&(S.push(s),A.push(i)))}for(let e=0;e<S.length;e++)_.push(A[e]),w.push(S[e]);for(let e=0;e<g;e++)_.push(e+1),w.push(e+1);let x=this.c2b_ContactTable(_,w),k={};for(let e in x){let t=e.split("_"),s=parseInt(t[0]),i=parseInt(t[1]);x[e]<this.min_contacts&&(x[e]=0),o[s-1].Sheet&&o[i-1].Sheet&&x[e]>=this.min_contacts&&(k[s]||(k[s]={}),k[i]||(k[i]={}),k[s][i]=1,k[i][s]=1)}let O=0,R={};this.groupnum2sheet={},this.visited={};for(let e in k)this.visited[e]=!1;for(let e in k)0==this.visited[e]&&(O++,this.countUtil(e,k,O));for(let e in this.groupnum2sheet){let t=this.groupnum2sheet[e].sort((function(e,t){return e-t}));for(let e=0,s=t.length;e<s;++e)R[t[e]]=t[0]}let I={};for(let e=0;e<g;e++)if(o[e].Sheet){let t={};R[e+1]?(t.sheet_num=R[e+1],t.adj_strand2=1,t.sse=e+1):(t.sheet_num=0,t.adj_strand2=0,t.sse=e+1,I[t.sse]=1),d.push(t)}for(let e=0;e<g;e++)for(let t=0;t<g;t++){let s=(e+1).toString()+"_"+(t+1).toString();if(x[s]){let i=x[s];e==t&&i--,this.ctc_cnt[e][t]=i,this.ctc_cnt[t][e]=i}else this.ctc_cnt[e][t]=0}if(v){let e=0;for(let t=0;t<d.length;t++){let s=d[t];s.sheet_num>0&&this.elt_size[s.sse-1]>=6&&0!=s.adj_strand2&&e++}for(let e=0;e<g;e++)this.group_num[e]=e+1;if(e>0)for(let e=0;e<d.length;e++){let t=d[e];0!=t.sheet_num&&(this.group_num[t.sse-1]=t.sheet_num)}}else for(let e=0;e<g;e++)this.group_num[e]=e+1;this.parts=[],this.parts.length=2*this.MAX_SSE;let E=[];E.length=this.MAX_SSE;let T=0;for(let e=0;e<g;e++)this.parts[2*e]=this.parts[2*e+1]=0,E[e]=0;T=this.new_split_chain(g,.25,25,3,4,0,3,0,this.parts,T,E);let P=[];if(T>0){let e=0;for(let t=0;t<=T;t++){let t=[];for(;e<2*g;){let s=this.parts[e++];if(0==s){P.push(t);break}t.push(s)}}}P.sort((function(e,t){return e[0]-t[0]}));let D=[];for(let e=0,t=P.length;e<t;++e){let t=[];for(let s=0,i=P[e].length;s<i;++s){let i=P[e][s];I.hasOwnProperty(i)||t.push(i)}t.length>=this.min_sse&&D.push(P[e])}if(P=D,0==P.length){let e={},t={},s=0;for(let i=0,n=this.group_num.length;i<n;++i){let n=this.group_num[i],l=i+1;n&&n!=i+1&&(t[n]||(t[n]=[]),t[n].push(l),e[n]?(++e[n],e[n]>=3&&(s=n)):e[n]=1)}if(0!=s){let e=[s].concat(t[s]);P.push(e)}}for(let e=0,t=P.length;e<t;++e){let t=P[e],s={};if(t.length<=2)continue;for(let e=0;e<f;e++)s[e+1]=0;for(let e=0;e<t.length;e++){let i=t[e]-1;if(i<0||i>=o.length)return o=this.standardizeSubstruct(p,o,u),{subdomains:a,substruct:o};let n=o[i],l=n.From,r=n.To;for(let e=l;e<=r;e++)s[e]=1;if(0==i&&l>1)for(let e=1;e<l;e++)l-e<=10&&(s[e]=1);if(i==o.length-1&&r<parseInt(C))for(let e=r+1;e<=parseInt(C);e++)e-r<=10&&(s[e]=1);if(i>0){let e=o[i-1].To,t=parseInt(.5*(l-e-1));if(t>0)for(let e=l-t;e<=l-1;e++)s[e]=1}if(i<o.length-1){let e=o[i+1].From,t=parseInt(.5*(e-r-1)+.5);if(t>0)for(let e=r+1;e<=r+t;e++)s[e]=1}}let i,n=!1,l=[];for(let e=0;e<f;e++){let t=s[e+1];if(n||1!=t){if(n&&0==t){let t=this.getNcbiresiRangeFromPos(p,i,e,u);l=l.concat(t),n=!1}}else i=e+1,n=!0}if(n){let e=this.getNcbiresiRangeFromPos(p,i,C,u);l=l.concat(e)}a.push(l)}s.tddomains||(s.tddomains={});for(let e=0,t=a.length;e<t;++e){let t="domain3d-"+Object.keys(s.tddomains).length;s.tddomains[t]={};for(let i=0,n=a[e].length;i<n;i+=2)for(let n=a[e][i];n<=a[e][i+1];++n){let e=p+"_"+n;s.tddomains[t][e]=1}}return o=this.standardizeSubstruct(p,o,u),{subdomains:a,substruct:o}}standardizeSubstruct(e,t,s){let i=this.icn3d;i.icn3dui;for(let n=0;n<t.length;n++){let l=t[n],r=l.From,o=l.To,a=s[r-1],d=s[o-1],c=i.annoDomainCls.getNcbiresiFromResid(e+"_"+a),h=i.annoDomainCls.getNcbiresiFromResid(e+"_"+d);t[n].From=c.substr(c.lastIndexOf("_")+1),t[n].To=h.substr(h.lastIndexOf("_")+1),t[n].From=parseInt(t[n].From),t[n].To=parseInt(t[n].To)}return t}getNcbiresiRangeFromPos(e,t,s,i){let n=this.icn3d;n.icn3dui;let l=[];for(let r=t;r<=s;++r){let t=i[r-1],s=n.resid2ncbi[e+"_"+t]?n.resid2ncbi[e+"_"+t]:e+"_"+t,o=s.substr(s.lastIndexOf("_")+1);l.push(parseInt(o))}return n.resid2specCls.resi2range(l)}getDomainJsonForAlign(e){let t=this.icn3d,s=t.icn3dui,i=t.firstAtomObjCls.getResiduesFromAtoms(e),n=Object.keys(i),l=n[0].substr(0,n[0].lastIndexOf("_")),r=[],o={},a={},d=999,c=-999;for(let e=0;e<n.length;++e){let s=n[e],i=t.firstAtomObjCls.getFirstCalphaAtomObj(t.residues[s]),l=s.substr(s.lastIndexOf("_")+1);a[e]=l;let h=t.resid2ncbi[s]?t.resid2ncbi[s]:s,p=parseInt(h.substr(h.lastIndexOf("_")+1));p<d&&(d=p),p>c&&(c=p),i.ssend&&(o.To=e+1,o.x2=i.coord.x,o.y2=i.coord.y,o.z2=i.coord.z,o.Sheet="sheet"==i.ss,r.push(o),o={}),i.ssbegin&&(o.From=e+1,o.x1=i.coord.x,o.y1=i.coord.y,o.z1=i.coord.z)}r=this.standardizeSubstruct(l,r,a);let h='{"data": [';h+='{"ss": [';let p=0;for(let e=0,s=r.length;e<s;++e){let s=r[e].Sheet?2:1,i=r[e].From,n=r[e].To,o=t.ncbi2resid[l+"_"+i],a=t.firstAtomObjCls.getFirstCalphaAtomObj(t.residues[o]);if(!a||!t.hAtoms.hasOwnProperty(a.serial))continue;let d=t.ncbi2resid[l+"_"+n],c=t.firstAtomObjCls.getFirstCalphaAtomObj(t.residues[d]);c&&t.hAtoms.hasOwnProperty(c.serial)&&(p>0&&(h+=", "),h+="["+s+","+i+","+n+","+r[e].x1.toFixed(2)+","+r[e].y1.toFixed(2)+",",h+=r[e].z1.toFixed(2)+","+r[e].x2.toFixed(2)+","+r[e].y2.toFixed(2)+","+r[e].z2.toFixed(2)+"]",++p)}h+="]",h+=', "domain": [';let m=0;for(let e=d;e<=c;++e){let n=l+"_"+e,r=t.ncbi2resid[n];r.split("_")[2];let o=e;if(m>0&&(h+=", "),i.hasOwnProperty(r)){let e=t.firstAtomObjCls.getFirstCalphaAtomObj(t.residues[r]);h+="["+o+","+(s.parasCls.resn2restype[e.resn]?s.parasCls.resn2restype[e.resn]:0)+","+e.coord.x.toFixed(2)+","+e.coord.y.toFixed(2)+","+e.coord.z.toFixed(2)+"]"}else h+="["+o+",0,0,0,0]";++m}return h+="]}",h+="]}",h}}class Tt{constructor(e){this.icn3d=e}clickAddTrackButton(){let e=this.icn3d,t=e.icn3dui,s=this;t.myEventCls.onIds("#"+e.pre+"addtrack_button1","click",(async function(e){let i=s.icn3d;e.stopImmediatePropagation(),dialog.dialog("close");let n=$("#"+i.pre+"track_chainid").val(),l=$("#"+i.pre+"track_gi").val(),r=isNaN(l)?"Acc "+l:"gi "+l,o=t.htmlCls.baseUrl+"pwaln/pwaln.fcgi?from=track",a={targets:n,queries:l},d=await t.getAjaxPostPromise(o,a);s.alignSequenceToStructure(n,d,r)})),t.myEventCls.onIds("#"+e.pre+"addtrack_button2","click",(async function(e){let i=s.icn3d;e.stopImmediatePropagation(),dialog.dialog("close");let n=$("#"+i.pre+"track_chainid").val(),l=$("#"+i.pre+"track_fasta").val(),r=$("#"+i.pre+"fasta_title").val(),o=n.substr(0,n.indexOf("_")),a=n;if(5==o.length)a=a.substr(0,4);else if(o.length>5){a="";for(let e=0,t=i.chainsSeq[n].length;e<t;++e)a+=i.chainsSeq[n][e].name}let d=t.htmlCls.baseUrl+"pwaln/pwaln.fcgi?from=track",c={targets:a,queries:l},h=await t.getAjaxPostPromise(d,c);s.alignSequenceToStructure(n,h,r)})),t.myEventCls.onIds("#"+e.pre+"addtrack_button2b","click",(async function(e){let t=s.icn3d;e.stopImmediatePropagation(),dialog.dialog("close");let i=$("#"+t.pre+"track_chainid").val(),n=$("#"+t.pre+"fasta_startpos").val();n||(n=1);let l="identity"==$("#"+t.pre+"colorseqby").val()?"identity":"custom",r=$("#"+t.pre+"track_fastaalign").val();r&&await s.addMsaTracks(i,n,l,r)})),t.myEventCls.onIds("#"+e.pre+"exons_table","click",(async function(e){let t=s.icn3d;e.stopImmediatePropagation();let i=$("#"+t.pre+"track_geneid").val().trim();window.open("https://www.ncbi.nlm.nih.gov/gene/"+i+"?report=gene_table","_blank")})),t.myEventCls.onIds("#"+e.pre+"addtrack_button2c","click",(async function(e){s.icn3d,e.stopImmediatePropagation(),dialog.dialog("close"),await s.addExonTracksWrap()})),t.myEventCls.onIds("#"+e.pre+"addtrack_button3","click",(function(e){let i=s.icn3d;e.stopImmediatePropagation(),dialog.dialog("close");let n=$("#"+i.pre+"track_chainid").val(),l=$("#"+i.pre+"track_bed")[0].files[0];if(l){window.File&&window.FileReader&&window.FileList&&window.Blob||alert("The File APIs are not fully supported in this browser.");let e=new FileReader;e.onload=function(e){let l,r=e.target.result.split("\n"),o=!1,a=!1;for(let e=0,d=r.length;e<d;++e)if("browser"!=r[e].substr(0,7))if("track"==r[e].substr(0,5)){if(-1!=r[e].toLowerCase().indexOf("itemrgb")&&(o=!0),-1!=r[e].toLowerCase().indexOf("colorbystrand=")){a=!0;let t=r[e].toLowerCase().indexOf("colorbystrand="),s=r[e].substr(t),i=s.indexOf('"');if(-1!=i){let e=s.substr(i+1),t=e.indexOf('"');if(-1!=i){l=e.substr(0,t).split(" ")}}}}else{if(""==r[e])continue;let d=r[e].replace(/\s+/g," ").split(" ");(d.length>8||d.length<6)&&(a=!1),d.length<9&&(o=!1),d[0];let c,h,p=d[1],m=d[2],u=d[3];d.length>4&&d[4],d.length>5&&(c=d[5]),d.length>6&&d[6],d.length>7&&d[7],d.length>8&&(h=d[8]),d.length>9&&d[9],d.length>10&&d[10],d.length>11&&d[11];let g=u,f="51,51,51";o?f=h:a&&("+"==c&&l.length>0?f=l[0]:"-"==c&&l.length>1?f=l[1]:"."==c&&l.length>2&&(f=l[2]));let C="",b=[];for(let e=0,t=m;e<t;++e)e<p?(C+="-",b.push("")):(C+=i.giSeq[n][e],b.push("rgb("+f+")"));s.showNewTrack(n,g,C,b,void 0,void 0,f),t.htmlCls.clickMenuCls.setLogCmd("add track | chainid "+n+" | title "+g+" | text "+s.simplifyText(C)+" | type bed | color "+f,!0)}},e.readAsText(l)}else alert("Please select a file...")})),t.myEventCls.onIds("#"+e.pre+"addtrack_button4","click",(function(e){let i=s.icn3d;e.stopImmediatePropagation(),dialog.dialog("close");let n=$("#"+i.pre+"track_chainid").val(),l=$("#"+i.pre+"track_title").val(),r=$("#"+i.pre+"track_text").val(),o=s.getFullText(r);s.showNewTrack(n,l,o.text,void 0,void 0,"custom",void 0,void 0,o.fromArray,o.toArray),t.htmlCls.clickMenuCls.setLogCmd("add track | chainid "+n+" | title "+l+" | text "+s.simplifyText(r)+" | type custom",!0)})),t.myEventCls.onIds("#"+e.pre+"addtrack_button5","click",(function(e){let i=s.icn3d;e.stopImmediatePropagation(),dialog.dialog("close");let n=$("#"+i.pre+"track_chainid").val(),l=$("#"+i.pre+"track_selection").val(),r="",o=t.hashUtilsCls.intHash(i.hAtoms,i.chains[n]),a=i.firstAtomObjCls.getResiduesFromCalphaAtoms(o),d=[];for(let e=0,t=i.giSeq[n].length;e<t;++e){let t=i.giSeq[n][e],s=t;t.length>1&&(s=t[0]);let l=i.ParserUtilsCls.getResi(n,e);if(a.hasOwnProperty(n+"_"+l)){let e=i.firstAtomObjCls.getFirstCalphaAtomObj(i.residues[n+"_"+l]),t=void 0===e.color||"FFFFFF"===e.color.getHexString().toUpperCase()?"DDDDDD":e.color.getHexString(),o=void 0!==e.color?t:"CCCCCC";r+=s,d.push("#"+o)}else r+="-",d.push("")}s.showNewTrack(n,l,r,d,void 0,"selection",void 0),t.htmlCls.clickMenuCls.setLogCmd("add track | chainid "+n+" | title "+l+" | text "+s.simplifyText(r)+" | type selection",!0)}))}showNewTrack(e,t,s,i,n,l,r,o,a,d,c,h,p){let m=this.icn3d,u=m.icn3dui,g=!1;"cannot be aligned"==s&&(g=!0);let f=s.replace(/-/g,"").length;if(!o)if(s.length>m.giSeq[e].length)s=s.substr(0,m.giSeq[e].length);else if(s.length<m.giSeq[e].length&&!g){let t="";for(let i=0,n=m.giSeq[e].length-s.length;i<n;++i)t+="-";s+=t}let C=t.replace(/\s/g,"_").replace(/\./g,"dot").replace(/\W/g,"");C.length>20&&(C=C.substr(0,20));let b=u.htmlCls.RESIDUE_WIDTH*s.length+200;$("#"+m.pre+"dt_custom_"+e).append("<div id='"+m.pre+"dt_custom_"+e+"_"+C+"'></div>"),$("#"+m.pre+"dt_custom_"+e+"_"+C).width(b),$("#"+m.pre+"ov_custom_"+e).append("<div id='"+m.pre+"ov_custom_"+e+"_"+C+"'></div>"),$("#"+m.pre+"ov_custom_"+e+"_"+C).width(b),$("#"+m.pre+"tt_custom_"+e).append("<div id='"+m.pre+"tt_custom_"+e+"_"+C+"'></div>"),$("#"+m.pre+"tt_custom_"+e+"_"+C).width(b);let y='<div class="icn3d-dl_sequence">',v=y,_=y,w=y,S=y,A=parseInt(10*Math.random()),x='<div class="icn3d-seqTitle icn3d-link icn3d-blue" custom="'+(A+1).toString()+'" from="'+a+'" to="'+d+'" shorttitle="'+C+'" index="'+A+'" setname="'+e+"_custom_"+(A+1).toString()+'" anno="sequence" chain="'+e+'" title="'+t+'">'+C+" </div>",k='<div class="icn3d-seqTitle" chain="'+e+'" title="Exons of '+t+'">Exons </div>',O='<span class="icn3d-residueNum" title="residue count">'+f.toString()+" Pos</span>";w+=x+O+"<br>",S+=k+O+"<br>";let R='<span class="icn3d-seqLine">';y+=x+O+R,v+=k+O+R,_+=x+O+R;let I=e.indexOf("_"),E="cst"+e.substr(I+1),T=0,P=0,D=(void 0===l||"seq"===l||"custom"===l)&&-1==s.indexOf("cannot-be-aligned")&&-1==s.indexOf("cannot be aligned"),M="identity"===l&&-1==s.indexOf("cannot-be-aligned")&&-1==s.indexOf("cannot be aligned"),F={},H=0;x="";let L={},N={},q={},U=0;if(h)for(let e=0,t=h.length;e<t;++e){let t=h[e].resStart,s=h[e].resEnd,i=parseInt(h[e].genomeRange.split("-")[0]);for(let n=0,l=s-t+1;n<l;++n){let l=this.getExonColor(t,s,U);L[U]=l,N[U]=i+m.exonOrder*n*3+"-"+(i+m.exonOrder*n*3+2*m.exonOrder),q[U]=e,++U}}U=0;for(let t=0,a=s.length;t<a;++t){let a=t-H-(m.seqStartLen&&m.seqStartLen[e]?m.seqStartLen[e]:0);o?m.targetGapHash.hasOwnProperty(a)&&!F.hasOwnProperty(a)&&(H+=m.targetGapHash[a].to-m.targetGapHash[a].from+1,F[a]=1):y+=m.showSeqCls.insertGap(e,t,"-");let d=s.charAt(t);if(" "!=d&&"-"!=d){let s,o=m.chainsSeq[e][a]?m.chainsSeq[e][a].name:" ",c=m.showAnnoCls.getColorhexFromBlosum62(d,o),p=d==o?"FF0000":"0000FF",g=m.baseResi[e]+(t+1)-(m.seqStartLen&&m.seqStartLen[e]?m.seqStartLen[e]:0);if(void 0!==n&&(g=m.baseResi[e]+n[t]+1),void 0!==i&&""!=i[t])s='style="color:'+i[t]+'"';else if(r)s='style="color:rgb('+r+')"';else if(D||"seq"==l){if(s='style="color:#'+c+'"',"seq"==l)for(let t in m.residues[e+"_"+g]){let e=u.parasCls.thr("#"+c);m.atoms[t].color=e,m.atomPrevColors[t]=e}}else s=M?'style="color:#'+p+'"':"";if(y+='<span id="'+E+"_"+m.pre+e+"_"+g+'" title="'+d+g+'" class="icn3d-residue" '+s+">"+d+"</span>",h){let t='style="background-color:'+L[U]+'"';v+='<span id="'+E+"_"+m.pre+e+"_"+g+'" title="'+d+g+", Exon "+(q[U]+1)+": "+N[U]+'" class="icn3d-residue" '+t+">&nbsp;</span>";for(let t in m.residues[e+"_"+g]){let e=m.atoms[t];e.color=u.parasCls.thr(L[U]),m.atomPrevColors[t]=e.color}}x+=m.showSeqCls.insertGapOverview(e,t);let f=Math.round(m.seqAnnWidth*t/(m.maxAnnoLength+m.nTotalGap)-T-P);f<0&&(f=0),x+='<div style="display:inline-block; width:'+f+'px;">&nbsp;</div>',s=void 0!==i&&""!=i[t]?i[t]:r?"rgb("+r+")":D?"#"+c:"#333",x+='<div style="display:inline-block; background-color:'+s+'; width:1px;" title="'+d+(t+1).toString()+'">&nbsp;</div>',T+=f,P+=1,++U}else g?y+="<span>"+d+"</span>":(y+="<span>-</span>",v+="<span></span>")}if(void 0!==a){x="";let s=[],i=[],n=[];for(let e=0,t=a.length;e<t;++e){s.push(a[e]),n.push(p[e]);for(let t=parseInt(a[e]);t<=parseInt(d[e]);++t)void 0!==m.targetGapHash&&m.targetGapHash.hasOwnProperty(t)&&(i.push(t-1),s.push(t),n.push(p[e]));i.push(d[e])}m.nTotalGap=0;for(let e in m.targetGapHash)m.nTotalGap+=m.targetGapHash[e].to-m.targetGapHash[e].from+1;let l,r=m.firstAtomObjCls.getFirstCalphaAtomObj(m.chains[e]),o=void 0===r.color||"FFFFFF"===r.color.getHexString()?"DDDDDD":r.color.getHexString(),u=void 0!==r.color?o:"CCCCCC",g=0;for(let r=0,o=s.length;r<o;++r){x+=m.showSeqCls.insertGapOverview(e,s[r]);let o=c?s[r]:s[r]-m.baseResi[e]-1,p=0==r?Math.round(m.seqAnnWidth*o/(m.maxAnnoLength+m.nTotalGap)):Math.round(m.seqAnnWidth*(s[r]-i[r-1]-1)/(m.maxAnnoLength+m.nTotalGap));if(p<0&&(p=0),x+='<div style="display:inline-block; width:'+p+'px;">&nbsp;</div>',h){let t,s,i=n[r];l=d[r]-a[r]+1;let o,c,p,m=g,u=g+l-1;g+=l;for(let e=0,i=h.length;e<i;++e){let i=h[e].resStart,n=h[e].resEnd;m>=i&&m<=n&&(t={exonIndex:e,rangeStart:i,rangeEnd:n,from:m,genomeRange:h[e].genomeRange}),u>=i&&u<=n&&(s={exonIndex:e,rangeStart:i,rangeEnd:n,to:u,genomeRange:h[e].genomeRange})}if(t&&s&&t.exonIndex==s.exonIndex)o=this.getExonColor(t.rangeStart,t.rangeEnd,m),c=this.getExonColor(t.rangeStart,t.rangeEnd,u),p=o+" 0%, #FFF 50%, "+c+" 100%",x+=this.getExonHtml(t.exonIndex,p,t.from,s.to,t.genomeRange,e,C,i);else if(t&&(o=this.getExonColor(t.rangeStart,t.rangeEnd,m),p=o+" 0%, #FFF 50%, #00F 100%",x+=this.getExonHtml(t.exonIndex,p,t.from,t.rangeEnd,t.genomeRange,e,C,i)),t&&s){for(let n=t.exonIndex+1;n<s.exonIndex;++n)p="#F00 0%, #FFF 50%, #00F 100%",x+=this.getExonHtml(n,p,h[n].resStart,h[n].resEnd,h[n].genomeRange,e,C,i);c=this.getExonColor(s.rangeStart,s.rangeEnd,u),p="#F00 0%, #FFF 50%, "+c+" 100%",x+=this.getExonHtml(s.exonIndex,p,s.rangeStart,s.to,s.genomeRange,e,C,i)}}else x+='<div style="display:inline-block; color:white!important; font-weight:bold; background-color:#'+u+"; width:"+Math.round(m.seqAnnWidth*(i[r]-s[r]+1)/(m.maxAnnoLength+m.nTotalGap))+'px;" class="icn3d-seqTitle icn3d-link icn3d-blue" custom="'+(A+1).toString()+'" from="'+s+'" to="'+i+'" shorttitle="'+C+'" index="'+A+'" setname="'+e+"_custom_"+(A+1).toString()+'" id="'+e+"_custom_"+A+'" anno="sequence" chain="'+e+'" title="'+t+'">'+t+"</div>"}}R='<span class="icn3d-residueNum" title="residue count">'+f.toString()+" Pos</span>",R+="</span>",R+="<br>",R+="</div>",y+=R,_+=x+R,v+=R,w+="</div>",S+="</div>",h?($("#"+m.pre+"dt_custom_"+e+"_"+C).html(v+y),$("#"+m.pre+"ov_custom_"+e+"_"+C).html(_),$("#"+m.pre+"tt_custom_"+e+"_"+C).html(S+w)):($("#"+m.pre+"dt_custom_"+e+"_"+C).html(y),$("#"+m.pre+"ov_custom_"+e+"_"+C).html(_),$("#"+m.pre+"tt_custom_"+e+"_"+C).html(w))}getExonHtml(e,t,s,i,n,l,r,o){let a=this.icn3d;return a.icn3dui,'<div style="display:inline-block; color:white!important; width:'+Math.round(a.seqAnnWidth*(i-s+1)/(a.maxAnnoLength+a.nTotalGap))+'px;" class="icn3d-seqTitle icn3d-link icn3d-blue" domain="'+(e+1)+'" from="'+(s+o)+'" to="'+(i+o)+'" setname="'+r+", "+(e+1)+'" title="Exon: '+n+' genomic interval" anno="sequence" chain="'+l+'"><div style="height: 12px; border: 1px solid #000; background: linear-gradient(to right, '+t+');"></div></div>'}getExonColor(e,t,s){this.icn3d.icn3dui;let i=.5*(e+t);if(s<i){let t=parseInt((s-e)/(i-e)*255);return"rgb(255, "+t+", "+t+")"}{let e=parseInt((t-s)/(t-i)*255);return"rgb("+e+", "+e+", 255)"}}alignSequenceToStructure(e,t,s){let i,n,l,r=this.icn3d,o=r.icn3dui;void 0!==t.data&&(i=t.data[0].query,l=Object.keys(t.data[0].targets)[0],n=t.data[0].targets[l],n=n.hsps[0]);let a="",d=[],c={};if(void 0!==i&&void 0!==n){let h=n.scores.e_value.toPrecision(2);h>1e-200&&(h=parseFloat(h).toExponential()),n.scores.bit_score;let p=t.targets[l].seqdata,m=i.seqdata,u=n.segs;for(let e=0,t=u.length;e<t;++e){let t=u[e];for(let e=0;e<=t.orito-t.orifrom;++e)c[e+t.orifrom]=e+t.from}for(let t=0,s=p.length;t<s;++t)if(c.hasOwnProperty(t)){a+=m[c[t]];let s=r.showAnnoCls.getColorhexFromBlosum62(p[t],m[c[t]]);d.push("#"+s);let i=r.ParserUtilsCls.getResi(e,t);for(let t in r.residues[e+"_"+i]){let e=o.parasCls.thr("#"+s);r.atoms[t].color=e,r.atomPrevColors[t]=e}}else a+="-",d.push("");s+=", E: "+h}else a+="cannot be aligned";this.showNewTrack(e,s,a,d,c,"seq"),r.hlUpdateCls.updateHlAll(),r.drawCls.draw(),o.htmlCls.clickMenuCls.setLogCmd("add track | chainid "+e+" | title "+s+" | text "+this.simplifyText(a)+" | type seq",!0)}defineSecondary(e,t){let s=this.icn3d,i=s.icn3dui;$("#"+s.pre+"dl_definedsets").hasClass("ui-dialog-content")&&$("#"+s.pre+"dl_definedsets").dialog("isOpen")||(i.htmlCls.dialogCls.openDlg("dl_definedsets","Select sets"),$("#"+s.pre+"atomsCustom").resizable());let n,l,r={},o=!1,a=!0,d=0,c=0,h=e+"_C(Nterm";s.hAtoms={};for(let i=0,p=s.chainsSeq[e].length;i<p;++i){let p=e+"_"+s.chainsSeq[e][i].resi;if(s.residues.hasOwnProperty(p)){let i=s.firstAtomObjCls.getFirstCalphaAtomObj(s.residues[p]),m=s.secondaries[p];"H"==m?(i.ssbegin&&(++d,Object.keys(r).length>0&&(l=n+"H"+d.toString().padStart(2,"0")+")","coil"==t&&(s.selectionCls.selectResidueList(r,l,l,o,a),o||(o=!0)),r={})),n=e+"_H"+d.toString().padStart(2,"0"),r[p]=1,i.ssend&&(h=e+"_C(H"+d.toString().padStart(2,"0"),"helix"==t&&(s.selectionCls.selectResidueList(r,n,n,o,a),o||(o=!0)),r={})):"E"==m?(i.ssbegin&&(++c,Object.keys(r).length>0&&(l=n+"S"+c.toString().padStart(2,"0")+")","coil"==t&&(s.selectionCls.selectResidueList(r,l,l,o,a),o||(o=!0)),r={})),n=e+"_S"+c.toString().padStart(2,"0"),r[p]=1,i.ssend&&(h=e+"_C(S"+c.toString().padStart(2,"0"),"sheet"==t&&(s.selectionCls.selectResidueList(r,n,n,o,a),o||(o=!0)),r={})):(n=h+"-",r[p]=1)}}Object.keys(r).length>0&&(l=n+"Cterm)","coil"==t&&s.selectionCls.selectResidueList(r,l,l,o,a))}defineIgstrand(e,t){let s=this.icn3d,i=s.icn3dui;$("#"+s.pre+"dl_definedsets").hasClass("ui-dialog-content")&&$("#"+s.pre+"dl_definedsets").dialog("isOpen")||(i.htmlCls.dialogCls.openDlg("dl_definedsets","Select sets"),$("#"+s.pre+"atomsCustom").resizable());let n={},l=!1,r=!0;if(s.hAtoms={},"igdomain"==t){let t=s.chain2igArray[e];if(t&&t.length>0)for(let i=0,o=t.length;i<o;++i){let o=t[i].startPos,a=t[i].endPos,d=t[i].domainid;n={};for(let t=parseInt(o);t<=parseInt(a);++t){n[e+"_"+s.chainsSeq[e][t].resi]=1}let c=d;s.selectionCls.selectResidueList(n,c,c,l,r)}}else{let i,o,a,d,c,h=0,p=0,m="NT",u=!1;for(let g=0,f=s.chainsSeq[e].length;g<f;++g){let f,C,b,y=e+"_"+s.chainsSeq[e][g].resi;s.residues.hasOwnProperty(y)&&(f=s.resid2refnum[y],f&&(C=s.refnumCls.rmStrandFromRefnumlabel(f),o=f.replace(C,""),b=parseInt(C),"iganchor"==t?b>1e3&&"50"==C.substr(C.length-2,2)&&(n[y]=1):(d=s.residIgLoop.hasOwnProperty(y)?"igloop":"igstrand",u&&d!=c&&Object.keys(n).length>0&&("igstrand"==c?(++h,i="Strand-"+a+"-"+e+"-"+h.toString().padStart(3,"0"),i=i.replace(/'/g,"`"),"igstrand"==t&&(s.selectionCls.selectResidueList(n,i,i,l,r),l||(l=!0)),m=a):"igloop"==c&&(++p,i="Loop-"+m+"_"+o+"-"+e+"-"+p.toString().padStart(3,"0"),i=i.replace(/'/g,"`"),"igloop"==t&&(s.selectionCls.selectResidueList(n,i,i,l,r),l||(l=!0))),n={}),n[y]=1,a=o,c=d,u=!0)))}"iganchor"==t?(i="Anchor-"+e,s.selectionCls.selectResidueList(n,i,i,l,r)):"igstrand"==c?(++h,i="Strand-"+a+"-"+e+"-"+h.toString().padStart(3,"0"),i=i.replace(/'/g,"`"),"igstrand"==t&&s.selectionCls.selectResidueList(n,i,i,l,r)):"igloop"==c&&(++p,o="CT",i="Loop-"+m+"_"+o+"-"+e+"-"+p.toString().padStart(3,"0"),i=i.replace(/'/g,"`"),"igloop"==t&&s.selectionCls.selectResidueList(n,i,i,l,r))}}simplifyText(e){this.icn3d.icn3dui;let t,s,i="",n=!1,l=-1;for(t=0,s=(e=e.replace(/undefined/g," ")).length;t<s;++t)"-"==e[t]||" "==e[t]?(n&&t!==l&&(i+=l+1==t-1?(l+1+1).toString()+" "+e.substr(l+1,t-1-l)+", ":(l+1+1).toString()+"-"+(t-1+1).toString()+" "+e.substr(l+1,t-1-l)+", ",n=!1),l=t):n=!0;return n&&t==s&&(i+=l+1==t-1?(l+1+1).toString()+" "+e.substr(l+1,t-1-l)+", ":(l+1+1).toString()+"-"+(t-1+1).toString()+" "+e.substr(l+1,t-1-l)+", "),i}checkGiSeq(e,t,s,i,n,l,r){let o=this.icn3d;o.icn3dui;let a=this;if(r>20)return!1;if(void 0!==o.giSeq&&void 0!==o.giSeq[e]){let r=this.getFullText(s);return s=r.text,this.showNewTrack(e,t,s,void 0,void 0,i,n,l),!1}setTimeout((function(){a.checkGiSeq(e,t,s,i,n,l,r+1)}),100)}getFullText(e){this.icn3d.icn3dui;let t="",s=[],i=[],n=e.split(","),l=-1;for(let e=0,r=n.length;e<r;++e){let r=n[e].trim();if(0==r.length)continue;let o=r.split(" ");if(2!==o.length)continue;let a,d,c=o[1],h=o[0].split("-");if(2==h.length)a=h[0]-1,d=h[1]-1;else{if(1!=h.length)continue;a=h[0]-1,d=a}s.push(a),i.push(d);for(let e=0;e<a-l-1;++e)t+="-";let p=d-a+1;c.length>p?t+=c.substr(0,p):t+=c;for(let e=0;e<p-c.length;++e)t+="-";l=d}return{text:t,fromArray:s,toArray:i}}setCustomFile(e,t,s,i){var n=this.icn3d,l=n.icn3dui;let r=this,o=$("#"+n.pre+"customcolor_chainid").val(),a=$("#"+n.pre+"cstcolorfile")[0].files[0];if(a){l.utilsCls.checkFileAPI();let n=new FileReader;n.onload=function(n){let a=r.icn3d,d=n.target.result.split("\n");void 0===a.queryresi2score&&(a.queryresi2score={}),a.queryresi2score[o]={};for(let e=0,t=d.length;e<t;++e)if(""!==d[e].trim()){let t=d[e].split(/\s+/);a.queryresi2score[o][t[0]]=t[1]}let c=Object.keys(a.queryresi2score[o]),h=Math.min.apply(null,c),p=Math.max.apply(null,c),m="";for(let e=h;e<=p;++e)a.queryresi2score[o].hasOwnProperty(e)?m+=Math.round(a.queryresi2score[o][e]/11):m+="_";if("color"==e){a.opts.color="align custom",a.setColorCls.setColorByOptions(a.opts,a.hAtoms),a.hlUpdateCls.updateHlAll(),l.htmlCls.clickMenuCls.setLogCmd("color align custom | "+o+" | range "+h+"_"+p+" | "+m+" | colorrange "+t+" "+s+" "+i,!0);let e=l.htmlCls.clickMenuCls.setLegendHtml();$("#"+l.pre+"dl_legend_html").html(e),l.htmlCls.dialogCls.openDlg("dl_legend","Color range")}else"tube"==e&&(a.setOptionCls.setStyle("proteins","custom tube"),l.htmlCls.clickMenuCls.setLogCmd("color tube | "+o+" | range "+h+"_"+p+" | "+m,!0));a.drawCls.draw()},n.readAsText(a)}else alert("Please select a file before clicking 'Load'")}async getMsa(e,t,s){let i=this.icn3d,n=i.icn3dui,l=[t],r=[],o=n.htmlCls.baseUrl+"/vastdyn/vastdyn.cgi?chainlist="+e,a=await n.getAjaxPromise(o,"jsonp"),d=0,c=0,h=0;for(let e in a){let t=a[e],s=e.indexOf(".");-1!=s&&(e=e.substr(0,s)),l.push(e),t.length>d&&(d=t.length,c=h),++h}o=n.htmlCls.baseUrl+"pwaln/pwaln.fcgi?from=msa";let p=e.split(","),m={};m[t]=0;for(let e=0,t=p.length;e<t;++e)m[p[e]]=e+1;let u=p[c];p.splice(c,1);let g=s||t;p.length>0&&(g+=","+p.join(","));let f={targets:u,queries:g},C=await n.getAjaxPostPromise(o,f);if(!C.data)return void console.log("The protein accessions "+u+","+g+" can not be aligned...");let b=[];i.qt_start_end={};let y=[],v=[],_=Object.keys(C.targets)[0],w=C.targets[_].seqdata;p.splice(0,0,t);for(let e=0,s=p.length;e<s;++e){let s,n,l;if(!C.data[e])continue;s=C.data[e].query,l=s.acc.length<=5?s.acc.substr(0,4)+"_"+s.acc.substr(4,1):s.acc,0==e&&(l=t),y.push(l),_=Object.keys(C.data[e].targets)[0],n=C.data[e].targets[_],n=n.hsps[0],v.push(s.seqdata);let r=100*n.scores.num_ident+s.sz;i.qt_start_end[e]=[];let o=n.segs;for(let t=0,s=o.length;t<s;++t){let s=o[t],n={t_start:s.orifrom,t_end:s.orito,q_start:s.from,q_end:s.to};i.qt_start_end[e].push(n)}b.push({index:e,alignLen:r})}p=y,b.sort((function(e,t){return t.alignLen-e.alignLen}));let S=9999,A=-1;for(let e=0,t=p.length;e<t;++e)if(i.qt_start_end[e])for(let t=0,s=i.qt_start_end[e].length;t<s;++t){let s,n;s=i.qt_start_end[e][t].t_start,n=i.qt_start_end[e][t].t_end;for(let e=s;e<=n;++e)e<S&&(S=e),e>A&&(A=e)}let x=S,k=w.length-(A+1),O=[],R=[];for(let e=0,t=p.length;e<t;++e){if(!i.qt_start_end[e])continue;let t=i.qt_start_end[e][0].q_start;O.push(t),x<t&&(x=t);let s=i.qt_start_end[e].length-1;t=i.qt_start_end[e][s].q_end,R.push(t);let n=v[e].length-(t+1);k<n&&(k=n)}i.msaSeq={},i.msaSeq[u]="";for(let e=S;e<=A;++e)i.msaSeq[u]+=w[e];let I=[0];for(let e=0,t=b.length;e<t;++e){let t=b[e].index;I.push(t),i.msaSeq[p[t]]="",v[t]&&i.setSeqAlignCls.mergeTwoSeqForAllSimple(u,p,t,I,S,A,v)}let E,T="";for(let e=0;e<x-S;++e)T+="-";for(let e=0;e<S;++e)T+=w[e];i.msaSeq[u]=T+i.msaSeq[u];for(let e=0,t=p.length;e<t;++e){T="";for(let t=0;t<x-O[e];++t)T+="-";for(let t=0;t<O[e];++t)T+=v[e][t];i.msaSeq[p[e]]=T+i.msaSeq[p[e]]}for(let e=A+1;e<w.length;++e)i.msaSeq[u]+=w[e];E=w.length-(A+1);for(let e=0;e<k-E;++e)i.msaSeq[u]+="-";for(let e=0,t=p.length;e<t;++e){for(let t=R[e]+1;t<v[e].length;++t)i.msaSeq[p[e]]+=v[e][t];E=v[e].length-(R[e]+1);for(let t=0;t<k-E;++t)i.msaSeq[p[e]]+="-"}for(let e in i.msaSeq){let t=m[e];r[t]=i.msaSeq[e],l[t]=e}let P=[],D=[];for(let e=0,t=r.length;e<t;++e)r[e]&&(D.push(r[e]),P.push(l[e]));let M=D[0];return D.splice(0,1),P.splice(0,1),{trackTitleArray:P,trackSeqArray:D,seqFirst:M}}async getIsoformMsa(e,t){let s=this.icn3d,i=s.icn3dui,n=[],l=[],r=i.htmlCls.baseUrl+"/vastdyn/vastdyn.cgi?chainlist="+e,o=await i.getAjaxPromise(r,"jsonp"),a=0,d=0,c=0,h=[],p=[];for(let e in o){let t=o[e];p.push(t);let s=e.indexOf(".");-1!=s&&(e=e.substr(0,s)),h.push(e),t.length>a&&(a=t.length,d=c),++c}s.qt_start_end={};let m="genomeRes",u={};for(let e=0,i=h.length;e<i;++e){let i=h[e];u[i]=e,s.qt_start_end[e]=[];let n=t[i];for(let t=0,i=n.length;t<i;++t){let i=n[t],l={t_start:s.exonOrder*i.genResStart,t_end:s.exonOrder*i.genResEnd,q_start:i.resStart,q_end:i.resEnd};s.qt_start_end[e].push(l)}}let g=999999999,f=-999999999;for(let e=0,t=h.length;e<t;++e)if(s.qt_start_end[e])for(let t=0,i=s.qt_start_end[e].length;t<i;++t){let i,n;i=s.qt_start_end[e][t].t_start,n=s.qt_start_end[e][t].t_end;for(let e=i;e<=n;++e)e<g&&(g=e),e>f&&(f=e)}for(let e=0,t=h.length;e<t;++e){let t=s.qt_start_end[e];for(let e=0,s=t.length;e<s;++e){let s=t[e];s.t_start-=g,s.t_end-=g}}s.msaSeq={},s.msaSeq[m]="";let C=f-g;for(let e=0;e<=C;++e)s.msaSeq[m]+="X";let b=[0];for(let e=0,t=h.length;e<t;++e)b.push(e),s.msaSeq[h[e]]="",p[e]&&s.setSeqAlignCls.mergeTwoSeqForAllSimple(m,h,e,b,0,C,p);for(let e in s.msaSeq){let t=u[e];void 0!==t&&(l[t]=s.msaSeq[e],n[t]=e)}let y=[];for(let e=0,t=l.length;e<t;++e)y[e]="";if(l[d])for(let e=0,t=l[d].length;e<t;++e){let t="-"!=l[d][e];if(!t)for(let s=0,i=l.length;s<i;++s)if("-"!=l[s][e]){t=!0;break}if(t)for(let t=0,s=l.length;t<s;++t)y[t]+=l[t][e]}return{trackTitleArray:n,trackSeqArray:y,maxIndex:d}}async showMsaTracks(e,t,s,i,n,l,r){let o=this.icn3d;o.icn3dui;for(let t=0,s=o.chainsSeq[e].length;t<s;++t){o.ParserUtilsCls.getResi(e,t)==n&&(o.startposGiSeq=t)}if(void 0===o.startposGiSeq)return void alert('Please double check the start position before clicking "Add Track"');o.targetGapHash={};let a,d,c="-",h=0,p=0,m=0,u=!1,g=0,f=0,C=t.length;o.seqStartLen||(o.seqStartLen={}),o.seqEndLen||(o.seqEndLen={});for(let s=0,i=t.length;s<i;++s)"-"==t[s]&&t[s]!=c&&(a=p,m=0),"-"==c&&t[s]!=c&&p>0&&(d=h,o.targetGapHash[a+o.startposGiSeq]={from:a+o.startposGiSeq,to:d+m-1+o.startposGiSeq}),c=t[s],h=p,"-"!=t[s]?(++p,f=s,o.seqEndLen[e]=C-1-f,u||(g=s,o.seqStartLen[e]=g,u=!0)):++m;o.maxAnnoLength<o.maxAnnoLengthOri+o.seqStartLen[e]+o.seqEndLen[e]&&(o.maxAnnoLength=o.maxAnnoLengthOri+o.seqStartLen[e]+o.seqEndLen[e]),await o.showAnnoCls.processSeqData(o.chainid_seq);let b="",y=0;for(let e in o.targetGapHash)y>0&&(b+=" "),b+=e+"_"+o.targetGapHash[e].from+"_"+o.targetGapHash[e].to,++y;let v={};for(let a=0,d=i.length;a<d;++a){let d=n,c="";for(let e=0;e<o.startposGiSeq;++e){if(o.targetGapHash.hasOwnProperty(e))for(let t=0;t<o.targetGapHash[e].to-o.targetGapHash[e].from+1;++t)c+="-";c+="-"}let h,p="-",m=[],u=[],g=!1,f=0,b=0,y=[];for(let s=0;s<C;++s)0==a&&(v[d]=0),h=i[a][s],"-"!=h&&(g||(f=s,g=!0,b=o.startposGiSeq-o.seqStartLen[e]+f)),"-"==p&&"-"!=h&&(m.push(s),y.push(b)),"-"!=p&&"-"==h&&u.push(s-1),s>=o.seqStartLen[e]&&("-"==t[s]&&b--,"-"==h&&b++),c+=h,"-"!=t[s]&&(t[s]==i[a][s]&&++v[d],++d),p=h;"-"!=p&&u.push(C-1);let _=s[a].length<20?s[a]:s[a].substr(0,20)+"...",w=!0,S=r?r[s[a]]:void 0;this.showNewTrack(e,_,c,void 0,void 0,l,void 0,w,m,u,f,S,y)}o.opts.color="exon",o.legendTableCls.showColorLegend(o.opts.color),o.hlUpdateCls.updateHlAll(),o.drawCls.draw()}processAccList(e){this.icn3d.icn3dui;let t=e.split(","),s={},i="";for(let e=0,n=t.length;e<n;++e){let n=t[e];if(s.hasOwnProperty(n))continue;s[n]=1;let l=n.indexOf(".");i+=-1!=l?n.substr(0,l):n,e<t.length-1&&(i+=",")}return i}async addExonTracksWrap(){let e=this.icn3d;e.icn3dui;let t=$("#"+e.pre+"track_chainid").val(),s=$("#"+e.pre+"track_geneid").val();if(!s)return void alert("Please fill in the Gene ID...");let i=$("#"+e.pre+"fasta_startpos2").val();i||(i=1);await this.addExonTracks(t,s,i,"identity")}async addExonTracks(e,t,s,i){let n,l=this.icn3d,r=l.icn3dui,o=[],a=[],d=r.htmlCls.baseUrl+"/vastdyn/vastdyn.cgi?geneid2isoforms="+t,c=await r.getAjaxPromise(d,"jsonp"),h=c.acclist,p=c.exons,m={},u="";l.exonOrder=1;for(let e=0,t=h.length;e<t;++e){let s=h[e],i=s.indexOf("."),n=-1!=i?s.substr(0,i):s,r=0,o=0,a=[];for(let e=0,t=p[s].length;e<t;++e){let i=p[s][e].split("-");i[0]=parseInt(i[0]),i[1]=parseInt(i[1]),i[2]=parseInt(i[2]),l.exonOrder=i[0]<i[1]?1:-1;let n=i[0]+"-"+i[1];r+=e==t-1?i[2]-3:i[2];let d=parseInt((o+2)/3),c=parseInt((r+2)/3)-1,h=parseInt((i[1]+2)/3),m=h-l.exonOrder*(c-d);a.push({genomeRange:n,genResStart:m,genResEnd:h,resStart:d,resEnd:c}),o=r}m[n]=a,u+=n,e<t-1&&(u+=",")}let g=await this.getIsoformMsa(u,m);o=g.trackTitleArray,a=g.trackSeqArray;let f,C=g.maxIndex,b=o[C],y=e.substr(0,e.indexOf("_"));if(y.length>5?(l.uniprot2acc&&l.uniprot2acc[y]&&(y=l.uniprot2acc[y]),f=y):f=e,y.length>5){let e="";for(let t=0,s=l.chainsSeq.length;t<s;++t)e+=l.chainsSeq[t].resn;g=await this.getMsa(b,f,e)}else g=await this.getMsa(b,f);g.trackTitleArray;let v=g.trackSeqArray;n=g.seqFirst;let _=a[C],w=v[0],S=0,A=0,x=a.length;for(;_&&w&&S<_.length&&A<w.length;){if(_[S]!=w[A])if("-"==_[S])w=w.substr(0,A)+"-"+w.substr(A),n=n.substr(0,A)+"-"+n.substr(A);else for(let e=0;e<x;++e)a[e]=a[e].substr(0,S)+"-"+a[e].substr(S);++S,++A}await this.showMsaTracks(e,n,o,a,s,i,m),r.htmlCls.clickMenuCls.setLogCmd("add exon track | chainid "+e+" | geneid "+t+" | startpos "+s+" | type "+i,!0),r.htmlCls.clickMenuCls.setLogCmd("set annotation custom",!0)}async addMsaTracks(e,t,s,i){let n,l=this.icn3d.icn3dui,r=[],o=[],a=i.split(">"),d=a[1].indexOf("\n");n=a[1].substr(d+1).replace(/\n/g,"");for(let e=2,t=a.length;e<t;++e){let t=a[e].indexOf("\n"),s=a[e].substr(0,t);-1!=s.indexOf("|")&&(s=s.split("|")[1]),r.push(s);let i=a[e].substr(t+1).replace(/\n/g,"");o.push(i)}await this.showMsaTracks(e,n,r,o,t,s),l.htmlCls.clickMenuCls.setLogCmd("add msa track | chainid "+e+" | startpos "+t+" | type "+s+" | fastaList "+i,!0)}}class Pt{constructor(e){this.icn3d=e}hideAllAnno(){let e=this.icn3d;e.icn3dui,this.setAnnoSeqBase(!1),$("[id^="+e.pre+"custom]").hide()}setAnnoSeqBase(e){let t=this.icn3d;t.icn3dui;let s=["cdd","clinvar","snp","site","ptm","ssbond","crosslink","transmem","domain","interaction","ig"];for(let i in s){let n=s[i];e?$("[id^="+t.pre+n+"]").show():$("[id^="+t.pre+n+"]").hide()}}setAnnoTabBase(e){let t=this.icn3d;t.icn3dui;let s=["all","cdd","clinvar","snp","binding","ptm","ssbond","crosslink","transmem","3dd","custom","interact","ig"];for(let i in s){let n=s[i];$("#"+t.pre+"anno_"+n).length&&($("#"+t.pre+"anno_"+n)[0].checked=e)}}async setAnnoTabAll(){let e=this.icn3d;e.icn3dui,this.setAnnoTabBase(!0),this.setAnnoSeqBase(!0),await this.updateClinvar(),await this.updateSnp(),this.updateDomain(),await this.updatePTM(),this.updateSsbond(),this.updateCrosslink(),await this.updateTransmem(),e.bRunRefnumAgain=!0,await this.updateIg(),e.bRunRefnumAgain=!1,this.updateInteraction()}hideAnnoTabAll(){this.icn3d.icn3dui,this.setAnnoTabBase(!1),this.hideAllAnno()}async resetAnnoAll(){let e=this.icn3d;e.icn3dui,$("[id^="+e.pre+"dt_]").html(""),$("[id^="+e.pre+"tt_]").html(""),$("[id^="+e.pre+"ov_]").html(""),await e.showAnnoCls.processSeqData(e.chainid_seq),this.setAnnoViewAndDisplay("detailed view"),await this.resetAnnoTabAll()}async resetAnnoTabAll(){let e=this.icn3d;e.icn3dui,$("#"+e.pre+"anno_binding").length&&$("#"+e.pre+"anno_binding")[0].checked&&$("[id^="+e.pre+"site]").show(),$("#"+e.pre+"anno_snp").length&&$("#"+e.pre+"anno_snp")[0].checked&&(e.bSnpShown=!1,await this.updateSnp(),$("[id^="+e.pre+"snp]").show()),$("#"+e.pre+"anno_clinvar").length&&$("#"+e.pre+"anno_clinvar")[0].checked&&(e.bClinvarShown=!1,await this.updateClinvar(),$("[id^="+e.pre+"clinvar]").show()),$("#"+e.pre+"anno_cdd").length&&$("#"+e.pre+"anno_cdd")[0].checked&&$("[id^="+e.pre+"cdd]").show(),$("#"+e.pre+"anno_3dd").length&&$("#"+e.pre+"anno_3dd")[0].checked&&($("[id^="+e.pre+"domain]").show(),e.bDomainShown=!1,this.updateDomain()),$("#"+e.pre+"anno_interact").length&&$("#"+e.pre+"anno_interact")[0].checked&&($("[id^="+e.pre+"interaction]").show(),e.bInteractionShown=!1,this.updateInteraction()),$("#"+e.pre+"anno_ptm").length&&$("#"+e.pre+"anno_ptm")[0].checked&&(e.bPTMShown=!1,await this.updatePTM(),$("[id^="+e.pre+"ptm]").show()),$("#"+e.pre+"anno_custom").length&&$("#"+e.pre+"anno_custom")[0].checked&&$("[id^="+e.pre+"custom]").show(),$("#"+e.pre+"anno_ssbond").length&&$("#"+e.pre+"anno_ssbond")[0].checked&&($("[id^="+e.pre+"ssbond]").show(),e.bSSbondShown=!1,this.updateSsbond()),$("#"+e.pre+"anno_crosslink").length&&$("#"+e.pre+"anno_crosslink")[0].checked&&($("[id^="+e.pre+"crosslink]").show(),e.bCrosslinkShown=!1,this.updateCrosslink()),$("#"+e.pre+"anno_transmem").length&&$("#"+e.pre+"anno_transmem")[0].checked&&(e.bTranememShown=!1,await this.updateTransmem(),$("[id^="+e.pre+"transmem]").show()),($("#"+e.pre+"anno_ig").length&&$("#"+e.pre+"anno_ig")[0].checked||e.bShowRefnum)&&(e.bRunRefnumAgain=!1,await this.updateIg(),$("[id^="+e.pre+"ig]").show())}setAnnoTabCustom(){let e=this.icn3d;e.icn3dui,$("[id^="+e.pre+"custom]").show(),$("#"+e.pre+"anno_custom").length&&($("#"+e.pre+"anno_custom")[0].checked=!0)}hideAnnoTabCustom(){let e=this.icn3d;e.icn3dui,$("[id^="+e.pre+"custom]").hide(),$("#"+e.pre+"anno_custom").length&&($("#"+e.pre+"anno_custom")[0].checked=!1)}async setAnnoTabClinvar(){let e=this.icn3d;e.icn3dui,await this.updateClinvar(),$("[id^="+e.pre+"clinvar]").show(),$("#"+e.pre+"anno_clinvar").length&&($("#"+e.pre+"anno_clinvar")[0].checked=!0)}hideAnnoTabClinvar(){let e=this.icn3d;e.icn3dui,$("[id^="+e.pre+"clinvar]").hide(),$("#"+e.pre+"anno_clinvar").length&&($("#"+e.pre+"anno_clinvar")[0].checked=!1)}async setAnnoTabSnp(){let e=this.icn3d;e.icn3dui,await this.updateSnp(),$("[id^="+e.pre+"snp]").show(),$("#"+e.pre+"anno_snp").length&&($("#"+e.pre+"anno_snp")[0].checked=!0)}hideAnnoTabSnp(){let e=this.icn3d;e.icn3dui,$("[id^="+e.pre+"snp]").hide(),$("#"+e.pre+"anno_snp").length&&($("#"+e.pre+"anno_snp")[0].checked=!1)}setAnnoTabCdd(){let e=this.icn3d;e.icn3dui,$("[id^="+e.pre+"cdd]").show(),$("#"+e.pre+"anno_cdd").length&&($("#"+e.pre+"anno_cdd")[0].checked=!0)}hideAnnoTabCdd(){let e=this.icn3d;e.icn3dui,$("[id^="+e.pre+"cdd]").hide(),$("#"+e.pre+"anno_cdd").length&&($("#"+e.pre+"anno_cdd")[0].checked=!1)}setAnnoTab3ddomain(){let e=this.icn3d;e.icn3dui,this.updateDomain(),$("[id^="+e.pre+"domain]").show(),$("#"+e.pre+"anno_3dd").length&&($("#"+e.pre+"anno_3dd")[0].checked=!0)}hideAnnoTab3ddomain(){let e=this.icn3d;e.icn3dui,$("[id^="+e.pre+"domain]").hide(),$("#"+e.pre+"anno_3dd").length&&($("#"+e.pre+"anno_3dd")[0].checked=!1)}setAnnoTabSite(){let e=this.icn3d;e.icn3dui,$("[id^="+e.pre+"site]").show(),$("[id^="+e.pre+"feat]").show(),$("#"+e.pre+"anno_binding").length&&($("#"+e.pre+"anno_binding")[0].checked=!0)}hideAnnoTabSite(){let e=this.icn3d;e.icn3dui,$("[id^="+e.pre+"site]").hide(),$("[id^="+e.pre+"feat]").hide(),$("#"+e.pre+"anno_binding").length&&($("#"+e.pre+"anno_binding")[0].checked=!1)}setAnnoTabInteraction(){let e=this.icn3d;e.icn3dui,$("[id^="+e.pre+"interaction]").show(),$("#"+e.pre+"anno_interact").length&&($("#"+e.pre+"anno_interact")[0].checked=!0),this.updateInteraction()}hideAnnoTabInteraction(){let e=this.icn3d;e.icn3dui,$("[id^="+e.pre+"interaction]").hide(),$("#"+e.pre+"anno_interact").length&&($("#"+e.pre+"anno_interact")[0].checked=!1)}async setAnnoTabPTM(){let e=this.icn3d;e.icn3dui,await this.updatePTM(),$("[id^="+e.pre+"ptm]").show(),$("#"+e.pre+"anno_ptm").length&&($("#"+e.pre+"anno_ptm")[0].checked=!0)}hideAnnoTabPTM(){let e=this.icn3d;e.icn3dui,$("[id^="+e.pre+"ptm]").hide(),$("#"+e.pre+"anno_ptm").length&&($("#"+e.pre+"anno_ptm")[0].checked=!1)}setAnnoTabSsbond(){let e=this.icn3d;e.icn3dui,$("[id^="+e.pre+"ssbond]").show(),$("#"+e.pre+"anno_ssbond").length&&($("#"+e.pre+"anno_ssbond")[0].checked=!0),this.updateSsbond()}hideAnnoTabSsbond(){let e=this.icn3d;e.icn3dui,$("[id^="+e.pre+"ssbond]").hide(),$("#"+e.pre+"anno_ssbond").length&&($("#"+e.pre+"anno_ssbond")[0].checked=!1)}setAnnoTabCrosslink(){let e=this.icn3d;e.icn3dui,$("[id^="+e.pre+"crosslink]").show(),$("#"+e.pre+"anno_crosslink").length&&($("#"+e.pre+"anno_crosslink")[0].checked=!0),this.updateCrosslink()}hideAnnoTabCrosslink(){let e=this.icn3d;e.icn3dui,$("[id^="+e.pre+"crosslink]").hide(),$("#"+e.pre+"anno_crosslink").length&&($("#"+e.pre+"anno_crosslink")[0].checked=!1)}async setAnnoTabTransmem(){let e=this.icn3d;e.icn3dui,await this.updateTransmem(),$("[id^="+e.pre+"transmem]").show(),$("#"+e.pre+"anno_transmem").length&&($("#"+e.pre+"anno_transmem")[0].checked=!0)}hideAnnoTabTransmem(){let e=this.icn3d;e.icn3dui,$("[id^="+e.pre+"transmem]").hide(),$("#"+e.pre+"anno_transmem").length&&($("#"+e.pre+"anno_transmem")[0].checked=!1)}async setAnnoTabIg(e,t){let s=this.icn3d;s.icn3dui,await this.updateIg(e,t),$("[id^="+s.pre+"ig]").show(),$("#"+s.pre+"anno_ig").length&&($("#"+s.pre+"anno_ig")[0].checked=!0)}hideAnnoTabIg(){let e=this.icn3d;e.icn3dui,$("[id^="+e.pre+"ig]").hide(),$("#"+e.pre+"anno_ig").length&&($("#"+e.pre+"anno_ig")[0].checked=!1)}setTabs(){let e=this.icn3d,t=e.icn3dui,s=this;$("#"+e.pre+"dl_addtrack_tabs").tabs(),$("#"+e.pre+"dl_anno_view_tabs").tabs(),t.myEventCls.onIds("#"+e.pre+"anno_all","click",(async function(i){$("#"+e.pre+"anno_all")[0].checked?(await s.setAnnoTabAll(),t.htmlCls.clickMenuCls.setLogCmd("set annotation all",!0)):(s.hideAnnoTabAll(),t.htmlCls.clickMenuCls.setLogCmd("hide annotation all",!0))})),t.myEventCls.onIds("#"+e.pre+"anno_binding","click",(function(i){$("#"+e.pre+"anno_binding")[0].checked?(s.setAnnoTabSite(),t.htmlCls.clickMenuCls.setLogCmd("set annotation site",!0)):(s.hideAnnoTabSite(),t.htmlCls.clickMenuCls.setLogCmd("hide annotation site",!0))})),t.myEventCls.onIds("#"+e.pre+"anno_snp","click",(async function(i){$("#"+e.pre+"anno_snp")[0].checked?(await s.setAnnoTabSnp(),t.htmlCls.clickMenuCls.setLogCmd("set annotation snp",!0)):(s.hideAnnoTabSnp(),t.htmlCls.clickMenuCls.setLogCmd("hide annotation snp",!0))})),t.myEventCls.onIds("#"+e.pre+"anno_clinvar","click",(async function(i){$("#"+e.pre+"anno_clinvar")[0].checked?(await s.setAnnoTabClinvar(),t.htmlCls.clickMenuCls.setLogCmd("set annotation clinvar",!0)):(s.hideAnnoTabClinvar(),t.htmlCls.clickMenuCls.setLogCmd("hide annotation clinvar",!0))})),t.myEventCls.onIds("#"+e.pre+"anno_cdd","click",(function(e){s.clickCdd()})),t.myEventCls.onIds("#"+e.pre+"anno_3dd","click",(function(i){$("#"+e.pre+"anno_3dd")[0].checked?(s.setAnnoTab3ddomain(),t.htmlCls.clickMenuCls.setLogCmd("set annotation 3ddomain",!0)):(s.hideAnnoTab3ddomain(),t.htmlCls.clickMenuCls.setLogCmd("hide annotation 3ddomain",!0))})),t.myEventCls.onIds("#"+e.pre+"anno_interact","click",(function(i){$("#"+e.pre+"anno_interact")[0].checked?(s.setAnnoTabInteraction(),t.htmlCls.clickMenuCls.setLogCmd("set annotation interaction",!0)):(s.hideAnnoTabInteraction(),t.htmlCls.clickMenuCls.setLogCmd("hide annotation interaction",!0))})),t.myEventCls.onIds("#"+e.pre+"anno_ptm","click",(async function(i){$("#"+e.pre+"anno_ptm")[0].checked?(await s.setAnnoTabPTM(),t.htmlCls.clickMenuCls.setLogCmd("set annotation ptm",!0)):(s.hideAnnoTabPTM(),t.htmlCls.clickMenuCls.setLogCmd("hide annotation ptm",!0))})),t.myEventCls.onIds("#"+e.pre+"anno_custom","click",(function(i){$("#"+e.pre+"anno_custom")[0].checked?(s.setAnnoTabCustom(),t.htmlCls.clickMenuCls.setLogCmd("set annotation custom",!0)):(s.hideAnnoTabCustom(),t.htmlCls.clickMenuCls.setLogCmd("hide annotation custom",!0))})),t.myEventCls.onIds("#"+e.pre+"anno_ssbond","click",(function(i){$("#"+e.pre+"anno_ssbond")[0].checked?(s.setAnnoTabSsbond(),t.htmlCls.clickMenuCls.setLogCmd("set annotation ssbond",!0)):(s.hideAnnoTabSsbond(),t.htmlCls.clickMenuCls.setLogCmd("hide annotation ssbond",!0))})),t.myEventCls.onIds("#"+e.pre+"anno_crosslink","click",(function(i){$("#"+e.pre+"anno_crosslink")[0].checked?(s.setAnnoTabCrosslink(),t.htmlCls.clickMenuCls.setLogCmd("set annotation crosslink",!0)):(s.hideAnnoTabCrosslink(),t.htmlCls.clickMenuCls.setLogCmd("hide annotation crosslink",!0))})),t.myEventCls.onIds("#"+e.pre+"anno_transmem","click",(async function(i){$("#"+e.pre+"anno_transmem").length&&$("#"+e.pre+"anno_transmem")[0].checked?(await s.setAnnoTabTransmem(),t.htmlCls.clickMenuCls.setLogCmd("set annotation transmembrane",!0)):(s.hideAnnoTabTransmem(),t.htmlCls.clickMenuCls.setLogCmd("hide annotation transmembrane",!0))})),t.myEventCls.onIds("#"+e.pre+"anno_ig","click",(async function(i){$("#"+e.pre+"anno_ig").length&&$("#"+e.pre+"anno_ig")[0].checked?(e.bRunRefnumAgain=!0,await s.setAnnoTabIg(),t.htmlCls.clickMenuCls.setLogCmd("set annotation ig",!0),e.bRunRefnumAgain=!1):(s.hideAnnoTabIg(),t.htmlCls.clickMenuCls.setLogCmd("hide annotation ig",!0))}))}clickCdd(){let e=this.icn3d,t=e.icn3dui;$("[id^="+e.pre+"cdd]").length>0&&($("#"+e.pre+"anno_cdd")[0].checked?(this.setAnnoTabCdd(),t.htmlCls.clickMenuCls.setLogCmd("set annotation cdd",!0)):(this.hideAnnoTabCdd(),t.htmlCls.clickMenuCls.setLogCmd("hide annotation cdd",!0)))}showAnnoSelectedChains(){let e=this.icn3d,t=e.icn3dui,s={};for(let t in e.hAtoms){let i=e.atoms[t];s[i.structure+"_"+i.chain]=1}$("#"+e.pre+"dl_annotations > .icn3d-annotation").hide();for(let i in s){$("#"+e.pre+"anno_"+i).length&&$("#"+e.pre+"anno_"+i).show();let s=e.firstAtomObjCls.getFirstCalphaAtomObj(e.chains[i]);if(s&&void 0!==s.resn){let i=t.utilsCls.residueName2Abbr(s.resn.substr(0,3));$("#"+e.pre+"anno_"+i).show()}}}showAnnoAllChains(){let e=this.icn3d;e.icn3dui,$("#"+e.pre+"dl_annotations > .icn3d-annotation").show()}setAnnoView(e){let t=this.icn3d;t.icn3dui.bNode||("detailed view"===e?(t.view="detailed view",$("#"+t.pre+"dl_anno_view_tabs").tabs("option","active",1)):(t.view="overview",$("#"+t.pre+"dl_anno_view_tabs").tabs("option","active",0)))}setAnnoDisplay(e,t){let s=this.icn3d;s.icn3dui;let i=["giseq","custom","site","ptm","snp","clinvar","cdd","domain","interaction","ssbond","crosslink","transmem","ig"];for(let n in i){let l=i[n];$("[id^="+s.pre+t+"_"+l+"]").attr("style",e)}}showFixedTitle(){this.icn3d.icn3dui;this.setAnnoDisplay("display:block;","tt")}hideFixedTitle(){this.icn3d.icn3dui;this.setAnnoDisplay("display:none!important;","tt")}setAnnoViewAndDisplay(e){let t=this.icn3d;if(t.icn3dui,"detailed view"===e){this.setAnnoView("detailed view");let e="display:block;";this.setAnnoDisplay(e,"dt"),$("#"+t.pre+"seqguide_wrapper").attr("style",e),e="display:none;",this.setAnnoDisplay(e,"ov")}else{this.setAnnoView("overview"),this.hideFixedTitle();let e="display:none;";this.setAnnoDisplay(e,"dt"),$("#"+t.pre+"seqguide_wrapper").attr("style",e),e="display:block;",this.setAnnoDisplay(e,"ov")}}async updateClinvar(){let e=this.icn3d;if(e.icn3dui,void 0===e.bClinvarShown||!e.bClinvarShown)for(let t in e.protein_chainid){let s=e.protein_chainid[t];await e.annoSnpClinVarCls.showClinvar(t,s)}e.bClinvarShown=!0}async updateSnp(){let e=this.icn3d;if(e.icn3dui,void 0===e.bSnpShown||!e.bSnpShown)for(let t in e.protein_chainid){let s=e.protein_chainid[t];await e.annoSnpClinVarCls.showSnp(t,s)}e.bSnpShown=!0}updateDomain(){let e=this.icn3d;e.icn3dui,void 0!==e.bDomainShown&&e.bDomainShown||e.annoDomainCls.showDomainAll(),e.bDomainShown=!0}updateInteraction(){let e=this.icn3d;if(e.icn3dui,void 0===e.bInteractionShown||!e.bInteractionShown)for(let t in e.interactChainbase){let s=e.interactChainbase[t];e.annoContactCls.showInteraction(t,s)}e.bInteractionShown=!0}async updatePTM(){let e=this.icn3d;if(e.icn3dui,void 0===e.bPTMShown||!e.bPTMShown)for(let t in e.PTMChainbase){let s=e.PTMChainbase[t];await e.annoPTMCls.showPTM(t,s,"ptm")}e.bPTMShown=!0}updateSsbond(){let e=this.icn3d;if(e.icn3dui,void 0===e.bSSbondShown||!e.bSSbondShown)for(let t in e.ssbondChainbase){let s=e.ssbondChainbase[t];e.annoSsbondCls.showSsbond(t,s)}e.bSSbondShown=!0}updateCrosslink(){let e=this.icn3d;if(e.icn3dui,void 0===e.bCrosslinkShown||!e.bCrosslinkShown)for(let t in e.crosslinkChainbase){let s=e.crosslinkChainbase[t];e.annoCrossLinkCls.showCrosslink(t,s)}e.bCrosslinkShown=!0}async updateTransmem(){let e=this.icn3d,t=e.icn3dui;if(void 0===e.bTranememShown||!e.bTranememShown)for(let s in e.protein_chainid){let i=e.protein_chainid[s];if(void 0!==t.cfg.opmid)e.annoTransMemCls.showTransmem(s,i);else if(e.bAfMem&&e.afmem_start_end){let t=e.afmem_start_end[0],n=e.afmem_start_end[1];await e.annoPTMCls.showPTM(s,i,"afmem",t,n)}else await e.annoPTMCls.showPTM(s,i,"transmem")}e.bTranememShown=!0}async updateIg(e,t){let s=this.icn3d,i=s.icn3dui;if(s.opts.color="ig strand",!e){s.hAtoms={};for(let e in s.protein_chainid)s.hAtoms=i.hashUtilsCls.unionHash(s.hAtoms,s.chains[e])}let n=s.firstAtomObjCls.getResiduesFromAtoms(s.hAtoms);for(let e in n)s.resid2refnum&&delete s.resid2refnum[e],s.residIgLoop&&delete s.residIgLoop[e],s.resid2domainid&&delete s.resid2domainid[e];s.bRunRefnumAgain=!0;let l=e?s.firstAtomObjCls.getChainsFromAtoms(s.hAtoms):s.protein_chainid;for(let e in l)await s.annoIgCls.showIg(e,t),s.bRunRefnumAgain=!1;s.bShowRefnum&&(s.hlUpdateCls.updateHlAll(),s.drawCls.draw())}}class Dt{constructor(e){this.icn3d=e}showAnnotations_part1(e){let t=this.icn3d,s=t.icn3dui;if(s.htmlCls.dialogCls.openDlg("dl_selectannotations","Sequences and Annotations"),(void 0===t.bAssemblyNote||!t.bAssemblyNote)&&void 0!==t.asuCnt){let e="     <br><div id='"+t.pre+"assembly_note' style='margin-left:5px;'><span class='icn3d-annoLargeTitle'>Assembly Tips:</span> Only the asymmetric unit is shown in the sequence window.<br>Click \"Assembly\" in the menu \"View\" to switch between asymmetric unit and biological assembly(<b>"+t.asuCnt+"</b> asymmetric unit).</div>";$("#"+t.pre+"dl_annotations_tabs").append(e),t.bAssemblyNote=!0}t.bResetAnno&&(t.giSeq={},t.currClin={},t.resi2disease_nonempty={},t.baseResi={},t.matchedPos={},$("#"+s.pre+"dl_annotations").empty(),t.annotationCls.setAnnoView("overview"));let i={},n={},l={};if(void 0===t.bAnnoShown||!t.bAnnoShown||t.bResetAnno){t.protein_chainid={};let r,o=Object.keys(t.chains);if(e){let s=t.resid2specCls.atoms2structureArray(e);o=[];for(let e=0,i=s.length;e<i;++e)o=o.concat(t.structures[s[e]])}void 0===t.giSeq&&(t.giSeq={}),void 0===t.currClin&&(t.currClin={}),void 0===t.resi2disease_nonempty&&(t.resi2disease_nonempty={}),void 0===t.baseResi&&(t.baseResi={}),void 0===t.matchedPos&&(t.matchedPos={}),r=s.bNode?500:s.cfg.notebook?s.htmlCls.WIDTH/2:$("#"+t.pre+"dl_selectannotations").dialog("option","width"),t.seqAnnWidth=r-120-60-50;for(let e=0,r=o.length;e<r;++e){Math.round(o[e].indexOf("_"));let r=t.firstAtomObjCls.getMiddleAtomObj(t.chains[o[e]],100);if(void 0===r&&(r=t.firstAtomObjCls.getFirstAtomObj(t.chains[o[e]])),void 0===r)continue;let a,d=o[e].substr(o[e].indexOf("_")+1);if(-1!==d.indexOf("_")?(d=d.substr(0,d.indexOf("_")),a=o[e].substr(0,o[e].indexOf("_"))+"_"+d):d.length>1&&"1"==d.substr(d.length-1)?(d=d.substr(0,d.length-1),a=o[e].substr(0,o[e].indexOf("_"))+"_"+d):a=o[e],t.proteins.hasOwnProperty(r.serial)&&t.chainsSeq[o[e]].length>1)t.protein_chainid[o[e]]=a;else if(t.nucleotides.hasOwnProperty(r.serial)&&t.chainsSeq[o[e]].length>1)i[o[e]]=a;else if(t.chainsSeq[o[e]].length>1)n[o[e]]=a;else{let s=t.chainsSeq[o[e]][0].name,i=o[e]+"_"+t.chainsSeq[o[e]][0].resi;void 0===l[s]&&(l[s]=[]),l[s].push(i)}if((void 0!==s.cfg.pdbid||void 0!==s.cfg.opmid||void 0!==s.cfg.mmcifid||void 0!==s.cfg.mmtfid)&&(t.proteins.hasOwnProperty(r.serial)||t.nucleotides.hasOwnProperty(r.serial)))for(let s=0,i=t.chainsSeq[o[e]].length;s<i;++s){let i=t.chainsSeq[o[e]][s];if(""!==i.name&&"-"!==i.name&&i.name==i.name.toUpperCase()){let s=o[e]+"_"+i.resi,n=t.firstAtomObjCls.getFirstCalphaAtomObj(t.residues[s]);if(void 0===n&&(n=t.firstAtomObjCls.getFirstAtomObj(t.chains[o[e]])),t.proteins.hasOwnProperty(n.serial)||t.nucleotides.hasOwnProperty(n.serial))continue;{let e=i.name.trim();void 0===l[e]&&(l[e]=[]),l[e].push(s)}}}}t.maxAnnoLengthOri=1;for(let e in t.chainsSeq)t.chainsSeq[e].length>t.maxAnnoLengthOri&&(t.protein_chainid.hasOwnProperty(e)||i.hasOwnProperty(e))&&(t.maxAnnoLengthOri=t.chainsSeq[e].length);t.maxAnnoLength=t.maxAnnoLengthOri}return{nucleotide_chainid:i,chemical_chainid:n,chemical_set:l}}async showAnnotations(e){let t=this.icn3d,s=t.icn3dui,i=this,n=this.showAnnotations_part1(e),l=n.nucleotide_chainid,r=n.chemical_chainid,o=n.chemical_set;if(!t.bAnnoShown||t.bResetAnno)if(t.bAnnoShown=!0,void 0===s.cfg.blast_rep_id){if(t.bFullUi){if(void 0!==s.cfg.mmtfid){let e=Object.keys(t.structures)[0];await t.mmcifParserCls.downloadMmcifSymmetry(e,"mmtfid")}await this.showAnnoSeqData(l,r,o)}}else if(void 0===s.cfg.blast_rep_id||t.bSmithwm||t.bLocalSmithwm){if(void 0!==s.cfg.blast_rep_id&&(t.bSmithwm||t.bLocalSmithwm)){let e,n,a=[s.cfg.blast_rep_id];if(-1!=s.cfg.query_id.indexOf(">")?n=s.cfg.query_id.substr(s.cfg.query_id.indexOf("\n")+1):!/\d/.test(s.cfg.query_id)||s.cfg.query_id.length>50?n=s.cfg.query_id:a.push(s.cfg.query_id),t.blastAcxn){let i=s.cfg.afid+"_A",n="";for(let e=0,s=t.chainsSeq[i].length;e<s;++e)n+=t.chainsSeq[i][e].name;e=n}else{let t=s.htmlCls.baseUrl+"/vastdyn/vastdyn.cgi?chainlist="+a,i=await s.getAjaxPromise(t,"jsonp",!1,"Can not retrieve the sequence of the accession(s) "+a.join(", "));for(let t in i)e=i[t]}let d=1,c=-1,h=-1,p=-1,m=!!t.bLocalSmithwm;t.seqStructAlignDataLocalSmithwm=t.alignSWCls.alignSW(e,n,d,c,h,p,m),await i.showAnnoSeqData(l,r,o)}}else{let e=s.htmlCls.baseUrl+"pwaln/pwaln.fcgi?from=querytarget",n={targets:s.cfg.blast_rep_id,queries:s.cfg.query_id};if(void 0!==s.cfg.query_from_to){let e=s.cfg.query_from_to.split(":");for(let t=0,s=e.length;t<s;++t)e[t]=parseInt(e[t])-1;n.queries=s.cfg.query_id+":"+e.join(":")}if(void 0!==s.cfg.target_from_to){let e=s.cfg.target_from_to.split(":");for(let t=0,s=e.length;t<s;++t)e[t]=parseInt(e[t])-1;n.targets=s.cfg.blast_rep_id+":"+e.join(":")}if(t.blastAcxn){let e=s.cfg.afid+"_A",i="";for(let s=0,n=t.chainsSeq[e].length;s<n;++s)i+=t.chainsSeq[e][s].name;n.targets=i}let a=await s.getAjaxPostPromise(e,n);t.seqStructAlignData=a,await i.showAnnoSeqData(l,r,o)}}async showAnnoSeqData(e,t,s){let i=this.icn3d,n=i.icn3dui;n.bNode||await this.getAnnotationData();let l=0;for(let t in e)this.getSequenceData(t,e[t],"nucleotide",l),++l;i.interactChainbase=n.hashUtilsCls.unionHash(i.interactChainbase,i.protein_chainid),i.interactChainbase=n.hashUtilsCls.unionHash(i.interactChainbase,e),l=0;for(let e in t)this.getSequenceData(e,t[e],"chemical",l),++l;i.interactChainbase=n.hashUtilsCls.unionHash(i.interactChainbase,t),i.PTMChainbase=n.hashUtilsCls.unionHash(i.PTMChainbase,i.protein_chainid),i.ssbondChainbase=n.hashUtilsCls.unionHash(i.ssbondChainbase,i.protein_chainid),i.ssbondChainbase=n.hashUtilsCls.unionHash(i.ssbondChainbase,t),i.crosslinkChainbase=n.hashUtilsCls.unionHash(i.crosslinkChainbase,i.protein_chainid),i.crosslinkChainbase=n.hashUtilsCls.unionHash(i.crosslinkChainbase,e),i.crosslinkChainbase=n.hashUtilsCls.unionHash(i.crosslinkChainbase,t);for(let e in s)this.getCombinedSequenceData(e,s[e],l),++l;n.bNode||(this.enableHlSeq(),i.annotationCls.hideAllAnno(),i.annotationCls.clickCdd())}async getAnnotationData(){let e=this.icn3d,t=e.icn3dui,s=this,i=$.map(e.protein_chainid,(function(e){return e})),n=0;e.chainsGene||(e.chainsGene={});for(let s in e.protein_chainid){let i=s.substr(0,s.indexOf("_"));if(i.length>5){let n;e.uniprot2acc&&e.uniprot2acc[i]?e.uniprot2acc[i]:e.uniprot2acc={},n="https://rest.uniprot.org/uniprotkb/search?format=json&fields=xref_geneid,gene_names&query="+i;let l=await t.getAjaxPromise(n,"json"),r=l.results[0]&&l.results[0].uniProtKBCrossReferences&&l.results[0].uniProtKBCrossReferences[0]?l.results[0].uniProtKBCrossReferences[0].id:void 0,o=l.results[0]&&l.results[0].genes&&l.results[0].genes[0]&&l.results[0].genes[0].geneName?l.results[0].genes[0].geneName.value:"ID "+r;e.chainsGene[s]={geneId:r,geneSymbol:o}}}for(let s in e.protein_chainid){let i=t.utilsCls.isMobile()?"none":"button",l=e.showSeqCls.getProteinName(s),r=l,o=0==n?"<span class='icn3d-annoLargeTitle'><b>Proteins</b>: </span><br><br>":"",a=e.chainsGene[s]&&e.chainsGene[s].geneId&&e.chainsGene[s].geneDesc?"(Gene: <a href='https://www.ncbi.nlm.nih.gov/gene/"+e.chainsGene[s].geneId+"?report=gene_table' target='_blank' title='"+e.chainsGene[s].geneDesc+"'>"+e.chainsGene[s].geneSymbol+"</a>)":"",d=s.substr(0,s.indexOf("_")),c=d.length>5?'<a href="https://alphafold.ebi.ac.uk/entry/'+d+'" target="_blank">'+s+"</a>":s,h="<div id='"+e.pre+"anno_"+s+"' class='icn3d-annotation'>"+o+"<span style='font-weight:bold;'>Annotations of "+c+"</span>: <a class='icn3d-blue' href='https://www.ncbi.nlm.nih.gov/protein?term="+s+"' target='_blank' title='"+l+"'>"+r+"</a>"+a+"&nbsp;&nbsp;&nbsp;"+this.addButton(s,"icn3d-addtrack","Add Track","Add a custom track",60,i)+"&nbsp;&nbsp;&nbsp;";h+=this.addButton(s,"icn3d-customcolor","Custom Color/Tube","Use a custom file to define the colors or tubes in 3D structure",110,i)+"&nbsp;&nbsp;&nbsp;",h+=this.addButton(s,"icn3d-helixsets","Helix Sets",'Define sets for each helix in this chain and add them to the menu of "Defined Sets"',60,i)+"&nbsp;"+this.addButton(s,"icn3d-sheetsets","Sheet Sets",'Define sets for each sheet in this chain and add them to the menu of "Defined Sets"',60,i)+"&nbsp;"+this.addButton(s,"icn3d-coilsets","Coil Sets",'Define sets for each coil in this chain and add them to the menu of "Defined Sets"',60,i),h+="&nbsp;&nbsp;&nbsp;"+this.addButton(s,"icn3d-iganchorsets","Ig Anchor Set",'Define the set for all Ig anchors in this chain and add them to the menu of "Defined Sets"',80,i)+"&nbsp;"+this.addButton(s,"icn3d-igstrandsets","Ig Strand Sets",'Define sets for each Ig strand in this chain and add them to the menu of "Defined Sets"',80,i)+"&nbsp;"+this.addButton(s,"icn3d-igloopsets","Ig Loop Sets",'Define sets for each Ig loop in this chain and add them to the menu of "Defined Sets"',80,i)+"&nbsp;"+this.addButton(s,"icn3d-igdomainsets","Ig Domain Sets",'Define sets for each Ig domain in this chain and add them to the menu of "Defined Sets"',80,i),$("#"+e.pre+"dl_annotations").append(h);let p=["giseq","cdd","clinvar","snp","site","ptm","ssbond","crosslink","transmem","domain","custom","interaction","ig"];for(let t in p){let i=p[t];$("#"+e.pre+"anno_"+s).append(this.getAnDiv(s,i))}$("#"+e.pre+"anno_"+s).append("<br><hr><br>"),++n}if(t.bNode||e.annoCddSiteCls.setToolTip(),void 0!==e.chainid_seq)await this.processSeqData(e.chainid_seq);else try{let n=[],l=[];for(let e=0,t=i.length;e<t;++e){i[e].substr(0,i.indexOf("_")).length>=6?l.push(i[e]):n.push(i[e])}if(n.length>0){let s=t.htmlCls.baseUrl+"/vastdyn/vastdyn.cgi?chainlist="+n;e.chainid_seq=await t.getAjaxPromise(s,"jsonp")}else e.chainid_seq={};for(let t=0,s=l.length;t<s;++t){let s=l[t],i="";for(let t=0,n=e.chainsSeq[s].length;t<n;++t)i+=e.chainsSeq[s][t].name;e.chainid_seq[s]=i}await s.processSeqData(e.chainid_seq)}catch(n){s.enableHlSeq(),t.bNode||console.log("No sequence data were found for the protein "+i+"...");for(let t in e.protein_chainid){let s=e.protein_chainid[t];e.showSeqCls.setAlternativeSeq(t,s),e.showSeqCls.showSeq(t,s)}return void await e.annoCddSiteCls.showCddSiteAll()}}getSequenceData(e,t,s,i){let n=this.icn3d;n.icn3dui;let l=n.showSeqCls.getProteinName(e),r=l;r.length>40&&(r=r.substr(0,40)+"...");let o="";0==i&&("protein"==s?o="<span class='icn3d-annoLargeTitle'><b>Proteins</b>: </span><br><br>":"nucleotide"==s?o="<span class='icn3d-annoLargeTitle'><b>Nucleotides</b>: </span><br><br>":"chemical"==s&&(o="<span class='icn3d-annoLargeTitle'><b>Chemicals/Ions/Water</b>: </span><br><br>")),$("#"+n.pre+"dl_annotations").append("<div id='"+n.pre+"anno_"+e+"' class='icn3d-annotation'>"+o+"<b>"+e+"</b>: <span title='"+l+"'>"+r+"</span> </div>"),$("#"+n.pre+"anno_"+e).append(this.getAnDiv(e,"giseq")),$("#"+n.pre+"anno_"+e).append(this.getAnDiv(e,"interaction")),$("#"+n.pre+"anno_"+e).append("<br><hr><br>"),n.giSeq[e]=[];for(let t=0;t<n.chainsSeq[e].length;++t){let s=n.chainsSeq[e][t].name;n.giSeq[e][t]=s}n.matchedPos[e]=0,n.baseResi[e]=n.chainsSeq[e][0].resi-n.matchedPos[e]-1,n.showSeqCls.showSeq(e,t,s)}getCombinedSequenceData(e,t,s){let i,n=this.icn3d,l=n.icn3dui,r=0==s?"<span class='icn3d-annoLargeTitle'><b>Chemicals/Ions/Water</b>: </span><br><br>":"",o=t[0].lastIndexOf("_"),a=t[0].substr(0,o),d=void 0!==l.cfg.mmdbid&&void 0!==n.chainid2sid?n.chainid2sid[a]:void 0;i=void 0!==d?"<b>"+e+" <a class='icn3d-blue' href='https://pubchem.ncbi.nlm.nih.gov/substance/"+d+"#section=2D-Structure' target='_blank'><img src='https://pubchem.ncbi.nlm.nih.gov/image/imgsrv.fcgi?sid="+d+"'></a></b>":"<b>"+e+"</b>",$("#"+n.pre+"dl_annotations").append("<div id='"+n.pre+"anno_"+e+"' class='icn3d-annotation'>"+r+i+"</div>"),$("#"+n.pre+"anno_"+e).append("<div id='"+n.pre+"giseq_"+e+"'><div id='"+n.pre+"dt_giseq_"+e+"' style='display:none'></div><div id='"+n.pre+"ov_giseq_"+e+"'></div></div>"),$("#"+n.pre+"anno_"+e).append("<br><hr><br>");let c='<div class="icn3d-dl_sequence">';c+='<div class="icn3d-seqTitle icn3d-link icn3d-blue" anno="sequence" gi="'+e+'" resn="'+e+'"><span style="white-space:nowrap;" title="Chemical '+e+'">Chem. '+e+"</span></div>",c+='<span class="icn3d-residueNum" style="width:60px!important;" title="starting protein sequence number">Count: '+t.length+"</span>",c+='<span class="icn3d-seqLine">';let h=c,p=c;for(let s=0,i=t.length;s<i;++s){let i=e,l=i;i.length>3&&(l=i.substr(0,3)),s<t.length-1&&(l+=",");let r=t[s],o=r.substr(r.lastIndexOf("_")+1);h+='<span id="giseq_'+n.pre+r+'" title="'+i+o+'" class="icn3d-residue icn3d-chemical">'+l+"</span>"}let m=l.htmlCls.GREY8,u=Math.round(n.seqAnnWidth*t.length/n.maxAnnoLength);u<1&&(u=1),p+='<div class="icn3d-seqTitle" style="display:inline-block; color:white; font-weight:bold; background-color:'+m+"; width:"+u+'px;">&nbsp;</div>',c="</span>",c+="<br>",c+="</div>",h+=c,p+=c,$("#"+n.pre+"dt_giseq_"+e).html(h),$("#"+n.pre+"ov_giseq_"+e).html(p)}async processSeqData(e){let t=this.icn3d,s=t.icn3dui;t.bAnnoShown=!0;for(let i in t.protein_chainid){let n=t.protein_chainid[i];if(e.hasOwnProperty(n)){let s=e[n];t.giSeq[i]=s;let l="";for(let e=0;e<10&&e<t.chainsSeq[i].length;++e)l+=t.chainsSeq[i][e].name.substr(0,1);let r=s.toLowerCase().indexOf(l.toLowerCase());-1==r?(console.log("The gi sequence didn't match the protein sequence. The start of 3D protein sequence: "+l+". The gi sequence: "+s.substr(0,10)+"."),t.showSeqCls.setAlternativeSeq(i,n)):(t.matchedPos[i]=r,t.baseResi[i]=t.chainsSeq[i][0].resi-t.matchedPos[i]-1)}else s.bNode||console.log("No sequence data were found for the chain "+i+"..."),t.showSeqCls.setAlternativeSeq(i,n);if(s.cfg.blast_rep_id!=i)t.showSeqCls.showSeq(i,n);else if(s.cfg.blast_rep_id==i&&void 0===t.seqStructAlignData&&void 0===t.seqStructAlignDataSmithwm){let e,l,r,o=s.cfg.oriQuery_id?s.cfg.oriQuery_id:s.cfg.query_id;e=o.length>14?"Query: "+o.substr(0,6)+"...":isNaN(s.cfg.query_id)?"Query: "+o:"Query: gi "+o;let a="cannot be aligned";t.queryStart="",t.queryEnd="",t.bRender&&alert("The sequence can NOT be aligned to the structure"),t.showSeqCls.showSeq(i,n,void 0,e,l,a,r)}else if(s.cfg.blast_rep_id==i&&(void 0!==t.seqStructAlignData||void 0!==t.seqStructAlignDataSmithwm)){let e,l,r,o,a,d=s.cfg.oriQuery_id?s.cfg.oriQuery_id:s.cfg.query_id;if(e=d.length>14?"Query: "+d.substr(0,6)+"...":isNaN(s.cfg.query_id)?"Query: "+d:"Query: gi "+d,void 0!==t.seqStructAlignData){let e,s,i=t.seqStructAlignData;if(void 0!==i.data){e=i.data[0].query;let t=Object.keys(i.data[0].targets);s=i.data[0].targets[t[0]],s=void 0!==s&&s.hsps.length>0?s.hsps[0]:void 0}if(void 0!==e&&void 0!==s){l=s.scores.e_value.toPrecision(2),l>1e-200&&(l=parseFloat(l).toExponential()),s.scores.bit_score;let t=Object.keys(i.targets);r=i.targets[t[0]].seqdata,o=e.seqdata,a=s.segs}}else{let e=t.seqStructAlignDataSmithwm;l=e.score,r=e.target.replace(/-/g,""),o=e.query.replace(/-/g,""),a=[];let s=-1,i=-1,n=!1,d={};for(let t=0,l=e.target.length;t<l;++t)"-"!=e.target[t]&&++s,"-"!=e.query[t]&&++i,n||"-"==e.target[t]||"-"==e.query[t]?!n||"-"!=e.target[t]&&"-"!=e.query[t]||(n=!1,d.orito="-"==e.target[t]?s:s-1,d.to="-"==e.query[t]?i:i-1,a.push(d),d={}):(n=!0,d.orifrom=s,d.from=i);"-"!=e.target[e.target.length-1]&&"-"!=e.query[e.target.length-1]&&(d.orito=s,d.to=i,a.push(d))}let c="",h="";if(t.queryStart="",t.queryEnd="",void 0!==a){let e={};void 0===t.targetGapHash&&(t.targetGapHash={}),t.fullpos2ConsTargetpos={},t.consrvResPosArray=[];let n=0,l=0;t.nTotalGap=0,t.queryStart=a[0].from+1,t.queryEnd=a[a.length-1].to+1;for(let s=0,i=a.length;s<i;++s){let i=a[s];if(s>0)if(i.orifrom-n<i.from-l)t.targetGapHash[i.orifrom]={from:l+1,to:i.from-1},t.nTotalGap+=t.targetGapHash[i.orifrom].to-t.targetGapHash[i.orifrom].from+1;else if(i.orifrom-n>i.from-l)for(let t=n+1;t<i.orifrom;++t)e[t]=-1;for(let t=0;t<=i.orito-i.orifrom;++t)e[t+i.orifrom]=t+i.from;n=i.orito,l=i.to}let d=0;t.alnChainsSeq[i]=[];for(let n=0,l=r.length;n<l;++n){if(t.targetGapHash.hasOwnProperty(n))for(let e=t.targetGapHash[n].from;e<=t.targetGapHash[n].to;++e)c+=o[e];h+=t.showSeqCls.insertGap(i,n,"-",!0),t.targetGapHash.hasOwnProperty(n)&&(d+=t.targetGapHash[n].to-t.targetGapHash[n].from+1);let l=t.bUsePdbNum?t.ParserUtilsCls.getResi(i,n):n+1;if(e.hasOwnProperty(n)&&-1!==e[n]){c+=o[e[n]];let a=this.getColorhexFromBlosum62(r[n],o[e[n]]);r[n]==o[e[n]]?(h+=r[n],t.fullpos2ConsTargetpos[n+d]={same:1,pos:l,res:r[n],color:a},t.consrvResPosArray.push(l),t.alnChainsSeq[i].push({resi:l,color:"#FF0000",color2:"#"+a})):this.conservativeReplacement(r[n],o[e[n]])?(h+="+",t.fullpos2ConsTargetpos[n+d]={same:0,pos:l,res:r[n],color:a},t.consrvResPosArray.push(l),t.alnChainsSeq[i].push({resi:l,color:"#0000FF",color2:"#"+a})):(h+=" ",t.fullpos2ConsTargetpos[n+d]={same:-1,pos:l,res:r[n],color:a},t.alnChainsSeq[i].push({resi:l,color:s.htmlCls.GREYC,color2:"#"+a}))}else c+="-",h+=" "}}else c+="cannot be aligned",t.bRender&&alert("The sequence can NOT be aligned to the structure");let p=void 0!==t.seqStructAlignData?"BLAST, E: "+l:"Score: "+l;t.showSeqCls.showSeq(i,n,void 0,e,p,c,h);let m,u={};if(void 0!==t.consrvResPosArray)for(let e=0,s=t.consrvResPosArray.length;e<s;++e)m=n+"_"+t.consrvResPosArray[e],u[m]=1;let g=s.hashUtilsCls.cloneHash(t.hAtoms);t.selectionCls.selectResidueList(u,"protein_aligned",p,!1),t.hAtoms=s.hashUtilsCls.cloneHash(g)}}s.bNode||(this.enableHlSeq(),await t.annoCddSiteCls.showCddSiteAll())}enableHlSeq(){let e=this.icn3d;e.icn3dui.utilsCls.isMobile()?(e.hlSeqCls.selectSequenceMobile(),e.hlSeqCls.selectChainMobile()):e.hlSeqCls.selectSequenceNonMobile(),Object.keys(e.hAtoms).length<Object.keys(e.dAtoms).length&&e.hlUpdateCls.updateHlSeq()}getAnDiv(e,t){let s=this.icn3d;s.icn3dui;let i="Loading "+t+"...";return"custom"==t?i="":"domain"==t&&(i="Loading 3D "+t+"..."),"<div id='"+s.pre+t+"_"+e+"'><div id='"+s.pre+"tt_"+t+"_"+e+"' class='icn3d-fixed-pos' style='display:none!important'></div><div id='"+s.pre+"dt_"+t+"_"+e+"' style='display:none'>"+i+"</div><div id='"+s.pre+"ov_"+t+"_"+e+"'>"+i+"</div></div>"}addButton(e,t,s,i,n,l){return this.icn3d.icn3dui,"<div class='"+t+"' chainid='"+e+"' style='display:inline-block; font-size:11px; font-weight:bold; width:"+n+"px!important;'><button style='-webkit-appearance:"+l+"; height:18px; width:"+n+"px;'><span style='white-space:nowrap; margin-left:-3px;' title='"+i+"'>"+s+"</span></button></div>"}addSnpButton(e,t,s,i,n,l){let r=this.icn3d;return r.icn3dui,"<div class='"+r.pre+t+"' snp='"+e+"' style='margin:3px 0 3px 0; display:inline-block; font-size:11px; font-weight:bold; width:"+n+"px!important;'><button style='-webkit-appearance:"+l+"; height:18px; width:"+n+"px;'><span style='white-space:nowrap; margin-left:-3px;' title='"+i+"'>"+s+"</span></button></div>"}conservativeReplacement(e,t){let s=this.icn3d.icn3dui,i=-1!==s.parasCls.b62ResArray.indexOf(e)?s.parasCls.b62ResArray.indexOf(e):s.parasCls.b62ResArray.length-1,n=-1!==s.parasCls.b62ResArray.indexOf(t)?s.parasCls.b62ResArray.indexOf(t):s.parasCls.b62ResArray.length-1;return s.parasCls.b62Matrix[i][n]>0}getColorhexFromBlosum62(e,t){let s=this.icn3d.icn3dui,i="333333";if(!e||!t)return i;e=e.toUpperCase(),t=t.toUpperCase();let n=-1!==s.parasCls.b62ResArray.indexOf(e)?s.parasCls.b62ResArray.indexOf(e):s.parasCls.b62ResArray.length-1,l=-1!==s.parasCls.b62ResArray.indexOf(t)?s.parasCls.b62ResArray.indexOf(t):s.parasCls.b62ResArray.length-1,r=s.parasCls.b62Matrix[n][l];if(void 0===r)return"333333";if(r>0){let e=221-parseInt(r/11*221),t=e<10?"0"+e.toString(16):e.toString(16);i="DD"+t+t}else{let e=221-parseInt(-1*r/4*221),t=e<10?"0"+e.toString(16):e.toString(16);i=t+t+"DD"}return i}}class Mt{constructor(e){this.icn3d=e}getSeq(e){let t,s=this.icn3d,i=s.icn3dui;if(void 0===i.cfg.mmdbid&&void 0===i.cfg.gi&&void 0===i.cfg.blast_rep_id&&void 0===i.cfg.align&&void 0===i.cfg.chainalign&&void 0===i.cfg.mmdbafid){t=[];for(let i=0;i<s.chainsSeq[e].length;++i)t.push(s.chainsSeq[e][i])}else t=s.giSeq[e];if(!t)return[];let n=[];for(let e=0,s=t.length;e<s;++e)t[e]&&n.push(t[e]);return t=n,t}showSeq(e,t,s,i,n,l,r){let o=this.icn3d,a=o.icn3dui,d=this.getSeq(e),c=!1;void 0===a.cfg.mmdbid&&void 0===a.cfg.gi&&void 0===a.cfg.blast_rep_id&&void 0===a.cfg.align&&void 0===a.cfg.chainalign&&void 0===a.cfg.mmdbafid&&(c=!0);let h=a.htmlCls.RESIDUE_WIDTH*(d.length+o.nTotalGap)+200,p=["giseq","cddsite","clinvar","snp","ptm","ssbond","crosslink","transmem","domain","custom","interaction","ig"];for(let t in p){let s=p[t];$("#"+o.pre+s+"_"+e).length&&$("#"+o.pre+s+"_"+e).width(h)}let m,u="",g="",f="";if(u+='<div class="icn3d-dl_sequence">',f+='<div class="icn3d-dl_sequence">',d.length>10){m='<div class="icn3d-residueLine" style="white-space:nowrap;">';let t=o.firstAtomObjCls.getFirstCalphaAtomObj(o.chains[e]);void 0===a.cfg.mmdbid&&void 0===a.cfg.gi&&void 0===a.cfg.blast_rep_id&&void 0===a.cfg.align&&void 0===a.cfg.chainalign&&void 0===a.cfg.mmdbafid||void 0===t.resi_ori||t.resi_ori==t.resi||-1!=e.indexOf("Misc")?m+='<div class="icn3d-annoTitle" anno="0"></div>':m+='<div class="icn3d-annoTitle" anno="0" title="NCBI Residue Numbers">NCBI Residue Numbers</div>',m+='<span class="icn3d-residueNum"></span>',f+=m+"<br>",u+=m+'<span class="icn3d-seqLine">';let s=0,i=0,n="";o.seqStartLen&&o.seqStartLen[e]&&(u+=this.insertMulGap(o.seqStartLen[e]," "));for(let t=0,l=d.length;t<l;++t){let l;u+=this.insertGap(e,t,"-"),l=o.ParserUtilsCls.getResi(e,t),u+="<span>",l%10==0&&(u+=l);let r=e+"_"+l,a=l%10!=0&&l%10!=1&&l%10!=9;if(o.residues.hasOwnProperty(r)){let e=o.firstAtomObjCls.getFirstCalphaAtomObj(o.residues[r]);"H"==o.secondaries[r]&&e.ssbegin?(++s,n='<span class="icn3d-helix-color">H'+s+"</span>",a&&(u+=n,n="")):"E"==o.secondaries[r]&&e.ssbegin?(++i,"green"==o.sheetcolor?n='<span class="icn3d-sheet-color">S'+i+"</span>":"yellow"==o.sheetcolor&&(n='<span class="icn3d-sheet-colory">S'+i+"</span>"),a&&(u+=n,n="")):e.ssend&&(n=""),""!=n&&a&&(u+=n,n="")}u+="</span>"}o.seqStartLen&&o.seqStartLen[e]&&(u+=this.insertMulGap(o.seqEndLen[e]," ")),u+='<span class="icn3d-residueNum"></span>',u+="</span>",u+="<br>",u+="</div>",f+="</div>"}m='<div class="icn3d-residueLine" style="white-space:nowrap;">',m+='<div class="icn3d-annoTitle" anno="0"></div>',m+='<span class="icn3d-residueNum"></span>',f+=m+"<br>",u+=m+'<span class="icn3d-seqLine">',o.seqStartLen&&o.seqStartLen[e]&&(u+=this.insertMulGap(o.seqStartLen[e],"-"));for(let t=0,s=d.length;t<s;++t){u+=this.insertGap(e,t,"-");let s=e+"_"+o.ParserUtilsCls.getResi(e,t);if(o.residues.hasOwnProperty(s))if("H"==o.secondaries[s])u+=t%2==0?'<span class="icn3d-helix">':'<span class="icn3d-helix2">',u+="&nbsp;</span>";else if("E"==o.secondaries[s]){o.firstAtomObjCls.getFirstCalphaAtomObj(o.residues[s]).ssend?"green"==o.sheetcolor?u+='<span class="icn3d-sheet2">':"yellow"==o.sheetcolor&&(u+='<span class="icn3d-sheet2y">'):"green"==o.sheetcolor?u+='<span class="icn3d-sheet">':"yellow"==o.sheetcolor&&(u+='<span class="icn3d-sheety">'),u+="&nbsp;</span>"}else"c"==o.secondaries[s]?u+='<span class="icn3d-coil">&nbsp;</span>':"o"==o.secondaries[s]&&(u+='<span class="icn3d-other">&nbsp;</span>');else u+="<span>-</span>"}o.seqStartLen&&o.seqStartLen[e]&&(u+=this.insertMulGap(o.seqEndLen[e],"-")),u+='<span class="icn3d-residueNum"></span>',u+="</span>",u+="<br>",u+="</div>",u+="</div>",f+="</div></div>",m=a.cfg.blast_rep_id===e?'<div class="icn3d-dl_sequence" style="border: solid 1px #000">':'<div class="icn3d-dl_sequence">';let C="Protein",b="Protein";void 0!==s&&("nucleotide"==s?(C="Nucl.",b="Nucleotide"):"chemical"==s&&(C="Chem.",b="Chemical")),m+='<div class="icn3d-seqTitle icn3d-link icn3d-blue" gi="'+e+'" anno="sequence" chain="'+e+'"><span style="white-space:nowrap;" title="'+b+" "+e+'">'+C+" "+e+"</span></div>",m+='<span class="icn3d-residueNum" title="starting protein sequence number">'+(o.baseResi[e]+1).toString()+"</span>",f+=m+"<br>";let y='<span class="icn3d-seqLine">';u+=m+y,g+=m+y;let v,_=0;o.seqStartLen&&o.seqStartLen[e]&&(u+=this.insertMulGap(o.seqStartLen[e],"-"));for(let t=0,s=d.length;t<s;++t){u+=this.insertGap(e,t,"-"),void 0!==o.targetGapHash&&o.targetGapHash.hasOwnProperty(t)&&(_+=o.targetGapHash[t].to-o.targetGapHash[t].from+1);let s=c?d[t].name:d[t],i=s;if(s.length>1&&(i=s[0]+".."),v=o.ParserUtilsCls.getResi(e,t),o.residues.hasOwnProperty(e+"_"+v)){let n="333333";if(a.cfg.blast_rep_id==e&&void 0!==o.fullpos2ConsTargetpos&&void 0!==o.fullpos2ConsTargetpos[t+_])n=o.fullpos2ConsTargetpos[t+_].color;else{let t=o.firstAtomObjCls.getFirstCalphaAtomObj(o.residues[e+"_"+v]),s=void 0===t.color||"FFFFFF"===t.color.getHexString().toUpperCase()||"FFF"===t.color.getHexString().toUpperCase()?"DDDDDD":t.color.getHexString();n=void 0!==t.color?s:"CCCCCC"}u+='<span id="giseq_'+o.pre+e+"_"+v+'" title="'+s+v+'" class="icn3d-residue" style="color:#'+n+'">'+i+"</span>"}else i=i.toLowerCase(),u+='<span title="'+s+v+'" class="icn3d-residue">'+i+"</span>"}o.seqStartLen&&o.seqStartLen[e]&&(u+=this.insertMulGap(o.seqEndLen[e],"-")),a.cfg.blast_rep_id==e&&(o.opts.color=o.blastAcxn?"confidence":"conservation",o.setColorCls.setColorByOptions(o.opts,o.atoms));let w=o.firstAtomObjCls.getFirstCalphaAtomObj(o.chains[e]),S=w.color?w.color.getHexString():"CCCCCC",A=Math.round(o.seqAnnWidth*d.length/(o.maxAnnoLength+o.nTotalGap));if(A<1&&(A=1),o.seqStartLen&&o.seqStartLen[e]&&(g+=this.insertMulGapOverview(e,o.seqStartLen[e])),a.cfg.blast_rep_id!=e)g+='<div id="giseq_summary_'+o.pre+e+'" class="icn3d-seqTitle icn3d-link" gi chain="'+e+'" style="display:inline-block; color:white; font-weight:bold; background-color:#'+S+"; width:"+A+'px;">'+e+"</div>";else{let t=[],s=[];t.push(0);for(let e=0,i=d.length;e<i;++e)void 0!==o.targetGapHash&&o.targetGapHash.hasOwnProperty(e)&&(s.push(e-1),t.push(e));s.push(d.length-1),g+='<div id="giseq_summary_'+o.pre+e+'" class="icn3d-seqTitle icn3d-link" gi chain="'+e+'" style="width:'+A+'px;">';for(let i=0,n=t.length;i<n;++i)g+=this.insertGapOverview(e,t[i]),g+='<div style="display:inline-block; color:white!important; font-weight:bold; background-color:#'+S+"; width:"+Math.round(o.seqAnnWidth*(s[i]-t[i]+1)/(o.maxAnnoLength+o.nTotalGap))+'px;" class="icn3d-seqTitle icn3d-link icn3d-blue" anno="sequence" gi chain="'+e+'" title="'+e+'">'+e+"</div>";g+="</div>"}if(m='<span class="icn3d-residueNum" title="ending protein sequence number">'+v+"</span>",m+="</span>",m+="<br>",u+=m,g+=m,a.cfg.blast_rep_id==e){if(void 0!==r&&""!==r){m='<div class="icn3d-seqTitle icn3d-link icn3d-blue" blast="" posarray="'+o.consrvResPosArray.toString()+'" title="'+n+'" setname="'+e+'_blast" anno="sequence" chain="'+e+'"><span style="white-space:nowrap;" title="'+n+'">'+n+"</span></div>",m+='<span class="icn3d-residueNum"></span>',f+=m+"<br>";let t='<span class="icn3d-seqLine">';u+=m+t,g+=m+t;let s=0,i=0,l=1;o.queryStart;for(let t=0,n=r.length;t<n;++t){let n=r[t];if("-"==n)u+="<span>-</span>";else if(" "==n)u+="<span> </span>";else{let r=o.fullpos2ConsTargetpos[t].pos;if(o.residues.hasOwnProperty(e+"_"+r)){let s=o.fullpos2ConsTargetpos[t].color;u+='<span id="giseq_'+o.pre+e+"_"+r+'" title="'+o.fullpos2ConsTargetpos[t].res+r+'" class="icn3d-residue" style="color:#'+s+'">'+n+"</span>"}else n=n.toLowerCase(),u+='<span class="icn3d-residue">'+n+"</span>";g+=this.insertGapOverview(e,t);let a=Math.round(o.seqAnnWidth*t/(o.maxAnnoLength+o.nTotalGap)-s-i);a>=0&&(g+='<div style="display:inline-block; width:'+a+'px;">&nbsp;</div>',g+='<div style="display:inline-block; background-color:#F00; width:'+l+'px;" title="'+n+r+'">&nbsp;</div>',s+=a,i+=l)}}m='<span class="icn3d-residueNum"></span>',m+="</span>",m+="<br>",u+=m,g+=m}m='<div class="icn3d-annoTitle" anno="sequence" chain="'+e+'"><span style="white-space:nowrap;" title="'+i+'">'+i+"</span></div>",m+='<span class="icn3d-residueNum" title="starting protein sequence number">'+o.queryStart+"</span>",f+=m+"<br>";let t='<span class="icn3d-seqLine" style="font-weight: bold;">';u+=m+t,g+=m+t;let s=o.queryStart;for(let t=0,i=l.length;t<i;++t){let i=l[t];" "==i||"-"==i?u+="<span>-</span>":(void 0===o.fullpos2ConsTargetpos||void 0===o.fullpos2ConsTargetpos[t]||o.residues.hasOwnProperty(e+"_"+o.fullpos2ConsTargetpos[t].pos)||(i=i.toLowerCase()),u+='<span title="'+i+s+'" class="icn3d-residue">'+i+"</span>",++s)}let a=o.firstAtomObjCls.getFirstCalphaAtomObj(o.chains[e]),d=void 0===a.color||"FFFFFF"===a.color.getHexString()?"DDDDDD":a.color.getHexString(),c=void 0!==a.color?d:"CCCCCC",h=[],p=[],C="-";for(let e=0,t=l.length;e<t;++e){let t=l[e];"-"!=t&&"-"==C?h.push(e):"-"==t&&"-"!=C&&p.push(e-1),C=t}"-"!=C&&p.push(l.length-1);for(let t=0,s=h.length;t<s;++t){g+='<div style="display:inline-block; width:'+(0==t?Math.round(o.seqAnnWidth*(h[t]-o.baseResi[e]-1)/(o.maxAnnoLength+o.nTotalGap)):Math.round(o.seqAnnWidth*(h[t]-p[t-1]-1)/(o.maxAnnoLength+o.nTotalGap)))+'px;">&nbsp;</div>',g+='<div style="display:inline-block; color:white!important; font-weight:bold; background-color:#'+c+"; width:"+Math.round(o.seqAnnWidth*(p[t]-h[t]+1)/(o.maxAnnoLength+o.nTotalGap))+'px;" anno="sequence" chain="'+e+'" title="'+i+'">'+i+"</div>"}m='<span class="icn3d-residueNum" title="ending protein sequence number">'+o.queryEnd+"</span>",m+="</span>",m+="<br>",u+=m,g+=m}if(u+="</div>",g+="</div>",f+="</div>",d.length>10){let t=o.firstAtomObjCls.getFirstCalphaAtomObj(o.chains[e]);if((void 0!==a.cfg.mmdbid||void 0!==a.cfg.gi||void 0!==a.cfg.blast_rep_id||void 0!==a.cfg.align||void 0!==a.cfg.chainalign||void 0!==a.cfg.mmdbafid)&&void 0!==t.resi_ori&&t.resi_ori!=t.resi&&-1==e.indexOf("Misc")){m='<div class="icn3d-dl_sequence">',m+='<div class="icn3d-residueLine" style="white-space:nowrap;">',m+='<div class="icn3d-annoTitle" anno="0" title="PDB Residue Numbers">PDB Residue Numbers</div>',m+='<span class="icn3d-residueNum"></span>',f+=m+"<br>",u+=m+'<span class="icn3d-seqLine">',o.seqStartLen&&o.seqStartLen[e]&&(u+=this.insertMulGap(o.seqStartLen[e],"-"));for(let t=0,s=d.length;t<s;++t){u+=this.insertGap(e,t,"-");let s=e+"_"+o.ParserUtilsCls.getResi(e,t);if(o.residues.hasOwnProperty(s)){let e=o.firstAtomObjCls.getFirstCalphaAtomObj(o.residues[s]).resi_ori;u+="<span>",e%10==0&&(u+=e+" "),u+="</span>"}else u+="<span></span>"}o.seqStartLen&&o.seqStartLen[e]&&(u+=this.insertMulGap(o.seqEndLen[e],"-")),u+='<span class="icn3d-residueNum"></span>',u+="</span>",u+="<br>",u+="</div>",u+="</div>",f+="</div></div>"}if(o.bShowCustomRefnum&&o.chainsMapping.hasOwnProperty(e)){let t=!0,s=o.annoIgCls.showRefNum(d,e,void 0,t);u+=s.html,f+=s.html3}}o.bShowRefnum&&o.hlUpdateCls.updateHlAll(),$("#"+o.pre+"dt_giseq_"+e).html(u),$("#"+o.pre+"ov_giseq_"+e).html(g),$("#"+o.pre+"tt_giseq_"+e).html(f)}insertGap(e,t,s,i){let n=this.icn3d;n.icn3dui;let l="";return void 0!==n.targetGapHash&&n.targetGapHash.hasOwnProperty(t)&&(l+=this.insertMulGap(n.targetGapHash[t].to-n.targetGapHash[t].from+1,s,i)),l}insertMulGap(e,t,s){this.icn3d.icn3dui;let i="";for(let n=0;n<e;++n)i+=s?t:"<span>"+t+"</span>";return i}insertGapOverview(e,t){let s=this.icn3d;s.icn3dui;let i="";return void 0!==s.targetGapHash&&s.targetGapHash.hasOwnProperty(t)&&(i+=this.insertMulGapOverview(e,s.targetGapHash[t].to-s.targetGapHash[t].from+1)),i}insertMulGapOverview(e,t){let s=this.icn3d;s.icn3dui;let i="",n=s.seqAnnWidth*t/(s.maxAnnoLength+s.nTotalGap);return n=parseInt(n),i+='<div style="display:inline-block; width:'+n+'px;">&nbsp;</div>',i}setAlternativeSeq(e,t){let s=this.icn3d;s.icn3dui;let i=s.chainsSeq[e];s.giSeq[e]=[];for(let t=0,n=i.length;t<n;++t){let n=i[t].name;s.giSeq[e][t]=n}s.matchedPos[e]=0,s.baseResi[e]=s.chainsSeq[e][0].resi-s.matchedPos[e]-1}getProteinName(e){let t=this.icn3d,s=t.icn3dui,i="";if(void 0===s.cfg.mmdbid&&void 0===s.cfg.gi&&void 0===s.cfg.blast_rep_id||void 0===t.mmdb_data)(void 0!==s.cfg.align||void 0!==s.cfg.chainalign||void 0!==s.cfg.mmdbafid||t.bRealign||t.bSymd)&&void 0!==t.chainid2title&&void 0!==t.chainid2title[e]&&(i=t.chainid2title[e]);else{let s=t.mmdb_data.moleculeInfor,n=e.substr(e.indexOf("_")+1);for(let e in s)if(s[e].chain==n){i=s[e].name.replace(/\'/g,"&prime;");break}}return i}}class Ft{constructor(e){this.icn3d=e}selectSequenceNonMobile(){let e=this.icn3d;if(e.icn3dui.bNode)return;let t=this;$("#"+e.pre+"dl_sequence2").add("[id^="+e.pre+"dt_giseq]").add("[id^="+e.pre+"dt_custom]").add("[id^="+e.pre+"dt_site]").add("[id^="+e.pre+"dt_ptm]").add("[id^="+e.pre+"dt_snp]").add("[id^="+e.pre+"dt_clinvar]").add("[id^="+e.pre+"dt_cdd]").add("[id^="+e.pre+"dt_domain]").add("[id^="+e.pre+"dt_interaction]").add("[id^="+e.pre+"dt_ssbond]").add("[id^="+e.pre+"dt_crosslink]").add("[id^="+e.pre+"dt_transmem]").add("[id^="+e.pre+"dt_ig]").add("[id^="+e.pre+"tt_giseq]").add("[id^="+e.pre+"tt_custom]").add("[id^="+e.pre+"tt_site]").add("[id^="+e.pre+"tt_ptm]").add("[id^="+e.pre+"tt_snp]").add("[id^="+e.pre+"tt_clinvar]").add("[id^="+e.pre+"tt_cdd]").add("[id^="+e.pre+"tt_domain]").add("[id^="+e.pre+"tt_interaction]").add("[id^="+e.pre+"tt_ssbond]").add("[id^="+e.pre+"tt_crosslink]").add("[id^="+e.pre+"tt_transmem]").add("[id^="+e.pre+"tt_ig]").selectable({distance:1,stop:function(){let e=t.icn3d;$(this).attr("id")===e.pre+"dl_sequence2"?(e.bAlignSeq=!0,e.bAnnotations=!1):(e.bAlignSeq=!1,e.bAnnotations=!0),!1!==e.bSelectResidue||e.bShift||e.bCtrl||e.selectionCls.removeSelection(),$("span.ui-selected",this).each((function(){let e=$(this).attr("id");void 0!==e&&t.selectResidues(e,this)})),e.selectionCls.saveSelectionPrep(!0),e.selectionCls.saveSelection(void 0,void 0,!1),e.hlObjectsCls.addHlObjects();let s={};for(let t in e.selectedResidues){let e=t.lastIndexOf("_");s[t.substr(0,e)]=1}let i=Object.keys(s);e.hlUpdateCls.updateHl2D(i),$("div.ui-selected",this).each((function(){void 0!==$(this).attr("chain")&&t.selectTitle(this)}))}}),$("[id^="+e.pre+"ov_giseq]").add("[id^="+e.pre+"ov_custom]").add("[id^="+e.pre+"ov_site]").add("[id^="+e.pre+"ov_ptm]").add("[id^="+e.pre+"ov_snp]").add("[id^="+e.pre+"ov_clinvar]").add("[id^="+e.pre+"ov_cdd]").add("[id^="+e.pre+"ov_domain]").add("[id^="+e.pre+"ov_interaction]").add("[id^="+e.pre+"ov_ssbond]").add("[id^="+e.pre+"ov_crosslink]").add("[id^="+e.pre+"ov_transmem]").add("[id^="+e.pre+"ov_ig]").add("[id^="+e.pre+"tt_giseq]").add("[id^="+e.pre+"tt_custom]").add("[id^="+e.pre+"tt_site]").add("[id^="+e.pre+"tt_ptm]").add("[id^="+e.pre+"tt_snp]").add("[id^="+e.pre+"tt_clinvar]").add("[id^="+e.pre+"tt_cdd]").add("[id^="+e.pre+"tt_domain]").add("[id^="+e.pre+"tt_interaction]").add("[id^="+e.pre+"tt_ssbond]").add("[id^="+e.pre+"tt_crosslink]").add("[id^="+e.pre+"tt_transmem]").add("[id^="+e.pre+"tt_ig]").add("#"+e.pre+"dl_sequence2").add("[id^="+e.pre+"dt_giseq]").add("[id^="+e.pre+"dt_custom]").add("[id^="+e.pre+"dt_site]").add("[id^="+e.pre+"dt_ptm]").add("[id^="+e.pre+"dt_snp]").add("[id^="+e.pre+"dt_clinvar]").add("[id^="+e.pre+"dt_cdd]").add("[id^="+e.pre+"dt_domain]").add("[id^="+e.pre+"dt_interaction]").add("[id^="+e.pre+"dt_ssbond]").add("[id^="+e.pre+"dt_crosslink]").add("[id^="+e.pre+"dt_transmem]").add("[id^="+e.pre+"dt_ig]").add("[id^="+e.pre+"tt_giseq]").add("[id^="+e.pre+"tt_custom]").add("[id^="+e.pre+"tt_site]").add("[id^="+e.pre+"tt_ptm]").add("[id^="+e.pre+"tt_snp]").add("[id^="+e.pre+"tt_clinvar]").add("[id^="+e.pre+"tt_cdd]").add("[id^="+e.pre+"tt_domain]").add("[id^="+e.pre+"tt_interaction]").add("[id^="+e.pre+"tt_ssbond]").add("[id^="+e.pre+"tt_crosslink]").add("[id^="+e.pre+"tt_transmem]").add("[id^="+e.pre+"tt_ig]").on("click",".icn3d-seqTitle",(function(e){let s=t.icn3d;e.stopImmediatePropagation(),$(this).parents("div").attr("id")===s.pre+"dl_sequence2"?(s.bAlignSeq=!0,s.bAnnotations=!1):(s.bAlignSeq=!1,s.bAnnotations=!0),t.selectTitle(this),s.hlUpdateCls.hlSummaryDomain3ddomain(this)}))}selectSequenceMobile(){let e=this.icn3d;if(e.icn3dui.bNode)return;let t=this;$("#"+e.pre+"dl_sequence2").add("[id^="+e.pre+"giseq]").add("[id^="+e.pre+"custom]").add("[id^="+e.pre+"site]").add("[id^="+e.pre+"ptm]").add("[id^="+e.pre+"clinvar]").add("[id^="+e.pre+"snp]").add("[id^="+e.pre+"cdd]").add("[id^="+e.pre+"domain]").add("[id^="+e.pre+"interaction]").add("[id^="+e.pre+"ssbond]").add("[id^="+e.pre+"crosslink]").add("[id^="+e.pre+"transmem]").add("[id^="+e.pre+"ig]").on("click",".icn3d-residue",(function(e){let s=t.icn3d;e.stopImmediatePropagation();let i=$(this).attr("id");void 0!==i&&(t.selectResidues(i,this),s.selectionCls.saveSelectionPrep(!0),s.selectionCls.saveSelection(void 0,void 0,!1)),s.hlObjectsCls.addHlObjects();let n={};for(let e in s.selectedResidues){let t=e.lastIndexOf("_");n[e.substr(0,t)]=1}s.hlUpdateCls.removeHl2D();let l=Object.keys(n);s.hlUpdateCls.updateHl2D(l)}))}selectChainMobile(){let e=this.icn3d;if(e.icn3dui.bNode)return;let t=this;$("#"+e.pre+"dl_sequence2").add("[id^="+e.pre+"giseq]").add("[id^="+e.pre+"custom]").add("[id^="+e.pre+"site]").add("[id^="+e.pre+"ptm]").add("[id^="+e.pre+"feat]").add("[id^="+e.pre+"clinvar]").add("[id^="+e.pre+"snp]").add("[id^="+e.pre+"cdd]").add("[id^="+e.pre+"domain]").add("[id^="+e.pre+"interaction]").add("[id^="+e.pre+"ssbond]").add("[id^="+e.pre+"crosslink]").add("[id^="+e.pre+"transmem]").add("[id^="+e.pre+"ig]").on("click",".icn3d-seqTitle",(function(e){let s=t.icn3d;e.stopImmediatePropagation(),$(this).parents("div").attr("id")===s.pre+"dl_sequence2"?(s.bAlignSeq=!0,s.bAnnotations=!1):(s.bAlignSeq=!1,s.bAnnotations=!0),t.selectTitle(this),s.hlUpdateCls.hlSummaryDomain3ddomain(this)}))}selectTitle(e){let t=this.icn3d,s=t.icn3dui;if(!s.bNode&&$(e).hasClass("icn3d-seqTitle")){let i,n,l,r=$(e).attr("chain"),o=$(e).attr("resn");if(t.bAlignSeq?t.bSelectAlignResidue=!1:t.bSelectResidue=!1,t.bAnnotations||t.hlUpdateCls.removeSeqChainBkgd(r),t.bCtrl||t.bShift||(t.hlUpdateCls.removeSeqResidueBkgd(),t.hlUpdateCls.removeSeqChainBkgd(),t.currSelectedSets=[]),$(e).toggleClass("icn3d-highlightSeq"),o?i=o:t.bAnnotations?(i=$(e).attr("setname"),n=$(e).attr("title")):i=t.bAlignSeq?"align_"+r:r,$(e).hasClass("icn3d-highlightSeq"))if(t.bAnnotations){if($(e).hasClass("icn3d-highlightSeq"))if(t.hlUpdateCls.removeHl2D(),void 0!==$(e).attr("gi")){if(t.bCtrl||t.bShift)if(t.currSelectedSets.push(r),o){let e=s.hashUtilsCls.cloneHash(t.hAtoms),n=!0;t.selByCommCls.selectBySpec("select :3"+o,i,i,!1,n),t.hAtoms=s.hashUtilsCls.unionHash(t.hAtoms,e),t.hlUpdateCls.updateHlAll(o,void 0,!0,!0)}else t.selectionCls.selectAChain(r,r,!1,!0);else if(t.currSelectedSets=[r],o){let e=!0;t.selByCommCls.selectBySpec("select :3"+o,i,i,!1,e),t.hlUpdateCls.updateHlAll(o,void 0,!0,!0)}else t.selectionCls.selectAChain(r,r,!1);o?s.htmlCls.clickMenuCls.setLogCmd("select :3"+o,!0):s.htmlCls.clickMenuCls.setLogCmd("select chain "+r,!0);let e=t.currSelectedSets.join(" or ");t.currSelectedSets.length>1&&s.htmlCls.clickMenuCls.setLogCmd("select sets "+e,!0)}else{let o={};if(void 0!==$(e).attr("domain")||void 0!==$(e).attr("feat")||void 0!==$(e).attr("3ddomain")||void 0!==$(e).attr("custom")||void 0!==$(e).attr("ig")){t.hlUpdateCls.hlSummaryDomain3ddomain(e);let a,d,c,h=$(e).attr("from").split(","),p=$(e).attr("to").split(",");r.substr(0,r.indexOf("_"));for(let s=0,i=h.length;s<i;++s){d=parseInt(h[s]),c=parseInt(p[s]);for(let s=d;s<=c;++s){if(void 0!==$(e).attr("domain")||void 0!==$(e).attr("feat")||void 0!==$(e).attr("ig")){let e=r+"_"+(s+1).toString();a=t.ncbi2resid[e]}else a=void 0!==$(e).attr("3ddomain")?t.ncbi2resid[r+"_"+s]:r+"_"+(s+1).toString();o[a]=1}}t.bCtrl||t.bShift?t.selectionCls.selectResidueList(o,i,n,!0):t.selectionCls.selectResidueList(o,i,n,!1),a=r+"_"+parseInt((d+c)/2).toString(),l=t.applyCenterCls.centerAtoms(s.hashUtilsCls.hash2Atoms(t.residues[a],t.atoms))}else if(void 0!==$(e).attr("posarray")){let a,d=$(e).attr("posarray").split(",");r.substr(0,r.indexOf("_"));for(let s=0,i=d.length;s<i;++s){if(void 0!==$(e).attr("site")||void 0!==$(e).attr("ptm")){let e=r+"_"+(parseInt(d[s])+1).toString();a=t.ncbi2resid[e]}else a=r+"_"+d[s];o[a]=1}t.bCtrl||t.bShift?t.selectionCls.selectResidueList(o,i,n,!0):t.selectionCls.selectResidueList(o,i,n,!1),a=r+"_"+d[parseInt((0+d.length)/2)].toString(),l=t.applyCenterCls.centerAtoms(s.hashUtilsCls.hash2Atoms(t.residues[a],t.atoms))}for(let e in t.labels)"schematic"!==e&&"distance"!==e&&(t.labels[e]=[]);let a=t.LABELSIZE,d="black"!=t.opts.background?t.colorWhitebkgd:t.colorBlackbkgd;void 0!==l&&t.analysisCls.addLabel(n,l.center.x,l.center.y,l.center.z,a,d,void 0,"custom"),t.drawCls.draw(),s.htmlCls.clickMenuCls.setLogCmd("select "+t.resid2specCls.residueids2spec(Object.keys(o))+" | name "+i,!0),t.bCtrl||t.bShift?t.currSelectedSets.push(i):t.currSelectedSets=[i];let c=t.currSelectedSets.join(" or ");t.currSelectedSets.length>1&&s.htmlCls.clickMenuCls.setLogCmd("select sets "+c,!0)}}else{t.bCtrl||t.bShift?(t.currSelectedSets.push(i),t.selectionCls.selectAChain(r,i,!0,!0)):(t.currSelectedSets=[i],t.selectionCls.selectAChain(r,i,t.bAlignSeq)),t.bAlignSeq?s.htmlCls.clickMenuCls.setLogCmd("select alignChain "+r,!0):s.htmlCls.clickMenuCls.setLogCmd("select chain "+r,!0);let e=t.currSelectedSets.join(" or ");t.currSelectedSets.length>1&&s.htmlCls.clickMenuCls.setLogCmd("select sets "+e,!0)}else t.hlObjectsCls.removeHlObjects(),t.hlUpdateCls.removeHl2D(),$("#"+t.pre+"atomsCustom").val("")}}selectResidues(e,t){let s=this.icn3d,i=s.icn3dui;if(!i.bNode&&(!1!==s.bSelectResidue||s.bShift||s.bCtrl||s.selectionCls.removeSelection(),void 0!==e&&""!==e)){e=e.substr(e.indexOf("_")+1),s.bSelectResidue=!0,$(t).toggleClass("icn3d-highlightSeq");let n=e.substr(e.indexOf("_")+1);if(s.residues.hasOwnProperty(n))if($(t).hasClass("icn3d-highlightSeq")){for(let e in s.residues[n])s.hAtoms[e]=1;if(s.selectedResidues[n]=1,s.bAnnotations&&void 0!==$(t).attr("disease")){let e=$(t).attr("disease"),l=s.applyCenterCls.centerAtoms(i.hashUtilsCls.hash2Atoms(s.residues[n],s.atoms)),r=15;e.length>r&&(e=e.substr(0,r)+"...");let o=s.LABELSIZE,a=i.htmlCls.GREYD;s.analysisCls.addLabel(e,l.center.x,l.center.y,l.center.z,o,a,void 0,"custom")}}else{for(let e in s.residues[n])delete s.hAtoms[e];delete s.selectedResidues[n],s.hlObjectsCls.removeHlObjects()}}}}class Ht{constructor(e){this.icn3d=e}update2DdgmContent(){let e=this.icn3d,t=e.icn3dui,s="";void 0!==t.cfg.mmdbid||void 0!==t.cfg.gi?(s+=e.diagram2dCls.draw2Ddgm(e.interactionData,e.inputid,void 0,!0),s+=e.diagram2dCls.set2DdgmNote(),$("#"+e.pre+"dl_2ddgm_html").html(s)):e.mmdbidArray&&(void 0!==t.cfg.align||void 0!==t.cfg.chainalign||e.bRealign)&&(s+=e.diagram2dCls.draw2Ddgm(e.interactionData1,e.mmdbidArray[0].toUpperCase(),0,!0),void 0!==e.mmdbid_q&&e.mmdbid_q===e.mmdbid_t?s+=e.diagram2dCls.draw2Ddgm(e.interactionData2,e.mmdbidArray[0].toUpperCase(),1,!0):s+=e.diagram2dCls.draw2Ddgm(e.interactionData2,e.mmdbidArray[1].toUpperCase(),1,!0),s+=e.diagram2dCls.set2DdgmNote(!0),$("#"+e.pre+"dl_2ddgm_html").html(s))}changeSeqColor(e){let t=this.icn3d,s=t.icn3dui;for(let i=0,n=e.length;i<n;++i){let n=e[i],l=t.firstAtomObjCls.getFirstCalphaAtomObj(t.residues[n]);if(!l)continue;let r=void 0===l.color||"FFFFFF"===l.color.getHexString().toUpperCase()?"DDDDDD":l.color.getHexString(),o=void 0!==l.color?r:"CCCCCC";$("[id=giseq_"+t.pre+n+"]").attr("style","color:#"+o),$("[id=align_"+t.pre+n+"]").attr("style","color:#"+o),(void 0!==s.cfg.align||void 0!==s.cfg.chainalign||t.bRealign||t.bSymd)&&$("[id=align_"+t.pre+n+"]").attr("style","color:#"+o)}}removeHlAll(){this.icn3d.icn3dui,this.removeHlObjects(),this.removeHlSeq(),this.removeHl2D(),this.removeHlMenus()}removeHlObjects(){let e=this.icn3d;e.icn3dui,e.hlObjectsCls.removeHlObjects()}removeHlSeq(){this.icn3d.icn3dui,this.removeSeqResidueBkgd()}removeHl2D(e){let t=this.icn3d;t.icn3dui,$("#"+t.pre+"dl_2ddgm rect").attr("stroke","#000000"),$("#"+t.pre+"dl_2ddgm circle").attr("stroke","#000000"),$("#"+t.pre+"dl_2ddgm polygon").attr("stroke","#000000"),$("#"+t.pre+"dl_2ddgm rect").attr("stroke-width",1),$("#"+t.pre+"dl_2ddgm circle").attr("stroke-width",1),$("#"+t.pre+"dl_2ddgm polygon").attr("stroke-width",1),$("#"+t.pre+"dl_2ddgm circle").length>0&&($("#"+t.pre+"dl_2ddgm svg line").attr("stroke","#000000"),$("#"+t.pre+"dl_2ddgm line").attr("stroke-width",1)),e||($("#"+t.pre+"dl_linegraph circle").attr("stroke","#000000"),$("#"+t.pre+"dl_linegraph circle").attr("stroke-width",1),$("#"+t.pre+"dl_scatterplot rect").attr("stroke","#000000"),$("#"+t.pre+"dl_scatterplot circle").attr("stroke","#000000"),$("#"+t.pre+"dl_scatterplot rect").attr("stroke-width",1),$("#"+t.pre+"dl_scatterplot circle").attr("stroke-width",1))}removeHlMenus(){let e=this.icn3d;e.icn3dui,$("#"+e.pre+"atomsCustom").val(""),$("#"+e.pre+"atomsCustom")[0].blur()}updateHlAll(e,t,s,i){let n=this.icn3d,l=n.icn3dui;n.prevHighlightAtoms=l.hashUtilsCls.cloneHash(n.hAtoms),this.updateHlObjects(i),void 0!==e?this.updateHlSeqInChain(e,s):this.updateHlSeq(void 0,void 0,s),this.updateHl2D(),(void 0===t||t)&&this.updateHlMenus(e)}updateHlObjects(e){let t=this.icn3d;t.icn3dui,t.hlObjectsCls.removeHlObjects(),(t.hAtoms&&t.atoms&&Object.keys(t.hAtoms).length<Object.keys(t.dAtoms).length||e)&&((void 0===t.bShowHighlight||t.bShowHighlight)&&t.hlObjectsCls.addHlObjects(),t.definedSetsCls.setMode("selection"))}updateHlSeq(e,t,s){let i=this.icn3d;i.icn3dui,void 0!==s&&s||this.removeHlSeq(),void 0===t&&(t=i.firstAtomObjCls.getResiduesFromCalphaAtoms(i.hAtoms)),i.hAtoms&&i.atoms&&Object.keys(i.hAtoms).length<Object.keys(i.atoms).length&&this.hlSequence(Object.keys(t)),this.changeSeqColor(Object.keys(t))}updateHlSeqInChain(e,t){let s=this.icn3d;if(s.icn3dui,void 0!==t&&t||this.removeHlSeq(),!s.hAtoms||!s.atoms||Object.keys(s.hAtoms).length!=Object.keys(s.atoms).length)for(let t=0,i=e.length;t<i;++t){let i=e[t];if(-1!==Object.keys(s.chains).indexOf(i))this.hlSeqInChain(i);else{let e=[];void 0!==s.defNames2Residues[i]&&s.defNames2Residues[i].length>0&&(e=s.defNames2Residues[i]);let t={};if(void 0!==s.defNames2Atoms[i]&&s.defNames2Atoms[i].length>0){for(let e=0,n=s.defNames2Atoms[i].length;e<n;++e){let n=s.defNames2Atoms[i][e],l=s.atoms[n];t[l.structure+"_"+l.chain+"_"+l.resi]=1}e=e.concat(Object.keys(t))}this.hlSequence(e)}}}updateHl2D(e){let t=this.icn3d,s=t.icn3dui;if(this.removeHl2D(!0),!t.hAtoms||!t.atoms||Object.keys(t.hAtoms).length!=Object.keys(t.atoms).length){if(void 0===e){let s=t.firstAtomObjCls.getChainsFromAtoms(t.hAtoms);e=Object.keys(s)}if(void 0!==e)for(let i=0,n=e.length;i<n;++i){let n=s.hashUtilsCls.intHash(t.chains[e[i]],t.hAtoms);if(!t.chains[e[i]])continue;let l=1*Object.keys(n).length/Object.keys(t.chains[e[i]]).length,r=t.firstAtomObjCls.getFirstCalphaAtomObj(n);if(void 0!==t.alnChains[e[i]]){let l=s.hashUtilsCls.intHash(t.alnChains[e[i]],n);Object.keys(l).length>0&&(r=t.firstAtomObjCls.getFirstCalphaAtomObj(l))}let o=void 0!==r&&void 0!==r.color?"#"+r.color.getHexString():"#FFFFFF",a=$("#"+t.pre+"dl_2ddgm g[chainid="+e[i]+"] rect[class='icn3d-hlnode']"),d=$("#"+t.pre+"dl_2ddgm g[chainid="+e[i]+"] rect[class='icn3d-basenode']");void 0!==a&&(t.diagram2dCls.highlightNode("rect",a,d,l),$(a).attr("fill",o)),a=$("#"+t.pre+"dl_2ddgm g[chainid="+e[i]+"] circle[class='icn3d-hlnode']"),d=$("#"+t.pre+"dl_2ddgm g[chainid="+e[i]+"] circle[class='icn3d-basenode']"),void 0!==a&&(t.diagram2dCls.highlightNode("circle",a,d,l),$(a).attr("fill",o)),a=$("#"+t.pre+"dl_2ddgm g[chainid="+e[i]+"] ellipse[class='icn3d-hlnode']"),void 0!==a&&t.diagram2dCls.highlightNode("ellipse",a,void 0,l),a=$("#"+t.pre+"dl_2ddgm g[chainid="+e[i]+"] polygon[class='icn3d-hlnode']"),d=$("#"+t.pre+"dl_2ddgm g[chainid="+e[i]+"] polygon[class='icn3d-basenode']"),void 0!==a&&(t.diagram2dCls.highlightNode("polygon",a,d,l),$(a).attr("fill",o))}if(void 0!==t.lineArray2d)for(let e=0,i=t.lineArray2d.length;e<i;e+=2)$("#"+t.pre+"dl_2ddgm g[chainid1="+t.lineArray2d[e]+"][chainid2="+t.lineArray2d[e+1]+"] line").attr("stroke",s.htmlCls.ORANGE);t.prevHighlightAtoms=s.hashUtilsCls.cloneHash(t.hAtoms),t.definedSetsCls.setMode("selection")}}updateHlMenus(e){let t=this.icn3d;t.icn3dui,void 0===e&&(e=[]);let s=t.definedSetsCls.setAtomMenu(e);$("#"+t.pre+"atomsCustom").length&&($("#"+t.pre+"atomsCustom").html(s),$("#"+t.pre+"atomsCustom")[0].blur())}hlSequence(e){let t=this.icn3d;t.icn3dui;let s={};for(let i=0,n=e.length;i<n;++i){let n=e[i].trim(),l=$("[id=giseq_"+t.pre+n+"]");0!==l.length&&l.addClass("icn3d-highlightSeq"),l=$("[id=align_"+t.pre+n+"]"),0!==l.length&&l.addClass("icn3d-highlightSeq");let r=n.lastIndexOf("_");s[n.substr(0,r)]=1}for(let e in s)0!==$("#giseq_summary_"+t.pre+e).length&&$("#giseq_summary_"+t.pre+e).addClass("icn3d-highlightSeqBox")}hlSeqInChain(e){let t=this.icn3d;t.icn3dui;for(let s=0,i=t.chainsSeq[e].length;s<i;++s){let i=e+"_"+t.chainsSeq[e][s].resi;0!==$("#giseq_"+t.pre+i).length&&$("#giseq_"+t.pre+i).addClass("icn3d-highlightSeq"),0!==$("#align_"+t.pre+i).length&&$("#align_"+t.pre+i).addClass("icn3d-highlightSeq")}0!==$("#giseq_summary_"+t.pre+e).length&&$("#giseq_summary_"+t.pre+e).addClass("icn3d-highlightSeqBox")}toggleHighlight(){let e=this.icn3d;e.icn3dui,e.bShowHighlight?(this.clearHighlight(),e.bShowHighlight=!1):(this.showHighlight(),e.bShowHighlight=!0)}clearHighlight(){let e=this.icn3d;e.icn3dui,e.labels.picking=[],e.drawCls.draw(),e.hlObjectsCls.removeHlObjects(),this.removeHl2D(),e.bRender&&e.drawCls.render(),this.removeSeqChainBkgd(),this.removeSeqResidueBkgd(),e.bSelectResidue=!1}showHighlight(){let e=this.icn3d;e.icn3dui,e.hlObjectsCls.addHlObjects(),this.updateHlAll()}highlightChains(e){let t=this.icn3d;t.icn3dui,t.hlObjectsCls.removeHlObjects(),this.removeHl2D(),t.hlObjectsCls.addHlObjects(),this.updateHl2D(e);let s={};for(let i=0,n=e.length;i<n;++i){let n=e[i];for(let e in t.chainsSeq[n]){let i=t.chainsSeq[n][e],l=n+"_"+i.resi;""!==i.name&&"-"!==i.name&&(s[l]=1)}}this.hlSequence(Object.keys(s))}hlSummaryDomain3ddomain(e){if(this.icn3d.icn3dui,void 0!==$(e).attr("domain")){let t=$(e).attr("index"),s=$(e).attr("chain");0!==$("[id^="+s+"_domain_"+t+"]").length&&$("[id^="+s+"_domain_"+t+"]").addClass("icn3d-highlightSeqBox")}if(void 0!==$(e).attr("3ddomain")){let t=$(e).attr("index"),s=$(e).attr("chain");0!==$("[id^="+s+"_3d_domain_"+t+"]").length&&$("[id^="+s+"_3d_domain_"+t+"]").addClass("icn3d-highlightSeqBox")}}removeSeqChainBkgd(e){void 0===e?$(".icn3d-seqTitle").each((function(e){$(this).removeClass("icn3d-highlightSeq"),$(this).removeClass("icn3d-highlightSeqBox")})):$(".icn3d-seqTitle").each((function(t){$(this).attr("chain")!==e&&($(this).removeClass("icn3d-highlightSeq"),$(this).removeClass("icn3d-highlightSeqBox"))}))}removeSeqResidueBkgd(){$(".icn3d-residue").each((function(e){$(this).removeClass("icn3d-highlightSeq")}))}}class Lt{constructor(e){this.icn3d=e}addHlObjects(e,t,s){let i=this.icn3d,n=i.icn3dui;void 0===e&&(e=i.hColor);let l=s?n.hashUtilsCls.intHash(s,i.dAtoms):n.hashUtilsCls.intHash(i.hAtoms,i.dAtoms);i.applyDisplayCls.applyDisplayOptions(i.opts,l,i.bHighlight),(t||i.bRender)&&i.drawCls.render()}removeHlObjects(){let e=this.icn3d;e.icn3dui;for(let t in e.prevHighlightObjects)e.mdl&&e.mdl.remove(e.prevHighlightObjects[t]);e.prevHighlightObjects=[];for(let t in e.prevHighlightObjects_ghost)e.mdl&&e.mdl.remove(e.prevHighlightObjects_ghost[t]);e.prevHighlightObjects_ghost=[]}}class Nt{constructor(e){this.icn3d=e}drawLineGraph(e,t){let s,i=this.icn3d,n=i.icn3dui,l=JSON.parse(e),r=[],o=[],a=[],d={};for(let e=0,t=l.nodes.length;e<t;++e){let t=l.nodes[e];d[t.id]=t}let c={};for(let e=0,t=l.links.length;e<t;++e){let t=l.links[e];t.v!=n.htmlCls.hbondValue&&t.v!=n.htmlCls.ionicValue&&t.v!=n.htmlCls.halogenValue&&t.v!=n.htmlCls.picationValue&&t.v!=n.htmlCls.pistackingValue&&t.v!=n.htmlCls.contactValue||(r.push(t),c[t.source]=1,c[t.target]=1)}let h=i.getGraphCls.getNodeTopBottom(c,d);o=h.nodeArray1,a=h.nodeArray2,i.lineGraphStr="{\n";let p=Object.keys(i.structures);if(p.length>1){let e={},l=[],o=[],a=[],c=[],h=[],m=[],u=[],g=[],f=[],C=[],b=[],y=[],v={},_={},w={};for(let t=0,s=p.length;t<s;++t)l[t]=[],o[t]=[],a[t]=[],c[t]={},h[t]=[],m[t]=[],u[t]=[],g[t]={},f[t]=[],C[t]=[],b[t]=[],y[t]={},e[p[t]]=t;for(let t=0,s=r.length;t<s;++t){let s=r[t],n=d[s.source],l=d[s.target];if(!(n&&l&&n.r&&l.r))continue;let o=this.getIdArrayFromNode(n),h=this.getIdArrayFromNode(l),m=e[o[2]];if(o[2]==p[m]&&h[2]==p[m]){a[m].push(s),c[m][s.source]=1,c[m][s.target]=1;let e,t,l=o[2]+"_"+o[3],r=h[2]+"_"+h[3],d=l+"_"+o[4],p=r+"_"+h[4];if(i.chainsMapping[l]&&i.chainsMapping[l][d]&&i.chainsMapping[r]&&i.chainsMapping[r][p]){e="a"==n.s?i.chainsMapping[l][d]:i.chainsMapping[r][p],t="a"==n.s?i.chainsMapping[r][p]:i.chainsMapping[l][d];let o=e+"_"+t+"_"+s.c;v.hasOwnProperty(o)?(++v[o],_[o]+=s.n,w[o]=_[o]/s.n==v[o]?0:1):(v[o]=1,_[o]=s.n)}}}let S="=>",A="==>",x="-",k="--";for(let t=0,s=r.length;t<s;++t){let s=r[t],l=d[s.source],o=d[s.target];if(!(l&&o&&l.r&&o.r))continue;let h=this.getIdArrayFromNode(l),m=this.getIdArrayFromNode(o),f=e[h[2]];if(h[2]==p[f]&&m[2]==p[f]){a[f].push(s),c[f][s.source]=1,c[f][s.target]=1;let e,t,r=h[2]+"_"+h[3],o=m[2]+"_"+m[3],d=r+"_"+h[4],C=o+"_"+m[4];if(i.chainsMapping[r]&&i.chainsMapping[r][d]&&i.chainsMapping[o]&&i.chainsMapping[o][C]){e="a"==l.s?i.chainsMapping[r][d]:i.chainsMapping[o][C],t="a"==l.s?i.chainsMapping[o][C]:i.chainsMapping[r][d];let a=e.length>4&&!isNaN(parseInt(e.substr(-4,4)))||t.length>4&&!isNaN(parseInt(t.substr(-4,4))),c=e+"_"+t+"_"+s.c,h=n.hashUtilsCls.cloneHash(s);h.source+=S+i.chainsMapping[r][d],h.target+=S+i.chainsMapping[o][C];let m=n.hashUtilsCls.cloneHash(s);m.source+=A+i.chainsMapping[r][d],m.target+=A+i.chainsMapping[o][C],v[c]!=p.length||!a&&0!=w[c]?b[f].push(m):u[f].push(h),g[f][s.source]=i.chainsMapping[r][d],g[f][s.target]=i.chainsMapping[o][C],y[f][s.source]=i.chainsMapping[r][d],y[f][s.target]=i.chainsMapping[o][C]}else{let e=n.hashUtilsCls.cloneHash(s);e.source+=i.chainsMapping[r]&&i.chainsMapping[r][d]?A+i.chainsMapping[r][d]:A+k,e.target+=i.chainsMapping[o]&&i.chainsMapping[o][C]?A+i.chainsMapping[o][C]:A+k,b[f].push(e),g[f][s.source]=i.chainsMapping[r]&&i.chainsMapping[r][d]?i.chainsMapping[r][d]:x,g[f][s.target]=i.chainsMapping[o]&&i.chainsMapping[o][C]?i.chainsMapping[o][C]:x,y[f][s.source]=i.chainsMapping[r]&&i.chainsMapping[r][d]?i.chainsMapping[r][d]:k,y[f][s.target]=i.chainsMapping[o]&&i.chainsMapping[o][C]?i.chainsMapping[o][C]:k}}}let O=[],R=[],I=0,E=[],T=1;for(let e=0,t=p.length;e<t;++e){let t=i.getGraphCls.getNodeTopBottom(c[e],d);l[e]=t.nodeArray1,o[e]=t.nodeArray2,Object.keys(i.chainsMapping).length>0&&(T=1,t=i.getGraphCls.getNodeTopBottom(c[e],d,void 0,T,g[e]),h[e]=t.nodeArray1,m[e]=t.nodeArray2,d=n.hashUtilsCls.unionHash(d,t.name2node),T=2,t=i.getGraphCls.getNodeTopBottom(c[e],d,void 0,T,y[e]),f[e]=t.nodeArray1,C[e]=t.nodeArray2,d=n.hashUtilsCls.unionHash(d,t.name2node)),O[e]=l[e].length,R[e]=o[e].length,I=Math.max(I,R[e]),E.push(p[e])}let P,D,M,F,H,L=1,N=3*L,q=7*L,U=10,$=10,B=30,j=20;t?(M=(n.utilsCls.sumArray(O)+2*E.length)*(N+q)+4*$+2*B+j*E.length,D=(I+2)*(N+q)+2*U+B):(P=110+j,M=P*E.length,D=(I+2)*(N+q)+2*U,D+=20),Object.keys(i.chainsMapping).length>0&&(M*=3),t?(i.scatterplotWidth=2*D,H=i.scatterplotWidth,F=n.scatterplotid):(i.linegraphWidth=2*D,H=i.linegraphWidth,F=n.linegraphid),s=0==E.length?"No interactions found for each structure<br><br>":"2D integration graph for "+E.length+" structure(s) <b>"+E+'</b>. There are three sections: "Interactions", "Common interactions", and "Different interactions". Each section has '+E.length+" graphs.<br><br>",s+="<svg id='"+F+"' viewBox='0,0,"+D+","+M+"' width='"+H+"px'>";let z,G=0;T=0,z=this.drawGraphPerType(T,p,t,l,o,a,d,G,P,j,O,N,q,$),G=z.heightFinal,s+=z.html,Object.keys(i.chainsMapping).length>0&&(T=1,z=this.drawGraphPerType(T,p,t,h,m,u,d,G,P,j,O,N,q,$),G=z.heightFinal,s+=z.html,T=2,z=this.drawGraphPerType(T,p,t,f,C,b,d,G,P,j,O,N,q,$),G=z.heightFinal,s+=z.html),s+="</svg>"}else if(t){let e,t,l,c,h=p[0],m=1,u=3*m,g=7*m,f=30;t=(o.length+2)*(u+g)+2*10+f,e=(a.length+2)*(u+g)+2*10+f,i.scatterplotWidth=2*e,c=i.scatterplotWidth,l=n.scatterplotid,s=r.length>0?"":"No interactions found for these two sets<br><br>",s+="<svg id='"+l+"' viewBox='0,0,"+e+","+t+"' width='"+c+"px'>",s+=this.drawScatterplot_base(o,a,r,d,0),i.lineGraphStr+=i.getGraphCls.updateGraphJson(h,1,o,a,r),s+="</svg>"}else{let e=p[0],t=o.length,l=a.length,c=1,h=3*c,m=7*c,u=110,g=10,f=t>l?t*(h+m)+2*g:l*(h+m)+2*g;i.linegraphWidth=2*f,s=r.length>0?"":"No interactions found for these two sets<br><br>",s+="<svg id='"+n.linegraphid+"' viewBox='0,0,"+f+","+u+"' width='"+i.linegraphWidth+"px'>",s+=this.drawLineGraph_base(o,a,r,d,0),i.lineGraphStr+=i.getGraphCls.updateGraphJson(e,1,o,a,r),s+="</svg>"}return i.lineGraphStr+="}\n",i.scatterplotStr=i.lineGraphStr,t?$("#"+i.pre+"scatterplotDiv").html(s):$("#"+i.pre+"linegraphDiv").html(s),s}drawGraphPerType(e,t,s,i,n,l,r,o,a,d,c,h,p,m){let u=this.icn3d;u.icn3dui;let g,f,C="",b=2==t.length&&"2"==t[1].replace(t[0],"");0==e?(g="Interactions in ",f=""):1==e?(g="Common interactions in ",f="_common"):2==e&&(g="Different interactions in ",f="_diff");for(let y=0,v=t.length;y<v;++y){let v=g;b&&(0==y?v+="Wild Type ":1==y&&(v+="Mutant ")),s?(C+=this.drawScatterplot_base(i[y],n[y],l[y],r,o,void 0,v+t[y],d),a=(c[y]+1)*(h+p)+2*m+d):C+=this.drawLineGraph_base(i[y],n[y],l[y],r,o,v+t[y],d),o+=a,e?y>0&&(u.lineGraphStr+=", \n"):u.lineGraphStr+=", \n",u.lineGraphStr+=u.getGraphCls.updateGraphJson(t[y],y+f,i[y],n[y],l[y])}return{heightFinal:o,html:C}}getIdArrayFromNode(e){let t=this.icn3d.icn3dui,s=[];s.push(""),s.push("");let i=e.r.substr(4);return s=s.concat(t.utilsCls.getIdArray(i)),s}drawLineGraph_base(e,t,s,i,n,l,r){let o,a,d=this.icn3d,c=d.icn3dui,h="",p=e.length,m=t.length;p>m?(o=10,a=10*Math.abs(p-m)*.5+10):(a=10,o=10*Math.abs(p-m)*.5+10),l&&(h+="<text x='10' y='"+(n+=r)+"' style='font-size:8px; font-weight:bold'>"+l+"</text>");let u=30+n,g=80+n,f="",C={},b={};for(let t=0;t<p;++t)f+=d.getGraphCls.drawResNode(e[t],t,3,7,o,u,"a"),C[e[t].id]={x:o+10*t,y:u};for(let e=0;e<m;++e)f+=d.getGraphCls.drawResNode(t[e],e,3,7,a,g,"b"),b[t[e].id]={x:a+10*e,y:g};for(let e=0,t=s.length;e<t;++e){let t=s[e],n=i[t.source],l=i[t.target];if(void 0===n||void 0===l)continue;let r,o=n.r.substr(4),a=l.r.substr(4),d=C[n.id],p=b[l.id];if(void 0===d||void 0===p)continue;r=t.v==c.htmlCls.contactValue?1:1==t.n?2:4;let m=this.getStrokecolor(t.v);h+="<g class='icn3d-interaction' resid1='"+o+"' resid2='"+a+"' >";let u=1==t.n?"Interaction":t.n+" interactions";t.n>1&&(h+="<title>"+u+" of residue "+n.id+" with residue "+l.id+"</title>"),h+="<line x1='"+d.x+"' y1='"+d.y+"' x2='"+p.x+"' y2='"+p.y+"' stroke='"+m+"' stroke-width='"+r+"'/></g>"}return h+=f,h}drawScatterplot_base(e,t,s,i,n,l,r,o,a){let d=this.icn3d;d.icn3dui;let c="",h=e.length,p=t.length,m=l?3:7,u=(h+1)*(3+m)+30+40;r&&(c+="<text x='10' y='"+((n+=o)+15).toString()+"' style='font-size:8px; font-weight:bold'>"+r+"</text>");let g=n+u-(50+(3+m)),f=40+(3+m),C="",b={},y={};for(let t=0;t<h;++t)C+=d.getGraphCls.drawResNode(e[t],t,3,m,g,40,"a",!0,void 0,a),b[e[t].id]={x:40,y:g-t*(3+m)};let v=n+u-50;for(let e=0;e<p;++e)C+=d.getGraphCls.drawResNode(t[e],e,3,m,f,v,"b",!1,l,a),y[t[e].id]={x:f+e*(3+m),y:v};for(let e=0,t=s.length;e<t;++e){let t=s[e],n=i[t.source],r=i[t.target];n&&r&&(c+=this.drawOnePairNode(t,n,r,b,y,l,a),l&&!a&&(c+=this.drawOnePairNode(t,r,n,b,y,l,a)))}return c+=C,c}getStrokecolor(e,t){let s=this.icn3d.icn3dui,i="#000";return e&&(e==s.htmlCls.hbondValue?i="#"+s.htmlCls.hbondColor:e==s.htmlCls.ionicValue?i="#"+s.htmlCls.ionicColor:e==s.htmlCls.halogenValue?i="#"+s.htmlCls.halogenColor:e==s.htmlCls.picationValue?i="#"+s.htmlCls.picationColor:e==s.htmlCls.pistackingValue?i="#"+s.htmlCls.pistackingColor:e==s.htmlCls.contactValue&&(i="#"+s.htmlCls.contactColor)),t&&("hbond"==t?i="#"+s.htmlCls.hbondColor:"ionic"==t?i="#"+s.htmlCls.ionicColor:"halogen"==t?i="#"+s.htmlCls.halogenColor:"pi-cation"==t?i="#"+s.htmlCls.picationColor:"pi-stacking"==t?i="#"+s.htmlCls.pistackingColor:"contact"==t&&(i="#"+s.htmlCls.contactColor)),i}drawOnePairNode(e,t,s,i,n,l,r){let o=this.icn3d,a=o.icn3dui,d="",c=l?6:4.5,h=.5*c,p=t.r.substr(4),m=s.r.substr(4),u=i[t.id],g=n[s.id];if(void 0===u||void 0===g)return d;let f,C=this.getStrokecolor(e.v);if(l&&(C="#"+e.c),f=e.v==a.htmlCls.contactValue?1:1==e.n?2:4,r&&o.hex2skip[e.c]);else if(r&&o.hex2id[e.c])o.hex2id[e.c],d+="<rect class='icn3d-interaction' resid1='"+p+"' resid2='"+m+"' x='"+(g.x-h).toString()+"' y='"+(u.y-h).toString()+"' width='"+c+"' height='"+c+"' fill='"+C+"' stroke-width='"+f+"' stroke='"+C+"' />";else{d+="<g class='icn3d-interaction' resid1='"+p+"' resid2='"+m+"' >";let i=1==e.n?"Interaction":e.n+" interactions";e.n>1&&(d+="<title>"+i+" of residue "+t.id+" with residue "+s.id+"</title>"),d+=l?"<rect x='"+(g.x-h).toString()+"' y='"+(u.y-h).toString()+"' width='"+c+"' height='"+c+"' fill='"+C+"' stroke-width='"+f+"' stroke='"+C+"' />":"<rect x='"+(g.x-h).toString()+"' y='"+(u.y-h).toString()+"' width='"+c+"' height='"+c+"' fill='"+C+"' fill-opacity='0.6' stroke-width='"+f+"' stroke='"+C+"' />",d+="</g>"}return d}copyStylesInline(e,t){this.icn3d.icn3dui;let s=["svg","g"];for(let i=0;i<e.childNodes.length;i++){let n=e.childNodes[i];if(-1!=s.indexOf(n.tagName)){this.copyStylesInline(n,t.childNodes[i]);continue}let l=t.childNodes[i].currentStyle||window.getComputedStyle(t.childNodes[i]);if("undefined"!=l&&null!=l)for(let e=0;e<l.length;e++)n.style.setProperty(l[e],l.getPropertyValue(l[e]))}}}class qt{constructor(e){this.icn3d=e}getGraphData(e,t,s,i,n,l,r){let o=this.icn3d,a=o.icn3dui,d="",c="",h=[],p=[],m=this.getNodesLinksForSet(e,l,"a",r),u=this.getNodesLinksForSet(t,l,"b",r);h=m.node.concat(u.node);let g=[],f={},C=0;for(let e=0,t=h.length;e<t;++e){let t=h[e],s=JSON.parse(t);if(f.hasOwnProperty(s.id)){g[f[s.id]].s="ab"}else g.push(s),f[s.id]=C,++C}let b=[];for(let e=0,t=g.length;e<t;++e){let t=g[e];b.push(JSON.stringify(t))}d=b.join(", "),p=m.link.concat(u.link),c=p.join(", ");let y=a.hashUtilsCls.unionHash(a.hashUtilsCls.cloneHash(t),e),v="",_="",w="",S="",A="",x="";1==s.length&&1==i.length&&s[0]==i[0]||(v+=this.getHbondLinksForSet(e,l),v+=this.getHbondLinksForSet(t,l)),1==s.length&&1==i.length&&s[0]==i[0]||(_+=this.getIonicLinksForSet(e,l),_+=this.getIonicLinksForSet(t,l)),1==s.length&&1==i.length&&s[0]==i[0]||(w+=this.getHalogenPiLinksForSet(e,l),w+=this.getHalogenPiLinksForSet(t,l)),1==s.length&&1==i.length&&s[0]==i[0]||(S+=this.getContactLinksForSet(e,l),S+=this.getContactLinksForSet(t,l));for(let e in o.ssbondpnts)for(let t=0,s=o.ssbondpnts[e].length;t<s;t+=2){let s=o.ssbondpnts[e][t],i=o.ssbondpnts[e][t+1],n=o.firstAtomObjCls.getFirstAtomObj(o.residues[s]),r=o.firstAtomObjCls.getFirstAtomObj(o.residues[i]);if(y.hasOwnProperty(n.serial)&&y.hasOwnProperty(r.serial)){let e=a.utilsCls.residueName2Abbr(n.resn)+n.resi;"chain"!=l&&"structure"!=l||(e+="."+n.chain),"structure"==l&&(e+="."+n.structure);let t=a.utilsCls.residueName2Abbr(r.resn)+r.resi;"chain"!=l&&"structure"!=l||(t+="."+r.chain),"structure"==l&&(t+="."+r.structure),A+=', {"source": "'+e+'", "target": "'+t+'", "v": '+a.htmlCls.ssbondValue+', "c": "'+a.htmlCls.ssbondColor+'"}'}}for(let e in o.clbondpnts)for(let t=0,s=o.clbondpnts[e].length;t<s;t+=2){let s=o.clbondpnts[e][t],i=o.clbondpnts[e][t+1],n=o.firstAtomObjCls.getFirstAtomObj(o.residues[s]),r=o.firstAtomObjCls.getFirstAtomObj(o.residues[i]);if(y.hasOwnProperty(n.serial)&&y.hasOwnProperty(r.serial)){let e=a.utilsCls.residueName2Abbr(n.resn)+n.resi;"chain"!=l&&"structure"!=l||(e+="."+n.chain),"structure"==l&&(e+="."+n.structure);let t=a.utilsCls.residueName2Abbr(r.resn)+r.resi;"chain"!=l&&"structure"!=l||(t+="."+r.chain),"structure"==l&&(t+="."+r.structure),x+=', {"source": "'+e+'", "target": "'+t+'", "v": '+a.htmlCls.clbondValue+', "c": "'+a.htmlCls.clbondColor+'"}'}}let k='{"nodes": ['+d+'], "links": [';return k+=""==c?c+n.substr(1)+A+x+S+v+_+w:c+n+A+x+S+v+_+w,k+="]}",k}drawResNode(e,t,s,i,n,l,r,o,a,d){let c=this.icn3d;c.icn3dui;let h,p=e.r.substr(4);h=o?n-t*(s+i):n+t*(s+i),c.firstAtomObjCls.getFirstAtomObj(c.residues[p]);let m="#"+e.c.toUpperCase();c.hColor.getHexString().toUpperCase();let u=e.id.indexOf("."),g=-1==u?e.id:e.id.substr(0,u),f="a"==r?-7:10;if(t%2==1&&(f="a"==r?f-7:f+7),a&&(g=g.substr(1),o||(f+=4*s)),c.bShownRefnum&&c.resid2refnum[p]){let e=c.resid2refnum[p],t=c.refnumCls.rmStrandFromRefnumlabel(e);g=c.residueId2Name[p]+t}let C="#000",b="#000",y="<g class='icn3d-node' resid='"+p+"' >",v=e.id;return c.resid2refnum[p]&&(v+="=>"+c.resid2refnum[p]),y+="<title>"+v+"</title>",o?(y+="<circle cx='"+l+"' cy='"+h+"' r='"+s+"' fill='"+m+"' stroke-width='1' stroke='"+C+"' resid='"+p+"' />",y+="<text x='"+(l-20).toString()+"' y='"+(h+2).toString()+"' fill='"+b+"' stroke='none' style='font-size:6px; text-anchor:middle' >"+g+"</text>"):(y+="<circle cx='"+h+"' cy='"+l+"' r='"+s+"' fill='"+m+"' stroke-width='1' stroke='"+C+"' resid='"+p+"' />",y+="<text x='"+(h+0).toString()+"' y='"+(l+f).toString()+"' fill='"+b+"' stroke='none' style='font-size:6px; text-anchor:middle' >"+g+"</text>"),y+="</g>",y}getNodeTopBottom(e,t,s,i,n){let l=this.icn3d.icn3dui,r=this,o=[],a=[],d={};for(let s in e){let e=t[s];if(e){if(1==i||2==i){if(e=l.hashUtilsCls.cloneHash(e),1==i){let t=n[s]?n[s]:"-";e.id+="=>"+t}else{let t=n[s]?n[s]:"--";e.id+="==>"+t}d[e.id]=e}"a"==e.s?o.push(e):"b"==e.s?a.push(e):"ab"==e.s&&(o.push(e),a.push(e))}}return o.sort((function(e,t){return r.compNode(e,t)})),a.sort((function(e,t){return r.compNode(e,t,s)})),{nodeArray1:o,nodeArray2:a,name2node:d}}updateGraphJson(e,t,s,i,n){let l=this.icn3d.icn3dui,r="";return r+='"structure'+t+'": {"id": "'+e+'", "nodes1":[',r+=l.utilsCls.getJSONFromArray(s),r+='], \n"nodes2":[',r+=l.utilsCls.getJSONFromArray(i),r+='], \n"links":[',r+=l.utilsCls.getJSONFromArray(n),r+="]}",r}updateGraphColor(){this.icn3d.icn3dui}handleForce(){let e=this.icn3d;0==e.icn3dui.htmlCls.force&&void 0!==e.simulation?(e.simulation.stop(),e.simulation.force("charge",null),e.simulation.force("x",null),e.simulation.force("y",null),e.simulation.force("r",null),e.simulation.force("link",null)):e.drawGraphCls.drawGraph(e.graphStr,e.pre+"dl_graph")}getNodesLinksForSet(e,t,s,i){let n=this.icn3d,l=n.icn3dui,r=[],o=[],a=0,d=l.htmlCls.coilValue,c="",h="",p=0,m={};for(let u in e){let e=n.atoms[u];if("DUM"!=e.chain&&(i||e.het||"CA"==e.name&&"C"==e.elem||"O3'"==e.name||"O3*"==e.name||"P"==e.name)){let i=e.structure+"_"+e.chain+"_"+e.resi;if(m.hasOwnProperty(i))continue;m[i]=1;let u=l.utilsCls.residueName2Abbr(e.resn)+e.resi;"chain"!=t&&"structure"!=t||(u+="."+e.chain),"structure"==t&&(u+="."+e.structure);let g="1_1_"+i,f=e.color?e.color.getHexString().toUpperCase():"000";r.push('{"id": "'+u+'", "r": "'+g+'", "s": "'+s+'", "x": '+e.coord.x.toFixed(0)+', "y": '+e.coord.y.toFixed(0)+', "c": "'+f+'"}'),a>0&&c==e.chain&&(n.resid2ncbi[e.resi]==n.resid2ncbi[p]+1||n.resid2ncbi[e.resi]==n.resid2ncbi[p])&&(o.push('{"source": "'+h+'", "target": "'+u+'", "v": '+d+', "c": "'+f+'"}'),e.ssbegin&&(d=l.htmlCls.ssValue),e.ssend&&(d=l.htmlCls.coilValue)),c=e.chain,h=u,p=e.resi,++a}}return{node:r,link:o}}getHbondLinksForSet(e,t){let s=this.icn3d,i=s.icn3dui,n={},l=parseFloat($("#"+s.pre+"hbondthreshold").val()),r=e,o=r;if(Object.keys(o).length>0&&Object.keys(r).length>0){let e=!1;s.hBondCls.calculateChemicalHbonds(i.hashUtilsCls.hash2Atoms(o,s.atoms),i.hashUtilsCls.hash2Atoms(r,s.atoms),parseFloat(l),e,"graph",!0),n=i.hashUtilsCls.cloneHash(s.resid2Residhash)}return this.getGraphLinks(n,n,i.htmlCls.hbondInsideColor,t,i.htmlCls.hbondInsideValue)}getIonicLinksForSet(e,t){let s=this.icn3d,i=s.icn3dui,n={},l=parseFloat($("#"+s.pre+"saltbridgethreshold").val()),r=e,o=r;if(Object.keys(o).length>0&&Object.keys(r).length>0){let e=!1;s.saltbridgeCls.calculateIonicInteractions(i.hashUtilsCls.hash2Atoms(o,s.atoms),i.hashUtilsCls.hash2Atoms(r,s.atoms),parseFloat(l),e,"graph",!0),n=i.hashUtilsCls.cloneHash(s.resid2Residhash)}return this.getGraphLinks(n,n,i.htmlCls.ionicInsideColor,t,i.htmlCls.ionicInsideValue)}getHalogenPiLinksForSet(e,t){let s,i=this.icn3d,n=i.icn3dui,l={},r=e,o=r,a="";return s=parseFloat($("#"+i.pre+"halogenthreshold").val()),Object.keys(o).length>0&&Object.keys(r).length>0&&(i.piHalogenCls.calculateHalogenPiInteractions(n.hashUtilsCls.hash2Atoms(r,i.atoms),n.hashUtilsCls.hash2Atoms(o,i.atoms),parseFloat(s),"graph","halogen",!0),l=n.hashUtilsCls.cloneHash(i.resid2Residhash)),a+=this.getGraphLinks(l,l,n.htmlCls.halogenInsideColor,t,n.htmlCls.halogenInsideValue),s=parseFloat($("#"+i.pre+"picationthreshold").val()),Object.keys(o).length>0&&Object.keys(r).length>0&&(i.piHalogenCls.calculateHalogenPiInteractions(n.hashUtilsCls.hash2Atoms(r,i.atoms),n.hashUtilsCls.hash2Atoms(o,i.atoms),parseFloat(s),"graph","pi-cation",!0),l=n.hashUtilsCls.cloneHash(i.resid2Residhash)),a+=this.getGraphLinks(l,l,n.htmlCls.picationInsideColor,t,n.htmlCls.picationInsideValue),s=parseFloat($("#"+i.pre+"pistackingthreshold").val()),Object.keys(o).length>0&&Object.keys(r).length>0&&(i.piHalogenCls.calculateHalogenPiInteractions(n.hashUtilsCls.hash2Atoms(r,i.atoms),n.hashUtilsCls.hash2Atoms(o,i.atoms),parseFloat(s),"graph","pi-stacking",!0),l=n.hashUtilsCls.cloneHash(i.resid2Residhash)),a+=this.getGraphLinks(l,l,n.htmlCls.pistackingInsideColor,t,n.htmlCls.pistackingInsideValue),a}getContactLinksForSet(e,t,s){let i=this.icn3d;i.icn3dui;let n=[],l="",r="",o={};for(let t in e){let e=i.atoms[t];e.ss==l&&e.chain==r||(Object.keys(o).length>0&&n.push(o),o={}),o[e.serial]=1,l=e.ss,r=e.chain}Object.keys(o).length>0&&n.push(o);let a=n.length,d="";for(let e=0;e<a;++e)for(let i=e+1;i<a;++i)d+=this.getContactLinks(n[e],n[i],t,!0,s);return d}getContactLinks(e,t,s,i,n){let l=this.icn3d,r=l.icn3dui,o=parseFloat($("#"+l.pre+"contactthreshold").val());l.contactCls.getAtomsWithinAtom(t,e,parseFloat(o),!0,!1,i);let a=r.hashUtilsCls.cloneHash(l.resid2Residhash);return this.getGraphLinks(a,a,r.htmlCls.contactInsideColor,s,r.htmlCls.contactInsideValue,n)}compNode(e,t,s){let i=this.icn3d.icn3dui,n=e.r.substr(4),l=t.r.substr(4),r=i.utilsCls.getIdArray(n),o=i.utilsCls.getIdArray(l),a=r[0]+"_"+r[1],d=o[0]+"_"+o[1],c=parseInt(r[2]),h=parseInt(o[2]);return a>d?s?-1:1:a<d?s?1:-1:a==d?c>h?1:c<h?-1:0:void 0}getGraphLinks(e,t,s,i,n,l){var r=this.icn3d,o=r.icn3dui;let a="";n=void 0===n?1:n;let d={};for(let a in e){let e=a.trim(),c=e.split(" ");3==c.length&&(a=c[0]+" "+c[1]);let h=a.indexOf(" "),p=a.indexOf(":"),m=a.indexOf("@"),u=-1!==m?m:a.length,g=a.indexOf("."),f=a.indexOf("$"),C=o.utilsCls.residueName2Abbr(a.substr(0,h))+a.substr(p+1,u-p-1);"chain"!=i&&"structure"!=i||(C+="."+a.substr(g+1,p-g-1)),"structure"==i&&(C+="."+a.substr(f+1,g-f-1));for(let a in t[e]){let e=a.trim().split(" ");3==e.length&&(a=e[0]+" "+e[1]);let t=a.indexOf(" "),c=a.indexOf(":"),h=a.indexOf("@"),p=-1!==h?h:a.length,m=a.indexOf("."),u=a.indexOf("$"),g=o.utilsCls.residueName2Abbr(a.substr(0,t))+a.substr(c+1,p-c-1);if(a.substr(m+1,c-m-1),"chain"!=i&&"structure"!=i||(g+="."+a.substr(m+1,c-m-1)),"structure"==i&&(g+="."+a.substr(u+1,m-u-1)),l&&(C=r.resi2resirange[C],g=r.resi2resirange[g]),void 0!==C&&void 0!==g){let e='"source": "'+C+'", "target": "'+g+'", "v": '+n+', "c": "'+s+'"';d.hasOwnProperty(e)?++d[e]:d[e]=1}}}for(let e in d){a+=", {"+e+', "n": '+(n==o.htmlCls.contactInsideValue||n==o.htmlCls.contactValue?1:d[e])+"}"}return a}convertLabel2Resid(e){this.icn3d.icn3dui;let t=e.split(" ");(e=2==t.length?e:e.substr(0,e.lastIndexOf(" "))).indexOf(" ");let s=e.indexOf("@"),i=-1!==s?s:e.length,n=e.indexOf("$"),l=e.indexOf("."),r=e.indexOf(":");return e.substr(n+1,l-n-1)+"_"+e.substr(l+1,r-l-1)+"_"+e.substr(r+1,i-r-1)}}class Ut{constructor(e){this.icn3d=e}async showInteractions(e){let t,s,i=this.icn3d,n=i.icn3dui,l=$("#"+i.pre+"atomsCustomHbond").val(),r=$("#"+i.pre+"atomsCustomHbond2").val();if(t=i.definedSetsCls.getAtomsFromNameArray(l),s=i.definedSetsCls.getAtomsFromNameArray(r),i.dAtoms=n.hashUtilsCls.unionHash(i.dAtoms,t),i.dAtoms=n.hashUtilsCls.unionHash(i.dAtoms,s),"ligplot"==e){let e=i.firstAtomObjCls.getResiduesFromAtoms(t),n=i.firstAtomObjCls.getResiduesFromAtoms(s);if(Object.keys(e).length>1&&Object.keys(n).length>1)return void alert("Please select one ligand or residue as one of the interaction sets...");Object.keys(e).length<Object.keys(n).length&&(r=$("#"+i.pre+"atomsCustomHbond").val(),l=$("#"+i.pre+"atomsCustomHbond2").val(),t=i.definedSetsCls.getAtomsFromNameArray(l),s=i.definedSetsCls.getAtomsFromNameArray(r))}if(0==r.length)alert("Please select the first set");else{i.definedSetsCls.setMode("selection");let t=$("#"+i.pre+"analysis_hbond")[0].checked,s=$("#"+i.pre+"analysis_saltbridge")[0].checked,o=$("#"+i.pre+"analysis_contact")[0].checked,a=$("#"+i.pre+"analysis_halogen")[0].checked,d=$("#"+i.pre+"analysis_pication")[0].checked,c=$("#"+i.pre+"analysis_pistacking")[0].checked,h="threshold "+$("#"+i.pre+"hbondthreshold").val()+" "+$("#"+i.pre+"saltbridgethreshold").val()+" "+$("#"+i.pre+"contactthreshold").val()+" "+$("#"+i.pre+"halogenthreshold").val()+" "+$("#"+i.pre+"picationthreshold").val()+" "+$("#"+i.pre+"pistackingthreshold").val(),p=(await i.viewInterPairsCls.viewInteractionPairs(r,l,i.bHbondCalc,e,t,s,o,a,d,c)).interactionTypes,m=i.bHbondCalc?"true":"false",u=r+" "+l+" | "+p+" | "+m+" | "+h;if("3d"==e)n.htmlCls.clickMenuCls.setLogCmd("display interaction 3d | "+u,!0);else if("view"==e)n.htmlCls.clickMenuCls.setLogCmd("view interaction pairs | "+u,!0);else if("save1"==e)n.htmlCls.clickMenuCls.setLogCmd("save1 interaction pairs | "+u,!0);else if("save2"==e)n.htmlCls.clickMenuCls.setLogCmd("save2 interaction pairs | "+u,!0);else if("linegraph"==e)n.htmlCls.clickMenuCls.setLogCmd("line graph interaction pairs | "+u,!0);else if("scatterplot"==e)n.htmlCls.clickMenuCls.setLogCmd("scatterplot interaction pairs | "+u,!0);else if("ligplot"==e)n.htmlCls.clickMenuCls.setLogCmd("ligplot interaction pairs | "+u,!0);else if("graph"==e){let e=parseInt($("#"+i.pre+"dist_ss").val()),t=parseInt($("#"+i.pre+"dist_coil").val()),s=parseInt($("#"+i.pre+"dist_hbond").val()),o=parseInt($("#"+i.pre+"dist_inter").val()),a=parseInt($("#"+i.pre+"dist_ssbond").val()),d=parseInt($("#"+i.pre+"dist_ionic").val()),c=parseInt($("#"+i.pre+"dist_halogen").val()),u=parseInt($("#"+i.pre+"dist_pication").val()),g=parseInt($("#"+i.pre+"dist_pistacking").val());n.htmlCls.clickMenuCls.setLogCmd("graph interaction pairs | "+r+" "+l+" | "+p+" | "+m+" | "+h+" | "+e+" "+t+" "+s+" "+o+" "+a+" "+d+" "+c+" "+u+" "+g,!0)}i.bHbondCalc=!0}}showHbonds(e,t,s,i,n,l){let r,o,a,d,c=this.icn3d,h=c.icn3dui;if(!i&&(n?(r="saltbridge",o="salt bridge "+e+" | sets "+t+" "+s+" | "+i):(r="hbonds",o="hbonds "+e+" | sets "+t+" "+s+" | "+i),c.opts[r]="yes",c.opts.water="dot",a=c.definedSetsCls.getAtomsFromNameArray(t),d=c.definedSetsCls.getAtomsFromNameArray(s),Object.keys(d).length>0&&Object.keys(a).length>0)){let t,s=c.hBondCls.calculateChemicalHbonds(h.hashUtilsCls.hash2Atoms(d,c.atoms),h.hashUtilsCls.hash2Atoms(a,c.atoms),parseFloat(e),n);n?(c.resid2ResidhashSaltbridge=h.hashUtilsCls.cloneHash(c.resid2Residhash),t="all atoms that have salt bridges with the selected atoms"):(c.resid2ResidhashHbond=h.hashUtilsCls.cloneHash(c.resid2Residhash),t="all atoms that are hydrogen-bonded with the selected atoms");let i={};for(let e in s){i[c.atoms[e].structure+"_"+c.atoms[e].chain+"_"+c.atoms[e].resi]=1}c.hAtoms={};for(let e in i)for(let t in c.residues[e])c.hAtoms[t]=1,c.atoms[t].style2="stick";let l=r+"_auto";c.selectionCls.addCustomSelection(Object.keys(i),l,t,o,!0),c.selectionCls.saveSelectio