var $NGL_shaderTextHash = {};

$NGL_shaderTextHash['SphereImpostor.frag'] = ["#define STANDARD",
"#define IMPOSTOR",
"",
"uniform vec3 diffuse;",
"uniform vec3 emissive;",
"uniform float roughness;",
"uniform float metalness;",
"uniform float opacity;",
"uniform float nearClip;",
"uniform mat4 projectionMatrix;",
"uniform float ortho;",
"",
"varying float vRadius;",
"varying float vRadiusSq;",
"varying vec3 vPoint;",
"varying vec3 vPointViewPosition;",
"",
"#ifdef PICKING",
"    uniform float objectId;",
"    varying vec3 vPickingColor;",
"#else",
"    #include common",
"    #include color_pars_fragment",
"    #include fog_pars_fragment",
"    #include bsdfs",
"    #include lights_pars_begin",
"    #include lights_physical_pars_fragment",
"#endif",
"",
"bool flag2 = false;",
"bool interior = false;",
"vec3 cameraPos;",
"vec3 cameraNormal;",
"",
"// Calculate depth based on the given camera position.",
"float calcDepth( in vec3 cameraPos ){",
"    vec2 clipZW = cameraPos.z * projectionMatrix[2].zw + projectionMatrix[3].zw;",
"    return 0.5 + 0.5 * clipZW.x / clipZW.y;",
"}",
"",
"float calcClip( vec3 cameraPos ){",
"    return dot( vec4( cameraPos, 1.0 ), vec4( 0.0, 0.0, 1.0, nearClip - 0.5 ) );",
"}",
"",
"bool Impostor( out vec3 cameraPos, out vec3 cameraNormal ){",
"",
"    vec3 cameraSpherePos = -vPointViewPosition;",
"    cameraSpherePos.z += vRadius;",
"",
"    vec3 rayOrigin = mix( vec3( 0.0, 0.0, 0.0 ), vPoint, ortho );",
"    vec3 rayDirection = mix( normalize( vPoint ), vec3( 0.0, 0.0, 1.0 ), ortho );",
"    vec3 cameraSphereDir = mix( cameraSpherePos, rayOrigin - cameraSpherePos, ortho );",
"",
"    float B = dot( rayDirection, cameraSphereDir );",
"    float det = B * B + vRadiusSq - dot( cameraSphereDir, cameraSphereDir );",
"",
"    if( det < 0.0 ){",
"        discard;",
"        return false;",
"    }",
"        float sqrtDet = sqrt( det );",
"        float posT = mix( B + sqrtDet, B + sqrtDet, ortho );",
"        float negT = mix( B - sqrtDet, sqrtDet - B, ortho );",
"",
"        cameraPos = rayDirection * negT + rayOrigin;",
"",
"        #ifdef NEAR_CLIP",
"if( calcDepth( cameraPos ) <= 0.0 ){",
"    cameraPos = rayDirection * posT + rayOrigin;",
"    interior = true;",
"    return false;",
"}else if( calcClip( cameraPos ) > 0.0 ){",
"    cameraPos = rayDirection * posT + rayOrigin;",
"    interior = true;",
"    flag2 = true;",
"    return false;",
"}else{",
"    cameraNormal = normalize( cameraPos - cameraSpherePos );",
"}",
"        #else",
"if( calcDepth( cameraPos ) <= 0.0 ){",
"    cameraPos = rayDirection * posT + rayOrigin;",
"    interior = true;",
"    return false;",
"}else{",
"    cameraNormal = normalize( cameraPos - cameraSpherePos );",
"}",
"        #endif",
"",
"        cameraNormal = normalize( cameraPos - cameraSpherePos );",
"        cameraNormal *= float(!interior) * 2.0 - 1.0;",
"         return !interior;",
"",
"}",
"",
"void main(void){",
"",
"    bool flag = Impostor( cameraPos, cameraNormal );",
"",
"    #ifdef NEAR_CLIP",
"        if( calcClip( cameraPos ) > 0.0 )",
"            discard;",
"    #endif",
"",
"    // FIXME not compatible with custom clipping plane",
"    //Set the depth based on the new cameraPos.",
"    gl_FragDepthEXT = calcDepth( cameraPos );",
"    if( !flag ){",
"",
"        // clamp to near clipping plane and add a tiny value to",
"        // make spheres with a greater radius occlude smaller ones",
"        #ifdef NEAR_CLIP",
"if( flag2 ){",
"    gl_FragDepthEXT = max( 0.0, calcDepth( vec3( - ( nearClip - 0.5 ) ) ) + ( 0.0000001 / vRadius ) );",
"}else if( gl_FragDepthEXT >= 0.0 ){",
"    gl_FragDepthEXT = 0.0 + ( 0.0000001 / vRadius );",
"}",
"        #else",
"if( gl_FragDepthEXT >= 0.0 ){",
"    gl_FragDepthEXT = 0.0 + ( 0.0000001 / vRadius );",
"}",
"        #endif",
"",
"    }",
"",
"    // bugfix (mac only?)",
"    if (gl_FragDepthEXT < 0.0)",
"        discard;",
"    if (gl_FragDepthEXT > 1.0)",
"        discard;",
"",
"    #ifdef PICKING",
"",
"        gl_FragColor = vec4( vPickingColor, objectId );",
"",
"    #else",
"",
"        vec3 vNormal = cameraNormal;",
"        vec3 vViewPosition = -cameraPos;",
"",
"        vec4 diffuseColor = vec4( diffuse, opacity );",
"        ReflectedLight reflectedLight = ReflectedLight( vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ) );",
"        vec3 totalEmissiveLight = emissive;",
"",
"        #include color_fragment",
"        #include roughnessmap_fragment",
"        #include metalnessmap_fragment",
"",
"        // don't use include normal_fragment",
"        vec3 normal = normalize( vNormal );",
"",
"        #include lights_physical_fragment",
"        //include lights_template",
"        #include lights_fragment_begin",
"        #include lights_fragment_end",
"",
"        vec3 outgoingLight = reflectedLight.directDiffuse + reflectedLight.indirectDiffuse + reflectedLight.directSpecular + reflectedLight.indirectSpecular + totalEmissiveLight;",
"",
"        gl_FragColor = vec4( outgoingLight, diffuseColor.a );",
"        //gl_FragColor = vec4( reflectedLight.directSpecular, diffuseColor.a );",
"",
"        #include premultiplied_alpha_fragment",
"        #include tonemapping_fragment",
"        #include encodings_fragment",
"        //include fog_fragment",
"        #ifdef USE_FOG",
"            #ifdef USE_LOGDEPTHBUF_EXT",
"                float depth = gl_FragDepthEXT / gl_FragCoord.w;",
"            #else",
"                float depth = gl_FragCoord.z / gl_FragCoord.w;",
"            #endif",
"            #ifdef FOG_EXP2",
"                float fogFactor = whiteCompliment( exp2( - fogDensity * fogDensity * depth * depth * LOG2 ) );",
"            #else",
"                float fogFactor = smoothstep( fogNear, fogFar, depth );",
"            #endif",
"            gl_FragColor.rgb = mix( gl_FragColor.rgb, fogColor, fogFactor );",
"        #endif",
"",
"    #endif",
"",
"}"
].join("\n");

$NGL_shaderTextHash['SphereImpostor.vert'] = ["uniform mat4 projectionMatrixInverse;",
"uniform float nearClip;",
"",
"varying float vRadius;",
"varying float vRadiusSq;",
"varying vec3 vPoint;",
"varying vec3 vPointViewPosition;",
"varying float fogDepth;",
"varying float fogNear;",
"varying float fogFar;",
"",
"attribute vec2 mapping;",
"//attribute vec3 position;",
"attribute float radius;",
"",
"#ifdef PICKING",
"    #include unpack_clr",
"    attribute float primitiveId;",
"    varying vec3 vPickingColor;",
"#else",
"    #include color_pars_vertex",
"#endif",
"",
"//include matrix_scale",
"float matrixScale( in mat4 m ){",
"    vec4 r = m[ 0 ];",
"    return sqrt( r[ 0 ] * r[ 0 ] + r[ 1 ] * r[ 1 ] + r[ 2 ] * r[ 2 ] );",
"}",
"",
"const mat4 D = mat4(",
"    1.0, 0.0, 0.0, 0.0,",
"    0.0, 1.0, 0.0, 0.0,",
"    0.0, 0.0, 1.0, 0.0,",
"    0.0, 0.0, 0.0, -1.0",
");",
"",
"mat4 transposeTmp( in mat4 inMatrix ) {",
"    vec4 i0 = inMatrix[0];",
"    vec4 i1 = inMatrix[1];",
"    vec4 i2 = inMatrix[2];",
"    vec4 i3 = inMatrix[3];",
"",
"    mat4 outMatrix = mat4(",
"        vec4(i0.x, i1.x, i2.x, i3.x),",
"        vec4(i0.y, i1.y, i2.y, i3.y),",
"        vec4(i0.z, i1.z, i2.z, i3.z),",
"        vec4(i0.w, i1.w, i2.w, i3.w)",
"    );",
"    return outMatrix;",
"}",
"",
"//------------------------------------------------------------------------------",
"// Compute point size and center using the technique described in:",
"// 'GPU-Based Ray-Casting of Quadratic Surfaces'",
"// by Christian Sigg, Tim Weyrich, Mario Botsch, Markus Gross.",
"//",
"// Code based on",
"/*=========================================================================",
"",
" Program:   Visualization Toolkit",
" Module:    Quadrics_fs.glsl and Quadrics_vs.glsl",
"",
" Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen",
" All rights reserved.",
" See Copyright.txt or http://www.kitware.com/Copyright.htm for details.",
"",
" This software is distributed WITHOUT ANY WARRANTY; without even",
" the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR",
" PURPOSE.  See the above copyright notice for more information.",
"",
" =========================================================================*/",
"",
"// .NAME Quadrics_fs.glsl and Quadrics_vs.glsl",
"// .SECTION Thanks",
"// <verbatim>",
"//",
"//  This file is part of the PointSprites plugin developed and contributed by",
"//",
"//  Copyright (c) CSCS - Swiss National Supercomputing Centre",
"//                EDF - Electricite de France",
"//",
"//  John Biddiscombe, Ugo Varetto (CSCS)",
"//  Stephane Ploix (EDF)",
"//",
"// </verbatim>",
"//",
"// Contributions by Alexander Rose",
"// - ported to WebGL",
"// - adapted to work with quads",
"void ComputePointSizeAndPositionInClipCoordSphere(){",
"",
"    vec2 xbc;",
"    vec2 ybc;",
"",
"    mat4 T = mat4(",
"        radius, 0.0, 0.0, 0.0,",
"        0.0, radius, 0.0, 0.0,",
"        0.0, 0.0, radius, 0.0,",
"        position.x, position.y, position.z, 1.0",
"    );",
"",
"    mat4 R = transposeTmp( projectionMatrix * modelViewMatrix * T );",
"    float A = dot( R[ 3 ], D * R[ 3 ] );",
"    float B = -2.0 * dot( R[ 0 ], D * R[ 3 ] );",
"    float C = dot( R[ 0 ], D * R[ 0 ] );",
"    xbc[ 0 ] = ( -B - sqrt( B * B - 4.0 * A * C ) ) / ( 2.0 * A );",
"    xbc[ 1 ] = ( -B + sqrt( B * B - 4.0 * A * C ) ) / ( 2.0 * A );",
"    float sx = abs( xbc[ 0 ] - xbc[ 1 ] ) * 0.5;",
"",
"    A = dot( R[ 3 ], D * R[ 3 ] );",
"    B = -2.0 * dot( R[ 1 ], D * R[ 3 ] );",
"    C = dot( R[ 1 ], D * R[ 1 ] );",
"    ybc[ 0 ] = ( -B - sqrt( B * B - 4.0 * A * C ) ) / ( 2.0 * A );",
"    ybc[ 1 ] = ( -B + sqrt( B * B - 4.0 * A * C ) ) / ( 2.0 * A );",
"    float sy = abs( ybc[ 0 ] - ybc[ 1 ]  ) * 0.5;",
"",
"    gl_Position.xy = vec2( 0.5 * ( xbc.x + xbc.y ), 0.5 * ( ybc.x + ybc.y ) );",
"    gl_Position.xy -= mapping * vec2( sx, sy );",
"    gl_Position.xy *= gl_Position.w;",
"",
"}",
"",
"void main(void){",
"",
"    #ifdef PICKING",
"        vPickingColor = unpackColor( primitiveId );",
"    #else",
"        #include color_vertex",
"    #endif",
"",
"    vRadius = radius * matrixScale( modelViewMatrix );",
"",
"    vec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );",
"    // avoid clipping, added again in fragment shader",
"    mvPosition.z -= vRadius;",
"",
"    gl_Position = projectionMatrix * vec4( mvPosition.xyz, 1.0 );",
"    ComputePointSizeAndPositionInClipCoordSphere();",
"",
"",
"    vRadiusSq = vRadius * vRadius;",
"    vec4 vPoint4 = projectionMatrixInverse * gl_Position;",
"    vPoint = vPoint4.xyz / vPoint4.w;",
"    vPointViewPosition = -mvPosition.xyz / mvPosition.w;",
"",
"}"
].join("\n");

$NGL_shaderTextHash['CylinderImpostor.frag'] = ["#define STANDARD",
"#define IMPOSTOR",
"",
"// Open-Source PyMOL is Copyright (C) Schrodinger, LLC.",
"//",
"//  All Rights Reserved",
"//",
"//  Permission to use, copy, modify, distribute, and distribute modified",
"//  versions of this software and its built-in documentation for any",
"//  purpose and without fee is hereby granted, provided that the above",
"//  copyright notice appears in all copies and that both the copyright",
"//  notice and this permission notice appear in supporting documentation,",
"//  and that the name of Schrodinger, LLC not be used in advertising or",
"//  publicity pertaining to distribution of the software without specific,",
"//  written prior permission.",
"//",
"//  SCHRODINGER, LLC DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,",
"//  INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS. IN",
"//  NO EVENT SHALL SCHRODINGER, LLC BE LIABLE FOR ANY SPECIAL, INDIRECT OR",
"//  CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS",
"//  OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE",
"//  OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE",
"//  USE OR PERFORMANCE OF THIS SOFTWARE.",
"",
"// Contributions by Alexander Rose",
"// - ported to WebGL",
"// - dual color",
"// - pk color",
"// - custom clipping",
"// - three.js lighting",
"",
"uniform vec3 diffuse;",
"uniform vec3 emissive;",
"uniform float roughness;",
"uniform float metalness;",
"uniform float opacity;",
"uniform float nearClip;",
"uniform mat4 projectionMatrix;",
"uniform float ortho;",
"",
"varying vec3 axis;",
"varying vec4 base_radius;",
"varying vec4 end_b;",
"varying vec3 U;",
"varying vec3 V;",
"varying vec4 w;",
"",
"#ifdef PICKING",
"    uniform float objectId;",
"    varying vec3 vPickingColor;",
"#else",
"    varying vec3 vColor1;",
"    varying vec3 vColor2;",
"    #include common",
"    #include fog_pars_fragment",
"    #include bsdfs",
"    #include lights_pars_begin",
"    #include lights_physical_pars_fragment",
"#endif",
"",
"bool interior = false;",
"",
"float distSq3( vec3 v3a, vec3 v3b ){",
"    return (",
"        ( v3a.x - v3b.x ) * ( v3a.x - v3b.x ) +",
"        ( v3a.y - v3b.y ) * ( v3a.y - v3b.y ) +",
"        ( v3a.z - v3b.z ) * ( v3a.z - v3b.z )",
"    );",
"}",
"",
"// Calculate depth based on the given camera position.",
"float calcDepth( in vec3 cameraPos ){",
"    vec2 clipZW = cameraPos.z * projectionMatrix[2].zw + projectionMatrix[3].zw;",
"    return 0.5 + 0.5 * clipZW.x / clipZW.y;",
"}",
"",
"float calcClip( vec3 cameraPos ){",
"    return dot( vec4( cameraPos, 1.0 ), vec4( 0.0, 0.0, 1.0, nearClip - 0.5 ) );",
"}",
"",
"void main(){",
"",
"    vec3 point = w.xyz / w.w;",
"",
"    // unpacking",
"    vec3 base = base_radius.xyz;",
"    float vRadius = base_radius.w;",
"    vec3 end = end_b.xyz;",
"    float b = end_b.w;",
"",
"    vec3 end_cyl = end;",
"    vec3 surface_point = point;",
"",
"    vec3 ray_target = surface_point;",
"    vec3 ray_origin = vec3(0.0);",
"    vec3 ray_direction = mix(normalize(ray_origin - ray_target), vec3(0.0, 0.0, 1.0), ortho);",
"    mat3 basis = mat3( U, V, axis );",
"",
"    vec3 diff = ray_target - 0.5 * (base + end_cyl);",
"    vec3 P = diff * basis;",
"",
"    // angle (cos) between cylinder cylinder_axis and ray direction",
"    float dz = dot( axis, ray_direction );",
"",
"    float radius2 = vRadius*vRadius;",
"",
"    // calculate distance to the cylinder from ray origin",
"    vec3 D = vec3(dot(U, ray_direction),",
"                dot(V, ray_direction),",
"                dz);",
"    float a0 = P.x*P.x + P.y*P.y - radius2;",
"    float a1 = P.x*D.x + P.y*D.y;",
"    float a2 = D.x*D.x + D.y*D.y;",
"",
"    // calculate a dicriminant of the above quadratic equation",
"    float d = a1*a1 - a0*a2;",
"    if (d < 0.0)",
"        // outside of the cylinder",
"        discard;",
"",
"    float dist = (-a1 + sqrt(d)) / a2;",
"",
"    // point of intersection on cylinder surface",
"    vec3 new_point = ray_target + dist * ray_direction;",
"",
"    vec3 tmp_point = new_point - base;",
"    vec3 _normal = normalize( tmp_point - axis * dot(tmp_point, axis) );",
"",
"    ray_origin = mix( ray_origin, surface_point, ortho );",
"",
"    // test caps",
"    float front_cap_test = dot( tmp_point, axis );",
"    float end_cap_test = dot((new_point - end_cyl), axis);",
"",
"    // to calculate caps, simply check the angle between",
"    // the point of intersection - cylinder end vector",
"    // and a cap plane normal (which is the cylinder cylinder_axis)",
"    // if the angle < 0, the point is outside of cylinder",
"    // test front cap",
"",
"    #ifndef CAP",
"        vec3 new_point2 = ray_target + ( (-a1 - sqrt(d)) / a2 ) * ray_direction;",
"        vec3 tmp_point2 = new_point2 - base;",
"    #endif",
"",
"    // flat",
"    if (front_cap_test < 0.0)",
"    {",
"        // ray-plane intersection",
"        float dNV = dot(-axis, ray_direction);",
"        if (dNV < 0.0)",
"            discard;",
"        float near = dot(-axis, (base)) / dNV;",
"        vec3 front_point = ray_direction * near + ray_origin;",
"        // within the cap radius?",
"        if (dot(front_point - base, front_point-base) > radius2)",
"            discard;",
"",
"        #ifdef CAP",
"            new_point = front_point;",
"            _normal = axis;",
"        #else",
"            new_point = ray_target + ( (-a1 - sqrt(d)) / a2 ) * ray_direction;",
"            dNV = dot(-axis, ray_direction);",
"            near = dot(axis, end_cyl) / dNV;",
"            new_point2 = ray_direction * near + ray_origin;",
"            if (dot(new_point2 - end_cyl, new_point2-base) < radius2)",
"                discard;",
"            interior = true;",
"        #endif",
"    }",
"",
"    // test end cap",
"",
"",
"    // flat",
"    if( end_cap_test > 0.0 )",
"    {",
"        // ray-plane intersection",
"        float dNV = dot(axis, ray_direction);",
"        if (dNV < 0.0)",
"            discard;",
"        float near = dot(axis, end_cyl) / dNV;",
"        vec3 end_point = ray_direction * near + ray_origin;",
"        // within the cap radius?",
"        if( dot(end_point - end_cyl, end_point-base) > radius2 )",
"            discard;",
"",
"        #ifdef CAP",
"            new_point = end_point;",
"            _normal = axis;",
"        #else",
"            new_point = ray_target + ( (-a1 - sqrt(d)) / a2 ) * ray_direction;",
"            dNV = dot(-axis, ray_direction);",
"            near = dot(-axis, (base)) / dNV;",
"            new_point2 = ray_direction * near + ray_origin;",
"            if (dot(new_point2 - base, new_point2-base) < radius2)",
"                discard;",
"            interior = true;",
"        #endif",
"    }",
"",
"    gl_FragDepthEXT = calcDepth( new_point );",
"",
"    #ifdef NEAR_CLIP",
"        if( calcClip( new_point ) > 0.0 ){",
"            dist = (-a1 - sqrt(d)) / a2;",
"            new_point = ray_target + dist * ray_direction;",
"            if( calcClip( new_point ) > 0.0 )",
"                discard;",
"            interior = true;",
"            gl_FragDepthEXT = calcDepth( new_point );",
"            if( gl_FragDepthEXT >= 0.0 ){",
"                gl_FragDepthEXT = max( 0.0, calcDepth( vec3( - ( nearClip - 0.5 ) ) ) + ( 0.0000001 / vRadius ) );",
"            }",
"        }else if( gl_FragDepthEXT <= 0.0 ){",
"            dist = (-a1 - sqrt(d)) / a2;",
"            new_point = ray_target + dist * ray_direction;",
"            interior = true;",
"            gl_FragDepthEXT = calcDepth( new_point );",
"            if( gl_FragDepthEXT >= 0.0 ){",
"                gl_FragDepthEXT = 0.0 + ( 0.0000001 / vRadius );",
"            }",
"        }",
"    #else",
"        if( gl_FragDepthEXT <= 0.0 ){",
"            dist = (-a1 - sqrt(d)) / a2;",
"            new_point = ray_target + dist * ray_direction;",
"            interior = true;",
"            gl_FragDepthEXT = calcDepth( new_point );",
"            if( gl_FragDepthEXT >= 0.0 ){",
"                gl_FragDepthEXT = 0.0 + ( 0.0000001 / vRadius );",
"            }",
"        }",
"    #endif",
"",
"    // this is a workaround necessary for Mac",
"    // otherwise the modified fragment won't clip properly",
"    if (gl_FragDepthEXT < 0.0)",
"        discard;",
"    if (gl_FragDepthEXT > 1.0)",
"        discard;",
"",
"    #ifdef PICKING",
"",
"        gl_FragColor = vec4( vPickingColor, objectId );",
"",
"    #else",
"",
"        vec3 vViewPosition = -new_point;",
"        vec3 vNormal = _normal;",
"        vec3 vColor;",
"",
"        if( distSq3( new_point, end_cyl ) < distSq3( new_point, base ) ){",
"            if( b < 0.0 ){",
"                vColor = vColor1;",
"            }else{",
"                vColor = vColor2;",
"            }",
"        }else{",
"            if( b > 0.0 ){",
"                vColor = vColor1;",
"            }else{",
"                vColor = vColor2;",
"            }",
"        }",
"",
"        vec4 diffuseColor = vec4( diffuse, opacity );",
"        ReflectedLight reflectedLight = ReflectedLight( vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ) );",
"        vec3 totalEmissiveLight = emissive;",
"",
"        #include color_fragment",
"     //ifdef USE_COLOR",
"     //diffuseColor.r *= vColor[0];",
"     //diffuseColor.g *= vColor[1];",
"     //diffuseColor.b *= vColor[2];",
"     //endif",
"        #include roughnessmap_fragment",
"        #include metalnessmap_fragment",
"",
"        // don't use include normal_fragment",
"        vec3 normal = normalize( vNormal );",
"",
"        #include lights_physical_fragment",
"        //include lights_template",
"        #include lights_fragment_begin",
"        #include lights_fragment_end",
"",
"        vec3 outgoingLight = reflectedLight.directDiffuse + reflectedLight.indirectDiffuse + reflectedLight.directSpecular + reflectedLight.indirectSpecular + totalEmissiveLight;",
"",
"        gl_FragColor = vec4( outgoingLight, diffuseColor.a );",
"        //gl_FragColor = vec4( reflectedLight.directSpecular, diffuseColor.a );",
"",
"        #include premultiplied_alpha_fragment",
"        #include tonemapping_fragment",
"        #include encodings_fragment",
"        //include fog_fragment",
"        #ifdef USE_FOG",
"            #ifdef USE_LOGDEPTHBUF_EXT",
"                float depth = gl_FragDepthEXT / gl_FragCoord.w;",
"            #else",
"                float depth = gl_FragCoord.z / gl_FragCoord.w;",
"            #endif",
"            #ifdef FOG_EXP2",
"                float fogFactor = whiteCompliment( exp2( - fogDensity * fogDensity * depth * depth * LOG2 ) );",
"            #else",
"                float fogFactor = smoothstep( fogNear, fogFar, depth );",
"            #endif",
"            gl_FragColor.rgb = mix( gl_FragColor.rgb, fogColor, fogFactor );",
"        #endif",
"",
"    #endif",
"",
"}"
].join("\n");

$NGL_shaderTextHash['CylinderImpostor.vert'] = ["// Open-Source PyMOL is Copyright (C) Schrodinger, LLC.",
"//",
"//  All Rights Reserved",
"//",
"//  Permission to use, copy, modify, distribute, and distribute modified",
"//  versions of this software and its built-in documentation for any",
"//  purpose and without fee is hereby granted, provided that the above",
"//  copyright notice appears in all copies and that both the copyright",
"//  notice and this permission notice appear in supporting documentation,",
"//  and that the name of Schrodinger, LLC not be used in advertising or",
"//  publicity pertaining to distribution of the software without specific,",
"//  written prior permission.",
"//",
"//  SCHRODINGER, LLC DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,",
"//  INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS. IN",
"//  NO EVENT SHALL SCHRODINGER, LLC BE LIABLE FOR ANY SPECIAL, INDIRECT OR",
"//  CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS",
"//  OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE",
"//  OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE",
"//  USE OR PERFORMANCE OF THIS SOFTWARE.",
"",
"// Contributions by Alexander Rose",
"// - ported to WebGL",
"// - dual color",
"// - pk color",
"// - shift",
"",
"attribute vec3 mapping;",
"attribute vec3 position1;",
"attribute vec3 position2;",
"attribute float radius;",
"",
"varying vec3 axis;",
"varying vec4 base_radius;",
"varying vec4 end_b;",
"varying vec3 U;",
"varying vec3 V;",
"varying vec4 w;",
"varying float fogDepth;",
"varying float fogNear;",
"varying float fogFar;",
"",
"#ifdef PICKING",
"    #include unpack_clr",
"    attribute float primitiveId;",
"    varying vec3 vPickingColor;",
"#else",
"    //attribute vec3 color;",
"    attribute vec3 color2;",
"    varying vec3 vColor1;",
"    varying vec3 vColor2;",
"#endif",
"",
"uniform mat4 modelViewMatrixInverse;",
"uniform float ortho;",
"",
"//include matrix_scale",
"float matrixScale( in mat4 m ){",
"    vec4 r = m[ 0 ];",
"    return sqrt( r[ 0 ] * r[ 0 ] + r[ 1 ] * r[ 1 ] + r[ 2 ] * r[ 2 ] );",
"}",
"",
"void main(){",
"",
"    #ifdef PICKING",
"        vPickingColor = unpackColor( primitiveId );",
"    #else",
"        vColor1 = color;",
"        vColor2 = color2;",
"    #endif",
"",
"    // vRadius = radius;",
"    base_radius.w = radius * matrixScale( modelViewMatrix );",
"",
"    //vec3 center = position;",
"    vec3 center = ( position2 + position1 ) / 2.0;",
"    vec3 dir = normalize( position2 - position1 );",
"    float ext = length( position2 - position1 ) / 2.0;",
"",
"    // using cameraPosition fails on some machines, not sure why",
"    // vec3 cam_dir = normalize( cameraPosition - mix( center, vec3( 0.0 ), ortho ) );",
"    vec3 cam_dir;",
"    if( ortho == 0.0 ){",
"        cam_dir = ( modelViewMatrixInverse * vec4( 0, 0, 0, 1 ) ).xyz - center;",
"    }else{",
"        cam_dir = ( modelViewMatrixInverse * vec4( 0, 0, 1, 0 ) ).xyz;",
"    }",
"    cam_dir = normalize( cam_dir );",
"",
"    vec3 ldir;",
"",
"    float b = dot( cam_dir, dir );",
"    end_b.w = b;",
"    // direction vector looks away, so flip",
"    if( b < 0.0 )",
"        ldir = -ext * dir;",
"    // direction vector already looks in my direction",
"    else",
"        ldir = ext * dir;",
"",
"    vec3 left = normalize( cross( cam_dir, ldir ) );",
"    left = radius * left;",
"    vec3 up = radius * normalize( cross( left, ldir ) );",
"",
"    // transform to modelview coordinates",
"    axis = normalize( normalMatrix * ldir );",
"    U = normalize( normalMatrix * up );",
"    V = normalize( normalMatrix * left );",
"",
"    vec4 base4 = modelViewMatrix * vec4( center - ldir, 1.0 );",
"    base_radius.xyz = base4.xyz / base4.w;",
"",
"    vec4 top_position = modelViewMatrix * vec4( center + ldir, 1.0 );",
"    vec4 end4 = top_position;",
"    end_b.xyz = end4.xyz / end4.w;",
"",
"    w = modelViewMatrix * vec4(",
"        center + mapping.x*ldir + mapping.y*left + mapping.z*up, 1.0",
"    );",
"",
"    gl_Position = projectionMatrix * w;",
"",
"    // avoid clipping (1.0 seems to induce flickering with some drivers)",
"    gl_Position.z = 0.99;",
"",
"}"
].join("\n");

$NGL_shaderTextHash['SphereInstancing.frag'] = $NGL_shaderTextHash['SphereImpostor.frag'];

$NGL_shaderTextHash['SphereInstancing.vert'] = ["uniform mat4 projectionMatrixInverse;",
"uniform float nearClip;",
"",
"varying float vRadius;",
"varying float vRadiusSq;",
"varying vec3 vPoint;",
"varying vec3 vPointViewPosition;",
"varying float fogDepth;",
"varying float fogNear;",
"varying float fogFar;",
"",
"attribute vec2 mapping;",
"//attribute vec3 position;",
"attribute float radius;",
"attribute vec4 matrix1;",
"attribute vec4 matrix2;",
"attribute vec4 matrix3;",
"attribute vec4 matrix4;",
"",
"#ifdef PICKING",
"    #include unpack_clr",
"    attribute float primitiveId;",
"    varying vec3 vPickingColor;",
"#else",
"    #include color_pars_vertex",
"#endif",
"",
"//include matrix_scale",
"float matrixScale( in mat4 m ){",
"    vec4 r = m[ 0 ];",
"    return sqrt( r[ 0 ] * r[ 0 ] + r[ 1 ] * r[ 1 ] + r[ 2 ] * r[ 2 ] );",
"}",
"",
"const mat4 D = mat4(",
"    1.0, 0.0, 0.0, 0.0,",
"    0.0, 1.0, 0.0, 0.0,",
"    0.0, 0.0, 1.0, 0.0,",
"    0.0, 0.0, 0.0, -1.0",
");",
"",
"mat4 transposeTmp( in mat4 inMatrix ) {",
"    vec4 i0 = inMatrix[0];",
"    vec4 i1 = inMatrix[1];",
"    vec4 i2 = inMatrix[2];",
"    vec4 i3 = inMatrix[3];",
"",
"    mat4 outMatrix = mat4(",
"        vec4(i0.x, i1.x, i2.x, i3.x),",
"        vec4(i0.y, i1.y, i2.y, i3.y),",
"        vec4(i0.z, i1.z, i2.z, i3.z),",
"        vec4(i0.w, i1.w, i2.w, i3.w)",
"    );",
"    return outMatrix;",
"}",
"",
"//------------------------------------------------------------------------------",
"// Compute point size and center using the technique described in:",
"// 'GPU-Based Ray-Casting of Quadratic Surfaces'",
"// by Christian Sigg, Tim Weyrich, Mario Botsch, Markus Gross.",
"//",
"// Code based on",
"/*=========================================================================",
"",
" Program:   Visualization Toolkit",
" Module:    Quadrics_fs.glsl and Quadrics_vs.glsl",
"",
" Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen",
" All rights reserved.",
" See Copyright.txt or http://www.kitware.com/Copyright.htm for details.",
"",
" This software is distributed WITHOUT ANY WARRANTY; without even",
" the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR",
" PURPOSE.  See the above copyright notice for more information.",
"",
" =========================================================================*/",
"",
"// .NAME Quadrics_fs.glsl and Quadrics_vs.glsl",
"// .SECTION Thanks",
"// <verbatim>",
"//",
"//  This file is part of the PointSprites plugin developed and contributed by",
"//",
"//  Copyright (c) CSCS - Swiss National Supercomputing Centre",
"//                EDF - Electricite de France",
"//",
"//  John Biddiscombe, Ugo Varetto (CSCS)",
"//  Stephane Ploix (EDF)",
"//",
"// </verbatim>",
"//",
"// Contributions by Alexander Rose",
"// - ported to WebGL",
"// - adapted to work with quads",
"void ComputePointSizeAndPositionInClipCoordSphere(vec4 updatePosition){",
"",
"    vec2 xbc;",
"    vec2 ybc;",
"",
"    mat4 T = mat4(",
"        radius, 0.0, 0.0, 0.0,",
"        0.0, radius, 0.0, 0.0,",
"        0.0, 0.0, radius, 0.0,",
"        updatePosition.x, updatePosition.y, updatePosition.z, 1.0",
"    );",
"",
"    mat4 R = transposeTmp( projectionMatrix * modelViewMatrix * T );",
"    float A = dot( R[ 3 ], D * R[ 3 ] );",
"    float B = -2.0 * dot( R[ 0 ], D * R[ 3 ] );",
"    float C = dot( R[ 0 ], D * R[ 0 ] );",
"    xbc[ 0 ] = ( -B - sqrt( B * B - 4.0 * A * C ) ) / ( 2.0 * A );",
"    xbc[ 1 ] = ( -B + sqrt( B * B - 4.0 * A * C ) ) / ( 2.0 * A );",
"    float sx = abs( xbc[ 0 ] - xbc[ 1 ] ) * 0.5;",
"",
"    A = dot( R[ 3 ], D * R[ 3 ] );",
"    B = -2.0 * dot( R[ 1 ], D * R[ 3 ] );",
"    C = dot( R[ 1 ], D * R[ 1 ] );",
"    ybc[ 0 ] = ( -B - sqrt( B * B - 4.0 * A * C ) ) / ( 2.0 * A );",
"    ybc[ 1 ] = ( -B + sqrt( B * B - 4.0 * A * C ) ) / ( 2.0 * A );",
"    float sy = abs( ybc[ 0 ] - ybc[ 1 ]  ) * 0.5;",
"",
"    gl_Position.xy = vec2( 0.5 * ( xbc.x + xbc.y ), 0.5 * ( ybc.x + ybc.y ) );",
"    gl_Position.xy -= mapping * vec2( sx, sy );",
"    gl_Position.xy *= gl_Position.w;",
"",
"}",
"",
"  mat4 computeMat(vec4 v1, vec4 v2, vec4 v3, vec4 v4) {",
"    return mat4(",
"      v1.x, v1.y, v1.z, v1.w,",
"      v2.x, v2.y, v2.z, v2.w,",
"      v3.x, v3.y, v3.z, v3.w,",
"      v4.x, v4.y, v4.z, v4.w",
"    );",
"  }",
"",
"void main(void){",
"",
"    #ifdef PICKING",
"        vPickingColor = unpackColor( primitiveId );",
"    #else",
"        #include color_vertex",
"    #endif",
"",
"    vRadius = radius * matrixScale( modelViewMatrix );",
"",
"    mat4 matrix = computeMat(matrix1, matrix2, matrix3, matrix4);",
"    vec4 updatePosition = matrix * vec4(position, 1.0);",
"",
"//    vec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );",
"    vec4 mvPosition = modelViewMatrix * vec4( updatePosition.xyz, 1.0 );",
"    // avoid clipping, added again in fragment shader",
"    mvPosition.z -= vRadius;",
"",
"//    gl_Position = projectionMatrix * vec4( mvPosition.xyz, 1.0 );",
"    gl_Position = projectionMatrix * vec4( mvPosition.xyz, 1.0 );",
"    ComputePointSizeAndPositionInClipCoordSphere(updatePosition);",
"",
"",
"    vRadiusSq = vRadius * vRadius;",
"    vec4 vPoint4 = projectionMatrixInverse * gl_Position;",
"    vPoint = vPoint4.xyz / vPoint4.w;",
"    vPointViewPosition = -mvPosition.xyz / mvPosition.w;",
"",
"}"
].join("\n");

$NGL_shaderTextHash['CylinderInstancing.frag'] = $NGL_shaderTextHash['CylinderImpostor.frag'];
$NGL_shaderTextHash['CylinderInstancing.vert'] = ["// Open-Source PyMOL is Copyright (C) Schrodinger, LLC.",
"//",
"//  All Rights Reserved",
"//",
"//  Permission to use, copy, modify, distribute, and distribute modified",
"//  versions of this software and its built-in documentation for any",
"//  purpose and without fee is hereby granted, provided that the above",
"//  copyright notice appears in all copies and that both the copyright",
"//  notice and this permission notice appear in supporting documentation,",
"//  and that the name of Schrodinger, LLC not be used in advertising or",
"//  publicity pertaining to distribution of the software without specific,",
"//  written prior permission.",
"//",
"//  SCHRODINGER, LLC DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,",
"//  INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS. IN",
"//  NO EVENT SHALL SCHRODINGER, LLC BE LIABLE FOR ANY SPECIAL, INDIRECT OR",
"//  CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS",
"//  OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE",
"//  OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE",
"//  USE OR PERFORMANCE OF THIS SOFTWARE.",
"",
"// Contributions by Alexander Rose",
"// - ported to WebGL",
"// - dual color",
"// - pk color",
"// - shift",
"",
"attribute vec3 mapping;",
"attribute vec3 position1;",
"attribute vec3 position2;",
"attribute float radius;",
"attribute vec4 matrix1;",
"attribute vec4 matrix2;",
"attribute vec4 matrix3;",
"attribute vec4 matrix4;",
"",
"varying vec3 axis;",
"varying vec4 base_radius;",
"varying vec4 end_b;",
"varying vec3 U;",
"varying vec3 V;",
"varying vec4 w;",
"varying float fogDepth;",
"varying float fogNear;",
"varying float fogFar;",
"",
"#ifdef PICKING",
"    #include unpack_clr",
"    attribute float primitiveId;",
"    varying vec3 vPickingColor;",
"#else",
"    //attribute vec3 color;",
"    attribute vec3 color2;",
"    varying vec3 vColor1;",
"    varying vec3 vColor2;",
"#endif",
"",
"uniform mat4 modelViewMatrixInverse;",
"uniform float ortho;",
"",
"//include matrix_scale",
"float matrixScale( in mat4 m ){",
"    vec4 r = m[ 0 ];",
"    return sqrt( r[ 0 ] * r[ 0 ] + r[ 1 ] * r[ 1 ] + r[ 2 ] * r[ 2 ] );",
"}",
"",
"  mat4 computeMat(vec4 v1, vec4 v2, vec4 v3, vec4 v4) {",
"    return mat4(",
"      v1.x, v1.y, v1.z, v1.w,",
"      v2.x, v2.y, v2.z, v2.w,",
"      v3.x, v3.y, v3.z, v3.w,",
"      v4.x, v4.y, v4.z, v4.w",
"    );",
"  }",
"",
"void main(){",
"",
"    #ifdef PICKING",
"        vPickingColor = unpackColor( primitiveId );",
"    #else",
"        vColor1 = color;",
"        vColor2 = color2;",
"    #endif",
"",
"    // vRadius = radius;",
"    base_radius.w = radius * matrixScale( modelViewMatrix );",
"",
"    //vec3 center = ( position2 + position1 ) / 2.0;",
"",
"    mat4 matrix = computeMat(matrix1, matrix2, matrix3, matrix4);",
"    vec4 updatePosition1 = matrix * vec4(position1, 1.0);",
"    vec4 updatePosition2 = matrix * vec4(position2, 1.0);",
"    vec3 center = ( updatePosition2.xyz + updatePosition1.xyz ) / 2.0;",
"",
"    //vec3 dir = normalize( position2 - position1 );",
"    vec3 dir = normalize( updatePosition2.xyz - updatePosition1.xyz );",
"    float ext = length( position2 - position1 ) / 2.0;",
"",
"    // using cameraPosition fails on some machines, not sure why",
"    // vec3 cam_dir = normalize( cameraPosition - mix( center, vec3( 0.0 ), ortho ) );",
"    vec3 cam_dir;",
"    if( ortho == 0.0 ){",
"        cam_dir = ( modelViewMatrixInverse * vec4( 0, 0, 0, 1 ) ).xyz - center;",
"    }else{",
"        cam_dir = ( modelViewMatrixInverse * vec4( 0, 0, 1, 0 ) ).xyz;",
"    }",
"    cam_dir = normalize( cam_dir );",
"",
"    vec3 ldir;",
"",
"    float b = dot( cam_dir, dir );",
"    end_b.w = b;",
"    // direction vector looks away, so flip",
"    if( b < 0.0 )",
"        ldir = -ext * dir;",
"    // direction vector already looks in my direction",
"    else",
"        ldir = ext * dir;",
"",
"    vec3 left = normalize( cross( cam_dir, ldir ) );",
"    left = radius * left;",
"    vec3 up = radius * normalize( cross( left, ldir ) );",
"",
"    // transform to modelview coordinates",
"    axis = normalize( normalMatrix * ldir );",
"    U = normalize( normalMatrix * up );",
"    V = normalize( normalMatrix * left );",
"",
"    vec4 base4 = modelViewMatrix * vec4( center - ldir, 1.0 );",
"    base_radius.xyz = base4.xyz / base4.w;",
"",
"    vec4 top_position = modelViewMatrix * vec4( center + ldir, 1.0 );",
"    vec4 end4 = top_position;",
"    end_b.xyz = end4.xyz / end4.w;",
"",
"    w = modelViewMatrix * vec4(",
"        center + mapping.x*ldir + mapping.y*left + mapping.z*up, 1.0",
"    );",
"",
"    gl_Position = projectionMatrix * w;",
"",
"    // avoid clipping (1.0 seems to induce flickering with some drivers)",
"    gl_Position.z = 0.99;",
"",
"}"
].join("\n");

$NGL_shaderTextHash['Instancing.frag'] = ["#define STANDARD",
"uniform vec3 diffuse;",
"uniform vec3 emissive;",
"uniform float roughness;",
"uniform float metalness;",
"uniform float opacity;",
"uniform float nearClip;",
"uniform float clipRadius;",
"uniform mat4 projectionMatrix;",
"uniform float ortho;",
"varying float bCylinder;",
"",
"#if defined( NEAR_CLIP ) || defined( RADIUS_CLIP ) || ( !defined( PICKING ) && !defined( NOLIGHT ) )",
"    varying vec3 vViewPosition;",
"#endif",
"",
"#if defined( RADIUS_CLIP )",
"    varying vec3 vClipCenter;",
"#endif",
"",
"#if defined( PICKING )",
"    uniform float objectId;",
"    varying vec3 vPickingColor;",
"#elif defined( NOLIGHT )",
"    varying vec3 vColor;",
"#else",
"    #ifndef FLAT_SHADED",
"        varying vec3 vNormal;",
"    #endif",
"    #include common",
"    #include color_pars_fragment",
"    #include fog_pars_fragment",
"    #include bsdfs",
"    #include lights_pars_begin",
"    #include lights_physical_pars_fragment",
"#endif",
"",
"void main(){",
"    #include nearclip_fragment",
"    #include radiusclip_fragment",
"",
"    #if defined( PICKING )",
"",
"        gl_FragColor = vec4( vPickingColor, objectId );",
"",
"    #elif defined( NOLIGHT )",
"",
"        gl_FragColor = vec4( vColor, opacity );",
"",
"    #else",
"",
"        vec4 diffuseColor = vec4( diffuse, opacity );",
"        ReflectedLight reflectedLight = ReflectedLight( vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ) );",
"        vec3 totalEmissiveLight = emissive;",
"",
"        #include color_fragment",
"        #include roughnessmap_fragment",
"        #include metalnessmap_fragment",
"        #include normal_flip",
"        #include normal_fragment_begin",
"",
"        //include dull_interior_fragment",
"",
"        #include lights_physical_fragment",
"        //include lights_template",
"        #include lights_fragment_begin",
"        #include lights_fragment_end",
"",
"        vec3 outgoingLight = reflectedLight.directDiffuse + reflectedLight.indirectDiffuse + reflectedLight.directSpecular + reflectedLight.indirectSpecular + totalEmissiveLight;",
"",
"        #include interior_fragment",
"",
"        gl_FragColor = vec4( outgoingLight, diffuseColor.a );",
"",
"        #include premultiplied_alpha_fragment",
"        #include tonemapping_fragment",
"        #include encodings_fragment",
"        #include fog_fragment",
"",
"        #include opaque_back_fragment",
"",
"    #endif",
"",
"}"
].join("\n");

$NGL_shaderTextHash['Instancing.vert'] = ["#define STANDARD",
"",
"uniform mat4 projectionMatrixInverse;",
"uniform float nearClip;",
"uniform vec3 clipCenter;",
"attribute vec4 matrix1;",
"attribute vec4 matrix2;",
"attribute vec4 matrix3;",
"attribute vec4 matrix4;",
"attribute float cylinder;",
"varying float bCylinder;",
"",
"#if defined( NEAR_CLIP ) || defined( RADIUS_CLIP ) || ( !defined( PICKING ) && !defined( NOLIGHT ) )",
"    varying vec3 vViewPosition;",
"#endif",
"",
"#if defined( RADIUS_CLIP )",
"    varying vec3 vClipCenter;",
"#endif",
"",
"#if defined( PICKING )",
"    #include unpack_color",
"    attribute float primitiveId;",
"    varying vec3 vPickingColor;",
"#elif defined( NOLIGHT )",
"    varying vec3 vColor;",
"#else",
"    #include color_pars_vertex",
"    #ifndef FLAT_SHADED",
"        varying vec3 vNormal;",
"    #endif",
"#endif",
"",
"#include common",
"",
"  mat4 computeMat(vec4 v1, vec4 v2, vec4 v3, vec4 v4) {",
"    return mat4(",
"      v1.x, v1.y, v1.z, v1.w,",
"      v2.x, v2.y, v2.z, v2.w,",
"      v3.x, v3.y, v3.z, v3.w,",
"      v4.x, v4.y, v4.z, v4.w",
"    );",
"  }",
"",
"void main(){",
"    bCylinder = cylinder;",
"",
"    mat4 matrix = computeMat(matrix1, matrix2, matrix3, matrix4);",
"    vec4 updatePosition = matrix * vec4(position, 1.0);",
"",
"    #if defined( PICKING )",
"        vPickingColor = unpackColor( primitiveId );",
"    #elif defined( NOLIGHT )",
"        vColor = color;",
"    #else",
"        #include color_vertex",
"        //include beginnormal_vertex",
"        //vec3 objectNormal = vec3( normal );",
"        vec3 objectNormal = vec3(matrix * vec4(normal,0.0));",
"        #include defaultnormal_vertex",
"        // Normal computed with derivatives when FLAT_SHADED",
"        #ifndef FLAT_SHADED",
"            vNormal = normalize( transformedNormal );",
"        #endif",
"    #endif",
"",
"    //include begin_vertex",
"    vec3 transformed = updatePosition.xyz;",
"    //include project_vertex",
"    vec4 mvPosition = modelViewMatrix * vec4( transformed, 1.0 );",
"    gl_Position = projectionMatrix * mvPosition;",
"",
"    #if defined( NEAR_CLIP ) || defined( RADIUS_CLIP ) || ( !defined( PICKING ) && !defined( NOLIGHT ) )",
"        vViewPosition = -mvPosition.xyz;",
"    #endif",
"",
"    #if defined( RADIUS_CLIP )",
"        vClipCenter = -( modelViewMatrix * vec4( clipCenter, 1.0 ) ).xyz;",
"    #endif",
"",
"    #include nearclip_vertex",
"",
"}"
].join("\n");

/* Projector.js from http://threejs.org/
 * @author mrdoob / http://mrdoob.com/
 * @author supereggbert / http://www.paulbrunt.co.uk/
 * @author julianwa / https://github.com/julianwa
 */



THREE.RenderableObject = function () {
    "use strict";

    this.id = 0;

    this.object = null;
    this.z = 0;

};

//

THREE.RenderableFace = function () {
    "use strict";

    this.id = 0;

    this.v1 = new THREE.RenderableVertex();
    this.v2 = new THREE.RenderableVertex();
    this.v3 = new THREE.RenderableVertex();

    this.normalModel = new THREE.Vector3();

    this.vertexNormalsModel = [ new THREE.Vector3(), new THREE.Vector3(), new THREE.Vector3() ];
    this.vertexNormalsLength = 0;

    this.color = new THREE.Color();
    this.material = null;
    this.uvs = [ new THREE.Vector2(), new THREE.Vector2(), new THREE.Vector2() ];

    this.z = 0;

};

//

THREE.RenderableVertex = function () {
    "use strict";

    this.position = new THREE.Vector3();
    this.positionWorld = new THREE.Vector3();
    this.positionScreen = new THREE.Vector4();

    this.visible = true;

};

THREE.RenderableVertex.prototype.copy = function ( vertex ) {
    "use strict";

    this.positionWorld.copy( vertex.positionWorld );
    this.positionScreen.copy( vertex.positionScreen );

};

//

THREE.RenderableLine = function () {
    "use strict";

    this.id = 0;

    this.v1 = new THREE.RenderableVertex();
    this.v2 = new THREE.RenderableVertex();

    this.vertexColors = [ new THREE.Color(), new THREE.Color() ];
    this.material = null;

    this.z = 0;

};

//

THREE.RenderableSprite = function () {
    "use strict";

    this.id = 0;

    this.object = null;

    this.x = 0;
    this.y = 0;
    this.z = 0;

    this.rotation = 0;
    this.scale = new THREE.Vector2();

    this.material = null;

};

//

THREE.Projector = function () {
    "use strict";

    var _object, _objectCount, _objectPool = [], _objectPoolLength = 0,
    _vertex, _vertexCount, _vertexPool = [], _vertexPoolLength = 0,
    _face, _faceCount, _facePool = [], _facePoolLength = 0,
    _line, _lineCount, _linePool = [], _linePoolLength = 0,
    _sprite, _spriteCount, _spritePool = [], _spritePoolLength = 0,

    _renderData = { objects: [], lights: [], elements: [] },

    _vA = new THREE.Vector3(),
    _vB = new THREE.Vector3(),
    _vC = new THREE.Vector3(),

    _vector3 = new THREE.Vector3(),
    _vector4 = new THREE.Vector4(),

    _clipBox = new THREE.Box3( new THREE.Vector3( - 1, - 1, - 1 ), new THREE.Vector3( 1, 1, 1 ) ),
    _boundingBox = new THREE.Box3(),
    _pnts3 = new Array( 3 ),
    _pnts4 = new Array( 4 ),

    _viewMatrix = new THREE.Matrix4(),
    _viewProjectionMatrix = new THREE.Matrix4(),

    _modelMatrix,
    _modelViewProjectionMatrix = new THREE.Matrix4(),

    _normalMatrix = new THREE.Matrix3(),

    _frustum = new THREE.Frustum(),

    _clippedVertex1PositionScreen = new THREE.Vector4(),
    _clippedVertex2PositionScreen = new THREE.Vector4();

    //

    this.projectVector = function ( vector, camera ) {

        console.warn( 'THREE.Projector: .projectVector() is now vector.project().' );
        vector.project( camera );

    };

    this.unprojectVector = function ( vector, camera ) {

        console.warn( 'THREE.Projector: .unprojectVector() is now vector.unproject().' );
        vector.unproject( camera );

    };

    this.pkRay = function ( vector, camera ) {

        console.error( 'THREE.Projector: .pkRay() is now raycaster.setFromCamera().' );

    };

    //

    var RenderList = function () {

        var normals = [];
        var uvs = [];

        var object = null;
        var material = null;

        var normalMatrix = new THREE.Matrix3();

        var setObject = function ( value ) {

            object = value;
            material = object.material;

            normalMatrix.getNormalMatrix( object.matrixWorld );

            normals.length = 0;
            uvs.length = 0;

        };

        var projectVertex = function ( vertex ) {

            var position = vertex.position;
            var positionWorld = vertex.positionWorld;
            var positionScreen = vertex.positionScreen;

            positionWorld.copy( position ).applyMatrix4( _modelMatrix );
            positionScreen.copy( positionWorld ).applyMatrix4( _viewProjectionMatrix );

            var invW = 1 / positionScreen.w;

            positionScreen.x *= invW;
            positionScreen.y *= invW;
            positionScreen.z *= invW;

            vertex.visible = positionScreen.x >= - 1 && positionScreen.x <= 1 &&
                     positionScreen.y >= - 1 && positionScreen.y <= 1 &&
                     positionScreen.z >= - 1 && positionScreen.z <= 1;

        };

        var pushVertex = function ( x, y, z ) {

            _vertex = getNextVertexInPool();
            _vertex.position.set( x, y, z );

            projectVertex( _vertex );

        };

        var pushNormal = function ( x, y, z ) {

            normals.push( x, y, z );

        };

        var pushUv = function ( x, y ) {

            uvs.push( x, y );

        };

        var checkTriangleVisibility = function ( v1, v2, v3 ) {

            if ( v1.visible === true || v2.visible === true || v3.visible === true ) return true;

            _pnts3[ 0 ] = v1.positionScreen;
            _pnts3[ 1 ] = v2.positionScreen;
            _pnts3[ 2 ] = v3.positionScreen;

            return _clipBox.isIntersectionBox( _boundingBox.setFromPoints( _pnts3 ) );

        };

        var checkBackfaceCulling = function ( v1, v2, v3 ) {

            return ( ( v3.positionScreen.x - v1.positionScreen.x ) *
                    ( v2.positionScreen.y - v1.positionScreen.y ) -
                    ( v3.positionScreen.y - v1.positionScreen.y ) *
                    ( v2.positionScreen.x - v1.positionScreen.x ) ) < 0;

        };

        var pushLine = function ( a, b ) {

            var v1 = _vertexPool[ a ];
            var v2 = _vertexPool[ b ];

            _line = getNextLineInPool();

            _line.id = object.id;
            _line.v1.copy( v1 );
            _line.v2.copy( v2 );
            _line.z = ( v1.positionScreen.z + v2.positionScreen.z ) / 2;

            _line.material = object.material;

            _renderData.elements.push( _line );

        };

        var pushTriangle = function ( a, b, c ) {

            var v1 = _vertexPool[ a ];
            var v2 = _vertexPool[ b ];
            var v3 = _vertexPool[ c ];

            if ( checkTriangleVisibility( v1, v2, v3 ) === false ) return;

            if ( material.side === THREE.DoubleSide || checkBackfaceCulling( v1, v2, v3 ) === true ) {

                _face = getNextFaceInPool();

                _face.id = object.id;
                _face.v1.copy( v1 );
                _face.v2.copy( v2 );
                _face.v3.copy( v3 );
                _face.z = ( v1.positionScreen.z + v2.positionScreen.z + v3.positionScreen.z ) / 3;

                for ( var i = 0; i < 3; i ++ ) {

                    var offset = arguments[ i ] * 3;
                    var normal = _face.vertexNormalsModel[ i ];

                    normal.set( normals[ offset ], normals[ offset + 1 ], normals[ offset + 2 ] );
                    normal.applyMatrix3( normalMatrix ).normalize();

                    var offset2 = arguments[ i ] * 2;

                    var uv = _face.uvs[ i ];
                    uv.set( uvs[ offset2 ], uvs[ offset2 + 1 ] );

                }

                _face.vertexNormalsLength = 3;

                _face.material = object.material;

                _renderData.elements.push( _face );

            }

        };

        return {
            setObject: setObject,
            projectVertex: projectVertex,
            checkTriangleVisibility: checkTriangleVisibility,
            checkBackfaceCulling: checkBackfaceCulling,
            pushVertex: pushVertex,
            pushNormal: pushNormal,
            pushUv: pushUv,
            pushLine: pushLine,
            pushTriangle: pushTriangle
        }

    };

    var renderList = new RenderList();

    this.projectScene = function ( scene, camera, sortObjects, sortElements ) {

        _faceCount = 0;
        _lineCount = 0;
        _spriteCount = 0;

        _renderData.elements.length = 0;

        if ( scene.autoUpdate === true ) scene.updateMatrixWorld();
        if ( camera.parent === undefined ) camera.updateMatrixWorld();

        //_viewMatrix.copy( camera.matrixWorldInverse.getInverse( camera.matrixWorld ) );
        _viewMatrix.copy( camera.matrixWorldInverse.copy(camera.matrixWorld).invert() );
        _viewProjectionMatrix.multiplyMatrices( camera.projectionMatrix, _viewMatrix );

        _frustum.setFromMatrix( _viewProjectionMatrix );

        //

        _objectCount = 0;

        _renderData.objects.length = 0;
        _renderData.lights.length = 0;

        scene.traverseVisible( function ( object ) {

            if ( object instanceof THREE.Light ) {

                _renderData.lights.push( object );

            } else if ( object instanceof THREE.Mesh || object instanceof THREE.Line || object instanceof THREE.Sprite ) {

                if ( object.material.visible === false ) return;

                if ( object.frustumCulled === false || _frustum.intersectsObject( object ) === true ) {

                    _object = getNextObjectInPool();
                    _object.id = object.id;
                    _object.object = object;

                    _vector3.setFromMatrixPosition( object.matrixWorld );
                    _vector3.applyProjection( _viewProjectionMatrix );
                    _object.z = _vector3.z;

                    _renderData.objects.push( _object );

                }

            }

        } );

        if ( sortObjects === true ) {

            _renderData.objects.sort( painterSort );

        }

        //

        for ( var o = 0, ol = _renderData.objects.length; o < ol; o ++ ) {

            var object = _renderData.objects[ o ].object;
            var geometry = object.geometry;

            renderList.setObject( object );

            _modelMatrix = object.matrixWorld;

            _vertexCount = 0;

            if ( object instanceof THREE.Mesh ) {

                if ( geometry instanceof THREE.BufferGeometry ) {

                    var attributes = geometry.attributes;
                    var offsets = geometry.offsets;

                    if ( attributes.position === undefined ) continue;

                    var positions = attributes.position.array;

                    for ( var i = 0, l = positions.length; i < l; i += 3 ) {

                        renderList.pushVertex( positions[ i ], positions[ i + 1 ], positions[ i + 2 ] );

                    }

                    if ( attributes.normal !== undefined ) {

                        var normals = attributes.normal.array;

                        for ( var i = 0, l = normals.length; i < l; i += 3 ) {

                            renderList.pushNormal( normals[ i ], normals[ i + 1 ], normals[ i + 2 ] );

                        }

                    }

                    if ( attributes.uv !== undefined ) {

                        var uvs = attributes.uv.array;

                        for ( var i = 0, l = uvs.length; i < l; i += 2 ) {

                            renderList.pushUv( uvs[ i ], uvs[ i + 1 ] );

                        }

                    }

                    if ( attributes.index !== undefined ) {

                        var indices = attributes.index.array;

                        if ( offsets.length > 0 ) {

                            for ( var o = 0; o < offsets.length; o ++ ) {

                                var offset = offsets[ o ];
                                var index = offset.index;

                                for ( var i = offset.start, l = offset.start + offset.count; i < l; i += 3 ) {

                                    renderList.pushTriangle( indices[ i ] + index, indices[ i + 1 ] + index, indices[ i + 2 ] + index );

                                }

                            }

                        } else {

                            for ( var i = 0, l = indices.length; i < l; i += 3 ) {

                                renderList.pushTriangle( indices[ i ], indices[ i + 1 ], indices[ i + 2 ] );

                            }

                        }

                    } else {

                        for ( var i = 0, l = positions.length / 3; i < l; i += 3 ) {

                            renderList.pushTriangle( i, i + 1, i + 2 );

                        }

                    }

                }
                /*
                else if ( geometry instanceof THREE.Geometry ) {

                    var vertices = geometry.vertices;
                    var faces = geometry.faces;
                    var faceVertexUvs = geometry.faceVertexUvs[ 0 ];

                    _normalMatrix.getNormalMatrix( _modelMatrix );

                    var isFaceMaterial = object.material instanceof THREE.MeshFaceMaterial;
                    var objectMaterials = isFaceMaterial === true ? object.material : null;

                    for ( var v = 0, vl = vertices.length; v < vl; v ++ ) {

                        var vertex = vertices[ v ];
                        renderList.pushVertex( vertex.x, vertex.y, vertex.z );

                    }

                    for ( var f = 0, fl = faces.length; f < fl; f ++ ) {

                        var face = faces[ f ];

                        var material = isFaceMaterial === true
                             ? objectMaterials.materials[ face.materialIndex ]
                             : object.material;

                        if ( material === undefined ) continue;

                        var side = material.side;

                        var v1 = _vertexPool[ face.a ];
                        var v2 = _vertexPool[ face.b ];
                        var v3 = _vertexPool[ face.c ];

                        if ( material.morphTargets === true ) {

                            var morphTargets = geometry.morphTargets;
                            var morphInfluences = object.morphTargetInfluences;

                            var v1p = v1.position;
                            var v2p = v2.position;
                            var v3p = v3.position;

                            _vA.set( 0, 0, 0 );
                            _vB.set( 0, 0, 0 );
                            _vC.set( 0, 0, 0 );

                            for ( var t = 0, tl = morphTargets.length; t < tl; t ++ ) {

                                var influence = morphInfluences[ t ];

                                if ( influence === 0 ) continue;

                                var targets = morphTargets[ t ].vertices;

                                _vA.x += ( targets[ face.a ].x - v1p.x ) * influence;
                                _vA.y += ( targets[ face.a ].y - v1p.y ) * influence;
                                _vA.z += ( targets[ face.a ].z - v1p.z ) * influence;

                                _vB.x += ( targets[ face.b ].x - v2p.x ) * influence;
                                _vB.y += ( targets[ face.b ].y - v2p.y ) * influence;
                                _vB.z += ( targets[ face.b ].z - v2p.z ) * influence;

                                _vC.x += ( targets[ face.c ].x - v3p.x ) * influence;
                                _vC.y += ( targets[ face.c ].y - v3p.y ) * influence;
                                _vC.z += ( targets[ face.c ].z - v3p.z ) * influence;

                            }

                            v1.position.add( _vA );
                            v2.position.add( _vB );
                            v3.position.add( _vC );

                            renderList.projectVertex( v1 );
                            renderList.projectVertex( v2 );
                            renderList.projectVertex( v3 );

                        }

                        if ( renderList.checkTriangleVisibility( v1, v2, v3 ) === false ) continue;

                        var visible = renderList.checkBackfaceCulling( v1, v2, v3 );

                        if ( side !== THREE.DoubleSide ) {
                            if ( side === THREE.FrontSide && visible === false ) continue;
                            if ( side === THREE.BackSide && visible === true ) continue;
                        }

                        _face = getNextFaceInPool();

                        _face.id = object.id;
                        _face.v1.copy( v1 );
                        _face.v2.copy( v2 );
                        _face.v3.copy( v3 );

                        _face.normalModel.copy( face.normal );

                        if ( visible === false && ( side === THREE.BackSide || side === THREE.DoubleSide ) ) {

                            _face.normalModel.negate();

                        }

                        _face.normalModel.applyMatrix3( _normalMatrix ).normalize();

                        var faceVertexNormals = face.vertexNormals;

                        for ( var n = 0, nl = Math.min( faceVertexNormals.length, 3 ); n < nl; n ++ ) {

                            var normalModel = _face.vertexNormalsModel[ n ];
                            normalModel.copy( faceVertexNormals[ n ] );

                            if ( visible === false && ( side === THREE.BackSide || side === THREE.DoubleSide ) ) {

                                normalModel.negate();

                            }

                            normalModel.applyMatrix3( _normalMatrix ).normalize();

                        }

                        _face.vertexNormalsLength = faceVertexNormals.length;

                        var vertexUvs = faceVertexUvs[ f ];

                        if ( vertexUvs !== undefined ) {

                            for ( var u = 0; u < 3; u ++ ) {

                                _face.uvs[ u ].copy( vertexUvs[ u ] );

                            }

                        }

                        _face.color = face.color;
                        _face.material = material;

                        _face.z = ( v1.positionScreen.z + v2.positionScreen.z + v3.positionScreen.z ) / 3;

                        _renderData.elements.push( _face );

                    }

                }
                */

            } else if ( object instanceof THREE.Line ) {

                if ( geometry instanceof THREE.BufferGeometry ) {

                    var attributes = geometry.attributes;

                    if ( attributes.position !== undefined ) {

                        var positions = attributes.position.array;

                        for ( var i = 0, l = positions.length; i < l; i += 3 ) {

                            renderList.pushVertex( positions[ i ], positions[ i + 1 ], positions[ i + 2 ] );

                        }

                        if ( attributes.index !== undefined ) {

                            var indices = attributes.index.array;

                            for ( var i = 0, l = indices.length; i < l; i += 2 ) {

                                renderList.pushLine( indices[ i ], indices[ i + 1 ] );

                            }

                        } else {

                            var step = object.mode === THREE.LinePieces ? 2 : 1;

                            for ( var i = 0, l = ( positions.length / 3 ) - 1; i < l; i += step ) {

                                renderList.pushLine( i, i + 1 );

                            }

                        }

                    }

                }
                /*
                else if ( geometry instanceof THREE.Geometry ) {

                    _modelViewProjectionMatrix.multiplyMatrices( _viewProjectionMatrix, _modelMatrix );

                    var vertices = object.geometry.vertices;

                    if ( vertices.length === 0 ) continue;

                    v1 = getNextVertexInPool();
                    v1.positionScreen.copy( vertices[ 0 ] ).applyMatrix4( _modelViewProjectionMatrix );

                    // Handle LineStrip and LinePieces
                    var step = object.mode === THREE.LinePieces ? 2 : 1;

                    for ( var v = 1, vl = vertices.length; v < vl; v ++ ) {

                        v1 = getNextVertexInPool();
                        v1.positionScreen.copy( vertices[ v ] ).applyMatrix4( _modelViewProjectionMatrix );

                        if ( ( v + 1 ) % step > 0 ) continue;

                        v2 = _vertexPool[ _vertexCount - 2 ];

                        _clippedVertex1PositionScreen.copy( v1.positionScreen );
                        _clippedVertex2PositionScreen.copy( v2.positionScreen );

                        if ( clipLine( _clippedVertex1PositionScreen, _clippedVertex2PositionScreen ) === true ) {

                            // Perform the perspective divide
                            _clippedVertex1PositionScreen.multiplyScalar( 1 / _clippedVertex1PositionScreen.w );
                            _clippedVertex2PositionScreen.multiplyScalar( 1 / _clippedVertex2PositionScreen.w );

                            _line = getNextLineInPool();

                            _line.id = object.id;
                            _line.v1.positionScreen.copy( _clippedVertex1PositionScreen );
                            _line.v2.positionScreen.copy( _clippedVertex2PositionScreen );

                            _line.z = Math.max( _clippedVertex1PositionScreen.z, _clippedVertex2PositionScreen.z );

                            _line.material = object.material;

                            if ( object.material.vertexColors === THREE.VertexColors ) {

                                _line.vertexColors[ 0 ].copy( object.geometry.colors[ v ] );
                                _line.vertexColors[ 1 ].copy( object.geometry.colors[ v - 1 ] );

                            }

                            _renderData.elements.push( _line );

                        }

                    }

                }
                */

            } else if ( object instanceof THREE.Sprite ) {

                _vector4.set( _modelMatrix.elements[ 12 ], _modelMatrix.elements[ 13 ], _modelMatrix.elements[ 14 ], 1 );
                _vector4.applyMatrix4( _viewProjectionMatrix );

                var invW = 1 / _vector4.w;

                _vector4.z *= invW;

                if ( _vector4.z >= - 1 && _vector4.z <= 1 ) {

                    _sprite = getNextSpriteInPool();
                    _sprite.id = object.id;
                    _sprite.x = _vector4.x * invW;
                    _sprite.y = _vector4.y * invW;
                    _sprite.z = _vector4.z;
                    _sprite.object = object;

                    _sprite.rotation = object.rotation;

                    _sprite.scale.x = object.scale.x * Math.abs( _sprite.x - ( _vector4.x + camera.projectionMatrix.elements[ 0 ] ) / ( _vector4.w + camera.projectionMatrix.elements[ 12 ] ) );
                    _sprite.scale.y = object.scale.y * Math.abs( _sprite.y - ( _vector4.y + camera.projectionMatrix.elements[ 5 ] ) / ( _vector4.w + camera.projectionMatrix.elements[ 13 ] ) );

                    _sprite.material = object.material;

                    _renderData.elements.push( _sprite );

                }

            }

        }

        if ( sortElements === true ) {

            _renderData.elements.sort( painterSort );

        }

        return _renderData;

    };

    // Pools

    function getNextObjectInPool() {

        if ( _objectCount === _objectPoolLength ) {

            var object = new THREE.RenderableObject();
            _objectPool.push( object );
            _objectPoolLength ++;
            _objectCount ++;
            return object;

        }

        return _objectPool[ _objectCount ++ ];

    }

    function getNextVertexInPool() {

        if ( _vertexCount === _vertexPoolLength ) {

            var vertex = new THREE.RenderableVertex();
            _vertexPool.push( vertex );
            _vertexPoolLength ++;
            _vertexCount ++;
            return vertex;

        }

        return _vertexPool[ _vertexCount ++ ];

    }

    function getNextFaceInPool() {

        if ( _faceCount === _facePoolLength ) {

            var face = new THREE.RenderableFace();
            _facePool.push( face );
            _facePoolLength ++;
            _faceCount ++;
            return face;

        }

        return _facePool[ _faceCount ++ ];


    }

    function getNextLineInPool() {

        if ( _lineCount === _linePoolLength ) {

            var line = new THREE.RenderableLine();
            _linePool.push( line );
            _linePoolLength ++;
            _lineCount ++
            return line;

        }

        return _linePool[ _lineCount ++ ];

    }

    function getNextSpriteInPool() {

        if ( _spriteCount === _spritePoolLength ) {

            var sprite = new THREE.RenderableSprite();
            _spritePool.push( sprite );
            _spritePoolLength ++;
            _spriteCount ++
            return sprite;

        }

        return _spritePool[ _spriteCount ++ ];

    }

    //

    function painterSort( a, b ) {

        if ( a.z !== b.z ) {

            return b.z - a.z;

        } else if ( a.id !== b.id ) {

            return a.id - b.id;

        } else {

            return 0;

        }

    }

    function clipLine( s1, s2 ) {

        var alpha1 = 0, alpha2 = 1,

        // Calculate the boundary coordinate of each vertex for the near and far clip planes,
        // Z = -1 and Z = +1, respectively.
        bc1near =  s1.z + s1.w,
        bc2near =  s2.z + s2.w,
        bc1far =  - s1.z + s1.w,
        bc2far =  - s2.z + s2.w;

        if ( bc1near >= 0 && bc2near >= 0 && bc1far >= 0 && bc2far >= 0 ) {

            // Both vertices lie entirely within all clip planes.
            return true;

        } else if ( ( bc1near < 0 && bc2near < 0 ) || ( bc1far < 0 && bc2far < 0 ) ) {

            // Both vertices lie entirely outside one of the clip planes.
            return false;

        } else {

            // The line segment spans at least one clip plane.

            if ( bc1near < 0 ) {

                // v1 lies outside the near plane, v2 inside
                alpha1 = Math.max( alpha1, bc1near / ( bc1near - bc2near ) );

            } else if ( bc2near < 0 ) {

                // v2 lies outside the near plane, v1 inside
                alpha2 = Math.min( alpha2, bc1near / ( bc1near - bc2near ) );

            }

            if ( bc1far < 0 ) {

                // v1 lies outside the far plane, v2 inside
                alpha1 = Math.max( alpha1, bc1far / ( bc1far - bc2far ) );

            } else if ( bc2far < 0 ) {

                // v2 lies outside the far plane, v2 inside
                alpha2 = Math.min( alpha2, bc1far / ( bc1far - bc2far ) );

            }

            if ( alpha2 < alpha1 ) {

                // The line segment spans two boundaries, but is outside both of them.
                // (This can't happen when we're only clipping against just near/far but good
                //  to leave the check here for future usage if other clip planes are added.)
                return false;

            } else {

                // Update the s1 and s2 vertices to match the clipped line segment.
                s1.lerp( s2, alpha1 );
                s2.lerp( s1, 1 - alpha2 );

                return true;

            }

        }

    }

};

/* TrackballControls.js from http://threejs.org/
 * @author Eberhard Graether / http://egraether.com/
 * @author Mark Lundin  / http://mark-lundin.com
 * modified by Jiyao Wang
 */



THREE.TrackballControls = function ( object, domElement, icn3d ) {
    "use strict";

    var _this = this;

    this.STATE = { NONE: -1, ROTATE: 0, ZOOM: 1, PAN: 2, TOUCH_ROTATE: 3, TOUCH_ZOOM_PAN: 4 };

    this.object = object;
    this.domElement = ( domElement !== undefined ) ? domElement : document;

    // API
    this.enabled = true;

    this.screen = { left: 0, top: 0, width: 0, height: 0 };

    this.rotateSpeed = 1.0;
    this.zoomSpeed = 1.2;
    this.panSpeed = 0.3;

    this.noRotate = false;
    this.noZoom = false;
    this.noPan = false;
    this.noRoll = false;

    this.staticMoving = false;
    this.dynamicDampingFactor = 0.2;

    this.minDistance = 0;
    this.maxDistance = Infinity;

    this.keys = [ 65 /*A*/, 83 /*S*/, 68 /*D*/ ];

    // internals

    this.target = new THREE.Vector3();

    var EPS = 0.000001;

    var lastPosition = new THREE.Vector3();

    this._state = this.STATE.NONE;
    var _prevState = this.STATE.NONE;

    var _eye = new THREE.Vector3();

    this._rotateStart = new THREE.Vector3();
    this._rotateEnd = new THREE.Vector3();

    this._zoomStart = new THREE.Vector2();
    this._zoomEnd = new THREE.Vector2();

    var _touchZoomDistanceStart = 0;
    var _touchZoomDistanceEnd = 0;

    this._panStart = new THREE.Vector2();
    this._panEnd = new THREE.Vector2();

    // for reset

    this.target0 = this.target.clone();
    this.position0 = this.object.position.clone();
    this.up0 = this.object.up.clone();

    // events

    var changeEvent = { type: 'change' };
    var startEvent = { type: 'start'};
    var endEvent = { type: 'end'};


    // methods

    this.handleResize = function () {

        if ( this.domElement === document ) {

            this.screen.left = 0;
            this.screen.top = 0;
            this.screen.width = window.innerWidth;
            this.screen.height = window.innerHeight;

        } else if(this.domElement) {

            var box = this.domElement.getBoundingClientRect();
            // adjustments come from similar code in the jquery offset() function
            var d = this.domElement.ownerDocument.documentElement;
            this.screen.left = box.left + window.pageXOffset - d.clientLeft;
            this.screen.top = box.top + window.pageYOffset - d.clientTop;
            this.screen.width = box.width;
            this.screen.height = box.height;

        }

    };

    this.handleEvent = function ( event ) {

        if ( typeof this[ event.type ] === 'function' ) {

            this[ event.type ]( event );

        }

    };

    var getMouseOnScreen = ( function () {

        var vector = new THREE.Vector2();

        return function ( pageX, pageY ) {

            vector.set(
                ( pageX - _this.screen.left ) / _this.screen.width,
                ( pageY - _this.screen.top ) / _this.screen.height
            );

            return vector;

        };

    }() );

    var getMouseProjectionOnBall = ( function () {

        var vector = new THREE.Vector3();
        var objectUp = new THREE.Vector3();
        var mouseOnBall = new THREE.Vector3();

        return function ( pageX, pageY ) {

            mouseOnBall.set(
                ( pageX - _this.screen.width * 0.5 - _this.screen.left ) / (_this.screen.width*.5),
                ( _this.screen.height * 0.5 + _this.screen.top - pageY ) / (_this.screen.height*.5),
                0.0
            );

            var length = mouseOnBall.length();

            if ( _this.noRoll ) {

                if ( length < Math.SQRT1_2 ) {

                    mouseOnBall.z = Math.sqrt( 1.0 - length*length );

                } else {

                    mouseOnBall.z = .5 / length;

                }

            } else if ( length > 1.0 ) {

                mouseOnBall.normalize();

            } else {

                mouseOnBall.z = Math.sqrt( 1.0 - length * length );

            }

            _eye.copy( _this.object.position ).sub( _this.target );

            vector.copy( _this.object.up ).setLength( mouseOnBall.y )
            vector.add( objectUp.copy( _this.object.up ).cross( _eye ).setLength( mouseOnBall.x ) );
            vector.add( _eye.setLength( mouseOnBall.z ) );

            return vector;

        };

    }() );

    this.rotateCamera = (function(quaternionIn, bUpdate){

        var axis = new THREE.Vector3(),
            quaternion = new THREE.Quaternion();


        return function (quaternionIn, bUpdate) {

            var angle;
            if(quaternionIn === undefined) {
              angle = Math.acos( _this._rotateStart.dot( _this._rotateEnd ) / _this._rotateStart.length() / _this._rotateEnd.length() );
            }

            //var angle = Math.acos( _this._rotateStart.dot( _this._rotateEnd ) / _this._rotateStart.length() / _this._rotateEnd.length() );

            if ( angle || quaternionIn !== undefined) {
                if(quaternionIn === undefined) {
                  axis.crossVectors( _this._rotateStart, _this._rotateEnd ).normalize();

                  angle *= _this.rotateSpeed;

                  quaternion.setFromAxisAngle( axis, -angle );
                }
                else {
                  quaternion.copy(quaternionIn);
                }

                // order matters in quaernion multiplication: http://www.cprogramming.com/tutorial/3d/quaternions.html
                if(icn3d !== undefined && icn3d.quaternion !== undefined && (bUpdate === undefined || bUpdate === true)) {
                    icn3d.quaternion.multiplyQuaternions(quaternion, icn3d.quaternion);
                }

                _eye.applyQuaternion( quaternion );
                _this.object.up.applyQuaternion( quaternion );

                _this._rotateEnd.applyQuaternion( quaternion );

                if ( _this.staticMoving ) {

                    _this._rotateStart.copy( _this._rotateEnd );

                } else {

                    quaternion.setFromAxisAngle( axis, angle * ( _this.dynamicDampingFactor - 1.0 ) );
                    _this._rotateStart.applyQuaternion( quaternion );

                }
            }

        }

    }());

    this.zoomCamera = function (zoomFactor, bUpdate) {
        if ( _this._state === _this.STATE.TOUCH_ZOOM_PAN ) {

            var factor;

            if(zoomFactor !== undefined) {
              factor = zoomFactor;
            }
            else {

              factor = _touchZoomDistanceStart / _touchZoomDistanceEnd;
              _touchZoomDistanceStart = _touchZoomDistanceEnd;
            }

            _eye.multiplyScalar( factor );

            if(icn3d !== undefined && icn3d._zoomFactor !== undefined && (bUpdate === undefined || bUpdate === true)) {
                icn3d._zoomFactor *= factor;
                icn3d.fogCls.setFog();
            }

        } else {

            var factor;

            if(zoomFactor !== undefined) {
              factor = zoomFactor;
            }
            else {
              factor = 1.0 + ( _this._zoomEnd.y - _this._zoomStart.y ) * _this.zoomSpeed;
            }

            if(icn3d !== undefined && icn3d._zoomFactor !== undefined && (bUpdate === undefined || bUpdate === true)) {
                icn3d._zoomFactor *= factor;
                icn3d.fogCls.setFog();
            }

            //if ( factor !== 1.0 && factor > 0.0 ) {
            if ( factor !== 1.0 ) {

                _eye.multiplyScalar( factor );

                if ( _this.staticMoving ) {

                    _this._zoomStart.copy( _this._zoomEnd );

                } else {

                    _this._zoomStart.y += ( _this._zoomEnd.y - _this._zoomStart.y ) * this.dynamicDampingFactor;
                }
            }

        }

    };

    this.panCamera = (function(mouseChangeIn, bUpdate){

        var mouseChange = new THREE.Vector2(),
            objectUp = new THREE.Vector3(),
            pan = new THREE.Vector3();

        return function (mouseChangeIn, bUpdate) {

            if(mouseChangeIn !== undefined) {
              mouseChange = mouseChangeIn;

              if(icn3d !== undefined && icn3d.mouseChange !== undefined && (bUpdate === undefined || bUpdate === true)) icn3d.mouseChange.add(mouseChangeIn);
            }
            else {
              mouseChange.copy( _this._panEnd ).sub( _this._panStart );

              if(icn3d !== undefined && icn3d.mouseChange !== undefined && (bUpdate === undefined || bUpdate === true)) icn3d.mouseChange.add( _this._panEnd ).sub( _this._panStart );
            }

            if ( mouseChange.lengthSq() ) {
                mouseChange.multiplyScalar( _eye.length() * _this.panSpeed );

                pan.copy( _eye ).cross( _this.object.up ).setLength( mouseChange.x );
                pan.add( objectUp.copy( _this.object.up ).setLength( mouseChange.y ) );

                _this.object.position.add( pan );
                _this.target.add( pan );

                if ( _this.staticMoving ) {

                    _this._panStart.copy( _this._panEnd );

                } else {

                    _this._panStart.add( mouseChange.subVectors( _this._panEnd, _this._panStart ).multiplyScalar( _this.dynamicDampingFactor ) );

                }

            }
        }

    }());

    this.checkDistances = function () {

        if ( !_this.noZoom || !_this.noPan ) {

            if ( _eye.lengthSq() > _this.maxDistance * _this.maxDistance ) {

                _this.object.position.addVectors( _this.target, _eye.setLength( _this.maxDistance ) );

            }

            if ( _eye.lengthSq() < _this.minDistance * _this.minDistance ) {

                _this.object.position.addVectors( _this.target, _eye.setLength( _this.minDistance ) );

            }

        }

    };

    this.update = function (para) {

        _eye.subVectors( _this.object.position, _this.target );

        if ( !_this.noRotate ) {

            if(para !== undefined && para.quaternion !== undefined) {
              _this.rotateCamera(para.quaternion, para.update);
            }
            else {
              _this.rotateCamera();
            }

        }

        if ( !_this.noZoom ) {

            if(para !== undefined && para._zoomFactor !== undefined) {
              _this.zoomCamera(para._zoomFactor, para.update);
            }
            else {
              _this.zoomCamera();
            }

        }

        if ( !_this.noPan ) {

            if(para !== undefined && para.mouseChange !== undefined) {
              _this.panCamera(para.mouseChange, para.update);
            }
            else {
              _this.panCamera();
            }

        }

        _this.object.position.addVectors( _this.target, _eye );

        _this.checkDistances();

        _this.object.lookAt( _this.target );

        if ( lastPosition.distanceToSquared( _this.object.position ) > EPS ) {

            _this.dispatchEvent( changeEvent );

            lastPosition.copy( _this.object.position );

        }

    };

    this.reset = function () {

        _this._state = _this.STATE.NONE;
        _prevState = _this.STATE.NONE;

        _this.target.copy( _this.target0 );
        _this.object.position.copy( _this.position0 );
        _this.object.up.copy( _this.up0 );

        _eye.subVectors( _this.object.position, _this.target );

        _this.object.lookAt( _this.target );

        _this.dispatchEvent( changeEvent );

        lastPosition.copy( _this.object.position );

    };

    // listeners

    function keydown( event ) {
//console.log("keydown");

        if ( _this.enabled === false || Object.keys(window).length < 2)  return;

        window.removeEventListener( 'keydown', keydown );

        _prevState = _this._state;


        if ( _this._state !== _this.STATE.NONE ) {

            return;

        } else if ( event.keyCode === _this.keys[ _this.STATE.ROTATE ] &&  !_this.noRotate) {

            _this._state = _this.STATE.ROTATE;

        } else if ( (event.keyCode === _this.keys[ _this.STATE.ZOOM ]) && !_this.noZoom ) {

            _this._state = _this.STATE.ZOOM;

        } else if ( (event.keyCode === _this.keys[ _this.STATE.PAN ]) && !_this.noPan ) {

            _this._state = _this.STATE.PAN;

        }


    }

    function keyup( event ) {
//console.log("keyup");

        if ( _this.enabled === false || Object.keys(window).length < 2)  return;

        _this._state = _prevState;

        window.addEventListener( 'keydown', keydown, false );

    }

    function mousedown( event ) {

        if ( _this.enabled === false || Object.keys(window).length < 2)  return;

        //event.preventDefault();
        event.stopPropagation();

        if ( _this._state === _this.STATE.NONE ) {

            _this._state = event.button;

        }

        if ( _this._state === _this.STATE.ROTATE && !_this.noRotate ) {

            _this._rotateStart.copy( getMouseProjectionOnBall( event.pageX, event.pageY ) );
            _this._rotateEnd.copy( _this._rotateStart );

        } else if ( _this._state === _this.STATE.ZOOM && !_this.noZoom ) {

            _this._zoomStart.copy( getMouseOnScreen( event.pageX, event.pageY ) );
            _this._zoomEnd.copy(_this._zoomStart);

        } else if ( _this._state === _this.STATE.PAN && !_this.noPan ) {

            _this._panStart.copy( getMouseOnScreen( event.pageX, event.pageY ) );
            _this._panEnd.copy(_this._panStart)

        }

        document.addEventListener( 'mousemove', mousemove, false );
        document.addEventListener( 'mouseup', mouseup, false );

        _this.dispatchEvent( startEvent );

    }

    function mousemove( event ) {

        if ( _this.enabled === false || Object.keys(window).length < 2)  return;

        //event.preventDefault();
        event.stopPropagation();

        if ( _this._state === _this.STATE.ROTATE && !_this.noRotate ) {

//console.log("ROTATE");
            _this._rotateEnd.copy( getMouseProjectionOnBall( event.pageX, event.pageY ) );

        } else if ( _this._state === _this.STATE.ZOOM && !_this.noZoom ) {

            _this._zoomEnd.copy( getMouseOnScreen( event.pageX, event.pageY ) );

        } else if ( _this._state === _this.STATE.PAN && !_this.noPan ) {

            _this._panEnd.copy( getMouseOnScreen( event.pageX, event.pageY ) );

        }

    }

    function mouseup( event ) {
        if ( _this.enabled === false || Object.keys(window).length < 2)  return;

        //event.preventDefault();
        event.stopPropagation();

        _this._state = _this.STATE.NONE;

        document.removeEventListener( 'mousemove', mousemove );
        document.removeEventListener( 'mouseup', mouseup );
        _this.dispatchEvent( endEvent );

    }

    function mousewheel( event ) {

        if ( _this.enabled === false || Object.keys(window).length < 2)  return;

        //event.preventDefault();
        event.stopPropagation();

        var delta = 0;

        if ( event.wheelDelta ) { // WebKit / Opera / Explorer 9

            delta = event.wheelDelta / 40;

        } else if ( event.detail ) { // Firefox

            delta = - event.detail / 3;

        }

        //_this._zoomStart.y += delta * 0.01;
        //_this._zoomStart.y = delta * 0.01;
        _this._zoomStart.y = delta * 0.005;
        _this.dispatchEvent( startEvent );
        _this.dispatchEvent( endEvent );

    }

    function touchstart( event ) {

        if ( _this.enabled === false || Object.keys(window).length < 2)  return;

        switch ( event.touches.length ) {
            case 1:
                _this._state = _this.STATE.TOUCH_ROTATE;
                _this._rotateStart.copy( getMouseProjectionOnBall( event.touches[ 0 ].pageX, event.touches[ 0 ].pageY ) );
                _this._rotateEnd.copy( _this._rotateStart );
                break;

            case 2:
                _this._state = _this.STATE.TOUCH_ZOOM_PAN;
                var dx = event.touches[ 0 ].pageX - event.touches[ 1 ].pageX;
                var dy = event.touches[ 0 ].pageY - event.touches[ 1 ].pageY;
                _touchZoomDistanceEnd = _touchZoomDistanceStart = Math.sqrt( dx * dx + dy * dy );

                var x = ( event.touches[ 0 ].pageX + event.touches[ 1 ].pageX ) / 2;
                var y = ( event.touches[ 0 ].pageY + event.touches[ 1 ].pageY ) / 2;
                _this._panStart.copy( getMouseOnScreen( x, y ) );
                _this._panEnd.copy( _this._panStart );
                break;

            default:
                _this._state = _this.STATE.NONE;

        }
        _this.dispatchEvent( startEvent );


    }

    function touchmove( event ) {

        if ( _this.enabled === false || Object.keys(window).length < 2)  return;

        //event.preventDefault();
        event.stopPropagation();

        switch ( event.touches.length ) {

            case 1:
                _this._rotateEnd.copy( getMouseProjectionOnBall( event.touches[ 0 ].pageX, event.touches[ 0 ].pageY ) );
                break;

            case 2:
                var dx = event.touches[ 0 ].pageX - event.touches[ 1 ].pageX;
                var dy = event.touches[ 0 ].pageY - event.touches[ 1 ].pageY;
                _touchZoomDistanceEnd = Math.sqrt( dx * dx + dy * dy );

                var x = ( event.touches[ 0 ].pageX + event.touches[ 1 ].pageX ) / 2;
                var y = ( event.touches[ 0 ].pageY + event.touches[ 1 ].pageY ) / 2;
                _this._panEnd.copy( getMouseOnScreen( x, y ) );
                break;

            default:
                _this._state = _this.STATE.NONE;

        }

    }

    function touchend( event ) {

        if ( _this.enabled === false || Object.keys(window).length < 2)  return;

        switch ( event.touches.length ) {

            case 1:
                _this._rotateEnd.copy( getMouseProjectionOnBall( event.touches[ 0 ].pageX, event.touches[ 0 ].pageY ) );
                _this._rotateStart.copy( _this._rotateEnd );
                break;

            case 2:
                _touchZoomDistanceStart = _touchZoomDistanceEnd = 0;

                var x = ( event.touches[ 0 ].pageX + event.touches[ 1 ].pageX ) / 2;
                var y = ( event.touches[ 0 ].pageY + event.touches[ 1 ].pageY ) / 2;
                _this._panEnd.copy( getMouseOnScreen( x, y ) );
                _this._panStart.copy( _this._panEnd );
                break;

        }

        _this._state = _this.STATE.NONE;
        _this.dispatchEvent( endEvent );

    }

    if(Object.keys(window).length >= 2 && this.domElement) {
        this.domElement.addEventListener( 'contextmn', function ( event ) {
            //event.preventDefault();
        }, false );

        this.domElement.addEventListener( 'mousedown', mousedown, false );

        this.domElement.addEventListener( 'mousewheel', mousewheel, false );
        this.domElement.addEventListener( 'DOMMouseScroll', mousewheel, false ); // firefox

        this.domElement.addEventListener( 'touchstart', touchstart, false );
        this.domElement.addEventListener( 'touchend', touchend, false );
        this.domElement.addEventListener( 'touchmove', touchmove, false );

        if(Object.keys(window).length >= 2) window.addEventListener( 'keydown', keydown, false );
        if(Object.keys(window).length >= 2) window.addEventListener( 'keyup', keyup, false );
    }

    this.handleResize();

    // force an update at start
    this.update();

};

THREE.TrackballControls.prototype = Object.create( THREE.EventDispatcher.prototype );
THREE.TrackballControls.prototype.constructor = THREE.TrackballControls;

/* OrthographicTrackballControls.js from http://threejs.org/
 * @author Eberhard Graether / http://egraether.com/
 * @author Mark Lundin  / http://mark-lundin.com
 * @author Patrick Fuller / http://patrick-fuller.com
 * modified by Jiyao Wang
 */



THREE.OrthographicTrackballControls = function ( object, domElement, icn3d ) { var me = this, ic = me.icn3d; "use strict";
    var _this = this;
    var STATE = { NONE: -1, ROTATE: 0, ZOOM: 1, PAN: 2, TOUCH_ROTATE: 3, TOUCH_ZOOM_PAN: 4 };

    this.object = object;
    this.domElement = ( domElement !== undefined ) ? domElement : document;

    // API
    this.enabled = true;

    this.screen = { left: 0, top: 0, width: 0, height: 0 };

    // JW: the rotation speed of orthographic should be much less than that of perspective
    //this.rotateSpeed = 1.0;
    this.rotateSpeed = 0.5;
    this.zoomSpeed = 1.2;

    var zoomSpeedAdjust = 0.01;
    this.zoomSpeed *= zoomSpeedAdjust;

    //this.panSpeed = 0.3;
    this.panSpeed = 0.03;

    this.noRotate = false;
    this.noZoom = false;
    this.noPan = false;
    this.noRoll = false;

    this.staticMoving = false;
    this.dynamicDampingFactor = 0.2;

    this.keys = [ 65 /*A*/, 83 /*S*/, 68 /*D*/ ];

    // internals

    this.target = new THREE.Vector3();

    var EPS = 0.000001;

    var lastPosition = new THREE.Vector3();

    this._state = STATE.NONE;
    var _prevState = STATE.NONE;

    var _eye = new THREE.Vector3();

    this._rotateStart = new THREE.Vector3();
    this._rotateEnd = new THREE.Vector3();

    this._zoomStart = new THREE.Vector2();
    this._zoomEnd = new THREE.Vector2();
    var _zoomFactor = 1;

    var _touchZoomDistanceStart = 0;
    var _touchZoomDistanceEnd = 0;

    this._panStart = new THREE.Vector2();
    this._panEnd = new THREE.Vector2();

    // for reset

    this.target0 = this.target.clone();
    this.position0 = this.object.position.clone();
    this.up0 = this.object.up.clone();

    this.left0 = this.object.left;
    this.right0 = this.object.right;
    this.top0 = this.object.top;
    this.bottom0 = this.object.bottom;
    this.center0 = new THREE.Vector2((this.left0 + this.right0) / 2.0, (this.top0 + this.bottom0) / 2.0);

    // events

    var changeEvent = { type: 'change' };
    var startEvent = { type: 'start'};
    var endEvent = { type: 'end'};


    // methods

    this.handleResize = function () {

        if ( this.domElement === document ) {

            this.screen.left = 0;
            this.screen.top = 0;
            this.screen.width = window.innerWidth;
            this.screen.height = window.innerHeight;

        } else if(this.domElement) {

            var box = this.domElement.getBoundingClientRect();
            // adjustments come from similar code in the jquery offset() function
            var d = this.domElement.ownerDocument.documentElement;
            this.screen.left = box.left + window.pageXOffset - d.clientLeft;
            this.screen.top = box.top + window.pageYOffset - d.clientTop;
            this.screen.width = box.width;
            this.screen.height = box.height;
        }

        this.left0 = this.object.left;
        this.right0 = this.object.right;
        this.top0 = this.object.top;
        this.bottom0 = this.object.bottom;
        this.center0.set((this.left0 + this.right0) / 2.0, (this.top0 + this.bottom0) / 2.0);

    };

    this.handleEvent = function ( event ) {

        if ( typeof this[ event.type ] === 'function' ) {

            this[ event.type ]( event );

        }

    };

    var getMouseOnScreen = ( function () {

        var vector = new THREE.Vector2();

        return function ( pageX, pageY ) {

            vector.set(
                ( pageX - _this.screen.left ) / _this.screen.width,
                ( pageY - _this.screen.top ) / _this.screen.height
            );

            return vector;

        };

    }() );

    var getMouseProjectionOnBall = ( function () {

        var vector = new THREE.Vector3();
        var objectUp = new THREE.Vector3();
        var mouseOnBall = new THREE.Vector3();

        return function ( pageX, pageY ) {

            mouseOnBall.set(
                ( pageX - _this.screen.width * 0.5 - _this.screen.left ) / (_this.screen.width*.5),
                ( _this.screen.height * 0.5 + _this.screen.top - pageY ) / (_this.screen.height*.5),
                0.0
            );

            var length = mouseOnBall.length();

            if ( _this.noRoll ) {

                if ( length < Math.SQRT1_2 ) {

                    mouseOnBall.z = Math.sqrt( 1.0 - length*length );

                } else {

                    mouseOnBall.z = .5 / length;

                }

            } else if ( length > 1.0 ) {

                mouseOnBall.normalize();

            } else {

                mouseOnBall.z = Math.sqrt( 1.0 - length * length );

            }

            _eye.copy( _this.object.position ).sub( _this.target );

            vector.copy( _this.object.up ).setLength( mouseOnBall.y )
            vector.add( objectUp.copy( _this.object.up ).cross( _eye ).setLength( mouseOnBall.x ) );
            vector.add( _eye.setLength( mouseOnBall.z ) );

            return vector;

        };

    }() );

    this.rotateCamera = (function(quaternionIn, bUpdate){

        var axis = new THREE.Vector3(),
            quaternion = new THREE.Quaternion();

        return function (quaternionIn, bUpdate) {

            var angle;
            if(quaternionIn === undefined) {
              angle = Math.acos( _this._rotateStart.dot( _this._rotateEnd ) / _this._rotateStart.length() / _this._rotateEnd.length() );
            }

            //var angle = Math.acos( _this._rotateStart.dot( _this._rotateEnd ) / _this._rotateStart.length() / _this._rotateEnd.length() );

            if ( angle || quaternionIn !== undefined) {
                if(quaternionIn === undefined) {
                  axis.crossVectors( _this._rotateStart, _this._rotateEnd ).normalize();

                  angle *= _this.rotateSpeed;

                  quaternion.setFromAxisAngle( axis, -angle );
                }
                else {
                  quaternion.copy(quaternionIn);
                }

                // order matters in quaernion multiplication: http://www.cprogramming.com/tutorial/3d/quaternions.html
                if(icn3d !== undefined && icn3d.quaternion !== undefined && (bUpdate === undefined || bUpdate === true)) icn3d.quaternion.multiplyQuaternions(quaternion, icn3d.quaternion);

                _eye.applyQuaternion( quaternion );
                _this.object.up.applyQuaternion( quaternion );

                _this._rotateEnd.applyQuaternion( quaternion );

                if ( _this.staticMoving ) {

                    _this._rotateStart.copy( _this._rotateEnd );

                } else {

                    quaternion.setFromAxisAngle( axis, angle * ( _this.dynamicDampingFactor - 1.0 ) );
                    _this._rotateStart.applyQuaternion( quaternion );

                }

            }
        }

    }());

    this.zoomCamera = function (zoomFactor, bUpdate) {

        var factor;
        if ( _this._state === STATE.TOUCH_ZOOM_PAN ) {

            if(zoomFactor !== undefined) {
              factor = zoomFactor;
            }
            else {

              factor = _touchZoomDistanceStart / _touchZoomDistanceEnd;
              _touchZoomDistanceStart = _touchZoomDistanceEnd;
            }

        } else {

            if(zoomFactor !== undefined) {
              factor = zoomFactor;
            }
            else {

              factor = 1.0 + ( _this._zoomEnd.y - _this._zoomStart.y ) * _this.zoomSpeed / zoomSpeedAdjust;
            }
        }

        if(icn3d !== undefined && icn3d._zoomFactor !== undefined && (bUpdate === undefined || bUpdate === true)) icn3d._zoomFactor *= factor;

        //if ( factor !== 1.0 && factor > 0.0 ) {
        if ( factor !== 1.0 ) {

            //_zoomFactor *= factor;
            _zoomFactor = factor;

            _this.object.left = _zoomFactor * _this.left0 + ( 1 - _zoomFactor ) *  _this.center0.x;
            _this.object.right = _zoomFactor * _this.right0 + ( 1 - _zoomFactor ) *  _this.center0.x;
            _this.object.top = _zoomFactor * _this.top0 + ( 1 - _zoomFactor ) *  _this.center0.y;
            _this.object.bottom = _zoomFactor * _this.bottom0 + ( 1 - _zoomFactor ) *  _this.center0.y;

            if ( _this.staticMoving ) {

                _this._zoomStart.copy( _this._zoomEnd );

            } else {

                _this._zoomStart.y += ( _this._zoomEnd.y - _this._zoomStart.y ) * this.dynamicDampingFactor;

            }

        }

    };

    this.panCamera = (function(mouseChangeIn, bUpdate){

        var mouseChange = new THREE.Vector2(),
            objectUp = new THREE.Vector3(),
            pan = new THREE.Vector3();

        return function (mouseChangeIn, bUpdate) {

            if(mouseChangeIn !== undefined) {
              mouseChange = mouseChangeIn;

              if(icn3d !== undefined && icn3d.mouseChange !== undefined && (bUpdate === undefined || bUpdate === true)) icn3d.mouseChange.add(mouseChangeIn);
            }
            else {
              mouseChange.copy( _this._panEnd ).sub( _this._panStart );

              if(icn3d !== undefined && icn3d.mouseChange !== undefined && (bUpdate === undefined || bUpdate === true)) icn3d.mouseChange.add( _this._panEnd ).sub( _this._panStart );
            }

            if ( mouseChange.lengthSq() ) {

                mouseChange.multiplyScalar( _eye.length() * _this.panSpeed );

                pan.copy( _eye ).cross( _this.object.up ).setLength( mouseChange.x );
                pan.add( objectUp.copy( _this.object.up ).setLength( mouseChange.y ) );

                _this.object.position.add( pan );
                _this.target.add( pan );

                if ( _this.staticMoving ) {

                    _this._panStart.copy( _this._panEnd );

                } else {

                    _this._panStart.add( mouseChange.subVectors( _this._panEnd, _this._panStart ).multiplyScalar( _this.dynamicDampingFactor ) );

                }

            }
        }

    }());

    this.update = function (para) {

        _eye.subVectors( _this.object.position, _this.target );

        if ( !_this.noRotate ) {

            if(para !== undefined && para.quaternion !== undefined) {
              _this.rotateCamera(para.quaternion, para.update);
            }
            else {
              _this.rotateCamera();
            }

        }

        if ( !_this.noZoom ) {

            if(para !== undefined && para._zoomFactor !== undefined) {
              _this.zoomCamera(para._zoomFactor, para.update);
            }
            else {
              _this.zoomCamera();
            }

            _this.object.updateProjectionMatrix();

        }

        if ( !_this.noPan ) {

            if(para !== undefined && para.mouseChange !== undefined) {
              _this.panCamera(para.mouseChange, para.update);
            }
            else {
              _this.panCamera();
            }

        }

        _this.object.position.addVectors( _this.target, _eye );

        _this.object.lookAt( _this.target );

        if ( lastPosition.distanceToSquared( _this.object.position ) > EPS ) {

            _this.dispatchEvent( changeEvent );

            lastPosition.copy( _this.object.position );

        }

    };

    this.reset = function () {

        _this._state = STATE.NONE;
        _prevState = STATE.NONE;

        _this.target.copy( _this.target0 );
        _this.object.position.copy( _this.position0 );
        _this.object.up.copy( _this.up0 );

        _eye.subVectors( _this.object.position, _this.target );

        _this.object.left = _this.left0;
        _this.object.right = _this.right0;
        _this.object.top = _this.top0;
        _this.object.bottom = _this.bottom0;

        _this.object.lookAt( _this.target );

        _this.dispatchEvent( changeEvent );

        lastPosition.copy( _this.object.position );

    };

    // listeners

    function keydown( event ) {

        if ( _this.enabled === false || Object.keys(window).length < 2)  return;

        window.removeEventListener( 'keydown', keydown );

        _prevState = _this._state;

        if ( _this._state !== STATE.NONE ) {

            return;

        } else if ( event.keyCode === _this.keys[ STATE.ROTATE ] && !_this.noRotate ) {

            _this._state = STATE.ROTATE;

        } else if ( (event.keyCode === _this.keys[ STATE.ZOOM ]) && !_this.noZoom ) {

            _this._state = STATE.ZOOM;

        } else if ( (event.keyCode === _this.keys[ STATE.PAN ]) && !_this.noPan ) {

            _this._state = STATE.PAN;

        }

    }

    function keyup( event ) {

        if ( _this.enabled === false || Object.keys(window).length < 2)  return;

        _this._state = _prevState;

        window.addEventListener( 'keydown', keydown, false );

    }

    function mousedown( event ) {

        if ( _this.enabled === false || Object.keys(window).length < 2)  return;

        //event.preventDefault();
        event.stopPropagation();

        if ( _this._state === STATE.NONE ) {

            _this._state = event.button;

        }

        if ( _this._state === STATE.ROTATE && !_this.noRotate ) {

            _this._rotateStart.copy( getMouseProjectionOnBall( event.pageX, event.pageY ) );
            _this._rotateEnd.copy( _this._rotateStart );

        } else if ( _this._state === STATE.ZOOM && !_this.noZoom ) {

            _this._zoomStart.copy( getMouseOnScreen( event.pageX, event.pageY ) );
            _this._zoomEnd.copy(_this._zoomStart);

        } else if ( _this._state === STATE.PAN && !_this.noPan ) {

            _this._panStart.copy( getMouseOnScreen( event.pageX, event.pageY ) );
            _this._panEnd.copy(_this._panStart)

        }

        document.addEventListener( 'mousemove', mousemove, false );
        document.addEventListener( 'mouseup', mouseup, false );

        _this.dispatchEvent( startEvent );

    }

    function mousemove( event ) {

        if ( _this.enabled === false || Object.keys(window).length < 2)  return;

        //event.preventDefault();
        event.stopPropagation();

        if ( _this._state === STATE.ROTATE && !_this.noRotate ) {

            _this._rotateEnd.copy( getMouseProjectionOnBall( event.pageX, event.pageY ) );

        } else if ( _this._state === STATE.ZOOM && !_this.noZoom ) {

            _this._zoomEnd.copy( getMouseOnScreen( event.pageX, event.pageY ) );

        } else if ( _this._state === STATE.PAN && !_this.noPan ) {

            _this._panEnd.copy( getMouseOnScreen( event.pageX, event.pageY ) );

        }

    }

    function mouseup( event ) {

        if ( _this.enabled === false || Object.keys(window).length < 2)  return;

        //event.preventDefault();
        event.stopPropagation();

        _this._state = STATE.NONE;

        document.removeEventListener( 'mousemove', mousemove );
        document.removeEventListener( 'mouseup', mouseup );
        _this.dispatchEvent( endEvent );

    }

    function mousewheel( event ) {

        if ( _this.enabled === false || Object.keys(window).length < 2)  return;

        //event.preventDefault();
        event.stopPropagation();

        var delta = 0;

        if ( event.wheelDelta ) { // WebKit / Opera / Explorer 9

            delta = event.wheelDelta / 40;

        } else if ( event.detail ) { // Firefox

            delta = - event.detail / 3;

        }

        //_this._zoomStart.y += delta * 0.01;
        _this._zoomStart.y = delta * 0.01;
        _this.dispatchEvent( startEvent );
        _this.dispatchEvent( endEvent );

    }

    function touchstart( event ) {

        if ( _this.enabled === false || Object.keys(window).length < 2)  return;

        switch ( event.touches.length ) {

            case 1:
                _this._state = STATE.TOUCH_ROTATE;
                _this._rotateStart.copy( getMouseProjectionOnBall( event.touches[ 0 ].pageX, event.touches[ 0 ].pageY ) );
                _this._rotateEnd.copy( _this._rotateStart );
                break;

            case 2:
                _this._state = STATE.TOUCH_ZOOM_PAN;
                var dx = event.touches[ 0 ].pageX - event.touches[ 1 ].pageX;
                var dy = event.touches[ 0 ].pageY - event.touches[ 1 ].pageY;
                _touchZoomDistanceEnd = _touchZoomDistanceStart = Math.sqrt( dx * dx + dy * dy );

                var x = ( event.touches[ 0 ].pageX + event.touches[ 1 ].pageX ) / 2;
                var y = ( event.touches[ 0 ].pageY + event.touches[ 1 ].pageY ) / 2;
                _this._panStart.copy( getMouseOnScreen( x, y ) );
                _this._panEnd.copy( _this._panStart );
                break;

            default:
                _this._state = STATE.NONE;

        }
        _this.dispatchEvent( startEvent );


    }

    function touchmove( event ) {

        if ( _this.enabled === false || Object.keys(window).length < 2)  return;

        //event.preventDefault();
        event.stopPropagation();

        switch ( event.touches.length ) {

            case 1:
                _this._rotateEnd.copy( getMouseProjectionOnBall( event.touches[ 0 ].pageX, event.touches[ 0 ].pageY ) );
                break;

            case 2:
                var dx = event.touches[ 0 ].pageX - event.touches[ 1 ].pageX;
                var dy = event.touches[ 0 ].pageY - event.touches[ 1 ].pageY;
                _touchZoomDistanceEnd = Math.sqrt( dx * dx + dy * dy );

                var x = ( event.touches[ 0 ].pageX + event.touches[ 1 ].pageX ) / 2;
                var y = ( event.touches[ 0 ].pageY + event.touches[ 1 ].pageY ) / 2;
                _this._panEnd.copy( getMouseOnScreen( x, y ) );
                break;

            default:
                _this._state = STATE.NONE;

        }

    }

    function touchend( event ) {

        if ( _this.enabled === false || Object.keys(window).length < 2)  return;

        switch ( event.touches.length ) {

            case 1:
                _this._rotateEnd.copy( getMouseProjectionOnBall( event.touches[ 0 ].pageX, event.touches[ 0 ].pageY ) );
                _this._rotateStart.copy( _this._rotateEnd );
                break;

            case 2:
                _touchZoomDistanceStart = _touchZoomDistanceEnd = 0;

                var x = ( event.touches[ 0 ].pageX + event.touches[ 1 ].pageX ) / 2;
                var y = ( event.touches[ 0 ].pageY + event.touches[ 1 ].pageY ) / 2;
                _this._panEnd.copy( getMouseOnScreen( x, y ) );
                _this._panStart.copy( _this._panEnd );
                break;

        }

        _this._state = STATE.NONE;
        _this.dispatchEvent( endEvent );

    }

    if(Object.keys(window).length >= 2 && this.domElement) {
        this.domElement.addEventListener( 'contextmn', function ( event ) {
            //event.preventDefault();
        }, false );

        this.domElement.addEventListener( 'mousedown', mousedown, false );

        this.domElement.addEventListener( 'mousewheel', mousewheel, false );
        this.domElement.addEventListener( 'DOMMouseScroll', mousewheel, false ); // firefox

        this.domElement.addEventListener( 'touchstart', touchstart, false );
        this.domElement.addEventListener( 'touchend', touchend, false );
        this.domElement.addEventListener( 'touchmove', touchmove, false );

        window.addEventListener( 'keydown', keydown, false );
        window.addEventListener( 'keyup', keyup, false );
    }

    this.handleResize();

    // force an update at start
    this.update();

};

THREE.OrthographicTrackballControls.prototype = Object.create( THREE.EventDispatcher.prototype );
THREE.OrthographicTrackballControls.prototype.constructor = THREE.OrthographicTrackballControls;


// ; var __CIFTools = function () {
//   'use strict';
/*
 * Copyright (c) 2016 - now David Sehnal, licensed under MIT License, See LICENSE file for more info.
 */
var CIFTools;
(function (CIFTools) {
    CIFTools.VERSION = { number: "1.1.7", date: "Oct 30 2018" };
// })(CIFTools || (CIFTools = {}));
/*
 * Copyright (c) 2016 - now David Sehnal, licensed under MIT License, See LICENSE file for more info.
 */
// var CIFTools;
// (function (CIFTools) {
    var Utils;
    (function (Utils) {
        var ChunkedArray;
        (function (ChunkedArray) {
            function is(x) {
                return x.creator && x.chunkSize;
            }
            ChunkedArray.is = is;
            function add4(array, x, y, z, w) {
                if (array.currentIndex >= array.chunkSize) {
                    array.currentIndex = 0;
                    array.current = array.creator(array.chunkSize);
                    array.parts[array.parts.length] = array.current;
                }
                array.current[array.currentIndex++] = x;
                array.current[array.currentIndex++] = y;
                array.current[array.currentIndex++] = z;
                array.current[array.currentIndex++] = w;
                return array.elementCount++;
            }
            ChunkedArray.add4 = add4;
            function add3(array, x, y, z) {
                if (array.currentIndex >= array.chunkSize) {
                    array.currentIndex = 0;
                    array.current = array.creator(array.chunkSize);
                    array.parts[array.parts.length] = array.current;
                }
                array.current[array.currentIndex++] = x;
                array.current[array.currentIndex++] = y;
                array.current[array.currentIndex++] = z;
                return array.elementCount++;
            }
            ChunkedArray.add3 = add3;
            function add2(array, x, y) {
                if (array.currentIndex >= array.chunkSize) {
                    array.currentIndex = 0;
                    array.current = array.creator(array.chunkSize);
                    array.parts[array.parts.length] = array.current;
                }
                array.current[array.currentIndex++] = x;
                array.current[array.currentIndex++] = y;
                return array.elementCount++;
            }
            ChunkedArray.add2 = add2;
            function add(array, x) {
                if (array.currentIndex >= array.chunkSize) {
                    array.currentIndex = 0;
                    array.current = array.creator(array.chunkSize);
                    array.parts[array.parts.length] = array.current;
                }
                array.current[array.currentIndex++] = x;
                return array.elementCount++;
            }
            ChunkedArray.add = add;
            function compact(array) {
                var ret = array.creator(array.elementSize * array.elementCount), offset = (array.parts.length - 1) * array.chunkSize, offsetInner = 0, part;
                if (array.parts.length > 1) {
                    if (array.parts[0].buffer) {
                        for (var i = 0; i < array.parts.length - 1; i++) {
                            ret.set(array.parts[i], array.chunkSize * i);
                        }
                    }
                    else {
                        for (var i = 0; i < array.parts.length - 1; i++) {
                            offsetInner = array.chunkSize * i;
                            part = array.parts[i];
                            for (var j = 0; j < array.chunkSize; j++) {
                                ret[offsetInner + j] = part[j];
                            }
                        }
                    }
                }
                if (array.current.buffer && array.currentIndex >= array.chunkSize) {
                    ret.set(array.current, array.chunkSize * (array.parts.length - 1));
                }
                else {
                    for (var i = 0; i < array.currentIndex; i++) {
                        ret[offset + i] = array.current[i];
                    }
                }
                return ret;
            }
            ChunkedArray.compact = compact;
            function forVertex3D(chunkVertexCount) {
                if (chunkVertexCount === void 0) { chunkVertexCount = 262144; }
                return create(function (size) { return new Float32Array(size); }, chunkVertexCount, 3);
            }
            ChunkedArray.forVertex3D = forVertex3D;
            function forIndexBuffer(chunkIndexCount) {
                if (chunkIndexCount === void 0) { chunkIndexCount = 262144; }
                return create(function (size) { return new Uint32Array(size); }, chunkIndexCount, 3);
            }
            ChunkedArray.forIndexBuffer = forIndexBuffer;
            function forTokenIndices(chunkTokenCount) {
                if (chunkTokenCount === void 0) { chunkTokenCount = 131072; }
                return create(function (size) { return new Int32Array(size); }, chunkTokenCount, 2);
            }
            ChunkedArray.forTokenIndices = forTokenIndices;
            function forIndices(chunkTokenCount) {
                if (chunkTokenCount === void 0) { chunkTokenCount = 131072; }
                return create(function (size) { return new Int32Array(size); }, chunkTokenCount, 1);
            }
            ChunkedArray.forIndices = forIndices;
            function forInt32(chunkSize) {
                if (chunkSize === void 0) { chunkSize = 131072; }
                return create(function (size) { return new Int32Array(size); }, chunkSize, 1);
            }
            ChunkedArray.forInt32 = forInt32;
            function forFloat32(chunkSize) {
                if (chunkSize === void 0) { chunkSize = 131072; }
                return create(function (size) { return new Float32Array(size); }, chunkSize, 1);
            }
            ChunkedArray.forFloat32 = forFloat32;
            function forArray(chunkSize) {
                if (chunkSize === void 0) { chunkSize = 131072; }
                return create(function (size) { return []; }, chunkSize, 1);
            }
            ChunkedArray.forArray = forArray;
            function create(creator, chunkElementCount, elementSize) {
                chunkElementCount = chunkElementCount | 0;
                if (chunkElementCount <= 0)
                    chunkElementCount = 1;
                var chunkSize = chunkElementCount * elementSize;
                var current = creator(chunkSize);
                return {
                    elementSize: elementSize,
                    chunkSize: chunkSize,
                    creator: creator,
                    current: current,
                    parts: [current],
                    currentIndex: 0,
                    elementCount: 0
                };
            }
            ChunkedArray.create = create;
        })(ChunkedArray = Utils.ChunkedArray || (Utils.ChunkedArray = {}));
    })(Utils = CIFTools.Utils || (CIFTools.Utils = {}));
// })(CIFTools || (CIFTools = {}));
/*
 * Copyright (c) 2016 - now David Sehnal, licensed under MIT License, See LICENSE file for more info.
 */
/**
 * Efficient integer and float parsers.
 *
 * For the purposes of parsing numbers from the mmCIF data representations,
 * up to 4 times faster than JS parseInt/parseFloat.
 */
// var CIFTools;
// (function (CIFTools) {
//     var Utils;
    (function (Utils) {
        var FastNumberParsers;
        (function (FastNumberParsers) {
            "use strict";
            function parseIntSkipTrailingWhitespace(str, start, end) {
                while (start < end && str.charCodeAt(start) === 32)
                    start++;
                return parseInt(str, start, end);
            }
            FastNumberParsers.parseIntSkipTrailingWhitespace = parseIntSkipTrailingWhitespace;
            function parseInt(str, start, end) {
                var ret = 0, neg = 1;
                if (str.charCodeAt(start) === 45 /* - */) {
                    neg = -1;
                    start++;
                }
                for (; start < end; start++) {
                    var c = str.charCodeAt(start) - 48;
                    if (c > 9 || c < 0)
                        return (neg * ret) | 0;
                    else
                        ret = (10 * ret + c) | 0;
                }
                return neg * ret;
            }
            FastNumberParsers.parseInt = parseInt;
            function parseScientific(main, str, start, end) {
                // handle + in '1e+1' separately.
                if (str.charCodeAt(start) === 43 /* + */)
                    start++;
                return main * Math.pow(10.0, parseInt(str, start, end));
            }
            function parseFloatSkipTrailingWhitespace(str, start, end) {
                while (start < end && str.charCodeAt(start) === 32)
                    start++;
                return parseFloat(str, start, end);
            }
            FastNumberParsers.parseFloatSkipTrailingWhitespace = parseFloatSkipTrailingWhitespace;
            function parseFloat(str, start, end) {
                var neg = 1.0, ret = 0.0, point = 0.0, div = 1.0;
                if (str.charCodeAt(start) === 45) {
                    neg = -1.0;
                    ++start;
                }
                while (start < end) {
                    var c = str.charCodeAt(start) - 48;
                    if (c >= 0 && c < 10) {
                        ret = ret * 10 + c;
                        ++start;
                    }
                    else if (c === -2) { // .
                        ++start;
                        while (start < end) {
                            c = str.charCodeAt(start) - 48;
                            if (c >= 0 && c < 10) {
                                point = 10.0 * point + c;
                                div = 10.0 * div;
                                ++start;
                            }
                            else if (c === 53 || c === 21) { // 'e'/'E'
                                return parseScientific(neg * (ret + point / div), str, start + 1, end);
                            }
                            else {
                                return neg * (ret + point / div);
                            }
                        }
                        return neg * (ret + point / div);
                    }
                    else if (c === 53 || c === 21) { // 'e'/'E'
                        return parseScientific(neg * ret, str, start + 1, end);
                    }
                    else
                        break;
                }
                return neg * ret;
            }
            FastNumberParsers.parseFloat = parseFloat;
        })(FastNumberParsers = Utils.FastNumberParsers || (Utils.FastNumberParsers = {}));
    })(Utils = CIFTools.Utils || (CIFTools.Utils = {}));
// })(CIFTools || (CIFTools = {}));
/*
 * Copyright (c) 2016 - now David Sehnal, licensed under MIT License, See LICENSE file for more info.
 */
// var CIFTools;
// (function (CIFTools) {
//     var Utils;
    (function (Utils) {
        var __paddingSpaces = [];
        (function () {
            var s = '';
            for (var i = 0; i < 512; i++) {
                __paddingSpaces[i] = s;
                s = s + ' ';
            }
        })();
        var StringWriter;
        (function (StringWriter) {
            function create(chunkCapacity) {
                if (chunkCapacity === void 0) { chunkCapacity = 512; }
                return {
                    chunkData: [],
                    chunkOffset: 0,
                    chunkCapacity: chunkCapacity,
                    data: []
                };
            }
            StringWriter.create = create;
            function asString(writer) {
                if (!writer.data.length) {
                    if (writer.chunkData.length === writer.chunkOffset)
                        return writer.chunkData.join('');
                    return writer.chunkData.splice(0, writer.chunkOffset).join('');
                }
                if (writer.chunkOffset > 0) {
                    writer.data[writer.data.length] = writer.chunkData.splice(0, writer.chunkOffset).join('');
                }
                return writer.data.join('');
            }
            StringWriter.asString = asString;
            function writeTo(writer, stream) {
                finalize(writer);
                for (var _i = 0, _a = writer.data; _i < _a.length; _i++) {
                    var s = _a[_i];
                    stream.writeString(s);
                }
            }
            StringWriter.writeTo = writeTo;
            function finalize(writer) {
                if (writer.chunkOffset > 0) {
                    if (writer.chunkData.length === writer.chunkOffset)
                        writer.data[writer.data.length] = writer.chunkData.join('');
                    else
                        writer.data[writer.data.length] = writer.chunkData.splice(0, writer.chunkOffset).join('');
                    writer.chunkOffset = 0;
                }
            }
            function newline(writer) {
                write(writer, '\n');
            }
            StringWriter.newline = newline;
            function whitespace(writer, len) {
                write(writer, __paddingSpaces[len]);
            }
            StringWriter.whitespace = whitespace;
            function write(writer, val) {
                if (val === undefined || val === null) {
                    return;
                }
                if (writer.chunkOffset === writer.chunkCapacity) {
                    writer.data[writer.data.length] = writer.chunkData.join('');
                    writer.chunkOffset = 0;
                }
                writer.chunkData[writer.chunkOffset++] = val;
            }
            StringWriter.write = write;
            function writeSafe(writer, val) {
                if (writer.chunkOffset === writer.chunkCapacity) {
                    writer.data[writer.data.length] = writer.chunkData.join('');
                    writer.chunkOffset = 0;
                }
                writer.chunkData[writer.chunkOffset++] = val;
            }
            StringWriter.writeSafe = writeSafe;
            function writePadLeft(writer, val, totalWidth) {
                if (val === undefined || val === null) {
                    write(writer, __paddingSpaces[totalWidth]);
                }
                var padding = totalWidth - val.length;
                if (padding > 0)
                    write(writer, __paddingSpaces[padding]);
                write(writer, val);
            }
            StringWriter.writePadLeft = writePadLeft;
            function writePadRight(writer, val, totalWidth) {
                if (val === undefined || val === null) {
                    write(writer, __paddingSpaces[totalWidth]);
                }
                var padding = totalWidth - val.length;
                write(writer, val);
                if (padding > 0)
                    write(writer, __paddingSpaces[padding]);
            }
            StringWriter.writePadRight = writePadRight;
            function writeInteger(writer, val) {
                write(writer, '' + val);
            }
            StringWriter.writeInteger = writeInteger;
            function writeIntegerPadLeft(writer, val, totalWidth) {
                var s = '' + val;
                var padding = totalWidth - s.length;
                if (padding > 0)
                    write(writer, __paddingSpaces[padding]);
                write(writer, s);
            }
            StringWriter.writeIntegerPadLeft = writeIntegerPadLeft;
            function writeIntegerPadRight(writer, val, totalWidth) {
                var s = '' + val;
                var padding = totalWidth - s.length;
                write(writer, s);
                if (padding > 0)
                    write(writer, __paddingSpaces[padding]);
            }
            StringWriter.writeIntegerPadRight = writeIntegerPadRight;
            /**
             * @example writeFloat(123.2123, 100) -- 2 decim
             */
            function writeFloat(writer, val, precisionMultiplier) {
                write(writer, '' + Math.round(precisionMultiplier * val) / precisionMultiplier);
            }
            StringWriter.writeFloat = writeFloat;
            function writeFloatPadLeft(writer, val, precisionMultiplier, totalWidth) {
                var s = '' + Math.round(precisionMultiplier * val) / precisionMultiplier;
                var padding = totalWidth - s.length;
                if (padding > 0)
                    write(writer, __paddingSpaces[padding]);
                write(writer, s);
            }
            StringWriter.writeFloatPadLeft = writeFloatPadLeft;
            function writeFloatPadRight(writer, val, precisionMultiplier, totalWidth) {
                var s = '' + Math.round(precisionMultiplier * val) / precisionMultiplier;
                var padding = totalWidth - s.length;
                write(writer, s);
                if (padding > 0)
                    write(writer, __paddingSpaces[padding]);
            }
            StringWriter.writeFloatPadRight = writeFloatPadRight;
        })(StringWriter = Utils.StringWriter || (Utils.StringWriter = {}));
    })(Utils = CIFTools.Utils || (CIFTools.Utils = {}));
// })(CIFTools || (CIFTools = {}));
/*
 * Copyright (c) 2016 - now David Sehnal, licensed under MIT License, See LICENSE file for more info.
 */
// var CIFTools;
// (function (CIFTools) {
//     "use strict";
    /**
     * Represents a column that is not present.
     */
    var _UndefinedColumn = /** @class */ (function () {
        function _UndefinedColumn() {
            this.isDefined = false;
        }
        _UndefinedColumn.prototype.getString = function (row) { return null; };
        ;
        _UndefinedColumn.prototype.getInteger = function (row) { return 0; };
        _UndefinedColumn.prototype.getFloat = function (row) { return 0.0; };
        _UndefinedColumn.prototype.getValuePresence = function (row) { return 1 /* NotSpecified */; };
        _UndefinedColumn.prototype.areValuesEqual = function (rowA, rowB) { return true; };
        _UndefinedColumn.prototype.stringEquals = function (row, value) { return value === null; };
        return _UndefinedColumn;
    }());
    CIFTools.UndefinedColumn = new _UndefinedColumn();
    /**
     * Helper functions for categoies.
     */
    var Category;
    (function (Category) {
        /**
         * Extracts a matrix from a category from a specified rowIndex.
         *
         * _category.matrix[1][1] v11
         * ....
         * ....
         * _category.matrix[rows][cols] vRowsCols
         */
        function getMatrix(category, field, rows, cols, rowIndex) {
            var ret = [];
            for (var i = 1; i <= rows; i++) {
                var row = [];
                for (var j = 1; j <= cols; j++) {
                    row[j - 1] = category.getColumn(field + "[" + i + "][" + j + "]").getFloat(rowIndex);
                }
                ret[i - 1] = row;
            }
            return ret;
        }
        Category.getMatrix = getMatrix;
        /**
         * Extracts a vector from a category from a specified rowIndex.
         *
         * _category.matrix[1][1] v11
         * ....
         * ....
         * _category.matrix[rows][cols] vRowsCols
         */
        function getVector(category, field, rows, cols, rowIndex) {
            var ret = [];
            for (var i = 1; i <= rows; i++) {
                ret[i - 1] = category.getColumn(field + "[" + i + "]").getFloat(rowIndex);
            }
            return ret;
        }
        Category.getVector = getVector;
    })(Category = CIFTools.Category || (CIFTools.Category = {}));
// })(CIFTools || (CIFTools = {}));
/*
 * Copyright (c) 2016 - now David Sehnal, licensed under MIT License, See LICENSE file for more info.
 */
// var CIFTools;
// (function (CIFTools) {
//     "use strict";
    var ParserResult;
    (function (ParserResult) {
        function error(message, line) {
            if (line === void 0) { line = -1; }
            return new ParserError(message, line);
        }
        ParserResult.error = error;
        function success(result, warnings) {
            if (warnings === void 0) { warnings = []; }
            return new ParserSuccess(result, warnings);
        }
        ParserResult.success = success;
    })(ParserResult = CIFTools.ParserResult || (CIFTools.ParserResult = {}));
    var ParserError = /** @class */ (function () {
        function ParserError(message, line) {
            this.message = message;
            this.line = line;
            this.isError = true;
        }
        ParserError.prototype.toString = function () {
            if (this.line >= 0) {
                return "[Line " + this.line + "] " + this.message;
            }
            return this.message;
        };
        return ParserError;
    }());
    CIFTools.ParserError = ParserError;
    var ParserSuccess = /** @class */ (function () {
        function ParserSuccess(result, warnings) {
            this.result = result;
            this.warnings = warnings;
            this.isError = false;
        }
        return ParserSuccess;
    }());
    CIFTools.ParserSuccess = ParserSuccess;
// })(CIFTools || (CIFTools = {}));
/*
 * Copyright (c) 2016 - now David Sehnal, licensed under MIT License, See LICENSE file for more info.
 */
/*
 * Copyright (c) 2016 - now David Sehnal, licensed under MIT License, See LICENSE file for more info.
 */
/*
    On data representation of molecular files

    Consider an mmCIF file that stores a molecule with 100k atoms. For the sake of simplicity,
    lets ignore things like symmetry or assemblies, and assume, that the file only stores the
    _atom_site records. The atom site "table" in the standard mmCIF from PDB database currently
    has 26 columns.

    So the data looks something like this:

        loop_
        _atom_site.column1
        ....
        _atom_site.column26
        t1,1 .... t1,26
        t100000,1 .... t100000,26

    The straightforward way to represent this data in JavaScript is to have an array of objects
    with properties named "column1" ..., "column26":

        [{ column1: "t1,1", ..., column26: "t1,26" },
          ...,
         { column1: "t100000,1", ..., column26: "t100000,26" }]

    So in order to represent the atoms sites, we would need 100k objects and 2.6 million strings.
    Is this bad? well, sort of. It would not be so bad if this representation would be the only
    thing we need to keep in memory and/or the life time of the object was short. But usually
    we would need to keep the object around for the entire lifetime of the app. This alone
    adds a very non-significant overhead for the garbage collector (which increases the app's
    latency). What's worse is that we usually only need a fraction of this data, but this can
    vary application for application. For just 100k atoms, the overhead is not "that bad", but
    consider 1M atoms and suddenly we have a problem.

    The following data model shows an alternative way of storing molecular file s
    in memory that is very efficient, fast and introduces a very minimal overhead.

 */
// var CIFTools;
// (function (CIFTools) {
    var Text;
    (function (Text) {
        "use strict";
        var ShortStringPool;
        (function (ShortStringPool) {
            function create() { return Object.create(null); }
            ShortStringPool.create = create;
            function get(pool, str) {
                if (str.length > 6)
                    return str;
                var value = pool[str];
                if (value !== void 0)
                    return value;
                pool[str] = str;
                return str;
            }
            ShortStringPool.get = get;
        })(ShortStringPool || (ShortStringPool = {}));
        /**
         * Represents the input file.
         */
        var File = /** @class */ (function () {
            function File(data) {
                /**
                 * Data blocks inside the file. If no data block is present, a "default" one is created.
                 */
                this.dataBlocks = [];
                this.data = data;
            }
            File.prototype.toJSON = function () {
                return this.dataBlocks.map(function (b) { return b.toJSON(); });
            };
            return File;
        }());
        Text.File = File;
        /**
         * Represents a single data block.
         */
        var DataBlock = /** @class */ (function () {
            function DataBlock(data, header) {
                this.header = header;
                this.data = data;
                this.categoryList = [];
                this.additionalData = {};
                this.categoryMap = new Map();
            }
            Object.defineProperty(DataBlock.prototype, "categories", {
                /**
                 * Categories of the block.
                 * block.categories._atom_site / ['_atom_site']
                 */
                get: function () {
                    return this.categoryList;
                },
                enumerable: true,
                configurable: true
            });
            /**
             * Gets a category by its name.
             */
            DataBlock.prototype.getCategory = function (name) {
                return this.categoryMap.get(name);
            };
            /**
             * Adds a category.
             */
            DataBlock.prototype.addCategory = function (category) {
                this.categoryList[this.categoryList.length] = category;
                this.categoryMap.set(category.name, category);
            };
            DataBlock.prototype.toJSON = function () {
                return {
                    id: this.header,
                    categories: this.categoryList.map(function (c) { return c.toJSON(); }),
                    additionalData: this.additionalData
                };
            };
            return DataBlock;
        }());
        Text.DataBlock = DataBlock;
        /**
         * Represents a single CIF category.
         */
        var Category = /** @class */ (function () {
            function Category(data, name, startIndex, endIndex, columns, tokens, tokenCount) {
                this.name = name;
                this.tokens = tokens;
                this.data = data;
                this.startIndex = startIndex;
                this.endIndex = endIndex;
                this.columnCount = columns.length;
                this.rowCount = (tokenCount / columns.length) | 0;
                this.columnIndices = new Map();
                this.columnNameList = [];
                for (var i = 0; i < columns.length; i++) {
                    var colName = columns[i].substr(name.length + 1);
                    this.columnIndices.set(colName, i);
                    this.columnNameList.push(colName);
                }
            }
            Object.defineProperty(Category.prototype, "columnNames", {
                /**
                 * The array of columns.
                 */
                get: function () {
                    return this.columnNameList;
                },
                enumerable: true,
                configurable: true
            });
            /**
             * Get a column object that makes accessing data easier.
             * @returns undefined if the column isn't present, the Column object otherwise.
             */
            Category.prototype.getColumn = function (name) {
                var i = this.columnIndices.get(name);
                if (i !== void 0)
                    return new Column(this, this.data, name, i);
                return CIFTools.UndefinedColumn;
            };
            Category.prototype.toJSON = function () {
                var rows = [], data = this.data, tokens = this.tokens;
                var colNames = this.columnNameList;
                var strings = ShortStringPool.create();
                for (var i = 0; i < this.rowCount; i++) {
                    var item = {};
                    for (var j = 0; j < this.columnCount; j++) {
                        var tk = (i * this.columnCount + j) * 2;
                        item[colNames[j]] = ShortStringPool.get(strings, data.substring(tokens[tk], tokens[tk + 1]));
                    }
                    rows[i] = item;
                }
                return { name: this.name, columns: colNames, rows: rows };
            };
            return Category;
        }());
        Text.Category = Category;
        var fastParseInt = CIFTools.Utils.FastNumberParsers.parseInt;
        var fastParseFloat = CIFTools.Utils.FastNumberParsers.parseFloat;
        /**
         * Represents a single column of a CIF category.
         */
        var Column = /** @class */ (function () {
            function Column(category, data, name, index) {
                this.data = data;
                this.name = name;
                this.index = index;
                this.stringPool = ShortStringPool.create();
                this.isDefined = true;
                this.tokens = category.tokens;
                this.columnCount = category.columnCount;
            }
            /**
             * Returns the string value at given row.
             */
            Column.prototype.getString = function (row) {
                var i = (row * this.columnCount + this.index) * 2;
                var ret = ShortStringPool.get(this.stringPool, this.data.substring(this.tokens[i], this.tokens[i + 1]));
                if (ret === "." || ret === "?")
                    return null;
                return ret;
            };
            /**
             * Returns the integer value at given row.
             */
            Column.prototype.getInteger = function (row) {
                var i = (row * this.columnCount + this.index) * 2;
                return fastParseInt(this.data, this.tokens[i], this.tokens[i + 1]);
            };
            /**
             * Returns the float value at given row.
             */
            Column.prototype.getFloat = function (row) {
                var i = (row * this.columnCount + this.index) * 2;
                return fastParseFloat(this.data, this.tokens[i], this.tokens[i + 1]);
            };
            /**
             * Returns true if the token has the specified string value.
             */
            Column.prototype.stringEquals = function (row, value) {
                var aIndex = (row * this.columnCount + this.index) * 2, s = this.tokens[aIndex], len = value.length;
                if (len !== this.tokens[aIndex + 1] - s)
                    return false;
                for (var i = 0; i < len; i++) {
                    if (this.data.charCodeAt(i + s) !== value.charCodeAt(i))
                        return false;
                }
                return true;
            };
            /**
             * Determines if values at the given rows are equal.
             */
            Column.prototype.areValuesEqual = function (rowA, rowB) {
                var aIndex = (rowA * this.columnCount + this.index) * 2, bIndex = (rowB * this.columnCount + this.index) * 2;
                var aS = this.tokens[aIndex], bS = this.tokens[bIndex], len = this.tokens[aIndex + 1] - aS;
                if (len !== this.tokens[bIndex + 1] - bS)
                    return false;
                for (var i = 0; i < len; i++) {
                    if (this.data.charCodeAt(i + aS) !== this.data.charCodeAt(i + bS)) {
                        return false;
                    }
                }
                return true;
            };
            /**
             * Returns true if the value is not defined (. or ? token).
             */
            Column.prototype.getValuePresence = function (row) {
                var index = row * this.columnCount + this.index;
                var s = this.tokens[2 * index];
                if (this.tokens[2 * index + 1] - s !== 1)
                    return 0 /* Present */;
                var v = this.data.charCodeAt(s);
                if (v === 46 /* . */)
                    return 1 /* NotSpecified */;
                if (v === 63 /* ? */)
                    return 2 /* Unknown */;
                return 0 /* Present */;
            };
            return Column;
        }());
        Text.Column = Column;
    })(Text = CIFTools.Text || (CIFTools.Text = {}));
// })(CIFTools || (CIFTools = {}));
/*
 * Copyright (c) 2016 - now David Sehnal, licensed under MIT License, See LICENSE file for more info.
 */
// var CIFTools;
// (function (CIFTools) {
//     var Text;
    (function (Text) {
        "use strict";
        var TokenIndexBuilder;
        (function (TokenIndexBuilder) {
            function resize(builder) {
                // scale the size using golden ratio, because why not.
                var newBuffer = new Int32Array((1.61 * builder.tokens.length) | 0);
                newBuffer.set(builder.tokens);
                builder.tokens = newBuffer;
                builder.tokensLenMinus2 = (newBuffer.length - 2) | 0;
            }
            function addToken(builder, start, end) {
                if (builder.count >= builder.tokensLenMinus2) {
                    resize(builder);
                }
                builder.tokens[builder.count++] = start;
                builder.tokens[builder.count++] = end;
            }
            TokenIndexBuilder.addToken = addToken;
            function create(size) {
                return {
                    tokensLenMinus2: (size - 2) | 0,
                    count: 0,
                    tokens: new Int32Array(size)
                };
            }
            TokenIndexBuilder.create = create;
        })(TokenIndexBuilder || (TokenIndexBuilder = {}));
        /**
         * Eat everything until a whitespace/newline occurs.
         */
        function eatValue(state) {
            while (state.position < state.length) {
                switch (state.data.charCodeAt(state.position)) {
                    case 9: // \t
                    case 10: // \n
                    case 13: // \r
                    case 32: // ' '
                        state.currentTokenEnd = state.position;
                        return;
                    default:
                        ++state.position;
                        break;
                }
            }
            state.currentTokenEnd = state.position;
        }
        /**
         * Eats an escaped values. Handles the "degenerate" cases as well.
         *
         * "Degenerate" cases:
         * - 'xx'x' => xx'x
         * - 'xxxNEWLINE => 'xxx
         *
         */
        function eatEscaped(state, esc) {
            var next, c;
            ++state.position;
            while (state.position < state.length) {
                c = state.data.charCodeAt(state.position);
                if (c === esc) {
                    next = state.data.charCodeAt(state.position + 1);
                    switch (next) {
                        case 9: // \t
                        case 10: // \n
                        case 13: // \r
                        case 32: // ' '
                            // get rid of the quotes.
                            state.currentTokenStart++;
                            state.currentTokenEnd = state.position;
                            state.isEscaped = true;
                            ++state.position;
                            return;
                        default:
                            if (next === void 0) { // = "end of stream"
                                // get rid of the quotes.
                                state.currentTokenStart++;
                                state.currentTokenEnd = state.position;
                                state.isEscaped = true;
                                ++state.position;
                                return;
                            }
                            ++state.position;
                            break;
                    }
                }
                else {
                    // handle 'xxxNEWLINE => 'xxx
                    if (c === 10 || c === 13) {
                        state.currentTokenEnd = state.position;
                        return;
                    }
                    ++state.position;
                }
            }
            state.currentTokenEnd = state.position;
        }
        /**
         * Eats a multiline token of the form NL;....NL;
         */
        function eatMultiline(state) {
            var prev = 59, pos = state.position + 1, c;
            while (pos < state.length) {
                c = state.data.charCodeAt(pos);
                if (c === 59 && (prev === 10 || prev === 13)) { // ;, \n \r
                    state.position = pos + 1;
                    // get rid of the ;
                    state.currentTokenStart++;
                    // remove trailing newlines
                    pos--;
                    c = state.data.charCodeAt(pos);
                    while (c === 10 || c === 13) {
                        pos--;
                        c = state.data.charCodeAt(pos);
                    }
                    state.currentTokenEnd = pos + 1;
                    state.isEscaped = true;
                    return;
                }
                else {
                    // handle line numbers
                    if (c === 13) { // \r
                        state.currentLineNumber++;
                    }
                    else if (c === 10 && prev !== 13) { // \r\n
                        state.currentLineNumber++;
                    }
                    prev = c;
                    ++pos;
                }
            }
            state.position = pos;
            return prev;
        }
        /**
         * Skips until \n or \r occurs -- therefore the newlines get handled by the "skipWhitespace" function.
         */
        function skipCommentLine(state) {
            while (state.position < state.length) {
                var c = state.data.charCodeAt(state.position);
                if (c === 10 || c === 13) {
                    return;
                }
                ++state.position;
            }
        }
        /**
         * Skips all the whitespace - space, tab, newline, CR
         * Handles incrementing line count.
         */
        function skipWhitespace(state) {
            var prev = 10;
            while (state.position < state.length) {
                var c = state.data.charCodeAt(state.position);
                switch (c) {
                    case 9: // '\t'
                    case 32: // ' '
                        prev = c;
                        ++state.position;
                        break;
                    case 10: // \n
                        // handle \r\n
                        if (prev !== 13) {
                            ++state.currentLineNumber;
                        }
                        prev = c;
                        ++state.position;
                        break;
                    case 13: // \r
                        prev = c;
                        ++state.position;
                        ++state.currentLineNumber;
                        break;
                    default:
                        return prev;
                }
            }
            return prev;
        }
        function isData(state) {
            // here we already assume the 5th char is _ and that the length >= 5
            // d/D
            var c = state.data.charCodeAt(state.currentTokenStart);
            if (c !== 68 && c !== 100)
                return false;
            // a/A
            c = state.data.charCodeAt(state.currentTokenStart + 1);
            if (c !== 65 && c !== 97)
                return false;
            // t/t
            c = state.data.charCodeAt(state.currentTokenStart + 2);
            if (c !== 84 && c !== 116)
                return false;
            // a/A
            c = state.data.charCodeAt(state.currentTokenStart + 3);
            if (c !== 65 && c !== 97)
                return false;
            return true;
        }
        function isSave(state) {
            // here we already assume the 5th char is _ and that the length >= 5
            // s/S
            var c = state.data.charCodeAt(state.currentTokenStart);
            if (c !== 83 && c !== 115)
                return false;
            // a/A
            c = state.data.charCodeAt(state.currentTokenStart + 1);
            if (c !== 65 && c !== 97)
                return false;
            // v/V
            c = state.data.charCodeAt(state.currentTokenStart + 2);
            if (c !== 86 && c !== 118)
                return false;
            // e/E
            c = state.data.charCodeAt(state.currentTokenStart + 3);
            if (c !== 69 && c !== 101)
                return false;
            return true;
        }
        function isLoop(state) {
            // here we already assume the 5th char is _ and that the length >= 5
            if (state.currentTokenEnd - state.currentTokenStart !== 5)
                return false;
            // l/L
            var c = state.data.charCodeAt(state.currentTokenStart);
            if (c !== 76 && c !== 108)
                return false;
            // o/O
            c = state.data.charCodeAt(state.currentTokenStart + 1);
            if (c !== 79 && c !== 111)
                return false;
            // o/O
            c = state.data.charCodeAt(state.currentTokenStart + 2);
            if (c !== 79 && c !== 111)
                return false;
            // p/P
            c = state.data.charCodeAt(state.currentTokenStart + 3);
            if (c !== 80 && c !== 112)
                return false;
            return true;
        }
        /**
         * Checks if the current token shares the namespace with string at <start,end).
         */
        function isNamespace(state, start, end) {
            var i, nsLen = end - start, offset = state.currentTokenStart - start, tokenLen = state.currentTokenEnd - state.currentTokenStart;
            if (tokenLen < nsLen)
                return false;
            for (i = start; i < end; ++i) {
                if (state.data.charCodeAt(i) !== state.data.charCodeAt(i + offset))
                    return false;
            }
            if (nsLen === tokenLen)
                return true;
            if (state.data.charCodeAt(i + offset) === 46) { // .
                return true;
            }
            return false;
        }
        /**
         * Returns the index of '.' in the current token. If no '.' is present, returns currentTokenEnd.
         */
        function getNamespaceEnd(state) {
            var i;
            for (i = state.currentTokenStart; i < state.currentTokenEnd; ++i) {
                if (state.data.charCodeAt(i) === 46)
                    return i;
            }
            return i;
        }
        /**
         * Get the namespace string. endIndex is obtained by the getNamespaceEnd() function.
         */
        function getNamespace(state, endIndex) {
            return state.data.substring(state.currentTokenStart, endIndex);
        }
        /**
         * String representation of the current token.
         */
        function getTokenString(state) {
            return state.data.substring(state.currentTokenStart, state.currentTokenEnd);
        }
        /**
         * Move to the next token.
         */
        function moveNextInternal(state) {
            var prev = skipWhitespace(state);
            if (state.position >= state.length) {
                state.currentTokenType = 6 /* End */;
                return;
            }
            state.currentTokenStart = state.position;
            state.currentTokenEnd = state.position;
            state.isEscaped = false;
            var c = state.data.charCodeAt(state.position);
            switch (c) {
                case 35: // #, comment
                    skipCommentLine(state);
                    state.currentTokenType = 5 /* Comment */;
                    break;
                case 34: // ", escaped value
                case 39: // ', escaped value
                    eatEscaped(state, c);
                    state.currentTokenType = 3 /* Value */;
                    break;
                case 59: // ;, possible multiline value
                    // multiline value must start at the beginning of the line.
                    if (prev === 10 || prev === 13) { // /n or /r
                        eatMultiline(state);
                    }
                    else {
                        eatValue(state);
                    }
                    state.currentTokenType = 3 /* Value */;
                    break;
                default:
                    eatValue(state);
                    // escaped is always Value
                    if (state.isEscaped) {
                        state.currentTokenType = 3 /* Value */;
                        // _ always means column name
                    }
                    else if (state.data.charCodeAt(state.currentTokenStart) === 95) { // _
                        state.currentTokenType = 4 /* ColumnName */;
                        // 5th char needs to be _ for data_ or loop_
                    }
                    else if (state.currentTokenEnd - state.currentTokenStart >= 5 && state.data.charCodeAt(state.currentTokenStart + 4) === 95) {
                        if (isData(state))
                            state.currentTokenType = 0 /* Data */;
                        else if (isSave(state))
                            state.currentTokenType = 1 /* Save */;
                        else if (isLoop(state))
                            state.currentTokenType = 2 /* Loop */;
                        else
                            state.currentTokenType = 3 /* Value */;
                        // all other tests failed, we are at Value token.
                    }
                    else {
                        state.currentTokenType = 3 /* Value */;
                    }
                    break;
            }
        }
        /**
         * Moves to the next non-comment token.
         */
        function moveNext(state) {
            moveNextInternal(state);
            while (state.currentTokenType === 5 /* Comment */)
                moveNextInternal(state);
        }
        function createTokenizer(data) {
            return {
                data: data,
                length: data.length,
                position: 0,
                currentTokenStart: 0,
                currentTokenEnd: 0,
                currentTokenType: 6 /* End */,
                currentLineNumber: 1,
                isEscaped: false
            };
        }
        /**
         * Reads a category containing a single row.
         */
        function handleSingle(tokenizer, block) {
            var nsStart = tokenizer.currentTokenStart, nsEnd = getNamespaceEnd(tokenizer), name = getNamespace(tokenizer, nsEnd), column, columns = [], tokens = TokenIndexBuilder.create(512), tokenCount = 0, readingNames = true;
            while (readingNames) {
                if (tokenizer.currentTokenType !== 4 /* ColumnName */ || !isNamespace(tokenizer, nsStart, nsEnd)) {
                    readingNames = false;
                    break;
                }
                column = getTokenString(tokenizer);
                moveNext(tokenizer);
                if (tokenizer.currentTokenType !== 3 /* Value */) {
                    return {
                        hasError: true,
                        errorLine: tokenizer.currentLineNumber,
                        errorMessage: "Expected value."
                    };
                }
                columns[columns.length] = column;
                TokenIndexBuilder.addToken(tokens, tokenizer.currentTokenStart, tokenizer.currentTokenEnd);
                tokenCount++;
                moveNext(tokenizer);
            }
            block.addCategory(new Text.Category(block.data, name, nsStart, tokenizer.currentTokenStart, columns, tokens.tokens, tokenCount));
            return {
                hasError: false,
                errorLine: 0,
                errorMessage: ""
            };
        }
        /**
         * Reads a loop.
         */
        function handleLoop(tokenizer, block) {
            var start = tokenizer.currentTokenStart, loopLine = tokenizer.currentLineNumber;
            moveNext(tokenizer);
            var name = getNamespace(tokenizer, getNamespaceEnd(tokenizer)), columns = [], tokens = TokenIndexBuilder.create(name === "_atom_site" ? (block.data.length / 1.85) | 0 : 1024), tokenCount = 0;
            while (tokenizer.currentTokenType === 4 /* ColumnName */) {
                columns[columns.length] = getTokenString(tokenizer);
                moveNext(tokenizer);
            }
            while (tokenizer.currentTokenType === 3 /* Value */) {
                TokenIndexBuilder.addToken(tokens, tokenizer.currentTokenStart, tokenizer.currentTokenEnd);
                tokenCount++;
                moveNext(tokenizer);
            }
            if (tokenCount % columns.length !== 0) {
                return {
                    hasError: true,
                    errorLine: tokenizer.currentLineNumber,
                    errorMessage: "The number of values for loop starting at line " + loopLine + " is not a multiple of the number of columns."
                };
            }
            block.addCategory(new Text.Category(block.data, name, start, tokenizer.currentTokenStart, columns, tokens.tokens, tokenCount));
            return {
                hasError: false,
                errorLine: 0,
                errorMessage: ""
            };
        }
        /**
         * Creates an error result.
         */
        function error(line, message) {
            return CIFTools.ParserResult.error(message, line);
        }
        /**
         * Creates a data result.
         */
        function result(data) {
            return CIFTools.ParserResult.success(data);
        }
        /**
         * Parses an mmCIF file.
         *
         * @returns CifParserResult wrapper of the result.
         */
        function parseInternal(data) {
            var tokenizer = createTokenizer(data), cat, id, file = new Text.File(data), block = new Text.DataBlock(data, "default"), saveFrame = new Text.DataBlock(data, "empty"), inSaveFrame = false, blockSaveFrames;
            moveNext(tokenizer);
            while (tokenizer.currentTokenType !== 6 /* End */) {
                var token = tokenizer.currentTokenType;
                // Data block
                if (token === 0 /* Data */) {
                    if (inSaveFrame) {
                        return error(tokenizer.currentLineNumber, "Unexpected data block inside a save frame.");
                    }
                    if (block.categories.length > 0) {
                        file.dataBlocks.push(block);
                    }
                    block = new Text.DataBlock(data, data.substring(tokenizer.currentTokenStart + 5, tokenizer.currentTokenEnd));
                    moveNext(tokenizer);
                    // Save frame
                }
                else if (token === 1 /* Save */) {
                    id = data.substring(tokenizer.currentTokenStart + 5, tokenizer.currentTokenEnd);
                    if (id.length === 0) {
                        if (saveFrame.categories.length > 0) {
                            blockSaveFrames = block.additionalData["saveFrames"];
                            if (!blockSaveFrames) {
                                blockSaveFrames = [];
                                block.additionalData["saveFrames"] = blockSaveFrames;
                            }
                            blockSaveFrames[blockSaveFrames.length] = saveFrame;
                        }
                        inSaveFrame = false;
                    }
                    else {
                        if (inSaveFrame) {
                            return error(tokenizer.currentLineNumber, "Save frames cannot be nested.");
                        }
                        inSaveFrame = true;
                        saveFrame = new Text.DataBlock(data, id);
                    }
                    moveNext(tokenizer);
                    // Loop
                }
                else if (token === 2 /* Loop */) {
                    cat = handleLoop(tokenizer, inSaveFrame ? saveFrame : block);
                    if (cat.hasError) {
                        return error(cat.errorLine, cat.errorMessage);
                    }
                    // Single row
                }
                else if (token === 4 /* ColumnName */) {
                    cat = handleSingle(tokenizer, inSaveFrame ? saveFrame : block);
                    if (cat.hasError) {
                        return error(cat.errorLine, cat.errorMessage);
                    }
                    // Out of options
                }
                else {
                    return error(tokenizer.currentLineNumber, "Unexpected token. Expected data_, loop_, or data name.");
                }
            }
            // Check if the latest save frame was closed.
            if (inSaveFrame) {
                return error(tokenizer.currentLineNumber, "Unfinished save frame (`" + saveFrame.header + "`).");
            }
            if (block.categories.length > 0) {
                file.dataBlocks.push(block);
            }
            return result(file);
        }
        function parse(data) {
            return parseInternal(data);
        }
        Text.parse = parse;
    })(Text = CIFTools.Text || (CIFTools.Text = {}));
// })(CIFTools || (CIFTools = {}));
/*
 * Copyright (c) 2016 - now David Sehnal, licensed under MIT License, See LICENSE file for more info.
 */
// var CIFTools;
// (function (CIFTools) {
//     var Text;
    (function (Text) {
        "use strict";
        var StringWriter = CIFTools.Utils.StringWriter;
        var Writer = /** @class */ (function () {
            function Writer() {
                this.writer = StringWriter.create();
                this.encoded = false;
                this.dataBlockCreated = false;
            }
            Writer.prototype.startDataBlock = function (header) {
                this.dataBlockCreated = true;
                StringWriter.write(this.writer, "data_" + (header || '').replace(/[ \n\t]/g, '').toUpperCase() + "\n#\n");
            };
            Writer.prototype.writeCategory = function (category, contexts) {
                if (this.encoded) {
                    throw new Error('The writer contents have already been encoded, no more writing.');
                }
                if (!this.dataBlockCreated) {
                    throw new Error('No data block created.');
                }
                var src = !contexts || !contexts.length ? [category(void 0)] : contexts.map(function (c) { return category(c); });
                var data = src.filter(function (c) { return c && c.count > 0; });
                if (!data.length)
                    return;
                var count = data.reduce(function (a, c) { return a + (c.count === void 0 ? 1 : c.count); }, 0);
                if (!count)
                    return;
                else if (count === 1) {
                    writeCifSingleRecord(data[0], this.writer);
                }
                else {
                    writeCifLoop(data, this.writer);
                }
            };
            Writer.prototype.encode = function () {
                this.encoded = true;
            };
            Writer.prototype.flush = function (stream) {
                StringWriter.writeTo(this.writer, stream);
            };
            return Writer;
        }());
        Text.Writer = Writer;
        function isMultiline(value) {
            return !!value && value.indexOf('\n') >= 0;
        }
        function writeCifSingleRecord(category, writer) {
            var fields = category.desc.fields;
            var data = category.data;
            var width = fields.reduce(function (w, s) { return Math.max(w, s.name.length); }, 0) + category.desc.name.length + 5;
            for (var _i = 0, fields_1 = fields; _i < fields_1.length; _i++) {
                var f = fields_1[_i];
                StringWriter.writePadRight(writer, category.desc.name + "." + f.name, width);
                var presence = f.presence;
                var p = presence ? presence(data, 0) : 0 /* Present */;
                if (p !== 0 /* Present */) {
                    if (p === 1 /* NotSpecified */)
                        writeNotSpecified(writer);
                    else
                        writeUnknown(writer);
                }
                else {
                    var val = f.string(data, 0);
                    if (isMultiline(val)) {
                        writeMultiline(writer, val);
                        StringWriter.newline(writer);
                    }
                    else {
                        writeChecked(writer, val);
                    }
                }
                StringWriter.newline(writer);
            }
            StringWriter.write(writer, '#\n');
        }
        function writeCifLoop(categories, writer) {
            writeLine(writer, 'loop_');
            var first = categories[0];
            var fields = first.desc.fields;
            for (var _i = 0, fields_2 = fields; _i < fields_2.length; _i++) {
                var f = fields_2[_i];
                writeLine(writer, first.desc.name + "." + f.name);
            }
            for (var _a = 0, categories_1 = categories; _a < categories_1.length; _a++) {
                var category = categories_1[_a];
                var data = category.data;
                var count = category.count;
                for (var i = 0; i < count; i++) {
                    for (var _b = 0, fields_3 = fields; _b < fields_3.length; _b++) {
                        var f = fields_3[_b];
                        var presence = f.presence;
                        var p = presence ? presence(data, i) : 0 /* Present */;
                        if (p !== 0 /* Present */) {
                            if (p === 1 /* NotSpecified */)
                                writeNotSpecified(writer);
                            else
                                writeUnknown(writer);
                        }
                        else {
                            var val = f.string(data, i);
                            if (isMultiline(val)) {
                                writeMultiline(writer, val);
                                StringWriter.newline(writer);
                            }
                            else {
                                writeChecked(writer, val);
                            }
                        }
                    }
                    StringWriter.newline(writer);
                }
            }
            StringWriter.write(writer, '#\n');
        }
        function writeLine(writer, val) {
            StringWriter.write(writer, val);
            StringWriter.newline(writer);
        }
        function writeInteger(writer, val) {
            StringWriter.writeSafe(writer, '' + val + ' ');
        }
        /**
            * eg writeFloat(123.2123, 100) -- 2 decim
            */
        function writeFloat(writer, val, precisionMultiplier) {
            StringWriter.writeSafe(writer, '' + Math.round(precisionMultiplier * val) / precisionMultiplier + ' ');
        }
        /**
            * Writes '. '
            */
        function writeNotSpecified(writer) {
            StringWriter.writeSafe(writer, '. ');
        }
        /**
            * Writes '? '
            */
        function writeUnknown(writer) {
            StringWriter.writeSafe(writer, '? ');
        }
        function writeChecked(writer, val) {
            if (!val) {
                StringWriter.writeSafe(writer, '. ');
                return;
            }
            var escape = false, escapeCharStart = '\'', escapeCharEnd = '\' ';
            var hasWhitespace = false;
            var hasSingle = false;
            var hasDouble = false;
            for (var i = 0, _l = val.length - 1; i < _l; i++) {
                var c = val.charCodeAt(i);
                switch (c) {
                    case 9:
                        hasWhitespace = true;
                        break; // \t
                    case 10: // \n
                        StringWriter.writeSafe(writer, '\n;' + val);
                        StringWriter.writeSafe(writer, '\n; ');
                        return;
                    case 32:
                        hasWhitespace = true;
                        break; // ' '
                    case 34: // "
                        if (hasSingle) {
                            StringWriter.writeSafe(writer, '\n;' + val);
                            StringWriter.writeSafe(writer, '\n; ');
                            return;
                        }
                        hasDouble = true;
                        escape = true;
                        escapeCharStart = '\'';
                        escapeCharEnd = '\' ';
                        break;
                    case 39: // '
                        if (hasDouble) {
                            StringWriter.writeSafe(writer, '\n;' + val);
                            StringWriter.writeSafe(writer, '\n; ');
                            return;
                        }
                        escape = true;
                        hasSingle = true;
                        escapeCharStart = '"';
                        escapeCharEnd = '" ';
                        break;
                }
            }
            var fst = val.charCodeAt(0);
            if (!escape && (fst === 35 /* # */ || fst === 36 /* $ */ || fst === 59 /* ; */ || fst === 91 /* [ */ || fst === 93 /* ] */ || hasWhitespace)) {
                escapeCharStart = '\'';
                escapeCharEnd = '\' ';
                escape = true;
            }
            if (escape) {
                StringWriter.writeSafe(writer, escapeCharStart + val + escapeCharEnd);
            }
            else {
                StringWriter.write(writer, val);
                StringWriter.writeSafe(writer, ' ');
            }
        }
        function writeMultiline(writer, val) {
            StringWriter.writeSafe(writer, '\n;' + val);
            StringWriter.writeSafe(writer, '\n; ');
        }
        function writeToken(writer, data, start, end) {
            var escape = false, escapeCharStart = '\'', escapeCharEnd = '\' ';
            for (var i = start; i < end - 1; i++) {
                var c = data.charCodeAt(i);
                switch (c) {
                    case 10: // \n
                        StringWriter.writeSafe(writer, '\n;' + data.substring(start, end));
                        StringWriter.writeSafe(writer, '\n; ');
                        return;
                    case 34: // "
                        escape = true;
                        escapeCharStart = '\'';
                        escapeCharEnd = '\' ';
                        break;
                    case 39: // '
                        escape = true;
                        escapeCharStart = '"';
                        escapeCharEnd = '" ';
                        break;
                }
            }
            if (!escape && data.charCodeAt(start) === 59 /* ; */) {
                escapeCharStart = '\'';
                escapeCharEnd = '\' ';
                escape = true;
            }
            if (escape) {
                StringWriter.writeSafe(writer, escapeCharStart + data.substring(start, end));
                StringWriter.writeSafe(writer, escapeCharStart);
            }
            else {
                StringWriter.write(writer, data.substring(start, end));
                StringWriter.writeSafe(writer, ' ');
            }
        }
    })(Text = CIFTools.Text || (CIFTools.Text = {}));
// })(CIFTools || (CIFTools = {}));
/*
 * Copyright (c) 2016 - now David Sehnal, licensed under MIT License, See LICENSE file for more info.
 */
// var CIFTools;
// (function (CIFTools) {
    var Binary;
    (function (Binary) {
        var MessagePack;
        (function (MessagePack) {
            /*
             * Adapted from https://github.com/rcsb/mmtf-javascript
             * by Alexander Rose <alexander.rose@weirdbyte.de>, MIT License, Copyright (c) 2016
             */
            /**
             * decode all key-value pairs of a map into an object
             * @param  {Integer} length - number of key-value pairs
             * @return {Object} decoded map
             */
            function map(state, length) {
                var value = {};
                for (var i = 0; i < length; i++) {
                    var key = parse(state);
                    value[key] = parse(state);
                }
                return value;
            }
            /**
             * decode binary array
             * @param  {Integer} length - number of elements in the array
             * @return {Uint8Array} decoded array
             */
            function bin(state, length) {
                // This approach to binary parsing wastes a bit of memory to trade for speed compared to:
                //
                //   let value = buffer.subarray(offset, offset + length); //new Uint8Array(buffer.buffer, offset, length);
                // 
                // It turns out that using the view created by subarray probably uses DataView
                // in the background, which causes the element access to be several times slower
                // than creating the new byte array.
                var value = new Uint8Array(length);
                var o = state.offset;
                for (var i = 0; i < length; i++)
                    value[i] = state.buffer[i + o];
                state.offset += length;
                return value;
            }
            /**
             * decode string
             * @param  {Integer} length - number string characters
             * @return {String} decoded string
             */
            function str(state, length) {
                var value = MessagePack.utf8Read(state.buffer, state.offset, length);
                state.offset += length;
                return value;
            }
            /**
                 * decode array
                 * @param  {Integer} length - number of array elements
                 * @return {Array} decoded array
                 */
            function array(state, length) {
                var value = new Array(length);
                for (var i = 0; i < length; i++) {
                    value[i] = parse(state);
                }
                return value;
            }
            /**
             * recursively parse the MessagePack data
             * @return {Object|Array|String|Number|Boolean|null} decoded MessagePack data
             */
            function parse(state) {
                var type = state.buffer[state.offset];
                var value, length;
                // Positive FixInt
                if ((type & 0x80) === 0x00) {
                    state.offset++;
                    return type;
                }
                // FixMap
                if ((type & 0xf0) === 0x80) {
                    length = type & 0x0f;
                    state.offset++;
                    return map(state, length);
                }
                // FixArray
                if ((type & 0xf0) === 0x90) {
                    length = type & 0x0f;
                    state.offset++;
                    return array(state, length);
                }
                // FixStr
                if ((type & 0xe0) === 0xa0) {
                    length = type & 0x1f;
                    state.offset++;
                    return str(state, length);
                }
                // Negative FixInt
                if ((type & 0xe0) === 0xe0) {
                    value = state.dataView.getInt8(state.offset);
                    state.offset++;
                    return value;
                }
                switch (type) {
                    // nil
                    case 0xc0:
                        state.offset++;
                        return null;
                    // false
                    case 0xc2:
                        state.offset++;
                        return false;
                    // true
                    case 0xc3:
                        state.offset++;
                        return true;
                    // bin 8
                    case 0xc4:
                        length = state.dataView.getUint8(state.offset + 1);
                        state.offset += 2;
                        return bin(state, length);
                    // bin 16
                    case 0xc5:
                        length = state.dataView.getUint16(state.offset + 1);
                        state.offset += 3;
                        return bin(state, length);
                    // bin 32
                    case 0xc6:
                        length = state.dataView.getUint32(state.offset + 1);
                        state.offset += 5;
                        return bin(state, length);
                    // float 32
                    case 0xca:
                        value = state.dataView.getFloat32(state.offset + 1);
                        state.offset += 5;
                        return value;
                    // float 64
                    case 0xcb:
                        value = state.dataView.getFloat64(state.offset + 1);
                        state.offset += 9;
                        return value;
                    // uint8
                    case 0xcc:
                        value = state.buffer[state.offset + 1];
                        state.offset += 2;
                        return value;
                    // uint 16
                    case 0xcd:
                        value = state.dataView.getUint16(state.offset + 1);
                        state.offset += 3;
                        return value;
                    // uint 32
                    case 0xce:
                        value = state.dataView.getUint32(state.offset + 1);
                        state.offset += 5;
                        return value;
                    // int 8
                    case 0xd0:
                        value = state.dataView.getInt8(state.offset + 1);
                        state.offset += 2;
                        return value;
                    // int 16
                    case 0xd1:
                        value = state.dataView.getInt16(state.offset + 1);
                        state.offset += 3;
                        return value;
                    // int 32
                    case 0xd2:
                        value = state.dataView.getInt32(state.offset + 1);
                        state.offset += 5;
                        return value;
                    // str 8
                    case 0xd9:
                        length = state.dataView.getUint8(state.offset + 1);
                        state.offset += 2;
                        return str(state, length);
                    // str 16
                    case 0xda:
                        length = state.dataView.getUint16(state.offset + 1);
                        state.offset += 3;
                        return str(state, length);
                    // str 32
                    case 0xdb:
                        length = state.dataView.getUint32(state.offset + 1);
                        state.offset += 5;
                        return str(state, length);
                    // array 16
                    case 0xdc:
                        length = state.dataView.getUint16(state.offset + 1);
                        state.offset += 3;
                        return array(state, length);
                    // array 32
                    case 0xdd:
                        length = state.dataView.getUint32(state.offset + 1);
                        state.offset += 5;
                        return array(state, length);
                    // map 16:
                    case 0xde:
                        length = state.dataView.getUint16(state.offset + 1);
                        state.offset += 3;
                        return map(state, length);
                    // map 32
                    case 0xdf:
                        length = state.dataView.getUint32(state.offset + 1);
                        state.offset += 5;
                        return map(state, length);
                }
                throw new Error("Unknown type 0x" + type.toString(16));
            }
            function decode(buffer) {
                return parse({
                    buffer: buffer,
                    offset: 0,
                    dataView: new DataView(buffer.buffer)
                });
            }
            MessagePack.decode = decode;
        })(MessagePack = Binary.MessagePack || (Binary.MessagePack = {}));
    })(Binary = CIFTools.Binary || (CIFTools.Binary = {}));
// })(CIFTools || (CIFTools = {}));
/*
 * Copyright (c) 2016 - now David Sehnal, licensed under MIT License, See LICENSE file for more info.
 */
// var CIFTools;
// (function (CIFTools) {
//     var Binary;
    (function (Binary) {
        var MessagePack;
        (function (MessagePack) {
            /*
             * Adapted from https://github.com/rcsb/mmtf-javascript
             * by Alexander Rose <alexander.rose@weirdbyte.de>, MIT License, Copyright (c) 2016
             */
            function encode(value) {
                var buffer = new ArrayBuffer(encodedSize(value));
                var view = new DataView(buffer);
                var bytes = new Uint8Array(buffer);
                encodeInternal(value, view, bytes, 0);
                return bytes;
            }
            MessagePack.encode = encode;
            function encodedSize(value) {
                var type = typeof value;
                // Raw Bytes
                if (type === "string") {
                    var length_1 = MessagePack.utf8ByteCount(value);
                    if (length_1 < 0x20) {
                        return 1 + length_1;
                    }
                    if (length_1 < 0x100) {
                        return 2 + length_1;
                    }
                    if (length_1 < 0x10000) {
                        return 3 + length_1;
                    }
                    if (length_1 < 0x100000000) {
                        return 5 + length_1;
                    }
                }
                if (value instanceof Uint8Array) {
                    var length_2 = value.byteLength;
                    if (length_2 < 0x100) {
                        return 2 + length_2;
                    }
                    if (length_2 < 0x10000) {
                        return 3 + length_2;
                    }
                    if (length_2 < 0x100000000) {
                        return 5 + length_2;
                    }
                }
                if (type === "number") {
                    // Floating Point
                    // double
                    if (Math.floor(value) !== value)
                        return 9;
                    // Integers
                    if (value >= 0) {
                        // positive fixnum
                        if (value < 0x80)
                            return 1;
                        // uint 8
                        if (value < 0x100)
                            return 2;
                        // uint 16
                        if (value < 0x10000)
                            return 3;
                        // uint 32
                        if (value < 0x100000000)
                            return 5;
                        throw new Error("Number too big 0x" + value.toString(16));
                    }
                    // negative fixnum
                    if (value >= -0x20)
                        return 1;
                    // int 8
                    if (value >= -0x80)
                        return 2;
                    // int 16
                    if (value >= -0x8000)
                        return 3;
                    // int 32
                    if (value >= -0x80000000)
                        return 5;
                    throw new Error("Number too small -0x" + value.toString(16).substr(1));
                }
                // Boolean, null
                if (type === "boolean" || value === null || value === void 0)
                    return 1;
                // Container Types
                if (type === "object") {
                    var length_3, size = 0;
                    if (Array.isArray(value)) {
                        length_3 = value.length;
                        for (var i = 0; i < length_3; i++) {
                            size += encodedSize(value[i]);
                        }
                    }
                    else {
                        var keys = Object.keys(value);
                        length_3 = keys.length;
                        for (var i = 0; i < length_3; i++) {
                            var key = keys[i];
                            size += encodedSize(key) + encodedSize(value[key]);
                        }
                    }
                    if (length_3 < 0x10) {
                        return 1 + size;
                    }
                    if (length_3 < 0x10000) {
                        return 3 + size;
                    }
                    if (length_3 < 0x100000000) {
                        return 5 + size;
                    }
                    throw new Error("Array or object too long 0x" + length_3.toString(16));
                }
                throw new Error("Unknown type " + type);
            }
            function encodeInternal(value, view, bytes, offset) {
                var type = typeof value;
                // Strings Bytes
                if (type === "string") {
                    var length_4 = MessagePack.utf8ByteCount(value);
                    // fix str
                    if (length_4 < 0x20) {
                        view.setUint8(offset, length_4 | 0xa0);
                        MessagePack.utf8Write(bytes, offset + 1, value);
                        return 1 + length_4;
                    }
                    // str 8
                    if (length_4 < 0x100) {
                        view.setUint8(offset, 0xd9);
                        view.setUint8(offset + 1, length_4);
                        MessagePack.utf8Write(bytes, offset + 2, value);
                        return 2 + length_4;
                    }
                    // str 16
                    if (length_4 < 0x10000) {
                        view.setUint8(offset, 0xda);
                        view.setUint16(offset + 1, length_4);
                        MessagePack.utf8Write(bytes, offset + 3, value);
                        return 3 + length_4;
                    }
                    // str 32
                    if (length_4 < 0x100000000) {
                        view.setUint8(offset, 0xdb);
                        view.setUint32(offset + 1, length_4);
                        MessagePack.utf8Write(bytes, offset + 5, value);
                        return 5 + length_4;
                    }
                }
                if (value instanceof Uint8Array) {
                    var length_5 = value.byteLength;
                    var bytes_1 = new Uint8Array(view.buffer);
                    // bin 8
                    if (length_5 < 0x100) {
                        view.setUint8(offset, 0xc4);
                        view.setUint8(offset + 1, length_5);
                        bytes_1.set(value, offset + 2);
                        return 2 + length_5;
                    }
                    // bin 16
                    if (length_5 < 0x10000) {
                        view.setUint8(offset, 0xc5);
                        view.setUint16(offset + 1, length_5);
                        bytes_1.set(value, offset + 3);
                        return 3 + length_5;
                    }
                    // bin 32
                    if (length_5 < 0x100000000) {
                        view.setUint8(offset, 0xc6);
                        view.setUint32(offset + 1, length_5);
                        bytes_1.set(value, offset + 5);
                        return 5 + length_5;
                    }
                }
                if (type === "number") {
                    if (!isFinite(value)) {
                        throw new Error("Number not finite: " + value);
                    }
                    // Floating point
                    if (Math.floor(value) !== value) {
                        view.setUint8(offset, 0xcb);
                        view.setFloat64(offset + 1, value);
                        return 9;
                    }
                    // Integers
                    if (value >= 0) {
                        // positive fixnum
                        if (value < 0x80) {
                            view.setUint8(offset, value);
                            return 1;
                        }
                        // uint 8
                        if (value < 0x100) {
                            view.setUint8(offset, 0xcc);
                            view.setUint8(offset + 1, value);
                            return 2;
                        }
                        // uint 16
                        if (value < 0x10000) {
                            view.setUint8(offset, 0xcd);
                            view.setUint16(offset + 1, value);
                            return 3;
                        }
                        // uint 32
                        if (value < 0x100000000) {
                            view.setUint8(offset, 0xce);
                            view.setUint32(offset + 1, value);
                            return 5;
                        }
                        throw new Error("Number too big 0x" + value.toString(16));
                    }
                    // negative fixnum
                    if (value >= -0x20) {
                        view.setInt8(offset, value);
                        return 1;
                    }
                    // int 8
                    if (value >= -0x80) {
                        view.setUint8(offset, 0xd0);
                        view.setInt8(offset + 1, value);
                        return 2;
                    }
                    // int 16
                    if (value >= -0x8000) {
                        view.setUint8(offset, 0xd1);
                        view.setInt16(offset + 1, value);
                        return 3;
                    }
                    // int 32
                    if (value >= -0x80000000) {
                        view.setUint8(offset, 0xd2);
                        view.setInt32(offset + 1, value);
                        return 5;
                    }
                    throw new Error("Number too small -0x" + (-value).toString(16).substr(1));
                }
                // null
                if (value === null || value === undefined) {
                    view.setUint8(offset, 0xc0);
                    return 1;
                }
                // Boolean
                if (type === "boolean") {
                    view.setUint8(offset, value ? 0xc3 : 0xc2);
                    return 1;
                }
                // Container Types
                if (type === "object") {
                    var length_6, size = 0;
                    var isArray = Array.isArray(value);
                    var keys = void 0;
                    if (isArray) {
                        length_6 = value.length;
                    }
                    else {
                        keys = Object.keys(value);
                        length_6 = keys.length;
                    }
                    if (length_6 < 0x10) {
                        view.setUint8(offset, length_6 | (isArray ? 0x90 : 0x80));
                        size = 1;
                    }
                    else if (length_6 < 0x10000) {
                        view.setUint8(offset, isArray ? 0xdc : 0xde);
                        view.setUint16(offset + 1, length_6);
                        size = 3;
                    }
                    else if (length_6 < 0x100000000) {
                        view.setUint8(offset, isArray ? 0xdd : 0xdf);
                        view.setUint32(offset + 1, length_6);
                        size = 5;
                    }
                    if (isArray) {
                        for (var i = 0; i < length_6; i++) {
                            size += encodeInternal(value[i], view, bytes, offset + size);
                        }
                    }
                    else {
                        for (var _i = 0, _a = keys; _i < _a.length; _i++) {
                            var key = _a[_i];
                            size += encodeInternal(key, view, bytes, offset + size);
                            size += encodeInternal(value[key], view, bytes, offset + size);
                        }
                    }
                    return size;
                }
                throw new Error("Unknown type " + type);
            }
        })(MessagePack = Binary.MessagePack || (Binary.MessagePack = {}));
    })(Binary = CIFTools.Binary || (CIFTools.Binary = {}));
// })(CIFTools || (CIFTools = {}));
/*
 * Copyright (c) 2016 - now David Sehnal, licensed under MIT License, See LICENSE file for more info.
 */
// var CIFTools;
// (function (CIFTools) {
//     var Binary;
    (function (Binary) {
        var MessagePack;
        (function (MessagePack) {
            /*
             * Adapted from https://github.com/rcsb/mmtf-javascript
             * by Alexander Rose <alexander.rose@weirdbyte.de>, MIT License, Copyright (c) 2016
             */
            function utf8Write(data, offset, str) {
                var byteLength = data.byteLength;
                for (var i = 0, l = str.length; i < l; i++) {
                    var codePoint = str.charCodeAt(i);
                    // One byte of UTF-8
                    if (codePoint < 0x80) {
                        data[offset++] = codePoint >>> 0 & 0x7f | 0x00;
                        continue;
                    }
                    // Two bytes of UTF-8
                    if (codePoint < 0x800) {
                        data[offset++] = codePoint >>> 6 & 0x1f | 0xc0;
                        data[offset++] = codePoint >>> 0 & 0x3f | 0x80;
                        continue;
                    }
                    // Three bytes of UTF-8.
                    if (codePoint < 0x10000) {
                        data[offset++] = codePoint >>> 12 & 0x0f | 0xe0;
                        data[offset++] = codePoint >>> 6 & 0x3f | 0x80;
                        data[offset++] = codePoint >>> 0 & 0x3f | 0x80;
                        continue;
                    }
                    // Four bytes of UTF-8
                    if (codePoint < 0x110000) {
                        data[offset++] = codePoint >>> 18 & 0x07 | 0xf0;
                        data[offset++] = codePoint >>> 12 & 0x3f | 0x80;
                        data[offset++] = codePoint >>> 6 & 0x3f | 0x80;
                        data[offset++] = codePoint >>> 0 & 0x3f | 0x80;
                        continue;
                    }
                    throw new Error("bad codepoint " + codePoint);
                }
            }
            MessagePack.utf8Write = utf8Write;
            var __chars = function () {
                var data = [];
                for (var i = 0; i < 1024; i++)
                    data[i] = String.fromCharCode(i);
                return data;
            }();
            function throwError(err) {
                throw new Error(err);
            }
            function utf8Read(data, offset, length) {
                var chars = __chars;
                var str = void 0, chunk = [], chunkSize = 512, chunkOffset = 0;
                for (var i = offset, end = offset + length; i < end; i++) {
                    var byte = data[i];
                    // One byte character
                    if ((byte & 0x80) === 0x00) {
                        chunk[chunkOffset++] = chars[byte];
                    }
                    // Two byte character
                    else if ((byte & 0xe0) === 0xc0) {
                        chunk[chunkOffset++] = chars[((byte & 0x0f) << 6) | (data[++i] & 0x3f)];
                    }
                    // Three byte character
                    else if ((byte & 0xf0) === 0xe0) {
                        chunk[chunkOffset++] = String.fromCharCode(((byte & 0x0f) << 12) |
                            ((data[++i] & 0x3f) << 6) |
                            ((data[++i] & 0x3f) << 0));
                    }
                    // Four byte character
                    else if ((byte & 0xf8) === 0xf0) {
                        chunk[chunkOffset++] = String.fromCharCode(((byte & 0x07) << 18) |
                            ((data[++i] & 0x3f) << 12) |
                            ((data[++i] & 0x3f) << 6) |
                            ((data[++i] & 0x3f) << 0));
                    }
                    else
                        throwError("Invalid byte " + byte.toString(16));
                    if (chunkOffset === chunkSize) {
                        str = str || [];
                        str[str.length] = chunk.join('');
                        chunkOffset = 0;
                    }
                }
                if (!str)
                    return chunk.slice(0, chunkOffset).join('');
                if (chunkOffset > 0) {
                    str[str.length] = chunk.slice(0, chunkOffset).join('');
                }
                return str.join('');
            }
            MessagePack.utf8Read = utf8Read;
            function utf8ByteCount(str) {
                var count = 0;
                for (var i = 0, l = str.length; i < l; i++) {
                    var codePoint = str.charCodeAt(i);
                    if (codePoint < 0x80) {
                        count += 1;
                        continue;
                    }
                    if (codePoint < 0x800) {
                        count += 2;
                        continue;
                    }
                    if (codePoint < 0x10000) {
                        count += 3;
                        continue;
                    }
                    if (codePoint < 0x110000) {
                        count += 4;
                        continue;
                    }
                    throwError("bad codepoint " + codePoint);
                }
                return count;
            }
            MessagePack.utf8ByteCount = utf8ByteCount;
        })(MessagePack = Binary.MessagePack || (Binary.MessagePack = {}));
    })(Binary = CIFTools.Binary || (CIFTools.Binary = {}));
// })(CIFTools || (CIFTools = {}));
/*
 * Copyright (c) 2016 - now David Sehnal, licensed under MIT License, See LICENSE file for more info.
 */
// var CIFTools;
// (function (CIFTools) {
//     var Binary;
    (function (Binary) {
        "use strict";
        /**
         * Fixed point, delta, RLE, integer packing adopted from https://github.com/rcsb/mmtf-javascript/
         * by Alexander Rose <alexander.rose@weirdbyte.de>, MIT License, Copyright (c) 2016
         */
        function decode(data) {
            var current = data.data;
            for (var i = data.encoding.length - 1; i >= 0; i--) {
                current = Decoder.decodeStep(current, data.encoding[i]);
            }
            return current;
        }
        Binary.decode = decode;
        var Decoder;
        (function (Decoder) {
            function decodeStep(data, encoding) {
                switch (encoding.kind) {
                    case 'ByteArray': {
                        switch (encoding.type) {
                            case 4 /* Uint8 */: return data;
                            case 1 /* Int8 */: return int8(data);
                            case 2 /* Int16 */: return int16(data);
                            case 5 /* Uint16 */: return uint16(data);
                            case 3 /* Int32 */: return int32(data);
                            case 6 /* Uint32 */: return uint32(data);
                            case 32 /* Float32 */: return float32(data);
                            case 33 /* Float64 */: return float64(data);
                            default: throw new Error('Unsupported ByteArray type.');
                        }
                    }
                    case 'FixedPoint': return fixedPoint(data, encoding);
                    case 'IntervalQuantization': return intervalQuantization(data, encoding);
                    case 'RunLength': return runLength(data, encoding);
                    case 'Delta': return delta(data, encoding);
                    case 'IntegerPacking': return integerPacking(data, encoding);
                    case 'StringArray': return stringArray(data, encoding);
                }
            }
            Decoder.decodeStep = decodeStep;
            function getIntArray(type, size) {
                switch (type) {
                    case 1 /* Int8 */: return new Int8Array(size);
                    case 2 /* Int16 */: return new Int16Array(size);
                    case 3 /* Int32 */: return new Int32Array(size);
                    case 4 /* Uint8 */: return new Uint8Array(size);
                    case 5 /* Uint16 */: return new Uint16Array(size);
                    case 6 /* Uint32 */: return new Uint32Array(size);
                    default: throw new Error('Unsupported integer data type.');
                }
            }
            function getFloatArray(type, size) {
                switch (type) {
                    case 32 /* Float32 */: return new Float32Array(size);
                    case 33 /* Float64 */: return new Float64Array(size);
                    default: throw new Error('Unsupported floating data type.');
                }
            }
            /* http://stackoverflow.com/questions/7869752/javascript-typed-arrays-and-endianness */
            var isLittleEndian = (function () {
                var arrayBuffer = new ArrayBuffer(2);
                var uint8Array = new Uint8Array(arrayBuffer);
                var uint16array = new Uint16Array(arrayBuffer);
                uint8Array[0] = 0xAA;
                uint8Array[1] = 0xBB;
                if (uint16array[0] === 0xBBAA)
                    return true;
                return false;
            })();
            function int8(data) { return new Int8Array(data.buffer, data.byteOffset); }
            function flipByteOrder(data, bytes) {
                var buffer = new ArrayBuffer(data.length);
                var ret = new Uint8Array(buffer);
                for (var i = 0, n = data.length; i < n; i += bytes) {
                    for (var j = 0; j < bytes; j++) {
                        ret[i + bytes - j - 1] = data[i + j];
                    }
                }
                return buffer;
            }
            function view(data, byteSize, c) {
                if (isLittleEndian)
                    return new c(data.buffer);
                return new c(flipByteOrder(data, byteSize));
            }
            function int16(data) { return view(data, 2, Int16Array); }
            function uint16(data) { return view(data, 2, Uint16Array); }
            function int32(data) { return view(data, 4, Int32Array); }
            function uint32(data) { return view(data, 4, Uint32Array); }
            function float32(data) { return view(data, 4, Float32Array); }
            function float64(data) { return view(data, 8, Float64Array); }
            function fixedPoint(data, encoding) {
                var n = data.length;
                var output = getFloatArray(encoding.srcType, n);
                var f = 1 / encoding.factor;
                for (var i = 0; i < n; i++) {
                    output[i] = f * data[i];
                }
                return output;
            }
            function intervalQuantization(data, encoding) {
                var n = data.length;
                var output = getFloatArray(encoding.srcType, n);
                var delta = (encoding.max - encoding.min) / (encoding.numSteps - 1);
                var min = encoding.min;
                for (var i = 0; i < n; i++) {
                    output[i] = min + delta * data[i];
                }
                return output;
            }
            function runLength(data, encoding) {
                var output = getIntArray(encoding.srcType, encoding.srcSize);
                var dataOffset = 0;
                for (var i = 0, il = data.length; i < il; i += 2) {
                    var value = data[i]; // value to be repeated
                    var length_7 = data[i + 1]; // number of repeats
                    for (var j = 0; j < length_7; ++j) {
                        output[dataOffset++] = value;
                    }
                }
                return output;
            }
            function delta(data, encoding) {
                var n = data.length;
                var output = getIntArray(encoding.srcType, n);
                if (!n)
                    return output;
                output[0] = data[0] + (encoding.origin | 0);
                for (var i = 1; i < n; ++i) {
                    output[i] = data[i] + output[i - 1];
                }
                return output;
            }
            function integerPackingSigned(data, encoding) {
                var upperLimit = encoding.byteCount === 1 ? 0x7F : 0x7FFF;
                var lowerLimit = -upperLimit - 1;
                var n = data.length;
                var output = new Int32Array(encoding.srcSize);
                var i = 0;
                var j = 0;
                while (i < n) {
                    var value = 0, t = data[i];
                    while (t === upperLimit || t === lowerLimit) {
                        value += t;
                        i++;
                        t = data[i];
                    }
                    value += t;
                    output[j] = value;
                    i++;
                    j++;
                }
                return output;
            }
            function integerPackingUnsigned(data, encoding) {
                var upperLimit = encoding.byteCount === 1 ? 0xFF : 0xFFFF;
                var n = data.length;
                var output = new Int32Array(encoding.srcSize);
                var i = 0;
                var j = 0;
                while (i < n) {
                    var value = 0, t = data[i];
                    while (t === upperLimit) {
                        value += t;
                        i++;
                        t = data[i];
                    }
                    value += t;
                    output[j] = value;
                    i++;
                    j++;
                }
                return output;
            }
            function integerPacking(data, encoding) {
                return encoding.isUnsigned ? integerPackingUnsigned(data, encoding) : integerPackingSigned(data, encoding);
            }
            function stringArray(data, encoding) {
                var str = encoding.stringData;
                var offsets = decode({ encoding: encoding.offsetEncoding, data: encoding.offsets });
                var indices = decode({ encoding: encoding.dataEncoding, data: data });
                var cache = Object.create(null);
                var result = new Array(indices.length);
                var offset = 0;
                for (var _i = 0, indices_1 = indices; _i < indices_1.length; _i++) {
                    var i = indices_1[_i];
                    if (i < 0) {
                        result[offset++] = null;
                        continue;
                    }
                    var v = cache[i];
                    if (v === void 0) {
                        v = str.substring(offsets[i], offsets[i + 1]);
                        cache[i] = v;
                    }
                    result[offset++] = v;
                }
                return result;
            }
        })(Decoder || (Decoder = {}));
    })(Binary = CIFTools.Binary || (CIFTools.Binary = {}));
// })(CIFTools || (CIFTools = {}));
/*
 * Copyright (c) 2016 - now David Sehnal, licensed under MIT License, See LICENSE file for more info.
 */
// var CIFTools;
// (function (CIFTools) {
//     var Binary;
    (function (Binary) {
        "use strict";
        var File = /** @class */ (function () {
            function File(data) {
                this.dataBlocks = data.dataBlocks.map(function (b) { return new DataBlock(b); });
            }
            File.prototype.toJSON = function () {
                return this.dataBlocks.map(function (b) { return b.toJSON(); });
            };
            return File;
        }());
        Binary.File = File;
        var DataBlock = /** @class */ (function () {
            function DataBlock(data) {
                this.additionalData = {};
                this.header = data.header;
                this.categoryList = data.categories.map(function (c) { return new Category(c); });
                this.categoryMap = new Map();
                for (var _i = 0, _a = this.categoryList; _i < _a.length; _i++) {
                    var c = _a[_i];
                    this.categoryMap.set(c.name, c);
                }
            }
            Object.defineProperty(DataBlock.prototype, "categories", {
                get: function () { return this.categoryList; },
                enumerable: true,
                configurable: true
            });
            DataBlock.prototype.getCategory = function (name) { return this.categoryMap.get(name); };
            DataBlock.prototype.toJSON = function () {
                return {
                    id: this.header,
                    categories: this.categoryList.map(function (c) { return c.toJSON(); }),
                    additionalData: this.additionalData
                };
            };
            return DataBlock;
        }());
        Binary.DataBlock = DataBlock;
        var Category = /** @class */ (function () {
            function Category(data) {
                this.name = data.name;
                this.columnCount = data.columns.length;
                this.rowCount = data.rowCount;
                this.columnNameList = [];
                this.encodedColumns = new Map();
                for (var _i = 0, _a = data.columns; _i < _a.length; _i++) {
                    var c = _a[_i];
                    this.encodedColumns.set(c.name, c);
                    this.columnNameList.push(c.name);
                }
            }
            Object.defineProperty(Category.prototype, "columnNames", {
                get: function () { return this.columnNameList; },
                enumerable: true,
                configurable: true
            });
            Category.prototype.getColumn = function (name) {
                var w = this.encodedColumns.get(name);
                if (w)
                    return wrapColumn(w);
                return CIFTools.UndefinedColumn;
            };
            Category.prototype.toJSON = function () {
                var _this = this;
                var rows = [];
                var columns = this.columnNameList.map(function (name) { return ({ name: name, column: _this.getColumn(name) }); });
                for (var i = 0; i < this.rowCount; i++) {
                    var item = {};
                    for (var _i = 0, columns_1 = columns; _i < columns_1.length; _i++) {
                        var c = columns_1[_i];
                        var d = c.column.getValuePresence(i);
                        if (d === 0 /* Present */)
                            item[c.name] = c.column.getString(i);
                        else if (d === 1 /* NotSpecified */)
                            item[c.name] = '.';
                        else
                            item[c.name] = '?';
                    }
                    rows[i] = item;
                }
                return { name: this.name, columns: this.columnNames, rows: rows };
            };
            return Category;
        }());
        Binary.Category = Category;
        function wrapColumn(column) {
            if (!column.data.data)
                return CIFTools.UndefinedColumn;
            var data = Binary.decode(column.data);
            var mask = void 0;
            if (column.mask)
                mask = Binary.decode(column.mask);
            if (data.buffer && data.byteLength && data.BYTES_PER_ELEMENT) {
                return mask ? new MaskedNumericColumn(data, mask) : new NumericColumn(data);
            }
            return mask ? new MaskedStringColumn(data, mask) : new StringColumn(data);
        }
        var fastParseInt = CIFTools.Utils.FastNumberParsers.parseInt;
        var fastParseFloat = CIFTools.Utils.FastNumberParsers.parseFloat;
        var NumericColumn = /** @class */ (function () {
            function NumericColumn(data) {
                this.data = data;
                this.isDefined = true;
            }
            NumericColumn.prototype.getString = function (row) { return "" + this.data[row]; };
            NumericColumn.prototype.getInteger = function (row) { return this.data[row] | 0; };
            NumericColumn.prototype.getFloat = function (row) { return 1.0 * this.data[row]; };
            NumericColumn.prototype.stringEquals = function (row, value) { return this.data[row] === fastParseFloat(value, 0, value.length); };
            NumericColumn.prototype.areValuesEqual = function (rowA, rowB) { return this.data[rowA] === this.data[rowB]; };
            NumericColumn.prototype.getValuePresence = function (row) { return 0 /* Present */; };
            return NumericColumn;
        }());
        var MaskedNumericColumn = /** @class */ (function () {
            function MaskedNumericColumn(data, mask) {
                this.data = data;
                this.mask = mask;
                this.isDefined = true;
            }
            MaskedNumericColumn.prototype.getString = function (row) { return this.mask[row] === 0 /* Present */ ? "" + this.data[row] : null; };
            MaskedNumericColumn.prototype.getInteger = function (row) { return this.mask[row] === 0 /* Present */ ? this.data[row] : 0; };
            MaskedNumericColumn.prototype.getFloat = function (row) { return this.mask[row] === 0 /* Present */ ? this.data[row] : 0; };
            MaskedNumericColumn.prototype.stringEquals = function (row, value) { return this.mask[row] === 0 /* Present */ ? this.data[row] === fastParseFloat(value, 0, value.length) : value === null || value === void 0; };
            MaskedNumericColumn.prototype.areValuesEqual = function (rowA, rowB) { return this.data[rowA] === this.data[rowB]; };
            MaskedNumericColumn.prototype.getValuePresence = function (row) { return this.mask[row]; };
            return MaskedNumericColumn;
        }());
        var StringColumn = /** @class */ (function () {
            function StringColumn(data) {
                this.data = data;
                this.isDefined = true;
            }
            StringColumn.prototype.getString = function (row) { return this.data[row]; };
            StringColumn.prototype.getInteger = function (row) { var v = this.data[row]; return fastParseInt(v, 0, v.length); };
            StringColumn.prototype.getFloat = function (row) { var v = this.data[row]; return fastParseFloat(v, 0, v.length); };
            StringColumn.prototype.stringEquals = function (row, value) { return this.data[row] === value; };
            StringColumn.prototype.areValuesEqual = function (rowA, rowB) { return this.data[rowA] === this.data[rowB]; };
            StringColumn.prototype.getValuePresence = function (row) { return 0 /* Present */; };
            return StringColumn;
        }());
        var MaskedStringColumn = /** @class */ (function () {
            function MaskedStringColumn(data, mask) {
                this.data = data;
                this.mask = mask;
                this.isDefined = true;
            }
            MaskedStringColumn.prototype.getString = function (row) { return this.mask[row] === 0 /* Present */ ? this.data[row] : null; };
            MaskedStringColumn.prototype.getInteger = function (row) { if (this.mask[row] !== 0 /* Present */)
                return 0; var v = this.data[row]; return fastParseInt(v || '', 0, (v || '').length); };
            MaskedStringColumn.prototype.getFloat = function (row) { if (this.mask[row] !== 0 /* Present */)
                return 0; var v = this.data[row]; return fastParseFloat(v || '', 0, (v || '').length); };
            MaskedStringColumn.prototype.stringEquals = function (row, value) { return this.data[row] === value; };
            MaskedStringColumn.prototype.areValuesEqual = function (rowA, rowB) { return this.data[rowA] === this.data[rowB]; };
            MaskedStringColumn.prototype.getValuePresence = function (row) { return this.mask[row]; };
            return MaskedStringColumn;
        }());
    })(Binary = CIFTools.Binary || (CIFTools.Binary = {}));
// })(CIFTools || (CIFTools = {}));
/*
 * Copyright (c) 2016 - now David Sehnal, licensed under MIT License, See LICENSE file for more info.
 */
// var CIFTools;
// (function (CIFTools) {
//     var Binary;
    (function (Binary) {
        "use strict";
        /**
         * Fixed point, delta, RLE, integer packing adopted from https://github.com/rcsb/mmtf-javascript/
         * by Alexander Rose <alexander.rose@weirdbyte.de>, MIT License, Copyright (c) 2016
         */
        var Encoder = /** @class */ (function () {
            function Encoder(providers) {
                this.providers = providers;
            }
            Encoder.prototype.and = function (f) {
                return new Encoder(this.providers.concat([f]));
            };
            Encoder.prototype.encode = function (data) {
                var encoding = [];
                for (var _i = 0, _a = this.providers; _i < _a.length; _i++) {
                    var p = _a[_i];
                    var t = p(data);
                    if (!t.encodings.length) {
                        throw new Error('Encodings must be non-empty.');
                    }
                    data = t.data;
                    for (var _b = 0, _c = t.encodings; _b < _c.length; _b++) {
                        var e = _c[_b];
                        encoding.push(e);
                    }
                }
                if (!(data instanceof Uint8Array)) {
                    throw new Error('The encoding must result in a Uint8Array. Fix your encoding chain.');
                }
                return {
                    encoding: encoding,
                    data: data
                };
            };
            return Encoder;
        }());
        Binary.Encoder = Encoder;
        (function (Encoder) {
            var _a, _b;
            function by(f) {
                return new Encoder([f]);
            }
            Encoder.by = by;
            function uint8(data) {
                return {
                    encodings: [{ kind: 'ByteArray', type: 4 /* Uint8 */ }],
                    data: data
                };
            }
            function int8(data) {
                return {
                    encodings: [{ kind: 'ByteArray', type: 1 /* Int8 */ }],
                    data: new Uint8Array(data.buffer, data.byteOffset)
                };
            }
            var writers = (_a = {},
                _a[2 /* Int16 */] = function (v, i, a) { v.setInt16(2 * i, a, true); },
                _a[5 /* Uint16 */] = function (v, i, a) { v.setUint16(2 * i, a, true); },
                _a[3 /* Int32 */] = function (v, i, a) { v.setInt32(4 * i, a, true); },
                _a[6 /* Uint32 */] = function (v, i, a) { v.setUint32(4 * i, a, true); },
                _a[32 /* Float32 */] = function (v, i, a) { v.setFloat32(4 * i, a, true); },
                _a[33 /* Float64 */] = function (v, i, a) { v.setFloat64(8 * i, a, true); },
                _a);
            var byteSizes = (_b = {},
                _b[2 /* Int16 */] = 2,
                _b[5 /* Uint16 */] = 2,
                _b[3 /* Int32 */] = 4,
                _b[6 /* Uint32 */] = 4,
                _b[32 /* Float32 */] = 4,
                _b[33 /* Float64 */] = 8,
                _b);
            function byteArray(data) {
                var type = Binary.Encoding.getDataType(data);
                if (type === 1 /* Int8 */)
                    return int8(data);
                else if (type === 4 /* Uint8 */)
                    return uint8(data);
                var result = new Uint8Array(data.length * byteSizes[type]);
                var w = writers[type];
                var view = new DataView(result.buffer);
                for (var i = 0, n = data.length; i < n; i++) {
                    w(view, i, data[i]);
                }
                return {
                    encodings: [{ kind: 'ByteArray', type: type }],
                    data: result
                };
            }
            Encoder.byteArray = byteArray;
            function _fixedPoint(data, factor) {
                var srcType = Binary.Encoding.getDataType(data);
                var result = new Int32Array(data.length);
                for (var i = 0, n = data.length; i < n; i++) {
                    result[i] = Math.round(data[i] * factor);
                }
                return {
                    encodings: [{ kind: 'FixedPoint', factor: factor, srcType: srcType }],
                    data: result
                };
            }
            function fixedPoint(factor) { return function (data) { return _fixedPoint(data, factor); }; }
            Encoder.fixedPoint = fixedPoint;
            function _intervalQuantizaiton(data, min, max, numSteps, arrayType) {
                var srcType = Binary.Encoding.getDataType(data);
                if (!data.length) {
                    return {
                        encodings: [{ kind: 'IntervalQuantization', min: min, max: max, numSteps: numSteps, srcType: srcType }],
                        data: new Int32Array(0)
                    };
                }
                if (max < min) {
                    var t = min;
                    min = max;
                    max = t;
                }
                var delta = (max - min) / (numSteps - 1);
                var output = new arrayType(data.length);
                for (var i = 0, n = data.length; i < n; i++) {
                    var v = data[i];
                    if (v <= min)
                        output[i] = 0;
                    else if (v >= max)
                        output[i] = numSteps;
                    else
                        output[i] = (Math.round((v - min) / delta)) | 0;
                }
                return {
                    encodings: [{ kind: 'IntervalQuantization', min: min, max: max, numSteps: numSteps, srcType: srcType }],
                    data: output
                };
            }
            function intervalQuantizaiton(min, max, numSteps, arrayType) {
                if (arrayType === void 0) { arrayType = Int32Array; }
                return function (data) { return _intervalQuantizaiton(data, min, max, numSteps, arrayType); };
            }
            Encoder.intervalQuantizaiton = intervalQuantizaiton;
            function runLength(data) {
                var srcType = Binary.Encoding.getDataType(data);
                if (srcType === void 0) {
                    data = new Int32Array(data);
                    srcType = 3 /* Int32 */;
                }
                if (!data.length) {
                    return {
                        encodings: [{ kind: 'RunLength', srcType: srcType, srcSize: 0 }],
                        data: new Int32Array(0)
                    };
                }
                // calculate output size
                var fullLength = 2;
                for (var i = 1, il = data.length; i < il; i++) {
                    if (data[i - 1] !== data[i]) {
                        fullLength += 2;
                    }
                }
                var output = new Int32Array(fullLength);
                var offset = 0;
                var runLength = 1;
                for (var i = 1, il = data.length; i < il; i++) {
                    if (data[i - 1] !== data[i]) {
                        output[offset] = data[i - 1];
                        output[offset + 1] = runLength;
                        runLength = 1;
                        offset += 2;
                    }
                    else {
                        ++runLength;
                    }
                }
                output[offset] = data[data.length - 1];
                output[offset + 1] = runLength;
                return {
                    encodings: [{ kind: 'RunLength', srcType: srcType, srcSize: data.length }],
                    data: output
                };
            }
            Encoder.runLength = runLength;
            function delta(data) {
                if (!Binary.Encoding.isSignedIntegerDataType(data)) {
                    throw new Error('Only signed integer types can be encoded using delta encoding.');
                }
                var srcType = Binary.Encoding.getDataType(data);
                if (srcType === void 0) {
                    data = new Int32Array(data);
                    srcType = 3 /* Int32 */;
                }
                if (!data.length) {
                    return {
                        encodings: [{ kind: 'Delta', origin: 0, srcType: srcType }],
                        data: new data.constructor(0)
                    };
                }
                var output = new data.constructor(data.length);
                var origin = data[0];
                output[0] = data[0];
                for (var i = 1, n = data.length; i < n; i++) {
                    output[i] = data[i] - data[i - 1];
                }
                output[0] = 0;
                return {
                    encodings: [{ kind: 'Delta', origin: origin, srcType: srcType }],
                    data: output
                };
            }
            Encoder.delta = delta;
            function isSigned(data) {
                for (var i = 0, n = data.length; i < n; i++) {
                    if (data[i] < 0)
                        return true;
                }
                return false;
            }
            function packingSize(data, upperLimit) {
                var lowerLimit = -upperLimit - 1;
                var size = 0;
                for (var i = 0, n = data.length; i < n; i++) {
                    var value = data[i];
                    if (value === 0) {
                        size += 1;
                    }
                    else if (value > 0) {
                        size += Math.ceil(value / upperLimit);
                        if (value % upperLimit === 0)
                            size += 1;
                    }
                    else {
                        size += Math.ceil(value / lowerLimit);
                        if (value % lowerLimit === 0)
                            size += 1;
                    }
                }
                return size;
            }
            function determinePacking(data) {
                var signed = isSigned(data);
                var size8 = signed ? packingSize(data, 0x7F) : packingSize(data, 0xFF);
                var size16 = signed ? packingSize(data, 0x7FFF) : packingSize(data, 0xFFFF);
                if (data.length * 4 < size16 * 2) {
                    // 4 byte packing is the most effective
                    return {
                        isSigned: signed,
                        size: data.length,
                        bytesPerElement: 4
                    };
                }
                else if (size16 * 2 < size8) {
                    // 2 byte packing is the most effective
                    return {
                        isSigned: signed,
                        size: size16,
                        bytesPerElement: 2
                    };
                }
                else {
                    // 1 byte packing is the most effective
                    return {
                        isSigned: signed,
                        size: size8,
                        bytesPerElement: 1
                    };
                }
                ;
            }
            function _integerPacking(data, packing) {
                var upperLimit = packing.isSigned
                    ? (packing.bytesPerElement === 1 ? 0x7F : 0x7FFF)
                    : (packing.bytesPerElement === 1 ? 0xFF : 0xFFFF);
                var lowerLimit = -upperLimit - 1;
                var n = data.length;
                var packed = packing.isSigned
                    ? packing.bytesPerElement === 1 ? new Int8Array(packing.size) : new Int16Array(packing.size)
                    : packing.bytesPerElement === 1 ? new Uint8Array(packing.size) : new Uint16Array(packing.size);
                var j = 0;
                for (var i = 0; i < n; i++) {
                    var value = data[i];
                    if (value >= 0) {
                        while (value >= upperLimit) {
                            packed[j] = upperLimit;
                            ++j;
                            value -= upperLimit;
                        }
                    }
                    else {
                        while (value <= lowerLimit) {
                            packed[j] = lowerLimit;
                            ++j;
                            value -= lowerLimit;
                        }
                    }
                    packed[j] = value;
                    ++j;
                }
                var result = byteArray(packed);
                return {
                    encodings: [{
                            kind: 'IntegerPacking',
                            byteCount: packing.bytesPerElement,
                            isUnsigned: !packing.isSigned,
                            srcSize: n
                        },
                        result.encodings[0]
                    ],
                    data: result.data
                };
            }
            /**
             * Packs Int32 array. The packing level is determined automatically to either 1-, 2-, or 4-byte words.
             */
            function integerPacking(data) {
                if (!(data instanceof Int32Array)) {
                    throw new Error('Integer packing can only be applied to Int32 data.');
                }
                var packing = determinePacking(data);
                if (packing.bytesPerElement === 4) {
                    // no packing done, Int32 encoding will be used
                    return byteArray(data);
                }
                return _integerPacking(data, packing);
            }
            Encoder.integerPacking = integerPacking;
            function stringArray(data) {
                var map = Object.create(null);
                var strings = [];
                var accLength = 0;
                var offsets = CIFTools.Utils.ChunkedArray.create(function (s) { return new Int32Array(s); }, 1024, 1);
                var output = new Int32Array(data.length);
                CIFTools.Utils.ChunkedArray.add(offsets, 0);
                var i = 0;
                for (var _i = 0, data_1 = data; _i < data_1.length; _i++) {
                    var s = data_1[_i];
                    // handle null strings.
                    if (s === null || s === void 0) {
                        output[i++] = -1;
                        continue;
                    }
                    var index = map[s];
                    if (index === void 0) {
                        // increment the length
                        accLength += s.length;
                        // store the string and index                   
                        index = strings.length;
                        strings[index] = s;
                        map[s] = index;
                        // write the offset
                        CIFTools.Utils.ChunkedArray.add(offsets, accLength);
                    }
                    output[i++] = index;
                }
                var encOffsets = Encoder.by(delta).and(integerPacking).encode(CIFTools.Utils.ChunkedArray.compact(offsets));
                var encOutput = Encoder.by(delta).and(runLength).and(integerPacking).encode(output);
                return {
                    encodings: [{ kind: 'StringArray', dataEncoding: encOutput.encoding, stringData: strings.join(''), offsetEncoding: encOffsets.encoding, offsets: encOffsets.data }],
                    data: encOutput.data
                };
            }
            Encoder.stringArray = stringArray;
        })(Encoder = Binary.Encoder || (Binary.Encoder = {}));
    })(Binary = CIFTools.Binary || (CIFTools.Binary = {}));
// })(CIFTools || (CIFTools = {}));
/*
 * Copyright (c) 2016 - now David Sehnal, licensed under MIT License, See LICENSE file for more info.
 */
// var CIFTools;
// (function (CIFTools) {
//     var Binary;
    (function (Binary) {
        "use strict";
        Binary.VERSION = '0.3.0';
        var Encoding;
        (function (Encoding) {
            function getDataType(data) {
                var srcType;
                if (data instanceof Int8Array)
                    srcType = 1 /* Int8 */;
                else if (data instanceof Int16Array)
                    srcType = 2 /* Int16 */;
                else if (data instanceof Int32Array)
                    srcType = 3 /* Int32 */;
                else if (data instanceof Uint8Array)
                    srcType = 4 /* Uint8 */;
                else if (data instanceof Uint16Array)
                    srcType = 5 /* Uint16 */;
                else if (data instanceof Uint32Array)
                    srcType = 6 /* Uint32 */;
                else if (data instanceof Float32Array)
                    srcType = 32 /* Float32 */;
                else if (data instanceof Float64Array)
                    srcType = 33 /* Float64 */;
                else
                    throw new Error('Unsupported integer data type.');
                return srcType;
            }
            Encoding.getDataType = getDataType;
            function isSignedIntegerDataType(data) {
                return data instanceof Int8Array || data instanceof Int16Array || data instanceof Int32Array;
            }
            Encoding.isSignedIntegerDataType = isSignedIntegerDataType;
        })(Encoding = Binary.Encoding || (Binary.Encoding = {}));
    })(Binary = CIFTools.Binary || (CIFTools.Binary = {}));
// })(CIFTools || (CIFTools = {}));
/*
 * Copyright (c) 2016 - now David Sehnal, licensed under MIT License, See LICENSE file for more info.
 */
// var CIFTools;
// (function (CIFTools) {
//     var Binary;
    (function (Binary) {
        "use strict";
        function checkVersions(min, current) {
            for (var i = 0; i < 2; i++) {
                if (min[i] > current[i])
                    return false;
            }
            return true;
        }
        function parse(data) {
            var minVersion = [0, 3];
            try {
                var array = new Uint8Array(data);
                var unpacked = Binary.MessagePack.decode(array);
                if (!checkVersions(minVersion, unpacked.version.match(/(\d)\.(\d)\.\d/).slice(1))) {
                    return CIFTools.ParserResult.error("Unsupported format version. Current " + unpacked.version + ", required " + minVersion.join('.') + ".");
                }
                var file = new Binary.File(unpacked);
                return CIFTools.ParserResult.success(file);
            }
            catch (e) {
                return CIFTools.ParserResult.error('' + e);
            }
        }
        Binary.parse = parse;
    })(Binary = CIFTools.Binary || (CIFTools.Binary = {}));
// })(CIFTools || (CIFTools = {}));
/*
 * Copyright (c) 2016 - now David Sehnal, licensed under MIT License, See LICENSE file for more info.
 */
// var CIFTools;
// (function (CIFTools) {
//     var Binary;
    (function (Binary) {
        "use strict";
        function encodeField(field, data, totalCount) {
            var array, isNative = false;
            if (field.typedArray) {
                array = new field.typedArray(totalCount);
            }
            else {
                isNative = true;
                array = new Array(totalCount);
            }
            var mask = new Uint8Array(totalCount);
            var presence = field.presence;
            var getter = field.number ? field.number : field.string;
            var allPresent = true;
            var offset = 0;
            for (var _i = 0, data_2 = data; _i < data_2.length; _i++) {
                var _d = data_2[_i];
                var d = _d.data;
                for (var i = 0, _b = _d.count; i < _b; i++) {
                    var p = presence ? presence(d, i) : 0 /* Present */;
                    if (p !== 0 /* Present */) {
                        mask[offset] = p;
                        if (isNative)
                            array[offset] = null;
                        allPresent = false;
                    }
                    else {
                        mask[offset] = 0 /* Present */;
                        array[offset] = getter(d, i);
                    }
                    offset++;
                }
            }
            var encoder = field.encoder ? field.encoder : Binary.Encoder.by(Binary.Encoder.stringArray);
            var encoded = encoder.encode(array);
            var maskData = void 0;
            if (!allPresent) {
                var maskRLE = Binary.Encoder.by(Binary.Encoder.runLength).and(Binary.Encoder.byteArray).encode(mask);
                if (maskRLE.data.length < mask.length) {
                    maskData = maskRLE;
                }
                else {
                    maskData = Binary.Encoder.by(Binary.Encoder.byteArray).encode(mask);
                }
            }
            return {
                name: field.name,
                data: encoded,
                mask: maskData
            };
        }
        var Writer = /** @class */ (function () {
            function Writer(encoder) {
                this.dataBlocks = [];
                this.data = {
                    encoder: encoder,
                    version: Binary.VERSION,
                    dataBlocks: this.dataBlocks
                };
            }
            Writer.prototype.startDataBlock = function (header) {
                this.dataBlocks.push({
                    header: (header || '').replace(/[ \n\t]/g, '').toUpperCase(),
                    categories: []
                });
            };
            Writer.prototype.writeCategory = function (category, contexts) {
                if (!this.data) {
                    throw new Error('The writer contents have already been encoded, no more writing.');
                }
                if (!this.dataBlocks.length) {
                    throw new Error('No data block created.');
                }
                var src = !contexts || !contexts.length ? [category(void 0)] : contexts.map(function (c) { return category(c); });
                var categories = src.filter(function (c) { return c && c.count > 0; });
                if (!categories.length)
                    return;
                var count = categories.reduce(function (a, c) { return a + c.count; }, 0);
                if (!count)
                    return;
                var first = categories[0];
                var cat = { name: first.desc.name, columns: [], rowCount: count };
                var data = categories.map(function (c) { return ({ data: c.data, count: c.count }); });
                for (var _i = 0, _a = first.desc.fields; _i < _a.length; _i++) {
                    var f = _a[_i];
                    cat.columns.push(encodeField(f, data, count));
                }
                this.dataBlocks[this.dataBlocks.length - 1].categories.push(cat);
            };
            Writer.prototype.encode = function () {
                this.encodedData = Binary.MessagePack.encode(this.data);
                this.data = null;
                this.dataBlocks = null;
            };
            Writer.prototype.flush = function (stream) {
                stream.writeBinary(this.encodedData);
            };
            return Writer;
        }());
        Binary.Writer = Writer;
    })(Binary = CIFTools.Binary || (CIFTools.Binary = {}));
 })(CIFTools || (CIFTools = {}));
//   return CIFTools;
// }
// if (typeof module === 'object' && typeof module.exports === 'object') {
//   module.exports = __CIFTools();
// } else if (typeof define === 'function' && define.amd) {
//   define(['require'], function(require) { return __CIFTools(); })
// } else {
//   var __target = !!window ? window : this;
//   __target.CIFTools = __CIFTools();
// }


/*
 * ==========================================================
 *  COLOR PICKER PLUGIN 1.3.9
 * ==========================================================
 * Author: Taufik Nurrohman <https://github.com/tovic>
 * License: MIT
 * ----------------------------------------------------------
 */

(function(win, doc, NS) {

    var instance = '__instance__',
        first = 'firstChild',
        delay = setTimeout;

    function is_set(x) {
        return typeof x !== "undefined";
    }

    function is_string(x) {
        return typeof x === "string";
    }

    function is_object(x) {
        return typeof x === "object";
    }

    function object_length(x) {
        return Object.keys(x).length;
    }

    function edge(a, b, c) {
        if (a < b) return b;
        if (a > c) return c;
        return a;
    }

    function num(i, j) {
        return parseInt(i, j || 10);
    }

    function round(i) {
        return Math.round(i);
    }

    // [h, s, v] ... 0 <= h, s, v <= 1
    function HSV2RGB(a) {
        var h = +a[0],
            s = +a[1],
            v = +a[2],
            r, g, b, i, f, p, q, t;
        i = Math.floor(h * 6);
        f = h * 6 - i;
        p = v * (1 - s);
        q = v * (1 - f * s);
        t = v * (1 - (1 - f) * s);
        i = i || 0;
        q = q || 0;
        t = t || 0;
        switch (i % 6) {
            case 0:
                r = v, g = t, b = p;
                break;
            case 1:
                r = q, g = v, b = p;
                break;
            case 2:
                r = p, g = v, b = t;
                break;
            case 3:
                r = p, g = q, b = v;
                break;
            case 4:
                r = t, g = p, b = v;
                break;
            case 5:
                r = v, g = p, b = q;
                break;
        }
        return [round(r * 255), round(g * 255), round(b * 255)];
    }

    function HSV2HEX(a) {
        return RGB2HEX(HSV2RGB(a));
    }

    // [r, g, b] ... 0 <= r, g, b <= 255
    function RGB2HSV(a) {
        var r = +a[0],
            g = +a[1],
            b = +a[2],
            max = Math.max(r, g, b),
            min = Math.min(r, g, b),
            d = max - min,
            h, s = (max === 0 ? 0 : d / max),
            v = max / 255;
        switch (max) {
            case min:
                h = 0;
                break;
            case r:
                h = (g - b) + d * (g < b ? 6 : 0);
                h /= 6 * d;
                break;
            case g:
                h = (b - r) + d * 2;
                h /= 6 * d;
                break;
            case b:
                h = (r - g) + d * 4;
                h /= 6 * d;
                break;
        }
        return [h, s, v];
    }

    function RGB2HEX(a) {
        var s = +a[2] | (+a[1] << 8) | (+a[0] << 16);
        s = '000000' + s.toString(16);
        return s.slice(-6);
    }

    // rrggbb or rgb
    function HEX2HSV(s) {
        return RGB2HSV(HEX2RGB(s));
    }

    function HEX2RGB(s) {
        if (s.length === 3) {
            s = s.replace(/./g, '$&$&');
        }
        return [num(s[0] + s[1], 16), num(s[2] + s[3], 16), num(s[4] + s[5], 16)];
    }

    // convert range from `0` to `360` and `0` to `100` in color into range from `0` to `1`
    function _2HSV_pri(a) {
        return [+a[0] / 360, +a[1] / 100, +a[2] / 100];
    }

    // convert range from `0` to `1` into `0` to `360` and `0` to `100` in color
    function _2HSV_pub(a) {
        return [round(+a[0] * 360), round(+a[1] * 100), round(+a[2] * 100)];
    }

    // convert range from `0` to `255` in color into range from `0` to `1`
    function _2RGB_pri(a) {
        return [+a[0] / 255, +a[1] / 255, +a[2] / 255];
    }

    // *
    function parse(x) {
        if (is_object(x)) return x;
        var rgb = /\s*rgb\s*\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*\)\s*$/i.exec(x),
            hsv = /\s*hsv\s*\(\s*(\d+)\s*,\s*(\d+)%\s*,\s*(\d+)%\s*\)\s*$/i.exec(x),
            hex = x[0] === '#' && x.match(/^#([\da-f]{3}|[\da-f]{6})$/i);
        if (hex) {
            return HEX2HSV(x.slice(1));
        } else if (hsv) {
            return _2HSV_pri([+hsv[1], +hsv[2], +hsv[3]]);
        } else if (rgb) {
            return RGB2HSV([+rgb[1], +rgb[2], +rgb[3]]);
        }
        return [0, 1, 1]; // default is red
    }

    (function($) {

        // plugin version
        $.version = '1.3.9';

        // collect all instance(s)
        $[instance] = {};

        // plug to all instance(s)
        $.each = function(fn, t) {
            return delay(function() {
                var ins = $[instance], i;
                for (i in ins) {
                    fn(ins[i], i, ins);
                }
            }, t === 0 ? 0 : (t || 1)), $;
        };

        // static method(s)
        $.parse = parse;
        $._HSV2RGB = HSV2RGB;
        $._HSV2HEX = HSV2HEX;
        $._RGB2HSV = RGB2HSV;
        $._HEX2HSV = HEX2HSV;
        $._HEX2RGB = function(a) {
            return _2RGB_pri(HEX2RGB(a));
        };
        $.HSV2RGB = function(a) {
            return HSV2RGB(_2HSV_pri(a));
        };
        $.HSV2HEX = function(a) {
            return HSV2HEX(_2HSV_pri(a));
        };
        $.RGB2HSV = function(a) {
            return _2HSV_pub(RGB2HSV(a));
        };
        $.RGB2HEX = RGB2HEX;
        $.HEX2HSV = function(s) {
            return _2HSV_pub(HEX2HSV(s));
        };
        $.HEX2RGB = HEX2RGB;

    })(win[NS] = function(target, events, parent) {

        var b = doc.body,
            h = doc.documentElement,
            $ = this,
            $$ = win[NS],
            _ = false,
            hooks = {},
            picker = doc.createElement('div'),
            on_down = "touchstart mousedown",
            on_move = "touchmove mousemove",
            on_up = "touchend mouseup",
            on_resize = "orientationchange resize";

        // return a new instance if `CP` was called without the `new` operator
        if (!($ instanceof $$)) {
            return new $$(target, events);
        }

        // store color picker instance to `CP.__instance__`
        $$[instance][target.id || target.name || object_length($$[instance])] = $;

        // trigger color picker panel on click by default
        if (!is_set(events) || events === true) {
            events = on_down;
        }

        // add event
        function on(ev, el, fn) {
            ev = ev.split(/\s+/);
            for (var i = 0, ien = ev.length; i < ien; ++i) {
                el.addEventListener(ev[i], fn, false);
            }
        }

        // remove event
        function off(ev, el, fn) {
            ev = ev.split(/\s+/);
            for (var i = 0, ien = ev.length; i < ien; ++i) {
                el.removeEventListener(ev[i], fn);
            }
        }

        // get mouse/finger coordinate
        function point(el, e) {
            var T = 'touches',
                X = 'clientX',
                Y = 'clientY',
                x = !!e[T] ? e[T][0][X] : e[X],
                y = !!e[T] ? e[T][0][Y] : e[Y],
                o = offset(el);
            return {
                x: x - o.l,
                y: y - o.t
            };
        }

        // get position
        function offset(el) {
            var left, top, rect;
            if (el === win) {
                left = win.pageXOffset || h.scrollLeft;
                top = win.pageYOffset || h.scrollTop;
            } else {
                rect = el.getBoundingClientRect();
                left = rect.left;
                top = rect.top;
            }
            return {
                l: left,
                t: top
            };
        }

        // get closest parent
        function closest(a, b) {
            while ((a = a.parentElement) && a !== b);
            return a;
        }

        // prevent default
        function prevent(e) {
            if (e) e.preventDefault();
        }

        // get dimension
        function size(el) {
            return el === win ? {
                w: win.innerWidth,
                h: win.innerHeight
            } : {
                w: el.offsetWidth,
                h: el.offsetHeight
            };
        }

        // get color data
        function get_data(a) {
            return _ || (is_set(a) ? a : false);
        }

        // set color data
        function set_data(a) {
            _ = a;
        }

        // add hook
        function add(ev, fn, id) {
            if (!is_set(ev)) return hooks;
            if (!is_set(fn)) return hooks[ev];
            if (!is_set(hooks[ev])) hooks[ev] = {};
            if (!is_set(id)) id = object_length(hooks[ev]);
            return hooks[ev][id] = fn, $;
        }

        // remove hook
        function remove(ev, id) {
            if (!is_set(ev)) return hooks = {}, $;
            if (!is_set(id)) return hooks[ev] = {}, $;
            return delete hooks[ev][id], $;
        }

        // trigger hook
        function trigger(ev, a, id) {
            if (!is_set(hooks[ev])) return $;
            if (!is_set(id)) {
                for (var i in hooks[ev]) {
                    hooks[ev][i].apply($, a);
                }
            } else {
                if (is_set(hooks[ev][id])) {
                    hooks[ev][id].apply($, a);
                }
            }
            return $;
        }

        // initialize data ...
        set_data($$.parse(target.getAttribute('data-color') || target.value || [0, 1, 1]));

        // generate color picker pane ...
        picker.className = 'color-picker';
        picker.innerHTML = '<div class="color-picker-control"><span class="color-picker-h"><i></i></span><span class="color-picker-sv"><i></i></span></div>';
        var c = picker[first].children,
            HSV = get_data([0, 1, 1]), // default is red
            H = c[0],
            SV = c[1],
            H_point = H[first],
            SV_point = SV[first],
            start_H = 0,
            start_SV = 0,
            drag_H = 0,
            drag_SV = 0,
            left = 0,
            top = 0,
            P_W = 0,
            P_H = 0,
            v = HSV2HEX(HSV),
            set;

        // on update ...
        function trigger_(k, x) {
            if (!k || k === "h") {
                trigger("change:h", x);
            }
            if (!k || k === "sv") {
                trigger("change:sv", x);
            }
            trigger("change", x);
        }

        // is visible?
        function visible() {
            return picker.parentNode;
        }

        // create
        function create(first, bucket) {
            if (!first) {
                (parent || bucket || b).appendChild(picker), $.visible = true;
            }
            P_W = size(picker).w;
            P_H = size(picker).h;
            var SV_size = size(SV),
                SV_point_size = size(SV_point),
                H_H = size(H).h,
                SV_W = SV_size.w,
                SV_H = SV_size.h,
                H_point_H = size(H_point).h,
                SV_point_W = SV_point_size.w,
                SV_point_H = SV_point_size.h;
            if (first) {
                picker.style.left = picker.style.top = '-9999px';
                function click(e) {
                    var t = e.target,
                        is_target = t === target || closest(t, target) === target;
                    if (is_target) {
                        create();
                    } else {
                        $.exit();
                    }
                    trigger(is_target ? "enter" : "exit", [$]);
                }
                if (events !== false) {
                    on(events, target, click);
                }
                $.create = function() {
                    return create(1), trigger("create", [$]), $;
                };
                $.destroy = function() {
                    if (events !== false) {
                        off(events, target, click);
                    }
                    $.exit(), set_data(false);
                    return trigger("destroy", [$]), $;
                };
            } else {
                fit();
            }
            set = function() {
                HSV = get_data(HSV), color();
                H_point.style.top = (H_H - (H_point_H / 2) - (H_H * +HSV[0])) + 'px';
                SV_point.style.right = (SV_W - (SV_point_W / 2) - (SV_W * +HSV[1])) + 'px';
                SV_point.style.top = (SV_H - (SV_point_H / 2) - (SV_H * +HSV[2])) + 'px';
            };
            $.exit = function(e) {
                if (visible()) {
                    visible().removeChild(picker);
                    $.visible = false;
                }
                off(on_down, H, down_H);
                off(on_down, SV, down_SV);
                off(on_move, doc, move);
                off(on_up, doc, stop);
                off(on_resize, win, fit);
                return $;
            };
            function color(e) {
                var a = HSV2RGB(HSV),
                    b = HSV2RGB([HSV[0], 1, 1]);
                SV.style.backgroundColor = 'rgb(' + b.join(',') + ')';
                set_data(HSV);
                prevent(e);
            };
            set();
            function do_H(e) {
                var y = edge(point(H, e).y, 0, H_H);
                HSV[0] = (H_H - y) / H_H;
                H_point.style.top = (y - (H_point_H / 2)) + 'px';
                color(e);
            }
            function do_SV(e) {
                var o = point(SV, e),
                    x = edge(o.x, 0, SV_W),
                    y = edge(o.y, 0, SV_H);
                HSV[1] = 1 - ((SV_W - x) / SV_W);
                HSV[2] = (SV_H - y) / SV_H;
                SV_point.style.right = (SV_W - x - (SV_point_W / 2)) + 'px';
                SV_point.style.top = (y - (SV_point_H / 2)) + 'px';
                color(e);
            }
            function move(e) {
                if (drag_H) {
                    do_H(e), v = HSV2HEX(HSV);
                    if (!start_H) {
                        trigger("drag:h", [v, $]);
                        trigger("drag", [v, $]);
                        trigger_("h", [v, $]);
                    }
                }
                if (drag_SV) {
                    do_SV(e), v = HSV2HEX(HSV);
                    if (!start_SV) {
                        trigger("drag:sv", [v, $]);
                        trigger("drag", [v, $]);
                        trigger_("sv", [v, $]);
                    }
                }
                start_H = 0,
                start_SV = 0;
            }
            function stop(e) {
                var t = e.target,
                    k = drag_H ? "h" : "sv",
                    a = [HSV2HEX(HSV), $],
                    is_target = t === target || closest(t, target) === target,
                    is_picker = t === picker || closest(t, picker) === picker;
                if (!is_target && !is_picker) {
                    // click outside the target or picker element to exit
                    if (visible() && events !== false) $.exit(), trigger("exit", [$]), trigger_(0, a);
                } else {
                    if (is_picker) {
                        trigger("stop:" + k, a);
                        trigger("stop", a);
                        trigger_(k, a);
                    }
                }
                drag_H = 0,
                drag_SV = 0;
            }
            function down_H(e) {
                start_H = 1,
                drag_H = 1,
                move(e), prevent(e);
                trigger("start:h", [v, $]);
                trigger("start", [v, $]);
                trigger_("h", [v, $]);
            }
            function down_SV(e) {
                start_SV = 1,
                drag_SV = 1,
                move(e), prevent(e);
                trigger("start:sv", [v, $]);
                trigger("start", [v, $]);
                trigger_("sv", [v, $]);
            }
            if (!first) {
                on(on_down, H, down_H);
                on(on_down, SV, down_SV);
                on(on_move, doc, move);
                on(on_up, doc, stop);
                on(on_resize, win, fit);
            }
        } create(1);

        delay(function() {
            var a = [HSV2HEX(HSV), $];
            trigger("create", a);
            trigger_(0, a);
        }, 0);

        // fit to window
        $.fit = function(o) {
            var w = size(win),
                y = size(h),
                screen_w = w.w - y.w, // vertical scroll bar
                screen_h = w.h - h.clientHeight, // horizontal scroll bar
                ww = offset(win),
                to = offset(target);
            left = to.l + ww.l;
            top = to.t + ww.t + size(target).h; // drop!
            if (is_object(o)) {
                is_set(o[0]) && (left = o[0]);
                is_set(o[1]) && (top = o[1]);
            } else {
                var min_x = ww.l,
                    min_y = ww.t,
                    max_x = ww.l + w.w - P_W - screen_w,
                    max_y = ww.t + w.h - P_H - screen_h;
                left = edge(left, min_x, max_x) >> 0;
                top = edge(top, min_y, max_y) >> 0;
            }
            picker.style.left = left + 'px';
            picker.style.top = top + 'px';
            return trigger("fit", [$]), $;
        };

        // for event listener ID
        function fit() {
            return $.fit();
        }

        // set hidden color picker data
        $.set = function(a) {
            if (!is_set(a)) return get_data();
            if (is_string(a)) {
                a = $$.parse(a);
            }
            return set_data(a), set(), $;
        };

        // alias for `$.set()`
        $.get = function(a) {
            return get_data(a);
        };

        // register to global ...
        $.target = target;
        $.picker = picker;
        $.visible = false;
        $.on = add;
        $.off = remove;
        $.fire = trigger;
        $.hooks = hooks;
        $.enter = function(bucket) {
            return create(0, bucket);
        };

        // return the global object
        return $;

    });

})(window, document, 'CP');

/* FileSaver.js
 * A saveAs() FileSaver implementation.
 * 1.3.8
 * 2018-03-22 14:03:47
 *
 * By Eli Grey, https://eligrey.com
 * License: MIT
 *   See https://github.com/eligrey/FileSaver.js/blob/master/LICENSE.md
 */

/*global self */
/*jslint bitwise: true, indent: 4, laxbreak: true, laxcomma: true, smarttabs: true, plusplus: true */

/* @source http://purl.eligrey.com/github/FileSaver.js/blob/master/src/FileSaver.js */

//var saveAs = saveAs || (function(view) {
var saveAs = (function(view) {
    "use strict";
    // IE <10 is explicitly unsupported
    if (typeof view === "undefined" || typeof navigator !== "undefined" && /MSIE [1-9]\./.test(navigator.userAgent)) {
        return;
    }
    var doc = view.document
          // only get URL when necessary in case Blob.js hasn't overridden it yet
        , get_URL = function() {
            return view.URL || view.webkitURL || view;
        }
        , save_link = doc.createElementNS("http://www.w3.org/1999/xhtml", "a")
        , can_use_save_link = "download" in save_link
        , click = function(node) {
            var event = new MouseEvent("click");
            node.dispatchEvent(event);
        }
        , is_safari = /constructor/i.test(view.HTMLElement) || view.safari
        , is_chrome_ios =/CriOS\/[\d]+/.test(navigator.userAgent)
        , setImmediate = view.setImmediate || view.setTimeout
        , throw_outside = function(ex) {
            setImmediate(function() {
                throw ex;
            }, 0);
        }
        , force_saveable_type = "application/octet-stream"
        // the Blob API is fundamentally broken as there is no "downloadfinished" event to subscribe to
        , arbitrary_revoke_timeout = 1000 * 40 // in ms
        , revoke = function(file) {
            var revoker = function() {
                if (typeof file === "string") { // file is an object URL
                    get_URL().revokeObjectURL(file);
                } else { // file is a File
                    file.remove();
                }
            };
            setTimeout(revoker, arbitrary_revoke_timeout);
        }
        , dispatch = function(filesaver, event_types, event) {
            event_types = [].concat(event_types);
            var i = event_types.length;
            while (i--) {
                var listener = filesaver["on" + event_types[i]];
                if (typeof listener === "function") {
                    try {
                        listener.call(filesaver, event || filesaver);
                    } catch (ex) {
                        throw_outside(ex);
                    }
                }
            }
        }
        , auto_bom = function(blob) {
            // prepend BOM for UTF-8 XML and text/* types (including HTML)
            // note: your browser will automatically convert UTF-16 U+FEFF to EF BB BF
            //if (blob && /^\s*(?:text\/\S*|application\/xml|\S*\/\S*\+xml)\s*;.*charset\s*=\s*utf-8/i.test(blob.type)) {
            if (/^\s*(?:text\/\S*|application\/xml|\S*\/\S*\+xml)\s*;.*charset\s*=\s*utf-8/i.test(blob.type)) {
                return new Blob([String.fromCharCode(0xFEFF), blob], {type: blob.type});
            }
            return blob;
        }
        , FileSaver = function(blob, name, no_auto_bom) {
            if (!no_auto_bom) {
                blob = auto_bom(blob);
            }
            // First try a.download, then web filesystem, then object URLs
            var
                  filesaver = this
                , type = (blob) ? blob.type : undefined
                , force = type === force_saveable_type
                , object_url
                , dispatch_all = function() {
                    dispatch(filesaver, "writestart progress write writeend".split(" "));
                }
                // on any filesys errors revert to saving with object URLs
                , fs_error = function() {
                    if ((is_chrome_ios || (force && is_safari)) && view.FileReader) {
                        // Safari doesn't allow downloading of blob urls
                        var reader = new FileReader();
                        reader.onloadend = function() {
                            var url = is_chrome_ios ? reader.result : reader.result.replace(/^data:[^;]*;/, 'data:attachment/file;');
                            var urlTarget = '_blank';
                            var popup = view.open(url, urlTarget);
                            if(!popup) view.location.href = url;
                            url=undefined; // release reference before dispatching
                            filesaver.readyState = filesaver.DONE;
                            dispatch_all();
                        };
                        reader.readAsDataURL(blob);
                        filesaver.readyState = filesaver.INIT;
                        return;
                    }
                    // don't create more object URLs than needed
                    if (!object_url) object_url = get_URL().createObjectURL(blob);
                    if (force) {
                        view.location.href = object_url;
                    } else {
                        var opened = view.open(object_url, "_blank");
                        if (!opened) {
                            // Apple does not allow window.open, see https://developer.apple.com/library/safari/documentation/Tools/Conceptual/SafariExtensionGuide/WorkingwithWindowsandTabs/WorkingwithWindowsandTabs.html
                            view.location.href = object_url;
                        }
                    }
                    filesaver.readyState = filesaver.DONE;
                    dispatch_all();
                    revoke(object_url);
                }
            ;
            filesaver.readyState = filesaver.INIT;

            if (can_use_save_link) {
                if (!object_url) object_url = get_URL().createObjectURL(blob);
                setImmediate(function() {
                    save_link.href = object_url;
                    save_link.download = name;
                    click(save_link);
                    dispatch_all();
                    revoke(object_url);
                    filesaver.readyState = filesaver.DONE;
                }, 0);
                return;
            }

            fs_error();
        }
        , FS_proto = FileSaver.prototype
        , saveAs = function(blob, name, no_auto_bom) {
            return new FileSaver(blob, name || blob.name || "download", no_auto_bom);
        }
    ;

    // IE 10+ (native saveAs)
    if (typeof navigator !== "undefined" && navigator.msSaveOrOpenBlob) {
        return function(blob, name, no_auto_bom) {
            name = name || blob.name || "download";

            if (!no_auto_bom) {
                blob = auto_bom(blob);
            }
            return navigator.msSaveOrOpenBlob(blob, name);
        };
    }

    // todo: detect chrome extensions & packaged apps
    //save_link.target = "_blank";

    FS_proto.abort = function(){};
    FS_proto.readyState = FS_proto.INIT = 0;
    FS_proto.WRITING = 1;
    FS_proto.DONE = 2;

    FS_proto.error =
    FS_proto.onwritestart =
    FS_proto.onprogress =
    FS_proto.onwrite =
    FS_proto.onabort =
    FS_proto.onerror =
    FS_proto.onwriteend =
        null;

    return saveAs;
}(
       typeof self !== "undefined" && self
    || typeof window !== "undefined" && window
    || this
));

/*
 * JavaScript Canvas to Blob
 * https://github.com/blueimp/JavaScript-Canvas-to-Blob
 *
 * Copyright 2012, Sebastian Tschan
 * https://blueimp.net
 *
 * Licensed under the MIT license:
 * https://opensource.org/licenses/MIT
 *
 * Based on stackoverflow user Stoive's code snippet:
 * http://stackoverflow.com/q/4998908
 */

/* global atob, Blob, define */

;(function (window) {
  'use strict';

  var CanvasPrototype =
    window.HTMLCanvasElement && window.HTMLCanvasElement.prototype
  var hasBlobConstructor =
    window.Blob &&
    (function () {
      try {
        return Boolean(new Blob())
      } catch (e) {
        return false
      }
    })()
  var hasArrayBufferViewSupport =
    hasBlobConstructor &&
    window.Uint8Array &&
    (function () {
      try {
        return new Blob([new Uint8Array(100)]).size === 100
      } catch (e) {
        return false
      }
    })()
  var BlobBuilder =
    window.BlobBuilder ||
    window.WebKitBlobBuilder ||
    window.MozBlobBuilder ||
    window.MSBlobBuilder
  var dataURIPattern = /^data:((.*?)(;charset=.*?)?)(;base64)?,/
  var dataURLtoBlob =
    (hasBlobConstructor || BlobBuilder) &&
    window.atob &&
    window.ArrayBuffer &&
    window.Uint8Array &&
    function (dataURI) {
      var matches,
        mediaType,
        isBase64,
        dataString,
        byteString,
        arrayBuffer,
        intArray,
        i,
        bb
      // Parse the dataURI components as per RFC 2397
      matches = dataURI.match(dataURIPattern)
      if (!matches) {
        throw new Error('invalid data URI')
      }
      // Default to text/plain;charset=US-ASCII
      mediaType = matches[2]
        ? matches[1]
        : 'text/plain' + (matches[3] || ';charset=US-ASCII')
      isBase64 = !!matches[4]
      dataString = dataURI.slice(matches[0].length)
      if (isBase64) {
        // Convert base64 to raw binary data held in a string:
        byteString = atob(dataString)
      } else {
        // Convert base64/URLEncoded data component to raw binary:
        byteString = decodeURIComponent(dataString)
      }
      // Write the bytes of the string to an ArrayBuffer:
      arrayBuffer = new ArrayBuffer(byteString.length)
      intArray = new Uint8Array(arrayBuffer)
      for (i = 0; i < byteString.length; i += 1) {
        intArray[i] = byteString.charCodeAt(i)
      }
      // Write the ArrayBuffer (or ArrayBufferView) to a blob:
      if (hasBlobConstructor) {
        return new Blob([hasArrayBufferViewSupport ? intArray : arrayBuffer], {
          type: mediaType
        })
      }
      bb = new BlobBuilder()
      bb.append(arrayBuffer)
      return bb.getBlob(mediaType)
    }
  if (window.HTMLCanvasElement && !CanvasPrototype.toBlob) {
    if (CanvasPrototype.mozGetAsFile) {
      CanvasPrototype.toBlob = function (callback, type, quality) {
        var self = this
        setTimeout(function () {
          if (quality && CanvasPrototype.toDataURL && dataURLtoBlob) {
            callback(dataURLtoBlob(self.toDataURL(type, quality)))
          } else {
            callback(self.mozGetAsFile('blob', type))
          }
        })
      }
    } else if (CanvasPrototype.toDataURL && dataURLtoBlob) {
      CanvasPrototype.toBlob = function (callback, type, quality) {
        var self = this
        setTimeout(function () {
          callback(dataURLtoBlob(self.toDataURL(type, quality)))
        })
      }
    }
  }
  if (typeof define === 'function' && define.amd) {
    define(function () {
      return dataURLtoBlob
    })
  } else if (typeof module === 'object' && module.exports) {
    module.exports = dataURLtoBlob
  } else {
    window.dataURLtoBlob = dataURLtoBlob
  }
})(window)

/**
 * @author Jiyao Wang <wangjiy@ncbi.nlm.nih.gov> / https://github.com/ncbi/icn3d
 */

//import * as $ from 'jquery';

class HashUtilsCls {
    constructor(icn3dui) {
        this.icn3dui = icn3dui;
    }

    //Clone the "fromHash" and return the cloned hash.
    cloneHash(from) { this.icn3dui;
      let to = {};

      if(from === undefined) from = {};

      for(let i in from) {
        to[i] = from[i];
      }

      return to;
    }

    //Get the intersection of two hashes "atoms1" and "atoms2". The returned hash has atom index as key and 1 as value.
    intHash(atoms1, atoms2) { this.icn3dui;
        let results = {};

        if(atoms1 === undefined) atoms1 = {};
        if(atoms2 === undefined) atoms2 = {};

        if(Object.keys(atoms1).length < Object.keys(atoms2).length) {
            for (let i in atoms1) {
                if (atoms2 !== undefined && atoms2[i]) {
                    results[i] = atoms1[i];
                }
            }
        }
        else {
            for (let i in atoms2) {
                if (atoms1 !== undefined && atoms1[i]) {
                    results[i] = atoms2[i];
                }
            }
        }

        return results;
    }

    // get atoms in allAtoms, but not in "atoms"
    //Get atoms in "includeAtoms", but not in "excludeAtoms". The returned hash has atom index as key and 1 as value.
    exclHash(includeAtomsInput, excludeAtoms) { let me = this.icn3dui;
        if(includeAtomsInput === undefined) includeAtomsInput = {};
        if(excludeAtoms === undefined) excludeAtoms = {};

        let includeAtoms = me.hashUtilsCls.cloneHash(includeAtomsInput);

        for (let i in includeAtoms) {
            if (excludeAtoms !== undefined && excludeAtoms[i]) {
                delete includeAtoms[i];
            }
        }

        return includeAtoms;
    }

    //Get the union of two hashes "atoms1" and "atoms2". The returned hash has atom index as key and 1 as value.
    unionHash(atoms1, atoms2) { let me = this.icn3dui;
        // much slower
        //return me.hashUtilsCls.unionHashNotInPlace(atoms1, atoms2);

        // much faster
        return me.hashUtilsCls.unionHashInPlace(atoms1, atoms2);
    }

    unionHashInPlace(atoms1, atoms2) { this.icn3dui;
        if(atoms1 === undefined) atoms1 = {};
        if(atoms2 === undefined) atoms2 = {};

        $.extend(atoms1, atoms2);

        return atoms1;
    }

    unionHashNotInPlace(atoms1, atoms2) { this.icn3dui;
        let results = $.extend({}, atoms1, atoms2);

        return results;
    }

    //Get the intersection of two hashes "atoms1" and "atoms2". The returned hash has atom index as key and atom object as value.
    intHash2Atoms(atoms1, atoms2, allAtoms) { let me = this.icn3dui;
        return me.hashUtilsCls.hash2Atoms(me.hashUtilsCls.intHash(atoms1, atoms2), allAtoms);
    }

    // get atoms in allAtoms, but not in "atoms"
    //Get atoms in "includeAtoms", but not in "excludeAtoms". The returned hash has atom index as key and atom object as value.
    exclHash2Atoms(includeAtoms, excludeAtoms, allAtoms) { let me = this.icn3dui;
        return me.hashUtilsCls.hash2Atoms(me.hashUtilsCls.exclHash(includeAtoms, excludeAtoms), allAtoms);
    }

    //Get the union of two hashes "atoms1" and "atoms2". The returned hash has atom index as key and atom object as value.
    unionHash2Atoms(atoms1, atoms2, allAtoms) { let me = this.icn3dui;
        return me.hashUtilsCls.hash2Atoms(me.hashUtilsCls.unionHash(atoms1, atoms2), allAtoms);
    }

    //The input "hash" has atom index as key and 1 as value. The returned hash has atom index as key and atom object as value.
    hash2Atoms(hash, allAtoms) { this.icn3dui;
        let atoms = {};
        for(let i in hash) {
          atoms[i] = allAtoms[i];
        }

        return atoms;
    }

    hashvalue2array(hash) { this.icn3dui;
        //return $.map(hash, function(v) { return v; });

        let array = [];
        for(let i in hash) {
            array.push(hash[i]);
        }

        return array;
    }
}

/**
 * @author Jiyao Wang <wangjiy@ncbi.nlm.nih.gov> / https://github.com/ncbi/icn3d
 */



// import {ParasCls} from './parasCls.js';

class UtilsCls {
    constructor(icn3dui) {
        this.icn3dui = icn3dui;
    }

    //Determine whether the current browser is Internet Explorer.
    isIE() { this.icn3dui;
        //http://stackoverflow.com/questions/19999388/check-if-user-is-using-ie-with-jquery
        let ua = window.navigator.userAgent;
        let msie = ua.indexOf("MSIE ");

        if (msie > 0 || !!window.navigator.userAgent.match(/Trident.*rv\:11\./))      // If Internet Explorer
            return true;
        else                 // If another browser, return 0
            return false;
    }

    //Determine whether it is a mobile device.
    isMobile() { this.icn3dui;
        return /Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(window.navigator.userAgent);
    }

    //Determine whether it is a Mac.
    isMac() { this.icn3dui;
        return /Mac/i.test(window.navigator.userAgent);
    }

    isAndroid() { this.icn3dui;
      return /android/i.test(window.navigator.userAgent.toLowerCase());
    }

    isChrome() { this.icn3dui;
      return navigator.userAgent.includes("Chrome") && navigator.vendor.includes("Google Inc");
    }

    //Determine whether Session Storage is supported in your browser. Session Storage is not supported in Safari.
    isSessionStorageSupported() { this.icn3dui;
        return window.sessionStorage;
    }

    isLocalStorageSupported() { this.icn3dui;
      return window.localStorage;
    }

    // http://stackoverflow.com/questions/5623838/rgb-to-hex-and-hex-to-rgb
    hexToRgb(hex, a) { this.icn3dui;
         let result = /^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(hex);
         return result ? {
             r: parseInt(result[1], 16),
             g: parseInt(result[2], 16),
             b: parseInt(result[3], 16),
             a: a
         } : null;
    }

    //isCalphaPhosOnly(atomlist, atomname1, atomname2) {
    isCalphaPhosOnly(atomlist) { this.icn3dui;
          let bCalphaPhosOnly = false;

          let index = 0, testLength = 100; //30
          //var bOtherAtoms = false;
          let nOtherAtoms = 0;
          for(let i in atomlist) {
            if(index < testLength) {
              let atomName = atomlist[i].name;   
              if(!atomName) continue;
              atomName = atomName.trim();

              if(atomName !== "CA" && atomName !== "P" && atomName !== "O3'" && atomName !== "O3*") {
                //bOtherAtoms = true;
                //break;
                ++nOtherAtoms;
              }
            }
            else {
              break;
            }

            ++index;
          }

          //if(!bOtherAtoms) {
          if(nOtherAtoms < 0.5 * index) {
            bCalphaPhosOnly = true;
          }

          return bCalphaPhosOnly;
    }

    // from iview (http://istar.cse.cuhk.edu.hk/iview/)
    //Determine whether atom1 and atom2 have covalent bond.
    hasCovalentBond(atom0, atom1) { let me = this.icn3dui;
        let r = me.parasCls.covalentRadii[atom0.elem.toUpperCase()] + me.parasCls.covalentRadii[atom1.elem.toUpperCase()];

        //return atom0.coord.distanceToSquared(atom1.coord) < 1.3 * r * r;
        let dx = atom0.coord.x - atom1.coord.x;
        let dy = atom0.coord.y - atom1.coord.y;
        let dz = atom0.coord.z - atom1.coord.z;
        let distSq = dx*dx + dy*dy + dz*dz;

        // r(N) = 0.71, r(H) = 0.31, N-H in residues are about 1.5
        // factor = (1.5 / 1.02) * (1.5 / 1.02) = 2.16
        let factor = ((atom0.elem == 'N' && atom1.elem.substr(0,1) == 'H') || (atom1.elem == 'N' && atom0.elem.substr(0,1) == 'H')) ? 2.2 : 1.3;

        return distSq < factor * r * r;
    }

    //Convert a three-letter residue name to a one-letter residue abbreviation, e.g., 'LYS' to 'K', or ' A' to 'A' for nucleotides.
    residueName2Abbr(residueName) { this.icn3dui;
      let pos = residueName.indexOf(' ');
      if(pos > 0) {
          residueName = residueName.substr(0, pos);
      }

      switch(residueName) {
        case '  A':
          return 'A';
        case '  C':
          return 'C';
        case '  G':
          return 'G';
        case '  T':
          return 'T';
        case '  U':
          return 'U';
        case '  I':
          return 'I';
        case ' DA':
          return 'A';
        case ' DC':
          return 'C';
        case ' DG':
          return 'G';
        case ' DT':
          return 'T';
        case ' DU':
          return 'U';
        case ' DI':
          return 'I';
        case 'DA':
          return 'A';
        case 'DC':
          return 'C';
        case 'DG':
          return 'G';
        case 'DT':
          return 'T';
        case 'DU':
          return 'U';
        case 'DI':
          return 'I';
        case 'ALA':
          return 'A';
        case 'ARG':
          return 'R';
        case 'ASN':
          return 'N';
        case 'ASP':
          return 'D';
        case 'CYS':
          return 'C';
        case 'GLU':
          return 'E';
        case 'GLN':
          return 'Q';
        case 'GLY':
          return 'G';
        case 'HIS':
          return 'H';
        case 'ILE':
          return 'I';
        case 'LEU':
          return 'L';
        case 'LYS':
          return 'K';
        case 'MET':
          return 'M';
        case 'PHE':
          return 'F';
        case 'PRO':
          return 'P';
        case 'SER':
          return 'S';
        case 'THR':
          return 'T';
        case 'TRP':
          return 'W';
        case 'TYR':
          return 'Y';
        case 'VAL':
          return 'V';
        case 'SEC':
          return 'U';
    //        case 'PYL':
    //          return 'O';
    //          break;

        case 'HOH':
          return 'O';
        case 'WAT':
          return 'O';

        default:
          return residueName.trim();
      }
    }

    residueAbbr2Name(residueAbbr) { this.icn3dui;
      residueAbbr = residueAbbr.toUpperCase();

      if(residueAbbr.length > 1) {
          return residueAbbr;
      }

      switch(residueAbbr) {
        case 'A':
          return 'ALA';
        case 'R':
          return 'ARG';
        case 'N':
          return 'ASN';
        case 'D':
          return 'ASP';
        case 'C':
          return 'CYS';
        case 'E':
          return 'GLU';
        case 'Q':
          return 'GLN';
        case 'G':
          return 'GLY';
        case 'H':
          return 'HIS';
        case 'I':
          return 'ILE';
        case 'L':
          return 'LEU';
        case 'K':
          return 'LYS';
        case 'M':
          return 'MET';
        case 'F':
          return 'PHE';
        case 'P':
          return 'PRO';
        case 'S':
          return 'SER';
        case 'T':
          return 'THR';
        case 'W':
          return 'TRP';
        case 'Y':
          return 'TYR';
        case 'V':
          return 'VAL';
        case 'O':
          return 'HOH';

        default:
          return residueAbbr.trim();
      }
    }

    getJSONFromArray(inArray) { this.icn3dui;
        let jsonStr = '';
        for(let i = 0, il= inArray.length; i < il; ++i) {
            jsonStr += JSON.stringify(inArray[i]);
            if(i != il - 1) jsonStr += ', ';
        }
        return jsonStr;
    }

    checkFileAPI() { this.icn3dui;
         if(!window.File || !window.FileReader || !window.FileList || !window.Blob) {
            alert('The File APIs are not fully supported in this browser.');
         }
    }

    getIdArray(resid) { this.icn3dui;
        //var idArray = resid.split('_');
        let idArray = [];

        if(resid) {
            let pos1 = resid.indexOf('_');
            let pos2 = resid.lastIndexOf('_');
            idArray.push(resid.substr(0, pos1));
            idArray.push(resid.substr(pos1 + 1, pos2 - pos1 - 1));
            idArray.push(resid.substr(pos2 + 1));
        }

        return idArray;
    }

    compResid(a, b, type) { let me = this.icn3dui;
      let aArray = a.split(',');
      let bArray = b.split(',');
      let aIdArray, bIdArray;
      if(type == 'save1') {
        aIdArray = me.utilsCls.getIdArray(aArray[0]); //aArray[0].split('_');
        bIdArray = me.utilsCls.getIdArray(bArray[0]); //bArray[0].split('_');
      }
      else if(type == 'save2') {
        aIdArray = me.utilsCls.getIdArray(aArray[1]); //aArray[1].split('_');
        bIdArray = me.utilsCls.getIdArray(bArray[1]); //bArray[1].split('_');
      }
      let aChainid = aIdArray[0] + '_' + aIdArray[1];
      let bChainid = bIdArray[0] + '_' + bIdArray[1];
      let aResi = parseInt(aIdArray[2]);
      let bResi = parseInt(bIdArray[2]);
      if(aChainid > bChainid){
        return 1;
      }
      else if(aChainid < bChainid){
        return -1;
      }
      else if(aChainid == bChainid){
        return (aResi > bResi) ? 1 :(aResi < bResi) ? -1 : 0;
      }
    }

    toggle(id1, id2, id3, id4) { this.icn3dui;
      let itemArray = [id1, id2];
      for(let i in itemArray) {
          let item = itemArray[i];
          $("#" + item).toggleClass('ui-icon-plus');
          $("#" + item).toggleClass('ui-icon-minus');
      }

      itemArray = [id1, id2, id3, id4];
      for(let i in itemArray) {
          let item = itemArray[i];
          $("#" + item).toggleClass('icn3d-shown');
          $("#" + item).toggleClass('icn3d-hidden');
      }
    }

    setViewerWidthHeight(me, bRealSize) { //let me = this.icn3dui;
        if(me.bNode) {
            me.htmlCls.WIDTH = 400;
            me.htmlCls.HEIGHT = 400;
            return;
        }

        me.htmlCls.WIDTH = $( window ).width() - me.htmlCls.LESSWIDTH;
        me.htmlCls.HEIGHT = $( window ).height() - me.htmlCls.EXTRAHEIGHT - me.htmlCls.LESSHEIGHT;

        // width from css
        let viewer_width, viewer_height;

        if(!bRealSize && me.oriWidth !== undefined && me.cfg.width.toString().indexOf('%') === -1) {
            viewer_width = me.oriWidth;
            viewer_height = me.oriHeight;
        }
        else {
            // css width and height with the unit "px"
            viewer_width = $( "#" + me.pre + "viewer" ).css('width');
            viewer_height = $( "#" + me.pre + "viewer" ).css('height');

            viewer_width = (viewer_width) ? viewer_width.replace(/px/g, '') : me.htmlCls.WIDTH;
            viewer_height = (viewer_height) ? viewer_height.replace(/px/g, '') : me.htmlCls.HEIGHT;

            if(!bRealSize) {
                // width and height from input parameter
                if(me.cfg.width.toString().indexOf('%') !== -1) {
                  viewer_width = $( window ).width() * me.cfg.width.substr(0, me.cfg.width.toString().indexOf('%')) / 100.0 - me.htmlCls.LESSWIDTH;
                }
                else if(me.cfg.width) {
                  viewer_width = parseInt(me.cfg.width);
                }

                if(me.cfg.height.toString().indexOf('%') !== -1) {
                  viewer_height = $( window ).height() * me.cfg.height.substr(0, me.cfg.height.toString().indexOf('%')) / 100.0 - me.htmlCls.EXTRAHEIGHT - me.htmlCls.LESSHEIGHT;
                }
                else if(me.cfg.height) {
                  viewer_height = parseInt(me.cfg.height);
                }
            }
        }

        if(viewer_width && me.htmlCls.WIDTH > viewer_width) me.htmlCls.WIDTH = viewer_width;
        if(viewer_height && me.htmlCls.HEIGHT > viewer_height) me.htmlCls.HEIGHT = viewer_height;
    }

    sumArray(numArray) {
      let sum = 0;

      for(let i = 0, il = numArray.length; i < il; ++i) {
        sum += numArray[i];
      }

      return sum;
    }

    getMemDesc() {
      return "<div style='width:150px'><span style='color:red'>Red</span> and <span style='color:blue'>blue</span> membranes indicate <span style='color:red'>extracellular</span> and <span style='color:blue'>intracellular</span> membranes, respectively.<br><br></div>";
    }

    getStructures(atoms) { let me = this.icn3dui;
      let idHash = {};
      for(let i in atoms) {
          let structureid = me.icn3d.atoms[i].structure;
          idHash[structureid] = 1;
      }

      return idHash;
    }

    getHlStructures(atoms) { let me = this.icn3dui;
      if(!atoms) atoms = me.icn3d.hAtoms;

      return this.getStructures(atoms);
    }

    getDisplayedStructures(atoms) { let me = this.icn3dui;
      if(!atoms) atoms = me.icn3d.dAtoms;

      return this.getStructures(atoms);
    }

    getDateDigitStr() { this.icn3dui;
      let date = new Date();
      let monthStr =(date.getMonth() + 1).toString();
      if(date.getMonth() + 1 < 10) monthStr = '0' + monthStr;

      let dateStr = date.getDate().toString();
      if(date.getDate() < 10) dateStr = '0' + dateStr;

      return date.getFullYear().toString() + monthStr + dateStr;
    }
}

/**
 * @author Jiyao Wang <wangjiy@ncbi.nlm.nih.gov> / https://github.com/ncbi/icn3d
 */



class ParasCls {
    constructor(icn3dui) {
        this.icn3dui = icn3dui;

        // https://pubs.acs.org/doi/pdf/10.1021/acs.jproteome.8b00473
        this.glycanHash = {
            'GLC': {'c': '1E90FF', 's': 'sphere'},
            'BGC': {'c': '1E90FF', 's': 'sphere'},

            'NAG': {'c': '1E90FF', 's': 'cube'},
            'NDG': {'c': '1E90FF', 's': 'cube'},
            'GCS': {'c': '1E90FF', 's': 'cube'},
            'PA1': {'c': '1E90FF', 's': 'cube'},

            'GCU': {'c': '1E90FF', 's': 'cone'},
            'BDP': {'c': '1E90FF', 's': 'cone'},
            'G6D': {'c': '1E90FF', 's': 'cone'},

            'DDA': {'c': '1E90FF', 's': 'cylinder'},
            'B6D': {'c': '1E90FF', 's': 'cylinder'},
            'XXM': {'c': '1E90FF', 's': 'cylinder'},


            'MAN': {'c': '00FF00', 's': 'sphere'},
            'BMA': {'c': '00FF00', 's': 'sphere'},

            'BM3': {'c': '00FF00', 's': 'cube'},
            '95Z': {'c': '00FF00', 's': 'cube'},

            'MAV': {'c': '00FF00', 's': 'cone'},
            'BEM': {'c': '00FF00', 's': 'cone'},
            'RAM': {'c': '00FF00', 's': 'cone'},
            'RM4': {'c': '00FF00', 's': 'cone'},

            'TYV': {'c': '00FF00', 's': 'cylinder'},
            'ARA': {'c': '00FF00', 's': 'cylinder'},
            'ARB': {'c': '00FF00', 's': 'cylinder'},
            'KDN': {'c': '00FF00', 's': 'cylinder'},
            'KDM': {'c': '00FF00', 's': 'cylinder'},
            '6PZ': {'c': '00FF00', 's': 'cylinder'},
            'GMH': {'c': '00FF00', 's': 'cylinder'},
            'BDF': {'c': '00FF00', 's': 'cylinder'},


            'GAL': {'c': 'FFFF00', 's': 'sphere'},
            'GLA': {'c': 'FFFF00', 's': 'sphere'},

            'NGA': {'c': 'FFFF00', 's': 'cube'},
            'A2G': {'c': 'FFFF00', 's': 'cube'},
            'X6X': {'c': 'FFFF00', 's': 'cube'},
            '1GN': {'c': 'FFFF00', 's': 'cube'},

            'ADA': {'c': 'FFFF00', 's': 'cone'},
            'GTR': {'c': 'FFFF00', 's': 'cone'},

            'LDY': {'c': 'FFFF00', 's': 'cylinder'},
            'KDO': {'c': 'FFFF00', 's': 'cylinder'},
            'T6T': {'c': 'FFFF00', 's': 'cylinder'},


            'GUP': {'c': 'A52A2A', 's': 'sphere'},
            'GL0': {'c': 'A52A2A', 's': 'sphere'},

            'LGU': {'c': 'A52A2A', 's': 'cone'},

            'ABE': {'c': 'A52A2A', 's': 'cylinder'},
            'XYS': {'c': 'A52A2A', 's': 'cylinder'},
            'XYP': {'c': 'A52A2A', 's': 'cylinder'},
            'SOE': {'c': 'A52A2A', 's': 'cylinder'},


            'PZU': {'c': 'FF69B4', 's': 'cylinder'},
            'RIP': {'c': 'FF69B4', 's': 'cylinder'},
            '0MK': {'c': 'FF69B4', 's': 'cylinder'},


            'ALL': {'c': '8A2BE2', 's': 'sphere'},
            'AFD': {'c': '8A2BE2', 's': 'sphere'},

            'NAA': {'c': '8A2BE2', 's': 'cube'},

            'SIA': {'c': '8A2BE2', 's': 'cylinder'},
            'SIB': {'c': '8A2BE2', 's': 'cylinder'},
            'AMU': {'c': '8A2BE2', 's': 'cylinder'},


            'X0X': {'c': '1E90FF', 's': 'cone'},
            'X1X': {'c': '1E90FF', 's': 'cone'},

            'NGC': {'c': '1E90FF', 's': 'cylinder'},
            'NGE': {'c': '1E90FF', 's': 'cylinder'},


            '4N2': {'c': 'A0522D', 's': 'sphere'},

            'HSQ': {'c': 'A0522D', 's': 'cube'},

            'IDR': {'c': 'A0522D', 's': 'cone'},

            'MUR': {'c': 'A0522D', 's': 'cylinder'},


            'FUC': {'c': 'FF0000', 's': 'cone'},
            'FUL': {'c': 'FF0000', 's': 'cone'}
        };

        // added nucleotides and ions
        this.nucleotidesArray = ['  G', '  A', '  T', '  C', '  U', ' DG', ' DA', ' DT', ' DC', ' DU',
            'G', 'A', 'T', 'C', 'U', 'DG', 'DA', 'DT', 'DC', 'DU'];

        this.ionsArray = ['  K', ' NA', ' MG', ' AL', ' CA', ' TI', ' MN', ' FE', ' NI', ' CU', ' ZN', ' AG', ' BA',
            '  F', ' CL', ' BR', '  I', 'K', 'NA', 'MG', 'AL', 'CA', 'TI', 'MN', 'FE', 'NI', 'CU', 'ZN', 'AG', 'BA',
            'F', 'CL', 'BR', 'I'];

        this.cationsTrimArray = ['K', 'NA', 'MG', 'AL', 'CA', 'TI', 'MN', 'FE', 'NI', 'CU', 'ZN', 'AG', 'BA'];
        this.anionsTrimArray = ['F', 'CL', 'BR', 'I'];

        this.ionCharges = {K: 1, NA: 1, MG: 2, AL: 3, CA: 2, TI: 3, MN: 2, FE: 3, NI: 2, CU: 2, ZN: 2, AG: 1, BA: 2};

        this.vdwRadii = { // Hu, S.Z.; Zhou, Z.H.; Tsai, K.R. Acta Phys.-Chim. Sin., 2003, 19:1073.
             H: 1.08,           HE: 1.34,           LI: 1.75,           BE: 2.05,            B: 1.47,
             C: 1.49,            N: 1.41,            O: 1.40,            F: 1.39,           NE: 1.68,
             NA: 1.84,          MG: 2.05,           AL: 2.11,           SI: 2.07,            P: 1.92,
             S: 1.82,           CL: 1.83,           AR: 1.93,            K: 2.05,           CA: 2.21,
             SC: 2.16,          TI: 1.87,            V: 1.79,           CR: 1.89,           MN: 1.97,
             FE: 1.94,          CO: 1.92,           NI: 1.84,           CU: 1.86,           ZN: 2.10,
             GA: 2.08,          GE: 2.15,           AS: 2.06,           SE: 1.93,           BR: 1.98,
             KR: 2.12,          RB: 2.16,           SR: 2.24,            Y: 2.19,           ZR: 1.86,
             NB: 2.07,          MO: 2.09,           TC: 2.09,           RU: 2.07,           RH: 1.95,
             PD: 2.02,          AG: 2.03,           CD: 2.30,           IN: 2.36,           SN: 2.33,
             SB: 2.25,          TE: 2.23,            I: 2.23,           XE: 2.21,           CS: 2.22,
             BA: 2.51,          LA: 2.40,           CE: 2.35,           PR: 2.39,           ND: 2.29,
             PM: 2.36,          SM: 2.29,           EU: 2.33,           GD: 2.37,           TB: 2.21,
             DY: 2.29,          HO: 2.16,           ER: 2.35,           TM: 2.27,           YB: 2.42,
             LU: 2.21,          HF: 2.12,           TA: 2.17,            W: 2.10,           RE: 2.17,
             OS: 2.16,          IR: 2.02,           PT: 2.09,           AU: 2.17,           HG: 2.09,
             TL: 2.35,          PB: 2.32,           BI: 2.43,           PO: 2.29,           AT: 2.36,
             RN: 2.43,          FR: 2.56,           RA: 2.43,           AC: 2.60,           TH: 2.37,
             PA: 2.43,           U: 2.40,           NP: 2.21,           PU: 2.56,           AM: 2.56,
             CM: 2.56,          BK: 2.56,           CF: 2.56,           ES: 2.56,           FM: 2.56
        };

        this.covalentRadii = { // http://en.wikipedia.org/wiki/Covalent_radius
             H: 0.31,           HE: 0.28,           LI: 1.28,           BE: 0.96,            B: 0.84,
             C: 0.76,            N: 0.71,            O: 0.66,            F: 0.57,           NE: 0.58,
             NA: 1.66,          MG: 1.41,           AL: 1.21,           SI: 1.11,            P: 1.07,
             S: 1.05,           CL: 1.02,           AR: 1.06,            K: 2.03,           CA: 1.76,
             SC: 1.70,          TI: 1.60,            V: 1.53,           CR: 1.39,           MN: 1.39,
             FE: 1.32,          CO: 1.26,           NI: 1.24,           CU: 1.32,           ZN: 1.22,
             GA: 1.22,          GE: 1.20,           AS: 1.19,           SE: 1.20,           BR: 1.20,
             KR: 1.16,          RB: 2.20,           SR: 1.95,            Y: 1.90,           ZR: 1.75,
             NB: 1.64,          MO: 1.54,           TC: 1.47,           RU: 1.46,           RH: 1.42,
             PD: 1.39,          AG: 1.45,           CD: 1.44,           IN: 1.42,           SN: 1.39,
             SB: 1.39,          TE: 1.38,            I: 1.39,           XE: 1.40,           CS: 2.44,
             BA: 2.15,          LA: 2.07,           CE: 2.04,           PR: 2.03,           ND: 2.01,
             PM: 1.99,          SM: 1.98,           EU: 1.98,           GD: 1.96,           TB: 1.94,
             DY: 1.92,          HO: 1.92,           ER: 1.89,           TM: 1.90,           YB: 1.87,
             LU: 1.87,          HF: 1.75,           TA: 1.70,            W: 1.62,           RE: 1.51,
             OS: 1.44,          IR: 1.41,           PT: 1.36,           AU: 1.36,           HG: 1.32,
             TL: 1.45,          PB: 1.46,           BI: 1.48,           PO: 1.40,           AT: 1.50,
             RN: 1.50,          FR: 2.60,           RA: 2.21,           AC: 2.15,           TH: 2.06,
             PA: 2.00,           U: 1.96,           NP: 1.90,           PU: 1.87,           AM: 1.80,
             CM: 1.69
        };

    /*
        this.surfaces = {
            1: undefined,
            2: undefined,
            3: undefined,
            4: undefined
        };
    */

        //'C': this.thr(0xC8C8C8),
        this.atomColors = {
            'H': this.thr(0xFFFFFF),       'He': this.thr(0xFFC0CB),      'HE': this.thr(0xFFC0CB),
            'Li': this.thr(0xB22222),      'LI': this.thr(0xB22222),      'B': this.thr(0x00FF00),
            'C': this.thr(0xAAAAAA),       'N': this.thr(0x0000FF),       'O': this.thr(0xF00000),
            'F': this.thr(0xDAA520),       'Na': this.thr(0x0000FF),      'NA': this.thr(0x0000FF),
            'Mg': this.thr(0x228B22),      'MG': this.thr(0x228B22),      'Al': this.thr(0x808090),
            'AL': this.thr(0x808090),      'Si': this.thr(0xDAA520),      'SI': this.thr(0xDAA520),
            'P': this.thr(0xFFA500),       'S': this.thr(0xFFC832),       'Cl': this.thr(0x00FF00),
            'CL': this.thr(0x00FF00),      'Ca': this.thr(0x808090),      'CA': this.thr(0x808090),
            'Ti': this.thr(0x808090),      'TI': this.thr(0x808090),      'Cr': this.thr(0x808090),
            'CR': this.thr(0x808090),      'Mn': this.thr(0x808090),      'MN': this.thr(0x808090),
            'Fe': this.thr(0xFFA500),      'FE': this.thr(0xFFA500),      'Ni': this.thr(0xA52A2A),
            'NI': this.thr(0xA52A2A),      'Cu': this.thr(0xA52A2A),      'CU': this.thr(0xA52A2A),
            'Zn': this.thr(0xA52A2A),      'ZN': this.thr(0xA52A2A),      'Br': this.thr(0xA52A2A),
            'BR': this.thr(0xA52A2A),      'Ag': this.thr(0x808090),      'AG': this.thr(0x808090),
            'I': this.thr(0xA020F0),       'Ba': this.thr(0xFFA500),      'BA': this.thr(0xFFA500),
            'Au': this.thr(0xDAA520),      'AU': this.thr(0xDAA520)
        };

        this.atomnames = {
            'H': 'Hydrogen',        'HE': 'Helium',         'LI': 'Lithium',        'B': 'Boron',           
            'C': 'Carbon',          'N': 'Nitrogen',        'O': 'Oxygen',          'F': 'Fluorine',       
            'NA': 'Sodium',         'MG': 'Magnesium',      'AL': 'Aluminum',       'SI': 'Silicon',      
            'P': 'Phosphorus',      'S': 'Sulfur',          'CL': 'Chlorine',       'CA': 'Calcium',      
            'TI': 'Titanium',       'CR': 'Chromium',       'MN': 'Manganese',      'FE': 'Iron',      
            'NI': 'Nickel',         'CU': 'Copper',         'ZN': 'Zinc',           'BR': 'Bromine',
            'AG': 'Silver',         'I': 'Iodine',          'BA': 'Barium',         'AU': 'Gold'
        };

        this.defaultAtomColor = this.thr(0xCCCCCC);

        this.stdChainColors = [
            // first 6 colors from MMDB
            this.thr(0xFF00FF),            this.thr(0x0000FF),            this.thr(0x996633),
            this.thr(0x00FF99),            this.thr(0xFF9900),            this.thr(0xFF6666),
            this.thr(0x32CD32),            this.thr(0x1E90FF),            this.thr(0xFA8072),
            this.thr(0xFFA500),            this.thr(0x00CED1),            this.thr(0xFF69B4),
            this.thr(0x00FF00),            this.thr(0x0000FF),            this.thr(0xFF0000),
            this.thr(0xFFFF00),            this.thr(0x00FFFF),            this.thr(0xFF00FF),
            this.thr(0x3CB371),            this.thr(0x4682B4),            this.thr(0xCD5C5C),
            this.thr(0xFFE4B5),            this.thr(0xAFEEEE),            this.thr(0xEE82EE),
            this.thr(0x006400),            this.thr(0x00008B),            this.thr(0x8B0000),
            this.thr(0xCD853F),            this.thr(0x008B8B),            this.thr(0x9400D3)
        ];

        this.backgroundColors = {
            'black': this.thr(0x000000),
             'grey': this.thr(0xCCCCCC),
            'white': this.thr(0xFFFFFF),
            'transparent': this.thr(0xFFFFFF) //this.thr(0x000000)
        };

        this.residueColors = {
            ALA: this.thr(0xC8C8C8),       ARG: this.thr(0x145AFF),       ASN: this.thr(0x00DCDC),
            ASP: this.thr(0xE60A0A),       CYS: this.thr(0xE6E600),       GLN: this.thr(0x00DCDC),
            GLU: this.thr(0xE60A0A),       GLY: this.thr(0xEBEBEB),       HIS: this.thr(0x8282D2),
            ILE: this.thr(0x0F820F),       LEU: this.thr(0x0F820F),       LYS: this.thr(0x145AFF),
            MET: this.thr(0xE6E600),       PHE: this.thr(0x3232AA),       PRO: this.thr(0xDC9682),
            SER: this.thr(0xFA9600),       THR: this.thr(0xFA9600),       TRP: this.thr(0xB45AB4),
            TYR: this.thr(0x3232AA),       VAL: this.thr(0x0F820F),       ASX: this.thr(0xFF69B4),
            GLX: this.thr(0xFF69B4),         'G': this.thr(0x008000),       'A': this.thr(0x6080FF),
            'T': this.thr(0xFF8000),         'C': this.thr(0xFF0000),       'U': this.thr(0xFF8000),
            'DG': this.thr(0x008000),       'DA': this.thr(0x6080FF),      'DT': this.thr(0xFF8000),
            'DC': this.thr(0xFF0000),       'DU': this.thr(0xFF8000)
        };

        // calculated in iCn3D, the value could fluctuate 10-20 in different proteins
        this.residueArea = {
            ALA: 247,       ARG: 366,       ASN: 290,       ASP: 285,       CYS: 271,
            GLN: 336,       GLU: 325,       GLY: 217,       HIS: 340,       ILE: 324,
            LEU: 328,       LYS: 373,       MET: 346,       PHE: 366,       PRO: 285,
            SER: 265,       THR: 288,       TRP: 414,       TYR: 387,       VAL: 293,
            ASX: 290,       GLX: 336,         'G': 520,       'A': 507,       'T': 515,
            'C': 467,         'U': 482,      'DG': 520,      'DA': 507,      'DT': 515,
            'DC': 467,       'DU': 482
        };

        this.defaultResidueColor = this.thr(0xBEA06E);

        this.chargeColors = {
            // charged residues
            '  G': this.thr(0xFF0000),     '  A': this.thr(0xFF0000),     '  T': this.thr(0xFF0000),
            '  C': this.thr(0xFF0000),     '  U': this.thr(0xFF0000),     ' DG': this.thr(0xFF0000),
            ' DA': this.thr(0xFF0000),     ' DT': this.thr(0xFF0000),     ' DC': this.thr(0xFF0000),
            ' DU': this.thr(0xFF0000),       'G': this.thr(0xFF0000),       'A': this.thr(0xFF0000),
            'T': this.thr(0xFF0000),         'C': this.thr(0xFF0000),       'U': this.thr(0xFF0000),
            'DG': this.thr(0xFF0000),       'DA': this.thr(0xFF0000),      'DT': this.thr(0xFF0000),
            'DC': this.thr(0xFF0000),       'DU': this.thr(0xFF0000),     'ARG': this.thr(0x0000FF),
            'LYS': this.thr(0x0000FF),     'ASP': this.thr(0xFF0000),     'GLU': this.thr(0xFF0000),
            'HIS': this.thr(0x8080FF),     'GLY': this.thr(0x888888),     'PRO': this.thr(0x888888),
            'ALA': this.thr(0x888888),     'VAL': this.thr(0x888888),     'LEU': this.thr(0x888888),
            'ILE': this.thr(0x888888),     'PHE': this.thr(0x888888),     'SER': this.thr(0x888888),
            'THR': this.thr(0x888888),     'ASN': this.thr(0x888888),     'GLN': this.thr(0x888888),
            'TYR': this.thr(0x888888),     'MET': this.thr(0x888888),     'CYS': this.thr(0x888888),
            'TRP': this.thr(0x888888)
        };

        this.hydrophobicColors = {
            // charged residues
            '  G': this.thr(0xFF0000),     '  A': this.thr(0xFF0000),     '  T': this.thr(0xFF0000),
            '  C': this.thr(0xFF0000),     '  U': this.thr(0xFF0000),     ' DG': this.thr(0xFF0000),
            ' DA': this.thr(0xFF0000),     ' DT': this.thr(0xFF0000),     ' DC': this.thr(0xFF0000),
            ' DU': this.thr(0xFF0000),       'G': this.thr(0xFF0000),       'A': this.thr(0xFF0000),
            'T': this.thr(0xFF0000),         'C': this.thr(0xFF0000),       'U': this.thr(0xFF0000),
            'DG': this.thr(0xFF0000),       'DA': this.thr(0xFF0000),      'DT': this.thr(0xFF0000),
            'DC': this.thr(0xFF0000),       'DU': this.thr(0xFF0000),     'ARG': this.thr(0x0000FF),
            'LYS': this.thr(0x0000FF),     'ASP': this.thr(0xFF0000),     'GLU': this.thr(0xFF0000),
            'HIS': this.thr(0x8080FF),

            //this.thr().setHSL(1/3.0, 1, 0.5 + 0.5 * ( + 0.81)/(1.14 + 0.81)),
            // hydrophobic
            // https://en.m.wikipedia.org/wiki/Hydrophobicity_scales#Wimley%E2%80%93White_whole_residue_hydrophobicity_scales
            'TRP': this.thr().setHSL(1/3.0, 1, 0.5 + 0.5 * (-2.09 + 2.09) / (0 + 2.09)),
            'PHE': this.thr().setHSL(1/3.0, 1, 0.5 + 0.5 * (-1.71 + 2.09) / (0 + 2.09)),
            'LEU': this.thr().setHSL(1/3.0, 1, 0.5 + 0.5 * (-1.25 + 2.09) / (0 + 2.09)),
            'ILE': this.thr().setHSL(1/3.0, 1, 0.5 + 0.5 * (-1.12 + 2.09) / (0 + 2.09)),
            'TYR': this.thr().setHSL(1/3.0, 1, 0.5 + 0.5 * (-0.71 + 2.09) / (0 + 2.09)),
            'MET': this.thr().setHSL(1/3.0, 1, 0.5 + 0.5 * (-0.67 + 2.09) / (0 + 2.09)),
            'VAL': this.thr().setHSL(1/3.0, 1, 0.5 + 0.5 * (-0.46 + 2.09) / (0 + 2.09)),
            'CYS': this.thr().setHSL(1/3.0, 1, 0.5 + 0.5 * (-0.02 + 2.09) / (0 + 2.09)),

            // polar
            'PRO': this.thr().setHSL(1/6.0, 1, 0.5 + 0.5 * (-0.14 + 1.15) / (0 + 1.15)),
            'THR': this.thr().setHSL(1/6.0, 1, 0.5 + 0.5 * (-0.25 + 1.15) / (0 + 1.15)),
            'SER': this.thr().setHSL(1/6.0, 1, 0.5 + 0.5 * (-0.46 + 1.15) / (0 + 1.15)),
            'ALA': this.thr().setHSL(1/6.0, 1, 0.5 + 0.5 * (-0.50 + 1.15) / (0 + 1.15)),
            'GLN': this.thr().setHSL(1/6.0, 1, 0.5 + 0.5 * (-0.77 + 1.15) / (0 + 1.15)),
            'ASN': this.thr().setHSL(1/6.0, 1, 0.5 + 0.5 * (-0.85 + 1.15) / (0 + 1.15)),
            'GLY': this.thr().setHSL(1/6.0, 1, 0.5 + 0.5 * (-1.15 + 1.15) / (0 + 1.15))
        };

        this.normalizedHPColors = {
            // charged residues
            '  G': this.thr(0xFFFFFF),     '  A': this.thr(0xFFFFFF),     '  T': this.thr(0xFFFFFF),
            '  C': this.thr(0xFFFFFF),     '  U': this.thr(0xFFFFFF),     ' DG': this.thr(0xFFFFFF),
            ' DA': this.thr(0xFFFFFF),     ' DT': this.thr(0xFFFFFF),     ' DC': this.thr(0xFFFFFF),
            ' DU': this.thr(0xFFFFFF),       'G': this.thr(0xFFFFFF),       'A': this.thr(0xFFFFFF),
            'T': this.thr(0xFFFFFF),         'C': this.thr(0xFFFFFF),       'U': this.thr(0xFFFFFF),
            'DG': this.thr(0xFFFFFF),       'DA': this.thr(0xFFFFFF),      'DT': this.thr(0xFFFFFF),
            'DC': this.thr(0xFFFFFF),       'DU': this.thr(0xFFFFFF),     'ARG': this.thr(0xFFFFFF),
            'LYS': this.thr(0xFFFFFF),     'ASP': this.thr(0xFFFFFF),     'GLU': this.thr(0xFFFFFF),
            'HIS': this.thr(0xFFFFFF),

            //this.thr().setHSL(1/3.0, 1, 0.5 + 0.5 * ( + 0.81)/(1.14 + 0.81)),
            // hydrophobic
            // https://en.m.wikipedia.org/wiki/Hydrophobicity_scales#Wimley%E2%80%93White_whole_residue_hydrophobicity_scales
            // 1.15 ~ -2.09: white ~ green
            'TRP': this.thr().setHSL(1/3.0, 1, 0.5 + 0.5 * (-2.09 + 2.09) / 3.24),
            'PHE': this.thr().setHSL(1/3.0, 1, 0.5 + 0.5 * (-1.71 + 2.09) / 3.24),
            'LEU': this.thr().setHSL(1/3.0, 1, 0.5 + 0.5 * (-1.25 + 2.09) / 3.24),
            'ILE': this.thr().setHSL(1/3.0, 1, 0.5 + 0.5 * (-1.12 + 2.09) / 3.24),
            'TYR': this.thr().setHSL(1/3.0, 1, 0.5 + 0.5 * (-0.71 + 2.09) / 3.24),
            'MET': this.thr().setHSL(1/3.0, 1, 0.5 + 0.5 * (-0.67 + 2.09) / 3.24),
            'VAL': this.thr().setHSL(1/3.0, 1, 0.5 + 0.5 * (-0.46 + 2.09) / 3.24),
            'CYS': this.thr().setHSL(1/3.0, 1, 0.5 + 0.5 * (-0.02 + 2.09) / 3.24),

            // polar
            'PRO': this.thr().setHSL(1/3.0, 1, 0.5 + 0.5 * (0.14 + 2.09) / 3.24),
            'THR': this.thr().setHSL(1/3.0, 1, 0.5 + 0.5 * (0.25 + 2.09) / 3.24),
            'SER': this.thr().setHSL(1/3.0, 1, 0.5 + 0.5 * (0.46 + 2.09) / 3.24),
            'ALA': this.thr().setHSL(1/3.0, 1, 0.5 + 0.5 * (0.50 + 2.09) / 3.24),
            'GLN': this.thr().setHSL(1/3.0, 1, 0.5 + 0.5 * (0.77 + 2.09) / 3.24),
            'ASN': this.thr().setHSL(1/3.0, 1, 0.5 + 0.5 * (0.85 + 2.09) / 3.24),
            'GLY': this.thr().setHSL(1/3.0, 1, 0.5 + 0.5 * (1.15 + 2.09) / 3.24)
        };

        this.hydrophobicValues = {
            // charged residues, larger than max polar (1.15)
            '  G': 3,     '  A': 3,     '  T': 3,
            '  C': 3,     '  U': 3,     ' DG': 3,
            ' DA': 3,     ' DT': 3,     ' DC': 3,
            ' DU': 3,       'G': 3,       'A': 3,
            'T': 3,         'C': 3,       'U': 3,
            'DG': 3,       'DA': 3,      'DT': 3,
            'DC': 3,       'DU': 3,     'ARG': 1.5,
            'LYS': 1.5,     'ASP': 3,     'GLU': 3,
            'HIS': 2,

            // hydrophobic
            // https://en.m.wikipedia.org/wiki/Hydrophobicity_scales#Wimley%E2%80%93White_whole_residue_hydrophobicity_scales
            // 1.15 ~ -2.09: white ~ green
            'TRP': -2.09,
            'PHE': -1.71,
            'LEU': -1.25,
            'ILE': -1.12,
            'TYR': -0.71,
            'MET': -0.67,
            'VAL': -0.46,
            'CYS': -0.02,

            // polar
            'PRO': 0.14,
            'THR': 0.25,
            'SER': 0.46,
            'ALA': 0.50,
            'GLN': 0.77,
            'ASN': 0.85,
            'GLY': 1.15
        };

        this.residueAbbrev = {
            ALA: "A (Ala)",       ARG: "R (Arg)",       ASN: "N (Asn)",
            ASP: "D (Asp)",       CYS: "C (Cys)",       GLN: "Q (Gln)",
            GLU: "E (Glu)",       GLY: "G (Gly)",       HIS: "H (His)",
            ILE: "I (Ile)",       LEU: "L (Leu)",       LYS: "K (Lys)",
            MET: "M (Met)",       PHE: "F (Phe)",       PRO: "P (Pro)",
            SER: "S (Ser)",       THR: "T (Thr)",       TRP: "W (Trp)",
            TYR: "Y (Tyr)",       VAL: "V (Val)",       
            //ASX: "B (Asx)",       GLX: "Z (Glx)",   
            ASX: "X (Asx)",       GLX: "X (Glx)",       
            'G': "Guanine",       'A': "Adenine",
            'T': "Thymine",         'C': "Cytosine",       'U': "Uracil",
            'DG': "deoxy-Guanine",       'DA': "deoxy-Adenine",      'DT': "deoxy-Thymine",
            'DC': "deoxy-Cytosine",       'DU': 'deoxy-Uracil'
        };

        this.ssColors = {
            helix: this.thr(0xFF0000),
            sheet: this.thr(0x008000),
             coil: this.thr(0x6080FF) //this.thr(0xEEEEEE) //this.thr(0x6080FF)
        };

        this.ssColors2 = {
            helix: this.thr(0xFF0000),
            sheet: this.thr(0xFFC800),
             coil: this.thr(0x6080FF) //this.thr(0xEEEEEE) //this.thr(0x6080FF)
        };

        this.resn2restype = {
            "ALA": 1, "ARG": 4, "ASN": 7, "ASP": 10, "CYS": 13, "GLN": 16, "GLU": 19, "GLY": 22, "HIS": 25, "ILE": 28, "LEU": 31, "LYS": 34, "MET": 37, "PHE": 40, "PRO": 43, "SER": 46, "THR": 49, "TRP": 52, "TYR": 55, "VAL": 58
        };

        this.nuclMainArray = ["C1'", "C1*", "C2'", "C2*", "C3'", "C3*", "C4'", "C4*", "C5'", "C5*", "O3'", "O3*", "O4'", "O4*", "O5'", "O5*", "P", "OP1", "O1P", "OP2", "O2P"];

        // https://www.ncbi.nlm.nih.gov/Class/FieldGuide/BLOSUM62.txt, range from -4 to 11
        this.b62ResArray = ['A', 'R', 'N', 'D', 'C', 'Q', 'E', 'G', 'H', 'I', 'L', 'K', 'M', 'F',
            'P', 'S', 'T', 'W', 'Y', 'V', 'B', 'Z', 'X', '*']; // length: 24
        this.b62Matrix = [
            [4, -1, -2, -2, 0, -1, -1, 0, -2, -1, -1, -1, -1, -2, -1, 1, 0, -3, -2, 0, -2, -1, 0, -4],
            [-1, 5, 0, -2, -3, 1, 0, -2, 0, -3, -2, 2, -1, -3, -2, -1, -1, -3, -2, -3, -1, 0, -1, -4],
            [-2, 0, 6, 1, -3, 0, 0, 0, 1, -3, -3, 0, -2, -3, -2, 1, 0, -4, -2, -3, 3, 0, -1, -4],
            [-2, -2, 1, 6, -3, 0, 2, -1, -1, -3, -4, -1, -3, -3, -1, 0, -1, -4, -3, -3, 4, 1, -1, -4],
            [0, -3, -3, -3, 9, -3, -4, -3, -3, -1, -1, -3, -1, -2, -3, -1, -1, -2, -2, -1, -3, -3, -2, -4],
            [-1, 1, 0, 0, -3, 5, 2, -2, 0, -3, -2, 1, 0, -3, -1, 0, -1, -2, -1, -2, 0, 3, -1, -4],
            [-1, 0, 0, 2, -4, 2, 5, -2, 0, -3, -3, 1, -2, -3, -1, 0, -1, -3, -2, -2, 1, 4, -1, -4],
            [0, -2, 0, -1, -3, -2, -2, 6, -2, -4, -4, -2, -3, -3, -2, 0, -2, -2, -3, -3, -1, -2, -1, -4],
            [-2, 0, 1, -1, -3, 0, 0, -2, 8, -3, -3, -1, -2, -1, -2, -1, -2, -2, 2, -3, 0, 0, -1, -4],
            [-1, -3, -3, -3, -1, -3, -3, -4, -3, 4, 2, -3, 1, 0, -3, -2, -1, -3, -1, 3, -3, -3, -1, -4],
            [-1, -2, -3, -4, -1, -2, -3, -4, -3, 2, 4, -2, 2, 0, -3, -2, -1, -2, -1, 1, -4, -3, -1, -4],
            [-1, 2, 0, -1, -3, 1, 1, -2, -1, -3, -2, 5, -1, -3, -1, 0, -1, -3, -2, -2, 0, 1, -1, -4],
            [-1, -1, -2, -3, -1, 0, -2, -3, -2, 1, 2, -1, 5, 0, -2, -1, -1, -1, -1, 1, -3, -1, -1, -4],
            [-2, -3, -3, -3, -2, -3, -3, -3, -1, 0, 0, -3, 0, 6, -4, -2, -2, 1, 3, -1, -3, -3, -1, -4],
            [-1, -2, -2, -1, -3, -1, -1, -2, -2, -3, -3, -1, -2, -4, 7, -1, -1, -4, -3, -2, -2, -1, -2, -4],
            [1, -1, 1, 0, -1, 0, 0, 0, -1, -2, -2, 0, -1, -2, -1, 4, 1, -3, -2, -2, 0, 0, 0, -4],
            [0, -1, 0, -1, -1, -1, -1, -2, -2, -1, -1, -1, -1, -2, -1, 1, 5, -2, -2, 0, -1, -1, 0, -4],
            [-3, -3, -4, -4, -2, -2, -3, -2, -2, -3, -2, -3, -1, 1, -4, -3, -2, 11, 2, -3, -4, -3, -2, -4],
            [-2, -2, -2, -3, -2, -1, -2, -3, 2, -1, -1, -2, -1, 3, -3, -2, -2, 2, 7, -1, -3, -2, -1, -4],
            [0, -3, -3, -3, -1, -2, -2, -3, -3, 3, 1, -2, 1, -1, -2, -2, 0, -3, -1, 4, -3, -2, -1, -4],
            [-2, -1, 3, 4, -3, 0, 1, -1, 0, -3, -4, 0, -3, -3, -2, 0, -1, -4, -3, -3, 4, 1, -1, -4],
            [-1, 0, 0, 1, -3, 3, 4, -2, 0, -3, -3, 1, -1, -3, -1, 0, -1, -3, -2, -2, 1, 4, -1, -4],
            [0, -1, -1, -1, -2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -2, 0, 0, -2, -1, -1, -1, -1, -1, -4],
            [-4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, 1],
        ];
    }

    thr(color) { this.icn3dui;
        if(color == '#0') color = '#000';
        return new THREE.Color(color);
    }
}

/**
 * @author Jiyao Wang <wangjiy@ncbi.nlm.nih.gov> / https://github.com/ncbi/icn3d
 */

class MyEventCls {
    constructor(icn3dui) {
        this.icn3dui = icn3dui;
    }

    onId(id, eventName, myFunction) { this.icn3dui;
        if(Object.keys(window).length < 2) return;

        if(id.substr(0, 1) == '#') id = id.substr(1);
        if(document.getElementById(id)) {
            let eventArray = eventName.split(' ');
            eventArray.forEach(event => {
                document.getElementById(id).addEventListener(event, myFunction);
            });
        }
    }

    onIds(idArray, eventName, myFunction) { let me = this.icn3dui;
        let bArray = Array.isArray(idArray);
        if(bArray) {
            idArray.forEach(id => {
                me.myEventCls.onId(id, eventName, myFunction);
            });
        }
        else {
            me.myEventCls.onId(idArray, eventName, myFunction);
        }
    }

    // CSS selector such as class
/*
    onSel(selector, eventName, myFunction) { let me = this.icn3dui;
        let elemArray = document.querySelectorAll(selector); // non-live
        elemArray.forEach(elem => {
            let eventArray = eventName.split(' ');
            eventArray.forEach(event => {
                elem.addEventListener(event, myFunction);
            });
        });
    }

    onSelClass(selector, eventName, myFunction) { let me = this.icn3dui;
        selector = selector.replace(/\./gi, '');
        let classArray = selector.split(',');
        classArray.forEach(item => {
            let elemArray = document.getElementsByClassName(item.trim()); // live
            if(Array.isArray(elemArray)) {
                elemArray.forEach(elem => {
                    let eventArray = eventName.split(' ');
                    eventArray.forEach(event => {
                        elem.addEventListener(event, myFunction);
                    });
                });
            }
        });
    }
*/
}

// from Thomas Madej at NCBI
/* A routine to return the superposition rmsd for 'n' pairs of corresponding
 * points.  It also returns the translation vectors and rotation matrix.
 *
 * Based on the appendix in the paper:
 *
 *  A.D. McLachlan, "Gene Duplications in the Structural Evolution of
 *  Chymotrypsin", J. Mol. Biol. 128 (1979) 49-79.
 */



class RmsdSuprCls {
    constructor(icn3dui) {
        this.icn3dui = icn3dui;
    }

    getRmsdSuprCls(co1, co2, n) { let me = this.icn3dui;
    //    let TINY0 = 1.0e-10;
        let supr;
        let rot = new Array(9);

        let i, k, flag;
        //double cp[3], cq[3];
        let cp = new THREE.Vector3(), cq = new THREE.Vector3();

        let da, ra, rb, d1, d2, d3, e, s, v;
        //double ap[MAX_RES][3], bp[MAX_RES][3], mat[9];
        let ap = [], bp = [];
    //    let mat = new Array(9);

        //double h1[3], h2[3], h3[3], k1[3], k2[3], k3[3];
        let h1 = new Array(3), h2 = new Array(3), h3 = new Array(3), k1 = new Array(3), k2 = new Array(3), k3 = new Array(3);

        supr = 0.0;

        if (n <= 1) return {'rot': undefined, 'trans1': undefined, 'trans2': undefined, 'rmsd': 999};

        // read in and reformat the coordinates
        // calculate the centroids
        let finalCnt = n;
        for (i = 0; i < n; i++) {
            if(co1[i] === undefined || co2[i] === undefined) {
                --finalCnt;
                continue;
            }
            ap.push(co1[i].clone());
            bp.push(co2[i].clone());

            cp.add(co1[i]);
            cq.add(co2[i]);
        }

        n = finalCnt;
        if (n <= 1) return {'rot': undefined, 'trans1': undefined, 'trans2': undefined, 'rmsd': 999};

        cp.multiplyScalar(1.0 / n);
        cq.multiplyScalar(1.0 / n);

        // save the translation vectors
        let xc1 = cp;
        let xc2 = cq;

        // translate coordinates
        for (i = 0; i < n; i++) {
            ap[i].sub(cp);
            bp[i].sub(cq);
        }

        // radii of gyration
        for (i = 0, ra = rb = 0.0; i < n; i++) {
            ra += ap[i].x*ap[i].x + ap[i].y*ap[i].y + ap[i].z*ap[i].z;
            rb += bp[i].x*bp[i].x + bp[i].y*bp[i].y + bp[i].z*bp[i].z;
        }

        ra /= n;
        rb /= n;

        let u = new Array(9); //var u00, u01, u02, u10, u11, u12, u20, u21, u22;

        // correlation matrix U
        for (i = 0; i < 9; ++i) {
            u[i] = 0;
        }

        for (i = 0; i < n; i++) {
            u[0] += ap[i].x*bp[i].x;
            u[1] += ap[i].x*bp[i].y;
            u[2] += ap[i].x*bp[i].z;
            u[3] += ap[i].y*bp[i].x;
            u[4] += ap[i].y*bp[i].y;
            u[5] += ap[i].y*bp[i].z;
            u[6] += ap[i].z*bp[i].x;
            u[7] += ap[i].z*bp[i].y;
            u[8] += ap[i].z*bp[i].z;
        }

        for (i = 0; i < 9; ++i) {
            u[i] /= n;
        }

        let eigenRet = me.rmsdSuprCls.getEigenVectors(u);
        k = eigenRet.k;
        h1 = eigenRet.h1;
        h2 = eigenRet.h2;
        h3 = eigenRet.h3;

        k1 = eigenRet.k1;
        k2 = eigenRet.k2;
        k3 = eigenRet.k3;

        d1 = eigenRet.d1;
        d2 = eigenRet.d2;
        d3 = eigenRet.d3;

        flag = eigenRet.flag;

        s = eigenRet.s;

        if (k != 1) {
            supr = 100.0;
            rot[0] = 1.0; rot[1] = 0.0; rot[2] = 0.0;
            rot[3] = 0.0; rot[4] = 1.0; rot[5] = 0.0;
            rot[6] = 0.0; rot[7] = 0.0; rot[8] = 1.0;
            return {'rot': rot, 'trans1': xc1, 'trans2': xc2, 'rmsd': supr};
        }

        if (flag == 1) {
            // compute the k-vectors via the h-vectors
            k1[0] = u[0]*h1[0] + u[3]*h1[1] + u[6]*h1[2];
            k1[1] = u[1]*h1[0] + u[4]*h1[1] + u[7]*h1[2];
            k1[2] = u[2]*h1[0] + u[5]*h1[1] + u[8]*h1[2];
            da = Math.sqrt(d1);
            k1[0] /= da;
            k1[1] /= da;
            k1[2] /= da;
            k2[0] = u[0]*h2[0] + u[3]*h2[1] + u[6]*h2[2];
            k2[1] = u[1]*h2[0] + u[4]*h2[1] + u[7]*h2[2];
            k2[2] = u[2]*h2[0] + u[5]*h2[1] + u[8]*h2[2];
            da = Math.sqrt(d2);
            k2[0] /= da;
            k2[1] /= da;
            k2[2] /= da;
            k3[0] = u[0]*h3[0] + u[3]*h3[1] + u[6]*h3[2];
            k3[1] = u[1]*h3[0] + u[4]*h3[1] + u[7]*h3[2];
            k3[2] = u[2]*h3[0] + u[5]*h3[1] + u[8]*h3[2];
            da = Math.sqrt(d3);
            k3[0] /= da;
            k3[1] /= da;
            k3[2] /= da;
        }
        else if (flag == 2) {
            // compute the h-vectors via the k-vectors
            h1[0] = u[0]*k1[0] + u[1]*k1[1] + u[2]*k1[2];
            h1[1] = u[3]*k1[0] + u[4]*k1[1] + u[5]*k1[2];
            h1[2] = u[6]*k1[0] + u[7]*k1[1] + u[8]*k1[2];
            da = Math.sqrt(d1);
            h1[0] /= da;
            h1[1] /= da;
            h1[2] /= da;
            h2[0] = u[0]*k2[0] + u[1]*k2[1] + u[2]*k2[2];
            h2[1] = u[3]*k2[0] + u[4]*k2[1] + u[5]*k2[2];
            h2[2] = u[6]*k2[0] + u[7]*k2[1] + u[8]*k2[2];
            da = Math.sqrt(d2);
            h2[0] /= da;
            h2[1] /= da;
            h2[2] /= da;
            h3[0] = u[0]*k3[0] + u[1]*k3[1] + u[2]*k3[2];
            h3[1] = u[3]*k3[0] + u[4]*k3[1] + u[5]*k3[2];
            h3[2] = u[6]*k3[0] + u[7]*k3[1] + u[8]*k3[2];
            da = Math.sqrt(d3);
            h3[0] /= da;
            h3[1] /= da;
            h3[2] /= da;
        }

        if (s > 0.0) {
            rot[0] = (k1[0]*h1[0] + k2[0]*h2[0] + k3[0]*h3[0]);
            rot[1] = (k1[0]*h1[1] + k2[0]*h2[1] + k3[0]*h3[1]);
            rot[2] = (k1[0]*h1[2] + k2[0]*h2[2] + k3[0]*h3[2]);
            rot[3] = (k1[1]*h1[0] + k2[1]*h2[0] + k3[1]*h3[0]);
            rot[4] = (k1[1]*h1[1] + k2[1]*h2[1] + k3[1]*h3[1]);
            rot[5] = (k1[1]*h1[2] + k2[1]*h2[2] + k3[1]*h3[2]);
            rot[6] = (k1[2]*h1[0] + k2[2]*h2[0] + k3[2]*h3[0]);
            rot[7] = (k1[2]*h1[1] + k2[2]*h2[1] + k3[2]*h3[1]);
            rot[8] = (k1[2]*h1[2] + k2[2]*h2[2] + k3[2]*h3[2]);
        }
        else {
            rot[0] = (k1[0]*h1[0] + k2[0]*h2[0] - k3[0]*h3[0]);
            rot[1] = (k1[0]*h1[1] + k2[0]*h2[1] - k3[0]*h3[1]);
            rot[2] = (k1[0]*h1[2] + k2[0]*h2[2] - k3[0]*h3[2]);
            rot[3] = (k1[1]*h1[0] + k2[1]*h2[0] - k3[1]*h3[0]);
            rot[4] = (k1[1]*h1[1] + k2[1]*h2[1] - k3[1]*h3[1]);
            rot[5] = (k1[1]*h1[2] + k2[1]*h2[2] - k3[1]*h3[2]);
            rot[6] = (k1[2]*h1[0] + k2[2]*h2[0] - k3[2]*h3[0]);
            rot[7] = (k1[2]*h1[1] + k2[2]*h2[1] - k3[2]*h3[1]);
            rot[8] = (k1[2]*h1[2] + k2[2]*h2[2] - k3[2]*h3[2]);
        }

        // optimal rotation correction via eigenvalues
        d1 = Math.sqrt(d1);
        d2 = Math.sqrt(d2);
        d3 = Math.sqrt(d3);
        v = d1 + d2 + s*d3;
        e = ra + rb - 2.0*v;

        if (e > 0.0) {
            supr = Math.sqrt(e);
        }
        else {
            supr = undefined;
        }

        return {'rot': rot, 'trans1': xc1, 'trans2': xc2, 'rmsd': supr};

    }; // end rmsd_supr


    eigen_values(a0) { this.icn3dui;
        let v00, v01, v02, v10, v11, v12, v20, v21, v22;
        let a, b, c, p, q, t, u, v, d1, d2, d3;

        // initialization
        v00 = a0[0]; v01 = a0[1]; v02 = a0[2];
        v10 = a0[3]; v11 = a0[4]; v12 = a0[5];
        v20 = a0[6]; v21 = a0[7]; v22 = a0[8];

        // coefficients of the characteristic polynomial for V
        // det(xI - V) = x^3 + a*x^2 + b*x + c
        a = -(v00 + v11 + v22);
        b = v00*v11 + (v00 + v11)*v22 - v12*v21 - v01*v10 - v02*v20;
        c = -v00*v11*v22 + v00*v12*v21 + v01*v10*v22 - v01*v12*v20 - v02*v10*v21
            + v02*v11*v20;

        // transformed polynomial: x = y - a/3, poly(y) = y^3 + p*y + q
        p = -a*a/3.0 + b;
        q = a*a*a/13.5 - a*b/3.0 + c;

        // solutions y = u + v
        t = 0.25*q*q + p*p*p/27.0;

        if (t < 0.0) {
            let r, theta;

            // things are a bit more complicated
            r = Math.sqrt(0.25*q*q - t);
            theta = Math.acos(-0.5*q/r);
            d1 = 2.0*Math.cbrt(r)*Math.cos(theta/3.0);
        }
        else {
            u = Math.cbrt(-0.5*q + Math.sqrt(t));
            v = Math.cbrt(-0.5*q - Math.sqrt(t));
            d1 = u + v;
        }

        // return to the original characteristic polynomial
        d1 -= a/3.0;
        a += d1;
        c /= -d1;

        // solve the quadratic x^2 + a*x + c = 0
        d2 = 0.5*(-a + Math.sqrt(a*a - 4.0*c));
        d3 = 0.5*(-a - Math.sqrt(a*a - 4.0*c));

        // order the eigenvalues: d1 >= d2 >= d3
        if (d2 < d3) {
            t = d3;
            d3 = d2;
            d2 = d3;
        }

        if (d1 < d2) {
            t = d2;
            d2 = d1;
            d1 = t;
        }

        if (d2 < d3) {
            t = d3;
            d3 = d2;
            d2 = d3;
        }

        return {'d1': d1, 'd2': d2, 'd3': d3};
    }; // end eigen_values

    // Return the basis for the null space of the input matrix.
    null_basis(a0, v1, v2, v3, epsi) { this.icn3dui;
        let k, k0, spec;
        let a11, a12, a13, a21, a22, a23, a31, a32, a33;
        let b22, b23, b32, b33;
        let t, mx0;

        // initialization
        a11 = a0[0]; a12 = a0[1]; a13 = a0[2];
        a21 = a0[3]; a22 = a0[4]; a23 = a0[5];
        a31 = a0[6]; a32 = a0[7]; a33 = a0[8];

        // scale the matrix, so find the max entry
        mx0 = Math.abs(a11);
        if (Math.abs(a12) > mx0) mx0 = Math.abs(a12);
        if (Math.abs(a13) > mx0) mx0 = Math.abs(a13);
        if (Math.abs(a21) > mx0) mx0 = Math.abs(a21);
        if (Math.abs(a22) > mx0) mx0 = Math.abs(a22);
        if (Math.abs(a23) > mx0) mx0 = Math.abs(a23);
        if (Math.abs(a31) > mx0) mx0 = Math.abs(a31);
        if (Math.abs(a32) > mx0) mx0 = Math.abs(a32);
        if (Math.abs(a33) > mx0) mx0 = Math.abs(a33);

        if (mx0 < 1.0e-10) {
            // interpret this as the matrix of all 0's
            k0 = 3;
            return {'k': k0, 'v1': v1, 'v2': v2, 'v3': v3};
        }

        spec = 0;
        a11 /= mx0; a12 /= mx0; a13 /= mx0;
        a21 /= mx0; a22 /= mx0; a23 /= mx0;
        a31 /= mx0; a32 /= mx0; a33 /= mx0;

        if ((Math.abs(a11) < epsi) && (Math.abs(a21) < epsi) && (Math.abs(a31) < epsi)) {
            // let x1 is independent
            k = 1;
            v1[0] = 1.0; v1[1] = 0.0; v1[2] = 0.0;

            if ((Math.abs(a12) < epsi) && (Math.abs(a22) < epsi) && (Math.abs(a32) < epsi)) {
                // let x2 is independent
                k = 2;
                v2[0] = 0.0; v2[1] = 1.0; v2[2] = 0.0;

                if ((Math.abs(a13) < epsi) && (Math.abs(a23) < epsi) && (Math.abs(a33) < epsi)) {
                    // let x3 is independent
                    k = 3;
                    v3[0] = 0.0; v3[1] = 0.0; v3[2] = 1.0;
                }

                // else, we must have x3 = 0.0, so we're done
            }
            else {
                // reorder so that a12 is maximized
                mx0 = Math.abs(a12);

                if (Math.abs(a22) > mx0) {
                    // swap rows 1 and 2
                    t = a11; a11 = a21; a21 = t;
                    t = a12; a12 = a22; a22 = t;
                    t = a13; a13 = a23; a23 = t;
                    mx0 = Math.abs(a12);
                }

                if (Math.abs(a32) > mx0) {
                    // swap rows 1 and 3
                    t = a11; a11 = a31; a31 = t;
                    t = a12; a12 = a32; a32 = t;
                    t = a13; a13 = a33; a33 = t;
                }

                // let x2 is dependent, x2 = -a13/a12*x3
                b32 = a23 - a22*a13/a12;
                b33 = a33 - a32*a13/a12;

                if ((Math.abs(b32) < epsi) && (Math.abs(b33) < epsi)) {
                    //* let x3 is independent
                    k = 2;
                    v2[0] = 0.0; v2[1] = -a13/a12; v2[2] = 1.0;
                    spec = 1;
                }

                // else, we must have x3 = x2 = 0.0, so we're done
            }
        }
        else {
            // reorder so that a11 is maximized
            mx0 = Math.abs(a11);

            if (Math.abs(a12) > mx0) {
                // swap rows 1 and 2
                t = a11; a11 = a21; a21 = t;
                t = a12; a12 = a22; a22 = t;
                t = a13; a13 = a23; a23 = t;
                mx0 = Math.abs(a11);
            }

            if (Math.abs(a13) > mx0) {
                // swap rows 1 and 3
                t = a11; a11 = a31; a31 = t;
                t = a12; a12 = a32; a32 = t;
                t = a13; a13 = a33; a33 = t;
            }

            // let x1 is dependent, x1 = -a12/a11*x2 - a13/a11*x3
            b22 = a22 - a21*a12/a11;
            b23 = a23 - a21*a13/a11;
            b32 = a32 - a31*a12/a11;
            b33 = a33 - a31*a13/a11;

            if ((Math.abs(b22) < epsi) && (Math.abs(b32) < epsi)) {
                // let x2 is independent
                k = 1;
                v1[0] = -a12/a11; v1[1] = 1.0; v1[2] = 0.0;

                if ((Math.abs(b23) < epsi) && (Math.abs(b33) < epsi)) {
                    // let x3 is independent
                    k = 2;
                    v2[0] = -a13/a11; v2[1] = 0.0; v2[2] = 1.0;
                    spec = 2;
                }

                // else, we must have x3 = 0.0, so we're done
            }
            else {
                // reorder so that b22 is maximized
                if (Math.abs(b22) < Math.abs(b32)) {
                    t = b22; b22 = b32; b32 = t;
                    t = b23; b23 = b33; b33 = t;
                }

                // let x2 is dependent, x2 = -b23/b22*x3
                if (Math.abs(b33 - b23*b32/b22) < epsi) {
                    // let x3 is independent
                    k = 1;
                    v1[0] = (a12/a11)*(b23/b22) - a13/a11;
                    v1[1] = -b23/b22; v1[2] = 1.0;
                    spec = 3;
                }
                else {
                    // the null space contains only the zero vector
                    k0 = 0;
                    v1[0] = 0.0; v1[1] = 0.0; v1[2] = 0.0;
                    //return;
                    return {'k': k0, 'v1': v1, 'v2': v2, 'v3': v3};
                }
            }
        }

        k0 = k;

        if (spec > 0) {
            // special cases, basis should be orthogonalized
            if (spec == 1) {
                // 2nd vector must be normalized
                a11 = v2[0]; a12 = v2[1]; a13 = v2[2];
                t = Math.sqrt(a11*a11 + a12*a12 + a13*a13);
                v2[0] = a11/t; v2[1] = a12/t; v2[2] = a13/t;
            }
            else if (spec == 2) {
                // 1st, 2nd vectors must be orthogonalized
                a11 = v1[0]; a12 = v1[1]; a13 = v1[2];
                a21 = v2[0]; a22 = v2[1]; a23 = v2[2];
                t = a11*a21 + a12*a22 + a13*a23;

                if (Math.abs(t) >= epsi) {
                    v2[0] = a11 + t*a21;
                    v2[1] = a12 + t*a22;
                    v2[2] = a13 + t*a23;
                    a21 = v2[0]; a22 = v2[1]; a23 = v2[2];
                }

                // normalize the vectors
                t = Math.sqrt(a11*a11 + a12*a12 + a13*a13);
                v1[0] = a11/t; v1[1] = a12/t; v1[2] = a13/t;
                t = Math.sqrt(a21*a21 + a22*a22 + a23*a23);
                v2[0] = a21/t; v2[1] = a22/t; v2[2] = a23/t;
            }
            else {
                // 1st vector must be normalized
                a11 = v1[0]; a12 = v1[1]; a13 = v1[2];
                t = Math.sqrt(a11*a11 + a12*a12 + a13*a13);
                v1[0] = a11/t; v1[1] = a12/t; v1[2] = a13/t;
            }
        }

        return {'k': k0, 'v1': v1, 'v2': v2, 'v3': v3};
    }; // end null_basis


    getEigenForSelection(coord, n) { let me = this.icn3dui;
        let i;
        let cp = new THREE.Vector3();
        let ap = [];

        // read in and reformat the coordinates
        // calculate the centroids
        for (i = 0; i < n; i++) {
            ap.push(coord[i]);

            cp.add(coord[i]);
        }

        cp.multiplyScalar(1.0 / n);

        // translate coordinates
        for (i = 0; i < n; i++) {
            ap[i].sub(cp);
        }

        let u = new Array(9); //var u00, u01, u02, u10, u11, u12, u20, u21, u22;

        for (i = 0; i < 9; ++i) {
            u[i] = 0;
        }

        // http://individual.utoronto.ca/rav/Web/FR/cov.htm
        // https://builtin.com/data-science/step-step-explanation-principal-component-analysis
        for (i = 0; i < n; i++) {
            u[0] += ap[i].x*ap[i].x;
            u[1] += ap[i].x*ap[i].y;
            u[2] += ap[i].x*ap[i].z;
            u[3] += ap[i].y*ap[i].x;
            u[4] += ap[i].y*ap[i].y;
            u[5] += ap[i].y*ap[i].z;
            u[6] += ap[i].z*ap[i].x;
            u[7] += ap[i].z*ap[i].y;
            u[8] += ap[i].z*ap[i].z;
        }

        for (i = 0; i < 9; ++i) {
            u[i] /= n;
        }

        return me.rmsdSuprCls.getEigenVectors(u);
    };

    getEigenVectors(u, bJustPc1) { let me = this.icn3dui;
    //    let TINY0 = 1.0e-10;
        let TINY0 = 1.0e-8;
        let k, flag;
        let mat = new Array(9);

        let h1 = new Array(3), h2 = new Array(3), h3 = new Array(3), k1 = new Array(3), k2 = new Array(3), k3 = new Array(3);

        let dU, d1, d2, d3, s;

        // determinant of U
        dU = u[0]*(u[4]*u[8] - u[5]*u[7]);
        dU -= u[1]*(u[3]*u[8] - u[5]*u[6]);
        dU += u[2]*(u[3]*u[7] - u[4]*u[6]);
        s = (dU < 0.0) ? -1.0 : 1.0;

        let v1 = new Array(3), v2 = new Array(3);
        for(let i = 0; i < 3; ++i) {
            v1[i] = new THREE.Vector3();
            v2[i] = new THREE.Vector3();
        }

        // compute V = UU' (it is symmetric)
        v1[0].x = u[0]*u[0] + u[1]*u[1] + u[2]*u[2];
        v1[0].y = u[0]*u[3] + u[1]*u[4] + u[2]*u[5];
        v1[0].z = u[0]*u[6] + u[1]*u[7] + u[2]*u[8];
        v1[1].x = v1[0].y;
        v1[1].y = u[3]*u[3] + u[4]*u[4] + u[5]*u[5];
        v1[1].z = u[3]*u[6] + u[4]*u[7] + u[5]*u[8];
        v1[2].x = v1[0].z;
        v1[2].y = v1[1].z;
        v1[2].z = u[6]*u[6] + u[7]*u[7] + u[8]*u[8];

        // also compute V = U'U, as it may be needed
        v2[0].x = u[0]*u[0] + u[3]*u[3] + u[6]*u[6];
        v2[0].y = u[0]*u[1] + u[3]*u[4] + u[6]*u[7];
        v2[0].z = u[0]*u[2] + u[3]*u[5] + u[6]*u[8];
        v2[1].x = v2[0].y;
        v2[1].y = u[1]*u[1] + u[4]*u[4] + u[7]*u[7];
        v2[1].z = u[1]*u[2] + u[4]*u[5] + u[7]*u[8];
        v2[2].x = v2[0].z;
        v2[2].y = v2[1].z;
        v2[2].z = u[2]*u[2] + u[5]*u[5] + u[8]*u[8];

        // compute the eigenvalues
        mat[0] = v1[0].x; mat[1] = v1[0].y; mat[2] = v1[0].z;
        mat[3] = v1[1].x; mat[4] = v1[1].y; mat[5] = v1[1].z;
        mat[6] = v1[2].x; mat[7] = v1[2].y; mat[8] = v1[2].z;

        let eigen = me.rmsdSuprCls.eigen_values(mat);

        d1 = eigen.d1;
        d2 = eigen.d2;
        d3 = eigen.d3;

        // now we need the eigenvectors
        flag = 1;
        mat[0] -= d1;
        mat[4] -= d1;
        mat[8] -= d1;
        let basis = me.rmsdSuprCls.null_basis(mat, h1, h2, h3, TINY0);
        k = basis.k;
        h1 = basis.v1;
        h2 = basis.v2;
        h3 = basis.v3;

        if(bJustPc1) return {"k": k, "h1": h1, "h2": h2, "h3": h3, "k1": k1, "k2": k2, "k3": k3, "d1": d1, "d2": d2, "d3": d3, "flag": flag, "s": s};

        if (k == 1) {
            mat[0] += d1 - d2;
            mat[4] += d1 - d2;
            mat[8] += d1 - d2;
            basis = me.rmsdSuprCls.null_basis(mat, h2, h3, h1, TINY0);
            k = basis.k;
            h2 = basis.v1;
            h3 = basis.v2;
            h1 = basis.v3;

            if (k == 1) {
                mat[0] += d2 - d3;
                mat[4] += d2 - d3;
                mat[8] += d2 - d3;
                basis = me.rmsdSuprCls.null_basis(mat, h3, h1, h2, TINY0);
                k = basis.k;
                h3 = basis.v1;
                h1 = basis.v2;
                h2 = basis.v3;
            }
        }

        if (k != 1) {
            // retry the computation, but using V = U'U
            mat[0] = v2[0].x; mat[1] = v2[0].y; mat[2] = v2[0].z;
            mat[3] = v2[1].x; mat[4] = v2[1].y; mat[5] = v2[1].z;
            mat[6] = v2[2].x; mat[7] = v2[2].y; mat[8] = v2[2].z;

            // now we need the eigenvectors
            flag = 2;
            mat[0] -= d1;
            mat[4] -= d1;
            mat[8] -= d1;
            basis = me.rmsdSuprCls.null_basis(mat, k1, k2, k3, TINY0);
            k = basis.k;
            k1 = basis.v1;
            k2 = basis.v2;
            k3 = basis.v3;

            if (k == 1) {
                mat[0] += d1 - d2;
                mat[4] += d1 - d2;
                mat[8] += d1 - d2;
                basis = me.rmsdSuprCls.null_basis(mat, k2, k3, k1, TINY0);
                k = basis.k;
                k2 = basis.v1;
                k3 = basis.v2;
                k1 = basis.v3;

                if (k == 1) {
                    mat[0] += d2 - d3;
                    mat[4] += d2 - d3;
                    mat[8] += d2 - d3;
                    basis = me.rmsdSuprCls.null_basis(mat, k3, k1, k2, TINY0);
                    k = basis.k;
                    k3 = basis.v1;
                    k1 = basis.v2;
                    k2 = basis.v3;
                }
            }
        }

        return {"k": k, "h1": h1, "h2": h2, "h3": h3, "k1": k1, "k2": k2, "k3": k3, "d1": d1, "d2": d2, "d3": d3, "flag": flag, "s": s};
    }
}

/**
 * @author Jiyao Wang <wangjiy@ncbi.nlm.nih.gov> / https://github.com/ncbi/icn3d
 */



class SubdivideCls {
    constructor(icn3dui) {
        this.icn3dui = icn3dui;
    }

    // cubic splines for four points: http://thalestriangles.blogspot.com/2014/02/a-bit-of-ex-spline-ation.html
    // https://math.stackexchange.com/questions/577641/how-to-calculate-interpolating-splines-in-3d-space
    subdivide(_pnts, _clrs, DIV, bShowArray, bHighlight, prevone, nexttwo, bExtendLastRes) { let me = this.icn3dui;

        let ret = [];
        let pos = [];
        let color = [];

        let pnts = new Array(); // Smoothing test

        let prevoneLen = (prevone !== undefined) ? prevone.length : 0;
        let nexttwoLenOri = (nexttwo !== undefined) ? nexttwo.length : 0;

        let maxDist = 6.0;

        if(prevoneLen > 0
            && Math.abs(prevone[0].x - _pnts[0].x) <= maxDist
            && Math.abs(prevone[0].y - _pnts[0].y) <= maxDist
            && Math.abs(prevone[0].z - _pnts[0].z) <= maxDist
            ) {
          pnts.push(prevone[0]);
          prevoneLen = 1;
        }
        else {
          prevoneLen = 0;
        }

        pnts.push(_pnts[0]);
        for (let i = 1, lim = _pnts.length - 1; i < lim; ++i) {
            let p0 = _pnts[i], p1 = _pnts[i + 1];
            pnts.push(p0.smoothen ? p0.clone().add(p1).multiplyScalar(0.5) : p0);
        }
        pnts.push(_pnts[_pnts.length - 1]);

        let nexttwoLen = 0;
        if(nexttwoLenOri > 0
            && Math.abs(nexttwo[0].x - _pnts[_pnts.length - 1].x) <= maxDist
            && Math.abs(nexttwo[0].y - _pnts[_pnts.length - 1].y) <= maxDist
            && Math.abs(nexttwo[0].z - _pnts[_pnts.length - 1].z) <= maxDist
            ) {
          pnts.push(nexttwo[0]);
          ++nexttwoLen;
        }

        if(nexttwoLenOri > 1
            && Math.abs(nexttwo[0].x - nexttwo[1].x) <= maxDist
            && Math.abs(nexttwo[0].y - nexttwo[1].y) <= maxDist
            && Math.abs(nexttwo[0].z - nexttwo[1].z) <= maxDist
            ) {
          pnts.push(nexttwo[1]);
          ++nexttwoLen;
        }

        let savedPoints = [];
        let savedPos = [];
        let savedColor = [];

        //var nexttwoLen = nexttwoLenOri;
        if(bExtendLastRes) {
            nexttwoLen = (nexttwoLenOri > 0) ? nexttwoLenOri - 1 : 0;
        }

        let alpha = 1, newI;

        for (let i = -1, size = pnts.length, DIVINV = 1 / DIV; i <= size - 3; ++i) {
            newI = i - prevoneLen;
            let p0 = pnts[i === -1 ? 0 : i];
            let p1 = pnts[i + 1];
            let p2 = pnts[i + 2];
            let p3 = pnts[i === size - 3 ? size - 1 : i + 3];

            let t0 = 0;
            let t1 = me.subdivideCls.getKnot(alpha, t0, p0, p1);
            let t2 = me.subdivideCls.getKnot(alpha, t1, p1, p2);
            let t3 = me.subdivideCls.getKnot(alpha, t2, p2, p3);

            if(t1 - t0 < 1e-4) t1 = t0 + 1;
            if(t2 - t1 < 1e-4) t2 = t1 + 1;
            if(t3 - t2 < 1e-4) t3 = t2 + 1;

            //if(i > -1 && bHighlight && bShowArray !== undefined && bShowArray[i + 1]) {
            if(i > -1 && (bShowArray === undefined || bShowArray[newI + 1]) ) {
                // get from previous i for the first half of residue
                if(i >= -1 + prevoneLen && i <= size - 3 - nexttwoLen + 1) {
                    ret = ret.concat(savedPoints);
                    pos = pos.concat(savedPos);
                    color = color.concat(savedColor);
                }
            }

            savedPoints = [];
            savedPos = [];
            savedColor = [];

            let step = (t2 - t1) * DIVINV;
            for (let j = 0; j < DIV; ++j) {
                let t = t1 + step * j;
                let x = me.subdivideCls.getValueFromKnot(t, t0, t1, t2, t3, p0.x, p1.x, p2.x, p3.x);
                let y = me.subdivideCls.getValueFromKnot(t, t0, t1, t2, t3, p0.y, p1.y, p2.y, p3.y);
                let z = me.subdivideCls.getValueFromKnot(t, t0, t1, t2, t3, p0.z, p1.z, p2.z, p3.z);

                if(!bShowArray) {
                    if(i >= -1 + prevoneLen && i <= size - 3 - nexttwoLen) {
                        ret.push(new THREE.Vector3(x, y, z));
                        pos.push(newI + 1);
                        color.push(_clrs[newI+1]);
                    }
                }
                else {
                    if(i >= -1 + prevoneLen && i <= size - 3 - nexttwoLen) {
                        if(bShowArray[newI + 1]) {
                            if(j <= parseInt((DIV) / 2) ) {
                                ret.push(new THREE.Vector3(x, y, z));
                                pos.push(bShowArray[newI + 1]);
                                color.push(_clrs[newI+1]);
                            }
                        }
                    }

                    if(i >= -1 + prevoneLen && i <= size - 3 - nexttwoLen + 1) {
                        if(bShowArray[newI + 2]) {
                            if(j > parseInt((DIV) / 2) ) {
                                savedPoints.push(new THREE.Vector3(x, y, z));
                                savedPos.push(bShowArray[newI + 2]);
                                savedColor.push(_clrs[newI+2]);
                            }
                        }
                    }
                } // end else

            } // end for (let j = 0;
        } // end for (let i = -1;

        if(!bShowArray || bShowArray[newI + 1]) {
            //if(bHighlight) {
            ret = ret.concat(savedPoints);
            pos = pos.concat(savedPos);
            color = color.concat(savedColor);
            //}

            ret.push(pnts[pnts.length - 1 - nexttwoLen]);
            pos.push(pnts.length - 1 - nexttwoLen);
            color.push(_clrs[pnts.length - 1 - nexttwoLen]);
        }

        savedPoints = [];
        savedPos = [];
        savedColor = [];
        pnts = [];

        let pnts_positions = [];

        pnts_positions.push(ret);
        pnts_positions.push(pos);
        pnts_positions.push(color);

        return pnts_positions;
    };


    getKnot(alpha, ti, Pi, Pj) { this.icn3dui;
        //var alpha = 1;

        //return Math.pow(Pi.distanceTo(Pj), alpha) + ti;
        return Pi.distanceTo(Pj) + ti;
    }

    getValueFromKnot(t, t0, t1, t2, t3, y0, y1, y2, y3) { this.icn3dui;
        let inf = 9999;

        // m(i) = ( t(i+1) - t(i) == 0 ) ? 0 : ( y(i+1) - y(i) ) / ( t(i+1) - t(i) )
        let m0 = (y1 - y0) / (t1 - t0);
        let m1 = (y2 - y1) / (t2 - t1);
        let m2 = (y3 - y2) / (t3 - t2);

        // L(i) = m(i) * (t - t(i)) + y(i)
        //var L0 = m0 * (t - t0) + y0;
        let L1 = m1 * (t - t1) + y1;
        //var L2 = m2 * (t - t2) + y2;

        let denom = (t1 + t2) * (t1 + t2) - 4*(t0*t1 + t2*t3 - t0*t3);
        let d1, d2;

        if(denom == 0) {
            d1 = inf;
            d2 = inf;
        }
        else {
            d1 = 6 * (3*m1*t1 + 2*m0*t3 + m2*t1 - 2*m0*t1 - 2*m1*t3 - m1*t2 - m2*t1) / denom;
            d2 = 6 * (3*m1*t2 + 2*m2*t0 + m0*t1 - 2*m1*t0 - 2*m2*t2 - m0*t2 - m1*t1) / denom;
        }

        // a(i) = ( 2*d(i) + d(i+1) ) / 6 / (t(i) - t(i+1))
        // b(i) = ( 2*d(i+1) + d(i) ) / 6 / (t(i+1) - t(i))
        //var a0 = ( 2*d0 + d1 ) / 6 / (t0 - t1);
        let a1 = ( 2*d1 + d2 ) / 6 / (t1 - t2);
        //var a2 = ( 2*d2 + d3 ) / 6 / (t2 - t3);

        //var b0 = ( 2*d1 + d0 ) / 6 / (t1 - t0);
        let b1 = ( 2*d2 + d1 ) / 6 / (t2 - t1);
        //var b2 = ( 2*d3 + d2 ) / 6 / (t3 - t2);

        // C(i) = a(i)*(t - t(i))*(t - t(i+1))*(t - t(i+1)) + b(i)*(t - t(i))*(t - t(i))*(t - t(i+1))
        //var C0 = a0*(t - t0)*(t - t1)*(t - t1) + b0*(t - t0)*(t - t0)*(t - t1);
        let C1 = a1*(t - t1)*(t - t2)*(t - t2) + b1*(t - t1)*(t - t1)*(t - t2);
        //var C2 = a2*(t - t2)*(t - t3)*(t - t3) + b2*(t - t2)*(t - t2)*(t - t3);

        let F1 = L1 + C1;

        return F1;
    }
}

/**
 * @author Jiyao Wang <wangjiy@ncbi.nlm.nih.gov> / https://github.com/ncbi/icn3d
 */

class ConvertTypeCls {
    constructor(icn3dui) {
        this.icn3dui = icn3dui;
    }

    passFloat32( array, output ){ let me = this.icn3dui;
        let n = array.length;
        if( !output ) output = new Uint8Array( 4 * n );
        let dv = me.convertTypeCls.getDataView( output );
        for( let i = 0; i < n; ++i ){
            dv.setFloat32( 4 * i, array[ i ], true); // litteEndian = true
        }        return me.convertTypeCls.getUint8View( output );
    }

    passInt8( array, output ){ let me = this.icn3dui;
        let n = array.length;
        if( !output ) output = new Uint8Array( 1 * n );
        let dv = me.convertTypeCls.getDataView( output );
        for( let i = 0; i < n; ++i ){
            dv.setInt8( 1 * i, array[ i ], true); // litteEndian = true
        }        return me.convertTypeCls.getUint8View( output );
    }

    passInt16( array, output ){ let me = this.icn3dui;
        let n = array.length;
        if( !output ) output = new Uint8Array( 2 * n );
        let dv = me.convertTypeCls.getDataView( output );
        for( let i = 0; i < n; ++i ){
            dv.setInt16( 2 * i, array[ i ], true); // litteEndian = true
        }        return me.convertTypeCls.getUint8View( output );
    }

    passInt32( array, output ){ let me = this.icn3dui;
        let n = array.length;
        if( !output ) output = new Uint8Array( 4 * n );
        let dv = me.convertTypeCls.getDataView( output );
        for( let i = 0; i < n; ++i ){
            dv.setInt32( 4 * i, array[ i ], true); // litteEndian = true
        }        return me.convertTypeCls.getUint8View( output );
    }

    getUint8View( typedArray ){ let me = this.icn3dui;
        return me.convertTypeCls.getView( Uint8Array, typedArray );
    }

    getDataView( typedArray ){ let me = this.icn3dui;
        return me.convertTypeCls.getView( DataView, typedArray );
    }

    getView( ctor, typedArray, elemSize ){ this.icn3dui;
        return typedArray ? new ctor(
            typedArray.buffer,
            typedArray.byteOffset,
            typedArray.byteLength / ( elemSize || 1 )
        ) : undefined;
    }

    getBlobFromBufferAndText(arrayBuffer, text) { let me = this.icn3dui;
        let strArray = new Uint8Array(arrayBuffer);

        let strArray2 = new Uint8Array(text.length);
        for(let i = 0; i < text.length; ++i) {
           strArray2[i] = me.convertTypeCls.passInt8([text.charCodeAt(i)])[0];
        }

        let blobArray = []; // hold blobs

        //blobArray.push(new Blob([strArray0],{ type: "application/octet-stream"}));
        blobArray.push(new Blob([strArray],{ type: "application/octet-stream"}));
        blobArray.push(new Blob([strArray2],{ type: "application/octet-stream"}));

        //var blob = new Blob(blobArray,{ type: "application/octet-stream"});
        let blob = new Blob(blobArray,{ type: "image/png"});

        return blob;
    }
}

/**
 * @author Jiyao Wang <wangjiy@ncbi.nlm.nih.gov> / https://github.com/ncbi/icn3d
 */

class ClickMenu {
    constructor(icn3dui) {
        this.icn3dui = icn3dui;
    }

    setAlphaFoldLegend() { let me = this.icn3dui; me.icn3d;
        let legendHtml;
        legendHtml = '<div>';
        legendHtml += '<span class="icn3d-square" style="background-color: rgb(0, 83, 204);">&nbsp;</span> <span>Very high (pLDDT &gt; 90)</span><br>';
        legendHtml += '<span class="icn3d-square" style="background-color: rgb(101, 203, 243);">&nbsp;</span> <span>Confident (90 &gt; pLDDT &gt; 70)</span><br>';
        legendHtml += '<span class="icn3d-square" style="background-color: rgb(255, 209, 19);">&nbsp;</span> <span>Low (70 &gt; pLDDT &gt; 50)</span><br>';
        legendHtml += '<span class="icn3d-square" style="background-color: rgb(255, 125, 69);">&nbsp;</span> <span>Very low (pLDDT &lt; 50)</span><br>';
        legendHtml += '</div>';

        return legendHtml;
    }

    setLegendHtml(bAf) { let me = this.icn3dui, ic = me.icn3d;
        let legendHtml = "<br>";
        if(bAf) {
            legendHtml += this.setAlphaFoldLegend();
        }
        else {
            let startColorStr = (ic.startColor == 'red') ? '#F00' : (ic.startColor == 'green') ? '#0F0' : '#00F';
            let midColorStr = (ic.midColor == 'white') ? '#FFF' : '#000';
            let endColorStr = (ic.endColor == 'red') ? '#F00' : (ic.endColor == 'green') ? '#0F0' : '#00F';
            let rangeStr = startColorStr + ' 0%, ' + midColorStr + ' 50%, ' + endColorStr + ' 100%';

            legendHtml += "<div style='height: 20px; background: linear-gradient(to right, " + rangeStr + ");'></div><table width='100%' border='0' cellspacing='0' cellpadding='0'><tr><td width='33%'>" + ic.startValue + "</td><td width='33%' align='center'>" + ic.midValue + "</td><td width='33%' align='right'>" + ic.endValue + "</td></tr></table>";
        }

        return legendHtml;
    }

    SetChainsAdvancedMenu() { let me = this.icn3dui, ic = me.icn3d;
        if(ic.bSetChainsAdvancedMenu === undefined || !ic.bSetChainsAdvancedMenu) {
            let prevHAtoms = me.hashUtilsCls.cloneHash(ic.hAtoms);
            ic.definedSetsCls.setPredefinedInMenu();
            ic.bSetChainsAdvancedMenu = true;
            ic.hAtoms = me.hashUtilsCls.cloneHash(prevHAtoms);
        }
    }

    setSetsMenus(id, bOneset) { let me = this.icn3dui, ic = me.icn3d;
        this.SetChainsAdvancedMenu();

        let id1 = id;
        let id2 = id + '2';

        let definedAtomsHtml = ic.definedSetsCls.setAtomMenu(['protein']);
        if($("#" + me.pre + id1).length) {
            $("#" + me.pre + id1).html("  <option value='selected'>selected</option>" + definedAtomsHtml);
        }
        if(!bOneset && $("#" + me.pre + id2).length) {
            $("#" + me.pre + id2).html("  <option value='selected' selected>selected</option>" + definedAtomsHtml);
        }

        $("#" + me.pre + id1).resizable();
        if(!bOneset) $("#" + me.pre + id2).resizable();
    }

    applyShownMenus(bNoSave) { let me = this.icn3dui; me.icn3d;
        let idArray = [];
        for(let id in me.htmlCls.allMenus) {
            if(me.htmlCls.shownMenus.hasOwnProperty(id)) {
                $("#" + me.pre + id).parent().show();
            }
            else {            
                $("#" + me.pre + id).parent().hide();     
                idArray.push(id);         
            }
        }   

        if(Object.keys(me.htmlCls.shownMenus).length == Object.keys(me.htmlCls.allMenus).length) {
            $(".icn3d-menusep").show();
        }
        else {
            $(".icn3d-menusep").hide();
        }

        // save to localStorage
        if(localStorage && !bNoSave) localStorage.setItem('hiddenmenus', JSON.stringify(idArray));
    }

    getHiddenMenusFromCache() { let me = this.icn3dui; me.icn3d;
      // me.htmlCls.shownMenus = {};

      // let mode = me.htmlCls.setHtmlCls.getCookie('menumode');

      let idArrayStr = (localStorage) ? localStorage.getItem('hiddenmenus') : '';
      
      if(idArrayStr && idArrayStr != '[]') {
         me.htmlCls.shownMenus = {};

         let idArray = JSON.parse(idArrayStr);

         // for(let i = 0, il = idArray.length; i < il; ++i) {
         //     me.htmlCls.shownMenus[idArray[i]] = 1;
         // }
         for(let menu in me.htmlCls.allMenus) {
            if(idArray.indexOf(menu) == -1) {
               me.htmlCls.shownMenus[menu] = 1;
            }
         }
      }
      //###
      else {
         me.htmlCls.shownMenus = me.hashUtilsCls.cloneHash(me.htmlCls.allMenus);
      }

      // else {
      //    if(mode == 'all') {
      //       me.htmlCls.shownMenus = me.hashUtilsCls.cloneHash(me.htmlCls.allMenus);
      //    }
      //    else if(!mode || mode == 'simple') {
      //       me.htmlCls.shownMenus = me.hashUtilsCls.cloneHash(me.htmlCls.simpleMenus);
      //    }
      //    else {
      //       me.htmlCls.shownMenus = me.hashUtilsCls.cloneHash(me.htmlCls.simpleMenus);
      //    }
      // }
    }
    
    displayShownMenus() { let me = this.icn3dui; me.icn3d;
        let html = "<form name='" + me.pre + "selmenu'>";
        html += "<table><tr><th>File</th><th>Select</th><th>View</th><th>Style</th><th>Color</th><th>Analysis</th><th>Help</th></tr>";
        html += "<tr>";
        for(let id in me.htmlCls.allMenusSel) {
            // skip all unicolor: too many
            if(id.substr(0, 6) == 'uniclr' 
                || id.substr(0, 11) == 'mn5_opacity'
                || id.substr(0, 14) == 'mn6_labelscale'
                || id.substr(0, 4) == 'faq_'
                || id.substr(0, 4) == 'dev_') {
                    continue;
            }

            if(id == 'mn1_searchgrooup') {
                html += "<td valign='top'>";
            }
            else if(id == 'mn2_definedsets') {
                html += "</td><td valign='top'>";
            }
            else if(id == 'mn2_show_selected') {
                html += "</td><td valign='top'>";
            }
            else if(id == 'mn3_proteinwrap' || (me.cfg.cid && id == 'mn3_ligwrap')) {
                html += "</td><td valign='top'>";
            }
            else if(id == 'mn4_clrwrap') {
                html += "</td><td valign='top'>";
            }
            else if(id == 'mn6_selectannotations') {
                html += "</td><td valign='top'>";
            }
            else if(id == 'abouticn3d') {
                html += "</td><td valign='top'>";
            }

            let checkStr = (me.htmlCls.shownMenus.hasOwnProperty(id)) ? "checked" : "";

            let selType = me.htmlCls.allMenusSel[id];
            let styleStr = (selType == 3) ? " style='margin-left:30px'" : ((selType == 2) ? " style='margin-left:15px'" : "");

            html += "<span style='white-space:nowrap'><input type='checkbox' name='" + id + "' value='" + id + "'" + checkStr + styleStr + ">" + me.htmlCls.allMenus[id] + "</span><br>";
        }  
        html += "</td></tr></table></form>";

        $("#" + me.pre + "menulist").html(html);
    }

    async setIgTemplate(template) { let me = this.icn3dui, ic = me.icn3d;
      ic.bRunRefnumAgain = true;

      // reset for the selection
      let residueArray = ic.resid2specCls.atoms2residues(Object.keys(ic.hAtoms));
      for(let i = 0, il = residueArray.length; i < il; ++i) {
         let resid = residueArray[i];

         if(ic.resid2refnum) delete ic.resid2refnum[resid];
         // if(ic.resid2refnum_ori) delete ic.resid2refnum_ori[resid];
         if(ic.resid2domainid) delete ic.resid2domainid[resid];
      }

      let bSelection = true;
      // await ic.refnumCls.showIgRefNum(template);
      if(!ic.bAnnoShown) await ic.showAnnoCls.showAnnotations();
      await ic.annotationCls.setAnnoTabIg(bSelection, template);

      ic.bRunRefnumAgain = false;
    }

    setClashedResidues() { let me = this.icn3dui, ic = me.icn3d;
      // check contacts between all chains
      let chainidArray = Object.keys(ic.chains);
      let radius = 4, bSphereCalc = false, bInteraction = true;
      for(let i = 0, il = chainidArray.length; i < il; ++i) {
         let chainid1 = chainidArray[i];
         for(let j = i + 1, jl = chainidArray.length; j < jl; ++j) {
            let chainid2 = chainidArray[j];
            ic.showInterCls.pickCustomSphere_base(radius, ic.chains[chainid1], ic.chains[chainid2], bSphereCalc, bInteraction);
         }
      }

      // use domains to determine which one to hide
      let bNotShowDomain = true;
      ic.annoDomainCls.showDomainAll(bNotShowDomain);
    }

    clickMenu1() { let me = this.icn3dui; me.icn3d;
        if(me.bNode) return;

        let thisClass = this;
    //mn 1
    //    clkMn1_mmtfid: function() {
        me.myEventCls.onIds("#" + me.pre + "mn1_vastplus", "click", function(e) { me.icn3d; //e.preventDefault();
            me.htmlCls.dialogCls.openDlg('dl_vastplus', 'Please input PDB ID for VAST+');
         });

        me.myEventCls.onIds("#" + me.pre + "mn1_vast", "click", function(e) { me.icn3d; //e.preventDefault();
            me.htmlCls.dialogCls.openDlg('dl_vast', 'Please input chain or PDB file for VAST');
         });

        me.myEventCls.onIds("#" + me.pre + "mn1_foldseek", "click", function(e) { me.icn3d; //e.preventDefault();
            me.htmlCls.dialogCls.openDlg('dl_foldseek', 'Submit your selection to Foldseek');
         });

        me.myEventCls.onIds("#" + me.pre + "mn1_mmtfid", "click", function(e) { me.icn3d; //e.preventDefault();
           me.htmlCls.dialogCls.openDlg('dl_mmtfid', 'Please input BCIF/MMTF ID');
        });

    //    clkMn1_pdbid: function() {
        me.myEventCls.onIds("#" + me.pre + "mn1_pdbid", "click", function(e) { me.icn3d; //e.preventDefault();
           me.htmlCls.dialogCls.openDlg('dl_pdbid', 'Please input PDB ID');
        });

        me.myEventCls.onIds("#" + me.pre + "mn1_afid", "click", function(e) { me.icn3d; //e.preventDefault();
           me.htmlCls.dialogCls.openDlg('dl_afid', 'Please input AlphaFold UniProt ID');
        });

        me.myEventCls.onIds("#" + me.pre + "mn1_refseqid", "click", function(e) { me.icn3d; //e.preventDefault();
            me.htmlCls.dialogCls.openDlg('dl_refseqid', 'Please input NCBI Protein Accession');
         });

        me.myEventCls.onIds("#" + me.pre + "mn1_opmid", "click", function(e) { me.icn3d; //e.preventDefault();
           me.htmlCls.dialogCls.openDlg('dl_opmid', 'Please input OPM PDB ID');
        });

        me.myEventCls.onIds("#" + me.pre + "mn1_align", "click", function(e) { me.icn3d; //e.preventDefault();
           me.htmlCls.dialogCls.openDlg('dl_align', 'Align two PDB structures');
        });

        me.myEventCls.onIds("#" + me.pre + "mn1_alignaf", "click", function(e) { me.icn3d; //e.preventDefault();
            me.htmlCls.dialogCls.openDlg('dl_alignaf', 'Align two AlphaFold structures');
         });

        me.myEventCls.onIds("#" + me.pre + "mn1_chainalign", "click", function(e) { me.icn3d; //e.preventDefault();
           me.htmlCls.dialogCls.openDlg('dl_chainalign', 'Align multiple chains by structure alignment');
        });

        me.myEventCls.onIds("#" + me.pre + "mn1_chainalign2", "click", function(e) { me.icn3d; //e.preventDefault();
            me.htmlCls.dialogCls.openDlg('dl_chainalign2', 'Align multiple chains by sequence alignment');
         });

        me.myEventCls.onIds("#" + me.pre + "mn1_chainalign3", "click", function(e) { me.icn3d; //e.preventDefault();
            me.htmlCls.dialogCls.openDlg('dl_chainalign3', 'Align multiple chains residue by residue');
         });

        me.myEventCls.onIds("#" + me.pre + "mn1_mutation", "click", function(e) { me.icn3d; //e.preventDefault();
           me.htmlCls.dialogCls.openDlg('dl_mutation', 'Show the mutations in 3D');
        });

        me.myEventCls.onIds("#" + me.pre + "mn1_pdbfile", "click", function(e) { me.icn3d; //e.preventDefault();
           //me = me.setIcn3dui($(this).attr('id'));
           me.htmlCls.dialogCls.openDlg('dl_pdbfile', 'Please input PDB File');
        });
        me.myEventCls.onIds(["#" + me.pre + "mn1_pdbfile_app", "#" + me.pre + "tool_pdbfile"], "click", function(e) { me.icn3d; //e.preventDefault();
           //me = me.setIcn3dui($(this).attr('id'));
           me.htmlCls.dialogCls.openDlg('dl_pdbfile_app', 'Please append PDB Files');
        });

        me.myEventCls.onIds("#" + me.pre + "mn1_mol2file", "click", function(e) { me.icn3d; //e.preventDefault();
           me.htmlCls.dialogCls.openDlg('dl_mol2file', 'Please input Mol2 File');
        });

        me.myEventCls.onIds("#" + me.pre + "mn1_sdffile", "click", function(e) { me.icn3d; //e.preventDefault();
           me.htmlCls.dialogCls.openDlg('dl_sdffile', 'Please input SDF File');
        });

        me.myEventCls.onIds("#" + me.pre + "mn1_xyzfile", "click", function(e) { me.icn3d; //e.preventDefault();
           me.htmlCls.dialogCls.openDlg('dl_xyzfile', 'Please input XYZ File');
        });

        me.myEventCls.onIds("#" + me.pre + "mn1_afmapfile", "click", function(e) { me.icn3d; //e.preventDefault();
            me.htmlCls.dialogCls.openDlg('dl_afmapfile', 'Please input AlphaFold PAE File');
         });

        me.myEventCls.onIds("#" + me.pre + "mn1_urlfile", "click", function(e) { me.icn3d; //e.preventDefault();
           me.htmlCls.dialogCls.openDlg('dl_urlfile', 'Load data by URL');
        });

        me.myEventCls.onIds("#" + me.pre + "mn1_fixedversion", "click", function(e) { me.icn3d; //e.preventDefault();
           me.htmlCls.dialogCls.openDlg('dl_fixedversion', 'Open Share Link URL in the archived version of iCn3D');
        });
        me.myEventCls.onIds("#" + me.pre + "reload_fixedversion", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           let url = $("#" + me.pre + "sharelinkurl").val();
           thisClass.setLogCmd("open " + url, false);
           localStorage.setItem('fixedversion', '1');
           let urlTarget = (ic.structures && Object.keys(ic.structures).length > 0) ? '_blank' : '_self';
           window.open(url, urlTarget);
        });

        me.myEventCls.onIds("#" + me.pre + "mn1_mmciffile", "click", function(e) { me.icn3d; //e.preventDefault();
           me.htmlCls.dialogCls.openDlg('dl_mmciffile', 'Please append mmCIF File');
        });

        me.myEventCls.onIds("#" + me.pre + "mn1_mmcifid", "click", function(e) { me.icn3d; //e.preventDefault();
           me.htmlCls.dialogCls.openDlg('dl_mmcifid', 'Please input mmCIF ID');
        });

        me.myEventCls.onIds("#" + me.pre + "mn1_mmdbid", "click", function(e) { me.icn3d; //e.preventDefault();
           me.htmlCls.dialogCls.openDlg('dl_mmdbid', 'Please input MMDB or PDB ID');
        });

        me.myEventCls.onIds(["#" + me.pre + "mn1_mmdbafid", , "#" + me.pre + "tool_mmdbafid"], "click", function(e) { me.icn3d; //e.preventDefault();
            me.htmlCls.dialogCls.openDlg('dl_mmdbafid', 'Please input PDB/MMDB/AlphaFold UniProt IDs');
        });

        me.myEventCls.onIds("#" + me.pre + "mn1_blast_rep_id", "click", function(e) { me.icn3d; //e.preventDefault();
           me.htmlCls.dialogCls.openDlg('dl_blast_rep_id', 'Align sequence to structure');
        });

        me.myEventCls.onIds("#" + me.pre + "mn1_esmfold", "click", function(e) { me.icn3d; //e.preventDefault();
           me.htmlCls.dialogCls.openDlg('dl_esmfold', 'Sequence to structure prediction with ESMFold');
        });

        me.myEventCls.onIds("#" + me.pre + "mn1_proteinname", "click", function(e) { me.icn3d; //e.preventDefault();
           me.htmlCls.dialogCls.openDlg('dl_proteinname', 'Please input protein or gene name');
        });

        me.myEventCls.onIds("#" + me.pre + "mn1_cid", "click", function(e) { me.icn3d; //e.preventDefault();
           me.htmlCls.dialogCls.openDlg('dl_cid', 'Please input PubChem Compound');
        });

        me.myEventCls.onIds("#" + me.pre + "mn1_smiles", "click", function(e) { me.icn3d; //e.preventDefault();
         me.htmlCls.dialogCls.openDlg('dl_smiles', 'Please input a chemical SMILES');
        });

        me.myEventCls.onIds("#" + me.pre + "mn1_pngimage", "click", function(e) { me.icn3d; //e.preventDefault();
           me.htmlCls.dialogCls.openDlg('dl_pngimage', 'Please append PNG images');
        });

        me.myEventCls.onIds("#" + me.pre + "mn1_state", "click", function(e) { me.icn3d; //e.preventDefault();
           me.htmlCls.dialogCls.openDlg('dl_state', 'Please input the state file');
        });

        me.myEventCls.onIds("#" + me.pre + "mn1_selection", "click", function(e) { me.icn3d; //e.preventDefault();
           me.htmlCls.dialogCls.openDlg('dl_selection', 'Please input the selection file');
        });
       
        me.myEventCls.onIds("#" + me.pre + "mn1_collection", "click", function (e) { me.icn3d; //e.preventDefault();
           me.htmlCls.dialogCls.openDlg("dl_selectCollections", "Select Collections");
        });
       
        me.myEventCls.onIds("#" + me.pre + "mn1_dsn6", "click", function(e) { me.icn3d; //e.preventDefault();
           me.htmlCls.dialogCls.openDlg('dl_dsn6', 'Please input the map file to display electron density map');
        });


        me.myEventCls.onIds(["#" + me.pre + "mn1_delphi", "#" + me.pre + "mn1_delphi2", "#" + me.pre + "tool_delphi"], "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.loadPhiFrom = 'delphi';
           $("#" + me.pre + "dl_delphi_tabs").tabs();
           me.htmlCls.dialogCls.openDlg('dl_delphi', 'Please set parameters to display DelPhi potential map');
        });

        me.myEventCls.onIds("#" + me.pre + "mn1_phi", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.loadPhiFrom = 'phi';
           $("#" + me.pre + "dl_phi_tabs").tabs();
           $("#" + me.pre + "phitab1_tabs").tabs();
           $("#" + me.pre + "phitab2_tabs").tabs();
           me.htmlCls.dialogCls.openDlg('dl_phi', 'Please input local phi or cube file to display DelPhi potential map');
        });
        me.myEventCls.onIds("#" + me.pre + "mn1_phiurl", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.loadPhiFrom = 'phiurl';
           $("#" + me.pre + "dl_phiurl_tabs").tabs();
           $("#" + me.pre + "phiurltab1_tabs").tabs();
           $("#" + me.pre + "phiurltab2_tabs").tabs();
           me.htmlCls.dialogCls.openDlg('dl_phiurl', 'Please input URL phi or cube file to display DelPhi potential map');
        });


        me.myEventCls.onIds("#" + me.pre + "mn1_dsn6url", "click", function(e) { me.icn3d; //e.preventDefault();
           me.htmlCls.dialogCls.openDlg('dl_dsn6url', 'Please input the map file to display electron density map');
        });

        me.myEventCls.onIds("#" + me.pre + "mn1_exportState", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           thisClass.setLogCmd("export state file", false);
           let file_pref = Object.keys(ic.structures).join(',');

           ic.saveFileCls.saveFile(file_pref + '_statefile.txt', 'command');
        });


        me.myEventCls.onIds("#" + me.pre + "mn1_exportPdbRes", "click", function(e) { me.icn3d; //e.preventDefault();
           me.htmlCls.setHtmlCls.exportPdb();

           thisClass.setLogCmd("export pdb", true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn1_exportSecondary", "click", function(e) { me.icn3d; //e.preventDefault();
           me.htmlCls.setHtmlCls.exportSecondary();

           thisClass.setLogCmd("export secondary structure", true);
        });

        me.myEventCls.onIds(["#" + me.pre + "delphipdb", "#" + me.pre + "phipdb"], "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           let pdbStr = ic.saveFileCls.getSelectedResiduePDB();

           thisClass.setLogCmd("export PDB of selected residues", false);
           //let file_pref = Object.keys(ic.structures).join(',');
           let file_pref = Object.keys(ic.structures).join(',');
           ic.saveFileCls.saveFile(file_pref + '_icn3d_residues.pdb', 'text', [pdbStr]);
        });

        me.myEventCls.onIds(["#" + me.pre + "delphipqr", "#" + me.pre + "phipqr", "#" + me.pre + "phiurlpqr"], "click", async function(e) { me.icn3d; //e.preventDefault();
           await me.htmlCls.setHtmlCls.exportPqr();
           thisClass.setLogCmd("export pqr", true);
        });

      //   me.myEventCls.onIds("#" + me.pre + "delphipqbh", "click", async function(e) { let ic = me.icn3d; //e.preventDefault();
      //       let bPdb = true;
      //       await me.htmlCls.setHtmlCls.exportPqr(bPdb);
      //       thisClass.setLogCmd("export pdbh", false);
      //    });

        me.myEventCls.onIds("#" + me.pre + "profixpdb", "click", async function(e) { let ic = me.icn3d; //e.preventDefault();
         let bHydrogen = false;
         await ic.scapCls.exportPdbProfix(bHydrogen);
         thisClass.setLogCmd("export pdb missing atoms", true);
        });

        me.myEventCls.onIds("#" + me.pre + "profixpdbh", "click", async function(e) { let ic = me.icn3d; //e.preventDefault();
        let bHydrogen = true;
        await ic.scapCls.exportPdbProfix(bHydrogen);
        thisClass.setLogCmd("export pdb hydrogen", true);
       });

       me.myEventCls.onIds("#" + me.pre + "mn1_exportIgstrand", "click", async function(e) { let ic = me.icn3d; //e.preventDefault();
       ic.refnumCls.exportRefnum('igstrand');
       thisClass.setLogCmd("export refnum igstrand", true);
      });

      me.myEventCls.onIds("#" + me.pre + "mn1_exportKabat", "click", async function(e) { let ic = me.icn3d; //e.preventDefault();
      ic.refnumCls.exportRefnum('kabat');
         thisClass.setLogCmd("export refnum kabat", true);
      });

      me.myEventCls.onIds("#" + me.pre + "mn1_exportImgt", "click", async function(e) { let ic = me.icn3d; //e.preventDefault();
      ic.refnumCls.exportRefnum('imgt');
      thisClass.setLogCmd("export refnum imgt", true);
      });

        me.myEventCls.onIds("#" + me.pre + "mn1_exportStl", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           thisClass.setLogCmd("export stl file", false);
           //ic.threeDPrintCls.hideStabilizer();
           ic.export3DCls.exportStlFile('');
        });

        me.myEventCls.onIds("#" + me.pre + "mn1_exportVrml", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           thisClass.setLogCmd("export vrml file", false);
           //ic.threeDPrintCls.hideStabilizer();
           ic.export3DCls.exportVrmlFile('');
        });

        me.myEventCls.onIds("#" + me.pre + "mn1_exportStlStab", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           thisClass.setLogCmd("export stl stabilizer file", false);
           //ic.bRender = false;
           ic.threeDPrintCls.hideStabilizer();
           ic.threeDPrintCls.resetAfter3Dprint();
           ic.threeDPrintCls.addStabilizer();
           ic.export3DCls.exportStlFile('_stab');
        });

        me.myEventCls.onIds("#" + me.pre + "mn1_exportVrmlStab", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           thisClass.setLogCmd("export vrml stabilizer file", false);
           //ic.bRender = false;
           ic.threeDPrintCls.hideStabilizer();
           ic.threeDPrintCls.resetAfter3Dprint();
           ic.threeDPrintCls.addStabilizer();
           ic.export3DCls.exportVrmlFile('_stab');
        });

        me.myEventCls.onIds("#" + me.pre + "mn6_exportInteraction", "click", async function(e) { let ic = me.icn3d; //e.preventDefault();
           thisClass.setLogCmd("export interactions", false);
           if(me.cfg.mmdbid !== undefined) await ic.viewInterPairsCls.retrieveInteractionData();
           ic.viewInterPairsCls.exportInteractions();
        });

        me.myEventCls.onIds(["#" + me.pre + "mn1_exportCanvas", "#" + me.pre + "saveimage"], "click", async function(e) { let ic = me.icn3d; //e.preventDefault();
           // do not record the export command
           //thisClass.setLogCmd("export canvas", true);
           thisClass.setLogCmd("export canvas", false);
           //var file_pref =(ic.inputid) ? ic.inputid : "custom";
           //ic.saveFileCls.saveFile(file_pref + '_image_icn3d_loadable.png', 'png');
           let bPngHtml = true;
           await ic.shareLinkCls.shareLink(bPngHtml);
        });
        me.myEventCls.onIds("#" + me.pre + "mn1_exportCanvas1", "click", async function(e) { let ic = me.icn3d; //e.preventDefault();
           thisClass.setLogCmd("export canvas 1", true);
           ic.scaleFactor = 1;
           await ic.shareLinkCls.shareLink(true, true);
        });
        me.myEventCls.onIds("#" + me.pre + "mn1_exportCanvas2", "click", async function(e) { let ic = me.icn3d; //e.preventDefault();
           thisClass.setLogCmd("export canvas 2", true);
           ic.scaleFactor = 2;
           await ic.shareLinkCls.shareLink(true, true);
        });
        me.myEventCls.onIds("#" + me.pre + "mn1_exportCanvas4", "click", async function(e) { let ic = me.icn3d; //e.preventDefault();
           thisClass.setLogCmd("export canvas 4", true);
           ic.scaleFactor = 4;
           await ic.shareLinkCls.shareLink(true, true);
        });
        me.myEventCls.onIds("#" + me.pre + "mn1_exportCanvas8", "click", async function(e) { let ic = me.icn3d; //e.preventDefault();
           thisClass.setLogCmd("export canvas 8", true);
           ic.scaleFactor = 8;
           await ic.shareLinkCls.shareLink(true, true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn1_exportCounts", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           thisClass.setLogCmd("export counts", false);
           let text = '<html><body><div style="text-align:center"><br><b>Total Count for atoms with coordinates</b>:<br/><table align=center border=1 cellpadding=10 cellspacing=0><tr><th>Structure Count</th><th>Chain Count</th><th>Residue Count</th><th>Atom Count</th></tr>';
           text += '<tr><td>' + Object.keys(ic.structures).length + '</td><td>' + Object.keys(ic.chains).length + '</td><td>' + Object.keys(ic.residues).length + '</td><td>' + Object.keys(ic.atoms).length + '</td></tr>';
           text += '</table><br/>';
           text += '<b>Counts by Chain for atoms with coordinates</b>:<br/><table align=center border=1 cellpadding=10 cellspacing=0><tr><th>Structure</th><th>Chain</th><th>Residue Count</th><th>Atom Count</th></tr>';
           let chainArray = Object.keys(ic.chains);

           for(let i = 0, il = chainArray.length; i < il; ++i) {
               let chainid = chainArray[i];
               //if(!chainid) continue;

               let pos = chainid.indexOf('_');
               let structure = chainid.substr(0, pos);
               let chain = chainid.substr(pos + 1);
               let residueHash = {};
               let atoms = ic.chains[chainid];
               for(let j in atoms) {
                   residueHash[ic.atoms[j].resi] = 1;
               }
               text += '<tr><td>' + structure + '</td><td>' + chain + '</td><td>' + Object.keys(residueHash).length + '</td><td>' + Object.keys(ic.chains[chainid]).length + '</td></tr>';
           }
           text += '</table><br/></div></body></html>';
           let file_pref = Object.keys(ic.structures).join(',');
           ic.saveFileCls.saveFile(file_pref + '_counts.html', 'html', text);
        });

        me.myEventCls.onIds("#" + me.pre + "mn1_exportSelections", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           thisClass.setLogCmd("export all selections", false);
          
           thisClass.SetChainsAdvancedMenu();

           let text = ic.saveFileCls.exportCustomAtoms();
           let file_pref = Object.keys(ic.structures).join(',');
           ic.saveFileCls.saveFile(file_pref + '_selections.txt', 'text', [text]);
        });

        me.myEventCls.onIds("#" + me.pre + "mn1_exportSelDetails", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           thisClass.setLogCmd("export all selections with details", false);
          
           thisClass.SetChainsAdvancedMenu();

           let bDetails = true;
           let text = ic.saveFileCls.exportCustomAtoms(bDetails);
           let file_pref = Object.keys(ic.structures).join(',');
           ic.saveFileCls.saveFile(file_pref + '_sel_details.txt', 'text', [text]);
        });

        me.myEventCls.onIds(["#" + me.pre + "mn1_sharelink", "#" + me.pre + "tool_sharelink"], "click", async function(e) { let ic = me.icn3d; //e.preventDefault();
            await ic.shareLinkCls.shareLink();
        });

        me.myEventCls.onIds("#" + me.pre + "mn1_replayon", "click", async function(e) { let ic = me.icn3d; //e.preventDefault();
          await ic.resizeCanvasCls.replayon();
          thisClass.setLogCmd("replay on", true);
        });
        me.myEventCls.onIds("#" + me.pre + "mn1_replayoff", "click", async function(e) { let ic = me.icn3d; //e.preventDefault();
            await ic.resizeCanvasCls.replayoff();
            thisClass.setLogCmd("replay off", true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn1_menuall", "click", function(e) { me.icn3d; //e.preventDefault();
            me.htmlCls.shownMenus = me.hashUtilsCls.cloneHash(me.htmlCls.allMenus);

            thisClass.applyShownMenus();    
          });

        me.myEventCls.onIds("#" + me.pre + "mn1_menusimple", "click", function(e) { me.icn3d; //e.preventDefault();
            me.htmlCls.shownMenus = me.hashUtilsCls.cloneHash(me.htmlCls.simpleMenus);

            thisClass.applyShownMenus();
          });

        me.myEventCls.onIds("#" + me.pre + "mn1_menupref", "click", function(e) { me.icn3d; //e.preventDefault();
            me.htmlCls.dialogCls.openDlg('dl_menupref', 'Select Menus');

            thisClass.getHiddenMenusFromCache();

            thisClass.displayShownMenus();
         });

         me.myEventCls.onIds(["#" + me.pre + "apply_menupref", "#" + me.pre + "apply_menupref2"], "click", function(e) { me.icn3d; //e.preventDefault();
            var checkboxes = document.querySelectorAll('form[name="' + me.pre + 'selmenu"] input:checked');
            me.htmlCls.shownMenus = {};
            for (var checkbox of checkboxes) {
                me.htmlCls.shownMenus[checkbox.value] = 1;
            }

            me.htmlCls.setHtmlCls.setCookie('menumode', 'custom');

            thisClass.applyShownMenus();
         });

         me.myEventCls.onIds(["#" + me.pre + "reset_menupref", "#" + me.pre + "reset_menupref2"], "click", function(e) { me.icn3d; //e.preventDefault();
            me.htmlCls.shownMenus = me.hashUtilsCls.cloneHash(me.htmlCls.simpleMenus);
            me.htmlCls.setHtmlCls.setCookie('menumode', 'simple');

            thisClass.applyShownMenus();
            thisClass.displayShownMenus();
         });

         me.myEventCls.onIds(["#" + me.pre + "reset_menupref_all", "#" + me.pre + "reset_menupref_all2"], "click", function(e) { me.icn3d; //e.preventDefault();
            me.htmlCls.shownMenus = me.hashUtilsCls.cloneHash(me.htmlCls.allMenus);
            me.htmlCls.setHtmlCls.setCookie('menumode', 'all');

            thisClass.applyShownMenus();
            thisClass.displayShownMenus();
         });

         me.myEventCls.onIds(["#" + me.pre + "savepref", "#" + me.pre + "savepref2"], "click", function(e) { let ic = me.icn3d; //e.preventDefault();
            let menuStr = '[';

            //var checkboxes = document.querySelectorAll('form[name="' + me.pre + 'selmenu"] input:checked');
            var checkboxes = document.querySelectorAll('form[name="' + me.pre + 'selmenu"] input:not(:checked)');
            let cnt = 0;
            for (var checkbox of checkboxes) {
                if(cnt > 0) menuStr += ', ';
                menuStr += '"' + checkbox.value + '"';
                ++cnt;
            }
            
            menuStr += ']';
    
            ic.saveFileCls.saveFile('icn3d_menus_pref.txt', 'text', [menuStr]);
         });

         me.myEventCls.onIds("#" + me.pre + "reload_menupreffile", "click", function(e) { me.icn3d; 
            e.preventDefault();

            if(!me.cfg.notebook) dialog.dialog( "close" );
            let file = $("#" + me.pre + "menupreffile")[0].files[0];
            if(!file) {
              alert("Please select a file before clicking 'Load'");
            }
            else {
              me.htmlCls.setHtmlCls.fileSupport();
              let reader = new FileReader();
              reader.onload = function(e) {
                let dataStr = e.target.result; // or = reader.result;
                let idArray = JSON.parse(dataStr);

                me.htmlCls.shownMenus = {};
                // for(let i = 0, il = idArray.length; i < il; ++i) {
                //     me.htmlCls.shownMenus[idArray[i]] = 1;
                // }
                for(let menu in me.htmlCls.allMenus) {
                    if(idArray.indexOf(menu) == -1) {
                        me.htmlCls.shownMenus[menu] = 1;
                    }
                }

                thisClass.applyShownMenus();
                thisClass.displayShownMenus();

                me.htmlCls.setHtmlCls.setCookie('menumode', 'custom');
              };
              reader.readAsText(file);
            }
         });

        me.myEventCls.onIds(["#" + me.pre + "mn1_menuloadpref", "#" + me.pre + "loadpref", "#" + me.pre + "loadpref2"], "click", function(e) { me.icn3d; //e.preventDefault();
            me.htmlCls.dialogCls.openDlg('dl_menuloadpref', 'Please input the menu preference file');
        });

        me.myEventCls.onIds("#" + me.pre + "mn1_link_structure", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           let url = ic.saveFileCls.getLinkToStructureSummary(true);
           let urlTarget = (ic.structures && Object.keys(ic.structures).length > 0) ? '_blank' : '_self';
           window.open(url, urlTarget);
        });

        me.myEventCls.onIds("#" + me.pre + "mn1_alphafold", "click", function(e) { me.icn3d; //e.preventDefault();
           let url = 'https://github.com/sokrypton/ColabFold';
           window.open(url, '_blank');
        });

        me.myEventCls.onIds("#" + me.pre + "mn1_link_bind", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           let url = "https://www.ncbi.nlm.nih.gov/pccompound?LinkName=pccompound_structure&from_uid=" + ic.inputid;
           thisClass.setLogCmd("link to 3D protein structures bound to CID " + ic.inputid + ": " + url, false);
           let urlTarget = (ic.structures && Object.keys(ic.structures).length > 0) ? '_blank' : '_self';
           window.open(url, urlTarget);
        });

        me.myEventCls.onIds("#" + me.pre + "mn1_link_vast", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
         let url;  
         if(ic.inputid === undefined) {
               url = "https://www.ncbi.nlm.nih.gov/pccompound?term=" + ic.molTitle;
               thisClass.setLogCmd("link to compounds " + ic.molTitle + ": " + url, false);
           }
           else {
               if(me.cfg.cid !== undefined) {
                       url = "https://www.ncbi.nlm.nih.gov/pccompound?LinkName=pccompound_pccompound_3d&from_uid=" + ic.inputid;
                       thisClass.setLogCmd("link to compounds with structure similar to CID " + ic.inputid + ": " + url, false);
               }
               else {
                   let idArray = ic.inputid.split('_');
                   
                   if(idArray.length === 1) {
                       url = me.htmlCls.baseUrl + "vastplus/vastplus.cgi?uid=" + ic.inputid;
                       thisClass.setLogCmd("link to structures similar to " + ic.inputid + ": " + url, false);
                   }
                   else if(idArray.length === 2) {
                       url = me.htmlCls.baseUrl + "vastplus/vastplus.cgi?uid=" + idArray[0];
                       thisClass.setLogCmd("link to structures similar to " + idArray[0] + ": " + url, false);
                   }
               }
           }

           let urlTarget = (ic.structures && Object.keys(ic.structures).length > 0) ? '_blank' : '_self';
           window.open(url, urlTarget);
        });

        me.myEventCls.onIds("#" + me.pre + "mn1_link_pubmed", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           let url;
           if(ic.inputid === undefined) {
               url = "https://www.ncbi.nlm.nih.gov/pubmed/?term=" + ic.molTitle;
               thisClass.setLogCmd("link to literature about " + ic.molTitle + ": " + url, false);
               let urlTarget = (ic.structures && Object.keys(ic.structures).length > 0) ? '_blank' : '_self';
               window.open(url, urlTarget);
           }
           else if(ic.pmid) {
               let idArray = ic.pmid.toString().split('_');
               if(idArray.length === 1) {
                   url = "https://www.ncbi.nlm.nih.gov/pubmed/" + ic.pmid;
                   thisClass.setLogCmd("link to PubMed ID " + ic.pmid + ": " + url, false);
               }
               else if(idArray.length === 2) {
                   url = "https://www.ncbi.nlm.nih.gov/pubmed/?term=" + idArray[0] + " OR " + idArray[1];
                   thisClass.setLogCmd("link to PubMed IDs " + idArray[0] + ", " + idArray[1] + ": " + url, false);
               }
               let urlTarget = (ic.structures && Object.keys(ic.structures).length > 0) ? '_blank' : '_self';
               window.open(url, urlTarget);
           }
           else if(isNaN(ic.inputid)) {
               let idArray = ic.inputid.toString().split('_');
               if(idArray.length === 1) {
                   url = "https://www.ncbi.nlm.nih.gov/pubmed/?term=" + ic.inputid;
                   thisClass.setLogCmd("link to literature about PDB " + ic.inputid + ": " + url, false);
               }
               else if(idArray.length === 2) {
                   url = "https://www.ncbi.nlm.nih.gov/pubmed/?term=" + idArray[0] + " OR " + idArray[1];
                   thisClass.setLogCmd("link to literature about PDB " + idArray[0] + " OR " + idArray[1] + ": " + url, false);
               }
               let urlTarget = (ic.structures && Object.keys(ic.structures).length > 0) ? '_blank' : '_self';
               window.open(url, urlTarget);
           }
           else {
               if(me.cfg.cid !== undefined) {
                   alert("No literature information is available for this compound in the SDF file.");
               }
               else {
                   alert("No literature information is available for this structure.");
               }
           }
        });

        me.myEventCls.onIds("#" + me.pre + "mn1_link_protein", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
          //ic.saveFileCls.setEntrezLinks('protein');
          let structArray = Object.keys(ic.structures);
          let chainArray = Object.keys(ic.chains);
          let text = '';
          for(let i = 0, il = chainArray.length; i < il; ++i) {
              let firstAtom = ic.firstAtomObjCls.getFirstCalphaAtomObj(ic.chains[chainArray[i]]);
              if(ic.proteins.hasOwnProperty(firstAtom.serial) && chainArray[i].length == 6) {
                  text += chainArray[i] + '[accession] OR ';
              }
          }
          if(text.length > 0) text = text.substr(0, text.length - 4);
          let url = "https://www.ncbi.nlm.nih.gov/protein/?term=" + text;
          thisClass.setLogCmd("link to Entrez protein about PDB " + structArray + ": " + url, false);
          let urlTarget = (ic.structures && Object.keys(ic.structures).length > 0) ? '_blank' : '_self';
          window.open(url, urlTarget);
        });

    }

    clickMenu2() { let me = this.icn3dui; me.icn3d;
        if(me.bNode) return;

        let thisClass = this;

        me.myEventCls.onIds(["#" + me.pre + "mn6_selectannotations", "#" + me.pre + "tool_selectannotations"], "click", async function(e) { let ic = me.icn3d; //e.preventDefault();
           await ic.showAnnoCls.showAnnotations();
           thisClass.setLogCmd("view annotations", true);
           //thisClass.setLogCmd("window annotations", true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn2_selectall", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           thisClass.setLogCmd("select all", true);
           ic.selectionCls.selectAll();
           ic.hlUpdateCls.removeHlAll();
           ic.drawCls.draw();
        });
        me.myEventCls.onIds("#" + me.pre + "clearall", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           thisClass.setLogCmd("clear all", true);
           ic.bSelectResidue = false;
           ic.selectionCls.selectAll();
           ic.hlUpdateCls.removeHlAll();
           ic.drawCls.draw();
        });

        me.myEventCls.onIds("#" + me.pre + "mn2_selectdisplayed", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           thisClass.setLogCmd("select displayed set", true);
           //ic.hAtoms = me.hashUtilsCls.cloneHash(ic.dAtoms);
           ic.hAtoms = me.hashUtilsCls.cloneHash(ic.viewSelectionAtoms);
           ic.hlUpdateCls.updateHlAll();
           //ic.drawCls.draw();
        });

        me.myEventCls.onIds("#" + me.pre + "mn2_clashedYes", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
            ic.bHideClashed = false;
            ic.annoDomainCls.showHideClashedResidues();

            ic.drawCls.draw();
            thisClass.setLogCmd('clashed residues show', true);
        });
        me.myEventCls.onIds("#" + me.pre + "mn2_clashedNo", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
            ic.bHideClashed = true;

            thisClass.setClashedResidues();
            ic.annoDomainCls.showHideClashedResidues();

            ic.drawCls.draw();
            thisClass.setLogCmd('clashed residues hide', true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn2_fullstru", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           thisClass.setLogCmd("show all", true);
           ic.selectionCls.showAll();
        });

        me.myEventCls.onIds("#" + me.pre + "mn2_selectcomplement", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           if(Object.keys(ic.hAtoms).length < Object.keys(ic.atoms).length) {
               thisClass.setLogCmd("select complement", true);
               ic.resid2specCls.selectComplement();
           }
        });

        me.myEventCls.onIds("#" + me.pre + "mn2_selectmainchains", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           thisClass.setLogCmd("select main chains", true);
           ic.selectionCls.selectMainChains();
        });

        me.myEventCls.onIds("#" + me.pre + "mn2_selectsidechains", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           thisClass.setLogCmd("select side chains", true);
           ic.selectionCls.selectSideChains();
        });

        me.myEventCls.onIds("#" + me.pre + "mn2_selectmainsidechains", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           thisClass.setLogCmd("select main side chains", true);
           ic.selectionCls.selectMainSideChains();
        });

        me.myEventCls.onIds("#" + me.pre + "mn2_propPos", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           thisClass.setLogCmd("select prop positive", true);
           ic.resid2specCls.selectProperty('positive');
        });
        me.myEventCls.onIds("#" + me.pre + "mn2_propNeg", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           thisClass.setLogCmd("select prop negative", true);
           ic.resid2specCls.selectProperty('negative');
        });
        me.myEventCls.onIds("#" + me.pre + "mn2_propHydro", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           thisClass.setLogCmd("select prop hydrophobic", true);
           ic.resid2specCls.selectProperty('hydrophobic');
        });
        me.myEventCls.onIds("#" + me.pre + "mn2_propPolar", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           thisClass.setLogCmd("select prop polar", true);
           ic.resid2specCls.selectProperty('polar');
        });
        me.myEventCls.onIds("#" + me.pre + "mn2_propBfactor", "click", function(e) { me.icn3d; //e.preventDefault();
           me.htmlCls.dialogCls.openDlg('dl_propbybfactor', 'Select residue based on B-factor/pLDDT');
        });
        me.myEventCls.onIds("#" + me.pre + "mn2_propSolAcc", "click", function(e) { me.icn3d; //e.preventDefault();
           me.htmlCls.dialogCls.openDlg('dl_propbypercentout', 'Select residue based on the percentage of solvent accessilbe surface area');
        });
        me.myEventCls.onIds("#" + me.pre + "applypropbybfactor", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           let from = $("#" + me.pre + "minbfactor").val();
           let to = $("#" + me.pre + "maxbfactor").val();
           thisClass.setLogCmd("select prop b factor | " + from + '_' + to, true);
           ic.resid2specCls.selectProperty('b factor', from, to);
        });
        me.myEventCls.onIds("#" + me.pre + "applypropbypercentout", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           let from = $("#" + me.pre + "minpercentout").val();
           let to = $("#" + me.pre + "maxpercentout").val();
           thisClass.setLogCmd("select prop percent out | " + from + '_' + to, true);
           ic.resid2specCls.selectProperty('percent out', from, to);
        });

        me.myEventCls.onIds("#" + me.pre + "mn2_alignment", "click", function(e) { me.icn3d; //e.preventDefault();
           me.htmlCls.dialogCls.openDlg('dl_alignment', 'Select residues in aligned sequences');
           thisClass.setLogCmd("window aligned sequences", true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn1_window_table", "click", function(e) { me.icn3d; //e.preventDefault();
           me.htmlCls.dialogCls.openDlg('dl_allinteraction', 'Show interactions');
           thisClass.setLogCmd("window interaction table", true);
        });
        me.myEventCls.onIds("#" + me.pre + "mn1_window_linegraph", "click", function(e) { me.icn3d; //e.preventDefault();
           me.htmlCls.dialogCls.openDlg('dl_linegraph', 'Show interactions between two lines of residue nodes');
           thisClass.setLogCmd("window interaction graph", true);
        });
        me.myEventCls.onIds("#" + me.pre + "mn1_window_scatterplot", "click", function(e) { me.icn3d; //e.preventDefault();
           me.htmlCls.dialogCls.openDlg('dl_scatterplot', 'Show interactions as map');
           thisClass.setLogCmd("window interaction scatterplot", true);
        });
        me.myEventCls.onIds("#" + me.pre + "mn1_window_graph", "click", function(e) { me.icn3d; //e.preventDefault();
           me.htmlCls.dialogCls.openDlg('dl_graph', 'Force-directed graph');
           thisClass.setLogCmd("window force-directed graph", true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn6_yournote", "click", function(e) { me.icn3d; //e.preventDefault();
           me.htmlCls.dialogCls.openDlg('dl_yournote', 'Your note about the current display');
        });

        me.myEventCls.onIds("#" + me.pre + "applyyournote", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.yournote = $("#" + me.pre + "yournote").val();
           if(me.cfg.shownote) document.title = ic.yournote;
           if(!me.cfg.notebook) dialog.dialog( "close" );
           thisClass.setLogCmd('your note | ' + ic.yournote, true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn2_command", "click", function(e) { me.icn3d; //e.preventDefault();
           me.htmlCls.dialogCls.openDlg('dl_advanced2', 'Select by specification');
        });

        me.myEventCls.onIds(["#" + me.pre + "mn2_definedsets", "#" + me.pre + "definedsets", "#" + me.pre + "definedsets2", "#" + me.pre + "tool_definedsets"], "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.definedSetsCls.showSets();
           thisClass.setLogCmd('defined sets', true);
           //thisClass.setLogCmd('window defined sets', true);
        });
        $(document).on("click", "#" + me.pre + "setOr", function(e) { let ic = me.icn3d;
            e.stopImmediatePropagation();
            ic.setOperation = 'or';
        });
        $(document).on("click", "#" + me.pre + "setAnd", function(e) { let ic = me.icn3d;
            e.stopImmediatePropagation();
            ic.setOperation = 'and';
        });
        $(document).on("click", "#" + me.pre + "setNot", function(e) { let ic = me.icn3d;
            e.stopImmediatePropagation();
            ic.setOperation = 'not';
        });


        me.myEventCls.onIds("#" + me.pre + "mn2_pkNo", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.pk = 0;
           ic.opts['pk'] = 'no';
           thisClass.setLogCmd('set pk off', true);
           ic.drawCls.draw();
           ic.hlObjectsCls.removeHlObjects();
        });

        me.myEventCls.onIds("#" + me.pre + "mn2_pkYes", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.pk = 1;
           ic.opts['pk'] = 'atom';
           thisClass.setLogCmd('set pk atom', true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn2_pkResidue", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.pk = 2;
           ic.opts['pk'] = 'residue';
           thisClass.setLogCmd('set pk residue', true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn2_pkStrand", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.pk = 3;
           ic.opts['pk'] = 'strand';
           thisClass.setLogCmd('set pk strand', true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn2_pkDomain", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.pk = 4;
           ic.opts['pk'] = 'domain';
           thisClass.setLogCmd('set pk domain', true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn2_pkChain", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.pk = 5;
           ic.opts['pk'] = 'chain';
           thisClass.setLogCmd('set pk chain', true);
        });

        me.myEventCls.onIds("#" + me.pre + "adjustmem", "click", function(e) { me.icn3d; //e.preventDefault();
            me.htmlCls.dialogCls.openDlg('dl_adjustmem', 'Adjust the Z-axis positions of the membrane');
        });

        me.myEventCls.onIds("#" + me.pre + "togglemem", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.selectionCls.toggleMembrane();
           thisClass.setLogCmd('toggle membrane', true);
        });

        me.myEventCls.onIds("#" + me.pre + "selectplane", "click", function(e) { me.icn3d; //e.preventDefault();
            me.htmlCls.dialogCls.openDlg('dl_selectplane', 'Select a region between two planes');
        });

        me.myEventCls.onIds(["#" + me.pre + "mn2_aroundsphere", "#" + me.pre + "tool_aroundsphere"], "click", function(e) { let ic = me.icn3d; //e.preventDefault();
            thisClass.SetChainsAdvancedMenu();

            let definedAtomsHtml = ic.definedSetsCls.setAtomMenu(['protein']);
            if($("#" + me.pre + "atomsCustomSphere").length) {
                $("#" + me.pre + "atomsCustomSphere").html("  <option value='non-selected' selected>non-selected</option><option value='selected'>selected</option>" + definedAtomsHtml);
            }
            if($("#" + me.pre + "atomsCustomSphere2").length) {
                $("#" + me.pre + "atomsCustomSphere2").html("  <option value='selected' selected>selected</option>" + definedAtomsHtml);
            }
            me.htmlCls.dialogCls.openDlg('dl_aroundsphere', 'Select a sphere around a set of residues');
            ic.bSphereCalc = false;
            //thisClass.setLogCmd('set calculate sphere false', true);
            $("#" + me.pre + "atomsCustomSphere").resizable();
            $("#" + me.pre + "atomsCustomSphere2").resizable();
        });

        me.myEventCls.onIds(["#" + me.pre + "mn2_select_chain", "#" + me.pre + "definedSets"], "click", function(e) { me.icn3d; //e.preventDefault();
           me.htmlCls.dialogCls.openDlg('dl_select_chain', 'Select Structure/Chain/Custom Selection');
        });

    }

    clickMenu3() { let me = this.icn3dui; me.icn3d;
        if(me.bNode) return;

        let thisClass = this;
    // mn 3
        me.myEventCls.onIds(["#" + me.pre + "mn3_proteinsRibbon","#" + me.pre + "tool_proteinsRibbon"], "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.setOptionCls.setStyle('proteins', 'ribbon');
           thisClass.setLogCmd('style proteins ribbon', true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn3_proteinsStrand", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.setOptionCls.setStyle('proteins', 'strand');
           thisClass.setLogCmd('style proteins strand', true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn3_proteinsCylinder", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.setOptionCls.setStyle('proteins', 'cylinder and plate');
           thisClass.setLogCmd('style proteins cylinder and plate', true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn3_proteinsSchematic", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.setOptionCls.setStyle('proteins', 'schematic');
           thisClass.setLogCmd('style proteins schematic', true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn3_proteinsCalpha", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.setOptionCls.setStyle('proteins', 'c alpha trace');
           thisClass.setLogCmd('style proteins c alpha trace', true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn3_proteinsBackbone", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.setOptionCls.setStyle('proteins', 'backbone');
           thisClass.setLogCmd('style proteins backbone', true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn3_proteinsBfactor", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.setOptionCls.setStyle('proteins', 'b factor tube');
           thisClass.setLogCmd('style proteins b factor tube', true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn3_proteinsLines", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.setOptionCls.setStyle('proteins', 'lines');
           thisClass.setLogCmd('style proteins lines', true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn3_proteinsStick", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.setOptionCls.setStyle('proteins', 'stick');
           thisClass.setLogCmd('style proteins stick', true);
        });

        me.myEventCls.onIds(["#" + me.pre + "mn3_proteinsBallstick", "#" + me.pre + "tool_proteinsBallstick"], "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.setOptionCls.setStyle('proteins', 'ball and stick');
           thisClass.setLogCmd('style proteins ball and stick', true);
        });

        me.myEventCls.onIds(["#" + me.pre + "mn3_proteinsSphere", "#" + me.pre + "tool_proteinsSphere"], "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.setOptionCls.setStyle('proteins', 'sphere');
           thisClass.setLogCmd('style proteins sphere', true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn3_proteinsNo", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.setOptionCls.setStyle('proteins', 'nothing');
           thisClass.setLogCmd('style proteins nothing', true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn3_sidecLines", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.setOptionCls.setStyle('sidec', 'lines2');
           thisClass.setLogCmd('style sidec lines2', true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn3_sidecStick", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.setOptionCls.setStyle('sidec', 'stick2');
           thisClass.setLogCmd('style sidec stick2', true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn3_sidecBallstick", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.setOptionCls.setStyle('sidec', 'ball and stick2');
           thisClass.setLogCmd('style sidec ball and stick2', true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn3_sidecSphere", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.setOptionCls.setStyle('sidec', 'sphere2');
           thisClass.setLogCmd('style sidec sphere2', true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn3_sidecNo", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.setOptionCls.setStyle('sidec', 'nothing');
           thisClass.setLogCmd('style sidec nothing', true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn3_ntbaseLines", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
            ic.setOptionCls.setStyle('ntbase', 'lines2');
            thisClass.setLogCmd('style ntbase lines2', true);
         });
 
         me.myEventCls.onIds("#" + me.pre + "mn3_ntbaseStick", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
            ic.setOptionCls.setStyle('ntbase', 'stick2');
            thisClass.setLogCmd('style ntbase stick2', true);
         });
 
         me.myEventCls.onIds("#" + me.pre + "mn3_ntbaseBallstick", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
            ic.setOptionCls.setStyle('ntbase', 'ball and stick2');
            thisClass.setLogCmd('style ntbase ball and stick2', true);
         });
 
         me.myEventCls.onIds("#" + me.pre + "mn3_ntbaseSphere", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
            ic.setOptionCls.setStyle('ntbase', 'sphere2');
            thisClass.setLogCmd('style ntbase sphere2', true);
         });
 
         me.myEventCls.onIds("#" + me.pre + "mn3_ntbaseNo", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
            ic.setOptionCls.setStyle('ntbase', 'nothing');
            thisClass.setLogCmd('style ntbase nothing', true);
         });

        me.myEventCls.onIds("#" + me.pre + "mn3_nuclCartoon", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.setOptionCls.setStyle('nucleotides', 'nucleotide cartoon');
           thisClass.setLogCmd('style nucleotides nucleotide cartoon', true);
       });

        me.myEventCls.onIds("#" + me.pre + "mn3_nuclBackbone", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.setOptionCls.setStyle('nucleotides', 'backbone');
           thisClass.setLogCmd('style nucleotides backbone', true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn3_nuclSchematic", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.setOptionCls.setStyle('nucleotides', 'schematic');
           thisClass.setLogCmd('style nucleotides schematic', true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn3_nuclPhos", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.setOptionCls.setStyle('nucleotides', 'o3 trace');
           thisClass.setLogCmd('style nucleotides o3 trace', true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn3_nuclLines", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.setOptionCls.setStyle('nucleotides', 'lines');
           thisClass.setLogCmd('style nucleotides lines', true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn3_nuclStick", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.setOptionCls.setStyle('nucleotides', 'stick');
           thisClass.setLogCmd('style nucleotides stick', true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn3_nuclBallstick", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.setOptionCls.setStyle('nucleotides', 'ball and stick');
           thisClass.setLogCmd('style nucleotides ball and stick', true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn3_nuclSphere", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.setOptionCls.setStyle('nucleotides', 'sphere');
           thisClass.setLogCmd('style nucleotides sphere', true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn3_nuclNo", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.setOptionCls.setStyle('nucleotides', 'nothing');
           thisClass.setLogCmd('style nucleotides nothing', true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn3_ligLines", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.setOptionCls.setStyle('chemicals', 'lines');
           thisClass.setLogCmd('style chemicals lines', true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn3_ligStick", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.setOptionCls.setStyle('chemicals', 'stick');
           thisClass.setLogCmd('style chemicals stick', true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn3_ligBallstick", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.setOptionCls.setStyle('chemicals', 'ball and stick');
           thisClass.setLogCmd('style chemicals ball and stick', true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn3_ligSchematic", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.setOptionCls.setStyle('chemicals', 'schematic');
           thisClass.setLogCmd('style chemicals schematic', true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn3_ligSphere", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.setOptionCls.setStyle('chemicals', 'sphere');
           thisClass.setLogCmd('style chemicals sphere', true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn3_ligNo", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.setOptionCls.setStyle('chemicals', 'nothing');
           thisClass.setLogCmd('style chemicals nothing', true);
        });


        me.myEventCls.onIds("#" + me.pre + "mn3_glycansCartYes", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.bGlycansCartoon = true;
           ic.drawCls.draw();
           thisClass.setLogCmd('glycans cartoon yes', true);
        });
        me.myEventCls.onIds("#" + me.pre + "mn3_glycansCartNo", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.bGlycansCartoon = false;
           ic.drawCls.draw();
           thisClass.setLogCmd('glycans cartoon no', true);
        });


        me.myEventCls.onIds("#" + me.pre + "mn3_hydrogensYes", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.showInterCls.showHydrogens();
           ic.drawCls.draw();
           thisClass.setLogCmd('hydrogens', true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn3_hydrogensNo", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.showInterCls.hideHydrogens();
           ic.drawCls.draw();
           thisClass.setLogCmd('set hydrogens off', true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn3_ionsSphere", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.setOptionCls.setStyle('ions', 'sphere');
           thisClass.setLogCmd('style ions sphere', true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn3_ionsDot", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.setOptionCls.setStyle('ions', 'dot');
           thisClass.setLogCmd('style ions dot', true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn3_ionsNo", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.setOptionCls.setStyle('ions', 'nothing');
           thisClass.setLogCmd('style ions nothing', true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn3_waterSphere", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.setOptionCls.setStyle('water', 'sphere');
           thisClass.setLogCmd('style water sphere', true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn3_waterDot", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.setOptionCls.setStyle('water', 'dot');
           thisClass.setLogCmd('style water dot', true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn3_waterNo", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.setOptionCls.setStyle('water', 'nothing');
           thisClass.setLogCmd('style water nothing', true);
        });

    }

    clickMenu4() { let me = this.icn3dui; me.icn3d;
        if(me.bNode) return;

        let thisClass = this;
    // mn 4
        me.myEventCls.onIds("#" + me.pre + "mn4_clrSpectrum", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.setOptionCls.setOption('color', 'spectrum');
           thisClass.setLogCmd('color spectrum', true);
        });
        me.myEventCls.onIds("#" + me.pre + "mn4_clrSpectrumChain", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.setOptionCls.setOption('color', 'spectrum for chains');
           thisClass.setLogCmd('color spectrum for chains', true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn4_clrSpectrumAcrossSets", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
             thisClass.SetChainsAdvancedMenu();
             let definedAtomsHtml = ic.definedSetsCls.setAtomMenu(['protein']);
             if($("#" + me.pre + "atomsCustomColorSpectrumAcross").length) {
                 $("#" + me.pre + "atomsCustomColorSpectrumAcross").html(definedAtomsHtml);
             }

             if(ic.bRender) me.htmlCls.dialogCls.openDlg('dl_colorspectrumacrosssets', 'Please select sets to apply spectrum color for sets');
             $("#" + me.pre + "atomsCustomColorSpectrumAcross").resizable();
         });

         me.myEventCls.onIds("#" + me.pre + "mn4_clrSpectrumSets", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
             thisClass.SetChainsAdvancedMenu();
             let definedAtomsHtml = ic.definedSetsCls.setAtomMenu(['protein']);
             if($("#" + me.pre + "atomsCustomColorSpectrum").length) {
                 $("#" + me.pre + "atomsCustomColorSpectrum").html(definedAtomsHtml);
             }

             if(ic.bRender) me.htmlCls.dialogCls.openDlg('dl_colorspectrumbysets', 'Please select sets to apply spectrum color for residues');
             $("#" + me.pre + "atomsCustomColorSpectrum").resizable();
         });

         me.myEventCls.onIds("#" + me.pre + "mn4_clrRainbowAcrossSets", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
             thisClass.SetChainsAdvancedMenu();
             let definedAtomsHtml = ic.definedSetsCls.setAtomMenu(['protein']);
             if($("#" + me.pre + "atomsCustomColorRainbowAcross").length) {
                 $("#" + me.pre + "atomsCustomColorRainbowAcross").html(definedAtomsHtml);
             }

             if(ic.bRender) me.htmlCls.dialogCls.openDlg('dl_colorrainbowacrosssets', 'Please select sets to apply rainbow color for sets');
             $("#" + me.pre + "atomsCustomColorRainbowAcross").resizable();
         });

         me.myEventCls.onIds("#" + me.pre + "mn4_clrRainbowSets", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
             thisClass.SetChainsAdvancedMenu();
             let definedAtomsHtml = ic.definedSetsCls.setAtomMenu(['protein']);
             if($("#" + me.pre + "atomsCustomColorRainbow").length) {
                 $("#" + me.pre + "atomsCustomColorRainbow").html(definedAtomsHtml);
             }

             if(ic.bRender) me.htmlCls.dialogCls.openDlg('dl_colorrainbowbysets', 'Please select sets to apply rainbow color for residues');
             $("#" + me.pre + "atomsCustomColorRainbow").resizable();
         });

        me.myEventCls.onIds("#" + me.pre + "mn4_clrRainbow", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.setOptionCls.setOption('color', 'rainbow');

           thisClass.setLogCmd('color rainbow', true);
        });
        me.myEventCls.onIds(["#" + me.pre + "mn4_clrRainbowChain", "#" + me.pre + "tool_clrRainbowChain"], "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.setOptionCls.setOption('color', 'rainbow for chains');
           thisClass.setLogCmd('color rainbow for chains', true);
        });

        me.myEventCls.onIds(["#" + me.pre + "mn4_clrChain", "#" + me.pre + "tool_clrChain"], "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.setOptionCls.setOption('color', 'chain');
           thisClass.setLogCmd('color chain', true);
        });
        me.myEventCls.onIds("#" + me.pre + "mn4_clrStructure", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
            ic.setOptionCls.setOption('color', 'structure');
            thisClass.setLogCmd('color structure', true);
         });

        me.myEventCls.onIds("#" + me.pre + "mn4_clrdomain", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.setOptionCls.setOption('color', 'domain');
           thisClass.setLogCmd('color domain', true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn4_clrsets", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.setOptionCls.setOption('color', 'defined sets');
           thisClass.setLogCmd('color defined sets', true);
        });


        me.myEventCls.onIds(["#" + me.pre + "mn4_clrSSGreen", "#" + me.pre + "tool_clrSSGreen"], "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.sheetcolor = 'green';
           ic.setOptionCls.setOption('color', 'secondary structure green');
           thisClass.setLogCmd('color secondary structure green', true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn4_clrSSYellow", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.sheetcolor = 'yellow';
           ic.setOptionCls.setOption('color', 'secondary structure yellow');
           thisClass.setLogCmd('color secondary structure yellow', true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn4_clrSSSpectrum", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.setOptionCls.setOption('color', 'secondary structure spectrum');
           thisClass.setLogCmd('color secondary structure spectrum', true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn4_clrResidue", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
            //ic.legendClick = 2;
            ic.setOptionCls.setOption('color', 'residue');
            thisClass.setLogCmd('color residue', true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn4_clrResidueCustom", "click", function(e) { me.icn3d; //e.preventDefault();
            //ic.legendClick = 2;
            me.htmlCls.dialogCls.openDlg('dl_rescolorfile', 'Please input the file on residue colors');
        });

        me.myEventCls.onIds("#" + me.pre + "reload_rescolorfile", "click", function(e) { let ic = me.icn3d; 
           e.preventDefault();

           if(!me.cfg.notebook) dialog.dialog( "close" );
           let file = $("#" + me.pre + "rescolorfile")[0].files[0];
           if(!file) {
             alert("Please select a file before clicking 'Load'");
           }
           else {
             me.htmlCls.setHtmlCls.fileSupport();
             let reader = new FileReader();
             reader.onload = function(e) {
               let dataStrTmp = e.target.result; // or = reader.result;
               let dataStr = dataStrTmp.replace(/#/g, "");
               ic.customResidueColors = JSON.parse(dataStr);
               for(let res in ic.customResidueColors) {
                   ic.customResidueColors[res.toUpperCase()] = me.parasCls.thr("#" + ic.customResidueColors[res]);
               }
               ic.setOptionCls.setOption('color', 'residue custom');
               thisClass.setLogCmd('color residue custom | ' + dataStr, true);
             };
             reader.readAsText(file);
           }
        });

        me.myEventCls.onIds("#" + me.pre + "reload_customcolorfile", "click", function(e) { let ic = me.icn3d; 
           e.preventDefault();

           if(!me.cfg.notebook) dialog.dialog( "close" );
           ic.startColor = $("#" + me.pre + "startColor").val();
           ic.midColor = $("#" + me.pre + "midColor").val();
           ic.endColor = $("#" + me.pre + "endColor").val();

           let legendHtml = thisClass.setLegendHtml();
           //$("#" + me.pre + "legend").html(legendHtml).show();
           $("#" + me.pre + "dl_legend_html").html(legendHtml);
           me.htmlCls.dialogCls.openDlg('dl_legend', 'Color range');

           ic.addTrackCls.setCustomFile('color', ic.startColor, ic.midColor, ic.endColor);
        });

        me.myEventCls.onIds("#" + me.pre + "mn6_customref", "click", function(e) { me.icn3d; //e.preventDefault();
 
            me.htmlCls.dialogCls.openDlg('dl_customref', 'Set custom reference numbers');
         });

        me.myEventCls.onIds("#" + me.pre + "reload_customreffile", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
 
            if(!me.cfg.notebook) dialog.dialog( "close" );
            
            let file = $("#" + ic.pre + "cstreffile")[0].files[0];
            if(!file) {
                alert("Please select a file before clicking 'Apply'");
            }
            else {
                me.utilsCls.checkFileAPI();
                let reader = new FileReader();
                reader.onload = async function(e) {
                    let dataStr = e.target.result; // or = reader.result;
                    await ic.refnumCls.parseCustomRefFile(dataStr);

                    dataStr = dataStr.replace(/\r/g, '').replace(/\n/g, '\\n');

                    thisClass.setLogCmd('custom refnum | ' + dataStr, true);
                };
                reader.readAsText(file);
            }
        }); 

        me.myEventCls.onIds("#" + me.pre + "remove_legend", "click", function(e) { me.icn3d; 
           e.preventDefault();

           $("#" + me.pre + "legend").hide();

           thisClass.setLogCmd('remove legend', true);
        });
        me.myEventCls.onIds("#" + me.pre + "reload_customtubefile", "click", function(e) { let ic = me.icn3d; 
           e.preventDefault();

           if(!me.cfg.notebook) dialog.dialog( "close" );
           ic.addTrackCls.setCustomFile('tube');
        });

        me.myEventCls.onIds("#" + me.pre + "mn4_clrCharge", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
            //ic.legendClick = 3;
            ic.setOptionCls.setOption('color', 'charge');
            thisClass.setLogCmd('color charge', true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn4_clrHydrophobic", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
            //ic.legendClick = 4; 
            ic.setOptionCls.setOption('color', 'hydrophobic');
            thisClass.setLogCmd('color hydrophobic', true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn4_clrNormalizedHP", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
            //ic.legendClick = 4;
            ic.setOptionCls.setOption('color', 'normalized hydrophobic');
            thisClass.setLogCmd('color normalized hydrophobic', true);
        });


        me.myEventCls.onIds(["#" + me.pre + "mn4_clrAtom", "#" + me.pre + "tool_clrAtom"], "click", function(e) { let ic = me.icn3d; //e.preventDefault();
            //ic.legendClick = 1;
            ic.setOptionCls.setOption('color', 'atom');
            thisClass.setLogCmd('color atom', true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn4_clrBfactor", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
            //ic.legendClick = 5;
            ic.setOptionCls.setOption('color', 'b factor');
            thisClass.setLogCmd('color b factor', true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn4_clrConfidence", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
            //ic.legendClick = 6;
            ic.setOptionCls.setOption('color', 'confidence');
            thisClass.setLogCmd('color confidence', true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn4_clrIgstrand", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
            //ic.legendClick = 6;
            ic.setOptionCls.setOption('color', 'ig strand');
            thisClass.setLogCmd('color ig strand', true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn4_clrIgproto", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
            //ic.legendClick = 6;
            ic.setOptionCls.setOption('color', 'ig protodomain');
            thisClass.setLogCmd('color ig protodomain', true);
        });


        me.myEventCls.onIds("#" + me.pre + "mn4_clrArea", "click", function(e) { me.icn3d; //e.preventDefault();
            me.htmlCls.dialogCls.openDlg('dl_colorbyarea', "Color based on residue's solvent accessibility");
        });
        me.myEventCls.onIds("#" + me.pre + "applycolorbyarea", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
            ic.midpercent = $("#" + me.pre + 'midpercent').val();
            ic.setOptionCls.setOption('color', 'area');
            thisClass.setLogCmd('color area | ' + ic.midpercent, true);

        });

        me.myEventCls.onIds("#" + me.pre + "mn4_clrBfactorNorm", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.setOptionCls.setOption('color', 'b factor percentile');
           thisClass.setLogCmd('color b factor percentile', true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn4_clrIdentity", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.setOptionCls.setOption('color', 'identity');
           thisClass.setLogCmd('color identity', true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn4_clrConserved", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.setOptionCls.setOption('color', 'conservation');
           thisClass.setLogCmd('color conservation', true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn4_clrCustom", "click", function(e) { me.icn3d; //e.preventDefault();
           me.htmlCls.dialogCls.openDlg('dl_clr', 'Color picker');
        });

        $(document).on("click", ".icn3d-color-rad-text", function(e) { let ic = me.icn3d; 
          e.stopImmediatePropagation();
          //e.preventDefault();
          let color = $(this).attr('color');
          ic.setOptionCls.setOption("color", color);

          thisClass.setLogCmd("color " + color, true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn4_clrSave", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.setOptionCls.saveColor();
           thisClass.setLogCmd('save color', true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn4_clrApplySave", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.setOptionCls.applySavedColor();
           thisClass.setLogCmd('apply saved color', true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn3_styleSave", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.setOptionCls.saveStyle();
           thisClass.setLogCmd('save style', true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn3_styleApplySave", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.setOptionCls.applySavedStyle();
           thisClass.setLogCmd('apply saved style', true);
        });

    }

    clickMenu5() { let me = this.icn3dui; me.icn3d;
        if(me.bNode) return;

        let thisClass = this;
    // mn 5
        me.myEventCls.onIds("#" + me.pre + "mn5_neighborsYes", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.bConsiderNeighbors = true;
           ic.applyMapCls.removeLastSurface();
           ic.applyMapCls.applySurfaceOptions();
           if(ic.bRender) ic.drawCls.render();
           thisClass.setLogCmd('set surface neighbors on', true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn5_neighborsNo", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.bConsiderNeighbors = false;
           ic.applyMapCls.removeLastSurface();
           ic.applyMapCls.applySurfaceOptions();
           if(ic.bRender) ic.drawCls.render();
           thisClass.setLogCmd('set surface neighbors off', true);
        });

        me.myEventCls.onIds(["#" + me.pre + "mn5_surfaceVDW", "#" + me.pre + "tool_surfaceVDW"], "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.bConsiderNeighbors = false;
           ic.setOptionCls.setOption('surface', 'Van der Waals surface');
           thisClass.setLogCmd('set surface Van der Waals surface', true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn5_surfaceSAS", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.bConsiderNeighbors = false;
           ic.setOptionCls.setOption('surface', 'solvent accessible surface');
           thisClass.setLogCmd('set surface solvent accessible surface', true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn5_surfaceMolecular", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.bConsiderNeighbors = false;
           ic.setOptionCls.setOption('surface', 'molecular surface');
           thisClass.setLogCmd('set surface molecular surface', true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn5_surfaceVDWContext", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.bConsiderNeighbors = true;
           ic.setOptionCls.setOption('surface', 'Van der Waals surface with context');
           thisClass.setLogCmd('set surface Van der Waals surface with context', true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn5_surfaceSASContext", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.bConsiderNeighbors = true;
           ic.setOptionCls.setOption('surface', 'solvent accessible surface with context');
           thisClass.setLogCmd('set surface solvent accessible surface with context', true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn5_surfaceMolecularContext", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.bConsiderNeighbors = true;
           ic.setOptionCls.setOption('surface', 'molecular surface with context');
           thisClass.setLogCmd('set surface molecular surface with context', true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn5_surfaceNo", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.setOptionCls.setOption('surface', 'nothing');
           thisClass.setLogCmd('set surface nothing', true);
        });

        $(document).on("click", "." + me.pre + "mn5_opacity", function(e) { let ic = me.icn3d; //e.preventDefault();
            ic.transparentRenderOrder = false;

            let value = $(this).attr('v');
           ic.setOptionCls.setOption('opacity', value);
           thisClass.setLogCmd('set surface opacity ' + value, true);
        });

        $(document).on("click", "." + me.pre + "mn5_opacityslow", function(e) { let ic = me.icn3d; //e.preventDefault();
            ic.transparentRenderOrder = true;

            let value = $(this).attr('v');
            ic.setOptionCls.setOption('opacity', value);
            thisClass.setLogCmd('set surface2 opacity ' + value, true);
         });

        me.myEventCls.onIds("#" + me.pre + "mn5_wireframeYes", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.setOptionCls.setOption('wireframe', 'yes');
           thisClass.setLogCmd('set surface wireframe on', true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn5_wireframeNo", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.setOptionCls.setOption('wireframe', 'no');
           thisClass.setLogCmd('set surface wireframe off', true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn5_elecmap2fofc", "click", function(e) { me.icn3d; //e.preventDefault();
           me.htmlCls.dialogCls.openDlg('dl_elecmap2fofc', '2Fo-Fc Electron Density Map');
        });

        me.myEventCls.onIds("#" + me.pre + "mn5_elecmapfofc", "click", function(e) { me.icn3d; //e.preventDefault();
           me.htmlCls.dialogCls.openDlg('dl_elecmapfofc', 'Fo-Fc Electron Density Map');
        });

        me.myEventCls.onIds(["#" + me.pre + "mn5_elecmapNo", "#" + me.pre + "elecmapNo2", "#" + me.pre + "elecmapNo3", "#" + me.pre + "elecmapNo4", "#" + me.pre + "elecmapNo5"], "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.setOptionCls.setOption('map', 'nothing');
           thisClass.setLogCmd('setoption map nothing', true);
        });

        me.myEventCls.onIds(["#" + me.pre + "delphimapNo", "#" + me.pre + "phimapNo", "#" + me.pre + "phiurlmapNo", "#" + me.pre + "mn1_phimapNo"], "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.setOptionCls.setOption('phimap', 'nothing');
           thisClass.setLogCmd('setoption phimap nothing', true);
        });

        me.myEventCls.onIds(["#" + me.pre + "delphimapNo2", "#" + me.pre + "phimapNo2", "#" + me.pre + "phiurlmapNo2"], "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           //ic.setOptionCls.setOption('surface', 'nothing');
           //thisClass.setLogCmd('set surface nothing', true);
           ic.setOptionCls.setOption('phisurface', 'nothing');
           thisClass.setLogCmd('setoption phisurface nothing', true);
        });

        me.myEventCls.onIds("#" + me.pre + "applymap2fofc", "click", async function(e) { let ic = me.icn3d; 
           e.preventDefault();

           //if(!me.cfg.notebook) dialog.dialog( "close" );
           let sigma2fofc = parseFloat($("#" + me.pre + "sigma2fofc" ).val());
           let type = '2fofc';
           //await ic.dsn6ParserCls.dsn6Parser(ic.inputid, type, sigma2fofc);
           await ic.densityCifParserCls.densityCifParser(ic.inputid, type, sigma2fofc);

           //ic.setOptionCls.setOption('map', '2fofc');
           thisClass.setLogCmd('set map 2fofc sigma ' + sigma2fofc, true);
        });

        me.myEventCls.onIds("#" + me.pre + "applymapfofc", "click", async function(e) { let ic = me.icn3d; 
           e.preventDefault();

           //if(!me.cfg.notebook) dialog.dialog( "close" );
           let sigmafofc = parseFloat($("#" + me.pre + "sigmafofc" ).val());
           let type = 'fofc';
           //await ic.dsn6ParserCls.dsn6Parser(ic.inputid, type, sigmafofc);
           await ic.densityCifParserCls.densityCifParser(ic.inputid, type, sigma2fofc);
           //ic.setOptionCls.setOption('map', 'fofc');
           thisClass.setLogCmd('set map fofc sigma ' + sigmafofc, true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn5_mapwireframeYes", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           //ic.dsn6ParserCls.dsn6Parser(ic.inputid);
           ic.setOptionCls.setOption('mapwireframe', 'yes');
           thisClass.setLogCmd('set map wireframe on', true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn5_mapwireframeNo", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.setOptionCls.setOption('mapwireframe', 'no');
           thisClass.setLogCmd('set map wireframe off', true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn5_emmap", "click", function(e) { me.icn3d; //e.preventDefault();
           me.htmlCls.dialogCls.openDlg('dl_emmap', 'EM Density Map');
        });

        me.myEventCls.onIds(["#" + me.pre + "mn5_emmapNo", "#" + me.pre + "emmapNo2"], "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.setOptionCls.setOption('emmap', 'nothing');
           thisClass.setLogCmd('setoption emmap nothing', true);
        });

        me.myEventCls.onIds("#" + me.pre + "applyemmap", "click", async function(e) { let ic = me.icn3d; 
           e.preventDefault();

           //if(!me.cfg.notebook) dialog.dialog( "close" );
           let empercentage = parseFloat($("#" + me.pre + "empercentage" ).val());
           let type = 'em';
           //ic.emd = 'emd-3906';

           await ic.densityCifParserCls.densityCifParser(ic.inputid, type, empercentage, ic.emd);
           thisClass.setLogCmd('set emmap percentage ' + empercentage, true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn5_emmapwireframeYes", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           //ic.dsn6ParserCls.dsn6Parser(ic.inputid);
           ic.setOptionCls.setOption('emmapwireframe', 'yes');
           thisClass.setLogCmd('set emmap wireframe on', true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn5_emmapwireframeNo", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.setOptionCls.setOption('emmapwireframe', 'no');
           thisClass.setLogCmd('set emmap wireframe off', true);
        });

    }

    clickMenu6() { let me = this.icn3dui, ic = me.icn3d;
        if(me.bNode) return;

        let thisClass = this;
    // mn 6
        me.myEventCls.onIds("#" + me.pre + "mn6_assemblyYes", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.bAssembly = true;
           thisClass.setLogCmd('set assembly on', true);
           ic.drawCls.draw();
        });

        me.myEventCls.onIds("#" + me.pre + "mn6_assemblyNo", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.bAssembly = false;
           thisClass.setLogCmd('set assembly off', true);
           ic.drawCls.draw();
        });

        me.myEventCls.onIds("#" + me.pre + "mn6_igrefYes", "click", async function(e) { let ic = me.icn3d; //e.preventDefault();
            ic.bRunRefnumAgain = true;

            thisClass.setLogCmd('ig refnum on', true);
            // await ic.refnumCls.showIgRefNum();
            // thisClass.setLogCmd('set annotation ig', true);
            if(!ic.bAnnoShown) await ic.showAnnoCls.showAnnotations();

            let bSelection = true;
            await ic.annotationCls.setAnnoTabIg(bSelection);

            // if(ic.bShowRefnum) {
            //    ic.opts.color = 'ig strand';
            //    ic.setColorCls.setColorByOptions(ic.opts, ic.atoms);
   
            //    ic.selectionCls.selectAll_base();
            //    ic.hlUpdateCls.updateHlAll();
            //    ic.drawCls.draw();
            // }

            ic.bRunRefnumAgain = false;
         });

        me.myEventCls.onIds("#" + me.pre + "mn6_igrefTpl", "click", async function(e) { me.icn3d; //e.preventDefault();
            me.htmlCls.dialogCls.openDlg('dl_igrefTpl', 'Choose an Ig template');
         });

        me.myEventCls.onIds("#" + me.pre + "mn6_igrefTpl_apply", "click", async function(e) { me.icn3d; //e.preventDefault();
            if(!me.cfg.notebook) dialog.dialog( "close" );

            let template = $("#" + me.pre + "refTpl").val();

            await thisClass.setIgTemplate(template);

            thisClass.setLogCmd('ig template ' + template, true);
         });

         me.myEventCls.onIds("#" + me.pre + "mn6_alignrefTpl", "click", async function(e) { me.icn3d; //e.preventDefault();
            me.htmlCls.dialogCls.openDlg('dl_alignrefTpl', 'Align with an Ig template');
         });

         me.myEventCls.onIds("#" + me.pre + "mn6_alignrefTpl_apply", "click", async function(e) { let ic = me.icn3d; //e.preventDefault();
            if(!me.cfg.notebook) dialog.dialog( "close" );
   
            let template = $("#" + me.pre + "refTpl2").val();

            let selAtoms = me.hashUtilsCls.cloneHash(ic.hAtoms);

            // load the template
            let url = me.htmlCls.baseUrl + "icn3d/refpdb/" + template + ".pdb";
            await ic.pdbParserCls.downloadUrl(url, 'pdb', undefined, template);
            thisClass.setLogCmd('load url ' + url + ' | type pdb', true);
   
            let structure = template.replace(/_/g, '').substr(0,4);

            let chainid = ic.structures[structure][0];

            ic.hAtoms = me.hashUtilsCls.unionHash(selAtoms, ic.chains[chainid]);

            // align the template with the selection
            me.cfg.aligntool = 'tmalign';
            await ic.realignParserCls.realignOnStructAlign();
            thisClass.setLogCmd('realign on tmalign', true);   
         });

         me.myEventCls.onIds("#" + me.pre + "mn6_igrefNo", "click", async function(e) { let ic = me.icn3d; //e.preventDefault();
            thisClass.setLogCmd('ig refnum off', true);
            await ic.refnumCls.hideIgRefNum();

            // ic.selectionCls.selectAll_base();
            // ic.hlUpdateCls.updateHlAll();
            
            // ic.drawCls.draw();
         });

        me.myEventCls.onIds("#" + me.pre + "mn6_addlabelAtoms", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.residueLabelsCls.addAtomLabels(ic.hAtoms);
           ic.selectionCls.saveSelectionIfSelected();
           thisClass.setLogCmd('add atom labels', true);
           ic.drawCls.draw();
        });

        me.myEventCls.onIds("#" + me.pre + "mn6_addlabelElements", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.residueLabelsCls.addAtomLabels(ic.hAtoms, true);
           ic.selectionCls.saveSelectionIfSelected();
           thisClass.setLogCmd('add element labels', true);
           ic.drawCls.draw();
        });


        me.myEventCls.onIds("#" + me.pre + "mn6_addlabelResidues", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.residueLabelsCls.addResidueLabels(ic.hAtoms);
           ic.selectionCls.saveSelectionIfSelected();
           thisClass.setLogCmd('add residue labels', true);
           ic.drawCls.draw();
        });

        me.myEventCls.onIds("#" + me.pre + "mn6_addlabelResnum", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.residueLabelsCls.addResidueLabels(ic.hAtoms, undefined, undefined, true);
           ic.selectionCls.saveSelectionIfSelected();
           thisClass.setLogCmd('add residue number labels', true);
           ic.drawCls.draw();
        });

        me.myEventCls.onIds("#" + me.pre + "mn6_addlabelRefnum", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
         ic.residueLabelsCls.addResidueLabels(ic.hAtoms, undefined, undefined, undefined, true);
         ic.selectionCls.saveSelectionIfSelected();
         thisClass.setLogCmd('add reference number labels', true);
         ic.drawCls.draw();
        });

        me.myEventCls.onIds("#" + me.pre + "mn6_addlabelIg", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
         ic.residueLabelsCls.addIgLabels(ic.hAtoms);
         ic.selectionCls.saveSelectionIfSelected();
         thisClass.setLogCmd('add ig labels', true);
         ic.drawCls.draw();
        });

        me.myEventCls.onIds("#" + me.pre + "mn6_addlabelChains", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.analysisCls.addChainLabels(ic.hAtoms);
           ic.selectionCls.saveSelectionIfSelected();
           thisClass.setLogCmd('add chain labels', true);
           ic.drawCls.draw();
        });

        me.myEventCls.onIds("#" + me.pre + "mn6_addlabelTermini", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.analysisCls.addTerminiLabels(ic.hAtoms);
           ic.selectionCls.saveSelectionIfSelected();
           thisClass.setLogCmd('add terminal labels', true);
           ic.drawCls.draw();
        });

        me.myEventCls.onIds("#" + me.pre + "mn6_addlabelYes", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           me.htmlCls.dialogCls.openDlg('dl_addlabel', 'Add custom labels by selection');
           ic.pk = 1;
           ic.opts['pk'] = 'atom';
           ic.pickpair = true;
           ic.pAtomNum = 0;
        });

        me.myEventCls.onIds("#" + me.pre + "mn6_addlabelSelection", "click", function(e) { me.icn3d; //e.preventDefault();
           me.htmlCls.dialogCls.openDlg('dl_addlabelselection', 'Add custom labels by the selected');
        });

         me.myEventCls.onIds("#" + me.pre + "mn6_labelColor", "click", function(e) { me.icn3d; //e.preventDefault();
           me.htmlCls.dialogCls.openDlg('dl_labelColor', 'Change color for all labels');
        });

        me.myEventCls.onIds(["#" + me.pre + "mn2_saveselection","#" + me.pre + "tool_saveselection"], "click", function(e) { me.icn3d; //e.preventDefault();
           me.htmlCls.dialogCls.openDlg('dl_saveselection', 'Save the selected');
        });

        me.myEventCls.onIds(["#" + me.pre + "mn6_addlabelNo", "#" + me.pre + "removeLabels"], "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.labelcolor = undefined;
            ic.pickpair = false;
           //ic.labels['residue'] = [];
           //ic.labels['custom'] = [];
           let select = "set labels off";
           thisClass.setLogCmd(select, true);
           for(let name in ic.labels) {
               //if(name === 'residue' || name === 'custom') {
                   ic.labels[name] = [];
               //}
           }
           ic.drawCls.draw();
        });

        $(document).on("click", "." + me.pre + "mn6_labelscale", function(e) { let ic = me.icn3d; //e.preventDefault();
           let value = $(this).attr('v');
           ic.labelScale = value;
           ic.drawCls.draw();
           thisClass.setLogCmd('set label scale ' + value, true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn6_distanceYes", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           me.htmlCls.dialogCls.openDlg('dl_distance', 'Measure the distance of atoms');
           ic.pk = 1;
           ic.opts['pk'] = 'atom';
           ic.pickpair = true;
           ic.pAtomNum = 0;
           ic.bMeasureDistance = true;
        });


        me.myEventCls.onIds("#" + me.pre + "mn6_distTwoSets", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
            me.htmlCls.dialogCls.openDlg('dl_disttwosets', 'Measure the distance between two sets');

            thisClass.setSetsMenus('atomsCustomDist');

           ic.bMeasureDistance = true;
        });

        me.myEventCls.onIds("#" + me.pre + "mn6_distManySets", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
            me.htmlCls.dialogCls.openDlg('dl_distmanysets', 'Measure the pairwise distances among many sets');

            thisClass.setSetsMenus('atomsCustomDistTable');

           ic.bMeasureDistance = true;
        });

        me.myEventCls.onIds("#" + me.pre + "mn6_angleManySets", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
         me.htmlCls.dialogCls.openDlg('dl_anglemanysets', 'Measure the pairwise angles among many sets');

         thisClass.setSetsMenus('atomsCustomAngleTable');

        ic.bMeasureAngle = true;
       });

        me.myEventCls.onIds("#" + me.pre + "mn6_distanceNo", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.pickpair = false;
           let select = "set lines off";
           thisClass.setLogCmd(select, true);
           ic.labels['distance'] = [];
           ic.lines['distance'] = [];
           ic.distPnts = [];
           ic.pk = 2;
           ic.drawCls.draw();
        });

        me.myEventCls.onIds("#" + me.pre + "mn5_cartoonshape", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
            me.htmlCls.dialogCls.openDlg('dl_cartoonshape', 'Draw cartoon for a set');

            let bOneset = true;
            thisClass.setSetsMenus('cartoonshape', bOneset);

           ic.bCartoonshape = true;
        });

        me.myEventCls.onIds("#" + me.pre + "mn5_linebtwsets", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
            me.htmlCls.dialogCls.openDlg('dl_linebtwsets', 'Draw a line between two sets');

            thisClass.setSetsMenus('linebtwsets');

           ic.bLinebtwsets = true;
        });


        me.myEventCls.onIds(["#" + me.pre + "mn2_selectedcenter", "#" + me.pre + "zoomin_selection", "#" + me.pre + "tool_selectedcenter"], "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           //thisClass.setLogCmd('zoom selection', true);
           ic.transformCls.zoominSelection();
           ic.drawCls.draw();
           thisClass.setLogCmd('zoom selection', true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn6_center", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           //thisClass.setLogCmd('center selection', true);
           ic.applyCenterCls.centerSelection();
           ic.drawCls.draw();
           thisClass.setLogCmd('center selection', true);
        });

        me.myEventCls.onIds(["#" + me.pre + "mn6_resetOrientation", "#" + me.pre + "resetOrientation", "#" + me.pre + "tool_resetOrientation"], "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           //thisClass.setLogCmd('reset orientation', true);
           ic.transformCls.resetOrientation();
           //ic.setColorCls.applyOriginalColor();
           ic.drawCls.draw();
           thisClass.setLogCmd('reset orientation', true);
        });

        me.myEventCls.onIds(["#" + me.pre + "mn6_chemicalbindingshow", "#" + me.pre + "chemicalbindingshow"], "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.setOptionCls.setOption('chemicalbinding', 'show');
           thisClass.setLogCmd('set chemicalbinding show', true);
        });

        me.myEventCls.onIds(["#" + me.pre + "mn6_chemicalbindinghide", "#" + me.pre + "chemicalbindinghide"], "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.setOptionCls.setOption('chemicalbinding', 'hide');
           thisClass.setLogCmd('set chemicalbinding hide', true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn6_sidebyside", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           if(ic.bInputfile) {
                alert("Side-by-Side does NOT work when the input is from a local file.");
                return;
           }
           let url = ic.shareLinkCls.shareLinkUrl(undefined);
           //if(url.indexOf('http') !== 0) {
           //    alert("The url is more than 4000 characters and may not work.");
           //}
           //else {
               url = url.replace("icn3d/full.html?", "icn3d/full2.html?");
               url = url.replace("icn3d/?", "icn3d/full2.html?");
               url += '&closepopup=1';
               let urlTarget = (ic.structures && Object.keys(ic.structures).length > 0) ? '_blank' : '_self';
               window.open(url, urlTarget);
               thisClass.setLogCmd('side by side | ' + url, true);
           //}
        });

        $(document).on("click", "#" + me.pre + "mn2_translate", function(e) { me.icn3d; //e.preventDefault();
           me.htmlCls.dialogCls.openDlg('dl_translate', 'Translate the X,Y,Z coordinates of the structure');
        });

        $(document).on("click", "#" + me.pre + "mn6_angleTwoSets", function(e) { me.icn3d; //e.preventDefault();
         me.htmlCls.dialogCls.openDlg('dl_angle', 'Measure the angle between two vectors');
        });

        $(document).on("click", "#" + me.pre + "mn2_matrix", function(e) { me.icn3d; //e.preventDefault();
           me.htmlCls.dialogCls.openDlg('dl_matrix', 'Apply matrix to the X,Y,Z coordinates of the structure');
        });

        $(document).on("click", "." + me.pre + "mn6_rotate", function(e) { let ic = me.icn3d; //e.preventDefault();
           let value = $(this).attr('v').toLowerCase();
           let direction = value.split(' ')[1];

           thisClass.setLogCmd(value, true);
           ic.bStopRotate = false;
           ic.transformCls.rotateCount = 0;
           ic.transformCls.rotateCountMax = 6000;
           ic.ROT_DIR = direction;
           ic.resizeCanvasCls.rotStruc(direction);
        });

        $(document).on("click", "." + me.pre + "mn6_rotate90", function(e) { let ic = me.icn3d; //e.preventDefault();
          let value = $(this).attr('v').toLowerCase();
          let direction = value.split(' ')[1];

          thisClass.setLogCmd(value, true);
          let axis;
          if(direction == 'x') {
              axis = new THREE.Vector3(1,0,0);
          }
          else if(direction == 'y') {
              axis = new THREE.Vector3(0,1,0);
          }
          else if(direction == 'z') {
              axis = new THREE.Vector3(0,0,1);
          }
          let angle = 0.5 * Math.PI;
          ic.transformCls.setRotation(axis, angle);
        });

        me.myEventCls.onIds("#" + me.pre + "mn6_cameraPers", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.setOptionCls.setOption('camera', 'perspective');
           thisClass.setLogCmd('set camera perspective', true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn6_cameraOrth", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.setOptionCls.setOption('camera', 'orthographic');
           thisClass.setLogCmd('set camera orthographic', true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn6_bkgdBlack", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.setStyleCls.setBackground('black');
        });

        me.myEventCls.onIds("#" + me.pre + "tool_bkgd", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
            if(ic.opts['background'] == 'black') {
                ic.setStyleCls.setBackground('white');
            }
            else {
                ic.setStyleCls.setBackground('black');
            }
         });

        me.myEventCls.onIds("#" + me.pre + "mn6_bkgdGrey", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.setStyleCls.setBackground('grey');
        });

        me.myEventCls.onIds(["#" + me.pre + "mn6_bkgdWhite", "#" + me.pre + "tool_bkgdWhite"], "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.setStyleCls.setBackground('white');
        });

        me.myEventCls.onIds("#" + me.pre + "mn6_bkgdTransparent", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.setStyleCls.setBackground('transparent');
        });

        me.myEventCls.onIds("#" + me.pre + "mn6_showfogYes", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           //ic.setOptionCls.setOption('fog', 'yes');
           ic.opts['fog'] = 'yes';
           ic.fogCls.setFog(true);
           ic.drawCls.draw();
           thisClass.setLogCmd('set fog on', true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn6_showfogNo", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           //ic.setOptionCls.setOption('fog', 'no');
           ic.opts['fog'] = 'no';
           ic.fogCls.setFog(true);
           ic.drawCls.draw();
           thisClass.setLogCmd('set fog off', true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn6_showslabYes", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.setOptionCls.setOption('slab', 'yes');
           thisClass.setLogCmd('set slab on', true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn6_showslabNo", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.setOptionCls.setOption('slab', 'no');
           thisClass.setLogCmd('set slab off', true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn6_showaxisYes", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.setOptionCls.setOption('axis', 'yes');
           thisClass.setLogCmd('set axis on', true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn6_showaxisSel", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.pc1 = true;

           ic.axesCls.setPc1Axes();
           thisClass.setLogCmd('set pc1 axis', true);
        });


        me.myEventCls.onIds("#" + me.pre + "mn6_showaxisNo", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.pc1 = false;
           ic.axes = [];

           ic.setOptionCls.setOption('axis', 'no');

           thisClass.setLogCmd('set axis off', true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn6_symmetry", "click", async function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.bAxisOnly = false;
           await ic.symdCls.retrieveSymmetry(Object.keys(ic.structures)[0]);
           //me.htmlCls.dialogCls.openDlg('dl_symmetry', 'Symmetry');
        });

        me.myEventCls.onIds("#" + me.pre + "mn6_symd", "click", async function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.bAxisOnly = false;
           await ic.symdCls.retrieveSymd();
           ic.bSymd = true;

           thisClass.setLogCmd('symd symmetry', true);
        });
        me.myEventCls.onIds("#" + me.pre + "mn6_clear_sym", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.symdArray = [];
           ic.drawCls.draw();
           thisClass.setLogCmd('clear symd symmetry', true);
        });
        me.myEventCls.onIds("#" + me.pre + "mn6_axes_only", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.bAxisOnly = true;
           ic.drawCls.draw();
           thisClass.setLogCmd('show axis', true);
        });


        me.myEventCls.onIds("#" + me.pre + "mn6_area", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
            ic.analysisCls.calculateArea();
            thisClass.setLogCmd('area', true);
        });

        me.myEventCls.onIds("#" + me.pre + "applysymmetry", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.bAxisOnly = false;

           let title = $("#" + me.pre + "selectSymmetry" ).val();

           ic.symmetrytitle =(title === 'none') ? undefined : title;
           //if(title !== 'none') ic.applySymmetry(title);
           ic.drawCls.draw();
           thisClass.setLogCmd('symmetry ' + title, true);
        });
        me.myEventCls.onIds("#" + me.pre + "clearsymmetry", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           let title = 'none';
           ic.symmetrytitle = undefined;
           ic.drawCls.draw();
           thisClass.setLogCmd('symmetry ' + title, true);
        });

        me.myEventCls.onIds(["#" + me.pre + "mn6_hbondsYes", "#" + me.pre + "hbondsYes"], "click", function(e) { let ic = me.icn3d; //e.preventDefault();
            thisClass.SetChainsAdvancedMenu();

            let definedAtomsHtml = ic.definedSetsCls.setAtomMenu(['protein']);
            if($("#" + me.pre + "atomsCustomHbond").length) {
                $("#" + me.pre + "atomsCustomHbond").html("  <option value='non-selected' selected>non-selected</option><option value='selected'>selected</option>" + definedAtomsHtml);
            }
            if($("#" + me.pre + "atomsCustomHbond2").length) {
                $("#" + me.pre + "atomsCustomHbond2").html("  <option value='selected' selected>selected</option>" + definedAtomsHtml);
            }
           me.htmlCls.dialogCls.openDlg('dl_hbonds', 'Hydrogen bonds/interactions between two sets of atoms');
           ic.bHbondCalc = false;
           //thisClass.setLogCmd('set calculate hbond false', true);
           $("#" + me.pre + "atomsCustomHbond").resizable();
           $("#" + me.pre + "atomsCustomHbond2").resizable();
        });

        me.myEventCls.onIds(["#" + me.pre + "mn6_contactmap"], "click", function(e) { me.icn3d; //e.preventDefault();
            me.htmlCls.dialogCls.openDlg('dl_contact', 'Set contact map');
        });

        me.myEventCls.onIds(["#" + me.pre + "mn6_DSSP"], "click", async function(e) { let ic = me.icn3d; //e.preventDefault();
         thisClass.setLogCmd('set dssp sse', true);
         await ic.pdbParserCls.applyCommandDssp();
         ic.bResetAnno = true;

         if(ic.bAnnoShown) {
             await ic.showAnnoCls.showAnnotations();
 
             ic.annotationCls.resetAnnoTabAll();
         }
        });


        me.myEventCls.onIds("#" + me.pre + "mn6_hbondsNo", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.showInterCls.hideHbondsContacts();
           ic.drawCls.draw();
        });

        me.myEventCls.onIds("#" + me.pre + "mn1_stabilizerYes", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           let select = "stabilizer";
           ic.threeDPrintCls.addStabilizer();
           ic.threeDPrintCls.prepareFor3Dprint();
           //ic.drawCls.draw();
           thisClass.setLogCmd(select, true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn1_stabilizerNo", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           let select = "set stabilizer off";
           thisClass.setLogCmd(select, true);
           ic.threeDPrintCls.hideStabilizer();
           ic.drawCls.draw();
        });

        me.myEventCls.onIds("#" + me.pre + "mn1_stabilizerOne", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           me.htmlCls.dialogCls.openDlg('dl_stabilizer', 'Add One Stabilizer');
           ic.pk = 1;
           ic.opts['pk'] = 'atom';
           ic.pickpair = true;
           ic.pAtomNum = 0;
        });

        me.myEventCls.onIds("#" + me.pre + "mn1_stabilizerRmOne", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           me.htmlCls.dialogCls.openDlg('dl_stabilizer_rm', 'Remove One Stabilizer');
           ic.pk = 1;
           ic.opts['pk'] = 'atom';
           ic.pickpair = true;
           ic.pAtomNum = 0;
        });

        me.myEventCls.onIds("#" + me.pre + "mn1_thicknessSet", "click", function(e) { me.icn3d; //e.preventDefault();
           me.htmlCls.dialogCls.openDlg('dl_thickness', 'Set Thickness for 3D Printing');
        });

        me.myEventCls.onIds("#" + me.pre + "mn3_setThickness", "click", function(e) { me.icn3d; //e.preventDefault();
           me.htmlCls.dialogCls.openDlg('dl_thickness2', 'Style Preferences');
        });


        me.myEventCls.onIds("#" + me.pre + "mn6_ssbondsYes", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           let select = "disulfide bonds";
           thisClass.setLogCmd(select, true);
           ic.showInterCls.showSsbonds();
        });

        me.myEventCls.onIds("#" + me.pre + "mn6_ssbondsExport", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.viewInterPairsCls.exportSsbondPairs();
           thisClass.setLogCmd("export disulfide bond pairs", false);
        });

        me.myEventCls.onIds("#" + me.pre + "mn6_ssbondsNo", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.opts["ssbonds"] = "no";
           let select = "set disulfide bonds off";
           thisClass.setLogCmd(select, true);
           ic.lines['ssbond'] = [];
           ic.setOptionCls.setStyle('sidec', 'nothing');
        });

        me.myEventCls.onIds("#" + me.pre + "mn6_clbondsYes", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           let select = "cross linkage";
           thisClass.setLogCmd(select, true);
           //ic.bShowCrossResidueBond = true;
           //ic.setOptionCls.setStyle('proteins', 'lines')
           ic.showInterCls.showClbonds();
        });

        me.myEventCls.onIds("#" + me.pre + "mn6_clbondsExport", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.viewInterPairsCls.exportClbondPairs();
           thisClass.setLogCmd("export cross linkage pairs", false);
        });

        me.myEventCls.onIds("#" + me.pre + "mn6_clbondsNo", "click", function(e) { let ic = me.icn3d; //e.preventDefault();
           ic.opts["clbonds"] = "no";
           let select = "set cross linkage off";
           thisClass.setLogCmd(select, true);
           //ic.bShowCrossResidueBond = false;
           //ic.setOptionCls.setStyle('proteins', 'ribbon')
           ic.lines['clbond'] = [];
           ic.setOptionCls.setStyle('sidec', 'nothing');
        });


        $("#" + me.pre + "newvs2").on('submit', function() {
            // fill the pdbstr
            let bVastSearch = true;
            let pdbstr = ic.saveFileCls.getAtomPDB(ic.hAtoms, undefined, undefined, undefined, undefined, undefined, undefined, bVastSearch);
            $("#" + me.pre + "pdbstr").val(pdbstr);
            return true;
        });

        $("#" + me.pre + "fssubmit").on('click', function() {
            let pdbstr = ic.saveFileCls.getAtomPDB(ic.hAtoms);
            let url = 'https://search.foldseek.com/api/ticket';


            let template = "<!doctype html>\n<head>\n<title>Loading Foldseek</title>\n<style>\n  body {\n    background-color: #121212;\n    color: #fff;\n    font-family: system-ui, -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, 'Open Sans', 'Helvetica Neue', sans-serif;\n    height: 100vh;\n    display: flex;\n    flex-direction: column;\n    flex-wrap: wrap;\n    justify-content: center;\n    align-items: center;\n  }\n  .loader {\n    display: block;\n    width: 80px;\n    height: 80px;\n  }\n  .loader:after {\n    content: \" \";\n    display: block;\n    width: 64px;\n    height: 64px;\n    margin: 8px;\n    border-radius: 50%;\n    border: 6px solid #fff;\n    border-color: #fff transparent #fff transparent;\n    animation: loader 1.2s linear infinite;\n  }\n  @keyframes loader {\n    0% {\n      transform: rotate(0deg);\n    }\n    100% {\n      transform: rotate(360deg);\n    }\n  }\n</style>\n</head>\n<body>\n<div>Foldseek is loading...</div><div class=\"loader\"></div>\n</body>";

            let urlTarget = '_blank';
            let w = window.open('', urlTarget);
            w.document.body.innerHTML = template;

            $.ajax({
                url: url,
                type: 'POST',
                data: { 
                    q : pdbstr,
                    database: ["afdb50", "afdb-swissprot", "gmgcl_id", "pdb100", "afdb-proteome", "mgnify_esm30"],
                    mode: "3diaa"
                },
                dataType: 'text',
                success: function(data) {
                    w.location = 'https://search.foldseek.com/queue/' + JSON.parse(data).id;
                },
                error : function(xhr, textStatus, errorThrown ) {
                  console.log("Error in submitting data to Foldseek...");
                }
            });
        });

        me.myEventCls.onIds("#" + me.pre + "jn_copy", "click", function(e) { me.icn3d; //e.preventDefault();
            let text = $("#" + me.pre + "jn_commands").val();
            navigator.clipboard.writeText(text);
        });
    } 

    //Show the input command in log. If "bSetCommand" is true, the command will be saved in the state file as well.
    setLogCmd(str, bSetCommand, bAddLogs) {var me = this.icn3dui, ic = me.icn3d;
      if(str.trim() === '') return false;
      let pos = str.indexOf('|||');
      if(pos !== -1) str = str.substr(0, pos);
      let transformation = {};

      if(!ic.quaternion) {
         // reset parameters
         ic._zoomFactor = 1.0;
         ic.mouseChange = new THREE.Vector2(0,0);
         ic.quaternion = new THREE.Quaternion(0,0,0,1);
      }

      transformation.factor = ic._zoomFactor;
      transformation.mouseChange = ic.mouseChange;
      transformation.quaternion = {};
      transformation.quaternion._x = parseFloat(ic.quaternion._x).toPrecision(5);
      transformation.quaternion._y = parseFloat(ic.quaternion._y).toPrecision(5);
      transformation.quaternion._z = parseFloat(ic.quaternion._z).toPrecision(5);
      transformation.quaternion._w = parseFloat(ic.quaternion._w).toPrecision(5);
      if(bSetCommand) {
          // save the command only when it's not a history command, i.e., not in the process of going back and forth
          if(ic.bAddCommands) {
              // If a new command was called, remove the forward commands and push to the command array
              if(ic.STATENUMBER < ic.commands.length) {
                  let oldCommand = ic.commands[ic.STATENUMBER - 1];
                  let pos = oldCommand.indexOf('|||');
                  if(pos != -1 && str !== oldCommand.substr(0, pos)) {
                    ic.commands = ic.commands.slice(0, ic.STATENUMBER);
                    ic.commands.push(str + '|||' + ic.transformCls.getTransformationStr(transformation));
                    ic.optsHistory.push(me.hashUtilsCls.cloneHash(ic.opts));
                    ic.optsHistory[ic.optsHistory.length - 1].hlatomcount = Object.keys(ic.hAtoms).length;
                    if(me.utilsCls.isSessionStorageSupported()) ic.setStyleCls.saveCommandsToSession();
                    ic.STATENUMBER = ic.commands.length;
                  }
              }
              else {
                ic.commands.push(str + '|||' + ic.transformCls.getTransformationStr(transformation));
                ic.optsHistory.push(me.hashUtilsCls.cloneHash(ic.opts));
                if(ic.hAtoms !== undefined) ic.optsHistory[ic.optsHistory.length - 1].hlatomcount = Object.keys(ic.hAtoms).length;
                if(me.utilsCls.isSessionStorageSupported()) ic.setStyleCls.saveCommandsToSession();
                ic.STATENUMBER = ic.commands.length;
              }
          }
      }
      if((ic.bAddLogs || bAddLogs) && me.cfg.showcommand) {
          let finalStr = (bSetCommand) ? str : '[comment] ' + str;
          ic.logs.push(finalStr);
          // move cursor to the end, and scroll to the end
          $("#" + me.pre + "logtext").val("> " + ic.logs.join("\n> ") + "\n> ");
          if($("#" + me.pre + "logtext")[0]) {
            $("#" + me.pre + "logtext").scrollTop($("#" + me.pre + "logtext")[0].scrollHeight);
          }
      }
      ic.setStyleCls.adjustIcon();
    }
}

/**
 * @author Jiyao Wang <wangjiy@ncbi.nlm.nih.gov> / https://github.com/ncbi/icn3d
 */

class SetMenu {
    constructor(icn3dui) {
        this.icn3dui = icn3dui;
        //this.sh = this.icn3dui.htmlCls.setHtmlCls;
    }

    // simplify the calls of the following functions from setHtmlCls
    getLink(id, text, bSimpleMenu, selType) { let me = this.icn3dui;
        return me.htmlCls.setHtmlCls.getLink(id, text, bSimpleMenu, selType);
    }

    getMenuText(id, text, classname, bSimpleMenu, selType) { let me = this.icn3dui;
        return me.htmlCls.setHtmlCls.getMenuText(id, text, classname, bSimpleMenu, selType);
    }

    getMenuUrl(id, url, text, bSimpleMenu, selType) { let me = this.icn3dui;
        return me.htmlCls.setHtmlCls.getMenuUrl(id, url, text, bSimpleMenu, selType);
    }

    getMenuSep() { let me = this.icn3dui;
        return me.htmlCls.setHtmlCls.getMenuSep();
    }

    getLinkWrapper(id, text, wrapper, bSimpleMenu, selType, bHide) { let me = this.icn3dui; me.icn3d;
        return me.htmlCls.setHtmlCls.getLinkWrapper(id, text, wrapper, bSimpleMenu, selType, bHide);
    }

    getLinkWrapper2(id, text, wrapper, bSimpleMenu, selType) { let me = this.icn3dui; me.icn3d;
        return me.htmlCls.setHtmlCls.getLinkWrapper2(id, text, wrapper, bSimpleMenu, selType);
    }

    getRadio(radioid, id, text, bChecked, bSimpleMenu, selType) { let me = this.icn3dui;
        return me.htmlCls.setHtmlCls.getRadio(radioid, id, text, bChecked, bSimpleMenu, selType);
    }

    getRadClr(radioid, id, text, color, bChecked, bSimpleMenu, selType) { let me = this.icn3dui;
        return me.htmlCls.setHtmlCls.getRadioColor(radioid, id, text, color, bChecked, bSimpleMenu, selType);
    }

    resetMenu(mode) { let me = this.icn3dui;
        if(!mode || mode == 'simple') {
            me.htmlCls.shownMenus = me.hashUtilsCls.cloneHash(me.htmlCls.simpleMenus);

            me.htmlCls.clickMenuCls.applyShownMenus(); 
        }
        else if(mode == 'all') {
            me.htmlCls.shownMenus = me.hashUtilsCls.cloneHash(me.htmlCls.allMenus);

            me.htmlCls.clickMenuCls.applyShownMenus(); 
        }
        else if(mode == 'custom') {
            me.htmlCls.dialogCls.openDlg('dl_menupref', 'Select Menus');

            me.htmlCls.clickMenuCls.getHiddenMenusFromCache();

            me.htmlCls.clickMenuCls.displayShownMenus();
        }
    }

    setMenuMode(bMobile) { let me = this.icn3dui;
        let spaceCss = (bMobile) ? "; padding-left:6px; background-color:#eee" : "; margin:3px; background-color:white";
        let spaceCss2 = (bMobile) ? "; font-size:14px!important" : ""; 

        let mode = me.htmlCls.setHtmlCls.getCookie('menumode');

        let html = '<div class="icn3d-text" style="color:#f8b84e; font-weight:bold' + spaceCss + '">';
        html += '<select name="menumode" id="' + me.pre + 'menumode" class="icn3d-text" style="color:#f8b84e; font-weight:bold; border:0px' + spaceCss2 + '">';
        html += (mode == 'simple' || !mode) ? '<option value="simple" selected>Simple</option>' : '<option value="simple">Simple</option>';
        html += (mode == 'all') ? '<option value="all" selected>All</option>' : '<option value="all">All</option>';
        html += (mode == 'custom') ? '<option value="custom" selected>Custom</option>' : '<option value="custom">Custom</option>';
        html += '</select>';

        if(bMobile) {
            html += '<br><span style="font-size:12px">&nbsp;Menus</span>';
        }
        else {
            html += '&nbsp;Menus';
        }

        html += '</div>';

        return html;
    }

    //Set the HTML code for the menus shown at the top of the viewer.
    setTopMenusHtml(id, str1, str2) { let me = this.icn3dui;
        if(me.bNode) return '';

        let titleColor =(me.htmlCls.opts['background'] == 'black') ? me.htmlCls.GREYD : 'black';

        let html = "";

        html += "<div style='position:relative;'>";

        html += me.htmlCls.divStr + "popup' class='icn3d-text icn3d-popup'></div>";

        html += this.setReplayHtml();

        html += "<!--https://forum.jquery.com/topic/looking-for-a-jquery-horizontal-menu-bar-->";
        html += me.htmlCls.divStr + "mnlist' style='position:absolute; z-index:999; float:left; display:table-row; margin-top: -2px;'>";
        html += "<table border='0' cellpadding='0' cellspacing='0' width='100'><tr>";

        let tdStr = '<td valign="top">';

        // html += tdStr + this.setMenuMode() + '</td>';

        html += tdStr + this.setMenu1() + '</td>';

        html += tdStr + this.setMenu2() + '</td>';

        html += tdStr + this.setMenu2b() + '</td>';
        html += tdStr + this.setMenu3() + '</td>';
        html += tdStr + this.setMenu4() + '</td>';

        html += tdStr + this.setMenu5() + '</td>';
        //html += tdStr + this.setMenu5b() + '</td>';
        html += tdStr + this.setMenu6() + '</td>';

        // reset the menus at the end of the menus
        // let mode = me.htmlCls.setHtmlCls.getCookie('menumode');
        // this.resetMenu(mode);

        // me.htmlCls.shownMenus = me.hashUtilsCls.cloneHash(me.htmlCls.simpleMenus); 

        html += tdStr + "<div style='position:relative; margin-left:6px;'>" + str1;
        html += "<div class='icn3d-commandTitle' style='min-width:40px; margin-top: 3px; white-space: nowrap;'>" + str2;

        html += tdStr + '<div class="icn3d-commandTitle" style="white-space:nowrap; margin-top:10px; border-left:solid 1px #888888"><span id="' + me.pre +  'selection_expand" class="icn3d-expand icn3d-link" style="display:block;" title="Expand">' + me.htmlCls.space2 + 'Toolbar <span class="ui-icon ui-icon-plus" style="width:15px"></span>' + me.htmlCls.space2 + '</span><span id="' + me.pre +  'selection_shrink" class="icn3d-shrink icn3d-link" style="display:none;" title="Shrink">' + me.htmlCls.space2 + 'Toolbar <span class="ui-icon ui-icon-minus" style="width:15px"></span>' + me.htmlCls.space2 + '</span></div></td>';

        html += tdStr + '<div class="icn3d-commandTitle" style="white-space:nowrap; margin-top:8px; border-left:solid 1px #888888">' + me.htmlCls.space2 + '<input type="text" id="' + me.pre + 'search_seq" size="10" placeholder="one-letter seq."> <button style="white-space:nowrap;" id="' + me.pre + 'search_seq_button">Search</button> <a style="text-decoration: none;" href="' + me.htmlCls.baseUrl + 'icn3d/icn3d.html#selectb" target="_blank" title="Specification tips">?</a></div></td>';

        html += "</tr>";
        html += "</table>";
        html += "</div>";

        html += this.setTools();

        // show title at the top left corner
        html += me.htmlCls.divStr + "title' class='icn3d-commandTitle' style='font-size:1.2em; font-weight:normal; position:absolute; z-index:1; float:left; display:table-row; margin: 85px 0px 0px 5px; color:" + titleColor + "; width:" + me.htmlCls.WIDTH + "px'></div>";

        html += me.htmlCls.divStr + "viewer' style='position:relative; width:100%; height:100%; background-color: " + me.htmlCls.GREYD + ";'>";

        // deprecated, use the dialog dl_legend instead
        //html += me.htmlCls.divStr + "legend' class='icn3d-text icn3d-legend'></div>";

        html += me.htmlCls.divStr + "mnLogSection'>";
        html += "<div style='height: " + me.htmlCls.MENU_HEIGHT + "px;'></div>";
    //        html += "<div style='height: " + me.htmlCls.MENU_HEIGHT + "px;'></div>";

        html += " </div>";

        if(me.cfg.mmtfid === undefined) {
            //var tmpStr =(ic.realHeight < 300) ? 'top:100px; font-size: 1.2em;' : 'top:180px; font-size: 1.8em;';
            let tmpStr = 'top:180px; font-size: 1.8em;';
            html += me.htmlCls.divStr + "wait' style='position:absolute; left:50px; " + tmpStr + " color: #444444;'>Loading data...</div>";
        }
        html += "<canvas id='" + me.pre + "canvas' style='width:100%; height: 100%; background-color: #FFF;'>Your browser does not support WebGL.</canvas>";

        // separate for the log box
        if(me.cfg.showcommand === undefined || me.cfg.showcommand) {
            html += this.setLogWindow();
        }

        html += "</div>";

        html += "</div>";

        html += me.htmlCls.setDialogCls.setDialogs();

        html += me.htmlCls.setDialogCls.setCustomDialogs();

        $( "#" + id).html(html);

        // mn display
        $("accordion").accordion({ collapsible: true, active: false, heightStyle: "content"});
        $("accordion div").removeClass("ui-accordion-content ui-corner-all ui-corner-bottom ui-widget-content");

        $(".icn3d-mn-item").menu({position: { my: "left top", at: "right top" }});
        $(".icn3d-mn-item").hover(function(){},function(){$("accordion").accordion( "option", "active", "none");});

        $("#" + me.pre + "accordion1").hover( function(){ $("#" + me.pre + "accordion1 div").css("display", "block"); }, function(){ $("#" + me.pre + "accordion1 div").css("display", "none"); } );
        $("#" + me.pre + "accordion2").hover( function(){ $("#" + me.pre + "accordion2 div").css("display", "block"); }, function(){ $("#" + me.pre + "accordion2 div").css("display", "none"); } );
        $("#" + me.pre + "accordion2b").hover( function(){ $("#" + me.pre + "accordion2b div").css("display", "block"); }, function(){ $("#" + me.pre + "accordion2b div").css("display", "none"); } );
        $("#" + me.pre + "accordion3").hover( function(){ $("#" + me.pre + "accordion3 div").css("display", "block"); }, function(){ $("#" + me.pre + "accordion3 div").css("display", "none"); } );
        $("#" + me.pre + "accordion4").hover( function(){ $("#" + me.pre + "accordion4 div").css("display", "block"); }, function(){ $("#" + me.pre + "accordion4 div").css("display", "none"); } );
        $("#" + me.pre + "accordion5").hover( function(){ $("#" + me.pre + "accordion5 div").css("display", "block"); }, function(){ $("#" + me.pre + "accordion5 div").css("display", "none"); } );
        $("#" + me.pre + "accordion6").hover( function(){ $("#" + me.pre + "accordion6 div").css("display", "block"); }, function(){ $("#" + me.pre + "accordion6 div").css("display", "none"); } );
    }

    setTopMenusHtmlMobile(id, str1, str2) { let me = this.icn3dui;
        if(me.bNode) return '';

        let titleColor =(me.htmlCls.opts['background'] == 'black') ? me.htmlCls.GREYD : 'black';

        let html = "";

        html += "<div style='position:relative;'>";

        html += me.htmlCls.divStr + "popup' class='icn3d-text icn3d-popup'></div>";

        html += this.setReplayHtml();

        if(!me.utilsCls.isMobile()) {
            let marginLeft = me.htmlCls.WIDTH - 40 + 5;

            html += me.htmlCls.buttonStr + "fullscreen' style='position:absolute; z-index:1999; display:block; padding:0px; margin: 12px 0px 0px " + marginLeft + "px; width:30px; height:34px; border-radius:4px; border:none; background-color:#f6f6f6;' title='Full screen'>";
            html += "<svg fill='#1c94c4' viewBox='0 0 24 24' width='24' height='24'>";
            html += "<path d='M0 0h24v24H0z' fill='none'></path>";
            html += "<path d='M7 14H5v5h5v-2H7v-3zm-2-4h2V7h3V5H5v5zm12 7h-3v2h5v-5h-2v3zM14 5v2h3v3h2V5h-5z'></path>";
            html += "</svg>";
            html += "</button>";
        }

        html += "<!--https://forum.jquery.com/topic/looking-for-a-jquery-horizontal-menu-bar-->";
        html += me.htmlCls.divStr + "mnlist' style='position:absolute; z-index:999; float:left; display:block; margin: 5px 0px 0px 5px;'>";

        //html += "<div class='icn3d-menu'>";
        html += "<div>";

        html += "<accordion id='" + me.pre + "accordion0' class='icn3d-accordion'>";
        if(me.cfg.notebook) {
            html += "<h3 style='width:20px; height:24px; position:relative; padding: 0'><span style='position:absolute; left:3px; top:4px;'>&#9776;</span></h3>";
        }
        else {
            html += "<h3 style='width:30px; height:34px; position:relative; padding: 0; margin-top:7px!important; background-color:#f6f6f6;'><span style='position:absolute; left:7px; top:8px;'>&#9776;</span></h3>";
        }
        html += "<div>";

        // html += '<li>' + this.setMenuMode(true);

        let liStr = "<li><span class='icn3d-menu-color'";

        html += "<ul class='icn3d-mn-item'>";
        html += liStr + ">File</span>";
        html += this.setMenu1_base();
        html += liStr + ">Select</span>";
        html += this.setMenu2_base();
        html += liStr + ">View</span>";
        html += this.setMenu2b_base();
        html += liStr + " id='" + me.pre + "style'>Style</span>";
        html += this.setMenu3_base();
        html += liStr + " id='" + me.pre + "color'>Color</span>";
        html += this.setMenu4_base();
        html += liStr + ">Analysis</span>";
        html += this.setMenu5_base();
        html += liStr + ">Help</span>";
        html += this.setMenu6_base();

        // reset the menus at the end of the menus
        // let mode = me.htmlCls.setHtmlCls.getCookie('menumode');
        // this.resetMenu(mode);

        // me.htmlCls.shownMenus = me.hashUtilsCls.cloneHash(me.htmlCls.simpleMenus); 

        html += "<li><div style='position:relative; margin-top:-6px;'>" + str1;
        html += "<div class='icn3d-commandTitle' style='margin-top: 3px; white-space: nowrap;'>" + str2;

        //if(me.cfg.align !== undefined) {
            html += "<li><span id='" + me.pre + "alternate2' class='icn3d-menu-color' title='Alternate the structures'>Alternate</span>";
        //}

        html += "</ul>";

        html += "</div>";
        html += "</accordion>";
        html += "</div>";

        html += "</div>";

        //html += me.htmlCls.setMenuCls.setTools();

        // show title at the top left corner
        html += me.htmlCls.divStr + "title' class='icn3d-commandTitle' style='font-size:1.2em; font-weight:normal; position:absolute; z-index:1; float:left; display:block; margin: 12px 0px 0px 40px; color:" + titleColor + "; width:" +(me.htmlCls.WIDTH - 40).toString() + "px'></div>";
        html += me.htmlCls.divStr + "viewer' style='position:relative; width:100%; height:100%; background-color: " + me.htmlCls.GREYD + ";'>";
        // don't show legend in mobile
        //html += me.htmlCls.divStr + "legend' class='icn3d-text icn3d-legend'></div>";
        html += me.htmlCls.divStr + "mnLogSection'>";
        html += "<div style='height: " + me.htmlCls.MENU_HEIGHT + "px;'></div>";
        html += "</div>";

        if(me.cfg.mmtfid === undefined) {
            //var tmpStr =(ic.realHeight < 300) ? 'top:100px; font-size: 1.2em;' : 'top:180px; font-size: 1.8em;';
            let tmpStr = 'top:180px; font-size: 1.8em;';
            html += me.htmlCls.divStr + "wait' style='position:absolute; left:50px; " + tmpStr + " color: #444444;'>Loading data...</div>";
        }
        html += "<canvas id='" + me.pre + "canvas' style='width:100%; height: 100%; background-color: #FFF;'>Your browser does not support WebGL.</canvas>";

        // separate for the log box
        if(me.cfg.showcommand === undefined || me.cfg.showcommand) {
            html += this.setLogWindow();
        }

        html += "</div>";

        html += "</div>";

        html += me.htmlCls.setDialogCls.setDialogs();

        html += me.htmlCls.setDialogCls.setCustomDialogs();

        $( "#" + id).html(html);

        // mn display
        $("accordion").accordion({ collapsible: true, active: false, heightStyle: "content"});
        $("accordion div").removeClass("ui-accordion-content ui-corner-all ui-corner-bottom ui-widget-content");

        $(".icn3d-mn-item").menu({position: { my: "left top", at: "right top" }});
        $(".icn3d-mn-item").hover(function(){},function(){$("accordion").accordion( "option", "active", "none");});

        $("#" + me.pre + "accordion0").hover( function(){ $("#" + me.pre + "accordion0 div").css("display", "block"); }, function(){ $("#" + me.pre + "accordion0 div").css("display", "none"); } );
    }

    setReplayHtml(id) { let me = this.icn3dui;
        if(me.bNode) return '';

        let html = '';

        html += me.htmlCls.divStr + "replay' style='display:none; position:absolute; z-index:9999; top:" + parseInt(me.htmlCls.HEIGHT - 100).toString() + "px; left:20px;'>";
        html += "<div title='Click to replay one step'><svg style='cursor:pointer;' fill='#f8b84e' viewBox='0 0 60 60' width='40' height='40'>";
        html += '<circle style="fill:#f8b84e;" cx="29" cy="29" r="29"/>';
        html += '<g>';
        html += '<polygon style="fill:#FFFFFF;" points="44,29 22,44 22,29.273 22,14"/>';
        html += '<path style="fill:#FFFFFF;" d="M22,45c-0.16,0-0.321-0.038-0.467-0.116C21.205,44.711,21,44.371,21,44V14c0-0.371,0.205-0.711,0.533-0.884c0.328-0.174,0.724-0.15,1.031,0.058l22,15C44.836,28.36,45,28.669,45,29s-0.164,0.64-0.437,0.826l-22,15C22.394,44.941,22.197,45,22,45z M23,15.893v26.215L42.225,29L23,15.893z"/>';
        html += '</g>';
        html += "</svg></div>";
        html += me.htmlCls.divStr + "replay_menu' style='background-color:#DDDDDD; padding:3px; font-weight:bold;'></div>";
        html += me.htmlCls.divStr + "replay_cmd' style='background-color:#DDDDDD; padding:3px; max-width:250px'></div>";
        html += "</div>";

        return html;
    }

    //Set the HTML code for the tools section. It includes several buttons, and is the second line at the top of the viewer.
    setTools() { let me = this.icn3dui;
        if(me.bNode) return '';

        let html = "";

        html += me.htmlCls.divStr + "selection' style='display:none;'><div style='position:absolute; z-index:555; float:left; display:table-row; margin: 32px 0px 0px 0px;'>";
        //html += "<table style='margin-top: 3px; width:100px;'>";
        html += "<table style='margin-top: 3px; width:770px; background-color:#EEE;'>";

        html += this.setTools_base();

        // add custom buttons here
        // ...

        html += "</table>";
        html += "</div></div>";

        return html;
    }

    setButton(buttonStyle, id, title, text, color) { let me = this.icn3dui;
        if(me.bNode) return '';

        color =(color !== undefined) ? 'color:' + color : '';
        let bkgdColor = me.utilsCls.isMobile() ? ' background-color:#DDDDDD;' : '';
        return "<div style='margin:3px 0px 0px 10px;'><button style='-webkit-appearance:" + buttonStyle + "; height:36px;" + bkgdColor + "' id='" + me.pre + id + "'><span style='white-space:nowrap;" + color + "' class='icn3d-commandTitle' title='" + title + "'>" + text + "</span></button></div>";
    }

    setIcon(iconType, id, title, iconStyle, url, bText, bHighlight) { let me = this.icn3dui;
        if(me.bNode) return '';

        let color = (bHighlight) ? 'color:#f8b84e; ' : 'color:#1c94c4; ';
        let bkgdColor = ' background-color:#EEE; ';
        let cssCursor = (iconType == 'text') ? '' : 'cursor:pointer;';

        //let iconHtml = '<i id="' + me.pre + id + '" class="fa fa-' + iconStyle + '" title="' + title + '" style="font-size:20px; ' + color + bkgdColor + cssCursor + cssBorder + '"></i>';
        let iconHtml;
        if(bText) {
            iconHtml = '<div id="' + me.pre + id + '" title="' + title + '" style="font-family: Arial, Helvetica, sans-serif; font-size:16px; width:16px; height:16px;' + color + bkgdColor + cssCursor + '">' + iconStyle + '</div>';
        }
        else {
            iconHtml = '<i id="' + me.pre + id + '" class="las la-' + iconStyle + '" title="' + title + '" style="width:16px; height:16px;' + color + bkgdColor + cssCursor + '"></i>';
        }

        if(iconType == 'link') {
            return '<a href="' + url + '" target="_blank">' + iconHtml + '</a>';
        }
        else {
            return iconHtml;
        }
    }

    setTools_base() { let me = this.icn3dui;
        if(me.bNode) return '';

        // second row
        let html = "<tr valign='center'>";

        let iconType = 'regular';
        let tdStr = "<td valign='top' align='center'>";
        let tdStrBorder = "<td valign='top' align='center' style='border-left: solid 1px #888888'>";

        // line-awesome: https://icons8.com/line-awesome
        // File menu
        html += tdStr + this.setIcon(iconType, 'tool_mmdbafid', 'Input PDB/MMDB/AlphaFold IDs', 'id', undefined, true) + "</td>";
        html += tdStr + this.setIcon(iconType, 'tool_pdbfile', 'Input PDB Files (appendable)', 'file-alt') + "</td>";
        html += tdStr + this.setIcon(iconType, 'tool_sharelink', 'Get Share Link', 'link') + "</td>";
        html += tdStr + this.setIcon(iconType, 'saveimage', 'Save iCn3D PNG Image', 'camera') + "</td>";

        // Select menu
        html += tdStrBorder + this.setIcon(iconType, 'tool_definedsets', 'Defined Sets', 'object-group') + "</td>";
        html += tdStr + this.setIcon(iconType, 'tool_aroundsphere', 'Select by Distance', 'dot-circle') + "</td>";
        html += tdStr + this.setIcon(iconType, 'tool_saveselection', 'Save Selection as a Set', 'save') + "</td>";
        html += tdStr + this.setIcon(iconType, 'toggleHighlight', 'Toggle Highlight', 'highlighter') + "</td>";

        // View menu
        html += tdStrBorder + this.setIcon(iconType, 'show_selected', 'View Selection', 'eye') + "</td>";
        html += tdStr + this.setIcon(iconType, 'tool_selectedcenter', 'Zoom in Selection', 'search-plus') + "</td>";
        html += tdStr + this.setIcon(iconType, 'alternate', "Alternate the Structures by keying the letter 'a'", 'a', undefined, true, true) + "</td>";
        html += tdStr + this.setIcon(iconType, 'tool_resetOrientation', 'Reset Orientation', 'undo-alt') + "</td>";

        // Style menu
        html += tdStrBorder + this.setIcon(iconType, 'tool_proteinsRibbon', 'Style Ribbon for proteins', 'dna') + "</td>";
        html += tdStr + this.setIcon(iconType, 'tool_proteinsSphere', 'Style Sphere for proteins', 'volleyball-ball') + "</td>";
        html += tdStr + this.setIcon(iconType, 'tool_surfaceVDW', 'Show Van der Waals Surface', 'cloud') + "</td>";
        html += tdStr + this.setIcon(iconType, 'tool_bkgd', 'Toggle Background Color', 'adjust') + "</td>";

        // Color menu
        html += tdStrBorder + this.setIcon(iconType, 'tool_clrRainbowChain', 'Color Rainbow for Chains', 'rainbow') + "</td>"; 
        html += tdStr + this.setIcon(iconType, 'tool_clrSSGreen', 'Color by Secondary Structures', 'ring') + "</td>";
        html += tdStr + this.setIcon(iconType, 'tool_clrChain', 'Color by Chains', 'layer-group') + "</td>";
        html += tdStr + this.setIcon(iconType, 'tool_clrAtom', 'Color by Atoms', 'atom') + "</td>";

        // Analysis menu
        html += tdStrBorder + this.setIcon(iconType, 'tool_selectannotations', 'Sequences & Annotations', 'grip-lines') + "</td>";
        html += tdStr + this.setIcon(iconType, 'hbondsYes', 'Interactions', 'users') + "</td>";
        html += tdStr + this.setIcon(iconType, 'tool_delphi', 'DelPhi Potentials', 'cloud-meatball') + "</td>";
        html += tdStr + this.setIcon(iconType, 'removeLabels', 'Remove Labels', 'remove-format') + "</td>";

        // Help menu
        html += tdStrBorder + this.setIcon('link', 'tool-gallery', 'Gallery', 'image', 'https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d.html#gallery') + "</td>";
        html += tdStr + this.setIcon('link', 'tool-video', 'Videos', 'file-video', 'https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d.html#videos') + "</td>";
        html += tdStr + this.setIcon('link', 'tool-github', 'iCn3D GitHub', 'code', 'https://github.com/ncbi/icn3d') + "</td>";
        html += tdStr + this.setIcon('link', 'tool-hints', 'Transform Hints', 'info-circle', 'https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d.html#useicn3d') + "</td>";

        html += "</tr>";

        return html;
    }

    setTheme(color) { let me = this.icn3dui;
        if(me.bNode) return '';

        let borderColor, bkgdColor, bkgdImg, iconImg, activeTabColor;

        me.htmlCls.themecolor = color;

        if(color == 'orange') {
            borderColor = '#e78f08';
            bkgdColor = '#f6a828';
            bkgdImg = 'ui-bg_gloss-wave_35_f6a828_500x100.png';
            iconImg = 'ui-icons_ef8c08_256x240.png';
            activeTabColor = '#eb8f00';
        }
        else if(color == 'black') {
            borderColor = '#333333';
            bkgdColor = '#333333';
            bkgdImg = 'ui-bg_gloss-wave_25_333333_500x100.png';
            iconImg = 'ui-icons_222222_256x240.png';
            activeTabColor = '#222222';
        }
        else if(color == 'blue') {
            borderColor = '#4297d7';
            bkgdColor = '#5c9ccc';
            bkgdImg = 'ui-bg_gloss-wave_55_5c9ccc_500x100.png';
            iconImg = 'ui-icons_228ef1_256x240.png';
            activeTabColor = '#444';
        }

        $('.ui-widget-header').css({
            'border': '1px solid ' + borderColor,
            'background': bkgdColor + ' url("https://www.ncbi.nlm.nih.gov/Structure/icn3d/lib/images/' + bkgdImg + '") 50% 50% repeat-x',
            'color':'#fff',
            'font-weight':'bold'
        });

        $('.ui-button .ui-icon').css({
            'background-image': 'url(https://www.ncbi.nlm.nih.gov/Structure/icn3d/lib/images/' + iconImg + ')'
        });

        $('.ui-state-active a, .ui-state-active a:link, .ui-state-active a:visited').css({
            'color': activeTabColor,
            'text-decoration': 'none'
        });
    }

    //Set the textarea for the log output.
    setLogWindow(bUpdate, bCmdWindowInput) { let me = this.icn3dui;
        if(me.bNode) return '';

        let bCmdWindow, html = "";

        // check command window 
        let value = me.htmlCls.setHtmlCls.getCookie('cmdwindow');
        if(value != '') {
            bCmdWindow = (bCmdWindowInput !== undefined) ? bCmdWindowInput : parseInt(value);
            if(bCmdWindow == 1) { // default 0
                me.htmlCls.LOG_HEIGHT = 180; //65;
                me.htmlCls.CMD_HEIGHT = 0.8*me.htmlCls.LOG_HEIGHT;

                if(!bUpdate) html += me.htmlCls.divStr + "cmdlog' style='float:left; margin-top: 5px; width: 100%;'>";
                html += "<textarea id='" + me.pre + "logtext' rows='2' style='width: 100%; height: " + me.htmlCls.CMD_HEIGHT + "px;  margin: auto; padding: 5px; box-sizing: border-box; border: 4px inset orange; background-color: " + me.htmlCls.GREYD + ";'></textarea>";
            }
            else {
                me.htmlCls.LOG_HEIGHT = 65;
                me.htmlCls.CMD_HEIGHT = 0.8*me.htmlCls.LOG_HEIGHT;

                if(!bUpdate) html += me.htmlCls.divStr + "cmdlog' style='float:left; margin-top: 5px; width: 100%;'>";
                html += "<textarea id='" + me.pre + "logtext' rows='2' style='width: 100%; height: " + me.htmlCls.CMD_HEIGHT + "px; padding: 0px; border: 0px; background-color: " + me.htmlCls.GREYD + ";'></textarea>";                 
            }
        }
        else {
            bCmdWindow = 0;

            me.htmlCls.LOG_HEIGHT = 65;
            me.htmlCls.CMD_HEIGHT = 0.8*me.htmlCls.LOG_HEIGHT;

            if(!bUpdate) html += me.htmlCls.divStr + "cmdlog' style='float:left; margin-top: 5px; width: 100%;'>";
            html += "<textarea id='" + me.pre + "logtext' rows='2' style='width: 100%; height: " + me.htmlCls.CMD_HEIGHT + "px; padding: 0px; border: 0px; background-color: " + me.htmlCls.GREYD + ";'></textarea>";
        }
        
        if(!bUpdate) html += "</div>";

        if(bUpdate) {
            me.htmlCls.clickMenuCls.setLogCmd('set cmdwindow ' + bCmdWindow, true);
            $("#" + me.pre + "cmdlog").html(html);
        }

        return html;
    }

    //Set the menu "File" at the top of the viewer.
    setMenu1() { let me = this.icn3dui;
        if(me.bNode) return '';

        let html = "";

        html += "<div class='icn3d-menu'>";

        html += "<accordion id='" + me.pre + "accordion1' class='icn3d-accordion'>";
        html += "<h3>File</h3>";
        html += "<div>";

        html += this.setMenu1_base();

        html += "</div>";
        html += "</accordion>";
        html += "</div>";

        return html;
    }

    setMenu1_base() { let me = this.icn3dui;
        if(me.bNode) return '';

        let html = "";

        html += "<ul class='icn3d-mn-item'>";
        
        html += this.getMenuText('mn1_searchgrooup', 'Search Structure ' + me.htmlCls.wifiStr, undefined, 1, 1);
        html += "<ul>";
        html += this.getMenuUrl('mn1_searchstru', 'https://www.ncbi.nlm.nih.gov/structure', 'PDB Structures ' + me.htmlCls.wifiStr, 1, 2);
        html += this.getLink('mn1_proteinname', 'AlphaFold Structures ' + me.htmlCls.wifiStr, 1, 2);
        html += this.getMenuUrl('mn1_afdatabase', 'https://alphafold.ebi.ac.uk', 'AlphaFold UniProt Database ' + me.htmlCls.wifiStr, undefined, 2);
        html += "</ul>";
        html += "</li>";

        html += this.getMenuText('mn1_searchsimilar', 'Search Similar' + me.htmlCls.wifiStr, undefined, undefined, 1);
        html += "<ul>";
        html += this.getLink('mn1_vastplus', 'NCBI VAST+ (PDB Complex)' + me.htmlCls.wifiStr, undefined, 2);
        html += this.getLink('mn1_vast', 'NCBI VAST (PDB Chain)' + me.htmlCls.wifiStr, undefined, 2);
        html += this.getLink('mn1_foldseek', 'Foldseek (PDB & AlphaFold)' + me.htmlCls.wifiStr, undefined, 2);
        html += "</ul>";
        html += "</li>";

        html += this.getMenuText('mn1_retrievebyid', 'Retrieve by ID', undefined, 1, 1); 
        html += "<ul>";
        
        html += this.getLink('mn1_mmdbafid', 'PDB/MMDB/AlphaFold IDs' + me.htmlCls.wifiStr, 1, 2);
        html += this.getLink('mn1_mmdbid', 'NCBI MMDB ID (annotation) ' + me.htmlCls.wifiStr, undefined, 2);
        html += this.getLink('mn1_mmtfid', 'RCSB BCIF/MMTF ID (fast) ' + me.htmlCls.wifiStr, undefined, 2);
        html += this.getLink('mn1_pdbid', 'RCSB PDB ID ' + me.htmlCls.wifiStr, undefined, 2);

        html += this.getMenuText('mn1_afwrap', 'AlphaFold Structures', undefined, undefined, 2);
        html += "<ul>";
        
        html += this.getLink('mn1_afid', 'UniProt ID ' + me.htmlCls.wifiStr, undefined, 3);
        html += this.getLink('mn1_refseqid', 'NCBI Protein Accession ' + me.htmlCls.wifiStr, undefined, 3);
        html += "</ul>";

        
        html += this.getLink('mn1_opmid', 'OPM PDB ID ' + me.htmlCls.wifiStr, undefined, 2);
        html += this.getLink('mn1_mmcifid', 'RCSB mmCIF ID ' + me.htmlCls.wifiStr, undefined, 2);
        //html += this.getLink('mn1_gi', 'NCBI gi ' + me.htmlCls.wifiStr, undefined, 2);

        html += this.getLink('mn1_cid', 'PubChem CID/Name/InchI ' + me.htmlCls.wifiStr, 1, 2);
        html += this.getLink('mn1_smiles', 'Chemical SMILES ', undefined, 2);
        
        html += "</ul>";
        html += "</li>";

        html += this.getMenuText('mn1_openfile', 'Open File', undefined, 1, 1);
        html += "<ul>";
//        html += this.getLink('mn1_pdbfile', 'PDB File');
//        html += this.getLink('mn1_pdbfile_app', 'PDB File (append)');
        html += this.getLink('mn1_pdbfile_app', 'PDB Files (appendable)', 1, 2);
        html += this.getLink('mn1_mmciffile', 'mmCIF Files (appendable)', undefined, 2);
        html += this.getLink('mn1_mol2file', 'Mol2 File', undefined, 2);
        html += this.getLink('mn1_sdffile', 'SDF File', undefined, 2);
        html += this.getLink('mn1_xyzfile', 'XYZ File', undefined, 2);
        html += this.getLink('mn1_afmapfile', 'AlphaFold PAE File', undefined, 2);

        html += this.getLink('mn1_urlfile', 'URL(CORS) ' + me.htmlCls.wifiStr, undefined, 2);
        html += this.getMenuSep();
        html += this.getLink('mn1_pngimage', 'iCn3D PNG (appendable)', 1, 2);
        html += this.getLink('mn1_state', 'State/Script File', undefined, 2);
        html += this.getLink('mn1_fixedversion', 'Share Link in Archived Ver. ' + me.htmlCls.wifiStr, undefined, 2);
        html += this.getLink('mn1_selection', 'Selection File', undefined, 2);
        html += this.getLink("mn1_collection", "Collection File", undefined, 2);

        html += this.getMenuSep();

        html += this.getMenuText('mn1_dsn6wrap', 'Electron Density', undefined, undefined, 2);
        html += "<ul>";
        html += this.getLink('mn1_dsn6', 'Local File', undefined, 3);
        html += this.getLink('mn1_dsn6url', 'URL(CORS) ' + me.htmlCls.wifiStr, undefined, 3);
        html += "</ul>";

        html += "<li><br/></li>";

        html += "</ul>";
        html += "</li>";

        //html += this.getMenuText('mn1_fold', 'AlphaFold/ESM', undefined, undefined, 1);
        html += this.getMenuText('mn1_fold', 'Predict by Seq.', undefined, undefined, 1);
        html += "<ul>";
        html += this.getLink('mn1_esmfold', 'ESMFold', undefined, 2);
        //html += this.getMenuUrl('mn1_esmfold_link', "https://colab.research.google.com/github/sokrypton/ColabFold/blob/main/ESMFold.ipynb", "ESMFold via ColabFold" + me.htmlCls.wifiStr, undefined, 2);
        html += this.getLink('mn1_alphafold', 'AlphaFold2 via ColabFold' + me.htmlCls.wifiStr, undefined, 2);
        html += "</ul>";

        
        html += this.getMenuText('mn1_alignwrap', 'Align', undefined, 1, 1);
        html += "<ul>";
        
        html += this.getMenuText('mn1_chainalignwrap', 'Multiple Chains', undefined, 1, 2);
        html += "<ul>";
        html += this.getRadio('mn1_chainalignRad', 'mn1_chainalign', 'by Structure Alignment ' + me.htmlCls.wifiStr, undefined, 1, 3);
        html += this.getRadio('mn1_chainalignRad', 'mn1_chainalign2', 'by Sequence Alignment ' + me.htmlCls.wifiStr, undefined, 1, 3);
        html += this.getRadio('mn1_chainalignRad', 'mn1_chainalign3', 'Residue by Residue', undefined, undefined, 3);
        html += "</ul>";
        html += "</li>";

        html += this.getMenuText('mn1_aligntwostru', 'Protein Complexes', undefined, undefined, 2);
        html += "<ul>";
        html += this.getLink('mn1_align', 'Two PDB Structures ' + me.htmlCls.wifiStr, undefined, 3);
        html += this.getLink('mn1_alignaf', 'Two AlphaFold Structures ' + me.htmlCls.wifiStr, undefined, 3);
        html += "</ul>";

        html += this.getLink('mn1_blast_rep_id', 'Sequence to Structure', undefined, 2);

        html += "</ul>";
        html += "</li>";

        html += this.getMenuText('mn2_realignWrap', 'Realign Selection', undefined, undefined, 1);
        html += "<ul>";

        html += this.getMenuText('mn2_chainrealignwrap', 'Multiple Chains', undefined, undefined, 2);
        html += "<ul>";
        html += this.getRadio('mn2_realign', 'mn2_realignonstruct', 'by Structure Alignment ' + me.htmlCls.wifiStr, undefined, undefined, 3);
        html += this.getRadio('mn2_realign', 'mn2_realignonseqalign', 'by Sequence Alignment ' + me.htmlCls.wifiStr, undefined, undefined, 3);
        html += this.getRadio('mn2_realign', 'mn2_realignresbyres', 'Residue by Residue', undefined, undefined, 3);
        html += "</ul>";

        html += this.getLink('mn2_realigntwostru', 'Protein Complexes', undefined, 2);

        html += "</ul>";
        html += "</li>";

        html += this.getMenuText('mn1_3dpprint', '3D Printing', undefined, 1, 1);
        html += "<ul>";
        if(me.cfg.cid === undefined) {
            html += this.getLink('mn1_exportVrmlStab', 'WRL/VRML(Color, W/ Stab.)', 1, 2);
            html += this.getLink('mn1_exportStlStab', 'STL(W/ Stabilizers)', 1, 2);
            html += this.getMenuSep();
            html += this.getLink('mn1_exportVrml', 'WRL/VRML(Color)', undefined, 2);
            html += this.getLink('mn1_exportStl', 'STL', undefined, 2);

            html += this.getMenuSep();
            html += this.getLink('mn1_stabilizerYes', 'Add All Stabilizers', undefined, 2);
            html += this.getLink('mn1_stabilizerNo', 'Remove All Stabilizers', undefined, 2);
            html += this.getMenuSep();
            html += this.getLink('mn1_stabilizerOne', 'Add One Stabilizer', undefined, 2);
            html += this.getLink('mn1_stabilizerRmOne', 'Remove One Stabilizer', undefined, 2);
            html += this.getMenuSep();
            html += this.getLink('mn1_thicknessSet', 'Set Thickness', undefined, 2);
        }
        else {
            html += this.getLink('mn1_exportVrml', 'VRML(Color)', 1, 2);
            html += this.getLink('mn1_exportStl', 'STL', 1, 2);
        }

        html += "</ul>";
        html += "</li>";

        html += this.getMenuText('mn1_savefile', 'Save File', undefined, 1, 1);
        html += "<ul>";
        html += this.getMenuText('mn1_savepngimage', 'iCn3D PNG Image', undefined, 1, 2);
        html += "<ul>";
        html += this.getLink('mn1_exportCanvas', 'Original Size & HTML', 1, 3);
        html += this.getLink('mn1_exportCanvas1', 'Original Size', undefined, 3);

        html += this.getLink('mn1_exportCanvas2', '2X Large', undefined, 3);
        html += this.getLink('mn1_exportCanvas4', '4X Large', undefined, 3);
        html += this.getLink('mn1_exportCanvas8', '8X Large', undefined, 3);

        html += "</ul>";
        html += "</li>";

        html += this.getLink('mn1_exportState', 'State File', undefined, 2);
        html += this.getLink('mn1_exportSelections', 'Selection File', undefined, 2);
        html += this.getLink('mn1_exportSelDetails', 'Selection Details', undefined, 2);
        html += this.getLink('mn1_exportCounts', 'Residue Counts', undefined, 2);

        html += this.getLink('mn1_exportPdbRes', 'PDB', 1, 2);
        html += this.getLink('profixpdb', 'PDB with Missing Atoms', undefined, 2);
        
        // the quality is not good to add hydrogen
        //html += this.getLink('profixpdbh', 'PDB with Hydrogens', undefined, 2);

        if(me.cfg.cid === undefined) {
            html += this.getLink('mn1_exportSecondary', 'Secondary Structure', undefined, 2);
        }

        html += this.getMenuText('m1_exportrefnum', 'Reference Numbers', undefined, undefined, 2);
        html += "<ul>";
        html += this.getLink('mn1_exportIgstrand', 'Ig Strand', undefined, 3);
        html += this.getLink('mn1_exportKabat', 'Kabat', undefined, 3);
        html += this.getLink('mn1_exportImgt', 'IMGT', undefined, 3);
        html += "</ul>";

        html += "<li><br/></li>";

        html += "</ul>";
        html += "</li>";

        html += this.getLink('mn1_sharelink', 'Share Link ' + me.htmlCls.wifiStr, 1, 1);

        html += this.getLink('mn1_replayon', 'Replay Each Step', undefined, 1);

        html += this.getMenuSep();

        html += this.getMenuText('mn1_menuwrap', 'Customize Menus', undefined, 1, 1);
        html += "<ul>";
        html += this.getLink('mn1_menuall', 'All Menus', 1, 2);
        html += this.getLink('mn1_menusimple', 'Simple Menus', 1, 2);
        html += this.getMenuSep();
        html += this.getLink('mn1_menupref', 'Preferences', 1, 2);
        html += this.getLink('mn1_menuloadpref', 'Load Preferences', 1, 2);
        html += "</ul>";
        html += "</li>";

        html += "<li><br/></li>";

        html += "</ul>";

        return html;
    }

    //Set the menu "Select" at the top of the viewer.
    setMenu2() { let me = this.icn3dui;
        if(me.bNode) return '';

        let html = "";

        html += "<div class='icn3d-menu'>";
        html += "<accordion id='" + me.pre + "accordion2' class='icn3d-accordion'>";
        html += "<h3>Select</h3>";
        html += "<div>";

        html += this.setMenu2_base();

        html += "</div>";
        html += "</accordion>";
        html += "</div>";

        return html;
    }

    setMenu2_base() { let me = this.icn3dui;
        if(me.bNode) return '';

        let html = "";

        html += "<ul class='icn3d-mn-item'>";

        html += this.getLink('mn2_definedsets', 'Defined Sets', 1, 1);
        html += this.getLink('mn2_selectall', 'All', undefined, 1);
        html += this.getLink('mn2_selectdisplayed', 'Displayed Set', undefined, 1);
        html += this.getLink('mn2_aroundsphere', 'by Distance', 1, 1);

        html += this.getMenuText('mn2_selbyprop', 'by Property', undefined, undefined, 1);
        html += "<ul>";
        html += this.getLink('mn2_propPos', 'Positive', undefined, 2);
        html += this.getLink('mn2_propNeg', 'Negative', undefined, 2);
        html += this.getLink('mn2_propHydro', 'Hydrophobic', undefined, 2);
        html += this.getLink('mn2_propPolar', 'Polar', undefined, 2);
        html += this.getLink('mn2_propBfactor', 'B-factor/pLDDT', undefined, 2);
        html += this.getLink('mn2_propSolAcc', 'Solvent Accessibility', undefined, 2);
        html += "</ul>";
        html += "</li>";

        html += this.getLink('mn2_selectcomplement', 'Inverse', undefined, 1);
        html += this.getLink('mn2_selectmainchains', 'Main Chains', undefined, 1);
        html += this.getLink('mn2_selectsidechains', 'Side Chains', undefined, 1);
        html += this.getLink('mn2_selectmainsidechains', 'Main & Side Chains', undefined, 1);
        html += this.getLink('mn2_command', 'Advanced', undefined, 1);

        if(me.cfg.cid === undefined) {
            html += this.getMenuText('mn2_selon3d', 'Select on 3D', undefined, 1, 1);
            html += "<ul>";

            html += "<li>\"Alt\"+Click: start selection</li>";
            html += "<li>\"Ctrl\"+Click: union selection</li>";
            html += "<li>\"Shift\"+Click: range Selection</li>";
            html += this.getMenuSep();
            html += this.getRadio('mn2_pk', 'mn2_pkChain', 'Chain', undefined, 1, 2);
            if(me.cfg.mmdbid !== undefined || me.cfg.gi !== undefined) {
                html += this.getRadio('mn2_pk', 'mn2_pkDomain', '3D Domain', undefined, undefined, 2);
            }
            html += this.getRadio('mn2_pk', 'mn2_pkStrand', 'Strand/Helix', undefined, undefined, 2);
            html += this.getRadio('mn2_pk', 'mn2_pkResidue', 'Residue', true, 1, 2);
            html += this.getRadio('mn2_pk', 'mn2_pkYes', 'Atom', undefined, 1, 2);
            html += this.getRadio('mn2_pk', 'mn2_pkNo', 'None', undefined, undefined, 2);
            html += "</ul>";
            html += "</li>";
        }
        else {
            if(me.utilsCls.isMobile()) {
                html += "<li><span>Touch to pick</span></li>";
            }
            else {
                html += "<li><span>Picking with<br>\"Alt\" + Click</span></li>";
            }
        }

        html += this.getMenuSep();

        html += this.getLink('mn2_saveselection', 'Save Selection', 1, 1);
        html += this.getLink('clearall', 'Clear Selection', undefined, 1);
        html += this.getLink('mn2_saveresidue', 'Save Res. in Sel.', 1, 1);

        html += this.getMenuSep();

        html += this.getMenuText('mn2_hlcolor', 'Highlight Color', undefined, undefined, 1);
        html += "<ul>";
        html += this.getRadio('mn2_hl_clr', 'mn2_hl_clrYellow', 'Yellow', true, undefined, 2);
        html += this.getRadio('mn2_hl_clr', 'mn2_hl_clrGreen', 'Green', undefined, undefined, 2);
        html += this.getRadio('mn2_hl_clr', 'mn2_hl_clrRed', 'Red', undefined, undefined, 2);
        html += "</ul>";
        html += "</li>";
        html += this.getMenuText('mn2_hlstyle', 'Highlight Style', undefined, undefined, 1);
        html += "<ul>";

        html += this.getRadio('mn2_hl_style', 'mn2_hl_styleOutline', 'Outline', true, undefined, 2);
        html += this.getRadio('mn2_hl_style', 'mn2_hl_styleObject', '3D Objects', undefined, undefined, 2);

        html += "</ul>";
        html += "</li>";

        html += this.getLink('toggleHighlight2', 'Toggle Highlight', 1, 1);

        html += "<li><br/></li>";

        html += "</ul>";

        return html;
    }

    setMenu2b() { let me = this.icn3dui;
        if(me.bNode) return '';

        let html = "";

        html += "<div class='icn3d-menu'>";
        html += "<accordion id='" + me.pre + "accordion2b' class='icn3d-accordion'>";
        html += "<h3>View</h3>";
        html += "<div>";

        html += this.setMenu2b_base();

        html += "</div>";
        html += "</accordion>";
        html += "</div>";

        return html;
    }

    setMenu2b_base() { let me = this.icn3dui;
        if(me.bNode) return '';

        let html = "";
        html += "<ul class='icn3d-mn-item'>";

        html += this.getLink('mn2_show_selected', 'View Selection', 1, 1);
        html += this.getLink('mn2_hide_selected', 'Hide Selection', 1, 1);
        html += this.getLink('mn2_selectedcenter', 'Zoom in Selection', 1, 1);
        //html += this.getLink('mn6_center', 'Center Selection', undefined, 1);
        html += this.getLink('mn6_center', 'Center Selection', 1, 1);

        html += this.getLink('mn2_fullstru', 'View Full Structure');
        html += this.getLinkWrapper('mn2_alternate', 'Alternate(Key "a")', 'mn2_alternateWrap', undefined, 1);

        if(me.cfg.opmid !== undefined) {
            html += this.getLinkWrapper('togglemem', 'Toggle Membrane', 'togglememli', undefined, 1);
        }
        //else if(me.cfg.mmdbafid !== undefined || me.cfg.afid !== undefined) {
        else if(me.cfg.cid === undefined) {
            // hide by default
            html += this.getLinkWrapper('togglemem', 'Toggle Membrane', 'togglememli', undefined, 1, true);
        }

        if(me.cfg.opmid !== undefined) {
            html += this.getLinkWrapper('adjustmem', 'Adjust Membrane', 'adjustmemli', undefined, 1);
            html += this.getLinkWrapper('selectplane', 'Select between<br>Two X-Y Planes</span>', 'selectplaneli', undefined, 1);
        }

        html += this.getMenuSep();

        html += this.getMenuText('mn2_vrarhints', 'VR & AR Hints', undefined, 1, 1);
        html += "<ul>";
        html += this.getMenuUrl("vrhint", me.htmlCls.baseUrl + "icn3d/icn3d.html#vr", "VR: VR Headsets", 1, 2);
        html += this.getMenuUrl("arhint", me.htmlCls.baseUrl + "icn3d/icn3d.html#ar", "AR: Chrome in Android", 1, 2);
        html += "</ul>";
        html += "</li>";

        html += this.getLink('mn6_sidebyside', 'Side by Side', 1, 1);

        html += this.getMenuText('mn2_rotate', 'Rotate', undefined, 1, 1);
        html += "<ul>";

        html += this.getMenuText('mn2_rotate90', 'Rotate 90&deg;', undefined, undefined, 2);
        html += "<ul>";
        html += this.getRadio('mn6_rotate90', 'mn6_rotatex', 'rotate x', undefined, undefined, 2);
        html += this.getRadio('mn6_rotate90', 'mn6_rotatey', 'rotate y', undefined, undefined, 2);
        html += this.getRadio('mn6_rotate90', 'mn6_rotatez', 'rotate z', undefined, undefined, 2);
        html += "</ul>";
        html += "</li>";
        html += this.getMenuText('mn2_rotateauto', 'Auto Rotation', undefined, 1, 2);
        html += "<ul>";
        html += this.getRadio('mn6_rotate', 'mn6_rotateleft', 'Rotate Left', undefined, 1, 3);
        html += this.getRadio('mn6_rotate', 'mn6_rotateright', 'Rotate Right', undefined, 1, 3);
        html += this.getRadio('mn6_rotate', 'mn6_rotateup', 'Rotate Up', undefined, 1, 3);
        html += this.getRadio('mn6_rotate', 'mn6_rotatedown', 'Rotate Down', undefined, 1, 3);
        html += "</ul>";
        html += "</li>";

        html += "</ul>";
        html += "</li>";

        html += this.getLink('mn2_translate', 'Translate XYZ', undefined, 1);
        html += this.getLink('mn2_matrix', 'Rotate with Matrix', undefined, 1);

        html += this.getMenuText('mn2_camera', 'Camera', undefined, undefined, 1);
        html += "<ul>";
        html += this.getRadio('mn6_camera', 'mn6_cameraPers', 'Perspective', true, undefined, 2);
        html += this.getRadio('mn6_camera', 'mn6_cameraOrth', 'Orthographic', undefined, undefined, 2);
        html += "</ul>";
        html += "</li>";
        html += this.getMenuText('mn2_fog', 'Fog for Selection', undefined, undefined, 1);
        html += "<ul>";
        html += this.getRadio('mn6_showfog', 'mn6_showfogYes', 'On', undefined, undefined, 2);
        html += this.getRadio('mn6_showfog', 'mn6_showfogNo', 'Off', true, undefined, 2);
        html += "</ul>";
        html += "</li>";
        html += this.getMenuText('mn2_slab', 'Slab for Selection', undefined, undefined, 1);
        html += "<ul>";
        html += this.getRadio('mn6_showslab', 'mn6_showslabYes', 'On', undefined, undefined, 2);
        html += this.getRadio('mn6_showslab', 'mn6_showslabNo', 'Off', true, undefined, 2);
        html += "</ul>";
        html += "</li>";
        html += this.getMenuText('mn2_axes', 'XYZ-axes', undefined, undefined, 1);
        html += "<ul>";
        html += this.getRadio('mn6_showaxis', 'mn6_showaxisYes', 'Original', undefined, undefined, 2);
        html += this.getRadio('mn6_showaxis', 'mn6_showaxisSel', 'Prin. Axes on Sel.', undefined, undefined, 2);
        html += this.getRadio('mn6_showaxis', 'mn6_showaxisNo', 'Hide', true, undefined, 2);
        html += "</ul>";
        html += "</li>";

        html += this.getMenuSep();

        html += this.getMenuText('mn2_resetwrap', 'Reset', undefined, 1, 1);
        html += "<ul>";
        html += this.getRadio('mn6_reset', 'reset', 'All', undefined, 1, 2);
        html += this.getRadio('mn6_reset', 'mn6_resetOrientation', 'Orientation', undefined, 1, 2);
        html += "</ul>";
        html += "</li>";

        html += this.getLink('mn6_back', 'Undo', undefined, 1);
        html += this.getLink('mn6_forward', 'Redo', undefined, 1);

        html += this.getLink('mn6_fullscreen', 'Full Screen', undefined, 1);
    //    html += this.getLink('mn6_exitfullscreen', 'Exit Full Screen');

        html += "<li><br/></li>";

        html += "</ul>";

        return html;
    }

    //Set the menu "Style" at the top of the viewer.
    setMenu3() { let me = this.icn3dui;
        if(me.bNode) return '';

        let html = "";

        html += "<div class='icn3d-menu'>";
        html += "<accordion id='" + me.pre + "accordion3' class='icn3d-accordion'>";
        html += "<h3 id='" + me.pre + "style'>Style</h3>";
        html += "<div>";

        html += this.setMenu3_base();

        html += "</div>";
        html += "</accordion>";
        html += "</div>";

        return html;
    }

    setMenu3_base() { let me = this.icn3dui;
        if(me.bNode) return '';

        let html = "";

        html += "<ul class='icn3d-mn-item'>";

        if(me.cfg.cid === undefined) {
            html += this.getMenuText('mn3_proteinwrap', 'Proteins', undefined, 1, 1);
            html += "<ul>";
            if(me.cfg.align !== undefined || me.cfg.chainalign !== undefined) {
                html += this.getRadio('mn3_proteins', 'mn3_proteinsRibbon', 'Ribbon', undefined, 1, 2);
            }
            else {
                html += this.getRadio('mn3_proteins', 'mn3_proteinsRibbon', 'Ribbon', true, 1, 2);
            }

            html += this.getRadio('mn3_proteins', 'mn3_proteinsStrand', 'Strand', undefined, undefined, 2);
            html += this.getRadio('mn3_proteins', 'mn3_proteinsCylinder', 'Cylinder and Plate', undefined, undefined, 2);
            html += this.getRadio('mn3_proteins', 'mn3_proteinsSchematic', 'Schematic', undefined, 1, 2);

            if(me.cfg.align !== undefined || me.cfg.chainalign !== undefined) {
                html += this.getRadio('mn3_proteins', 'mn3_proteinsCalpha', 'C Alpha Trace', true, 1, 2);
            }
            else {
                html += this.getRadio('mn3_proteins', 'mn3_proteinsCalpha', 'C Alpha Trace', undefined, 1, 2);
            }

            html += this.getRadio('mn3_proteins', 'mn3_proteinsBackbone', 'Backbone', undefined, undefined, 2);
            html += this.getRadio('mn3_proteins', 'mn3_proteinsBfactor', 'B-factor Tube', undefined, 1, 2);
            html += this.getRadio('mn3_proteins', 'mn3_proteinsLines', 'Lines', undefined, 1, 2);
            html += this.getRadio('mn3_proteins', 'mn3_proteinsStick', 'Stick', undefined, 1, 2);
            html += this.getRadio('mn3_proteins', 'mn3_proteinsBallstick', 'Ball and Stick', undefined, 1, 2);
            html += this.getRadio('mn3_proteins', 'mn3_proteinsSphere', 'Sphere', undefined, 1, 2);
            html += this.getRadio('mn3_proteins', 'mn3_proteinsNo', 'Hide', undefined, 1, 2);
            html += "</ul>";
            html += "</li>";

            html += this.getMenuText('mn3_sidecwrap', 'Side Chains', undefined, 1, 1);
            html += "<ul>";

            html += this.getRadio('mn3_sidec', 'mn3_sidecLines', 'Lines', undefined, 1, 2);
            html += this.getRadio('mn3_sidec', 'mn3_sidecStick', 'Stick', undefined, 1, 2);
            html += this.getRadio('mn3_sidec', 'mn3_sidecBallstick', 'Ball and Stick', undefined, 1, 2);
            html += this.getRadio('mn3_sidec', 'mn3_sidecSphere', 'Sphere', undefined, 1, 2);
            html += this.getRadio('mn3_sidec', 'mn3_sidecNo', 'Hide', true, 1, 2);
            html += "</ul>";
            html += "</li>";

            html += this.getMenuText('mn3_nuclwrap', 'Nucleotides', undefined, 1, 1);
            html += "<ul>";
            html += this.getRadio('mn3_nucl', 'mn3_nuclCartoon', 'Cartoon', true, 1, 2);
            html += this.getRadio('mn3_nucl', 'mn3_nuclPhos', "O3' Trace", undefined, 1, 2);
            html += this.getRadio('mn3_nucl', 'mn3_nuclBackbone', 'Backbone', undefined, undefined, 2);
            html += this.getRadio('mn3_nucl', 'mn3_nuclSchematic', 'Schematic', undefined, 1, 2);
            html += this.getRadio('mn3_nucl', 'mn3_nuclLines', 'Lines', undefined, 1, 2);
            html += this.getRadio('mn3_nucl', 'mn3_nuclStick', 'Stick', undefined, 1, 2);
            html += this.getRadio('mn3_nucl', 'mn3_nuclBallstick', 'Ball and Stick', undefined, 1, 2);
            html += this.getRadio('mn3_nucl', 'mn3_nuclSphere', 'Sphere', undefined, 1, 2);
            html += this.getRadio('mn3_nucl', 'mn3_nuclNo', 'Hide', undefined, 1, 2);
            html += "</ul>";
            html += "</li>";

            html += this.getMenuText('mn3_ntbasewrap', 'Nucl. Bases', undefined, 1, 1);
            html += "<ul>";

            html += this.getRadio('mn3_ntbase', 'mn3_ntbaseLines', 'Lines', undefined, 1, 2);
            html += this.getRadio('mn3_ntbase', 'mn3_ntbaseStick', 'Stick', undefined, 1, 2);
            html += this.getRadio('mn3_ntbase', 'mn3_ntbaseBallstick', 'Ball and Stick', undefined, 1, 2);
            html += this.getRadio('mn3_ntbase', 'mn3_ntbaseSphere', 'Sphere', undefined, 1, 2);
            html += this.getRadio('mn3_ntbase', 'mn3_ntbaseNo', 'Hide', true, 1, 2);
            html += "</ul>";
            html += "</li>";
        }

        html += this.getMenuText('mn3_ligwrap', 'Chemicals', undefined, 1, 1);
        html += "<ul>";
        html += this.getRadio('mn3_lig', 'mn3_ligLines', 'Lines', undefined, 1, 2);
        if(me.cfg.cid === undefined) {
            html += this.getRadio('mn3_lig', 'mn3_ligStick', 'Stick', true, 1, 2);
            html += this.getRadio('mn3_lig', 'mn3_ligBallstick', 'Ball and Stick', undefined, 1, 2);
        }
        else {
            html += this.getRadio('mn3_lig', 'mn3_ligStick', 'Stick', undefined, 1, 2);
            html += this.getRadio('mn3_lig', 'mn3_ligBallstick', 'BalHydrogensl and Stick', true, 1, 2);
        }
        html += this.getRadio('mn3_lig', 'mn3_ligSchematic', 'Schematic', undefined, 1, 2);
        html += this.getRadio('mn3_lig', 'mn3_ligSphere', 'Sphere', undefined, 1, 2);
        html += this.getRadio('mn3_lig', 'mn3_ligNo', 'Hide', undefined, 1, 2);
        html += "</ul>";
        html += "</li>";

        //if(me.cfg.cid !== undefined) {
            html += this.getMenuText('mn3_hydrogenswrap', 'Hydrogens', undefined, 1, 1);
            html += "<ul>";
            html += this.getRadio('mn3_hydrogens', 'mn3_hydrogensYes', 'Show', true, 1, 2);
            html += this.getRadio('mn3_hydrogens', 'mn3_hydrogensNo', 'Hide', undefined, 1, 2);
            html += "</ul>";
            html += "</li>";
        //}

        if(me.cfg.cid === undefined) {
            html += this.getMenuText('mn3_glycanwrap', 'Glycans', undefined, undefined, 1);
            html += "<ul>";
            html += this.getRadio('mn3_glycansCart', 'mn3_glycansCartYes', 'Show Cartoon', undefined, undefined, 2);
            html += this.getRadio('mn3_glycansCart', 'mn3_glycansCartNo', 'Hide Cartoon', true, undefined, 2);
            html += "</ul>";
            html += "</li>";
        }

        html += this.getMenuText('mn3_ionswrap', 'Ions', undefined, 1, 1);
        html += "<ul>";
        html += this.getRadio('mn3_ions', 'mn3_ionsSphere', 'Sphere', true, 1, 2);
        html += this.getRadio('mn3_ions', 'mn3_ionsDot', 'Dot', undefined, 1, 2);
        html += this.getRadio('mn3_ions', 'mn3_ionsNo', 'Hide', undefined, 1, 2);
        html += "</ul>";
        html += "</li>";

        html += this.getMenuText('mn3_waterwrap', 'Water', undefined, 1, 1);
        html += "<ul>";
        html += this.getRadio('mn3_water', 'mn3_waterSphere', 'Sphere', undefined, 1, 2);
        html += this.getRadio('mn3_water', 'mn3_waterDot', 'Dot', undefined, 1, 2);
        html += this.getRadio('mn3_water', 'mn3_waterNo', 'Hide', true, 1, 2);
        html += "</ul>";
        html += "</li>";

        if(me.cfg.cid === undefined) {
            html += this.getMenuText('mn2_clashedwrap', 'Clashed Residues', undefined, undefined, 1);
            html += "<ul>";
            html += this.getRadio('mn2_clashed', 'mn2_clashedYes', 'Show', true, undefined, 2);
            html += this.getRadio('mn2_clashed', 'mn2_clashedNo', 'Hide', undefined, undefined, 2);
            html += "</ul>";
            html += "</li>";
        }

        html += this.getLink('mn3_setThickness', 'Preferences', undefined, 1);

        html += this.getMenuSep();
        html += this.getLink('mn3_styleSave', 'Save Style', undefined, 2);
        html += this.getLink('mn3_styleApplySave', 'Apply Saved Style', undefined, 2);

        html += this.getMenuSep();

        html += this.getMenuText('mn5_surfacewrap', 'Surface Type', undefined, 1, 1);
        html += "<ul>";
        html += this.getRadio('mn5_surface', 'mn5_surfaceVDW', 'Van der Waals', undefined, 1, 2);
        html += this.getRadio('mn5_surface', 'mn5_surfaceVDWContext', 'VDW with Context', undefined, undefined, 2);
        html += this.getRadio('mn5_surface', 'mn5_surfaceMolecular', 'Molecular Surface', undefined, 1, 2);
        html += this.getRadio('mn5_surface', 'mn5_surfaceMolecularContext', 'MS with Context', undefined, undefined, 2);
        html += this.getRadio('mn5_surface', 'mn5_surfaceSAS', 'Solvent Accessible', undefined, 1, 2);
        html += this.getRadio('mn5_surface', 'mn5_surfaceSASContext', 'SA with Context', undefined, undefined, 2);
        html += "</ul>";
        html += "</li>";

        html += this.getLink('mn5_surfaceNo', 'Remove Surface', 1, 1);

        html += this.getMenuText('mn5_surfaceop', 'Surface Opacity', undefined, 1, 1);
        html += "<ul>";

        html += this.getMenuText('mn5_surfaceopfast', 'Fast Transparency', undefined, 1, 2);
        html += "<ul>";
        html += this.getRadio('mn5_opacity', 'mn5_opacity10', '1.0', true, 1, 3);

        for(let i = 9; i > 0; --i) {
            html += this.getRadio('mn5_opacity', 'mn5_opacity0' + i, '0.' + i, 1, 3);
        }
        html += "</ul>";
        html += "</li>";

        html += this.getMenuText('mn5_surfaceopslow', 'Slow Transparency', undefined, undefined, 2);
        html += "<ul>";
        html += this.getRadio('mn5_opacityslow', 'mn5_opacityslow10', '1.0', true, undefined, 3);

        for(let i = 9; i > 0; --i) {
            html += this.getRadio('mn5_opacityslow', 'mn5_opacityslow0' + i, '0.' + i, undefined, undefined, 3);
        }
        html += "</ul>";
        html += "</li>";

        html += "</ul>"; // end of Surface Opacity

        html += this.getMenuText('mn5_wireframewrap', 'Surface Wireframe', undefined, 1, 1);
        html += "<ul>";
        html += this.getRadio('mn5_wireframe', 'mn5_wireframeYes', 'Yes', undefined, 1, 2);
        html += this.getRadio('mn5_wireframe', 'mn5_wireframeNo', 'No', true, 1, 2);
        html += "</ul>";
        html += "</li>";

        html += this.getMenuSep();

        html += this.getLink('mn5_cartoonshape', 'Cartoon for a Set', undefined, 1);
        html += this.getLink('mn5_linebtwsets', 'Line btw. Two Sets', undefined, 1);

        if(me.cfg.cid === undefined && me.cfg.align === undefined && me.cfg.chainalign === undefined && me.cfg.mmdbaf === undefined) {
            html += this.getMenuSep();

            html += this.getLinkWrapper2('mn5_map', 'Electron Density', 'mapWrapper1', undefined, 1);

            html += "<ul>";
            html += this.getLink('mn5_elecmap2fofc', '2Fo-Fc Map', undefined, 2);
            html += this.getLink('mn5_elecmapfofc', 'Fo-Fc Map', undefined, 2);
            html += this.getLinkWrapper('mn5_elecmapNo', 'Remove Map', 'mapWrapper2', undefined, 2);

            html += "</ul>";
            html += "</li>";

            html += this.getLinkWrapper2('mn5_map3', 'Map Wireframe', 'mapWrapper3', undefined, 1);
            
            html += "<ul>";
            html += this.getRadio('mn5_mapwireframe', 'mn5_mapwireframeYes', 'Yes', true, undefined, 2);
            html += this.getRadio('mn5_mapwireframe', 'mn5_mapwireframeNo', 'No', undefined, undefined, 2);
            html += "</ul>";
            html += "</li>";

            if(me.cfg.mmtfid === undefined) {
                html += this.getLinkWrapper('mn5_emmap', 'EM Density Map', 'emmapWrapper1', undefined, 1);
                html += this.getLinkWrapper('mn5_emmapNo', 'Remove EM Map', 'emmapWrapper2', undefined, 1);

                html += this.getLinkWrapper2('mn5_emmap3', 'EM Map Wireframe', 'emmapWrapper3', undefined, 1);
                html += "<ul>";
                html += this.getRadio('mn5_emmapwireframe', 'mn5_emmapwireframeYes', 'Yes', true, undefined, 2);
                html += this.getRadio('mn5_emmapwireframe', 'mn5_emmapwireframeNo', 'No', undefined, undefined, 2);
                html += "</ul>";
                html += "</li>";
            }
        }

        html += this.getMenuSep();

        html += this.getMenuText('mn6_bkgdwrap', 'Background', undefined, 1, 1);
        html += "<ul>";
        html += this.getRadio('mn6_bkgd', 'mn6_bkgdTransparent', 'Transparent', undefined, 1, 2);
        html += this.getRadio('mn6_bkgd', 'mn6_bkgdBlack', 'Black', true, 1, 2);
        html += this.getRadio('mn6_bkgd', 'mn6_bkgdGrey', 'Gray', undefined, 1, 2);
        html += this.getRadio('mn6_bkgd', 'mn6_bkgdWhite', 'White', undefined, 1, 2);
        html += "</ul>";
        html += "</li>";

        html += this.getMenuText('mn6_themewrap', 'Dialog Color', undefined, undefined, 1);
        html += "<ul>";
        html += this.getRadio('mn6_theme', 'mn6_themeBlue', 'Blue', true, undefined, 2);
        html += this.getRadio('mn6_theme', 'mn6_themeOrange', 'Orange', undefined, undefined, 2);
        html += this.getRadio('mn6_theme', 'mn6_themeBlack', 'Black', undefined, undefined, 2);
        html += "</ul>";
        html += "</li>";

        html += "<li><br/></li>";

        html += "</ul>";

        return html;
    }

    //Set the menu "Color" at the top of the viewer.
    setMenu4() { let me = this.icn3dui;
        if(me.bNode) return '';

        let html = "";

        html += "<div class='icn3d-menu'>";
        html += "<accordion id='" + me.pre + "accordion4' class='icn3d-accordion'>";
        html += "<h3 id='" + me.pre + "color'>Color</h3>";
        html += "<div>";

        html += this.setMenu4_base();

        html += "</div>";
        html += "</accordion>";
        html += "</div>";

        return html;
    }

    setMenu4_base() { let me = this.icn3dui;
        if(me.bNode) return '';

        let html = "";

        html += "<ul class='icn3d-mn-item'>";

        html += this.getMenuText('mn4_clrwrap', 'Unicolor', 'icn3d-menupd', 1, 1);
        html += "<ul>";

        html += this.getMenuText('uniclrRedwrap', 'Red', undefined, 1, 2);
        html += "<ul>";
        html += this.getRadClr('mn4_clr', 'uniclrRed1', 'Red', 'F00', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrRed2', 'Indian Red', 'CD5C5C', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrRed3', 'Light Coral', 'F08080', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrRed4', 'Salmon', 'FA8072', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrRed5', 'Dark Salmon', 'E9967A', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrRed6', 'Light Salmon', 'FFA07A', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrRed7', 'Crimson', 'DC143C', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrRed8', 'Fire Brick', 'B22222', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrRed9', 'Dark Red', '8B0000', undefined, 1, 3);
        html += "</ul>";

        html += this.getMenuText('uniclrPinkwrap', 'Pink', undefined, 1, 2);
        html += "<ul>";
        html += this.getRadClr('mn4_clr', 'uniclrPink1', 'Pink', 'FFC0CB', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrPink2', 'Light Pink', 'FFB6C1', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrPink3', 'Hot Pink', 'FF69B4', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrPink4', 'Deep Pink', 'FF1493', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrPink5', 'Medium Violet Red', 'C71585', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrPink6', 'Pale Violet Red', 'DB7093', undefined, 1, 3);
        html += "</ul>";

        html += this.getMenuText('uniclrOrangewrap', 'Orange', undefined, 1, 2);
        html += "<ul>";
        html += this.getRadClr('mn4_clr', 'uniclrOran1', 'Orange', 'FFA500', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrOran2', 'Dark Orange', 'FF8C00', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrOran3', 'Orange Red', 'FF4500', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrOran4', 'Tomato', 'FF6347', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrOran5', 'Coral', 'FF7F50', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrOran6', 'Light Salmon', 'FFA07A', undefined, 1, 3);
        html += "</ul>";

        html += this.getMenuText('uniclrYellowwrap', 'Yellow', undefined, 1, 2);
        html += "<ul>";
        html += this.getRadClr('mn4_clr', 'uniclrYllw1', 'Yellow', 'FF0', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrYllw2', 'Gold', 'FFD700', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrYllw3', 'Light Yellow', 'FFFFE0', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrYllw4', 'Lemon Chiffon', 'FFFACD', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrYllw5', 'Light Golden Rod', 'FAFAD2', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrYllw6', 'Papaya Whip', 'FFEFD5', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrYllw7', 'Moccasin', 'FFE4B5', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrYllw8', 'Peach Puff', 'FFDAB9', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrYllw9', 'Pale Golden Rod', 'EEE8AA', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrYllw10', 'Khaki', 'F0E68C', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrYllw11', 'Dark Khaki', 'BDB76B', undefined, 1, 3);
        html += "</ul>";

        html += this.getMenuText('uniclrMagentawrap', 'Magenta', undefined, 1, 2);
        html += "<ul>";
        html += this.getRadClr('mn4_clr', 'uniclrMgnt1', 'Magenta', 'F0F', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrMgnt2', 'Orchid', 'DA70D6', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrMgnt3', 'Violet', 'EE82EE', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrMgnt4', 'Plum', 'DDA0DD', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrMgnt5', 'Thistle', 'D8BFD8', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrMgnt6', 'Lavender', 'E6E6FA', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrMgnt7', 'Medium Orchid', 'BA55D3', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrMgnt8', 'Medium Purple', '9370DB', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrMgnt9', 'Rebecca Purple', '663399', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrMgnt10', 'Blue Violet', '8A2BE2', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrMgnt11', 'Dark Violet', '9400D3', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrMgnt12', 'Dark Orchid', '9932CC', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrMgnt13', 'Dark Magenta', '8B008B', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrMgnt14', 'Purple', '800080', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrMgnt15', 'Indigo', '4B0082', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrMgnt16', 'Slat Blue', '6A5ACD', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrMgnt17', 'Dark Slate Blue', '483D8B', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrMgnt18', 'Medium Slat Blue', '6A5ACD', undefined, 1, 3);
        html += "</ul>";

        html += this.getMenuText('uniclrGreenwrap', 'Green', undefined, 1, 2);
        html += "<ul>";
        html += this.getRadClr('mn4_clr', 'uniclrGrn1', 'Green', '0F0', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrGrn2', 'Dark Green', '006400', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrGrn3', 'Yellow Green', '9ACD32', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrGrn4', 'Olive Drab', '6B8E23', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrGrn5', 'Olive', '808000', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrGrn6', 'Dark Olive Green', '556B2F', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrGrn7', 'Medium Aquamarine', '66CDAA', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrGrn8', 'Dark Sea Green', '8FBC8B', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrGrn9', 'Lignt Sea Green', '20B2AA', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrGrn10', 'Dark Cyan', '008B8B', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrGrn11', 'Teal', '008080', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrGrn12', 'Forest Green', '228B22', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrGrn13', 'Sea Green', '2E8B57', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrGrn14', 'Medium Sea Green', '3CB371', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrGrn15', 'Spring Green', '00FF7F', undefined, 1, 3);
        //html += this.getRadClr('mn4_clr', 'uniclrGrn16', 'Medium Spring Green', '00FA9A', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrGrn16', 'Medium Spring', '00FA9A', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrGrn17', 'Light Green', '90EE90', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrGrn18', 'Pale Green', '98FB98', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrGrn19', 'Lime Green', '32CD32', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrGrn20', 'Lawn Green', '7CFC00', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrGrn21', 'Chartreuse', '7FFF00', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrGrn22', 'Green Yellow', 'ADFF2F', undefined, 1, 3);
        html += "</ul>";

        html += this.getMenuText('uniclrCyanwrap', 'Cyan', undefined, 1, 2);
        html += "<ul>";
        html += this.getRadClr('mn4_clr', 'uniclrCyan1', 'Cyan', '0FF', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrCyan2', 'Light Cyan', 'E0FFFF', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrCyan3', 'Pale Turquoise', 'AFEEEE', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrCyan4', 'Aquamarine', '7FFFD4', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrCyan5', 'Turquoise', '40E0D0', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrCyan6', 'Medium Turquoise', '48D1CC', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrCyan7', 'Dark Turquoise', '00CED1', undefined, 1, 3);
        html += "</ul>";

        html += this.getMenuText('uniclrBluewrap', 'Blue', undefined, 1, 2);
        html += "<ul>";
        html += this.getRadClr('mn4_clr', 'uniclrBlue1', 'Blue', '00F', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrBlue2', 'Medium Blue', '0000CD', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrBlue3', 'Dark Blue', '00008B', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrBlue4', 'Navy', '000080', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrBlue5', 'Midnight Blue', '191970', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrBlue6', 'Royal Blue', '4169E1', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrBlue7', 'Medium Slate Blue', '7B68EE', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrBlue8', 'Corn Flower Blue', '6495ED', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrBlue9', 'Dodger Blue', '1E90FF', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrBlue10', 'Deep Sky Blue', '00BFFF', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrBlue11', 'Light Sky Blue', '87CEFA', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrBlue12', 'Sky Blue', '87CEEB', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrBlue13', 'Light Blue', 'ADD8E6', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrBlue14', 'Powder Blue', 'B0E0E6', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrBlue15', 'Light Steel Blue', 'B0C4DE', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrBlue16', 'Steel Blue', '4682B4', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrBlue17', 'Cadet Blue', '5F9EA0', undefined, 1, 3);
        html += "</ul>";

        html += this.getMenuText('uniclrBrownwrap', 'Brown', undefined, 1, 2);
        html += "<ul>";
        html += this.getRadClr('mn4_clr', 'uniclrBrown1', 'Brown', 'A52A2A', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrBrown2', 'Maroon', '800000', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrBrown3', 'Sienna', 'A0522D', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrBrown4', 'Saddle Brown', '8B4513', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrBrown5', 'Chocolate', 'D2691E', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrBrown6', 'Peru', 'CD853F', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrBrown7', 'Dark Golden Rod', 'B8860B', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrBrown8', 'Golden Rod', 'DAA520', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrBrown9', 'Sandy Brown', 'F4A460', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrBrown10', 'Rosy Brown', 'BC8F8F', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrBrown11', 'Tan', 'D2B48C', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrBrown12', 'Burlywood', 'DEB887', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrBrown13', 'Wheat', 'F5DEB3', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrBrown14', 'Navajo White', 'FFDEAD', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrBrown15', 'Bisque', 'FFE4C4', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrBrown16', 'Blanched Almond', 'FFEBCD', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrBrown17', 'Corn Silk', 'FFF8DC', undefined, 1, 3);
        html += "</ul>";

        //html += "<li><span>White</span>";
        html += this.getMenuText('uniclrWhitewrap', 'White', undefined, 1, 2);
        html += "<ul>";
        html += this.getRadClr('mn4_clr', 'uniclrWhite1', 'White', 'FFF', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrWhite2', 'Snow', 'FFFAFA', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrWhite3', 'Honey Dew', 'F0FFF0', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrWhite4', 'Mint Cream', 'F5FFFA', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrWhite5', 'Azure', 'F0FFFF', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrWhite6', 'Alice Blue', 'F0F8FF', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrWhite7', 'Ghost White', 'F8F8FF', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrWhite8', 'White Smoke', 'F5F5F5', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrWhite9', 'Sea Shell', 'FFF5EE', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrWhite10', 'Beige', 'F5F5DC', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrWhite11', 'Old Lace', 'FDF5E6', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrWhite12', 'Floral White', 'FFFAF0', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrWhite13', 'Ivory', 'FFFFF0', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrWhite14', 'Antique White', 'FAEBD7', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrWhite15', 'Linen', 'FAF0E6', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrWhite16', 'Lavenderblush', 'FFF0F5', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrWhite17', 'Misty Rose', 'FFE4E1', undefined, 1, 3);
        html += "</ul>";

        html += this.getMenuText('uniclrGraywrap', 'Gray', undefined, 1, 2);
        html += "<ul>";
        html += this.getRadClr('mn4_clr', 'uniclrGray1', 'Gray', '808080', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrGray2', 'Dim Gray', '696969', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrGray3', 'Light Slate Gray', '778899', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrGray4', 'Slate Gray', '708090', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrGray5', 'Dark Slate Gray', '2F4F4F', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrGray6', 'Black', '000000', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrGray7', 'Dark Gray', 'A9A9A9', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrGray8', 'Silver', 'C0C0C0', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrGray9', 'Light Gray', 'D3D3D3', undefined, 1, 3);
        html += this.getRadClr('mn4_clr', 'uniclrGray10', 'Gainsboro', 'DCDCDC', undefined, 1, 3);
        html += "</ul>";

        html += "</ul>";

        html += this.getRadio('mn4_clr', 'mn4_clrCustom', 'Color Picker', undefined, undefined, 1);
        html += this.getMenuSep();

        if(me.cfg.cid === undefined) {
            html += this.getMenuText('mn4_clrRainbowwrap', 'Rainbow (R-V)', 'icn3d-menupd', 1, 1);
            html += "<ul>";
            html += this.getRadio('mn4_clr', 'mn4_clrRainbow', 'for Selection', undefined, 1, 2);
            html += this.getRadio('mn4_clr', 'mn4_clrRainbowChain', 'for Chains', undefined, 1, 2);
            html += this.getRadio('mn4_clr', 'mn4_clrRainbowSets', 'for Sets', undefined, undefined, 2);
            html += this.getRadio('mn4_clr', 'mn4_clrRainbowAcrossSets', 'across Sets', undefined, undefined, 2);
            html += "</ul>";

            html += this.getMenuText('mn4_clrSpectrumwrap', 'Spectrum (V-R)', 'icn3d-menupd', 1, 1);
            html += "<ul>";
            html += this.getRadio('mn4_clr', 'mn4_clrSpectrum', 'for Selection', undefined, 1, 2);
            html += this.getRadio('mn4_clr', 'mn4_clrSpectrumChain', 'for Chains', undefined, 1, 2);
            html += this.getRadio('mn4_clr', 'mn4_clrSpectrumSets', 'for Sets', undefined, undefined, 2);
            html += this.getRadio('mn4_clr', 'mn4_clrSpectrumAcrossSets', 'across Sets', undefined, undefined, 2);
            html += "</ul>";

            html += this.getMenuText('mn4_clrSSwrap', 'Secondary', 'icn3d-menupd', 1, 1);
            html += "<ul>";
            html += this.getRadio('mn4_clr', 'mn4_clrSSGreen', 'Sheet in Green', undefined, 1, 2);
            html += this.getRadio('mn4_clr', 'mn4_clrSSYellow', 'Sheet in Yellow', undefined, 1, 2);
            html += this.getRadio('mn4_clr', 'mn4_clrSSSpectrum', 'Spectrum', undefined, undefined, 2);
            html += "</ul>";

            html += this.getRadio('mn4_clr', 'mn4_clrCharge', 'Charge', undefined, 1, 1);

            html += this.getMenuText('mn4_hydrophobicwrap', 'Hydrophobicity', 'icn3d-menupd', 1, 1);
            html += "<ul>";
            html += this.getRadio('mn4_clr', 'mn4_clrNormalizedHP', 'Normalized', undefined, 1, 2);
            html += this.getRadio('mn4_clr', 'mn4_clrHydrophobic', 'Wimley-White', undefined, undefined, 2);
            html += "</ul>";

            html += this.getMenuText('mn4_clrBfactorwrap', 'B-factor', 'icn3d-menupd', 1, 1);
            html += "<ul>";
            html += this.getRadio('mn4_clr', 'mn4_clrBfactor', 'Original', undefined, 1, 2);
            html += this.getRadio('mn4_clr', 'mn4_clrBfactorNorm', 'Percentile', undefined, 1, 2);
            html += "</ul>";

            html += this.getRadio('mn4_clr', 'mn4_clrArea', 'Solvent<br><span style="padding-left:1.5em;">Accessibility</span>', undefined, undefined, 1);

            html += this.getRadio('mn4_clr', 'mn4_clrStructure', 'Structure', undefined, 1, 1);

            if(me.cfg.align !== undefined || me.cfg.chainalign !== undefined || me.cfg.blast_rep_id !== undefined) {
                html += this.getRadio('mn4_clr', 'mn4_clrChain', 'Chain', undefined, 1, 1);
            }
            else {
                html += this.getRadio('mn4_clr', 'mn4_clrChain', 'Chain', true, 1, 1);
            }

            //if(me.cfg.mmdbid !== undefined || me.cfg.gi !== undefined) {
              html += this.getRadio('mn4_clr', 'mn4_clrdomain', '3D Domain', undefined, undefined, 1);
            //}

            if(me.cfg.cid === undefined) {
                html += this.getMenuText('mn4_clrsetswrap', 'Defined Sets', 'icn3d-menupd', undefined, 1);
                html += "<ul>";
                html += this.getRadio('mn4_clr', 'mn4_clrsets', 'Rainbow for Selected Sets<br><span style="padding-left:1.5em;">in "Analysis > Defined Sets"</span>', undefined, undefined, 2);
                html += "</ul>";
                html += "</li>";
            }

            html += this.getMenuText('mn4_clrResiduewrap', 'Residue', 'icn3d-menupd', 1, 1);
            html += "<ul>";
            html += this.getRadio('mn4_clr', 'mn4_clrResidue', 'Default', undefined, 1, 2);
            html += this.getRadio('mn4_clr', 'mn4_clrResidueCustom', 'Custom', undefined, undefined, 2);
            html += "</ul>";

            html += this.getRadio('mn4_clr', 'mn4_clrAtom', 'Atom', undefined, 1, 1);

            if(me.cfg.align !== undefined || me.cfg.chainalign !== undefined) {
              html += this.getRadio('mn4_clr', 'mn4_clrIdentity', 'Identity', true, undefined, 2);
              html += this.getRadio('mn4_clr', 'mn4_clrConserved', 'Conservation', undefined, undefined, 2);
            }
            else if(me.cfg.blast_rep_id !== undefined) {
              html += this.getRadio('mn4_clr', 'mn4_clrIdentity', 'Identity', undefined, undefined, 2);
              html += this.getRadio('mn4_clr', 'mn4_clrConserved', 'Conservation', true, undefined, 2);
            }
            else {
              html += this.getRadio('mn4_clr', 'mn4_clrIdentity', 'Identity', undefined, undefined, 2);
              html += this.getRadio('mn4_clr', 'mn4_clrConserved', 'Conservation', undefined, undefined, 2);
            }

            //if(me.cfg.afid) html += this.getRadio('mn4_clr', 'mn4_clrConfidence', 'AF Confidence');
            //if(!me.cfg.mmtfid && !me.cfg.pdbid && !me.cfg.opmid && !me.cfg.mmdbid && !me.cfg.gi && !me.cfg.uniprotid && !me.cfg.blast_rep_id && !me.cfg.cid && !me.cfg.mmcifid && !me.cfg.align && !me.cfg.chainalign) {
                html += this.getRadio('mn4_clr', 'mn4_clrConfidence', 'pLDDT', undefined, 1, 1);
            //}

            html += this.getRadio('mn4_clr', 'mn4_clrIgstrand', 'Ig Strand', undefined, undefined, 2);
            html += this.getRadio('mn4_clr', 'mn4_clrIgproto', 'Ig Protodomain', undefined, undefined, 2);
        }
        else {
            //if(!me.cfg.hidelicense) html += this.getRadio('mn4_clr', 'mn1_delphi2', 'DelPhi<br><span style="padding-left:1.5em;">Potential ' + me.htmlCls.licenseStr + '</span>');
            html += this.getRadio('mn4_clr', 'mn4_clrAtom', 'Atom', true, 1, 1);
        }

        html += this.getMenuSep();

        html += this.getLink('mn4_clrSave', 'Save Color', undefined, 1);
        html += this.getLink('mn4_clrApplySave', 'Apply Saved Color', undefined, 1);

        html += "<li><br/></li>";
        html += "</ul>";

        return html;
    }

    //Set the menu "Surface" at the top of the viewer.
    setMenu5() { let me = this.icn3dui;
        if(me.bNode) return '';

        let html = "";

        html += "<div class='icn3d-menu'>";
        html += "<accordion id='" + me.pre + "accordion5' class='icn3d-accordion'>";
        html += "<h3 id='" + me.pre + "analysis' style='font-size:1.2em'>&nbsp;Analysis</h3>";
        html += "<div>";

        html += this.setMenu5_base();

        html += "</div>";
        html += "</accordion>";
        html += "</div>";

        return html;
    }

    setMenu5_base() { let me = this.icn3dui;
        if(me.bNode) return '';

        let html = "";

        html += "<ul class='icn3d-mn-item'>";

        if(me.cfg.cid !== undefined || me.cfg.smiles !== undefined) {
            html += this.getLink('mn2_2ddepiction', '2D Depiction ' + me.htmlCls.wifiStr, 1, 1);
        }

        if(me.cfg.cid === undefined) {
            html += this.getLink('mn6_selectannotations', 'Seq. & Annotations ' + me.htmlCls.wifiStr, 1, 1);

            //if(me.cfg.align !== undefined || me.cfg.chainalign !== undefined) { // || ic.bRealign || ic.bSymd || ic.bInputfile) {
                html += this.getLink('mn2_alignment', 'Aligned Seq. ' + me.htmlCls.wifiStr, undefined, 1);
            //}

            if(me.cfg.mmdbid !== undefined || me.cfg.gi !== undefined || me.cfg.blast_rep_id !== undefined || me.cfg.align !== undefined || me.cfg.chainalign !== undefined) {
              html += this.getLink('mn2_2ddgm', '2D Diagram ' + me.htmlCls.wifiStr, 1, 1);
            }

            html += this.getMenuText('2dctnwrap', '2D Cartoon', undefined, undefined, 1);
            html += "<ul>";
            html += this.getLink('2dctn_chain', 'Chain Level', undefined, 2);
            html += this.getLink('2dctn_domain', 'Domain Level', undefined, 2);
            html += this.getLink('2dctn_secondary', 'Helix/Sheet Level', undefined, 2);
            html += "</ul>";
            html += "</li>";

            html += this.getLink('definedsets2', 'Defined Sets', 1, 1);

            html += this.getMenuSep();

            html += this.getLink('mn6_hbondsYes', 'Interactions', 1, 1);

            html += this.getMenuText('mn1_window', 'Bring to Front', undefined, undefined, 1);
            html += "<ul>";
            html += this.getLink('mn1_window_table', 'Interaction Table', undefined, 2);
            html += this.getLink('mn1_window_linegraph', '2D Interaction Network', undefined, 2);
            html += this.getLink('mn1_window_scatterplot', '2D Interaction Map', undefined, 2);
            html += this.getLink('mn1_window_graph', '2D Graph(Force-Directed)', undefined, 2);
            html += "</ul>";
            html += "</li>";

            html += this.getLink('mn6_contactmap', 'Contact Map', undefined, 1);

            //if(!me.cfg.notebook) {
                html += this.getLink('mn1_mutation', 'Mutation ' + me.htmlCls.wifiStr, 1, 1);
            //}

            //html += this.getMenuSep();
        }

        //if(!me.cfg.notebook && !me.cfg.hidelicense) {
        if(!me.cfg.hidelicense) {
            html += this.getMenuText('mn1_delphiwrap', 'DelPhi Potential', undefined, 1, 1);

            html += "<ul>";       
                html += this.getLink('mn1_delphi', 'DelPhi Potential ' + me.htmlCls.licenseStr, 1, 2);    

                html += this.getMenuText('mn1_phiwrap', 'Load PQR/Phi', undefined, undefined, 2);
                html += "<ul>";
                html += this.getLink('mn1_phi', 'Local PQR/Phi/Cube File', undefined, 3);
                html += this.getLink('mn1_phiurl', 'URL PQR/Phi/Cube File', undefined, 3);
                html += "</ul>";
                html += "</li>";
                html += this.getLink('delphipqr', 'Download PQR', undefined, 2);
            html += "</ul>";
            html += "</li>";

            //html += this.getMenuSep();
        }

        html += this.getMenuSep();

        html += this.getMenuText('mn6_distancewrap', 'Distance', undefined, 1, 1);
        html += "<ul>";
        html += this.getRadio('mn6_distance', 'mn6_distanceYes', 'between Two Atoms', undefined, 1, 2);
        html += this.getRadio('mn6_distance', 'mn6_distTwoSets', 'between Two Sets', undefined, undefined, 2);
        html += this.getRadio('mn6_distance', 'mn6_distManySets', 'among Many Sets', undefined, undefined, 2);
        html += this.getRadio('mn6_distance', 'mn6_distanceNo', 'Hide', true, 1, 2);
        html += "</ul>";
        html += "</li>";

        html += this.getMenuText('mn6_anglewrap', 'Angle', undefined, 1, 1);
        html += "<ul>";
        html += this.getRadio('mn6_angle', 'mn6_angleManySets', 'among Many Sets', undefined, 1, 2);
        html += this.getRadio('mn6_angle', 'mn6_angleTwoSets', 'b/w Two Vectors', undefined, undefined, 2);
        html += "</ul>";
        html += "</li>";

        html += this.getLink('mn6_area', 'Surface Area', 1, 1);

        html += this.getMenuText('mn6_addlabelwrap', 'Label', undefined, 1, 1);
        html += "<ul>";
        html += this.getRadio('mn6_addlabel', 'mn6_addlabelYes', 'by Picking Atoms', undefined, undefined, 2);
        html += this.getRadio('mn6_addlabel', 'mn6_addlabelSelection', 'per Selection', undefined, undefined, 2);
        html += this.getRadio('mn6_addlabel', 'mn6_addlabelAtoms', 'per Atom', undefined, undefined, 2);
        html += this.getRadio('mn6_addlabel', 'mn6_addlabelElements', 'per Atom Element', undefined, 1, 2);
        if(me.cfg.cid === undefined) {
            html += this.getRadio('mn6_addlabel', 'mn6_addlabelResidues', 'per Residue', undefined, 1, 2);
            html += this.getRadio('mn6_addlabel', 'mn6_addlabelResnum', 'per Residue & Number', undefined, 1, 2);

            html += this.getRadio('mn6_addlabel', 'mn6_addlabelRefnum', 'per Reference Number', undefined, 1, 2);
            html += this.getRadio('mn6_addlabel', 'mn6_addlabelIg', 'per Ig Domain', undefined, 1, 2);

            html += this.getRadio('mn6_addlabel', 'mn6_addlabelChains', 'per Chain', undefined, undefined, 2);
            html += this.getRadio('mn6_addlabel', 'mn6_addlabelTermini', 'N- & C-Termini', undefined, 1, 2);
        }

        html += this.getMenuSep();
        html += this.getRadio('mn6_addlabel', 'mn6_labelColor', 'Change Label Color', undefined, 1, 2);
        html += this.getRadio('mn6_addlabel', 'mn6_addlabelNo', 'Remove', true, 1, 2);
        html += "</ul>";
        html += "</li>";

        html += this.getMenuText('labelscalewrap', 'Label Scale', undefined, 1, 1);
        html += "<ul>";

        for(let i = 1; i <= 4; ++i) {
            let twoi = 2 * i;
            html += this.getRadio('mn6_labelscale', 'mn6_labelscale0' + twoi, '0.' + twoi, undefined, 1, 2);
        }

        for(let i = 2; i <= 10; ++i) {
            let value = (i / 2.0).toFixed(1);

            if(i == 2) {
                html += this.getRadio('mn6_labelscale', 'mn6_labelscale' + i + '0', value, true, 1, 2);
            }
            else {
                html += this.getRadio('mn6_labelscale', 'mn6_labelscale' + i + '0', value, undefined, 1, 2);
            }
        }

        html += "</ul>";
        html += "</li>";

        html += this.getMenuSep();

        if(me.cfg.cid === undefined) {
            html += this.getMenuText('mn6_chemicalbindingwrap', 'Chem. Binding', undefined, undefined, 1);
            html += "<ul>";
            html += this.getRadio('mn6_chemicalbinding', 'mn6_chemicalbindingshow', 'Show', undefined, undefined, 2);
            html += this.getRadio('mn6_chemicalbinding', 'mn6_chemicalbindinghide', 'Hide', true, undefined, 2);
            html += "</ul>";
            html += "</li>";

            html += this.getMenuText('mn6_ssbondswrap', 'Disulfide Bonds', undefined, 1, 1);
            html += "<ul>";
            html += this.getRadio('mn6_ssbonds', 'mn6_ssbondsYes', 'Show', true, 1, 2);
            html += this.getRadio('mn6_ssbonds', 'mn6_ssbondsExport', 'Export Pairs', undefined, undefined, 2);
            html += this.getRadio('mn6_ssbonds', 'mn6_ssbondsNo', 'Hide', undefined, 1, 2);
            html += "</ul>";
            html += "</li>";

            html += this.getMenuText('mn6_clbondswrap', 'Cross-Linkages', undefined, undefined, 1);
            html += "<ul>";
            html += this.getRadio('mn6_clbonds', 'mn6_clbondsYes', 'Show', true, undefined, 2);
            html += this.getRadio('mn6_clbonds', 'mn6_clbondsExport', 'Export Pairs', undefined, undefined, 2);
            html += this.getRadio('mn6_clbonds', 'mn6_clbondsNo', 'Hide', undefined, undefined, 2);
            html += "</ul>";
            html += "</li>";

            html += this.getLink('mn6_DSSP', 'DSSP Secondary', undefined, 1);

            let bOnePdb = me.cfg.mmtfid !== undefined || me.cfg.pdbid !== undefined || me.cfg.opmid !== undefined || me.cfg.mmcifid !== undefined || me.cfg.mmdbid !== undefined || me.cfg.mmdbafid !== undefined || me.cfg.gi !== undefined || me.cfg.blast_rep_id !== undefined;

            if(bOnePdb) {
              html += this.getMenuText('assemblyWrapper', 'Assembly', undefined, 1, 1);
              html += "<ul>";

              if(!me.cfg.bu) {
                html += this.getRadio('mn6_assembly', 'mn6_assemblyYes', 'Biological Assembly', undefined, 1, 2);
                html += this.getRadio('mn6_assembly', 'mn6_assemblyNo', 'Asymmetric Unit', true, 1, 2);
              }
              else {
                html += this.getRadio('mn6_assembly', 'mn6_assemblyYes', 'Biological Assembly', true, 1, 2);
                html += this.getRadio('mn6_assembly', 'mn6_assemblyNo', 'Asymmetric Unit', undefined, 1, 2);
              }

              html += "</ul>";
              html += "</li>";
            }

            html += this.getMenuText('mn6_symmetrywrap', 'Symmetry', undefined, undefined, 1);

            html += "<ul>";
            if(bOnePdb) html += this.getLink('mn6_symmetry', 'from PDB(precalculated) ' + me.htmlCls.wifiStr, undefined, 2);

            html += this.getLink('mn6_symd', 'from SymD(Dynamic) ' + me.htmlCls.wifiStr, undefined, 2);
            html += this.getLink('mn6_clear_sym', 'Clear SymD Symmetry', undefined, 2);
            html += this.getLink('mn6_axes_only', 'Show Axes Only', undefined, 2);

            html += "</ul>";
            html += "</li>";

            html += this.getMenuText('mn6_igrefwrap', 'Ref. Number', undefined, undefined, 1);

            html += "<ul>";

            html += this.getLink('mn6_igrefYes', 'Show Ig for Selection', undefined, 2);
            html += this.getLink('mn6_igrefTpl', 'Ig w/ Specified Template', undefined, 2);
            html += this.getLink('mn6_alignrefTpl', 'Align w/ Specified Template', undefined, 2);
            html += this.getLink('mn6_igrefNo', 'Reset Ig Ref. Number', undefined, 2);

            html += this.getMenuSep();

            html += this.getLink('mn6_customref', 'Custom Ref. Number', undefined, 2);
            html += "</ul>";
            html += "</li>";

            html += this.getMenuSep();
        }

        html += this.getLink('mn6_yournote', 'Window Title', undefined, 1);

        if(me.cfg.cid !== undefined) {
            html += this.getMenuText('mn1_linkwrap', 'Links', undefined, undefined, 1);
            
            html += "<ul>";
            html += this.getLink('mn1_link_structure', 'Compound Summary ' + me.htmlCls.wifiStr, undefined, 2);
            html += this.getLink('mn1_link_vast', 'Similar Compounds ' + me.htmlCls.wifiStr, undefined, 2);
            html += this.getLink('mn1_link_bind', 'Structures Bound ' + me.htmlCls.wifiStr, undefined, 2);
            html += "</ul>";
            html += "</li>";
        }
        else {
            html += this.getMenuText('mn1_linkwrap', 'Links', undefined, undefined, 1);
            html += "<ul>";
            html += this.getLink('mn1_link_structure', 'Structure Summary ' + me.htmlCls.wifiStr, undefined, 2);
            html += this.getLink('mn1_link_vast', 'Similar Structures ' + me.htmlCls.wifiStr, undefined, 2);
            html += this.getLink('mn1_link_pubmed', 'Literature ' + me.htmlCls.wifiStr, undefined, 2);
            html += this.getLink('mn1_link_protein', 'Protein ' + me.htmlCls.wifiStr, undefined, 2);
            //html += this.getLink('mn1_link_gene', 'Gene');
            //html += this.getLink('mn1_link_chemicals', 'Chemicals');
            html += "</ul>";
            html += "</li>";
        }

        html += "<li><br/></li>";

        html += "</ul>";

        return html;
    }

    //Set the menu "Other" at the top of the viewer.
    setMenu6() { let me = this.icn3dui;
        if(me.bNode) return '';

        let html = "";

        html += "<div class='icn3d-menu'>";
        html += "<accordion id='" + me.pre + "accordion6' class='icn3d-accordion'>";
        html += "<h3>Help</h3>";
        html += "<div>";

        html += this.setMenu6_base();

        html += "</div>";
        html += "</accordion>";
        html += "</div>";

        return html;
    }

    setMenu6_base() { let me = this.icn3dui;
        if(me.bNode) return '';

        let html = "";

        html += "<ul class='icn3d-mn-item'>";

        html += this.getMenuUrl('abouticn3d', me.htmlCls.baseUrl + "icn3d/icn3d.html#about", "About iCn3D<span style='font-size:0.9em'> " + me.REVISION + "</span>", 1, 1);

        html += this.getMenuUrl('gallery', me.htmlCls.baseUrl + "icn3d/icn3d.html#gallery", "Live Gallery " + me.htmlCls.wifiStr, 1, 1);
        html += this.getMenuUrl('video', me.htmlCls.baseUrl + "icn3d/icn3d.html#videos", "Videos & Tutorials", 1, 1);

        html += this.getMenuText('mn6_faq', 'FAQ', undefined, 1, 1);

        html += "<ul>";
        html += this.getMenuUrl('faq_viewstru', me.htmlCls.baseUrl + "icn3d/icn3d.html#viewstru", "View structure", 1, 2);
        html += this.getMenuUrl('faq_tfstru', me.htmlCls.baseUrl + "icn3d/icn3d.html#tfstru", "Transform Structure", 1, 2);
        html += this.getMenuUrl('faq_selsubset', me.htmlCls.baseUrl + "icn3d/icn3d.html#selsubset", "Select Subsets", 1, 2);
        html += this.getMenuUrl('faq_stylecolor', me.htmlCls.baseUrl + "icn3d/icn3d.html#changestylecolor", "Change Style/Color", 1, 2);
        html += this.getMenuUrl('faq_savework', me.htmlCls.baseUrl + "icn3d/icn3d.html#saveview", "Save Work", 1, 2);
        html += this.getMenuUrl('faq_showanno', me.htmlCls.baseUrl + "icn3d/icn3d.html#showanno", "Show Annotations", 1, 2);
        html += this.getMenuUrl('faq_exportanno', me.htmlCls.baseUrl + "icn3d/icn3d.html#exportanno", "Export Annotations", 1, 2);
        html += this.getMenuUrl('faq_interanal', me.htmlCls.baseUrl + "icn3d/icn3d.html#interanalysis", "Interaction Analysis", 1, 2);
        html += this.getMenuUrl('faq_mutanal', me.htmlCls.baseUrl + "icn3d/icn3d.html#mutationanalysis", "Mutation Analysis", 1, 2);
        html += this.getMenuUrl('faq_elecpot', me.htmlCls.baseUrl + "icn3d/icn3d.html#elecpot", "Electrostatic Pot.", 1, 2);
        html += this.getMenuUrl('faq_simipdb', me.htmlCls.baseUrl + "icn3d/icn3d.html#simivast", "Similar PDB", 1, 2);
        html += this.getMenuUrl('faq_simialphapdb', me.htmlCls.baseUrl + "icn3d/icn3d.html#simifoldseek", "Similar AlphaFold/PDB", 1, 2);
        html += this.getMenuUrl('faq_alnstru', me.htmlCls.baseUrl + "icn3d/icn3d.html#alignmul", "Align Multiple Structures", 1, 2);
        html += this.getMenuUrl('faq_batchanal', me.htmlCls.baseUrl + "icn3d/icn3d.html#batchanalysis", "Batch Analysis", 1, 2);
        html += this.getMenuUrl('faq_batchanal', me.htmlCls.baseUrl + "icn3d/icn3d.html#igrefnum", "Assign Ig Ref. Numbers", 1, 2);
        html += this.getMenuUrl('faq_embedicn3d', me.htmlCls.baseUrl + "icn3d/icn3d.html#embedicn3d", "Embed iCn3D", 1, 2);
        html += "</ul>";
        html += "</li>";

        //html += liStr + "https://www.ncbi.nlm.nih.gov/structure' target='_blank'>Search Structure " + me.htmlCls.wifiStr + "</a></li>";
        //html += liStr + me.htmlCls.baseUrl + "icn3d/icn3d.html#citing' target='_blank'>Citing iCn3D</a></li>";
        html += this.getMenuUrl('citing', me.htmlCls.baseUrl + "icn3d/icn3d.html#citing", "Citing iCn3D", undefined, 1);

        html += this.getMenuText('mn6_source', 'Source Code', undefined, 1, 1);
        html += "<ul>";
        html += this.getMenuUrl('github', "https://github.com/ncbi/icn3d", "GitHub (browser) " + me.htmlCls.wifiStr, 1, 2);
        html += this.getMenuUrl('npm', "https://www.npmjs.com/package/icn3d", "npm (Node.js) " + me.htmlCls.wifiStr, 1, 2);
        html += this.getMenuUrl('notebook', "https://pypi.org/project/icn3dpy", "Jupyter Notebook " + me.htmlCls.wifiStr, 1, 2);
        html += "</ul>";
        html += "</li>";

        html += this.getMenuText('mn6_develop', 'Develop', undefined, undefined, 1);
        html += "<ul>";
        html += this.getMenuUrl('dev_embedicn3d2', me.htmlCls.baseUrl + "icn3d/icn3d.html#HowToUse", "Embed iCn3D", undefined, 2);
        html += this.getMenuUrl('dev_urlpara', me.htmlCls.baseUrl + "icn3d/icn3d.html#parameters", "URL Parameters", undefined, 2);
        html += this.getMenuUrl('dev_command', me.htmlCls.baseUrl + "icn3d/icn3d.html#commands", "Commands", undefined, 2);

        html += this.getMenuUrl('dev_datastru', me.htmlCls.baseUrl + "icn3d/icn3d.html#datastructure", "Data Structure", undefined, 2);
        html += this.getMenuUrl('dev_classstru', me.htmlCls.baseUrl + "icn3d/icn3d.html#classstructure", "Class Structure", undefined, 2);
        html += this.getMenuUrl('dev_addclass', me.htmlCls.baseUrl + "icn3d/icn3d.html#addclass", "Add New Classes", undefined, 2);
        html += this.getMenuUrl('dev_modfunc', me.htmlCls.baseUrl + "icn3d/icn3d.html#modifyfunction", "Modify Functions", undefined, 2);
        html += this.getMenuUrl('dev_restful', me.htmlCls.baseUrl + "icn3d/icn3d.html#restfulapi", "RESTful APIs", undefined, 2);
        html += this.getMenuUrl('dev_contributor', me.htmlCls.baseUrl + "icn3d/icn3d.html#contributors", "iCn3D Contributors", undefined, 2);
        html += "</ul>";
        html += "</li>";

        html += this.getMenuUrl('helpdoc', me.htmlCls.baseUrl + "icn3d/docs/icn3d_help.html", "Help Doc " + me.htmlCls.wifiStr, 1, 1);

        html += this.getMenuSep();

        html += this.getMenuText('mn6_tfhint', 'Transform Hints', undefined, 1, 1);
        html += "<ul>";
        html += this.getMenuText('mn6_rotate', 'Rotate', undefined, 1, 2);
        html += "<ul>";
        html += "<li>Left Mouse (Click & Drag)</li>";
        html += "<li>Key l: Left</li>";
        html += "<li>Key j: Right</li>";
        html += "<li>Key i: Up</li>";
        html += "<li>Key m: Down</li>";
        html += "<li>Shift + Key l: Left 90&deg;</li>";
        html += "<li>Shift + Key j: Right 90&deg;</li>";
        html += "<li>Shift + Key i: Up 90&deg;</li>";
        html += "<li>Shift + Key m: Down 90&deg;</li>";
        html += "</ul>";
        html += "</li>";
        html += this.getMenuText('mn6_zoom', 'Zoom', undefined, 1, 2);
        html += "<ul>";
        html += "<li>Middle Mouse <br>(Pinch & Spread)</li>";
        html += "<li>Key z: Zoom in</li>";
        html += "<li>Key x: Zoom out</li>";
        html += "</ul>";
        html += "</li>";
        html += this.getMenuText('mn6_translate', 'Translate', undefined, 1, 2);
        html += "<ul>";
        html += "<li>Right Mouse <br>(Two Finger Click & Drag)</li>";
        html += "</ul>";
        html += "</li>";
        html += "</ul>";
        html += "</li>";

        html += this.getMenuUrl('selhints', me.htmlCls.baseUrl + "icn3d/icn3d.html#selsubset", "Selection Hints", undefined, 1);
        html += this.getMenuUrl('helpdesk', "https://support.nlm.nih.gov/support/create-case/", "Write to Help Desk", 1, 1);

        html += "<li><br/></li>";
        html += "</ul>";

        return html;
    }

    //Hide the menu at the top and just show the canvas. "width" and "height" are the width and height of the canvas.
    hideMenu() { let me = this.icn3dui;
      if(me.bNode) return;

      if($("#" + me.pre + "mnlist")[0] !== undefined) $("#" + me.pre + "mnlist")[0].style.display = "none";
      if($("#" + me.pre + "mnLogSection")[0] !== undefined) $("#" + me.pre + "mnLogSection")[0].style.display = "none";
      if($("#" + me.pre + "cmdlog")[0] !== undefined) $("#" + me.pre + "cmdlog")[0].style.display = "none";
      $("#" + me.pre + "title")[0].style.margin = "10px 0 0 10px";
    }

    //Show the menu at the top and the canvas. "width" and "height" are the width and height of the canvas.
    showMenu() { let me = this.icn3dui;
      if(me.bNode) return;

      if($("#" + me.pre + "mnlist")[0] !== undefined) $("#" + me.pre + "mnlist")[0].style.display = "block";
      if($("#" + me.pre + "mnLogSection")[0] !== undefined) $("#" + me.pre + "mnLogSection")[0].style.display = "block";
      if($("#" + me.pre + "cmdlog")[0] !== undefined) $("#" + me.pre + "cmdlog")[0].style.display = "block";
      //if($("#" + me.pre + "title")[0] !== undefined) $("#" + me.pre + "title")[0].style.display = "block";
    }
}

/**
 * @author Jiyao Wang <wangjiy@ncbi.nlm.nih.gov> / https://github.com/ncbi/icn3d
 */

class Dialog {
    constructor(icn3dui) {
        this.icn3dui = icn3dui;
    }

    //Open a dialog to input parameters. "id" is the id of the div section holding the html content.
    //"title" is the title of the dialog. The dialog can be out of the viewing area.
    openDlg(id, title) {  let me = this.icn3dui; me.icn3d;
        if(me.bNode) return;

        id = me.pre + id;

        if(!me.cfg.notebook) {
            this.openDlgRegular(id, title);
        }
        else {
            this.openDlgNotebook(id, title);
        }

        if(!me.htmlCls.themecolor) me.htmlCls.themecolor = 'blue';

        me.htmlCls.setMenuCls.setTheme(me.htmlCls.themecolor);
    }

    addSaveButton(id) {  let me = this.icn3dui; me.icn3d;
        if(me.bNode) return;

        // adda save button
        if(this.dialogHashSave === undefined || !this.dialogHashSave.hasOwnProperty(id)) {
            $("#" + id).parent().children('.ui-dialog-titlebar')
            .append("<div pid='" + id + "' class='icn3d-saveicon ui-icon ui-icon-disk' title='Save as an HTML file' style='background-color:white; background-image: url(&quot;https://www.ncbi.nlm.nih.gov/Structure/icn3d/lib/images/ui-icons_228ef1_256x240.png&quot;);'></div>");

            if(this.dialogHashSave === undefined) this.dialogHashSave = {};
            this.dialogHashSave[id] = 1;
        }
    }

    addHideButton(id) {  let me = this.icn3dui; me.icn3d;
        if(me.bNode) return;

        // adda save button
        if(this.dialogHashHide === undefined || !this.dialogHashHide.hasOwnProperty(id)) {
            $("#" + id).parent().children('.ui-dialog-titlebar')
            .append("<div pid='" + id + "' class='icn3d-hideicon ui-icon ui-icon-arrowthick-2-ne-sw' title='Resize the window' style='background-color:white; background-image: url(&quot;https://www.ncbi.nlm.nih.gov/Structure/icn3d/lib/images/ui-icons_228ef1_256x240.png&quot;);'></div>");

            if(this.dialogHashHide === undefined) this.dialogHashHide = {};
            this.dialogHashHide[id] = 1;
        }
    }

    getDialogStatus() {  let me = this.icn3dui; me.icn3d;
        if(me.bNode) return;

        let status = {};
        let id2flag = {};

        // determine whether dialogs initilaized
        let bSelectannotationsInit = $('#' + me.pre + 'dl_selectannotations').hasClass('ui-dialog-content'); // initialized
        let bGraph = $('#' + me.pre + 'dl_graph').hasClass('ui-dialog-content'); // initialized
        let bLineGraph = $('#' + me.pre + 'dl_linegraph').hasClass('ui-dialog-content'); // initialized
        let bScatterplot = $('#' + me.pre + 'dl_scatterplot').hasClass('ui-dialog-content'); // initialized
        let bLigplot = $('#' + me.pre + 'dl_ligplot').hasClass('ui-dialog-content'); // initialized
        let bContactmap = $('#' + me.pre + 'dl_contactmap').hasClass('ui-dialog-content'); // initialized
        let bAlignerrormap = $('#' + me.pre + 'dl_alignerrormap').hasClass('ui-dialog-content'); // initialized
        let bTable = $('#' + me.pre + 'dl_interactionsorted').hasClass('ui-dialog-content'); // initialized
        let bAlignmentInit = $('#' + me.pre + 'dl_alignment').hasClass('ui-dialog-content'); // initialized
        let bTwoddgmInit = $('#' + me.pre + 'dl_2ddgm').hasClass('ui-dialog-content'); // initialized
        let bTwodctnInit = $('#' + me.pre + 'dl_2dctn').hasClass('ui-dialog-content'); // initialized
        let bSetsInit = $('#' + me.pre + 'dl_definedsets').hasClass('ui-dialog-content'); // initialized

        status.bSelectannotationsInit2 = false, status.bGraph2 = false, status.bLineGraph2 = false;
        status.bScatterplot2 = false, status.bLigplot2 = false, status.bTable2 = false, status.bAlignmentInit2 = false;
        status.bTwoddgmInit2 = false, status.bTwodctnInit2 = false, status.bSetsInit2 = false;

        id2flag.dl_selectannotations = 'bSelectannotationsInit2';
        id2flag.dl_graph = 'bGraph2';
        id2flag.dl_linegraph = 'bLineGraph2';
        id2flag.dl_scatterplot = 'bScatterplot2';
        id2flag.dl_ligplot = 'bLigplot2';	
        id2flag.dl_contactmap = 'bContactmap2';
        id2flag.dl_alignerrormap = 'bAlignerrormap2';
        id2flag.dl_interactionsorted = 'bTable2';
        id2flag.dl_alignment = 'bAlignmentInit2';
        id2flag.dl_2ddgm = 'bTwoddgmInit2';
        id2flag.dl_2dctn = 'bTwodctnInit2';
        id2flag.dl_definedsets = 'bSetsInit2';

        if(bSelectannotationsInit) status.bSelectannotationsInit2 = $('#' + me.pre + 'dl_selectannotations').dialog( 'isOpen' );
        if(bGraph) status.bGraph2 = $('#' + me.pre + 'dl_graph').dialog( 'isOpen' );
        if(bLineGraph) status.bLineGraph2 = $('#' + me.pre + 'dl_linegraph').dialog( 'isOpen' );
        if(bScatterplot) status.bScatterplot2 = $('#' + me.pre + 'dl_scatterplot').dialog( 'isOpen' );
        if(bLigplot) status.bLigplot2 = $('#' + me.pre + 'dl_ligplot').dialog( 'isOpen' );
        if(bContactmap) status.bContactmap2 = $('#' + me.pre + 'dl_contactmap').dialog( 'isOpen' );
        if(bAlignerrormap) status.bAlignerror2 = $('#' + me.pre + 'dl_alignerrormap').dialog( 'isOpen' );
        if(bTable) status.bTable2 = $('#' + me.pre + 'dl_interactionsorted').dialog( 'isOpen' );
        if(bAlignmentInit) status.bAlignmentInit2 = $('#' + me.pre + 'dl_alignment').dialog( 'isOpen' );
        if(bTwoddgmInit) status.bTwoddgmInit2 = $('#' + me.pre + 'dl_2ddgm').dialog( 'isOpen' );
        if(bTwodctnInit) status.bTwodctnInit2 = $('#' + me.pre + 'dl_2dctn').dialog( 'isOpen' );
        if(bSetsInit) status.bSetsInit2 = $('#' + me.pre + 'dl_definedsets').dialog( 'isOpen' );

        return {status: status, id2flag: id2flag};
    }

    openDlgHalfWindow(id, title, dialogWidth, bForceResize) {  let me = this.icn3dui, ic = me.icn3d;
        if(me.bNode) return;

        let thisClass = this;

        let twoddgmWidth = me.htmlCls.width2d + 20;

        //ic.resizeCanvasCls.resizeCanvas(me.htmlCls.WIDTH - dialogWidth - me.htmlCls.LESSWIDTH, me.htmlCls.HEIGHT - me.htmlCls.LESSHEIGHT - me.htmlCls.EXTRAHEIGHT, bForceResize);
        ic.resizeCanvasCls.resizeCanvas(me.htmlCls.WIDTH - dialogWidth, me.htmlCls.HEIGHT, bForceResize);

        //height = me.htmlCls.HEIGHT - me.htmlCls.LESSHEIGHT - me.htmlCls.EXTRAHEIGHT;
        let height = me.htmlCls.HEIGHT;
        let width = dialogWidth;

        let position;
        if(me.cfg.showmenu && !me.utilsCls.isMobile() && !me.cfg.mobilemenu) {
            position ={ my: "left top", at: "right top+40", of: "#" + me.pre + "viewer", collision: "none" };
        }
        else {
            position ={ my: "left top", at: "right top", of: "#" + me.pre + "viewer", collision: "none" };
        }

        // disable resize
        me.cfg.resize = false;

        window.dialog = $( "#" + id ).dialog({
          autoOpen: true,
          title: title,
          height: height,
          width: width,
          modal: false,
          position: position,
          close: function(e) {
              let result = thisClass.getDialogStatus();
              let status = result.status;
              let id2flag = result.id2flag;

              // check the condition when all the rest dialogs are closed
              let bCheckAll = false;
              for(let idname in id2flag) {
                let bCheckRest = (id === me.pre + idname);
                for(let idstatus in status) {
                    // just check the rest, not itself
                    if(status.hasOwnProperty(idstatus)) continue;
                    bCheckRest = bCheckRest && !status[idstatus];
                }
                bCheckAll = bCheckAll || bCheckRest;
              }

              if(bCheckAll) {
                  if(status.bTwoddgmInit2 || status.bTwodctnInit2 || status.bSetsInit2) {
                      //ic.resizeCanvasCls.resizeCanvas(me.htmlCls.WIDTH - me.htmlCls.LESSWIDTH - twoddgmWidth, me.htmlCls.HEIGHT - me.htmlCls.LESSHEIGHT - me.htmlCls.EXTRAHEIGHT, true);
                      let canvasWidth = me.utilsCls.isMobile() ? me.htmlCls.WIDTH : me.htmlCls.WIDTH - twoddgmWidth;
                      ic.resizeCanvasCls.resizeCanvas(canvasWidth, me.htmlCls.HEIGHT, true);

                      if(status.bTwoddgmInit2) thisClass.openDlg2Ddgm(me.pre + 'dl_2ddgm', undefined, status.bSetsInit2);
                      if(status.bTwodctnInit2) thisClass.openDlg2Ddgm(me.pre + 'dl_2dctn', undefined, status.bSetsInit2);
                      if(status.bSetsInit2) thisClass.openDlg2Ddgm(me.pre + 'dl_definedsets');
                  }
                  else {
                      //ic.resizeCanvasCls.resizeCanvas(me.htmlCls.WIDTH - me.htmlCls.LESSWIDTH, me.htmlCls.HEIGHT - me.htmlCls.LESSHEIGHT - me.htmlCls.EXTRAHEIGHT, true);
                      ic.resizeCanvasCls.resizeCanvas(me.htmlCls.WIDTH, me.htmlCls.HEIGHT, true);
                  }
              }
          },
          resize: function(e) {
              if(id == me.pre + 'dl_selectannotations') {
                  ic.annotationCls.hideFixedTitle();
              }
              else if(id == me.pre + 'dl_graph') {
                  let width = $("#" + id).width();
                  let height = $("#" + id).height();

                  d3.select("#" + me.svgid).attr("width", width).attr("height", height);
              }
              else if(id == me.pre + 'dl_linegraph' || id == me.pre + 'dl_scatterplot' || id == me.pre + 'dl_ligplot' || id == me.pre + 'dl_contactmap' || id == me.pre + 'dl_alignerrormap') {
                  let oriWidth =(status.bTwoddgmInit2 || status.bSetsInit2) ?(me.htmlCls.WIDTH - twoddgmWidth)/2 : me.htmlCls.WIDTH / 2;
                  let ratio = $("#" + id).width() / oriWidth;

                  if(id == me.pre + 'dl_linegraph') {
                      let width = ic.linegraphWidth * ratio;
                      $("#" + me.linegraphid).attr("width", width);
                  }
                  else if(id == me.pre + 'dl_scatterplot') {
                      let width = ic.scatterplotWidth * ratio;
                      $("#" + me.scatterplotid).attr("width", width);
                  }
                  else if(id == me.pre + 'dl_ligplot') {
                    let width = ic.ligplotWidth * ratio;
                    $("#" + me.ligplotid).attr("width", width);
                  }
                  else if(id == me.pre + 'dl_ligplot') {
                    let width = ic.ligplotWidth * ratio;
                    $("#" + me.ligplotid).attr("width", width);
                }
                  else if(id == me.pre + 'dl_contactmap') {
                      let width = ic.contactmapWidth * ratio;
                      $("#" + me.contactmapid).attr("width", width);
                  }
                  else if(id == me.pre + 'dl_alignerrormap') {
                    let width = ic.alignerrormapWidth * ratio;
                    $("#" + me.alignerrormapid).attr("width", width);
                }
              }
          }
        });

        this.addSaveButton(id);
        this.addHideButton(id);
    }

    openDlg2Ddgm(id, inHeight, bDefinedSets) {  let me = this.icn3dui, ic = me.icn3d;
        if(me.bNode) return;

        let thisClass = this;

        let twoddgmWidth = me.htmlCls.width2d + 20;
        let at, title;
        if(id === me.pre + 'dl_definedsets') {
            at = "right top";
            title = 'Select sets';
        }
        else if(id === me.pre + 'dl_2ddgm' || id === me.pre + 'dl_2dctn') {
            if(bDefinedSets) {
                at = "right top+240";
            }
            else {
                at = "right top";
            }

            title = (id === me.pre + 'dl_2ddgm') ? '2D Diagram' : '2D Cartoon';
        }

        //var position ={ my: "left top", at: at, of: "#" + me.pre + "canvas", collision: "none" }
        let position ={ my: "left top+" + me.htmlCls.MENU_HEIGHT, at: at, of: "#" + me.pre + "viewer", collision: "none" };

        let height = 'auto';

        window.dialog = $( '#' + id ).dialog({
          autoOpen: true,
          title: title,
          height: height,
          width: twoddgmWidth,
          modal: false,
          position: position,
          close: function(e) {
              let status = thisClass.getDialogStatus().status;

              if((!status.bSelectannotationsInit2) &&(!status.bGraph2) &&(!status.bLineGraph2) &&(!status.bScatterplot2) &&(!status.bLigplot2) &&(!status.bTable2) &&(!status.bAlignmentInit2) ) {
                    //ic.resizeCanvasCls.resizeCanvas(me.htmlCls.WIDTH - me.htmlCls.LESSWIDTH, me.htmlCls.HEIGHT - me.htmlCls.LESSHEIGHT - me.htmlCls.EXTRAHEIGHT, true);
                    ic.resizeCanvasCls.resizeCanvas(me.htmlCls.WIDTH, me.htmlCls.HEIGHT, true);
              }
          },
          resize: function(e, ui) {
              if(id == me.pre + 'dl_2dctn') {
                ic.resizeRatioX = ui.size.width / me.htmlCls.width2d; //ui.originalSize.width;
                ic.resizeRatioY = ui.size.height / (me.htmlCls.width2d + 70); //ui.originalSize.height;
              }
          },
          resizeStop: function(e, ui) {
            ic.resizeRatioX = ui.size.width / me.htmlCls.width2d; //ui.originalSize.width;
            ic.resizeRatioY = ui.size.height / (me.htmlCls.width2d + 70); //ui.originalSize.height;
          }
        });

        this.addSaveButton(id);
        this.addHideButton(id);
    }

    openDlgRegular(id, title) {  let me = this.icn3dui, ic = me.icn3d;
        if(me.bNode) return;

        let width = 400, height = 150;
        let twoddgmWidth = me.htmlCls.width2d + 20;

        let status = this.getDialogStatus().status;

        if(id === me.pre + 'dl_selectannotations' || id === me.pre + 'dl_graph' || id === me.pre + 'dl_linegraph' || id === me.pre + 'dl_scatterplot' || id === me.pre + 'dl_ligplot' || id === me.pre + 'dl_contactmap'  || id === me.pre + 'dl_alignerrormap' || id === me.pre + 'dl_interactionsorted' || id === me.pre + 'dl_alignment') {
            //var dialogWidth = 0.5 *(me.htmlCls.WIDTH - me.htmlCls.LESSWIDTH) - twoddgmWidth * 0.5;
            let dialogWidth = 0.5 *(me.htmlCls.WIDTH) - twoddgmWidth * 0.5;

            //if(me.htmlCls.WIDTH - me.htmlCls.LESSWIDTH >= me.htmlCls.HEIGHT - me.htmlCls.LESSHEIGHT - me.htmlCls.EXTRAHEIGHT) {
            if(me.htmlCls.WIDTH >= me.htmlCls.HEIGHT) {
                this.openDlgHalfWindow(id, title, dialogWidth, true);

                if(status.bTwoddgmInit2 || status.bTwodctnInit2 || status.bSetsInit2) {
                    ic.resizeCanvasCls.resizeCanvas(me.htmlCls.WIDTH - dialogWidth - twoddgmWidth, me.htmlCls.HEIGHT, true);

                    if(status.bTwoddgmInit2) this.openDlg2Ddgm(me.pre + 'dl_2ddgm', undefined, status.bSetsInit2);
                    if(status.bTwodctnInit2) this.openDlg2Ddgm(me.pre + 'dl_2dctn', undefined, status.bSetsInit2);
                    if(status.bSetsInit2) this.openDlg2Ddgm(me.pre + 'dl_definedsets');
                }
            }
            else {
                //ic.resizeCanvasCls.resizeCanvas(me.htmlCls.WIDTH - me.htmlCls.LESSWIDTH,(me.htmlCls.HEIGHT - me.htmlCls.LESSHEIGHT - me.htmlCls.EXTRAHEIGHT) * 0.5, true);
                ic.resizeCanvasCls.resizeCanvas(me.htmlCls.WIDTH,(me.htmlCls.HEIGHT) * 0.5, true);

                //height =(me.htmlCls.HEIGHT - me.htmlCls.LESSHEIGHT - me.htmlCls.EXTRAHEIGHT) * 0.5;
                height =(me.htmlCls.HEIGHT) * 0.5;

                //width = me.htmlCls.WIDTH - me.htmlCls.LESSWIDTH;
                width = me.htmlCls.WIDTH;

                let position ={ my: "left top", at: "left bottom+32", of: "#" + me.pre + "canvas", collision: "none" };

                window.dialog = $( "#" + id ).dialog({
                  autoOpen: true,
                  title: title,
                  height: height,
                  width: width,
                  modal: false,
                  position: position,
                  close: function(e) {
                      if((id === me.pre + 'dl_selectannotations' &&(!status.bAlignmentInit2) &&(!status.bGraph2) &&(!status.bTable2) &&(!status.bLineGraph2) &&(!status.bScatterplot2) &&(!status.bLigplot2) &&(!status.bContactmap2) &&(!status.bAlignerrormap2))
                        ||(id === me.pre + 'dl_graph' &&(!status.bSelectannotationsInit2) &&(!status.bAlignmentInit2) &&(!status.bTable2) &&(!status.bLineGraph2) &&(!status.bScatterplot2) &&(!status.bLigplot2) &&(!status.bContactmap2) &&(!status.bAlignerrormap2))
                        ||(id === me.pre + 'dl_alignment' &&(!status.bSelectannotationsInit2) &&(!status.bGraph2) &&(!status.bTable2) &&(!status.bLineGraph2) &&(!status.bScatterplot2) &&(!status.bLigplot2) &&(!status.bContactmap2) &&(!status.bAlignerrormap2))
                        ||(id === me.pre + 'dl_interactionsorted' &&(!status.bSelectannotationsInit2) &&(!status.bGraph2) &&(!status.bAlignmentInit2) &&(!status.bLineGraph2) &&(!status.bScatterplot2) &&(!status.bLigplot2) &&(!status.bContactmap2) &&(!status.bAlignerrormap2))
                        ||(id === me.pre + 'dl_linegraph' &&(!status.bSelectannotationsInit2) &&(!status.bGraph2) &&(!status.bAlignmentInit2) &&(!status.bTable2) &&(!status.bScatterplot2) &&(!status.bLigplot2) &&(!status.bContactmap2) &&(!status.bAlignerrormap2))
                        ||(id === me.pre + 'dl_scatterplot' &&(!status.bSelectannotationsInit2) &&(!status.bGraph2) &&(!status.bAlignmentInit2) &&(!status.bTable2) &&(!status.bLineGraph2) &&(!status.bLigplot2) &&(!status.bContactmap2) &&(!status.bAlignerrormap2))
                        ||(id === me.pre + 'dl_ligplot' &&(!status.bSelectannotationsInit2) &&(!status.bGraph2) &&(!status.bAlignmentInit2) &&(!status.bTable2) &&(!status.bLineGraph2) &&(!status.bScatterplot2) &&(!status.bContactmap2) &&(!status.bAlignerrormap2))
                        ||(id === me.pre + 'dl_contactmap' &&(!status.bSelectannotationsInit2) &&(!status.bGraph2) &&(!status.bAlignmentInit2) &&(!status.bTable2) &&(!status.bLineGraph2) &&(!status.bScatterplot2) &&(!status.bLigplot2) &&(!status.bAlignerrormap2))
                        ||(id === me.pre + 'dl_alignerrormap' &&(!status.bSelectannotationsInit2) &&(!status.bGraph2) &&(!status.bAlignmentInit2) &&(!status.bTable2) &&(!status.bLineGraph2) &&(!status.bScatterplot2) &&(!status.bLigplot2) &&(!status.bContactmap2))
                        ) {
                          if(status.bTwoddgmInit2 || status.bTwodctnInit2 || status.bSetsInit2) {
                              let canvasWidth = me.utilsCls.isMobile() ? me.htmlCls.WIDTH : me.htmlCls.WIDTH - twoddgmWidth;
                              ic.resizeCanvasCls.resizeCanvas(canvasWidth, me.htmlCls.HEIGHT, true);

                              if(status.bTwoddgmInit2) thisClass.openDlg2Ddgm(me.pre + 'dl_2ddgm', undefined, status.bSetsInit2);
                              if(status.bTwodctnInit2) thisClass.openDlg2Ddgm(me.pre + 'dl_2dctn', undefined, status.bSetsInit2);
                              if(status.bSetsInit2) thisClass.openDlg2Ddgm(me.pre + 'dl_definedsets');
                          }
                          else {
                              //ic.resizeCanvasCls.resizeCanvas(me.htmlCls.WIDTH - me.htmlCls.LESSWIDTH, me.htmlCls.HEIGHT - me.htmlCls.LESSHEIGHT - me.htmlCls.EXTRAHEIGHT, true);
                              ic.resizeCanvasCls.resizeCanvas(me.htmlCls.WIDTH, me.htmlCls.HEIGHT, true);
                          }
                      }
                  },
                  resize: function(e) {
                      if(id == me.pre + 'dl_selectannotations') {
                          ic.annotationCls.hideFixedTitle();
                      }
                      else if(id == me.pre + 'dl_graph') {
                          let width = $("#" + id).width();
                          let height = $("#" + id).height();

                          d3.select("#" + me.svgid).attr("width", width).attr("height", height);
                      }
                      else if(id == me.pre + 'dl_linegraph' || id == me.pre + 'dl_scatterplot' || id == me.pre + 'dl_ligplot' || id == me.pre + 'dl_contactmap' || id == me.pre + 'dl_alignerrormap') {
                          let oriWidth =(status.bTwoddgmInit2 || status.bSetsInit2) ?(me.htmlCls.WIDTH - twoddgmWidth)/2 : me.htmlCls.WIDTH / 2;
                          let ratio = $("#" + id).width() / oriWidth;

                          if(id == me.pre + 'dl_linegraph') {
                              let width = ic.linegraphWidth * ratio;
                              $("#" + me.linegraphid).attr("width", width);
                          }
                          else if(id == me.pre + 'dl_scatterplot') {
                              let width = ic.scatterplotWidth * ratio;
                              $("#" + me.scatterplotid).attr("width", width);
                          }
                          else if(id == me.pre + 'dl_ligplot') {
                            let width = ic.ligplotWidth * ratio;
                            $("#" + me.ligplotid).attr("width", width);
                        }
                          else if(id == me.pre + 'dl_contactmap') {
                              let width = ic.contactmapWidth * ratio;
                              $("#" + me.contactmapid).attr("width", width);
                          }
                          else if(id == me.pre + 'dl_alignerrormap') {
                            let width = ic.alignerrormapWidth * ratio;
                            $("#" + me.alignerrormapid).attr("width", width);
                        }
                      }
                  }
                });

                this.addSaveButton(id);
                this.addHideButton(id);
            }
        }
        else if(id === me.pre + 'dl_2ddgm' || id === me.pre + 'dl_2dctn') {
            let tmpWidth = 0;

            //if(me.htmlCls.WIDTH - me.htmlCls.LESSWIDTH >= me.htmlCls.HEIGHT - me.htmlCls.LESSHEIGHT - me.htmlCls.EXTRAHEIGHT) {
            if(me.htmlCls.WIDTH >= me.htmlCls.HEIGHT) {
                if(status.bSelectannotationsInit2 || status.bGraph2 || status.bLineGraph2 || status.bScatterplot2 || status.bLigplot2 || status.bTable2 || status.bAlignmentInit2) {
                    //tmpWidth = 0.5 *(me.htmlCls.WIDTH - me.htmlCls.LESSWIDTH) - twoddgmWidth * 0.5;
                    tmpWidth = 0.5 *(me.htmlCls.WIDTH) - twoddgmWidth * 0.5;
                }
                //ic.resizeCanvasCls.resizeCanvas(me.htmlCls.WIDTH - me.htmlCls.LESSWIDTH - tmpWidth - twoddgmWidth, me.htmlCls.HEIGHT - me.htmlCls.LESSHEIGHT - me.htmlCls.EXTRAHEIGHT, true);
                ic.resizeCanvasCls.resizeCanvas(me.htmlCls.WIDTH - tmpWidth - twoddgmWidth, me.htmlCls.HEIGHT, true);

                this.openDlg2Ddgm(id, undefined, status.bSetsInit2);
            }
            else {
                //ic.resizeCanvasCls.resizeCanvas(me.htmlCls.WIDTH - me.htmlCls.LESSWIDTH - tmpWidth - twoddgmWidth,(me.htmlCls.HEIGHT - me.htmlCls.LESSHEIGHT - me.htmlCls.EXTRAHEIGHT)*0.5, true);
                let canvasWidth = me.utilsCls.isMobile() ? me.htmlCls.WIDTH : me.htmlCls.WIDTH - twoddgmWidth;
                ic.resizeCanvasCls.resizeCanvas(canvasWidth,(me.htmlCls.HEIGHT)*0.5, true);
                //this.openDlg2Ddgm(id,(me.htmlCls.HEIGHT - me.htmlCls.LESSHEIGHT - me.htmlCls.EXTRAHEIGHT)*0.5);
                this.openDlg2Ddgm(id,(me.htmlCls.HEIGHT)*0.5);

                //this.openDlg2Ddgm(id,(me.htmlCls.HEIGHT - me.htmlCls.LESSHEIGHT - me.htmlCls.EXTRAHEIGHT)*0.5, bSetsInit2);
                this.openDlg2Ddgm(id,(me.htmlCls.HEIGHT)*0.5, status.bSetsInit2);
            }
        }
        else {
            height = 'auto';
            width = 'auto';

            if(id === me.pre + 'dl_addtrack') {
                width='50%';
            }
            else if(id === me.pre + 'dl_menupref') {
                width = 800;
                height = 500;
            }
            
            let position;

            if(id === me.pre + 'dl_definedsets') {
                let tmpWidth = 0;

                //if(me.htmlCls.WIDTH - me.htmlCls.LESSWIDTH >= me.htmlCls.HEIGHT - me.htmlCls.LESSHEIGHT - me.htmlCls.EXTRAHEIGHT) {
                if(me.htmlCls.WIDTH >= me.htmlCls.HEIGHT) {
                    if(status.bSelectannotationsInit2 || status.bGraph2 || status.bLineGraph2 || status.bScatterplot2 || status.bLigplot2 || status.bTable2 || status.bAlignmentInit2) {
                        //tmpWidth = 0.5 *(me.htmlCls.WIDTH - me.htmlCls.LESSWIDTH) - twoddgmWidth * 0.5;
                        tmpWidth = 0.5 *(me.htmlCls.WIDTH) - twoddgmWidth * 0.5;
                    }
                    //ic.resizeCanvasCls.resizeCanvas(me.htmlCls.WIDTH - me.htmlCls.LESSWIDTH - tmpWidth - twoddgmWidth, me.htmlCls.HEIGHT - me.htmlCls.LESSHEIGHT - me.htmlCls.EXTRAHEIGHT, true);
                    ic.resizeCanvasCls.resizeCanvas(me.htmlCls.WIDTH - tmpWidth - twoddgmWidth, me.htmlCls.HEIGHT, true);
                    this.openDlg2Ddgm(id);

                    if(status.bTwoddgmInit2) this.openDlg2Ddgm(me.pre + 'dl_2ddgm', undefined, true);
                    if(status.bTwodctnInit2) this.openDlg2Ddgm(me.pre + 'dl_2dctn', undefined, true);
                }
                else {
                    //ic.resizeCanvasCls.resizeCanvas(me.htmlCls.WIDTH - me.htmlCls.LESSWIDTH - tmpWidth - twoddgmWidth,(me.htmlCls.HEIGHT - me.htmlCls.LESSHEIGHT - me.htmlCls.EXTRAHEIGHT)*0.5, true);
                    let canvasWidth = me.utilsCls.isMobile() ? me.htmlCls.WIDTH : me.htmlCls.WIDTH - twoddgmWidth;
                    ic.resizeCanvasCls.resizeCanvas(canvasWidth,(me.htmlCls.HEIGHT)*0.5, true);
                    //this.openDlg2Ddgm(id,(me.htmlCls.HEIGHT - me.htmlCls.LESSHEIGHT - me.htmlCls.EXTRAHEIGHT)*0.5);
                    this.openDlg2Ddgm(id,(me.htmlCls.HEIGHT)*0.5);

                    //if(bTwoddgmInit2) this.openDlg2Ddgm(me.pre + 'dl_2ddgm',(me.htmlCls.HEIGHT - me.htmlCls.LESSHEIGHT - me.htmlCls.EXTRAHEIGHT)*0.5, true);
                    if(status.bTwoddgmInit2) this.openDlg2Ddgm(me.pre + 'dl_2ddgm',(me.htmlCls.HEIGHT)*0.5, true);
                    if(status.bTwodctnInit2) this.openDlg2Ddgm(me.pre + 'dl_2dctn',(me.htmlCls.HEIGHT)*0.5, true);
                }
            }
            else {
                if(me.utilsCls.isMobile()) {
                    position ={ my: "left top", at: "left bottom-50", of: "#" + me.pre + "canvas", collision: "none" };
                }
                else if(id === me.pre + 'dl_allinteraction' || id === me.pre + 'dl_buriedarea') {
                    //position ={ my: "right top", at: "right top+50", of: "#" + me.pre + "dl_selectannotations", collision: "none" }
                    position ={ my: "right top", at: "right top+50", of: "#" + ic.divid, collision: "none" };

                    width = 700;
                    height = 500;
                }
                else if(id === me.pre + 'dl_rmsd') {
                    position ={ my: "left bottom", at: "left+20 bottom-20", of: "#" + me.pre + "canvas", collision: "none" };
                }
                else if(id === me.pre + 'dl_legend') {
                    position ={ my: "left bottom", at: "left+20 bottom-20", of: "#" + me.pre + "canvas", collision: "none" };
                }
                else if(id === me.pre + 'dl_symd') {
                    position ={ my: "left top", at: "right-200 bottom-200", of: "#" + me.pre + "canvas", collision: "none" };
                }
                else {
                    if(me.cfg.align) {
                        position ={ my: "left top", at: "left top+90", of: "#" + me.pre + "canvas", collision: "none" };
                    }
                    else if(id === me.pre + 'dl_mmdbafid') {
                        position ={ my: "left top", at: "left top+130", of: "#" + me.pre + "canvas", collision: "none" };
                    }
                    else {
                        position ={ my: "left top", at: "left top+50", of: "#" + me.pre + "canvas", collision: "none" };
                    }
                }

                window.dialog = $( "#" + id ).dialog({
                  autoOpen: true,
                  title: title,
                  height: height,
                  width: width,
                  modal: false,
                  position: position
                });

                this.addSaveButton(id);
                this.addHideButton(id);
            }
        }

        $(".ui-dialog .ui-button span")
          .removeClass("ui-icon-closethick")
          .addClass("ui-icon-close");
    }

    openDlgNotebook(id, title) {  let me = this.icn3dui, ic = me.icn3d;
        if(me.bNode) return;

        let width = 400, height = 150;
        let twoddgmWidth = me.htmlCls.width2d + 20;

        if(id === me.pre + 'dl_selectannotations' || id === me.pre + 'dl_graph' || id === me.pre + 'dl_linegraph' || id === me.pre + 'dl_scatterplot' || id === me.pre + 'dl_ligplot' || id === me.pre + 'dl_contactmap'  || id === me.pre + 'dl_alignerrormap' || id === me.pre + 'dl_interactionsorted' || id === me.pre + 'dl_alignment') {
            $( "#" + id ).show();
            $( "#" + id + "_nb").show();
            $( "#" + id + "_title").html(title);

            height =(me.htmlCls.HEIGHT) * 0.5;

            width = me.htmlCls.WIDTH;

            $( "#" + id ).width(width);
            $( "#" + id ).height(height);

            $( "#" + id ).resize(function(e) {
                  let oriWidth = me.htmlCls.WIDTH / 2;
                  let ratio = $("#" + id).width() / oriWidth;

                  if(id == me.pre + 'dl_selectannotations') {
                      ic.annotationCls.hideFixedTitle();
                  }
                  else if(id == me.pre + 'dl_graph') {
                      let width = $("#" + id).width();
                      let height = $("#" + id).height();

                      d3.select("#" + me.svgid).attr("width", width).attr("height", height);
                  }
                  else if(id == me.pre + 'dl_linegraph') {
                      let width = ic.linegraphWidth * ratio;

                      $("#" + me.linegraphid).attr("width", width);
                  }
                  else if(id == me.pre + 'dl_scatterplot') {
                      let width = ic.scatterplotWidth * ratio;

                      $("#" + me.scatterplotid).attr("width", width);
                  }
                  else if(id == me.pre + 'dl_ligplot') {
                    let width = ic.ligplotWidth * ratio;

                    $("#" + me.ligplotid).attr("width", width);
                  }
                  else if(id == me.pre + 'dl_contactmap') {
                      let width = ic.contactmapWidth * ratio;

                      $("#" + me.contactmapid).attr("width", width);
                  }
                  else if(id == me.pre + 'dl_alignerrormap') {
                    let width = ic.alignerrormapWidth * ratio;

                    $("#" + me.alignerrormapid).attr("width", width);
                }
            });
        }
        else {
            if(ic.bRender) {
                $( "#" + id ).show();
                $( "#" + id + "_nb").show();
                $( "#" + id + "_title").html(title);
            }

            height = 'auto';
            width = 'auto';

            if(id === me.pre + 'dl_addtrack') {
                width='50%';
            }
            else if(id === me.pre + 'dl_2ddgm' || id === me.pre + 'dl_2dctn' || id === me.pre + 'dl_definedsets') {
                width=twoddgmWidth;
            }
            else if(id === me.pre + 'dl_allinteraction' || id === me.pre + 'dl_buriedarea') {
                width = 700;
                height = 500;
            }

            $( "#" + id ).width(width);
            $( "#" + id ).height(height);
        }
    }
}

/**
 * @author Jiyao Wang <wangjiy@ncbi.nlm.nih.gov> / https://github.com/ncbi/icn3d
 */

class SetDialog {
    constructor(icn3dui) {
        this.icn3dui = icn3dui;
    }

    //A placeholder for all custom dialogs.
    setCustomDialogs() { let me = this.icn3dui; me.icn3d;
        if(me.bNode) return '';

        let html = "";
        return html;
    }

    getHtmlAlignResidueByResidue(chainids, predefinedid, buttonid) { let me = this.icn3dui; me.icn3d;
        let html = '';

        html += "All chains will be aligned to the first chain in the comma-separated chain IDs. Each chain ID has the form of PDBID_chain (e.g., 1HHO_A, case sensitive) or UniprotID (e.g., P69905 for AlphaFold structures).<br/><br/>";
        html += "<b>Chain IDs</b>: " + me.htmlCls.inputTextStr + "id='" + me.pre + chainids + "' value='P69905,P01942,1HHO_A' size=50><br/><br/>";
        
        html += "Each alignment is defined as \" | \"-separated residue lists in one line. \"10-50\" means a range of residues from 10 to 50.<br><textarea id='" + me.pre + predefinedid + "' rows='5' style='width: 100%; height: " +(me.htmlCls.LOG_HEIGHT) + "px; padding: 0px; border: 0px;'>1,5,10-50 | 1,5,10-50\n2,6,11-51 | 1,5,10-50</textarea><br/>";
        html += me.htmlCls.buttonStr + buttonid + "'><b>Align Residue by Residue</b></button><br/>";
        return html;
    }

    addNotebookTitle(id, title, bAddExtraDiv) { let me = this.icn3dui; me.icn3d;
        //return '<div id="' + me.pre + id + '_nb" style="display:none; background-color:#1c94c4; width:100%"><span style="color:white; font-weight:bold">' + title + '</span>&nbsp;&nbsp;&nbsp;<span onclick="$(\'#' + me.pre + id + '\').hide(); return false;" class="icn3d-nbclose" title="Close">x</span></div>';

        let html = '<div id="' + me.pre + id + '_nb" style="display:none; background-color:#5C9CCC; width:100%"><span id="' + me.pre + id + '_title" style="color:white; font-weight:bold">' + title + '</span>&nbsp;&nbsp;&nbsp;<div onclick="$(\'#' + me.pre + id + '\').hide(); return false;" class="icn3d-nbclose ui-icon ui-icon-close" title="Close"></div></div>';

        if(bAddExtraDiv) {
            html += '<div id="' + me.pre + id + '_html"></div>';
        }

        return html;
    }

    //Set the html for all popup dialogs.
    setDialogs() { let me = this.icn3dui, ic = me.icn3d;
        if(me.bNode) return '';

        let html = "";

        let defaultColor = "#ffff00"; //ic.colorBlackbkgd; 
 
        me.htmlCls.optionStr = "<option value=";

        html += "<!-- dialog will not be part of the form -->";

        let divClass =(me.cfg.notebook) ? '' : 'icn3d-hidden';
        let dialogClass =(me.cfg.notebook) ? 'icn3d-hidden' : '';
        //html += me.htmlCls.divStr + "alldialogs' class='" + divClass + " icn3d-dialog' style='margin-top:" + me.htmlCls.CMD_HEIGHT + "px'>";
        html += me.htmlCls.divStr + "alldialogs' class='" + divClass + " icn3d-dialog' style='margin-top:12px'>";

        html += me.htmlCls.divStr + "dl_2ddgm' class='" + dialogClass + " icn3d-dl_2ddgm' style='background-color:white'>";
        html += this.addNotebookTitle('dl_2ddgm', '2D Diagram', true);
        html += "</div>";

        html += me.htmlCls.divStr + "dl_2dctn' class='" + dialogClass + " icn3d-dl_2dctn' style='background-color:white'>";
        html += this.addNotebookTitle('dl_2dctn', '2D Cartoon');

        me.svgid_ct = me.pre + "icn3d_cartoon";

        let buttonStrTmp = '<button class="icn3d-commandTitle" style="-webkit-appearance:button; height:24px;background-color:#DDD;" id="';
        let tmpStr = 'icn3d-node-text';
        html += me.htmlCls.divNowrapStr + "Dynamically generated for selected residues. <br>Nodes can be dragged or clicked.</div>";
        html += me.htmlCls.divNowrapStr + buttonStrTmp + me.svgid_ct + '_svg">SVG</button>' + me.htmlCls.space2;
        html += buttonStrTmp + me.svgid_ct + '_png">PNG</button>' + me.htmlCls.space2;
        html += buttonStrTmp + me.svgid_ct + '_json">JSON</button><br>';
        html += "<b>Label</b>: <select id='" + me.svgid_ct + "_label'>";
        html += me.htmlCls.optionStr + "'" + tmpStr + "0'>No</option>";
        html += me.htmlCls.optionStr + "'" + tmpStr + "4'>4px</option>";
        html += me.htmlCls.optionStr + "'" + tmpStr + "8' selected>8px</option>";
        html += me.htmlCls.optionStr + "'" + tmpStr + "12'>12px</option>";
        html += me.htmlCls.optionStr + "'" + tmpStr + "16'>16px</option>";
        html += me.htmlCls.optionStr + "'" + tmpStr + "24'>24px</option>";
        html += me.htmlCls.optionStr + "'" + tmpStr + "32'>32px</option>";
        html += "</select>";
        html += "</div>";

        html += "<svg id='" + me.svgid_ct + "' viewBox='" + "0,0," + me.htmlCls.width2d + "," + me.htmlCls.width2d + "'>";
        html += "</svg>";

        html += "</div>";

    //    if(me.cfg.align !== undefined || me.cfg.chainalign !== undefined || ic.bRealign || ic.bSymd) {
          html += me.htmlCls.divStr + "dl_alignment' class='" + dialogClass + "' style='background-color:white;'>";
          html += this.addNotebookTitle('dl_alignment', 'Dynamically Calculated Symmetry using SymD');
          html += me.htmlCls.divStr + "symd_info'></div>";
          html += me.htmlCls.divStr + "alignseqguide_wrapper'><br>" + me.htmlCls.setHtmlCls.setAlignSequenceGuide() + "</div>";
          html += me.htmlCls.divStr + "dl_sequence2' class='icn3d-dl_sequence'>";
          html += this.addNotebookTitle('dl_sequence2', 'Select Residues in Aligned Sequences');
          html += "</div>";
          html += "</div>";
    //    }

        html += me.htmlCls.divStr + "dl_definedsets' class='" + dialogClass + "'>";
        html += this.addNotebookTitle('dl_definedsets', 'Defined Sets');
        html += me.htmlCls.divStr + "dl_setsmenu'>";
        html += "<b>Defined Sets:</b> <br/>";
        html += "<select id='" + me.pre + "atomsCustom' multiple size='6' style='min-width:130px;'>";
        html += "</select>";
        html += "<div style='margin: 6px 0 6px 0;'>" + me.htmlCls.buttonStr + "deletesets'><b>Delete Selected Sets</b></button></div>";
        html += '        <b>Set Operations</b>: <div style="width:20px; margin-top:6px; display:inline-block;"><span id="' + me.pre + 'dl_command_expand" class="ui-icon ui-icon-plus icn3d-expand icn3d-link" style="width:15px;" title="Expand"></span><span id="' + me.pre + 'dl_command_shrink" class="ui-icon ui-icon-minus icn3d-shrink icn3d-link" style="display:none; width:15px;" title="Shrink"></span></div><br>';
        html += "</div>";

        html += me.htmlCls.divStr + "dl_command' style='display:none;'>";
        html += me.htmlCls.divStr + "dl_setoperations'>";
        html += "<label for='" + me.pre + "setOr'>" + me.htmlCls.inputRadioStr + "name='" + me.pre + "setOperation' id='" + me.pre + "setOr' checked> Union(or) </label><br/>";
        html += "<label for='" + me.pre + "setAnd'>" + me.htmlCls.inputRadioStr + "name='" + me.pre + "setOperation' id='" + me.pre + "setAnd'> Intersection(and) </label><br/>";
        html += "<label for='" + me.pre + "setNot'>" + me.htmlCls.inputRadioStr + "name='" + me.pre + "setOperation' id='" + me.pre + "setNot'> Exclusion(not) </label>";
        html += "</div><br>";

        html += me.htmlCls.setHtmlCls.setAdvanced();

        html += "</div>";
        html += "</div>";

        html += me.htmlCls.setHtmlCls.setAdvanced(2);

        html += me.htmlCls.divStr + "dl_vastplus' class='" + dialogClass + "' style='max-width:500px'>";
        html += this.addNotebookTitle('dl_vastplus', 'Please input PDB ID for VAST+');
        html += "Note: <b>VAST+</b> finds other macromolecular structures that have a similar biological unit. To do this, VAST+ takes into consideration the complete set of 3D domains that VAST identified within a query structure, throughout all of its component protein molecules, and finds other macromolecular structures that have a similar set of proteins/3D domains.<br><br>"; 
        html += "PDB ID: " + me.htmlCls.inputTextStr + "id='" + me.pre + "vastpluspdbid' value='6VXX' size=8><br>";
        html += me.htmlCls.buttonStr + "reload_vastplus'>VAST+</button>";
        html += "</div>";

        html += me.htmlCls.divStr + "dl_vast' class='" + dialogClass + "' style='max-width:500px'>";
        html += this.addNotebookTitle('dl_vast', 'Pleaes input chain or PDB file for VAST');
        html += 'Note: <b>VAST</b> identifies 3D domains (substructures) within each protein structure in the Molecular Modeling Database (MMDB), and then finds other protein structures that have one or more similar 3D domains, using purely geometric criteria. You have two ways to do a VAST search.<br><br>'; 

        html += '<b>Option 1</b>, search with your selection (all residues are selected by default) in the loaded structures:<br>'; 
        html += '<form data-ncbi-sg-search="true" method=post enctype=multipart/form-data action="https://www.ncbi.nlm.nih.gov/Structure/vast/VSMmdb.cgi" id="' + me.pre + 'newvs2" name="newvs2" target="_blank">';
        html += '<input type=hidden id="' + me.pre + 'pdbstr" name="pdbstr">';
        html += "Searching against: <input type='radio' name='dataset' value='Non-redundant subset' checked> Medium-redundancy Subset of PDB <a href='https://www.ncbi.nlm.nih.gov/Structure/VAST/vasthelp.html#VASTNR' title='Medium-redundancy Subset' target='_blank'>?</a> <input type='radio' name='dataset' value='All'>All of PDB <br>";
        // the submit value has to be "Submit" in order to make the backend cgi works
        //html += '<input type="submit" name="' + me.pre + 'cmdVSMmdb" value="VAST Search"></input>';
        html += '<input type="submit" id="' + me.pre + 'cmdVSMmdb2" name="cmdVSMmdb" value="Submit"></input>';
        html += "</form><br>";

        html += '<b>Option 2</b>, search with PDB ID and chain name:<br>'; 
        html += "PDB ID: " + me.htmlCls.inputTextStr + "id='" + me.pre + "vastpdbid' value='4N7N' size=8> &nbsp;&nbsp;";
        html += "Chain Name: " + me.htmlCls.inputTextStr + "id='" + me.pre + "vastchainid' value='A' size=8> <br>";
        html += me.htmlCls.buttonStr + "reload_vast'>VAST</button><br><br>";

        html += '<b>Option 3</b>, search with a PDB file:<br>'; 
        html += '<form data-ncbi-sg-search="true" method=post enctype=multipart/form-data action="https://www.ncbi.nlm.nih.gov/Structure/vast/VSMmdb.cgi" id="' + me.pre + 'newvs" name="newvs" target="_blank">';
        html += "PDB File: " + me.htmlCls.inputFileStr + " name='pdbfile' size=8><br>";
        html += "Searching against: <input type='radio' name='dataset' value='Non-redundant subset' checked> Medium-redundancy Subset of PDB <a href='https://www.ncbi.nlm.nih.gov/Structure/VAST/vasthelp.html#VASTNR' title='Medium-redundancy Subset' target='_blank'>?</a> <input type='radio' name='dataset' value='All'>All of PDB <br>";
        // the submit value has to be "Submit" in order to make the backend cgi works
        //html += '<input type="submit" name="' + me.pre + 'cmdVSMmdb" value="VAST Search"></input>';
        html += '<input type="submit" id="' + me.pre + 'cmdVSMmdb" name="cmdVSMmdb" value="Submit"></input>';
        html += "</form><br>";

        html += "</div>";

        html += me.htmlCls.divStr + "dl_foldseek' class='" + dialogClass + "' style='max-width:500px'>";
        html += this.addNotebookTitle('dl_foldseek', 'Submit your selection to Foldseek');
        html += '1. <input type="submit" id="' + me.pre + 'fssubmit" name="fssubmit" value="Submit"></input> your selection (all residues are selected by default) in the loaded structures to <a href="https://search.foldseek.com/search" target="_blank">Foldseek</a> web server.<br><br>';
        html += '2 (Optional). Once you see the structure neighbors, you can view the alignment in iCn3D by inputing a list of PDB chain IDs or AlphaFold UniProt IDs below. <br><br>The PDB chain IDs are the same as the record names such as "1HHO_A". The UniProt ID is the text between "AF-" and "-F1". For example, the UniProt ID for the record name "AF-P69905-F1-model_v4" is "P69905".<br><br>'; 

        html += "Chain ID List: " + me.htmlCls.inputTextStr + "id='" + me.pre + "foldseekchainids' value='P69905,P01942,1HHO_A' size=30> ";
        html += me.htmlCls.buttonStr + "reload_foldseek'>Align</button>";
        html += "</div>";

        html += me.htmlCls.divStr + "dl_mmtfid' class='" + dialogClass + "'>";
        html += this.addNotebookTitle('dl_mmtfid', 'Please input an BCIF/MMTF ID');
        html += "BCIF/MMTF ID: " + me.htmlCls.inputTextStr + "id='" + me.pre + "mmtfid' value='1TUP' size=8> ";
        html += me.htmlCls.buttonStr + "reload_mmtf'>Load</button>";
        html += "</div>";

        html += me.htmlCls.divStr + "dl_pdbid' class='" + dialogClass + "'>";
        html += this.addNotebookTitle('dl_pdbid', 'Please input a PDB ID');
        html += "PDB ID: " + me.htmlCls.inputTextStr + "id='" + me.pre + "pdbid' value='1TUP' size=8> ";
        html += me.htmlCls.buttonStr + "reload_pdb'>Load</button>";
        html += "</div>";

        html += me.htmlCls.divStr + "dl_afid' class='" + dialogClass + "'>";
        html += this.addNotebookTitle('dl_afid', 'Please input an AlphaFold UniProt ID');
        html += "Note: AlphaFold produces a per-residue confidence score (pLDDT) between 0 and 100:<br>";
        html += me.htmlCls.clickMenuCls.setAlphaFoldLegend() + "<br>";

        let afid = (me.cfg.afid) ? me.cfg.afid : 'A4D1S0';

        html += "<a href='https://alphafold.ebi.ac.uk/' target='_blank'>AlphaFold Uniprot</a> ID: " + me.htmlCls.inputTextStr + "id='" + me.pre + "afid' value='" + afid + "' size=10><br><br>";
        html += me.htmlCls.buttonStr + "reload_af'>Load Structure</button><br><br>"; 
        html += "PAE Map: " + me.htmlCls.buttonStr + "reload_afmap'>Load Half</button>"
            + me.htmlCls.buttonStr + "reload_afmapfull' style='margin-left:30px'>Load Full (slow)</button>";
        html += "</div>";

        html += me.htmlCls.divStr + "dl_refseqid' class='" + dialogClass + "'>";
        html += this.addNotebookTitle('dl_refseqid', 'Please input an NCBI protein accession');
        html += "NCBI Protein Accession: " + me.htmlCls.inputTextStr + "id='" + me.pre + "refseqid' value='NP_001743.1' size=8> ";
        html += me.htmlCls.buttonStr + "reload_refseq'>Load</button>";
        html += "</div>";

        html += me.htmlCls.divStr + "dl_opmid' class='" + dialogClass + "'>";
        html += this.addNotebookTitle('dl_opmid', 'Please input an OPM PDB ID');
        html += "<a href='https://opm.phar.umich.edu' target='_blank'>Orientations of Proteins in Membranes(OPM)</a> PDB ID: " + me.htmlCls.inputTextStr + "id='" + me.pre + "opmid' value='6JXR' size=8> ";
        html += me.htmlCls.buttonStr + "reload_opm'>Load</button>";
        html += "</div>";

        html += me.htmlCls.divStr + "dl_pdbfile' class='" + dialogClass + "'>";
        html += this.addNotebookTitle('dl_pdbfile', 'Please input a PDB file');
        html += "Note: Several PDB files could be concatenated into a single PDB file. Use the line \"ENDMDL\" to separate PDB files.<br><br>";
        html += "PDB File: " + me.htmlCls.inputFileStr + " id='" + me.pre + "pdbfile' size=8> ";
        html += me.htmlCls.buttonStr + "reload_pdbfile'>Load</button>";
        html += "</div>";

        html += me.htmlCls.divStr + "dl_pdbfile_app' class='" + dialogClass + "'>";
        html += this.addNotebookTitle('dl_pdbfile_app', 'Please append PDB files');
        html += "Multiple PDB Files: <input type='file' multiple id='" + me.pre + "pdbfile_app' size=8> ";
        html += me.htmlCls.buttonStr + "reload_pdbfile_app'>Append</button>";
        html += "</div>";

        html += me.htmlCls.divStr + "dl_rescolorfile' class='" + dialogClass + "'>";
        html += this.addNotebookTitle('dl_rescolorfile', 'Please input a residue color file');
        html += '<div style="width:450px;">The custom JSON file on residue colors has the following format for proteins("ALA" and "ARG") and nucleotides("G" and "A"):<br>';
        html += '{"ALA":"#C8C8C8", "ARG":"#145AFF", ..., "G":"#008000", "A":"#6080FF", ...}</div><br>';
        html += "Residue Color File: " + me.htmlCls.inputFileStr + "id='" + me.pre + "rescolorfile' size=8> ";
        html += me.htmlCls.buttonStr + "reload_rescolorfile'>Load</button>";
        html += "</div>";

        html += me.htmlCls.divStr + "dl_customcolor' class='" + dialogClass + "'>";
        html += this.addNotebookTitle('dl_customcolor', 'Please input a custom color file');
        html += " <input type='hidden' id='" + me.pre + "customcolor_chainid' value=''>";
        html += '<div style="width:450px;">The custom file for the structure has two columns separated by space or tab: ';
        html += 'residue number, and score in the range of 0-100. If you click "Apply Custom Color" button, ';
        html += 'the scores 0, 50 and 100 correspond to the three colors specified below. If you click "Apply Custom Tube", ';
        html += 'the selected residues will be displayed in a style similar to "B-factor Tube".</div><br>';
        html += "Custom File: " + me.htmlCls.inputFileStr + "id='" + me.pre + "cstcolorfile' size=8> <br><br>";
        html += "1. " + me.htmlCls.buttonStr + "reload_customcolorfile'>Apply Custom Color</button>" + me.htmlCls.buttonStr + "remove_legend' style='margin-left:30px;'>Remove Legend</button><br>";
        html += "<span style='margin-left:15px'>Score to Color: 0:</span> <select id='" + me.pre + "startColor'>";
        html += me.htmlCls.optionStr + "'red'>Red</option>";
        html += me.htmlCls.optionStr + "'green'>Green</option>";
        html += me.htmlCls.optionStr + "'blue' selected>Blue</option>";
        html += "</select>";
        html += "<span style='margin-left:30px'>50</span>: <select id='" + me.pre + "midColor'>";
        html += me.htmlCls.optionStr + "'white' selected>White</option>";
        html += me.htmlCls.optionStr + "'black'>Black</option>";
        html += "</select>";
        html += "<span style='margin-left:30px'>100</span>: <select id='" + me.pre + "endColor'>";
        html += me.htmlCls.optionStr + "'red' selected>Red</option>";
        html += me.htmlCls.optionStr + "'green'>Green</option>";
        html += me.htmlCls.optionStr + "'blue'>Blue</option>";
        html += "</select><br>";
        html += "or<br><br>";
        html += "2. " + me.htmlCls.buttonStr + "reload_customtubefile'>Apply Custom Tube</button>";

        html += "</div>";

        html += me.htmlCls.divStr + "dl_customref' class='" + dialogClass + "'>";
        html += this.addNotebookTitle('dl_customref', 'Please input a reference number file');
        html += '<div style="width:550px;">You can define your own reference numbers in a custom file using Excel, and then export it as a CSV file. An example file is shown below with cells separated by commas.<br>';
        html += '<pre>refnum,11,12,,21,22,,10C,11C,20C<br>';
        html += '1TUP_A,100,101,,,132,,,,<br>';
        html += '1TUP_B,110,111,,141,142,,,,<br>';
        html += '1TUP_C,,,,,,,200,201,230</pre>';
        html += 'The first row defines the reference residue numbers, which could be any strings. The 1st cell could be anything. The rest cells are reference residue numbers (e.g., 11, 21, 10C, etc.) or empty cells. Each chain has a separate row. The first cell of the second row is the chain ID "1TUP_A". The rest cells are the corresponding real residue numbers for reference residue numbers in the first row. For example, the reference numbers for residues 100, 101, and 132 in the chain 1TUP_A are 11, 12, and 22, respectively. The fourth row shows another set of reference numners for the chain "1TUP_C". It could be a chain from a different structure.<br><br>';
        html += 'To select all residues corresponding to the reference numbers, you can simplay replace ":" with "%" in the <a href="https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d.html#selectb" target="_blank">Specification</a>. For example, "%12"  selects the residue 101 in 1TUP_A and the residue 111 in 1TUP_B. ".A%12" has the chain "A" filter and selects the residue 101 in 1TUP_A.<br>';
        html += '</div><br>';
        html += "Custom File: " + me.htmlCls.inputFileStr + "id='" + me.pre + "cstreffile' size=8> <br><br>";
        html += me.htmlCls.buttonStr + "reload_customreffile'>Apply Custom Reference Numbers</button>";
        html += "</div>";

        html += me.htmlCls.divStr + "dl_align' class='" + dialogClass + "'>";
        html += this.addNotebookTitle('dl_align', 'Please select residues in aligned sequences');
        html += "Enter the PDB IDs or MMDB IDs of the structures: <br/><br/>ID1: " + me.htmlCls.inputTextStr + "id='" + me.pre + "alignid1' value='2DN3' size=8>" + me.htmlCls.space3 + me.htmlCls.space3 + "ID2: " + me.htmlCls.inputTextStr + "id='" + me.pre + "alignid2' value='4N7N' size=8><br/><br/>";
        html += "<b>VAST+ based on VAST</b>: " + me.htmlCls.buttonStr + "reload_align_ori'>All Matching Molecules Superposed</button>" + me.htmlCls.space3 + me.htmlCls.buttonStr + "reload_align_refined'>Invariant Substructure Superposed</button><br><br>";
        html += "<b>VAST+ based on TM-align</b>: " + me.htmlCls.buttonStr + "reload_align_tmalign'>All Matching Molecules Superposed</button><br><br>";
        html += "</div>";
        
        html += me.htmlCls.divStr + "dl_alignaf' class='" + dialogClass + "'>";
        html += this.addNotebookTitle('dl_alignaf', 'Align AlphaFold structures');
        html += "Enter two <a href='https://alphafold.ebi.ac.uk/' target='_blank'>AlphaFold Uniprot</a> IDs: <br/><br/>ID1: " + me.htmlCls.inputTextStr + "id='" + me.pre + "alignafid1' value='P41327' size=8>" + me.htmlCls.space3 + me.htmlCls.space3 + "ID2: " + me.htmlCls.inputTextStr + "id='" + me.pre + "alignafid2' value='P41331' size=8><br/><br/>";
        html += me.htmlCls.buttonStr + "reload_alignaf_tmalign'>Align with TM-align</button>" + me.htmlCls.buttonStr + "reload_alignaf' style='margin-left:30px'>Align with VAST</button>";
        html += "</div>";

        html += me.htmlCls.divStr + "dl_chainalign' class='" + dialogClass + "'>";
        html += this.addNotebookTitle('dl_chainalign', 'Align chains');
        html += "<div style='width:550px'>";
        html += "All chains will be aligned to the first chain in the comma-separated chain IDs. Each chain ID has the form of PDBID_chain (e.g., 1HHO_A, case sensitive) or UniprotID (e.g., P69905 for AlphaFold structures).<br/><br/>";
        html += "<b>Chain IDs</b>: " + me.htmlCls.inputTextStr + "id='" + me.pre + "chainalignids' value='P69905,P01942,1HHO_A' size=50><br/><br/>";
        html += me.htmlCls.buttonStr + "reload_chainalign_tmalign'><b>Align with TM-align</b></button>" + me.htmlCls.buttonStr + "reload_chainalign_asym' style='margin-left:30px'><b>Align with VAST</b></button><br/><br/>";

        html += "(Note: To align chains in custom PDB files, you could load them in \"File > Open File > PDB Files (appendable)\" and click \"Analysis > Defined Sets\". Finally select multiple chains in Defined Sets and click \"File > Realign Selection\".)<br><br>";
        html += "</div></div>";

        html += me.htmlCls.divStr + "dl_chainalign2' class='" + dialogClass + "'>";
        html += this.addNotebookTitle('dl_chainalign2', 'Align chains');
        html += "<div style='width:550px'>";
        html += "All chains will be aligned to the first chain in the comma-separated chain IDs. Each chain ID has the form of PDBID_chain (e.g., 1HHO_A, case sensitive) or UniprotID (e.g., P69905 for AlphaFold structures).<br/><br/>";
        html += "<b>Chain IDs</b>: " + me.htmlCls.inputTextStr + "id='" + me.pre + "chainalignids2' value='P69905,P01942,1HHO_A' size=50><br/><br/>";

        html += "The sequence alignment (followed by structure alignment) is based on residue numbers in the First/Master chain: <br>" + me.htmlCls.inputTextStr + "id='" + me.pre + "resalignids' value='1,5,10-50' size=50><br/>";
        html += me.htmlCls.buttonStr + "reload_chainalign_asym2' style='margin-top:3px;'><b>Align by Sequence Alignment</b></button><br/><br/>";

        html += "(Note: To align chains in custom PDB files, you could load them in \"File > Open File > PDB Files (appendable)\" and click \"Analysis > Defined Sets\". Finally select multiple chains in Defined Sets and click \"File > Realign Selection\".)<br><br>";
        html += "</div></div>";

        html += me.htmlCls.divStr + "dl_chainalign3' class='" + dialogClass + "'>";
        html += this.addNotebookTitle('dl_chainalign3', 'Align chains');
        html += "<div style='width:550px'>";
        html += this.getHtmlAlignResidueByResidue('chainalignids3', 'predefinedres', 'reload_chainalign_asym3');
        html += "</div></div>";

        html += me.htmlCls.divStr + "dl_realignresbyres' class='" + dialogClass + "'>";
        html += this.addNotebookTitle('dl_realignresbyres', 'Realign residue by residue');
        html += "<div style='width:550px'>";
        html += "<b>Option 1</b>: " + me.htmlCls.buttonStr + "realignSelection'><b>Realign Current Selection Residue by Residue</b></button><br/><br/>";
        html += "<b>Option 2</b>: <br>";
        html += "<div class='icn3d-box'>" + this.getHtmlAlignResidueByResidue('chainalignids4', 'predefinedres2', 'reload_chainalign_asym4') + "</div>";
        html += "</div></div>";

        html += me.htmlCls.divStr + "dl_mutation' class='" + dialogClass + "'>";
        html += this.addNotebookTitle('dl_mutation', 'Mutation analysis');
        html += "<div style='width:500px'>";
        html += 'Please specify the mutations with a comma separated mutation list. Each mutation can be specified as "[<b>uppercase</b> PDB ID or AlphaFold UniProt ID]_[Chain Name]_[Residue Number]_[One Letter Mutant Residue]". E.g., the mutation of N501Y in the E chain of PDB 6M0J can be specified as "6M0J_E_501_Y". For AlphaFold structures, the "Chain ID" is "A".<br/>If you load a custom structure without PDB or UniProt ID, you can open "Seq. & Annotations" window and find the chain ID such as "stru_A". The part before the underscore is the structure ID, which can be used to specify the mutation such as "stru_A_...". Remember to choose "Show Mutation in: Current Page".<br/><br/>';
        html += "<div style='display:inline-block; width:110px'>Mutations: </div>" + me.htmlCls.inputTextStr + "id='" + me.pre + "mutationids' value='6M0J_E_484_K,6M0J_E_501_Y,6M0J_E_417_N' size=50><br/><br/>";
 
        html += '<b>ID Type</b>: ';
        html += '<input type="radio" name="' + me.pre + 'idsource" id="' + me.pre + 'type_mmdbid" value="mmdbid" checked>PDB ID';
        html += '<input type="radio" name="' + me.pre + 'idsource" id="' + me.pre + 'type_afid" value="afid" style="margin-left:20px">AlphaFold UniProt ID<br><br>';

        html += '<b>Show Mutation in</b>: ';
        html += '<input type="radio" name="' + me.pre + 'pdbsource" id="' + me.pre + 'showin_currentpage" value="currentpage">Current Page';
        html += '<input type="radio" name="' + me.pre + 'pdbsource" id="' + me.pre + 'showin_newpage" value="newpage" style="margin-left:20px" checked>New Page<br><br>';

        html += me.htmlCls.buttonStr + "reload_mutation_3d' title='Show the mutations in 3D using the scap program'>3D with scap</button>";
        html += me.htmlCls.buttonStr + "reload_mutation_inter' style='margin-left:20px' title='Show the mutations in 3D and the change of interactions'>Interactions</button>";
        html += me.htmlCls.buttonStr + "reload_mutation_pdb' style='margin-left:20px' title='Show the mutations in 3D and export the PDB of the mutant within 10 angstrom'>PDB</button>";
        html += "<br/><br/></div></div>";

        html += me.htmlCls.divStr + "dl_mol2file' class='" + dialogClass + "'>";
        html += this.addNotebookTitle('dl_mol2file', 'Please input a Mol2 file');
        html += "Mol2 File: " + me.htmlCls.inputFileStr + "id='" + me.pre + "mol2file' size=8> ";
        html += me.htmlCls.buttonStr + "reload_mol2file'>Load</button>";
        html += "</div>";
        html += me.htmlCls.divStr + "dl_sdffile' class='" + dialogClass + "'>";
        html += this.addNotebookTitle('dl_sdffile', 'Please input an SDF file');
        html += "SDF File: " + me.htmlCls.inputFileStr + "id='" + me.pre + "sdffile' size=8> ";
        html += me.htmlCls.buttonStr + "reload_sdffile'>Load</button>";
        html += "</div>";
        html += me.htmlCls.divStr + "dl_xyzfile' class='" + dialogClass + "'>";
        html += this.addNotebookTitle('dl_xyzfile', 'Please input an XYZ file');
        html += "XYZ File: " + me.htmlCls.inputFileStr + "id='" + me.pre + "xyzfile' size=8> ";
        html += me.htmlCls.buttonStr + "reload_xyzfile'>Load</button>";
        html += "</div>";

        html += me.htmlCls.divStr + "dl_afmapfile' class='" + dialogClass + "'>";
        html += this.addNotebookTitle('dl_afmapfile', 'Please input an AlphaFold PAE file');
        html += "AlphaFold PAE File: " + me.htmlCls.inputFileStr + "id='" + me.pre + "afmapfile' size=8> <br><br>";
        html += me.htmlCls.buttonStr + "reload_afmapfile'>Load Half PAE Map</button>" 
          + me.htmlCls.buttonStr + "reload_afmapfilefull' style='margin-left:30px'>Load Full PAE Map (slow)</button>";
        html += "</div>";

        html += me.htmlCls.divStr + "dl_urlfile' class='" + dialogClass + "'>";
        html += this.addNotebookTitle('dl_urlfile', 'Please input a file via URL');
        html += "File type: ";
        html += "<select id='" + me.pre + "filetype'>";
        html += me.htmlCls.optionStr + "'pdb' selected>PDB</option>";
        html += me.htmlCls.optionStr + "'mmcif'>mmCIF</option>";
        html += me.htmlCls.optionStr + "'mol2'>Mol2</option>";
        html += me.htmlCls.optionStr + "'sdf'>SDF</option>";
        html += me.htmlCls.optionStr + "'xyz'>XYZ</option>";
        html += me.htmlCls.optionStr + "'icn3dpng'>iCn3D PNG</option>";
        html += me.htmlCls.optionStr + "'pae'>AlphaFold PAE</option>";
        html += "</select><br/>";
        html += "URL in the same host: " + me.htmlCls.inputTextStr + "id='" + me.pre + "urlfile' size=20><br/> ";
        html += me.htmlCls.buttonStr + "reload_urlfile'>Load</button>";
        html += "</div>";

        html += me.htmlCls.divStr + "dl_mmciffile' class='" + dialogClass + "'>";
        html += this.addNotebookTitle('dl_mmciffile', 'Please append mmCIF files');
        html += "Multiple mmCIF Files: <input type='file' multiple id='" + me.pre + "mmciffile' size=8> ";
        html += me.htmlCls.buttonStr + "reload_mmciffile'>Load</button>";
        html += "</div>";

        html += me.htmlCls.divStr + "dl_mmcifid' class='" + dialogClass + "'>";
        html += this.addNotebookTitle('dl_mmcifid', 'Please input an mmCIF ID');
        html += "mmCIF ID: " + me.htmlCls.inputTextStr + "id='" + me.pre + "mmcifid' value='1TUP' size=8> ";
        html += me.htmlCls.buttonStr + "reload_mmcif'>Load</button>";
        html += "</div>";

        html += me.htmlCls.divStr + "dl_mmdbid' class='" + dialogClass + "' style='max-width:500px'>";
        html += this.addNotebookTitle('dl_mmdbid', 'Please input an MMDB ID');
        html += "MMDB or PDB ID: " + me.htmlCls.inputTextStr + "id='" + me.pre + "mmdbid' value='1TUP' size=8> <br><br>";
        html += me.htmlCls.buttonStr + "reload_mmdb'>Load Biological Unit</button>" + me.htmlCls.buttonStr + "reload_mmdb_asym' style='margin-left:30px'>Load Asymmetric Unit (All Chains)</button><br/><br/><br/>";
        html += '<b>Note</b>: The "<b>biological unit</b>" is the <b>biochemically active form of a biomolecule</b>, <div style="width:20px; margin:6px 0 0 20px; display:inline-block;"><span id="'
          + me.pre + 'asu_bu_expand" class="ui-icon ui-icon-plus icn3d-expand icn3d-link" style="width:15px;" title="Expand"></span><span id="'
          + me.pre + 'asu_bu_shrink" class="ui-icon ui-icon-minus icn3d-shrink icn3d-link" style="display:none; width:15px;" title="Shrink"></span></div>';

        html += me.htmlCls.divStr + "asu_bu' style='display:none;'>";
        html += 'which can range from a monomer (single protein molecule) to an oligomer of 100+ protein molecules.<br><br>The "<b>asymmetric unit</b>" is the raw 3D structure data resolved by X-ray crystallography, NMR, or Cryo-electron microscopy. The asymmetric unit is equivalent to the biological unit in approximately 60% of structure records. In the remaining 40% of the records, the asymmetric unit represents a portion of the biological unit that can be reconstructed using crystallographic symmetry, or it represents multiple copies of the biological unit.</div>';

        html += "</div>";

        html += me.htmlCls.divStr + "dl_mmdbafid' class='" + dialogClass + "' style='max-width:600px'>";
        html += this.addNotebookTitle('dl_mmdbafid', 'Please input a list of PDB/AlphaFold IDs');
        html += "List of PDB, MMDB, or AlphaFold UniProt structures: " + me.htmlCls.inputTextStr + "id='" + me.pre + "mmdbafid' placeholder='e.g., 1HHO,4N7N,P69905,P01942' size=30> <br><br>";
        html += "<div style='display:inline-block; width:20px'></div>" + me.htmlCls.buttonStr + "reload_mmdbaf' style='width:150px'>Load Biological Unit</button>" + me.htmlCls.buttonStr + "reload_mmdbaf_asym' style='margin-left:30px; width:250px'>Load Asymmetric Unit (All Chains)</button>" + "<br/><br/>";
        html += "<div style='display:inline-block; width:20px'>or</div>" + me.htmlCls.buttonStr + "reload_mmdbaf_append' style='width:150px'>Append Biological Unit</button>" + me.htmlCls.buttonStr + "reload_mmdbaf_asym_append' style='margin-left:30px; width:250px'>Append Asymmetric Unit (All Chains)</button>" + "<br/><br/>";

        html += '<b>Note</b>: The "<b>biological unit</b>" is the <b>biochemically active form of a biomolecule</b>, <div style="width:20px; margin:6px 0 0 20px; display:inline-block;"><span id="'
        + me.pre + 'asu_bu2_expand" class="ui-icon ui-icon-plus icn3d-expand icn3d-link" style="width:15px;" title="Expand"></span><span id="'
        + me.pre + 'asu_bu2_shrink" class="ui-icon ui-icon-minus icn3d-shrink icn3d-link" style="display:none; width:15px;" title="Shrink"></span></div>';

        html += me.htmlCls.divStr + "asu_bu2' style='display:none;'>";
        html += 'which can range from a monomer (single protein molecule) to an oligomer of 100+ protein molecules.<br><br>The "<b>asymmetric unit</b>" is the raw 3D structure data resolved by X-ray crystallography, NMR, or Cryo-electron microscopy. The asymmetric unit is equivalent to the biological unit in approximately 60% of structure records. In the remaining 40% of the records, the asymmetric unit represents a portion of the biological unit that can be reconstructed using crystallographic symmetry, or it represents multiple copies of the biological unit.</div>';

        html += "</div>";

        html += me.htmlCls.divStr + "dl_blast_rep_id' style='max-width:600px;' class='" + dialogClass + "'>";
        html += this.addNotebookTitle('dl_blast_rep_id', 'Align sequence to structure');
        html += "Enter a protein sequence ID (or FASTA sequence) and the aligned protein accession, which can be found using the <a href='https://blast.ncbi.nlm.nih.gov/Blast.cgi?PROGRAM=blastp&PAGE_TYPE=BlastSearch' target='_blank'>BLAST</a> search with the protein sequence ID or FASTA sequence as input. If the protein accession is not a PDB chain, the corresponding AlphaFold UniProt structure is used.<br><br> ";
        html += "<b>Protein Sequence ID</b>(NCBI protein accession of a sequence): " + me.htmlCls.inputTextStr + "id='" + me.pre + "query_id' value='NP_001108451.1' size=8><br> ";
        html += "or FASTA sequence: <br><textarea id='" + me.pre + "query_fasta' rows='5' style='width: 100%; height: " +(me.htmlCls.LOG_HEIGHT) + "px; padding: 0px; border: 0px;'></textarea><br><br>";
        html += "<b>Aligned Protein Accession</b> (or a chain of a PDB): " + me.htmlCls.inputTextStr + "id='" + me.pre + "blast_rep_id' value='1TSR_A' size=8><br> ";
        //html += me.htmlCls.buttonStr + "reload_blast_rep_id'>Load</button>";
        html += me.htmlCls.buttonStr + "reload_blast_rep_id'>Align with BLAST</button> " + me.htmlCls.wifiStr
            + me.htmlCls.buttonStr + "reload_alignsw' style='margin-left:30px'>Align with Global Smith-Waterman</button>"
            + me.htmlCls.buttonStr + "reload_alignswlocal' style='margin-left:30px'>Align with Local Smith-Waterman</button>";
        html += "</div>";

        html += me.htmlCls.divStr + "dl_esmfold' style='max-width:600px;' class='" + dialogClass + "'>";
        html += this.addNotebookTitle('dl_esmfold', 'Sequence to structure prediction with ESMFold');
        html += "The sequence to structure prediction is done via <a href='https://esmatlas.com/resources?action=fold' target='_blank'>ESM Metagenomic Atlas</a>. The sequence should be less than 400 characters. For any sequence longer than 400, please see the discussion <a href='https://github.com/facebookresearch/esm/issues/21' target='_blank'>here</a>.<br><br> ";
        html += "FASTA sequence: <br><textarea id='" + me.pre + "esmfold_fasta' rows='5' style='width: 100%; height: " +(me.htmlCls.LOG_HEIGHT) + "px; padding: 0px; border: 0px;'></textarea><br><br>";
        html += me.htmlCls.buttonStr + "run_esmfold'>ESMFold</button> ";
        html += "</div>";

        html += me.htmlCls.divStr + "dl_yournote' class='" + dialogClass + "'>";
        html += this.addNotebookTitle('dl_yournote', 'Your Note');
        html += "Your note will be saved in the HTML file when you click \"File > Save File > iCn3D PNG Image\".<br><br>";
        html += "<textarea id='" + me.pre + "yournote' rows='5' style='width: 100%; height: " +(me.htmlCls.LOG_HEIGHT) + "px; padding: 0px; border: 0px;' placeholder='Enter your note here'></textarea><br>";
        html += me.htmlCls.buttonStr + "applyyournote'>Save</button>";
        html += "</div>";

        html += me.htmlCls.divStr + "dl_proteinname' class='" + dialogClass + "'>";
        html += this.addNotebookTitle('dl_proteinname', 'Please input a protein/gene name');
        html += "Protein/Gene name: " + me.htmlCls.inputTextStr + "id='" + me.pre + "proteinname' value='TP53' size=8> ";
        html += me.htmlCls.buttonStr + "reload_proteinname'>Search</button>";
        html += "</div>";

        html += me.htmlCls.divStr + "dl_cid' class='" + dialogClass + "'>";
        html += this.addNotebookTitle('dl_cid', 'Please input a PubChem Compound');
        html += "PubChem CID/Name/InchI: " + me.htmlCls.inputTextStr + "id='" + me.pre + "cid' value='2244' size=8> ";
        html += me.htmlCls.buttonStr + "reload_cid'>Load</button>";
        html += "</div>";

        html += me.htmlCls.divStr + "dl_smiles' class='" + dialogClass + "'>";
        html += this.addNotebookTitle('dl_cid', 'Please input a chemical SMILES');
        html += "Chemical SMILES: " + me.htmlCls.inputTextStr + "id='" + me.pre + "smiles' value='CC(=O)OC1=CC=CC=C1C(=O)O' size=30> ";
        html += me.htmlCls.buttonStr + "reload_smiles'>Load</button>";
        html += "</div>";

        html += me.htmlCls.divStr + "dl_pngimage' class='" + dialogClass + "'>";
        html += this.addNotebookTitle('dl_pngimage', 'Please append iCn3D PNG Image files');
        html += "Multiple iCn3D PNG images: " + me.htmlCls.inputFileStr + " multiple id='" + me.pre + "pngimage' size=8><br/>";
        html += me.htmlCls.buttonStr + "reload_pngimage' style='margin-top: 6px;'>Append</button>";
        html += "</div>";

        html += me.htmlCls.divStr + "dl_state' class='" + dialogClass + "'>";
        html += this.addNotebookTitle('dl_state', 'Please input a state file');
        html += "State file: " + me.htmlCls.inputFileStr + "id='" + me.pre + "state'><br/>";
        html += me.htmlCls.buttonStr + "reload_state' style='margin-top: 6px;'>Load</button>";
        html += "</div>";

        html += me.htmlCls.divStr + "dl_fixedversion' style='max-width:500px' class='" + dialogClass + "'>";
        html += this.addNotebookTitle('dl_fixedversion', 'Use fixed version of iCn3D');
        html += "Since January 6, 2021, you can show the original view with the archived version of iCn3D by pasting your URL below and click \"Show Originial View\". Note the version in the parameter \"v\" was used to replace \"full.html\" with \"full_[v].html\" in the URL.<br><br>";
        html += "Share Link URL: " + me.htmlCls.inputTextStr + "id='" + me.pre + "sharelinkurl' size=60><br>";
        html += me.htmlCls.buttonStr + "reload_fixedversion'>Show Original View</button><br><br>";
        html += "</div>";


        html += me.htmlCls.divStr + "dl_selection' class='" + dialogClass + "'>";
        html += this.addNotebookTitle('dl_selection', 'Please input the selection file');
        html += "Selection file: " + me.htmlCls.inputFileStr + "id='" + me.pre + "selectionfile'><br/>";
        html += me.htmlCls.buttonStr + "reload_selectionfile' style='margin-top: 6px;'>Load</button>";
        html += "</div>";

        html += me.htmlCls.divStr + "dl_selectCollections' class='" + dialogClass + "'>";
        html += me.htmlCls.divStr + "dl_collectionsMenu'>";
        html += '<b>Collection File</b>: <div style="width:20px; margin-top:6px; display:inline-block;"><span id="' + me.pre + 'dl_collection_file_expand" class="ui-icon ui-icon-plus icn3d-expand icn3d-link" style="display:none; width:15px;" title="Expand"></span><span id="' + me.pre + 'dl_collection_file_shrink" class="ui-icon ui-icon-minus icn3d-shrink icn3d-link" style="width:15px;" title="Shrink"></span></div><br>';
        html += me.htmlCls.divStr + "dl_collection_file' style=''>";
        html += "You can load a collection of structures via a file. Here are <a href='https://github.com/ncbi/icn3d/blob/master/example/collection/' target='_blank'>some example files</a><br><br>";
        html += "Collection file: " + me.htmlCls.inputFileStr + "id='" + me.pre + "collectionfile'><br/>";
        html += "<input type='radio' id='dl_collectionAppendStructureNone' name='appendStructure' value='none' checked/>";
        html += "<label for='dl_collectionAppendStructureNone'>Default</label>";
        html += "<input type='radio' id='dl_collectionAppendStructure' name='appendStructure' value='append' />";
        html += "<label for='dl_collectionAppendStructure'>Append</label><br/>";
        html += me.htmlCls.buttonStr + "reload_collectionfile' style='margin-top: 6px;'>Load</button>";
        html += "</div>";
        html += "</div>";
        html += '<br/><b>Structures</b>: <div style="width:20px; margin-top:6px; display:inline-block;"><span id="' + me.pre + 'dl_collection_structures_expand" class="ui-icon ui-icon-plus icn3d-expand icn3d-link" style="width:15px;" title="Expand"></span><span id="' + me.pre + 'dl_collection_structures_shrink" class="ui-icon ui-icon-minus icn3d-shrink icn3d-link" style="display:none; width:15px;" title="Shrink"></span></div><br>';
        html += me.htmlCls.divStr + "dl_collection_structures' style='display: none'>";
        html += "<select id='" + me.pre + "collections_menu'multiple size='6' style='min-width:300px;'></select>";
        html += '<br/>';
        html += me.htmlCls.buttonStr + "collections_clear_commands' style='margin-top: 6px;'>Clear Commands</button>";
        html += me.htmlCls.buttonStr + "opendl_export_collections'>Export JSON</button>";
        html += "</div>";
        html += '<br/>'; 
        html += "</div>";

        html += me.htmlCls.divStr + "dl_export_collections' class='" + dialogClass + "'>";
        html += this.addNotebookTitle('dl_export_collections', 'Export Collections');
        html += "<label for='dl_collectionTitle'>Collection Title: </label>";
        html += "<input type='text' id='dl_collectionTitle' name='collectionTitle' placeholder='Enter collection title' />";
        html += '<br/>';
        html += "<label for='dl_collectionDescription'>Collection Description: </label>";
        html += "<input type='text' id='dl_collectionDescription' name='collectionDescription' placeholder='Enter collection description' />";
        html += '<br/>';
        html += "<input type='radio' id='dl_collectionExportSelected' name='exportOption' value='selected' />";
        html += "<label for='dl_collectionExportSelected'>Selected</label>";
        html += "<input type='radio' id='dl_collectionExportAll' name='exportOption' value='all' />";
        html += "<label for='dl_collectionExportAll'>All</label>";
        html += '<br/>';
        html += me.htmlCls.buttonStr + "export_collections'>Export</button>";
        html += "</div>";

        html += me.htmlCls.divStr + "dl_menuloadpref' class='" + dialogClass + "'>";
        html += this.addNotebookTitle('dl_menuloadpref', 'Load a preference file');
        html += "Preference file: " + me.htmlCls.inputFileStr + "id='" + me.pre + "menupreffile'><br/>";
        html += me.htmlCls.buttonStr + "reload_menupreffile' style='margin-top: 6px;'>Load</button>";
        html += "</div>";

        html += me.htmlCls.divStr + "dl_dsn6' class='" + dialogClass + "' style='max-width:600px'>";
        html += this.addNotebookTitle('dl_dsn6', 'Load a map file');
        html += "<b>Note</b>: Always load a PDB file before loading map files. If you don't specify the threshold below, a default one will be chosen.<br/><br/><br/>";

        html += "<span style='white-space:nowrap;font-weight:bold;'>2fofc contour at default threshold or at: " 
          + me.htmlCls.inputTextStr + "id='" + me.pre + "dsn6sigma2fofc' value='' size=8> &sigma;</span><br/>";
        //html += me.htmlCls.inputFileStr + "id='" + me.pre + "dsn6file2fofc'><br>" + me.htmlCls.buttonStr + "reload_dsn6file2fofc' style='margin: 6px 20px 0 0;'>Load DSN6</button>" + me.htmlCls.buttonStr + "reload_ccp4file2fofc' style='margin: 6px 20px 0 0;'>Load CCP4</button>" + me.htmlCls.buttonStr + "reload_mtzfile2fofc' style='margin: 6px 20px 0 0;'>Load MTZ</button>" + me.htmlCls.buttonStr + "reload_rcsbmtzfile2fofc' style='margin-top: 6px;'>Load RCSB MTZ</button><br><br><br/>";
        html += me.htmlCls.inputFileStr + "id='" + me.pre + "dsn6file2fofc'><br>" + me.htmlCls.buttonStr + "reload_ccp4file2fofc' style='margin: 6px 20px 0 0;'>Load CCP4</button>" + me.htmlCls.buttonStr + "reload_mtzfile2fofc' style='margin: 6px 20px 0 0;'>Load MTZ</button>" + me.htmlCls.buttonStr + "reload_rcsbmtzfile2fofc' style='margin-top: 6px;'>Load RCSB MTZ</button><br><br><br/>";

        html += "<span style='white-space:nowrap;font-weight:bold;'>fofc contour at default threshold or at: "
          + me.htmlCls.inputTextStr + "id='" + me.pre + "dsn6sigmafofc' value='' size=8> &sigma;</span><br/>";

        //html += me.htmlCls.inputFileStr + "id='" + me.pre + "dsn6filefofc'><br>" + me.htmlCls.buttonStr + "reload_dsn6filefofc' style='margin: 6px 20px 0 0;'>Load DSN6</button>" + me.htmlCls.buttonStr + "reload_ccp4filefofc' style='margin: 6px 20px 0 0;'>Load CCP4</button>"  + me.htmlCls.buttonStr + "reload_mtzfilefofc' style='margin: 6px 20px 0 0;'>Load MTZ</button>"  + me.htmlCls.buttonStr + "reload_rcsbmtzfilefofc' style='margin-top: 6px;'>Load RCSB MTZ</button><br><br><br>";
        html += me.htmlCls.inputFileStr + "id='" + me.pre + "dsn6filefofc'><br>" + me.htmlCls.buttonStr + "reload_ccp4filefofc' style='margin: 6px 20px 0 0;'>Load CCP4</button>"  + me.htmlCls.buttonStr + "reload_mtzfilefofc' style='margin: 6px 20px 0 0;'>Load MTZ</button>"  + me.htmlCls.buttonStr + "reload_rcsbmtzfilefofc' style='margin-top: 6px;'>Load RCSB MTZ</button><br><br><br>";


        html += me.htmlCls.buttonStr + "elecmapNo4'>Remove Map</button><br>";

        html += "</div>";

        html += me.htmlCls.divStr + "dl_dsn6url' class='" + dialogClass + "' style='max-width:600px'>";
        html += this.addNotebookTitle('dl_dsn6url', 'Load a selection file via a URL');
        html += "<b>Note</b>: Always load a PDB file before loading map files. If you don't specify the threshold below, a default one will be chosen.<br/><br/><br/>";

        html += "<span style='white-space:nowrap;font-weight:bold;'>2fofc contour at default threshold or at: "
          + me.htmlCls.inputTextStr + "id='" + me.pre + "dsn6sigmaurl2fofc' value='' size=8> &sigma;</span><br/>";

        //html += "URL in the same host: " + me.htmlCls.inputTextStr + "id='" + me.pre + "dsn6fileurl2fofc' size=20><br>" + me.htmlCls.buttonStr + "reload_dsn6fileurl2fofc' style='margin: 6px 20px 0 0;'>Load DSN6</button>" + me.htmlCls.buttonStr + "reload_ccp4fileurl2fofc' style='margin: 6px 20px 0 0;'>Load CCP4</button>" + me.htmlCls.buttonStr + "reload_mtzfileurl2fofc' style='margin: 6px 20px 0 0;'>Load MTZ</button>" + me.htmlCls.buttonStr + "reload_rcsbmtzfileurl2fofc' style='margin-top: 6px;'>Load RCSB MTZ</button><br><br><br/>";

        html += "URL in the same host: " + me.htmlCls.inputTextStr + "id='" + me.pre + "dsn6fileurl2fofc' size=20><br>" + me.htmlCls.buttonStr + "reload_ccp4fileurl2fofc' style='margin: 6px 20px 0 0;'>Load CCP4</button>" + me.htmlCls.buttonStr + "reload_mtzfileurl2fofc' style='margin: 6px 20px 0 0;'>Load MTZ</button>" + me.htmlCls.buttonStr + "reload_rcsbmtzfileurl2fofc' style='margin-top: 6px;'>Load RCSB MTZ</button><br><br><br/>";

        html += "<span style='white-space:nowrap;font-weight:bold;'>fofc contour at default threshold or at: "
        + me.htmlCls.inputTextStr + "id='" + me.pre + "dsn6sigmaurlfofc' value='' size=8> &sigma;</span><br/>";

        //html += "URL in the same host: " + me.htmlCls.inputTextStr + "id='" + me.pre + "dsn6fileurlfofc' size=20><br>" + me.htmlCls.buttonStr + "reload_dsn6fileurlfofc' style='margin: 6px 20px 0 0;'>Load DSN6</button>" + me.htmlCls.buttonStr + "reload_ccp4fileurlfofc' style='margin: 6px 20px 0 0;'>Load CCP4</button>"  + me.htmlCls.buttonStr + "reload_mtzfileurlfofc' style='margin: 6px 20px 0 0;'>Load MTZ</button>"  + me.htmlCls.buttonStr + "reload_rcsbmtzfileurlfofc' style='margin-top: 6px;'>Load RCSB MTZ</button><br><br><br>";

        html += "URL in the same host: " + me.htmlCls.inputTextStr + "id='" + me.pre + "dsn6fileurlfofc' size=20><br>" + me.htmlCls.buttonStr + "reload_ccp4fileurlfofc' style='margin: 6px 20px 0 0;'>Load CCP4</button>"  + me.htmlCls.buttonStr + "reload_mtzfileurlfofc' style='margin: 6px 20px 0 0;'>Load MTZ</button>"  + me.htmlCls.buttonStr + "reload_rcsbmtzfileurlfofc' style='margin-top: 6px;'>Load RCSB MTZ</button><br><br><br>";

        html += me.htmlCls.buttonStr + "elecmapNo5'>Remove Map</button><br>";

        html += "</div>";

        html += me.htmlCls.divStr + "dl_clr' class='" + dialogClass + "'>";
        html += this.addNotebookTitle('dl_clr', 'Pick a color');
        html += "Click in the input box to use the color picker:<br><br> ";
        html += "Custom Color: " + me.htmlCls.inputTextStr + "id='" + me.pre + "colorcustom' value='FF0000' size=8> ";
        html += me.htmlCls.buttonStr + "applycustomcolor'>Apply</button>";
        html += "</div>";

        html += me.htmlCls.setHtmlCls.getPotentialHtml('delphi', dialogClass);

        html += me.htmlCls.setHtmlCls.getPotentialHtml('local', dialogClass);
        html += me.htmlCls.setHtmlCls.getPotentialHtml('url', dialogClass);

        html += me.htmlCls.divStr + "dl_symmetry' class='" + dialogClass + "'><br>";
        html += this.addNotebookTitle('dl_symmetry', 'Symmetry');
        html += me.htmlCls.divNowrapStr + "Symmetry: <select id='" + me.pre + "selectSymmetry'>";
        html += "</select>" + me.htmlCls.space3;
        html += me.htmlCls.buttonStr + "applysymmetry'>Apply</button>" + me.htmlCls.space3;
        html += me.htmlCls.buttonStr + "clearsymmetry'>Clear</button></div>";
        html += "</div>";

        html += me.htmlCls.divStr + "dl_symd' style='max-width:400px' class='" + dialogClass + "'><br>";
        html += this.addNotebookTitle('dl_symd', 'Dynamically symmetry calculation using SymD');

        html += "</div>";

        html += me.htmlCls.divStr + "dl_contact' class='" + dialogClass + "'>";
        html += this.addNotebookTitle('dl_contact', 'Contact Map');
        html += "<span style='white-space:nowrap;font-weight:bold;'>Distance: <select id='" + me.pre + "contactdist'>";
        html += me.htmlCls.setHtmlCls.getOptionHtml(['4', '5', '6', '7', '8', '9', '10'], 4);
        html += "</select></span>";
        html += "<span style='margin-left:30px; white-space:nowrap;font-weight:bold;'>Contact Type: <select id='" + me.pre + "contacttype'>";
        html += me.htmlCls.optionStr + "'calpha' >between C-alpha Atoms</option>";
        html += me.htmlCls.optionStr + "'cbeta' selected>between C-beta Atoms</option>";
        html += me.htmlCls.optionStr + "'heavyatoms' >between Heavy Atoms</option>";
        html += "</select></span><br><br>";
        html += "<span style='white-space:nowrap;'>" + me.htmlCls.buttonStr + "applycontactmap'>Display</button></span><br>";
        html += "</div>";

        html += me.htmlCls.divStr + "dl_hbonds' class='" + dialogClass + "'>";
        html += this.addNotebookTitle('dl_hbonds', 'Interaction Analysis');
        html += "1. Choose interaction types and their thresholds:<br>";
        html += "<div class='icn3d-box'><table border=0 width=450><tr>";
        html += "<td style='white-space:nowrap'>" + me.htmlCls.inputCheckStr + "id='" + me.pre + "analysis_hbond' checked>Hydrogen Bonds <span style='background-color:#" + me.htmlCls.hbondColor + "'>" + me.htmlCls.space3 + "</span></td>";
        html += "<td>";
        html += me.htmlCls.divNowrapStr + " <select id='" + me.pre + "hbondthreshold'>";

        let optArray2 = ['3.2', '3.3', '3.4', '3.5', '3.6', '3.7', '3.8', '3.9', '4.0', '4.1', '4.2'];
        html += me.htmlCls.setHtmlCls.getOptionHtml(optArray2, 6);

        html += "</select> &#197;" + me.htmlCls.space3 + "</div></td>";
        html += "<td style='white-space:nowrap'>" + me.htmlCls.inputCheckStr + "id='" + me.pre + "analysis_saltbridge' checked>Salt Bridge/Ionic <span style='background-color:#" + me.htmlCls.ionicColor + "'>" + me.htmlCls.space3 + "</span></td>";
        html += "<td>";
        html += me.htmlCls.divNowrapStr + " <select id='" + me.pre + "saltbridgethreshold'>";

        let optArray3 = ['3', '4', '5', '6', '7', '8'];
        html += me.htmlCls.setHtmlCls.getOptionHtml(optArray3, 3);

        html += "</select> &#197;" + me.htmlCls.space3 + "</div></td>";
        html += "<td style='white-space:nowrap'>" + me.htmlCls.inputCheckStr + "id='" + me.pre + "analysis_contact' checked>Contacts/Interactions <span style='background-color:#" + me.htmlCls.contactColor + "'>" + me.htmlCls.space3 + "</span></td>";
        html += "<td>";
        html += me.htmlCls.divNowrapStr + " <select id='" + me.pre + "contactthreshold'>";

        html += me.htmlCls.setHtmlCls.getOptionHtml(optArray3, 1);

        html += "</select> &#197;" + me.htmlCls.space3 + "</div></td>";
        html += "</tr>";

        html += "<tr>";
        html += "<td style='white-space:nowrap'>" + me.htmlCls.inputCheckStr + "id='" + me.pre + "analysis_halogen' checked>Halogen Bonds <span style='background-color:#" + me.htmlCls.halogenColor + "'>" + me.htmlCls.space3 + "</span></td>";
        html += "<td>";
        html += me.htmlCls.divNowrapStr + " <select id='" + me.pre + "halogenthreshold'>";

        html += me.htmlCls.setHtmlCls.getOptionHtml(optArray2, 6);

        html += "</select> &#197;" + me.htmlCls.space3 + "</div></td>";
        html += "<td style='white-space:nowrap'>" + me.htmlCls.inputCheckStr + "id='" + me.pre + "analysis_pication' checked>&pi;-Cation <span style='background-color:#" + me.htmlCls.picationColor + "'>" + me.htmlCls.space3 + "</span></td>";
        html += "<td>";
        html += me.htmlCls.divNowrapStr + " <select id='" + me.pre + "picationthreshold'>";

        html += me.htmlCls.setHtmlCls.getOptionHtml(optArray3, 3);

        html += "</select> &#197;" + me.htmlCls.space3 + "</div></td>";
        html += "<td style='white-space:nowrap'>" + me.htmlCls.inputCheckStr + "id='" + me.pre + "analysis_pistacking' checked>&pi;-Stacking <span style='background-color:#" + me.htmlCls.pistackingColor + "'>" + me.htmlCls.space3 + "</span></td>";
        html += "<td>";
        html += me.htmlCls.divNowrapStr + " <select id='" + me.pre + "pistackingthreshold'>";

        html += me.htmlCls.setHtmlCls.getOptionHtml(['3', '4', '5'], 99);

        html += me.htmlCls.optionStr + "'5.5' selected>5.5</option>";

        html += me.htmlCls.setHtmlCls.getOptionHtml(['6', '7', '8'], 99);

        html += "</select> &#197;" + me.htmlCls.space3 + "</div></td>";
        html += "</tr></table></div>";

        html += "<table border=0 width=400 cellspacing=10><tr><td>";

        html += me.htmlCls.divNowrapStr + "2. Select the first set:</div>";
        html += "<div style='text-indent:1.1em'><select style='max-width:200px' id='" + me.pre + "atomsCustomHbond2' multiple size='5' style='min-width:130px;'>";
        html += "</select></div>";

        html += "</td><td>";

        html += me.htmlCls.divNowrapStr + "3. Select the second set:</div>";
        html += "<div style='text-indent:1.1em'><select style='max-width:200px' id='" + me.pre + "atomsCustomHbond' multiple size='5' style='min-width:130px;'>";
        html += "</select></div>";

        html += "</td></tr></table>";
        
        html += "<div>4. " + me.htmlCls.buttonStr + "applyhbonds'>3D Display Interactions</button></div><br>";

        html += "<div style='text-indent:1.1em'>" + me.htmlCls.buttonStr + "hbondWindow'>Highlight Interactions in Table</button><span style='margin-left:30px; font-wieght:bold'>Sort Interactions on</span>: " + me.htmlCls.buttonStr + "sortSet1'> Set 1</button>" + me.htmlCls.buttonStr + "sortSet2' style='margin-left:12px'>Set 2</button></div><br>";

        html += "<div style='text-indent:1.1em'>" + me.htmlCls.buttonStr + "hbondLineGraph'>2D Interaction Network</button> " + me.htmlCls.buttonStr + "hbondLineGraph2' style='margin-left:12px'>2D Network with Reference Numbers</button> to show two lines of residue nodes</div><br>";

        html += "<div style='text-indent:1.1em'>" + me.htmlCls.buttonStr + "hbondScatterplot'>2D Interaction Map</button> " + me.htmlCls.buttonStr + "hbondScatterplot2' style='margin-left:12px'>2D Map with Reference Numbers</button> to show map</div><br>";

        html += "<div style='text-indent:1.1em'>" + me.htmlCls.buttonStr + "hbondLigplot'>2D Interaction for One Ligand/Residue</button> with atom details</div><br>";

        tmpStr = ': </td><td><input style="margin-left:-12px" type="text" id="';

        html += "<div style='text-indent:1.1em'>" + me.htmlCls.buttonStr + "hbondGraph'>2D Graph(Force-Directed)</button> to show interactions with strength parameters in 0-200:</div>";
        html += '<div style="text-indent:1.1em"><table><tr><td>Helix or Sheet' + tmpStr + me.pre + 'dist_ss" size="4" value="100"></td>';
        html += '<td>Coil or Nucleotide' + tmpStr + me.pre + 'dist_coil" size="4" value="50"></td>';
        html += '<td>Disulfide Bonds' + tmpStr + me.pre + 'dist_ssbond" size="4" value="50"></td></tr>';
        html += '<tr><td>Hydrogen Bonds' + tmpStr + me.pre + 'dist_hbond" size="4" value="50"></td>';
        html += '<td>Salt Bridge/Ionic' + tmpStr + me.pre + 'dist_ionic" size="4" value="50"></td>';
        html += '<td>Contacts' + tmpStr + me.pre + 'dist_inter" size="4" value="25"></td></tr>';
        html += '<tr><td>Halogen Bonds' + tmpStr + me.pre + 'dist_halogen" size="4" value="50"></td>';
        html += '<td>&pi;-Cation' + tmpStr + me.pre + 'dist_pication" size="4" value="50"></td>';
        html += '<td>&pi;-Stacking' + tmpStr + me.pre + 'dist_pistacking" size="4" value="50"></td></tr></table></div>';
        html += '<div style="text-indent:1.1em">(Note: you can also adjust thresholds at #1 to add/remove interactions.)</div><br>';

    //    html += "<div style='text-indent:1.1em'>" + me.htmlCls.buttonStr + "hbondExport'>Save</button> H-bond/contact pairs in a file</div><br>";
        html += "<div style='text-indent:1.1em'>" + me.htmlCls.buttonStr + "areaWindow'>Buried Surface Area</button></div><br>";

        html += "<div>5. " + me.htmlCls.buttonStr + "hbondReset'>Reset</button> and select new sets</div>";
        html += "</div>";

        html += me.htmlCls.divStr + "dl_realign' class='" + dialogClass + "'>";
        html += this.addNotebookTitle('dl_realign', 'Realign by sequence');

        html += me.htmlCls.divNowrapStr + "1. Select sets below <br>or use your current selection:</div><br>";
        html += "<div style='text-indent:1.1em'><select id='" + me.pre + "atomsCustomRealign' multiple size='5' style='min-width:130px;'>";
        html += "</select></div><br>";

        html += "<div>2. " + me.htmlCls.buttonStr + "applyRealign'>Realign by Sequence</button></div><br>";
        html += "</div>";

        html += me.htmlCls.divStr + "dl_realignbystruct' class='" + dialogClass + "' style='max-width:500px'>";
        html += this.addNotebookTitle('dl_realignbystruct', 'Realign by structure');

        //html += "<div><b>1</b>. There are two options to align chains. Option \"a\" is to select a list of chains below, and align all chains to the first chain. Option \"b\" is to select sets below or use your current selection, and align all chains pairwise.</div><br>";
        html += "<div><b>1</b>. Select sets below or use your current selection.</div><br>";
        html += "<div style='text-indent:1.1em'><select id='" + me.pre + "atomsCustomRealignByStruct' multiple size='5' style='min-width:130px;'>";
        html += "</select></div><br>";

        // some issues in aligning 4orz_C and 5esv_H due to insertion code
        //html += "<div><b>2a</b>. <div style='display:inline-block; width:170px'>Align to First Chain:</div> " + me.htmlCls.buttonStr + "applyRealignByStructMsa_tmalign'>Realign with TM-align</button>" + me.htmlCls.buttonStr + "applyRealignByStructMsa' style='margin-left:30px'>Realign with VAST</button></div><br>";

        //html += "<div>or <b>2b</b>. <div style='display:inline-block; width:155px'>Align All Chains Pairwise:</div> " + me.htmlCls.buttonStr + "applyRealignByStruct_tmalign'>Realign with TM-align</button>" + me.htmlCls.buttonStr + "applyRealignByStruct' style='margin-left:30px'>Realign with VAST</button></div><br>";
        html += "<div><b>2</b>. " + me.htmlCls.buttonStr + "applyRealignByStruct_tmalign'>Realign with TM-align</button>" + me.htmlCls.buttonStr + "applyRealignByStruct' style='margin-left:30px'>Realign with VAST</button></div><br>";

        html += "</div>";

        html += me.htmlCls.divStr + "dl_realigntwostru' class='" + dialogClass + "'>";
        html += this.addNotebookTitle('dl_realigntwostru', 'Realign two structure complexes');

        html += me.htmlCls.divNowrapStr + "1. Select sets below or use your current selection:</div><br>";
        html += "<div style='text-indent:1.1em'><select id='" + me.pre + "atomsCustomRealignByStruct2' multiple size='5' style='min-width:130px;'>";
        html += "</select></div><br>";

        html += "2. Overall maximum RMSD: " + me.htmlCls.inputTextStr + "id='" + me.pre + "maxrmsd' value='30' size='2'> &#197; <br><br>";

        html += "<div>3. " + me.htmlCls.buttonStr + "applyRealignByStruct_vastplus'>VAST+ Alignment based on TM-align</button></div><br>";
        html += "</div>";


        html += me.htmlCls.divStr + "dl_colorspectrumacrosssets' class='" + dialogClass + "'>";
        html += this.addNotebookTitle('dl_colorspectrumacrosssets', 'Set color spectrum across sets');

        html += me.htmlCls.divNowrapStr + "1. Select sets below:</div><br>";
        html += "<div style='text-indent:1.1em'><select id='" + me.pre + "atomsCustomColorSpectrumAcross' multiple size='5' style='min-width:130px;'>";
        html += "</select></div>";

        html += "<div>2. " + me.htmlCls.buttonStr + "applyColorSpectrumAcrossSets'>Spectrum Color for Sets</button></div><br>";
        html += "</div>";

        
        html += me.htmlCls.divStr + "dl_colorspectrumbysets' class='" + dialogClass + "'>";
        html += this.addNotebookTitle('dl_colorspectrumbysets', 'Set color spectrum for residues in sets');
        html += me.htmlCls.divNowrapStr + "1. Select sets below:</div><br>";
        html += "<div style='text-indent:1.1em'><select id='" + me.pre + "atomsCustomColorSpectrum' multiple size='5' style='min-width:130px;'>";
        html += "</select></div>";

        html += "<div>2. " + me.htmlCls.buttonStr + "applyColorSpectrumBySets'>Spectrum Color for Residues in Sets</button></div><br>";
        html += "</div>";

        
        html += me.htmlCls.divStr + "dl_colorrainbowacrosssets' class='" + dialogClass + "'>";
        html += this.addNotebookTitle('dl_colorrainbowacrosssets', 'Set color rainbow across sets');
        html += me.htmlCls.divNowrapStr + "1. Select sets below:</div><br>";
        html += "<div style='text-indent:1.1em'><select id='" + me.pre + "atomsCustomColorRainbowAcross' multiple size='5' style='min-width:130px;'>";
        html += "</select></div>";

        html += "<div>2. " + me.htmlCls.buttonStr + "applyColorRainbowAcrossSets'>Rainbow Color for Sets</button></div><br>";
        html += "</div>";


        html += me.htmlCls.divStr + "dl_colorrainbowbysets' class='" + dialogClass + "'>";
        html += this.addNotebookTitle('dl_colorrainbowbysets', 'Set color rainbow for residues in sets');
        html += me.htmlCls.divNowrapStr + "1. Select sets below:</div><br>";
        html += "<div style='text-indent:1.1em'><select id='" + me.pre + "atomsCustomColorRainbow' multiple size='5' style='min-width:130px;'>";
        html += "</select></div>";

        html += "<div>2. " + me.htmlCls.buttonStr + "applyColorRainbowBySets'>Rainbow Color for Residues in Sets</button></div><br>";
        html += "</div>";


        html += me.htmlCls.divStr + "dl_allinteraction' style='background-color:white' class='" + dialogClass + "'>";
        html += this.addNotebookTitle('dl_allinteraction', 'All interactions', true);
        html += "</div>";

        html += me.htmlCls.divStr + "dl_interactionsorted' style='background-color:white' class='" + dialogClass + "'>";
        html += this.addNotebookTitle('dl_interactionsorted', 'Sorted interactions', true);
        html += "</div>";

        html += me.htmlCls.divStr + "dl_linegraph' style='background-color:white' class='" + dialogClass + "'>";
        html += this.addNotebookTitle('dl_linegraph', '2D Interaction Network');

        html += me.htmlCls.divNowrapStr + '<div style="width:20px; margin-top:6px; display:inline-block;"><span id="'
          + me.pre + 'dl_linegraphcolor_expand" class="ui-icon ui-icon-plus icn3d-expand icn3d-link" style="display:none; width:15px;" title="Expand"></span><span id="'
          + me.pre + 'dl_linegraphcolor_shrink" class="ui-icon ui-icon-minus icn3d-shrink icn3d-link" style="width:15px;" title="Shrink"></span></div>';

        html += me.htmlCls.space2 + "Hold Ctrl key to select multiple nodes/lines.</div>";

        html += me.htmlCls.divStr + "dl_linegraphcolor' style='display:block;'>";

        html += me.htmlCls.setHtmlCls.setColorHints();

        html += "</div><br>";

        //let buttonStrTmp = '<button class="icn3d-commandTitle" style="-webkit-appearance:button; height:24px;background-color:#DDD;" id="';

        me.linegraphid = me.pre + 'linegraph';
        html += me.htmlCls.divNowrapStr + buttonStrTmp + me.linegraphid + '_svg">SVG</button>' + me.htmlCls.space2;
        html += buttonStrTmp + me.linegraphid + '_png">PNG</button>' + me.htmlCls.space2;
        html += buttonStrTmp + me.linegraphid + '_json">JSON</button>' + me.htmlCls.space4;
        html += "<b>Scale</b>: <select id='" + me.linegraphid + "_scale'>";

        let optArray4 = ['0.1', '0.2', '0.4', '0.6', '0.8', '1', '2', '4', '6', '8', '10'];
        html += me.htmlCls.setHtmlCls.getOptionHtml(optArray4, 5);

        html += "</select></div><br>";
        html += '<div id="' + me.pre + 'linegraphDiv"></div>';

        html += "</div>";

        html += me.htmlCls.divStr + "dl_scatterplot' style='background-color:white' class='" + dialogClass + "'>";
        html += this.addNotebookTitle('dl_scatterplot', '2D Interaction Map');

        html += me.htmlCls.divNowrapStr + "Hold Ctrl key to select multiple nodes." + me.htmlCls.space3;

        html += '<div style="width:20px; margin-top:6px; display:inline-block;"><span id="'
          + me.pre + 'dl_scatterplotcolor_expand" class="ui-icon ui-icon-plus icn3d-expand icn3d-link" style="width:15px;" title="Expand"></span><span id="'
          + me.pre + 'dl_scatterplotcolor_shrink" class="ui-icon ui-icon-minus icn3d-shrink icn3d-link" style="display:none; width:15px;" title="Shrink"></span></div></div>';
        html += me.htmlCls.divStr + "dl_scatterplotcolor' style='display:none;'>";

        html += me.htmlCls.setHtmlCls.setColorHints();

        html += "</div>";

        me.scatterplotid = me.pre + 'scatterplot';
        html += me.htmlCls.divNowrapStr + buttonStrTmp + me.scatterplotid + '_svg">SVG</button>' + me.htmlCls.space2;
        html += buttonStrTmp + me.scatterplotid + '_png">PNG</button>' + me.htmlCls.space2;
        html += buttonStrTmp + me.scatterplotid + '_json">JSON</button>' + me.htmlCls.space4;
        html += "<b>Scale</b>: <select id='" + me.scatterplotid + "_scale'>";

        html += me.htmlCls.setHtmlCls.getOptionHtml(optArray4, 5);

        html += "</select></div><br>";
        html += '<div id="' + me.pre + 'scatterplotDiv"></div>';

        html += "</div>";


        html += me.htmlCls.divStr + "dl_ligplot' style='background-color:white' class='" + dialogClass + "'>";

        if(me.cfg.cid !== undefined || me.cfg.smiles !== undefined) {
            html += this.addNotebookTitle('dl_ligplot', '2D Depiction for Chemicals');
        }
        else {
            html += this.addNotebookTitle('dl_ligplot', '2D Interaction for One Ligand/Residue with Atom Details');

            html += me.htmlCls.divNowrapStr + "<b>Note</b>: Nodes/Residues can be dragged. Both nodes and dashed lines/interactions can be clicked to select residues. " + me.htmlCls.space3;

            html += '<div style="width:20px; margin-top:6px; display:inline-block;"><span id="'
            + me.pre + 'dl_ligplotcolor_expand" class="ui-icon ui-icon-plus icn3d-expand icn3d-link" style="display:none; width:15px;" title="Expand"></span><span id="'
            + me.pre + 'dl_ligplotcolor_shrink" class="ui-icon ui-icon-minus icn3d-shrink icn3d-link" style="width:15px;" title="Shrink"></span></div></div>';

            html += me.htmlCls.divStr + "dl_ligplotcolor' style='inline-block;'>";

            // html += "The real interaction distances are not in scale, and are about twice the distances of dashed line segments.<br>Some \"Contact\" lines are only shown partially to simplify the view.<br>";
            // html += "Mouseover the dashed lines to see interaction types and distances.<br>";
            html += "<b>Color legend</b> for interactions (dashed lines): <br>";

            html += me.htmlCls.setHtmlCls.setColorHints();

            html += "<br></div>";
        }

        me.ligplotid = me.pre + 'ligplot';
        html += me.htmlCls.divNowrapStr + buttonStrTmp + me.ligplotid + '_svg">SVG</button>' + me.htmlCls.space2;
        html += buttonStrTmp + me.ligplotid + '_png">PNG</button>' + me.htmlCls.space2;
        // html += buttonStrTmp + me.ligplotid + '_json">JSON</button>' + me.htmlCls.space4;
        html += "<b>Scale</b>: <select id='" + me.ligplotid + "_scale'>";

        html += me.htmlCls.setHtmlCls.getOptionHtml(optArray4, 5);

        html += "</select></div><br>";
        html += '<div id="' + me.pre + 'ligplotDiv"></div>';

        html += "</div>";



        html += me.htmlCls.divStr + "dl_contactmap' style='background-color:white' class='" + dialogClass + "'>";
        html += this.addNotebookTitle('dl_contactmap', 'Contact Map');

        html += me.htmlCls.divNowrapStr + "Hold Ctrl key to select multiple nodes." + me.htmlCls.space3 + "</div>";

        me.contactmapid = me.pre + 'contactmap';
        html += me.htmlCls.divNowrapStr + buttonStrTmp + me.contactmapid + '_svg">SVG</button>' + me.htmlCls.space2;
        html += buttonStrTmp + me.contactmapid + '_png">PNG</button>' + me.htmlCls.space2;
        html += buttonStrTmp + me.contactmapid + '_json">JSON</button>' + me.htmlCls.space4;
        html += "<b>Scale</b>: <select id='" + me.contactmapid + "_scale'>";

        let optArray5 = ['0.01', '0.02', '0.04', '0.06', '0.08', '0.1', '0.2', '0.4', '0.6', '0.8', '1'];
        html += me.htmlCls.setHtmlCls.getOptionHtml(optArray5, 10);

        html += "</select></div><br>";
        html += '<div id="' + me.pre + 'contactmapDiv"></div>';

        html += "</div>";

        html += me.htmlCls.divStr + "dl_alignerrormap' style='background-color:white' class='" + dialogClass + "'>";
        html += this.addNotebookTitle('dl_alignerrormap', 'PAE Map');

        html += me.htmlCls.divNowrapStr + "Hold Ctrl key to select multiple nodes." + me.htmlCls.space3 + "</div>";
      
        me.alignerrormapid = me.pre + 'alignerrormap';
        html += me.htmlCls.divNowrapStr + buttonStrTmp + me.alignerrormapid + '_svg">SVG</button>' + me.htmlCls.space2;
        html += buttonStrTmp + me.alignerrormapid + '_png">PNG (slow)</button>' + me.htmlCls.space2;
        html += buttonStrTmp + me.alignerrormapid + '_json">JSON</button>' + me.htmlCls.space4;
        html += '<b>Scale</b>: <select id="' + me.alignerrormapid + '_scale">';

        //let optArray5 = ['0.01', '0.02', '0.04', '0.06', '0.08', '0.1', '0.2', '0.4', '0.6', '0.8', '1'];
        html += me.htmlCls.setHtmlCls.getOptionHtml(optArray5, 2);

        html += "</select></div><br>";

        //min: 004d00, max: FFFFFF
        let startColorStr = '#004d00';
        let endColorStr = '#FFFFFF';
        let rangeStr = startColorStr + ' 0%, ' + endColorStr + ' 100%';

        html += "<div style='width:200px'><div style='height: 12px; border: 1px solid #000; background: linear-gradient(to right, " + rangeStr + ");'></div>";
        html += "<table width='100%' border='0' cellspacing='0' cellpadding='0'><tr><td width='15%'>0</td><td width='15%'>5</td><td width='15%'>10</td><td width='15%'>15</td><td width='15%'>20</td><td width='15%'>25</td><td>30</td></tr><tr><td colspan='7' align='center'>Expected position error (Angstroms)</td></tr></table></div><br>";
  
        html += '<div id="' + me.pre + 'alignerrormapDiv"></div>';

        html += "</div>";

        html += me.htmlCls.divStr + "dl_elecmap2fofc' class='" + dialogClass + "'>";
        html += this.addNotebookTitle('dl_elecmap2fofc', 'Electron Density 2F0-Fc Map');
        html += "<span style='white-space:nowrap;font-weight:bold;'>Contour at: <select id='" + me.pre + "sigma2fofc'>";

        let optArray1 = ['0', '0.5', '1', '1.5', '2', '3', '4', '5', '6', '7', '8', '9', '10'];
        html += me.htmlCls.setHtmlCls.getOptionHtml(optArray1, 3);

        html += "</select> &sigma;</span> <span style='white-space:nowrap; margin-left:30px;'>" + me.htmlCls.buttonStr + "applymap2fofc'>Display</button></span> <span style='white-space:nowrap; margin-left:30px;'>" + me.htmlCls.buttonStr + "elecmapNo2'>Remove Map</button></span>";
        html += "</div>";

        html += me.htmlCls.divStr + "dl_elecmapfofc' class='" + dialogClass + "'>";
        html += this.addNotebookTitle('dl_elecmapfofc', 'Electron Density F0-Fc Map');
        html += "<span style='white-space:nowrap;font-weight:bold;'>Contour at: <select id='" + me.pre + "sigmafofc'>";

        html += me.htmlCls.setHtmlCls.getOptionHtml(optArray1, 5);

        html += "</select> &sigma;</span> <span style='white-space:nowrap; margin-left:30px;'>" + me.htmlCls.buttonStr + "applymapfofc'>Display</button></span> <span style='white-space:nowrap; margin-left:30px;'>" + me.htmlCls.buttonStr + "elecmapNo3'>Remove Map</button></span>";
        html += "</div>";

        html += me.htmlCls.divStr + "dl_emmap' class='" + dialogClass + "'>";
        html += this.addNotebookTitle('dl_emmap', 'EM Density Map');
        html += "<span style='white-space:nowrap;font-weight:bold;'>Contour at: <select id='" + me.pre + "empercentage'>";

        html += me.htmlCls.setHtmlCls.getOptionHtml(['0', '10', '20', '30', '40', '50', '60', '70', '80', '90', '100'], 3);

        html += "</select> % of maximum EM values</span><br><span style='white-space:nowrap; margin-left:30px;'>" + me.htmlCls.buttonStr + "applyemmap'>Display</button></span> <span style='white-space:nowrap; margin-left:30px;'>" + me.htmlCls.buttonStr + "emmapNo2'>Remove EM Map</button></span>";
        html += "</div>";

        html += me.htmlCls.divStr + "dl_aroundsphere' class='" + dialogClass + "'>";
        html += this.addNotebookTitle('dl_aroundsphere', 'Select a sphere around a set of residues');
        html += me.htmlCls.divNowrapStr + "1. Select the first set:</div>";
        html += "<div style='text-indent:1.1em'><select id='" + me.pre + "atomsCustomSphere2' multiple size='3' style='min-width:130px;'>";
        html += "</select></div><br>";
        html += me.htmlCls.divNowrapStr + "2. Sphere with a radius: " + me.htmlCls.inputTextStr + "id='" + me.pre + "radius_aroundsphere' value='4' size='2'> &#197;</div><br/>";

        html += me.htmlCls.divNowrapStr + "3. Select the second set to apply the sphere:</div>";
        html += "<div style='text-indent:1.1em'><select id='" + me.pre + "atomsCustomSphere' multiple size='3' style='min-width:130px;'>";
        html += "</select></div><br>";

        html += me.htmlCls.divNowrapStr + "4. " + me.htmlCls.buttonStr + "applypick_aroundsphere'>Display</button> the sphere around the first set of atoms</div><br>";
        html += "<div style='text-indent:1.1em'>" + me.htmlCls.buttonStr + "sphereExport'>Save</button> interacting/contacting residue pairs in a file</div>";
        html += "</div>";

        html += me.htmlCls.divStr + "dl_adjustmem' class='" + dialogClass + "'>";
        html += this.addNotebookTitle('dl_adjustmem', 'Adjust membranes');
        html += "<b>Note</b>: The membranes are parallel to the X-Y plane. The center of the membranes is at Z = 0. <br/><br/>";
        html += me.htmlCls.divNowrapStr + "1. Extracellular membrane Z-axis position: " + me.htmlCls.inputTextStr + "id='" + me.pre + "extra_mem_z' value='' size='3'> &#197;</div><br/>";
        html += me.htmlCls.divNowrapStr + "2. intracellular membrane Z-axis position: " + me.htmlCls.inputTextStr + "id='" + me.pre + "intra_mem_z' value='' size='3'> &#197;</div><br/>";
        html += me.htmlCls.divNowrapStr + "3. " + me.htmlCls.buttonStr + "apply_adjustmem'>Display</button> the adjusted membranes</div><br>";
        html += "</div>";

        html += me.htmlCls.divStr + "dl_selectplane' class='" + dialogClass + "'>";
        html += this.addNotebookTitle('dl_selectplane', 'Select a plane');
        html += "<b>Note</b>: The membranes are parallel to the X-Y plane. The center of the membranes is at Z = 0. <br/><br/>";
        html += me.htmlCls.divNowrapStr + "1. Z-axis position of the first X-Y plane: " + me.htmlCls.inputTextStr + "id='" + me.pre + "selectplane_z1' value='15' size='3'> &#197;</div><br/>";
        html += me.htmlCls.divNowrapStr + "2. Z-axis position of the second X-Y plane: " + me.htmlCls.inputTextStr + "id='" + me.pre + "selectplane_z2' value='-15' size='3'> &#197;</div><br/>";
        html += me.htmlCls.divNowrapStr + "3. " + me.htmlCls.buttonStr + "apply_selectplane'>Save</button> the region between the planes to Defined Sets</div><br>";
        html += "</div>";

        html += me.htmlCls.divStr + "dl_addlabel' class='" + dialogClass + "'>";
        html += this.addNotebookTitle('dl_addlabel', 'Add labels between two atoms');
        html += "1. Text: " + me.htmlCls.inputTextStr + "id='" + me.pre + "labeltext' value='Text' size=4><br/>";
        html += "2. Size: " + me.htmlCls.inputTextStr + "id='" + me.pre + "labelsize' value='18' size=4 maxlength=2><br/>";
        html += "3. Color: " + me.htmlCls.inputTextStr + "id='" + me.pre + "labelcolor' value='" + defaultColor + "' size=4><br/>";
        //html += "4. Background: " + me.htmlCls.inputTextStr + "id='" + me.pre + "labelbkgd' value='' size=4><br/>";
        if(me.utilsCls.isMobile()) {
            html += me.htmlCls.spanNowrapStr + "4. Touch TWO atoms</span><br/>";
        }
        else {
            html += me.htmlCls.spanNowrapStr + "4. Pick TWO atoms while holding \"Alt\" key</span><br/>";
        }
        html += me.htmlCls.spanNowrapStr + "5. " + me.htmlCls.buttonStr + "applypick_labels'>Display</button></span>";
        html += "</div>";

        html += me.htmlCls.divStr + "dl_addlabelselection' class='" + dialogClass + "'>";
        html += this.addNotebookTitle('dl_addlabelselection', 'Add labels for your selection');
        html += "1. Text: " + me.htmlCls.inputTextStr + "id='" + me.pre + "labeltext2' value='Text' size=4><br/>";
        html += "2. Size: " + me.htmlCls.inputTextStr + "id='" + me.pre + "labelsize2' value='18' size=4 maxlength=2><br/>";
        html += "3. Color: " + me.htmlCls.inputTextStr + "id='" + me.pre + "labelcolor2' value='" + defaultColor + "' size=4><br/>";
        //html += "4. Background: " + me.htmlCls.inputTextStr + "id='" + me.pre + "labelbkgd2' value='' size=4><br/>";
        html += me.htmlCls.spanNowrapStr + "4. " + me.htmlCls.buttonStr + "applyselection_labels'>Display</button></span>";
        html += "</div>";

        html += me.htmlCls.divStr + "dl_labelColor' class='" + dialogClass + "'>";
        html += this.addNotebookTitle('dl_labelColor', 'Change label color');
        html += "Color for all labels: " + me.htmlCls.inputTextStr + "id='" + me.pre + "labelcolorall' value='" + defaultColor + "' size=4><br/><br/>";
        html += me.htmlCls.spanNowrapStr + me.htmlCls.buttonStr + "applylabelcolor'>Display</button></span>";
        html += "</div>";

        html += me.htmlCls.divStr + "dl_distance' class='" + dialogClass + "'>";
        html += this.addNotebookTitle('dl_distance', 'Measure distance');
        if(me.utilsCls.isMobile()) {
            html += me.htmlCls.spanNowrapStr + "1. Touch TWO atoms</span><br/>";
        }
        else {
            html += me.htmlCls.spanNowrapStr + "1. Pick TWO atoms while holding \"Alt\" key</span><br/>";
        }
        html += me.htmlCls.spanNowrapStr + "2. Line Color: " + me.htmlCls.inputTextStr + "id='" + me.pre + "distancecolor' value='" + defaultColor + "' size=4><br/>";
        html += me.htmlCls.spanNowrapStr + "3. " + me.htmlCls.buttonStr + "applypick_measuredistance'>Display</button></span>";
        html += "</div>";

        html += me.htmlCls.divStr + "dl_stabilizer' class='" + dialogClass + "'>";
        html += this.addNotebookTitle('dl_stabilizer', 'Add a stabilizer');
        if(me.utilsCls.isMobile()) {
            html += me.htmlCls.spanNowrapStr + "1. Touch TWO atoms</span><br/>";
        }
        else {
            html += me.htmlCls.spanNowrapStr + "1. Pick TWO atoms while holding \"Alt\" key</span><br/>";
        }
        html += me.htmlCls.spanNowrapStr + "2. Color: " + me.htmlCls.inputTextStr + "id='" + me.pre + "stabilizercolor' value='ffffff' size=4><br/>";
        html += me.htmlCls.spanNowrapStr + "3. " + me.htmlCls.buttonStr + "applypick_stabilizer'>Add</button></span>";
        html += "</div>";

        html += me.htmlCls.divStr + "dl_disttwosets' class='" + dialogClass + "'>";
        html += this.addNotebookTitle('dl_disttwosets', 'Measure the distance between two sets');
        html += me.htmlCls.spanNowrapStr + "1. Select two sets</span><br/>";
        html += "<table border=0 width=400 cellspacing=10><tr><td>";

        html += me.htmlCls.divNowrapStr + "First set:</div>";
        html += "<div style='text-indent:1.1em'><select style='max-width:200px' id='" + me.pre + "atomsCustomDist2' multiple size='5' style='min-width:130px;'>";
        html += "</select></div>";

        html += "</td><td>";

        html += me.htmlCls.divNowrapStr + "Second set:</div>";
        html += "<div style='text-indent:1.1em'><select style='max-width:200px' id='" + me.pre + "atomsCustomDist' multiple size='5' style='min-width:130px;'>";
        html += "</select></div>";

        html += "</td></tr></table>";

        html += me.htmlCls.spanNowrapStr + "2. Color: " + me.htmlCls.inputTextStr + "id='" + me.pre + "distancecolor2' value='" + defaultColor + "' size=4><br/><br/>";
        html += me.htmlCls.spanNowrapStr + "3. " + me.htmlCls.buttonStr + "applydist2'>Display</button></span>";
        html += "</div>";

        
        html += me.htmlCls.divStr + "dl_linebtwsets' class='" + dialogClass + "'>";
        html += this.addNotebookTitle('dl_linebtwsets', 'Add a line between  two sets');
        html += me.htmlCls.spanNowrapStr + "1. Select two sets</span><br/>";
        html += "<table border=0 width=400 cellspacing=10><tr><td>";

        html += me.htmlCls.divNowrapStr + "First set:</div>";
        html += "<div style='text-indent:1.1em'><select style='max-width:200px' id='" + me.pre + "linebtwsets2' multiple size='5' style='min-width:130px;'>";
        html += "</select></div>";

        html += "</td><td>";

        html += me.htmlCls.divNowrapStr + "Second set:</div>";
        html += "<div style='text-indent:1.1em'><select style='max-width:200px' id='" + me.pre + "linebtwsets' multiple size='5' style='min-width:130px;'>";
        html += "</select></div>";

        html += "</td></tr></table>";

        html += me.htmlCls.divNowrapStr + "2. Line style: <select id='" + me.pre + "linebtwsets_style'>";
        html += me.htmlCls.setHtmlCls.getOptionHtml(['Solid', 'Dashed'], 0);
        html += "</select></div><br>";

        html += "3. Line radius: " + me.htmlCls.inputTextStr + "id='" + me.pre + "linebtwsets_radius' value='0.4' size=4><br/><br/>";
        
        html += "4. Color: " + me.htmlCls.inputTextStr + "id='" + me.pre + "linebtwsets_customcolor' value='" + defaultColor + "' size=4><br/><br/>";

        html += me.htmlCls.divNowrapStr + "5. Opacity: <select id='" + me.pre + "linebtwsets_opacity'>";
        html += me.htmlCls.setHtmlCls.getOptionHtml(['1.0', '0.9', '0.8', '0.7', '0.6', '0.5', '0.4', '0.3', '0.2', '0.1'], 7);
        html += "</select></div><br>";

        html += me.htmlCls.spanNowrapStr + "6. " + me.htmlCls.buttonStr + "applylinebtwsets'>Display</button></span>";
        html += me.htmlCls.space3 + me.htmlCls.spanNowrapStr + me.htmlCls.buttonStr + "clearlinebtwsets'>Clear</button></span>";
        html += "</div>";


        html += me.htmlCls.divStr + "dl_cartoonshape' class='" + dialogClass + "'>";
        html += this.addNotebookTitle('dl_cartoonshape', 'Cartoon Shape');
        html += me.htmlCls.spanNowrapStr + "1. Select a set:</span><br/>";
        html += "<div style='text-indent:1.1em'><select style='max-width:200px' id='" + me.pre + "cartoonshape' multiple size='5' style='min-width:130px;'>";
        html += "</select></div><br>";

        html += me.htmlCls.divNowrapStr + "2. Shape: <select id='" + me.pre + "cartoonshape_shape'>";
        html += me.htmlCls.setHtmlCls.getOptionHtml(['Sphere', 'Cube'], 0);
        html += "</select></div><br>";

        html += "3. Radius: " + me.htmlCls.inputTextStr + "id='" + me.pre + "cartoonshape_radius' value='1.5' size=4><br/><br/>";
        
        html += "4. Color: " + me.htmlCls.inputTextStr + "id='" + me.pre + "cartoonshape_customcolor' value='" + defaultColor + "' size=4><br/><br/>";

        html += me.htmlCls.divNowrapStr + "5. Opacity: <select id='" + me.pre + "cartoonshape_opacity'>";
        html += me.htmlCls.setHtmlCls.getOptionHtml(['1.0', '0.9', '0.8', '0.7', '0.6', '0.5', '0.4', '0.3', '0.2', '0.1'], 7);
        html += "</select></div><br>";
        
        html += me.htmlCls.spanNowrapStr + "6. " + me.htmlCls.buttonStr + "applycartoonshape'>Display</button></span>";
        html += me.htmlCls.space3 + me.htmlCls.spanNowrapStr + me.htmlCls.buttonStr + "clearcartoonshape'>Clear</button></span>";
        html += "</div>";


        html += me.htmlCls.divStr + "dl_distmanysets' class='" + dialogClass + "'>";
        html += this.addNotebookTitle('dl_distmanysets', 'Measure distances among many sets');
        html += me.htmlCls.spanNowrapStr + "1. Select sets for pairwise distances</span><br/>";
        html += "<table border=0 width=400 cellspacing=10><tr><td>";

        html += me.htmlCls.divNowrapStr + "First sets:</div>";
        html += "<div style='text-indent:1.1em'><select style='max-width:200px' id='" + me.pre + "atomsCustomDistTable2' multiple size='5' style='min-width:130px;'>";
        html += "</select></div>";

        html += "</td><td>";

        html += me.htmlCls.divNowrapStr + "Second sets:</div>";
        html += "<div style='text-indent:1.1em'><select style='max-width:200px' id='" + me.pre + "atomsCustomDistTable' multiple size='5' style='min-width:130px;'>";
        html += "</select></div>";

        html += "</td></tr></table>";

        html += me.htmlCls.spanNowrapStr + "2. " + me.htmlCls.buttonStr + "applydisttable'>Distances in Table</button></span>";
        html += "</div>";


        html += me.htmlCls.divStr + "dl_anglemanysets' class='" + dialogClass + "' style='max-width:500px'>";
        html += this.addNotebookTitle('dl_anglemanysets', 'Measure angles among many sets');
        html += me.htmlCls.spanNowrapStr + "Note: Each set is represented by a vector, which is the X-axis of the principle axes. The angles between the vectors are then calculated.<br/><br/>";
        html += me.htmlCls.spanNowrapStr + "1. Select sets for pairwise angles</span><br/>";
        html += "<table border=0 width=400 cellspacing=10><tr><td>";

        html += me.htmlCls.divNowrapStr + "First sets:</div>";
        html += "<div style='text-indent:1.1em'><select style='max-width:200px' id='" + me.pre + "atomsCustomAngleTable2' multiple size='5' style='min-width:130px;'>";
        html += "</select></div>";

        html += "</td><td>";

        html += me.htmlCls.divNowrapStr + "Second sets:</div>";
        html += "<div style='text-indent:1.1em'><select style='max-width:200px' id='" + me.pre + "atomsCustomAngleTable' multiple size='5' style='min-width:130px;'>";
        html += "</select></div>";

        html += "</td></tr></table>";

        html += me.htmlCls.spanNowrapStr + "2. " + me.htmlCls.buttonStr + "applyangletable'>Angles in Table</button></span>";
        html += "</div>";


        html += me.htmlCls.divStr + "dl_stabilizer_rm' class='" + dialogClass + "'>";
        html += this.addNotebookTitle('dl_stabilizer_rm', 'Remove a stabilizer');
        if(me.utilsCls.isMobile()) {
            html += me.htmlCls.spanNowrapStr + "1. Touch TWO atoms</span><br/>";
        }
        else {
            html += me.htmlCls.spanNowrapStr + "1. Pick TWO atoms while holding \"Alt\" key</span><br/>";
        }
        html += me.htmlCls.spanNowrapStr + "2. " + me.htmlCls.buttonStr + "applypick_stabilizer_rm'>Remove</button></span>";
        html += "</div>";

        html += me.htmlCls.divStr + "dl_thickness' class='" + dialogClass + "'>";
        html += this.addNotebookTitle('dl_thickness', 'Set thickness');
        html += me.htmlCls.setHtmlCls.setThicknessHtml('3dprint');
        html += "</div>";

        html += me.htmlCls.divStr + "dl_thickness2' class='" + dialogClass + "'>";
        html += this.addNotebookTitle('dl_thickness2', 'Set thickness');
        html += me.htmlCls.setHtmlCls.setThicknessHtml('style');
        html += "</div>";

        html += me.htmlCls.divStr + "dl_menupref' class='" + dialogClass + "'>";
        html += this.addNotebookTitle('dl_menupref', 'Preferences for menus');
        html += "<b>Note</b>: The following parameters will be saved in cache. You just need to set them once. <br><br>";

        html += me.htmlCls.spanNowrapStr + "" + me.htmlCls.buttonStr + "apply_menupref'>Apply</button></span>";
        html += me.htmlCls.spanNowrapStr + "" + me.htmlCls.buttonStr + "reset_menupref' style='margin-left:30px'>Reset to Simple Menus</button></span>";
        html += me.htmlCls.spanNowrapStr + "" + me.htmlCls.buttonStr + "reset_menupref_all' style='margin-left:30px'>Reset to All Menus</button></span>";
        html += me.htmlCls.spanNowrapStr + "" + me.htmlCls.buttonStr + "savepref' style='margin-left:30px'>Save Preferences</button></span>";
        html += me.htmlCls.spanNowrapStr + "" + me.htmlCls.buttonStr + "loadpref' style='margin-left:30px'>Load Preferences</button></span><br><br>";

        html += "<div id='" + me.pre + "menulist'></div><br><br>";
        html += me.htmlCls.spanNowrapStr + "" + me.htmlCls.buttonStr + "apply_menupref2'>Apply</button></span>";
        html += me.htmlCls.spanNowrapStr + "" + me.htmlCls.buttonStr + "reset_menupref2' style='margin-left:30px'>Reset to Simple Menus</button></span>";
        html += me.htmlCls.spanNowrapStr + "" + me.htmlCls.buttonStr + "reset_menupref_all2' style='margin-left:30px'>Reset to All Menus</button></span>";
        html += me.htmlCls.spanNowrapStr + "" + me.htmlCls.buttonStr + "savepref2' style='margin-left:30px'>Save Preferences</button></span>";
        html += me.htmlCls.spanNowrapStr + "" + me.htmlCls.buttonStr + "loadpref2' style='margin-left:30px'>Load Preferences</button></span>";
        html += "</div>";

        html += me.htmlCls.divStr + "dl_addtrack' class='" + dialogClass + "'>";
        html += this.addNotebookTitle('dl_addtrack', 'Add a track');
        html += " <input type='hidden' id='" + me.pre + "track_chainid' value=''>";

        html += me.htmlCls.divStr + "dl_addtrack_tabs' style='border:0px;'>";
        html += "<ul>";
        html += "<li><a href='#" + me.pre + "tracktab2c'>Isoforms & Exons</a></li>";
        html += "<li><a href='#" + me.pre + "tracktab2b'>MSA</a></li>";
        html += "<li><a href='#" + me.pre + "tracktab1'>NCBI gi/Accession</a></li>";
        html += "<li><a href='#" + me.pre + "tracktab2'>FASTA</a></li>";
        html += "<li><a href='#" + me.pre + "tracktab3'>BED File</a></li>";
        html += "<li><a href='#" + me.pre + "tracktab4'>Custom</a></li>";
        html += "<li><a href='#" + me.pre + "tracktab5'>Current Selection</a></li>";
        html += "</ul>";
        html += me.htmlCls.divStr + "tracktab1'>";
        html += "NCBI gi/Accession: " + me.htmlCls.inputTextStr + "id='" + me.pre + "track_gi' placeholder='gi' size=16> <br><br>";
        html += me.htmlCls.buttonStr + "addtrack_button1'>Add Track</button>";
        html += "</div>";
        html += me.htmlCls.divStr + "tracktab2'>";
        html += "FASTA Title: " + me.htmlCls.inputTextStr + "id='" + me.pre + "fasta_title' placeholder='track title' size=16> <br><br>";
        html += "FASTA sequence: <br><textarea id='" + me.pre + "track_fasta' rows='5' style='width: 100%; height: " +(2*me.htmlCls.LOG_HEIGHT) + "px; padding: 0px; border: 0px;'></textarea><br><br>";
        html += me.htmlCls.buttonStr + "addtrack_button2'>Add Track</button>";
        html += "</div>";

        html += me.htmlCls.divStr + "tracktab2b'>";
        // html += "<div style='width:600px'>The full protein sequences with gaps are listed one by one. The sequence of the structure is listed at the top. If there are non-gap residues(e.g., from RefSeq) outside of the sequence of the structure, please remove them. Each sequence has a title line starting with \">\".</div><br>";
        html += "<div style='width:600px'>Note: The full protein sequences with gaps in MSA are listed one by one. The sequence of the structure is listed at the top. Each sequence has a title line starting with \">\".</div><br>";

        html += "<b>Precalculated Multiple Sequence Alignment (MSA)</b>:<br>";
        html += "<textarea id='" + me.pre + "track_fastaalign' rows='5' style='width: 100%; height: " +(2*me.htmlCls.LOG_HEIGHT) + "px; padding: 0px; border: 0px;'></textarea><br><br>";

        // html += "<b>Opion 1. Precalculated Multiple Sequence Alignment (MSA)</b>:<br>";
        // html += "<textarea id='" + me.pre + "track_fastaalign' rows='5' style='width: 100%; height: " +(2*me.htmlCls.LOG_HEIGHT) + "px; padding: 0px; border: 0px;'></textarea><br><br>";
        // html += "<b>Opion 2. NCBI Protein Accessions</b>: "+ me.htmlCls.inputTextStr + "id='" + me.pre + "track_acclist' size=60> <br><br>";
        html += "<b>Position of the first residue in Sequences & Annotations window</b>: " + me.htmlCls.inputTextStr + "id='" + me.pre + "fasta_startpos' value='1' size=2> <br><br>";

        html += "Color Sequence by: <select id='" + me.pre + "colorseqby'>";
        html += me.htmlCls.optionStr + "'identity' selected>Identity</option>";
        html += me.htmlCls.optionStr + "'conservation'>Conservation</option>";
        html += "</select> <br><br>";

        html += me.htmlCls.buttonStr + "addtrack_button2b'>Add Track(s)</button>";
        html += "</div>";

        html += me.htmlCls.divStr + "tracktab2c'>";
        html += "<div style='width:500px'>Note: Show exons for all isoforms of the protein in the same gene as specified below.</div><br>";

        html += "<b><a href='https://www.ncbi.nlm.nih.gov/gene' target='_blank'>NCBI Gene</a> ID</b>: "+ me.htmlCls.inputTextStr + "id='" + me.pre + "track_geneid' size=20>" + me.htmlCls.space3 + me.htmlCls.buttonStr + "exons_table'>Exons & Introns in Gene Table</button><br><br>";

        html += "<b>Position of the first residue in Sequences & Annotations window</b>: " + me.htmlCls.inputTextStr + "id='" + me.pre + "fasta_startpos2' value='1' size=2> <br><br>";

        // html += "Color Sequence by: <select id='" + me.pre + "colorseqby2'>";
        // html += me.htmlCls.optionStr + "'identity' selected>Identity</option>";
        // html += me.htmlCls.optionStr + "'conservation'>Conservation</option>";
        // html += "</select> <br><br>";

        html += me.htmlCls.buttonStr + "addtrack_button2c'>Show Isoforms & Exons</button>";
        html += "</div>";


        html += me.htmlCls.divStr + "tracktab3'>";
        html += "BED file: " + me.htmlCls.inputFileStr + "id='" + me.pre + "track_bed' size=16> <br><br>";
        html += me.htmlCls.buttonStr + "addtrack_button3'>Add Track</button>";
        html += "</div>";
        html += me.htmlCls.divStr + "tracktab4'>";
        html += "Track Title: " + me.htmlCls.inputTextStr + "id='" + me.pre + "track_title' placeholder='track title' size=16> <br><br>";
        html += "Track Text (e.g., \"2 G, 5-6 RR\" defines a character \"G\" at the position 2 and two continuous characters \"RR\" at positions from 5 to 6. The starting position is 1): <br>";
        html += "<textarea id='" + me.pre + "track_text' rows='5' style='width: 100%; height: " +(2*me.htmlCls.MENU_HEIGHT) + "px; padding: 0px; border: 0px;'></textarea><br><br>";
        html += me.htmlCls.buttonStr + "addtrack_button4'>Add Track</button>";
        html += "</div>";
        html += me.htmlCls.divStr + "tracktab5'>";
        html += "Track Title: " + me.htmlCls.inputTextStr + "id='" + me.pre + "track_selection' placeholder='track title' size=16> <br><br>";
        html += me.htmlCls.buttonStr + "addtrack_button5'>Add Track</button>";
        html += "</div>";

        html += "</div>";

        html += "</div>";

        html += me.htmlCls.divStr + "dl_saveselection' class='" + dialogClass + "'>";
        html += this.addNotebookTitle('dl_saveselection', 'Save Selection');
        let index =(ic && ic.defNames2Atoms) ? Object.keys(ic.defNames2Atoms).length : 1;
        let suffix = '';
        html += "Name: " + me.htmlCls.inputTextStr + "id='" + me.pre + "seq_command_name" + suffix + "' value='seq_" + index + "' size='5'> <br>";
        //html += "Description: " + me.htmlCls.inputTextStr + "id='" + me.pre + "seq_command_desc" + suffix + "' value='seq_desc_" + index + "' size='10'> <br>";
        html += "<button style='white-space:nowrap;' id='" + me.pre + "seq_saveselection" + suffix + "'>Save</button> <button style='white-space:nowrap; margin-left:20px;' id='" + me.pre + "seq_clearselection" + suffix + "'>Clear</button><br/><br/>";
        html += "</div>";


        html += me.htmlCls.divStr + "dl_copyurl' style='width:520px;' class='" + dialogClass + "'>";
        html += this.addNotebookTitle('dl_copyurl', 'Share Link');
        html += "<br>";
        html += "1. <b>URLs Used in Browsers</b><br><br>";

        html += "Please copy one of the URLs below. They show the same result.<br>(To add a title to share link, click \"Windows > Your Note\" and click \"File > Share Link\" again.)<br><br>";
        html += "Original URL with commands: <br><textarea id='" + me.pre + "ori_url' rows='4' style='width:100%'></textarea><br><br>";
        if(!me.cfg.notebook) {
            html += "Lifelong Short URL:(To replace this URL, send a pull request to update share.html at <a href='https://github.com/ncbi/icn3d' target='_blank'>iCn3D GitHub</a>)<br>" + me.htmlCls.inputTextStr + "id='" + me.pre + "short_url' value='' style='width:100%'><br><br>";
            html += "Lifelong Short URL + Window Title:(To update the window title, click \"Analysis > Your Note/Window Title\".)<br>" + me.htmlCls.inputTextStr + "id='" + me.pre + "short_url_title' value='' style='width:100%'><br><br>";
        }

        html += "2. <b>Commands Used in Jupyter Noteboook</b><br><br>";
        html += "Please copy the following commands into a cell in Jupyter Notebook to show the same result. <br>More details are at https://github.com/ncbi/icn3d/tree/master/jupyternotebook.<br><br>";

        html += '<textarea id="' + me.pre + 'jn_commands" rows="4" style="width:100%"></textarea><br>';

        html += buttonStrTmp + me.pre + 'jn_copy">Copy Commands</button><br>';

        html += "</div>";

        html += me.htmlCls.divStr + "dl_selectannotations' class='" + dialogClass + " icn3d-annotation' style='background-color:white;'>";
        html += this.addNotebookTitle('dl_selectannotations', 'Sequences & Annotations');

        html += me.htmlCls.divStr + "dl_annotations_tabs'>";

        html += me.htmlCls.divStr + "dl_anno_view_tabs' style='border:0px; height:33px;'>";
        html += "<ul>";
        html += "<li><a href='#" + me.pre + "anno_tmp1' id='" + me.pre + "anno_summary'>Summary</a></li>";
        html += "<li><a href='#" + me.pre + "anno_tmp2' id='" + me.pre + "anno_details'>Details</a></li>";
        html += "</ul>";
        html += me.htmlCls.divStr + "anno_tmp1'>";
        html += "</div>";
        html += me.htmlCls.divStr + "anno_tmp2'>";
        html += "</div>";
        html += "</div>";

        html += this.getAnnoHeader();

        html += "<button style='white-space:nowrap; margin-left:5px;' id='" + me.pre + "showallchains'>Show All Chains</button><br>";

        html += me.htmlCls.divStr + "seqguide_wrapper' style='display:none'><br>" + me.htmlCls.setHtmlCls.setSequenceGuide("2") + "</div>";

        html += "</div><br/><hr><br>";

        html += me.htmlCls.divStr + "dl_annotations'>";
        html += "</div>";

        html += "</div>";

        html += me.htmlCls.divStr + "dl_graph' style='background-color:white;' class='" + dialogClass + "'>";
        html += this.addNotebookTitle('dl_graph', 'Interactions');
        me.svgid = me.pre + 'icn3d_viz';
        html += '<style>';
        html += '#' + me.svgid + ' svg { border: 1px solid; font: 13px sans-serif; text-anchor: end; }';
        html += '#' + me.svgid + ' .node { stroke: #eee; stroke-width: 1.5px; }';
        html += '.node .selected { stroke: ' + me.htmlCls.ORANGE + '; }';
        html += '.link { stroke: #999; stroke-opacity: 0.6; }';

        html += '</style>';

        html += me.htmlCls.divNowrapStr + '<b>Zoom</b>: mouse wheel; ' + me.htmlCls.space3 + ' <b>Move</b>: left button; ' + me.htmlCls.space3 + ' <b>Select Multiple Nodes</b>: Ctrl Key and drag an Area' + me.htmlCls.space3;
        html += '<div id="' + me.pre + 'interactionDesc" style="width:20px; margin-top:6px; display:inline-block;"><span id="'
          + me.pre + 'dl_svgcolor_expand" class="ui-icon ui-icon-plus icn3d-expand icn3d-link" style="width:15px;" title="Expand"></span><span id="'
          + me.pre + 'dl_svgcolor_shrink" class="ui-icon ui-icon-minus icn3d-shrink icn3d-link" style="display:none; width:15px;" title="Shrink"></span></div></div>';
        html += me.htmlCls.divStr + "dl_svgcolor' style='display:none;'>";
        html += me.htmlCls.divNowrapStr + '<span style="margin-left:33px">Click "View > H-Bonds & Interactions" to adjust parameters and relaunch the graph</span></div>';
        html += me.htmlCls.divNowrapStr + '<span style="margin-left:33px; color:#00FF00; font-weight:bold">Green</span>: H-Bonds; ';
        html += '<span style="color:#00FFFF; font-weight:bold">Cyan</span>: Salt Bridge/Ionic; ';
        html += '<span style="font-weight:bold">Grey</span>: contacts; ';
        html += '<span style="color:' + me.htmlCls.ORANGE + '; font-weight:bold">Orange</span>: disulfide bonds</div>';
        html += me.htmlCls.divNowrapStr + '<span style="margin-left:33px; color:#FF00FF; font-weight:bold">Magenta</span>: Halogen Bonds; ';
        html += '<span style="color:#FF0000; font-weight:bold">Red</span>: &pi;-Cation; ';
        html += '<span style="color:#0000FF; font-weight:bold">Blue</span>: &pi;-Stacking</div>';
        html += "</div>";

        html += me.htmlCls.divNowrapStr + buttonStrTmp + me.svgid + '_svg">SVG</button>' + me.htmlCls.space2;
        html += buttonStrTmp + me.svgid + '_png">PNG</button>' + me.htmlCls.space2;
        html += buttonStrTmp + me.svgid + '_json">JSON</button>';
        html += me.htmlCls.space3 + "<div id='" + me.pre + "force' style='display:inline-block;'><b>Force on Nodes</b>: <select id='" + me.svgid + "_force'>";
        html += me.htmlCls.optionStr + "'0'>No</option>";
        html += me.htmlCls.optionStr + "'1'>X-axis</option>";
        html += me.htmlCls.optionStr + "'2'>Y-axis</option>";
        html += me.htmlCls.optionStr + "'3'>Circle</option>";
        html += me.htmlCls.optionStr + "'4' selected>Random</option>";
        html += "</select></div>";
        html += me.htmlCls.space3 + "<b>Label Size</b>: <select id='" + me.svgid + "_label'>";
        tmpStr = 'icn3d-node-text';
        html += me.htmlCls.optionStr + "'" + tmpStr + "0'>No</option>";
        html += me.htmlCls.optionStr + "'" + tmpStr + "4'>4px</option>";
        html += me.htmlCls.optionStr + "'" + tmpStr + "8' selected>8px</option>";
        html += me.htmlCls.optionStr + "'" + tmpStr + "12'>12px</option>";
        html += me.htmlCls.optionStr + "'" + tmpStr + "16'>16px</option>";
        html += me.htmlCls.optionStr + "'" + tmpStr + "24'>24px</option>";
        html += me.htmlCls.optionStr + "'" + tmpStr + "32'>32px</option>";
        html += "</select>";
        html += me.htmlCls.space3 + "<div id='" + me.pre + "internalEdges' style='display:inline-block;'><b>Internal Edges</b>: <select id='" + me.svgid + "_hideedges'>";
        html += me.htmlCls.optionStr + "'1' selected>Hide</option>";
        html += me.htmlCls.optionStr + "'0'>Show</option>";
        html += "</select></div>";
        html += "</div>";

        html += '<svg id="' + me.svgid + '" style="margin-top:6px;"></svg>';
        html += "</div>";

        html += me.htmlCls.divStr + "dl_area' class='" + dialogClass + "'>";
        html += this.addNotebookTitle('dl_area', 'Surface Area');
        html += "Solvent Accessible Surface Area(SASA) calculated using the <a href='https://journals.plos.org/plosone/article?id=10.1371/journal.pone.0008140' target='_blank'>EDTSurf algorithm</a>: <br>";
        html += '(0-20% out is considered "in". 50-100% out is considered "out".)<br><br>';
        html += "<b>Toal</b>: " + me.htmlCls.inputTextStr + "id='" + me.pre + "areavalue' value='' size='10'> &#8491;<sup>2</sup><br><br>";
        html += "<div id='" + me.pre + "areatable' style='max-height:400px; overflow:auto'></div>";
        html += "</div>";

        html += me.htmlCls.divStr + "dl_colorbyarea' class='" + dialogClass + "'>";
        html += this.addNotebookTitle('dl_colorbyarea', 'Color by surface area');
        html += "<div style='width:500px'>Color each residue based on the percentage of solvent accessilbe surface area. The color ranges from blue, to white, to red for a percentage of 0, 35(variable), and 100, respectively.</div><br>";
        html += "<b>Middle Percentage(White)</b>: " + me.htmlCls.inputTextStr + "id='" + me.pre + "midpercent' value='35' size='10'>% <br><br>";
        html += "<button style='white-space:nowrap;' id='" + me.pre + "applycolorbyarea'>Color</button><br/><br/>";
        html += "</div>";

        html += me.htmlCls.divStr + "dl_rmsd' class='" + dialogClass + "' style='max-width:300px'>";
        html += this.addNotebookTitle('dl_rmsd', 'RMSD', true);
        
        html += "</div>";

        html += me.htmlCls.divStr + "dl_buriedarea' class='" + dialogClass + "'>";
        html += this.addNotebookTitle('dl_buriedarea', 'Buried surface area', true);
        html += "</div>";

        html += me.htmlCls.divStr + "dl_propbypercentout' class='" + dialogClass + "'>";
        html += this.addNotebookTitle('dl_propbypercentout', 'Select residues basen on solvent accessilbe surface area');
        html += "<div style='width:400px'>Select residue based on the percentage of solvent accessilbe surface area. The values are in the range of 0-100.</div><br>";
        html += "<b>Min Percentage</b>: " + me.htmlCls.inputTextStr + "id='" + me.pre + "minpercentout' value='0' size='10'>% <br>";
        html += "<b>Max Percentage</b>: " + me.htmlCls.inputTextStr + "id='" + me.pre + "maxpercentout' value='100' size='10'>% <br>";
        html += "<button style='white-space:nowrap;' id='" + me.pre + "applypropbypercentout'>Apply</button><br/><br/>";
        html += "</div>";

        html += me.htmlCls.divStr + "dl_propbybfactor' class='" + dialogClass + "'>";
        html += this.addNotebookTitle('dl_propbybfactor', 'Select residues basen on B-factor/pLDDT');
        html += "<div style='width:400px'>Select residue based on B-factor/pLDDT. The values are in the range of 0-100.</div><br>";
        html += "<b>Min B-factor/pLDDT</b>: " + me.htmlCls.inputTextStr + "id='" + me.pre + "minbfactor' value='0' size='10'>% <br>";
        html += "<b>Max B-factor/pLDDT</b>: " + me.htmlCls.inputTextStr + "id='" + me.pre + "maxbfactor' value='100' size='10'>% <br>";
        html += "<button style='white-space:nowrap;' id='" + me.pre + "applypropbybfactor'>Apply</button><br/><br/>";
        html += "</div>";

        html += me.htmlCls.divStr + "dl_legend' class='" + dialogClass + "' style='max-width:500px; background-color:white'>";
        html += this.addNotebookTitle('dl_legend', 'Legend', true);
        html += "</div>";

        html += me.htmlCls.divStr + "dl_disttable' class='" + dialogClass + "'>";
        html += this.addNotebookTitle('dl_disttable', 'Distance Table', true);
        html += "</div>";

        
        html += me.htmlCls.divStr + "dl_angletable' class='" + dialogClass + "'>";
        html += this.addNotebookTitle('dl_angletable', 'Angle Table', true);
        html += "</div>";

        html += me.htmlCls.divStr + "dl_translate' class='" + dialogClass + "'>";
        html += this.addNotebookTitle('dl_translate', 'Translate the X,Y,Z coordinates of the structure');
        html += "X: " + me.htmlCls.inputTextStr + "id='" + me.pre + "translateX' value='' size=4> ";
        html += "Y: " + me.htmlCls.inputTextStr + "id='" + me.pre + "translateY' value='' size=4> ";
        html += "Z: " + me.htmlCls.inputTextStr + "id='" + me.pre + "translateZ' value='' size=4> ";
        html += me.htmlCls.buttonStr + "translate_pdb'>Translate</button>";
        html += "</div>";

        html += me.htmlCls.divStr + "dl_angle' class='" + dialogClass + "'>";
        html += this.addNotebookTitle('dl_angle', 'Measure the angle between two vectors');
        html += "<b>Vector 1</b>, X: " + me.htmlCls.inputTextStr + "id='" + me.pre + "v1X' value='' size=6> ";
        html += "Y: " + me.htmlCls.inputTextStr + "id='" + me.pre + "v1Y' value='' size=6> ";
        html += "Z: " + me.htmlCls.inputTextStr + "id='" + me.pre + "v1Z' value='' size=6><br>";
        html += "<b>Vector 2</b>, X: " + me.htmlCls.inputTextStr + "id='" + me.pre + "v2X' value='' size=6> ";
        html += "Y: " + me.htmlCls.inputTextStr + "id='" + me.pre + "v2Y' value='' size=6> ";
        html += "Z: " + me.htmlCls.inputTextStr + "id='" + me.pre + "v2Z' value='' size=6><br>";
        html += "<br>";
        
        html += me.htmlCls.buttonStr + "measure_angle'>Measure Angle</button><br><br>";
        html += "The angle is: " + me.htmlCls.inputTextStr + "id='" + me.pre + "angle_value' value='' size=6> degree.<br><br>";
        html += "</div>";

        html += me.htmlCls.divStr + "dl_matrix' class='" + dialogClass + "'>";
        html += this.addNotebookTitle('dl_matrix', 'Apply matrix to the X,Y,Z coordinates of the structure');
        html += "0: " + me.htmlCls.inputTextStr + "id='" + me.pre + "matrix0' value='1' size=2> ";
        html += "4: " + me.htmlCls.inputTextStr + "id='" + me.pre + "matrix4' value='0' size=2> ";
        html += "8: " + me.htmlCls.inputTextStr + "id='" + me.pre + "matrix8' value='0' size=2> ";
        html += "12: " + me.htmlCls.inputTextStr + "id='" + me.pre + "matrix12' value='0' size=2><br>";

        html += "1: " + me.htmlCls.inputTextStr + "id='" + me.pre + "matrix1' value='0' size=2> ";
        html += "5: " + me.htmlCls.inputTextStr + "id='" + me.pre + "matrix5' value='1' size=2> ";
        html += "9: " + me.htmlCls.inputTextStr + "id='" + me.pre + "matrix9' value='0' size=2> ";
        html += "13: " + me.htmlCls.inputTextStr + "id='" + me.pre + "matrix13' value='0' size=2><br>";

        html += "2: " + me.htmlCls.inputTextStr + "id='" + me.pre + "matrix2' value='0' size=2> ";
        html += "6: " + me.htmlCls.inputTextStr + "id='" + me.pre + "matrix6' value='0' size=2> ";
        html += "10: " + me.htmlCls.inputTextStr + "id='" + me.pre + "matrix10' value='1' size=2> ";
        html += "14: " + me.htmlCls.inputTextStr + "id='" + me.pre + "matrix14' value='0' size=2><br>";

        html += "3: " + me.htmlCls.inputTextStr + "id='" + me.pre + "matrix3' value='0' size=2> ";
        html += "7: " + me.htmlCls.inputTextStr + "id='" + me.pre + "matrix7' value='0' size=2> ";
        html += "11: " + me.htmlCls.inputTextStr + "id='" + me.pre + "matrix11' value='0' size=2> ";
        html += "15: " + me.htmlCls.inputTextStr + "id='" + me.pre + "matrix15' value='1' size=2><br>";

        html += me.htmlCls.buttonStr + "matrix_pdb'>Rotate with Matrix</button>";
        html += "</div>";

        html += me.htmlCls.divStr + "dl_igrefTpl' class='" + dialogClass + "'>";
        html += this.addNotebookTitle('dl_igrefTpl', 'Choose an Ig template');
        html += "<span style='white-space:nowrap;font-weight:bold;'>Choose an Ig template for selected residues:</span> <br><br><select id='" + me.pre + "refTpl'>";
        html += this.setTemplateMenu();
        html += "</select><br><br><span style='white-space:nowrap;'>" + me.htmlCls.buttonStr + "mn6_igrefTpl_apply'>Show Ig Ref. Number</button></span>";
        html += "</div>";

        html += me.htmlCls.divStr + "dl_alignrefTpl' class='" + dialogClass + "'>";
        html += this.addNotebookTitle('dl_alignrefTpl', 'Align with an Ig template');
        html += "<span style='white-space:nowrap;font-weight:bold;'>Choose an Ig template to align with selected residues:</span> <br><br><select id='" + me.pre + "refTpl2'>";
        html += this.setTemplateMenu();
        html += "</select><br><br><span style='white-space:nowrap;'>" + me.htmlCls.buttonStr + "mn6_alignrefTpl_apply'>Align Template with Selection</button></span>";
        html += "</div>";

        html += "</div>";
        html += "<!--/form-->";

        return html;
    }

    setTemplateMenu()  { let me = this.icn3dui; me.icn3d;
        let group2tpl = {};
        group2tpl['IgV'] = ['CD28_1yjdC_human_V', 'CD2_1hnfA_human_V-n1', 'CD8a_1cd8A_human_V', 'FAB-HEAVY_5esv_V-n1', 'FAB-LIGHT_5esv_V-n1', 'ICOS_6x4gA_human_V', 'LAG3_7tzgD_human_V-n1', 'PD1_4zqkB_human_V', 'PDL1_4z18B_human_V-n1', 'TCRa_6jxrm_human_V-n1', 'VISTA_6oilA_human_V', 'VNAR_1t6vN_shark_V'];
        group2tpl['IgC1'] = ['B2Microglobulin_7phrL_human_C1', 'CD3d_6jxrd_human_C1', 'CD3e_6jxrf_human_C1', 'FAB-LIGHT_5esv_C1-n2', 'FAB-HEAVY_5esv_C1-n2', 'GHR_1axiB_human_C1-n1', 'LAG3_7tzgD_human_C1-n2', 'MHCIa_7phrH_human_C1', 'Siglec3_5j0bB_human_C1-n2', 'TCRa_6jxrm_human_C1-n2', 'VTCN1_Q7Z7D3_human_C1-n2'];
        group2tpl['IgC2'] = ['CD2_1hnfA_human_C2-n2', 'CD3g_6jxrg_human_C2'];
        group2tpl['IgI'] = ['BTLA_2aw2A_human_Iset', 'Contactin1_3s97C_human_Iset-n2', 'JAM1_1nbqA_human_Iset-n2', 'Palladin_2dm3A_human_Iset-n1', 'Titin_4uowM_human_Iset-n152'];
        group2tpl['IgE'] = ['CoAtomerGamma1_1r4xA_human', 'Endo-1,4-BetaXylanase10A_1i8aA_bacteria_n4', 'IsdA_2iteA_bacteria', 'NaKATPaseTransporterBeta_2zxeB_spurdogshark', 'TP34_2o6cA_bacteria', 'TP47_1o75A_bacteria'];

        group2tpl['IgFN3'] = ['Contactin1_2ee2A_human_FN3-n9', 'IL6Rb_1bquB_human_FN3-n2', 'IL6Rb_1bquB_human_FN3-n3', 'InsulinR_8guyE_human_FN3-n1', 'InsulinR_8guyE_human_FN3-n2', 'Sidekick2_1wf5A_human_FN3-n7'];

        group2tpl['IgFN3-like'] = ['ASF1A_2iijA_human', 'BArrestin1_4jqiA_rat_n1', 'C3_2qkiD_human_n1', 'MPT63_1lmiA_bacteria', 'NaCaExchanger_2fwuA_dog_n2', 'RBPJ_6py8C_human_Unk-n1', 'RBPJ_6py8C_human_Unk-n2', 'TEAD1_3kysC_human'];

        group2tpl['Other Ig'] = ['CD19_6al5A_human-n1', 'CuZnSuperoxideDismutase_1hl5C_human', 'ECadherin_4zt1A_human_n2', 'LaminAC_1ifrA_human', 'ORF7a_1xakA_virus'];  

        let tpl2strandsig = {};
        tpl2strandsig['ASF1A_2iijA_human']                          = "A A' B C C' E F G G+";
        tpl2strandsig['B2Microglobulin_7phrL_human_C1']             = "A B C C' D E F G";
        tpl2strandsig['BArrestin1_4jqiA_rat_n1']                    = "A- A A' B C C' E F G";
        tpl2strandsig['BTLA_2aw2A_human_Iset']                      = "A A' B C C' D E F G";
        tpl2strandsig['C3_2qkiD_human_n1']                          = "A A' B C C' E F G";
        tpl2strandsig['CD19_6al5A_human-n1']                  = "A' B C C' D E F G";
        tpl2strandsig['CD28_1yjdC_human_V']                         = "A A' B C C' C'' D E F G";
        tpl2strandsig['CD2_1hnfA_human_C2-n2']                      = "A B C C' E F G";
        tpl2strandsig['CD2_1hnfA_human_V-n1']                       = "A' B C C' C'' D E F G";
        tpl2strandsig['CD3d_6jxrd_human_C1']                      = "A B C D E F G";
        tpl2strandsig['CD3e_6jxrf_human_C1']                      = "A B C C' D E F G";
        tpl2strandsig['CD3g_6jxrg_human_C2']                      = "A B C C' E F G G+";
        tpl2strandsig['CD8a_1cd8A_human_V']                         = "A A' B C C' C'' D E F G";
        tpl2strandsig['CoAtomerGamma1_1r4xA_human']                 = "A- A B C D E F G";
        tpl2strandsig['Contactin1_2ee2A_human_FN3-n9']              = "A A' B C C' E F G";
        tpl2strandsig['Contactin1_3s97C_human_Iset-n2']               = "A A' B C D E F G";
        tpl2strandsig['CuZnSuperoxideDismutase_1hl5C_human']        = "A- A B C C' E F G";
        tpl2strandsig['ECadherin_4zt1A_human_n2']                   = "A' B C D E F G";
        tpl2strandsig['Endo-1,4-BetaXylanase10A_1i8aA_bacteria_n4'] = "A--- A-- A- A B C C' C'' D E F G";
        tpl2strandsig['FAB-HEAVY_5esv_C1-n2']                       = "A B C D E F G";
        tpl2strandsig['FAB-HEAVY_5esv_V-n1']                        = "A B C C' C'' D E F G";
        tpl2strandsig['FAB-LIGHT_5esv_C1-n2']                       = "A B C C' D E F G";
        tpl2strandsig['FAB-LIGHT_5esv_V-n1']                        = "A A' B C C' C'' D E F G";
        tpl2strandsig['GHR_1axiB_human_C1-n1']                     = "A B C C' D E F G";
        tpl2strandsig['ICOS_6x4gA_human_V']                         = "A B C C' C'' D E F G";
        tpl2strandsig['IL6Rb_1bquB_human_FN3-n2']                   = "A B C C' E F G";
        tpl2strandsig['IL6Rb_1bquB_human_FN3-n3']                   = "A B C C' E F G";
        tpl2strandsig['InsulinR_8guyE_human_FN3-n1']                = "A B C C' E F G";
        tpl2strandsig['InsulinR_8guyE_human_FN3-n2']                = "A B C C' E F G";
        tpl2strandsig['IsdA_2iteA_bacteria']                        = "A- A B C C' D E F G";
        tpl2strandsig['JAM1_1nbqA_human_Iset-n2']                = "A A' B C C' D E F G";
        tpl2strandsig['LAG3_7tzgD_human_C1-n2']                     = "A A' B C C' D E F G";
        tpl2strandsig['LAG3_7tzgD_human_V-n1']                      = "A' B C C' D E F G";
        tpl2strandsig['LaminAC_1ifrA_human']                        = "A- A B C C' E E+ F G";
        tpl2strandsig['MHCIa_7phrH_human_C1']                       = "A B C C' D E F G";
        tpl2strandsig['MPT63_1lmiA_bacteria']                       = "A-- A- A BC C' E F G";
        tpl2strandsig['NaCaExchanger_2fwuA_dog_n2']                 = "A A' B C C' E F G";
        tpl2strandsig['NaKATPaseTransporterBeta_2zxeB_spurdogshark']= "A A' B C D E F G";
        tpl2strandsig['ORF7a_1xakA_virus']                          = "A' B C D E F G";
        tpl2strandsig['PD1_4zqkB_human_V']                          = "A A' B C C' D E F G";
        tpl2strandsig['PDL1_4z18B_human_V-n1']                      = "A A' B C C' C'' D E F G";
        tpl2strandsig['Palladin_2dm3A_human_Iset-n1']               = "A A' B C C' D E F G";
        tpl2strandsig['RBPJ_6py8C_human_Unk-n1']                    = "A A' B C C' E F G";
        tpl2strandsig['RBPJ_6py8C_human_Unk-n2']                    = "A B C D E F G";
        tpl2strandsig['Sidekick2_1wf5A_human_FN3-n7']               = "A B C C' E F G";
        tpl2strandsig['Siglec3_5j0bB_human_C1-n2']                  = "A A' B C D E F G";
        tpl2strandsig['TCRa_6jxrm_human_C1-n2']                     = "A B C D E F G";
        tpl2strandsig['TCRa_6jxrm_human_V-n1']                      = "A A' B C C' C'' D E F G";
        tpl2strandsig['TEAD1_3kysC_human']                          = "A A+ A' B C C' E F G G+";
        tpl2strandsig['TP34_2o6cA_bacteria']                        = "A- A B C C' D E F G";
        tpl2strandsig['TP47_1o75A_bacteria']                        = "A B C C' D E F G";
        tpl2strandsig['Titin_4uowM_human_Iset-n152']                 = "A A' B C C' D E F G";
        tpl2strandsig['VISTA_6oilA_human_V']                        = "A A' B C C' C'' D E F G G+";
        tpl2strandsig['VNAR_1t6vN_shark_V']                         = "A A' B C C' D E F G";
        tpl2strandsig['VTCN1_Q7Z7D3_human_C1-n2']                    = "A B C C' D E F G G+";

        let html = '';
        for(let group in group2tpl) {
            html += "<optgroup label='" + group + "'>";
            for(let i = 0, il = group2tpl[group].length; i < il; ++i) {
                let template = group2tpl[group][i];
                html += me.htmlCls.optionStr + "'" + template + "'>" + template  + ", Strands: " + tpl2strandsig[template] + "</option>";
            }
            html += "</optgroup>";
        }

        return html;
    }

    getAnnoHeader() { let me = this.icn3dui; me.icn3d;
        let html = '';

        html += "<div id='" + me.pre + "annoHeaderSection' class='icn3d-box' style='width:520px;'><b>Annotations:&nbsp;</b><br>";
        html += "<div id='" + me.pre + "annoHeader'><table border=0><tr>";
        let tmpStr1 = "<td style='min-width:110px;'><span style='white-space:nowrap'>";
        let tmpStr2 = "<td style='min-width:130px;'><span style='white-space:nowrap'>";

        html += tmpStr1 + me.htmlCls.inputCheckStr + "id='" + me.pre + "anno_all'>All" + me.htmlCls.space2 + "</span></td>";
        html += tmpStr2 + me.htmlCls.inputCheckStr + "id='" + me.pre + "anno_cdd' checked>Conserved Domains" + me.htmlCls.space2 + "</span></td>";
        html += tmpStr1 + me.htmlCls.inputCheckStr + "id='" + me.pre + "anno_clinvar'>ClinVar" + me.htmlCls.space2 + "</span></td>";
        html += tmpStr1 + me.htmlCls.inputCheckStr + "id='" + me.pre + "anno_binding'>Functional Sites" + me.htmlCls.space2 + "</span></td>";
        html += "</tr><tr>";
        html += tmpStr1 + me.htmlCls.inputCheckStr + "id='" + me.pre + "anno_custom'>Custom" + me.htmlCls.space2 + "</span></td>";
        html += tmpStr2 + me.htmlCls.inputCheckStr + "id='" + me.pre + "anno_3dd'>3D Domains" + me.htmlCls.space2 + "</span></td>";
        html += tmpStr1 + me.htmlCls.inputCheckStr + "id='" + me.pre + "anno_snp'>SNPs" + me.htmlCls.space2 + "</span></td>";
        
        // if(me.cfg.mmdbid != undefined || me.cfg.pdbid != undefined || me.cfg.mmtfid != undefined || me.cfg.mmcifid != undefined) { // PDB
        //     html += tmpStr1 + me.htmlCls.inputCheckStr + "id='" + me.pre + "anno_ptm' disabled>PTM (UniProt)" + me.htmlCls.space2 + "</span></td>";
        // }
        // else {
            html += tmpStr1 + me.htmlCls.inputCheckStr + "id='" + me.pre + "anno_ptm'>PTM (UniProt)" + me.htmlCls.space2 + "</span></td>";
        // }
        html += "<td></td>";
        html += "</tr><tr>";
        html += tmpStr1 + me.htmlCls.inputCheckStr + "id='" + me.pre + "anno_ssbond'>Disulfide Bonds" + me.htmlCls.space2 + "</span></td>";
        html += tmpStr1 + me.htmlCls.inputCheckStr + "id='" + me.pre + "anno_interact'>Interactions" + me.htmlCls.space2 + "</span></td>";
        html += tmpStr1 + me.htmlCls.inputCheckStr + "id='" + me.pre + "anno_crosslink'>Cross-Linkages" + me.htmlCls.space2 + "</span></td>";
        html += tmpStr1 + me.htmlCls.inputCheckStr + "id='" + me.pre + "anno_transmem'>Transmembrane" + me.htmlCls.space2 + "</span></td>";

        html += "<td></td>";
        html += "</tr><tr>";
        html += tmpStr1 + me.htmlCls.inputCheckStr + "id='" + me.pre + "anno_ig'>Ig Domains" + me.htmlCls.space2 + "</span></td>";

        html += "<td></td>";
        html += "</tr></table></div></div>";

        return html;
    }
}

/**
 * @author Jiyao Wang <wangjiy@ncbi.nlm.nih.gov> / https://github.com/ncbi/icn3d
 */

class Events {
    constructor(icn3dui) {
        this.icn3dui = icn3dui;
    }

    // simplify setLogCmd from clickMenuCls
    setLogCmd(str, bSetCommand, bAddLogs) {var me = this.icn3dui; me.icn3d;
        me.htmlCls.clickMenuCls.setLogCmd(str, bSetCommand, bAddLogs);
    }

    // ====== events start ===============
    fullScreenChange() { let me = this.icn3dui, ic = me.icn3d, thisClass = this; // event handler uses ".bind(inputAsThis)" to define "this"
        if(me.bNode) return;

        let fullscreenElement = document.fullscreenElement || document.webkitFullscreenElement
          || document.mozFullscreenElement || document.msFullscreenElement;
        if(!fullscreenElement) {
            thisClass.setLogCmd("exit full screen", false);
            ic.bFullscreen = false;
            me.utilsCls.setViewerWidthHeight(me, true);
            ic.applyCenterCls.setWidthHeight(me.htmlCls.WIDTH, me.htmlCls.HEIGHT);
            ic.drawCls.draw();
        }
    }

    convertUniProtInChains(alignment) { let me = this.icn3dui; me.icn3d;
        let idArray = alignment.split(',');
        let alignment_final = '';
        for(let i = 0, il = idArray.length; i < il; ++i) {
            alignment_final += (idArray[i].indexOf('_') != -1) ? idArray[i] : idArray[i] + '_A'; // AlphaFold ID
            if(i < il - 1) alignment_final += ',';
        }

        return alignment_final;
    }

    async searchSeq() { let me = this.icn3dui, ic = me.icn3d, thisClass = this;
       let select = $("#" + me.pre + "search_seq").val();
       if(isNaN(select) && select.indexOf('$') == -1 && select.indexOf('.') == -1 && select.indexOf(':') == -1 
       && select.indexOf('@') == -1) {
           select = ':' + select;
       }
       let commandname = select.replace(/\s+/g, '_');
       let commanddesc = commandname;
       await ic.selByCommCls.selectByCommand(select, commandname, commanddesc);
       thisClass.setLogCmd('select ' + select + ' | name ' + commandname, true);
    }

    async setRealign(alignType, bMsa) { let me = this.icn3dui, ic = me.icn3d, thisClass = this;
        let nameArray = $("#" + me.pre + "atomsCustomRealignByStruct").val();
        if(nameArray.length > 0) {
            ic.hAtoms = ic.definedSetsCls.getAtomsFromNameArray(nameArray);
        }

        me.cfg.aligntool = alignType;

        let alignStr = (alignType == 'vast') ? 'structure align' : 'tmalign';
        alignStr += (bMsa) ? ' msa' : '';

        if(nameArray.length > 0) {
            thisClass.setLogCmd("realign on " + alignStr + " | " + nameArray, true);
        }
        else {
            thisClass.setLogCmd("realign on " + alignStr, true);
        }

        if(bMsa) {
            // choose the first chain for each structure
            if(nameArray.length == 0) {
                nameArray = [];
                let structureHash = {};
                
                for(let chainid in ic.chains) {
                    let atom = ic.firstAtomObjCls.getFirstAtomObj(ic.chains[chainid]);
                    if(!structureHash.hasOwnProperty(atom.structure) && (ic.proteins.hasOwnProperty(atom.serial) || ic.nucleotides.hasOwnProperty(atom.serial))) {
                        nameArray.push(chainid);
                        structureHash[atom.structure] = 1;
                    }
                }
            }

            await ic.realignParserCls.realignOnStructAlignMsa(nameArray);
        }
        else {
            await ic.realignParserCls.realignOnStructAlign();
        }
    }

    async readFile(bAppend, files, index, dataStrAll, bmmCIF, bPng) { let me = this.icn3dui, ic = me.icn3d, thisClass = this;
        let file = files[index];
        let commandName = (bAppend) ? 'append': 'load';
        commandName += (bmmCIF) ? ' mmcif file ' : (bPng) ? ' png file ' : ' pdb file ';
        
        /*
             reader.onload = async function(e) {
               let imageStr = e.target.result; // or = reader.result;
               await thisClass.loadPng(dataStr);
             }
             */

        let reader = new FileReader();
        reader.onload = async function(e) {
            let dataStr = e.target.result; // or = reader.result;
            thisClass.setLogCmd(commandName + file.name, false);

            if(!bAppend) {
                ic.init();
            }
            else {
                ic.resetConfig();
                //ic.hAtoms = {};
                //ic.dAtoms = {};
                ic.bResetAnno = true;
                ic.bResetSets = true;
            }

            ic.bInputfile = true;
            ic.InputfileType = (bmmCIF) ? 'mmcif' : (bPng) ? 'png' : 'pdb';
            if(bPng) {
                let result = await me.htmlCls.setHtmlCls.loadPng(dataStr);
                dataStr = result.pdb;

                if(!dataStr) return; // old iCn3D PNG with sharable link

                if(!ic.statefileArray) ic.statefileArray = [];
                ic.statefileArray.push(result.statefile);
            }

            ic.InputfileData = (ic.InputfileData) ? ic.InputfileData + '\nENDMDL\n' + dataStr : dataStr;

            dataStrAll = (index > 0) ? dataStrAll + '\nENDMDL\n' + dataStr : dataStr;

            if(Object.keys(files).length == index + 1) {
                if(bAppend) {
                    ic.hAtoms = {};
                    ic.dAtoms = {};
                }
                if(bmmCIF) {
                    await ic.mmcifParserCls.loadMultipleMmcifData(dataStrAll, undefined, bAppend); 
                }
                else {
                	await ic.pdbParserCls.loadPdbData(dataStrAll, undefined, undefined, bAppend);
                }

                //ic.InputfileType = undefined; // reset
            }
            else {
                await thisClass.readFile(bAppend, files, index + 1, dataStrAll, bmmCIF, bPng);
            }

            if(bAppend) {
                if(ic.bSetChainsAdvancedMenu) ic.definedSetsCls.showSets();

                ic.bResetAnno = true;

                if(ic.bAnnoShown) {
                    await ic.showAnnoCls.showAnnotations();

                    ic.annotationCls.resetAnnoTabAll();
                }
            }
        };

        if (typeof file === "object") {
            reader.readAsText(file);
        }
    }

    async loadPdbFile(bAppend, fileId, bmmCIF) { let me = this.icn3dui, ic = me.icn3d;
       //me = ic.setIcn3dui(this.id);
       ic.bInitial = true;
       if(!me.cfg.notebook) dialog.dialog( "close" );
       //close all dialog
       if(!me.cfg.notebook) {
           $(".ui-dialog-content").dialog("close");
       }
       else {
           ic.resizeCanvasCls.closeDialogs();
       }
       let files = $("#" + me.pre + fileId)[0].files;
       if(!files[0]) {
         alert("Please select a file before clicking 'Load'");
       }
       else {
            me.htmlCls.setHtmlCls.fileSupport();
            ic.molTitle = "";

            //ic.fileCnt = Object.keys(files).length;
            //ic.loadedFileCnt = 0;

            ic.dataStrAll = '';

            await this.readFile(bAppend, files, 0, '', bmmCIF);
       }
    }

    saveHtml(id) { let me = this.icn3dui, ic = me.icn3d;
        let html = '';
        html += '<link rel="stylesheet" href="https://www.ncbi.nlm.nih.gov/Structure/icn3d/lib/jquery-ui-1.13.2.min.css">\n';
        html += '<link rel="stylesheet" href="https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d_full_ui.css">\n';
        html += $("#" + id).html();
        let idArray = id.split('_');
        let idStr =(idArray.length > 2) ? idArray[2] : id;
        let structureStr = Object.keys(ic.structures)[0];
        if(Object.keys(ic.structures).length > 1) structureStr += '-' + Object.keys(ic.structures)[1];
        ic.saveFileCls.saveFile(structureStr + '-' + idStr + '.html', 'html', encodeURIComponent(html));
    }

    setPredefinedMenu(id) { let me = this.icn3dui, ic = me.icn3d;
        if(Object.keys(ic.chains).length < 2) {
            alert("At least two chains are required for alignment...");
            return;
        }
        me.htmlCls.clickMenuCls.SetChainsAdvancedMenu();
        let definedAtomsHtml = ic.definedSetsCls.setAtomMenu(['protein']);
        if($("#" + me.pre + id).length) {
            $("#" + me.pre + id).html(definedAtomsHtml);
        }
        
        $("#" + me.pre + id).resizable();
    }

    async launchMmdb(ids, bBiounit, hostUrl, bAppend) { let me = this.icn3dui, ic = me.icn3d, thisClass = this;
        if(!me.cfg.notebook) dialog.dialog( "close" );
        
        let flag = bBiounit ? 1 : 0;

        // remove space
        ids = ids.replace(/,/g, ' ').replace(/\s+/g, ',').trim();

        if(!ids) {
            alert("Please enter a list of PDB IDs or AlphaFold UniProt IDs...");
            return;
        }

        let idArray = ids.split(',');

        if(!bAppend) {
            if(idArray.length == 1 && (idArray[0].length == 4 || !isNaN(idArray[0])) ) {
                thisClass.setLogCmd("load mmdb" + flag + " " + ids, false);
                let urlTarget = (ic.structures && Object.keys(ic.structures).length > 0) ? '_blank' : '_self';
                window.open(hostUrl + '?mmdbid=' + ids + '&bu=' + flag, urlTarget);
            }
            else {
                thisClass.setLogCmd("load mmdbaf" + flag + " " + ids, false);
                let urlTarget = (ic.structures && Object.keys(ic.structures).length > 0) ? '_blank' : '_self';
                window.open(hostUrl + '?mmdbafid=' + ids + '&bu=' + flag, urlTarget);
            }
        }
        else {
            // single MMDB ID could show memebranes
            if(!ic.structures && idArray.length == 1 && (idArray[0].length == 4 || !isNaN(idArray[0])) ) {
                thisClass.setLogCmd("load mmdb" + flag + " " + ids, false);
                let urlTarget = (ic.structures && Object.keys(ic.structures).length > 0) ? '_blank' : '_self';
                window.open(hostUrl + '?mmdbid=' + ids + '&bu=' + flag, urlTarget);
            }
            else {
                me.cfg.mmdbafid = ids;
                me.cfg.bu = flag;

                ic.bMmdbafid = true;
                ic.inputid = (ic.inputid) ? ic.inputid + me.cfg.mmdbafid : me.cfg.mmdbafid;
                if(me.cfg.bu == 1) {
                    ic.loadCmd = 'load mmdbaf1 ' + me.cfg.mmdbafid;
                }
                else {
                    ic.loadCmd = 'load mmdbaf0 ' + me.cfg.mmdbafid;
                }
                me.htmlCls.clickMenuCls.setLogCmd(ic.loadCmd, true);  

                let bStructures = (ic.structures && Object.keys(ic.structures).length > 0) ? true : false;

                await ic.chainalignParserCls.downloadMmdbAf(me.cfg.mmdbafid);   

                if(bStructures) {
                    if(ic.bSetChainsAdvancedMenu) ic.definedSetsCls.showSets();
                    if(ic.bAnnoShown) {
                        await ic.showAnnoCls.showAnnotations();
                        ic.annotationCls.resetAnnoTabAll();
                    }
                }
            }
        }
    }

    //Hold all functions related to click events.
    allEventFunctions() { let me = this.icn3dui, ic = me.icn3d;
        let thisClass = this;

        if(me.bNode) return;

        let hostUrl = document.URL;
        let pos = hostUrl.indexOf("?");
        hostUrl = (pos == -1) ? hostUrl : hostUrl.substr(0, pos);

        // some URLs from VAST search are like https://www.ncbi.nlm.nih.gov/Structure/vast/icn3d/
        if(hostUrl.indexOf('/vast/icn3d/')) {
            hostUrl = hostUrl.replace(/\/vast\/icn3d\//g, '/icn3d/');
        }

        ic.definedSetsCls.clickCustomAtoms();
        ic.definedSetsCls.clickCommand_apply();
        ic.definedSetsCls.clickModeswitch();

        ic.selectionCls.clickShow_selected();
        ic.selectionCls.clickHide_selected();

        ic.diagram2dCls.click2Ddgm();
        ic.cartoon2dCls.click2Dcartoon();
        ic.ligplotCls.clickLigplot();
        ic.addTrackCls.clickAddTrackButton();
        ic.resizeCanvasCls.windowResize();
        ic.annotationCls.setTabs();
        ic.resid2specCls.switchHighlightLevel();

        if(! me.utilsCls.isMobile()) {
            ic.hlSeqCls.selectSequenceNonMobile();
        }
        else {
            ic.hlSeqCls.selectSequenceMobile();
            ic.hlSeqCls.selectChainMobile();
        }

        me.htmlCls.clickMenuCls.clickMenu1();
        me.htmlCls.clickMenuCls.clickMenu2();
        me.htmlCls.clickMenuCls.clickMenu3();
        me.htmlCls.clickMenuCls.clickMenu4();
        me.htmlCls.clickMenuCls.clickMenu5();
        me.htmlCls.clickMenuCls.clickMenu6();

        me.myEventCls.onIds("#" + me.pre + "menumode", "change", async function(e) { me.icn3d;
            e.preventDefault();
            let mode = $("#" + me.pre + "menumode").val();

            me.htmlCls.setHtmlCls.setCookie('menumode', mode);
            me.htmlCls.setMenuCls.resetMenu(mode);
        });

        // back and forward arrows
        me.myEventCls.onIds(["#" + me.pre + "back", "#" + me.pre + "mn6_back"], "click", async function(e) { let ic = me.icn3d;
           e.preventDefault();
           thisClass.setLogCmd("back", false);
           await ic.resizeCanvasCls.back();
        });

        me.myEventCls.onIds(["#" + me.pre + "forward", "#" + me.pre + "mn6_forward"], "click", async function(e) { let ic = me.icn3d;
           e.preventDefault();
           thisClass.setLogCmd("forward", false);
           await ic.resizeCanvasCls.forward();
        });

        me.myEventCls.onIds(["#" + me.pre + "fullscreen", "#" + me.pre + "mn6_fullscreen"], "click", function(e) { let ic = me.icn3d; // from expand icon for mobilemenu
           e.preventDefault();
           //me = ic.setIcn3dui($(this).attr('id'));
           thisClass.setLogCmd("enter full screen", false);
           ic.bFullscreen = true;
           me.htmlCls.WIDTH = $( window ).width();
           me.htmlCls.HEIGHT = $( window ).height();
           ic.applyCenterCls.setWidthHeight(me.htmlCls.WIDTH, me.htmlCls.HEIGHT);
           ic.drawCls.draw();

           ic.resizeCanvasCls.openFullscreen($("#" + me.pre + "canvas")[0]);
        });

        document.addEventListener('fullscreenchange', this.fullScreenChange.bind(this));
        document.addEventListener('webkitfullscreenchange', this.fullScreenChange.bind(this));
        document.addEventListener('mozfullscreenchange', this.fullScreenChange.bind(this));
        document.addEventListener('msfullscreenchange', this.fullScreenChange.bind(this));


        me.myEventCls.onIds(["#" + me.pre + "toggle", "#" + me.pre + "mn2_toggle"], "click", function(e) { let ic = me.icn3d;
           //thisClass.setLogCmd("toggle selection", true);
           ic.selectionCls.toggleSelection();
           thisClass.setLogCmd("toggle selection", true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn2_hl_clrYellow", "click", function(e) { let ic = me.icn3d;
           thisClass.setLogCmd("set highlight color yellow", true);
           ic.hColor = me.parasCls.thr(0xFFFF00);
           ic.matShader = ic.setColorCls.setOutlineColor('yellow');
           ic.drawCls.draw(); // required to make it work properly
        });

        me.myEventCls.onIds("#" + me.pre + "mn2_hl_clrGreen", "click", function(e) { let ic = me.icn3d;
           thisClass.setLogCmd("set highlight color green", true);
           ic.hColor = me.parasCls.thr(0x00FF00);
           ic.matShader = ic.setColorCls.setOutlineColor('green');
           ic.drawCls.draw(); // required to make it work properly
        });

        me.myEventCls.onIds("#" + me.pre + "mn2_hl_clrRed", "click", function(e) { let ic = me.icn3d;
           thisClass.setLogCmd("set highlight color red", true);
           ic.hColor = me.parasCls.thr(0xFF0000);
           ic.matShader = ic.setColorCls.setOutlineColor('red');
           ic.drawCls.draw(); // required to make it work properly
        });

        me.myEventCls.onIds("#" + me.pre + "mn2_hl_styleOutline", "click", function(e) { let ic = me.icn3d;
           thisClass.setLogCmd("set highlight style outline", true);
           ic.bHighlight = 1;
           ic.hlUpdateCls.showHighlight();
        });

        me.myEventCls.onIds("#" + me.pre + "mn2_hl_styleObject", "click", function(e) { let ic = me.icn3d;
           thisClass.setLogCmd("set highlight style 3d", true);
           ic.bHighlight = 2;
           ic.hlUpdateCls.showHighlight();
        });

        me.myEventCls.onIds("#" + me.pre + "mn2_hl_styleNone", "click", function(e) { let ic = me.icn3d;
            e.stopImmediatePropagation();
            ic.hlUpdateCls.clearHighlight();
            thisClass.setLogCmd("clear selection", true);
        });

        me.myEventCls.onIds(["#" + me.pre + "alternate", "#" + me.pre + "mn2_alternate", "#" + me.pre + "alternate2"], "click", async function(e) { let ic = me.icn3d;
           ic.bAlternate = true;
           await ic.alternateCls.alternateStructures();
           ic.bAlternate = false;

           thisClass.setLogCmd("alternate structures", false);
        });

        me.myEventCls.onIds("#" + me.pre + "mn2_realignresbyres", "click", function(e) { me.icn3d;
            me.htmlCls.dialogCls.openDlg('dl_realignresbyres', 'Align multiple chains residue by residue');
        });

        me.myEventCls.onIds("#" + me.pre + "realignSelection", "click", function(e) { let ic = me.icn3d;
            if(Object.keys(ic.chains).length < 2) {
                alert("At least two chains are required for alignment...");
                return;
            }
            
           ic.realignParserCls.realign();
           thisClass.setLogCmd("realign", true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn2_realignonseqalign", "click", function(e) { let ic = me.icn3d;
            if(ic.bRender) me.htmlCls.dialogCls.openDlg('dl_realign', 'Please select chains to realign');

            thisClass.setPredefinedMenu('atomsCustomRealign');
        });

        me.myEventCls.onIds("#" + me.pre + "mn2_realignonstruct", "click", function(e) { let ic = me.icn3d;
            if(ic.bRender) me.htmlCls.dialogCls.openDlg('dl_realignbystruct', 'Please select chains to realign');

            thisClass.setPredefinedMenu('atomsCustomRealignByStruct');
        });

        me.myEventCls.onIds("#" + me.pre + "mn2_realigntwostru", "click", function(e) { let ic = me.icn3d;
            if(ic.bRender) me.htmlCls.dialogCls.openDlg('dl_realigntwostru', 'Please select structures to realign');

            thisClass.setPredefinedMenu('atomsCustomRealignByStruct2');
        });


        me.myEventCls.onIds("#" + me.pre + "applyRealign", "click", async function(e) { let ic = me.icn3d;
           e.preventDefault();
           if(!me.cfg.notebook) dialog.dialog( "close" );
           let nameArray = $("#" + me.pre + "atomsCustomRealign").val();
           if(nameArray.length > 0) {
               ic.hAtoms = ic.definedSetsCls.getAtomsFromNameArray(nameArray);
           }

           await ic.realignParserCls.realignOnSeqAlign();

           if(nameArray.length > 0) {
               thisClass.setLogCmd("realign on seq align | " + nameArray, true);
           }
           else {
               thisClass.setLogCmd("realign on seq align", true);
           }
        });

        me.myEventCls.onIds("#" + me.pre + "applyRealignByStruct", "click", async function(e) { me.icn3d;
            e.preventDefault();
            if(!me.cfg.notebook) dialog.dialog( "close" );

            await thisClass.setRealign('vast', false);
         });

         me.myEventCls.onIds("#" + me.pre + "applyRealignByStruct_tmalign", "click", async function(e) { me.icn3d;
            e.preventDefault();
            if(!me.cfg.notebook) dialog.dialog( "close" );

            await thisClass.setRealign('tmalign', false);
         });

         me.myEventCls.onIds("#" + me.pre + "applyRealignByStructMsa", "click", async function(e) { me.icn3d;
            e.preventDefault();
            if(!me.cfg.notebook) dialog.dialog( "close" );

            await thisClass.setRealign('vast', true);
         });

         me.myEventCls.onIds("#" + me.pre + "applyRealignByStructMsa_tmalign", "click", async function(e) { me.icn3d;
            e.preventDefault();
            if(!me.cfg.notebook) dialog.dialog( "close" );

            await thisClass.setRealign('tmalign', true);
         });

         me.myEventCls.onIds("#" + me.pre + "applyRealignByStruct_vastplus", "click", async function(e) { let ic = me.icn3d;
            e.preventDefault();
            if(!me.cfg.notebook) dialog.dialog( "close" );
            let nameArray = $("#" + me.pre + "atomsCustomRealignByStruct2").val();
            if(nameArray.length > 0) {
                ic.hAtoms = ic.definedSetsCls.getAtomsFromNameArray(nameArray);
            }

            //me.cfg.aligntool = 'tmalign';

            await ic.vastplusCls.realignOnVastplus();

            if(nameArray.length > 0) {
                thisClass.setLogCmd("realign on vastplus | " + nameArray, true);
            }
            else {
                thisClass.setLogCmd("realign on vastplus", true);
            }
         });


        me.myEventCls.onIds("#" + me.pre + "applyColorSpectrumAcrossSets", "click", function(e) { let ic = me.icn3d;
            e.preventDefault();
            if(!me.cfg.notebook) dialog.dialog( "close" );
            let nameArray = $("#" + me.pre + "atomsCustomColorSpectrumAcross").val();
            if(nameArray.length == 0) {
                alert("Please select some sets");
                return;
            }

            let bSpectrum = true;
            ic.setColorCls.setColorAcrossSets(nameArray, bSpectrum);

            thisClass.setLogCmd("set color spectrum | " + nameArray, true);
        });

        me.myEventCls.onIds("#" + me.pre + "applyColorSpectrumBySets", "click", function(e) { let ic = me.icn3d;
            e.preventDefault();
            if(!me.cfg.notebook) dialog.dialog( "close" );
            let nameArray = $("#" + me.pre + "atomsCustomColorSpectrum").val();
            if(nameArray.length == 0) {
                alert("Please select some sets");
                return;
            }

            let bSpectrum = true;
            ic.setColorCls.setColorBySets(nameArray, bSpectrum);

            thisClass.setLogCmd("set residues color spectrum | " + nameArray, true);
        });

        me.myEventCls.onIds("#" + me.pre + "applyColorRainbowAcrossSets", "click", function(e) { let ic = me.icn3d;
            e.preventDefault();
            if(!me.cfg.notebook) dialog.dialog( "close" );
            let nameArray = $("#" + me.pre + "atomsCustomColorRainbowAcross").val();
            if(nameArray.length == 0) {
                alert("Please select some sets");
                return;
            }

            let bSpectrum = false;
            ic.setColorCls.setColorAcrossSets(nameArray, bSpectrum);

            thisClass.setLogCmd("set color rainbow | " + nameArray, true);
        });

        me.myEventCls.onIds("#" + me.pre + "applyColorRainbowBySets", "click", function(e) { let ic = me.icn3d;
            e.preventDefault();
            if(!me.cfg.notebook) dialog.dialog( "close" );
            let nameArray = $("#" + me.pre + "atomsCustomColorRainbow").val();
            if(nameArray.length == 0) {
                alert("Please select some sets");
                return;
            }

            let bSpectrum = false;
            ic.setColorCls.setColorBySets(nameArray, bSpectrum);

            thisClass.setLogCmd("set residues color rainbow | " + nameArray, true);
        });

        // other
        me.myEventCls.onIds("#" + me.pre + "anno_summary", "click", function(e) { let ic = me.icn3d;
            e.preventDefault();
            ic.annotationCls.setAnnoViewAndDisplay('overview');
            thisClass.setLogCmd("set view overview", true);
        });
        me.myEventCls.onIds("#" + me.pre + "anno_details", "click", function(e) { let ic = me.icn3d;
            e.preventDefault();
            ic.annotationCls.setAnnoViewAndDisplay('detailed view');
            thisClass.setLogCmd("set view detailed view", true);
        });

        me.myEventCls.onIds("#" + me.pre + "show_annotations", "click", async function(e) { let ic = me.icn3d;
            await ic.showAnnoCls.showAnnotations();
            thisClass.setLogCmd("view annotations", true);
        });

        me.myEventCls.onIds("#" + me.pre + "showallchains", "click", function(e) { let ic = me.icn3d;
           ic.annotationCls.showAnnoAllChains();
           thisClass.setLogCmd("show annotations all chains", true);
        });

        me.myEventCls.onIds("#" + me.pre + "show_alignsequences", "click", function(e) { me.icn3d;
             me.htmlCls.dialogCls.openDlg('dl_alignment', 'Select residues in aligned sequences');
        });

        me.myEventCls.onIds(["#" + me.pre + "show_2ddgm", "#" + me.pre + "mn2_2ddgm"], "click", async function(e) { let ic = me.icn3d;
             me.htmlCls.dialogCls.openDlg('dl_2ddgm', '2D Diagram');
             await ic.viewInterPairsCls.retrieveInteractionData();
             thisClass.setLogCmd("view interactions", true);
        });

        me.myEventCls.onIds("#" + me.pre + "mn2_2ddepiction", "click", async function(e) { let ic = me.icn3d;
            await ic.ligplotCls.drawLigplot(ic.atoms, true);
            thisClass.setLogCmd("view 2d depiction", true);
       });

        me.myEventCls.onIds("#" + me.pre + "search_seq_button", "click", async function(e) { me.icn3d;
           e.stopImmediatePropagation();
           await thisClass.searchSeq();
        });

        me.myEventCls.onIds("#" + me.pre + "search_seq", "keyup", async function(e) { me.icn3d;
           if (e.keyCode === 13) {
               e.preventDefault();
               await thisClass.searchSeq();
           }
        });


        me.myEventCls.onIds("#" + me.pre + "reload_vastplus", "click", function(e) { let ic = me.icn3d;
            e.preventDefault();
            if(!me.cfg.notebook) dialog.dialog( "close" );
            thisClass.setLogCmd("vast+ search " + $("#" + me.pre + "vastpluspdbid").val(), false);
            let urlTarget = (ic.structures && Object.keys(ic.structures).length > 0) ? '_blank' : '_self';
            window.open('https://www.ncbi.nlm.nih.gov/Structure/vastplus/vastplus.cgi?uid=' + $("#" + me.pre + "vastpluspdbid").val(), urlTarget);
         });

        me.myEventCls.onIds("#" + me.pre + "reload_vast", "click", function(e) { let ic = me.icn3d;
            e.preventDefault();
            if(!me.cfg.notebook) dialog.dialog( "close" );
            thisClass.setLogCmd("vast search " + $("#" + me.pre + "vastpdbid").val() + "_" + $("#" + me.pre + "vastchainid").val(), false);
            let urlTarget = (ic.structures && Object.keys(ic.structures).length > 0) ? '_blank' : '_self';
            window.open('https://www.ncbi.nlm.nih.gov/Structure/vast/vastsrv.cgi?pdbid=' + $("#" + me.pre + "vastpdbid").val() + '&chain=' + $("#" + me.pre + "vastchainid").val(), urlTarget);
         });

        me.myEventCls.onIds("#" + me.pre + "reload_foldseek", "click", function(e) { me.icn3d;
            e.preventDefault();
            if(!me.cfg.notebook) dialog.dialog( "close" );

            let alignment = $("#" + me.pre + "foldseekchainids").val();
            let alignment_final = thisClass.convertUniProtInChains(alignment);

            thisClass.setLogCmd("load chainalignment " + alignment_final, true);
            window.open(hostUrl + '?chainalign=' + alignment_final + '&aligntool=tmalign&showalignseq=1&bu=0', '_self');
         });

        me.myEventCls.onIds("#" + me.pre + "reload_mmtf", "click", function(e) { let ic = me.icn3d;
           e.preventDefault();
           if(!me.cfg.notebook) dialog.dialog( "close" );
           thisClass.setLogCmd("load bcif " + $("#" + me.pre + "mmtfid").val(), false);
           let urlTarget = (ic.structures && Object.keys(ic.structures).length > 0) ? '_blank' : '_self';
           window.open(hostUrl + '?bcifid=' + $("#" + me.pre + "mmtfid").val(), urlTarget);
        });

        me.myEventCls.onIds("#" + me.pre + "mmtfid", "keyup", function(e) { let ic = me.icn3d;
           if (e.keyCode === 13) {
               e.preventDefault();
               if(!me.cfg.notebook) dialog.dialog( "close" );
               thisClass.setLogCmd("load mmtf " + $("#" + me.pre + "mmtfid").val(), false);
               let urlTarget = (ic.structures && Object.keys(ic.structures).length > 0) ? '_blank' : '_self';
               window.open(hostUrl + '?mmtfid=' + $("#" + me.pre + "mmtfid").val(), urlTarget);
           }
        });


        me.myEventCls.onIds("#" + me.pre + "reload_pdb", "click", function(e) { let ic = me.icn3d;
           e.preventDefault();
           if(!me.cfg.notebook) dialog.dialog( "close" );
           thisClass.setLogCmd("load pdb " + $("#" + me.pre + "pdbid").val(), false);
           let urlTarget = (ic.structures && Object.keys(ic.structures).length > 0) ? '_blank' : '_self';
           window.open(hostUrl + '?pdbid=' + $("#" + me.pre + "pdbid").val(), urlTarget);
        });

        me.myEventCls.onIds("#" + me.pre + "translate_pdb", "click", function(e) { let ic = me.icn3d;
            e.preventDefault();
            if(!me.cfg.notebook) dialog.dialog( "close" );
            let dx = $("#" + me.pre + "translateX").val();
            let dy = $("#" + me.pre + "translateY").val();
            let dz = $("#" + me.pre + "translateZ").val();

            ic.transformCls.translateCoord(ic.hAtoms, parseFloat(dx), parseFloat(dy), parseFloat(dz));
            ic.drawCls.draw();

            thisClass.setLogCmd("translate pdb " + dx + " " + dy + " "  + dz, true);
        });

        me.myEventCls.onIds("#" + me.pre + "measure_angle", "click", function(e) { me.icn3d;
            e.preventDefault();
            if(!me.cfg.notebook) dialog.dialog( "close" );
            let v1X = $("#" + me.pre + "v1X").val();
            let v1Y = $("#" + me.pre + "v1Y").val();
            let v1Z= $("#" + me.pre + "v1Z").val();

            let v2X = $("#" + me.pre + "v2X").val();
            let v2Y = $("#" + me.pre + "v2Y").val();
            let v2Z = $("#" + me.pre + "v2Z").val();

            let angleRad = new THREE.Vector3(parseFloat(v1X), parseFloat(v1Y), parseFloat(v1Z)).angleTo(new THREE.Vector3(parseFloat(v2X), parseFloat(v2Y), parseFloat(v2Z)));
            let angle = angleRad / 3.1416 * 180;
            angle = Math.abs(angle).toFixed(0);
            if(angle > 180) angle -= 180;
            if(angle > 90) angle = 180 - angle;

            thisClass.setLogCmd("The angle is " + angle + " degree", false);
            $("#" + me.pre + "angle_value").val(angle);
        });

        me.myEventCls.onIds("#" + me.pre + "matrix_pdb", "click", function(e) { let ic = me.icn3d;
            e.preventDefault();
            if(!me.cfg.notebook) dialog.dialog( "close" );
            let mArray = [];
            for(let i = 0; i< 16; ++i) {
                mArray.push(parseFloat($("#" + me.pre + "matrix" + i).val()));
            }

            ic.transformCls.rotateCoord(ic.hAtoms, mArray);
            ic.drawCls.draw();

            thisClass.setLogCmd("rotate pdb " + mArray, true);
        });

        me.myEventCls.onIds("#" + me.pre + "pdbid", "keyup", function(e) { let ic = me.icn3d;
           if (e.keyCode === 13) {
               e.preventDefault();
               if(!me.cfg.notebook) dialog.dialog( "close" );
               thisClass.setLogCmd("load pdb " + $("#" + me.pre + "pdbid").val(), false);
               let urlTarget = (ic.structures && Object.keys(ic.structures).length > 0) ? '_blank' : '_self';
               window.open(hostUrl + '?pdbid=' + $("#" + me.pre + "pdbid").val(), urlTarget);
           }
        });

        me.myEventCls.onIds("#" + me.pre + "reload_af", "click", function(e) { let ic = me.icn3d;
           e.preventDefault();
           if(!me.cfg.notebook) dialog.dialog( "close" );
           thisClass.setLogCmd("load af " + $("#" + me.pre + "afid").val(), false);
           let urlTarget = (ic.structures && Object.keys(ic.structures).length > 0) ? '_blank' : '_self';
           window.open(hostUrl + '?afid=' + $("#" + me.pre + "afid").val(), urlTarget);
        });

        me.myEventCls.onIds("#" + me.pre + "reload_afmap", "click", async function(e) { let ic = me.icn3d;
            e.preventDefault();
            if(!me.cfg.notebook) dialog.dialog( "close" );
            let afid = me.cfg.afid ? me.cfg.afid : $("#" + me.pre + "afid").val();

            thisClass.setLogCmd("set half pae map " + afid, true);
            
            await ic.contactMapCls.afErrorMap(afid);
        });
        me.myEventCls.onIds("#" + me.pre + "reload_afmapfull", "click", async function(e) { let ic = me.icn3d;
            e.preventDefault();
            if(!me.cfg.notebook) dialog.dialog( "close" );
            let afid = me.cfg.afid ? me.cfg.afid : $("#" + me.pre + "afid").val();

            thisClass.setLogCmd("set full pae map " + afid, true);
            
            await ic.contactMapCls.afErrorMap(afid, true);
        });

        me.myEventCls.onIds("#" + me.pre + "afid", "keyup", function(e) { let ic = me.icn3d;
           if (e.keyCode === 13) {
               e.preventDefault();
               if(!me.cfg.notebook) dialog.dialog( "close" );
               thisClass.setLogCmd("load af " + $("#" + me.pre + "afid").val(), false);
               let urlTarget = (ic.structures && Object.keys(ic.structures).length > 0) ? '_blank' : '_self';
               window.open(hostUrl + '?afid=' + $("#" + me.pre + "afid").val(), urlTarget);
           }
        });

        me.myEventCls.onIds("#" + me.pre + "reload_opm", "click", function(e) { let ic = me.icn3d;
           e.preventDefault();
           if(!me.cfg.notebook) dialog.dialog( "close" );
           thisClass.setLogCmd("load opm " + $("#" + me.pre + "opmid").val(), false);
           let urlTarget = (ic.structures && Object.keys(ic.structures).length > 0) ? '_blank' : '_self';
           window.open(hostUrl + '?opmid=' + $("#" + me.pre + "opmid").val(), urlTarget);
        });

        me.myEventCls.onIds("#" + me.pre + "opmid", "keyup", function(e) { let ic = me.icn3d;
           if (e.keyCode === 13) {
               e.preventDefault();
               if(!me.cfg.notebook) dialog.dialog( "close" );
               thisClass.setLogCmd("load opm " + $("#" + me.pre + "opmid").val(), false);
               let urlTarget = (ic.structures && Object.keys(ic.structures).length > 0) ? '_blank' : '_self';
               window.open(hostUrl + '?opmid=' + $("#" + me.pre + "opmid").val(), urlTarget);
           }
        });

        me.myEventCls.onIds("#" + me.pre + "reload_align_refined", "click", function(e) { let ic = me.icn3d;
            e.preventDefault();
            if(!me.cfg.notebook) dialog.dialog( "close" );
            let alignment = $("#" + me.pre + "alignid1").val() + "," + $("#" + me.pre + "alignid2").val();
            thisClass.setLogCmd("load alignment " + alignment + ' | parameters &atype=1&bu=1', false);
            let urlTarget = (ic.structures && Object.keys(ic.structures).length > 0) ? '_blank' : '_self';
            window.open(hostUrl + '?align=' + alignment + '&showalignseq=1&atype=1&bu=1', urlTarget);
         });

        me.myEventCls.onIds("#" + me.pre + "reload_align_ori", "click", function(e) { let ic = me.icn3d;
            e.preventDefault();
            if(!me.cfg.notebook) dialog.dialog( "close" );
            let alignment = $("#" + me.pre + "alignid1").val() + "," + $("#" + me.pre + "alignid2").val();
            thisClass.setLogCmd("load alignment " + alignment + ' | parameters &atype=0&bu=1', false);
            let urlTarget = (ic.structures && Object.keys(ic.structures).length > 0) ? '_blank' : '_self';
            window.open(hostUrl + '?align=' + alignment + '&showalignseq=1&atype=0&bu=1', urlTarget);
         });

        me.myEventCls.onIds("#" + me.pre + "reload_align_tmalign", "click", function(e) { let ic = me.icn3d;
            e.preventDefault();
            if(!me.cfg.notebook) dialog.dialog( "close" );
            let alignment = $("#" + me.pre + "alignid1").val() + "," + $("#" + me.pre + "alignid2").val();
            thisClass.setLogCmd("load alignment " + alignment + ' | parameters &atype=2&bu=1', false);
            let urlTarget = (ic.structures && Object.keys(ic.structures).length > 0) ? '_blank' : '_self';
            window.open(hostUrl + '?align=' + alignment + '&showalignseq=1&atype=2&bu=1', urlTarget);
         });

        me.myEventCls.onIds("#" + me.pre + "reload_alignaf", "click", function(e) { let ic = me.icn3d;
            e.preventDefault();
            if(!me.cfg.notebook) dialog.dialog( "close" );
            let alignment = $("#" + me.pre + "alignafid1").val() + "_A," + $("#" + me.pre + "alignafid2").val() + "_A";
            thisClass.setLogCmd("load chains " + alignment + " | residues | resdef ", false);
            let urlTarget = (ic.structures && Object.keys(ic.structures).length > 0) ? '_blank' : '_self';
            window.open(hostUrl + '?chainalign=' + alignment + '&resnum=&resdef=&showalignseq=1', urlTarget);
          });

        me.myEventCls.onIds("#" + me.pre + "reload_alignaf_tmalign", "click", function(e) { let ic = me.icn3d;
            e.preventDefault();
            if(!me.cfg.notebook) dialog.dialog( "close" );
            let alignment = $("#" + me.pre + "alignafid1").val() + "_A," + $("#" + me.pre + "alignafid2").val() + "_A";
            thisClass.setLogCmd("load chains " + alignment + " | residues | resdef | align tmalign", false);
            let urlTarget = (ic.structures && Object.keys(ic.structures).length > 0) ? '_blank' : '_self';
            window.open(hostUrl + '?chainalign=' + alignment + '&aligntool=tmalign&resnum=&resdef=&showalignseq=1', urlTarget);
          });


        me.myEventCls.onIds("#" + me.pre + "reload_chainalign_asym", "click", function(e) { let ic = me.icn3d;
           e.preventDefault();
           if(!me.cfg.notebook) dialog.dialog( "close" );

           let alignment = $("#" + me.pre + "chainalignids").val();
           let alignment_final = thisClass.convertUniProtInChains(alignment);

           thisClass.setLogCmd("load chains " + alignment_final + " on asymmetric unit | residues | resdef ", false);
           let urlTarget = (ic.structures && Object.keys(ic.structures).length > 0) ? '_blank' : '_self';
           window.open(hostUrl + '?chainalign=' + alignment_final + '&resnum=&resdef=&showalignseq=1&bu=0', urlTarget);
        });

        me.myEventCls.onIds("#" + me.pre + "reload_chainalign_asym2", "click", function(e) { let ic = me.icn3d;
            e.preventDefault();
            if(!me.cfg.notebook) dialog.dialog( "close" );
 
            let alignment = $("#" + me.pre + "chainalignids2").val();
            let alignment_final = thisClass.convertUniProtInChains(alignment);
            let resalign = $("#" + me.pre + "resalignids").val();
 
            thisClass.setLogCmd("load chains " + alignment_final + " on asymmetric unit | residues " + resalign + " | resdef ", false);
            let urlTarget = (ic.structures && Object.keys(ic.structures).length > 0) ? '_blank' : '_self';
            window.open(hostUrl + '?chainalign=' + alignment_final + '&resnum=' + resalign + '&resdef=&showalignseq=1&bu=0', urlTarget);
         });

         me.myEventCls.onIds("#" + me.pre + "reload_chainalign_asym3", "click", function(e) { let ic = me.icn3d;
            e.preventDefault();
            if(!me.cfg.notebook) dialog.dialog( "close" );
 
            let alignment = $("#" + me.pre + "chainalignids3").val();
            let alignment_final = thisClass.convertUniProtInChains(alignment);

            let predefinedres = $("#" + me.pre + "predefinedres").val().trim().replace(/\n/g, ': ');
            if(predefinedres && alignment_final.split(',').length - 1 != predefinedres.split(': ').length) {
                alert("Please make sure the number of chains and the lines of predefined residues are the same...");
                return;
            }
 
            thisClass.setLogCmd("load chains " + alignment_final + " on asymmetric unit | residues | resdef " + predefinedres, false);
            let urlTarget = (ic.structures && Object.keys(ic.structures).length > 0) ? '_blank' : '_self';
            window.open(hostUrl + '?chainalign=' + alignment_final + '&resnum=&resdef=' + predefinedres + '&showalignseq=1&bu=0', urlTarget);
         });

         me.myEventCls.onIds("#" + me.pre + "reload_chainalign_asym4", "click", async function(e) { let ic = me.icn3d;
            e.preventDefault();
            if(!me.cfg.notebook) dialog.dialog( "close" );
 
            let alignment = $("#" + me.pre + "chainalignids4").val();
            let alignment_final = thisClass.convertUniProtInChains(alignment);

            let predefinedres = $("#" + me.pre + "predefinedres2").val().trim().replace(/\n/g, ': ');
            if(predefinedres && alignment_final.split(',').length - 1 != predefinedres.split(': ').length) {
                alert("Please make sure the number of chains and the lines of predefined residues are the same...");
                return;
            }

            me.cfg.resdef = predefinedres.replace(/:/gi, ';');

            let bRealign = true, bPredefined = true;
            let chainidArray = alignment_final.split(',');
            await ic.realignParserCls.realignChainOnSeqAlign(undefined, chainidArray, bRealign, bPredefined);
 
            thisClass.setLogCmd("realign predefined " + alignment_final + " " + predefinedres, true);
         });

        me.myEventCls.onIds("#" + me.pre + "reload_chainalign_tmalign", "click", function(e) { let ic = me.icn3d;
            e.preventDefault();
            if(!me.cfg.notebook) dialog.dialog( "close" );

            let alignment = $("#" + me.pre + "chainalignids").val();
            let alignment_final = thisClass.convertUniProtInChains(alignment);
 
            thisClass.setLogCmd("load chains " + alignment_final + " on asymmetric unit | residues | resdef | align tmalign", false);
            let urlTarget = (ic.structures && Object.keys(ic.structures).length > 0) ? '_blank' : '_self';
            window.open(hostUrl + '?chainalign=' + alignment_final + '&aligntool=tmalign&resnum=&resdef=&showalignseq=1&bu=0', urlTarget);
         });

        me.myEventCls.onIds("#" + me.pre + "reload_mutation_3d", "click", async function(e) { let ic = me.icn3d;
           e.preventDefault();
           if(!me.cfg.notebook) dialog.dialog( "close" );
           let mutationids = $("#" + me.pre + "mutationids").val();
           //let idsource = $("#" + me.pre + "idsource").val();
           let idsource, pdbsource;
           if($("#" + me.pre + "type_mmdbid").is(":checked")) {
                idsource = 'mmdbid';
           }
           else {
                idsource = 'afid';
           }
           if($("#" + me.pre + "showin_currentpage").is(":checked")) {
                pdbsource = 'currentpage';
            }
            else {
                pdbsource = 'newpage';
            }

           if(pdbsource == 'currentpage') {
                let snp = mutationids;

                await ic.scapCls.retrieveScap(snp);
                thisClass.setLogCmd('scap 3d ' + snp, true);
                thisClass.setLogCmd("select displayed set", true);
           }
           else {
                let mmdbid = mutationids.substr(0, mutationids.indexOf('_'));           
                thisClass.setLogCmd("3d of mutation " + mutationids, false);
                let urlTarget = (ic.structures && Object.keys(ic.structures).length > 0) ? '_blank' : '_self';
                window.open(hostUrl + '?' + idsource + '=' + mmdbid + '&command=scap 3d ' + mutationids + '; select displayed set', urlTarget);
           }
        });

        me.myEventCls.onIds("#" + me.pre + "reload_mutation_pdb", "click", async function(e) { let ic = me.icn3d;
           e.preventDefault();
           if(!me.cfg.notebook) dialog.dialog( "close" );
           let mutationids = $("#" + me.pre + "mutationids").val();
           //let idsource = $("#" + me.pre + "idsource").val();
           let idsource, pdbsource;
           if($("#" + me.pre + "type_mmdbid").is(":checked")) {
                idsource = 'mmdbid';
           }
           else {
                idsource = 'afid';
           }
           if($("#" + me.pre + "showin_currentpage").is(":checked")) {
                pdbsource = 'currentpage';
            }
            else {
                pdbsource = 'newpage';
            }

           if(pdbsource == 'currentpage') {
                let snp = mutationids;

                let bPdb = true;
                await ic.scapCls.retrieveScap(snp, undefined, bPdb);
                thisClass.setLogCmd('scap pdb ' + snp, true);
           }
           else {
                let mmdbid = mutationids.substr(0, mutationids.indexOf('_'));
                thisClass.setLogCmd("pdb of mutation " + mutationids, false);
                let urlTarget = (ic.structures && Object.keys(ic.structures).length > 0) ? '_blank' : '_self';
                window.open(hostUrl + '?' + idsource + '=' + mmdbid + '&command=scap pdb ' + mutationids + '; select displayed set', urlTarget);
           }
        });

        me.myEventCls.onIds("#" + me.pre + "reload_mutation_inter", "click", async function(e) { let ic = me.icn3d;
           e.preventDefault();
           if(!me.cfg.notebook) dialog.dialog( "close" );
           let mutationids = $("#" + me.pre + "mutationids").val();
           //let idsource = $("#" + me.pre + "idsource").val();
           let idsource, pdbsource;
           if($("#" + me.pre + "type_mmdbid").is(":checked")) {
                idsource = 'mmdbid';
           }
           else {
                idsource = 'afid';
           }
           if($("#" + me.pre + "showin_currentpage").is(":checked")) {
                pdbsource = 'currentpage';
            }
            else {
                pdbsource = 'newpage';
            }

           if(pdbsource == 'currentpage') {
                let snp = mutationids;

                let bInteraction = true;
                await ic.scapCls.retrieveScap(snp, bInteraction);
                thisClass.setLogCmd('scap interaction ' + snp, true);

                let idArray = snp.split('_'); //stru_chain_resi_snp
                let select = '.' + idArray[1] + ':' + idArray[2];
                let name = 'snp_' + idArray[1] + '_' + idArray[2];
                thisClass.setLogCmd("select " + select + " | name " + name, true);
                thisClass.setLogCmd("line graph interaction pairs | selected non-selected | hbonds,salt bridge,interactions,halogen,pi-cation,pi-stacking | false | threshold 3.8 6 4 3.8 6 5.5", true);
                thisClass.setLogCmd("adjust dialog dl_linegraph", true);
                thisClass.setLogCmd("select displayed set", true);
           }
           else {
                let mutationArray = mutationids.split(',');
                let residArray = [];
                for(let i = 0, il = mutationArray.length; i < il; ++i) {
                    let pos = mutationArray[i].lastIndexOf('_');
                    let resid = mutationArray[i].substr(0, pos);
                    residArray.push(resid);
                }

                let mmdbid = mutationids.substr(0, mutationids.indexOf('_'));

                // if no structures are loaded yet
                if(!ic.structures) {
                    ic.structures = {};
                    ic.structures[mmdbid] = 1;
                }
                ic.resid2specCls.residueids2spec(residArray);

                thisClass.setLogCmd("interaction change of mutation " + mutationids, false);
                let urlTarget = (ic.structures && Object.keys(ic.structures).length > 0) ? '_blank' : '_self';
                window.open(hostUrl + '?' + idsource + '=' + mmdbid + '&command=scap interaction ' + mutationids, urlTarget);
           }
        });

        me.myEventCls.onIds("#" + me.pre + "reload_mmcif", "click", function(e) { let ic = me.icn3d;
           e.preventDefault();
           if(!me.cfg.notebook) dialog.dialog( "close" );
           thisClass.setLogCmd("load mmcif " + $("#" + me.pre + "mmcifid").val(), false);
           let urlTarget = (ic.structures && Object.keys(ic.structures).length > 0) ? '_blank' : '_self';
           window.open(hostUrl + '?mmcifid=' + $("#" + me.pre + "mmcifid").val(), urlTarget);
        });

        me.myEventCls.onIds("#" + me.pre + "mmcifid", "keyup", function(e) { let ic = me.icn3d;
           if (e.keyCode === 13) {
               e.preventDefault();
               if(!me.cfg.notebook) dialog.dialog( "close" );
               thisClass.setLogCmd("load mmcif " + $("#" + me.pre + "mmcifid").val(), false);
               let urlTarget = (ic.structures && Object.keys(ic.structures).length > 0) ? '_blank' : '_self';
               window.open(hostUrl + '?mmcifid=' + $("#" + me.pre + "mmcifid").val(), urlTarget);
           }
        });


        me.myEventCls.onIds("#" + me.pre + "reload_mmdb", "click", function(e) { let ic = me.icn3d;
           e.preventDefault();
           
           thisClass.setLogCmd("load mmdb1 " + $("#" + me.pre + "mmdbid").val(), false);
           let urlTarget = (ic.structures && Object.keys(ic.structures).length > 0) ? '_blank' : '_self';
           window.open(hostUrl + '?mmdbid=' + $("#" + me.pre + "mmdbid").val() + '&bu=1', urlTarget);
        });

        me.myEventCls.onIds("#" + me.pre + "reload_mmdb_asym", "click", function(e) { let ic = me.icn3d;
            e.preventDefault();
            
            thisClass.setLogCmd("load mmdb0 " + $("#" + me.pre + "mmdbid").val(), false);
            let urlTarget = (ic.structures && Object.keys(ic.structures).length > 0) ? '_blank' : '_self';
            window.open(hostUrl + '?mmdbid=' + $("#" + me.pre + "mmdbid").val() + '&bu=0', urlTarget);
        });

         me.myEventCls.onIds("#" + me.pre + "reload_mmdbaf", "click", function(e) { me.icn3d;
            e.preventDefault();
            let ids = $("#" + me.pre + "mmdbafid").val();
            thisClass.launchMmdb(ids, 1, hostUrl);
        });
 
         me.myEventCls.onIds("#" + me.pre + "reload_mmdbaf_asym", "click", function(e) { me.icn3d;
            e.preventDefault();
            let ids = $("#" + me.pre + "mmdbafid").val();
            thisClass.launchMmdb(ids, 0, hostUrl);
        });

        me.myEventCls.onIds("#" + me.pre + "reload_mmdbaf_append", "click", function(e) { me.icn3d;
            e.preventDefault();
            let ids = $("#" + me.pre + "mmdbafid").val();
            thisClass.launchMmdb(ids, 1, hostUrl, true);
        });
 
         me.myEventCls.onIds("#" + me.pre + "reload_mmdbaf_asym_append", "click", function(e) { me.icn3d;
            e.preventDefault();
            let ids = $("#" + me.pre + "mmdbafid").val();
            thisClass.launchMmdb(ids, 0, hostUrl, true);
        });

        me.myEventCls.onIds("#" + me.pre + "mmdbid", "keyup", function(e) { let ic = me.icn3d;
           if (e.keyCode === 13) {
               e.preventDefault();
               
               thisClass.setLogCmd("load mmdb1 " + $("#" + me.pre + "mmdbid").val(), false);
               let urlTarget = (ic.structures && Object.keys(ic.structures).length > 0) ? '_blank' : '_self';
               window.open(hostUrl + '?mmdbid=' + $("#" + me.pre + "mmdbid").val() + '&bu=1', urlTarget);
              }
        });

        me.myEventCls.onIds("#" + me.pre + "mmdbafid", "keyup", function(e) { me.icn3d;
            if (e.keyCode === 13) {
                e.preventDefault();
                
                let ids = $("#" + me.pre + "mmdbafid").val();
                thisClass.launchMmdb(ids, 1, hostUrl);
               }
         });


        me.myEventCls.onIds("#" + me.pre + "reload_blast_rep_id", "click", function(e) { let ic = me.icn3d;
           e.preventDefault();
           if(!me.cfg.notebook) dialog.dialog( "close" );
           let query_id = $("#" + me.pre + "query_id").val().trim();
           if(query_id.substr(1, 2) == 'M_') { // e.g., NM_..., XM_...
                alert("You are inputting a nucleotide accession " + query_id + ". Please use a protein accession instead.");
                return;
           }
           let query_fasta = encodeURIComponent($("#" + me.pre + "query_fasta").val());
           let blast_rep_id = $("#" + me.pre + "blast_rep_id").val();
           thisClass.setLogCmd("load seq_struct_ids " + query_id + "," + blast_rep_id, false);
           query_id =(query_id !== '' && query_id !== undefined) ? query_id : query_fasta;
           let urlTarget = (ic.structures && Object.keys(ic.structures).length > 0) ? '_blank' : '_self';
           window.open(hostUrl + '?from=icn3d&alg=blast&blast_rep_id=' + blast_rep_id
             + '&query_id=' + query_id
             + '&command=view annotations; set annotation cdd; set annotation site; set view detailed view; select chain '
             + blast_rep_id + '; show selection', urlTarget);
        });

        me.myEventCls.onIds("#" + me.pre + "run_esmfold", "click", async function(e) { let ic = me.icn3d;
            e.preventDefault();
            if(!me.cfg.notebook) dialog.dialog( "close" );

            if($('#' + me.pre + 'dl_mmdbafid').hasClass('ui-dialog-content')) {
                $('#' + me.pre + 'dl_mmdbafid').dialog( 'close' );
            }

            let esmfold_fasta = $("#" + me.pre + "esmfold_fasta").val();
            let pdbid = 'stru--';

            if(esmfold_fasta.indexOf('>') != -1) { //FASTA with header
                let pos = esmfold_fasta.indexOf('\n');
                ic.esmTitle = esmfold_fasta.substr(1, pos - 1).trim();
                if(ic.esmTitle.indexOf('|') != -1) { // uniprot
                    let idArray = ic.esmTitle.split('|');
                    pdbid = (idArray.length > 2) ? idArray[1] : ic.esmTitle;
                }
                else { // NCBI
                    pdbid = (ic.esmTitle.indexOf(' ') != -1) ? ic.esmTitle.substr(0, ic.esmTitle.indexOf(' ')) : ic.esmTitle;
                }

                if(pdbid.length < 6) pdbid = pdbid.padEnd(6, '-');

                esmfold_fasta = esmfold_fasta.substr(pos + 1);
            }

            // remove new lines
            esmfold_fasta = esmfold_fasta.replace(/\s/g, '');

            if(esmfold_fasta.length > 400) {
                alert("Your sequence is larger than 400 characters. Please consider to split it as described at https://github.com/facebookresearch/esm/issues/21.");
                return;
            }

            let esmUrl = "https://api.esmatlas.com/foldSequence/v1/pdb/";
            let alertMess = 'Problem in returning PDB from ESMFold server...';
            thisClass.setLogCmd("Run ESMFold with the sequence " + esmfold_fasta, false);

            let esmData = await me.getAjaxPostPromise(esmUrl, esmfold_fasta, true, alertMess, undefined, true, 'text');
            
            ic.bResetAnno = true;
            
            ic.bInputfile = true;
            ic.InputfileType = 'pdb';
            ic.InputfileData = (ic.InputfileData) ? ic.InputfileData + '\nENDMDL\n' + esmData : esmData;

            ic.bEsmfold = true;
            let bAppend = true;
            await ic.pdbParserCls.loadPdbData(esmData, pdbid, undefined, bAppend, undefined, undefined, undefined, ic.bEsmfold);
         });

        me.myEventCls.onIds("#" + me.pre + "reload_alignsw", "click", function(e) { let ic = me.icn3d;
            e.preventDefault();
            if(!me.cfg.notebook) dialog.dialog( "close" );
            let query_id = $("#" + me.pre + "query_id").val().trim();
            if(query_id.substr(1, 2) == 'M_') { // e.g., NM_..., XM_...
                alert("You are inputting a nucleotide accession " + query_id + ". Please use a protein accession instead.");
                return;
            }
            let query_fasta = encodeURIComponent($("#" + me.pre + "query_fasta").val());
            let blast_rep_id = $("#" + me.pre + "blast_rep_id").val();
            thisClass.setLogCmd("load seq_struct_ids_smithwm " + query_id + "," + blast_rep_id, false);
            query_id =(query_id !== '' && query_id !== undefined) ? query_id : query_fasta;
            
            let urlTarget = (ic.structures && Object.keys(ic.structures).length > 0) ? '_blank' : '_self';
            window.open(hostUrl + '?from=icn3d&alg=smithwm&blast_rep_id=' + blast_rep_id
              + '&query_id=' + query_id
              + '&command=view annotations; set annotation cdd; set annotation site; set view detailed view; select chain '
              + blast_rep_id + '; show selection', urlTarget);
         });

         me.myEventCls.onIds("#" + me.pre + "reload_alignswlocal", "click", function(e) { let ic = me.icn3d;
            e.preventDefault();
            if(!me.cfg.notebook) dialog.dialog( "close" );
            let query_id = $("#" + me.pre + "query_id").val().trim();
            if(query_id.substr(1, 2) == 'M_') { // e.g., NM_..., XM_...
                alert("You are inputting a nucleotide accession " + query_id + ". Please use a protein accession instead.");
                return;
            }
            let query_fasta = encodeURIComponent($("#" + me.pre + "query_fasta").val());
            let blast_rep_id = $("#" + me.pre + "blast_rep_id").val();
            thisClass.setLogCmd("load seq_struct_ids_local_smithwm " + query_id + "," + blast_rep_id, false);
            query_id =(query_id !== '' && query_id !== undefined) ? query_id : query_fasta;
            
            let urlTarget = (ic.structures && Object.keys(ic.structures).length > 0) ? '_blank' : '_self';
            window.open(hostUrl + '?from=icn3d&alg=local_smithwm&blast_rep_id=' + blast_rep_id
              + '&query_id=' + query_id
              + '&command=view annotations; set annotation cdd; set annotation site; set view detailed view; select chain '
              + blast_rep_id + '; show selection', urlTarget);
         });


        me.myEventCls.onIds("#" + me.pre + "reload_proteinname", "click", function(e) { let ic = me.icn3d;
           e.preventDefault();
           if(!me.cfg.notebook) dialog.dialog( "close" );
           thisClass.setLogCmd("load protein " + $("#" + me.pre + "proteinname").val(), false);
           let urlTarget = (ic.structures && Object.keys(ic.structures).length > 0) ? '_blank' : '_self';
           window.open(hostUrl + '?protein=' + $("#" + me.pre + "proteinname").val(), urlTarget);
        });

        me.myEventCls.onIds("#" + me.pre + "reload_refseq", "click", function(e) { let ic = me.icn3d;
            e.preventDefault();
            if(!me.cfg.notebook) dialog.dialog( "close" );
            thisClass.setLogCmd("load refseq " + $("#" + me.pre + "refseqid").val(), false);
            let urlTarget = (ic.structures && Object.keys(ic.structures).length > 0) ? '_blank' : '_self';
            window.open(hostUrl + '?refseqid=' + $("#" + me.pre + "refseqid").val(), urlTarget);
         });

        me.myEventCls.onIds("#" + me.pre + "gi", "keyup", function(e) { let ic = me.icn3d;
           if (e.keyCode === 13) {
               e.preventDefault();
               if(!me.cfg.notebook) dialog.dialog( "close" );
               thisClass.setLogCmd("load gi " + $("#" + me.pre + "gi").val(), false);
               let urlTarget = (ic.structures && Object.keys(ic.structures).length > 0) ? '_blank' : '_self';
               window.open(hostUrl + '?gi=' + $("#" + me.pre + "gi").val(), urlTarget);
           }
        });

        me.myEventCls.onIds("#" + me.pre + "reload_uniprotid", "click", function(e) { let ic = me.icn3d;
           e.preventDefault();
           if(!me.cfg.notebook) dialog.dialog( "close" );
           thisClass.setLogCmd("load uniprotid " + $("#" + me.pre + "uniprotid").val(), false);
           let urlTarget = (ic.structures && Object.keys(ic.structures).length > 0) ? '_blank' : '_self';
           window.open(hostUrl + '?uniprotid=' + $("#" + me.pre + "uniprotid").val(), urlTarget);
        });

        me.myEventCls.onIds("#" + me.pre + "uniprotid", "keyup", function(e) { let ic = me.icn3d;
           if (e.keyCode === 13) {
               e.preventDefault();
               if(!me.cfg.notebook) dialog.dialog( "close" );
               thisClass.setLogCmd("load uniprotid " + $("#" + me.pre + "uniprotid").val(), false);
               let urlTarget = (ic.structures && Object.keys(ic.structures).length > 0) ? '_blank' : '_self';
               window.open(hostUrl + '?uniprotid=' + $("#" + me.pre + "uniprotid").val(), urlTarget);
           }
        });


        me.myEventCls.onIds("#" + me.pre + "reload_cid", "click", function(e) { let ic = me.icn3d;
           e.preventDefault();
           if(!me.cfg.notebook) dialog.dialog( "close" );
           thisClass.setLogCmd("load cid " + $("#" + me.pre + "cid").val(), false);
           let urlTarget = (ic.structures && Object.keys(ic.structures).length > 0) ? '_blank' : '_self';
           window.open(hostUrl + '?cid=' + $("#" + me.pre + "cid").val(), urlTarget);
        });

        me.myEventCls.onIds("#" + me.pre + "reload_smiles", "click", function(e) { let ic = me.icn3d;
            e.preventDefault();
            if(!me.cfg.notebook) dialog.dialog( "close" );
            // thisClass.setLogCmd("load smiles " + $("#" + me.pre + "smiles").val(), false);
            let urlTarget = (ic.structures && Object.keys(ic.structures).length > 0) ? '_blank' : '_self';

            urlTarget = '_blank';

            window.open(hostUrl + '?smiles=' + encodeURIComponent($("#" + me.pre + "smiles").val()), urlTarget);
        });

        me.myEventCls.onIds("#" + me.pre + "cid", "keyup", function(e) { let ic = me.icn3d;
           if (e.keyCode === 13) {
               e.preventDefault();
               if(!me.cfg.notebook) dialog.dialog( "close" );
               thisClass.setLogCmd("load cid " + $("#" + me.pre + "cid").val(), false);
               let urlTarget = (ic.structures && Object.keys(ic.structures).length > 0) ? '_blank' : '_self';
               window.open(hostUrl + '?cid=' + $("#" + me.pre + "cid").val(), urlTarget);
           }
        });


        me.htmlCls.setHtmlCls.clickReload_pngimage();

        me.myEventCls.onIds("#" + me.pre + "reload_state", "click", function(e) { let ic = me.icn3d;
           e.preventDefault();
           if(!me.cfg.notebook) dialog.dialog( "close" );
           //close all dialog
           if(!me.cfg.notebook) {
               $(".ui-dialog-content").dialog("close");
           }
           else {
               ic.resizeCanvasCls.closeDialogs();
           }
           // initialize icn3dui
           //Do NOT clear data if iCn3D loads a pdb or other data file and then load a state file
           if(!ic.bInputfile) {
               //ic.initUI();
               ic.init();
           }
           let file = $("#" + me.pre + "state")[0].files[0];
           if(!file) {
             alert("Please select a file before clicking 'Load'");
           }
           else {
             me.htmlCls.setHtmlCls.fileSupport();
             let reader = new FileReader();
             reader.onload = async function(e) {
               ic.bStatefile = true;

               let dataStr = e.target.result; // or = reader.result;
               thisClass.setLogCmd('load state file ' + $("#" + me.pre + "state").val(), false);
               ic.commands = [];
               ic.optsHistory = [];
               await ic.loadScriptCls.loadScript(dataStr, true);
             };
             reader.readAsText(file);
           }
        });

        me.myEventCls.onIds("#" + me.pre + "reload_selectionfile", "click", function(e) { let ic = me.icn3d;
           e.preventDefault();
           if(!me.cfg.notebook) dialog.dialog( "close" );
           let file = $("#" + me.pre + "selectionfile")[0].files[0];
           if(!file) {
             alert("Please select a file before clicking 'Load'");
           }
           else {
             me.htmlCls.setHtmlCls.fileSupport();
             let reader = new FileReader();
             reader.onload = async function(e) {
               let dataStr = e.target.result; // or = reader.result;
               await ic.selectionCls.loadSelection(dataStr);
               thisClass.setLogCmd('load selection file ' + $("#" + me.pre + "selectionfile").val(), false);
             };
             reader.readAsText(file);
           }
        });

        me.myEventCls.onIds("#" + me.pre + "reload_collectionfile", "click", function (e) { let ic = me.icn3d;
            e.preventDefault();
            let file = $("#" + me.pre + "collectionfile")[0].files[0];
            if (!file) {
                alert("Please select a file before clicking 'Load'");
            } else {
            if (!me.cfg.notebook) dialog.dialog("close");
            if (!me.cfg.notebook) {
                $(".ui-dialog-content").dialog("close");
            } else {
                ic.resizeCanvasCls.closeDialogs();
                }
                
            ic.dAtoms = me.hashUtilsCls.cloneHash(ic.atoms);
            ic.hAtoms = me.hashUtilsCls.cloneHash(ic.atoms);
            me.htmlCls.setHtmlCls.fileSupport();

            let fileName = file.name;
            let fileExtension = fileName.split('.').pop().toLowerCase();
            let collection = {};
            
            $("#" + ic.pre + "collections_menu").empty();
            $("#" + ic.pre + "collections_menu").off("change");
                
            if (dl_collectionAppendStructureNone.checked || ic.allData === undefined) {
                ic.bInputfile = false;
                ic.pdbCollection = {};
                ic.allData = {};
                ic.allData['all'] = {
                    'atoms': {},
                    'proteins': {},
                    'nucleotides': {},
                    'chemicals': {},
                    'ions': {},
                    'water': {},
                    'structures': {}, // getSSExpandedAtoms
                    'ssbondpnts': {},
                    'residues': {}, // getSSExpandedAtoms
                    'chains': {},
                    'chainsSeq': {}, //Sequences and Annotation
                    'defNames2Atoms': {},
                    'defNames2Residues': {}
                };
                ic.allData['prev'] = {};
                ic.selectCollectionsCls.reset();

            } else {
                if (ic.collections) {
                    collection = ic.collections;
                }
            }

            function parseJsonCollection(data) {
                let dataStr = JSON.parse(data);
                let parsedCollection = {};

                dataStr["structures"].map(({ id, title, description, commands }) => {
                    if (id && id.includes('.pdb')) {
                        id = id.split('.pdb')[0];
                    }
                    parsedCollection[id] = [id, title, description, commands, false];
                });

                return parsedCollection;
            }
            
            function parsePdbCollection(data, description = '', commands = []) {         
                let dataStr = data;
                let lines = dataStr.split('\n');
                let sections = [];
                let currentSection = [];
                
                lines.forEach(line => {
                    if (line.startsWith('HEADER')) {
                    currentSection = [];
                    sections.push(currentSection);
                    }
                    currentSection.push(line);
                });
        
                
                let parsedCollection = {};
                
                sections.forEach((section) => {
                    let headerLine = section[0].replace(/[\n\r]/g, '').trim();
                    let header = headerLine.split(' ').filter(Boolean);
                    let id = header[header.length - 1];
                    let title = section[1].startsWith('TITLE') ? section[1].split('TITLE').pop().trim() : id;

                    parsedCollection[id] = [id, title, description, commands, true];

                    const sanitizedSection = section.map(line => line.trim());
                    ic.pdbCollection[id] = sanitizedSection;
                });

                return parsedCollection;
            }

            if (fileExtension === 'json' || fileExtension === 'pdb') {
                let reader = new FileReader();
                reader.onload = async function (e) {
                    if (fileExtension === 'json') {
                        let jsonCollection = parseJsonCollection(e.target.result);
                        collection = { ...collection, ...jsonCollection };
                    } else if (fileExtension === 'pdb') {
                        ic.bInputfile = true;
                        let pdbCollection = parsePdbCollection(e.target.result);
                        collection = { ...collection, ...pdbCollection };
                    }

                    let collectionHtml = await ic.selectCollectionsCls.setAtomMenu(collection);

                    ic.collections = collection;

                    $("#" + ic.pre + "collections_menu").html(collectionHtml);
                    await ic.selectCollectionsCls.clickStructure(collection);
                    $("#" + ic.pre + "collections_menu").trigger("change");     

                    me.htmlCls.clickMenuCls.setLogCmd(
                        "load collection file " +
                        $("#" + me.pre + "collectionfile").val(),
                        false
                    );
                };

                reader.readAsText(file);
            } else if (fileExtension === 'zip' || fileExtension === 'gz') {
                ic.bInputfile = true;
                let reader2 = new FileReader();
                reader2.onload = async function (e) {
                    if (fileExtension === 'zip') {
                        let url = './script/jszip.js';
                        await me.getAjaxPromise(url, 'script');

                        let jszip = new JSZip();
                        try {
                            let data = await jszip.loadAsync(e.target.result);

                            let hasJson = false;
                            let hasPdb = false;
                            let hasGz = false;
                            let jsonFiles = [];
                            let pdbFiles = [];
                            let gzFiles = [];

                            for (let fileName in data.files) {
                                let file = data.files[fileName];
                                if (!file.dir) {
                                    if (fileName.endsWith('.json')) {
                                        hasJson = true;
                                        jsonFiles.push(file);
                                    } else if (fileName.endsWith('.pdb')) {
                                        hasPdb = true;
                                        pdbFiles.push(file);
                                    } else if (fileName.endsWith('.gz')) {
                                        hasGz = true;
                                        gzFiles.push(file);
                                    }
                                }
                            }

                            if (hasJson && hasPdb) {
                                let jsonCollection = [];
                                for (const file of jsonFiles) {
                                    let fileData = await file.async('text');
                                    parseJsonCollection(fileData).forEach(element => {
                                        jsonCollection.push(element);
                                    });
                                }

                                // For each JSON object, check if a corresponding PDB file exists
                                for (const [id, title, description, commands, _] of jsonCollection) {
                                    let matchingPdbFile = pdbFiles.find(file => file.name.toLowerCase().includes(id.toLowerCase()));
                                    if (matchingPdbFile) {
                                        let pdbFileData = await matchingPdbFile.async('text');
                                        parsePdbCollection(pdbFileData, description, commands).forEach(element => {
                                            collection.push(element);
                                        });
                                    }
                                }

                            } else if (hasJson) {
                                // Do something if only JSON files are present
                                jsonFiles.forEach(async file => {
                                    let fileData = await file.async('text');
                                    parseJsonCollection(fileData).forEach(element => {
                                        collection.push(element);
                                    });
                                });
                            } else if (hasPdb) {
                                // Do something if only PDB files are present
                                pdbFiles.forEach(async file => {
                                    let fileData = await file.async('text');
                                    parsePdbCollection(fileData).forEach(element => {
                                        collection.push(element);
                                    });
                                });
                            } else if (hasGz) {
                                let url = './script/pako.js';
                                await me.getAjaxPromise(url, 'script');
                                try {
                                    for (const file of gzFiles) {
                                        let compressed = await file.async('uint8array');
                                        let decompressed = pako.inflate(compressed, { to: 'string' });
                                        parsePdbCollection(decompressed).forEach(element => {
                                            collection.push(element);
                                        });
                                    }
                                } catch (error) {
                                    console.error('Error loading GZ file', error);
                                }
                            }
                        } catch (error) {
                            console.error('Error loading ZIP file', error);
                        }
                    } else if (fileExtension === 'gz') {
                        let url = './script/pako.js';
                        await me.getAjaxPromise(url, 'script');
                        
                        try {
                            const compressed = new Uint8Array(e.target.result);
                            const decompressed = pako.inflate(compressed, { to: 'string' });
                            collection = parsePdbCollection(decompressed);
                        } catch (error) {
                            console.error('Error loading GZ file', error);
                        }
                    }

                    let collectionHtml = await ic.selectCollectionsCls.setAtomMenu(collection);

                    $("#" + ic.pre + "collections_menu").html(collectionHtml);
                    await ic.selectCollectionsCls.clickStructure(collection);

                    ic.collections = collection;

                    $("#" + ic.pre + "collections_menu").trigger("change");

                    me.htmlCls.clickMenuCls.setLogCmd(
                        "load collection file " +
                        $("#" + me.pre + "collectionfile").val(),
                        false
                    );
                };

                reader2.onerror = function(error) {
                    console.error('Error reading file', error);
                };

                reader2.readAsArrayBuffer(file);
            } else {
                throw new Error('Invalid file type');
            }
            
            if (ic.allData && Object.keys(ic.allData).length > 0) {
                $("#" + me.pre + "dl_collection_file").hide();
                $("#" + me.pre + "dl_collection_structures").show();
                $("#" + me.pre + "dl_collection_file_expand").show();
                $("#" + me.pre + "dl_collection_file_shrink").hide();
                $("#" + me.pre + "dl_collection_structures_expand").hide();
                $("#" + me.pre + "dl_collection_structures_shrink").show();

            } else {
                $("#" + me.pre + "dl_collection_file").show();
                $("#" + me.pre + "dl_collection_structures").hide();
                $("#" + me.pre + "dl_collection_file_expand").hide();
                $("#" + me.pre + "dl_collection_file_shrink").hide();
                $("#" + me.pre + "dl_collection_structures_expand").show();
                $("#" + me.pre + "dl_collection_structures_shrink").hide();
            }
              
            me.htmlCls.dialogCls.openDlg("dl_selectCollections", "Select Collections");
            }
        });

        me.myEventCls.onIds("#" + me.pre + "collections_clear_commands", "click", function (e) {
            var selectedValues = $("#" + ic.pre + "collections_menu").val();
            selectedValues.forEach(function (selectedValue) {
                if (ic.allData[selectedValue]) {
                    ic.allData[selectedValue]['commands'] = [];
                } else {
                    console.warn("No data found for selectedValue:", selectedValue);
                }
            });
        });

        me.myEventCls.onIds("#" + me.pre + "opendl_export_collections", "click", function (e) {
            me.htmlCls.dialogCls.openDlg("dl_export_collections", "Export Collections");
        });

        me.myEventCls.onIds("#" + me.pre + "export_collections", "click", function (e) {
            let ic = me.icn3d;

            const selectElement = document.getElementById(me.pre + 'collections_menu');
    
            // Array to store parsed results
            const structures = [];

            const dl_collectionExportSelected = document.getElementById('dl_collectionExportSelected');
            const dl_collectionExportAll = document.getElementById('dl_collectionExportAll');

            if (dl_collectionExportSelected.checked) {

                // Iterate over each <option> element
                Array.from(selectElement.options)
                    .filter(option => option.selected)
                    .forEach(option => {
                        const name = option.value;
                        const title = option.textContent.trim();
                        const description = option.getAttribute('data-description');

                        // Push the extracted data into the array
                        structures.push({
                            id: name,
                            title: title,
                            description: description || '',
                            commands: (ic.allData[name] && ic.allData[name].commands) ? ic.allData[name].commands : []
                        });
                    });
            } else if (dl_collectionExportAll.checked) {
                // Iterate over each <option> element
                Array.from(selectElement.options)
                    .forEach(option => {
                        const name = option.value;
                        const title = option.textContent.trim();
                        const description = option.getAttribute('data-description');

                        // Push the extracted data into the array
                        structures.push({
                            name: name,
                            title: title,
                            description: description || '',
                            commands: (ic.allData[name] && ic.allData[name].commands) ? ic.allData[name].commands : []
                        });
                    });
            }

            
            const now = new Date();
            const month = now.getMonth() + 1; // Months are zero-based
            const day = now.getDate();
            const year = now.getFullYear();
            const formattedDate = `${month}_${day}_${year}`;

            const collection = {
                collectionTitle: document.getElementById('dl_collectionTitle').value,
                collectionDescription: document.getElementById('dl_collectionDescription').value,
                structures: structures
            };

            const filename = `${collection.collectionTitle.replace(/\s+/g, '_')}_${formattedDate}.json`;

            const jsonString = JSON.stringify(collection, null, 2);
    
            // Create a Blob with the JSON data
            const blob = new Blob([jsonString], { type: 'application/json' });
            const url = URL.createObjectURL(blob);
            
            // Create a temporary link element to trigger download
            const a = document.createElement('a');
            a.href = url;
            a.download = filename;
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);
            
            // Revoke the object URL after download
            URL.revokeObjectURL(url);
        });

        me.myEventCls.onIds("#" + me.pre + "reload_dsn6file2fofc", "click", function(e) { let ic = me.icn3d;
           e.preventDefault();
           //if(!me.cfg.notebook) dialog.dialog( "close" );
           ic.dsn6ParserCls.loadDsn6File('2fofc');
        });
        me.myEventCls.onIds("#" + me.pre + "reload_dsn6filefofc", "click", function(e) { let ic = me.icn3d;
           e.preventDefault();
           //if(!me.cfg.notebook) dialog.dialog( "close" );
           ic.dsn6ParserCls.loadDsn6File('fofc');
        });

        me.myEventCls.onIds("#" + me.pre + "reload_ccp4file2fofc", "click", function(e) { let ic = me.icn3d;
            e.preventDefault();
            //if(!me.cfg.notebook) dialog.dialog( "close" );
            ic.ccp4ParserCls.loadCcp4File('2fofc');
        });
        me.myEventCls.onIds("#" + me.pre + "reload_ccp4filefofc", "click", function(e) { let ic = me.icn3d;
            e.preventDefault();
            //if(!me.cfg.notebook) dialog.dialog( "close" );
            ic.ccp4ParserCls.loadCcp4File('fofc');
        });

        me.myEventCls.onIds("#" + me.pre + "reload_mtzfile2fofc", "click", function(e) { let ic = me.icn3d;
            e.preventDefault();
            //if(!me.cfg.notebook) dialog.dialog( "close" );
            ic.mtzParserCls.loadMtzFile('2fofc');
        });
        me.myEventCls.onIds("#" + me.pre + "reload_mtzfilefofc", "click", function(e) { let ic = me.icn3d;
            e.preventDefault();
            //if(!me.cfg.notebook) dialog.dialog( "close" );
            ic.mtzParserCls.loadMtzFile('fofc');
        });

        me.myEventCls.onIds("#" + me.pre + "reload_rcsbmtzfile2fofc", "click", function(e) { let ic = me.icn3d;
            e.preventDefault();
            //if(!me.cfg.notebook) dialog.dialog( "close" );
            ic.mtzParserCls.loadMtzFile('2fofc', true);
        });
        me.myEventCls.onIds("#" + me.pre + "reload_rcsbmtzfilefofc", "click", function(e) { let ic = me.icn3d;
            e.preventDefault();
            //if(!me.cfg.notebook) dialog.dialog( "close" );
            ic.mtzParserCls.loadMtzFile('fofc', true);
        });

        me.myEventCls.onIds("#" + me.pre + "reload_delphifile", "click", async function(e) { let ic = me.icn3d;
           e.preventDefault();
           if(!me.cfg.notebook) dialog.dialog( "close" );
           await ic.delphiCls.loadDelphiFile('delphi');
        });
        me.myEventCls.onIds("#" + me.pre + "reload_pqrfile", "click", function(e) { let ic = me.icn3d;
           e.preventDefault();
           if(!me.cfg.notebook) dialog.dialog( "close" );
           ic.delphiCls.loadPhiFile('pqr');
        });
        me.myEventCls.onIds("#" + me.pre + "reload_phifile", "click", function(e) { let ic = me.icn3d;
           e.preventDefault();
           if(!me.cfg.notebook) dialog.dialog( "close" );
           ic.delphiCls.loadPhiFile('phi');
        });
        me.myEventCls.onIds("#" + me.pre + "reload_cubefile", "click", function(e) { let ic = me.icn3d;
           e.preventDefault();
           if(!me.cfg.notebook) dialog.dialog( "close" );
           ic.delphiCls.loadPhiFile('cube');
        });
        me.myEventCls.onIds("#" + me.pre + "reload_pqrurlfile", "click", async function(e) { let ic = me.icn3d;
           e.preventDefault();
           if(!me.cfg.notebook) dialog.dialog( "close" );
           await ic.delphiCls.loadPhiFileUrl('pqrurl');
        });
        me.myEventCls.onIds("#" + me.pre + "reload_phiurlfile", "click", async function(e) { let ic = me.icn3d;
           e.preventDefault();
           if(!me.cfg.notebook) dialog.dialog( "close" );
           await ic.delphiCls.loadPhiFileUrl('phiurl');
        });
        me.myEventCls.onIds("#" + me.pre + "reload_cubeurlfile", "click", async function(e) { let ic = me.icn3d;
           e.preventDefault();
           if(!me.cfg.notebook) dialog.dialog( "close" );
           await ic.delphiCls.loadPhiFileUrl('cubeurl');
        });

        me.myEventCls.onIds("#" + me.pre + "reload_delphifile2", "click", async function(e) { let ic = me.icn3d;
           e.preventDefault();
           me.htmlCls.setHtmlCls.updateSurfPara('delphi');

           if(!me.cfg.notebook) dialog.dialog( "close" );

           await ic.delphiCls.loadDelphiFile('delphi2');
        });
        me.myEventCls.onIds("#" + me.pre + "reload_pqrfile2", "click", function(e) { let ic = me.icn3d;
           e.preventDefault();
           me.htmlCls.setHtmlCls.updateSurfPara('phi');

           if(!me.cfg.notebook) dialog.dialog( "close" );
           ic.delphiCls.loadPhiFile('pqr2');
        });
        me.myEventCls.onIds("#" + me.pre + "reload_phifile2", "click", function(e) { let ic = me.icn3d;
           e.preventDefault();
           me.htmlCls.setHtmlCls.updateSurfPara('phi');

           if(!me.cfg.notebook) dialog.dialog( "close" );
           ic.delphiCls.loadPhiFile('phi2');
        });
        me.myEventCls.onIds("#" + me.pre + "reload_cubefile2", "click", function(e) { let ic = me.icn3d;
           e.preventDefault();
           me.htmlCls.setHtmlCls.updateSurfPara('phi');

           if(!me.cfg.notebook) dialog.dialog( "close" );
           ic.delphiCls.loadPhiFile('cube2');
        });
        me.myEventCls.onIds("#" + me.pre + "reload_pqrurlfile2", "click", async function(e) { let ic = me.icn3d;
           e.preventDefault();
           me.htmlCls.setHtmlCls.updateSurfPara('phiurl');

           if(!me.cfg.notebook) dialog.dialog( "close" );
           await ic.delphiCls.loadPhiFileUrl('pqrurl2');
        });
        me.myEventCls.onIds("#" + me.pre + "reload_phiurlfile2", "click", async function(e) { let ic = me.icn3d;
           e.preventDefault();
           me.htmlCls.setHtmlCls.updateSurfPara('phiurl');

           if(!me.cfg.notebook) dialog.dialog( "close" );
           await ic.delphiCls.loadPhiFileUrl('phiurl2');
        });
        me.myEventCls.onIds("#" + me.pre + "reload_cubeurlfile2", "click", async function(e) { let ic = me.icn3d;
           e.preventDefault();
           me.htmlCls.setHtmlCls.updateSurfPara('phiurl');

           if(!me.cfg.notebook) dialog.dialog( "close" );
           await ic.delphiCls.loadPhiFileUrl('cubeurl2');
        });

        me.myEventCls.onIds("#" + me.pre + "reload_dsn6fileurl2fofc", "click", function(e) { let ic = me.icn3d;
           e.preventDefault();
           //if(!me.cfg.notebook) dialog.dialog( "close" );
           ic.dsn6ParserCls.loadDsn6FileUrl('2fofc');
        });
        me.myEventCls.onIds("#" + me.pre + "reload_dsn6fileurlfofc", "click", function(e) { let ic = me.icn3d;
           e.preventDefault();
           //if(!me.cfg.notebook) dialog.dialog( "close" );
           ic.dsn6ParserCls.loadDsn6FileUrl('fofc');
        });

        me.myEventCls.onIds("#" + me.pre + "reload_ccp4fileurl2fofc", "click", function(e) { let ic = me.icn3d;
            e.preventDefault();
            //if(!me.cfg.notebook) dialog.dialog( "close" );
            ic.ccp4ParserCls.loadCcp4FileUrl('2fofc');
        });
        me.myEventCls.onIds("#" + me.pre + "reload_ccp4fileurlfofc", "click", function(e) { let ic = me.icn3d;
            e.preventDefault();
            //if(!me.cfg.notebook) dialog.dialog( "close" );
            ic.ccp4ParserCls.loadCcp4FileUrl('fofc');
        });

        me.myEventCls.onIds("#" + me.pre + "reload_mtzfileurl2fofc", "click", function(e) { let ic = me.icn3d;
            e.preventDefault();
            //if(!me.cfg.notebook) dialog.dialog( "close" );
            ic.mtzParserCls.loadMtzFileUrl('2fofc');
        });
        me.myEventCls.onIds("#" + me.pre + "reload_mtzfileurlfofc", "click", function(e) { let ic = me.icn3d;
            e.preventDefault();
            //if(!me.cfg.notebook) dialog.dialog( "close" );
            ic.mtzParserCls.loadMtzFileUrl('fofc');
        });

        me.myEventCls.onIds("#" + me.pre + "reload_rcsbmtzfileurl2fofc", "click", async function(e) { let ic = me.icn3d;
            e.preventDefault();
            //if(!me.cfg.notebook) dialog.dialog( "close" );
            await ic.mtzParserCls.loadMtzFileUrl('2fofc', true);
        });
        me.myEventCls.onIds("#" + me.pre + "reload_rcsbmtzfileurlfofc", "click", async function(e) { let ic = me.icn3d;
            e.preventDefault();
            //if(!me.cfg.notebook) dialog.dialog( "close" );
            await ic.mtzParserCls.loadMtzFileUrl('fofc', true);
        });

        me.myEventCls.onIds("#" + me.pre + "reload_pdbfile", "click", async function(e) { me.icn3d;
           e.preventDefault();

           let bAppend = false;
           await thisClass.loadPdbFile(bAppend, 'pdbfile');
        });

        me.myEventCls.onIds("#" + me.pre + "reload_pdbfile_app", "click", async function(e) { let ic = me.icn3d;
           e.preventDefault();

           ic.bAppend = true;
           await thisClass.loadPdbFile(ic.bAppend, 'pdbfile_app');
        });

        me.myEventCls.onIds("#" + me.pre + "reload_mol2file", "click", function(e) { let ic = me.icn3d;
           e.preventDefault();
           ic.bInitial = true;
           if(!me.cfg.notebook) dialog.dialog( "close" );
           //close all dialog
           if(!me.cfg.notebook) {
               $(".ui-dialog-content").dialog("close");
           }
           else {
               ic.resizeCanvasCls.closeDialogs();
           }
           let file = $("#" + me.pre + "mol2file")[0].files[0];
           if(!file) {
             alert("Please select a file before clicking 'Load'");
           }
           else {
             me.htmlCls.setHtmlCls.fileSupport();
             let reader = new FileReader();
             reader.onload = async function(e) {
               let dataStr = e.target.result; // or = reader.result;
               thisClass.setLogCmd('load mol2 file ' + $("#" + me.pre + "mol2file").val(), false);
               ic.molTitle = "";
               ic.inputid = undefined;
               //ic.initUI();
               ic.init();
               ic.bInputfile = true;
               ic.InputfileData = (ic.InputfileData) ? ic.InputfileData + '\nENDMDL\n' + dataStr : dataStr;
               ic.InputfileType = 'mol2';
               await ic.mol2ParserCls.loadMol2Data(dataStr);
             };
             reader.readAsText(file);
           }
        });

        me.myEventCls.onIds("#" + me.pre + "reload_sdffile", "click", function(e) { let ic = me.icn3d;
           e.preventDefault();
           ic.bInitial = true;
           if(!me.cfg.notebook) dialog.dialog( "close" );
           //close all dialog
           if(!me.cfg.notebook) {
               $(".ui-dialog-content").dialog("close");
           }
           else {
               ic.resizeCanvasCls.closeDialogs();
           }
           let file = $("#" + me.pre + "sdffile")[0].files[0];
           if(!file) {
             alert("Please select a file before clicking 'Load'");
           }
           else {
             me.htmlCls.setHtmlCls.fileSupport();
             let reader = new FileReader();
             reader.onload = async function(e) {
               let dataStr = e.target.result; // or = reader.result;
               thisClass.setLogCmd('load sdf file ' + $("#" + me.pre + "sdffile").val(), false);
               ic.molTitle = "";
               ic.inputid = undefined;
               //ic.initUI();
               ic.init();
               ic.bInputfile = true;
               ic.InputfileData = (ic.InputfileData) ? ic.InputfileData + '\nENDMDL\n' + dataStr : dataStr;
               ic.InputfileType = 'sdf';
               await ic.sdfParserCls.loadSdfData(dataStr);
             };
             reader.readAsText(file);
           }
        });

        me.myEventCls.onIds("#" + me.pre + "reload_xyzfile", "click", function(e) { let ic = me.icn3d;
           e.preventDefault();
           ic.bInitial = true;
           if(!me.cfg.notebook) dialog.dialog( "close" );
           //close all dialog
           if(!me.cfg.notebook) {
               $(".ui-dialog-content").dialog("close");
           }
           else {
               ic.resizeCanvasCls.closeDialogs();
           }
           let file = $("#" + me.pre + "xyzfile")[0].files[0];
           if(!file) {
             alert("Please select a file before clicking 'Load'");
           }
           else {
             me.htmlCls.setHtmlCls.fileSupport();
             let reader = new FileReader();
             reader.onload = async function(e) {
               let dataStr = e.target.result; // or = reader.result;
               thisClass.setLogCmd('load xyz file ' + $("#" + me.pre + "xyzfile").val(), false);
               ic.molTitle = "";
               ic.inputid = undefined;
               //ic.initUI();
               ic.init();
               ic.bInputfile = true;
               ic.InputfileData = (ic.InputfileData) ? ic.InputfileData + '\nENDMDL\n' + dataStr : dataStr;
               ic.InputfileType = 'xyz';
               await ic.xyzParserCls.loadXyzData(dataStr);
             };
             reader.readAsText(file);
           }
        });

        me.myEventCls.onIds("#" + me.pre + "reload_afmapfile", "click", function(e) { let ic = me.icn3d;
            e.preventDefault();
            ic.bInitial = true;
            if(!me.cfg.notebook) dialog.dialog( "close" );
            //close all dialog
            if(!me.cfg.notebook) {
                $(".ui-dialog-content").dialog("close");
            }
            else {
                ic.resizeCanvasCls.closeDialogs();
            }
            let file = $("#" + me.pre + "afmapfile")[0].files[0];
            if(!file) {
              alert("Please select a file before clicking 'Load'");
            }
            else {
              me.htmlCls.setHtmlCls.fileSupport();
              let reader = new FileReader();
              reader.onload = function(e) {
                let dataStr = e.target.result; // or = reader.result;
                thisClass.setLogCmd('load AlphaFold PAE file ' + $("#" + me.pre + "afmapfile").val(), false);
                
                me.htmlCls.dialogCls.openDlg('dl_alignerrormap', 'Show Predicted Aligned Error (PAE) map');
                ic.contactMapCls.processAfErrorMap(JSON.parse(dataStr));
              };
              reader.readAsText(file);
            }
         });

         me.myEventCls.onIds("#" + me.pre + "reload_afmapfilefull", "click", function(e) { let ic = me.icn3d;
            e.preventDefault();
            ic.bInitial = true;
            if(!me.cfg.notebook) dialog.dialog( "close" );
            //close all dialog
            if(!me.cfg.notebook) {
                $(".ui-dialog-content").dialog("close");
            }
            else {
                ic.resizeCanvasCls.closeDialogs();
            }
            let file = $("#" + me.pre + "afmapfile")[0].files[0];
            if(!file) {
              alert("Please select a file before clicking 'Load'");
            }
            else {
              me.htmlCls.setHtmlCls.fileSupport();
              let reader = new FileReader();
              reader.onload = function(e) {
                let dataStr = e.target.result; // or = reader.result;
                thisClass.setLogCmd('load AlphaFold PAE file ' + $("#" + me.pre + "afmapfile").val(), false);
                
                me.htmlCls.dialogCls.openDlg('dl_alignerrormap', 'Show Predicted Aligned Error (PAE) map');
                ic.contactMapCls.processAfErrorMap(JSON.parse(dataStr), true);
              };
              reader.readAsText(file);
            }
         });

        me.myEventCls.onIds("#" + me.pre + "reload_urlfile", "click", async function(e) { let ic = me.icn3d;
           e.preventDefault();
           ic.bInitial = true;
           if(!me.cfg.notebook) dialog.dialog( "close" );
           //close all dialog
           if(!me.cfg.notebook) {
               $(".ui-dialog-content").dialog("close");
           }
           else {
               ic.resizeCanvasCls.closeDialogs();
           }
           let type = $("#" + me.pre + "filetype").val();
           let url = $("#" + me.pre + "urlfile").val();
           ic.inputurl = 'type=' + type + '&url=' + encodeURIComponent(url);
           //ic.initUI();
           ic.init();
           ic.bInputfile = true;
           ic.bInputUrlfile = true;
           await ic.pdbParserCls.downloadUrl(url, type);
        });

        me.myEventCls.onIds("#" + me.pre + "reload_mmciffile", "click", async function(e) { let ic = me.icn3d;
           e.preventDefault();

           ic.bAppend = true;
           let bmmCIF = true;
           let fileId = 'mmciffile';
           await thisClass.loadPdbFile(ic.bAppend, fileId, bmmCIF);
        });

        me.myEventCls.onIds("#" + me.pre + "applycustomcolor", "click", function(e) { let ic = me.icn3d;
           e.preventDefault();
           if(!me.cfg.notebook) dialog.dialog( "close" );
           ic.setOptionCls.setOption("color", $("#" + me.pre + "colorcustom").val());
           thisClass.setLogCmd("color " + $("#" + me.pre + "colorcustom").val(), true);
        });

        me.myEventCls.onIds(["#" + me.pre + "atomsCustomSphere2", "#" + me.pre + "atomsCustomSphere", "#" + me.pre + "radius_aroundsphere"], "change", function(e) { let ic = me.icn3d;
            ic.bSphereCalc = false;
            //thisClass.setLogCmd('set calculate sphere false', true);
        });
        me.myEventCls.onIds("#" + me.pre + "applypick_aroundsphere", "click", function(e) { let ic = me.icn3d;
            //e.preventDefault();
            
            let radius = parseFloat($("#" + me.pre + "radius_aroundsphere").val());
            let nameArray = $("#" + me.pre + "atomsCustomSphere").val();
            let nameArray2 = $("#" + me.pre + "atomsCustomSphere2").val();
            if(nameArray2.length == 0) {
                alert("Please select the first set at step #1");
            }
            else {
                let select = "select zone cutoff " + radius + " | sets " + nameArray2 + " " + nameArray + " | " + ic.bSphereCalc;
                if(!ic.bSphereCalc) ic.showInterCls.pickCustomSphere(radius, nameArray2, nameArray, ic.bSphereCalc);
                ic.bSphereCalc = true;
                //thisClass.setLogCmd('set calculate sphere true', true);
                ic.hlUpdateCls.updateHlAll();
                thisClass.setLogCmd(select, true);
            }
        });
        me.myEventCls.onIds("#" + me.pre + "sphereExport", "click", function(e) { let ic = me.icn3d;
            e.preventDefault();
            
            let radius = parseFloat($("#" + me.pre + "radius_aroundsphere").val());
            let nameArray = $("#" + me.pre + "atomsCustomSphere").val();
            let nameArray2 = $("#" + me.pre + "atomsCustomSphere2").val();
            if(nameArray2.length == 0) {
                alert("Please select the first set at step #1");
            }
            else {
                ic.showInterCls.pickCustomSphere(radius, nameArray2, nameArray, ic.bSphereCalc);
                ic.bSphereCalc = true;
                let text = ic.viewInterPairsCls.exportSpherePairs();
                let file_pref = Object.keys(me.utilsCls.getHlStructures()).join(',');
                ic.saveFileCls.saveFile(file_pref + '_sphere_pairs.html', 'html', text);

                thisClass.setLogCmd("export pairs | " + nameArray2 + " " + nameArray + " | dist " + radius, true);
            }
        });

        me.myEventCls.onIds("#" + me.pre + "apply_adjustmem", "click", function(e) { let ic = me.icn3d;
            //e.preventDefault();
            if(!me.cfg.notebook) dialog.dialog( "close" );
            let extra_mem_z = parseFloat($("#" + me.pre + "extra_mem_z").val());
            let intra_mem_z = parseFloat($("#" + me.pre + "intra_mem_z").val());
            ic.selectionCls.adjustMembrane(extra_mem_z, intra_mem_z);
            let select = "adjust membrane z-axis " + extra_mem_z + " " + intra_mem_z;
            thisClass.setLogCmd(select, true);
        });

        me.myEventCls.onIds("#" + me.pre + "apply_selectplane", "click", function(e) { let ic = me.icn3d;
            //e.preventDefault();
            if(!me.cfg.notebook) dialog.dialog( "close" );
            let large = parseFloat($("#" + me.pre + "selectplane_z1").val());
            let small = parseFloat($("#" + me.pre + "selectplane_z2").val());
            ic.selectionCls.selectBtwPlanes(large, small);
            let select = "select planes z-axis " + large + " " + small;
            thisClass.setLogCmd(select, true);
        });

        me.myEventCls.onIds(["#" + me.pre + "atomsCustomHbond2", "#" + me.pre + "atomsCustomHbond", "#" + me.pre + "analysis_hbond", "#" + me.pre + "analysis_saltbridge", "#" + me.pre + "analysis_contact", "#" + me.pre + "hbondthreshold", "#" + me.pre + "saltbridgethreshold", "#" + me.pre + "contactthreshold"], "change", function(e) { let ic = me.icn3d;
            ic.bHbondCalc = false;
            //thisClass.setLogCmd('set calculate hbond false', true);
        });
        me.myEventCls.onIds("#" + me.pre + "crossstrucinter", "change", function(e) { let ic = me.icn3d;
           e.preventDefault();
           
           ic.crossstrucinter = parseInt($("#" + me.pre + "crossstrucinter").val());
           thisClass.setLogCmd("cross structure interaction " + ic.crossstrucinter, true);
        });
        me.myEventCls.onIds("#" + me.pre + "applyhbonds", "click", async function(e) { let ic = me.icn3d;
           e.preventDefault();
           
           await ic.showInterCls.showInteractions('3d');
        });
        me.myEventCls.onIds("#" + me.pre + "applycontactmap", "click", async function(e) { let ic = me.icn3d;
           e.preventDefault();
           if(!me.cfg.notebook) dialog.dialog( "close" );

           let contactdist = parseFloat($("#" + ic.pre + "contactdist").val());
           let contacttype = $("#" + ic.pre + "contacttype").val();

           await ic.contactMapCls.contactMap(contactdist, contacttype);
           thisClass.setLogCmd('contact map | dist ' + contactdist + ' | type ' + contacttype, true);
        });
        me.myEventCls.onIds("#" + me.pre + "hbondWindow", "click", async function(e) { let ic = me.icn3d;
           e.preventDefault();
           
           await ic.showInterCls.showInteractions('view');
        });
        me.myEventCls.onIds("#" + me.pre + "areaWindow", "click", function(e) { let ic = me.icn3d;
           e.preventDefault();
           
           let nameArray = $("#" + me.pre + "atomsCustomHbond").val();
           let nameArray2 = $("#" + me.pre + "atomsCustomHbond2").val();
           ic.analysisCls.calcBuriedSurface(nameArray2, nameArray);
           thisClass.setLogCmd("calc buried surface | " + nameArray2 + " " + nameArray, true);
        });
        me.myEventCls.onIds("#" + me.pre + "sortSet1", "click", async function(e) { let ic = me.icn3d;
           e.preventDefault();
           
           await ic.showInterCls.showInteractions('save1');
        });
        $(document).on("click", "." + me.pre + "showintercntonly", function(e) { me.icn3d;
            e.stopImmediatePropagation();
            $(".icn3d-border").hide();
            thisClass.setLogCmd("table inter count only", true);
        });
        $(document).on("click", "." + me.pre + "showinterdetails", function(e) { me.icn3d;
            e.stopImmediatePropagation();
            $(".icn3d-border").show();
            thisClass.setLogCmd("table inter details", true);
        });
        me.myEventCls.onIds("#" + me.pre + "sortSet2", "click", async function(e) { let ic = me.icn3d;
           e.preventDefault();
           
           await ic.showInterCls.showInteractions('save2');
        });
        me.myEventCls.onIds("#" + me.pre + "hbondGraph", "click", async function(e) { let ic = me.icn3d;
           e.preventDefault();
           
           await ic.showInterCls.showInteractions('graph');
        });
        me.myEventCls.onIds("#" + me.pre + "hbondLineGraph", "click", async function(e) { let ic = me.icn3d;
           e.preventDefault();
           
           ic.bShownRefnum = false;
           thisClass.setLogCmd("hide ref number", true);
           await ic.showInterCls.showInteractions('linegraph');
        });
        me.myEventCls.onIds("#" + me.pre + "hbondLineGraph2", "click", async function(e) { let ic = me.icn3d;
            e.preventDefault();
            
            ic.bShownRefnum = true;
            thisClass.setLogCmd("show ref number", true);
            await ic.showInterCls.showInteractions('linegraph');
        });
        me.myEventCls.onIds("#" + me.pre + "hbondScatterplot", "click", async function(e) { let ic = me.icn3d;
            e.preventDefault();
            
            ic.bShownRefnum = false;
            thisClass.setLogCmd("hide ref number", true);
            await ic.showInterCls.showInteractions('scatterplot');
        });
        me.myEventCls.onIds("#" + me.pre + "hbondScatterplot2", "click", async function(e) { let ic = me.icn3d;
           e.preventDefault();
           
           ic.bShownRefnum = true;
           thisClass.setLogCmd("show ref number", true);
           await ic.showInterCls.showInteractions('scatterplot');
        });
        me.myEventCls.onIds("#" + me.pre + "hbondLigplot", "click", async function(e) { let ic = me.icn3d;
            e.preventDefault();
            
            ic.bShownRefnum = false;
            thisClass.setLogCmd("hide ref number", true);
            await ic.showInterCls.showInteractions('ligplot');
        });
        // select residues
        $(document).on("click", "#" + me.svgid + " circle.selected", function(e) { let ic = me.icn3d;
            e.stopImmediatePropagation();
            let id = $(this).attr('res');
            if(ic.bSelectResidue === false && !ic.bShift && !ic.bCtrl) {
              ic.selectionCls.removeSelection();
            }
            if(id !== undefined) {
               ic.hlSeqCls.selectResidues(id, this);
               ic.hlObjectsCls.addHlObjects();  // render() is called
            }
        });
        me.myEventCls.onIds("#" + me.svgid + "_svg", "click", function(e) { let ic = me.icn3d;
           e.preventDefault();
           
           ic.saveFileCls.saveSvg(me.svgid, ic.inputid + "_force_directed_graph.svg");
        });
        me.myEventCls.onIds("#" + me.svgid + "_png", "click", function(e) { let ic = me.icn3d;
           e.preventDefault();
           
           ic.saveFileCls.savePng(me.svgid, ic.inputid + "_force_directed_graph.png");
        });
        me.myEventCls.onIds("#" + me.svgid + "_json", "click", function(e) { let ic = me.icn3d;
            e.preventDefault();
            
            let graphStr2 = ic.graphStr.substr(0, ic.graphStr.lastIndexOf('}'));
            graphStr2 += me.htmlCls.setHtmlCls.getLinkColor();

            ic.saveFileCls.saveFile(ic.inputid + "_force_directed_graph.json", "text", [graphStr2]);
        });

        $(document).on("click", "#" + me.svgid_ct + "_svg", function(e) { let ic = me.icn3d;
           e.preventDefault();
           
           ic.saveFileCls.saveSvg(me.svgid_ct, ic.inputid + "_cartoon.svg");
        });
        $(document).on("click", "#" + me.svgid_ct + "_png", function(e) { let ic = me.icn3d;
           e.preventDefault();
           
           ic.saveFileCls.savePng(me.svgid_ct, ic.inputid + "_cartoon.png");
        });
        $(document).on("click", "#" + me.svgid_ct + "_json", function(e) { let ic = me.icn3d;
            e.preventDefault();
            
            //let graphStr2 = ic.graphStr.substr(0, ic.graphStr.lastIndexOf('}'));

            ic.saveFileCls.saveFile(ic.inputid + "_cartoon.json", "text", [ic.graphStr]);
        });
        $(document).on("change", "#" + me.svgid_ct + "_label", function(e) { me.icn3d;
           e.preventDefault();
           
           let className = $("#" + me.svgid_ct + "_label").val();
           $("#" + me.svgid_ct + " text").removeClass();
           $("#" + me.svgid_ct + " text").addClass(className);
           thisClass.setLogCmd("cartoon label " + className, true);
        });

        me.myEventCls.onIds("#" + me.linegraphid + "_svg", "click", function(e) { let ic = me.icn3d;
           e.preventDefault();
           
           ic.saveFileCls.saveSvg(me.linegraphid, ic.inputid + "_line_graph.svg");
        });
        me.myEventCls.onIds("#" + me.linegraphid + "_png", "click", function(e) { let ic = me.icn3d;
           e.preventDefault();
           
           ic.saveFileCls.savePng(me.linegraphid, ic.inputid + "_line_graph.png");
        });
        me.myEventCls.onIds("#" + me.linegraphid + "_json", "click", function(e) { let ic = me.icn3d;
            e.preventDefault();
            
            let graphStr2 = ic.lineGraphStr.substr(0, ic.lineGraphStr.lastIndexOf('}'));

            graphStr2 += me.htmlCls.setHtmlCls.getLinkColor();

            ic.saveFileCls.saveFile(ic.inputid + "_line_graph.json", "text", [graphStr2]);
        });
        me.myEventCls.onIds("#" + me.linegraphid + "_scale", "change", function(e) { let ic = me.icn3d;
           e.preventDefault();
           
           let scale = $("#" + me.linegraphid + "_scale").val();
           $("#" + me.linegraphid).attr("width",(ic.linegraphWidth * parseFloat(scale)).toString() + "px");
           thisClass.setLogCmd("line graph scale " + scale, true);
        });
        me.myEventCls.onIds("#" + me.scatterplotid + "_svg", "click", function(e) { let ic = me.icn3d;
           e.preventDefault();
           
           ic.saveFileCls.saveSvg(me.scatterplotid, ic.inputid + "_scatterplot.svg");
        });
        me.myEventCls.onIds("#" + me.scatterplotid + "_png", "click", function(e) { let ic = me.icn3d;
           e.preventDefault();
           
           ic.saveFileCls.savePng(me.scatterplotid, ic.inputid + "_scatterplot.png");
        });
        me.myEventCls.onIds("#" + me.scatterplotid + "_json", "click", function(e) { let ic = me.icn3d;
            e.preventDefault();
            
            let graphStr2 = ic.scatterplotStr.substr(0, ic.scatterplotStr.lastIndexOf('}'));

            graphStr2 += me.htmlCls.setHtmlCls.getLinkColor();

            ic.saveFileCls.saveFile(ic.inputid + "_scatterplot.json", "text", [graphStr2]);
        });
        me.myEventCls.onIds("#" + me.scatterplotid + "_scale", "change", function(e) { let ic = me.icn3d;
           e.preventDefault();
           
           let scale = $("#" + me.scatterplotid + "_scale").val();
           $("#" + me.scatterplotid).attr("width",(ic.scatterplotWidth * parseFloat(scale)).toString() + "px");
           thisClass.setLogCmd("scatterplot scale " + scale, true);
        });

        me.myEventCls.onIds("#" + me.ligplotid + "_svg", "click", function(e) { let ic = me.icn3d;
            e.preventDefault();
            
            ic.saveFileCls.saveSvg(me.ligplotid, ic.inputid + "_ligplot.svg", undefined, true);
         });
         me.myEventCls.onIds("#" + me.ligplotid + "_png", "click", function(e) { let ic = me.icn3d;
            e.preventDefault();
            
            ic.saveFileCls.savePng(me.ligplotid, ic.inputid + "_ligplot.png", undefined, true);
         });
        //  me.myEventCls.onIds("#" + me.ligplotid + "_json", "click", function(e) { let ic = me.icn3d;
        //      e.preventDefault();
             
        //      let graphStr2 = ic.ligplotStr.substr(0, ic.ligplotStr.lastIndexOf('}'));
 
        //      graphStr2 += me.htmlCls.setHtmlCls.getLinkColor();
 
        //      ic.saveFileCls.saveFile(ic.inputid + "_ligplot.json", "text", [graphStr2]);
        //  });
         me.myEventCls.onIds("#" + me.ligplotid + "_scale", "change", function(e) { let ic = me.icn3d;
            e.preventDefault();
            
            let scale = $("#" + me.ligplotid + "_scale").val();
            $("#" + me.ligplotid).attr("width",(ic.ligplotWidth * parseFloat(scale)).toString() + "px");
            ic.ligplotScale = parseFloat(scale);
            thisClass.setLogCmd("ligplot scale " + scale, true);
         });

        me.myEventCls.onIds("#" + me.contactmapid + "_svg", "click", function(e) { let ic = me.icn3d;
           e.preventDefault();
           
           ic.saveFileCls.saveSvg(me.contactmapid, ic.inputid + "_contactmap.svg", true);
        });
        me.myEventCls.onIds("#" + me.contactmapid + "_png", "click", function(e) { let ic = me.icn3d;
           e.preventDefault();
           
           ic.saveFileCls.savePng(me.contactmapid, ic.inputid + "_contactmap.png", true);
        });
        me.myEventCls.onIds("#" + me.contactmapid + "_json", "click", function(e) { let ic = me.icn3d;
            e.preventDefault();
            
            let graphStr2 = ic.contactmapStr.substr(0, ic.contactmapStr.lastIndexOf('}'));

            graphStr2 += me.htmlCls.setHtmlCls.getLinkColor();

            ic.saveFileCls.saveFile(ic.inputid + "_contactmap.json", "text", [graphStr2]);
        });
        me.myEventCls.onIds("#" + me.contactmapid + "_scale", "change", function(e) { let ic = me.icn3d;
            e.preventDefault();
            
            let scale = $("#" + me.contactmapid + "_scale").val();
            $("#" + me.contactmapid).attr("width",(ic.contactmapWidth * parseFloat(scale)).toString() + "px");
            thisClass.setLogCmd("contactmap scale " + scale, true);
         });

        me.myEventCls.onIds("#" + me.alignerrormapid + "_svg", "click", function(e) { let ic = me.icn3d;
            e.preventDefault();
            
            let scale = 1;
            $("#" + me.alignerrormapid + "_scale").val(scale);
            $("#" + me.alignerrormapid).attr("width",(ic.alignerrormapWidth * parseFloat(scale)).toString() + "px");
            
            ic.saveFileCls.saveSvg(me.alignerrormapid, ic.inputid + "_alignerrormap.svg", true);
         });
         me.myEventCls.onIds("#" + me.alignerrormapid + "_png", "click", function(e) { let ic = me.icn3d;
            e.preventDefault();
            
            let scale = 1;
            $("#" + me.alignerrormapid + "_scale").val(scale);
            $("#" + me.alignerrormapid).attr("width",(ic.alignerrormapWidth * parseFloat(scale)).toString() + "px");
            
            ic.saveFileCls.savePng(me.alignerrormapid, ic.inputid + "_alignerrormap.png", true);
         });
         me.myEventCls.onIds("#" + me.alignerrormapid + "_full", "click", async function(e) { let ic = me.icn3d;
            e.preventDefault();
            
            await ic.contactMapCls.afErrorMap(afid, true);
         });
         me.myEventCls.onIds("#" + me.alignerrormapid + "_json", "click", function(e) { let ic = me.icn3d;
             e.preventDefault();
             
             
             let graphStr2 = ic.alignerrormapStr.substr(0, ic.alignerrormapStr.lastIndexOf('}'));
 
             graphStr2 += me.htmlCls.setHtmlCls.getLinkColor();
 
             ic.saveFileCls.saveFile(ic.inputid + "_alignerrormap.json", "text", [graphStr2]);
         });

        me.myEventCls.onIds("#" + me.alignerrormapid + "_scale", "change", function(e) { let ic = me.icn3d;
           e.preventDefault();
           
           let scale = $("#" + me.alignerrormapid + "_scale").val();
           $("#" + me.alignerrormapid).attr("width",(ic.alignerrormapWidth * parseFloat(scale)).toString() + "px");
           thisClass.setLogCmd("alignerrormap scale " + scale, true);
        });

        me.myEventCls.onIds("#" + me.svgid + "_label", "change", function(e) { me.icn3d;
           e.preventDefault();
           
           let className = $("#" + me.svgid + "_label").val();
           $("#" + me.svgid + " text").removeClass();
           $("#" + me.svgid + " text").addClass(className);
           thisClass.setLogCmd("graph label " + className, true);
        });
        me.myEventCls.onIds("#" + me.svgid + "_hideedges", "change", function(e) { let ic = me.icn3d;
           e.preventDefault();
           
           me.htmlCls.hideedges = parseInt($("#" + me.svgid + "_hideedges").val());
           if(me.htmlCls.hideedges) {
                me.htmlCls.contactInsideColor = 'FFF';
                me.htmlCls.hbondInsideColor = 'FFF';
                me.htmlCls.ionicInsideColor = 'FFF';
           }
           else {
                me.htmlCls.contactInsideColor = 'DDD';
                me.htmlCls.hbondInsideColor = 'AFA';
                me.htmlCls.ionicInsideColor = '8FF';
           }
           if(ic.graphStr !== undefined) {
               if(ic.bRender && me.htmlCls.force) me.drawGraph(ic.graphStr, me.pre + 'dl_graph');
               thisClass.setLogCmd("hide edges " + me.htmlCls.hideedges, true);
           }
        });
        me.myEventCls.onIds("#" + me.svgid + "_force", "change", function(e) { let ic = me.icn3d;
           e.preventDefault();
           
           me.htmlCls.force = parseInt($("#" + me.svgid + "_force").val());
           if(ic.graphStr !== undefined) {
               thisClass.setLogCmd("graph force " + me.htmlCls.force, true);
               ic.getGraphCls.handleForce();
           }
        });
        me.myEventCls.onIds("#" + me.pre + "hbondReset", "click", function(e) { let ic = me.icn3d;
           e.preventDefault();
           
           ic.viewInterPairsCls.resetInteractionPairs();
           thisClass.setLogCmd("reset interaction pairs", true);
        });

        me.myEventCls.onIds("#" + me.pre + "applypick_labels", "click", function(e) { let ic = me.icn3d;
           e.preventDefault();
           if(!me.cfg.notebook) dialog.dialog( "close" );
           let text = $("#" + me.pre + "labeltext" ).val();
           let size = $("#" + me.pre + "labelsize" ).val();
           let color = $("#" + me.pre + "labelcolor" ).val();
           let background = $("#" + me.pre + "labelbkgd" ).val();
           if(size === '0' || size === '' || size === 'undefined') size = 0;
           if(color === '0' || color === '' || color === 'undefined') color = 0;
           if(background === '0' || background === '' || background === 'undefined') background = 0;
           if(ic.pAtom === undefined || ic.pAtom2 === undefined) {
             alert("Please pick another atom");
           }
           else {
             let x =(ic.pAtom.coord.x + ic.pAtom2.coord.x) / 2;
             let y =(ic.pAtom.coord.y + ic.pAtom2.coord.y) / 2;
             let z =(ic.pAtom.coord.z + ic.pAtom2.coord.z) / 2;
             ic.analysisCls.addLabel(text, x, y, z, size, color, background, 'custom');
             ic.pickpair = false;
             let sizeStr = '', colorStr = '', backgroundStr = '';
             if(size != 0) sizeStr = ' | size ' + size;
             if(color != 0) colorStr = ' | color ' + color;
             if(background != 0) backgroundStr = ' | background ' + background;
             thisClass.setLogCmd('add label ' + text + ' | x ' + x.toPrecision(4)  + ' y ' + y.toPrecision(4) + ' z ' + z.toPrecision(4) + sizeStr + colorStr + backgroundStr + ' | type custom', true);
             ic.drawCls.draw();
           }
        });

        me.myEventCls.onIds("#" + me.pre + "applyselection_labels", "click", function(e) { let ic = me.icn3d;
           e.preventDefault();
           if(!me.cfg.notebook) dialog.dialog( "close" );
           let text = $("#" + me.pre + "labeltext2" ).val();
           let size = $("#" + me.pre + "labelsize2" ).val();
           let color = $("#" + me.pre + "labelcolor2" ).val();
           let background = $("#" + me.pre + "labelbkgd2" ).val();
           if(size === '0' || size === '' || size === 'undefined') size = 0;
           if(color === '0' || color === '' || color === 'undefined') color = 0;
           if(background === '0' || background === '' || background === 'undefined') background = 0;
             let position = ic.applyCenterCls.centerAtoms(me.hashUtilsCls.hash2Atoms(ic.hAtoms, ic.atoms));
             let x = position.center.x;
             let y = position.center.y;
             let z = position.center.z;
             //thisClass.setLogCmd('add label ' + text + ' | size ' + size + ' | color ' + color + ' | background ' + background + ' | type custom', true);
             ic.analysisCls.addLabel(text, x, y, z, size, color, background, 'custom');
             let sizeStr = '', colorStr = '', backgroundStr = '';
             if(size != 0) sizeStr = ' | size ' + size;
             if(color != 0) colorStr = ' | color ' + color;
             if(background != 0) backgroundStr = ' | background ' + background;
             thisClass.setLogCmd('add label ' + text + ' | x ' + x.toPrecision(4)  + ' y ' + y.toPrecision(4) + ' z ' + z.toPrecision(4) + sizeStr + colorStr + backgroundStr + ' | type custom', true);
             ic.drawCls.draw();
        });

        me.myEventCls.onIds("#" + me.pre + "applylabelcolor", "click", function(e) { let ic = me.icn3d;
            e.preventDefault();
            if(!me.cfg.notebook) dialog.dialog( "close" );
            ic.labelcolor = $("#" + me.pre + "labelcolorall" ).val();

            thisClass.setLogCmd('set label color ' + ic.labelcolor, true);
            ic.drawCls.draw();
        });

        me.myEventCls.onIds("#" + me.pre + "applypick_stabilizer", "click", function(e) { let ic = me.icn3d;
           e.preventDefault();
           if(!me.cfg.notebook) dialog.dialog( "close" );
           if(ic.pAtom === undefined || ic.pAtom2 === undefined) {
             alert("Please pick another atom");
           }
           else {
             ic.pickpair = false;
             thisClass.setLogCmd('add one stabilizer | ' + ic.pAtom.serial + ' ' + ic.pAtom2.serial, true);
             if(ic.pairArray === undefined) ic.pairArray = [];
             ic.pairArray.push(ic.pAtom.serial);
             ic.pairArray.push(ic.pAtom2.serial);
             //ic.updateStabilizer();
             ic.threeDPrintCls.setThichknessFor3Dprint();
             ic.drawCls.draw();
           }
        });

    // https://github.com/tovic/color-picker
    // https://tovic.github.io/color-picker/color-picker.value-update.html
    //    pickColor: function() {
        let picker = new CP(document.querySelector("#" + me.pre + "colorcustom"));
        picker.on("change", function(color) {
            this.target.value = color;
        });
        me.myEventCls.onIds("#" + me.pre + "colorcustom", "input", function() {
            let color = $("#" + me.pre + "colorcustom").val();
            picker.set('#' + color).enter();
        });
        me.myEventCls.onIds("#" + me.pre + "colorcustom", "keyup", function() {
            let color = $("#" + me.pre + "colorcustom").val();
            picker.set('#' + color).enter();
        });
        me.myEventCls.onIds("#" + me.pre + "colorcustom", "paste", function() {
            let color = $("#" + me.pre + "colorcustom").val();
            picker.set('#' + color).enter();
        });
        me.myEventCls.onIds("#" + me.pre + "colorcustom", "cut", function() {
            let color = $("#" + me.pre + "colorcustom").val();
            picker.set('#' + color).enter();
        });

        let picker2 = new CP(document.querySelector("#" + me.pre + "labelcolorall"));
        picker2.on("change", function(color) {
            this.target.value = color;
        });
        me.myEventCls.onIds("#" + me.pre + "labelcolorall", "input", function() {
            let color = $("#" + me.pre + "labelcolorall").val();
            picker2.set('#' + color).enter();
        });
        me.myEventCls.onIds("#" + me.pre + "labelcolorall", "keyup", function() {
            let color = $("#" + me.pre + "labelcolorall").val();
            picker2.set('#' + color).enter();
        });
        me.myEventCls.onIds("#" + me.pre + "labelcolorall", "paste", function() {
            let color = $("#" + me.pre + "labelcolorall").val();
            picker2.set('#' + color).enter();
        });
        me.myEventCls.onIds("#" + me.pre + "labelcolorall", "cut", function() {
            let color = $("#" + me.pre + "labelcolorall").val();
            picker2.set('#' + color).enter();
        });    

        me.myEventCls.onIds("#" + me.pre + "applypick_stabilizer_rm", "click", function(e) { let ic = me.icn3d;
           e.preventDefault();
           if(!me.cfg.notebook) dialog.dialog( "close" );
           if(ic.pAtom === undefined || ic.pAtom2 === undefined) {
             alert("Please pick another atom");
           }
           else {
             ic.pickpair = false;
             thisClass.setLogCmd('remove one stabilizer | ' + ic.pAtom.serial + ' ' + ic.pAtom2.serial, true);
             let rmLineArray = [];
             rmLineArray.push(ic.pAtom.serial);
             rmLineArray.push(ic.pAtom2.serial);
             ic.threeDPrintCls.removeOneStabilizer(rmLineArray);
             //ic.updateStabilizer();
             ic.drawCls.draw();
           }
        });

        me.myEventCls.onIds("#" + me.pre + "applypick_measuredistance", "click", function(e) { let ic = me.icn3d;
           e.preventDefault();
           if(!me.cfg.notebook) dialog.dialog( "close" );
           ic.bMeasureDistance = false;
           if(ic.pAtom === undefined || ic.pAtom2 === undefined) {
             alert("Please pick another atom");
           }
           else {
             let size = 0, background = 0;
             let color = $("#" + me.pre + "linecolor" ).val();
             let x =(ic.pAtom.coord.x + ic.pAtom2.coord.x) / 2;
             let y =(ic.pAtom.coord.y + ic.pAtom2.coord.y) / 2;
             let z =(ic.pAtom.coord.z + ic.pAtom2.coord.z) / 2;
             ic.analysisCls.addLineFromPicking('distance');
             let distance = parseInt(ic.pAtom.coord.distanceTo(ic.pAtom2.coord) * 10) / 10;
             let text = distance.toString() + " A";
             ic.analysisCls.addLabel(text, x, y, z, size, color, background, 'distance');
             let sizeStr = '', colorStr = '', backgroundStr = '';
             if(color != 0) colorStr = ' | color ' + color;
             thisClass.setLogCmd('add label ' + text + ' | x ' + x.toPrecision(4)  + ' y ' + y.toPrecision(4) + ' z ' + z.toPrecision(4) + sizeStr + colorStr + backgroundStr + ' | type distance', true);
             ic.drawCls.draw();
             ic.pk = 2;
           }
        });


        me.myEventCls.onIds("#" + me.pre + "applydist2", "click", function(e) { let ic = me.icn3d;
           e.preventDefault();
           if(!me.cfg.notebook) dialog.dialog( "close" );
           ic.bMeasureDistance = false;

           let nameArray = $("#" + me.pre + "atomsCustomDist").val();
           let nameArray2 = $("#" + me.pre + "atomsCustomDist2").val();

           ic.analysisCls.measureDistTwoSets(nameArray, nameArray2);
           thisClass.setLogCmd("dist | " + nameArray2 + " " + nameArray, true);
        });

        $(document).on("click", ".icn3d-distance", function(e) { let ic = me.icn3d;
            e.preventDefault();
            ic.bMeasureDistance = false;

            ic.distPnts = [];
            ic.labels['distance'] = [];
            ic.lines['distance'] = [];

            let sets = $(this).attr('sets').split('|');
 
            let nameArray = [sets[0]];
            let nameArray2 = [sets[1]];
 
            ic.analysisCls.measureDistTwoSets(nameArray, nameArray2);
            thisClass.setLogCmd("dist | " + nameArray2 + " " + nameArray, true);
         });

        me.myEventCls.onIds("#" + me.pre + "applydisttable", "click", function(e) { let ic = me.icn3d;
            e.preventDefault();
            if(!me.cfg.notebook) dialog.dialog( "close" );
            ic.bMeasureDistance = false;
 
            let nameArray = $("#" + me.pre + "atomsCustomDistTable").val();
            let nameArray2 = $("#" + me.pre + "atomsCustomDistTable2").val();
 
            ic.analysisCls.measureDistManySets(nameArray, nameArray2);
            me.htmlCls.dialogCls.openDlg('dl_disttable', 'Distance among the sets');

            thisClass.setLogCmd("disttable | " + nameArray2 + " " + nameArray, true);
        });

        me.myEventCls.onIds("#" + me.pre + "applyangletable", "click", function(e) { let ic = me.icn3d;
            e.preventDefault();
            if(!me.cfg.notebook) dialog.dialog( "close" );
            ic.bMeasureAngle = false;
 
            let nameArray = $("#" + me.pre + "atomsCustomAngleTable").val();
            let nameArray2 = $("#" + me.pre + "atomsCustomAngleTable2").val();
 
            ic.analysisCls.measureAngleManySets(nameArray, nameArray2);
            me.htmlCls.dialogCls.openDlg('dl_angletable', 'Angles among the sets');

            thisClass.setLogCmd("angletable | " + nameArray2 + " " + nameArray, true);
        });

        me.myEventCls.onIds("#" + me.pre + "applylinebtwsets", "click", function(e) { let ic = me.icn3d;
            e.preventDefault();
            
            ic.bLinebtwsets = false;
 
            let nameArray = $("#" + me.pre + "linebtwsets").val();
            let nameArray2 = $("#" + me.pre + "linebtwsets2").val();
 
            let atomSet1 = ic.definedSetsCls.getAtomsFromNameArray(nameArray);
            let atomSet2 = ic.definedSetsCls.getAtomsFromNameArray(nameArray2);

            let posArray1 = ic.contactCls.getExtent(atomSet1);
            let posArray2 = ic.contactCls.getExtent(atomSet2);

            let pos1 = new THREE.Vector3(posArray1[2][0], posArray1[2][1], posArray1[2][2]);
            let pos2 = new THREE.Vector3(posArray2[2][0], posArray2[2][1], posArray2[2][2]);

            let radius = $("#" + me.pre + "linebtwsets_radius").val(); 
            let color = $("#" + me.pre + "linebtwsets_customcolor").val(); 
            let opacity = $("#" + me.pre + "linebtwsets_opacity").val();
            let dashed = ($("#" + me.pre + "linebtwsets_style").val() == 'Solid') ? false : true;
            let type = 'cylinder';

            let command = 'add line | x1 ' + pos1.x.toPrecision(4)  + ' y1 ' + pos1.y.toPrecision(4) + ' z1 ' + pos1.z.toPrecision(4) + ' | x2 ' + pos2.x.toPrecision(4)  + ' y2 ' + pos2.y.toPrecision(4) + ' z2 ' + pos2.z.toPrecision(4) + ' | color ' + color + ' | dashed ' + dashed + ' | type ' + type + ' | radius ' + radius + ' | opacity ' + opacity;

            thisClass.setLogCmd(command, true);

            ic.analysisCls.addLine(pos1.x, pos1.y, pos1.z, pos2.x, pos2.y, pos2.z, color, dashed, type, radius, opacity);
            ic.drawCls.draw();
        });

        me.myEventCls.onIds("#" + me.pre + "applycartoonshape", "click", function(e) { let ic = me.icn3d;
            e.preventDefault();
            
            ic.bCartoonshape = false;
 
            let nameArray = $("#" + me.pre + "cartoonshape").val();
            let atomSet1 = ic.definedSetsCls.getAtomsFromNameArray(nameArray);
            let posArray1 = ic.contactCls.getExtent(atomSet1);
            let pos1 = new THREE.Vector3(posArray1[2][0], posArray1[2][1], posArray1[2][2]);

            let shape = $("#" + me.pre + "cartoonshape_shape").val(); // Sphere or Cube
            let radius = $("#" + me.pre + "cartoonshape_radius").val(); 
            let colorStr = $("#" + me.pre + "cartoonshape_customcolor").val(); 
            let opacity = $("#" + me.pre + "cartoonshape_opacity").val();

            colorStr = '#' + colorStr.replace(/\#/g, '');
            let color = me.parasCls.thr(colorStr);
         
            // draw the shape
            let command;
            if(shape == 'Sphere') {
                ic.sphereCls.createSphereBase(pos1, color, radius, undefined, undefined, undefined, opacity);
                // command = 'add sphere | x1 ' + pos1.x.toPrecision(4)  + ' y1 ' + pos1.y.toPrecision(4) + ' z1 ' + pos1.z.toPrecision(4) + ' | color ' + colorStr + ' | opacity ' + opacity + ' | radius ' + radius;
                command = 'add sphere | ' + nameArray + ' | color ' + colorStr + ' | opacity ' + opacity + ' | radius ' + radius;
            }
            else {
                ic.boxCls.createBox_base(pos1, radius, color, undefined, undefined, undefined, opacity);
                // command = 'add cube | x1 ' + pos1.x.toPrecision(4)  + ' y1 ' + pos1.y.toPrecision(4) + ' z1 ' + pos1.z.toPrecision(4) + ' | color ' + colorStr + ' | opacity ' + opacity + ' | radius ' + radius;
                command = 'add cube | ' + nameArray + ' | color ' + colorStr + ' | opacity ' + opacity + ' | radius ' + radius;
            }

            thisClass.setLogCmd(command, true);
            ic.shapeCmdHash[command] = 1;

            ic.drawCls.draw();
        });

        me.myEventCls.onIds("#" + me.pre + "clearlinebtwsets", "click", function(e) { let ic = me.icn3d;
            e.preventDefault();
            

            ic.lines['cylinder'] = [];
            thisClass.setLogCmd('clear line between sets', true);

            ic.drawCls.draw();
        });

        me.myEventCls.onIds("#" + me.pre + "clearcartoonshape", "click", function(e) { let ic = me.icn3d;
            e.preventDefault();
            

            ic.shapeCmdHash = {};
            thisClass.setLogCmd('clear shape', true);

            ic.drawCls.draw();
        });

        me.myEventCls.onIds("#" + me.pre + "apply_thickness_3dprint", "click", function(e) { me.icn3d;
            e.preventDefault();

            me.htmlCls.setHtmlCls.setLineThickness("3dprint");
        });
        me.myEventCls.onIds("#" + me.pre + "apply_thickness_style", "click", function(e) { me.icn3d;
            e.preventDefault();

            me.htmlCls.setHtmlCls.setLineThickness("style");
            me.htmlCls.setMenuCls.setLogWindow(true);
        });

        me.myEventCls.onIds("#" + me.pre + "reset_thickness_3dprint", "click", function(e) { me.icn3d;
            e.preventDefault();

            me.htmlCls.setHtmlCls.setLineThickness("3dprint", true);
        });
        me.myEventCls.onIds("#" + me.pre + "reset_thickness_style", "click", function(e) { me.icn3d;
            e.preventDefault();

            me.htmlCls.setHtmlCls.setLineThickness("style", true);
            me.htmlCls.setMenuCls.setLogWindow(true);
        });


        me.myEventCls.onIds("#" + me.pre + "reset", "click", function(e) { let ic = me.icn3d;
            ic.selectionCls.resetAll();

            // need to render
            if(ic.bRender) ic.drawCls.draw(); //ic.drawCls.render();
        });

        me.myEventCls.onIds(["#" + me.pre + "toggleHighlight", "#" + me.pre + "toggleHighlight2"], "click", function(e) { let ic = me.icn3d;
            e.stopImmediatePropagation();
            ic.hlUpdateCls.toggleHighlight();
            thisClass.setLogCmd("toggle highlight", true);
        });
        me.myEventCls.onIds("#" + me.pre + "seq_clearselection", "click", function(e) { let ic = me.icn3d;
            e.stopImmediatePropagation();
            if(!me.cfg.notebook) dialog.dialog( "close" );
            ic.hlUpdateCls.clearHighlight();
            thisClass.setLogCmd("clear selection", true);
        });
        me.myEventCls.onIds("#" + me.pre + "seq_clearselection2", "click", function(e) { let ic = me.icn3d;
            e.stopImmediatePropagation();
            e.preventDefault();
            ic.hlUpdateCls.clearHighlight();
            thisClass.setLogCmd("clear selection", true);
        });
        me.myEventCls.onIds("#" + me.pre + "alignseq_clearselection", "click", function(e) { let ic = me.icn3d;
            e.stopImmediatePropagation();
            ic.hlUpdateCls.clearHighlight();
            thisClass.setLogCmd("clear selection", true);
        });

        me.myEventCls.onIds("#" + me.pre + "replay", "click", async function(e) { let ic = me.icn3d;
             e.stopImmediatePropagation();
             ic.CURRENTNUMBER++;
             let currentNumber =(me.cfg.replay) ? ic.STATENUMBER : ic.STATENUMBER - 1;

             if(ic.CURRENTNUMBER == currentNumber) {
                  ic.bReplay = 0;
                  $("#" + me.pre + "replay").hide();
             }
             else if(ic.commands.length > 0 && ic.commands[ic.CURRENTNUMBER]) {         
                  await ic.loadScriptCls.execCommandsBase(ic.CURRENTNUMBER, ic.CURRENTNUMBER, ic.STATENUMBER);
                  let pos = ic.commands[ic.CURRENTNUMBER].indexOf('|||');
                  let cmdStrOri =(pos != -1) ? ic.commands[ic.CURRENTNUMBER].substr(0, pos) : ic.commands[ic.CURRENTNUMBER];
                  let maxLen = 30;
                  let cmdStr =(cmdStrOri.length > maxLen) ? cmdStrOri.substr(0, maxLen) + '...' : cmdStrOri;
                  let menuStr = ic.applyCommandCls.getMenuFromCmd(cmdStr);
                  $("#" + me.pre + "replay_cmd").html('Cmd: ' + cmdStr);
                  $("#" + me.pre + "replay_menu").html('Menu: ' + menuStr);

                  thisClass.setLogCmd(cmdStrOri, true);

                  ic.drawCls.draw();
             }
        });


        ic.loadScriptCls.pressCommandtext();

        me.myEventCls.onIds("#" + me.pre + "seq_saveselection", "click", function(e) { let ic = me.icn3d;
           e.stopImmediatePropagation();
           if(!me.cfg.notebook) dialog.dialog( "close" );
           ic.selectionCls.saveSelectionPrep();
           let name = $("#" + me.pre + "seq_command_name").val().replace(/\s+/g, '_');
           //var description = $("#" + me.pre + "seq_command_desc").val();
           ic.selectionCls.saveSelection(name, name);
        });
        me.myEventCls.onIds("#" + me.pre + "seq_saveselection2", "click", function(e) { let ic = me.icn3d;
           e.stopImmediatePropagation();
           ic.selectionCls.saveSelectionPrep();
           let name = $("#" + me.pre + "seq_command_name2").val().replace(/\s+/g, '_');
           //var description = $("#" + me.pre + "seq_command_desc2").val();
           ic.selectionCls.saveSelection(name, name);
        });

        me.myEventCls.onIds("#" + me.pre + "mn2_saveresidue", "click", function(e) { let ic = me.icn3d;
            e.stopImmediatePropagation();
            if(!me.cfg.notebook) dialog.dialog( "close" );
            
            ic.selectionCls.saveEachResiInSel();

            thisClass.setLogCmd('select each residue', true);
         });


        me.myEventCls.onIds("#" + me.pre + "alignseq_saveselection", "click", function(e) { let ic = me.icn3d;
           e.stopImmediatePropagation();
           ic.selectionCls.saveSelectionPrep();
           let name = $("#" + me.pre + "alignseq_command_name").val().replace(/\s+/g, '_');
           //var description = $("#" + me.pre + "alignseq_command_desc").val();
           ic.selectionCls.saveSelection(name, name);
        });

        $(document).on("click", "." + me.pre + "outputselection", function(e) { let ic = me.icn3d;
              e.stopImmediatePropagation();
            ic.bSelectResidue = false;
            ic.bSelectAlignResidue = false;
            thisClass.setLogCmd('output selection', true);
            ic.threeDPrintCls.outputSelection();
        });

        $(document).on("click", ".icn3d-saveicon", function(e) { me.icn3d;
           e.stopImmediatePropagation();
           let id = $(this).attr('pid');

           thisClass.saveHtml(id);
           thisClass.setLogCmd("save html " + id, true);
        });

        $(document).on("click", ".icn3d-hideicon", function(e) { let ic = me.icn3d;
           e.stopImmediatePropagation();
           let id = $(this).attr('pid');
           if(!me.cfg.notebook) {
               if(ic.dialogHashHideDone === undefined) ic.dialogHashHideDone = {};
               if(ic.dialogHashPosToRight === undefined) ic.dialogHashPosToRight = {};
               if(!ic.dialogHashHideDone.hasOwnProperty(id)) {
                   ic.dialogHashHideDone[id] = {"width": $("#" + id).dialog( "option", "width"), "height": $("#" + id).dialog( "option", "height"), "position": $("#" + id).dialog( "option", "position")};
                   let dialogWidth = 160;
                   let dialogHeight = 80;
                   $("#" + id).dialog( "option", "width", dialogWidth );
                   $("#" + id).dialog( "option", "height", dialogHeight );
                   let posToRight;
                   if(ic.dialogHashPosToRight.hasOwnProperty(id)) {
                       posToRight = ic.dialogHashPosToRight[id];
                   }
                   else {
                       posToRight = Object.keys(ic.dialogHashPosToRight).length *(dialogWidth + 10);
                       ic.dialogHashPosToRight[id] = posToRight;
                   }
                   let position ={ my: "right bottom", at: "right-" + posToRight + " bottom+60", of: "#" + ic.divid, collision: "none" };
                   $("#" + id).dialog( "option", "position", position );
               }
               else {
                   let width = ic.dialogHashHideDone[id].width;
                   let height = ic.dialogHashHideDone[id].height;
                   let position = ic.dialogHashHideDone[id].position;
                   $("#" + id).dialog( "option", "width", width );
                   $("#" + id).dialog( "option", "height", height );
                   $("#" + id).dialog( "option", "position", position );
                   delete ic.dialogHashHideDone[id];
               }
           }
        });

        // highlight a pair residues
        $(document).on("click", "." + me.pre + "selres", function(e) { let ic = me.icn3d;
              e.stopImmediatePropagation();
              ic.bSelOneRes = false;
              let elems = $( "." + me.pre + "seloneres" );
              for(let i = 0, il = elems.length; i < il;  ++i) {
                  elems[i].checked = false;
              }
              let idArray = $(this).attr('resid').split('|');
              ic.hAtoms = {};
              ic.selectedResidues = {};
              let cmd = 'select ';
              for(let i = 0, il = idArray.length; i < il; ++i) {
                  let idStr = idArray[i]; // TYR $1KQ2.B:56@OH, or ASP $1KQ2.B:40
                  if(i > 0) cmd += ' or ';
                  cmd += ic.selectionCls.selectOneResid(idStr);
              }
              ic.hlUpdateCls.updateHlAll();
              thisClass.setLogCmd(cmd, true);
        });
        // highlight a residue
        $(document).on("click", "." + me.pre + "seloneres", function(e) { let ic = me.icn3d;
              e.stopImmediatePropagation();
              if(!ic.bSelOneRes) {
                  ic.hAtoms = {};
                  ic.selectedResidues = {};
                  ic.bSelOneRes = true;
              }
              let resid = $(this).attr('resid');
              let id = $(this).attr('id');
              if($("#" + id).length && $("#" + id)[0].checked) { // checked
                  ic.selectionCls.selectOneResid(resid);
              }
              else if($("#" + id).length && !$("#" + id)[0].checked) { // unchecked
                  ic.selectionCls.selectOneResid(resid, true);
              }
              ic.hlUpdateCls.updateHlAll();
        });
        // highlight a set of residues
        $(document).on("click", "." + me.pre + "selset", async function(e) { let ic = me.icn3d;
              e.stopImmediatePropagation();
              ic.bSelOneRes = false;
              let elems = $( "." + me.pre + "seloneres" );
              for(let i = 0, il = elems.length; i < il;  ++i) {
                  elems[i].checked = false;
              }
              let cmd = $(this).attr('cmd');
              await ic.selByCommCls.selectByCommand(cmd, '', '');
              ic.hlObjectsCls.removeHlObjects();  // render() is called
              ic.hlObjectsCls.addHlObjects();  // render() is called
              thisClass.setLogCmd(cmd, true);
        });


        $(document).on("click", ".icn3d-addtrack", function(e) { let ic = me.icn3d;
          e.stopImmediatePropagation();
          $("#" + me.pre + "anno_custom")[0].checked = true;
          $("[id^=" + me.pre + "custom]").show();
          //e.preventDefault();
          let chainid = $(this).attr('chainid');
          let geneid = ic.chainsGene[chainid].geneId;
          $("#" + me.pre + "track_chainid").val(chainid);
          $("#" + me.pre + "track_geneid").val(geneid);
          me.htmlCls.dialogCls.openDlg('dl_addtrack', 'Add track for Chain: ' + chainid);
          $( "#" + me.pre + "track_gi" ).focus();
        });

        $(document).on("click", ".icn3d-customcolor", function(e) { me.icn3d;
          e.stopImmediatePropagation();
          //e.preventDefault();
          let chainid = $(this).attr('chainid');
          $("#" + me.pre + "customcolor_chainid").val(chainid);
          me.htmlCls.dialogCls.openDlg('dl_customcolor', 'Apply custom color or tube for Chain: ' + chainid);
        });

        $(document).on("click", ".icn3d-helixsets", function(e) { let ic = me.icn3d;
          e.stopImmediatePropagation();
          //e.preventDefault();
          let chainid = $(this).attr('chainid');
          ic.addTrackCls.defineSecondary(chainid, 'helix');
          thisClass.setLogCmd('define helix sets | chain ' + chainid, true);
        });

        $(document).on("click", ".icn3d-sheetsets", function(e) { let ic = me.icn3d;
          e.stopImmediatePropagation();
          //e.preventDefault();
          let chainid = $(this).attr('chainid');
          ic.addTrackCls.defineSecondary(chainid, 'sheet');
          thisClass.setLogCmd('define sheet sets | chain ' + chainid, true);
        });

        $(document).on("click", ".icn3d-coilsets", function(e) { let ic = me.icn3d;
          e.stopImmediatePropagation();
          //e.preventDefault();
          let chainid = $(this).attr('chainid');
          ic.addTrackCls.defineSecondary(chainid, 'coil');
          thisClass.setLogCmd('define coil sets | chain ' + chainid, true);
        });

        $(document).on("click", ".icn3d-iganchorsets", function(e) { let ic = me.icn3d;
            e.stopImmediatePropagation();
            //e.preventDefault();
            let chainid = $(this).attr('chainid');
            ic.addTrackCls.defineIgstrand(chainid, 'iganchor');
            thisClass.setLogCmd('define iganchor sets | chain ' + chainid, true);
        });

        $(document).on("click", ".icn3d-igstrandsets", function(e) { let ic = me.icn3d;
            e.stopImmediatePropagation();
            //e.preventDefault();
            let chainid = $(this).attr('chainid');
            ic.addTrackCls.defineIgstrand(chainid, 'igstrand');
            thisClass.setLogCmd('define igstrand sets | chain ' + chainid, true);
        });

        $(document).on("click", ".icn3d-igloopsets", function(e) { let ic = me.icn3d;
            e.stopImmediatePropagation();
            //e.preventDefault();
            let chainid = $(this).attr('chainid');
            ic.addTrackCls.defineIgstrand(chainid, 'igloop');
            thisClass.setLogCmd('define igloop sets | chain ' + chainid, true);
        });

        $(document).on("click", ".icn3d-igdomainsets", function(e) { let ic = me.icn3d;
            e.stopImmediatePropagation();
            //e.preventDefault();
            let chainid = $(this).attr('chainid');
            ic.addTrackCls.defineIgstrand(chainid, 'igdomain');
            thisClass.setLogCmd('define igdomain sets | chain ' + chainid, true);
        });

        me.myEventCls.onIds("#" + me.pre + "deletesets", "click", function(e) { let ic = me.icn3d;
             ic.definedSetsCls.deleteSelectedSets();
             thisClass.setLogCmd("delete selected sets", true);
        });

        $(document).on('mouseup touchend', "accordion", function(e) { let ic = me.icn3d;
          if(ic.bControlGl && !me.bNode) {
              if(window.controls) {
                window.controls.noRotate = false;
                window.controls.noZoom = false;
                window.controls.noPan = false;
              }
          }
          else {
              if(ic.controls) {
                ic.controls.noRotate = false;
                ic.controls.noZoom = false;
                ic.controls.noPan = false;
              }
          }
        });

       $(document).on('mousedown touchstart', "accordion", function(e) { let ic = me.icn3d;
          if(ic.bControlGl && !me.bNode) {
              if(window.controls) {
                window.controls.noRotate = true;
                window.controls.noZoom = true;
                window.controls.noPan = true;
              }
          }
          else {
              if(ic.controls) {
                ic.controls.noRotate = true;
                ic.controls.noZoom = true;
                ic.controls.noPan = true;
              }
          }
        });

        //$("[id$=_cddseq_expand]").on('click', '.ui-icon-plus', function(e) { let ic = me.icn3d;
        $(document).on("click", ".icn3d-expand", function(e) { me.icn3d;
            e.stopImmediatePropagation();
            let oriId = $(this).attr('id');
            let pos = oriId.lastIndexOf('_');
            let id = oriId.substr(0, pos);
            $("#" + id).show();
            $("#" + id + "_expand").hide();
            $("#" + id + "_shrink").show();
        });
        //$("[id$=_cddseq_shrink]").on('click', '.ui-icon-minus', function(e) { let ic = me.icn3d;
        $(document).on("click", ".icn3d-shrink", function(e) { me.icn3d;
            e.stopImmediatePropagation();
            let oriId = $(this).attr('id');
            let pos = oriId.lastIndexOf('_');
            let id = oriId.substr(0, pos);
            $("#" + id).hide();
            $("#" + id + "_expand").show();
            $("#" + id + "_shrink").hide();
        });

        window.onscroll = function(e) { let ic = me.icn3d;
            if(ic.view == 'detailed view' && $(window).scrollTop() == 0 && $(window).scrollTop() == 0 && $("#" + me.pre + "dl_selectannotations").scrollTop() == 0) {
                // show fixed titles
                ic.annotationCls.showFixedTitle();
            }
            else {
                // remove fixed titles
                ic.annotationCls.hideFixedTitle();
            }
        } ;
        me.myEventCls.onIds( "#" + me.pre + "dl_selectannotations", "scroll", function() {
            if(ic.view == 'detailed view' && $(window).scrollTop() == 0 && $(window).scrollTop() == 0 && $("#" + me.pre + "dl_selectannotations").scrollTop() == 0) {
                // show fixed titles
                ic.annotationCls.showFixedTitle();
            }
            else {
                // remove fixed titles
                ic.annotationCls.hideFixedTitle();
            }
        });


        me.myEventCls.onIds("#" + me.pre + "mn6_themeBlue", "click", function(e) { me.icn3d;
           me.htmlCls.setMenuCls.setTheme('blue');
           thisClass.setLogCmd("set theme blue", true);
        });
        me.myEventCls.onIds("#" + me.pre + "mn6_themeOrange", "click", function(e) { me.icn3d;
           me.htmlCls.setMenuCls.setTheme('orange');
           thisClass.setLogCmd("set theme orange", true);
        });
        me.myEventCls.onIds("#" + me.pre + "mn6_themeBlack", "click", function(e) { me.icn3d;
           me.htmlCls.setMenuCls.setTheme('black');
           thisClass.setLogCmd("set theme black", true);
        });

        $(document).on("click", "." + me.pre + "snpin3d", async function(e) { let ic = me.icn3d;
            e.stopImmediatePropagation();

            let snp = $(this).attr('snp');

            await ic.scapCls.retrieveScap(snp);
            thisClass.setLogCmd('scap 3d ' + snp, true);
            thisClass.setLogCmd("select displayed set", true);
        });

        $(document).on("click", "." + me.pre + "snpinter", async function(e) { let ic = me.icn3d;
            e.stopImmediatePropagation();

            let snp = $(this).attr('snp');

            let bInteraction = true;
            await ic.scapCls.retrieveScap(snp, bInteraction);
            thisClass.setLogCmd('scap interaction ' + snp, true);

            let idArray = snp.split('_'); //stru_chain_resi_snp
            let select = '.' + idArray[1] + ':' + idArray[2];
            let name = 'snp_' + idArray[1] + '_' + idArray[2];
            thisClass.setLogCmd("select " + select + " | name " + name, true);
            thisClass.setLogCmd("line graph interaction pairs | selected non-selected | hbonds,salt bridge,interactions,halogen,pi-cation,pi-stacking | false | threshold 3.8 6 4 3.8 6 5.5", true);
            thisClass.setLogCmd("adjust dialog dl_linegraph", true);
            thisClass.setLogCmd("select displayed set", true);
        });

        $(document).on("click", "." + me.pre + "snppdb", async function(e) { let ic = me.icn3d;
            e.stopImmediatePropagation();

            let snp = $(this).attr('snp');

            let bPdb = true;
            await ic.scapCls.retrieveScap(snp, undefined, bPdb);
            thisClass.setLogCmd('scap pdb ' + snp, true);
        });

    }

}

/**
 * @author Jiyao Wang <wangjiy@ncbi.nlm.nih.gov> / https://github.com/ncbi/icn3d
 */

class AlignSeq {
    constructor(icn3dui) {
        this.icn3dui = icn3dui;
    }

    //Set up the sequence display with the aligned sequences. Either chains in "alignChainArray" or residues
    //in "residueArray" will be highlighted. "bUpdateHighlightAtoms" is a flag to update the highlight atoms
    //or not. "bShowHighlight" is a flag to show highlight or not.
    getAlignSequencesAnnotations(alignChainArray, bUpdateHighlightAtoms, residueArray, bShowHighlight, bOnechain, bReverse) {
        let me = this.icn3dui,
            ic = me.icn3d;
        let sequencesHtml = '';

        alignChainArray = Object.keys(ic.alnChains);

        if (bReverse) alignChainArray = alignChainArray.reverse();
        
        let maxSeqCnt = 0;

        let chainHash = {};
        if (alignChainArray !== undefined) {

            for (let i = 0, il = alignChainArray.length; i < il; ++i) {
                let chainid = alignChainArray[i];

                // make sure some residues are aligned
                if(ic.alnChainsSeq[chainid] && ic.alnChainsSeq[chainid].length > 0) {
                    chainHash[chainid] = 1;
                }
                else {
                    return { "sequencesHtml": sequencesHtml, "maxSeqCnt": maxSeqCnt };
                }
            }
        }

        //  let bModifyHAtoms = Object.keys(ic.hAtoms).length == Object.keys(ic.atoms).length && bHighlightChain &&(bUpdateHighlightAtoms === undefined || bUpdateHighlightAtoms);
        //  let bModifyHAtoms = Object.keys(ic.hAtoms).length == Object.keys(ic.atoms).length &&(bUpdateHighlightAtoms === undefined || bUpdateHighlightAtoms);
        let bModifyHAtoms = (bUpdateHighlightAtoms === undefined || bUpdateHighlightAtoms);

        if (bModifyHAtoms) {
            ic.hAtoms = {};
        }

        let bHighlightChain;
        let index = 0, prevResCnt2nd = 0;
        let firstChainid, oriChainid;

        //  for(let i in ic.alnChains) {
        for (let m = 0, ml = alignChainArray.length; m < ml; ++m) {
            let i = alignChainArray[m];
          
            if (index == 0) firstChainid = i;

            if (bOnechain && index > 0) {
                oriChainid = firstChainid;
            } else {
                oriChainid = i;
            }

            //bHighlightChain =(alignChainArray !== undefined && chainHash.hasOwnProperty(oriChainid)) ? true : false;

            //if( bHighlightChain &&(bUpdateHighlightAtoms === undefined || bUpdateHighlightAtoms) ) {
            // do not update isa subset is selected already
            if (bModifyHAtoms) {
                ic.hAtoms = me.hashUtilsCls.unionHash(ic.hAtoms, ic.alnChains[i]);
            }

            let resiHtmlArray = [], seqHtml = "";
            let seqLength = (ic.alnChainsSeq[i] !== undefined) ? ic.alnChainsSeq[i].length : 0;

            if (seqLength > maxSeqCnt) maxSeqCnt = seqLength;

            let dashPos = oriChainid.indexOf('_');
            let structure = oriChainid.substr(0, dashPos);
            let chain = oriChainid.substr(dashPos + 1);

            //let startResi = (ic.alnChainsSeq[i][0] !== undefined) ? ic.alnChainsSeq[i][0].resi : '';
            let startResi, endResi;
            for (let k = 0, kl = seqLength; k < kl; ++k) {
                if(ic.alnChainsSeq[i][k].resn != '-') {
                    startResi = ic.alnChainsSeq[i][k].resi;
                    break;
                }
            }

            for (let k = seqLength - 1; k >= 0; --k) {
                if(ic.alnChainsSeq[i][k].resn != '-') {
                    endResi = ic.alnChainsSeq[i][k].resi;
                    break;
                }
            }

            seqHtml += "<span class='icn3d-residueNum' title='starting residue number'>" + startResi + "</span>";
            bHighlightChain = (alignChainArray !== undefined && chainHash.hasOwnProperty(oriChainid)) ? true : false;

            for (let k = 0, kl = seqLength; k < kl; ++k) {
                // resiId is empty if it's gap
                let resiId = 'N/A', resIdFull = '';
                //if (ic.alnChainsSeq[i][k].resi !== '' && !isNaN(ic.alnChainsSeq[i][k].resi)) {
                if (ic.alnChainsSeq[i][k].resi !== '') {
                    resiId = ic.alnChainsSeq[i][k].resi;
                    resIdFull = structure + "_" + chain + "_" + resiId;
                    ic.alnChainsSeq[i][k].color;
                }

                let classForAlign = "class='icn3d-residue"; // used to identify a residue when clicking a residue in sequence

                //if((bShowHighlight === undefined || bShowHighlight) &&(bHighlightChain ||(ic.alnChainsSeq[i][k].aligned === 2 && residueArray !== undefined && resIdFull !== '' && residueArray.indexOf(resIdFull) !== -1) ) ) {
                if ((bShowHighlight === undefined || bShowHighlight) && (bHighlightChain || (residueArray !== undefined && resIdFull !== '' && residueArray.indexOf(resIdFull) !== -1))) {
                    classForAlign = "class='icn3d-residue icn3d-highlightSeq";
                }

                // class for alignment: cons, ncons, nalign
                if (resIdFull === '') {
                    classForAlign += "'";
                } else {
                    classForAlign += " " + ic.alnChainsSeq[i][k].class + "'";
                }

                let colorRes;

                if (!ic.residues.hasOwnProperty(resIdFull)) {                  
                    colorRes = '#000000;';
                } else {
                    let firstAtom = ic.firstAtomObjCls.getFirstCalphaAtomObj(ic.residues[resIdFull]);
                    colorRes = (firstAtom.color !== undefined) ? '#' + firstAtom.color.getHexString() + ';' : '#000000;';
                }

                if (colorRes.toUpperCase() === '#FFFFFF;') colorRes = me.htmlCls.GREYD;

                let bWithCoord = (resIdFull !== '') ? true : false;

                if (bOnechain && k == 0) {
                    let letterSpace = 10;
                    let empthWidth = prevResCnt2nd * letterSpace;
                    seqHtml += "<span style='width:" + empthWidth + "px'></span>";
                }

                if (bWithCoord) {
                    if (ic.alnChainsSeq[i][k].resi != -1) {
                        // add "align" in front of id so that full sequence and aligned sequence will not conflict
                        seqHtml += "<span id='align_" + me.pre + resIdFull + "' " + classForAlign + " style='color:" + colorRes + "' title='" + ic.alnChainsSeq[i][k].resn + ic.alnChainsSeq[i][k].resi + "'>" + ic.alnChainsSeq[i][k].resn + "</span>";
                    } else {
                        seqHtml += "<span>" + ic.alnChainsSeq[i][k].resn + "</span>";
                    }
                } else {
                    seqHtml += "<span title='" + ic.alnChainsSeq[i][k].resn + ic.alnChainsSeq[i][k].resi + "'>" + ic.alnChainsSeq[i][k].resn + "</span>";
                }

            }
            //let endResi = (ic.alnChainsSeq[i][seqLength - 1] !== undefined) ? ic.alnChainsSeq[i][seqLength - 1].resi : '';
            seqHtml += "<span class='icn3d-residueNum' title='ending residue number'>" + endResi + "</span>";

            let n = alignChainArray.length;

            // the first chain stores all annotations
            // secondary: n, labels: 2, title: n, empty line: 1
            let annoLength = (ic.alnChainsAnno[i] !== undefined) ? ic.alnChainsAnno[i].length : 0;

            for (let j = 0, jl = annoLength; j < jl; ++j) {
                resiHtmlArray[j] = "";

                //let chainid = (j == 0 && annoLength >= 7) ? ic.alnChainsAnTtl[i][4][0] : oriChainid; // bottom secondary, j == 0: chain2,  next secondary, j == 1: chain1,
                let chainid = (j < n) ?  alignChainArray[n - 1 - j] : oriChainid; // bottom secondary, j == 0: chain2,  next secondary, j == 1: chain1,

                resiHtmlArray[j] += "<span class='icn3d-residueNum'></span>"; // a spot corresponding to the starting and ending residue number
                for (let k = 0, kl = ic.alnChainsAnno[i][j].length; k < kl; ++k) {
                    let text = ic.alnChainsAnno[i][j][k];

                    if (text == 'H' || text == 'E' || text == 'c' || text == 'o') {

                        if (text == 'H') {
                            if (k % 2 == 0) {
                                resiHtmlArray[j] += '<span class="icn3d-helix">&nbsp;</span>';
                            } else {
                                resiHtmlArray[j] += '<span class="icn3d-helix2">&nbsp;</span>';
                            }
                        } else if (text == 'E') {
                            if (ic.alnChainsSeq[chainid][k] !== undefined) {
                                let resiId = ic.alnChainsSeq[chainid][k].resi;
                                let resIdFull = chainid + "_" + resiId;

                                if (ic.residues.hasOwnProperty(resIdFull)) {
                                    let atom = ic.firstAtomObjCls.getFirstCalphaAtomObj(ic.residues[resIdFull]);

                                    if (atom.ssend) {
                                        resiHtmlArray[j] += '<span class="icn3d-sheet2">&nbsp;</span>';
                                    } else {
                                        resiHtmlArray[j] += '<span class="icn3d-sheet">&nbsp;</span>';
                                    }
                                }
                                else {
                                    resiHtmlArray[j] += '<span class="icn3d-sheet">&nbsp;</span>';
                                }
                            }
                            else {
                                resiHtmlArray[j] += '<span class="icn3d-sheet">&nbsp;</span>';
                            }
                        } else if (text == 'c') {
                            resiHtmlArray[j] += '<span class="icn3d-coil">&nbsp;</span>';
                        } else if (text == 'o') {
                            resiHtmlArray[j] += '<span class="icn3d-other">&nbsp;</span>';
                        } else {                          
                            resiHtmlArray[j] += "<span></span>";
                        }
                    } else {
                        resiHtmlArray[j] += "<span>" + text + "</span>";
                    }
                    //resiHtmlArray[j] += "<span>" + ic.alnChainsAnno[i][j][k] + "</span>";
                }
                resiHtmlArray[j] += "<span class='icn3d-residueNum'></span>"; // a spot corresponding to the starting and ending residue number
            }

            let chainidTmp = i,
                title = (ic.pdbid_chain2title !== undefined) ? ic.pdbid_chain2title[oriChainid] : '';

            // add markers and residue numbers
            for (let j = annoLength - 1; j >= 0; --j) {
                let annotitle = ic.alnChainsAnTtl[i][j][0];
                if (annotitle == 'SS') annotitle = '';
                //sequencesHtml += "<div class='icn3d-residueLine' style='white-space:nowrap;'><div class='icn3d-seqTitle' chain='" + i + "' anno='" + j + "'>" + annotitle + "</div>" + resiHtmlArray[j] + "<br/></div>";
                sequencesHtml += "<div class='icn3d-residueLine' style='white-space:nowrap;'><div class='icn3d-seqTitle' anno='" + j + "'>" + annotitle + "</div>" + resiHtmlArray[j] + "<br/></div>";
            }
            
            sequencesHtml += '<div class="icn3d-seqTitle icn3d-link icn3d-blue" chain="' + i + '" anno="sequence" title="' + title + '">' + chainidTmp + ' </div><span class="icn3d-seqLine">' + seqHtml + '</span><br/>';

            if (index > 0) prevResCnt2nd += seqLength;

            ++index;
        }

        return { "sequencesHtml": sequencesHtml, "maxSeqCnt": maxSeqCnt }
    }
}

/**
 * @author Jiyao Wang <wangjiy@ncbi.nlm.nih.gov> / https://github.com/ncbi/icn3d
 */

class SetHtml {
    constructor(icn3dui) {
        this.icn3dui = icn3dui;
    }

    getLink(id, text, bSimpleMenu, selType) { let me = this.icn3dui; me.icn3d;
        me.htmlCls.allMenus[id] = text;
        if(selType) me.htmlCls.allMenusSel[id] = selType;
        if(bSimpleMenu) me.htmlCls.simpleMenus[id] = 1;

        return "<li><span data-pinger id='" + me.pre + id + "' class='icn3d-link'>" + text + "</span></li>";
    }

    // a group of menus
    getMenuText(id, text, classname, bSimpleMenu, selType) { let me = this.icn3dui; me.icn3d;
        me.htmlCls.allMenus[id] = text;
        if(selType) me.htmlCls.allMenusSel[id] = selType;
        if(bSimpleMenu) me.htmlCls.simpleMenus[id] = 1;

        let styleStr = (classname == 'icn3d-menupd') ? " style='padding-left:1.5em!important;'" : "";

        // no ending "</li>"" since this is usually the start of a group of menus
        return "<li><span data-pinger id='" + me.pre + id + "'" + styleStr + ">" + text + "</span>"; 
    }

    getMenuUrl(id, url, text, bSimpleMenu, selType) { let me = this.icn3dui; me.icn3d;
        me.htmlCls.allMenus[id] = text;
        if(selType) me.htmlCls.allMenusSel[id] = selType;
        if(bSimpleMenu) me.htmlCls.simpleMenus[id] = 1;

        return "<li><a id='" + me.pre + id + "' href='" + url + "' target='_blank'>" + text + "</a></li>";
    }

    getMenuSep() { let me = this.icn3dui; me.icn3d;
        return "<li class='icn3d-menusep'>-</li>";
    }

    getLinkWrapper(id, text, wrapper, bSimpleMenu, selType, bHide) { let me = this.icn3dui; me.icn3d;
        me.htmlCls.allMenus[id] = text;
        if(selType) me.htmlCls.allMenusSel[id] = selType;
        if(bSimpleMenu) me.htmlCls.simpleMenus[id] = 1;

        let hideStr = (bHide) ? ' style="display:none"' : '';
        return "<li id='" + me.pre + wrapper + "'" + hideStr + "><span data-pinger id='" + me.pre + id + "' class='icn3d-link'>" + text + "</span></li>";
    }

    getLinkWrapper2(id, text, wrapper, bSimpleMenu, selType) { let me = this.icn3dui; me.icn3d;
        me.htmlCls.allMenus[id] = text;
        if(selType) me.htmlCls.allMenusSel[id] = selType;
        if(bSimpleMenu) me.htmlCls.simpleMenus[id] = 1;

        return "<li id='" + me.pre + wrapper + "'><span data-pinger id='" + me.pre + id + "' class='icn3d-link'>" + text + "</span>";
    }

    getRadio(radioid, id, text, bChecked, bSimpleMenu, selType) { let me = this.icn3dui; me.icn3d;
        me.htmlCls.allMenus[id] = text;
        if(selType) me.htmlCls.allMenusSel[id] = selType;
        if(bSimpleMenu) me.htmlCls.simpleMenus[id] = 1;

        let checkedStr =(bChecked) ? ' checked' : '';

        //https://stackoverflow.com/questions/17541614/use-images-instead-of-radio-buttons/17541916
        return "<li><label data-pinger id='" + me.pre + id + "' class='icn3d-rad'>" + me.htmlCls.inputRadioStr + "name='" + me.pre + radioid + "' " + "class='" + me.pre + radioid + "' " + "v='" + text + "'" + checkedStr + "><span class='ui-icon ui-icon-blank'></span> <span class='icn3d-rad-text'>" + text + "</span></label></li>";
    }

    getRadioColor(radioid, id, text, color, bChecked, bSimpleMenu, selType) { let me = this.icn3dui; me.icn3d;
        me.htmlCls.allMenus[id] = text;
        if(selType) me.htmlCls.allMenusSel[id] = selType;
        if(bSimpleMenu) me.htmlCls.simpleMenus[id] = 1;

        let checkedStr =(bChecked) ? ' checked' : '';

        //https://stackoverflow.com/questions/17541614/use-images-instead-of-radio-buttons/17541916
        return "<li><label data-pinger id='" + me.pre + id + "' class='icn3d-rad'>" + me.htmlCls.inputRadioStr + "name='" + me.pre + radioid + "'" + checkedStr + "><span class='ui-icon ui-icon-blank'></span> <span class='icn3d-color-rad-text' color='" + color + "'><span style='background-color:#" + color + "'>" + me.htmlCls.space3 + "</span> " + text + "</span></label></li>";
    }

    setAdvanced(index) { let me = this.icn3dui; me.icn3d;
        let indexStr =(index === undefined) ? '' : index;

        let dialogClass =(me.cfg.notebook) ? 'icn3d-hidden' : '';
        let html = me.htmlCls.divStr + "dl_advanced" + indexStr + "' class='" + dialogClass + "'>";

        html += "<table width='500'><tr><td valign='top'><table cellspacing='0'>";
        html += "<tr><td><b>Select:</b></td><td>" + me.htmlCls.inputTextStr + "id='" + me.pre + "command" + indexStr + "' placeholder='$[structures].[chains]:[residues]@[atoms]' size='60'></td></tr>";
        html += "<tr><td><b>Name:</b></td><td>" + me.htmlCls.inputTextStr + "id='" + me.pre + "command_name" + indexStr + "' placeholder='my_selection' size='60'></td></tr>";
        html += "<tr><td colspan='2' align='left'>" + me.htmlCls.space3 + me.htmlCls.buttonStr + "command_apply" + indexStr + "'><b>Save Selection to Defined Sets</b></button></td></tr>";
        html += "</table></td>";

        html += "</tr>";

        html += "<tr><td>";

        html += 'Specification Tips: <div style="width:20px; margin-top:6px; display:inline-block;"><span id="' + me.pre + 'specguide' + indexStr + '_expand" class="ui-icon ui-icon-plus icn3d-expand icn3d-link" style="width:15px;" title="Expand"></span><span id="' + me.pre + 'specguide' + indexStr + '_shrink" class="ui-icon ui-icon-minus icn3d-shrink icn3d-link" style="display:none; width:15px;" title="Shrink"></span></div><br>';

        html += me.htmlCls.divStr + "specguide" + indexStr + "' style='display:none; width:500px' class='icn3d-box'>";

        html += "<b>Specification:</b> In the selection \"$1HHO,4N7N.A,B,C:5-10,LV,3AlaVal,chemicals@CA,C,C*\":";
        html += "<ul><li>\"$1HHO,4N7N\" uses \"$\" to indicate structure selection.<br/>";
        html += "<li>\".A,B,C\" uses \".\" to indicate chain selection.<br/>";
        html += "<li>\":5-10,LV,3LeuVal,chemicals\" uses the colon \":\" to indicate residue selection. Residue selection could be residue number(5-10), one-letter IUPAC residue name abbreviations(LV), three-letter residue names(AlaVal, \"3\" indicates each residue name has three letters), or predefined names: \"proteins\", \"nucleotides\", \"chemicals\", \"ions\", and \"water\". IUPAC abbreviations can be written either as a contiguous string(e.g., \":LV\"), in order to find all instances of that sequence in the structure, or they can be separated by commas(e.g., \":L,V\") to select all residues of a given type in the structure(in the latter case, select all Leucine and Valine in the structure).<br/>";
        html += "<li>\"@CA,C,C*\" uses \"@\" to indicate atom name selection. \"C*\" selects any atom names starting with \"C\". <br/>";
        html += "<li>Partial definition is allowed, e.g., \":1-10\" selects all residue IDs 1-10 in all chains.<br/>";
        html += "<li>Different selections can be unioned(with \"<b>or</b>\", default), intersected(with \"<b>and</b>\"), or negated(with \"<b>not</b>\"). For example, \":1-10 or :K\" selects all residues 1-10 and all Lys residues. \":1-10 and :K\" selects all Lys residues in the range of residue number 1-10. \":1-10 or not :K\" selects all residues 1-10, which are not Lys residues.<br/>";
        html += "<li>The wild card character \"X\" or \"x\" can be used to represent any character.";
        html += "</ul>";
        html += "<b>Set Operation:</b>";
        html += "<ul><li>Users can select multiple sets in the menu \"Select > Defined Sets\".<br/>";
        html += "<li>Different sets can be unioned(with \"<b>or</b>\", default), intersected(with \"<b>and</b>\"), or negated(with \"<b>not</b>\"). For example, if the \"Defined Sets\" menu has four sets \":1-10\", \":11-20\", \":5-15\", and \":7-8\", the command \"saved atoms :1-10 or :11-20 and :5-15 not :7-8\" unions all residues 1-10 and 11-20 to get the residues 1-20, then intersects with the residues 5-15 to get the residues 5-15, then exclude the residues 7-8 to get the final residues 5-6 and 9-15.</ul>";
        html += "<b>Full commands in url or command window:</b>";
        html += "<ul><li>Select without saving the set: select $1HHO,4N7N.A,B,C:5-10,LV,chemicals@CA,C,C*<br/>";
        //html += "<li>Select and save: select $1HHO,4N7N.A,B,C:5-10,LV,chemicals@CA,C | name my_name | description my_description</ul>";
        html += "<li>Select and save: select $1HHO,4N7N.A,B,C:5-10,LV,chemicals@CA,C,C* | name my_name</ul>";

        html += "</div>";

        html += "</td></tr></table>";
        html += "</div>";

        return html;
    }

    getOptionHtml(optArray, selIndex) { let me = this.icn3dui; me.icn3d;
        let html = '';

        for(let i = 0, il = optArray.length; i < il; ++i) {
            let iStr = optArray[i];

            if(i == selIndex) {
                html += me.htmlCls.optionStr + "'" + iStr + "' selected>" + iStr + "</option>";
            }
            else {
                html += me.htmlCls.optionStr + "'" + iStr + "'>" + iStr + "</option>";
            }
        }

        return html;
    }

    setColorHints() { let me = this.icn3dui; me.icn3d;
        let html = '';

        html += me.htmlCls.divNowrapStr + '<span style="margin-left:33px; color:#00FF00; font-weight:bold">Green</span>: H-Bonds; ';
        html += '<span style="color:#00FFFF; font-weight:bold">Cyan</span>: Salt Bridge/Ionic; ';
        html += '<span style="font-weight:bold">Grey</span>: Contacts</div>';
        html += me.htmlCls.divNowrapStr + '<span style="margin-left:33px; color:#FF00FF; font-weight:bold">Magenta</span>: Halogen Bonds; ';
        html += '<span style="color:#FF0000; font-weight:bold">Red</span>: &pi;-Cation; ';
        html += '<span style="color:#0000FF; font-weight:bold">Blue</span>: &pi;-Stacking</div>';

        return html;
    }

    setThicknessHtml(type) { let me = this.icn3dui, ic = me.icn3d;
        let html = '';

        // type == '3dprint' or 'style'
        let linerad =(type == '3dprint') ? '1' : '0.1';
        let coilrad =(type == '3dprint') ? '1.2' : '0.3';
        let stickrad =(type == '3dprint') ? '0.8' : '0.4';
        let crosslinkrad =(type == '3dprint') ? '0.8' : '0.4';
        let tracerad =(type == '3dprint') ? '1' : '0.4';
        let ballscale =(type == '3dprint') ? '0.6' : '0.3';
        let ribbonthick =(type == '3dprint') ? '1' : '0.2';
        let prtribbonwidth =(type == '3dprint') ? '2' : '1.3';
        let nucleotideribbonwidth =(type == '3dprint') ? '1.4' : '0.8';

        let shininess = 40;
        let light1 = 0.8;
        let light2 = 0.4;
        let light3 = 0.2;
        let bGlycansCartoon = 0;
        let bMembrane = 1;
        let bCmdWindow = 0;

        // retrieve from cache
        if(type == 'style') {
            if(this.getCookie('shininess') != '') {
                shininess = parseFloat(this.getCookie('shininess'));
            }

            if(this.getCookie('light1') != '') {
                light1 = parseFloat(this.getCookie('light1'));
                light2 = parseFloat(this.getCookie('light2'));
                light3 = parseFloat(this.getCookie('light3'));
            }

            if(this.getCookie('lineRadius') != '') {
                linerad = parseFloat(this.getCookie('lineRadius'));
                coilrad = parseFloat(this.getCookie('coilWidth'));
                stickrad = parseFloat(this.getCookie('cylinderRadius'));
                let clrad = this.getCookie('crosslinkRadius');
                crosslinkrad = (!isNaN(clrad)) ? parseFloat(clrad) : ic.crosslinkRadius;
                tracerad = parseFloat(this.getCookie('traceRadius'));
                ballscale = parseFloat(this.getCookie('dotSphereScale'));
                ribbonthick = parseFloat(this.getCookie('ribbonthickness'));
                prtribbonwidth = parseFloat(this.getCookie('helixSheetWidth'));
                nucleotideribbonwidth = parseFloat(this.getCookie('nucleicAcidWidth'));
            }

            if(this.getCookie('glycan') != '') {
                bGlycansCartoon = parseFloat(this.getCookie('glycan'));
            }

            if(this.getCookie('membrane') != '') {
                bMembrane = parseFloat(this.getCookie('membrane'));
            }

            if(this.getCookie('cmdwindow') != '') {
                bCmdWindow = parseFloat(this.getCookie('cmdwindow'));
            }

            html += "<b>Note</b>: The following parameters will be saved in cache. You just need to set them once. <br><br>";

            html += "<b>1. Shininess</b>: " + me.htmlCls.inputTextStr + "id='" + me.pre + "shininess' value='" + shininess + "' size=4>" + me.htmlCls.space3 + "(for the shininess of the 3D objects, default 40)<br/><br/>";
            html += "<b>2. Three directional lights</b>: <br>";
            html += "<b>Key Light</b>: " + me.htmlCls.inputTextStr + "id='" + me.pre + "light1' value='" + light1 + "' size=4>" + me.htmlCls.space3 + "(for the light strength of the key light, default 0.8)<br/>";
            html += "<b>Fill Light</b>: " + me.htmlCls.inputTextStr + "id='" + me.pre + "light2' value='" + light2 + "' size=4>" + me.htmlCls.space3 + "(for the light strength of the fill light, default 0.4)<br/>";
            html += "<b>Back Light</b>: " + me.htmlCls.inputTextStr + "id='" + me.pre + "light3' value='" + light3 + "' size=4>" + me.htmlCls.space3 + "(for the light strength of the back light, default 0.2)<br/><br/>";
            html += "<b>3. Thickness</b>: <br>";
        }

        html += "<b>Line Radius</b>: " + me.htmlCls.inputTextStr + "id='" + me.pre + "linerad_" + type + "' value='" + linerad + "' size=4>" + me.htmlCls.space3 + "(for stabilizers, hydrogen bonds, distance lines, default 0.1)<br/>";
        html += "<b>Coil Radius</b>: " + me.htmlCls.inputTextStr + "id='" + me.pre + "coilrad_" + type + "' value='" + coilrad + "' size=4>" + me.htmlCls.space3 + "(for coils, default 0.3)<br/>";
        html += "<b>Stick Radius</b>: " + me.htmlCls.inputTextStr + "id='" + me.pre + "stickrad_" + type + "' value='" + stickrad + "' size=4>" + me.htmlCls.space3 + "(for sticks, default 0.4)<br/>";
        html += "<b>Cross-Linkage Radius</b>: " + me.htmlCls.inputTextStr + "id='" + me.pre + "crosslinkrad_" + type + "' value='" + crosslinkrad + "' size=4>" + me.htmlCls.space3 + "(for cross-linkages, default 0.4)<br/>";
        html += "<b>Trace Radius</b>: " + me.htmlCls.inputTextStr + "id='" + me.pre + "tracerad_" + type + "' value='" + tracerad + "' size=4>" + me.htmlCls.space3 + "(for C alpha trace, O3' trace, default 0.4)<br/>";

        html += "<b>Ribbon Thickness</b>: " + me.htmlCls.inputTextStr + "id='" + me.pre + "ribbonthick_" + type + "' value='" + ribbonthick + "' size=4>" + me.htmlCls.space3 + "(for helix and sheet ribbons, nucleotide ribbons, default 0.2)<br/>";
        html += "<b>Protein Ribbon Width</b>: " + me.htmlCls.inputTextStr + "id='" + me.pre + "prtribbonwidth_" + type + "' value='" + prtribbonwidth + "' size=4>" + me.htmlCls.space3 + "(for helix and sheet ribbons, default 1.3)<br/>";
        html += "<b>Nucleotide Ribbon Width</b>: " + me.htmlCls.inputTextStr + "id='" + me.pre + "nucleotideribbonwidth_" + type + "' value='" + nucleotideribbonwidth + "' size=4>" + me.htmlCls.space3 + "(for nucleotide ribbons, default 0.8)<br/>";

        html += "<b>Ball Scale</b>: " + me.htmlCls.inputTextStr + "id='" + me.pre + "ballscale_" + type + "' value='" + ballscale + "' size=4>" + me.htmlCls.space3 + "(for styles 'Ball and Stick' and 'Dot', default 0.3)<br/>";

        if(type == 'style') {
            html += "<br><b>4. Show Glycan Cartoon</b>: " + me.htmlCls.inputTextStr + "id='" + me.pre + "glycan' value='" + bGlycansCartoon + "' size=4>" + me.htmlCls.space3 + "(0: hide, 1: show, default 0)<br/>";

            html += "<br><b>5. Show Membrane</b>: " + me.htmlCls.inputTextStr + "id='" + me.pre + "membrane' value='" + bMembrane + "' size=4>" + me.htmlCls.space3 + "(0: hide, 1: show, default 1)<br/>";

            html += "<br><b>6. Enlarge Command Window</b>: " + me.htmlCls.inputTextStr + "id='" + me.pre + "cmdwindow' value='" + bCmdWindow + "' size=4>" + me.htmlCls.space3 + "(0: Regular, 1: Large, default 0)<br/><br/>";
        }

        html += me.htmlCls.spanNowrapStr + "" + me.htmlCls.buttonStr + "apply_thickness_" + type + "'>Apply</button></span>&nbsp;&nbsp;&nbsp;";

        html += me.htmlCls.spanNowrapStr + "" + me.htmlCls.buttonStr + "reset_thickness_" + type + "'>Reset</button></span>";

        return html;
    }

    getCookie(cname) {
      let name = cname + "=";
      let decodedCookie = decodeURIComponent(document.cookie);
      let ca = decodedCookie.split(';');
      for(let i = 0; i <ca.length; i++) {
        let c = ca[i];
        while (c.charAt(0) == ' ') {
          c = c.substring(1);
        }
        if (c.indexOf(name) == 0) {
          return c.substring(name.length, c.length);
        }
      }
      return "";
    }

    setSequenceGuide(suffix, bShown) { let me = this.icn3dui, ic = me.icn3d;
      let sequencesHtml = '';

      let index =(ic && ic.defNames2Atoms) ? Object.keys(ic.defNames2Atoms).length : 1;

      if(bShown) {
         sequencesHtml += me.htmlCls.divStr + "seqguide" + suffix + "'>";
     }
     else {
         sequencesHtml += '<div style="width:20px; margin-left:3px; display:inline-block;"><span id="' + me.pre + 'seqguide' + suffix + '_expand" class="ui-icon ui-icon-plus icn3d-expand icn3d-link" style="width:15px;" title="Expand"></span><span id="' + me.pre + 'seqguide' + suffix + '_shrink" class="ui-icon ui-icon-minus icn3d-shrink icn3d-link" style="display:none; width:15px;" title="Shrink"></span></div> ';

         sequencesHtml += "<div style='min-width:200px; display:inline-block;'><b>Selection:</b> Name: " + me.htmlCls.inputTextStr + "id='" + me.pre + "seq_command_name" + suffix + "' value='seq_" + index + "' size='5'> " + me.htmlCls.space2 + "<button style='white-space:nowrap;' id='" + me.pre + "seq_saveselection" + suffix + "'>Save</button> <button style='white-space:nowrap; margin-left:20px;' id='" + me.pre + "seq_clearselection" + suffix + "'>Clear</button></div><br/>";

         sequencesHtml += me.htmlCls.divStr + "seqguide" + suffix + "' style='display:none; white-space:normal;' class='icn3d-box'>";
     }

      sequencesHtml += this.getSelectionHints();

      let resCategories = "<b>Residue labeling:</b> standard residue with coordinates: UPPER case letter; nonstandard residue with coordinates: the first UPPER case letter plus a period except that water residue uses the letter 'O'; residue missing coordinates: lower case letter.";
      let scroll =(me.utilsCls.isMac() && !me.utilsCls.isMobile()) ? "<br/><br/><b>Turn on scroll bar:</b> System preferences -> General -> show scroll bars -> check Always" : "";

      sequencesHtml += resCategories + scroll + "<br/></div>";

      return sequencesHtml;
    }

    setAlignSequenceGuide(suffix, bShown) { let me = this.icn3dui, ic = me.icn3d;
      let sequencesHtml = '';
      suffix = '';

      let index =(ic && ic.defNames2Atoms) ? Object.keys(ic.defNames2Atoms).length : 1;

      sequencesHtml += '<div style="width:20px; margin-left:3px; display:inline-block;"><span id="' + me.pre + 'alignseqguide' + suffix + '_expand" class="ui-icon ui-icon-plus icn3d-expand icn3d-link" style="width:15px;" title="Expand"></span><span id="' + me.pre + 'alignseqguide' + suffix + '_shrink" class="ui-icon ui-icon-minus icn3d-shrink icn3d-link" style="display:none; width:15px;" title="Shrink"></span></div> ';

      sequencesHtml += "<div style='min-width:200px; display:inline-block;''><b>Selection:</b> Name: " + me.htmlCls.inputTextStr + "id='" + me.pre + "alignseq_command_name' value='alseq_" + index + "' size='10'> " + me.htmlCls.space2 + "<button style='white-space:nowrap;' id='" + me.pre + "alignseq_saveselection'>Save</button> <button style='white-space:nowrap; margin-left:20px;' id='" + me.pre + "alignseq_clearselection'>Clear</button></div><br/>";

      sequencesHtml += me.htmlCls.divStr + "alignseqguide" + suffix + "' style='display:none; white-space:normal;' class='icn3d-box'>";

      sequencesHtml += this.getSelectionHints();

      let resCategories = "<b>Residue labeling:</b> aligned residue with coordinates: UPPER case letter; non-aligned residue with coordinates: lower case letter which can be highlighted; residue missing coordinates: lower case letter which can NOT be highlighted.";
      let scroll =(me.utilsCls.isMac() && !me.utilsCls.isMobile()) ? "<br/><br/><b>Turn on scroll bar:</b> System preferences -> General -> show scroll bars -> check Always" : "";

      sequencesHtml += resCategories + scroll + "<br/></div>";

      return sequencesHtml;
    }

    getSelectionHints() { let me = this.icn3dui; me.icn3d;
      let sequencesHtml = '';

      if(!me.utilsCls.isMobile()) {
          sequencesHtml += "<b>Select on 1D sequences:</b> drag to select, drag again to deselect, multiple selection is allowed without Ctrl key, click \"Save Selection\" to save the current selection.<br/><br/>";

          sequencesHtml += "<b>Select on 2D interaction diagram:</b> click on the nodes or lines. The nodes are chains and can be united with the Ctrl key. The lines are interactions and can NOT be united. Each click on the lines selects half of the lines, i.e., select the interacting residues in one of the two chains.<br/><br/>";

          let tmpStr = me.utilsCls.isMobile() ? 'use finger to pick' : 'hold "Alt" and use mouse to pick';
          sequencesHtml += "<b>Select on 3D structures:</b> " + tmpStr + ", click the second time to deselect, hold \"Ctrl\" to union selection, hold \"Shift\" to select a range, press the up/down arrow to switch among atom/residue/strand/chain/structure, click \"Save Selection\" to save the current selection.<br/><br/>";

          sequencesHtml += "<b>Save the current selection</b>(either on 3D structure, 2D interactions, or 1D sequence): open the menu \"Select -> Save Selection\", specify the name and description for the selection, and click \"Save\".<br/><br/>";
      }
      else {
            sequencesHtml += "<b>Select Aligned Sequences:</b> touch to select, touch again to deselect, multiple selection is allowed without Ctrl key, click \"Save Selection\" to save the current selection.<br/>";
      }

      return sequencesHtml;
    }

    addGsizeSalt(name) { let me = this.icn3dui; me.icn3d;
        let html = "";

        html += "<span style='white-space:nowrap;font-weight:bold;'>Grid Size: <select id='" + me.pre + name + "gsize'>";

        let optArray1c = ['65', '97', '129'];
        html += this.getOptionHtml(optArray1c, 0);

        html += "</select></span>";

        html += "<span style='white-space:nowrap;font-weight:bold;margin-left:30px;'>Salt Concentration: <select id='" + me.pre + name + "salt'>";

        let optArray1d = ['0', '0.15'];
        html += this.getOptionHtml(optArray1d, 1);

        html += "</select> M</span><br/>";

        return html;
    }

    getFootHtml(type, tabName) { let me = this.icn3dui; me.icn3d;
        let footHtml = "<div style='width:500px;'>";

        if(type == 'delphi') {
            if(me.cfg.cid) {
                footHtml += "<b>Note</b>: Partial charges(MMFF94) are from PubChem Compound SDF files.<br/><br/>";
            }
            else {
                footHtml += "<b>Note</b>: Only the selected residues are used for <a href='http://honig.c2b2.columbia.edu/delphi'>DelPhi</a> potential calculation by solving linear Poisson-Boltzmann equation.";

                footHtml += '<div style="width:20px; margin-top:6px; display:inline-block;"><span id="'
                  + me.pre + tabName + '_expand" class="ui-icon ui-icon-plus icn3d-expand icn3d-link" style="width:15px;" title="Expand"></span><span id="'
                  + me.pre + tabName + '_shrink" class="ui-icon ui-icon-minus icn3d-shrink icn3d-link" style="display:none; width:15px;" title="Shrink"></span></div><br>';
                footHtml += me.htmlCls.divStr + tabName + "' style='display:none;'>";

                footHtml += "<br>The hydrogens and partial charges of proteins and nucleotides are added using <a href='http://compbio.clemson.edu/pka_webserver'>DelPhiPKa</a> with the Amber charge and size files. The hydrogens of ligands are added using <a href='http://openbabel.org/wiki/Main_Page'>Open Babel</a>. The partial charges of ligands are calculated using <a href='http://ambermd.org/antechamber/ac.html'>Antechamber</a> with the Gasteiger charge method. All partial charges are calculated at pH 7.<br/><br/>";

                footHtml += "Lipids are treated as ligands. Please use \"HETATM\" instead of \"ATOM  \" for each lipid atom in your PDB file. Each phosphate in lipids is assigned with a charge of -1. You can download PQR and modify it, or prepare your PQR file using other tools. Then load the PQR file at the menu \"Analysis > Load PQR/Potential\".<br/><br/>";

                footHtml += "</div>";
            }
        }
        else {
            footHtml += "<b>Note</b>: Always load a PDB file before loading a PQR or DelPhi potential file.";

            footHtml += '<div style="width:20px; margin-top:6px; display:inline-block;"><span id="'
              + me.pre + tabName + '_expand" class="ui-icon ui-icon-plus icn3d-expand icn3d-link" style="width:15px;" title="Expand"></span><span id="'
              + me.pre + tabName + '_shrink" class="ui-icon ui-icon-minus icn3d-shrink icn3d-link" style="display:none; width:15px;" title="Shrink"></span></div><br>';
            footHtml += me.htmlCls.divStr + tabName + "' style='display:none;'>";

            footHtml += "The PDB file can be loaded in the URL with \"pdbid=\" or at \"File > Open File\". The PQR file can be prepared at the menu \"Analysis > Download PQR\" with your modification or using other tools. The DelPhi potential file can be calculated at <a href='http://compbio.clemson.edu/sapp/delphi_webserver/'>DelPhi Web Server</a> and be exported as a Cube file. ";

            if(type == 'url') footHtml += "The PQR or potential file can be accessed in a URL if it is located in the same host as iCn3D.";

            footHtml += "<br/><br/>";

            footHtml += "</div>";
        }
        footHtml += "</div>";

        return footHtml;
    }

    getPotentialHtml(type, dialogClass) { let me = this.icn3dui; me.icn3d;
        let html = '';

        let name0, name1, name2;
        let tab1, tab2;
        tab1 = 'Equipotential Map';
        tab2 = 'Surface with Potential';
        //tab3 = 'Download PQR';

        if(type == 'delphi') {
            name1 = 'delphi';
        }
        else if(type == 'local') {
            name0 = 'pqr';
            name1 = 'phi';
            name2 = 'cube';
        }
        else if(type == 'url') {
            name0 = 'pqrurl';
            name1 = 'phiurl';
            name2 = 'cubeurl';
        }

        html += me.htmlCls.divStr + "dl_" + name1 + "' class='" + dialogClass + "'>";
        html += me.htmlCls.setDialogCls.addNotebookTitle("dl_" + name1, 'DelPhi Potential');
        
        html += me.htmlCls.divStr + "dl_" + name1 + "_tabs' style='border:0px;'>";
        html += "<ul>";
        html += "<li><a href='#" + me.pre + name1 + "tab1'>" + tab1 + "</a></li>";
        html += "<li><a href='#" + me.pre + name1 + "tab2'>" + tab2 + "</a></li>";
        //html += "<li><a href='#" + me.pre + name1 + "tab3'>" + tab3 + "</a></li>";
        html += "</ul>";

        html += me.htmlCls.divStr + name1 + "tab1'>";
        if(type == 'delphi') html += this.addGsizeSalt(name1 + "1") + "<br>";

        html += "<span style='white-space:nowrap;font-weight:bold;'>Potential contour at: <select id='" + me.pre + name1 + "contour'>";

        let optArray1b = ['0.5', '1', '2', '3', '4', '5', '6', '7', '8', '9', '10'];
        html += this.getOptionHtml(optArray1b, 2);

        html += "</select> kT/e(25.6mV at 298K)</span><br/><br/>";

        let htmlTmp;

        // tab1: equipotential map
        if(type == 'delphi') {
            html += me.htmlCls.buttonStr + "reload_" + name1 + "file' style='margin-top: 6px;'>Equipotential Map</button>";
            html += me.htmlCls.buttonStr + name1 + "mapNo' style='margin-left:30px;'>Remove Map</button><br>";
        }
        else if(type == 'local') {
            html += me.htmlCls.divStr + name1 + "tab1_tabs' style='border:0px;'>";
            html += "<ul>";
            html += "<li><a href='#" + me.pre + name1 + "tab1_" + name0 + "'>PQR</a></li>";
            html += "<li><a href='#" + me.pre + name1 + "tab1_" + name1 + "'>Phi</a></li>";
            html += "<li><a href='#" + me.pre + name1 + "tab1_" + name2 + "'>Cube</a></li>";
            html += "</ul>";

            htmlTmp = "<span style='margin-left:30px'>" + me.htmlCls.buttonStr + name1 + "mapNo'>Remove Map</button></span></div>";

            html += me.htmlCls.divStr + name1 + "tab1_" + name0 + "'>";
            html += this.addGsizeSalt(name0) + "<br>";
            html += "<b>PQR File</b>: " + me.htmlCls.inputFileStr + "id='" + me.pre + name0 + "file'> <br><br>" + me.htmlCls.buttonStr + "reload_" + name0 + "file' style='margin-top: 6px;'>Equipotential Map</button>" + htmlTmp;

            html += me.htmlCls.divStr + name1 + "tab1_" + name1 + "'>";
            html += "<b>Phi File</b>: " + me.htmlCls.inputFileStr + "id='" + me.pre + name1 + "file'> <br><br>" + me.htmlCls.buttonStr + "reload_" + name1 + "file' style='margin-top: 6px;'>Equipotential Map</button>" + htmlTmp;

            html += me.htmlCls.divStr + name1 + "tab1_" + name2 + "'>";
            html += "<b>Cube File</b>: " + me.htmlCls.inputFileStr + "id='" + me.pre + name2 + "file'> <br><br>" + me.htmlCls.buttonStr + "reload_" + name2 + "file' style='margin-top: 6px;'>Equipotential Map</button>" + htmlTmp;

            html += "</div>";
        }
        else if(type == 'url') {
            html += me.htmlCls.divStr + name1 + "tab1_tabs' style='border:0px;'>";
            html += "<ul>";
            html += "<li><a href='#" + me.pre + name1 + "tab1_" + name0 + "2'>PQR</a></li>";
            html += "<li><a href='#" + me.pre + name1 + "tab1_" + name1 + "2'>Phi</a></li>";
            html += "<li><a href='#" + me.pre + name1 + "tab1_" + name2 + "2'>Cube</a></li>";
            html += "</ul>";

            htmlTmp = "<span style='margin-left:30px'>" + me.htmlCls.buttonStr + name1 + "mapNo'>Remove Map</button></span></div>";

            html += me.htmlCls.divStr + name1 + "tab1_" + name0 + "2'>";
            html += this.addGsizeSalt(name0) + "<br>";
            html += "<b>PQR URL</b> in the same host: " + me.htmlCls.inputTextStr + "id='" + me.pre + name0 + "file'> <br><br>" + me.htmlCls.buttonStr + "reload_" + name0 + "file' style='margin-top: 6px;'>Equipotential Map</button>" + htmlTmp;

            html += me.htmlCls.divStr + name1 + "tab1_" + name1 + "2'>";
            html += "<b>Phi URL</b> in the same host: " + me.htmlCls.inputTextStr + "id='" + me.pre + name1 + "file'> <br><br>" + me.htmlCls.buttonStr + "reload_" + name1 + "file' style='margin-top: 6px;'>Equipotential Map</button>" + htmlTmp;

            html += me.htmlCls.divStr + name1 + "tab1_" + name2 + "2'>";
            html += "<b>Cube URL</b> in the same host: " + me.htmlCls.inputTextStr + "id='" + me.pre + name2 + "file'> <br><br>" + me.htmlCls.buttonStr + "reload_" + name2 + "file' style='margin-top: 6px;'>Equipotential Map</button>" + htmlTmp;

            html += "</div>";
        }

        html += "<br>" + this.getFootHtml(type, name1 + "tab1_foot");
        html += "</div>";

        html += me.htmlCls.divStr + name1 + "tab2'>";
        if(type == 'delphi') html += this.addGsizeSalt(name1 + "2") + "<br>";

        html += "<span style='white-space:nowrap;font-weight:bold;'>Surface with max potential at: <select id='" + me.pre + name1 + "contour2'>";

        let optArray1c = ['0.5', '1', '2', '3', '4', '5', '6', '7', '8', '9', '10'];
        html += this.getOptionHtml(optArray1c, 2);

        html += "</select> kT/e(25.6mV at 298K)</span><br/><br/>";

        html += "<b>Surface</b>: <select id='" + me.pre + name1 + "surftype'>";
        html += "<option value='21'>Van der Waals</option>";
        html += "<option value='22' selected>Molecular Surface</option>";
        html += "<option value='23'>Solvent Accessible</option>";
        html += "</select>";

        html += "<span style='margin-left:20px'><b>Opacity</b>: <select id='" + me.pre + name1 + "surfop'>";
        let surfOp = ['1.0', '0.9', '0.8', '0.7', '0.6', '0.5', '0.4', '0.3', '0.2', '0.1'];
        html += this.getOptionHtml(surfOp, 0);
        html += "</select></span>";

        html += "<span style='margin-left:20px'><b>Wireframe</b>: <select id='" + me.pre + name1 + "surfwf'>";
        html += "<option value='yes'>Yes</option>";
        html += "<option value='no' selected>No</option>";
        html += "</select></span><br/>";

        html += "<br/>";

        // tab2: surface with potential
        if(type == 'delphi') {
            html += me.htmlCls.buttonStr + "reload_" + name1 + "file2' style='margin-top: 6px;'>Surface with Potential</button>";
            html += me.htmlCls.buttonStr + name1 + "mapNo2' style='margin-left:30px;'>Remove Surface</button><br>";
        }
        else if(type == 'local') {
            html += me.htmlCls.divStr + name1 + "tab2_tabs' style='border:0px;'>";
            html += "<ul>";
            html += "<li><a href='#" + me.pre + name1 + "tab2_" + name0 + "'>PQR</a></li>";
            html += "<li><a href='#" + me.pre + name1 + "tab2_" + name1 + "'>Phi</a></li>";
            html += "<li><a href='#" + me.pre + name1 + "tab2_" + name2 + "'>Cube</a></li>";
            html += "</ul>";

            htmlTmp = "<span style='margin-left:30px'>" + me.htmlCls.buttonStr + name1 + "mapNo2'>Remove Surface</button></span></div>";

            html += me.htmlCls.divStr + name1 + "tab2_" + name0 + "'>";
            html += this.addGsizeSalt(name0 + "2") + "<br>";
            html += "<b>PQR File</b>: " + me.htmlCls.inputFileStr + "id='" + me.pre + name0 + "file2'> <br><br>" + me.htmlCls.buttonStr + "reload_" + name0 + "file2' style='margin-top: 6px;'>Surface with Potential</button>" + htmlTmp;

            html += me.htmlCls.divStr + name1 + "tab2_" + name1 + "'>";
            html += "<b>Phi File</b>: " + me.htmlCls.inputFileStr + "id='" + me.pre + name1 + "file2'> <br><br>" + me.htmlCls.buttonStr + "reload_" + name1 + "file2' style='margin-top: 6px;'>Surface with Potential</button>" + htmlTmp;

            html += me.htmlCls.divStr + name1 + "tab2_" + name2 + "'>";
            html += "<b>Cube File</b>: " + me.htmlCls.inputFileStr + "id='" + me.pre + name2 + "file2'> <br><br>" + me.htmlCls.buttonStr + "reload_" + name2 + "file2' style='margin-top: 6px;'>Surface with Potential</button>" + htmlTmp;

            html += "</div>";
        }
        else if(type == 'url') {
            html += me.htmlCls.divStr + name1 + "tab2_tabs' style='border:0px;'>";
            html += "<ul>";
            html += "<li><a href='#" + me.pre + name1 + "tab2_" + name0 + "2'>PQR</a></li>";
            html += "<li><a href='#" + me.pre + name1 + "tab2_" + name1 + "2'>Phi</a></li>";
            html += "<li><a href='#" + me.pre + name1 + "tab2_" + name2 + "2'>Cube</a></li>";
            html += "</ul>";

            htmlTmp = "<span style='margin-left:30px'>" + me.htmlCls.buttonStr + name1 + "mapNo2'>Remove Surface</button></span></div>";

            html += me.htmlCls.divStr + name1 + "tab2_" + name0 + "2'>";
            html += this.addGsizeSalt(name0 + "2") + "<br>";
            html += "<b>PQR URL</b> in the same host: " + me.htmlCls.inputTextStr + "id='" + me.pre + name0 + "file2'> <br><br>" + me.htmlCls.buttonStr + "reload_" + name0 + "file2' style='margin-top: 6px;'>Surface with Potential</button>" + htmlTmp;

            html += me.htmlCls.divStr + name1 + "tab2_" + name1 + "2'>";
            html += "<b>Phi URL</b> in the same host: " + me.htmlCls.inputTextStr + "id='" + me.pre + name1 + "file2'> <br><br>" + me.htmlCls.buttonStr + "reload_" + name1 + "file2' style='margin-top: 6px;'>Surface with Potential</button>" + htmlTmp;

            html += me.htmlCls.divStr + name1 + "tab2_" + name2 + "2'>";
            html += "<b>Cube URL</b> in the same host: " + me.htmlCls.inputTextStr + "id='" + me.pre + name2 + "file2'> <br><br>" + me.htmlCls.buttonStr + "reload_" + name2 + "file2' style='margin-top: 6px;'>Surface with Potential</button>" + htmlTmp;

            html += "</div>";
        }

        html += "<br>" + this.getFootHtml(type, name1 + "tab2_foot");
        html += "</div>";

        html += "</div>";
        html += "</div>";

        return html;
    }

    async exportPqr(bPdb) { let me = this.icn3dui, ic = me.icn3d;
       let ionHash = {};
       let atomHash = {};

       let atoms = me.hashUtilsCls.intHash(ic.dAtoms, ic.hAtoms);
       for(let i in atoms) {
           ic.atoms[i];

           if(ic.ions.hasOwnProperty(i)) {
             ionHash[i] = 1;
           }
           else {
             atomHash[i] = 1;
           }
       }

       let fileExt = (bPdb) ? 'pdb' : 'pqr';
       if(me.cfg.cid) {
          let pqrStr = '';
          
          let bPqr = (bPdb) ? false : true;
          pqrStr += ic.saveFileCls.getAtomPDB(atomHash, bPqr) + ic.saveFileCls.getAtomPDB(ionHash, bPqr);

          let file_pref = Object.keys(me.utilsCls.getHlStructures()).join(',');
          ic.saveFileCls.saveFile(file_pref + '_icn3d.' + fileExt, 'text', [pqrStr]);
       }
       else {
            let bCalphaOnly = me.utilsCls.isCalphaPhosOnly(me.hashUtilsCls.hash2Atoms(atomHash, ic.atoms));
            if(bCalphaOnly) {
                alert("The potential will not be shown because the side chains are missing in the structure...");
                return;
            }

            let pdbstr = '';

            let bMergeIntoOne = true;
            pdbstr += ic.saveFileCls.getAtomPDB(atomHash, undefined, undefined, undefined, undefined, undefined, bMergeIntoOne);
            pdbstr += ic.saveFileCls.getAtomPDB(ionHash, true, undefined, true);

            let url = me.htmlCls.baseUrl + "delphi/delphi.cgi";

            let pdbid =(me.cfg.cid) ? me.cfg.cid : Object.keys(ic.structures).toString();

            let dataObj = {'pdb2pqr': pdbstr, 'pdbid': pdbid};
            let data = await me.getAjaxPostPromise(url, dataObj, true, undefined, undefined, true, 'text');

            let pqrStr = data;

            if(bPdb) {
            let lineArray = pqrStr.split('\n');

            let pdbStr = '';
            for(let i = 0, il = lineArray.length; i < il; ++i) {
                let line = lineArray[i];
                if(line.substr(0, 6) == 'ATOM  ' || line.substr(0, 6) == 'HETATM') {
                    let atomName = line.substr(12, 4).trim();
                    let elem;
                    if(line.substr(0, 6) == 'ATOM  ') {
                        elem = atomName.substr(0, 1);
                    }
                    else {
                        let twochar = atomName.substr(0, 2);
                        if(me.parasCls.vdwRadii.hasOwnProperty(twochar)) {
                            elem = twochar;
                        }
                        else {
                            elem = atomName.substr(0, 1);
                        }
                    }

                    pdbStr += line.substr(0, 54) + '                      ' + elem.padStart(2, ' ') + '\n';
                }
                else {
                    pdbStr += line + '\n';
                }
            }

            pqrStr = pdbStr;
            }

            let file_pref = Object.keys(me.utilsCls.getHlStructures()).join(',');
            ic.saveFileCls.saveFile(file_pref + '_icn3d_residues.' + fileExt, 'text', [pqrStr]);
        }
    }

    clickReload_pngimage() { let me = this.icn3dui; me.icn3d;
        if(me.bNode) return;

        let thisClass = this;
        me.myEventCls.onIds("#" + me.pre + "reload_pngimage", "click", async function(e) { let ic = me.icn3d;
           e.preventDefault();
           if(!me.cfg.notebook) dialog.dialog( "close" );
           //close all dialog
           if(!me.cfg.notebook) {
               $(".ui-dialog-content").dialog("close");
           }
           else {
               ic.resizeCanvasCls.closeDialogs();
           }

        //    ic.init();
           let files = $("#" + me.pre + "pngimage")[0].files;
           if(!files[0]) {
             alert("Please select a file before clicking 'Load'");
           }
           else {
             thisClass.fileSupport();

             let bAppend = true;
             let bmmCIF = false;
             let bPng = true;
             await me.htmlCls.eventsCls.readFile(bAppend, files, 0, '', bmmCIF, bPng);
           }
        });
    }

    async loadPng(imageStr, command, bRender) { let me = this.icn3dui, ic = me.icn3d;
    // async loadPng(imageStr) { let me = this.icn3dui, ic = me.icn3d;
       let matchedStr = 'Share Link: ';
       let pos = imageStr.indexOf(matchedStr);
       let matchedStrState = "Start of state file======\n";
       let posState = imageStr.indexOf(matchedStrState);

       let data = '', statefile = '';

       if(pos == -1 && posState == -1) {
           alert('Please load a PNG image saved by clicking the menu "File > Save File > iCn3D PNG Image"...');
       }
       else if(pos != -1) {
           let url = imageStr.substr(pos + matchedStr.length);
           me.htmlCls.clickMenuCls.setLogCmd('load iCn3D PNG image ' + $("#" + me.pre + "pngimage").val(), false);
           window.open(url, '_self');
       }
       else if(posState != -1) {
           let matchedStrData = "Start of data file======\n";
           let posData = imageStr.indexOf(matchedStrData);
           ic.bInputfile =(posData == -1) ? false : true;
           ic.bInputPNGWithData = ic.bInputfile;
           let commandStr = (command) ? command.replace(/;/g, "\n") : '';
        //    let commandStr = '';

        //    let statefile;
        //    if(ic.bInputfile) {
               let posDataEnd = imageStr.indexOf("End of data file======\n");
               data = imageStr.substr(posData + matchedStrData.length, posDataEnd - posData - matchedStrData.length);
            //    ic.InputfileData = (ic.InputfileData) ? ic.InputfileData + '\nENDMDL\n' + data : data;

               let matchedStrType = "Start of type file======\n";
               let posType = imageStr.indexOf(matchedStrType);
               let posTypeEnd = imageStr.indexOf("End of type file======\n");
               let type = imageStr.substr(posType + matchedStrType.length, posTypeEnd - posType - matchedStrType.length - 1); // remove the new line char
               ic.InputfileType = type;

               //var matchedStrState = "Start of state file======\n";
               //var posState = imageStr.indexOf(matchedStrState);
               let posStateEnd = imageStr.indexOf("End of state file======\n");
               statefile = imageStr.substr(posState + matchedStrState.length, posStateEnd - posState- matchedStrState.length);
               //statefile = decodeURIComponent(statefile);
               statefile = decodeURIComponent(statefile + "\n" + commandStr);

               if(bRender) {
                    if(type === 'pdb') {
                        await ic.pdbParserCls.loadPdbData(data);

                        ic.commands = [];
                        ic.optsHistory = [];
                        //await ic.loadScriptCls.loadScript(statefile, true);
                    }
                    else {
                        if(type === 'mol2') {
                            await ic.mol2ParserCls.loadMol2Data(data);
                        }
                        else if(type === 'sdf') {
                            await ic.sdfParserCls.loadSdfData(data);
                        }
                        else if(type === 'xyz') {
                            await ic.xyzParserCls.loadXyzData(data);
                        }
                        else if(type === 'mmcif') {
                            await ic.mmcifParserCls.loadMmcifData(data);
                        }
                        ic.commands = [];
                        ic.optsHistory = [];
                        //await ic.loadScriptCls.loadScript(statefile, true);
                    }

                    await ic.loadScriptCls.loadScript(statefile, true);

                    // me.htmlCls.clickMenuCls.setLogCmd('load iCn3D PNG image ' + $("#" + me.pre + "pngimage").val(), false);
                }
/*                   
           }
           else { // url length > 4000
               //var matchedStrState = "Start of state file======\n";
               //var posState = imageStr.indexOf(matchedStrState);
               let posStateEnd = imageStr.indexOf("End of state file======\n");
               statefile = imageStr.substr(posState + matchedStrState.length, posStateEnd - posState- matchedStrState.length);
               //statefile = decodeURIComponent(statefile);
               statefile = decodeURIComponent(statefile + "\n" + commandStr);

               ic.commands = [];
               ic.optsHistory = [];
               //await  ic.loadScriptCls.loadScript(statefile, true);
           }

            await ic.loadScriptCls.loadScript(statefile, true);

           me.htmlCls.clickMenuCls.setLogCmd('load iCn3D PNG image ' + $("#" + me.pre + "pngimage").val(), false);
*/
       }

       return {'pdb': data, 'statefile': statefile};
    }

    fileSupport() {
         if(!window.File || !window.FileReader || !window.FileList || !window.Blob) {
            alert('The File APIs are not fully supported in this browser.');
         }
    }

    getLinkColor() {
        let graphStr2 = '';
        graphStr2 += ', linkmap: {\n';
        graphStr2 += '3: {"type": "peptidebond", "c":""},\n';
        graphStr2 += '4: {"type": "ssbond", "c":"FFA500"},\n';
        graphStr2 += '5: {"type": "ionic", "c":"0FF"},\n';
        graphStr2 += '6: {"type": "ionicInside", "c":"FFF"},\n';
        graphStr2 += '11: {"type": "contact", "c":"888"},\n';
        graphStr2 += '12: {"type": "contactInside", "c":"FFF"},\n';
        graphStr2 += '13: {"type": "hbond", "c":"0F0"},\n';
        graphStr2 += '14: {"type": "hbondInside", "c":"FFF"},\n';
        graphStr2 += '15: {"type": "clbond", "c":"006400"},\n';
        graphStr2 += '17: {"type": "halogen", "c":"F0F"},\n';
        graphStr2 += '18: {"type": "halogenInside", "c":"FFF"},\n';
        graphStr2 += '19: {"type": "pication", "c":"F00"},\n';
        graphStr2 += '20: {"type": "picationInside", "c":"FFF"},\n';
        graphStr2 += '21: {"type": "pistacking", "c":"00F"},\n';
        graphStr2 += '22: {"type": "pistackingInside", "c":"FFF"}\n';
        graphStr2 += '}}\n';

        return graphStr2;
    }

    setCookieForThickness() { let me = this.icn3dui, ic = me.icn3d;
        if(!me.bNode) { // && postfix == 'style') {
            let exdays = 3650; // 10 years

            this.setCookie('lineRadius', ic.lineRadius, exdays);
            this.setCookie('coilWidth', ic.coilWidth, exdays);
            this.setCookie('cylinderRadius', ic.cylinderRadius, exdays);
            this.setCookie('crosslinkRadius', ic.crosslinkRadius, exdays);
            this.setCookie('traceRadius', ic.traceRadius, exdays);
            this.setCookie('dotSphereScale', ic.dotSphereScale, exdays);
            this.setCookie('ribbonthickness', ic.ribbonthickness, exdays);
            this.setCookie('helixSheetWidth', ic.helixSheetWidth, exdays);
            this.setCookie('nucleicAcidWidth', ic.nucleicAcidWidth, exdays);
        }
    }

    setLineThickness(postfix, bReset) { let me = this.icn3dui, ic = me.icn3d;
        ic.bSetThickness = true;

        if(postfix == 'style') {
            if(bReset) {
                $("#" + me.pre + "shininess").val('40');
                $("#" + me.pre + "light1").val('0.8');
                $("#" + me.pre + "light2").val('0.4');
                $("#" + me.pre + "light3").val('0.2');
                $("#" + me.pre + "glycan").val('0');
                $("#" + me.pre + "membrane").val('1');
                $("#" + me.pre + "cmdwindow").val('0');
            }

            ic.shininess = parseFloat($("#" + me.pre + "shininess").val()); //40;
            ic.light1 = parseFloat($("#" + me.pre + "light1").val()); //0.6;
            ic.light2 = parseFloat($("#" + me.pre + "light2").val()); //0.4;
            ic.light3 = parseFloat($("#" + me.pre + "light3").val()); //0.2;
            ic.bGlycansCartoon = parseInt($("#" + me.pre + "glycan").val()); //0;
            ic.bMembrane = parseInt($("#" + me.pre + "membrane").val()); //1;
            ic.bCmdWindow = parseInt($("#" + me.pre + "cmdwindow").val()); //0;
        }

        if(bReset) {
            $("#" + me.pre + "linerad_" + postfix ).val(0.1); //0.1; // hbonds, distance lines
            $("#" + me.pre + "coilrad_" + postfix ).val(0.3); //0.3; // style cartoon-coil
            $("#" + me.pre + "stickrad_" + postfix ).val(0.4); //0.4; // style stick
            $("#" + me.pre + "crosslinkrad_" + postfix ).val(0.4); //0.4; // cross-linkage
            $("#" + me.pre + "tracerad_" + postfix ).val(0.4); //0.4; // style c alpha trace, nucleotide stick
            $("#" + me.pre + "ballscale_" + postfix ).val(0.3); //0.3; // style ball and stick, dot
            $("#" + me.pre + "ribbonthick_" + postfix ).val(0.2); //0.2; // style ribbon, nucleotide cartoon, stand thickness
            $("#" + me.pre + "prtribbonwidth_" + postfix ).val(1.3); //1.3; // style ribbon, stand thickness
            $("#" + me.pre + "nucleotideribbonwidth_" + postfix ).val(0.8); //0.8; // nucleotide cartoon
        }

        ic.lineRadius = parseFloat($("#" + me.pre + "linerad_" + postfix ).val()); //0.1; // hbonds, distance lines
        ic.coilWidth = parseFloat($("#" + me.pre + "coilrad_" + postfix ).val()); //0.4; // style cartoon-coil
        ic.cylinderRadius = parseFloat($("#" + me.pre + "stickrad_" + postfix ).val()); //0.4; // style stick
        ic.crosslinkRadius = parseFloat($("#" + me.pre + "crosslinkrad_" + postfix ).val()); //0.4; // cross-linkage
        ic.traceRadius = parseFloat($("#" + me.pre + "tracerad_" + postfix ).val()); //0.4; // style c alpha trace, nucleotide stick
        ic.dotSphereScale = parseFloat($("#" + me.pre + "ballscale_" + postfix ).val()); //0.3; // style ball and stick, dot
        ic.ribbonthickness = parseFloat($("#" + me.pre + "ribbonthick_" + postfix ).val()); //0.4; // style ribbon, nucleotide cartoon, stand thickness
        ic.helixSheetWidth = parseFloat($("#" + me.pre + "prtribbonwidth_" + postfix ).val()); //1.3; // style ribbon, stand thickness
        ic.nucleicAcidWidth = parseFloat($("#" + me.pre + "nucleotideribbonwidth_" + postfix ).val()); //0.8; // nucleotide cartoon

        // save to cache
        if(!me.bNode) { // && postfix == 'style') {
            let exdays = 3650; // 10 years
            this.setCookie('shininess', ic.shininess, exdays);
            this.setCookie('light1', ic.light1, exdays);
            this.setCookie('light2', ic.light2, exdays);
            this.setCookie('light3', ic.light3, exdays);
            this.setCookie('glycan', ic.bGlycansCartoon, exdays);
            this.setCookie('membrane', ic.bMembrane, exdays);
            this.setCookie('cmdwindow', ic.bCmdWindow, exdays);
        }

        this.setCookieForThickness();

        if(postfix = bReset) {
           let select = "reset thickness";
           me.htmlCls.clickMenuCls.setLogCmd(select, true);
           ic.bSetThickness = false;
           ic.threeDPrintCls.resetAfter3Dprint();
        }
        else {
            me.htmlCls.clickMenuCls.setLogCmd('set thickness | linerad ' + ic.lineRadius + ' | coilrad ' + ic.coilWidth + ' | stickrad ' + ic.cylinderRadius + ' | crosslinkrad ' + ic.crosslinkRadius + ' | tracerad ' + ic.traceRadius + ' | ribbonthick ' + ic.ribbonthickness + ' | proteinwidth ' + ic.helixSheetWidth + ' | nucleotidewidth ' + ic.nucleicAcidWidth  + ' | ballscale ' + ic.dotSphereScale, true);

            me.htmlCls.clickMenuCls.setLogCmd('set glycan ' + ic.bGlycansCartoon, true);
            me.htmlCls.clickMenuCls.setLogCmd('set membrane ' + ic.bMembrane, true);
            me.htmlCls.clickMenuCls.setLogCmd('set cmdwindow ' + ic.bCmdWindow, true);
        }

        ic.drawCls.draw();
    }

    setCookie(cname, cvalue, exdays) {
      let d = new Date();
      d.setTime(d.getTime() + (exdays*24*60*60*1000));
      let expires = "expires="+ d.toUTCString();
      document.cookie = cname + "=" + cvalue + ";" + expires + ";path=/";
    }

    updateSurfPara(type) { let me = this.icn3dui, ic = me.icn3d;
       ic.phisurftype = $("#" + me.pre + type + "surftype").val();
       ic.phisurfop = $("#" + me.pre + type + "surfop").val();
       ic.phisurfwf = $("#" + me.pre + type + "surfwf").val();
    }

    exportPdb() { let me = this.icn3dui, ic = me.icn3d;
        let pdbStr = '';
    ///       pdbStr += ic.saveFileCls.getPDBHeader();
        let atoms = me.hashUtilsCls.intHash(ic.dAtoms, ic.hAtoms);
        pdbStr += ic.saveFileCls.getAtomPDB(atoms);

        if(!me.bNode) {
            let file_pref = Object.keys(me.utilsCls.getHlStructures()).join(',');
            ic.saveFileCls.saveFile(file_pref + '_icn3d.pdb', 'text', [pdbStr]);
        }
        
        return pdbStr;
    }

    exportSecondary() { let me = this.icn3dui, ic = me.icn3d;
        let secondaryStr = '';
        let atoms = me.hashUtilsCls.intHash(ic.dAtoms, ic.hAtoms);
        secondaryStr += ic.saveFileCls.getSecondary(atoms);

        if(!me.bNode) {
            let file_pref = Object.keys(me.utilsCls.getHlStructures()).join(',');
            ic.saveFileCls.saveFile(file_pref + '_icn3d_ss.txt', 'text', [secondaryStr]);
        }
        
        return secondaryStr;
    }
}

/**
 * @author Jiyao Wang <wangjiy@ncbi.nlm.nih.gov> / https://github.com/ncbi/icn3d
 */

class Html {
  constructor(icn3dui) { let me = icn3dui;
    this.icn3dui = icn3dui;

    this.cfg = this.icn3dui.cfg;

    this.opts = {};
    this.opts['background']         = 'black';        //transparent, black, grey, white

    this.allMenus = {};
    this.allMenusSel= {}; // Selectable menus
    this.simpleMenus = {};
    this.shownMenus = {};

    this.WIDTH = 400; // total width of view area
    this.HEIGHT = 400; // total height of view area
    this.RESIDUE_WIDTH = 10;  // sequences
    if(me.utilsCls.isMobile() || this.cfg.mobilemenu) {
        this.MENU_HEIGHT = 0;
    }
    else {
        this.MENU_HEIGHT = 40;
    }
    this.LOG_HEIGHT = 65; //65;

    // used to set the position for the log/command textarea
    this.MENU_WIDTH = 750;
    //The width (in px) that was left empty by the 3D viewer. The default is 20px.
    this.LESSWIDTH = 20;
    this.LESSWIDTH_RESIZE = 20;
    //The height (in px) that was left empty by the 3D viewer. The default is 20px.
    this.LESSHEIGHT = 20;

    // size of 2D cartoons
    this.width2d = 200;

    this.CMD_HEIGHT = 0.8*this.LOG_HEIGHT;
    //this.EXTRAHEIGHT = 2*this.MENU_HEIGHT + this.CMD_HEIGHT;
    this.EXTRAHEIGHT = this.MENU_HEIGHT + this.CMD_HEIGHT;
    if(this.cfg.showmenu != undefined && this.cfg.showmenu == false) {
        //this.EXTRAHEIGHT -= 2*this.MENU_HEIGHT;
        this.EXTRAHEIGHT -= this.MENU_HEIGHT;
    }
    if(this.cfg.showcommand != undefined && this.cfg.showcommand == false) {
        this.EXTRAHEIGHT -= this.CMD_HEIGHT;
    }

    this.GREY8 = "#AAAAAA"; //"#888888"; // style protein grey
    this.GREYB = "#CCCCCC"; //"#BBBBBB";
    this.GREYC = "#DDDDDD"; //"#CCCCCC"; // grey background
    this.GREYD = "#EEEEEE"; //"#DDDDDD";
    this.ORANGE = "#FFA500";

    this.themecolor = 'blue';

    // used in graph
    this.defaultValue = 1;
    this.ssValue = 3;
    this.coilValue = 3;
    this.contactValue = 11;
    this.contactInsideValue = 12;
    this.hbondValue = 13;
    this.hbondInsideValue = 14;
    this.ssbondValue = 4;
    this.ionicValue = 5;
    this.ionicInsideValue = 6;
    this.clbondValue = 15;
    this.halogenValue = 17;
    this.halogenInsideValue = 18;
    this.picationValue = 19;
    this.picationInsideValue = 20;
    this.pistackingValue = 21;
    this.pistackingInsideValue = 22;
    this.contactColor = '888';
    this.contactInsideColor = 'FFF'; //'DDD';
    this.hbondColor = '0F0';
    this.hbondInsideColor = 'FFF'; //'AFA';
    this.ssbondColor = 'FFA500';
    this.ionicColor = '0FF';
    this.ionicInsideColor = 'FFF'; //'8FF';
    this.clbondColor = '006400';
    this.halogenColor = 'F0F';
    this.halogenInsideColor = 'FFF';
    this.picationColor = 'F00';
    this.picationInsideColor = 'FFF';
    this.pistackingColor = '00F';
    this.pistackingInsideColor = 'FFF';
    this.hideedges = 1;
    //this.pushcenter = 0;
    this.force = 4;
    this.simulation = undefined;

    //this.baseUrl = "https://www.ncbi.nlm.nih.gov/Structure/";
    this.baseUrl = (window && window.location && window.location.hostname == 'structure.ncbi.nlm.nih.gov') 
        ? "https://structure.ncbi.nlm.nih.gov/Structure/" : "https://www.ncbi.nlm.nih.gov/Structure/";

    this.tmalignUrl = this.baseUrl + "tmalign/tmalign.cgi";
    
    this.divStr = "<div id='" + this.icn3dui.pre;
    this.divNowrapStr = "<div style='white-space:nowrap'>";
    this.spanNowrapStr = "<span style='white-space:nowrap'>";
    this.inputTextStr = "<input type='text' ";
    this.inputFileStr = "<input type='file' ";
    this.inputRadioStr = "<input type='radio' ";
    this.inputCheckStr = "<input type='checkbox' ";
    this.optionStr = "<option value=";
    this.buttonStr = "<button id='" + this.icn3dui.pre;
    this.postfix = "2"; // add postfix for the structure of the query protein when align two chains in one protein
    this.space2 = "&nbsp;&nbsp;";
    this.space3 = this.space2 + "&nbsp;";
    this.space4 = this.space2 + this.space2;
    //this.wifiStr = '<i class="icn3d-wifi" title="requires internet">&nbsp;</i>';
    this.wifiStr = '';
    //this.licenseStr = '<i class="icn3d-license" title="requires license">&nbsp;</i>';
    this.licenseStr = '';
    this.closeAc = {collapsible: true, active: false}; // close accordion

    this.clickMenuCls = new ClickMenu(this.icn3dui);
    this.setMenuCls = new SetMenu(this.icn3dui);
    this.dialogCls = new Dialog(this.icn3dui);
    this.setDialogCls = new SetDialog(this.icn3dui);
    this.eventsCls = new Events(this.icn3dui);
    this.alignSeqCls = new AlignSeq(this.icn3dui);
    this.setHtmlCls = new SetHtml(this.icn3dui);
  }
}

/*
import {
    AnimationClip,
    Bone,
    Box3,
    BufferAttribute,
    BufferGeometry,
    ClampToEdgeWrapping,
    Color,
    DirectionalLight,
    DoubleSide,
    FileLoader,
    FrontSide,
    Group,
    ImageBitmapLoader,
    InterleavedBuffer,
    InterleavedBufferAttribute,
    Interpolant,
    InterpolateDiscrete,
    InterpolateLinear,
    Line,
    LineBasicMaterial,
    LineLoop,
    LineSegments,
    LinearFilter,
    LinearMipmapLinearFilter,
    LinearMipmapNearestFilter,
    Loader,
    THREE.LoaderUtils,
    Material,
    MathUtils,
    Matrix4,
    Mesh,
    MeshBasicMaterial,
    MeshPhysicalMaterial,
    MeshStandardMaterial,
    MirroredRepeatWrapping,
    NearestFilter,
    NearestMipmapLinearFilter,
    NearestMipmapNearestFilter,
    NumberKeyframeTrack,
    Object3D,
    OrthographicCamera,
    PerspectiveCamera,
    PointLight,
    Points,
    PointsMaterial,
    PropertyBinding,
    Quaternion,
    QuaternionKeyframeTrack,
    RepeatWrapping,
    Skeleton,
    SkinnedMesh,
    Sphere,
    SpotLight,
    TangentSpaceNormalMap,
    Texture,
    TextureLoader,
    TriangleFanDrawMode,
    TriangleStripDrawMode,
    Vector2,
    Vector3,
    VectorKeyframeTrack,
    sRGBEncoding
} from 'three';
*/

class GLTFLoader extends THREE.Loader {

    constructor( manager ) {

        super( manager );

        this.dracoLoader = null;
        this.ktx2Loader = null;
        this.meshoptDecoder = null;

        this.pluginCallbacks = [];

        this.register( function ( parser ) {

            return new GLTFMaterialsClearcoatExtension( parser );

        } );

        this.register( function ( parser ) {

            return new GLTFTextureBasisUExtension( parser );

        } );

        this.register( function ( parser ) {

            return new GLTFTextureWebPExtension( parser );

        } );

        this.register( function ( parser ) {

            return new GLTFMaterialsSheenExtension( parser );

        } );

        this.register( function ( parser ) {

            return new GLTFMaterialsTransmissionExtension( parser );

        } );

        this.register( function ( parser ) {

            return new GLTFMaterialsVolumeExtension( parser );

        } );

        this.register( function ( parser ) {

            return new GLTFMaterialsIorExtension( parser );

        } );

        this.register( function ( parser ) {

            return new GLTFMaterialsSpecularExtension( parser );

        } );

        this.register( function ( parser ) {

            return new GLTFLightsExtension( parser );

        } );

        this.register( function ( parser ) {

            return new GLTFMeshoptCompression( parser );

        } );

    }

    load( url, onLoad, onProgress, onError ) {

        const scope = this;

        let resourcePath;

        if ( this.resourcePath !== '' ) {

            resourcePath = this.resourcePath;

        } else if ( this.path !== '' ) {

            resourcePath = this.path;

        } else {

            resourcePath = THREE.LoaderUtils.extractUrlBase( url );

        }

        // Tells the LoadingManager to track an extra item, which resolves after
        // the model is fully loaded. This means the count of items loaded will
        // be incorrect, but ensures manager.onLoad() does not fire early.
        this.manager.itemStart( url );

        const _onError = function ( e ) {

            if ( onError ) {

                onError( e );

            } else {

                console.error( e );

            }

            scope.manager.itemError( url );
            scope.manager.itemEnd( url );

        };

        const loader = new THREE.FileLoader( this.manager );

        loader.setPath( this.path );
        loader.setResponseType( 'arraybuffer' );
        loader.setRequestHeader( this.requestHeader );
        loader.setWithCredentials( this.withCredentials );

        loader.load( url, function ( data ) {

            try {

                scope.parse( data, resourcePath, function ( gltf ) {

                    onLoad( gltf );

                    scope.manager.itemEnd( url );

                }, _onError );

            } catch ( e ) {

                _onError( e );

            }

        }, onProgress, _onError );

    }

    setDRACOLoader( dracoLoader ) {

        this.dracoLoader = dracoLoader;
        return this;

    }

    setDDSLoader() {

        throw new Error(

            'THREE.GLTFLoader: "MSFT_texture_dds" no longer supported. Please update to "KHR_texture_basisu".'

        );

    }

    setKTX2Loader( ktx2Loader ) {

        this.ktx2Loader = ktx2Loader;
        return this;

    }

    setMeshoptDecoder( meshoptDecoder ) {

        this.meshoptDecoder = meshoptDecoder;
        return this;

    }

    register( callback ) {

        if ( this.pluginCallbacks.indexOf( callback ) === - 1 ) {

            this.pluginCallbacks.push( callback );

        }

        return this;

    }

    unregister( callback ) {

        if ( this.pluginCallbacks.indexOf( callback ) !== - 1 ) {

            this.pluginCallbacks.splice( this.pluginCallbacks.indexOf( callback ), 1 );

        }

        return this;

    }

    parse( data, path, onLoad, onError ) {

        let content;
        const extensions = {};
        const plugins = {};

        if ( typeof data === 'string' ) {

            content = data;

        } else {

            const magic = THREE.LoaderUtils.decodeText( new Uint8Array( data, 0, 4 ) );

            if ( magic === BINARY_EXTENSION_HEADER_MAGIC ) {

                try {

                    extensions[ EXTENSIONS.KHR_BINARY_GLTF ] = new GLTFBinaryExtension( data );

                } catch ( error ) {

                    if ( onError ) onError( error );
                    return;

                }

                content = extensions[ EXTENSIONS.KHR_BINARY_GLTF ].content;

            } else {

                content = THREE.LoaderUtils.decodeText( new Uint8Array( data ) );

            }

        }

        const json = JSON.parse( content );

        if ( json.asset === undefined || json.asset.version[ 0 ] < 2 ) {

            if ( onError ) onError( new Error( 'THREE.GLTFLoader: Unsupported asset. glTF versions >=2.0 are supported.' ) );
            return;

        }

        const parser = new GLTFParser( json, {

            path: path || this.resourcePath || '',
            crossOrigin: this.crossOrigin,
            requestHeader: this.requestHeader,
            manager: this.manager,
            ktx2Loader: this.ktx2Loader,
            meshoptDecoder: this.meshoptDecoder

        } );

        parser.fileLoader.setRequestHeader( this.requestHeader );

        for ( let i = 0; i < this.pluginCallbacks.length; i ++ ) {

            const plugin = this.pluginCallbacks[ i ]( parser );
            plugins[ plugin.name ] = plugin;

            // Workaround to avoid determining as unknown extension
            // in addUnknownExtensionsToUserData().
            // Remove this workaround if we move all the existing
            // extension handlers to plugin system
            extensions[ plugin.name ] = true;

        }

        if ( json.extensionsUsed ) {

            for ( let i = 0; i < json.extensionsUsed.length; ++ i ) {

                const extensionName = json.extensionsUsed[ i ];
                const extensionsRequired = json.extensionsRequired || [];

                switch ( extensionName ) {

                    case EXTENSIONS.KHR_MATERIALS_UNLIT:
                        extensions[ extensionName ] = new GLTFMaterialsUnlitExtension();
                        break;

                    case EXTENSIONS.KHR_MATERIALS_PBR_SPECULAR_GLOSSINESS:
                        extensions[ extensionName ] = new GLTFMaterialsPbrSpecularGlossinessExtension();
                        break;

                    case EXTENSIONS.KHR_DRACO_MESH_COMPRESSION:
                        extensions[ extensionName ] = new GLTFDracoMeshCompressionExtension( json, this.dracoLoader );
                        break;

                    case EXTENSIONS.KHR_TEXTURE_TRANSFORM:
                        extensions[ extensionName ] = new GLTFTextureTransformExtension();
                        break;

                    case EXTENSIONS.KHR_MESH_QUANTIZATION:
                        extensions[ extensionName ] = new GLTFMeshQuantizationExtension();
                        break;

                    default:

                        if ( extensionsRequired.indexOf( extensionName ) >= 0 && plugins[ extensionName ] === undefined ) {

                            console.warn( 'THREE.GLTFLoader: Unknown extension "' + extensionName + '".' );

                        }

                }

            }

        }

        parser.setExtensions( extensions );
        parser.setPlugins( plugins );
        parser.parse( onLoad, onError );

    }

    parseAsync( data, path ) {

        const scope = this;

        return new Promise( function ( resolve, reject ) {

            scope.parse( data, path, resolve, reject );

        } );

    }

}

/* GLTFREGISTRY */

function GLTFRegistry() {

    let objects = {};

    return  {

        get: function ( key ) {

            return objects[ key ];

        },

        add: function ( key, object ) {

            objects[ key ] = object;

        },

        remove: function ( key ) {

            delete objects[ key ];

        },

        removeAll: function () {

            objects = {};

        }

    };

}

/*********************************/
/********** EXTENSIONS ***********/
/*********************************/

const EXTENSIONS = {
    KHR_BINARY_GLTF: 'KHR_binary_glTF',
    KHR_DRACO_MESH_COMPRESSION: 'KHR_draco_mesh_compression',
    KHR_LIGHTS_PUNCTUAL: 'KHR_lights_punctual',
    KHR_MATERIALS_CLEARCOAT: 'KHR_materials_clearcoat',
    KHR_MATERIALS_IOR: 'KHR_materials_ior',
    KHR_MATERIALS_PBR_SPECULAR_GLOSSINESS: 'KHR_materials_pbrSpecularGlossiness',
    KHR_MATERIALS_SHEEN: 'KHR_materials_sheen',
    KHR_MATERIALS_SPECULAR: 'KHR_materials_specular',
    KHR_MATERIALS_TRANSMISSION: 'KHR_materials_transmission',
    KHR_MATERIALS_UNLIT: 'KHR_materials_unlit',
    KHR_MATERIALS_VOLUME: 'KHR_materials_volume',
    KHR_TEXTURE_BASISU: 'KHR_texture_basisu',
    KHR_TEXTURE_TRANSFORM: 'KHR_texture_transform',
    KHR_MESH_QUANTIZATION: 'KHR_mesh_quantization',
    EXT_TEXTURE_WEBP: 'EXT_texture_webp',
    EXT_MESHOPT_COMPRESSION: 'EXT_meshopt_compression'
};

/**
 * Punctual Lights Extension
 *
 * Specification: https://github.com/KhronosGroup/glTF/tree/master/extensions/2.0/Khronos/KHR_lights_punctual
 */
class GLTFLightsExtension {

    constructor( parser ) {

        this.parser = parser;
        this.name = EXTENSIONS.KHR_LIGHTS_PUNCTUAL;

        // Object3D instance caches
        this.cache = { refs: {}, uses: {} };

    }

    _markDefs() {

        const parser = this.parser;
        const nodeDefs = this.parser.json.nodes || [];

        for ( let nodeIndex = 0, nodeLength = nodeDefs.length; nodeIndex < nodeLength; nodeIndex ++ ) {

            const nodeDef = nodeDefs[ nodeIndex ];

            if ( nodeDef.extensions
                    && nodeDef.extensions[ this.name ]
                    && nodeDef.extensions[ this.name ].light !== undefined ) {

                parser._addNodeRef( this.cache, nodeDef.extensions[ this.name ].light );

            }

        }

    }

    _loadLight( lightIndex ) {

        const parser = this.parser;
        const cacheKey = 'light:' + lightIndex;
        let dependency = parser.cache.get( cacheKey );

        if ( dependency ) return dependency;

        const json = parser.json;
        const extensions = ( json.extensions && json.extensions[ this.name ] ) || {};
        const lightDefs = extensions.lights || [];
        const lightDef = lightDefs[ lightIndex ];
        let lightNode;

        const color = new Color( 0xffffff );

        if ( lightDef.color !== undefined ) color.fromArray( lightDef.color );

        const range = lightDef.range !== undefined ? lightDef.range : 0;

        switch ( lightDef.type ) {

            case 'directional':
                lightNode = new DirectionalLight( color );
                lightNode.target.position.set( 0, 0, - 1 );
                lightNode.add( lightNode.target );
                break;

            case 'point':
                lightNode = new PointLight( color );
                lightNode.distance = range;
                break;

            case 'spot':
                lightNode = new SpotLight( color );
                lightNode.distance = range;
                // Handle spotlight properties.
                lightDef.spot = lightDef.spot || {};
                lightDef.spot.innerConeAngle = lightDef.spot.innerConeAngle !== undefined ? lightDef.spot.innerConeAngle : 0;
                lightDef.spot.outerConeAngle = lightDef.spot.outerConeAngle !== undefined ? lightDef.spot.outerConeAngle : Math.PI / 4.0;
                lightNode.angle = lightDef.spot.outerConeAngle;
                lightNode.penumbra = 1.0 - lightDef.spot.innerConeAngle / lightDef.spot.outerConeAngle;
                lightNode.target.position.set( 0, 0, - 1 );
                lightNode.add( lightNode.target );
                break;

            default:
                throw new Error( 'THREE.GLTFLoader: Unexpected light type: ' + lightDef.type );

        }

        // Some lights (e.g. spot) default to a position other than the origin. Reset the position
        // here, because node-level parsing will only override position if explicitly specified.
        lightNode.position.set( 0, 0, 0 );

        lightNode.decay = 2;

        if ( lightDef.intensity !== undefined ) lightNode.intensity = lightDef.intensity;

        lightNode.name = parser.createUniqueName( lightDef.name || ( 'light_' + lightIndex ) );

        dependency = Promise.resolve( lightNode );

        parser.cache.add( cacheKey, dependency );

        return dependency;

    }

    createNodeAttachment( nodeIndex ) {

        const self = this;
        const parser = this.parser;
        const json = parser.json;
        const nodeDef = json.nodes[ nodeIndex ];
        const lightDef = ( nodeDef.extensions && nodeDef.extensions[ this.name ] ) || {};
        const lightIndex = lightDef.light;

        if ( lightIndex === undefined ) return null;

        return this._loadLight( lightIndex ).then( function ( light ) {

            return parser._getNodeRef( self.cache, lightIndex, light );

        } );

    }

}

/**
 * Unlit Materials Extension
 *
 * Specification: https://github.com/KhronosGroup/glTF/tree/master/extensions/2.0/Khronos/KHR_materials_unlit
 */
class GLTFMaterialsUnlitExtension {

    constructor() {

        this.name = EXTENSIONS.KHR_MATERIALS_UNLIT;

    }

    getMaterialType() {

        return MeshBasicMaterial;

    }

    extendParams( materialParams, materialDef, parser ) {

        const pending = [];

        materialParams.color = new Color( 1.0, 1.0, 1.0 );
        materialParams.opacity = 1.0;

        const metallicRoughness = materialDef.pbrMetallicRoughness;

        if ( metallicRoughness ) {

            if ( Array.isArray( metallicRoughness.baseColorFactor ) ) {

                const array = metallicRoughness.baseColorFactor;

                materialParams.color.fromArray( array );
                materialParams.opacity = array[ 3 ];

            }

            if ( metallicRoughness.baseColorTexture !== undefined ) {

                pending.push( parser.assignTexture( materialParams, 'map', metallicRoughness.baseColorTexture, sRGBEncoding ) );

            }

        }

        return Promise.all( pending );

    }

}

/**
 * Clearcoat Materials Extension
 *
 * Specification: https://github.com/KhronosGroup/glTF/tree/master/extensions/2.0/Khronos/KHR_materials_clearcoat
 */
class GLTFMaterialsClearcoatExtension {

    constructor( parser ) {

        this.parser = parser;
        this.name = EXTENSIONS.KHR_MATERIALS_CLEARCOAT;

    }

    getMaterialType( materialIndex ) {

        const parser = this.parser;
        const materialDef = parser.json.materials[ materialIndex ];

        if ( ! materialDef.extensions || ! materialDef.extensions[ this.name ] ) return null;

        return MeshPhysicalMaterial;

    }

    extendMaterialParams( materialIndex, materialParams ) {

        const parser = this.parser;
        const materialDef = parser.json.materials[ materialIndex ];

        if ( ! materialDef.extensions || ! materialDef.extensions[ this.name ] ) {

            return Promise.resolve();

        }

        const pending = [];

        const extension = materialDef.extensions[ this.name ];

        if ( extension.clearcoatFactor !== undefined ) {

            materialParams.clearcoat = extension.clearcoatFactor;

        }

        if ( extension.clearcoatTexture !== undefined ) {

            pending.push( parser.assignTexture( materialParams, 'clearcoatMap', extension.clearcoatTexture ) );

        }

        if ( extension.clearcoatRoughnessFactor !== undefined ) {

            materialParams.clearcoatRoughness = extension.clearcoatRoughnessFactor;

        }

        if ( extension.clearcoatRoughnessTexture !== undefined ) {

            pending.push( parser.assignTexture( materialParams, 'clearcoatRoughnessMap', extension.clearcoatRoughnessTexture ) );

        }

        if ( extension.clearcoatNormalTexture !== undefined ) {

            pending.push( parser.assignTexture( materialParams, 'clearcoatNormalMap', extension.clearcoatNormalTexture ) );

            if ( extension.clearcoatNormalTexture.scale !== undefined ) {

                const scale = extension.clearcoatNormalTexture.scale;

                materialParams.clearcoatNormalScale = new Vector2( scale, scale );

            }

        }

        return Promise.all( pending );

    }

}

/**
 * Sheen Materials Extension
 *
 * Specification: https://github.com/KhronosGroup/glTF/tree/main/extensions/2.0/Khronos/KHR_materials_sheen
 */
class GLTFMaterialsSheenExtension {

    constructor( parser ) {

        this.parser = parser;
        this.name = EXTENSIONS.KHR_MATERIALS_SHEEN;

    }

    getMaterialType( materialIndex ) {

        const parser = this.parser;
        const materialDef = parser.json.materials[ materialIndex ];

        if ( ! materialDef.extensions || ! materialDef.extensions[ this.name ] ) return null;

        return MeshPhysicalMaterial;

    }

    extendMaterialParams( materialIndex, materialParams ) {

        const parser = this.parser;
        const materialDef = parser.json.materials[ materialIndex ];

        if ( ! materialDef.extensions || ! materialDef.extensions[ this.name ] ) {

            return Promise.resolve();

        }

        const pending = [];

        materialParams.sheenColor = new Color( 0, 0, 0 );
        materialParams.sheenRoughness = 0;
        materialParams.sheen = 1;

        const extension = materialDef.extensions[ this.name ];

        if ( extension.sheenColorFactor !== undefined ) {

            materialParams.sheenColor.fromArray( extension.sheenColorFactor );

        }

        if ( extension.sheenRoughnessFactor !== undefined ) {

            materialParams.sheenRoughness = extension.sheenRoughnessFactor;

        }

        if ( extension.sheenColorTexture !== undefined ) {

            pending.push( parser.assignTexture( materialParams, 'sheenColorMap', extension.sheenColorTexture, sRGBEncoding ) );

        }

        if ( extension.sheenRoughnessTexture !== undefined ) {

            pending.push( parser.assignTexture( materialParams, 'sheenRoughnessMap', extension.sheenRoughnessTexture ) );

        }

        return Promise.all( pending );

    }

}

/**
 * Transmission Materials Extension
 *
 * Specification: https://github.com/KhronosGroup/glTF/tree/master/extensions/2.0/Khronos/KHR_materials_transmission
 * Draft: https://github.com/KhronosGroup/glTF/pull/1698
 */
class GLTFMaterialsTransmissionExtension {

    constructor( parser ) {

        this.parser = parser;
        this.name = EXTENSIONS.KHR_MATERIALS_TRANSMISSION;

    }

    getMaterialType( materialIndex ) {

        const parser = this.parser;
        const materialDef = parser.json.materials[ materialIndex ];

        if ( ! materialDef.extensions || ! materialDef.extensions[ this.name ] ) return null;

        return MeshPhysicalMaterial;

    }

    extendMaterialParams( materialIndex, materialParams ) {

        const parser = this.parser;
        const materialDef = parser.json.materials[ materialIndex ];

        if ( ! materialDef.extensions || ! materialDef.extensions[ this.name ] ) {

            return Promise.resolve();

        }

        const pending = [];

        const extension = materialDef.extensions[ this.name ];

        if ( extension.transmissionFactor !== undefined ) {

            materialParams.transmission = extension.transmissionFactor;

        }

        if ( extension.transmissionTexture !== undefined ) {

            pending.push( parser.assignTexture( materialParams, 'transmissionMap', extension.transmissionTexture ) );

        }

        return Promise.all( pending );

    }

}

/**
 * Materials Volume Extension
 *
 * Specification: https://github.com/KhronosGroup/glTF/tree/master/extensions/2.0/Khronos/KHR_materials_volume
 */
class GLTFMaterialsVolumeExtension {

    constructor( parser ) {

        this.parser = parser;
        this.name = EXTENSIONS.KHR_MATERIALS_VOLUME;

    }

    getMaterialType( materialIndex ) {

        const parser = this.parser;
        const materialDef = parser.json.materials[ materialIndex ];

        if ( ! materialDef.extensions || ! materialDef.extensions[ this.name ] ) return null;

        return MeshPhysicalMaterial;

    }

    extendMaterialParams( materialIndex, materialParams ) {

        const parser = this.parser;
        const materialDef = parser.json.materials[ materialIndex ];

        if ( ! materialDef.extensions || ! materialDef.extensions[ this.name ] ) {

            return Promise.resolve();

        }

        const pending = [];

        const extension = materialDef.extensions[ this.name ];

        materialParams.thickness = extension.thicknessFactor !== undefined ? extension.thicknessFactor : 0;

        if ( extension.thicknessTexture !== undefined ) {

            pending.push( parser.assignTexture( materialParams, 'thicknessMap', extension.thicknessTexture ) );

        }

        materialParams.attenuationDistance = extension.attenuationDistance || 0;

        const colorArray = extension.attenuationColor || [ 1, 1, 1 ];
        materialParams.attenuationColor = new Color( colorArray[ 0 ], colorArray[ 1 ], colorArray[ 2 ] );

        return Promise.all( pending );

    }

}

/**
 * Materials ior Extension
 *
 * Specification: https://github.com/KhronosGroup/glTF/tree/master/extensions/2.0/Khronos/KHR_materials_ior
 */
class GLTFMaterialsIorExtension {

    constructor( parser ) {

        this.parser = parser;
        this.name = EXTENSIONS.KHR_MATERIALS_IOR;

    }

    getMaterialType( materialIndex ) {

        const parser = this.parser;
        const materialDef = parser.json.materials[ materialIndex ];

        if ( ! materialDef.extensions || ! materialDef.extensions[ this.name ] ) return null;

        return MeshPhysicalMaterial;

    }

    extendMaterialParams( materialIndex, materialParams ) {

        const parser = this.parser;
        const materialDef = parser.json.materials[ materialIndex ];

        if ( ! materialDef.extensions || ! materialDef.extensions[ this.name ] ) {

            return Promise.resolve();

        }

        const extension = materialDef.extensions[ this.name ];

        materialParams.ior = extension.ior !== undefined ? extension.ior : 1.5;

        return Promise.resolve();

    }

}

/**
 * Materials specular Extension
 *
 * Specification: https://github.com/KhronosGroup/glTF/tree/master/extensions/2.0/Khronos/KHR_materials_specular
 */
class GLTFMaterialsSpecularExtension {

    constructor( parser ) {

        this.parser = parser;
        this.name = EXTENSIONS.KHR_MATERIALS_SPECULAR;

    }

    getMaterialType( materialIndex ) {

        const parser = this.parser;
        const materialDef = parser.json.materials[ materialIndex ];

        if ( ! materialDef.extensions || ! materialDef.extensions[ this.name ] ) return null;

        return MeshPhysicalMaterial;

    }

    extendMaterialParams( materialIndex, materialParams ) {

        const parser = this.parser;
        const materialDef = parser.json.materials[ materialIndex ];

        if ( ! materialDef.extensions || ! materialDef.extensions[ this.name ] ) {

            return Promise.resolve();

        }

        const pending = [];

        const extension = materialDef.extensions[ this.name ];

        materialParams.specularIntensity = extension.specularFactor !== undefined ? extension.specularFactor : 1.0;

        if ( extension.specularTexture !== undefined ) {

            pending.push( parser.assignTexture( materialParams, 'specularIntensityMap', extension.specularTexture ) );

        }

        const colorArray = extension.specularColorFactor || [ 1, 1, 1 ];
        materialParams.specularColor = new Color( colorArray[ 0 ], colorArray[ 1 ], colorArray[ 2 ] );

        if ( extension.specularColorTexture !== undefined ) {

            pending.push( parser.assignTexture( materialParams, 'specularColorMap', extension.specularColorTexture, sRGBEncoding ) );

        }

        return Promise.all( pending );

    }

}

/**
 * BasisU Texture Extension
 *
 * Specification: https://github.com/KhronosGroup/glTF/tree/master/extensions/2.0/Khronos/KHR_texture_basisu
 */
class GLTFTextureBasisUExtension {

    constructor( parser ) {

        this.parser = parser;
        this.name = EXTENSIONS.KHR_TEXTURE_BASISU;

    }

    loadTexture( textureIndex ) {

        const parser = this.parser;
        const json = parser.json;

        const textureDef = json.textures[ textureIndex ];

        if ( ! textureDef.extensions || ! textureDef.extensions[ this.name ] ) {

            return null;

        }

        const extension = textureDef.extensions[ this.name ];
        const loader = parser.options.ktx2Loader;

        if ( ! loader ) {

            if ( json.extensionsRequired && json.extensionsRequired.indexOf( this.name ) >= 0 ) {

                throw new Error( 'THREE.GLTFLoader: setKTX2Loader must be called before loading KTX2 textures' );

            } else {

                // Assumes that the extension is optional and that a fallback texture is present
                return null;

            }

        }

        return parser.loadTextureImage( textureIndex, extension.source, loader );

    }

}

/**
 * WebP Texture Extension
 *
 * Specification: https://github.com/KhronosGroup/glTF/tree/master/extensions/2.0/Vendor/EXT_texture_webp
 */
class GLTFTextureWebPExtension {

    constructor( parser ) {

        this.parser = parser;
        this.name = EXTENSIONS.EXT_TEXTURE_WEBP;
        this.isSupported = null;

    }

    loadTexture( textureIndex ) {

        const name = this.name;
        const parser = this.parser;
        const json = parser.json;

        const textureDef = json.textures[ textureIndex ];

        if ( ! textureDef.extensions || ! textureDef.extensions[ name ] ) {

            return null;

        }

        const extension = textureDef.extensions[ name ];
        const source = json.images[ extension.source ];

        let loader = parser.textureLoader;
        if ( source.uri ) {

            const handler = parser.options.manager.getHandler( source.uri );
            if ( handler !== null ) loader = handler;

        }

        return this.detectSupport().then( function ( isSupported ) {

            if ( isSupported ) return parser.loadTextureImage( textureIndex, extension.source, loader );

            if ( json.extensionsRequired && json.extensionsRequired.indexOf( name ) >= 0 ) {

                throw new Error( 'THREE.GLTFLoader: WebP required by asset but unsupported.' );

            }

            // Fall back to PNG or JPEG.
            return parser.loadTexture( textureIndex );

        } );

    }

    detectSupport() {

        if ( ! this.isSupported ) {

            this.isSupported = new Promise( function ( resolve ) {

                const image = new Image();

                // Lossy test image. Support for lossy images doesn't guarantee support for all
                // WebP images, unfortunately.
                image.src = 'data:image/webp;base64,UklGRiIAAABXRUJQVlA4IBYAAAAwAQCdASoBAAEADsD+JaQAA3AAAAAA';

                image.onload = image.onerror = function () {

                    resolve( image.height === 1 );

                };

            } );

        }

        return this.isSupported;

    }

}

/**
 * meshopt BufferView Compression Extension
 *
 * Specification: https://github.com/KhronosGroup/glTF/tree/master/extensions/2.0/Vendor/EXT_meshopt_compression
 */
class GLTFMeshoptCompression {

    constructor( parser ) {

        this.name = EXTENSIONS.EXT_MESHOPT_COMPRESSION;
        this.parser = parser;

    }

    loadBufferView( index ) {

        const json = this.parser.json;
        const bufferView = json.bufferViews[ index ];

        if ( bufferView.extensions && bufferView.extensions[ this.name ] ) {

            const extensionDef = bufferView.extensions[ this.name ];

            const buffer = this.parser.getDependency( 'buffer', extensionDef.buffer );
            const decoder = this.parser.options.meshoptDecoder;

            if ( ! decoder || ! decoder.supported ) {

                if ( json.extensionsRequired && json.extensionsRequired.indexOf( this.name ) >= 0 ) {

                    throw new Error( 'THREE.GLTFLoader: setMeshoptDecoder must be called before loading compressed files' );

                } else {

                    // Assumes that the extension is optional and that fallback buffer data is present
                    return null;

                }

            }

            return Promise.all( [ buffer, decoder.ready ] ).then( function ( res ) {

                const byteOffset = extensionDef.byteOffset || 0;
                const byteLength = extensionDef.byteLength || 0;

                const count = extensionDef.count;
                const stride = extensionDef.byteStride;

                const result = new ArrayBuffer( count * stride );
                const source = new Uint8Array( res[ 0 ], byteOffset, byteLength );

                decoder.decodeGltfBuffer( new Uint8Array( result ), count, stride, source, extensionDef.mode, extensionDef.filter );
                return result;

            } );

        } else {

            return null;

        }

    }

}

/* BINARY EXTENSION */
const BINARY_EXTENSION_HEADER_MAGIC = 'glTF';
const BINARY_EXTENSION_HEADER_LENGTH = 12;
const BINARY_EXTENSION_CHUNK_TYPES = { JSON: 0x4E4F534A, BIN: 0x004E4942 };

class GLTFBinaryExtension {

    constructor( data ) {

        this.name = EXTENSIONS.KHR_BINARY_GLTF;
        this.content = null;
        this.body = null;

        const headerView = new DataView( data, 0, BINARY_EXTENSION_HEADER_LENGTH );

        this.header = {
            magic: THREE.LoaderUtils.decodeText( new Uint8Array( data.slice( 0, 4 ) ) ),
            version: headerView.getUint32( 4, true ),
            length: headerView.getUint32( 8, true )
        };

        if ( this.header.magic !== BINARY_EXTENSION_HEADER_MAGIC ) {

            throw new Error( 'THREE.GLTFLoader: Unsupported glTF-Binary header.' );

        } else if ( this.header.version < 2.0 ) {

            throw new Error( 'THREE.GLTFLoader: Legacy binary file detected.' );

        }

        const chunkContentsLength = this.header.length - BINARY_EXTENSION_HEADER_LENGTH;
        const chunkView = new DataView( data, BINARY_EXTENSION_HEADER_LENGTH );
        let chunkIndex = 0;

        while ( chunkIndex < chunkContentsLength ) {

            const chunkLength = chunkView.getUint32( chunkIndex, true );
            chunkIndex += 4;

            const chunkType = chunkView.getUint32( chunkIndex, true );
            chunkIndex += 4;

            if ( chunkType === BINARY_EXTENSION_CHUNK_TYPES.JSON ) {

                const contentArray = new Uint8Array( data, BINARY_EXTENSION_HEADER_LENGTH + chunkIndex, chunkLength );
                this.content = THREE.LoaderUtils.decodeText( contentArray );

            } else if ( chunkType === BINARY_EXTENSION_CHUNK_TYPES.BIN ) {

                const byteOffset = BINARY_EXTENSION_HEADER_LENGTH + chunkIndex;
                this.body = data.slice( byteOffset, byteOffset + chunkLength );

            }

            // Clients must ignore chunks with unknown types.

            chunkIndex += chunkLength;

        }

        if ( this.content === null ) {

            throw new Error( 'THREE.GLTFLoader: JSON content not found.' );

        }

    }

}

/**
 * DRACO Mesh Compression Extension
 *
 * Specification: https://github.com/KhronosGroup/glTF/tree/master/extensions/2.0/Khronos/KHR_draco_mesh_compression
 */
class GLTFDracoMeshCompressionExtension {

    constructor( json, dracoLoader ) {

        if ( ! dracoLoader ) {

            throw new Error( 'THREE.GLTFLoader: No DRACOLoader instance provided.' );

        }

        this.name = EXTENSIONS.KHR_DRACO_MESH_COMPRESSION;
        this.json = json;
        this.dracoLoader = dracoLoader;
        this.dracoLoader.preload();

    }

    decodePrimitive( primitive, parser ) {

        const json = this.json;
        const dracoLoader = this.dracoLoader;
        const bufferViewIndex = primitive.extensions[ this.name ].bufferView;
        const gltfAttributeMap = primitive.extensions[ this.name ].attributes;
        const threeAttributeMap = {};
        const attributeNormalizedMap = {};
        const attributeTypeMap = {};

        for ( const attributeName in gltfAttributeMap ) {

            const threeAttributeName = ATTRIBUTES[ attributeName ] || attributeName.toLowerCase();

            threeAttributeMap[ threeAttributeName ] = gltfAttributeMap[ attributeName ];

        }

        for ( const attributeName in primitive.attributes ) {

            const threeAttributeName = ATTRIBUTES[ attributeName ] || attributeName.toLowerCase();

            if ( gltfAttributeMap[ attributeName ] !== undefined ) {

                const accessorDef = json.accessors[ primitive.attributes[ attributeName ] ];
                const componentType = WEBGL_COMPONENT_TYPES[ accessorDef.componentType ];

                attributeTypeMap[ threeAttributeName ] = componentType;
                attributeNormalizedMap[ threeAttributeName ] = accessorDef.normalized === true;

            }

        }

        return parser.getDependency( 'bufferView', bufferViewIndex ).then( function ( bufferView ) {

            return new Promise( function ( resolve ) {

                dracoLoader.decodeDracoFile( bufferView, function ( geometry ) {

                    for ( const attributeName in geometry.attributes ) {

                        const attribute = geometry.attributes[ attributeName ];
                        const normalized = attributeNormalizedMap[ attributeName ];

                        if ( normalized !== undefined ) attribute.normalized = normalized;

                    }

                    resolve( geometry );

                }, threeAttributeMap, attributeTypeMap );

            } );

        } );

    }

}

/**
 * Texture Transform Extension
 *
 * Specification: https://github.com/KhronosGroup/glTF/tree/master/extensions/2.0/Khronos/KHR_texture_transform
 */
class GLTFTextureTransformExtension {

    constructor() {

        this.name = EXTENSIONS.KHR_TEXTURE_TRANSFORM;

    }

    extendTexture( texture, transform ) {

        if ( transform.texCoord !== undefined ) {

            console.warn( 'THREE.GLTFLoader