## Change Log
[icn3d-3.39.1](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.39.1.zip) was release on December 20, 2024. Collections update - added strucure append and clear commands, fix collections example directory.

[icn3d-3.39.0](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.39.0.zip) was release on November 25, 2024. Collections update - added multi file format support for zip, command history and JSON export, gz&ent file support.

[icn3d-3.38.1](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.38.1.zip) was release on November 14, 2024. Improved the conversion of chemical SMILES to 3D structure by showing double bonds.

[icn3d-3.38.0](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.38.0.zip) was release on November 12, 2024. Enabled to convert chemical SMILES to 3D structure via the menu "File > Retrieve by ID > Chemical SMILES".

[icn3d-3.37.0](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.37.0.zip) was release on October 16, 2024. Added a menu "Style > Clashed Residues > Hide" to hide clashed residues.

[icn3d-3.36.1](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.36.1.zip) was release on October 7, 2024. Fixed an issue related to previous chain IDs such as "A_1" (changed to "A1") in previous sharable links.

[icn3d-3.36.0](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.36.0.zip) was release on October 3, 2024. Allowed to load multiple iCn3D PNG images.

[icn3d-3.35.0](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.35.0.zip) was release on September 12, 2024. Retrieved updated ClinVar annotations directly from NCBI ClinVar database.

[icn3d-3.34.1](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.34.1.zip) was release on August 5, 2024. Switched VAST search alignment from backend to dynamic alignment in iCn3D. 

[icn3d-3.34.0](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.34.0.zip) was release on July 29, 2024. Show atom details for the interaction of one ligand/residue with protein via the menu "Analysis > Interaction" and then the button "2D Interaction for One Ligand/Residue". 

[icn3d-3.33.3](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.33.3.zip) was release on July 15, 2024. Switch electron density data from RCSB DSN6 to PDBe Density Server. 

[icn3d-3.33.2](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.33.2.zip) was release on June 25, 2024. Enabled to measure angles between sets in the menu "Analysis > Angle". 

[icn3d-3.33.1](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.33.1.zip) was release on June 18, 2024. Draw coils for the whole structure with zero radius for the secondary structure parts. 

[icn3d-3.33.0](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.33.0.zip) was release on June 12, 2024. Users can use iCn3D to detect Ig domains for any structures and assign IgStrand reference numbers for each residue. The instruction is at https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d.html#igrefnum.  

[icn3d-3.32.0](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.32.0.zip) was release on May 28, 2024. Allowed to load multiple mmCIF text files, which could contain multiple structures separated by "ENDMDL\n". 

[icn3d-3.31.4](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.31.4.zip) was release on May 11, 2024. Release Ig templates for assigning reference numbers.

[icn3d-3.31.3](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.31.3.zip) was release on April 15, 2024. Jack Lin fixed some issues in loading a collection file.

[icn3d-3.31.2](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.31.2.zip) was release on April 9, 2024. Fixed the secondary structure ranges in CIF files.

[icn3d-3.31.1](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.31.1.zip) was release on March 21, 2024. Switched from "let xArray = atom_site.getColumn('Cartn_x').data" to "let xArray = atom_site.getColumn('Cartn_x')" when accessing data from Binary or text CIF data.

[icn3d-3.31.0](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.31.0.zip) was release on March 21, 2024. Replaced MMTF data with Binary CIF data. Both "mmtfid" and "bcifid" inputs get the Binary CIF data. 

[icn3d-3.30.1](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.30.1.zip) was release on March 11, 2024. Fixed 3D domain summary view.

[icn3d-3.30.0](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.30.0.zip) was release on February 27, 2024. Calculate 3D domains on-the-fly and show 3D domains even when only one domain is available.

[icn3d-3.29.5](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.29.5.zip) was release on February 5, 2024. Added an option to load  MTZ files from RCSB to show electrondensity maps; fixed a bug in saving sets; fixed a bug in the replay of rotating structures with a matrix.

[icn3d-3.29.4](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.29.4.zip) was release on January 19, 2024. Added the options to translate the coordinates (View > Translate XYZ) and rotate the coordinates with a matrix (View > Rotate with Matrix).

[icn3d-3.29.3](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.29.3.zip) was release on January 11, 2024. Fixed the "Sequences & Annotations" view when a collection of structure is loaded.

[icn3d-3.29.2](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.29.2.zip) was release on January 8, 2024. Simplified code to make icn3dnode calls simpler.

[icn3d-3.29.1](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.29.1.zip) was release on December 14, 2023. Allowed users to load a collection of structures via the menu "File > Open File > Collection File". The example collection file is at https://github.com/ncbi/icn3d/blob/master/example/collection.json.

[icn3d-3.29.0](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.29.0.zip) was release on December 13, 2023. Added the feature to load electron density maps from ccp4 or MTZ files either locally or via URLs.

[icn3d-3.28.4](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.28.4.zip) was release on November 7, 2023. Enabled to show DelPhi potential for multiple structures.

[icn3d-3.28.3](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.28.3.zip) was release on October 5, 2023. Fixed the async/await issue for electron density maps and EM density maps.

[icn3d-3.28.2](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.28.2.zip) was release on September 14, 2023. Upgraded three.js to version 151, and improved the image quality.

[icn3d-3.28.1](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.28.1.zip) was release on August 23, 2023. Added logs for menu usages, and updated iCn3D tutorials at https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d.html#videos.

[icn3d-3.28.0](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.28.0.zip) was release on July 31, 2023. Added the feature to show isoforms and exons as tracks with the button "Add Track" in the "Sequences & Annotations" window via the menu "Analysis > Sequences & Annotations". Also displayed pathogenic ClinVars in red and the rest in green in the ClinVar track.

[icn3d-3.27.0](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.27.0.zip) was release on July 13, 2023. Added the feature to search AlphaFold structures with protein/gene names directly in iCn3D via the menu "File > Search Structures > AlphaFold Structures".

[icn3d-3.26.1](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.26.1.zip) was release on July 10, 2023. Fixed a bug in TM-align and updated Python scripts.

[icn3d-3.26.0](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.26.0.zip) was release on June 20, 2023. Added the feature to run  ESMFold on the fly via the menu "File > AlphaFold/ESM > ESMFold" in iCn3D.

[icn3d-3.25.4](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.25.4.zip) was release on June 15, 2023. Fixed the extra side chains of disulfide bonds when the disulfide bonds are not showing; fixed the extra tracks in Sequences & Annotations window.

[icn3d-3.25.3](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.25.3.zip) was release on May 24, 2023. Fixed a bug in Node.js scripts about retrieving data from Ajax calls.

[icn3d-3.25.2](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.25.2.zip) was release on May 17, 2023. Fixed a bug in VAST alignment.

[icn3d-3.25.1](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.25.1.zip) was release on May 3, 2023. Fixed a bug in relaigning structures.

[icn3d-3.25.0](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.25.0.zip) was release on April 26, 2023. To improve the performance of embedding several structures in a single page, added the URL parameter "imageonly=1" to render the structure into a static image instead of interactive 3D view. The image is clickable to launch an interactive 3D view.

[icn3d-3.24.2](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.24.2.zip) was release on April 24, 2023. Fixed the secondary structures of mutant in the mutation analysis; fixed the lower case in the sequences of VAST+ alignment.

[icn3d-3.24.1](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.24.1.zip) was release on April 14, 2023. Added more menus to the VR view of iCn3D to measure distance, toggle highlight, etc.

[icn3d-3.24.0](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.24.0.zip) was release on April 10, 2023. Improved the use of iCn3D in Jupyter Notebook by making the dialogs closable, and adding DelPhi potential and mutation analysis; added DelPhi potential as one option in the Virtual Reality (VR) view of iCn3D.

[icn3d-3.23.3](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.23.3.zip) was release on April 6, 2023. Fixed the VR view when only one controller is available.

[icn3d-3.23.2](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.23.2.zip) was release on April 2, 2023. Added the document at https://pypi.org/project/icn3dpy/ for loading a local/remote PDB file or iCn3D PNG Image into iCn3D in Jupyter Notebook; added both "Load" and "Append" options when launching a structure.

[icn3d-3.23.1](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.23.1.zip) was release on March 22, 2023. Added the feature to scale in AR view of iCn3D; changed the default coloring to "AlphaFold Confidence" when lining from BLAST to iCn3D for AlphaFold structures; added the wildcard symbol "*" for atom name selection.

[icn3d-3.23.0](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.23.0.zip) was release on March 16, 2023. Added more VR features to allow users to select residues, change style and color, and show interactions in VR. When users input PDB/AlphaFold IDs, the structures append to the existing structures. 

[icn3d-3.22.4](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.22.4.zip) was release on March 7, 2023. Fixed the menu "View > Reset > All" for side chains. Added a new Node.js script "interactiondetail.js" to show the interaction details between two chains. 

[icn3d-3.22.3](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.22.3.zip) was release on March 1, 2023. Fixed Node.js scripts cdsearch.js, and also fixed some iCn3D code to make Node.j scripts work.

[icn3d-3.22.2](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.22.2.zip) was release on February 23, 2023. Fixed a bug when the input is NCBI protein accession.

[icn3d-3.22.1](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.22.1.zip) was release on February 17, 2023. Enabled to align a sequence to a protein structure with similar sequence. If the protein accession is not a PDB chain, the corresponding AlphaFold UniProt structure is used. Added a Node.js script to add missing atoms to an exported PDB file.

[icn3d-3.22.0](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.22.0.zip) was release on February 14, 2023. Enabled to export PDB files with missing atoms or with hydrogen; added the option to show Multiple Sequence Alignment (MSA) when realigning multiple chains based on structure alignment.

[icn3d-3.21.3](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.21.3.zip) was release on February 3, 2023. Updated the description about custom reference numbers.

[icn3d-3.21.2](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.21.2.zip) was release on January 20, 2023. Added instructions (https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d.html#saveview) to host iCn3D PNG Images at any web server, which can be accessed by iCn3D, e.g., https://www.ncbi.nlm.nih.gov/Structure/icn3d/?type=icn3dpng&url=https://api.figshare.com/v2/file/download/39125801, or https://www.ncbi.nlm.nih.gov/Structure/icn3d/?type=icn3dpng&url=https://zenodo.org/api/files/1a3325c8-0c84-4f1e-be2c-c143b08c6563/3GVU-XCxR6fSTmXHxR3o1A.png.

[icn3d-3.21.1](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.21.1.zip) was release on January 17, 2023. Fixed a bug in selecting a conserved domain and a bug in the secondary structure display for pdbid input.

[icn3d-3.21.0](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.21.0.zip) was release on January 11, 2023. Mapped PDB residue numbers with NCBI residue numbers; replaced jQuery promise with JavaScript Promise, await, and async.

[icn3d-3.20.1](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.20.1.zip) was release on December 19, 2022. Removed unnecessary import and cleaned some codes.

[icn3d-3.20.0](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.20.0.zip) was release on December 12, 2022. Enabled users to show AlphaFold structures with NCBI RefSeq IDs as input.

[icn3d-3.19.1](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.19.1.zip) was release on December 1, 2022. Fixed bugs in retrieving data with the POST method, in aligning two chains from the same structure, in mutational analysis, and in launching several PDB/AlphaFold IDs.

[icn3d-3.19.0](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.19.0.zip) was release on November 16, 2022. Enabled users to add custom reference residue number with the menu "Analysis > Ref. Number", add (transparent) spheres or cubes for any sets with the menu "Style > Cartoon for a Set", add a line between two sets with the menu "Style > Line btw. Two Sets". Also improved the color legends.

[icn3d-3.18.1](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.18.1.zip) was release on November 8, 2022. Added the annotation "Transmembrane" for PDB or AlphaFold structures based on data from OPM, Membranome, and UniProt; enabled to load a PAE file from a URL in the same domain.

[icn3d-3.18.0](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.18.0.zip) was release on November 3, 2022. Merged Jack Lin's branch with the following new features: show some basic color legends when coloring a structure; add local Smith-Waterman alignment when aligning two sequences; add a preference in the menu "Style > Prefereces" to enlarge the command window.

[icn3d-3.17.0](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.17.0.zip) was release on October 27, 2022. Showed membranes for AlphaFold structures, which are single-spanning transmembrane proteins; enabled to load recent version of PAE json files for AlphaFold Structures.

[icn3d-3.16.3](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.16.3.zip) was release on September 29, 2022. Fixed a bug in VAST chain alignment. Updated the video of iCn3D tutorial. 

[icn3d-3.16.2](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.16.2.zip) was release on September 19, 2022. Enabled to submit loaded structures to VAST and Foldseek to search similar structures directly. 

[icn3d-3.16.1](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.16.1.zip) was release on September 12, 2022. Fixed a bug in VAST+ alignment based on TM-align. 

[icn3d-3.16.0](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.16.0.zip) was release on September 8, 2022. Added dynamic VAST+ based on TM-align for any two structure assemblies in the menus "File > Align > Protein Complexes > Two PDB Structures" and "File > Realign Selection > Protein Complexes". Added the angle restriction for hydrogen bonds back. 

[icn3d-3.15.1](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.15.1.zip) was release on August 18, 2022. Fixed the stickiness of menus and the TM-align output for a subset of residues.

[icn3d-3.15.0](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.15.0.zip) was release on August 16, 2022. Enabled users to switch between "All Menus" and "Simple Menus", or customize the menus and save them in a file to be loaded by others. The customized menus are sticky and saved in cache.

[icn3d-3.14.3](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.14.3.zip) was release on August 12, 2022. Enabled to show 200 million AlphaFold UniProt structures in the recent release.

[icn3d-3.14.2](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.14.2.zip) was release on August 9, 2022. Added the "FAQ" section in the "Help" menu.

[icn3d-3.14.1](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.14.1.zip) was release on August 3, 2022. Enabled to show mutation analysis for currently loaded structures or structures to be loaded with PDB IDs or AlphaFold UniProt IDs in the menu "Analysis > Mutation".

[icn3d-3.14.0](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.14.0.zip) was release on August 1, 2022. Added Post-Translational Modification (PTM) annotation from UniProt.

[icn3d-3.13.2](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.13.2.zip) was release on July 27, 2022. jQuery UI was upgraded from version 1.12.1 to 1.13.2.

[icn3d-3.13.1](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.13.1.zip) was release on July 25, 2022. Split the menu "File > Align > Multiple Chains" into three categories: by Structure Alignment, by Sequence Alignment, and Residue by Residue".

[icn3d-3.13.0](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.13.0.zip) was release on July 21, 2022. In addition to "VAST" alignment, users can also use "TM-align" to align two chains. The feature is available in the menus "File > Align > Multiple Chains" and "File > Realign Selection > by Structure Alignment".

[icn3d-3.12.8](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.12.8.zip) was release on July 15, 2022. Expanded Python scripts to download any output in iCn3D; Added a new Node.js script to retrieve all annotations (e.g., SNP, ClinVar, domain, etc) from iCn3D; added an exmaple to add users' own annotation and hide default annotations at https://github.com/ncbi/icn3d/tree/master/example/addAnnoLocal.html.

[icn3d-3.12.7](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.12.7.zip) was release on July 7, 2022. Fixed the iCn3D view from VAST search.

[icn3d-3.12.6](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.12.6.zip) was release on July 5, 2022. Enabled to load a mmCIF file from a URL in the menu "File > Open File > URL(CORS)".

[icn3d-3.12.5](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.12.5.zip) was release on July 1, 2022. Output the full mutant PDB file in mutation analysis, and fixed the alignment of same chain IDs.

[icn3d-3.12.4](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.12.4.zip) was release on June 21, 2022. Added some basic navigation controls in VR and AR views. In the VR view, users can use the right trigger to move forward and the left trigger to move backward. In the AR view, users can tap once on the screen to locate a minimized 3D structure in the tapped location, and tap twice quickly to scale up the 3D structure.

[icn3d-3.12.3](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.12.3.zip) was release on June 13, 2022. Users now can have Augmented Reality (AR) view on any iCn3D display by clicking the "START AR" button. Currently the AR view is only available to Chrome browser in an Android phone.

[icn3d-3.12.2](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.12.2.zip) was release on June 10, 2022. Made two kinds of transparent surfaces available in the menu "Style > Surface Opacity": "Fast Transparency" and "Slow Transparency".

[icn3d-3.12.1](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.12.1.zip) was release on June 8, 2022. Fixed the bug about exporting iCn3D PNG Image.

[icn3d-3.12.0](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.12.0.zip) was release on June 6, 2022. Users now can have Virtual Reality (VR) view on any iCn3D display; enabled to view multiple sequence alignment (MSA) instead of pairwise alignment; changed the tools in toolbar from buttons to icons; switched to WegGL2 from WebGL1.

[icn3d-3.11.8](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.11.8.zip) was release on May 20, 2022. Enabled to import "icn3d.css" and "three.module.js" from npm icn3d to work with React.

[icn3d-3.11.7](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.11.7.zip) was release on May 18, 2022. Enabled to import "icn3d.module.js" from npm icn3d to work with React.

[icn3d-3.11.6](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.11.6.zip) was release on May 11, 2022. Fixed a bug in the dynamic VAST alignment in iCn3D with the menu "File > Realign Selection > by Structure Alignment".

[icn3d-3.11.5](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.11.5.zip) was release on May 3, 2022. Added VAST+ and VAST Search interface in the menu "File > Search Similar". Enabled to assign rainbow/spectrum colors for a list of sets in the menu "Color > Rainbow/Spectrum > for Sets".

[icn3d-3.11.4](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.11.4.zip) was release on April 26, 2022. Added two examples in https://www.ncbi.nlm.nih.gov/Structure/icn3d/example.html to show the predefined alignment of two PDB files, or the predefined alignment of one PDB file to other chains.

[icn3d-3.11.3](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.11.3.zip) was release on April 22, 2022. Added the menu "Style > Nucl. Bases" to display the bases of nucleotides.

[icn3d-3.11.2](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.11.2.zip) was release on April 18, 2022. Added "[comment]" in front of logs to diferentiate from commands in the command window. If "mmdbid" is the input and the parameter "bu" is not defined, set "bu" as 1 (biological unit).

[icn3d-3.11.1](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.11.1.zip) was release on April 13, 2022. Users can input multiple PDB, MMDB, or AlphaFold IDs with the menu "File > Retrieve by ID > MMDB or AlphaFold IDs". Users can also load multiple PDB files at the same time with the menu "File > Open File > PDB Files (appendable)". The color legend became draggable.

[icn3d-3.11.0](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.11.0.zip) was release on March 28, 2022. Users can align AlphaFold structures or PDB structures with the menu "File > Align > Multiple Chains" or "File > Align > Protein Complexes > Two AlphaFold Structures". Users can also load any structures as usual, then load your custom PDB file with the menu "File > Open File > PDB File (appendable)", then relaign these structures with the menu "File > Realign Selection > by Structure Alignment".

[icn3d-3.10.1](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.10.1.zip) was release on March 9, 2022. Added the color option "Structure" and the style option "Hydrogens". Fixed some bugs on loading PDB files without headers.

[icn3d-3.10.0](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.10.0.zip) was release on March 7, 2022. Showed SNP and ClinVar annotations for AlphaFold structures.

[icn3d-3.9.0](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.9.0.zip) was release on February 28, 2022. Showed 3D domains for AlphaFold structures or any custom structures.

[icn3d-3.8.4](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.8.4.zip) was release on February 22, 2022. Enabled to export the content of any iCn3D dialog/popup window using a Python script in the command line. One example is at https://github.com/ncbi/icn3d/blob/master/icn3dpython/batch_export_panel.py.

[icn3d-3.8.3](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.8.3.zip) was release on February 17, 2022. Another paper about iCn3D was published in Frontiers (https://www.frontiersin.org/articles/10.3389/fmolb.2022.831740/full). Fixed some bugs as well.

[icn3d-3.8.2](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.8.2.zip) was release on February 7, 2022. Enabled to show mutations for AlphaFold structures in the menu "Analysis > Mutation". Fixed the 2D interaction network view of mutations.

[icn3d-3.8.1](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.8.1.zip) was release on January 28, 2022. Upgrade three.js from version 128 to 137 to avoid the security issues related to iframe.

[icn3d-3.8.0](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.8.0.zip) was release on January 27, 2022. Enabled to show the map of AlphaFold Predicted Aligned Error (PAE) on the fly in the menu "File > Retrieve by ID > AlphaFold UniProt ID", and load custom PAE files in the menu "File > Open File > AlphaFold PAE File". Switched the parameter "buidx" to "bu" for asymmetric units and biological units.

[icn3d-3.7.2](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.7.2.zip) was release on January 21, 2022. Now users can see all interactions, common interactions, and different interactions when several structures are aligned and their interactions are shown, e.g., https://www.ncbi.nlm.nih.gov/Structure/icn3d/share.html?9FD78C7YsE9zKyi18.

[icn3d-3.7.1](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.7.1.zip) was release on January 19, 2022. Modified the Node.js example script to use the URL parameter "&bu=0" to get the asymmetric unit data from MMDB. Fixed the fog view when zooming in or out.

[icn3d-3.7.0](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.7.0.zip) was release on January 18, 2022. Now users can see the common interactions in several structures when they are aligned and their interactions are shown. iCn3D now shows asymmetric unit instead of biological unit since asymmetric unit contains all chains. Added the menu "File > Search Structure".

[icn3d-3.6.1](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.6.1.zip) was release on January 11, 2022. Enabled users to change the color for all lables in the menu "Analysis > Label > Change Label Color".

[icn3d-3.6.0](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.6.0.zip) was release on January 7, 2022. Added some example Python scripts in the directory "icn3dpython" to export secondary structures or PNG images. Changed the background color from "transparent/white" to "black".

[icn3d-3.5.1](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.5.1.zip) was release on December 27, 2021. Changed the canvas background color from "black" to "white". The "Style > Background" is still "transparent", but the display will be white by default.

[icn3d-3.5.0](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.5.0.zip) was release on December 21, 2021. Enabled to use the global Smith Waterman algorithm to align a sequence to a structure in the menu "File > Align > Sequence to Structure". Improved the labels by removing the background boxes and adjusting the text color when switching the canvas background color. Simplified the menus when the URL parameter "simplemenu=1" is used.

[icn3d-3.4.13](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.4.13.zip) was release on December 13, 2021. Added the menu "File > Save File > Selection Details" to export selected residues in a human readable format.

[icn3d-3.4.12](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.4.12.zip) was release on November 24, 2021. Fixed some bugs including the selection on 1D sequences in mobile devices.

[icn3d-3.4.11](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.4.11.zip) was release on November 19, 2021. Relaxed the angle restriction on hydrogen bonds and pi-stacking.

[icn3d-3.4.10](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.4.10.zip) was release on November 15, 2021. Fixed the base URL when launching iCn3D from a non-NCBI server.

[icn3d-3.4.9](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.4.9.zip) was release on November 8, 2021. Enabled to export secondary structure information for any subset of any structure, including AlphaFold UniProt structures. The feature is available in the menu "File > Save File > Secondary Structure".

[icn3d-3.4.8](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.4.8.zip) was release on October 22, 2021. Fixed the mapping between PDB residue numbers and NCBI residue numbers for 3D domains, conserved domains, and sites.

[icn3d-3.4.7](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.4.7.zip) was release on October 15, 2021. Fixed the 3D display of a single residue without any secondary structure, and fixed the selection of a chain in the sequence window.

[icn3d-3.4.6](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.4.6.zip) was release on October 6, 2021. Fixed the PDB file export for multiple structures.

[icn3d-3.4.5](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.4.5.zip) was release on September 28, 2021. Showed Conserved Domains for all structures in the Sequences & Annotations window.

[icn3d-3.4.4](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.4.4.zip) was release on September 16, 2021. Users can load multiple structures by appending PDB files with the menu "File > Open File > PDB File (appendable)" to othe PDB files or other structures, which are retrieved by IDs such as "mmdbid" or "mmmtfid". A new color method "Color > Hydrophobicity > Normalized" was added to show hydrophobicity for any residues with different green color.

[icn3d-3.4.3](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.4.3.zip) was release on September 10, 2021. Replaced delphi.fcgi with delphi.cgi.

[icn3d-3.4.2](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.4.2.zip) was release on August 26, 2021. AlphaFold predicted structures can be viewed at iCn3D with the menu "File > Retrieve by ID > AlphaFold UniProt ID". The domain annotation can be displayed by clicking the menu "Analysis > Seq. & Annotations".

[icn3d-3.4.1](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.4.1.zip) was release on August 23, 2021. Added a Python script to export PNG images for any structures in the batch mode. The script is in the directory icn3dnode.

[icn3d-3.4.0](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.4.0.zip) was release on August 19, 2021. Dynamically generate "2D Cartoon" in the chain, domain, or secondary structure levels for selected residues in the menu "Analysis". The cartoons are draggable and clickable.

[icn3d-3.3.5](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.3.5.zip) was release on August 11, 2021. Added a new color method "Rainbow" to show colors ranging from red to violet. This is different from the previous "Spectrum" method, which shows colors ranging from violet to red.

[icn3d-3.3.4](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.3.4.zip) was release on July 28, 2021. The license of scap for side chain prediction was waived by Dr. Barry Honig. Replaced 'var' with 'let' in iCn3D JavaScript files.

[icn3d-3.3.2](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.3.2.zip) was release on July 14, 2021. Now users can choose the color gradient and show the color legend for the "Custom Color" button in the Sequences & Annotations window.

[icn3d-3.3.1](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.3.1.zip) was release on July 7, 2021. Enabled to use as an input a URL containing a saved iCn3D PNG image in the menu "File > Open File > URL (CORS)". Fixed a bug in displaying an assembly with multiple copies of a structure.

[icn3d-3.3.0](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.3.0.zip) was release on June 30, 2021. Added the feature to show contact map for any selected residues in the menu "Analysis > Contact Map".

[icn3d-3.2.3](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.2.3.zip) was release on June 25, 2021. Enabled to set the URL parameter "menuicon" to 1 to show icons for those menus requiring internet access or license.

[icn3d-3.2.2](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.2.2.zip) was release on June 20, 2021. Skipped the secondary structure calculation when the input is a PDB file of nucleotides.

[icn3d-3.2.1](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.2.1.zip) was release on June 18, 2021. Export all classes so that functions in these classes can be manually modified as shown in the file example.html.

[icn3d-3.2.0](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.2.0.zip) was release on June 8, 2021. Added the option to load UniProt ID in the menu "File > Retrieve by ID > UniProt ID".

[icn3d-3.1.6](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.1.6.zip) was release on June 4, 2021. Fixed file export in 3D printing due to the change of Geometry to BufferGeometry in three.js version 128.

[icn3d-3.1.5](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.1.5.zip) was release on June 2, 2021. Added an option to load predefined alignments in the menu "File > Align > Multiple Chains". Enabled to change the shininess, lights, and thickness in the menu "Style > Preferences".

[icn3d-3.1.4](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.1.4.zip) was release on May 27, 2021. Remove "alert" in the npm icn3d package. 

[icn3d-3.1.3](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.1.3.zip) was release on May 25, 2021. Switched residue numbers from integers to strings such as "100A". 

[icn3d-3.1.2](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.1.2.zip) was release on May 17, 2021. iCn3D could hide the features requiring licenses, such as "Analysis > DelPhi Potential" and "Analysis > Mutaion" using the URL parameter "hidelicense=1".

[icn3d-3.1.1](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.1.1.zip) was release on May 10, 2021. Fixed the URL parameters in full.html.

[icn3d-3.1.0](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.1.0.zip) was release on May 7, 2021. Added icn3d.module.js in the build directory. Upgraded three.js from version 103 to version 128. THREE.Geometry was replaced with THREE.BufferGeometry.

[icn3d-3.0.0](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-3.0.0.zip) was release on May 3, 2021. iCn3D version 3.0.0 was converted to ES6 with classes and is available in npm with the package "icn3d". Users can use npm to install icn3d and generate Node.js scripts by calling icn3d functions. All previously embedded iCn3D will not be affected. To embed iCn3D version 3, iCn3D JavaScript and CSS library files were renamed from "icn3d_full_ui" to "icn3d". A global variable "icn3d" was used to access the class iCn3DUI: "var icn3dui = new icn3d.iCn3DUI(cfg)".

[icn3d-2.24.6](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.24.6.zip) was release on March 22, 2021. Broke large files into small ones and stopped upgrading the basic/simple UI.

[icn3d-2.24.5](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.24.5.zip) was release on March 4, 2021. Changed the default 3D view (https://www.ncbi.nlm.nih.gov/Structure/icn3d/index.html) from the basic view (https://www.ncbi.nlm.nih.gov/Structure/icn3d/simple.html) to the advanced view (https://www.ncbi.nlm.nih.gov/Structure/icn3d/full.html).

[icn3d-2.24.4](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.24.4.zip) was release on February 12, 2021. Added an option to save a sharable link with your note/window title in the menu "File > Share Link".

[icn3d-2.24.3](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.24.3.zip) was release on February 9, 2021. Added a few more Node.js scripts in icn3dnode to retrieve ligand-protein and protein-protein interactions, change of interactions, binding site and domain information in the command line.

[icn3d-2.24.2](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.24.2.zip) was release on February 3, 2021. Enabled to show multiple mutations together in the menu "Analysis > Mutation". 

[icn3d-2.24.1](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.24.1.zip) was release on February 1, 2021. Enabled to show multiple mutations together ( https://www.ncbi.nlm.nih.gov/Structure/icn3d/share.html?tKz5GiA2pTVQEWwy6). Fixed the alternation in multiple chain alignment. 

[icn3d-2.24.0](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.24.0.zip) was release on January 27, 2021. Converted the interaction part of iCn3D to Node.js (in the directory icn3dnode) to allow batch-mode analysis. Expanded the chain-chain alignment to multiple chain alignment in the menu "File > Align > Multiple Chains". You could focus on part of the chains for the multiple chain alignment.

[icn3d-2.23.2](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.23.2.zip) was release on January 8, 2021. Adjust the chain IDs according to the data from the backend cgi that aligns a sequence to a structure. 

[icn3d-2.23.1](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.23.1.zip) was release on January 6, 2021. Added version number and improved Principle Axes view. 

[icn3d-2.23.0](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.23.0.zip) was release on December 22, 2020. Use PDB residue numbers when the input is MMDB ID. 

[icn3d-2.22.2](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.22.2.zip) was release on December 15, 2020. Enabled to show secondary structures for a PDB file containing multiple structures. 

[icn3d-2.22.1](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.22.1.zip) was release on December 1, 2020. Added cartoons for glycan display by default. The cartoons can be toggled in the menu "Style > Glycans". 

[icn3d-2.22.0](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.22.0.zip) was release on November 24, 2020. Users now can alternate  wild type and mutant, and their interaction networks in 3D for each SNP/ClinVar in the "Sequences & Annotation" window. 

[icn3d-2.21.0](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.21.0.zip) was release on November 17, 2020. Symmetry can be calculated dynamically for selected residues using SymD. The menu is at "Analysis > Symmetry (SymD, dynamic)". Speeded up the loading of VAST+ structure alignment.

[icn3d-2.20.2](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.20.2.zip) was release on October 29, 2020. Fixed the DelPhi potential map in VAST+ alignment. Added back the usage tracking.

[icn3d-2.20.1](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.20.1.zip) was release on October 13, 2020. Reverted the label scale to 0.3. Updated the LICENSE.

[icn3d-2.20.0](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.20.0.zip) was release on October 6, 2020. Users can show electrostatic potential on surface or as equipotential map for any subsets of proteins/nucleotides/membrane/ligands. The PQR file (modified PDB file with partial charges and radii) can also be downloaded. The display of helices, tubes, and axes were improved. Users can change the helix display at the menu "Style > Two-color Helix".

[icn3d-2.19.1](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.19.1.zip) was release on September 15, 2020. Added shade to 3D display using multiple lights.

[icn3d-2.19.0](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.19.0.zip) was release on August 12, 2020. DelPhi potential map can be displayed for PDB structures at "Analysis > DelPhi Potential". The PDB file can be loaded in the URL with "pdbid=" or at "File > Open File". The DelPhi potential file can be calculated at DelPhi Web Server and be exported as a Cube file. The potential file can be accessed in a URL if it is located in the same host as iCn3D.

[icn3d-2.18.4](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.18.4.zip) was release on August 10, 2020. Fixed bugs in recently modified dropdown menus.

[icn3d-2.18.3](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.18.3.zip) was release on August 3, 2020. Moved "H-Bonds & Interactions" to "Analysis" menu and merged "Windows" menu with "Analysis" menu. Changed the default dialog color to blue. Users can change it at the menu "Style > Dialog Color".

[icn3d-2.18.2](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.18.2.zip) was release on July 28, 2020. Use strict mode and shrink code size.

[icn3d-2.18.1](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.18.1.zip) was release on July 23, 2020. Fixed the issue in the Jupyter Notebook widget icn3dpy; fixed the synchronized issue of the function show3DStructure().

[icn3d-2.18.0](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.18.0.zip) was release on July 20, 2020. Showed SNPs for SARS-CoV-2 proteins; generated icn3dpy (the Jupyter Notebook widget of iCn3D) at https://pypi.org/project/icn3dpy; added "2D Interaction Map" in the menu "View > H-Bonds & Interactions"; added the shrink/expand icon in each orange dialog/window.

[icn3d-2.17.7](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.17.7.zip) was release on July 7, 2020. Added iCn3D tutorial videos and slides.

[icn3d-2.17.6](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.17.6.zip) was release on June 29, 2020. All "Share Link" URLs can show the original view using the archived version of iCn3D at "File > Open File > Share Link URL in Fixed Ver.".

[icn3d-2.17.5](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.17.5.zip) was release on June 26, 2020. Made a versioned full_[version].html file so that "Share Link" URL could point to a fixed version by replacing "full.html" with "full_[version].html".

[icn3d-2.17.4](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.17.4.zip) was release on June 24, 2020. Users now can select options for cross structure interaction in alignment. Get ClinVar annotations from database.

[icn3d-2.17.3](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.17.3.zip) was release on June 18, 2020. Added the track "Cross-Linkages" for glycans, etc.

[icn3d-2.17.2](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.17.2.zip) was release on June 17, 2020. Added pinger to log usage.

[icn3d-2.17.1](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.17.1.zip) was release on June 15, 2020. Enabled to accept RID from BLAST result page.

[icn3d-2.17.0](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.17.0.zip) was release on June 12, 2020. Users can now show "2D Interaction Graph" and also "Highlight Interactions in Table" in the menu "View > H-Bonds & Interactions". Users can also replay the share link step by step to learn how to generate a custom display in the menu "File > Replay Each Step".

[icn3d-2.16.4](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.16.4.zip) was release on June 8, 2020. Enabled to turn force off in 2D Graph so that users can manually arrange the nodes.

[icn3d-2.16.3](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.16.3.zip) was release on June 5, 2020. Added halogen bonds, pi-cation, and pi-stacking interactions in the menu "View > H-Bonds & Interaction" and showed the interactions in sorted tables.

[icn3d-2.16.2](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.16.2.zip) was release on May 29, 2020. Added the following features: 1. save contents in any dialog/window using the save icon next to the closeicon, 2. set names for each tab/window using the menu "Windows > Your Note / Window Title", 3. select by property (such as residue type, solvent accessibilty, etc) in the "Select" menu, 4. Use a custom file to define the color or tube size for each residue by clicking the button "Custom Color / Tube" in the "Sequences & Annotations" window.

[icn3d-2.16.1](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.16.1.zip) was release on May 27, 2020. Enabled to show gaps when adding multiple sequence alignment data as tracks. 

[icn3d-2.16.0](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.16.0.zip) was release on May 21, 2020. Enabled to show interactions using force-directed graph in the menu "View > H-Bonds & Interactions > Force-Directed Graph". Enabled to calculate Solvent Accessible Surface Area (SASA) in the menu "View > Surface Area", or color by SASA in the menu "Color > Solvent Accessibility". Fixed ClinVar and SNP annotations.

[icn3d-2.15.3](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.15.3.zip) was release on May 8, 2020. Enabled to update the short "Share Link" URL; enabled to save in a sharable URL the "Side by Side" view, which is useful to view two aligned structures.

[icn3d-2.15.2](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.15.2.zip) was release on May 5, 2020. Fixed the display of electron density map and EM map.

[icn3d-2.15.1](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.15.1.zip) was release on April 27, 2020. Improved the unionHash function to speed up selection. Improved the message when loading a list of commands.

[icn3d-2.15.0](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.15.0.zip) was release on April 21, 2020. Enabled to show the same structure "Side by Side" in two views in the "View" menu. Each view has the same orientation, but can have independent 3D display. Enabled to add multiple sequence alignments as tracks when clicking "Add Track" in the "Sequences & Annotations" window. Added "Hide Selection" in the "View" menu. Improved selection on "H-Bonds & Interactions". Improved the UI for "Realign Selection" in the "File" menu. The gallery shows COVID-19-related structures at the top. 

[icn3d-2.14.0](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.14.0.zip) was release on April 15, 2020. Added the features to load Electron Density data in the menu "File > Open File > Electron Density", resize the 3D window, realign two structures in the menu "File > Realign", color residues with custom colors in the menu "Color > Residue > Custom", and add custom colors when aligning a sequence to a structure.

[icn3d-2.13.1](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.13.1.zip) was release on March 26, 2020. Showed membranes for transmembrane proteins in VAST+ alignment.

[icn3d-2.13.0](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.13.0.zip) was release on March 23, 2020. Added the "Symmetry" feature in the View menu.

[icn3d-2.12.1](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.12.1.zip) was release on March 12, 2020. Fixed a bug on hydrogen bonds between residues with the same residue number but different chain names. Removed duplicated names in the menu of "Defined Sets".

[icn3d-2.12.0](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.12.0.zip) was release on March 2, 2020. Enabled to realign selected residues in VAST+ structure alignment. The option "Realign Selection" is in the View menu.

[icn3d-2.11.5](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.11.5.zip) was release on Fearuary 11, 2020. Add colors to aligned sequence track based on Blosum62.

[icn3d-2.11.4](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.11.4.zip) was release on January 14, 2020. The compiling tool gulp was upgraded to version 4.

[icn3d-2.11.3](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.11.3.zip) was release on January 7, 2020. A bug was fixed to have predefined sets available for hydrogen bonds/interations.

[icn3d-2.11.2](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.11.2.zip) was release on December 20, 2019. Added the style Backbone and added 'use strict' to each function.

[icn3d-2.11.1](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.11.1.zip) was release on December 19, 2019. Fixed a bug in chain alignment due to the introduction of membranes.

[icn3d-2.11.0](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.11.0.zip) was release on December 16, 2019. Enabled to show membranes for transmembrane proteins for data from PDB or MMDB by aligning the coordinates to the data from Orientations of Proteins in Membranes (OPM) database. Users could adjust the location of the membrane as well.

[icn3d-2.10.1](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.10.1.zip) was release on December 9, 2019. Enabled to select the currently displayed set in the Select menu and fixed some bugs on H-Bonds & Interactions.

[icn3d-2.10.0](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.10.0.zip) was release on December 5, 2019. Enabled to show each hydrogen bond and contact in 3D using the menu "View > H-Bonds & Interactions".

[icn3d-2.9.2](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.9.2.zip) was release on November 18, 2019. Added Transmembrane track if the input is opmid. Added angle constraint for hydrogen bonds.

[icn3d-2.9.1](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.9.1.zip) was release on November 14, 2019. Enable to select regions between two X-Y membranes for transmembrane proteins.

[icn3d-2.9.0](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.9.0.zip) was release on November 8, 2019. Display membranes for transmembrane proteins using data from Orientations of Proteins in Membranes (OPM). The feature is at "File > Retrieve by ID > OPM PDB ID".

[icn3d-2.8.3](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.8.3.zip) was release on November 5, 2019. Display/output salt bridges; color helices and sheets with spectrum in the menu "Color > Secondary > Spectrum".

[icn3d-2.8.2](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.8.2.zip) was release on October 29, 2019. Reduced the size of three.js (version 103) library. Added links to dbSNP in the mouseover texts of SNP annotations.  

[icn3d-2.8.1](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.8.1.zip) was release on October 21, 2019. Fixed the 2D interaction display in structure alignment. The bug was introduced in the last release.  

[icn3d-2.8.0](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.8.0.zip) was release on October 10, 2019. Allowed to align any chain to another chain in the menu "File > Align > Chain to Chain".  

[icn3d-2.7.19](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.7.19.zip) was release on September 9, 2019. Fixed the input width and height with "%". 

[icn3d-2.7.18](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.7.18.zip) was release on September 4, 2019. Added the option to view in Full Screen mode by clicking the expansion icon in the top-right corner when "mobilemenu" is turned on, or by clicking "Full Screen" in the View menu. 

[icn3d-2.7.17](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.7.17.zip) was release on September 3, 2019. Made it easy to save interactive work by clicking "File > Save File > iCn3D PNG Images". This saves both "iCn3D PNG Image" and an HTML file with a clickable PNG image, which is link to the custom display via a sharable link. 

[icn3d-2.7.16](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.7.16.zip) was release on August 29, 2019. Fixed the transparent display by switching three.js from version 107 to 103. 

[icn3d-2.7.15](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.7.15.zip) was release on August 21, 2019. Added an example page to embed multiple iCn3D viewers in one page. 

[icn3d-2.7.14](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.7.14.zip) was release on August 21, 2019. Enabled the mobile style menu with the URL parameter "mobilemenu=1". 

[icn3d-2.7.13](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.7.13.zip) was release on August 14, 2019. Fixed the calculations on contacting atoms by considering the centers of atoms and not radii of atoms. Minimized the code size by retrieving some rarely used code on the fly. 

[icn3d-2.7.12](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.7.12.zip) was release on August 8, 2019. The backend to retrieve ClinVar annotation was fixed.

[icn3d-2.7.11](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.7.11.zip) was release on August 6, 2019. Added "Label Scale" in the View menu to scale all labels.

[icn3d-2.7.10](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.7.10.zip) was release on August 5, 2019. Improved the display of binding sites with fog and slab.

[icn3d-2.7.9](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.7.9.zip) was release on August 1, 2019. Fixed the effect of Fog on sticks and spheres.

[icn3d-2.7.8](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.7.8.zip) was release on July 31, 2019. Fixed SNP annotation in the sequences and annotations window.

[icn3d-2.7.7](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.7.7.zip) was release on July 30, 2019. Added the option to show or hide hydrogens when displaying PubChem compounds.

[icn3d-2.7.6](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.7.6.zip) was release on July 18, 2019. Enabled to show disulfide bonds when a custom pdb file is input; added the option to output pairs for disulfide bonds, hydrogen bonds, and interacting/contacting residues by distance.

[icn3d-2.7.5](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.7.5.zip) was release on July 16, 2019. Added a Gallery section. Fixed the picking and centering issues in some Mac computers. Optimized the width and height of embedded iCn3D viewer.

[icn3d-2.7.4](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.7.4.zip) was release on July 8, 2019. Included Miniland1333's fix on clickTab for the basic display; auto-detected lipids and treated them as chemicals; improved the display of modified PDB files; mouseover showed the structure names when there are more than one structures.

[icn3d-2.7.3](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.7.3.zip) was release on June 6, 2019. Improved the display of transparent surfaces.

[icn3d-2.7.2](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.7.2.zip) was release on June 5, 2019. Fixed the display of transparent surfaces.

[icn3d-2.7.1](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.7.1.zip) was release on June 3, 2019. Fixed the sequence display when there are insertion codes or missing coordinates.

[icn3d-2.7.0](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.7.0.zip) was release on May 20, 2019. "Share Link" can be used to reproduce a custom display when the input is a known ID. "iCn3D PNG Image" can be saved and opened in the File menu to reproduce a custom display for all cases, even when the input is a PDB file or other files.

[icn3d-2.6.6](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.6.6.zip) was release on May 16, 2019. The sequence display was fixed when the input is a MMTF ID or a mmCIF ID.

[icn3d-2.6.5](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.6.5.zip) was release on May 14, 2019. The sequence display was fixed when the input is a pdb file.

[icn3d-2.6.4](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.6.4.zip) was release on April 29, 2019. jQuery was upgraded to version 3.4.0.

[icn3d-2.6.3](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.6.3.zip) was release on April 23, 2019. Showed SNP annotations for more 3D structures.

[icn3d-2.6.2](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.6.2.zip) was release on April 15, 2019. Enabled to show large structure such as HIV-1 capsid (3J3Q): (https://www.ncbi.nlm.nih.gov/Structure/icn3d/?mmtfid=3j3q).

[icn3d-2.6.1](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.6.1.zip) was release on April 1, 2019. Enabled to link from BLAST result page to iCn3D.

[icn3d-2.6.0](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.6.0.zip) was release on March 19, 2019. Users can now align any sequence to a hit structure by clicking "Align > Sequence to Structure" in the File menu. The default color scheme is color by sequence "Conservation" for sequence-structure or structure-structure alignments.

[icn3d-2.5.3](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.5.3.zip) was release on March 12, 2019. Added commands for up arraow and down arrow after picking a residue. 

[icn3d-2.5.2](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.5.2.zip) was release on March 5, 2019. The style Lines was fixed by replacing THREE.Line with THREE.LineSegments. 

[icn3d-2.5.1](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.5.1.zip) was release on February 14, 2019. Change log was moved to the file CHANGELOG.md. Share Link was changed from https://d55qc.app.goo.gl/### to https://icn3d.page.link/###. All previous share links still work. iCn3D library file was renamed from full_ui_all_#.#.#.min.js to icn3d_full_ui_#.#.#.min.js. Both files are available to make it backward compatible. 

[icn3d-2.5.0](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.5.0.zip) was release on January 31, 2019. Updated Three.js from version 80 to version 99. Enabled the basic version (simple_ui_all.min.js) to hide the Tools menu and title. Fixed a bug in picking an atom for distance or labeling.

[icn3d-2.4.3](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.4.3.zip) was release on January 22, 2019. Non-standard proteins or nucleotides were still displayed as "Biopolymer" in 2D interactions and were displayed in the style of protein or nucleotide in 3D. The usage tracking was implemented in iCn3D.

[icn3d-2.4.2](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.4.2.zip) was release on January 16, 2019. Non-standard proteins or nucleotides were displayed as "Biopolymer" in 2D interactions and were displayed in the style of "Stick" in 3D. A new kind of annotation "Disulfie Bonds" was added to the "Sequences and Annotations" window.

[icn3d-2.4.1](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.4.1.zip) was release on January 7, 2019. Enabled users to show EM density map for any subset of an EM structure.

[icn3d-2.4.0](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.4.0.zip) was release on December 17, 2018. Enabled users to show electron density map for any subset of a crystal structure.

[icn3d-2.3.4](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.3.4.zip) was release on December 12, 2018. Enabled users to load a saved iCn3D PNG image into iCn3D to reproduce the display using the URL embedded in the image.

[icn3d-2.3.3](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.3.3.zip) was release on December 6, 2018. Made the list of interacting residues consistent in "File -> Save File -> Interaction List" and in the "Sequences and Annotations" window.

[icn3d-2.3.2](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.3.2.zip) was release on October 30, 2018. Water molecules were enabled to be shown when the structure is not a biological assembly. Gene symbols were shown for each chain in the "Sequences and Annotations" window.

[icn3d-2.3.1](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.3.1.zip) was release on October 25, 2018. The color of the the first residue in a coil was fixed.

[icn3d-2.3.0](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.3.0.zip) was release on October 18, 2018. Added set operations (union,intersection, exclusion) in "Defined Sets"; added buttons "Helix Sets" and "Sheet Sets" in the "Sequences and Annotations" window to define helix sets and sheet sets in the window "Defined Sets"; added "Save Color" and "Apply Saved Color" in the menu "Color"; added "Save Style" and "Apply Saved Style" in the menu "Style"; added "Side Chains" in the menu "Select" to select side chains; added two options for color by "Secondary" structures: "Sheets in Green" and "Sheets in Yellow"; added color by "B-factor" that is normalized with "Original" values or "Percentile" values.

[icn3d-2.2.5](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.2.5.zip) was release on September 17, 2018. A bug in loading local PDB file was fixed.

[icn3d-2.2.4](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.2.4.zip) was release on September 6, 2018. The location of 2D interaction dialog was optimized.

[icn3d-2.2.3](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.2.3.zip) was release on August 30, 2018. Added an option to show N- and C-terminal labels.

[icn3d-2.2.2](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.2.2.zip) was release on August 9, 2018. Defined sets can be combined using "or", "and", and "not".

[icn3d-2.2.1](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.2.1.zip) was release on August 3, 2018. Mouseover on the 3D structure shows the residue or atom name. Some Ajax calls are combined into one Ajax call.

[icn3d-2.2.0](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.2.0.zip) was release on July 30, 2018. The smoothing algorithm was switched from Catmull-Rom spline to cubic spline to make the curves more smooth. The thickness of ribbon was decreased to make the sides of the ribbons less apparent. The radio buttons in the menus was replaced by the check sign. A "Save Image" button was added in the "Toolbar".

[icn3d-2.1.8](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.1.8.zip) was release on July 12, 2018. Checked the code with the strict mode.

[icn3d-2.1.7](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.1.7.zip) was release on June 28, 2018. Simplified the addition of custom text as a track in the Sequences and Annotations window.

[icn3d-2.1.6](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.1.6.zip) was release on June 21, 2018. A color picker was added to the color menu.

[icn3d-2.1.5](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.1.5.zip) was release on June 18, 2018. 3D printing are enabled for biological assemblies.

[icn3d-2.1.4](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.1.4.zip) was release on June 7, 2018. The retrieval of transformation matrix from mmCIF was fixed for Mac.

[icn3d-2.1.3](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.1.3.zip) was release on May 30, 2018.  "Sequences and Annotations" is now able to be highlighted even if some annotations didn't show up.

[icn3d-2.1.2](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.1.2.zip) was release on May 23, 2018. The surface display was improved by adding light reflection. Light was added to the display of instanced biological assemblies.

[icn3d-2.1.1](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.1.1.zip) was release on May 22, 2018. The option of color by "Spectrum" was added back.

[icn3d-2.1.0](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.1.0.zip) was release on May 21, 2018. The instancing method is used to display a biological assembly. It significantly improved the rendering speed by sending only the geometry of its assymmetruic unit to GPU and applying transformation matrices to display the assembly.

[icn3d-2.0.3](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.0.3.zip) was release on May 2, 2018. Removed the "Description" field when saving a set of atoms. This made "Share Link" URL shorter. Made the size of stabilizer thicker for 3D printing.

[icn3d-2.0.2](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.0.2.zip) was release on April 30, 2018. Reset WebGLRenderer when WebGL context is lost in Internet Explore 11.

[icn3d-2.0.1](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.0.1.zip) was release on April 23, 2018. The bug about extra 3D domains in the "Sequences & Annotations" window was fixed. The stabilizers for 3D printing were improved.

[icn3d-2.0.0](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-2.0.0.zip) was release on April 17, 2018. By clicking the menu "Windows: View Sequences & Annotations", users can view all kinds of annotations: ClinVar, SNPs, CDD domains, 3D domains, binding sites, interactions, and custom tracks. Users can click the menu "View: Chemical Binding" to show the chemical binding sites. Users can also export files for 3D printing at the menu "File: 3D Printing: VRML (Color, W/ Stabilizers)".

[icn3d-1.4.1](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-1.4.1.zip) was release on November 3, 2017. The version of THREE.js in the zip file was fixed.

[icn3d-1.4.0](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-1.4.0.zip) was release on November 2, 2017. The rendering speed has been significantly improved by using the Imposter shaders from NGL Viewer. A bug in "Share Link" was fixed.

[icn3d-1.3.10](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-1.3.10.zip) was release on October 27, 2017. The "Save File" issue in Chrome 60 and after was fixed.

[icn3d-1.3.9](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-1.3.9.zip) was release on September 5, 2017. The handling of residues with insertion codes was fixed in structure alignment.

[icn3d-1.3.8](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-1.3.8.zip) was release on August 7, 2017. The handling of residues with insertion codes was fixed.

[icn3d-1.3.7](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-1.3.7.zip) was release on April 18, 2017. A bug in the output order of commands was fixed.

[icn3d-1.3.6](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-1.3.6.zip) was release on April 10, 2017. A bug introduced in the version of icn3d-1.3.5 was fixed in the function unionHash.

[icn3d-1.3.5](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-1.3.5.zip) was release on March 23, 2017. The codes were optimized to show 3D structures as soon as possible. Vast+ structure alignment was optimized as well.

[icn3d-1.3.4](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-1.3.4.zip) was release on March 1, 2017. The backend of structure alignment was updated.

[icn3d-1.3.3](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-1.3.3.zip) was release on November 15, 2016. Now users can save the image with "transparent" background using a single url, e.g., [](https://www.ncbi.nlm.nih.gov/Structure/icn3d/?mmdbid=1tup&width=300&height=300&command=set%20background%20transparent;%20export%20canvas)https://www.ncbi.nlm.nih.gov/Structure/icn3d/?mmdbid=1tup&width=300&height=300&command=set%20background%20transparent;%20export%20canvas.

[icn3d-1.3.2](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-1.3.2.zip) was release on October 18, 2016. The atom specification in "Advanced set selection" was modified to use "$" instead of "#" in front of structure IDs. This modification avoids to the problem of showing multiple "#" in the urls of "Share Link".

[icn3d-1.3.1](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-1.3.1.zip) was release on October 4, 2016. Partial diplay of helices or beta-sheets are enabled. The side chains, if displayed, are connected to C-alphas.

[icn3d-1.2.3](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-1.2.3.zip) was release on September 13, 2016. The MMTF format started to support https.

[icn3d-1.2.2](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-1.2.2.zip) was release on August 18, 2016. Added a switch button to switch between all atoms and selected atoms. When the mode is "selected atoms", the switch and the text "selection" next to it are colored in orange. The menu "Style", "Color", and "Surface" are colored in orange and only apply to selected atoms.

[icn3d-1.2.1](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-1.2.1.zip) was release on August 18, 2016. Some bugs were fixed.

[icn3d-1.2.0](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-1.2.0.zip) was release on August 17, 2016. The dialog of 2D interactions was added to show the interactions among different chains. Both the nodes (chains) and lines (interactions) can be selected. Secondary structures will be calculated if the input PDB file has no defined secondary structure information. The previous files src/icn3d.js, src/full_ui.js, and src/simple_ui.js were separated into small files.

[icn3d-1.1.1](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-1.1.1.zip) was release on July 25, 2016. Some bugs were fixed.

[icn3d-1.1.0](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-1.1.0.zip) was release on July 18, 2016. The new binary MMTF file format was supported. A new "Analysis" menu was added with an option to show disulfide bonds. Users can also input data from a url, either through the UI or through a encoded url parameter "?type=pdb&url=...", e.g., [](https://www.ncbi.nlm.nih.gov/Structure/icn3d/?type=pdb&url=https%3A%2F%2Ffiles.rcsb.org%2Fview%2F1gpk.pdb)https://www.ncbi.nlm.nih.gov/Structure/icn3d/?type=pdb&url=https%3A%2F%2Ffiles.rcsb.org%2Fview%2F1gpk.pdb.

[icn3d-1.0.1](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-1.0.1.zip) was release on May 16, 2016.

[icn3d-1.0.0](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-1.0.0.zip) was release on April 28, 2016.

The beta version [icn3d-0.9.6-dev](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-0.9.6-dev.zip) was release on April 21, 2016. Enabled to export and import selection file where each custom sets of atoms are defined. Javascript files and CSS files are versioned. Developers can use the default latest version or specify the specific version in their pages.

The beta version [icn3d-0.9.5-dev](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-0.9.5-dev.zip) was release on April 4, 2016. Enabled to import Mol2, SDF, XYZ, PDB, and mmCIF files. Added "Schematic" style for chemicals. Improved the coordination between pk on 3D structure and selection on sequences.

The beta version [icn3d-0.9.4-dev](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-0.9.4-dev.zip) was release on March 14, 2016. Added "Fog" and "Slab" features.

The beta version [icn3d-0.9.3-dev](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-0.9.3-dev.zip) was release on March 9, 2016. Improved the following features: "Back" and "Forward" button, Export State, Open State.

The beta version [icn3d-0.9.2-dev](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-0.9.2-dev.zip) was release on March 4, 2016. CSS namespace was added. The file simple_ui.js was reorganized to share some codes with full_ui.js. A "Schematic" style was added to show one letter residue name in the C-alpha (for protein) or O3' (for nucleotide) position.

The beta version [icn3d-0.9.1-dev](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-0.9.1-dev.zip) was release on Feb 9, 2016. The surface generation was switched from the iview version (surface.js) to the more efficient 3Dmol version (ProteinSurface4.js and marchingcube.js).

The beta version [icn3d-0.9.0-dev](https://www.ncbi.nlm.nih.gov/Structure/icn3d/icn3d-0.9.0-dev.zip) was release on Jan 17, 2016.

