<p align="center">
    <img src="https://github.com/natenho/Mockaco/raw/master/src/Mockaco/Resources/mockaco-logo.svg" width="96px" height="96px" alt="Mockaco">
</p>

# Mockaco

[![Main Build](https://github.com/natenho/Mockaco/actions/workflows/main-release.yml/badge.svg)](https://github.com/natenho/Mockaco/actions/workflows/main-release.yml) [![Docker Pulls](https://img.shields.io/docker/pulls/natenho/mockaco)](https://hub.docker.com/repository/docker/natenho/mockaco) [![Nuget](https://img.shields.io/nuget/dt/Mockaco?color=blue&label=nuget%20downloads)](https://www.nuget.org/packages/Mockaco/) [![FOSSA Status](https://app.fossa.com/api/projects/git%2Bgithub.com%2Fnatenho%2FMockaco.svg?type=shield)](https://app.fossa.com/projects/git%2Bgithub.com%2Fnatenho%2FMockaco?ref=badge_shield)

Mockaco is an HTTP-based API mock server with fast setup.

## Features

- **Simple JSON-based Configuration**: Configure your mocks easily using a simple JSON format.
- **Pure C# Scripting**: Configure your mocks using C# scripting without the need to learn a new language or API.
- **Delay Simulation**: Simulate network delays to test how your system handles timeouts and latency.
- **Fake Data Generation**: Generate realistic fake data using the built-in functionality.
- **Callback (Webhook) Support**: Trigger another service call when a request hits your mocked API.
- **Verification**: Verify if a specific mock was called during testing to ensure expected interactions.
- **State Support**: Create stateful mocks that return responses based on global variables previously set by other mocks.
- **Portability**: Run the mock server in [any environment supported by .NET](https://github.com/dotnet/core/blob/main/release-notes/6.0/supported-os.md).

## Get Started

Access the documentation on <strong>[natenho.github.io/Mockaco](https://natenho.github.io/Mockaco/)</strong>

[![Mocking APIs with Mockaco | .NET 7](https://user-images.githubusercontent.com/4236481/195997781-b730959e-8d6d-432c-b35a-3adb580abc41.png)](https://www.youtube.com/watch?v=QBnXCgZFzM0 "Mocking APIs with Mockaco | .NET 7")

## License
[![FOSSA Status](https://app.fossa.com/api/projects/git%2Bgithub.com%2Fnatenho%2FMockaco.svg?type=large)](https://app.fossa.com/projects/git%2Bgithub.com%2Fnatenho%2FMockaco?ref=badge_large)

---

*Icon made by [Freepik](https://www.freepik.com/ "Freepik") from [www.flaticon.com](https://www.flaticon.com/ "Flaticon") is licensed by [CC 3.0 BY](http://creativecommons.org/licenses/by/3.0/ "Creative Commons BY 3.0")*

