output "cluster_endpoint" {
  description = "Endpoint for EKS control plane."
  value       = module.eks.cluster_endpoint
}

output "cluster_security_group_id" {
  description = "Security group ids attached to the cluster control plane."
  value       = module.eks.cluster_security_group_id
}

output "kubectl_config" {
  description = "kubectl config as generated by the module."
  value       = module.eks.kubeconfig
}

output "config_map_aws_auth" {
  description = "A kubernetes configuration to authenticate to this EKS cluster."
  value       = module.eks.config_map_aws_auth
}

output "region" {
  description = "AWS region."
  value       = data.aws_region.current.name
}

output "aws_kubeconfig_command" {
  description = "AWS cli command to get kubeconfig"
  value = "aws eks --region ${data.aws_region.current.name} update-kubeconfig --name ${var.prefix}"
}

output "helm_upgrade_command" {
  description = "run helm upgrade"
  value = "helm upgrade --install nasqar nasqar  --set image.tag=$CIRCLE_SHA1 --set efsProvisioner.efsFileSystemId=${aws_efs_file_system.nasqar.id} --set efsProvisioner.path=/ --set efsProvisioner.awsRegion=$REGION --set efsProvisioner.dnsName=${aws_efs_file_system.nasqar.dns_name}"
}