package zelix.longdecrypter;

import java.util.concurrent.ConcurrentHashMap;

/**
 * Decrypter that uses shared {@link SimpleLongDecrypter#mutableEncryptionInts}. This decrypter is only used when it
 * cannot find registered decryption for given numbers.
 * {@link FallbackLongDecrypter#decrypt(long)} is never called in untouched jar obfuscated using zelix. When
 * {@link FallbackLongDecrypter#decrypt(long)} is called (which is an error) then it intentionally breaks every other
 * decrypter, by overriding their {@link SimpleLongDecrypter#getEncryptionInts()}, making them unusable.
 * <p>
 * This decrypter only exists here to make it harder to deobfuscate the jar and to confuse people that try to deobfuscate it.
 */
public class FallbackLongDecrypter implements ILongDecrypter {
  private static boolean e;
  private static FallbackLongDecrypter INSTANCE = new FallbackLongDecrypter();
  private ConcurrentHashMap<ILongDecrypter, ILongDecrypter> decrypterToDecrypterMap = new ConcurrentHashMap<>();
  private ILongDecrypter child;
  private int[] encryptionInts;
  private long key;

  public FallbackLongDecrypter() {
    this.initCachedDecryptersMap();
    this.encryptionInts = new int[64];
    this.encryptionInts[0] = -47;
    this.encryptionInts[1] = -37;
    this.encryptionInts[2] = -2;
    this.encryptionInts[3] = -48;
    this.encryptionInts[4] = 2;
    this.encryptionInts[5] = -45;
    this.encryptionInts[6] = -54;
    this.encryptionInts[7] = -50;
    this.encryptionInts[8] = -23;
    this.encryptionInts[9] = -12;
    this.encryptionInts[10] = -35;
    this.encryptionInts[11] = -4;
    this.encryptionInts[12] = -28;
    this.encryptionInts[13] = -42;
    this.encryptionInts[14] = -12;
    this.encryptionInts[15] = 4;
    this.encryptionInts[16] = -7;
    this.encryptionInts[17] = -26;
    this.encryptionInts[18] = -44;
    this.encryptionInts[19] = -14;
    this.encryptionInts[20] = -36;
    this.encryptionInts[21] = 12;
    this.encryptionInts[22] = -32;
    this.encryptionInts[23] = 7;
    this.encryptionInts[24] = -12;
    this.encryptionInts[25] = -4;
    this.encryptionInts[26] = 12;
    this.encryptionInts[27] = -3;
    this.encryptionInts[28] = -30;
    this.encryptionInts[29] = 4;
    this.encryptionInts[30] = 3;
    this.encryptionInts[31] = 23;
    this.encryptionInts[32] = -3;
    this.encryptionInts[33] = 14;
    this.encryptionInts[34] = -29;
    this.encryptionInts[35] = 3;
    this.encryptionInts[36] = 12;
    this.encryptionInts[37] = -7;
    this.encryptionInts[38] = 37;
    this.encryptionInts[39] = -10;
    this.encryptionInts[40] = 28;
    this.encryptionInts[41] = -7;
    this.encryptionInts[42] = -11;
    this.encryptionInts[43] = 26;
    this.encryptionInts[44] = 7;
    this.encryptionInts[45] = 35;
    this.encryptionInts[46] = -6;
    this.encryptionInts[47] = 47;
    this.encryptionInts[48] = 7;
    this.encryptionInts[49] = 10;
    this.encryptionInts[50] = 45;
    this.encryptionInts[51] = 48;
    this.encryptionInts[52] = 6;
    this.encryptionInts[53] = 11;
    this.encryptionInts[54] = 32;
    this.encryptionInts[55] = 42;
    this.encryptionInts[56] = 36;
    this.encryptionInts[57] = 50;
    this.encryptionInts[58] = 30;
    this.encryptionInts[59] = -2;
    this.encryptionInts[60] = 54;
    this.encryptionInts[61] = 2;
    this.encryptionInts[62] = 44;
    this.encryptionInts[63] = 29;
    SimpleLongDecrypter.initSharedDecrypter(this);
  }

  static void a(boolean var0) {
    e = var0;
  }

  static ILongDecrypter getPairStatic(ILongDecrypter key, ILongDecrypter value) {
    return INSTANCE.getPair(key, value);
  }

  private ILongDecrypter getPair(ILongDecrypter key, ILongDecrypter value) {
    System.out.println("key: "+key);
    Object result = this.decrypterToDecrypterMap.get(key);
    if (result == null) {
      result = this;
      //System.out.println("Not cached");
    } else {
      //System.out.println("Used cache");
    }

    System.out.println("put: "+value+" -> "+key);
    Object var4 = this.decrypterToDecrypterMap.put(value, key);
    return (ILongDecrypter)result;
  }

  void init() {
    this.setupEncryptionInts();
    SimpleLongDecrypter.initEncryptionData(this);
  }

  void prepareCachedDecrypters() {
    this.setChildrenForDecrypters();
  }

  @Override
  public void setChild(ILongDecrypter child) {
    if (this != child) {
      if (this.child == null) {
        this.child = child;
      } else {
        this.child.setChild(child);
      }
    }
  }

  @Override
  public long decrypt(long decryptKey) {
    ILongDecrypter longDecrypter = SimpleLongDecrypter.getCachedDecrypter(decryptKey);
    long value = longDecrypter.decrypt(decryptKey);

    // Update long decrypter's encryption ints with our own array
    // This effectively modifies the state of SimpleLongDecrypter
    int[] encryptionInts = longDecrypter.getEncryptionInts();
    System.arraycopy(this.encryptionInts, 0, encryptionInts, 0, 64);

    if (this.child != null) {
      this.child.decrypt(decryptKey);
    }

    return value;
  }

  @Override
  public int[] getEncryptionInts() {
    return SimpleLongDecrypter.mutableEncryptionInts;
  }

  // Unused
  @Override
  public boolean lessThanOrEqual(ILongDecrypter other) {
    if (this == other) {
      return true;
    } else {
      return other instanceof FallbackLongDecrypter ? System.identityHashCode(this) - System.identityHashCode(other) <= 0 : false;
    }
  }

  @Override
  public void setKey(long key) {
    this.key = key;
  }

  private void initCachedDecryptersMap() {
    ConcurrentHashMap<ILongDecrypter, ILongDecrypter> var10000 = this.decrypterToDecrypterMap;
    this.decrypterToDecrypterMap.put(SimpleLongDecrypter.getCachedDecrypter(-1986416091109256469L), SimpleLongDecrypter.getCachedDecrypter(-3059166788854042651L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(6920982444000201384L), SimpleLongDecrypter.getCachedDecrypter(1502142890550895894L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-287693565063644781L), SimpleLongDecrypter.getCachedDecrypter(6918793201750776901L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-458912916494629938L), SimpleLongDecrypter.getCachedDecrypter(5863594772594630018L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(4074822491960867241L), SimpleLongDecrypter.getCachedDecrypter(2105670753694342612L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(959978680119219899L), SimpleLongDecrypter.getCachedDecrypter(5847567693026368449L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(5779323504258784073L), SimpleLongDecrypter.getCachedDecrypter(-1058989732404172907L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-4033266620404474058L), SimpleLongDecrypter.getCachedDecrypter(-5146050006772315680L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-3745185180108532409L), SimpleLongDecrypter.getCachedDecrypter(-8220449341766149921L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(7906899774795397262L), SimpleLongDecrypter.getCachedDecrypter(-485213178055450227L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(5307135347845555143L), SimpleLongDecrypter.getCachedDecrypter(316092335528197106L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-1037347408094146583L), SimpleLongDecrypter.getCachedDecrypter(6105454837132386951L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-6556669306231050068L), SimpleLongDecrypter.getCachedDecrypter(90013165418731139L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-2840189856866554324L), SimpleLongDecrypter.getCachedDecrypter(5319882638750678593L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-6575430992262218251L), SimpleLongDecrypter.getCachedDecrypter(-8216525300395158383L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(2406248529132448077L), SimpleLongDecrypter.getCachedDecrypter(3276011903675299950L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(5287646012352263875L), SimpleLongDecrypter.getCachedDecrypter(-3944757197390805694L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(4096728984916145431L), SimpleLongDecrypter.getCachedDecrypter(-1597678014114441018L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-6873600760421070333L), SimpleLongDecrypter.getCachedDecrypter(-5758649873308582376L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-8533856970645599186L), SimpleLongDecrypter.getCachedDecrypter(7512411064658545368L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(6449473114346810785L), SimpleLongDecrypter.getCachedDecrypter(-1401818488487131118L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-3148966477615345941L), SimpleLongDecrypter.getCachedDecrypter(979436940229788763L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(4070492533627884182L), SimpleLongDecrypter.getCachedDecrypter(-8225900608387630771L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-8932642830225366980L), SimpleLongDecrypter.getCachedDecrypter(-4857712906395309440L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(613811845475938723L), SimpleLongDecrypter.getCachedDecrypter(6446393157965702307L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(4372224277806209824L), SimpleLongDecrypter.getCachedDecrypter(-7448691860841767344L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(4086677762671742416L), SimpleLongDecrypter.getCachedDecrypter(6936070293451539301L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-5911032427228622064L), SimpleLongDecrypter.getCachedDecrypter(4746564250933093252L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-2561465566664046462L), SimpleLongDecrypter.getCachedDecrypter(-6534630883339696717L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(9052942315196205479L), SimpleLongDecrypter.getCachedDecrypter(-1715257455839901369L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-3910884879902596192L), SimpleLongDecrypter.getCachedDecrypter(95497893363974849L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-4795903473016158574L), SimpleLongDecrypter.getCachedDecrypter(627778304642993702L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-6327647821487709124L), SimpleLongDecrypter.getCachedDecrypter(1158118967382568374L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-4298173472291467369L), SimpleLongDecrypter.getCachedDecrypter(-8905917217017034898L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-6550041211142933579L), SimpleLongDecrypter.getCachedDecrypter(-5943772596146400334L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-765959740845257943L), SimpleLongDecrypter.getCachedDecrypter(-1101870134195519254L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-5629454399823173274L), SimpleLongDecrypter.getCachedDecrypter(-3356316483103340058L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-266451600674873302L), SimpleLongDecrypter.getCachedDecrypter(-6319649386837741034L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-3152762654813314490L), SimpleLongDecrypter.getCachedDecrypter(-5449876397578030429L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-2194087465120208387L), SimpleLongDecrypter.getCachedDecrypter(-6898133555370385272L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(113277574090118205L), SimpleLongDecrypter.getCachedDecrypter(381951238395070403L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(3541123465801158029L), SimpleLongDecrypter.getCachedDecrypter(-5722162613367820418L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(9061312626457130616L), SimpleLongDecrypter.getCachedDecrypter(1779263460277172729L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-5334037756471346292L), SimpleLongDecrypter.getCachedDecrypter(4434666850092175488L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(2071693639275863605L), SimpleLongDecrypter.getCachedDecrypter(-6321650278900505065L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-3052757996326430601L), SimpleLongDecrypter.getCachedDecrypter(7636498607107252304L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-2764642559863078952L), SimpleLongDecrypter.getCachedDecrypter(7874468307973213683L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-757688652838960085L), SimpleLongDecrypter.getCachedDecrypter(8431119858190369941L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-2781501505383978045L), SimpleLongDecrypter.getCachedDecrypter(-6249052947989494668L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(7210660166972221461L), SimpleLongDecrypter.getCachedDecrypter(5556543494131064257L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(5017621479488976779L), SimpleLongDecrypter.getCachedDecrypter(-5946338443679534808L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-8901872600361898941L), SimpleLongDecrypter.getCachedDecrypter(2903076651694454812L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-2220357651577134934L), SimpleLongDecrypter.getCachedDecrypter(-8641107989337930719L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(6772442765306243480L), SimpleLongDecrypter.getCachedDecrypter(-3992553879568065108L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(5577145109809299507L), SimpleLongDecrypter.getCachedDecrypter(884367853506451505L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-4896962154554857259L), SimpleLongDecrypter.getCachedDecrypter(-5711721979399085474L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-2284168892885967857L), SimpleLongDecrypter.getCachedDecrypter(136401745214457453L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-2188166367672492792L), SimpleLongDecrypter.getCachedDecrypter(1493603206514373463L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-6203719015280650887L), SimpleLongDecrypter.getCachedDecrypter(-848557752568873008L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(2427774537877502563L), SimpleLongDecrypter.getCachedDecrypter(6933805961999359820L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(4729897799036936825L), SimpleLongDecrypter.getCachedDecrypter(-5652275630224481051L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(7539003542365874134L), SimpleLongDecrypter.getCachedDecrypter(3804603338895916462L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(6945293954517698056L), SimpleLongDecrypter.getCachedDecrypter(4107211023701178855L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-7670747672225799494L), SimpleLongDecrypter.getCachedDecrypter(2607506495773903483L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(6662361721171447392L), SimpleLongDecrypter.getCachedDecrypter(-6832705165918441731L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-2263072771391433412L), SimpleLongDecrypter.getCachedDecrypter(-7779500624029721705L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-1590841055503294028L), SimpleLongDecrypter.getCachedDecrypter(-7194743878133107428L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(1270933948645597017L), SimpleLongDecrypter.getCachedDecrypter(7605738971359475590L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-3997531565804855859L), SimpleLongDecrypter.getCachedDecrypter(-8307851924525407131L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(7833224161343017824L), SimpleLongDecrypter.getCachedDecrypter(2072005988800624320L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-1602268489837685215L), SimpleLongDecrypter.getCachedDecrypter(-1014946931091788216L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(2057782750328802040L), SimpleLongDecrypter.getCachedDecrypter(-5704253349698956943L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(3587762441364646195L), SimpleLongDecrypter.getCachedDecrypter(4914970621108341600L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(8489237013067928376L), SimpleLongDecrypter.getCachedDecrypter(1534088641706480502L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(1515546851908191787L), SimpleLongDecrypter.getCachedDecrypter(-1588458697964406892L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(1851155936305434067L), SimpleLongDecrypter.getCachedDecrypter(8414650931027805168L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(7041328398955029177L), SimpleLongDecrypter.getCachedDecrypter(-3943028264093306708L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-1635699581028065367L), SimpleLongDecrypter.getCachedDecrypter(6955127348504138027L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(6676896237662643946L), SimpleLongDecrypter.getCachedDecrypter(6120749559517389669L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(8763945315791641795L), SimpleLongDecrypter.getCachedDecrypter(7299520050749001064L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-3699383514083040537L), SimpleLongDecrypter.getCachedDecrypter(-2200266768229069439L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(4379642046480619337L), SimpleLongDecrypter.getCachedDecrypter(3885077209634005918L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-8549308585340088438L), SimpleLongDecrypter.getCachedDecrypter(-4525546783531838738L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-5136348972601537923L), this);
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(2043406722489770281L), SimpleLongDecrypter.getCachedDecrypter(-4788524663131450536L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-2279733311605992532L), SimpleLongDecrypter.getCachedDecrypter(8391783631609711381L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(8134275136228235264L), SimpleLongDecrypter.getCachedDecrypter(5906784049220193084L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(8372623318218744371L), SimpleLongDecrypter.getCachedDecrypter(4135432760822577737L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-2457716384756211607L), SimpleLongDecrypter.getCachedDecrypter(-3351180828161003368L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-4868959217466863033L), SimpleLongDecrypter.getCachedDecrypter(-7734884993792450155L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(7228785725715030226L), SimpleLongDecrypter.getCachedDecrypter(-2460711654545998130L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(4678810986061828285L), SimpleLongDecrypter.getCachedDecrypter(-5945426860617490137L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(5596749052371630687L), SimpleLongDecrypter.getCachedDecrypter(2310424126601823384L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(661909517148127452L), SimpleLongDecrypter.getCachedDecrypter(-7988421617240798351L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(1220102509552993558L), SimpleLongDecrypter.getCachedDecrypter(4653929683838060129L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(7629008540892765309L), SimpleLongDecrypter.getCachedDecrypter(-8535189180439540550L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-8844649047648619377L), SimpleLongDecrypter.getCachedDecrypter(-4846255648524561974L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-4899655788421965785L), SimpleLongDecrypter.getCachedDecrypter(6987724228389289086L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-8642022059205502660L), SimpleLongDecrypter.getCachedDecrypter(-8241830452793914048L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(4730690686541329026L), SimpleLongDecrypter.getCachedDecrypter(5812087815026598844L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-6849591046257818588L), SimpleLongDecrypter.getCachedDecrypter(7022438833107637227L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-7120303310061228174L), SimpleLongDecrypter.getCachedDecrypter(-5045767810669300106L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(3589056781703594341L), SimpleLongDecrypter.getCachedDecrypter(-7746577810766325978L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-3691244458241766240L), SimpleLongDecrypter.getCachedDecrypter(8696955212032434771L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-6783374136799069950L), SimpleLongDecrypter.getCachedDecrypter(-9164504345238193254L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(4036092661302369475L), SimpleLongDecrypter.getCachedDecrypter(5277600869534084776L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(2019333355680506647L), SimpleLongDecrypter.getCachedDecrypter(-3694344595356795099L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-5072447823481113131L), SimpleLongDecrypter.getCachedDecrypter(706477987228533641L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-3360071314170953540L), SimpleLongDecrypter.getCachedDecrypter(-7754079436543475675L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(2145890329318324537L), SimpleLongDecrypter.getCachedDecrypter(3011839329347897911L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-9121927751705477024L), SimpleLongDecrypter.getCachedDecrypter(8429353085580438717L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(304269284705821330L), SimpleLongDecrypter.getCachedDecrypter(1529823172802193626L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(3587490384654127492L), SimpleLongDecrypter.getCachedDecrypter(8214398120729716728L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-4255507460876481401L), SimpleLongDecrypter.getCachedDecrypter(2975234674882658445L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(8763697291602240547L), SimpleLongDecrypter.getCachedDecrypter(610030248328152197L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-8568463942911179208L), SimpleLongDecrypter.getCachedDecrypter(4987498095518624277L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(3492760420596023592L), SimpleLongDecrypter.getCachedDecrypter(7282820256688013859L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-1144287033634106159L), SimpleLongDecrypter.getCachedDecrypter(7524781730897500390L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(7838570639395205213L), SimpleLongDecrypter.getCachedDecrypter(-6012892709473599248L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-2272132145273189228L), SimpleLongDecrypter.getCachedDecrypter(7842014754227260002L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-5676504380667643107L), SimpleLongDecrypter.getCachedDecrypter(1824495392943150321L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(5023873729504475276L), SimpleLongDecrypter.getCachedDecrypter(6174898298449659147L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(339307853422226330L), SimpleLongDecrypter.getCachedDecrypter(4046340500072407177L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(4670991423143278569L), SimpleLongDecrypter.getCachedDecrypter(137608147280951035L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(7205942410578379130L), SimpleLongDecrypter.getCachedDecrypter(-3732683939784642372L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(5820543313534781238L), SimpleLongDecrypter.getCachedDecrypter(8724728949486010654L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-4542329462095617766L), SimpleLongDecrypter.getCachedDecrypter(-7200745740395412222L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(4376269587338320535L), SimpleLongDecrypter.getCachedDecrypter(-8580865301667010639L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-493086870023779793L), SimpleLongDecrypter.getCachedDecrypter(5207770643373605233L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-6269773939349014230L), SimpleLongDecrypter.getCachedDecrypter(8421473217932302534L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-4010409925836264614L), SimpleLongDecrypter.getCachedDecrypter(8373354263531373904L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-4546047052792055901L), SimpleLongDecrypter.getCachedDecrypter(-6278399730405336911L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-6284565676249684441L), SimpleLongDecrypter.getCachedDecrypter(-5703022638269651043L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(4982628833488094674L), SimpleLongDecrypter.getCachedDecrypter(-5945151282447435692L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(6107467081261169994L), SimpleLongDecrypter.getCachedDecrypter(-8043226046251281719L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(7321504444565377931L), SimpleLongDecrypter.getCachedDecrypter(5287907534740249420L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(1524929632910422548L), SimpleLongDecrypter.getCachedDecrypter(2413224543021193504L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-7744023984207809264L), SimpleLongDecrypter.getCachedDecrypter(-8248031799360177161L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-7399547618208336499L), SimpleLongDecrypter.getCachedDecrypter(-6260728425221417206L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(1808840443591547163L), SimpleLongDecrypter.getCachedDecrypter(9038733568219968526L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(4927641048381990981L), SimpleLongDecrypter.getCachedDecrypter(-3128107694322188423L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(6440037323966090089L), SimpleLongDecrypter.getCachedDecrypter(-7156948790279684504L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(6702248853881433865L), SimpleLongDecrypter.getCachedDecrypter(-3378418735745111170L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(661948952224100106L), SimpleLongDecrypter.getCachedDecrypter(5900632736629437979L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(4736200256431845731L), SimpleLongDecrypter.getCachedDecrypter(-1146818598540722375L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-3743013051875184152L), SimpleLongDecrypter.getCachedDecrypter(8073475980802051925L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(83208821655898477L), SimpleLongDecrypter.getCachedDecrypter(-6236174305285514365L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-736381695806913133L), SimpleLongDecrypter.getCachedDecrypter(-1130679965239864840L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(8466137165500933476L), SimpleLongDecrypter.getCachedDecrypter(3181403830166629096L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-5377978246712879296L), SimpleLongDecrypter.getCachedDecrypter(-7649809353285285780L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(364818715671619056L), SimpleLongDecrypter.getCachedDecrypter(-7753376661691852493L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(6116050039557398859L), SimpleLongDecrypter.getCachedDecrypter(-3612871415275240979L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-6608651480983725416L), SimpleLongDecrypter.getCachedDecrypter(5220624081610830673L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-2531369932321710358L), SimpleLongDecrypter.getCachedDecrypter(6770957041204362784L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(385158871454716980L), SimpleLongDecrypter.getCachedDecrypter(5193389589470841672L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(1181471781776655964L), SimpleLongDecrypter.getCachedDecrypter(2923672309141886419L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-1421322407309228933L), SimpleLongDecrypter.getCachedDecrypter(-4532644287730267790L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(5897376005294042505L), SimpleLongDecrypter.getCachedDecrypter(2061190479432968616L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-7134727476440637214L), SimpleLongDecrypter.getCachedDecrypter(-2560890491384652582L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(5485342240572142566L), SimpleLongDecrypter.getCachedDecrypter(-4609671512480169104L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(6179895083710068092L), SimpleLongDecrypter.getCachedDecrypter(8972697747220579684L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(7245362760218859580L), SimpleLongDecrypter.getCachedDecrypter(3510398010351968735L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(6165016240174298123L), SimpleLongDecrypter.getCachedDecrypter(-2001242842227574990L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-1959713771009631369L), SimpleLongDecrypter.getCachedDecrypter(-831939294583380713L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(7636057832186446723L), SimpleLongDecrypter.getCachedDecrypter(5222213145292224113L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(8202396056909258693L), SimpleLongDecrypter.getCachedDecrypter(5043618972789482217L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(8737664160110424061L), SimpleLongDecrypter.getCachedDecrypter(-2246847661962489950L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(1556538056287073540L), SimpleLongDecrypter.getCachedDecrypter(-5178486087167549180L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-4560689755942962401L), SimpleLongDecrypter.getCachedDecrypter(8706506427288997982L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-7715439852530017067L), SimpleLongDecrypter.getCachedDecrypter(-2227336202774002633L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-250747443919715206L), SimpleLongDecrypter.getCachedDecrypter(2602643050843917966L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(2402546272291220950L), SimpleLongDecrypter.getCachedDecrypter(8390350447953322097L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(2729239783546683375L), SimpleLongDecrypter.getCachedDecrypter(-5046248560086064285L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(37645850315316989L), SimpleLongDecrypter.getCachedDecrypter(9016139601421746013L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(5567725390399664632L), SimpleLongDecrypter.getCachedDecrypter(-7157608332373419735L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(6942453922974449976L), SimpleLongDecrypter.getCachedDecrypter(-4893452845139109957L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-7781239653639572880L), SimpleLongDecrypter.getCachedDecrypter(-5370512335852330606L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-5375748156151954815L), SimpleLongDecrypter.getCachedDecrypter(-7726082147330546571L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-7949636601977662136L), SimpleLongDecrypter.getCachedDecrypter(2672800623009191604L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(6383930417493749682L), SimpleLongDecrypter.getCachedDecrypter(-8879122285082939309L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-5126940363206370652L), SimpleLongDecrypter.getCachedDecrypter(7785907853882330008L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(3533658288343208819L), SimpleLongDecrypter.getCachedDecrypter(-4246060702196633701L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-8889218289575856441L), SimpleLongDecrypter.getCachedDecrypter(4652061526943924747L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(7850102882511672357L), SimpleLongDecrypter.getCachedDecrypter(2945638573311670557L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(56301736052047660L), SimpleLongDecrypter.getCachedDecrypter(7861849567704128875L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(8077634095869542890L), SimpleLongDecrypter.getCachedDecrypter(-5078948519639490155L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(1779477549804199316L), SimpleLongDecrypter.getCachedDecrypter(3797129624514802351L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(2732655374238301417L), SimpleLongDecrypter.getCachedDecrypter(2315356002873038061L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(4427662554959714445L), SimpleLongDecrypter.getCachedDecrypter(8101815433056787397L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-6493570400126197560L), SimpleLongDecrypter.getCachedDecrypter(3534242430824622594L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-2775250514967388688L), SimpleLongDecrypter.getCachedDecrypter(4648704626418856385L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-8032421794768590703L), SimpleLongDecrypter.getCachedDecrypter(1873484994923567612L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-254246267639709803L), SimpleLongDecrypter.getCachedDecrypter(9052839283960268257L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(6384669817168732524L), SimpleLongDecrypter.getCachedDecrypter(5814573291418988007L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-5467535408307629909L), SimpleLongDecrypter.getCachedDecrypter(6456948714488959351L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-9084630688531254585L), SimpleLongDecrypter.getCachedDecrypter(8160418263926000683L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-7744034531133669197L), SimpleLongDecrypter.getCachedDecrypter(3024470466463684294L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-7753458018928994198L), SimpleLongDecrypter.getCachedDecrypter(3006341955424656018L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(9064989897575046071L), SimpleLongDecrypter.getCachedDecrypter(5272086243777455247L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(5594506641425853871L), SimpleLongDecrypter.getCachedDecrypter(294091228180613981L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(668981264244018218L), SimpleLongDecrypter.getCachedDecrypter(-2510843039958690183L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-8222793466399334817L), SimpleLongDecrypter.getCachedDecrypter(-210286065138585472L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(7501585616025335412L), SimpleLongDecrypter.getCachedDecrypter(-7198738356860688453L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-3988074218583689232L), SimpleLongDecrypter.getCachedDecrypter(-210442442861576731L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(4692621686185077919L), SimpleLongDecrypter.getCachedDecrypter(-8907865118524114591L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(1547516317625778004L), SimpleLongDecrypter.getCachedDecrypter(5511334621724301863L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(9064807233428649083L), SimpleLongDecrypter.getCachedDecrypter(5822852522116386376L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-828060573887178198L), SimpleLongDecrypter.getCachedDecrypter(4095961321723666346L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(8976053937454215489L), SimpleLongDecrypter.getCachedDecrypter(5037788004919824928L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(5190631826692878692L), SimpleLongDecrypter.getCachedDecrypter(4078015822532516984L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(5530992893707757523L), SimpleLongDecrypter.getCachedDecrypter(-2301371847584433671L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(4707802126753043397L), SimpleLongDecrypter.getCachedDecrypter(-2842022611035926767L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(7835511128253700480L), SimpleLongDecrypter.getCachedDecrypter(4983055862315474224L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-439489906865322352L), SimpleLongDecrypter.getCachedDecrypter(3539255384697355426L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-2586295549703032208L), SimpleLongDecrypter.getCachedDecrypter(-2764124031921860393L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(8105461326482080372L), SimpleLongDecrypter.getCachedDecrypter(2347096292480849666L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(106173929846387253L), SimpleLongDecrypter.getCachedDecrypter(-8512206958645633145L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(1251713922808129784L), SimpleLongDecrypter.getCachedDecrypter(-753481708870875771L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(1478759168584654753L), SimpleLongDecrypter.getCachedDecrypter(-3716632073859055624L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-3083037391056922187L), SimpleLongDecrypter.getCachedDecrypter(-2248530523700627568L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-460449213613254035L), SimpleLongDecrypter.getCachedDecrypter(690600858715720729L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(6193559001190287466L), SimpleLongDecrypter.getCachedDecrypter(-4543854315518520951L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(4720539672123030788L), SimpleLongDecrypter.getCachedDecrypter(-6618043615921902658L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-7360621833281274615L), SimpleLongDecrypter.getCachedDecrypter(3204634952760401314L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-6824400448435472147L), SimpleLongDecrypter.getCachedDecrypter(3772690131991462787L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(7025952160290531559L), SimpleLongDecrypter.getCachedDecrypter(-554273319344779329L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-7719552691899572060L), SimpleLongDecrypter.getCachedDecrypter(5824280900363065358L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-9204904250319947226L), SimpleLongDecrypter.getCachedDecrypter(-5453028408030147429L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(1255186932293804589L), SimpleLongDecrypter.getCachedDecrypter(5226276608651111752L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-8926499960958218837L), SimpleLongDecrypter.getCachedDecrypter(-746146143253684428L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-3324032015769707991L), SimpleLongDecrypter.getCachedDecrypter(-4267485783134324078L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-4488967063777002646L), SimpleLongDecrypter.getCachedDecrypter(-1994209690221588922L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(2624614194044854488L), SimpleLongDecrypter.getCachedDecrypter(2948821014693131471L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(1471200598848811681L), SimpleLongDecrypter.getCachedDecrypter(-7664068583381312995L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-2200269809090576113L), SimpleLongDecrypter.getCachedDecrypter(907188704930883124L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-278360760276422332L), SimpleLongDecrypter.getCachedDecrypter(2321677148833979536L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(118929900044112093L), SimpleLongDecrypter.getCachedDecrypter(-7745405674589395731L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(4913928174377764347L), SimpleLongDecrypter.getCachedDecrypter(-6808228072076139136L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(8449237673757226866L), SimpleLongDecrypter.getCachedDecrypter(-7428992675437492511L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(2609351399610051103L), SimpleLongDecrypter.getCachedDecrypter(-1597426435667560437L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(3512229502811356686L), SimpleLongDecrypter.getCachedDecrypter(690372539353189685L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-831427766905911680L), SimpleLongDecrypter.getCachedDecrypter(-5658401255270742747L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-7645428420832167956L), SimpleLongDecrypter.getCachedDecrypter(4095105469778802883L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(6747650535507002162L), SimpleLongDecrypter.getCachedDecrypter(7260506006505442098L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-8510437908478216410L), SimpleLongDecrypter.getCachedDecrypter(-1903509732765076773L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-9102885662433169511L), SimpleLongDecrypter.getCachedDecrypter(7053093802478561844L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(4633019485250603535L), SimpleLongDecrypter.getCachedDecrypter(-2486330222306819873L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-6875522785068807043L), SimpleLongDecrypter.getCachedDecrypter(3768855698775967641L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(1560179997741392790L), SimpleLongDecrypter.getCachedDecrypter(-7191722313696732579L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(1856105173737321905L), SimpleLongDecrypter.getCachedDecrypter(-7717080236666849809L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(8149379766307451206L), SimpleLongDecrypter.getCachedDecrypter(-493761383589599295L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(3025103996926338877L), SimpleLongDecrypter.getCachedDecrypter(6702358132664336133L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-3633293223923886999L), SimpleLongDecrypter.getCachedDecrypter(5512627131297829007L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-1399006838602794990L), SimpleLongDecrypter.getCachedDecrypter(1259240313875856665L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(3855868167406400123L), SimpleLongDecrypter.getCachedDecrypter(-7673851064900946679L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(6940260487619691845L), SimpleLongDecrypter.getCachedDecrypter(2319453546740306076L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-2805359627525136510L), SimpleLongDecrypter.getCachedDecrypter(-9213858272385324916L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-3050242128584220291L), SimpleLongDecrypter.getCachedDecrypter(2426948854738884484L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(2089145489051168761L), SimpleLongDecrypter.getCachedDecrypter(-1976574236665561500L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(5000225197065207734L), SimpleLongDecrypter.getCachedDecrypter(-5914570566482257658L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(7865075778614297677L), SimpleLongDecrypter.getCachedDecrypter(882168992909457586L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(3557548855757095999L), SimpleLongDecrypter.getCachedDecrypter(3192667863527761023L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(7921664579917316149L), SimpleLongDecrypter.getCachedDecrypter(-1686662328109017448L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(16030545931613829L), SimpleLongDecrypter.getCachedDecrypter(8427570431936679729L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(2072000809330830941L), SimpleLongDecrypter.getCachedDecrypter(2699141695702979730L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-190176580380278532L), SimpleLongDecrypter.getCachedDecrypter(-3665018027907116742L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(8441280878557436659L), SimpleLongDecrypter.getCachedDecrypter(-8618210726459123612L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(868610363467293337L), SimpleLongDecrypter.getCachedDecrypter(8470993428666161097L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-1977481351025488552L), SimpleLongDecrypter.getCachedDecrypter(3297111064124731840L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-6287070246673950896L), SimpleLongDecrypter.getCachedDecrypter(-6014084052722820580L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-3631833685691878627L), SimpleLongDecrypter.getCachedDecrypter(-4873477442426885784L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-545611487548678208L), SimpleLongDecrypter.getCachedDecrypter(7866510512487842104L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(3216252896265573375L), SimpleLongDecrypter.getCachedDecrypter(3781808300992487674L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(1501006475173056326L), SimpleLongDecrypter.getCachedDecrypter(6706669794210771477L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-5964667453973529479L), SimpleLongDecrypter.getCachedDecrypter(4966723286899222785L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-525712538421082729L), SimpleLongDecrypter.getCachedDecrypter(-4799221693868549205L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(5535997420572536844L), SimpleLongDecrypter.getCachedDecrypter(-5633213351953233165L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(947909479146261258L), SimpleLongDecrypter.getCachedDecrypter(8671830010059921680L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-6261069166899588980L), SimpleLongDecrypter.getCachedDecrypter(1737220361212352454L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(2916357505796789185L), SimpleLongDecrypter.getCachedDecrypter(132939269701051514L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(7897403347197942571L), SimpleLongDecrypter.getCachedDecrypter(-1897721707299672549L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(4177724402902082499L), SimpleLongDecrypter.getCachedDecrypter(2152061244657799841L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(3936978236254310L), SimpleLongDecrypter.getCachedDecrypter(-3687010394128661005L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(1524754667682501362L), SimpleLongDecrypter.getCachedDecrypter(-3608265407164279981L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-5101367195978946117L), SimpleLongDecrypter.getCachedDecrypter(6074342367818979530L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-4179422530396647193L), SimpleLongDecrypter.getCachedDecrypter(-5732865919794735904L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-6858671282305005792L), SimpleLongDecrypter.getCachedDecrypter(1285372701687665869L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-7087053533801605746L), SimpleLongDecrypter.getCachedDecrypter(-560643507480573711L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(3879300281446393663L), SimpleLongDecrypter.getCachedDecrypter(8140048637933306299L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(7016817443144306468L), SimpleLongDecrypter.getCachedDecrypter(6993846540610826759L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(3880079044751367776L), SimpleLongDecrypter.getCachedDecrypter(-2772175961550748877L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(6918728115301022535L), SimpleLongDecrypter.getCachedDecrypter(-7093691541903820998L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-7121869508018465296L), SimpleLongDecrypter.getCachedDecrypter(-3619905918253696669L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-4545617661108764150L), SimpleLongDecrypter.getCachedDecrypter(-5693751197263386763L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(5834011537330639540L), SimpleLongDecrypter.getCachedDecrypter(7292145881775566192L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(7530432167940528081L), SimpleLongDecrypter.getCachedDecrypter(-2804792023393741134L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(910831794564461123L), SimpleLongDecrypter.getCachedDecrypter(-6788076165741273230L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(5805549404228672770L), SimpleLongDecrypter.getCachedDecrypter(-6013502380933964971L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(5315798377556678107L), SimpleLongDecrypter.getCachedDecrypter(8675676969925212567L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(2306904932395304954L), SimpleLongDecrypter.getCachedDecrypter(5233265262665027345L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(417321317301484570L), SimpleLongDecrypter.getCachedDecrypter(2729110386304083763L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-6515147614880339305L), SimpleLongDecrypter.getCachedDecrypter(5820542412055344786L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(8386867570350352289L), SimpleLongDecrypter.getCachedDecrypter(7025705443174003468L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(2140727713596191545L), SimpleLongDecrypter.getCachedDecrypter(4966535516766319824L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(9028240545303715909L), SimpleLongDecrypter.getCachedDecrypter(4161130978478061659L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(4995181205128241268L), SimpleLongDecrypter.getCachedDecrypter(-2250732696933624885L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(1000359605547491138L), SimpleLongDecrypter.getCachedDecrypter(-5067854833064411496L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(4717309719445949203L), SimpleLongDecrypter.getCachedDecrypter(-1302670413065042625L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(3215824997069522944L), SimpleLongDecrypter.getCachedDecrypter(656721864649648603L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(7349872978350392675L), SimpleLongDecrypter.getCachedDecrypter(-8294295262056016382L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-6293906392389105330L), SimpleLongDecrypter.getCachedDecrypter(7829181915181653587L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-6021541225501284101L), SimpleLongDecrypter.getCachedDecrypter(-4788605159548992922L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-5737303548234516633L), SimpleLongDecrypter.getCachedDecrypter(-7738614297119902111L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(1198923286267990471L), SimpleLongDecrypter.getCachedDecrypter(-234527576298942974L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-8845565663603887722L), SimpleLongDecrypter.getCachedDecrypter(6167232154533197865L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(3530630654110623395L), SimpleLongDecrypter.getCachedDecrypter(6065879112502443808L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-6908025239597109984L), SimpleLongDecrypter.getCachedDecrypter(6069941128679859712L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-2558457005567348423L), SimpleLongDecrypter.getCachedDecrypter(91345267010913253L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-782373616705194270L), SimpleLongDecrypter.getCachedDecrypter(1767758975939877959L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(3016612345624369176L), SimpleLongDecrypter.getCachedDecrypter(-8862590541130599355L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(6374973279477575904L), SimpleLongDecrypter.getCachedDecrypter(-3936693917617855661L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-6234778360532797906L), SimpleLongDecrypter.getCachedDecrypter(-7091025249248227541L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(968397907509092979L), SimpleLongDecrypter.getCachedDecrypter(6971456398153871322L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-7386689375527301399L), SimpleLongDecrypter.getCachedDecrypter(5592898530940969649L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-8021071976435742099L), SimpleLongDecrypter.getCachedDecrypter(-1410554232717218871L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-6047842900499663656L), SimpleLongDecrypter.getCachedDecrypter(-6025376823128948419L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-7493301312391954086L), SimpleLongDecrypter.getCachedDecrypter(-2243623914411394937L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(6399459047076277734L), SimpleLongDecrypter.getCachedDecrypter(4414443402235425627L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-6004124665206926105L), SimpleLongDecrypter.getCachedDecrypter(4719607874416305356L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-6885805125234222286L), SimpleLongDecrypter.getCachedDecrypter(2610052737336624519L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(5601350417950841237L), SimpleLongDecrypter.getCachedDecrypter(1159832963531477685L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(7600489719658346270L), SimpleLongDecrypter.getCachedDecrypter(-2766096624059432923L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(97386679336626192L), SimpleLongDecrypter.getCachedDecrypter(6089653035852408058L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(4737660432105245070L), SimpleLongDecrypter.getCachedDecrypter(-6499693970290028794L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-2862279360250382810L), SimpleLongDecrypter.getCachedDecrypter(5033402261285769772L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(964714810070452851L), SimpleLongDecrypter.getCachedDecrypter(2035822917184709522L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(4949704821785051643L), SimpleLongDecrypter.getCachedDecrypter(-4830151301484024496L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(4961503327033331805L), SimpleLongDecrypter.getCachedDecrypter(980132385905890097L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-7734828891484288176L), SimpleLongDecrypter.getCachedDecrypter(5029013262079200957L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-1122697362436371493L), SimpleLongDecrypter.getCachedDecrypter(-4594050595048356903L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(7267855829506004579L), SimpleLongDecrypter.getCachedDecrypter(-1389656990777157213L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(2961322791761084674L), SimpleLongDecrypter.getCachedDecrypter(5784827536626261061L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-8022696442592741420L), SimpleLongDecrypter.getCachedDecrypter(8942969501674475696L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-3341621605486904294L), SimpleLongDecrypter.getCachedDecrypter(5008800931004342630L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-9097345448816965785L), SimpleLongDecrypter.getCachedDecrypter(-2012308899786648798L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(7802270083407105795L), SimpleLongDecrypter.getCachedDecrypter(-8925901428137007466L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(714849768446868051L), SimpleLongDecrypter.getCachedDecrypter(-5982764926234007237L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(2660276783187614785L), SimpleLongDecrypter.getCachedDecrypter(-7674732951944579181L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(5024169230666247083L), SimpleLongDecrypter.getCachedDecrypter(-2273709351824551035L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(7810943727813919222L), SimpleLongDecrypter.getCachedDecrypter(4676928900592256673L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-4314170972102188999L), SimpleLongDecrypter.getCachedDecrypter(-1091813998054512961L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(6429954260661201866L), SimpleLongDecrypter.getCachedDecrypter(-6516895424999344911L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(7051311777055982371L), SimpleLongDecrypter.getCachedDecrypter(-8905274342768594602L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-4818287019748067833L), SimpleLongDecrypter.getCachedDecrypter(3231212246489347365L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-751423037687385412L), SimpleLongDecrypter.getCachedDecrypter(-7087540861198617429L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(903620552191322348L), SimpleLongDecrypter.getCachedDecrypter(-8066312395195232393L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-487137508511646938L), SimpleLongDecrypter.getCachedDecrypter(6111308729072307362L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-4306990737088024564L), SimpleLongDecrypter.getCachedDecrypter(40739935297772656L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-2230405235101944150L), SimpleLongDecrypter.getCachedDecrypter(-4802052276137419767L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-9213610144656793448L), SimpleLongDecrypter.getCachedDecrypter(5528735448915153560L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-5127282740209722454L), SimpleLongDecrypter.getCachedDecrypter(2338367842891747943L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(4058777504300427778L), SimpleLongDecrypter.getCachedDecrypter(7030348343729496510L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-4489203175706871803L), SimpleLongDecrypter.getCachedDecrypter(2436128364946729138L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-1985463212546730893L), SimpleLongDecrypter.getCachedDecrypter(1503225382871840887L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(3261475990356265095L), SimpleLongDecrypter.getCachedDecrypter(-3684293871248535363L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(1251200170936072921L), SimpleLongDecrypter.getCachedDecrypter(414185806746110756L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-2492186342638841466L), SimpleLongDecrypter.getCachedDecrypter(6127889876601604833L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-4812052855496746058L), SimpleLongDecrypter.getCachedDecrypter(-3441232602555558810L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(6104743711715720582L), SimpleLongDecrypter.getCachedDecrypter(5550742070499708834L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-4291438610783180948L), SimpleLongDecrypter.getCachedDecrypter(-4822472091649876240L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(3287589663713248093L), SimpleLongDecrypter.getCachedDecrypter(-1318327050548204018L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-1936860395339092342L), SimpleLongDecrypter.getCachedDecrypter(-216242536234500818L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(1164646280394707803L), SimpleLongDecrypter.getCachedDecrypter(-5375922665205522015L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-3676356086329747043L), SimpleLongDecrypter.getCachedDecrypter(2159960793600962460L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(1861924180524265268L), SimpleLongDecrypter.getCachedDecrypter(2041068522875395002L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-1599372275624215912L), SimpleLongDecrypter.getCachedDecrypter(2627335188098139621L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-3968014076150943092L), SimpleLongDecrypter.getCachedDecrypter(-5672370220949952910L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-8897573491462008667L), SimpleLongDecrypter.getCachedDecrypter(7516153944194388902L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-6622414785048812852L), SimpleLongDecrypter.getCachedDecrypter(-4895369942767240245L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(705751551808393188L), SimpleLongDecrypter.getCachedDecrypter(4906243432529874756L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(23488521461252473L), SimpleLongDecrypter.getCachedDecrypter(1737898781121438701L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-3120623693690216175L), SimpleLongDecrypter.getCachedDecrypter(-221787879458000006L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-9169002127790327935L), SimpleLongDecrypter.getCachedDecrypter(-1644105685460275113L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(2602455213354983369L), SimpleLongDecrypter.getCachedDecrypter(-1892435409186160291L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-2467611323332223549L), SimpleLongDecrypter.getCachedDecrypter(-5701144405129075182L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-3979607951608508482L), SimpleLongDecrypter.getCachedDecrypter(-8035689473826410668L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(8434895420130300289L), SimpleLongDecrypter.getCachedDecrypter(-4231059275968124766L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(4725931716553248945L), SimpleLongDecrypter.getCachedDecrypter(3534809596371067350L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(5771191268656994620L), SimpleLongDecrypter.getCachedDecrypter(5268942502750394631L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-2297316494589926006L), SimpleLongDecrypter.getCachedDecrypter(-3443198645138015149L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(354431906228379776L), SimpleLongDecrypter.getCachedDecrypter(7246742268518858855L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(7903115472466988697L), SimpleLongDecrypter.getCachedDecrypter(-6318692329861037796L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-1074970225486255262L), SimpleLongDecrypter.getCachedDecrypter(-7197449799664741715L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-3993377112047544824L), SimpleLongDecrypter.getCachedDecrypter(8959410482135964315L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-6914227602058393617L), SimpleLongDecrypter.getCachedDecrypter(-2563425423895780971L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-4299477708949975295L), SimpleLongDecrypter.getCachedDecrypter(8690149283610481558L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(6944348811718765326L), SimpleLongDecrypter.getCachedDecrypter(-1431044745178013656L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-154381619622724114L), SimpleLongDecrypter.getCachedDecrypter(-3903618763120038522L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-1700206241746613907L), SimpleLongDecrypter.getCachedDecrypter(2983752321579195891L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(4038131987975639364L), SimpleLongDecrypter.getCachedDecrypter(5583190291160591140L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-7950263401446864551L), SimpleLongDecrypter.getCachedDecrypter(-8909444861474085824L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-2288718572070450379L), SimpleLongDecrypter.getCachedDecrypter(1219170454185898543L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(1154878549529887923L), SimpleLongDecrypter.getCachedDecrypter(3226567142593212128L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(8204340518189572129L), SimpleLongDecrypter.getCachedDecrypter(-7999500263346146954L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-4001803958421617316L), SimpleLongDecrypter.getCachedDecrypter(1805659666201147299L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(7544974571995729321L), SimpleLongDecrypter.getCachedDecrypter(6665938459097531383L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-3653965894365075246L), SimpleLongDecrypter.getCachedDecrypter(-5958472403039008552L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(6931109432720623161L), SimpleLongDecrypter.getCachedDecrypter(8971270010109809454L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-863448684633845311L), SimpleLongDecrypter.getCachedDecrypter(2396596250039801732L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(8734818552200299726L), SimpleLongDecrypter.getCachedDecrypter(-6283019064132880891L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-3622094358802050711L), SimpleLongDecrypter.getCachedDecrypter(670756099490132659L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-1632154815127558586L), SimpleLongDecrypter.getCachedDecrypter(-7736149103259672802L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-264996976509015800L), SimpleLongDecrypter.getCachedDecrypter(1271812486436340599L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(4135733368270762987L), SimpleLongDecrypter.getCachedDecrypter(-3336829765073941538L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(4438628755652070032L), SimpleLongDecrypter.getCachedDecrypter(-770998940927487636L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-5116432142843563747L), SimpleLongDecrypter.getCachedDecrypter(-2848074080919480327L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(8461596694001043278L), SimpleLongDecrypter.getCachedDecrypter(7227219541787753764L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(2095450951568301439L), SimpleLongDecrypter.getCachedDecrypter(-3090497528872707679L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-1036879386400563331L), SimpleLongDecrypter.getCachedDecrypter(-5714604002764959964L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-6032205626104206880L), SimpleLongDecrypter.getCachedDecrypter(-9221723857602545013L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(2383988667681006421L), SimpleLongDecrypter.getCachedDecrypter(-4188031384059750905L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-2226601040604023843L), SimpleLongDecrypter.getCachedDecrypter(6722143445993883618L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(6124250655337873507L), SimpleLongDecrypter.getCachedDecrypter(1282065781052079970L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-4208597635690118374L), SimpleLongDecrypter.getCachedDecrypter(8786450614948815192L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-2766793536324627636L), SimpleLongDecrypter.getCachedDecrypter(-1325867141378492277L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(9043416075744653774L), SimpleLongDecrypter.getCachedDecrypter(-1888825328430393040L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-8507576109536971433L), SimpleLongDecrypter.getCachedDecrypter(6357726215092055303L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(8766752220662278925L), SimpleLongDecrypter.getCachedDecrypter(-8641871386880560849L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-1426872245362072435L), SimpleLongDecrypter.getCachedDecrypter(-8237405747895154280L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(7263985508484137759L), SimpleLongDecrypter.getCachedDecrypter(2656137819864908101L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(8366861855858010383L), SimpleLongDecrypter.getCachedDecrypter(-3659201479422197160L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-1345556857965872886L), SimpleLongDecrypter.getCachedDecrypter(1541148623292954062L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-6897803055098233958L), SimpleLongDecrypter.getCachedDecrypter(912892808408715617L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(2108322837530216343L), SimpleLongDecrypter.getCachedDecrypter(625739576380465064L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-5151063001870992855L), SimpleLongDecrypter.getCachedDecrypter(-4861135685562473660L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(7241399854753543853L), SimpleLongDecrypter.getCachedDecrypter(3216897902496932299L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(2420780668095621487L), SimpleLongDecrypter.getCachedDecrypter(-5672951961723977488L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(6393406827380722542L), SimpleLongDecrypter.getCachedDecrypter(6703962216147856235L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-7095594274592896977L), SimpleLongDecrypter.getCachedDecrypter(1868025286954292728L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(7829417426161930631L), SimpleLongDecrypter.getCachedDecrypter(-3959327813796197300L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-4824515308896786901L), SimpleLongDecrypter.getCachedDecrypter(-1405811707050280346L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(3286490278918913644L), SimpleLongDecrypter.getCachedDecrypter(-7744602077766009100L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-3367467065624746027L), SimpleLongDecrypter.getCachedDecrypter(-3059356556791202823L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(8397696247687517670L), SimpleLongDecrypter.getCachedDecrypter(-525942199931705578L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(651168870930844700L), SimpleLongDecrypter.getCachedDecrypter(-8618908303770829682L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-4839311400968560219L), SimpleLongDecrypter.getCachedDecrypter(-6514113296966961393L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(3847190968155529880L), SimpleLongDecrypter.getCachedDecrypter(2640098269386838675L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(4711565122503307111L), SimpleLongDecrypter.getCachedDecrypter(4134390205549782640L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(4036972949353277807L), SimpleLongDecrypter.getCachedDecrypter(-9171583909646029827L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-5337820687173385795L), SimpleLongDecrypter.getCachedDecrypter(1733269798371550292L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-1427046497278896003L), SimpleLongDecrypter.getCachedDecrypter(4403976938739061070L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-3117765903076992105L), SimpleLongDecrypter.getCachedDecrypter(1831941971145226370L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(6648935290294162239L), SimpleLongDecrypter.getCachedDecrypter(6962425901369256538L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(4068337570196535934L), SimpleLongDecrypter.getCachedDecrypter(8401631191307051609L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-7675885677948792146L), SimpleLongDecrypter.getCachedDecrypter(3237260777441236841L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(4742617290260807561L), SimpleLongDecrypter.getCachedDecrypter(5820814434084206950L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(2136049429574056234L), SimpleLongDecrypter.getCachedDecrypter(-3393755617980253763L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(3805465932581805580L), SimpleLongDecrypter.getCachedDecrypter(926730380218181999L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-6223387704568913809L), SimpleLongDecrypter.getCachedDecrypter(-4585735887922629869L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-6900950712213057439L), SimpleLongDecrypter.getCachedDecrypter(-8853266570156161635L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(4641741812341944765L), SimpleLongDecrypter.getCachedDecrypter(5884578961044824961L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-8528568438068591508L), SimpleLongDecrypter.getCachedDecrypter(-3745812953933579136L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(2600178630780978636L), SimpleLongDecrypter.getCachedDecrypter(6139987630669975016L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(5770582745800436013L), SimpleLongDecrypter.getCachedDecrypter(-3403834598654674625L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-2223111757024032861L), SimpleLongDecrypter.getCachedDecrypter(6193058824059779599L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-1076615577855320995L), SimpleLongDecrypter.getCachedDecrypter(-8046890878872229394L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-838346238462508676L), SimpleLongDecrypter.getCachedDecrypter(414995927547222189L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(5314713642757272720L), SimpleLongDecrypter.getCachedDecrypter(7832643154401386573L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-9087322272570016418L), SimpleLongDecrypter.getCachedDecrypter(-191181591795314693L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-6889440644918898107L), SimpleLongDecrypter.getCachedDecrypter(4427264186003912112L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-5925596232892992777L), SimpleLongDecrypter.getCachedDecrypter(-1060440851915341303L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-4211444530536527988L), SimpleLongDecrypter.getCachedDecrypter(-2746922616728108890L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(6440277512906977357L), SimpleLongDecrypter.getCachedDecrypter(7255233799140836900L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-214429447646150338L), SimpleLongDecrypter.getCachedDecrypter(-4288220978619611165L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(5783630001182493123L), SimpleLongDecrypter.getCachedDecrypter(668631230446192293L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(1492331395273011929L), SimpleLongDecrypter.getCachedDecrypter(3196002195676928438L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-219262937525704579L), SimpleLongDecrypter.getCachedDecrypter(-3328836543514286404L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(1491930307179816510L), SimpleLongDecrypter.getCachedDecrypter(3575864876251461797L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-3032704322594353123L), SimpleLongDecrypter.getCachedDecrypter(-2584437128016956105L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-2501939326423066686L), SimpleLongDecrypter.getCachedDecrypter(-3443470215988730983L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-6025989339737815656L), SimpleLongDecrypter.getCachedDecrypter(-727070217491950877L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(4377546815298955053L), SimpleLongDecrypter.getCachedDecrypter(-7713888936009496807L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(1223316477089837666L), SimpleLongDecrypter.getCachedDecrypter(5852355652943671400L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(2906065153346711344L), SimpleLongDecrypter.getCachedDecrypter(-4588369808080052021L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-180833071244128351L), SimpleLongDecrypter.getCachedDecrypter(7261201523170080567L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-6610585593858119241L), SimpleLongDecrypter.getCachedDecrypter(586998087746943813L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-1590140978487009068L), SimpleLongDecrypter.getCachedDecrypter(-3091326785878963564L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(5549053739051001678L), SimpleLongDecrypter.getCachedDecrypter(8373925505099782927L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-8881730220976124521L), SimpleLongDecrypter.getCachedDecrypter(-5361174598842081823L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-7481964983063069625L), SimpleLongDecrypter.getCachedDecrypter(-2505162514269137582L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(4088366279472734208L), SimpleLongDecrypter.getCachedDecrypter(-9220748014060917752L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-7768126979992879027L), SimpleLongDecrypter.getCachedDecrypter(-2772805787504854895L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(6349326039416540707L), SimpleLongDecrypter.getCachedDecrypter(-1926317975031238613L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-3652854834267099769L), SimpleLongDecrypter.getCachedDecrypter(1851359584508198503L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(5771750400656787494L), SimpleLongDecrypter.getCachedDecrypter(-2772702260440151093L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(715734041292136875L), SimpleLongDecrypter.getCachedDecrypter(4428502305950130425L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-6534615948151037167L), SimpleLongDecrypter.getCachedDecrypter(60864792920822986L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-5955887808655913151L), SimpleLongDecrypter.getCachedDecrypter(2422404253389130711L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(8363028041646467769L), SimpleLongDecrypter.getCachedDecrypter(8771565867046695252L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-5051416571532622699L), SimpleLongDecrypter.getCachedDecrypter(3210106042755029436L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(3281568862634955965L), SimpleLongDecrypter.getCachedDecrypter(1263794432885518897L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-6492090397442386768L), SimpleLongDecrypter.getCachedDecrypter(-4801563183523760060L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-7141600573628064531L), SimpleLongDecrypter.getCachedDecrypter(-6529624141516642017L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-527939303505038826L), SimpleLongDecrypter.getCachedDecrypter(2957227917611903662L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(4355770457751719495L), SimpleLongDecrypter.getCachedDecrypter(-7718891852913039262L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(5316729612445016017L), SimpleLongDecrypter.getCachedDecrypter(-5692521851463906765L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-7186242685839529504L), SimpleLongDecrypter.getCachedDecrypter(3492819034401456821L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-263669425792222283L), SimpleLongDecrypter.getCachedDecrypter(-8901060055377406733L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-1998778094412529463L), SimpleLongDecrypter.getCachedDecrypter(4672129580086528837L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-3900418952085978002L), SimpleLongDecrypter.getCachedDecrypter(7267359594722828844L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-7102868889770148389L), SimpleLongDecrypter.getCachedDecrypter(2958324859534854859L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-8896387127649430804L), SimpleLongDecrypter.getCachedDecrypter(2678908032703626035L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-1694058600109406174L), SimpleLongDecrypter.getCachedDecrypter(-236507534990845948L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(71814265845636330L), SimpleLongDecrypter.getCachedDecrypter(2124720226958629305L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-6293092409985383305L), SimpleLongDecrypter.getCachedDecrypter(-4568271758540731463L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-6574951097590622724L), SimpleLongDecrypter.getCachedDecrypter(7567512715530343742L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-5131286056932931629L), SimpleLongDecrypter.getCachedDecrypter(-5937793708416141430L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(5837741365045733643L), SimpleLongDecrypter.getCachedDecrypter(2126352550892598446L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(8083143949749767200L), SimpleLongDecrypter.getCachedDecrypter(-6016707722115083596L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-8540801851551410431L), SimpleLongDecrypter.getCachedDecrypter(4923712654088419718L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-2550343766101346061L), SimpleLongDecrypter.getCachedDecrypter(2602699110681787371L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-8035448723394677595L), SimpleLongDecrypter.getCachedDecrypter(-6600243351589117561L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(6066643048569261214L), SimpleLongDecrypter.getCachedDecrypter(-3892493299303233206L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(1222214426463750927L), SimpleLongDecrypter.getCachedDecrypter(-196603229884274416L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-9214492422392729088L), SimpleLongDecrypter.getCachedDecrypter(-5068673389840986176L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(7637908085072340745L), SimpleLongDecrypter.getCachedDecrypter(-4776598915055900017L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-6839058428408281656L), SimpleLongDecrypter.getCachedDecrypter(-7074758740037835804L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(7494654135777169400L), SimpleLongDecrypter.getCachedDecrypter(-7356485946352041971L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(3287263796659164665L), SimpleLongDecrypter.getCachedDecrypter(8944644142814857886L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(7325928128014796668L), SimpleLongDecrypter.getCachedDecrypter(1571355323198027406L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-1893471620220551826L), SimpleLongDecrypter.getCachedDecrypter(-3385497531314433003L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-1628201339298549965L), SimpleLongDecrypter.getCachedDecrypter(-5128453860684904760L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-3029627814614514571L), SimpleLongDecrypter.getCachedDecrypter(8157872703053348528L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(5258968202611884222L), SimpleLongDecrypter.getCachedDecrypter(-286307034775532370L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(9039056590888679939L), SimpleLongDecrypter.getCachedDecrypter(8694807994543145401L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-6891491388041718087L), SimpleLongDecrypter.getCachedDecrypter(2412700916478034709L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-8906868652891041563L), SimpleLongDecrypter.getCachedDecrypter(4691696738777908567L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(5312065789986746707L), SimpleLongDecrypter.getCachedDecrypter(5803029651452380379L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-7717907006842938542L), SimpleLongDecrypter.getCachedDecrypter(2991012968636384077L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(5507596484866732711L), SimpleLongDecrypter.getCachedDecrypter(-5465885038072617469L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(8404183836537216426L), SimpleLongDecrypter.getCachedDecrypter(-1931188627568012480L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-2179201491355106044L), SimpleLongDecrypter.getCachedDecrypter(-4879920708571577692L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-1409691154278372934L), SimpleLongDecrypter.getCachedDecrypter(-5384254395932355638L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-3453771697326360111L), SimpleLongDecrypter.getCachedDecrypter(4960648935227833319L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(2608384410456575161L), SimpleLongDecrypter.getCachedDecrypter(-4492280417691094754L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-4760060870418116133L), SimpleLongDecrypter.getCachedDecrypter(-3728313348415743802L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(7894521952164935343L), SimpleLongDecrypter.getCachedDecrypter(3877219082462248588L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-2529885501562409053L), SimpleLongDecrypter.getCachedDecrypter(-1876089266242849831L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-3144057267821837707L), SimpleLongDecrypter.getCachedDecrypter(2674097330007448636L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-9136901137518187681L), SimpleLongDecrypter.getCachedDecrypter(-1878907481491024228L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(7348190784814928224L), SimpleLongDecrypter.getCachedDecrypter(7852009303630559581L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-1044461416248473699L), SimpleLongDecrypter.getCachedDecrypter(7267178572744184225L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-5139691850684570010L), SimpleLongDecrypter.getCachedDecrypter(9010470221632476100L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(2409882409050750845L), SimpleLongDecrypter.getCachedDecrypter(7581323364678862008L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(4907458534843161739L), SimpleLongDecrypter.getCachedDecrypter(-7448922759746595400L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(5248182274947579036L), SimpleLongDecrypter.getCachedDecrypter(-1421841150762046228L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(7498516839558184552L), SimpleLongDecrypter.getCachedDecrypter(595962783201542952L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(6281843890197881L), SimpleLongDecrypter.getCachedDecrypter(-8254316574705443778L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-147613254999963452L), SimpleLongDecrypter.getCachedDecrypter(1223397166028208495L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(6387162671490187706L), SimpleLongDecrypter.getCachedDecrypter(-9211997347803281366L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(6999683366765816081L), SimpleLongDecrypter.getCachedDecrypter(1195898219976600368L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(695002588098054132L), SimpleLongDecrypter.getCachedDecrypter(5249682973350786900L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-7352755087300711694L), SimpleLongDecrypter.getCachedDecrypter(4910912199222662380L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(1264592743495977529L), SimpleLongDecrypter.getCachedDecrypter(1850615798518152557L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-8224688088659832094L), SimpleLongDecrypter.getCachedDecrypter(-7964210703637142179L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-4316289882413605179L), SimpleLongDecrypter.getCachedDecrypter(-483099721547879586L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-1123120505182694242L), SimpleLongDecrypter.getCachedDecrypter(-3384451414840920336L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-8551642201846707003L), SimpleLongDecrypter.getCachedDecrypter(5213238675056207173L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-4591713452930733747L), SimpleLongDecrypter.getCachedDecrypter(-2164857960914071176L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(1493272765368449123L), SimpleLongDecrypter.getCachedDecrypter(-1337080035100161358L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(9041940441655793022L), SimpleLongDecrypter.getCachedDecrypter(313366383327839895L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-201629169987813590L), SimpleLongDecrypter.getCachedDecrypter(7496412350308707625L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(4663270512341825932L), SimpleLongDecrypter.getCachedDecrypter(1773830343119874533L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-7699088518979642231L), SimpleLongDecrypter.getCachedDecrypter(6374061335307503747L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(6758068971812962151L), SimpleLongDecrypter.getCachedDecrypter(-847590117847124491L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(8073844874654153585L), SimpleLongDecrypter.getCachedDecrypter(8945866317369207938L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(3863530974432051960L), SimpleLongDecrypter.getCachedDecrypter(-7975909672163484254L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-6809852124200845774L), SimpleLongDecrypter.getCachedDecrypter(-1336652458517825620L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-7148700429013183315L), SimpleLongDecrypter.getCachedDecrypter(4721253067017717402L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(8937311634691541939L), SimpleLongDecrypter.getCachedDecrypter(945038507445065938L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-7997821595170852310L), SimpleLongDecrypter.getCachedDecrypter(8446901729150954611L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(880237017360152410L), SimpleLongDecrypter.getCachedDecrypter(9024995846141370010L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-3051952586062477277L), SimpleLongDecrypter.getCachedDecrypter(409621813950816474L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-4799827891497935367L), SimpleLongDecrypter.getCachedDecrypter(-1626590474600274374L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(650107507199714739L), SimpleLongDecrypter.getCachedDecrypter(6984815589504016245L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(4736558873264345034L), SimpleLongDecrypter.getCachedDecrypter(4970005825937087090L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(7828943434147797614L), SimpleLongDecrypter.getCachedDecrypter(5794621034987548573L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-5084076892050157094L), SimpleLongDecrypter.getCachedDecrypter(-1710288253199838468L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(7537515195847269063L), SimpleLongDecrypter.getCachedDecrypter(-7090459800986468781L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-4756008601783500290L), SimpleLongDecrypter.getCachedDecrypter(-5704287839992275066L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(4098021295170918336L), SimpleLongDecrypter.getCachedDecrypter(-9195286120483943947L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-8920645766759993205L), SimpleLongDecrypter.getCachedDecrypter(-9176298249449508617L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-9133604005136949743L), SimpleLongDecrypter.getCachedDecrypter(5891156745608422428L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(3593119228420575928L), SimpleLongDecrypter.getCachedDecrypter(-1588711730728175292L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-2748598289438532100L), SimpleLongDecrypter.getCachedDecrypter(1235401990882950507L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-8635486025413912983L), SimpleLongDecrypter.getCachedDecrypter(8678006655306999227L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(6652954385099610594L), SimpleLongDecrypter.getCachedDecrypter(-7475076092827099586L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(1204474108967526618L), SimpleLongDecrypter.getCachedDecrypter(-1349546363815376642L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(7332742017608784652L), SimpleLongDecrypter.getCachedDecrypter(2092511613661685898L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-5976531005480578153L), SimpleLongDecrypter.getCachedDecrypter(4436533447829410100L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-8817950554382514728L), SimpleLongDecrypter.getCachedDecrypter(-6568323932816453443L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-5062035917807044668L), SimpleLongDecrypter.getCachedDecrypter(-3039250002955690430L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-1903137008153056001L), SimpleLongDecrypter.getCachedDecrypter(3203972524286510032L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(6098678655073322424L), SimpleLongDecrypter.getCachedDecrypter(-8594472797276382706L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(1735012428973313106L), SimpleLongDecrypter.getCachedDecrypter(-5633265653656335080L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(4719790616637468365L), SimpleLongDecrypter.getCachedDecrypter(-9169427411310259033L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(5552971854452280191L), SimpleLongDecrypter.getCachedDecrypter(-7984791382272857340L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-3066874635686529033L), SimpleLongDecrypter.getCachedDecrypter(2947520042059342368L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-2281377643799991032L), SimpleLongDecrypter.getCachedDecrypter(-4209151965905991241L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-4771595937178648796L), SimpleLongDecrypter.getCachedDecrypter(-1664659111482949208L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(347161798952888429L), SimpleLongDecrypter.getCachedDecrypter(-5656185654092647082L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(8739143482759446867L), SimpleLongDecrypter.getCachedDecrypter(-1922875466698991023L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-500703858091556936L), SimpleLongDecrypter.getCachedDecrypter(-3715277533349636735L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(3302642848026906174L), SimpleLongDecrypter.getCachedDecrypter(4998534105988418249L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(7901888478383900931L), SimpleLongDecrypter.getCachedDecrypter(7214236370700066333L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(3755103406563357922L), SimpleLongDecrypter.getCachedDecrypter(2158545604330204929L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(8773366351179099234L), SimpleLongDecrypter.getCachedDecrypter(-5419769699250861473L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(6168262080810762909L), SimpleLongDecrypter.getCachedDecrypter(684957212441402385L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(3288466689738668460L), SimpleLongDecrypter.getCachedDecrypter(-1625215497473758629L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-6003516724440293926L), SimpleLongDecrypter.getCachedDecrypter(598500374108042934L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-3710058766762053522L), SimpleLongDecrypter.getCachedDecrypter(-7666295778289477563L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-6901949346289736851L), SimpleLongDecrypter.getCachedDecrypter(3755857878950170728L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(9006862177158857375L), SimpleLongDecrypter.getCachedDecrypter(-1600319696196233767L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-5421770309421669591L), SimpleLongDecrypter.getCachedDecrypter(-3347722771785935964L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-8867824928011291840L), SimpleLongDecrypter.getCachedDecrypter(6387790868112881312L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-3417276103553292344L), SimpleLongDecrypter.getCachedDecrypter(-6049832740651119023L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(6143652468241353324L), SimpleLongDecrypter.getCachedDecrypter(-1310622359509761826L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(8436168856149594982L), SimpleLongDecrypter.getCachedDecrypter(6135119076353691046L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(4973918597874473968L), SimpleLongDecrypter.getCachedDecrypter(-4573703335541253815L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-3964803241783440351L), SimpleLongDecrypter.getCachedDecrypter(8679790617169156596L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-4254581879934012842L), SimpleLongDecrypter.getCachedDecrypter(2103576313087505102L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(9019474978509167179L), SimpleLongDecrypter.getCachedDecrypter(3290457990210939943L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-6800515397527062631L), SimpleLongDecrypter.getCachedDecrypter(-6568254369893890675L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-3715297324198080490L), SimpleLongDecrypter.getCachedDecrypter(-1149688180220361595L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-521863588289927802L), SimpleLongDecrypter.getCachedDecrypter(-5175396131557048147L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(1190135021245367557L), SimpleLongDecrypter.getCachedDecrypter(1006464993654372986L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(1275959633097942215L), SimpleLongDecrypter.getCachedDecrypter(3781112736488442916L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-7750706669242774885L), SimpleLongDecrypter.getCachedDecrypter(7839846077020171420L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-4308094044460578045L), SimpleLongDecrypter.getCachedDecrypter(-4256035369776659989L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(5281780278039787975L), SimpleLongDecrypter.getCachedDecrypter(-2264200617093950733L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(1792071502732154704L), SimpleLongDecrypter.getCachedDecrypter(7850492881837011555L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-5746837124257294904L), SimpleLongDecrypter.getCachedDecrypter(-2809134681157261729L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(3528610481976043379L), SimpleLongDecrypter.getCachedDecrypter(6687717350548646942L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-3716251662867236596L), SimpleLongDecrypter.getCachedDecrypter(-258317200230259382L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-3974683003793424813L), SimpleLongDecrypter.getCachedDecrypter(-811748818979807833L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(4939793604354115991L), SimpleLongDecrypter.getCachedDecrypter(-2465471677113515533L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-1042987680052184023L), SimpleLongDecrypter.getCachedDecrypter(584089247558725951L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(7861373524490280204L), SimpleLongDecrypter.getCachedDecrypter(-2172804652123645089L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-563678048935346948L), SimpleLongDecrypter.getCachedDecrypter(8426183188225426213L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(8358963481449245126L), SimpleLongDecrypter.getCachedDecrypter(3173036501582914690L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(9049221933985816542L), SimpleLongDecrypter.getCachedDecrypter(8442554593888980273L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-1712101187622935087L), SimpleLongDecrypter.getCachedDecrypter(8119983400340874062L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-7780534423075591407L), SimpleLongDecrypter.getCachedDecrypter(8386602842607388999L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-790676696379318782L), SimpleLongDecrypter.getCachedDecrypter(-5129479948026193304L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-4591661646256641820L), SimpleLongDecrypter.getCachedDecrypter(-8050914385498772224L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-6047876199025371995L), SimpleLongDecrypter.getCachedDecrypter(4690110471719632313L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-3355238867795176293L), SimpleLongDecrypter.getCachedDecrypter(-5638797927326793291L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-8802333553156363406L), SimpleLongDecrypter.getCachedDecrypter(-730848231735615841L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-6226159061042810425L), SimpleLongDecrypter.getCachedDecrypter(5540343810227262915L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-2193635827172266278L), SimpleLongDecrypter.getCachedDecrypter(-1696142901830016820L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(960494692552474948L), SimpleLongDecrypter.getCachedDecrypter(70773218947454695L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(1809771950602830896L), SimpleLongDecrypter.getCachedDecrypter(-7753899412190998864L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(4141496314410354572L), SimpleLongDecrypter.getCachedDecrypter(1832164222503285199L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-7649292868285643725L), SimpleLongDecrypter.getCachedDecrypter(-6325499150233226055L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(7605642656589494291L), SimpleLongDecrypter.getCachedDecrypter(-2548716948714553278L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(1734334727375576022L), SimpleLongDecrypter.getCachedDecrypter(3220698892576959918L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(2686370953227063774L), SimpleLongDecrypter.getCachedDecrypter(305409315799334911L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-1897481519579626572L), SimpleLongDecrypter.getCachedDecrypter(-2751747783461316945L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(4663871168583513295L), SimpleLongDecrypter.getCachedDecrypter(-3979253196117895600L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-5460745413330207222L), SimpleLongDecrypter.getCachedDecrypter(4620762718186237175L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(3588284332553904244L), SimpleLongDecrypter.getCachedDecrypter(-6902029257664264177L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(7563184428860464652L), SimpleLongDecrypter.getCachedDecrypter(3490181721326752184L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(7889274929420804578L), SimpleLongDecrypter.getCachedDecrypter(8758475353419695595L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-2515811868483019673L), SimpleLongDecrypter.getCachedDecrypter(3855527583756474464L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(1291970856217711801L), SimpleLongDecrypter.getCachedDecrypter(-8930469712751266876L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(8937603882921327349L), SimpleLongDecrypter.getCachedDecrypter(-1975240139780191833L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(1765243263429148089L), SimpleLongDecrypter.getCachedDecrypter(6961583135071547444L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-2542599161154009545L), SimpleLongDecrypter.getCachedDecrypter(705725026242874803L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(4906408440894571949L), SimpleLongDecrypter.getCachedDecrypter(8723233914991699155L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(5206671415663236908L), SimpleLongDecrypter.getCachedDecrypter(6690231533746757456L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-7074036276421817115L), SimpleLongDecrypter.getCachedDecrypter(-1984944125376123320L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-5048310770541538716L), SimpleLongDecrypter.getCachedDecrypter(887561832302026659L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-8525305200200411342L), SimpleLongDecrypter.getCachedDecrypter(-6595628357771460746L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-3430046121349071691L), SimpleLongDecrypter.getCachedDecrypter(-4828744663515814268L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(5582264511105333593L), SimpleLongDecrypter.getCachedDecrypter(4986052575563163876L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(44003936618149971L), SimpleLongDecrypter.getCachedDecrypter(-5708486550225475586L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-7734337008107580329L), SimpleLongDecrypter.getCachedDecrypter(3293249077325077361L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-7730772720757962214L), SimpleLongDecrypter.getCachedDecrypter(6975892530884078890L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(4104319495399167867L), SimpleLongDecrypter.getCachedDecrypter(3761568695020784797L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(8745057353279302527L), SimpleLongDecrypter.getCachedDecrypter(2108759355814584723L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-7735684521719391255L), SimpleLongDecrypter.getCachedDecrypter(-7947250324030833369L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(2121502035769794282L), SimpleLongDecrypter.getCachedDecrypter(-1639710334935190186L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-4560665851195392979L), SimpleLongDecrypter.getCachedDecrypter(-7643588173594849316L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(3175064200664682173L), SimpleLongDecrypter.getCachedDecrypter(-4538701175582596679L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(8742753538918026698L), SimpleLongDecrypter.getCachedDecrypter(7545516579952798464L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-7391800965493911704L), SimpleLongDecrypter.getCachedDecrypter(-6340839970434227303L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-2537540532986830240L), SimpleLongDecrypter.getCachedDecrypter(1770154347045830801L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-3620973675030184105L), SimpleLongDecrypter.getCachedDecrypter(4384090162738111855L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(7322247095322807960L), SimpleLongDecrypter.getCachedDecrypter(4944573090023120482L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-1895236251571127620L), SimpleLongDecrypter.getCachedDecrypter(-8929863096608853337L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(884863938271635180L), SimpleLongDecrypter.getCachedDecrypter(-8067988997643043262L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(4999607867818820525L), SimpleLongDecrypter.getCachedDecrypter(-2208577611342627927L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(4154585203116481863L), SimpleLongDecrypter.getCachedDecrypter(2341250000541172457L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-4192384563149033680L), SimpleLongDecrypter.getCachedDecrypter(6468694684346464406L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(5037618242065483997L), SimpleLongDecrypter.getCachedDecrypter(2611841353141181865L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(6462942554551950377L), SimpleLongDecrypter.getCachedDecrypter(1498288205430034804L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-2511155065117184969L), SimpleLongDecrypter.getCachedDecrypter(-7381704678570766320L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-5157197611035504556L), SimpleLongDecrypter.getCachedDecrypter(865611761732747624L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-3343002020285337644L), SimpleLongDecrypter.getCachedDecrypter(-2249412872604940178L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(3282332264316179951L), SimpleLongDecrypter.getCachedDecrypter(-3066040324347096177L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(3024061599094657868L), SimpleLongDecrypter.getCachedDecrypter(8376145769472715928L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(1798812660256384710L), SimpleLongDecrypter.getCachedDecrypter(-2480353566557868789L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-4294557635825919419L), SimpleLongDecrypter.getCachedDecrypter(2683623872915879412L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(2074335053624586460L), SimpleLongDecrypter.getCachedDecrypter(-3369576012847444632L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-5059692913957364661L), SimpleLongDecrypter.getCachedDecrypter(-5351233918081139383L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-4022908255526003729L), SimpleLongDecrypter.getCachedDecrypter(5858163224426797121L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-2878953059557936600L), SimpleLongDecrypter.getCachedDecrypter(316809037415838994L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-3714564374358119577L), SimpleLongDecrypter.getCachedDecrypter(1450842524459528819L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(5211400883067034758L), SimpleLongDecrypter.getCachedDecrypter(-2818341821640899078L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-5378881317216735058L), SimpleLongDecrypter.getCachedDecrypter(6744729758658474146L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(6356700196631382995L), SimpleLongDecrypter.getCachedDecrypter(4366433396549276902L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(5791437668132087070L), SimpleLongDecrypter.getCachedDecrypter(-4232822992761907045L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-4818867388790180897L), SimpleLongDecrypter.getCachedDecrypter(717577665967524490L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-1941855642001634076L), SimpleLongDecrypter.getCachedDecrypter(-8530290889501597410L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-7657073007055372566L), SimpleLongDecrypter.getCachedDecrypter(8967426794768337168L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-8247914220083600624L), SimpleLongDecrypter.getCachedDecrypter(-5431319790483011655L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(587050438728742639L), SimpleLongDecrypter.getCachedDecrypter(9076088852825925276L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-4190389184572129517L), SimpleLongDecrypter.getCachedDecrypter(2098920076425194885L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(4044225675458059685L), SimpleLongDecrypter.getCachedDecrypter(-7134179120593406730L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-9181628685270266698L), SimpleLongDecrypter.getCachedDecrypter(-6008496031623360801L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(1496800846042828550L), SimpleLongDecrypter.getCachedDecrypter(-4009427693864208901L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(938635367436514772L), SimpleLongDecrypter.getCachedDecrypter(-2742069584845773684L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-7126905841261621814L), SimpleLongDecrypter.getCachedDecrypter(3024999319577403797L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-6226538094819036807L), SimpleLongDecrypter.getCachedDecrypter(-1980196689557545830L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-6540759721564953637L), SimpleLongDecrypter.getCachedDecrypter(8367882716021216621L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(2158407643444234958L), SimpleLongDecrypter.getCachedDecrypter(-6589174471551428379L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(2663299722029063255L), SimpleLongDecrypter.getCachedDecrypter(5828206980773513016L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-4762335988125210044L), SimpleLongDecrypter.getCachedDecrypter(-6608079257766783629L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(2432868806034485315L), SimpleLongDecrypter.getCachedDecrypter(5503870235002682362L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-5740215336853136786L), SimpleLongDecrypter.getCachedDecrypter(-8928871186177645747L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-1148648656267208763L), SimpleLongDecrypter.getCachedDecrypter(4051219623424522588L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(4941697592576018334L), SimpleLongDecrypter.getCachedDecrypter(-5994312648718011507L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-1704187014754952995L), SimpleLongDecrypter.getCachedDecrypter(3547335808129356930L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-5670155132538582186L), SimpleLongDecrypter.getCachedDecrypter(-4021903949692044771L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(8648129641541796150L), SimpleLongDecrypter.getCachedDecrypter(4038814075528244401L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-1098184385911367566L), SimpleLongDecrypter.getCachedDecrypter(583674954110935914L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-8518943792376654678L), SimpleLongDecrypter.getCachedDecrypter(-4299590193478047579L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(5583565955978027011L), SimpleLongDecrypter.getCachedDecrypter(-6910488988854344139L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-7403368338833851502L), SimpleLongDecrypter.getCachedDecrypter(-8882924461368230529L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-804773006690544867L), SimpleLongDecrypter.getCachedDecrypter(-7638152299287124719L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-7153191483446026286L), SimpleLongDecrypter.getCachedDecrypter(4462595492018806704L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(83836970632894239L), SimpleLongDecrypter.getCachedDecrypter(-1616517667815770477L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-4875548303129679023L), SimpleLongDecrypter.getCachedDecrypter(6384459916493475941L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(1551027505266410121L), SimpleLongDecrypter.getCachedDecrypter(-5465329494238646551L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-2806360784934708738L), SimpleLongDecrypter.getCachedDecrypter(298868575196312711L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(5012024348948679665L), SimpleLongDecrypter.getCachedDecrypter(-5064347476252312524L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-8883277064780163494L), SimpleLongDecrypter.getCachedDecrypter(905254666895210424L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(7219501161889905404L), SimpleLongDecrypter.getCachedDecrypter(-8925088278891271800L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-7186394649514926800L), SimpleLongDecrypter.getCachedDecrypter(6431696377447326360L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-3972753837674093418L), SimpleLongDecrypter.getCachedDecrypter(-3628299120818631267L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(6924261653161073669L), SimpleLongDecrypter.getCachedDecrypter(-3047275480645935528L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-5046493874068884037L), SimpleLongDecrypter.getCachedDecrypter(1270533176964296392L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-2780920879878228734L), SimpleLongDecrypter.getCachedDecrypter(3594900970855051675L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(636014501972012612L), SimpleLongDecrypter.getCachedDecrypter(28995404127599640L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(6761655198339965131L), SimpleLongDecrypter.getCachedDecrypter(-4224168946513108523L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(5492084042060543319L), SimpleLongDecrypter.getCachedDecrypter(2639204119816161715L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-3699975696360045275L), SimpleLongDecrypter.getCachedDecrypter(6133802496689836296L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(937195869627976846L), SimpleLongDecrypter.getCachedDecrypter(7570835798716730348L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(6174128940432524737L), SimpleLongDecrypter.getCachedDecrypter(-1058017539307175724L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-3316217894472314747L), SimpleLongDecrypter.getCachedDecrypter(-237727739795135511L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-2756339726546441898L), SimpleLongDecrypter.getCachedDecrypter(-4591316575299744016L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-1597024828144881148L), SimpleLongDecrypter.getCachedDecrypter(-8321054387088012716L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-514912897448158268L), SimpleLongDecrypter.getCachedDecrypter(3602766394303021835L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-255115137693080702L), SimpleLongDecrypter.getCachedDecrypter(-4271471853115380530L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-2198764693148899792L), SimpleLongDecrypter.getCachedDecrypter(9025599187631072310L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(4178620057943593358L), SimpleLongDecrypter.getCachedDecrypter(1244201843352156955L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-6841705085751293229L), SimpleLongDecrypter.getCachedDecrypter(-8822404115599395840L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-1589655370552556382L), SimpleLongDecrypter.getCachedDecrypter(6691401928941216675L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(2150961324032054923L), SimpleLongDecrypter.getCachedDecrypter(4382514385847483248L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(8127584130845832708L), SimpleLongDecrypter.getCachedDecrypter(-6017857994005128969L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-3157210340724992738L), SimpleLongDecrypter.getCachedDecrypter(3529039537011162263L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(8084400598368831262L), SimpleLongDecrypter.getCachedDecrypter(-6620451447141414730L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(8732834240164360591L), SimpleLongDecrypter.getCachedDecrypter(-3422174284513251777L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(1507590849516390916L), SimpleLongDecrypter.getCachedDecrypter(8363616092015084553L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(5285755795586184646L), SimpleLongDecrypter.getCachedDecrypter(-3074003063778089212L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(4956484603977669786L), SimpleLongDecrypter.getCachedDecrypter(911604087610449143L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(5488100622532427868L), SimpleLongDecrypter.getCachedDecrypter(-4026304414388370747L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-3135131658996610645L), SimpleLongDecrypter.getCachedDecrypter(2077502840136124922L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(8071594428260008665L), SimpleLongDecrypter.getCachedDecrypter(2332279856418147471L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-785097048178623266L), SimpleLongDecrypter.getCachedDecrypter(-1934815618690209865L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(4709456550372057950L), SimpleLongDecrypter.getCachedDecrypter(-7072340696347576710L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-7703096981267062444L), SimpleLongDecrypter.getCachedDecrypter(7793121221615226181L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-219420038788743913L), SimpleLongDecrypter.getCachedDecrypter(7823797609453934590L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(4116925203472247863L), SimpleLongDecrypter.getCachedDecrypter(-5405996950275448345L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(5795635626668754096L), SimpleLongDecrypter.getCachedDecrypter(-8248219541938253055L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(359145258106717703L), SimpleLongDecrypter.getCachedDecrypter(1275997761567607892L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(6149735307064627390L), SimpleLongDecrypter.getCachedDecrypter(9025480950336821237L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-7692011574225327606L), SimpleLongDecrypter.getCachedDecrypter(6735928068536794648L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(2406864935422365862L), SimpleLongDecrypter.getCachedDecrypter(-9198490433901094271L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-1715406417145256371L), SimpleLongDecrypter.getCachedDecrypter(-3929180015599318279L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(-7740049226103557519L), SimpleLongDecrypter.getCachedDecrypter(2598349219060717877L));
    var10000.put(SimpleLongDecrypter.getCachedDecrypter(8073094865408628434L), SimpleLongDecrypter.getCachedDecrypter(-4804217907428580323L));
  }

  private void setupEncryptionInts() {
    int[] var10000 = SimpleLongDecrypter.getCachedDecrypter(2443998190580209211L).getEncryptionInts();
    var10000[0] = -13;
    var10000[1] = -46;
    var10000[2] = -2;
    var10000[3] = -14;
    var10000[4] = 2;
    var10000[5] = -33;
    var10000[6] = -19;
    var10000[7] = -17;
    var10000[8] = -10;
    var10000[9] = -30;
    var10000[10] = -11;
    var10000[11] = -19;
    var10000[12] = -33;
    var10000[13] = 13;
    var10000[14] = -30;
    var10000[15] = -44;
    var10000[16] = -40;
    var10000[17] = 14;
    var10000[18] = 10;
    var10000[19] = -23;
    var10000[20] = -13;
    var10000[21] = 11;
    var10000[22] = -38;
    var10000[23] = -28;
    var10000[24] = 17;
    var10000[25] = 19;
    var10000[26] = -11;
    var10000[27] = -22;
    var10000[28] = -8;
    var10000[29] = -34;
    var10000[30] = 19;
    var10000[31] = -30;
    var10000[32] = -9;
    var10000[33] = 13;
    var10000[34] = -24;
    var10000[35] = -19;
    var10000[36] = 8;
    var10000[37] = 11;
    var10000[38] = 33;
    var10000[39] = 30;
    var10000[40] = -13;
    var10000[41] = 9;
    var10000[42] = 23;
    var10000[43] = -19;
    var10000[44] = 30;
    var10000[45] = 33;
    var10000[46] = -6;
    var10000[47] = 46;
    var10000[48] = -2;
    var10000[49] = 22;
    var10000[50] = 2;
    var10000[51] = 28;
    var10000[52] = 6;
    var10000[53] = 13;
    var10000[54] = 19;
    var10000[55] = -2;
    var10000[56] = 40;
    var10000[57] = 2;
    var10000[58] = 24;
    var10000[59] = 44;
    var10000[60] = 38;
    var10000[61] = 30;
    var10000[62] = 19;
    var10000[63] = 34;
    int[] var10001 = SimpleLongDecrypter.getCachedDecrypter(-732174610889469645L).getEncryptionInts();
    var10001[0] = -47;
    var10001[1] = -29;
    var10001[2] = -20;
    var10001[3] = -12;
    var10001[4] = -58;
    var10001[5] = -11;
    var10001[6] = -32;
    var10001[7] = -48;
    var10001[8] = -4;
    var10001[9] = -8;
    var10001[10] = -31;
    var10001[11] = -34;
    var10001[12] = 4;
    var10001[13] = -40;
    var10001[14] = -28;
    var10001[15] = 12;
    var10001[16] = 11;
    var10001[17] = 8;
    var10001[18] = -45;
    var10001[19] = -25;
    var10001[20] = -13;
    var10001[21] = -15;
    var10001[22] = 20;
    var10001[23] = -38;
    var10001[24] = -28;
    var10001[25] = -23;
    var10001[26] = -3;
    var10001[27] = -12;
    var10001[28] = -6;
    var10001[29] = 3;
    var10001[30] = 29;
    var10001[31] = -19;
    var10001[32] = -14;
    var10001[33] = 13;
    var10001[34] = 6;
    var10001[35] = -19;
    var10001[36] = 15;
    var10001[37] = -21;
    var10001[38] = 32;
    var10001[39] = 12;
    var10001[40] = -9;
    var10001[41] = 31;
    var10001[42] = 28;
    var10001[43] = -16;
    var10001[44] = 25;
    var10001[45] = 34;
    var10001[46] = 14;
    var10001[47] = 47;
    var10001[48] = 23;
    var10001[49] = 9;
    var10001[50] = 19;
    var10001[51] = -5;
    var10001[52] = 28;
    var10001[53] = 40;
    var10001[54] = 19;
    var10001[55] = 48;
    var10001[56] = 5;
    var10001[57] = -3;
    var10001[58] = 21;
    var10001[59] = 16;
    var10001[60] = 3;
    var10001[61] = 38;
    var10001[62] = 58;
    var10001[63] = 45;
    int[] var10002 = SimpleLongDecrypter.getCachedDecrypter(311277116407346596L).getEncryptionInts();
    var10002[0] = -13;
    var10002[1] = -46;
    var10002[2] = -2;
    var10002[3] = -14;
    var10002[4] = 2;
    var10002[5] = -33;
    var10002[6] = -19;
    var10002[7] = -17;
    var10002[8] = -15;
    var10002[9] = -22;
    var10002[10] = -9;
    var10002[11] = -39;
    var10002[12] = -2;
    var10002[13] = 13;
    var10002[14] = 2;
    var10002[15] = -38;
    var10002[16] = -10;
    var10002[17] = 14;
    var10002[18] = -23;
    var10002[19] = 9;
    var10002[20] = -14;
    var10002[21] = -42;
    var10002[22] = -10;
    var10002[23] = 15;
    var10002[24] = 17;
    var10002[25] = 19;
    var10002[26] = 10;
    var10002[27] = -24;
    var10002[28] = -2;
    var10002[29] = -4;
    var10002[30] = 2;
    var10002[31] = 22;
    var10002[32] = 10;
    var10002[33] = 4;
    var10002[34] = 14;
    var10002[35] = -21;
    var10002[36] = -10;
    var10002[37] = -3;
    var10002[38] = 33;
    var10002[39] = -10;
    var10002[40] = 3;
    var10002[41] = 23;
    var10002[42] = -18;
    var10002[43] = -1;
    var10002[44] = 1;
    var10002[45] = -14;
    var10002[46] = 10;
    var10002[47] = 46;
    var10002[48] = -4;
    var10002[49] = 10;
    var10002[50] = 39;
    var10002[51] = 24;
    var10002[52] = 4;
    var10002[53] = 38;
    var10002[54] = -7;
    var10002[55] = -2;
    var10002[56] = 21;
    var10002[57] = 2;
    var10002[58] = -4;
    var10002[59] = 14;
    var10002[60] = 18;
    var10002[61] = 7;
    var10002[62] = 4;
    var10002[63] = 42;
    int[] var10003 = SimpleLongDecrypter.getCachedDecrypter(3573886869861327935L).getEncryptionInts();
    var10003[0] = -13;
    var10003[1] = -46;
    var10003[2] = -2;
    var10003[3] = -14;
    var10003[4] = 2;
    var10003[5] = -33;
    var10003[6] = -19;
    var10003[7] = -17;
    var10003[8] = -28;
    var10003[9] = -13;
    var10003[10] = -21;
    var10003[11] = -15;
    var10003[12] = -50;
    var10003[13] = 13;
    var10003[14] = -49;
    var10003[15] = -5;
    var10003[16] = -16;
    var10003[17] = 14;
    var10003[18] = -5;
    var10003[19] = -40;
    var10003[20] = 5;
    var10003[21] = -13;
    var10003[22] = 13;
    var10003[23] = 5;
    var10003[24] = 17;
    var10003[25] = 19;
    var10003[26] = 15;
    var10003[27] = -23;
    var10003[28] = -25;
    var10003[29] = -19;
    var10003[30] = -31;
    var10003[31] = 21;
    var10003[32] = 16;
    var10003[33] = -18;
    var10003[34] = 13;
    var10003[35] = -2;
    var10003[36] = 28;
    var10003[37] = 2;
    var10003[38] = 33;
    var10003[39] = -2;
    var10003[40] = -12;
    var10003[41] = 2;
    var10003[42] = -1;
    var10003[43] = 1;
    var10003[44] = -14;
    var10003[45] = -9;
    var10003[46] = -10;
    var10003[47] = 46;
    var10003[48] = 19;
    var10003[49] = -11;
    var10003[50] = 23;
    var10003[51] = 18;
    var10003[52] = 12;
    var10003[53] = 25;
    var10003[54] = 9;
    var10003[55] = -2;
    var10003[56] = 10;
    var10003[57] = 2;
    var10003[58] = 14;
    var10003[59] = 40;
    var10003[60] = 11;
    var10003[61] = 31;
    var10003[62] = 50;
    var10003[63] = 49;
    int[] var10004 = SimpleLongDecrypter.getCachedDecrypter(-8088291897303784593L).getEncryptionInts();
    var10004[0] = -13;
    var10004[1] = -46;
    var10004[2] = -2;
    var10004[3] = -14;
    var10004[4] = 2;
    var10004[5] = -33;
    var10004[6] = -19;
    var10004[7] = -17;
    var10004[8] = -21;
    var10004[9] = -36;
    var10004[10] = -29;
    var10004[11] = -21;
    var10004[12] = -9;
    var10004[13] = 13;
    var10004[14] = -36;
    var10004[15] = -46;
    var10004[16] = -30;
    var10004[17] = 14;
    var10004[18] = -36;
    var10004[19] = -4;
    var10004[20] = -20;
    var10004[21] = 9;
    var10004[22] = -20;
    var10004[23] = 4;
    var10004[24] = 17;
    var10004[25] = 19;
    var10004[26] = -15;
    var10004[27] = -8;
    var10004[28] = -30;
    var10004[29] = 21;
    var10004[30] = -29;
    var10004[31] = -31;
    var10004[32] = 21;
    var10004[33] = -20;
    var10004[34] = -15;
    var10004[35] = 8;
    var10004[36] = -1;
    var10004[37] = 1;
    var10004[38] = 33;
    var10004[39] = 29;
    var10004[40] = 20;
    var10004[41] = 15;
    var10004[42] = 20;
    var10004[43] = -9;
    var10004[44] = -12;
    var10004[45] = 36;
    var10004[46] = 30;
    var10004[47] = 46;
    var10004[48] = -12;
    var10004[49] = 15;
    var10004[50] = 36;
    var10004[51] = -12;
    var10004[52] = 9;
    var10004[53] = 20;
    var10004[54] = 36;
    var10004[55] = -2;
    var10004[56] = 12;
    var10004[57] = 2;
    var10004[58] = 30;
    var10004[59] = 29;
    var10004[60] = 12;
    var10004[61] = 46;
    var10004[62] = 31;
    var10004[63] = 12;
    int[] var10005 = SimpleLongDecrypter.getCachedDecrypter(2536297521161778078L).getEncryptionInts();
    var10005[0] = -47;
    var10005[1] = -29;
    var10005[2] = -20;
    var10005[3] = -12;
    var10005[4] = -58;
    var10005[5] = -11;
    var10005[6] = -32;
    var10005[7] = -48;
    var10005[8] = -31;
    var10005[9] = -51;
    var10005[10] = -14;
    var10005[11] = -25;
    var10005[12] = -51;
    var10005[13] = -18;
    var10005[14] = -4;
    var10005[15] = 12;
    var10005[16] = 11;
    var10005[17] = -32;
    var10005[18] = 4;
    var10005[19] = -31;
    var10005[20] = -31;
    var10005[21] = -12;
    var10005[22] = 20;
    var10005[23] = -14;
    var10005[24] = 14;
    var10005[25] = -17;
    var10005[26] = -35;
    var10005[27] = -14;
    var10005[28] = -20;
    var10005[29] = -27;
    var10005[30] = 29;
    var10005[31] = 18;
    var10005[32] = -2;
    var10005[33] = 12;
    var10005[34] = 2;
    var10005[35] = -9;
    var10005[36] = 25;
    var10005[37] = 14;
    var10005[38] = 32;
    var10005[39] = 31;
    var10005[40] = -14;
    var10005[41] = 14;
    var10005[42] = 17;
    var10005[43] = -9;
    var10005[44] = 9;
    var10005[45] = -1;
    var10005[46] = 1;
    var10005[47] = 47;
    var10005[48] = 20;
    var10005[49] = 32;
    var10005[50] = 31;
    var10005[51] = 31;
    var10005[52] = 9;
    var10005[53] = -5;
    var10005[54] = 14;
    var10005[55] = 48;
    var10005[56] = 27;
    var10005[57] = -2;
    var10005[58] = 5;
    var10005[59] = 2;
    var10005[60] = 51;
    var10005[61] = 35;
    var10005[62] = 58;
    var10005[63] = 51;
    int[] var10006 = SimpleLongDecrypter.getCachedDecrypter(-3937235194352561265L).getEncryptionInts();
    var10006[0] = -47;
    var10006[1] = -29;
    var10006[2] = -20;
    var10006[3] = -12;
    var10006[4] = -58;
    var10006[5] = -11;
    var10006[6] = -32;
    var10006[7] = -48;
    var10006[8] = -45;
    var10006[9] = -50;
    var10006[10] = -35;
    var10006[11] = -13;
    var10006[12] = -40;
    var10006[13] = -50;
    var10006[14] = -25;
    var10006[15] = 12;
    var10006[16] = 11;
    var10006[17] = -29;
    var10006[18] = -22;
    var10006[19] = -37;
    var10006[20] = -23;
    var10006[21] = -5;
    var10006[22] = 20;
    var10006[23] = -10;
    var10006[24] = 13;
    var10006[25] = -36;
    var10006[26] = 5;
    var10006[27] = -30;
    var10006[28] = -26;
    var10006[29] = -15;
    var10006[30] = 29;
    var10006[31] = -10;
    var10006[32] = -26;
    var10006[33] = 10;
    var10006[34] = -1;
    var10006[35] = 1;
    var10006[36] = -14;
    var10006[37] = -11;
    var10006[38] = 32;
    var10006[39] = 25;
    var10006[40] = 22;
    var10006[41] = 10;
    var10006[42] = -9;
    var10006[43] = 23;
    var10006[44] = 15;
    var10006[45] = 35;
    var10006[46] = 29;
    var10006[47] = 47;
    var10006[48] = 11;
    var10006[49] = -11;
    var10006[50] = 14;
    var10006[51] = 9;
    var10006[52] = 40;
    var10006[53] = 45;
    var10006[54] = 26;
    var10006[55] = 48;
    var10006[56] = 37;
    var10006[57] = 30;
    var10006[58] = 26;
    var10006[59] = 50;
    var10006[60] = 11;
    var10006[61] = 36;
    var10006[62] = 58;
    var10006[63] = 50;
    int[] var10007 = SimpleLongDecrypter.getCachedDecrypter(-2196368890409135898L).getEncryptionInts();
    var10007[0] = -13;
    var10007[1] = -46;
    var10007[2] = -2;
    var10007[3] = -14;
    var10007[4] = 2;
    var10007[5] = -33;
    var10007[6] = -19;
    var10007[7] = -17;
    var10007[8] = -53;
    var10007[9] = -32;
    var10007[10] = -30;
    var10007[11] = -21;
    var10007[12] = -51;
    var10007[13] = 13;
    var10007[14] = -4;
    var10007[15] = -47;
    var10007[16] = -17;
    var10007[17] = 14;
    var10007[18] = 4;
    var10007[19] = -4;
    var10007[20] = -38;
    var10007[21] = -22;
    var10007[22] = -8;
    var10007[23] = 4;
    var10007[24] = 17;
    var10007[25] = 19;
    var10007[26] = -25;
    var10007[27] = -17;
    var10007[28] = -25;
    var10007[29] = -21;
    var10007[30] = 8;
    var10007[31] = -3;
    var10007[32] = 21;
    var10007[33] = 17;
    var10007[34] = 3;
    var10007[35] = -14;
    var10007[36] = -9;
    var10007[37] = -2;
    var10007[38] = 33;
    var10007[39] = 2;
    var10007[40] = 30;
    var10007[41] = 32;
    var10007[42] = -18;
    var10007[43] = 22;
    var10007[44] = 17;
    var10007[45] = 9;
    var10007[46] = -6;
    var10007[47] = 46;
    var10007[48] = -8;
    var10007[49] = 14;
    var10007[50] = 21;
    var10007[51] = 25;
    var10007[52] = 6;
    var10007[53] = 25;
    var10007[54] = -5;
    var10007[55] = -2;
    var10007[56] = 8;
    var10007[57] = 2;
    var10007[58] = 38;
    var10007[59] = 5;
    var10007[60] = 18;
    var10007[61] = 53;
    var10007[62] = 47;
    var10007[63] = 51;
    int[] var10008 = SimpleLongDecrypter.getCachedDecrypter(6225524340471897257L).getEncryptionInts();
    var10008[0] = -13;
    var10008[1] = -46;
    var10008[2] = -2;
    var10008[3] = -14;
    var10008[4] = 2;
    var10008[5] = -33;
    var10008[6] = -19;
    var10008[7] = -17;
    var10008[8] = -32;
    var10008[9] = -11;
    var10008[10] = -19;
    var10008[11] = -19;
    var10008[12] = -49;
    var10008[13] = 13;
    var10008[14] = -42;
    var10008[15] = -45;
    var10008[16] = -16;
    var10008[17] = 14;
    var10008[18] = -33;
    var10008[19] = -3;
    var10008[20] = 11;
    var10008[21] = -13;
    var10008[22] = 3;
    var10008[23] = -12;
    var10008[24] = 17;
    var10008[25] = 19;
    var10008[26] = -11;
    var10008[27] = -12;
    var10008[28] = -25;
    var10008[29] = 19;
    var10008[30] = 19;
    var10008[31] = -18;
    var10008[32] = 16;
    var10008[33] = -21;
    var10008[34] = 13;
    var10008[35] = 12;
    var10008[36] = -16;
    var10008[37] = 11;
    var10008[38] = 33;
    var10008[39] = 12;
    var10008[40] = 32;
    var10008[41] = -18;
    var10008[42] = -20;
    var10008[43] = -15;
    var10008[44] = -4;
    var10008[45] = -1;
    var10008[46] = 1;
    var10008[47] = 46;
    var10008[48] = 4;
    var10008[49] = 18;
    var10008[50] = -13;
    var10008[51] = 33;
    var10008[52] = 16;
    var10008[53] = 25;
    var10008[54] = 21;
    var10008[55] = -2;
    var10008[56] = 42;
    var10008[57] = 2;
    var10008[58] = 15;
    var10008[59] = 18;
    var10008[60] = 45;
    var10008[61] = 49;
    var10008[62] = 20;
    var10008[63] = 13;
    int[] var10009 = SimpleLongDecrypter.getCachedDecrypter(585673308755942405L).getEncryptionInts();
    var10009[0] = -47;
    var10009[1] = -29;
    var10009[2] = -20;
    var10009[3] = -12;
    var10009[4] = -58;
    var10009[5] = -11;
    var10009[6] = -32;
    var10009[7] = -48;
    var10009[8] = -48;
    var10009[9] = -36;
    var10009[10] = -34;
    var10009[11] = -39;
    var10009[12] = -40;
    var10009[13] = -27;
    var10009[14] = -17;
    var10009[15] = 12;
    var10009[16] = 11;
    var10009[17] = -9;
    var10009[18] = -43;
    var10009[19] = -6;
    var10009[20] = -34;
    var10009[21] = -30;
    var10009[22] = 20;
    var10009[23] = -13;
    var10009[24] = -4;
    var10009[25] = 6;
    var10009[26] = 9;
    var10009[27] = -32;
    var10009[28] = 4;
    var10009[29] = -12;
    var10009[30] = 29;
    var10009[31] = 17;
    var10009[32] = -14;
    var10009[33] = -20;
    var10009[34] = -9;
    var10009[35] = -4;
    var10009[36] = 13;
    var10009[37] = -12;
    var10009[38] = 32;
    var10009[39] = 4;
    var10009[40] = 27;
    var10009[41] = 12;
    var10009[42] = -18;
    var10009[43] = 9;
    var10009[44] = 34;
    var10009[45] = 36;
    var10009[46] = 14;
    var10009[47] = 47;
    var10009[48] = -9;
    var10009[49] = 12;
    var10009[50] = 39;
    var10009[51] = 30;
    var10009[52] = 40;
    var10009[53] = 20;
    var10009[54] = 34;
    var10009[55] = 48;
    var10009[56] = 48;
    var10009[57] = 9;
    var10009[58] = -5;
    var10009[59] = 32;
    var10009[60] = 18;
    var10009[61] = 43;
    var10009[62] = 58;
    var10009[63] = 5;
    int[] var10010 = SimpleLongDecrypter.getCachedDecrypter(222902674777066608L).getEncryptionInts();
    var10010[0] = -47;
    var10010[1] = -29;
    var10010[2] = -20;
    var10010[3] = -12;
    var10010[4] = -58;
    var10010[5] = -11;
    var10010[6] = -32;
    var10010[7] = -48;
    var10010[8] = -27;
    var10010[9] = -12;
    var10010[10] = -29;
    var10010[11] = -14;
    var10010[12] = -48;
    var10010[13] = -28;
    var10010[14] = -44;
    var10010[15] = 12;
    var10010[16] = 11;
    var10010[17] = -32;
    var10010[18] = -38;
    var10010[19] = -33;
    var10010[20] = -12;
    var10010[21] = 12;
    var10010[22] = 20;
    var10010[23] = -19;
    var10010[24] = -26;
    var10010[25] = 14;
    var10010[26] = -7;
    var10010[27] = -4;
    var10010[28] = -8;
    var10010[29] = -11;
    var10010[30] = 29;
    var10010[31] = 4;
    var10010[32] = 12;
    var10010[33] = 7;
    var10010[34] = -25;
    var10010[35] = 27;
    var10010[36] = 8;
    var10010[37] = -8;
    var10010[38] = 32;
    var10010[39] = 29;
    var10010[40] = 11;
    var10010[41] = 28;
    var10010[42] = 19;
    var10010[43] = -11;
    var10010[44] = -2;
    var10010[45] = 8;
    var10010[46] = 2;
    var10010[47] = 47;
    var10010[48] = -3;
    var10010[49] = 32;
    var10010[50] = 26;
    var10010[51] = 3;
    var10010[52] = 33;
    var10010[53] = -4;
    var10010[54] = 11;
    var10010[55] = 48;
    var10010[56] = 38;
    var10010[57] = 4;
    var10010[58] = 44;
    var10010[59] = 25;
    var10010[60] = 48;
    var10010[61] = -2;
    var10010[62] = 58;
    var10010[63] = 2;
    int[] var10011 = SimpleLongDecrypter.getCachedDecrypter(-8311871109988165652L).getEncryptionInts();
    var10011[0] = -13;
    var10011[1] = -46;
    var10011[2] = -2;
    var10011[3] = -14;
    var10011[4] = 2;
    var10011[5] = -33;
    var10011[6] = -19;
    var10011[7] = -17;
    var10011[8] = -19;
    var10011[9] = -30;
    var10011[10] = -39;
    var10011[11] = -25;
    var10011[12] = -8;
    var10011[13] = 13;
    var10011[14] = -17;
    var10011[15] = -46;
    var10011[16] = -21;
    var10011[17] = 14;
    var10011[18] = -23;
    var10011[19] = -44;
    var10011[20] = 8;
    var10011[21] = -9;
    var10011[22] = -23;
    var10011[23] = -3;
    var10011[24] = 17;
    var10011[25] = 19;
    var10011[26] = 3;
    var10011[27] = 19;
    var10011[28] = -26;
    var10011[29] = -27;
    var10011[30] = 9;
    var10011[31] = 17;
    var10011[32] = -28;
    var10011[33] = -17;
    var10011[34] = -17;
    var10011[35] = -13;
    var10011[36] = 25;
    var10011[37] = 21;
    var10011[38] = 33;
    var10011[39] = 30;
    var10011[40] = -4;
    var10011[41] = 23;
    var10011[42] = -16;
    var10011[43] = -10;
    var10011[44] = 4;
    var10011[45] = 23;
    var10011[46] = -16;
    var10011[47] = 46;
    var10011[48] = 13;
    var10011[49] = 39;
    var10011[50] = 17;
    var10011[51] = 17;
    var10011[52] = -7;
    var10011[53] = 10;
    var10011[54] = 26;
    var10011[55] = -2;
    var10011[56] = 27;
    var10011[57] = 2;
    var10011[58] = 16;
    var10011[59] = 7;
    var10011[60] = 28;
    var10011[61] = 46;
    var10011[62] = 16;
    var10011[63] = 44;
    int[] var10012 = SimpleLongDecrypter.getCachedDecrypter(-2804476685438403728L).getEncryptionInts();
    var10012[0] = -47;
    var10012[1] = -29;
    var10012[2] = -20;
    var10012[3] = -12;
    var10012[4] = -58;
    var10012[5] = -11;
    var10012[6] = -32;
    var10012[7] = -48;
    var10012[8] = -55;
    var10012[9] = -36;
    var10012[10] = -16;
    var10012[11] = -47;
    var10012[12] = -25;
    var10012[13] = -19;
    var10012[14] = -6;
    var10012[15] = 12;
    var10012[16] = 11;
    var10012[17] = -43;
    var10012[18] = -10;
    var10012[19] = -6;
    var10012[20] = 6;
    var10012[21] = -40;
    var10012[22] = 20;
    var10012[23] = -17;
    var10012[24] = -9;
    var10012[25] = 6;
    var10012[26] = 16;
    var10012[27] = -24;
    var10012[28] = 10;
    var10012[29] = -20;
    var10012[30] = 29;
    var10012[31] = -28;
    var10012[32] = 19;
    var10012[33] = 9;
    var10012[34] = -16;
    var10012[35] = -8;
    var10012[36] = -3;
    var10012[37] = 25;
    var10012[38] = 32;
    var10012[39] = 3;
    var10012[40] = 17;
    var10012[41] = -12;
    var10012[42] = -10;
    var10012[43] = 8;
    var10012[44] = -12;
    var10012[45] = 36;
    var10012[46] = -11;
    var10012[47] = 47;
    var10012[48] = -6;
    var10012[49] = 20;
    var10012[50] = 16;
    var10012[51] = 24;
    var10012[52] = 10;
    var10012[53] = 12;
    var10012[54] = 6;
    var10012[55] = 48;
    var10012[56] = 12;
    var10012[57] = 11;
    var10012[58] = 47;
    var10012[59] = 28;
    var10012[60] = 43;
    var10012[61] = 40;
    var10012[62] = 58;
    var10012[63] = 55;
    int[] var10013 = SimpleLongDecrypter.getCachedDecrypter(-4339146255632361389L).getEncryptionInts();
    var10013[0] = -13;
    var10013[1] = -46;
    var10013[2] = -2;
    var10013[3] = -14;
    var10013[4] = 2;
    var10013[5] = -33;
    var10013[6] = -19;
    var10013[7] = -17;
    var10013[8] = -18;
    var10013[9] = -22;
    var10013[10] = -27;
    var10013[11] = -12;
    var10013[12] = -6;
    var10013[13] = 13;
    var10013[14] = -42;
    var10013[15] = -31;
    var10013[16] = -23;
    var10013[17] = 14;
    var10013[18] = 6;
    var10013[19] = -25;
    var10013[20] = -43;
    var10013[21] = -22;
    var10013[22] = -19;
    var10013[23] = 12;
    var10013[24] = 17;
    var10013[25] = 19;
    var10013[26] = 18;
    var10013[27] = -21;
    var10013[28] = -34;
    var10013[29] = -7;
    var10013[30] = -23;
    var10013[31] = 22;
    var10013[32] = -17;
    var10013[33] = -19;
    var10013[34] = -26;
    var10013[35] = -23;
    var10013[36] = 7;
    var10013[37] = 27;
    var10013[38] = 33;
    var10013[39] = 23;
    var10013[40] = -11;
    var10013[41] = 19;
    var10013[42] = -12;
    var10013[43] = 22;
    var10013[44] = 25;
    var10013[45] = -16;
    var10013[46] = 31;
    var10013[47] = 46;
    var10013[48] = 21;
    var10013[49] = 17;
    var10013[50] = -9;
    var10013[51] = 11;
    var10013[52] = 19;
    var10013[53] = 23;
    var10013[54] = 12;
    var10013[55] = -2;
    var10013[56] = 42;
    var10013[57] = 2;
    var10013[58] = 23;
    var10013[59] = 9;
    var10013[60] = 26;
    var10013[61] = 16;
    var10013[62] = 34;
    var10013[63] = 43;
    int[] var10014 = SimpleLongDecrypter.getCachedDecrypter(-7938614726365082053L).getEncryptionInts();
    var10014[0] = -47;
    var10014[1] = -29;
    var10014[2] = -20;
    var10014[3] = -12;
    var10014[4] = -58;
    var10014[5] = -11;
    var10014[6] = -32;
    var10014[7] = -48;
    var10014[8] = -48;
    var10014[9] = -50;
    var10014[10] = -35;
    var10014[11] = -41;
    var10014[12] = -14;
    var10014[13] = -18;
    var10014[14] = -25;
    var10014[15] = 12;
    var10014[16] = 11;
    var10014[17] = -26;
    var10014[18] = -10;
    var10014[19] = -23;
    var10014[20] = -15;
    var10014[21] = -20;
    var10014[22] = 20;
    var10014[23] = -31;
    var10014[24] = -10;
    var10014[25] = -26;
    var10014[26] = 14;
    var10014[27] = -36;
    var10014[28] = 10;
    var10014[29] = -32;
    var10014[30] = 29;
    var10014[31] = 18;
    var10014[32] = -18;
    var10014[33] = -20;
    var10014[34] = 10;
    var10014[35] = 15;
    var10014[36] = -10;
    var10014[37] = -23;
    var10014[38] = 32;
    var10014[39] = 25;
    var10014[40] = -9;
    var10014[41] = 20;
    var10014[42] = 23;
    var10014[43] = 26;
    var10014[44] = -13;
    var10014[45] = 35;
    var10014[46] = 10;
    var10014[47] = 47;
    var10014[48] = -10;
    var10014[49] = 9;
    var10014[50] = 18;
    var10014[51] = 26;
    var10014[52] = 41;
    var10014[53] = 20;
    var10014[54] = 31;
    var10014[55] = 48;
    var10014[56] = 48;
    var10014[57] = 13;
    var10014[58] = 10;
    var10014[59] = 50;
    var10014[60] = 23;
    var10014[61] = 32;
    var10014[62] = 58;
    var10014[63] = 36;
    int[] var10015 = SimpleLongDecrypter.getCachedDecrypter(-8795115415588106499L).getEncryptionInts();
    var10015[0] = -47;
    var10015[1] = -29;
    var10015[2] = -20;
    var10015[3] = -12;
    var10015[4] = -58;
    var10015[5] = -11;
    var10015[6] = -32;
    var10015[7] = -48;
    var10015[8] = -9;
    var10015[9] = -34;
    var10015[10] = -42;
    var10015[11] = -13;
    var10015[12] = -41;
    var10015[13] = -38;
    var10015[14] = -30;
    var10015[15] = 12;
    var10015[16] = 11;
    var10015[17] = 9;
    var10015[18] = -9;
    var10015[19] = -2;
    var10015[20] = -21;
    var10015[21] = 2;
    var10015[22] = 20;
    var10015[23] = -11;
    var10015[24] = 13;
    var10015[25] = -6;
    var10015[26] = -9;
    var10015[27] = 9;
    var10015[28] = -20;
    var10015[29] = -30;
    var10015[30] = 29;
    var10015[31] = 6;
    var10015[32] = -4;
    var10015[33] = -7;
    var10015[34] = 11;
    var10015[35] = 9;
    var10015[36] = 4;
    var10015[37] = -21;
    var10015[38] = 32;
    var10015[39] = -21;
    var10015[40] = 7;
    var10015[41] = 21;
    var10015[42] = -7;
    var10015[43] = 34;
    var10015[44] = 30;
    var10015[45] = -9;
    var10015[46] = -11;
    var10015[47] = 47;
    var10015[48] = 20;
    var10015[49] = 7;
    var10015[50] = -11;
    var10015[51] = 38;
    var10015[52] = 42;
    var10015[53] = 41;
    var10015[54] = 9;
    var10015[55] = 48;
    var10015[56] = -7;
    var10015[57] = 11;
    var10015[58] = 21;
    var10015[59] = 30;
    var10015[60] = 21;
    var10015[61] = 11;
    var10015[62] = 58;
    var10015[63] = 7;
    int[] var10016 = SimpleLongDecrypter.getCachedDecrypter(-5862441065954389428L).getEncryptionInts();
    var10016[0] = -47;
    var10016[1] = -29;
    var10016[2] = -20;
    var10016[3] = -12;
    var10016[4] = -58;
    var10016[5] = -11;
    var10016[6] = -32;
    var10016[7] = -48;
    var10016[8] = -25;
    var10016[9] = -16;
    var10016[10] = -38;
    var10016[11] = -38;
    var10016[12] = -31;
    var10016[13] = -38;
    var10016[14] = -49;
    var10016[15] = 12;
    var10016[16] = 11;
    var10016[17] = -17;
    var10016[18] = -24;
    var10016[19] = -12;
    var10016[20] = -12;
    var10016[21] = -6;
    var10016[22] = 20;
    var10016[23] = -5;
    var10016[24] = -36;
    var10016[25] = 16;
    var10016[26] = -24;
    var10016[27] = 6;
    var10016[28] = 5;
    var10016[29] = -27;
    var10016[30] = 29;
    var10016[31] = 12;
    var10016[32] = 12;
    var10016[33] = 25;
    var10016[34] = 17;
    var10016[35] = -19;
    var10016[36] = -21;
    var10016[37] = -24;
    var10016[38] = 32;
    var10016[39] = -2;
    var10016[40] = -13;
    var10016[41] = 2;
    var10016[42] = 24;
    var10016[43] = 31;
    var10016[44] = -1;
    var10016[45] = 1;
    var10016[46] = -6;
    var10016[47] = 47;
    var10016[48] = 38;
    var10016[49] = 38;
    var10016[50] = 24;
    var10016[51] = 38;
    var10016[52] = 6;
    var10016[53] = 13;
    var10016[54] = 19;
    var10016[55] = 48;
    var10016[56] = 27;
    var10016[57] = 21;
    var10016[58] = -1;
    var10016[59] = 1;
    var10016[60] = 36;
    var10016[61] = 24;
    var10016[62] = 58;
    var10016[63] = 49;
    int[] var10017 = SimpleLongDecrypter.getCachedDecrypter(-4079211624705094744L).getEncryptionInts();
    var10017[0] = -13;
    var10017[1] = -46;
    var10017[2] = -2;
    var10017[3] = -14;
    var10017[4] = 2;
    var10017[5] = -33;
    var10017[6] = -19;
    var10017[7] = -17;
    var10017[8] = -20;
    var10017[9] = -17;
    var10017[10] = -42;
    var10017[11] = -29;
    var10017[12] = -15;
    var10017[13] = 13;
    var10017[14] = -5;
    var10017[15] = -31;
    var10017[16] = -29;
    var10017[17] = 14;
    var10017[18] = -45;
    var10017[19] = 5;
    var10017[20] = -17;
    var10017[21] = -32;
    var10017[22] = -17;
    var10017[23] = -18;
    var10017[24] = 17;
    var10017[25] = 19;
    var10017[26] = 17;
    var10017[27] = 15;
    var10017[28] = 20;
    var10017[29] = -20;
    var10017[30] = -6;
    var10017[31] = -31;
    var10017[32] = -26;
    var10017[33] = -27;
    var10017[34] = -20;
    var10017[35] = -16;
    var10017[36] = 6;
    var10017[37] = 17;
    var10017[38] = 33;
    var10017[39] = 17;
    var10017[40] = 29;
    var10017[41] = 18;
    var10017[42] = -17;
    var10017[43] = -13;
    var10017[44] = -17;
    var10017[45] = 29;
    var10017[46] = 31;
    var10017[47] = 46;
    var10017[48] = -2;
    var10017[49] = 20;
    var10017[50] = 2;
    var10017[51] = 16;
    var10017[52] = 42;
    var10017[53] = 32;
    var10017[54] = 20;
    var10017[55] = -2;
    var10017[56] = 13;
    var10017[57] = 2;
    var10017[58] = 26;
    var10017[59] = 17;
    var10017[60] = 27;
    var10017[61] = 17;
    var10017[62] = 31;
    var10017[63] = 45;
    int[] var10018 = SimpleLongDecrypter.getCachedDecrypter(-5137695640643056922L).getEncryptionInts();
    var10018[0] = -13;
    var10018[1] = -46;
    var10018[2] = -2;
    var10018[3] = -14;
    var10018[4] = 2;
    var10018[5] = -33;
    var10018[6] = -19;
    var10018[7] = -17;
    var10018[8] = -14;
    var10018[9] = -42;
    var10018[10] = -42;
    var10018[11] = -16;
    var10018[12] = -22;
    var10018[13] = 13;
    var10018[14] = -30;
    var10018[15] = -4;
    var10018[16] = -32;
    var10018[17] = 14;
    var10018[18] = -5;
    var10018[19] = 4;
    var10018[20] = -36;
    var10018[21] = -39;
    var10018[22] = 14;
    var10018[23] = 5;
    var10018[24] = 17;
    var10018[25] = 19;
    var10018[26] = -9;
    var10018[27] = 16;
    var10018[28] = -15;
    var10018[29] = -2;
    var10018[30] = -33;
    var10018[31] = 2;
    var10018[32] = -26;
    var10018[33] = -8;
    var10018[34] = 22;
    var10018[35] = 9;
    var10018[36] = -4;
    var10018[37] = -22;
    var10018[38] = 33;
    var10018[39] = -14;
    var10018[40] = 4;
    var10018[41] = 8;
    var10018[42] = -8;
    var10018[43] = 15;
    var10018[44] = 30;
    var10018[45] = -16;
    var10018[46] = -3;
    var10018[47] = 46;
    var10018[48] = 32;
    var10018[49] = 3;
    var10018[50] = 8;
    var10018[51] = 42;
    var10018[52] = 42;
    var10018[53] = 14;
    var10018[54] = -8;
    var10018[55] = -2;
    var10018[56] = 36;
    var10018[57] = 2;
    var10018[58] = 26;
    var10018[59] = 22;
    var10018[60] = 39;
    var10018[61] = 16;
    var10018[62] = 8;
    var10018[63] = 33;
    int[] var10019 = SimpleLongDecrypter.getCachedDecrypter(9206375288206380280L).getEncryptionInts();
    var10019[0] = -47;
    var10019[1] = -29;
    var10019[2] = -20;
    var10019[3] = -12;
    var10019[4] = -58;
    var10019[5] = -11;
    var10019[6] = -32;
    var10019[7] = -48;
    var10019[8] = -17;
    var10019[9] = -52;
    var10019[10] = -17;
    var10019[11] = -28;
    var10019[12] = -42;
    var10019[13] = -28;
    var10019[14] = -4;
    var10019[15] = 12;
    var10019[16] = 11;
    var10019[17] = -12;
    var10019[18] = 4;
    var10019[19] = -25;
    var10019[20] = -20;
    var10019[21] = -28;
    var10019[22] = 20;
    var10019[23] = -27;
    var10019[24] = -36;
    var10019[25] = 17;
    var10019[26] = -8;
    var10019[27] = 17;
    var10019[28] = -24;
    var10019[29] = 12;
    var10019[30] = 29;
    var10019[31] = -14;
    var10019[32] = -10;
    var10019[33] = -3;
    var10019[34] = 8;
    var10019[35] = -18;
    var10019[36] = 3;
    var10019[37] = -21;
    var10019[38] = 32;
    var10019[39] = 28;
    var10019[40] = 20;
    var10019[41] = 28;
    var10019[42] = 10;
    var10019[43] = -14;
    var10019[44] = 25;
    var10019[45] = 14;
    var10019[46] = -13;
    var10019[47] = 47;
    var10019[48] = -15;
    var10019[49] = 28;
    var10019[50] = 27;
    var10019[51] = -5;
    var10019[52] = 24;
    var10019[53] = 18;
    var10019[54] = 42;
    var10019[55] = 48;
    var10019[56] = 5;
    var10019[57] = 14;
    var10019[58] = 21;
    var10019[59] = 13;
    var10019[60] = 36;
    var10019[61] = 52;
    var10019[62] = 58;
    var10019[63] = 15;
    int[] var10020 = SimpleLongDecrypter.getCachedDecrypter(4897631728732188407L).getEncryptionInts();
    var10020[0] = -13;
    var10020[1] = -46;
    var10020[2] = -2;
    var10020[3] = -14;
    var10020[4] = 2;
    var10020[5] = -33;
    var10020[6] = -19;
    var10020[7] = -17;
    var10020[8] = -18;
    var10020[9] = -43;
    var10020[10] = -44;
    var10020[11] = -37;
    var10020[12] = -31;
    var10020[13] = 13;
    var10020[14] = -32;
    var10020[15] = -13;
    var10020[16] = -19;
    var10020[17] = 14;
    var10020[18] = -21;
    var10020[19] = -3;
    var10020[20] = -14;
    var10020[21] = -42;
    var10020[22] = 3;
    var10020[23] = -7;
    var10020[24] = 17;
    var10020[25] = 19;
    var10020[26] = 18;
    var10020[27] = -22;
    var10020[28] = 13;
    var10020[29] = -32;
    var10020[30] = 7;
    var10020[31] = -20;
    var10020[32] = -27;
    var10020[33] = -27;
    var10020[34] = 14;
    var10020[35] = 19;
    var10020[36] = -26;
    var10020[37] = -19;
    var10020[38] = 33;
    var10020[39] = 21;
    var10020[40] = -10;
    var10020[41] = -1;
    var10020[42] = 1;
    var10020[43] = 31;
    var10020[44] = -14;
    var10020[45] = -8;
    var10020[46] = 32;
    var10020[47] = 46;
    var10020[48] = 37;
    var10020[49] = 22;
    var10020[50] = 10;
    var10020[51] = 20;
    var10020[52] = 43;
    var10020[53] = 8;
    var10020[54] = 44;
    var10020[55] = -2;
    var10020[56] = 19;
    var10020[57] = 2;
    var10020[58] = 14;
    var10020[59] = 27;
    var10020[60] = 27;
    var10020[61] = 32;
    var10020[62] = 26;
    var10020[63] = 42;
    int[] var10021 = SimpleLongDecrypter.getCachedDecrypter(4247992522478179471L).getEncryptionInts();
    var10021[0] = -13;
    var10021[1] = -46;
    var10021[2] = -2;
    var10021[3] = -14;
    var10021[4] = 2;
    var10021[5] = -33;
    var10021[6] = -19;
    var10021[7] = -17;
    var10021[8] = -32;
    var10021[9] = -52;
    var10021[10] = -8;
    var10021[11] = -31;
    var10021[12] = -18;
    var10021[13] = 13;
    var10021[14] = -23;
    var10021[15] = -18;
    var10021[16] = -18;
    var10021[17] = 14;
    var10021[18] = 8;
    var10021[19] = -20;
    var10021[20] = -31;
    var10021[21] = -1;
    var10021[22] = 1;
    var10021[23] = -4;
    var10021[24] = 17;
    var10021[25] = 19;
    var10021[26] = -27;
    var10021[27] = 4;
    var10021[28] = -28;
    var10021[29] = -15;
    var10021[30] = 18;
    var10021[31] = -5;
    var10021[32] = -17;
    var10021[33] = 18;
    var10021[34] = 18;
    var10021[35] = -8;
    var10021[36] = 5;
    var10021[37] = 23;
    var10021[38] = 33;
    var10021[39] = 20;
    var10021[40] = 32;
    var10021[41] = -21;
    var10021[42] = 31;
    var10021[43] = 8;
    var10021[44] = 15;
    var10021[45] = -5;
    var10021[46] = -8;
    var10021[47] = 46;
    var10021[48] = -10;
    var10021[49] = 17;
    var10021[50] = 5;
    var10021[51] = 31;
    var10021[52] = -8;
    var10021[53] = 27;
    var10021[54] = 8;
    var10021[55] = -2;
    var10021[56] = 28;
    var10021[57] = 2;
    var10021[58] = 10;
    var10021[59] = -4;
    var10021[60] = 8;
    var10021[61] = 52;
    var10021[62] = 21;
    var10021[63] = 4;
    int[] var10022 = SimpleLongDecrypter.getCachedDecrypter(6787008718202684364L).getEncryptionInts();
    var10022[0] = -47;
    var10022[1] = -29;
    var10022[2] = -20;
    var10022[3] = -12;
    var10022[4] = -58;
    var10022[5] = -11;
    var10022[6] = -32;
    var10022[7] = -48;
    var10022[8] = -53;
    var10022[9] = -26;
    var10022[10] = -43;
    var10022[11] = -10;
    var10022[12] = -32;
    var10022[13] = -11;
    var10022[14] = -29;
    var10022[15] = 12;
    var10022[16] = 11;
    var10022[17] = -43;
    var10022[18] = -11;
    var10022[19] = -23;
    var10022[20] = -31;
    var10022[21] = 10;
    var10022[22] = 20;
    var10022[23] = -23;
    var10022[24] = 11;
    var10022[25] = -9;
    var10022[26] = -31;
    var10022[27] = -32;
    var10022[28] = -3;
    var10022[29] = 11;
    var10022[30] = 29;
    var10022[31] = 3;
    var10022[32] = -8;
    var10022[33] = -16;
    var10022[34] = 9;
    var10022[35] = 26;
    var10022[36] = -1;
    var10022[37] = 1;
    var10022[38] = 32;
    var10022[39] = -24;
    var10022[40] = 8;
    var10022[41] = -7;
    var10022[42] = 23;
    var10022[43] = 29;
    var10022[44] = 32;
    var10022[45] = -5;
    var10022[46] = 23;
    var10022[47] = 47;
    var10022[48] = 7;
    var10022[49] = 16;
    var10022[50] = 5;
    var10022[51] = 31;
    var10022[52] = -4;
    var10022[53] = 43;
    var10022[54] = -4;
    var10022[55] = 48;
    var10022[56] = 4;
    var10022[57] = 31;
    var10022[58] = 4;
    var10022[59] = 32;
    var10022[60] = 43;
    var10022[61] = 53;
    var10022[62] = 58;
    var10022[63] = 24;
    int[] var10023 = SimpleLongDecrypter.getCachedDecrypter(2843900069307882856L).getEncryptionInts();
    var10023[0] = -47;
    var10023[1] = -29;
    var10023[2] = -20;
    var10023[3] = -12;
    var10023[4] = -58;
    var10023[5] = -11;
    var10023[6] = -32;
    var10023[7] = -48;
    var10023[8] = -11;
    var10023[9] = -12;
    var10023[10] = -40;
    var10023[11] = -14;
    var10023[12] = -41;
    var10023[13] = -50;
    var10023[14] = -43;
    var10023[15] = 12;
    var10023[16] = 11;
    var10023[17] = -9;
    var10023[18] = -38;
    var10023[19] = 11;
    var10023[20] = -20;
    var10023[21] = 12;
    var10023[22] = 20;
    var10023[23] = -18;
    var10023[24] = -4;
    var10023[25] = 14;
    var10023[26] = 9;
    var10023[27] = -27;
    var10023[28] = 4;
    var10023[29] = -8;
    var10023[30] = 29;
    var10023[31] = -17;
    var10023[32] = -1;
    var10023[33] = 1;
    var10023[34] = -26;
    var10023[35] = -11;
    var10023[36] = -13;
    var10023[37] = 8;
    var10023[38] = 32;
    var10023[39] = -3;
    var10023[40] = 20;
    var10023[41] = 18;
    var10023[42] = 3;
    var10023[43] = -9;
    var10023[44] = -17;
    var10023[45] = -13;
    var10023[46] = 11;
    var10023[47] = 47;
    var10023[48] = 17;
    var10023[49] = 13;
    var10023[50] = 40;
    var10023[51] = -8;
    var10023[52] = 9;
    var10023[53] = 41;
    var10023[54] = 27;
    var10023[55] = 48;
    var10023[56] = 38;
    var10023[57] = 43;
    var10023[58] = 13;
    var10023[59] = 8;
    var10023[60] = 26;
    var10023[61] = 17;
    var10023[62] = 58;
    var10023[63] = 50;
    int[] var10024 = SimpleLongDecrypter.getCachedDecrypter(1314517845669453177L).getEncryptionInts();
    var10024[0] = -47;
    var10024[1] = -29;
    var10024[2] = -20;
    var10024[3] = -12;
    var10024[4] = -58;
    var10024[5] = -11;
    var10024[6] = -32;
    var10024[7] = -48;
    var10024[8] = -53;
    var10024[9] = -41;
    var10024[10] = -24;
    var10024[11] = -14;
    var10024[12] = -5;
    var10024[13] = -13;
    var10024[14] = -44;
    var10024[15] = 12;
    var10024[16] = 11;
    var10024[17] = 5;
    var10024[18] = -26;
    var10024[19] = -17;
    var10024[20] = -36;
    var10024[21] = -27;
    var10024[22] = 20;
    var10024[23] = -28;
    var10024[24] = -11;
    var10024[25] = 14;
    var10024[26] = 13;
    var10024[27] = -25;
    var10024[28] = -32;
    var10024[29] = -13;
    var10024[30] = 29;
    var10024[31] = -1;
    var10024[32] = 1;
    var10024[33] = -4;
    var10024[34] = 24;
    var10024[35] = 11;
    var10024[36] = 17;
    var10024[37] = 4;
    var10024[38] = 32;
    var10024[39] = -6;
    var10024[40] = -14;
    var10024[41] = -18;
    var10024[42] = 13;
    var10024[43] = -14;
    var10024[44] = 26;
    var10024[45] = 6;
    var10024[46] = -7;
    var10024[47] = 47;
    var10024[48] = 27;
    var10024[49] = -14;
    var10024[50] = 41;
    var10024[51] = 28;
    var10024[52] = 25;
    var10024[53] = 7;
    var10024[54] = 14;
    var10024[55] = 48;
    var10024[56] = 36;
    var10024[57] = 14;
    var10024[58] = 44;
    var10024[59] = 18;
    var10024[60] = 32;
    var10024[61] = 53;
    var10024[62] = 58;
    var10024[63] = 14;
    int[] var10025 = SimpleLongDecrypter.getCachedDecrypter(2428257667479886378L).getEncryptionInts();
    var10025[0] = -13;
    var10025[1] = -46;
    var10025[2] = -2;
    var10025[3] = -14;
    var10025[4] = 2;
    var10025[5] = -33;
    var10025[6] = -19;
    var10025[7] = -17;
    var10025[8] = -43;
    var10025[9] = -27;
    var10025[10] = -24;
    var10025[11] = -15;
    var10025[12] = -28;
    var10025[13] = 13;
    var10025[14] = -9;
    var10025[15] = -27;
    var10025[16] = -11;
    var10025[17] = 14;
    var10025[18] = -41;
    var10025[19] = -16;
    var10025[20] = -17;
    var10025[21] = -22;
    var10025[22] = -23;
    var10025[23] = 9;
    var10025[24] = 17;
    var10025[25] = 19;
    var10025[26] = 15;
    var10025[27] = 11;
    var10025[28] = -18;
    var10025[29] = -29;
    var10025[30] = -9;
    var10025[31] = -30;
    var10025[32] = -22;
    var10025[33] = -8;
    var10025[34] = 24;
    var10025[35] = 16;
    var10025[36] = 27;
    var10025[37] = 17;
    var10025[38] = 33;
    var10025[39] = 9;
    var10025[40] = 28;
    var10025[41] = 8;
    var10025[42] = 27;
    var10025[43] = 22;
    var10025[44] = -18;
    var10025[45] = 23;
    var10025[46] = 18;
    var10025[47] = 46;
    var10025[48] = -4;
    var10025[49] = -11;
    var10025[50] = -6;
    var10025[51] = 43;
    var10025[52] = 4;
    var10025[53] = -10;
    var10025[54] = 22;
    var10025[55] = -2;
    var10025[56] = 6;
    var10025[57] = 2;
    var10025[58] = 29;
    var10025[59] = 41;
    var10025[60] = 11;
    var10025[61] = 30;
    var10025[62] = 18;
    var10025[63] = 10;
    int[] var10026 = SimpleLongDecrypter.getCachedDecrypter(-9122108110927643580L).getEncryptionInts();
    var10026[0] = -47;
    var10026[1] = -29;
    var10026[2] = -20;
    var10026[3] = -12;
    var10026[4] = -58;
    var10026[5] = -11;
    var10026[6] = -32;
    var10026[7] = -48;
    var10026[8] = -38;
    var10026[9] = -40;
    var10026[10] = -46;
    var10026[11] = -41;
    var10026[12] = -27;
    var10026[13] = -12;
    var10026[14] = -44;
    var10026[15] = 12;
    var10026[16] = 11;
    var10026[17] = -19;
    var10026[18] = -11;
    var10026[19] = -35;
    var10026[20] = -13;
    var10026[21] = -20;
    var10026[22] = 20;
    var10026[23] = -4;
    var10026[24] = -29;
    var10026[25] = 12;
    var10026[26] = -16;
    var10026[27] = 4;
    var10026[28] = -12;
    var10026[29] = 11;
    var10026[30] = 29;
    var10026[31] = -17;
    var10026[32] = -12;
    var10026[33] = 13;
    var10026[34] = -9;
    var10026[35] = -25;
    var10026[36] = 19;
    var10026[37] = -20;
    var10026[38] = 32;
    var10026[39] = 27;
    var10026[40] = 12;
    var10026[41] = 20;
    var10026[42] = 16;
    var10026[43] = 9;
    var10026[44] = 12;
    var10026[45] = -18;
    var10026[46] = 38;
    var10026[47] = 47;
    var10026[48] = 17;
    var10026[49] = 40;
    var10026[50] = -11;
    var10026[51] = -8;
    var10026[52] = 41;
    var10026[53] = 29;
    var10026[54] = 35;
    var10026[55] = 48;
    var10026[56] = 46;
    var10026[57] = 20;
    var10026[58] = 44;
    var10026[59] = 8;
    var10026[60] = 25;
    var10026[61] = 11;
    var10026[62] = 58;
    var10026[63] = 18;
    int[] var10027 = SimpleLongDecrypter.getCachedDecrypter(8928604223545899827L).getEncryptionInts();
    var10027[0] = -13;
    var10027[1] = -46;
    var10027[2] = -2;
    var10027[3] = -14;
    var10027[4] = 2;
    var10027[5] = -33;
    var10027[6] = -19;
    var10027[7] = -17;
    var10027[8] = -37;
    var10027[9] = -34;
    var10027[10] = -51;
    var10027[11] = -45;
    var10027[12] = -25;
    var10027[13] = 13;
    var10027[14] = -45;
    var10027[15] = -45;
    var10027[16] = -20;
    var10027[17] = 14;
    var10027[18] = -12;
    var10027[19] = -10;
    var10027[20] = -26;
    var10027[21] = -27;
    var10027[22] = -36;
    var10027[23] = -9;
    var10027[24] = 17;
    var10027[25] = 19;
    var10027[26] = -2;
    var10027[27] = -14;
    var10027[28] = 2;
    var10027[29] = 10;
    var10027[30] = 12;
    var10027[31] = -22;
    var10027[32] = 9;
    var10027[33] = -1;
    var10027[34] = 1;
    var10027[35] = -16;
    var10027[36] = 20;
    var10027[37] = 25;
    var10027[38] = 33;
    var10027[39] = -11;
    var10027[40] = -2;
    var10027[41] = 14;
    var10027[42] = 2;
    var10027[43] = 34;
    var10027[44] = -5;
    var10027[45] = 37;
    var10027[46] = 26;
    var10027[47] = 46;
    var10027[48] = 27;
    var10027[49] = 5;
    var10027[50] = 11;
    var10027[51] = 16;
    var10027[52] = -11;
    var10027[53] = 22;
    var10027[54] = -8;
    var10027[55] = -2;
    var10027[56] = 45;
    var10027[57] = 2;
    var10027[58] = 36;
    var10027[59] = 45;
    var10027[60] = 45;
    var10027[61] = 51;
    var10027[62] = 8;
    var10027[63] = 11;
    int[] var10028 = SimpleLongDecrypter.getCachedDecrypter(-273909861970175489L).getEncryptionInts();
    var10028[0] = -13;
    var10028[1] = -46;
    var10028[2] = -2;
    var10028[3] = -14;
    var10028[4] = 2;
    var10028[5] = -33;
    var10028[6] = -19;
    var10028[7] = -17;
    var10028[8] = -36;
    var10028[9] = -51;
    var10028[10] = -29;
    var10028[11] = -1;
    var10028[12] = 1;
    var10028[13] = 13;
    var10028[14] = -13;
    var10028[15] = -46;
    var10028[16] = -10;
    var10028[17] = 14;
    var10028[18] = -10;
    var10028[19] = -40;
    var10028[20] = -21;
    var10028[21] = -42;
    var10028[22] = -26;
    var10028[23] = -22;
    var10028[24] = 17;
    var10028[25] = 19;
    var10028[26] = 10;
    var10028[27] = 13;
    var10028[28] = 10;
    var10028[29] = -25;
    var10028[30] = -28;
    var10028[31] = -18;
    var10028[32] = -3;
    var10028[33] = -9;
    var10028[34] = -3;
    var10028[35] = 3;
    var10028[36] = -16;
    var10028[37] = 3;
    var10028[38] = 33;
    var10028[39] = 29;
    var10028[40] = -16;
    var10028[41] = 21;
    var10028[42] = 9;
    var10028[43] = -3;
    var10028[44] = 36;
    var10028[45] = 22;
    var10028[46] = 3;
    var10028[47] = 46;
    var10028[48] = 26;
    var10028[49] = 18;
    var10028[50] = -12;
    var10028[51] = -2;
    var10028[52] = 16;
    var10028[53] = 2;
    var10028[54] = 25;
    var10028[55] = -2;
    var10028[56] = 16;
    var10028[57] = 2;
    var10028[58] = 28;
    var10028[59] = 40;
    var10028[60] = 51;
    var10028[61] = 46;
    var10028[62] = 12;
    var10028[63] = 42;
    int[] var10029 = SimpleLongDecrypter.getCachedDecrypter(-6884207350383239299L).getEncryptionInts();
    var10029[0] = -47;
    var10029[1] = -29;
    var10029[2] = -20;
    var10029[3] = -12;
    var10029[4] = -58;
    var10029[5] = -11;
    var10029[6] = -32;
    var10029[7] = -48;
    var10029[8] = -36;
    var10029[9] = -8;
    var10029[10] = -30;
    var10029[11] = -32;
    var10029[12] = -12;
    var10029[13] = -46;
    var10029[14] = -21;
    var10029[15] = 12;
    var10029[16] = 11;
    var10029[17] = 8;
    var10029[18] = -27;
    var10029[19] = -38;
    var10029[20] = -40;
    var10029[21] = -33;
    var10029[22] = 20;
    var10029[23] = -10;
    var10029[24] = 12;
    var10029[25] = -9;
    var10029[26] = -10;
    var10029[27] = -2;
    var10029[28] = -35;
    var10029[29] = 2;
    var10029[30] = 29;
    var10029[31] = -21;
    var10029[32] = -24;
    var10029[33] = 10;
    var10029[34] = 9;
    var10029[35] = 21;
    var10029[36] = 10;
    var10029[37] = -2;
    var10029[38] = 32;
    var10029[39] = 2;
    var10029[40] = 30;
    var10029[41] = -10;
    var10029[42] = -6;
    var10029[43] = 32;
    var10029[44] = 36;
    var10029[45] = 27;
    var10029[46] = -7;
    var10029[47] = 47;
    var10029[48] = 6;
    var10029[49] = -12;
    var10029[50] = -8;
    var10029[51] = 10;
    var10029[52] = 21;
    var10029[53] = 7;
    var10029[54] = 33;
    var10029[55] = 48;
    var10029[56] = 24;
    var10029[57] = 38;
    var10029[58] = 8;
    var10029[59] = 46;
    var10029[60] = 40;
    var10029[61] = 12;
    var10029[62] = 58;
    var10029[63] = 35;
    int[] var10030 = SimpleLongDecrypter.getCachedDecrypter(-5871629535273291584L).getEncryptionInts();
    var10030[0] = -13;
    var10030[1] = -46;
    var10030[2] = -2;
    var10030[3] = -14;
    var10030[4] = 2;
    var10030[5] = -33;
    var10030[6] = -19;
    var10030[7] = -17;
    var10030[8] = -35;
    var10030[9] = -42;
    var10030[10] = -29;
    var10030[11] = -42;
    var10030[12] = -44;
    var10030[13] = 13;
    var10030[14] = -12;
    var10030[15] = -16;
    var10030[16] = -2;
    var10030[17] = 14;
    var10030[18] = 2;
    var10030[19] = -17;
    var10030[20] = -32;
    var10030[21] = -19;
    var10030[22] = -27;
    var10030[23] = -22;
    var10030[24] = 17;
    var10030[25] = 19;
    var10030[26] = 12;
    var10030[27] = -34;
    var10030[28] = -32;
    var10030[29] = -4;
    var10030[30] = -5;
    var10030[31] = 16;
    var10030[32] = -31;
    var10030[33] = 4;
    var10030[34] = -25;
    var10030[35] = 5;
    var10030[36] = 17;
    var10030[37] = -21;
    var10030[38] = 33;
    var10030[39] = 29;
    var10030[40] = 19;
    var10030[41] = -13;
    var10030[42] = -2;
    var10030[43] = 35;
    var10030[44] = 2;
    var10030[45] = 22;
    var10030[46] = -4;
    var10030[47] = 46;
    var10030[48] = -14;
    var10030[49] = 27;
    var10030[50] = 4;
    var10030[51] = 42;
    var10030[52] = 32;
    var10030[53] = 42;
    var10030[54] = 13;
    var10030[55] = -2;
    var10030[56] = 44;
    var10030[57] = 2;
    var10030[58] = 21;
    var10030[59] = 25;
    var10030[60] = 32;
    var10030[61] = 34;
    var10030[62] = 14;
    var10030[63] = 31;
    int[] var10031 = SimpleLongDecrypter.getCachedDecrypter(-424263253355394522L).getEncryptionInts();
    var10031[0] = -47;
    var10031[1] = -29;
    var10031[2] = -20;
    var10031[3] = -12;
    var10031[4] = -58;
    var10031[5] = -11;
    var10031[6] = -32;
    var10031[7] = -48;
    var10031[8] = -18;
    var10031[9] = -4;
    var10031[10] = -4;
    var10031[11] = -34;
    var10031[12] = -39;
    var10031[13] = 4;
    var10031[14] = 4;
    var10031[15] = 12;
    var10031[16] = 11;
    var10031[17] = -43;
    var10031[18] = -25;
    var10031[19] = -10;
    var10031[20] = -43;
    var10031[21] = -15;
    var10031[22] = 20;
    var10031[23] = -34;
    var10031[24] = -24;
    var10031[25] = -12;
    var10031[26] = 18;
    var10031[27] = -25;
    var10031[28] = -4;
    var10031[29] = 10;
    var10031[30] = 29;
    var10031[31] = -15;
    var10031[32] = 4;
    var10031[33] = -25;
    var10031[34] = -27;
    var10031[35] = -5;
    var10031[36] = 15;
    var10031[37] = 12;
    var10031[38] = 32;
    var10031[39] = -5;
    var10031[40] = 5;
    var10031[41] = -15;
    var10031[42] = -7;
    var10031[43] = 25;
    var10031[44] = 5;
    var10031[45] = 34;
    var10031[46] = 15;
    var10031[47] = 47;
    var10031[48] = 24;
    var10031[49] = 7;
    var10031[50] = -4;
    var10031[51] = 39;
    var10031[52] = 25;
    var10031[53] = -6;
    var10031[54] = 4;
    var10031[55] = 48;
    var10031[56] = 15;
    var10031[57] = 34;
    var10031[58] = 25;
    var10031[59] = 6;
    var10031[60] = 43;
    var10031[61] = 27;
    var10031[62] = 58;
    var10031[63] = 43;
    int[] var10032 = SimpleLongDecrypter.getCachedDecrypter(2879200281046143716L).getEncryptionInts();
    var10032[0] = -47;
    var10032[1] = -29;
    var10032[2] = -20;
    var10032[3] = -12;
    var10032[4] = -58;
    var10032[5] = -11;
    var10032[6] = -32;
    var10032[7] = -48;
    var10032[8] = -3;
    var10032[9] = -27;
    var10032[10] = -13;
    var10032[11] = 3;
    var10032[12] = -23;
    var10032[13] = -44;
    var10032[14] = -19;
    var10032[15] = 12;
    var10032[16] = 11;
    var10032[17] = -43;
    var10032[18] = -36;
    var10032[19] = -20;
    var10032[20] = -4;
    var10032[21] = -31;
    var10032[22] = 20;
    var10032[23] = 13;
    var10032[24] = 4;
    var10032[25] = -31;
    var10032[26] = -37;
    var10032[27] = -15;
    var10032[28] = -23;
    var10032[29] = -8;
    var10032[30] = 29;
    var10032[31] = -22;
    var10032[32] = -11;
    var10032[33] = 19;
    var10032[34] = -27;
    var10032[35] = 23;
    var10032[36] = 27;
    var10032[37] = 8;
    var10032[38] = 32;
    var10032[39] = 20;
    var10032[40] = -8;
    var10032[41] = -5;
    var10032[42] = 15;
    var10032[43] = 11;
    var10032[44] = -6;
    var10032[45] = -4;
    var10032[46] = 5;
    var10032[47] = 47;
    var10032[48] = 8;
    var10032[49] = 4;
    var10032[50] = 6;
    var10032[51] = 23;
    var10032[52] = 31;
    var10032[53] = 22;
    var10032[54] = 36;
    var10032[55] = 48;
    var10032[56] = 31;
    var10032[57] = 44;
    var10032[58] = -1;
    var10032[59] = 1;
    var10032[60] = 43;
    var10032[61] = 27;
    var10032[62] = 58;
    var10032[63] = 37;
    int[] var10033 = SimpleLongDecrypter.getCachedDecrypter(-3915444766270323582L).getEncryptionInts();
    var10033[0] = -13;
    var10033[1] = -46;
    var10033[2] = -2;
    var10033[3] = -14;
    var10033[4] = 2;
    var10033[5] = -33;
    var10033[6] = -19;
    var10033[7] = -17;
    var10033[8] = -55;
    var10033[9] = -49;
    var10033[10] = -2;
    var10033[11] = -16;
    var10033[12] = 2;
    var10033[13] = 13;
    var10033[14] = -5;
    var10033[15] = -46;
    var10033[16] = -20;
    var10033[17] = 14;
    var10033[18] = -13;
    var10033[19] = 5;
    var10033[20] = -19;
    var10033[21] = -33;
    var10033[22] = -40;
    var10033[23] = -37;
    var10033[24] = 17;
    var10033[25] = 19;
    var10033[26] = -11;
    var10033[27] = 16;
    var10033[28] = -18;
    var10033[29] = -27;
    var10033[30] = -4;
    var10033[31] = 13;
    var10033[32] = -10;
    var10033[33] = -7;
    var10033[34] = 4;
    var10033[35] = -18;
    var10033[36] = 20;
    var10033[37] = 11;
    var10033[38] = 33;
    var10033[39] = 19;
    var10033[40] = 7;
    var10033[41] = -2;
    var10033[42] = 10;
    var10033[43] = 2;
    var10033[44] = -8;
    var10033[45] = -3;
    var10033[46] = 18;
    var10033[47] = 46;
    var10033[48] = 3;
    var10033[49] = -2;
    var10033[50] = -9;
    var10033[51] = 2;
    var10033[52] = 8;
    var10033[53] = 18;
    var10033[54] = 33;
    var10033[55] = -2;
    var10033[56] = 27;
    var10033[57] = 2;
    var10033[58] = 49;
    var10033[59] = 9;
    var10033[60] = 37;
    var10033[61] = 46;
    var10033[62] = 40;
    var10033[63] = 55;
    int[] var10034 = SimpleLongDecrypter.getCachedDecrypter(8496079957003954936L).getEncryptionInts();
    var10034[0] = -13;
    var10034[1] = -46;
    var10034[2] = -2;
    var10034[3] = -14;
    var10034[4] = 2;
    var10034[5] = -33;
    var10034[6] = -19;
    var10034[7] = -17;
    var10034[8] = -24;
    var10034[9] = -7;
    var10034[10] = -46;
    var10034[11] = -3;
    var10034[12] = -10;
    var10034[13] = 13;
    var10034[14] = 3;
    var10034[15] = -31;
    var10034[16] = 7;
    var10034[17] = 14;
    var10034[18] = -1;
    var10034[19] = 1;
    var10034[20] = -1;
    var10034[21] = 1;
    var10034[22] = 10;
    var10034[23] = -26;
    var10034[24] = 17;
    var10034[25] = 19;
    var10034[26] = -15;
    var10034[27] = -35;
    var10034[28] = -15;
    var10034[29] = -15;
    var10034[30] = -9;
    var10034[31] = -27;
    var10034[32] = 24;
    var10034[33] = -28;
    var10034[34] = -6;
    var10034[35] = -13;
    var10034[36] = -27;
    var10034[37] = -5;
    var10034[38] = 33;
    var10034[39] = 9;
    var10034[40] = 6;
    var10034[41] = 15;
    var10034[42] = 5;
    var10034[43] = 15;
    var10034[44] = 15;
    var10034[45] = -8;
    var10034[46] = 31;
    var10034[47] = 46;
    var10034[48] = 13;
    var10034[49] = 26;
    var10034[50] = -1;
    var10034[51] = 1;
    var10034[52] = -7;
    var10034[53] = 8;
    var10034[54] = -6;
    var10034[55] = -2;
    var10034[56] = 46;
    var10034[57] = 2;
    var10034[58] = 27;
    var10034[59] = 7;
    var10034[60] = 6;
    var10034[61] = 28;
    var10034[62] = 35;
    var10034[63] = 27;
    int[] var10035 = SimpleLongDecrypter.getCachedDecrypter(-3375409109635290632L).getEncryptionInts();
    var10035[0] = -13;
    var10035[1] = -46;
    var10035[2] = -2;
    var10035[3] = -14;
    var10035[4] = 2;
    var10035[5] = -33;
    var10035[6] = -19;
    var10035[7] = -17;
    var10035[8] = -21;
    var10035[9] = -37;
    var10035[10] = -20;
    var10035[11] = -1;
    var10035[12] = 1;
    var10035[13] = 13;
    var10035[14] = -22;
    var10035[15] = -44;
    var10035[16] = -5;
    var10035[17] = 14;
    var10035[18] = -34;
    var10035[19] = -21;
    var10035[20] = -41;
    var10035[21] = 5;
    var10035[22] = -4;
    var10035[23] = -8;
    var10035[24] = 17;
    var10035[25] = 19;
    var10035[26] = 4;
    var10035[27] = -29;
    var10035[28] = -9;
    var10035[29] = 21;
    var10035[30] = 20;
    var10035[31] = 8;
    var10035[32] = -30;
    var10035[33] = -10;
    var10035[34] = -17;
    var10035[35] = -9;
    var10035[36] = 22;
    var10035[37] = 9;
    var10035[38] = 33;
    var10035[39] = -15;
    var10035[40] = 21;
    var10035[41] = -4;
    var10035[42] = -8;
    var10035[43] = 10;
    var10035[44] = 9;
    var10035[45] = 4;
    var10035[46] = 37;
    var10035[47] = 46;
    var10035[48] = -10;
    var10035[49] = -14;
    var10035[50] = 8;
    var10035[51] = 17;
    var10035[52] = 34;
    var10035[53] = -7;
    var10035[54] = 15;
    var10035[55] = -2;
    var10035[56] = 29;
    var10035[57] = 2;
    var10035[58] = 10;
    var10035[59] = 44;
    var10035[60] = 7;
    var10035[61] = 41;
    var10035[62] = 30;
    var10035[63] = 14;
    int[] var10036 = SimpleLongDecrypter.getCachedDecrypter(6912869271594957233L).getEncryptionInts();
    var10036[0] = -47;
    var10036[1] = -29;
    var10036[2] = -20;
    var10036[3] = -12;
    var10036[4] = -58;
    var10036[5] = -11;
    var10036[6] = -32;
    var10036[7] = -48;
    var10036[8] = -20;
    var10036[9] = -1;
    var10036[10] = 1;
    var10036[11] = -15;
    var10036[12] = -28;
    var10036[13] = -48;
    var10036[14] = -17;
    var10036[15] = 12;
    var10036[16] = 11;
    var10036[17] = -29;
    var10036[18] = -35;
    var10036[19] = -33;
    var10036[20] = -17;
    var10036[21] = -8;
    var10036[22] = 20;
    var10036[23] = -37;
    var10036[24] = -12;
    var10036[25] = -23;
    var10036[26] = 15;
    var10036[27] = -12;
    var10036[28] = 20;
    var10036[29] = 8;
    var10036[30] = 29;
    var10036[31] = 17;
    var10036[32] = -18;
    var10036[33] = -10;
    var10036[34] = -22;
    var10036[35] = -19;
    var10036[36] = 12;
    var10036[37] = 17;
    var10036[38] = 32;
    var10036[39] = 12;
    var10036[40] = 28;
    var10036[41] = -4;
    var10036[42] = -16;
    var10036[43] = 10;
    var10036[44] = -19;
    var10036[45] = 4;
    var10036[46] = 29;
    var10036[47] = 47;
    var10036[48] = 23;
    var10036[49] = -8;
    var10036[50] = 18;
    var10036[51] = -8;
    var10036[52] = 33;
    var10036[53] = 35;
    var10036[54] = 19;
    var10036[55] = 48;
    var10036[56] = 22;
    var10036[57] = 8;
    var10036[58] = 16;
    var10036[59] = 8;
    var10036[60] = 37;
    var10036[61] = 48;
    var10036[62] = 58;
    var10036[63] = 19;
    int[] var10037 = SimpleLongDecrypter.getCachedDecrypter(-4132085752789065574L).getEncryptionInts();
    var10037[0] = -47;
    var10037[1] = -29;
    var10037[2] = -20;
    var10037[3] = -12;
    var10037[4] = -58;
    var10037[5] = -11;
    var10037[6] = -32;
    var10037[7] = -48;
    var10037[8] = -52;
    var10037[9] = -32;
    var10037[10] = -30;
    var10037[11] = -43;
    var10037[12] = -16;
    var10037[13] = -33;
    var10037[14] = -4;
    var10037[15] = 12;
    var10037[16] = 11;
    var10037[17] = -20;
    var10037[18] = 4;
    var10037[19] = -42;
    var10037[20] = -6;
    var10037[21] = -35;
    var10037[22] = 20;
    var10037[23] = -34;
    var10037[24] = -28;
    var10037[25] = -14;
    var10037[26] = 6;
    var10037[27] = -24;
    var10037[28] = 16;
    var10037[29] = -24;
    var10037[30] = 29;
    var10037[31] = -11;
    var10037[32] = -27;
    var10037[33] = -17;
    var10037[34] = -10;
    var10037[35] = -13;
    var10037[36] = -13;
    var10037[37] = 20;
    var10037[38] = 32;
    var10037[39] = 14;
    var10037[40] = 30;
    var10037[41] = 32;
    var10037[42] = 11;
    var10037[43] = -2;
    var10037[44] = 10;
    var10037[45] = 2;
    var10037[46] = 33;
    var10037[47] = 47;
    var10037[48] = 13;
    var10037[49] = 13;
    var10037[50] = 17;
    var10037[51] = 24;
    var10037[52] = 28;
    var10037[53] = 24;
    var10037[54] = 43;
    var10037[55] = 48;
    var10037[56] = 35;
    var10037[57] = 34;
    var10037[58] = -5;
    var10037[59] = 27;
    var10037[60] = 52;
    var10037[61] = 42;
    var10037[62] = 58;
    var10037[63] = 5;
  }

  /**
   * Sets the whole chain of class initialization order (super classes and user-defined)
   */
  private void setChildrenForDecrypters() {
    SimpleLongDecrypter.getCachedDecrypter(-7406567533090573370L).setChild(SimpleLongDecrypter.getCachedDecrypter(6690527463172170990L));
    SimpleLongDecrypter.getCachedDecrypter(-3225483683454951468L).setChild(SimpleLongDecrypter.getCachedDecrypter(-647215684339716115L));
    SimpleLongDecrypter.getCachedDecrypter(-4780195495239093138L).setChild(SimpleLongDecrypter.getCachedDecrypter(-5927968530810759203L));
    SimpleLongDecrypter.getCachedDecrypter(-4219042817156204291L).setChild(SimpleLongDecrypter.getCachedDecrypter(6698590451626520550L));
    SimpleLongDecrypter.getCachedDecrypter(-5073872155081098087L).setChild(SimpleLongDecrypter.getCachedDecrypter(3124422545158480907L));
    SimpleLongDecrypter.getCachedDecrypter(1868786821847194174L).setChild(SimpleLongDecrypter.getCachedDecrypter(405125801012146277L));
    SimpleLongDecrypter.getCachedDecrypter(-8140406786986808531L).setChild(SimpleLongDecrypter.getCachedDecrypter(3935054869509805813L));
    SimpleLongDecrypter.getCachedDecrypter(-7752346683388610490L).setChild(SimpleLongDecrypter.getCachedDecrypter(3327445173721452402L));
    SimpleLongDecrypter.getCachedDecrypter(1609334501522128038L).setChild(SimpleLongDecrypter.getCachedDecrypter(3912114223114699498L));
    SimpleLongDecrypter.getCachedDecrypter(5976488600399836521L).setChild(SimpleLongDecrypter.getCachedDecrypter(-6655168601617155275L));
    SimpleLongDecrypter.getCachedDecrypter(-6829667446852531022L).setChild(SimpleLongDecrypter.getCachedDecrypter(-9069722508836043815L));
    SimpleLongDecrypter.getCachedDecrypter(7036594950795899714L).setChild(SimpleLongDecrypter.getCachedDecrypter(2458155809079339586L));
    SimpleLongDecrypter.getCachedDecrypter(-951007125278101541L).setChild(SimpleLongDecrypter.getCachedDecrypter(-7686871143378004546L));
    SimpleLongDecrypter.getCachedDecrypter(-7965229455733162124L).setChild(SimpleLongDecrypter.getCachedDecrypter(4882394367093312867L));
    SimpleLongDecrypter.getCachedDecrypter(5469301855235171239L).setChild(SimpleLongDecrypter.getCachedDecrypter(8760824032359873910L));
    SimpleLongDecrypter.getCachedDecrypter(-8806605034456379162L).setChild(SimpleLongDecrypter.getCachedDecrypter(-3278251486317708477L));
    SimpleLongDecrypter.getCachedDecrypter(4755340985250814092L).setChild(SimpleLongDecrypter.getCachedDecrypter(-7426466749740615661L));
    SimpleLongDecrypter.getCachedDecrypter(-2448247039917022966L).setChild(SimpleLongDecrypter.getCachedDecrypter(-1088424650754938335L));
    SimpleLongDecrypter.getCachedDecrypter(8479457360576846856L).setChild(SimpleLongDecrypter.getCachedDecrypter(-6665108232603114281L));
    SimpleLongDecrypter.getCachedDecrypter(8002311201772979404L).setChild(SimpleLongDecrypter.getCachedDecrypter(-3318007300320053004L));
    SimpleLongDecrypter.getCachedDecrypter(1702811239535217252L).setChild(SimpleLongDecrypter.getCachedDecrypter(-8388721863387287231L));
    SimpleLongDecrypter.getCachedDecrypter(3621913397863252810L).setChild(SimpleLongDecrypter.getCachedDecrypter(-4105608120767430111L));
    SimpleLongDecrypter.getCachedDecrypter(-6627376511503321864L).setChild(SimpleLongDecrypter.getCachedDecrypter(-183133117009285678L));
    SimpleLongDecrypter.getCachedDecrypter(8300036339901270908L).setChild(SimpleLongDecrypter.getCachedDecrypter(5499190294738442345L));
    SimpleLongDecrypter.getCachedDecrypter(3129761951490035793L).setChild(SimpleLongDecrypter.getCachedDecrypter(-3049307478478654601L));
    SimpleLongDecrypter.getCachedDecrypter(7052321403213943049L).setChild(SimpleLongDecrypter.getCachedDecrypter(1497587108923141099L));
    SimpleLongDecrypter.getCachedDecrypter(-6324962069979158987L).setChild(SimpleLongDecrypter.getCachedDecrypter(-8414577541446118605L));
    SimpleLongDecrypter.getCachedDecrypter(-6235511813007028695L).setChild(SimpleLongDecrypter.getCachedDecrypter(5012103985424030441L));
    SimpleLongDecrypter.getCachedDecrypter(4288063783747288570L).setChild(SimpleLongDecrypter.getCachedDecrypter(-4949604267225607716L));
    SimpleLongDecrypter.getCachedDecrypter(-2352525324186605202L).setChild(SimpleLongDecrypter.getCachedDecrypter(-679766455571135744L));
    SimpleLongDecrypter.getCachedDecrypter(-5201439432148450018L).setChild(SimpleLongDecrypter.getCachedDecrypter(-5769049546147267276L));
    SimpleLongDecrypter.getCachedDecrypter(-3350494989858292048L).setChild(SimpleLongDecrypter.getCachedDecrypter(-466675982005320988L));
    SimpleLongDecrypter.getCachedDecrypter(8183699010397090198L).setChild(SimpleLongDecrypter.getCachedDecrypter(-8896863883363402408L));
    SimpleLongDecrypter.getCachedDecrypter(-5810338069721974894L).setChild(SimpleLongDecrypter.getCachedDecrypter(1654472568747285076L));
    SimpleLongDecrypter.getCachedDecrypter(8375409980755861060L).setChild(SimpleLongDecrypter.getCachedDecrypter(95802982489740891L));
    SimpleLongDecrypter.getCachedDecrypter(3774597477003806553L).setChild(SimpleLongDecrypter.getCachedDecrypter(-5543279809926781460L));
    SimpleLongDecrypter.getCachedDecrypter(2040852253780947507L).setChild(SimpleLongDecrypter.getCachedDecrypter(-2173363515845384502L));
    SimpleLongDecrypter.getCachedDecrypter(-1119795088883262940L).setChild(SimpleLongDecrypter.getCachedDecrypter(-6844146785256865603L));
    SimpleLongDecrypter.getCachedDecrypter(5898493421222174628L).setChild(SimpleLongDecrypter.getCachedDecrypter(-4673541039390670741L));
    SimpleLongDecrypter.getCachedDecrypter(-6025123290008397502L).setChild(SimpleLongDecrypter.getCachedDecrypter(8100343694584106869L));
    SimpleLongDecrypter.getCachedDecrypter(-1687839107695998604L).setChild(SimpleLongDecrypter.getCachedDecrypter(4082639866086927401L));
    SimpleLongDecrypter.getCachedDecrypter(1032870127241940881L).setChild(SimpleLongDecrypter.getCachedDecrypter(7796273061562669738L));
    SimpleLongDecrypter.getCachedDecrypter(-3390357122133997902L).setChild(SimpleLongDecrypter.getCachedDecrypter(-7223275394657811255L));
    SimpleLongDecrypter.getCachedDecrypter(1614407314741431910L).setChild(SimpleLongDecrypter.getCachedDecrypter(-7137242187442203916L));
    SimpleLongDecrypter.getCachedDecrypter(7973438877709146705L).setChild(SimpleLongDecrypter.getCachedDecrypter(-6903537505694231382L));
    SimpleLongDecrypter.getCachedDecrypter(595167445307265811L).setChild(SimpleLongDecrypter.getCachedDecrypter(-2367276984044216222L));
    SimpleLongDecrypter.getCachedDecrypter(-47694158698015468L).setChild(SimpleLongDecrypter.getCachedDecrypter(-1741796521549902481L));
    SimpleLongDecrypter.getCachedDecrypter(8532356779416896727L).setChild(SimpleLongDecrypter.getCachedDecrypter(785745392130827267L));
    SimpleLongDecrypter.getCachedDecrypter(1491448455168375580L).setChild(SimpleLongDecrypter.getCachedDecrypter(4653133785010539128L));
    SimpleLongDecrypter.getCachedDecrypter(-9030279505136289218L).setChild(SimpleLongDecrypter.getCachedDecrypter(-5357982956299171934L));
    SimpleLongDecrypter.getCachedDecrypter(4817739461015647851L).setChild(SimpleLongDecrypter.getCachedDecrypter(2384354468395814775L));
    SimpleLongDecrypter.getCachedDecrypter(-4247558348085330331L).setChild(SimpleLongDecrypter.getCachedDecrypter(6861291252848010667L));
    SimpleLongDecrypter.getCachedDecrypter(1896824048039241442L).setChild(SimpleLongDecrypter.getCachedDecrypter(9200807512405033279L));
    SimpleLongDecrypter.getCachedDecrypter(-729622004254176843L).setChild(SimpleLongDecrypter.getCachedDecrypter(8467901606820181344L));
    SimpleLongDecrypter.getCachedDecrypter(-7063611226259497053L).setChild(SimpleLongDecrypter.getCachedDecrypter(-4656996830293145675L));
    SimpleLongDecrypter.getCachedDecrypter(5596044475398982892L).setChild(SimpleLongDecrypter.getCachedDecrypter(-8893655563449932323L));
    SimpleLongDecrypter.getCachedDecrypter(1431888787003577485L).setChild(SimpleLongDecrypter.getCachedDecrypter(583628639259396680L));
    SimpleLongDecrypter.getCachedDecrypter(-6504943693463551493L).setChild(SimpleLongDecrypter.getCachedDecrypter(-8755703086640742754L));
    SimpleLongDecrypter.getCachedDecrypter(-5538361362858487097L).setChild(SimpleLongDecrypter.getCachedDecrypter(8059264599566440476L));
    SimpleLongDecrypter.getCachedDecrypter(6002252668328685509L).setChild(SimpleLongDecrypter.getCachedDecrypter(3044348169698742250L));
    SimpleLongDecrypter.getCachedDecrypter(-906057204172044156L).setChild(SimpleLongDecrypter.getCachedDecrypter(-4254940491005395647L));
    SimpleLongDecrypter.getCachedDecrypter(-9164108870351536226L).setChild(SimpleLongDecrypter.getCachedDecrypter(1891056254251553428L));
    SimpleLongDecrypter.getCachedDecrypter(4272241665536966924L).setChild(SimpleLongDecrypter.getCachedDecrypter(517654833253661605L));
    SimpleLongDecrypter.getCachedDecrypter(5421888524997821838L).setChild(SimpleLongDecrypter.getCachedDecrypter(-3062263439225054768L));
    SimpleLongDecrypter.getCachedDecrypter(-6248006811259474958L).setChild(SimpleLongDecrypter.getCachedDecrypter(7679002727961869050L));
    SimpleLongDecrypter.getCachedDecrypter(-2652483830555946169L).setChild(SimpleLongDecrypter.getCachedDecrypter(-7390738114058541890L));
    SimpleLongDecrypter.getCachedDecrypter(-7541881315637647494L).setChild(SimpleLongDecrypter.getCachedDecrypter(-3835927617750404033L));
    SimpleLongDecrypter.getCachedDecrypter(5169632936870671549L).setChild(SimpleLongDecrypter.getCachedDecrypter(-5542618961895586177L));
    SimpleLongDecrypter.getCachedDecrypter(-718973606857473903L).setChild(SimpleLongDecrypter.getCachedDecrypter(-8016592590733028835L));
    SimpleLongDecrypter.getCachedDecrypter(5165945635781711237L).setChild(SimpleLongDecrypter.getCachedDecrypter(230459073645416368L));
    SimpleLongDecrypter.getCachedDecrypter(-4324312423879107034L).setChild(SimpleLongDecrypter.getCachedDecrypter(1059213733975670467L));
    SimpleLongDecrypter.getCachedDecrypter(7269527114030564247L).setChild(SimpleLongDecrypter.getCachedDecrypter(5259940795325676318L));
    SimpleLongDecrypter.getCachedDecrypter(977928604365993594L).setChild(SimpleLongDecrypter.getCachedDecrypter(8149857136885135091L));
    SimpleLongDecrypter.getCachedDecrypter(5510283258821426863L).setChild(SimpleLongDecrypter.getCachedDecrypter(8877763976067165998L));
    SimpleLongDecrypter.getCachedDecrypter(-3912289482646213758L).setChild(SimpleLongDecrypter.getCachedDecrypter(4529162338020925920L));
    SimpleLongDecrypter.getCachedDecrypter(-2637368387637745866L).setChild(SimpleLongDecrypter.getCachedDecrypter(-8576176518016889286L));
    SimpleLongDecrypter.getCachedDecrypter(-2063205344359979043L).setChild(SimpleLongDecrypter.getCachedDecrypter(2348977869912151302L));
    SimpleLongDecrypter.getCachedDecrypter(1677350400951040246L).setChild(SimpleLongDecrypter.getCachedDecrypter(-1194138458712081110L));
    SimpleLongDecrypter.getCachedDecrypter(-8118501365623699010L).setChild(SimpleLongDecrypter.getCachedDecrypter(-3049962093283552679L));
    SimpleLongDecrypter.getCachedDecrypter(-8149207172887799135L).setChild(SimpleLongDecrypter.getCachedDecrypter(-7230770479095309121L));
    SimpleLongDecrypter.getCachedDecrypter(-1566191551106726019L).setChild(SimpleLongDecrypter.getCachedDecrypter(1942968588373222322L));
    SimpleLongDecrypter.getCachedDecrypter(2919557725087814367L).setChild(SimpleLongDecrypter.getCachedDecrypter(299631390380420149L));
    SimpleLongDecrypter.getCachedDecrypter(-3412910056480643875L).setChild(SimpleLongDecrypter.getCachedDecrypter(-3279651806983225634L));
    SimpleLongDecrypter.getCachedDecrypter(2687561753960154484L).setChild(SimpleLongDecrypter.getCachedDecrypter(6705249766401078924L));
    SimpleLongDecrypter.getCachedDecrypter(5611861724851063348L).setChild(SimpleLongDecrypter.getCachedDecrypter(-3062875005972038159L));
    SimpleLongDecrypter.getCachedDecrypter(-7494065993652099202L).setChild(SimpleLongDecrypter.getCachedDecrypter(3407176390593694262L));
    SimpleLongDecrypter.getCachedDecrypter(-3878413137506292851L).setChild(SimpleLongDecrypter.getCachedDecrypter(-7951018362796311241L));
    SimpleLongDecrypter.getCachedDecrypter(7736638694094912895L).setChild(SimpleLongDecrypter.getCachedDecrypter(6263069475729799942L));
    SimpleLongDecrypter.getCachedDecrypter(3631230664219418387L).setChild(SimpleLongDecrypter.getCachedDecrypter(-4668995668308701324L));
    SimpleLongDecrypter.getCachedDecrypter(2641711534195258121L).setChild(SimpleLongDecrypter.getCachedDecrypter(2897265688386343866L));
    SimpleLongDecrypter.getCachedDecrypter(796442933525749544L).setChild(SimpleLongDecrypter.getCachedDecrypter(5991650078595189106L));
    SimpleLongDecrypter.getCachedDecrypter(-3699051865798861973L).setChild(SimpleLongDecrypter.getCachedDecrypter(-4889992248381285988L));
    SimpleLongDecrypter.getCachedDecrypter(6735823745258808605L).setChild(SimpleLongDecrypter.getCachedDecrypter(396244264284831955L));
    SimpleLongDecrypter.getCachedDecrypter(5666071493967461153L).setChild(SimpleLongDecrypter.getCachedDecrypter(2054181457026824330L));
    SimpleLongDecrypter.getCachedDecrypter(8932544518204398395L).setChild(SimpleLongDecrypter.getCachedDecrypter(-7862784471620462888L));
    SimpleLongDecrypter.getCachedDecrypter(-4337538997205403834L).setChild(SimpleLongDecrypter.getCachedDecrypter(-1010336511128816389L));
    SimpleLongDecrypter.getCachedDecrypter(-5690475923095769056L).setChild(SimpleLongDecrypter.getCachedDecrypter(-6403793309287722993L));
    SimpleLongDecrypter.getCachedDecrypter(4597878540802454293L).setChild(SimpleLongDecrypter.getCachedDecrypter(-7098144265690968242L));
    SimpleLongDecrypter.getCachedDecrypter(-5568142617591298883L).setChild(SimpleLongDecrypter.getCachedDecrypter(2323298618663095841L));
    SimpleLongDecrypter.getCachedDecrypter(6111599966184832311L).setChild(SimpleLongDecrypter.getCachedDecrypter(-4919991257025764397L));
    SimpleLongDecrypter.getCachedDecrypter(3984970941957540024L).setChild(SimpleLongDecrypter.getCachedDecrypter(6848159359736875711L));
    SimpleLongDecrypter.getCachedDecrypter(2608097878907637429L).setChild(SimpleLongDecrypter.getCachedDecrypter(-8418415392424900886L));
    SimpleLongDecrypter.getCachedDecrypter(-1734580311647841728L).setChild(SimpleLongDecrypter.getCachedDecrypter(3922961190875004234L));
    SimpleLongDecrypter.getCachedDecrypter(2665981095504285600L).setChild(SimpleLongDecrypter.getCachedDecrypter(-1835513351868903280L));
    SimpleLongDecrypter.getCachedDecrypter(2456858623314898681L).setChild(SimpleLongDecrypter.getCachedDecrypter(-8745719273343514131L));
    SimpleLongDecrypter.getCachedDecrypter(-5744419250819714160L).setChild(SimpleLongDecrypter.getCachedDecrypter(3996385072647942442L));
    SimpleLongDecrypter.getCachedDecrypter(-6515912999035718065L).setChild(SimpleLongDecrypter.getCachedDecrypter(-3528043630333746336L));
    SimpleLongDecrypter.getCachedDecrypter(-7344832367090759087L).setChild(SimpleLongDecrypter.getCachedDecrypter(-2839357734335761328L));
    SimpleLongDecrypter.getCachedDecrypter(-5095583139092677518L).setChild(SimpleLongDecrypter.getCachedDecrypter(-1784632779509305171L));
    SimpleLongDecrypter.getCachedDecrypter(6497231090219045301L).setChild(SimpleLongDecrypter.getCachedDecrypter(9177467708607290692L));
    SimpleLongDecrypter.getCachedDecrypter(3650197747646070886L).setChild(SimpleLongDecrypter.getCachedDecrypter(-5817209484480650166L));
    SimpleLongDecrypter.getCachedDecrypter(-1969062133507518384L).setChild(SimpleLongDecrypter.getCachedDecrypter(9094114197573981717L));
    SimpleLongDecrypter.getCachedDecrypter(-7302995502612605662L).setChild(SimpleLongDecrypter.getCachedDecrypter(4881720861476812976L));
    SimpleLongDecrypter.getCachedDecrypter(1030031040886616640L).setChild(SimpleLongDecrypter.getCachedDecrypter(4125543164031545988L));
    SimpleLongDecrypter.getCachedDecrypter(-7588843357976630994L).setChild(SimpleLongDecrypter.getCachedDecrypter(-7656304263459939225L));
    SimpleLongDecrypter.getCachedDecrypter(7950550355221095458L).setChild(SimpleLongDecrypter.getCachedDecrypter(-3973617837522631585L));
    SimpleLongDecrypter.getCachedDecrypter(1834792991362820626L).setChild(SimpleLongDecrypter.getCachedDecrypter(7969895522421362828L));
    SimpleLongDecrypter.getCachedDecrypter(6142872975742202426L).setChild(SimpleLongDecrypter.getCachedDecrypter(-7061544804311887742L));
    SimpleLongDecrypter.getCachedDecrypter(4752154988145741172L).setChild(SimpleLongDecrypter.getCachedDecrypter(304005760152899016L));
    SimpleLongDecrypter.getCachedDecrypter(5149748730778818204L).setChild(SimpleLongDecrypter.getCachedDecrypter(7383692049193010128L));
    SimpleLongDecrypter.getCachedDecrypter(9201123360032279167L).setChild(SimpleLongDecrypter.getCachedDecrypter(4486376216180192906L));
    SimpleLongDecrypter.getCachedDecrypter(-2530289321593110713L).setChild(SimpleLongDecrypter.getCachedDecrypter(7279311649554526725L));
    SimpleLongDecrypter.getCachedDecrypter(-4924514740123267466L).setChild(SimpleLongDecrypter.getCachedDecrypter(-5207625135232652897L));
    SimpleLongDecrypter.getCachedDecrypter(-8212566929598430841L).setChild(SimpleLongDecrypter.getCachedDecrypter(-3732436097833541333L));
    SimpleLongDecrypter.getCachedDecrypter(-2677348326002569901L).setChild(SimpleLongDecrypter.getCachedDecrypter(1707293968374623880L));
    SimpleLongDecrypter.getCachedDecrypter(-1825803865639397783L).setChild(SimpleLongDecrypter.getCachedDecrypter(5677235402297667527L));
    SimpleLongDecrypter.getCachedDecrypter(-4111299359869474792L).setChild(SimpleLongDecrypter.getCachedDecrypter(-1639766374702672096L));
    SimpleLongDecrypter.getCachedDecrypter(5488271561872233995L).setChild(SimpleLongDecrypter.getCachedDecrypter(-750739362410725002L));
    SimpleLongDecrypter.getCachedDecrypter(-1823267288165773511L).setChild(SimpleLongDecrypter.getCachedDecrypter(3394852543117698938L));
    SimpleLongDecrypter.getCachedDecrypter(-7975557000326725955L).setChild(SimpleLongDecrypter.getCachedDecrypter(7156709552714351733L));
    SimpleLongDecrypter.getCachedDecrypter(8322180047738447376L).setChild(SimpleLongDecrypter.getCachedDecrypter(-1694559336053392881L));
    SimpleLongDecrypter.getCachedDecrypter(-1748144033469229757L).setChild(SimpleLongDecrypter.getCachedDecrypter(-6353465209517880298L));
    SimpleLongDecrypter.getCachedDecrypter(-6276973871435825398L).setChild(SimpleLongDecrypter.getCachedDecrypter(6266665475325431626L));
    SimpleLongDecrypter.getCachedDecrypter(-6545950420944891426L).setChild(SimpleLongDecrypter.getCachedDecrypter(4414543775785883292L));
    SimpleLongDecrypter.getCachedDecrypter(3439675664076789838L).setChild(SimpleLongDecrypter.getCachedDecrypter(-1273057914771899094L));
    SimpleLongDecrypter.getCachedDecrypter(1299254474207525478L).setChild(SimpleLongDecrypter.getCachedDecrypter(3896380610944187697L));
    SimpleLongDecrypter.getCachedDecrypter(5671014670398332906L).setChild(SimpleLongDecrypter.getCachedDecrypter(-563283834308194186L));
    SimpleLongDecrypter.getCachedDecrypter(-8191364773633308341L).setChild(SimpleLongDecrypter.getCachedDecrypter(78017785129226598L));
    SimpleLongDecrypter.getCachedDecrypter(-904802906769115606L).setChild(SimpleLongDecrypter.getCachedDecrypter(9070253528638484241L));
    SimpleLongDecrypter.getCachedDecrypter(-2290891157545410248L).setChild(SimpleLongDecrypter.getCachedDecrypter(-1371526126111648497L));
    SimpleLongDecrypter.getCachedDecrypter(477528237200645372L).setChild(SimpleLongDecrypter.getCachedDecrypter(7003095554992435181L));
    SimpleLongDecrypter.getCachedDecrypter(-6136876023385979029L).setChild(SimpleLongDecrypter.getCachedDecrypter(56975636532899758L));
    SimpleLongDecrypter.getCachedDecrypter(-8873777166602698718L).setChild(SimpleLongDecrypter.getCachedDecrypter(-3396565528096506083L));
    SimpleLongDecrypter.getCachedDecrypter(-4330874968113301925L).setChild(SimpleLongDecrypter.getCachedDecrypter(-347489780790934724L));
    SimpleLongDecrypter.getCachedDecrypter(-1578957316264918867L).setChild(SimpleLongDecrypter.getCachedDecrypter(-8238941192357269051L));
    SimpleLongDecrypter.getCachedDecrypter(-3794701916274899022L).setChild(SimpleLongDecrypter.getCachedDecrypter(-5034046765032651509L));
    SimpleLongDecrypter.getCachedDecrypter(-1464652962325804921L).setChild(SimpleLongDecrypter.getCachedDecrypter(7351311518050968378L));
    SimpleLongDecrypter.getCachedDecrypter(-1600715588515571650L).setChild(SimpleLongDecrypter.getCachedDecrypter(-2852394204793925032L));
    SimpleLongDecrypter.getCachedDecrypter(1794599576329659112L).setChild(SimpleLongDecrypter.getCachedDecrypter(2125120140303517L));
    SimpleLongDecrypter.getCachedDecrypter(-5363739739085134303L).setChild(SimpleLongDecrypter.getCachedDecrypter(-17111555264556806L));
    SimpleLongDecrypter.getCachedDecrypter(7573833978900612490L).setChild(SimpleLongDecrypter.getCachedDecrypter(-382840298175478872L));
    SimpleLongDecrypter.getCachedDecrypter(9001845879609937950L).setChild(SimpleLongDecrypter.getCachedDecrypter(6351187523167473704L));
    SimpleLongDecrypter.getCachedDecrypter(4388671032482177795L).setChild(SimpleLongDecrypter.getCachedDecrypter(1575994542281727816L));
    SimpleLongDecrypter.getCachedDecrypter(-1398677314575951650L).setChild(SimpleLongDecrypter.getCachedDecrypter(315156659929762827L));
    SimpleLongDecrypter.getCachedDecrypter(3557180460568406162L).setChild(SimpleLongDecrypter.getCachedDecrypter(1830726870243965218L));
    SimpleLongDecrypter.getCachedDecrypter(-3865328269218928726L).setChild(SimpleLongDecrypter.getCachedDecrypter(5551913501145955410L));
    SimpleLongDecrypter.getCachedDecrypter(-3577665522722579642L).setChild(SimpleLongDecrypter.getCachedDecrypter(7348430269908380787L));
    SimpleLongDecrypter.getCachedDecrypter(2012788976059392144L).setChild(SimpleLongDecrypter.getCachedDecrypter(-7155438940575486343L));
    SimpleLongDecrypter.getCachedDecrypter(453340005909755057L).setChild(SimpleLongDecrypter.getCachedDecrypter(4847773736736754184L));
    SimpleLongDecrypter.getCachedDecrypter(-1024516945276089102L).setChild(SimpleLongDecrypter.getCachedDecrypter(9067201814703839480L));
    SimpleLongDecrypter.getCachedDecrypter(8470671176033006469L).setChild(SimpleLongDecrypter.getCachedDecrypter(-576595273903444493L));
    SimpleLongDecrypter.getCachedDecrypter(8238500440237549429L).setChild(SimpleLongDecrypter.getCachedDecrypter(-5474273870743981652L));
    SimpleLongDecrypter.getCachedDecrypter(-3147288882412037926L).setChild(SimpleLongDecrypter.getCachedDecrypter(-1337673224622371509L));
    SimpleLongDecrypter.getCachedDecrypter(4280995283035361654L).setChild(SimpleLongDecrypter.getCachedDecrypter(-247284920537753406L));
    SimpleLongDecrypter.getCachedDecrypter(-6312018717725180662L).setChild(SimpleLongDecrypter.getCachedDecrypter(8961813764635533972L));
    SimpleLongDecrypter.getCachedDecrypter(-6218022276802626090L).setChild(SimpleLongDecrypter.getCachedDecrypter(-4852609847694134033L));
    SimpleLongDecrypter.getCachedDecrypter(6781335188630186084L).setChild(SimpleLongDecrypter.getCachedDecrypter(5174901859496335784L));
    SimpleLongDecrypter.getCachedDecrypter(-4840852955524074958L).setChild(SimpleLongDecrypter.getCachedDecrypter(-2611046508763591235L));
    SimpleLongDecrypter.getCachedDecrypter(2374169585079246292L).setChild(SimpleLongDecrypter.getCachedDecrypter(3897647276884987555L));
    SimpleLongDecrypter.getCachedDecrypter(3910004837355821277L).setChild(SimpleLongDecrypter.getCachedDecrypter(5044248927267634691L));
    SimpleLongDecrypter.getCachedDecrypter(-9070580594208135947L).setChild(SimpleLongDecrypter.getCachedDecrypter(-7044035608520663909L));
    SimpleLongDecrypter.getCachedDecrypter(-7169883894964993191L).setChild(SimpleLongDecrypter.getCachedDecrypter(6050358522179408120L));
    SimpleLongDecrypter.getCachedDecrypter(125560246054470675L).setChild(SimpleLongDecrypter.getCachedDecrypter(388342199304417388L));
    SimpleLongDecrypter.getCachedDecrypter(-556374410900992914L).setChild(SimpleLongDecrypter.getCachedDecrypter(-1126491388726619124L));
    SimpleLongDecrypter.getCachedDecrypter(6538980380936312026L).setChild(SimpleLongDecrypter.getCachedDecrypter(8202959569140787923L));
    SimpleLongDecrypter.getCachedDecrypter(-2534013349558472385L).setChild(SimpleLongDecrypter.getCachedDecrypter(-3639109288790078182L));
    SimpleLongDecrypter.getCachedDecrypter(9214720585025867899L).setChild(SimpleLongDecrypter.getCachedDecrypter(-1384386533007193934L));
    SimpleLongDecrypter.getCachedDecrypter(7251023975483980666L).setChild(SimpleLongDecrypter.getCachedDecrypter(-4098689740503545652L));
    SimpleLongDecrypter.getCachedDecrypter(-5286738684968674164L).setChild(SimpleLongDecrypter.getCachedDecrypter(-6143373472131889640L));
    SimpleLongDecrypter.getCachedDecrypter(-4221018931401634156L).setChild(SimpleLongDecrypter.getCachedDecrypter(-7334680931980338662L));
    SimpleLongDecrypter.getCachedDecrypter(-8688156712530747636L).setChild(SimpleLongDecrypter.getCachedDecrypter(5047894602306045575L));
    SimpleLongDecrypter.getCachedDecrypter(5325277600552507599L).setChild(SimpleLongDecrypter.getCachedDecrypter(-4608266750970830120L));
    SimpleLongDecrypter.getCachedDecrypter(-5579783714415927071L).setChild(SimpleLongDecrypter.getCachedDecrypter(8277006456197315836L));
    SimpleLongDecrypter.getCachedDecrypter(3568187227620256005L).setChild(SimpleLongDecrypter.getCachedDecrypter(-7473566472811732635L));
    SimpleLongDecrypter.getCachedDecrypter(-4306406562485018588L).setChild(SimpleLongDecrypter.getCachedDecrypter(-2332665553893473470L));
    SimpleLongDecrypter.getCachedDecrypter(-4053592404199613242L).setChild(SimpleLongDecrypter.getCachedDecrypter(-2610703847381801652L));
    SimpleLongDecrypter.getCachedDecrypter(-6769888785339305152L).setChild(SimpleLongDecrypter.getCachedDecrypter(1083929168692230577L));
    SimpleLongDecrypter.getCachedDecrypter(-7990211308788313555L).setChild(SimpleLongDecrypter.getCachedDecrypter(-9167255116805490560L));
    SimpleLongDecrypter.getCachedDecrypter(-4300757868534345083L).setChild(SimpleLongDecrypter.getCachedDecrypter(-7146780080527038850L));
    SimpleLongDecrypter.getCachedDecrypter(7291733129839991329L).setChild(SimpleLongDecrypter.getCachedDecrypter(-4113558775441309805L));
    SimpleLongDecrypter.getCachedDecrypter(-5719305552238839632L).setChild(SimpleLongDecrypter.getCachedDecrypter(-519045890228396023L));
    SimpleLongDecrypter.getCachedDecrypter(6758429833122027677L).setChild(SimpleLongDecrypter.getCachedDecrypter(-802364429906001148L));
    SimpleLongDecrypter.getCachedDecrypter(8002571533234412003L).setChild(SimpleLongDecrypter.getCachedDecrypter(-8639765410599426471L));
    SimpleLongDecrypter.getCachedDecrypter(-5367332393176888604L).setChild(SimpleLongDecrypter.getCachedDecrypter(-1479748216226764137L));
    SimpleLongDecrypter.getCachedDecrypter(8001455099999097815L).setChild(SimpleLongDecrypter.getCachedDecrypter(7765668520983918701L));
    SimpleLongDecrypter.getCachedDecrypter(-8904335220462726432L).setChild(SimpleLongDecrypter.getCachedDecrypter(-3896937312104156512L));
    SimpleLongDecrypter.getCachedDecrypter(-8852956039465115769L).setChild(SimpleLongDecrypter.getCachedDecrypter(-7088314766680808142L));
    SimpleLongDecrypter.getCachedDecrypter(6281639177807286054L).setChild(SimpleLongDecrypter.getCachedDecrypter(-663784295300721897L));
    SimpleLongDecrypter.getCachedDecrypter(3121806575291555914L).setChild(SimpleLongDecrypter.getCachedDecrypter(6069867716165234319L));
    SimpleLongDecrypter.getCachedDecrypter(1048668343748546234L).setChild(SimpleLongDecrypter.getCachedDecrypter(-8030809329183607048L));
    SimpleLongDecrypter.getCachedDecrypter(-2981269091230507305L).setChild(SimpleLongDecrypter.getCachedDecrypter(6228409979545922894L));
    SimpleLongDecrypter.getCachedDecrypter(-1686962928661399837L).setChild(SimpleLongDecrypter.getCachedDecrypter(-2134232425497784025L));
    SimpleLongDecrypter.getCachedDecrypter(6509480827224577450L).setChild(SimpleLongDecrypter.getCachedDecrypter(2831620722752761345L));
    SimpleLongDecrypter.getCachedDecrypter(5793135223869027700L).setChild(SimpleLongDecrypter.getCachedDecrypter(2057576482467122362L));
    SimpleLongDecrypter.getCachedDecrypter(-7438425648524385795L).setChild(SimpleLongDecrypter.getCachedDecrypter(2260071489959202959L));
    SimpleLongDecrypter.getCachedDecrypter(2378109435183162721L).setChild(SimpleLongDecrypter.getCachedDecrypter(-7316391247511906025L));
    SimpleLongDecrypter.getCachedDecrypter(-6753730076561949514L).setChild(SimpleLongDecrypter.getCachedDecrypter(5113884139726931139L));
    SimpleLongDecrypter.getCachedDecrypter(-985150985099337537L).setChild(SimpleLongDecrypter.getCachedDecrypter(-8169185574138921162L));
    SimpleLongDecrypter.getCachedDecrypter(739830087681315882L).setChild(SimpleLongDecrypter.getCachedDecrypter(-6255306087394117127L));
    SimpleLongDecrypter.getCachedDecrypter(8285243343121093830L).setChild(SimpleLongDecrypter.getCachedDecrypter(-2975630088927881204L));
    SimpleLongDecrypter.getCachedDecrypter(4662014831942551613L).setChild(SimpleLongDecrypter.getCachedDecrypter(-3626420206861709251L));
    SimpleLongDecrypter.getCachedDecrypter(1254580435756204014L).setChild(SimpleLongDecrypter.getCachedDecrypter(-2129822163658091779L));
    SimpleLongDecrypter.getCachedDecrypter(5161752481063595539L).setChild(SimpleLongDecrypter.getCachedDecrypter(8157599782876896638L));
    SimpleLongDecrypter.getCachedDecrypter(-5070964574743314693L).setChild(SimpleLongDecrypter.getCachedDecrypter(7514978176128368126L));
    SimpleLongDecrypter.getCachedDecrypter(5801066008090679174L).setChild(SimpleLongDecrypter.getCachedDecrypter(5753288239644122878L));
    SimpleLongDecrypter.getCachedDecrypter(-385988190920488476L).setChild(SimpleLongDecrypter.getCachedDecrypter(-8691910380481662847L));
    SimpleLongDecrypter.getCachedDecrypter(-5022274516328385898L).setChild(SimpleLongDecrypter.getCachedDecrypter(3098042382405238737L));
    SimpleLongDecrypter.getCachedDecrypter(1394113547626280804L).setChild(SimpleLongDecrypter.getCachedDecrypter(-1191503359816148841L));
    SimpleLongDecrypter.getCachedDecrypter(-7509582740156261860L).setChild(SimpleLongDecrypter.getCachedDecrypter(-5708659359763917633L));
    SimpleLongDecrypter.getCachedDecrypter(7758286407123783200L).setChild(SimpleLongDecrypter.getCachedDecrypter(-691923491190773573L));
    SimpleLongDecrypter.getCachedDecrypter(4348815485141551005L).setChild(SimpleLongDecrypter.getCachedDecrypter(-3337348686833276413L));
    SimpleLongDecrypter.getCachedDecrypter(-5853721933328739046L).setChild(SimpleLongDecrypter.getCachedDecrypter(-9089761846276984882L));
    SimpleLongDecrypter.getCachedDecrypter(-1793203398077080497L).setChild(SimpleLongDecrypter.getCachedDecrypter(1792445048890917439L));
    SimpleLongDecrypter.getCachedDecrypter(4864091013441638702L).setChild(SimpleLongDecrypter.getCachedDecrypter(7247748798674906493L));
    SimpleLongDecrypter.getCachedDecrypter(8620063005534111093L).setChild(SimpleLongDecrypter.getCachedDecrypter(-8768484951054814900L));
    SimpleLongDecrypter.getCachedDecrypter(-8864881021578580144L).setChild(SimpleLongDecrypter.getCachedDecrypter(-3607645361111242148L));
    SimpleLongDecrypter.getCachedDecrypter(1841668710915126084L).setChild(SimpleLongDecrypter.getCachedDecrypter(1718480891508050853L));
    SimpleLongDecrypter.getCachedDecrypter(-8486666093025080326L).setChild(SimpleLongDecrypter.getCachedDecrypter(5869893071103075315L));
    SimpleLongDecrypter.getCachedDecrypter(-8235158332426996750L).setChild(SimpleLongDecrypter.getCachedDecrypter(-6499086466763447152L));
    SimpleLongDecrypter.getCachedDecrypter(7762274225730633680L).setChild(SimpleLongDecrypter.getCachedDecrypter(-3901544382224187354L));
    SimpleLongDecrypter.getCachedDecrypter(5803209734683255223L).setChild(SimpleLongDecrypter.getCachedDecrypter(3247300559951319304L));
    SimpleLongDecrypter.getCachedDecrypter(4957376919994183856L).setChild(SimpleLongDecrypter.getCachedDecrypter(-9054861527368143628L));
    SimpleLongDecrypter.getCachedDecrypter(3813474945321745348L).setChild(SimpleLongDecrypter.getCachedDecrypter(6661938666036759450L));
    SimpleLongDecrypter.getCachedDecrypter(-8591782539587023535L).setChild(SimpleLongDecrypter.getCachedDecrypter(7512498010790101581L));
    SimpleLongDecrypter.getCachedDecrypter(7366945128636210190L).setChild(SimpleLongDecrypter.getCachedDecrypter(192260606330289136L));
    SimpleLongDecrypter.getCachedDecrypter(4752286678678976970L).setChild(SimpleLongDecrypter.getCachedDecrypter(-741293041901876623L));
    SimpleLongDecrypter.getCachedDecrypter(-1421497412511011296L).setChild(SimpleLongDecrypter.getCachedDecrypter(-5264523563089638833L));
    SimpleLongDecrypter.getCachedDecrypter(7831030153118957260L).setChild(SimpleLongDecrypter.getCachedDecrypter(5238090330292703738L));
    SimpleLongDecrypter.getCachedDecrypter(3302619350799947521L).setChild(SimpleLongDecrypter.getCachedDecrypter(-3038206237519933898L));
    SimpleLongDecrypter.getCachedDecrypter(2313154416771833287L).setChild(SimpleLongDecrypter.getCachedDecrypter(-133357418197941074L));
    SimpleLongDecrypter.getCachedDecrypter(-4507317011181847691L).setChild(SimpleLongDecrypter.getCachedDecrypter(-4225134143195488527L));
    SimpleLongDecrypter.getCachedDecrypter(106940172465169992L).setChild(SimpleLongDecrypter.getCachedDecrypter(921960596382065368L));
    SimpleLongDecrypter.getCachedDecrypter(-1753946565057553760L).setChild(SimpleLongDecrypter.getCachedDecrypter(4971998370259886835L));
    SimpleLongDecrypter.getCachedDecrypter(-3915286094620403635L).setChild(SimpleLongDecrypter.getCachedDecrypter(-1962798096606098927L));
    SimpleLongDecrypter.getCachedDecrypter(-1720349024220717708L).setChild(SimpleLongDecrypter.getCachedDecrypter(-6156247084443927877L));
    SimpleLongDecrypter.getCachedDecrypter(-6940309497896985891L).setChild(SimpleLongDecrypter.getCachedDecrypter(-5777376615241355470L));
    SimpleLongDecrypter.getCachedDecrypter(5789697870402077488L).setChild(SimpleLongDecrypter.getCachedDecrypter(-5323954165463765832L));
    SimpleLongDecrypter.getCachedDecrypter(-730598488065116191L).setChild(SimpleLongDecrypter.getCachedDecrypter(-1573672285993730856L));
    SimpleLongDecrypter.getCachedDecrypter(599761337706416233L).setChild(SimpleLongDecrypter.getCachedDecrypter(5125140796870326550L));
    SimpleLongDecrypter.getCachedDecrypter(-4567209784175286248L).setChild(SimpleLongDecrypter.getCachedDecrypter(-2143834830446140265L));
    SimpleLongDecrypter.getCachedDecrypter(5852484081181194549L).setChild(SimpleLongDecrypter.getCachedDecrypter(5781612223323153876L));
    SimpleLongDecrypter.getCachedDecrypter(-1743064237855845791L).setChild(SimpleLongDecrypter.getCachedDecrypter(-1838863480214634027L));
    SimpleLongDecrypter.getCachedDecrypter(2011760256976836412L).setChild(SimpleLongDecrypter.getCachedDecrypter(-4326591849358221720L));
    SimpleLongDecrypter.getCachedDecrypter(737185461631869359L).setChild(SimpleLongDecrypter.getCachedDecrypter(-1960233103849386726L));
    SimpleLongDecrypter.getCachedDecrypter(-1258415164289941537L).setChild(SimpleLongDecrypter.getCachedDecrypter(1880347565556215697L));
    SimpleLongDecrypter.getCachedDecrypter(-3247841349065019479L).setChild(SimpleLongDecrypter.getCachedDecrypter(9141538195471015459L));
    SimpleLongDecrypter.getCachedDecrypter(-3819000744286541798L).setChild(SimpleLongDecrypter.getCachedDecrypter(-8393433972161365991L));
    SimpleLongDecrypter.getCachedDecrypter(-6636933341295295428L).setChild(SimpleLongDecrypter.getCachedDecrypter(5304934065523870020L));
    SimpleLongDecrypter.getCachedDecrypter(4391058615791447676L).setChild(SimpleLongDecrypter.getCachedDecrypter(-454668913916047360L));
    SimpleLongDecrypter.getCachedDecrypter(-8365234931143631079L).setChild(SimpleLongDecrypter.getCachedDecrypter(54649322273033899L));
    SimpleLongDecrypter.getCachedDecrypter(299737109191481790L).setChild(SimpleLongDecrypter.getCachedDecrypter(1012266654253562716L));
    SimpleLongDecrypter.getCachedDecrypter(-8540495873349851926L).setChild(SimpleLongDecrypter.getCachedDecrypter(-7270186475112963100L));
    SimpleLongDecrypter.getCachedDecrypter(-6358446437909398342L).setChild(SimpleLongDecrypter.getCachedDecrypter(6398807757987610455L));
    SimpleLongDecrypter.getCachedDecrypter(1176424673961674164L).setChild(SimpleLongDecrypter.getCachedDecrypter(-2249054411098237105L));
    SimpleLongDecrypter.getCachedDecrypter(3055129412472210913L).setChild(SimpleLongDecrypter.getCachedDecrypter(5636399400541219926L));
    SimpleLongDecrypter.getCachedDecrypter(3826668298532653327L).setChild(SimpleLongDecrypter.getCachedDecrypter(8027212461971715116L));
    SimpleLongDecrypter.getCachedDecrypter(5989179694902056992L).setChild(SimpleLongDecrypter.getCachedDecrypter(-6541934578550153139L));
    SimpleLongDecrypter.getCachedDecrypter(5447319263764459025L).setChild(SimpleLongDecrypter.getCachedDecrypter(6580322177819454892L));
    SimpleLongDecrypter.getCachedDecrypter(-3375166560050769911L).setChild(SimpleLongDecrypter.getCachedDecrypter(-209325547041039153L));
    SimpleLongDecrypter.getCachedDecrypter(-7910820103014184475L).setChild(SimpleLongDecrypter.getCachedDecrypter(8741958599263790547L));
    SimpleLongDecrypter.getCachedDecrypter(-8893466686089079081L).setChild(SimpleLongDecrypter.getCachedDecrypter(1653604798056659246L));
    SimpleLongDecrypter.getCachedDecrypter(7898357610014744297L).setChild(SimpleLongDecrypter.getCachedDecrypter(-5373767521399885156L));
    SimpleLongDecrypter.getCachedDecrypter(-6674132190137383232L).setChild(SimpleLongDecrypter.getCachedDecrypter(2136129575294036698L));
    SimpleLongDecrypter.getCachedDecrypter(7379683805086078268L).setChild(SimpleLongDecrypter.getCachedDecrypter(-110031787927880179L));
    SimpleLongDecrypter.getCachedDecrypter(4701703473233638964L).setChild(SimpleLongDecrypter.getCachedDecrypter(6165232186470540746L));
    SimpleLongDecrypter.getCachedDecrypter(-1786600658421953595L).setChild(SimpleLongDecrypter.getCachedDecrypter(2188553869869053545L));
    SimpleLongDecrypter.getCachedDecrypter(3127010575028624873L).setChild(SimpleLongDecrypter.getCachedDecrypter(-1101924063554204982L));
    SimpleLongDecrypter.getCachedDecrypter(-2848737943440493560L).setChild(SimpleLongDecrypter.getCachedDecrypter(1309386827467173832L));
    SimpleLongDecrypter.getCachedDecrypter(9100161136582805363L).setChild(SimpleLongDecrypter.getCachedDecrypter(1963149998028300005L));
    SimpleLongDecrypter.getCachedDecrypter(5288430926231334888L).setChild(SimpleLongDecrypter.getCachedDecrypter(-6860632289739257772L));
    SimpleLongDecrypter.getCachedDecrypter(7750684382019510539L).setChild(SimpleLongDecrypter.getCachedDecrypter(8642536526337786098L));
    SimpleLongDecrypter.getCachedDecrypter(5341750292204843798L).setChild(SimpleLongDecrypter.getCachedDecrypter(-3769423372677091503L));
    SimpleLongDecrypter.getCachedDecrypter(-3994972470383442757L).setChild(SimpleLongDecrypter.getCachedDecrypter(1811869703711486598L));
    SimpleLongDecrypter.getCachedDecrypter(9046838047564294015L).setChild(SimpleLongDecrypter.getCachedDecrypter(7958325569643371266L));
    SimpleLongDecrypter.getCachedDecrypter(-5536502239627713417L).setChild(SimpleLongDecrypter.getCachedDecrypter(4150353428249749269L));
    SimpleLongDecrypter.getCachedDecrypter(-4522376473243092615L).setChild(SimpleLongDecrypter.getCachedDecrypter(-3318616344023327034L));
    SimpleLongDecrypter.getCachedDecrypter(3644983919227663455L).setChild(SimpleLongDecrypter.getCachedDecrypter(-1322575272353315224L));
    SimpleLongDecrypter.getCachedDecrypter(-4697087931088650654L).setChild(SimpleLongDecrypter.getCachedDecrypter(314807364146819058L));
    SimpleLongDecrypter.getCachedDecrypter(6123560612512304889L).setChild(SimpleLongDecrypter.getCachedDecrypter(2106922802331071378L));
    SimpleLongDecrypter.getCachedDecrypter(4713877015987858822L).setChild(SimpleLongDecrypter.getCachedDecrypter(6861500578241604746L));
    SimpleLongDecrypter.getCachedDecrypter(5314449459505470482L).setChild(SimpleLongDecrypter.getCachedDecrypter(7173892718033286729L));
    SimpleLongDecrypter.getCachedDecrypter(8164326471715091665L).setChild(SimpleLongDecrypter.getCachedDecrypter(-6922389077596899131L));
    SimpleLongDecrypter.getCachedDecrypter(-3830222476217210869L).setChild(SimpleLongDecrypter.getCachedDecrypter(-7589494504505648952L));
    SimpleLongDecrypter.getCachedDecrypter(-4245801363241673642L).setChild(SimpleLongDecrypter.getCachedDecrypter(-8483119506700677833L));
    SimpleLongDecrypter.getCachedDecrypter(5295738117637993126L).setChild(SimpleLongDecrypter.getCachedDecrypter(2297996074954904691L));
    SimpleLongDecrypter.getCachedDecrypter(3475646895068952659L).setChild(SimpleLongDecrypter.getCachedDecrypter(2228962458158957020L));
    SimpleLongDecrypter.getCachedDecrypter(-3103500704996224819L).setChild(SimpleLongDecrypter.getCachedDecrypter(-6125575484518874223L));
    SimpleLongDecrypter.getCachedDecrypter(-6105154654873450683L).setChild(SimpleLongDecrypter.getCachedDecrypter(1618385734546112428L));
    SimpleLongDecrypter.getCachedDecrypter(1171186671516979801L).setChild(SimpleLongDecrypter.getCachedDecrypter(-6110493652561036209L));
    SimpleLongDecrypter.getCachedDecrypter(-369080881299519325L).setChild(SimpleLongDecrypter.getCachedDecrypter(-6152945257874988130L));
    SimpleLongDecrypter.getCachedDecrypter(3959005484417820544L).setChild(SimpleLongDecrypter.getCachedDecrypter(-6168203557017482504L));
    SimpleLongDecrypter.getCachedDecrypter(-2641962831071855909L).setChild(SimpleLongDecrypter.getCachedDecrypter(4006816442429754536L));
    SimpleLongDecrypter.getCachedDecrypter(2720435741607367826L).setChild(SimpleLongDecrypter.getCachedDecrypter(-7273059526537992321L));
    SimpleLongDecrypter.getCachedDecrypter(-5069254726425569224L).setChild(SimpleLongDecrypter.getCachedDecrypter(-8167584657491065694L));
    SimpleLongDecrypter.getCachedDecrypter(6090224066184331527L).setChild(SimpleLongDecrypter.getCachedDecrypter(757932610651497026L));
    SimpleLongDecrypter.getCachedDecrypter(4441283175448357436L).setChild(SimpleLongDecrypter.getCachedDecrypter(4985330804605888231L));
    SimpleLongDecrypter.getCachedDecrypter(1712073927429297950L).setChild(SimpleLongDecrypter.getCachedDecrypter(-2562586743183285132L));
    SimpleLongDecrypter.getCachedDecrypter(6112661284985731200L).setChild(SimpleLongDecrypter.getCachedDecrypter(-8199217453944400800L));
    SimpleLongDecrypter.getCachedDecrypter(8050410192621531038L).setChild(SimpleLongDecrypter.getCachedDecrypter(-2720632243032061566L));
    SimpleLongDecrypter.getCachedDecrypter(8036039288039660018L).setChild(SimpleLongDecrypter.getCachedDecrypter(5402942478391691222L));
    SimpleLongDecrypter.getCachedDecrypter(-2121412387717371798L).setChild(SimpleLongDecrypter.getCachedDecrypter(-4780869504178420789L));
    SimpleLongDecrypter.getCachedDecrypter(-6941152087436186563L).setChild(SimpleLongDecrypter.getCachedDecrypter(7741741657549742004L));
    SimpleLongDecrypter.getCachedDecrypter(1477028262718597451L).setChild(SimpleLongDecrypter.getCachedDecrypter(-1307357064767070501L));
    SimpleLongDecrypter.getCachedDecrypter(4709438403876312292L).setChild(SimpleLongDecrypter.getCachedDecrypter(-5106837729026586952L));
    SimpleLongDecrypter.getCachedDecrypter(-7747735658073860543L).setChild(SimpleLongDecrypter.getCachedDecrypter(2483912699259082176L));
    SimpleLongDecrypter.getCachedDecrypter(4952781817876877443L).setChild(SimpleLongDecrypter.getCachedDecrypter(62887964199925139L));
    SimpleLongDecrypter.getCachedDecrypter(4438640498665767783L).setChild(SimpleLongDecrypter.getCachedDecrypter(901687390829571604L));
    SimpleLongDecrypter.getCachedDecrypter(-5374646287346811161L).setChild(SimpleLongDecrypter.getCachedDecrypter(6602920604900167710L));
    SimpleLongDecrypter.getCachedDecrypter(9075998735398514689L).setChild(SimpleLongDecrypter.getCachedDecrypter(6538000790714212885L));
    SimpleLongDecrypter.getCachedDecrypter(7509116320252081075L).setChild(SimpleLongDecrypter.getCachedDecrypter(-6682718753038105456L));
    SimpleLongDecrypter.getCachedDecrypter(6656023141945886246L).setChild(SimpleLongDecrypter.getCachedDecrypter(-2100241850520793921L));
    SimpleLongDecrypter.getCachedDecrypter(1517699797948623156L).setChild(SimpleLongDecrypter.getCachedDecrypter(4482999672913191229L));
    SimpleLongDecrypter.getCachedDecrypter(1278046788679510487L).setChild(SimpleLongDecrypter.getCachedDecrypter(7096819394387074442L));
    SimpleLongDecrypter.getCachedDecrypter(5524733671209002915L).setChild(SimpleLongDecrypter.getCachedDecrypter(-8141447343328038538L));
    SimpleLongDecrypter.getCachedDecrypter(2159987474598286405L).setChild(SimpleLongDecrypter.getCachedDecrypter(-8154777426371446485L));
    SimpleLongDecrypter.getCachedDecrypter(2176022071923271088L).setChild(SimpleLongDecrypter.getCachedDecrypter(1637758647099415432L));
    SimpleLongDecrypter.getCachedDecrypter(-7518577572442813121L).setChild(SimpleLongDecrypter.getCachedDecrypter(8172800787517482960L));
    SimpleLongDecrypter.getCachedDecrypter(-3194712642417066595L).setChild(SimpleLongDecrypter.getCachedDecrypter(5173110775804000429L));
    SimpleLongDecrypter.getCachedDecrypter(5465887539197673083L).setChild(SimpleLongDecrypter.getCachedDecrypter(2517184991032953813L));
    SimpleLongDecrypter.getCachedDecrypter(3899281817388308654L).setChild(SimpleLongDecrypter.getCachedDecrypter(-3505937820980123565L));
    SimpleLongDecrypter.getCachedDecrypter(-5848859049951965214L).setChild(SimpleLongDecrypter.getCachedDecrypter(8131025473339845910L));
    SimpleLongDecrypter.getCachedDecrypter(853188076446543453L).setChild(SimpleLongDecrypter.getCachedDecrypter(-1924927370713460897L));
    SimpleLongDecrypter.getCachedDecrypter(-8423738957950678507L).setChild(SimpleLongDecrypter.getCachedDecrypter(1433914670345795364L));
    SimpleLongDecrypter.getCachedDecrypter(-1999215961545506773L).setChild(SimpleLongDecrypter.getCachedDecrypter(-6419724404087907184L));
    SimpleLongDecrypter.getCachedDecrypter(6623542212479081754L).setChild(SimpleLongDecrypter.getCachedDecrypter(6546959251839236492L));
    SimpleLongDecrypter.getCachedDecrypter(6918385992433126648L).setChild(SimpleLongDecrypter.getCachedDecrypter(-5625294766359050135L));
    SimpleLongDecrypter.getCachedDecrypter(-2865579633054645289L).setChild(SimpleLongDecrypter.getCachedDecrypter(4148471983056493914L));
    SimpleLongDecrypter.getCachedDecrypter(-4242700463525595902L).setChild(SimpleLongDecrypter.getCachedDecrypter(8273115145370632948L));
    SimpleLongDecrypter.getCachedDecrypter(-5439365475282598050L).setChild(SimpleLongDecrypter.getCachedDecrypter(5723434970466782861L));
    SimpleLongDecrypter.getCachedDecrypter(-1318647277415011926L).setChild(SimpleLongDecrypter.getCachedDecrypter(7424511920356404608L));
    SimpleLongDecrypter.getCachedDecrypter(8040085065425327493L).setChild(SimpleLongDecrypter.getCachedDecrypter(1490440282118290734L));
    SimpleLongDecrypter.getCachedDecrypter(-1674891953604253922L).setChild(SimpleLongDecrypter.getCachedDecrypter(4282469322667900595L));
    SimpleLongDecrypter.getCachedDecrypter(6627896572603135929L).setChild(SimpleLongDecrypter.getCachedDecrypter(-8477232565405898759L));
    SimpleLongDecrypter.getCachedDecrypter(4509592576144655795L).setChild(SimpleLongDecrypter.getCachedDecrypter(1251434908854413750L));
    SimpleLongDecrypter.getCachedDecrypter(566667289272986626L).setChild(SimpleLongDecrypter.getCachedDecrypter(657012491303530292L));
    SimpleLongDecrypter.getCachedDecrypter(4504784956692419838L).setChild(SimpleLongDecrypter.getCachedDecrypter(-5506275862650739530L));
    SimpleLongDecrypter.getCachedDecrypter(8259430964804231861L).setChild(SimpleLongDecrypter.getCachedDecrypter(9071061837668139771L));
    SimpleLongDecrypter.getCachedDecrypter(-2253612022726207421L).setChild(SimpleLongDecrypter.getCachedDecrypter(-378583104915791737L));
    SimpleLongDecrypter.getCachedDecrypter(6410186053963673549L).setChild(SimpleLongDecrypter.getCachedDecrypter(2545085644601778134L));
    SimpleLongDecrypter.getCachedDecrypter(-3050877384699091304L).setChild(SimpleLongDecrypter.getCachedDecrypter(-6210697667982859347L));
    SimpleLongDecrypter.getCachedDecrypter(-1407748949680895421L).setChild(SimpleLongDecrypter.getCachedDecrypter(-2473903493979893477L));
    SimpleLongDecrypter.getCachedDecrypter(4236588051694513591L).setChild(SimpleLongDecrypter.getCachedDecrypter(-3934059828501338778L));
    SimpleLongDecrypter.getCachedDecrypter(-8906965794862352509L).setChild(SimpleLongDecrypter.getCachedDecrypter(-2748493371333511890L));
    SimpleLongDecrypter.getCachedDecrypter(8448765178915162617L).setChild(SimpleLongDecrypter.getCachedDecrypter(5068901346320826008L));
    SimpleLongDecrypter.getCachedDecrypter(3057353056007199664L).setChild(SimpleLongDecrypter.getCachedDecrypter(-459259763091732642L));
    SimpleLongDecrypter.getCachedDecrypter(-4090125480882706864L).setChild(SimpleLongDecrypter.getCachedDecrypter(-1845259621173860050L));
    SimpleLongDecrypter.getCachedDecrypter(1392663850211087745L).setChild(SimpleLongDecrypter.getCachedDecrypter(4896295211361002972L));
    SimpleLongDecrypter.getCachedDecrypter(361689625360603220L).setChild(SimpleLongDecrypter.getCachedDecrypter(204842635809641210L));
    SimpleLongDecrypter.getCachedDecrypter(8337816915690804359L).setChild(SimpleLongDecrypter.getCachedDecrypter(-4108156691947284755L));
    SimpleLongDecrypter.getCachedDecrypter(-130517498433288300L).setChild(SimpleLongDecrypter.getCachedDecrypter(8734452080609553746L));
    SimpleLongDecrypter.getCachedDecrypter(-5765425828538491135L).setChild(SimpleLongDecrypter.getCachedDecrypter(-1261574249981984840L));
    SimpleLongDecrypter.getCachedDecrypter(5939308303333732094L).setChild(SimpleLongDecrypter.getCachedDecrypter(-9101067556274718087L));
    SimpleLongDecrypter.getCachedDecrypter(-7562851225787896866L).setChild(SimpleLongDecrypter.getCachedDecrypter(3530124144772958146L));
    SimpleLongDecrypter.getCachedDecrypter(-1902860572831520869L).setChild(SimpleLongDecrypter.getCachedDecrypter(-4263764844469825532L));
    SimpleLongDecrypter.getCachedDecrypter(2444118617923845926L).setChild(SimpleLongDecrypter.getCachedDecrypter(-430984328636349782L));
    SimpleLongDecrypter.getCachedDecrypter(-4665851761462832761L).setChild(SimpleLongDecrypter.getCachedDecrypter(1498861828534737665L));
    SimpleLongDecrypter.getCachedDecrypter(-786139948718906761L).setChild(SimpleLongDecrypter.getCachedDecrypter(781759367631119988L));
    SimpleLongDecrypter.getCachedDecrypter(-8471685103271757479L).setChild(SimpleLongDecrypter.getCachedDecrypter(3517190925728161385L));
    SimpleLongDecrypter.getCachedDecrypter(-1305159011629204733L).setChild(SimpleLongDecrypter.getCachedDecrypter(4314504125399239467L));
    SimpleLongDecrypter.getCachedDecrypter(-5059263106480020230L).setChild(SimpleLongDecrypter.getCachedDecrypter(115628670855171164L));
    SimpleLongDecrypter.getCachedDecrypter(-6529882568881267292L).setChild(SimpleLongDecrypter.getCachedDecrypter(-2781405637859943210L));
    SimpleLongDecrypter.getCachedDecrypter(4986387001628926195L).setChild(SimpleLongDecrypter.getCachedDecrypter(-8781150472552471188L));
    SimpleLongDecrypter.getCachedDecrypter(7818183889803409752L).setChild(SimpleLongDecrypter.getCachedDecrypter(1731245939687024597L));
    SimpleLongDecrypter.getCachedDecrypter(9073080208619462339L).setChild(SimpleLongDecrypter.getCachedDecrypter(-5892003626993702213L));
    SimpleLongDecrypter.getCachedDecrypter(3744328038665870132L).setChild(SimpleLongDecrypter.getCachedDecrypter(534995755347789862L));
    SimpleLongDecrypter.getCachedDecrypter(-822911958298858319L).setChild(SimpleLongDecrypter.getCachedDecrypter(-4762417736863143366L));
    SimpleLongDecrypter.getCachedDecrypter(-1587306100756810047L).setChild(SimpleLongDecrypter.getCachedDecrypter(-5763327547164684101L));
    SimpleLongDecrypter.getCachedDecrypter(-3620675944284060761L).setChild(SimpleLongDecrypter.getCachedDecrypter(-510112038253950827L));
    SimpleLongDecrypter.getCachedDecrypter(-2095604666882560921L).setChild(SimpleLongDecrypter.getCachedDecrypter(7421687319443371742L));
    SimpleLongDecrypter.getCachedDecrypter(944244278445438484L).setChild(SimpleLongDecrypter.getCachedDecrypter(2693259185777051717L));
    SimpleLongDecrypter.getCachedDecrypter(6349739631692162792L).setChild(SimpleLongDecrypter.getCachedDecrypter(5251643600259939000L));
    SimpleLongDecrypter.getCachedDecrypter(-7964986868026421452L).setChild(SimpleLongDecrypter.getCachedDecrypter(-6503842824570032961L));
    SimpleLongDecrypter.getCachedDecrypter(-1339464723958995205L).setChild(SimpleLongDecrypter.getCachedDecrypter(-439904404007456266L));
    SimpleLongDecrypter.getCachedDecrypter(-6267110119259939800L).setChild(SimpleLongDecrypter.getCachedDecrypter(-2213620631355669931L));
    SimpleLongDecrypter.getCachedDecrypter(2195297040547941010L).setChild(SimpleLongDecrypter.getCachedDecrypter(-6036130927416826466L));
    SimpleLongDecrypter.getCachedDecrypter(-3635899182370024525L).setChild(SimpleLongDecrypter.getCachedDecrypter(-7962489462776054695L));
    SimpleLongDecrypter.getCachedDecrypter(-7082735442922805344L).setChild(SimpleLongDecrypter.getCachedDecrypter(-8188567450255973044L));
    SimpleLongDecrypter.getCachedDecrypter(-6160870960674341068L).setChild(SimpleLongDecrypter.getCachedDecrypter(506497671333270429L));
    SimpleLongDecrypter.getCachedDecrypter(6926933056808113743L).setChild(SimpleLongDecrypter.getCachedDecrypter(-8232327327937262234L));
    SimpleLongDecrypter.getCachedDecrypter(8652705945099767755L).setChild(SimpleLongDecrypter.getCachedDecrypter(-6637100465415064466L));
    SimpleLongDecrypter.getCachedDecrypter(-8515961753106348133L).setChild(SimpleLongDecrypter.getCachedDecrypter(-8081365087505464917L));
    SimpleLongDecrypter.getCachedDecrypter(395268676720384512L).setChild(SimpleLongDecrypter.getCachedDecrypter(-3140235633325434923L));
    SimpleLongDecrypter.getCachedDecrypter(1925054666822262402L).setChild(SimpleLongDecrypter.getCachedDecrypter(1266116562772003908L));
    SimpleLongDecrypter.getCachedDecrypter(2530205096464133970L).setChild(SimpleLongDecrypter.getCachedDecrypter(8992475098889097120L));
    SimpleLongDecrypter.getCachedDecrypter(-6540023932777848058L).setChild(SimpleLongDecrypter.getCachedDecrypter(4301927205159801191L));
    SimpleLongDecrypter.getCachedDecrypter(-3897358688431377058L).setChild(SimpleLongDecrypter.getCachedDecrypter(-5550460529409159860L));
    SimpleLongDecrypter.getCachedDecrypter(-3194846047851463045L).setChild(SimpleLongDecrypter.getCachedDecrypter(-8067415010166852420L));
    SimpleLongDecrypter.getCachedDecrypter(-4158011642987891572L).setChild(SimpleLongDecrypter.getCachedDecrypter(8691922172153854547L));
    SimpleLongDecrypter.getCachedDecrypter(-3839670183351774361L).setChild(SimpleLongDecrypter.getCachedDecrypter(8742548475825882702L));
    SimpleLongDecrypter.getCachedDecrypter(-4903308482967971646L).setChild(SimpleLongDecrypter.getCachedDecrypter(-7718431959952319489L));
    SimpleLongDecrypter.getCachedDecrypter(3489735710305116480L).setChild(SimpleLongDecrypter.getCachedDecrypter(-6568225821611770867L));
    SimpleLongDecrypter.getCachedDecrypter(2621367610522681285L).setChild(SimpleLongDecrypter.getCachedDecrypter(8116228842664109392L));
    SimpleLongDecrypter.getCachedDecrypter(419853503675703848L).setChild(SimpleLongDecrypter.getCachedDecrypter(-6729066079806909382L));
    SimpleLongDecrypter.getCachedDecrypter(-7449706112540656127L).setChild(SimpleLongDecrypter.getCachedDecrypter(5796707392960242636L));
    SimpleLongDecrypter.getCachedDecrypter(-1204466139341444200L).setChild(SimpleLongDecrypter.getCachedDecrypter(-8769336641727557478L));
    SimpleLongDecrypter.getCachedDecrypter(-6861188099878450360L).setChild(SimpleLongDecrypter.getCachedDecrypter(5177699500784113388L));
    SimpleLongDecrypter.getCachedDecrypter(-5819820315177618942L).setChild(SimpleLongDecrypter.getCachedDecrypter(-2042656567073087083L));
    SimpleLongDecrypter.getCachedDecrypter(-6923538913548135444L).setChild(SimpleLongDecrypter.getCachedDecrypter(-5103700385353568744L));
    SimpleLongDecrypter.getCachedDecrypter(-2568171337183865152L).setChild(SimpleLongDecrypter.getCachedDecrypter(-1687752523079363847L));
    SimpleLongDecrypter.getCachedDecrypter(6171767994888564121L).setChild(SimpleLongDecrypter.getCachedDecrypter(-7054815939549967669L));
    SimpleLongDecrypter.getCachedDecrypter(7274116216330748339L).setChild(SimpleLongDecrypter.getCachedDecrypter(-88992214020540670L));
    SimpleLongDecrypter.getCachedDecrypter(5340991671682028639L).setChild(SimpleLongDecrypter.getCachedDecrypter(-2646568114065908421L));
    SimpleLongDecrypter.getCachedDecrypter(-406360373630190612L).setChild(SimpleLongDecrypter.getCachedDecrypter(4792945756970219759L));
    SimpleLongDecrypter.getCachedDecrypter(-234855949964617381L).setChild(SimpleLongDecrypter.getCachedDecrypter(-761772711232521406L));
    SimpleLongDecrypter.getCachedDecrypter(-2183625647105481466L).setChild(SimpleLongDecrypter.getCachedDecrypter(-5585125933343233217L));
    SimpleLongDecrypter.getCachedDecrypter(2070569302860676030L).setChild(SimpleLongDecrypter.getCachedDecrypter(-6499316274545131691L));
    SimpleLongDecrypter.getCachedDecrypter(-1533012689217631230L).setChild(SimpleLongDecrypter.getCachedDecrypter(4146812658546732030L));
    SimpleLongDecrypter.getCachedDecrypter(3216159436105609797L).setChild(SimpleLongDecrypter.getCachedDecrypter(6450814972817031474L));
    SimpleLongDecrypter.getCachedDecrypter(7337088737787407690L).setChild(SimpleLongDecrypter.getCachedDecrypter(-1866112981936700991L));
    SimpleLongDecrypter.getCachedDecrypter(6546726037700175056L).setChild(SimpleLongDecrypter.getCachedDecrypter(-8198651759612411702L));
    SimpleLongDecrypter.getCachedDecrypter(5763083069142072911L).setChild(SimpleLongDecrypter.getCachedDecrypter(-4007265190674354335L));
    SimpleLongDecrypter.getCachedDecrypter(-797970001185778887L).setChild(SimpleLongDecrypter.getCachedDecrypter(1033873022318610980L));
    SimpleLongDecrypter.getCachedDecrypter(1564900841208575884L).setChild(SimpleLongDecrypter.getCachedDecrypter(6154624247880896829L));
    SimpleLongDecrypter.getCachedDecrypter(-7872296773749919374L).setChild(SimpleLongDecrypter.getCachedDecrypter(7151273152527155899L));
    SimpleLongDecrypter.getCachedDecrypter(-5617374066161817628L).setChild(SimpleLongDecrypter.getCachedDecrypter(-6192237917970790436L));
    SimpleLongDecrypter.getCachedDecrypter(8869069173820047768L).setChild(SimpleLongDecrypter.getCachedDecrypter(6634122443583445942L));
    SimpleLongDecrypter.getCachedDecrypter(4051267050173812799L).setChild(SimpleLongDecrypter.getCachedDecrypter(-7798855477378304638L));
    SimpleLongDecrypter.getCachedDecrypter(-7136778762495634762L).setChild(SimpleLongDecrypter.getCachedDecrypter(-2254332461018839683L));
    SimpleLongDecrypter.getCachedDecrypter(9077444728485617593L).setChild(SimpleLongDecrypter.getCachedDecrypter(-7902178421858125729L));
    SimpleLongDecrypter.getCachedDecrypter(-4190293606630623801L).setChild(SimpleLongDecrypter.getCachedDecrypter(-3827549316738103350L));
    SimpleLongDecrypter.getCachedDecrypter(8123414983467587327L).setChild(SimpleLongDecrypter.getCachedDecrypter(7548625935894456327L));
    SimpleLongDecrypter.getCachedDecrypter(4756937187665201685L).setChild(SimpleLongDecrypter.getCachedDecrypter(-6917248340964123L));
    SimpleLongDecrypter.getCachedDecrypter(-1763035265546887827L).setChild(SimpleLongDecrypter.getCachedDecrypter(7701439795142094065L));
    SimpleLongDecrypter.getCachedDecrypter(8615195480243312642L).setChild(SimpleLongDecrypter.getCachedDecrypter(-5273128524910742733L));
    SimpleLongDecrypter.getCachedDecrypter(-9156749268158163070L).setChild(SimpleLongDecrypter.getCachedDecrypter(-6775825287055311240L));
    SimpleLongDecrypter.getCachedDecrypter(3485954081509334010L).setChild(SimpleLongDecrypter.getCachedDecrypter(4569573544282848207L));
    SimpleLongDecrypter.getCachedDecrypter(-1599678998189121009L).setChild(SimpleLongDecrypter.getCachedDecrypter(-2124053579261877332L));
    SimpleLongDecrypter.getCachedDecrypter(-6211645423194411939L).setChild(SimpleLongDecrypter.getCachedDecrypter(2367363218296822603L));
    SimpleLongDecrypter.getCachedDecrypter(-4278228138317088718L).setChild(SimpleLongDecrypter.getCachedDecrypter(3737728533147581839L));
    SimpleLongDecrypter.getCachedDecrypter(-5134193286250597421L).setChild(SimpleLongDecrypter.getCachedDecrypter(5706436078071354656L));
    SimpleLongDecrypter.getCachedDecrypter(-3301737976759136321L).setChild(SimpleLongDecrypter.getCachedDecrypter(4221950029879721471L));
    SimpleLongDecrypter.getCachedDecrypter(6989377807297194735L).setChild(SimpleLongDecrypter.getCachedDecrypter(8693788439019486229L));
    SimpleLongDecrypter.getCachedDecrypter(4064376815669702283L).setChild(SimpleLongDecrypter.getCachedDecrypter(857201944168274217L));
    SimpleLongDecrypter.getCachedDecrypter(8744148804982604716L).setChild(SimpleLongDecrypter.getCachedDecrypter(8586476969485614159L));
    SimpleLongDecrypter.getCachedDecrypter(644191710526643751L).setChild(SimpleLongDecrypter.getCachedDecrypter(3237780179820166555L));
    SimpleLongDecrypter.getCachedDecrypter(8015319415608055960L).setChild(SimpleLongDecrypter.getCachedDecrypter(-6353769624846865260L));
    SimpleLongDecrypter.getCachedDecrypter(-5148795244977954023L).setChild(SimpleLongDecrypter.getCachedDecrypter(8578640289587340680L));
    SimpleLongDecrypter.getCachedDecrypter(3481763425916949095L).setChild(SimpleLongDecrypter.getCachedDecrypter(-2049521222394817462L));
    SimpleLongDecrypter.getCachedDecrypter(-442478870125095842L).setChild(SimpleLongDecrypter.getCachedDecrypter(-8881313692116588375L));
    SimpleLongDecrypter.getCachedDecrypter(6546039463061568173L).setChild(SimpleLongDecrypter.getCachedDecrypter(-2907070742324026490L));
    SimpleLongDecrypter.getCachedDecrypter(-3853673304230964239L).setChild(SimpleLongDecrypter.getCachedDecrypter(2802541380018343544L));
    SimpleLongDecrypter.getCachedDecrypter(8049323981228840204L).setChild(SimpleLongDecrypter.getCachedDecrypter(-2154652276225259664L));
    SimpleLongDecrypter.getCachedDecrypter(-1774571464897092962L).setChild(SimpleLongDecrypter.getCachedDecrypter(-8616608047438441805L));
    SimpleLongDecrypter.getCachedDecrypter(-1076853949166901338L).setChild(SimpleLongDecrypter.getCachedDecrypter(7320816159752358541L));
    SimpleLongDecrypter.getCachedDecrypter(5757777911833986729L).setChild(SimpleLongDecrypter.getCachedDecrypter(8523784981563329105L));
    SimpleLongDecrypter.getCachedDecrypter(3746827096723897243L).setChild(SimpleLongDecrypter.getCachedDecrypter(-2369919603171053267L));
    SimpleLongDecrypter.getCachedDecrypter(7884292683753352601L).setChild(SimpleLongDecrypter.getCachedDecrypter(2371511123464566991L));
    SimpleLongDecrypter.getCachedDecrypter(394596521283131811L).setChild(SimpleLongDecrypter.getCachedDecrypter(590093467030702653L));
    SimpleLongDecrypter.getCachedDecrypter(7204873755456844705L).setChild(SimpleLongDecrypter.getCachedDecrypter(-3117332478503248651L));
    SimpleLongDecrypter.getCachedDecrypter(-6795631248796792530L).setChild(SimpleLongDecrypter.getCachedDecrypter(6735597719008617323L));
    SimpleLongDecrypter.getCachedDecrypter(3375182685821931590L).setChild(SimpleLongDecrypter.getCachedDecrypter(-5340248739275311178L));
    SimpleLongDecrypter.getCachedDecrypter(9085500316335344274L).setChild(SimpleLongDecrypter.getCachedDecrypter(-2495272224289347492L));
    SimpleLongDecrypter.getCachedDecrypter(-9110917481300078142L).setChild(SimpleLongDecrypter.getCachedDecrypter(2531986729633353124L));
    SimpleLongDecrypter.getCachedDecrypter(6362455586043225804L).setChild(SimpleLongDecrypter.getCachedDecrypter(-6002430136711561821L));
    SimpleLongDecrypter.getCachedDecrypter(-932717631578316767L).setChild(SimpleLongDecrypter.getCachedDecrypter(3105818719703982991L));
    SimpleLongDecrypter.getCachedDecrypter(-4819764561478341351L).setChild(SimpleLongDecrypter.getCachedDecrypter(-2312872564724143296L));
    SimpleLongDecrypter.getCachedDecrypter(-5538845460319945339L).setChild(SimpleLongDecrypter.getCachedDecrypter(-1841751061392169458L));
    SimpleLongDecrypter.getCachedDecrypter(8556072894249772299L).setChild(SimpleLongDecrypter.getCachedDecrypter(919348880000951843L));
    SimpleLongDecrypter.getCachedDecrypter(3604329199951685635L).setChild(SimpleLongDecrypter.getCachedDecrypter(-5416148051831291773L));
    SimpleLongDecrypter.getCachedDecrypter(-1040021295561250879L).setChild(SimpleLongDecrypter.getCachedDecrypter(-8182466970736895429L));
    SimpleLongDecrypter.getCachedDecrypter(-4022042888108275255L).setChild(SimpleLongDecrypter.getCachedDecrypter(5865332559364661771L));
    SimpleLongDecrypter.getCachedDecrypter(5746471864070743371L).setChild(SimpleLongDecrypter.getCachedDecrypter(-1695796155735699321L));
    SimpleLongDecrypter.getCachedDecrypter(-5937981345176564746L).setChild(SimpleLongDecrypter.getCachedDecrypter(-873658881905925622L));
    SimpleLongDecrypter.getCachedDecrypter(-3190731840701391617L).setChild(SimpleLongDecrypter.getCachedDecrypter(-4784735121240880470L));
    SimpleLongDecrypter.getCachedDecrypter(-5661547407791187888L).setChild(SimpleLongDecrypter.getCachedDecrypter(-2707262269984351755L));
    SimpleLongDecrypter.getCachedDecrypter(6089199059640371863L).setChild(SimpleLongDecrypter.getCachedDecrypter(4163240203735598724L));
    SimpleLongDecrypter.getCachedDecrypter(5595977630662190260L).setChild(SimpleLongDecrypter.getCachedDecrypter(-6739742118757754660L));
    SimpleLongDecrypter.getCachedDecrypter(-8112409814377107772L).setChild(SimpleLongDecrypter.getCachedDecrypter(-7410703826639319079L));
    SimpleLongDecrypter.getCachedDecrypter(-4914838825486075048L).setChild(SimpleLongDecrypter.getCachedDecrypter(5034536773969575943L));
    SimpleLongDecrypter.getCachedDecrypter(5805138704225564179L).setChild(SimpleLongDecrypter.getCachedDecrypter(-6234229361970831054L));
    SimpleLongDecrypter.getCachedDecrypter(7067708435390684181L).setChild(SimpleLongDecrypter.getCachedDecrypter(2039451878026792880L));
    SimpleLongDecrypter.getCachedDecrypter(5977480719136064405L).setChild(SimpleLongDecrypter.getCachedDecrypter(3421968712861918015L));
    SimpleLongDecrypter.getCachedDecrypter(8778661043995307043L).setChild(SimpleLongDecrypter.getCachedDecrypter(-1232638800979478577L));
    SimpleLongDecrypter.getCachedDecrypter(-6001122989254055460L).setChild(SimpleLongDecrypter.getCachedDecrypter(-7497008411315546163L));
    SimpleLongDecrypter.getCachedDecrypter(-8213384286531170193L).setChild(SimpleLongDecrypter.getCachedDecrypter(-783850359622143819L));
    SimpleLongDecrypter.getCachedDecrypter(2013617285219519111L).setChild(SimpleLongDecrypter.getCachedDecrypter(-7441799508157325060L));
    SimpleLongDecrypter.getCachedDecrypter(-2381361684164834084L).setChild(SimpleLongDecrypter.getCachedDecrypter(-649450547294321637L));
    SimpleLongDecrypter.getCachedDecrypter(-2416278818245275920L).setChild(SimpleLongDecrypter.getCachedDecrypter(5029001852695440059L));
    SimpleLongDecrypter.getCachedDecrypter(4849029536827076223L).setChild(SimpleLongDecrypter.getCachedDecrypter(6385493025280121372L));
    SimpleLongDecrypter.getCachedDecrypter(-8424229937282305836L).setChild(SimpleLongDecrypter.getCachedDecrypter(8320493775880418339L));
    SimpleLongDecrypter.getCachedDecrypter(-4514603734649314352L).setChild(SimpleLongDecrypter.getCachedDecrypter(-2613331830476356582L));
    SimpleLongDecrypter.getCachedDecrypter(4018090343122046663L).setChild(SimpleLongDecrypter.getCachedDecrypter(731668010870130746L));
    SimpleLongDecrypter.getCachedDecrypter(-2953799052069206233L).setChild(SimpleLongDecrypter.getCachedDecrypter(4884533278795276364L));
    SimpleLongDecrypter.getCachedDecrypter(3796199456439943119L).setChild(SimpleLongDecrypter.getCachedDecrypter(6851062508416013699L));
    SimpleLongDecrypter.getCachedDecrypter(6504255894926000394L).setChild(SimpleLongDecrypter.getCachedDecrypter(4991864357580206432L));
    SimpleLongDecrypter.getCachedDecrypter(-7114430753912583426L).setChild(SimpleLongDecrypter.getCachedDecrypter(-5339896538127694890L));
    SimpleLongDecrypter.getCachedDecrypter(-6521271303948254436L).setChild(SimpleLongDecrypter.getCachedDecrypter(-2711921645733899388L));
    SimpleLongDecrypter.getCachedDecrypter(-913249808141621761L).setChild(SimpleLongDecrypter.getCachedDecrypter(-7464150191667606742L));
    SimpleLongDecrypter.getCachedDecrypter(7243723480659128458L).setChild(SimpleLongDecrypter.getCachedDecrypter(-7255249095637073690L));
    SimpleLongDecrypter.getCachedDecrypter(2265532591832649986L).setChild(SimpleLongDecrypter.getCachedDecrypter(-6182447631327552950L));
    SimpleLongDecrypter.getCachedDecrypter(7775834118475129116L).setChild(SimpleLongDecrypter.getCachedDecrypter(-2960508264570444660L));
    SimpleLongDecrypter.getCachedDecrypter(-2449604811915569972L).setChild(SimpleLongDecrypter.getCachedDecrypter(6286640156965522327L));
    SimpleLongDecrypter.getCachedDecrypter(-2035672979804289003L).setChild(SimpleLongDecrypter.getCachedDecrypter(1919765053951512027L));
    SimpleLongDecrypter.getCachedDecrypter(7994460447217903383L).setChild(SimpleLongDecrypter.getCachedDecrypter(-915821709692845186L));
    SimpleLongDecrypter.getCachedDecrypter(3089960458208207407L).setChild(SimpleLongDecrypter.getCachedDecrypter(-1700871477840608347L));
    SimpleLongDecrypter.getCachedDecrypter(-8810700170553810626L).setChild(SimpleLongDecrypter.getCachedDecrypter(1065230423441244469L));
    SimpleLongDecrypter.getCachedDecrypter(-8254754090985849191L).setChild(SimpleLongDecrypter.getCachedDecrypter(-899652975262687915L));
    SimpleLongDecrypter.getCachedDecrypter(2232877113175008577L).setChild(SimpleLongDecrypter.getCachedDecrypter(1211541992046158761L));
    SimpleLongDecrypter.getCachedDecrypter(-4279676109623497126L).setChild(SimpleLongDecrypter.getCachedDecrypter(-3388602136030134803L));
    SimpleLongDecrypter.getCachedDecrypter(7598025337294845017L).setChild(SimpleLongDecrypter.getCachedDecrypter(-4508774729372623533L));
    SimpleLongDecrypter.getCachedDecrypter(-7593614314791404258L).setChild(SimpleLongDecrypter.getCachedDecrypter(-3295144668808350244L));
    SimpleLongDecrypter.getCachedDecrypter(-3946673195261662158L).setChild(SimpleLongDecrypter.getCachedDecrypter(1405119140104038561L));
    SimpleLongDecrypter.getCachedDecrypter(-1687801297030480490L).setKey(9035505579810971093L);
    SimpleLongDecrypter.getCachedDecrypter(839170810005028463L).setKey(1377509904951237953L);
    SimpleLongDecrypter.getCachedDecrypter(1006235134574781600L).setKey(8813853026480736637L);
    SimpleLongDecrypter.getCachedDecrypter(5827005005929101760L).setKey(8068702893528140911L);
    SimpleLongDecrypter.getCachedDecrypter(-1620130627922048736L).setKey(-2794292103442652149L);
    SimpleLongDecrypter.getCachedDecrypter(-2889786308392928681L).setKey(-438246856312059149L);
    SimpleLongDecrypter.getCachedDecrypter(4201142996276959446L).setKey(-7623324939006558795L);
    SimpleLongDecrypter.getCachedDecrypter(-7588767932666833750L).setKey(3606389575382117317L);
    SimpleLongDecrypter.getCachedDecrypter(-3431590292493056223L).setKey(8874977424003475424L);
    SimpleLongDecrypter.getCachedDecrypter(8344279254774909678L).setKey(3952465644874973885L);
    SimpleLongDecrypter.getCachedDecrypter(3532030509744383556L).setKey(4583709014226352936L);
    SimpleLongDecrypter.getCachedDecrypter(-4066597297490302706L).setKey(-7474714324265743083L);
    SimpleLongDecrypter.getCachedDecrypter(1484684983882196676L).setKey(6628077279547674892L);
    SimpleLongDecrypter.getCachedDecrypter(-2675550573962655852L).setKey(2801870046184812837L);
    SimpleLongDecrypter.getCachedDecrypter(-6051868466913286154L).setKey(-3520584899529120052L);
    SimpleLongDecrypter.getCachedDecrypter(8601260025962749253L).setKey(1974916616525825200L);
    SimpleLongDecrypter.getCachedDecrypter(-8239545246304600392L).setKey(-8423443726748823337L);
    SimpleLongDecrypter.getCachedDecrypter(7630665689401722303L).setKey(6247100607277175900L);
    SimpleLongDecrypter.getCachedDecrypter(-1535437735835094979L).setKey(6101167110993430704L);
    SimpleLongDecrypter.getCachedDecrypter(-2786418183258079495L).setKey(-1987378687821681385L);
    SimpleLongDecrypter.getCachedDecrypter(776627356474954479L).setKey(3829215224626892749L);
    SimpleLongDecrypter.getCachedDecrypter(-3860853012179319122L).setKey(-1314273391555892849L);
    SimpleLongDecrypter.getCachedDecrypter(-4476583800497163020L).setKey(2239573647235333618L);
    SimpleLongDecrypter.getCachedDecrypter(8468387033847605840L).setKey(-4968121689851854740L);
    SimpleLongDecrypter.getCachedDecrypter(-963157713029069682L).setKey(951603026848971592L);
    SimpleLongDecrypter.getCachedDecrypter(-186695498145066343L).setKey(3464899193122336136L);
    SimpleLongDecrypter.getCachedDecrypter(-4259580546096079344L).setKey(2825202266775768970L);
    SimpleLongDecrypter.getCachedDecrypter(-7030730832343435102L).setKey(-4269990181730933622L);
    SimpleLongDecrypter.getCachedDecrypter(-7969399907252088328L).setKey(-8122560438108013314L);
    SimpleLongDecrypter.getCachedDecrypter(7993869036920847124L).setKey(1105798848640253001L);
    SimpleLongDecrypter.getCachedDecrypter(-7743886045768841356L).setKey(-1390547221052100562L);
    SimpleLongDecrypter.getCachedDecrypter(9012542123871370574L).setKey(-7716357647625918511L);
    SimpleLongDecrypter.getCachedDecrypter(-2827916667201564899L).setKey(8580877964489791682L);
    SimpleLongDecrypter.getCachedDecrypter(1482205076031720975L).setKey(-7852393681512182320L);
    SimpleLongDecrypter.getCachedDecrypter(-1774036003052191396L).setKey(-7461611579477431112L);
    SimpleLongDecrypter.getCachedDecrypter(5781428741125141782L).setKey(-7132412673758717472L);
    SimpleLongDecrypter.getCachedDecrypter(5140763764799103058L).setKey(-7087578082822814404L);
    SimpleLongDecrypter.getCachedDecrypter(4667156429308708375L).setKey(-2974673979564228050L);
    SimpleLongDecrypter.getCachedDecrypter(4195824480653337711L).setKey(2871872036548071985L);
    SimpleLongDecrypter.getCachedDecrypter(1177893404256704386L).setKey(-6593555716033411144L);
    SimpleLongDecrypter.getCachedDecrypter(-7974804659770440780L).setKey(3755286896429122408L);
    SimpleLongDecrypter.getCachedDecrypter(5530100548402394811L).setKey(4831236902013542759L);
    SimpleLongDecrypter.getCachedDecrypter(-32548523916352716L).setKey(6982064104588075165L);
    SimpleLongDecrypter.getCachedDecrypter(-7652880060730765566L).setKey(4073454997947425743L);
    SimpleLongDecrypter.getCachedDecrypter(-8523600006446826161L).setKey(589966531699892954L);
    SimpleLongDecrypter.getCachedDecrypter(-5577819823085510975L).setKey(373578814694300140L);
    SimpleLongDecrypter.getCachedDecrypter(1259574829590385678L).setKey(-385206962206420812L);
    SimpleLongDecrypter.getCachedDecrypter(7754942803328756876L).setKey(439371597307386824L);
    SimpleLongDecrypter.getCachedDecrypter(-7592416742862684129L).setKey(-6910514494554877980L);
    SimpleLongDecrypter.getCachedDecrypter(-3040459825056057948L).setKey(1394869002000922205L);
    SimpleLongDecrypter.getCachedDecrypter(-3244954416438319973L).setKey(8721308627724101276L);
    SimpleLongDecrypter.getCachedDecrypter(392907372959869062L).setKey(-5252902945472920538L);
    SimpleLongDecrypter.getCachedDecrypter(791581630082120729L).setKey(-4777325010767433845L);
    SimpleLongDecrypter.getCachedDecrypter(-7247856208351020506L).setKey(5451488223132349625L);
    SimpleLongDecrypter.getCachedDecrypter(-6441650631652793428L).setKey(-1685394237288469814L);
    SimpleLongDecrypter.getCachedDecrypter(-1133689432286988254L).setKey(3849261407629588495L);
    SimpleLongDecrypter.getCachedDecrypter(3232686385880699986L).setKey(-7259462095418955005L);
    SimpleLongDecrypter.getCachedDecrypter(-5429525813836609683L).setKey(5560875312476557975L);
    SimpleLongDecrypter.getCachedDecrypter(-3034646919166970109L).setKey(6724045258221870829L);
    SimpleLongDecrypter.getCachedDecrypter(3660622377763254266L).setKey(4705656288916800910L);
    SimpleLongDecrypter.getCachedDecrypter(-7453367982812875730L).setKey(-5914398315239713275L);
    SimpleLongDecrypter.getCachedDecrypter(8563163625146084871L).setKey(-7502742840923875349L);
    SimpleLongDecrypter.getCachedDecrypter(-5881540505870494241L).setKey(-8204972744592668688L);
    SimpleLongDecrypter.getCachedDecrypter(5807553681231454994L).setKey(7893784886526427602L);
    SimpleLongDecrypter.getCachedDecrypter(7868358815255099492L).setKey(582022674235852978L);
    SimpleLongDecrypter.getCachedDecrypter(8284317391688468263L).setKey(-3914219111943616045L);
    SimpleLongDecrypter.getCachedDecrypter(3962748777278634472L).setKey(66977511477576116L);
    SimpleLongDecrypter.getCachedDecrypter(7267881475870807184L).setKey(429199649098519217L);
    SimpleLongDecrypter.getCachedDecrypter(-3975493155070590315L).setKey(-3102339716374233214L);
    SimpleLongDecrypter.getCachedDecrypter(8283510796984287033L).setKey(-7272138909926388507L);
    SimpleLongDecrypter.getCachedDecrypter(335308784435883952L).setKey(5313070806350919952L);
    SimpleLongDecrypter.getCachedDecrypter(8225825407399966743L).setKey(-6672093826064048687L);
    SimpleLongDecrypter.getCachedDecrypter(4017299796935741729L).setKey(2545437831806384503L);
    SimpleLongDecrypter.getCachedDecrypter(-7514084015960819271L).setKey(-1931115984382962138L);
    SimpleLongDecrypter.getCachedDecrypter(-3316859656188138800L).setKey(8328162419429353172L);
    SimpleLongDecrypter.getCachedDecrypter(-659327610908283410L).setKey(2720678390731021359L);
    SimpleLongDecrypter.getCachedDecrypter(1604568453256038459L).setKey(-5035789255770332051L);
    SimpleLongDecrypter.getCachedDecrypter(1285609683576345001L).setKey(-1760393444990642333L);
    SimpleLongDecrypter.getCachedDecrypter(-915907276286386849L).setKey(8458744486949385602L);
    SimpleLongDecrypter.getCachedDecrypter(-2613321510381934377L).setKey(-8449043896509269618L);
    SimpleLongDecrypter.getCachedDecrypter(-4758681704657970022L).setKey(-7504463986668172476L);
    SimpleLongDecrypter.getCachedDecrypter(7277757535971756465L).setKey(-3540757721070907738L);
    SimpleLongDecrypter.getCachedDecrypter(-8900782187369124545L).setKey(-6163147974017894295L);
    SimpleLongDecrypter.getCachedDecrypter(-3754906561523086242L).setKey(4719431323046406244L);
    SimpleLongDecrypter.getCachedDecrypter(25423516108122609L).setKey(-5388691637680948612L);
    SimpleLongDecrypter.getCachedDecrypter(-2121989390598636866L).setKey(3443817081616157514L);
    SimpleLongDecrypter.getCachedDecrypter(7098550875079893825L).setKey(-6020865890609266889L);
    SimpleLongDecrypter.getCachedDecrypter(5889144850582701309L).setKey(5034805364492289315L);
    SimpleLongDecrypter.getCachedDecrypter(6019873341977734664L).setKey(620111562739042106L);
    SimpleLongDecrypter.getCachedDecrypter(-7436718230334501946L).setKey(-5889341832517045651L);
    SimpleLongDecrypter.getCachedDecrypter(-2805029226992001714L).setKey(-7268405893652589720L);
    SimpleLongDecrypter.getCachedDecrypter(-1268216701412074951L).setKey(-7363601240581690738L);
    SimpleLongDecrypter.getCachedDecrypter(-8139845446816054957L).setKey(7234954020884980399L);
    SimpleLongDecrypter.getCachedDecrypter(1486247676607179878L).setKey(-2001894580323844528L);
    SimpleLongDecrypter.getCachedDecrypter(-4938901033051618950L).setKey(4540780395115003979L);
    SimpleLongDecrypter.getCachedDecrypter(-5883087715123707242L).setKey(4241937628526535584L);
    SimpleLongDecrypter.getCachedDecrypter(-2312232914144269235L).setKey(7964327048443566576L);
    SimpleLongDecrypter.getCachedDecrypter(-8350530775578678934L).setKey(4575187350542413589L);
    SimpleLongDecrypter.getCachedDecrypter(-7427398034206614491L).setKey(-6130846747758328818L);
    SimpleLongDecrypter.getCachedDecrypter(481027163611181278L).setKey(8413209770904837133L);
    SimpleLongDecrypter.getCachedDecrypter(5861528041068097180L).setKey(7280840527269418701L);
    SimpleLongDecrypter.getCachedDecrypter(3854987289991889212L).setKey(-2597569056559360385L);
    SimpleLongDecrypter.getCachedDecrypter(-1959960910737496632L).setKey(4785865685211466318L);
    SimpleLongDecrypter.getCachedDecrypter(7553360981360436562L).setKey(-6387071793234398256L);
    SimpleLongDecrypter.getCachedDecrypter(7932902595496121016L).setKey(-3202630900339751153L);
    SimpleLongDecrypter.getCachedDecrypter(7545081526052856424L).setKey(-10418375960243064L);
    SimpleLongDecrypter.getCachedDecrypter(747993811866076180L).setKey(-5699884089158347300L);
    SimpleLongDecrypter.getCachedDecrypter(5028540990233040597L).setKey(1449421975980050395L);
    SimpleLongDecrypter.getCachedDecrypter(6459331634871161104L).setKey(8008479534115852162L);
    SimpleLongDecrypter.getCachedDecrypter(-9144803040383257562L).setKey(-5878005847933694208L);
    SimpleLongDecrypter.getCachedDecrypter(-6709438036463147112L).setKey(6749478747219817717L);
    SimpleLongDecrypter.getCachedDecrypter(-7043667597910571275L).setKey(1257103462245836398L);
    SimpleLongDecrypter.getCachedDecrypter(7100773112979052277L).setKey(4143504197598676611L);
    SimpleLongDecrypter.getCachedDecrypter(4564631690533534790L).setKey(4393211497186200780L);
    SimpleLongDecrypter.getCachedDecrypter(5432163899056030519L).setKey(-1521182912645219985L);
    SimpleLongDecrypter.getCachedDecrypter(658115482158717630L).setKey(-5019957363947126361L);
    SimpleLongDecrypter.getCachedDecrypter(9054661641135494679L).setKey(5107098703882637344L);
    SimpleLongDecrypter.getCachedDecrypter(7251705521748800610L).setKey(47384805705861055L);
    SimpleLongDecrypter.getCachedDecrypter(1300135942853784818L).setKey(7591632733806117408L);
    SimpleLongDecrypter.getCachedDecrypter(3590660434768594909L).setKey(-8903731610591496349L);
    SimpleLongDecrypter.getCachedDecrypter(8985527791238610512L).setKey(-2484621006183358535L);
    SimpleLongDecrypter.getCachedDecrypter(5918717561938289427L).setKey(3897527219873353352L);
    SimpleLongDecrypter.getCachedDecrypter(-5079380681825172699L).setKey(-5042401447992908746L);
    SimpleLongDecrypter.getCachedDecrypter(-9110517861132586410L).setKey(-5411680112512400596L);
    SimpleLongDecrypter.getCachedDecrypter(-7829891665816658742L).setKey(-3540765545573032319L);
    SimpleLongDecrypter.getCachedDecrypter(6148705170337054785L).setKey(2877102063159594744L);
    SimpleLongDecrypter.getCachedDecrypter(2873657619170920166L).setKey(3031881800503101175L);
    SimpleLongDecrypter.getCachedDecrypter(-6928514617268562706L).setKey(2787036127285089262L);
    SimpleLongDecrypter.getCachedDecrypter(-349674079465302572L).setKey(-3114709345632723067L);
    SimpleLongDecrypter.getCachedDecrypter(1686497131945929186L).setKey(-8635987775135122403L);
    SimpleLongDecrypter.getCachedDecrypter(3693860369801601361L).setKey(-2514510076628673584L);
    SimpleLongDecrypter.getCachedDecrypter(3063101272481544812L).setKey(-1970153809152021940L);
    SimpleLongDecrypter.getCachedDecrypter(5152815545086874584L).setKey(-8388696723669881006L);
    SimpleLongDecrypter.getCachedDecrypter(-3098383440936398269L).setKey(6636730484850516863L);
    SimpleLongDecrypter.getCachedDecrypter(-219995232263326805L).setKey(3313531268657860490L);
    SimpleLongDecrypter.getCachedDecrypter(-1137892690691078103L).setKey(6002286154771606501L);
    SimpleLongDecrypter.getCachedDecrypter(-4307398480013086055L).setKey(-2033152670098084712L);
    SimpleLongDecrypter.getCachedDecrypter(5024893108290924874L).setKey(214667639394448559L);
    SimpleLongDecrypter.getCachedDecrypter(109175201415463182L).setKey(6323970893596389014L);
    SimpleLongDecrypter.getCachedDecrypter(2191254850392429911L).setKey(-266695439759028242L);
    SimpleLongDecrypter.getCachedDecrypter(6027202515584732464L).setKey(741362946662043614L);
    SimpleLongDecrypter.getCachedDecrypter(-8911483452475226164L).setKey(-1306777987400181116L);
    SimpleLongDecrypter.getCachedDecrypter(-7046471220132584275L).setKey(522496683322137953L);
    SimpleLongDecrypter.getCachedDecrypter(3367566379867133353L).setKey(-526357240420579428L);
    SimpleLongDecrypter.getCachedDecrypter(3654553137677473844L).setKey(-7085980105674617810L);
    SimpleLongDecrypter.getCachedDecrypter(2904234771865502288L).setKey(-5501853514963570863L);
    SimpleLongDecrypter.getCachedDecrypter(-7671314827118883438L).setKey(3488190176153123693L);
    SimpleLongDecrypter.getCachedDecrypter(-6175504150124776849L).setKey(7830036519447375550L);
    SimpleLongDecrypter.getCachedDecrypter(4541235248156786122L).setKey(8051860574879584565L);
    SimpleLongDecrypter.getCachedDecrypter(-441544170171554847L).setKey(5345446112717524161L);
    SimpleLongDecrypter.getCachedDecrypter(11074999347912416L).setKey(3991831966464583345L);
    SimpleLongDecrypter.getCachedDecrypter(307619396280607911L).setKey(3468931850486113083L);
    SimpleLongDecrypter.getCachedDecrypter(-8965771547849787126L).setKey(-7800593706377861082L);
    SimpleLongDecrypter.getCachedDecrypter(4591739844654543880L).setKey(-7215537456583032188L);
    SimpleLongDecrypter.getCachedDecrypter(-5396884867232164608L).setKey(2856662327795152446L);
    SimpleLongDecrypter.getCachedDecrypter(4247416644848881981L).setKey(-701217472135571135L);
    SimpleLongDecrypter.getCachedDecrypter(4027399919241943185L).setKey(924163430047002169L);
    SimpleLongDecrypter.getCachedDecrypter(-7297631962996823785L).setKey(3338141506211884991L);
    SimpleLongDecrypter.getCachedDecrypter(1561588544490454004L).setKey(6703011525747425471L);
    SimpleLongDecrypter.getCachedDecrypter(9172225693067162294L).setKey(-4265880124877152063L);
    SimpleLongDecrypter.getCachedDecrypter(248639762751927841L).setKey(-5305667596876526098L);
    SimpleLongDecrypter.getCachedDecrypter(-281687436302966097L).setKey(374887771634529925L);
    SimpleLongDecrypter.getCachedDecrypter(4867961155593887475L).setKey(2358946812439584922L);
    SimpleLongDecrypter.getCachedDecrypter(1218978968656394483L).setKey(604582270548257236L);
    SimpleLongDecrypter.getCachedDecrypter(-8114819628493794848L).setKey(4863278692607725617L);
    SimpleLongDecrypter.getCachedDecrypter(166400138357852798L).setKey(-7017439776166578550L);
    SimpleLongDecrypter.getCachedDecrypter(260907281877342762L).setKey(-1071433028933738546L);
    SimpleLongDecrypter.getCachedDecrypter(-2502543851040080084L).setKey(-3984215353523390988L);
    SimpleLongDecrypter.getCachedDecrypter(3465305237323627272L).setKey(7197253457855127886L);
    SimpleLongDecrypter.getCachedDecrypter(-2806556598135606734L).setKey(1426970277250636742L);
    SimpleLongDecrypter.getCachedDecrypter(-1907781958675083425L).setKey(-5984176814385660298L);
    SimpleLongDecrypter.getCachedDecrypter(-7762431419615679684L).setKey(6062658224649556085L);
    SimpleLongDecrypter.getCachedDecrypter(-4478371658966869487L).setKey(-4514830207866054595L);
    SimpleLongDecrypter.getCachedDecrypter(-3858958959376245448L).setKey(1783336056532879308L);
    SimpleLongDecrypter.getCachedDecrypter(4108066029710460410L).setKey(6028170797038164473L);
    SimpleLongDecrypter.getCachedDecrypter(4587516482145479764L).setKey(-314328875524115002L);
    SimpleLongDecrypter.getCachedDecrypter(-8710060895434779971L).setKey(-4810246998536323124L);
    SimpleLongDecrypter.getCachedDecrypter(-4225488680755211270L).setKey(3663258549866471184L);
    SimpleLongDecrypter.getCachedDecrypter(-2415836497856773718L).setKey(-8579413529834424107L);
    SimpleLongDecrypter.getCachedDecrypter(4623221425016167L).setKey(-6789161301525643571L);
    SimpleLongDecrypter.getCachedDecrypter(-5046134623583218587L).setKey(4130912432414557173L);
    SimpleLongDecrypter.getCachedDecrypter(8294568390575869156L).setKey(8352057332129332408L);
    SimpleLongDecrypter.getCachedDecrypter(1852012355455936192L).setKey(2622137741905938650L);
    SimpleLongDecrypter.getCachedDecrypter(-3116437842327622297L).setKey(1047536393193685649L);
    SimpleLongDecrypter.getCachedDecrypter(-1146012575931887370L).setKey(4641058947018605600L);
    SimpleLongDecrypter.getCachedDecrypter(7246959631459810883L).setKey(831154015231465068L);
    SimpleLongDecrypter.getCachedDecrypter(8371033099342313634L).setKey(-8683692831013825637L);
    SimpleLongDecrypter.getCachedDecrypter(-6527802852412647677L).setKey(-7392156296695107202L);
    SimpleLongDecrypter.getCachedDecrypter(387158419892315047L).setKey(-2291076756890039855L);
    SimpleLongDecrypter.getCachedDecrypter(7536910761199030312L).setKey(-7450017330228909994L);
    SimpleLongDecrypter.getCachedDecrypter(-6117010757481986528L).setKey(-3607612612610681344L);
    SimpleLongDecrypter.getCachedDecrypter(7000792081176753840L).setKey(-7517954538094264659L);
    SimpleLongDecrypter.getCachedDecrypter(5216381573865775291L).setKey(1824659613161437170L);
    SimpleLongDecrypter.getCachedDecrypter(-4227716031141332772L).setKey(-827805234783512526L);
    SimpleLongDecrypter.getCachedDecrypter(6073108262768041536L).setKey(-36974550633105555L);
    SimpleLongDecrypter.getCachedDecrypter(7826135133978019161L).setKey(-6700738459108044529L);
    SimpleLongDecrypter.getCachedDecrypter(-8273543908541816463L).setKey(2932268788637035988L);
    SimpleLongDecrypter.getCachedDecrypter(8350880445613818649L).setKey(5069008847109160984L);
    SimpleLongDecrypter.getCachedDecrypter(1940976831944366045L).setKey(-315452659049375244L);
    SimpleLongDecrypter.getCachedDecrypter(-5662929182390565486L).setKey(6632877225374295747L);
    SimpleLongDecrypter.getCachedDecrypter(8370394594628382209L).setKey(-8647880064616987068L);
    SimpleLongDecrypter.getCachedDecrypter(3929585644019809922L).setKey(245357827426041688L);
    SimpleLongDecrypter.getCachedDecrypter(7677858644434066103L).setKey(-5374998245735915928L);
    SimpleLongDecrypter.getCachedDecrypter(-7972260553768356599L).setKey(1399151337694181146L);
    SimpleLongDecrypter.getCachedDecrypter(-7739819938115641858L).setKey(-1320028941523408407L);
    SimpleLongDecrypter.getCachedDecrypter(3415268579951248018L).setKey(-7843370938479033245L);
    SimpleLongDecrypter.getCachedDecrypter(8339132425775158639L).setKey(1166996406176371254L);
    SimpleLongDecrypter.getCachedDecrypter(2736048942940159147L).setKey(-7812142505925698271L);
    SimpleLongDecrypter.getCachedDecrypter(-508930766859648259L).setKey(2503197228104978566L);
    SimpleLongDecrypter.getCachedDecrypter(836779339717194263L).setKey(290487210571510954L);
    SimpleLongDecrypter.getCachedDecrypter(-636220259015325774L).setKey(-9177964528137541144L);
    SimpleLongDecrypter.getCachedDecrypter(8002026561627282770L).setKey(7046737085163227102L);
    SimpleLongDecrypter.getCachedDecrypter(8231986331405567380L).setKey(-6419658544498350969L);
    SimpleLongDecrypter.getCachedDecrypter(-962968613217777221L).setKey(-5057833703398257177L);
    SimpleLongDecrypter.getCachedDecrypter(-8036758850164164654L).setKey(1168290475472081468L);
    SimpleLongDecrypter.getCachedDecrypter(2292488682947811420L).setKey(-6090060703513955747L);
    SimpleLongDecrypter.getCachedDecrypter(3045508323063487085L).setKey(8589946320136542236L);
    SimpleLongDecrypter.getCachedDecrypter(5832442757768346674L).setKey(-3016328507400082692L);
    SimpleLongDecrypter.getCachedDecrypter(6132077389017125111L).setKey(-7728960067201171513L);
    SimpleLongDecrypter.getCachedDecrypter(7040259576450741764L).setKey(-5595798624816472078L);
    SimpleLongDecrypter.getCachedDecrypter(-6370293963358373454L).setKey(-8207093526003897967L);
    SimpleLongDecrypter.getCachedDecrypter(2221606009250636723L).setKey(-687805105560877268L);
    SimpleLongDecrypter.getCachedDecrypter(-2519557508073837018L).setKey(-9126031188055963029L);
    SimpleLongDecrypter.getCachedDecrypter(-2087012827137697973L).setKey(-3313689810298160785L);
    SimpleLongDecrypter.getCachedDecrypter(-4419508519973265719L).setKey(-1641817661722236813L);
    SimpleLongDecrypter.getCachedDecrypter(1968288964176550575L).setKey(3653301301923704189L);
    SimpleLongDecrypter.getCachedDecrypter(39328731428598783L).setKey(2647198649683298028L);
    SimpleLongDecrypter.getCachedDecrypter(7957499372034169572L).setKey(-8792072935185231626L);
    SimpleLongDecrypter.getCachedDecrypter(3006452808995191439L).setKey(-8884099613982604373L);
    SimpleLongDecrypter.getCachedDecrypter(-6720810714914432366L).setKey(7585357503576567655L);
    SimpleLongDecrypter.getCachedDecrypter(4717287698072299720L).setKey(-7116106371334760395L);
    SimpleLongDecrypter.getCachedDecrypter(8149968452845977945L).setKey(5537808205388692656L);
    SimpleLongDecrypter.getCachedDecrypter(2851268574372615217L).setKey(-4326730723999084538L);
    SimpleLongDecrypter.getCachedDecrypter(6134737231181225164L).setKey(2348481523802123692L);
    SimpleLongDecrypter.getCachedDecrypter(2750199379952323854L).setKey(-5439068085289677484L);
    SimpleLongDecrypter.getCachedDecrypter(-1087812897245607622L).setKey(9088723456173358678L);
    SimpleLongDecrypter.getCachedDecrypter(-7326613922791864213L).setKey(3595627617427205864L);
    SimpleLongDecrypter.getCachedDecrypter(5425561626556952653L).setKey(-6494620781361454108L);
    SimpleLongDecrypter.getCachedDecrypter(3886195992816071889L).setKey(-9089708278327906964L);
    SimpleLongDecrypter.getCachedDecrypter(7821800698480699850L).setKey(5303451315549124476L);
    SimpleLongDecrypter.getCachedDecrypter(6875889239214488886L).setKey(-9089592825381868463L);
    SimpleLongDecrypter.getCachedDecrypter(-9194562158283875119L).setKey(3839679512409078047L);
    SimpleLongDecrypter.getCachedDecrypter(-8876695832378649699L).setKey(7004085173806683119L);
    SimpleLongDecrypter.getCachedDecrypter(-6492348001791940324L).setKey(7814914746551772879L);
    SimpleLongDecrypter.getCachedDecrypter(-4443194776765294263L).setKey(2910727677053643770L);
    SimpleLongDecrypter.getCachedDecrypter(6396529723379056641L).setKey(6165735770995137811L);
    SimpleLongDecrypter.getCachedDecrypter(-6236827486023344798L).setKey(-6663170822625004252L);
    SimpleLongDecrypter.getCachedDecrypter(6566961187202636660L).setKey(-7027860253299108978L);
    SimpleLongDecrypter.getCachedDecrypter(-6284901867111040501L).setKey(269773722422686988L);
    SimpleLongDecrypter.getCachedDecrypter(-4080762775763887452L).setKey(1588908053067955560L);
    SimpleLongDecrypter.getCachedDecrypter(8232945499780286862L).setKey(-8636989002333433378L);
    SimpleLongDecrypter.getCachedDecrypter(1040414308224927113L).setKey(-7039333939060079909L);
    SimpleLongDecrypter.getCachedDecrypter(6468232793374830649L).setKey(-4257579197762763890L);
    SimpleLongDecrypter.getCachedDecrypter(4312995677015793946L).setKey(1359607203844910961L);
    SimpleLongDecrypter.getCachedDecrypter(6076504612957138538L).setKey(6840460635959329516L);
    SimpleLongDecrypter.getCachedDecrypter(-755434027840721154L).setKey(956732614470042017L);
    SimpleLongDecrypter.getCachedDecrypter(4010543767222207949L).setKey(-4538639624725322258L);
    SimpleLongDecrypter.getCachedDecrypter(2381077128078765175L).setKey(5803035741013282126L);
    SimpleLongDecrypter.getCachedDecrypter(-4511574746930861559L).setKey(-7029090780453659500L);
    SimpleLongDecrypter.getCachedDecrypter(-8399822066866052335L).setKey(-8989214860137705611L);
    SimpleLongDecrypter.getCachedDecrypter(-5541282928550769755L).setKey(3963906748139061998L);
    SimpleLongDecrypter.getCachedDecrypter(1845285265865621153L).setKey(910093670942926199L);
    SimpleLongDecrypter.getCachedDecrypter(6462246897409408418L).setKey(-2686744058277520892L);
    SimpleLongDecrypter.getCachedDecrypter(4417134323344690978L).setKey(3742337681440984585L);
    SimpleLongDecrypter.getCachedDecrypter(9063995937948242194L).setKey(1820989811731484426L);
    SimpleLongDecrypter.getCachedDecrypter(-7592589378891271535L).setKey(-4485646021319581788L);
    SimpleLongDecrypter.getCachedDecrypter(-8403075055776698692L).setKey(-6291056022342697257L);
    SimpleLongDecrypter.getCachedDecrypter(7870693521992625590L).setKey(-4847967952185218446L);
    SimpleLongDecrypter.getCachedDecrypter(6411010144882000759L).setKey(-8559740897871839819L);
    SimpleLongDecrypter.getCachedDecrypter(1655608197477625427L).setKey(2641596413186690809L);
    SimpleLongDecrypter.getCachedDecrypter(2421490504823755073L).setKey(-4127243242611425559L);
    SimpleLongDecrypter.getCachedDecrypter(-926932694206394734L).setKey(-8547912793862211332L);
    SimpleLongDecrypter.getCachedDecrypter(-3035664730697742061L).setKey(7983398819272544532L);
    SimpleLongDecrypter.getCachedDecrypter(-2697721040860348116L).setKey(-3385854312992394390L);
    SimpleLongDecrypter.getCachedDecrypter(-5804346182067363578L).setKey(6402741130496624462L);
    SimpleLongDecrypter.getCachedDecrypter(-1082882552953889048L).setKey(-3108323842088619619L);
    SimpleLongDecrypter.getCachedDecrypter(1112857291425017313L).setKey(-5105572472645567035L);
    SimpleLongDecrypter.getCachedDecrypter(2199152616306975776L).setKey(-4068136508591089588L);
    SimpleLongDecrypter.getCachedDecrypter(7718332663798989649L).setKey(-2001013353804913076L);
    SimpleLongDecrypter.getCachedDecrypter(2210500143247915740L).setKey(-7627859552649817202L);
    SimpleLongDecrypter.getCachedDecrypter(2372902128633383783L).setKey(-46903358585155005L);
    SimpleLongDecrypter.getCachedDecrypter(-884686823001898062L).setKey(3517974750135863379L);
    SimpleLongDecrypter.getCachedDecrypter(5071105958124238334L).setKey(-5998786049080560897L);
    SimpleLongDecrypter.getCachedDecrypter(5295682040041156292L).setKey(8066568606390806871L);
    SimpleLongDecrypter.getCachedDecrypter(2049622617304318385L).setKey(1055310318991648540L);
    SimpleLongDecrypter.getCachedDecrypter(-1233459486293112933L).setKey(7824513275893960216L);
    SimpleLongDecrypter.getCachedDecrypter(-6974505110501072546L).setKey(5558815172170985524L);
    SimpleLongDecrypter.getCachedDecrypter(-4905795988123833722L).setKey(-6187363678131597249L);
    SimpleLongDecrypter.getCachedDecrypter(-2635030966957309070L).setKey(-4701446948836611410L);
    SimpleLongDecrypter.getCachedDecrypter(7932395262870543777L).setKey(-7430779967103100791L);
    SimpleLongDecrypter.getCachedDecrypter(8809329674644065381L).setKey(2277583851565714605L);
    SimpleLongDecrypter.getCachedDecrypter(-4681246297645209152L).setKey(3399565646411300966L);
    SimpleLongDecrypter.getCachedDecrypter(-2072355512435020000L).setKey(-747130619176532124L);
    SimpleLongDecrypter.getCachedDecrypter(-3793328488992891175L).setKey(-3807575941425465520L);
    SimpleLongDecrypter.getCachedDecrypter(5169963922636973259L).setKey(12143414794215200L);
    SimpleLongDecrypter.getCachedDecrypter(3373524249775982177L).setKey(7552378080220011833L);
    SimpleLongDecrypter.getCachedDecrypter(6428877910621204263L).setKey(-4785170029093271573L);
    SimpleLongDecrypter.getCachedDecrypter(5651582456464419955L).setKey(-294816742370081920L);
    SimpleLongDecrypter.getCachedDecrypter(-9176678657291839078L).setKey(-5953266836974169840L);
    SimpleLongDecrypter.getCachedDecrypter(1538008579306470285L).setKey(-1433656204360288002L);
    SimpleLongDecrypter.getCachedDecrypter(4480115463606167120L).setKey(8767048141574926581L);
    SimpleLongDecrypter.getCachedDecrypter(-5731293901856657786L).setKey(-663129145856064872L);
    SimpleLongDecrypter.getCachedDecrypter(8336224796534634643L).setKey(-1131933249930277081L);
    SimpleLongDecrypter.getCachedDecrypter(-1535088463693284447L).setKey(622363412762923977L);
    SimpleLongDecrypter.getCachedDecrypter(7419346413017907918L).setKey(-3293842723191222585L);
    SimpleLongDecrypter.getCachedDecrypter(2933741551525469605L).setKey(3834548909850754093L);
    SimpleLongDecrypter.getCachedDecrypter(-6075518333120751310L).setKey(-3232563041373393541L);
    SimpleLongDecrypter.getCachedDecrypter(408676539959910573L).setKey(8986475119606999608L);
    SimpleLongDecrypter.getCachedDecrypter(-3877574793749593026L).setKey(8600393427693055067L);
    SimpleLongDecrypter.getCachedDecrypter(-4846778859975766465L).setKey(-7747110317066423519L);
    SimpleLongDecrypter.getCachedDecrypter(-1159201591969283644L).setKey(-5445075909910378680L);
    SimpleLongDecrypter.getCachedDecrypter(4427109547073299515L).setKey(2140773358560608504L);
    SimpleLongDecrypter.getCachedDecrypter(3812451448245540120L).setKey(8912948440946833285L);
    SimpleLongDecrypter.getCachedDecrypter(4840870720231398981L).setKey(-3593216981417775196L);
    SimpleLongDecrypter.getCachedDecrypter(-8018981153987415812L).setKey(-5231998083267928344L);
    SimpleLongDecrypter.getCachedDecrypter(-7855370048175430949L).setKey(-3092141079899087802L);
    SimpleLongDecrypter.getCachedDecrypter(4176258034898269404L).setKey(5770485299527762178L);
    SimpleLongDecrypter.getCachedDecrypter(-1643443145228999436L).setKey(797463401694080086L);
    SimpleLongDecrypter.getCachedDecrypter(-127640603051631744L).setKey(249542920820664970L);
    SimpleLongDecrypter.getCachedDecrypter(-3039354916056429684L).setKey(-5967453104680934426L);
    SimpleLongDecrypter.getCachedDecrypter(359220759996767876L).setKey(3370348464833080637L);
    SimpleLongDecrypter.getCachedDecrypter(501702791910950173L).setKey(163907423549141125L);
    SimpleLongDecrypter.getCachedDecrypter(-8351484038295654227L).setKey(-4025612593385404301L);
    SimpleLongDecrypter.getCachedDecrypter(-1964183598985769939L).setKey(411979328228256891L);
    SimpleLongDecrypter.getCachedDecrypter(8284954302970426961L).setKey(4564351820050000415L);
    SimpleLongDecrypter.getCachedDecrypter(-7376009843670746216L).setKey(2402537422769344737L);
    SimpleLongDecrypter.getCachedDecrypter(-7685279077175559692L).setKey(2180762765637350838L);
    SimpleLongDecrypter.getCachedDecrypter(5145171455240678090L).setKey(-9108826966711114997L);
    SimpleLongDecrypter.getCachedDecrypter(-2893509884893299213L).setKey(-7543885711686703615L);
    SimpleLongDecrypter.getCachedDecrypter(-1190739854458198428L).setKey(-6975168008345286111L);
    SimpleLongDecrypter.getCachedDecrypter(-8520336449109017693L).setKey(-51641849365052932L);
    SimpleLongDecrypter.getCachedDecrypter(-4108885761162867100L).setKey(100956862675581815L);
    SimpleLongDecrypter.getCachedDecrypter(1562940260491982002L).setKey(-1651310101491838764L);
    SimpleLongDecrypter.getCachedDecrypter(-6439476408148614787L).setKey(-7805414810400871568L);
    SimpleLongDecrypter.getCachedDecrypter(8172784860382542701L).setKey(-6737901041146833416L);
    SimpleLongDecrypter.getCachedDecrypter(1573980181729197875L).setKey(-1210537226754819496L);
    SimpleLongDecrypter.getCachedDecrypter(6070175838425417951L).setKey(6298179822341515108L);
    SimpleLongDecrypter.getCachedDecrypter(6868550184200332147L).setKey(-1849835469544820327L);
    SimpleLongDecrypter.getCachedDecrypter(5080599972822719759L).setKey(-426610078051192163L);
    SimpleLongDecrypter.getCachedDecrypter(4786999746502386095L).setKey(-7518269483203742603L);
    SimpleLongDecrypter.getCachedDecrypter(-8920631767994130449L).setKey(-8459405991824339425L);
    SimpleLongDecrypter.getCachedDecrypter(-5707296564122575084L).setKey(1698036868601676699L);
    SimpleLongDecrypter.getCachedDecrypter(-4096446447456724046L).setKey(-36526326812840579L);
    SimpleLongDecrypter.getCachedDecrypter(-755375741544051907L).setKey(-1551958970833467862L);
    SimpleLongDecrypter.getCachedDecrypter(-2863327394034554859L).setKey(7400864207545143907L);
    SimpleLongDecrypter.getCachedDecrypter(-1537016236611366914L).setKey(-1536112437988511379L);
    SimpleLongDecrypter.getCachedDecrypter(-6583335753886652215L).setKey(-4832391137484138903L);
    SimpleLongDecrypter.getCachedDecrypter(-7159038919359916439L).setKey(3710398507625424608L);
    SimpleLongDecrypter.getCachedDecrypter(-7469435572233102543L).setKey(4845257404898684140L);
    SimpleLongDecrypter.getCachedDecrypter(-6123943533877895909L).setKey(-6502899197218424284L);
    SimpleLongDecrypter.getCachedDecrypter(-1493179252342044652L).setKey(-5030344000262533598L);
    SimpleLongDecrypter.getCachedDecrypter(2424119025980118162L).setKey(-9207786730797799012L);
    SimpleLongDecrypter.getCachedDecrypter(7732607722046907678L).setKey(8725733979988749733L);
    SimpleLongDecrypter.getCachedDecrypter(3895693713420305943L).setKey(-4889187435292506756L);
    SimpleLongDecrypter.getCachedDecrypter(6537000709347488852L).setKey(6624061872134458760L);
    SimpleLongDecrypter.getCachedDecrypter(-4979123782895317574L).setKey(-414309661443291637L);
    SimpleLongDecrypter.getCachedDecrypter(904077477839559156L).setKey(-7823538866652803985L);
    SimpleLongDecrypter.getCachedDecrypter(8862277063817607944L).setKey(-2845078297615425542L);
    SimpleLongDecrypter.getCachedDecrypter(-2409121222446195748L).setKey(-582043506198503322L);
    SimpleLongDecrypter.getCachedDecrypter(-2221616430345284721L).setKey(-7249999593604149976L);
    SimpleLongDecrypter.getCachedDecrypter(3416671676411630177L).setKey(-1333131975541866184L);
    SimpleLongDecrypter.getCachedDecrypter(2222899331485059873L).setKey(-2806070992046173478L);
    SimpleLongDecrypter.getCachedDecrypter(8427927396212620125L).setKey(-5152687137505893096L);
    SimpleLongDecrypter.getCachedDecrypter(8632823391019161055L).setKey(-8961055062510060580L);
    SimpleLongDecrypter.getCachedDecrypter(451709396012492270L).setKey(-1440477269648596841L);
    SimpleLongDecrypter.getCachedDecrypter(2599618037841700160L).setKey(-7100054497819393329L);
    SimpleLongDecrypter.getCachedDecrypter(-2365069657831159840L).setKey(-9053629108691360339L);
    SimpleLongDecrypter.getCachedDecrypter(-2289962441916204170L).setKey(6452225907307397568L);
    SimpleLongDecrypter.getCachedDecrypter(-4983788173831778289L).setKey(1663516060918635192L);
    SimpleLongDecrypter.getCachedDecrypter(-2887950265480072465L).setKey(6679879741047200740L);
    SimpleLongDecrypter.getCachedDecrypter(1929097426880982595L).setKey(8573106988944157347L);
    SimpleLongDecrypter.getCachedDecrypter(-2899245421729811714L).setKey(-399710071923785817L);
    SimpleLongDecrypter.getCachedDecrypter(5649315497809223454L).setKey(-1420025851479416892L);
    SimpleLongDecrypter.getCachedDecrypter(-6290524211650047230L).setKey(2907854199274990236L);
    SimpleLongDecrypter.getCachedDecrypter(4603789890977950864L).setKey(9064147064426499710L);
    SimpleLongDecrypter.getCachedDecrypter(2890636738118296945L).setKey(1258022009186105717L);
    SimpleLongDecrypter.getCachedDecrypter(-4501565245164148153L).setKey(4886000795372280238L);
    SimpleLongDecrypter.getCachedDecrypter(5798711220691100095L).setKey(6333290853067761144L);
    SimpleLongDecrypter.getCachedDecrypter(-3295972549289996406L).setKey(-3430254648944612538L);
    SimpleLongDecrypter.getCachedDecrypter(4752607582376704645L).setKey(6597300429970288986L);
    SimpleLongDecrypter.getCachedDecrypter(4988001084467412691L).setKey(7725863985634495853L);
    SimpleLongDecrypter.getCachedDecrypter(-2138112881857579362L).setKey(-2806599649027059265L);
    SimpleLongDecrypter.getCachedDecrypter(9175190901484709137L).setKey(-2716210300589271754L);
    SimpleLongDecrypter.getCachedDecrypter(888138362294299186L).setKey(-8498650860153517730L);
    SimpleLongDecrypter.getCachedDecrypter(735707699692774949L).setKey(4827073169134958018L);
    SimpleLongDecrypter.getCachedDecrypter(1318171398019829286L).setKey(2034890820869219376L);
    SimpleLongDecrypter.getCachedDecrypter(8812614310127049023L).setKey(2453646568108479727L);
    SimpleLongDecrypter.getCachedDecrypter(8297397481059481511L).setKey(-8863364482411877576L);
    SimpleLongDecrypter.getCachedDecrypter(7470439854761861850L).setKey(8009844027659244009L);
    SimpleLongDecrypter.getCachedDecrypter(3504080083387433859L).setKey(1950470806844378261L);
    SimpleLongDecrypter.getCachedDecrypter(-3708451777626252724L).setKey(7038473280770736499L);
    SimpleLongDecrypter.getCachedDecrypter(-2627812975015806119L).setKey(-780662190746346152L);
    SimpleLongDecrypter.getCachedDecrypter(163058306752727777L).setKey(4399970377099358519L);
    SimpleLongDecrypter.getCachedDecrypter(-2621305211317220855L).setKey(-8338437676716717608L);
    SimpleLongDecrypter.getCachedDecrypter(1297993884101108812L).setKey(6378395834111427234L);
    SimpleLongDecrypter.getCachedDecrypter(3593437967233771151L).setKey(8522515654069213993L);
    SimpleLongDecrypter.getCachedDecrypter(-7341370754945759408L).setKey(-1566170876315540300L);
    SimpleLongDecrypter.getCachedDecrypter(5406608498455424983L).setKey(-8994346090762608889L);
    SimpleLongDecrypter.getCachedDecrypter(-8218622060224332628L).setKey(-5447859367059125752L);
    SimpleLongDecrypter.getCachedDecrypter(-976283156714156863L).setKey(-5651026617450771663L);
    SimpleLongDecrypter.getCachedDecrypter(6767386477204842154L).setKey(-4670402239881012689L);
    SimpleLongDecrypter.getCachedDecrypter(-1289154608330662295L).setKey(7444528311764717661L);
    SimpleLongDecrypter.getCachedDecrypter(3691534154988820644L).setKey(-1296773750226999978L);
    SimpleLongDecrypter.getCachedDecrypter(-7785735362312587534L).setKey(-7495687207204101229L);
    SimpleLongDecrypter.getCachedDecrypter(2274036668710750423L).setKey(1005386615478125507L);
    SimpleLongDecrypter.getCachedDecrypter(6827643188359302443L).setKey(-1135694867437007267L);
    SimpleLongDecrypter.getCachedDecrypter(6271159678409443420L).setKey(5462167057988343399L);
    SimpleLongDecrypter.getCachedDecrypter(-4291321251443244794L).setKey(5256443083860993777L);
    SimpleLongDecrypter.getCachedDecrypter(5454073591614462548L).setKey(6039164277700703810L);
    SimpleLongDecrypter.getCachedDecrypter(5442815033585389152L).setKey(-6114416995504822368L);
    SimpleLongDecrypter.getCachedDecrypter(-6361424158552255530L).setKey(8912212021900882164L);
    SimpleLongDecrypter.getCachedDecrypter(-5834160701196820155L).setKey(5449604344814456756L);
    SimpleLongDecrypter.getCachedDecrypter(584237768040432510L).setKey(-7619382978784269601L);
    SimpleLongDecrypter.getCachedDecrypter(-1883817040652348665L).setKey(-575903718357673286L);
    SimpleLongDecrypter.getCachedDecrypter(-6106970829092138127L).setKey(1581259832790387046L);
    SimpleLongDecrypter.getCachedDecrypter(-4905250534538872502L).setKey(-6595927366028098271L);
    SimpleLongDecrypter.getCachedDecrypter(1546071430750274149L).setKey(-1077482295049983519L);
    SimpleLongDecrypter.getCachedDecrypter(-1918022825025335126L).setKey(-875311916100729088L);
    SimpleLongDecrypter.getCachedDecrypter(-4414036206871071086L).setKey(-3601749095234796598L);
    SimpleLongDecrypter.getCachedDecrypter(6365279892319123852L).setKey(-6908986945250052683L);
    SimpleLongDecrypter.getCachedDecrypter(5913714281943489097L).setKey(2890311399455564839L);
    SimpleLongDecrypter.getCachedDecrypter(325552484633841819L).setKey(262599111965138466L);
    SimpleLongDecrypter.getCachedDecrypter(7061436985445733451L).setKey(-20613689238962774L);
    SimpleLongDecrypter.getCachedDecrypter(3308032120243784702L).setKey(-2724516208206667505L);
    SimpleLongDecrypter.getCachedDecrypter(8519423355785793659L).setKey(1085977584225898340L);
    SimpleLongDecrypter.getCachedDecrypter(2343810709093648689L).setKey(5565412469076323750L);
    SimpleLongDecrypter.getCachedDecrypter(809112921409130388L).setKey(-6914697736417663251L);
    SimpleLongDecrypter.getCachedDecrypter(6736553558180563988L).setKey(9171849946587631499L);
    SimpleLongDecrypter.getCachedDecrypter(-7174047923056453960L).setKey(-2033857768924388826L);
    SimpleLongDecrypter.getCachedDecrypter(-8118381897477785305L).setKey(-1354567376861031144L);
    SimpleLongDecrypter.getCachedDecrypter(4596683759956111043L).setKey(7358225571007956987L);
    SimpleLongDecrypter.getCachedDecrypter(6090196190407523134L).setKey(-595981419073830578L);
    SimpleLongDecrypter.getCachedDecrypter(1945585616807457053L).setKey(-1558350019646575338L);
    SimpleLongDecrypter.getCachedDecrypter(8115684641289178706L).setKey(2582374148989639436L);
    SimpleLongDecrypter.getCachedDecrypter(-6043510010129764657L).setKey(7744564653349428776L);
    SimpleLongDecrypter.getCachedDecrypter(8953456181979649140L).setKey(-4795733194828335516L);
    SimpleLongDecrypter.getCachedDecrypter(-779557832169052213L).setKey(-4613013078691554591L);
    SimpleLongDecrypter.getCachedDecrypter(-8028890750815341112L).setKey(1510268471491600448L);
    SimpleLongDecrypter.getCachedDecrypter(-6599635743562645938L).setKey(7082779441729487601L);
    SimpleLongDecrypter.getCachedDecrypter(6303154655886984808L).setKey(-2603229809868446481L);
    SimpleLongDecrypter.getCachedDecrypter(6369875111270074581L).setKey(-2027255661464929375L);
    SimpleLongDecrypter.getCachedDecrypter(-5363221949032409450L).setKey(-3437958922090780056L);
    SimpleLongDecrypter.getCachedDecrypter(2460419919605200252L).setKey(-4648921145586776465L);
    SimpleLongDecrypter.getCachedDecrypter(5434777602218104443L).setKey(-5798533304771906907L);
    SimpleLongDecrypter.getCachedDecrypter(-2233606684578526797L).setKey(-3763939947234369966L);
    SimpleLongDecrypter.getCachedDecrypter(6308347939291995835L).setKey(7496936509384470331L);
    SimpleLongDecrypter.getCachedDecrypter(-8529905328678685367L).setKey(9185262356042353150L);
    SimpleLongDecrypter.getCachedDecrypter(3451112116632409027L).setKey(5879555502382150096L);
    SimpleLongDecrypter.getCachedDecrypter(-1666856654131134417L).setKey(2809514200547281661L);
    SimpleLongDecrypter.getCachedDecrypter(2902895224452340564L).setKey(-7182853624396882060L);
    SimpleLongDecrypter.getCachedDecrypter(-594638107599310245L).setKey(-702940019692218404L);
    SimpleLongDecrypter.getCachedDecrypter(166952504140761082L).setKey(3778463973781624237L);
    SimpleLongDecrypter.getCachedDecrypter(5594790203020303199L).setKey(1289526191179287951L);
    SimpleLongDecrypter.getCachedDecrypter(6092443694525230006L).setKey(1122415713594310385L);
    SimpleLongDecrypter.getCachedDecrypter(8826437791384391149L).setKey(4273299204133961234L);
    SimpleLongDecrypter.getCachedDecrypter(6398416945217942826L).setKey(4207426601536163599L);
    SimpleLongDecrypter.getCachedDecrypter(-6230145770719912932L).setKey(799298810026266789L);
    SimpleLongDecrypter.getCachedDecrypter(-3655003549150894501L).setKey(-7337417005264120158L);
    SimpleLongDecrypter.getCachedDecrypter(3596645359104040662L).setKey(4754915309609809649L);
    SimpleLongDecrypter.getCachedDecrypter(-1086243472940995864L).setKey(-5900966576301033204L);
    SimpleLongDecrypter.getCachedDecrypter(-4732024078944923311L).setKey(-8097600403050227438L);
    SimpleLongDecrypter.getCachedDecrypter(-5853068726447408053L).setKey(-1915068323972944722L);
    SimpleLongDecrypter.getCachedDecrypter(3850946174669505176L).setKey(-797998237440338464L);
    SimpleLongDecrypter.getCachedDecrypter(4281270001727434630L).setKey(703027750017157580L);
    SimpleLongDecrypter.getCachedDecrypter(-5655370417592776280L).setKey(-4464092640688870503L);
    SimpleLongDecrypter.getCachedDecrypter(-7678734234483440624L).setKey(-8495770254580479529L);
    SimpleLongDecrypter.getCachedDecrypter(820137591949463018L).setKey(-5305116919252405686L);
    SimpleLongDecrypter.getCachedDecrypter(354107100521717484L).setKey(-2978821922832384211L);
    SimpleLongDecrypter.getCachedDecrypter(5883485912526208804L).setKey(-3341615156110662361L);
    SimpleLongDecrypter.getCachedDecrypter(1363079898500689398L).setKey(-7182836824557277233L);
    SimpleLongDecrypter.getCachedDecrypter(763553870353473481L).setKey(-6976037711291104576L);
    SimpleLongDecrypter.getCachedDecrypter(-4581822805159337943L).setKey(842570124617100760L);
    SimpleLongDecrypter.getCachedDecrypter(-7554570115783397943L).setKey(92400705191205920L);
    SimpleLongDecrypter.getCachedDecrypter(-2359370246151854603L).setKey(-1207339949695130145L);
    SimpleLongDecrypter.getCachedDecrypter(-2921457917609803901L).setKey(-6334418659988173463L);
    SimpleLongDecrypter.getCachedDecrypter(6698313774021496879L).setKey(9093657375281836952L);
    SimpleLongDecrypter.getCachedDecrypter(2572536848615978189L).setKey(-8126151261673373471L);
    SimpleLongDecrypter.getCachedDecrypter(-8900851253759639781L).setKey(-8516479762584029131L);
    SimpleLongDecrypter.getCachedDecrypter(5264724048029029803L).setKey(-5668432723300163648L);
    SimpleLongDecrypter.getCachedDecrypter(-8609155769543066201L).setKey(-1833421338681779734L);
    SimpleLongDecrypter.getCachedDecrypter(-8316259936548822317L).setKey(-5501728033228467969L);
    SimpleLongDecrypter.getCachedDecrypter(2866743489798560366L).setKey(-714716488356254291L);
    SimpleLongDecrypter.getCachedDecrypter(3915609423946946110L).setKey(-7348791404771729181L);
    SimpleLongDecrypter.getCachedDecrypter(-3852815183546571978L).setKey(-5092982670550614622L);
    SimpleLongDecrypter.getCachedDecrypter(8711043115694317154L).setKey(1044340463972250361L);
    SimpleLongDecrypter.getCachedDecrypter(5023396092629057202L).setKey(-5881990132030728593L);
    SimpleLongDecrypter.getCachedDecrypter(7680081175224897115L).setKey(2487219127296618073L);
    SimpleLongDecrypter.getCachedDecrypter(-7882172192517585807L).setKey(-5851683080050863803L);
    SimpleLongDecrypter.getCachedDecrypter(9207914317635551425L).setKey(4427369503514914175L);
    SimpleLongDecrypter.getCachedDecrypter(1687460393217661700L).setKey(-2044136586626931996L);
    SimpleLongDecrypter.getCachedDecrypter(-1128996678733268107L).setKey(-8221463861919860707L);
    SimpleLongDecrypter.getCachedDecrypter(1227647384374047116L).setKey(-5893078586142917883L);
    SimpleLongDecrypter.getCachedDecrypter(5500239905784273107L).setKey(-1718743757037849624L);
    SimpleLongDecrypter.getCachedDecrypter(6537134838241311645L).setKey(-72248177333021804L);
    SimpleLongDecrypter.getCachedDecrypter(7463618689293348366L).setKey(7625848727137122883L);
    SimpleLongDecrypter.getCachedDecrypter(2936833663525107781L).setKey(-8627330337221118198L);
    SimpleLongDecrypter.getCachedDecrypter(-5232993446441342972L).setKey(737878678157022364L);
    SimpleLongDecrypter.getCachedDecrypter(-9029473139822572694L).setKey(2519891012346377604L);
    SimpleLongDecrypter.getCachedDecrypter(-4503676040007695910L).setKey(4978034748702037509L);
    SimpleLongDecrypter.getCachedDecrypter(-4674304416455827993L).setKey(3221349535402744972L);
    SimpleLongDecrypter.getCachedDecrypter(8982377522245505405L).setKey(-3529652310620596876L);
    SimpleLongDecrypter.getCachedDecrypter(5948007592606886255L).setKey(-8779628119918254746L);
    SimpleLongDecrypter.getCachedDecrypter(-7935618996094257082L).setKey(-6080969070247268314L);
    SimpleLongDecrypter.getCachedDecrypter(5570246185025275275L).setKey(7914309787471799752L);
    SimpleLongDecrypter.getCachedDecrypter(6436191200845220688L).setKey(7469112655643288840L);
    SimpleLongDecrypter.getCachedDecrypter(-8341785244379023550L).setKey(-4210756206632500079L);
    SimpleLongDecrypter.getCachedDecrypter(-2134041379326950394L).setKey(2991251194564825594L);
    SimpleLongDecrypter.getCachedDecrypter(4721095900471678578L).setKey(-8520178170671559678L);
    SimpleLongDecrypter.getCachedDecrypter(8446111474270490455L).setKey(-6959757460746127888L);
    SimpleLongDecrypter.getCachedDecrypter(997957384136369101L).setKey(8543486924188738528L);
    SimpleLongDecrypter.getCachedDecrypter(-660616488852506193L).setKey(7126131745266764026L);
    SimpleLongDecrypter.getCachedDecrypter(-3608379651159953532L).setKey(7456141658062544518L);
    SimpleLongDecrypter.getCachedDecrypter(-8957618341825712324L).setKey(5472632429522914509L);
    SimpleLongDecrypter.getCachedDecrypter(736275967068741835L).setKey(-595458958461975751L);
    SimpleLongDecrypter.getCachedDecrypter(-3023363938460094996L).setKey(6664103185166238084L);
    SimpleLongDecrypter.getCachedDecrypter(-7788562506699970436L).setKey(7394565787448193054L);
    SimpleLongDecrypter.getCachedDecrypter(371855841752901933L).setKey(-1111599365605353585L);
    SimpleLongDecrypter.getCachedDecrypter(-6047287966175679614L).setKey(229116005659763091L);
    SimpleLongDecrypter.getCachedDecrypter(-929765406743488385L).setKey(-5898995886990956202L);
    SimpleLongDecrypter.getCachedDecrypter(-2099876938048143623L).setKey(8873769369975868901L);
    SimpleLongDecrypter.getCachedDecrypter(6336372491099001934L).setKey(-1538747475020882039L);
    SimpleLongDecrypter.getCachedDecrypter(-929826958199413159L).setKey(-6894600597296757322L);
    SimpleLongDecrypter.getCachedDecrypter(5560217998646627473L).setKey(-2825873802757856732L);
    SimpleLongDecrypter.getCachedDecrypter(-1271690465984234201L).setKey(-5222115264722215837L);
    SimpleLongDecrypter.getCachedDecrypter(3858315677835841465L).setKey(8169159314888418853L);
    SimpleLongDecrypter.getCachedDecrypter(2009522020796409484L).setKey(-5384701992489290630L);
    SimpleLongDecrypter.getCachedDecrypter(7821848370853183936L).setKey(8401864730529492816L);
    SimpleLongDecrypter.getCachedDecrypter(-9162905054229068528L).setKey(924744612203458146L);
    SimpleLongDecrypter.getCachedDecrypter(-7606696020395649039L).setKey(-6904039418593831163L);
    SimpleLongDecrypter.getCachedDecrypter(-3317647089676892251L).setKey(-5096982069728753160L);
    SimpleLongDecrypter.getCachedDecrypter(8072213628999174296L).setKey(-3293631797371010716L);
    SimpleLongDecrypter.getCachedDecrypter(-2132619735810711404L).setKey(-5715296733354307854L);
    SimpleLongDecrypter.getCachedDecrypter(-1118598514820346968L).setKey(4509617847104569882L);
    SimpleLongDecrypter.getCachedDecrypter(8282282808826297394L).setKey(-2804699515937725229L);
    SimpleLongDecrypter.getCachedDecrypter(6744848812260339471L).setKey(7788858074854832511L);
    SimpleLongDecrypter.getCachedDecrypter(2687226290281500426L).setKey(7235752837390850044L);
    SimpleLongDecrypter.getCachedDecrypter(-2807937675251300193L).setKey(2905715224933726507L);
    SimpleLongDecrypter.getCachedDecrypter(-2100823043566479215L).setKey(-6754634102445857179L);
    SimpleLongDecrypter.getCachedDecrypter(9139029527235986091L).setKey(5254342796466830170L);
    SimpleLongDecrypter.getCachedDecrypter(-3191208785450964970L).setKey(-7214196011960152244L);
    SimpleLongDecrypter.getCachedDecrypter(7522667832135433334L).setKey(124623864760169744L);
    SimpleLongDecrypter.getCachedDecrypter(8940557864985989798L).setKey(-9216825375027223599L);
    SimpleLongDecrypter.getCachedDecrypter(157247244631627075L).setKey(2805159863108156233L);
    SimpleLongDecrypter.getCachedDecrypter(1063214025768646268L).setKey(-4065649744211407514L);
    SimpleLongDecrypter.getCachedDecrypter(8333855641932557059L).setKey(8695728912850102484L);
    SimpleLongDecrypter.getCachedDecrypter(-5342133634179606282L).setKey(7052350244056337763L);
    SimpleLongDecrypter.getCachedDecrypter(-8712863329992225833L).setKey(-2703330593637491058L);
    SimpleLongDecrypter.getCachedDecrypter(-8133732589857883362L).setKey(-5219948496588880161L);
    SimpleLongDecrypter.getCachedDecrypter(8715854668022991580L).setKey(-1751022756191224299L);
    SimpleLongDecrypter.getCachedDecrypter(1240508094931232641L).setKey(-1420985706121828848L);
    SimpleLongDecrypter.getCachedDecrypter(8144801570678487371L).setKey(-6000941888117735253L);
    SimpleLongDecrypter.getCachedDecrypter(-8150052973971170620L).setKey(1788214549325612818L);
    SimpleLongDecrypter.getCachedDecrypter(7971920234215362453L).setKey(2537916489614379483L);
    SimpleLongDecrypter.getCachedDecrypter(7276738536916642521L).setKey(-6032352151046461789L);
    SimpleLongDecrypter.getCachedDecrypter(9122993591801521523L).setKey(-8643790418762541507L);
    SimpleLongDecrypter.getCachedDecrypter(-2268540829198127870L).setKey(-3043746319131673564L);
    SimpleLongDecrypter.getCachedDecrypter(3519853106117627730L).setKey(8688708840889573627L);
    SimpleLongDecrypter.getCachedDecrypter(-3897640154732940623L).setKey(-6558798375092523038L);
    SimpleLongDecrypter.getCachedDecrypter(-1402751009133107743L).setKey(-5514190698821215035L);
    SimpleLongDecrypter.getCachedDecrypter(-4255519287356249844L).setKey(-7389839337239616628L);
    SimpleLongDecrypter.getCachedDecrypter(1330333924118524521L).setKey(-5035997142681650601L);
    SimpleLongDecrypter.getCachedDecrypter(-3156016966467047090L).setKey(682957285431293316L);
    SimpleLongDecrypter.getCachedDecrypter(2474167843637955245L).setKey(39293981188937376L);
    SimpleLongDecrypter.getCachedDecrypter(-3779636218402913222L).setKey(-322414630290340633L);
    SimpleLongDecrypter.getCachedDecrypter(2613551839235348078L).setKey(5006358622055487718L);
    SimpleLongDecrypter.getCachedDecrypter(7924352279662035718L).setKey(6154938867000317484L);
    SimpleLongDecrypter.getCachedDecrypter(9093817325508005580L).setKey(-3089989283904034303L);
    SimpleLongDecrypter.getCachedDecrypter(7883180343635824542L).setKey(-6929547809608789008L);
    SimpleLongDecrypter.getCachedDecrypter(6902790515623202510L).setKey(-5004020300017086994L);
    SimpleLongDecrypter.getCachedDecrypter(2319573589788829691L).setKey(-5814396945964894910L);
    SimpleLongDecrypter.getCachedDecrypter(-4670581985096259637L).setKey(-6900825507966998989L);
    SimpleLongDecrypter.getCachedDecrypter(-7784452391255854542L).setKey(4246129867032878660L);
    SimpleLongDecrypter.getCachedDecrypter(-5333827065742655448L).setKey(3470834829249034106L);
    SimpleLongDecrypter.getCachedDecrypter(1610050673748753535L).setKey(-5159972703114938323L);
    SimpleLongDecrypter.getCachedDecrypter(-7529963838724795772L).setKey(5160520523889457789L);
    SimpleLongDecrypter.getCachedDecrypter(-7533885818055878419L).setKey(-6619992740101513161L);
    SimpleLongDecrypter.getCachedDecrypter(-5237798374525000199L).setKey(-869082348668489391L);
    SimpleLongDecrypter.getCachedDecrypter(606393409736769L).setKey(505578109534196904L);
    SimpleLongDecrypter.getCachedDecrypter(-7501676734778299610L).setKey(-7468523818706552634L);
    SimpleLongDecrypter.getCachedDecrypter(-8861209658205749210L).setKey(3124221849319211763L);
    SimpleLongDecrypter.getCachedDecrypter(3645263569869729951L).setKey(1592642735177339595L);
    SimpleLongDecrypter.getCachedDecrypter(-5591321789547825081L).setKey(1463701857804214331L);
    SimpleLongDecrypter.getCachedDecrypter(1221806658749589561L).setKey(-3508558860394776234L);
    SimpleLongDecrypter.getCachedDecrypter(1646659966350445288L).setKey(-1029846845644684086L);
    SimpleLongDecrypter.getCachedDecrypter(5967466342335354472L).setKey(-6393698481840342475L);
    SimpleLongDecrypter.getCachedDecrypter(-1771003948323205901L).setKey(8258193045024287586L);
    SimpleLongDecrypter.getCachedDecrypter(4073395144908635004L).setKey(4178740534025917467L);
    SimpleLongDecrypter.getCachedDecrypter(-3698241134135530099L).setKey(-199374678015215429L);
    SimpleLongDecrypter.getCachedDecrypter(-2064452562449779734L).setKey(3516455532117562217L);
    SimpleLongDecrypter.getCachedDecrypter(7921771447412444734L).setKey(-7993551897767015317L);
    SimpleLongDecrypter.getCachedDecrypter(3387256442297706662L).setKey(4612287829703127980L);
    SimpleLongDecrypter.getCachedDecrypter(-8217197482488450351L).setKey(1928930985400961824L);
    SimpleLongDecrypter.getCachedDecrypter(-5401521411627609307L).setKey(-6982070123953930953L);
    SimpleLongDecrypter.getCachedDecrypter(-6427927862512047760L).setKey(3179481229097032452L);
    SimpleLongDecrypter.getCachedDecrypter(-293360658507858685L).setKey(-3863867143432355689L);
    SimpleLongDecrypter.getCachedDecrypter(-9116591398507077556L).setKey(639399768352921752L);
    SimpleLongDecrypter.getCachedDecrypter(294507281225237439L).setKey(8756790087634177010L);
    SimpleLongDecrypter.getCachedDecrypter(1423827850916953634L).setKey(2823902827873060010L);
    SimpleLongDecrypter.getCachedDecrypter(-4126778708422487837L).setKey(-7908437475799253434L);
    SimpleLongDecrypter.getCachedDecrypter(-7078102108315381708L).setKey(-8545817390670959081L);
    SimpleLongDecrypter.getCachedDecrypter(8810771851679632908L).setKey(-8028839451604475770L);
    SimpleLongDecrypter.getCachedDecrypter(-55794642380743449L).setKey(-8276806736412601609L);
    SimpleLongDecrypter.getCachedDecrypter(288529206462702042L).setKey(-2576113904518592443L);
    SimpleLongDecrypter.getCachedDecrypter(8832203191425936772L).setKey(8963695742815285250L);
    SimpleLongDecrypter.getCachedDecrypter(-8210708616051419517L).setKey(4793564011928694178L);
    SimpleLongDecrypter.getCachedDecrypter(4139144116572089251L).setKey(-8301732837146898181L);
    SimpleLongDecrypter.getCachedDecrypter(4094631468043626968L).setKey(1746159160168006573L);
    SimpleLongDecrypter.getCachedDecrypter(4450014453728482651L).setKey(5744227775844169755L);
    SimpleLongDecrypter.getCachedDecrypter(5382979701730129513L).setKey(3154577986898324143L);
    SimpleLongDecrypter.getCachedDecrypter(-1908316752695168240L).setKey(80490157975627610L);
    SimpleLongDecrypter.getCachedDecrypter(-8392952758979538081L).setKey(-3968668349779868231L);
    SimpleLongDecrypter.getCachedDecrypter(902327503021203672L).setKey(541489388367812948L);
    SimpleLongDecrypter.getCachedDecrypter(4650971867416353761L).setKey(3602753650198432042L);
    SimpleLongDecrypter.getCachedDecrypter(-3874167926788085206L).setKey(-1673222678755932202L);
    SimpleLongDecrypter.getCachedDecrypter(-4903135116036896397L).setKey(-2397734136251816361L);
    SimpleLongDecrypter.getCachedDecrypter(-7542415568554547154L).setKey(4525001232325151042L);
    SimpleLongDecrypter.getCachedDecrypter(-4906663118633953263L).setKey(5699363593316028538L);
    SimpleLongDecrypter.getCachedDecrypter(1745448414383010517L).setKey(3307745863865706191L);
    SimpleLongDecrypter.getCachedDecrypter(6463706038254629088L).setKey(448848445141316732L);
    SimpleLongDecrypter.getCachedDecrypter(7759231360464311253L).setKey(-1211244702830277765L);
    SimpleLongDecrypter.getCachedDecrypter(364235549191944876L).setKey(3231883480623483564L);
    SimpleLongDecrypter.getCachedDecrypter(-2049765071652341818L).setKey(-472012659272429500L);
    SimpleLongDecrypter.getCachedDecrypter(8908081448832048233L).setKey(4184344337734964930L);
    SimpleLongDecrypter.getCachedDecrypter(43809548156404517L).setKey(-4642483578443907462L);
    SimpleLongDecrypter.getCachedDecrypter(1781366541865718887L).setKey(-3799320242787921240L);
    SimpleLongDecrypter.getCachedDecrypter(-1320194970236738644L).setKey(-3630784817043462712L);
    SimpleLongDecrypter.getCachedDecrypter(-7217996964552095014L).setKey(-5110640226439285856L);
    SimpleLongDecrypter.getCachedDecrypter(-8597369478755237230L).setKey(-267697544469951924L);
    SimpleLongDecrypter.getCachedDecrypter(-1357308344625492008L).setKey(-2977734015792301393L);
    SimpleLongDecrypter.getCachedDecrypter(-6067796589072285163L).setKey(-5114204513684497437L);
    SimpleLongDecrypter.getCachedDecrypter(-8618022826715264568L).setKey(4342682168644337718L);
    SimpleLongDecrypter.getCachedDecrypter(6753902620707227688L).setKey(-8544468781611839527L);
    SimpleLongDecrypter.getCachedDecrypter(-3808743731013199381L).setKey(-2997233940994775885L);
    SimpleLongDecrypter.getCachedDecrypter(5734515169326673700L).setKey(7978482640523946903L);
    SimpleLongDecrypter.getCachedDecrypter(1598838842333883040L).setKey(-1834603814679431663L);
    SimpleLongDecrypter.getCachedDecrypter(540910794019638161L).setKey(-6664047288806671355L);
    SimpleLongDecrypter.getCachedDecrypter(4955603443746621341L).setKey(3774558708223773577L);
    SimpleLongDecrypter.getCachedDecrypter(-4325231762284184514L).setKey(-141607658483614702L);
    SimpleLongDecrypter.getCachedDecrypter(-538792015113279572L).setKey(-6388440302850581492L);
    SimpleLongDecrypter.getCachedDecrypter(759464773225650365L).setKey(2806000896007796585L);
    SimpleLongDecrypter.getCachedDecrypter(-3419935207107913297L).setKey(-7651119862025399207L);
    SimpleLongDecrypter.getCachedDecrypter(2937400153834468147L).setKey(4356063510843151080L);
    SimpleLongDecrypter.getCachedDecrypter(-5587475637388524244L).setKey(6508413839932053910L);
    SimpleLongDecrypter.getCachedDecrypter(3037086783247464208L).setKey(-7217356207351716018L);
    SimpleLongDecrypter.getCachedDecrypter(-8809206604520051100L).setKey(-7428676632690995690L);
    SimpleLongDecrypter.getCachedDecrypter(-1052885245678761248L).setKey(-7500254858643611962L);
    SimpleLongDecrypter.getCachedDecrypter(309871678391475313L).setKey(2617917075308556737L);
    SimpleLongDecrypter.getCachedDecrypter(-6740857693173624524L).setKey(6244263938269297434L);
    SimpleLongDecrypter.getCachedDecrypter(4883859690064980479L).setKey(-2163835925228832703L);
    SimpleLongDecrypter.getCachedDecrypter(862973870593039791L).setKey(-4330864096924229764L);
    SimpleLongDecrypter.getCachedDecrypter(5339626927823598391L).setKey(986668422035183747L);
    SimpleLongDecrypter.getCachedDecrypter(3426907962473950958L).setKey(7888685007126463357L);
    SimpleLongDecrypter.getCachedDecrypter(-5311180518433531644L).setKey(1711965904165987236L);
    SimpleLongDecrypter.getCachedDecrypter(6387122037958407967L).setKey(9064579102269286471L);
    SimpleLongDecrypter.getCachedDecrypter(844813405649458308L).setKey(-8886463550578114072L);
    SimpleLongDecrypter.getCachedDecrypter(-283320911895044902L).setKey(1719991226447726573L);
    SimpleLongDecrypter.getCachedDecrypter(-1264434880797650968L).setKey(3974883294280818195L);
    SimpleLongDecrypter.getCachedDecrypter(133028975236948588L).setKey(5354830694950317076L);
    SimpleLongDecrypter.getCachedDecrypter(-8580081261491427462L).setKey(98032285316670964L);
    SimpleLongDecrypter.getCachedDecrypter(-5020460107966381998L).setKey(7136213677862715014L);
    SimpleLongDecrypter.getCachedDecrypter(-4938759921952708670L).setKey(8838626172823483364L);
    SimpleLongDecrypter.getCachedDecrypter(8976325845367440957L).setKey(-1765776257303574582L);
    SimpleLongDecrypter.getCachedDecrypter(6902982124506283337L).setKey(6719393308562537114L);
    SimpleLongDecrypter.getCachedDecrypter(-6391992125206361557L).setKey(4711549946554340662L);
    SimpleLongDecrypter.getCachedDecrypter(3352389660826873536L).setKey(-4431621669043676484L);
    SimpleLongDecrypter.getCachedDecrypter(5934349590132009875L).setKey(-2739552621131332644L);
    SimpleLongDecrypter.getCachedDecrypter(-2490599300836943014L).setKey(-7114594335783031264L);
    SimpleLongDecrypter.getCachedDecrypter(-3865317369981384278L).setKey(2038347863949324474L);
    SimpleLongDecrypter.getCachedDecrypter(8563498211666826399L).setKey(832203478746020441L);
    SimpleLongDecrypter.getCachedDecrypter(-2419219221989267787L).setKey(1508326552573767856L);
    SimpleLongDecrypter.getCachedDecrypter(4258863648478514284L).setKey(115647521030542927L);
    SimpleLongDecrypter.getCachedDecrypter(5605279560795375449L).setKey(-8249250124532008050L);
    SimpleLongDecrypter.getCachedDecrypter(-6271886400726074696L).setKey(3520441167412720204L);
    SimpleLongDecrypter.getCachedDecrypter(2524852401206042875L).setKey(2699677102748147885L);
    SimpleLongDecrypter.getCachedDecrypter(8749689422217271489L).setKey(-1009473764090718526L);
    SimpleLongDecrypter.getCachedDecrypter(4798937993004731314L).setKey(-8913455327705786024L);
    SimpleLongDecrypter.getCachedDecrypter(-5434509465473261992L).setKey(-1856376621542209546L);
    SimpleLongDecrypter.getCachedDecrypter(-934640261167858521L).setKey(-4626672151371498762L);
    SimpleLongDecrypter.getCachedDecrypter(4713885432059659051L).setKey(-6164830028186898555L);
    SimpleLongDecrypter.getCachedDecrypter(9135711438604276665L).setKey(-8346561735703188165L);
    SimpleLongDecrypter.getCachedDecrypter(-67035206978617958L).setKey(1430654872927378346L);
    SimpleLongDecrypter.getCachedDecrypter(7349666945689785501L).setKey(7379467498354782624L);
    SimpleLongDecrypter.getCachedDecrypter(6651602831566549283L).setKey(1863834424200288137L);
    SimpleLongDecrypter.getCachedDecrypter(2850114504609184887L).setKey(6753735155384326998L);
    SimpleLongDecrypter.getCachedDecrypter(5809164552160749911L).setKey(992989546879455821L);
    SimpleLongDecrypter.getCachedDecrypter(-769840753859834119L).setKey(-4806941274041708844L);
    SimpleLongDecrypter.getCachedDecrypter(-3060171067466035977L).setKey(4295960175075858955L);
    SimpleLongDecrypter.getCachedDecrypter(4348580667745657764L).setKey(3255836173157741369L);
    SimpleLongDecrypter.getCachedDecrypter(-791376334248074031L).setKey(-3544275198554430112L);
    SimpleLongDecrypter.getCachedDecrypter(4512056722868951188L).setKey(3512700352144273413L);
    SimpleLongDecrypter.getCachedDecrypter(6088037671248288698L).setKey(8037145334040942854L);
    SimpleLongDecrypter.getCachedDecrypter(8862321168526046178L).setKey(-5817987245208594821L);
    SimpleLongDecrypter.getCachedDecrypter(-910775311537783619L).setKey(-343395346393406934L);
    SimpleLongDecrypter.getCachedDecrypter(-7181910559943479468L).setKey(5941911745798725932L);
    SimpleLongDecrypter.getCachedDecrypter(-5880729938727250434L).setKey(-5074609423781143888L);
    SimpleLongDecrypter.getCachedDecrypter(3130363211075346695L).setKey(-389648285736896311L);
    SimpleLongDecrypter.getCachedDecrypter(-1172816033555547397L).setKey(1448125749421696853L);
    SimpleLongDecrypter.getCachedDecrypter(-9098856711288487839L).setKey(4330100688009131668L);
    SimpleLongDecrypter.getCachedDecrypter(-8219805688086716557L).setKey(7865205394072468313L);
    SimpleLongDecrypter.getCachedDecrypter(6094643673138998317L).setKey(-6375518671241863457L);
    SimpleLongDecrypter.getCachedDecrypter(-282936575719509312L).setKey(6830932346659487152L);
    SimpleLongDecrypter.getCachedDecrypter(-6904530853366419368L).setKey(21047560844529413L);
    SimpleLongDecrypter.getCachedDecrypter(2956780895681462601L).setKey(5730786638025223923L);
    SimpleLongDecrypter.getCachedDecrypter(-9014587823232993665L).setKey(-6881552381202098793L);
    SimpleLongDecrypter.getCachedDecrypter(8097304403009895644L).setKey(-6855007828518168540L);
    SimpleLongDecrypter.getCachedDecrypter(5837280635202993850L).setKey(6786197412692135324L);
    SimpleLongDecrypter.getCachedDecrypter(5154009706078004535L).setKey(-3674148127617585018L);
    SimpleLongDecrypter.getCachedDecrypter(7148494537791468005L).setKey(2180402609218998418L);
    SimpleLongDecrypter.getCachedDecrypter(-4678876556820685576L).setKey(1770289843500493117L);
    SimpleLongDecrypter.getCachedDecrypter(-8556818090886225489L).setKey(816828047363274957L);
    SimpleLongDecrypter.getCachedDecrypter(6684767113140828352L).setKey(-4934465846726257333L);
    SimpleLongDecrypter.getCachedDecrypter(5951188326308085477L).setKey(7149195779370790252L);
    SimpleLongDecrypter.getCachedDecrypter(8566911697251815519L).setKey(5547639912630165402L);
    SimpleLongDecrypter.getCachedDecrypter(-9122021164580647769L).setKey(-6963586786771391937L);
    SimpleLongDecrypter.getCachedDecrypter(-5881114867440596407L).setKey(544004994850714071L);
    SimpleLongDecrypter.getCachedDecrypter(6312352923165959616L).setKey(6778216987424958881L);
    SimpleLongDecrypter.getCachedDecrypter(2404664728834018156L).setKey(9156931120643730276L);
    SimpleLongDecrypter.getCachedDecrypter(2121517868066579812L).setKey(7018571992692176702L);
    SimpleLongDecrypter.getCachedDecrypter(6957662343393363865L).setKey(-4837243352509281377L);
    SimpleLongDecrypter.getCachedDecrypter(7814176419041663577L).setKey(-1480627188199721678L);
    SimpleLongDecrypter.getCachedDecrypter(-2219430966030596736L).setKey(-580022407626261462L);
    SimpleLongDecrypter.getCachedDecrypter(2398994520332957628L).setKey(827251461380454044L);
    SimpleLongDecrypter.getCachedDecrypter(5976313691929166593L).setKey(-6542417732491543826L);
    SimpleLongDecrypter.getCachedDecrypter(3687246192373168530L).setKey(-7164075019008515092L);
    SimpleLongDecrypter.getCachedDecrypter(-4152914073162760565L).setKey(7131571310287021247L);
    SimpleLongDecrypter.getCachedDecrypter(-7995157028941602172L).setKey(3344106750252170525L);
    SimpleLongDecrypter.getCachedDecrypter(491601438706218642L).setKey(3875237187869205351L);
    SimpleLongDecrypter.getCachedDecrypter(-3333686790695614850L).setKey(-3277518571890042799L);
    SimpleLongDecrypter.getCachedDecrypter(4422012386165546951L).setKey(-4913557442781272547L);
    SimpleLongDecrypter.getCachedDecrypter(5956589460587076984L).setKey(1025473908427791274L);
    SimpleLongDecrypter.getCachedDecrypter(891260726512913069L).setKey(5718377678261071824L);
    SimpleLongDecrypter.getCachedDecrypter(-2001459333578242601L).setKey(-7815956587293471376L);
    SimpleLongDecrypter.getCachedDecrypter(4705406497617487456L).setKey(8864700104682761987L);
    SimpleLongDecrypter.getCachedDecrypter(-501444999015994561L).setKey(-1424513387912155069L);
    SimpleLongDecrypter.getCachedDecrypter(8050839368480795084L).setKey(-5545581302488060422L);
    SimpleLongDecrypter.getCachedDecrypter(4175493085894172087L).setKey(-4548213819164511242L);
    SimpleLongDecrypter.getCachedDecrypter(1402706220106707178L).setKey(4854152339492951989L);
    SimpleLongDecrypter.getCachedDecrypter(643851899556155899L).setKey(4353858805986728119L);
    SimpleLongDecrypter.getCachedDecrypter(930669849477838468L).setKey(7145601802951184029L);
    SimpleLongDecrypter.getCachedDecrypter(-7146127485752021367L).setKey(7044564927001292446L);
    SimpleLongDecrypter.getCachedDecrypter(-4676612654574824581L).setKey(2615163793692267302L);
    SimpleLongDecrypter.getCachedDecrypter(-5274958937854147628L).setKey(-5503830377620117265L);
    SimpleLongDecrypter.getCachedDecrypter(-2388838235809591337L).setKey(8083929249767153637L);
    SimpleLongDecrypter.getCachedDecrypter(2664218538285118486L).setKey(-4805822886752440267L);
    SimpleLongDecrypter.getCachedDecrypter(3629194053976295328L).setKey(-413980845934818214L);
    SimpleLongDecrypter.getCachedDecrypter(-4338534444795628312L).setKey(4348262170333362245L);
    SimpleLongDecrypter.getCachedDecrypter(-2772157567561306362L).setKey(1894262266830265545L);
    SimpleLongDecrypter.getCachedDecrypter(-2942068645557674439L).setKey(-150661161550048906L);
    SimpleLongDecrypter.getCachedDecrypter(4624283345539399637L).setKey(-4940398043791286839L);
    SimpleLongDecrypter.getCachedDecrypter(2246287275923875104L).setKey(8598055807579568112L);
    SimpleLongDecrypter.getCachedDecrypter(903867180974421630L).setKey(7797353828341442493L);
    SimpleLongDecrypter.getCachedDecrypter(-8015384363368747498L).setKey(6945407675553590950L);
    SimpleLongDecrypter.getCachedDecrypter(-1625989088698370552L).setKey(5628262993782960255L);
    SimpleLongDecrypter.getCachedDecrypter(8891311302007128071L).setKey(-9050537958242044703L);
    SimpleLongDecrypter.getCachedDecrypter(6775539649882491691L).setKey(-5764432961484024293L);
    SimpleLongDecrypter.getCachedDecrypter(1352193570690361330L).setKey(-7590933945267580880L);
    SimpleLongDecrypter.getCachedDecrypter(2345463557891197605L).setKey(4447430963469323247L);
    SimpleLongDecrypter.getCachedDecrypter(-9069652156379357150L).setKey(7639680417057728556L);
    SimpleLongDecrypter.getCachedDecrypter(-5708398972059792414L).setKey(-8859510332864342271L);
    SimpleLongDecrypter.getCachedDecrypter(7571040440452288187L).setKey(-7087586181182731716L);
    SimpleLongDecrypter.getCachedDecrypter(-7305416110844601097L).setKey(2577480317527510167L);
    SimpleLongDecrypter.getCachedDecrypter(-378023458620248605L).setKey(922282017464848516L);
    SimpleLongDecrypter.getCachedDecrypter(4680774539808764200L).setKey(1096854189666281645L);
    SimpleLongDecrypter.getCachedDecrypter(-7660975159807947644L).setKey(-8385550395755313800L);
    SimpleLongDecrypter.getCachedDecrypter(5336013110431850456L).setKey(8765615049448257257L);
    SimpleLongDecrypter.getCachedDecrypter(7763546371815309491L).setKey(6435807052483608014L);
    SimpleLongDecrypter.getCachedDecrypter(896023792638087005L).setKey(-6347657031532049631L);
    SimpleLongDecrypter.getCachedDecrypter(-8036652892478285093L).setKey(-5506669334272813454L);
    SimpleLongDecrypter.getCachedDecrypter(-2237303544096370490L).setKey(2132470087871025539L);
    SimpleLongDecrypter.getCachedDecrypter(-6827420007518630828L).setKey(-975433886623141575L);
    SimpleLongDecrypter.getCachedDecrypter(-4552077274966164290L).setKey(8434280111720096799L);
    SimpleLongDecrypter.getCachedDecrypter(-8641099509195641086L).setKey(-4621904329833665023L);
    SimpleLongDecrypter.getCachedDecrypter(-7851566888382361952L).setKey(-763409257936342593L);
    SimpleLongDecrypter.getCachedDecrypter(-730569396482508763L).setKey(-4492122526688375103L);
    SimpleLongDecrypter.getCachedDecrypter(2405330025398845677L).setKey(2616032772154789979L);
    SimpleLongDecrypter.getCachedDecrypter(1448794457425911914L).setKey(-5645027995818675964L);
    SimpleLongDecrypter.getCachedDecrypter(-6379861610990764550L).setKey(-964295607853426938L);
    SimpleLongDecrypter.getCachedDecrypter(-4137707281809752681L).setKey(-2205604848825726941L);
    SimpleLongDecrypter.getCachedDecrypter(-1300266886960319186L).setKey(5721471920365470161L);
    SimpleLongDecrypter.getCachedDecrypter(5033910897191388577L).setKey(-5166730403869464736L);
    SimpleLongDecrypter.getCachedDecrypter(6111449495208522016L).setKey(965033930409783797L);
    SimpleLongDecrypter.getCachedDecrypter(-5999953860601114342L).setKey(-1806769929713484939L);
    SimpleLongDecrypter.getCachedDecrypter(-2412157528476050771L).setKey(5507492511569539436L);
    SimpleLongDecrypter.getCachedDecrypter(6185607658836735601L).setKey(3108746505017920696L);
    SimpleLongDecrypter.getCachedDecrypter(4766289894804749756L).setKey(-47920227637495741L);
    SimpleLongDecrypter.getCachedDecrypter(7584603450947307746L).setKey(-499453735057360819L);
    SimpleLongDecrypter.getCachedDecrypter(-7122257526532969866L).setKey(-2689966326499909487L);
    SimpleLongDecrypter.getCachedDecrypter(2515537778683552044L).setKey(5976591340448892216L);
    SimpleLongDecrypter.getCachedDecrypter(2353727905162011051L).setKey(-6740694979374399771L);
    SimpleLongDecrypter.getCachedDecrypter(-2631913965872103142L).setKey(3876489088184427667L);
    SimpleLongDecrypter.getCachedDecrypter(-1814206818475842269L).setKey(3952140031731298147L);
    SimpleLongDecrypter.getCachedDecrypter(2107817823539001197L).setKey(-4699533254061778047L);
    SimpleLongDecrypter.getCachedDecrypter(3119452672653796894L).setKey(-2336709522875219522L);
    SimpleLongDecrypter.getCachedDecrypter(5308707814759603155L).setKey(8650704900376008488L);
    SimpleLongDecrypter.getCachedDecrypter(2755578120010336604L).setKey(-5599650805540706105L);
    SimpleLongDecrypter.getCachedDecrypter(997471349203579075L).setKey(6020636863960873413L);
    SimpleLongDecrypter.getCachedDecrypter(5608399832312421221L).setKey(-5829616728632838662L);
    SimpleLongDecrypter.getCachedDecrypter(281008728445914947L).setKey(-3666912004735716134L);
    SimpleLongDecrypter.getCachedDecrypter(3741813788632310969L).setKey(6974883652563611140L);
    SimpleLongDecrypter.getCachedDecrypter(3807114972471083822L).setKey(2550405902859388595L);
    SimpleLongDecrypter.getCachedDecrypter(-1032666542233428319L).setKey(4265784763814842190L);
    SimpleLongDecrypter.getCachedDecrypter(-1408562034254832454L).setKey(-7598922603911193709L);
    SimpleLongDecrypter.getCachedDecrypter(4296979728457418541L).setKey(80108833732533863L);
    SimpleLongDecrypter.getCachedDecrypter(8819011162557837062L).setKey(8051002818026338522L);
    SimpleLongDecrypter.getCachedDecrypter(5891916869008650820L).setKey(5813822977884202330L);
    SimpleLongDecrypter.getCachedDecrypter(-8705256926536339063L).setKey(4198032795880094414L);
    SimpleLongDecrypter.getCachedDecrypter(8905296941067805389L).setKey(-3184393157463815467L);
    SimpleLongDecrypter.getCachedDecrypter(8695827222366877811L).setKey(-5769284836606938201L);
    SimpleLongDecrypter.getCachedDecrypter(-2032727011601781453L).setKey(-1309528398766854776L);
    SimpleLongDecrypter.getCachedDecrypter(6260257088522702944L).setKey(-4785899956557196579L);
    SimpleLongDecrypter.getCachedDecrypter(-1225386556953875196L).setKey(2184902331510845749L);
    SimpleLongDecrypter.getCachedDecrypter(-230057259810112451L).setKey(3061345739211365038L);
    SimpleLongDecrypter.getCachedDecrypter(-347515885558938266L).setKey(287486677512468472L);
    SimpleLongDecrypter.getCachedDecrypter(-5052765552939976123L).setKey(-6818772514654675467L);
    SimpleLongDecrypter.getCachedDecrypter(-6305377142938099016L).setKey(-2425847871913137149L);
    SimpleLongDecrypter.getCachedDecrypter(-6076120867025073142L).setKey(-3054129230845095505L);
    SimpleLongDecrypter.getCachedDecrypter(-718537287416822422L).setKey(-7695375579992436077L);
    SimpleLongDecrypter.getCachedDecrypter(-4910533213913136333L).setKey(-1880976847801138930L);
    SimpleLongDecrypter.getCachedDecrypter(-685904189583729236L).setKey(4404800672137999811L);
    SimpleLongDecrypter.getCachedDecrypter(5829217361647972373L).setKey(8157288924875590061L);
    SimpleLongDecrypter.getCachedDecrypter(7258607073421805651L).setKey(-783137905939236200L);
    SimpleLongDecrypter.getCachedDecrypter(2844313584151821573L).setKey(-3478851231310295574L);
    SimpleLongDecrypter.getCachedDecrypter(4940892636610903681L).setKey(-4839761963128566155L);
    SimpleLongDecrypter.getCachedDecrypter(-7886287652582179190L).setKey(-6629994973894450365L);
    SimpleLongDecrypter.getCachedDecrypter(-8797582416289294738L).setKey(-1974714536982424759L);
    SimpleLongDecrypter.getCachedDecrypter(9215993389690188835L).setKey(1826380564089731349L);
    SimpleLongDecrypter.getCachedDecrypter(8268926973297654471L).setKey(-1030371023468390414L);
    SimpleLongDecrypter.getCachedDecrypter(3415707310243745834L).setKey(2620249153700654200L);
    SimpleLongDecrypter.getCachedDecrypter(-5683576916409922460L).setKey(4469434171487894429L);
    SimpleLongDecrypter.getCachedDecrypter(7861744999556844312L).setKey(-9208257512213705L);
    SimpleLongDecrypter.getCachedDecrypter(-4013986384641439662L).setKey(2953214773011554640L);
    SimpleLongDecrypter.getCachedDecrypter(-3586610354225245321L).setKey(-2225163357887164132L);
    SimpleLongDecrypter.getCachedDecrypter(-8662600031285239008L).setKey(1312854403453549284L);
    SimpleLongDecrypter.getCachedDecrypter(-4630039151186882224L).setKey(-4570924647354877284L);
    SimpleLongDecrypter.getCachedDecrypter(-5472518267725183876L).setKey(-1124189193793300960L);
    SimpleLongDecrypter.getCachedDecrypter(-7271728144883895543L).setKey(-1129044914612434960L);
    SimpleLongDecrypter.getCachedDecrypter(-7076731209583152483L).setKey(-4866247374677741190L);
    SimpleLongDecrypter.getCachedDecrypter(-3976091818337261079L).setKey(-6516938832495763509L);
    SimpleLongDecrypter.getCachedDecrypter(-5283107585868709161L).setKey(-2280070406269710254L);
    SimpleLongDecrypter.getCachedDecrypter(-1269880912503947929L).setKey(3344176970258954183L);
    SimpleLongDecrypter.getCachedDecrypter(4492602613297031580L).setKey(-9044140268156402394L);
    SimpleLongDecrypter.getCachedDecrypter(-3596628289837164461L).setKey(-4863291749868748738L);
    SimpleLongDecrypter.getCachedDecrypter(-908846270013315825L).setKey(-8207620211696362121L);
    SimpleLongDecrypter.getCachedDecrypter(-6332070144054978921L).setKey(-270062485689622029L);
    SimpleLongDecrypter.getCachedDecrypter(433920241321254465L).setKey(8182119176967205496L);
    SimpleLongDecrypter.getCachedDecrypter(-1137352042545981996L).setKey(-5284720172479976575L);
    SimpleLongDecrypter.getCachedDecrypter(578623419453259596L).setKey(-2265788966376935948L);
    SimpleLongDecrypter.getCachedDecrypter(-8539422970503288679L).setKey(-4927310620627675452L);
    SimpleLongDecrypter.getCachedDecrypter(-8076555829328392145L).setKey(-1226407345918797607L);
    SimpleLongDecrypter.getCachedDecrypter(-3845142371141045124L).setKey(-7409973274495938474L);
    SimpleLongDecrypter.getCachedDecrypter(-4609404247335391935L).setKey(8219900804071642616L);
    SimpleLongDecrypter.getCachedDecrypter(-2635811570132226181L).setKey(2602017401361256539L);
    SimpleLongDecrypter.getCachedDecrypter(5868137159599459108L).setKey(3386829292368610803L);
    SimpleLongDecrypter.getCachedDecrypter(-6097882243598930294L).setKey(-266701966871432066L);
    SimpleLongDecrypter.getCachedDecrypter(1457113226221545676L).setKey(-4473399401957219425L);
    SimpleLongDecrypter.getCachedDecrypter(-2226090317452295654L).setKey(-4814148907175785043L);
    SimpleLongDecrypter.getCachedDecrypter(2061524061065799941L).setKey(6252661349220709709L);
    SimpleLongDecrypter.getCachedDecrypter(-3777070770427996013L).setKey(6260217903298267449L);
    SimpleLongDecrypter.getCachedDecrypter(-3083140932856660116L).setKey(2274786107078597384L);
    SimpleLongDecrypter.getCachedDecrypter(-7781746102113926676L).setKey(-8576036948113113611L);
    SimpleLongDecrypter.getCachedDecrypter(194204710527421124L).setKey(1310515527228495341L);
    SimpleLongDecrypter.getCachedDecrypter(6173837781650496647L).setKey(-1720414629250729325L);
    SimpleLongDecrypter.getCachedDecrypter(-7284787193292731001L).setKey(7867469392832470639L);
    SimpleLongDecrypter.getCachedDecrypter(-607024276877568327L).setKey(5663631593466143967L);
    SimpleLongDecrypter.getCachedDecrypter(161922536029005060L).setKey(6320227739778164569L);
    SimpleLongDecrypter.getCachedDecrypter(186564734450198815L).setKey(-3864447756122245635L);
    SimpleLongDecrypter.getCachedDecrypter(1077962770773113132L).setKey(-4926662641630284121L);
    SimpleLongDecrypter.getCachedDecrypter(-4029696182017788976L).setKey(-3319564848746594900L);
    SimpleLongDecrypter.getCachedDecrypter(-1967453165764311274L).setKey(5021892544636294882L);
    SimpleLongDecrypter.getCachedDecrypter(1963816454044765500L).setKey(-360889287272561836L);
    SimpleLongDecrypter.getCachedDecrypter(-7332711196549788079L).setKey(-3887605504906376400L);
    SimpleLongDecrypter.getCachedDecrypter(-4780634992695739225L).setKey(-1812272834269411328L);
    SimpleLongDecrypter.getCachedDecrypter(-5951970011870783482L).setKey(-1469962208625385884L);
    SimpleLongDecrypter.getCachedDecrypter(-4214782198233646759L).setKey(6817800858635072802L);
    SimpleLongDecrypter.getCachedDecrypter(5223694580192228645L).setKey(-1150607044823804383L);
    SimpleLongDecrypter.getCachedDecrypter(2062427773613326055L).setKey(4556612720102421850L);
    SimpleLongDecrypter.getCachedDecrypter(1213125596186324192L).setKey(6764046256361948024L);
    SimpleLongDecrypter.getCachedDecrypter(-1940045494097321219L).setKey(8911329614615938988L);
    SimpleLongDecrypter.getCachedDecrypter(-2391372495178511590L).setKey(5053697444304357451L);
    SimpleLongDecrypter.getCachedDecrypter(-585428471360421721L).setKey(-6933610267654220824L);
    SimpleLongDecrypter.getCachedDecrypter(-1269914699773916463L).setKey(-2538562080736935650L);
    SimpleLongDecrypter.getCachedDecrypter(4671198192713014705L).setKey(6219486407937113805L);
    SimpleLongDecrypter.getCachedDecrypter(3069428160580116087L).setKey(3515224670580566934L);
    SimpleLongDecrypter.getCachedDecrypter(-860887575799611990L).setKey(-3536950944077651687L);
    SimpleLongDecrypter.getCachedDecrypter(7913294351857791487L).setKey(-8880136695067972797L);
    SimpleLongDecrypter.getCachedDecrypter(-7389359691604263986L).setKey(-30037485320133862L);
    SimpleLongDecrypter.getCachedDecrypter(-5626294014255541453L).setKey(6235696700339812663L);
    SimpleLongDecrypter.getCachedDecrypter(5114925484144516149L).setKey(-6358823149323204010L);
    SimpleLongDecrypter.getCachedDecrypter(-5692121909299804844L).setKey(-1896698448203491074L);
    SimpleLongDecrypter.getCachedDecrypter(2225627047281660936L).setKey(4502425516208926030L);
    SimpleLongDecrypter.getCachedDecrypter(5474231748219190710L).setKey(1286871519852327622L);
    SimpleLongDecrypter.getCachedDecrypter(3379131489968643550L).setKey(-7951136298157489299L);
    SimpleLongDecrypter.getCachedDecrypter(7085165451073933624L).setKey(6301379273026279495L);
    SimpleLongDecrypter.getCachedDecrypter(7219134313334080222L).setKey(7929725165935092268L);
    SimpleLongDecrypter.getCachedDecrypter(3508160487305556552L).setKey(-6471271013329250062L);
    SimpleLongDecrypter.getCachedDecrypter(-5547644677964569684L).setKey(-6501626311327823695L);
    SimpleLongDecrypter.getCachedDecrypter(-4635672113622722196L).setKey(-9037426920966661355L);
    SimpleLongDecrypter.getCachedDecrypter(5613192595752858543L).setKey(-617203749451550912L);
    SimpleLongDecrypter.getCachedDecrypter(3303974493293778980L).setKey(7403059436101508600L);
    SimpleLongDecrypter.getCachedDecrypter(-5660811660762702811L).setKey(-5718893313844796413L);
    SimpleLongDecrypter.getCachedDecrypter(6419617577577389976L).setKey(-3557703322571480473L);
    SimpleLongDecrypter.getCachedDecrypter(-6686063078996543395L).setKey(4342152124047613952L);
    SimpleLongDecrypter.getCachedDecrypter(-5611036935943732645L).setKey(-6609408451643222995L);
    SimpleLongDecrypter.getCachedDecrypter(949189709204768716L).setKey(-7792655992029411652L);
    SimpleLongDecrypter.getCachedDecrypter(3633532041377306703L).setKey(-7594511257737688532L);
    SimpleLongDecrypter.getCachedDecrypter(-5340490931118950745L).setKey(2671663723724803527L);
    SimpleLongDecrypter.getCachedDecrypter(1721081388572205275L).setKey(-4312931600953800040L);
    SimpleLongDecrypter.getCachedDecrypter(-3884236051853241675L).setKey(-2074352829678579105L);
    SimpleLongDecrypter.getCachedDecrypter(-5657628566183231167L).setKey(-625719579658880068L);
    SimpleLongDecrypter.getCachedDecrypter(-2487922806028493083L).setKey(-3677321164760329767L);
    SimpleLongDecrypter.getCachedDecrypter(-1965747641827456002L).setKey(4735604152053341736L);
    SimpleLongDecrypter.getCachedDecrypter(6517527998844717577L).setKey(-1054251713793218522L);
    SimpleLongDecrypter.getCachedDecrypter(2802894877553421337L).setKey(3888535321103665882L);
    SimpleLongDecrypter.getCachedDecrypter(2057428586028921412L).setKey(-4381122910182561359L);
    SimpleLongDecrypter.getCachedDecrypter(-1193603825741756557L).setKey(-363782566835389093L);
    SimpleLongDecrypter.getCachedDecrypter(6016551819798478198L).setKey(8568863846688867089L);
    SimpleLongDecrypter.getCachedDecrypter(7711381116061502078L).setKey(4471392017356747406L);
    SimpleLongDecrypter.getCachedDecrypter(5889378791192491094L).setKey(5984464768939725838L);
    SimpleLongDecrypter.getCachedDecrypter(8401738068663074154L).setKey(5766195525726473453L);
    SimpleLongDecrypter.getCachedDecrypter(4501765291689892488L).setKey(-1159529694699093853L);
    SimpleLongDecrypter.getCachedDecrypter(-7718325243664923523L).setKey(4812916429702280798L);
    SimpleLongDecrypter.getCachedDecrypter(-2040946300398928100L).setKey(-1629896540564808223L);
    SimpleLongDecrypter.getCachedDecrypter(-3346448748773669126L).setKey(-4803994436103886982L);
    SimpleLongDecrypter.getCachedDecrypter(5166813009876610842L).setKey(-2573707926518369443L);
    SimpleLongDecrypter.getCachedDecrypter(-7131190739882646197L).setKey(7369506509352994437L);
    SimpleLongDecrypter.getCachedDecrypter(-6275143252432446409L).setKey(7215797610554510334L);
    SimpleLongDecrypter.getCachedDecrypter(2967776132393628325L).setKey(4380798432958694005L);
    SimpleLongDecrypter.getCachedDecrypter(8309414877128288787L).setKey(5877831043767831897L);
    SimpleLongDecrypter.getCachedDecrypter(4246118523526653536L).setKey(-5243784101651981647L);
    SimpleLongDecrypter.getCachedDecrypter(-8967545983735833640L).setKey(-9088293421852171940L);
    SimpleLongDecrypter.getCachedDecrypter(-4533633881644565215L).setKey(-7770308024132909478L);
    SimpleLongDecrypter.getCachedDecrypter(-1397880274618364378L).setKey(6608841295585613272L);
    SimpleLongDecrypter.getCachedDecrypter(6437185844784568117L).setKey(2276068393042236981L);
    SimpleLongDecrypter.getCachedDecrypter(5609367404941869335L).setKey(2484521955842651698L);
    SimpleLongDecrypter.getCachedDecrypter(-5780661619314299982L).setKey(6643671237398299636L);
    SimpleLongDecrypter.getCachedDecrypter(8904117036968760169L).setKey(840914296265396452L);
    SimpleLongDecrypter.getCachedDecrypter(-3064456258830201458L).setKey(-2321030584762874927L);
    SimpleLongDecrypter.getCachedDecrypter(-5102359221491009480L).setKey(-353754492846476356L);
    SimpleLongDecrypter.getCachedDecrypter(-6169183676957267487L).setKey(-5505789061531298767L);
    SimpleLongDecrypter.getCachedDecrypter(-7936925965638138386L).setKey(1639635570961840665L);
    SimpleLongDecrypter.getCachedDecrypter(-1615929681435208587L).setKey(-2968788310792625178L);
    SimpleLongDecrypter.getCachedDecrypter(-8708905642253923653L).setKey(7939394802113738050L);
    SimpleLongDecrypter.getCachedDecrypter(4554184200509951517L).setKey(4721291965869897994L);
    SimpleLongDecrypter.getCachedDecrypter(-5683520390413426366L).setKey(7947640529673854349L);
    SimpleLongDecrypter.getCachedDecrypter(-5593884381516186039L).setKey(-9136723649160894573L);
    SimpleLongDecrypter.getCachedDecrypter(-2255988379456869212L).setKey(5525579963988578438L);
    SimpleLongDecrypter.getCachedDecrypter(-5555013588188685324L).setKey(4298528855630781102L);
    SimpleLongDecrypter.getCachedDecrypter(3903701478119138748L).setKey(7522427139109985362L);
    SimpleLongDecrypter.getCachedDecrypter(-3264922339265983758L).setKey(-1258767203757307836L);
    SimpleLongDecrypter.getCachedDecrypter(6729595208190815879L).setKey(-5966459293125080441L);
    SimpleLongDecrypter.getCachedDecrypter(8371109807555253893L).setKey(-6769967094279619122L);
    SimpleLongDecrypter.getCachedDecrypter(-8579633775657026411L).setKey(801363964817926739L);
    SimpleLongDecrypter.getCachedDecrypter(-512115788548991283L).setKey(-1788898582611672654L);
    SimpleLongDecrypter.getCachedDecrypter(7450979011007011077L).setKey(6584535602800686684L);
    SimpleLongDecrypter.getCachedDecrypter(-766010040747712659L).setKey(-7718491359111173939L);
    SimpleLongDecrypter.getCachedDecrypter(4023081085708508183L).setKey(-8332828992202330792L);
    SimpleLongDecrypter.getCachedDecrypter(2995415640129950629L).setKey(6090555137963924584L);
    SimpleLongDecrypter.getCachedDecrypter(-9001404322685750796L).setKey(1918719100825133177L);
    SimpleLongDecrypter.getCachedDecrypter(-7528493265282411561L).setKey(3053067916487979065L);
    SimpleLongDecrypter.getCachedDecrypter(332134035235417872L).setKey(1358333438218534118L);
    SimpleLongDecrypter.getCachedDecrypter(7372275824110013954L).setKey(-8519694273707332301L);
    SimpleLongDecrypter.getCachedDecrypter(3639000469692727174L).setKey(5787276395341327591L);
    SimpleLongDecrypter.getCachedDecrypter(7100957166950668116L).setKey(1849233497105620867L);
    SimpleLongDecrypter.getCachedDecrypter(2224707637035431354L).setKey(-1657296404198274387L);
    SimpleLongDecrypter.getCachedDecrypter(5321913929972856599L).setKey(-330003032022513497L);
    SimpleLongDecrypter.getCachedDecrypter(6332167732351623904L).setKey(-7535097510769313108L);
    SimpleLongDecrypter.getCachedDecrypter(-8456358026880929920L).setKey(449110261434879161L);
    SimpleLongDecrypter.getCachedDecrypter(4625919925374718706L).setKey(870231537189306478L);
    SimpleLongDecrypter.getCachedDecrypter(6039351737531591474L).setKey(2780987515814172718L);
    SimpleLongDecrypter.getCachedDecrypter(-1141302648810960122L).setKey(-8986048534892058381L);
    SimpleLongDecrypter.getCachedDecrypter(115776929845132442L).setKey(3925413541495250392L);
    SimpleLongDecrypter.getCachedDecrypter(-8012968404627254794L).setKey(3883405774483324150L);
    SimpleLongDecrypter.getCachedDecrypter(7922365337955490159L).setKey(2253835675506686675L);
    SimpleLongDecrypter.getCachedDecrypter(-9098936529823846238L).setKey(4118068233256573431L);
    SimpleLongDecrypter.getCachedDecrypter(3861837551237127201L).setKey(3697170707232720797L);
    SimpleLongDecrypter.getCachedDecrypter(-7383725929016762586L).setKey(-6664119565501672295L);
    SimpleLongDecrypter.getCachedDecrypter(3797410525195312712L).setKey(3082593396056762146L);
    SimpleLongDecrypter.getCachedDecrypter(-5004786245805872869L).setKey(-1519219497300168705L);
    SimpleLongDecrypter.getCachedDecrypter(-487069256458300398L).setKey(8189751719598485768L);
    SimpleLongDecrypter.getCachedDecrypter(-3045592880861167672L).setKey(3867477207358463979L);
    SimpleLongDecrypter.getCachedDecrypter(-7731883549901899587L).setKey(-4904958622392651498L);
    SimpleLongDecrypter.getCachedDecrypter(-6856740598526240375L).setKey(-531461290795475867L);
    SimpleLongDecrypter.getCachedDecrypter(2975749227795274167L).setKey(-901323884047770009L);
    SimpleLongDecrypter.getCachedDecrypter(2804461249725417170L).setKey(-831075716097867351L);
    SimpleLongDecrypter.getCachedDecrypter(2634761252652773197L).setKey(-5566906033433243581L);
    SimpleLongDecrypter.getCachedDecrypter(1340811178183234409L).setKey(-5956788711371547046L);
    SimpleLongDecrypter.getCachedDecrypter(4386996726110941219L).setKey(6100996670254338119L);
    SimpleLongDecrypter.getCachedDecrypter(-6370856373498777951L).setKey(-6976616072431843702L);
    SimpleLongDecrypter.getCachedDecrypter(-2441844021034509362L).setKey(5787936561682956490L);
    SimpleLongDecrypter.getCachedDecrypter(-6545004947880963693L).setKey(-3352046170677584828L);
    SimpleLongDecrypter.getCachedDecrypter(-3968232955711074133L).setKey(-4970111534614739111L);
    SimpleLongDecrypter.getCachedDecrypter(-7240525790183003676L).setKey(-3117676961719983277L);
    SimpleLongDecrypter.getCachedDecrypter(2185175504522925193L).setKey(1738086923383177179L);
    SimpleLongDecrypter.getCachedDecrypter(-7655170317501711721L).setKey(1737184312241567531L);
    SimpleLongDecrypter.getCachedDecrypter(8432766444444216265L).setKey(7878947169525731716L);
    SimpleLongDecrypter.getCachedDecrypter(-6024774183714868663L).setKey(6149776496771081188L);
    SimpleLongDecrypter.getCachedDecrypter(1370650286571039290L).setKey(-3151871481369786625L);
    SimpleLongDecrypter.getCachedDecrypter(-3825180543839084565L).setKey(2573346358117906306L);
    SimpleLongDecrypter.getCachedDecrypter(2581348212979189162L).setKey(-6378259983634064320L);
    SimpleLongDecrypter.getCachedDecrypter(7670882971342265734L).setKey(-8122879657749417211L);
    SimpleLongDecrypter.getCachedDecrypter(-280595073495814219L).setKey(-3639462054650436512L);
    SimpleLongDecrypter.getCachedDecrypter(7296025092183338215L).setKey(6129857043068909404L);
    SimpleLongDecrypter.getCachedDecrypter(-7347572876486647480L).setKey(-938598601234047613L);
    SimpleLongDecrypter.getCachedDecrypter(8493434442365369318L).setKey(-4170696398770464884L);
    SimpleLongDecrypter.getCachedDecrypter(-6229254793057104517L).setKey(351039051970900345L);
    SimpleLongDecrypter.getCachedDecrypter(1767690126961945300L).setKey(1316276844071710993L);
    SimpleLongDecrypter.getCachedDecrypter(-8545733944765967989L).setKey(685456249404915628L);
    SimpleLongDecrypter.getCachedDecrypter(-5567637832186338684L).setKey(-7063007164167857159L);
    SimpleLongDecrypter.getCachedDecrypter(9203939272986204381L).setKey(7704457220335448308L);
    SimpleLongDecrypter.getCachedDecrypter(7124797895193839163L).setKey(6830182828673249986L);
    SimpleLongDecrypter.getCachedDecrypter(9062483313310716152L).setKey(6345574500273351513L);
    SimpleLongDecrypter.getCachedDecrypter(-1651704877991621999L).setKey(-1578951519504280268L);
    SimpleLongDecrypter.getCachedDecrypter(-9103205149641257594L).setKey(8652004805383713387L);
    SimpleLongDecrypter.getCachedDecrypter(5072202032913291520L).setKey(-7124146926258467900L);
    SimpleLongDecrypter.getCachedDecrypter(-1398819436674531905L).setKey(-2326705926015504082L);
    SimpleLongDecrypter.getCachedDecrypter(-5316956170070739410L).setKey(4235282352315502892L);
    SimpleLongDecrypter.getCachedDecrypter(-9119746161180090588L).setKey(5497108685415983017L);
    SimpleLongDecrypter.getCachedDecrypter(4785407757834566221L).setKey(-9023316542319102433L);
    SimpleLongDecrypter.getCachedDecrypter(-6452657919553483417L).setKey(531437528604388136L);
    SimpleLongDecrypter.getCachedDecrypter(-4194230688762687955L).setKey(7085447097372211771L);
    SimpleLongDecrypter.getCachedDecrypter(-4330576196821530940L).setKey(-8702450502952588240L);
    SimpleLongDecrypter.getCachedDecrypter(3107329749327873690L).setKey(-4194381641748673652L);
    SimpleLongDecrypter.getCachedDecrypter(3498660463279805333L).setKey(-8694543440249619448L);
    SimpleLongDecrypter.getCachedDecrypter(-4066984513583908467L).setKey(-3820720298076593844L);
    SimpleLongDecrypter.getCachedDecrypter(4389269484530562187L).setKey(3582981575125201688L);
    SimpleLongDecrypter.getCachedDecrypter(-8355752216015849112L).setKey(-5079303750160881812L);
    SimpleLongDecrypter.getCachedDecrypter(3347486822224866367L).setKey(-3844782773683652561L);
    SimpleLongDecrypter.getCachedDecrypter(8222275322019952730L).setKey(2148390556893250956L);
    SimpleLongDecrypter.getCachedDecrypter(4980784376668102834L).setKey(2937610928904937914L);
    SimpleLongDecrypter.getCachedDecrypter(8031080380039647325L).setKey(2123234509422043267L);
    SimpleLongDecrypter.getCachedDecrypter(-4115918539197599633L).setKey(1509176025608543872L);
    SimpleLongDecrypter.getCachedDecrypter(-985996608630183314L).setKey(-1940073878172790540L);
    SimpleLongDecrypter.getCachedDecrypter(-1137179487210259552L).setKey(8368488366700458346L);
    SimpleLongDecrypter.getCachedDecrypter(-3858647898228072199L).setKey(7831431516805328111L);
    SimpleLongDecrypter.getCachedDecrypter(1514085577023323224L).setKey(7196228206433842935L);
    SimpleLongDecrypter.getCachedDecrypter(8633303668951844126L).setKey(3446774311101399095L);
    SimpleLongDecrypter.getCachedDecrypter(-5557491543361290732L).setKey(-1849388174122698750L);
    SimpleLongDecrypter.getCachedDecrypter(-6075321094135001139L).setKey(4477102111638881014L);
    SimpleLongDecrypter.getCachedDecrypter(-982160963901207048L).setKey(7478477722059986661L);
    SimpleLongDecrypter.getCachedDecrypter(5872647239657502800L).setKey(6401163615565741388L);
    SimpleLongDecrypter.getCachedDecrypter(-4106810992020069997L).setKey(-8788218863744266739L);
    SimpleLongDecrypter.getCachedDecrypter(-3316808944461186192L).setKey(-7260338286325985227L);
    SimpleLongDecrypter.getCachedDecrypter(-6947885788709957597L).setKey(1880302378801790182L);
    SimpleLongDecrypter.getCachedDecrypter(-5916305063853153411L).setKey(7279747957666938093L);
    SimpleLongDecrypter.getCachedDecrypter(-2451251335704724803L).setKey(-497754426688123801L);
    SimpleLongDecrypter.getCachedDecrypter(-119287780694506329L).setKey(5551926298358761499L);
    SimpleLongDecrypter.getCachedDecrypter(5517483904713125324L).setKey(-7055571928442381499L);
    SimpleLongDecrypter.getCachedDecrypter(367417373199396918L).setKey(7785463669739739846L);
    SimpleLongDecrypter.getCachedDecrypter(4616281316630977952L).setKey(-7226046852276811149L);
    SimpleLongDecrypter.getCachedDecrypter(-6653956692739722578L).setKey(-1414095905463042033L);
    SimpleLongDecrypter.getCachedDecrypter(7872010166358596434L).setKey(-2948415143224684935L);
    SimpleLongDecrypter.getCachedDecrypter(-4998038086310773631L).setKey(-2404880584697080480L);
    SimpleLongDecrypter.getCachedDecrypter(1526992695168814459L).setKey(-260314494841144134L);
    SimpleLongDecrypter.getCachedDecrypter(-8272560127123953496L).setKey(-7818632163276363309L);
    SimpleLongDecrypter.getCachedDecrypter(4468313965120632087L).setKey(-93105817275979431L);
    SimpleLongDecrypter.getCachedDecrypter(-6699316214475635761L).setKey(8099049226107174491L);
    SimpleLongDecrypter.getCachedDecrypter(516845560795460069L).setKey(2925528759813617917L);
    SimpleLongDecrypter.getCachedDecrypter(-3643425642262530957L).setKey(-6371417650257870842L);
    SimpleLongDecrypter.getCachedDecrypter(-3023065024282075311L).setKey(7834908941459175121L);
    SimpleLongDecrypter.getCachedDecrypter(1584800498430516087L).setKey(-706362111194947203L);
    SimpleLongDecrypter.getCachedDecrypter(-7431320364172477862L).setKey(-1881782653878896701L);
    SimpleLongDecrypter.getCachedDecrypter(-8303284752927041846L).setKey(2988337961660856799L);
    SimpleLongDecrypter.getCachedDecrypter(2340364933943548854L).setKey(-201510857184532063L);
    SimpleLongDecrypter.getCachedDecrypter(8149731375628857902L).setKey(2151887874757884176L);
    SimpleLongDecrypter.getCachedDecrypter(-3825120207350504649L).setKey(6067643852833165843L);
    SimpleLongDecrypter.getCachedDecrypter(5993123437798287076L).setKey(-1940077219545073643L);
    SimpleLongDecrypter.getCachedDecrypter(494523940956647954L).setKey(-3956393073389419488L);
    SimpleLongDecrypter.getCachedDecrypter(-884654331463467298L).setKey(-7850980247109401194L);
    SimpleLongDecrypter.getCachedDecrypter(-6050302001855293254L).setKey(8994139993019604903L);
    SimpleLongDecrypter.getCachedDecrypter(-2249681151491590613L).setKey(-1444419233932756306L);
    SimpleLongDecrypter.getCachedDecrypter(4391349005173980862L).setKey(1692291376555787565L);
    SimpleLongDecrypter.getCachedDecrypter(-2817700026242613241L).setKey(5805961727725303799L);
    SimpleLongDecrypter.getCachedDecrypter(-2123937026238841263L).setKey(8080129503000880587L);
    SimpleLongDecrypter.getCachedDecrypter(3920657702337081132L).setKey(1769268968073003134L);
    SimpleLongDecrypter.getCachedDecrypter(-7538327560061680359L).setKey(5731817498360878519L);
    SimpleLongDecrypter.getCachedDecrypter(4307405310917510336L).setKey(-778811594676511302L);
    SimpleLongDecrypter.getCachedDecrypter(-8068378758344081415L).setKey(7203497627352896681L);
    SimpleLongDecrypter.getCachedDecrypter(-4029929454345660504L).setKey(-1543265893007110112L);
    SimpleLongDecrypter.getCachedDecrypter(-9134954520320628851L).setKey(-7557581382907488812L);
    SimpleLongDecrypter.getCachedDecrypter(-3216983260259804915L).setKey(-2804611961373439360L);
    SimpleLongDecrypter.getCachedDecrypter(2019406650251225041L).setKey(4188840612406438641L);
    SimpleLongDecrypter.getCachedDecrypter(4108928347095601664L).setKey(5433120010952512242L);
    SimpleLongDecrypter.getCachedDecrypter(-4354987785027683062L).setKey(1236580111716998739L);
    SimpleLongDecrypter.getCachedDecrypter(-4957233908584132709L).setKey(5571224436660790277L);
    SimpleLongDecrypter.getCachedDecrypter(7466419149978856212L).setKey(965306965160455555L);
    SimpleLongDecrypter.getCachedDecrypter(-6768875840120669603L).setKey(5149468132399057172L);
    SimpleLongDecrypter.getCachedDecrypter(3803202920437078985L).setKey(-2197348844377076727L);
    SimpleLongDecrypter.getCachedDecrypter(-353745969942352113L).setKey(-2759950557049759583L);
    SimpleLongDecrypter.getCachedDecrypter(3721152294977697059L).setKey(8836318146291879117L);
    SimpleLongDecrypter.getCachedDecrypter(-7071025754506017450L).setKey(-5814481829242988549L);
    SimpleLongDecrypter.getCachedDecrypter(-1367496368510280499L).setKey(-7399039481454387501L);
    SimpleLongDecrypter.getCachedDecrypter(962250530077941453L).setKey(8714306351372948395L);
    SimpleLongDecrypter.getCachedDecrypter(5375962402242124840L).setKey(4182254671076189770L);
    SimpleLongDecrypter.getCachedDecrypter(-3968084796232477517L).setKey(4035174604629198762L);
    SimpleLongDecrypter.getCachedDecrypter(8973083104798979427L).setKey(6051875698689957284L);
    SimpleLongDecrypter.getCachedDecrypter(-7769301988547888066L).setKey(6120839536144180997L);
    SimpleLongDecrypter.getCachedDecrypter(-2192737844425167420L).setKey(-1159706106951810568L);
    SimpleLongDecrypter.getCachedDecrypter(108471504380677428L).setKey(202891975013411350L);
    SimpleLongDecrypter.getCachedDecrypter(-4643334714295068010L).setKey(8985128556688507552L);
    SimpleLongDecrypter.getCachedDecrypter(9070058511261574034L).setKey(-9144998362809686687L);
    SimpleLongDecrypter.getCachedDecrypter(5813480565798063365L).setKey(-2969572231919879461L);
    SimpleLongDecrypter.getCachedDecrypter(-6950312744858137565L).setKey(8964097236331070067L);
    SimpleLongDecrypter.getCachedDecrypter(-8210952132393318314L).setKey(2444750405932706988L);
    SimpleLongDecrypter.getCachedDecrypter(4636991986122711237L).setKey(1152894612679229636L);
    SimpleLongDecrypter.getCachedDecrypter(-4400292066099847235L).setKey(5306675636848367867L);
    SimpleLongDecrypter.getCachedDecrypter(6667286567916910025L).setKey(-6531665562742382234L);
    SimpleLongDecrypter.getCachedDecrypter(2252081205708219861L).setKey(87001033006397444L);
    SimpleLongDecrypter.getCachedDecrypter(-3050943510437397296L).setKey(4852837810360410849L);
    SimpleLongDecrypter.getCachedDecrypter(6741783293193904623L).setKey(-5934472440761389793L);
    SimpleLongDecrypter.getCachedDecrypter(-5637750909457609552L).setKey(-8934093441175197018L);
    SimpleLongDecrypter.getCachedDecrypter(1629657537175523109L).setKey(-6249404241121529699L);
    SimpleLongDecrypter.getCachedDecrypter(7313969139448148278L).setKey(-7321075123965083464L);
    SimpleLongDecrypter.getCachedDecrypter(5377274044009038496L).setKey(806330172225540838L);
    SimpleLongDecrypter.getCachedDecrypter(-7743336296491016275L).setKey(-8126011582802627965L);
    SimpleLongDecrypter.getCachedDecrypter(-5536253103587618805L).setKey(-700611116576616973L);
    SimpleLongDecrypter.getCachedDecrypter(904784302860625365L).setKey(-6177942536058482240L);
    SimpleLongDecrypter.getCachedDecrypter(3430362771833757077L).setKey(1836742154971768475L);
    SimpleLongDecrypter.getCachedDecrypter(-8872868584407449522L).setKey(-4398684143610237327L);
    SimpleLongDecrypter.getCachedDecrypter(302608078044574655L).setKey(523345530516086919L);
    SimpleLongDecrypter.getCachedDecrypter(5800831274736773453L).setKey(-2097646773388879620L);
    SimpleLongDecrypter.getCachedDecrypter(-1527914013808528408L).setKey(-4934312560400757557L);
    SimpleLongDecrypter.getCachedDecrypter(-1342463959584723367L).setKey(6048949309804760836L);
    SimpleLongDecrypter.getCachedDecrypter(-3280988298852226611L).setKey(-5452734359323044404L);
    SimpleLongDecrypter.getCachedDecrypter(8720039940700267019L).setKey(-562647151356778890L);
    SimpleLongDecrypter.getCachedDecrypter(7668318071225732446L).setKey(6236850484425762896L);
    SimpleLongDecrypter.getCachedDecrypter(-3167290785758321315L).setKey(8606938929385695954L);
    SimpleLongDecrypter.getCachedDecrypter(4486174180094080779L).setKey(-152598487059895647L);
    SimpleLongDecrypter.getCachedDecrypter(7280742808264518501L).setKey(-1841272343288636625L);
    SimpleLongDecrypter.getCachedDecrypter(865276794991823591L).setKey(-697500703458044074L);
    SimpleLongDecrypter.getCachedDecrypter(-4366498714719285607L).setKey(-5246014330137011594L);
    SimpleLongDecrypter.getCachedDecrypter(4865495706571431375L).setKey(-4103716022013901066L);
    SimpleLongDecrypter.getCachedDecrypter(8025595908170625094L).setKey(-2859169359841324246L);
    SimpleLongDecrypter.getCachedDecrypter(-2505383949991080908L).setKey(8131877304007088900L);
    SimpleLongDecrypter.getCachedDecrypter(-4903767256782388759L).setKey(-8345406024759639975L);
    SimpleLongDecrypter.getCachedDecrypter(-2061449307245156134L).setKey(1607701475283670181L);
    SimpleLongDecrypter.getCachedDecrypter(-6960269097467423694L).setKey(-2684583322112947938L);
    SimpleLongDecrypter.getCachedDecrypter(-4615128449727634470L).setKey(-6095683936340395915L);
    SimpleLongDecrypter.getCachedDecrypter(-8775597669882932234L).setKey(-2149408243650741971L);
    SimpleLongDecrypter.getCachedDecrypter(3554523620763964863L).setKey(-3762070470601449184L);
    SimpleLongDecrypter.getCachedDecrypter(1373709124025218330L).setKey(-8356428209304367211L);
    SimpleLongDecrypter.getCachedDecrypter(7849535997697952981L).setKey(5709026395352674152L);
    SimpleLongDecrypter.getCachedDecrypter(-6251048441907918015L).setKey(-519450909942916385L);
    SimpleLongDecrypter.getCachedDecrypter(1968866800081869236L).setKey(-1806912105753589311L);
    SimpleLongDecrypter.getCachedDecrypter(3725247981489930276L).setKey(98726891508234801L);
    SimpleLongDecrypter.getCachedDecrypter(-4365587612396649113L).setKey(5301553018633184755L);
    SimpleLongDecrypter.getCachedDecrypter(-1898703038185736945L).setKey(7610424756957080799L);
    SimpleLongDecrypter.getCachedDecrypter(9143529653539113876L).setKey(4316519219188606005L);
    SimpleLongDecrypter.getCachedDecrypter(3448791851287722885L).setKey(5970056470977332284L);
    SimpleLongDecrypter.getCachedDecrypter(1021607551049073889L).setKey(2481907017442232866L);
    SimpleLongDecrypter.getCachedDecrypter(-2851552053666509221L).setKey(597922493007043275L);
    SimpleLongDecrypter.getCachedDecrypter(5612827130936291745L).setKey(-7145183683620190774L);
    SimpleLongDecrypter.getCachedDecrypter(4604019357166594475L).setKey(2485387138973003704L);
    SimpleLongDecrypter.getCachedDecrypter(-5957034415080906416L).setKey(476033028704502670L);
    SimpleLongDecrypter.getCachedDecrypter(-1422799770439163454L).setKey(-4958431929541770649L);
    SimpleLongDecrypter.getCachedDecrypter(-5682513674880712083L).setKey(-6426653108232355586L);
    SimpleLongDecrypter.getCachedDecrypter(-484939322823461374L).setKey(-5456325193397922213L);
    SimpleLongDecrypter.getCachedDecrypter(-5746990292110234411L).setKey(3469011487747941596L);
    SimpleLongDecrypter.getCachedDecrypter(4616318844088751811L).setKey(4262883765506901295L);
    SimpleLongDecrypter.getCachedDecrypter(7271607377314521359L).setKey(3599019037312557283L);
    SimpleLongDecrypter.getCachedDecrypter(-1520318610830569041L).setKey(3868546609319185130L);
    SimpleLongDecrypter.getCachedDecrypter(-8986273072386652435L).setKey(8691800123060208095L);
    SimpleLongDecrypter.getCachedDecrypter(-9094957049424794964L).setKey(-3046989847075190784L);
    SimpleLongDecrypter.getCachedDecrypter(-3635003569144323138L).setKey(2664680535196873296L);
    SimpleLongDecrypter.getCachedDecrypter(401291005151219177L).setKey(5402816277528819678L);
    SimpleLongDecrypter.getCachedDecrypter(-1803684337010677656L).setKey(8275773893080468874L);
    SimpleLongDecrypter.getCachedDecrypter(-5083987812580881504L).setKey(-3854887464501840420L);
    SimpleLongDecrypter.getCachedDecrypter(-4839853877362326973L).setKey(-7851623861575359161L);
    SimpleLongDecrypter.getCachedDecrypter(6051409221658586076L).setKey(-8174520752982852966L);
    SimpleLongDecrypter.getCachedDecrypter(-7053192767193379417L).setKey(7228871490929218391L);
    SimpleLongDecrypter.getCachedDecrypter(7087885712825740921L).setKey(-4642146072405099263L);
    SimpleLongDecrypter.getCachedDecrypter(9198359700029533509L).setKey(-3582488946442218747L);
    SimpleLongDecrypter.getCachedDecrypter(6197066289971735430L).setKey(1963327754621922595L);
    SimpleLongDecrypter.getCachedDecrypter(8367147020078322784L).setKey(8020823304357443815L);
    SimpleLongDecrypter.getCachedDecrypter(-4059917539926316191L).setKey(5238757581269424514L);
    SimpleLongDecrypter.getCachedDecrypter(5790033356174775162L).setKey(-1049478880769038926L);
    SimpleLongDecrypter.getCachedDecrypter(-7029516013430739842L).setKey(-8197861715204381356L);
    SimpleLongDecrypter.getCachedDecrypter(-8870507779408932471L).setKey(-5015881140769148769L);
    SimpleLongDecrypter.getCachedDecrypter(3356153231291485938L).setKey(-3267244054459801993L);
    SimpleLongDecrypter.getCachedDecrypter(553510858741317190L).setKey(-3687319803537396385L);
    SimpleLongDecrypter.getCachedDecrypter(4757019121774831358L).setKey(-2770115161060071899L);
    SimpleLongDecrypter.getCachedDecrypter(7713324080395283235L).setKey(3542637095508985393L);
    SimpleLongDecrypter.getCachedDecrypter(-8085072641933472209L).setKey(7078541099080050547L);
    SimpleLongDecrypter.getCachedDecrypter(3682995351079955764L).setKey(6314626824209940583L);
    SimpleLongDecrypter.getCachedDecrypter(4088918555403439586L).setKey(1877001619987203907L);
    SimpleLongDecrypter.getCachedDecrypter(-2038303653132148006L).setKey(-8911731737818095064L);
    SimpleLongDecrypter.getCachedDecrypter(2970990859168661495L).setKey(-2206159570730005594L);
    SimpleLongDecrypter.getCachedDecrypter(-8306542014618848471L).setKey(8524537957858968788L);
    SimpleLongDecrypter.getCachedDecrypter(-7830983871925325899L).setKey(5612120122470873479L);
    SimpleLongDecrypter.getCachedDecrypter(1491393150322288743L).setKey(-4241145648422874899L);
    SimpleLongDecrypter.getCachedDecrypter(3034063718906246598L).setKey(-308760627914444278L);
    SimpleLongDecrypter.getCachedDecrypter(7119876424174366611L).setKey(8736767835390179261L);
    SimpleLongDecrypter.getCachedDecrypter(-7513896388190627559L).setKey(-8833448505901574622L);
    SimpleLongDecrypter.getCachedDecrypter(-243575494872819652L).setKey(2485997611689093065L);
    SimpleLongDecrypter.getCachedDecrypter(5328464182322888316L).setKey(-5545624413494394526L);
    SimpleLongDecrypter.getCachedDecrypter(7195595308003417022L).setKey(7604041555547444104L);
    SimpleLongDecrypter.getCachedDecrypter(2735093867943569963L).setKey(5987633069341593379L);
    SimpleLongDecrypter.getCachedDecrypter(-5522727284711942065L).setKey(-5153781108635070723L);
    SimpleLongDecrypter.getCachedDecrypter(-4811947568823328509L).setKey(-3381721700901303362L);
    SimpleLongDecrypter.getCachedDecrypter(7578450300785475903L).setKey(-1151438862269878216L);
    SimpleLongDecrypter.getCachedDecrypter(5319862677760806985L).setKey(4843111493898979064L);
    SimpleLongDecrypter.getCachedDecrypter(616390909775562686L).setKey(6875388028785383657L);
    SimpleLongDecrypter.getCachedDecrypter(6349839109125752438L).setKey(-4691534370880811309L);
    SimpleLongDecrypter.getCachedDecrypter(2789367059394943687L).setKey(-4362544815501862132L);
    SimpleLongDecrypter.getCachedDecrypter(-8410095282441183611L).setKey(6776280544681839747L);
    SimpleLongDecrypter.getCachedDecrypter(-4507464542748680082L).setKey(-4415547420811532204L);
    SimpleLongDecrypter.getCachedDecrypter(4291266484617113993L).setKey(3488995679885672584L);
    SimpleLongDecrypter.getCachedDecrypter(-986395328542316374L).setKey(2388151549749529475L);
    SimpleLongDecrypter.getCachedDecrypter(6149747944907668996L).setKey(-3030765248264331739L);
    SimpleLongDecrypter.getCachedDecrypter(-9111714066571086514L).setKey(-2365288748438029746L);
    SimpleLongDecrypter.getCachedDecrypter(559088752292037456L).setKey(1410589621783212147L);
    SimpleLongDecrypter.getCachedDecrypter(3053177927180100575L).setKey(6487593570387913520L);
    SimpleLongDecrypter.getCachedDecrypter(-5543647235929449099L).setKey(5737827019580563788L);
    SimpleLongDecrypter.getCachedDecrypter(9130762650109052560L).setKey(3818132122169066590L);
    SimpleLongDecrypter.getCachedDecrypter(5284633206502959560L).setKey(4466911888926018020L);
    SimpleLongDecrypter.getCachedDecrypter(8645278047529341764L).setKey(3640179500357223803L);
    SimpleLongDecrypter.getCachedDecrypter(2081459585562574697L).setKey(34234918505649974L);
    SimpleLongDecrypter.getCachedDecrypter(1342132493783655645L).setKey(9069052144564426L);
    SimpleLongDecrypter.getCachedDecrypter(-8501016620130471140L).setKey(-2093733922246983236L);
    SimpleLongDecrypter.getCachedDecrypter(-4153042696313686419L).setKey(8263576327630510485L);
    SimpleLongDecrypter.getCachedDecrypter(1494089664813120997L).setKey(-7132539552746358896L);
    SimpleLongDecrypter.getCachedDecrypter(5080199753026011837L).setKey(3095136691560184602L);
    SimpleLongDecrypter.getCachedDecrypter(16608723268770980L).setKey(1137810584512396499L);
    SimpleLongDecrypter.getCachedDecrypter(5153146355562193749L).setKey(5287731183817839784L);
    SimpleLongDecrypter.getCachedDecrypter(2867565265961688735L).setKey(-7139700341815376231L);
    SimpleLongDecrypter.getCachedDecrypter(6177928385028660644L).setKey(939881984926066978L);
    SimpleLongDecrypter.getCachedDecrypter(8471609844558590347L).setKey(-672681973275207783L);
    SimpleLongDecrypter.getCachedDecrypter(-3545464524489266916L).setKey(-5930960237497032969L);
    SimpleLongDecrypter.getCachedDecrypter(4478360924930527182L).setKey(7936763337768453536L);
    SimpleLongDecrypter.getCachedDecrypter(-4985412563720594230L).setKey(3121755810022315641L);
    SimpleLongDecrypter.getCachedDecrypter(-3161026748002981923L).setKey(-897725736057918653L);
    SimpleLongDecrypter.getCachedDecrypter(-4763005170945720657L).setKey(-7042343202779209728L);
    SimpleLongDecrypter.getCachedDecrypter(6402385875819598766L).setKey(873217072098415237L);
    SimpleLongDecrypter.getCachedDecrypter(-3359558043183580034L).setKey(-8619662574410015615L);
    SimpleLongDecrypter.getCachedDecrypter(-403903606079965520L).setKey(1062087173940011531L);
    SimpleLongDecrypter.getCachedDecrypter(-7132901453153710149L).setKey(223840657721807527L);
    SimpleLongDecrypter.getCachedDecrypter(1141205279245454017L).setKey(-4311864606206114595L);
    SimpleLongDecrypter.getCachedDecrypter(-4573177370279440571L).setKey(-738678821952340278L);
    SimpleLongDecrypter.getCachedDecrypter(-1135865726029858509L).setKey(8521001616540071106L);
    SimpleLongDecrypter.getCachedDecrypter(-7995747426049998656L).setKey(5176124284875883007L);
    SimpleLongDecrypter.getCachedDecrypter(7508545416114263638L).setKey(-6838857994931355476L);
    SimpleLongDecrypter.getCachedDecrypter(9018743516188961734L).setKey(319900349794720531L);
    SimpleLongDecrypter.getCachedDecrypter(7508325380580666960L).setKey(6701007493158169420L);
    SimpleLongDecrypter.getCachedDecrypter(91244122535102324L).setKey(-5457583028750809345L);
    SimpleLongDecrypter.getCachedDecrypter(6806378469671062843L).setKey(-4018080649806116220L);
    SimpleLongDecrypter.getCachedDecrypter(2902862355872814666L).setKey(-2525736692250709752L);
    SimpleLongDecrypter.getCachedDecrypter(-1075304148098156889L).setKey(-9114534431912181063L);
    SimpleLongDecrypter.getCachedDecrypter(-4732465165271718304L).setKey(2301741392306734647L);
    SimpleLongDecrypter.getCachedDecrypter(4487743330225993967L).setKey(7755401045563739190L);
    SimpleLongDecrypter.getCachedDecrypter(5847509116838151108L).setKey(-8506530899977190750L);
    SimpleLongDecrypter.getCachedDecrypter(8125352643235871781L).setKey(7172964443480818642L);
    SimpleLongDecrypter.getCachedDecrypter(7963447177994234840L).setKey(-3602532203367991675L);
    SimpleLongDecrypter.getCachedDecrypter(-7214822490065015450L).setKey(7649500819560441347L);
    SimpleLongDecrypter.getCachedDecrypter(2188365048060007339L).setKey(-4278269408355038456L);
    SimpleLongDecrypter.getCachedDecrypter(5131142061315535855L).setKey(6744401344625341381L);
    SimpleLongDecrypter.getCachedDecrypter(-7941384629271954926L).setKey(-2524289573446709520L);
    SimpleLongDecrypter.getCachedDecrypter(-6811259281079804436L).setKey(-84363381378959713L);
    SimpleLongDecrypter.getCachedDecrypter(-330518799265874019L).setKey(185547651645245043L);
    SimpleLongDecrypter.getCachedDecrypter(3696190363833076773L).setKey(1291092092990842175L);
    SimpleLongDecrypter.getCachedDecrypter(-6832401113740752531L).setKey(-304298645352630135L);
    SimpleLongDecrypter.getCachedDecrypter(103486084864841568L).setKey(-5539849838937157537L);
    SimpleLongDecrypter.getCachedDecrypter(-3204322537360853749L).setKey(-2068724526687298157L);
    SimpleLongDecrypter.getCachedDecrypter(-2522988169619304033L).setKey(6093557092096524670L);
    SimpleLongDecrypter.getCachedDecrypter(-4908556449281647784L).setKey(6578833601020535537L);
    SimpleLongDecrypter.getCachedDecrypter(707878424125040710L).setKey(-3619244332821224553L);
    SimpleLongDecrypter.getCachedDecrypter(-8682012744125527140L).setKey(7157854746712316645L);
    SimpleLongDecrypter.getCachedDecrypter(3858191867602497805L).setKey(-8658382100164619490L);
    SimpleLongDecrypter.getCachedDecrypter(2423983371813549536L).setKey(3819210035265690495L);
    SimpleLongDecrypter.getCachedDecrypter(-1950324813262331796L).setKey(-2621469945962427827L);
    SimpleLongDecrypter.getCachedDecrypter(-8585060829932164966L).setKey(-7572193738953023683L);
    SimpleLongDecrypter.getCachedDecrypter(-8852348507668258676L).setKey(1381926162094471757L);
    SimpleLongDecrypter.getCachedDecrypter(692834785271118355L).setKey(7920691992869115962L);
    SimpleLongDecrypter.getCachedDecrypter(4213570349755028989L).setKey(-8435044750766632291L);
    SimpleLongDecrypter.getCachedDecrypter(-6845489943236485808L).setKey(-6765906893997239437L);
    SimpleLongDecrypter.getCachedDecrypter(1204314650524263009L).setKey(-4328124686456961446L);
    SimpleLongDecrypter.getCachedDecrypter(7511555625792019208L).setKey(4519571490049820621L);
    SimpleLongDecrypter.getCachedDecrypter(2060917874517897443L).setKey(-6331524104214377746L);
    SimpleLongDecrypter.getCachedDecrypter(6042633630691091680L).setKey(-1507167172915905193L);
    SimpleLongDecrypter.getCachedDecrypter(710930490514193468L).setKey(-6194075692724069755L);
    SimpleLongDecrypter.getCachedDecrypter(4137583897110417195L).setKey(41767289087843420L);
    SimpleLongDecrypter.getCachedDecrypter(-3563297245487682559L).setKey(-9164367170209385956L);
    SimpleLongDecrypter.getCachedDecrypter(1010317781559844741L).setKey(5123557547472860654L);
    SimpleLongDecrypter.getCachedDecrypter(-3201759967231157732L).setKey(3668638251437591720L);
    SimpleLongDecrypter.getCachedDecrypter(5967525028915117640L).setKey(-2718391164982752984L);
    SimpleLongDecrypter.getCachedDecrypter(-3846596886708919529L).setKey(-8691256941058216002L);
    SimpleLongDecrypter.getCachedDecrypter(-5502511215205001497L).setKey(-4286640380405450748L);
    SimpleLongDecrypter.getCachedDecrypter(-9163797127234069966L).setKey(-5131321007563057839L);
    SimpleLongDecrypter.getCachedDecrypter(-7193473175480199996L).setKey(3761533704670086197L);
    SimpleLongDecrypter.getCachedDecrypter(5996076321536045046L).setKey(4777646200094957005L);
    SimpleLongDecrypter.getCachedDecrypter(-8900651321676042990L).setKey(-3461478812613615033L);
    SimpleLongDecrypter.getCachedDecrypter(8673066227904742234L).setKey(7309671642007147883L);
    SimpleLongDecrypter.getCachedDecrypter(-4841676172144064799L).setKey(-1101475174258121439L);
    SimpleLongDecrypter.getCachedDecrypter(6798754856889214168L).setKey(-2145929754267211071L);
    SimpleLongDecrypter.getCachedDecrypter(7720211022714593934L).setKey(7362482698514474927L);
    SimpleLongDecrypter.getCachedDecrypter(-5757433565370216999L).setKey(5085157151515673604L);
    SimpleLongDecrypter.getCachedDecrypter(2137508799098059478L).setKey(-4175088789097081578L);
    SimpleLongDecrypter.getCachedDecrypter(4154086778264762275L).setKey(-8161453803042582136L);
    SimpleLongDecrypter.getCachedDecrypter(2893701482512225910L).setKey(-170232597226645854L);
    SimpleLongDecrypter.getCachedDecrypter(-8741288781124838997L).setKey(-1373462440697696612L);
    SimpleLongDecrypter.getCachedDecrypter(7767894503786834360L).setKey(-4859210916330296715L);
    SimpleLongDecrypter.getCachedDecrypter(5364449083553992975L).setKey(1491718456991617394L);
    SimpleLongDecrypter.getCachedDecrypter(664886368070515421L).setKey(4863209867214980232L);
    SimpleLongDecrypter.getCachedDecrypter(-7247942375985573405L).setKey(2724327933231667638L);
    SimpleLongDecrypter.getCachedDecrypter(-3738887881752877854L).setKey(-5394738623484549309L);
    SimpleLongDecrypter.getCachedDecrypter(5187746192940792680L).setKey(-3957737426782876461L);
    SimpleLongDecrypter.getCachedDecrypter(8588417364159177616L).setKey(4543184953254812431L);
    SimpleLongDecrypter.getCachedDecrypter(-6285295072341674691L).setKey(-9176931223414050841L);
    SimpleLongDecrypter.getCachedDecrypter(-4865767967187366309L).setKey(-9115978210625611799L);
    SimpleLongDecrypter.getCachedDecrypter(-5543188363817849267L).setKey(-6605343050932205377L);
    SimpleLongDecrypter.getCachedDecrypter(-6013075677996430232L).setKey(-5665928925014211131L);
    SimpleLongDecrypter.getCachedDecrypter(1423741846829611548L).setKey(-7875346913365175942L);
    SimpleLongDecrypter.getCachedDecrypter(7205055042732216573L).setKey(4139457288075244387L);
    SimpleLongDecrypter.getCachedDecrypter(-3301372411445132613L).setKey(-2359050353798792708L);
    SimpleLongDecrypter.getCachedDecrypter(8205826689295462307L).setKey(7813295364877386597L);
    SimpleLongDecrypter.getCachedDecrypter(2337477378317786943L).setKey(-6361186292191359917L);
    SimpleLongDecrypter.getCachedDecrypter(7542545945419412957L).setKey(7232297885079975938L);
    SimpleLongDecrypter.getCachedDecrypter(3022634348089875093L).setKey(-5574095415477552804L);
    SimpleLongDecrypter.getCachedDecrypter(-1211950234131756040L).setKey(-3639589961803174731L);
    SimpleLongDecrypter.getCachedDecrypter(4572276498822595247L).setKey(8397902500516684740L);
    SimpleLongDecrypter.getCachedDecrypter(-6021588311837726220L).setKey(-8367097660907191608L);
    SimpleLongDecrypter.getCachedDecrypter(927432308726968895L).setKey(2718614723948810818L);
    SimpleLongDecrypter.getCachedDecrypter(-8743701098223685371L).setKey(-411367705040640741L);
    SimpleLongDecrypter.getCachedDecrypter(3401072904693765963L).setKey(1581970829575878967L);
    SimpleLongDecrypter.getCachedDecrypter(-3593841255774166813L).setKey(9036395258498541958L);
    SimpleLongDecrypter.getCachedDecrypter(5655497945420960435L).setKey(3280761738315325620L);
    SimpleLongDecrypter.getCachedDecrypter(3451528363397551220L).setKey(1385701810749549684L);
    SimpleLongDecrypter.getCachedDecrypter(-8124310843722276083L).setKey(-4221393994085230398L);
    SimpleLongDecrypter.getCachedDecrypter(-4537344967028902489L).setKey(-2349086648399652936L);
    SimpleLongDecrypter.getCachedDecrypter(-1415726187869861678L).setKey(1709163711827794540L);
    SimpleLongDecrypter.getCachedDecrypter(-7353170174364305238L).setKey(-2611024459872772007L);
    SimpleLongDecrypter.getCachedDecrypter(9085864427344729974L).setKey(-460924340338527585L);
    SimpleLongDecrypter.getCachedDecrypter(-5506465104675748323L).setKey(-5087100946835179409L);
    SimpleLongDecrypter.getCachedDecrypter(-2778288852866610944L).setKey(-4183060737834863247L);
    SimpleLongDecrypter.getCachedDecrypter(5182787340757636756L).setKey(-8538748766244671252L);
    SimpleLongDecrypter.getCachedDecrypter(2798502748566405868L).setKey(-2223162749747782252L);
    SimpleLongDecrypter.getCachedDecrypter(4963483220993702651L).setKey(-4901612984725431890L);
    SimpleLongDecrypter.getCachedDecrypter(5595708620569246508L).setKey(5982057159227242530L);
    SimpleLongDecrypter.getCachedDecrypter(7934292517770034513L).setKey(5592054598300383760L);
    SimpleLongDecrypter.getCachedDecrypter(566061993988877962L).setKey(-8662192434919098264L);
    SimpleLongDecrypter.getCachedDecrypter(1659084041903248094L).setKey(-3902301149871444946L);
    SimpleLongDecrypter.getCachedDecrypter(1858734089467413525L).setKey(-8956037845510430248L);
    SimpleLongDecrypter.getCachedDecrypter(-8947884264741190428L).setKey(8157686783994766571L);
    SimpleLongDecrypter.getCachedDecrypter(2875524495390645943L).setKey(-1697386577286525028L);
    SimpleLongDecrypter.getCachedDecrypter(2525117424803823566L).setKey(-2664457804279759243L);
    SimpleLongDecrypter.getCachedDecrypter(6256958164154952993L).setKey(4006034500095606312L);
    SimpleLongDecrypter.getCachedDecrypter(-5044242503040042633L).setKey(1404661701620525923L);
    SimpleLongDecrypter.getCachedDecrypter(-8508633083400952412L).setKey(3059558538256952488L);
    SimpleLongDecrypter.getCachedDecrypter(9092359654545383665L).setKey(-3315868476120704846L);
    SimpleLongDecrypter.getCachedDecrypter(3901894922309817351L).setKey(7154029165040332154L);
    SimpleLongDecrypter.getCachedDecrypter(4748476702081036812L).setKey(1873198700126652342L);
    SimpleLongDecrypter.getCachedDecrypter(1463385434931312017L).setKey(-3008815825764124687L);
    SimpleLongDecrypter.getCachedDecrypter(-3897562251607760738L).setKey(1686211401544119430L);
    SimpleLongDecrypter.getCachedDecrypter(4240679358481454709L).setKey(-6802840482178074326L);
    SimpleLongDecrypter.getCachedDecrypter(1728377775206921038L).setKey(-3318650037001057367L);
    SimpleLongDecrypter.getCachedDecrypter(2903465266454951086L).setKey(-7603674104654525036L);
    SimpleLongDecrypter.getCachedDecrypter(1541060936725389449L).setKey(-6779000842373516061L);
    SimpleLongDecrypter.getCachedDecrypter(-6555703628364437722L).setKey(6196073128903427994L);
    SimpleLongDecrypter.getCachedDecrypter(-6170838684218707658L).setKey(5001498739289601398L);
    SimpleLongDecrypter.getCachedDecrypter(-2625755662750373389L).setKey(-1179437030280534770L);
    SimpleLongDecrypter.getCachedDecrypter(-5525714013545269119L).setKey(-890799650959200034L);
    SimpleLongDecrypter.getCachedDecrypter(2605654333647180296L).setKey(-5398327007729063264L);
    SimpleLongDecrypter.getCachedDecrypter(-3971966066202463083L).setKey(-3585565487660867922L);
    SimpleLongDecrypter.getCachedDecrypter(4967998242959421720L).setKey(-7666274264012395615L);
    SimpleLongDecrypter.getCachedDecrypter(-7292525398660242303L).setKey(-2715262959826928969L);
    SimpleLongDecrypter.getCachedDecrypter(5047783153840916203L).setKey(-7616244529428534067L);
    SimpleLongDecrypter.getCachedDecrypter(-7587991283979786360L).setKey(-5850224151646231849L);
    SimpleLongDecrypter.getCachedDecrypter(1714684839975473469L).setKey(2225896271418347649L);
    SimpleLongDecrypter.getCachedDecrypter(1912590090813351365L).setKey(-716858701942635474L);
    SimpleLongDecrypter.getCachedDecrypter(8779269585824015007L).setKey(-8061142262920290430L);
    SimpleLongDecrypter.getCachedDecrypter(-1095661383049806117L).setKey(-2543722666890627114L);
    SimpleLongDecrypter.getCachedDecrypter(-4028650048823538148L).setKey(8759774189160679296L);
    SimpleLongDecrypter.getCachedDecrypter(-7312916550180035921L).setKey(3444925346543457680L);
    SimpleLongDecrypter.getCachedDecrypter(2799375107147803074L).setKey(2186702452993096399L);
    SimpleLongDecrypter.getCachedDecrypter(-1980199650843658975L).setKey(-2823014427137545882L);
    SimpleLongDecrypter.getCachedDecrypter(-129478623394363359L).setKey(-7325001785309156757L);
    SimpleLongDecrypter.getCachedDecrypter(4197886343753747205L).setKey(-9128041982828608381L);
    SimpleLongDecrypter.getCachedDecrypter(5373454224974185000L).setKey(2229169089541482307L);
    SimpleLongDecrypter.getCachedDecrypter(661751168714911210L).setKey(-7631551459232019907L);
    SimpleLongDecrypter.getCachedDecrypter(7669731067240236419L).setKey(8036969672273417714L);
    SimpleLongDecrypter.getCachedDecrypter(-6811376340518551758L).setKey(3606426324652962970L);
    SimpleLongDecrypter.getCachedDecrypter(-9167186239536708054L).setKey(-6062990904116885184L);
    SimpleLongDecrypter.getCachedDecrypter(-4716984406249995446L).setKey(-3706767889775215009L);
    SimpleLongDecrypter.getCachedDecrypter(2368441159022925182L).setKey(6590496414655077578L);
    SimpleLongDecrypter.getCachedDecrypter(4686431100186309612L).setKey(-6432564661302543709L);
    SimpleLongDecrypter.getCachedDecrypter(-7048626659775594689L).setKey(-6471445024688664505L);
    SimpleLongDecrypter.getCachedDecrypter(5798179085679334343L).setKey(-7416644461233041359L);
    SimpleLongDecrypter.getCachedDecrypter(832395647808444863L).setKey(343912523240318692L);
    SimpleLongDecrypter.getCachedDecrypter(6038801730063991826L).setKey(-8403647840991693563L);
    SimpleLongDecrypter.getCachedDecrypter(-6143915884461729557L).setKey(-3166398704089068630L);
    SimpleLongDecrypter.getCachedDecrypter(-4576862672741050387L).setKey(2636486389674961254L);
    SimpleLongDecrypter.getCachedDecrypter(8672122458423636592L).setKey(3708184149068066619L);
    SimpleLongDecrypter.getCachedDecrypter(507654040706337441L).setKey(-4416954414115674970L);
    SimpleLongDecrypter.getCachedDecrypter(6968008378745662073L).setKey(3407674021839006376L);
    SimpleLongDecrypter.getCachedDecrypter(3408467920169547397L).setKey(-51190193265318808L);
    SimpleLongDecrypter.getCachedDecrypter(-8668106289515993190L).setKey(-5084969502381986530L);
    SimpleLongDecrypter.getCachedDecrypter(-8836186528503066514L).setKey(3385616747164001392L);
    SimpleLongDecrypter.getCachedDecrypter(7102066860397301752L).setKey(-1885051626109354046L);
    SimpleLongDecrypter.getCachedDecrypter(-6993832109119472732L).setKey(-6773534165661395836L);
    SimpleLongDecrypter.getCachedDecrypter(2206557733545496955L).setKey(-6671676208086798134L);
    SimpleLongDecrypter.getCachedDecrypter(3785442395526820618L).setKey(-3580166363716801239L);
    SimpleLongDecrypter.getCachedDecrypter(-8808245648092267035L).setKey(1857072894702790786L);
    SimpleLongDecrypter.getCachedDecrypter(4292113854973194115L).setKey(2910675341642846362L);
    SimpleLongDecrypter.getCachedDecrypter(-2245590007159606673L).setKey(-1944677701928492932L);
    SimpleLongDecrypter.getCachedDecrypter(2431056818857040612L).setKey(3650682085104476464L);
    SimpleLongDecrypter.getCachedDecrypter(-2200840168952866270L).setKey(300758068870578185L);
    SimpleLongDecrypter.getCachedDecrypter(-1851969932807775962L).setKey(-1668444797577881415L);
    SimpleLongDecrypter.getCachedDecrypter(799909612779804135L).setKey(-3527932724561553944L);
    SimpleLongDecrypter.getCachedDecrypter(-4457670491146406544L).setKey(-1042354561162650508L);
    SimpleLongDecrypter.getCachedDecrypter(6113842012534027006L).setKey(2545448416499731209L);
    SimpleLongDecrypter.getCachedDecrypter(1742653509539466969L).setKey(8377918569444092731L);
    SimpleLongDecrypter.getCachedDecrypter(-4433616906069315453L).setKey(8700271987213325490L);
    SimpleLongDecrypter.getCachedDecrypter(5048992504185414320L).setKey(-7899039639597206912L);
    SimpleLongDecrypter.getCachedDecrypter(-6766392492109753948L).setKey(4426785990868149567L);
    SimpleLongDecrypter.getCachedDecrypter(1124027588226919294L).setKey(3017038289803600718L);
    SimpleLongDecrypter.getCachedDecrypter(-1112791354944908863L).setKey(6896498820390254764L);
    SimpleLongDecrypter.getCachedDecrypter(30455977399061676L).setKey(521819844431010898L);
    SimpleLongDecrypter.getCachedDecrypter(-2507745883339726256L).setKey(-5683366207754194971L);
    SimpleLongDecrypter.getCachedDecrypter(4304488152353087751L).setKey(-4647486559119827747L);
    SimpleLongDecrypter.getCachedDecrypter(-5701856300808750738L).setKey(7445180925040050416L);
    SimpleLongDecrypter.getCachedDecrypter(-3255149582356588165L).setKey(4113645486948669718L);
    SimpleLongDecrypter.getCachedDecrypter(-197461148448453461L).setKey(-1207006476226685315L);
    SimpleLongDecrypter.getCachedDecrypter(6521822959928089977L).setKey(8413889411545685683L);
    SimpleLongDecrypter.getCachedDecrypter(5180810144194256891L).setKey(-3570266821777261622L);
    SimpleLongDecrypter.getCachedDecrypter(2368611677932603933L).setKey(-6854526705115882649L);
    SimpleLongDecrypter.getCachedDecrypter(-1645268313044409559L).setKey(4280698580289619457L);
    SimpleLongDecrypter.getCachedDecrypter(-7685580722440196500L).setKey(-8091287444911147458L);
    SimpleLongDecrypter.getCachedDecrypter(8001111816110344958L).setKey(-3016048523774306067L);
    SimpleLongDecrypter.getCachedDecrypter(1958521076846376274L).setKey(-7779212068647939216L);
    SimpleLongDecrypter.getCachedDecrypter(-8459901781208225351L).setKey(-2874847859748686226L);
    SimpleLongDecrypter.getCachedDecrypter(-3119200894918836522L).setKey(5073039803146027246L);
    SimpleLongDecrypter.getCachedDecrypter(7412871936695043836L).setKey(-8950252696893113518L);
    SimpleLongDecrypter.getCachedDecrypter(-604920190624968834L).setKey(5635068743836389782L);
    SimpleLongDecrypter.getCachedDecrypter(-167919062203213751L).setKey(-7874815411735151779L);
    SimpleLongDecrypter.getCachedDecrypter(655212059839436281L).setKey(-4532118110773788564L);
    SimpleLongDecrypter.getCachedDecrypter(6193026249662086205L).setKey(413286951967537828L);
    SimpleLongDecrypter.getCachedDecrypter(-4932513801152294861L).setKey(-8585026686307581163L);
    SimpleLongDecrypter.getCachedDecrypter(-511661253293433431L).setKey(743144716705680274L);
    SimpleLongDecrypter.getCachedDecrypter(6111273977187070425L).setKey(-8756001649529777604L);
    SimpleLongDecrypter.getCachedDecrypter(6012002358558966423L).setKey(4619287038221867218L);
    SimpleLongDecrypter.getCachedDecrypter(-2798148038980097926L).setKey(-6525513242857925485L);
    SimpleLongDecrypter.getCachedDecrypter(-8884691471570332463L).setKey(-743975905557150815L);
    SimpleLongDecrypter.getCachedDecrypter(-2526398118488923853L).setKey(7946275066519700908L);
    SimpleLongDecrypter.getCachedDecrypter(2539011694663758330L).setKey(-6264818470398851290L);
    SimpleLongDecrypter.getCachedDecrypter(-376989407664483086L).setKey(-5392989214098056439L);
    SimpleLongDecrypter.getCachedDecrypter(194234108647378075L).setKey(5485494974060232616L);
    SimpleLongDecrypter.getCachedDecrypter(645499127770190502L).setKey(-8713038685572612378L);
    SimpleLongDecrypter.getCachedDecrypter(-1825888034428342229L).setKey(-299808820020923688L);
    SimpleLongDecrypter.getCachedDecrypter(-6932961751183513202L).setKey(-7691305110407775126L);
    SimpleLongDecrypter.getCachedDecrypter(-1077551196950386872L).setKey(-6754689899445947954L);
    SimpleLongDecrypter.getCachedDecrypter(2847482374656485979L).setKey(-3726862211747996212L);
    SimpleLongDecrypter.getCachedDecrypter(-179571823836923311L).setKey(2232219532251331133L);
    SimpleLongDecrypter.getCachedDecrypter(797333857057254951L).setKey(7071709975424457803L);
    SimpleLongDecrypter.getCachedDecrypter(1457817196285770984L).setKey(3553679987007694279L);
    SimpleLongDecrypter.getCachedDecrypter(-3704314660701640239L).setKey(-5841788784052411592L);
    SimpleLongDecrypter.getCachedDecrypter(-201083070910374780L).setKey(4809623196485650828L);
    SimpleLongDecrypter.getCachedDecrypter(6095307921512293514L).setKey(-5588208218398677923L);
    SimpleLongDecrypter.getCachedDecrypter(-2898816967910471384L).setKey(8780267488213535984L);
    SimpleLongDecrypter.getCachedDecrypter(-5754550838628715434L).setKey(-2914565267681081691L);
    SimpleLongDecrypter.getCachedDecrypter(2777379061751226346L).setKey(-4137440002879648166L);
    SimpleLongDecrypter.getCachedDecrypter(-6363660721610493683L).setKey(4539102929984171675L);
    SimpleLongDecrypter.getCachedDecrypter(-2082646068343044551L).setKey(1100353367243653074L);
    SimpleLongDecrypter.getCachedDecrypter(9064223851557609438L).setKey(-4114277977638425840L);
    SimpleLongDecrypter.getCachedDecrypter(-8874305497589264404L).setKey(-5866685905965883231L);
    SimpleLongDecrypter.getCachedDecrypter(-7336904156043519981L).setKey(4558475917592338750L);
    SimpleLongDecrypter.getCachedDecrypter(-5174105977788999131L).setKey(938705388437501356L);
    SimpleLongDecrypter.getCachedDecrypter(-4530149770929394489L).setKey(-6348384361509434061L);
    SimpleLongDecrypter.getCachedDecrypter(3963375769228025598L).setKey(-2858673909960860439L);
    SimpleLongDecrypter.getCachedDecrypter(-9055825500420793714L).setKey(3659340037148811353L);
    SimpleLongDecrypter.getCachedDecrypter(801972426697468357L).setKey(1651804631845775796L);
    SimpleLongDecrypter.getCachedDecrypter(-8532194282700910261L).setKey(1597051230631232869L);
    SimpleLongDecrypter.getCachedDecrypter(1628278515014687184L).setKey(2712601616158898945L);
    SimpleLongDecrypter.getCachedDecrypter(-6974044591253583409L).setKey(-1489716486634179263L);
    SimpleLongDecrypter.getCachedDecrypter(-1103876810463568064L).setKey(-2692490746300101490L);
    SimpleLongDecrypter.getCachedDecrypter(2582057426271092736L).setKey(8009768165651394354L);
    SimpleLongDecrypter.getCachedDecrypter(6255512141274012271L).setKey(4367373822131412955L);
    SimpleLongDecrypter.getCachedDecrypter(5681710145529351350L).setKey(6338476167454209674L);
    SimpleLongDecrypter.getCachedDecrypter(1241678293727710259L).setKey(870033428329686775L);
    SimpleLongDecrypter.getCachedDecrypter(8497506925578285438L).setKey(-4188303581095699978L);
    SimpleLongDecrypter.getCachedDecrypter(-7775646392250863559L).setKey(-6870970025921030672L);
    SimpleLongDecrypter.getCachedDecrypter(-5244750823034210506L).setKey(-3017873056794943943L);
    SimpleLongDecrypter.getCachedDecrypter(1597308826578142055L).setKey(5415100557689568404L);
    SimpleLongDecrypter.getCachedDecrypter(5272152424182884429L).setKey(6795550413020788385L);
    SimpleLongDecrypter.getCachedDecrypter(747025750338791985L).setKey(4459849081908131978L);
    SimpleLongDecrypter.getCachedDecrypter(-2744919426701863945L).setKey(794072747884774307L);
    SimpleLongDecrypter.getCachedDecrypter(-212093283128087923L).setKey(-3805527134229470271L);
    SimpleLongDecrypter.getCachedDecrypter(639105765387001402L).setKey(650165455256124884L);
    SimpleLongDecrypter.getCachedDecrypter(-691178816798631930L).setKey(-438698647729170149L);
    SimpleLongDecrypter.getCachedDecrypter(-6892356351213478672L).setKey(1588127842711648860L);
    SimpleLongDecrypter.getCachedDecrypter(2215572882768835164L).setKey(779487616368435851L);
    SimpleLongDecrypter.getCachedDecrypter(4017482765865910721L).setKey(3721023493201383930L);
    SimpleLongDecrypter.getCachedDecrypter(-4542100751411146608L).setKey(-709988716997533707L);
    SimpleLongDecrypter.getCachedDecrypter(-6768550658772063659L).setKey(-5452762719677307618L);
    SimpleLongDecrypter.getCachedDecrypter(2492307306600875951L).setKey(-1954527672388359376L);
    SimpleLongDecrypter.getCachedDecrypter(7590119284004242150L).setKey(3674254096076090236L);
    SimpleLongDecrypter.getCachedDecrypter(-5442457607328349694L).setKey(369470151555135144L);
    SimpleLongDecrypter.getCachedDecrypter(-5098562949908907432L).setKey(-7015872141430381200L);
    SimpleLongDecrypter.getCachedDecrypter(4323349156429023315L).setKey(1888298218704458294L);
    SimpleLongDecrypter.getCachedDecrypter(-7874768164741068988L).setKey(-2464433809738462954L);
    SimpleLongDecrypter.getCachedDecrypter(-3970308288578104427L).setKey(1534083756198510994L);
    SimpleLongDecrypter.getCachedDecrypter(-5101141037251748487L).setKey(56178153902982324L);
    SimpleLongDecrypter.getCachedDecrypter(7189568598758626780L).setKey(87931131190249007L);
    SimpleLongDecrypter.getCachedDecrypter(-1463260358995568808L).setKey(4345914917452835063L);
    SimpleLongDecrypter.getCachedDecrypter(-5929294695699147395L).setKey(2466031891883531911L);
    SimpleLongDecrypter.getCachedDecrypter(8528252190688409944L).setKey(-6916545330787639894L);
    SimpleLongDecrypter.getCachedDecrypter(-3355847007076748999L).setKey(-8439833302896352634L);
    SimpleLongDecrypter.getCachedDecrypter(4665582870868755387L).setKey(-495875701888325867L);
    SimpleLongDecrypter.getCachedDecrypter(3376915949025706748L).setKey(-4004934404306552952L);
    SimpleLongDecrypter.getCachedDecrypter(-962948944613878177L).setKey(1517126311847850339L);
    SimpleLongDecrypter.getCachedDecrypter(4026424958029452208L).setKey(-5543465467340549692L);
    SimpleLongDecrypter.getCachedDecrypter(2338531806770529894L).setKey(-5008200691652706505L);
    SimpleLongDecrypter.getCachedDecrypter(922020115749962468L).setKey(4765452861764859479L);
    SimpleLongDecrypter.getCachedDecrypter(5355738139947739630L).setKey(6169841520759849602L);
    SimpleLongDecrypter.getCachedDecrypter(4255154029388740298L).setKey(-6450250323687971686L);
    SimpleLongDecrypter.getCachedDecrypter(-4391320878029221421L).setKey(4907142856080637354L);
    SimpleLongDecrypter.getCachedDecrypter(1625459339234679590L).setKey(5652706847893946896L);
    SimpleLongDecrypter.getCachedDecrypter(-3420598883163720694L).setKey(-6803383071672422165L);
    SimpleLongDecrypter.getCachedDecrypter(7444678937459893482L).setKey(-8918055005205759872L);
    SimpleLongDecrypter.getCachedDecrypter(5464153636084904495L).setKey(-1390984442967720633L);
    SimpleLongDecrypter.getCachedDecrypter(-2301432568888831523L).setKey(-844247254678013009L);
    SimpleLongDecrypter.getCachedDecrypter(6993446623865075132L).setKey(7273156305186736482L);
    SimpleLongDecrypter.getCachedDecrypter(-4253940309716343450L).setKey(950273969418128717L);
    SimpleLongDecrypter.getCachedDecrypter(5962222253179206200L).setKey(1642477093945279801L);
    SimpleLongDecrypter.getCachedDecrypter(-5827119113393071779L).setKey(-8488526885326840749L);
    SimpleLongDecrypter.getCachedDecrypter(5160069404031976388L).setKey(-1001694157696750648L);
    SimpleLongDecrypter.getCachedDecrypter(1440567120833582110L).setKey(8881830427256036045L);
    SimpleLongDecrypter.getCachedDecrypter(-9177949358036287008L).setKey(6746655007882539212L);
    SimpleLongDecrypter.getCachedDecrypter(1179311785238657433L).setKey(951734318086548274L);
    SimpleLongDecrypter.getCachedDecrypter(2164215133800982069L).setKey(-1987317363865716482L);
    SimpleLongDecrypter.getCachedDecrypter(3865433491046929311L).setKey(493842138465279462L);
    SimpleLongDecrypter.getCachedDecrypter(-2926205830959165863L).setKey(-6910985841343478937L);
    SimpleLongDecrypter.getCachedDecrypter(-6893856517931929341L).setKey(8163572963702108785L);
    SimpleLongDecrypter.getCachedDecrypter(-4756151241979799495L).setKey(-5722670203612420669L);
    SimpleLongDecrypter.getCachedDecrypter(-5031417536587628329L).setKey(3539643634316818421L);
    SimpleLongDecrypter.getCachedDecrypter(-8063728196650787938L).setKey(-3181580312642502578L);
    SimpleLongDecrypter.getCachedDecrypter(-7685741427500799781L).setKey(509000681892564780L);
    SimpleLongDecrypter.getCachedDecrypter(-8589503111829810798L).setKey(-3746709826201469300L);
    SimpleLongDecrypter.getCachedDecrypter(1026605272194587321L).setKey(-1540102981352066802L);
    SimpleLongDecrypter.getCachedDecrypter(1834079494986373447L).setKey(-6353713501482219491L);
    SimpleLongDecrypter.getCachedDecrypter(-3500251774755870811L).setKey(-8866330539943036220L);
    SimpleLongDecrypter.getCachedDecrypter(5926789938090128640L).setKey(-6302952740431273502L);
    SimpleLongDecrypter.getCachedDecrypter(5570093781269963224L).setKey(-2539170867165848569L);
    SimpleLongDecrypter.getCachedDecrypter(-4413593950337129276L).setKey(-5062165755450312516L);
    SimpleLongDecrypter.getCachedDecrypter(7397085293192115141L).setKey(5290167761754111134L);
    SimpleLongDecrypter.getCachedDecrypter(593536235967428544L).setKey(263431160989975757L);
    SimpleLongDecrypter.getCachedDecrypter(928720371381790844L).setKey(-5458861663351264437L);
    SimpleLongDecrypter.getCachedDecrypter(2147451630644392721L).setKey(-2097470913207858349L);
    SimpleLongDecrypter.getCachedDecrypter(-1208189063975720724L).setKey(-1684333418590497685L);
    SimpleLongDecrypter.getCachedDecrypter(7026852701650966666L).setKey(429321972384452842L);
    SimpleLongDecrypter.getCachedDecrypter(3217200453472323658L).setKey(3686498587188944845L);
    SimpleLongDecrypter.getCachedDecrypter(5143280674850937309L).setKey(-6403874018169243618L);
    SimpleLongDecrypter.getCachedDecrypter(-8868503133950471405L).setKey(550503622373431311L);
    SimpleLongDecrypter.getCachedDecrypter(8830117575883558363L).setKey(-7933414917707794853L);
    SimpleLongDecrypter.getCachedDecrypter(3673074676334204089L).setKey(-3236923994411086973L);
    SimpleLongDecrypter.getCachedDecrypter(8550203807664804593L).setKey(-7358292859042399828L);
    SimpleLongDecrypter.getCachedDecrypter(5212113655951294977L).setKey(-7926519666513738255L);
    SimpleLongDecrypter.getCachedDecrypter(-6978868103316390532L).setKey(7516661392885552006L);
    SimpleLongDecrypter.getCachedDecrypter(6452659029409559674L).setKey(5099306551746343110L);
    SimpleLongDecrypter.getCachedDecrypter(-6067597685705384996L).setKey(1654781762218397283L);
    SimpleLongDecrypter.getCachedDecrypter(-4994544334402439281L).setKey(5043882265283298130L);
    SimpleLongDecrypter.getCachedDecrypter(7511316848194191269L).setKey(7089450387155082374L);
    SimpleLongDecrypter.getCachedDecrypter(8979285194773697681L).setKey(-2945156265340406771L);
    SimpleLongDecrypter.getCachedDecrypter(-7015383164893645554L).setKey(8586198925090511677L);
    SimpleLongDecrypter.getCachedDecrypter(148706894124341009L).setKey(-7436944561123422897L);
    SimpleLongDecrypter.getCachedDecrypter(-4193445458544169262L).setKey(-9149176582374971188L);
    SimpleLongDecrypter.getCachedDecrypter(1888283732290676879L).setKey(4810562716218892595L);
    SimpleLongDecrypter.getCachedDecrypter(8299231841907687858L).setKey(-6489257244006327208L);
    SimpleLongDecrypter.getCachedDecrypter(-924848646441286131L).setKey(-3139924734835666189L);
    SimpleLongDecrypter.getCachedDecrypter(8543323408721615433L).setKey(-690159866065515440L);
    SimpleLongDecrypter.getCachedDecrypter(8102151993213550864L).setKey(-9122495236798429241L);
    SimpleLongDecrypter.getCachedDecrypter(-2266198575319352711L).setKey(1344422970586725390L);
    SimpleLongDecrypter.getCachedDecrypter(1792966486209028545L).setKey(81494410126121301L);
    SimpleLongDecrypter.getCachedDecrypter(-4676946530865761393L).setKey(-7288373758831804191L);
    SimpleLongDecrypter.getCachedDecrypter(4864651802415745619L).setKey(-8663433451788355610L);
    SimpleLongDecrypter.getCachedDecrypter(8933460942542429083L).setKey(2549153637831757542L);
    SimpleLongDecrypter.getCachedDecrypter(-2567622927059121865L).setKey(7348203633593405263L);
    SimpleLongDecrypter.getCachedDecrypter(2343255185386943172L).setKey(7462102340996201329L);
    SimpleLongDecrypter.getCachedDecrypter(-8539352599667624212L).setKey(2368120461431947658L);
    SimpleLongDecrypter.getCachedDecrypter(4926875232935818816L).setKey(-3673431252856600282L);
    SimpleLongDecrypter.getCachedDecrypter(840680886870020403L).setKey(6708842004115248389L);
    SimpleLongDecrypter.getCachedDecrypter(-4925767926864583256L).setKey(8383954722731617570L);
    SimpleLongDecrypter.getCachedDecrypter(504924762447987619L).setKey(-4708153541851695431L);
    SimpleLongDecrypter.getCachedDecrypter(-1582785126012168929L).setKey(-2687689990482017250L);
    SimpleLongDecrypter.getCachedDecrypter(1600850477333762064L).setKey(6341767766247782569L);
    SimpleLongDecrypter.getCachedDecrypter(4677080207504842926L).setKey(1168345289543676105L);
    SimpleLongDecrypter.getCachedDecrypter(-5291553600833031668L).setKey(-4441901259605611246L);
    SimpleLongDecrypter.getCachedDecrypter(4764692602871464907L).setKey(1837551022945911622L);
    SimpleLongDecrypter.getCachedDecrypter(-3864422159141294762L).setKey(-863402602024454484L);
    SimpleLongDecrypter.getCachedDecrypter(-4154212544891822541L).setKey(-3051341282320249702L);
    SimpleLongDecrypter.getCachedDecrypter(-4406565938293078575L).setKey(1630682102008394994L);
    SimpleLongDecrypter.getCachedDecrypter(6538565780687322634L).setKey(-1538109824666937684L);
    SimpleLongDecrypter.getCachedDecrypter(-4755859472231622756L).setKey(-5274201698437293291L);
    SimpleLongDecrypter.getCachedDecrypter(-8039409331502748486L).setKey(8739560974471198751L);
    SimpleLongDecrypter.getCachedDecrypter(5274577398868453537L).setKey(-4363984743525772388L);
    SimpleLongDecrypter.getCachedDecrypter(2629931669005736922L).setKey(-3241375260339264570L);
    SimpleLongDecrypter.getCachedDecrypter(1524997205057252358L).setKey(-5681663587098980590L);
    SimpleLongDecrypter.getCachedDecrypter(4865706909417798119L).setKey(8783333638811187962L);
    SimpleLongDecrypter.getCachedDecrypter(3735702413694503837L).setKey(4556652746429885700L);
    SimpleLongDecrypter.getCachedDecrypter(-2400277445329014214L).setKey(6856245094947725099L);
    SimpleLongDecrypter.getCachedDecrypter(277921651240128572L).setKey(5437128656255165953L);
    SimpleLongDecrypter.getCachedDecrypter(-2555419955992357936L).setKey(9078755238118120784L);
    SimpleLongDecrypter.getCachedDecrypter(-4054214924606981113L).setKey(-2191527579533168871L);
    SimpleLongDecrypter.getCachedDecrypter(-4658608746581299194L).setKey(8317524886485773555L);
    SimpleLongDecrypter.getCachedDecrypter(5113591711377816770L).setKey(7708472526193906832L);
    SimpleLongDecrypter.getCachedDecrypter(-6725422450996003530L).setKey(-2103824943723184953L);
    SimpleLongDecrypter.getCachedDecrypter(3253556778196826955L).setKey(6288474842291548156L);
    SimpleLongDecrypter.getCachedDecrypter(3569257655907658777L).setKey(-3631571162452054098L);
    SimpleLongDecrypter.getCachedDecrypter(3845913155428774742L).setKey(-8648965126488734782L);
    SimpleLongDecrypter.getCachedDecrypter(-1732683378175758701L).setKey(-4762022281019175297L);
    SimpleLongDecrypter.getCachedDecrypter(4845660768628320067L).setKey(4135610284215203345L);
    SimpleLongDecrypter.getCachedDecrypter(431853018132265819L).setKey(-729636242132418861L);
    SimpleLongDecrypter.getCachedDecrypter(4323828518872826203L).setKey(3989674129917274094L);
    SimpleLongDecrypter.getCachedDecrypter(6185812326971848047L).setKey(-4811871076734893508L);
    SimpleLongDecrypter.getCachedDecrypter(-2143663798569263280L).setKey(8654393777154802479L);
    SimpleLongDecrypter.getCachedDecrypter(-4387127247044577505L).setKey(-5493808618719301738L);
    SimpleLongDecrypter.getCachedDecrypter(-6598433110801900376L).setKey(5058357405906878016L);
    SimpleLongDecrypter.getCachedDecrypter(-4453015270862234665L).setKey(-6401026495473431755L);
    SimpleLongDecrypter.getCachedDecrypter(1758595752676755913L).setKey(-6131428416775058851L);
    SimpleLongDecrypter.getCachedDecrypter(562664941005203198L).setKey(-5537490225268801960L);
    SimpleLongDecrypter.getCachedDecrypter(-7212900018564863460L).setKey(3674982222718839622L);
    SimpleLongDecrypter.getCachedDecrypter(5154469842110852495L).setKey(6761636173286845359L);
    SimpleLongDecrypter.getCachedDecrypter(1936008554850977740L).setKey(-5761732593428842681L);
    SimpleLongDecrypter.getCachedDecrypter(6528036029184460956L).setKey(-5303659033955031214L);
    SimpleLongDecrypter.getCachedDecrypter(-4882533568708628657L).setKey(6485059151397739884L);
    SimpleLongDecrypter.getCachedDecrypter(7792485802567423271L).setKey(6459984049556927806L);
    SimpleLongDecrypter.getCachedDecrypter(8299455630416463559L).setKey(-2756777461712236205L);
    SimpleLongDecrypter.getCachedDecrypter(3943135975239856721L).setKey(-7336363427253637615L);
    SimpleLongDecrypter.getCachedDecrypter(-38133250063926130L).setKey(-5050749645565360454L);
    SimpleLongDecrypter.getCachedDecrypter(2264439698137005495L).setKey(-1124754602928877081L);
    SimpleLongDecrypter.getCachedDecrypter(4448384365607032352L).setKey(5707617814314561016L);
    SimpleLongDecrypter.getCachedDecrypter(-1942193125693451349L).setKey(-3183675586075357611L);
    SimpleLongDecrypter.getCachedDecrypter(-2355644483945450476L).setKey(4128685878945977473L);
    SimpleLongDecrypter.getCachedDecrypter(1019957169973950552L).setKey(2107704886512198918L);
    SimpleLongDecrypter.getCachedDecrypter(-3797129426047134672L).setKey(-8763308151789634165L);
    SimpleLongDecrypter.getCachedDecrypter(-3256168868288664318L).setKey(4507762567009879403L);
    SimpleLongDecrypter.getCachedDecrypter(-3220983252011293342L).setKey(5358072593153989546L);
    SimpleLongDecrypter.getCachedDecrypter(5701077892013580254L).setKey(1232059981094839836L);
    SimpleLongDecrypter.getCachedDecrypter(3108847877900056437L).setKey(-8285230245191666833L);
    SimpleLongDecrypter.getCachedDecrypter(3656318993058195316L).setKey(7784573262085045763L);
    SimpleLongDecrypter.getCachedDecrypter(-3980720079687929802L).setKey(-1503146528454977569L);
    SimpleLongDecrypter.getCachedDecrypter(2569848670338099956L).setKey(4698376325080393944L);
    SimpleLongDecrypter.getCachedDecrypter(-7950519690557423525L).setKey(-7994796081710344029L);
    SimpleLongDecrypter.getCachedDecrypter(-3490210623089805114L).setKey(5671074675979131441L);
    SimpleLongDecrypter.getCachedDecrypter(6470630808314153104L).setKey(3328666729515535740L);
    SimpleLongDecrypter.getCachedDecrypter(-3279156259585225373L).setKey(4427364593453170144L);
    SimpleLongDecrypter.getCachedDecrypter(-1625953934345426090L).setKey(2607062175965072507L);
    SimpleLongDecrypter.getCachedDecrypter(-2868516565236901984L).setKey(779278161619649893L);
    SimpleLongDecrypter.getCachedDecrypter(1655401633235102594L).setKey(-852921831407055811L);
    SimpleLongDecrypter.getCachedDecrypter(-462483712531873651L).setKey(4525847143692478033L);
    SimpleLongDecrypter.getCachedDecrypter(-8897328147543140731L).setKey(408238935683196511L);
    SimpleLongDecrypter.getCachedDecrypter(-2834005029965071068L).setKey(-4545931076471432633L);
    SimpleLongDecrypter.getCachedDecrypter(817321519864738352L).setKey(553166662594559082L);
    SimpleLongDecrypter.getCachedDecrypter(1022271696649130981L).setKey(6780417993912893800L);
    SimpleLongDecrypter.getCachedDecrypter(2515224293847387776L).setKey(-5632138848695072128L);
    SimpleLongDecrypter.getCachedDecrypter(-6474857095719986195L).setKey(3858415526386166438L);
    SimpleLongDecrypter.getCachedDecrypter(-2059920558855007961L).setKey(730106599903822477L);
    SimpleLongDecrypter.getCachedDecrypter(-2362878485456883731L).setKey(-6314578571513164730L);
    SimpleLongDecrypter.getCachedDecrypter(-6729977192229253162L).setKey(-8049506591561839837L);
    SimpleLongDecrypter.getCachedDecrypter(1924714014399527081L).setKey(-5631821218232532929L);
    SimpleLongDecrypter.getCachedDecrypter(1015594880122072929L).setKey(-141376425224722602L);
    SimpleLongDecrypter.getCachedDecrypter(-42923258516934206L).setKey(-6412645058582846538L);
    SimpleLongDecrypter.getCachedDecrypter(1329688210463118847L).setKey(-143810738802925080L);
    SimpleLongDecrypter.getCachedDecrypter(-4639673772535878776L).setKey(3293050864049185507L);
    SimpleLongDecrypter.getCachedDecrypter(5374990670502319608L).setKey(1900324247099267931L);
    SimpleLongDecrypter.getCachedDecrypter(6931480389753654225L).setKey(3794760190831709609L);
    SimpleLongDecrypter.getCachedDecrypter(-5330015373253737753L).setKey(-4697145092570154653L);
    SimpleLongDecrypter.getCachedDecrypter(7597384473157990870L).setKey(5203279161839776636L);
    SimpleLongDecrypter.getCachedDecrypter(-700163477294446611L).setKey(7792722538370662397L);
    SimpleLongDecrypter.getCachedDecrypter(411089702141885407L).setKey(5845623374599542701L);
    SimpleLongDecrypter.getCachedDecrypter(8893612174289022211L).setKey(-4695644617656136161L);
    SimpleLongDecrypter.getCachedDecrypter(950513125575587431L).setKey(-707937898433957967L);
    SimpleLongDecrypter.getCachedDecrypter(1927140053614991665L).setKey(-4852506717214059693L);
    SimpleLongDecrypter.getCachedDecrypter(7140407358993954730L).setKey(2449154331669280357L);
    SimpleLongDecrypter.getCachedDecrypter(6665940990393188289L).setKey(-6422187720648918786L);
    SimpleLongDecrypter.getCachedDecrypter(8415902436124249210L).setKey(4850039549306868475L);
    SimpleLongDecrypter.getCachedDecrypter(7713616702209272924L).setKey(2062505471116940534L);
    SimpleLongDecrypter.getCachedDecrypter(-4225938016585701323L).setKey(1272611209935446292L);
    SimpleLongDecrypter.getCachedDecrypter(5793892935044054089L).setKey(-2600729651406248486L);
    SimpleLongDecrypter.getCachedDecrypter(-4598743902237011449L).setKey(-5314913635201686070L);
    SimpleLongDecrypter.getCachedDecrypter(-7530037652973469667L).setKey(-6482807082539338436L);
    SimpleLongDecrypter.getCachedDecrypter(-277614558029051092L).setKey(7763522334266507179L);
    SimpleLongDecrypter.getCachedDecrypter(3418028578278148673L).setKey(-7788492640496168211L);
    SimpleLongDecrypter.getCachedDecrypter(5557234774006585882L).setKey(2329675868102148634L);
    SimpleLongDecrypter.getCachedDecrypter(5769246121261170231L).setKey(3135041060095890337L);
    SimpleLongDecrypter.getCachedDecrypter(-476097865983158305L).setKey(795569666886716L);
    SimpleLongDecrypter.getCachedDecrypter(-9052974663451438393L).setKey(5165021907856575925L);
    SimpleLongDecrypter.getCachedDecrypter(-8202342386172902915L).setKey(956687543838587625L);
    SimpleLongDecrypter.getCachedDecrypter(-7230922108876464739L).setKey(9085107484615145442L);
    SimpleLongDecrypter.getCachedDecrypter(-156639914892642144L).setKey(-6386756901134419629L);
    SimpleLongDecrypter.getCachedDecrypter(4798608248224932556L).setKey(8586981187281646666L);
    SimpleLongDecrypter.getCachedDecrypter(-5646725847011195406L).setKey(-7029595400520530833L);
    SimpleLongDecrypter.getCachedDecrypter(8087638698547209526L).setKey(8236071949577821159L);
    SimpleLongDecrypter.getCachedDecrypter(7649392037835207913L).setKey(-4380790634621505987L);
    SimpleLongDecrypter.getCachedDecrypter(-8715101991662592243L).setKey(3751398821858198162L);
    SimpleLongDecrypter.getCachedDecrypter(3315454371400809920L).setKey(-2076237502208078445L);
    SimpleLongDecrypter.getCachedDecrypter(1316492889685849139L).setKey(-5737880269997715972L);
    SimpleLongDecrypter.getCachedDecrypter(5111616843167129751L).setKey(5899373372545921339L);
    SimpleLongDecrypter.getCachedDecrypter(-3595559118969416885L).setKey(-6139170789195146447L);
    SimpleLongDecrypter.getCachedDecrypter(-6445551366589165206L).setKey(-1640101401585321745L);
    SimpleLongDecrypter.getCachedDecrypter(-2943241419369006743L).setKey(-6211251045462673822L);
    SimpleLongDecrypter.getCachedDecrypter(-1012531264339766566L).setKey(-1049322541553168694L);
    SimpleLongDecrypter.getCachedDecrypter(6883934332300029145L).setKey(1114349125190704721L);
    SimpleLongDecrypter.getCachedDecrypter(5584346632402414911L).setKey(-6638834253137470466L);
    SimpleLongDecrypter.getCachedDecrypter(1198705319856703302L).setKey(-2191734325087437689L);
    SimpleLongDecrypter.getCachedDecrypter(6042384710216422090L).setKey(-8381353633310507771L);
    SimpleLongDecrypter.getCachedDecrypter(3829413250059701787L).setKey(-4550373095575492258L);
    SimpleLongDecrypter.getCachedDecrypter(5580548771575989930L).setKey(-6307096747631851975L);
    SimpleLongDecrypter.getCachedDecrypter(-7671653802781085729L).setKey(-5214744716131667110L);
    SimpleLongDecrypter.getCachedDecrypter(-2240276782565090493L).setKey(-6607564534407055112L);
    SimpleLongDecrypter.getCachedDecrypter(7779052061150154624L).setKey(4770669137824299151L);
    SimpleLongDecrypter.getCachedDecrypter(-5002614757201395872L).setKey(-6598687698648156962L);
    SimpleLongDecrypter.getCachedDecrypter(-2867996271547512227L).setKey(-621989907875470287L);
    SimpleLongDecrypter.getCachedDecrypter(4814983822345607297L).setKey(-2489325403665685877L);
    SimpleLongDecrypter.getCachedDecrypter(-1538425359130470117L).setKey(-6266738176815743288L);
    SimpleLongDecrypter.getCachedDecrypter(-2837430872233661467L).setKey(-5410860988866756132L);
    SimpleLongDecrypter.getCachedDecrypter(6055965200493727934L).setKey(-8462821203961056679L);
    SimpleLongDecrypter.getCachedDecrypter(6484064765142447236L).setKey(6804901791906664577L);
    SimpleLongDecrypter.getCachedDecrypter(-8190645262461289117L).setKey(-1963407436858537046L);
    SimpleLongDecrypter.getCachedDecrypter(2406596696449172214L).setKey(-985643827686692878L);
    SimpleLongDecrypter.getCachedDecrypter(-9056154723476004040L).setKey(-5726232558653387126L);
    SimpleLongDecrypter.getCachedDecrypter(-2107598248025900840L).setKey(8546894740449074329L);
    SimpleLongDecrypter.getCachedDecrypter(5266740183263860473L).setKey(9112118654538507691L);
    SimpleLongDecrypter.getCachedDecrypter(-892333751215425712L).setKey(5253864229585617348L);
    SimpleLongDecrypter.getCachedDecrypter(-8147550182700021940L).setKey(1299294403222677860L);
    SimpleLongDecrypter.getCachedDecrypter(-1968729250530162211L).setKey(-2222181796212020942L);
    SimpleLongDecrypter.getCachedDecrypter(-7932535582403543993L).setKey(-1252534455109952852L);
    SimpleLongDecrypter.getCachedDecrypter(-3892126986082344213L).setKey(3275069431704681555L);
    SimpleLongDecrypter.getCachedDecrypter(4251243239550924976L).setKey(-4513665685962431241L);
    SimpleLongDecrypter.getCachedDecrypter(-642033151859082796L).setKey(2651050370152292746L);
    SimpleLongDecrypter.getCachedDecrypter(415315151936728908L).setKey(-4530689833157361258L);
    SimpleLongDecrypter.getCachedDecrypter(-8010094591878376596L).setKey(-8314540288096538373L);
    SimpleLongDecrypter.getCachedDecrypter(-6495897737506491041L).setKey(6918894577687772701L);
    SimpleLongDecrypter.getCachedDecrypter(5372376503690963758L).setKey(2208648153930021203L);
    SimpleLongDecrypter.getCachedDecrypter(-7645610627583489116L).setKey(4628445478859391834L);
    SimpleLongDecrypter.getCachedDecrypter(3269529809244349803L).setKey(-4876290087543864081L);
    SimpleLongDecrypter.getCachedDecrypter(-37204427552335107L).setKey(-3142719334659145909L);
    SimpleLongDecrypter.getCachedDecrypter(-6040806314189547925L).setKey(-4865990232324236566L);
    SimpleLongDecrypter.getCachedDecrypter(7675146195856846604L).setKey(-2080627164077930941L);
    SimpleLongDecrypter.getCachedDecrypter(398102120137133019L).setKey(-2873311606105361289L);
    SimpleLongDecrypter.getCachedDecrypter(-3806464577250041273L).setKey(8491168847676349452L);
    SimpleLongDecrypter.getCachedDecrypter(7661276116089454445L).setKey(-1363103118541051961L);
    SimpleLongDecrypter.getCachedDecrypter(3397584987374255845L).setKey(-1765820890859871794L);
    SimpleLongDecrypter.getCachedDecrypter(7777427419119037848L).setKey(1300160272620655629L);
    SimpleLongDecrypter.getCachedDecrypter(-3906525082840791360L).setKey(4464779605887238040L);
    SimpleLongDecrypter.getCachedDecrypter(955281015914158794L).setKey(-7344594329389765432L);
    SimpleLongDecrypter.getCachedDecrypter(749590956133874242L).setKey(-5156721280392447243L);
    SimpleLongDecrypter.getCachedDecrypter(-5961426663642485422L).setKey(-5590801891477227995L);
    SimpleLongDecrypter.getCachedDecrypter(-6252145269190889916L).setKey(-4454304549074584345L);
    SimpleLongDecrypter.getCachedDecrypter(-4954757533396019772L).setKey(-3343146359994558966L);
    SimpleLongDecrypter.getCachedDecrypter(6256965994882655739L).setKey(8154830310614057204L);
    SimpleLongDecrypter.getCachedDecrypter(3760015457019158064L).setKey(2675830247427378773L);
    SimpleLongDecrypter.getCachedDecrypter(-2608616981890402048L).setKey(-2922334234575241964L);
    SimpleLongDecrypter.getCachedDecrypter(-4236102164045099706L).setKey(7742561456288244619L);
    SimpleLongDecrypter.getCachedDecrypter(-597792462106139550L).setKey(-8319615037958152274L);
    SimpleLongDecrypter.getCachedDecrypter(3991657142464524008L).setKey(-5590053123777413742L);
    SimpleLongDecrypter.getCachedDecrypter(4134654690053636642L).setKey(-6379972968543588278L);
    SimpleLongDecrypter.getCachedDecrypter(-2909246426743944322L).setKey(-3834607846215499291L);
    SimpleLongDecrypter.getCachedDecrypter(-8589223745034700491L).setKey(7401751780412120318L);
    SimpleLongDecrypter.getCachedDecrypter(-5628437939475001426L).setKey(6949512771973400190L);
    SimpleLongDecrypter.getCachedDecrypter(8710984293665548478L).setKey(-8634235507419297233L);
    SimpleLongDecrypter.getCachedDecrypter(6716875612784928142L).setKey(-5399493119191403590L);
    SimpleLongDecrypter.getCachedDecrypter(-566848259650697601L).setKey(2277463694162163620L);
    SimpleLongDecrypter.getCachedDecrypter(-602591965287236045L).setKey(1260584404485837872L);
    SimpleLongDecrypter.getCachedDecrypter(6242385216693367899L).setKey(185635739753116337L);
    SimpleLongDecrypter.getCachedDecrypter(330575738144736992L).setKey(-1087092466757057566L);
    SimpleLongDecrypter.getCachedDecrypter(7651316347172265014L).setKey(1894114916125614645L);
    SimpleLongDecrypter.getCachedDecrypter(4866964632314886762L).setKey(-2951367605500536627L);
    SimpleLongDecrypter.getCachedDecrypter(7937320738288559123L).setKey(-2756927978877737672L);
    SimpleLongDecrypter.getCachedDecrypter(-587758583295789741L).setKey(-7937468360997879629L);
    SimpleLongDecrypter.getCachedDecrypter(3542378535315750952L).setKey(-5332532847482275171L);
    SimpleLongDecrypter.getCachedDecrypter(-8298848418728381980L).setKey(7203461658237970706L);
    SimpleLongDecrypter.getCachedDecrypter(-1662694120635101571L).setKey(-8047156019218000279L);
    SimpleLongDecrypter.getCachedDecrypter(3763341423949443984L).setKey(2300238964129893792L);
    SimpleLongDecrypter.getCachedDecrypter(-1744911334347642295L).setKey(2685287631390235360L);
    SimpleLongDecrypter.getCachedDecrypter(-4689304783556081725L).setKey(5929853753479104590L);
    SimpleLongDecrypter.getCachedDecrypter(4090662571870670336L).setKey(-1234641030826436375L);
    SimpleLongDecrypter.getCachedDecrypter(-1971802150340939635L).setKey(-14447600298555928L);
    SimpleLongDecrypter.getCachedDecrypter(-54274335641992620L).setKey(3435495736813157018L);
    SimpleLongDecrypter.getCachedDecrypter(2120137561001043856L).setKey(-2820707503490860148L);
    SimpleLongDecrypter.getCachedDecrypter(3804031249402313589L).setKey(-4966828568429086039L);
    SimpleLongDecrypter.getCachedDecrypter(-2978971819670264400L).setKey(7447179998267996562L);
    SimpleLongDecrypter.getCachedDecrypter(-2038803231175744127L).setKey(1530265940127104086L);
    SimpleLongDecrypter.getCachedDecrypter(1495008889087404158L).setKey(595200802906910892L);
    SimpleLongDecrypter.getCachedDecrypter(-1950061458919298624L).setKey(-3627304072676128529L);
    SimpleLongDecrypter.getCachedDecrypter(3789912739111878568L).setKey(7065603038798785290L);
    SimpleLongDecrypter.getCachedDecrypter(-1486626576692757360L).setKey(7767547015246051834L);
    SimpleLongDecrypter.getCachedDecrypter(2245496100562721020L).setKey(-7189140836932820958L);
    SimpleLongDecrypter.getCachedDecrypter(-3181364827343897981L).setKey(2934104514364496455L);
    SimpleLongDecrypter.getCachedDecrypter(856500635572789803L).setKey(2199367706854401294L);
    SimpleLongDecrypter.getCachedDecrypter(5497013498675990192L).setKey(2588174324201663766L);
    SimpleLongDecrypter.getCachedDecrypter(1128262411030179762L).setKey(-7304061580076886339L);
    SimpleLongDecrypter.getCachedDecrypter(8122773022414216259L).setKey(-8007245786432572835L);
    SimpleLongDecrypter.getCachedDecrypter(8592769409979801722L).setKey(6499723106812302055L);
    SimpleLongDecrypter.getCachedDecrypter(-241854897694366608L).setKey(639292939385215489L);
    SimpleLongDecrypter.getCachedDecrypter(-1733053348472434571L).setKey(4157120812339086400L);
    SimpleLongDecrypter.getCachedDecrypter(5268320824483135330L).setKey(6067605238180638083L);
    SimpleLongDecrypter.getCachedDecrypter(-7186214577833489364L).setKey(-3023999882075887361L);
    SimpleLongDecrypter.getCachedDecrypter(-3556619928062883620L).setKey(5469895247559915662L);
    SimpleLongDecrypter.getCachedDecrypter(-5668831617674288975L).setKey(105749999064578529L);
    SimpleLongDecrypter.getCachedDecrypter(5893772860895439221L).setKey(4436426577319265131L);
    SimpleLongDecrypter.getCachedDecrypter(6304072879371605733L).setKey(-3894765066219410215L);
    SimpleLongDecrypter.getCachedDecrypter(-6051160415195052750L).setKey(7110606594618041507L);
    SimpleLongDecrypter.getCachedDecrypter(6126130976528193553L).setKey(-1396725269095269699L);
    SimpleLongDecrypter.getCachedDecrypter(4690298511117139841L).setKey(4920101411773697061L);
    SimpleLongDecrypter.getCachedDecrypter(-5251694554774426582L).setKey(-2900233069389954033L);
    SimpleLongDecrypter.getCachedDecrypter(5044740996485640695L).setKey(6302930642462123005L);
    SimpleLongDecrypter.getCachedDecrypter(-7586019719615305309L).setKey(-3035587052337338581L);
    SimpleLongDecrypter.getCachedDecrypter(-4770814469287483673L).setKey(-8576817287847052450L);
    SimpleLongDecrypter.getCachedDecrypter(-2317682633979033208L).setKey(-2925879401052869129L);
    SimpleLongDecrypter.getCachedDecrypter(-9140445872089012406L).setKey(-1020169110723157634L);
    SimpleLongDecrypter.getCachedDecrypter(8638316837300230104L).setKey(-2869548056564664141L);
    SimpleLongDecrypter.getCachedDecrypter(-5167936736486228439L).setKey(-4228257507110493496L);
    SimpleLongDecrypter.getCachedDecrypter(6947218096083059140L).setKey(6518484276766729088L);
    SimpleLongDecrypter.getCachedDecrypter(2017111720666987145L).setKey(-284647966141754159L);
    SimpleLongDecrypter.getCachedDecrypter(5913647287832290672L).setKey(4353506366500651439L);
    SimpleLongDecrypter.getCachedDecrypter(-2743268308318908159L).setKey(-6624371253997545347L);
    SimpleLongDecrypter.getCachedDecrypter(-4082126720590360935L).setKey(-6662966574358926132L);
    SimpleLongDecrypter.getCachedDecrypter(3305049217817676827L).setKey(-6336711509610130708L);
    SimpleLongDecrypter.getCachedDecrypter(-9198558790437272192L).setKey(1486003398254328858L);
    SimpleLongDecrypter.getCachedDecrypter(5953357397944166434L).setKey(8578278343129121643L);
    SimpleLongDecrypter.getCachedDecrypter(-7533426715686738127L).setKey(-3756117953890694239L);
    SimpleLongDecrypter.getCachedDecrypter(-51875987794828188L).setKey(-4865966888849358804L);
    SimpleLongDecrypter.getCachedDecrypter(1837671294879240583L).setKey(-2370067349594190746L);
    SimpleLongDecrypter.getCachedDecrypter(6840814958151878636L).setKey(-5301693731182205599L);
    SimpleLongDecrypter.getCachedDecrypter(-3789060690194674941L).setKey(429817484815155740L);
    SimpleLongDecrypter.getCachedDecrypter(-5928096187397421387L).setKey(5419859030269354265L);
    SimpleLongDecrypter.getCachedDecrypter(8891945437348017007L).setKey(-8798609612145917621L);
    SimpleLongDecrypter.getCachedDecrypter(5849600526398826329L).setKey(-4159109715422804124L);
    SimpleLongDecrypter.getCachedDecrypter(2948493695151940610L).setKey(3837681045411225610L);
    SimpleLongDecrypter.getCachedDecrypter(-1546242161654696729L).setKey(6860399724980070385L);
    SimpleLongDecrypter.getCachedDecrypter(2882308199117996547L).setKey(-4498622003880406932L);
    SimpleLongDecrypter.getCachedDecrypter(-7491277144070668828L).setKey(-5126467818388069650L);
    SimpleLongDecrypter.getCachedDecrypter(717785160301235437L).setKey(-634640425445191858L);
    SimpleLongDecrypter.getCachedDecrypter(-5162142312815836066L).setKey(5857627206246155088L);
    SimpleLongDecrypter.getCachedDecrypter(-5031800787753440527L).setKey(2389744542441105360L);
    SimpleLongDecrypter.getCachedDecrypter(611062557550598366L).setKey(2067998772011809260L);
    SimpleLongDecrypter.getCachedDecrypter(2558970025188074920L).setKey(4823144360773099260L);
    SimpleLongDecrypter.getCachedDecrypter(4362411102836279505L).setKey(3121163162843552290L);
    SimpleLongDecrypter.getCachedDecrypter(-5948684177822039098L).setKey(811346069038791757L);
    SimpleLongDecrypter.getCachedDecrypter(-760566240849364596L).setKey(3667690421917939889L);
    SimpleLongDecrypter.getCachedDecrypter(-6909007633623656612L).setKey(6795082471116292746L);
    SimpleLongDecrypter.getCachedDecrypter(-3033550607363021096L).setKey(1628320658179635059L);
    SimpleLongDecrypter.getCachedDecrypter(5914789162519913494L).setKey(-6978137722306864016L);
    SimpleLongDecrypter.getCachedDecrypter(5406677122819456009L).setKey(1055226352769427228L);
    SimpleLongDecrypter.getCachedDecrypter(7868189931546271338L).setKey(-3880966876376259225L);
    SimpleLongDecrypter.getCachedDecrypter(-6813493598614117117L).setKey(7476814549853477955L);
    SimpleLongDecrypter.getCachedDecrypter(3711619924839606911L).setKey(-819028013208924595L);
    SimpleLongDecrypter.getCachedDecrypter(-185131178344738613L).setKey(5593550412548954322L);
    SimpleLongDecrypter.getCachedDecrypter(-7388866273046936587L).setKey(5359179367723490834L);
    SimpleLongDecrypter.getCachedDecrypter(-8253421734874760378L).setKey(8633149810642229695L);
    SimpleLongDecrypter.getCachedDecrypter(-1599211414088593361L).setKey(5466820111494322347L);
    SimpleLongDecrypter.getCachedDecrypter(-2183233545181747833L).setKey(6923221178997719434L);
    SimpleLongDecrypter.getCachedDecrypter(1668929495518164951L).setKey(-6960420459916805972L);
    SimpleLongDecrypter.getCachedDecrypter(4876334548532233928L).setKey(-6578821453497150553L);
    SimpleLongDecrypter.getCachedDecrypter(3274754832447128004L).setKey(3462229742542465550L);
    SimpleLongDecrypter.getCachedDecrypter(7320182605808888699L).setKey(7612108489874554817L);
    SimpleLongDecrypter.getCachedDecrypter(-7897405531427644559L).setKey(-6643587073734500427L);
    SimpleLongDecrypter.getCachedDecrypter(413653754478157977L).setKey(-8770603152297678235L);
    SimpleLongDecrypter.getCachedDecrypter(-2005420147985705291L).setKey(1355387568958504753L);
    SimpleLongDecrypter.getCachedDecrypter(455893826387634948L).setKey(8214351191346464972L);
    SimpleLongDecrypter.getCachedDecrypter(6940382296312048360L).setKey(2471793860071929054L);
    SimpleLongDecrypter.getCachedDecrypter(5884114629437238563L).setKey(7746846327460307891L);
    SimpleLongDecrypter.getCachedDecrypter(8491064084511631256L).setKey(7697236750133335483L);
    SimpleLongDecrypter.getCachedDecrypter(-6365382536246912034L).setKey(-8057732091090859356L);
    SimpleLongDecrypter.getCachedDecrypter(420215948496617698L).setKey(-8737682015500875083L);
    SimpleLongDecrypter.getCachedDecrypter(-4897149433144873074L).setKey(842571276135161856L);
    SimpleLongDecrypter.getCachedDecrypter(386158679672263741L).setKey(397119188977774720L);
    SimpleLongDecrypter.getCachedDecrypter(2313166913398300288L).setKey(-2161415948348456959L);
    SimpleLongDecrypter.getCachedDecrypter(6202321625322073426L).setKey(4261170666551055054L);
    SimpleLongDecrypter.getCachedDecrypter(4106336659570727281L).setKey(-3148760909753064406L);
    SimpleLongDecrypter.getCachedDecrypter(-6347790921768268685L).setKey(-2703527024547768365L);
    SimpleLongDecrypter.getCachedDecrypter(-4389331465120073988L).setKey(7242693322384529193L);
    SimpleLongDecrypter.getCachedDecrypter(-5204314246522088924L).setKey(2632781471348758686L);
    SimpleLongDecrypter.getCachedDecrypter(1017181999152218294L).setKey(-7705564230108673348L);
    SimpleLongDecrypter.getCachedDecrypter(-4600798587676966292L).setKey(-4061583140941762139L);
    SimpleLongDecrypter.getCachedDecrypter(-3765459934618972033L).setKey(-4370078111691357779L);
    SimpleLongDecrypter.getCachedDecrypter(-8006877663536718095L).setKey(-3460881452391105471L);
    SimpleLongDecrypter.getCachedDecrypter(-6101296245294271603L).setKey(-5997177950266081333L);
    SimpleLongDecrypter.getCachedDecrypter(-731531853645894575L).setKey(-6973823396604465268L);
    SimpleLongDecrypter.getCachedDecrypter(-900107724889385090L).setKey(1193205883535050141L);
    SimpleLongDecrypter.getCachedDecrypter(5013437159090094233L).setKey(-7781958706548928924L);
    SimpleLongDecrypter.getCachedDecrypter(-5274600669965795752L).setKey(-5163394920496417957L);
    SimpleLongDecrypter.getCachedDecrypter(-2121874369992995338L).setKey(2587636963135609900L);
    SimpleLongDecrypter.getCachedDecrypter(-5149894015208051806L).setKey(-1488095263134796791L);
    SimpleLongDecrypter.getCachedDecrypter(4022403049666906218L).setKey(-276179664378351224L);
    SimpleLongDecrypter.getCachedDecrypter(-893775513798485023L).setKey(6591315769740417891L);
    SimpleLongDecrypter.getCachedDecrypter(-6413898647088967563L).setKey(2446873271126680139L);
    SimpleLongDecrypter.getCachedDecrypter(8500889573719934984L).setKey(3114864697991447344L);
    SimpleLongDecrypter.getCachedDecrypter(7267182188991616814L).setKey(5863352986232811243L);
    SimpleLongDecrypter.getCachedDecrypter(3777816292343773455L).setKey(-4821486503100686450L);
    SimpleLongDecrypter.getCachedDecrypter(-6436185749192412696L).setKey(3860839657224268173L);
    SimpleLongDecrypter.getCachedDecrypter(-7126455575374654462L).setKey(-2563485619342155383L);
    SimpleLongDecrypter.getCachedDecrypter(4196975987355435355L).setKey(-1364572508088848524L);
    SimpleLongDecrypter.getCachedDecrypter(-9071026837027443539L).setKey(-2442445380102741126L);
    SimpleLongDecrypter.getCachedDecrypter(-4280001669528869152L).setKey(2450410294175115771L);
    SimpleLongDecrypter.getCachedDecrypter(8824381760203443822L).setKey(-3815417255638540878L);
    SimpleLongDecrypter.getCachedDecrypter(-2688419009570052472L).setKey(-307047291103654398L);
    SimpleLongDecrypter.getCachedDecrypter(8872821901195285798L).setKey(718178856647839514L);
    SimpleLongDecrypter.getCachedDecrypter(-4897076623611467821L).setKey(2238697582924838706L);
    SimpleLongDecrypter.getCachedDecrypter(-3324571085235939454L).setKey(-5770828877075770552L);
    SimpleLongDecrypter.getCachedDecrypter(652305573840333516L).setKey(-574007488664284274L);
    SimpleLongDecrypter.getCachedDecrypter(6707450491604212227L).setKey(-7348634067806574601L);
    SimpleLongDecrypter.getCachedDecrypter(6402566760800990077L).setKey(8232295366636614692L);
    SimpleLongDecrypter.getCachedDecrypter(7711175235262995910L).setKey(249124836571229189L);
    SimpleLongDecrypter.getCachedDecrypter(-6100840827237031940L).setKey(-4646174993821191410L);
    SimpleLongDecrypter.getCachedDecrypter(6783169575792474639L).setKey(-6612703330378100657L);
    SimpleLongDecrypter.getCachedDecrypter(8193857294834806805L).setKey(-4211935010919498972L);
    SimpleLongDecrypter.getCachedDecrypter(5181293789635363920L).setKey(429898984167927647L);
    SimpleLongDecrypter.getCachedDecrypter(-4736592581247816059L).setKey(-5506753267669041206L);
    SimpleLongDecrypter.getCachedDecrypter(4923771132459878080L).setKey(-9094319159911319715L);
    SimpleLongDecrypter.getCachedDecrypter(2457905243342298839L).setKey(3857065532561539350L);
    SimpleLongDecrypter.getCachedDecrypter(-8458160537531761820L).setKey(9008630312686034666L);
    SimpleLongDecrypter.getCachedDecrypter(4618729532457684023L).setKey(-5988956113418689419L);
    SimpleLongDecrypter.getCachedDecrypter(1609838011809989281L).setKey(7753171229498699477L);
    SimpleLongDecrypter.getCachedDecrypter(2748496700715697926L).setKey(5201852808960737079L);
    SimpleLongDecrypter.getCachedDecrypter(5491214405021640559L).setKey(-5126034447245468444L);
    SimpleLongDecrypter.getCachedDecrypter(-1701487458332743043L).setKey(-7251549815234552162L);
    SimpleLongDecrypter.getCachedDecrypter(5998897843352736296L).setKey(-3113639689350831957L);
    SimpleLongDecrypter.getCachedDecrypter(3196410194778895115L).setKey(-2566195776815887016L);
    SimpleLongDecrypter.getCachedDecrypter(3737512854036883898L).setKey(-206361844622563477L);
    SimpleLongDecrypter.getCachedDecrypter(-3352859811030974947L).setKey(-5717296933770767307L);
    SimpleLongDecrypter.getCachedDecrypter(2664081661595480920L).setKey(166409595955460372L);
    SimpleLongDecrypter.getCachedDecrypter(1929880685907837519L).setKey(2190230529123420698L);
    SimpleLongDecrypter.getCachedDecrypter(-5154516635430469907L).setKey(-2795543653173782875L);
    SimpleLongDecrypter.getCachedDecrypter(799200985811726986L).setKey(4124022597066877007L);
    SimpleLongDecrypter.getCachedDecrypter(-7663553625145467027L).setKey(3984526474381155458L);
    SimpleLongDecrypter.getCachedDecrypter(-1360655356446310059L).setKey(-9093085253353222819L);
    SimpleLongDecrypter.getCachedDecrypter(8083090964652709516L).setKey(-7531012476757400213L);
    SimpleLongDecrypter.getCachedDecrypter(-8951727645611382812L).setKey(1463991362279509143L);
    SimpleLongDecrypter.getCachedDecrypter(-6289141032444157326L).setKey(3895136509288684822L);
    SimpleLongDecrypter.getCachedDecrypter(-4330966255085041132L).setKey(-4350294097569351608L);
    SimpleLongDecrypter.getCachedDecrypter(-3487985760470266056L).setKey(1852338934608791218L);
    SimpleLongDecrypter.getCachedDecrypter(-7330075403075699371L).setKey(4763704090336719211L);
    SimpleLongDecrypter.getCachedDecrypter(8382169118643269928L).setKey(6555524929838862180L);
    SimpleLongDecrypter.getCachedDecrypter(-5919562744626009859L).setKey(-7631141537620769819L);
    SimpleLongDecrypter.getCachedDecrypter(8596291334148453940L).setKey(-2196512663887672711L);
    SimpleLongDecrypter.getCachedDecrypter(-5268163279264779867L).setKey(-6289870468119963705L);
    SimpleLongDecrypter.getCachedDecrypter(1026362650192175885L).setKey(-5393736153410286447L);
    SimpleLongDecrypter.getCachedDecrypter(-2764279569106608746L).setKey(8616171018464929493L);
    SimpleLongDecrypter.getCachedDecrypter(4453594825022336419L).setKey(1602584325525972860L);
    SimpleLongDecrypter.getCachedDecrypter(3580382886114258684L).setKey(2071793850771490429L);
    SimpleLongDecrypter.getCachedDecrypter(-7700329352544669844L).setKey(3045823075355838067L);
    SimpleLongDecrypter.getCachedDecrypter(-1232754668506224863L).setKey(4913921563269305731L);
    SimpleLongDecrypter.getCachedDecrypter(-3122758807885464843L).setKey(3101498021477928215L);
    SimpleLongDecrypter.getCachedDecrypter(-9095280698318813681L).setKey(7719322854070770065L);
    SimpleLongDecrypter.getCachedDecrypter(-3498136622045571882L).setKey(-8363180630371904277L);
    SimpleLongDecrypter.getCachedDecrypter(7326284501684051221L).setKey(-7257700210429865916L);
    SimpleLongDecrypter.getCachedDecrypter(2358813272724861342L).setKey(2252054580100691715L);
    SimpleLongDecrypter.getCachedDecrypter(917532565416539413L).setKey(3116392849540194074L);
    SimpleLongDecrypter.getCachedDecrypter(-5770742069574921397L).setKey(-5982759053740624018L);
    SimpleLongDecrypter.getCachedDecrypter(-7898304784371278785L).setKey(4431348565232437695L);
    SimpleLongDecrypter.getCachedDecrypter(-1877150923514028673L).setKey(6601616114667625122L);
    SimpleLongDecrypter.getCachedDecrypter(6225185426217013346L).setKey(-175534991239328883L);
    SimpleLongDecrypter.getCachedDecrypter(-650430940106130784L).setKey(2844845946706592200L);
    SimpleLongDecrypter.getCachedDecrypter(-6050284908092325435L).setKey(-3833732460044662498L);
    SimpleLongDecrypter.getCachedDecrypter(-6249287041835270385L).setKey(2546869727262358069L);
    SimpleLongDecrypter.getCachedDecrypter(-5376361755904073600L).setKey(-6076440923681701297L);
    SimpleLongDecrypter.getCachedDecrypter(3176774993056743615L).setKey(-2560056802921230357L);
    SimpleLongDecrypter.getCachedDecrypter(978639459001417489L).setKey(4337629884835129872L);
    SimpleLongDecrypter.getCachedDecrypter(5064378093808939719L).setKey(-9125057481825053927L);
    SimpleLongDecrypter.getCachedDecrypter(8713071119374277964L).setKey(4188165761838968472L);
    SimpleLongDecrypter.getCachedDecrypter(-862583909264672472L).setKey(6343950937858601668L);
    SimpleLongDecrypter.getCachedDecrypter(2056833191576366719L).setKey(-4546179581049390270L);
    SimpleLongDecrypter.getCachedDecrypter(5226139452508097668L).setKey(4349327256227677603L);
    SimpleLongDecrypter.getCachedDecrypter(-4219126260279223747L).setKey(-536821055911090384L);
    SimpleLongDecrypter.getCachedDecrypter(-8123323547205325229L).setKey(-8032591965634445630L);
    SimpleLongDecrypter.getCachedDecrypter(2927166064297796573L).setKey(1381723258968344605L);
    SimpleLongDecrypter.getCachedDecrypter(7417231285970171106L).setKey(-3326877580937229440L);
    SimpleLongDecrypter.getCachedDecrypter(-4871330148844828069L).setKey(-3925247735220758153L);
    SimpleLongDecrypter.getCachedDecrypter(-7535131701160853021L).setKey(-64502161832848246L);
    SimpleLongDecrypter.getCachedDecrypter(1060220066315536679L).setKey(8541424803806302985L);
    SimpleLongDecrypter.getCachedDecrypter(6907809498557368332L).setKey(-8654904731482561181L);
    SimpleLongDecrypter.getCachedDecrypter(-5842994152465547152L).setKey(-7990662853054559508L);
    SimpleLongDecrypter.getCachedDecrypter(3389889936173000238L).setKey(-7901171385786255026L);
    SimpleLongDecrypter.getCachedDecrypter(-4172734170532876980L).setKey(2725761342630293517L);
    SimpleLongDecrypter.getCachedDecrypter(-5593995064605328718L).setKey(3006735400726606176L);
    SimpleLongDecrypter.getCachedDecrypter(8375715512348596198L).setKey(5067885141457528931L);
    SimpleLongDecrypter.getCachedDecrypter(-6323965717576739717L).setKey(-4644833729253615916L);
    SimpleLongDecrypter.getCachedDecrypter(4660031888504896246L).setKey(7110607157340209157L);
    SimpleLongDecrypter.getCachedDecrypter(1224482564325245692L).setKey(7982149838646422877L);
    SimpleLongDecrypter.getCachedDecrypter(2360516979010055924L).setKey(5737855166165243046L);
    SimpleLongDecrypter.getCachedDecrypter(362265361392110998L).setKey(-2045571349818506672L);
    SimpleLongDecrypter.getCachedDecrypter(5033746275278070164L).setKey(3523466436597801744L);
    SimpleLongDecrypter.getCachedDecrypter(8350554435376235900L).setKey(-3911639778537508253L);
    SimpleLongDecrypter.getCachedDecrypter(7082218559398527116L).setKey(7564563838328698088L);
    SimpleLongDecrypter.getCachedDecrypter(3129169178928551240L).setKey(-6034361231954734053L);
    SimpleLongDecrypter.getCachedDecrypter(-707642074323957257L).setKey(5100890388571979431L);
    SimpleLongDecrypter.getCachedDecrypter(8300344862672381220L).setKey(4915855810788722645L);
    SimpleLongDecrypter.getCachedDecrypter(-5988460743099673452L).setKey(177888698188078770L);
    SimpleLongDecrypter.getCachedDecrypter(6769108488956382383L).setKey(-6725263733007920920L);
    SimpleLongDecrypter.getCachedDecrypter(8186744980426079816L).setKey(-7773303179903619932L);
    SimpleLongDecrypter.getCachedDecrypter(-8647362592828831795L).setKey(-5745373497539891572L);
    SimpleLongDecrypter.getCachedDecrypter(492073941031103402L).setKey(-2960574691291962526L);
    SimpleLongDecrypter.getCachedDecrypter(7986351134723507055L).setKey(9039891883575880509L);
    SimpleLongDecrypter.getCachedDecrypter(4149040134723093756L).setKey(-7039819542354203643L);
    SimpleLongDecrypter.getCachedDecrypter(918426473096169097L).setKey(-2264041077346007602L);
    SimpleLongDecrypter.getCachedDecrypter(994461542773235386L).setKey(-7203669272075104346L);
    SimpleLongDecrypter.getCachedDecrypter(-1991326655726891784L).setKey(922851437824726667L);
    SimpleLongDecrypter.getCachedDecrypter(7424753166148703825L).setKey(1052972455906525997L);
    SimpleLongDecrypter.getCachedDecrypter(-3057644509013766173L).setKey(7198641492167523353L);
    SimpleLongDecrypter.getCachedDecrypter(4359748640065118078L).setKey(-1007703401592246130L);
    SimpleLongDecrypter.getCachedDecrypter(5570562965845464892L).setKey(7366330975989651943L);
    SimpleLongDecrypter.getCachedDecrypter(-3424548085217808455L).setKey(2187301903547812239L);
    SimpleLongDecrypter.getCachedDecrypter(2025727644253104044L).setKey(2362011689123508508L);
    SimpleLongDecrypter.getCachedDecrypter(1263367589936605610L).setKey(-2201498212416399154L);
    SimpleLongDecrypter.getCachedDecrypter(5313009679448178992L).setKey(-4076961260393409077L);
    SimpleLongDecrypter.getCachedDecrypter(-6847847579771860371L).setKey(-5359375180695294864L);
    SimpleLongDecrypter.getCachedDecrypter(3243346448756854361L).setKey(-7951873105106577768L);
    SimpleLongDecrypter.getCachedDecrypter(-7804409484136253031L).setKey(-1576563815809810883L);
    SimpleLongDecrypter.getCachedDecrypter(-8450462863602601119L).setKey(-9175851599049551003L);
    SimpleLongDecrypter.getCachedDecrypter(-3949493404071716294L).setKey(8877301357454737063L);
    SimpleLongDecrypter.getCachedDecrypter(3555453552829350838L).setKey(-8582467805704001624L);
    SimpleLongDecrypter.getCachedDecrypter(367250953362381429L).setKey(7094849020331800658L);
    SimpleLongDecrypter.getCachedDecrypter(-861722796855349083L).setKey(621784809139661089L);
    SimpleLongDecrypter.getCachedDecrypter(-5576707416219798740L).setKey(611937246028451309L);
    SimpleLongDecrypter.getCachedDecrypter(-8787858764970498911L).setKey(5617552893354136326L);
    SimpleLongDecrypter.getCachedDecrypter(-2323196702624753119L).setKey(-2695745506857051507L);
    SimpleLongDecrypter.getCachedDecrypter(-3289919044707090041L).setKey(2588644977451219931L);
    SimpleLongDecrypter.getCachedDecrypter(-1214458122420883869L).setKey(-8593633965092513608L);
    SimpleLongDecrypter.getCachedDecrypter(4373089856916075417L).setKey(-6783215496556853542L);
    SimpleLongDecrypter.getCachedDecrypter(-6362317841811686202L).setKey(9053284708285870481L);
    SimpleLongDecrypter.getCachedDecrypter(-3007427731057653650L).setKey(-7046692600337839071L);
    SimpleLongDecrypter.getCachedDecrypter(6776759583582749115L).setKey(-6769724629529713774L);
    SimpleLongDecrypter.getCachedDecrypter(2349619461715005678L).setKey(4757246756352781298L);
    SimpleLongDecrypter.getCachedDecrypter(822299911746843501L).setKey(5642472617979082701L);
    SimpleLongDecrypter.getCachedDecrypter(5078808099577228785L).setKey(8580670843900329251L);
    SimpleLongDecrypter.getCachedDecrypter(-6298035116828856274L).setKey(-1283012870997980289L);
    SimpleLongDecrypter.getCachedDecrypter(4098068719554372971L).setKey(-1946673857107374284L);
    SimpleLongDecrypter.getCachedDecrypter(-2471215842368993132L).setKey(215207927052330858L);
    SimpleLongDecrypter.getCachedDecrypter(3428172310302726127L).setKey(172481747950909334L);
    SimpleLongDecrypter.getCachedDecrypter(6557475839076774522L).setKey(-1526057587566382053L);
    SimpleLongDecrypter.getCachedDecrypter(-7132094723362857701L).setKey(-4300275875877932260L);
    SimpleLongDecrypter.getCachedDecrypter(-7102233086899395794L).setKey(-3810529204714733234L);
    SimpleLongDecrypter.getCachedDecrypter(-7381275533524641279L).setKey(-9162560404738011075L);
    SimpleLongDecrypter.getCachedDecrypter(6418831398611790986L).setKey(1750172206472201666L);
    SimpleLongDecrypter.getCachedDecrypter(-8141350835250056350L).setKey(8547960061479336257L);
    SimpleLongDecrypter.getCachedDecrypter(-6870946559844852647L).setKey(-3289632609881920217L);
    SimpleLongDecrypter.getCachedDecrypter(-7994667500232684965L).setKey(-5790518332800810484L);
    SimpleLongDecrypter.getCachedDecrypter(-7353071623406468895L).setKey(-6146673071820693803L);
    SimpleLongDecrypter.getCachedDecrypter(-1870191573704831687L).setKey(-8655929008489272683L);
    SimpleLongDecrypter.getCachedDecrypter(-4680960856854853015L).setKey(-7834105367818196866L);
    SimpleLongDecrypter.getCachedDecrypter(375977074568480927L).setKey(-1922616547444543174L);
    SimpleLongDecrypter.getCachedDecrypter(6872063409797026971L).setKey(-7686660496854421323L);
    SimpleLongDecrypter.getCachedDecrypter(4325051788648895141L).setKey(774893277547560946L);
    SimpleLongDecrypter.getCachedDecrypter(-1986007720022140939L).setKey(-1479429444252840756L);
    SimpleLongDecrypter.getCachedDecrypter(6388764356715848656L).setKey(-8154060425926609958L);
    SimpleLongDecrypter.getCachedDecrypter(7403072602376795447L).setKey(-1562289131801205685L);
    SimpleLongDecrypter.getCachedDecrypter(-1146500178410583104L).setKey(986249951487666577L);
    SimpleLongDecrypter.getCachedDecrypter(2083415165270862999L).setKey(-9145235207588742533L);
    SimpleLongDecrypter.getCachedDecrypter(6321402722370748333L).setKey(-2530447328847696630L);
    SimpleLongDecrypter.getCachedDecrypter(-2138218446784547859L).setKey(5152904579663278779L);
    SimpleLongDecrypter.getCachedDecrypter(-1751399135095035123L).setKey(13329038953495628L);
    SimpleLongDecrypter.getCachedDecrypter(-194604483594180437L).setKey(7065343370371690398L);
    SimpleLongDecrypter.getCachedDecrypter(-6362390901655755534L).setKey(-5836180932284073244L);
    SimpleLongDecrypter.getCachedDecrypter(-7576476698081821219L).setKey(790213657527089784L);
    SimpleLongDecrypter.getCachedDecrypter(9048443632000766606L).setKey(6103143462042810549L);
    SimpleLongDecrypter.getCachedDecrypter(-5948306178234228827L).setKey(6356923478485036575L);
    SimpleLongDecrypter.getCachedDecrypter(2664489603700127362L).setKey(2966706000174515527L);
    SimpleLongDecrypter.getCachedDecrypter(-4550588855114347200L).setKey(8089334297007289703L);
    SimpleLongDecrypter.getCachedDecrypter(-5775623932827148492L).setKey(5094830093982045976L);
    SimpleLongDecrypter.getCachedDecrypter(-2082751378577749716L).setKey(3133380304848603582L);
    SimpleLongDecrypter.getCachedDecrypter(2940955351595983565L).setKey(6622798369385967538L);
    SimpleLongDecrypter.getCachedDecrypter(-5230072533020612L).setKey(581488690406756540L);
    SimpleLongDecrypter.getCachedDecrypter(7727544237389338611L).setKey(-4807162878808199879L);
    SimpleLongDecrypter.getCachedDecrypter(5655106520868222724L).setKey(5359051459974258357L);
    SimpleLongDecrypter.getCachedDecrypter(-8539042863237242655L).setKey(-467931936093795071L);
    SimpleLongDecrypter.getCachedDecrypter(4634348842218560120L).setKey(-8388383135834612767L);
    SimpleLongDecrypter.getCachedDecrypter(-336151990825660718L).setKey(-9160866698189432164L);
    SimpleLongDecrypter.getCachedDecrypter(3118003085068781438L).setKey(-6652082915582718831L);
    SimpleLongDecrypter.getCachedDecrypter(6593130657862128843L).setKey(4220466644162738862L);
    SimpleLongDecrypter.getCachedDecrypter(-5097505609372512699L).setKey(-4475322644695677598L);
    SimpleLongDecrypter.getCachedDecrypter(-26151009252047922L).setKey(-6342439351815859821L);
    SimpleLongDecrypter.getCachedDecrypter(-2414218366838061445L).setKey(-1054798261842982349L);
    SimpleLongDecrypter.getCachedDecrypter(-1954126639340292275L).setKey(-5807854081426495390L);
    SimpleLongDecrypter.getCachedDecrypter(-2450418469488162715L).setKey(4749851399054684144L);
    SimpleLongDecrypter.getCachedDecrypter(8494057223504917992L).setKey(-8983358854238878642L);
    SimpleLongDecrypter.getCachedDecrypter(-7099369642594785500L).setKey(6806782536259129908L);
    SimpleLongDecrypter.getCachedDecrypter(1213428117484910161L).setKey(-2526079466603430406L);
    SimpleLongDecrypter.getCachedDecrypter(656502379481362740L).setKey(-23973193044302647L);
    SimpleLongDecrypter.getCachedDecrypter(-5379989664911524539L).setKey(7253437521272748693L);
    SimpleLongDecrypter.getCachedDecrypter(2109424774274999694L).setKey(-654084882881947394L);
    SimpleLongDecrypter.getCachedDecrypter(1656775201369542852L).setKey(7376118618899621719L);
    SimpleLongDecrypter.getCachedDecrypter(2895769906212068808L).setKey(-8902341036420585049L);
    SimpleLongDecrypter.getCachedDecrypter(-5971664491523402994L).setKey(6695276133647621877L);
    SimpleLongDecrypter.getCachedDecrypter(-2825294847573518310L).setKey(-2498043241549853160L);
    SimpleLongDecrypter.getCachedDecrypter(5868460551426961405L).setKey(-5651704495206085788L);
    SimpleLongDecrypter.getCachedDecrypter(-806400613321713321L).setKey(4458981674992263869L);
    SimpleLongDecrypter.getCachedDecrypter(-1571203275492425526L).setKey(3368530668718658963L);
    SimpleLongDecrypter.getCachedDecrypter(265528001809317608L).setKey(7509978497984847407L);
    SimpleLongDecrypter.getCachedDecrypter(-3785729980710635834L).setKey(-7655611345591695910L);
    SimpleLongDecrypter.getCachedDecrypter(106207520010754531L).setKey(1348758773322919527L);
    SimpleLongDecrypter.getCachedDecrypter(-6905731520122639365L).setKey(4528033971353918479L);
    SimpleLongDecrypter.getCachedDecrypter(2440636502615079141L).setKey(8215704094656918231L);
    SimpleLongDecrypter.getCachedDecrypter(-6914720426922674437L).setKey(1978648429245968574L);
    SimpleLongDecrypter.getCachedDecrypter(8566067423206059560L).setKey(-3384330999593719789L);
    SimpleLongDecrypter.getCachedDecrypter(1089044605105780301L).setKey(-4423310800212054738L);
    SimpleLongDecrypter.getCachedDecrypter(-593768666353731021L).setKey(3636749136470130970L);
    SimpleLongDecrypter.getCachedDecrypter(5977874030105518174L).setKey(-859474184110103867L);
    SimpleLongDecrypter.getCachedDecrypter(-8715956570448372114L).setKey(-9206790441059166897L);
    SimpleLongDecrypter.getCachedDecrypter(5015862706763628661L).setKey(-1130865381568533958L);
    SimpleLongDecrypter.getCachedDecrypter(8193992252089386651L).setKey(-8728279057864470300L);
    SimpleLongDecrypter.getCachedDecrypter(-3764588836150471018L).setKey(-5768459697334357801L);
    SimpleLongDecrypter.getCachedDecrypter(5064955628400515001L).setKey(7001712733250076423L);
    SimpleLongDecrypter.getCachedDecrypter(8648964367771283618L).setKey(6602199251936516758L);
    SimpleLongDecrypter.getCachedDecrypter(6357001899310304033L).setKey(-1128089780052481983L);
    SimpleLongDecrypter.getCachedDecrypter(-7918425005393848456L).setKey(-8477764632535571416L);
    SimpleLongDecrypter.getCachedDecrypter(-3197390439242461510L).setKey(496691292057916554L);
    SimpleLongDecrypter.getCachedDecrypter(453765050745408300L).setKey(-9148108324050348872L);
    SimpleLongDecrypter.getCachedDecrypter(2879597216884382900L).setKey(-7509608719287235088L);
    SimpleLongDecrypter.getCachedDecrypter(-8312720471368364722L).setKey(1035432882821567295L);
    SimpleLongDecrypter.getCachedDecrypter(1706251781471798691L).setKey(-1086329251805077873L);
    SimpleLongDecrypter.getCachedDecrypter(-8405649913739541805L).setKey(-1139354863823855724L);
    SimpleLongDecrypter.getCachedDecrypter(8227938531355997297L).setKey(6378870115601543486L);
    SimpleLongDecrypter.getCachedDecrypter(-6133862115766592368L).setKey(4300921921775208245L);
    SimpleLongDecrypter.getCachedDecrypter(-6299391959664752446L).setKey(-6665445914380875350L);
    SimpleLongDecrypter.getCachedDecrypter(4119974474652787577L).setKey(-838120544011461937L);
    SimpleLongDecrypter.getCachedDecrypter(-6717204154762285300L).setKey(-2527100640149442901L);
    SimpleLongDecrypter.getCachedDecrypter(-8488667204906468484L).setKey(-3173963450502147142L);
    SimpleLongDecrypter.getCachedDecrypter(5508662973033243710L).setKey(5430560830471712661L);
    SimpleLongDecrypter.getCachedDecrypter(-8276094369109373086L).setKey(-8308384084670578722L);
    SimpleLongDecrypter.getCachedDecrypter(-6523359723011215851L).setKey(6910602667427279508L);
    SimpleLongDecrypter.getCachedDecrypter(-6064645259651469467L).setKey(-343309974779493526L);
    SimpleLongDecrypter.getCachedDecrypter(4966626710162651231L).setKey(7525353270610693651L);
    SimpleLongDecrypter.getCachedDecrypter(6293781382777347846L).setKey(-2859195357233722076L);
    SimpleLongDecrypter.getCachedDecrypter(-1012728491105509795L).setKey(2604540533260174502L);
    SimpleLongDecrypter.getCachedDecrypter(2455971612979440871L).setKey(9196381209102216809L);
    SimpleLongDecrypter.getCachedDecrypter(3116252946552437385L).setKey(6185827855448121703L);
    SimpleLongDecrypter.getCachedDecrypter(7765671148256739120L).setKey(2085592461173799535L);
    SimpleLongDecrypter.getCachedDecrypter(-170190473036596903L).setKey(-6028171953760447644L);
    SimpleLongDecrypter.getCachedDecrypter(-329238252061915374L).setKey(-5152547605851661954L);
    SimpleLongDecrypter.getCachedDecrypter(1943445694919430546L).setKey(1551769333556553333L);
    SimpleLongDecrypter.getCachedDecrypter(7081110147733176870L).setKey(5210869904582309836L);
    SimpleLongDecrypter.getCachedDecrypter(3978192691019863456L).setKey(196291424567782151L);
    SimpleLongDecrypter.getCachedDecrypter(-7419588245660337261L).setKey(-2755206005805992845L);
    SimpleLongDecrypter.getCachedDecrypter(-8431801021916376128L).setKey(8835157582527638481L);
    SimpleLongDecrypter.getCachedDecrypter(-6083165683820045081L).setKey(-8477712005283392715L);
    SimpleLongDecrypter.getCachedDecrypter(-6286404657444500459L).setKey(3195113866463392446L);
    SimpleLongDecrypter.getCachedDecrypter(7915526612333515110L).setKey(-1763011767468464730L);
    SimpleLongDecrypter.getCachedDecrypter(-6403586731775554178L).setKey(4185920428768053335L);
    SimpleLongDecrypter.getCachedDecrypter(4830078056494577938L).setKey(-6937075970279810737L);
    SimpleLongDecrypter.getCachedDecrypter(-3731430447993999527L).setKey(820963792004167362L);
    SimpleLongDecrypter.getCachedDecrypter(3281889532633868384L).setKey(7920964553424175755L);
    SimpleLongDecrypter.getCachedDecrypter(-925405030357799201L).setKey(-1309892682148785705L);
    SimpleLongDecrypter.getCachedDecrypter(-3029676514099400778L).setKey(548588352309432649L);
    SimpleLongDecrypter.getCachedDecrypter(-7501975910394902195L).setKey(8909338628148797786L);
    SimpleLongDecrypter.getCachedDecrypter(-7046241411021596043L).setKey(5319831256616051324L);
    SimpleLongDecrypter.getCachedDecrypter(-1770211908355745699L).setKey(-3198829876910996080L);
    SimpleLongDecrypter.getCachedDecrypter(7822062523281386540L).setKey(-1921950133806912052L);
    SimpleLongDecrypter.getCachedDecrypter(-5727521813618612548L).setKey(3054744305109293929L);
    SimpleLongDecrypter.getCachedDecrypter(4248497720293141279L).setKey(-797154221092399190L);
    SimpleLongDecrypter.getCachedDecrypter(-8368750914042761907L).setKey(9198180186224531630L);
    SimpleLongDecrypter.getCachedDecrypter(-3892123633536449193L).setKey(4863587134180006340L);
    SimpleLongDecrypter.getCachedDecrypter(8931522526161290923L).setKey(8561956717588959664L);
    SimpleLongDecrypter.getCachedDecrypter(-7950843592296749619L).setKey(736584526065997287L);
    SimpleLongDecrypter.getCachedDecrypter(-7908749306474674355L).setKey(-5335754524134814302L);
    SimpleLongDecrypter.getCachedDecrypter(8715733604819387593L).setKey(-8342390212695523798L);
    SimpleLongDecrypter.getCachedDecrypter(8587033287877706852L).setKey(-2710986785572715618L);
    SimpleLongDecrypter.getCachedDecrypter(-8828354033574433299L).setKey(3045828722473519626L);
    SimpleLongDecrypter.getCachedDecrypter(5750069388872755462L).setKey(6455080667351368403L);
    SimpleLongDecrypter.getCachedDecrypter(5911914670065936119L).setKey(-2807843261285066957L);
    SimpleLongDecrypter.getCachedDecrypter(-573477846487688903L).setKey(3890763785047867684L);
    SimpleLongDecrypter.getCachedDecrypter(1006479777789591839L).setKey(5443920390240649855L);
    SimpleLongDecrypter.getCachedDecrypter(-4119081505367320772L).setKey(-4275986266355747663L);
    SimpleLongDecrypter.getCachedDecrypter(-1887816211576534106L).setKey(-8690336269425706366L);
    SimpleLongDecrypter.getCachedDecrypter(2463301214826180439L).setKey(-5978132334723271455L);
    SimpleLongDecrypter.getCachedDecrypter(7111172057326609500L).setKey(8283277641315435323L);
    SimpleLongDecrypter.getCachedDecrypter(8766516853355131553L).setKey(-5212615444661332500L);
    SimpleLongDecrypter.getCachedDecrypter(5007249271847878662L).setKey(4441058969809918814L);
    SimpleLongDecrypter.getCachedDecrypter(-2970224626053022582L).setKey(382468668618750812L);
    SimpleLongDecrypter.getCachedDecrypter(-6677864814110756572L).setKey(2634770701616011444L);
    SimpleLongDecrypter.getCachedDecrypter(-6468547514026659306L).setKey(-7483038940864269757L);
    SimpleLongDecrypter.getCachedDecrypter(4682114190257787074L).setKey(-3853930675500381844L);
    SimpleLongDecrypter.getCachedDecrypter(-7833867237202226012L).setKey(-7805054304443169406L);
    SimpleLongDecrypter.getCachedDecrypter(4065260625511080882L).setKey(2607565472043212781L);
    SimpleLongDecrypter.getCachedDecrypter(7381032708487706369L).setKey(-3307969758850074938L);
    SimpleLongDecrypter.getCachedDecrypter(-3693553917105884630L).setKey(8269035842430493222L);
    SimpleLongDecrypter.getCachedDecrypter(-5053855578154580963L).setKey(-9209456472212049901L);
    SimpleLongDecrypter.getCachedDecrypter(-8511740574553855311L).setKey(7626466928877406653L);
    SimpleLongDecrypter.getCachedDecrypter(-7030342841381777723L).setKey(4989304533179679779L);
    SimpleLongDecrypter.getCachedDecrypter(3049693997601364838L).setKey(-2728911337724846130L);
    SimpleLongDecrypter.getCachedDecrypter(6016720464274110477L).setKey(-3718570006758994421L);
    SimpleLongDecrypter.getCachedDecrypter(6607476815559966932L).setKey(1674674256278021346L);
    SimpleLongDecrypter.getCachedDecrypter(1659632463936122267L).setKey(-6028775072294208885L);
    SimpleLongDecrypter.getCachedDecrypter(9205178327112664738L).setKey(2828182715083374010L);
    SimpleLongDecrypter.getCachedDecrypter(5493974790065734179L).setKey(-4952256888137280445L);
    SimpleLongDecrypter.getCachedDecrypter(4563874623434792125L).setKey(3883593514574278015L);
    SimpleLongDecrypter.getCachedDecrypter(-3256781516088119066L).setKey(1046532627320018821L);
    SimpleLongDecrypter.getCachedDecrypter(-1703746318022928778L).setKey(6994390224590131533L);
    SimpleLongDecrypter.getCachedDecrypter(8021859996962349944L).setKey(-1710920235439451988L);
    SimpleLongDecrypter.getCachedDecrypter(7851906839640367136L).setKey(-6933090428636989806L);
    SimpleLongDecrypter.getCachedDecrypter(9146855521411231959L).setKey(-947141584394396019L);
    SimpleLongDecrypter.getCachedDecrypter(-6266526246208461588L).setKey(1896917789148514587L);
    SimpleLongDecrypter.getCachedDecrypter(-2634713338843476531L).setKey(-7564602321956382779L);
    SimpleLongDecrypter.getCachedDecrypter(1929417923347365335L).setKey(8668079526748943650L);
    SimpleLongDecrypter.getCachedDecrypter(7196554171251666961L).setKey(-9089781471319680879L);
    SimpleLongDecrypter.getCachedDecrypter(-8717681974270813991L).setKey(-3265343286584338063L);
    SimpleLongDecrypter.getCachedDecrypter(5267054240807804926L).setKey(-7089863342401363671L);
    SimpleLongDecrypter.getCachedDecrypter(4707897738583609470L).setKey(-2750788856158894324L);
    SimpleLongDecrypter.getCachedDecrypter(-7709930666906625223L).setKey(-1650526389745103420L);
    SimpleLongDecrypter.getCachedDecrypter(5905889154830265453L).setKey(237260303989193977L);
    SimpleLongDecrypter.getCachedDecrypter(3460151430415803962L).setKey(7642628922853677331L);
    SimpleLongDecrypter.getCachedDecrypter(-5939205707035017166L).setKey(5182597777721676552L);
    SimpleLongDecrypter.getCachedDecrypter(7285685552597440122L).setKey(1892829306320380231L);
    SimpleLongDecrypter.getCachedDecrypter(-3087201396555530845L).setKey(3566289274759081939L);
    SimpleLongDecrypter.getCachedDecrypter(-2490265037597102566L).setKey(8933241049614026732L);
    SimpleLongDecrypter.getCachedDecrypter(6980846888997431969L).setKey(-567876113101377144L);
    SimpleLongDecrypter.getCachedDecrypter(6190821854749685534L).setKey(-8040677173311116835L);
    SimpleLongDecrypter.getCachedDecrypter(-4405129645094521677L).setKey(-2887391755369636841L);
    SimpleLongDecrypter.getCachedDecrypter(7336307638418133231L).setKey(-6473882355853138286L);
    SimpleLongDecrypter.getCachedDecrypter(1874325847388226783L).setKey(1007420570430200111L);
    SimpleLongDecrypter.getCachedDecrypter(-4783698781976891290L).setKey(758583846430267473L);
    SimpleLongDecrypter.getCachedDecrypter(-1665972668430910098L).setKey(-4293806176322383134L);
    SimpleLongDecrypter.getCachedDecrypter(495098579136551352L).setKey(6224929804663930405L);
    SimpleLongDecrypter.getCachedDecrypter(-919119802568830338L).setKey(-2376801067349665794L);
    SimpleLongDecrypter.getCachedDecrypter(7749703759857619959L).setKey(6813289184461950761L);
    SimpleLongDecrypter.getCachedDecrypter(1259293678681579173L).setKey(1402077429350663750L);
    SimpleLongDecrypter.getCachedDecrypter(10164190594098712L).setKey(3075400069898983901L);
    SimpleLongDecrypter.getCachedDecrypter(-4365145361755017210L).setKey(994628177040218192L);
    SimpleLongDecrypter.getCachedDecrypter(3390297568724184548L).setKey(41133437954504029L);
    SimpleLongDecrypter.getCachedDecrypter(5939055243760649417L).setKey(-8073664214695975741L);
    SimpleLongDecrypter.getCachedDecrypter(7614959749509304846L).setKey(-4872151556109024669L);
    SimpleLongDecrypter.getCachedDecrypter(-6246301343662307796L).setKey(-5896045735105115428L);
    SimpleLongDecrypter.getCachedDecrypter(-502442767605432475L).setKey(9122623449697960567L);
    SimpleLongDecrypter.getCachedDecrypter(6913996058601856951L).setKey(-1046524016562795440L);
    SimpleLongDecrypter.getCachedDecrypter(7920044364316957656L).setKey(149149251719098L);
    SimpleLongDecrypter.getCachedDecrypter(4091755288223162947L).setKey(5370539085744521437L);
    SimpleLongDecrypter.getCachedDecrypter(-515102505523155032L).setKey(3346669255090789240L);
    SimpleLongDecrypter.getCachedDecrypter(-8510472735147589712L).setKey(-6620110965156152965L);
    SimpleLongDecrypter.getCachedDecrypter(-5863539490158554661L).setKey(-8062037173391033474L);
    SimpleLongDecrypter.getCachedDecrypter(279491603758981652L).setKey(8188932406645186994L);
    SimpleLongDecrypter.getCachedDecrypter(6420021044833676295L).setKey(-8892081383469690292L);
    SimpleLongDecrypter.getCachedDecrypter(-7247434981751642018L).setKey(6497894257268704660L);
    SimpleLongDecrypter.getCachedDecrypter(-2746737735500034432L).setKey(2023029321312539996L);
    SimpleLongDecrypter.getCachedDecrypter(-4411585450060311107L).setKey(-2395944436243451981L);
    SimpleLongDecrypter.getCachedDecrypter(4400822799529157884L).setKey(1518027621284775535L);
    SimpleLongDecrypter.getCachedDecrypter(521707303394311365L).setKey(-1090248997130827260L);
    SimpleLongDecrypter.getCachedDecrypter(-1495726078563747913L).setKey(-9168756470984436693L);
    SimpleLongDecrypter.getCachedDecrypter(9187242807485593421L).setKey(2841775112782332214L);
    SimpleLongDecrypter.getCachedDecrypter(1673531541003005216L).setKey(2770736231055946631L);
    SimpleLongDecrypter.getCachedDecrypter(-4658300631227020072L).setKey(4978217767710511810L);
    SimpleLongDecrypter.getCachedDecrypter(-8098841699793767446L).setKey(5135592621622192944L);
    SimpleLongDecrypter.getCachedDecrypter(708368412006428006L).setKey(-8076732008785057043L);
    SimpleLongDecrypter.getCachedDecrypter(-7766668879875710190L).setKey(9123276767897055760L);
    SimpleLongDecrypter.getCachedDecrypter(8185645699486834072L).setKey(-921796621909573690L);
    SimpleLongDecrypter.getCachedDecrypter(-6634611569088503473L).setKey(1273690064716978536L);
    SimpleLongDecrypter.getCachedDecrypter(-6064768685997403317L).setKey(3939873926154255231L);
    SimpleLongDecrypter.getCachedDecrypter(-6611050873022000886L).setKey(1062877532315001433L);
    SimpleLongDecrypter.getCachedDecrypter(5758095442847240859L).setKey(4228487879271911410L);
    SimpleLongDecrypter.getCachedDecrypter(-884463287223078285L).setKey(2732430753959814186L);
    SimpleLongDecrypter.getCachedDecrypter(-589124203805027830L).setKey(-1022169198424312226L);
    SimpleLongDecrypter.getCachedDecrypter(-4655080943977004869L).setKey(-7653386684158221370L);
    SimpleLongDecrypter.getCachedDecrypter(-6526426113441039477L).setKey(-4004406200112090729L);
    SimpleLongDecrypter.getCachedDecrypter(770300017324614433L).setKey(2394010596344569549L);
    SimpleLongDecrypter.getCachedDecrypter(-1452656857693835301L).setKey(-7009068804071027772L);
    SimpleLongDecrypter.getCachedDecrypter(8401291156133336194L).setKey(-1401277406778547145L);
    SimpleLongDecrypter.getCachedDecrypter(-2828994187155729992L).setKey(-6443659150115479215L);
    SimpleLongDecrypter.getCachedDecrypter(-2011207011691712171L).setKey(-5213110272021443841L);
    SimpleLongDecrypter.getCachedDecrypter(2249856036124374452L).setKey(-6466860308165086807L);
    SimpleLongDecrypter.getCachedDecrypter(-7788938133524324498L).setKey(-6510221282562183413L);
    SimpleLongDecrypter.getCachedDecrypter(-5037185314123298401L).setKey(-5867528906693354927L);
    SimpleLongDecrypter.getCachedDecrypter(-1510948281590230502L).setKey(-8810096153482675633L);
    SimpleLongDecrypter.getCachedDecrypter(-7953219069237534698L).setKey(-832087038260698569L);
    SimpleLongDecrypter.getCachedDecrypter(-5155769274561546825L).setKey(-9171620653086226781L);
    SimpleLongDecrypter.getCachedDecrypter(-8209233629414814093L).setKey(-4491446445201861054L);
    SimpleLongDecrypter.getCachedDecrypter(1873196361262979007L).setKey(2367876954210595670L);
    SimpleLongDecrypter.getCachedDecrypter(-6579992968194807292L).setKey(1252913376633408873L);
    SimpleLongDecrypter.getCachedDecrypter(3961228563351972257L).setKey(-2861010341863799338L);
    SimpleLongDecrypter.getCachedDecrypter(-6116510587883646345L).setKey(-6837045282328287360L);
    SimpleLongDecrypter.getCachedDecrypter(-8297314815878062721L).setKey(7536309672331118079L);
    SimpleLongDecrypter.getCachedDecrypter(221113465814046912L).setKey(8416883923450760579L);
    SimpleLongDecrypter.getCachedDecrypter(7831123476562198820L).setKey(-5904738713013686836L);
    SimpleLongDecrypter.getCachedDecrypter(-5895272869755827768L).setKey(-8094665961859083805L);
    SimpleLongDecrypter.getCachedDecrypter(-358417461369493472L).setKey(-3517249009717202705L);
    SimpleLongDecrypter.getCachedDecrypter(-9164886757153534423L).setKey(1483680207747198236L);
    SimpleLongDecrypter.getCachedDecrypter(828930249830574562L).setKey(-4163834166761764900L);
    SimpleLongDecrypter.getCachedDecrypter(-1611910275418673458L).setKey(5296784550766968308L);
    SimpleLongDecrypter.getCachedDecrypter(339455154128939797L).setKey(3976093753246211601L);
    SimpleLongDecrypter.getCachedDecrypter(1365850457509950242L).setKey(2528000663314167470L);
    SimpleLongDecrypter.getCachedDecrypter(3787563210672871404L).setKey(-3054374952671945811L);
    SimpleLongDecrypter.getCachedDecrypter(-8639495167870452613L).setKey(-2369748414057014889L);
    SimpleLongDecrypter.getCachedDecrypter(4027215804921189334L).setKey(6279712721592966777L);
    SimpleLongDecrypter.getCachedDecrypter(3816700499520252794L).setKey(-5764733992549575860L);
    SimpleLongDecrypter.getCachedDecrypter(3418441750776435956L).setKey(-1063743065491247355L);
    SimpleLongDecrypter.getCachedDecrypter(-6607417528701499188L).setKey(-1174225231474707632L);
    SimpleLongDecrypter.getCachedDecrypter(-5839839812561808002L).setKey(5439398639199504395L);
    SimpleLongDecrypter.getCachedDecrypter(2884238535187981327L).setKey(-5868859234765545497L);
    SimpleLongDecrypter.getCachedDecrypter(-3696843822982333622L).setKey(-2886834358066980064L);
    SimpleLongDecrypter.getCachedDecrypter(5670249299290208544L).setKey(3013209532430044874L);
    SimpleLongDecrypter.getCachedDecrypter(8811730880608265670L).setKey(5231615948755850720L);
    SimpleLongDecrypter.getCachedDecrypter(9202347175859624348L).setKey(-6085275304804190434L);
    SimpleLongDecrypter.getCachedDecrypter(336390099385265504L).setKey(5966516958914412992L);
    SimpleLongDecrypter.getCachedDecrypter(-6999808076375415881L).setKey(-6961627622093704208L);
    SimpleLongDecrypter.getCachedDecrypter(-256558241295338890L).setKey(-5384220675547382066L);
    SimpleLongDecrypter.getCachedDecrypter(-6227151522745369905L).setKey(-1589625752524654915L);
    SimpleLongDecrypter.getCachedDecrypter(3175356676296263538L).setKey(-4709713544117095182L);
    SimpleLongDecrypter.getCachedDecrypter(-5491001464638784589L).setKey(1892723519919731278L);
    SimpleLongDecrypter.getCachedDecrypter(-3012433699890572474L).setKey(-8863801455278188208L);
    SimpleLongDecrypter.getCachedDecrypter(2853940824374390846L).setKey(719252433805748483L);
    SimpleLongDecrypter.getCachedDecrypter(3265561080342553744L).setKey(8753792381432326896L);
    SimpleLongDecrypter.getCachedDecrypter(-3863578664240812589L).setKey(7341564670325068361L);
    SimpleLongDecrypter.getCachedDecrypter(-8884740845746451614L).setKey(-4143342915404388063L);
    SimpleLongDecrypter.getCachedDecrypter(6351557484240604597L).setKey(3022359029747746628L);
    SimpleLongDecrypter.getCachedDecrypter(-7344061005315844306L).setKey(-2464345426878493919L);
    SimpleLongDecrypter.getCachedDecrypter(344181794462886863L).setKey(8252087999822629597L);
    SimpleLongDecrypter.getCachedDecrypter(6216305797600623986L).setKey(-2881897218492304972L);
    SimpleLongDecrypter.getCachedDecrypter(-593559873880319887L).setKey(400771775912075042L);
  }
}
