package uwu.narumi.deobfuscator.core.other.impl.exploit;

import uwu.narumi.deobfuscator.api.transformer.Transformer;

public class WebExploitRemoveTransformer extends Transformer {

  private boolean changed = false;

  @Override
  protected void transform() throws Exception {
    changed |= context().getClassesMap().entrySet().removeIf(entry -> entry.getKey().contains("<html>"));
    changed |= context().getFilesMap().entrySet().removeIf(entry -> entry.getKey().contains("<html>"));

    scopedClasses().forEach(classWrapper -> {
      changed |= classWrapper.methods().removeIf(methodNode -> methodNode.name.contains("<html>"));
      changed |= classWrapper.fields().removeIf(fieldNode -> fieldNode.name.contains("<html>") || fieldNode.desc.contains("<html>"));
    });

    if (changed) {
      markChange();
    }
  }
}
