# golintui

[![License: GPL v3](https://img.shields.io/badge/License-GPLv3-blue.svg)](https://www.gnu.org/licenses/gpl-3.0)

`golintui` is a TUI tool that helps you run various kinds of linters with ease and organize its results, with the power of [golangci-lint](https://github.com/golangci/golangci-lint).

![Screenshot](golintui.gif)

## Cool features

- Simple UI
- Selectable linters on the UI.
- Sorting out the issues for each linter
- Able to open files by specifying the issue line


## Installation

**Binary Releases**

For Mac OS or Linux, you can download a binary release [here](https://github.com/nakabonne/golintui/releases).

**With Homebrew**

```bash
brew install nakabonne/golintui/golintui
```

**With Go**

```bash
go get github.com/nakabonne/golintui
```

Note that `go get` downloads a bunch of dependencies on golangci-lint so can take a while to fully install.

**With Docker**

```bash
docker run --rm -i -t -v $(pwd):/app -w /app nakabonne/golintui:latest golintui
```

## Usage

Requires: [golangci-lint](https://github.com/golangci/golangci-lint) executable.  
  
Be sure to change the CTYPE as shown below if your locale isn't `en_US`. The UI does not display well without it.

```bash
export LC_CTYPE=en_US.UTF-8
```

### Quick Start

```bash
golintui
```

Just press <kbd>r</kbd>, then results from the linters should be shown.

### Keybinds

**Global**

<pre>
  <kbd>r</kbd>: run selected linters against the selected directories
  <kbd>q</kbd>: quit
  <kbd>l</kbd>: next panel
  <kbd>h</kbd>: previous panel
  <kbd>j</kbd>: move down
  <kbd>k</kbd>: move up
</pre>

**Linters Panel**

<pre>
  <kbd>space</kbd>: toggle enabled
</pre>

Note that for users who specify `disable-all` in the config file for golangci-lint, it is impossible to disable linters that are enabled in it.

**Source File Panel**

<pre>
  <kbd>space</kbd>: toggle selected
  <kbd>o</kbd>: expand directory
</pre>

**Commits Panel**

<pre>
  <kbd>space</kbd>: toggle selected
</pre>

It shows only new issues created after the commit you selected. Internally it just gives it on to `--new-from-rev`.

**Results Panel**

<pre>
  <kbd>o</kbd>: open a file with the reported line
</pre>

## Settings

### Editor
`golintui` refers to `$EDITOR` by default to open the problematic file. You can change the editor to your taste and habits by setting `$GOLINTUI_OPEN_COMMAND`.  

For instance, for users of VSCode:

```bash
export GOLINTUI_OPEN_COMMAND="code -r"
```

## Editors that can open by specifying a line

- vim(vi)
- emacs
- VSCode

Please let me know how to open a file at a specific line if the editor you're used to is missing.

## License Scan

[![FOSSA Status](https://app.fossa.com/api/projects/custom%2B19582%2Fssh%3A%2F%2Fgit%40github.com%2Fnakabonne%2Fgolintui.git.svg?type=large)](https://app.fossa.com/projects/custom%2B19582%2Fssh%3A%2F%2Fgit%40github.com%2Fnakabonne%2Fgolintui.git?ref=badge_large)
