# 《Unix系统编程》读书笔记-文件系统

![文件系统](https://ssl.aicode.cc/%E6%96%87%E4%BB%B6%E7%B3%BB%E7%BB%9F.png)

[TOC]

## 设备专用文件 

在内核中，每种设备类型都有与之相对应的设 备驱动程序，用来处理设备的所有 I/O 请求。设备驱动程序属内核代码单元，可执行一系列操 作，（通常）与相关硬件的输入/输出动作相对应。由设备驱动程序提供的 API 是固定的，包含的操作对应于系统调用 open()、close()、read()、write()、mmap()以及 ioctl()。

可将设备划分为以下两种类型

- 字符型设备基于每个字符来处理数据。终端和键盘都属于字符型设备
- 块设备则每次处理一块数据。块的大小取决于设备类型，但通常为 512 字节的倍数。 磁盘和磁带设备都属于块设备

设备 ID: 

- 每个设备文件都有主、辅 ID 号各一。主 ID 号标识一般的设备等级，内核会使用主 ID 号 查找与该类设备相应的驱动程序。辅 ID 号能够在一般等级中唯一标识特定设备。命令 ls –l 可显示出设备文件的主、辅 ID
- 设备文件的 i 节点中记录了设备文件的主、辅 ID

## 磁盘和分区

可将每块磁盘划分为一个或多个（不重叠的）分区。内核则将每个分区视为位于/dev 路 径下的单独设备。

磁盘分区可容纳任何类型的信息

- 文件系统：用来存放常规文件
- 数据区域：可做为裸设备对其进行访问
- 交换区域：供内核的内存管理之用

    > 可使用 Linux 专有文件/proc/swaps 来查看系统中当前已激活交换区域的信息

## 文件系统

> 从 Linux 的专有文件/proc/filesystems 中可以查看当前为内核所知的文件系统类型

传统文件系统 ext2文件系统（非日志文件系统）。在文件系统中，用来分配空间的基本单位是逻辑块，亦即文件系统所在磁盘设备上若干连续的物理块。

文件系统由以下几部分组成

![-w500](https://ssl.aicode.cc/15511121108814.jpg)

- **引导块**：总是作为文件系统的首块。引导块不为文件系统所用，只是包含用来引导操作系统的信息。
- **超级块**：紧随引导块之后的一个独立块，包含与文件系统有关的参数信息
    - i 节点表容量
    - 文件系统中逻辑块的大小
    - 以逻辑块计，文件系统的大小

- **i 节点表**：文件系统中的每个文件或目录在 i 节点表中都对应着唯一一条记录
- **数据块**：文件系统的大部分空间都用于存放数据，以构成驻留于文件系统之上的文件和目录

## i 节点

针对驻留于文件系统上的每个文件，文件系统的 i 节点表会包含一个 i 节点。

i 节点所维护的信息包含

- 文件类型
- 文件属主
- 文件属组
- 3 类用户的访问权限
- 对文件的最后访问时间（ls –lu 所显示的时间）
- 对文件的最后修改时间（也是 ls –l 所默认显示的时间）
- 文件状态的最后改变时间（ls –lc 所显示的最后 改变 i 节点信息的时间）
- 指向文件的硬链接数量
- 文件的大小，以字节为单位
- 实际分配给文件的块数量，以 512 字节块为单位
- 指向文件数据块的指针

## 虚拟文件系统VFS

虚拟文件系统 （VFS，有时也称为虚拟文件交换）是一种内核特性，通过为文件系统操作创建抽象层来解决各种底层文件系统的差异性。

![-w500](https://ssl.aicode.cc/15511122803031.jpg)


- VFS 针对文件系统定义了一套通用接口。
- 每种文件系统都会提供 VFS 接口的实现

VFS 接口的操作与涉及文件系统和目录的所有常规系统调用相对应，这些系统调用有 `open()`、`read()`、`write()`、`lseek()`、`close()`、`truncate()`、`stat()`、`vmount()`、`umount()`、`mmap()`、`mkdir()`、 `link()`、`unlink()`、`symlink()` 以及 `rename()`。

## 日志文件系统

采用日志文件系统，则无需在系统崩溃后对文件进行漫长的一致性检查。

在实际更新文件之前，日志文件系统会记录元数据更新（还可有选择地记录数据更新和文件 系统更新）。这也意味着，一旦系统崩溃，系统可以重放（replay）日志文件，并迅速将文件 系统恢复到一致状态。

日志文件系统最为昭著的臭名在于增加了文件更新的时间，当然，良好的设计可以降低这方面的开销。

Linux支持的日志文件系统：

- Reiserfs 是首个被集成进内核（版本号为 2.4.1）的日志文件系统
- ext3 文件系统，源于一个旨在以最小改动为 ext2 追加日志功能的项目
- JFS
- XFS
- ext4 文件系统
- Btrfs（B-树 FS， 一般读作“butter FS”）

## 文件系统的挂载和卸载

> 系统调用 mount()和 umount()运行特权级进程(CAP_SYS_ADMIN)以挂载或卸载文件系统。

- 通过 Linux 专有的虚拟文件/proc/mounts， 可查看当前已挂载文件系统的列表。
- mount(8)和 umount(8)命令会自动维护/etc/mtab 文件。但是系统调用 mount()和 umount()并不更新/etc/mtab， 如果某些挂载或卸载了设备的应用程序没有更新该文件，那么/etc/mtab 可能会变得不准确。
- /etc/fstab（由系统管理员手工维护）包含了对系统支持的所有文件系统的描述， 该文件可供 mount(8)、umount(8)以及 fsck(8)所用。

fstab格式

![-w240](https://ssl.aicode.cc/15511125475617.jpg)

- 已挂载设备名
- 设备的挂载点
- 文件系统类型
- 挂载标志
- 一个数字， dump(8)会使用其来控制对文件系统的备份操作。 只有/etc/fstab 文件才会用到该字段和第 6 个字段，在/proc/mounts 和/etc/mtab 中，该字段总是为 0
- 一个数字，在系统引导时，用于控制 fsck(8)对文件系统的检查顺序

相关系统调用：

mount()系统调用将由 source 指定设备所包含的文件系统，挂载到由 target 指定的目录下

![-w806](https://ssl.aicode.cc/15511126140831.jpg)

umount()系统调用用于卸载已挂载的文件系统

![-w801](https://ssl.aicode.cc/15511126348882.jpg)

系统调用 umount2()是 umount()的扩展版。 通过 flags 参数， umount2()可对卸载操作施以 更精密的控制

![-w803](https://ssl.aicode.cc/15511126500245.jpg)


## 虚拟内存文件系统：tmpfs

该文件系统不但使用 RAM， 而且在 RAM 耗尽的情况下，还会利用交换空间。

要创建 tmpfs 文件系统，请使用如下形式的命令

![-w307](https://ssl.aicode.cc/15511127003907.jpg)


特殊用途

- 由内核内部挂载的隐形 tmpfs 文件系统，用于实现 System V 共享内存和 共享匿名内存映射
- 挂载于/dev/shm 的 tmpfs 文件系统，为 glibc 用以实现 POSIX 共享内存和 POSIX 信号量

## 获得与文件系统有关的信息：statvfs()

statvfs()和 fstatvfs()库函数能够获得与已挂载文件系统有关的信息

![-w804](https://ssl.aicode.cc/15511127542028.jpg)

参数导出的返回值statvfs结构体

![-w801](https://ssl.aicode.cc/15511127873964.jpg)


> 许多原生 UNIX 和 Linux 文件系统，都支持为超级用户预留一部分文件系统块，如 此一来，即便在文件系统空间耗尽的情况下，超级用户仍可以登录系统解决故障。
