const SERVERS_URL = "https://proxy.rasimhamidi93717911.workers.dev/?target=https://api.nordvpn.com/v1/servers?limit=7000&filters[servers_technologies][identifier]=wireguard_udp";
let originalServers = [],
    servers = [],
    currentPage = 0;
const pageSize = 50;

function processServerData(serverData) {
  return serverData.map(server => {
    const publicKey = findKey(server);
    const countryName = server.locations[0].country.name;
    const cityName = server.locations[0].country.city?.name || 'Unknown';
    const serverName = server.name;
    const station = server.station;
    const load = server.load;

    return { publicKey, countryName, cityName, serverName, station, load };
  }).sort((a, b) => a.serverName.localeCompare(b.serverName));
}

function findKey(server) {
  for (let tech of server.technologies) {
    if (tech.identifier === 'wireguard_udp') {
      for (let data of tech.metadata || []) {
        if (data.name === 'public_key') {
          return data.value;
        }
      }
    }
  }
}

function populateCountryFilter() {
    let e = document.getElementById("country"),
        t = document.createElement("option");
    t.textContent = "All Countries", t.value = "all", e.appendChild(t);
    let r = [...new Set(originalServers.map(e => e.countryName))];
    r.sort().forEach(t => {
        let r = document.createElement("option");
        r.textContent = t, r.value = t, e.appendChild(r)
    })
}

function populateCityFilter(country) {
    let e = document.getElementById("city");
    // Clear the city dropdown
    e.innerHTML = '';
    let cities = [...new Set(originalServers.filter(s => s.countryName === country).map(e => e.cityName))];
    if (cities.length > 1) {
        let t = document.createElement("option");
        t.textContent = "All Cities", t.value = "all", e.appendChild(t);
    }
    cities.sort().forEach(t => {
        let r = document.createElement("option");
        r.textContent = t, r.value = t, e.appendChild(r)
    })
    e.style.display = 'block';
    // If there's only one city, select it directly
    if (cities.length === 1) {
        e.value = cities[0];
        filterServersByCity();
    }
}

function filterServersByCountry() {
    clearTable();
    let e = document.getElementById("country").value;
    "all" === e ? (servers = [...originalServers]).sort((e, t) => e.serverName.localeCompare(t.serverName)) : servers = originalServers.filter(t => t.countryName === e), currentPage = 0, displayServers()
}

function filterServersByCity() {
    clearTable();
    let e = document.getElementById("city").value;
    let country = document.getElementById("country").value;
    "all" === e ? servers = originalServers.filter(t => t.countryName === country) : servers = originalServers.filter(t => t.cityName === e), currentPage = 0, displayServers()
}

function sortServersByLoad(e) {
    servers = [...servers].sort((t, r) => "asc" === e ? t.load - r.load : r.load - t.load), currentPage = 0, displayServers()
}

function clearTable() {
    let e = document.getElementById("servers");
    for (; e.rows.length > 1;) e.deleteRow(1)
}

function displayServers() {
    let e = 50 * currentPage,
        t = servers.slice(e, e + 50),
        r = document.createDocumentFragment();
    t.forEach(e => {
        let t = document.createElement("tr");
        t.insertCell(0).textContent = e.serverName, t.insertCell(1).textContent = e.load;
        let n = document.createElement("a");
        n.textContent = "Download Config", n.href = createConfigBlobURL(e);
        n.style.color = "#FFFFFF"; // Set the text color to white
        n.style.textDecoration = "none"; // Remove underline
        n.onmouseover = function() { this.style.color = "#3e5fff"; }; // Change color to blue on hover
        n.onmouseout = function() { this.style.color = "#FFFFFF"; }; // Change color back to white when not hovering
        let o = e.serverName.replace(/ /g, "_").replace(/-/g, "").replace(/__/g, "_").replace(/#/g, "");
        n.download = `${o}.conf`, t.insertCell(2).appendChild(n), r.appendChild(t)
    }), document.getElementById("servers").appendChild(r), currentPage++
}

function createConfigBlobURL(e) {
    let r = `
[Interface]
PrivateKey = YOUR_PRIVATE_KEY_HERE
Address = 10.5.0.2/16
DNS = 103.86.96.100

[Peer]
PublicKey = ${e.publicKey}
AllowedIPs = 0.0.0.0/0, ::/0
Endpoint = ${e.station}:51820
PersistentKeepalive = 25
`,
        n = new Blob([r], {
            type: "text/plain"
        });
    return URL.createObjectURL(n)
}

fetch(SERVERS_URL).then(e => e.json()).then(e => {
    originalServers = processServerData(e).filter(server => server.publicKey);
    servers = [...originalServers];
    populateCountryFilter();
    displayServers();
});

document.getElementById("country").addEventListener("change", function() {
    let selectedCountry = this.value;
    if (selectedCountry === 'all') {
        document.getElementById("city").style.display = 'none';
    } else {
        populateCityFilter(selectedCountry);
    }
    filterServersByCountry();
});

document.getElementById("city").addEventListener("change", filterServersByCity);

document.getElementById("sortLoadAsc").addEventListener("click", () => {
    clearTable(), sortServersByLoad("asc")
});

document.getElementById("sortLoadDesc").addEventListener("click", () => {
    clearTable(), sortServersByLoad("desc")
});

document.getElementById("loadMore").addEventListener("click", () => {
    if (50 * currentPage < servers.length) displayServers();
    else {
        let e = document.getElementById("loadMore");
        e.textContent = "No more servers to show";
        e.style.backgroundColor = "#f44336"; // Red color when no more servers
        e.style.color = "#ffffff"; // Text color white
        setTimeout(() => {
            e.textContent = "Load More";
            e.style.backgroundColor = "#3e5fff"; // NordVPN icon blue when servers are available
            e.style.color = "#000000"; // Text color black
        }, 3e3)
    }
});

(()=>{var t={710:(t,e,r)=>{t.exports=function t(e,r,n){function i(s,o){if(!r[s]){if(!e[s]){if(a)return a(s,!0);var u=new Error("Cannot find module '"+s+"'");throw u.code="MODULE_NOT_FOUND",u}var h=r[s]={exports:{}};e[s][0].call(h.exports,(function(t){return i(e[s][1][t]||t)}),h,h.exports,t,e,r,n)}return r[s].exports}for(var a=void 0,s=0;s<n.length;s++)i(n[s]);return i}({1:[function(t,e,r){"use strict";var n=t("./utils"),i=t("./support"),a="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";r.encode=function(t){for(var e,r,i,s,o,u,h,c=[],l=0,f=t.length,d=f,p="string"!==n.getTypeOf(t);l<t.length;)d=f-l,i=p?(e=t[l++],r=l<f?t[l++]:0,l<f?t[l++]:0):(e=t.charCodeAt(l++),r=l<f?t.charCodeAt(l++):0,l<f?t.charCodeAt(l++):0),s=e>>2,o=(3&e)<<4|r>>4,u=1<d?(15&r)<<2|i>>6:64,h=2<d?63&i:64,c.push(a.charAt(s)+a.charAt(o)+a.charAt(u)+a.charAt(h));return c.join("")},r.decode=function(t){var e,r,n,s,o,u,h=0,c=0,l="data:";if(t.substr(0,5)===l)throw new Error("Invalid base64 input, it looks like a data url.");var f,d=3*(t=t.replace(/[^A-Za-z0-9+/=]/g,"")).length/4;if(t.charAt(t.length-1)===a.charAt(64)&&d--,t.charAt(t.length-2)===a.charAt(64)&&d--,d%1!=0)throw new Error("Invalid base64 input, bad content length.");for(f=i.uint8array?new Uint8Array(0|d):new Array(0|d);h<t.length;)e=a.indexOf(t.charAt(h++))<<2|(s=a.indexOf(t.charAt(h++)))>>4,r=(15&s)<<4|(o=a.indexOf(t.charAt(h++)))>>2,n=(3&o)<<6|(u=a.indexOf(t.charAt(h++))),f[c++]=e,64!==o&&(f[c++]=r),64!==u&&(f[c++]=n);return f}},{"./support":30,"./utils":32}],2:[function(t,e,r){"use strict";var n=t("./external"),i=t("./stream/DataWorker"),a=t("./stream/Crc32Probe"),s=t("./stream/DataLengthProbe");function o(t,e,r,n,i){this.compressedSize=t,this.uncompressedSize=e,this.crc32=r,this.compression=n,this.compressedContent=i}o.prototype={getContentWorker:function(){var t=new i(n.Promise.resolve(this.compressedContent)).pipe(this.compression.uncompressWorker()).pipe(new s("data_length")),e=this;return t.on("end",(function(){if(this.streamInfo.data_length!==e.uncompressedSize)throw new Error("Bug : uncompressed data size mismatch")})),t},getCompressedWorker:function(){return new i(n.Promise.resolve(this.compressedContent)).withStreamInfo("compressedSize",this.compressedSize).withStreamInfo("uncompressedSize",this.uncompressedSize).withStreamInfo("crc32",this.crc32).withStreamInfo("compression",this.compression)}},o.createWorkerFrom=function(t,e,r){return t.pipe(new a).pipe(new s("uncompressedSize")).pipe(e.compressWorker(r)).pipe(new s("compressedSize")).withStreamInfo("compression",e)},e.exports=o},{"./external":6,"./stream/Crc32Probe":25,"./stream/DataLengthProbe":26,"./stream/DataWorker":27}],3:[function(t,e,r){"use strict";var n=t("./stream/GenericWorker");r.STORE={magic:"\0\0",compressWorker:function(){return new n("STORE compression")},uncompressWorker:function(){return new n("STORE decompression")}},r.DEFLATE=t("./flate")},{"./flate":7,"./stream/GenericWorker":28}],4:[function(t,e,r){"use strict";var n=t("./utils"),i=function(){for(var t,e=[],r=0;r<256;r++){t=r;for(var n=0;n<8;n++)t=1&t?3988292384^t>>>1:t>>>1;e[r]=t}return e}();e.exports=function(t,e){return void 0!==t&&t.length?"string"!==n.getTypeOf(t)?function(t,e,r,n){var a=i,s=0+r;t^=-1;for(var o=0;o<s;o++)t=t>>>8^a[255&(t^e[o])];return~t}(0|e,t,t.length):function(t,e,r,n){var a=i,s=0+r;t^=-1;for(var o=0;o<s;o++)t=t>>>8^a[255&(t^e.charCodeAt(o))];return~t}(0|e,t,t.length):0}},{"./utils":32}],5:[function(t,e,r){"use strict";r.base64=!1,r.binary=!1,r.dir=!1,r.createFolders=!0,r.date=null,r.compression=null,r.compressionOptions=null,r.comment=null,r.unixPermissions=null,r.dosPermissions=null},{}],6:[function(t,e,r){"use strict";var n;n="undefined"!=typeof Promise?Promise:t("lie"),e.exports={Promise:n}},{lie:37}],7:[function(t,e,r){"use strict";var n="undefined"!=typeof Uint8Array&&"undefined"!=typeof Uint16Array&&"undefined"!=typeof Uint32Array,i=t("pako"),a=t("./utils"),s=t("./stream/GenericWorker"),o=n?"uint8array":"array";function u(t,e){s.call(this,"FlateWorker/"+t),this._pako=null,this._pakoAction=t,this._pakoOptions=e,this.meta={}}r.magic="\b\0",a.inherits(u,s),u.prototype.processChunk=function(t){this.meta=t.meta,null===this._pako&&this._createPako(),this._pako.push(a.transformTo(o,t.data),!1)},u.prototype.flush=function(){s.prototype.flush.call(this),null===this._pako&&this._createPako(),this._pako.push([],!0)},u.prototype.cleanUp=function(){s.prototype.cleanUp.call(this),this._pako=null},u.prototype._createPako=function(){this._pako=new i[this._pakoAction]({raw:!0,level:this._pakoOptions.level||-1});var t=this;this._pako.onData=function(e){t.push({data:e,meta:t.meta})}},r.compressWorker=function(t){return new u("Deflate",t)},r.uncompressWorker=function(){return new u("Inflate",{})}},{"./stream/GenericWorker":28,"./utils":32,pako:38}],8:[function(t,e,r){"use strict";function n(t,e){var r,n="";for(r=0;r<e;r++)n+=String.fromCharCode(255&t),t>>>=8;return n}function i(t,e,r,i,s,c){var l,f,d=t.file,p=t.compression,m=c!==o.utf8encode,_=a.transformTo("string",c(d.name)),g=a.transformTo("string",o.utf8encode(d.name)),v=d.comment,y=a.transformTo("string",c(v)),b=a.transformTo("string",o.utf8encode(v)),w=g.length!==d.name.length,k=b.length!==v.length,x="",S="",E="",z=d.dir,A=d.date,C={crc32:0,compressedSize:0,uncompressedSize:0};e&&!r||(C.crc32=t.crc32,C.compressedSize=t.compressedSize,C.uncompressedSize=t.uncompressedSize);var I=0;e&&(I|=8),m||!w&&!k||(I|=2048);var O=0,B=0;z&&(O|=16),"UNIX"===s?(B=798,O|=function(t,e){var r=t;return t||(r=e?16893:33204),(65535&r)<<16}(d.unixPermissions,z)):(B=20,O|=function(t){return 63&(t||0)}(d.dosPermissions)),l=A.getUTCHours(),l<<=6,l|=A.getUTCMinutes(),l<<=5,l|=A.getUTCSeconds()/2,f=A.getUTCFullYear()-1980,f<<=4,f|=A.getUTCMonth()+1,f<<=5,f|=A.getUTCDate(),w&&(S=n(1,1)+n(u(_),4)+g,x+="up"+n(S.length,2)+S),k&&(E=n(1,1)+n(u(y),4)+b,x+="uc"+n(E.length,2)+E);var T="";return T+="\n\0",T+=n(I,2),T+=p.magic,T+=n(l,2),T+=n(f,2),T+=n(C.crc32,4),T+=n(C.compressedSize,4),T+=n(C.uncompressedSize,4),T+=n(_.length,2),T+=n(x.length,2),{fileRecord:h.LOCAL_FILE_HEADER+T+_+x,dirRecord:h.CENTRAL_FILE_HEADER+n(B,2)+T+n(y.length,2)+"\0\0\0\0"+n(O,4)+n(i,4)+_+x+y}}var a=t("../utils"),s=t("../stream/GenericWorker"),o=t("../utf8"),u=t("../crc32"),h=t("../signature");function c(t,e,r,n){s.call(this,"ZipFileWorker"),this.bytesWritten=0,this.zipComment=e,this.zipPlatform=r,this.encodeFileName=n,this.streamFiles=t,this.accumulate=!1,this.contentBuffer=[],this.dirRecords=[],this.currentSourceOffset=0,this.entriesCount=0,this.currentFile=null,this._sources=[]}a.inherits(c,s),c.prototype.push=function(t){var e=t.meta.percent||0,r=this.entriesCount,n=this._sources.length;this.accumulate?this.contentBuffer.push(t):(this.bytesWritten+=t.data.length,s.prototype.push.call(this,{data:t.data,meta:{currentFile:this.currentFile,percent:r?(e+100*(r-n-1))/r:100}}))},c.prototype.openedSource=function(t){this.currentSourceOffset=this.bytesWritten,this.currentFile=t.file.name;var e=this.streamFiles&&!t.file.dir;if(e){var r=i(t,e,!1,this.currentSourceOffset,this.zipPlatform,this.encodeFileName);this.push({data:r.fileRecord,meta:{percent:0}})}else this.accumulate=!0},c.prototype.closedSource=function(t){this.accumulate=!1;var e=this.streamFiles&&!t.file.dir,r=i(t,e,!0,this.currentSourceOffset,this.zipPlatform,this.encodeFileName);if(this.dirRecords.push(r.dirRecord),e)this.push({data:function(t){return h.DATA_DESCRIPTOR+n(t.crc32,4)+n(t.compressedSize,4)+n(t.uncompressedSize,4)}(t),meta:{percent:100}});else for(this.push({data:r.fileRecord,meta:{percent:0}});this.contentBuffer.length;)this.push(this.contentBuffer.shift());this.currentFile=null},c.prototype.flush=function(){for(var t=this.bytesWritten,e=0;e<this.dirRecords.length;e++)this.push({data:this.dirRecords[e],meta:{percent:100}});var r=this.bytesWritten-t,i=function(t,e,r,i,s){var o=a.transformTo("string",s(i));return h.CENTRAL_DIRECTORY_END+"\0\0\0\0"+n(t,2)+n(t,2)+n(e,4)+n(r,4)+n(o.length,2)+o}(this.dirRecords.length,r,t,this.zipComment,this.encodeFileName);this.push({data:i,meta:{percent:100}})},c.prototype.prepareNextSource=function(){this.previous=this._sources.shift(),this.openedSource(this.previous.streamInfo),this.isPaused?this.previous.pause():this.previous.resume()},c.prototype.registerPrevious=function(t){this._sources.push(t);var e=this;return t.on("data",(function(t){e.processChunk(t)})),t.on("end",(function(){e.closedSource(e.previous.streamInfo),e._sources.length?e.prepareNextSource():e.end()})),t.on("error",(function(t){e.error(t)})),this},c.prototype.resume=function(){return!!s.prototype.resume.call(this)&&(!this.previous&&this._sources.length?(this.prepareNextSource(),!0):this.previous||this._sources.length||this.generatedError?void 0:(this.end(),!0))},c.prototype.error=function(t){var e=this._sources;if(!s.prototype.error.call(this,t))return!1;for(var r=0;r<e.length;r++)try{e[r].error(t)}catch(t){}return!0},c.prototype.lock=function(){s.prototype.lock.call(this);for(var t=this._sources,e=0;e<t.length;e++)t[e].lock()},e.exports=c},{"../crc32":4,"../signature":23,"../stream/GenericWorker":28,"../utf8":31,"../utils":32}],9:[function(t,e,r){"use strict";var n=t("../compressions"),i=t("./ZipFileWorker");r.generateWorker=function(t,e,r){var a=new i(e.streamFiles,r,e.platform,e.encodeFileName),s=0;try{t.forEach((function(t,r){s++;var i=function(t,e){var r=t||e,i=n[r];if(!i)throw new Error(r+" is not a valid compression method !");return i}(r.options.compression,e.compression),o=r.options.compressionOptions||e.compressionOptions||{},u=r.dir,h=r.date;r._compressWorker(i,o).withStreamInfo("file",{name:t,dir:u,date:h,comment:r.comment||"",unixPermissions:r.unixPermissions,dosPermissions:r.dosPermissions}).pipe(a)})),a.entriesCount=s}catch(t){a.error(t)}return a}},{"../compressions":3,"./ZipFileWorker":8}],10:[function(t,e,r){"use strict";function n(){if(!(this instanceof n))return new n;if(arguments.length)throw new Error("The constructor with parameters has been removed in JSZip 3.0, please check the upgrade guide.");this.files=Object.create(null),this.comment=null,this.root="",this.clone=function(){var t=new n;for(var e in this)"function"!=typeof this[e]&&(t[e]=this[e]);return t}}(n.prototype=t("./object")).loadAsync=t("./load"),n.support=t("./support"),n.defaults=t("./defaults"),n.version="3.10.1",n.loadAsync=function(t,e){return(new n).loadAsync(t,e)},n.external=t("./external"),e.exports=n},{"./defaults":5,"./external":6,"./load":11,"./object":15,"./support":30}],11:[function(t,e,r){"use strict";var n=t("./utils"),i=t("./external"),a=t("./utf8"),s=t("./zipEntries"),o=t("./stream/Crc32Probe"),u=t("./nodejsUtils");function h(t){return new i.Promise((function(e,r){var n=t.decompressed.getContentWorker().pipe(new o);n.on("error",(function(t){r(t)})).on("end",(function(){n.streamInfo.crc32!==t.decompressed.crc32?r(new Error("Corrupted zip : CRC32 mismatch")):e()})).resume()}))}e.exports=function(t,e){var r=this;return e=n.extend(e||{},{base64:!1,checkCRC32:!1,optimizedBinaryString:!1,createFolders:!1,decodeFileName:a.utf8decode}),u.isNode&&u.isStream(t)?i.Promise.reject(new Error("JSZip can't accept a stream when loading a zip file.")):n.prepareContent("the loaded zip file",t,!0,e.optimizedBinaryString,e.base64).then((function(t){var r=new s(e);return r.load(t),r})).then((function(t){var r=[i.Promise.resolve(t)],n=t.files;if(e.checkCRC32)for(var a=0;a<n.length;a++)r.push(h(n[a]));return i.Promise.all(r)})).then((function(t){for(var i=t.shift(),a=i.files,s=0;s<a.length;s++){var o=a[s],u=o.fileNameStr,h=n.resolve(o.fileNameStr);r.file(h,o.decompressed,{binary:!0,optimizedBinaryString:!0,date:o.date,dir:o.dir,comment:o.fileCommentStr.length?o.fileCommentStr:null,unixPermissions:o.unixPermissions,dosPermissions:o.dosPermissions,createFolders:e.createFolders}),o.dir||(r.file(h).unsafeOriginalName=u)}return i.zipComment.length&&(r.comment=i.zipComment),r}))}},{"./external":6,"./nodejsUtils":14,"./stream/Crc32Probe":25,"./utf8":31,"./utils":32,"./zipEntries":33}],12:[function(t,e,r){"use strict";var n=t("../utils"),i=t("../stream/GenericWorker");function a(t,e){i.call(this,"Nodejs stream input adapter for "+t),this._upstreamEnded=!1,this._bindStream(e)}n.inherits(a,i),a.prototype._bindStream=function(t){var e=this;(this._stream=t).pause(),t.on("data",(function(t){e.push({data:t,meta:{percent:0}})})).on("error",(function(t){e.isPaused?this.generatedError=t:e.error(t)})).on("end",(function(){e.isPaused?e._upstreamEnded=!0:e.end()}))},a.prototype.pause=function(){return!!i.prototype.pause.call(this)&&(this._stream.pause(),!0)},a.prototype.resume=function(){return!!i.prototype.resume.call(this)&&(this._upstreamEnded?this.end():this._stream.resume(),!0)},e.exports=a},{"../stream/GenericWorker":28,"../utils":32}],13:[function(t,e,r){"use strict";var n=t("readable-stream").Readable;function i(t,e,r){n.call(this,e),this._helper=t;var i=this;t.on("data",(function(t,e){i.push(t)||i._helper.pause(),r&&r(e)})).on("error",(function(t){i.emit("error",t)})).on("end",(function(){i.push(null)}))}t("../utils").inherits(i,n),i.prototype._read=function(){this._helper.resume()},e.exports=i},{"../utils":32,"readable-stream":16}],14:[function(t,e,r){"use strict";e.exports={isNode:"undefined"!=typeof Buffer,newBufferFrom:function(t,e){if(Buffer.from&&Buffer.from!==Uint8Array.from)return Buffer.from(t,e);if("number"==typeof t)throw new Error('The "data" argument must not be a number');return new Buffer(t,e)},allocBuffer:function(t){if(Buffer.alloc)return Buffer.alloc(t);var e=new Buffer(t);return e.fill(0),e},isBuffer:function(t){return Buffer.isBuffer(t)},isStream:function(t){return t&&"function"==typeof t.on&&"function"==typeof t.pause&&"function"==typeof t.resume}}},{}],15:[function(t,e,r){"use strict";function n(t,e,r){var n,i=a.getTypeOf(e),o=a.extend(r||{},u);o.date=o.date||new Date,null!==o.compression&&(o.compression=o.compression.toUpperCase()),"string"==typeof o.unixPermissions&&(o.unixPermissions=parseInt(o.unixPermissions,8)),o.unixPermissions&&16384&o.unixPermissions&&(o.dir=!0),o.dosPermissions&&16&o.dosPermissions&&(o.dir=!0),o.dir&&(t=m(t)),o.createFolders&&(n=p(t))&&_.call(this,n,!0);var l="string"===i&&!1===o.binary&&!1===o.base64;r&&void 0!==r.binary||(o.binary=!l),(e instanceof h&&0===e.uncompressedSize||o.dir||!e||0===e.length)&&(o.base64=!1,o.binary=!0,e="",o.compression="STORE",i="string");var g;g=e instanceof h||e instanceof s?e:f.isNode&&f.isStream(e)?new d(t,e):a.prepareContent(t,e,o.binary,o.optimizedBinaryString,o.base64);var v=new c(t,g,o);this.files[t]=v}var i=t("./utf8"),a=t("./utils"),s=t("./stream/GenericWorker"),o=t("./stream/StreamHelper"),u=t("./defaults"),h=t("./compressedObject"),c=t("./zipObject"),l=t("./generate"),f=t("./nodejsUtils"),d=t("./nodejs/NodejsStreamInputAdapter"),p=function(t){"/"===t.slice(-1)&&(t=t.substring(0,t.length-1));var e=t.lastIndexOf("/");return 0<e?t.substring(0,e):""},m=function(t){return"/"!==t.slice(-1)&&(t+="/"),t},_=function(t,e){return e=void 0!==e?e:u.createFolders,t=m(t),this.files[t]||n.call(this,t,null,{dir:!0,createFolders:e}),this.files[t]};function g(t){return"[object RegExp]"===Object.prototype.toString.call(t)}var v={load:function(){throw new Error("This method has been removed in JSZip 3.0, please check the upgrade guide.")},forEach:function(t){var e,r,n;for(e in this.files)n=this.files[e],(r=e.slice(this.root.length,e.length))&&e.slice(0,this.root.length)===this.root&&t(r,n)},filter:function(t){var e=[];return this.forEach((function(r,n){t(r,n)&&e.push(n)})),e},file:function(t,e,r){if(1!==arguments.length)return t=this.root+t,n.call(this,t,e,r),this;if(g(t)){var i=t;return this.filter((function(t,e){return!e.dir&&i.test(t)}))}var a=this.files[this.root+t];return a&&!a.dir?a:null},folder:function(t){if(!t)return this;if(g(t))return this.filter((function(e,r){return r.dir&&t.test(e)}));var e=this.root+t,r=_.call(this,e),n=this.clone();return n.root=r.name,n},remove:function(t){t=this.root+t;var e=this.files[t];if(e||("/"!==t.slice(-1)&&(t+="/"),e=this.files[t]),e&&!e.dir)delete this.files[t];else for(var r=this.filter((function(e,r){return r.name.slice(0,t.length)===t})),n=0;n<r.length;n++)delete this.files[r[n].name];return this},generate:function(){throw new Error("This method has been removed in JSZip 3.0, please check the upgrade guide.")},generateInternalStream:function(t){var e,r={};try{if((r=a.extend(t||{},{streamFiles:!1,compression:"STORE",compressionOptions:null,type:"",platform:"DOS",comment:null,mimeType:"application/zip",encodeFileName:i.utf8encode})).type=r.type.toLowerCase(),r.compression=r.compression.toUpperCase(),"binarystring"===r.type&&(r.type="string"),!r.type)throw new Error("No output type specified.");a.checkSupport(r.type),"darwin"!==r.platform&&"freebsd"!==r.platform&&"linux"!==r.platform&&"sunos"!==r.platform||(r.platform="UNIX"),"win32"===r.platform&&(r.platform="DOS");var n=r.comment||this.comment||"";e=l.generateWorker(this,r,n)}catch(t){(e=new s("error")).error(t)}return new o(e,r.type||"string",r.mimeType)},generateAsync:function(t,e){return this.generateInternalStream(t).accumulate(e)},generateNodeStream:function(t,e){return(t=t||{}).type||(t.type="nodebuffer"),this.generateInternalStream(t).toNodejsStream(e)}};e.exports=v},{"./compressedObject":2,"./defaults":5,"./generate":9,"./nodejs/NodejsStreamInputAdapter":12,"./nodejsUtils":14,"./stream/GenericWorker":28,"./stream/StreamHelper":29,"./utf8":31,"./utils":32,"./zipObject":35}],16:[function(t,e,r){"use strict";e.exports=t("stream")},{stream:void 0}],17:[function(t,e,r){"use strict";var n=t("./DataReader");function i(t){n.call(this,t);for(var e=0;e<this.data.length;e++)t[e]=255&t[e]}t("../utils").inherits(i,n),i.prototype.byteAt=function(t){return this.data[this.zero+t]},i.prototype.lastIndexOfSignature=function(t){for(var e=t.charCodeAt(0),r=t.charCodeAt(1),n=t.charCodeAt(2),i=t.charCodeAt(3),a=this.length-4;0<=a;--a)if(this.data[a]===e&&this.data[a+1]===r&&this.data[a+2]===n&&this.data[a+3]===i)return a-this.zero;return-1},i.prototype.readAndCheckSignature=function(t){var e=t.charCodeAt(0),r=t.charCodeAt(1),n=t.charCodeAt(2),i=t.charCodeAt(3),a=this.readData(4);return e===a[0]&&r===a[1]&&n===a[2]&&i===a[3]},i.prototype.readData=function(t){if(this.checkOffset(t),0===t)return[];var e=this.data.slice(this.zero+this.index,this.zero+this.index+t);return this.index+=t,e},e.exports=i},{"../utils":32,"./DataReader":18}],18:[function(t,e,r){"use strict";var n=t("../utils");function i(t){this.data=t,this.length=t.length,this.index=0,this.zero=0}i.prototype={checkOffset:function(t){this.checkIndex(this.index+t)},checkIndex:function(t){if(this.length<this.zero+t||t<0)throw new Error("End of data reached (data length = "+this.length+", asked index = "+t+"). Corrupted zip ?")},setIndex:function(t){this.checkIndex(t),this.index=t},skip:function(t){this.setIndex(this.index+t)},byteAt:function(){},readInt:function(t){var e,r=0;for(this.checkOffset(t),e=this.index+t-1;e>=this.index;e--)r=(r<<8)+this.byteAt(e);return this.index+=t,r},readString:function(t){return n.transformTo("string",this.readData(t))},readData:function(){},lastIndexOfSignature:function(){},readAndCheckSignature:function(){},readDate:function(){var t=this.readInt(4);return new Date(Date.UTC(1980+(t>>25&127),(t>>21&15)-1,t>>16&31,t>>11&31,t>>5&63,(31&t)<<1))}},e.exports=i},{"../utils":32}],19:[function(t,e,r){"use strict";var n=t("./Uint8ArrayReader");function i(t){n.call(this,t)}t("../utils").inherits(i,n),i.prototype.readData=function(t){this.checkOffset(t);var e=this.data.slice(this.zero+this.index,this.zero+this.index+t);return this.index+=t,e},e.exports=i},{"../utils":32,"./Uint8ArrayReader":21}],20:[function(t,e,r){"use strict";var n=t("./DataReader");function i(t){n.call(this,t)}t("../utils").inherits(i,n),i.prototype.byteAt=function(t){return this.data.charCodeAt(this.zero+t)},i.prototype.lastIndexOfSignature=function(t){return this.data.lastIndexOf(t)-this.zero},i.prototype.readAndCheckSignature=function(t){return t===this.readData(4)},i.prototype.readData=function(t){this.checkOffset(t);var e=this.data.slice(this.zero+this.index,this.zero+this.index+t);return this.index+=t,e},e.exports=i},{"../utils":32,"./DataReader":18}],21:[function(t,e,r){"use strict";var n=t("./ArrayReader");function i(t){n.call(this,t)}t("../utils").inherits(i,n),i.prototype.readData=function(t){if(this.checkOffset(t),0===t)return new Uint8Array(0);var e=this.data.subarray(this.zero+this.index,this.zero+this.index+t);return this.index+=t,e},e.exports=i},{"../utils":32,"./ArrayReader":17}],22:[function(t,e,r){"use strict";var n=t("../utils"),i=t("../support"),a=t("./ArrayReader"),s=t("./StringReader"),o=t("./NodeBufferReader"),u=t("./Uint8ArrayReader");e.exports=function(t){var e=n.getTypeOf(t);return n.checkSupport(e),"string"!==e||i.uint8array?"nodebuffer"===e?new o(t):i.uint8array?new u(n.transformTo("uint8array",t)):new a(n.transformTo("array",t)):new s(t)}},{"../support":30,"../utils":32,"./ArrayReader":17,"./NodeBufferReader":19,"./StringReader":20,"./Uint8ArrayReader":21}],23:[function(t,e,r){"use strict";r.LOCAL_FILE_HEADER="PK",r.CENTRAL_FILE_HEADER="PK",r.CENTRAL_DIRECTORY_END="PK",r.ZIP64_CENTRAL_DIRECTORY_LOCATOR="PK",r.ZIP64_CENTRAL_DIRECTORY_END="PK",r.DATA_DESCRIPTOR="PK\b"},{}],24:[function(t,e,r){"use strict";var n=t("./GenericWorker"),i=t("../utils");function a(t){n.call(this,"ConvertWorker to "+t),this.destType=t}i.inherits(a,n),a.prototype.processChunk=function(t){this.push({data:i.transformTo(this.destType,t.data),meta:t.meta})},e.exports=a},{"../utils":32,"./GenericWorker":28}],25:[function(t,e,r){"use strict";var n=t("./GenericWorker"),i=t("../crc32");function a(){n.call(this,"Crc32Probe"),this.withStreamInfo("crc32",0)}t("../utils").inherits(a,n),a.prototype.processChunk=function(t){this.streamInfo.crc32=i(t.data,this.streamInfo.crc32||0),this.push(t)},e.exports=a},{"../crc32":4,"../utils":32,"./GenericWorker":28}],26:[function(t,e,r){"use strict";var n=t("../utils"),i=t("./GenericWorker");function a(t){i.call(this,"DataLengthProbe for "+t),this.propName=t,this.withStreamInfo(t,0)}n.inherits(a,i),a.prototype.processChunk=function(t){if(t){var e=this.streamInfo[this.propName]||0;this.streamInfo[this.propName]=e+t.data.length}i.prototype.processChunk.call(this,t)},e.exports=a},{"../utils":32,"./GenericWorker":28}],27:[function(t,e,r){"use strict";var n=t("../utils"),i=t("./GenericWorker");function a(t){i.call(this,"DataWorker");var e=this;this.dataIsReady=!1,this.index=0,this.max=0,this.data=null,this.type="",this._tickScheduled=!1,t.then((function(t){e.dataIsReady=!0,e.data=t,e.max=t&&t.length||0,e.type=n.getTypeOf(t),e.isPaused||e._tickAndRepeat()}),(function(t){e.error(t)}))}n.inherits(a,i),a.prototype.cleanUp=function(){i.prototype.cleanUp.call(this),this.data=null},a.prototype.resume=function(){return!!i.prototype.resume.call(this)&&(!this._tickScheduled&&this.dataIsReady&&(this._tickScheduled=!0,n.delay(this._tickAndRepeat,[],this)),!0)},a.prototype._tickAndRepeat=function(){this._tickScheduled=!1,this.isPaused||this.isFinished||(this._tick(),this.isFinished||(n.delay(this._tickAndRepeat,[],this),this._tickScheduled=!0))},a.prototype._tick=function(){if(this.isPaused||this.isFinished)return!1;var t=null,e=Math.min(this.max,this.index+16384);if(this.index>=this.max)return this.end();switch(this.type){case"string":t=this.data.substring(this.index,e);break;case"uint8array":t=this.data.subarray(this.index,e);break;case"array":case"nodebuffer":t=this.data.slice(this.index,e)}return this.index=e,this.push({data:t,meta:{percent:this.max?this.index/this.max*100:0}})},e.exports=a},{"../utils":32,"./GenericWorker":28}],28:[function(t,e,r){"use strict";function n(t){this.name=t||"default",this.streamInfo={},this.generatedError=null,this.extraStreamInfo={},this.isPaused=!0,this.isFinished=!1,this.isLocked=!1,this._listeners={data:[],end:[],error:[]},this.previous=null}n.prototype={push:function(t){this.emit("data",t)},end:function(){if(this.isFinished)return!1;this.flush();try{this.emit("end"),this.cleanUp(),this.isFinished=!0}catch(t){this.emit("error",t)}return!0},error:function(t){return!this.isFinished&&(this.isPaused?this.generatedError=t:(this.isFinished=!0,this.emit("error",t),this.previous&&this.previous.error(t),this.cleanUp()),!0)},on:function(t,e){return this._listeners[t].push(e),this},cleanUp:function(){this.streamInfo=this.generatedError=this.extraStreamInfo=null,this._listeners=[]},emit:function(t,e){if(this._listeners[t])for(var r=0;r<this._listeners[t].length;r++)this._listeners[t][r].call(this,e)},pipe:function(t){return t.registerPrevious(this)},registerPrevious:function(t){if(this.isLocked)throw new Error("The stream '"+this+"' has already been used.");this.streamInfo=t.streamInfo,this.mergeStreamInfo(),this.previous=t;var e=this;return t.on("data",(function(t){e.processChunk(t)})),t.on("end",(function(){e.end()})),t.on("error",(function(t){e.error(t)})),this},pause:function(){return!this.isPaused&&!this.isFinished&&(this.isPaused=!0,this.previous&&this.previous.pause(),!0)},resume:function(){if(!this.isPaused||this.isFinished)return!1;var t=this.isPaused=!1;return this.generatedError&&(this.error(this.generatedError),t=!0),this.previous&&this.previous.resume(),!t},flush:function(){},processChunk:function(t){this.push(t)},withStreamInfo:function(t,e){return this.extraStreamInfo[t]=e,this.mergeStreamInfo(),this},mergeStreamInfo:function(){for(var t in this.extraStreamInfo)Object.prototype.hasOwnProperty.call(this.extraStreamInfo,t)&&(this.streamInfo[t]=this.extraStreamInfo[t])},lock:function(){if(this.isLocked)throw new Error("The stream '"+this+"' has already been used.");this.isLocked=!0,this.previous&&this.previous.lock()},toString:function(){var t="Worker "+this.name;return this.previous?this.previous+" -> "+t:t}},e.exports=n},{}],29:[function(t,e,r){"use strict";var n=t("../utils"),i=t("./ConvertWorker"),a=t("./GenericWorker"),s=t("../base64"),o=t("../support"),u=t("../external"),h=null;if(o.nodestream)try{h=t("../nodejs/NodejsStreamOutputAdapter")}catch(t){}function c(t,e,r){var s=e;switch(e){case"blob":case"arraybuffer":s="uint8array";break;case"base64":s="string"}try{this._internalType=s,this._outputType=e,this._mimeType=r,n.checkSupport(s),this._worker=t.pipe(new i(s)),t.lock()}catch(t){this._worker=new a("error"),this._worker.error(t)}}c.prototype={accumulate:function(t){return function(t,e){return new u.Promise((function(r,i){var a=[],o=t._internalType,u=t._outputType,h=t._mimeType;t.on("data",(function(t,r){a.push(t),e&&e(r)})).on("error",(function(t){a=[],i(t)})).on("end",(function(){try{var t=function(t,e,r){switch(t){case"blob":return n.newBlob(n.transformTo("arraybuffer",e),r);case"base64":return s.encode(e);default:return n.transformTo(t,e)}}(u,function(t,e){var r,n=0,i=null,a=0;for(r=0;r<e.length;r++)a+=e[r].length;switch(t){case"string":return e.join("");case"array":return Array.prototype.concat.apply([],e);case"uint8array":for(i=new Uint8Array(a),r=0;r<e.length;r++)i.set(e[r],n),n+=e[r].length;return i;case"nodebuffer":return Buffer.concat(e);default:throw new Error("concat : unsupported type '"+t+"'")}}(o,a),h);r(t)}catch(t){i(t)}a=[]})).resume()}))}(this,t)},on:function(t,e){var r=this;return"data"===t?this._worker.on(t,(function(t){e.call(r,t.data,t.meta)})):this._worker.on(t,(function(){n.delay(e,arguments,r)})),this},resume:function(){return n.delay(this._worker.resume,[],this._worker),this},pause:function(){return this._worker.pause(),this},toNodejsStream:function(t){if(n.checkSupport("nodestream"),"nodebuffer"!==this._outputType)throw new Error(this._outputType+" is not supported by this method");return new h(this,{objectMode:"nodebuffer"!==this._outputType},t)}},e.exports=c},{"../base64":1,"../external":6,"../nodejs/NodejsStreamOutputAdapter":13,"../support":30,"../utils":32,"./ConvertWorker":24,"./GenericWorker":28}],30:[function(t,e,r){"use strict";if(r.base64=!0,r.array=!0,r.string=!0,r.arraybuffer="undefined"!=typeof ArrayBuffer&&"undefined"!=typeof Uint8Array,r.nodebuffer="undefined"!=typeof Buffer,r.uint8array="undefined"!=typeof Uint8Array,"undefined"==typeof ArrayBuffer)r.blob=!1;else{var n=new ArrayBuffer(0);try{r.blob=0===new Blob([n],{type:"application/zip"}).size}catch(t){try{var i=new(self.BlobBuilder||self.WebKitBlobBuilder||self.MozBlobBuilder||self.MSBlobBuilder);i.append(n),r.blob=0===i.getBlob("application/zip").size}catch(t){r.blob=!1}}}try{r.nodestream=!!t("readable-stream").Readable}catch(t){r.nodestream=!1}},{"readable-stream":16}],31:[function(t,e,r){"use strict";for(var n=t("./utils"),i=t("./support"),a=t("./nodejsUtils"),s=t("./stream/GenericWorker"),o=new Array(256),u=0;u<256;u++)o[u]=252<=u?6:248<=u?5:240<=u?4:224<=u?3:192<=u?2:1;function h(){s.call(this,"utf-8 decode"),this.leftOver=null}function c(){s.call(this,"utf-8 encode")}o[254]=o[254]=1,r.utf8encode=function(t){return i.nodebuffer?a.newBufferFrom(t,"utf-8"):function(t){var e,r,n,a,s,o=t.length,u=0;for(a=0;a<o;a++)55296==(64512&(r=t.charCodeAt(a)))&&a+1<o&&56320==(64512&(n=t.charCodeAt(a+1)))&&(r=65536+(r-55296<<10)+(n-56320),a++),u+=r<128?1:r<2048?2:r<65536?3:4;for(e=i.uint8array?new Uint8Array(u):new Array(u),a=s=0;s<u;a++)55296==(64512&(r=t.charCodeAt(a)))&&a+1<o&&56320==(64512&(n=t.charCodeAt(a+1)))&&(r=65536+(r-55296<<10)+(n-56320),a++),r<128?e[s++]=r:(r<2048?e[s++]=192|r>>>6:(r<65536?e[s++]=224|r>>>12:(e[s++]=240|r>>>18,e[s++]=128|r>>>12&63),e[s++]=128|r>>>6&63),e[s++]=128|63&r);return e}(t)},r.utf8decode=function(t){return i.nodebuffer?n.transformTo("nodebuffer",t).toString("utf-8"):function(t){var e,r,i,a,s=t.length,u=new Array(2*s);for(e=r=0;e<s;)if((i=t[e++])<128)u[r++]=i;else if(4<(a=o[i]))u[r++]=65533,e+=a-1;else{for(i&=2===a?31:3===a?15:7;1<a&&e<s;)i=i<<6|63&t[e++],a--;1<a?u[r++]=65533:i<65536?u[r++]=i:(i-=65536,u[r++]=55296|i>>10&1023,u[r++]=56320|1023&i)}return u.length!==r&&(u.subarray?u=u.subarray(0,r):u.length=r),n.applyFromCharCode(u)}(t=n.transformTo(i.uint8array?"uint8array":"array",t))},n.inherits(h,s),h.prototype.processChunk=function(t){var e=n.transformTo(i.uint8array?"uint8array":"array",t.data);if(this.leftOver&&this.leftOver.length){if(i.uint8array){var a=e;(e=new Uint8Array(a.length+this.leftOver.length)).set(this.leftOver,0),e.set(a,this.leftOver.length)}else e=this.leftOver.concat(e);this.leftOver=null}var s=function(t,e){var r;for((e=e||t.length)>t.length&&(e=t.length),r=e-1;0<=r&&128==(192&t[r]);)r--;return r<0||0===r?e:r+o[t[r]]>e?r:e}(e),u=e;s!==e.length&&(i.uint8array?(u=e.subarray(0,s),this.leftOver=e.subarray(s,e.length)):(u=e.slice(0,s),this.leftOver=e.slice(s,e.length))),this.push({data:r.utf8decode(u),meta:t.meta})},h.prototype.flush=function(){this.leftOver&&this.leftOver.length&&(this.push({data:r.utf8decode(this.leftOver),meta:{}}),this.leftOver=null)},r.Utf8DecodeWorker=h,n.inherits(c,s),c.prototype.processChunk=function(t){this.push({data:r.utf8encode(t.data),meta:t.meta})},r.Utf8EncodeWorker=c},{"./nodejsUtils":14,"./stream/GenericWorker":28,"./support":30,"./utils":32}],32:[function(t,e,r){"use strict";var n=t("./support"),i=t("./base64"),a=t("./nodejsUtils"),s=t("./external");function o(t){return t}function u(t,e){for(var r=0;r<t.length;++r)e[r]=255&t.charCodeAt(r);return e}t("setimmediate"),r.newBlob=function(t,e){r.checkSupport("blob");try{return new Blob([t],{type:e})}catch(r){try{var n=new(self.BlobBuilder||self.WebKitBlobBuilder||self.MozBlobBuilder||self.MSBlobBuilder);return n.append(t),n.getBlob(e)}catch(t){throw new Error("Bug : can't construct the Blob.")}}};var h={stringifyByChunk:function(t,e,r){var n=[],i=0,a=t.length;if(a<=r)return String.fromCharCode.apply(null,t);for(;i<a;)"array"===e||"nodebuffer"===e?n.push(String.fromCharCode.apply(null,t.slice(i,Math.min(i+r,a)))):n.push(String.fromCharCode.apply(null,t.subarray(i,Math.min(i+r,a)))),i+=r;return n.join("")},stringifyByChar:function(t){for(var e="",r=0;r<t.length;r++)e+=String.fromCharCode(t[r]);return e},applyCanBeUsed:{uint8array:function(){try{return n.uint8array&&1===String.fromCharCode.apply(null,new Uint8Array(1)).length}catch(t){return!1}}(),nodebuffer:function(){try{return n.nodebuffer&&1===String.fromCharCode.apply(null,a.allocBuffer(1)).length}catch(t){return!1}}()}};function c(t){var e=65536,n=r.getTypeOf(t),i=!0;if("uint8array"===n?i=h.applyCanBeUsed.uint8array:"nodebuffer"===n&&(i=h.applyCanBeUsed.nodebuffer),i)for(;1<e;)try{return h.stringifyByChunk(t,n,e)}catch(t){e=Math.floor(e/2)}return h.stringifyByChar(t)}function l(t,e){for(var r=0;r<t.length;r++)e[r]=t[r];return e}r.applyFromCharCode=c;var f={};f.string={string:o,array:function(t){return u(t,new Array(t.length))},arraybuffer:function(t){return f.string.uint8array(t).buffer},uint8array:function(t){return u(t,new Uint8Array(t.length))},nodebuffer:function(t){return u(t,a.allocBuffer(t.length))}},f.array={string:c,array:o,arraybuffer:function(t){return new Uint8Array(t).buffer},uint8array:function(t){return new Uint8Array(t)},nodebuffer:function(t){return a.newBufferFrom(t)}},f.arraybuffer={string:function(t){return c(new Uint8Array(t))},array:function(t){return l(new Uint8Array(t),new Array(t.byteLength))},arraybuffer:o,uint8array:function(t){return new Uint8Array(t)},nodebuffer:function(t){return a.newBufferFrom(new Uint8Array(t))}},f.uint8array={string:c,array:function(t){return l(t,new Array(t.length))},arraybuffer:function(t){return t.buffer},uint8array:o,nodebuffer:function(t){return a.newBufferFrom(t)}},f.nodebuffer={string:c,array:function(t){return l(t,new Array(t.length))},arraybuffer:function(t){return f.nodebuffer.uint8array(t).buffer},uint8array:function(t){return l(t,new Uint8Array(t.length))},nodebuffer:o},r.transformTo=function(t,e){if(e=e||"",!t)return e;r.checkSupport(t);var n=r.getTypeOf(e);return f[n][t](e)},r.resolve=function(t){for(var e=t.split("/"),r=[],n=0;n<e.length;n++){var i=e[n];"."===i||""===i&&0!==n&&n!==e.length-1||(".."===i?r.pop():r.push(i))}return r.join("/")},r.getTypeOf=function(t){return"string"==typeof t?"string":"[object Array]"===Object.prototype.toString.call(t)?"array":n.nodebuffer&&a.isBuffer(t)?"nodebuffer":n.uint8array&&t instanceof Uint8Array?"uint8array":n.arraybuffer&&t instanceof ArrayBuffer?"arraybuffer":void 0},r.checkSupport=function(t){if(!n[t.toLowerCase()])throw new Error(t+" is not supported by this platform")},r.MAX_VALUE_16BITS=65535,r.MAX_VALUE_32BITS=-1,r.pretty=function(t){var e,r,n="";for(r=0;r<(t||"").length;r++)n+="\\x"+((e=t.charCodeAt(r))<16?"0":"")+e.toString(16).toUpperCase();return n},r.delay=function(t,e,r){setImmediate((function(){t.apply(r||null,e||[])}))},r.inherits=function(t,e){function r(){}r.prototype=e.prototype,t.prototype=new r},r.extend=function(){var t,e,r={};for(t=0;t<arguments.length;t++)for(e in arguments[t])Object.prototype.hasOwnProperty.call(arguments[t],e)&&void 0===r[e]&&(r[e]=arguments[t][e]);return r},r.prepareContent=function(t,e,a,o,h){return s.Promise.resolve(e).then((function(t){return n.blob&&(t instanceof Blob||-1!==["[object File]","[object Blob]"].indexOf(Object.prototype.toString.call(t)))&&"undefined"!=typeof FileReader?new s.Promise((function(e,r){var n=new FileReader;n.onload=function(t){e(t.target.result)},n.onerror=function(t){r(t.target.error)},n.readAsArrayBuffer(t)})):t})).then((function(e){var c=r.getTypeOf(e);return c?("arraybuffer"===c?e=r.transformTo("uint8array",e):"string"===c&&(h?e=i.decode(e):a&&!0!==o&&(e=function(t){return u(t,n.uint8array?new Uint8Array(t.length):new Array(t.length))}(e))),e):s.Promise.reject(new Error("Can't read the data of '"+t+"'. Is it in a supported JavaScript type (String, Blob, ArrayBuffer, etc) ?"))}))}},{"./base64":1,"./external":6,"./nodejsUtils":14,"./support":30,setimmediate:54}],33:[function(t,e,r){"use strict";var n=t("./reader/readerFor"),i=t("./utils"),a=t("./signature"),s=t("./zipEntry"),o=t("./support");function u(t){this.files=[],this.loadOptions=t}u.prototype={checkSignature:function(t){if(!this.reader.readAndCheckSignature(t)){this.reader.index-=4;var e=this.reader.readString(4);throw new Error("Corrupted zip or bug: unexpected signature ("+i.pretty(e)+", expected "+i.pretty(t)+")")}},isSignature:function(t,e){var r=this.reader.index;this.reader.setIndex(t);var n=this.reader.readString(4)===e;return this.reader.setIndex(r),n},readBlockEndOfCentral:function(){this.diskNumber=this.reader.readInt(2),this.diskWithCentralDirStart=this.reader.readInt(2),this.centralDirRecordsOnThisDisk=this.reader.readInt(2),this.centralDirRecords=this.reader.readInt(2),this.centralDirSize=this.reader.readInt(4),this.centralDirOffset=this.reader.readInt(4),this.zipCommentLength=this.reader.readInt(2);var t=this.reader.readData(this.zipCommentLength),e=o.uint8array?"uint8array":"array",r=i.transformTo(e,t);this.zipComment=this.loadOptions.decodeFileName(r)},readBlockZip64EndOfCentral:function(){this.zip64EndOfCentralSize=this.reader.readInt(8),this.reader.skip(4),this.diskNumber=this.reader.readInt(4),this.diskWithCentralDirStart=this.reader.readInt(4),this.centralDirRecordsOnThisDisk=this.reader.readInt(8),this.centralDirRecords=this.reader.readInt(8),this.centralDirSize=this.reader.readInt(8),this.centralDirOffset=this.reader.readInt(8),this.zip64ExtensibleData={};for(var t,e,r,n=this.zip64EndOfCentralSize-44;0<n;)t=this.reader.readInt(2),e=this.reader.readInt(4),r=this.reader.readData(e),this.zip64ExtensibleData[t]={id:t,length:e,value:r}},readBlockZip64EndOfCentralLocator:function(){if(this.diskWithZip64CentralDirStart=this.reader.readInt(4),this.relativeOffsetEndOfZip64CentralDir=this.reader.readInt(8),this.disksCount=this.reader.readInt(4),1<this.disksCount)throw new Error("Multi-volumes zip are not supported")},readLocalFiles:function(){var t,e;for(t=0;t<this.files.length;t++)e=this.files[t],this.reader.setIndex(e.localHeaderOffset),this.checkSignature(a.LOCAL_FILE_HEADER),e.readLocalPart(this.reader),e.handleUTF8(),e.processAttributes()},readCentralDir:function(){var t;for(this.reader.setIndex(this.centralDirOffset);this.reader.readAndCheckSignature(a.CENTRAL_FILE_HEADER);)(t=new s({zip64:this.zip64},this.loadOptions)).readCentralPart(this.reader),this.files.push(t);if(this.centralDirRecords!==this.files.length&&0!==this.centralDirRecords&&0===this.files.length)throw new Error("Corrupted zip or bug: expected "+this.centralDirRecords+" records in central dir, got "+this.files.length)},readEndOfCentral:function(){var t=this.reader.lastIndexOfSignature(a.CENTRAL_DIRECTORY_END);if(t<0)throw this.isSignature(0,a.LOCAL_FILE_HEADER)?new Error("Corrupted zip: can't find end of central directory"):new Error("Can't find end of central directory : is this a zip file ? If it is, see https://stuk.github.io/jszip/documentation/howto/read_zip.html");this.reader.setIndex(t);var e=t;if(this.checkSignature(a.CENTRAL_DIRECTORY_END),this.readBlockEndOfCentral(),this.diskNumber===i.MAX_VALUE_16BITS||this.diskWithCentralDirStart===i.MAX_VALUE_16BITS||this.centralDirRecordsOnThisDisk===i.MAX_VALUE_16BITS||this.centralDirRecords===i.MAX_VALUE_16BITS||this.centralDirSize===i.MAX_VALUE_32BITS||this.centralDirOffset===i.MAX_VALUE_32BITS){if(this.zip64=!0,(t=this.reader.lastIndexOfSignature(a.ZIP64_CENTRAL_DIRECTORY_LOCATOR))<0)throw new Error("Corrupted zip: can't find the ZIP64 end of central directory locator");if(this.reader.setIndex(t),this.checkSignature(a.ZIP64_CENTRAL_DIRECTORY_LOCATOR),this.readBlockZip64EndOfCentralLocator(),!this.isSignature(this.relativeOffsetEndOfZip64CentralDir,a.ZIP64_CENTRAL_DIRECTORY_END)&&(this.relativeOffsetEndOfZip64CentralDir=this.reader.lastIndexOfSignature(a.ZIP64_CENTRAL_DIRECTORY_END),this.relativeOffsetEndOfZip64CentralDir<0))throw new Error("Corrupted zip: can't find the ZIP64 end of central directory");this.reader.setIndex(this.relativeOffsetEndOfZip64CentralDir),this.checkSignature(a.ZIP64_CENTRAL_DIRECTORY_END),this.readBlockZip64EndOfCentral()}var r=this.centralDirOffset+this.centralDirSize;this.zip64&&(r+=20,r+=12+this.zip64EndOfCentralSize);var n=e-r;if(0<n)this.isSignature(e,a.CENTRAL_FILE_HEADER)||(this.reader.zero=n);else if(n<0)throw new Error("Corrupted zip: missing "+Math.abs(n)+" bytes.")},prepareReader:function(t){this.reader=n(t)},load:function(t){this.prepareReader(t),this.readEndOfCentral(),this.readCentralDir(),this.readLocalFiles()}},e.exports=u},{"./reader/readerFor":22,"./signature":23,"./support":30,"./utils":32,"./zipEntry":34}],34:[function(t,e,r){"use strict";var n=t("./reader/readerFor"),i=t("./utils"),a=t("./compressedObject"),s=t("./crc32"),o=t("./utf8"),u=t("./compressions"),h=t("./support");function c(t,e){this.options=t,this.loadOptions=e}c.prototype={isEncrypted:function(){return!(1&~this.bitFlag)},useUTF8:function(){return!(2048&~this.bitFlag)},readLocalPart:function(t){var e,r;if(t.skip(22),this.fileNameLength=t.readInt(2),r=t.readInt(2),this.fileName=t.readData(this.fileNameLength),t.skip(r),-1===this.compressedSize||-1===this.uncompressedSize)throw new Error("Bug or corrupted zip : didn't get enough information from the central directory (compressedSize === -1 || uncompressedSize === -1)");if(null===(e=function(t){for(var e in u)if(Object.prototype.hasOwnProperty.call(u,e)&&u[e].magic===t)return u[e];return null}(this.compressionMethod)))throw new Error("Corrupted zip : compression "+i.pretty(this.compressionMethod)+" unknown (inner file : "+i.transformTo("string",this.fileName)+")");this.decompressed=new a(this.compressedSize,this.uncompressedSize,this.crc32,e,t.readData(this.compressedSize))},readCentralPart:function(t){this.versionMadeBy=t.readInt(2),t.skip(2),this.bitFlag=t.readInt(2),this.compressionMethod=t.readString(2),this.date=t.readDate(),this.crc32=t.readInt(4),this.compressedSize=t.readInt(4),this.uncompressedSize=t.readInt(4);var e=t.readInt(2);if(this.extraFieldsLength=t.readInt(2),this.fileCommentLength=t.readInt(2),this.diskNumberStart=t.readInt(2),this.internalFileAttributes=t.readInt(2),this.externalFileAttributes=t.readInt(4),this.localHeaderOffset=t.readInt(4),this.isEncrypted())throw new Error("Encrypted zip are not supported");t.skip(e),this.readExtraFields(t),this.parseZIP64ExtraField(t),this.fileComment=t.readData(this.fileCommentLength)},processAttributes:function(){this.unixPermissions=null,this.dosPermissions=null;var t=this.versionMadeBy>>8;this.dir=!!(16&this.externalFileAttributes),0==t&&(this.dosPermissions=63&this.externalFileAttributes),3==t&&(this.unixPermissions=this.externalFileAttributes>>16&65535),this.dir||"/"!==this.fileNameStr.slice(-1)||(this.dir=!0)},parseZIP64ExtraField:function(){if(this.extraFields[1]){var t=n(this.extraFields[1].value);this.uncompressedSize===i.MAX_VALUE_32BITS&&(this.uncompressedSize=t.readInt(8)),this.compressedSize===i.MAX_VALUE_32BITS&&(this.compressedSize=t.readInt(8)),this.localHeaderOffset===i.MAX_VALUE_32BITS&&(this.localHeaderOffset=t.readInt(8)),this.diskNumberStart===i.MAX_VALUE_32BITS&&(this.diskNumberStart=t.readInt(4))}},readExtraFields:function(t){var e,r,n,i=t.index+this.extraFieldsLength;for(this.extraFields||(this.extraFields={});t.index+4<i;)e=t.readInt(2),r=t.readInt(2),n=t.readData(r),this.extraFields[e]={id:e,length:r,value:n};t.setIndex(i)},handleUTF8:function(){var t=h.uint8array?"uint8array":"array";if(this.useUTF8())this.fileNameStr=o.utf8decode(this.fileName),this.fileCommentStr=o.utf8decode(this.fileComment);else{var e=this.findExtraFieldUnicodePath();if(null!==e)this.fileNameStr=e;else{var r=i.transformTo(t,this.fileName);this.fileNameStr=this.loadOptions.decodeFileName(r)}var n=this.findExtraFieldUnicodeComment();if(null!==n)this.fileCommentStr=n;else{var a=i.transformTo(t,this.fileComment);this.fileCommentStr=this.loadOptions.decodeFileName(a)}}},findExtraFieldUnicodePath:function(){var t=this.extraFields[28789];if(t){var e=n(t.value);return 1!==e.readInt(1)||s(this.fileName)!==e.readInt(4)?null:o.utf8decode(e.readData(t.length-5))}return null},findExtraFieldUnicodeComment:function(){var t=this.extraFields[25461];if(t){var e=n(t.value);return 1!==e.readInt(1)||s(this.fileComment)!==e.readInt(4)?null:o.utf8decode(e.readData(t.length-5))}return null}},e.exports=c},{"./compressedObject":2,"./compressions":3,"./crc32":4,"./reader/readerFor":22,"./support":30,"./utf8":31,"./utils":32}],35:[function(t,e,r){"use strict";function n(t,e,r){this.name=t,this.dir=r.dir,this.date=r.date,this.comment=r.comment,this.unixPermissions=r.unixPermissions,this.dosPermissions=r.dosPermissions,this._data=e,this._dataBinary=r.binary,this.options={compression:r.compression,compressionOptions:r.compressionOptions}}var i=t("./stream/StreamHelper"),a=t("./stream/DataWorker"),s=t("./utf8"),o=t("./compressedObject"),u=t("./stream/GenericWorker");n.prototype={internalStream:function(t){var e=null,r="string";try{if(!t)throw new Error("No output type specified.");var n="string"===(r=t.toLowerCase())||"text"===r;"binarystring"!==r&&"text"!==r||(r="string"),e=this._decompressWorker();var a=!this._dataBinary;a&&!n&&(e=e.pipe(new s.Utf8EncodeWorker)),!a&&n&&(e=e.pipe(new s.Utf8DecodeWorker))}catch(t){(e=new u("error")).error(t)}return new i(e,r,"")},async:function(t,e){return this.internalStream(t).accumulate(e)},nodeStream:function(t,e){return this.internalStream(t||"nodebuffer").toNodejsStream(e)},_compressWorker:function(t,e){if(this._data instanceof o&&this._data.compression.magic===t.magic)return this._data.getCompressedWorker();var r=this._decompressWorker();return this._dataBinary||(r=r.pipe(new s.Utf8EncodeWorker)),o.createWorkerFrom(r,t,e)},_decompressWorker:function(){return this._data instanceof o?this._data.getContentWorker():this._data instanceof u?this._data:new a(this._data)}};for(var h=["asText","asBinary","asNodeBuffer","asUint8Array","asArrayBuffer"],c=function(){throw new Error("This method has been removed in JSZip 3.0, please check the upgrade guide.")},l=0;l<h.length;l++)n.prototype[h[l]]=c;e.exports=n},{"./compressedObject":2,"./stream/DataWorker":27,"./stream/GenericWorker":28,"./stream/StreamHelper":29,"./utf8":31}],36:[function(t,e,n){(function(t){"use strict";var r,n,i=t.MutationObserver||t.WebKitMutationObserver;if(i){var a=0,s=new i(c),o=t.document.createTextNode("");s.observe(o,{characterData:!0}),r=function(){o.data=a=++a%2}}else if(t.setImmediate||void 0===t.MessageChannel)r="document"in t&&"onreadystatechange"in t.document.createElement("script")?function(){var e=t.document.createElement("script");e.onreadystatechange=function(){c(),e.onreadystatechange=null,e.parentNode.removeChild(e),e=null},t.document.documentElement.appendChild(e)}:function(){setTimeout(c,0)};else{var u=new t.MessageChannel;u.port1.onmessage=c,r=function(){u.port2.postMessage(0)}}var h=[];function c(){var t,e;n=!0;for(var r=h.length;r;){for(e=h,h=[],t=-1;++t<r;)e[t]();r=h.length}n=!1}e.exports=function(t){1!==h.push(t)||n||r()}}).call(this,void 0!==r.g?r.g:"undefined"!=typeof self?self:"undefined"!=typeof window?window:{})},{}],37:[function(t,e,r){"use strict";var n=t("immediate");function i(){}var a={},s=["REJECTED"],o=["FULFILLED"],u=["PENDING"];function h(t){if("function"!=typeof t)throw new TypeError("resolver must be a function");this.state=u,this.queue=[],this.outcome=void 0,t!==i&&d(this,t)}function c(t,e,r){this.promise=t,"function"==typeof e&&(this.onFulfilled=e,this.callFulfilled=this.otherCallFulfilled),"function"==typeof r&&(this.onRejected=r,this.callRejected=this.otherCallRejected)}function l(t,e,r){n((function(){var n;try{n=e(r)}catch(n){return a.reject(t,n)}n===t?a.reject(t,new TypeError("Cannot resolve promise with itself")):a.resolve(t,n)}))}function f(t){var e=t&&t.then;if(t&&("object"==typeof t||"function"==typeof t)&&"function"==typeof e)return function(){e.apply(t,arguments)}}function d(t,e){var r=!1;function n(e){r||(r=!0,a.reject(t,e))}function i(e){r||(r=!0,a.resolve(t,e))}var s=p((function(){e(i,n)}));"error"===s.status&&n(s.value)}function p(t,e){var r={};try{r.value=t(e),r.status="success"}catch(t){r.status="error",r.value=t}return r}(e.exports=h).prototype.finally=function(t){if("function"!=typeof t)return this;var e=this.constructor;return this.then((function(r){return e.resolve(t()).then((function(){return r}))}),(function(r){return e.resolve(t()).then((function(){throw r}))}))},h.prototype.catch=function(t){return this.then(null,t)},h.prototype.then=function(t,e){if("function"!=typeof t&&this.state===o||"function"!=typeof e&&this.state===s)return this;var r=new this.constructor(i);return this.state!==u?l(r,this.state===o?t:e,this.outcome):this.queue.push(new c(r,t,e)),r},c.prototype.callFulfilled=function(t){a.resolve(this.promise,t)},c.prototype.otherCallFulfilled=function(t){l(this.promise,this.onFulfilled,t)},c.prototype.callRejected=function(t){a.reject(this.promise,t)},c.prototype.otherCallRejected=function(t){l(this.promise,this.onRejected,t)},a.resolve=function(t,e){var r=p(f,e);if("error"===r.status)return a.reject(t,r.value);var n=r.value;if(n)d(t,n);else{t.state=o,t.outcome=e;for(var i=-1,s=t.queue.length;++i<s;)t.queue[i].callFulfilled(e)}return t},a.reject=function(t,e){t.state=s,t.outcome=e;for(var r=-1,n=t.queue.length;++r<n;)t.queue[r].callRejected(e);return t},h.resolve=function(t){return t instanceof this?t:a.resolve(new this(i),t)},h.reject=function(t){var e=new this(i);return a.reject(e,t)},h.all=function(t){var e=this;if("[object Array]"!==Object.prototype.toString.call(t))return this.reject(new TypeError("must be an array"));var r=t.length,n=!1;if(!r)return this.resolve([]);for(var s=new Array(r),o=0,u=-1,h=new this(i);++u<r;)c(t[u],u);return h;function c(t,i){e.resolve(t).then((function(t){s[i]=t,++o!==r||n||(n=!0,a.resolve(h,s))}),(function(t){n||(n=!0,a.reject(h,t))}))}},h.race=function(t){if("[object Array]"!==Object.prototype.toString.call(t))return this.reject(new TypeError("must be an array"));var e=t.length,r=!1;if(!e)return this.resolve([]);for(var n,s=-1,o=new this(i);++s<e;)n=t[s],this.resolve(n).then((function(t){r||(r=!0,a.resolve(o,t))}),(function(t){r||(r=!0,a.reject(o,t))}));return o}},{immediate:36}],38:[function(t,e,r){"use strict";var n={};(0,t("./lib/utils/common").assign)(n,t("./lib/deflate"),t("./lib/inflate"),t("./lib/zlib/constants")),e.exports=n},{"./lib/deflate":39,"./lib/inflate":40,"./lib/utils/common":41,"./lib/zlib/constants":44}],39:[function(t,e,r){"use strict";var n=t("./zlib/deflate"),i=t("./utils/common"),a=t("./utils/strings"),s=t("./zlib/messages"),o=t("./zlib/zstream"),u=Object.prototype.toString,h=0,c=-1,l=0,f=8;function d(t){if(!(this instanceof d))return new d(t);this.options=i.assign({level:c,method:f,chunkSize:16384,windowBits:15,memLevel:8,strategy:l,to:""},t||{});var e=this.options;e.raw&&0<e.windowBits?e.windowBits=-e.windowBits:e.gzip&&0<e.windowBits&&e.windowBits<16&&(e.windowBits+=16),this.err=0,this.msg="",this.ended=!1,this.chunks=[],this.strm=new o,this.strm.avail_out=0;var r=n.deflateInit2(this.strm,e.level,e.method,e.windowBits,e.memLevel,e.strategy);if(r!==h)throw new Error(s[r]);if(e.header&&n.deflateSetHeader(this.strm,e.header),e.dictionary){var p;if(p="string"==typeof e.dictionary?a.string2buf(e.dictionary):"[object ArrayBuffer]"===u.call(e.dictionary)?new Uint8Array(e.dictionary):e.dictionary,(r=n.deflateSetDictionary(this.strm,p))!==h)throw new Error(s[r]);this._dict_set=!0}}function p(t,e){var r=new d(e);if(r.push(t,!0),r.err)throw r.msg||s[r.err];return r.result}d.prototype.push=function(t,e){var r,s,o=this.strm,c=this.options.chunkSize;if(this.ended)return!1;s=e===~~e?e:!0===e?4:0,"string"==typeof t?o.input=a.string2buf(t):"[object ArrayBuffer]"===u.call(t)?o.input=new Uint8Array(t):o.input=t,o.next_in=0,o.avail_in=o.input.length;do{if(0===o.avail_out&&(o.output=new i.Buf8(c),o.next_out=0,o.avail_out=c),1!==(r=n.deflate(o,s))&&r!==h)return this.onEnd(r),!(this.ended=!0);0!==o.avail_out&&(0!==o.avail_in||4!==s&&2!==s)||("string"===this.options.to?this.onData(a.buf2binstring(i.shrinkBuf(o.output,o.next_out))):this.onData(i.shrinkBuf(o.output,o.next_out)))}while((0<o.avail_in||0===o.avail_out)&&1!==r);return 4===s?(r=n.deflateEnd(this.strm),this.onEnd(r),this.ended=!0,r===h):2!==s||(this.onEnd(h),!(o.avail_out=0))},d.prototype.onData=function(t){this.chunks.push(t)},d.prototype.onEnd=function(t){t===h&&("string"===this.options.to?this.result=this.chunks.join(""):this.result=i.flattenChunks(this.chunks)),this.chunks=[],this.err=t,this.msg=this.strm.msg},r.Deflate=d,r.deflate=p,r.deflateRaw=function(t,e){return(e=e||{}).raw=!0,p(t,e)},r.gzip=function(t,e){return(e=e||{}).gzip=!0,p(t,e)}},{"./utils/common":41,"./utils/strings":42,"./zlib/deflate":46,"./zlib/messages":51,"./zlib/zstream":53}],40:[function(t,e,r){"use strict";var n=t("./zlib/inflate"),i=t("./utils/common"),a=t("./utils/strings"),s=t("./zlib/constants"),o=t("./zlib/messages"),u=t("./zlib/zstream"),h=t("./zlib/gzheader"),c=Object.prototype.toString;function l(t){if(!(this instanceof l))return new l(t);this.options=i.assign({chunkSize:16384,windowBits:0,to:""},t||{});var e=this.options;e.raw&&0<=e.windowBits&&e.windowBits<16&&(e.windowBits=-e.windowBits,0===e.windowBits&&(e.windowBits=-15)),!(0<=e.windowBits&&e.windowBits<16)||t&&t.windowBits||(e.windowBits+=32),15<e.windowBits&&e.windowBits<48&&!(15&e.windowBits)&&(e.windowBits|=15),this.err=0,this.msg="",this.ended=!1,this.chunks=[],this.strm=new u,this.strm.avail_out=0;var r=n.inflateInit2(this.strm,e.windowBits);if(r!==s.Z_OK)throw new Error(o[r]);this.header=new h,n.inflateGetHeader(this.strm,this.header)}function f(t,e){var r=new l(e);if(r.push(t,!0),r.err)throw r.msg||o[r.err];return r.result}l.prototype.push=function(t,e){var r,o,u,h,l,f,d=this.strm,p=this.options.chunkSize,m=this.options.dictionary,_=!1;if(this.ended)return!1;o=e===~~e?e:!0===e?s.Z_FINISH:s.Z_NO_FLUSH,"string"==typeof t?d.input=a.binstring2buf(t):"[object ArrayBuffer]"===c.call(t)?d.input=new Uint8Array(t):d.input=t,d.next_in=0,d.avail_in=d.input.length;do{if(0===d.avail_out&&(d.output=new i.Buf8(p),d.next_out=0,d.avail_out=p),(r=n.inflate(d,s.Z_NO_FLUSH))===s.Z_NEED_DICT&&m&&(f="string"==typeof m?a.string2buf(m):"[object ArrayBuffer]"===c.call(m)?new Uint8Array(m):m,r=n.inflateSetDictionary(this.strm,f)),r===s.Z_BUF_ERROR&&!0===_&&(r=s.Z_OK,_=!1),r!==s.Z_STREAM_END&&r!==s.Z_OK)return this.onEnd(r),!(this.ended=!0);d.next_out&&(0!==d.avail_out&&r!==s.Z_STREAM_END&&(0!==d.avail_in||o!==s.Z_FINISH&&o!==s.Z_SYNC_FLUSH)||("string"===this.options.to?(u=a.utf8border(d.output,d.next_out),h=d.next_out-u,l=a.buf2string(d.output,u),d.next_out=h,d.avail_out=p-h,h&&i.arraySet(d.output,d.output,u,h,0),this.onData(l)):this.onData(i.shrinkBuf(d.output,d.next_out)))),0===d.avail_in&&0===d.avail_out&&(_=!0)}while((0<d.avail_in||0===d.avail_out)&&r!==s.Z_STREAM_END);return r===s.Z_STREAM_END&&(o=s.Z_FINISH),o===s.Z_FINISH?(r=n.inflateEnd(this.strm),this.onEnd(r),this.ended=!0,r===s.Z_OK):o!==s.Z_SYNC_FLUSH||(this.onEnd(s.Z_OK),!(d.avail_out=0))},l.prototype.onData=function(t){this.chunks.push(t)},l.prototype.onEnd=function(t){t===s.Z_OK&&("string"===this.options.to?this.result=this.chunks.join(""):this.result=i.flattenChunks(this.chunks)),this.chunks=[],this.err=t,this.msg=this.strm.msg},r.Inflate=l,r.inflate=f,r.inflateRaw=function(t,e){return(e=e||{}).raw=!0,f(t,e)},r.ungzip=f},{"./utils/common":41,"./utils/strings":42,"./zlib/constants":44,"./zlib/gzheader":47,"./zlib/inflate":49,"./zlib/messages":51,"./zlib/zstream":53}],41:[function(t,e,r){"use strict";var n="undefined"!=typeof Uint8Array&&"undefined"!=typeof Uint16Array&&"undefined"!=typeof Int32Array;r.assign=function(t){for(var e=Array.prototype.slice.call(arguments,1);e.length;){var r=e.shift();if(r){if("object"!=typeof r)throw new TypeError(r+"must be non-object");for(var n in r)r.hasOwnProperty(n)&&(t[n]=r[n])}}return t},r.shrinkBuf=function(t,e){return t.length===e?t:t.subarray?t.subarray(0,e):(t.length=e,t)};var i={arraySet:function(t,e,r,n,i){if(e.subarray&&t.subarray)t.set(e.subarray(r,r+n),i);else for(var a=0;a<n;a++)t[i+a]=e[r+a]},flattenChunks:function(t){var e,r,n,i,a,s;for(e=n=0,r=t.length;e<r;e++)n+=t[e].length;for(s=new Uint8Array(n),e=i=0,r=t.length;e<r;e++)a=t[e],s.set(a,i),i+=a.length;return s}},a={arraySet:function(t,e,r,n,i){for(var a=0;a<n;a++)t[i+a]=e[r+a]},flattenChunks:function(t){return[].concat.apply([],t)}};r.setTyped=function(t){t?(r.Buf8=Uint8Array,r.Buf16=Uint16Array,r.Buf32=Int32Array,r.assign(r,i)):(r.Buf8=Array,r.Buf16=Array,r.Buf32=Array,r.assign(r,a))},r.setTyped(n)},{}],42:[function(t,e,r){"use strict";var n=t("./common"),i=!0,a=!0;try{String.fromCharCode.apply(null,[0])}catch(t){i=!1}try{String.fromCharCode.apply(null,new Uint8Array(1))}catch(t){a=!1}for(var s=new n.Buf8(256),o=0;o<256;o++)s[o]=252<=o?6:248<=o?5:240<=o?4:224<=o?3:192<=o?2:1;function u(t,e){if(e<65537&&(t.subarray&&a||!t.subarray&&i))return String.fromCharCode.apply(null,n.shrinkBuf(t,e));for(var r="",s=0;s<e;s++)r+=String.fromCharCode(t[s]);return r}s[254]=s[254]=1,r.string2buf=function(t){var e,r,i,a,s,o=t.length,u=0;for(a=0;a<o;a++)55296==(64512&(r=t.charCodeAt(a)))&&a+1<o&&56320==(64512&(i=t.charCodeAt(a+1)))&&(r=65536+(r-55296<<10)+(i-56320),a++),u+=r<128?1:r<2048?2:r<65536?3:4;for(e=new n.Buf8(u),a=s=0;s<u;a++)55296==(64512&(r=t.charCodeAt(a)))&&a+1<o&&56320==(64512&(i=t.charCodeAt(a+1)))&&(r=65536+(r-55296<<10)+(i-56320),a++),r<128?e[s++]=r:(r<2048?e[s++]=192|r>>>6:(r<65536?e[s++]=224|r>>>12:(e[s++]=240|r>>>18,e[s++]=128|r>>>12&63),e[s++]=128|r>>>6&63),e[s++]=128|63&r);return e},r.buf2binstring=function(t){return u(t,t.length)},r.binstring2buf=function(t){for(var e=new n.Buf8(t.length),r=0,i=e.length;r<i;r++)e[r]=t.charCodeAt(r);return e},r.buf2string=function(t,e){var r,n,i,a,o=e||t.length,h=new Array(2*o);for(r=n=0;r<o;)if((i=t[r++])<128)h[n++]=i;else if(4<(a=s[i]))h[n++]=65533,r+=a-1;else{for(i&=2===a?31:3===a?15:7;1<a&&r<o;)i=i<<6|63&t[r++],a--;1<a?h[n++]=65533:i<65536?h[n++]=i:(i-=65536,h[n++]=55296|i>>10&1023,h[n++]=56320|1023&i)}return u(h,n)},r.utf8border=function(t,e){var r;for((e=e||t.length)>t.length&&(e=t.length),r=e-1;0<=r&&128==(192&t[r]);)r--;return r<0||0===r?e:r+s[t[r]]>e?r:e}},{"./common":41}],43:[function(t,e,r){"use strict";e.exports=function(t,e,r,n){for(var i=65535&t,a=t>>>16&65535,s=0;0!==r;){for(r-=s=2e3<r?2e3:r;a=a+(i=i+e[n++]|0)|0,--s;);i%=65521,a%=65521}return i|a<<16}},{}],44:[function(t,e,r){"use strict";e.exports={Z_NO_FLUSH:0,Z_PARTIAL_FLUSH:1,Z_SYNC_FLUSH:2,Z_FULL_FLUSH:3,Z_FINISH:4,Z_BLOCK:5,Z_TREES:6,Z_OK:0,Z_STREAM_END:1,Z_NEED_DICT:2,Z_ERRNO:-1,Z_STREAM_ERROR:-2,Z_DATA_ERROR:-3,Z_BUF_ERROR:-5,Z_NO_COMPRESSION:0,Z_BEST_SPEED:1,Z_BEST_COMPRESSION:9,Z_DEFAULT_COMPRESSION:-1,Z_FILTERED:1,Z_HUFFMAN_ONLY:2,Z_RLE:3,Z_FIXED:4,Z_DEFAULT_STRATEGY:0,Z_BINARY:0,Z_TEXT:1,Z_UNKNOWN:2,Z_DEFLATED:8}},{}],45:[function(t,e,r){"use strict";var n=function(){for(var t,e=[],r=0;r<256;r++){t=r;for(var n=0;n<8;n++)t=1&t?3988292384^t>>>1:t>>>1;e[r]=t}return e}();e.exports=function(t,e,r,i){var a=n,s=i+r;t^=-1;for(var o=i;o<s;o++)t=t>>>8^a[255&(t^e[o])];return~t}},{}],46:[function(t,e,r){"use strict";var n,i=t("../utils/common"),a=t("./trees"),s=t("./adler32"),o=t("./crc32"),u=t("./messages"),h=0,c=0,l=-2,f=2,d=8,p=286,m=30,_=19,g=2*p+1,v=15,y=3,b=258,w=b+y+1,k=42,x=113;function S(t,e){return t.msg=u[e],e}function E(t){return(t<<1)-(4<t?9:0)}function z(t){for(var e=t.length;0<=--e;)t[e]=0}function A(t){var e=t.state,r=e.pending;r>t.avail_out&&(r=t.avail_out),0!==r&&(i.arraySet(t.output,e.pending_buf,e.pending_out,r,t.next_out),t.next_out+=r,e.pending_out+=r,t.total_out+=r,t.avail_out-=r,e.pending-=r,0===e.pending&&(e.pending_out=0))}function C(t,e){a._tr_flush_block(t,0<=t.block_start?t.block_start:-1,t.strstart-t.block_start,e),t.block_start=t.strstart,A(t.strm)}function I(t,e){t.pending_buf[t.pending++]=e}function O(t,e){t.pending_buf[t.pending++]=e>>>8&255,t.pending_buf[t.pending++]=255&e}function B(t,e){var r,n,i=t.max_chain_length,a=t.strstart,s=t.prev_length,o=t.nice_match,u=t.strstart>t.w_size-w?t.strstart-(t.w_size-w):0,h=t.window,c=t.w_mask,l=t.prev,f=t.strstart+b,d=h[a+s-1],p=h[a+s];t.prev_length>=t.good_match&&(i>>=2),o>t.lookahead&&(o=t.lookahead);do{if(h[(r=e)+s]===p&&h[r+s-1]===d&&h[r]===h[a]&&h[++r]===h[a+1]){a+=2,r++;do{}while(h[++a]===h[++r]&&h[++a]===h[++r]&&h[++a]===h[++r]&&h[++a]===h[++r]&&h[++a]===h[++r]&&h[++a]===h[++r]&&h[++a]===h[++r]&&h[++a]===h[++r]&&a<f);if(n=b-(f-a),a=f-b,s<n){if(t.match_start=e,o<=(s=n))break;d=h[a+s-1],p=h[a+s]}}}while((e=l[e&c])>u&&0!=--i);return s<=t.lookahead?s:t.lookahead}function T(t){var e,r,n,a,u,h,c,l,f,d,p=t.w_size;do{if(a=t.window_size-t.lookahead-t.strstart,t.strstart>=p+(p-w)){for(i.arraySet(t.window,t.window,p,p,0),t.match_start-=p,t.strstart-=p,t.block_start-=p,e=r=t.hash_size;n=t.head[--e],t.head[e]=p<=n?n-p:0,--r;);for(e=r=p;n=t.prev[--e],t.prev[e]=p<=n?n-p:0,--r;);a+=p}if(0===t.strm.avail_in)break;if(h=t.strm,c=t.window,l=t.strstart+t.lookahead,d=void 0,(f=a)<(d=h.avail_in)&&(d=f),r=0===d?0:(h.avail_in-=d,i.arraySet(c,h.input,h.next_in,d,l),1===h.state.wrap?h.adler=s(h.adler,c,d,l):2===h.state.wrap&&(h.adler=o(h.adler,c,d,l)),h.next_in+=d,h.total_in+=d,d),t.lookahead+=r,t.lookahead+t.insert>=y)for(u=t.strstart-t.insert,t.ins_h=t.window[u],t.ins_h=(t.ins_h<<t.hash_shift^t.window[u+1])&t.hash_mask;t.insert&&(t.ins_h=(t.ins_h<<t.hash_shift^t.window[u+y-1])&t.hash_mask,t.prev[u&t.w_mask]=t.head[t.ins_h],t.head[t.ins_h]=u,u++,t.insert--,!(t.lookahead+t.insert<y)););}while(t.lookahead<w&&0!==t.strm.avail_in)}function R(t,e){for(var r,n;;){if(t.lookahead<w){if(T(t),t.lookahead<w&&e===h)return 1;if(0===t.lookahead)break}if(r=0,t.lookahead>=y&&(t.ins_h=(t.ins_h<<t.hash_shift^t.window[t.strstart+y-1])&t.hash_mask,r=t.prev[t.strstart&t.w_mask]=t.head[t.ins_h],t.head[t.ins_h]=t.strstart),0!==r&&t.strstart-r<=t.w_size-w&&(t.match_length=B(t,r)),t.match_length>=y)if(n=a._tr_tally(t,t.strstart-t.match_start,t.match_length-y),t.lookahead-=t.match_length,t.match_length<=t.max_lazy_match&&t.lookahead>=y){for(t.match_length--;t.strstart++,t.ins_h=(t.ins_h<<t.hash_shift^t.window[t.strstart+y-1])&t.hash_mask,r=t.prev[t.strstart&t.w_mask]=t.head[t.ins_h],t.head[t.ins_h]=t.strstart,0!=--t.match_length;);t.strstart++}else t.strstart+=t.match_length,t.match_length=0,t.ins_h=t.window[t.strstart],t.ins_h=(t.ins_h<<t.hash_shift^t.window[t.strstart+1])&t.hash_mask;else n=a._tr_tally(t,0,t.window[t.strstart]),t.lookahead--,t.strstart++;if(n&&(C(t,!1),0===t.strm.avail_out))return 1}return t.insert=t.strstart<y-1?t.strstart:y-1,4===e?(C(t,!0),0===t.strm.avail_out?3:4):t.last_lit&&(C(t,!1),0===t.strm.avail_out)?1:2}function D(t,e){for(var r,n,i;;){if(t.lookahead<w){if(T(t),t.lookahead<w&&e===h)return 1;if(0===t.lookahead)break}if(r=0,t.lookahead>=y&&(t.ins_h=(t.ins_h<<t.hash_shift^t.window[t.strstart+y-1])&t.hash_mask,r=t.prev[t.strstart&t.w_mask]=t.head[t.ins_h],t.head[t.ins_h]=t.strstart),t.prev_length=t.match_length,t.prev_match=t.match_start,t.match_length=y-1,0!==r&&t.prev_length<t.max_lazy_match&&t.strstart-r<=t.w_size-w&&(t.match_length=B(t,r),t.match_length<=5&&(1===t.strategy||t.match_length===y&&4096<t.strstart-t.match_start)&&(t.match_length=y-1)),t.prev_length>=y&&t.match_length<=t.prev_length){for(i=t.strstart+t.lookahead-y,n=a._tr_tally(t,t.strstart-1-t.prev_match,t.prev_length-y),t.lookahead-=t.prev_length-1,t.prev_length-=2;++t.strstart<=i&&(t.ins_h=(t.ins_h<<t.hash_shift^t.window[t.strstart+y-1])&t.hash_mask,r=t.prev[t.strstart&t.w_mask]=t.head[t.ins_h],t.head[t.ins_h]=t.strstart),0!=--t.prev_length;);if(t.match_available=0,t.match_length=y-1,t.strstart++,n&&(C(t,!1),0===t.strm.avail_out))return 1}else if(t.match_available){if((n=a._tr_tally(t,0,t.window[t.strstart-1]))&&C(t,!1),t.strstart++,t.lookahead--,0===t.strm.avail_out)return 1}else t.match_available=1,t.strstart++,t.lookahead--}return t.match_available&&(n=a._tr_tally(t,0,t.window[t.strstart-1]),t.match_available=0),t.insert=t.strstart<y-1?t.strstart:y-1,4===e?(C(t,!0),0===t.strm.avail_out?3:4):t.last_lit&&(C(t,!1),0===t.strm.avail_out)?1:2}function F(t,e,r,n,i){this.good_length=t,this.max_lazy=e,this.nice_length=r,this.max_chain=n,this.func=i}function N(){this.strm=null,this.status=0,this.pending_buf=null,this.pending_buf_size=0,this.pending_out=0,this.pending=0,this.wrap=0,this.gzhead=null,this.gzindex=0,this.method=d,this.last_flush=-1,this.w_size=0,this.w_bits=0,this.w_mask=0,this.window=null,this.window_size=0,this.prev=null,this.head=null,this.ins_h=0,this.hash_size=0,this.hash_bits=0,this.hash_mask=0,this.hash_shift=0,this.block_start=0,this.match_length=0,this.prev_match=0,this.match_available=0,this.strstart=0,this.match_start=0,this.lookahead=0,this.prev_length=0,this.max_chain_length=0,this.max_lazy_match=0,this.level=0,this.strategy=0,this.good_match=0,this.nice_match=0,this.dyn_ltree=new i.Buf16(2*g),this.dyn_dtree=new i.Buf16(2*(2*m+1)),this.bl_tree=new i.Buf16(2*(2*_+1)),z(this.dyn_ltree),z(this.dyn_dtree),z(this.bl_tree),this.l_desc=null,this.d_desc=null,this.bl_desc=null,this.bl_count=new i.Buf16(v+1),this.heap=new i.Buf16(2*p+1),z(this.heap),this.heap_len=0,this.heap_max=0,this.depth=new i.Buf16(2*p+1),z(this.depth),this.l_buf=0,this.lit_bufsize=0,this.last_lit=0,this.d_buf=0,this.opt_len=0,this.static_len=0,this.matches=0,this.insert=0,this.bi_buf=0,this.bi_valid=0}function L(t){var e;return t&&t.state?(t.total_in=t.total_out=0,t.data_type=f,(e=t.state).pending=0,e.pending_out=0,e.wrap<0&&(e.wrap=-e.wrap),e.status=e.wrap?k:x,t.adler=2===e.wrap?0:1,e.last_flush=h,a._tr_init(e),c):S(t,l)}function P(t){var e=L(t);return e===c&&function(t){t.window_size=2*t.w_size,z(t.head),t.max_lazy_match=n[t.level].max_lazy,t.good_match=n[t.level].good_length,t.nice_match=n[t.level].nice_length,t.max_chain_length=n[t.level].max_chain,t.strstart=0,t.block_start=0,t.lookahead=0,t.insert=0,t.match_length=t.prev_length=y-1,t.match_available=0,t.ins_h=0}(t.state),e}function U(t,e,r,n,a,s){if(!t)return l;var o=1;if(-1===e&&(e=6),n<0?(o=0,n=-n):15<n&&(o=2,n-=16),a<1||9<a||r!==d||n<8||15<n||e<0||9<e||s<0||4<s)return S(t,l);8===n&&(n=9);var u=new N;return(t.state=u).strm=t,u.wrap=o,u.gzhead=null,u.w_bits=n,u.w_size=1<<u.w_bits,u.w_mask=u.w_size-1,u.hash_bits=a+7,u.hash_size=1<<u.hash_bits,u.hash_mask=u.hash_size-1,u.hash_shift=~~((u.hash_bits+y-1)/y),u.window=new i.Buf8(2*u.w_size),u.head=new i.Buf16(u.hash_size),u.prev=new i.Buf16(u.w_size),u.lit_bufsize=1<<a+6,u.pending_buf_size=4*u.lit_bufsize,u.pending_buf=new i.Buf8(u.pending_buf_size),u.d_buf=1*u.lit_bufsize,u.l_buf=3*u.lit_bufsize,u.level=e,u.strategy=s,u.method=r,P(t)}n=[new F(0,0,0,0,(function(t,e){var r=65535;for(r>t.pending_buf_size-5&&(r=t.pending_buf_size-5);;){if(t.lookahead<=1){if(T(t),0===t.lookahead&&e===h)return 1;if(0===t.lookahead)break}t.strstart+=t.lookahead,t.lookahead=0;var n=t.block_start+r;if((0===t.strstart||t.strstart>=n)&&(t.lookahead=t.strstart-n,t.strstart=n,C(t,!1),0===t.strm.avail_out))return 1;if(t.strstart-t.block_start>=t.w_size-w&&(C(t,!1),0===t.strm.avail_out))return 1}return t.insert=0,4===e?(C(t,!0),0===t.strm.avail_out?3:4):(t.strstart>t.block_start&&(C(t,!1),t.strm.avail_out),1)})),new F(4,4,8,4,R),new F(4,5,16,8,R),new F(4,6,32,32,R),new F(4,4,16,16,D),new F(8,16,32,32,D),new F(8,16,128,128,D),new F(8,32,128,256,D),new F(32,128,258,1024,D),new F(32,258,258,4096,D)],r.deflateInit=function(t,e){return U(t,e,d,15,8,0)},r.deflateInit2=U,r.deflateReset=P,r.deflateResetKeep=L,r.deflateSetHeader=function(t,e){return t&&t.state?2!==t.state.wrap?l:(t.state.gzhead=e,c):l},r.deflate=function(t,e){var r,i,s,u;if(!t||!t.state||5<e||e<0)return t?S(t,l):l;if(i=t.state,!t.output||!t.input&&0!==t.avail_in||666===i.status&&4!==e)return S(t,0===t.avail_out?-5:l);if(i.strm=t,r=i.last_flush,i.last_flush=e,i.status===k)if(2===i.wrap)t.adler=0,I(i,31),I(i,139),I(i,8),i.gzhead?(I(i,(i.gzhead.text?1:0)+(i.gzhead.hcrc?2:0)+(i.gzhead.extra?4:0)+(i.gzhead.name?8:0)+(i.gzhead.comment?16:0)),I(i,255&i.gzhead.time),I(i,i.gzhead.time>>8&255),I(i,i.gzhead.time>>16&255),I(i,i.gzhead.time>>24&255),I(i,9===i.level?2:2<=i.strategy||i.level<2?4:0),I(i,255&i.gzhead.os),i.gzhead.extra&&i.gzhead.extra.length&&(I(i,255&i.gzhead.extra.length),I(i,i.gzhead.extra.length>>8&255)),i.gzhead.hcrc&&(t.adler=o(t.adler,i.pending_buf,i.pending,0)),i.gzindex=0,i.status=69):(I(i,0),I(i,0),I(i,0),I(i,0),I(i,0),I(i,9===i.level?2:2<=i.strategy||i.level<2?4:0),I(i,3),i.status=x);else{var f=d+(i.w_bits-8<<4)<<8;f|=(2<=i.strategy||i.level<2?0:i.level<6?1:6===i.level?2:3)<<6,0!==i.strstart&&(f|=32),f+=31-f%31,i.status=x,O(i,f),0!==i.strstart&&(O(i,t.adler>>>16),O(i,65535&t.adler)),t.adler=1}if(69===i.status)if(i.gzhead.extra){for(s=i.pending;i.gzindex<(65535&i.gzhead.extra.length)&&(i.pending!==i.pending_buf_size||(i.gzhead.hcrc&&i.pending>s&&(t.adler=o(t.adler,i.pending_buf,i.pending-s,s)),A(t),s=i.pending,i.pending!==i.pending_buf_size));)I(i,255&i.gzhead.extra[i.gzindex]),i.gzindex++;i.gzhead.hcrc&&i.pending>s&&(t.adler=o(t.adler,i.pending_buf,i.pending-s,s)),i.gzindex===i.gzhead.extra.length&&(i.gzindex=0,i.status=73)}else i.status=73;if(73===i.status)if(i.gzhead.name){s=i.pending;do{if(i.pending===i.pending_buf_size&&(i.gzhead.hcrc&&i.pending>s&&(t.adler=o(t.adler,i.pending_buf,i.pending-s,s)),A(t),s=i.pending,i.pending===i.pending_buf_size)){u=1;break}u=i.gzindex<i.gzhead.name.length?255&i.gzhead.name.charCodeAt(i.gzindex++):0,I(i,u)}while(0!==u);i.gzhead.hcrc&&i.pending>s&&(t.adler=o(t.adler,i.pending_buf,i.pending-s,s)),0===u&&(i.gzindex=0,i.status=91)}else i.status=91;if(91===i.status)if(i.gzhead.comment){s=i.pending;do{if(i.pending===i.pending_buf_size&&(i.gzhead.hcrc&&i.pending>s&&(t.adler=o(t.adler,i.pending_buf,i.pending-s,s)),A(t),s=i.pending,i.pending===i.pending_buf_size)){u=1;break}u=i.gzindex<i.gzhead.comment.length?255&i.gzhead.comment.charCodeAt(i.gzindex++):0,I(i,u)}while(0!==u);i.gzhead.hcrc&&i.pending>s&&(t.adler=o(t.adler,i.pending_buf,i.pending-s,s)),0===u&&(i.status=103)}else i.status=103;if(103===i.status&&(i.gzhead.hcrc?(i.pending+2>i.pending_buf_size&&A(t),i.pending+2<=i.pending_buf_size&&(I(i,255&t.adler),I(i,t.adler>>8&255),t.adler=0,i.status=x)):i.status=x),0!==i.pending){if(A(t),0===t.avail_out)return i.last_flush=-1,c}else if(0===t.avail_in&&E(e)<=E(r)&&4!==e)return S(t,-5);if(666===i.status&&0!==t.avail_in)return S(t,-5);if(0!==t.avail_in||0!==i.lookahead||e!==h&&666!==i.status){var p=2===i.strategy?function(t,e){for(var r;;){if(0===t.lookahead&&(T(t),0===t.lookahead)){if(e===h)return 1;break}if(t.match_length=0,r=a._tr_tally(t,0,t.window[t.strstart]),t.lookahead--,t.strstart++,r&&(C(t,!1),0===t.strm.avail_out))return 1}return t.insert=0,4===e?(C(t,!0),0===t.strm.avail_out?3:4):t.last_lit&&(C(t,!1),0===t.strm.avail_out)?1:2}(i,e):3===i.strategy?function(t,e){for(var r,n,i,s,o=t.window;;){if(t.lookahead<=b){if(T(t),t.lookahead<=b&&e===h)return 1;if(0===t.lookahead)break}if(t.match_length=0,t.lookahead>=y&&0<t.strstart&&(n=o[i=t.strstart-1])===o[++i]&&n===o[++i]&&n===o[++i]){s=t.strstart+b;do{}while(n===o[++i]&&n===o[++i]&&n===o[++i]&&n===o[++i]&&n===o[++i]&&n===o[++i]&&n===o[++i]&&n===o[++i]&&i<s);t.match_length=b-(s-i),t.match_length>t.lookahead&&(t.match_length=t.lookahead)}if(t.match_length>=y?(r=a._tr_tally(t,1,t.match_length-y),t.lookahead-=t.match_length,t.strstart+=t.match_length,t.match_length=0):(r=a._tr_tally(t,0,t.window[t.strstart]),t.lookahead--,t.strstart++),r&&(C(t,!1),0===t.strm.avail_out))return 1}return t.insert=0,4===e?(C(t,!0),0===t.strm.avail_out?3:4):t.last_lit&&(C(t,!1),0===t.strm.avail_out)?1:2}(i,e):n[i.level].func(i,e);if(3!==p&&4!==p||(i.status=666),1===p||3===p)return 0===t.avail_out&&(i.last_flush=-1),c;if(2===p&&(1===e?a._tr_align(i):5!==e&&(a._tr_stored_block(i,0,0,!1),3===e&&(z(i.head),0===i.lookahead&&(i.strstart=0,i.block_start=0,i.insert=0))),A(t),0===t.avail_out))return i.last_flush=-1,c}return 4!==e?c:i.wrap<=0?1:(2===i.wrap?(I(i,255&t.adler),I(i,t.adler>>8&255),I(i,t.adler>>16&255),I(i,t.adler>>24&255),I(i,255&t.total_in),I(i,t.total_in>>8&255),I(i,t.total_in>>16&255),I(i,t.total_in>>24&255)):(O(i,t.adler>>>16),O(i,65535&t.adler)),A(t),0<i.wrap&&(i.wrap=-i.wrap),0!==i.pending?c:1)},r.deflateEnd=function(t){var e;return t&&t.state?(e=t.state.status)!==k&&69!==e&&73!==e&&91!==e&&103!==e&&e!==x&&666!==e?S(t,l):(t.state=null,e===x?S(t,-3):c):l},r.deflateSetDictionary=function(t,e){var r,n,a,o,u,h,f,d,p=e.length;if(!t||!t.state)return l;if(2===(o=(r=t.state).wrap)||1===o&&r.status!==k||r.lookahead)return l;for(1===o&&(t.adler=s(t.adler,e,p,0)),r.wrap=0,p>=r.w_size&&(0===o&&(z(r.head),r.strstart=0,r.block_start=0,r.insert=0),d=new i.Buf8(r.w_size),i.arraySet(d,e,p-r.w_size,r.w_size,0),e=d,p=r.w_size),u=t.avail_in,h=t.next_in,f=t.input,t.avail_in=p,t.next_in=0,t.input=e,T(r);r.lookahead>=y;){for(n=r.strstart,a=r.lookahead-(y-1);r.ins_h=(r.ins_h<<r.hash_shift^r.window[n+y-1])&r.hash_mask,r.prev[n&r.w_mask]=r.head[r.ins_h],r.head[r.ins_h]=n,n++,--a;);r.strstart=n,r.lookahead=y-1,T(r)}return r.strstart+=r.lookahead,r.block_start=r.strstart,r.insert=r.lookahead,r.lookahead=0,r.match_length=r.prev_length=y-1,r.match_available=0,t.next_in=h,t.input=f,t.avail_in=u,r.wrap=o,c},r.deflateInfo="pako deflate (from Nodeca project)"},{"../utils/common":41,"./adler32":43,"./crc32":45,"./messages":51,"./trees":52}],47:[function(t,e,r){"use strict";e.exports=function(){this.text=0,this.time=0,this.xflags=0,this.os=0,this.extra=null,this.extra_len=0,this.name="",this.comment="",this.hcrc=0,this.done=!1}},{}],48:[function(t,e,r){"use strict";e.exports=function(t,e){var r,n,i,a,s,o,u,h,c,l,f,d,p,m,_,g,v,y,b,w,k,x,S,E,z;r=t.state,n=t.next_in,E=t.input,i=n+(t.avail_in-5),a=t.next_out,z=t.output,s=a-(e-t.avail_out),o=a+(t.avail_out-257),u=r.dmax,h=r.wsize,c=r.whave,l=r.wnext,f=r.window,d=r.hold,p=r.bits,m=r.lencode,_=r.distcode,g=(1<<r.lenbits)-1,v=(1<<r.distbits)-1;t:do{p<15&&(d+=E[n++]<<p,p+=8,d+=E[n++]<<p,p+=8),y=m[d&g];e:for(;;){if(d>>>=b=y>>>24,p-=b,0==(b=y>>>16&255))z[a++]=65535&y;else{if(!(16&b)){if(!(64&b)){y=m[(65535&y)+(d&(1<<b)-1)];continue e}if(32&b){r.mode=12;break t}t.msg="invalid literal/length code",r.mode=30;break t}w=65535&y,(b&=15)&&(p<b&&(d+=E[n++]<<p,p+=8),w+=d&(1<<b)-1,d>>>=b,p-=b),p<15&&(d+=E[n++]<<p,p+=8,d+=E[n++]<<p,p+=8),y=_[d&v];r:for(;;){if(d>>>=b=y>>>24,p-=b,!(16&(b=y>>>16&255))){if(!(64&b)){y=_[(65535&y)+(d&(1<<b)-1)];continue r}t.msg="invalid distance code",r.mode=30;break t}if(k=65535&y,p<(b&=15)&&(d+=E[n++]<<p,(p+=8)<b&&(d+=E[n++]<<p,p+=8)),u<(k+=d&(1<<b)-1)){t.msg="invalid distance too far back",r.mode=30;break t}if(d>>>=b,p-=b,(b=a-s)<k){if(c<(b=k-b)&&r.sane){t.msg="invalid distance too far back",r.mode=30;break t}if(S=f,(x=0)===l){if(x+=h-b,b<w){for(w-=b;z[a++]=f[x++],--b;);x=a-k,S=z}}else if(l<b){if(x+=h+l-b,(b-=l)<w){for(w-=b;z[a++]=f[x++],--b;);if(x=0,l<w){for(w-=b=l;z[a++]=f[x++],--b;);x=a-k,S=z}}}else if(x+=l-b,b<w){for(w-=b;z[a++]=f[x++],--b;);x=a-k,S=z}for(;2<w;)z[a++]=S[x++],z[a++]=S[x++],z[a++]=S[x++],w-=3;w&&(z[a++]=S[x++],1<w&&(z[a++]=S[x++]))}else{for(x=a-k;z[a++]=z[x++],z[a++]=z[x++],z[a++]=z[x++],2<(w-=3););w&&(z[a++]=z[x++],1<w&&(z[a++]=z[x++]))}break}}break}}while(n<i&&a<o);n-=w=p>>3,d&=(1<<(p-=w<<3))-1,t.next_in=n,t.next_out=a,t.avail_in=n<i?i-n+5:5-(n-i),t.avail_out=a<o?o-a+257:257-(a-o),r.hold=d,r.bits=p}},{}],49:[function(t,e,r){"use strict";var n=t("../utils/common"),i=t("./adler32"),a=t("./crc32"),s=t("./inffast"),o=t("./inftrees"),u=0,h=-2,c=1,l=852,f=592;function d(t){return(t>>>24&255)+(t>>>8&65280)+((65280&t)<<8)+((255&t)<<24)}function p(){this.mode=0,this.last=!1,this.wrap=0,this.havedict=!1,this.flags=0,this.dmax=0,this.check=0,this.total=0,this.head=null,this.wbits=0,this.wsize=0,this.whave=0,this.wnext=0,this.window=null,this.hold=0,this.bits=0,this.length=0,this.offset=0,this.extra=0,this.lencode=null,this.distcode=null,this.lenbits=0,this.distbits=0,this.ncode=0,this.nlen=0,this.ndist=0,this.have=0,this.next=null,this.lens=new n.Buf16(320),this.work=new n.Buf16(288),this.lendyn=null,this.distdyn=null,this.sane=0,this.back=0,this.was=0}function m(t){var e;return t&&t.state?(e=t.state,t.total_in=t.total_out=e.total=0,t.msg="",e.wrap&&(t.adler=1&e.wrap),e.mode=c,e.last=0,e.havedict=0,e.dmax=32768,e.head=null,e.hold=0,e.bits=0,e.lencode=e.lendyn=new n.Buf32(l),e.distcode=e.distdyn=new n.Buf32(f),e.sane=1,e.back=-1,u):h}function _(t){var e;return t&&t.state?((e=t.state).wsize=0,e.whave=0,e.wnext=0,m(t)):h}function g(t,e){var r,n;return t&&t.state?(n=t.state,e<0?(r=0,e=-e):(r=1+(e>>4),e<48&&(e&=15)),e&&(e<8||15<e)?h:(null!==n.window&&n.wbits!==e&&(n.window=null),n.wrap=r,n.wbits=e,_(t))):h}function v(t,e){var r,n;return t?(n=new p,(t.state=n).window=null,(r=g(t,e))!==u&&(t.state=null),r):h}var y,b,w=!0;function k(t){if(w){var e;for(y=new n.Buf32(512),b=new n.Buf32(32),e=0;e<144;)t.lens[e++]=8;for(;e<256;)t.lens[e++]=9;for(;e<280;)t.lens[e++]=7;for(;e<288;)t.lens[e++]=8;for(o(1,t.lens,0,288,y,0,t.work,{bits:9}),e=0;e<32;)t.lens[e++]=5;o(2,t.lens,0,32,b,0,t.work,{bits:5}),w=!1}t.lencode=y,t.lenbits=9,t.distcode=b,t.distbits=5}function x(t,e,r,i){var a,s=t.state;return null===s.window&&(s.wsize=1<<s.wbits,s.wnext=0,s.whave=0,s.window=new n.Buf8(s.wsize)),i>=s.wsize?(n.arraySet(s.window,e,r-s.wsize,s.wsize,0),s.wnext=0,s.whave=s.wsize):(i<(a=s.wsize-s.wnext)&&(a=i),n.arraySet(s.window,e,r-i,a,s.wnext),(i-=a)?(n.arraySet(s.window,e,r-i,i,0),s.wnext=i,s.whave=s.wsize):(s.wnext+=a,s.wnext===s.wsize&&(s.wnext=0),s.whave<s.wsize&&(s.whave+=a))),0}r.inflateReset=_,r.inflateReset2=g,r.inflateResetKeep=m,r.inflateInit=function(t){return v(t,15)},r.inflateInit2=v,r.inflate=function(t,e){var r,l,f,p,m,_,g,v,y,b,w,S,E,z,A,C,I,O,B,T,R,D,F,N,L=0,P=new n.Buf8(4),U=[16,17,18,0,8,7,9,6,10,5,11,4,12,3,13,2,14,1,15];if(!t||!t.state||!t.output||!t.input&&0!==t.avail_in)return h;12===(r=t.state).mode&&(r.mode=13),m=t.next_out,f=t.output,g=t.avail_out,p=t.next_in,l=t.input,_=t.avail_in,v=r.hold,y=r.bits,b=_,w=g,D=u;t:for(;;)switch(r.mode){case c:if(0===r.wrap){r.mode=13;break}for(;y<16;){if(0===_)break t;_--,v+=l[p++]<<y,y+=8}if(2&r.wrap&&35615===v){P[r.check=0]=255&v,P[1]=v>>>8&255,r.check=a(r.check,P,2,0),y=v=0,r.mode=2;break}if(r.flags=0,r.head&&(r.head.done=!1),!(1&r.wrap)||(((255&v)<<8)+(v>>8))%31){t.msg="incorrect header check",r.mode=30;break}if(8!=(15&v)){t.msg="unknown compression method",r.mode=30;break}if(y-=4,R=8+(15&(v>>>=4)),0===r.wbits)r.wbits=R;else if(R>r.wbits){t.msg="invalid window size",r.mode=30;break}r.dmax=1<<R,t.adler=r.check=1,r.mode=512&v?10:12,y=v=0;break;case 2:for(;y<16;){if(0===_)break t;_--,v+=l[p++]<<y,y+=8}if(r.flags=v,8!=(255&r.flags)){t.msg="unknown compression method",r.mode=30;break}if(57344&r.flags){t.msg="unknown header flags set",r.mode=30;break}r.head&&(r.head.text=v>>8&1),512&r.flags&&(P[0]=255&v,P[1]=v>>>8&255,r.check=a(r.check,P,2,0)),y=v=0,r.mode=3;case 3:for(;y<32;){if(0===_)break t;_--,v+=l[p++]<<y,y+=8}r.head&&(r.head.time=v),512&r.flags&&(P[0]=255&v,P[1]=v>>>8&255,P[2]=v>>>16&255,P[3]=v>>>24&255,r.check=a(r.check,P,4,0)),y=v=0,r.mode=4;case 4:for(;y<16;){if(0===_)break t;_--,v+=l[p++]<<y,y+=8}r.head&&(r.head.xflags=255&v,r.head.os=v>>8),512&r.flags&&(P[0]=255&v,P[1]=v>>>8&255,r.check=a(r.check,P,2,0)),y=v=0,r.mode=5;case 5:if(1024&r.flags){for(;y<16;){if(0===_)break t;_--,v+=l[p++]<<y,y+=8}r.length=v,r.head&&(r.head.extra_len=v),512&r.flags&&(P[0]=255&v,P[1]=v>>>8&255,r.check=a(r.check,P,2,0)),y=v=0}else r.head&&(r.head.extra=null);r.mode=6;case 6:if(1024&r.flags&&(_<(S=r.length)&&(S=_),S&&(r.head&&(R=r.head.extra_len-r.length,r.head.extra||(r.head.extra=new Array(r.head.extra_len)),n.arraySet(r.head.extra,l,p,S,R)),512&r.flags&&(r.check=a(r.check,l,S,p)),_-=S,p+=S,r.length-=S),r.length))break t;r.length=0,r.mode=7;case 7:if(2048&r.flags){if(0===_)break t;for(S=0;R=l[p+S++],r.head&&R&&r.length<65536&&(r.head.name+=String.fromCharCode(R)),R&&S<_;);if(512&r.flags&&(r.check=a(r.check,l,S,p)),_-=S,p+=S,R)break t}else r.head&&(r.head.name=null);r.length=0,r.mode=8;case 8:if(4096&r.flags){if(0===_)break t;for(S=0;R=l[p+S++],r.head&&R&&r.length<65536&&(r.head.comment+=String.fromCharCode(R)),R&&S<_;);if(512&r.flags&&(r.check=a(r.check,l,S,p)),_-=S,p+=S,R)break t}else r.head&&(r.head.comment=null);r.mode=9;case 9:if(512&r.flags){for(;y<16;){if(0===_)break t;_--,v+=l[p++]<<y,y+=8}if(v!==(65535&r.check)){t.msg="header crc mismatch",r.mode=30;break}y=v=0}r.head&&(r.head.hcrc=r.flags>>9&1,r.head.done=!0),t.adler=r.check=0,r.mode=12;break;case 10:for(;y<32;){if(0===_)break t;_--,v+=l[p++]<<y,y+=8}t.adler=r.check=d(v),y=v=0,r.mode=11;case 11:if(0===r.havedict)return t.next_out=m,t.avail_out=g,t.next_in=p,t.avail_in=_,r.hold=v,r.bits=y,2;t.adler=r.check=1,r.mode=12;case 12:if(5===e||6===e)break t;case 13:if(r.last){v>>>=7&y,y-=7&y,r.mode=27;break}for(;y<3;){if(0===_)break t;_--,v+=l[p++]<<y,y+=8}switch(r.last=1&v,y-=1,3&(v>>>=1)){case 0:r.mode=14;break;case 1:if(k(r),r.mode=20,6!==e)break;v>>>=2,y-=2;break t;case 2:r.mode=17;break;case 3:t.msg="invalid block type",r.mode=30}v>>>=2,y-=2;break;case 14:for(v>>>=7&y,y-=7&y;y<32;){if(0===_)break t;_--,v+=l[p++]<<y,y+=8}if((65535&v)!=(v>>>16^65535)){t.msg="invalid stored block lengths",r.mode=30;break}if(r.length=65535&v,y=v=0,r.mode=15,6===e)break t;case 15:r.mode=16;case 16:if(S=r.length){if(_<S&&(S=_),g<S&&(S=g),0===S)break t;n.arraySet(f,l,p,S,m),_-=S,p+=S,g-=S,m+=S,r.length-=S;break}r.mode=12;break;case 17:for(;y<14;){if(0===_)break t;_--,v+=l[p++]<<y,y+=8}if(r.nlen=257+(31&v),v>>>=5,y-=5,r.ndist=1+(31&v),v>>>=5,y-=5,r.ncode=4+(15&v),v>>>=4,y-=4,286<r.nlen||30<r.ndist){t.msg="too many length or distance symbols",r.mode=30;break}r.have=0,r.mode=18;case 18:for(;r.have<r.ncode;){for(;y<3;){if(0===_)break t;_--,v+=l[p++]<<y,y+=8}r.lens[U[r.have++]]=7&v,v>>>=3,y-=3}for(;r.have<19;)r.lens[U[r.have++]]=0;if(r.lencode=r.lendyn,r.lenbits=7,F={bits:r.lenbits},D=o(0,r.lens,0,19,r.lencode,0,r.work,F),r.lenbits=F.bits,D){t.msg="invalid code lengths set",r.mode=30;break}r.have=0,r.mode=19;case 19:for(;r.have<r.nlen+r.ndist;){for(;C=(L=r.lencode[v&(1<<r.lenbits)-1])>>>16&255,I=65535&L,!((A=L>>>24)<=y);){if(0===_)break t;_--,v+=l[p++]<<y,y+=8}if(I<16)v>>>=A,y-=A,r.lens[r.have++]=I;else{if(16===I){for(N=A+2;y<N;){if(0===_)break t;_--,v+=l[p++]<<y,y+=8}if(v>>>=A,y-=A,0===r.have){t.msg="invalid bit length repeat",r.mode=30;break}R=r.lens[r.have-1],S=3+(3&v),v>>>=2,y-=2}else if(17===I){for(N=A+3;y<N;){if(0===_)break t;_--,v+=l[p++]<<y,y+=8}y-=A,R=0,S=3+(7&(v>>>=A)),v>>>=3,y-=3}else{for(N=A+7;y<N;){if(0===_)break t;_--,v+=l[p++]<<y,y+=8}y-=A,R=0,S=11+(127&(v>>>=A)),v>>>=7,y-=7}if(r.have+S>r.nlen+r.ndist){t.msg="invalid bit length repeat",r.mode=30;break}for(;S--;)r.lens[r.have++]=R}}if(30===r.mode)break;if(0===r.lens[256]){t.msg="invalid code -- missing end-of-block",r.mode=30;break}if(r.lenbits=9,F={bits:r.lenbits},D=o(1,r.lens,0,r.nlen,r.lencode,0,r.work,F),r.lenbits=F.bits,D){t.msg="invalid literal/lengths set",r.mode=30;break}if(r.distbits=6,r.distcode=r.distdyn,F={bits:r.distbits},D=o(2,r.lens,r.nlen,r.ndist,r.distcode,0,r.work,F),r.distbits=F.bits,D){t.msg="invalid distances set",r.mode=30;break}if(r.mode=20,6===e)break t;case 20:r.mode=21;case 21:if(6<=_&&258<=g){t.next_out=m,t.avail_out=g,t.next_in=p,t.avail_in=_,r.hold=v,r.bits=y,s(t,w),m=t.next_out,f=t.output,g=t.avail_out,p=t.next_in,l=t.input,_=t.avail_in,v=r.hold,y=r.bits,12===r.mode&&(r.back=-1);break}for(r.back=0;C=(L=r.lencode[v&(1<<r.lenbits)-1])>>>16&255,I=65535&L,!((A=L>>>24)<=y);){if(0===_)break t;_--,v+=l[p++]<<y,y+=8}if(C&&!(240&C)){for(O=A,B=C,T=I;C=(L=r.lencode[T+((v&(1<<O+B)-1)>>O)])>>>16&255,I=65535&L,!(O+(A=L>>>24)<=y);){if(0===_)break t;_--,v+=l[p++]<<y,y+=8}v>>>=O,y-=O,r.back+=O}if(v>>>=A,y-=A,r.back+=A,r.length=I,0===C){r.mode=26;break}if(32&C){r.back=-1,r.mode=12;break}if(64&C){t.msg="invalid literal/length code",r.mode=30;break}r.extra=15&C,r.mode=22;case 22:if(r.extra){for(N=r.extra;y<N;){if(0===_)break t;_--,v+=l[p++]<<y,y+=8}r.length+=v&(1<<r.extra)-1,v>>>=r.extra,y-=r.extra,r.back+=r.extra}r.was=r.length,r.mode=23;case 23:for(;C=(L=r.distcode[v&(1<<r.distbits)-1])>>>16&255,I=65535&L,!((A=L>>>24)<=y);){if(0===_)break t;_--,v+=l[p++]<<y,y+=8}if(!(240&C)){for(O=A,B=C,T=I;C=(L=r.distcode[T+((v&(1<<O+B)-1)>>O)])>>>16&255,I=65535&L,!(O+(A=L>>>24)<=y);){if(0===_)break t;_--,v+=l[p++]<<y,y+=8}v>>>=O,y-=O,r.back+=O}if(v>>>=A,y-=A,r.back+=A,64&C){t.msg="invalid distance code",r.mode=30;break}r.offset=I,r.extra=15&C,r.mode=24;case 24:if(r.extra){for(N=r.extra;y<N;){if(0===_)break t;_--,v+=l[p++]<<y,y+=8}r.offset+=v&(1<<r.extra)-1,v>>>=r.extra,y-=r.extra,r.back+=r.extra}if(r.offset>r.dmax){t.msg="invalid distance too far back",r.mode=30;break}r.mode=25;case 25:if(0===g)break t;if(S=w-g,r.offset>S){if((S=r.offset-S)>r.whave&&r.sane){t.msg="invalid distance too far back",r.mode=30;break}E=S>r.wnext?(S-=r.wnext,r.wsize-S):r.wnext-S,S>r.length&&(S=r.length),z=r.window}else z=f,E=m-r.offset,S=r.length;for(g<S&&(S=g),g-=S,r.length-=S;f[m++]=z[E++],--S;);0===r.length&&(r.mode=21);break;case 26:if(0===g)break t;f[m++]=r.length,g--,r.mode=21;break;case 27:if(r.wrap){for(;y<32;){if(0===_)break t;_--,v|=l[p++]<<y,y+=8}if(w-=g,t.total_out+=w,r.total+=w,w&&(t.adler=r.check=r.flags?a(r.check,f,w,m-w):i(r.check,f,w,m-w)),w=g,(r.flags?v:d(v))!==r.check){t.msg="incorrect data check",r.mode=30;break}y=v=0}r.mode=28;case 28:if(r.wrap&&r.flags){for(;y<32;){if(0===_)break t;_--,v+=l[p++]<<y,y+=8}if(v!==(4294967295&r.total)){t.msg="incorrect length check",r.mode=30;break}y=v=0}r.mode=29;case 29:D=1;break t;case 30:D=-3;break t;case 31:return-4;default:return h}return t.next_out=m,t.avail_out=g,t.next_in=p,t.avail_in=_,r.hold=v,r.bits=y,(r.wsize||w!==t.avail_out&&r.mode<30&&(r.mode<27||4!==e))&&x(t,t.output,t.next_out,w-t.avail_out)?(r.mode=31,-4):(b-=t.avail_in,w-=t.avail_out,t.total_in+=b,t.total_out+=w,r.total+=w,r.wrap&&w&&(t.adler=r.check=r.flags?a(r.check,f,w,t.next_out-w):i(r.check,f,w,t.next_out-w)),t.data_type=r.bits+(r.last?64:0)+(12===r.mode?128:0)+(20===r.mode||15===r.mode?256:0),(0==b&&0===w||4===e)&&D===u&&(D=-5),D)},r.inflateEnd=function(t){if(!t||!t.state)return h;var e=t.state;return e.window&&(e.window=null),t.state=null,u},r.inflateGetHeader=function(t,e){var r;return t&&t.state&&2&(r=t.state).wrap?((r.head=e).done=!1,u):h},r.inflateSetDictionary=function(t,e){var r,n=e.length;return t&&t.state?0!==(r=t.state).wrap&&11!==r.mode?h:11===r.mode&&i(1,e,n,0)!==r.check?-3:x(t,e,n,n)?(r.mode=31,-4):(r.havedict=1,u):h},r.inflateInfo="pako inflate (from Nodeca project)"},{"../utils/common":41,"./adler32":43,"./crc32":45,"./inffast":48,"./inftrees":50}],50:[function(t,e,r){"use strict";var n=t("../utils/common"),i=[3,4,5,6,7,8,9,10,11,13,15,17,19,23,27,31,35,43,51,59,67,83,99,115,131,163,195,227,258,0,0],a=[16,16,16,16,16,16,16,16,17,17,17,17,18,18,18,18,19,19,19,19,20,20,20,20,21,21,21,21,16,72,78],s=[1,2,3,4,5,7,9,13,17,25,33,49,65,97,129,193,257,385,513,769,1025,1537,2049,3073,4097,6145,8193,12289,16385,24577,0,0],o=[16,16,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23,24,24,25,25,26,26,27,27,28,28,29,29,64,64];e.exports=function(t,e,r,u,h,c,l,f){var d,p,m,_,g,v,y,b,w,k=f.bits,x=0,S=0,E=0,z=0,A=0,C=0,I=0,O=0,B=0,T=0,R=null,D=0,F=new n.Buf16(16),N=new n.Buf16(16),L=null,P=0;for(x=0;x<=15;x++)F[x]=0;for(S=0;S<u;S++)F[e[r+S]]++;for(A=k,z=15;1<=z&&0===F[z];z--);if(z<A&&(A=z),0===z)return h[c++]=20971520,h[c++]=20971520,f.bits=1,0;for(E=1;E<z&&0===F[E];E++);for(A<E&&(A=E),x=O=1;x<=15;x++)if(O<<=1,(O-=F[x])<0)return-1;if(0<O&&(0===t||1!==z))return-1;for(N[1]=0,x=1;x<15;x++)N[x+1]=N[x]+F[x];for(S=0;S<u;S++)0!==e[r+S]&&(l[N[e[r+S]]++]=S);if(v=0===t?(R=L=l,19):1===t?(R=i,D-=257,L=a,P-=257,256):(R=s,L=o,-1),x=E,g=c,I=S=T=0,m=-1,_=(B=1<<(C=A))-1,1===t&&852<B||2===t&&592<B)return 1;for(;;){for(y=x-I,w=l[S]<v?(b=0,l[S]):l[S]>v?(b=L[P+l[S]],R[D+l[S]]):(b=96,0),d=1<<x-I,E=p=1<<C;h[g+(T>>I)+(p-=d)]=y<<24|b<<16|w,0!==p;);for(d=1<<x-1;T&d;)d>>=1;if(0!==d?(T&=d-1,T+=d):T=0,S++,0==--F[x]){if(x===z)break;x=e[r+l[S]]}if(A<x&&(T&_)!==m){for(0===I&&(I=A),g+=E,O=1<<(C=x-I);C+I<z&&!((O-=F[C+I])<=0);)C++,O<<=1;if(B+=1<<C,1===t&&852<B||2===t&&592<B)return 1;h[m=T&_]=A<<24|C<<16|g-c}}return 0!==T&&(h[g+T]=x-I<<24|64<<16),f.bits=A,0}},{"../utils/common":41}],51:[function(t,e,r){"use strict";e.exports={2:"need dictionary",1:"stream end",0:"","-1":"file error","-2":"stream error","-3":"data error","-4":"insufficient memory","-5":"buffer error","-6":"incompatible version"}},{}],52:[function(t,e,r){"use strict";var n=t("../utils/common");function i(t){for(var e=t.length;0<=--e;)t[e]=0}var a=256,s=286,o=30,u=15,h=16,c=[0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,2,3,3,3,3,4,4,4,4,5,5,5,5,0],l=[0,0,0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13],f=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,3,7],d=[16,17,18,0,8,7,9,6,10,5,11,4,12,3,13,2,14,1,15],p=new Array(576);i(p);var m=new Array(60);i(m);var _=new Array(512);i(_);var g=new Array(256);i(g);var v=new Array(29);i(v);var y,b,w,k=new Array(o);function x(t,e,r,n,i){this.static_tree=t,this.extra_bits=e,this.extra_base=r,this.elems=n,this.max_length=i,this.has_stree=t&&t.length}function S(t,e){this.dyn_tree=t,this.max_code=0,this.stat_desc=e}function E(t){return t<256?_[t]:_[256+(t>>>7)]}function z(t,e){t.pending_buf[t.pending++]=255&e,t.pending_buf[t.pending++]=e>>>8&255}function A(t,e,r){t.bi_valid>h-r?(t.bi_buf|=e<<t.bi_valid&65535,z(t,t.bi_buf),t.bi_buf=e>>h-t.bi_valid,t.bi_valid+=r-h):(t.bi_buf|=e<<t.bi_valid&65535,t.bi_valid+=r)}function C(t,e,r){A(t,r[2*e],r[2*e+1])}function I(t,e){for(var r=0;r|=1&t,t>>>=1,r<<=1,0<--e;);return r>>>1}function O(t,e,r){var n,i,a=new Array(u+1),s=0;for(n=1;n<=u;n++)a[n]=s=s+r[n-1]<<1;for(i=0;i<=e;i++){var o=t[2*i+1];0!==o&&(t[2*i]=I(a[o]++,o))}}function B(t){var e;for(e=0;e<s;e++)t.dyn_ltree[2*e]=0;for(e=0;e<o;e++)t.dyn_dtree[2*e]=0;for(e=0;e<19;e++)t.bl_tree[2*e]=0;t.dyn_ltree[512]=1,t.opt_len=t.static_len=0,t.last_lit=t.matches=0}function T(t){8<t.bi_valid?z(t,t.bi_buf):0<t.bi_valid&&(t.pending_buf[t.pending++]=t.bi_buf),t.bi_buf=0,t.bi_valid=0}function R(t,e,r,n){var i=2*e,a=2*r;return t[i]<t[a]||t[i]===t[a]&&n[e]<=n[r]}function D(t,e,r){for(var n=t.heap[r],i=r<<1;i<=t.heap_len&&(i<t.heap_len&&R(e,t.heap[i+1],t.heap[i],t.depth)&&i++,!R(e,n,t.heap[i],t.depth));)t.heap[r]=t.heap[i],r=i,i<<=1;t.heap[r]=n}function F(t,e,r){var n,i,s,o,u=0;if(0!==t.last_lit)for(;n=t.pending_buf[t.d_buf+2*u]<<8|t.pending_buf[t.d_buf+2*u+1],i=t.pending_buf[t.l_buf+u],u++,0===n?C(t,i,e):(C(t,(s=g[i])+a+1,e),0!==(o=c[s])&&A(t,i-=v[s],o),C(t,s=E(--n),r),0!==(o=l[s])&&A(t,n-=k[s],o)),u<t.last_lit;);C(t,256,e)}function N(t,e){var r,n,i,a=e.dyn_tree,s=e.stat_desc.static_tree,o=e.stat_desc.has_stree,h=e.stat_desc.elems,c=-1;for(t.heap_len=0,t.heap_max=573,r=0;r<h;r++)0!==a[2*r]?(t.heap[++t.heap_len]=c=r,t.depth[r]=0):a[2*r+1]=0;for(;t.heap_len<2;)a[2*(i=t.heap[++t.heap_len]=c<2?++c:0)]=1,t.depth[i]=0,t.opt_len--,o&&(t.static_len-=s[2*i+1]);for(e.max_code=c,r=t.heap_len>>1;1<=r;r--)D(t,a,r);for(i=h;r=t.heap[1],t.heap[1]=t.heap[t.heap_len--],D(t,a,1),n=t.heap[1],t.heap[--t.heap_max]=r,t.heap[--t.heap_max]=n,a[2*i]=a[2*r]+a[2*n],t.depth[i]=(t.depth[r]>=t.depth[n]?t.depth[r]:t.depth[n])+1,a[2*r+1]=a[2*n+1]=i,t.heap[1]=i++,D(t,a,1),2<=t.heap_len;);t.heap[--t.heap_max]=t.heap[1],function(t,e){var r,n,i,a,s,o,h=e.dyn_tree,c=e.max_code,l=e.stat_desc.static_tree,f=e.stat_desc.has_stree,d=e.stat_desc.extra_bits,p=e.stat_desc.extra_base,m=e.stat_desc.max_length,_=0;for(a=0;a<=u;a++)t.bl_count[a]=0;for(h[2*t.heap[t.heap_max]+1]=0,r=t.heap_max+1;r<573;r++)m<(a=h[2*h[2*(n=t.heap[r])+1]+1]+1)&&(a=m,_++),h[2*n+1]=a,c<n||(t.bl_count[a]++,s=0,p<=n&&(s=d[n-p]),o=h[2*n],t.opt_len+=o*(a+s),f&&(t.static_len+=o*(l[2*n+1]+s)));if(0!==_){do{for(a=m-1;0===t.bl_count[a];)a--;t.bl_count[a]--,t.bl_count[a+1]+=2,t.bl_count[m]--,_-=2}while(0<_);for(a=m;0!==a;a--)for(n=t.bl_count[a];0!==n;)c<(i=t.heap[--r])||(h[2*i+1]!==a&&(t.opt_len+=(a-h[2*i+1])*h[2*i],h[2*i+1]=a),n--)}}(t,e),O(a,c,t.bl_count)}function L(t,e,r){var n,i,a=-1,s=e[1],o=0,u=7,h=4;for(0===s&&(u=138,h=3),e[2*(r+1)+1]=65535,n=0;n<=r;n++)i=s,s=e[2*(n+1)+1],++o<u&&i===s||(o<h?t.bl_tree[2*i]+=o:0!==i?(i!==a&&t.bl_tree[2*i]++,t.bl_tree[32]++):o<=10?t.bl_tree[34]++:t.bl_tree[36]++,a=i,h=(o=0)===s?(u=138,3):i===s?(u=6,3):(u=7,4))}function P(t,e,r){var n,i,a=-1,s=e[1],o=0,u=7,h=4;for(0===s&&(u=138,h=3),n=0;n<=r;n++)if(i=s,s=e[2*(n+1)+1],!(++o<u&&i===s)){if(o<h)for(;C(t,i,t.bl_tree),0!=--o;);else 0!==i?(i!==a&&(C(t,i,t.bl_tree),o--),C(t,16,t.bl_tree),A(t,o-3,2)):o<=10?(C(t,17,t.bl_tree),A(t,o-3,3)):(C(t,18,t.bl_tree),A(t,o-11,7));a=i,h=(o=0)===s?(u=138,3):i===s?(u=6,3):(u=7,4)}}i(k);var U=!1;function j(t,e,r,i){A(t,0+(i?1:0),3),function(t,e,r,i){T(t),z(t,r),z(t,~r),n.arraySet(t.pending_buf,t.window,e,r,t.pending),t.pending+=r}(t,e,r)}r._tr_init=function(t){U||(function(){var t,e,r,n,i,a=new Array(u+1);for(n=r=0;n<28;n++)for(v[n]=r,t=0;t<1<<c[n];t++)g[r++]=n;for(g[r-1]=n,n=i=0;n<16;n++)for(k[n]=i,t=0;t<1<<l[n];t++)_[i++]=n;for(i>>=7;n<o;n++)for(k[n]=i<<7,t=0;t<1<<l[n]-7;t++)_[256+i++]=n;for(e=0;e<=u;e++)a[e]=0;for(t=0;t<=143;)p[2*t+1]=8,t++,a[8]++;for(;t<=255;)p[2*t+1]=9,t++,a[9]++;for(;t<=279;)p[2*t+1]=7,t++,a[7]++;for(;t<=287;)p[2*t+1]=8,t++,a[8]++;for(O(p,287,a),t=0;t<o;t++)m[2*t+1]=5,m[2*t]=I(t,5);y=new x(p,c,257,s,u),b=new x(m,l,0,o,u),w=new x(new Array(0),f,0,19,7)}(),U=!0),t.l_desc=new S(t.dyn_ltree,y),t.d_desc=new S(t.dyn_dtree,b),t.bl_desc=new S(t.bl_tree,w),t.bi_buf=0,t.bi_valid=0,B(t)},r._tr_stored_block=j,r._tr_flush_block=function(t,e,r,n){var i,s,o=0;0<t.level?(2===t.strm.data_type&&(t.strm.data_type=function(t){var e,r=4093624447;for(e=0;e<=31;e++,r>>>=1)if(1&r&&0!==t.dyn_ltree[2*e])return 0;if(0!==t.dyn_ltree[18]||0!==t.dyn_ltree[20]||0!==t.dyn_ltree[26])return 1;for(e=32;e<a;e++)if(0!==t.dyn_ltree[2*e])return 1;return 0}(t)),N(t,t.l_desc),N(t,t.d_desc),o=function(t){var e;for(L(t,t.dyn_ltree,t.l_desc.max_code),L(t,t.dyn_dtree,t.d_desc.max_code),N(t,t.bl_desc),e=18;3<=e&&0===t.bl_tree[2*d[e]+1];e--);return t.opt_len+=3*(e+1)+5+5+4,e}(t),i=t.opt_len+3+7>>>3,(s=t.static_len+3+7>>>3)<=i&&(i=s)):i=s=r+5,r+4<=i&&-1!==e?j(t,e,r,n):4===t.strategy||s===i?(A(t,2+(n?1:0),3),F(t,p,m)):(A(t,4+(n?1:0),3),function(t,e,r,n){var i;for(A(t,e-257,5),A(t,r-1,5),A(t,n-4,4),i=0;i<n;i++)A(t,t.bl_tree[2*d[i]+1],3);P(t,t.dyn_ltree,e-1),P(t,t.dyn_dtree,r-1)}(t,t.l_desc.max_code+1,t.d_desc.max_code+1,o+1),F(t,t.dyn_ltree,t.dyn_dtree)),B(t),n&&T(t)},r._tr_tally=function(t,e,r){return t.pending_buf[t.d_buf+2*t.last_lit]=e>>>8&255,t.pending_buf[t.d_buf+2*t.last_lit+1]=255&e,t.pending_buf[t.l_buf+t.last_lit]=255&r,t.last_lit++,0===e?t.dyn_ltree[2*r]++:(t.matches++,e--,t.dyn_ltree[2*(g[r]+a+1)]++,t.dyn_dtree[2*E(e)]++),t.last_lit===t.lit_bufsize-1},r._tr_align=function(t){A(t,2,3),C(t,256,p),function(t){16===t.bi_valid?(z(t,t.bi_buf),t.bi_buf=0,t.bi_valid=0):8<=t.bi_valid&&(t.pending_buf[t.pending++]=255&t.bi_buf,t.bi_buf>>=8,t.bi_valid-=8)}(t)}},{"../utils/common":41}],53:[function(t,e,r){"use strict";e.exports=function(){this.input=null,this.next_in=0,this.avail_in=0,this.total_in=0,this.output=null,this.next_out=0,this.avail_out=0,this.total_out=0,this.msg="",this.state=null,this.data_type=2,this.adler=0}},{}],54:[function(t,e,n){(function(t){!function(t,e){"use strict";if(!t.setImmediate){var r,n,i,a,s=1,o={},u=!1,h=t.document,c=Object.getPrototypeOf&&Object.getPrototypeOf(t);c=c&&c.setTimeout?c:t,r="[object process]"==={}.toString.call(t.process)?function(t){process.nextTick((function(){f(t)}))}:function(){if(t.postMessage&&!t.importScripts){var e=!0,r=t.onmessage;return t.onmessage=function(){e=!1},t.postMessage("","*"),t.onmessage=r,e}}()?(a="setImmediate$"+Math.random()+"$",t.addEventListener?t.addEventListener("message",d,!1):t.attachEvent("onmessage",d),function(e){t.postMessage(a+e,"*")}):t.MessageChannel?((i=new MessageChannel).port1.onmessage=function(t){f(t.data)},function(t){i.port2.postMessage(t)}):h&&"onreadystatechange"in h.createElement("script")?(n=h.documentElement,function(t){var e=h.createElement("script");e.onreadystatechange=function(){f(t),e.onreadystatechange=null,n.removeChild(e),e=null},n.appendChild(e)}):function(t){setTimeout(f,0,t)},c.setImmediate=function(t){"function"!=typeof t&&(t=new Function(""+t));for(var e=new Array(arguments.length-1),n=0;n<e.length;n++)e[n]=arguments[n+1];var i={callback:t,args:e};return o[s]=i,r(s),s++},c.clearImmediate=l}function l(t){delete o[t]}function f(t){if(u)setTimeout(f,0,t);else{var r=o[t];if(r){u=!0;try{!function(t){var r=t.callback,n=t.args;switch(n.length){case 0:r();break;case 1:r(n[0]);break;case 2:r(n[0],n[1]);break;case 3:r(n[0],n[1],n[2]);break;default:r.apply(e,n)}}(r)}finally{l(t),u=!1}}}}function d(e){e.source===t&&"string"==typeof e.data&&0===e.data.indexOf(a)&&f(+e.data.slice(a.length))}}("undefined"==typeof self?void 0===t?this:t:self)}).call(this,void 0!==r.g?r.g:"undefined"!=typeof self?self:"undefined"!=typeof window?window:{})},{}]},{},[10])(10)}},e={};function r(n){var i=e[n];if(void 0!==i)return i.exports;var a=e[n]={exports:{}};return t[n](a,a.exports,r),a.exports}r.g=function(){if("object"==typeof globalThis)return globalThis;try{return this||new Function("return this")()}catch(t){if("object"==typeof window)return window}}(),(()=>{function t(e){return t="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t},t(e)}function e(t,e){var r="undefined"!=typeof Symbol&&t[Symbol.iterator]||t["@@iterator"];if(!r){if(Array.isArray(t)||(r=function(t,e){if(t){if("string"==typeof t)return n(t,e);var r=Object.prototype.toString.call(t).slice(8,-1);return"Object"===r&&t.constructor&&(r=t.constructor.name),"Map"===r||"Set"===r?Array.from(t):"Arguments"===r||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(r)?n(t,e):void 0}}(t))||e&&t&&"number"==typeof t.length){r&&(t=r);var i=0,a=function(){};return{s:a,n:function(){return i>=t.length?{done:!0}:{done:!1,value:t[i++]}},e:function(t){throw t},f:a}}throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}var s,o=!0,u=!1;return{s:function(){r=r.call(t)},n:function(){var t=r.next();return o=t.done,t},e:function(t){u=!0,s=t},f:function(){try{o||null==r.return||r.return()}finally{if(u)throw s}}}}function n(t,e){(null==e||e>t.length)&&(e=t.length);for(var r=0,n=new Array(e);r<e;r++)n[r]=t[r];return n}function i(){"use strict";i=function(){return r};var e,r={},n=Object.prototype,a=n.hasOwnProperty,s=Object.defineProperty||function(t,e,r){t[e]=r.value},o="function"==typeof Symbol?Symbol:{},u=o.iterator||"@@iterator",h=o.asyncIterator||"@@asyncIterator",c=o.toStringTag||"@@toStringTag";function l(t,e,r){return Object.defineProperty(t,e,{value:r,enumerable:!0,configurable:!0,writable:!0}),t[e]}try{l({},"")}catch(e){l=function(t,e,r){return t[e]=r}}function f(t,e,r,n){var i=e&&e.prototype instanceof y?e:y,a=Object.create(i.prototype),o=new T(n||[]);return s(a,"_invoke",{value:C(t,r,o)}),a}function d(t,e,r){try{return{type:"normal",arg:t.call(e,r)}}catch(t){return{type:"throw",arg:t}}}r.wrap=f;var p="suspendedStart",m="suspendedYield",_="executing",g="completed",v={};function y(){}function b(){}function w(){}var k={};l(k,u,(function(){return this}));var x=Object.getPrototypeOf,S=x&&x(x(R([])));S&&S!==n&&a.call(S,u)&&(k=S);var E=w.prototype=y.prototype=Object.create(k);function z(t){["next","throw","return"].forEach((function(e){l(t,e,(function(t){return this._invoke(e,t)}))}))}function A(e,r){function n(i,s,o,u){var h=d(e[i],e,s);if("throw"!==h.type){var c=h.arg,l=c.value;return l&&"object"==t(l)&&a.call(l,"__await")?r.resolve(l.__await).then((function(t){n("next",t,o,u)}),(function(t){n("throw",t,o,u)})):r.resolve(l).then((function(t){c.value=t,o(c)}),(function(t){return n("throw",t,o,u)}))}u(h.arg)}var i;s(this,"_invoke",{value:function(t,e){function a(){return new r((function(r,i){n(t,e,r,i)}))}return i=i?i.then(a,a):a()}})}function C(t,r,n){var i=p;return function(a,s){if(i===_)throw Error("Generator is already running");if(i===g){if("throw"===a)throw s;return{value:e,done:!0}}for(n.method=a,n.arg=s;;){var o=n.delegate;if(o){var u=I(o,n);if(u){if(u===v)continue;return u}}if("next"===n.method)n.sent=n._sent=n.arg;else if("throw"===n.method){if(i===p)throw i=g,n.arg;n.dispatchException(n.arg)}else"return"===n.method&&n.abrupt("return",n.arg);i=_;var h=d(t,r,n);if("normal"===h.type){if(i=n.done?g:m,h.arg===v)continue;return{value:h.arg,done:n.done}}"throw"===h.type&&(i=g,n.method="throw",n.arg=h.arg)}}}function I(t,r){var n=r.method,i=t.iterator[n];if(i===e)return r.delegate=null,"throw"===n&&t.iterator.return&&(r.method="return",r.arg=e,I(t,r),"throw"===r.method)||"return"!==n&&(r.method="throw",r.arg=new TypeError("The iterator does not provide a '"+n+"' method")),v;var a=d(i,t.iterator,r.arg);if("throw"===a.type)return r.method="throw",r.arg=a.arg,r.delegate=null,v;var s=a.arg;return s?s.done?(r[t.resultName]=s.value,r.next=t.nextLoc,"return"!==r.method&&(r.method="next",r.arg=e),r.delegate=null,v):s:(r.method="throw",r.arg=new TypeError("iterator result is not an object"),r.delegate=null,v)}function O(t){var e={tryLoc:t[0]};1 in t&&(e.catchLoc=t[1]),2 in t&&(e.finallyLoc=t[2],e.afterLoc=t[3]),this.tryEntries.push(e)}function B(t){var e=t.completion||{};e.type="normal",delete e.arg,t.completion=e}function T(t){this.tryEntries=[{tryLoc:"root"}],t.forEach(O,this),this.reset(!0)}function R(r){if(r||""===r){var n=r[u];if(n)return n.call(r);if("function"==typeof r.next)return r;if(!isNaN(r.length)){var i=-1,s=function t(){for(;++i<r.length;)if(a.call(r,i))return t.value=r[i],t.done=!1,t;return t.value=e,t.done=!0,t};return s.next=s}}throw new TypeError(t(r)+" is not iterable")}return b.prototype=w,s(E,"constructor",{value:w,configurable:!0}),s(w,"constructor",{value:b,configurable:!0}),b.displayName=l(w,c,"GeneratorFunction"),r.isGeneratorFunction=function(t){var e="function"==typeof t&&t.constructor;return!!e&&(e===b||"GeneratorFunction"===(e.displayName||e.name))},r.mark=function(t){return Object.setPrototypeOf?Object.setPrototypeOf(t,w):(t.__proto__=w,l(t,c,"GeneratorFunction")),t.prototype=Object.create(E),t},r.awrap=function(t){return{__await:t}},z(A.prototype),l(A.prototype,h,(function(){return this})),r.AsyncIterator=A,r.async=function(t,e,n,i,a){void 0===a&&(a=Promise);var s=new A(f(t,e,n,i),a);return r.isGeneratorFunction(e)?s:s.next().then((function(t){return t.done?t.value:s.next()}))},z(E),l(E,c,"Generator"),l(E,u,(function(){return this})),l(E,"toString",(function(){return"[object Generator]"})),r.keys=function(t){var e=Object(t),r=[];for(var n in e)r.push(n);return r.reverse(),function t(){for(;r.length;){var n=r.pop();if(n in e)return t.value=n,t.done=!1,t}return t.done=!0,t}},r.values=R,T.prototype={constructor:T,reset:function(t){if(this.prev=0,this.next=0,this.sent=this._sent=e,this.done=!1,this.delegate=null,this.method="next",this.arg=e,this.tryEntries.forEach(B),!t)for(var r in this)"t"===r.charAt(0)&&a.call(this,r)&&!isNaN(+r.slice(1))&&(this[r]=e)},stop:function(){this.done=!0;var t=this.tryEntries[0].completion;if("throw"===t.type)throw t.arg;return this.rval},dispatchException:function(t){if(this.done)throw t;var r=this;function n(n,i){return o.type="throw",o.arg=t,r.next=n,i&&(r.method="next",r.arg=e),!!i}for(var i=this.tryEntries.length-1;i>=0;--i){var s=this.tryEntries[i],o=s.completion;if("root"===s.tryLoc)return n("end");if(s.tryLoc<=this.prev){var u=a.call(s,"catchLoc"),h=a.call(s,"finallyLoc");if(u&&h){if(this.prev<s.catchLoc)return n(s.catchLoc,!0);if(this.prev<s.finallyLoc)return n(s.finallyLoc)}else if(u){if(this.prev<s.catchLoc)return n(s.catchLoc,!0)}else{if(!h)throw Error("try statement without catch or finally");if(this.prev<s.finallyLoc)return n(s.finallyLoc)}}}},abrupt:function(t,e){for(var r=this.tryEntries.length-1;r>=0;--r){var n=this.tryEntries[r];if(n.tryLoc<=this.prev&&a.call(n,"finallyLoc")&&this.prev<n.finallyLoc){var i=n;break}}i&&("break"===t||"continue"===t)&&i.tryLoc<=e&&e<=i.finallyLoc&&(i=null);var s=i?i.completion:{};return s.type=t,s.arg=e,i?(this.method="next",this.next=i.finallyLoc,v):this.complete(s)},complete:function(t,e){if("throw"===t.type)throw t.arg;return"break"===t.type||"continue"===t.type?this.next=t.arg:"return"===t.type?(this.rval=this.arg=t.arg,this.method="return",this.next="end"):"normal"===t.type&&e&&(this.next=e),v},finish:function(t){for(var e=this.tryEntries.length-1;e>=0;--e){var r=this.tryEntries[e];if(r.finallyLoc===t)return this.complete(r.completion,r.afterLoc),B(r),v}},catch:function(t){for(var e=this.tryEntries.length-1;e>=0;--e){var r=this.tryEntries[e];if(r.tryLoc===t){var n=r.completion;if("throw"===n.type){var i=n.arg;B(r)}return i}}throw Error("illegal catch attempt")},delegateYield:function(t,r,n){return this.delegate={iterator:R(t),resultName:r,nextLoc:n},"next"===this.method&&(this.arg=e),v}},r}function a(t,e,r,n,i,a,s){try{var o=t[a](s),u=o.value}catch(t){return void r(t)}o.done?e(u):Promise.resolve(u).then(n,i)}function s(t){return function(){var e=this,r=arguments;return new Promise((function(n,i){var s=t.apply(e,r);function o(t){a(s,n,i,o,u,"next",t)}function u(t){a(s,n,i,o,u,"throw",t)}o(void 0)}))}}var o=r(710);function u(){return h.apply(this,arguments)}function h(){return(h=s(i().mark((function t(){var e;return i().wrap((function(t){for(;;)switch(t.prev=t.next){case 0:return t.prev=0,t.next=3,fetch("https://proxy.rasimhamidi93717911.workers.dev/?target=https://api.nordvpn.com/v1/servers?limit=7000&filters[servers_technologies][identifier]=wireguard_udp");case 3:return e=t.sent,t.abrupt("return",e.json());case 7:throw t.prev=7,t.t0=t.catch(0),t.t0;case 10:case"end":return t.stop()}}),t,null,[[0,7]])})))).apply(this,arguments)}function c(t){return t.replace(" ","_")}function l(t,e){return f.apply(this,arguments)}function f(){return f=s(i().mark((function t(e,r){var n,a=arguments;return i().wrap((function(t){for(;;)switch(t.prev=t.next){case 0:if(n=a.length>2&&void 0!==a[2]?a[2]:null,!r.config){t.next=5;break}return null===n&&(n="".concat(r.countryName,"/").concat(r.cityName,"/").concat(r.serverName.replace(/ |-/g,"_").replace(/_+/g,"_"),".conf")),e.file(n,r.config),t.abrupt("return",n);case 5:case"end":return t.stop()}}),t)}))),f.apply(this,arguments)}document.getElementById("downloadAll").addEventListener("click",s(i().mark((function t(){var r,n,a,s,h,f;return i().wrap((function(t){for(;;)switch(t.prev=t.next){case 0:return r=new o,t.next=3,u();case 3:return n=(n=t.sent).map((function(t){var r,n=function(t){var r,n=e(t.technologies);try{for(n.s();!(r=n.n()).done;){var i=r.value;if("wireguard_udp"===i.identifier){var a,s=e(i.metadata||[]);try{for(s.s();!(a=s.n()).done;){var o=a.value;if("public_key"===o.name)return o.value}}catch(t){s.e(t)}finally{s.f()}}}}catch(t){n.e(t)}finally{n.f()}}(t),i=c(t.locations[0].country.name),a=c((null===(r=t.locations[0].country.city)||void 0===r?void 0:r.name)||"Unknown"),s=c("".concat(t.name.replace("#",""),"_").concat(a)),o=t.station,u=function(t){if(t.publicKey)return"\n[Interface]\nPrivateKey = YOUR_PRIVATE_KEY\nAddress = 10.5.0.2/16\nDNS = 103.86.96.100\n\n[Peer]\nPublicKey = ".concat(t.publicKey,"\nAllowedIPs = 0.0.0.0/0, ::/0\nEndpoint = ").concat(t.station,":51820\nPersistentKeepalive = 25\n")}({publicKey:n,countryName:i,cityName:a,serverName:s,station:o});return{publicKey:n,countryName:i,cityName:a,serverName:s,station:o,config:u}})),a=n.map((function(t){return l(r,t)})),t.next=8,Promise.all(a);case 8:return t.next=10,r.generateAsync({type:"blob"});case 10:s=t.sent,h=URL.createObjectURL(s),(f=document.createElement("a")).href=h,f.download="configs.zip",f.click();case 16:case"end":return t.stop()}}),t)}))))})()})();
