# NordVPN WireGuard Config Generator & Proxy Fetcher  

This tool makes it simple to create WireGuard configs for NordVPN and fetch proxy servers from the NordVPN API. Choose from Python, Go, Rust, Node.js, Ruby, or a web app version.  

## Features  

- Automatically picks the best servers for speed and performance.  
- Organizes servers by location (country, city).  
- Finds nearby servers for faster connections.  
- Connects to less crowded servers.  
- Fetches proxy servers with ease.  
- Simple management of configuration files.  
- Multi-language support: Python, Go, Rust, Node.js, Ruby, and web.  
- Secure key setup using `get-key.py`.  

## How to Use  

### General Steps  
1. Get your NordVPN access token.  
2. Choose a version: Python, Go, Rust, Node.js, Ruby, or Web.  
3. Follow the instructions below for your chosen version.  

### Python  
1. Clone the repo and run `main.py`.  
2. Enter your access token and follow the prompts.  
3. Use `proxy_fetcher.py` to get proxy servers.  
4. (Optional) Use `get-key.py` for secure private key setup.  

### Go (fastest mybe ?)  
1. Install Go, clone the repo, and compile or use pre-built files.
2. Run `go tidy` to organize dependencies.
3. Use `go run main.go` to execute.  

### Rust  
1. Install Rust, clone the repo, and compile or use pre-built files.  
2. Run the tool and follow the prompts.  

### Node.js  
1. Install Node.js, clone the repo, and install dependencies `npm install`.  
2. Run the tool `npm start` and follow the prompts.  

### Ruby  
1. Install Ruby, clone the repo, and install dependencies `bundle install`.  
2. Run the script `ruby main.rb` and follow the prompts.  

### Web  
1. Visit [nord-configs-crafter](https://wg-nord.pages.dev/) or the remake at [nord-configs](https://nord-configs.onrender.com/).  
2. Follow the steps to generate configs.

## Contributing  
Want to help? Open issues or submit pull requests on GitHub.  

## License  
This project uses the GNU License. See the LICENSE file for details.  

## Support  
- **Star on GitHub**: Show your support by starring this project.  
- **Subscribe to NordVPN**: Use [this referral link](https://ref.nordvpn.com/MXIVDoJGpKT) to get your NordVPN subscription. You'll receive 1-3 extra months for free, and you'll support the project at no extra cost.  

Enjoy a faster, simpler NordVPN setup with this tool!  
