<?php

namespace Chatify\Console;

use Illuminate\Console\Command;

class PublishCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'chatify:publish {--force : Overwrite any existing files}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Publish all of the chatify assets';

    /**
     * Execute the console command.
     *
     * @return void
     */
    public function handle()
    {
        if($this->option('force')){
            $this->call('vendor:publish', [
                '--tag' => 'chatify-config',
                '--force' => true,
            ]);

            $this->call('vendor:publish', [
                '--tag' => 'chatify-migrations',
                '--force' => true,
            ]);

            $this->call('vendor:publish', [
                '--tag' => 'chatify-models',
                '--force' => true,
            ]);
        }

        $this->call('vendor:publish', [
            '--tag' => 'chatify-views',
            '--force' => true,
        ]);

        $this->call('vendor:publish', [
            '--tag' => 'chatify-assets',
            '--force' => true,
        ]);
    }
}
