<a href="https://multy.dev?utm_source=github.com">
    <img src="https://multy.dev/assets/multy_logo_horizontal.jpg" width="250">
</a>

<br/>
<br/>

**Join the Multy Community! We are always looking for feedback and contributors!**

**This document is a WIP**

## Contributing

Multy is built on open-source and we are always looking for people to contribute feedback, ideas, fixes, blog posts and
more!

If you are interested in contributing to Multy, here are a few ideas:

💬 Join the discussion on our community [Discord Server](https://discord.gg/rgaKXY4tCZ)!

💡 Raise any feedback/ideas as a GitHub Issue.

⭐️ Star the repository to spread the word!

The guide will provide you with an overview on Multy projects and how to contribute!

## How to start

To get started, you should first look at the project [overview document](/.github/overview.md) that goes over the folder
structure and how the
project is laid out. For any question, you can always talk to the maintainers on
our [discord server](https://discord.gg/rgaKXY4tCZ). You can also submit an issue to discuss anything with the team!

## Submitting a pull request

PR naming convention is `TYPE: overview-of-pull-request`

When TYPE can be:

- **feat** - is a new feature
- **doc** - documentation only changes
- **fix** - a bug fix
- **refactor** - code change that neither fixes a bug nor adds a feature

For the initial start, fork the project and use git clone command to download the repository to your computer. A
standard procedure for working on an issue would be to:

1. Pull the repository to get the latest changes

```bash
$ git pull
```

2. Create new branch from `main` like: `feat-added-brazil-region`

```bash
$ git checkout -b [name_of_your_new_branch]
```

3. Work - commit - repeat

4. Push changes to GitHub

```bash
$ git push origin [name_of_your_new_branch]
```

5. Submit your changes for review
   If you go to your repository on GitHub, you'll see a `Compare & pull request` button. Click on that button.
6. Start a Pull Request

   Now submit the pull request and click on `Create pull request`.
7. Get a code review approval
8. After approval, merge your PR
9. GitHub will automatically delete the branch after the merge is done. (they can still be restored).

## Other ways to help

There are plenty of ways to support Multy that don't involve contributing code!

### Sharing the project

If you believe in the project and the problem we're trying to solve, share the message at work, meetups and the
wider community!

### Blog posts

Blog posts and shareable content are a great way to increase the reach of Multy and spread the word about what we're
trying to do! They're also a great way to promote yourself and get your name out there.

If you have any ideas or are looking for inspiration, let us know at team@multy.dev and we're happy to
assist!

### Share ideas, feedback or bugs

If you think of new potential features or spot any fixes, please let us know by raising a new issue or by sharing your
thoughts on our [discord server](https://discord.gg/rgaKXY4tCZ)

### Improve documentation

The right documentation is how new people get started with Multy and it's important for us to keep everything up to date
and cover all use cases. From spell checks to updated docs, all contributions are appreciated!
