# Contributing to fishbowlpy

We welcome contributions from everyone. By participating in this project, you agree to abide by our [Code of Conduct](https://github.com/mukulbindal/fishbowlpy/blob/main/CODEOFCONDUCT.md).

## How Can I Contribute?

### Reporting Issues

If you find any issues with the project, please report them using our issue tracker on [GitHub](https://github.com/mukulbindal/fishbowlpy/issues). Before creating a new issue, please search the existing ones to avoid duplicates.

When reporting an issue, provide as much detail as possible, including steps to reproduce the problem, expected behavior, and your operating system environment.

### Suggesting Enhancements

We appreciate your ideas for improving the project. If you have any suggestions, please create a new issue on our [issue tracker](https://github.com/mukulbindal/fishbowlpy/issues) and include a clear description of your enhancement proposal.

### Code Contributions

We encourage you to contribute to the project by submitting pull requests with bug fixes or new features. To do this, follow these steps:

1. Fork the repository and create your branch from `main`.
2. Make your changes and ensure they follow the project's coding style and conventions.
3. Write tests to cover your changes, if applicable.
4. Ensure all existing tests pass by running the test suite.
5. Make sure your code lints without any errors.
6. Commit your changes with a descriptive commit message.
7. Push your branch to your forked repository.
8. Open a pull request to the main repository's branch.

### Pull Request Guidelines

To help us review your pull request in a timely manner, please follow these guidelines:

- Provide a clear and descriptive title for your pull request.
- Include a summary of the changes made and any additional context if necessary.
- Reference any related issues or pull requests in the description.
- Ensure your code follows the project's coding style and conventions.
- Include any necessary tests with your changes.

## Code of Conduct

Please review and adhere to our [Code of Conduct](https://github.com/mukulbindal/fishbowlpy/blob/main/CODEOFCONDUCT.md) while participating in this project.

## License

By contributing to this project, you agree that your contributions will be licensed under the [Project License](https://github.com/mukulbindal/fishbowlpy/blob/main/LICENSE).

---

We appreciate your interest and support in improving this project. Thank you for your contributions!
