# Contribution guidelines

mtugnoli welcomes contributions to our open source projects on Github. Please see our [guidelines for contributing](https://github.com/esri/contributing).

We do not currently accept new PRs for full features, for example a new function or a significant change to an existing one, but we do encourage you to submit issues for:

* Bugs you find while using ZacCAD.
* Requests for new features or enhancements to existing.

## Contributing to the ZacCAD project

This guide describes how you can contribute improvements to the ZacCAD source code.

1. Make sure you have a [GitHub account](https://github.com/signup/free).
2. To add an enhancement or fix a problem, create an issue.
    * Be descriptive: Clearly describe the issue including steps to reproduce and, if possible, a sample.
    * If an enhancement, clearly describe the additional functionality and provide a good use case to support it.
3. [Fork](https://help.github.com/articles/fork-a-repo) the [ZacCAD repo](https://github.com/mtugnoli/ZacCAD/) on GitHub.
4. Clone it to your local machine.
5. Checkout the [main branch](https://github.com/mtugnoli/ZacCAD/tree/main).
6. Create a new feature branch on your local machine. The name of the branch is not important.
7. Write code to add an enhancement or fix a problem.  
    * Follow the coding conventions already used in the ZacCAD source code.
    * Document your code.
    * Make commits of logical units.  
    * Use clear and descriptive commit messages.
8. Self-review your code.
9. Test your code.

### Submitting changes

1. Push the changes in your feature branch to your repo.
2. Submit a [pull request](https://help.github.com/articles/using-pull-requests) against the "main" branch.
3. In the pull request comments, add a reference to the issue the pull request resolves. For example, if the pull request resolves issue 45, add a comment to the pull request that includes `#45`.

### Code reviews

Expect a good amount of feedback as part of any pull request.

* Pull requests will be reviewed and tested, and may be rejected for various reasons.
  * If a PR is rejected because it would cause a breaking change or includes a feature that is out of scope, it will be closed permanently.
  * If a PR is rejected because the proposed changes failed code review or testing, please review feedback, fix and reopen as necessary.  

### License

By contributing your code, you agree to license your contribution under the terms of the [MIT License](LICENSE).

Your contributions should be an original work of authorship by you, including any modifications or additions to an existing work, that is intentionally submitted for inclusion in this repo. Contributions that require an additional third-party license or have other restrictions (including, but not limited to, related patents and trademarks) will be rejected.
