[![Build status](https://ci.appveyor.com/api/projects/status/ktka9cfk1rxe2mt3?svg=true)](https://ci.appveyor.com/project/msx752/riotgamesapi)

# RiotGamesAPI
A Portable RiotGames v3 and upper API Wrapper for C#

## Documentation
- https://riotgamesapi.readme.io

## Supported Frameworks
Framework | Framework Version | Nuget | Nuget Version
--- | --- | --- | ---
[.NET Standard](https://github.com/msx752/RiotGamesAPI/tree/master/RiotGamesApi) | >=1.6 | [![nuget](https://img.shields.io/badge/Nuget-RiotGamesAPI-brightgreen.svg?style=flat&maxAge=259200)](https://www.nuget.org/packages/RiotGamesAPI) | [![NuGet](https://img.shields.io/nuget/v/RiotGamesAPI.svg)](https://www.nuget.org/packages/RiotGamesAPI)
[.Asp.NET](https://github.com/msx752/RiotGamesAPI/tree/master/RiotGamesApi) | >=4.6.2 | [![nuget](https://img.shields.io/badge/Nuget-RiotGamesAPI-brightgreen.svg?style=flat&maxAge=259200)](https://www.nuget.org/packages/RiotGamesAPI) | [![NuGet](https://img.shields.io/nuget/v/RiotGamesAPI.svg)](https://www.nuget.org/packages/RiotGamesAPI)
[.Asp.NET Core](https://github.com/msx752/RiotGamesAPI/tree/master/RiotGamesApi) | >=1.1 | [![nuget](https://img.shields.io/badge/Nuget-RiotGamesAPI-brightgreen.svg?style=flat&maxAge=259200)](https://www.nuget.org/packages/RiotGamesAPI) | [![NuGet](https://img.shields.io/nuget/v/RiotGamesAPI.svg)](https://www.nuget.org/packages/RiotGamesAPI)

## API Library Table
ApiName | Version
--- | ---
CHAMPION-MASTERY | [V3](https://github.com/msx752/RiotGamesApi/tree/master/RiotGamesApi/Libraries/Lol/v3/NonStaticEndPoints/ChampionMastery)
CHAMPION | [V3](https://github.com/msx752/RiotGamesApi/tree/master/RiotGamesApi/Libraries/Lol/v3/NonStaticEndPoints/Champion)
LEAGUE | [V3](https://github.com/msx752/RiotGamesApi/tree/master/RiotGamesApi/Libraries/Lol/v3/NonStaticEndPoints/League)
LOL-STATIC-DATA  | [V3](https://github.com/msx752/RiotGamesApi/tree/master/RiotGamesApi/Libraries/Lol/v3/StaticEndPoints)
LOL-STATUS | [V3](https://github.com/msx752/RiotGamesApi/tree/master/RiotGamesApi/Libraries/Lol/v3/StatusEndPoints)
MASTERIES | [V3](https://github.com/msx752/RiotGamesApi/tree/master/RiotGamesApi/Libraries/Lol/v3/NonStaticEndPoints/Mastery)
MATCH | [V3](https://github.com/msx752/RiotGamesApi/tree/master/RiotGamesApi/Libraries/Lol/v3/NonStaticEndPoints/Match)
RUNES | [V3](https://github.com/msx752/RiotGamesApi/tree/master/RiotGamesApi/Libraries/Lol/v3/NonStaticEndPoints/Rune)
SPECTATOR | [V3](https://github.com/msx752/RiotGamesApi/tree/master/RiotGamesApi/Libraries/Lol/v3/NonStaticEndPoints/Spectator)
SUMMONER | [V3](https://github.com/msx752/RiotGamesApi/tree/master/RiotGamesApi/Libraries/Lol/v3/NonStaticEndPoints/Summoner)
TOURNAMENT-STUB| [V3](https://github.com/msx752/RiotGamesApi/tree/master/RiotGamesApi/Libraries/Lol/v3/TournamentEndPoints)
TOURNAMENT | [V3](https://github.com/msx752/RiotGamesApi/tree/master/RiotGamesApi/Libraries/Lol/v3/TournamentEndPoints)
CHAMPION (*Test for the Feature*) | [V3.1](https://github.com/msx752/RiotGamesApi/tree/master/RiotGamesApi/Libraries/Lol/v31/NonStaticEndPoints/Champion)

GameConstants([ref.](https://developer.riotgames.com/game-constants.html)) |
--- |
[SEASONS](https://github.com/msx752/RiotGamesApi/tree/master/RiotGamesApi/Libraries/Lol/Enums/GameConstants/Season.cs) |
[MATCHMAKING QUEUES](https://github.com/msx752/RiotGamesApi/tree/master/RiotGamesApi/Libraries/Lol/Enums/GameConstants/MatchMakingQueue.cs) |
[MAP NAMES](https://github.com/msx752/RiotGamesApi/tree/master/RiotGamesApi/Libraries/Lol/Enums/GameConstants/MapName.cs) |
[GAME/MATCH MODES](https://github.com/msx752/RiotGamesApi/tree/master/RiotGamesApi/Libraries/Lol/Enums/GameConstants/GameMatchMode.cs) |
[GAME/MATCH TYPES](https://github.com/msx752/RiotGamesApi/tree/master/RiotGamesApi/Libraries/Lol/Enums/GameConstants/GameMatchType.cs) |
[SUB TYPES](https://github.com/msx752/RiotGamesApi/tree/master/RiotGamesApi/Libraries/Lol/Enums/GameConstants/SubType.cs) |
[PLAYER STAT SUMMARY TYPES](https://github.com/msx752/RiotGamesApi/tree/master/RiotGamesApi/Libraries/Lol/Enums/GameConstants/PlayerStatSummaryType.cs) |
