# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic
Versioning](https://semver.org/spec/v2.0.0.html).

## [Unreleased]

## [0.10.0] - 2019-02-21

### Added

- Ability to choose what kind of format a flowgraph is rendered to using the `--format` argument.

### Changed

- Default flowgraph format is now `svg`.

## [0.9.0] - 2019-02-15

### Added

- Flowgraphs can now be generated by using `cargo inspect
  --unpretty=flowgraph=main`. This requires `dot` to be installed on the
  machine. Thanks to @[jonathansty](/jonathansty).

## [0.8.1] - 2019-02-05

### Changed

- Remove the implicit dependency on git2 caused by prettyprint (see
  mre/prettyprint#6).  
  This fixes compilation on macOS in the case where openssl wasn't installed.
  Thanks to @[lilyball](/lilyball) for reporting.

## [0.8.0] - 2019-02-05

### Added

-   You can now choose different themes! Simply run cargo inspect --list-themes
    to get a list of available choices. For example, this will use the GitHub
    theme, which should work well on white backgrounds: cargo inspect
    examples/file.rs --theme GitHub. Thanks to @[jonathansty](/jonathansty).

### Changed

-   The output is now a bit cleaner, because formatting issues are now handled a
    little better. Even if rustfmt fails, we print the final output on a
    best-effort basis. Most of the time, this should look quite pleasing to the
    eye. If you want to see the full debug trace, you can use `RUST_LOG=debug`.
    Thanks to @[jonathansty](/jonathansty).

## [0.7.0] - 2019-02-03

- Add logging support
- Add support for diffing files (#11)

## [0.6.0] - 2019-01-29

- Print unformatted text instead of panicking on rustfmt

## [0.5.0] - 2018-12-16

- Move to Rust 2018 edition
- Add crate support
- Adds support for plaintext output.
- More examples

