import { StyleSheet } from 'react-native';

import { Fonts, Colors, Metrics } from '../../themes';

export default StyleSheet.create({
  container: {
    marginTop: Metrics.smallMargin,
    backgroundColor: Colors.transparent,
    flexDirection: 'row',
  },
  searchInput: {
    flex: 5,
    height: 30,
    alignSelf: 'center',
    padding: Metrics.smallMargin,
    textAlign: 'left',
    fontFamily: Fonts.type.base,
    fontSize: Fonts.size.instructions,
    borderRadius: 5,
    borderWidth: 1,
    borderColor: Colors.black,
    paddingLeft: 30,
    color: Colors.black,
    flexDirection: 'row',
  },
  searchIcon: {
    left: Metrics.doubleBaseMargin,
    alignSelf: 'center',
    color: Colors.black,
    backgroundColor: Colors.transparent,
  },
  cancelButton: {
    alignItems: 'center',
    justifyContent: 'center',
    marginHorizontal: Metrics.baseMargin,
  },
  buttonLabel: {
    color: Colors.black,
    fontFamily: Fonts.type.base,
    fontSize: Fonts.size.regular,
  },
});
