import React from 'react';
import { useFormikContext } from 'formik';
import { ApplicationStyles } from '../../themes';

import { Text, TouchableOpacity } from 'react-native';

export default React.forwardRef(({ title, ...otherProps }, ref) => {
  const { handleSubmit } = useFormikContext();

  return (
    <TouchableOpacity style={[ApplicationStyles.screen.button]} onPress={handleSubmit} ref={ref} {...otherProps}>
      <Text style={ApplicationStyles.screen.buttonText}>{title}</Text>
    </TouchableOpacity>
  );
});
