import React from 'react';
import { View, StyleSheet, Text, Switch } from 'react-native';

export default React.forwardRef((props, ref) => {
  const { label, labelStyle, error, ...otherProps } = props;

  return (
    <View style={styles.container}>
      {/* if there's a label, render it */}
      {label && <Text style={[styles.label, labelStyle]}>{label}</Text>}

      {/* render the switch */}
      <Switch style={[styles.input]} {...otherProps} />

      {/* if there's an error, render it */}
      {!!error && !!error.message && <Text style={styles.textError}>{error && error.message}</Text>}
    </View>
  );
});

const styles = StyleSheet.create({
  container: {
    marginVertical: 8,
  },
  input: {},
  label: {
    paddingVertical: 5,
    fontSize: 16,
    fontWeight: 'bold',
  },
});
