import * as React from 'react';
import { StyleSheet, Text, View, Button } from 'react-native';
import type { StackScreenProps } from '@react-navigation/stack';

const NotFoundScreen = ({ navigation }: StackScreenProps<{ Home: undefined }>) => {
  return (
    <View style={styles.container}>
      <Text style={styles.title}>404 Not Found</Text>
      <Button onPress={() => navigation.navigate('Home')} title={'Go to home'} />
    </View>
  );
};

export default NotFoundScreen;

const styles = StyleSheet.create({
  title: {
    fontSize: 36,
  },
  container: {
    flex: 1,
    justifyContent: 'center',
    alignItems: 'center',
    padding: 8,
  },
});
