# Installation And Usage

This chapter provides all the necessary information to obtain **mp-units** and build the user's
source code using it.


## Obtaining dependencies

This library assumes that most of the dependencies will be provided by the
[Conan Package Manager](https://conan.io/). If you want to obtain required
dependencies by other means, some modifications to the library's CMake files might be needed.


??? info "Conan quick intro"

    In case you are not familiar with Conan, to install it (or upgrade) just do:

    ```shell
    pip install -U conan
    ```

    After that, you might need to add a custom profile file for your development environment
    in _~/.conan2/profiles_ directory. An example profile can look as follows:

    ```ini hl_lines="5" title="~/.conan2/profiles/gcc12"
    [settings]
    arch=x86_64
    build_type=Release
    compiler=gcc
    compiler.cppstd=20
    compiler.libcxx=libstdc++11
    compiler.version=14
    os=Linux

    [conf]
    tools.build:compiler_executables={"c": "gcc-14", "cpp": "g++-14"}
    ```

    !!! tip "Setting the language version"

        Please note that the **mp-units** library requires at least C++20 to be set in a Conan profile
        or forced via the Conan command line. If we do the former, we will not need to provide
        `-s compiler.cppstd=20` every time we run a Conan command line (as provided in the command
        line instructions below).

    !!! tip "Using Ninja as a CMake generator for Conan"

        It is highly recommended to set Ninja as a CMake generator for Conan. To do so, we could
        create a _~/.conan2/global.conf_ file that will set `tools.cmake.cmaketoolchain:generator`
        to one of the Ninja generators. For example:

        ```text title="~/.conan2/global.conf"
        tools.cmake.cmaketoolchain:generator="Ninja Multi-Config"
        ```

    !!! tip "Separate build folders for different configurations"

        _~/.conan2/global.conf_ file may also set `tools.cmake.cmake_layout:build_folder_vars` which
        [makes working with several compilers or build configurations easier](https://docs.conan.io/2/reference/tools/cmake/cmake_layout.html#multi-setting-option-cmake-layout).
        For example, the below line will force Conan to generate separate CMake presets and folders for
        each compiler and C++ standard version:

        ```text title="~/.conan2/global.conf"
        tools.cmake.cmake_layout:build_folder_vars=["settings.compiler", "settings.compiler.version", "settings.compiler.cppstd"]
        ```

        In such a case, we will need to use a configuration-specific preset name in the Conan instructions
        provided below rather than just `conan-default` and `conan-release`
        (e.g., `conan-gcc-13-23` and `conan-gcc-13-23-release`)

??? info "CMake with presets support"

    It is recommended to use at least CMake 3.23 to build this project to benefit from CMake Presets
    generated by Conan. All build instructions below assume that you have such support. If not,
    your CMake invocations have to be replaced with something like:

    ```shell
    mkdir build && cd build
    cmake .. -G "Ninja Multi-Config" -DCMAKE_TOOLCHAIN_FILE=<path_to_generators_dir>/conan_toolchain.cmake
    cmake --build . --config Release
    ```

    !!! tip

        In case you can't use CMake 3.23 but you have access to CMake 3.20 or later, you can append
        `-c tools.cmake.cmaketoolchain.presets:max_schema_version=2` to the `conan install` command
        which will force Conan to use an older version of the CMake Presets schema.


## Build options

!!! note

    Most of the below options are related to the C++ language features available in the compilers.
    Please refer to the [C++ compiler support](cpp_compiler_support.md) chapter to learn more
    about which C++ features are required for each option and which compilers support them.

### Conan options

[`cxx_modules`](#cxx_modules){ #cxx_modules }

:   [:octicons-tag-24: 2.2.0][conan C++ modules support] · :octicons-milestone-24: `True`/`False` (Default: automatically determined from settings)

    Configures CMake to add C++ modules to the list of default targets.

    [conan C++ modules support]: https://github.com/mpusz/mp-units/releases/tag/v2.2.0

[`import_std`](#import_std){ #import_std } :test_tube:{ title="Experimental" }

:   [:octicons-tag-24: 2.3.0][conan import std support] · :octicons-milestone-24: `True`/`False` (Default: automatically determined from settings)

    Enables `import std;` usage.

    [conan import std support]: https://github.com/mpusz/mp-units/releases/tag/v2.3.0

[`std_format`](#std_format){ #std_format }

:   [:octicons-tag-24: 2.2.0][conan std::format support] · :octicons-milestone-24: `True`/`False` (Default: automatically determined from settings)

    Enables the usage of [`std::format`](https://en.cppreference.com/w/cpp/utility/format/format)
    and associated facilities for text formatting. If it is not supported, then
    the [{fmt}](https://github.com/fmtlib/fmt) library is used instead.

    [conan std::format support]: https://github.com/mpusz/mp-units/releases/tag/v2.2.0

[`no_crtp`](#no_crtp){ #no_crtp }

:   [:octicons-tag-24: 2.2.0][conan no crtp support] · :octicons-milestone-24: `True`/`False` (Default: automatically determined from settings)

    Removes the need for the usage of the CRTP idiom in the
    [`quantity_spec` definitions](../users_guide/framework_basics/systems_of_quantities.md#defining-quantities).

    [conan no crtp support]: https://github.com/mpusz/mp-units/releases/tag/v2.2.0

[`contracts`](#contracts){ #contracts }

:   [:octicons-tag-24: 2.2.0][conan contracts] · :octicons-milestone-24: `none`/`gsl-lite`/`ms-gsl` (Default: _see below_)

    Enables checking of preconditions and additional assertions in the code.

    If the automatically determined default for `import_std` is `True`, then the `contracts` option
    is set to `none` by default. `gsl-lite` otherwise.

    [conan contracts]: https://github.com/mpusz/mp-units/releases/tag/v2.2.0

[`freestanding`](#freestanding){ #freestanding }

:   [:octicons-tag-24: 2.2.0][conan freestanding] · :octicons-milestone-24: `True`/`False` (Default: `False`)

    Configures the library in the [freestanding](https://en.cppreference.com/w/cpp/freestanding)
    mode. When enabled, the library's source code will build with the compiler's
    [`-ffreestanding`](https://gcc.gnu.org/onlinedocs/gcc/C-Dialect-Options.html) compilation option
    without any issues.

    [conan freestanding]: https://github.com/mpusz/mp-units/releases/tag/v2.2.0

??? info "CMake options to set when Conan is not being used"

    ### CMake options

    Conan will automatically set all the below CMake options based on its configuration (described above).
    Manual setting of the below CMake options is only needed when Conan is not being used.

    [`MP_UNITS_BUILD_AS_SYSTEM_HEADERS`](#MP_UNITS_BUILD_AS_SYSTEM_HEADERS){ #MP_UNITS_BUILD_AS_SYSTEM_HEADERS }

    :   [:octicons-tag-24: 2.2.0][cmake as system headers support] · :octicons-milestone-24: `ON`/`OFF` (Default: `OFF`)

        Exports library as system headers.

        [cmake as system headers support]: https://github.com/mpusz/mp-units/releases/tag/v2.2.0

    [`MP_UNITS_BUILD_CXX_MODULES`](#MP_UNITS_BUILD_CXX_MODULES){ #MP_UNITS_BUILD_CXX_MODULES }

    :   [:octicons-tag-24: 2.2.0][cmake build cxx modules support] · :octicons-milestone-24: `ON`/`OFF` (Default: `OFF`)

        Adds C++ modules to the list of default targets.

        [cmake build cxx modules support]: https://github.com/mpusz/mp-units/releases/tag/v2.2.0

    [`MP_UNITS_API_STD_FORMAT`](#MP_UNITS_API_STD_FORMAT){ #MP_UNITS_API_STD_FORMAT }

    :   [:octicons-tag-24: 2.2.0][cmake std::format support] · :octicons-milestone-24: `ON`/`OFF` (Default: automatically determined)

        Enables the usage of [`std::format`](https://en.cppreference.com/w/cpp/utility/format/format)
        and associated facilities for text formatting. If it is not supported, then
        the [{fmt}](https://github.com/fmtlib/fmt) library is used instead.

        [cmake std::format support]: https://github.com/mpusz/mp-units/releases/tag/v2.2.0

    [`MP_UNITS_API_NO_CRTP`](#MP_UNITS_API_NO_CRTP){ #MP_UNITS_API_NO_CRTP }

    :   [:octicons-tag-24: 2.2.0][cmake no crtp support] · :octicons-milestone-24: `ON`/`OFF` (Default: automatically determined)

        Removes the need for the usage of the CRTP idiom in the
        [`quantity_spec` definitions](../users_guide/framework_basics/systems_of_quantities.md#defining-quantities).

        [cmake no crtp support]: https://github.com/mpusz/mp-units/releases/tag/v2.2.0

    [`MP_UNITS_API_CONTRACTS`](#MP_UNITS_API_CONTRACTS){ #MP_UNITS_API_CONTRACTS }

    :   [:octicons-tag-24: 2.2.0][cmake contracts] · :octicons-milestone-24: `NONE`/`GSL-LITE`/`MS-GSL` (Default: `GSL-LITE`)

        Enables checking of preconditions and additional asserts in the code.

        [cmake contracts]: https://github.com/mpusz/mp-units/releases/tag/v2.2.0

    [`MP_UNITS_API_FREESTANDING`](#MP_UNITS_API_FREESTANDING){ #MP_UNITS_API_FREESTANDING }

    :   [:octicons-tag-24: 2.2.0][cmake freestanding] · :octicons-milestone-24: `ON`/`OFF` (Default: `OFF`)

        Configures the library in the [freestanding](https://en.cppreference.com/w/cpp/freestanding)
        mode. When enabled, the library's source code should build with the compiler's
        [`-ffreestanding`](https://gcc.gnu.org/onlinedocs/gcc/C-Dialect-Options.html) compilation option
        without any issues.

        [cmake freestanding]: https://github.com/mpusz/mp-units/releases/tag/v2.2.0


## Installation and reuse

There are many different ways of installing/reusing **mp-units** in your project. Below we mention
only a few of many options possible.

!!! important "Important: Prefer using Conan if possible"

    The easiest and most recommended way to obtain **mp-units** is with the Conan package manager.
    See [Conan + CMake (release)](#conan-cmake-release) for a detailed instruction.

### Conan + CMake (release)

!!! tip

    If you are new to the Conan package manager you may want to read
    [Obtaining Dependencies](#obtaining-dependencies) and refer to the
    [Consuming packages](https://docs.conan.io/2/tutorial/consuming_packages.html)
    chapter of the official Conan documentation for more information.

**mp-units** releases are hosted on [Conan-Center](https://conan.io/center/recipes/mp-units).
The following steps may be performed to obtain an official library release:

1. Create Conan configuration file (either _conanfile.txt_ or _conanfile.py_) in your
   project's top-level directory and add **mp-units** as a dependency of your project.
   For example, the simplest file may look as follows:

    === "_conanfile.txt_"

        ```ini
        [requires]
        mp-units/2.4.0

        [options]
        # The below mp-units options are set to defaults by Conan.
        # Uncomment and set to an explicit value to override the defaults.
        #
        # mp-units*:cxx_modules=True
        # mp-units*:import_std=False
        # mp-units*:std_format=True
        # mp-units*:no_crtp=True
        # mp-units*:contracts=gsl-lite
        # mp-units*:freestanding=False

        [layout]
        cmake_layout

        [generators]
        CMakeToolchain
        CMakeDeps
        ```

    === "_conanfile.py_"

        ```python
        from conan import ConanFile
        from conan.tools.build import can_run
        from conan.tools.cmake import CMake, cmake_layout

        class MPUnitsTestConan(ConanFile):
            settings = "os", "arch", "compiler", "build_type"
            generators = "CMakeDeps", "CMakeToolchain"

            def requirements(self):
                self.requires(
                    "mp-units/2.4.0",
                    options={
                        # The below mp-units options are set to defaults by Conan.
                        # Uncomment and set to an explicit value to override the defaults.
                        #
                        # "cxx_modules": False,
                        # "import_std": False,
                        # "std_format": True,
                        # "no_crtp": True,
                        # "contracts": "gsl-lite",
                        # "freestanding": False,
                    },
                )

            def layout(self):
                cmake_layout(self)

            def build(self):
                cmake = CMake(self)
                cmake.configure()
                cmake.build()
                if can_run(self):
                    cmake.ctest(cli_args=["--output-on-failure"])
        ```

2. Import **mp-units** and its dependencies definitions with `find_package`:

    ```cmake
    find_package(mp-units REQUIRED)
    ```

3. Link your CMake targets with **mp-units**:

    ```cmake
    target_link_libraries(<your_target> <PUBLIC|PRIVATE|INTERFACE> mp-units::mp-units)
    ```

4. Download, build, and install Conan dependencies before running the CMake configuration step:

    === "_conanfile.txt_ or _conanfile.py_"

        ```shell
        conan install . -pr <your_conan_profile> -s compiler.cppstd=20 -b=missing
        cmake --preset conan-default
        cmake --build --preset conan-release
        cmake --build --preset conan-release --target test
        ```

    === "_conanfile.py_ only"

        ```shell
        conan build . -pr <your_conan_profile> -s compiler.cppstd=20 -b=missing
        ```

### Conan + CMake (Live At Head)

This chapter describes the procedure to Live At Head, which means using the latest stable version
of **mp-units** all the time.

!!! note

    Please note that even though the Conan packages that you will be using are generated **ONLY**
    for builds that are considered stable (passed our CI tests), some minor regressions may happen
    (CI and C++ build environments are not perfect yet). Also, please expect that the library
    interface might, and probably will, change occasionally. Even though we do our best, such
    changes might not be reflected in the project's documentation right away.

The procedure is similar to the one described in [Conan + CMake (release)](#conan-cmake-release)
with the following differences:

1. Before starting the previous procedure, add **mp-units** remote to your Conan configuration:

    ```shell
    conan remote add conan-mpusz https://mpusz.jfrog.io/artifactory/api/conan/conan-oss
    ```

2. In your Conan configuration file, provide the package identifier of the `mpusz/testing` stream:

    === "_conanfile.txt_"

        ```ini hl_lines="2"
        [requires]
        mp-units/2.5.0@mpusz/testing

        [options]
        # The below mp-units options are set to defaults by Conan.
        # Uncomment and set to an explicit value to override the defaults.
        #
        # mp-units*:cxx_modules=True
        # mp-units*:import_std=False
        # mp-units*:std_format=True
        # mp-units*:no_crtp=True
        # mp-units*:contracts=gsl-lite
        # mp-units*:freestanding=False

        [layout]
        cmake_layout

        [generators]
        CMakeToolchain
        CMakeDeps
        ```

    === "_conanfile.py_"

        ```python hl_lines="11"
        from conan import ConanFile
        from conan.tools.build import can_run
        from conan.tools.cmake import CMake, cmake_layout

        class MPUnitsTestConan(ConanFile):
            settings = "os", "arch", "compiler", "build_type"
            generators = "CMakeDeps", "CMakeToolchain"

            def requirements(self):
                self.requires(
                    "mp-units/2.5.0@mpusz/testing",
                    options={
                        # The below mp-units options are set to defaults by Conan.
                        # Uncomment and set to an explicit value to override the defaults.
                        #
                        # "cxx_modules": False,
                        # "import_std": False,
                        # "std_format": True,
                        # "no_crtp": True,
                        # "contracts": "gsl-lite",
                        # "freestanding": False,
                    },
                )

            def layout(self):
                cmake_layout(self)

            def build(self):
                cmake = CMake(self)
                cmake.configure()
                cmake.build()
                if can_run(self):
                    cmake.ctest(cli_args=["--output-on-failure"])
        ```

    !!! tip

        The identifiers of the latest packages can always be found in
        [the project's README file](https://github.com/mpusz/mp-units/blob/master/README.md) or on
        [the project's Artifactory](https://mpusz.jfrog.io/ui/packages/conan:%2F%2Fmp-units).

3. Force Conan to check for updated recipes with `-u`:

    ```shell
    conan install . -pr <your_conan_profile> -s compiler.cppstd=20 -b=missing -u
    ```

??? info "Alternative installation scenarios"

    ### Copy

    As **mp-units** is a C++ header-only library you can simply copy all needed _src/*/include_ subdirectories
    to your source tree.

    !!! note

        In such a case, you are on your own to ensure all the dependencies are installed and their header
        files can be located during the build. Please also note that some compiler-specific flags are needed
        to make the code compile without issues.


    ### Copy + CMake

    If you copy the **mp-units** library source code from **the project's _./src_ directory**
    (not the entire repo from its root), you can reuse CMake targets defined by the library.
    To do so, **you should use _CMakeLists.txt_ file from the _./src_ directory**:

    ```cmake
    add_subdirectory(<path_to_mp_units_lib_folder>)
    # ...
    target_link_libraries(<your_target> <PUBLIC|PRIVATE|INTERFACE> mp-units::mp-units)
    ```

    !!! note

        You are still on your own to make sure all the dependencies are installed and their header and CMake
        configuration files can be located during the build.

    !!! important "Important: Library users should not use the top-level CMake file"

        Top level _CMakeLists.txt_ file should only be used by **mp-units developers and contributors**
        as an entry point for the project's development.
        _./src/CMakeLists.txt_ contains only a pure library definition and **should be used by the
        customers** that prefer to use CMake's
        [`add_subdirectory()`](https://cmake.org/cmake/help/latest/command/add_subdirectory.html) to
        handle the dependencies.

        To learn more about the rationale, please check our
        [FAQ](faq.md#why-dont-we-have-cmake-options-to-disable-the-building-of-tests-and-examples).


    ### Install

    If you don't want to use Conan in your project and just want to install the **mp-units**
    library on your file system, and use `find_package(mp-units)` from another repository to find it;
    it is enough to perform the following steps:

    ```shell
    conan install . -pr <your_conan_profile> -s compiler.cppstd=20 -b=missing
    mv CMakeUserPresets.json src
    cd src
    cmake --preset conan-default -DCMAKE_INSTALL_PREFIX=<your_installation_path>
    cmake --build --preset conan-release --target install
    ```
