# Amazing Web Development Resources and More! 💻

[![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome) 

The ultimate repository full of resources to learn about web development, design, git, and more!

This repository started as an extension guide for web development resources that Kode With Klossy Web Dev students can refer to as a way to further expand their webdev abilities after the camp. However, I've expanded this doc for anyone willing to learn webdev here, not just those in Kode With Klossy. The list will be updated throughout time and feel free to look around or make a pull request here!

Happy Learning!

 
## Contents
- [Learning Web Development](#webdevelopment)

- [Designs](#designs)

- [Site Templates](#templates)

- [Prototyping](#prototyping)

- [Github](#github)

- [IDEs](#IDEs)

- [Blogs](#blogs)

- [Challenges](#Challenges)

- [Additional Resources](#additionalresources)

:memo: [**Contributing**](#memo-contributing)

---- 
## WebDevelopment
 ### Best Sites for Learning ANYTHING Web Development Related
 * [W3Schools](https://www.w3schools.com/)
 * [FreeCodeCamp](https://www.freecodecamp.org/)
 * [Codecademy](https://www.codecademy.com/catalog/subject/web-development)
 * [Educative](https://www.educative.io/learn)
 * [Django Tutorial](https://tutorial.djangogirls.org/en/)
 * [ReactJS](https://reactjs.org/tutorial/tutorial.html)
    * [Setting Up React](https://www.codecademy.com/articles/how-to-create-a-react-app)
    * [More React](https://reactjs.org/docs/create-a-new-react-app.html)
    * [Practicing React.js alongside s'more resources](https://github.com/hack4impact-uiuc/react-exercise)
    * [Mini Web Dev Bootcamp](https://www.notion.so/Curriculum-ca431096426b4fd1968ac49121ff2fdb)
 * [Mozilla](https://developer.mozilla.org/en-US/docs/Learn)
 * [LearnJS](https://github.com/CodeNerve/LearnJavaScript)
 * [Techntonica Curriculum](https://github.com/Techtonica/curriculum)
 * [Harvard CS50 Web Programming](https://cs50.harvard.edu/web/2020/)

 ## Designs
 * [Google Fonts](https://fonts.google.com/)
 * [HTML ColorCode](https://htmlcolorcodes.com/)
 * [Font Awesome](https://fontawesome.com/v4.7.0/icons/)
 * [unDraw](https://undraw.co/)
 * [emojipedia](https://emojipedia.org/)
 * [Dribble](https://dribbble.com/?fbclid=IwAR3c_YUBr-wLjHWvIQcARBeM7UG2ZYd02_I8U4zy2oUSUWkTtFIivoxqHxA)
 * [CSS Animated & Gradient Background](https://uigradients.com/#SandtoBlue)
 * [Bootstrap](https://getbootstrap.com/)

 ## Templates
 * [HTML5UP](https://html5up.net/)
 * [JSON Resume](https://jsonresume.org/getting-started/)
 * [urspace](https://urspace.io/) customized templates
 * [Terminal-like Portfolio](https://github.com/CodeNerve/CodeNerve.github.io)
 * [Some more templates](https://html.com/resources/free-html-templates/)
 * [w3 Schools Bootstrap Theme](https://www.w3schools.com/bootstrap4/bootstrap_templates.asp) Bootstrap is a front-end framework that allows your site to be more responsive across all devices!

 ## Prototyping
 * [Proto.io](https://proto.io/) - keep in mind you only have a 14 day free trial
 * [Figma](https://www.figma.com/blog/)
 * [Bubble.io](https://bubble.io/) Easy and free tool to create mockups
 * [Check this Medium blog out](https://medium.com/@denisz.design/the-9-best-go-to-prototyping-tools-for-designers-in-2019-296b341a51a2)

 ## Github
* [Github Guides](https://guides.github.com/activities/hello-world/)
* [Introduction to Github](https://lab.github.com/githubtraining/introduction-to-github)
* [More GitHub Courses](https://lab.github.com/)
* [Practicing How to Use Git](https://github.com/benthayer/git-gud)
* [Gitbook](https://www.gitbook.com/)
* [Importance of Having a good READ.ME](https://github.com/noffle/art-of-readme?fbclid=IwAR3sFPA8KV71i2YCESls4fCqIxvTzbB0eiJGEAiDMUgs1rfZ0Rv1YN0KsOY) - very useful to include for your final project!
* [Why you need a clear README if you want a "coding" job](https://www.reddit.com/r/cscareerquestions/comments/h17blk/always_write_a_clear_readme_if_you_want_to_find_a/) 
* [Github Student Developer Pack](https://education.github.com/pack)
* [Showcase Portfolio through Github Pages](https://github.dev/)
* [FORK this repo](https://github.com/dipakkr/A-to-Z-Resources-for-Students)

 ## IDEs
* [Repl.it](https://repl.it/)
* [Code Pen](https://codepen.io/)
* [Glitch](https://glitch.com/)
* [Atom](https://atom.io/)
* [VSCode](https://code.visualstudio.com/)

## Blogs
### 📰 BLOGS TO CHECK OUT 
* [freeCodeCamp](https://www.freecodecamp.org/news/)
* [CodePath](https://blog.codepath.org/)
* [Tech Together](https://medium.com/techtogether)
* [Better Programming](https://medium.com/better-programming)

## Challenges
### Doing challenges are a great way to expand your skill set and to create projects! Here are some challenges to look at below
* [7 Days, 7 Websites](https://www.freecodecamp.org/news/the-7days7websites-coding-challenge/)
* [#100DaysOfCode](https://www.100daysofcode.com/)
* [Contributing to Open Source Projects](https://github.com/freeCodeCamp/how-to-contribute-to-open-source)
* [List of Hackathons](https://mlh.io/seasons/na-2020/events)
* [JS Challenges] (https://jsbeginners.com/javascript-projects-for-beginners/#list)

## Additional Resources
* [Ways to get involved with Women in Tech!](https://github.com/nishapant/Women-in-Tech-Resources)
* [Impactful](https://weareimpactful.org/?fbclid=IwAR1w5zp9XhK1jcCj0DVCttMCtOMOZt7AAQaf6x3nZJvBU76MuwN2OROM7a4#home)
* [Adding Google Analytics to Website](https://www.pair.com/support/kb/how-to-google-analytics-to-an-html-website/)
* [How to make a Chrome Extension](https://developer.chrome.com/extensions/getstarted) 
* [Contributing to Open Source](https://opensource.guide/how-to-contribute/)
* [Missing Semester of your CS Education](https://missing.csail.mit.edu/)
* [Developer Roadmaps](https://roadmap.sh/guides)
* [Github Student Pack](https://education.github.com/pack)
## :memo: Contributing
 See [contributing.md](contributing.md)



