<?php
/**
 * ------------------------ 
 *  版权所有  www.tecmz.com
 *  商业版本请购买正版授权使用
 * ------------------------
*/ namespace ModStart\Form; use Closure; use Illuminate\Contracts\Support\Renderable; use Illuminate\Database\Eloquent\Model; use Illuminate\Support\Collection; use Illuminate\Support\Facades\Input; use Illuminate\Support\Str; use Illuminate\Validation\Validator; use ModStart\Core\Dao\DynamicModel; use ModStart\Core\Exception\BizException; use ModStart\Core\Exception\ResultException; use ModStart\Core\Input\InputPackage; use ModStart\Core\Input\Response; use ModStart\Core\Type\SortDirection; use ModStart\Core\Util\CRUDUtil; use ModStart\Core\Util\IdUtil; use ModStart\Core\Util\SerializeUtil; use ModStart\Detail\Detail; use ModStart\Field\AbstractField; use ModStart\Field\AutoRenderedFieldValue; use ModStart\Field\Display; use ModStart\Field\Select; use ModStart\Field\Type\FieldRenderMode; use ModStart\Form\Concern\HasCascadeFields; use ModStart\Form\Type\FormEngine; use ModStart\Form\Type\FormMode; use ModStart\Grid\Concerns\HasSort; use ModStart\Repository\Filter\HasRepositoryFilter; use ModStart\Repository\Filter\HasScopeFilter; use ModStart\Repository\Repository; use ModStart\Repository\RepositoryUtil; use ModStart\Support\Concern\HasBuilder; use ModStart\Support\Concern\HasFields; use ModStart\Support\Concern\HasFluentAttribute; use ModStart\Support\Manager\FieldManager; use stdClass; class Form implements Renderable { use HasFields, HasBuilder, HasFluentAttribute, HasSort, HasCascadeFields, HasScopeFilter, HasRepositoryFilter; public $id; private $repository; private $view = 'modstart::core.form.index'; protected $fluentAttributes = array('engine', 'builder', 'mode', 'title', 'showSubmit', 'showReset', 'itemId', 'item', 'hookSubmitted', 'hookSaving', 'hookSaved', 'hookDeleting', 'hookDeleted', 'hookChanged', 'dataSubmitted', 'dataForming', 'dataAdding', 'dataEditing', 'canAdd', 'canEdit', 'canDelete', 'canSort', 'canCopy', 'sortAddPosition', 'formClass', 'treeMaxLevel', 'treeRootPid', 'formUrl', 'ajax', 'formAttr'); private $engine = 'basic'; private $mode = 'form'; private $title; private $showSubmit = true; private $showReset = true; private $itemId = null; private $item; private $hookSubmitted; private $hookSaving; private $hookSaved; private $hookDeleting; private $hookDeleted; private $hookChanged; private $dataSubmitted; private $dataForming; private $dataAdding; private $dataEditing; private $canAdd = true; private $canEdit = true; private $canDelete = true; private $canSort = false; private $canCopy = false; private $sortAddPosition = false; private $formClass = ''; private $treeMaxLevel = 99; private $treeRootPid = 0; private $formUrl = null; private $ajax = true; private $formAttr = ''; public function __construct($WmFTo, \Closure $Ph3uP = null) { goto RkSPb; E78xi: $this->builder($Ph3uP); goto VkrTE; JhdYv: $this->repository = Repository::instance($WmFTo); goto a0g9e; a0g9e: $this->setupFields(); goto Ebege; Ebege: $this->fieldDefaultRenderMode(FieldRenderMode::FORM); goto U_SIp; RkSPb: $this->id = IdUtil::generate('Grid'); goto JhdYv; U_SIp: $this->setupRepositoryFilter(); goto E78xi; VkrTE: } public static function make($IotVp = null, \Closure $Ph3uP = null) { if (is_object($IotVp) || class_exists($IotVp) && is_subclass_of($IotVp, Model::class)) { return new Form($IotVp, $Ph3uP); } return new Form(DynamicModel::make($IotVp), $Ph3uP); } public function asTree($p5nRv = 'id', $Wq1Em = 'pid', $FPzse = 'sort', $PEQTP = 'title') { goto JPwCD; F3hZo: $this->repository->setSortColumn($FPzse); goto wD2BX; KNox2: return $this; goto MEY6e; wD2BX: $this->repository->setTreeTitleColumn($PEQTP); goto PbOvS; uYrXr: $this->repository->setTreePidColumn($Wq1Em); goto F3hZo; JPwCD: $this->repository->setKeyName($p5nRv); goto uYrXr; PbOvS: $this->engine = FormEngine::TREE; goto vfC3G; vfC3G: $this->canSort(true); goto KNox2; MEY6e: } public function asTreeMass($P05Ny = 0, $p5nRv = 'id', $Wq1Em = 'pid', $FPzse = 'sort', $PEQTP = 'title') { goto R66E2; R66E2: $this->repository->setKeyName($p5nRv); goto rxvVS; dEJ4w: $this->canSort(true); goto kpK4E; e1wXF: $this->engine = FormEngine::TREE_MASS; goto dEJ4w; TJYLy: $this->repository->setSortColumn($FPzse); goto pf5NJ; pf5NJ: $this->repository->setTreeTitleColumn($PEQTP); goto e1wXF; kpK4E: return $this; goto WUFZ2; rxvVS: $this->repository->setTreePidColumn($Wq1Em); goto TJYLy; WUFZ2: } private function build() { $this->runBuilder(); if ($this->engine == FormEngine::TREE) { if ($this->treeMaxLevel > 1) { $Y5tRr = FieldManager::make($this, 'select', $this->repository->getTreePidColumn(), L('Parent')); $Y5tRr->optionRepositoryTreeItems($this->repository, $this->treeMaxLevel); } else { $Y5tRr = FieldManager::make($this, 'hidden', $this->repository->getTreePidColumn(), L('Parent')); $Y5tRr->value(0); } $this->prependField($Y5tRr); } else { if ($this->engine == FormEngine::TREE_MASS) { goto AiUy0; AiUy0: $Y5tRr = FieldManager::make($this, 'display', $this->repository->getTreePidColumn(), L('Parent')); goto CFRNP; CFRNP: $Y5tRr->addable(true)->editable(true)->listable(false); goto uL_eL; uL_eL: $Y5tRr->hookRendering(function (AbstractField $Y5tRr, $DdLHQ, $YcjXW) { if (empty($DdLHQ)) { $u_gXa = InputPackage::buildFromInput()->get('_pid', $this->treeRootPid); } else { $u_gXa = $DdLHQ->{$this->repository->getTreePidColumn()}; } $this->repository()->setArgument('treePid', $u_gXa); $BHo28 = $this->repository->getTreeAncestorItems(); $qkW4k = array(); $qkW4k[] = '<span class="ub-text-muted"><i class="icon iconfont icon-angle-right"></i></span> ' . L('Root'); foreach ($BHo28 as $QXEuq) { $qkW4k[] = '<span class="ub-text-muted"><i class="icon iconfont icon-angle-right"></i></span> ' . htmlspecialchars($QXEuq->{$this->repository->getTreeTitleColumn()}); } $qkW4k[] = '<input type="hidden" name="' . $this->repository->getTreePidColumn() . '" value="' . htmlspecialchars($u_gXa) . '" />'; return AutoRenderedFieldValue::make(join('', $qkW4k)); }); goto sbwYz; sbwYz: $this->prependField($Y5tRr); goto BIQvp; BIQvp: } } } public function repository() { return $this->repository; } private function fieldValidateMessages($rhCB3, $GSxEZ) { goto V2iLI; ZnscO: foreach ($R4B5m as $idDPK) { foreach ($idDPK->messages()->getMessages() as $cT3tC => $b2W8a) { $gjFUR[$cT3tC] = $b2W8a; } } goto ckjSZ; sFLbL: return $gjFUR; goto DepKG; ckjSZ: if (empty($gjFUR)) { return false; } goto sFLbL; szZ_P: $gjFUR = array(); goto ZnscO; V2iLI: $R4B5m = array(); goto WO899; WO899: foreach ($rhCB3 as $Y5tRr) { if (!($idDPK = $Y5tRr->getValidator($GSxEZ))) { continue; } if ($idDPK instanceof Validator) { try { if (!$idDPK->passes()) { $R4B5m[] = $idDPK; } } catch (\Exception $uQzst) { BizException::throws('Form.fieldValidateMessages.Error - ' . SerializeUtil::jsonEncode($idDPK->getRules())); } } } goto szZ_P; DepKG: } private function convertBizExceptionToResponse($ZgNDw) { goto LM82n; mrrNP: $Sxb6H = array(array('FieldTooLong:', 'Field %s Too Long'), array('FieldFormatError:', 'Field %s Format Error')); goto Xa8yI; LM82n: $Z0L2s = $ZgNDw->getMessage(); goto mrrNP; Xa8yI: foreach ($Sxb6H as $LSvaV) { if (Str::startsWith($Z0L2s, $LSvaV[0])) { goto NGIgQ; r96lg: $Y5tRr = $this->getFieldByColumn($eCtl0); goto fPEMc; fPEMc: if ($Y5tRr) { return Response::jsonError(L($LSvaV[1], $Y5tRr->label())); } goto LS2c2; NGIgQ: list($s4Dxh, $eCtl0) = explode(':', $Z0L2s); goto r96lg; LS2c2: } } goto GpfPe; GpfPe: return Response::jsonError($Z0L2s); goto daNin; daNin: } private function validateFields($rhCB3, $bpsWZ) { goto O53Uh; O53Uh: $SOIX3 = array(); goto P1jlM; P1jlM: if ($n6vG_ = $this->fieldValidateMessages($rhCB3, $bpsWZ)) { $SOIX3 = array_merge($SOIX3, $n6vG_); } goto lB1dO; QzvBz: return Response::generateSuccess(); goto ktWlc; lB1dO: foreach ($SOIX3 as $cT3tC => $gjFUR) { foreach ($gjFUR as $M1ZjS) { return Response::generateError($M1ZjS); } } goto QzvBz; ktWlc: } private function removeReservedFields() { goto aR7_6; UnDj0: $this->fields = $this->fields()->reject($jok0I); goto eGwDV; lYt9U: $jok0I = function (AbstractField $Y5tRr) use(&$B0cFC) { return in_array($Y5tRr->column(), $B0cFC, true) && $Y5tRr instanceof \ModStart\Field\Display; }; goto UnDj0; aR7_6: $B0cFC = array($this->repository->getKeyName(), $this->repository->getCreatedAtColumn(), $this->repository->getUpdatedAtColumn()); goto lYt9U; eGwDV: } public function hookCall($Zum0Z) { if ($Zum0Z instanceof Closure) { $HWCH3 = call_user_func($Zum0Z, $this); if (null !== $HWCH3) { return $HWCH3; } } return Response::generateSuccess(); } public function isModeForm() { return $this->mode === FormMode::FORM; } public function isModeAdd() { return $this->mode === FormMode::ADD; } public function isModeEdit() { return $this->mode === FormMode::EDIT; } public function isModeDelete() { return $this->mode === FormMode::DELETE; } public function formRequest($Zum0Z, array $bpsWZ = null) { goto jqAX_; E7f0J: try { goto sJ9_X; yONgf: ResultException::throwsIfFail($this->hookCall($this->hookSubmitted)); goto KGGJJ; X0Url: $this->removeReservedFields(); goto unaEg; k2jrT: $HWCH3 = call_user_func($Zum0Z, $this); goto zejKZ; unaEg: foreach ($this->addableFields() as $Y5tRr) { goto pXK0x; EXU4A: $dw4kO = isset($this->dataSubmitted[$Y5tRr->column()]) ? $this->dataSubmitted[$Y5tRr->column()] : null; goto Yy3xP; uJT09: $dw4kO = $Y5tRr->serializeValue($dw4kO, $Y5tRr); goto Jkxtt; Jkxtt: if ($Y5tRr->hookValueSerialize()) { $dw4kO = call_user_func($Y5tRr->hookValueSerialize(), $dw4kO, $Y5tRr); } goto r1Lg5; pXK0x: if ($Y5tRr->isLayoutField()) { continue; } goto EXU4A; r1Lg5: $this->dataForming[$Y5tRr->column()] = $dw4kO; goto JER1o; Yy3xP: $dw4kO = $Y5tRr->prepareInput($dw4kO, $this->dataSubmitted); goto uJT09; JER1o: } goto L95n5; oYFP6: if (null !== $HWCH3) { return Response::jsonFromGenerate($HWCH3); } goto pjIrX; pjIrX: if (!empty($this->dataSubmitted['_redirect'])) { return Response::json(0, null, null, $this->dataSubmitted['_redirect']); } goto wZtkg; zejKZ: if (null !== $HWCH3) { if (Response::isError($HWCH3)) { return Response::jsonFromGenerate($HWCH3); } } goto NXVwC; sJ9_X: ResultException::throwsIfFail($this->validateFields($this->addableFields(), $this->dataSubmitted)); goto yONgf; wZtkg: return Response::jsonSuccess(L('Save Success')); goto cRh4U; NXVwC: ResultException::throwsIfFail($this->hookCall($this->hookSaved)); goto oGIzG; oGIzG: ResultException::throwsIfFail($this->hookCall($this->hookChanged)); goto oYFP6; KGGJJ: $this->dataForming = array(); goto X0Url; L95n5: ResultException::throwsIfFail($this->hookCall($this->hookSaving)); goto k2jrT; cRh4U: } catch (BizException $uQzst) { return Response::jsonError($uQzst->getMessage()); } catch (ResultException $uQzst) { return Response::jsonError($uQzst->getMessage()); } goto Q_ppw; VVLwO: $this->build(); goto g7AKJ; jqAX_: $this->mode(FormMode::FORM); goto VVLwO; g7AKJ: $this->dataSubmitted = $bpsWZ ? $bpsWZ : Input::all(); goto E7f0J; Q_ppw: } public function add() { goto kyLlC; mwy6g: $this->build(); goto Ofwyl; qzMmC: if ($this->canCopy()) { $LsXJx = CRUDUtil::copyId(); if ($LsXJx) { goto LnHzl; LnHzl: $this->itemId($LsXJx); goto VCvcu; JWTIL: $this->itemId(0); goto k0vXL; k0vXL: $fmaPd = true; goto G_kw3; VCvcu: $this->item($this->repository()->editing($this)); goto JWTIL; G_kw3: } } goto mwy6g; Ofwyl: if ($fmaPd) { $this->fillFields(); } goto EUVrt; EUVrt: return $this; goto Kosxv; kyLlC: $this->mode(FormMode::ADD); goto mMANf; mMANf: $fmaPd = false; goto qzMmC; Kosxv: } public function addRequest(array $bpsWZ = null) { goto SGRU0; zSz4s: $this->mode(FormMode::ADD); goto kGF8o; SGRU0: if (!$this->canAdd) { return Response::pagePermissionDenied(); } goto zSz4s; cctaz: try { goto r12D2; yngdK: $this->dataAdding = array(); goto q00GY; LBE38: foreach ($this->addableFields() as $Y5tRr) { if ($Y5tRr->hookValueSaved()) { call_user_func($Y5tRr->hookValueSaved(), $t2PJW, $Y5tRr); } } goto hyQdM; q00GY: $this->removeReservedFields(); goto XHUqG; OCy6g: ResultException::throwsIfFail($this->hookCall($this->hookSubmitted)); goto yngdK; r12D2: ResultException::throwsIfFail($this->validateFields($this->addableFields(), $this->dataSubmitted)); goto OCy6g; hyQdM: if (!empty($this->dataSubmitted['_redirect'])) { return Response::json(0, null, null, $this->dataSubmitted['_redirect']); } goto qt1C3; qt1C3: return Response::jsonSuccess(L('Add Success')); goto wai5q; XHUqG: foreach ($this->addableFields() as $Y5tRr) { goto h0EMp; RRMG5: $dw4kO = $Y5tRr->serializeValue($dw4kO, $Y5tRr); goto ykqjJ; h0EMp: if ($Y5tRr->isLayoutField() || $Y5tRr->isCustomField()) { continue; } goto T3R4a; iDOYq: $dw4kO = $Y5tRr->prepareInput($dw4kO, $this->dataSubmitted); goto RRMG5; ykqjJ: if ($Y5tRr->hookValueSerialize()) { $dw4kO = call_user_func($Y5tRr->hookValueSerialize(), $dw4kO, $Y5tRr); } goto JXMxo; T3R4a: $dw4kO = isset($this->dataSubmitted[$Y5tRr->column()]) ? $this->dataSubmitted[$Y5tRr->column()] : null; goto iDOYq; JXMxo: $this->dataAdding[$Y5tRr->column()] = $dw4kO; goto la02Q; la02Q: } goto Rpg2t; Rpg2t: $t2PJW = $this->repository->add($this); goto LBE38; wai5q: } catch (BizException $uQzst) { return $this->convertBizExceptionToResponse($uQzst); } catch (ResultException $uQzst) { return Response::jsonError($uQzst->getMessage()); } goto x6tO8; kGF8o: $this->build(); goto sxxlX; sxxlX: $this->dataSubmitted = $bpsWZ ? $bpsWZ : Input::all(); goto cctaz; x6tO8: } public function edit($t2PJW) { try { goto PPbkc; zVj32: BizException::throwsIfEmpty(L('Record Not Exists'), $this->item); goto jt6bO; J5_4H: $this->fillFields(); goto fxWIa; SPw5Z: $this->itemId($t2PJW); goto zBH1I; fxWIa: return $this; goto gfX5g; zBH1I: $this->item($this->repository()->editing($this)); goto zVj32; PPbkc: $this->mode(FormMode::EDIT); goto SPw5Z; jt6bO: $this->build(); goto J5_4H; gfX5g: } catch (BizException $uQzst) { return Response::sendError($uQzst->getMessage()); } } public function editRequest($t2PJW, array $bpsWZ = null) { goto TzpLf; taLjm: $this->dataSubmitted = $bpsWZ ? $bpsWZ : Input::all(); goto Q5W71; Q5W71: try { goto i7EsD; i7EsD: $this->edit($t2PJW); goto mvSTM; kAvQM: ResultException::throwsIfFail($this->hookCall($this->hookSubmitted)); goto sWXvF; CLnrg: $CuLom = isset($this->dataSubmitted['_action']) ? $this->dataSubmitted['_action'] : null; goto YrNna; XDVnl: $this->removeReservedFields(); goto CLnrg; sWXvF: $this->dataEditing = array(); goto XDVnl; MHLSK: if ('itemCellEdit' == $CuLom) { foreach ($this->editableFields() as $Y5tRr) { if ($Y5tRr->column() == $cT3tC && $Y5tRr->hookValueSaved()) { call_user_func($Y5tRr->hookValueSaved(), $this->itemId(), $Y5tRr); } } } else { foreach ($this->editableFields() as $Y5tRr) { if ($Y5tRr->hookValueSaved()) { call_user_func($Y5tRr->hookValueSaved(), $this->itemId(), $Y5tRr); } } } goto VaAgL; mvSTM: ResultException::throwsIfFail($this->validateFields($this->editableFields(), $this->dataSubmitted)); goto kAvQM; VaAgL: if (!empty($this->dataSubmitted['_redirect'])) { return Response::json(0, null, null, $this->dataSubmitted['_redirect']); } goto dV3S6; YrNna: if ('itemCellEdit' == $CuLom) { goto xwQrg; NElJ8: $dw4kO = isset($this->dataSubmitted['value']) ? $this->dataSubmitted['value'] : null; goto Gz8yo; xwQrg: $cT3tC = isset($this->dataSubmitted['column']) ? $this->dataSubmitted['column'] : null; goto NElJ8; Gz8yo: if ($cT3tC) { foreach ($this->editableFields() as $Y5tRr) { if ($Y5tRr->isLayoutField() || $Y5tRr->isCustomField()) { continue; } if ($Y5tRr->column() == $cT3tC) { goto mvXXQ; MLnW3: $this->dataEditing[$Y5tRr->column()] = $dw4kO; goto CuaVF; Uk1XK: $dw4kO = $Y5tRr->serializeValue($dw4kO, $Y5tRr); goto Qtfqp; Qtfqp: if ($Y5tRr->hookValueSerialize()) { $dw4kO = call_user_func($Y5tRr->hookValueSerialize(), $dw4kO, $Y5tRr); } goto MLnW3; mvXXQ: $dw4kO = $Y5tRr->prepareInput($dw4kO, $this->dataSubmitted); goto Uk1XK; CuaVF: break; goto bvz_9; bvz_9: } } } goto wURv_; wURv_: BizException::throwsIfEmpty('Data Error', $this->dataEditing); goto rgGj0; rgGj0: } else { foreach ($this->editableFields() as $Y5tRr) { goto lwrUb; yQfUx: $dw4kO = $Y5tRr->serializeValue($dw4kO, $Y5tRr); goto WMWhM; W5Tms: $this->dataEditing[$Y5tRr->column()] = $dw4kO; goto lBaNP; lwrUb: if ($Y5tRr->isLayoutField() || $Y5tRr->isCustomField()) { continue; } goto U2Xmz; Ji_Nw: $dw4kO = $Y5tRr->prepareInput($dw4kO, $this->dataSubmitted); goto yQfUx; WMWhM: if ($Y5tRr->hookValueSerialize()) { $dw4kO = call_user_func($Y5tRr->hookValueSerialize(), $dw4kO, $Y5tRr); } goto W5Tms; U2Xmz: $dw4kO = isset($this->dataSubmitted[$Y5tRr->column()]) ? $this->dataSubmitted[$Y5tRr->column()] : null; goto Ji_Nw; lBaNP: } } goto ylyST; ylyST: $this->repository()->edit($this); goto MHLSK; dV3S6: return Response::jsonSuccess(L('Edit Success')); goto bFZKe; bFZKe: } catch (BizException $uQzst) { return $this->convertBizExceptionToResponse($uQzst); } catch (ResultException $uQzst) { return Response::jsonError($uQzst->getMessage()); } goto LVnLK; TzpLf: if (!$this->canEdit) { return Response::pagePermissionDenied(); } goto taLjm; LVnLK: } public function deleteRequest($A8RPX) { goto oTxnE; qq3mk: try { goto XidRI; R14ny: $vxypk = $this->repository->delete($this, $bpsWZ); goto H849B; T1vvq: $this->item($bpsWZ); goto voU4m; XidRI: $bpsWZ = $this->repository->deleting($this); goto T1vvq; H849B: return Response::jsonSuccess(L('Delete Success')); goto sE01e; voU4m: $this->itemId(collect($bpsWZ)->map(function ($QwggW) { return $QwggW->{$this->repository()->getKeyName()}; })->toArray()); goto R14ny; sE01e: } catch (BizException $uQzst) { return Response::jsonError($uQzst->getMessage()); } catch (ResultException $uQzst) { return Response::jsonError($uQzst->getMessage()); } goto F8B7z; oTxnE: if (!$this->canDelete) { return Response::pagePermissionDenied(); } goto c_107; c_107: $this->mode(FormMode::DELETE); goto y_NDo; y_NDo: $this->itemId($A8RPX); goto PL2FR; PL2FR: $this->build(); goto qq3mk; F8B7z: } public function sortRequest($A8RPX) { goto KHMwl; XYav8: $this->mode(FormMode::SORT); goto Vbenu; ITVwt: try { goto oZnr2; oZnr2: $vxypk = $this->repository->sortEdit($this); goto sGC8A; MpuiD: return Response::jsonSuccess(L('Operate Success')); goto Vnf4c; sGC8A: ResultException::throwsIfFail($this->hookCall($this->hookChanged)); goto MpuiD; Vnf4c: } catch (BizException $uQzst) { return Response::jsonError($uQzst->getMessage()); } catch (ResultException $uQzst) { return Response::jsonError($uQzst->getMessage()); } goto UePxA; TF_DJ: $GSxEZ = InputPackage::buildFromInput(); goto HWG66; TXQxZ: $this->build(); goto ITVwt; KHMwl: if (!$this->canSort) { return Response::pagePermissionDenied(); } goto XYav8; HWG66: $this->repository->setArgument('direction', $GSxEZ->getType('direction', SortDirection::class)); goto TXQxZ; Vbenu: $this->itemId($A8RPX); goto TF_DJ; UePxA: } public function render() { goto l07mP; zyW8B: return view($this->view, $bpsWZ)->render(); goto Fu3Go; NOKn1: switch ($this->mode) { case FormMode::FORM: $bpsWZ['fields'] = $this->addableFields(true); break; case FormMode::ADD: goto Kw7fs; lcBuO: break; goto Gxje8; o2nsL: $bpsWZ['fields'] = $this->addableFields(true); goto lcBuO; Kw7fs: if (!$this->canAdd) { return Response::pagePermissionDenied(); } goto o2nsL; Gxje8: case FormMode::EDIT: goto cd1Nx; wcf_a: $bpsWZ['fields'] = $this->editableFields(true); goto xfAfx; cd1Nx: if (!$this->canEdit) { return Response::pagePermissionDenied(); } goto wcf_a; xfAfx: break; goto ufuCo; ufuCo: default: return Response::sendError('Form.render mode error : ' . $this->mode); } goto JERTJ; JERTJ: $bpsWZ = array_merge($this->fluentAttributeVariables(), $bpsWZ); goto zyW8B; l07mP: $bpsWZ = array(); goto NOKn1; Fu3Go: } public function __call($ZAyOp, $sZqsv) { goto iB0mF; iB0mF: switch ($ZAyOp) { case 'enablePagination': case 'defaultOrder': case 'canShow': case 'canExport': case 'canImport': case 'canBatchDelete': case 'canMultiSelectItem': case 'addBlankPage': case 'editBlankPage': case 'disableCUD': case 'hookItemOperateRendering': case 'addDialogSize': case 'editDialogSize': case 'dialogSizeSmall': case 'gridFilter': case 'gridOperateAppend': case 'bodyAppend': case 'operateFixed': case 'defaultPageSize': case 'pageSizes': case 'canBatchSelect': case 'batchOperatePrepend': case 'gridToolbar': case 'pageJumpEnable': case 'textEdit': case 'gridTableTopView': case 'gridBeforeRequestScriptView': case 'gridRequestScript': return $this; } goto X1GqP; X1GqP: if ($this->isFluentAttribute($ZAyOp)) { switch ($ZAyOp) { case 'item': if (isset($sZqsv[0]) && is_array($sZqsv[0])) { $sZqsv[0] = RepositoryUtil::itemFromArray($sZqsv[0]); } break; } return $this->fluentAttribute($ZAyOp, $sZqsv); } goto nLDaM; nLDaM: return FieldManager::call($this, $ZAyOp, $sZqsv); goto un3BT; un3BT: } public function __toString() { try { return $this->render(); } catch (\Exception $uQzst) { return $uQzst->getMessage(); } } }