<?php
/**
 * ------------------------ 
 *  版权所有  www.tecmz.com
 *  商业版本请购买正版授权使用
 * ------------------------
*/ namespace Illuminate\Database\Schema\Grammars; use Illuminate\Support\Fluent; use Illuminate\Database\Connection; use Illuminate\Database\Schema\Blueprint; class MySqlGrammar extends Grammar { protected $modifiers = array('Unsigned', 'Charset', 'Collate', 'Nullable', 'Default', 'Increment', 'Comment', 'After', 'First'); protected $serials = array('bigInteger', 'integer', 'mediumInteger', 'smallInteger', 'tinyInteger'); public function compileTableExists() { return 'select * from information_schema.tables where table_schema = ? and table_name = ?'; } public function compileColumnExists() { return 'select column_name as `column_name` from information_schema.columns where table_schema = ? and table_name = ?'; } public function compileCreate(Blueprint $SZKAL, Fluent $hbvee, Connection $YUYmc) { goto F0Oqp; q6FT1: $lnMWR = $this->compileCreateEncoding($lnMWR, $YUYmc, $SZKAL); goto mDEIW; YIqmR: return $lnMWR; goto lHT6o; U22ec: $lnMWR .= ' table ' . $this->wrapTable($SZKAL) . " ({$sPsSx})"; goto q6FT1; PdGXr: $lnMWR = $SZKAL->temporary ? 'create temporary' : 'create'; goto U22ec; F0Oqp: $sPsSx = implode(', ', $this->getColumns($SZKAL)); goto PdGXr; mDEIW: if (isset($SZKAL->engine)) { $lnMWR .= ' engine = ' . $SZKAL->engine; } goto YIqmR; lHT6o: } protected function compileCreateEncoding($lnMWR, Connection $YUYmc, Blueprint $SZKAL) { goto hTqMx; O0Iyr: if (isset($SZKAL->collation)) { $lnMWR .= ' collate ' . $SZKAL->collation; } elseif (!is_null($Jkrle = $YUYmc->getConfig('collation'))) { $lnMWR .= ' collate ' . $Jkrle; } goto K3Hfe; K3Hfe: return $lnMWR; goto vXs_g; hTqMx: if (isset($SZKAL->charset)) { $lnMWR .= ' default character set ' . $SZKAL->charset; } elseif (!is_null($oLcud = $YUYmc->getConfig('charset'))) { $lnMWR .= ' default character set ' . $oLcud; } goto O0Iyr; vXs_g: } public function compileAdd(Blueprint $SZKAL, Fluent $hbvee) { goto COi8o; COi8o: $MZe70 = $this->wrapTable($SZKAL); goto Rrrpy; X42VX: return 'alter table ' . $MZe70 . ' ' . implode(', ', $sPsSx); goto K9DCe; Rrrpy: $sPsSx = $this->prefixArray('add', $this->getColumns($SZKAL)); goto X42VX; K9DCe: } public function compilePrimary(Blueprint $SZKAL, Fluent $hbvee) { $hbvee->name(null); return $this->compileKey($SZKAL, $hbvee, 'primary key'); } public function compileUnique(Blueprint $SZKAL, Fluent $hbvee) { return $this->compileKey($SZKAL, $hbvee, 'unique'); } public function compileIndex(Blueprint $SZKAL, Fluent $hbvee) { return $this->compileKey($SZKAL, $hbvee, 'index'); } protected function compileKey(Blueprint $SZKAL, Fluent $hbvee, $xz4ns) { goto mMER0; fy2mV: $MZe70 = $this->wrapTable($SZKAL); goto QEKai; QEKai: return "alter table {$MZe70} add {$xz4ns} `{$hbvee->index}`({$sPsSx})"; goto mN7vP; mMER0: $sPsSx = $this->columnize($hbvee->columns); goto fy2mV; mN7vP: } public function compileDrop(Blueprint $SZKAL, Fluent $hbvee) { return 'drop table ' . $this->wrapTable($SZKAL); } public function compileDropIfExists(Blueprint $SZKAL, Fluent $hbvee) { return 'drop table if exists ' . $this->wrapTable($SZKAL); } public function compileDropColumn(Blueprint $SZKAL, Fluent $hbvee) { goto NglOU; hrEa5: return 'alter table ' . $MZe70 . ' ' . implode(', ', $sPsSx); goto NLdzJ; NglOU: $sPsSx = $this->prefixArray('drop', $this->wrapArray($hbvee->columns)); goto QDw7T; QDw7T: $MZe70 = $this->wrapTable($SZKAL); goto hrEa5; NLdzJ: } public function compileDropPrimary(Blueprint $SZKAL, Fluent $hbvee) { return 'alter table ' . $this->wrapTable($SZKAL) . ' drop primary key'; } public function compileDropUnique(Blueprint $SZKAL, Fluent $hbvee) { $MZe70 = $this->wrapTable($SZKAL); return "alter table {$MZe70} drop index `{$hbvee->index}`"; } public function compileDropIndex(Blueprint $SZKAL, Fluent $hbvee) { $MZe70 = $this->wrapTable($SZKAL); return "alter table {$MZe70} drop index `{$hbvee->index}`"; } public function compileDropForeign(Blueprint $SZKAL, Fluent $hbvee) { $MZe70 = $this->wrapTable($SZKAL); return "alter table {$MZe70} drop foreign key `{$hbvee->index}`"; } public function compileRename(Blueprint $SZKAL, Fluent $hbvee) { $sWbGp = $this->wrapTable($SZKAL); return "rename table {$sWbGp} to " . $this->wrapTable($hbvee->to); } protected function typeChar(Fluent $cT3tC) { return "char({$cT3tC->length})"; } protected function typeString(Fluent $cT3tC) { return "varchar({$cT3tC->length})"; } protected function typeText(Fluent $cT3tC) { return 'text'; } protected function typeMediumText(Fluent $cT3tC) { return 'mediumtext'; } protected function typeLongText(Fluent $cT3tC) { return 'longtext'; } protected function typeBigInteger(Fluent $cT3tC) { return 'bigint'; } protected function typeInteger(Fluent $cT3tC) { return 'int'; } protected function typeMediumInteger(Fluent $cT3tC) { return 'mediumint'; } protected function typeTinyInteger(Fluent $cT3tC) { return 'tinyint'; } protected function typeSmallInteger(Fluent $cT3tC) { return 'smallint'; } protected function typeFloat(Fluent $cT3tC) { return $this->typeDouble($cT3tC); } protected function typeDouble(Fluent $cT3tC) { if ($cT3tC->total && $cT3tC->places) { return "double({$cT3tC->total}, {$cT3tC->places})"; } return 'double'; } protected function typeDecimal(Fluent $cT3tC) { return "decimal({$cT3tC->total}, {$cT3tC->places})"; } protected function typeBoolean(Fluent $cT3tC) { return 'tinyint(1)'; } protected function typeEnum(Fluent $cT3tC) { return 'enum(\'' . implode('\', \'', $cT3tC->allowed) . '\')'; } protected function typeJson(Fluent $cT3tC) { return 'text'; } protected function typeJsonb(Fluent $cT3tC) { return 'text'; } protected function typeDate(Fluent $cT3tC) { return 'date'; } protected function typeDateTime(Fluent $cT3tC) { return 'datetime'; } protected function typeDateTimeTz(Fluent $cT3tC) { return 'datetime'; } protected function typeTime(Fluent $cT3tC) { return 'time'; } protected function typeTimeTz(Fluent $cT3tC) { return 'time'; } protected function typeTimestamp(Fluent $cT3tC) { goto reVx7; reVx7: if ($cT3tC->useCurrent) { return 'timestamp default CURRENT_TIMESTAMP'; } goto E_Gz4; E_Gz4: if (!$cT3tC->nullable && $cT3tC->default === null) { return 'timestamp default 0'; } goto oE6Ta; oE6Ta: return 'timestamp'; goto UHUYT; UHUYT: } protected function typeTimestampTz(Fluent $cT3tC) { goto E4d4s; RgDz5: if (!$cT3tC->nullable && $cT3tC->default === null) { return 'timestamp default 0'; } goto IaJYJ; E4d4s: if ($cT3tC->useCurrent) { return 'timestamp default CURRENT_TIMESTAMP'; } goto RgDz5; IaJYJ: return 'timestamp'; goto IzaZS; IzaZS: } protected function typeBinary(Fluent $cT3tC) { return 'blob'; } protected function typeUuid(Fluent $cT3tC) { return 'char(36)'; } protected function modifyUnsigned(Blueprint $SZKAL, Fluent $cT3tC) { if ($cT3tC->unsigned) { return ' unsigned'; } } protected function modifyCharset(Blueprint $SZKAL, Fluent $cT3tC) { if (!is_null($cT3tC->charset)) { return ' character set ' . $cT3tC->charset; } } protected function modifyCollate(Blueprint $SZKAL, Fluent $cT3tC) { if (!is_null($cT3tC->collation)) { return ' collate ' . $cT3tC->collation; } } protected function modifyNullable(Blueprint $SZKAL, Fluent $cT3tC) { return $cT3tC->nullable ? ' null' : ' not null'; } protected function modifyDefault(Blueprint $SZKAL, Fluent $cT3tC) { if (!is_null($cT3tC->default)) { return ' default ' . $this->getDefaultValue($cT3tC->default); } } protected function modifyIncrement(Blueprint $SZKAL, Fluent $cT3tC) { if (in_array($cT3tC->type, $this->serials) && $cT3tC->autoIncrement) { return ' auto_increment primary key'; } } protected function modifyFirst(Blueprint $SZKAL, Fluent $cT3tC) { if (!is_null($cT3tC->first)) { return ' first'; } } protected function modifyAfter(Blueprint $SZKAL, Fluent $cT3tC) { if (!is_null($cT3tC->after)) { return ' after ' . $this->wrap($cT3tC->after); } } protected function modifyComment(Blueprint $SZKAL, Fluent $cT3tC) { if (!is_null($cT3tC->comment)) { return ' comment "' . $cT3tC->comment . '"'; } } protected function wrapValue($dw4kO) { if ($dw4kO === '*') { return $dw4kO; } return '`' . str_replace('`', '``', $dw4kO) . '`'; } }