<?php
/**
 * ------------------------ 
 *  版权所有  www.tecmz.com
 *  商业版本请购买正版授权使用
 * ------------------------
*/ namespace Module\Member\Util; use Carbon\Carbon; use Illuminate\Support\Facades\Cache; use Illuminate\Support\Str; use Intervention\Image\Facades\Image; use ModStart\Core\Assets\AssetsUtil; use ModStart\Core\Dao\ModelUtil; use ModStart\Core\Exception\BizException; use ModStart\Core\Input\Request; use ModStart\Core\Input\Response; use ModStart\Core\Util\AgentUtil; use ModStart\Core\Util\ArrayUtil; use ModStart\Core\Util\EncodeUtil; use ModStart\Core\Util\FormatUtil; use ModStart\Core\Util\LockUtil; use ModStart\Core\Util\RandomUtil; use ModStart\Core\Util\StrUtil; use ModStart\Data\DataManager; use ModStart\Data\Event\DataFileUploadedEvent; use Module\Member\Events\MemberUserLoginAttemptEvent; use Module\Member\Events\MemberUserLoginFailedEvent; use Module\Member\Type\MemberMessageStatus; use Module\Member\Type\MemberStatus; use Module\Vendor\Type\DeviceType; class MemberUtil { public static function total() { return Cache::remember('MemberUserTotal', 60, function () { return ModelUtil::count('member_user'); }); } public static function get($Ch1Xd) { return ModelUtil::get('member_user', array('id' => $Ch1Xd)); } public static function getCached($Ch1Xd) { return Cache::remember('MemberUser:' . $Ch1Xd, 60, function () use($Ch1Xd) { return self::get($Ch1Xd); }); } public static function processDefault(&$Bc59j) { goto cBr17; xeev_: if (empty($Bc59j['nickname'])) { $Bc59j['nickname'] = $Bc59j['username']; } goto uItF5; Wwv2q: if (empty($Bc59j['avatarMedium'])) { $Bc59j['avatarMedium'] = AssetsUtil::fixFull('asset/image/avatar.svg', false); } goto OfQ3M; OfQ3M: if (empty($Bc59j['avatarBig'])) { $Bc59j['avatarBig'] = AssetsUtil::fixFull('asset/image/avatar.svg', false); } goto HyJHq; cBr17: if (empty($Bc59j)) { return; } goto xeev_; uItF5: if (empty($Bc59j['avatar'])) { $Bc59j['avatar'] = AssetsUtil::fixFull('asset/image/avatar.svg', false); } goto Wwv2q; HyJHq: } private static function processBasicFields($Anylp) { goto vgiGs; vgiGs: $lHm6W = array('id', 'username', 'avatar', 'created_at', 'signature', 'nickname'); goto yDLUD; yDLUD: if (null === $Anylp) { $Anylp = $lHm6W; } else { goto Fc6tC; ru_oj: foreach ($Anylp as $mUe4B) { if ('<basic>' == $mUe4B) { $AR1ee = array_merge($AR1ee, $lHm6W); } else { $AR1ee[] = $mUe4B; } } goto gI7cp; gI7cp: $Anylp = $AR1ee; goto amZUK; Fc6tC: $AR1ee = array(); goto ru_oj; amZUK: } goto XOT5V; XOT5V: return $Anylp; goto RaofC; RaofC: } public static function fixAvatar($jerzV) { return AssetsUtil::fixFullOrDefault($jerzV, 'asset/image/avatar.svg'); } public static function getBasic($Ch1Xd, $Anylp = null) { goto FkQhr; vOpEV: foreach ($Anylp as $wpB0h) { if (isset($ssG_v[$wpB0h])) { $Hz6MR[$wpB0h] = $ssG_v[$wpB0h]; } else { $Hz6MR[$wpB0h] = null; } } goto vAnBg; Ia5KO: if (empty($ssG_v)) { return null; } goto dshXG; dshXG: if (empty($ssG_v['nickname'])) { $ssG_v['nickname'] = $ssG_v['username']; } goto AxDQM; xjVcN: $Hz6MR = array(); goto vOpEV; AxDQM: $ssG_v['avatar'] = self::fixAvatar($ssG_v['avatar']); goto xjVcN; bW7G1: $ssG_v = self::get($Ch1Xd); goto Ia5KO; vAnBg: return $Hz6MR; goto fOFoP; FkQhr: $Anylp = self::processBasicFields($Anylp); goto bW7G1; fOFoP: } public static function listViewName($X3w8E) { goto ukiWq; G0dhD: return $Pv3g_; goto TV1xL; ukiWq: $Pv3g_ = array(); goto vqCip; vqCip: $MsAxI = ModelUtil::allIn('member_user', 'id', $X3w8E); goto U088i; U088i: foreach ($MsAxI as $Bc59j) { $Pv3g_[] = self::viewName($Bc59j); } goto G0dhD; TV1xL: } public static function listUsers($X3w8E) { return ModelUtil::allIn('member_user', 'id', $X3w8E); } public static function convertOneToBasic($Bc59j) { return array('id' => $Bc59j['id'], 'username' => $Bc59j['username'], 'nickname' => empty($Bc59j['nickname']) ? $Bc59j['username'] : $Bc59j['nickname'], 'created_at' => $Bc59j['created_at'], 'signature' => isset($Bc59j['signature']) ? $Bc59j['signature'] : null, 'avatar' => AssetsUtil::fixFullOrDefault($Bc59j['avatar'], 'asset/image/avatar.svg')); } public static function convertToBasic($MsAxI) { return array_map(function ($ssG_v) { return array('id' => $ssG_v['id'], 'username' => $ssG_v['username'], 'nickname' => empty($ssG_v['nickname']) ? $ssG_v['username'] : $ssG_v['nickname'], 'created_at' => $ssG_v['created_at'], 'signature' => isset($ssG_v['signature']) ? $ssG_v['signature'] : null, 'avatar' => AssetsUtil::fixFullOrDefault($ssG_v['avatar'], 'asset/image/avatar.svg')); }, $MsAxI); } public static function listUsersBasic($X3w8E) { return self::convertToBasic(self::listUsers($X3w8E)); } public static function getViewName($Ch1Xd) { return self::viewName(self::get($Ch1Xd)); } public static function viewName($Bc59j) { goto MkarQ; DJm3J: if (!empty($Bc59j['nickname'])) { return $Bc59j['nickname']; } goto pyNCs; OZn1b: if (empty($Bc59j)) { return '-'; } goto DJm3J; pyNCs: if (!empty($Bc59j['username'])) { return $Bc59j['username']; } goto ouqHk; MkarQ: if ($Bc59j && is_numeric($Bc59j)) { return self::getViewName($Bc59j); } goto OZn1b; ouqHk: return "ID-{$Bc59j['id']}"; goto zM3HU; zM3HU: } public static function update($Ch1Xd, $xoPiT) { return ModelUtil::update('member_user', array('id' => $Ch1Xd), $xoPiT); } public static function updateBasicWithUniqueCheck($Ch1Xd, $xoPiT) { goto vkNeq; vkNeq: if (empty($xoPiT)) { return Response::generate(0, 'ok'); } goto iOm_b; AMcKt: self::update($Ch1Xd, $xoPiT); goto xgAmc; xgAmc: return Response::generate(0, 'ok'); goto jMiXj; iOm_b: foreach (array('username' => '用户名', 'phone' => '手机', 'email' => '邮箱') as $hZjv3 => $MXz6z) { if (isset($xoPiT[$hZjv3])) { goto nkxrJ; nkxrJ: if (empty($xoPiT[$hZjv3])) { $xoPiT[$hZjv3] = null; continue; } goto Nr2xp; Nr2xp: $H4mfB = ModelUtil::all('member_user', array($hZjv3 => $xoPiT[$hZjv3])); goto lUy7M; vfdsQ: if (count($H4mfB) == 1) { if ($H4mfB[0]['id'] != $Ch1Xd) { return Response::generate(-1, $MXz6z . '重复'); } } goto gT9h3; lUy7M: if (count($H4mfB) > 1) { return Response::generate(-1, $MXz6z . '重复'); } goto vfdsQ; gT9h3: } } goto AMcKt; jMiXj: } public static function login($AvQzw = '', $gZcuD = '', $iNP5R = '', $k_rau = '') { goto R2IKM; FnqJ4: MemberUserLoginAttemptEvent::fire($Bc59j['id'], Request::ip(), AgentUtil::getUserAgent()); goto dAcgu; YasGM: if (!($iNP5R || $gZcuD || $AvQzw)) { return Response::generate(-1, '所有登录字段均为空'); } goto oiKpk; RoI7P: $gZcuD = trim($gZcuD); goto JHU0P; Lntt2: if ($iNP5R) { if (!FormatUtil::isEmail($iNP5R)) { return Response::generate(-3, '邮箱格式不正确'); } $th30Q = array('email' => $iNP5R); } else { if ($gZcuD) { if (!preg_match('/(^1[0-9]{10}$)/', $gZcuD)) { return Response::generate(-4, '手机格式不正确'); } $th30Q = array('phone' => $gZcuD); } else { if ($AvQzw) { if (strpos($AvQzw, '@') !== false) { return Response::generate(-5, '用户名格式不正确'); } $th30Q = array('username' => $AvQzw); } } } goto GN41W; oiKpk: if (!$k_rau) { return Response::generate(-2, '密码为空'); } goto Lntt2; bLiyU: switch ($Bc59j['status']) { case MemberStatus::FORBIDDEN: return Response::generateError(-8, '登录失败:当前用户已被禁用'); } goto m0u_S; dAcgu: if ($Bc59j['password'] != EncodeUtil::md5WithSalt($k_rau, $Bc59j['passwordSalt'])) { MemberUserLoginFailedEvent::fire($Bc59j['id'], $Bc59j['username'], Request::ip(), AgentUtil::getUserAgent()); return Response::generate(-7, '登录失败:用户名或密码错误'); } goto bLiyU; JHU0P: $AvQzw = trim($AvQzw); goto YasGM; R2IKM: $iNP5R = trim($iNP5R); goto RoI7P; m0u_S: return Response::generateSuccessData($Bc59j); goto uueJ2; GN41W: $Bc59j = ModelUtil::get('member_user', $th30Q); goto hA7zg; hA7zg: if (empty($Bc59j)) { return Response::generate(-6, '登录失败:用户名或密码错误'); } goto FnqJ4; uueJ2: } public static function autoSetUsernameNickname($PJ6BT, $BITNi) { goto MaBrA; jr0tq: if (preg_match('/\\{.*\\}/', $BITNi)) { goto EF1R2; IgUVV: $BITNi = str_replace(array_keys($c6JwK), array_values($c6JwK), $BITNi); goto gVuUJ; EF1R2: $Bc59j = self::get($PJ6BT); goto zVOew; zVOew: $c6JwK = array('{Phone}' => $Bc59j['phone'], '{Phone4}' => substr($Bc59j['phone'], 7), '{Uid}' => $Bc59j['id']); goto IgUVV; gVuUJ: $rBtDU = 0; goto lVlik; lVlik: } goto eEWav; MaBrA: $rBtDU = 6; goto jr0tq; eEWav: self::suggestUsernameNickname($PJ6BT, $BITNi, $rBtDU); goto geToC; geToC: } public static function getSuggestUsernameNickname($lWLsX) { goto IXRZh; J_Q76: return $BITNi . Str::random(10); goto Frcpp; Xat_q: for ($CyUOi = 0; $CyUOi < 20; $CyUOi++) { $Bx9cC = ModelUtil::model('member_user')->where(array('username' => $BITNi))->orWhere(array('nickname' => $BITNi))->first(); if (empty($Bx9cC)) { return $BITNi; } $BITNi = $BITNi . Str::random(1); } goto J_Q76; IXRZh: $BITNi = $lWLsX . Str::random(1); goto Xat_q; Frcpp: } private static function suggestUsernameNickname($PJ6BT, $DjI5I = '用户', $rBtDU = 6) { goto PCncA; nP2bh: for ($CyUOi = 0; $CyUOi < 20; $CyUOi++) { $Bx9cC = ModelUtil::model('member_user')->where(array('username' => $BITNi))->orWhere(array('nickname' => $BITNi))->first(); if (empty($Bx9cC)) { break; } $BITNi = $BITNi . Str::random(1); } goto Jv9Tg; Jv9Tg: ModelUtil::update('member_user', $PJ6BT, array('username' => $BITNi, 'nickname' => $BITNi)); goto KfWpI; PCncA: if ($rBtDU > 0) { $BITNi = $DjI5I . RandomUtil::string($rBtDU); } else { $BITNi = $DjI5I; } goto nP2bh; KfWpI: } public static function registerId($Ch1Xd, $xoPiT = array()) { $Bc59j = ModelUtil::insert('member_user', array_merge(array('id' => $Ch1Xd, 'status' => MemberStatus::NORMAL, 'vipId' => MemberVipUtil::defaultVipId(), 'groupId' => MemberGroupUtil::defaultGroupId(), 'isDeleted' => false), $xoPiT)); return Response::generate(0, 'ok', $Bc59j); } public static function registerUsername($AvQzw) { return self::register($AvQzw, '', '', '', true); } public static function registerUsernameQuick($AvQzw) { goto VKt8F; feIk3: return Response::generateError('注册失败'); goto qz7AX; GUwRB: for ($CyUOi = 0; $CyUOi < 10; $CyUOi++) { $fsZ7S = self::register($KkOji, '', '', '', true); if ($fsZ7S['code']) { $KkOji = $KkOji . Str::random(1); } else { return $fsZ7S; } } goto feIk3; VKt8F: $KkOji = $AvQzw; goto GUwRB; qz7AX: } public static function register($AvQzw = '', $gZcuD = '', $iNP5R = '', $k_rau = '', $MpTcX = false) { goto IqcWq; Sl68O: $AvQzw = trim($AvQzw); goto K3CZV; JLJ4O: if ($AvQzw) { goto c3mwi; C8NsG: if (Str::contains($AvQzw, '@')) { return Response::generate(-1, '用户名不能包含特殊字符'); } goto l_boY; sT8Pi: if ($fsZ7S['code']) { return $fsZ7S; } goto E9TNQ; c3mwi: $fsZ7S = self::uniqueCheck('username', $AvQzw); goto sT8Pi; E9TNQ: if (strlen($AvQzw) < modstart_config('Member_UsernameMinLength', 3)) { return Response::generate(-1, '用户名至少3个字符'); } goto C8NsG; l_boY: if (preg_match('/^[0-9]{11}$/', $AvQzw)) { return Response::generate(-1, '用户名不能为纯数字'); } goto gSPFb; gSPFb: } else { $AvQzw = null; } goto AVG0m; AVG0m: if (!$MpTcX) { if (empty($k_rau) || strlen($k_rau) < 6) { return Response::generate(-3, '密码不合法'); } } goto EZUf7; EZUf7: $g2Tui = Str::random(16); goto GETrW; ukGRV: if ($gZcuD) { $fsZ7S = self::uniqueCheck('phone', $gZcuD); if ($fsZ7S['code']) { return $fsZ7S; } } else { $gZcuD = null; } goto JLJ4O; Yi2sZ: return Response::generate(0, 'ok', $Bc59j); goto JoDHS; GETrW: $Bc59j = ModelUtil::insert('member_user', array('status' => MemberStatus::NORMAL, 'username' => $AvQzw, 'email' => $iNP5R, 'phone' => $gZcuD, 'password' => $MpTcX ? null : EncodeUtil::md5WithSalt($k_rau, $g2Tui), 'passwordSalt' => $MpTcX ? null : $g2Tui, 'vipId' => MemberVipUtil::defaultVipId(), 'groupId' => MemberGroupUtil::defaultGroupId(), 'isDeleted' => false)); goto Yi2sZ; ATVoF: if ($iNP5R) { $fsZ7S = self::uniqueCheck('email', $iNP5R); if ($fsZ7S['code']) { return $fsZ7S; } } else { $iNP5R = null; } goto ukGRV; IqcWq: $iNP5R = trim($iNP5R); goto a8nBH; a8nBH: $gZcuD = trim($gZcuD); goto Sl68O; K3CZV: if (!($iNP5R || $gZcuD || $AvQzw)) { return Response::generate(-1, '所有注册字段均为空'); } goto ATVoF; JoDHS: } public static function uniqueCheck($yMhiX, $nFwIG, $eH7c1 = 0) { goto Hwsc4; Hwsc4: $nFwIG = trim($nFwIG); goto pbUIA; gB3HN: return Response::generate(-2, $tduMA[$yMhiX] . '已经被占用'); goto zknjR; N0bd8: if (empty($Bc59j)) { return Response::generate(0, 'ok'); } goto Z18lM; E9L2b: $Bc59j = ModelUtil::get('member_user', array($yMhiX => $nFwIG)); goto N0bd8; pbUIA: switch ($yMhiX) { case 'email': if (!FormatUtil::isEmail($nFwIG)) { return Response::generate(-1, '邮箱格式不正确'); } break; case 'phone': if (!preg_match('/(^1[0-9]{10}$)/', $nFwIG)) { return Response::generate(-1, '手机格式不正确'); } break; case 'username': if (strpos($nFwIG, '@') !== false) { return Response::generate(-1, '用户名格式不正确'); } break; case 'nickname': break; default: return Response::generate(-1, '未能识别的类型' . $yMhiX); } goto E9L2b; Z18lM: $tduMA = array('username' => '用户名', 'email' => '邮箱', 'phone' => '手机号'); goto NCrF0; NCrF0: if ($eH7c1 == $Bc59j['id']) { return Response::generate(0, 'ok'); } goto gB3HN; zknjR: } public static function getByUsername($AvQzw) { return ModelUtil::get('member_user', array('username' => $AvQzw)); } public static function getByEmail($iNP5R) { return ModelUtil::get('member_user', array('email' => $iNP5R)); } public static function getByPhone($gZcuD) { return ModelUtil::get('member_user', array('phone' => $gZcuD)); } public static function changeNickname($PJ6BT, $wakTG) { goto UiPzf; ch7QH: return Response::generate(0, 'ok'); goto RS5zl; iweT7: if (Response::isError($fsZ7S)) { return $fsZ7S; } goto vZn3H; vZn3H: ModelUtil::update('member_user', $PJ6BT, array('nickname' => $wakTG)); goto ch7QH; UiPzf: $fsZ7S = self::uniqueCheck('nickname', $wakTG, $PJ6BT); goto iweT7; RS5zl: } public static function changePassword($PJ6BT, $aZfn2, $aZ72P = null, $Y8oTF = false) { goto DB1sc; sypR1: if (empty($Bc59j)) { return Response::generate(-1, '用户不存在'); } goto vzwkp; DB1sc: if (!$Y8oTF && empty($aZ72P)) { return Response::generate(-1, '旧密码不能为空'); } goto hJ2ii; bTi2c: ModelUtil::update('member_user', array('id' => $Bc59j['id']), array('passwordSalt' => $g2Tui, 'password' => EncodeUtil::md5WithSalt($aZfn2, $g2Tui))); goto tdX8u; cGqLX: $g2Tui = Str::random(16); goto bTi2c; hkJau: if (!$Y8oTF && EncodeUtil::md5WithSalt($aZ72P, $Bc59j['passwordSalt']) != $Bc59j['password']) { return Response::generate(-1, '旧密码不正确'); } goto cGqLX; hJ2ii: $Bc59j = ModelUtil::get('member_user', array('id' => $PJ6BT)); goto sypR1; vzwkp: if (empty($aZfn2)) { return Response::generate(-1, '新密码为空'); } goto hkJau; tdX8u: return Response::generate(0, 'ok'); goto cFU_C; cFU_C: } public static function setAvatar($hRBVT, $iyfqe, $JCEKM = 'jpg') { goto YBmx9; Obvuw: $fsZ7S = DataManager::upload('image', 'U_' . $hRBVT . '_Avatar.' . $JCEKM, $KqiAf, null, $P85Ib); goto VTqB2; MBvGh: self::update($Bc59j['id'], array('avatarBig' => $VzIPc['data']['fullPath'], 'avatarMedium' => $cbYzk['data']['fullPath'], 'avatar' => $fsZ7S['data']['fullPath'])); goto cfAw8; wk1yr: $cbYzk = DataManager::upload('image', 'U' . $hRBVT . '_AvatarMiddle.' . $JCEKM, $S5KiG, null, $P85Ib); goto GxCAm; cfAw8: return Response::generateSuccess(); goto JWoIg; msNSq: if ($VzIPc['code']) { return Response::generate(-1, '头像存储失败（' . $VzIPc['msg'] . '）'); } goto wk1yr; GxCAm: if ($cbYzk['code']) { DataManager::deleteById($VzIPc['data']['id']); if ($VzIPc['code']) { return Response::generate(-1, '头像存储失败（' . $cbYzk['msg'] . '）'); } } goto Obvuw; pz2Cq: if (empty($iyfqe)) { return Response::generate(-1, '图片数据为空'); } goto ifQ9V; ifQ9V: $ptSUM = (string) Image::make($iyfqe)->resize(400, 400)->encode($JCEKM, 75); goto wMpRf; wMpRf: $S5KiG = (string) Image::make($iyfqe)->resize(200, 200)->encode($JCEKM, 75); goto gFrZj; gFrZj: $KqiAf = (string) Image::make($iyfqe)->resize(50, 50)->encode($JCEKM, 75); goto ZwumU; cS3Ny: $Bc59j = self::get($hRBVT); goto X1Tx_; bdSqy: $VzIPc = DataManager::upload('image', 'U' . $hRBVT . '_AvatarBig.' . $JCEKM, $ptSUM, null, $P85Ib); goto msNSq; X1Tx_: if (empty($Bc59j)) { return Response::generate(-1, '用户不存在'); } goto pz2Cq; VTqB2: if ($fsZ7S['code']) { goto WyIwH; tzSk6: DataManager::deleteById($cbYzk['data']['id']); goto UTRz0; UTRz0: if ($VzIPc['code']) { return Response::generate(-1, '头像存储失败（' . $fsZ7S['msg'] . '）'); } goto Dbygj; WyIwH: DataManager::deleteById($VzIPc['data']['id']); goto tzSk6; Dbygj: } goto MBvGh; YBmx9: if (!in_array($JCEKM, array('jpg', 'jpeg', 'png', 'gif'))) { return Response::generate(-1, '图片格式不正确'); } goto cS3Ny; ZwumU: $P85Ib = array('eventOpt' => array(DataFileUploadedEvent::OPT_IMAGE_COMPRESS_IGNORE => true, DataFileUploadedEvent::OPT_IMAGE_WATERMARK_IGNORE => true)); goto bdSqy; JWoIg: } public static function findUsers($eBa96) { goto sVzdn; c47tx: $ZbJoA = array(); goto MYNco; g24Hu: foreach ($MsAxI as &$qez7R) { $ZbJoA[$qez7R->id] = $qez7R->toArray(); } goto bTAfI; bTAfI: return $ZbJoA; goto f53XX; sVzdn: if (empty($eBa96)) { return array(); } goto c47tx; MYNco: $MsAxI = ModelUtil::model('member_user')->whereIn('id', $eBa96)->get(); goto g24Hu; f53XX: } public static function filterUserIds($eBa96) { goto cVFwN; v4ncv: $c6JwK = array(); goto dj12F; dj12F: $MsAxI = ModelUtil::model('member_user')->whereIn('id', $eBa96)->get(array('id')); goto M_0N5; cVFwN: if (empty($eBa96)) { return array(); } goto v4ncv; M_0N5: foreach ($MsAxI as &$qez7R) { $c6JwK[$qez7R->id] = true; } goto qdZrL; qdZrL: return array_keys($c6JwK); goto yvVl2; yvVl2: } public static function mergeMemberUsers(&$I0Ndf, $brHln = 'memberUserId', $RlSN_ = '_memberUser') { ModelUtil::join($I0Ndf, $brHln, $RlSN_, 'member_user', 'id'); } public static function mergeMemberUserBasics(&$I0Ndf, $brHln = 'memberUserId', $RlSN_ = '_memberUser', $Anylp = null) { $Anylp = self::processBasicFields($Anylp); if (is_array($I0Ndf)) { ModelUtil::join($I0Ndf, $brHln, $RlSN_, 'member_user', 'id'); foreach ($I0Ndf as $mUe4B => $m1E3O) { goto BXaiz; ljl8I: $Bc59j = ArrayUtil::keepKeys($m1E3O[$RlSN_], $Anylp); goto JssVw; L4qQ_: if (empty($Bc59j['avatar'])) { $Bc59j['avatar'] = AssetsUtil::fixFull('asset/image/avatar.svg'); } else { $Bc59j['avatar'] = AssetsUtil::fixFull($Bc59j['avatar']); } goto DB_9k; BXaiz: if (empty($m1E3O[$RlSN_])) { continue; } goto ljl8I; JssVw: if (empty($Bc59j['nickname'])) { $Bc59j['nickname'] = $Bc59j['username']; } goto L4qQ_; DB_9k: $I0Ndf[$mUe4B][$RlSN_] = $Bc59j; goto R4Kvv; R4Kvv: } } else { ModelUtil::joinItems($I0Ndf, $brHln, $RlSN_, 'member_user', 'id'); foreach ($I0Ndf as $ssG_v) { goto rbyCk; AAWpN: $Bc59j = ArrayUtil::keepKeys($ssG_v->{$RlSN_}, $Anylp); goto rKMmd; K6brA: $ssG_v->{$RlSN_} = $Bc59j; goto Y2k_6; rKMmd: if (empty($Bc59j['nickname'])) { $Bc59j['nickname'] = $Bc59j['username']; } goto vZrm3; vZrm3: if (empty($Bc59j['avatar'])) { $Bc59j['avatar'] = AssetsUtil::fixFull('asset/image/avatar.svg'); } else { $Bc59j['avatar'] = AssetsUtil::fixFull($Bc59j['avatar']); } goto K6brA; rbyCk: if (empty($ssG_v->{$RlSN_})) { continue; } goto AAWpN; Y2k_6: } } } public static function insert($xoPiT) { return ModelUtil::insert('member_user', $xoPiT); } public static function getIdByOauth($XtyGa, $Ab8NC) { goto rhcNC; rhcNC: $xhIzn = ModelUtil::get('member_oauth', array('type' => $XtyGa, 'openId' => $Ab8NC)); goto yfV9Y; M7mQg: return intval($xhIzn['memberUserId']); goto S1Y24; yfV9Y: if (empty($xhIzn)) { return 0; } goto M7mQg; S1Y24: } public static function getIdByOauthAndCheck($XtyGa, $Ab8NC) { goto o7eTW; eOmDX: if (self::get($PJ6BT)) { return $PJ6BT; } goto PEVHx; VadFH: return 0; goto zZIlk; PEVHx: MemberUtil::forgetOauth($XtyGa, $Ab8NC); goto VadFH; o7eTW: $PJ6BT = self::getIdByOauth($XtyGa, $Ab8NC); goto eOmDX; zZIlk: } public static function getOauthOpenId($PJ6BT, $XtyGa) { goto ChRih; GRxMi: $xhIzn = ModelUtil::get('member_oauth', $th30Q); goto xZDHk; c61hx: return $xhIzn['openId']; goto vyXfq; xZDHk: if (empty($xhIzn)) { return null; } goto c61hx; ChRih: $th30Q = array('memberUserId' => $PJ6BT, 'type' => $XtyGa); goto GRxMi; vyXfq: } public static function getOauth($PJ6BT, $XtyGa) { $th30Q = array('memberUserId' => $PJ6BT, 'type' => $XtyGa); return ModelUtil::get('member_oauth', $th30Q); } public static function listOauths($PJ6BT) { return ModelUtil::all('member_oauth', array('memberUserId' => $PJ6BT), array('*'), array('type', 'asc')); } public static function putOauth($PJ6BT, $XtyGa, $Ab8NC, $ku700 = array()) { goto CPY0h; L_ydt: if (empty($xhIzn)) { ModelUtil::delete('member_oauth', array('type' => $XtyGa, 'openId' => $Ab8NC)); ModelUtil::insert('member_oauth', array_merge($th30Q, $j9zYt)); } else { if ($xhIzn['openId'] != $Ab8NC) { ModelUtil::update('member_oauth', $xhIzn['id'], $j9zYt); } } goto SlL7Q; GCMnu: $pfrHL = "MemberOauth:{$PJ6BT}"; goto aah0a; aLCqy: $xhIzn = ModelUtil::get('member_oauth', $th30Q); goto ZgKDF; SlL7Q: LockUtil::release($pfrHL); goto XCi0n; ZgKDF: $j9zYt = array_merge(array('openId' => $Ab8NC), $ku700); goto L_ydt; CPY0h: $th30Q = array('memberUserId' => $PJ6BT, 'type' => $XtyGa); goto GCMnu; aah0a: if (!LockUtil::acquire($pfrHL)) { BizException::throws('正在处理中，请稍后再试'); } goto aLCqy; XCi0n: } public static function forgetOauth($XtyGa, $Ab8NC) { ModelUtil::delete('member_oauth', array('type' => $XtyGa, 'openId' => $Ab8NC)); } public static function updateNewMessageStatus($PJ6BT) { ModelUtil::update('member_user', array('id' => $PJ6BT), array('newMessageCount' => ModelUtil::count('member_message', array('userId' => $PJ6BT, 'status' => MemberMessageStatus::UNREAD)))); } public static function updateNewChatMsgStatus($PJ6BT) { if (modstart_module_enabled('MemberChat')) { ModelUtil::update('member_user', array('id' => $PJ6BT), array('newChatMsgCount' => ModelUtil::sum('member_chat', 'unreadMsgCount', array('memberUserId' => $PJ6BT)))); } } public static function paginate($xUD6f, $Pq7W4, $cdf0_ = array()) { return ModelUtil::paginate('member_user', $xUD6f, $Pq7W4, $cdf0_); } public static function updateStatus($KPunC, $FLJX4) { goto Fq5nQ; CuBGy: ModelUtil::model('member_user')->whereIn('id', $KPunC)->update(array('status' => $FLJX4)); goto aoYmq; Fq5nQ: if (!is_array($KPunC)) { $KPunC = array($KPunC); } goto ywqt5; ywqt5: if (empty($KPunC)) { return; } goto CuBGy; aoYmq: } public static function delete($PJ6BT) { goto HOe_c; Aq44B: ModelUtil::update('member_user', $PJ6BT, array('deleteAtTime' => 0, 'isDeleted' => true, 'username' => null, 'phone' => null, 'email' => null)); goto BgsDS; chlnq: $gFo13 = array(); goto ULth9; BqVYh: BizException::throwsIfEmpty('用户不存在', $Bc59j); goto YYI7V; HOe_c: $Bc59j = self::get($PJ6BT); goto BqVYh; pkD1g: $gFo13['oauth'] = ArrayUtil::keepItemsKeys($DPLoq, array('type', 'openId', 'infoUsername', 'infoAvatar')); goto U1eEs; YYI7V: ModelUtil::transactionBegin(); goto chlnq; ULth9: $DPLoq = ModelUtil::all('member_oauth', array('memberUserId' => $Bc59j['id'])); goto pkD1g; U1eEs: ModelUtil::insert('member_deleted', array('id' => $Bc59j['id'], 'username' => $Bc59j['username'], 'phone' => $Bc59j['phone'], 'email' => $Bc59j['email'], 'content' => json_encode($gFo13, JSON_UNESCAPED_UNICODE))); goto Aq44B; BgsDS: ModelUtil::transactionCommit(); goto BDX4Q; BDX4Q: } public static function fireLogin($PJ6BT) { goto PCuMG; PCuMG: $dv2tS = Request::ip(); goto noO2I; noO2I: ModelUtil::update('member_user', $PJ6BT, array('lastLoginTime' => Carbon::now(), 'lastLoginIp' => StrUtil::mbLimit($dv2tS, 20))); goto ha20v; ha20v: ModelUtil::insert('member_login_log', array('memberUserId' => $PJ6BT, 'deviceType' => DeviceType::current(), 'ip' => StrUtil::mbLimit($dv2tS, 20), 'userAgent' => StrUtil::mbLimit(AgentUtil::getUserAgent(), 400))); goto URj7e; URj7e: } }