<?php
/**
 * ------------------------ 
 *  版权所有  www.tecmz.com
 *  商业版本请购买正版授权使用
 * ------------------------
*/ namespace Module\Member\Admin\Controller; use Illuminate\Routing\Controller; use ModStart\Admin\Auth\AdminPermission; use ModStart\Admin\Concern\HasAdminQuickCRUD; use ModStart\Admin\Layout\AdminConfigBuilder; use ModStart\Admin\Layout\AdminCRUDBuilder; use ModStart\Admin\Layout\AdminDialogPage; use ModStart\Core\Assets\AssetsUtil; use ModStart\Core\Dao\ModelUtil; use ModStart\Core\Exception\BizException; use ModStart\Core\Input\InputPackage; use ModStart\Core\Input\Request; use ModStart\Core\Input\Response; use ModStart\Core\Type\TypeUtil; use ModStart\Core\Util\ArrayUtil; use ModStart\Core\Util\ColorUtil; use ModStart\Core\Util\CRUDUtil; use ModStart\Core\Util\EventUtil; use ModStart\Core\Util\RandomUtil; use ModStart\Core\Util\TimeUtil; use ModStart\Field\AbstractField; use ModStart\Field\AutoRenderedFieldValue; use ModStart\Field\Select; use ModStart\Field\Type\FieldRenderMode; use ModStart\Form\Form; use ModStart\Grid\Displayer\ItemOperate; use ModStart\Grid\GridFilter; use ModStart\Module\ModuleManager; use ModStart\Repository\Filter\RepositoryFilter; use ModStart\Support\Concern\HasFields; use ModStart\Widget\TextDialogRequest; use Module\Member\Config\MemberAdminList; use Module\Member\Config\MemberOauth; use Module\Member\Events\MemberUserRegisteredEvent; use Module\Member\Provider\MemberAdminShowPanel\MemberAdminShowPanelProvider; use Module\Member\Type\Gender; use Module\Member\Type\MemberStatus; use Module\Member\Util\MemberGroupUtil; use Module\Member\Util\MemberMessageUtil; use Module\Member\Util\MemberUtil; use Module\Member\Util\MemberVipUtil; use Module\Vendor\QuickRun\Export\ExportHandle; class MemberController extends Controller { use HasAdminQuickCRUD; protected function crud(AdminCRUDBuilder $wFsT4) { $wFsT4->init('member_user')->field(function ($wFsT4) { $wFsT4->id('id', 'ID'); MemberAdminList::callGridField($wFsT4); $wFsT4->display('avatar', '头像')->hookRendering(function (AbstractField $hZjv3, $ssG_v, $BGN_g) { $LVg5r = AssetsUtil::fixOrDefault($ssG_v->avatar, 'asset/image/avatar.svg'); $MN4cK = AssetsUtil::fixOrDefault($ssG_v->avatarBig, 'asset/image/avatar.svg'); return AutoRenderedFieldValue::make("<a href='{$MN4cK}' class='tw-inline-block' data-image-preview>\n                        <img src='{$LVg5r}' class='tw-rounded-full tw-w-8 tw-h-8 tw-shadow'></a>"); }); $wFsT4->text('username', '用户名')->required()->ruleUnique('member_user')->hookRendering(function (AbstractField $hZjv3, $ssG_v, $BGN_g) { switch ($hZjv3->renderMode()) { case FieldRenderMode::GRID: case FieldRenderMode::DETAIL: return AutoRenderedFieldValue::make(TextDialogRequest::make('primary', htmlspecialchars($ssG_v->username), modstart_admin_url('member/show', array('_id' => $ssG_v->id)))->width('90%')->height('90%')->render()); break; } }); $wFsT4->text('email', '邮箱'); $wFsT4->text('phone', '手机'); $wFsT4->text('nickname', '昵称'); if (MemberOauth::hasEnableItems()) { $wFsT4->display('_oauth', '授权')->hookRendering(function (AbstractField $hZjv3, $ssG_v, $BGN_g) { $vLc1T = array(); $GTF4X = MemberUtil::listOauths($ssG_v->id); foreach ($GTF4X as $dBEUh) { goto ya7k3; aQMQT: if ($f9jD9) { $thpqe = $f9jD9->color(); $wmjLt = $f9jD9->title(); } goto z9RbD; z9RbD: if (empty($thpqe)) { $thpqe = ColorUtil::pick($dBEUh['type']); } goto PK2bK; fHvxC: $wmjLt = $dBEUh['type']; goto w2ZOw; w2ZOw: $f9jD9 = MemberOauth::getByOauthKey($dBEUh['type']); goto aQMQT; ya7k3: $thpqe = null; goto fHvxC; PK2bK: $vLc1T[] = '<a style="color:' . $thpqe . ';" href="javascript:;" data-tip-popover="' . $wmjLt . '"><i class="iconfont icon-dot"></i></a>'; goto qy4tb; qy4tb: } return join('', $vLc1T); }); } $wFsT4->type('status', '状态')->type(MemberStatus::class, array(MemberStatus::NORMAL => 'success', MemberStatus::FORBIDDEN => 'danger'))->required(); $y9ToU = ModuleManager::getModuleConfig('Member', 'groupEnable', false); if ($y9ToU) { $wFsT4->radio('groupId', '分组')->options(MemberGroupUtil::mapIdTitle())->required(); } $r9yGc = ModuleManager::getModuleConfig('Member', 'vipEnable', false); if ($r9yGc) { $wFsT4->radio('vipId', 'VIP')->options(MemberVipUtil::mapTitle())->required(); $wFsT4->date('vipExpire', 'VIP过期'); } $wFsT4->display('registerIp', '注册IP'); $wFsT4->display('created_at', '注册时间'); $wFsT4->canBatchSelect(true); $wFsT4->batchOperatePrepend('<button class="btn" data-batch-confirm="确认禁用 %d 个用户？" data-batch-operate="' . modstart_admin_url('member/status_forbidden') . '"><i class="iconfont icon-warning"></i> 禁用</button>'); })->repositoryFilter(function (RepositoryFilter $Vonyp) { $Vonyp->where(array('isDeleted' => false)); })->gridFilter(function (GridFilter $Vonyp) { $Vonyp->eq('id', L('ID')); $Vonyp->like('username', '用户名'); $Vonyp->like('email', '邮箱')->autoHide(true); $Vonyp->like('phone', '手机')->autoHide(true); $Vonyp->eq('status', '状态')->autoHide(true)->select(MemberStatus::class); if (ModuleManager::getModuleConfig('Member', 'groupEnable', false)) { $Vonyp->eq('groupId', '分组')->autoHide(true)->select(MemberGroupUtil::mapIdTitle()); } if (ModuleManager::getModuleConfig('Member', 'vipEnable', false)) { $Vonyp->eq('vipId', 'VIP')->autoHide(true)->select(MemberVipUtil::mapTitle()); } })->operateFixed('right')->hookItemOperateRendering(function (ItemOperate $e9GCN) { $ssG_v = $e9GCN->item(); $e9GCN->prepend(TextDialogRequest::make('primary', '查看', modstart_admin_url('member/show', array('_id' => $ssG_v->id)))->width('90%')->height('90%')->render()); })->title('用户管理')->canShow(false)->canDelete(true)->canEdit(false)->canExport(ModuleManager::getModuleConfig('Member', 'exportEnable', false)); } public function selectRemote() { return Select::optionRemoteHandleModel('member_user', 'id', 'username'); } public function add(AdminDialogPage $xUD6f) { goto g4We3; l_fpc: return $xUD6f->pageTitle('创建用户')->body($beEeo)->handleForm($beEeo, function (Form $beEeo) { AdminPermission::demoCheck(); $xoPiT = $beEeo->dataForming(); $AvQzw = !empty($xoPiT['username']) ? $xoPiT['username'] : null; $gZcuD = !empty($xoPiT['phone']) ? $xoPiT['phone'] : null; $iNP5R = !empty($xoPiT['email']) ? $xoPiT['email'] : null; $p_GlW = ArrayUtil::keepKeys($xoPiT, array('nickname', 'groupId', 'status', 'vipId', 'vipExpire')); $fsZ7S = MemberUtil::register($AvQzw, $gZcuD, $iNP5R, $xoPiT['password']); BizException::throwsIfResponseError($fsZ7S); if (!empty($p_GlW)) { if (isset($p_GlW['vipExpire']) && TimeUtil::isDateEmpty($p_GlW['vipExpire'])) { $p_GlW['vipExpire'] = null; } MemberUtil::update($fsZ7S['data']['id'], $p_GlW); } EventUtil::fire(new MemberUserRegisteredEvent($fsZ7S['data']['id'])); return Response::redirect(CRUDUtil::jsDialogCloseAndParentGridRefresh()); }); goto xVZPE; RaBwW: $beEeo->layoutPanel('基础（用户、手机、邮箱不能同时为空）', function (Form $beEeo) { $beEeo->text('username', '用户名'); $beEeo->text('phone', '手机'); $beEeo->text('email', '邮箱'); $beEeo->text('password', '初始密码')->defaultValue(RandomUtil::lowerString(8)); }); goto GYbKd; g4We3: $beEeo = Form::make(''); goto RaBwW; y6rvx: $beEeo->showSubmit(false)->showReset(false); goto l_fpc; GYbKd: $beEeo->layoutPanel('高级', function (Form $beEeo) { $beEeo->text('nickname', '昵称'); $beEeo->radio('status', '状态')->optionType(MemberStatus::class)->defaultValue(MemberStatus::NORMAL); if (ModuleManager::getModuleConfig('Member', 'groupEnable', false)) { $beEeo->radio('groupId', '分组')->options(MemberGroupUtil::mapIdTitle())->required(); } if (ModuleManager::getModuleConfig('Member', 'vipEnable', false)) { $beEeo->radio('vipId', 'VIP')->options(MemberVipUtil::mapTitle())->required(); $beEeo->date('vipExpire', 'VIP过期'); } }); goto y6rvx; xVZPE: } public function edit(AdminDialogPage $xUD6f) { goto Cm63d; IMpXS: $beEeo->layoutPanel('基础', function (Form $beEeo) { $beEeo->display('id', '用户ID')->addable(true); $beEeo->text('username', '用户名'); $beEeo->text('phone', '手机'); $beEeo->text('email', '邮箱'); }); goto o7nyE; sfQOF: $beEeo->item($Bc59j)->fillFields(); goto Kloby; QfDQ6: return $xUD6f->pageTitle('修改信息')->body($beEeo)->handleForm($beEeo, function (Form $beEeo) use($Bc59j) { AdminPermission::demoCheck(); $xoPiT = $beEeo->dataForming(); $CfaUK = ArrayUtil::keepKeys($xoPiT, array('username', 'phone', 'email')); $p_GlW = ArrayUtil::keepKeys($xoPiT, array('nickname', 'groupId', 'status', 'vipId', 'vipExpire')); $fsZ7S = MemberUtil::updateBasicWithUniqueCheck($Bc59j['id'], $CfaUK); BizException::throwsIfResponseError($fsZ7S); if (isset($p_GlW['vipExpire']) && TimeUtil::isDateEmpty($p_GlW['vipExpire'])) { $p_GlW['vipExpire'] = null; } MemberUtil::update($Bc59j['id'], $p_GlW); return Response::redirect(CRUDUtil::jsDialogCloseAndParentRefresh()); }); goto rdjUE; Kloby: $beEeo->showSubmit(false)->showReset(false); goto QfDQ6; o7nyE: $beEeo->layoutPanel('高级', function (Form $beEeo) { $beEeo->text('nickname', '昵称'); $beEeo->radio('status', '状态')->optionType(MemberStatus::class)->defaultValue(MemberStatus::NORMAL); if (ModuleManager::getModuleConfig('Member', 'groupEnable', false)) { $beEeo->radio('groupId', '分组')->options(MemberGroupUtil::mapIdTitle())->required(); } if (ModuleManager::getModuleConfig('Member', 'vipEnable', false)) { $beEeo->radio('vipId', 'VIP')->options(MemberVipUtil::mapTitle())->required(); $beEeo->date('vipExpire', 'VIP过期')->help('VIP过期留空表示永久'); } }); goto sfQOF; VoJG2: $beEeo = Form::make(''); goto IMpXS; UX5EX: BizException::throwsIfEmpty('用户不存在', $Bc59j); goto zd9YJ; Cm63d: $Bc59j = ModelUtil::get('member_user', CRUDUtil::id()); goto UX5EX; zd9YJ: if (Request::isPost()) { goto kzBYg; oxh6I: switch ($bj56m->getTrimString('_action')) { case 'itemCellEdit': goto cARMl; nIko6: if (!empty($j9zYt)) { MemberUtil::update($Bc59j['id'], $j9zYt); } goto Ab1Le; cARMl: $j9zYt = array(); goto GOStj; Ab1Le: return Response::generateSuccess(); goto xvN3y; GOStj: switch ($bj56m->getTrimString('column')) { case 'status': $j9zYt['status'] = $bj56m->getInteger('value'); break; } goto nIko6; xvN3y: } goto oA0rj; kzBYg: AdminPermission::demoCheck(); goto P23WA; P23WA: $bj56m = InputPackage::buildFromInput(); goto oxh6I; oA0rj: } goto VoJG2; rdjUE: } public function select(AdminDialogPage $xUD6f) { goto iacOb; fYaEK: return $xUD6f->pageTitle('选择用户')->body($c_f2j); goto J6xCS; iacOb: $c_f2j = $this->grid(); goto VroPI; Uo0ba: CRUDUtil::registerGridResource($c_f2j, '\\' . __CLASS__); goto b7PTV; NpZR_: $c_f2j->canSingleSelectItem(true); goto Uo0ba; VroPI: $c_f2j->disableCUD(); goto NpZR_; b7PTV: if (Request::isPost()) { return $c_f2j->request(); } goto fYaEK; J6xCS: } public function search() { goto ZlKy_; LquTI: $cdf0_ = array(); goto KxbG9; A7quc: $FhUys = $bj56m->getTrimString('keywords'); goto LquTI; lB3L6: $I0Ndf = array_map(function ($ssG_v) { return array('value' => intval($ssG_v['id']), 'name' => htmlspecialchars(MemberUtil::viewName($ssG_v)), 'avatar' => AssetsUtil::fixOrDefault($ssG_v['avatar'], 'asset/image/avatar.svg')); }, $sDOSj['records']); goto JXcqD; KxbG9: $cdf0_['whereOperate'] = array('username', 'like', "%{$FhUys}%"); goto XEDCQ; ZlKy_: $bj56m = InputPackage::buildFromInput(); goto A7quc; JXcqD: return Response::jsonSuccessData($I0Ndf); goto q3ewD; XEDCQ: $sDOSj = MemberUtil::paginate(1, 10, $cdf0_); goto lB3L6; q3ewD: } public function resetPassword(AdminConfigBuilder $wFsT4) { goto fZlvB; R1L4p: return $wFsT4; goto z5WQL; fZlvB: $Ch1Xd = CRUDUtil::id(); goto bLlIz; bLlIz: $Bc59j = MemberUtil::get($Ch1Xd); goto TlKQQ; YO90f: $wFsT4->text('passwordNew', '新密码')->required()->defaultValue(RandomUtil::upperString(6)); goto ZtVsk; TlKQQ: BizException::throwsIfEmpty('用户不存在', $Bc59j); goto nVo22; ZtVsk: if (Request::isPost()) { return $wFsT4->formRequest(function (Form $beEeo) use($Bc59j) { AdminPermission::demoCheck(); $xoPiT = $beEeo->dataForming(); $fsZ7S = MemberUtil::changePassword($Bc59j['id'], $xoPiT['passwordNew'], null, true); BizException::throwsIfResponseError($fsZ7S); return Response::redirect(CRUDUtil::jsDialogClose()); }); } goto R1L4p; nVo22: $wFsT4->useDialog(); goto u47yx; u47yx: $wFsT4->pageTitle('重置密码'); goto YO90f; z5WQL: } public function sendMessage(AdminConfigBuilder $wFsT4) { goto ph_oI; bYB9I: $wFsT4->pageTitle('发送消息'); goto Wb5q5; ph_oI: $Ch1Xd = CRUDUtil::id(); goto iNfER; ZTlX9: $wFsT4->useDialog(); goto bYB9I; Jm5_E: BizException::throwsIfEmpty('用户不存在', $Bc59j); goto ZTlX9; K2ZLF: if (Request::isPost()) { return $wFsT4->formRequest(function (Form $beEeo) use($Bc59j) { AdminPermission::demoCheck(); $xoPiT = $beEeo->dataForming(); $fsZ7S = MemberMessageUtil::send($Bc59j['id'], $xoPiT['content']); BizException::throwsIfResponseError($fsZ7S); return Response::redirect(CRUDUtil::jsDialogClose()); }); } goto jQgSY; Wb5q5: $wFsT4->richHtml('content', '消息内容')->required(); goto K2ZLF; jQgSY: return $wFsT4; goto kKPYC; iNfER: $Bc59j = MemberUtil::get($Ch1Xd); goto Jm5_E; kKPYC: } public function show() { goto bf02Y; x3px4: return view('module::Member.View.admin.memberUser.show', array('record' => $vVTeu, 'showPanelProviders' => $NsAM3)); goto a2BhT; KxvWp: $NsAM3 = MemberAdminShowPanelProvider::listAll(); goto x3px4; bf02Y: $vVTeu = MemberUtil::get(CRUDUtil::id()); goto KxvWp; a2BhT: } public function delete() { goto m25S5; m25S5: AdminPermission::demoCheck(); goto pGheb; bq8cC: return Response::redirect(CRUDUtil::jsGridRefresh()); goto dQuDw; pGheb: MemberUtil::delete(CRUDUtil::id()); goto bq8cC; dQuDw: } public function statusForbidden() { goto kFdYS; kFdYS: AdminPermission::demoCheck(); goto F3_wp; fpy9h: return Response::redirect(CRUDUtil::jsGridRefresh()); goto Oiiq2; F3_wp: MemberUtil::updateStatus(CRUDUtil::ids(), MemberStatus::FORBIDDEN); goto fpy9h; Oiiq2: } public function export(ExportHandle $bURZA) { $A9g6k = array('ID', '用户名', '邮箱', '手机', '注册时间', '性别', '姓名', '签名'); return $bURZA->withPageTitle('导出用户信息')->withDefaultExportName('用户信息')->withHeadTitles($A9g6k)->handleFetch(function ($xUD6f, $Pq7W4, $LliVt, $YVTn3) { $rtN3F = ModelUtil::model('member_user'); $rtN3F = $rtN3F->where(array('isDeleted' => false))->orderBy('id', 'desc'); foreach ($LliVt as $qXoX1) { if (!empty($qXoX1['id']['eq'])) { $rtN3F = $rtN3F->where('id', $qXoX1['id']['eq']); } elseif (!empty($qXoX1['status']['eq'])) { $rtN3F = $rtN3F->where('status', $qXoX1['status']['eq']); } elseif (!empty($qXoX1['groupId']['eq'])) { $rtN3F = $rtN3F->where('groupId', $qXoX1['groupId']['eq']); } elseif (!empty($qXoX1['vipId']['eq'])) { $rtN3F = $rtN3F->where('vipId', $qXoX1['vipId']['eq']); } elseif (!empty($qXoX1['username']['like'])) { $rtN3F = $rtN3F->where('username', 'like', '%' . $qXoX1['username']['like'] . '%'); } elseif (!empty($qXoX1['email']['like'])) { $rtN3F = $rtN3F->where('email', 'like', '%' . $qXoX1['email']['like'] . '%'); } elseif (!empty($qXoX1['phone']['like'])) { $rtN3F = $rtN3F->where('phone', 'like', '%' . $qXoX1['phone']['like'] . '%'); } } $Hz6MR = $rtN3F->paginate($Pq7W4, array('*'), 'page', $xUD6f)->toArray(); $pfBAk = array(); foreach ($Hz6MR['data'] as $ssG_v) { goto sQkm1; SmEJ5: $pfBAk[] = $zmelN; goto M2Jgh; sQkm1: $zmelN = array(); goto QmvKD; cBwji: $zmelN[] = $ssG_v['signature']; goto SmEJ5; opt7z: $zmelN[] = $ssG_v['email']; goto Y5_Pn; BpdAO: $zmelN[] = $ssG_v['realname']; goto cBwji; Y5_Pn: $zmelN[] = $ssG_v['phone']; goto jTQXJ; vowWX: $zmelN[] = TypeUtil::name(Gender::class, $ssG_v['gender']); goto BpdAO; jTQXJ: $zmelN[] = $ssG_v['created_at']; goto vowWX; QmvKD: $zmelN[] = $ssG_v['id']; goto a7aQ0; a7aQ0: $zmelN[] = $ssG_v['username']; goto opt7z; M2Jgh: } return array('list' => $pfBAk, 'total' => $Hz6MR['total']); })->performCommon(); } }