@extends($_viewFrame)

@section('pageTitle'){{(!empty($pageTitle)?$pageTitle.' - ':'').modstart_config('siteName')}}@endsection
@section('pageKeywords'){{(!empty($pageTitle)?$pageTitle.' - ':'').modstart_config('siteName')}}@endsection
@section('pageDescription'){{(!empty($pageTitle)?$pageTitle.' - ':'').modstart_config('siteName')}}@endsection

@section('headAppend')
    @parent
    <style type="text/css">
        .ub-container{
            max-width:100%;
        }
        .ub-header-b .logo{
            min-width: 160px;
            margin-right: 0;
        }
        .ub-header-b .nav{
            padding: 1rem 0 !important;
        }
        .ub-header-b .nav a{
            line-height: 1.2rem !important;
            border-radius:1rem;
        }
        .ub-header-b .nav .active{
            background-color:var(--color-primary);
            color:#FFF !important;
        }
        .ub-header-b{
            position:fixed;
            left:0px;
            top:0px;
            right:0px;
            z-index:1000;
        }
        .pb-header-placeholder{
            height:60px;
        }
    </style>
@endsection

@section('headNav')
    <div class="nav">
        <a class="{{modstart_baseurl_active(['corp_crm','corp_crm/*'])}}" href="{{modstart_web_url('corp_crm')}}">客户管理</a>
        <a class="{{modstart_baseurl_active(['corp','corp/*'])}}" href="{{modstart_web_url('corp')}}">企业设置</a>
    </div>
@endsection

@section('bodyContent')

    <div class="ub-container margin-top">
        <div class="row">
            <div class="col-md-2">
                <div class="ub-menu nav-menu">
                    <div class="title"><i class="icon iconfont icon-user"></i> 资料</div>
                    <div class="items">
                        <a href="{{modstart_web_url('member_profile')}}" class="{{modstart_baseurl_active(modstart_web_url('member_profile'))}}">我的资料</a>
                    </div>
                    <div class="title"><i class="icon iconfont icon-user"></i> 安全</div>
                    <div class="items">
                        <a href="{{modstart_web_url('member_profile/password')}}" class="{{modstart_baseurl_active(modstart_web_url('member_profile/password'))}}">修改密码</a>
                        <a href="{{modstart_web_url('member_profile/avatar')}}" class="{{modstart_baseurl_active(modstart_web_url('member_profile/avatar'))}}">修改头像</a>
                        <a href="{{modstart_web_url('member_profile/phone')}}" class="{{modstart_baseurl_active(modstart_web_url('member_profile/phone'))}}">绑定手机</a>
                        <a href="{{modstart_web_url('member_profile/email')}}" class="{{modstart_baseurl_active(modstart_web_url('member_profile/email'))}}">绑定邮箱</a>
                    </div>
                </div>
                <script>
                    $(function () {
                        var $menu = $('.ub-menu.nav-menu');
                        if($(window).width()>600){
                            $menu.find('.items').addClass('open');
                        }else{
                            $menu.find('.title').on('click',function () {
                                $menu.find('.items').removeClass('open');
                                $(this).next().addClass('open')
                                    .css('left',$(this).offset().left+'px')
                                    .css('width',$(this).width()+'px');
                                return false;
                            });
                            $(document).on('click',function(){
                                $menu.find('.items').removeClass('open');
                            });
                        }
                    });
                </script>
            </div>
            <div class="col-md-10">
                @section('memberBodyContent')
                    {!! $content or '' !!}
                @show
            </div>
        </div>
    </div>

@endsection
