<?php
/**
 * ------------------------ 
 *  版权所有  www.tecmz.com
 *  商业版本请购买正版授权使用
 * ------------------------
*/ namespace Module\Member\Util; use Carbon\Carbon; use Illuminate\Support\Facades\Cache; use Illuminate\Support\Str; use Intervention\Image\Facades\Image; use ModStart\Core\Assets\AssetsUtil; use ModStart\Core\Dao\ModelUtil; use ModStart\Core\Exception\BizException; use ModStart\Core\Input\Request; use ModStart\Core\Input\Response; use ModStart\Core\Util\AgentUtil; use ModStart\Core\Util\ArrayUtil; use ModStart\Core\Util\EncodeUtil; use ModStart\Core\Util\FormatUtil; use ModStart\Core\Util\LockUtil; use ModStart\Core\Util\RandomUtil; use ModStart\Core\Util\StrUtil; use ModStart\Data\DataManager; use ModStart\Data\Event\DataFileUploadedEvent; use Module\Member\Events\MemberUserLoginAttemptEvent; use Module\Member\Events\MemberUserLoginFailedEvent; use Module\Member\Type\MemberMessageStatus; use Module\Member\Type\MemberStatus; use Module\Vendor\Type\DeviceType; class MemberUtil { public static function total() { return Cache::remember('MemberUserTotal', 60, function () { return ModelUtil::count('member_user'); }); } public static function get($M3rBS) { return ModelUtil::get('member_user', array('id' => $M3rBS)); } public static function getCached($M3rBS) { return Cache::remember('MemberUser:' . $M3rBS, 60, function () use($M3rBS) { return self::get($M3rBS); }); } public static function processDefault(&$J09PA) { goto Poh7c; ClP44: if (empty($J09PA['nickname'])) { $J09PA['nickname'] = $J09PA['username']; } goto Kcr5L; Kcr5L: if (empty($J09PA['avatar'])) { $J09PA['avatar'] = AssetsUtil::fixFull('asset/image/avatar.svg', false); } goto dekOG; dekOG: if (empty($J09PA['avatarMedium'])) { $J09PA['avatarMedium'] = AssetsUtil::fixFull('asset/image/avatar.svg', false); } goto W885B; W885B: if (empty($J09PA['avatarBig'])) { $J09PA['avatarBig'] = AssetsUtil::fixFull('asset/image/avatar.svg', false); } goto zZneI; Poh7c: if (empty($J09PA)) { return; } goto ClP44; zZneI: } private static function processBasicFields($BsRJ4) { goto A4Cqp; SmPPy: if (null === $BsRJ4) { $BsRJ4 = $VKsvJ; } else { goto JLNR6; JLNR6: $vzMB1 = array(); goto EH_QZ; EH_QZ: foreach ($BsRJ4 as $MFVkb) { if ('<basic>' == $MFVkb) { $vzMB1 = array_merge($vzMB1, $VKsvJ); } else { $vzMB1[] = $MFVkb; } } goto XhMtI; XhMtI: $BsRJ4 = $vzMB1; goto TQG_q; TQG_q: } goto fnSri; fnSri: return $BsRJ4; goto OUc8P; A4Cqp: $VKsvJ = array('id', 'username', 'avatar', 'created_at', 'signature', 'nickname'); goto SmPPy; OUc8P: } public static function fixAvatar($K5SMg) { return AssetsUtil::fixFullOrDefault($K5SMg, 'asset/image/avatar.svg'); } public static function getBasic($M3rBS, $BsRJ4 = null) { goto Z21gG; zrf5F: $Z32UA = self::get($M3rBS); goto dI6h1; acfYW: return $s2vPN; goto mD7DB; rIt_v: $Z32UA['avatar'] = self::fixAvatar($Z32UA['avatar']); goto dwo0Z; dwo0Z: $s2vPN = array(); goto EkCBd; Z21gG: $BsRJ4 = self::processBasicFields($BsRJ4); goto zrf5F; EkCBd: foreach ($BsRJ4 as $x2K4x) { if (isset($Z32UA[$x2K4x])) { $s2vPN[$x2K4x] = $Z32UA[$x2K4x]; } else { $s2vPN[$x2K4x] = null; } } goto acfYW; c6nJI: if (empty($Z32UA['nickname'])) { $Z32UA['nickname'] = $Z32UA['username']; } goto rIt_v; dI6h1: if (empty($Z32UA)) { return null; } goto c6nJI; mD7DB: } public static function listViewName($JidTX) { goto aiz6L; fStNN: foreach ($sHpVc as $J09PA) { $tVUbY[] = self::viewName($J09PA); } goto CXXOG; bd3eU: $sHpVc = ModelUtil::allIn('member_user', 'id', $JidTX); goto fStNN; aiz6L: $tVUbY = array(); goto bd3eU; CXXOG: return $tVUbY; goto z00YP; z00YP: } public static function listUsers($JidTX) { return ModelUtil::allIn('member_user', 'id', $JidTX); } public static function convertOneToBasic($J09PA) { return array('id' => $J09PA['id'], 'username' => $J09PA['username'], 'nickname' => empty($J09PA['nickname']) ? $J09PA['username'] : $J09PA['nickname'], 'created_at' => $J09PA['created_at'], 'signature' => isset($J09PA['signature']) ? $J09PA['signature'] : null, 'avatar' => AssetsUtil::fixFullOrDefault($J09PA['avatar'], 'asset/image/avatar.svg')); } public static function convertToBasic($sHpVc) { return array_map(function ($Z32UA) { return array('id' => $Z32UA['id'], 'username' => $Z32UA['username'], 'nickname' => empty($Z32UA['nickname']) ? $Z32UA['username'] : $Z32UA['nickname'], 'created_at' => $Z32UA['created_at'], 'signature' => isset($Z32UA['signature']) ? $Z32UA['signature'] : null, 'avatar' => AssetsUtil::fixFullOrDefault($Z32UA['avatar'], 'asset/image/avatar.svg')); }, $sHpVc); } public static function listUsersBasic($JidTX) { return self::convertToBasic(self::listUsers($JidTX)); } public static function getViewName($M3rBS) { return self::viewName(self::get($M3rBS)); } public static function viewName($J09PA) { goto jorJy; MQkQw: if (empty($J09PA)) { return '-'; } goto u2JGn; u2JGn: if (!empty($J09PA['nickname'])) { return $J09PA['nickname']; } goto Y0zAi; Y0zAi: if (!empty($J09PA['username'])) { return $J09PA['username']; } goto wTZ9W; jorJy: if ($J09PA && is_numeric($J09PA)) { return self::getViewName($J09PA); } goto MQkQw; wTZ9W: return "ID-{$J09PA['id']}"; goto Ip8Ii; Ip8Ii: } public static function update($M3rBS, $Pg57y) { return ModelUtil::update('member_user', array('id' => $M3rBS), $Pg57y); } public static function updateBasicWithUniqueCheck($M3rBS, $Pg57y) { goto q9kuH; ufwks: self::update($M3rBS, $Pg57y); goto BtbHj; BtbHj: return Response::generate(0, 'ok'); goto tNzuh; q9kuH: if (empty($Pg57y)) { return Response::generate(0, 'ok'); } goto b0Xml; b0Xml: foreach (array('username' => '用户名', 'phone' => '手机', 'email' => '邮箱') as $UdGHQ => $Nimja) { if (isset($Pg57y[$UdGHQ])) { goto v_C8f; mRuKe: $e8n8Q = ModelUtil::all('member_user', array($UdGHQ => $Pg57y[$UdGHQ])); goto xX2C4; NGqZa: if (count($e8n8Q) == 1) { if ($e8n8Q[0]['id'] != $M3rBS) { return Response::generate(-1, $Nimja . '重复'); } } goto swYIz; xX2C4: if (count($e8n8Q) > 1) { return Response::generate(-1, $Nimja . '重复'); } goto NGqZa; v_C8f: if (empty($Pg57y[$UdGHQ])) { $Pg57y[$UdGHQ] = null; continue; } goto mRuKe; swYIz: } } goto ufwks; tNzuh: } public static function login($f6vte = '', $cz6lT = '', $FoN15 = '', $iJwHS = '') { goto GqvVP; GqvVP: $FoN15 = trim($FoN15); goto mvPkm; hUA8Y: MemberUserLoginAttemptEvent::fire($J09PA['id'], Request::ip(), AgentUtil::getUserAgent()); goto k0FXw; mvPkm: $cz6lT = trim($cz6lT); goto z1oGW; k0FXw: if ($J09PA['password'] != EncodeUtil::md5WithSalt($iJwHS, $J09PA['passwordSalt'])) { MemberUserLoginFailedEvent::fire($J09PA['id'], $J09PA['username'], Request::ip(), AgentUtil::getUserAgent()); return Response::generate(-7, '登录失败:用户名或密码错误'); } goto gi5Bf; z1oGW: $f6vte = trim($f6vte); goto YaKl3; A_qca: if (!$iJwHS) { return Response::generate(-2, '密码为空'); } goto ZBo6g; gi5Bf: switch ($J09PA['status']) { case MemberStatus::FORBIDDEN: return Response::generateError(-8, '登录失败:当前用户已被禁用'); } goto viiGY; ZBo6g: if ($FoN15) { if (!FormatUtil::isEmail($FoN15)) { return Response::generate(-3, '邮箱格式不正确'); } $HBsr7 = array('email' => $FoN15); } else { if ($cz6lT) { if (!preg_match('/(^1[0-9]{10}$)/', $cz6lT)) { return Response::generate(-4, '手机格式不正确'); } $HBsr7 = array('phone' => $cz6lT); } else { if ($f6vte) { if (strpos($f6vte, '@') !== false) { return Response::generate(-5, '用户名格式不正确'); } $HBsr7 = array('username' => $f6vte); } } } goto n7Mam; jdjD_: if (empty($J09PA)) { return Response::generate(-6, '登录失败:用户名或密码错误'); } goto hUA8Y; viiGY: return Response::generateSuccessData($J09PA); goto xzSMX; n7Mam: $J09PA = ModelUtil::get('member_user', $HBsr7); goto jdjD_; YaKl3: if (!($FoN15 || $cz6lT || $f6vte)) { return Response::generate(-1, '所有登录字段均为空'); } goto A_qca; xzSMX: } public static function autoSetUsernameNickname($d4RRw, $uXSNC) { goto e97WC; e97WC: $LRBDg = 6; goto I6OKL; I6OKL: if (preg_match('/\\{.*\\}/', $uXSNC)) { goto GJ3_Y; bzAjL: $z0UO7 = array('{Phone}' => $J09PA['phone'], '{Phone4}' => substr($J09PA['phone'], 7), '{Uid}' => $J09PA['id']); goto LmCmJ; IjYqK: $LRBDg = 0; goto iHH82; GJ3_Y: $J09PA = self::get($d4RRw); goto bzAjL; LmCmJ: $uXSNC = str_replace(array_keys($z0UO7), array_values($z0UO7), $uXSNC); goto IjYqK; iHH82: } goto bSe7j; bSe7j: self::suggestUsernameNickname($d4RRw, $uXSNC, $LRBDg); goto HPBJn; HPBJn: } public static function getSuggestUsernameNickname($n6M2h) { goto Vxdv9; Vxdv9: $uXSNC = $n6M2h . Str::random(1); goto QL6HA; QL6HA: for ($PsIao = 0; $PsIao < 20; $PsIao++) { $M3aYk = ModelUtil::model('member_user')->where(array('username' => $uXSNC))->orWhere(array('nickname' => $uXSNC))->first(); if (empty($M3aYk)) { return $uXSNC; } $uXSNC = $uXSNC . Str::random(1); } goto Mgko4; Mgko4: return $uXSNC . Str::random(10); goto V8Fdo; V8Fdo: } private static function suggestUsernameNickname($d4RRw, $CDU3A = '用户', $LRBDg = 6) { goto uS5yK; Zt4KS: ModelUtil::update('member_user', $d4RRw, array('username' => $uXSNC, 'nickname' => $uXSNC)); goto ap4am; mRD8w: for ($PsIao = 0; $PsIao < 20; $PsIao++) { $M3aYk = ModelUtil::model('member_user')->where(array('username' => $uXSNC))->orWhere(array('nickname' => $uXSNC))->first(); if (empty($M3aYk)) { break; } $uXSNC = $uXSNC . Str::random(1); } goto Zt4KS; uS5yK: if ($LRBDg > 0) { $uXSNC = $CDU3A . RandomUtil::string($LRBDg); } else { $uXSNC = $CDU3A; } goto mRD8w; ap4am: } public static function registerUsernameQuick($f6vte) { goto NPIu9; NPIu9: $pmz3S = $f6vte; goto Y8VDc; aEdBV: return Response::generateError('注册失败'); goto gjevn; Y8VDc: for ($PsIao = 0; $PsIao < 10; $PsIao++) { $Ecj99 = self::register($pmz3S, '', '', '', true); if ($Ecj99['code']) { $pmz3S = $pmz3S . Str::random(1); } else { return $Ecj99; } } goto aEdBV; gjevn: } public static function register($f6vte = '', $cz6lT = '', $FoN15 = '', $iJwHS = '', $HcLAs = false) { goto SHVco; pPC37: if ($f6vte) { goto R9jRB; tB6CA: if (Str::contains($f6vte, '@')) { return Response::generate(-1, '用户名不能包含特殊字符'); } goto qhjjq; WUHxj: if ($Ecj99['code']) { return $Ecj99; } goto xg0VE; R9jRB: $Ecj99 = self::uniqueCheck('username', $f6vte); goto WUHxj; qhjjq: if (preg_match('/^[0-9]{11}$/', $f6vte)) { return Response::generate(-1, '用户名不能为纯数字'); } goto EVSzb; xg0VE: if (strlen($f6vte) < modstart_config('Member_UsernameMinLength', 3)) { return Response::generate(-1, '用户名至少3个字符'); } goto tB6CA; EVSzb: } else { $f6vte = null; } goto yle0G; TW_Vw: if ($FoN15) { $Ecj99 = self::uniqueCheck('email', $FoN15); if ($Ecj99['code']) { return $Ecj99; } } else { $FoN15 = null; } goto VCcsl; VmJeq: if (!($FoN15 || $cz6lT || $f6vte)) { return Response::generate(-1, '所有注册字段均为空'); } goto TW_Vw; XmAqs: $mo4yA = Str::random(16); goto q6QPr; f2HuV: return Response::generate(0, 'ok', $J09PA); goto c2KF3; VCcsl: if ($cz6lT) { $Ecj99 = self::uniqueCheck('phone', $cz6lT); if ($Ecj99['code']) { return $Ecj99; } } else { $cz6lT = null; } goto pPC37; SHVco: $FoN15 = trim($FoN15); goto o2IUj; q6QPr: $J09PA = ModelUtil::insert('member_user', array('status' => MemberStatus::NORMAL, 'username' => $f6vte, 'email' => $FoN15, 'phone' => $cz6lT, 'password' => $HcLAs ? null : EncodeUtil::md5WithSalt($iJwHS, $mo4yA), 'passwordSalt' => $HcLAs ? null : $mo4yA, 'vipId' => MemberVipUtil::defaultVipId(), 'groupId' => MemberGroupUtil::defaultGroupId(), 'isDeleted' => false)); goto f2HuV; o2IUj: $cz6lT = trim($cz6lT); goto BQDYa; BQDYa: $f6vte = trim($f6vte); goto VmJeq; yle0G: if (!$HcLAs) { if (empty($iJwHS) || strlen($iJwHS) < 6) { return Response::generate(-3, '密码不合法'); } } goto XmAqs; c2KF3: } public static function uniqueCheck($g_4iP, $hsART, $BMVDc = 0) { goto mnXpu; a0TEh: $J09PA = ModelUtil::get('member_user', array($g_4iP => $hsART)); goto Vbp13; mnXpu: $hsART = trim($hsART); goto kfo7e; Vbp13: if (empty($J09PA)) { return Response::generate(0, 'ok'); } goto AS_nE; cyLX1: return Response::generate(-2, $OEHSa[$g_4iP] . '已经被占用'); goto ZlPjA; Np109: if ($BMVDc == $J09PA['id']) { return Response::generate(0, 'ok'); } goto cyLX1; AS_nE: $OEHSa = array('username' => '用户名', 'email' => '邮箱', 'phone' => '手机号'); goto Np109; kfo7e: switch ($g_4iP) { case 'email': if (!FormatUtil::isEmail($hsART)) { return Response::generate(-1, '邮箱格式不正确'); } break; case 'phone': if (!preg_match('/(^1[0-9]{10}$)/', $hsART)) { return Response::generate(-1, '手机格式不正确'); } break; case 'username': if (strpos($hsART, '@') !== false) { return Response::generate(-1, '用户名格式不正确'); } break; case 'nickname': break; default: return Response::generate(-1, '未能识别的类型' . $g_4iP); } goto a0TEh; ZlPjA: } public static function getByUsername($f6vte) { return ModelUtil::get('member_user', array('username' => $f6vte)); } public static function getByEmail($FoN15) { return ModelUtil::get('member_user', array('email' => $FoN15)); } public static function getByPhone($cz6lT) { return ModelUtil::get('member_user', array('phone' => $cz6lT)); } public static function changeNickname($d4RRw, $K4AI8) { goto vb4Vm; lwV7j: if (Response::isError($Ecj99)) { return $Ecj99; } goto RGcaJ; vb4Vm: $Ecj99 = self::uniqueCheck('nickname', $K4AI8, $d4RRw); goto lwV7j; RGcaJ: ModelUtil::update('member_user', $d4RRw, array('nickname' => $K4AI8)); goto yL8RX; yL8RX: return Response::generate(0, 'ok'); goto eJ9xI; eJ9xI: } public static function changePassword($d4RRw, $SwZbe, $P4ZVh = null, $uwlKH = false) { goto NsDHT; NsDHT: if (!$uwlKH && empty($P4ZVh)) { return Response::generate(-1, '旧密码不能为空'); } goto w3px9; j3OMX: if (!$uwlKH && EncodeUtil::md5WithSalt($P4ZVh, $J09PA['passwordSalt']) != $J09PA['password']) { return Response::generate(-1, '旧密码不正确'); } goto Y6e5M; h6m1m: ModelUtil::update('member_user', array('id' => $J09PA['id']), array('passwordSalt' => $mo4yA, 'password' => EncodeUtil::md5WithSalt($SwZbe, $mo4yA))); goto VKe4V; Y6e5M: $mo4yA = Str::random(16); goto h6m1m; w3px9: $J09PA = ModelUtil::get('member_user', array('id' => $d4RRw)); goto C__PJ; VKe4V: return Response::generate(0, 'ok'); goto I7oep; xfVui: if (empty($SwZbe)) { return Response::generate(-1, '新密码为空'); } goto j3OMX; C__PJ: if (empty($J09PA)) { return Response::generate(-1, '用户不存在'); } goto xfVui; I7oep: } public static function setAvatar($klMu7, $rgbJj, $XIHmb = 'jpg') { goto KzYuG; FXp2C: $x8CUD = (string) Image::make($rgbJj)->resize(400, 400)->encode($XIHmb, 75); goto Hjnuu; qCkn7: $Ecj99 = DataManager::upload('image', 'U_' . $klMu7 . '_Avatar.' . $XIHmb, $CzRaU, null, $BVqCD); goto b4QIb; b4QIb: if ($Ecj99['code']) { goto mZTrO; SdP3p: DataManager::deleteById($LjdCn['data']['id']); goto XqVC1; XqVC1: if ($Ct4d1['code']) { return Response::generate(-1, '头像存储失败（' . $Ecj99['msg'] . '）'); } goto u2uOE; mZTrO: DataManager::deleteById($Ct4d1['data']['id']); goto SdP3p; u2uOE: } goto Upbg1; KzYuG: $J09PA = self::get($klMu7); goto jBXsC; SnsjR: if ($LjdCn['code']) { DataManager::deleteById($Ct4d1['data']['id']); if ($Ct4d1['code']) { return Response::generate(-1, '头像存储失败（' . $LjdCn['msg'] . '）'); } } goto qCkn7; jBXsC: if (empty($J09PA)) { return Response::generate(-1, '用户不存在'); } goto fEVnn; fEVnn: if (empty($rgbJj)) { return Response::generate(-1, '图片数据为空'); } goto FXp2C; ajUJ9: $LjdCn = DataManager::upload('image', 'U' . $klMu7 . '_AvatarMiddle.' . $XIHmb, $pIVV2, null, $BVqCD); goto SnsjR; HG0Uf: return Response::generateSuccess(); goto LOPpb; WqJiy: $Ct4d1 = DataManager::upload('image', 'U' . $klMu7 . '_AvatarBig.' . $XIHmb, $x8CUD, null, $BVqCD); goto D1kWa; Upbg1: self::update($J09PA['id'], array('avatarBig' => $Ct4d1['data']['fullPath'], 'avatarMedium' => $LjdCn['data']['fullPath'], 'avatar' => $Ecj99['data']['fullPath'])); goto HG0Uf; Q_pvV: $CzRaU = (string) Image::make($rgbJj)->resize(50, 50)->encode($XIHmb, 75); goto c6Ha6; c6Ha6: $BVqCD = array('eventOpt' => array(DataFileUploadedEvent::OPT_IMAGE_COMPRESS_IGNORE => true, DataFileUploadedEvent::OPT_IMAGE_WATERMARK_IGNORE => true)); goto WqJiy; Hjnuu: $pIVV2 = (string) Image::make($rgbJj)->resize(200, 200)->encode($XIHmb, 75); goto Q_pvV; D1kWa: if ($Ct4d1['code']) { return Response::generate(-1, '头像存储失败（' . $Ct4d1['msg'] . '）'); } goto ajUJ9; LOPpb: } public static function findUsers($HtTng) { goto dHWuD; RL6nL: $sHpVc = ModelUtil::model('member_user')->whereIn('id', $HtTng)->get(); goto U6gxY; ECuXx: $NQnt0 = array(); goto RL6nL; dHWuD: if (empty($HtTng)) { return array(); } goto ECuXx; U6gxY: foreach ($sHpVc as &$tsyd0) { $NQnt0[$tsyd0->id] = $tsyd0->toArray(); } goto EXH54; EXH54: return $NQnt0; goto zLUQk; zLUQk: } public static function filterUserIds($HtTng) { goto MYSPk; Jwq_I: foreach ($sHpVc as &$tsyd0) { $z0UO7[$tsyd0->id] = true; } goto jY9LS; MYSPk: if (empty($HtTng)) { return array(); } goto x7z1r; jY9LS: return array_keys($z0UO7); goto RpQsf; x7z1r: $z0UO7 = array(); goto bmwZD; bmwZD: $sHpVc = ModelUtil::model('member_user')->whereIn('id', $HtTng)->get(array('id')); goto Jwq_I; RpQsf: } public static function mergeMemberUsers(&$XsrNI, $OOtbF = 'memberUserId', $sLYpU = '_memberUser') { ModelUtil::join($XsrNI, $OOtbF, $sLYpU, 'member_user', 'id'); } public static function mergeMemberUserBasics(&$XsrNI, $OOtbF = 'memberUserId', $sLYpU = '_memberUser', $BsRJ4 = null) { $BsRJ4 = self::processBasicFields($BsRJ4); if (is_array($XsrNI)) { ModelUtil::join($XsrNI, $OOtbF, $sLYpU, 'member_user', 'id'); foreach ($XsrNI as $MFVkb => $YxV2x) { goto pgFlx; cjJwD: if (empty($J09PA['avatar'])) { $J09PA['avatar'] = AssetsUtil::fixFull('asset/image/avatar.svg'); } else { $J09PA['avatar'] = AssetsUtil::fixFull($J09PA['avatar']); } goto qOtbY; PhPJU: $J09PA = ArrayUtil::keepKeys($YxV2x[$sLYpU], $BsRJ4); goto MSiJJ; MSiJJ: if (empty($J09PA['nickname'])) { $J09PA['nickname'] = $J09PA['username']; } goto cjJwD; pgFlx: if (empty($YxV2x[$sLYpU])) { continue; } goto PhPJU; qOtbY: $XsrNI[$MFVkb][$sLYpU] = $J09PA; goto MC9NV; MC9NV: } } else { ModelUtil::joinItems($XsrNI, $OOtbF, $sLYpU, 'member_user', 'id'); foreach ($XsrNI as $Z32UA) { goto sxbuA; sxbuA: if (empty($Z32UA->{$sLYpU})) { continue; } goto xX97S; xX97S: $J09PA = ArrayUtil::keepKeys($Z32UA->{$sLYpU}, $BsRJ4); goto cnZEu; cnZEu: if (empty($J09PA['nickname'])) { $J09PA['nickname'] = $J09PA['username']; } goto dLvGx; tflKb: $Z32UA->{$sLYpU} = $J09PA; goto eUpSH; dLvGx: if (empty($J09PA['avatar'])) { $J09PA['avatar'] = AssetsUtil::fixFull('asset/image/avatar.svg'); } else { $J09PA['avatar'] = AssetsUtil::fixFull($J09PA['avatar']); } goto tflKb; eUpSH: } } } public static function insert($Pg57y) { return ModelUtil::insert('member_user', $Pg57y); } public static function getIdByOauth($gM10z, $iMnLx) { goto l4ReE; l4ReE: $nnCtx = ModelUtil::get('member_oauth', array('type' => $gM10z, 'openId' => $iMnLx)); goto Zum2c; Zum2c: if (empty($nnCtx)) { return 0; } goto OzFQr; OzFQr: return intval($nnCtx['memberUserId']); goto gwj76; gwj76: } public static function getIdByOauthAndCheck($gM10z, $iMnLx) { goto ygHDg; ygHDg: $d4RRw = self::getIdByOauth($gM10z, $iMnLx); goto Tp0f1; dRnOC: MemberUtil::forgetOauth($gM10z, $iMnLx); goto MJF3C; MJF3C: return 0; goto r35oX; Tp0f1: if (self::get($d4RRw)) { return $d4RRw; } goto dRnOC; r35oX: } public static function getOauthOpenId($d4RRw, $gM10z) { goto XMip3; XMip3: $HBsr7 = array('memberUserId' => $d4RRw, 'type' => $gM10z); goto kO1lo; H1VAi: if (empty($nnCtx)) { return null; } goto jPk2o; jPk2o: return $nnCtx['openId']; goto FRBuk; kO1lo: $nnCtx = ModelUtil::get('member_oauth', $HBsr7); goto H1VAi; FRBuk: } public static function getOauth($d4RRw, $gM10z) { $HBsr7 = array('memberUserId' => $d4RRw, 'type' => $gM10z); return ModelUtil::get('member_oauth', $HBsr7); } public static function listOauths($d4RRw) { return ModelUtil::all('member_oauth', array('memberUserId' => $d4RRw), array('*'), array('type', 'asc')); } public static function putOauth($d4RRw, $gM10z, $iMnLx, $PbcSo = array()) { goto WVLsy; lBI8W: $EUGER = array_merge(array('openId' => $iMnLx), $PbcSo); goto qKsP3; M3ZAY: $nnCtx = ModelUtil::get('member_oauth', $HBsr7); goto lBI8W; VHyI7: if (!LockUtil::acquire($uuYIJ)) { BizException::throws('正在处理中，请稍后再试'); } goto M3ZAY; oVwRY: $uuYIJ = "MemberOauth:{$d4RRw}"; goto VHyI7; lh899: LockUtil::release($uuYIJ); goto mbDt1; WVLsy: $HBsr7 = array('memberUserId' => $d4RRw, 'type' => $gM10z); goto oVwRY; qKsP3: if (empty($nnCtx)) { ModelUtil::delete('member_oauth', array('type' => $gM10z, 'openId' => $iMnLx)); ModelUtil::insert('member_oauth', array_merge($HBsr7, $EUGER)); } else { if ($nnCtx['openId'] != $iMnLx) { ModelUtil::update('member_oauth', $nnCtx['id'], $EUGER); } } goto lh899; mbDt1: } public static function forgetOauth($gM10z, $iMnLx) { ModelUtil::delete('member_oauth', array('type' => $gM10z, 'openId' => $iMnLx)); } public static function updateNewMessageStatus($d4RRw) { ModelUtil::update('member_user', array('id' => $d4RRw), array('newMessageCount' => ModelUtil::count('member_message', array('userId' => $d4RRw, 'status' => MemberMessageStatus::UNREAD)))); } public static function updateNewChatMsgStatus($d4RRw) { if (modstart_module_enabled('MemberChat')) { ModelUtil::update('member_user', array('id' => $d4RRw), array('newChatMsgCount' => ModelUtil::sum('member_chat', 'unreadMsgCount', array('memberUserId' => $d4RRw)))); } } public static function paginate($j13Tr, $OB9LF, $AQ4wg = array()) { return ModelUtil::paginate('member_user', $j13Tr, $OB9LF, $AQ4wg); } public static function updateStatus($khjor, $Ece4o) { goto Tpc0y; Tpc0y: if (!is_array($khjor)) { $khjor = array($khjor); } goto kCV34; qDj37: ModelUtil::model('member_user')->whereIn('id', $khjor)->update(array('status' => $Ece4o)); goto rfIPD; kCV34: if (empty($khjor)) { return; } goto qDj37; rfIPD: } public static function delete($d4RRw) { goto sYaxS; Khcy7: $mCcAZ = ModelUtil::all('member_oauth', array('memberUserId' => $J09PA['id'])); goto muENd; VUA8M: ModelUtil::insert('member_deleted', array('id' => $J09PA['id'], 'username' => $J09PA['username'], 'phone' => $J09PA['phone'], 'email' => $J09PA['email'], 'content' => json_encode($MPmfx, JSON_UNESCAPED_UNICODE))); goto dal34; dH9du: ModelUtil::transactionBegin(); goto RYBtk; RYBtk: $MPmfx = array(); goto Khcy7; T_TBC: ModelUtil::transactionCommit(); goto Mtf9o; WkdU2: BizException::throwsIfEmpty('用户不存在', $J09PA); goto dH9du; sYaxS: $J09PA = self::get($d4RRw); goto WkdU2; muENd: $MPmfx['oauth'] = ArrayUtil::keepItemsKeys($mCcAZ, array('type', 'openId', 'infoUsername', 'infoAvatar')); goto VUA8M; dal34: ModelUtil::update('member_user', $d4RRw, array('deleteAtTime' => 0, 'isDeleted' => true, 'username' => null, 'phone' => null, 'email' => null)); goto T_TBC; Mtf9o: } public static function fireLogin($d4RRw) { goto WkQpD; OaCZd: ModelUtil::insert('member_login_log', array('memberUserId' => $d4RRw, 'deviceType' => DeviceType::current(), 'ip' => StrUtil::mbLimit($lD1Bs, 20), 'userAgent' => StrUtil::mbLimit(AgentUtil::getUserAgent(), 400))); goto c0muP; sbH1T: ModelUtil::update('member_user', $d4RRw, array('lastLoginTime' => Carbon::now(), 'lastLoginIp' => StrUtil::mbLimit($lD1Bs, 20))); goto OaCZd; WkQpD: $lD1Bs = Request::ip(); goto sbH1T; c0muP: } }