<?php
/**
 * ------------------------ 
 *  版权所有  www.tecmz.com
 *  商业版本请购买正版授权使用
 * ------------------------
*/ namespace Module\Member\Api\Controller; use Illuminate\Support\Facades\Log; use Illuminate\Support\Facades\Session; use Illuminate\Support\Str; use ModStart\Core\Exception\BizException; use ModStart\Core\Input\InputPackage; use ModStart\Core\Input\Request; use ModStart\Core\Input\Response; use ModStart\Core\Util\CurlUtil; use ModStart\Core\Util\EventUtil; use ModStart\Core\Util\FileUtil; use ModStart\Core\Util\StrUtil; use ModStart\Misc\Captcha\CaptchaFacade; use ModStart\Module\ModuleBaseController; use Module\Member\Auth\MemberUser; use Module\Member\Config\MemberOauth; use Module\Member\Events\MemberUserLoginedEvent; use Module\Member\Events\MemberUserLogoutEvent; use Module\Member\Events\MemberUserPasswordResetedEvent; use Module\Member\Events\MemberUserRegisteredEvent; use Module\Member\Oauth\AbstractOauth; use Module\Member\Provider\RegisterProcessor\AbstractMemberRegisterProcessorProvider; use Module\Member\Provider\RegisterProcessor\MemberRegisterProcessorProvider; use Module\Member\Util\MemberUtil; use Module\Member\Util\SecurityUtil; use Module\Vendor\Job\MailSendJob; use Module\Vendor\Job\SmsSendJob; use Module\Vendor\Support\ResponseCodes; use Module\Vendor\Util\SessionUtil; class AuthController extends ModuleBaseController { public function checkRedirectSafety($j1j5n) { goto uFQaH; N0Qeb: $vMBQV = modstart_config('Member_LoginRedirectWhiteList', ''); goto rGmpo; Pl1xG: if ($PbcSo['host'] == Request::domain()) { return; } goto N0Qeb; AZflD: BizException::throws('登录跳转路径异常'); goto RoFUb; IXGC1: if (empty($PbcSo['host'])) { return; } goto Pl1xG; jKgrP: foreach ($vMBQV as $Z32UA) { if ($PbcSo['host'] == $Z32UA) { return; } } goto AZflD; rGmpo: $vMBQV = explode('
', $vMBQV); goto X0GzH; X0GzH: $vMBQV = array_filter($vMBQV); goto jKgrP; ZMUQl: $PbcSo = parse_url($j1j5n); goto IXGC1; uFQaH: if (!modstart_config('Member_LoginRedirectCheckEnable', false)) { return; } goto ZMUQl; RoFUb: } public function oauthTryLogin($gM10z = null) { goto tbheH; U0tTO: if (empty($QtZZ0)) { return Response::generate(-1, '用户授权数据为空'); } goto NrCdk; tbheH: $QtZZ0 = Session::get('oauthUserInfo', array()); goto U0tTO; drYDj: BizException::throwsIfEmpty('授权类型为空', $gM10z); goto P2925; HyDC7: return Response::generate(0, null, array('memberUserId' => 0)); goto cCF6i; P2925: $pArCr = MemberOauth::getOrFail($gM10z); goto LWViR; Q7IV7: BizException::throwsIfResponseError($Ecj99); goto Drcdg; Drcdg: if ($Ecj99['data']['memberUserId'] > 0) { goto jnWdS; dJGJO: Session::forget('oauthUserInfo'); goto gsh3t; jnWdS: Session::put('memberUserId', $Ecj99['data']['memberUserId']); goto rXOWQ; gsh3t: return Response::generateSuccessData(array('memberUserId' => $Ecj99['data']['memberUserId'])); goto zvX7E; rXOWQ: MemberUtil::fireLogin($Ecj99['data']['memberUserId']); goto dJGJO; zvX7E: } goto HyDC7; NrCdk: if (empty($gM10z)) { $Nw6ws = InputPackage::buildFromInput(); $gM10z = $Nw6ws->getTrimString('type'); } goto drYDj; LWViR: $Ecj99 = $pArCr->processTryLogin(array('userInfo' => $QtZZ0)); goto Q7IV7; cCF6i: } public function oauthBind($gM10z = null) { goto WV9pH; cPqOM: $V4l1p = $Nw6ws->getTrimString('captcha'); goto jgbmj; nXfTJ: if ($Ecj99['data']['memberUserId'] > 0) { goto CjESv; CjESv: Session::put('memberUserId', $Ecj99['data']['memberUserId']); goto evkbQ; evkbQ: MemberUtil::fireLogin($Ecj99['data']['memberUserId']); goto XOsOp; XOsOp: Session::forget('oauthUserInfo'); goto j42lK; j42lK: return Response::generateSuccessData(array('memberUserId' => $Ecj99['data']['memberUserId'])); goto vIxQE; vIxQE: } goto umL4H; Nq5lu: if ($Db0bm > 0) { goto Cfw2L; qL967: Session::forget('oauthUserInfo'); goto NdiPl; NdiPl: return Response::generate(0, null, null, $j1j5n); goto PgJ2P; Cfw2L: $Ecj99 = $pArCr->processBindToUser(array('memberUserId' => $Db0bm, 'userInfo' => $QtZZ0)); goto E3uik; E3uik: BizException::throwsIfResponseError($Ecj99); goto qL967; PgJ2P: } goto fJmnV; sxsg4: $FoN15 = $Nw6ws->getEmail('email'); goto Zy4Qd; p2Feq: BizException::throwsIfResponseError($Ecj99); goto nXfTJ; Zy4Qd: $dtCHB = $Nw6ws->getTrimString('emailVerify'); goto cPqOM; WV9pH: $Nw6ws = InputPackage::buildFromInput(); goto q_Bov; qrh12: $cz6lT = $Nw6ws->getPhone('phone'); goto Aejaj; D6xRL: Session::put('memberUserId', $d4RRw); goto YIJLy; gIOig: Session::forget('oauthUserInfo'); goto nPQDm; ahUhO: if (modstart_config('Member_OauthBindPhoneEnable')) { goto wWHCq; CfJng: if (Session::get('oauthBindPhoneVerifyTime') + 60 * 60 < time()) { return Response::generate(-1, '手机验证码已过期'); } goto Tlioc; Tlioc: if ($cz6lT != Session::get('oauthBindPhone')) { return Response::generate(-1, '两次手机不一致'); } goto zh1I5; GyQs_: if ($av2Cm != $PE_YT) { Log::info('Member.OauthBind.PhoneVerifyError - ' . $av2Cm . ' - ' . $PE_YT); return Response::generate(-1, '手机验证码不正确.'); } goto CfJng; wWHCq: if (empty($cz6lT)) { return Response::generate(-1, '请输入手机'); } goto AXtSE; AXtSE: $PE_YT = Session::get('oauthBindPhoneVerify'); goto GyQs_; zh1I5: } goto TLB2g; tRHVI: if (empty($QtZZ0)) { return Response::generate(-1, '用户授权数据为空'); } goto NTGys; nPQDm: return Response::generate(0, null); goto H733g; HHrfI: $Ecj99 = $pArCr->processBindToUser(array('memberUserId' => $d4RRw, 'userInfo' => $QtZZ0)); goto xR7h0; P3U0h: $EUGER = array(); goto U0swG; q_Bov: $j1j5n = $Nw6ws->getTrimString('redirect', modstart_web_url('member')); goto s1MJQ; sctyP: if (preg_match('/^\\d{11}$/', $f6vte)) { return Response::generate(-1, '用户名不能为纯数字'); } goto qrh12; GAcuZ: if (!empty($EUGER)) { MemberUtil::update($d4RRw, $EUGER); } goto HHrfI; umL4H: if (modstart_config()->getWithEnv('registerDisable', false) && !modstart_config()->getWithEnv('registerOauthEnable', false)) { return Response::generate(-1, '用户注册已禁用'); } goto zDIec; HIVxs: $Db0bm = Session::get('memberUserId', 0); goto Nq5lu; TLB2g: if (modstart_config('Member_OauthBindEmailEnable')) { goto Y4M6n; Y4M6n: if (empty($FoN15)) { return Response::generate(-1, '请输入邮箱'); } goto W0DyG; W0DyG: $yPfVx = Session::get('oauthBindEmailVerify'); goto RwPJv; Z892i: if ($FoN15 != Session::get('oauthBindEmail')) { return Response::generate(-1, '两次邮箱不一致'); } goto o5wHx; RwPJv: if ($dtCHB != $yPfVx) { Log::info('Member.OauthBind.EmailVerifyError - ' . $dtCHB . ' - ' . $yPfVx); return Response::generate(-1, '邮箱验证码不正确.'); } goto CoTA0; CoTA0: if (Session::get('oauthBindEmailVerifyTime') + 60 * 60 < time()) { return Response::generate(-1, '邮箱验证码已过期'); } goto Z892i; o5wHx: } goto AfMcu; YIJLy: MemberUtil::fireLogin($d4RRw); goto gIOig; fQvjm: $EUGER['registerIp'] = StrUtil::mbLimit(Request::ip(), 20); goto GAcuZ; jgbmj: if (!Session::get('oauthBindCaptchaPass', false)) { if (!CaptchaFacade::check($V4l1p)) { SessionUtil::atomicProduce('oauthBindCaptchaPassCount', 1); return Response::generate(-1, '请重新进行安全验证'); } } goto v4F5H; xR7h0: BizException::throwsIfResponseError($Ecj99); goto FknRu; FknRu: EventUtil::fire(new MemberUserRegisteredEvent($d4RRw)); goto y3GLV; U0swG: if (modstart_config('Member_OauthBindPhoneEnable')) { $EUGER['phoneVerified'] = true; } goto Oo_1Q; NTGys: $pArCr = MemberOauth::getOrFail($gM10z); goto HIVxs; xoMlQ: if ($Ecj99['code']) { return Response::generate(-1, $Ecj99['msg']); } goto Hli4X; s1MJQ: $gM10z = $Nw6ws->getTrimString('type', $gM10z); goto e1jSI; fJmnV: $Ecj99 = $pArCr->processTryLogin(array('userInfo' => $QtZZ0)); goto p2Feq; Oo_1Q: if (modstart_config('Member_OauthBindEmailEnable')) { $EUGER['emailVerified'] = true; } goto fQvjm; Hli4X: $d4RRw = $Ecj99['data']['id']; goto P3U0h; y3GLV: if (!empty($QtZZ0['avatar'])) { goto VV_0N; mnG0e: $woIL9 = array('jpg', 'jpeg', 'png', 'gif'); goto lynaX; Ghlcw: if (!empty($lfdvH['body'])) { if (empty($XIHmb) && !empty($Ecj99['headerMap']['content-type'])) { $XIHmb = FileUtil::mimeToExt($Ecj99['headerMap']['content-type']); if (!in_array($XIHmb, $woIL9)) { Log::info('Member.Auth.OauthBind.AvatarExtGuessError - ' . $XIHmb . ' - ' . $QtZZ0['avatar']); $XIHmb = null; } } if (!empty($XIHmb)) { MemberUtil::setAvatar($d4RRw, $lfdvH['body'], $XIHmb); } } goto lpmbq; lynaX: if (!in_array($XIHmb, $woIL9)) { Log::info('Member.Auth.OauthBind.AvatarExtError - ' . $XIHmb . ' - ' . $QtZZ0['avatar']); $XIHmb = null; } goto eFUN6; VV_0N: $XIHmb = FileUtil::extension($QtZZ0['avatar']); goto mnG0e; eFUN6: $lfdvH = CurlUtil::get($QtZZ0['avatar'], array(), array('returnHeader' => true)); goto Ghlcw; lpmbq: } goto D6xRL; Aejaj: $av2Cm = $Nw6ws->getTrimString('phoneVerify'); goto sxsg4; AfMcu: $Ecj99 = MemberUtil::register($f6vte, $cz6lT, $FoN15, null, true); goto xoMlQ; zDIec: $f6vte = $Nw6ws->getTrimString('username'); goto xaKvf; v4F5H: if (!SessionUtil::atomicConsume('oauthBindCaptchaPassCount')) { return Response::generate(-1, '请进行安全验证'); } goto ahUhO; xaKvf: if (Str::contains($f6vte, '@')) { return Response::generate(-1, '用户名不能包含特殊字符'); } goto sctyP; e1jSI: $QtZZ0 = Session::get('oauthUserInfo', array()); goto tRHVI; H733g: } public function oauthCallback($gM10z = null, $hy4YA = null) { goto zBdMm; F1pJL: if (!isset($Ecj99['code'])) { return Response::generate(-1, '登录失败(返回结果为空)'); } goto JtWy7; ln2OJ: if (empty($mYPP4)) { return Response::generate(-1, '登录失败(code为空)', null, '/'); } goto OudpZ; SgyGy: Session::put('oauthUserInfo', $v9Evc); goto uD46L; jladO: if ($RzPgc) { Session::put('oauthViewOpenId_' . $gM10z, $v9Evc['openid']); return Response::generateSuccess(); } goto SgyGy; cKx0B: $v9Evc = $Ecj99['data']['userInfo']; goto HIpz3; WVV4h: $Ecj99 = $pArCr->processLogin(array_merge($EPwwc, array('code' => $mYPP4, 'callback' => $hy4YA))); goto F1pJL; x7qQB: if (empty($hy4YA)) { $hy4YA = $Nw6ws->getTrimString('callback', null); } goto uAxx9; ogZVK: if (empty($mYPP4)) { $mYPP4 = $Nw6ws->getTrimString('auth_code'); } goto ln2OJ; uD46L: return Response::generate(0, 'ok', array('user' => $v9Evc)); goto bbfCb; g3loJ: if (empty($gM10z)) { $gM10z = $Nw6ws->getTrimString('type'); } goto x7qQB; j0LiM: $EPwwc = Session::get('oauthLoginParam', array()); goto nlHNM; JtWy7: if (0 != $Ecj99['code']) { return $Ecj99; } goto cKx0B; HIpz3: $RzPgc = $Nw6ws->getBoolean('view', false); goto jladO; uAxx9: $mYPP4 = $Nw6ws->getTrimString('code'); goto ogZVK; zBdMm: $Nw6ws = InputPackage::buildFromInput(); goto g3loJ; OudpZ: $pArCr = MemberOauth::getOrFail($gM10z); goto j0LiM; nlHNM: Session::forget('oauthLoginParam'); goto WVV4h; bbfCb: } public function oauthLogin($gM10z = null, $hy4YA = null) { goto Emu3h; bhd97: $Nw6ws = InputPackage::buildFromInput(); goto CuKD1; oA3bf: Session::put('oauthLoginParam', $EPwwc); goto P3n7_; Z2f1o: return Response::generate(0, 'ok', array('redirect' => $Ecj99['data']['redirect'])); goto WnnNx; P3n7_: $Ecj99 = $pArCr->processRedirect($EPwwc); goto rjuHf; IHrd7: $mm4Rk = $Nw6ws->getBoolean('silence', false); goto gmPZO; Emu3h: if ($DNsJV = modstart_config()->getWithEnv('oauthDisableText')) { return Response::generateError($DNsJV); } goto bhd97; cseME: if (empty($hy4YA)) { $hy4YA = $Nw6ws->getTrimString('callback', 'NO_CALLBACK'); } goto IHrd7; wI7WU: $EPwwc = array('callback' => $hy4YA, 'silence' => $mm4Rk); goto oA3bf; CuKD1: if (empty($gM10z)) { $gM10z = $Nw6ws->getTrimString('type'); } goto cseME; gmPZO: $pArCr = MemberOauth::getOrFail($gM10z); goto wI7WU; rjuHf: BizException::throwsIfResponseError($Ecj99); goto Z2f1o; WnnNx: } public function ssoClientLogoutPrepare() { goto cMLLt; d8txh: if (empty($I4nFx)) { return Response::generate(-1, '请配置 同步登录服务端地址'); } goto gOT1W; K_EWO: $Wob_z = $Nw6ws->getTrimString('domainUrl'); goto QALxs; gOT1W: $j1j5n = $I4nFx . '_logout' . '?' . http_build_query(array('redirect' => $Wob_z . '/sso/client_logout')); goto C51_o; QALxs: $I4nFx = modstart_config('ssoClientServer', ''); goto d8txh; cMLLt: if (!modstart_config('ssoClientEnable', false)) { return Response::generate(-1, '请开启 同步登录客户端'); } goto G3vw6; G3vw6: $Nw6ws = InputPackage::buildFromInput(); goto K_EWO; C51_o: return Response::generate(0, 'ok', array('redirect' => $j1j5n)); goto rOX0X; rOX0X: } public function ssoClientLogout() { goto rGdjj; rGdjj: if (!modstart_config('ssoClientEnable', false)) { return Response::generate(-1, '请开启 同步登录客户端'); } goto Aqycx; Aqycx: Session::forget('memberUserId'); goto zfwqR; zfwqR: return Response::generate(0, 'ok'); goto uUapd; uUapd: } public function ssoServerLogout() { goto tSGlv; qYjXS: return Response::generate(0, 'ok'); goto wXvIy; RUciL: Session::forget('memberUserId'); goto qYjXS; tSGlv: if (!modstart_config('ssoServerEnable', false)) { return Response::generate(-1, '请开启 同步登录服务端'); } goto RUciL; wXvIy: } public function ssoServerSuccess() { goto nps8k; FaW7B: if (empty($u7eXr)) { return Response::generate(-1, '请设置 同步登录服务端通讯秘钥'); } goto dn6ho; TXxyX: $Wob_z = $Nw6ws->getTrimString('domainUrl'); goto Ngt5Z; dPmkj: $feWMc = explode('
', modstart_config('ssoServerClientList', '')); goto pfw48; KMCx7: $hC24A = $Wob_z . '/sso/server'; goto JklSg; jpy23: $j1j5n = $e23f3 . '?server=' . urlencode($hC24A) . '&timestamp=' . $fDxI7 . '&username=' . urlencode(base64_encode($f6vte)) . '&sign=' . $BmaRj; goto iMCdx; nz_RI: $f6vte = $J09PA['username']; goto Ju6xf; Ngt5Z: if (empty($Wob_z) || empty($e23f3)) { return Response::generate(-1, '数据错误'); } goto dPmkj; TufQq: $e23f3 = $Nw6ws->getTrimString('client'); goto TXxyX; nps8k: if (!modstart_config('ssoServerEnable', false)) { return Response::generate(-1, '请开启 同步登录服务端'); } goto wB69V; Ane3O: if (!$uFI16) { return Response::generate(-1, '数据错误(2)'); } goto KMCx7; Zu5iD: $u7eXr = modstart_config('ssoServerSecret'); goto FaW7B; lYGYj: foreach ($feWMc as $Z32UA) { if (trim($Z32UA) == $e23f3) { $uFI16 = true; } } goto Ane3O; JklSg: $fDxI7 = time(); goto nz_RI; cYJ5p: $J09PA = MemberUtil::get($d4RRw); goto Zu5iD; wB69V: $d4RRw = Session::get('memberUserId', 0); goto u9Nc0; u9Nc0: if (!$d4RRw) { return Response::generate(-1, '未登录'); } goto cYJ5p; Ju6xf: $BmaRj = md5(md5($u7eXr) . md5($fDxI7 . '') . md5($hC24A) . md5($f6vte)); goto jpy23; iMCdx: return Response::generate(0, null, array('redirect' => $j1j5n)); goto JzDdN; dn6ho: $Nw6ws = InputPackage::buildFromInput(); goto TufQq; pfw48: $uFI16 = false; goto lYGYj; JzDdN: } public function ssoServer() { goto B0bYr; Fe850: if (!$uFI16) { return Response::generate(-1, '请在 同步登陆服务端增加客户端地址 ' . $e23f3); } goto b881T; ByCX3: $uFI16 = false; goto nfbTZ; YLF79: if (empty($P5Ym5)) { return Response::generate(-1, '请设置 同步登录服务端通讯秘钥'); } goto QZz2l; QZz2l: $YX_cV = md5(md5($P5Ym5) . md5($fDxI7 . '') . md5($e23f3)); goto jOJoE; Wtl_u: $e23f3 = $Nw6ws->getTrimString('client'); goto CLUtL; KI5X5: if (empty($BmaRj)) { return Response::generate(-1, 'sign 为空'); } goto tzlHr; LUGSX: if (empty($e23f3)) { return Response::generate(-1, 'client 为空'); } goto oWEYi; IrJxa: if (intval(Session::get('memberUserId', 0)) > 0) { $mtHlK = true; } goto O_2NO; b881T: $mtHlK = false; goto IrJxa; Wm919: $feWMc = explode('
', modstart_config('ssoServerClientList', '')); goto ByCX3; F6Dnp: $BmaRj = $Nw6ws->getTrimString('sign'); goto LUGSX; jOJoE: if ($BmaRj != $YX_cV) { return Response::generate(-1, 'sign 错误'); } goto TzdFQ; O_2NO: return Response::generate(0, 'ok', array('isLogin' => $mtHlK)); goto BLN_Q; B0bYr: if (!modstart_config('ssoServerEnable', false)) { return Response::generate(-1, '请开启 同步登录服务端'); } goto rUOI6; oWEYi: if (empty($fDxI7)) { return Response::generate(-1, 'timestamp 为空'); } goto KI5X5; CLUtL: $fDxI7 = $Nw6ws->getInteger('timestamp'); goto F6Dnp; rUOI6: $Nw6ws = InputPackage::buildFromInput(); goto Wtl_u; nfbTZ: foreach ($feWMc as $Z32UA) { if (trim($Z32UA) == $e23f3) { $uFI16 = true; } } goto Fe850; tzlHr: $P5Ym5 = modstart_config('ssoServerSecret'); goto YLF79; TzdFQ: if (abs(time() - $fDxI7) > 3600) { return Response::generate(-1, 'timestamp 错误'); } goto Wm919; BLN_Q: } public function ssoClient() { goto JFZOI; KUiAh: if (empty($I4nFx)) { return Response::generate(-1, '请配置 同步登录服务端地址'); } goto kaEjK; xvkI1: if (empty($eHv_m)) { return Response::generate(-1, '请设置 同步登录客户端通讯秘钥'); } goto Tws2n; HbQDo: if (empty($fDxI7)) { return Response::generate(-1, 'timestamp为空'); } goto lM067; rTt65: $f6vte = @base64_decode($Nw6ws->getTrimString('username')); goto WICyD; kSKB_: if ($hC24A != $I4nFx) { return Response::generate(-1, '同步登录 服务端地址不是配置的' . $I4nFx); } goto R2D_C; Tws2n: $Nw6ws = InputPackage::buildFromInput(); goto W_84l; R2D_C: $J09PA = MemberUtil::getByUsername($f6vte); goto bkFcY; vtBQm: Session::put('memberUserId', $J09PA['id']); goto QPY1t; Tz1qD: if ($BmaRj != $YX_cV) { return Response::generate(-1, 'sign错误'); } goto cEwrv; JFZOI: if (!modstart_config('ssoClientEnable', false)) { return Response::generate(-1, '请开启 同步登录客户端'); } goto Qgy2T; Okcy5: $fDxI7 = $Nw6ws->getInteger('timestamp'); goto BoohN; W_84l: $hC24A = $Nw6ws->getTrimString('server'); goto Okcy5; kaEjK: $eHv_m = modstart_config('ssoClientSecret'); goto xvkI1; bkFcY: if (empty($J09PA)) { goto wul9J; eE3E2: if ($Ecj99['code']) { return Response::generate(-1, $Ecj99['msg']); } goto zDv6A; wul9J: $Ecj99 = MemberUtil::register($f6vte, null, null, null, true); goto eE3E2; zDv6A: $J09PA = MemberUtil::get($Ecj99['data']['id']); goto EhV7W; EhV7W: } goto vtBQm; Qgy2T: $I4nFx = modstart_config('ssoClientServer', ''); goto KUiAh; WICyD: if (empty($f6vte)) { return Response::generate(-1, '同步登录返回的用户名为空'); } goto HbQDo; QPY1t: MemberUtil::fireLogin($J09PA['id']); goto VYpQu; lM067: if (empty($BmaRj)) { return Response::generate(-1, 'sign为空'); } goto cugrJ; cEwrv: if (abs(time() - $fDxI7) > 3600) { return Response::generate(-1, 'timestamp错误'); } goto kSKB_; VYpQu: return Response::generate(0, 'ok'); goto OVCGJ; cugrJ: $YX_cV = md5(md5($eHv_m) . md5($fDxI7 . '') . md5($hC24A) . md5($f6vte)); goto Tz1qD; BoohN: $BmaRj = $Nw6ws->getTrimString('sign'); goto rTt65; OVCGJ: } public function ssoClientPrepare() { goto WO4mN; QjYJ2: $Nw6ws = InputPackage::buildFromInput(); goto K2HoI; nJadv: $fDxI7 = time(); goto xehD9; y7H_y: $j1j5n = $I4nFx . '?client=' . urlencode($e23f3) . '&timestamp=' . $fDxI7 . '&sign=' . $BmaRj; goto lWC1D; T3lZq: $eHv_m = modstart_config('ssoClientSecret'); goto QjYJ2; iafMD: $I4nFx = modstart_config('ssoClientServer'); goto T3lZq; WO4mN: if (!modstart_config('ssoClientEnable', false)) { return Response::generate(-1, 'SSO未开启'); } goto iafMD; xehD9: $BmaRj = md5(md5($eHv_m) . md5($fDxI7 . '') . md5($e23f3)); goto y7H_y; K2HoI: $e23f3 = $Nw6ws->getTrimString('client', '/'); goto i51gh; i51gh: if (!Str::endsWith($e23f3, '/sso/client')) { return Response::generate(-1, 'client参数错误'); } goto nJadv; lWC1D: return Response::generate(0, 'ok', array('redirect' => $j1j5n)); goto Ec_O7; Ec_O7: } public function logout() { goto cxmCJ; cxmCJ: $d4RRw = MemberUser::id(); goto Y50rM; UQjAc: if ($d4RRw > 0) { EventUtil::fire(new MemberUserLogoutEvent($d4RRw)); } goto z23nK; Y50rM: Session::forget('memberUserId'); goto UQjAc; z23nK: return Response::generateSuccess(); goto hRSCf; hRSCf: } public function login() { goto oXK5O; xl_8v: $f6vte = $Nw6ws->getTrimString('username'); goto ywrEw; F1z5Q: if (modstart_config('loginCaptchaEnable', false)) { $jYvTb = SecurityUtil::loginCaptchaProvider(); if ($jYvTb) { $Ecj99 = $jYvTb->validate(); if (Response::isError($Ecj99)) { return Response::generate(-1, $Ecj99['msg']); } } else { if (!CaptchaFacade::check($Nw6ws->getTrimString('captcha'))) { return Response::generate(ResponseCodes::CAPTCHA_ERROR, '登录失败:图片验证码错误', null, '[js]$(\'[data-captcha]\').click();'); } } } goto xhQW_; ywrEw: $iJwHS = $Nw6ws->getTrimString('password'); goto FgSNG; oXK5O: $Nw6ws = InputPackage::buildFromInput(); goto xl_8v; v0vp6: $UUyzt = null; goto Tv7xx; Fw3Xz: return Response::generateSuccess(); goto r9KbM; MyfnS: if (!$J09PA) { $Ecj99 = MemberUtil::login(null, null, $f6vte, $iJwHS); if (0 == $Ecj99['code']) { $J09PA = $Ecj99['data']; } } goto o6_DK; o6_DK: if (!$J09PA) { $Q9Tp9 = Session::pull('memberUserLoginFailedTip', null); return Response::generate(ResponseCodes::CAPTCHA_ERROR, '登录失败:用户或密码错误' . ($Q9Tp9 ? '，' . $Q9Tp9 : '')); } goto pKqPs; Jiyu2: MemberUtil::fireLogin($J09PA['id']); goto CTGPo; FgSNG: if (empty($f6vte)) { return Response::generate(-1, '请输入用户'); } goto FQgLk; pKqPs: Session::put('memberUserId', $J09PA['id']); goto Jiyu2; CTGPo: EventUtil::fire(new MemberUserLoginedEvent($J09PA['id'])); goto Fw3Xz; xhQW_: $J09PA = null; goto v0vp6; wRjr0: if (!$J09PA) { $Ecj99 = MemberUtil::login(null, $f6vte, null, $iJwHS); if (0 == $Ecj99['code']) { $J09PA = $Ecj99['data']; } } goto MyfnS; Tv7xx: if (!$J09PA) { $Ecj99 = MemberUtil::login($f6vte, null, null, $iJwHS); if (0 == $Ecj99['code']) { $J09PA = $Ecj99['data']; } } goto wRjr0; FQgLk: if (empty($iJwHS)) { return Response::generate(-1, '请输入密码'); } goto F1z5Q; r9KbM: } public function loginCaptchaRaw() { return CaptchaFacade::create('default'); } public function loginPhoneCaptchaRaw() { return CaptchaFacade::create('default'); } public function loginPhone() { goto vY2K4; hEkeX: if (empty($J09PA) && modstart_config('Member_LoginPhoneAutoRegister', false)) { goto w0wug; yMd87: Session::forget('registerCaptchaPass'); goto DOW7h; vmWu4: $EUGER = array(); goto icbmk; wG3An: $d4RRw = $Ecj99['data']['id']; goto njhDX; DOW7h: foreach (MemberRegisterProcessorProvider::listAll() as $O9Vtg) { $O9Vtg->postProcess($d4RRw); } goto odYMg; w0wug: foreach (MemberRegisterProcessorProvider::listAll() as $O9Vtg) { $Ecj99 = $O9Vtg->preCheck(); if (Response::isError($Ecj99)) { return $Ecj99; } } goto AUB8o; AUB8o: $Ecj99 = MemberUtil::register(null, $cz6lT, null, null, true); goto yYlzI; yYlzI: if ($Ecj99['code']) { return Response::generate(-1, $Ecj99['msg']); } goto wG3An; vPVCH: EventUtil::fire(new MemberUserRegisteredEvent($d4RRw)); goto yMd87; odYMg: $J09PA = MemberUtil::get($d4RRw); goto dHg2d; njhDX: MemberUtil::autoSetUsernameNickname($d4RRw, modstart_config('Member_LoginPhoneNameSuggest', '用户')); goto vmWu4; xwX1e: if (!empty($EUGER)) { MemberUtil::update($d4RRw, $EUGER); } goto vPVCH; gbYNF: $EUGER['registerIp'] = StrUtil::mbLimit(Request::ip(), 20); goto xwX1e; icbmk: $EUGER['phoneVerified'] = true; goto gbYNF; dHg2d: } goto mZ_Uv; uNNw9: Session::forget('loginPhone'); goto FCc9o; r_PQm: $J09PA = MemberUtil::getByPhone($cz6lT); goto hEkeX; xnrRu: if (Session::get('loginPhoneVerifyTime') + 60 * 60 < time()) { return Response::generate(0, '手机验证码已过期'); } goto eX42l; SX6M4: $BTb3P = Session::get('loginPhoneVerify'); goto cmagH; v_tVf: $Nw6ws = InputPackage::buildFromInput(); goto QdbYK; mZ_Uv: if (empty($J09PA)) { return Response::generate(-1, '手机没有绑定任何账号'); } goto lJ3cY; S2Tgc: MemberUtil::fireLogin($J09PA['id']); goto JOV3k; IMbG3: if (empty($cz6lT)) { return Response::generate(-1, '手机为空或不正确'); } goto sybAt; sybAt: if (empty($s8_k3)) { return Response::generate(-1, '验证码不能为空'); } goto SX6M4; RhVS6: $s8_k3 = $Nw6ws->getTrimString('verify'); goto IMbG3; cmagH: if ($s8_k3 != $BTb3P) { Log::info('Member.LoginPhone.LoginVerifyError - ' . $s8_k3 . ' - ' . $BTb3P); return Response::generate(-1, '手机验证码不正确'); } goto xnrRu; PPcjk: return Response::generate(0, null); goto IxVZQ; FCc9o: Session::put('memberUserId', $J09PA['id']); goto S2Tgc; lJ3cY: Session::forget('loginPhoneVerify'); goto Nphx0; JOV3k: EventUtil::fire(new MemberUserLoginedEvent($J09PA)); goto PPcjk; QdbYK: $cz6lT = $Nw6ws->getPhone('phone'); goto RhVS6; Nphx0: Session::forget('loginPhoneVerifyTime'); goto uNNw9; eX42l: if ($cz6lT != Session::get('loginPhone')) { return Response::generate(-1, '两次手机不一致'); } goto r_PQm; vY2K4: if (!modstart_config('Member_LoginPhoneEnable', false)) { return Response::generate(-1, '手机快捷登录未开启'); } goto v_tVf; IxVZQ: } public function loginPhoneVerify() { goto uPULq; bwpIA: SmsSendJob::create($cz6lT, 'verify', array('code' => $s8_k3)); goto u2KB1; Ylbs2: if (empty($J09PA) && !modstart_config('Member_LoginPhoneAutoRegister', false)) { return Response::generate(-1, '手机没有绑定任何账号'); } goto HGJHX; mCssz: $Nw6ws = InputPackage::buildFromInput(); goto wL1GQ; ycD9s: if (empty($cz6lT)) { return Response::generate(-1, '手机为空或格式不正确'); } goto dQifR; kPCuR: $J09PA = MemberUtil::getByPhone($cz6lT); goto Ylbs2; uPULq: if (!modstart_config('Member_LoginPhoneEnable', false)) { return Response::generate(-1, '手机快捷登录未开启'); } goto mCssz; WkiF0: Session::put('loginPhoneVerify', $s8_k3); goto hKQm4; HGJHX: if (Session::get('loginPhoneVerifyTime') && $cz6lT == Session::get('loginPhone')) { if (Session::get('loginPhoneVerifyTime') + 60 > time()) { return Response::generate(-1, '验证码发送频繁，请稍后再试!'); } } goto rCLWI; u2KB1: return Response::generate(0, '验证码发送成功'); goto zaAtM; wL1GQ: $cz6lT = $Nw6ws->getPhone('target'); goto ycD9s; ZvRFT: Session::put('loginPhone', $cz6lT); goto bwpIA; dQifR: $O9Vtg = SecurityUtil::loginCaptchaProvider(); goto zG9mX; hKQm4: Session::put('loginPhoneVerifyTime', time()); goto ZvRFT; rCLWI: $s8_k3 = rand(100000, 999999); goto WkiF0; zG9mX: if ($O9Vtg) { $Ecj99 = $O9Vtg->validate(); if (Response::isError($Ecj99)) { return $Ecj99; } } else { $V4l1p = $Nw6ws->getTrimString('captcha'); if (!CaptchaFacade::check($V4l1p)) { return Response::generate(-1, '图片验证码错误'); } } goto kPCuR; zaAtM: } public function loginPhoneCaptcha() { $V4l1p = $this->loginCaptchaRaw(); return Response::generate(0, 'ok', array('image' => 'data:image/png;base64,' . base64_encode($V4l1p->getOriginalContent()))); } public function loginCaptcha() { $V4l1p = $this->loginCaptchaRaw(); return Response::generate(0, 'ok', array('image' => 'data:image/png;base64,' . base64_encode($V4l1p->getOriginalContent()))); } public function registerPhone() { goto Yr22T; B37bs: Session::put('memberUserId', $d4RRw); goto Avb4B; ttO1l: if ($cz6lT != Session::get('registerPhone')) { return Response::generate(-1, '两次手机不一致'); } goto B0exi; devH3: if (Session::get('registerPhoneVerifyTime') + 60 * 60 < time()) { return Response::generate(-1, '手机验证码已过期'); } goto ttO1l; oLT2y: $Nw6ws = InputPackage::buildFromInput(); goto mkHpu; ojqLu: $d4RRw = $Ecj99['data']['id']; goto bifpD; Yr22T: if (modstart_config('registerDisable', false)) { return Response::generate(-1, '禁止注册'); } goto Xjx33; g_B6K: EventUtil::fire(new MemberUserLoginedEvent($d4RRw)); goto Kz8sg; cUph8: $av2Cm = $Nw6ws->getTrimString('phoneVerify'); goto BHFD5; vT6RM: $Ecj99 = MemberUtil::register(null, $cz6lT, null, null, true); goto Gm2kG; B0exi: foreach (MemberRegisterProcessorProvider::listAll() as $O9Vtg) { $Ecj99 = $O9Vtg->preCheck(); if (Response::isError($Ecj99)) { return $Ecj99; } } goto vT6RM; ysjES: $EUGER['registerIp'] = StrUtil::mbLimit(Request::ip(), 20); goto Imu_H; cwkh3: $EUGER = array(); goto FrbTO; l_LPC: $cz6lT = $Nw6ws->getPhone('phone'); goto cUph8; Kz8sg: return Response::generate(0, '注册成功', array('id' => $d4RRw)); goto BnzIP; zZ_Ip: $PE_YT = Session::get('registerPhoneVerify'); goto fy7F2; fy7F2: if ($av2Cm != $PE_YT) { Log::info('Member.RegisterPhone.PhoneVerifyError - ' . $av2Cm . ' - ' . $PE_YT); return Response::generate(-1, '手机验证码不正确.'); } goto devH3; Xjx33: if (!modstart_config('Member_RegisterPhoneEnable', false)) { return Response::generate(-1, '手机快速注册未开启'); } goto oLT2y; bifpD: MemberUtil::autoSetUsernameNickname($d4RRw, modstart_config('Member_LoginPhoneNameSuggest', '用户')); goto cwkh3; BHFD5: if (empty($cz6lT)) { return Response::generate(-1, '请输入手机'); } goto zZ_Ip; Mimee: EventUtil::fire(new MemberUserRegisteredEvent($d4RRw)); goto Fpl95; Fpl95: Session::forget('registerCaptchaPass'); goto sQgHS; FrbTO: $EUGER['phoneVerified'] = true; goto ysjES; mkHpu: if (modstart_config('Member_AgreementEnable', false)) { if (!$Nw6ws->getBoolean('agreement')) { return Response::generateError('请先同意 ' . modstart_config('Member_AgreementTitle', '用户使用协议')); } } goto l_LPC; Gm2kG: if ($Ecj99['code']) { return Response::generate(-1, $Ecj99['msg']); } goto ojqLu; Avb4B: MemberUtil::fireLogin($d4RRw); goto g_B6K; sQgHS: foreach (MemberRegisterProcessorProvider::listAll() as $O9Vtg) { $O9Vtg->postProcess($d4RRw); } goto B37bs; Imu_H: if (!empty($EUGER)) { MemberUtil::update($d4RRw, $EUGER); } goto Mimee; BnzIP: } public function register() { goto stW8P; qtILi: if (!SessionUtil::atomicConsume('registerCaptchaPassCount')) { return Response::generate(-1, '请进行安全验证'); } goto Qlv4S; stW8P: if (modstart_config('registerDisable', false)) { return Response::generate(-1, '禁止注册'); } goto go76b; etsZl: return Response::generate(0, '注册成功', array('id' => $d4RRw)); goto DU0Ih; Tz3_L: $f6vte = $Nw6ws->getTrimString('username'); goto Eh00L; RPLGT: if (modstart_config('registerEmailEnable')) { $EUGER['emailVerified'] = true; } goto q3Xkx; VianY: if (modstart_config('registerPhoneEnable')) { $EUGER['phoneVerified'] = true; } goto RPLGT; A1d2B: foreach (MemberRegisterProcessorProvider::listAll() as $O9Vtg) { $Ecj99 = $O9Vtg->preCheck(); if (Response::isError($Ecj99)) { return $Ecj99; } } goto kpRi2; OCDrc: if (modstart_config('registerEmailEnable')) { goto eE9Op; eE9Op: if (empty($FoN15)) { return Response::generate(-1, '请输入邮箱'); } goto pMHf4; pMHf4: $yPfVx = Session::get('registerEmailVerify'); goto op9J7; rGYuB: if ($FoN15 != Session::get('registerEmail')) { return Response::generate(-1, '两次邮箱不一致'); } goto e0xnW; zTMwE: if (Session::get('registerEmailVerifyTime') + 60 * 60 < time()) { return Response::generate(-1, '邮箱验证码已过期'); } goto rGYuB; op9J7: if ($dtCHB != $yPfVx) { Log::info('Member.Register.EmailVerifyError - ' . $dtCHB . ' - ' . $yPfVx); return Response::generate(-1, '邮箱验证码不正确.'); } goto zTMwE; e0xnW: } goto EBkWo; E3h1_: $EUGER = array(); goto VianY; CxxLD: $dtCHB = $Nw6ws->getTrimString('emailVerify'); goto cy5wa; Qlv4S: if (modstart_config('registerPhoneEnable')) { goto BvFL7; Cus5g: $PE_YT = Session::get('registerPhoneVerify'); goto J2I2_; J2I2_: if ($av2Cm != $PE_YT) { Log::info('Member.Register.PhoneVerifyError - ' . $av2Cm . ' - ' . $PE_YT); return Response::generate(-1, '手机验证码不正确.'); } goto L3dFp; L3dFp: if (Session::get('registerPhoneVerifyTime') + 60 * 60 < time()) { return Response::generate(-1, '手机验证码已过期'); } goto yS2QK; BvFL7: if (empty($cz6lT)) { return Response::generate(-1, '请输入手机'); } goto Cus5g; yS2QK: if ($cz6lT != Session::get('registerPhone')) { return Response::generate(-1, '两次手机不一致'); } goto umBi_; umBi_: } goto OCDrc; cy5wa: $iJwHS = $Nw6ws->getTrimString('password'); goto VjHZS; fFG0J: if (preg_match('/^\\d{11}$/', $f6vte)) { return Response::generate(-1, '用户名不能为纯数字'); } goto J0Nv5; OJRaz: $d4RRw = $Ecj99['data']['id']; goto E3h1_; tU1UN: $FoN15 = $Nw6ws->getEmail('email'); goto CxxLD; szKi2: if (empty($f6vte)) { return Response::generate(-1, '用户名不能为空'); } goto NITuU; EBkWo: if (empty($iJwHS)) { return Response::generate(-1, '请输入密码'); } goto nX1Bp; ffJUu: EventUtil::fire(new MemberUserRegisteredEvent($d4RRw)); goto d0XoI; J0Nv5: if (!Session::get('registerCaptchaPass', false)) { if (!CaptchaFacade::check($V4l1p)) { SessionUtil::atomicProduce('registerCaptchaPassCount', 1); return Response::generate(-1, '请重新进行安全验证'); } } goto qtILi; d0XoI: Session::forget('registerCaptchaPass'); goto Ihuyg; jZyyq: $V4l1p = $Nw6ws->getTrimString('captcha'); goto szKi2; uedLv: if (!empty($EUGER)) { MemberUtil::update($d4RRw, $EUGER); } goto ffJUu; q3Xkx: $EUGER['registerIp'] = StrUtil::mbLimit(Request::ip(), 20); goto uedLv; Eh00L: $cz6lT = $Nw6ws->getPhone('phone'); goto V7c0_; VjHZS: $D5WPQ = $Nw6ws->getTrimString('passwordRepeat'); goto jZyyq; Xbelw: if ($Ecj99['code']) { return Response::generate(-1, $Ecj99['msg']); } goto OJRaz; go76b: $Nw6ws = InputPackage::buildFromInput(); goto noodP; V7c0_: $av2Cm = $Nw6ws->getTrimString('phoneVerify'); goto tU1UN; noodP: if (modstart_config('Member_AgreementEnable', false)) { if (!$Nw6ws->getBoolean('agreement')) { return Response::generateError('请先同意 ' . modstart_config('Member_AgreementTitle', '用户使用协议')); } } goto Tz3_L; nX1Bp: if ($iJwHS != $D5WPQ) { return Response::generate(-1, '两次输入密码不一致'); } goto A1d2B; kpRi2: $Ecj99 = MemberUtil::register($f6vte, $cz6lT, $FoN15, $iJwHS); goto Xbelw; NITuU: if (Str::contains($f6vte, '@')) { return Response::generate(-1, '用户名不能包含特殊字符'); } goto fFG0J; Ihuyg: foreach (MemberRegisterProcessorProvider::listAll() as $O9Vtg) { $O9Vtg->postProcess($d4RRw); } goto etsZl; DU0Ih: } public function registerEmailVerify() { goto B6i9r; B6i9r: if (modstart_config('registerDisable', false)) { return Response::generate(-1, '禁止注册'); } goto jaX5t; olLv3: Session::put('registerEmailVerifyTime', time()); goto BtQp1; GUhzH: MailSendJob::create($FoN15, '注册账户验证码', 'verify', array('code' => $s8_k3)); goto SCWWj; Kb6vE: $J09PA = MemberUtil::getByEmail($FoN15); goto LIqy_; jLMNI: return Response::generate(0, '验证码发送成功'); goto WhEsI; hvqJ6: if (!SessionUtil::atomicConsume('registerCaptchaPassCount')) { return Response::generate(-1, '请进行安全验证'); } goto Kb6vE; knHp1: $FoN15 = $Nw6ws->getEmail('target'); goto uZfqT; CUdxr: if (!Session::get('registerCaptchaPass', false)) { return Response::generate(-1, '请先进行安全验证'); } goto hvqJ6; oLS3D: if (Session::get('registerEmailVerifyTime') && $FoN15 == Session::get('registerEmail')) { if (Session::get('registerEmailVerifyTime') + 60 > time()) { return Response::generate(-1, '验证码发送频繁，请稍后再试!'); } } goto zEovR; LIqy_: if (!empty($J09PA)) { return Response::generate(-1, '邮箱已经被占用'); } goto oLS3D; Swq95: $Nw6ws = InputPackage::buildFromInput(); goto knHp1; SCWWj: Session::put('registerEmailVerify', $s8_k3); goto olLv3; zEovR: $s8_k3 = rand(100000, 999999); goto GUhzH; jaX5t: if (!modstart_config('registerEmailEnable')) { return Response::generate(-1, '注册未开启邮箱'); } goto Swq95; BtQp1: Session::put('registerEmail', $FoN15); goto jLMNI; uZfqT: if (empty($FoN15)) { return Response::generate(-1, '邮箱不能为空'); } goto CUdxr; WhEsI: } public function registerPhoneVerify() { goto uz0O6; hwgt4: if (!Session::get('registerCaptchaPass', false)) { return Response::generate(-1, '请先进行安全验证'); } goto BLw0h; uci3t: Session::put('registerPhoneVerifyTime', time()); goto LFNk1; KXJXP: $cz6lT = $Nw6ws->getPhone('target'); goto GY3Uj; BLw0h: if (!SessionUtil::atomicConsume('registerCaptchaPassCount')) { return Response::generate(-1, '请进行安全验证'); } goto A3kIR; uZapa: Session::put('registerPhoneVerify', $s8_k3); goto uci3t; exUQs: $s8_k3 = rand(100000, 999999); goto fCjBH; N7G0g: if (!empty($J09PA)) { return Response::generate(-1, '手机已经被占用'); } goto dlbCR; GY3Uj: if (empty($cz6lT)) { return Response::generate(-1, '手机不能为空'); } goto hwgt4; V9maL: $Nw6ws = InputPackage::buildFromInput(); goto KXJXP; juTmn: return Response::generate(0, '验证码发送成功'); goto wP_ne; A3kIR: $J09PA = MemberUtil::getByPhone($cz6lT); goto N7G0g; LFNk1: Session::put('registerPhone', $cz6lT); goto juTmn; ZhQgd: if (!modstart_config('registerPhoneEnable')) { return Response::generate(-1, '注册未开启手机'); } goto V9maL; fCjBH: SmsSendJob::create($cz6lT, 'verify', array('code' => $s8_k3)); goto uZapa; uz0O6: if (modstart_config('registerDisable', false)) { return Response::generate(-1, '禁止注册'); } goto ZhQgd; dlbCR: if (Session::get('registerPhoneVerifyTime') && $cz6lT == Session::get('registerPhone')) { if (Session::get('registerPhoneVerifyTime') + 60 > time()) { return Response::generate(0, '验证码发送成功!'); } } goto exUQs; wP_ne: } public function registerCaptchaVerify() { goto LD4ny; Eiu4b: SessionUtil::atomicProduce('registerCaptchaPassCount', $CGS6O); goto yCXTZ; RGoFv: if (modstart_config('registerPhoneEnable')) { $CGS6O++; } goto Eiu4b; OW67K: Session::put('registerCaptchaPass', true); goto l397Y; l397Y: $CGS6O = 1; goto JUjqy; LD4ny: $O9Vtg = SecurityUtil::registerCaptchaProvider(); goto EfJw3; JUjqy: if (modstart_config('registerEmailEnable')) { $CGS6O++; } goto RGoFv; EfJw3: if ($O9Vtg) { $Ecj99 = $O9Vtg->validate(); if (Response::isError($Ecj99)) { return $Ecj99; } } else { goto c1W7_; GGJUj: $V4l1p = $Nw6ws->getTrimString('captcha'); goto AJOsL; AJOsL: if (!CaptchaFacade::check($V4l1p)) { SessionUtil::atomicRemove('registerCaptchaPassCount'); return Response::generate(ResponseCodes::CAPTCHA_ERROR, '验证码错误'); } goto ofU9d; c1W7_: $Nw6ws = InputPackage::buildFromInput(); goto GGJUj; ofU9d: } goto OW67K; yCXTZ: return Response::generateSuccess(); goto UtLla; UtLla: } public function oauthBindCaptchaVerify() { goto mgo5R; hJV8x: return Response::generateSuccess(); goto AyPGl; EOrIH: if (!CaptchaFacade::check($V4l1p)) { SessionUtil::atomicRemove('oauthBindCaptchaPassCount'); return Response::generate(ResponseCodes::CAPTCHA_ERROR, '验证码错误'); } goto tQ5Ok; OzXW0: if (modstart_config('Member_OauthBindPhoneEnable')) { $QwOPe++; } goto BFllG; tQ5Ok: Session::put('oauthBindCaptchaPass', true); goto DkllM; Aq2PW: $V4l1p = $Nw6ws->getTrimString('captcha'); goto EOrIH; hQLD7: SessionUtil::atomicProduce('oauthBindCaptchaPassCount', $QwOPe); goto hJV8x; BFllG: if (modstart_config('Member_OauthBindEmailEnable')) { $QwOPe++; } goto hQLD7; mgo5R: $Nw6ws = InputPackage::buildFromInput(); goto Aq2PW; DkllM: $QwOPe = 1; goto OzXW0; AyPGl: } public function oauthBindCaptchaRaw() { return CaptchaFacade::create('default'); } public function oauthBindCaptcha() { goto Fc1ww; Fc1ww: Session::forget('oauthBindCaptchaPass'); goto jxNzj; fItzK: return Response::generate(0, 'ok', array('image' => 'data:image/png;base64,' . base64_encode($V4l1p->getOriginalContent()))); goto H9KVJ; jxNzj: $V4l1p = $this->oauthBindCaptchaRaw(); goto fItzK; H9KVJ: } public function oauthBindEmailVerify() { goto RHmqX; e80tg: Session::put('oauthBindEmail', $FoN15); goto aXddY; X89cl: Session::put('oauthBindEmailVerify', $s8_k3); goto Z_0kZ; ABc87: if (!SessionUtil::atomicConsume('oauthBindCaptchaPassCount')) { return Response::generate(-1, '请进行安全验证'); } goto a7GzZ; NkSpC: if (!empty($J09PA)) { return Response::generate(-1, '邮箱已经被占用'); } goto Sp0Z6; BV92l: $s8_k3 = rand(100000, 999999); goto UMco3; KJkCU: $Nw6ws = InputPackage::buildFromInput(); goto He1fw; Sp0Z6: if (Session::get('oauthBindEmailVerifyTime') && $FoN15 == Session::get('oauthBindEmail')) { if (Session::get('oauthBindEmailVerifyTime') + 60 > time()) { return Response::generate(-1, '验证码发送频繁，请稍后再试!'); } } goto BV92l; He1fw: $FoN15 = $Nw6ws->getEmail('target'); goto lPUp1; lPUp1: if (empty($FoN15)) { return Response::generate(-1, '邮箱不能为空'); } goto ak4Hv; RHmqX: if (!modstart_config('Member_OauthBindEmailEnable')) { return Response::generate(-1, '授权登录未开启邮箱'); } goto KJkCU; a7GzZ: $J09PA = MemberUtil::getByEmail($FoN15); goto NkSpC; aXddY: return Response::generate(0, '验证码发送成功'); goto aEc_6; ak4Hv: if (!Session::get('oauthBindCaptchaPass', false)) { return Response::generate(-1, '请先进行安全验证'); } goto ABc87; Z_0kZ: Session::put('oauthBindEmailVerifyTime', time()); goto e80tg; UMco3: MailSendJob::create($FoN15, '注册账户验证码', 'verify', array('code' => $s8_k3)); goto X89cl; aEc_6: } public function oauthBindPhoneVerify() { goto uWaE8; rGwbV: $cz6lT = $Nw6ws->getPhone('target'); goto LGHOj; gjUwF: if (!SessionUtil::atomicConsume('oauthBindCaptchaPassCount')) { return Response::generate(-1, '请进行安全验证'); } goto TVPqD; GW7K8: $s8_k3 = rand(100000, 999999); goto rOgS4; uWaE8: if (!modstart_config('Member_OauthBindPhoneEnable')) { return Response::generate(-1, '注册未开启手机'); } goto Q8MbD; TVPqD: $J09PA = MemberUtil::getByPhone($cz6lT); goto kuAHW; LOAed: if (!Session::get('oauthBindCaptchaPass', false)) { return Response::generate(-1, '请先进行安全验证'); } goto gjUwF; sjw81: if (Session::get('oauthBindPhoneVerifyTime') && $cz6lT == Session::get('oauthBindPhone')) { if (Session::get('oauthBindPhoneVerifyTime') + 60 > time()) { return Response::generate(0, '验证码发送成功!'); } } goto GW7K8; Q8MbD: $Nw6ws = InputPackage::buildFromInput(); goto rGwbV; E6UYJ: Session::put('oauthBindPhoneVerifyTime', time()); goto a9Okv; hqKZo: Session::put('oauthBindPhoneVerify', $s8_k3); goto E6UYJ; kuAHW: if (!empty($J09PA)) { return Response::generate(-1, '手机已经被占用'); } goto sjw81; xB5Tb: return Response::generate(0, '验证码发送成功'); goto SpL3o; LGHOj: if (empty($cz6lT)) { return Response::generate(-1, '手机不能为空'); } goto LOAed; rOgS4: SmsSendJob::create($cz6lT, 'verify', array('code' => $s8_k3)); goto hqKZo; a9Okv: Session::put('oauthBindPhone', $cz6lT); goto xB5Tb; SpL3o: } public function registerCaptchaRaw() { return CaptchaFacade::create('default'); } public function registerCaptcha() { goto laAZU; MApIb: $V4l1p = $this->registerCaptchaRaw(); goto EsHvi; EsHvi: return Response::generate(0, 'ok', array('image' => 'data:image/png;base64,' . base64_encode($V4l1p->getOriginalContent()))); goto EJaot; laAZU: Session::forget('registerCaptchaPass'); goto MApIb; EJaot: } public function retrievePhone() { goto n5ZGH; irPyB: return Response::generate(0, null); goto RdIQi; frKq7: if (!modstart_config('retrievePhoneEnable', false)) { return Response::generate(-1, '找回密码没有开启'); } goto N6itC; Yw34w: $s8_k3 = $Nw6ws->getTrimString('verify'); goto QjzoS; N6itC: $cz6lT = $Nw6ws->getPhone('phone'); goto Yw34w; gtRiu: $Nw6ws = InputPackage::buildFromInput(); goto frKq7; QjzoS: if (empty($cz6lT)) { return Response::generate(-1, '手机为空或不正确'); } goto qLyrB; PEcWa: Session::put('retrieveMemberUserId', $J09PA['id']); goto irPyB; o3G9O: Session::forget('retrievePhoneVerify'); goto n1uPz; ncO1L: if (Session::get('retrievePhoneVerifyTime') + 60 * 60 < time()) { return Response::generate(0, '手机验证码已过期'); } goto qCBsF; n5ZGH: if (modstart_config('retrieveDisable', false)) { return Response::generate(-1, '找回密码已禁用'); } goto gtRiu; qLyrB: if (empty($s8_k3)) { return Response::generate(-1, '验证码不能为空'); } goto MhLwh; AYRlN: if ($s8_k3 != $BTb3P) { Log::info('Member.RetrievePhone.PhoneVerifyError - ' . $s8_k3 . ' - ' . $BTb3P); return Response::generate(-1, '手机验证码不正确'); } goto ncO1L; K1Snt: Session::forget('retrievePhone'); goto PEcWa; OSQy4: if (empty($J09PA)) { return Response::generate(-1, '手机没有绑定任何账号'); } goto o3G9O; MhLwh: $BTb3P = Session::get('retrievePhoneVerify'); goto AYRlN; qCBsF: if ($cz6lT != Session::get('retrievePhone')) { return Response::generate(-1, '两次手机不一致'); } goto AmWfQ; n1uPz: Session::forget('retrievePhoneVerifyTime'); goto K1Snt; AmWfQ: $J09PA = MemberUtil::getByPhone($cz6lT); goto OSQy4; RdIQi: } public function retrievePhoneVerify() { goto aCY70; aCY70: if (modstart_config('retrieveDisable', false)) { return Response::generate(-1, '找回密码已禁用'); } goto tfKQ_; uvXgJ: if (empty($cz6lT)) { return Response::generate(-1, '手机为空或格式不正确'); } goto i3c6I; tfKQ_: $Nw6ws = InputPackage::buildFromInput(); goto GIbFv; gjBBN: SmsSendJob::create($cz6lT, 'verify', array('code' => $s8_k3)); goto vMDZN; TU1Uu: Session::put('retrievePhone', $cz6lT); goto gjBBN; GIbFv: $cz6lT = $Nw6ws->getPhone('target'); goto uvXgJ; vMDZN: return Response::generate(0, '验证码发送成功'); goto Lybam; EZDg6: Session::put('retrievePhoneVerify', $s8_k3); goto wMKXo; jJD33: if (empty($J09PA)) { return Response::generate(-1, '手机没有绑定任何账号'); } goto mNDcd; wMKXo: Session::put('retrievePhoneVerifyTime', time()); goto TU1Uu; mNDcd: if (Session::get('retrievePhoneVerifyTime') && $cz6lT == Session::get('retrievePhone')) { if (Session::get('retrievePhoneVerifyTime') + 60 * 2 > time()) { return Response::generate(0, '验证码发送成功!'); } } goto DGWSZ; hu1Ng: $J09PA = MemberUtil::getByPhone($cz6lT); goto jJD33; DGWSZ: $s8_k3 = rand(100000, 999999); goto EZDg6; i3c6I: $V4l1p = $Nw6ws->getTrimString('captcha'); goto uknvJ; uknvJ: if (!CaptchaFacade::check($V4l1p)) { return Response::generate(-1, '图片验证码错误'); } goto hu1Ng; Lybam: } public function retrieveEmail() { goto fPlLa; JHUpR: if (empty($s8_k3)) { return Response::generate(-1, '验证码不能为空'); } goto d1_l3; E502y: Session::put('retrieveMemberUserId', $J09PA['id']); goto z4zH7; qoTGO: if (Session::get('retrieveEmailVerifyTime') + 60 * 60 < time()) { return Response::generate(0, '邮箱验证码已过期'); } goto Y8Tx9; GtOWz: if ($s8_k3 != $BTb3P) { Log::info('Member.RetrieveEmail.PhoneVerifyError - ' . $s8_k3 . '- ' . $BTb3P); return Response::generate(-1, '邮箱验证码不正确'); } goto qoTGO; UI_gm: if (!modstart_config('retrieveEmailEnable', false)) { return Response::generate(-1, '找回密码没有开启'); } goto zSEzE; jMPhe: if (empty($J09PA)) { return Response::generate(-1, '邮箱没有绑定任何账号'); } goto A8A_V; Y8Tx9: if ($FoN15 != Session::get('retrieveEmail')) { return Response::generate(-1, '两次邮箱不一致'); } goto JDHq4; d1_l3: $BTb3P = Session::get('retrieveEmailVerify'); goto GtOWz; biHh4: $FoN15 = $Nw6ws->getEmail('email'); goto IjiaS; IjiaS: $s8_k3 = $Nw6ws->getTrimString('verify'); goto iBOXV; A8A_V: Session::forget('retrieveEmailVerify'); goto Hpuyk; Hpuyk: Session::forget('retrieveEmailVerifyTime'); goto Hkga7; z4zH7: return Response::generate(0, null); goto z28VZ; iBOXV: if (empty($FoN15)) { return Response::generate(-1, '邮箱为空或格式不正确'); } goto JHUpR; fPlLa: if (modstart_config('retrieveDisable', false)) { return Response::generate(-1, '找回密码已禁用'); } goto UI_gm; zSEzE: $Nw6ws = InputPackage::buildFromInput(); goto biHh4; JDHq4: $J09PA = MemberUtil::getByEmail($FoN15); goto jMPhe; Hkga7: Session::forget('retrieveEmail'); goto E502y; z28VZ: } public function retrieveEmailVerify() { goto quXy9; exkoi: $FoN15 = $Nw6ws->getEmail('target'); goto BrP5B; Bz2yE: $J09PA = MemberUtil::getByEmail($FoN15); goto Io9Hx; P6gDl: $s8_k3 = rand(100000, 999999); goto iBn3K; kTWs4: Session::put('retrieveEmailVerifyTime', time()); goto H9pI2; BrP5B: if (empty($FoN15)) { return Response::generate(-1, '邮箱格式不正确或为空'); } goto kaLI2; kaLI2: $V4l1p = $Nw6ws->getTrimString('captcha'); goto DHaOL; Io9Hx: if (empty($J09PA)) { return Response::generate(-1, '邮箱没有绑定任何账号'); } goto DYC33; iBn3K: MailSendJob::create($FoN15, '找回密码验证码', 'verify', array('code' => $s8_k3)); goto Brvw2; UAKqR: return Response::generate(0, '验证码发送成功'); goto vddR9; H9pI2: Session::put('retrieveEmail', $FoN15); goto UAKqR; quXy9: if (modstart_config('retrieveDisable', false)) { return Response::generate(-1, '找回密码已禁用'); } goto uIsfL; DHaOL: if (!CaptchaFacade::check($V4l1p)) { return Response::generate(-1, '图片验证码错误'); } goto Bz2yE; uIsfL: $Nw6ws = InputPackage::buildFromInput(); goto exkoi; Brvw2: Session::put('retrieveEmailVerify', $s8_k3); goto kTWs4; DYC33: if (Session::get('retrieveEmailVerifyTime') && $FoN15 == Session::get('retrieveEmail')) { if (Session::get('retrieveEmailVerifyTime') + 60 > time()) { return Response::generate(0, '验证码发送成功!'); } } goto P6gDl; vddR9: } public function retrieveResetInfo() { goto poiBp; pRw_8: $J09PA = MemberUtil::get($Kj3nF); goto uU_IQ; Sic3E: if (empty($f6vte)) { $f6vte = $J09PA['phone']; } goto fYWzx; uU_IQ: $f6vte = $J09PA['username']; goto Sic3E; fYWzx: if (empty($f6vte)) { $f6vte = $J09PA['email']; } goto HarJi; FaqbQ: if (empty($Kj3nF)) { return Response::generate(-1, '请求错误'); } goto pRw_8; poiBp: $Kj3nF = Session::get('retrieveMemberUserId'); goto FaqbQ; HarJi: return Response::generate(0, null, array('memberUser' => array('username' => $f6vte))); goto DhMXg; DhMXg: } public function retrieveReset() { goto TUcph; zXkbh: return Response::generate(0, '成功设置新密码,请您登录'); goto rneS0; SpykS: $Ecj99 = MemberUtil::changePassword($J09PA['id'], $iJwHS, null, true); goto E3Ore; qT28v: Session::forget('retrieveMemberUserId'); goto zXkbh; OI7lJ: if ($iJwHS != $D5WPQ) { return Response::generate(-1, '两次输入密码不一致'); } goto Zb2p4; E3Ore: if ($Ecj99['code']) { return Response::generate(-1, $Ecj99['msg']); } goto rZGgx; RJcHX: if (empty($J09PA)) { return Response::generate(-1, '用户不存在'); } goto SpykS; OEMCj: if (empty($Kj3nF)) { return Response::generate(-1, '请求错误'); } goto OoW9W; JF7ZD: $D5WPQ = $Nw6ws->getTrimString('passwordRepeat'); goto CxvPy; GPF6u: $Nw6ws = InputPackage::buildFromInput(); goto d1GE4; CxvPy: if (empty($iJwHS)) { return Response::generate(-1, '请输入密码'); } goto OI7lJ; rZGgx: EventUtil::fire(new MemberUserPasswordResetedEvent($J09PA['id'], $iJwHS)); goto qT28v; d1GE4: $Kj3nF = Session::get('retrieveMemberUserId'); goto OEMCj; OoW9W: $iJwHS = $Nw6ws->getTrimString('password'); goto JF7ZD; TUcph: if (modstart_config('retrieveDisable', false)) { return Response::generate(-1, '找回密码已禁用'); } goto GPF6u; Zb2p4: $J09PA = MemberUtil::get($Kj3nF); goto RJcHX; rneS0: } public function retrieveCaptchaRaw() { return CaptchaFacade::create('default'); } public function retrieveCaptcha() { $V4l1p = $this->retrieveCaptchaRaw(); return Response::generate(0, 'ok', array('image' => 'data:image/png;base64,' . base64_encode($V4l1p->getOriginalContent()))); } }