<?php
/**
 * ------------------------ 
 *  版权所有  www.tecmz.com
 *  商业版本请购买正版授权使用
 * ------------------------
*/ namespace Module\Member\Admin\Controller; use Illuminate\Routing\Controller; use ModStart\Admin\Auth\AdminPermission; use ModStart\Admin\Concern\HasAdminQuickCRUD; use ModStart\Admin\Layout\AdminConfigBuilder; use ModStart\Admin\Layout\AdminCRUDBuilder; use ModStart\Admin\Layout\AdminDialogPage; use ModStart\Core\Assets\AssetsUtil; use ModStart\Core\Dao\ModelUtil; use ModStart\Core\Exception\BizException; use ModStart\Core\Input\InputPackage; use ModStart\Core\Input\Request; use ModStart\Core\Input\Response; use ModStart\Core\Type\TypeUtil; use ModStart\Core\Util\ArrayUtil; use ModStart\Core\Util\ColorUtil; use ModStart\Core\Util\CRUDUtil; use ModStart\Core\Util\EventUtil; use ModStart\Core\Util\RandomUtil; use ModStart\Core\Util\TimeUtil; use ModStart\Field\AbstractField; use ModStart\Field\AutoRenderedFieldValue; use ModStart\Field\Select; use ModStart\Field\Type\FieldRenderMode; use ModStart\Form\Form; use ModStart\Grid\Displayer\ItemOperate; use ModStart\Grid\GridFilter; use ModStart\Module\ModuleManager; use ModStart\Repository\Filter\RepositoryFilter; use ModStart\Support\Concern\HasFields; use ModStart\Widget\TextDialogRequest; use Module\Member\Config\MemberAdminList; use Module\Member\Config\MemberOauth; use Module\Member\Events\MemberUserRegisteredEvent; use Module\Member\Provider\MemberAdminShowPanel\MemberAdminShowPanelProvider; use Module\Member\Type\Gender; use Module\Member\Type\MemberStatus; use Module\Member\Util\MemberGroupUtil; use Module\Member\Util\MemberMessageUtil; use Module\Member\Util\MemberUtil; use Module\Member\Util\MemberVipUtil; use Module\Vendor\QuickRun\Export\ExportHandle; class MemberController extends Controller { use HasAdminQuickCRUD; protected function crud(AdminCRUDBuilder $IuwRA) { $IuwRA->init('member_user')->field(function ($IuwRA) { $IuwRA->id('id', 'ID'); MemberAdminList::callGridField($IuwRA); $IuwRA->display('avatar', '头像')->hookRendering(function (AbstractField $UdGHQ, $Z32UA, $OPJGK) { $HErDc = AssetsUtil::fixOrDefault($Z32UA->avatar, 'asset/image/avatar.svg'); $uwyhu = AssetsUtil::fixOrDefault($Z32UA->avatarBig, 'asset/image/avatar.svg'); return AutoRenderedFieldValue::make("<a href='{$uwyhu}' class='tw-inline-block' data-image-preview>\n                        <img src='{$HErDc}' class='tw-rounded-full tw-w-8 tw-h-8 tw-shadow'></a>"); }); $IuwRA->text('username', '用户名')->required()->ruleUnique('member_user')->hookRendering(function (AbstractField $UdGHQ, $Z32UA, $OPJGK) { switch ($UdGHQ->renderMode()) { case FieldRenderMode::GRID: case FieldRenderMode::DETAIL: return AutoRenderedFieldValue::make(TextDialogRequest::make('primary', htmlspecialchars($Z32UA->username), modstart_admin_url('member/show', array('_id' => $Z32UA->id)))->width('90%')->height('90%')->render()); break; } }); $IuwRA->text('email', '邮箱'); $IuwRA->text('phone', '手机'); $IuwRA->text('nickname', '昵称'); if (MemberOauth::hasEnableItems()) { $IuwRA->display('_oauth', '授权')->hookRendering(function (AbstractField $UdGHQ, $Z32UA, $OPJGK) { $DBCrg = array(); $biXbN = MemberUtil::listOauths($Z32UA->id); foreach ($biXbN as $x043a) { goto cj5qJ; y0D2_: $DBCrg[] = '<a style="color:' . $Njh4L . ';" href="javascript:;" data-tip-popover="' . $WUQUn . '"><i class="iconfont icon-dot"></i></a>'; goto iSjMG; wPpSL: $pArCr = MemberOauth::getByOauthKey($x043a['type']); goto ywcGU; LknHQ: $WUQUn = $x043a['type']; goto wPpSL; BYxPc: if (empty($Njh4L)) { $Njh4L = ColorUtil::pick($x043a['type']); } goto y0D2_; cj5qJ: $Njh4L = null; goto LknHQ; ywcGU: if ($pArCr) { $Njh4L = $pArCr->color(); $WUQUn = $pArCr->title(); } goto BYxPc; iSjMG: } return join('', $DBCrg); }); } $IuwRA->type('status', '状态')->type(MemberStatus::class, array(MemberStatus::NORMAL => 'success', MemberStatus::FORBIDDEN => 'danger'))->required(); $YNLyT = ModuleManager::getModuleConfig('Member', 'groupEnable', false); if ($YNLyT) { $IuwRA->radio('groupId', '分组')->options(MemberGroupUtil::mapIdTitle())->required(); } $lKoew = ModuleManager::getModuleConfig('Member', 'vipEnable', false); if ($lKoew) { $IuwRA->radio('vipId', 'VIP')->options(MemberVipUtil::mapTitle())->required(); $IuwRA->date('vipExpire', 'VIP过期'); } $IuwRA->display('registerIp', '注册IP'); $IuwRA->display('created_at', '注册时间'); $IuwRA->canBatchSelect(true); $IuwRA->batchOperatePrepend('<button class="btn" data-batch-confirm="确认禁用 %d 个用户？" data-batch-operate="' . modstart_admin_url('member/status_forbidden') . '"><i class="iconfont icon-warning"></i> 禁用</button>'); })->repositoryFilter(function (RepositoryFilter $wPpmz) { $wPpmz->where(array('isDeleted' => false)); })->gridFilter(function (GridFilter $wPpmz) { $wPpmz->eq('id', L('ID')); $wPpmz->like('username', '用户名'); $wPpmz->like('email', '邮箱')->autoHide(true); $wPpmz->like('phone', '手机')->autoHide(true); $wPpmz->eq('status', '状态')->autoHide(true)->select(MemberStatus::class); if (ModuleManager::getModuleConfig('Member', 'groupEnable', false)) { $wPpmz->eq('groupId', '分组')->autoHide(true)->select(MemberGroupUtil::mapIdTitle()); } if (ModuleManager::getModuleConfig('Member', 'vipEnable', false)) { $wPpmz->eq('vipId', 'VIP')->autoHide(true)->select(MemberVipUtil::mapTitle()); } })->operateFixed('right')->hookItemOperateRendering(function (ItemOperate $PlL0g) { $Z32UA = $PlL0g->item(); $PlL0g->prepend(TextDialogRequest::make('primary', '查看', modstart_admin_url('member/show', array('_id' => $Z32UA->id)))->width('90%')->height('90%')->render()); })->title('用户管理')->canShow(false)->canDelete(true)->canEdit(false)->canExport(ModuleManager::getModuleConfig('Member', 'exportEnable', false)); } public function selectRemote() { return Select::optionRemoteHandleModel('member_user', 'id', 'username'); } public function add(AdminDialogPage $j13Tr) { goto fXgrW; fXgrW: $s4jIj = Form::make(''); goto KxjuS; um0Hg: $s4jIj->layoutPanel('高级', function (Form $s4jIj) { $s4jIj->text('nickname', '昵称'); $s4jIj->radio('status', '状态')->optionType(MemberStatus::class)->defaultValue(MemberStatus::NORMAL); if (ModuleManager::getModuleConfig('Member', 'groupEnable', false)) { $s4jIj->radio('groupId', '分组')->options(MemberGroupUtil::mapIdTitle())->required(); } if (ModuleManager::getModuleConfig('Member', 'vipEnable', false)) { $s4jIj->radio('vipId', 'VIP')->options(MemberVipUtil::mapTitle())->required(); $s4jIj->date('vipExpire', 'VIP过期'); } }); goto jQLot; jQLot: $s4jIj->showSubmit(false)->showReset(false); goto ghXe9; ghXe9: return $j13Tr->pageTitle('创建用户')->body($s4jIj)->handleForm($s4jIj, function (Form $s4jIj) { AdminPermission::demoCheck(); $Pg57y = $s4jIj->dataForming(); $f6vte = !empty($Pg57y['username']) ? $Pg57y['username'] : null; $cz6lT = !empty($Pg57y['phone']) ? $Pg57y['phone'] : null; $FoN15 = !empty($Pg57y['email']) ? $Pg57y['email'] : null; $iatsk = ArrayUtil::keepKeys($Pg57y, array('nickname', 'groupId', 'status', 'vipId', 'vipExpire')); $Ecj99 = MemberUtil::register($f6vte, $cz6lT, $FoN15, $Pg57y['password']); BizException::throwsIfResponseError($Ecj99); if (!empty($iatsk)) { if (isset($iatsk['vipExpire']) && TimeUtil::isDateEmpty($iatsk['vipExpire'])) { $iatsk['vipExpire'] = null; } MemberUtil::update($Ecj99['data']['id'], $iatsk); } EventUtil::fire(new MemberUserRegisteredEvent($Ecj99['data']['id'])); return Response::redirect(CRUDUtil::jsDialogCloseAndParentGridRefresh()); }); goto BhBGg; KxjuS: $s4jIj->layoutPanel('基础（用户、手机、邮箱不能同时为空）', function (Form $s4jIj) { $s4jIj->text('username', '用户名'); $s4jIj->text('phone', '手机'); $s4jIj->text('email', '邮箱'); $s4jIj->text('password', '初始密码')->defaultValue(RandomUtil::lowerString(8)); }); goto um0Hg; BhBGg: } public function edit(AdminDialogPage $j13Tr) { goto aS2ar; fZJPO: return $j13Tr->pageTitle('修改信息')->body($s4jIj)->handleForm($s4jIj, function (Form $s4jIj) use($J09PA) { AdminPermission::demoCheck(); $Pg57y = $s4jIj->dataForming(); $aaSr5 = ArrayUtil::keepKeys($Pg57y, array('username', 'phone', 'email')); $iatsk = ArrayUtil::keepKeys($Pg57y, array('nickname', 'groupId', 'status', 'vipId', 'vipExpire')); $Ecj99 = MemberUtil::updateBasicWithUniqueCheck($J09PA['id'], $aaSr5); BizException::throwsIfResponseError($Ecj99); if (isset($iatsk['vipExpire']) && TimeUtil::isDateEmpty($iatsk['vipExpire'])) { $iatsk['vipExpire'] = null; } MemberUtil::update($J09PA['id'], $iatsk); return Response::redirect(CRUDUtil::jsDialogCloseAndParentRefresh()); }); goto BjEX9; nkxiL: $s4jIj->showSubmit(false)->showReset(false); goto fZJPO; AGCtB: $s4jIj->layoutPanel('基础', function (Form $s4jIj) { $s4jIj->display('id', '用户ID')->addable(true); $s4jIj->text('username', '用户名'); $s4jIj->text('phone', '手机'); $s4jIj->text('email', '邮箱'); }); goto GmwgR; GmwgR: $s4jIj->layoutPanel('高级', function (Form $s4jIj) { $s4jIj->text('nickname', '昵称'); $s4jIj->radio('status', '状态')->optionType(MemberStatus::class)->defaultValue(MemberStatus::NORMAL); if (ModuleManager::getModuleConfig('Member', 'groupEnable', false)) { $s4jIj->radio('groupId', '分组')->options(MemberGroupUtil::mapIdTitle())->required(); } if (ModuleManager::getModuleConfig('Member', 'vipEnable', false)) { $s4jIj->radio('vipId', 'VIP')->options(MemberVipUtil::mapTitle())->required(); $s4jIj->date('vipExpire', 'VIP过期')->help('VIP过期留空表示永久'); } }); goto o2FxN; R6syg: if (Request::isPost()) { goto vsGgV; vsGgV: AdminPermission::demoCheck(); goto XJzZS; RZZsn: switch ($Nw6ws->getTrimString('_action')) { case 'itemCellEdit': goto wWkiY; xyUxp: switch ($Nw6ws->getTrimString('column')) { case 'status': $EUGER['status'] = $Nw6ws->getInteger('value'); break; } goto vVxym; vVxym: if (!empty($EUGER)) { MemberUtil::update($J09PA['id'], $EUGER); } goto ru1HO; wWkiY: $EUGER = array(); goto xyUxp; ru1HO: return Response::generateSuccess(); goto FbnDH; FbnDH: } goto i_4iX; XJzZS: $Nw6ws = InputPackage::buildFromInput(); goto RZZsn; i_4iX: } goto glX8M; aS2ar: $J09PA = ModelUtil::get('member_user', CRUDUtil::id()); goto KPn97; KPn97: BizException::throwsIfEmpty('用户不存在', $J09PA); goto R6syg; glX8M: $s4jIj = Form::make(''); goto AGCtB; o2FxN: $s4jIj->item($J09PA)->fillFields(); goto nkxiL; BjEX9: } public function select(AdminDialogPage $j13Tr) { goto vrsc2; HuDrc: $ktizU->disableCUD(); goto r6kKO; yhcX3: return $j13Tr->pageTitle('选择用户')->body($ktizU); goto v2HdC; W7KRK: CRUDUtil::registerGridResource($ktizU, '\\' . __CLASS__); goto Wc5Jj; Wc5Jj: if (Request::isPost()) { return $ktizU->request(); } goto yhcX3; vrsc2: $ktizU = $this->grid(); goto HuDrc; r6kKO: $ktizU->canSingleSelectItem(true); goto W7KRK; v2HdC: } public function search() { goto LmGaR; GWxJw: $fFBu8 = MemberUtil::paginate(1, 10, $AQ4wg); goto rI8e0; LmGaR: $Nw6ws = InputPackage::buildFromInput(); goto EM603; vLHX3: return Response::jsonSuccessData($XsrNI); goto XZ4wV; bQk5B: $AQ4wg['whereOperate'] = array('username', 'like', "%{$Ed0Ek}%"); goto GWxJw; rI8e0: $XsrNI = array_map(function ($Z32UA) { return array('value' => intval($Z32UA['id']), 'name' => htmlspecialchars(MemberUtil::viewName($Z32UA)), 'avatar' => AssetsUtil::fixOrDefault($Z32UA['avatar'], 'asset/image/avatar.svg')); }, $fFBu8['records']); goto vLHX3; EM603: $Ed0Ek = $Nw6ws->getTrimString('keywords'); goto K0zSG; K0zSG: $AQ4wg = array(); goto bQk5B; XZ4wV: } public function resetPassword(AdminConfigBuilder $IuwRA) { goto Ox4Rl; eCWm2: return $IuwRA; goto pnS5j; CWvBA: if (Request::isPost()) { return $IuwRA->formRequest(function (Form $s4jIj) use($J09PA) { AdminPermission::demoCheck(); $Pg57y = $s4jIj->dataForming(); $Ecj99 = MemberUtil::changePassword($J09PA['id'], $Pg57y['passwordNew'], null, true); BizException::throwsIfResponseError($Ecj99); return Response::redirect(CRUDUtil::jsDialogClose()); }); } goto eCWm2; jiP8V: $IuwRA->text('passwordNew', '新密码')->required()->defaultValue(RandomUtil::upperString(6)); goto CWvBA; hMz2Y: $IuwRA->useDialog(); goto c4I8J; OT24D: BizException::throwsIfEmpty('用户不存在', $J09PA); goto hMz2Y; c4I8J: $IuwRA->pageTitle('重置密码'); goto jiP8V; KBFz6: $J09PA = MemberUtil::get($M3rBS); goto OT24D; Ox4Rl: $M3rBS = CRUDUtil::id(); goto KBFz6; pnS5j: } public function sendMessage(AdminConfigBuilder $IuwRA) { goto roK50; OSahB: $J09PA = MemberUtil::get($M3rBS); goto JU45T; K8gkr: if (Request::isPost()) { return $IuwRA->formRequest(function (Form $s4jIj) use($J09PA) { AdminPermission::demoCheck(); $Pg57y = $s4jIj->dataForming(); $Ecj99 = MemberMessageUtil::send($J09PA['id'], $Pg57y['content']); BizException::throwsIfResponseError($Ecj99); return Response::redirect(CRUDUtil::jsDialogClose()); }); } goto g6LTj; YlkNu: $IuwRA->pageTitle('发送消息'); goto FxH0B; FxH0B: $IuwRA->richHtml('content', '消息内容')->required(); goto K8gkr; JU45T: BizException::throwsIfEmpty('用户不存在', $J09PA); goto Rzdqu; g6LTj: return $IuwRA; goto L750s; roK50: $M3rBS = CRUDUtil::id(); goto OSahB; Rzdqu: $IuwRA->useDialog(); goto YlkNu; L750s: } public function show() { goto YmoYB; zL3Nh: $u4LeC = MemberAdminShowPanelProvider::listAll(); goto KWxTe; KWxTe: return view('module::Member.View.admin.memberUser.show', array('record' => $HKoLA, 'showPanelProviders' => $u4LeC)); goto g0aX8; YmoYB: $HKoLA = MemberUtil::get(CRUDUtil::id()); goto zL3Nh; g0aX8: } public function delete() { goto afuE8; afuE8: AdminPermission::demoCheck(); goto jEmGS; jEmGS: MemberUtil::delete(CRUDUtil::id()); goto hsdgR; hsdgR: return Response::redirect(CRUDUtil::jsGridRefresh()); goto qsRng; qsRng: } public function statusForbidden() { goto XuBsA; XuBsA: AdminPermission::demoCheck(); goto PLQQ6; PLQQ6: MemberUtil::updateStatus(CRUDUtil::ids(), MemberStatus::FORBIDDEN); goto kj9dT; kj9dT: return Response::redirect(CRUDUtil::jsGridRefresh()); goto vInpq; vInpq: } public function export(ExportHandle $Bp1gR) { $Svpj_ = array('ID', '用户名', '邮箱', '手机', '注册时间', '性别', '姓名', '签名'); return $Bp1gR->withPageTitle('导出用户信息')->withDefaultExportName('用户信息')->withHeadTitles($Svpj_)->handleFetch(function ($j13Tr, $OB9LF, $oHfcx, $EPwwc) { $OZn1D = ModelUtil::model('member_user'); $OZn1D = $OZn1D->where(array('isDeleted' => false))->orderBy('id', 'desc'); foreach ($oHfcx as $vzhPa) { if (!empty($vzhPa['id']['eq'])) { $OZn1D = $OZn1D->where('id', $vzhPa['id']['eq']); } elseif (!empty($vzhPa['status']['eq'])) { $OZn1D = $OZn1D->where('status', $vzhPa['status']['eq']); } elseif (!empty($vzhPa['groupId']['eq'])) { $OZn1D = $OZn1D->where('groupId', $vzhPa['groupId']['eq']); } elseif (!empty($vzhPa['vipId']['eq'])) { $OZn1D = $OZn1D->where('vipId', $vzhPa['vipId']['eq']); } elseif (!empty($vzhPa['username']['like'])) { $OZn1D = $OZn1D->where('username', 'like', '%' . $vzhPa['username']['like'] . '%'); } elseif (!empty($vzhPa['email']['like'])) { $OZn1D = $OZn1D->where('email', 'like', '%' . $vzhPa['email']['like'] . '%'); } elseif (!empty($vzhPa['phone']['like'])) { $OZn1D = $OZn1D->where('phone', 'like', '%' . $vzhPa['phone']['like'] . '%'); } } $s2vPN = $OZn1D->paginate($OB9LF, array('*'), 'page', $j13Tr)->toArray(); $YK6cM = array(); foreach ($s2vPN['data'] as $Z32UA) { goto tri0Q; YTQO5: $dRTD0[] = $Z32UA['email']; goto KMrRQ; TFdQB: $dRTD0[] = $Z32UA['username']; goto YTQO5; xrOPC: $dRTD0[] = $Z32UA['signature']; goto JEoRg; zkIWY: $dRTD0[] = $Z32UA['id']; goto TFdQB; PuMhw: $dRTD0[] = TypeUtil::name(Gender::class, $Z32UA['gender']); goto Yk8q3; JEoRg: $YK6cM[] = $dRTD0; goto f_Mpq; Yk8q3: $dRTD0[] = $Z32UA['realname']; goto xrOPC; KMrRQ: $dRTD0[] = $Z32UA['phone']; goto AgpmF; AgpmF: $dRTD0[] = $Z32UA['created_at']; goto PuMhw; tri0Q: $dRTD0 = array(); goto zkIWY; f_Mpq: } return array('list' => $YK6cM, 'total' => $s2vPN['total']); })->performCommon(); } }