<?php

/*
 * This file is part of the overtrue/wechat.
 *
 * (c) overtrue <i@overtrue.me>
 *
 * This source file is subject to the MIT license that is bundled
 * with this source code in the file LICENSE.
 */
namespace EasyWeChat\Work\GroupRobot;

use Pimple\Container;
use Pimple\ServiceProviderInterface;
/**
 * Class ServiceProvider.
 *
 * @author her-cat <i@her-cat.com>
 */
class ServiceProvider implements ServiceProviderInterface
{
    /**
     * {@inheritdoc}
     */
    public function register(Container $app)
    {
        $app['group_robot'] = function ($app) {
            return new Client($app);
        };
        $app['group_robot_messenger'] = function ($app) {
            return new Messenger($app['group_robot']);
        };
    }
}