<?php
/**
 * ------------------------ 
 *  版权所有  www.tecmz.com
 *  商业版本请购买正版授权使用
 * ------------------------
*/ namespace ModStart\Form; use Closure; use Illuminate\Contracts\Support\Renderable; use Illuminate\Database\Eloquent\Model; use Illuminate\Support\Collection; use Illuminate\Support\Facades\Input; use Illuminate\Support\Str; use Illuminate\Validation\Validator; use ModStart\Core\Dao\DynamicModel; use ModStart\Core\Exception\BizException; use ModStart\Core\Exception\ResultException; use ModStart\Core\Input\InputPackage; use ModStart\Core\Input\Response; use ModStart\Core\Type\SortDirection; use ModStart\Core\Util\CRUDUtil; use ModStart\Core\Util\IdUtil; use ModStart\Core\Util\SerializeUtil; use ModStart\Detail\Detail; use ModStart\Field\AbstractField; use ModStart\Field\AutoRenderedFieldValue; use ModStart\Field\Display; use ModStart\Field\Select; use ModStart\Field\Type\FieldRenderMode; use ModStart\Form\Concern\HasCascadeFields; use ModStart\Form\Type\FormEngine; use ModStart\Form\Type\FormMode; use ModStart\Grid\Concerns\HasSort; use ModStart\Repository\Filter\HasRepositoryFilter; use ModStart\Repository\Filter\HasScopeFilter; use ModStart\Repository\Repository; use ModStart\Repository\RepositoryUtil; use ModStart\Support\Concern\HasBuilder; use ModStart\Support\Concern\HasFields; use ModStart\Support\Concern\HasFluentAttribute; use ModStart\Support\Manager\FieldManager; use stdClass; class Form implements Renderable { use HasFields, HasBuilder, HasFluentAttribute, HasSort, HasCascadeFields, HasScopeFilter, HasRepositoryFilter; public $id; private $repository; private $view = 'modstart::core.form.index'; protected $fluentAttributes = array('engine', 'builder', 'mode', 'title', 'showSubmit', 'showReset', 'itemId', 'item', 'hookSubmitted', 'hookSaving', 'hookSaved', 'hookDeleting', 'hookDeleted', 'hookChanged', 'dataSubmitted', 'dataForming', 'dataAdding', 'dataEditing', 'canAdd', 'canEdit', 'canDelete', 'canSort', 'canCopy', 'sortAddPosition', 'formClass', 'treeMaxLevel', 'treeRootPid', 'formUrl', 'ajax', 'formAttr'); private $engine = 'basic'; private $mode = 'form'; private $title; private $showSubmit = true; private $showReset = true; private $itemId = null; private $item; private $hookSubmitted; private $hookSaving; private $hookSaved; private $hookDeleting; private $hookDeleted; private $hookChanged; private $dataSubmitted; private $dataForming; private $dataAdding; private $dataEditing; private $canAdd = true; private $canEdit = true; private $canDelete = true; private $canSort = false; private $canCopy = false; private $sortAddPosition = false; private $formClass = ''; private $treeMaxLevel = 99; private $treeRootPid = 0; private $formUrl = null; private $ajax = true; private $formAttr = ''; public function __construct($Cxh0W, \Closure $GOTEy = null) { goto dD821; hyZZX: $this->setupFields(); goto QiAVP; dD821: $this->id = IdUtil::generate('Grid'); goto Mg6R2; BM3kE: $this->setupRepositoryFilter(); goto rgx1w; Mg6R2: $this->repository = Repository::instance($Cxh0W); goto hyZZX; QiAVP: $this->fieldDefaultRenderMode(FieldRenderMode::FORM); goto BM3kE; rgx1w: $this->builder($GOTEy); goto q9yKc; q9yKc: } public static function make($Wa8N4 = null, \Closure $GOTEy = null) { if (is_object($Wa8N4) || class_exists($Wa8N4) && is_subclass_of($Wa8N4, Model::class)) { return new Form($Wa8N4, $GOTEy); } return new Form(DynamicModel::make($Wa8N4), $GOTEy); } public function asTree($PkGEp = 'id', $HuEsB = 'pid', $HwF8D = 'sort', $OyJTz = 'title') { goto ElIkp; ElIkp: $this->repository->setKeyName($PkGEp); goto tlu0D; KmTjJ: $this->canSort(true); goto ZLzJo; ZLzJo: return $this; goto hYNSI; Ywomy: $this->repository->setSortColumn($HwF8D); goto LkBRc; LkBRc: $this->repository->setTreeTitleColumn($OyJTz); goto y0Q4F; tlu0D: $this->repository->setTreePidColumn($HuEsB); goto Ywomy; y0Q4F: $this->engine = FormEngine::TREE; goto KmTjJ; hYNSI: } public function asTreeMass($l0KTA = 0, $PkGEp = 'id', $HuEsB = 'pid', $HwF8D = 'sort', $OyJTz = 'title') { goto qGJCr; qGJCr: $this->repository->setKeyName($PkGEp); goto bBvZj; XzhcQ: $this->canSort(true); goto JD41l; HNsNV: $this->repository->setTreeTitleColumn($OyJTz); goto aOK_a; JD41l: return $this; goto PYl4Q; niCXQ: $this->repository->setSortColumn($HwF8D); goto HNsNV; aOK_a: $this->engine = FormEngine::TREE_MASS; goto XzhcQ; bBvZj: $this->repository->setTreePidColumn($HuEsB); goto niCXQ; PYl4Q: } private function build() { $this->runBuilder(); if ($this->engine == FormEngine::TREE) { if ($this->treeMaxLevel > 1) { $dBa7F = FieldManager::make($this, 'select', $this->repository->getTreePidColumn(), L('Parent')); $dBa7F->optionRepositoryTreeItems($this->repository, $this->treeMaxLevel); } else { $dBa7F = FieldManager::make($this, 'hidden', $this->repository->getTreePidColumn(), L('Parent')); $dBa7F->value(0); } $this->prependField($dBa7F); } else { if ($this->engine == FormEngine::TREE_MASS) { goto PdqtB; m3VAe: $dBa7F->addable(true)->editable(true)->listable(false); goto ZVDui; M3ulE: $this->prependField($dBa7F); goto pobz7; PdqtB: $dBa7F = FieldManager::make($this, 'display', $this->repository->getTreePidColumn(), L('Parent')); goto m3VAe; ZVDui: $dBa7F->hookRendering(function (AbstractField $dBa7F, $DUr2V, $kOFY1) { if (empty($DUr2V)) { $tloGv = InputPackage::buildFromInput()->get('_pid', $this->treeRootPid); } else { $tloGv = $DUr2V->{$this->repository->getTreePidColumn()}; } $this->repository()->setArgument('treePid', $tloGv); $U3kuf = $this->repository->getTreeAncestorItems(); $irW2y = array(); $irW2y[] = '<span class="ub-text-muted"><i class="icon iconfont icon-angle-right"></i></span> ' . L('Root'); foreach ($U3kuf as $A0Zrl) { $irW2y[] = '<span class="ub-text-muted"><i class="icon iconfont icon-angle-right"></i></span> ' . htmlspecialchars($A0Zrl->{$this->repository->getTreeTitleColumn()}); } $irW2y[] = '<input type="hidden" name="' . $this->repository->getTreePidColumn() . '" value="' . htmlspecialchars($tloGv) . '" />'; return AutoRenderedFieldValue::make(join('', $irW2y)); }); goto M3ulE; pobz7: } } } public function repository() { return $this->repository; } private function fieldValidateMessages($Px5Cq, $gY_Ck) { goto a3w8V; xYVf0: return $qQcgO; goto aWuI2; YpTSE: if (empty($qQcgO)) { return false; } goto xYVf0; fN1wc: $qQcgO = array(); goto FKS5X; a3w8V: $miFs5 = array(); goto RwnoN; RwnoN: foreach ($Px5Cq as $dBa7F) { if (!($qliMB = $dBa7F->getValidator($gY_Ck))) { continue; } if ($qliMB instanceof Validator) { try { if (!$qliMB->passes()) { $miFs5[] = $qliMB; } } catch (\Exception $l8i0J) { BizException::throws('Form.fieldValidateMessages.Error - ' . SerializeUtil::jsonEncode($qliMB->getRules())); } } } goto fN1wc; FKS5X: foreach ($miFs5 as $qliMB) { foreach ($qliMB->messages()->getMessages() as $NS5_3 => $Jv11J) { $qQcgO[$NS5_3] = $Jv11J; } } goto YpTSE; aWuI2: } private function convertBizExceptionToResponse($W0oQK) { goto Mtu7y; Mtu7y: $VBX5k = $W0oQK->getMessage(); goto twEru; FiE1O: return Response::jsonError($VBX5k); goto RMChO; twEru: $Y2Xu5 = array(array('FieldTooLong:', 'Field %s Too Long'), array('FieldFormatError:', 'Field %s Format Error')); goto BhGtF; BhGtF: foreach ($Y2Xu5 as $AkyhD) { if (Str::startsWith($VBX5k, $AkyhD[0])) { goto avMoQ; avMoQ: list($Wos7B, $br4ul) = explode(':', $VBX5k); goto c0v6Z; ILXSt: if ($dBa7F) { return Response::jsonError(L($AkyhD[1], $dBa7F->label())); } goto fy2Ep; c0v6Z: $dBa7F = $this->getFieldByColumn($br4ul); goto ILXSt; fy2Ep: } } goto FiE1O; RMChO: } private function validateFields($Px5Cq, $nx179) { goto IdJoF; IdJoF: $qk5n6 = array(); goto hWksA; hWksA: if ($FkC4h = $this->fieldValidateMessages($Px5Cq, $nx179)) { $qk5n6 = array_merge($qk5n6, $FkC4h); } goto WluD2; LF1aQ: return Response::generateSuccess(); goto UJytE; WluD2: foreach ($qk5n6 as $NS5_3 => $qQcgO) { foreach ($qQcgO as $BDbmq) { return Response::generateError($BDbmq); } } goto LF1aQ; UJytE: } private function removeReservedFields() { goto VhJgu; JjQQE: $zPnnk = function (AbstractField $dBa7F) use(&$PrFVa) { return in_array($dBa7F->column(), $PrFVa, true) && $dBa7F instanceof \ModStart\Field\Display; }; goto xDRmx; VhJgu: $PrFVa = array($this->repository->getKeyName(), $this->repository->getCreatedAtColumn(), $this->repository->getUpdatedAtColumn()); goto JjQQE; xDRmx: $this->fields = $this->fields()->reject($zPnnk); goto z0Q2N; z0Q2N: } public function hookCall($k_TMY) { if ($k_TMY instanceof Closure) { $nMi2c = call_user_func($k_TMY, $this); if (null !== $nMi2c) { return $nMi2c; } } return Response::generateSuccess(); } public function isModeForm() { return $this->mode === FormMode::FORM; } public function isModeAdd() { return $this->mode === FormMode::ADD; } public function isModeEdit() { return $this->mode === FormMode::EDIT; } public function isModeDelete() { return $this->mode === FormMode::DELETE; } public function formRequest($k_TMY, array $nx179 = null) { goto nf7RF; bCwkD: $this->dataSubmitted = $nx179 ? $nx179 : Input::all(); goto FKBkU; nf7RF: $this->mode(FormMode::FORM); goto SpuwH; FKBkU: try { goto ZjVI8; KmCKG: ResultException::throwsIfFail($this->hookCall($this->hookSaved)); goto WdaP1; T443n: $this->dataForming = array(); goto eZmR2; u3FcS: ResultException::throwsIfFail($this->hookCall($this->hookSaving)); goto WaIEW; WdaP1: ResultException::throwsIfFail($this->hookCall($this->hookChanged)); goto tGwPp; aYiGP: if (null !== $nMi2c) { if (Response::isError($nMi2c)) { return Response::jsonFromGenerate($nMi2c); } } goto KmCKG; QLDJe: return Response::jsonSuccess(L('Save Success')); goto ViwRr; ZjVI8: ResultException::throwsIfFail($this->validateFields($this->addableFields(), $this->dataSubmitted)); goto jgI1c; WDYVt: foreach ($this->addableFields() as $dBa7F) { goto tgC0g; tgC0g: if ($dBa7F->isLayoutField()) { continue; } goto gxXDn; xJg7K: $this->dataForming[$dBa7F->column()] = $VuXfH; goto ZCykQ; gxXDn: $VuXfH = isset($this->dataSubmitted[$dBa7F->column()]) ? $this->dataSubmitted[$dBa7F->column()] : null; goto Mrb3s; dqXBP: $VuXfH = $dBa7F->serializeValue($VuXfH, $dBa7F); goto fGe2D; Mrb3s: $VuXfH = $dBa7F->prepareInput($VuXfH, $this->dataSubmitted); goto dqXBP; fGe2D: if ($dBa7F->hookValueSerialize()) { $VuXfH = call_user_func($dBa7F->hookValueSerialize(), $VuXfH, $dBa7F); } goto xJg7K; ZCykQ: } goto u3FcS; QMVxt: if (!empty($this->dataSubmitted['_redirect'])) { return Response::json(0, null, null, $this->dataSubmitted['_redirect']); } goto QLDJe; eZmR2: $this->removeReservedFields(); goto WDYVt; tGwPp: if (null !== $nMi2c) { return Response::jsonFromGenerate($nMi2c); } goto QMVxt; WaIEW: $nMi2c = call_user_func($k_TMY, $this); goto aYiGP; jgI1c: ResultException::throwsIfFail($this->hookCall($this->hookSubmitted)); goto T443n; ViwRr: } catch (BizException $l8i0J) { return Response::jsonError($l8i0J->getMessage()); } catch (ResultException $l8i0J) { return Response::jsonError($l8i0J->getMessage()); } goto fFkjN; SpuwH: $this->build(); goto bCwkD; fFkjN: } public function add() { goto PcOQo; BQNu2: if ($this->canCopy()) { $quano = CRUDUtil::copyId(); if ($quano) { goto jklJp; kT04V: $xbvF2 = true; goto TDY3k; eRgvr: $this->itemId(0); goto kT04V; jklJp: $this->itemId($quano); goto hduIx; hduIx: $this->item($this->repository()->editing($this)); goto eRgvr; TDY3k: } } goto CvsXz; PcOQo: $this->mode(FormMode::ADD); goto sUljD; sUljD: $xbvF2 = false; goto BQNu2; vsV3q: if ($xbvF2) { $this->fillFields(); } goto mmp4K; mmp4K: return $this; goto uKHUK; CvsXz: $this->build(); goto vsV3q; uKHUK: } public function addRequest(array $nx179 = null) { goto snKW9; KIKSq: try { goto XMVtR; j3RjJ: $this->removeReservedFields(); goto b1nmD; XMVtR: ResultException::throwsIfFail($this->validateFields($this->addableFields(), $this->dataSubmitted)); goto Os_YR; h235m: $this->dataAdding = array(); goto j3RjJ; lTKda: return Response::jsonSuccess(L('Add Success')); goto NE9CB; dS9L1: foreach ($this->addableFields() as $dBa7F) { if ($dBa7F->hookValueSaved()) { call_user_func($dBa7F->hookValueSaved(), $CeOJi, $dBa7F); } } goto c9cG7; Os_YR: ResultException::throwsIfFail($this->hookCall($this->hookSubmitted)); goto h235m; c9cG7: if (!empty($this->dataSubmitted['_redirect'])) { return Response::json(0, null, null, $this->dataSubmitted['_redirect']); } goto lTKda; bV6ez: $CeOJi = $this->repository->add($this); goto dS9L1; b1nmD: foreach ($this->addableFields() as $dBa7F) { goto RdY_8; VI0Od: $VuXfH = $dBa7F->prepareInput($VuXfH, $this->dataSubmitted); goto PpQWn; yDraA: if ($dBa7F->hookValueSerialize()) { $VuXfH = call_user_func($dBa7F->hookValueSerialize(), $VuXfH, $dBa7F); } goto PNJxu; PNJxu: $this->dataAdding[$dBa7F->column()] = $VuXfH; goto qbg93; PpQWn: $VuXfH = $dBa7F->serializeValue($VuXfH, $dBa7F); goto yDraA; IKzlw: $VuXfH = isset($this->dataSubmitted[$dBa7F->column()]) ? $this->dataSubmitted[$dBa7F->column()] : null; goto VI0Od; RdY_8: if ($dBa7F->isLayoutField() || $dBa7F->isCustomField()) { continue; } goto IKzlw; qbg93: } goto bV6ez; NE9CB: } catch (BizException $l8i0J) { return $this->convertBizExceptionToResponse($l8i0J); } catch (ResultException $l8i0J) { return Response::jsonError($l8i0J->getMessage()); } goto J2VIh; nt00N: $this->mode(FormMode::ADD); goto frQVj; frQVj: $this->build(); goto jpOLQ; jpOLQ: $this->dataSubmitted = $nx179 ? $nx179 : Input::all(); goto KIKSq; snKW9: if (!$this->canAdd) { return Response::pagePermissionDenied(); } goto nt00N; J2VIh: } public function edit($CeOJi) { try { goto U_YVk; iYI8b: BizException::throwsIfEmpty(L('Record Not Exists'), $this->item); goto Exigl; Exigl: $this->build(); goto sA0TS; U_YVk: $this->mode(FormMode::EDIT); goto M_uE8; sA0TS: $this->fillFields(); goto EF3a7; GmZHT: $this->item($this->repository()->editing($this)); goto iYI8b; EF3a7: return $this; goto YirI3; M_uE8: $this->itemId($CeOJi); goto GmZHT; YirI3: } catch (BizException $l8i0J) { return Response::sendError($l8i0J->getMessage()); } } public function editRequest($CeOJi, array $nx179 = null) { goto wyCnm; wyCnm: if (!$this->canEdit) { return Response::pagePermissionDenied(); } goto TqfAI; TqfAI: $this->dataSubmitted = $nx179 ? $nx179 : Input::all(); goto Ozka4; Ozka4: try { goto Vlchc; VG9Dc: if (!empty($this->dataSubmitted['_redirect'])) { return Response::json(0, null, null, $this->dataSubmitted['_redirect']); } goto Jx0PK; SG1P7: ResultException::throwsIfFail($this->hookCall($this->hookSubmitted)); goto h39ao; irlYa: $CDUjL = isset($this->dataSubmitted['_action']) ? $this->dataSubmitted['_action'] : null; goto FE31o; Lfdpw: $this->removeReservedFields(); goto irlYa; h39ao: $this->dataEditing = array(); goto Lfdpw; Jx0PK: return Response::jsonSuccess(L('Edit Success')); goto Ar9jZ; BSNX_: $this->repository()->edit($this); goto u2rb8; u2rb8: if ('itemCellEdit' == $CDUjL) { foreach ($this->editableFields() as $dBa7F) { if ($dBa7F->column() == $NS5_3 && $dBa7F->hookValueSaved()) { call_user_func($dBa7F->hookValueSaved(), $this->itemId(), $dBa7F); } } } else { foreach ($this->editableFields() as $dBa7F) { if ($dBa7F->hookValueSaved()) { call_user_func($dBa7F->hookValueSaved(), $this->itemId(), $dBa7F); } } } goto VG9Dc; Vlchc: $this->edit($CeOJi); goto hphAc; FE31o: if ('itemCellEdit' == $CDUjL) { goto ovRNe; ppW_Q: $VuXfH = isset($this->dataSubmitted['value']) ? $this->dataSubmitted['value'] : null; goto p7CeP; ovRNe: $NS5_3 = isset($this->dataSubmitted['column']) ? $this->dataSubmitted['column'] : null; goto ppW_Q; BZ1pG: BizException::throwsIfEmpty('Data Error', $this->dataEditing); goto jXycE; p7CeP: if ($NS5_3) { foreach ($this->editableFields() as $dBa7F) { if ($dBa7F->isLayoutField() || $dBa7F->isCustomField()) { continue; } if ($dBa7F->column() == $NS5_3) { goto hLonG; qibdI: if ($dBa7F->hookValueSerialize()) { $VuXfH = call_user_func($dBa7F->hookValueSerialize(), $VuXfH, $dBa7F); } goto KGak_; hLonG: $VuXfH = $dBa7F->prepareInput($VuXfH, $this->dataSubmitted); goto M2FF5; KGak_: $this->dataEditing[$dBa7F->column()] = $VuXfH; goto zdgkL; zdgkL: break; goto CQxOw; M2FF5: $VuXfH = $dBa7F->serializeValue($VuXfH, $dBa7F); goto qibdI; CQxOw: } } } goto BZ1pG; jXycE: } else { foreach ($this->editableFields() as $dBa7F) { goto LV0eF; SN0G0: $VuXfH = isset($this->dataSubmitted[$dBa7F->column()]) ? $this->dataSubmitted[$dBa7F->column()] : null; goto diKbx; sngrE: $this->dataEditing[$dBa7F->column()] = $VuXfH; goto GLYo3; LV0eF: if ($dBa7F->isLayoutField() || $dBa7F->isCustomField()) { continue; } goto SN0G0; mObLs: $VuXfH = $dBa7F->serializeValue($VuXfH, $dBa7F); goto JyVzc; diKbx: $VuXfH = $dBa7F->prepareInput($VuXfH, $this->dataSubmitted); goto mObLs; JyVzc: if ($dBa7F->hookValueSerialize()) { $VuXfH = call_user_func($dBa7F->hookValueSerialize(), $VuXfH, $dBa7F); } goto sngrE; GLYo3: } } goto BSNX_; hphAc: ResultException::throwsIfFail($this->validateFields($this->editableFields(), $this->dataSubmitted)); goto SG1P7; Ar9jZ: } catch (BizException $l8i0J) { return $this->convertBizExceptionToResponse($l8i0J); } catch (ResultException $l8i0J) { return Response::jsonError($l8i0J->getMessage()); } goto OxZG7; OxZG7: } public function deleteRequest($iUHLt) { goto C5DBO; Jrtd4: $this->mode(FormMode::DELETE); goto iQE62; WLIH9: try { goto MzI7U; y7tG3: $jq2n1 = $this->repository->delete($this, $nx179); goto b0Gn9; JML_d: $this->item($nx179); goto NO86Z; b0Gn9: return Response::jsonSuccess(L('Delete Success')); goto amfJj; NO86Z: $this->itemId(collect($nx179)->map(function ($VL0g3) { return $VL0g3->{$this->repository()->getKeyName()}; })->toArray()); goto y7tG3; MzI7U: $nx179 = $this->repository->deleting($this); goto JML_d; amfJj: } catch (BizException $l8i0J) { return Response::jsonError($l8i0J->getMessage()); } catch (ResultException $l8i0J) { return Response::jsonError($l8i0J->getMessage()); } goto Cytzd; ECZf1: $this->build(); goto WLIH9; C5DBO: if (!$this->canDelete) { return Response::pagePermissionDenied(); } goto Jrtd4; iQE62: $this->itemId($iUHLt); goto ECZf1; Cytzd: } public function sortRequest($iUHLt) { goto i5dID; i5dID: if (!$this->canSort) { return Response::pagePermissionDenied(); } goto fI7_X; P_Dfl: $this->repository->setArgument('direction', $gY_Ck->getType('direction', SortDirection::class)); goto JF69z; Lkwke: $this->itemId($iUHLt); goto NZDoZ; zASAy: try { goto lXARZ; PGSt7: return Response::jsonSuccess(L('Operate Success')); goto K9d3W; ybHVQ: ResultException::throwsIfFail($this->hookCall($this->hookChanged)); goto PGSt7; lXARZ: $jq2n1 = $this->repository->sortEdit($this); goto ybHVQ; K9d3W: } catch (BizException $l8i0J) { return Response::jsonError($l8i0J->getMessage()); } catch (ResultException $l8i0J) { return Response::jsonError($l8i0J->getMessage()); } goto c8d3V; JF69z: $this->build(); goto zASAy; fI7_X: $this->mode(FormMode::SORT); goto Lkwke; NZDoZ: $gY_Ck = InputPackage::buildFromInput(); goto P_Dfl; c8d3V: } public function render() { goto vGorW; RRXIX: return view($this->view, $nx179)->render(); goto enRUH; qz0_X: switch ($this->mode) { case FormMode::FORM: $nx179['fields'] = $this->addableFields(true); break; case FormMode::ADD: goto mPB0W; mPB0W: if (!$this->canAdd) { return Response::pagePermissionDenied(); } goto qG_h2; hEudY: break; goto Jrlu_; qG_h2: $nx179['fields'] = $this->addableFields(true); goto hEudY; Jrlu_: case FormMode::EDIT: goto UClKW; UClKW: if (!$this->canEdit) { return Response::pagePermissionDenied(); } goto NLwMN; NLwMN: $nx179['fields'] = $this->editableFields(true); goto lL77f; lL77f: break; goto CPo9V; CPo9V: default: return Response::sendError('Form.render mode error : ' . $this->mode); } goto a11Xk; vGorW: $nx179 = array(); goto qz0_X; a11Xk: $nx179 = array_merge($this->fluentAttributeVariables(), $nx179); goto RRXIX; enRUH: } public function __call($lrQvV, $wnXyT) { goto WlQyX; Mu33Y: if ($this->isFluentAttribute($lrQvV)) { switch ($lrQvV) { case 'item': if (isset($wnXyT[0]) && is_array($wnXyT[0])) { $wnXyT[0] = RepositoryUtil::itemFromArray($wnXyT[0]); } break; } return $this->fluentAttribute($lrQvV, $wnXyT); } goto inMvf; WlQyX: switch ($lrQvV) { case 'enablePagination': case 'defaultOrder': case 'canShow': case 'canExport': case 'canImport': case 'canBatchDelete': case 'canMultiSelectItem': case 'addBlankPage': case 'editBlankPage': case 'disableCUD': case 'hookItemOperateRendering': case 'addDialogSize': case 'editDialogSize': case 'dialogSizeSmall': case 'gridFilter': case 'gridOperateAppend': case 'bodyAppend': case 'operateFixed': case 'defaultPageSize': case 'pageSizes': case 'canBatchSelect': case 'batchOperatePrepend': case 'gridToolbar': case 'pageJumpEnable': case 'textEdit': case 'gridTableTopView': case 'gridBeforeRequestScriptView': case 'gridRequestScript': case 'useSimple': case 'gridRowCols': return $this; } goto Mu33Y; inMvf: return FieldManager::call($this, $lrQvV, $wnXyT); goto M0m1S; M0m1S: } public function __toString() { try { return $this->render(); } catch (\Exception $l8i0J) { return $l8i0J->getMessage(); } } }