<?php
/**
 * ------------------------ 
 *  版权所有  www.tecmz.com
 *  商业版本请购买正版授权使用
 * ------------------------
*/ namespace Module\Member\Util; use Carbon\Carbon; use Illuminate\Support\Facades\Cache; use Illuminate\Support\Str; use Intervention\Image\Facades\Image; use ModStart\Core\Assets\AssetsUtil; use ModStart\Core\Dao\ModelUtil; use ModStart\Core\Exception\BizException; use ModStart\Core\Input\Request; use ModStart\Core\Input\Response; use ModStart\Core\Util\AgentUtil; use ModStart\Core\Util\ArrayUtil; use ModStart\Core\Util\EncodeUtil; use ModStart\Core\Util\FormatUtil; use ModStart\Core\Util\LockUtil; use ModStart\Core\Util\RandomUtil; use ModStart\Core\Util\SerializeUtil; use ModStart\Core\Util\StrUtil; use ModStart\Data\DataManager; use ModStart\Data\Event\DataFileUploadedEvent; use Module\Member\Events\MemberUserLoginAttemptEvent; use Module\Member\Events\MemberUserLoginFailedEvent; use Module\Member\Type\MemberMessageStatus; use Module\Member\Type\MemberPasswordStrength; use Module\Member\Type\MemberStatus; use Module\Vendor\Type\DeviceType; class MemberUtil { public static function total() { return Cache::remember('MemberUserTotal', 60, function () { return ModelUtil::count('member_user'); }); } public static function get($vWdBd) { return ModelUtil::get('member_user', array('id' => $vWdBd)); } public static function getCached($vWdBd) { return Cache::remember('MemberUser:' . $vWdBd, 60, function () use($vWdBd) { return self::get($vWdBd); }); } public static function processDefault(&$CRCLA) { goto Ajq1f; VUnvS: if (empty($CRCLA['nickname'])) { $CRCLA['nickname'] = $CRCLA['username']; } goto aQo_9; k2brl: if (empty($CRCLA['avatarMedium'])) { $CRCLA['avatarMedium'] = AssetsUtil::fixFull('asset/image/avatar.svg', false); } goto YbXRd; YbXRd: if (empty($CRCLA['avatarBig'])) { $CRCLA['avatarBig'] = AssetsUtil::fixFull('asset/image/avatar.svg', false); } goto jyAhA; aQo_9: if (empty($CRCLA['avatar'])) { $CRCLA['avatar'] = AssetsUtil::fixFull('asset/image/avatar.svg', false); } goto k2brl; Ajq1f: if (empty($CRCLA)) { return; } goto VUnvS; jyAhA: } private static function processBasicFields($U6J0q) { goto LFLbe; RDMDR: return $U6J0q; goto wc3OX; LFLbe: $ZBQQ6 = array('id', 'username', 'avatar', 'created_at', 'signature', 'nickname'); goto PW0BD; PW0BD: if (null === $U6J0q) { $U6J0q = $ZBQQ6; } else { goto svYFA; svYFA: $srxPD = array(); goto a2niV; a2niV: foreach ($U6J0q as $U8G_W) { if ('<basic>' == $U8G_W) { $srxPD = array_merge($srxPD, $ZBQQ6); } else { $srxPD[] = $U8G_W; } } goto Jgtqa; Jgtqa: $U6J0q = $srxPD; goto g1hNg; g1hNg: } goto RDMDR; wc3OX: } public static function fixAvatar($cM3gB) { return AssetsUtil::fixFullOrDefault($cM3gB, 'asset/image/avatar.svg'); } public static function getBasic($vWdBd, $U6J0q = null) { goto ua3_Y; YpnQu: foreach ($U6J0q as $tPK8O) { if (isset($AVLNU[$tPK8O])) { $FEjaa[$tPK8O] = $AVLNU[$tPK8O]; } else { $FEjaa[$tPK8O] = null; } } goto Ul12F; dN8tn: $AVLNU['avatar'] = self::fixAvatar($AVLNU['avatar']); goto FYbEi; xRH_L: $AVLNU = self::get($vWdBd); goto kLyZr; Ul12F: return $FEjaa; goto gf78Y; ua3_Y: $U6J0q = self::processBasicFields($U6J0q); goto xRH_L; kLyZr: if (empty($AVLNU)) { return null; } goto jZakk; jZakk: if (empty($AVLNU['nickname'])) { $AVLNU['nickname'] = $AVLNU['username']; } goto dN8tn; FYbEi: $FEjaa = array(); goto YpnQu; gf78Y: } public static function listViewName($Yb10b) { goto uWpqD; ZHfEL: $u1dS8 = ModelUtil::allIn('member_user', 'id', $Yb10b); goto BCJph; q_dxi: return $PBpnF; goto XfZc1; uWpqD: $PBpnF = array(); goto ZHfEL; BCJph: foreach ($u1dS8 as $CRCLA) { $PBpnF[] = self::viewName($CRCLA); } goto q_dxi; XfZc1: } public static function listUsers($Yb10b) { return ModelUtil::allIn('member_user', 'id', $Yb10b); } public static function convertOneToBasic($CRCLA) { return array('id' => $CRCLA['id'], 'username' => $CRCLA['username'], 'nickname' => empty($CRCLA['nickname']) ? $CRCLA['username'] : $CRCLA['nickname'], 'created_at' => $CRCLA['created_at'], 'signature' => isset($CRCLA['signature']) ? $CRCLA['signature'] : null, 'avatar' => AssetsUtil::fixFullOrDefault($CRCLA['avatar'], 'asset/image/avatar.svg')); } public static function convertToBasic($u1dS8) { return array_map(function ($AVLNU) { return array('id' => $AVLNU['id'], 'username' => $AVLNU['username'], 'nickname' => empty($AVLNU['nickname']) ? $AVLNU['username'] : $AVLNU['nickname'], 'created_at' => $AVLNU['created_at'], 'signature' => isset($AVLNU['signature']) ? $AVLNU['signature'] : null, 'avatar' => AssetsUtil::fixFullOrDefault($AVLNU['avatar'], 'asset/image/avatar.svg')); }, $u1dS8); } public static function listUsersBasic($Yb10b) { return self::convertToBasic(self::listUsers($Yb10b)); } public static function getViewName($vWdBd) { return self::viewName(self::get($vWdBd)); } public static function viewName($CRCLA) { goto jRqQo; jRqQo: if ($CRCLA && is_numeric($CRCLA)) { return self::getViewName($CRCLA); } goto zt8Tp; kRuiK: if (!empty($CRCLA['nickname'])) { return $CRCLA['nickname']; } goto Rbs0k; zt8Tp: if (empty($CRCLA)) { return '-'; } goto kRuiK; Rbs0k: if (!empty($CRCLA['username'])) { return $CRCLA['username']; } goto HVKCb; HVKCb: return "ID-{$CRCLA['id']}"; goto Zih02; Zih02: } public static function update($vWdBd, $XWlC_) { return ModelUtil::update('member_user', array('id' => $vWdBd), $XWlC_); } public static function updateBasicWithUniqueCheck($vWdBd, $XWlC_) { goto Zf0Kj; iiwCG: foreach (array('username' => '用户名', 'phone' => '手机', 'email' => '邮箱') as $E9h4W => $g4cGS) { if (isset($XWlC_[$E9h4W])) { goto ymSZf; ymSZf: if (empty($XWlC_[$E9h4W])) { $XWlC_[$E9h4W] = null; continue; } goto WBvOJ; zWcwO: if (count($VR35a) == 1) { if ($VR35a[0]['id'] != $vWdBd) { return Response::generate(-1, $g4cGS . '重复'); } } goto BOHL5; cFlDn: if (count($VR35a) > 1) { return Response::generate(-1, $g4cGS . '重复'); } goto zWcwO; WBvOJ: $VR35a = ModelUtil::all('member_user', array($E9h4W => $XWlC_[$E9h4W])); goto cFlDn; BOHL5: } } goto UMh8H; GtmLk: return Response::generate(0, 'ok'); goto qTQxc; Zf0Kj: if (empty($XWlC_)) { return Response::generate(0, 'ok'); } goto iiwCG; UMh8H: self::update($vWdBd, $XWlC_); goto GtmLk; qTQxc: } public static function login($c_Qdc = '', $jU6y9 = '', $PcW1B = '', $ESrAL = '') { goto NbitZ; RwNO7: $c_Qdc = trim($c_Qdc); goto fCHSx; QVf1a: $CRCLA = ModelUtil::get('member_user', $VSP7l); goto MxGAP; MxGAP: if (empty($CRCLA)) { return Response::generate(-6, '登录失败:用户名或密码错误'); } goto dglaR; xXApn: if ($CRCLA['password'] != EncodeUtil::md5WithSalt($ESrAL, $CRCLA['passwordSalt'])) { MemberUserLoginFailedEvent::fire($CRCLA['id'], $CRCLA['username'], Request::ip(), AgentUtil::getUserAgent()); return Response::generate(-7, '登录失败:用户名或密码错误'); } goto quGSQ; dglaR: MemberUserLoginAttemptEvent::fire($CRCLA['id'], Request::ip(), AgentUtil::getUserAgent()); goto xXApn; D9x04: if ($PcW1B) { if (!FormatUtil::isEmail($PcW1B)) { return Response::generate(-3, '邮箱格式不正确'); } $VSP7l = array('email' => $PcW1B); } else { if ($jU6y9) { if (!preg_match('/(^1[0-9]{10}$)/', $jU6y9)) { return Response::generate(-4, '手机格式不正确'); } $VSP7l = array('phone' => $jU6y9); } else { if ($c_Qdc) { if (strpos($c_Qdc, '@') !== false) { return Response::generate(-5, '用户名格式不正确'); } $VSP7l = array('username' => $c_Qdc); } } } goto QVf1a; quGSQ: switch ($CRCLA['status']) { case MemberStatus::FORBIDDEN: return Response::generateError(-8, '登录失败:当前用户已被禁用'); } goto OEX0e; fCHSx: if (!($PcW1B || $jU6y9 || $c_Qdc)) { return Response::generate(-1, '所有登录字段均为空'); } goto f15pr; OEX0e: return Response::generateSuccessData($CRCLA); goto ZoOnM; NbitZ: $PcW1B = trim($PcW1B); goto Ic3aI; f15pr: if (!$ESrAL) { return Response::generate(-2, '密码为空'); } goto D9x04; Ic3aI: $jU6y9 = trim($jU6y9); goto RwNO7; ZoOnM: } public static function autoSetUsernameNickname($tJ6XI, $vZ3ep) { goto soYwE; soYwE: $SlCuP = 6; goto ZVd3B; ZVd3B: if (preg_match('/\\{.*\\}/', $vZ3ep)) { goto vVcy7; JwrIp: $vZ3ep = str_replace(array_keys($VQao2), array_values($VQao2), $vZ3ep); goto YY27f; YY27f: $SlCuP = 0; goto fWBHb; vVcy7: $CRCLA = self::get($tJ6XI); goto FdQhx; FdQhx: $VQao2 = array('{Phone}' => $CRCLA['phone'], '{Phone4}' => substr($CRCLA['phone'], 7), '{Uid}' => $CRCLA['id']); goto JwrIp; fWBHb: } goto E5LbT; E5LbT: self::suggestUsernameNickname($tJ6XI, $vZ3ep, $SlCuP); goto xD3Je; xD3Je: } public static function getSuggestUsernameNickname($pb53c) { goto qSsyN; qSsyN: $vZ3ep = $pb53c . Str::random(1); goto CRE2s; CRE2s: for ($k8Rwr = 0; $k8Rwr < 20; $k8Rwr++) { $wC6g2 = ModelUtil::model('member_user')->where(array('username' => $vZ3ep))->orWhere(array('nickname' => $vZ3ep))->first(); if (empty($wC6g2)) { return $vZ3ep; } $vZ3ep = $vZ3ep . Str::random(1); } goto hp46L; hp46L: return $vZ3ep . Str::random(10); goto pxaaf; pxaaf: } private static function suggestUsernameNickname($tJ6XI, $bCQ1H = '用户', $SlCuP = 6) { goto jzFbn; saebL: for ($k8Rwr = 0; $k8Rwr < 20; $k8Rwr++) { $wC6g2 = ModelUtil::model('member_user')->where(array('username' => $vZ3ep))->orWhere(array('nickname' => $vZ3ep))->first(); if (empty($wC6g2)) { break; } $vZ3ep = $vZ3ep . Str::random(1); } goto aFB1c; jzFbn: if ($SlCuP > 0) { $vZ3ep = $bCQ1H . RandomUtil::string($SlCuP); } else { $vZ3ep = $bCQ1H; } goto saebL; aFB1c: ModelUtil::update('member_user', $tJ6XI, array('username' => $vZ3ep, 'nickname' => $vZ3ep)); goto JvjfJ; JvjfJ: } public static function registerId($vWdBd, $XWlC_ = array()) { $CRCLA = ModelUtil::insert('member_user', array_merge(array('id' => $vWdBd, 'status' => MemberStatus::NORMAL, 'vipId' => MemberVipUtil::defaultVipId(), 'groupId' => MemberGroupUtil::defaultGroupId(), 'isDeleted' => false), $XWlC_)); return Response::generate(0, 'ok', $CRCLA); } public static function registerUsername($c_Qdc) { return self::register($c_Qdc, '', '', '', true); } public static function registerUsernameQuick($c_Qdc) { goto wnMw6; kKvTP: return Response::generateError('注册失败'); goto L_tKz; wnMw6: $ZNp6H = $c_Qdc; goto RgZCU; RgZCU: for ($k8Rwr = 0; $k8Rwr < 10; $k8Rwr++) { $FZUh3 = self::register($ZNp6H, '', '', '', true); if ($FZUh3['code']) { $ZNp6H = $ZNp6H . Str::random(1); } else { return $FZUh3; } } goto kKvTP; L_tKz: } public static function register($c_Qdc = '', $jU6y9 = '', $PcW1B = '', $ESrAL = '', $LtExL = false) { goto YaYfq; YaYfq: $PcW1B = trim($PcW1B); goto WirtZ; WirtZ: $jU6y9 = trim($jU6y9); goto DlDNL; ajizd: if (!$LtExL) { goto FsPTJ; OKob_: if (Response::isError($FZUh3)) { return Response::generate(-1, $FZUh3['msg']); } goto enfgP; D69YR: $FZUh3 = self::passwordStrengthCheck($ESrAL); goto OKob_; FsPTJ: if (empty($ESrAL)) { return Response::generate(-3, '密码不合法'); } goto D69YR; enfgP: } goto g7kmJ; g7kmJ: $Hp0Da = Str::random(16); goto Xds0C; DlDNL: $c_Qdc = trim($c_Qdc); goto BroCk; vzd1z: if ($PcW1B) { $FZUh3 = self::uniqueCheck('email', $PcW1B); if ($FZUh3['code']) { return $FZUh3; } } else { $PcW1B = null; } goto hACYK; Xds0C: $CRCLA = ModelUtil::insert('member_user', array('status' => MemberStatus::NORMAL, 'username' => $c_Qdc, 'email' => $PcW1B, 'phone' => $jU6y9, 'password' => $LtExL ? null : EncodeUtil::md5WithSalt($ESrAL, $Hp0Da), 'passwordSalt' => $LtExL ? null : $Hp0Da, 'vipId' => MemberVipUtil::defaultVipId(), 'groupId' => MemberGroupUtil::defaultGroupId(), 'isDeleted' => false)); goto SDYR8; hACYK: if ($jU6y9) { $FZUh3 = self::uniqueCheck('phone', $jU6y9); if ($FZUh3['code']) { return $FZUh3; } } else { $jU6y9 = null; } goto vJYqf; SDYR8: return Response::generate(0, 'ok', $CRCLA); goto oFd0V; vJYqf: if ($c_Qdc) { goto c2tIy; gDGJR: if (strlen($c_Qdc) < modstart_config('Member_UsernameMinLength', 3)) { return Response::generate(-1, '用户名至少3个字符'); } goto jnMJW; YlR_u: if ($FZUh3['code']) { return $FZUh3; } goto gDGJR; c2tIy: $FZUh3 = self::uniqueCheck('username', $c_Qdc); goto YlR_u; jnMJW: if (Str::contains($c_Qdc, '@')) { return Response::generate(-1, '用户名不能包含特殊字符'); } goto bPAHP; bPAHP: if (preg_match('/^[0-9]{11}$/', $c_Qdc)) { return Response::generate(-1, '用户名不能为纯数字'); } goto jiW2P; jiW2P: } else { $c_Qdc = null; } goto ajizd; BroCk: if (!($PcW1B || $jU6y9 || $c_Qdc)) { return Response::generate(-1, '所有注册字段均为空'); } goto vzd1z; oFd0V: } public static function uniqueCheck($mhShF, $qTz8C, $w1cUT = 0) { goto TEpUv; CP6fC: if (empty($CRCLA)) { return Response::generate(0, 'ok'); } goto eAG0I; mxwKB: if ($w1cUT == $CRCLA['id']) { return Response::generate(0, 'ok'); } goto QL3vU; nljKP: $CRCLA = ModelUtil::get('member_user', array($mhShF => $qTz8C)); goto CP6fC; QL3vU: return Response::generate(-2, $epv5W[$mhShF] . '已经被占用'); goto qOjea; X5Fzj: switch ($mhShF) { case 'email': if (!FormatUtil::isEmail($qTz8C)) { return Response::generate(-1, '邮箱格式不正确'); } break; case 'phone': if (!preg_match('/(^1[0-9]{10}$)/', $qTz8C)) { return Response::generate(-1, '手机格式不正确'); } break; case 'username': if (strpos($qTz8C, '@') !== false) { return Response::generate(-1, '用户名格式不正确'); } break; case 'nickname': break; default: return Response::generate(-1, '未能识别的类型' . $mhShF); } goto nljKP; TEpUv: $qTz8C = trim($qTz8C); goto X5Fzj; eAG0I: $epv5W = array('username' => '用户名', 'email' => '邮箱', 'phone' => '手机号'); goto mxwKB; qOjea: } public static function getByUsername($c_Qdc) { return ModelUtil::get('member_user', array('username' => $c_Qdc)); } public static function getByEmail($PcW1B) { return ModelUtil::get('member_user', array('email' => $PcW1B)); } public static function getByPhone($jU6y9) { return ModelUtil::get('member_user', array('phone' => $jU6y9)); } public static function changeNickname($tJ6XI, $qWNT8) { goto RwFNZ; ZeBVF: return Response::generate(0, 'ok'); goto KU07N; u_Dz_: ModelUtil::update('member_user', $tJ6XI, array('nickname' => $qWNT8)); goto ZeBVF; RwFNZ: $FZUh3 = self::uniqueCheck('nickname', $qWNT8, $tJ6XI); goto f0Yht; f0Yht: if (Response::isError($FZUh3)) { return $FZUh3; } goto u_Dz_; KU07N: } public static function changePassword($tJ6XI, $FIQRS, $SQlm1 = null, $TUnbn = false) { goto CPfCb; rrqrU: if (empty($CRCLA)) { return Response::generate(-1, '用户不存在'); } goto m7REF; NoTWN: $FZUh3 = self::passwordStrengthCheck($FIQRS); goto QSsMx; ucyNQ: ModelUtil::update('member_user', array('id' => $CRCLA['id']), array('passwordSalt' => $Hp0Da, 'password' => EncodeUtil::md5WithSalt($FIQRS, $Hp0Da))); goto ZlQb2; CPfCb: if (!$TUnbn && empty($SQlm1)) { return Response::generate(-1, '旧密码不能为空'); } goto XHw3P; QSsMx: if (Response::isError($FZUh3)) { return Response::generate(-1, $FZUh3['msg']); } goto mMJLx; m7REF: if (empty($FIQRS)) { return Response::generate(-1, '新密码为空'); } goto NoTWN; mMJLx: if (!$TUnbn && EncodeUtil::md5WithSalt($SQlm1, $CRCLA['passwordSalt']) != $CRCLA['password']) { return Response::generate(-1, '旧密码不正确'); } goto atiNf; atiNf: $Hp0Da = Str::random(16); goto ucyNQ; ZlQb2: return Response::generate(0, 'ok'); goto xOz1x; XHw3P: $CRCLA = ModelUtil::get('member_user', array('id' => $tJ6XI)); goto rrqrU; xOz1x: } public static function setAvatar($qzstR, $qIh7b, $Q80sf = 'jpg') { goto EPIz3; tJIRn: $iaQ0M = DataManager::upload('image', 'U' . $qzstR . '_AvatarMiddle.' . $Q80sf, $vhAMt, null, $FdhVI); goto r_WGu; B32z1: $oR9zy = (string) Image::make($qIh7b)->resize(50, 50)->encode($Q80sf, 75); goto EupKe; c0Unj: if ($FZUh3['code']) { goto IM0i5; TSSGU: if ($crC1d['code']) { return Response::generate(-1, '头像存储失败（' . $FZUh3['msg'] . '）'); } goto tIoJ6; RRHDf: DataManager::deleteById($iaQ0M['data']['id']); goto TSSGU; IM0i5: DataManager::deleteById($crC1d['data']['id']); goto RRHDf; tIoJ6: } goto lxXOB; bD6gW: $SRni3 = (string) Image::make($qIh7b)->resize(400, 400)->encode($Q80sf, 75); goto HJTHy; HJTHy: $vhAMt = (string) Image::make($qIh7b)->resize(200, 200)->encode($Q80sf, 75); goto B32z1; r_WGu: if ($iaQ0M['code']) { DataManager::deleteById($crC1d['data']['id']); if ($crC1d['code']) { return Response::generate(-1, '头像存储失败（' . $iaQ0M['msg'] . '）'); } } goto lKePQ; EPIz3: if (!in_array($Q80sf, array('jpg', 'jpeg', 'png', 'gif'))) { return Response::generate(-1, '图片格式不正确'); } goto WyDpk; eZ5Ri: if (empty($CRCLA)) { return Response::generate(-1, '用户不存在'); } goto ZRNdz; t5Ysm: $crC1d = DataManager::upload('image', 'U' . $qzstR . '_AvatarBig.' . $Q80sf, $SRni3, null, $FdhVI); goto aA0RK; lKePQ: $FZUh3 = DataManager::upload('image', 'U_' . $qzstR . '_Avatar.' . $Q80sf, $oR9zy, null, $FdhVI); goto c0Unj; aA0RK: if ($crC1d['code']) { return Response::generate(-1, '头像存储失败（' . $crC1d['msg'] . '）'); } goto tJIRn; R4bJ4: return Response::generateSuccess(); goto qwxqn; ZRNdz: if (empty($qIh7b)) { return Response::generate(-1, '图片数据为空'); } goto bD6gW; EupKe: $FdhVI = array('eventOpt' => array(DataFileUploadedEvent::OPT_IMAGE_COMPRESS_IGNORE => true, DataFileUploadedEvent::OPT_IMAGE_WATERMARK_IGNORE => true)); goto t5Ysm; lxXOB: self::update($CRCLA['id'], array('avatarBig' => $crC1d['data']['fullPath'], 'avatarMedium' => $iaQ0M['data']['fullPath'], 'avatar' => $FZUh3['data']['fullPath'])); goto R4bJ4; WyDpk: $CRCLA = self::get($qzstR); goto eZ5Ri; qwxqn: } public static function findUsers($swc4I) { goto F0ajs; zXuvf: foreach ($u1dS8 as &$Gvkn_) { $rWUI6[$Gvkn_->id] = $Gvkn_->toArray(); } goto TBCCB; PKgZT: $rWUI6 = array(); goto NK_yl; F0ajs: if (empty($swc4I)) { return array(); } goto PKgZT; TBCCB: return $rWUI6; goto rvTmX; NK_yl: $u1dS8 = ModelUtil::model('member_user')->whereIn('id', $swc4I)->get(); goto zXuvf; rvTmX: } public static function filterUserIds($swc4I) { goto lDVkD; vjSAt: $VQao2 = array(); goto R9BDw; kkk76: foreach ($u1dS8 as &$Gvkn_) { $VQao2[$Gvkn_->id] = true; } goto emc1L; R9BDw: $u1dS8 = ModelUtil::model('member_user')->whereIn('id', $swc4I)->get(array('id')); goto kkk76; emc1L: return array_keys($VQao2); goto IcLM6; lDVkD: if (empty($swc4I)) { return array(); } goto vjSAt; IcLM6: } public static function mergeMemberUsers(&$EnI2D, $K15Tl = 'memberUserId', $eE0JN = '_memberUser') { ModelUtil::join($EnI2D, $K15Tl, $eE0JN, 'member_user', 'id'); } public static function mergeMemberUserBasics(&$EnI2D, $K15Tl = 'memberUserId', $eE0JN = '_memberUser', $U6J0q = null) { $U6J0q = self::processBasicFields($U6J0q); if (is_array($EnI2D)) { ModelUtil::join($EnI2D, $K15Tl, $eE0JN, 'member_user', 'id'); foreach ($EnI2D as $U8G_W => $gghxW) { goto emZnQ; Y_lqf: $CRCLA = ArrayUtil::keepKeys($gghxW[$eE0JN], $U6J0q); goto kuthk; TG0KE: if (empty($CRCLA['avatar'])) { $CRCLA['avatar'] = AssetsUtil::fixFull('asset/image/avatar.svg'); } else { $CRCLA['avatar'] = AssetsUtil::fixFull($CRCLA['avatar']); } goto SZe7O; kuthk: if (empty($CRCLA['nickname'])) { $CRCLA['nickname'] = $CRCLA['username']; } goto TG0KE; SZe7O: $EnI2D[$U8G_W][$eE0JN] = $CRCLA; goto pFmhT; emZnQ: if (empty($gghxW[$eE0JN])) { continue; } goto Y_lqf; pFmhT: } } else { ModelUtil::joinItems($EnI2D, $K15Tl, $eE0JN, 'member_user', 'id'); foreach ($EnI2D as $AVLNU) { goto t6XFz; t6XFz: if (empty($AVLNU->{$eE0JN})) { continue; } goto oyoTR; FbA1N: if (empty($CRCLA['nickname'])) { $CRCLA['nickname'] = $CRCLA['username']; } goto hOW5D; hOW5D: if (empty($CRCLA['avatar'])) { $CRCLA['avatar'] = AssetsUtil::fixFull('asset/image/avatar.svg'); } else { $CRCLA['avatar'] = AssetsUtil::fixFull($CRCLA['avatar']); } goto FCNXS; FCNXS: $AVLNU->{$eE0JN} = $CRCLA; goto XGWRV; oyoTR: $CRCLA = ArrayUtil::keepKeys($AVLNU->{$eE0JN}, $U6J0q); goto FbA1N; XGWRV: } } } public static function insert($XWlC_) { return ModelUtil::insert('member_user', $XWlC_); } public static function getIdByOauth($rDRQ3, $CVjjl) { goto h_SgZ; h_SgZ: $E1j2M = ModelUtil::get('member_oauth', array('type' => $rDRQ3, 'openId' => $CVjjl)); goto SWxgi; kzsNJ: return intval($E1j2M['memberUserId']); goto DCpO4; SWxgi: if (empty($E1j2M)) { return 0; } goto kzsNJ; DCpO4: } public static function getIdByOauthAndCheck($rDRQ3, $CVjjl) { goto LNb6b; v9imk: return 0; goto NWeyw; wcACi: MemberUtil::forgetOauth($rDRQ3, $CVjjl); goto v9imk; LNb6b: $tJ6XI = self::getIdByOauth($rDRQ3, $CVjjl); goto S24iW; S24iW: if (self::get($tJ6XI)) { return $tJ6XI; } goto wcACi; NWeyw: } public static function getOauthOpenId($tJ6XI, $rDRQ3) { goto FWiEU; JQEUr: if (empty($E1j2M)) { return null; } goto RNdXK; FWiEU: $VSP7l = array('memberUserId' => $tJ6XI, 'type' => $rDRQ3); goto lcb2u; lcb2u: $E1j2M = ModelUtil::get('member_oauth', $VSP7l); goto JQEUr; RNdXK: return $E1j2M['openId']; goto RlwQw; RlwQw: } public static function getOauth($tJ6XI, $rDRQ3) { $VSP7l = array('memberUserId' => $tJ6XI, 'type' => $rDRQ3); return ModelUtil::get('member_oauth', $VSP7l); } public static function listOauths($tJ6XI) { return ModelUtil::all('member_oauth', array('memberUserId' => $tJ6XI), array('*'), array('type', 'asc')); } public static function putOauth($tJ6XI, $rDRQ3, $CVjjl, $hEapL = array()) { goto RpoWg; RpoWg: $VSP7l = array('memberUserId' => $tJ6XI, 'type' => $rDRQ3); goto PwUzs; ohCgY: $E1j2M = ModelUtil::get('member_oauth', $VSP7l); goto JuHRJ; PwUzs: $oF8UZ = "MemberOauth:{$tJ6XI}"; goto jEgJp; OdHaK: LockUtil::release($oF8UZ); goto Vpl6W; JuHRJ: $Bj5vh = array_merge(array('openId' => $CVjjl), $hEapL); goto yv1oH; yv1oH: if (empty($E1j2M)) { ModelUtil::delete('member_oauth', array('type' => $rDRQ3, 'openId' => $CVjjl)); ModelUtil::insert('member_oauth', array_merge($VSP7l, $Bj5vh)); } else { if ($E1j2M['openId'] != $CVjjl) { ModelUtil::update('member_oauth', $E1j2M['id'], $Bj5vh); } } goto OdHaK; jEgJp: if (!LockUtil::acquire($oF8UZ)) { BizException::throws('正在处理中，请稍后再试'); } goto ohCgY; Vpl6W: } public static function forgetOauth($rDRQ3, $CVjjl) { ModelUtil::delete('member_oauth', array('type' => $rDRQ3, 'openId' => $CVjjl)); } public static function updateNewMessageStatus($tJ6XI) { ModelUtil::update('member_user', array('id' => $tJ6XI), array('newMessageCount' => ModelUtil::count('member_message', array('userId' => $tJ6XI, 'status' => MemberMessageStatus::UNREAD)))); } public static function updateNewChatMsgStatus($tJ6XI) { if (modstart_module_enabled('MemberChat')) { ModelUtil::update('member_user', array('id' => $tJ6XI), array('newChatMsgCount' => ModelUtil::sum('member_chat', 'unreadMsgCount', array('memberUserId' => $tJ6XI)))); } } public static function paginate($ZkvUG, $PP9UF, $cD48i = array()) { return ModelUtil::paginate('member_user', $ZkvUG, $PP9UF, $cD48i); } public static function updateStatus($ZHQJQ, $jpbC0) { goto c57L2; c57L2: if (!is_array($ZHQJQ)) { $ZHQJQ = array($ZHQJQ); } goto Kug1I; Kug1I: if (empty($ZHQJQ)) { return; } goto vF42o; vF42o: ModelUtil::model('member_user')->whereIn('id', $ZHQJQ)->update(array('status' => $jpbC0)); goto vjIVN; vjIVN: } public static function delete($tJ6XI) { goto codTI; IfBT3: ModelUtil::update('member_user', $tJ6XI, array('deleteAtTime' => 0, 'isDeleted' => true, 'username' => null, 'phone' => null, 'email' => null)); goto MA8YE; codTI: $CRCLA = self::get($tJ6XI); goto mqMpo; aXhM8: ModelUtil::transactionBegin(); goto zieg9; Un109: ModelUtil::insert('member_deleted', array('id' => $CRCLA['id'], 'username' => $CRCLA['username'], 'phone' => $CRCLA['phone'], 'email' => $CRCLA['email'], 'content' => SerializeUtil::jsonEncode($n3GvS))); goto IfBT3; MA8YE: ModelUtil::transactionCommit(); goto IVDRe; zieg9: $n3GvS = array(); goto QuEon; mqMpo: BizException::throwsIfEmpty('用户不存在', $CRCLA); goto aXhM8; QuEon: $dyxY9 = ModelUtil::all('member_oauth', array('memberUserId' => $CRCLA['id'])); goto iqPxk; iqPxk: $n3GvS['oauth'] = ArrayUtil::keepItemsKeys($dyxY9, array('type', 'openId', 'infoUsername', 'infoAvatar')); goto Un109; IVDRe: } public static function fireLogin($tJ6XI) { goto Hue0f; cWMrR: ModelUtil::insert('member_login_log', array('memberUserId' => $tJ6XI, 'deviceType' => DeviceType::current(), 'ip' => StrUtil::mbLimit($Vzm8o, 20), 'userAgent' => StrUtil::mbLimit(AgentUtil::getUserAgent(), 400))); goto GvFf3; VuCoe: ModelUtil::update('member_user', $tJ6XI, array('lastLoginTime' => Carbon::now(), 'lastLoginIp' => StrUtil::mbLimit($Vzm8o, 20))); goto cWMrR; Hue0f: $Vzm8o = Request::ip(); goto VuCoe; GvFf3: } public static function passwordStrengthCheck($ESrAL) { goto PgsIs; wu_02: switch ($KbyUa) { case MemberPasswordStrength::NO_LIMIT: break; case MemberPasswordStrength::STRENGTH_2: if (StrUtil::passwordStrength($ESrAL) < 2) { return Response::generateError('密码必须包含 大写/小写/数字/特殊字符 2种以上'); } break; case MemberPasswordStrength::STRENGTH_3: if (StrUtil::passwordStrength($ESrAL) < 3) { return Response::generateError('密码必须包含 大写/小写/数字/特殊字符 3种以上'); } break; } goto ps_Tu; PgsIs: $n_mCY = modstart_config('Member_PasswordLengthMin', 0); goto ZPydK; LEp4v: $KbyUa = modstart_config('Member_PasswordStrength', MemberPasswordStrength::NO_LIMIT); goto wu_02; ps_Tu: return Response::generateSuccess(); goto h273Z; ZPydK: if ($n_mCY > 0) { if (strlen($ESrAL) < $n_mCY) { return Response::generateError('密码长度不能小于' . $n_mCY . '位'); } } goto LEp4v; h273Z: } }