<?php
/**
 * ------------------------ 
 *  版权所有  www.tecmz.com
 *  商业版本请购买正版授权使用
 * ------------------------
*/ namespace Module\Member\Admin\Controller; use Illuminate\Routing\Controller; use ModStart\Admin\Auth\AdminPermission; use ModStart\Admin\Concern\HasAdminQuickCRUD; use ModStart\Admin\Layout\AdminConfigBuilder; use ModStart\Admin\Layout\AdminCRUDBuilder; use ModStart\Admin\Layout\AdminDialogPage; use ModStart\Core\Assets\AssetsUtil; use ModStart\Core\Dao\ModelUtil; use ModStart\Core\Exception\BizException; use ModStart\Core\Input\InputPackage; use ModStart\Core\Input\Request; use ModStart\Core\Input\Response; use ModStart\Core\Type\TypeUtil; use ModStart\Core\Util\ArrayUtil; use ModStart\Core\Util\ColorUtil; use ModStart\Core\Util\CRUDUtil; use ModStart\Core\Util\EventUtil; use ModStart\Core\Util\RandomUtil; use ModStart\Core\Util\TimeUtil; use ModStart\Field\AbstractField; use ModStart\Field\AutoRenderedFieldValue; use ModStart\Field\Select; use ModStart\Field\Type\FieldRenderMode; use ModStart\Form\Form; use ModStart\Grid\Displayer\ItemOperate; use ModStart\Grid\GridFilter; use ModStart\Module\ModuleManager; use ModStart\Repository\Filter\RepositoryFilter; use ModStart\Support\Concern\HasFields; use ModStart\Widget\TextDialogRequest; use Module\Member\Config\MemberAdminList; use Module\Member\Config\MemberOauth; use Module\Member\Events\MemberUserRegisteredEvent; use Module\Member\Events\MemberUserVipChangeEvent; use Module\Member\Provider\MemberAdminShowPanel\MemberAdminShowPanelProvider; use Module\Member\Type\Gender; use Module\Member\Type\MemberStatus; use Module\Member\Util\MemberGroupUtil; use Module\Member\Util\MemberMessageUtil; use Module\Member\Util\MemberUtil; use Module\Member\Util\MemberVipUtil; use Module\Vendor\QuickRun\Export\ExportHandle; class MemberController extends Controller { use HasAdminQuickCRUD; protected function crud(AdminCRUDBuilder $U2qv4) { $U2qv4->init('member_user')->field(function ($U2qv4) { $U2qv4->id('id', 'ID'); MemberAdminList::callGridField($U2qv4); $U2qv4->display('avatar', '头像')->hookRendering(function (AbstractField $E9h4W, $AVLNU, $oPu4k) { $pvqFh = AssetsUtil::fixOrDefault($AVLNU->avatar, 'asset/image/avatar.svg'); $zbxMQ = AssetsUtil::fixOrDefault($AVLNU->avatarBig, 'asset/image/avatar.svg'); return AutoRenderedFieldValue::make("<a href='{$zbxMQ}' class='tw-inline-block' data-image-preview>\n                        <img src='{$pvqFh}' class='tw-rounded-full tw-w-8 tw-h-8 tw-shadow'></a>"); }); $U2qv4->text('username', '用户名')->required()->ruleUnique('member_user')->hookRendering(function (AbstractField $E9h4W, $AVLNU, $oPu4k) { switch ($E9h4W->renderMode()) { case FieldRenderMode::GRID: case FieldRenderMode::DETAIL: return AutoRenderedFieldValue::make(TextDialogRequest::make('primary', htmlspecialchars($AVLNU->username), modstart_admin_url('member/show', array('_id' => $AVLNU->id)))->width('90%')->height('90%')->render()); break; } }); $U2qv4->text('email', '邮箱'); $U2qv4->text('phone', '手机'); $U2qv4->text('nickname', '昵称'); if (MemberOauth::hasEnableItems()) { $U2qv4->display('_oauth', '授权')->hookRendering(function (AbstractField $E9h4W, $AVLNU, $oPu4k) { $UQe2c = array(); $MunpS = MemberUtil::listOauths($AVLNU->id); foreach ($MunpS as $dX73N) { goto ica1p; TbZnq: $UQe2c[] = '<a style="color:' . $BxQ34 . ';" href="javascript:;" data-tip-popover="' . $xy3eh . '"><i class="iconfont icon-dot"></i></a>'; goto huyIS; BBG_l: $xy3eh = $dX73N['type']; goto Y5n5c; Y5n5c: $TZ7L5 = MemberOauth::getByOauthKey($dX73N['type']); goto P3_9G; dzKRh: if (empty($BxQ34)) { $BxQ34 = ColorUtil::pick($dX73N['type']); } goto TbZnq; P3_9G: if ($TZ7L5) { $BxQ34 = $TZ7L5->color(); $xy3eh = $TZ7L5->title(); } goto dzKRh; ica1p: $BxQ34 = null; goto BBG_l; huyIS: } return join('', $UQe2c); }); } $U2qv4->type('status', '状态')->type(MemberStatus::class, array(MemberStatus::NORMAL => 'success', MemberStatus::FORBIDDEN => 'danger'))->required(); $o1TC6 = ModuleManager::getModuleConfig('Member', 'groupEnable', false); if ($o1TC6) { $U2qv4->radio('groupId', '分组')->options(MemberGroupUtil::mapIdTitle())->required(); } $G2ZSf = ModuleManager::getModuleConfig('Member', 'vipEnable', false); if ($G2ZSf) { $U2qv4->radio('vipId', 'VIP')->options(MemberVipUtil::mapTitle())->required(); $U2qv4->date('vipExpire', 'VIP过期'); } $U2qv4->display('registerIp', '注册IP'); $U2qv4->display('created_at', '注册时间'); $U2qv4->canBatchSelect(true); $U2qv4->batchOperatePrepend('<button class="btn" data-batch-confirm="确认禁用 %d 个用户？" data-batch-operate="' . modstart_admin_url('member/status_forbidden') . '"><i class="iconfont icon-warning"></i> 禁用</button>'); })->repositoryFilter(function (RepositoryFilter $RryBq) { $RryBq->where(array('isDeleted' => false)); })->gridFilter(function (GridFilter $RryBq) { $RryBq->eq('id', L('ID')); $RryBq->like('username', '用户名'); $RryBq->like('email', '邮箱')->autoHide(true); $RryBq->like('phone', '手机')->autoHide(true); $RryBq->eq('status', '状态')->autoHide(true)->select(MemberStatus::class); if (ModuleManager::getModuleConfig('Member', 'groupEnable', false)) { $RryBq->eq('groupId', '分组')->autoHide(true)->select(MemberGroupUtil::mapIdTitle()); } if (ModuleManager::getModuleConfig('Member', 'vipEnable', false)) { $RryBq->eq('vipId', 'VIP')->autoHide(true)->select(MemberVipUtil::mapTitle()); } })->operateFixed('right')->hookItemOperateRendering(function (ItemOperate $nq5BI) { $AVLNU = $nq5BI->item(); $nq5BI->prepend(TextDialogRequest::make('primary', '查看', modstart_admin_url('member/show', array('_id' => $AVLNU->id)))->width('90%')->height('90%')->render()); })->title('用户管理')->canShow(false)->canDelete(true)->canEdit(false)->canExport(ModuleManager::getModuleConfig('Member', 'exportEnable', false)); } public function selectRemote() { return Select::optionRemoteHandleModel('member_user', 'id', 'username'); } public function add(AdminDialogPage $ZkvUG) { goto YD1U9; gEEld: return $ZkvUG->pageTitle('创建用户')->body($yAhCR)->handleForm($yAhCR, function (Form $yAhCR) { AdminPermission::demoCheck(); $XWlC_ = $yAhCR->dataForming(); $c_Qdc = !empty($XWlC_['username']) ? $XWlC_['username'] : null; $jU6y9 = !empty($XWlC_['phone']) ? $XWlC_['phone'] : null; $PcW1B = !empty($XWlC_['email']) ? $XWlC_['email'] : null; $eVg8O = ArrayUtil::keepKeys($XWlC_, array('nickname', 'groupId', 'status', 'vipId', 'vipExpire')); $FZUh3 = MemberUtil::register($c_Qdc, $jU6y9, $PcW1B, $XWlC_['password']); BizException::throwsIfResponseError($FZUh3); if (!empty($eVg8O)) { if (isset($eVg8O['vipExpire']) && TimeUtil::isDateEmpty($eVg8O['vipExpire'])) { $eVg8O['vipExpire'] = null; } MemberUtil::update($FZUh3['data']['id'], $eVg8O); } EventUtil::fire(new MemberUserRegisteredEvent($FZUh3['data']['id'])); return Response::redirect(CRUDUtil::jsDialogCloseAndParentGridRefresh()); }); goto dSxJs; objGb: $yAhCR->layoutPanel('基础（用户、手机、邮箱不能同时为空）', function (Form $yAhCR) { $yAhCR->text('username', '用户名'); $yAhCR->text('phone', '手机'); $yAhCR->text('email', '邮箱'); $yAhCR->text('password', '初始密码')->defaultValue(RandomUtil::lowerString(8)); }); goto SPPnt; SPPnt: $yAhCR->layoutPanel('高级', function (Form $yAhCR) { $yAhCR->text('nickname', '昵称'); $yAhCR->radio('status', '状态')->optionType(MemberStatus::class)->defaultValue(MemberStatus::NORMAL); if (ModuleManager::getModuleConfig('Member', 'groupEnable', false)) { $yAhCR->radio('groupId', '分组')->options(MemberGroupUtil::mapIdTitle())->required(); } if (ModuleManager::getModuleConfig('Member', 'vipEnable', false)) { $yAhCR->radio('vipId', 'VIP')->options(MemberVipUtil::mapTitle())->required(); $yAhCR->date('vipExpire', 'VIP过期'); } }); goto GZ8sw; YD1U9: $yAhCR = Form::make(''); goto objGb; GZ8sw: $yAhCR->showSubmit(false)->showReset(false); goto gEEld; dSxJs: } public function edit(AdminDialogPage $ZkvUG) { goto S7cwc; MjHgk: BizException::throwsIfEmpty('用户不存在', $CRCLA); goto XvvRO; bGdDp: $yAhCR->layoutPanel('基础', function (Form $yAhCR) { $yAhCR->display('id', '用户ID')->addable(true); $yAhCR->text('username', '用户名'); $yAhCR->text('phone', '手机'); $yAhCR->text('email', '邮箱'); }); goto W7tRF; S7cwc: $CRCLA = ModelUtil::get('member_user', CRUDUtil::id()); goto MjHgk; D6Jf7: $yAhCR->showSubmit(false)->showReset(false); goto xWuhc; xWuhc: return $ZkvUG->pageTitle('修改信息')->body($yAhCR)->handleForm($yAhCR, function (Form $yAhCR) use($CRCLA) { AdminPermission::demoCheck(); $XWlC_ = $yAhCR->dataForming(); $K_e5a = ArrayUtil::keepKeys($XWlC_, array('username', 'phone', 'email')); $eVg8O = ArrayUtil::keepKeys($XWlC_, array('nickname', 'groupId', 'status', 'vipId', 'vipExpire')); $FZUh3 = MemberUtil::updateBasicWithUniqueCheck($CRCLA['id'], $K_e5a); BizException::throwsIfResponseError($FZUh3); if (isset($eVg8O['vipExpire']) && TimeUtil::isDateEmpty($eVg8O['vipExpire'])) { $eVg8O['vipExpire'] = null; } if ($CRCLA['vipId'] != $eVg8O['vipId']) { MemberUserVipChangeEvent::fire($CRCLA['id'], $CRCLA['vipId'], $eVg8O['vipId']); } MemberUtil::update($CRCLA['id'], $eVg8O); return Response::redirect(CRUDUtil::jsDialogCloseAndParentRefresh()); }); goto X9ubc; QzxW0: $yAhCR = Form::make(''); goto bGdDp; Q0Ma2: $yAhCR->item($CRCLA)->fillFields(); goto D6Jf7; W7tRF: $yAhCR->layoutPanel('高级', function (Form $yAhCR) { $yAhCR->text('nickname', '昵称'); $yAhCR->radio('status', '状态')->optionType(MemberStatus::class)->defaultValue(MemberStatus::NORMAL); if (ModuleManager::getModuleConfig('Member', 'groupEnable', false)) { $yAhCR->radio('groupId', '分组')->options(MemberGroupUtil::mapIdTitle())->required(); } if (ModuleManager::getModuleConfig('Member', 'vipEnable', false)) { $yAhCR->radio('vipId', 'VIP')->options(MemberVipUtil::mapTitle())->required(); $yAhCR->date('vipExpire', 'VIP过期')->help('VIP过期留空表示永久'); } }); goto Q0Ma2; XvvRO: if (Request::isPost()) { goto CHxtY; onb08: $ErQts = InputPackage::buildFromInput(); goto zOvzI; CHxtY: AdminPermission::demoCheck(); goto onb08; zOvzI: switch ($ErQts->getTrimString('_action')) { case 'itemCellEdit': goto F9Uez; dm3pw: if (!empty($Bj5vh)) { MemberUtil::update($CRCLA['id'], $Bj5vh); } goto yHhIz; yHhIz: return Response::generateSuccess(); goto Qem2G; W78dC: switch ($ErQts->getTrimString('column')) { case 'status': $Bj5vh['status'] = $ErQts->getInteger('value'); break; } goto dm3pw; F9Uez: $Bj5vh = array(); goto W78dC; Qem2G: } goto QCL8J; QCL8J: } goto QzxW0; X9ubc: } public function select(AdminDialogPage $ZkvUG) { goto bNx9v; VhyB4: return $ZkvUG->pageTitle('选择用户')->body($qCqqU); goto agLZq; yrNYr: if (Request::isPost()) { return $qCqqU->request(); } goto VhyB4; bNx9v: $qCqqU = $this->grid(); goto ao3oQ; nXBmz: $qCqqU->canSingleSelectItem(true); goto HJPau; ao3oQ: $qCqqU->disableCUD(); goto nXBmz; HJPau: CRUDUtil::registerGridResource($qCqqU, '\\' . __CLASS__); goto yrNYr; agLZq: } public function search() { goto kWldu; JvdK_: $cD48i = array(); goto sHT5m; sHT5m: $cD48i['whereOperate'] = array('username', 'like', "%{$M9EmV}%"); goto nLrpi; kWldu: $ErQts = InputPackage::buildFromInput(); goto TiSmM; HaIpK: $EnI2D = array_map(function ($AVLNU) { return array('value' => intval($AVLNU['id']), 'name' => htmlspecialchars(MemberUtil::viewName($AVLNU)), 'avatar' => AssetsUtil::fixOrDefault($AVLNU['avatar'], 'asset/image/avatar.svg')); }, $NmpUA['records']); goto FDpRs; TiSmM: $M9EmV = $ErQts->getTrimString('keywords'); goto JvdK_; nLrpi: $NmpUA = MemberUtil::paginate(1, 10, $cD48i); goto HaIpK; FDpRs: return Response::jsonSuccessData($EnI2D); goto SQDkj; SQDkj: } public function resetPassword(AdminConfigBuilder $U2qv4) { goto EskMF; dhPVG: $U2qv4->text('passwordNew', '新密码')->required()->defaultValue(RandomUtil::upperString(6)); goto IBLrB; Xqeku: return $U2qv4; goto YAMP2; EskMF: $vWdBd = CRUDUtil::id(); goto Pw4CV; IBLrB: if (Request::isPost()) { return $U2qv4->formRequest(function (Form $yAhCR) use($CRCLA) { AdminPermission::demoCheck(); $XWlC_ = $yAhCR->dataForming(); $FZUh3 = MemberUtil::changePassword($CRCLA['id'], $XWlC_['passwordNew'], null, true); BizException::throwsIfResponseError($FZUh3); return Response::redirect(CRUDUtil::jsDialogClose()); }); } goto Xqeku; DRtHI: $U2qv4->pageTitle('重置密码'); goto dhPVG; IYrXN: BizException::throwsIfEmpty('用户不存在', $CRCLA); goto u2F2P; u2F2P: $U2qv4->useDialog(); goto DRtHI; Pw4CV: $CRCLA = MemberUtil::get($vWdBd); goto IYrXN; YAMP2: } public function sendMessage(AdminConfigBuilder $U2qv4) { goto dJe4k; AvXuy: BizException::throwsIfEmpty('用户不存在', $CRCLA); goto G5Ypl; FwKSU: $CRCLA = MemberUtil::get($vWdBd); goto AvXuy; dJe4k: $vWdBd = CRUDUtil::id(); goto FwKSU; DYUxK: return $U2qv4; goto TQvwZ; HQ68l: $U2qv4->pageTitle('发送消息'); goto FSYPN; zgJuu: if (Request::isPost()) { return $U2qv4->formRequest(function (Form $yAhCR) use($CRCLA) { AdminPermission::demoCheck(); $XWlC_ = $yAhCR->dataForming(); $FZUh3 = MemberMessageUtil::send($CRCLA['id'], $XWlC_['content']); BizException::throwsIfResponseError($FZUh3); return Response::redirect(CRUDUtil::jsDialogClose()); }); } goto DYUxK; G5Ypl: $U2qv4->useDialog(); goto HQ68l; FSYPN: $U2qv4->richHtml('content', '消息内容')->required(); goto zgJuu; TQvwZ: } public function show() { goto HdK4p; sqPtH: return view('module::Member.View.admin.memberUser.show', array('record' => $He0J8, 'showPanelProviders' => $wFXSV)); goto ul3L5; HdK4p: $He0J8 = MemberUtil::get(CRUDUtil::id()); goto xeYrQ; xeYrQ: $wFXSV = MemberAdminShowPanelProvider::listAll(); goto sqPtH; ul3L5: } public function delete() { goto N0ZXA; N0ZXA: AdminPermission::demoCheck(); goto uQg1k; uQg1k: MemberUtil::delete(CRUDUtil::id()); goto X_e6z; X_e6z: return Response::redirect(CRUDUtil::jsGridRefresh()); goto C62zu; C62zu: } public function statusForbidden() { goto Rxe2g; Mbigy: MemberUtil::updateStatus(CRUDUtil::ids(), MemberStatus::FORBIDDEN); goto yuj_w; yuj_w: return Response::redirect(CRUDUtil::jsGridRefresh()); goto Cu281; Rxe2g: AdminPermission::demoCheck(); goto Mbigy; Cu281: } public function export(ExportHandle $SvWKk) { $tExQ8 = array('ID', '用户名', '邮箱', '手机', '注册时间', '性别', '姓名', '签名'); return $SvWKk->withPageTitle('导出用户信息')->withDefaultExportName('用户信息')->withHeadTitles($tExQ8)->handleFetch(function ($ZkvUG, $PP9UF, $YBEmG, $uZEpM) { $MpFg6 = ModelUtil::model('member_user'); $MpFg6 = $MpFg6->where(array('isDeleted' => false))->orderBy('id', 'desc'); foreach ($YBEmG as $LccNr) { if (!empty($LccNr['id']['eq'])) { $MpFg6 = $MpFg6->where('id', $LccNr['id']['eq']); } elseif (!empty($LccNr['status']['eq'])) { $MpFg6 = $MpFg6->where('status', $LccNr['status']['eq']); } elseif (!empty($LccNr['groupId']['eq'])) { $MpFg6 = $MpFg6->where('groupId', $LccNr['groupId']['eq']); } elseif (!empty($LccNr['vipId']['eq'])) { $MpFg6 = $MpFg6->where('vipId', $LccNr['vipId']['eq']); } elseif (!empty($LccNr['username']['like'])) { $MpFg6 = $MpFg6->where('username', 'like', '%' . $LccNr['username']['like'] . '%'); } elseif (!empty($LccNr['email']['like'])) { $MpFg6 = $MpFg6->where('email', 'like', '%' . $LccNr['email']['like'] . '%'); } elseif (!empty($LccNr['phone']['like'])) { $MpFg6 = $MpFg6->where('phone', 'like', '%' . $LccNr['phone']['like'] . '%'); } } $FEjaa = $MpFg6->paginate($PP9UF, array('*'), 'page', $ZkvUG)->toArray(); $ZqYpj = array(); foreach ($FEjaa['data'] as $AVLNU) { goto jmSvY; Kz27C: $Fay2L[] = $AVLNU['phone']; goto XP9mo; jmSvY: $Fay2L = array(); goto WKnP8; Lx59A: $Fay2L[] = $AVLNU['username']; goto TH78d; TH78d: $Fay2L[] = $AVLNU['email']; goto Kz27C; wqXdt: $Fay2L[] = TypeUtil::name(Gender::class, $AVLNU['gender']); goto aHV9P; Ke0d7: $ZqYpj[] = $Fay2L; goto KANxO; XP9mo: $Fay2L[] = $AVLNU['created_at']; goto wqXdt; WKnP8: $Fay2L[] = $AVLNU['id']; goto Lx59A; aHV9P: $Fay2L[] = $AVLNU['realname']; goto Xd8zp; Xd8zp: $Fay2L[] = $AVLNU['signature']; goto Ke0d7; KANxO: } return array('list' => $ZqYpj, 'total' => $FEjaa['total']); })->performCommon(); } }